// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('flureenjs');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.auth');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.flake');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.operations');
goog.require('fluree.db.permissions');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.graphql_parser');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.sparql_parser');
goog.require('fluree.db.query.sql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.nodejs');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.api_js');
goog.require('cljs.js');
goog.require('cljs.analyzer');
goog.require('cljs.env');
goog.require('cljs.compiler');
cljs.nodejs.enable_util_print_BANG_.call(null);
flureenjs._init_state = (function flureenjs$_init_state(state){
return cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"rename-macros","rename-macros",1076432512),new cljs.core.Keyword(null,"renames","renames",343278368),new cljs.core.Keyword(null,"use-macros","use-macros",-905638393),new cljs.core.Keyword(null,"excludes","excludes",-1791725945),new cljs.core.Keyword(null,"macros","macros",811339431),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"imports","imports",-1249933394),new cljs.core.Keyword(null,"requires","requires",-1201390927),new cljs.core.Keyword("cljs.spec","speced-vars","cljs.spec/speced-vars",1010010387),new cljs.core.Keyword(null,"uses","uses",232664692),new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.Keyword("cljs.spec","registry-ref","cljs.spec/registry-ref",-71711915),new cljs.core.Keyword(null,"require-macros","require-macros",707947416),new cljs.core.Keyword("cljs.analyzer","constants","cljs.analyzer/constants",1697083770),new cljs.core.Keyword(null,"doc","doc",1913296891)],[cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 34, [new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"null",new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"null",new cljs.core.Symbol(null,"subs","subs",1453849536,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"dec","dec",-766002333,null),"null",new cljs.core.Symbol(null,"<","<",993667236,null),"null",new cljs.core.Symbol(null,"<=","<=",1244895369,null),"null",new cljs.core.Symbol(null,"*","*",345799209,null),"null",new cljs.core.Symbol(null,"min","min",2085523049,null),"null",new cljs.core.Symbol(null,"get","get",-971253014,null),"null",new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"null",new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"null",new cljs.core.Symbol(null,"not=","not=",1466536204,null),"null",new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"null",new cljs.core.Symbol(null,">",">",1085014381,null),"null",new cljs.core.Symbol(null,"mod","mod",1510044207,null),"null",new cljs.core.Symbol(null,"-","-",-471816912,null),"null",new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"null",new cljs.core.Symbol(null,"or","or",1876275696,null),"null",new cljs.core.Symbol(null,"rem","rem",664046770,null),"null",new cljs.core.Symbol(null,"nth","nth",1529209554,null),"null",new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"null",new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"null",new cljs.core.Symbol(null,"not","not",1044554643,null),"null",new cljs.core.Symbol(null,"/","/",-1371932971,null),"null",new cljs.core.Symbol(null,">=",">=",1016916022,null),"null",new cljs.core.Symbol(null,"inc","inc",324505433,null),"null",new cljs.core.Symbol(null,"+","+",-740910886,null),"null",new cljs.core.Symbol(null,"str","str",-1564826950,null),"null",new cljs.core.Symbol(null,"max","max",1701898075,null),"null",new cljs.core.Symbol(null,"==","==",-234118149,null),"null",new cljs.core.Symbol(null,"count","count",-514511684,null),"null",new cljs.core.Symbol(null,"and","and",668631710,null),"null",new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"null"], null), null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block.",new cljs.core.Keyword(null,"line","line",212345235),14,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null)], null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"log","log",45015523,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fdb","fdb",-1644172664,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"util","util",1147903249,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)],[new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.with_meta(new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Finds the maximum predicate value.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(30)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"query","query",352022017,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Executes a query",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Fuel required for query"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the flakes from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerce to boolean. Everything except false and nil is true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Decrements any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the floor of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?o","?o",-1814741084,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the object of an predicate from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(1)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objF","objF",-104129083,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all false flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the ceiling of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"add-stack","add-stack",1221952039,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns product of all the numbers in the sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in *"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets min value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get","get",-971253014,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets a value from an subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the most recent object of an predicate, as of the previous block",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if empty or #{nil}, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Quot[ient] of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"now","now",-9994004,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns current epoch milliseconds on the executing machine.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if two (or more) values are not equal.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"raise","raise",1824672588,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates test.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Modulus of num and div. Truncates toward negative infinity.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string lower case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns difference of all the numbers in the sequence with the first number as the minuend.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in -"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a hash-set of values",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of items in hash-set"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if any in the sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in or"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether an email is valid, based on its pattern",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"coerce-args","coerce-args",494321873,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?s","?s",456183954,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remainder of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nth","nth",1529209554,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the nth item in a collection",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in collection"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if nil, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cas","cas",1188988307,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Does a compare and set/swap operation as a transaction function.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(20)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Execute a re-find operation of regex pattern on provided string.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a boolean, true returns false, false returns true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string upper-case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Increments any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns sum of each argument.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in +"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenates all in sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objT","objT",1212205659,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all true flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets max value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if arguments in sequence equal each other.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in count"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Follows an subject down the provided path and returns a set of all matching subjects.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + length of path"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?p","?p",-10896580,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate predicates",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"stack","stack",847125597,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current auth _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current user _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether there is a relationship between two subjects",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if all in a sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in and"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,779,null,779,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,779,null,new cljs.core.Symbol(null,"any","any",-948528346,null),779,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,7,522,null,522,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),null,cljs.core.list(null,null),1,false,522,null,new cljs.core.Symbol(null,"any","any",-948528346,null),522,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,7,348,null,348,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns true if key is present.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,348,null,new cljs.core.Symbol(null,"any","any",-948528346,null),348,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns true if key is present.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,135,null,135,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,135,null,new cljs.core.Symbol(null,"any","any",-948528346,null),135,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,480,null,480,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),"Executes a query","Fuel required for query"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),null,6,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),480,null,480,6,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query","Fuel required for query"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,7,751,null,751,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,751,null,new cljs.core.Symbol(null,"any","any",-948528346,null),751,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,660,null,660,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),1,false,660,null,new cljs.core.Symbol(null,"any","any",-948528346,null),660,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,546,null,546,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,546,null,new cljs.core.Symbol(null,"any","any",-948528346,null),546,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,402,null,402,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),402,null,new cljs.core.Symbol(null,"any","any",-948528346,null),402,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,7,801,null,801,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,801,null,new cljs.core.Symbol(null,"any","any",-948528346,null),801,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,7,290,null,290,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,290,null,new cljs.core.Symbol(null,"any","any",-948528346,null),290,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,171,null,171,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,171,null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),171,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,739,null,739,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,739,null,new cljs.core.Symbol(null,"any","any",-948528346,null),739,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,789,null,789,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,789,null,new cljs.core.Symbol(null,"any","any",-948528346,null),789,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),41,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),41,new cljs.core.Keyword(null,"end-column","end-column",1425389514),17,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","add-stack","fluree.db.dbfunctions.fns/add-stack",-218303854,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null)),null,cljs.core.list(null,null),1,false,41,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),41,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),"Adds an entry to the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,415,null,415,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),415,null,new cljs.core.Symbol(null,"any","any",-948528346,null),415,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,595,null,595,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),595,null,new cljs.core.Symbol(null,"any","any",-948528346,null),595,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,467,null,467,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets min value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),467,null,new cljs.core.Symbol(null,"any","any",-948528346,null),467,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,272,null,272,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),null,cljs.core.list(null,null),1,false,272,null,new cljs.core.Symbol(null,"any","any",-948528346,null),272,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,302,null,302,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,302,null,new cljs.core.Symbol(null,"any","any",-948528346,null),302,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,7,111,null,111,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,111,null,new cljs.core.Symbol(null,"any","any",-948528346,null),111,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,621,null,621,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,621,null,new cljs.core.Symbol(null,"any","any",-948528346,null),621,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,559,null,559,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,559,null,new cljs.core.Symbol(null,"any","any",-948528346,null),559,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,441,null,441,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),441,null,new cljs.core.Symbol(null,"any","any",-948528346,null),441,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),52,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),52,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","raise","fluree.db.dbfunctions.fns/raise",-2030365545,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null)),null,cljs.core.list(null,null),1,false,52,new cljs.core.Symbol(null,"ignore","ignore",8989494,null),52,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),"Throws an exception with the provided message."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,75,null,75,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),null,cljs.core.list(null,null),1,false,75,null,new cljs.core.Symbol(null,"any","any",-948528346,null),75,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,763,null,763,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),null,3,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),763,null,763,3,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,389,null,389,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),389,null,new cljs.core.Symbol(null,"any","any",-948528346,null),389,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,634,null,634,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,634,null,new cljs.core.Symbol(null,"any","any",-948528346,null),634,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,7,147,null,147,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,147,null,new cljs.core.Symbol(null,"any","any",-948528346,null),147,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,582,null,582,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),582,null,new cljs.core.Symbol(null,"any","any",-948528346,null),582,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,362,null,362,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns a hash-set of values","9 + count of items in hash-set"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),362,null,new cljs.core.Symbol(null,"any","any",-948528346,null),362,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values","9 + count of items in hash-set"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,245,null,245,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),245,null,new cljs.core.Symbol(null,"any","any",-948528346,null),245,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,7,685,null,685,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),null,cljs.core.list(null,null),1,false,685,null,new cljs.core.Symbol(null,"any","any",-948528346,null),685,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),22,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),22,new cljs.core.Keyword(null,"end-column","end-column",1425389514),19,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","coerce-args","fluree.db.dbfunctions.fns/coerce-args",1196396954,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,22,new cljs.core.Symbol(null,"any","any",-948528346,null),22,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,203,null,203,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),203,null,203,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,647,null,647,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,647,null,new cljs.core.Symbol(null,"any","any",-948528346,null),647,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,60,null,60,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,60,null,new cljs.core.Symbol(null,"any","any",-948528346,null),60,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,88,null,88,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,88,null,new cljs.core.Symbol(null,"any","any",-948528346,null),88,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,813,null,813,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),null,cljs.core.list(null,null),1,false,813,null,new cljs.core.Symbol(null,"any","any",-948528346,null),813,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,672,null,672,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),null,cljs.core.list(null,null),1,false,672,null,new cljs.core.Symbol(null,"any","any",-948528346,null),672,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,100,null,100,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,100,null,new cljs.core.Symbol(null,"any","any",-948528346,null),100,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword(null,"file","file",-1269645878),null], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),608,null,new cljs.core.Symbol(null,"any","any",-948528346,null),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence","9 + count of numbers in /"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,428,null,428,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),428,null,new cljs.core.Symbol(null,"any","any",-948528346,null),428,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,7,159,null,159,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,159,null,new cljs.core.Symbol(null,"any","any",-948528346,null),159,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,534,null,534,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,534,null,new cljs.core.Symbol(null,"any","any",-948528346,null),534,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,569,null,569,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns sum of each argument.","9 + count of numbers in +"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),569,null,new cljs.core.Symbol(null,"any","any",-948528346,null),569,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.","9 + count of numbers in +"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,123,null,123,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Concatenates all in sequence.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),123,null,new cljs.core.Symbol(null,"any","any",-948528346,null),123,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,727,null,727,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,727,null,new cljs.core.Symbol(null,"any","any",-948528346,null),727,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,454,null,454,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets max value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),454,null,new cljs.core.Symbol(null,"any","any",-948528346,null),454,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,376,null,376,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),376,null,new cljs.core.Symbol(null,"any","any",-948528346,null),376,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,7,258,null,258,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),1,false,258,null,new cljs.core.Symbol(null,"any","any",-948528346,null),258,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,315,null,315,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Follows an subject down the provided path and returns a set of all matching subjects.","9 + length of path"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,315,null,new cljs.core.Symbol(null,"any","any",-948528346,null),315,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Follows an subject down the provided path and returns a set of all matching subjects.","9 + length of path"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,216,null,216,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),216,null,216,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),35,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),35,new cljs.core.Keyword(null,"end-column","end-column",1425389514),12,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","stack","fluree.db.dbfunctions.fns/stack",-729322264,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,35,new cljs.core.Symbol(null,"any","any",-948528346,null),35,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,7,715,null,715,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,715,null,new cljs.core.Symbol(null,"any","any",-948528346,null),715,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),14,new cljs.core.Keyword(null,"column","column",2078222095),11,new cljs.core.Keyword(null,"end-line","end-line",1837326455),14,new cljs.core.Keyword(null,"end-column","end-column",1425389514),18,new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",18,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&form","&form",1482799337,null),new cljs.core.Symbol(null,"&env","&env",-919163083,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),1,false,14,true,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),"null",new cljs.core.Symbol("cljs.core","IList","cljs.core/IList",1015168964,null),"null"], null), null),14,3,false,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"Resolves a value if a channel.\n  Must be used inside of a go-block."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,7,697,null,697,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,697,null,new cljs.core.Symbol(null,"any","any",-948528346,null),697,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,7,507,null,507,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),null,cljs.core.list(null,null),1,false,507,null,new cljs.core.Symbol(null,"any","any",-948528346,null),507,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,232,null,232,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),232,null,new cljs.core.Symbol(null,"any","any",-948528346,null),232,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,190,null,190,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,190,null,new cljs.core.Symbol(null,"any","any",-948528346,null),190,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,7,334,null,334,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Returns the value of a nested structure","Length of path"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,334,null,new cljs.core.Symbol(null,"any","any",-948528346,null),334,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Returns the value of a nested structure","Length of path"])]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"seen","seen",-518999789),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 25, [new cljs.core.Keyword(null,"_id","_id",-789960287),"null",new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),"null",new cljs.core.Keyword(null,"o","o",-1350007228),"null",new cljs.core.Keyword(null,"spent","spent",-62769180),"null",new cljs.core.Keyword(null,"instant","instant",655498374),"null",new cljs.core.Keyword(null,"else","else",-1508377146),"null",new cljs.core.Keyword(null,"db","db",993250759),"null",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"null",new cljs.core.Keyword(null,"recur","recur",-437573268),"null",new cljs.core.Keyword(null,"state","state",-1988618099),"null",new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),"null",new cljs.core.Symbol(null,"if","if",1181717262,null),"null",new cljs.core.Keyword(null,"s","s",1705939918),"null",new cljs.core.Keyword(null,"function","function",-2127255473),"null",new cljs.core.Keyword(null,"pid","pid",1018387698),"null",new cljs.core.Keyword(null,"status","status",-1997798413),"null",new cljs.core.Keyword(null,"result","result",1415092211),"null",new cljs.core.Keyword(null,"credits","credits",785860820),"null",new cljs.core.Keyword(null,"stack","stack",-793405930),"null",new cljs.core.Keyword(null,"user_id","user_id",993497112),"null",new cljs.core.Keyword(null,"error","error",-978969032),"null",new cljs.core.Keyword(null,"flakes","flakes",1977895739),"null",new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),"null",new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),"null",new cljs.core.Keyword(null,"sid","sid",1815016414),"null"], null), null),new cljs.core.Keyword(null,"order","order",-1254677256),new cljs.core.PersistentVector(null, 25, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),new cljs.core.Keyword(null,"recur","recur",-437573268),new cljs.core.Keyword(null,"else","else",-1508377146),new cljs.core.Keyword(null,"stack","stack",-793405930),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"credits","credits",785860820),new cljs.core.Keyword(null,"spent","spent",-62769180),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"o","o",-1350007228),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"user_id","user_id",993497112),new cljs.core.Keyword(null,"flakes","flakes",1977895739)], null)], null),null]));
});
flureenjs._ns_state = cljs.js.empty_state.call(null,flureenjs._init_state);
var st_80210 = flureenjs._ns_state;
(cljs.core._STAR_eval_STAR_ = (function (form){
var result = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"result","result",1415092211),null], null));
var form_str = ((typeof form === 'string')?form:cljs.core.str.cljs$core$IFn$_invoke$arity$1(form));
var name = "rtm";
var opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"eval","eval",-1103567905),cljs.js.js_eval,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.find_ns.call(null,cljs.analyzer._STAR_cljs_ns_STAR_),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"nodejs","nodejs",321212524)], null);
var cb = (function (res){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res))){
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res));
} else {
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(res));
}
});
cljs.js.eval_str.call(null,st_80210,form_str,name,opts,cb);

return new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,result));
}));
if((typeof flureenjs !== 'undefined') && (typeof flureenjs._app_state !== 'undefined')){
} else {
flureenjs._app_state = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"Fluree NodeJs Library",new cljs.core.Keyword(null,"version","version",425292698),"v1.0.0-rc21"], null));
}
cljs.core.println.call(null,new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs._app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs._app_state)));
flureenjs._njs_crypto = (function (){try{return require("crypto");
}catch (e80211){var ex = e80211;
fluree.db.util.log.warn.call(null,["Error: Unable to access Node.js crypto module:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ex)].join(''));

fluree.db.util.log.warn.call(null,"Private key generation is not available.");

return null;
}})();
fluree.db.util.log.set_level_BANG_.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureenjs.setLogging = (function flureenjs$setLogging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var map__80213 = opts_SINGLEQUOTE_;
var map__80213__$1 = cljs.core.__destructure_map.call(null,map__80213);
var level = cljs.core.get.call(null,map__80213__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_.call(null,cljs.core.keyword.call(null,level));
});
goog.exportSymbol('flureenjs.setLogging', flureenjs.setLogging);
/**
 * Returns account id from either a public key or message and signature.
 */
flureenjs.accountId = (function flureenjs$accountId(var_args){
var G__80215 = arguments.length;
switch (G__80215) {
case 1:
return flureenjs.accountId.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureenjs.accountId.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.accountId', flureenjs.accountId);

(flureenjs.accountId.cljs$core$IFn$_invoke$arity$1 = (function (public_key){
return fluree.crypto.account_id_from_public.call(null,public_key);
}));

(flureenjs.accountId.cljs$core$IFn$_invoke$arity$2 = (function (message,signature){
return fluree.crypto.account_id_from_message.call(null,message,signature);
}));

(flureenjs.accountId.cljs$lang$maxFixedArity = 2);

/**
 * Takes an http request and creates an http signature using a private key
 */
flureenjs.httpSignature = (function flureenjs$httpSignature(var_args){
var G__80218 = arguments.length;
switch (G__80218) {
case 4:
return flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.httpSignature', flureenjs.httpSignature);

(flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$4 = (function (req_method,url,request,private_key){
return flureenjs.httpSignature.call(null,req_method,url,request,private_key,null);
}));

(flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$5 = (function (req_method,url,request,private_key,auth){
var request__$1 = cljs.core.js__GT_clj.call(null,request);
return fluree.db.query.http_signatures.sign_request.call(null,req_method,url,request__$1,private_key,auth);
}));

(flureenjs.httpSignature.cljs$lang$maxFixedArity = 5);

/**
 * Returns a public key given a private key.
 */
flureenjs.publicKeyFromPrivate = (function flureenjs$publicKeyFromPrivate(private_key){
return fluree.crypto.pub_key_from_private.call(null,private_key);
});
goog.exportSymbol('flureenjs.publicKeyFromPrivate', flureenjs.publicKeyFromPrivate);
/**
 * Returns a public key from a message and a signature.
 */
flureenjs.publicKey = (function flureenjs$publicKey(message,signature){
return fluree.crypto.pub_key_from_message.call(null,message,signature);
});
goog.exportSymbol('flureenjs.publicKey', flureenjs.publicKey);
/**
 * Generates a private-public key pair using the Node.js
 *   crypto module. The JavaScript code looks like:
 * 
 *   const ecdh = crypto.createECDH('secp256k1');
 *   ecdh.generateKeys()
 *   return { private: ecdh.getPrivateKey('hex'),
 *            public:  ecdh.getPublicKey('hex','compressed')};
 *   
 */
flureenjs._generate_key_pair = (function flureenjs$_generate_key_pair(){
if(cljs.core.truth_(flureenjs._njs_crypto)){
var ecdh = cljs.core.js_invoke.call(null,flureenjs._njs_crypto,"createECDH","secp256k1");
var _ = cljs.core.js_invoke.call(null,ecdh,"generateKeys");
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),cljs.core.js_invoke.call(null,ecdh,"getPrivateKey","hex"),new cljs.core.Keyword(null,"public","public",1566243851),cljs.core.js_invoke.call(null,ecdh,"getPublicKey","hex","compressed")], null);
} else {
throw "Node.js crypto module not accessible";
}
});
/**
 * Generates a new private key, returned in a map along with
 *   the public key and account id. Return keys are :public,
 *   :private, and :id.
 *   
 */
flureenjs.newPrivateKey = (function flureenjs$newPrivateKey(){
try{var kp = flureenjs._generate_key_pair.call(null);
var account = fluree.crypto.account_id_from_private.call(null,new cljs.core.Keyword(null,"private","private",-558947994).cljs$core$IFn$_invoke$arity$1(kp));
return cljs.core.assoc.call(null,kp,new cljs.core.Keyword(null,"id","id",-1388402092),account);
}catch (e80220){var e = e80220;
fluree.db.util.log.error.call(null,["Unable to generate private key. Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e)].join(''));

throw e;
}});
goog.exportSymbol('flureenjs.newPrivateKey', flureenjs.newPrivateKey);
/**
 * Returns a signature for a message given a private key.
 */
flureenjs.sign = (function flureenjs$sign(message,private_key){
return fluree.crypto.sign_message.call(null,message,private_key);
});
goog.exportSymbol('flureenjs.sign', flureenjs.sign);
/**
 * Sets a new default private key for the entire tx-group, network or db level.
 *   This will only succeed if signed by the default private key for the tx-group,
 *   or if setting for a dbid, either the tx-group or network.
 * 
 *   It will overwrite any existing default private key.
 * 
 *   It will respond with true or false.
 * 
 *   Returns promise that eventually contains the results. 
 */
flureenjs.setDefaultKey = (function flureenjs$setDefaultKey(var_args){
var G__80222 = arguments.length;
switch (G__80222) {
case 2:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.setDefaultKey', flureenjs.setDefaultKey);

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$2 = (function (conn,private_key){
return flureenjs.setDefaultKey.call(null,conn,null,null,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$3 = (function (conn,network,private_key){
return flureenjs.setDefaultKey.call(null,conn,network,null,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,private_key){
return flureenjs.setDefaultKey.call(null,conn,network,dbid,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,private_key,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80278){
var state_val_80279 = (state_80278[(1)]);
if((state_val_80279 === (7))){
var inst_80237 = (state_80278[(7)]);
var state_80278__$1 = state_80278;
var statearr_80280_80321 = state_80278__$1;
(statearr_80280_80321[(2)] = inst_80237);

(statearr_80280_80321[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (20))){
var inst_80249 = (state_80278[(8)]);
var inst_80267 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_80249);
var state_80278__$1 = state_80278;
var statearr_80281_80322 = state_80278__$1;
(statearr_80281_80322[(2)] = inst_80267);

(statearr_80281_80322[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (1))){
var state_80278__$1 = state_80278;
var statearr_80282_80323 = state_80278__$1;
(statearr_80282_80323[(2)] = null);

(statearr_80282_80323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (4))){
var inst_80223 = (state_80278[(2)]);
var inst_80224 = fluree.db.util.log.error.call(null,inst_80223);
var inst_80225 = reject.call(null,inst_80223);
var state_80278__$1 = (function (){var statearr_80283 = state_80278;
(statearr_80283[(9)] = inst_80224);

return statearr_80283;
})();
var statearr_80284_80324 = state_80278__$1;
(statearr_80284_80324[(2)] = inst_80225);

(statearr_80284_80324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (15))){
var inst_80255 = (state_80278[(10)]);
var inst_80236 = (state_80278[(11)]);
var inst_80257 = fluree.crypto.sign_message.call(null,inst_80255,inst_80236);
var state_80278__$1 = state_80278;
var statearr_80285_80325 = state_80278__$1;
(statearr_80285_80325[(2)] = inst_80257);

(statearr_80285_80325[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (21))){
var inst_80269 = (state_80278[(2)]);
var state_80278__$1 = state_80278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80278__$1,(18),inst_80269);
} else {
if((state_val_80279 === (13))){
var state_80278__$1 = state_80278;
var statearr_80286_80326 = state_80278__$1;
(statearr_80286_80326[(2)] = null);

(statearr_80286_80326[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (6))){
var inst_80234 = (state_80278[(12)]);
var state_80278__$1 = state_80278;
var statearr_80287_80327 = state_80278__$1;
(statearr_80287_80327[(2)] = inst_80234);

(statearr_80287_80327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (17))){
var inst_80236 = (state_80278[(11)]);
var inst_80260 = (state_80278[(2)]);
var state_80278__$1 = (function (){var statearr_80288 = state_80278;
(statearr_80288[(13)] = inst_80260);

return statearr_80288;
})();
if(cljs.core.truth_(inst_80236)){
var statearr_80289_80328 = state_80278__$1;
(statearr_80289_80328[(1)] = (19));

} else {
var statearr_80290_80329 = state_80278__$1;
(statearr_80290_80329[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (3))){
var inst_80276 = (state_80278[(2)]);
var state_80278__$1 = state_80278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80278__$1,inst_80276);
} else {
if((state_val_80279 === (12))){
var inst_80249 = (state_80278[(8)]);
var inst_80251 = fluree.db.util.core.without_nils.call(null,inst_80249);
var inst_80252 = fluree.db.util.json.stringify.call(null,inst_80251);
var state_80278__$1 = state_80278;
var statearr_80291_80330 = state_80278__$1;
(statearr_80291_80330[(2)] = inst_80252);

(statearr_80291_80330[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (2))){
var inst_80234 = (state_80278[(12)]);
var _ = (function (){var statearr_80292 = state_80278;
(statearr_80292[(4)] = cljs.core.cons.call(null,(5),(state_80278[(4)])));

return statearr_80292;
})();
var inst_80232 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_80233 = cljs.core.__destructure_map.call(null,inst_80232);
var inst_80234__$1 = cljs.core.get.call(null,inst_80233,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_80235 = cljs.core.get.call(null,inst_80233,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_80236 = cljs.core.get.call(null,inst_80233,new cljs.core.Keyword(null,"signing-key","signing-key",1285642632));
var inst_80237 = fluree.db.util.core.current_time_millis.call(null);
var state_80278__$1 = (function (){var statearr_80293 = state_80278;
(statearr_80293[(11)] = inst_80236);

(statearr_80293[(14)] = inst_80235);

(statearr_80293[(7)] = inst_80237);

(statearr_80293[(12)] = inst_80234__$1);

return statearr_80293;
})();
if(cljs.core.truth_(inst_80234__$1)){
var statearr_80294_80331 = state_80278__$1;
(statearr_80294_80331[(1)] = (6));

} else {
var statearr_80295_80332 = state_80278__$1;
(statearr_80295_80332[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (19))){
var inst_80260 = (state_80278[(13)]);
var inst_80255 = (state_80278[(10)]);
var inst_80262 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_80263 = [inst_80255,inst_80260];
var inst_80264 = cljs.core.PersistentHashMap.fromArrays(inst_80262,inst_80263);
var inst_80265 = fluree.db.operations.command_async.call(null,conn,inst_80264);
var state_80278__$1 = state_80278;
var statearr_80296_80333 = state_80278__$1;
(statearr_80296_80333[(2)] = inst_80265);

(statearr_80296_80333[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (11))){
var inst_80236 = (state_80278[(11)]);
var inst_80241 = (state_80278[(15)]);
var inst_80246 = (state_80278[(2)]);
var inst_80247 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"private-key","private-key",426483388),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_80248 = [new cljs.core.Keyword(null,"default-key","default-key",-2094960617),network,dbid,private_key,inst_80241,inst_80246];
var inst_80249 = cljs.core.PersistentHashMap.fromArrays(inst_80247,inst_80248);
var state_80278__$1 = (function (){var statearr_80298 = state_80278;
(statearr_80298[(8)] = inst_80249);

return statearr_80298;
})();
if(cljs.core.truth_(inst_80236)){
var statearr_80299_80334 = state_80278__$1;
(statearr_80299_80334[(1)] = (12));

} else {
var statearr_80300_80335 = state_80278__$1;
(statearr_80300_80335[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (9))){
var inst_80235 = (state_80278[(14)]);
var state_80278__$1 = state_80278;
var statearr_80301_80336 = state_80278__$1;
(statearr_80301_80336[(2)] = inst_80235);

(statearr_80301_80336[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (5))){
var _ = (function (){var statearr_80302 = state_80278;
(statearr_80302[(4)] = cljs.core.rest.call(null,(state_80278[(4)])));

return statearr_80302;
})();
var state_80278__$1 = state_80278;
var ex80297 = (state_80278__$1[(2)]);
var statearr_80303_80337 = state_80278__$1;
(statearr_80303_80337[(5)] = ex80297);


var statearr_80304_80338 = state_80278__$1;
(statearr_80304_80338[(1)] = (4));

(statearr_80304_80338[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (14))){
var inst_80236 = (state_80278[(11)]);
var inst_80255 = (state_80278[(2)]);
var state_80278__$1 = (function (){var statearr_80305 = state_80278;
(statearr_80305[(10)] = inst_80255);

return statearr_80305;
})();
if(cljs.core.truth_(inst_80236)){
var statearr_80306_80339 = state_80278__$1;
(statearr_80306_80339[(1)] = (15));

} else {
var statearr_80307_80340 = state_80278__$1;
(statearr_80307_80340[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (16))){
var state_80278__$1 = state_80278;
var statearr_80308_80341 = state_80278__$1;
(statearr_80308_80341[(2)] = null);

(statearr_80308_80341[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (10))){
var inst_80237 = (state_80278[(7)]);
var inst_80244 = (inst_80237 + (30000));
var state_80278__$1 = state_80278;
var statearr_80309_80342 = state_80278__$1;
(statearr_80309_80342[(2)] = inst_80244);

(statearr_80309_80342[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (18))){
var inst_80271 = (state_80278[(2)]);
var inst_80272 = cljs.core.clj__GT_js.call(null,inst_80271);
var inst_80273 = resolve.call(null,inst_80272);
var _ = (function (){var statearr_80310 = state_80278;
(statearr_80310[(4)] = cljs.core.rest.call(null,(state_80278[(4)])));

return statearr_80310;
})();
var state_80278__$1 = state_80278;
var statearr_80311_80343 = state_80278__$1;
(statearr_80311_80343[(2)] = inst_80273);

(statearr_80311_80343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80279 === (8))){
var inst_80235 = (state_80278[(14)]);
var inst_80241 = (state_80278[(2)]);
var state_80278__$1 = (function (){var statearr_80312 = state_80278;
(statearr_80312[(15)] = inst_80241);

return statearr_80312;
})();
if(cljs.core.truth_(inst_80235)){
var statearr_80313_80344 = state_80278__$1;
(statearr_80313_80344[(1)] = (9));

} else {
var statearr_80314_80345 = state_80278__$1;
(statearr_80314_80345[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_80315 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80315[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_80315[(1)] = (1));

return statearr_80315;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_80278){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80316){var ex__10906__auto__ = e80316;
var statearr_80317_80346 = state_80278;
(statearr_80317_80346[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80278[(4)]))){
var statearr_80318_80347 = state_80278;
(statearr_80318_80347[(1)] = cljs.core.first.call(null,(state_80278[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80348 = state_80278;
state_80278 = G__80348;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_80278){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_80278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80319 = f__10977__auto__.call(null);
(statearr_80319[(6)] = c__10976__auto__);

return statearr_80319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.setDefaultKey.cljs$lang$maxFixedArity = 5);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * Returns a promise that eventually contains the connection object.
 */
flureenjs.connect = (function flureenjs$connect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___80355 = arguments.length;
var i__4865__auto___80356 = (0);
while(true){
if((i__4865__auto___80356 < len__4864__auto___80355)){
args__4870__auto__.push((arguments[i__4865__auto___80356]));

var G__80357 = (i__4865__auto___80356 + (1));
i__4865__auto___80356 = G__80357;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});
goog.exportSymbol('flureenjs.connect', flureenjs.connect);

(flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers_string,p__80351){
var vec__80352 = p__80351;
var opts = cljs.core.nth.call(null,vec__80352,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect_p.call(null,servers_string,clj_opts);
}));

(flureenjs.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(flureenjs.connect.cljs$lang$applyTo = (function (seq80349){
var G__80350 = cljs.core.first.call(null,seq80349);
var seq80349__$1 = cljs.core.next.call(null,seq80349);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__80350,seq80349__$1);
}));

/**
 * Closes a connection
 */
flureenjs.close = (function flureenjs$close(conn){
return fluree.db.connection_js.close.call(null,conn);
});
goog.exportSymbol('flureenjs.close', flureenjs.close);
/**
 * Attempts to generate a new user auth record account.
 * 
 *   Returns a promise that eventually contains the token or an exception.
 */
flureenjs.passwordGenerate = (function flureenjs$passwordGenerate(var_args){
var G__80359 = arguments.length;
switch (G__80359) {
case 4:
return flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.passwordGenerate', flureenjs.passwordGenerate);

(flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureenjs.passwordGenerate.call(null,conn,ledger,password,user,null);
}));

(flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var data = cljs.core.assoc.call(null,cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true),new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate.call(null,conn,ledger,password,data);
}));

(flureenjs.passwordGenerate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 * 
 *   Returns a promise that eventually contains the token or an exception.
 */
flureenjs.passwordLogin = (function flureenjs$passwordLogin(var_args){
var G__80362 = arguments.length;
switch (G__80362) {
case 4:
return flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.passwordLogin', flureenjs.passwordLogin);

(flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user);
}));

(flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,auth,expire);
}));

(flureenjs.passwordLogin.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureenjs.renewToken = (function flureenjs$renewToken(var_args){
var G__80365 = arguments.length;
switch (G__80365) {
case 2:
return flureenjs.renewToken.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.renewToken.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.renewToken', flureenjs.renewToken);

(flureenjs.renewToken.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(flureenjs.renewToken.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,expire);
}));

(flureenjs.renewToken.cljs$lang$maxFixedArity = 3);

/**
 * Takes block event data from (listen...) and adds an :added and
 *   :retracted key containing maps of data organized by subject
 *   and containing full predicate names.
 */
flureenjs.blockEventToMap = (function flureenjs$blockEventToMap(conn,ledger,block_event){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80396){
var state_val_80397 = (state_80396[(1)]);
if((state_val_80397 === (1))){
var state_80396__$1 = state_80396;
var statearr_80398_80413 = state_80396__$1;
(statearr_80398_80413[(2)] = null);

(statearr_80398_80413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80397 === (2))){
var _ = (function (){var statearr_80399 = state_80396;
(statearr_80399[(4)] = cljs.core.cons.call(null,(5),(state_80396[(4)])));

return statearr_80399;
})();
var inst_80377 = flureenjs._db_instance.call(null,conn,ledger);
var state_80396__$1 = state_80396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80396__$1,(6),inst_80377);
} else {
if((state_val_80397 === (3))){
var inst_80394 = (state_80396[(2)]);
var state_80396__$1 = state_80396;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80396__$1,inst_80394);
} else {
if((state_val_80397 === (4))){
var inst_80368 = (state_80396[(2)]);
var inst_80369 = fluree.db.util.log.error.call(null,inst_80368);
var inst_80370 = reject.call(null,inst_80368);
var state_80396__$1 = (function (){var statearr_80401 = state_80396;
(statearr_80401[(7)] = inst_80369);

return statearr_80401;
})();
var statearr_80402_80414 = state_80396__$1;
(statearr_80402_80414[(2)] = inst_80370);

(statearr_80402_80414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80397 === (5))){
var _ = (function (){var statearr_80403 = state_80396;
(statearr_80403[(4)] = cljs.core.rest.call(null,(state_80396[(4)])));

return statearr_80403;
})();
var state_80396__$1 = state_80396;
var ex80400 = (state_80396__$1[(2)]);
var statearr_80404_80415 = state_80396__$1;
(statearr_80404_80415[(5)] = ex80400);


var statearr_80405_80416 = state_80396__$1;
(statearr_80405_80416[(1)] = (4));

(statearr_80405_80416[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80397 === (6))){
var inst_80379 = (state_80396[(2)]);
var inst_80380 = fluree.db.util.async.throw_err.call(null,inst_80379);
var inst_80381 = (function (){var db = inst_80380;
return (function (p1__80367_SHARP_){
return cljs.core.nth.call(null,p1__80367_SHARP_,(4));
});
})();
var inst_80382 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block_event);
var inst_80383 = cljs.core.group_by.call(null,inst_80381,inst_80382);
var inst_80384 = cljs.core.__destructure_map.call(null,inst_80383);
var inst_80385 = cljs.core.get.call(null,inst_80384,true);
var inst_80386 = cljs.core.get.call(null,inst_80384,false);
var inst_80387 = (function (){var db = inst_80380;
var map__80376 = inst_80384;
var add = inst_80385;
var retract = inst_80386;
return (function (flakes){
var by_subj = cljs.core.group_by.call(null,cljs.core.first,flakes);
return cljs.core.reduce_kv.call(null,(function (acc,sid,flakes__$1){
return cljs.core.conj.call(null,acc,cljs.core.reduce.call(null,(function (m,flake){
var p_schema = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"pred","pred",1927423397),cljs.core.second.call(null,flake)], null));
var v = cljs.core.nth.call(null,flake,(2));
if(cljs.core.truth_(new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(p_schema))){
return cljs.core.update.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),cljs.core.conj,v);
} else {
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),v);
}
}),new cljs.core.PersistentArrayMap(null, 1, ["_id",sid], null),flakes__$1));
}),cljs.core.PersistentVector.EMPTY,by_subj);
});
})();
var inst_80388 = inst_80387.call(null,inst_80385);
var inst_80389 = inst_80387.call(null,inst_80386);
var inst_80390 = cljs.core.assoc.call(null,block_event,new cljs.core.Keyword(null,"added","added",2057651688),inst_80388,new cljs.core.Keyword(null,"retracted","retracted",-1399687854),inst_80389);
var inst_80391 = resolve.call(null,inst_80390);
var _ = (function (){var statearr_80406 = state_80396;
(statearr_80406[(4)] = cljs.core.rest.call(null,(state_80396[(4)])));

return statearr_80406;
})();
var state_80396__$1 = state_80396;
var statearr_80407_80417 = state_80396__$1;
(statearr_80407_80417[(2)] = inst_80391);

(statearr_80407_80417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$blockEventToMap_$_state_machine__10903__auto__ = null;
var flureenjs$blockEventToMap_$_state_machine__10903__auto____0 = (function (){
var statearr_80408 = [null,null,null,null,null,null,null,null];
(statearr_80408[(0)] = flureenjs$blockEventToMap_$_state_machine__10903__auto__);

(statearr_80408[(1)] = (1));

return statearr_80408;
});
var flureenjs$blockEventToMap_$_state_machine__10903__auto____1 = (function (state_80396){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80396);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80409){var ex__10906__auto__ = e80409;
var statearr_80410_80418 = state_80396;
(statearr_80410_80418[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80396[(4)]))){
var statearr_80411_80419 = state_80396;
(statearr_80411_80419[(1)] = cljs.core.first.call(null,(state_80396[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80420 = state_80396;
state_80396 = G__80420;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$blockEventToMap_$_state_machine__10903__auto__ = function(state_80396){
switch(arguments.length){
case 0:
return flureenjs$blockEventToMap_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$blockEventToMap_$_state_machine__10903__auto____1.call(this,state_80396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$blockEventToMap_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$blockEventToMap_$_state_machine__10903__auto____0;
flureenjs$blockEventToMap_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$blockEventToMap_$_state_machine__10903__auto____1;
return flureenjs$blockEventToMap_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80412 = f__10977__auto__.call(null);
(statearr_80412[(6)] = c__10976__auto__);

return statearr_80412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureenjs.listen = (function flureenjs$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen.call(null,conn,ledger,key,callback);
});
goog.exportSymbol('flureenjs.listen', flureenjs.listen);
/**
 * Closes a listener.
 */
flureenjs.closeListener = (function flureenjs$closeListener(conn,ledger,key){
return fluree.db.connection_js.close_listener.call(null,conn,ledger,key);
});
goog.exportSymbol('flureenjs.closeListener', flureenjs.closeListener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureenjs.listeners = (function flureenjs$listeners(conn){
return fluree.db.connection_js.listeners.call(null,conn);
});
goog.exportSymbol('flureenjs.listeners', flureenjs.listeners);
/**
 * Returns a queryable database from the connection.
 */
flureenjs._db_instance = (function flureenjs$_db_instance(var_args){
var G__80422 = arguments.length;
switch (G__80422) {
case 2:
return flureenjs._db_instance.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs._db_instance.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs._db_instance.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs._db_instance.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs._db_instance.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__10976__auto___80495 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80468){
var state_val_80469 = (state_80468[(1)]);
if((state_val_80469 === (7))){
var inst_80439 = (state_80468[(7)]);
var state_80468__$1 = state_80468;
if(cljs.core.truth_(inst_80439)){
var statearr_80470_80496 = state_80468__$1;
(statearr_80470_80496[(1)] = (9));

} else {
var statearr_80471_80497 = state_80468__$1;
(statearr_80471_80497[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80469 === (1))){
var state_80468__$1 = state_80468;
var statearr_80472_80498 = state_80468__$1;
(statearr_80472_80498[(2)] = null);

(statearr_80472_80498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80469 === (4))){
var inst_80423 = (state_80468[(2)]);
var inst_80424 = fluree.db.util.log.error.call(null,inst_80423);
var inst_80425 = cljs.core.async.put_BANG_.call(null,pc,inst_80423);
var inst_80426 = cljs.core.async.close_BANG_.call(null,pc);
var state_80468__$1 = (function (){var statearr_80473 = state_80468;
(statearr_80473[(8)] = inst_80424);

(statearr_80473[(9)] = inst_80425);

return statearr_80473;
})();
var statearr_80474_80499 = state_80468__$1;
(statearr_80474_80499[(2)] = inst_80426);

(statearr_80474_80499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80469 === (6))){
var inst_80438 = (state_80468[(10)]);
var state_80468__$1 = state_80468;
var statearr_80475_80500 = state_80468__$1;
(statearr_80475_80500[(2)] = inst_80438);

(statearr_80475_80500[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80469 === (3))){
var inst_80466 = (state_80468[(2)]);
var state_80468__$1 = state_80468;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80468__$1,inst_80466);
} else {
if((state_val_80469 === (12))){
var inst_80443 = (state_80468[(11)]);
var inst_80442 = (state_80468[(12)]);
var inst_80460 = (state_80468[(2)]);
var inst_80461 = fluree.db.util.async.throw_err.call(null,inst_80460);
var inst_80462 = cljs.core.assoc.call(null,inst_80461,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_80442,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_80443);
var inst_80463 = cljs.core.async.put_BANG_.call(null,pc,inst_80462);
var _ = (function (){var statearr_80476 = state_80468;
(statearr_80476[(4)] = cljs.core.rest.call(null,(state_80468[(4)])));

return statearr_80476;
})();
var state_80468__$1 = state_80468;
var statearr_80477_80501 = state_80468__$1;
(statearr_80477_80501[(2)] = inst_80463);

(statearr_80477_80501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80469 === (2))){
var inst_80438 = (state_80468[(10)]);
var _ = (function (){var statearr_80478 = state_80468;
(statearr_80478[(4)] = cljs.core.cons.call(null,(5),(state_80468[(4)])));

return statearr_80478;
})();
var inst_80436 = opts;
var inst_80437 = cljs.core.__destructure_map.call(null,inst_80436);
var inst_80438__$1 = cljs.core.get.call(null,inst_80437,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_80439 = cljs.core.get.call(null,inst_80437,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_80440 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_80441 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_80442 = cljs.core.nth.call(null,inst_80441,(0),null);
var inst_80443 = cljs.core.nth.call(null,inst_80441,(1),null);
var state_80468__$1 = (function (){var statearr_80479 = state_80468;
(statearr_80479[(10)] = inst_80438__$1);

(statearr_80479[(11)] = inst_80443);

(statearr_80479[(12)] = inst_80442);

(statearr_80479[(13)] = inst_80440);

(statearr_80479[(7)] = inst_80439);

return statearr_80479;
})();
if(cljs.core.truth_(inst_80438__$1)){
var statearr_80480_80502 = state_80468__$1;
(statearr_80480_80502[(1)] = (6));

} else {
var statearr_80481_80503 = state_80468__$1;
(statearr_80481_80503[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80469 === (11))){
var inst_80454 = (state_80468[(2)]);
var state_80468__$1 = state_80468;
var statearr_80483_80504 = state_80468__$1;
(statearr_80483_80504[(2)] = inst_80454);

(statearr_80483_80504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80469 === (9))){
var inst_80439 = (state_80468[(7)]);
var inst_80447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80448 = fluree.db.connection_js.validate_token.call(null,conn,inst_80439);
var inst_80449 = new cljs.core.Keyword(null,"sub","sub",-2093760025).cljs$core$IFn$_invoke$arity$1(inst_80448);
var inst_80450 = ["_auth/id",inst_80449];
var inst_80451 = (new cljs.core.PersistentVector(null,2,(5),inst_80447,inst_80450,null));
var state_80468__$1 = state_80468;
var statearr_80484_80505 = state_80468__$1;
(statearr_80484_80505[(2)] = inst_80451);

(statearr_80484_80505[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80469 === (5))){
var _ = (function (){var statearr_80485 = state_80468;
(statearr_80485[(4)] = cljs.core.rest.call(null,(state_80468[(4)])));

return statearr_80485;
})();
var state_80468__$1 = state_80468;
var ex80482 = (state_80468__$1[(2)]);
var statearr_80486_80506 = state_80468__$1;
(statearr_80486_80506[(5)] = ex80482);


var statearr_80487_80507 = state_80468__$1;
(statearr_80487_80507[(1)] = (4));

(statearr_80487_80507[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80469 === (10))){
var state_80468__$1 = state_80468;
var statearr_80488_80508 = state_80468__$1;
(statearr_80488_80508[(2)] = null);

(statearr_80488_80508[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80469 === (8))){
var inst_80456 = (state_80468[(2)]);
var inst_80457 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_80456);
var inst_80458 = fluree.db.api.ledger.db.call(null,conn,ledger,inst_80457);
var state_80468__$1 = state_80468;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80468__$1,(12),inst_80458);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_80489 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80489[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_80489[(1)] = (1));

return statearr_80489;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_80468){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80468);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80490){var ex__10906__auto__ = e80490;
var statearr_80491_80509 = state_80468;
(statearr_80491_80509[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80468[(4)]))){
var statearr_80492_80510 = state_80468;
(statearr_80492_80510[(1)] = cljs.core.first.call(null,(state_80468[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80511 = state_80468;
state_80468 = G__80511;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_80468){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_80468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80493 = f__10977__auto__.call(null);
(statearr_80493[(6)] = c__10976__auto___80495);

return statearr_80493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return pc;
}));

(flureenjs._db_instance.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db = (function flureenjs$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___80551 = arguments.length;
var i__4865__auto___80552 = (0);
while(true){
if((i__4865__auto___80552 < len__4864__auto___80551)){
args__4870__auto__.push((arguments[i__4865__auto___80552]));

var G__80553 = (i__4865__auto___80552 + (1));
i__4865__auto___80552 = G__80553;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return flureenjs.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});
goog.exportSymbol('flureenjs.db', flureenjs.db);

(flureenjs.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__80515){
var vec__80516 = p__80515;
var opts = cljs.core.nth.call(null,vec__80516,(0),null);
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80534){
var state_val_80535 = (state_80534[(1)]);
if((state_val_80535 === (1))){
var state_80534__$1 = state_80534;
var statearr_80536_80554 = state_80534__$1;
(statearr_80536_80554[(2)] = null);

(statearr_80536_80554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (2))){
var _ = (function (){var statearr_80537 = state_80534;
(statearr_80537[(4)] = cljs.core.cons.call(null,(5),(state_80534[(4)])));

return statearr_80537;
})();
var inst_80527 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_80528 = flureenjs._db_instance.call(null,conn,ledger,inst_80527);
var inst_80529 = resolve.call(null,inst_80528);
var ___$1 = (function (){var statearr_80538 = state_80534;
(statearr_80538[(4)] = cljs.core.rest.call(null,(state_80534[(4)])));

return statearr_80538;
})();
var state_80534__$1 = state_80534;
var statearr_80539_80555 = state_80534__$1;
(statearr_80539_80555[(2)] = inst_80529);

(statearr_80539_80555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (3))){
var inst_80532 = (state_80534[(2)]);
var state_80534__$1 = state_80534;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80534__$1,inst_80532);
} else {
if((state_val_80535 === (4))){
var inst_80519 = (state_80534[(2)]);
var inst_80520 = fluree.db.util.log.error.call(null,inst_80519);
var inst_80521 = reject.call(null,inst_80519);
var state_80534__$1 = (function (){var statearr_80541 = state_80534;
(statearr_80541[(7)] = inst_80520);

return statearr_80541;
})();
var statearr_80542_80556 = state_80534__$1;
(statearr_80542_80556[(2)] = inst_80521);

(statearr_80542_80556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (5))){
var _ = (function (){var statearr_80543 = state_80534;
(statearr_80543[(4)] = cljs.core.rest.call(null,(state_80534[(4)])));

return statearr_80543;
})();
var state_80534__$1 = state_80534;
var ex80540 = (state_80534__$1[(2)]);
var statearr_80544_80557 = state_80534__$1;
(statearr_80544_80557[(5)] = ex80540);


var statearr_80545_80558 = state_80534__$1;
(statearr_80545_80558[(1)] = (4));

(statearr_80545_80558[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_80546 = [null,null,null,null,null,null,null,null];
(statearr_80546[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_80546[(1)] = (1));

return statearr_80546;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_80534){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80534);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80547){var ex__10906__auto__ = e80547;
var statearr_80548_80559 = state_80534;
(statearr_80548_80559[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80534[(4)]))){
var statearr_80549_80560 = state_80534;
(statearr_80549_80560[(1)] = cljs.core.first.call(null,(state_80534[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80561 = state_80534;
state_80534 = G__80561;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_80534){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_80534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80550 = f__10977__auto__.call(null);
(statearr_80550[(6)] = c__10976__auto__);

return statearr_80550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db.cljs$lang$applyTo = (function (seq80512){
var G__80513 = cljs.core.first.call(null,seq80512);
var seq80512__$1 = cljs.core.next.call(null,seq80512);
var G__80514 = cljs.core.first.call(null,seq80512__$1);
var seq80512__$2 = cljs.core.next.call(null,seq80512__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__80513,G__80514,seq80512__$2);
}));

/**
 * Returns promise containing collection id given a collection name.
 *   If collection doesn't exist, returns nil.
 */
flureenjs.collectionId = (function flureenjs$collectionId(db,collection){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80581){
var state_val_80582 = (state_80581[(1)]);
if((state_val_80582 === (1))){
var state_80581__$1 = state_80581;
var statearr_80583_80599 = state_80581__$1;
(statearr_80583_80599[(2)] = null);

(statearr_80583_80599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80582 === (2))){
var _ = (function (){var statearr_80584 = state_80581;
(statearr_80584[(4)] = cljs.core.cons.call(null,(5),(state_80581[(4)])));

return statearr_80584;
})();
var inst_80570 = cljs.core.js__GT_clj.call(null,collection,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_80581__$1 = (function (){var statearr_80585 = state_80581;
(statearr_80585[(7)] = inst_80570);

return statearr_80585;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80581__$1,(6),db);
} else {
if((state_val_80582 === (3))){
var inst_80579 = (state_80581[(2)]);
var state_80581__$1 = state_80581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80581__$1,inst_80579);
} else {
if((state_val_80582 === (4))){
var inst_80562 = (state_80581[(2)]);
var inst_80563 = fluree.db.util.log.error.call(null,inst_80562);
var inst_80564 = reject.call(null,inst_80562);
var state_80581__$1 = (function (){var statearr_80587 = state_80581;
(statearr_80587[(8)] = inst_80563);

return statearr_80587;
})();
var statearr_80588_80600 = state_80581__$1;
(statearr_80588_80600[(2)] = inst_80564);

(statearr_80588_80600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80582 === (5))){
var _ = (function (){var statearr_80589 = state_80581;
(statearr_80589[(4)] = cljs.core.rest.call(null,(state_80581[(4)])));

return statearr_80589;
})();
var state_80581__$1 = state_80581;
var ex80586 = (state_80581__$1[(2)]);
var statearr_80590_80601 = state_80581__$1;
(statearr_80590_80601[(5)] = ex80586);


var statearr_80591_80602 = state_80581__$1;
(statearr_80591_80602[(1)] = (4));

(statearr_80591_80602[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80582 === (6))){
var inst_80570 = (state_80581[(7)]);
var inst_80572 = (state_80581[(2)]);
var inst_80573 = fluree.db.util.async.throw_err.call(null,inst_80572);
var inst_80574 = fluree.db.dbproto._c_prop.call(null,inst_80573,new cljs.core.Keyword(null,"id","id",-1388402092),inst_80570);
var inst_80575 = cljs.core.clj__GT_js.call(null,inst_80574);
var inst_80576 = resolve.call(null,inst_80575);
var _ = (function (){var statearr_80592 = state_80581;
(statearr_80592[(4)] = cljs.core.rest.call(null,(state_80581[(4)])));

return statearr_80592;
})();
var state_80581__$1 = state_80581;
var statearr_80593_80603 = state_80581__$1;
(statearr_80593_80603[(2)] = inst_80576);

(statearr_80593_80603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$collectionId_$_state_machine__10903__auto__ = null;
var flureenjs$collectionId_$_state_machine__10903__auto____0 = (function (){
var statearr_80594 = [null,null,null,null,null,null,null,null,null];
(statearr_80594[(0)] = flureenjs$collectionId_$_state_machine__10903__auto__);

(statearr_80594[(1)] = (1));

return statearr_80594;
});
var flureenjs$collectionId_$_state_machine__10903__auto____1 = (function (state_80581){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80595){var ex__10906__auto__ = e80595;
var statearr_80596_80604 = state_80581;
(statearr_80596_80604[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80581[(4)]))){
var statearr_80597_80605 = state_80581;
(statearr_80597_80605[(1)] = cljs.core.first.call(null,(state_80581[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80606 = state_80581;
state_80581 = G__80606;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$collectionId_$_state_machine__10903__auto__ = function(state_80581){
switch(arguments.length){
case 0:
return flureenjs$collectionId_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$collectionId_$_state_machine__10903__auto____1.call(this,state_80581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collectionId_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collectionId_$_state_machine__10903__auto____0;
flureenjs$collectionId_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collectionId_$_state_machine__10903__auto____1;
return flureenjs$collectionId_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80598 = f__10977__auto__.call(null);
(statearr_80598[(6)] = c__10976__auto__);

return statearr_80598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.collectionId', flureenjs.collectionId);
/**
 * Returns promise containing predicate id given a predicate.
 *   If predicate doesn't exist, returns nil.
 */
flureenjs.predicateId = (function flureenjs$predicateId(db,predicate){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80626){
var state_val_80627 = (state_80626[(1)]);
if((state_val_80627 === (1))){
var state_80626__$1 = state_80626;
var statearr_80628_80644 = state_80626__$1;
(statearr_80628_80644[(2)] = null);

(statearr_80628_80644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80627 === (2))){
var _ = (function (){var statearr_80629 = state_80626;
(statearr_80629[(4)] = cljs.core.cons.call(null,(5),(state_80626[(4)])));

return statearr_80629;
})();
var inst_80615 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_80626__$1 = (function (){var statearr_80630 = state_80626;
(statearr_80630[(7)] = inst_80615);

return statearr_80630;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80626__$1,(6),db);
} else {
if((state_val_80627 === (3))){
var inst_80624 = (state_80626[(2)]);
var state_80626__$1 = state_80626;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80626__$1,inst_80624);
} else {
if((state_val_80627 === (4))){
var inst_80607 = (state_80626[(2)]);
var inst_80608 = fluree.db.util.log.error.call(null,inst_80607);
var inst_80609 = reject.call(null,inst_80607);
var state_80626__$1 = (function (){var statearr_80632 = state_80626;
(statearr_80632[(8)] = inst_80608);

return statearr_80632;
})();
var statearr_80633_80645 = state_80626__$1;
(statearr_80633_80645[(2)] = inst_80609);

(statearr_80633_80645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80627 === (5))){
var _ = (function (){var statearr_80634 = state_80626;
(statearr_80634[(4)] = cljs.core.rest.call(null,(state_80626[(4)])));

return statearr_80634;
})();
var state_80626__$1 = state_80626;
var ex80631 = (state_80626__$1[(2)]);
var statearr_80635_80646 = state_80626__$1;
(statearr_80635_80646[(5)] = ex80631);


var statearr_80636_80647 = state_80626__$1;
(statearr_80636_80647[(1)] = (4));

(statearr_80636_80647[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80627 === (6))){
var inst_80615 = (state_80626[(7)]);
var inst_80617 = (state_80626[(2)]);
var inst_80618 = fluree.db.util.async.throw_err.call(null,inst_80617);
var inst_80619 = fluree.db.dbproto._p_prop.call(null,inst_80618,new cljs.core.Keyword(null,"id","id",-1388402092),inst_80615);
var inst_80620 = cljs.core.clj__GT_js.call(null,inst_80619);
var inst_80621 = resolve.call(null,inst_80620);
var _ = (function (){var statearr_80637 = state_80626;
(statearr_80637[(4)] = cljs.core.rest.call(null,(state_80626[(4)])));

return statearr_80637;
})();
var state_80626__$1 = state_80626;
var statearr_80638_80648 = state_80626__$1;
(statearr_80638_80648[(2)] = inst_80621);

(statearr_80638_80648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicateId_$_state_machine__10903__auto__ = null;
var flureenjs$predicateId_$_state_machine__10903__auto____0 = (function (){
var statearr_80639 = [null,null,null,null,null,null,null,null,null];
(statearr_80639[(0)] = flureenjs$predicateId_$_state_machine__10903__auto__);

(statearr_80639[(1)] = (1));

return statearr_80639;
});
var flureenjs$predicateId_$_state_machine__10903__auto____1 = (function (state_80626){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80626);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80640){var ex__10906__auto__ = e80640;
var statearr_80641_80649 = state_80626;
(statearr_80641_80649[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80626[(4)]))){
var statearr_80642_80650 = state_80626;
(statearr_80642_80650[(1)] = cljs.core.first.call(null,(state_80626[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80651 = state_80626;
state_80626 = G__80651;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$predicateId_$_state_machine__10903__auto__ = function(state_80626){
switch(arguments.length){
case 0:
return flureenjs$predicateId_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$predicateId_$_state_machine__10903__auto____1.call(this,state_80626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicateId_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicateId_$_state_machine__10903__auto____0;
flureenjs$predicateId_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicateId_$_state_machine__10903__auto____1;
return flureenjs$predicateId_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80643 = f__10977__auto__.call(null);
(statearr_80643[(6)] = c__10976__auto__);

return statearr_80643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.predicateId', flureenjs.predicateId);
/**
 * Returns promise containing predicate name given a predicate.
 *   If predicate doesn't exist, returns nil.
 */
flureenjs.predicateName = (function flureenjs$predicateName(db,predicate){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80671){
var state_val_80672 = (state_80671[(1)]);
if((state_val_80672 === (1))){
var state_80671__$1 = state_80671;
var statearr_80673_80689 = state_80671__$1;
(statearr_80673_80689[(2)] = null);

(statearr_80673_80689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80672 === (2))){
var _ = (function (){var statearr_80674 = state_80671;
(statearr_80674[(4)] = cljs.core.cons.call(null,(5),(state_80671[(4)])));

return statearr_80674;
})();
var inst_80660 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_80671__$1 = (function (){var statearr_80675 = state_80671;
(statearr_80675[(7)] = inst_80660);

return statearr_80675;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80671__$1,(6),db);
} else {
if((state_val_80672 === (3))){
var inst_80669 = (state_80671[(2)]);
var state_80671__$1 = state_80671;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80671__$1,inst_80669);
} else {
if((state_val_80672 === (4))){
var inst_80652 = (state_80671[(2)]);
var inst_80653 = fluree.db.util.log.error.call(null,inst_80652);
var inst_80654 = reject.call(null,inst_80652);
var state_80671__$1 = (function (){var statearr_80677 = state_80671;
(statearr_80677[(8)] = inst_80653);

return statearr_80677;
})();
var statearr_80678_80690 = state_80671__$1;
(statearr_80678_80690[(2)] = inst_80654);

(statearr_80678_80690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80672 === (5))){
var _ = (function (){var statearr_80679 = state_80671;
(statearr_80679[(4)] = cljs.core.rest.call(null,(state_80671[(4)])));

return statearr_80679;
})();
var state_80671__$1 = state_80671;
var ex80676 = (state_80671__$1[(2)]);
var statearr_80680_80691 = state_80671__$1;
(statearr_80680_80691[(5)] = ex80676);


var statearr_80681_80692 = state_80671__$1;
(statearr_80681_80692[(1)] = (4));

(statearr_80681_80692[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80672 === (6))){
var inst_80660 = (state_80671[(7)]);
var inst_80662 = (state_80671[(2)]);
var inst_80663 = fluree.db.util.async.throw_err.call(null,inst_80662);
var inst_80664 = fluree.db.dbproto._p_prop.call(null,inst_80663,new cljs.core.Keyword(null,"name","name",1843675177),inst_80660);
var inst_80665 = cljs.core.clj__GT_js.call(null,inst_80664);
var inst_80666 = resolve.call(null,inst_80665);
var _ = (function (){var statearr_80682 = state_80671;
(statearr_80682[(4)] = cljs.core.rest.call(null,(state_80671[(4)])));

return statearr_80682;
})();
var state_80671__$1 = state_80671;
var statearr_80683_80693 = state_80671__$1;
(statearr_80683_80693[(2)] = inst_80666);

(statearr_80683_80693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicateName_$_state_machine__10903__auto__ = null;
var flureenjs$predicateName_$_state_machine__10903__auto____0 = (function (){
var statearr_80684 = [null,null,null,null,null,null,null,null,null];
(statearr_80684[(0)] = flureenjs$predicateName_$_state_machine__10903__auto__);

(statearr_80684[(1)] = (1));

return statearr_80684;
});
var flureenjs$predicateName_$_state_machine__10903__auto____1 = (function (state_80671){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80671);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80685){var ex__10906__auto__ = e80685;
var statearr_80686_80694 = state_80671;
(statearr_80686_80694[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80671[(4)]))){
var statearr_80687_80695 = state_80671;
(statearr_80687_80695[(1)] = cljs.core.first.call(null,(state_80671[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80696 = state_80671;
state_80671 = G__80696;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$predicateName_$_state_machine__10903__auto__ = function(state_80671){
switch(arguments.length){
case 0:
return flureenjs$predicateName_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$predicateName_$_state_machine__10903__auto____1.call(this,state_80671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicateName_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicateName_$_state_machine__10903__auto____0;
flureenjs$predicateName_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicateName_$_state_machine__10903__auto____1;
return flureenjs$predicateName_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80688 = f__10977__auto__.call(null);
(statearr_80688[(6)] = c__10976__auto__);

return statearr_80688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.predicateName', flureenjs.predicateName);
/**
 * Returns promise containing subject id given a subject
 *   identity or a subject id.
 *   If subject doesn't exist, returns nil.
 */
flureenjs.subid = (function flureenjs$subid(db,ident){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80719){
var state_val_80720 = (state_80719[(1)]);
if((state_val_80720 === (1))){
var state_80719__$1 = state_80719;
var statearr_80721_80737 = state_80719__$1;
(statearr_80721_80737[(2)] = null);

(statearr_80721_80737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80720 === (2))){
var _ = (function (){var statearr_80722 = state_80719;
(statearr_80722[(4)] = cljs.core.cons.call(null,(5),(state_80719[(4)])));

return statearr_80722;
})();
var inst_80705 = cljs.core.js__GT_clj.call(null,ident,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_80719__$1 = (function (){var statearr_80723 = state_80719;
(statearr_80723[(7)] = inst_80705);

return statearr_80723;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80719__$1,(7),db);
} else {
if((state_val_80720 === (3))){
var inst_80717 = (state_80719[(2)]);
var state_80719__$1 = state_80719;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80719__$1,inst_80717);
} else {
if((state_val_80720 === (4))){
var inst_80697 = (state_80719[(2)]);
var inst_80698 = fluree.db.util.log.error.call(null,inst_80697);
var inst_80699 = reject.call(null,inst_80697);
var state_80719__$1 = (function (){var statearr_80725 = state_80719;
(statearr_80725[(8)] = inst_80698);

return statearr_80725;
})();
var statearr_80726_80738 = state_80719__$1;
(statearr_80726_80738[(2)] = inst_80699);

(statearr_80726_80738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80720 === (5))){
var _ = (function (){var statearr_80727 = state_80719;
(statearr_80727[(4)] = cljs.core.rest.call(null,(state_80719[(4)])));

return statearr_80727;
})();
var state_80719__$1 = state_80719;
var ex80724 = (state_80719__$1[(2)]);
var statearr_80728_80739 = state_80719__$1;
(statearr_80728_80739[(5)] = ex80724);


var statearr_80729_80740 = state_80719__$1;
(statearr_80729_80740[(1)] = (4));

(statearr_80729_80740[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80720 === (6))){
var inst_80711 = (state_80719[(2)]);
var inst_80712 = fluree.db.util.async.throw_err.call(null,inst_80711);
var inst_80713 = cljs.core.clj__GT_js.call(null,inst_80712);
var inst_80714 = resolve.call(null,inst_80713);
var _ = (function (){var statearr_80730 = state_80719;
(statearr_80730[(4)] = cljs.core.rest.call(null,(state_80719[(4)])));

return statearr_80730;
})();
var state_80719__$1 = state_80719;
var statearr_80731_80741 = state_80719__$1;
(statearr_80731_80741[(2)] = inst_80714);

(statearr_80731_80741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80720 === (7))){
var inst_80705 = (state_80719[(7)]);
var inst_80707 = (state_80719[(2)]);
var inst_80708 = fluree.db.util.async.throw_err.call(null,inst_80707);
var inst_80709 = fluree.db.dbproto._subid.call(null,inst_80708,inst_80705,false);
var state_80719__$1 = state_80719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80719__$1,(6),inst_80709);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$subid_$_state_machine__10903__auto__ = null;
var flureenjs$subid_$_state_machine__10903__auto____0 = (function (){
var statearr_80732 = [null,null,null,null,null,null,null,null,null];
(statearr_80732[(0)] = flureenjs$subid_$_state_machine__10903__auto__);

(statearr_80732[(1)] = (1));

return statearr_80732;
});
var flureenjs$subid_$_state_machine__10903__auto____1 = (function (state_80719){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80733){var ex__10906__auto__ = e80733;
var statearr_80734_80742 = state_80719;
(statearr_80734_80742[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80719[(4)]))){
var statearr_80735_80743 = state_80719;
(statearr_80735_80743[(1)] = cljs.core.first.call(null,(state_80719[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80744 = state_80719;
state_80719 = G__80744;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$subid_$_state_machine__10903__auto__ = function(state_80719){
switch(arguments.length){
case 0:
return flureenjs$subid_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$subid_$_state_machine__10903__auto____1.call(this,state_80719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$subid_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$subid_$_state_machine__10903__auto____0;
flureenjs$subid_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$subid_$_state_machine__10903__auto____1;
return flureenjs$subid_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80736 = f__10977__auto__.call(null);
(statearr_80736[(6)] = c__10976__auto__);

return statearr_80736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.subid', flureenjs.subid);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureenjs.deleteLedger = (function flureenjs$deleteLedger(var_args){
var G__80746 = arguments.length;
switch (G__80746) {
case 2:
return flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.deleteLedger', flureenjs.deleteLedger);

(flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.deleteLedger.call(null,conn,ledger,null);
}));

(flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80816){
var state_val_80817 = (state_80816[(1)]);
if((state_val_80817 === (7))){
var inst_80759 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_80816__$1 = state_80816;
var statearr_80818_80863 = state_80816__$1;
(statearr_80818_80863[(2)] = inst_80759);

(statearr_80818_80863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (20))){
var inst_80767 = (state_80816[(7)]);
var inst_80791 = (state_80816[(2)]);
var state_80816__$1 = (function (){var statearr_80819 = state_80816;
(statearr_80819[(8)] = inst_80791);

return statearr_80819;
})();
if(cljs.core.truth_(inst_80767)){
var statearr_80820_80864 = state_80816__$1;
(statearr_80820_80864[(1)] = (21));

} else {
var statearr_80821_80865 = state_80816__$1;
(statearr_80821_80865[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (1))){
var state_80816__$1 = state_80816;
var statearr_80822_80866 = state_80816__$1;
(statearr_80822_80866[(2)] = null);

(statearr_80822_80866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (24))){
var inst_80798 = (state_80816[(2)]);
var inst_80799 = fluree.db.util.async.throw_err.call(null,inst_80798);
var state_80816__$1 = state_80816;
var statearr_80823_80867 = state_80816__$1;
(statearr_80823_80867[(2)] = inst_80799);

(statearr_80823_80867[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (4))){
var inst_80747 = (state_80816[(2)]);
var inst_80748 = fluree.db.util.log.error.call(null,inst_80747);
var inst_80749 = reject.call(null,inst_80747);
var state_80816__$1 = (function (){var statearr_80824 = state_80816;
(statearr_80824[(9)] = inst_80748);

return statearr_80824;
})();
var statearr_80825_80868 = state_80816__$1;
(statearr_80825_80868[(2)] = inst_80749);

(statearr_80825_80868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (15))){
var inst_80780 = (state_80816[(10)]);
var inst_80782 = fluree.db.util.core.without_nils.call(null,inst_80780);
var inst_80783 = fluree.db.util.json.stringify.call(null,inst_80782);
var state_80816__$1 = state_80816;
var statearr_80826_80869 = state_80816__$1;
(statearr_80826_80869[(2)] = inst_80783);

(statearr_80826_80869[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (21))){
var inst_80786 = (state_80816[(11)]);
var inst_80791 = (state_80816[(8)]);
var inst_80793 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_80794 = [inst_80786,inst_80791];
var inst_80795 = cljs.core.PersistentHashMap.fromArrays(inst_80793,inst_80794);
var inst_80796 = fluree.db.operations.command_async.call(null,conn,inst_80795);
var state_80816__$1 = state_80816;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80816__$1,(24),inst_80796);
} else {
if((state_val_80817 === (13))){
var inst_80768 = (state_80816[(12)]);
var inst_80775 = (inst_80768 + (30000));
var state_80816__$1 = state_80816;
var statearr_80827_80870 = state_80816__$1;
(statearr_80827_80870[(2)] = inst_80775);

(statearr_80827_80870[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (22))){
var inst_80780 = (state_80816[(10)]);
var inst_80801 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_80780);
var state_80816__$1 = state_80816;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80816__$1,(25),inst_80801);
} else {
if((state_val_80817 === (6))){
var state_80816__$1 = state_80816;
var statearr_80828_80871 = state_80816__$1;
(statearr_80828_80871[(2)] = null);

(statearr_80828_80871[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (25))){
var inst_80803 = (state_80816[(2)]);
var inst_80804 = fluree.db.util.async.throw_err.call(null,inst_80803);
var state_80816__$1 = state_80816;
var statearr_80829_80872 = state_80816__$1;
(statearr_80829_80872[(2)] = inst_80804);

(statearr_80829_80872[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (17))){
var inst_80767 = (state_80816[(7)]);
var inst_80786 = (state_80816[(2)]);
var state_80816__$1 = (function (){var statearr_80830 = state_80816;
(statearr_80830[(11)] = inst_80786);

return statearr_80830;
})();
if(cljs.core.truth_(inst_80767)){
var statearr_80831_80873 = state_80816__$1;
(statearr_80831_80873[(1)] = (18));

} else {
var statearr_80832_80874 = state_80816__$1;
(statearr_80832_80874[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (3))){
var inst_80814 = (state_80816[(2)]);
var state_80816__$1 = state_80816;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80816__$1,inst_80814);
} else {
if((state_val_80817 === (12))){
var inst_80765 = (state_80816[(13)]);
var state_80816__$1 = state_80816;
var statearr_80833_80875 = state_80816__$1;
(statearr_80833_80875[(2)] = inst_80765);

(statearr_80833_80875[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (2))){
var _ = (function (){var statearr_80834 = state_80816;
(statearr_80834[(4)] = cljs.core.cons.call(null,(5),(state_80816[(4)])));

return statearr_80834;
})();
var inst_80756 = (opts == null);
var state_80816__$1 = state_80816;
if(cljs.core.truth_(inst_80756)){
var statearr_80835_80876 = state_80816__$1;
(statearr_80835_80876[(1)] = (6));

} else {
var statearr_80836_80877 = state_80816__$1;
(statearr_80836_80877[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (23))){
var inst_80806 = (state_80816[(2)]);
var inst_80807 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_80808 = [(200),inst_80806];
var inst_80809 = cljs.core.PersistentHashMap.fromArrays(inst_80807,inst_80808);
var inst_80810 = cljs.core.clj__GT_js.call(null,inst_80809);
var inst_80811 = resolve.call(null,inst_80810);
var _ = (function (){var statearr_80837 = state_80816;
(statearr_80837[(4)] = cljs.core.rest.call(null,(state_80816[(4)])));

return statearr_80837;
})();
var state_80816__$1 = state_80816;
var statearr_80838_80878 = state_80816__$1;
(statearr_80838_80878[(2)] = inst_80811);

(statearr_80838_80878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (19))){
var state_80816__$1 = state_80816;
var statearr_80839_80879 = state_80816__$1;
(statearr_80839_80879[(2)] = null);

(statearr_80839_80879[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (11))){
var inst_80765 = (state_80816[(13)]);
var inst_80772 = (state_80816[(2)]);
var state_80816__$1 = (function (){var statearr_80841 = state_80816;
(statearr_80841[(14)] = inst_80772);

return statearr_80841;
})();
if(cljs.core.truth_(inst_80765)){
var statearr_80842_80880 = state_80816__$1;
(statearr_80842_80880[(1)] = (12));

} else {
var statearr_80843_80881 = state_80816__$1;
(statearr_80843_80881[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (9))){
var inst_80764 = (state_80816[(15)]);
var state_80816__$1 = state_80816;
var statearr_80844_80882 = state_80816__$1;
(statearr_80844_80882[(2)] = inst_80764);

(statearr_80844_80882[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (5))){
var _ = (function (){var statearr_80845 = state_80816;
(statearr_80845[(4)] = cljs.core.rest.call(null,(state_80816[(4)])));

return statearr_80845;
})();
var state_80816__$1 = state_80816;
var ex80840 = (state_80816__$1[(2)]);
var statearr_80846_80883 = state_80816__$1;
(statearr_80846_80883[(5)] = ex80840);


var statearr_80847_80884 = state_80816__$1;
(statearr_80847_80884[(1)] = (4));

(statearr_80847_80884[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (14))){
var inst_80767 = (state_80816[(7)]);
var inst_80772 = (state_80816[(14)]);
var inst_80777 = (state_80816[(2)]);
var inst_80778 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_80779 = [new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),ledger,inst_80772,inst_80777];
var inst_80780 = cljs.core.PersistentHashMap.fromArrays(inst_80778,inst_80779);
var state_80816__$1 = (function (){var statearr_80848 = state_80816;
(statearr_80848[(10)] = inst_80780);

return statearr_80848;
})();
if(cljs.core.truth_(inst_80767)){
var statearr_80849_80885 = state_80816__$1;
(statearr_80849_80885[(1)] = (15));

} else {
var statearr_80850_80886 = state_80816__$1;
(statearr_80850_80886[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (16))){
var state_80816__$1 = state_80816;
var statearr_80851_80887 = state_80816__$1;
(statearr_80851_80887[(2)] = null);

(statearr_80851_80887[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (10))){
var inst_80768 = (state_80816[(12)]);
var state_80816__$1 = state_80816;
var statearr_80852_80888 = state_80816__$1;
(statearr_80852_80888[(2)] = inst_80768);

(statearr_80852_80888[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (18))){
var inst_80767 = (state_80816[(7)]);
var inst_80786 = (state_80816[(11)]);
var inst_80788 = fluree.crypto.sign_message.call(null,inst_80786,inst_80767);
var state_80816__$1 = state_80816;
var statearr_80853_80889 = state_80816__$1;
(statearr_80853_80889[(2)] = inst_80788);

(statearr_80853_80889[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80817 === (8))){
var inst_80764 = (state_80816[(15)]);
var inst_80761 = (state_80816[(2)]);
var inst_80762 = fluree.db.connection_js.check_connection.call(null,conn,inst_80761);
var inst_80763 = cljs.core.__destructure_map.call(null,inst_80761);
var inst_80764__$1 = cljs.core.get.call(null,inst_80763,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_80765 = cljs.core.get.call(null,inst_80763,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_80766 = cljs.core.get.call(null,inst_80763,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_80767 = cljs.core.get.call(null,inst_80763,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_80768 = fluree.db.util.core.current_time_millis.call(null);
var state_80816__$1 = (function (){var statearr_80854 = state_80816;
(statearr_80854[(7)] = inst_80767);

(statearr_80854[(13)] = inst_80765);

(statearr_80854[(15)] = inst_80764__$1);

(statearr_80854[(16)] = inst_80766);

(statearr_80854[(17)] = inst_80762);

(statearr_80854[(12)] = inst_80768);

return statearr_80854;
})();
if(cljs.core.truth_(inst_80764__$1)){
var statearr_80855_80890 = state_80816__$1;
(statearr_80855_80890[(1)] = (9));

} else {
var statearr_80856_80891 = state_80816__$1;
(statearr_80856_80891[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_80857 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80857[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_80857[(1)] = (1));

return statearr_80857;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_80816){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80816);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80858){var ex__10906__auto__ = e80858;
var statearr_80859_80892 = state_80816;
(statearr_80859_80892[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80816[(4)]))){
var statearr_80860_80893 = state_80816;
(statearr_80860_80893[(1)] = cljs.core.first.call(null,(state_80816[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80894 = state_80816;
state_80816 = G__80894;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_80816){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_80816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80861 = f__10977__auto__.call(null);
(statearr_80861[(6)] = c__10976__auto__);

return statearr_80861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.deleteLedger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise with ledger's status as a map, including index, indexes, block, and status.
 *   If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledgerInfo = (function flureenjs$ledgerInfo(conn,ledger){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80913){
var state_val_80914 = (state_80913[(1)]);
if((state_val_80914 === (1))){
var state_80913__$1 = state_80913;
var statearr_80915_80930 = state_80913__$1;
(statearr_80915_80930[(2)] = null);

(statearr_80915_80930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80914 === (2))){
var _ = (function (){var statearr_80916 = state_80913;
(statearr_80916[(4)] = cljs.core.cons.call(null,(5),(state_80913[(4)])));

return statearr_80916;
})();
var inst_80903 = fluree.db.operations.ledger_stats_async.call(null,conn,ledger);
var state_80913__$1 = state_80913;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80913__$1,(6),inst_80903);
} else {
if((state_val_80914 === (3))){
var inst_80911 = (state_80913[(2)]);
var state_80913__$1 = state_80913;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80913__$1,inst_80911);
} else {
if((state_val_80914 === (4))){
var inst_80895 = (state_80913[(2)]);
var inst_80896 = fluree.db.util.log.error.call(null,inst_80895);
var inst_80897 = reject.call(null,inst_80895);
var state_80913__$1 = (function (){var statearr_80918 = state_80913;
(statearr_80918[(7)] = inst_80896);

return statearr_80918;
})();
var statearr_80919_80931 = state_80913__$1;
(statearr_80919_80931[(2)] = inst_80897);

(statearr_80919_80931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80914 === (5))){
var _ = (function (){var statearr_80920 = state_80913;
(statearr_80920[(4)] = cljs.core.rest.call(null,(state_80913[(4)])));

return statearr_80920;
})();
var state_80913__$1 = state_80913;
var ex80917 = (state_80913__$1[(2)]);
var statearr_80921_80932 = state_80913__$1;
(statearr_80921_80932[(5)] = ex80917);


var statearr_80922_80933 = state_80913__$1;
(statearr_80922_80933[(1)] = (4));

(statearr_80922_80933[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80914 === (6))){
var inst_80905 = (state_80913[(2)]);
var inst_80906 = fluree.db.util.async.throw_err.call(null,inst_80905);
var inst_80907 = cljs.core.clj__GT_js.call(null,inst_80906);
var inst_80908 = resolve.call(null,inst_80907);
var _ = (function (){var statearr_80923 = state_80913;
(statearr_80923[(4)] = cljs.core.rest.call(null,(state_80913[(4)])));

return statearr_80923;
})();
var state_80913__$1 = state_80913;
var statearr_80924_80934 = state_80913__$1;
(statearr_80924_80934[(2)] = inst_80908);

(statearr_80924_80934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledgerInfo_$_state_machine__10903__auto__ = null;
var flureenjs$ledgerInfo_$_state_machine__10903__auto____0 = (function (){
var statearr_80925 = [null,null,null,null,null,null,null,null];
(statearr_80925[(0)] = flureenjs$ledgerInfo_$_state_machine__10903__auto__);

(statearr_80925[(1)] = (1));

return statearr_80925;
});
var flureenjs$ledgerInfo_$_state_machine__10903__auto____1 = (function (state_80913){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80913);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80926){var ex__10906__auto__ = e80926;
var statearr_80927_80935 = state_80913;
(statearr_80927_80935[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80913[(4)]))){
var statearr_80928_80936 = state_80913;
(statearr_80928_80936[(1)] = cljs.core.first.call(null,(state_80913[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80937 = state_80913;
state_80913 = G__80937;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$ledgerInfo_$_state_machine__10903__auto__ = function(state_80913){
switch(arguments.length){
case 0:
return flureenjs$ledgerInfo_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$ledgerInfo_$_state_machine__10903__auto____1.call(this,state_80913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledgerInfo_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledgerInfo_$_state_machine__10903__auto____0;
flureenjs$ledgerInfo_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledgerInfo_$_state_machine__10903__auto____1;
return flureenjs$ledgerInfo_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80929 = f__10977__auto__.call(null);
(statearr_80929[(6)] = c__10976__auto__);

return statearr_80929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.ledgerInfo', flureenjs.ledgerInfo);
/**
 * Returns promise with a list of ledgers the connected server is currently serving.
 */
flureenjs.ledgerList = (function flureenjs$ledgerList(conn){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80956){
var state_val_80957 = (state_80956[(1)]);
if((state_val_80957 === (1))){
var state_80956__$1 = state_80956;
var statearr_80958_80973 = state_80956__$1;
(statearr_80958_80973[(2)] = null);

(statearr_80958_80973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80957 === (2))){
var _ = (function (){var statearr_80959 = state_80956;
(statearr_80959[(4)] = cljs.core.cons.call(null,(5),(state_80956[(4)])));

return statearr_80959;
})();
var inst_80946 = fluree.db.operations.ledgers_async.call(null,conn);
var state_80956__$1 = state_80956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80956__$1,(6),inst_80946);
} else {
if((state_val_80957 === (3))){
var inst_80954 = (state_80956[(2)]);
var state_80956__$1 = state_80956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80956__$1,inst_80954);
} else {
if((state_val_80957 === (4))){
var inst_80938 = (state_80956[(2)]);
var inst_80939 = fluree.db.util.log.error.call(null,inst_80938);
var inst_80940 = reject.call(null,inst_80938);
var state_80956__$1 = (function (){var statearr_80961 = state_80956;
(statearr_80961[(7)] = inst_80939);

return statearr_80961;
})();
var statearr_80962_80974 = state_80956__$1;
(statearr_80962_80974[(2)] = inst_80940);

(statearr_80962_80974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80957 === (5))){
var _ = (function (){var statearr_80963 = state_80956;
(statearr_80963[(4)] = cljs.core.rest.call(null,(state_80956[(4)])));

return statearr_80963;
})();
var state_80956__$1 = state_80956;
var ex80960 = (state_80956__$1[(2)]);
var statearr_80964_80975 = state_80956__$1;
(statearr_80964_80975[(5)] = ex80960);


var statearr_80965_80976 = state_80956__$1;
(statearr_80965_80976[(1)] = (4));

(statearr_80965_80976[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80957 === (6))){
var inst_80948 = (state_80956[(2)]);
var inst_80949 = fluree.db.util.async.throw_err.call(null,inst_80948);
var inst_80950 = cljs.core.clj__GT_js.call(null,inst_80949);
var inst_80951 = resolve.call(null,inst_80950);
var _ = (function (){var statearr_80966 = state_80956;
(statearr_80966[(4)] = cljs.core.rest.call(null,(state_80956[(4)])));

return statearr_80966;
})();
var state_80956__$1 = state_80956;
var statearr_80967_80977 = state_80956__$1;
(statearr_80967_80977[(2)] = inst_80951);

(statearr_80967_80977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledgerList_$_state_machine__10903__auto__ = null;
var flureenjs$ledgerList_$_state_machine__10903__auto____0 = (function (){
var statearr_80968 = [null,null,null,null,null,null,null,null];
(statearr_80968[(0)] = flureenjs$ledgerList_$_state_machine__10903__auto__);

(statearr_80968[(1)] = (1));

return statearr_80968;
});
var flureenjs$ledgerList_$_state_machine__10903__auto____1 = (function (state_80956){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80969){var ex__10906__auto__ = e80969;
var statearr_80970_80978 = state_80956;
(statearr_80970_80978[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80956[(4)]))){
var statearr_80971_80979 = state_80956;
(statearr_80971_80979[(1)] = cljs.core.first.call(null,(state_80956[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80980 = state_80956;
state_80956 = G__80980;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$ledgerList_$_state_machine__10903__auto__ = function(state_80956){
switch(arguments.length){
case 0:
return flureenjs$ledgerList_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$ledgerList_$_state_machine__10903__auto____1.call(this,state_80956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledgerList_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledgerList_$_state_machine__10903__auto____0;
flureenjs$ledgerList_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledgerList_$_state_machine__10903__auto____1;
return flureenjs$ledgerList_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80972 = f__10977__auto__.call(null);
(statearr_80972[(6)] = c__10976__auto__);

return statearr_80972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.ledgerList', flureenjs.ledgerList);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than db-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 * 
 */
flureenjs.newLedger = (function flureenjs$newLedger(var_args){
var G__80982 = arguments.length;
switch (G__80982) {
case 2:
return flureenjs.newLedger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.newLedger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.newLedger', flureenjs.newLedger);

(flureenjs.newLedger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.newLedger.call(null,conn,ledger,null);
}));

(flureenjs.newLedger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_81100){
var state_val_81101 = (state_81100[(1)]);
if((state_val_81101 === (7))){
var inst_81005 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_81100__$1 = state_81100;
var statearr_81102_81167 = state_81100__$1;
(statearr_81102_81167[(2)] = inst_81005);

(statearr_81102_81167[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (20))){
var inst_81012 = (state_81100[(7)]);
var inst_81050 = (state_81100[(2)]);
var inst_81051 = fluree.db.util.core.current_time_millis.call(null);
var state_81100__$1 = (function (){var statearr_81103 = state_81100;
(statearr_81103[(8)] = inst_81050);

(statearr_81103[(9)] = inst_81051);

return statearr_81103;
})();
if(cljs.core.truth_(inst_81012)){
var statearr_81104_81168 = state_81100__$1;
(statearr_81104_81168[(1)] = (21));

} else {
var statearr_81105_81169 = state_81100__$1;
(statearr_81105_81169[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (27))){
var inst_81064 = (state_81100[(10)]);
var inst_81066 = fluree.db.util.core.without_nils.call(null,inst_81064);
var inst_81067 = fluree.db.util.json.stringify.call(null,inst_81066);
var state_81100__$1 = state_81100;
var statearr_81106_81170 = state_81100__$1;
(statearr_81106_81170[(2)] = inst_81067);

(statearr_81106_81170[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (1))){
var state_81100__$1 = state_81100;
var statearr_81107_81171 = state_81100__$1;
(statearr_81107_81171[(2)] = null);

(statearr_81107_81171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (24))){
var inst_81018 = (state_81100[(11)]);
var state_81100__$1 = state_81100;
var statearr_81108_81172 = state_81100__$1;
(statearr_81108_81172[(2)] = inst_81018);

(statearr_81108_81172[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (4))){
var inst_80983 = (state_81100[(2)]);
var inst_80984 = fluree.db.util.log.error.call(null,inst_80983);
var inst_80985 = cljs.core.ex_data.call(null,inst_80983);
var inst_80986 = cljs.core.ex_message.call(null,inst_80983);
var inst_80987 = cljs.core.assoc.call(null,inst_80985,new cljs.core.Keyword(null,"message","message",-406056002),inst_80986);
var inst_80988 = cljs.core.clj__GT_js.call(null,inst_80987);
var inst_80989 = reject.call(null,inst_80988);
var state_81100__$1 = (function (){var statearr_81109 = state_81100;
(statearr_81109[(12)] = inst_80984);

return statearr_81109;
})();
var statearr_81110_81173 = state_81100__$1;
(statearr_81110_81173[(2)] = inst_80989);

(statearr_81110_81173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (15))){
var inst_81040 = (state_81100[(13)]);
var inst_81042 = fluree.db.graphdb.validate_ledger_name.call(null,inst_81040,"alias");
var state_81100__$1 = state_81100;
var statearr_81111_81174 = state_81100__$1;
(statearr_81111_81174[(2)] = inst_81042);

(statearr_81111_81174[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (21))){
var inst_81012 = (state_81100[(7)]);
var state_81100__$1 = state_81100;
var statearr_81112_81175 = state_81100__$1;
(statearr_81112_81175[(2)] = inst_81012);

(statearr_81112_81175[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (31))){
var state_81100__$1 = state_81100;
var statearr_81113_81176 = state_81100__$1;
(statearr_81113_81176[(2)] = null);

(statearr_81113_81176[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (32))){
var inst_81014 = (state_81100[(14)]);
var inst_81075 = (state_81100[(2)]);
var state_81100__$1 = (function (){var statearr_81114 = state_81100;
(statearr_81114[(15)] = inst_81075);

return statearr_81114;
})();
if(cljs.core.truth_(inst_81014)){
var statearr_81115_81177 = state_81100__$1;
(statearr_81115_81177[(1)] = (33));

} else {
var statearr_81116_81178 = state_81100__$1;
(statearr_81116_81178[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (33))){
var inst_81075 = (state_81100[(15)]);
var inst_81070 = (state_81100[(16)]);
var inst_81077 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_81078 = [inst_81070,inst_81075];
var inst_81079 = cljs.core.PersistentHashMap.fromArrays(inst_81077,inst_81078);
var inst_81080 = fluree.db.operations.command_async.call(null,conn,inst_81079);
var state_81100__$1 = state_81100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81100__$1,(36),inst_81080);
} else {
if((state_val_81101 === (13))){
var state_81100__$1 = state_81100;
var statearr_81117_81179 = state_81100__$1;
(statearr_81117_81179[(2)] = null);

(statearr_81117_81179[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (22))){
var inst_81051 = (state_81100[(9)]);
var state_81100__$1 = state_81100;
var statearr_81118_81180 = state_81100__$1;
(statearr_81118_81180[(2)] = inst_81051);

(statearr_81118_81180[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (36))){
var inst_81082 = (state_81100[(2)]);
var inst_81083 = fluree.db.util.async.throw_err.call(null,inst_81082);
var state_81100__$1 = state_81100;
var statearr_81119_81181 = state_81100__$1;
(statearr_81119_81181[(2)] = inst_81083);

(statearr_81119_81181[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (29))){
var inst_81014 = (state_81100[(14)]);
var inst_81070 = (state_81100[(2)]);
var state_81100__$1 = (function (){var statearr_81120 = state_81100;
(statearr_81120[(16)] = inst_81070);

return statearr_81120;
})();
if(cljs.core.truth_(inst_81014)){
var statearr_81121_81182 = state_81100__$1;
(statearr_81121_81182[(1)] = (30));

} else {
var statearr_81122_81183 = state_81100__$1;
(statearr_81122_81183[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (6))){
var state_81100__$1 = state_81100;
var statearr_81123_81184 = state_81100__$1;
(statearr_81123_81184[(2)] = null);

(statearr_81123_81184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (28))){
var state_81100__$1 = state_81100;
var statearr_81124_81185 = state_81100__$1;
(statearr_81124_81185[(2)] = null);

(statearr_81124_81185[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (25))){
var inst_81051 = (state_81100[(9)]);
var inst_81058 = (inst_81051 + (30000));
var state_81100__$1 = state_81100;
var statearr_81125_81186 = state_81100__$1;
(statearr_81125_81186[(2)] = inst_81058);

(statearr_81125_81186[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (34))){
var inst_81064 = (state_81100[(10)]);
var inst_81085 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_81064);
var state_81100__$1 = state_81100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81100__$1,(37),inst_81085);
} else {
if((state_val_81101 === (17))){
var inst_81021 = (state_81100[(17)]);
var inst_81045 = (state_81100[(2)]);
var state_81100__$1 = (function (){var statearr_81126 = state_81100;
(statearr_81126[(18)] = inst_81045);

return statearr_81126;
})();
if(cljs.core.truth_(inst_81021)){
var statearr_81127_81187 = state_81100__$1;
(statearr_81127_81187[(1)] = (18));

} else {
var statearr_81128_81188 = state_81100__$1;
(statearr_81128_81188[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (3))){
var inst_81098 = (state_81100[(2)]);
var state_81100__$1 = state_81100;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81100__$1,inst_81098);
} else {
if((state_val_81101 === (12))){
var inst_81035 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var state_81100__$1 = state_81100;
var statearr_81129_81189 = state_81100__$1;
(statearr_81129_81189[(2)] = inst_81035);

(statearr_81129_81189[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (2))){
var _ = (function (){var statearr_81130 = state_81100;
(statearr_81130[(4)] = cljs.core.cons.call(null,(5),(state_81100[(4)])));

return statearr_81130;
})();
var inst_81002 = (opts == null);
var state_81100__$1 = state_81100;
if(cljs.core.truth_(inst_81002)){
var statearr_81131_81190 = state_81100__$1;
(statearr_81131_81190[(1)] = (6));

} else {
var statearr_81132_81191 = state_81100__$1;
(statearr_81132_81191[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (23))){
var inst_81018 = (state_81100[(11)]);
var inst_81055 = (state_81100[(2)]);
var state_81100__$1 = (function (){var statearr_81133 = state_81100;
(statearr_81133[(19)] = inst_81055);

return statearr_81133;
})();
if(cljs.core.truth_(inst_81018)){
var statearr_81134_81192 = state_81100__$1;
(statearr_81134_81192[(1)] = (24));

} else {
var statearr_81135_81193 = state_81100__$1;
(statearr_81135_81193[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (35))){
var inst_81090 = (state_81100[(2)]);
var inst_81091 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_81092 = [(200),inst_81090];
var inst_81093 = cljs.core.PersistentHashMap.fromArrays(inst_81091,inst_81092);
var inst_81094 = cljs.core.clj__GT_js.call(null,inst_81093);
var inst_81095 = resolve.call(null,inst_81094);
var _ = (function (){var statearr_81136 = state_81100;
(statearr_81136[(4)] = cljs.core.rest.call(null,(state_81100[(4)])));

return statearr_81136;
})();
var state_81100__$1 = state_81100;
var statearr_81137_81194 = state_81100__$1;
(statearr_81137_81194[(2)] = inst_81095);

(statearr_81137_81194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (19))){
var state_81100__$1 = state_81100;
var statearr_81138_81195 = state_81100__$1;
(statearr_81138_81195[(2)] = null);

(statearr_81138_81195[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (11))){
var inst_81024 = (state_81100[(20)]);
var inst_81021 = (state_81100[(17)]);
var inst_81031 = (state_81100[(21)]);
var inst_81031__$1 = (state_81100[(2)]);
var inst_81032 = fluree.db.graphdb.validate_ledger_name.call(null,inst_81031__$1,"ledger");
var inst_81033 = fluree.db.graphdb.validate_ledger_name.call(null,inst_81024,"network");
var state_81100__$1 = (function (){var statearr_81140 = state_81100;
(statearr_81140[(22)] = inst_81032);

(statearr_81140[(23)] = inst_81033);

(statearr_81140[(21)] = inst_81031__$1);

return statearr_81140;
})();
if(cljs.core.truth_(inst_81021)){
var statearr_81141_81196 = state_81100__$1;
(statearr_81141_81196[(1)] = (12));

} else {
var statearr_81142_81197 = state_81100__$1;
(statearr_81142_81197[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (9))){
var inst_81025 = (state_81100[(24)]);
var inst_81028 = cljs.core.subs.call(null,inst_81025,(1));
var state_81100__$1 = state_81100;
var statearr_81143_81198 = state_81100__$1;
(statearr_81143_81198[(2)] = inst_81028);

(statearr_81143_81198[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (5))){
var _ = (function (){var statearr_81144 = state_81100;
(statearr_81144[(4)] = cljs.core.rest.call(null,(state_81100[(4)])));

return statearr_81144;
})();
var state_81100__$1 = state_81100;
var ex81139 = (state_81100__$1[(2)]);
var statearr_81145_81199 = state_81100__$1;
(statearr_81145_81199[(5)] = ex81139);


var statearr_81146_81200 = state_81100__$1;
(statearr_81146_81200[(1)] = (4));

(statearr_81146_81200[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (14))){
var inst_81021 = (state_81100[(17)]);
var inst_81038 = (state_81100[(2)]);
var inst_81039 = cljs.core.nth.call(null,inst_81038,(0),null);
var inst_81040 = cljs.core.nth.call(null,inst_81038,(1),null);
var state_81100__$1 = (function (){var statearr_81147 = state_81100;
(statearr_81147[(25)] = inst_81039);

(statearr_81147[(13)] = inst_81040);

return statearr_81147;
})();
if(cljs.core.truth_(inst_81021)){
var statearr_81148_81201 = state_81100__$1;
(statearr_81148_81201[(1)] = (15));

} else {
var statearr_81149_81202 = state_81100__$1;
(statearr_81149_81202[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (26))){
var inst_81020 = (state_81100[(26)]);
var inst_81019 = (state_81100[(27)]);
var inst_81013 = (state_81100[(28)]);
var inst_81050 = (state_81100[(8)]);
var inst_81022 = (state_81100[(29)]);
var inst_81055 = (state_81100[(19)]);
var inst_81024 = (state_81100[(20)]);
var inst_81014 = (state_81100[(14)]);
var inst_81017 = (state_81100[(30)]);
var inst_81016 = (state_81100[(31)]);
var inst_81015 = (state_81100[(32)]);
var inst_81031 = (state_81100[(21)]);
var inst_81011 = (state_81100[(33)]);
var inst_81060 = (state_81100[(2)]);
var inst_81061 = [new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_81062 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81024),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81031)].join('');
var inst_81063 = [inst_81016,inst_81017,inst_81062,new cljs.core.Keyword(null,"new-db","new-db",1305352401),inst_81060,inst_81019,inst_81050,inst_81022,inst_81020,inst_81011,inst_81055,inst_81013,inst_81015];
var inst_81064 = cljs.core.PersistentHashMap.fromArrays(inst_81061,inst_81063);
var state_81100__$1 = (function (){var statearr_81150 = state_81100;
(statearr_81150[(10)] = inst_81064);

return statearr_81150;
})();
if(cljs.core.truth_(inst_81014)){
var statearr_81151_81203 = state_81100__$1;
(statearr_81151_81203[(1)] = (27));

} else {
var statearr_81152_81204 = state_81100__$1;
(statearr_81152_81204[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (16))){
var state_81100__$1 = state_81100;
var statearr_81153_81205 = state_81100__$1;
(statearr_81153_81205[(2)] = null);

(statearr_81153_81205[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (30))){
var inst_81014 = (state_81100[(14)]);
var inst_81070 = (state_81100[(16)]);
var inst_81072 = fluree.crypto.sign_message.call(null,inst_81070,inst_81014);
var state_81100__$1 = state_81100;
var statearr_81154_81206 = state_81100__$1;
(statearr_81154_81206[(2)] = inst_81072);

(statearr_81154_81206[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (10))){
var inst_81025 = (state_81100[(24)]);
var state_81100__$1 = state_81100;
var statearr_81155_81207 = state_81100__$1;
(statearr_81155_81207[(2)] = inst_81025);

(statearr_81155_81207[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (18))){
var inst_81039 = (state_81100[(25)]);
var inst_81040 = (state_81100[(13)]);
var inst_81047 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81039),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81040)].join('');
var state_81100__$1 = state_81100;
var statearr_81156_81208 = state_81100__$1;
(statearr_81156_81208[(2)] = inst_81047);

(statearr_81156_81208[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (37))){
var inst_81087 = (state_81100[(2)]);
var inst_81088 = fluree.db.util.async.throw_err.call(null,inst_81087);
var state_81100__$1 = state_81100;
var statearr_81157_81209 = state_81100__$1;
(statearr_81157_81209[(2)] = inst_81088);

(statearr_81157_81209[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81101 === (8))){
var inst_81025 = (state_81100[(24)]);
var inst_81007 = (state_81100[(2)]);
var inst_81008 = fluree.db.connection_js.check_connection.call(null,conn,inst_81007);
var inst_81009 = cljs.core.__destructure_map.call(null,inst_81007);
var inst_81010 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_81011 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_81012 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_81013 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_81014 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_81015 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_81016 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_81017 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_81018 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_81019 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_81020 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_81021 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_81022 = cljs.core.get.call(null,inst_81009,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_81023 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var inst_81024 = cljs.core.nth.call(null,inst_81023,(0),null);
var inst_81025__$1 = cljs.core.nth.call(null,inst_81023,(1),null);
var inst_81026 = clojure.string.starts_with_QMARK_.call(null,inst_81025__$1,"$");
var state_81100__$1 = (function (){var statearr_81158 = state_81100;
(statearr_81158[(34)] = inst_81008);

(statearr_81158[(11)] = inst_81018);

(statearr_81158[(26)] = inst_81020);

(statearr_81158[(27)] = inst_81019);

(statearr_81158[(28)] = inst_81013);

(statearr_81158[(29)] = inst_81022);

(statearr_81158[(35)] = inst_81010);

(statearr_81158[(20)] = inst_81024);

(statearr_81158[(7)] = inst_81012);

(statearr_81158[(14)] = inst_81014);

(statearr_81158[(24)] = inst_81025__$1);

(statearr_81158[(17)] = inst_81021);

(statearr_81158[(30)] = inst_81017);

(statearr_81158[(31)] = inst_81016);

(statearr_81158[(32)] = inst_81015);

(statearr_81158[(33)] = inst_81011);

return statearr_81158;
})();
if(inst_81026){
var statearr_81159_81210 = state_81100__$1;
(statearr_81159_81210[(1)] = (9));

} else {
var statearr_81160_81211 = state_81100__$1;
(statearr_81160_81211[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_81161 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81161[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_81161[(1)] = (1));

return statearr_81161;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_81100){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_81100);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e81162){var ex__10906__auto__ = e81162;
var statearr_81163_81212 = state_81100;
(statearr_81163_81212[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_81100[(4)]))){
var statearr_81164_81213 = state_81100;
(statearr_81164_81213[(1)] = cljs.core.first.call(null,(state_81100[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81214 = state_81100;
state_81100 = G__81214;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_81100){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_81100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_81165 = f__10977__auto__.call(null);
(statearr_81165[(6)] = c__10976__auto__);

return statearr_81165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.newLedger.cljs$lang$maxFixedArity = 3);

/**
 * Resolves a ledger identity in the form of 'network/ledger-or-alias' and returns a
 *   tuple of either [network ledger alias] or [network ledger].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger id.
 * 
 *   If you are providing a ledger id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the db-ident.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias or id of testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 */
flureenjs.resolveLedger = (function flureenjs$resolveLedger(conn,ledger){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_81230){
var state_val_81231 = (state_81230[(1)]);
if((state_val_81231 === (1))){
var state_81230__$1 = state_81230;
var statearr_81232_81247 = state_81230__$1;
(statearr_81232_81247[(2)] = null);

(statearr_81232_81247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81231 === (2))){
var _ = (function (){var statearr_81233 = state_81230;
(statearr_81233[(4)] = cljs.core.cons.call(null,(5),(state_81230[(4)])));

return statearr_81233;
})();
var inst_81223 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_81224 = cljs.core.clj__GT_js.call(null,inst_81223);
var inst_81225 = resolve.call(null,inst_81224);
var ___$1 = (function (){var statearr_81234 = state_81230;
(statearr_81234[(4)] = cljs.core.rest.call(null,(state_81230[(4)])));

return statearr_81234;
})();
var state_81230__$1 = state_81230;
var statearr_81235_81248 = state_81230__$1;
(statearr_81235_81248[(2)] = inst_81225);

(statearr_81235_81248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81231 === (3))){
var inst_81228 = (state_81230[(2)]);
var state_81230__$1 = state_81230;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81230__$1,inst_81228);
} else {
if((state_val_81231 === (4))){
var inst_81215 = (state_81230[(2)]);
var inst_81216 = fluree.db.util.log.error.call(null,inst_81215);
var inst_81217 = reject.call(null,inst_81215);
var state_81230__$1 = (function (){var statearr_81237 = state_81230;
(statearr_81237[(7)] = inst_81216);

return statearr_81237;
})();
var statearr_81238_81249 = state_81230__$1;
(statearr_81238_81249[(2)] = inst_81217);

(statearr_81238_81249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81231 === (5))){
var _ = (function (){var statearr_81239 = state_81230;
(statearr_81239[(4)] = cljs.core.rest.call(null,(state_81230[(4)])));

return statearr_81239;
})();
var state_81230__$1 = state_81230;
var ex81236 = (state_81230__$1[(2)]);
var statearr_81240_81250 = state_81230__$1;
(statearr_81240_81250[(5)] = ex81236);


var statearr_81241_81251 = state_81230__$1;
(statearr_81241_81251[(1)] = (4));

(statearr_81241_81251[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$resolveLedger_$_state_machine__10903__auto__ = null;
var flureenjs$resolveLedger_$_state_machine__10903__auto____0 = (function (){
var statearr_81242 = [null,null,null,null,null,null,null,null];
(statearr_81242[(0)] = flureenjs$resolveLedger_$_state_machine__10903__auto__);

(statearr_81242[(1)] = (1));

return statearr_81242;
});
var flureenjs$resolveLedger_$_state_machine__10903__auto____1 = (function (state_81230){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_81230);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e81243){var ex__10906__auto__ = e81243;
var statearr_81244_81252 = state_81230;
(statearr_81244_81252[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_81230[(4)]))){
var statearr_81245_81253 = state_81230;
(statearr_81245_81253[(1)] = cljs.core.first.call(null,(state_81230[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81254 = state_81230;
state_81230 = G__81254;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$resolveLedger_$_state_machine__10903__auto__ = function(state_81230){
switch(arguments.length){
case 0:
return flureenjs$resolveLedger_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$resolveLedger_$_state_machine__10903__auto____1.call(this,state_81230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$resolveLedger_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$resolveLedger_$_state_machine__10903__auto____0;
flureenjs$resolveLedger_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$resolveLedger_$_state_machine__10903__auto____1;
return flureenjs$resolveLedger_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_81246 = f__10977__auto__.call(null);
(statearr_81246[(6)] = c__10976__auto__);

return statearr_81246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.resolveLedger', flureenjs.resolveLedger);
/**
 * Returns session object for a given ledger.
 */
flureenjs.session = (function flureenjs$session(conn,ledger){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_81270){
var state_val_81271 = (state_81270[(1)]);
if((state_val_81271 === (1))){
var state_81270__$1 = state_81270;
var statearr_81272_81287 = state_81270__$1;
(statearr_81272_81287[(2)] = null);

(statearr_81272_81287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81271 === (2))){
var _ = (function (){var statearr_81273 = state_81270;
(statearr_81273[(4)] = cljs.core.cons.call(null,(5),(state_81270[(4)])));

return statearr_81273;
})();
var inst_81263 = fluree.db.session.session.call(null,conn,ledger);
var inst_81264 = cljs.core.clj__GT_js.call(null,inst_81263);
var inst_81265 = resolve.call(null,inst_81264);
var ___$1 = (function (){var statearr_81274 = state_81270;
(statearr_81274[(4)] = cljs.core.rest.call(null,(state_81270[(4)])));

return statearr_81274;
})();
var state_81270__$1 = state_81270;
var statearr_81275_81288 = state_81270__$1;
(statearr_81275_81288[(2)] = inst_81265);

(statearr_81275_81288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81271 === (3))){
var inst_81268 = (state_81270[(2)]);
var state_81270__$1 = state_81270;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81270__$1,inst_81268);
} else {
if((state_val_81271 === (4))){
var inst_81255 = (state_81270[(2)]);
var inst_81256 = fluree.db.util.log.error.call(null,inst_81255);
var inst_81257 = reject.call(null,inst_81255);
var state_81270__$1 = (function (){var statearr_81277 = state_81270;
(statearr_81277[(7)] = inst_81256);

return statearr_81277;
})();
var statearr_81278_81289 = state_81270__$1;
(statearr_81278_81289[(2)] = inst_81257);

(statearr_81278_81289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81271 === (5))){
var _ = (function (){var statearr_81279 = state_81270;
(statearr_81279[(4)] = cljs.core.rest.call(null,(state_81270[(4)])));

return statearr_81279;
})();
var state_81270__$1 = state_81270;
var ex81276 = (state_81270__$1[(2)]);
var statearr_81280_81290 = state_81270__$1;
(statearr_81280_81290[(5)] = ex81276);


var statearr_81281_81291 = state_81270__$1;
(statearr_81281_81291[(1)] = (4));

(statearr_81281_81291[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$session_$_state_machine__10903__auto__ = null;
var flureenjs$session_$_state_machine__10903__auto____0 = (function (){
var statearr_81282 = [null,null,null,null,null,null,null,null];
(statearr_81282[(0)] = flureenjs$session_$_state_machine__10903__auto__);

(statearr_81282[(1)] = (1));

return statearr_81282;
});
var flureenjs$session_$_state_machine__10903__auto____1 = (function (state_81270){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_81270);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e81283){var ex__10906__auto__ = e81283;
var statearr_81284_81292 = state_81270;
(statearr_81284_81292[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_81270[(4)]))){
var statearr_81285_81293 = state_81270;
(statearr_81285_81293[(1)] = cljs.core.first.call(null,(state_81270[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81294 = state_81270;
state_81270 = G__81294;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$session_$_state_machine__10903__auto__ = function(state_81270){
switch(arguments.length){
case 0:
return flureenjs$session_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$session_$_state_machine__10903__auto____1.call(this,state_81270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$session_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$session_$_state_machine__10903__auto____0;
flureenjs$session_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$session_$_state_machine__10903__auto____1;
return flureenjs$session_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_81286 = f__10977__auto__.call(null);
(statearr_81286[(6)] = c__10976__auto__);

return statearr_81286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.session', flureenjs.session);
/**
 * Returns a promise containing search results of flake parts (flake-parts).
 */
flureenjs.search = (function flureenjs$search(db,flake_parts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_81318){
var state_val_81319 = (state_81318[(1)]);
if((state_val_81319 === (1))){
var state_81318__$1 = state_81318;
var statearr_81320_81336 = state_81318__$1;
(statearr_81320_81336[(2)] = null);

(statearr_81320_81336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81319 === (2))){
var _ = (function (){var statearr_81321 = state_81318;
(statearr_81321[(4)] = cljs.core.cons.call(null,(5),(state_81318[(4)])));

return statearr_81321;
})();
var inst_81303 = cljs.core.js__GT_clj.call(null,flake_parts);
var state_81318__$1 = (function (){var statearr_81322 = state_81318;
(statearr_81322[(7)] = inst_81303);

return statearr_81322;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81318__$1,(7),db);
} else {
if((state_val_81319 === (3))){
var inst_81316 = (state_81318[(2)]);
var state_81318__$1 = state_81318;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81318__$1,inst_81316);
} else {
if((state_val_81319 === (4))){
var inst_81295 = (state_81318[(2)]);
var inst_81296 = fluree.db.util.log.error.call(null,inst_81295);
var inst_81297 = reject.call(null,inst_81295);
var state_81318__$1 = (function (){var statearr_81324 = state_81318;
(statearr_81324[(8)] = inst_81296);

return statearr_81324;
})();
var statearr_81325_81337 = state_81318__$1;
(statearr_81325_81337[(2)] = inst_81297);

(statearr_81325_81337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81319 === (5))){
var _ = (function (){var statearr_81326 = state_81318;
(statearr_81326[(4)] = cljs.core.rest.call(null,(state_81318[(4)])));

return statearr_81326;
})();
var state_81318__$1 = state_81318;
var ex81323 = (state_81318__$1[(2)]);
var statearr_81327_81338 = state_81318__$1;
(statearr_81327_81338[(5)] = ex81323);


var statearr_81328_81339 = state_81318__$1;
(statearr_81328_81339[(1)] = (4));

(statearr_81328_81339[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81319 === (6))){
var inst_81309 = (state_81318[(2)]);
var inst_81310 = fluree.db.util.async.throw_err.call(null,inst_81309);
var inst_81311 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_81310);
var inst_81312 = cljs.core.clj__GT_js.call(null,inst_81311);
var inst_81313 = resolve.call(null,inst_81312);
var _ = (function (){var statearr_81329 = state_81318;
(statearr_81329[(4)] = cljs.core.rest.call(null,(state_81318[(4)])));

return statearr_81329;
})();
var state_81318__$1 = state_81318;
var statearr_81330_81340 = state_81318__$1;
(statearr_81330_81340[(2)] = inst_81313);

(statearr_81330_81340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81319 === (7))){
var inst_81303 = (state_81318[(7)]);
var inst_81305 = (state_81318[(2)]);
var inst_81306 = fluree.db.util.async.throw_err.call(null,inst_81305);
var inst_81307 = fluree.db.dbproto._search.call(null,inst_81306,inst_81303);
var state_81318__$1 = state_81318;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81318__$1,(6),inst_81307);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$search_$_state_machine__10903__auto__ = null;
var flureenjs$search_$_state_machine__10903__auto____0 = (function (){
var statearr_81331 = [null,null,null,null,null,null,null,null,null];
(statearr_81331[(0)] = flureenjs$search_$_state_machine__10903__auto__);

(statearr_81331[(1)] = (1));

return statearr_81331;
});
var flureenjs$search_$_state_machine__10903__auto____1 = (function (state_81318){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_81318);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e81332){var ex__10906__auto__ = e81332;
var statearr_81333_81341 = state_81318;
(statearr_81333_81341[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_81318[(4)]))){
var statearr_81334_81342 = state_81318;
(statearr_81334_81342[(1)] = cljs.core.first.call(null,(state_81318[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81343 = state_81318;
state_81318 = G__81343;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$search_$_state_machine__10903__auto__ = function(state_81318){
switch(arguments.length){
case 0:
return flureenjs$search_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$search_$_state_machine__10903__auto____1.call(this,state_81318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$search_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$search_$_state_machine__10903__auto____0;
flureenjs$search_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$search_$_state_machine__10903__auto____1;
return flureenjs$search_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_81335 = f__10977__auto__.call(null);
(statearr_81335[(6)] = c__10976__auto__);

return statearr_81335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.search', flureenjs.search);
/**
 * Returns a promise containing a new db based on the provided db,
 * including the provided flakes. Flakes can contain one or more 't's,
 * but should be sequential and start after the current 't' of the provided
 * db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.). Remember
 * 't' is negative and thus should be in descending order.
 * 
 * A forward-time-travel db can be further forward-time-traveled.
 * 
 * A forward-time travel DB is held in memory, and is not shared across servers.
 * Ensure you have adequate memory to hold the flakes you generate and add. If
 * access is provided via an external API, do any desired size restrictions or
 * controls within your API endpoint.
 * 
 * Remember schema operations done via forward-time-travel should be done in a
 * 't' prior to the flakes that end up requiring the schema change.
 */
flureenjs.forwardTimeTravel = (function flureenjs$forwardTimeTravel(db,flakes){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_81364){
var state_val_81365 = (state_81364[(1)]);
if((state_val_81365 === (1))){
var state_81364__$1 = state_81364;
var statearr_81366_81382 = state_81364__$1;
(statearr_81366_81382[(2)] = null);

(statearr_81366_81382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81365 === (2))){
var _ = (function (){var statearr_81367 = state_81364;
(statearr_81367[(4)] = cljs.core.cons.call(null,(5),(state_81364[(4)])));

return statearr_81367;
})();
var inst_81352 = cljs.core.js__GT_clj.call(null,flakes);
var inst_81353 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_81352);
var state_81364__$1 = (function (){var statearr_81368 = state_81364;
(statearr_81368[(7)] = inst_81353);

return statearr_81368;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81364__$1,(6),db);
} else {
if((state_val_81365 === (3))){
var inst_81362 = (state_81364[(2)]);
var state_81364__$1 = state_81364;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81364__$1,inst_81362);
} else {
if((state_val_81365 === (4))){
var inst_81344 = (state_81364[(2)]);
var inst_81345 = fluree.db.util.log.error.call(null,inst_81344);
var inst_81346 = reject.call(null,inst_81344);
var state_81364__$1 = (function (){var statearr_81370 = state_81364;
(statearr_81370[(8)] = inst_81345);

return statearr_81370;
})();
var statearr_81371_81383 = state_81364__$1;
(statearr_81371_81383[(2)] = inst_81346);

(statearr_81371_81383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81365 === (5))){
var _ = (function (){var statearr_81372 = state_81364;
(statearr_81372[(4)] = cljs.core.rest.call(null,(state_81364[(4)])));

return statearr_81372;
})();
var state_81364__$1 = state_81364;
var ex81369 = (state_81364__$1[(2)]);
var statearr_81373_81384 = state_81364__$1;
(statearr_81373_81384[(5)] = ex81369);


var statearr_81374_81385 = state_81364__$1;
(statearr_81374_81385[(1)] = (4));

(statearr_81374_81385[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81365 === (6))){
var inst_81353 = (state_81364[(7)]);
var inst_81355 = (state_81364[(2)]);
var inst_81356 = fluree.db.util.async.throw_err.call(null,inst_81355);
var inst_81357 = fluree.db.graphdb.forward_time_travel.call(null,inst_81356,null,inst_81353);
var inst_81358 = cljs.core.clj__GT_js.call(null,inst_81357);
var inst_81359 = resolve.call(null,inst_81358);
var _ = (function (){var statearr_81375 = state_81364;
(statearr_81375[(4)] = cljs.core.rest.call(null,(state_81364[(4)])));

return statearr_81375;
})();
var state_81364__$1 = state_81364;
var statearr_81376_81386 = state_81364__$1;
(statearr_81376_81386[(2)] = inst_81359);

(statearr_81376_81386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$forwardTimeTravel_$_state_machine__10903__auto__ = null;
var flureenjs$forwardTimeTravel_$_state_machine__10903__auto____0 = (function (){
var statearr_81377 = [null,null,null,null,null,null,null,null,null];
(statearr_81377[(0)] = flureenjs$forwardTimeTravel_$_state_machine__10903__auto__);

(statearr_81377[(1)] = (1));

return statearr_81377;
});
var flureenjs$forwardTimeTravel_$_state_machine__10903__auto____1 = (function (state_81364){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_81364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e81378){var ex__10906__auto__ = e81378;
var statearr_81379_81387 = state_81364;
(statearr_81379_81387[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_81364[(4)]))){
var statearr_81380_81388 = state_81364;
(statearr_81380_81388[(1)] = cljs.core.first.call(null,(state_81364[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81389 = state_81364;
state_81364 = G__81389;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$forwardTimeTravel_$_state_machine__10903__auto__ = function(state_81364){
switch(arguments.length){
case 0:
return flureenjs$forwardTimeTravel_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$forwardTimeTravel_$_state_machine__10903__auto____1.call(this,state_81364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$forwardTimeTravel_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$forwardTimeTravel_$_state_machine__10903__auto____0;
flureenjs$forwardTimeTravel_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$forwardTimeTravel_$_state_machine__10903__auto____1;
return flureenjs$forwardTimeTravel_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_81381 = f__10977__auto__.call(null);
(statearr_81381[(6)] = c__10976__auto__);

return statearr_81381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.forwardTimeTravel', flureenjs.forwardTimeTravel);
/**
 * Returns true if provided db is a forward-time-travel db.
 */
flureenjs.isForwardTimeTravelDb = (function flureenjs$isForwardTimeTravelDb(db){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_81413){
var state_val_81414 = (state_81413[(1)]);
if((state_val_81414 === (7))){
var state_81413__$1 = state_81413;
var statearr_81415_81434 = state_81413__$1;
(statearr_81415_81434[(2)] = db);

(statearr_81415_81434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81414 === (1))){
var state_81413__$1 = state_81413;
var statearr_81416_81435 = state_81413__$1;
(statearr_81416_81435[(2)] = null);

(statearr_81416_81435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81414 === (4))){
var inst_81390 = (state_81413[(2)]);
var inst_81391 = fluree.db.util.log.error.call(null,inst_81390);
var inst_81392 = reject.call(null,inst_81390);
var state_81413__$1 = (function (){var statearr_81417 = state_81413;
(statearr_81417[(7)] = inst_81391);

return statearr_81417;
})();
var statearr_81418_81436 = state_81413__$1;
(statearr_81418_81436[(2)] = inst_81392);

(statearr_81418_81436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81414 === (6))){
var state_81413__$1 = state_81413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81413__$1,(9),db);
} else {
if((state_val_81414 === (3))){
var inst_81411 = (state_81413[(2)]);
var state_81413__$1 = state_81413;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81413__$1,inst_81411);
} else {
if((state_val_81414 === (2))){
var _ = (function (){var statearr_81420 = state_81413;
(statearr_81420[(4)] = cljs.core.cons.call(null,(5),(state_81413[(4)])));

return statearr_81420;
})();
var inst_81398 = fluree.db.util.async.channel_QMARK_.call(null,db);
var state_81413__$1 = state_81413;
if(inst_81398){
var statearr_81421_81437 = state_81413__$1;
(statearr_81421_81437[(1)] = (6));

} else {
var statearr_81422_81438 = state_81413__$1;
(statearr_81422_81438[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81414 === (9))){
var inst_81401 = (state_81413[(2)]);
var inst_81402 = fluree.db.util.async.throw_err.call(null,inst_81401);
var state_81413__$1 = state_81413;
var statearr_81423_81439 = state_81413__$1;
(statearr_81423_81439[(2)] = inst_81402);

(statearr_81423_81439[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81414 === (5))){
var _ = (function (){var statearr_81424 = state_81413;
(statearr_81424[(4)] = cljs.core.rest.call(null,(state_81413[(4)])));

return statearr_81424;
})();
var state_81413__$1 = state_81413;
var ex81419 = (state_81413__$1[(2)]);
var statearr_81425_81440 = state_81413__$1;
(statearr_81425_81440[(5)] = ex81419);


var statearr_81426_81441 = state_81413__$1;
(statearr_81426_81441[(1)] = (4));

(statearr_81426_81441[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81414 === (8))){
var inst_81405 = (state_81413[(2)]);
var inst_81406 = fluree.db.graphdb.forward_time_travel_db_QMARK_.call(null,inst_81405);
var inst_81407 = cljs.core.clj__GT_js.call(null,inst_81406);
var inst_81408 = resolve.call(null,inst_81407);
var _ = (function (){var statearr_81427 = state_81413;
(statearr_81427[(4)] = cljs.core.rest.call(null,(state_81413[(4)])));

return statearr_81427;
})();
var state_81413__$1 = state_81413;
var statearr_81428_81442 = state_81413__$1;
(statearr_81428_81442[(2)] = inst_81408);

(statearr_81428_81442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$isForwardTimeTravelDb_$_state_machine__10903__auto__ = null;
var flureenjs$isForwardTimeTravelDb_$_state_machine__10903__auto____0 = (function (){
var statearr_81429 = [null,null,null,null,null,null,null,null];
(statearr_81429[(0)] = flureenjs$isForwardTimeTravelDb_$_state_machine__10903__auto__);

(statearr_81429[(1)] = (1));

return statearr_81429;
});
var flureenjs$isForwardTimeTravelDb_$_state_machine__10903__auto____1 = (function (state_81413){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_81413);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e81430){var ex__10906__auto__ = e81430;
var statearr_81431_81443 = state_81413;
(statearr_81431_81443[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_81413[(4)]))){
var statearr_81432_81444 = state_81413;
(statearr_81432_81444[(1)] = cljs.core.first.call(null,(state_81413[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81445 = state_81413;
state_81413 = G__81445;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$isForwardTimeTravelDb_$_state_machine__10903__auto__ = function(state_81413){
switch(arguments.length){
case 0:
return flureenjs$isForwardTimeTravelDb_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$isForwardTimeTravelDb_$_state_machine__10903__auto____1.call(this,state_81413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$isForwardTimeTravelDb_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$isForwardTimeTravelDb_$_state_machine__10903__auto____0;
flureenjs$isForwardTimeTravelDb_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$isForwardTimeTravelDb_$_state_machine__10903__auto____1;
return flureenjs$isForwardTimeTravelDb_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_81433 = f__10977__auto__.call(null);
(statearr_81433[(6)] = c__10976__auto__);

return statearr_81433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.isForwardTimeTravelDb', flureenjs.isForwardTimeTravelDb);
/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureenjs.monitorTx = (function flureenjs$monitorTx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_81465){
var state_val_81466 = (state_81465[(1)]);
if((state_val_81466 === (1))){
var state_81465__$1 = state_81465;
var statearr_81467_81483 = state_81465__$1;
(statearr_81467_81483[(2)] = null);

(statearr_81467_81483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81466 === (2))){
var _ = (function (){var statearr_81468 = state_81465;
(statearr_81468[(4)] = cljs.core.cons.call(null,(5),(state_81465[(4)])));

return statearr_81468;
})();
var inst_81455 = fluree.db.connection_js.check_connection.call(null,conn);
var inst_81456 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,txid,timeout_ms);
var state_81465__$1 = (function (){var statearr_81469 = state_81465;
(statearr_81469[(7)] = inst_81455);

return statearr_81469;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81465__$1,(6),inst_81456);
} else {
if((state_val_81466 === (3))){
var inst_81463 = (state_81465[(2)]);
var state_81465__$1 = state_81465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81465__$1,inst_81463);
} else {
if((state_val_81466 === (4))){
var inst_81446 = (state_81465[(2)]);
var inst_81447 = fluree.db.util.log.error.call(null,inst_81446);
var inst_81448 = cljs.core.clj__GT_js.call(null,inst_81446);
var inst_81449 = reject.call(null,inst_81448);
var state_81465__$1 = (function (){var statearr_81471 = state_81465;
(statearr_81471[(8)] = inst_81447);

return statearr_81471;
})();
var statearr_81472_81484 = state_81465__$1;
(statearr_81472_81484[(2)] = inst_81449);

(statearr_81472_81484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81466 === (5))){
var _ = (function (){var statearr_81473 = state_81465;
(statearr_81473[(4)] = cljs.core.rest.call(null,(state_81465[(4)])));

return statearr_81473;
})();
var state_81465__$1 = state_81465;
var ex81470 = (state_81465__$1[(2)]);
var statearr_81474_81485 = state_81465__$1;
(statearr_81474_81485[(5)] = ex81470);


var statearr_81475_81486 = state_81465__$1;
(statearr_81475_81486[(1)] = (4));

(statearr_81475_81486[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81466 === (6))){
var inst_81458 = (state_81465[(2)]);
var inst_81459 = cljs.core.clj__GT_js.call(null,inst_81458);
var inst_81460 = resolve.call(null,inst_81459);
var _ = (function (){var statearr_81476 = state_81465;
(statearr_81476[(4)] = cljs.core.rest.call(null,(state_81465[(4)])));

return statearr_81476;
})();
var state_81465__$1 = state_81465;
var statearr_81477_81487 = state_81465__$1;
(statearr_81477_81487[(2)] = inst_81460);

(statearr_81477_81487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$monitorTx_$_state_machine__10903__auto__ = null;
var flureenjs$monitorTx_$_state_machine__10903__auto____0 = (function (){
var statearr_81478 = [null,null,null,null,null,null,null,null,null];
(statearr_81478[(0)] = flureenjs$monitorTx_$_state_machine__10903__auto__);

(statearr_81478[(1)] = (1));

return statearr_81478;
});
var flureenjs$monitorTx_$_state_machine__10903__auto____1 = (function (state_81465){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_81465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e81479){var ex__10906__auto__ = e81479;
var statearr_81480_81488 = state_81465;
(statearr_81480_81488[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_81465[(4)]))){
var statearr_81481_81489 = state_81465;
(statearr_81481_81489[(1)] = cljs.core.first.call(null,(state_81465[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81490 = state_81465;
state_81465 = G__81490;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$monitorTx_$_state_machine__10903__auto__ = function(state_81465){
switch(arguments.length){
case 0:
return flureenjs$monitorTx_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$monitorTx_$_state_machine__10903__auto____1.call(this,state_81465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$monitorTx_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$monitorTx_$_state_machine__10903__auto____0;
flureenjs$monitorTx_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$monitorTx_$_state_machine__10903__auto____1;
return flureenjs$monitorTx_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_81482 = f__10977__auto__.call(null);
(statearr_81482[(6)] = c__10976__auto__);

return statearr_81482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.monitorTx', flureenjs.monitorTx);
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
flureenjs.txToCommand = (function flureenjs$txToCommand(var_args){
var G__81492 = arguments.length;
switch (G__81492) {
case 3:
return flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return flureenjs.txToCommand.call(null,ledger,txn,private_key,null);
}));

(flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_81601){
var state_val_81602 = (state_81601[(1)]);
if((state_val_81602 === (7))){
var state_81601__$1 = state_81601;
var statearr_81603_81670 = state_81601__$1;
(statearr_81603_81670[(2)] = ledger);

(statearr_81603_81670[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (20))){
var inst_81518 = (state_81601[(7)]);
var inst_81558 = (state_81601[(2)]);
var inst_81559 = cljs.core.nth.call(null,inst_81558,(0),null);
var inst_81560 = cljs.core.nth.call(null,inst_81558,(1),null);
var inst_81561 = fluree.db.util.core.current_time_millis.call(null);
var state_81601__$1 = (function (){var statearr_81604 = state_81601;
(statearr_81604[(8)] = inst_81561);

(statearr_81604[(9)] = inst_81559);

(statearr_81604[(10)] = inst_81560);

return statearr_81604;
})();
if(cljs.core.truth_(inst_81518)){
var statearr_81605_81671 = state_81601__$1;
(statearr_81605_81671[(1)] = (27));

} else {
var statearr_81606_81672 = state_81601__$1;
(statearr_81606_81672[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (27))){
var inst_81518 = (state_81601[(7)]);
var state_81601__$1 = state_81601;
var statearr_81607_81673 = state_81601__$1;
(statearr_81607_81673[(2)] = inst_81518);

(statearr_81607_81673[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (1))){
var state_81601__$1 = state_81601;
var statearr_81608_81674 = state_81601__$1;
(statearr_81608_81674[(2)] = null);

(statearr_81608_81674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (24))){
var inst_81532 = (state_81601[(11)]);
var inst_81549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81550 = [inst_81532,null];
var inst_81551 = (new cljs.core.PersistentVector(null,2,(5),inst_81549,inst_81550,null));
var state_81601__$1 = state_81601;
var statearr_81609_81675 = state_81601__$1;
(statearr_81609_81675[(2)] = inst_81551);

(statearr_81609_81675[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (4))){
var inst_81493 = (state_81601[(2)]);
var inst_81494 = fluree.db.util.log.error.call(null,inst_81493);
var inst_81495 = cljs.core.clj__GT_js.call(null,inst_81493);
var inst_81496 = reject.call(null,inst_81495);
var state_81601__$1 = (function (){var statearr_81610 = state_81601;
(statearr_81610[(12)] = inst_81494);

return statearr_81610;
})();
var statearr_81611_81676 = state_81601__$1;
(statearr_81611_81676[(2)] = inst_81496);

(statearr_81611_81676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (15))){
var inst_81516 = (state_81601[(13)]);
var inst_81532 = (state_81601[(11)]);
var inst_81534 = cljs.core.not_EQ_.call(null,inst_81516,inst_81532);
var state_81601__$1 = state_81601;
var statearr_81612_81677 = state_81601__$1;
(statearr_81612_81677[(2)] = inst_81534);

(statearr_81612_81677[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (21))){
var inst_81516 = (state_81601[(13)]);
var inst_81544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81545 = [inst_81516,null];
var inst_81546 = (new cljs.core.PersistentVector(null,2,(5),inst_81544,inst_81545,null));
var state_81601__$1 = state_81601;
var statearr_81613_81678 = state_81601__$1;
(statearr_81613_81678[(2)] = inst_81546);

(statearr_81613_81678[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (31))){
var inst_81561 = (state_81601[(8)]);
var inst_81568 = (inst_81561 + (30000));
var state_81601__$1 = state_81601;
var statearr_81614_81679 = state_81601__$1;
(statearr_81614_81679[(2)] = inst_81568);

(statearr_81614_81679[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (32))){
var inst_81570 = (state_81601[(2)]);
var state_81601__$1 = (function (){var statearr_81615 = state_81601;
(statearr_81615[(14)] = inst_81570);

return statearr_81615;
})();
var statearr_81616_81680 = state_81601__$1;
(statearr_81616_81680[(2)] = null);

(statearr_81616_81680[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (33))){
var inst_81565 = (state_81601[(15)]);
var inst_81559 = (state_81601[(9)]);
var inst_81570 = (state_81601[(14)]);
var inst_81560 = (state_81601[(10)]);
var inst_81519 = (state_81601[(16)]);
var inst_81513 = (state_81601[(17)]);
var _ = (function (){var statearr_81617 = state_81601;
(statearr_81617[(4)] = cljs.core.cons.call(null,(36),(state_81601[(4)])));

return statearr_81617;
})();
var inst_81583 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"authority","authority",-551669367),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"deps","deps",1883360319)];
var inst_81584 = [new cljs.core.Keyword(null,"tx","tx",466630418),inst_81513,txn,inst_81565,inst_81559,inst_81560,inst_81570,inst_81519];
var inst_81585 = cljs.core.PersistentHashMap.fromArrays(inst_81583,inst_81584);
var inst_81586 = fluree.db.util.core.without_nils.call(null,inst_81585);
var inst_81587 = fluree.db.util.json.stringify.call(null,inst_81586);
var ___$1 = (function (){var statearr_81618 = state_81601;
(statearr_81618[(4)] = cljs.core.rest.call(null,(state_81601[(4)])));

return statearr_81618;
})();
var state_81601__$1 = state_81601;
var statearr_81619_81681 = state_81601__$1;
(statearr_81619_81681[(2)] = inst_81587);

(statearr_81619_81681[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (13))){
var inst_81524 = ["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('');
var inst_81525 = (new Error(inst_81524));
var inst_81526 = (function(){throw inst_81525})();
var state_81601__$1 = state_81601;
var statearr_81621_81682 = state_81601__$1;
(statearr_81621_81682[(2)] = inst_81526);

(statearr_81621_81682[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (22))){
var state_81601__$1 = state_81601;
var statearr_81622_81683 = state_81601__$1;
(statearr_81622_81683[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (36))){
var _ = (function (){var statearr_81624 = state_81601;
(statearr_81624[(4)] = cljs.core.rest.call(null,(state_81601[(4)])));

return statearr_81624;
})();
var state_81601__$1 = state_81601;
var ex81620 = (state_81601__$1[(2)]);
var statearr_81625_81684 = state_81601__$1;
(statearr_81625_81684[(5)] = ex81620);


var statearr_81626_81685 = state_81601__$1;
(statearr_81626_81685[(1)] = (35));

(statearr_81626_81685[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (29))){
var inst_81517 = (state_81601[(18)]);
var inst_81565 = (state_81601[(2)]);
var state_81601__$1 = (function (){var statearr_81627 = state_81601;
(statearr_81627[(15)] = inst_81565);

return statearr_81627;
})();
if(cljs.core.truth_(inst_81517)){
var statearr_81628_81686 = state_81601__$1;
(statearr_81628_81686[(1)] = (30));

} else {
var statearr_81629_81687 = state_81601__$1;
(statearr_81629_81687[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (6))){
var inst_81508 = cljs.core.first.call(null,ledger);
var inst_81509 = cljs.core.second.call(null,ledger);
var inst_81510 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81508),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81509)].join('');
var state_81601__$1 = state_81601;
var statearr_81630_81688 = state_81601__$1;
(statearr_81630_81688[(2)] = inst_81510);

(statearr_81630_81688[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (28))){
var inst_81561 = (state_81601[(8)]);
var state_81601__$1 = state_81601;
var statearr_81631_81689 = state_81601__$1;
(statearr_81631_81689[(2)] = inst_81561);

(statearr_81631_81689[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (25))){
var state_81601__$1 = state_81601;
var statearr_81632_81690 = state_81601__$1;
(statearr_81632_81690[(2)] = null);

(statearr_81632_81690[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (34))){
var inst_81590 = (state_81601[(2)]);
var inst_81591 = fluree.crypto.sign_message.call(null,inst_81590,private_key);
var inst_81592 = fluree.crypto.sha3_256.call(null,inst_81590);
var inst_81593 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"db","db",993250759)];
var inst_81594 = [inst_81590,inst_81591,inst_81592,ledger];
var inst_81595 = cljs.core.PersistentHashMap.fromArrays(inst_81593,inst_81594);
var inst_81596 = resolve.call(null,inst_81595);
var _ = (function (){var statearr_81633 = state_81601;
(statearr_81633[(4)] = cljs.core.rest.call(null,(state_81601[(4)])));

return statearr_81633;
})();
var state_81601__$1 = state_81601;
var statearr_81634_81691 = state_81601__$1;
(statearr_81634_81691[(2)] = inst_81596);

(statearr_81634_81691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (17))){
var inst_81537 = (state_81601[(2)]);
var state_81601__$1 = state_81601;
if(cljs.core.truth_(inst_81537)){
var statearr_81635_81692 = state_81601__$1;
(statearr_81635_81692[(1)] = (18));

} else {
var statearr_81636_81693 = state_81601__$1;
(statearr_81636_81693[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (3))){
var inst_81599 = (state_81601[(2)]);
var state_81601__$1 = state_81601;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81601__$1,inst_81599);
} else {
if((state_val_81602 === (12))){
var state_81601__$1 = state_81601;
var statearr_81637_81694 = state_81601__$1;
(statearr_81637_81694[(2)] = null);

(statearr_81637_81694[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (2))){
var _ = (function (){var statearr_81638 = state_81601;
(statearr_81638[(4)] = cljs.core.cons.call(null,(5),(state_81601[(4)])));

return statearr_81638;
})();
var inst_81506 = cljs.core.sequential_QMARK_.call(null,ledger);
var state_81601__$1 = state_81601;
if(inst_81506){
var statearr_81639_81695 = state_81601__$1;
(statearr_81639_81695[(1)] = (6));

} else {
var statearr_81640_81696 = state_81601__$1;
(statearr_81640_81696[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (23))){
var inst_81556 = (state_81601[(2)]);
var state_81601__$1 = state_81601;
var statearr_81641_81697 = state_81601__$1;
(statearr_81641_81697[(2)] = inst_81556);

(statearr_81641_81697[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (35))){
var inst_81571 = (state_81601[(2)]);
var inst_81572 = fluree.db.util.log.error.call(null,inst_81571);
var inst_81573 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81574 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_81575 = cljs.core.PersistentHashMap.fromArrays(inst_81573,inst_81574);
var inst_81576 = cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",inst_81575);
var inst_81577 = (function(){throw inst_81576})();
var state_81601__$1 = (function (){var statearr_81642 = state_81601;
(statearr_81642[(19)] = inst_81572);

return statearr_81642;
})();
var statearr_81643_81698 = state_81601__$1;
(statearr_81643_81698[(2)] = inst_81577);

(statearr_81643_81698[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (19))){
var inst_81516 = (state_81601[(13)]);
var state_81601__$1 = state_81601;
if(cljs.core.truth_(inst_81516)){
var statearr_81644_81699 = state_81601__$1;
(statearr_81644_81699[(1)] = (21));

} else {
var statearr_81645_81700 = state_81601__$1;
(statearr_81645_81700[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (11))){
var inst_81516 = (state_81601[(13)]);
var inst_81531 = (state_81601[(2)]);
var inst_81532 = fluree.crypto.account_id_from_private.call(null,private_key);
var state_81601__$1 = (function (){var statearr_81647 = state_81601;
(statearr_81647[(11)] = inst_81532);

(statearr_81647[(20)] = inst_81531);

return statearr_81647;
})();
if(cljs.core.truth_(inst_81516)){
var statearr_81648_81701 = state_81601__$1;
(statearr_81648_81701[(1)] = (15));

} else {
var statearr_81649_81702 = state_81601__$1;
(statearr_81649_81702[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (9))){
var inst_81519 = (state_81601[(16)]);
var inst_81521 = cljs.core.sequential_QMARK_.call(null,inst_81519);
var state_81601__$1 = state_81601;
if(inst_81521){
var statearr_81650_81703 = state_81601__$1;
(statearr_81650_81703[(1)] = (12));

} else {
var statearr_81651_81704 = state_81601__$1;
(statearr_81651_81704[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (5))){
var _ = (function (){var statearr_81652 = state_81601;
(statearr_81652[(4)] = cljs.core.rest.call(null,(state_81601[(4)])));

return statearr_81652;
})();
var state_81601__$1 = state_81601;
var ex81646 = (state_81601__$1[(2)]);
var statearr_81653_81705 = state_81601__$1;
(statearr_81653_81705[(5)] = ex81646);


var statearr_81654_81706 = state_81601__$1;
(statearr_81654_81706[(1)] = (4));

(statearr_81654_81706[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (14))){
var inst_81528 = (state_81601[(2)]);
var state_81601__$1 = state_81601;
var statearr_81655_81707 = state_81601__$1;
(statearr_81655_81707[(2)] = inst_81528);

(statearr_81655_81707[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (26))){
var inst_81554 = (state_81601[(2)]);
var state_81601__$1 = state_81601;
var statearr_81656_81708 = state_81601__$1;
(statearr_81656_81708[(2)] = inst_81554);

(statearr_81656_81708[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (16))){
var inst_81516 = (state_81601[(13)]);
var state_81601__$1 = state_81601;
var statearr_81657_81709 = state_81601__$1;
(statearr_81657_81709[(2)] = inst_81516);

(statearr_81657_81709[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (30))){
var inst_81517 = (state_81601[(18)]);
var state_81601__$1 = state_81601;
var statearr_81658_81710 = state_81601__$1;
(statearr_81658_81710[(2)] = inst_81517);

(statearr_81658_81710[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (10))){
var state_81601__$1 = state_81601;
var statearr_81659_81711 = state_81601__$1;
(statearr_81659_81711[(2)] = null);

(statearr_81659_81711[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (18))){
var inst_81516 = (state_81601[(13)]);
var inst_81532 = (state_81601[(11)]);
var inst_81539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81540 = [inst_81516,inst_81532];
var inst_81541 = (new cljs.core.PersistentVector(null,2,(5),inst_81539,inst_81540,null));
var state_81601__$1 = state_81601;
var statearr_81660_81712 = state_81601__$1;
(statearr_81660_81712[(2)] = inst_81541);

(statearr_81660_81712[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81602 === (8))){
var inst_81519 = (state_81601[(16)]);
var inst_81513 = (state_81601[(2)]);
var inst_81514 = opts;
var inst_81515 = cljs.core.__destructure_map.call(null,inst_81514);
var inst_81516 = cljs.core.get.call(null,inst_81515,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_81517 = cljs.core.get.call(null,inst_81515,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_81518 = cljs.core.get.call(null,inst_81515,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_81519__$1 = cljs.core.get.call(null,inst_81515,new cljs.core.Keyword(null,"deps","deps",1883360319));
var state_81601__$1 = (function (){var statearr_81661 = state_81601;
(statearr_81661[(13)] = inst_81516);

(statearr_81661[(16)] = inst_81519__$1);

(statearr_81661[(17)] = inst_81513);

(statearr_81661[(18)] = inst_81517);

(statearr_81661[(7)] = inst_81518);

return statearr_81661;
})();
if(cljs.core.truth_(inst_81519__$1)){
var statearr_81662_81713 = state_81601__$1;
(statearr_81662_81713[(1)] = (9));

} else {
var statearr_81663_81714 = state_81601__$1;
(statearr_81663_81714[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_81664 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81664[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_81664[(1)] = (1));

return statearr_81664;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_81601){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_81601);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e81665){var ex__10906__auto__ = e81665;
var statearr_81666_81715 = state_81601;
(statearr_81666_81715[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_81601[(4)]))){
var statearr_81667_81716 = state_81601;
(statearr_81667_81716[(1)] = cljs.core.first.call(null,(state_81601[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81717 = state_81601;
state_81601 = G__81717;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_81601){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_81601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_81668 = f__10977__auto__.call(null);
(statearr_81668[(6)] = c__10976__auto__);

return statearr_81668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.txToCommand.cljs$lang$maxFixedArity = 4);

/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 */
flureenjs.transact = (function flureenjs$transact(var_args){
var G__81719 = arguments.length;
switch (G__81719) {
case 3:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.transact', flureenjs.transact);

(flureenjs.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureenjs.transact.call(null,conn,ledger,txn,null);
}));

(flureenjs.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_81745){
var state_val_81746 = (state_81745[(1)]);
if((state_val_81746 === (7))){
var inst_81731 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_81745__$1 = state_81745;
var statearr_81747_81768 = state_81745__$1;
(statearr_81747_81768[(2)] = inst_81731);

(statearr_81747_81768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81746 === (1))){
var state_81745__$1 = state_81745;
var statearr_81748_81769 = state_81745__$1;
(statearr_81748_81769[(2)] = null);

(statearr_81748_81769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81746 === (4))){
var inst_81720 = (state_81745[(2)]);
var inst_81721 = fluree.db.util.log.error.call(null,inst_81720);
var inst_81722 = reject.call(null,inst_81720);
var state_81745__$1 = (function (){var statearr_81749 = state_81745;
(statearr_81749[(7)] = inst_81721);

return statearr_81749;
})();
var statearr_81750_81770 = state_81745__$1;
(statearr_81750_81770[(2)] = inst_81722);

(statearr_81750_81770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81746 === (6))){
var state_81745__$1 = state_81745;
var statearr_81751_81771 = state_81745__$1;
(statearr_81751_81771[(2)] = null);

(statearr_81751_81771[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81746 === (3))){
var inst_81743 = (state_81745[(2)]);
var state_81745__$1 = state_81745;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81745__$1,inst_81743);
} else {
if((state_val_81746 === (2))){
var _ = (function (){var statearr_81753 = state_81745;
(statearr_81753[(4)] = cljs.core.cons.call(null,(5),(state_81745[(4)])));

return statearr_81753;
})();
var inst_81728 = (opts == null);
var state_81745__$1 = state_81745;
if(cljs.core.truth_(inst_81728)){
var statearr_81754_81772 = state_81745__$1;
(statearr_81754_81772[(1)] = (6));

} else {
var statearr_81755_81773 = state_81745__$1;
(statearr_81755_81773[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81746 === (9))){
var inst_81738 = (state_81745[(2)]);
var inst_81739 = cljs.core.clj__GT_js.call(null,inst_81738);
var inst_81740 = resolve.call(null,inst_81739);
var _ = (function (){var statearr_81756 = state_81745;
(statearr_81756[(4)] = cljs.core.rest.call(null,(state_81745[(4)])));

return statearr_81756;
})();
var state_81745__$1 = state_81745;
var statearr_81757_81774 = state_81745__$1;
(statearr_81757_81774[(2)] = inst_81740);

(statearr_81757_81774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81746 === (5))){
var _ = (function (){var statearr_81758 = state_81745;
(statearr_81758[(4)] = cljs.core.rest.call(null,(state_81745[(4)])));

return statearr_81758;
})();
var state_81745__$1 = state_81745;
var ex81752 = (state_81745__$1[(2)]);
var statearr_81759_81775 = state_81745__$1;
(statearr_81759_81775[(5)] = ex81752);


var statearr_81760_81776 = state_81745__$1;
(statearr_81760_81776[(1)] = (4));

(statearr_81760_81776[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81746 === (8))){
var inst_81733 = (state_81745[(2)]);
var inst_81734 = fluree.db.connection_js.check_connection.call(null,conn,inst_81733);
var inst_81735 = cljs.core.js__GT_clj.call(null,txn,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_81736 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_81735,inst_81733);
var state_81745__$1 = (function (){var statearr_81761 = state_81745;
(statearr_81761[(8)] = inst_81734);

return statearr_81761;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81745__$1,(9),inst_81736);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_81762 = [null,null,null,null,null,null,null,null,null];
(statearr_81762[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_81762[(1)] = (1));

return statearr_81762;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_81745){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_81745);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e81763){var ex__10906__auto__ = e81763;
var statearr_81764_81777 = state_81745;
(statearr_81764_81777[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_81745[(4)]))){
var statearr_81765_81778 = state_81745;
(statearr_81765_81778[(1)] = cljs.core.first.call(null,(state_81745[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81779 = state_81745;
state_81745 = G__81779;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_81745){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_81745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_81766 = f__10977__auto__.call(null);
(statearr_81766[(6)] = c__10976__auto__);

return statearr_81766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureenjs.blockRangeWithTxn = (function flureenjs$blockRangeWithTxn(var_args){
var G__81781 = arguments.length;
switch (G__81781) {
case 3:
return flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockRangeWithTxn', flureenjs.blockRangeWithTxn);

(flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureenjs.blockRangeWithTxn.call(null,conn,ledger,block_map,null);
}));

(flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_81810){
var state_val_81811 = (state_81810[(1)]);
if((state_val_81811 === (1))){
var state_81810__$1 = state_81810;
var statearr_81812_81829 = state_81810__$1;
(statearr_81812_81829[(2)] = null);

(statearr_81812_81829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81811 === (2))){
var inst_81791 = (state_81810[(7)]);
var _ = (function (){var statearr_81813 = state_81810;
(statearr_81813[(4)] = cljs.core.cons.call(null,(5),(state_81810[(4)])));

return statearr_81813;
})();
var inst_81791__$1 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_81792 = cljs.core.js__GT_clj.call(null,block_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_81793 = cljs.core.__destructure_map.call(null,inst_81792);
var inst_81794 = cljs.core.get.call(null,inst_81793,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_81795 = cljs.core.get.call(null,inst_81793,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_81796 = flureenjs._db_instance.call(null,conn,ledger,inst_81791__$1);
var state_81810__$1 = (function (){var statearr_81814 = state_81810;
(statearr_81814[(8)] = inst_81795);

(statearr_81814[(9)] = inst_81794);

(statearr_81814[(7)] = inst_81791__$1);

return statearr_81814;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81810__$1,(6),inst_81796);
} else {
if((state_val_81811 === (3))){
var inst_81808 = (state_81810[(2)]);
var state_81810__$1 = state_81810;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81810__$1,inst_81808);
} else {
if((state_val_81811 === (4))){
var inst_81782 = (state_81810[(2)]);
var inst_81783 = fluree.db.util.log.error.call(null,inst_81782);
var inst_81784 = reject.call(null,inst_81782);
var state_81810__$1 = (function (){var statearr_81816 = state_81810;
(statearr_81816[(10)] = inst_81783);

return statearr_81816;
})();
var statearr_81817_81830 = state_81810__$1;
(statearr_81817_81830[(2)] = inst_81784);

(statearr_81817_81830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81811 === (5))){
var _ = (function (){var statearr_81818 = state_81810;
(statearr_81818[(4)] = cljs.core.rest.call(null,(state_81810[(4)])));

return statearr_81818;
})();
var state_81810__$1 = state_81810;
var ex81815 = (state_81810__$1[(2)]);
var statearr_81819_81831 = state_81810__$1;
(statearr_81819_81831[(5)] = ex81815);


var statearr_81820_81832 = state_81810__$1;
(statearr_81820_81832[(1)] = (4));

(statearr_81820_81832[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81811 === (6))){
var inst_81795 = (state_81810[(8)]);
var inst_81794 = (state_81810[(9)]);
var inst_81791 = (state_81810[(7)]);
var inst_81798 = (state_81810[(2)]);
var inst_81799 = fluree.db.query.block.block_range.call(null,inst_81798,inst_81794,inst_81795,inst_81791);
var state_81810__$1 = state_81810;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81810__$1,(7),inst_81799);
} else {
if((state_val_81811 === (7))){
var inst_81801 = (state_81810[(2)]);
var inst_81802 = fluree.db.util.async.throw_err.call(null,inst_81801);
var inst_81803 = fluree.db.query.range.block_with_tx_data.call(null,inst_81802);
var inst_81804 = cljs.core.clj__GT_js.call(null,inst_81803);
var inst_81805 = resolve.call(null,inst_81804);
var _ = (function (){var statearr_81821 = state_81810;
(statearr_81821[(4)] = cljs.core.rest.call(null,(state_81810[(4)])));

return statearr_81821;
})();
var state_81810__$1 = state_81810;
var statearr_81822_81833 = state_81810__$1;
(statearr_81822_81833[(2)] = inst_81805);

(statearr_81822_81833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_81823 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_81823[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_81823[(1)] = (1));

return statearr_81823;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_81810){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_81810);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e81824){var ex__10906__auto__ = e81824;
var statearr_81825_81834 = state_81810;
(statearr_81825_81834[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_81810[(4)]))){
var statearr_81826_81835 = state_81810;
(statearr_81826_81835[(1)] = cljs.core.first.call(null,(state_81810[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81836 = state_81810;
state_81810 = G__81836;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_81810){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_81810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_81827 = f__10977__auto__.call(null);
(statearr_81827[(6)] = c__10976__auto__);

return statearr_81827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.blockRangeWithTxn.cljs$lang$maxFixedArity = 4);

flureenjs.blockQuery = (function flureenjs$blockQuery(var_args){
var G__81838 = arguments.length;
switch (G__81838) {
case 3:
return flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockQuery', flureenjs.blockQuery);

(flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureenjs.blockQuery.call(null,conn,ledger,query_map,null);
}));

(flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_81896){
var state_val_81897 = (state_81896[(1)]);
if((state_val_81897 === (7))){
var state_81896__$1 = state_81896;
var statearr_81898_81939 = state_81896__$1;
(statearr_81898_81939[(2)] = null);

(statearr_81898_81939[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (20))){
var inst_81875 = (state_81896[(2)]);
var state_81896__$1 = state_81896;
var statearr_81899_81940 = state_81896__$1;
(statearr_81899_81940[(2)] = inst_81875);

(statearr_81899_81940[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (1))){
var state_81896__$1 = state_81896;
var statearr_81900_81941 = state_81896__$1;
(statearr_81900_81941[(2)] = null);

(statearr_81900_81941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (4))){
var inst_81839 = (state_81896[(2)]);
var inst_81840 = fluree.db.util.log.error.call(null,inst_81839);
var inst_81841 = reject.call(null,inst_81839);
var state_81896__$1 = (function (){var statearr_81901 = state_81896;
(statearr_81901[(7)] = inst_81840);

return statearr_81901;
})();
var statearr_81902_81942 = state_81896__$1;
(statearr_81902_81942[(2)] = inst_81841);

(statearr_81902_81942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (15))){
var state_81896__$1 = state_81896;
var statearr_81903_81943 = state_81896__$1;
(statearr_81903_81943[(2)] = null);

(statearr_81903_81943[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (21))){
var inst_81888 = (state_81896[(2)]);
var inst_81889 = fluree.db.util.async.throw_err.call(null,inst_81888);
var inst_81890 = cljs.core.clj__GT_js.call(null,inst_81889);
var inst_81891 = resolve.call(null,inst_81890);
var _ = (function (){var statearr_81904 = state_81896;
(statearr_81904[(4)] = cljs.core.rest.call(null,(state_81896[(4)])));

return statearr_81904;
})();
var state_81896__$1 = state_81896;
var statearr_81905_81944 = state_81896__$1;
(statearr_81905_81944[(2)] = inst_81891);

(statearr_81905_81944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (13))){
var inst_81854 = (state_81896[(8)]);
var inst_81863 = (state_81896[(9)]);
var inst_81863__$1 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_81854);
var inst_81864 = (inst_81863__$1 == null);
var state_81896__$1 = (function (){var statearr_81906 = state_81896;
(statearr_81906[(9)] = inst_81863__$1);

return statearr_81906;
})();
if(cljs.core.truth_(inst_81864)){
var statearr_81907_81945 = state_81896__$1;
(statearr_81907_81945[(1)] = (15));

} else {
var statearr_81908_81946 = state_81896__$1;
(statearr_81908_81946[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (6))){
var inst_81850 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_81896__$1 = state_81896;
var statearr_81909_81947 = state_81896__$1;
(statearr_81909_81947[(2)] = inst_81850);

(statearr_81909_81947[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (17))){
var inst_81869 = (state_81896[(10)]);
var inst_81869__$1 = (state_81896[(2)]);
var inst_81870 = (inst_81869__$1 == null);
var state_81896__$1 = (function (){var statearr_81910 = state_81896;
(statearr_81910[(10)] = inst_81869__$1);

return statearr_81910;
})();
if(cljs.core.truth_(inst_81870)){
var statearr_81911_81948 = state_81896__$1;
(statearr_81911_81948[(1)] = (18));

} else {
var statearr_81912_81949 = state_81896__$1;
(statearr_81912_81949[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (3))){
var inst_81894 = (state_81896[(2)]);
var state_81896__$1 = state_81896;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81896__$1,inst_81894);
} else {
if((state_val_81897 === (12))){
var inst_81859 = (state_81896[(11)]);
var state_81896__$1 = state_81896;
var statearr_81913_81950 = state_81896__$1;
(statearr_81913_81950[(2)] = inst_81859);

(statearr_81913_81950[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (2))){
var inst_81847 = (state_81896[(12)]);
var _ = (function (){var statearr_81914 = state_81896;
(statearr_81914[(4)] = cljs.core.cons.call(null,(5),(state_81896[(4)])));

return statearr_81914;
})();
var inst_81847__$1 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_81848 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_81847__$1);
var state_81896__$1 = (function (){var statearr_81915 = state_81896;
(statearr_81915[(12)] = inst_81847__$1);

(statearr_81915[(13)] = inst_81848);

return statearr_81915;
})();
if(cljs.core.truth_(opts)){
var statearr_81916_81951 = state_81896__$1;
(statearr_81916_81951[(1)] = (6));

} else {
var statearr_81917_81952 = state_81896__$1;
(statearr_81917_81952[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (19))){
var inst_81869 = (state_81896[(10)]);
var inst_81873 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_81869);
var state_81896__$1 = state_81896;
var statearr_81918_81953 = state_81896__$1;
(statearr_81918_81953[(2)] = inst_81873);

(statearr_81918_81953[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (11))){
var inst_81854 = (state_81896[(8)]);
var inst_81847 = (state_81896[(12)]);
var inst_81879 = (state_81896[(2)]);
var inst_81880 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_81881 = [inst_81879];
var inst_81882 = cljs.core.PersistentHashMap.fromArrays(inst_81880,inst_81881);
var inst_81883 = fluree.db.util.core.without_nils.call(null,inst_81882);
var inst_81884 = cljs.core.merge.call(null,inst_81854,inst_81883);
var inst_81885 = cljs.core.update.call(null,inst_81847,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_81884);
var inst_81886 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_81885);
var state_81896__$1 = state_81896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81896__$1,(21),inst_81886);
} else {
if((state_val_81897 === (9))){
var inst_81856 = (state_81896[(14)]);
var state_81896__$1 = state_81896;
var statearr_81920_81954 = state_81896__$1;
(statearr_81920_81954[(2)] = inst_81856);

(statearr_81920_81954[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (5))){
var _ = (function (){var statearr_81921 = state_81896;
(statearr_81921[(4)] = cljs.core.rest.call(null,(state_81896[(4)])));

return statearr_81921;
})();
var state_81896__$1 = state_81896;
var ex81919 = (state_81896__$1[(2)]);
var statearr_81922_81955 = state_81896__$1;
(statearr_81922_81955[(5)] = ex81919);


var statearr_81923_81956 = state_81896__$1;
(statearr_81923_81956[(1)] = (4));

(statearr_81923_81956[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (14))){
var inst_81877 = (state_81896[(2)]);
var state_81896__$1 = state_81896;
var statearr_81924_81957 = state_81896__$1;
(statearr_81924_81957[(2)] = inst_81877);

(statearr_81924_81957[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (16))){
var inst_81863 = (state_81896[(9)]);
var inst_81867 = fluree.db.connection_js.validate_token.call(null,conn,inst_81863);
var state_81896__$1 = state_81896;
var statearr_81925_81958 = state_81896__$1;
(statearr_81925_81958[(2)] = inst_81867);

(statearr_81925_81958[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (10))){
var inst_81854 = (state_81896[(8)]);
var inst_81859 = (state_81896[(11)]);
var inst_81859__$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_81854);
var state_81896__$1 = (function (){var statearr_81926 = state_81896;
(statearr_81926[(11)] = inst_81859__$1);

return statearr_81926;
})();
if(cljs.core.truth_(inst_81859__$1)){
var statearr_81927_81959 = state_81896__$1;
(statearr_81927_81959[(1)] = (12));

} else {
var statearr_81928_81960 = state_81896__$1;
(statearr_81928_81960[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (18))){
var state_81896__$1 = state_81896;
var statearr_81929_81961 = state_81896__$1;
(statearr_81929_81961[(2)] = null);

(statearr_81929_81961[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81897 === (8))){
var inst_81856 = (state_81896[(14)]);
var inst_81854 = (state_81896[(8)]);
var inst_81848 = (state_81896[(13)]);
var inst_81853 = (state_81896[(2)]);
var inst_81854__$1 = cljs.core.merge.call(null,inst_81848,inst_81853);
var inst_81855 = fluree.db.connection_js.check_connection.call(null,conn,inst_81854__$1);
var inst_81856__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_81854__$1);
var state_81896__$1 = (function (){var statearr_81930 = state_81896;
(statearr_81930[(15)] = inst_81855);

(statearr_81930[(14)] = inst_81856__$1);

(statearr_81930[(8)] = inst_81854__$1);

return statearr_81930;
})();
if(cljs.core.truth_(inst_81856__$1)){
var statearr_81931_81962 = state_81896__$1;
(statearr_81931_81962[(1)] = (9));

} else {
var statearr_81932_81963 = state_81896__$1;
(statearr_81932_81963[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_81933 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81933[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_81933[(1)] = (1));

return statearr_81933;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_81896){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_81896);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e81934){var ex__10906__auto__ = e81934;
var statearr_81935_81964 = state_81896;
(statearr_81935_81964[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_81896[(4)]))){
var statearr_81936_81965 = state_81896;
(statearr_81936_81965[(1)] = cljs.core.first.call(null,(state_81896[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81966 = state_81896;
state_81896 = G__81966;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_81896){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_81896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_81937 = f__10977__auto__.call(null);
(statearr_81937[(6)] = c__10976__auto__);

return statearr_81937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.blockQuery.cljs$lang$maxFixedArity = 4);

/**
 * Returns a promise containing blocks from start (inclusive)
 * to end if provided (exclusive).
 * 
 * Each block is a separate map, containing keys :block, :t and :flakes.
 */
flureenjs.blockRange = (function flureenjs$blockRange(var_args){
var G__81968 = arguments.length;
switch (G__81968) {
case 2:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockRange', flureenjs.blockRange);

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return flureenjs.blockRange.call(null,db,start,null,null);
}));

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return flureenjs.blockRange.call(null,db,start,end,null);
}));

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_81992){
var state_val_81993 = (state_81992[(1)]);
if((state_val_81993 === (1))){
var state_81992__$1 = state_81992;
var statearr_81994_82011 = state_81992__$1;
(statearr_81994_82011[(2)] = null);

(statearr_81994_82011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81993 === (2))){
var _ = (function (){var statearr_81995 = state_81992;
(statearr_81995[(4)] = cljs.core.cons.call(null,(5),(state_81992[(4)])));

return statearr_81995;
})();
var inst_81977 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_81992__$1 = (function (){var statearr_81996 = state_81992;
(statearr_81996[(7)] = inst_81977);

return statearr_81996;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81992__$1,(7),db);
} else {
if((state_val_81993 === (3))){
var inst_81990 = (state_81992[(2)]);
var state_81992__$1 = state_81992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81992__$1,inst_81990);
} else {
if((state_val_81993 === (4))){
var inst_81969 = (state_81992[(2)]);
var inst_81970 = fluree.db.util.log.error.call(null,inst_81969);
var inst_81971 = reject.call(null,inst_81969);
var state_81992__$1 = (function (){var statearr_81998 = state_81992;
(statearr_81998[(8)] = inst_81970);

return statearr_81998;
})();
var statearr_81999_82012 = state_81992__$1;
(statearr_81999_82012[(2)] = inst_81971);

(statearr_81999_82012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81993 === (5))){
var _ = (function (){var statearr_82000 = state_81992;
(statearr_82000[(4)] = cljs.core.rest.call(null,(state_81992[(4)])));

return statearr_82000;
})();
var state_81992__$1 = state_81992;
var ex81997 = (state_81992__$1[(2)]);
var statearr_82001_82013 = state_81992__$1;
(statearr_82001_82013[(5)] = ex81997);


var statearr_82002_82014 = state_81992__$1;
(statearr_82002_82014[(1)] = (4));

(statearr_82002_82014[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81993 === (6))){
var inst_81983 = (state_81992[(2)]);
var inst_81984 = fluree.db.util.async.throw_err.call(null,inst_81983);
var inst_81985 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_81984);
var inst_81986 = cljs.core.clj__GT_js.call(null,inst_81985);
var inst_81987 = resolve.call(null,inst_81986);
var _ = (function (){var statearr_82003 = state_81992;
(statearr_82003[(4)] = cljs.core.rest.call(null,(state_81992[(4)])));

return statearr_82003;
})();
var state_81992__$1 = state_81992;
var statearr_82004_82015 = state_81992__$1;
(statearr_82004_82015[(2)] = inst_81987);

(statearr_82004_82015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81993 === (7))){
var inst_81977 = (state_81992[(7)]);
var inst_81979 = (state_81992[(2)]);
var inst_81980 = fluree.db.util.async.throw_err.call(null,inst_81979);
var inst_81981 = fluree.db.query.block.block_range.call(null,inst_81980,start,end,inst_81977);
var state_81992__$1 = state_81992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81992__$1,(6),inst_81981);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_82005 = [null,null,null,null,null,null,null,null,null];
(statearr_82005[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_82005[(1)] = (1));

return statearr_82005;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_81992){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_81992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e82006){var ex__10906__auto__ = e82006;
var statearr_82007_82016 = state_81992;
(statearr_82007_82016[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_81992[(4)]))){
var statearr_82008_82017 = state_81992;
(statearr_82008_82017[(1)] = cljs.core.first.call(null,(state_81992[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82018 = state_81992;
state_81992 = G__82018;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_81992){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_81992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_82009 = f__10977__auto__.call(null);
(statearr_82009[(6)] = c__10976__auto__);

return statearr_82009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.blockRange.cljs$lang$maxFixedArity = 4);

/**
 * Returns spot index range for only the requested collection.
 */
flureenjs.collectionFlakes = (function flureenjs$collectionFlakes(db,collection){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_82041){
var state_val_82042 = (state_82041[(1)]);
if((state_val_82042 === (1))){
var state_82041__$1 = state_82041;
var statearr_82043_82058 = state_82041__$1;
(statearr_82043_82058[(2)] = null);

(statearr_82043_82058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82042 === (2))){
var _ = (function (){var statearr_82044 = state_82041;
(statearr_82044[(4)] = cljs.core.cons.call(null,(5),(state_82041[(4)])));

return statearr_82044;
})();
var state_82041__$1 = state_82041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82041__$1,(7),db);
} else {
if((state_val_82042 === (3))){
var inst_82039 = (state_82041[(2)]);
var state_82041__$1 = state_82041;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82041__$1,inst_82039);
} else {
if((state_val_82042 === (4))){
var inst_82019 = (state_82041[(2)]);
var inst_82020 = fluree.db.util.log.error.call(null,inst_82019);
var inst_82021 = reject.call(null,inst_82019);
var state_82041__$1 = (function (){var statearr_82046 = state_82041;
(statearr_82046[(7)] = inst_82020);

return statearr_82046;
})();
var statearr_82047_82059 = state_82041__$1;
(statearr_82047_82059[(2)] = inst_82021);

(statearr_82047_82059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82042 === (5))){
var _ = (function (){var statearr_82048 = state_82041;
(statearr_82048[(4)] = cljs.core.rest.call(null,(state_82041[(4)])));

return statearr_82048;
})();
var state_82041__$1 = state_82041;
var ex82045 = (state_82041__$1[(2)]);
var statearr_82049_82060 = state_82041__$1;
(statearr_82049_82060[(5)] = ex82045);


var statearr_82050_82061 = state_82041__$1;
(statearr_82050_82061[(1)] = (4));

(statearr_82050_82061[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82042 === (6))){
var inst_82032 = (state_82041[(2)]);
var inst_82033 = fluree.db.util.async.throw_err.call(null,inst_82032);
var inst_82034 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_82033);
var inst_82035 = cljs.core.clj__GT_js.call(null,inst_82034);
var inst_82036 = resolve.call(null,inst_82035);
var _ = (function (){var statearr_82051 = state_82041;
(statearr_82051[(4)] = cljs.core.rest.call(null,(state_82041[(4)])));

return statearr_82051;
})();
var state_82041__$1 = state_82041;
var statearr_82052_82062 = state_82041__$1;
(statearr_82052_82062[(2)] = inst_82036);

(statearr_82052_82062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82042 === (7))){
var inst_82028 = (state_82041[(2)]);
var inst_82029 = fluree.db.util.async.throw_err.call(null,inst_82028);
var inst_82030 = fluree.db.query.range.collection.call(null,inst_82029,collection);
var state_82041__$1 = state_82041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82041__$1,(6),inst_82030);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$collectionFlakes_$_state_machine__10903__auto__ = null;
var flureenjs$collectionFlakes_$_state_machine__10903__auto____0 = (function (){
var statearr_82053 = [null,null,null,null,null,null,null,null];
(statearr_82053[(0)] = flureenjs$collectionFlakes_$_state_machine__10903__auto__);

(statearr_82053[(1)] = (1));

return statearr_82053;
});
var flureenjs$collectionFlakes_$_state_machine__10903__auto____1 = (function (state_82041){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_82041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e82054){var ex__10906__auto__ = e82054;
var statearr_82055_82063 = state_82041;
(statearr_82055_82063[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_82041[(4)]))){
var statearr_82056_82064 = state_82041;
(statearr_82056_82064[(1)] = cljs.core.first.call(null,(state_82041[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82065 = state_82041;
state_82041 = G__82065;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$collectionFlakes_$_state_machine__10903__auto__ = function(state_82041){
switch(arguments.length){
case 0:
return flureenjs$collectionFlakes_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$collectionFlakes_$_state_machine__10903__auto____1.call(this,state_82041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collectionFlakes_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collectionFlakes_$_state_machine__10903__auto____0;
flureenjs$collectionFlakes_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collectionFlakes_$_state_machine__10903__auto____1;
return flureenjs$collectionFlakes_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_82057 = f__10977__auto__.call(null);
(statearr_82057[(6)] = c__10976__auto__);

return statearr_82057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.collectionFlakes', flureenjs.collectionFlakes);
/**
 * Execute a graphql query against the specified database.
 */
flureenjs.graphql = (function flureenjs$graphql(var_args){
var G__82067 = arguments.length;
switch (G__82067) {
case 3:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.graphql', flureenjs.graphql);

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,param){
return flureenjs.graphql.call(null,conn,ledger,param,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,param,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_82169){
var state_val_82170 = (state_82169[(1)]);
if((state_val_82170 === (7))){
var state_82169__$1 = state_82169;
var statearr_82171_82223 = state_82169__$1;
(statearr_82171_82223[(2)] = null);

(statearr_82171_82223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (20))){
var inst_82086 = (state_82169[(7)]);
var inst_82097 = (state_82169[(8)]);
var inst_82093 = (state_82169[(9)]);
var inst_82118 = cljs.core.dissoc.call(null,inst_82097,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_82119 = cljs.core.assoc.call(null,inst_82118,new cljs.core.Keyword(null,"opts","opts",155075701),inst_82086);
var inst_82120 = fluree.db.api.query.history_query_async.call(null,inst_82093,inst_82119);
var state_82169__$1 = state_82169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82169__$1,(23),inst_82120);
} else {
if((state_val_82170 === (27))){
var inst_82132 = (state_82169[(2)]);
var inst_82133 = fluree.db.util.async.throw_err.call(null,inst_82132);
var state_82169__$1 = state_82169;
var statearr_82172_82224 = state_82169__$1;
(statearr_82172_82224[(2)] = inst_82133);

(statearr_82172_82224[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (1))){
var state_82169__$1 = state_82169;
var statearr_82173_82225 = state_82169__$1;
(statearr_82173_82225[(2)] = null);

(statearr_82173_82225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (24))){
var inst_82086 = (state_82169[(7)]);
var inst_82097 = (state_82169[(8)]);
var inst_82128 = cljs.core.dissoc.call(null,inst_82097,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_82129 = cljs.core.assoc.call(null,inst_82128,new cljs.core.Keyword(null,"opts","opts",155075701),inst_82086);
var inst_82130 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_82129);
var state_82169__$1 = state_82169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82169__$1,(27),inst_82130);
} else {
if((state_val_82170 === (4))){
var inst_82068 = (state_82169[(2)]);
var inst_82069 = fluree.db.util.log.error.call(null,inst_82068);
var inst_82070 = cljs.core.clj__GT_js.call(null,inst_82068);
var inst_82071 = reject.call(null,inst_82070);
var state_82169__$1 = (function (){var statearr_82174 = state_82169;
(statearr_82174[(10)] = inst_82069);

return statearr_82174;
})();
var statearr_82175_82226 = state_82169__$1;
(statearr_82175_82226[(2)] = inst_82071);

(statearr_82175_82226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (15))){
var inst_82097 = (state_82169[(8)]);
var inst_82115 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_82097);
var inst_82116 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"history","history",-247395220),inst_82115);
var state_82169__$1 = state_82169;
if(inst_82116){
var statearr_82176_82227 = state_82169__$1;
(statearr_82176_82227[(1)] = (20));

} else {
var statearr_82177_82228 = state_82169__$1;
(statearr_82177_82228[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (21))){
var inst_82097 = (state_82169[(8)]);
var inst_82125 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_82097);
var inst_82126 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),inst_82125);
var state_82169__$1 = state_82169;
if(inst_82126){
var statearr_82178_82229 = state_82169__$1;
(statearr_82178_82229[(1)] = (24));

} else {
var statearr_82179_82230 = state_82169__$1;
(statearr_82179_82230[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (31))){
var inst_82140 = (state_82169[(2)]);
var inst_82141 = fluree.db.util.async.throw_err.call(null,inst_82140);
var state_82169__$1 = state_82169;
var statearr_82180_82231 = state_82169__$1;
(statearr_82180_82231[(2)] = inst_82141);

(statearr_82180_82231[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (32))){
var inst_82086 = (state_82169[(7)]);
var inst_82097 = (state_82169[(8)]);
var inst_82090 = (state_82169[(11)]);
var inst_82144 = cljs.core.dissoc.call(null,inst_82097,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_82145 = cljs.core.assoc.call(null,inst_82144,new cljs.core.Keyword(null,"opts","opts",155075701),inst_82086);
var inst_82146 = fluree.db.api.query.multi_query_async.call(null,inst_82090,inst_82145);
var state_82169__$1 = state_82169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82169__$1,(35),inst_82146);
} else {
if((state_val_82170 === (33))){
var state_82169__$1 = state_82169;
var statearr_82181_82232 = state_82169__$1;
(statearr_82181_82232[(2)] = null);

(statearr_82181_82232[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (13))){
var inst_82162 = (state_82169[(2)]);
var inst_82163 = cljs.core.clj__GT_js.call(null,inst_82162);
var inst_82164 = resolve.call(null,inst_82163);
var _ = (function (){var statearr_82182 = state_82169;
(statearr_82182[(4)] = cljs.core.rest.call(null,(state_82169[(4)])));

return statearr_82182;
})();
var state_82169__$1 = state_82169;
var statearr_82183_82233 = state_82169__$1;
(statearr_82183_82233[(2)] = inst_82164);

(statearr_82183_82233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (22))){
var inst_82158 = (state_82169[(2)]);
var state_82169__$1 = state_82169;
var statearr_82184_82234 = state_82169__$1;
(statearr_82184_82234[(2)] = inst_82158);

(statearr_82184_82234[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (29))){
var state_82169__$1 = state_82169;
var statearr_82185_82235 = state_82169__$1;
(statearr_82185_82235[(1)] = (32));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (6))){
var inst_82082 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82169__$1 = state_82169;
var statearr_82187_82236 = state_82169__$1;
(statearr_82187_82236[(2)] = inst_82082);

(statearr_82187_82236[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (28))){
var inst_82086 = (state_82169[(7)]);
var inst_82097 = (state_82169[(8)]);
var inst_82137 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_82097);
var inst_82138 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_82137,inst_82086);
var state_82169__$1 = state_82169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82169__$1,(31),inst_82138);
} else {
if((state_val_82170 === (25))){
var inst_82097 = (state_82169[(8)]);
var inst_82135 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_82097);
var state_82169__$1 = state_82169;
if(cljs.core.truth_(inst_82135)){
var statearr_82188_82237 = state_82169__$1;
(statearr_82188_82237[(1)] = (28));

} else {
var statearr_82189_82238 = state_82169__$1;
(statearr_82189_82238[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (34))){
var inst_82152 = (state_82169[(2)]);
var state_82169__$1 = state_82169;
var statearr_82190_82239 = state_82169__$1;
(statearr_82190_82239[(2)] = inst_82152);

(statearr_82190_82239[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (17))){
var inst_82097 = (state_82169[(8)]);
var inst_82109 = cljs.core.dissoc.call(null,inst_82097,new cljs.core.Keyword(null,"type","type",1174270348));
var state_82169__$1 = state_82169;
var statearr_82191_82240 = state_82169__$1;
(statearr_82191_82240[(2)] = inst_82109);

(statearr_82191_82240[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (3))){
var inst_82167 = (state_82169[(2)]);
var state_82169__$1 = state_82169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82169__$1,inst_82167);
} else {
if((state_val_82170 === (12))){
var inst_82097 = (state_82169[(8)]);
var inst_82101 = [new cljs.core.Keyword(null,"__schema","__schema",-305244223),null,new cljs.core.Keyword(null,"__type","__type",1665433236),null];
var inst_82102 = (new cljs.core.PersistentArrayMap(null,2,inst_82101,null));
var inst_82103 = (new cljs.core.PersistentHashSet(null,inst_82102,null));
var inst_82104 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_82097);
var inst_82105 = inst_82103.call(null,inst_82104);
var state_82169__$1 = state_82169;
if(cljs.core.truth_(inst_82105)){
var statearr_82192_82241 = state_82169__$1;
(statearr_82192_82241[(1)] = (14));

} else {
var statearr_82193_82242 = state_82169__$1;
(statearr_82193_82242[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (2))){
var inst_82079 = (state_82169[(12)]);
var _ = (function (){var statearr_82194 = state_82169;
(statearr_82194[(4)] = cljs.core.cons.call(null,(5),(state_82169[(4)])));

return statearr_82194;
})();
var inst_82078 = fluree.db.util.json.parse.call(null,param);
var inst_82079__$1 = cljs.core.js__GT_clj.call(null,inst_82078,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_82080 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_82079__$1);
var state_82169__$1 = (function (){var statearr_82195 = state_82169;
(statearr_82195[(13)] = inst_82080);

(statearr_82195[(12)] = inst_82079__$1);

return statearr_82195;
})();
if(cljs.core.truth_(opts)){
var statearr_82196_82243 = state_82169__$1;
(statearr_82196_82243[(1)] = (6));

} else {
var statearr_82197_82244 = state_82169__$1;
(statearr_82197_82244[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (23))){
var inst_82122 = (state_82169[(2)]);
var inst_82123 = fluree.db.util.async.throw_err.call(null,inst_82122);
var state_82169__$1 = state_82169;
var statearr_82198_82245 = state_82169__$1;
(statearr_82198_82245[(2)] = inst_82123);

(statearr_82198_82245[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (35))){
var inst_82148 = (state_82169[(2)]);
var inst_82149 = fluree.db.util.async.throw_err.call(null,inst_82148);
var state_82169__$1 = state_82169;
var statearr_82199_82246 = state_82169__$1;
(statearr_82199_82246[(2)] = inst_82149);

(statearr_82199_82246[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (19))){
var inst_82113 = (state_82169[(2)]);
var state_82169__$1 = state_82169;
var statearr_82200_82247 = state_82169__$1;
(statearr_82200_82247[(2)] = inst_82113);

(statearr_82200_82247[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (11))){
var inst_82097 = (state_82169[(8)]);
var state_82169__$1 = state_82169;
var statearr_82202_82248 = state_82169__$1;
(statearr_82202_82248[(2)] = inst_82097);

(statearr_82202_82248[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (9))){
var inst_82088 = (state_82169[(14)]);
var inst_82089 = (state_82169[(15)]);
var inst_82086 = (state_82169[(7)]);
var inst_82093 = (state_82169[(9)]);
var inst_82092 = (state_82169[(2)]);
var inst_82093__$1 = fluree.db.util.async.throw_err.call(null,inst_82092);
var inst_82094 = fluree.db.query.graphql_parser.parse_graphql_to_flureeql.call(null,inst_82093__$1,inst_82088,inst_82089,inst_82086);
var state_82169__$1 = (function (){var statearr_82203 = state_82169;
(statearr_82203[(9)] = inst_82093__$1);

return statearr_82203;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82169__$1,(10),inst_82094);
} else {
if((state_val_82170 === (5))){
var _ = (function (){var statearr_82204 = state_82169;
(statearr_82204[(4)] = cljs.core.rest.call(null,(state_82169[(4)])));

return statearr_82204;
})();
var state_82169__$1 = state_82169;
var ex82201 = (state_82169__$1[(2)]);
var statearr_82205_82249 = state_82169__$1;
(statearr_82205_82249[(5)] = ex82201);


var statearr_82206_82250 = state_82169__$1;
(statearr_82206_82250[(1)] = (4));

(statearr_82206_82250[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (14))){
var inst_82086 = (state_82169[(7)]);
var inst_82107 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_82086);
var state_82169__$1 = state_82169;
if(cljs.core.truth_(inst_82107)){
var statearr_82207_82251 = state_82169__$1;
(statearr_82207_82251[(1)] = (17));

} else {
var statearr_82208_82252 = state_82169__$1;
(statearr_82208_82252[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (26))){
var inst_82156 = (state_82169[(2)]);
var state_82169__$1 = state_82169;
var statearr_82209_82253 = state_82169__$1;
(statearr_82209_82253[(2)] = inst_82156);

(statearr_82209_82253[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (16))){
var inst_82160 = (state_82169[(2)]);
var state_82169__$1 = state_82169;
var statearr_82210_82254 = state_82169__$1;
(statearr_82210_82254[(2)] = inst_82160);

(statearr_82210_82254[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (30))){
var inst_82154 = (state_82169[(2)]);
var state_82169__$1 = state_82169;
var statearr_82211_82255 = state_82169__$1;
(statearr_82211_82255[(2)] = inst_82154);

(statearr_82211_82255[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (10))){
var inst_82097 = (state_82169[(8)]);
var inst_82096 = (state_82169[(2)]);
var inst_82097__$1 = fluree.db.util.async.throw_err.call(null,inst_82096);
var inst_82098 = fluree.db.util.core.exception_QMARK_.call(null,inst_82097__$1);
var state_82169__$1 = (function (){var statearr_82212 = state_82169;
(statearr_82212[(8)] = inst_82097__$1);

return statearr_82212;
})();
if(inst_82098){
var statearr_82213_82256 = state_82169__$1;
(statearr_82213_82256[(1)] = (11));

} else {
var statearr_82214_82257 = state_82169__$1;
(statearr_82214_82257[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (18))){
var inst_82097 = (state_82169[(8)]);
var inst_82111 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_82097);
var state_82169__$1 = state_82169;
var statearr_82215_82258 = state_82169__$1;
(statearr_82215_82258[(2)] = inst_82111);

(statearr_82215_82258[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82170 === (8))){
var inst_82086 = (state_82169[(7)]);
var inst_82080 = (state_82169[(13)]);
var inst_82079 = (state_82169[(12)]);
var inst_82090 = (state_82169[(11)]);
var inst_82085 = (state_82169[(2)]);
var inst_82086__$1 = cljs.core.merge.call(null,inst_82080,inst_82085);
var inst_82087 = cljs.core.__destructure_map.call(null,inst_82079);
var inst_82088 = cljs.core.get.call(null,inst_82087,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_82089 = cljs.core.get.call(null,inst_82087,new cljs.core.Keyword(null,"variables","variables",1563680814));
var inst_82090__$1 = flureenjs._db_instance.call(null,conn,ledger,inst_82086__$1);
var state_82169__$1 = (function (){var statearr_82216 = state_82169;
(statearr_82216[(14)] = inst_82088);

(statearr_82216[(15)] = inst_82089);

(statearr_82216[(7)] = inst_82086__$1);

(statearr_82216[(11)] = inst_82090__$1);

return statearr_82216;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82169__$1,(9),inst_82090__$1);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_82217 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82217[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_82217[(1)] = (1));

return statearr_82217;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_82169){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_82169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e82218){var ex__10906__auto__ = e82218;
var statearr_82219_82259 = state_82169;
(statearr_82219_82259[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_82169[(4)]))){
var statearr_82220_82260 = state_82169;
(statearr_82220_82260[(1)] = cljs.core.first.call(null,(state_82169[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82261 = state_82169;
state_82169 = G__82261;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_82169){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_82169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_82221 = f__10977__auto__.call(null);
(statearr_82221[(6)] = c__10976__auto__);

return statearr_82221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.graphql.cljs$lang$maxFixedArity = 4);

flureenjs.historyQuery = (function flureenjs$historyQuery(var_args){
var G__82263 = arguments.length;
switch (G__82263) {
case 2:
return flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.historyQuery', flureenjs.historyQuery);

(flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return flureenjs.historyQuery.call(null,sources,query_map,null);
}));

(flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_82290){
var state_val_82291 = (state_82290[(1)]);
if((state_val_82291 === (1))){
var state_82290__$1 = state_82290;
var statearr_82292_82308 = state_82290__$1;
(statearr_82292_82308[(2)] = null);

(statearr_82292_82308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82291 === (2))){
var _ = (function (){var statearr_82293 = state_82290;
(statearr_82293[(4)] = cljs.core.cons.call(null,(5),(state_82290[(4)])));

return statearr_82293;
})();
var inst_82272 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_82273 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_82272);
var inst_82274 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_82275 = cljs.core.merge.call(null,inst_82273,inst_82274);
var inst_82276 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_82277 = [inst_82275];
var inst_82278 = cljs.core.PersistentHashMap.fromArrays(inst_82276,inst_82277);
var inst_82279 = cljs.core.merge.call(null,inst_82272,inst_82278);
var inst_82280 = fluree.db.api.query.history_query_async.call(null,sources,inst_82279);
var state_82290__$1 = state_82290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82290__$1,(6),inst_82280);
} else {
if((state_val_82291 === (3))){
var inst_82288 = (state_82290[(2)]);
var state_82290__$1 = state_82290;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82290__$1,inst_82288);
} else {
if((state_val_82291 === (4))){
var inst_82264 = (state_82290[(2)]);
var inst_82265 = fluree.db.util.log.error.call(null,inst_82264);
var inst_82266 = reject.call(null,inst_82264);
var state_82290__$1 = (function (){var statearr_82295 = state_82290;
(statearr_82295[(7)] = inst_82265);

return statearr_82295;
})();
var statearr_82296_82309 = state_82290__$1;
(statearr_82296_82309[(2)] = inst_82266);

(statearr_82296_82309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82291 === (5))){
var _ = (function (){var statearr_82297 = state_82290;
(statearr_82297[(4)] = cljs.core.rest.call(null,(state_82290[(4)])));

return statearr_82297;
})();
var state_82290__$1 = state_82290;
var ex82294 = (state_82290__$1[(2)]);
var statearr_82298_82310 = state_82290__$1;
(statearr_82298_82310[(5)] = ex82294);


var statearr_82299_82311 = state_82290__$1;
(statearr_82299_82311[(1)] = (4));

(statearr_82299_82311[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82291 === (6))){
var inst_82282 = (state_82290[(2)]);
var inst_82283 = fluree.db.util.async.throw_err.call(null,inst_82282);
var inst_82284 = cljs.core.clj__GT_js.call(null,inst_82283);
var inst_82285 = resolve.call(null,inst_82284);
var _ = (function (){var statearr_82300 = state_82290;
(statearr_82300[(4)] = cljs.core.rest.call(null,(state_82290[(4)])));

return statearr_82300;
})();
var state_82290__$1 = state_82290;
var statearr_82301_82312 = state_82290__$1;
(statearr_82301_82312[(2)] = inst_82285);

(statearr_82301_82312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_82302 = [null,null,null,null,null,null,null,null];
(statearr_82302[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_82302[(1)] = (1));

return statearr_82302;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_82290){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_82290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e82303){var ex__10906__auto__ = e82303;
var statearr_82304_82313 = state_82290;
(statearr_82304_82313[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_82290[(4)]))){
var statearr_82305_82314 = state_82290;
(statearr_82305_82314[(1)] = cljs.core.first.call(null,(state_82290[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82315 = state_82290;
state_82290 = G__82315;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_82290){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_82290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_82306 = f__10977__auto__.call(null);
(statearr_82306[(6)] = c__10976__auto__);

return statearr_82306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.historyQuery.cljs$lang$maxFixedArity = 3);

flureenjs.multiQuery = (function flureenjs$multiQuery(var_args){
var G__82317 = arguments.length;
switch (G__82317) {
case 2:
return flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.multiQuery', flureenjs.multiQuery);

(flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$2 = (function (source,multi_query_map){
return flureenjs.multiQuery.call(null,source,multi_query_map,null);
}));

(flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$3 = (function (source,multi_query_map,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_82344){
var state_val_82345 = (state_82344[(1)]);
if((state_val_82345 === (1))){
var state_82344__$1 = state_82344;
var statearr_82346_82362 = state_82344__$1;
(statearr_82346_82362[(2)] = null);

(statearr_82346_82362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82345 === (2))){
var _ = (function (){var statearr_82347 = state_82344;
(statearr_82347[(4)] = cljs.core.cons.call(null,(5),(state_82344[(4)])));

return statearr_82347;
})();
var inst_82326 = cljs.core.js__GT_clj.call(null,multi_query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_82327 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_82326);
var inst_82328 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_82329 = cljs.core.merge.call(null,inst_82327,inst_82328);
var inst_82330 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_82331 = [inst_82329];
var inst_82332 = cljs.core.PersistentHashMap.fromArrays(inst_82330,inst_82331);
var inst_82333 = cljs.core.merge.call(null,inst_82326,inst_82332);
var inst_82334 = fluree.db.api.query.multi_query_async.call(null,source,inst_82333);
var state_82344__$1 = state_82344;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82344__$1,(6),inst_82334);
} else {
if((state_val_82345 === (3))){
var inst_82342 = (state_82344[(2)]);
var state_82344__$1 = state_82344;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82344__$1,inst_82342);
} else {
if((state_val_82345 === (4))){
var inst_82318 = (state_82344[(2)]);
var inst_82319 = fluree.db.util.log.error.call(null,inst_82318);
var inst_82320 = reject.call(null,inst_82318);
var state_82344__$1 = (function (){var statearr_82349 = state_82344;
(statearr_82349[(7)] = inst_82319);

return statearr_82349;
})();
var statearr_82350_82363 = state_82344__$1;
(statearr_82350_82363[(2)] = inst_82320);

(statearr_82350_82363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82345 === (5))){
var _ = (function (){var statearr_82351 = state_82344;
(statearr_82351[(4)] = cljs.core.rest.call(null,(state_82344[(4)])));

return statearr_82351;
})();
var state_82344__$1 = state_82344;
var ex82348 = (state_82344__$1[(2)]);
var statearr_82352_82364 = state_82344__$1;
(statearr_82352_82364[(5)] = ex82348);


var statearr_82353_82365 = state_82344__$1;
(statearr_82353_82365[(1)] = (4));

(statearr_82353_82365[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82345 === (6))){
var inst_82336 = (state_82344[(2)]);
var inst_82337 = fluree.db.util.async.throw_err.call(null,inst_82336);
var inst_82338 = cljs.core.clj__GT_js.call(null,inst_82337);
var inst_82339 = resolve.call(null,inst_82338);
var _ = (function (){var statearr_82354 = state_82344;
(statearr_82354[(4)] = cljs.core.rest.call(null,(state_82344[(4)])));

return statearr_82354;
})();
var state_82344__$1 = state_82344;
var statearr_82355_82366 = state_82344__$1;
(statearr_82355_82366[(2)] = inst_82339);

(statearr_82355_82366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_82356 = [null,null,null,null,null,null,null,null];
(statearr_82356[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_82356[(1)] = (1));

return statearr_82356;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_82344){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_82344);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e82357){var ex__10906__auto__ = e82357;
var statearr_82358_82367 = state_82344;
(statearr_82358_82367[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_82344[(4)]))){
var statearr_82359_82368 = state_82344;
(statearr_82359_82368[(1)] = cljs.core.first.call(null,(state_82344[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82369 = state_82344;
state_82344 = G__82369;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_82344){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_82344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_82360 = f__10977__auto__.call(null);
(statearr_82360[(6)] = c__10976__auto__);

return statearr_82360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.multiQuery.cljs$lang$maxFixedArity = 3);

/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise that eventually contains the results or
 *   an exception.
 */
flureenjs.query = (function flureenjs$query(source,query_map){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_82390){
var state_val_82391 = (state_82390[(1)]);
if((state_val_82391 === (1))){
var state_82390__$1 = state_82390;
var statearr_82392_82407 = state_82390__$1;
(statearr_82392_82407[(2)] = null);

(statearr_82392_82407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82391 === (2))){
var _ = (function (){var statearr_82393 = state_82390;
(statearr_82393[(4)] = cljs.core.cons.call(null,(5),(state_82390[(4)])));

return statearr_82393;
})();
var inst_82379 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_82380 = fluree.db.api.query.query.call(null,source,inst_82379);
var state_82390__$1 = state_82390;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82390__$1,(6),inst_82380);
} else {
if((state_val_82391 === (3))){
var inst_82388 = (state_82390[(2)]);
var state_82390__$1 = state_82390;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82390__$1,inst_82388);
} else {
if((state_val_82391 === (4))){
var inst_82370 = (state_82390[(2)]);
var inst_82371 = fluree.db.util.log.error.call(null,inst_82370);
var inst_82372 = cljs.core.clj__GT_js.call(null,inst_82370);
var inst_82373 = reject.call(null,inst_82372);
var state_82390__$1 = (function (){var statearr_82395 = state_82390;
(statearr_82395[(7)] = inst_82371);

return statearr_82395;
})();
var statearr_82396_82408 = state_82390__$1;
(statearr_82396_82408[(2)] = inst_82373);

(statearr_82396_82408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82391 === (5))){
var _ = (function (){var statearr_82397 = state_82390;
(statearr_82397[(4)] = cljs.core.rest.call(null,(state_82390[(4)])));

return statearr_82397;
})();
var state_82390__$1 = state_82390;
var ex82394 = (state_82390__$1[(2)]);
var statearr_82398_82409 = state_82390__$1;
(statearr_82398_82409[(5)] = ex82394);


var statearr_82399_82410 = state_82390__$1;
(statearr_82399_82410[(1)] = (4));

(statearr_82399_82410[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82391 === (6))){
var inst_82382 = (state_82390[(2)]);
var inst_82383 = fluree.db.util.async.throw_err.call(null,inst_82382);
var inst_82384 = cljs.core.clj__GT_js.call(null,inst_82383);
var inst_82385 = resolve.call(null,inst_82384);
var _ = (function (){var statearr_82400 = state_82390;
(statearr_82400[(4)] = cljs.core.rest.call(null,(state_82390[(4)])));

return statearr_82400;
})();
var state_82390__$1 = state_82390;
var statearr_82401_82411 = state_82390__$1;
(statearr_82401_82411[(2)] = inst_82385);

(statearr_82401_82411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$query_$_state_machine__10903__auto__ = null;
var flureenjs$query_$_state_machine__10903__auto____0 = (function (){
var statearr_82402 = [null,null,null,null,null,null,null,null];
(statearr_82402[(0)] = flureenjs$query_$_state_machine__10903__auto__);

(statearr_82402[(1)] = (1));

return statearr_82402;
});
var flureenjs$query_$_state_machine__10903__auto____1 = (function (state_82390){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_82390);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e82403){var ex__10906__auto__ = e82403;
var statearr_82404_82412 = state_82390;
(statearr_82404_82412[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_82390[(4)]))){
var statearr_82405_82413 = state_82390;
(statearr_82405_82413[(1)] = cljs.core.first.call(null,(state_82390[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82414 = state_82390;
state_82390 = G__82414;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$query_$_state_machine__10903__auto__ = function(state_82390){
switch(arguments.length){
case 0:
return flureenjs$query_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$query_$_state_machine__10903__auto____1.call(this,state_82390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$query_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$query_$_state_machine__10903__auto____0;
flureenjs$query_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$query_$_state_machine__10903__auto____1;
return flureenjs$query_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_82406 = f__10977__auto__.call(null);
(statearr_82406[(6)] = c__10976__auto__);

return statearr_82406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.query', flureenjs.query);
/**
 * Execute a query against a database source, with the
 *   given flakes applied.
 * 
 *   Returns promise that eventually contains the results or
 *   an exception.
 */
flureenjs.queryWith = (function flureenjs$queryWith(db,param){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_82444){
var state_val_82445 = (state_82444[(1)]);
if((state_val_82445 === (1))){
var state_82444__$1 = state_82444;
var statearr_82446_82462 = state_82444__$1;
(statearr_82446_82462[(2)] = null);

(statearr_82446_82462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82445 === (2))){
var _ = (function (){var statearr_82447 = state_82444;
(statearr_82447[(4)] = cljs.core.cons.call(null,(5),(state_82444[(4)])));

return statearr_82447;
})();
var inst_82425 = cljs.core.js__GT_clj.call(null,param,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_82426 = cljs.core.__destructure_map.call(null,inst_82425);
var inst_82427 = cljs.core.get.call(null,inst_82426,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_82428 = cljs.core.get.call(null,inst_82426,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_82429 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_82428);
var state_82444__$1 = (function (){var statearr_82448 = state_82444;
(statearr_82448[(7)] = inst_82429);

(statearr_82448[(8)] = inst_82427);

return statearr_82448;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82444__$1,(6),db);
} else {
if((state_val_82445 === (3))){
var inst_82442 = (state_82444[(2)]);
var state_82444__$1 = state_82444;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82444__$1,inst_82442);
} else {
if((state_val_82445 === (4))){
var inst_82415 = (state_82444[(2)]);
var inst_82416 = fluree.db.util.log.error.call(null,inst_82415);
var inst_82417 = cljs.core.clj__GT_js.call(null,inst_82415);
var inst_82418 = reject.call(null,inst_82417);
var state_82444__$1 = (function (){var statearr_82450 = state_82444;
(statearr_82450[(9)] = inst_82416);

return statearr_82450;
})();
var statearr_82451_82463 = state_82444__$1;
(statearr_82451_82463[(2)] = inst_82418);

(statearr_82451_82463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82445 === (5))){
var _ = (function (){var statearr_82452 = state_82444;
(statearr_82452[(4)] = cljs.core.rest.call(null,(state_82444[(4)])));

return statearr_82452;
})();
var state_82444__$1 = state_82444;
var ex82449 = (state_82444__$1[(2)]);
var statearr_82453_82464 = state_82444__$1;
(statearr_82453_82464[(5)] = ex82449);


var statearr_82454_82465 = state_82444__$1;
(statearr_82454_82465[(1)] = (4));

(statearr_82454_82465[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82445 === (6))){
var inst_82429 = (state_82444[(7)]);
var inst_82427 = (state_82444[(8)]);
var inst_82431 = (state_82444[(2)]);
var inst_82432 = fluree.db.util.async.throw_err.call(null,inst_82431);
var inst_82433 = fluree.db.dbproto._forward_time_travel.call(null,inst_82432,inst_82429);
var inst_82434 = fluree.db.api.query.query.call(null,inst_82433,inst_82427);
var state_82444__$1 = state_82444;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82444__$1,(7),inst_82434);
} else {
if((state_val_82445 === (7))){
var inst_82436 = (state_82444[(2)]);
var inst_82437 = fluree.db.util.async.throw_err.call(null,inst_82436);
var inst_82438 = cljs.core.clj__GT_js.call(null,inst_82437);
var inst_82439 = resolve.call(null,inst_82438);
var _ = (function (){var statearr_82455 = state_82444;
(statearr_82455[(4)] = cljs.core.rest.call(null,(state_82444[(4)])));

return statearr_82455;
})();
var state_82444__$1 = state_82444;
var statearr_82456_82466 = state_82444__$1;
(statearr_82456_82466[(2)] = inst_82439);

(statearr_82456_82466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$queryWith_$_state_machine__10903__auto__ = null;
var flureenjs$queryWith_$_state_machine__10903__auto____0 = (function (){
var statearr_82457 = [null,null,null,null,null,null,null,null,null,null];
(statearr_82457[(0)] = flureenjs$queryWith_$_state_machine__10903__auto__);

(statearr_82457[(1)] = (1));

return statearr_82457;
});
var flureenjs$queryWith_$_state_machine__10903__auto____1 = (function (state_82444){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_82444);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e82458){var ex__10906__auto__ = e82458;
var statearr_82459_82467 = state_82444;
(statearr_82459_82467[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_82444[(4)]))){
var statearr_82460_82468 = state_82444;
(statearr_82460_82468[(1)] = cljs.core.first.call(null,(state_82444[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82469 = state_82444;
state_82444 = G__82469;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$queryWith_$_state_machine__10903__auto__ = function(state_82444){
switch(arguments.length){
case 0:
return flureenjs$queryWith_$_state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$queryWith_$_state_machine__10903__auto____1.call(this,state_82444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$queryWith_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$queryWith_$_state_machine__10903__auto____0;
flureenjs$queryWith_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$queryWith_$_state_machine__10903__auto____1;
return flureenjs$queryWith_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_82461 = f__10977__auto__.call(null);
(statearr_82461[(6)] = c__10976__auto__);

return statearr_82461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
goog.exportSymbol('flureenjs.queryWith', flureenjs.queryWith);
/**
 * Exceute a sparql query against a specified database
 */
flureenjs.sparql = (function flureenjs$sparql(var_args){
var G__82471 = arguments.length;
switch (G__82471) {
case 2:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sparql', flureenjs.sparql);

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$2 = (function (db,sparql_str){
return flureenjs.sparql.call(null,db,sparql_str,null);
}));

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$3 = (function (db,sparql_str,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_82501){
var state_val_82502 = (state_82501[(1)]);
if((state_val_82502 === (7))){
var state_82501__$1 = state_82501;
var statearr_82503_82524 = state_82501__$1;
(statearr_82503_82524[(2)] = null);

(statearr_82503_82524[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82502 === (1))){
var state_82501__$1 = state_82501;
var statearr_82504_82525 = state_82501__$1;
(statearr_82504_82525[(2)] = null);

(statearr_82504_82525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82502 === (4))){
var inst_82472 = (state_82501[(2)]);
var inst_82473 = fluree.db.util.log.error.call(null,inst_82472);
var inst_82474 = cljs.core.clj__GT_js.call(null,inst_82472);
var inst_82475 = reject.call(null,inst_82474);
var state_82501__$1 = (function (){var statearr_82505 = state_82501;
(statearr_82505[(7)] = inst_82473);

return statearr_82505;
})();
var statearr_82506_82526 = state_82501__$1;
(statearr_82506_82526[(2)] = inst_82475);

(statearr_82506_82526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82502 === (6))){
var inst_82485 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82501__$1 = state_82501;
var statearr_82507_82527 = state_82501__$1;
(statearr_82507_82527[(2)] = inst_82485);

(statearr_82507_82527[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82502 === (3))){
var inst_82499 = (state_82501[(2)]);
var state_82501__$1 = state_82501;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82501__$1,inst_82499);
} else {
if((state_val_82502 === (2))){
var inst_82482 = (state_82501[(8)]);
var _ = (function (){var statearr_82509 = state_82501;
(statearr_82509[(4)] = cljs.core.cons.call(null,(5),(state_82501[(4)])));

return statearr_82509;
})();
var inst_82481 = fluree.db.util.json.parse.call(null,sparql_str);
var inst_82482__$1 = fluree.db.query.sparql_parser.sparql_to_ad_hoc.call(null,inst_82481);
var inst_82483 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_82482__$1);
var state_82501__$1 = (function (){var statearr_82510 = state_82501;
(statearr_82510[(8)] = inst_82482__$1);

(statearr_82510[(9)] = inst_82483);

return statearr_82510;
})();
if(cljs.core.truth_(opts)){
var statearr_82511_82528 = state_82501__$1;
(statearr_82511_82528[(1)] = (6));

} else {
var statearr_82512_82529 = state_82501__$1;
(statearr_82512_82529[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82502 === (9))){
var inst_82493 = (state_82501[(2)]);
var inst_82494 = fluree.db.util.async.throw_err.call(null,inst_82493);
var inst_82495 = cljs.core.clj__GT_js.call(null,inst_82494);
var inst_82496 = resolve.call(null,inst_82495);
var _ = (function (){var statearr_82513 = state_82501;
(statearr_82513[(4)] = cljs.core.rest.call(null,(state_82501[(4)])));

return statearr_82513;
})();
var state_82501__$1 = state_82501;
var statearr_82514_82530 = state_82501__$1;
(statearr_82514_82530[(2)] = inst_82496);

(statearr_82514_82530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82502 === (5))){
var _ = (function (){var statearr_82515 = state_82501;
(statearr_82515[(4)] = cljs.core.rest.call(null,(state_82501[(4)])));

return statearr_82515;
})();
var state_82501__$1 = state_82501;
var ex82508 = (state_82501__$1[(2)]);
var statearr_82516_82531 = state_82501__$1;
(statearr_82516_82531[(5)] = ex82508);


var statearr_82517_82532 = state_82501__$1;
(statearr_82517_82532[(1)] = (4));

(statearr_82517_82532[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82502 === (8))){
var inst_82482 = (state_82501[(8)]);
var inst_82483 = (state_82501[(9)]);
var inst_82488 = (state_82501[(2)]);
var inst_82489 = cljs.core.merge.call(null,inst_82483,inst_82488);
var inst_82490 = cljs.core.assoc.call(null,inst_82482,new cljs.core.Keyword(null,"opts","opts",155075701),inst_82489);
var inst_82491 = fluree.db.api.query.query_async.call(null,db,inst_82490);
var state_82501__$1 = state_82501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82501__$1,(9),inst_82491);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_82518 = [null,null,null,null,null,null,null,null,null,null];
(statearr_82518[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_82518[(1)] = (1));

return statearr_82518;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_82501){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_82501);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e82519){var ex__10906__auto__ = e82519;
var statearr_82520_82533 = state_82501;
(statearr_82520_82533[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_82501[(4)]))){
var statearr_82521_82534 = state_82501;
(statearr_82521_82534[(1)] = cljs.core.first.call(null,(state_82501[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82535 = state_82501;
state_82501 = G__82535;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_82501){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_82501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_82522 = f__10977__auto__.call(null);
(statearr_82522[(6)] = c__10976__auto__);

return statearr_82522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.sparql.cljs$lang$maxFixedArity = 3);

/**
 * Exceute a sql query against a specified database
 */
flureenjs.sql = (function flureenjs$sql(var_args){
var G__82537 = arguments.length;
switch (G__82537) {
case 2:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sql', flureenjs.sql);

(flureenjs.sql.cljs$core$IFn$_invoke$arity$2 = (function (db,sql_str){
return flureenjs.sql.call(null,db,sql_str,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.sql.cljs$core$IFn$_invoke$arity$3 = (function (db,sql_str,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_82561){
var state_val_82562 = (state_82561[(1)]);
if((state_val_82562 === (1))){
var state_82561__$1 = state_82561;
var statearr_82563_82579 = state_82561__$1;
(statearr_82563_82579[(2)] = null);

(statearr_82563_82579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82562 === (2))){
var _ = (function (){var statearr_82564 = state_82561;
(statearr_82564[(4)] = cljs.core.cons.call(null,(5),(state_82561[(4)])));

return statearr_82564;
})();
var inst_82547 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_82548 = fluree.db.util.json.parse.call(null,sql_str);
var inst_82549 = fluree.db.query.sql.parse.call(null,inst_82548);
var inst_82550 = cljs.core.update.call(null,inst_82549,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_82547);
var inst_82551 = fluree.db.api.query.query_async.call(null,db,inst_82550);
var state_82561__$1 = state_82561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82561__$1,(6),inst_82551);
} else {
if((state_val_82562 === (3))){
var inst_82559 = (state_82561[(2)]);
var state_82561__$1 = state_82561;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82561__$1,inst_82559);
} else {
if((state_val_82562 === (4))){
var inst_82538 = (state_82561[(2)]);
var inst_82539 = fluree.db.util.log.error.call(null,inst_82538);
var inst_82540 = cljs.core.clj__GT_js.call(null,inst_82538);
var inst_82541 = reject.call(null,inst_82540);
var state_82561__$1 = (function (){var statearr_82566 = state_82561;
(statearr_82566[(7)] = inst_82539);

return statearr_82566;
})();
var statearr_82567_82580 = state_82561__$1;
(statearr_82567_82580[(2)] = inst_82541);

(statearr_82567_82580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82562 === (5))){
var _ = (function (){var statearr_82568 = state_82561;
(statearr_82568[(4)] = cljs.core.rest.call(null,(state_82561[(4)])));

return statearr_82568;
})();
var state_82561__$1 = state_82561;
var ex82565 = (state_82561__$1[(2)]);
var statearr_82569_82581 = state_82561__$1;
(statearr_82569_82581[(5)] = ex82565);


var statearr_82570_82582 = state_82561__$1;
(statearr_82570_82582[(1)] = (4));

(statearr_82570_82582[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82562 === (6))){
var inst_82553 = (state_82561[(2)]);
var inst_82554 = fluree.db.util.async.throw_err.call(null,inst_82553);
var inst_82555 = cljs.core.clj__GT_js.call(null,inst_82554);
var inst_82556 = resolve.call(null,inst_82555);
var _ = (function (){var statearr_82571 = state_82561;
(statearr_82571[(4)] = cljs.core.rest.call(null,(state_82561[(4)])));

return statearr_82571;
})();
var state_82561__$1 = state_82561;
var statearr_82572_82583 = state_82561__$1;
(statearr_82572_82583[(2)] = inst_82556);

(statearr_82572_82583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__10903__auto__ = null;
var flureenjs$state_machine__10903__auto____0 = (function (){
var statearr_82573 = [null,null,null,null,null,null,null,null];
(statearr_82573[(0)] = flureenjs$state_machine__10903__auto__);

(statearr_82573[(1)] = (1));

return statearr_82573;
});
var flureenjs$state_machine__10903__auto____1 = (function (state_82561){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_82561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e82574){var ex__10906__auto__ = e82574;
var statearr_82575_82584 = state_82561;
(statearr_82575_82584[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_82561[(4)]))){
var statearr_82576_82585 = state_82561;
(statearr_82576_82585[(1)] = cljs.core.first.call(null,(state_82561[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82586 = state_82561;
state_82561 = G__82586;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
flureenjs$state_machine__10903__auto__ = function(state_82561){
switch(arguments.length){
case 0:
return flureenjs$state_machine__10903__auto____0.call(this);
case 1:
return flureenjs$state_machine__10903__auto____1.call(this,state_82561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__10903__auto____0;
flureenjs$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__10903__auto____1;
return flureenjs$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_82577 = f__10977__auto__.call(null);
(statearr_82577[(6)] = c__10976__auto__);

return statearr_82577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(flureenjs.sql.cljs$lang$maxFixedArity = 3);

