// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__11544 = arguments.length;
switch (G__11544) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11545 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11545 = (function (f,blockable,meta11546){
this.f = f;
this.blockable = blockable;
this.meta11546 = meta11546;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11545.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11547,meta11546__$1){
var self__ = this;
var _11547__$1 = this;
return (new cljs.core.async.t_cljs$core$async11545(self__.f,self__.blockable,meta11546__$1));
}));

(cljs.core.async.t_cljs$core$async11545.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11547){
var self__ = this;
var _11547__$1 = this;
return self__.meta11546;
}));

(cljs.core.async.t_cljs$core$async11545.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11545.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11545.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async11545.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async11545.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11546","meta11546",1691175450,null)], null);
}));

(cljs.core.async.t_cljs$core$async11545.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11545.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11545");

(cljs.core.async.t_cljs$core$async11545.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async11545");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11545.
 */
cljs.core.async.__GT_t_cljs$core$async11545 = (function cljs$core$async$__GT_t_cljs$core$async11545(f__$1,blockable__$1,meta11546){
return (new cljs.core.async.t_cljs$core$async11545(f__$1,blockable__$1,meta11546));
});

}

return (new cljs.core.async.t_cljs$core$async11545(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__11551 = arguments.length;
switch (G__11551) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__11554 = arguments.length;
switch (G__11554) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__11557 = arguments.length;
switch (G__11557) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_11559 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_11559) : fn1.call(null,val_11559));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_11559) : fn1.call(null,val_11559));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__11561 = arguments.length;
switch (G__11561) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___11563 = n;
var x_11564 = (0);
while(true){
if((x_11564 < n__4741__auto___11563)){
(a[x_11564] = x_11564);

var G__11565 = (x_11564 + (1));
x_11564 = G__11565;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11566 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11566 = (function (flag,meta11567){
this.flag = flag;
this.meta11567 = meta11567;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11566.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11568,meta11567__$1){
var self__ = this;
var _11568__$1 = this;
return (new cljs.core.async.t_cljs$core$async11566(self__.flag,meta11567__$1));
}));

(cljs.core.async.t_cljs$core$async11566.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11568){
var self__ = this;
var _11568__$1 = this;
return self__.meta11567;
}));

(cljs.core.async.t_cljs$core$async11566.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11566.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async11566.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11566.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async11566.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11567","meta11567",78666280,null)], null);
}));

(cljs.core.async.t_cljs$core$async11566.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11566.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11566");

(cljs.core.async.t_cljs$core$async11566.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async11566");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11566.
 */
cljs.core.async.__GT_t_cljs$core$async11566 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11566(flag__$1,meta11567){
return (new cljs.core.async.t_cljs$core$async11566(flag__$1,meta11567));
});

}

return (new cljs.core.async.t_cljs$core$async11566(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11569 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11569 = (function (flag,cb,meta11570){
this.flag = flag;
this.cb = cb;
this.meta11570 = meta11570;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11569.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11571,meta11570__$1){
var self__ = this;
var _11571__$1 = this;
return (new cljs.core.async.t_cljs$core$async11569(self__.flag,self__.cb,meta11570__$1));
}));

(cljs.core.async.t_cljs$core$async11569.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11571){
var self__ = this;
var _11571__$1 = this;
return self__.meta11570;
}));

(cljs.core.async.t_cljs$core$async11569.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11569.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async11569.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11569.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async11569.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11570","meta11570",-157952667,null)], null);
}));

(cljs.core.async.t_cljs$core$async11569.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11569.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11569");

(cljs.core.async.t_cljs$core$async11569.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async11569");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11569.
 */
cljs.core.async.__GT_t_cljs$core$async11569 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11569(flag__$1,cb__$1,meta11570){
return (new cljs.core.async.t_cljs$core$async11569(flag__$1,cb__$1,meta11570));
});

}

return (new cljs.core.async.t_cljs$core$async11569(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11572_SHARP_){
var G__11574 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11572_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__11574) : fret.call(null,G__11574));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11573_SHARP_){
var G__11575 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11573_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__11575) : fret.call(null,G__11575));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11576 = (i + (1));
i = G__11576;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4251__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4251__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___11581 = arguments.length;
var i__4865__auto___11582 = (0);
while(true){
if((i__4865__auto___11582 < len__4864__auto___11581)){
args__4870__auto__.push((arguments[i__4865__auto___11582]));

var G__11583 = (i__4865__auto___11582 + (1));
i__4865__auto___11582 = G__11583;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11579){
var map__11580 = p__11579;
var map__11580__$1 = cljs.core.__destructure_map(map__11580);
var opts = map__11580__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11577){
var G__11578 = cljs.core.first(seq11577);
var seq11577__$1 = cljs.core.next(seq11577);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11578,seq11577__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__11585 = arguments.length;
switch (G__11585) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11484__auto___11632 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_11609){
var state_val_11610 = (state_11609[(1)]);
if((state_val_11610 === (7))){
var inst_11605 = (state_11609[(2)]);
var state_11609__$1 = state_11609;
var statearr_11611_11633 = state_11609__$1;
(statearr_11611_11633[(2)] = inst_11605);

(statearr_11611_11633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11610 === (1))){
var state_11609__$1 = state_11609;
var statearr_11612_11634 = state_11609__$1;
(statearr_11612_11634[(2)] = null);

(statearr_11612_11634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11610 === (4))){
var inst_11588 = (state_11609[(7)]);
var inst_11588__$1 = (state_11609[(2)]);
var inst_11589 = (inst_11588__$1 == null);
var state_11609__$1 = (function (){var statearr_11613 = state_11609;
(statearr_11613[(7)] = inst_11588__$1);

return statearr_11613;
})();
if(cljs.core.truth_(inst_11589)){
var statearr_11614_11635 = state_11609__$1;
(statearr_11614_11635[(1)] = (5));

} else {
var statearr_11615_11636 = state_11609__$1;
(statearr_11615_11636[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11610 === (13))){
var state_11609__$1 = state_11609;
var statearr_11616_11637 = state_11609__$1;
(statearr_11616_11637[(2)] = null);

(statearr_11616_11637[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11610 === (6))){
var inst_11588 = (state_11609[(7)]);
var state_11609__$1 = state_11609;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11609__$1,(11),to,inst_11588);
} else {
if((state_val_11610 === (3))){
var inst_11607 = (state_11609[(2)]);
var state_11609__$1 = state_11609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11609__$1,inst_11607);
} else {
if((state_val_11610 === (12))){
var state_11609__$1 = state_11609;
var statearr_11617_11638 = state_11609__$1;
(statearr_11617_11638[(2)] = null);

(statearr_11617_11638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11610 === (2))){
var state_11609__$1 = state_11609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11609__$1,(4),from);
} else {
if((state_val_11610 === (11))){
var inst_11598 = (state_11609[(2)]);
var state_11609__$1 = state_11609;
if(cljs.core.truth_(inst_11598)){
var statearr_11618_11639 = state_11609__$1;
(statearr_11618_11639[(1)] = (12));

} else {
var statearr_11619_11640 = state_11609__$1;
(statearr_11619_11640[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11610 === (9))){
var state_11609__$1 = state_11609;
var statearr_11620_11641 = state_11609__$1;
(statearr_11620_11641[(2)] = null);

(statearr_11620_11641[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11610 === (5))){
var state_11609__$1 = state_11609;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11621_11642 = state_11609__$1;
(statearr_11621_11642[(1)] = (8));

} else {
var statearr_11622_11643 = state_11609__$1;
(statearr_11622_11643[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11610 === (14))){
var inst_11603 = (state_11609[(2)]);
var state_11609__$1 = state_11609;
var statearr_11623_11644 = state_11609__$1;
(statearr_11623_11644[(2)] = inst_11603);

(statearr_11623_11644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11610 === (10))){
var inst_11595 = (state_11609[(2)]);
var state_11609__$1 = state_11609;
var statearr_11624_11645 = state_11609__$1;
(statearr_11624_11645[(2)] = inst_11595);

(statearr_11624_11645[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11610 === (8))){
var inst_11592 = cljs.core.async.close_BANG_(to);
var state_11609__$1 = state_11609;
var statearr_11625_11646 = state_11609__$1;
(statearr_11625_11646[(2)] = inst_11592);

(statearr_11625_11646[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11410__auto__ = null;
var cljs$core$async$state_machine__11410__auto____0 = (function (){
var statearr_11626 = [null,null,null,null,null,null,null,null];
(statearr_11626[(0)] = cljs$core$async$state_machine__11410__auto__);

(statearr_11626[(1)] = (1));

return statearr_11626;
});
var cljs$core$async$state_machine__11410__auto____1 = (function (state_11609){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_11609);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e11627){var ex__11413__auto__ = e11627;
var statearr_11628_11647 = state_11609;
(statearr_11628_11647[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_11609[(4)]))){
var statearr_11629_11648 = state_11609;
(statearr_11629_11648[(1)] = cljs.core.first((state_11609[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11649 = state_11609;
state_11609 = G__11649;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$state_machine__11410__auto__ = function(state_11609){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11410__auto____1.call(this,state_11609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11410__auto____0;
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11410__auto____1;
return cljs$core$async$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_11630 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_11630[(6)] = c__11484__auto___11632);

return statearr_11630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__11650){
var vec__11651 = p__11650;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11651,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11651,(1),null);
var job = vec__11651;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__11484__auto___11827 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_11658){
var state_val_11659 = (state_11658[(1)]);
if((state_val_11659 === (1))){
var state_11658__$1 = state_11658;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11658__$1,(2),res,v);
} else {
if((state_val_11659 === (2))){
var inst_11655 = (state_11658[(2)]);
var inst_11656 = cljs.core.async.close_BANG_(res);
var state_11658__$1 = (function (){var statearr_11660 = state_11658;
(statearr_11660[(7)] = inst_11655);

return statearr_11660;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_11658__$1,inst_11656);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0 = (function (){
var statearr_11661 = [null,null,null,null,null,null,null,null];
(statearr_11661[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__);

(statearr_11661[(1)] = (1));

return statearr_11661;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1 = (function (state_11658){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_11658);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e11662){var ex__11413__auto__ = e11662;
var statearr_11663_11828 = state_11658;
(statearr_11663_11828[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_11658[(4)]))){
var statearr_11664_11829 = state_11658;
(statearr_11664_11829[(1)] = cljs.core.first((state_11658[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11830 = state_11658;
state_11658 = G__11830;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__ = function(state_11658){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1.call(this,state_11658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_11665 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_11665[(6)] = c__11484__auto___11827);

return statearr_11665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__11666){
var vec__11667 = p__11666;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11667,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11667,(1),null);
var job = vec__11667;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4741__auto___11831 = n;
var __11832 = (0);
while(true){
if((__11832 < n__4741__auto___11831)){
var G__11670_11833 = type;
var G__11670_11834__$1 = (((G__11670_11833 instanceof cljs.core.Keyword))?G__11670_11833.fqn:null);
switch (G__11670_11834__$1) {
case "compute":
var c__11484__auto___11836 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__11832,c__11484__auto___11836,G__11670_11833,G__11670_11834__$1,n__4741__auto___11831,jobs,results,process,async){
return (function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = ((function (__11832,c__11484__auto___11836,G__11670_11833,G__11670_11834__$1,n__4741__auto___11831,jobs,results,process,async){
return (function (state_11683){
var state_val_11684 = (state_11683[(1)]);
if((state_val_11684 === (1))){
var state_11683__$1 = state_11683;
var statearr_11685_11837 = state_11683__$1;
(statearr_11685_11837[(2)] = null);

(statearr_11685_11837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11684 === (2))){
var state_11683__$1 = state_11683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11683__$1,(4),jobs);
} else {
if((state_val_11684 === (3))){
var inst_11681 = (state_11683[(2)]);
var state_11683__$1 = state_11683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11683__$1,inst_11681);
} else {
if((state_val_11684 === (4))){
var inst_11673 = (state_11683[(2)]);
var inst_11674 = process(inst_11673);
var state_11683__$1 = state_11683;
if(cljs.core.truth_(inst_11674)){
var statearr_11686_11838 = state_11683__$1;
(statearr_11686_11838[(1)] = (5));

} else {
var statearr_11687_11839 = state_11683__$1;
(statearr_11687_11839[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11684 === (5))){
var state_11683__$1 = state_11683;
var statearr_11688_11840 = state_11683__$1;
(statearr_11688_11840[(2)] = null);

(statearr_11688_11840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11684 === (6))){
var state_11683__$1 = state_11683;
var statearr_11689_11841 = state_11683__$1;
(statearr_11689_11841[(2)] = null);

(statearr_11689_11841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11684 === (7))){
var inst_11679 = (state_11683[(2)]);
var state_11683__$1 = state_11683;
var statearr_11690_11842 = state_11683__$1;
(statearr_11690_11842[(2)] = inst_11679);

(statearr_11690_11842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11832,c__11484__auto___11836,G__11670_11833,G__11670_11834__$1,n__4741__auto___11831,jobs,results,process,async))
;
return ((function (__11832,switch__11409__auto__,c__11484__auto___11836,G__11670_11833,G__11670_11834__$1,n__4741__auto___11831,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0 = (function (){
var statearr_11691 = [null,null,null,null,null,null,null];
(statearr_11691[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__);

(statearr_11691[(1)] = (1));

return statearr_11691;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1 = (function (state_11683){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_11683);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e11692){var ex__11413__auto__ = e11692;
var statearr_11693_11843 = state_11683;
(statearr_11693_11843[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_11683[(4)]))){
var statearr_11694_11844 = state_11683;
(statearr_11694_11844[(1)] = cljs.core.first((state_11683[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11845 = state_11683;
state_11683 = G__11845;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__ = function(state_11683){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1.call(this,state_11683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__;
})()
;})(__11832,switch__11409__auto__,c__11484__auto___11836,G__11670_11833,G__11670_11834__$1,n__4741__auto___11831,jobs,results,process,async))
})();
var state__11486__auto__ = (function (){var statearr_11695 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_11695[(6)] = c__11484__auto___11836);

return statearr_11695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
});})(__11832,c__11484__auto___11836,G__11670_11833,G__11670_11834__$1,n__4741__auto___11831,jobs,results,process,async))
);


break;
case "async":
var c__11484__auto___11846 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__11832,c__11484__auto___11846,G__11670_11833,G__11670_11834__$1,n__4741__auto___11831,jobs,results,process,async){
return (function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = ((function (__11832,c__11484__auto___11846,G__11670_11833,G__11670_11834__$1,n__4741__auto___11831,jobs,results,process,async){
return (function (state_11708){
var state_val_11709 = (state_11708[(1)]);
if((state_val_11709 === (1))){
var state_11708__$1 = state_11708;
var statearr_11710_11847 = state_11708__$1;
(statearr_11710_11847[(2)] = null);

(statearr_11710_11847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11709 === (2))){
var state_11708__$1 = state_11708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11708__$1,(4),jobs);
} else {
if((state_val_11709 === (3))){
var inst_11706 = (state_11708[(2)]);
var state_11708__$1 = state_11708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11708__$1,inst_11706);
} else {
if((state_val_11709 === (4))){
var inst_11698 = (state_11708[(2)]);
var inst_11699 = async(inst_11698);
var state_11708__$1 = state_11708;
if(cljs.core.truth_(inst_11699)){
var statearr_11711_11848 = state_11708__$1;
(statearr_11711_11848[(1)] = (5));

} else {
var statearr_11712_11849 = state_11708__$1;
(statearr_11712_11849[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11709 === (5))){
var state_11708__$1 = state_11708;
var statearr_11713_11850 = state_11708__$1;
(statearr_11713_11850[(2)] = null);

(statearr_11713_11850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11709 === (6))){
var state_11708__$1 = state_11708;
var statearr_11714_11851 = state_11708__$1;
(statearr_11714_11851[(2)] = null);

(statearr_11714_11851[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11709 === (7))){
var inst_11704 = (state_11708[(2)]);
var state_11708__$1 = state_11708;
var statearr_11715_11852 = state_11708__$1;
(statearr_11715_11852[(2)] = inst_11704);

(statearr_11715_11852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11832,c__11484__auto___11846,G__11670_11833,G__11670_11834__$1,n__4741__auto___11831,jobs,results,process,async))
;
return ((function (__11832,switch__11409__auto__,c__11484__auto___11846,G__11670_11833,G__11670_11834__$1,n__4741__auto___11831,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0 = (function (){
var statearr_11716 = [null,null,null,null,null,null,null];
(statearr_11716[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__);

(statearr_11716[(1)] = (1));

return statearr_11716;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1 = (function (state_11708){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_11708);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e11717){var ex__11413__auto__ = e11717;
var statearr_11718_11853 = state_11708;
(statearr_11718_11853[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_11708[(4)]))){
var statearr_11719_11854 = state_11708;
(statearr_11719_11854[(1)] = cljs.core.first((state_11708[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11855 = state_11708;
state_11708 = G__11855;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__ = function(state_11708){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1.call(this,state_11708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__;
})()
;})(__11832,switch__11409__auto__,c__11484__auto___11846,G__11670_11833,G__11670_11834__$1,n__4741__auto___11831,jobs,results,process,async))
})();
var state__11486__auto__ = (function (){var statearr_11720 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_11720[(6)] = c__11484__auto___11846);

return statearr_11720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
});})(__11832,c__11484__auto___11846,G__11670_11833,G__11670_11834__$1,n__4741__auto___11831,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11670_11834__$1)].join('')));

}

var G__11856 = (__11832 + (1));
__11832 = G__11856;
continue;
} else {
}
break;
}

var c__11484__auto___11857 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_11742){
var state_val_11743 = (state_11742[(1)]);
if((state_val_11743 === (7))){
var inst_11738 = (state_11742[(2)]);
var state_11742__$1 = state_11742;
var statearr_11744_11858 = state_11742__$1;
(statearr_11744_11858[(2)] = inst_11738);

(statearr_11744_11858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11743 === (1))){
var state_11742__$1 = state_11742;
var statearr_11745_11859 = state_11742__$1;
(statearr_11745_11859[(2)] = null);

(statearr_11745_11859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11743 === (4))){
var inst_11723 = (state_11742[(7)]);
var inst_11723__$1 = (state_11742[(2)]);
var inst_11724 = (inst_11723__$1 == null);
var state_11742__$1 = (function (){var statearr_11746 = state_11742;
(statearr_11746[(7)] = inst_11723__$1);

return statearr_11746;
})();
if(cljs.core.truth_(inst_11724)){
var statearr_11747_11860 = state_11742__$1;
(statearr_11747_11860[(1)] = (5));

} else {
var statearr_11748_11861 = state_11742__$1;
(statearr_11748_11861[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11743 === (6))){
var inst_11723 = (state_11742[(7)]);
var inst_11728 = (state_11742[(8)]);
var inst_11728__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_11729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11730 = [inst_11723,inst_11728__$1];
var inst_11731 = (new cljs.core.PersistentVector(null,2,(5),inst_11729,inst_11730,null));
var state_11742__$1 = (function (){var statearr_11749 = state_11742;
(statearr_11749[(8)] = inst_11728__$1);

return statearr_11749;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11742__$1,(8),jobs,inst_11731);
} else {
if((state_val_11743 === (3))){
var inst_11740 = (state_11742[(2)]);
var state_11742__$1 = state_11742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11742__$1,inst_11740);
} else {
if((state_val_11743 === (2))){
var state_11742__$1 = state_11742;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11742__$1,(4),from);
} else {
if((state_val_11743 === (9))){
var inst_11735 = (state_11742[(2)]);
var state_11742__$1 = (function (){var statearr_11750 = state_11742;
(statearr_11750[(9)] = inst_11735);

return statearr_11750;
})();
var statearr_11751_11862 = state_11742__$1;
(statearr_11751_11862[(2)] = null);

(statearr_11751_11862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11743 === (5))){
var inst_11726 = cljs.core.async.close_BANG_(jobs);
var state_11742__$1 = state_11742;
var statearr_11752_11863 = state_11742__$1;
(statearr_11752_11863[(2)] = inst_11726);

(statearr_11752_11863[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11743 === (8))){
var inst_11728 = (state_11742[(8)]);
var inst_11733 = (state_11742[(2)]);
var state_11742__$1 = (function (){var statearr_11753 = state_11742;
(statearr_11753[(10)] = inst_11733);

return statearr_11753;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11742__$1,(9),results,inst_11728);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0 = (function (){
var statearr_11754 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11754[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__);

(statearr_11754[(1)] = (1));

return statearr_11754;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1 = (function (state_11742){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_11742);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e11755){var ex__11413__auto__ = e11755;
var statearr_11756_11864 = state_11742;
(statearr_11756_11864[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_11742[(4)]))){
var statearr_11757_11865 = state_11742;
(statearr_11757_11865[(1)] = cljs.core.first((state_11742[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11866 = state_11742;
state_11742 = G__11866;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__ = function(state_11742){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1.call(this,state_11742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_11758 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_11758[(6)] = c__11484__auto___11857);

return statearr_11758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_11796){
var state_val_11797 = (state_11796[(1)]);
if((state_val_11797 === (7))){
var inst_11792 = (state_11796[(2)]);
var state_11796__$1 = state_11796;
var statearr_11798_11867 = state_11796__$1;
(statearr_11798_11867[(2)] = inst_11792);

(statearr_11798_11867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (20))){
var state_11796__$1 = state_11796;
var statearr_11799_11868 = state_11796__$1;
(statearr_11799_11868[(2)] = null);

(statearr_11799_11868[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (1))){
var state_11796__$1 = state_11796;
var statearr_11800_11869 = state_11796__$1;
(statearr_11800_11869[(2)] = null);

(statearr_11800_11869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (4))){
var inst_11761 = (state_11796[(7)]);
var inst_11761__$1 = (state_11796[(2)]);
var inst_11762 = (inst_11761__$1 == null);
var state_11796__$1 = (function (){var statearr_11801 = state_11796;
(statearr_11801[(7)] = inst_11761__$1);

return statearr_11801;
})();
if(cljs.core.truth_(inst_11762)){
var statearr_11802_11870 = state_11796__$1;
(statearr_11802_11870[(1)] = (5));

} else {
var statearr_11803_11871 = state_11796__$1;
(statearr_11803_11871[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (15))){
var inst_11774 = (state_11796[(8)]);
var state_11796__$1 = state_11796;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11796__$1,(18),to,inst_11774);
} else {
if((state_val_11797 === (21))){
var inst_11787 = (state_11796[(2)]);
var state_11796__$1 = state_11796;
var statearr_11804_11872 = state_11796__$1;
(statearr_11804_11872[(2)] = inst_11787);

(statearr_11804_11872[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (13))){
var inst_11789 = (state_11796[(2)]);
var state_11796__$1 = (function (){var statearr_11805 = state_11796;
(statearr_11805[(9)] = inst_11789);

return statearr_11805;
})();
var statearr_11806_11873 = state_11796__$1;
(statearr_11806_11873[(2)] = null);

(statearr_11806_11873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (6))){
var inst_11761 = (state_11796[(7)]);
var state_11796__$1 = state_11796;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11796__$1,(11),inst_11761);
} else {
if((state_val_11797 === (17))){
var inst_11782 = (state_11796[(2)]);
var state_11796__$1 = state_11796;
if(cljs.core.truth_(inst_11782)){
var statearr_11807_11874 = state_11796__$1;
(statearr_11807_11874[(1)] = (19));

} else {
var statearr_11808_11875 = state_11796__$1;
(statearr_11808_11875[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (3))){
var inst_11794 = (state_11796[(2)]);
var state_11796__$1 = state_11796;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11796__$1,inst_11794);
} else {
if((state_val_11797 === (12))){
var inst_11771 = (state_11796[(10)]);
var state_11796__$1 = state_11796;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11796__$1,(14),inst_11771);
} else {
if((state_val_11797 === (2))){
var state_11796__$1 = state_11796;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11796__$1,(4),results);
} else {
if((state_val_11797 === (19))){
var state_11796__$1 = state_11796;
var statearr_11809_11876 = state_11796__$1;
(statearr_11809_11876[(2)] = null);

(statearr_11809_11876[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (11))){
var inst_11771 = (state_11796[(2)]);
var state_11796__$1 = (function (){var statearr_11810 = state_11796;
(statearr_11810[(10)] = inst_11771);

return statearr_11810;
})();
var statearr_11811_11877 = state_11796__$1;
(statearr_11811_11877[(2)] = null);

(statearr_11811_11877[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (9))){
var state_11796__$1 = state_11796;
var statearr_11812_11878 = state_11796__$1;
(statearr_11812_11878[(2)] = null);

(statearr_11812_11878[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (5))){
var state_11796__$1 = state_11796;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11813_11879 = state_11796__$1;
(statearr_11813_11879[(1)] = (8));

} else {
var statearr_11814_11880 = state_11796__$1;
(statearr_11814_11880[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (14))){
var inst_11774 = (state_11796[(8)]);
var inst_11776 = (state_11796[(11)]);
var inst_11774__$1 = (state_11796[(2)]);
var inst_11775 = (inst_11774__$1 == null);
var inst_11776__$1 = cljs.core.not(inst_11775);
var state_11796__$1 = (function (){var statearr_11815 = state_11796;
(statearr_11815[(8)] = inst_11774__$1);

(statearr_11815[(11)] = inst_11776__$1);

return statearr_11815;
})();
if(inst_11776__$1){
var statearr_11816_11881 = state_11796__$1;
(statearr_11816_11881[(1)] = (15));

} else {
var statearr_11817_11882 = state_11796__$1;
(statearr_11817_11882[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (16))){
var inst_11776 = (state_11796[(11)]);
var state_11796__$1 = state_11796;
var statearr_11818_11883 = state_11796__$1;
(statearr_11818_11883[(2)] = inst_11776);

(statearr_11818_11883[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (10))){
var inst_11768 = (state_11796[(2)]);
var state_11796__$1 = state_11796;
var statearr_11819_11884 = state_11796__$1;
(statearr_11819_11884[(2)] = inst_11768);

(statearr_11819_11884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (18))){
var inst_11779 = (state_11796[(2)]);
var state_11796__$1 = state_11796;
var statearr_11820_11885 = state_11796__$1;
(statearr_11820_11885[(2)] = inst_11779);

(statearr_11820_11885[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11797 === (8))){
var inst_11765 = cljs.core.async.close_BANG_(to);
var state_11796__$1 = state_11796;
var statearr_11821_11886 = state_11796__$1;
(statearr_11821_11886[(2)] = inst_11765);

(statearr_11821_11886[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0 = (function (){
var statearr_11822 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11822[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__);

(statearr_11822[(1)] = (1));

return statearr_11822;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1 = (function (state_11796){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_11796);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e11823){var ex__11413__auto__ = e11823;
var statearr_11824_11887 = state_11796;
(statearr_11824_11887[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_11796[(4)]))){
var statearr_11825_11888 = state_11796;
(statearr_11825_11888[(1)] = cljs.core.first((state_11796[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11889 = state_11796;
state_11796 = G__11889;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__ = function(state_11796){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1.call(this,state_11796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11410__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_11826 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_11826[(6)] = c__11484__auto__);

return statearr_11826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11891 = arguments.length;
switch (G__11891) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11894 = arguments.length;
switch (G__11894) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11897 = arguments.length;
switch (G__11897) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__11484__auto___11947 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_11923){
var state_val_11924 = (state_11923[(1)]);
if((state_val_11924 === (7))){
var inst_11919 = (state_11923[(2)]);
var state_11923__$1 = state_11923;
var statearr_11925_11948 = state_11923__$1;
(statearr_11925_11948[(2)] = inst_11919);

(statearr_11925_11948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11924 === (1))){
var state_11923__$1 = state_11923;
var statearr_11926_11949 = state_11923__$1;
(statearr_11926_11949[(2)] = null);

(statearr_11926_11949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11924 === (4))){
var inst_11900 = (state_11923[(7)]);
var inst_11900__$1 = (state_11923[(2)]);
var inst_11901 = (inst_11900__$1 == null);
var state_11923__$1 = (function (){var statearr_11927 = state_11923;
(statearr_11927[(7)] = inst_11900__$1);

return statearr_11927;
})();
if(cljs.core.truth_(inst_11901)){
var statearr_11928_11950 = state_11923__$1;
(statearr_11928_11950[(1)] = (5));

} else {
var statearr_11929_11951 = state_11923__$1;
(statearr_11929_11951[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11924 === (13))){
var state_11923__$1 = state_11923;
var statearr_11930_11952 = state_11923__$1;
(statearr_11930_11952[(2)] = null);

(statearr_11930_11952[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11924 === (6))){
var inst_11900 = (state_11923[(7)]);
var inst_11906 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_11900) : p.call(null,inst_11900));
var state_11923__$1 = state_11923;
if(cljs.core.truth_(inst_11906)){
var statearr_11931_11953 = state_11923__$1;
(statearr_11931_11953[(1)] = (9));

} else {
var statearr_11932_11954 = state_11923__$1;
(statearr_11932_11954[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11924 === (3))){
var inst_11921 = (state_11923[(2)]);
var state_11923__$1 = state_11923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11923__$1,inst_11921);
} else {
if((state_val_11924 === (12))){
var state_11923__$1 = state_11923;
var statearr_11933_11955 = state_11923__$1;
(statearr_11933_11955[(2)] = null);

(statearr_11933_11955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11924 === (2))){
var state_11923__$1 = state_11923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11923__$1,(4),ch);
} else {
if((state_val_11924 === (11))){
var inst_11900 = (state_11923[(7)]);
var inst_11910 = (state_11923[(2)]);
var state_11923__$1 = state_11923;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11923__$1,(8),inst_11910,inst_11900);
} else {
if((state_val_11924 === (9))){
var state_11923__$1 = state_11923;
var statearr_11934_11956 = state_11923__$1;
(statearr_11934_11956[(2)] = tc);

(statearr_11934_11956[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11924 === (5))){
var inst_11903 = cljs.core.async.close_BANG_(tc);
var inst_11904 = cljs.core.async.close_BANG_(fc);
var state_11923__$1 = (function (){var statearr_11935 = state_11923;
(statearr_11935[(8)] = inst_11903);

return statearr_11935;
})();
var statearr_11936_11957 = state_11923__$1;
(statearr_11936_11957[(2)] = inst_11904);

(statearr_11936_11957[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11924 === (14))){
var inst_11917 = (state_11923[(2)]);
var state_11923__$1 = state_11923;
var statearr_11937_11958 = state_11923__$1;
(statearr_11937_11958[(2)] = inst_11917);

(statearr_11937_11958[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11924 === (10))){
var state_11923__$1 = state_11923;
var statearr_11938_11959 = state_11923__$1;
(statearr_11938_11959[(2)] = fc);

(statearr_11938_11959[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11924 === (8))){
var inst_11912 = (state_11923[(2)]);
var state_11923__$1 = state_11923;
if(cljs.core.truth_(inst_11912)){
var statearr_11939_11960 = state_11923__$1;
(statearr_11939_11960[(1)] = (12));

} else {
var statearr_11940_11961 = state_11923__$1;
(statearr_11940_11961[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11410__auto__ = null;
var cljs$core$async$state_machine__11410__auto____0 = (function (){
var statearr_11941 = [null,null,null,null,null,null,null,null,null];
(statearr_11941[(0)] = cljs$core$async$state_machine__11410__auto__);

(statearr_11941[(1)] = (1));

return statearr_11941;
});
var cljs$core$async$state_machine__11410__auto____1 = (function (state_11923){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_11923);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e11942){var ex__11413__auto__ = e11942;
var statearr_11943_11962 = state_11923;
(statearr_11943_11962[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_11923[(4)]))){
var statearr_11944_11963 = state_11923;
(statearr_11944_11963[(1)] = cljs.core.first((state_11923[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11964 = state_11923;
state_11923 = G__11964;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$state_machine__11410__auto__ = function(state_11923){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11410__auto____1.call(this,state_11923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11410__auto____0;
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11410__auto____1;
return cljs$core$async$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_11945 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_11945[(6)] = c__11484__auto___11947);

return statearr_11945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_11986){
var state_val_11987 = (state_11986[(1)]);
if((state_val_11987 === (7))){
var inst_11982 = (state_11986[(2)]);
var state_11986__$1 = state_11986;
var statearr_11988_12007 = state_11986__$1;
(statearr_11988_12007[(2)] = inst_11982);

(statearr_11988_12007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11987 === (1))){
var inst_11965 = init;
var inst_11966 = inst_11965;
var state_11986__$1 = (function (){var statearr_11989 = state_11986;
(statearr_11989[(7)] = inst_11966);

return statearr_11989;
})();
var statearr_11990_12008 = state_11986__$1;
(statearr_11990_12008[(2)] = null);

(statearr_11990_12008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11987 === (4))){
var inst_11969 = (state_11986[(8)]);
var inst_11969__$1 = (state_11986[(2)]);
var inst_11970 = (inst_11969__$1 == null);
var state_11986__$1 = (function (){var statearr_11991 = state_11986;
(statearr_11991[(8)] = inst_11969__$1);

return statearr_11991;
})();
if(cljs.core.truth_(inst_11970)){
var statearr_11992_12009 = state_11986__$1;
(statearr_11992_12009[(1)] = (5));

} else {
var statearr_11993_12010 = state_11986__$1;
(statearr_11993_12010[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11987 === (6))){
var inst_11969 = (state_11986[(8)]);
var inst_11966 = (state_11986[(7)]);
var inst_11973 = (state_11986[(9)]);
var inst_11973__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_11966,inst_11969) : f.call(null,inst_11966,inst_11969));
var inst_11974 = cljs.core.reduced_QMARK_(inst_11973__$1);
var state_11986__$1 = (function (){var statearr_11994 = state_11986;
(statearr_11994[(9)] = inst_11973__$1);

return statearr_11994;
})();
if(inst_11974){
var statearr_11995_12011 = state_11986__$1;
(statearr_11995_12011[(1)] = (8));

} else {
var statearr_11996_12012 = state_11986__$1;
(statearr_11996_12012[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11987 === (3))){
var inst_11984 = (state_11986[(2)]);
var state_11986__$1 = state_11986;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11986__$1,inst_11984);
} else {
if((state_val_11987 === (2))){
var state_11986__$1 = state_11986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11986__$1,(4),ch);
} else {
if((state_val_11987 === (9))){
var inst_11973 = (state_11986[(9)]);
var inst_11966 = inst_11973;
var state_11986__$1 = (function (){var statearr_11997 = state_11986;
(statearr_11997[(7)] = inst_11966);

return statearr_11997;
})();
var statearr_11998_12013 = state_11986__$1;
(statearr_11998_12013[(2)] = null);

(statearr_11998_12013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11987 === (5))){
var inst_11966 = (state_11986[(7)]);
var state_11986__$1 = state_11986;
var statearr_11999_12014 = state_11986__$1;
(statearr_11999_12014[(2)] = inst_11966);

(statearr_11999_12014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11987 === (10))){
var inst_11980 = (state_11986[(2)]);
var state_11986__$1 = state_11986;
var statearr_12000_12015 = state_11986__$1;
(statearr_12000_12015[(2)] = inst_11980);

(statearr_12000_12015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11987 === (8))){
var inst_11973 = (state_11986[(9)]);
var inst_11976 = cljs.core.deref(inst_11973);
var state_11986__$1 = state_11986;
var statearr_12001_12016 = state_11986__$1;
(statearr_12001_12016[(2)] = inst_11976);

(statearr_12001_12016[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__11410__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11410__auto____0 = (function (){
var statearr_12002 = [null,null,null,null,null,null,null,null,null,null];
(statearr_12002[(0)] = cljs$core$async$reduce_$_state_machine__11410__auto__);

(statearr_12002[(1)] = (1));

return statearr_12002;
});
var cljs$core$async$reduce_$_state_machine__11410__auto____1 = (function (state_11986){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_11986);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e12003){var ex__11413__auto__ = e12003;
var statearr_12004_12017 = state_11986;
(statearr_12004_12017[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_11986[(4)]))){
var statearr_12005_12018 = state_11986;
(statearr_12005_12018[(1)] = cljs.core.first((state_11986[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12019 = state_11986;
state_11986 = G__12019;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11410__auto__ = function(state_11986){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11410__auto____1.call(this,state_11986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11410__auto____0;
cljs$core$async$reduce_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11410__auto____1;
return cljs$core$async$reduce_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_12006 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_12006[(6)] = c__11484__auto__);

return statearr_12006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_12025){
var state_val_12026 = (state_12025[(1)]);
if((state_val_12026 === (1))){
var inst_12020 = cljs.core.async.reduce(f__$1,init,ch);
var state_12025__$1 = state_12025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12025__$1,(2),inst_12020);
} else {
if((state_val_12026 === (2))){
var inst_12022 = (state_12025[(2)]);
var inst_12023 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_12022) : f__$1.call(null,inst_12022));
var state_12025__$1 = state_12025;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12025__$1,inst_12023);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__11410__auto__ = null;
var cljs$core$async$transduce_$_state_machine__11410__auto____0 = (function (){
var statearr_12027 = [null,null,null,null,null,null,null];
(statearr_12027[(0)] = cljs$core$async$transduce_$_state_machine__11410__auto__);

(statearr_12027[(1)] = (1));

return statearr_12027;
});
var cljs$core$async$transduce_$_state_machine__11410__auto____1 = (function (state_12025){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_12025);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e12028){var ex__11413__auto__ = e12028;
var statearr_12029_12032 = state_12025;
(statearr_12029_12032[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_12025[(4)]))){
var statearr_12030_12033 = state_12025;
(statearr_12030_12033[(1)] = cljs.core.first((state_12025[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12034 = state_12025;
state_12025 = G__12034;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__11410__auto__ = function(state_12025){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__11410__auto____1.call(this,state_12025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__11410__auto____0;
cljs$core$async$transduce_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__11410__auto____1;
return cljs$core$async$transduce_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_12031 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_12031[(6)] = c__11484__auto__);

return statearr_12031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__12036 = arguments.length;
switch (G__12036) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_12061){
var state_val_12062 = (state_12061[(1)]);
if((state_val_12062 === (7))){
var inst_12043 = (state_12061[(2)]);
var state_12061__$1 = state_12061;
var statearr_12063_12085 = state_12061__$1;
(statearr_12063_12085[(2)] = inst_12043);

(statearr_12063_12085[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12062 === (1))){
var inst_12037 = cljs.core.seq(coll);
var inst_12038 = inst_12037;
var state_12061__$1 = (function (){var statearr_12064 = state_12061;
(statearr_12064[(7)] = inst_12038);

return statearr_12064;
})();
var statearr_12065_12086 = state_12061__$1;
(statearr_12065_12086[(2)] = null);

(statearr_12065_12086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12062 === (4))){
var inst_12038 = (state_12061[(7)]);
var inst_12041 = cljs.core.first(inst_12038);
var state_12061__$1 = state_12061;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12061__$1,(7),ch,inst_12041);
} else {
if((state_val_12062 === (13))){
var inst_12055 = (state_12061[(2)]);
var state_12061__$1 = state_12061;
var statearr_12066_12087 = state_12061__$1;
(statearr_12066_12087[(2)] = inst_12055);

(statearr_12066_12087[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12062 === (6))){
var inst_12046 = (state_12061[(2)]);
var state_12061__$1 = state_12061;
if(cljs.core.truth_(inst_12046)){
var statearr_12067_12088 = state_12061__$1;
(statearr_12067_12088[(1)] = (8));

} else {
var statearr_12068_12089 = state_12061__$1;
(statearr_12068_12089[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12062 === (3))){
var inst_12059 = (state_12061[(2)]);
var state_12061__$1 = state_12061;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12061__$1,inst_12059);
} else {
if((state_val_12062 === (12))){
var state_12061__$1 = state_12061;
var statearr_12069_12090 = state_12061__$1;
(statearr_12069_12090[(2)] = null);

(statearr_12069_12090[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12062 === (2))){
var inst_12038 = (state_12061[(7)]);
var state_12061__$1 = state_12061;
if(cljs.core.truth_(inst_12038)){
var statearr_12070_12091 = state_12061__$1;
(statearr_12070_12091[(1)] = (4));

} else {
var statearr_12071_12092 = state_12061__$1;
(statearr_12071_12092[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12062 === (11))){
var inst_12052 = cljs.core.async.close_BANG_(ch);
var state_12061__$1 = state_12061;
var statearr_12072_12093 = state_12061__$1;
(statearr_12072_12093[(2)] = inst_12052);

(statearr_12072_12093[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12062 === (9))){
var state_12061__$1 = state_12061;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12073_12094 = state_12061__$1;
(statearr_12073_12094[(1)] = (11));

} else {
var statearr_12074_12095 = state_12061__$1;
(statearr_12074_12095[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12062 === (5))){
var inst_12038 = (state_12061[(7)]);
var state_12061__$1 = state_12061;
var statearr_12075_12096 = state_12061__$1;
(statearr_12075_12096[(2)] = inst_12038);

(statearr_12075_12096[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12062 === (10))){
var inst_12057 = (state_12061[(2)]);
var state_12061__$1 = state_12061;
var statearr_12076_12097 = state_12061__$1;
(statearr_12076_12097[(2)] = inst_12057);

(statearr_12076_12097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12062 === (8))){
var inst_12038 = (state_12061[(7)]);
var inst_12048 = cljs.core.next(inst_12038);
var inst_12038__$1 = inst_12048;
var state_12061__$1 = (function (){var statearr_12077 = state_12061;
(statearr_12077[(7)] = inst_12038__$1);

return statearr_12077;
})();
var statearr_12078_12098 = state_12061__$1;
(statearr_12078_12098[(2)] = null);

(statearr_12078_12098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11410__auto__ = null;
var cljs$core$async$state_machine__11410__auto____0 = (function (){
var statearr_12079 = [null,null,null,null,null,null,null,null];
(statearr_12079[(0)] = cljs$core$async$state_machine__11410__auto__);

(statearr_12079[(1)] = (1));

return statearr_12079;
});
var cljs$core$async$state_machine__11410__auto____1 = (function (state_12061){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_12061);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e12080){var ex__11413__auto__ = e12080;
var statearr_12081_12099 = state_12061;
(statearr_12081_12099[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_12061[(4)]))){
var statearr_12082_12100 = state_12061;
(statearr_12082_12100[(1)] = cljs.core.first((state_12061[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12101 = state_12061;
state_12061 = G__12101;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$state_machine__11410__auto__ = function(state_12061){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11410__auto____1.call(this,state_12061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11410__auto____0;
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11410__auto____1;
return cljs$core$async$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_12083 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_12083[(6)] = c__11484__auto__);

return statearr_12083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__12103 = arguments.length;
switch (G__12103) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_12105 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4551__auto__.call(null,_));
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4549__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_12105(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_12106 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4551__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4549__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_12106(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_12107 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_12107(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_12108 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_12108(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12109 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12109 = (function (ch,cs,meta12110){
this.ch = ch;
this.cs = cs;
this.meta12110 = meta12110;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12109.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12111,meta12110__$1){
var self__ = this;
var _12111__$1 = this;
return (new cljs.core.async.t_cljs$core$async12109(self__.ch,self__.cs,meta12110__$1));
}));

(cljs.core.async.t_cljs$core$async12109.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12111){
var self__ = this;
var _12111__$1 = this;
return self__.meta12110;
}));

(cljs.core.async.t_cljs$core$async12109.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12109.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12109.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12109.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async12109.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async12109.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async12109.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12110","meta12110",1929969669,null)], null);
}));

(cljs.core.async.t_cljs$core$async12109.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12109.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12109");

(cljs.core.async.t_cljs$core$async12109.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12109");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12109.
 */
cljs.core.async.__GT_t_cljs$core$async12109 = (function cljs$core$async$mult_$___GT_t_cljs$core$async12109(ch__$1,cs__$1,meta12110){
return (new cljs.core.async.t_cljs$core$async12109(ch__$1,cs__$1,meta12110));
});

}

return (new cljs.core.async.t_cljs$core$async12109(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__11484__auto___12328 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_12244){
var state_val_12245 = (state_12244[(1)]);
if((state_val_12245 === (7))){
var inst_12240 = (state_12244[(2)]);
var state_12244__$1 = state_12244;
var statearr_12246_12329 = state_12244__$1;
(statearr_12246_12329[(2)] = inst_12240);

(statearr_12246_12329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (20))){
var inst_12145 = (state_12244[(7)]);
var inst_12157 = cljs.core.first(inst_12145);
var inst_12158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12157,(0),null);
var inst_12159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12157,(1),null);
var state_12244__$1 = (function (){var statearr_12247 = state_12244;
(statearr_12247[(8)] = inst_12158);

return statearr_12247;
})();
if(cljs.core.truth_(inst_12159)){
var statearr_12248_12330 = state_12244__$1;
(statearr_12248_12330[(1)] = (22));

} else {
var statearr_12249_12331 = state_12244__$1;
(statearr_12249_12331[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (27))){
var inst_12114 = (state_12244[(9)]);
var inst_12187 = (state_12244[(10)]);
var inst_12189 = (state_12244[(11)]);
var inst_12194 = (state_12244[(12)]);
var inst_12194__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12187,inst_12189);
var inst_12195 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_12194__$1,inst_12114,done);
var state_12244__$1 = (function (){var statearr_12250 = state_12244;
(statearr_12250[(12)] = inst_12194__$1);

return statearr_12250;
})();
if(cljs.core.truth_(inst_12195)){
var statearr_12251_12332 = state_12244__$1;
(statearr_12251_12332[(1)] = (30));

} else {
var statearr_12252_12333 = state_12244__$1;
(statearr_12252_12333[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (1))){
var state_12244__$1 = state_12244;
var statearr_12253_12334 = state_12244__$1;
(statearr_12253_12334[(2)] = null);

(statearr_12253_12334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (24))){
var inst_12145 = (state_12244[(7)]);
var inst_12164 = (state_12244[(2)]);
var inst_12165 = cljs.core.next(inst_12145);
var inst_12123 = inst_12165;
var inst_12124 = null;
var inst_12125 = (0);
var inst_12126 = (0);
var state_12244__$1 = (function (){var statearr_12254 = state_12244;
(statearr_12254[(13)] = inst_12123);

(statearr_12254[(14)] = inst_12125);

(statearr_12254[(15)] = inst_12126);

(statearr_12254[(16)] = inst_12164);

(statearr_12254[(17)] = inst_12124);

return statearr_12254;
})();
var statearr_12255_12335 = state_12244__$1;
(statearr_12255_12335[(2)] = null);

(statearr_12255_12335[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (39))){
var state_12244__$1 = state_12244;
var statearr_12259_12336 = state_12244__$1;
(statearr_12259_12336[(2)] = null);

(statearr_12259_12336[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (4))){
var inst_12114 = (state_12244[(9)]);
var inst_12114__$1 = (state_12244[(2)]);
var inst_12115 = (inst_12114__$1 == null);
var state_12244__$1 = (function (){var statearr_12260 = state_12244;
(statearr_12260[(9)] = inst_12114__$1);

return statearr_12260;
})();
if(cljs.core.truth_(inst_12115)){
var statearr_12261_12337 = state_12244__$1;
(statearr_12261_12337[(1)] = (5));

} else {
var statearr_12262_12338 = state_12244__$1;
(statearr_12262_12338[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (15))){
var inst_12123 = (state_12244[(13)]);
var inst_12125 = (state_12244[(14)]);
var inst_12126 = (state_12244[(15)]);
var inst_12124 = (state_12244[(17)]);
var inst_12141 = (state_12244[(2)]);
var inst_12142 = (inst_12126 + (1));
var tmp12256 = inst_12123;
var tmp12257 = inst_12125;
var tmp12258 = inst_12124;
var inst_12123__$1 = tmp12256;
var inst_12124__$1 = tmp12258;
var inst_12125__$1 = tmp12257;
var inst_12126__$1 = inst_12142;
var state_12244__$1 = (function (){var statearr_12263 = state_12244;
(statearr_12263[(13)] = inst_12123__$1);

(statearr_12263[(14)] = inst_12125__$1);

(statearr_12263[(15)] = inst_12126__$1);

(statearr_12263[(18)] = inst_12141);

(statearr_12263[(17)] = inst_12124__$1);

return statearr_12263;
})();
var statearr_12264_12339 = state_12244__$1;
(statearr_12264_12339[(2)] = null);

(statearr_12264_12339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (21))){
var inst_12168 = (state_12244[(2)]);
var state_12244__$1 = state_12244;
var statearr_12268_12340 = state_12244__$1;
(statearr_12268_12340[(2)] = inst_12168);

(statearr_12268_12340[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (31))){
var inst_12194 = (state_12244[(12)]);
var inst_12198 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_12194);
var state_12244__$1 = state_12244;
var statearr_12269_12341 = state_12244__$1;
(statearr_12269_12341[(2)] = inst_12198);

(statearr_12269_12341[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (32))){
var inst_12186 = (state_12244[(19)]);
var inst_12187 = (state_12244[(10)]);
var inst_12189 = (state_12244[(11)]);
var inst_12188 = (state_12244[(20)]);
var inst_12200 = (state_12244[(2)]);
var inst_12201 = (inst_12189 + (1));
var tmp12265 = inst_12186;
var tmp12266 = inst_12187;
var tmp12267 = inst_12188;
var inst_12186__$1 = tmp12265;
var inst_12187__$1 = tmp12266;
var inst_12188__$1 = tmp12267;
var inst_12189__$1 = inst_12201;
var state_12244__$1 = (function (){var statearr_12270 = state_12244;
(statearr_12270[(19)] = inst_12186__$1);

(statearr_12270[(10)] = inst_12187__$1);

(statearr_12270[(21)] = inst_12200);

(statearr_12270[(11)] = inst_12189__$1);

(statearr_12270[(20)] = inst_12188__$1);

return statearr_12270;
})();
var statearr_12271_12342 = state_12244__$1;
(statearr_12271_12342[(2)] = null);

(statearr_12271_12342[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (40))){
var inst_12213 = (state_12244[(22)]);
var inst_12217 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_12213);
var state_12244__$1 = state_12244;
var statearr_12272_12343 = state_12244__$1;
(statearr_12272_12343[(2)] = inst_12217);

(statearr_12272_12343[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (33))){
var inst_12204 = (state_12244[(23)]);
var inst_12206 = cljs.core.chunked_seq_QMARK_(inst_12204);
var state_12244__$1 = state_12244;
if(inst_12206){
var statearr_12273_12344 = state_12244__$1;
(statearr_12273_12344[(1)] = (36));

} else {
var statearr_12274_12345 = state_12244__$1;
(statearr_12274_12345[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (13))){
var inst_12135 = (state_12244[(24)]);
var inst_12138 = cljs.core.async.close_BANG_(inst_12135);
var state_12244__$1 = state_12244;
var statearr_12275_12346 = state_12244__$1;
(statearr_12275_12346[(2)] = inst_12138);

(statearr_12275_12346[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (22))){
var inst_12158 = (state_12244[(8)]);
var inst_12161 = cljs.core.async.close_BANG_(inst_12158);
var state_12244__$1 = state_12244;
var statearr_12276_12347 = state_12244__$1;
(statearr_12276_12347[(2)] = inst_12161);

(statearr_12276_12347[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (36))){
var inst_12204 = (state_12244[(23)]);
var inst_12208 = cljs.core.chunk_first(inst_12204);
var inst_12209 = cljs.core.chunk_rest(inst_12204);
var inst_12210 = cljs.core.count(inst_12208);
var inst_12186 = inst_12209;
var inst_12187 = inst_12208;
var inst_12188 = inst_12210;
var inst_12189 = (0);
var state_12244__$1 = (function (){var statearr_12277 = state_12244;
(statearr_12277[(19)] = inst_12186);

(statearr_12277[(10)] = inst_12187);

(statearr_12277[(11)] = inst_12189);

(statearr_12277[(20)] = inst_12188);

return statearr_12277;
})();
var statearr_12278_12348 = state_12244__$1;
(statearr_12278_12348[(2)] = null);

(statearr_12278_12348[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (41))){
var inst_12204 = (state_12244[(23)]);
var inst_12219 = (state_12244[(2)]);
var inst_12220 = cljs.core.next(inst_12204);
var inst_12186 = inst_12220;
var inst_12187 = null;
var inst_12188 = (0);
var inst_12189 = (0);
var state_12244__$1 = (function (){var statearr_12279 = state_12244;
(statearr_12279[(19)] = inst_12186);

(statearr_12279[(10)] = inst_12187);

(statearr_12279[(11)] = inst_12189);

(statearr_12279[(20)] = inst_12188);

(statearr_12279[(25)] = inst_12219);

return statearr_12279;
})();
var statearr_12280_12349 = state_12244__$1;
(statearr_12280_12349[(2)] = null);

(statearr_12280_12349[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (43))){
var state_12244__$1 = state_12244;
var statearr_12281_12350 = state_12244__$1;
(statearr_12281_12350[(2)] = null);

(statearr_12281_12350[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (29))){
var inst_12228 = (state_12244[(2)]);
var state_12244__$1 = state_12244;
var statearr_12282_12351 = state_12244__$1;
(statearr_12282_12351[(2)] = inst_12228);

(statearr_12282_12351[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (44))){
var inst_12237 = (state_12244[(2)]);
var state_12244__$1 = (function (){var statearr_12283 = state_12244;
(statearr_12283[(26)] = inst_12237);

return statearr_12283;
})();
var statearr_12284_12352 = state_12244__$1;
(statearr_12284_12352[(2)] = null);

(statearr_12284_12352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (6))){
var inst_12178 = (state_12244[(27)]);
var inst_12177 = cljs.core.deref(cs);
var inst_12178__$1 = cljs.core.keys(inst_12177);
var inst_12179 = cljs.core.count(inst_12178__$1);
var inst_12180 = cljs.core.reset_BANG_(dctr,inst_12179);
var inst_12185 = cljs.core.seq(inst_12178__$1);
var inst_12186 = inst_12185;
var inst_12187 = null;
var inst_12188 = (0);
var inst_12189 = (0);
var state_12244__$1 = (function (){var statearr_12285 = state_12244;
(statearr_12285[(19)] = inst_12186);

(statearr_12285[(10)] = inst_12187);

(statearr_12285[(11)] = inst_12189);

(statearr_12285[(27)] = inst_12178__$1);

(statearr_12285[(28)] = inst_12180);

(statearr_12285[(20)] = inst_12188);

return statearr_12285;
})();
var statearr_12286_12353 = state_12244__$1;
(statearr_12286_12353[(2)] = null);

(statearr_12286_12353[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (28))){
var inst_12186 = (state_12244[(19)]);
var inst_12204 = (state_12244[(23)]);
var inst_12204__$1 = cljs.core.seq(inst_12186);
var state_12244__$1 = (function (){var statearr_12287 = state_12244;
(statearr_12287[(23)] = inst_12204__$1);

return statearr_12287;
})();
if(inst_12204__$1){
var statearr_12288_12354 = state_12244__$1;
(statearr_12288_12354[(1)] = (33));

} else {
var statearr_12289_12355 = state_12244__$1;
(statearr_12289_12355[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (25))){
var inst_12189 = (state_12244[(11)]);
var inst_12188 = (state_12244[(20)]);
var inst_12191 = (inst_12189 < inst_12188);
var inst_12192 = inst_12191;
var state_12244__$1 = state_12244;
if(cljs.core.truth_(inst_12192)){
var statearr_12290_12356 = state_12244__$1;
(statearr_12290_12356[(1)] = (27));

} else {
var statearr_12291_12357 = state_12244__$1;
(statearr_12291_12357[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (34))){
var state_12244__$1 = state_12244;
var statearr_12292_12358 = state_12244__$1;
(statearr_12292_12358[(2)] = null);

(statearr_12292_12358[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (17))){
var state_12244__$1 = state_12244;
var statearr_12293_12359 = state_12244__$1;
(statearr_12293_12359[(2)] = null);

(statearr_12293_12359[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (3))){
var inst_12242 = (state_12244[(2)]);
var state_12244__$1 = state_12244;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12244__$1,inst_12242);
} else {
if((state_val_12245 === (12))){
var inst_12173 = (state_12244[(2)]);
var state_12244__$1 = state_12244;
var statearr_12294_12360 = state_12244__$1;
(statearr_12294_12360[(2)] = inst_12173);

(statearr_12294_12360[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (2))){
var state_12244__$1 = state_12244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12244__$1,(4),ch);
} else {
if((state_val_12245 === (23))){
var state_12244__$1 = state_12244;
var statearr_12295_12361 = state_12244__$1;
(statearr_12295_12361[(2)] = null);

(statearr_12295_12361[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (35))){
var inst_12226 = (state_12244[(2)]);
var state_12244__$1 = state_12244;
var statearr_12296_12362 = state_12244__$1;
(statearr_12296_12362[(2)] = inst_12226);

(statearr_12296_12362[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (19))){
var inst_12145 = (state_12244[(7)]);
var inst_12149 = cljs.core.chunk_first(inst_12145);
var inst_12150 = cljs.core.chunk_rest(inst_12145);
var inst_12151 = cljs.core.count(inst_12149);
var inst_12123 = inst_12150;
var inst_12124 = inst_12149;
var inst_12125 = inst_12151;
var inst_12126 = (0);
var state_12244__$1 = (function (){var statearr_12297 = state_12244;
(statearr_12297[(13)] = inst_12123);

(statearr_12297[(14)] = inst_12125);

(statearr_12297[(15)] = inst_12126);

(statearr_12297[(17)] = inst_12124);

return statearr_12297;
})();
var statearr_12298_12363 = state_12244__$1;
(statearr_12298_12363[(2)] = null);

(statearr_12298_12363[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (11))){
var inst_12123 = (state_12244[(13)]);
var inst_12145 = (state_12244[(7)]);
var inst_12145__$1 = cljs.core.seq(inst_12123);
var state_12244__$1 = (function (){var statearr_12299 = state_12244;
(statearr_12299[(7)] = inst_12145__$1);

return statearr_12299;
})();
if(inst_12145__$1){
var statearr_12300_12364 = state_12244__$1;
(statearr_12300_12364[(1)] = (16));

} else {
var statearr_12301_12365 = state_12244__$1;
(statearr_12301_12365[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (9))){
var inst_12175 = (state_12244[(2)]);
var state_12244__$1 = state_12244;
var statearr_12302_12366 = state_12244__$1;
(statearr_12302_12366[(2)] = inst_12175);

(statearr_12302_12366[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (5))){
var inst_12121 = cljs.core.deref(cs);
var inst_12122 = cljs.core.seq(inst_12121);
var inst_12123 = inst_12122;
var inst_12124 = null;
var inst_12125 = (0);
var inst_12126 = (0);
var state_12244__$1 = (function (){var statearr_12303 = state_12244;
(statearr_12303[(13)] = inst_12123);

(statearr_12303[(14)] = inst_12125);

(statearr_12303[(15)] = inst_12126);

(statearr_12303[(17)] = inst_12124);

return statearr_12303;
})();
var statearr_12304_12367 = state_12244__$1;
(statearr_12304_12367[(2)] = null);

(statearr_12304_12367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (14))){
var state_12244__$1 = state_12244;
var statearr_12305_12368 = state_12244__$1;
(statearr_12305_12368[(2)] = null);

(statearr_12305_12368[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (45))){
var inst_12234 = (state_12244[(2)]);
var state_12244__$1 = state_12244;
var statearr_12306_12369 = state_12244__$1;
(statearr_12306_12369[(2)] = inst_12234);

(statearr_12306_12369[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (26))){
var inst_12178 = (state_12244[(27)]);
var inst_12230 = (state_12244[(2)]);
var inst_12231 = cljs.core.seq(inst_12178);
var state_12244__$1 = (function (){var statearr_12307 = state_12244;
(statearr_12307[(29)] = inst_12230);

return statearr_12307;
})();
if(inst_12231){
var statearr_12308_12370 = state_12244__$1;
(statearr_12308_12370[(1)] = (42));

} else {
var statearr_12309_12371 = state_12244__$1;
(statearr_12309_12371[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (16))){
var inst_12145 = (state_12244[(7)]);
var inst_12147 = cljs.core.chunked_seq_QMARK_(inst_12145);
var state_12244__$1 = state_12244;
if(inst_12147){
var statearr_12310_12372 = state_12244__$1;
(statearr_12310_12372[(1)] = (19));

} else {
var statearr_12311_12373 = state_12244__$1;
(statearr_12311_12373[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (38))){
var inst_12223 = (state_12244[(2)]);
var state_12244__$1 = state_12244;
var statearr_12312_12374 = state_12244__$1;
(statearr_12312_12374[(2)] = inst_12223);

(statearr_12312_12374[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (30))){
var state_12244__$1 = state_12244;
var statearr_12313_12375 = state_12244__$1;
(statearr_12313_12375[(2)] = null);

(statearr_12313_12375[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (10))){
var inst_12126 = (state_12244[(15)]);
var inst_12124 = (state_12244[(17)]);
var inst_12134 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12124,inst_12126);
var inst_12135 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12134,(0),null);
var inst_12136 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12134,(1),null);
var state_12244__$1 = (function (){var statearr_12314 = state_12244;
(statearr_12314[(24)] = inst_12135);

return statearr_12314;
})();
if(cljs.core.truth_(inst_12136)){
var statearr_12315_12376 = state_12244__$1;
(statearr_12315_12376[(1)] = (13));

} else {
var statearr_12316_12377 = state_12244__$1;
(statearr_12316_12377[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (18))){
var inst_12171 = (state_12244[(2)]);
var state_12244__$1 = state_12244;
var statearr_12317_12378 = state_12244__$1;
(statearr_12317_12378[(2)] = inst_12171);

(statearr_12317_12378[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (42))){
var state_12244__$1 = state_12244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12244__$1,(45),dchan);
} else {
if((state_val_12245 === (37))){
var inst_12204 = (state_12244[(23)]);
var inst_12114 = (state_12244[(9)]);
var inst_12213 = (state_12244[(22)]);
var inst_12213__$1 = cljs.core.first(inst_12204);
var inst_12214 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_12213__$1,inst_12114,done);
var state_12244__$1 = (function (){var statearr_12318 = state_12244;
(statearr_12318[(22)] = inst_12213__$1);

return statearr_12318;
})();
if(cljs.core.truth_(inst_12214)){
var statearr_12319_12379 = state_12244__$1;
(statearr_12319_12379[(1)] = (39));

} else {
var statearr_12320_12380 = state_12244__$1;
(statearr_12320_12380[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12245 === (8))){
var inst_12125 = (state_12244[(14)]);
var inst_12126 = (state_12244[(15)]);
var inst_12128 = (inst_12126 < inst_12125);
var inst_12129 = inst_12128;
var state_12244__$1 = state_12244;
if(cljs.core.truth_(inst_12129)){
var statearr_12321_12381 = state_12244__$1;
(statearr_12321_12381[(1)] = (10));

} else {
var statearr_12322_12382 = state_12244__$1;
(statearr_12322_12382[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__11410__auto__ = null;
var cljs$core$async$mult_$_state_machine__11410__auto____0 = (function (){
var statearr_12323 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12323[(0)] = cljs$core$async$mult_$_state_machine__11410__auto__);

(statearr_12323[(1)] = (1));

return statearr_12323;
});
var cljs$core$async$mult_$_state_machine__11410__auto____1 = (function (state_12244){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_12244);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e12324){var ex__11413__auto__ = e12324;
var statearr_12325_12383 = state_12244;
(statearr_12325_12383[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_12244[(4)]))){
var statearr_12326_12384 = state_12244;
(statearr_12326_12384[(1)] = cljs.core.first((state_12244[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12385 = state_12244;
state_12244 = G__12385;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11410__auto__ = function(state_12244){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11410__auto____1.call(this,state_12244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11410__auto____0;
cljs$core$async$mult_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11410__auto____1;
return cljs$core$async$mult_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_12327 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_12327[(6)] = c__11484__auto___12328);

return statearr_12327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__12387 = arguments.length;
switch (G__12387) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_12389 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_12389(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_12390 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_12390(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_12391 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_12391(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_12392 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4551__auto__.call(null,m,state_map));
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4549__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_12392(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_12393 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4551__auto__.call(null,m,mode));
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4549__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_12393(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___12403 = arguments.length;
var i__4865__auto___12404 = (0);
while(true){
if((i__4865__auto___12404 < len__4864__auto___12403)){
args__4870__auto__.push((arguments[i__4865__auto___12404]));

var G__12405 = (i__4865__auto___12404 + (1));
i__4865__auto___12404 = G__12405;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12398){
var map__12399 = p__12398;
var map__12399__$1 = cljs.core.__destructure_map(map__12399);
var opts = map__12399__$1;
var statearr_12400_12406 = state;
(statearr_12400_12406[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_12401_12407 = state;
(statearr_12401_12407[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_12402_12408 = state;
(statearr_12402_12408[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12394){
var G__12395 = cljs.core.first(seq12394);
var seq12394__$1 = cljs.core.next(seq12394);
var G__12396 = cljs.core.first(seq12394__$1);
var seq12394__$2 = cljs.core.next(seq12394__$1);
var G__12397 = cljs.core.first(seq12394__$2);
var seq12394__$3 = cljs.core.next(seq12394__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12395,G__12396,G__12397,seq12394__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12409 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12409 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12410){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12410 = meta12410;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12409.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12411,meta12410__$1){
var self__ = this;
var _12411__$1 = this;
return (new cljs.core.async.t_cljs$core$async12409(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12410__$1));
}));

(cljs.core.async.t_cljs$core$async12409.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12411){
var self__ = this;
var _12411__$1 = this;
return self__.meta12410;
}));

(cljs.core.async.t_cljs$core$async12409.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12409.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async12409.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12409.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12409.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12409.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12409.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12409.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12409.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12410","meta12410",382240377,null)], null);
}));

(cljs.core.async.t_cljs$core$async12409.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12409.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12409");

(cljs.core.async.t_cljs$core$async12409.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12409");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12409.
 */
cljs.core.async.__GT_t_cljs$core$async12409 = (function cljs$core$async$mix_$___GT_t_cljs$core$async12409(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12410){
return (new cljs.core.async.t_cljs$core$async12409(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12410));
});

}

return (new cljs.core.async.t_cljs$core$async12409(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11484__auto___12524 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_12479){
var state_val_12480 = (state_12479[(1)]);
if((state_val_12480 === (7))){
var inst_12439 = (state_12479[(2)]);
var state_12479__$1 = state_12479;
if(cljs.core.truth_(inst_12439)){
var statearr_12481_12525 = state_12479__$1;
(statearr_12481_12525[(1)] = (8));

} else {
var statearr_12482_12526 = state_12479__$1;
(statearr_12482_12526[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (20))){
var inst_12432 = (state_12479[(7)]);
var state_12479__$1 = state_12479;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12479__$1,(23),out,inst_12432);
} else {
if((state_val_12480 === (1))){
var inst_12415 = calc_state();
var inst_12416 = cljs.core.__destructure_map(inst_12415);
var inst_12417 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12416,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12418 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12416,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12419 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12416,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12420 = inst_12415;
var state_12479__$1 = (function (){var statearr_12483 = state_12479;
(statearr_12483[(8)] = inst_12419);

(statearr_12483[(9)] = inst_12417);

(statearr_12483[(10)] = inst_12418);

(statearr_12483[(11)] = inst_12420);

return statearr_12483;
})();
var statearr_12484_12527 = state_12479__$1;
(statearr_12484_12527[(2)] = null);

(statearr_12484_12527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (24))){
var inst_12423 = (state_12479[(12)]);
var inst_12420 = inst_12423;
var state_12479__$1 = (function (){var statearr_12485 = state_12479;
(statearr_12485[(11)] = inst_12420);

return statearr_12485;
})();
var statearr_12486_12528 = state_12479__$1;
(statearr_12486_12528[(2)] = null);

(statearr_12486_12528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (4))){
var inst_12432 = (state_12479[(7)]);
var inst_12434 = (state_12479[(13)]);
var inst_12431 = (state_12479[(2)]);
var inst_12432__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12431,(0),null);
var inst_12433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12431,(1),null);
var inst_12434__$1 = (inst_12432__$1 == null);
var state_12479__$1 = (function (){var statearr_12487 = state_12479;
(statearr_12487[(7)] = inst_12432__$1);

(statearr_12487[(14)] = inst_12433);

(statearr_12487[(13)] = inst_12434__$1);

return statearr_12487;
})();
if(cljs.core.truth_(inst_12434__$1)){
var statearr_12488_12529 = state_12479__$1;
(statearr_12488_12529[(1)] = (5));

} else {
var statearr_12489_12530 = state_12479__$1;
(statearr_12489_12530[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (15))){
var inst_12453 = (state_12479[(15)]);
var inst_12424 = (state_12479[(16)]);
var inst_12453__$1 = cljs.core.empty_QMARK_(inst_12424);
var state_12479__$1 = (function (){var statearr_12490 = state_12479;
(statearr_12490[(15)] = inst_12453__$1);

return statearr_12490;
})();
if(inst_12453__$1){
var statearr_12491_12531 = state_12479__$1;
(statearr_12491_12531[(1)] = (17));

} else {
var statearr_12492_12532 = state_12479__$1;
(statearr_12492_12532[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (21))){
var inst_12423 = (state_12479[(12)]);
var inst_12420 = inst_12423;
var state_12479__$1 = (function (){var statearr_12493 = state_12479;
(statearr_12493[(11)] = inst_12420);

return statearr_12493;
})();
var statearr_12494_12533 = state_12479__$1;
(statearr_12494_12533[(2)] = null);

(statearr_12494_12533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (13))){
var inst_12446 = (state_12479[(2)]);
var inst_12447 = calc_state();
var inst_12420 = inst_12447;
var state_12479__$1 = (function (){var statearr_12495 = state_12479;
(statearr_12495[(17)] = inst_12446);

(statearr_12495[(11)] = inst_12420);

return statearr_12495;
})();
var statearr_12496_12534 = state_12479__$1;
(statearr_12496_12534[(2)] = null);

(statearr_12496_12534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (22))){
var inst_12473 = (state_12479[(2)]);
var state_12479__$1 = state_12479;
var statearr_12497_12535 = state_12479__$1;
(statearr_12497_12535[(2)] = inst_12473);

(statearr_12497_12535[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (6))){
var inst_12433 = (state_12479[(14)]);
var inst_12437 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_12433,change);
var state_12479__$1 = state_12479;
var statearr_12498_12536 = state_12479__$1;
(statearr_12498_12536[(2)] = inst_12437);

(statearr_12498_12536[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (25))){
var state_12479__$1 = state_12479;
var statearr_12499_12537 = state_12479__$1;
(statearr_12499_12537[(2)] = null);

(statearr_12499_12537[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (17))){
var inst_12425 = (state_12479[(18)]);
var inst_12433 = (state_12479[(14)]);
var inst_12455 = (inst_12425.cljs$core$IFn$_invoke$arity$1 ? inst_12425.cljs$core$IFn$_invoke$arity$1(inst_12433) : inst_12425.call(null,inst_12433));
var inst_12456 = cljs.core.not(inst_12455);
var state_12479__$1 = state_12479;
var statearr_12500_12538 = state_12479__$1;
(statearr_12500_12538[(2)] = inst_12456);

(statearr_12500_12538[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (3))){
var inst_12477 = (state_12479[(2)]);
var state_12479__$1 = state_12479;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12479__$1,inst_12477);
} else {
if((state_val_12480 === (12))){
var state_12479__$1 = state_12479;
var statearr_12501_12539 = state_12479__$1;
(statearr_12501_12539[(2)] = null);

(statearr_12501_12539[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (2))){
var inst_12423 = (state_12479[(12)]);
var inst_12420 = (state_12479[(11)]);
var inst_12423__$1 = cljs.core.__destructure_map(inst_12420);
var inst_12424 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12423__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12425 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12423__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12426 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12423__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12479__$1 = (function (){var statearr_12502 = state_12479;
(statearr_12502[(18)] = inst_12425);

(statearr_12502[(12)] = inst_12423__$1);

(statearr_12502[(16)] = inst_12424);

return statearr_12502;
})();
return cljs.core.async.ioc_alts_BANG_(state_12479__$1,(4),inst_12426);
} else {
if((state_val_12480 === (23))){
var inst_12464 = (state_12479[(2)]);
var state_12479__$1 = state_12479;
if(cljs.core.truth_(inst_12464)){
var statearr_12503_12540 = state_12479__$1;
(statearr_12503_12540[(1)] = (24));

} else {
var statearr_12504_12541 = state_12479__$1;
(statearr_12504_12541[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (19))){
var inst_12459 = (state_12479[(2)]);
var state_12479__$1 = state_12479;
var statearr_12505_12542 = state_12479__$1;
(statearr_12505_12542[(2)] = inst_12459);

(statearr_12505_12542[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (11))){
var inst_12433 = (state_12479[(14)]);
var inst_12443 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_12433);
var state_12479__$1 = state_12479;
var statearr_12506_12543 = state_12479__$1;
(statearr_12506_12543[(2)] = inst_12443);

(statearr_12506_12543[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (9))){
var inst_12433 = (state_12479[(14)]);
var inst_12450 = (state_12479[(19)]);
var inst_12424 = (state_12479[(16)]);
var inst_12450__$1 = (inst_12424.cljs$core$IFn$_invoke$arity$1 ? inst_12424.cljs$core$IFn$_invoke$arity$1(inst_12433) : inst_12424.call(null,inst_12433));
var state_12479__$1 = (function (){var statearr_12507 = state_12479;
(statearr_12507[(19)] = inst_12450__$1);

return statearr_12507;
})();
if(cljs.core.truth_(inst_12450__$1)){
var statearr_12508_12544 = state_12479__$1;
(statearr_12508_12544[(1)] = (14));

} else {
var statearr_12509_12545 = state_12479__$1;
(statearr_12509_12545[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (5))){
var inst_12434 = (state_12479[(13)]);
var state_12479__$1 = state_12479;
var statearr_12510_12546 = state_12479__$1;
(statearr_12510_12546[(2)] = inst_12434);

(statearr_12510_12546[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (14))){
var inst_12450 = (state_12479[(19)]);
var state_12479__$1 = state_12479;
var statearr_12511_12547 = state_12479__$1;
(statearr_12511_12547[(2)] = inst_12450);

(statearr_12511_12547[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (26))){
var inst_12469 = (state_12479[(2)]);
var state_12479__$1 = state_12479;
var statearr_12512_12548 = state_12479__$1;
(statearr_12512_12548[(2)] = inst_12469);

(statearr_12512_12548[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (16))){
var inst_12461 = (state_12479[(2)]);
var state_12479__$1 = state_12479;
if(cljs.core.truth_(inst_12461)){
var statearr_12513_12549 = state_12479__$1;
(statearr_12513_12549[(1)] = (20));

} else {
var statearr_12514_12550 = state_12479__$1;
(statearr_12514_12550[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (10))){
var inst_12475 = (state_12479[(2)]);
var state_12479__$1 = state_12479;
var statearr_12515_12551 = state_12479__$1;
(statearr_12515_12551[(2)] = inst_12475);

(statearr_12515_12551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (18))){
var inst_12453 = (state_12479[(15)]);
var state_12479__$1 = state_12479;
var statearr_12516_12552 = state_12479__$1;
(statearr_12516_12552[(2)] = inst_12453);

(statearr_12516_12552[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12480 === (8))){
var inst_12432 = (state_12479[(7)]);
var inst_12441 = (inst_12432 == null);
var state_12479__$1 = state_12479;
if(cljs.core.truth_(inst_12441)){
var statearr_12517_12553 = state_12479__$1;
(statearr_12517_12553[(1)] = (11));

} else {
var statearr_12518_12554 = state_12479__$1;
(statearr_12518_12554[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__11410__auto__ = null;
var cljs$core$async$mix_$_state_machine__11410__auto____0 = (function (){
var statearr_12519 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12519[(0)] = cljs$core$async$mix_$_state_machine__11410__auto__);

(statearr_12519[(1)] = (1));

return statearr_12519;
});
var cljs$core$async$mix_$_state_machine__11410__auto____1 = (function (state_12479){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_12479);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e12520){var ex__11413__auto__ = e12520;
var statearr_12521_12555 = state_12479;
(statearr_12521_12555[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_12479[(4)]))){
var statearr_12522_12556 = state_12479;
(statearr_12522_12556[(1)] = cljs.core.first((state_12479[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12557 = state_12479;
state_12479 = G__12557;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11410__auto__ = function(state_12479){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11410__auto____1.call(this,state_12479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11410__auto____0;
cljs$core$async$mix_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11410__auto____1;
return cljs$core$async$mix_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_12523 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_12523[(6)] = c__11484__auto___12524);

return statearr_12523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_12560 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4551__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4549__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_12560(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_12561 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4551__auto__.call(null,p,v,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4549__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_12561(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_12562 = (function() {
var G__12563 = null;
var G__12563__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4551__auto__.call(null,p));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4549__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__12563__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4551__auto__.call(null,p,v));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4549__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__12563 = function(p,v){
switch(arguments.length){
case 1:
return G__12563__1.call(this,p);
case 2:
return G__12563__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12563.cljs$core$IFn$_invoke$arity$1 = G__12563__1;
G__12563.cljs$core$IFn$_invoke$arity$2 = G__12563__2;
return G__12563;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__12559 = arguments.length;
switch (G__12559) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12562.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12562.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__12567 = arguments.length;
switch (G__12567) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__12565_SHARP_){
if(cljs.core.truth_((p1__12565_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__12565_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__12565_SHARP_.call(null,topic)))){
return p1__12565_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__12565_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12568 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12568 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12569){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12569 = meta12569;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12568.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12570,meta12569__$1){
var self__ = this;
var _12570__$1 = this;
return (new cljs.core.async.t_cljs$core$async12568(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12569__$1));
}));

(cljs.core.async.t_cljs$core$async12568.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12570){
var self__ = this;
var _12570__$1 = this;
return self__.meta12569;
}));

(cljs.core.async.t_cljs$core$async12568.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12568.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12568.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12568.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async12568.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async12568.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async12568.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async12568.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12569","meta12569",728397350,null)], null);
}));

(cljs.core.async.t_cljs$core$async12568.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12568.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12568");

(cljs.core.async.t_cljs$core$async12568.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12568");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12568.
 */
cljs.core.async.__GT_t_cljs$core$async12568 = (function cljs$core$async$__GT_t_cljs$core$async12568(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12569){
return (new cljs.core.async.t_cljs$core$async12568(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12569));
});

}

return (new cljs.core.async.t_cljs$core$async12568(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11484__auto___12689 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_12642){
var state_val_12643 = (state_12642[(1)]);
if((state_val_12643 === (7))){
var inst_12638 = (state_12642[(2)]);
var state_12642__$1 = state_12642;
var statearr_12644_12690 = state_12642__$1;
(statearr_12644_12690[(2)] = inst_12638);

(statearr_12644_12690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (20))){
var state_12642__$1 = state_12642;
var statearr_12645_12691 = state_12642__$1;
(statearr_12645_12691[(2)] = null);

(statearr_12645_12691[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (1))){
var state_12642__$1 = state_12642;
var statearr_12646_12692 = state_12642__$1;
(statearr_12646_12692[(2)] = null);

(statearr_12646_12692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (24))){
var inst_12621 = (state_12642[(7)]);
var inst_12630 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_12621);
var state_12642__$1 = state_12642;
var statearr_12647_12693 = state_12642__$1;
(statearr_12647_12693[(2)] = inst_12630);

(statearr_12647_12693[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (4))){
var inst_12573 = (state_12642[(8)]);
var inst_12573__$1 = (state_12642[(2)]);
var inst_12574 = (inst_12573__$1 == null);
var state_12642__$1 = (function (){var statearr_12648 = state_12642;
(statearr_12648[(8)] = inst_12573__$1);

return statearr_12648;
})();
if(cljs.core.truth_(inst_12574)){
var statearr_12649_12694 = state_12642__$1;
(statearr_12649_12694[(1)] = (5));

} else {
var statearr_12650_12695 = state_12642__$1;
(statearr_12650_12695[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (15))){
var inst_12615 = (state_12642[(2)]);
var state_12642__$1 = state_12642;
var statearr_12651_12696 = state_12642__$1;
(statearr_12651_12696[(2)] = inst_12615);

(statearr_12651_12696[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (21))){
var inst_12635 = (state_12642[(2)]);
var state_12642__$1 = (function (){var statearr_12652 = state_12642;
(statearr_12652[(9)] = inst_12635);

return statearr_12652;
})();
var statearr_12653_12697 = state_12642__$1;
(statearr_12653_12697[(2)] = null);

(statearr_12653_12697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (13))){
var inst_12597 = (state_12642[(10)]);
var inst_12599 = cljs.core.chunked_seq_QMARK_(inst_12597);
var state_12642__$1 = state_12642;
if(inst_12599){
var statearr_12654_12698 = state_12642__$1;
(statearr_12654_12698[(1)] = (16));

} else {
var statearr_12655_12699 = state_12642__$1;
(statearr_12655_12699[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (22))){
var inst_12627 = (state_12642[(2)]);
var state_12642__$1 = state_12642;
if(cljs.core.truth_(inst_12627)){
var statearr_12656_12700 = state_12642__$1;
(statearr_12656_12700[(1)] = (23));

} else {
var statearr_12657_12701 = state_12642__$1;
(statearr_12657_12701[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (6))){
var inst_12623 = (state_12642[(11)]);
var inst_12621 = (state_12642[(7)]);
var inst_12573 = (state_12642[(8)]);
var inst_12621__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_12573) : topic_fn.call(null,inst_12573));
var inst_12622 = cljs.core.deref(mults);
var inst_12623__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12622,inst_12621__$1);
var state_12642__$1 = (function (){var statearr_12658 = state_12642;
(statearr_12658[(11)] = inst_12623__$1);

(statearr_12658[(7)] = inst_12621__$1);

return statearr_12658;
})();
if(cljs.core.truth_(inst_12623__$1)){
var statearr_12659_12702 = state_12642__$1;
(statearr_12659_12702[(1)] = (19));

} else {
var statearr_12660_12703 = state_12642__$1;
(statearr_12660_12703[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (25))){
var inst_12632 = (state_12642[(2)]);
var state_12642__$1 = state_12642;
var statearr_12661_12704 = state_12642__$1;
(statearr_12661_12704[(2)] = inst_12632);

(statearr_12661_12704[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (17))){
var inst_12597 = (state_12642[(10)]);
var inst_12606 = cljs.core.first(inst_12597);
var inst_12607 = cljs.core.async.muxch_STAR_(inst_12606);
var inst_12608 = cljs.core.async.close_BANG_(inst_12607);
var inst_12609 = cljs.core.next(inst_12597);
var inst_12583 = inst_12609;
var inst_12584 = null;
var inst_12585 = (0);
var inst_12586 = (0);
var state_12642__$1 = (function (){var statearr_12662 = state_12642;
(statearr_12662[(12)] = inst_12608);

(statearr_12662[(13)] = inst_12583);

(statearr_12662[(14)] = inst_12584);

(statearr_12662[(15)] = inst_12585);

(statearr_12662[(16)] = inst_12586);

return statearr_12662;
})();
var statearr_12663_12705 = state_12642__$1;
(statearr_12663_12705[(2)] = null);

(statearr_12663_12705[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (3))){
var inst_12640 = (state_12642[(2)]);
var state_12642__$1 = state_12642;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12642__$1,inst_12640);
} else {
if((state_val_12643 === (12))){
var inst_12617 = (state_12642[(2)]);
var state_12642__$1 = state_12642;
var statearr_12664_12706 = state_12642__$1;
(statearr_12664_12706[(2)] = inst_12617);

(statearr_12664_12706[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (2))){
var state_12642__$1 = state_12642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12642__$1,(4),ch);
} else {
if((state_val_12643 === (23))){
var state_12642__$1 = state_12642;
var statearr_12665_12707 = state_12642__$1;
(statearr_12665_12707[(2)] = null);

(statearr_12665_12707[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (19))){
var inst_12623 = (state_12642[(11)]);
var inst_12573 = (state_12642[(8)]);
var inst_12625 = cljs.core.async.muxch_STAR_(inst_12623);
var state_12642__$1 = state_12642;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12642__$1,(22),inst_12625,inst_12573);
} else {
if((state_val_12643 === (11))){
var inst_12597 = (state_12642[(10)]);
var inst_12583 = (state_12642[(13)]);
var inst_12597__$1 = cljs.core.seq(inst_12583);
var state_12642__$1 = (function (){var statearr_12666 = state_12642;
(statearr_12666[(10)] = inst_12597__$1);

return statearr_12666;
})();
if(inst_12597__$1){
var statearr_12667_12708 = state_12642__$1;
(statearr_12667_12708[(1)] = (13));

} else {
var statearr_12668_12709 = state_12642__$1;
(statearr_12668_12709[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (9))){
var inst_12619 = (state_12642[(2)]);
var state_12642__$1 = state_12642;
var statearr_12669_12710 = state_12642__$1;
(statearr_12669_12710[(2)] = inst_12619);

(statearr_12669_12710[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (5))){
var inst_12580 = cljs.core.deref(mults);
var inst_12581 = cljs.core.vals(inst_12580);
var inst_12582 = cljs.core.seq(inst_12581);
var inst_12583 = inst_12582;
var inst_12584 = null;
var inst_12585 = (0);
var inst_12586 = (0);
var state_12642__$1 = (function (){var statearr_12670 = state_12642;
(statearr_12670[(13)] = inst_12583);

(statearr_12670[(14)] = inst_12584);

(statearr_12670[(15)] = inst_12585);

(statearr_12670[(16)] = inst_12586);

return statearr_12670;
})();
var statearr_12671_12711 = state_12642__$1;
(statearr_12671_12711[(2)] = null);

(statearr_12671_12711[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (14))){
var state_12642__$1 = state_12642;
var statearr_12675_12712 = state_12642__$1;
(statearr_12675_12712[(2)] = null);

(statearr_12675_12712[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (16))){
var inst_12597 = (state_12642[(10)]);
var inst_12601 = cljs.core.chunk_first(inst_12597);
var inst_12602 = cljs.core.chunk_rest(inst_12597);
var inst_12603 = cljs.core.count(inst_12601);
var inst_12583 = inst_12602;
var inst_12584 = inst_12601;
var inst_12585 = inst_12603;
var inst_12586 = (0);
var state_12642__$1 = (function (){var statearr_12676 = state_12642;
(statearr_12676[(13)] = inst_12583);

(statearr_12676[(14)] = inst_12584);

(statearr_12676[(15)] = inst_12585);

(statearr_12676[(16)] = inst_12586);

return statearr_12676;
})();
var statearr_12677_12713 = state_12642__$1;
(statearr_12677_12713[(2)] = null);

(statearr_12677_12713[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (10))){
var inst_12583 = (state_12642[(13)]);
var inst_12584 = (state_12642[(14)]);
var inst_12585 = (state_12642[(15)]);
var inst_12586 = (state_12642[(16)]);
var inst_12591 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12584,inst_12586);
var inst_12592 = cljs.core.async.muxch_STAR_(inst_12591);
var inst_12593 = cljs.core.async.close_BANG_(inst_12592);
var inst_12594 = (inst_12586 + (1));
var tmp12672 = inst_12583;
var tmp12673 = inst_12584;
var tmp12674 = inst_12585;
var inst_12583__$1 = tmp12672;
var inst_12584__$1 = tmp12673;
var inst_12585__$1 = tmp12674;
var inst_12586__$1 = inst_12594;
var state_12642__$1 = (function (){var statearr_12678 = state_12642;
(statearr_12678[(17)] = inst_12593);

(statearr_12678[(13)] = inst_12583__$1);

(statearr_12678[(14)] = inst_12584__$1);

(statearr_12678[(15)] = inst_12585__$1);

(statearr_12678[(16)] = inst_12586__$1);

return statearr_12678;
})();
var statearr_12679_12714 = state_12642__$1;
(statearr_12679_12714[(2)] = null);

(statearr_12679_12714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (18))){
var inst_12612 = (state_12642[(2)]);
var state_12642__$1 = state_12642;
var statearr_12680_12715 = state_12642__$1;
(statearr_12680_12715[(2)] = inst_12612);

(statearr_12680_12715[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12643 === (8))){
var inst_12585 = (state_12642[(15)]);
var inst_12586 = (state_12642[(16)]);
var inst_12588 = (inst_12586 < inst_12585);
var inst_12589 = inst_12588;
var state_12642__$1 = state_12642;
if(cljs.core.truth_(inst_12589)){
var statearr_12681_12716 = state_12642__$1;
(statearr_12681_12716[(1)] = (10));

} else {
var statearr_12682_12717 = state_12642__$1;
(statearr_12682_12717[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11410__auto__ = null;
var cljs$core$async$state_machine__11410__auto____0 = (function (){
var statearr_12683 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12683[(0)] = cljs$core$async$state_machine__11410__auto__);

(statearr_12683[(1)] = (1));

return statearr_12683;
});
var cljs$core$async$state_machine__11410__auto____1 = (function (state_12642){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_12642);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e12684){var ex__11413__auto__ = e12684;
var statearr_12685_12718 = state_12642;
(statearr_12685_12718[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_12642[(4)]))){
var statearr_12686_12719 = state_12642;
(statearr_12686_12719[(1)] = cljs.core.first((state_12642[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12720 = state_12642;
state_12642 = G__12720;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$state_machine__11410__auto__ = function(state_12642){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11410__auto____1.call(this,state_12642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11410__auto____0;
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11410__auto____1;
return cljs$core$async$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_12687 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_12687[(6)] = c__11484__auto___12689);

return statearr_12687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12722 = arguments.length;
switch (G__12722) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12725 = arguments.length;
switch (G__12725) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12728 = arguments.length;
switch (G__12728) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__11484__auto___12806 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_12771){
var state_val_12772 = (state_12771[(1)]);
if((state_val_12772 === (7))){
var state_12771__$1 = state_12771;
var statearr_12773_12807 = state_12771__$1;
(statearr_12773_12807[(2)] = null);

(statearr_12773_12807[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (1))){
var state_12771__$1 = state_12771;
var statearr_12774_12808 = state_12771__$1;
(statearr_12774_12808[(2)] = null);

(statearr_12774_12808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (4))){
var inst_12732 = (state_12771[(7)]);
var inst_12731 = (state_12771[(8)]);
var inst_12734 = (inst_12732 < inst_12731);
var state_12771__$1 = state_12771;
if(cljs.core.truth_(inst_12734)){
var statearr_12775_12809 = state_12771__$1;
(statearr_12775_12809[(1)] = (6));

} else {
var statearr_12776_12810 = state_12771__$1;
(statearr_12776_12810[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (15))){
var inst_12757 = (state_12771[(9)]);
var inst_12762 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_12757);
var state_12771__$1 = state_12771;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12771__$1,(17),out,inst_12762);
} else {
if((state_val_12772 === (13))){
var inst_12757 = (state_12771[(9)]);
var inst_12757__$1 = (state_12771[(2)]);
var inst_12758 = cljs.core.some(cljs.core.nil_QMARK_,inst_12757__$1);
var state_12771__$1 = (function (){var statearr_12777 = state_12771;
(statearr_12777[(9)] = inst_12757__$1);

return statearr_12777;
})();
if(cljs.core.truth_(inst_12758)){
var statearr_12778_12811 = state_12771__$1;
(statearr_12778_12811[(1)] = (14));

} else {
var statearr_12779_12812 = state_12771__$1;
(statearr_12779_12812[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (6))){
var state_12771__$1 = state_12771;
var statearr_12780_12813 = state_12771__$1;
(statearr_12780_12813[(2)] = null);

(statearr_12780_12813[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (17))){
var inst_12764 = (state_12771[(2)]);
var state_12771__$1 = (function (){var statearr_12782 = state_12771;
(statearr_12782[(10)] = inst_12764);

return statearr_12782;
})();
var statearr_12783_12814 = state_12771__$1;
(statearr_12783_12814[(2)] = null);

(statearr_12783_12814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (3))){
var inst_12769 = (state_12771[(2)]);
var state_12771__$1 = state_12771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12771__$1,inst_12769);
} else {
if((state_val_12772 === (12))){
var _ = (function (){var statearr_12784 = state_12771;
(statearr_12784[(4)] = cljs.core.rest((state_12771[(4)])));

return statearr_12784;
})();
var state_12771__$1 = state_12771;
var ex12781 = (state_12771__$1[(2)]);
var statearr_12785_12815 = state_12771__$1;
(statearr_12785_12815[(5)] = ex12781);


if((ex12781 instanceof Object)){
var statearr_12786_12816 = state_12771__$1;
(statearr_12786_12816[(1)] = (11));

(statearr_12786_12816[(5)] = null);

} else {
throw ex12781;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (2))){
var inst_12730 = cljs.core.reset_BANG_(dctr,cnt);
var inst_12731 = cnt;
var inst_12732 = (0);
var state_12771__$1 = (function (){var statearr_12787 = state_12771;
(statearr_12787[(7)] = inst_12732);

(statearr_12787[(11)] = inst_12730);

(statearr_12787[(8)] = inst_12731);

return statearr_12787;
})();
var statearr_12788_12817 = state_12771__$1;
(statearr_12788_12817[(2)] = null);

(statearr_12788_12817[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (11))){
var inst_12736 = (state_12771[(2)]);
var inst_12737 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_12771__$1 = (function (){var statearr_12789 = state_12771;
(statearr_12789[(12)] = inst_12736);

return statearr_12789;
})();
var statearr_12790_12818 = state_12771__$1;
(statearr_12790_12818[(2)] = inst_12737);

(statearr_12790_12818[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (9))){
var inst_12732 = (state_12771[(7)]);
var _ = (function (){var statearr_12791 = state_12771;
(statearr_12791[(4)] = cljs.core.cons((12),(state_12771[(4)])));

return statearr_12791;
})();
var inst_12743 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_12732) : chs__$1.call(null,inst_12732));
var inst_12744 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_12732) : done.call(null,inst_12732));
var inst_12745 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_12743,inst_12744);
var ___$1 = (function (){var statearr_12792 = state_12771;
(statearr_12792[(4)] = cljs.core.rest((state_12771[(4)])));

return statearr_12792;
})();
var state_12771__$1 = state_12771;
var statearr_12793_12819 = state_12771__$1;
(statearr_12793_12819[(2)] = inst_12745);

(statearr_12793_12819[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (5))){
var inst_12755 = (state_12771[(2)]);
var state_12771__$1 = (function (){var statearr_12794 = state_12771;
(statearr_12794[(13)] = inst_12755);

return statearr_12794;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12771__$1,(13),dchan);
} else {
if((state_val_12772 === (14))){
var inst_12760 = cljs.core.async.close_BANG_(out);
var state_12771__$1 = state_12771;
var statearr_12795_12820 = state_12771__$1;
(statearr_12795_12820[(2)] = inst_12760);

(statearr_12795_12820[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (16))){
var inst_12767 = (state_12771[(2)]);
var state_12771__$1 = state_12771;
var statearr_12796_12821 = state_12771__$1;
(statearr_12796_12821[(2)] = inst_12767);

(statearr_12796_12821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (10))){
var inst_12732 = (state_12771[(7)]);
var inst_12748 = (state_12771[(2)]);
var inst_12749 = (inst_12732 + (1));
var inst_12732__$1 = inst_12749;
var state_12771__$1 = (function (){var statearr_12797 = state_12771;
(statearr_12797[(7)] = inst_12732__$1);

(statearr_12797[(14)] = inst_12748);

return statearr_12797;
})();
var statearr_12798_12822 = state_12771__$1;
(statearr_12798_12822[(2)] = null);

(statearr_12798_12822[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12772 === (8))){
var inst_12753 = (state_12771[(2)]);
var state_12771__$1 = state_12771;
var statearr_12799_12823 = state_12771__$1;
(statearr_12799_12823[(2)] = inst_12753);

(statearr_12799_12823[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11410__auto__ = null;
var cljs$core$async$state_machine__11410__auto____0 = (function (){
var statearr_12800 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12800[(0)] = cljs$core$async$state_machine__11410__auto__);

(statearr_12800[(1)] = (1));

return statearr_12800;
});
var cljs$core$async$state_machine__11410__auto____1 = (function (state_12771){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_12771);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e12801){var ex__11413__auto__ = e12801;
var statearr_12802_12824 = state_12771;
(statearr_12802_12824[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_12771[(4)]))){
var statearr_12803_12825 = state_12771;
(statearr_12803_12825[(1)] = cljs.core.first((state_12771[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12826 = state_12771;
state_12771 = G__12826;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$state_machine__11410__auto__ = function(state_12771){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11410__auto____1.call(this,state_12771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11410__auto____0;
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11410__auto____1;
return cljs$core$async$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_12804 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_12804[(6)] = c__11484__auto___12806);

return statearr_12804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12829 = arguments.length;
switch (G__12829) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11484__auto___12884 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_12861){
var state_val_12862 = (state_12861[(1)]);
if((state_val_12862 === (7))){
var inst_12841 = (state_12861[(7)]);
var inst_12840 = (state_12861[(8)]);
var inst_12840__$1 = (state_12861[(2)]);
var inst_12841__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12840__$1,(0),null);
var inst_12842 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12840__$1,(1),null);
var inst_12843 = (inst_12841__$1 == null);
var state_12861__$1 = (function (){var statearr_12863 = state_12861;
(statearr_12863[(7)] = inst_12841__$1);

(statearr_12863[(9)] = inst_12842);

(statearr_12863[(8)] = inst_12840__$1);

return statearr_12863;
})();
if(cljs.core.truth_(inst_12843)){
var statearr_12864_12885 = state_12861__$1;
(statearr_12864_12885[(1)] = (8));

} else {
var statearr_12865_12886 = state_12861__$1;
(statearr_12865_12886[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (1))){
var inst_12830 = cljs.core.vec(chs);
var inst_12831 = inst_12830;
var state_12861__$1 = (function (){var statearr_12866 = state_12861;
(statearr_12866[(10)] = inst_12831);

return statearr_12866;
})();
var statearr_12867_12887 = state_12861__$1;
(statearr_12867_12887[(2)] = null);

(statearr_12867_12887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (4))){
var inst_12831 = (state_12861[(10)]);
var state_12861__$1 = state_12861;
return cljs.core.async.ioc_alts_BANG_(state_12861__$1,(7),inst_12831);
} else {
if((state_val_12862 === (6))){
var inst_12857 = (state_12861[(2)]);
var state_12861__$1 = state_12861;
var statearr_12868_12888 = state_12861__$1;
(statearr_12868_12888[(2)] = inst_12857);

(statearr_12868_12888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (3))){
var inst_12859 = (state_12861[(2)]);
var state_12861__$1 = state_12861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12861__$1,inst_12859);
} else {
if((state_val_12862 === (2))){
var inst_12831 = (state_12861[(10)]);
var inst_12833 = cljs.core.count(inst_12831);
var inst_12834 = (inst_12833 > (0));
var state_12861__$1 = state_12861;
if(cljs.core.truth_(inst_12834)){
var statearr_12870_12889 = state_12861__$1;
(statearr_12870_12889[(1)] = (4));

} else {
var statearr_12871_12890 = state_12861__$1;
(statearr_12871_12890[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (11))){
var inst_12831 = (state_12861[(10)]);
var inst_12850 = (state_12861[(2)]);
var tmp12869 = inst_12831;
var inst_12831__$1 = tmp12869;
var state_12861__$1 = (function (){var statearr_12872 = state_12861;
(statearr_12872[(10)] = inst_12831__$1);

(statearr_12872[(11)] = inst_12850);

return statearr_12872;
})();
var statearr_12873_12891 = state_12861__$1;
(statearr_12873_12891[(2)] = null);

(statearr_12873_12891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (9))){
var inst_12841 = (state_12861[(7)]);
var state_12861__$1 = state_12861;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12861__$1,(11),out,inst_12841);
} else {
if((state_val_12862 === (5))){
var inst_12855 = cljs.core.async.close_BANG_(out);
var state_12861__$1 = state_12861;
var statearr_12874_12892 = state_12861__$1;
(statearr_12874_12892[(2)] = inst_12855);

(statearr_12874_12892[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (10))){
var inst_12853 = (state_12861[(2)]);
var state_12861__$1 = state_12861;
var statearr_12875_12893 = state_12861__$1;
(statearr_12875_12893[(2)] = inst_12853);

(statearr_12875_12893[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12862 === (8))){
var inst_12831 = (state_12861[(10)]);
var inst_12841 = (state_12861[(7)]);
var inst_12842 = (state_12861[(9)]);
var inst_12840 = (state_12861[(8)]);
var inst_12845 = (function (){var cs = inst_12831;
var vec__12836 = inst_12840;
var v = inst_12841;
var c = inst_12842;
return (function (p1__12827_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__12827_SHARP_);
});
})();
var inst_12846 = cljs.core.filterv(inst_12845,inst_12831);
var inst_12831__$1 = inst_12846;
var state_12861__$1 = (function (){var statearr_12876 = state_12861;
(statearr_12876[(10)] = inst_12831__$1);

return statearr_12876;
})();
var statearr_12877_12894 = state_12861__$1;
(statearr_12877_12894[(2)] = null);

(statearr_12877_12894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11410__auto__ = null;
var cljs$core$async$state_machine__11410__auto____0 = (function (){
var statearr_12878 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12878[(0)] = cljs$core$async$state_machine__11410__auto__);

(statearr_12878[(1)] = (1));

return statearr_12878;
});
var cljs$core$async$state_machine__11410__auto____1 = (function (state_12861){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_12861);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e12879){var ex__11413__auto__ = e12879;
var statearr_12880_12895 = state_12861;
(statearr_12880_12895[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_12861[(4)]))){
var statearr_12881_12896 = state_12861;
(statearr_12881_12896[(1)] = cljs.core.first((state_12861[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12897 = state_12861;
state_12861 = G__12897;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$state_machine__11410__auto__ = function(state_12861){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11410__auto____1.call(this,state_12861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11410__auto____0;
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11410__auto____1;
return cljs$core$async$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_12882 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_12882[(6)] = c__11484__auto___12884);

return statearr_12882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__12899 = arguments.length;
switch (G__12899) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11484__auto___12945 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_12923){
var state_val_12924 = (state_12923[(1)]);
if((state_val_12924 === (7))){
var inst_12905 = (state_12923[(7)]);
var inst_12905__$1 = (state_12923[(2)]);
var inst_12906 = (inst_12905__$1 == null);
var inst_12907 = cljs.core.not(inst_12906);
var state_12923__$1 = (function (){var statearr_12925 = state_12923;
(statearr_12925[(7)] = inst_12905__$1);

return statearr_12925;
})();
if(inst_12907){
var statearr_12926_12946 = state_12923__$1;
(statearr_12926_12946[(1)] = (8));

} else {
var statearr_12927_12947 = state_12923__$1;
(statearr_12927_12947[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12924 === (1))){
var inst_12900 = (0);
var state_12923__$1 = (function (){var statearr_12928 = state_12923;
(statearr_12928[(8)] = inst_12900);

return statearr_12928;
})();
var statearr_12929_12948 = state_12923__$1;
(statearr_12929_12948[(2)] = null);

(statearr_12929_12948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12924 === (4))){
var state_12923__$1 = state_12923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12923__$1,(7),ch);
} else {
if((state_val_12924 === (6))){
var inst_12918 = (state_12923[(2)]);
var state_12923__$1 = state_12923;
var statearr_12930_12949 = state_12923__$1;
(statearr_12930_12949[(2)] = inst_12918);

(statearr_12930_12949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12924 === (3))){
var inst_12920 = (state_12923[(2)]);
var inst_12921 = cljs.core.async.close_BANG_(out);
var state_12923__$1 = (function (){var statearr_12931 = state_12923;
(statearr_12931[(9)] = inst_12920);

return statearr_12931;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_12923__$1,inst_12921);
} else {
if((state_val_12924 === (2))){
var inst_12900 = (state_12923[(8)]);
var inst_12902 = (inst_12900 < n);
var state_12923__$1 = state_12923;
if(cljs.core.truth_(inst_12902)){
var statearr_12932_12950 = state_12923__$1;
(statearr_12932_12950[(1)] = (4));

} else {
var statearr_12933_12951 = state_12923__$1;
(statearr_12933_12951[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12924 === (11))){
var inst_12900 = (state_12923[(8)]);
var inst_12910 = (state_12923[(2)]);
var inst_12911 = (inst_12900 + (1));
var inst_12900__$1 = inst_12911;
var state_12923__$1 = (function (){var statearr_12934 = state_12923;
(statearr_12934[(8)] = inst_12900__$1);

(statearr_12934[(10)] = inst_12910);

return statearr_12934;
})();
var statearr_12935_12952 = state_12923__$1;
(statearr_12935_12952[(2)] = null);

(statearr_12935_12952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12924 === (9))){
var state_12923__$1 = state_12923;
var statearr_12936_12953 = state_12923__$1;
(statearr_12936_12953[(2)] = null);

(statearr_12936_12953[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12924 === (5))){
var state_12923__$1 = state_12923;
var statearr_12937_12954 = state_12923__$1;
(statearr_12937_12954[(2)] = null);

(statearr_12937_12954[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12924 === (10))){
var inst_12915 = (state_12923[(2)]);
var state_12923__$1 = state_12923;
var statearr_12938_12955 = state_12923__$1;
(statearr_12938_12955[(2)] = inst_12915);

(statearr_12938_12955[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12924 === (8))){
var inst_12905 = (state_12923[(7)]);
var state_12923__$1 = state_12923;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12923__$1,(11),out,inst_12905);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11410__auto__ = null;
var cljs$core$async$state_machine__11410__auto____0 = (function (){
var statearr_12939 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12939[(0)] = cljs$core$async$state_machine__11410__auto__);

(statearr_12939[(1)] = (1));

return statearr_12939;
});
var cljs$core$async$state_machine__11410__auto____1 = (function (state_12923){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_12923);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e12940){var ex__11413__auto__ = e12940;
var statearr_12941_12956 = state_12923;
(statearr_12941_12956[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_12923[(4)]))){
var statearr_12942_12957 = state_12923;
(statearr_12942_12957[(1)] = cljs.core.first((state_12923[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12958 = state_12923;
state_12923 = G__12958;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$state_machine__11410__auto__ = function(state_12923){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11410__auto____1.call(this,state_12923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11410__auto____0;
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11410__auto____1;
return cljs$core$async$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_12943 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_12943[(6)] = c__11484__auto___12945);

return statearr_12943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12960 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12960 = (function (f,ch,meta12961){
this.f = f;
this.ch = ch;
this.meta12961 = meta12961;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12960.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12962,meta12961__$1){
var self__ = this;
var _12962__$1 = this;
return (new cljs.core.async.t_cljs$core$async12960(self__.f,self__.ch,meta12961__$1));
}));

(cljs.core.async.t_cljs$core$async12960.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12962){
var self__ = this;
var _12962__$1 = this;
return self__.meta12961;
}));

(cljs.core.async.t_cljs$core$async12960.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12960.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12960.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12960.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12960.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12963 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12963 = (function (f,ch,meta12961,_,fn1,meta12964){
this.f = f;
this.ch = ch;
this.meta12961 = meta12961;
this._ = _;
this.fn1 = fn1;
this.meta12964 = meta12964;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12963.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12965,meta12964__$1){
var self__ = this;
var _12965__$1 = this;
return (new cljs.core.async.t_cljs$core$async12963(self__.f,self__.ch,self__.meta12961,self__._,self__.fn1,meta12964__$1));
}));

(cljs.core.async.t_cljs$core$async12963.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12965){
var self__ = this;
var _12965__$1 = this;
return self__.meta12964;
}));

(cljs.core.async.t_cljs$core$async12963.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12963.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async12963.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12963.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__12959_SHARP_){
var G__12966 = (((p1__12959_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__12959_SHARP_) : self__.f.call(null,p1__12959_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__12966) : f1.call(null,G__12966));
});
}));

(cljs.core.async.t_cljs$core$async12963.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12961","meta12961",1977208995,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12960","cljs.core.async/t_cljs$core$async12960",1019909216,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12964","meta12964",-1994495743,null)], null);
}));

(cljs.core.async.t_cljs$core$async12963.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12963.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12963");

(cljs.core.async.t_cljs$core$async12963.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12963");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12963.
 */
cljs.core.async.__GT_t_cljs$core$async12963 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12963(f__$1,ch__$1,meta12961__$1,___$2,fn1__$1,meta12964){
return (new cljs.core.async.t_cljs$core$async12963(f__$1,ch__$1,meta12961__$1,___$2,fn1__$1,meta12964));
});

}

return (new cljs.core.async.t_cljs$core$async12963(self__.f,self__.ch,self__.meta12961,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__12967 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__12967) : self__.f.call(null,G__12967));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async12960.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12960.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async12960.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12961","meta12961",1977208995,null)], null);
}));

(cljs.core.async.t_cljs$core$async12960.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12960.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12960");

(cljs.core.async.t_cljs$core$async12960.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12960");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12960.
 */
cljs.core.async.__GT_t_cljs$core$async12960 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12960(f__$1,ch__$1,meta12961){
return (new cljs.core.async.t_cljs$core$async12960(f__$1,ch__$1,meta12961));
});

}

return (new cljs.core.async.t_cljs$core$async12960(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12968 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12968 = (function (f,ch,meta12969){
this.f = f;
this.ch = ch;
this.meta12969 = meta12969;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12968.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12970,meta12969__$1){
var self__ = this;
var _12970__$1 = this;
return (new cljs.core.async.t_cljs$core$async12968(self__.f,self__.ch,meta12969__$1));
}));

(cljs.core.async.t_cljs$core$async12968.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12970){
var self__ = this;
var _12970__$1 = this;
return self__.meta12969;
}));

(cljs.core.async.t_cljs$core$async12968.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12968.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12968.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12968.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12968.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12968.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async12968.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12969","meta12969",-456070001,null)], null);
}));

(cljs.core.async.t_cljs$core$async12968.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12968.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12968");

(cljs.core.async.t_cljs$core$async12968.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12968");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12968.
 */
cljs.core.async.__GT_t_cljs$core$async12968 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12968(f__$1,ch__$1,meta12969){
return (new cljs.core.async.t_cljs$core$async12968(f__$1,ch__$1,meta12969));
});

}

return (new cljs.core.async.t_cljs$core$async12968(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12971 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12971 = (function (p,ch,meta12972){
this.p = p;
this.ch = ch;
this.meta12972 = meta12972;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12971.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12973,meta12972__$1){
var self__ = this;
var _12973__$1 = this;
return (new cljs.core.async.t_cljs$core$async12971(self__.p,self__.ch,meta12972__$1));
}));

(cljs.core.async.t_cljs$core$async12971.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12973){
var self__ = this;
var _12973__$1 = this;
return self__.meta12972;
}));

(cljs.core.async.t_cljs$core$async12971.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12971.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12971.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12971.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12971.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12971.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12971.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async12971.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12972","meta12972",-771042767,null)], null);
}));

(cljs.core.async.t_cljs$core$async12971.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12971.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12971");

(cljs.core.async.t_cljs$core$async12971.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12971");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12971.
 */
cljs.core.async.__GT_t_cljs$core$async12971 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12971(p__$1,ch__$1,meta12972){
return (new cljs.core.async.t_cljs$core$async12971(p__$1,ch__$1,meta12972));
});

}

return (new cljs.core.async.t_cljs$core$async12971(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__12975 = arguments.length;
switch (G__12975) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11484__auto___13016 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_12996){
var state_val_12997 = (state_12996[(1)]);
if((state_val_12997 === (7))){
var inst_12992 = (state_12996[(2)]);
var state_12996__$1 = state_12996;
var statearr_12998_13017 = state_12996__$1;
(statearr_12998_13017[(2)] = inst_12992);

(statearr_12998_13017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12997 === (1))){
var state_12996__$1 = state_12996;
var statearr_12999_13018 = state_12996__$1;
(statearr_12999_13018[(2)] = null);

(statearr_12999_13018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12997 === (4))){
var inst_12978 = (state_12996[(7)]);
var inst_12978__$1 = (state_12996[(2)]);
var inst_12979 = (inst_12978__$1 == null);
var state_12996__$1 = (function (){var statearr_13000 = state_12996;
(statearr_13000[(7)] = inst_12978__$1);

return statearr_13000;
})();
if(cljs.core.truth_(inst_12979)){
var statearr_13001_13019 = state_12996__$1;
(statearr_13001_13019[(1)] = (5));

} else {
var statearr_13002_13020 = state_12996__$1;
(statearr_13002_13020[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12997 === (6))){
var inst_12978 = (state_12996[(7)]);
var inst_12983 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_12978) : p.call(null,inst_12978));
var state_12996__$1 = state_12996;
if(cljs.core.truth_(inst_12983)){
var statearr_13003_13021 = state_12996__$1;
(statearr_13003_13021[(1)] = (8));

} else {
var statearr_13004_13022 = state_12996__$1;
(statearr_13004_13022[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12997 === (3))){
var inst_12994 = (state_12996[(2)]);
var state_12996__$1 = state_12996;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12996__$1,inst_12994);
} else {
if((state_val_12997 === (2))){
var state_12996__$1 = state_12996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12996__$1,(4),ch);
} else {
if((state_val_12997 === (11))){
var inst_12986 = (state_12996[(2)]);
var state_12996__$1 = state_12996;
var statearr_13005_13023 = state_12996__$1;
(statearr_13005_13023[(2)] = inst_12986);

(statearr_13005_13023[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12997 === (9))){
var state_12996__$1 = state_12996;
var statearr_13006_13024 = state_12996__$1;
(statearr_13006_13024[(2)] = null);

(statearr_13006_13024[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12997 === (5))){
var inst_12981 = cljs.core.async.close_BANG_(out);
var state_12996__$1 = state_12996;
var statearr_13007_13025 = state_12996__$1;
(statearr_13007_13025[(2)] = inst_12981);

(statearr_13007_13025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12997 === (10))){
var inst_12989 = (state_12996[(2)]);
var state_12996__$1 = (function (){var statearr_13008 = state_12996;
(statearr_13008[(8)] = inst_12989);

return statearr_13008;
})();
var statearr_13009_13026 = state_12996__$1;
(statearr_13009_13026[(2)] = null);

(statearr_13009_13026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12997 === (8))){
var inst_12978 = (state_12996[(7)]);
var state_12996__$1 = state_12996;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12996__$1,(11),out,inst_12978);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11410__auto__ = null;
var cljs$core$async$state_machine__11410__auto____0 = (function (){
var statearr_13010 = [null,null,null,null,null,null,null,null,null];
(statearr_13010[(0)] = cljs$core$async$state_machine__11410__auto__);

(statearr_13010[(1)] = (1));

return statearr_13010;
});
var cljs$core$async$state_machine__11410__auto____1 = (function (state_12996){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_12996);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e13011){var ex__11413__auto__ = e13011;
var statearr_13012_13027 = state_12996;
(statearr_13012_13027[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_12996[(4)]))){
var statearr_13013_13028 = state_12996;
(statearr_13013_13028[(1)] = cljs.core.first((state_12996[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13029 = state_12996;
state_12996 = G__13029;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$state_machine__11410__auto__ = function(state_12996){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11410__auto____1.call(this,state_12996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11410__auto____0;
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11410__auto____1;
return cljs$core$async$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_13014 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_13014[(6)] = c__11484__auto___13016);

return statearr_13014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__13031 = arguments.length;
switch (G__13031) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_13094){
var state_val_13095 = (state_13094[(1)]);
if((state_val_13095 === (7))){
var inst_13090 = (state_13094[(2)]);
var state_13094__$1 = state_13094;
var statearr_13096_13135 = state_13094__$1;
(statearr_13096_13135[(2)] = inst_13090);

(statearr_13096_13135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (20))){
var inst_13060 = (state_13094[(7)]);
var inst_13071 = (state_13094[(2)]);
var inst_13072 = cljs.core.next(inst_13060);
var inst_13046 = inst_13072;
var inst_13047 = null;
var inst_13048 = (0);
var inst_13049 = (0);
var state_13094__$1 = (function (){var statearr_13097 = state_13094;
(statearr_13097[(8)] = inst_13048);

(statearr_13097[(9)] = inst_13049);

(statearr_13097[(10)] = inst_13047);

(statearr_13097[(11)] = inst_13071);

(statearr_13097[(12)] = inst_13046);

return statearr_13097;
})();
var statearr_13098_13136 = state_13094__$1;
(statearr_13098_13136[(2)] = null);

(statearr_13098_13136[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (1))){
var state_13094__$1 = state_13094;
var statearr_13099_13137 = state_13094__$1;
(statearr_13099_13137[(2)] = null);

(statearr_13099_13137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (4))){
var inst_13035 = (state_13094[(13)]);
var inst_13035__$1 = (state_13094[(2)]);
var inst_13036 = (inst_13035__$1 == null);
var state_13094__$1 = (function (){var statearr_13100 = state_13094;
(statearr_13100[(13)] = inst_13035__$1);

return statearr_13100;
})();
if(cljs.core.truth_(inst_13036)){
var statearr_13101_13138 = state_13094__$1;
(statearr_13101_13138[(1)] = (5));

} else {
var statearr_13102_13139 = state_13094__$1;
(statearr_13102_13139[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (15))){
var state_13094__$1 = state_13094;
var statearr_13106_13140 = state_13094__$1;
(statearr_13106_13140[(2)] = null);

(statearr_13106_13140[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (21))){
var state_13094__$1 = state_13094;
var statearr_13107_13141 = state_13094__$1;
(statearr_13107_13141[(2)] = null);

(statearr_13107_13141[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (13))){
var inst_13048 = (state_13094[(8)]);
var inst_13049 = (state_13094[(9)]);
var inst_13047 = (state_13094[(10)]);
var inst_13046 = (state_13094[(12)]);
var inst_13056 = (state_13094[(2)]);
var inst_13057 = (inst_13049 + (1));
var tmp13103 = inst_13048;
var tmp13104 = inst_13047;
var tmp13105 = inst_13046;
var inst_13046__$1 = tmp13105;
var inst_13047__$1 = tmp13104;
var inst_13048__$1 = tmp13103;
var inst_13049__$1 = inst_13057;
var state_13094__$1 = (function (){var statearr_13108 = state_13094;
(statearr_13108[(8)] = inst_13048__$1);

(statearr_13108[(9)] = inst_13049__$1);

(statearr_13108[(10)] = inst_13047__$1);

(statearr_13108[(12)] = inst_13046__$1);

(statearr_13108[(14)] = inst_13056);

return statearr_13108;
})();
var statearr_13109_13142 = state_13094__$1;
(statearr_13109_13142[(2)] = null);

(statearr_13109_13142[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (22))){
var state_13094__$1 = state_13094;
var statearr_13110_13143 = state_13094__$1;
(statearr_13110_13143[(2)] = null);

(statearr_13110_13143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (6))){
var inst_13035 = (state_13094[(13)]);
var inst_13044 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_13035) : f.call(null,inst_13035));
var inst_13045 = cljs.core.seq(inst_13044);
var inst_13046 = inst_13045;
var inst_13047 = null;
var inst_13048 = (0);
var inst_13049 = (0);
var state_13094__$1 = (function (){var statearr_13111 = state_13094;
(statearr_13111[(8)] = inst_13048);

(statearr_13111[(9)] = inst_13049);

(statearr_13111[(10)] = inst_13047);

(statearr_13111[(12)] = inst_13046);

return statearr_13111;
})();
var statearr_13112_13144 = state_13094__$1;
(statearr_13112_13144[(2)] = null);

(statearr_13112_13144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (17))){
var inst_13060 = (state_13094[(7)]);
var inst_13064 = cljs.core.chunk_first(inst_13060);
var inst_13065 = cljs.core.chunk_rest(inst_13060);
var inst_13066 = cljs.core.count(inst_13064);
var inst_13046 = inst_13065;
var inst_13047 = inst_13064;
var inst_13048 = inst_13066;
var inst_13049 = (0);
var state_13094__$1 = (function (){var statearr_13113 = state_13094;
(statearr_13113[(8)] = inst_13048);

(statearr_13113[(9)] = inst_13049);

(statearr_13113[(10)] = inst_13047);

(statearr_13113[(12)] = inst_13046);

return statearr_13113;
})();
var statearr_13114_13145 = state_13094__$1;
(statearr_13114_13145[(2)] = null);

(statearr_13114_13145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (3))){
var inst_13092 = (state_13094[(2)]);
var state_13094__$1 = state_13094;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13094__$1,inst_13092);
} else {
if((state_val_13095 === (12))){
var inst_13080 = (state_13094[(2)]);
var state_13094__$1 = state_13094;
var statearr_13115_13146 = state_13094__$1;
(statearr_13115_13146[(2)] = inst_13080);

(statearr_13115_13146[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (2))){
var state_13094__$1 = state_13094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13094__$1,(4),in$);
} else {
if((state_val_13095 === (23))){
var inst_13088 = (state_13094[(2)]);
var state_13094__$1 = state_13094;
var statearr_13116_13147 = state_13094__$1;
(statearr_13116_13147[(2)] = inst_13088);

(statearr_13116_13147[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (19))){
var inst_13075 = (state_13094[(2)]);
var state_13094__$1 = state_13094;
var statearr_13117_13148 = state_13094__$1;
(statearr_13117_13148[(2)] = inst_13075);

(statearr_13117_13148[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (11))){
var inst_13060 = (state_13094[(7)]);
var inst_13046 = (state_13094[(12)]);
var inst_13060__$1 = cljs.core.seq(inst_13046);
var state_13094__$1 = (function (){var statearr_13118 = state_13094;
(statearr_13118[(7)] = inst_13060__$1);

return statearr_13118;
})();
if(inst_13060__$1){
var statearr_13119_13149 = state_13094__$1;
(statearr_13119_13149[(1)] = (14));

} else {
var statearr_13120_13150 = state_13094__$1;
(statearr_13120_13150[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (9))){
var inst_13082 = (state_13094[(2)]);
var inst_13083 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_13094__$1 = (function (){var statearr_13121 = state_13094;
(statearr_13121[(15)] = inst_13082);

return statearr_13121;
})();
if(cljs.core.truth_(inst_13083)){
var statearr_13122_13151 = state_13094__$1;
(statearr_13122_13151[(1)] = (21));

} else {
var statearr_13123_13152 = state_13094__$1;
(statearr_13123_13152[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (5))){
var inst_13038 = cljs.core.async.close_BANG_(out);
var state_13094__$1 = state_13094;
var statearr_13124_13153 = state_13094__$1;
(statearr_13124_13153[(2)] = inst_13038);

(statearr_13124_13153[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (14))){
var inst_13060 = (state_13094[(7)]);
var inst_13062 = cljs.core.chunked_seq_QMARK_(inst_13060);
var state_13094__$1 = state_13094;
if(inst_13062){
var statearr_13125_13154 = state_13094__$1;
(statearr_13125_13154[(1)] = (17));

} else {
var statearr_13126_13155 = state_13094__$1;
(statearr_13126_13155[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (16))){
var inst_13078 = (state_13094[(2)]);
var state_13094__$1 = state_13094;
var statearr_13127_13156 = state_13094__$1;
(statearr_13127_13156[(2)] = inst_13078);

(statearr_13127_13156[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13095 === (10))){
var inst_13049 = (state_13094[(9)]);
var inst_13047 = (state_13094[(10)]);
var inst_13054 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_13047,inst_13049);
var state_13094__$1 = state_13094;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13094__$1,(13),out,inst_13054);
} else {
if((state_val_13095 === (18))){
var inst_13060 = (state_13094[(7)]);
var inst_13069 = cljs.core.first(inst_13060);
var state_13094__$1 = state_13094;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13094__$1,(20),out,inst_13069);
} else {
if((state_val_13095 === (8))){
var inst_13048 = (state_13094[(8)]);
var inst_13049 = (state_13094[(9)]);
var inst_13051 = (inst_13049 < inst_13048);
var inst_13052 = inst_13051;
var state_13094__$1 = state_13094;
if(cljs.core.truth_(inst_13052)){
var statearr_13128_13157 = state_13094__$1;
(statearr_13128_13157[(1)] = (10));

} else {
var statearr_13129_13158 = state_13094__$1;
(statearr_13129_13158[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11410__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11410__auto____0 = (function (){
var statearr_13130 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13130[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11410__auto__);

(statearr_13130[(1)] = (1));

return statearr_13130;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11410__auto____1 = (function (state_13094){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_13094);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e13131){var ex__11413__auto__ = e13131;
var statearr_13132_13159 = state_13094;
(statearr_13132_13159[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_13094[(4)]))){
var statearr_13133_13160 = state_13094;
(statearr_13133_13160[(1)] = cljs.core.first((state_13094[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13161 = state_13094;
state_13094 = G__13161;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11410__auto__ = function(state_13094){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11410__auto____1.call(this,state_13094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11410__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11410__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_13134 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_13134[(6)] = c__11484__auto__);

return statearr_13134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__13163 = arguments.length;
switch (G__13163) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__13166 = arguments.length;
switch (G__13166) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__13169 = arguments.length;
switch (G__13169) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11484__auto___13217 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_13193){
var state_val_13194 = (state_13193[(1)]);
if((state_val_13194 === (7))){
var inst_13188 = (state_13193[(2)]);
var state_13193__$1 = state_13193;
var statearr_13195_13218 = state_13193__$1;
(statearr_13195_13218[(2)] = inst_13188);

(statearr_13195_13218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13194 === (1))){
var inst_13170 = null;
var state_13193__$1 = (function (){var statearr_13196 = state_13193;
(statearr_13196[(7)] = inst_13170);

return statearr_13196;
})();
var statearr_13197_13219 = state_13193__$1;
(statearr_13197_13219[(2)] = null);

(statearr_13197_13219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13194 === (4))){
var inst_13173 = (state_13193[(8)]);
var inst_13173__$1 = (state_13193[(2)]);
var inst_13174 = (inst_13173__$1 == null);
var inst_13175 = cljs.core.not(inst_13174);
var state_13193__$1 = (function (){var statearr_13198 = state_13193;
(statearr_13198[(8)] = inst_13173__$1);

return statearr_13198;
})();
if(inst_13175){
var statearr_13199_13220 = state_13193__$1;
(statearr_13199_13220[(1)] = (5));

} else {
var statearr_13200_13221 = state_13193__$1;
(statearr_13200_13221[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13194 === (6))){
var state_13193__$1 = state_13193;
var statearr_13201_13222 = state_13193__$1;
(statearr_13201_13222[(2)] = null);

(statearr_13201_13222[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13194 === (3))){
var inst_13190 = (state_13193[(2)]);
var inst_13191 = cljs.core.async.close_BANG_(out);
var state_13193__$1 = (function (){var statearr_13202 = state_13193;
(statearr_13202[(9)] = inst_13190);

return statearr_13202;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_13193__$1,inst_13191);
} else {
if((state_val_13194 === (2))){
var state_13193__$1 = state_13193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13193__$1,(4),ch);
} else {
if((state_val_13194 === (11))){
var inst_13173 = (state_13193[(8)]);
var inst_13182 = (state_13193[(2)]);
var inst_13170 = inst_13173;
var state_13193__$1 = (function (){var statearr_13203 = state_13193;
(statearr_13203[(10)] = inst_13182);

(statearr_13203[(7)] = inst_13170);

return statearr_13203;
})();
var statearr_13204_13223 = state_13193__$1;
(statearr_13204_13223[(2)] = null);

(statearr_13204_13223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13194 === (9))){
var inst_13173 = (state_13193[(8)]);
var state_13193__$1 = state_13193;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13193__$1,(11),out,inst_13173);
} else {
if((state_val_13194 === (5))){
var inst_13173 = (state_13193[(8)]);
var inst_13170 = (state_13193[(7)]);
var inst_13177 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13173,inst_13170);
var state_13193__$1 = state_13193;
if(inst_13177){
var statearr_13206_13224 = state_13193__$1;
(statearr_13206_13224[(1)] = (8));

} else {
var statearr_13207_13225 = state_13193__$1;
(statearr_13207_13225[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13194 === (10))){
var inst_13185 = (state_13193[(2)]);
var state_13193__$1 = state_13193;
var statearr_13208_13226 = state_13193__$1;
(statearr_13208_13226[(2)] = inst_13185);

(statearr_13208_13226[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13194 === (8))){
var inst_13170 = (state_13193[(7)]);
var tmp13205 = inst_13170;
var inst_13170__$1 = tmp13205;
var state_13193__$1 = (function (){var statearr_13209 = state_13193;
(statearr_13209[(7)] = inst_13170__$1);

return statearr_13209;
})();
var statearr_13210_13227 = state_13193__$1;
(statearr_13210_13227[(2)] = null);

(statearr_13210_13227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11410__auto__ = null;
var cljs$core$async$state_machine__11410__auto____0 = (function (){
var statearr_13211 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13211[(0)] = cljs$core$async$state_machine__11410__auto__);

(statearr_13211[(1)] = (1));

return statearr_13211;
});
var cljs$core$async$state_machine__11410__auto____1 = (function (state_13193){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_13193);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e13212){var ex__11413__auto__ = e13212;
var statearr_13213_13228 = state_13193;
(statearr_13213_13228[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_13193[(4)]))){
var statearr_13214_13229 = state_13193;
(statearr_13214_13229[(1)] = cljs.core.first((state_13193[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13230 = state_13193;
state_13193 = G__13230;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$state_machine__11410__auto__ = function(state_13193){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11410__auto____1.call(this,state_13193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11410__auto____0;
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11410__auto____1;
return cljs$core$async$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_13215 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_13215[(6)] = c__11484__auto___13217);

return statearr_13215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__13232 = arguments.length;
switch (G__13232) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11484__auto___13299 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_13270){
var state_val_13271 = (state_13270[(1)]);
if((state_val_13271 === (7))){
var inst_13266 = (state_13270[(2)]);
var state_13270__$1 = state_13270;
var statearr_13272_13300 = state_13270__$1;
(statearr_13272_13300[(2)] = inst_13266);

(statearr_13272_13300[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13271 === (1))){
var inst_13233 = (new Array(n));
var inst_13234 = inst_13233;
var inst_13235 = (0);
var state_13270__$1 = (function (){var statearr_13273 = state_13270;
(statearr_13273[(7)] = inst_13234);

(statearr_13273[(8)] = inst_13235);

return statearr_13273;
})();
var statearr_13274_13301 = state_13270__$1;
(statearr_13274_13301[(2)] = null);

(statearr_13274_13301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13271 === (4))){
var inst_13238 = (state_13270[(9)]);
var inst_13238__$1 = (state_13270[(2)]);
var inst_13239 = (inst_13238__$1 == null);
var inst_13240 = cljs.core.not(inst_13239);
var state_13270__$1 = (function (){var statearr_13275 = state_13270;
(statearr_13275[(9)] = inst_13238__$1);

return statearr_13275;
})();
if(inst_13240){
var statearr_13276_13302 = state_13270__$1;
(statearr_13276_13302[(1)] = (5));

} else {
var statearr_13277_13303 = state_13270__$1;
(statearr_13277_13303[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13271 === (15))){
var inst_13260 = (state_13270[(2)]);
var state_13270__$1 = state_13270;
var statearr_13278_13304 = state_13270__$1;
(statearr_13278_13304[(2)] = inst_13260);

(statearr_13278_13304[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13271 === (13))){
var state_13270__$1 = state_13270;
var statearr_13279_13305 = state_13270__$1;
(statearr_13279_13305[(2)] = null);

(statearr_13279_13305[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13271 === (6))){
var inst_13235 = (state_13270[(8)]);
var inst_13256 = (inst_13235 > (0));
var state_13270__$1 = state_13270;
if(cljs.core.truth_(inst_13256)){
var statearr_13280_13306 = state_13270__$1;
(statearr_13280_13306[(1)] = (12));

} else {
var statearr_13281_13307 = state_13270__$1;
(statearr_13281_13307[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13271 === (3))){
var inst_13268 = (state_13270[(2)]);
var state_13270__$1 = state_13270;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13270__$1,inst_13268);
} else {
if((state_val_13271 === (12))){
var inst_13234 = (state_13270[(7)]);
var inst_13258 = cljs.core.vec(inst_13234);
var state_13270__$1 = state_13270;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13270__$1,(15),out,inst_13258);
} else {
if((state_val_13271 === (2))){
var state_13270__$1 = state_13270;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13270__$1,(4),ch);
} else {
if((state_val_13271 === (11))){
var inst_13250 = (state_13270[(2)]);
var inst_13251 = (new Array(n));
var inst_13234 = inst_13251;
var inst_13235 = (0);
var state_13270__$1 = (function (){var statearr_13282 = state_13270;
(statearr_13282[(7)] = inst_13234);

(statearr_13282[(10)] = inst_13250);

(statearr_13282[(8)] = inst_13235);

return statearr_13282;
})();
var statearr_13283_13308 = state_13270__$1;
(statearr_13283_13308[(2)] = null);

(statearr_13283_13308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13271 === (9))){
var inst_13234 = (state_13270[(7)]);
var inst_13248 = cljs.core.vec(inst_13234);
var state_13270__$1 = state_13270;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13270__$1,(11),out,inst_13248);
} else {
if((state_val_13271 === (5))){
var inst_13234 = (state_13270[(7)]);
var inst_13238 = (state_13270[(9)]);
var inst_13235 = (state_13270[(8)]);
var inst_13243 = (state_13270[(11)]);
var inst_13242 = (inst_13234[inst_13235] = inst_13238);
var inst_13243__$1 = (inst_13235 + (1));
var inst_13244 = (inst_13243__$1 < n);
var state_13270__$1 = (function (){var statearr_13284 = state_13270;
(statearr_13284[(12)] = inst_13242);

(statearr_13284[(11)] = inst_13243__$1);

return statearr_13284;
})();
if(cljs.core.truth_(inst_13244)){
var statearr_13285_13309 = state_13270__$1;
(statearr_13285_13309[(1)] = (8));

} else {
var statearr_13286_13310 = state_13270__$1;
(statearr_13286_13310[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13271 === (14))){
var inst_13263 = (state_13270[(2)]);
var inst_13264 = cljs.core.async.close_BANG_(out);
var state_13270__$1 = (function (){var statearr_13288 = state_13270;
(statearr_13288[(13)] = inst_13263);

return statearr_13288;
})();
var statearr_13289_13311 = state_13270__$1;
(statearr_13289_13311[(2)] = inst_13264);

(statearr_13289_13311[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13271 === (10))){
var inst_13254 = (state_13270[(2)]);
var state_13270__$1 = state_13270;
var statearr_13290_13312 = state_13270__$1;
(statearr_13290_13312[(2)] = inst_13254);

(statearr_13290_13312[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13271 === (8))){
var inst_13234 = (state_13270[(7)]);
var inst_13243 = (state_13270[(11)]);
var tmp13287 = inst_13234;
var inst_13234__$1 = tmp13287;
var inst_13235 = inst_13243;
var state_13270__$1 = (function (){var statearr_13291 = state_13270;
(statearr_13291[(7)] = inst_13234__$1);

(statearr_13291[(8)] = inst_13235);

return statearr_13291;
})();
var statearr_13292_13313 = state_13270__$1;
(statearr_13292_13313[(2)] = null);

(statearr_13292_13313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11410__auto__ = null;
var cljs$core$async$state_machine__11410__auto____0 = (function (){
var statearr_13293 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13293[(0)] = cljs$core$async$state_machine__11410__auto__);

(statearr_13293[(1)] = (1));

return statearr_13293;
});
var cljs$core$async$state_machine__11410__auto____1 = (function (state_13270){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_13270);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e13294){var ex__11413__auto__ = e13294;
var statearr_13295_13314 = state_13270;
(statearr_13295_13314[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_13270[(4)]))){
var statearr_13296_13315 = state_13270;
(statearr_13296_13315[(1)] = cljs.core.first((state_13270[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13316 = state_13270;
state_13270 = G__13316;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$state_machine__11410__auto__ = function(state_13270){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11410__auto____1.call(this,state_13270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11410__auto____0;
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11410__auto____1;
return cljs$core$async$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_13297 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_13297[(6)] = c__11484__auto___13299);

return statearr_13297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__13318 = arguments.length;
switch (G__13318) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11484__auto___13396 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_13363){
var state_val_13364 = (state_13363[(1)]);
if((state_val_13364 === (7))){
var inst_13359 = (state_13363[(2)]);
var state_13363__$1 = state_13363;
var statearr_13365_13397 = state_13363__$1;
(statearr_13365_13397[(2)] = inst_13359);

(statearr_13365_13397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (1))){
var inst_13319 = [];
var inst_13320 = inst_13319;
var inst_13321 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13363__$1 = (function (){var statearr_13366 = state_13363;
(statearr_13366[(7)] = inst_13320);

(statearr_13366[(8)] = inst_13321);

return statearr_13366;
})();
var statearr_13367_13398 = state_13363__$1;
(statearr_13367_13398[(2)] = null);

(statearr_13367_13398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (4))){
var inst_13324 = (state_13363[(9)]);
var inst_13324__$1 = (state_13363[(2)]);
var inst_13325 = (inst_13324__$1 == null);
var inst_13326 = cljs.core.not(inst_13325);
var state_13363__$1 = (function (){var statearr_13368 = state_13363;
(statearr_13368[(9)] = inst_13324__$1);

return statearr_13368;
})();
if(inst_13326){
var statearr_13369_13399 = state_13363__$1;
(statearr_13369_13399[(1)] = (5));

} else {
var statearr_13370_13400 = state_13363__$1;
(statearr_13370_13400[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (15))){
var inst_13320 = (state_13363[(7)]);
var inst_13351 = cljs.core.vec(inst_13320);
var state_13363__$1 = state_13363;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13363__$1,(18),out,inst_13351);
} else {
if((state_val_13364 === (13))){
var inst_13346 = (state_13363[(2)]);
var state_13363__$1 = state_13363;
var statearr_13371_13401 = state_13363__$1;
(statearr_13371_13401[(2)] = inst_13346);

(statearr_13371_13401[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (6))){
var inst_13320 = (state_13363[(7)]);
var inst_13348 = inst_13320.length;
var inst_13349 = (inst_13348 > (0));
var state_13363__$1 = state_13363;
if(cljs.core.truth_(inst_13349)){
var statearr_13372_13402 = state_13363__$1;
(statearr_13372_13402[(1)] = (15));

} else {
var statearr_13373_13403 = state_13363__$1;
(statearr_13373_13403[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (17))){
var inst_13356 = (state_13363[(2)]);
var inst_13357 = cljs.core.async.close_BANG_(out);
var state_13363__$1 = (function (){var statearr_13374 = state_13363;
(statearr_13374[(10)] = inst_13356);

return statearr_13374;
})();
var statearr_13375_13404 = state_13363__$1;
(statearr_13375_13404[(2)] = inst_13357);

(statearr_13375_13404[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (3))){
var inst_13361 = (state_13363[(2)]);
var state_13363__$1 = state_13363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13363__$1,inst_13361);
} else {
if((state_val_13364 === (12))){
var inst_13320 = (state_13363[(7)]);
var inst_13339 = cljs.core.vec(inst_13320);
var state_13363__$1 = state_13363;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13363__$1,(14),out,inst_13339);
} else {
if((state_val_13364 === (2))){
var state_13363__$1 = state_13363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13363__$1,(4),ch);
} else {
if((state_val_13364 === (11))){
var inst_13320 = (state_13363[(7)]);
var inst_13328 = (state_13363[(11)]);
var inst_13324 = (state_13363[(9)]);
var inst_13336 = inst_13320.push(inst_13324);
var tmp13376 = inst_13320;
var inst_13320__$1 = tmp13376;
var inst_13321 = inst_13328;
var state_13363__$1 = (function (){var statearr_13377 = state_13363;
(statearr_13377[(7)] = inst_13320__$1);

(statearr_13377[(8)] = inst_13321);

(statearr_13377[(12)] = inst_13336);

return statearr_13377;
})();
var statearr_13378_13405 = state_13363__$1;
(statearr_13378_13405[(2)] = null);

(statearr_13378_13405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (9))){
var inst_13321 = (state_13363[(8)]);
var inst_13332 = cljs.core.keyword_identical_QMARK_(inst_13321,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_13363__$1 = state_13363;
var statearr_13379_13406 = state_13363__$1;
(statearr_13379_13406[(2)] = inst_13332);

(statearr_13379_13406[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (5))){
var inst_13328 = (state_13363[(11)]);
var inst_13321 = (state_13363[(8)]);
var inst_13329 = (state_13363[(13)]);
var inst_13324 = (state_13363[(9)]);
var inst_13328__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_13324) : f.call(null,inst_13324));
var inst_13329__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13328__$1,inst_13321);
var state_13363__$1 = (function (){var statearr_13380 = state_13363;
(statearr_13380[(11)] = inst_13328__$1);

(statearr_13380[(13)] = inst_13329__$1);

return statearr_13380;
})();
if(inst_13329__$1){
var statearr_13381_13407 = state_13363__$1;
(statearr_13381_13407[(1)] = (8));

} else {
var statearr_13382_13408 = state_13363__$1;
(statearr_13382_13408[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (14))){
var inst_13328 = (state_13363[(11)]);
var inst_13324 = (state_13363[(9)]);
var inst_13341 = (state_13363[(2)]);
var inst_13342 = [];
var inst_13343 = inst_13342.push(inst_13324);
var inst_13320 = inst_13342;
var inst_13321 = inst_13328;
var state_13363__$1 = (function (){var statearr_13383 = state_13363;
(statearr_13383[(14)] = inst_13341);

(statearr_13383[(15)] = inst_13343);

(statearr_13383[(7)] = inst_13320);

(statearr_13383[(8)] = inst_13321);

return statearr_13383;
})();
var statearr_13384_13409 = state_13363__$1;
(statearr_13384_13409[(2)] = null);

(statearr_13384_13409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (16))){
var state_13363__$1 = state_13363;
var statearr_13385_13410 = state_13363__$1;
(statearr_13385_13410[(2)] = null);

(statearr_13385_13410[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (10))){
var inst_13334 = (state_13363[(2)]);
var state_13363__$1 = state_13363;
if(cljs.core.truth_(inst_13334)){
var statearr_13386_13411 = state_13363__$1;
(statearr_13386_13411[(1)] = (11));

} else {
var statearr_13387_13412 = state_13363__$1;
(statearr_13387_13412[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (18))){
var inst_13353 = (state_13363[(2)]);
var state_13363__$1 = state_13363;
var statearr_13388_13413 = state_13363__$1;
(statearr_13388_13413[(2)] = inst_13353);

(statearr_13388_13413[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13364 === (8))){
var inst_13329 = (state_13363[(13)]);
var state_13363__$1 = state_13363;
var statearr_13389_13414 = state_13363__$1;
(statearr_13389_13414[(2)] = inst_13329);

(statearr_13389_13414[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11410__auto__ = null;
var cljs$core$async$state_machine__11410__auto____0 = (function (){
var statearr_13390 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13390[(0)] = cljs$core$async$state_machine__11410__auto__);

(statearr_13390[(1)] = (1));

return statearr_13390;
});
var cljs$core$async$state_machine__11410__auto____1 = (function (state_13363){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_13363);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e13391){var ex__11413__auto__ = e13391;
var statearr_13392_13415 = state_13363;
(statearr_13392_13415[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_13363[(4)]))){
var statearr_13393_13416 = state_13363;
(statearr_13393_13416[(1)] = cljs.core.first((state_13363[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13417 = state_13363;
state_13363 = G__13417;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
cljs$core$async$state_machine__11410__auto__ = function(state_13363){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11410__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11410__auto____1.call(this,state_13363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11410__auto____0;
cljs$core$async$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11410__auto____1;
return cljs$core$async$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_13394 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_13394[(6)] = c__11484__auto___13396);

return statearr_13394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

