// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e20214){var e = e20214;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__20215_SHARP_){
var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__20215_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__20215_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__20215_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__20215_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20216_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20216_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20217_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20217_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4251__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4253__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20222 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20222,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20222,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20218_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20218_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4251__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4251__auto__;
}
})())){
var vec__20225 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20225,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20225,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4253__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20219_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20219_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20220_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20220_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20221_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20221_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20228_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__20228_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (add_amount > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fuel;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4251__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__20229 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__20229) : intersecting_vars.call(null,G__20229));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20232,optional_QMARK_,fuel,max_fuel){
var map__20233 = p__20232;
var map__20233__$1 = cljs.core.__destructure_map(map__20233);
var res = map__20233__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20233__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_20299){
var state_val_20300 = (state_20299[(1)]);
if((state_val_20300 === (7))){
var inst_20288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20289 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_20290 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20289,clause);
var inst_20291 = [null,inst_20290];
var inst_20292 = (new cljs.core.PersistentVector(null,2,(5),inst_20288,inst_20291,null));
var state_20299__$1 = state_20299;
var statearr_20301_20329 = state_20299__$1;
(statearr_20301_20329[(2)] = inst_20292);

(statearr_20301_20329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20300 === (1))){
var state_20299__$1 = state_20299;
var statearr_20302_20330 = state_20299__$1;
(statearr_20302_20330[(2)] = null);

(statearr_20302_20330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20300 === (4))){
var inst_20234 = (state_20299[(2)]);
var state_20299__$1 = state_20299;
var statearr_20303_20331 = state_20299__$1;
(statearr_20303_20331[(2)] = inst_20234);

(statearr_20303_20331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20300 === (15))){
var inst_20277 = (state_20299[(2)]);
var inst_20278 = fluree.db.util.async.throw_err(inst_20277);
var inst_20279 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20278);
var inst_20280 = cljs.core.count(inst_20279);
var inst_20281 = fluree.db.query.analytical.add_fuel(inst_20280,fuel,max_fuel);
var inst_20282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20283 = [inst_20278,r];
var inst_20284 = (new cljs.core.PersistentVector(null,2,(5),inst_20282,inst_20283,null));
var state_20299__$1 = (function (){var statearr_20304 = state_20299;
(statearr_20304[(7)] = inst_20281);

return statearr_20304;
})();
var statearr_20305_20332 = state_20299__$1;
(statearr_20305_20332[(2)] = inst_20284);

(statearr_20305_20332[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20300 === (13))){
var inst_20243 = (state_20299[(8)]);
var inst_20256 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20257 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_20256);
var inst_20258 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20243);
var inst_20259 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20258);
var inst_20260 = cljs.core.set(inst_20259);
var inst_20261 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20257);
var inst_20262 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20261);
var inst_20263 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20260,inst_20262);
var inst_20264 = (function (){var all_wd = inst_20243;
var optional = inst_20257;
var all_wd_vars = inst_20260;
var all_vars = inst_20263;
return (function (p1__20230_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__20230_SHARP_) : all_vars.call(null,p1__20230_SHARP_));
});
})();
var inst_20265 = cljs.core.keys(vars);
var inst_20266 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20264,inst_20265);
var inst_20267 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_20266);
var inst_20268 = cljs.core.set(inst_20267);
var inst_20269 = (function (){var all_wd = inst_20243;
var optional = inst_20257;
var all_wd_vars = inst_20260;
var all_vars = inst_20263;
var intersecting_vars = inst_20268;
return (function (p1__20231_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__20231_SHARP_);
});
})();
var inst_20270 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20269,inst_20243);
var inst_20271 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20270);
var inst_20272 = fluree.db.query.analytical.select_from_tuples(inst_20271,res);
var inst_20273 = fluree.db.query.analytical.replace_vars_wikidata(inst_20243,inst_20268,vars);
var inst_20274 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_20268,inst_20263);
var inst_20275 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_20273,inst_20271,inst_20272,inst_20274,inst_20257);
var state_20299__$1 = state_20299;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20299__$1,(15),inst_20275);
} else {
if((state_val_20300 === (6))){
var inst_20244 = (state_20299[(9)]);
var inst_20242 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20243 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_20242);
var inst_20244__$1 = optional_QMARK_;
var state_20299__$1 = (function (){var statearr_20306 = state_20299;
(statearr_20306[(9)] = inst_20244__$1);

(statearr_20306[(8)] = inst_20243);

return statearr_20306;
})();
if(cljs.core.truth_(inst_20244__$1)){
var statearr_20307_20333 = state_20299__$1;
(statearr_20307_20333[(1)] = (9));

} else {
var statearr_20308_20334 = state_20299__$1;
(statearr_20308_20334[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20300 === (3))){
var inst_20297 = (state_20299[(2)]);
var state_20299__$1 = state_20299;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20299__$1,inst_20297);
} else {
if((state_val_20300 === (12))){
var inst_20252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20253 = [null,r];
var inst_20254 = (new cljs.core.PersistentVector(null,2,(5),inst_20252,inst_20253,null));
var state_20299__$1 = state_20299;
var statearr_20309_20335 = state_20299__$1;
(statearr_20309_20335[(2)] = inst_20254);

(statearr_20309_20335[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20300 === (2))){
var _ = (function (){var statearr_20310 = state_20299;
(statearr_20310[(4)] = cljs.core.cons((5),(state_20299[(4)])));

return statearr_20310;
})();
var inst_20240 = (r == null);
var state_20299__$1 = state_20299;
if(cljs.core.truth_(inst_20240)){
var statearr_20311_20336 = state_20299__$1;
(statearr_20311_20336[(1)] = (6));

} else {
var statearr_20312_20337 = state_20299__$1;
(statearr_20312_20337[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20300 === (11))){
var inst_20250 = (state_20299[(2)]);
var state_20299__$1 = state_20299;
if(cljs.core.truth_(inst_20250)){
var statearr_20314_20338 = state_20299__$1;
(statearr_20314_20338[(1)] = (12));

} else {
var statearr_20315_20339 = state_20299__$1;
(statearr_20315_20339[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20300 === (9))){
var inst_20243 = (state_20299[(8)]);
var inst_20246 = cljs.core.empty_QMARK_(inst_20243);
var inst_20247 = (!(inst_20246));
var state_20299__$1 = state_20299;
var statearr_20316_20340 = state_20299__$1;
(statearr_20316_20340[(2)] = inst_20247);

(statearr_20316_20340[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20300 === (5))){
var _ = (function (){var statearr_20317 = state_20299;
(statearr_20317[(4)] = cljs.core.rest((state_20299[(4)])));

return statearr_20317;
})();
var state_20299__$1 = state_20299;
var ex20313 = (state_20299__$1[(2)]);
var statearr_20318_20341 = state_20299__$1;
(statearr_20318_20341[(5)] = ex20313);


if((ex20313 instanceof Error)){
var statearr_20319_20342 = state_20299__$1;
(statearr_20319_20342[(1)] = (4));

(statearr_20319_20342[(5)] = null);

} else {
throw ex20313;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20300 === (14))){
var inst_20286 = (state_20299[(2)]);
var state_20299__$1 = state_20299;
var statearr_20320_20343 = state_20299__$1;
(statearr_20320_20343[(2)] = inst_20286);

(statearr_20320_20343[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20300 === (10))){
var inst_20244 = (state_20299[(9)]);
var state_20299__$1 = state_20299;
var statearr_20321_20344 = state_20299__$1;
(statearr_20321_20344[(2)] = inst_20244);

(statearr_20321_20344[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20300 === (8))){
var inst_20294 = (state_20299[(2)]);
var _ = (function (){var statearr_20322 = state_20299;
(statearr_20322[(4)] = cljs.core.rest((state_20299[(4)])));

return statearr_20322;
})();
var state_20299__$1 = state_20299;
var statearr_20323_20345 = state_20299__$1;
(statearr_20323_20345[(2)] = inst_20294);

(statearr_20323_20345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2741__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2741__auto____0 = (function (){
var statearr_20324 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20324[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2741__auto__);

(statearr_20324[(1)] = (1));

return statearr_20324;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2741__auto____1 = (function (state_20299){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_20299);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e20325){var ex__2744__auto__ = e20325;
var statearr_20326_20346 = state_20299;
(statearr_20326_20346[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_20299[(4)]))){
var statearr_20327_20347 = state_20299;
(statearr_20327_20347[(1)] = cljs.core.first((state_20299[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20348 = state_20299;
state_20299 = G__20348;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2741__auto__ = function(state_20299){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2741__auto____1.call(this,state_20299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2741__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2741__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_20328 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_20328[(6)] = c__2763__auto__);

return statearr_20328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20350 = arguments.length;
switch (G__20350) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_20444){
var state_val_20445 = (state_20444[(1)]);
if((state_val_20445 === (7))){
var inst_20357 = (state_20444[(7)]);
var inst_20367 = clojure.string.starts_with_QMARK_(inst_20357,"$fdb");
var state_20444__$1 = state_20444;
if(inst_20367){
var statearr_20446_20495 = state_20444__$1;
(statearr_20446_20495[(1)] = (9));

} else {
var statearr_20447_20496 = state_20444__$1;
(statearr_20447_20496[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (20))){
var state_20444__$1 = state_20444;
var statearr_20448_20497 = state_20444__$1;
(statearr_20448_20497[(2)] = null);

(statearr_20448_20497[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (27))){
var inst_20407 = (state_20444[(8)]);
var state_20444__$1 = state_20444;
var statearr_20449_20498 = state_20444__$1;
(statearr_20449_20498[(2)] = inst_20407);

(statearr_20449_20498[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (1))){
var state_20444__$1 = state_20444;
var statearr_20450_20499 = state_20444__$1;
(statearr_20450_20499[(2)] = null);

(statearr_20450_20499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (24))){
var inst_20430 = (state_20444[(2)]);
var state_20444__$1 = state_20444;
var statearr_20451_20500 = state_20444__$1;
(statearr_20451_20500[(2)] = inst_20430);

(statearr_20451_20500[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (4))){
var inst_20351 = (state_20444[(2)]);
var state_20444__$1 = state_20444;
var statearr_20452_20501 = state_20444__$1;
(statearr_20452_20501[(2)] = inst_20351);

(statearr_20452_20501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (15))){
var inst_20374 = (state_20444[(9)]);
var inst_20380 = (state_20444[(2)]);
var inst_20381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20382 = cljs.core.PersistentVector.EMPTY;
var inst_20383 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20384 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20382,inst_20383);
var inst_20385 = [inst_20374,inst_20384];
var inst_20386 = (new cljs.core.PersistentVector(null,2,(5),inst_20381,inst_20385,null));
var state_20444__$1 = (function (){var statearr_20453 = state_20444;
(statearr_20453[(10)] = inst_20380);

return statearr_20453;
})();
var statearr_20454_20502 = state_20444__$1;
(statearr_20454_20502[(2)] = inst_20386);

(statearr_20454_20502[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (21))){
var inst_20433 = (state_20444[(2)]);
var state_20444__$1 = state_20444;
var statearr_20455_20503 = state_20444__$1;
(statearr_20455_20503[(2)] = inst_20433);

(statearr_20455_20503[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (13))){
var inst_20374 = (state_20444[(9)]);
var inst_20377 = (function(){throw inst_20374})();
var state_20444__$1 = state_20444;
var statearr_20456_20504 = state_20444__$1;
(statearr_20456_20504[(2)] = inst_20377);

(statearr_20456_20504[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (22))){
var inst_20398 = (state_20444[(11)]);
var inst_20396 = (state_20444[(12)]);
var inst_20400 = fluree.db.query.analytical.parse_block_from_source(inst_20396);
var inst_20401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20402 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_20398];
var inst_20403 = (new cljs.core.PersistentVector(null,2,(5),inst_20401,inst_20402,null));
var inst_20404 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_20403);
var state_20444__$1 = (function (){var statearr_20457 = state_20444;
(statearr_20457[(13)] = inst_20400);

return statearr_20457;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20444__$1,(25),inst_20404);
} else {
if((state_val_20445 === (29))){
var inst_20411 = (state_20444[(2)]);
var inst_20412 = fluree.db.util.async.throw_err(inst_20411);
var state_20444__$1 = state_20444;
var statearr_20458_20505 = state_20444__$1;
(statearr_20458_20505[(2)] = inst_20412);

(statearr_20458_20505[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (6))){
var inst_20360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20361 = cljs.core.PersistentVector.EMPTY;
var inst_20362 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20363 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20361,inst_20362);
var inst_20364 = [db,inst_20363];
var inst_20365 = (new cljs.core.PersistentVector(null,2,(5),inst_20360,inst_20364,null));
var state_20444__$1 = state_20444;
var statearr_20459_20506 = state_20444__$1;
(statearr_20459_20506[(2)] = inst_20365);

(statearr_20459_20506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (28))){
var inst_20415 = (state_20444[(2)]);
var inst_20416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20417 = cljs.core.PersistentVector.EMPTY;
var inst_20418 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20419 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20417,inst_20418);
var inst_20420 = [inst_20415,inst_20419];
var inst_20421 = (new cljs.core.PersistentVector(null,2,(5),inst_20416,inst_20420,null));
var state_20444__$1 = state_20444;
var statearr_20460_20507 = state_20444__$1;
(statearr_20460_20507[(2)] = inst_20421);

(statearr_20460_20507[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (25))){
var inst_20400 = (state_20444[(13)]);
var inst_20406 = (state_20444[(2)]);
var inst_20407 = fluree.db.util.async.throw_err(inst_20406);
var state_20444__$1 = (function (){var statearr_20461 = state_20444;
(statearr_20461[(8)] = inst_20407);

return statearr_20461;
})();
if(cljs.core.truth_(inst_20400)){
var statearr_20462_20508 = state_20444__$1;
(statearr_20462_20508[(1)] = (26));

} else {
var statearr_20463_20509 = state_20444__$1;
(statearr_20463_20509[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (17))){
var state_20444__$1 = state_20444;
var statearr_20464_20510 = state_20444__$1;
(statearr_20464_20510[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (3))){
var inst_20442 = (state_20444[(2)]);
var state_20444__$1 = state_20444;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20444__$1,inst_20442);
} else {
if((state_val_20445 === (12))){
var inst_20374 = (state_20444[(9)]);
var inst_20373 = (state_20444[(2)]);
var inst_20374__$1 = fluree.db.util.async.throw_err(inst_20373);
var inst_20375 = fluree.db.util.core.exception_QMARK_(inst_20374__$1);
var state_20444__$1 = (function (){var statearr_20466 = state_20444;
(statearr_20466[(9)] = inst_20374__$1);

return statearr_20466;
})();
if(inst_20375){
var statearr_20467_20511 = state_20444__$1;
(statearr_20467_20511[(1)] = (13));

} else {
var statearr_20468_20512 = state_20444__$1;
(statearr_20468_20512[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (2))){
var inst_20357 = (state_20444[(7)]);
var _ = (function (){var statearr_20469 = state_20444;
(statearr_20469[(4)] = cljs.core.cons((5),(state_20444[(4)])));

return statearr_20469;
})();
var inst_20357__$1 = cljs.core.first(clause);
var inst_20358 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_20357__$1);
var state_20444__$1 = (function (){var statearr_20470 = state_20444;
(statearr_20470[(7)] = inst_20357__$1);

return statearr_20470;
})();
if(inst_20358){
var statearr_20471_20513 = state_20444__$1;
(statearr_20471_20513[(1)] = (6));

} else {
var statearr_20472_20514 = state_20444__$1;
(statearr_20472_20514[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (23))){
var inst_20357 = (state_20444[(7)]);
var inst_20423 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20357)," is not supported in Fluree"].join('');
var inst_20424 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20425 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20426 = cljs.core.PersistentHashMap.fromArrays(inst_20424,inst_20425);
var inst_20427 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20423,inst_20426);
var inst_20428 = (function(){throw inst_20427})();
var state_20444__$1 = state_20444;
var statearr_20473_20515 = state_20444__$1;
(statearr_20473_20515[(2)] = inst_20428);

(statearr_20473_20515[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (19))){
var inst_20398 = (state_20444[(11)]);
var inst_20357 = (state_20444[(7)]);
var inst_20395 = fluree.db.query.analytical.isolate_source_name(inst_20357);
var inst_20396 = fluree.db.query.analytical.isolate_source_block(inst_20357);
var inst_20397 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_20395);
var inst_20398__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_20397);
var state_20444__$1 = (function (){var statearr_20474 = state_20444;
(statearr_20474[(11)] = inst_20398__$1);

(statearr_20474[(12)] = inst_20396);

return statearr_20474;
})();
if(cljs.core.truth_(inst_20398__$1)){
var statearr_20475_20516 = state_20444__$1;
(statearr_20475_20516[(1)] = (22));

} else {
var statearr_20476_20517 = state_20444__$1;
(statearr_20476_20517[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (11))){
var inst_20437 = (state_20444[(2)]);
var state_20444__$1 = state_20444;
var statearr_20478_20518 = state_20444__$1;
(statearr_20478_20518[(2)] = inst_20437);

(statearr_20478_20518[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (9))){
var inst_20357 = (state_20444[(7)]);
var inst_20369 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_20357,(4));
var inst_20370 = fluree.db.query.analytical.parse_block_from_source(inst_20369);
var inst_20371 = fluree.db.time_travel.as_of_block(db,inst_20370);
var state_20444__$1 = state_20444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20444__$1,(12),inst_20371);
} else {
if((state_val_20445 === (5))){
var _ = (function (){var statearr_20479 = state_20444;
(statearr_20479[(4)] = cljs.core.rest((state_20444[(4)])));

return statearr_20479;
})();
var state_20444__$1 = state_20444;
var ex20477 = (state_20444__$1[(2)]);
var statearr_20480_20519 = state_20444__$1;
(statearr_20480_20519[(5)] = ex20477);


if((ex20477 instanceof Error)){
var statearr_20481_20520 = state_20444__$1;
(statearr_20481_20520[(1)] = (4));

(statearr_20481_20520[(5)] = null);

} else {
throw ex20477;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (14))){
var state_20444__$1 = state_20444;
var statearr_20482_20521 = state_20444__$1;
(statearr_20482_20521[(2)] = null);

(statearr_20482_20521[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (26))){
var inst_20407 = (state_20444[(8)]);
var inst_20400 = (state_20444[(13)]);
var inst_20409 = fluree.db.time_travel.as_of_block(inst_20407,inst_20400);
var state_20444__$1 = state_20444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20444__$1,(29),inst_20409);
} else {
if((state_val_20445 === (16))){
var inst_20390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20391 = ["$wd",clause];
var inst_20392 = (new cljs.core.PersistentVector(null,2,(5),inst_20390,inst_20391,null));
var state_20444__$1 = state_20444;
var statearr_20483_20522 = state_20444__$1;
(statearr_20483_20522[(2)] = inst_20392);

(statearr_20483_20522[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (10))){
var inst_20357 = (state_20444[(7)]);
var inst_20388 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_20357);
var state_20444__$1 = state_20444;
if(inst_20388){
var statearr_20484_20523 = state_20444__$1;
(statearr_20484_20523[(1)] = (16));

} else {
var statearr_20485_20524 = state_20444__$1;
(statearr_20485_20524[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (18))){
var inst_20435 = (state_20444[(2)]);
var state_20444__$1 = state_20444;
var statearr_20486_20525 = state_20444__$1;
(statearr_20486_20525[(2)] = inst_20435);

(statearr_20486_20525[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20445 === (8))){
var inst_20439 = (state_20444[(2)]);
var _ = (function (){var statearr_20487 = state_20444;
(statearr_20487[(4)] = cljs.core.rest((state_20444[(4)])));

return statearr_20487;
})();
var state_20444__$1 = state_20444;
var statearr_20488_20526 = state_20444__$1;
(statearr_20488_20526[(2)] = inst_20439);

(statearr_20488_20526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2741__auto__ = null;
var fluree$db$query$analytical$state_machine__2741__auto____0 = (function (){
var statearr_20489 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20489[(0)] = fluree$db$query$analytical$state_machine__2741__auto__);

(statearr_20489[(1)] = (1));

return statearr_20489;
});
var fluree$db$query$analytical$state_machine__2741__auto____1 = (function (state_20444){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_20444);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e20490){var ex__2744__auto__ = e20490;
var statearr_20491_20527 = state_20444;
(statearr_20491_20527[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_20444[(4)]))){
var statearr_20492_20528 = state_20444;
(statearr_20492_20528[(1)] = cljs.core.first((state_20444[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20529 = state_20444;
state_20444 = G__20529;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2741__auto__ = function(state_20444){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2741__auto____1.call(this,state_20444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2741__auto____0;
fluree$db$query$analytical$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2741__auto____1;
return fluree$db$query$analytical$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_20493 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_20493[(6)] = c__2763__auto__);

return statearr_20493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__20530){
var vec__20531 = p__20530;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20531,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20531,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20534_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__20534_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__20538 = subjects;
var vec__20539 = G__20538;
var seq__20540 = cljs.core.seq(vec__20539);
var first__20541 = cljs.core.first(seq__20540);
var seq__20540__$1 = cljs.core.next(seq__20540);
var subject = first__20541;
var r = seq__20540__$1;
var acc = expanded_map;
var G__20538__$1 = G__20538;
var acc__$1 = acc;
while(true){
var vec__20545 = G__20538__$1;
var seq__20546 = cljs.core.seq(vec__20545);
var first__20547 = cljs.core.first(seq__20546);
var seq__20546__$1 = cljs.core.next(seq__20546);
var subject__$1 = first__20547;
var r__$1 = seq__20546__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20548 = r__$1;
var G__20549 = acc__$2;
G__20538__$1 = G__20548;
acc__$1 = G__20549;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__20538__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20545,seq__20546,first__20547,seq__20546__$1,subject__$1,r__$1,acc__$2,G__20538,vec__20539,seq__20540,first__20541,seq__20540__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4253__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__20538__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20545,seq__20546,first__20547,seq__20546__$1,subject__$1,r__$1,acc__$2,G__20538,vec__20539,seq__20540,first__20541,seq__20540__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20538__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20545,seq__20546,first__20547,seq__20546__$1,subject__$1,r__$1,acc__$2,G__20538,vec__20539,seq__20540,first__20541,seq__20540__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__20538__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20545,seq__20546,first__20547,seq__20546__$1,subject__$1,r__$1,acc__$2,G__20538,vec__20539,seq__20540,first__20541,seq__20540__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20538__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20545,seq__20546,first__20547,seq__20546__$1,subject__$1,r__$1,acc__$2,G__20538,vec__20539,seq__20540,first__20541,seq__20540__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__20538__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20545,seq__20546,first__20547,seq__20546__$1,subject__$1,r__$1,acc__$2,G__20538,vec__20539,seq__20540,first__20541,seq__20540__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20550 = r__$1;
var G__20551 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__20538__$1 = G__20550;
acc__$1 = G__20551;
continue;
} else {
var G__20552 = subjects;
var G__20553 = acc_STAR_;
G__20538__$1 = G__20552;
acc__$1 = G__20553;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20554_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20554_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_20645){
var state_val_20646 = (state_20645[(1)]);
if((state_val_20646 === (7))){
var state_20645__$1 = state_20645;
var statearr_20647_20693 = state_20645__$1;
(statearr_20647_20693[(2)] = (100));

(statearr_20647_20693[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (20))){
var inst_20594 = (state_20645[(7)]);
var state_20645__$1 = state_20645;
var statearr_20648_20694 = state_20645__$1;
(statearr_20648_20694[(2)] = inst_20594);

(statearr_20648_20694[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (1))){
var state_20645__$1 = state_20645;
var statearr_20649_20695 = state_20645__$1;
(statearr_20649_20695[(2)] = null);

(statearr_20649_20695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (24))){
var inst_20566 = (state_20645[(8)]);
var inst_20631 = (state_20645[(9)]);
var inst_20632 = (state_20645[(10)]);
var inst_20633 = (state_20645[(11)]);
var inst_20636 = (function (){var max_depth = inst_20566;
var recur_map__$1 = inst_20632;
var subjects = inst_20631;
var tuples = inst_20633;
return (function (p1__20555_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__20555_SHARP_)],null));
});
})();
var inst_20637 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20636,inst_20633);
var inst_20638 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_20637);
var state_20645__$1 = state_20645;
var statearr_20650_20696 = state_20645__$1;
(statearr_20650_20696[(2)] = inst_20638);

(statearr_20650_20696[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (4))){
var inst_20556 = (state_20645[(2)]);
var state_20645__$1 = state_20645;
var statearr_20651_20697 = state_20645__$1;
(statearr_20651_20697[(2)] = inst_20556);

(statearr_20651_20697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (15))){
var inst_20579 = (state_20645[(12)]);
var inst_20590 = cljs.core.PersistentVector.EMPTY;
var inst_20591 = cljs.core.seq(inst_20579);
var inst_20592 = cljs.core.first(inst_20591);
var inst_20593 = cljs.core.next(inst_20591);
var inst_20594 = inst_20590;
var inst_20595 = inst_20579;
var state_20645__$1 = (function (){var statearr_20652 = state_20645;
(statearr_20652[(13)] = inst_20593);

(statearr_20652[(14)] = inst_20592);

(statearr_20652[(15)] = inst_20595);

(statearr_20652[(7)] = inst_20594);

return statearr_20652;
})();
var statearr_20653_20698 = state_20645__$1;
(statearr_20653_20698[(2)] = null);

(statearr_20653_20698[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (21))){
var inst_20615 = (state_20645[(2)]);
var state_20645__$1 = state_20645;
var statearr_20654_20699 = state_20645__$1;
(statearr_20654_20699[(2)] = inst_20615);

(statearr_20654_20699[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (13))){
var inst_20628 = (state_20645[(2)]);
var state_20645__$1 = state_20645;
var statearr_20655_20700 = state_20645__$1;
(statearr_20655_20700[(2)] = inst_20628);

(statearr_20655_20700[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (22))){
var inst_20594 = (state_20645[(7)]);
var inst_20602 = (state_20645[(16)]);
var inst_20609 = (state_20645[(2)]);
var inst_20610 = fluree.db.util.async.throw_err(inst_20609);
var inst_20611 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_20594,inst_20610);
var inst_20594__$1 = inst_20611;
var inst_20595 = inst_20602;
var state_20645__$1 = (function (){var statearr_20656 = state_20645;
(statearr_20656[(15)] = inst_20595);

(statearr_20656[(7)] = inst_20594__$1);

return statearr_20656;
})();
var statearr_20657_20701 = state_20645__$1;
(statearr_20657_20701[(2)] = null);

(statearr_20657_20701[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (6))){
var inst_20562 = (state_20645[(17)]);
var state_20645__$1 = state_20645;
var statearr_20658_20702 = state_20645__$1;
(statearr_20658_20702[(2)] = inst_20562);

(statearr_20658_20702[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (25))){
var inst_20640 = (state_20645[(2)]);
var _ = (function (){var statearr_20659 = state_20645;
(statearr_20659[(4)] = cljs.core.rest((state_20645[(4)])));

return statearr_20659;
})();
var state_20645__$1 = state_20645;
var statearr_20660_20703 = state_20645__$1;
(statearr_20660_20703[(2)] = inst_20640);

(statearr_20660_20703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (17))){
var inst_20595 = (state_20645[(15)]);
var inst_20601 = (state_20645[(18)]);
var inst_20600 = cljs.core.seq(inst_20595);
var inst_20601__$1 = cljs.core.first(inst_20600);
var inst_20602 = cljs.core.next(inst_20600);
var state_20645__$1 = (function (){var statearr_20661 = state_20645;
(statearr_20661[(18)] = inst_20601__$1);

(statearr_20661[(16)] = inst_20602);

return statearr_20661;
})();
if(cljs.core.truth_(inst_20601__$1)){
var statearr_20662_20704 = state_20645__$1;
(statearr_20662_20704[(1)] = (19));

} else {
var statearr_20663_20705 = state_20645__$1;
(statearr_20663_20705[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (3))){
var inst_20643 = (state_20645[(2)]);
var state_20645__$1 = state_20645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20645__$1,inst_20643);
} else {
if((state_val_20646 === (12))){
var inst_20568 = (state_20645[(19)]);
var inst_20579 = (state_20645[(12)]);
var inst_20574 = cljs.core.vals(inst_20568);
var inst_20575 = cljs.core.flatten(inst_20574);
var inst_20576 = cljs.core.set(inst_20575);
var inst_20577 = cljs.core.keys(inst_20568);
var inst_20578 = cljs.core.set(inst_20577);
var inst_20579__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_20576,inst_20578);
var inst_20580 = cljs.core.empty_QMARK_(inst_20579__$1);
var state_20645__$1 = (function (){var statearr_20664 = state_20645;
(statearr_20664[(12)] = inst_20579__$1);

return statearr_20664;
})();
if(inst_20580){
var statearr_20665_20706 = state_20645__$1;
(statearr_20665_20706[(1)] = (14));

} else {
var statearr_20666_20707 = state_20645__$1;
(statearr_20666_20707[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (2))){
var inst_20562 = (state_20645[(17)]);
var _ = (function (){var statearr_20667 = state_20645;
(statearr_20667[(4)] = cljs.core.cons((5),(state_20645[(4)])));

return statearr_20667;
})();
var inst_20562__$1 = depth;
var state_20645__$1 = (function (){var statearr_20668 = state_20645;
(statearr_20668[(17)] = inst_20562__$1);

return statearr_20668;
})();
if(cljs.core.truth_(inst_20562__$1)){
var statearr_20669_20708 = state_20645__$1;
(statearr_20669_20708[(1)] = (6));

} else {
var statearr_20670_20709 = state_20645__$1;
(statearr_20670_20709[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (23))){
var inst_20633 = (state_20645[(11)]);
var state_20645__$1 = state_20645;
var statearr_20671_20710 = state_20645__$1;
(statearr_20671_20710[(2)] = inst_20633);

(statearr_20671_20710[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (19))){
var inst_20601 = (state_20645[(18)]);
var inst_20604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20605 = [inst_20601,predicate];
var inst_20606 = (new cljs.core.PersistentVector(null,2,(5),inst_20604,inst_20605,null));
var inst_20607 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20606);
var state_20645__$1 = state_20645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20645__$1,(22),inst_20607);
} else {
if((state_val_20646 === (11))){
var inst_20568 = (state_20645[(19)]);
var state_20645__$1 = state_20645;
var statearr_20673_20711 = state_20645__$1;
(statearr_20673_20711[(2)] = inst_20568);

(statearr_20673_20711[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (9))){
var inst_20566 = (state_20645[(8)]);
var inst_20569 = (state_20645[(20)]);
var inst_20571 = (inst_20569 >= inst_20566);
var state_20645__$1 = state_20645;
if(cljs.core.truth_(inst_20571)){
var statearr_20674_20712 = state_20645__$1;
(statearr_20674_20712[(1)] = (11));

} else {
var statearr_20675_20713 = state_20645__$1;
(statearr_20675_20713[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (5))){
var _ = (function (){var statearr_20676 = state_20645;
(statearr_20676[(4)] = cljs.core.rest((state_20645[(4)])));

return statearr_20676;
})();
var state_20645__$1 = state_20645;
var ex20672 = (state_20645__$1[(2)]);
var statearr_20677_20714 = state_20645__$1;
(statearr_20677_20714[(5)] = ex20672);


if((ex20672 instanceof Error)){
var statearr_20678_20715 = state_20645__$1;
(statearr_20678_20715[(1)] = (4));

(statearr_20678_20715[(5)] = null);

} else {
throw ex20672;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (14))){
var inst_20568 = (state_20645[(19)]);
var state_20645__$1 = state_20645;
var statearr_20679_20716 = state_20645__$1;
(statearr_20679_20716[(2)] = inst_20568);

(statearr_20679_20716[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (16))){
var inst_20626 = (state_20645[(2)]);
var state_20645__$1 = state_20645;
var statearr_20680_20717 = state_20645__$1;
(statearr_20680_20717[(2)] = inst_20626);

(statearr_20680_20717[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (10))){
var inst_20631 = (state_20645[(9)]);
var inst_20632 = (state_20645[(10)]);
var inst_20630 = (state_20645[(2)]);
var inst_20631__$1 = cljs.core.keys(inst_20630);
var inst_20632__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_20631__$1,inst_20630);
var inst_20633 = fluree.db.query.analytical.recur_map__GT_tuples(inst_20631__$1,inst_20632__$1);
var state_20645__$1 = (function (){var statearr_20681 = state_20645;
(statearr_20681[(9)] = inst_20631__$1);

(statearr_20681[(10)] = inst_20632__$1);

(statearr_20681[(11)] = inst_20633);

return statearr_20681;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20682_20718 = state_20645__$1;
(statearr_20682_20718[(1)] = (23));

} else {
var statearr_20683_20719 = state_20645__$1;
(statearr_20683_20719[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (18))){
var inst_20569 = (state_20645[(20)]);
var inst_20568 = (state_20645[(19)]);
var inst_20617 = (state_20645[(2)]);
var inst_20618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20619 = [(0),(2)];
var inst_20620 = (new cljs.core.PersistentVector(null,2,(5),inst_20618,inst_20619,null));
var inst_20621 = fluree.db.query.analytical.get_ns_arrays(inst_20620,inst_20617);
var inst_20622 = fluree.db.query.analytical.tuples__GT_map(inst_20568,inst_20621);
var inst_20623 = (inst_20569 + (1));
var inst_20568__$1 = inst_20622;
var inst_20569__$1 = inst_20623;
var state_20645__$1 = (function (){var statearr_20684 = state_20645;
(statearr_20684[(20)] = inst_20569__$1);

(statearr_20684[(19)] = inst_20568__$1);

return statearr_20684;
})();
var statearr_20685_20720 = state_20645__$1;
(statearr_20685_20720[(2)] = null);

(statearr_20685_20720[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20646 === (8))){
var inst_20566 = (state_20645[(2)]);
var inst_20567 = recur_map;
var inst_20568 = inst_20567;
var inst_20569 = (1);
var state_20645__$1 = (function (){var statearr_20686 = state_20645;
(statearr_20686[(8)] = inst_20566);

(statearr_20686[(20)] = inst_20569);

(statearr_20686[(19)] = inst_20568);

return statearr_20686;
})();
var statearr_20687_20721 = state_20645__$1;
(statearr_20687_20721[(2)] = null);

(statearr_20687_20721[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2741__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2741__auto____0 = (function (){
var statearr_20688 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20688[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2741__auto__);

(statearr_20688[(1)] = (1));

return statearr_20688;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2741__auto____1 = (function (state_20645){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_20645);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e20689){var ex__2744__auto__ = e20689;
var statearr_20690_20722 = state_20645;
(statearr_20690_20722[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_20645[(4)]))){
var statearr_20691_20723 = state_20645;
(statearr_20691_20723[(1)] = cljs.core.first((state_20645[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20724 = state_20645;
state_20645 = G__20724;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2741__auto__ = function(state_20645){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2741__auto____1.call(this,state_20645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2741__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2741__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_20692 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_20692[(6)] = c__2763__auto__);

return statearr_20692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20725,clause,fuel,max_fuel){
var map__20726 = p__20725;
var map__20726__$1 = cljs.core.__destructure_map(map__20726);
var res = map__20726__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20726__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20726__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20726__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_20837){
var state_val_20838 = (state_20837[(1)]);
if((state_val_20838 === (7))){
var inst_20743 = (state_20837[(7)]);
var state_20837__$1 = state_20837;
var statearr_20839_20892 = state_20837__$1;
(statearr_20839_20892[(2)] = inst_20743);

(statearr_20839_20892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (20))){
var inst_20771 = (state_20837[(8)]);
var inst_20802 = typeof inst_20771 === 'number';
var state_20837__$1 = state_20837;
if(cljs.core.truth_(inst_20802)){
var statearr_20840_20893 = state_20837__$1;
(statearr_20840_20893[(1)] = (22));

} else {
var statearr_20841_20894 = state_20837__$1;
(statearr_20841_20894[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (27))){
var inst_20817 = (state_20837[(2)]);
var state_20837__$1 = state_20837;
var statearr_20842_20895 = state_20837__$1;
(statearr_20842_20895[(2)] = inst_20817);

(statearr_20842_20895[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (1))){
var state_20837__$1 = state_20837;
var statearr_20843_20896 = state_20837__$1;
(statearr_20843_20896[(2)] = null);

(statearr_20843_20896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (24))){
var inst_20819 = (state_20837[(2)]);
var state_20837__$1 = state_20837;
var statearr_20844_20897 = state_20837__$1;
(statearr_20844_20897[(2)] = inst_20819);

(statearr_20844_20897[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (4))){
var inst_20727 = (state_20837[(2)]);
var state_20837__$1 = state_20837;
var statearr_20845_20898 = state_20837__$1;
(statearr_20845_20898[(2)] = inst_20727);

(statearr_20845_20898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (15))){
var inst_20785 = (state_20837[(2)]);
var inst_20786 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_20787 = fluree.db.query.analytical.variable_QMARK_(inst_20786);
var state_20837__$1 = (function (){var statearr_20846 = state_20837;
(statearr_20846[(9)] = inst_20785);

return statearr_20846;
})();
if(cljs.core.truth_(inst_20787)){
var statearr_20847_20899 = state_20837__$1;
(statearr_20847_20899[(1)] = (16));

} else {
var statearr_20848_20900 = state_20837__$1;
(statearr_20848_20900[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (21))){
var inst_20773 = (state_20837[(10)]);
var inst_20774 = (state_20837[(11)]);
var inst_20744 = (state_20837[(12)]);
var inst_20821 = (state_20837[(2)]);
var inst_20822 = fluree.db.query.analytical.tuples__GT_recur(db,inst_20774,inst_20821,inst_20744,inst_20773);
var state_20837__$1 = state_20837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20837__$1,(28),inst_20822);
} else {
if((state_val_20838 === (13))){
var inst_20753 = (state_20837[(13)]);
var inst_20777 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20753)].join('');
var inst_20778 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20779 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20780 = cljs.core.PersistentHashMap.fromArrays(inst_20778,inst_20779);
var inst_20781 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20777,inst_20780);
var inst_20782 = (function(){throw inst_20781})();
var state_20837__$1 = state_20837;
var statearr_20849_20901 = state_20837__$1;
(statearr_20849_20901[(2)] = inst_20782);

(statearr_20849_20901[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (22))){
var inst_20771 = (state_20837[(8)]);
var inst_20769 = (state_20837[(14)]);
var inst_20804 = cljs.core.PersistentHashMap.EMPTY;
var inst_20805 = cljs.core.flatten(inst_20769);
var inst_20806 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20804,inst_20771,inst_20805);
var state_20837__$1 = state_20837;
var statearr_20850_20902 = state_20837__$1;
(statearr_20850_20902[(2)] = inst_20806);

(statearr_20850_20902[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (6))){
var inst_20755 = (state_20837[(15)]);
var state_20837__$1 = state_20837;
var statearr_20851_20903 = state_20837__$1;
(statearr_20851_20903[(2)] = inst_20755);

(statearr_20851_20903[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (28))){
var inst_20824 = (state_20837[(2)]);
var inst_20825 = fluree.db.util.async.throw_err(inst_20824);
var state_20837__$1 = state_20837;
var statearr_20852_20904 = state_20837__$1;
(statearr_20852_20904[(2)] = inst_20825);

(statearr_20852_20904[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (25))){
var inst_20765 = (state_20837[(16)]);
var inst_20769 = (state_20837[(14)]);
var inst_20810 = cljs.core.PersistentHashMap.EMPTY;
var inst_20811 = cljs.core.first(inst_20765);
var inst_20812 = cljs.core.first(inst_20811);
var inst_20813 = cljs.core.flatten(inst_20769);
var inst_20814 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20810,inst_20812,inst_20813);
var state_20837__$1 = state_20837;
var statearr_20853_20905 = state_20837__$1;
(statearr_20853_20905[(2)] = inst_20814);

(statearr_20853_20905[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (17))){
var inst_20753 = (state_20837[(13)]);
var inst_20790 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20753)].join('');
var inst_20791 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20792 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20793 = cljs.core.PersistentHashMap.fromArrays(inst_20791,inst_20792);
var inst_20794 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20790,inst_20793);
var inst_20795 = (function(){throw inst_20794})();
var state_20837__$1 = state_20837;
var statearr_20854_20906 = state_20837__$1;
(statearr_20854_20906[(2)] = inst_20795);

(statearr_20854_20906[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (3))){
var inst_20835 = (state_20837[(2)]);
var state_20837__$1 = state_20837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20837__$1,inst_20835);
} else {
if((state_val_20838 === (12))){
var inst_20740 = (state_20837[(17)]);
var inst_20828 = (state_20837[(2)]);
var inst_20829 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20830 = cljs.core.keys(inst_20740);
var inst_20831 = [inst_20830,vars,inst_20828];
var inst_20832 = cljs.core.PersistentHashMap.fromArrays(inst_20829,inst_20831);
var _ = (function (){var statearr_20855 = state_20837;
(statearr_20855[(4)] = cljs.core.rest((state_20837[(4)])));

return statearr_20855;
})();
var state_20837__$1 = state_20837;
var statearr_20856_20907 = state_20837__$1;
(statearr_20856_20907[(2)] = inst_20832);

(statearr_20856_20907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (2))){
var inst_20740 = (state_20837[(17)]);
var inst_20755 = (state_20837[(15)]);
var inst_20744 = (state_20837[(12)]);
var inst_20743 = (state_20837[(7)]);
var _ = (function (){var statearr_20857 = state_20837;
(statearr_20857[(4)] = cljs.core.cons((5),(state_20837[(4)])));

return statearr_20857;
})();
var inst_20737 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_20738 = cljs.core.__destructure_map(inst_20737);
var inst_20739 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20738,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20740__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20738,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20741 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20738,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20742 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_20743__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20741);
var inst_20744__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20741);
var inst_20746 = (function (){var map__20733 = inst_20738;
var search = inst_20739;
var rel = inst_20740__$1;
var opts = inst_20741;
var common_keys = inst_20742;
var object_fn = inst_20743__$1;
var recur_depth = inst_20744__$1;
return (function (p__20745,common_key){
var vec__20858 = p__20745;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20858,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20858,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20861 = cljs.core._EQ_;
var expr__20862 = idx_of;
if(cljs.core.truth_((pred__20861.cljs$core$IFn$_invoke$arity$2 ? pred__20861.cljs$core$IFn$_invoke$arity$2((0),expr__20862) : pred__20861.call(null,(0),expr__20862)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__20861.cljs$core$IFn$_invoke$arity$2 ? pred__20861.cljs$core$IFn$_invoke$arity$2((1),expr__20862) : pred__20861.call(null,(1),expr__20862)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__20861.cljs$core$IFn$_invoke$arity$2 ? pred__20861.cljs$core$IFn$_invoke$arity$2((2),expr__20862) : pred__20861.call(null,(2),expr__20862)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20862)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4251__auto__ = (!(single_v_QMARK_));
if(and__4251__auto__){
var and__4251__auto____$1 = object_fn;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20748 = cljs.core.PersistentHashMap.EMPTY;
var inst_20749 = [inst_20748,inst_20739];
var inst_20750 = (new cljs.core.PersistentVector(null,2,(5),inst_20747,inst_20749,null));
var inst_20751 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20746,inst_20750,inst_20742);
var inst_20752 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20751,(0),null);
var inst_20753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20751,(1),null);
var inst_20754 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20755__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20752);
var state_20837__$1 = (function (){var statearr_20864 = state_20837;
(statearr_20864[(17)] = inst_20740__$1);

(statearr_20864[(13)] = inst_20753);

(statearr_20864[(18)] = inst_20754);

(statearr_20864[(15)] = inst_20755__$1);

(statearr_20864[(12)] = inst_20744__$1);

(statearr_20864[(7)] = inst_20743__$1);

return statearr_20864;
})();
if(cljs.core.truth_(inst_20755__$1)){
var statearr_20865_20908 = state_20837__$1;
(statearr_20865_20908[(1)] = (6));

} else {
var statearr_20866_20909 = state_20837__$1;
(statearr_20866_20909[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (23))){
var inst_20771 = (state_20837[(8)]);
var inst_20808 = cljs.core.coll_QMARK_(inst_20771);
var state_20837__$1 = state_20837;
if(inst_20808){
var statearr_20867_20910 = state_20837__$1;
(statearr_20867_20910[(1)] = (25));

} else {
var statearr_20868_20911 = state_20837__$1;
(statearr_20868_20911[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (19))){
var inst_20769 = (state_20837[(14)]);
var inst_20799 = cljs.core.PersistentHashMap.EMPTY;
var inst_20800 = fluree.db.query.analytical.tuples__GT_map(inst_20799,inst_20769);
var state_20837__$1 = state_20837;
var statearr_20869_20912 = state_20837__$1;
(statearr_20869_20912[(2)] = inst_20800);

(statearr_20869_20912[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (11))){
var inst_20769 = (state_20837[(14)]);
var state_20837__$1 = state_20837;
var statearr_20871_20913 = state_20837__$1;
(statearr_20871_20913[(2)] = inst_20769);

(statearr_20871_20913[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (9))){
var inst_20740 = (state_20837[(17)]);
var inst_20765 = (state_20837[(16)]);
var inst_20744 = (state_20837[(12)]);
var inst_20764 = (state_20837[(2)]);
var inst_20765__$1 = fluree.db.util.async.throw_err(inst_20764);
var inst_20766 = cljs.core.count(inst_20765__$1);
var inst_20767 = fluree.db.query.analytical.add_fuel(inst_20766,fuel,max_fuel);
var inst_20768 = cljs.core.vals(inst_20740);
var inst_20769 = fluree.db.query.analytical.get_ns_arrays(inst_20768,inst_20765__$1);
var state_20837__$1 = (function (){var statearr_20872 = state_20837;
(statearr_20872[(16)] = inst_20765__$1);

(statearr_20872[(19)] = inst_20767);

(statearr_20872[(14)] = inst_20769);

return statearr_20872;
})();
if(cljs.core.truth_(inst_20744)){
var statearr_20873_20914 = state_20837__$1;
(statearr_20873_20914[(1)] = (10));

} else {
var statearr_20874_20915 = state_20837__$1;
(statearr_20874_20915[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (5))){
var _ = (function (){var statearr_20875 = state_20837;
(statearr_20875[(4)] = cljs.core.rest((state_20837[(4)])));

return statearr_20875;
})();
var state_20837__$1 = state_20837;
var ex20870 = (state_20837__$1[(2)]);
var statearr_20876_20916 = state_20837__$1;
(statearr_20876_20916[(5)] = ex20870);


if((ex20870 instanceof Error)){
var statearr_20877_20917 = state_20837__$1;
(statearr_20877_20917[(1)] = (4));

(statearr_20877_20917[(5)] = null);

} else {
throw ex20870;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (14))){
var state_20837__$1 = state_20837;
var statearr_20878_20918 = state_20837__$1;
(statearr_20878_20918[(2)] = null);

(statearr_20878_20918[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (26))){
var state_20837__$1 = state_20837;
var statearr_20879_20919 = state_20837__$1;
(statearr_20879_20919[(2)] = null);

(statearr_20879_20919[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (16))){
var state_20837__$1 = state_20837;
var statearr_20880_20920 = state_20837__$1;
(statearr_20880_20920[(2)] = null);

(statearr_20880_20920[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (10))){
var inst_20753 = (state_20837[(13)]);
var inst_20774 = (state_20837[(11)]);
var inst_20771 = cljs.core.first(inst_20753);
var inst_20772 = cljs.core.first(clause);
var inst_20773 = fluree.db.query.analytical.variable_QMARK_(inst_20772);
var inst_20774__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_20753,(1));
var inst_20775 = fluree.db.query.analytical.variable_QMARK_(inst_20774__$1);
var state_20837__$1 = (function (){var statearr_20881 = state_20837;
(statearr_20881[(10)] = inst_20773);

(statearr_20881[(8)] = inst_20771);

(statearr_20881[(11)] = inst_20774__$1);

return statearr_20881;
})();
if(cljs.core.truth_(inst_20775)){
var statearr_20882_20921 = state_20837__$1;
(statearr_20882_20921[(1)] = (13));

} else {
var statearr_20883_20922 = state_20837__$1;
(statearr_20883_20922[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (18))){
var inst_20773 = (state_20837[(10)]);
var inst_20797 = (state_20837[(2)]);
var state_20837__$1 = (function (){var statearr_20884 = state_20837;
(statearr_20884[(20)] = inst_20797);

return statearr_20884;
})();
if(cljs.core.truth_(inst_20773)){
var statearr_20885_20923 = state_20837__$1;
(statearr_20885_20923[(1)] = (19));

} else {
var statearr_20886_20924 = state_20837__$1;
(statearr_20886_20924[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20838 === (8))){
var inst_20753 = (state_20837[(13)]);
var inst_20754 = (state_20837[(18)]);
var inst_20759 = (state_20837[(2)]);
var inst_20760 = [inst_20759];
var inst_20761 = cljs.core.PersistentHashMap.fromArrays(inst_20754,inst_20760);
var inst_20762 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_20753,inst_20761);
var state_20837__$1 = state_20837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20837__$1,(9),inst_20762);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2741__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2741__auto____0 = (function (){
var statearr_20887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20887[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2741__auto__);

(statearr_20887[(1)] = (1));

return statearr_20887;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2741__auto____1 = (function (state_20837){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_20837);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e20888){var ex__2744__auto__ = e20888;
var statearr_20889_20925 = state_20837;
(statearr_20889_20925[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_20837[(4)]))){
var statearr_20890_20926 = state_20837;
(statearr_20890_20926[(1)] = cljs.core.first((state_20837[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20927 = state_20837;
state_20837 = G__20927;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2741__auto__ = function(state_20837){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2741__auto____1.call(this,state_20837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2741__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2741__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_20891 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_20891[(6)] = c__2763__auto__);

return statearr_20891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20928,res,clause){
var map__20929 = p__20928;
var map__20929__$1 = cljs.core.__destructure_map(map__20929);
var db = map__20929__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20929__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20929__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20929__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_21038){
var state_val_21039 = (state_21038[(1)]);
if((state_val_21039 === (7))){
var inst_20938 = (state_21038[(7)]);
var state_21038__$1 = state_21038;
var statearr_21040_21081 = state_21038__$1;
(statearr_21040_21081[(2)] = inst_20938);

(statearr_21040_21081[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (20))){
var state_21038__$1 = state_21038;
var statearr_21041_21082 = state_21038__$1;
(statearr_21041_21082[(2)] = null);

(statearr_21041_21082[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (1))){
var state_21038__$1 = state_21038;
var statearr_21042_21083 = state_21038__$1;
(statearr_21042_21083[(2)] = null);

(statearr_21042_21083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (24))){
var inst_20940 = (state_21038[(8)]);
var inst_21011 = (state_21038[(2)]);
var inst_21012 = fluree.db.flake.sid__GT_cid(inst_21011);
var inst_21013 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_21012);
var inst_21014 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21016 = [inst_20940];
var inst_21017 = (new cljs.core.PersistentVector(null,1,(5),inst_21015,inst_21016,null));
var inst_21018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21020 = [inst_21013];
var inst_21021 = (new cljs.core.PersistentVector(null,1,(5),inst_21019,inst_21020,null));
var inst_21022 = [inst_21021];
var inst_21023 = (new cljs.core.PersistentVector(null,1,(5),inst_21018,inst_21022,null));
var inst_21024 = cljs.core.PersistentHashMap.EMPTY;
var inst_21025 = [inst_21017,inst_21023,inst_21024];
var inst_21026 = cljs.core.PersistentHashMap.fromArrays(inst_21014,inst_21025);
var state_21038__$1 = state_21038;
var statearr_21043_21084 = state_21038__$1;
(statearr_21043_21084[(2)] = inst_21026);

(statearr_21043_21084[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (4))){
var inst_20931 = (state_21038[(2)]);
var state_21038__$1 = state_21038;
var statearr_21044_21085 = state_21038__$1;
(statearr_21044_21085[(2)] = inst_20931);

(statearr_21044_21085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (15))){
var inst_20940 = (state_21038[(8)]);
var inst_20938 = (state_21038[(7)]);
var inst_20959 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20960 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20962 = [inst_20938];
var inst_20963 = (new cljs.core.PersistentVector(null,1,(5),inst_20961,inst_20962,null));
var inst_20964 = (function (){var subject_var = inst_20938;
var object_var = inst_20940;
var min_sid = inst_20959;
var max_sid = (0);
return (function (p1__20930_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__20930_SHARP_);
});
})();
var inst_20965 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_20959,(0));
var inst_20966 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20964,inst_20965);
var inst_20967 = cljs.core.PersistentHashMap.EMPTY;
var inst_20968 = [inst_20963,inst_20966,inst_20967];
var inst_20969 = cljs.core.PersistentHashMap.fromArrays(inst_20960,inst_20968);
var state_21038__$1 = state_21038;
var statearr_21045_21086 = state_21038__$1;
(statearr_21045_21086[(2)] = inst_20969);

(statearr_21045_21086[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (21))){
var inst_21029 = (state_21038[(2)]);
var state_21038__$1 = state_21038;
var statearr_21046_21087 = state_21038__$1;
(statearr_21046_21087[(2)] = inst_21029);

(statearr_21046_21087[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (13))){
var inst_20940 = (state_21038[(8)]);
var state_21038__$1 = state_21038;
if(cljs.core.truth_(inst_20940)){
var statearr_21047_21088 = state_21038__$1;
(statearr_21047_21088[(1)] = (19));

} else {
var statearr_21048_21089 = state_21038__$1;
(statearr_21048_21089[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (22))){
var inst_21002 = (state_21038[(9)]);
var state_21038__$1 = state_21038;
var statearr_21049_21090 = state_21038__$1;
(statearr_21049_21090[(2)] = inst_21002);

(statearr_21049_21090[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (6))){
var inst_20940 = (state_21038[(8)]);
var state_21038__$1 = state_21038;
var statearr_21050_21091 = state_21038__$1;
(statearr_21050_21091[(2)] = inst_20940);

(statearr_21050_21091[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (25))){
var inst_21008 = (state_21038[(2)]);
var inst_21009 = fluree.db.util.async.throw_err(inst_21008);
var state_21038__$1 = state_21038;
var statearr_21051_21092 = state_21038__$1;
(statearr_21051_21092[(2)] = inst_21009);

(statearr_21051_21092[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (17))){
var inst_20999 = (state_21038[(2)]);
var state_21038__$1 = state_21038;
var statearr_21052_21093 = state_21038__$1;
(statearr_21052_21093[(2)] = inst_20999);

(statearr_21052_21093[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (3))){
var inst_21036 = (state_21038[(2)]);
var state_21038__$1 = state_21038;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21038__$1,inst_21036);
} else {
if((state_val_21039 === (12))){
var inst_20953 = ["_tx",null,"_block",null];
var inst_20954 = (new cljs.core.PersistentArrayMap(null,2,inst_20953,null));
var inst_20955 = (new cljs.core.PersistentHashSet(null,inst_20954,null));
var inst_20956 = cljs.core.last(clause);
var inst_20957 = (inst_20955.cljs$core$IFn$_invoke$arity$1 ? inst_20955.cljs$core$IFn$_invoke$arity$1(inst_20956) : inst_20955.call(null,inst_20956));
var state_21038__$1 = state_21038;
if(cljs.core.truth_(inst_20957)){
var statearr_21053_21094 = state_21038__$1;
(statearr_21053_21094[(1)] = (15));

} else {
var statearr_21054_21095 = state_21038__$1;
(statearr_21054_21095[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (2))){
var inst_20938 = (state_21038[(7)]);
var _ = (function (){var statearr_21055 = state_21038;
(statearr_21055[(4)] = cljs.core.cons((5),(state_21038[(4)])));

return statearr_21055;
})();
var inst_20937 = cljs.core.first(clause);
var inst_20938__$1 = fluree.db.query.analytical.variable_QMARK_(inst_20937);
var inst_20939 = cljs.core.last(clause);
var inst_20940 = fluree.db.query.analytical.variable_QMARK_(inst_20939);
var state_21038__$1 = (function (){var statearr_21056 = state_21038;
(statearr_21056[(8)] = inst_20940);

(statearr_21056[(7)] = inst_20938__$1);

return statearr_21056;
})();
if(cljs.core.truth_(inst_20938__$1)){
var statearr_21057_21096 = state_21038__$1;
(statearr_21057_21096[(1)] = (6));

} else {
var statearr_21058_21097 = state_21038__$1;
(statearr_21058_21097[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (23))){
var inst_21002 = (state_21038[(9)]);
var inst_21006 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_21002);
var state_21038__$1 = state_21038;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21038__$1,(25),inst_21006);
} else {
if((state_val_21039 === (19))){
var inst_21002 = (state_21038[(9)]);
var inst_21002__$1 = cljs.core.first(clause);
var inst_21003 = typeof inst_21002__$1 === 'number';
var state_21038__$1 = (function (){var statearr_21059 = state_21038;
(statearr_21059[(9)] = inst_21002__$1);

return statearr_21059;
})();
if(cljs.core.truth_(inst_21003)){
var statearr_21060_21098 = state_21038__$1;
(statearr_21060_21098[(1)] = (22));

} else {
var statearr_21061_21099 = state_21038__$1;
(statearr_21061_21099[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (11))){
var inst_21033 = (state_21038[(2)]);
var _ = (function (){var statearr_21063 = state_21038;
(statearr_21063[(4)] = cljs.core.rest((state_21038[(4)])));

return statearr_21063;
})();
var state_21038__$1 = state_21038;
var statearr_21064_21100 = state_21038__$1;
(statearr_21064_21100[(2)] = inst_21033);

(statearr_21064_21100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (9))){
var inst_20946 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20947 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20948 = cljs.core.PersistentHashMap.fromArrays(inst_20946,inst_20947);
var inst_20949 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_20948);
var inst_20950 = (function(){throw inst_20949})();
var state_21038__$1 = state_21038;
var statearr_21065_21101 = state_21038__$1;
(statearr_21065_21101[(2)] = inst_20950);

(statearr_21065_21101[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (5))){
var _ = (function (){var statearr_21066 = state_21038;
(statearr_21066[(4)] = cljs.core.rest((state_21038[(4)])));

return statearr_21066;
})();
var state_21038__$1 = state_21038;
var ex21062 = (state_21038__$1[(2)]);
var statearr_21067_21102 = state_21038__$1;
(statearr_21067_21102[(5)] = ex21062);


if((ex21062 instanceof Error)){
var statearr_21068_21103 = state_21038__$1;
(statearr_21068_21103[(1)] = (4));

(statearr_21068_21103[(5)] = null);

} else {
throw ex21062;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (14))){
var inst_21031 = (state_21038[(2)]);
var state_21038__$1 = state_21038;
var statearr_21069_21104 = state_21038__$1;
(statearr_21069_21104[(2)] = inst_21031);

(statearr_21069_21104[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (16))){
var inst_20974 = (state_21038[(10)]);
var inst_20972 = (state_21038[(11)]);
var inst_20975 = (state_21038[(12)]);
var inst_20971 = cljs.core.last(clause);
var inst_20972__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20971);
var inst_20973 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20974__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20973,inst_20972__$1);
var inst_20975__$1 = fluree.db.flake.min_subject_id(inst_20972__$1);
var inst_20976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20977 = [inst_20974__$1];
var inst_20978 = (new cljs.core.PersistentVector(null,1,(5),inst_20976,inst_20977,null));
var inst_20979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20980 = [inst_20975__$1];
var inst_20981 = (new cljs.core.PersistentVector(null,1,(5),inst_20979,inst_20980,null));
var inst_20982 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20978,cljs.core._LT__EQ_,inst_20981);
var state_21038__$1 = (function (){var statearr_21070 = state_21038;
(statearr_21070[(10)] = inst_20974__$1);

(statearr_21070[(11)] = inst_20972__$1);

(statearr_21070[(12)] = inst_20975__$1);

return statearr_21070;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21038__$1,(18),inst_20982);
} else {
if((state_val_21039 === (10))){
var inst_20938 = (state_21038[(7)]);
var state_21038__$1 = state_21038;
if(cljs.core.truth_(inst_20938)){
var statearr_21071_21105 = state_21038__$1;
(statearr_21071_21105[(1)] = (12));

} else {
var statearr_21072_21106 = state_21038__$1;
(statearr_21072_21106[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (18))){
var inst_20940 = (state_21038[(8)]);
var inst_20974 = (state_21038[(10)]);
var inst_20972 = (state_21038[(11)]);
var inst_20975 = (state_21038[(12)]);
var inst_20938 = (state_21038[(7)]);
var inst_20984 = (state_21038[(2)]);
var inst_20985 = fluree.db.util.async.throw_err(inst_20984);
var inst_20986 = (function (){var subject_var = inst_20938;
var object_var = inst_20940;
var partition = inst_20972;
var max_sid = inst_20974;
var min_sid = inst_20975;
var flakes = inst_20985;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20987 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_20986);
var inst_20988 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_20989 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_20987,inst_20988);
var inst_20990 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20992 = [inst_20938];
var inst_20993 = (new cljs.core.PersistentVector(null,1,(5),inst_20991,inst_20992,null));
var inst_20994 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_20989,inst_20985);
var inst_20995 = cljs.core.PersistentHashMap.EMPTY;
var inst_20996 = [inst_20993,inst_20994,inst_20995];
var inst_20997 = cljs.core.PersistentHashMap.fromArrays(inst_20990,inst_20996);
var state_21038__$1 = state_21038;
var statearr_21073_21107 = state_21038__$1;
(statearr_21073_21107[(2)] = inst_20997);

(statearr_21073_21107[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21039 === (8))){
var inst_20944 = (state_21038[(2)]);
var state_21038__$1 = state_21038;
if(cljs.core.truth_(inst_20944)){
var statearr_21074_21108 = state_21038__$1;
(statearr_21074_21108[(1)] = (9));

} else {
var statearr_21075_21109 = state_21038__$1;
(statearr_21075_21109[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2741__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2741__auto____0 = (function (){
var statearr_21076 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21076[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2741__auto__);

(statearr_21076[(1)] = (1));

return statearr_21076;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2741__auto____1 = (function (state_21038){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_21038);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e21077){var ex__2744__auto__ = e21077;
var statearr_21078_21110 = state_21038;
(statearr_21078_21110[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_21038[(4)]))){
var statearr_21079_21111 = state_21038;
(statearr_21079_21111[(1)] = cljs.core.first((state_21038[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21112 = state_21038;
state_21038 = G__21112;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2741__auto__ = function(state_21038){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2741__auto____1.call(this,state_21038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2741__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2741__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_21080 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_21080[(6)] = c__2763__auto__);

return statearr_21080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__21119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__21119 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__21119;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4652__auto__ = (function fluree$db$query$analytical$variance_$_iter__21120(s__21121){
return (new cljs.core.LazySeq(null,(function (){
var s__21121__$1 = s__21121;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__21121__$1);
if(temp__5753__auto__){
var s__21121__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__21121__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__21121__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__21123 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__21122 = (0);
while(true){
if((i__21122 < size__4651__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__21122);
var delta = (x - mean);
cljs.core.chunk_append(b__21123,(delta * delta));

var G__21125 = (i__21122 + (1));
i__21122 = G__21125;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__21123),fluree$db$query$analytical$variance_$_iter__21120(cljs.core.chunk_rest(s__21121__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__21123),null);
}
} else {
var x = cljs.core.first(s__21121__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__21120(cljs.core.rest(s__21121__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__21124 = variance(coll);
return Math.sqrt(G__21124);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4336__auto__ = n;
var y__4337__auto__ = (- n);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
}),(function() {
var G__21126 = null;
var G__21126__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21126__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21126 = function(n,coll){
switch(arguments.length){
case 1:
return G__21126__1.call(this,n);
case 2:
return G__21126__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21126.cljs$core$IFn$_invoke$arity$1 = G__21126__1;
G__21126.cljs$core$IFn$_invoke$arity$2 = G__21126__2;
return G__21126;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21127 = null;
var G__21127__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21127__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21127 = function(n,coll){
switch(arguments.length){
case 1:
return G__21127__1.call(this,n);
case 2:
return G__21127__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21127.cljs$core$IFn$_invoke$arity$1 = G__21127__1;
G__21127.cljs$core$IFn$_invoke$arity$2 = G__21127__2;
return G__21127;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21128 = null;
var G__21128__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__21128__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__21128 = function(n,coll){
switch(arguments.length){
case 1:
return G__21128__1.call(this,n);
case 2:
return G__21128__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21128.cljs$core$IFn$_invoke$arity$1 = G__21128__1;
G__21128.cljs$core$IFn$_invoke$arity$2 = G__21128__2;
return G__21128;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__21129 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21129,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21129,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21129,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21132 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__21135 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__21135) : agg_fn.call(null,G__21135));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21132,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21132,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__21136 = agg;
var map__21136__$1 = cljs.core.__destructure_map(map__21136);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21136__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21136__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21136__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__21138 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21138,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21138,(1),null);
var map__21141 = res__$1;
var map__21141__$1 = cljs.core.__destructure_map(map__21141);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21141__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21141__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21137_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__21137_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21142_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__21142_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21143_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21143_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__21144_SHARP_,p2__21145_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21144_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__21145_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21146_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21146_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__21149,row,b_tuple){
var vec__21150 = p__21149;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21150,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21150,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21147_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21147_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = acc;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21148_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21148_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21153_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21153_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21154_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21154_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21159 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21161 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__21160 = (function (p1__21155_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21155_SHARP_);
});
return fexpr__21160(G__21161);
})()),cljs.core.set(b_idxs));
var fexpr__21158 = (function (p1__21156_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21156_SHARP_);
});
return fexpr__21158(G__21159);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21157_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21157_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21162_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21162_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21163_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21163_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21168 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21170 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__21169 = (function (p1__21164_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21164_SHARP_);
});
return fexpr__21169(G__21170);
})()),cljs.core.set(b_idxs));
var fexpr__21167 = (function (p1__21165_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21165_SHARP_);
});
return fexpr__21167(G__21168);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21166_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21166_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__21172 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21172,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21172,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__21171_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__21171_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__21177 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21177,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21177,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21175_SHARP_){
return fluree.db.util.core.index_of(headers,p1__21175_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__21176_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__21176_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21180,filters,optional_QMARK_){
var map__21181 = p__21180;
var map__21181__$1 = cljs.core.__destructure_map(map__21181);
var tuple_map = map__21181__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21181__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21181__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21181__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21182 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21182,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21182,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21185 = res;
var map__21185__$1 = cljs.core.__destructure_map(map__21185);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21185__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21185__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_21241){
var state_val_21242 = (state_21241[(1)]);
if((state_val_21242 === (7))){
var inst_21215 = (state_21241[(7)]);
var inst_21213 = (state_21241[(2)]);
var inst_21214 = fluree.db.util.async.throw_err(inst_21213);
var inst_21215__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21214,(0),null);
var inst_21216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21214,(1),null);
var inst_21217 = (inst_21215__$1 == null);
var state_21241__$1 = (function (){var statearr_21243 = state_21241;
(statearr_21243[(8)] = inst_21216);

(statearr_21243[(7)] = inst_21215__$1);

return statearr_21243;
})();
if(cljs.core.truth_(inst_21217)){
var statearr_21244_21273 = state_21241__$1;
(statearr_21244_21273[(1)] = (8));

} else {
var statearr_21245_21274 = state_21241__$1;
(statearr_21245_21274[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (1))){
var inst_21193 = optional_clauses;
var inst_21194 = cljs.core.seq(inst_21193);
var inst_21195 = cljs.core.first(inst_21194);
var inst_21196 = cljs.core.next(inst_21194);
var inst_21197 = where_tuples;
var inst_21198 = inst_21193;
var inst_21199 = inst_21197;
var state_21241__$1 = (function (){var statearr_21246 = state_21241;
(statearr_21246[(9)] = inst_21196);

(statearr_21246[(10)] = inst_21195);

(statearr_21246[(11)] = inst_21198);

(statearr_21246[(12)] = inst_21199);

return statearr_21246;
})();
var statearr_21247_21275 = state_21241__$1;
(statearr_21247_21275[(2)] = null);

(statearr_21247_21275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (4))){
var inst_21205 = (state_21241[(13)]);
var inst_21206 = (state_21241[(14)]);
var inst_21199 = (state_21241[(12)]);
var inst_21211 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_21199,inst_21205,inst_21206,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21199,inst_21205,inst_21206,true,fuel,max_fuel,opts));
var state_21241__$1 = state_21241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21241__$1,(7),inst_21211);
} else {
if((state_val_21242 === (15))){
var state_21241__$1 = state_21241;
var statearr_21248_21276 = state_21241__$1;
(statearr_21248_21276[(2)] = null);

(statearr_21248_21276[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (13))){
var inst_21232 = (state_21241[(2)]);
var state_21241__$1 = state_21241;
var statearr_21249_21277 = state_21241__$1;
(statearr_21249_21277[(2)] = inst_21232);

(statearr_21249_21277[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (6))){
var inst_21237 = (state_21241[(2)]);
var state_21241__$1 = state_21241;
var statearr_21250_21278 = state_21241__$1;
(statearr_21250_21278[(2)] = inst_21237);

(statearr_21250_21278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (3))){
var inst_21239 = (state_21241[(2)]);
var state_21241__$1 = state_21241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21241__$1,inst_21239);
} else {
if((state_val_21242 === (12))){
var state_21241__$1 = state_21241;
var statearr_21251_21279 = state_21241__$1;
(statearr_21251_21279[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (2))){
var inst_21205 = (state_21241[(13)]);
var inst_21198 = (state_21241[(11)]);
var inst_21204 = cljs.core.seq(inst_21198);
var inst_21205__$1 = cljs.core.first(inst_21204);
var inst_21206 = cljs.core.next(inst_21204);
var state_21241__$1 = (function (){var statearr_21253 = state_21241;
(statearr_21253[(13)] = inst_21205__$1);

(statearr_21253[(14)] = inst_21206);

return statearr_21253;
})();
if(cljs.core.truth_(inst_21205__$1)){
var statearr_21254_21280 = state_21241__$1;
(statearr_21254_21280[(1)] = (4));

} else {
var statearr_21255_21281 = state_21241__$1;
(statearr_21255_21281[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (11))){
var inst_21216 = (state_21241[(8)]);
var inst_21215 = (state_21241[(7)]);
var inst_21198 = inst_21216;
var inst_21199 = inst_21215;
var state_21241__$1 = (function (){var statearr_21256 = state_21241;
(statearr_21256[(11)] = inst_21198);

(statearr_21256[(12)] = inst_21199);

return statearr_21256;
})();
var statearr_21257_21282 = state_21241__$1;
(statearr_21257_21282[(2)] = null);

(statearr_21257_21282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (9))){
var inst_21205 = (state_21241[(13)]);
var inst_21221 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21205);
var state_21241__$1 = state_21241;
if(cljs.core.truth_(inst_21221)){
var statearr_21258_21283 = state_21241__$1;
(statearr_21258_21283[(1)] = (11));

} else {
var statearr_21259_21284 = state_21241__$1;
(statearr_21259_21284[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (5))){
var inst_21199 = (state_21241[(12)]);
var state_21241__$1 = state_21241;
var statearr_21260_21285 = state_21241__$1;
(statearr_21260_21285[(2)] = inst_21199);

(statearr_21260_21285[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (14))){
var inst_21216 = (state_21241[(8)]);
var inst_21215 = (state_21241[(7)]);
var inst_21199 = (state_21241[(12)]);
var inst_21226 = fluree.db.query.analytical.left_outer_join(inst_21199,inst_21215);
var inst_21198 = inst_21216;
var inst_21199__$1 = inst_21226;
var state_21241__$1 = (function (){var statearr_21261 = state_21241;
(statearr_21261[(11)] = inst_21198);

(statearr_21261[(12)] = inst_21199__$1);

return statearr_21261;
})();
var statearr_21262_21286 = state_21241__$1;
(statearr_21262_21286[(2)] = null);

(statearr_21262_21286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (16))){
var inst_21230 = (state_21241[(2)]);
var state_21241__$1 = state_21241;
var statearr_21264_21287 = state_21241__$1;
(statearr_21264_21287[(2)] = inst_21230);

(statearr_21264_21287[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (10))){
var inst_21234 = (state_21241[(2)]);
var state_21241__$1 = state_21241;
var statearr_21265_21288 = state_21241__$1;
(statearr_21265_21288[(2)] = inst_21234);

(statearr_21265_21288[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (8))){
var inst_21216 = (state_21241[(8)]);
var inst_21199 = (state_21241[(12)]);
var tmp21263 = inst_21199;
var inst_21198 = inst_21216;
var inst_21199__$1 = tmp21263;
var state_21241__$1 = (function (){var statearr_21266 = state_21241;
(statearr_21266[(11)] = inst_21198);

(statearr_21266[(12)] = inst_21199__$1);

return statearr_21266;
})();
var statearr_21267_21289 = state_21241__$1;
(statearr_21267_21289[(2)] = null);

(statearr_21267_21289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2741__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2741__auto____0 = (function (){
var statearr_21268 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21268[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2741__auto__);

(statearr_21268[(1)] = (1));

return statearr_21268;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2741__auto____1 = (function (state_21241){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_21241);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e21269){var ex__2744__auto__ = e21269;
var statearr_21270_21290 = state_21241;
(statearr_21270_21290[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_21241[(4)]))){
var statearr_21271_21291 = state_21241;
(statearr_21271_21291[(1)] = cljs.core.first((state_21241[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21292 = state_21241;
state_21241 = G__21292;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2741__auto__ = function(state_21241){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2741__auto____1.call(this,state_21241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2741__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2741__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_21272 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_21272[(6)] = c__2763__auto__);

return statearr_21272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__21294){
var vec__21295 = p__21294;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21295,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21295,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21293_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21293_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21299,p__21300,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21301 = p__21299;
var map__21301__$1 = cljs.core.__destructure_map(map__21301);
var q_map = map__21301__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21301__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21302 = p__21300;
var map__21302__$1 = cljs.core.__destructure_map(map__21302);
var res = map__21302__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21302__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_21539){
var state_val_21540 = (state_21539[(1)]);
if((state_val_21540 === (65))){
var inst_21488 = (state_21539[(7)]);
var inst_21489 = (state_21539[(8)]);
var inst_21500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21501 = fluree.db.query.analytical.full_text__GT_tuples(inst_21488,res,inst_21489);
var inst_21502 = [inst_21501,r];
var inst_21503 = (new cljs.core.PersistentVector(null,2,(5),inst_21500,inst_21502,null));
var state_21539__$1 = state_21539;
var statearr_21541_21654 = state_21539__$1;
(statearr_21541_21654[(2)] = inst_21503);

(statearr_21541_21654[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (70))){
var inst_21515 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21542_21655 = state_21539__$1;
(statearr_21542_21655[(2)] = inst_21515);

(statearr_21542_21655[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (62))){
var inst_21489 = (state_21539[(8)]);
var inst_21497 = cljs.core.second(inst_21489);
var inst_21498 = clojure.string.starts_with_QMARK_(inst_21497,"fullText:");
var state_21539__$1 = state_21539;
if(inst_21498){
var statearr_21543_21656 = state_21539__$1;
(statearr_21543_21656[(1)] = (65));

} else {
var statearr_21544_21657 = state_21539__$1;
(statearr_21544_21657[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (7))){
var inst_21408 = (state_21539[(9)]);
var inst_21407 = cljs.core.count(clause);
var inst_21408__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21407);
var state_21539__$1 = (function (){var statearr_21545 = state_21539;
(statearr_21545[(9)] = inst_21408__$1);

return statearr_21545;
})();
if(inst_21408__$1){
var statearr_21546_21658 = state_21539__$1;
(statearr_21546_21658[(1)] = (31));

} else {
var statearr_21547_21659 = state_21539__$1;
(statearr_21547_21659[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (59))){
var inst_21522 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21548_21660 = state_21539__$1;
(statearr_21548_21660[(2)] = inst_21522);

(statearr_21548_21660[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (20))){
var inst_21371 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21549_21661 = state_21539__$1;
(statearr_21549_21661[(2)] = inst_21371);

(statearr_21549_21661[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (58))){
var state_21539__$1 = state_21539;
var statearr_21550_21662 = state_21539__$1;
(statearr_21550_21662[(2)] = null);

(statearr_21550_21662[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (60))){
var inst_21488 = (state_21539[(7)]);
var inst_21486 = (state_21539[(2)]);
var inst_21487 = fluree.db.util.async.throw_err(inst_21486);
var inst_21488__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21487,(0),null);
var inst_21489 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21487,(1),null);
var inst_21490 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_21488__$1);
var state_21539__$1 = (function (){var statearr_21551 = state_21539;
(statearr_21551[(7)] = inst_21488__$1);

(statearr_21551[(8)] = inst_21489);

return statearr_21551;
})();
if(inst_21490){
var statearr_21552_21663 = state_21539__$1;
(statearr_21552_21663[(1)] = (61));

} else {
var statearr_21553_21664 = state_21539__$1;
(statearr_21553_21664[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (27))){
var inst_21401 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21554_21665 = state_21539__$1;
(statearr_21554_21665[(2)] = inst_21401);

(statearr_21554_21665[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (1))){
var state_21539__$1 = state_21539;
var statearr_21555_21666 = state_21539__$1;
(statearr_21555_21666[(2)] = null);

(statearr_21555_21666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (69))){
var state_21539__$1 = state_21539;
var statearr_21556_21667 = state_21539__$1;
(statearr_21556_21667[(2)] = null);

(statearr_21556_21667[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (24))){
var inst_21365 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21557_21668 = state_21539__$1;
(statearr_21557_21668[(2)] = inst_21365);

(statearr_21557_21668[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (55))){
var inst_21471 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21472 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21473 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21474 = cljs.core.PersistentHashMap.fromArrays(inst_21472,inst_21473);
var inst_21475 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21471,inst_21474);
var inst_21476 = (function(){throw inst_21475})();
var state_21539__$1 = state_21539;
var statearr_21558_21669 = state_21539__$1;
(statearr_21558_21669[(2)] = inst_21476);

(statearr_21558_21669[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (39))){
var inst_21428 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
if(cljs.core.truth_(inst_21428)){
var statearr_21559_21670 = state_21539__$1;
(statearr_21559_21670[(1)] = (40));

} else {
var statearr_21560_21671 = state_21539__$1;
(statearr_21560_21671[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (46))){
var inst_21528 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21561_21672 = state_21539__$1;
(statearr_21561_21672[(2)] = inst_21528);

(statearr_21561_21672[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (4))){
var inst_21303 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21562_21673 = state_21539__$1;
(statearr_21562_21673[(2)] = inst_21303);

(statearr_21562_21673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (54))){
var inst_21464 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21465 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21466 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21467 = cljs.core.PersistentHashMap.fromArrays(inst_21465,inst_21466);
var inst_21468 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21464,inst_21467);
var inst_21469 = (function(){throw inst_21468})();
var state_21539__$1 = state_21539;
var statearr_21563_21674 = state_21539__$1;
(statearr_21563_21674[(2)] = inst_21469);

(statearr_21563_21674[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (15))){
var inst_21403 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21564_21675 = state_21539__$1;
(statearr_21564_21675[(2)] = inst_21403);

(statearr_21564_21675[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (48))){
var inst_21452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21453 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_21454 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21453);
var inst_21455 = [inst_21454,r];
var inst_21456 = (new cljs.core.PersistentVector(null,2,(5),inst_21452,inst_21455,null));
var state_21539__$1 = state_21539;
var statearr_21565_21676 = state_21539__$1;
(statearr_21565_21676[(2)] = inst_21456);

(statearr_21565_21676[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (50))){
var inst_21526 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21566_21677 = state_21539__$1;
(statearr_21566_21677[(2)] = inst_21526);

(statearr_21566_21677[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (21))){
var inst_21349 = (state_21539[(10)]);
var inst_21348 = (state_21539[(11)]);
var inst_21339 = (state_21539[(12)]);
var inst_21316 = (state_21539[(13)]);
var inst_21337 = (state_21539[(14)]);
var inst_21312 = (state_21539[(15)]);
var inst_21340 = (state_21539[(16)]);
var inst_21342 = (state_21539[(17)]);
var inst_21341 = (state_21539[(18)]);
var inst_21353 = (state_21539[(2)]);
var inst_21354 = fluree.db.util.async.throw_err(inst_21353);
var inst_21355 = (function (){var seq__21345 = inst_21349;
var new_res = inst_21354;
var rest = inst_21349;
var pred__21313 = inst_21316;
var first__21346 = inst_21348;
var first__21336 = inst_21339;
var tuples = inst_21342;
var vec__21344 = inst_21341;
var seq__21335 = inst_21340;
var G__21333 = inst_21341;
var segment_type = inst_21312;
var vec__21334 = inst_21337;
var clause_group = inst_21348;
var expr__21314 = inst_21312;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21356 = cljs.core.keys(vars);
var inst_21357 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_21355,inst_21354,inst_21356);
var inst_21358 = fluree.db.query.analytical.res_absorb_vars(inst_21357);
var state_21539__$1 = (function (){var statearr_21567 = state_21539;
(statearr_21567[(19)] = inst_21358);

return statearr_21567;
})();
if(cljs.core.truth_(inst_21342)){
var statearr_21568_21678 = state_21539__$1;
(statearr_21568_21678[(1)] = (22));

} else {
var statearr_21569_21679 = state_21539__$1;
(statearr_21569_21679[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (31))){
var inst_21410 = cljs.core.second(clause);
var inst_21411 = clojure.string.starts_with_QMARK_(inst_21410,"fullText:");
var state_21539__$1 = state_21539;
var statearr_21570_21680 = state_21539__$1;
(statearr_21570_21680[(2)] = inst_21411);

(statearr_21570_21680[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (32))){
var inst_21408 = (state_21539[(9)]);
var state_21539__$1 = state_21539;
var statearr_21571_21681 = state_21539__$1;
(statearr_21571_21681[(2)] = inst_21408);

(statearr_21571_21681[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (40))){
var inst_21430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21431 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_21539__$1 = (function (){var statearr_21572 = state_21539;
(statearr_21572[(20)] = inst_21430);

return statearr_21572;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21539__$1,(43),inst_21431);
} else {
if((state_val_21540 === (56))){
var inst_21478 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21573_21682 = state_21539__$1;
(statearr_21573_21682[(2)] = inst_21478);

(statearr_21573_21682[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (33))){
var inst_21414 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
if(cljs.core.truth_(inst_21414)){
var statearr_21574_21683 = state_21539__$1;
(statearr_21574_21683[(1)] = (34));

} else {
var statearr_21575_21684 = state_21539__$1;
(statearr_21575_21684[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (13))){
var inst_21337 = (state_21539[(14)]);
var inst_21337__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21338 = cljs.core.seq(inst_21337__$1);
var inst_21339 = cljs.core.first(inst_21338);
var inst_21340 = cljs.core.next(inst_21338);
var inst_21341 = inst_21337__$1;
var inst_21342 = null;
var state_21539__$1 = (function (){var statearr_21576 = state_21539;
(statearr_21576[(12)] = inst_21339);

(statearr_21576[(14)] = inst_21337__$1);

(statearr_21576[(16)] = inst_21340);

(statearr_21576[(17)] = inst_21342);

(statearr_21576[(18)] = inst_21341);

return statearr_21576;
})();
var statearr_21577_21685 = state_21539__$1;
(statearr_21577_21685[(2)] = null);

(statearr_21577_21685[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (22))){
var inst_21349 = (state_21539[(10)]);
var inst_21358 = (state_21539[(19)]);
var inst_21342 = (state_21539[(17)]);
var inst_21360 = fluree.db.query.union.results(inst_21342,inst_21358);
var inst_21341 = inst_21349;
var inst_21342__$1 = inst_21360;
var state_21539__$1 = (function (){var statearr_21578 = state_21539;
(statearr_21578[(17)] = inst_21342__$1);

(statearr_21578[(18)] = inst_21341);

return statearr_21578;
})();
var statearr_21579_21686 = state_21539__$1;
(statearr_21579_21686[(2)] = null);

(statearr_21579_21686[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (36))){
var inst_21532 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21580_21687 = state_21539__$1;
(statearr_21580_21687[(2)] = inst_21532);

(statearr_21580_21687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (41))){
var inst_21438 = cljs.core.count(clause);
var inst_21439 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21438);
var state_21539__$1 = state_21539;
if(inst_21439){
var statearr_21581_21688 = state_21539__$1;
(statearr_21581_21688[(1)] = (44));

} else {
var statearr_21582_21689 = state_21539__$1;
(statearr_21582_21689[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (43))){
var inst_21430 = (state_21539[(20)]);
var inst_21433 = (state_21539[(2)]);
var inst_21434 = fluree.db.util.async.throw_err(inst_21433);
var inst_21435 = [inst_21434,r];
var inst_21436 = (new cljs.core.PersistentVector(null,2,(5),inst_21430,inst_21435,null));
var state_21539__$1 = state_21539;
var statearr_21583_21690 = state_21539__$1;
(statearr_21583_21690[(2)] = inst_21436);

(statearr_21583_21690[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (61))){
var inst_21489 = (state_21539[(8)]);
var inst_21492 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_21489,r,res,optional_QMARK_,fuel,max_fuel);
var state_21539__$1 = state_21539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21539__$1,(64),inst_21492);
} else {
if((state_val_21540 === (29))){
var inst_21312 = (state_21539[(15)]);
var inst_21395 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21312)].join('');
var inst_21396 = (new Error(inst_21395));
var inst_21397 = (function(){throw inst_21396})();
var state_21539__$1 = state_21539;
var statearr_21584_21691 = state_21539__$1;
(statearr_21584_21691[(2)] = inst_21397);

(statearr_21584_21691[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (44))){
var inst_21441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21442 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_21539__$1 = (function (){var statearr_21585 = state_21539;
(statearr_21585[(21)] = inst_21441);

return statearr_21585;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21539__$1,(47),inst_21442);
} else {
if((state_val_21540 === (6))){
var inst_21316 = (state_21539[(13)]);
var inst_21312 = (state_21539[(15)]);
var inst_21311 = cljs.core.keys(clause);
var inst_21312__$1 = cljs.core.first(inst_21311);
var inst_21316__$1 = cljs.core._EQ_;
var inst_21317 = (function (){var G__21586 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__21587 = inst_21312__$1;
return (inst_21316__$1.cljs$core$IFn$_invoke$arity$2 ? inst_21316__$1.cljs$core$IFn$_invoke$arity$2(G__21586,G__21587) : inst_21316__$1.call(null,G__21586,G__21587));
})();
var state_21539__$1 = (function (){var statearr_21588 = state_21539;
(statearr_21588[(13)] = inst_21316__$1);

(statearr_21588[(15)] = inst_21312__$1);

return statearr_21588;
})();
if(cljs.core.truth_(inst_21317)){
var statearr_21589_21692 = state_21539__$1;
(statearr_21589_21692[(1)] = (9));

} else {
var statearr_21590_21693 = state_21539__$1;
(statearr_21590_21693[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (28))){
var inst_21389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21390 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21391 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_21390,optional_QMARK_);
var inst_21392 = [inst_21391,r];
var inst_21393 = (new cljs.core.PersistentVector(null,2,(5),inst_21389,inst_21392,null));
var state_21539__$1 = state_21539;
var statearr_21591_21694 = state_21539__$1;
(statearr_21591_21694[(2)] = inst_21393);

(statearr_21591_21694[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (64))){
var inst_21494 = (state_21539[(2)]);
var inst_21495 = fluree.db.util.async.throw_err(inst_21494);
var state_21539__$1 = state_21539;
var statearr_21592_21695 = state_21539__$1;
(statearr_21592_21695[(2)] = inst_21495);

(statearr_21592_21695[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (51))){
var inst_21461 = cljs.core.first(clause);
var inst_21462 = cljs.core.sequential_QMARK_(inst_21461);
var state_21539__$1 = state_21539;
if(inst_21462){
var statearr_21593_21696 = state_21539__$1;
(statearr_21593_21696[(1)] = (54));

} else {
var statearr_21594_21697 = state_21539__$1;
(statearr_21594_21697[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (25))){
var inst_21316 = (state_21539[(13)]);
var inst_21312 = (state_21539[(15)]);
var inst_21377 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21378 = (function (){var segment_type = inst_21312;
var pred__21313 = inst_21316;
var expr__21314 = inst_21312;
var bindings = inst_21377;
return (function (p1__21298_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__21298_SHARP_);
});
})();
var inst_21379 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21378,inst_21377);
var inst_21380 = cljs.core.PersistentHashMap.EMPTY;
var inst_21381 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21380,inst_21379);
var inst_21382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21383 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21381);
var inst_21384 = [inst_21383,r];
var inst_21385 = (new cljs.core.PersistentVector(null,2,(5),inst_21382,inst_21384,null));
var state_21539__$1 = state_21539;
var statearr_21595_21698 = state_21539__$1;
(statearr_21595_21698[(2)] = inst_21385);

(statearr_21595_21698[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (34))){
var inst_21416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21417 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_21418 = [inst_21417,r];
var inst_21419 = (new cljs.core.PersistentVector(null,2,(5),inst_21416,inst_21418,null));
var state_21539__$1 = state_21539;
var statearr_21596_21699 = state_21539__$1;
(statearr_21596_21699[(2)] = inst_21419);

(statearr_21596_21699[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (17))){
var inst_21373 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21597_21700 = state_21539__$1;
(statearr_21597_21700[(2)] = inst_21373);

(statearr_21597_21700[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (3))){
var inst_21537 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21539__$1,inst_21537);
} else {
if((state_val_21540 === (12))){
var inst_21319 = (state_21539[(22)]);
var inst_21323 = (state_21539[(2)]);
var inst_21324 = fluree.db.util.async.throw_err(inst_21323);
var inst_21325 = [inst_21324,r];
var inst_21326 = (new cljs.core.PersistentVector(null,2,(5),inst_21319,inst_21325,null));
var state_21539__$1 = state_21539;
var statearr_21598_21701 = state_21539__$1;
(statearr_21598_21701[(2)] = inst_21326);

(statearr_21598_21701[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (2))){
var _ = (function (){var statearr_21599 = state_21539;
(statearr_21599[(4)] = cljs.core.cons((5),(state_21539[(4)])));

return statearr_21599;
})();
var inst_21309 = cljs.core.map_QMARK_(clause);
var state_21539__$1 = state_21539;
if(inst_21309){
var statearr_21600_21702 = state_21539__$1;
(statearr_21600_21702[(1)] = (6));

} else {
var statearr_21601_21703 = state_21539__$1;
(statearr_21601_21703[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (66))){
var state_21539__$1 = state_21539;
var statearr_21602_21704 = state_21539__$1;
(statearr_21602_21704[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (23))){
var inst_21349 = (state_21539[(10)]);
var inst_21358 = (state_21539[(19)]);
var inst_21341 = inst_21349;
var inst_21342 = inst_21358;
var state_21539__$1 = (function (){var statearr_21604 = state_21539;
(statearr_21604[(17)] = inst_21342);

(statearr_21604[(18)] = inst_21341);

return statearr_21604;
})();
var statearr_21605_21705 = state_21539__$1;
(statearr_21605_21705[(2)] = null);

(statearr_21605_21705[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (47))){
var inst_21441 = (state_21539[(21)]);
var inst_21444 = (state_21539[(2)]);
var inst_21445 = fluree.db.util.async.throw_err(inst_21444);
var inst_21446 = [inst_21445,r];
var inst_21447 = (new cljs.core.PersistentVector(null,2,(5),inst_21441,inst_21446,null));
var state_21539__$1 = state_21539;
var statearr_21606_21706 = state_21539__$1;
(statearr_21606_21706[(2)] = inst_21447);

(statearr_21606_21706[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (35))){
var inst_21422 = (state_21539[(23)]);
var inst_21421 = cljs.core.count(clause);
var inst_21422__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21421);
var state_21539__$1 = (function (){var statearr_21607 = state_21539;
(statearr_21607[(23)] = inst_21422__$1);

return statearr_21607;
})();
if(inst_21422__$1){
var statearr_21608_21707 = state_21539__$1;
(statearr_21608_21707[(1)] = (37));

} else {
var statearr_21609_21708 = state_21539__$1;
(statearr_21609_21708[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (19))){
var inst_21342 = (state_21539[(17)]);
var inst_21367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21368 = [inst_21342,r];
var inst_21369 = (new cljs.core.PersistentVector(null,2,(5),inst_21367,inst_21368,null));
var state_21539__$1 = state_21539;
var statearr_21610_21709 = state_21539__$1;
(statearr_21610_21709[(2)] = inst_21369);

(statearr_21610_21709[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (57))){
var inst_21484 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_21539__$1 = state_21539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21539__$1,(60),inst_21484);
} else {
if((state_val_21540 === (68))){
var inst_21488 = (state_21539[(7)]);
var inst_21489 = (state_21539[(8)]);
var inst_21506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21507 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_21488,res,inst_21489,fuel,max_fuel);
var state_21539__$1 = (function (){var statearr_21611 = state_21539;
(statearr_21611[(24)] = inst_21506);

return statearr_21611;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21539__$1,(71),inst_21507);
} else {
if((state_val_21540 === (11))){
var inst_21405 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21613_21710 = state_21539__$1;
(statearr_21613_21710[(2)] = inst_21405);

(statearr_21613_21710[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (9))){
var inst_21319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21320 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21321 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21320,res,fuel,max_fuel,opts);
var state_21539__$1 = (function (){var statearr_21614 = state_21539;
(statearr_21614[(22)] = inst_21319);

return statearr_21614;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21539__$1,(12),inst_21321);
} else {
if((state_val_21540 === (5))){
var _ = (function (){var statearr_21615 = state_21539;
(statearr_21615[(4)] = cljs.core.rest((state_21539[(4)])));

return statearr_21615;
})();
var state_21539__$1 = state_21539;
var ex21612 = (state_21539__$1[(2)]);
var statearr_21616_21711 = state_21539__$1;
(statearr_21616_21711[(5)] = ex21612);


if((ex21612 instanceof Error)){
var statearr_21617_21712 = state_21539__$1;
(statearr_21617_21712[(1)] = (4));

(statearr_21617_21712[(5)] = null);

} else {
throw ex21612;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (14))){
var inst_21316 = (state_21539[(13)]);
var inst_21312 = (state_21539[(15)]);
var inst_21375 = (function (){var G__21618 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__21619 = inst_21312;
return (inst_21316.cljs$core$IFn$_invoke$arity$2 ? inst_21316.cljs$core$IFn$_invoke$arity$2(G__21618,G__21619) : inst_21316.call(null,G__21618,G__21619));
})();
var state_21539__$1 = state_21539;
if(cljs.core.truth_(inst_21375)){
var statearr_21620_21713 = state_21539__$1;
(statearr_21620_21713[(1)] = (25));

} else {
var statearr_21621_21714 = state_21539__$1;
(statearr_21621_21714[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (45))){
var inst_21449 = cljs.core.count(clause);
var inst_21450 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21449);
var state_21539__$1 = state_21539;
if(inst_21450){
var statearr_21622_21715 = state_21539__$1;
(statearr_21622_21715[(1)] = (48));

} else {
var statearr_21623_21716 = state_21539__$1;
(statearr_21623_21716[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (53))){
var inst_21524 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21624_21717 = state_21539__$1;
(statearr_21624_21717[(2)] = inst_21524);

(statearr_21624_21717[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (26))){
var inst_21316 = (state_21539[(13)]);
var inst_21312 = (state_21539[(15)]);
var inst_21387 = (function (){var G__21625 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__21626 = inst_21312;
return (inst_21316.cljs$core$IFn$_invoke$arity$2 ? inst_21316.cljs$core$IFn$_invoke$arity$2(G__21625,G__21626) : inst_21316.call(null,G__21625,G__21626));
})();
var state_21539__$1 = state_21539;
if(cljs.core.truth_(inst_21387)){
var statearr_21627_21718 = state_21539__$1;
(statearr_21627_21718[(1)] = (28));

} else {
var statearr_21628_21719 = state_21539__$1;
(statearr_21628_21719[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (16))){
var inst_21348 = (state_21539[(11)]);
var inst_21341 = (state_21539[(18)]);
var inst_21347 = cljs.core.seq(inst_21341);
var inst_21348__$1 = cljs.core.first(inst_21347);
var inst_21349 = cljs.core.next(inst_21347);
var state_21539__$1 = (function (){var statearr_21629 = state_21539;
(statearr_21629[(10)] = inst_21349);

(statearr_21629[(11)] = inst_21348__$1);

return statearr_21629;
})();
if(cljs.core.truth_(inst_21348__$1)){
var statearr_21630_21720 = state_21539__$1;
(statearr_21630_21720[(1)] = (18));

} else {
var statearr_21631_21721 = state_21539__$1;
(statearr_21631_21721[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (38))){
var inst_21422 = (state_21539[(23)]);
var state_21539__$1 = state_21539;
var statearr_21632_21722 = state_21539__$1;
(statearr_21632_21722[(2)] = inst_21422);

(statearr_21632_21722[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (30))){
var inst_21399 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21633_21723 = state_21539__$1;
(statearr_21633_21723[(2)] = inst_21399);

(statearr_21633_21723[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (10))){
var inst_21316 = (state_21539[(13)]);
var inst_21312 = (state_21539[(15)]);
var inst_21328 = (function (){var G__21634 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__21635 = inst_21312;
return (inst_21316.cljs$core$IFn$_invoke$arity$2 ? inst_21316.cljs$core$IFn$_invoke$arity$2(G__21634,G__21635) : inst_21316.call(null,G__21634,G__21635));
})();
var state_21539__$1 = state_21539;
if(cljs.core.truth_(inst_21328)){
var statearr_21636_21724 = state_21539__$1;
(statearr_21636_21724[(1)] = (13));

} else {
var statearr_21637_21725 = state_21539__$1;
(statearr_21637_21725[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (18))){
var inst_21348 = (state_21539[(11)]);
var inst_21351 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21348,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21348,q_map,vars,fuel,max_fuel,opts));
var state_21539__$1 = state_21539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21539__$1,(21),inst_21351);
} else {
if((state_val_21540 === (52))){
var state_21539__$1 = state_21539;
var statearr_21638_21726 = state_21539__$1;
(statearr_21638_21726[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (67))){
var inst_21517 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21640_21727 = state_21539__$1;
(statearr_21640_21727[(2)] = inst_21517);

(statearr_21640_21727[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (71))){
var inst_21506 = (state_21539[(24)]);
var inst_21509 = (state_21539[(2)]);
var inst_21510 = fluree.db.util.async.throw_err(inst_21509);
var inst_21511 = [inst_21510,r];
var inst_21512 = (new cljs.core.PersistentVector(null,2,(5),inst_21506,inst_21511,null));
var state_21539__$1 = state_21539;
var statearr_21641_21728 = state_21539__$1;
(statearr_21641_21728[(2)] = inst_21512);

(statearr_21641_21728[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (42))){
var inst_21530 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21642_21729 = state_21539__$1;
(statearr_21642_21729[(2)] = inst_21530);

(statearr_21642_21729[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (37))){
var inst_21424 = cljs.core.second(clause);
var inst_21425 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21424,"rdf:type");
var state_21539__$1 = state_21539;
var statearr_21643_21730 = state_21539__$1;
(statearr_21643_21730[(2)] = inst_21425);

(statearr_21643_21730[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (63))){
var inst_21519 = (state_21539[(2)]);
var state_21539__$1 = state_21539;
var statearr_21644_21731 = state_21539__$1;
(statearr_21644_21731[(2)] = inst_21519);

(statearr_21644_21731[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (8))){
var inst_21534 = (state_21539[(2)]);
var _ = (function (){var statearr_21645 = state_21539;
(statearr_21645[(4)] = cljs.core.rest((state_21539[(4)])));

return statearr_21645;
})();
var state_21539__$1 = state_21539;
var statearr_21646_21732 = state_21539__$1;
(statearr_21646_21732[(2)] = inst_21534);

(statearr_21646_21732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21540 === (49))){
var inst_21458 = cljs.core.count(clause);
var inst_21459 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_21458);
var state_21539__$1 = state_21539;
if(inst_21459){
var statearr_21647_21733 = state_21539__$1;
(statearr_21647_21733[(1)] = (51));

} else {
var statearr_21648_21734 = state_21539__$1;
(statearr_21648_21734[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2741__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2741__auto____0 = (function (){
var statearr_21649 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21649[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2741__auto__);

(statearr_21649[(1)] = (1));

return statearr_21649;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2741__auto____1 = (function (state_21539){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_21539);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e21650){var ex__2744__auto__ = e21650;
var statearr_21651_21735 = state_21539;
(statearr_21651_21735[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_21539[(4)]))){
var statearr_21652_21736 = state_21539;
(statearr_21652_21736[(1)] = cljs.core.first((state_21539[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21737 = state_21539;
state_21539 = G__21737;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2741__auto__ = function(state_21539){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2741__auto____1.call(this,state_21539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2741__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2741__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_21653 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_21653[(6)] = c__2763__auto__);

return statearr_21653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21739 = arguments.length;
switch (G__21739) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_21819){
var state_val_21820 = (state_21819[(1)]);
if((state_val_21820 === (7))){
var inst_21814 = (state_21819[(2)]);
var _ = (function (){var statearr_21821 = state_21819;
(statearr_21821[(4)] = cljs.core.rest((state_21819[(4)])));

return statearr_21821;
})();
var state_21819__$1 = state_21819;
var statearr_21822_21870 = state_21819__$1;
(statearr_21822_21870[(2)] = inst_21814);

(statearr_21822_21870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (20))){
var inst_21779 = (state_21819[(7)]);
var inst_21791 = (state_21819[(2)]);
var inst_21761 = inst_21779;
var inst_21762 = inst_21791;
var state_21819__$1 = (function (){var statearr_21823 = state_21819;
(statearr_21823[(8)] = inst_21761);

(statearr_21823[(9)] = inst_21762);

return statearr_21823;
})();
var statearr_21824_21871 = state_21819__$1;
(statearr_21824_21871[(2)] = null);

(statearr_21824_21871[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (1))){
var state_21819__$1 = state_21819;
var statearr_21825_21872 = state_21819__$1;
(statearr_21825_21872[(2)] = null);

(statearr_21825_21872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (24))){
var inst_21762 = (state_21819[(9)]);
var inst_21778 = (state_21819[(10)]);
var inst_21779 = (state_21819[(7)]);
var inst_21799 = fluree.db.query.analytical.inner_join(inst_21762,inst_21778);
var inst_21761 = inst_21779;
var inst_21762__$1 = inst_21799;
var state_21819__$1 = (function (){var statearr_21826 = state_21819;
(statearr_21826[(8)] = inst_21761);

(statearr_21826[(9)] = inst_21762__$1);

return statearr_21826;
})();
var statearr_21827_21873 = state_21819__$1;
(statearr_21827_21873[(2)] = null);

(statearr_21827_21873[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (4))){
var inst_21740 = (state_21819[(2)]);
var state_21819__$1 = state_21819;
var statearr_21829_21874 = state_21819__$1;
(statearr_21829_21874[(2)] = inst_21740);

(statearr_21829_21874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (15))){
var inst_21778 = (state_21819[(10)]);
var state_21819__$1 = state_21819;
if(cljs.core.truth_(inst_21778)){
var statearr_21830_21875 = state_21819__$1;
(statearr_21830_21875[(1)] = (18));

} else {
var statearr_21831_21876 = state_21819__$1;
(statearr_21831_21876[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (21))){
var inst_21762 = (state_21819[(9)]);
var inst_21779 = (state_21819[(7)]);
var tmp21828 = inst_21762;
var inst_21761 = inst_21779;
var inst_21762__$1 = tmp21828;
var state_21819__$1 = (function (){var statearr_21832 = state_21819;
(statearr_21832[(8)] = inst_21761);

(statearr_21832[(9)] = inst_21762__$1);

return statearr_21832;
})();
var statearr_21833_21877 = state_21819__$1;
(statearr_21833_21877[(2)] = null);

(statearr_21833_21877[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (13))){
var inst_21762 = (state_21819[(9)]);
var inst_21785 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_21762,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21786 = cljs.core.empty_QMARK_(inst_21785);
var state_21819__$1 = state_21819;
if(inst_21786){
var statearr_21834_21878 = state_21819__$1;
(statearr_21834_21878[(1)] = (15));

} else {
var statearr_21835_21879 = state_21819__$1;
(statearr_21835_21879[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (22))){
var state_21819__$1 = state_21819;
var statearr_21836_21880 = state_21819__$1;
(statearr_21836_21880[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (6))){
var inst_21761 = (state_21819[(8)]);
var inst_21768 = (state_21819[(11)]);
var inst_21767 = cljs.core.seq(inst_21761);
var inst_21768__$1 = cljs.core.first(inst_21767);
var inst_21769 = cljs.core.next(inst_21767);
var state_21819__$1 = (function (){var statearr_21838 = state_21819;
(statearr_21838[(12)] = inst_21769);

(statearr_21838[(11)] = inst_21768__$1);

return statearr_21838;
})();
if(cljs.core.truth_(inst_21768__$1)){
var statearr_21839_21881 = state_21819__$1;
(statearr_21839_21881[(1)] = (8));

} else {
var statearr_21840_21882 = state_21819__$1;
(statearr_21840_21882[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (25))){
var state_21819__$1 = state_21819;
var statearr_21841_21883 = state_21819__$1;
(statearr_21841_21883[(2)] = null);

(statearr_21841_21883[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (17))){
var inst_21807 = (state_21819[(2)]);
var state_21819__$1 = state_21819;
var statearr_21842_21884 = state_21819__$1;
(statearr_21842_21884[(2)] = inst_21807);

(statearr_21842_21884[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (3))){
var inst_21817 = (state_21819[(2)]);
var state_21819__$1 = state_21819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21819__$1,inst_21817);
} else {
if((state_val_21820 === (12))){
var inst_21778 = (state_21819[(10)]);
var inst_21779 = (state_21819[(7)]);
var inst_21761 = inst_21779;
var inst_21762 = inst_21778;
var state_21819__$1 = (function (){var statearr_21843 = state_21819;
(statearr_21843[(8)] = inst_21761);

(statearr_21843[(9)] = inst_21762);

return statearr_21843;
})();
var statearr_21844_21885 = state_21819__$1;
(statearr_21844_21885[(2)] = null);

(statearr_21844_21885[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (2))){
var _ = (function (){var statearr_21845 = state_21819;
(statearr_21845[(4)] = cljs.core.cons((5),(state_21819[(4)])));

return statearr_21845;
})();
var inst_21753 = where;
var inst_21754 = cljs.core.seq(inst_21753);
var inst_21755 = cljs.core.first(inst_21754);
var inst_21756 = cljs.core.next(inst_21754);
var inst_21757 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21758 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_21759 = [inst_21758];
var inst_21760 = cljs.core.PersistentHashMap.fromArrays(inst_21757,inst_21759);
var inst_21761 = inst_21753;
var inst_21762 = inst_21760;
var state_21819__$1 = (function (){var statearr_21846 = state_21819;
(statearr_21846[(8)] = inst_21761);

(statearr_21846[(9)] = inst_21762);

(statearr_21846[(13)] = inst_21756);

(statearr_21846[(14)] = inst_21755);

return statearr_21846;
})();
var statearr_21847_21886 = state_21819__$1;
(statearr_21847_21886[(2)] = null);

(statearr_21847_21886[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (23))){
var inst_21805 = (state_21819[(2)]);
var state_21819__$1 = state_21819;
var statearr_21848_21887 = state_21819__$1;
(statearr_21848_21887[(2)] = inst_21805);

(statearr_21848_21887[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (19))){
var inst_21762 = (state_21819[(9)]);
var state_21819__$1 = state_21819;
var statearr_21849_21888 = state_21819__$1;
(statearr_21849_21888[(2)] = inst_21762);

(statearr_21849_21888[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (11))){
var inst_21768 = (state_21819[(11)]);
var inst_21776 = (state_21819[(2)]);
var inst_21777 = fluree.db.util.async.throw_err(inst_21776);
var inst_21778 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21777,(0),null);
var inst_21779 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21777,(1),null);
var inst_21780 = cljs.core.count(inst_21768);
var inst_21781 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21780);
var state_21819__$1 = (function (){var statearr_21851 = state_21819;
(statearr_21851[(10)] = inst_21778);

(statearr_21851[(7)] = inst_21779);

return statearr_21851;
})();
if(inst_21781){
var statearr_21852_21889 = state_21819__$1;
(statearr_21852_21889[(1)] = (12));

} else {
var statearr_21853_21890 = state_21819__$1;
(statearr_21853_21890[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (9))){
var inst_21762 = (state_21819[(9)]);
var state_21819__$1 = state_21819;
var statearr_21854_21891 = state_21819__$1;
(statearr_21854_21891[(2)] = inst_21762);

(statearr_21854_21891[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (5))){
var _ = (function (){var statearr_21855 = state_21819;
(statearr_21855[(4)] = cljs.core.rest((state_21819[(4)])));

return statearr_21855;
})();
var state_21819__$1 = state_21819;
var ex21850 = (state_21819__$1[(2)]);
var statearr_21856_21892 = state_21819__$1;
(statearr_21856_21892[(5)] = ex21850);


if((ex21850 instanceof Error)){
var statearr_21857_21893 = state_21819__$1;
(statearr_21857_21893[(1)] = (4));

(statearr_21857_21893[(5)] = null);

} else {
throw ex21850;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (14))){
var inst_21809 = (state_21819[(2)]);
var state_21819__$1 = state_21819;
var statearr_21858_21894 = state_21819__$1;
(statearr_21858_21894[(2)] = inst_21809);

(statearr_21858_21894[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (26))){
var inst_21803 = (state_21819[(2)]);
var state_21819__$1 = state_21819;
var statearr_21859_21895 = state_21819__$1;
(statearr_21859_21895[(2)] = inst_21803);

(statearr_21859_21895[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (16))){
var inst_21778 = (state_21819[(10)]);
var inst_21794 = (inst_21778 == null);
var state_21819__$1 = state_21819;
if(cljs.core.truth_(inst_21794)){
var statearr_21860_21896 = state_21819__$1;
(statearr_21860_21896[(1)] = (21));

} else {
var statearr_21861_21897 = state_21819__$1;
(statearr_21861_21897[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (10))){
var inst_21812 = (state_21819[(2)]);
var state_21819__$1 = state_21819;
var statearr_21862_21898 = state_21819__$1;
(statearr_21862_21898[(2)] = inst_21812);

(statearr_21862_21898[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (18))){
var inst_21778 = (state_21819[(10)]);
var state_21819__$1 = state_21819;
var statearr_21863_21899 = state_21819__$1;
(statearr_21863_21899[(2)] = inst_21778);

(statearr_21863_21899[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21820 === (8))){
var inst_21769 = (state_21819[(12)]);
var inst_21762 = (state_21819[(9)]);
var inst_21768 = (state_21819[(11)]);
var inst_21774 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_21762,inst_21768,inst_21769,false,fuel,max_fuel,opts);
var state_21819__$1 = state_21819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21819__$1,(11),inst_21774);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2741__auto__ = null;
var fluree$db$query$analytical$state_machine__2741__auto____0 = (function (){
var statearr_21864 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21864[(0)] = fluree$db$query$analytical$state_machine__2741__auto__);

(statearr_21864[(1)] = (1));

return statearr_21864;
});
var fluree$db$query$analytical$state_machine__2741__auto____1 = (function (state_21819){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_21819);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e21865){var ex__2744__auto__ = e21865;
var statearr_21866_21900 = state_21819;
(statearr_21866_21900[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_21819[(4)]))){
var statearr_21867_21901 = state_21819;
(statearr_21867_21901[(1)] = cljs.core.first((state_21819[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21902 = state_21819;
state_21819 = G__21902;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2741__auto__ = function(state_21819){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2741__auto____1.call(this,state_21819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2741__auto____0;
fluree$db$query$analytical$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2741__auto____1;
return fluree$db$query$analytical$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_21868 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_21868[(6)] = c__2763__auto__);

return statearr_21868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_21937){
var state_val_21938 = (state_21937[(1)]);
if((state_val_21938 === (7))){
var inst_21914 = (state_21937[(7)]);
var inst_21919 = (state_21937[(8)]);
var inst_21921 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21914,inst_21919,fuel,max_fuel,opts);
var state_21937__$1 = state_21937;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21937__$1,(10),inst_21921);
} else {
if((state_val_21938 === (1))){
var state_21937__$1 = state_21937;
var statearr_21939_21964 = state_21937__$1;
(statearr_21939_21964[(2)] = null);

(statearr_21939_21964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21938 === (4))){
var inst_21903 = (state_21937[(2)]);
var state_21937__$1 = state_21937;
var statearr_21940_21965 = state_21937__$1;
(statearr_21940_21965[(2)] = inst_21903);

(statearr_21940_21965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21938 === (13))){
var inst_21932 = (state_21937[(2)]);
var _ = (function (){var statearr_21941 = state_21937;
(statearr_21941[(4)] = cljs.core.rest((state_21937[(4)])));

return statearr_21941;
})();
var state_21937__$1 = state_21937;
var statearr_21942_21966 = state_21937__$1;
(statearr_21942_21966[(2)] = inst_21932);

(statearr_21942_21966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21938 === (6))){
var inst_21914 = (state_21937[(7)]);
var inst_21918 = (state_21937[(2)]);
var inst_21919 = fluree.db.util.async.throw_err(inst_21918);
var state_21937__$1 = (function (){var statearr_21943 = state_21937;
(statearr_21943[(8)] = inst_21919);

return statearr_21943;
})();
if(cljs.core.truth_(inst_21914)){
var statearr_21944_21967 = state_21937__$1;
(statearr_21944_21967[(1)] = (7));

} else {
var statearr_21945_21968 = state_21937__$1;
(statearr_21945_21968[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21938 === (3))){
var inst_21935 = (state_21937[(2)]);
var state_21937__$1 = state_21937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21937__$1,inst_21935);
} else {
if((state_val_21938 === (12))){
var inst_21927 = (state_21937[(9)]);
var state_21937__$1 = state_21937;
var statearr_21946_21969 = state_21937__$1;
(statearr_21946_21969[(2)] = inst_21927);

(statearr_21946_21969[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21938 === (2))){
var _ = (function (){var statearr_21947 = state_21937;
(statearr_21947[(4)] = cljs.core.cons((5),(state_21937[(4)])));

return statearr_21947;
})();
var inst_21910 = q_map;
var inst_21911 = cljs.core.__destructure_map(inst_21910);
var inst_21912 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21911,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21913 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21911,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21911,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21915 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21911,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21916 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21913,q_map,inst_21912,fuel,max_fuel,opts);
var state_21937__$1 = (function (){var statearr_21948 = state_21937;
(statearr_21948[(7)] = inst_21914);

(statearr_21948[(10)] = inst_21915);

return statearr_21948;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21937__$1,(6),inst_21916);
} else {
if((state_val_21938 === (11))){
var inst_21915 = (state_21937[(10)]);
var inst_21927 = (state_21937[(9)]);
var inst_21929 = fluree.db.query.analytical.tuples__GT_filtered(inst_21927,inst_21915,null);
var state_21937__$1 = state_21937;
var statearr_21950_21970 = state_21937__$1;
(statearr_21950_21970[(2)] = inst_21929);

(statearr_21950_21970[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21938 === (9))){
var inst_21915 = (state_21937[(10)]);
var inst_21927 = (state_21937[(2)]);
var state_21937__$1 = (function (){var statearr_21951 = state_21937;
(statearr_21951[(9)] = inst_21927);

return statearr_21951;
})();
if(cljs.core.truth_(inst_21915)){
var statearr_21952_21971 = state_21937__$1;
(statearr_21952_21971[(1)] = (11));

} else {
var statearr_21953_21972 = state_21937__$1;
(statearr_21953_21972[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21938 === (5))){
var _ = (function (){var statearr_21954 = state_21937;
(statearr_21954[(4)] = cljs.core.rest((state_21937[(4)])));

return statearr_21954;
})();
var state_21937__$1 = state_21937;
var ex21949 = (state_21937__$1[(2)]);
var statearr_21955_21973 = state_21937__$1;
(statearr_21955_21973[(5)] = ex21949);


if((ex21949 instanceof Error)){
var statearr_21956_21974 = state_21937__$1;
(statearr_21956_21974[(1)] = (4));

(statearr_21956_21974[(5)] = null);

} else {
throw ex21949;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21938 === (10))){
var inst_21923 = (state_21937[(2)]);
var inst_21924 = fluree.db.util.async.throw_err(inst_21923);
var state_21937__$1 = state_21937;
var statearr_21957_21975 = state_21937__$1;
(statearr_21957_21975[(2)] = inst_21924);

(statearr_21957_21975[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21938 === (8))){
var inst_21919 = (state_21937[(8)]);
var state_21937__$1 = state_21937;
var statearr_21958_21976 = state_21937__$1;
(statearr_21958_21976[(2)] = inst_21919);

(statearr_21958_21976[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2741__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2741__auto____0 = (function (){
var statearr_21959 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21959[(0)] = fluree$db$query$analytical$q_$_state_machine__2741__auto__);

(statearr_21959[(1)] = (1));

return statearr_21959;
});
var fluree$db$query$analytical$q_$_state_machine__2741__auto____1 = (function (state_21937){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_21937);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e21960){var ex__2744__auto__ = e21960;
var statearr_21961_21977 = state_21937;
(statearr_21961_21977[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_21937[(4)]))){
var statearr_21962_21978 = state_21937;
(statearr_21962_21978[(1)] = cljs.core.first((state_21937[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21979 = state_21937;
state_21937 = G__21979;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2741__auto__ = function(state_21937){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2741__auto____1.call(this,state_21937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2741__auto____0;
fluree$db$query$analytical$q_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2741__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_21963 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_21963[(6)] = c__2763__auto__);

return statearr_21963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
