// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41084 = arguments.length;
var i__4737__auto___41085 = (0);
while(true){
if((i__4737__auto___41085 < len__4736__auto___41084)){
args__4742__auto__.push((arguments[i__4737__auto___41085]));

var G__41086 = (i__4737__auto___41085 + (1));
i__4737__auto___41085 = G__41086;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq41081){
var G__41082 = cljs.core.first(seq41081);
var seq41081__$1 = cljs.core.next(seq41081);
var G__41083 = cljs.core.first(seq41081__$1);
var seq41081__$2 = cljs.core.next(seq41081__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41082,G__41083,seq41081__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e41087){var e = e41087;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e41088){var e = e41088;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e41089){var e = e41089;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e41090){var e = e41090;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e41091){var e = e41091;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41094 = arguments.length;
var i__4737__auto___41095 = (0);
while(true){
if((i__4737__auto___41095 < len__4736__auto___41094)){
args__4742__auto__.push((arguments[i__4737__auto___41095]));

var G__41096 = (i__4737__auto___41095 + (1));
i__4737__auto___41095 = G__41096;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e41093){var e = e41093;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq41092){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41092));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41099 = arguments.length;
var i__4737__auto___41100 = (0);
while(true){
if((i__4737__auto___41100 < len__4736__auto___41099)){
args__4742__auto__.push((arguments[i__4737__auto___41100]));

var G__41101 = (i__4737__auto___41100 + (1));
i__4737__auto___41100 = G__41101;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e41098){var e = e41098;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq41097){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41097));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e41102){var e = e41102;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41105 = arguments.length;
var i__4737__auto___41106 = (0);
while(true){
if((i__4737__auto___41106 < len__4736__auto___41105)){
args__4742__auto__.push((arguments[i__4737__auto___41106]));

var G__41107 = (i__4737__auto___41106 + (1));
i__4737__auto___41106 = G__41107;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e41104){var e = e41104;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq41103){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41103));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41110 = arguments.length;
var i__4737__auto___41111 = (0);
while(true){
if((i__4737__auto___41111 < len__4736__auto___41110)){
args__4742__auto__.push((arguments[i__4737__auto___41111]));

var G__41112 = (i__4737__auto___41111 + (1));
i__4737__auto___41111 = G__41112;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e41109){var e = e41109;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq41108){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41108));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e41113){var e = e41113;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e41114){var e = e41114;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41117 = arguments.length;
var i__4737__auto___41118 = (0);
while(true){
if((i__4737__auto___41118 < len__4736__auto___41117)){
args__4742__auto__.push((arguments[i__4737__auto___41118]));

var G__41119 = (i__4737__auto___41118 + (1));
i__4737__auto___41118 = G__41119;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e41116){var e = e41116;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq41115){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41115));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41122 = arguments.length;
var i__4737__auto___41123 = (0);
while(true){
if((i__4737__auto___41123 < len__4736__auto___41122)){
args__4742__auto__.push((arguments[i__4737__auto___41123]));

var G__41124 = (i__4737__auto___41123 + (1));
i__4737__auto___41123 = G__41124;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e41121){var e = e41121;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq41120){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41120));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41127 = arguments.length;
var i__4737__auto___41128 = (0);
while(true){
if((i__4737__auto___41128 < len__4736__auto___41127)){
args__4742__auto__.push((arguments[i__4737__auto___41128]));

var G__41129 = (i__4737__auto___41128 + (1));
i__4737__auto___41128 = G__41129;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e41126){var e = e41126;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq41125){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41125));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41132 = arguments.length;
var i__4737__auto___41133 = (0);
while(true){
if((i__4737__auto___41133 < len__4736__auto___41132)){
args__4742__auto__.push((arguments[i__4737__auto___41133]));

var G__41134 = (i__4737__auto___41133 + (1));
i__4737__auto___41133 = G__41134;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e41131){var e = e41131;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq41130){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41130));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41137 = arguments.length;
var i__4737__auto___41138 = (0);
while(true){
if((i__4737__auto___41138 < len__4736__auto___41137)){
args__4742__auto__.push((arguments[i__4737__auto___41138]));

var G__41139 = (i__4737__auto___41138 + (1));
i__4737__auto___41138 = G__41139;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e41136){var e = e41136;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq41135){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41135));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41142 = arguments.length;
var i__4737__auto___41143 = (0);
while(true){
if((i__4737__auto___41143 < len__4736__auto___41142)){
args__4742__auto__.push((arguments[i__4737__auto___41143]));

var G__41144 = (i__4737__auto___41143 + (1));
i__4737__auto___41143 = G__41144;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e41141){var e = e41141;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq41140){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41140));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41147 = arguments.length;
var i__4737__auto___41148 = (0);
while(true){
if((i__4737__auto___41148 < len__4736__auto___41147)){
args__4742__auto__.push((arguments[i__4737__auto___41148]));

var G__41149 = (i__4737__auto___41148 + (1));
i__4737__auto___41148 = G__41149;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e41146){var e = e41146;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq41145){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41145));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__41151 = arguments.length;
switch (G__41151) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41179){
var state_val_41180 = (state_41179[(1)]);
if((state_val_41180 === (7))){
var inst_41164 = (state_41179[(7)]);
var inst_41167 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41164,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_41179__$1 = state_41179;
var statearr_41181_41267 = state_41179__$1;
(statearr_41181_41267[(2)] = inst_41167);

(statearr_41181_41267[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41180 === (1))){
var state_41179__$1 = state_41179;
var statearr_41182_41268 = state_41179__$1;
(statearr_41182_41268[(2)] = null);

(statearr_41182_41268[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41180 === (4))){
var inst_41152 = (state_41179[(2)]);
var state_41179__$1 = state_41179;
var statearr_41183_41269 = state_41179__$1;
(statearr_41183_41269[(2)] = inst_41152);

(statearr_41183_41269[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41180 === (6))){
var inst_41164 = (state_41179[(7)]);
var inst_41164__$1 = (state_41179[(2)]);
var inst_41165 = fluree.db.util.core.exception_QMARK_(inst_41164__$1);
var state_41179__$1 = (function (){var statearr_41184 = state_41179;
(statearr_41184[(7)] = inst_41164__$1);

return statearr_41184;
})();
if(inst_41165){
var statearr_41185_41270 = state_41179__$1;
(statearr_41185_41270[(1)] = (7));

} else {
var statearr_41186_41271 = state_41179__$1;
(statearr_41186_41271[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41180 === (3))){
var inst_41177 = (state_41179[(2)]);
var state_41179__$1 = state_41179;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41179__$1,inst_41177);
} else {
if((state_val_41180 === (2))){
var inst_41158 = (state_41179[(8)]);
var _ = (function (){var statearr_41188 = state_41179;
(statearr_41188[(4)] = cljs.core.cons((5),(state_41179[(4)])));

return statearr_41188;
})();
var inst_41158__$1 = cljs.core.volatile_BANG_((0));
var inst_41159 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_41160 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_41159,cljs.core.cst$kw$fuel,inst_41158__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_41161 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_41160);
var inst_41162 = fluree.db.query.fql.query(db,inst_41161);
var state_41179__$1 = (function (){var statearr_41189 = state_41179;
(statearr_41189[(8)] = inst_41158__$1);

return statearr_41189;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41179__$1,(6),inst_41162);
} else {
if((state_val_41180 === (9))){
var inst_41174 = (state_41179[(2)]);
var _ = (function (){var statearr_41190 = state_41179;
(statearr_41190[(4)] = cljs.core.rest((state_41179[(4)])));

return statearr_41190;
})();
var state_41179__$1 = state_41179;
var statearr_41191_41272 = state_41179__$1;
(statearr_41191_41272[(2)] = inst_41174);

(statearr_41191_41272[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41180 === (5))){
var _ = (function (){var statearr_41192 = state_41179;
(statearr_41192[(4)] = cljs.core.rest((state_41179[(4)])));

return statearr_41192;
})();
var state_41179__$1 = state_41179;
var ex41187 = (state_41179__$1[(2)]);
var statearr_41193_41273 = state_41179__$1;
(statearr_41193_41273[(5)] = ex41187);


if((ex41187 instanceof Error)){
var statearr_41194_41274 = state_41179__$1;
(statearr_41194_41274[(1)] = (4));

(statearr_41194_41274[(5)] = null);

} else {
throw ex41187;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41180 === (8))){
var inst_41158 = (state_41179[(8)]);
var inst_41164 = (state_41179[(7)]);
var inst_41169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41170 = cljs.core.deref(inst_41158);
var inst_41171 = [inst_41164,inst_41170];
var inst_41172 = (new cljs.core.PersistentVector(null,2,(5),inst_41169,inst_41171,null));
var state_41179__$1 = state_41179;
var statearr_41195_41275 = state_41179__$1;
(statearr_41195_41275[(2)] = inst_41172);

(statearr_41195_41275[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16301__auto____0 = (function (){
var statearr_41196 = [null,null,null,null,null,null,null,null,null];
(statearr_41196[(0)] = fluree$db$dbfunctions$internal$state_machine__16301__auto__);

(statearr_41196[(1)] = (1));

return statearr_41196;
});
var fluree$db$dbfunctions$internal$state_machine__16301__auto____1 = (function (state_41179){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41179);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41197){var ex__16304__auto__ = e41197;
var statearr_41198_41276 = state_41179;
(statearr_41198_41276[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41179[(4)]))){
var statearr_41199_41277 = state_41179;
(statearr_41199_41277[(1)] = cljs.core.first((state_41179[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41278 = state_41179;
state_41179 = G__41278;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16301__auto__ = function(state_41179){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____1.call(this,state_41179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41200 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41200[(6)] = c__16375__auto__);

return statearr_41200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41245){
var state_val_41246 = (state_41245[(1)]);
if((state_val_41246 === (7))){
var inst_41231 = (state_41245[(2)]);
var inst_41232 = fluree.db.query.fql.query(db,inst_41231);
var state_41245__$1 = state_41245;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41245__$1,(8),inst_41232);
} else {
if((state_val_41246 === (1))){
var inst_41201 = typeof select === 'string';
var state_41245__$1 = state_41245;
if(cljs.core.truth_(inst_41201)){
var statearr_41247_41279 = state_41245__$1;
(statearr_41247_41279[(1)] = (2));

} else {
var statearr_41248_41280 = state_41245__$1;
(statearr_41248_41280[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (4))){
var inst_41207 = (state_41245[(7)]);
var inst_41214 = (state_41245[(8)]);
var inst_41206 = (state_41245[(2)]);
var inst_41207__$1 = cljs.core.volatile_BANG_((0));
var inst_41208 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_41209 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_41210 = [inst_41207__$1,(100000)];
var inst_41211 = cljs.core.PersistentHashMap.fromArrays(inst_41209,inst_41210);
var inst_41212 = [inst_41206,from,where,block,limit,inst_41211];
var inst_41213 = cljs.core.PersistentHashMap.fromArrays(inst_41208,inst_41212);
var inst_41214__$1 = fluree.db.util.core.without_nils(inst_41213);
var inst_41215 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_41214__$1);
var inst_41216 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_41214__$1);
var inst_41217 = cljs.core.first(inst_41216);
var inst_41218 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41217], 0));
var inst_41219 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_41218);
var inst_41220 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_41214__$1);
var inst_41221 = cljs.core.last(inst_41220);
var inst_41222 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41221], 0));
var inst_41223 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_41222);
var inst_41224 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41215,inst_41219,inst_41223], 0));
var state_41245__$1 = (function (){var statearr_41249 = state_41245;
(statearr_41249[(7)] = inst_41207__$1);

(statearr_41249[(8)] = inst_41214__$1);

return statearr_41249;
})();
if(cljs.core.truth_(inst_41224)){
var statearr_41250_41281 = state_41245__$1;
(statearr_41250_41281[(1)] = (5));

} else {
var statearr_41251_41282 = state_41245__$1;
(statearr_41251_41282[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (6))){
var inst_41214 = (state_41245[(8)]);
var state_41245__$1 = state_41245;
var statearr_41252_41283 = state_41245__$1;
(statearr_41252_41283[(2)] = inst_41214);

(statearr_41252_41283[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (3))){
var state_41245__$1 = state_41245;
var statearr_41253_41284 = state_41245__$1;
(statearr_41253_41284[(2)] = select);

(statearr_41253_41284[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (2))){
var inst_41203 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_41245__$1 = state_41245;
var statearr_41254_41285 = state_41245__$1;
(statearr_41254_41285[(2)] = inst_41203);

(statearr_41254_41285[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (11))){
var inst_41243 = (state_41245[(2)]);
var state_41245__$1 = state_41245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41245__$1,inst_41243);
} else {
if((state_val_41246 === (9))){
var inst_41234 = (state_41245[(9)]);
var state_41245__$1 = state_41245;
var statearr_41255_41286 = state_41245__$1;
(statearr_41255_41286[(2)] = inst_41234);

(statearr_41255_41286[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (5))){
var inst_41214 = (state_41245[(8)]);
var inst_41226 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_41214);
var inst_41227 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_41226);
var inst_41228 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41214,cljs.core.cst$kw$where,inst_41227);
var state_41245__$1 = state_41245;
var statearr_41256_41287 = state_41245__$1;
(statearr_41256_41287[(2)] = inst_41228);

(statearr_41256_41287[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (10))){
var inst_41207 = (state_41245[(7)]);
var inst_41234 = (state_41245[(9)]);
var inst_41238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41239 = cljs.core.deref(inst_41207);
var inst_41240 = [inst_41234,inst_41239];
var inst_41241 = (new cljs.core.PersistentVector(null,2,(5),inst_41238,inst_41240,null));
var state_41245__$1 = state_41245;
var statearr_41257_41288 = state_41245__$1;
(statearr_41257_41288[(2)] = inst_41241);

(statearr_41257_41288[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (8))){
var inst_41234 = (state_41245[(9)]);
var inst_41234__$1 = (state_41245[(2)]);
var inst_41235 = fluree.db.util.core.exception_QMARK_(inst_41234__$1);
var state_41245__$1 = (function (){var statearr_41258 = state_41245;
(statearr_41258[(9)] = inst_41234__$1);

return statearr_41258;
})();
if(inst_41235){
var statearr_41259_41289 = state_41245__$1;
(statearr_41259_41289[(1)] = (9));

} else {
var statearr_41260_41290 = state_41245__$1;
(statearr_41260_41290[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16301__auto____0 = (function (){
var statearr_41261 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41261[(0)] = fluree$db$dbfunctions$internal$state_machine__16301__auto__);

(statearr_41261[(1)] = (1));

return statearr_41261;
});
var fluree$db$dbfunctions$internal$state_machine__16301__auto____1 = (function (state_41245){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41245);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41262){var ex__16304__auto__ = e41262;
var statearr_41263_41291 = state_41245;
(statearr_41263_41291[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41245[(4)]))){
var statearr_41264_41292 = state_41245;
(statearr_41264_41292[(1)] = cljs.core.first((state_41245[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41293 = state_41245;
state_41245 = G__41293;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16301__auto__ = function(state_41245){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____1.call(this,state_41245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41265 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41265[(6)] = c__16375__auto__);

return statearr_41265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__41297 = path;
var vec__41298 = G__41297;
var seq__41299 = cljs.core.seq(vec__41298);
var first__41300 = cljs.core.first(seq__41299);
var seq__41299__$1 = cljs.core.next(seq__41299);
var var$ = first__41300;
var r = seq__41299__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__41297__$1 = G__41297;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__41304 = G__41297__$1;
var seq__41305 = cljs.core.seq(vec__41304);
var first__41306 = cljs.core.first(seq__41305);
var seq__41305__$1 = cljs.core.next(seq__41305);
var var$__$1 = first__41306;
var r__$1 = seq__41305__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__41307 = r__$1;
var G__41308 = n__$2;
var G__41309 = next_clauses;
G__41297__$1 = G__41307;
n__$1 = G__41308;
where_clauses__$1 = G__41309;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__41310 = r__$1;
var G__41311 = next_n;
var G__41312 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__41297__$1 = G__41310;
n__$1 = G__41311;
where_clauses__$1 = G__41312;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41349){
var state_val_41350 = (state_41349[(1)]);
if((state_val_41350 === (7))){
var inst_41322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41323 = [path];
var inst_41324 = (new cljs.core.PersistentVector(null,1,(5),inst_41322,inst_41323,null));
var state_41349__$1 = state_41349;
var statearr_41351_41379 = state_41349__$1;
(statearr_41351_41379[(2)] = inst_41324);

(statearr_41351_41379[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41350 === (1))){
var state_41349__$1 = state_41349;
var statearr_41352_41380 = state_41349__$1;
(statearr_41352_41380[(2)] = null);

(statearr_41352_41380[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41350 === (4))){
var inst_41313 = (state_41349[(2)]);
var state_41349__$1 = state_41349;
var statearr_41353_41381 = state_41349__$1;
(statearr_41353_41381[(2)] = inst_41313);

(statearr_41353_41381[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41350 === (13))){
var inst_41340 = (state_41349[(2)]);
var inst_41341 = fluree.db.util.async.throw_err(inst_41340);
var _ = (function (){var statearr_41354 = state_41349;
(statearr_41354[(4)] = cljs.core.rest((state_41349[(4)])));

return statearr_41354;
})();
var state_41349__$1 = state_41349;
var statearr_41355_41382 = state_41349__$1;
(statearr_41355_41382[(2)] = inst_41341);

(statearr_41355_41382[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41350 === (6))){
var state_41349__$1 = state_41349;
var statearr_41357_41383 = state_41349__$1;
(statearr_41357_41383[(2)] = path);

(statearr_41357_41383[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41350 === (3))){
var inst_41347 = (state_41349[(2)]);
var state_41349__$1 = state_41349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41349__$1,inst_41347);
} else {
if((state_val_41350 === (12))){
var _ = (function (){var statearr_41358 = state_41349;
(statearr_41358[(4)] = cljs.core.rest((state_41349[(4)])));

return statearr_41358;
})();
var state_41349__$1 = state_41349;
var ex41356 = (state_41349__$1[(2)]);
var statearr_41359_41384 = state_41349__$1;
(statearr_41359_41384[(5)] = ex41356);


var statearr_41360_41385 = state_41349__$1;
(statearr_41360_41385[(1)] = (11));

(statearr_41360_41385[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41350 === (2))){
var _ = (function (){var statearr_41361 = state_41349;
(statearr_41361[(4)] = cljs.core.cons((5),(state_41349[(4)])));

return statearr_41361;
})();
var inst_41319 = cljs.core.vector_QMARK_(path);
var state_41349__$1 = state_41349;
if(inst_41319){
var statearr_41362_41386 = state_41349__$1;
(statearr_41362_41386[(1)] = (6));

} else {
var statearr_41363_41387 = state_41349__$1;
(statearr_41363_41387[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41350 === (11))){
var inst_41326 = (state_41349[(7)]);
var inst_41331 = (state_41349[(2)]);
var inst_41332 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41331,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_41326,endSubject], 0));
var state_41349__$1 = state_41349;
var statearr_41365_41388 = state_41349__$1;
(statearr_41365_41388[(2)] = inst_41332);

(statearr_41365_41388[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41350 === (9))){
var inst_41330 = (state_41349[(8)]);
var _ = (function (){var statearr_41366 = state_41349;
(statearr_41366[(4)] = cljs.core.cons((12),(state_41349[(4)])));

return statearr_41366;
})();
var inst_41338 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_41330);
var state_41349__$1 = state_41349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41349__$1,(13),inst_41338);
} else {
if((state_val_41350 === (5))){
var _ = (function (){var statearr_41367 = state_41349;
(statearr_41367[(4)] = cljs.core.rest((state_41349[(4)])));

return statearr_41367;
})();
var state_41349__$1 = state_41349;
var ex41364 = (state_41349__$1[(2)]);
var statearr_41368_41389 = state_41349__$1;
(statearr_41368_41389[(5)] = ex41364);


if((ex41364 instanceof Error)){
var statearr_41369_41390 = state_41349__$1;
(statearr_41369_41390[(1)] = (4));

(statearr_41369_41390[(5)] = null);

} else {
throw ex41364;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41350 === (10))){
var inst_41344 = (state_41349[(2)]);
var _ = (function (){var statearr_41370 = state_41349;
(statearr_41370[(4)] = cljs.core.rest((state_41349[(4)])));

return statearr_41370;
})();
var state_41349__$1 = state_41349;
var statearr_41371_41391 = state_41349__$1;
(statearr_41371_41391[(2)] = inst_41344);

(statearr_41371_41391[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41350 === (8))){
var inst_41326 = (state_41349[(7)]);
var inst_41326__$1 = (state_41349[(2)]);
var inst_41327 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_41326__$1,endSubject);
var inst_41328 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_41329 = ["?var1",inst_41327];
var inst_41330 = cljs.core.PersistentHashMap.fromArrays(inst_41328,inst_41329);
var state_41349__$1 = (function (){var statearr_41372 = state_41349;
(statearr_41372[(7)] = inst_41326__$1);

(statearr_41372[(8)] = inst_41330);

return statearr_41372;
})();
var statearr_41373_41392 = state_41349__$1;
(statearr_41373_41392[(2)] = null);

(statearr_41373_41392[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____0 = (function (){
var statearr_41374 = [null,null,null,null,null,null,null,null,null];
(statearr_41374[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__);

(statearr_41374[(1)] = (1));

return statearr_41374;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____1 = (function (state_41349){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41349);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41375){var ex__16304__auto__ = e41375;
var statearr_41376_41393 = state_41349;
(statearr_41376_41393[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41349[(4)]))){
var statearr_41377_41394 = state_41349;
(statearr_41377_41394[(1)] = cljs.core.first((state_41349[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41395 = state_41349;
state_41349 = G__41395;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__ = function(state_41349){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____1.call(this,state_41349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41378 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41378[(6)] = c__16375__auto__);

return statearr_41378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e41396){var e = e41396;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e41397){var e = e41397;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e41398){var e = e41398;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e41399){var e = e41399;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41402 = arguments.length;
var i__4737__auto___41403 = (0);
while(true){
if((i__4737__auto___41403 < len__4736__auto___41402)){
args__4742__auto__.push((arguments[i__4737__auto___41403]));

var G__41404 = (i__4737__auto___41403 + (1));
i__4737__auto___41403 = G__41404;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e41401){var e = e41401;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq41400){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41400));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41407 = arguments.length;
var i__4737__auto___41408 = (0);
while(true){
if((i__4737__auto___41408 < len__4736__auto___41407)){
args__4742__auto__.push((arguments[i__4737__auto___41408]));

var G__41409 = (i__4737__auto___41408 + (1));
i__4737__auto___41408 = G__41409;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e41406){var e = e41406;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq41405){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41405));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41412 = arguments.length;
var i__4737__auto___41413 = (0);
while(true){
if((i__4737__auto___41413 < len__4736__auto___41412)){
args__4742__auto__.push((arguments[i__4737__auto___41413]));

var G__41414 = (i__4737__auto___41413 + (1));
i__4737__auto___41413 = G__41414;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e41411){var e = e41411;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq41410){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41410));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41417 = arguments.length;
var i__4737__auto___41418 = (0);
while(true){
if((i__4737__auto___41418 < len__4736__auto___41417)){
args__4742__auto__.push((arguments[i__4737__auto___41418]));

var G__41419 = (i__4737__auto___41418 + (1));
i__4737__auto___41418 = G__41419;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e41416){var e = e41416;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq41415){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41415));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e41420){var e = e41420;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e41421){var e = e41421;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e41422){var e = e41422;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e41423){var e = e41423;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e41424){var e = e41424;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__41430 = path;
var vec__41431 = G__41430;
var seq__41432 = cljs.core.seq(vec__41431);
var first__41433 = cljs.core.first(seq__41432);
var seq__41432__$1 = cljs.core.next(seq__41432);
var pred = first__41433;
var r = seq__41432__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__41430__$1 = G__41430;
var subjects__$1 = subjects;
while(true){
var vec__41437 = G__41430__$1;
var seq__41438 = cljs.core.seq(vec__41437);
var first__41439 = cljs.core.first(seq__41438);
var seq__41438__$1 = cljs.core.next(seq__41438);
var pred__$1 = first__41439;
var r__$1 = seq__41438__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__41430__$1,subjects__$1,vec__41437,seq__41438,first__41439,seq__41438__$1,pred__$1,r__$1,subjects__$2,G__41430,vec__41431,seq__41432,first__41433,seq__41432__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__41430__$1,subjects__$1,vec__41437,seq__41438,first__41439,seq__41438__$1,pred__$1,r__$1,subjects__$2,G__41430,vec__41431,seq__41432,first__41433,seq__41432__$1,pred,r,subjects){
return (function (p1__41425_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__41425_SHARP_,pred__$1);
});})(G__41430__$1,subjects__$1,vec__41437,seq__41438,first__41439,seq__41438__$1,pred__$1,r__$1,subjects__$2,G__41430,vec__41431,seq__41432,first__41433,seq__41432__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__41430__$1,subjects__$1,vec__41437,seq__41438,first__41439,seq__41438__$1,pred__$1,r__$1,subjects__$2,G__41430,vec__41431,seq__41432,first__41433,seq__41432__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__41440 = r__$1;
var G__41441 = next_subjects;
G__41430__$1 = G__41440;
subjects__$1 = G__41441;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e41426){var e = e41426;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e41442){var e = e41442;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e41443){var e = e41443;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41446 = arguments.length;
var i__4737__auto___41447 = (0);
while(true){
if((i__4737__auto___41447 < len__4736__auto___41446)){
args__4742__auto__.push((arguments[i__4737__auto___41447]));

var G__41448 = (i__4737__auto___41447 + (1));
i__4737__auto___41447 = G__41448;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e41445){var e = e41445;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq41444){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41444));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e41449){var e = e41449;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41452 = arguments.length;
var i__4737__auto___41453 = (0);
while(true){
if((i__4737__auto___41453 < len__4736__auto___41452)){
args__4742__auto__.push((arguments[i__4737__auto___41453]));

var G__41454 = (i__4737__auto___41453 + (1));
i__4737__auto___41453 = G__41454;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e41451){var e = e41451;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq41450){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41450));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e41455){var e = e41455;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41510){
var state_val_41511 = (state_41510[(1)]);
if((state_val_41511 === (7))){
var inst_41457 = (state_41510[(2)]);
var state_41510__$1 = state_41510;
var statearr_41512_41545 = state_41510__$1;
(statearr_41512_41545[(2)] = inst_41457);

(statearr_41512_41545[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (1))){
var state_41510__$1 = state_41510;
var statearr_41513_41546 = state_41510__$1;
(statearr_41513_41546[(2)] = null);

(statearr_41513_41546[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (4))){
var inst_41456 = (state_41510[(2)]);
var state_41510__$1 = (function (){var statearr_41514 = state_41510;
(statearr_41514[(7)] = inst_41456);

return statearr_41514;
})();
var statearr_41515_41547 = state_41510__$1;
(statearr_41515_41547[(2)] = null);

(statearr_41515_41547[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (15))){
var inst_41494 = (state_41510[(8)]);
var inst_41498 = inst_41494.o;
var state_41510__$1 = state_41510;
var statearr_41516_41548 = state_41510__$1;
(statearr_41516_41548[(2)] = inst_41498);

(statearr_41516_41548[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (13))){
var inst_41494 = (state_41510[(8)]);
var inst_41490 = (state_41510[(2)]);
var inst_41491 = fluree.db.util.async.throw_err(inst_41490);
var inst_41492 = fluree.db.dbfunctions.internal.count(inst_41491);
var inst_41494__$1 = cljs.core.first(inst_41491);
var inst_41495 = (inst_41494__$1 == null);
var state_41510__$1 = (function (){var statearr_41517 = state_41510;
(statearr_41517[(8)] = inst_41494__$1);

(statearr_41517[(9)] = inst_41492);

return statearr_41517;
})();
if(cljs.core.truth_(inst_41495)){
var statearr_41518_41549 = state_41510__$1;
(statearr_41518_41549[(1)] = (14));

} else {
var statearr_41519_41550 = state_41510__$1;
(statearr_41519_41550[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (6))){
var inst_41466 = (state_41510[(2)]);
var state_41510__$1 = state_41510;
var statearr_41520_41551 = state_41510__$1;
(statearr_41520_41551[(2)] = inst_41466);

(statearr_41520_41551[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (3))){
var inst_41508 = (state_41510[(2)]);
var state_41510__$1 = state_41510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41510__$1,inst_41508);
} else {
if((state_val_41511 === (12))){
var inst_41505 = (state_41510[(2)]);
var _ = (function (){var statearr_41521 = state_41510;
(statearr_41521[(4)] = cljs.core.rest((state_41510[(4)])));

return statearr_41521;
})();
var state_41510__$1 = state_41510;
var statearr_41522_41552 = state_41510__$1;
(statearr_41522_41552[(2)] = inst_41505);

(statearr_41522_41552[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (2))){
var _ = (function (){var statearr_41524 = state_41510;
(statearr_41524[(4)] = cljs.core.cons((9),(state_41510[(4)])));

return statearr_41524;
})();
var inst_41472 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41473 = typeof inst_41472 === 'string';
var state_41510__$1 = state_41510;
if(cljs.core.truth_(inst_41473)){
var statearr_41525_41553 = state_41510__$1;
(statearr_41525_41553[(1)] = (10));

} else {
var statearr_41526_41554 = state_41510__$1;
(statearr_41526_41554[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (11))){
var inst_41479 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41480 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_41479);
var inst_41481 = fluree.db.dbfunctions.internal.inc(inst_41480);
var inst_41482 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41479,cljs.core.cst$kw$t,inst_41481);
var inst_41483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41484 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41485 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41486 = [inst_41484,inst_41485];
var inst_41487 = (new cljs.core.PersistentVector(null,2,(5),inst_41483,inst_41486,null));
var inst_41488 = fluree.db.dbproto._search(inst_41482,inst_41487);
var state_41510__$1 = state_41510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41510__$1,(13),inst_41488);
} else {
if((state_val_41511 === (9))){
var _ = (function (){var statearr_41527 = state_41510;
(statearr_41527[(4)] = cljs.core.rest((state_41510[(4)])));

return statearr_41527;
})();
var state_41510__$1 = state_41510;
var ex41523 = (state_41510__$1[(2)]);
var statearr_41528_41555 = state_41510__$1;
(statearr_41528_41555[(5)] = ex41523);


var statearr_41529_41556 = state_41510__$1;
(statearr_41529_41556[(1)] = (4));

(statearr_41529_41556[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (5))){
var inst_41456 = (state_41510[(7)]);
var _ = (function (){var statearr_41530 = state_41510;
(statearr_41530[(4)] = cljs.core.cons((8),(state_41510[(4)])));

return statearr_41530;
})();
var inst_41463 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41456,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_41531 = state_41510;
(statearr_41531[(4)] = cljs.core.rest((state_41510[(4)])));

return statearr_41531;
})();
var state_41510__$1 = state_41510;
var statearr_41532_41557 = state_41510__$1;
(statearr_41532_41557[(2)] = inst_41463);

(statearr_41532_41557[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (14))){
var state_41510__$1 = state_41510;
var statearr_41533_41558 = state_41510__$1;
(statearr_41533_41558[(2)] = null);

(statearr_41533_41558[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (16))){
var inst_41492 = (state_41510[(9)]);
var inst_41500 = (state_41510[(2)]);
var inst_41501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41502 = [inst_41500,inst_41492];
var inst_41503 = (new cljs.core.PersistentVector(null,2,(5),inst_41501,inst_41502,null));
var state_41510__$1 = state_41510;
var statearr_41535_41559 = state_41510__$1;
(statearr_41535_41559[(2)] = inst_41503);

(statearr_41535_41559[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (10))){
var inst_41475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41476 = [null,(0)];
var inst_41477 = (new cljs.core.PersistentVector(null,2,(5),inst_41475,inst_41476,null));
var state_41510__$1 = state_41510;
var statearr_41536_41560 = state_41510__$1;
(statearr_41536_41560[(2)] = inst_41477);

(statearr_41536_41560[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (8))){
var _ = (function (){var statearr_41537 = state_41510;
(statearr_41537[(4)] = cljs.core.rest((state_41510[(4)])));

return statearr_41537;
})();
var state_41510__$1 = state_41510;
var ex41534 = (state_41510__$1[(2)]);
var statearr_41538_41561 = state_41510__$1;
(statearr_41538_41561[(5)] = ex41534);


var statearr_41539_41562 = state_41510__$1;
(statearr_41539_41562[(1)] = (7));

(statearr_41539_41562[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____0 = (function (){
var statearr_41540 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41540[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__);

(statearr_41540[(1)] = (1));

return statearr_41540;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____1 = (function (state_41510){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41510);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41541){var ex__16304__auto__ = e41541;
var statearr_41542_41563 = state_41510;
(statearr_41542_41563[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41510[(4)]))){
var statearr_41543_41564 = state_41510;
(statearr_41543_41564[(1)] = cljs.core.first((state_41510[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41565 = state_41510;
state_41510 = G__41565;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__ = function(state_41510){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____1.call(this,state_41510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41544 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41544[(6)] = c__16375__auto__);

return statearr_41544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41617){
var state_val_41618 = (state_41617[(1)]);
if((state_val_41618 === (7))){
var inst_41567 = (state_41617[(2)]);
var state_41617__$1 = state_41617;
var statearr_41619_41648 = state_41617__$1;
(statearr_41619_41648[(2)] = inst_41567);

(statearr_41619_41648[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41618 === (1))){
var state_41617__$1 = state_41617;
var statearr_41620_41649 = state_41617__$1;
(statearr_41620_41649[(2)] = null);

(statearr_41620_41649[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41618 === (4))){
var inst_41566 = (state_41617[(2)]);
var state_41617__$1 = (function (){var statearr_41621 = state_41617;
(statearr_41621[(7)] = inst_41566);

return statearr_41621;
})();
var statearr_41622_41650 = state_41617__$1;
(statearr_41622_41650[(2)] = null);

(statearr_41622_41650[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41618 === (13))){
var inst_41612 = (state_41617[(2)]);
var _ = (function (){var statearr_41623 = state_41617;
(statearr_41623[(4)] = cljs.core.rest((state_41617[(4)])));

return statearr_41623;
})();
var state_41617__$1 = state_41617;
var statearr_41624_41651 = state_41617__$1;
(statearr_41624_41651[(2)] = inst_41612);

(statearr_41624_41651[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41618 === (6))){
var inst_41576 = (state_41617[(2)]);
var state_41617__$1 = state_41617;
var statearr_41625_41652 = state_41617__$1;
(statearr_41625_41652[(2)] = inst_41576);

(statearr_41625_41652[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41618 === (3))){
var inst_41615 = (state_41617[(2)]);
var state_41617__$1 = state_41617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41617__$1,inst_41615);
} else {
if((state_val_41618 === (12))){
var inst_41599 = (state_41617[(8)]);
var inst_41608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41609 = [null,inst_41599];
var inst_41610 = (new cljs.core.PersistentVector(null,2,(5),inst_41608,inst_41609,null));
var state_41617__$1 = state_41617;
var statearr_41626_41653 = state_41617__$1;
(statearr_41626_41653[(2)] = inst_41610);

(statearr_41626_41653[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41618 === (2))){
var _ = (function (){var statearr_41628 = state_41617;
(statearr_41628[(4)] = cljs.core.cons((9),(state_41617[(4)])));

return statearr_41628;
})();
var inst_41585 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_41586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41588 = [null,pred_name,"?o"];
var inst_41589 = (new cljs.core.PersistentVector(null,3,(5),inst_41587,inst_41588,null));
var inst_41590 = [inst_41589];
var inst_41591 = (new cljs.core.PersistentVector(null,1,(5),inst_41586,inst_41590,null));
var inst_41592 = ["?o",inst_41591,opts];
var inst_41593 = cljs.core.PersistentHashMap.fromArrays(inst_41585,inst_41592);
var inst_41594 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_41593);
var state_41617__$1 = state_41617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41617__$1,(10),inst_41594);
} else {
if((state_val_41618 === (11))){
var inst_41598 = (state_41617[(9)]);
var inst_41599 = (state_41617[(8)]);
var inst_41603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41604 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_41598);
var inst_41605 = [inst_41604,inst_41599];
var inst_41606 = (new cljs.core.PersistentVector(null,2,(5),inst_41603,inst_41605,null));
var state_41617__$1 = state_41617;
var statearr_41629_41654 = state_41617__$1;
(statearr_41629_41654[(2)] = inst_41606);

(statearr_41629_41654[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41618 === (9))){
var _ = (function (){var statearr_41630 = state_41617;
(statearr_41630[(4)] = cljs.core.rest((state_41617[(4)])));

return statearr_41630;
})();
var state_41617__$1 = state_41617;
var ex41627 = (state_41617__$1[(2)]);
var statearr_41631_41655 = state_41617__$1;
(statearr_41631_41655[(5)] = ex41627);


var statearr_41632_41656 = state_41617__$1;
(statearr_41632_41656[(1)] = (4));

(statearr_41632_41656[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41618 === (5))){
var inst_41566 = (state_41617[(7)]);
var _ = (function (){var statearr_41634 = state_41617;
(statearr_41634[(4)] = cljs.core.cons((8),(state_41617[(4)])));

return statearr_41634;
})();
var inst_41573 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41566,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_41635 = state_41617;
(statearr_41635[(4)] = cljs.core.rest((state_41617[(4)])));

return statearr_41635;
})();
var state_41617__$1 = state_41617;
var statearr_41636_41657 = state_41617__$1;
(statearr_41636_41657[(2)] = inst_41573);

(statearr_41636_41657[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41618 === (10))){
var inst_41598 = (state_41617[(9)]);
var inst_41596 = (state_41617[(2)]);
var inst_41597 = fluree.db.util.async.throw_err(inst_41596);
var inst_41598__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41597,(0),null);
var inst_41599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41597,(1),null);
var inst_41600 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_41598__$1);
var inst_41601 = cljs.core.not(inst_41600);
var state_41617__$1 = (function (){var statearr_41637 = state_41617;
(statearr_41637[(9)] = inst_41598__$1);

(statearr_41637[(8)] = inst_41599);

return statearr_41637;
})();
if(inst_41601){
var statearr_41638_41658 = state_41617__$1;
(statearr_41638_41658[(1)] = (11));

} else {
var statearr_41639_41659 = state_41617__$1;
(statearr_41639_41659[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41618 === (8))){
var _ = (function (){var statearr_41640 = state_41617;
(statearr_41640[(4)] = cljs.core.rest((state_41617[(4)])));

return statearr_41640;
})();
var state_41617__$1 = state_41617;
var ex41633 = (state_41617__$1[(2)]);
var statearr_41641_41660 = state_41617__$1;
(statearr_41641_41660[(5)] = ex41633);


var statearr_41642_41661 = state_41617__$1;
(statearr_41642_41661[(1)] = (7));

(statearr_41642_41661[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____0 = (function (){
var statearr_41643 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41643[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__);

(statearr_41643[(1)] = (1));

return statearr_41643;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____1 = (function (state_41617){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41617);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41644){var ex__16304__auto__ = e41644;
var statearr_41645_41662 = state_41617;
(statearr_41645_41662[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41617[(4)]))){
var statearr_41646_41663 = state_41617;
(statearr_41646_41663[(1)] = cljs.core.first((state_41617[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41664 = state_41617;
state_41617 = G__41664;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__ = function(state_41617){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____1.call(this,state_41617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41647 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41647[(6)] = c__16375__auto__);

return statearr_41647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$(((typeof email === 'string')?cljs.core.re_matches(pattern,email):false));
}catch (e41665){var e = e41665;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__41667 = arguments.length;
switch (G__41667) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41737){
var state_val_41738 = (state_41737[(1)]);
if((state_val_41738 === (7))){
var inst_41669 = (state_41737[(2)]);
var state_41737__$1 = state_41737;
var statearr_41739_41783 = state_41737__$1;
(statearr_41739_41783[(2)] = inst_41669);

(statearr_41739_41783[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (20))){
var inst_41713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41714 = ["*"];
var inst_41715 = (new cljs.core.PersistentVector(null,1,(5),inst_41713,inst_41714,null));
var state_41737__$1 = state_41737;
var statearr_41740_41784 = state_41737__$1;
(statearr_41740_41784[(2)] = inst_41715);

(statearr_41740_41784[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (1))){
var state_41737__$1 = state_41737;
var statearr_41741_41785 = state_41737__$1;
(statearr_41741_41785[(2)] = null);

(statearr_41741_41785[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (4))){
var inst_41668 = (state_41737[(2)]);
var state_41737__$1 = (function (){var statearr_41742 = state_41737;
(statearr_41742[(7)] = inst_41668);

return statearr_41742;
})();
var statearr_41743_41786 = state_41737__$1;
(statearr_41743_41786[(2)] = null);

(statearr_41743_41786[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (15))){
var inst_41732 = (state_41737[(2)]);
var _ = (function (){var statearr_41744 = state_41737;
(statearr_41744[(4)] = cljs.core.rest((state_41737[(4)])));

return statearr_41744;
})();
var state_41737__$1 = state_41737;
var statearr_41745_41787 = state_41737__$1;
(statearr_41745_41787[(2)] = inst_41732);

(statearr_41745_41787[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (21))){
var inst_41703 = (state_41737[(8)]);
var inst_41696 = (state_41737[(9)]);
var inst_41717 = (state_41737[(2)]);
var inst_41718 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_41719 = cljs.core.PersistentHashMap.EMPTY;
var inst_41720 = [inst_41717,inst_41703,inst_41719];
var inst_41721 = cljs.core.PersistentHashMap.fromArrays(inst_41718,inst_41720);
var inst_41722 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41696,inst_41721);
var state_41737__$1 = state_41737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41737__$1,(22),inst_41722);
} else {
if((state_val_41738 === (13))){
var inst_41691 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41737__$1 = state_41737;
var statearr_41746_41788 = state_41737__$1;
(statearr_41746_41788[(2)] = inst_41691);

(statearr_41746_41788[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (22))){
var inst_41724 = (state_41737[(2)]);
var inst_41725 = fluree.db.util.async.throw_err(inst_41724);
var inst_41726 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41725,(0),null);
var inst_41727 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41725,(1),null);
var inst_41728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41729 = [inst_41726,inst_41727];
var inst_41730 = (new cljs.core.PersistentVector(null,2,(5),inst_41728,inst_41729,null));
var state_41737__$1 = state_41737;
var statearr_41747_41789 = state_41737__$1;
(statearr_41747_41789[(2)] = inst_41730);

(statearr_41747_41789[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (6))){
var inst_41678 = (state_41737[(2)]);
var state_41737__$1 = state_41737;
var statearr_41748_41790 = state_41737__$1;
(statearr_41748_41790[(2)] = inst_41678);

(statearr_41748_41790[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (17))){
var inst_41700 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41701 = fluree.db.dbfunctions.internal.get(inst_41700,cljs.core.cst$kw$_id);
var state_41737__$1 = state_41737;
var statearr_41749_41791 = state_41737__$1;
(statearr_41749_41791[(2)] = inst_41701);

(statearr_41749_41791[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (3))){
var inst_41735 = (state_41737[(2)]);
var state_41737__$1 = state_41737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41737__$1,inst_41735);
} else {
if((state_val_41738 === (12))){
var inst_41689 = (state_41737[(2)]);
var state_41737__$1 = state_41737;
if(cljs.core.truth_(inst_41689)){
var statearr_41750_41792 = state_41737__$1;
(statearr_41750_41792[(1)] = (13));

} else {
var statearr_41751_41793 = state_41737__$1;
(statearr_41751_41793[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (2))){
var inst_41684 = (state_41737[(10)]);
var _ = (function (){var statearr_41752 = state_41737;
(statearr_41752[(4)] = cljs.core.cons((9),(state_41737[(4)])));

return statearr_41752;
})();
var inst_41684__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41737__$1 = (function (){var statearr_41753 = state_41737;
(statearr_41753[(10)] = inst_41684__$1);

return statearr_41753;
})();
if(cljs.core.truth_(inst_41684__$1)){
var statearr_41754_41794 = state_41737__$1;
(statearr_41754_41794[(1)] = (10));

} else {
var statearr_41755_41795 = state_41737__$1;
(statearr_41755_41795[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (19))){
var inst_41705 = cljs.core.PersistentVector.EMPTY;
var inst_41706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41707 = ["*"];
var inst_41708 = (new cljs.core.PersistentVector(null,1,(5),inst_41706,inst_41707,null));
var inst_41709 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_41710 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_41708,inst_41709);
var inst_41711 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41705,inst_41710);
var state_41737__$1 = state_41737;
var statearr_41757_41796 = state_41737__$1;
(statearr_41757_41796[(2)] = inst_41711);

(statearr_41757_41796[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (11))){
var inst_41684 = (state_41737[(10)]);
var state_41737__$1 = state_41737;
var statearr_41758_41797 = state_41737__$1;
(statearr_41758_41797[(2)] = inst_41684);

(statearr_41758_41797[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (9))){
var _ = (function (){var statearr_41759 = state_41737;
(statearr_41759[(4)] = cljs.core.rest((state_41737[(4)])));

return statearr_41759;
})();
var state_41737__$1 = state_41737;
var ex41756 = (state_41737__$1[(2)]);
var statearr_41760_41798 = state_41737__$1;
(statearr_41760_41798[(5)] = ex41756);


var statearr_41761_41799 = state_41737__$1;
(statearr_41761_41799[(1)] = (4));

(statearr_41761_41799[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (5))){
var inst_41668 = (state_41737[(7)]);
var _ = (function (){var statearr_41762 = state_41737;
(statearr_41762[(4)] = cljs.core.cons((8),(state_41737[(4)])));

return statearr_41762;
})();
var inst_41675 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41668,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_41763 = state_41737;
(statearr_41763[(4)] = cljs.core.rest((state_41737[(4)])));

return statearr_41763;
})();
var state_41737__$1 = state_41737;
var statearr_41764_41800 = state_41737__$1;
(statearr_41764_41800[(2)] = inst_41675);

(statearr_41764_41800[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (14))){
var inst_41697 = (state_41737[(11)]);
var inst_41696 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41697__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41737__$1 = (function (){var statearr_41765 = state_41737;
(statearr_41765[(11)] = inst_41697__$1);

(statearr_41765[(9)] = inst_41696);

return statearr_41765;
})();
if(cljs.core.truth_(inst_41697__$1)){
var statearr_41766_41801 = state_41737__$1;
(statearr_41766_41801[(1)] = (16));

} else {
var statearr_41767_41802 = state_41737__$1;
(statearr_41767_41802[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (16))){
var inst_41697 = (state_41737[(11)]);
var state_41737__$1 = state_41737;
var statearr_41768_41803 = state_41737__$1;
(statearr_41768_41803[(2)] = inst_41697);

(statearr_41768_41803[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (10))){
var inst_41686 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_41737__$1 = state_41737;
var statearr_41770_41804 = state_41737__$1;
(statearr_41770_41804[(2)] = inst_41686);

(statearr_41770_41804[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (18))){
var inst_41703 = (state_41737[(2)]);
var state_41737__$1 = (function (){var statearr_41771 = state_41737;
(statearr_41771[(8)] = inst_41703);

return statearr_41771;
})();
if(cljs.core.truth_(additional_params)){
var statearr_41772_41805 = state_41737__$1;
(statearr_41772_41805[(1)] = (19));

} else {
var statearr_41773_41806 = state_41737__$1;
(statearr_41773_41806[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41738 === (8))){
var _ = (function (){var statearr_41774 = state_41737;
(statearr_41774[(4)] = cljs.core.rest((state_41737[(4)])));

return statearr_41774;
})();
var state_41737__$1 = state_41737;
var ex41769 = (state_41737__$1[(2)]);
var statearr_41775_41807 = state_41737__$1;
(statearr_41775_41807[(5)] = ex41769);


var statearr_41776_41808 = state_41737__$1;
(statearr_41776_41808[(1)] = (7));

(statearr_41776_41808[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16301__auto____0 = (function (){
var statearr_41777 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41777[(0)] = fluree$db$dbfunctions$internal$state_machine__16301__auto__);

(statearr_41777[(1)] = (1));

return statearr_41777;
});
var fluree$db$dbfunctions$internal$state_machine__16301__auto____1 = (function (state_41737){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41737);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41778){var ex__16304__auto__ = e41778;
var statearr_41779_41809 = state_41737;
(statearr_41779_41809[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41737[(4)]))){
var statearr_41780_41810 = state_41737;
(statearr_41780_41810[(1)] = cljs.core.first((state_41737[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41811 = state_41737;
state_41737 = G__41811;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16301__auto__ = function(state_41737){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____1.call(this,state_41737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41781 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41781[(6)] = c__16375__auto__);

return statearr_41781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__41813 = arguments.length;
switch (G__41813) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41857){
var state_val_41858 = (state_41857[(1)]);
if((state_val_41858 === (7))){
var inst_41835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41836 = ["*"];
var inst_41837 = (new cljs.core.PersistentVector(null,1,(5),inst_41835,inst_41836,null));
var state_41857__$1 = state_41857;
var statearr_41859_41879 = state_41857__$1;
(statearr_41859_41879[(2)] = inst_41837);

(statearr_41859_41879[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41858 === (1))){
var state_41857__$1 = state_41857;
var statearr_41860_41880 = state_41857__$1;
(statearr_41860_41880[(2)] = null);

(statearr_41860_41880[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41858 === (4))){
var inst_41814 = (state_41857[(2)]);
var inst_41815 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41814,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_41857__$1 = state_41857;
var statearr_41861_41881 = state_41857__$1;
(statearr_41861_41881[(2)] = inst_41815);

(statearr_41861_41881[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41858 === (6))){
var inst_41827 = cljs.core.PersistentVector.EMPTY;
var inst_41828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41829 = ["*"];
var inst_41830 = (new cljs.core.PersistentVector(null,1,(5),inst_41828,inst_41829,null));
var inst_41831 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_41832 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_41830,inst_41831);
var inst_41833 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41827,inst_41832);
var state_41857__$1 = state_41857;
var statearr_41862_41882 = state_41857__$1;
(statearr_41862_41882[(2)] = inst_41833);

(statearr_41862_41882[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41858 === (3))){
var inst_41855 = (state_41857[(2)]);
var state_41857__$1 = state_41857;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41857__$1,inst_41855);
} else {
if((state_val_41858 === (2))){
var _ = (function (){var statearr_41864 = state_41857;
(statearr_41864[(4)] = cljs.core.cons((5),(state_41857[(4)])));

return statearr_41864;
})();
var inst_41824 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41825 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41857__$1 = (function (){var statearr_41865 = state_41857;
(statearr_41865[(7)] = inst_41825);

(statearr_41865[(8)] = inst_41824);

return statearr_41865;
})();
if(cljs.core.truth_(additional_params)){
var statearr_41866_41883 = state_41857__$1;
(statearr_41866_41883[(1)] = (6));

} else {
var statearr_41867_41884 = state_41857__$1;
(statearr_41867_41884[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41858 === (9))){
var inst_41846 = (state_41857[(2)]);
var inst_41847 = fluree.db.util.async.throw_err(inst_41846);
var inst_41848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41847,(0),null);
var inst_41849 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41847,(1),null);
var inst_41850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41851 = [inst_41848,inst_41849];
var inst_41852 = (new cljs.core.PersistentVector(null,2,(5),inst_41850,inst_41851,null));
var _ = (function (){var statearr_41868 = state_41857;
(statearr_41868[(4)] = cljs.core.rest((state_41857[(4)])));

return statearr_41868;
})();
var state_41857__$1 = state_41857;
var statearr_41869_41885 = state_41857__$1;
(statearr_41869_41885[(2)] = inst_41852);

(statearr_41869_41885[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41858 === (5))){
var _ = (function (){var statearr_41870 = state_41857;
(statearr_41870[(4)] = cljs.core.rest((state_41857[(4)])));

return statearr_41870;
})();
var state_41857__$1 = state_41857;
var ex41863 = (state_41857__$1[(2)]);
var statearr_41871_41886 = state_41857__$1;
(statearr_41871_41886[(5)] = ex41863);


var statearr_41872_41887 = state_41857__$1;
(statearr_41872_41887[(1)] = (4));

(statearr_41872_41887[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41858 === (8))){
var inst_41825 = (state_41857[(7)]);
var inst_41824 = (state_41857[(8)]);
var inst_41839 = (state_41857[(2)]);
var inst_41840 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_41841 = cljs.core.PersistentHashMap.EMPTY;
var inst_41842 = [inst_41839,inst_41825,inst_41841];
var inst_41843 = cljs.core.PersistentHashMap.fromArrays(inst_41840,inst_41842);
var inst_41844 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41824,inst_41843);
var state_41857__$1 = state_41857;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41857__$1,(9),inst_41844);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16301__auto____0 = (function (){
var statearr_41873 = [null,null,null,null,null,null,null,null,null];
(statearr_41873[(0)] = fluree$db$dbfunctions$internal$state_machine__16301__auto__);

(statearr_41873[(1)] = (1));

return statearr_41873;
});
var fluree$db$dbfunctions$internal$state_machine__16301__auto____1 = (function (state_41857){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41857);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41874){var ex__16304__auto__ = e41874;
var statearr_41875_41888 = state_41857;
(statearr_41875_41888[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41857[(4)]))){
var statearr_41876_41889 = state_41857;
(statearr_41876_41889[(1)] = cljs.core.first((state_41857[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41890 = state_41857;
state_41857 = G__41890;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16301__auto__ = function(state_41857){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____1.call(this,state_41857);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41877 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41877[(6)] = c__16375__auto__);

return statearr_41877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41934){
var state_val_41935 = (state_41934[(1)]);
if((state_val_41935 === (1))){
var state_41934__$1 = state_41934;
var statearr_41936_41950 = state_41934__$1;
(statearr_41936_41950[(2)] = null);

(statearr_41936_41950[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41935 === (2))){
var _ = (function (){var statearr_41937 = state_41934;
(statearr_41937[(4)] = cljs.core.cons((5),(state_41934[(4)])));

return statearr_41937;
})();
var inst_41901 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_41902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41903 = ["_user/_auth"];
var inst_41904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41905 = ["*"];
var inst_41906 = (new cljs.core.PersistentVector(null,1,(5),inst_41904,inst_41905,null));
var inst_41907 = [inst_41906];
var inst_41908 = cljs.core.PersistentHashMap.fromArrays(inst_41903,inst_41907);
var inst_41909 = [inst_41908];
var inst_41910 = (new cljs.core.PersistentVector(null,1,(5),inst_41902,inst_41909,null));
var inst_41911 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41912 = cljs.core.PersistentHashMap.EMPTY;
var inst_41913 = [inst_41910,inst_41911,inst_41912];
var inst_41914 = cljs.core.PersistentHashMap.fromArrays(inst_41901,inst_41913);
var inst_41915 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41916 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41915,inst_41914);
var state_41934__$1 = state_41934;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41934__$1,(6),inst_41916);
} else {
if((state_val_41935 === (3))){
var inst_41932 = (state_41934[(2)]);
var state_41934__$1 = state_41934;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41934__$1,inst_41932);
} else {
if((state_val_41935 === (4))){
var inst_41891 = (state_41934[(2)]);
var inst_41892 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41891,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_41934__$1 = state_41934;
var statearr_41939_41951 = state_41934__$1;
(statearr_41939_41951[(2)] = inst_41892);

(statearr_41939_41951[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41935 === (5))){
var _ = (function (){var statearr_41940 = state_41934;
(statearr_41940[(4)] = cljs.core.rest((state_41934[(4)])));

return statearr_41940;
})();
var state_41934__$1 = state_41934;
var ex41938 = (state_41934__$1[(2)]);
var statearr_41941_41952 = state_41934__$1;
(statearr_41941_41952[(5)] = ex41938);


var statearr_41942_41953 = state_41934__$1;
(statearr_41942_41953[(1)] = (4));

(statearr_41942_41953[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41935 === (6))){
var inst_41918 = (state_41934[(2)]);
var inst_41919 = fluree.db.util.async.throw_err(inst_41918);
var inst_41920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41919,(0),null);
var inst_41921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41919,(1),null);
var inst_41922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41923 = ["_user/_auth","_id"];
var inst_41924 = (new cljs.core.PersistentVector(null,2,(5),inst_41922,inst_41923,null));
var inst_41925 = fluree.db.dbfunctions.internal.get_in(inst_41920,inst_41924);
var inst_41926 = cljs.core.first(inst_41925);
var inst_41927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41928 = [inst_41926,inst_41921];
var inst_41929 = (new cljs.core.PersistentVector(null,2,(5),inst_41927,inst_41928,null));
var _ = (function (){var statearr_41943 = state_41934;
(statearr_41943[(4)] = cljs.core.rest((state_41934[(4)])));

return statearr_41943;
})();
var state_41934__$1 = state_41934;
var statearr_41944_41954 = state_41934__$1;
(statearr_41944_41954[(2)] = inst_41929);

(statearr_41944_41954[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____0 = (function (){
var statearr_41945 = [null,null,null,null,null,null,null];
(statearr_41945[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__);

(statearr_41945[(1)] = (1));

return statearr_41945;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____1 = (function (state_41934){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41934);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41946){var ex__16304__auto__ = e41946;
var statearr_41947_41955 = state_41934;
(statearr_41947_41955[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41934[(4)]))){
var statearr_41948_41956 = state_41934;
(statearr_41948_41956[(1)] = cljs.core.first((state_41934[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41957 = state_41934;
state_41934 = G__41957;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__ = function(state_41934){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____1.call(this,state_41934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41949 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41949[(6)] = c__16375__auto__);

return statearr_41949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41974){
var state_val_41975 = (state_41974[(1)]);
if((state_val_41975 === (1))){
var state_41974__$1 = state_41974;
var statearr_41976_41990 = state_41974__$1;
(statearr_41976_41990[(2)] = null);

(statearr_41976_41990[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41975 === (2))){
var _ = (function (){var statearr_41977 = state_41974;
(statearr_41977[(4)] = cljs.core.cons((5),(state_41974[(4)])));

return statearr_41977;
})();
var inst_41964 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41965 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41966 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_41965,inst_41964);
var state_41974__$1 = state_41974;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41974__$1,(6),inst_41966);
} else {
if((state_val_41975 === (3))){
var inst_41972 = (state_41974[(2)]);
var state_41974__$1 = state_41974;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41974__$1,inst_41972);
} else {
if((state_val_41975 === (4))){
var inst_41958 = (state_41974[(2)]);
var state_41974__$1 = state_41974;
var statearr_41979_41991 = state_41974__$1;
(statearr_41979_41991[(2)] = inst_41958);

(statearr_41979_41991[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41975 === (5))){
var _ = (function (){var statearr_41980 = state_41974;
(statearr_41980[(4)] = cljs.core.rest((state_41974[(4)])));

return statearr_41980;
})();
var state_41974__$1 = state_41974;
var ex41978 = (state_41974__$1[(2)]);
var statearr_41981_41992 = state_41974__$1;
(statearr_41981_41992[(5)] = ex41978);


if((ex41978 instanceof Error)){
var statearr_41982_41993 = state_41974__$1;
(statearr_41982_41993[(1)] = (4));

(statearr_41982_41993[(5)] = null);

} else {
throw ex41978;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41975 === (6))){
var inst_41968 = (state_41974[(2)]);
var inst_41969 = fluree.db.util.async.throw_err(inst_41968);
var _ = (function (){var statearr_41983 = state_41974;
(statearr_41983[(4)] = cljs.core.rest((state_41974[(4)])));

return statearr_41983;
})();
var state_41974__$1 = state_41974;
var statearr_41984_41994 = state_41974__$1;
(statearr_41984_41994[(2)] = inst_41969);

(statearr_41984_41994[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____0 = (function (){
var statearr_41985 = [null,null,null,null,null,null,null];
(statearr_41985[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__);

(statearr_41985[(1)] = (1));

return statearr_41985;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____1 = (function (state_41974){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41974);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41986){var ex__16304__auto__ = e41986;
var statearr_41987_41995 = state_41974;
(statearr_41987_41995[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41974[(4)]))){
var statearr_41988_41996 = state_41974;
(statearr_41988_41996[(1)] = cljs.core.first((state_41974[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41997 = state_41974;
state_41974 = G__41997;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__ = function(state_41974){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____1.call(this,state_41974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41989 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41989[(6)] = c__16375__auto__);

return statearr_41989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__41998_SHARP_){
return p1__41998_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41999_SHARP_){
return p1__41999_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e42000){var e = e42000;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__42001_SHARP_){
return p1__42001_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42002_SHARP_){
return p1__42002_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e42003){var e = e42003;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__42005 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__42005);
})() | (0));
return num;
}catch (e42004){var e = e42004;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_42105){
var state_val_42106 = (state_42105[(1)]);
if((state_val_42106 === (7))){
var state_42105__$1 = state_42105;
var statearr_42107_42155 = state_42105__$1;
(statearr_42107_42155[(2)] = false);

(statearr_42107_42155[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (20))){
var inst_42039 = (state_42105[(7)]);
var inst_42040 = (state_42105[(8)]);
var inst_42061 = (state_42105[(2)]);
var inst_42062 = fluree.db.dbproto._p_prop(inst_42040,cljs.core.cst$kw$multi,inst_42039);
var state_42105__$1 = (function (){var statearr_42108 = state_42105;
(statearr_42108[(9)] = inst_42061);

return statearr_42108;
})();
if(cljs.core.truth_(inst_42062)){
var statearr_42109_42156 = state_42105__$1;
(statearr_42109_42156[(1)] = (21));

} else {
var statearr_42110_42157 = state_42105__$1;
(statearr_42110_42157[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (27))){
var inst_42100 = (state_42105[(2)]);
var _ = (function (){var statearr_42111 = state_42105;
(statearr_42111[(4)] = cljs.core.rest((state_42105[(4)])));

return statearr_42111;
})();
var state_42105__$1 = state_42105;
var statearr_42112_42158 = state_42105__$1;
(statearr_42112_42158[(2)] = inst_42100);

(statearr_42112_42158[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (1))){
var state_42105__$1 = state_42105;
var statearr_42113_42159 = state_42105__$1;
(statearr_42113_42159[(2)] = null);

(statearr_42113_42159[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (24))){
var inst_42089 = (state_42105[(10)]);
var inst_42085 = (state_42105[(2)]);
var inst_42086 = fluree.db.util.async.throw_err(inst_42085);
var inst_42087 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42086,(0),null);
var inst_42088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42086,(1),null);
var inst_42089__$1 = cljs.core.first(inst_42087);
var inst_42090 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42089__$1,compare_val);
var state_42105__$1 = (function (){var statearr_42114 = state_42105;
(statearr_42114[(10)] = inst_42089__$1);

(statearr_42114[(11)] = inst_42088);

return statearr_42114;
})();
if(inst_42090){
var statearr_42115_42160 = state_42105__$1;
(statearr_42115_42160[(1)] = (25));

} else {
var statearr_42116_42161 = state_42105__$1;
(statearr_42116_42161[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (4))){
var inst_42006 = (state_42105[(2)]);
var state_42105__$1 = state_42105;
var statearr_42117_42162 = state_42105__$1;
(statearr_42117_42162[(2)] = inst_42006);

(statearr_42117_42162[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (15))){
var state_42105__$1 = state_42105;
var statearr_42118_42163 = state_42105__$1;
(statearr_42118_42163[(2)] = null);

(statearr_42118_42163[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (21))){
var inst_42041 = (state_42105[(12)]);
var inst_42064 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_42041], 0));
var inst_42065 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42066 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_42067 = cljs.core.PersistentHashMap.fromArrays(inst_42065,inst_42066);
var inst_42068 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42064,inst_42067);
var inst_42069 = (function(){throw inst_42068})();
var state_42105__$1 = state_42105;
var statearr_42119_42164 = state_42105__$1;
(statearr_42119_42164[(2)] = inst_42069);

(statearr_42119_42164[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (13))){
var inst_42016 = (state_42105[(13)]);
var state_42105__$1 = state_42105;
var statearr_42120_42165 = state_42105__$1;
(statearr_42120_42165[(2)] = inst_42016);

(statearr_42120_42165[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (22))){
var state_42105__$1 = state_42105;
var statearr_42121_42166 = state_42105__$1;
(statearr_42121_42166[(2)] = null);

(statearr_42121_42166[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (6))){
var inst_42016 = (state_42105[(13)]);
var inst_42021 = inst_42016.cljs$lang$protocol_mask$partition0$;
var inst_42022 = (inst_42021 & (64));
var inst_42023 = inst_42016.cljs$core$ISeq$;
var inst_42024 = (cljs.core.PROTOCOL_SENTINEL === inst_42023);
var inst_42025 = ((inst_42022) || (inst_42024));
var state_42105__$1 = state_42105;
if(cljs.core.truth_(inst_42025)){
var statearr_42122_42167 = state_42105__$1;
(statearr_42122_42167[(1)] = (9));

} else {
var statearr_42123_42168 = state_42105__$1;
(statearr_42123_42168[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (25))){
var state_42105__$1 = state_42105;
var statearr_42124_42169 = state_42105__$1;
(statearr_42124_42169[(2)] = new_val);

(statearr_42124_42169[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (17))){
var inst_42041 = (state_42105[(12)]);
var inst_42051 = (state_42105[(2)]);
var state_42105__$1 = (function (){var statearr_42125 = state_42105;
(statearr_42125[(14)] = inst_42051);

return statearr_42125;
})();
if(cljs.core.truth_(inst_42041)){
var statearr_42126_42170 = state_42105__$1;
(statearr_42126_42170[(1)] = (18));

} else {
var statearr_42127_42171 = state_42105__$1;
(statearr_42127_42171[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (3))){
var inst_42103 = (state_42105[(2)]);
var state_42105__$1 = state_42105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42105__$1,inst_42103);
} else {
if((state_val_42106 === (12))){
var inst_42016 = (state_42105[(13)]);
var inst_42034 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_42016);
var state_42105__$1 = state_42105;
var statearr_42128_42172 = state_42105__$1;
(statearr_42128_42172[(2)] = inst_42034);

(statearr_42128_42172[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (2))){
var inst_42016 = (state_42105[(13)]);
var _ = (function (){var statearr_42129 = state_42105;
(statearr_42129[(4)] = cljs.core.cons((5),(state_42105[(4)])));

return statearr_42129;
})();
var inst_42016__$1 = _QMARK_ctx;
var inst_42018 = (inst_42016__$1 == null);
var inst_42019 = cljs.core.not(inst_42018);
var state_42105__$1 = (function (){var statearr_42130 = state_42105;
(statearr_42130[(13)] = inst_42016__$1);

return statearr_42130;
})();
if(inst_42019){
var statearr_42131_42173 = state_42105__$1;
(statearr_42131_42173[(1)] = (6));

} else {
var statearr_42132_42174 = state_42105__$1;
(statearr_42132_42174[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (23))){
var inst_42041 = (state_42105[(12)]);
var inst_42040 = (state_42105[(8)]);
var inst_42038 = (state_42105[(15)]);
var inst_42072 = (state_42105[(2)]);
var inst_42073 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_42074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42076 = [inst_42038,inst_42041,"?current-val"];
var inst_42077 = (new cljs.core.PersistentVector(null,3,(5),inst_42075,inst_42076,null));
var inst_42078 = [inst_42077];
var inst_42079 = (new cljs.core.PersistentVector(null,1,(5),inst_42074,inst_42078,null));
var inst_42080 = cljs.core.PersistentHashMap.EMPTY;
var inst_42081 = ["?current-val",inst_42079,inst_42080];
var inst_42082 = cljs.core.PersistentHashMap.fromArrays(inst_42073,inst_42081);
var inst_42083 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_42040,inst_42082);
var state_42105__$1 = (function (){var statearr_42133 = state_42105;
(statearr_42133[(16)] = inst_42072);

return statearr_42133;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42105__$1,(24),inst_42083);
} else {
if((state_val_42106 === (19))){
var inst_42054 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_42055 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42056 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_42057 = cljs.core.PersistentHashMap.fromArrays(inst_42055,inst_42056);
var inst_42058 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42054,inst_42057);
var inst_42059 = (function(){throw inst_42058})();
var state_42105__$1 = state_42105;
var statearr_42134_42175 = state_42105__$1;
(statearr_42134_42175[(2)] = inst_42059);

(statearr_42134_42175[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (11))){
var inst_42029 = (state_42105[(2)]);
var state_42105__$1 = state_42105;
var statearr_42136_42176 = state_42105__$1;
(statearr_42136_42176[(2)] = inst_42029);

(statearr_42136_42176[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (9))){
var state_42105__$1 = state_42105;
var statearr_42137_42177 = state_42105__$1;
(statearr_42137_42177[(2)] = true);

(statearr_42137_42177[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (5))){
var _ = (function (){var statearr_42138 = state_42105;
(statearr_42138[(4)] = cljs.core.rest((state_42105[(4)])));

return statearr_42138;
})();
var state_42105__$1 = state_42105;
var ex42135 = (state_42105__$1[(2)]);
var statearr_42139_42178 = state_42105__$1;
(statearr_42139_42178[(5)] = ex42135);


if((ex42135 instanceof Error)){
var statearr_42140_42179 = state_42105__$1;
(statearr_42140_42179[(1)] = (4));

(statearr_42140_42179[(5)] = null);

} else {
throw ex42135;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (14))){
var inst_42039 = (state_42105[(7)]);
var inst_42040 = (state_42105[(8)]);
var inst_42038 = (state_42105[(15)]);
var inst_42037 = (state_42105[(2)]);
var inst_42038__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42037,cljs.core.cst$kw$sid);
var inst_42039__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42037,cljs.core.cst$kw$pid);
var inst_42040__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42037,cljs.core.cst$kw$db);
var inst_42041 = fluree.db.dbproto._p_prop(inst_42040__$1,cljs.core.cst$kw$name,inst_42039__$1);
var state_42105__$1 = (function (){var statearr_42141 = state_42105;
(statearr_42141[(7)] = inst_42039__$1);

(statearr_42141[(12)] = inst_42041);

(statearr_42141[(8)] = inst_42040__$1);

(statearr_42141[(15)] = inst_42038__$1);

return statearr_42141;
})();
if(cljs.core.truth_(inst_42038__$1)){
var statearr_42142_42180 = state_42105__$1;
(statearr_42142_42180[(1)] = (15));

} else {
var statearr_42143_42181 = state_42105__$1;
(statearr_42143_42181[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (26))){
var inst_42089 = (state_42105[(10)]);
var inst_42093 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42089)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_42094 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42095 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_42096 = cljs.core.PersistentHashMap.fromArrays(inst_42094,inst_42095);
var inst_42097 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42093,inst_42096);
var inst_42098 = (function(){throw inst_42097})();
var state_42105__$1 = state_42105;
var statearr_42144_42182 = state_42105__$1;
(statearr_42144_42182[(2)] = inst_42098);

(statearr_42144_42182[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (16))){
var inst_42044 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_42045 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42046 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_42047 = cljs.core.PersistentHashMap.fromArrays(inst_42045,inst_42046);
var inst_42048 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42044,inst_42047);
var inst_42049 = (function(){throw inst_42048})();
var state_42105__$1 = state_42105;
var statearr_42145_42183 = state_42105__$1;
(statearr_42145_42183[(2)] = inst_42049);

(statearr_42145_42183[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (10))){
var state_42105__$1 = state_42105;
var statearr_42146_42184 = state_42105__$1;
(statearr_42146_42184[(2)] = false);

(statearr_42146_42184[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (18))){
var state_42105__$1 = state_42105;
var statearr_42147_42185 = state_42105__$1;
(statearr_42147_42185[(2)] = null);

(statearr_42147_42185[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42106 === (8))){
var inst_42032 = (state_42105[(2)]);
var state_42105__$1 = state_42105;
if(cljs.core.truth_(inst_42032)){
var statearr_42148_42186 = state_42105__$1;
(statearr_42148_42186[(1)] = (12));

} else {
var statearr_42149_42187 = state_42105__$1;
(statearr_42149_42187[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____0 = (function (){
var statearr_42150 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42150[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__);

(statearr_42150[(1)] = (1));

return statearr_42150;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____1 = (function (state_42105){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_42105);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e42151){var ex__16304__auto__ = e42151;
var statearr_42152_42188 = state_42105;
(statearr_42152_42188[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_42105[(4)]))){
var statearr_42153_42189 = state_42105;
(statearr_42153_42189[(1)] = cljs.core.first((state_42105[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__42190 = state_42105;
state_42105 = G__42190;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__ = function(state_42105){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____1.call(this,state_42105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_42154 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_42154[(6)] = c__16375__auto__);

return statearr_42154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
