// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e33984){var e = e33984;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__33985_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__33985_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__33985_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__33985_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__33985_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33986_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33986_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33987_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33987_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__33992 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33992,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33992,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33988_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33988_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1)))?cljs.core.re_find(/\+/,key):false))){
var vec__33995 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33995,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33995,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33989_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33989_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33990_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33990_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33991_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33991_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33998_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__33998_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5733__auto__ = (function (){var G__33999 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__33999) : intersecting_vars.call(null,G__33999));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__34002,optional_QMARK_,fuel,max_fuel){
var map__34003 = p__34002;
var map__34003__$1 = (((((!((map__34003 == null))))?(((((map__34003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34003.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34003):map__34003);
var res = map__34003__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34003__$1,cljs.core.cst$kw$vars);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34070){
var state_val_34071 = (state_34070[(1)]);
if((state_val_34071 === (7))){
var inst_34059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34060 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_34061 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34060,clause);
var inst_34062 = [null,inst_34061];
var inst_34063 = (new cljs.core.PersistentVector(null,2,(5),inst_34059,inst_34062,null));
var state_34070__$1 = state_34070;
var statearr_34072_34100 = state_34070__$1;
(statearr_34072_34100[(2)] = inst_34063);

(statearr_34072_34100[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34071 === (1))){
var state_34070__$1 = state_34070;
var statearr_34073_34101 = state_34070__$1;
(statearr_34073_34101[(2)] = null);

(statearr_34073_34101[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34071 === (4))){
var inst_34005 = (state_34070[(2)]);
var state_34070__$1 = state_34070;
var statearr_34074_34102 = state_34070__$1;
(statearr_34074_34102[(2)] = inst_34005);

(statearr_34074_34102[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34071 === (15))){
var inst_34048 = (state_34070[(2)]);
var inst_34049 = fluree.db.util.async.throw_err(inst_34048);
var inst_34050 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_34049);
var inst_34051 = cljs.core.count(inst_34050);
var inst_34052 = fluree.db.query.analytical.add_fuel(inst_34051,fuel,max_fuel);
var inst_34053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34054 = [inst_34049,r];
var inst_34055 = (new cljs.core.PersistentVector(null,2,(5),inst_34053,inst_34054,null));
var state_34070__$1 = (function (){var statearr_34075 = state_34070;
(statearr_34075[(7)] = inst_34052);

return statearr_34075;
})();
var statearr_34076_34103 = state_34070__$1;
(statearr_34076_34103[(2)] = inst_34055);

(statearr_34076_34103[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34071 === (13))){
var inst_34014 = (state_34070[(8)]);
var inst_34027 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_34028 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_34027);
var inst_34029 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_34014);
var inst_34030 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_34029);
var inst_34031 = cljs.core.set(inst_34030);
var inst_34032 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_34028);
var inst_34033 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_34032);
var inst_34034 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34031,inst_34033);
var inst_34035 = (function (){var all_wd = inst_34014;
var optional = inst_34028;
var all_wd_vars = inst_34031;
var all_vars = inst_34034;
return (function (p1__34000_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__34000_SHARP_) : all_vars.call(null,p1__34000_SHARP_));
});
})();
var inst_34036 = cljs.core.keys(vars);
var inst_34037 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34035,inst_34036);
var inst_34038 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_34037);
var inst_34039 = cljs.core.set(inst_34038);
var inst_34040 = (function (){var all_wd = inst_34014;
var optional = inst_34028;
var all_wd_vars = inst_34031;
var all_vars = inst_34034;
var intersecting_vars = inst_34039;
return (function (p1__34001_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__34001_SHARP_);
});
})();
var inst_34041 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34040,inst_34014);
var inst_34042 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_34041);
var inst_34043 = fluree.db.query.analytical.select_from_tuples(inst_34042,res);
var inst_34044 = fluree.db.query.analytical.replace_vars_wikidata(inst_34014,inst_34039,vars);
var inst_34045 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_34039,inst_34034);
var inst_34046 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_34044,inst_34042,inst_34043,inst_34045,inst_34028);
var state_34070__$1 = state_34070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34070__$1,(15),inst_34046);
} else {
if((state_val_34071 === (6))){
var inst_34015 = (state_34070[(9)]);
var inst_34013 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_34014 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_34013);
var inst_34015__$1 = optional_QMARK_;
var state_34070__$1 = (function (){var statearr_34077 = state_34070;
(statearr_34077[(9)] = inst_34015__$1);

(statearr_34077[(8)] = inst_34014);

return statearr_34077;
})();
if(cljs.core.truth_(inst_34015__$1)){
var statearr_34078_34104 = state_34070__$1;
(statearr_34078_34104[(1)] = (9));

} else {
var statearr_34079_34105 = state_34070__$1;
(statearr_34079_34105[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34071 === (3))){
var inst_34068 = (state_34070[(2)]);
var state_34070__$1 = state_34070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34070__$1,inst_34068);
} else {
if((state_val_34071 === (12))){
var inst_34023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34024 = [null,r];
var inst_34025 = (new cljs.core.PersistentVector(null,2,(5),inst_34023,inst_34024,null));
var state_34070__$1 = state_34070;
var statearr_34080_34106 = state_34070__$1;
(statearr_34080_34106[(2)] = inst_34025);

(statearr_34080_34106[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34071 === (2))){
var _ = (function (){var statearr_34081 = state_34070;
(statearr_34081[(4)] = cljs.core.cons((5),(state_34070[(4)])));

return statearr_34081;
})();
var inst_34011 = (r == null);
var state_34070__$1 = state_34070;
if(cljs.core.truth_(inst_34011)){
var statearr_34082_34107 = state_34070__$1;
(statearr_34082_34107[(1)] = (6));

} else {
var statearr_34083_34108 = state_34070__$1;
(statearr_34083_34108[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34071 === (11))){
var inst_34021 = (state_34070[(2)]);
var state_34070__$1 = state_34070;
if(cljs.core.truth_(inst_34021)){
var statearr_34085_34109 = state_34070__$1;
(statearr_34085_34109[(1)] = (12));

} else {
var statearr_34086_34110 = state_34070__$1;
(statearr_34086_34110[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34071 === (9))){
var inst_34014 = (state_34070[(8)]);
var inst_34017 = cljs.core.empty_QMARK_(inst_34014);
var inst_34018 = (!(inst_34017));
var state_34070__$1 = state_34070;
var statearr_34087_34111 = state_34070__$1;
(statearr_34087_34111[(2)] = inst_34018);

(statearr_34087_34111[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34071 === (5))){
var _ = (function (){var statearr_34088 = state_34070;
(statearr_34088[(4)] = cljs.core.rest((state_34070[(4)])));

return statearr_34088;
})();
var state_34070__$1 = state_34070;
var ex34084 = (state_34070__$1[(2)]);
var statearr_34089_34112 = state_34070__$1;
(statearr_34089_34112[(5)] = ex34084);


if((ex34084 instanceof Error)){
var statearr_34090_34113 = state_34070__$1;
(statearr_34090_34113[(1)] = (4));

(statearr_34090_34113[(5)] = null);

} else {
throw ex34084;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34071 === (14))){
var inst_34057 = (state_34070[(2)]);
var state_34070__$1 = state_34070;
var statearr_34091_34114 = state_34070__$1;
(statearr_34091_34114[(2)] = inst_34057);

(statearr_34091_34114[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34071 === (10))){
var inst_34015 = (state_34070[(9)]);
var state_34070__$1 = state_34070;
var statearr_34092_34115 = state_34070__$1;
(statearr_34092_34115[(2)] = inst_34015);

(statearr_34092_34115[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34071 === (8))){
var inst_34065 = (state_34070[(2)]);
var _ = (function (){var statearr_34093 = state_34070;
(statearr_34093[(4)] = cljs.core.rest((state_34070[(4)])));

return statearr_34093;
})();
var state_34070__$1 = state_34070;
var statearr_34094_34116 = state_34070__$1;
(statearr_34094_34116[(2)] = inst_34065);

(statearr_34094_34116[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_34095 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34095[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__);

(statearr_34095[(1)] = (1));

return statearr_34095;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____1 = (function (state_34070){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34070);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34096){var ex__16304__auto__ = e34096;
var statearr_34097_34117 = state_34070;
(statearr_34097_34117[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34070[(4)]))){
var statearr_34098_34118 = state_34070;
(statearr_34098_34118[(1)] = cljs.core.first((state_34070[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34119 = state_34070;
state_34070 = G__34119;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__ = function(state_34070){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____1.call(this,state_34070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34099 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34099[(6)] = c__16375__auto__);

return statearr_34099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__34121 = arguments.length;
switch (G__34121) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34215){
var state_val_34216 = (state_34215[(1)]);
if((state_val_34216 === (7))){
var inst_34128 = (state_34215[(7)]);
var inst_34138 = clojure.string.starts_with_QMARK_(inst_34128,"$fdb");
var state_34215__$1 = state_34215;
if(inst_34138){
var statearr_34217_34266 = state_34215__$1;
(statearr_34217_34266[(1)] = (9));

} else {
var statearr_34218_34267 = state_34215__$1;
(statearr_34218_34267[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (20))){
var state_34215__$1 = state_34215;
var statearr_34219_34268 = state_34215__$1;
(statearr_34219_34268[(2)] = null);

(statearr_34219_34268[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (27))){
var inst_34178 = (state_34215[(8)]);
var state_34215__$1 = state_34215;
var statearr_34220_34269 = state_34215__$1;
(statearr_34220_34269[(2)] = inst_34178);

(statearr_34220_34269[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (1))){
var state_34215__$1 = state_34215;
var statearr_34221_34270 = state_34215__$1;
(statearr_34221_34270[(2)] = null);

(statearr_34221_34270[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (24))){
var inst_34201 = (state_34215[(2)]);
var state_34215__$1 = state_34215;
var statearr_34222_34271 = state_34215__$1;
(statearr_34222_34271[(2)] = inst_34201);

(statearr_34222_34271[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (4))){
var inst_34122 = (state_34215[(2)]);
var state_34215__$1 = state_34215;
var statearr_34223_34272 = state_34215__$1;
(statearr_34223_34272[(2)] = inst_34122);

(statearr_34223_34272[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (15))){
var inst_34145 = (state_34215[(9)]);
var inst_34151 = (state_34215[(2)]);
var inst_34152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34153 = cljs.core.PersistentVector.EMPTY;
var inst_34154 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34155 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34153,inst_34154);
var inst_34156 = [inst_34145,inst_34155];
var inst_34157 = (new cljs.core.PersistentVector(null,2,(5),inst_34152,inst_34156,null));
var state_34215__$1 = (function (){var statearr_34224 = state_34215;
(statearr_34224[(10)] = inst_34151);

return statearr_34224;
})();
var statearr_34225_34273 = state_34215__$1;
(statearr_34225_34273[(2)] = inst_34157);

(statearr_34225_34273[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (21))){
var inst_34204 = (state_34215[(2)]);
var state_34215__$1 = state_34215;
var statearr_34226_34274 = state_34215__$1;
(statearr_34226_34274[(2)] = inst_34204);

(statearr_34226_34274[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (13))){
var inst_34145 = (state_34215[(9)]);
var inst_34148 = (function(){throw inst_34145})();
var state_34215__$1 = state_34215;
var statearr_34227_34275 = state_34215__$1;
(statearr_34227_34275[(2)] = inst_34148);

(statearr_34227_34275[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (22))){
var inst_34167 = (state_34215[(11)]);
var inst_34169 = (state_34215[(12)]);
var inst_34171 = fluree.db.query.analytical.parse_block_from_source(inst_34167);
var inst_34172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34173 = [cljs.core.cst$kw$sources,inst_34169];
var inst_34174 = (new cljs.core.PersistentVector(null,2,(5),inst_34172,inst_34173,null));
var inst_34175 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_34174);
var state_34215__$1 = (function (){var statearr_34228 = state_34215;
(statearr_34228[(13)] = inst_34171);

return statearr_34228;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34215__$1,(25),inst_34175);
} else {
if((state_val_34216 === (29))){
var inst_34182 = (state_34215[(2)]);
var inst_34183 = fluree.db.util.async.throw_err(inst_34182);
var state_34215__$1 = state_34215;
var statearr_34229_34276 = state_34215__$1;
(statearr_34229_34276[(2)] = inst_34183);

(statearr_34229_34276[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (6))){
var inst_34131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34132 = cljs.core.PersistentVector.EMPTY;
var inst_34133 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34134 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34132,inst_34133);
var inst_34135 = [db,inst_34134];
var inst_34136 = (new cljs.core.PersistentVector(null,2,(5),inst_34131,inst_34135,null));
var state_34215__$1 = state_34215;
var statearr_34230_34277 = state_34215__$1;
(statearr_34230_34277[(2)] = inst_34136);

(statearr_34230_34277[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (28))){
var inst_34186 = (state_34215[(2)]);
var inst_34187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34188 = cljs.core.PersistentVector.EMPTY;
var inst_34189 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34190 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34188,inst_34189);
var inst_34191 = [inst_34186,inst_34190];
var inst_34192 = (new cljs.core.PersistentVector(null,2,(5),inst_34187,inst_34191,null));
var state_34215__$1 = state_34215;
var statearr_34231_34278 = state_34215__$1;
(statearr_34231_34278[(2)] = inst_34192);

(statearr_34231_34278[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (25))){
var inst_34171 = (state_34215[(13)]);
var inst_34177 = (state_34215[(2)]);
var inst_34178 = fluree.db.util.async.throw_err(inst_34177);
var state_34215__$1 = (function (){var statearr_34232 = state_34215;
(statearr_34232[(8)] = inst_34178);

return statearr_34232;
})();
if(cljs.core.truth_(inst_34171)){
var statearr_34233_34279 = state_34215__$1;
(statearr_34233_34279[(1)] = (26));

} else {
var statearr_34234_34280 = state_34215__$1;
(statearr_34234_34280[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (17))){
var state_34215__$1 = state_34215;
var statearr_34235_34281 = state_34215__$1;
(statearr_34235_34281[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (3))){
var inst_34213 = (state_34215[(2)]);
var state_34215__$1 = state_34215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34215__$1,inst_34213);
} else {
if((state_val_34216 === (12))){
var inst_34145 = (state_34215[(9)]);
var inst_34144 = (state_34215[(2)]);
var inst_34145__$1 = fluree.db.util.async.throw_err(inst_34144);
var inst_34146 = fluree.db.util.core.exception_QMARK_(inst_34145__$1);
var state_34215__$1 = (function (){var statearr_34237 = state_34215;
(statearr_34237[(9)] = inst_34145__$1);

return statearr_34237;
})();
if(inst_34146){
var statearr_34238_34282 = state_34215__$1;
(statearr_34238_34282[(1)] = (13));

} else {
var statearr_34239_34283 = state_34215__$1;
(statearr_34239_34283[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (2))){
var inst_34128 = (state_34215[(7)]);
var _ = (function (){var statearr_34240 = state_34215;
(statearr_34240[(4)] = cljs.core.cons((5),(state_34215[(4)])));

return statearr_34240;
})();
var inst_34128__$1 = cljs.core.first(clause);
var inst_34129 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_34128__$1);
var state_34215__$1 = (function (){var statearr_34241 = state_34215;
(statearr_34241[(7)] = inst_34128__$1);

return statearr_34241;
})();
if(inst_34129){
var statearr_34242_34284 = state_34215__$1;
(statearr_34242_34284[(1)] = (6));

} else {
var statearr_34243_34285 = state_34215__$1;
(statearr_34243_34285[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (23))){
var inst_34128 = (state_34215[(7)]);
var inst_34194 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34128)," is not supported in Fluree"].join('');
var inst_34195 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34196 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34197 = cljs.core.PersistentHashMap.fromArrays(inst_34195,inst_34196);
var inst_34198 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34194,inst_34197);
var inst_34199 = (function(){throw inst_34198})();
var state_34215__$1 = state_34215;
var statearr_34244_34286 = state_34215__$1;
(statearr_34244_34286[(2)] = inst_34199);

(statearr_34244_34286[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (19))){
var inst_34169 = (state_34215[(12)]);
var inst_34128 = (state_34215[(7)]);
var inst_34166 = fluree.db.query.analytical.isolate_source_name(inst_34128);
var inst_34167 = fluree.db.query.analytical.isolate_source_block(inst_34128);
var inst_34168 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_34166);
var inst_34169__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_34168);
var state_34215__$1 = (function (){var statearr_34245 = state_34215;
(statearr_34245[(11)] = inst_34167);

(statearr_34245[(12)] = inst_34169__$1);

return statearr_34245;
})();
if(cljs.core.truth_(inst_34169__$1)){
var statearr_34246_34287 = state_34215__$1;
(statearr_34246_34287[(1)] = (22));

} else {
var statearr_34247_34288 = state_34215__$1;
(statearr_34247_34288[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (11))){
var inst_34208 = (state_34215[(2)]);
var state_34215__$1 = state_34215;
var statearr_34249_34289 = state_34215__$1;
(statearr_34249_34289[(2)] = inst_34208);

(statearr_34249_34289[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (9))){
var inst_34128 = (state_34215[(7)]);
var inst_34140 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_34128,(4));
var inst_34141 = fluree.db.query.analytical.parse_block_from_source(inst_34140);
var inst_34142 = fluree.db.time_travel.as_of_block(db,inst_34141);
var state_34215__$1 = state_34215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34215__$1,(12),inst_34142);
} else {
if((state_val_34216 === (5))){
var _ = (function (){var statearr_34250 = state_34215;
(statearr_34250[(4)] = cljs.core.rest((state_34215[(4)])));

return statearr_34250;
})();
var state_34215__$1 = state_34215;
var ex34248 = (state_34215__$1[(2)]);
var statearr_34251_34290 = state_34215__$1;
(statearr_34251_34290[(5)] = ex34248);


if((ex34248 instanceof Error)){
var statearr_34252_34291 = state_34215__$1;
(statearr_34252_34291[(1)] = (4));

(statearr_34252_34291[(5)] = null);

} else {
throw ex34248;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (14))){
var state_34215__$1 = state_34215;
var statearr_34253_34292 = state_34215__$1;
(statearr_34253_34292[(2)] = null);

(statearr_34253_34292[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (26))){
var inst_34171 = (state_34215[(13)]);
var inst_34178 = (state_34215[(8)]);
var inst_34180 = fluree.db.time_travel.as_of_block(inst_34178,inst_34171);
var state_34215__$1 = state_34215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34215__$1,(29),inst_34180);
} else {
if((state_val_34216 === (16))){
var inst_34161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34162 = ["$wd",clause];
var inst_34163 = (new cljs.core.PersistentVector(null,2,(5),inst_34161,inst_34162,null));
var state_34215__$1 = state_34215;
var statearr_34254_34293 = state_34215__$1;
(statearr_34254_34293[(2)] = inst_34163);

(statearr_34254_34293[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (10))){
var inst_34128 = (state_34215[(7)]);
var inst_34159 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_34128);
var state_34215__$1 = state_34215;
if(inst_34159){
var statearr_34255_34294 = state_34215__$1;
(statearr_34255_34294[(1)] = (16));

} else {
var statearr_34256_34295 = state_34215__$1;
(statearr_34256_34295[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (18))){
var inst_34206 = (state_34215[(2)]);
var state_34215__$1 = state_34215;
var statearr_34257_34296 = state_34215__$1;
(statearr_34257_34296[(2)] = inst_34206);

(statearr_34257_34296[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34216 === (8))){
var inst_34210 = (state_34215[(2)]);
var _ = (function (){var statearr_34258 = state_34215;
(statearr_34258[(4)] = cljs.core.rest((state_34215[(4)])));

return statearr_34258;
})();
var state_34215__$1 = state_34215;
var statearr_34259_34297 = state_34215__$1;
(statearr_34259_34297[(2)] = inst_34210);

(statearr_34259_34297[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16301__auto__ = null;
var fluree$db$query$analytical$state_machine__16301__auto____0 = (function (){
var statearr_34260 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34260[(0)] = fluree$db$query$analytical$state_machine__16301__auto__);

(statearr_34260[(1)] = (1));

return statearr_34260;
});
var fluree$db$query$analytical$state_machine__16301__auto____1 = (function (state_34215){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34215);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34261){var ex__16304__auto__ = e34261;
var statearr_34262_34298 = state_34215;
(statearr_34262_34298[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34215[(4)]))){
var statearr_34263_34299 = state_34215;
(statearr_34263_34299[(1)] = cljs.core.first((state_34215[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34300 = state_34215;
state_34215 = G__34300;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16301__auto__ = function(state_34215){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16301__auto____1.call(this,state_34215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16301__auto____0;
fluree$db$query$analytical$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16301__auto____1;
return fluree$db$query$analytical$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34264 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34264[(6)] = c__16375__auto__);

return statearr_34264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__34301){
var vec__34302 = p__34301;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34302,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34302,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34305_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__34305_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__34309 = subjects;
var vec__34310 = G__34309;
var seq__34311 = cljs.core.seq(vec__34310);
var first__34312 = cljs.core.first(seq__34311);
var seq__34311__$1 = cljs.core.next(seq__34311);
var subject = first__34312;
var r = seq__34311__$1;
var acc = expanded_map;
var G__34309__$1 = G__34309;
var acc__$1 = acc;
while(true){
var vec__34316 = G__34309__$1;
var seq__34317 = cljs.core.seq(vec__34316);
var first__34318 = cljs.core.first(seq__34317);
var seq__34317__$1 = cljs.core.next(seq__34317);
var subject__$1 = first__34318;
var r__$1 = seq__34317__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__34319 = r__$1;
var G__34320 = acc__$2;
G__34309__$1 = G__34319;
acc__$1 = G__34320;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__34309__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__34316,seq__34317,first__34318,seq__34317__$1,subject__$1,r__$1,acc__$2,G__34309,vec__34310,seq__34311,first__34312,seq__34311__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__34309__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34316,seq__34317,first__34318,seq__34317__$1,subject__$1,r__$1,acc__$2,G__34309,vec__34310,seq__34311,first__34312,seq__34311__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__34309__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34316,seq__34317,first__34318,seq__34317__$1,subject__$1,r__$1,acc__$2,G__34309,vec__34310,seq__34311,first__34312,seq__34311__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__34309__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34316,seq__34317,first__34318,seq__34317__$1,subject__$1,r__$1,acc__$2,G__34309,vec__34310,seq__34311,first__34312,seq__34311__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__34309__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34316,seq__34317,first__34318,seq__34317__$1,subject__$1,r__$1,acc__$2,G__34309,vec__34310,seq__34311,first__34312,seq__34311__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__34309__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__34316,seq__34317,first__34318,seq__34317__$1,subject__$1,r__$1,acc__$2,G__34309,vec__34310,seq__34311,first__34312,seq__34311__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__34321 = r__$1;
var G__34322 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__34309__$1 = G__34321;
acc__$1 = G__34322;
continue;
} else {
var G__34323 = subjects;
var G__34324 = acc_STAR_;
G__34309__$1 = G__34323;
acc__$1 = G__34324;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34325_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__34325_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34416){
var state_val_34417 = (state_34416[(1)]);
if((state_val_34417 === (7))){
var state_34416__$1 = state_34416;
var statearr_34418_34464 = state_34416__$1;
(statearr_34418_34464[(2)] = (100));

(statearr_34418_34464[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (20))){
var inst_34365 = (state_34416[(7)]);
var state_34416__$1 = state_34416;
var statearr_34419_34465 = state_34416__$1;
(statearr_34419_34465[(2)] = inst_34365);

(statearr_34419_34465[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (1))){
var state_34416__$1 = state_34416;
var statearr_34420_34466 = state_34416__$1;
(statearr_34420_34466[(2)] = null);

(statearr_34420_34466[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (24))){
var inst_34402 = (state_34416[(8)]);
var inst_34337 = (state_34416[(9)]);
var inst_34403 = (state_34416[(10)]);
var inst_34404 = (state_34416[(11)]);
var inst_34407 = (function (){var max_depth = inst_34337;
var recur_map__$1 = inst_34403;
var subjects = inst_34402;
var tuples = inst_34404;
return (function (p1__34326_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__34326_SHARP_)],null));
});
})();
var inst_34408 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34407,inst_34404);
var inst_34409 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_34408);
var state_34416__$1 = state_34416;
var statearr_34421_34467 = state_34416__$1;
(statearr_34421_34467[(2)] = inst_34409);

(statearr_34421_34467[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (4))){
var inst_34327 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
var statearr_34422_34468 = state_34416__$1;
(statearr_34422_34468[(2)] = inst_34327);

(statearr_34422_34468[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (15))){
var inst_34350 = (state_34416[(12)]);
var inst_34361 = cljs.core.PersistentVector.EMPTY;
var inst_34362 = cljs.core.seq(inst_34350);
var inst_34363 = cljs.core.first(inst_34362);
var inst_34364 = cljs.core.next(inst_34362);
var inst_34365 = inst_34361;
var inst_34366 = inst_34350;
var state_34416__$1 = (function (){var statearr_34423 = state_34416;
(statearr_34423[(13)] = inst_34364);

(statearr_34423[(7)] = inst_34365);

(statearr_34423[(14)] = inst_34366);

(statearr_34423[(15)] = inst_34363);

return statearr_34423;
})();
var statearr_34424_34469 = state_34416__$1;
(statearr_34424_34469[(2)] = null);

(statearr_34424_34469[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (21))){
var inst_34386 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
var statearr_34425_34470 = state_34416__$1;
(statearr_34425_34470[(2)] = inst_34386);

(statearr_34425_34470[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (13))){
var inst_34399 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
var statearr_34426_34471 = state_34416__$1;
(statearr_34426_34471[(2)] = inst_34399);

(statearr_34426_34471[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (22))){
var inst_34365 = (state_34416[(7)]);
var inst_34373 = (state_34416[(16)]);
var inst_34380 = (state_34416[(2)]);
var inst_34381 = fluree.db.util.async.throw_err(inst_34380);
var inst_34382 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_34365,inst_34381);
var inst_34365__$1 = inst_34382;
var inst_34366 = inst_34373;
var state_34416__$1 = (function (){var statearr_34427 = state_34416;
(statearr_34427[(7)] = inst_34365__$1);

(statearr_34427[(14)] = inst_34366);

return statearr_34427;
})();
var statearr_34428_34472 = state_34416__$1;
(statearr_34428_34472[(2)] = null);

(statearr_34428_34472[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (6))){
var inst_34333 = (state_34416[(17)]);
var state_34416__$1 = state_34416;
var statearr_34429_34473 = state_34416__$1;
(statearr_34429_34473[(2)] = inst_34333);

(statearr_34429_34473[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (25))){
var inst_34411 = (state_34416[(2)]);
var _ = (function (){var statearr_34430 = state_34416;
(statearr_34430[(4)] = cljs.core.rest((state_34416[(4)])));

return statearr_34430;
})();
var state_34416__$1 = state_34416;
var statearr_34431_34474 = state_34416__$1;
(statearr_34431_34474[(2)] = inst_34411);

(statearr_34431_34474[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (17))){
var inst_34372 = (state_34416[(18)]);
var inst_34366 = (state_34416[(14)]);
var inst_34371 = cljs.core.seq(inst_34366);
var inst_34372__$1 = cljs.core.first(inst_34371);
var inst_34373 = cljs.core.next(inst_34371);
var state_34416__$1 = (function (){var statearr_34432 = state_34416;
(statearr_34432[(18)] = inst_34372__$1);

(statearr_34432[(16)] = inst_34373);

return statearr_34432;
})();
if(cljs.core.truth_(inst_34372__$1)){
var statearr_34433_34475 = state_34416__$1;
(statearr_34433_34475[(1)] = (19));

} else {
var statearr_34434_34476 = state_34416__$1;
(statearr_34434_34476[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (3))){
var inst_34414 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34416__$1,inst_34414);
} else {
if((state_val_34417 === (12))){
var inst_34339 = (state_34416[(19)]);
var inst_34350 = (state_34416[(12)]);
var inst_34345 = cljs.core.vals(inst_34339);
var inst_34346 = cljs.core.flatten(inst_34345);
var inst_34347 = cljs.core.set(inst_34346);
var inst_34348 = cljs.core.keys(inst_34339);
var inst_34349 = cljs.core.set(inst_34348);
var inst_34350__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_34347,inst_34349);
var inst_34351 = cljs.core.empty_QMARK_(inst_34350__$1);
var state_34416__$1 = (function (){var statearr_34435 = state_34416;
(statearr_34435[(12)] = inst_34350__$1);

return statearr_34435;
})();
if(inst_34351){
var statearr_34436_34477 = state_34416__$1;
(statearr_34436_34477[(1)] = (14));

} else {
var statearr_34437_34478 = state_34416__$1;
(statearr_34437_34478[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (2))){
var inst_34333 = (state_34416[(17)]);
var _ = (function (){var statearr_34438 = state_34416;
(statearr_34438[(4)] = cljs.core.cons((5),(state_34416[(4)])));

return statearr_34438;
})();
var inst_34333__$1 = depth;
var state_34416__$1 = (function (){var statearr_34439 = state_34416;
(statearr_34439[(17)] = inst_34333__$1);

return statearr_34439;
})();
if(cljs.core.truth_(inst_34333__$1)){
var statearr_34440_34479 = state_34416__$1;
(statearr_34440_34479[(1)] = (6));

} else {
var statearr_34441_34480 = state_34416__$1;
(statearr_34441_34480[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (23))){
var inst_34404 = (state_34416[(11)]);
var state_34416__$1 = state_34416;
var statearr_34442_34481 = state_34416__$1;
(statearr_34442_34481[(2)] = inst_34404);

(statearr_34442_34481[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (19))){
var inst_34372 = (state_34416[(18)]);
var inst_34375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34376 = [inst_34372,predicate];
var inst_34377 = (new cljs.core.PersistentVector(null,2,(5),inst_34375,inst_34376,null));
var inst_34378 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34377);
var state_34416__$1 = state_34416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34416__$1,(22),inst_34378);
} else {
if((state_val_34417 === (11))){
var inst_34339 = (state_34416[(19)]);
var state_34416__$1 = state_34416;
var statearr_34444_34482 = state_34416__$1;
(statearr_34444_34482[(2)] = inst_34339);

(statearr_34444_34482[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (9))){
var inst_34337 = (state_34416[(9)]);
var inst_34340 = (state_34416[(20)]);
var inst_34342 = (inst_34340 >= inst_34337);
var state_34416__$1 = state_34416;
if(cljs.core.truth_(inst_34342)){
var statearr_34445_34483 = state_34416__$1;
(statearr_34445_34483[(1)] = (11));

} else {
var statearr_34446_34484 = state_34416__$1;
(statearr_34446_34484[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (5))){
var _ = (function (){var statearr_34447 = state_34416;
(statearr_34447[(4)] = cljs.core.rest((state_34416[(4)])));

return statearr_34447;
})();
var state_34416__$1 = state_34416;
var ex34443 = (state_34416__$1[(2)]);
var statearr_34448_34485 = state_34416__$1;
(statearr_34448_34485[(5)] = ex34443);


if((ex34443 instanceof Error)){
var statearr_34449_34486 = state_34416__$1;
(statearr_34449_34486[(1)] = (4));

(statearr_34449_34486[(5)] = null);

} else {
throw ex34443;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (14))){
var inst_34339 = (state_34416[(19)]);
var state_34416__$1 = state_34416;
var statearr_34450_34487 = state_34416__$1;
(statearr_34450_34487[(2)] = inst_34339);

(statearr_34450_34487[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (16))){
var inst_34397 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
var statearr_34451_34488 = state_34416__$1;
(statearr_34451_34488[(2)] = inst_34397);

(statearr_34451_34488[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (10))){
var inst_34402 = (state_34416[(8)]);
var inst_34403 = (state_34416[(10)]);
var inst_34401 = (state_34416[(2)]);
var inst_34402__$1 = cljs.core.keys(inst_34401);
var inst_34403__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_34402__$1,inst_34401);
var inst_34404 = fluree.db.query.analytical.recur_map__GT_tuples(inst_34402__$1,inst_34403__$1);
var state_34416__$1 = (function (){var statearr_34452 = state_34416;
(statearr_34452[(8)] = inst_34402__$1);

(statearr_34452[(10)] = inst_34403__$1);

(statearr_34452[(11)] = inst_34404);

return statearr_34452;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_34453_34489 = state_34416__$1;
(statearr_34453_34489[(1)] = (23));

} else {
var statearr_34454_34490 = state_34416__$1;
(statearr_34454_34490[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (18))){
var inst_34339 = (state_34416[(19)]);
var inst_34340 = (state_34416[(20)]);
var inst_34388 = (state_34416[(2)]);
var inst_34389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34390 = [(0),(2)];
var inst_34391 = (new cljs.core.PersistentVector(null,2,(5),inst_34389,inst_34390,null));
var inst_34392 = fluree.db.query.analytical.get_ns_arrays(inst_34391,inst_34388);
var inst_34393 = fluree.db.query.analytical.tuples__GT_map(inst_34339,inst_34392);
var inst_34394 = (inst_34340 + (1));
var inst_34339__$1 = inst_34393;
var inst_34340__$1 = inst_34394;
var state_34416__$1 = (function (){var statearr_34455 = state_34416;
(statearr_34455[(19)] = inst_34339__$1);

(statearr_34455[(20)] = inst_34340__$1);

return statearr_34455;
})();
var statearr_34456_34491 = state_34416__$1;
(statearr_34456_34491[(2)] = null);

(statearr_34456_34491[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (8))){
var inst_34337 = (state_34416[(2)]);
var inst_34338 = recur_map;
var inst_34339 = inst_34338;
var inst_34340 = (1);
var state_34416__$1 = (function (){var statearr_34457 = state_34416;
(statearr_34457[(9)] = inst_34337);

(statearr_34457[(19)] = inst_34339);

(statearr_34457[(20)] = inst_34340);

return statearr_34457;
})();
var statearr_34458_34492 = state_34416__$1;
(statearr_34458_34492[(2)] = null);

(statearr_34458_34492[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____0 = (function (){
var statearr_34459 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34459[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__);

(statearr_34459[(1)] = (1));

return statearr_34459;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____1 = (function (state_34416){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34416);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34460){var ex__16304__auto__ = e34460;
var statearr_34461_34493 = state_34416;
(statearr_34461_34493[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34416[(4)]))){
var statearr_34462_34494 = state_34416;
(statearr_34462_34494[(1)] = cljs.core.first((state_34416[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34495 = state_34416;
state_34416 = G__34495;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__ = function(state_34416){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____1.call(this,state_34416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34463 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34463[(6)] = c__16375__auto__);

return statearr_34463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__34496,clause,fuel,max_fuel){
var map__34497 = p__34496;
var map__34497__$1 = (((((!((map__34497 == null))))?(((((map__34497.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34497.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34497):map__34497);
var res = map__34497__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34497__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34497__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34497__$1,cljs.core.cst$kw$vars);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34629){
var state_val_34630 = (state_34629[(1)]);
if((state_val_34630 === (7))){
var state_34629__$1 = state_34629;
var statearr_34631_34697 = state_34629__$1;
(statearr_34631_34697[(2)] = false);

(statearr_34631_34697[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (20))){
var inst_34561 = (state_34629[(7)]);
var state_34629__$1 = state_34629;
var statearr_34632_34698 = state_34629__$1;
(statearr_34632_34698[(2)] = inst_34561);

(statearr_34632_34698[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (27))){
var inst_34565 = (state_34629[(8)]);
var inst_34589 = (state_34629[(2)]);
var state_34629__$1 = (function (){var statearr_34633 = state_34629;
(statearr_34633[(9)] = inst_34589);

return statearr_34633;
})();
if(cljs.core.truth_(inst_34565)){
var statearr_34634_34699 = state_34629__$1;
(statearr_34634_34699[(1)] = (28));

} else {
var statearr_34635_34700 = state_34629__$1;
(statearr_34635_34700[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (1))){
var state_34629__$1 = state_34629;
var statearr_34636_34701 = state_34629__$1;
(statearr_34636_34701[(2)] = null);

(statearr_34636_34701[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (24))){
var inst_34577 = (state_34629[(2)]);
var inst_34578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_34579 = fluree.db.query.analytical.variable_QMARK_(inst_34578);
var state_34629__$1 = (function (){var statearr_34637 = state_34629;
(statearr_34637[(10)] = inst_34577);

return statearr_34637;
})();
if(cljs.core.truth_(inst_34579)){
var statearr_34638_34702 = state_34629__$1;
(statearr_34638_34702[(1)] = (25));

} else {
var statearr_34639_34703 = state_34629__$1;
(statearr_34639_34703[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (4))){
var inst_34499 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
var statearr_34640_34704 = state_34629__$1;
(statearr_34640_34704[(2)] = inst_34499);

(statearr_34640_34704[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (15))){
var inst_34547 = (state_34629[(11)]);
var state_34629__$1 = state_34629;
var statearr_34641_34705 = state_34629__$1;
(statearr_34641_34705[(2)] = inst_34547);

(statearr_34641_34705[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (21))){
var inst_34532 = (state_34629[(12)]);
var inst_34620 = (state_34629[(2)]);
var inst_34621 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_34622 = cljs.core.keys(inst_34532);
var inst_34623 = [inst_34622,vars,inst_34620];
var inst_34624 = cljs.core.PersistentHashMap.fromArrays(inst_34621,inst_34623);
var _ = (function (){var statearr_34642 = state_34629;
(statearr_34642[(4)] = cljs.core.rest((state_34629[(4)])));

return statearr_34642;
})();
var state_34629__$1 = state_34629;
var statearr_34643_34706 = state_34629__$1;
(statearr_34643_34706[(2)] = inst_34624);

(statearr_34643_34706[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (31))){
var inst_34561 = (state_34629[(7)]);
var inst_34563 = (state_34629[(13)]);
var inst_34596 = cljs.core.PersistentHashMap.EMPTY;
var inst_34597 = cljs.core.flatten(inst_34561);
var inst_34598 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34596,inst_34563,inst_34597);
var state_34629__$1 = state_34629;
var statearr_34644_34707 = state_34629__$1;
(statearr_34644_34707[(2)] = inst_34598);

(statearr_34644_34707[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (32))){
var inst_34563 = (state_34629[(13)]);
var inst_34600 = cljs.core.coll_QMARK_(inst_34563);
var state_34629__$1 = state_34629;
if(inst_34600){
var statearr_34645_34708 = state_34629__$1;
(statearr_34645_34708[(1)] = (34));

} else {
var statearr_34646_34709 = state_34629__$1;
(statearr_34646_34709[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (33))){
var inst_34611 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
var statearr_34647_34710 = state_34629__$1;
(statearr_34647_34710[(2)] = inst_34611);

(statearr_34647_34710[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (13))){
var inst_34509 = (state_34629[(14)]);
var state_34629__$1 = state_34629;
var statearr_34648_34711 = state_34629__$1;
(statearr_34648_34711[(2)] = inst_34509);

(statearr_34648_34711[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (22))){
var inst_34545 = (state_34629[(15)]);
var inst_34569 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34545)].join('');
var inst_34570 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34571 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34572 = cljs.core.PersistentHashMap.fromArrays(inst_34570,inst_34571);
var inst_34573 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34569,inst_34572);
var inst_34574 = (function(){throw inst_34573})();
var state_34629__$1 = state_34629;
var statearr_34649_34712 = state_34629__$1;
(statearr_34649_34712[(2)] = inst_34574);

(statearr_34649_34712[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (36))){
var inst_34609 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
var statearr_34650_34713 = state_34629__$1;
(statearr_34650_34713[(2)] = inst_34609);

(statearr_34650_34713[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (29))){
var inst_34563 = (state_34629[(13)]);
var inst_34594 = typeof inst_34563 === 'number';
var state_34629__$1 = state_34629;
if(cljs.core.truth_(inst_34594)){
var statearr_34651_34714 = state_34629__$1;
(statearr_34651_34714[(1)] = (31));

} else {
var statearr_34652_34715 = state_34629__$1;
(statearr_34652_34715[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (6))){
var inst_34509 = (state_34629[(14)]);
var inst_34514 = inst_34509.cljs$lang$protocol_mask$partition0$;
var inst_34515 = (inst_34514 & (64));
var inst_34516 = inst_34509.cljs$core$ISeq$;
var inst_34517 = (cljs.core.PROTOCOL_SENTINEL === inst_34516);
var inst_34518 = ((inst_34515) || (inst_34517));
var state_34629__$1 = state_34629;
if(cljs.core.truth_(inst_34518)){
var statearr_34653_34716 = state_34629__$1;
(statearr_34653_34716[(1)] = (9));

} else {
var statearr_34654_34717 = state_34629__$1;
(statearr_34654_34717[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (28))){
var inst_34561 = (state_34629[(7)]);
var inst_34591 = cljs.core.PersistentHashMap.EMPTY;
var inst_34592 = fluree.db.query.analytical.tuples__GT_map(inst_34591,inst_34561);
var state_34629__$1 = state_34629;
var statearr_34655_34718 = state_34629__$1;
(statearr_34655_34718[(2)] = inst_34592);

(statearr_34655_34718[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (25))){
var state_34629__$1 = state_34629;
var statearr_34656_34719 = state_34629__$1;
(statearr_34656_34719[(2)] = null);

(statearr_34656_34719[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (34))){
var inst_34561 = (state_34629[(7)]);
var inst_34557 = (state_34629[(16)]);
var inst_34602 = cljs.core.PersistentHashMap.EMPTY;
var inst_34603 = cljs.core.first(inst_34557);
var inst_34604 = cljs.core.first(inst_34603);
var inst_34605 = cljs.core.flatten(inst_34561);
var inst_34606 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34602,inst_34604,inst_34605);
var state_34629__$1 = state_34629;
var statearr_34657_34720 = state_34629__$1;
(statearr_34657_34720[(2)] = inst_34606);

(statearr_34657_34720[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (17))){
var inst_34546 = (state_34629[(17)]);
var inst_34545 = (state_34629[(15)]);
var inst_34551 = (state_34629[(2)]);
var inst_34552 = [inst_34551];
var inst_34553 = cljs.core.PersistentHashMap.fromArrays(inst_34546,inst_34552);
var inst_34554 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_34545,inst_34553);
var state_34629__$1 = state_34629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34629__$1,(18),inst_34554);
} else {
if((state_val_34630 === (3))){
var inst_34627 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34629__$1,inst_34627);
} else {
if((state_val_34630 === (12))){
var inst_34509 = (state_34629[(14)]);
var inst_34527 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_34509);
var state_34629__$1 = state_34629;
var statearr_34658_34721 = state_34629__$1;
(statearr_34658_34721[(2)] = inst_34527);

(statearr_34658_34721[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (2))){
var inst_34509 = (state_34629[(14)]);
var _ = (function (){var statearr_34659 = state_34629;
(statearr_34659[(4)] = cljs.core.cons((5),(state_34629[(4)])));

return statearr_34659;
})();
var inst_34509__$1 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_34511 = (inst_34509__$1 == null);
var inst_34512 = cljs.core.not(inst_34511);
var state_34629__$1 = (function (){var statearr_34660 = state_34629;
(statearr_34660[(14)] = inst_34509__$1);

return statearr_34660;
})();
if(inst_34512){
var statearr_34661_34722 = state_34629__$1;
(statearr_34661_34722[(1)] = (6));

} else {
var statearr_34662_34723 = state_34629__$1;
(statearr_34662_34723[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (23))){
var state_34629__$1 = state_34629;
var statearr_34663_34724 = state_34629__$1;
(statearr_34663_34724[(2)] = null);

(statearr_34663_34724[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (35))){
var state_34629__$1 = state_34629;
var statearr_34664_34725 = state_34629__$1;
(statearr_34664_34725[(2)] = null);

(statearr_34664_34725[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (19))){
var inst_34545 = (state_34629[(15)]);
var inst_34566 = (state_34629[(18)]);
var inst_34563 = cljs.core.first(inst_34545);
var inst_34564 = cljs.core.first(clause);
var inst_34565 = fluree.db.query.analytical.variable_QMARK_(inst_34564);
var inst_34566__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_34545,(1));
var inst_34567 = fluree.db.query.analytical.variable_QMARK_(inst_34566__$1);
var state_34629__$1 = (function (){var statearr_34665 = state_34629;
(statearr_34665[(8)] = inst_34565);

(statearr_34665[(13)] = inst_34563);

(statearr_34665[(18)] = inst_34566__$1);

return statearr_34665;
})();
if(cljs.core.truth_(inst_34567)){
var statearr_34666_34726 = state_34629__$1;
(statearr_34666_34726[(1)] = (22));

} else {
var statearr_34667_34727 = state_34629__$1;
(statearr_34667_34727[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (11))){
var inst_34522 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
var statearr_34669_34728 = state_34629__$1;
(statearr_34669_34728[(2)] = inst_34522);

(statearr_34669_34728[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (9))){
var state_34629__$1 = state_34629;
var statearr_34670_34729 = state_34629__$1;
(statearr_34670_34729[(2)] = true);

(statearr_34670_34729[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (5))){
var _ = (function (){var statearr_34671 = state_34629;
(statearr_34671[(4)] = cljs.core.rest((state_34629[(4)])));

return statearr_34671;
})();
var state_34629__$1 = state_34629;
var ex34668 = (state_34629__$1[(2)]);
var statearr_34672_34730 = state_34629__$1;
(statearr_34672_34730[(5)] = ex34668);


if((ex34668 instanceof Error)){
var statearr_34673_34731 = state_34629__$1;
(statearr_34673_34731[(1)] = (4));

(statearr_34673_34731[(5)] = null);

} else {
throw ex34668;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (14))){
var inst_34535 = (state_34629[(19)]);
var inst_34536 = (state_34629[(20)]);
var inst_34532 = (state_34629[(12)]);
var inst_34547 = (state_34629[(11)]);
var inst_34530 = (state_34629[(2)]);
var inst_34531 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34530,cljs.core.cst$kw$search);
var inst_34532__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34530,cljs.core.cst$kw$rel);
var inst_34533 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34530,cljs.core.cst$kw$opts);
var inst_34534 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_34535__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_34533);
var inst_34536__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_34533);
var inst_34538 = (function (){var map__34505 = inst_34530;
var search = inst_34531;
var rel = inst_34532__$1;
var opts = inst_34533;
var common_keys = inst_34534;
var object_fn = inst_34535__$1;
var recur_depth = inst_34536__$1;
return (function (p__34537,common_key){
var vec__34674 = p__34537;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34674,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34674,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__34677 = cljs.core._EQ_;
var expr__34678 = idx_of;
if(cljs.core.truth_((pred__34677.cljs$core$IFn$_invoke$arity$2 ? pred__34677.cljs$core$IFn$_invoke$arity$2((0),expr__34678) : pred__34677.call(null,(0),expr__34678)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__34677.cljs$core$IFn$_invoke$arity$2 ? pred__34677.cljs$core$IFn$_invoke$arity$2((1),expr__34678) : pred__34677.call(null,(1),expr__34678)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__34677.cljs$core$IFn$_invoke$arity$2 ? pred__34677.cljs$core$IFn$_invoke$arity$2((2),expr__34678) : pred__34677.call(null,(2),expr__34678)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__34678)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_34539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34540 = cljs.core.PersistentHashMap.EMPTY;
var inst_34541 = [inst_34540,inst_34531];
var inst_34542 = (new cljs.core.PersistentVector(null,2,(5),inst_34539,inst_34541,null));
var inst_34543 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34538,inst_34542,inst_34534);
var inst_34544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34543,(0),null);
var inst_34545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34543,(1),null);
var inst_34546 = [cljs.core.cst$kw$object_DASH_fn];
var inst_34547__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_34544);
var state_34629__$1 = (function (){var statearr_34680 = state_34629;
(statearr_34680[(19)] = inst_34535__$1);

(statearr_34680[(20)] = inst_34536__$1);

(statearr_34680[(17)] = inst_34546);

(statearr_34680[(15)] = inst_34545);

(statearr_34680[(12)] = inst_34532__$1);

(statearr_34680[(11)] = inst_34547__$1);

return statearr_34680;
})();
if(cljs.core.truth_(inst_34547__$1)){
var statearr_34681_34732 = state_34629__$1;
(statearr_34681_34732[(1)] = (15));

} else {
var statearr_34682_34733 = state_34629__$1;
(statearr_34682_34733[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (26))){
var inst_34545 = (state_34629[(15)]);
var inst_34582 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34545)].join('');
var inst_34583 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34584 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34585 = cljs.core.PersistentHashMap.fromArrays(inst_34583,inst_34584);
var inst_34586 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34582,inst_34585);
var inst_34587 = (function(){throw inst_34586})();
var state_34629__$1 = state_34629;
var statearr_34683_34734 = state_34629__$1;
(statearr_34683_34734[(2)] = inst_34587);

(statearr_34683_34734[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (16))){
var inst_34535 = (state_34629[(19)]);
var state_34629__$1 = state_34629;
var statearr_34684_34735 = state_34629__$1;
(statearr_34684_34735[(2)] = inst_34535);

(statearr_34684_34735[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (30))){
var inst_34536 = (state_34629[(20)]);
var inst_34565 = (state_34629[(8)]);
var inst_34566 = (state_34629[(18)]);
var inst_34613 = (state_34629[(2)]);
var inst_34614 = fluree.db.query.analytical.tuples__GT_recur(db,inst_34566,inst_34613,inst_34536,inst_34565);
var state_34629__$1 = state_34629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34629__$1,(37),inst_34614);
} else {
if((state_val_34630 === (10))){
var state_34629__$1 = state_34629;
var statearr_34685_34736 = state_34629__$1;
(statearr_34685_34736[(2)] = false);

(statearr_34685_34736[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (18))){
var inst_34536 = (state_34629[(20)]);
var inst_34557 = (state_34629[(16)]);
var inst_34532 = (state_34629[(12)]);
var inst_34556 = (state_34629[(2)]);
var inst_34557__$1 = fluree.db.util.async.throw_err(inst_34556);
var inst_34558 = cljs.core.count(inst_34557__$1);
var inst_34559 = fluree.db.query.analytical.add_fuel(inst_34558,fuel,max_fuel);
var inst_34560 = cljs.core.vals(inst_34532);
var inst_34561 = fluree.db.query.analytical.get_ns_arrays(inst_34560,inst_34557__$1);
var state_34629__$1 = (function (){var statearr_34686 = state_34629;
(statearr_34686[(21)] = inst_34559);

(statearr_34686[(7)] = inst_34561);

(statearr_34686[(16)] = inst_34557__$1);

return statearr_34686;
})();
if(cljs.core.truth_(inst_34536)){
var statearr_34687_34737 = state_34629__$1;
(statearr_34687_34737[(1)] = (19));

} else {
var statearr_34688_34738 = state_34629__$1;
(statearr_34688_34738[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (37))){
var inst_34616 = (state_34629[(2)]);
var inst_34617 = fluree.db.util.async.throw_err(inst_34616);
var state_34629__$1 = state_34629;
var statearr_34689_34739 = state_34629__$1;
(statearr_34689_34739[(2)] = inst_34617);

(statearr_34689_34739[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (8))){
var inst_34525 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
if(cljs.core.truth_(inst_34525)){
var statearr_34690_34740 = state_34629__$1;
(statearr_34690_34740[(1)] = (12));

} else {
var statearr_34691_34741 = state_34629__$1;
(statearr_34691_34741[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_34692 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34692[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__);

(statearr_34692[(1)] = (1));

return statearr_34692;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____1 = (function (state_34629){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34629);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34693){var ex__16304__auto__ = e34693;
var statearr_34694_34742 = state_34629;
(statearr_34694_34742[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34629[(4)]))){
var statearr_34695_34743 = state_34629;
(statearr_34695_34743[(1)] = cljs.core.first((state_34629[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34744 = state_34629;
state_34629 = G__34744;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__ = function(state_34629){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____1.call(this,state_34629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34696 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34696[(6)] = c__16375__auto__);

return statearr_34696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(db,res,clause){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34843){
var state_val_34844 = (state_34843[(1)]);
if((state_val_34844 === (7))){
var inst_34754 = (state_34843[(7)]);
var state_34843__$1 = state_34843;
var statearr_34845_34885 = state_34843__$1;
(statearr_34845_34885[(2)] = inst_34754);

(statearr_34845_34885[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (20))){
var inst_34834 = (state_34843[(2)]);
var state_34843__$1 = state_34843;
var statearr_34846_34886 = state_34843__$1;
(statearr_34846_34886[(2)] = inst_34834);

(statearr_34846_34886[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (1))){
var state_34843__$1 = state_34843;
var statearr_34847_34887 = state_34843__$1;
(statearr_34847_34887[(2)] = null);

(statearr_34847_34887[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (24))){
var inst_34813 = (state_34843[(2)]);
var inst_34814 = fluree.db.util.async.throw_err(inst_34813);
var state_34843__$1 = state_34843;
var statearr_34848_34888 = state_34843__$1;
(statearr_34848_34888[(2)] = inst_34814);

(statearr_34848_34888[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (4))){
var inst_34747 = (state_34843[(2)]);
var state_34843__$1 = state_34843;
var statearr_34849_34889 = state_34843__$1;
(statearr_34849_34889[(2)] = inst_34747);

(statearr_34849_34889[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (15))){
var inst_34754 = (state_34843[(7)]);
var inst_34756 = (state_34843[(8)]);
var inst_34775 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_34776 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_34777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34778 = [inst_34754];
var inst_34779 = (new cljs.core.PersistentVector(null,1,(5),inst_34777,inst_34778,null));
var inst_34780 = (function (){var subject_var = inst_34754;
var object_var = inst_34756;
var min_sid = inst_34775;
var max_sid = (0);
return (function (p1__34745_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__34745_SHARP_);
});
})();
var inst_34781 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_34775,(0));
var inst_34782 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34780,inst_34781);
var inst_34783 = cljs.core.PersistentHashMap.EMPTY;
var inst_34784 = [inst_34779,inst_34782,inst_34783];
var inst_34785 = cljs.core.PersistentHashMap.fromArrays(inst_34776,inst_34784);
var state_34843__$1 = state_34843;
var statearr_34850_34890 = state_34843__$1;
(statearr_34850_34890[(2)] = inst_34785);

(statearr_34850_34890[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (21))){
var inst_34807 = (state_34843[(9)]);
var state_34843__$1 = state_34843;
var statearr_34851_34891 = state_34843__$1;
(statearr_34851_34891[(2)] = inst_34807);

(statearr_34851_34891[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (13))){
var inst_34756 = (state_34843[(8)]);
var state_34843__$1 = state_34843;
if(cljs.core.truth_(inst_34756)){
var statearr_34852_34892 = state_34843__$1;
(statearr_34852_34892[(1)] = (18));

} else {
var statearr_34853_34893 = state_34843__$1;
(statearr_34853_34893[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (22))){
var inst_34807 = (state_34843[(9)]);
var inst_34811 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_34807);
var state_34843__$1 = state_34843;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34843__$1,(24),inst_34811);
} else {
if((state_val_34844 === (6))){
var inst_34756 = (state_34843[(8)]);
var state_34843__$1 = state_34843;
var statearr_34854_34894 = state_34843__$1;
(statearr_34854_34894[(2)] = inst_34756);

(statearr_34854_34894[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (17))){
var inst_34804 = (state_34843[(2)]);
var state_34843__$1 = state_34843;
var statearr_34855_34895 = state_34843__$1;
(statearr_34855_34895[(2)] = inst_34804);

(statearr_34855_34895[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (3))){
var inst_34841 = (state_34843[(2)]);
var state_34843__$1 = state_34843;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34843__$1,inst_34841);
} else {
if((state_val_34844 === (12))){
var inst_34769 = ["_tx",null,"_block",null];
var inst_34770 = (new cljs.core.PersistentArrayMap(null,2,inst_34769,null));
var inst_34771 = (new cljs.core.PersistentHashSet(null,inst_34770,null));
var inst_34772 = cljs.core.last(clause);
var inst_34773 = (inst_34771.cljs$core$IFn$_invoke$arity$1 ? inst_34771.cljs$core$IFn$_invoke$arity$1(inst_34772) : inst_34771.call(null,inst_34772));
var state_34843__$1 = state_34843;
if(cljs.core.truth_(inst_34773)){
var statearr_34856_34896 = state_34843__$1;
(statearr_34856_34896[(1)] = (15));

} else {
var statearr_34857_34897 = state_34843__$1;
(statearr_34857_34897[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (2))){
var inst_34754 = (state_34843[(7)]);
var _ = (function (){var statearr_34858 = state_34843;
(statearr_34858[(4)] = cljs.core.cons((5),(state_34843[(4)])));

return statearr_34858;
})();
var inst_34753 = cljs.core.first(clause);
var inst_34754__$1 = fluree.db.query.analytical.variable_QMARK_(inst_34753);
var inst_34755 = cljs.core.last(clause);
var inst_34756 = fluree.db.query.analytical.variable_QMARK_(inst_34755);
var state_34843__$1 = (function (){var statearr_34859 = state_34843;
(statearr_34859[(7)] = inst_34754__$1);

(statearr_34859[(8)] = inst_34756);

return statearr_34859;
})();
if(cljs.core.truth_(inst_34754__$1)){
var statearr_34860_34898 = state_34843__$1;
(statearr_34860_34898[(1)] = (6));

} else {
var statearr_34861_34899 = state_34843__$1;
(statearr_34861_34899[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (23))){
var inst_34756 = (state_34843[(8)]);
var inst_34816 = (state_34843[(2)]);
var inst_34817 = fluree.db.flake.sid__GT_cid(inst_34816);
var inst_34818 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_34817);
var inst_34819 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_34820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34821 = [inst_34756];
var inst_34822 = (new cljs.core.PersistentVector(null,1,(5),inst_34820,inst_34821,null));
var inst_34823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34825 = [inst_34818];
var inst_34826 = (new cljs.core.PersistentVector(null,1,(5),inst_34824,inst_34825,null));
var inst_34827 = [inst_34826];
var inst_34828 = (new cljs.core.PersistentVector(null,1,(5),inst_34823,inst_34827,null));
var inst_34829 = cljs.core.PersistentHashMap.EMPTY;
var inst_34830 = [inst_34822,inst_34828,inst_34829];
var inst_34831 = cljs.core.PersistentHashMap.fromArrays(inst_34819,inst_34830);
var state_34843__$1 = state_34843;
var statearr_34862_34900 = state_34843__$1;
(statearr_34862_34900[(2)] = inst_34831);

(statearr_34862_34900[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (19))){
var state_34843__$1 = state_34843;
var statearr_34863_34901 = state_34843__$1;
(statearr_34863_34901[(2)] = null);

(statearr_34863_34901[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (11))){
var inst_34838 = (state_34843[(2)]);
var _ = (function (){var statearr_34865 = state_34843;
(statearr_34865[(4)] = cljs.core.rest((state_34843[(4)])));

return statearr_34865;
})();
var state_34843__$1 = state_34843;
var statearr_34866_34902 = state_34843__$1;
(statearr_34866_34902[(2)] = inst_34838);

(statearr_34866_34902[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (9))){
var inst_34762 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34763 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34764 = cljs.core.PersistentHashMap.fromArrays(inst_34762,inst_34763);
var inst_34765 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_34764);
var inst_34766 = (function(){throw inst_34765})();
var state_34843__$1 = state_34843;
var statearr_34867_34903 = state_34843__$1;
(statearr_34867_34903[(2)] = inst_34766);

(statearr_34867_34903[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (5))){
var _ = (function (){var statearr_34868 = state_34843;
(statearr_34868[(4)] = cljs.core.rest((state_34843[(4)])));

return statearr_34868;
})();
var state_34843__$1 = state_34843;
var ex34864 = (state_34843__$1[(2)]);
var statearr_34869_34904 = state_34843__$1;
(statearr_34869_34904[(5)] = ex34864);


if((ex34864 instanceof Error)){
var statearr_34870_34905 = state_34843__$1;
(statearr_34870_34905[(1)] = (4));

(statearr_34870_34905[(5)] = null);

} else {
throw ex34864;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (14))){
var inst_34836 = (state_34843[(2)]);
var state_34843__$1 = state_34843;
var statearr_34871_34906 = state_34843__$1;
(statearr_34871_34906[(2)] = inst_34836);

(statearr_34871_34906[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (16))){
var inst_34754 = (state_34843[(7)]);
var inst_34756 = (state_34843[(8)]);
var inst_34787 = cljs.core.last(clause);
var inst_34788 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,inst_34787);
var inst_34789 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_34790 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34789,inst_34788);
var inst_34791 = fluree.db.flake.min_subject_id(inst_34788);
var inst_34792 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_34793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34794 = [inst_34754];
var inst_34795 = (new cljs.core.PersistentVector(null,1,(5),inst_34793,inst_34794,null));
var inst_34796 = (function (){var subject_var = inst_34754;
var object_var = inst_34756;
var cid = inst_34788;
var max_sid = inst_34790;
var min_sid = inst_34791;
return (function (p1__34746_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__34746_SHARP_);
});
})();
var inst_34797 = (inst_34790 + (1));
var inst_34798 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_34791,inst_34797);
var inst_34799 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34796,inst_34798);
var inst_34800 = cljs.core.PersistentHashMap.EMPTY;
var inst_34801 = [inst_34795,inst_34799,inst_34800];
var inst_34802 = cljs.core.PersistentHashMap.fromArrays(inst_34792,inst_34801);
var state_34843__$1 = state_34843;
var statearr_34872_34907 = state_34843__$1;
(statearr_34872_34907[(2)] = inst_34802);

(statearr_34872_34907[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (10))){
var inst_34754 = (state_34843[(7)]);
var state_34843__$1 = state_34843;
if(cljs.core.truth_(inst_34754)){
var statearr_34873_34908 = state_34843__$1;
(statearr_34873_34908[(1)] = (12));

} else {
var statearr_34874_34909 = state_34843__$1;
(statearr_34874_34909[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (18))){
var inst_34807 = (state_34843[(9)]);
var inst_34807__$1 = cljs.core.first(clause);
var inst_34808 = typeof inst_34807__$1 === 'number';
var state_34843__$1 = (function (){var statearr_34875 = state_34843;
(statearr_34875[(9)] = inst_34807__$1);

return statearr_34875;
})();
if(cljs.core.truth_(inst_34808)){
var statearr_34876_34910 = state_34843__$1;
(statearr_34876_34910[(1)] = (21));

} else {
var statearr_34877_34911 = state_34843__$1;
(statearr_34877_34911[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34844 === (8))){
var inst_34760 = (state_34843[(2)]);
var state_34843__$1 = state_34843;
if(cljs.core.truth_(inst_34760)){
var statearr_34878_34912 = state_34843__$1;
(statearr_34878_34912[(1)] = (9));

} else {
var statearr_34879_34913 = state_34843__$1;
(statearr_34879_34913[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_34880 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34880[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__);

(statearr_34880[(1)] = (1));

return statearr_34880;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____1 = (function (state_34843){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34843);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34881){var ex__16304__auto__ = e34881;
var statearr_34882_34914 = state_34843;
(statearr_34882_34914[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34843[(4)]))){
var statearr_34883_34915 = state_34843;
(statearr_34883_34915[(1)] = cljs.core.first((state_34843[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34916 = state_34843;
state_34843 = G__34916;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__ = function(state_34843){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____1.call(this,state_34843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34884 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34884[(6)] = c__16375__auto__);

return statearr_34884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__34923 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__34923 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__34923;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__34924(s__34925){
return (new cljs.core.LazySeq(null,(function (){
var s__34925__$1 = s__34925;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__34925__$1);
if(temp__5735__auto__){
var s__34925__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34925__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__34925__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__34927 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__34926 = (0);
while(true){
if((i__34926 < size__4528__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__34926);
var delta = (x - mean);
cljs.core.chunk_append(b__34927,(delta * delta));

var G__34929 = (i__34926 + (1));
i__34926 = G__34929;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34927),fluree$db$query$analytical$variance_$_iter__34924(cljs.core.chunk_rest(s__34925__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34927),null);
}
} else {
var x = cljs.core.first(s__34925__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__34924(cljs.core.rest(s__34925__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__34928 = variance(coll);
return Math.sqrt(G__34928);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__34930 = null;
var G__34930__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__34930__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__34930 = function(n,coll){
switch(arguments.length){
case 1:
return G__34930__1.call(this,n);
case 2:
return G__34930__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34930.cljs$core$IFn$_invoke$arity$1 = G__34930__1;
G__34930.cljs$core$IFn$_invoke$arity$2 = G__34930__2;
return G__34930;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__34931 = null;
var G__34931__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__34931__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__34931 = function(n,coll){
switch(arguments.length){
case 1:
return G__34931__1.call(this,n);
case 2:
return G__34931__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34931.cljs$core$IFn$_invoke$arity$1 = G__34931__1;
G__34931.cljs$core$IFn$_invoke$arity$2 = G__34931__2;
return G__34931;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__34932 = null;
var G__34932__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__34932__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__34932 = function(n,coll){
switch(arguments.length){
case 1:
return G__34932__1.call(this,n);
case 2:
return G__34932__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34932.cljs$core$IFn$_invoke$arity$1 = G__34932__1;
G__34932.cljs$core$IFn$_invoke$arity$2 = G__34932__2;
return G__34932;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__34933 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34933,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34933,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34933,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__34936 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__34939 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__34939) : agg_fn.call(null,G__34939));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34936,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34936,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__34940 = agg;
var map__34940__$1 = (((((!((map__34940 == null))))?(((((map__34940.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34940.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34940):map__34940);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34940__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34940__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34940__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__34943 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34943,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34943,(1),null);
var map__34946 = res__$1;
var map__34946__$1 = (((((!((map__34946 == null))))?(((((map__34946.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34946.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34946):map__34946);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34946__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34946__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34942_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__34942_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34948_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__34948_SHARP_);
}),a_idxs);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,b_tuple){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34949_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34949_SHARP_);
}),b_idxs))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34950_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34950_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34951_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__34951_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__34954,row,b_tuple){
var vec__34955 = p__34954;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34955,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34955,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34952_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34952_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34953_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34953_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34958_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__34958_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34959_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__34959_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34964 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34966 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__34965 = (function (p1__34960_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34960_SHARP_);
});
return fexpr__34965(G__34966);
})()),cljs.core.set(b_idxs));
var fexpr__34963 = (function (p1__34961_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34961_SHARP_);
});
return fexpr__34963(G__34964);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
return fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34962_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__34962_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34967_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__34967_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34968_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34968_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34973 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34975 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__34974 = (function (p1__34969_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34969_SHARP_);
});
return fexpr__34974(G__34975);
})()),cljs.core.set(b_idxs));
var fexpr__34972 = (function (p1__34970_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34970_SHARP_);
});
return fexpr__34972(G__34973);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
var matches = fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34971_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34971_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34976_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__34976_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34977_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34977_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34986 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34988 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__34987 = (function (p1__34978_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34978_SHARP_);
});
return fexpr__34987(G__34988);
})()),cljs.core.set(b_idxs));
var fexpr__34985 = (function (p1__34979_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34979_SHARP_);
});
return fexpr__34985(G__34986);
})();
var vec__34982 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__34989,a_tuple){
var vec__34990 = p__34989;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34990,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34990,(1),null);
var vec__34993 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34993,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34993,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34982,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34982,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34980_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34980_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34981_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34981_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__34997 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34997,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34997,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__34996_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__34996_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__35002 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35002,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35002,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35000_SHARP_){
return fluree.db.util.core.index_of(headers,p1__35000_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__35001_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__35001_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__35005,filters,optional_QMARK_){
var map__35006 = p__35005;
var map__35006__$1 = (((((!((map__35006 == null))))?(((((map__35006.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35006.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35006):map__35006);
var tuple_map = map__35006__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35006__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35006__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35006__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__35008 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35008,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35008,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__35011 = res;
var map__35011__$1 = (((((!((map__35011 == null))))?(((((map__35011.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35011.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35011):map__35011);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35011__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35011__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5733__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35068){
var state_val_35069 = (state_35068[(1)]);
if((state_val_35069 === (7))){
var inst_35042 = (state_35068[(7)]);
var inst_35040 = (state_35068[(2)]);
var inst_35041 = fluree.db.util.async.throw_err(inst_35040);
var inst_35042__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35041,(0),null);
var inst_35043 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35041,(1),null);
var inst_35044 = (inst_35042__$1 == null);
var state_35068__$1 = (function (){var statearr_35070 = state_35068;
(statearr_35070[(7)] = inst_35042__$1);

(statearr_35070[(8)] = inst_35043);

return statearr_35070;
})();
if(cljs.core.truth_(inst_35044)){
var statearr_35071_35100 = state_35068__$1;
(statearr_35071_35100[(1)] = (8));

} else {
var statearr_35072_35101 = state_35068__$1;
(statearr_35072_35101[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (1))){
var inst_35020 = optional_clauses;
var inst_35021 = cljs.core.seq(inst_35020);
var inst_35022 = cljs.core.first(inst_35021);
var inst_35023 = cljs.core.next(inst_35021);
var inst_35024 = where_tuples;
var inst_35025 = inst_35020;
var inst_35026 = inst_35024;
var state_35068__$1 = (function (){var statearr_35073 = state_35068;
(statearr_35073[(9)] = inst_35026);

(statearr_35073[(10)] = inst_35023);

(statearr_35073[(11)] = inst_35022);

(statearr_35073[(12)] = inst_35025);

return statearr_35073;
})();
var statearr_35074_35102 = state_35068__$1;
(statearr_35074_35102[(2)] = null);

(statearr_35074_35102[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (4))){
var inst_35026 = (state_35068[(9)]);
var inst_35033 = (state_35068[(13)]);
var inst_35032 = (state_35068[(14)]);
var inst_35038 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_35026,inst_35032,inst_35033,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_35026,inst_35032,inst_35033,true,fuel,max_fuel,opts));
var state_35068__$1 = state_35068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35068__$1,(7),inst_35038);
} else {
if((state_val_35069 === (15))){
var state_35068__$1 = state_35068;
var statearr_35075_35103 = state_35068__$1;
(statearr_35075_35103[(2)] = null);

(statearr_35075_35103[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (13))){
var inst_35059 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
var statearr_35076_35104 = state_35068__$1;
(statearr_35076_35104[(2)] = inst_35059);

(statearr_35076_35104[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (6))){
var inst_35064 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
var statearr_35077_35105 = state_35068__$1;
(statearr_35077_35105[(2)] = inst_35064);

(statearr_35077_35105[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (3))){
var inst_35066 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35068__$1,inst_35066);
} else {
if((state_val_35069 === (12))){
var state_35068__$1 = state_35068;
var statearr_35078_35106 = state_35068__$1;
(statearr_35078_35106[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (2))){
var inst_35032 = (state_35068[(14)]);
var inst_35025 = (state_35068[(12)]);
var inst_35031 = cljs.core.seq(inst_35025);
var inst_35032__$1 = cljs.core.first(inst_35031);
var inst_35033 = cljs.core.next(inst_35031);
var state_35068__$1 = (function (){var statearr_35080 = state_35068;
(statearr_35080[(13)] = inst_35033);

(statearr_35080[(14)] = inst_35032__$1);

return statearr_35080;
})();
if(cljs.core.truth_(inst_35032__$1)){
var statearr_35081_35107 = state_35068__$1;
(statearr_35081_35107[(1)] = (4));

} else {
var statearr_35082_35108 = state_35068__$1;
(statearr_35082_35108[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (11))){
var inst_35042 = (state_35068[(7)]);
var inst_35043 = (state_35068[(8)]);
var inst_35025 = inst_35043;
var inst_35026 = inst_35042;
var state_35068__$1 = (function (){var statearr_35083 = state_35068;
(statearr_35083[(9)] = inst_35026);

(statearr_35083[(12)] = inst_35025);

return statearr_35083;
})();
var statearr_35084_35109 = state_35068__$1;
(statearr_35084_35109[(2)] = null);

(statearr_35084_35109[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (9))){
var inst_35032 = (state_35068[(14)]);
var inst_35048 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_35032);
var state_35068__$1 = state_35068;
if(cljs.core.truth_(inst_35048)){
var statearr_35085_35110 = state_35068__$1;
(statearr_35085_35110[(1)] = (11));

} else {
var statearr_35086_35111 = state_35068__$1;
(statearr_35086_35111[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (5))){
var inst_35026 = (state_35068[(9)]);
var state_35068__$1 = state_35068;
var statearr_35087_35112 = state_35068__$1;
(statearr_35087_35112[(2)] = inst_35026);

(statearr_35087_35112[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (14))){
var inst_35026 = (state_35068[(9)]);
var inst_35042 = (state_35068[(7)]);
var inst_35043 = (state_35068[(8)]);
var inst_35053 = fluree.db.query.analytical.left_outer_join(inst_35026,inst_35042);
var inst_35025 = inst_35043;
var inst_35026__$1 = inst_35053;
var state_35068__$1 = (function (){var statearr_35088 = state_35068;
(statearr_35088[(9)] = inst_35026__$1);

(statearr_35088[(12)] = inst_35025);

return statearr_35088;
})();
var statearr_35089_35113 = state_35068__$1;
(statearr_35089_35113[(2)] = null);

(statearr_35089_35113[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (16))){
var inst_35057 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
var statearr_35091_35114 = state_35068__$1;
(statearr_35091_35114[(2)] = inst_35057);

(statearr_35091_35114[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (10))){
var inst_35061 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
var statearr_35092_35115 = state_35068__$1;
(statearr_35092_35115[(2)] = inst_35061);

(statearr_35092_35115[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35069 === (8))){
var inst_35026 = (state_35068[(9)]);
var inst_35043 = (state_35068[(8)]);
var tmp35090 = inst_35026;
var inst_35025 = inst_35043;
var inst_35026__$1 = tmp35090;
var state_35068__$1 = (function (){var statearr_35093 = state_35068;
(statearr_35093[(9)] = inst_35026__$1);

(statearr_35093[(12)] = inst_35025);

return statearr_35093;
})();
var statearr_35094_35116 = state_35068__$1;
(statearr_35094_35116[(2)] = null);

(statearr_35094_35116[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____0 = (function (){
var statearr_35095 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35095[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__);

(statearr_35095[(1)] = (1));

return statearr_35095;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____1 = (function (state_35068){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35068);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35096){var ex__16304__auto__ = e35096;
var statearr_35097_35117 = state_35068;
(statearr_35097_35117[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35068[(4)]))){
var statearr_35098_35118 = state_35068;
(statearr_35098_35118[(1)] = cljs.core.first((state_35068[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35119 = state_35068;
state_35068 = G__35119;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__ = function(state_35068){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____1.call(this,state_35068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35099 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35099[(6)] = c__16375__auto__);

return statearr_35099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__35121){
var vec__35122 = p__35121;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35122,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35122,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35120_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35120_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__35126,p__35127,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__35128 = p__35126;
var map__35128__$1 = (((((!((map__35128 == null))))?(((((map__35128.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35128.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35128):map__35128);
var q_map = map__35128__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35128__$1,cljs.core.cst$kw$prefixes);
var map__35129 = p__35127;
var map__35129__$1 = (((((!((map__35129 == null))))?(((((map__35129.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35129.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35129):map__35129);
var res = map__35129__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35129__$1,cljs.core.cst$kw$vars);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35338){
var state_val_35339 = (state_35338[(1)]);
if((state_val_35339 === (7))){
var inst_35236 = cljs.core.count(clause);
var inst_35237 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_35236);
var inst_35238 = cljs.core.second(clause);
var inst_35239 = clojure.string.starts_with_QMARK_(inst_35238,"fullText:");
var inst_35240 = ((inst_35237) && (inst_35239));
var state_35338__$1 = state_35338;
if(cljs.core.truth_(inst_35240)){
var statearr_35340_35435 = state_35338__$1;
(statearr_35340_35435[(1)] = (31));

} else {
var statearr_35341_35436 = state_35338__$1;
(statearr_35341_35436[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (59))){
var inst_35307 = (state_35338[(7)]);
var inst_35310 = (state_35338[(2)]);
var inst_35311 = fluree.db.util.async.throw_err(inst_35310);
var inst_35312 = [inst_35311,r];
var inst_35313 = (new cljs.core.PersistentVector(null,2,(5),inst_35307,inst_35312,null));
var state_35338__$1 = state_35338;
var statearr_35342_35437 = state_35338__$1;
(statearr_35342_35437[(2)] = inst_35313);

(statearr_35342_35437[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (20))){
var inst_35200 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35343_35438 = state_35338__$1;
(statearr_35343_35438[(2)] = inst_35200);

(statearr_35343_35438[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (58))){
var inst_35316 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35344_35439 = state_35338__$1;
(statearr_35344_35439[(2)] = inst_35316);

(statearr_35344_35439[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (27))){
var inst_35230 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35345_35440 = state_35338__$1;
(statearr_35345_35440[(2)] = inst_35230);

(statearr_35345_35440[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (1))){
var state_35338__$1 = state_35338;
var statearr_35346_35441 = state_35338__$1;
(statearr_35346_35441[(2)] = null);

(statearr_35346_35441[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (24))){
var inst_35194 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35347_35442 = state_35338__$1;
(statearr_35347_35442[(2)] = inst_35194);

(statearr_35347_35442[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (55))){
var inst_35318 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35348_35443 = state_35338__$1;
(statearr_35348_35443[(2)] = inst_35318);

(statearr_35348_35443[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (39))){
var inst_35272 = cljs.core.count(clause);
var inst_35273 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_35272);
var state_35338__$1 = state_35338;
if(inst_35273){
var statearr_35349_35444 = state_35338__$1;
(statearr_35349_35444[(1)] = (42));

} else {
var statearr_35350_35445 = state_35338__$1;
(statearr_35350_35445[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (46))){
var state_35338__$1 = state_35338;
var statearr_35351_35446 = state_35338__$1;
(statearr_35351_35446[(2)] = null);

(statearr_35351_35446[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (4))){
var inst_35132 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35352_35447 = state_35338__$1;
(statearr_35352_35447[(2)] = inst_35132);

(statearr_35352_35447[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (54))){
var state_35338__$1 = state_35338;
var statearr_35353_35448 = state_35338__$1;
(statearr_35353_35448[(1)] = (56));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (15))){
var inst_35232 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35355_35449 = state_35338__$1;
(statearr_35355_35449[(2)] = inst_35232);

(statearr_35355_35449[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (48))){
var inst_35289 = (state_35338[(8)]);
var inst_35287 = (state_35338[(2)]);
var inst_35288 = fluree.db.util.async.throw_err(inst_35287);
var inst_35289__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35288,(0),null);
var inst_35290 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35288,(1),null);
var inst_35291 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_35289__$1);
var state_35338__$1 = (function (){var statearr_35356 = state_35338;
(statearr_35356[(8)] = inst_35289__$1);

(statearr_35356[(9)] = inst_35290);

return statearr_35356;
})();
if(inst_35291){
var statearr_35357_35450 = state_35338__$1;
(statearr_35357_35450[(1)] = (49));

} else {
var statearr_35358_35451 = state_35338__$1;
(statearr_35358_35451[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (50))){
var inst_35290 = (state_35338[(9)]);
var inst_35298 = cljs.core.second(inst_35290);
var inst_35299 = clojure.string.starts_with_QMARK_(inst_35298,"fullText:");
var state_35338__$1 = state_35338;
if(inst_35299){
var statearr_35359_35452 = state_35338__$1;
(statearr_35359_35452[(1)] = (53));

} else {
var statearr_35360_35453 = state_35338__$1;
(statearr_35360_35453[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (21))){
var inst_35177 = (state_35338[(10)]);
var inst_35145 = (state_35338[(11)]);
var inst_35170 = (state_35338[(12)]);
var inst_35168 = (state_35338[(13)]);
var inst_35166 = (state_35338[(14)]);
var inst_35171 = (state_35338[(15)]);
var inst_35178 = (state_35338[(16)]);
var inst_35169 = (state_35338[(17)]);
var inst_35141 = (state_35338[(18)]);
var inst_35182 = (state_35338[(2)]);
var inst_35183 = fluree.db.util.async.throw_err(inst_35182);
var inst_35184 = (function (){var vec__35163 = inst_35166;
var new_res = inst_35183;
var rest = inst_35178;
var expr__35143 = inst_35141;
var tuples = inst_35171;
var pred__35142 = inst_35145;
var first__35165 = inst_35168;
var first__35175 = inst_35177;
var vec__35173 = inst_35170;
var segment_type = inst_35141;
var seq__35164 = inst_35169;
var seq__35174 = inst_35178;
var clause_group = inst_35177;
var G__35162 = inst_35170;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_35185 = cljs.core.keys(vars);
var inst_35186 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35184,inst_35183,inst_35185);
var inst_35187 = fluree.db.query.analytical.res_absorb_vars(inst_35186);
var state_35338__$1 = (function (){var statearr_35361 = state_35338;
(statearr_35361[(19)] = inst_35187);

return statearr_35361;
})();
if(cljs.core.truth_(inst_35171)){
var statearr_35362_35454 = state_35338__$1;
(statearr_35362_35454[(1)] = (22));

} else {
var statearr_35363_35455 = state_35338__$1;
(statearr_35363_35455[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (31))){
var inst_35242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35243 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_35244 = [inst_35243,r];
var inst_35245 = (new cljs.core.PersistentVector(null,2,(5),inst_35242,inst_35244,null));
var state_35338__$1 = state_35338;
var statearr_35364_35456 = state_35338__$1;
(statearr_35364_35456[(2)] = inst_35245);

(statearr_35364_35456[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (32))){
var inst_35247 = cljs.core.count(clause);
var inst_35248 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_35247);
var inst_35249 = cljs.core.second(clause);
var inst_35250 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35249,"rdf:type");
var inst_35251 = ((inst_35248) && (inst_35250));
var state_35338__$1 = state_35338;
if(cljs.core.truth_(inst_35251)){
var statearr_35365_35457 = state_35338__$1;
(statearr_35365_35457[(1)] = (34));

} else {
var statearr_35366_35458 = state_35338__$1;
(statearr_35366_35458[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (40))){
var inst_35327 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35367_35459 = state_35338__$1;
(statearr_35367_35459[(2)] = inst_35327);

(statearr_35367_35459[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (56))){
var inst_35289 = (state_35338[(8)]);
var inst_35290 = (state_35338[(9)]);
var inst_35307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35308 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_35289,res,inst_35290,fuel,max_fuel);
var state_35338__$1 = (function (){var statearr_35368 = state_35338;
(statearr_35368[(7)] = inst_35307);

return statearr_35368;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35338__$1,(59),inst_35308);
} else {
if((state_val_35339 === (33))){
var inst_35331 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35369_35460 = state_35338__$1;
(statearr_35369_35460[(2)] = inst_35331);

(statearr_35369_35460[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (13))){
var inst_35166 = (state_35338[(14)]);
var inst_35166__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35167 = cljs.core.seq(inst_35166__$1);
var inst_35168 = cljs.core.first(inst_35167);
var inst_35169 = cljs.core.next(inst_35167);
var inst_35170 = inst_35166__$1;
var inst_35171 = null;
var state_35338__$1 = (function (){var statearr_35370 = state_35338;
(statearr_35370[(12)] = inst_35170);

(statearr_35370[(13)] = inst_35168);

(statearr_35370[(14)] = inst_35166__$1);

(statearr_35370[(15)] = inst_35171);

(statearr_35370[(17)] = inst_35169);

return statearr_35370;
})();
var statearr_35371_35461 = state_35338__$1;
(statearr_35371_35461[(2)] = null);

(statearr_35371_35461[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (22))){
var inst_35187 = (state_35338[(19)]);
var inst_35171 = (state_35338[(15)]);
var inst_35178 = (state_35338[(16)]);
var inst_35189 = fluree.db.query.analytical.outer_union(inst_35171,inst_35187);
var inst_35170 = inst_35178;
var inst_35171__$1 = inst_35189;
var state_35338__$1 = (function (){var statearr_35372 = state_35338;
(statearr_35372[(12)] = inst_35170);

(statearr_35372[(15)] = inst_35171__$1);

return statearr_35372;
})();
var statearr_35373_35462 = state_35338__$1;
(statearr_35373_35462[(2)] = null);

(statearr_35373_35462[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (36))){
var inst_35329 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35374_35463 = state_35338__$1;
(statearr_35374_35463[(2)] = inst_35329);

(statearr_35374_35463[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (41))){
var inst_35264 = (state_35338[(20)]);
var inst_35267 = (state_35338[(2)]);
var inst_35268 = fluree.db.util.async.throw_err(inst_35267);
var inst_35269 = [inst_35268,r];
var inst_35270 = (new cljs.core.PersistentVector(null,2,(5),inst_35264,inst_35269,null));
var state_35338__$1 = state_35338;
var statearr_35375_35464 = state_35338__$1;
(statearr_35375_35464[(2)] = inst_35270);

(statearr_35375_35464[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (43))){
var state_35338__$1 = state_35338;
var statearr_35376_35465 = state_35338__$1;
(statearr_35376_35465[(1)] = (45));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (29))){
var inst_35141 = (state_35338[(18)]);
var inst_35224 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35141)].join('');
var inst_35225 = (new Error(inst_35224));
var inst_35226 = (function(){throw inst_35225})();
var state_35338__$1 = state_35338;
var statearr_35378_35466 = state_35338__$1;
(statearr_35378_35466[(2)] = inst_35226);

(statearr_35378_35466[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (44))){
var inst_35325 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35379_35467 = state_35338__$1;
(statearr_35379_35467[(2)] = inst_35325);

(statearr_35379_35467[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (6))){
var inst_35145 = (state_35338[(11)]);
var inst_35141 = (state_35338[(18)]);
var inst_35140 = cljs.core.keys(clause);
var inst_35141__$1 = cljs.core.first(inst_35140);
var inst_35145__$1 = cljs.core._EQ_;
var inst_35146 = (function (){var G__35380 = cljs.core.cst$kw$optional;
var G__35381 = inst_35141__$1;
return (inst_35145__$1.cljs$core$IFn$_invoke$arity$2 ? inst_35145__$1.cljs$core$IFn$_invoke$arity$2(G__35380,G__35381) : inst_35145__$1.call(null,G__35380,G__35381));
})();
var state_35338__$1 = (function (){var statearr_35382 = state_35338;
(statearr_35382[(11)] = inst_35145__$1);

(statearr_35382[(18)] = inst_35141__$1);

return statearr_35382;
})();
if(cljs.core.truth_(inst_35146)){
var statearr_35383_35468 = state_35338__$1;
(statearr_35383_35468[(1)] = (9));

} else {
var statearr_35384_35469 = state_35338__$1;
(statearr_35384_35469[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (28))){
var inst_35218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35219 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35220 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_35219,optional_QMARK_);
var inst_35221 = [inst_35220,r];
var inst_35222 = (new cljs.core.PersistentVector(null,2,(5),inst_35218,inst_35221,null));
var state_35338__$1 = state_35338;
var statearr_35385_35470 = state_35338__$1;
(statearr_35385_35470[(2)] = inst_35222);

(statearr_35385_35470[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (51))){
var inst_35320 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35386_35471 = state_35338__$1;
(statearr_35386_35471[(2)] = inst_35320);

(statearr_35386_35471[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (25))){
var inst_35145 = (state_35338[(11)]);
var inst_35141 = (state_35338[(18)]);
var inst_35206 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35207 = (function (){var segment_type = inst_35141;
var pred__35142 = inst_35145;
var expr__35143 = inst_35141;
var bindings = inst_35206;
return (function (p1__35125_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__35125_SHARP_);
});
})();
var inst_35208 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35207,inst_35206);
var inst_35209 = cljs.core.PersistentHashMap.EMPTY;
var inst_35210 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35209,inst_35208);
var inst_35211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35212 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_35210);
var inst_35213 = [inst_35212,r];
var inst_35214 = (new cljs.core.PersistentVector(null,2,(5),inst_35211,inst_35213,null));
var state_35338__$1 = state_35338;
var statearr_35387_35472 = state_35338__$1;
(statearr_35387_35472[(2)] = inst_35214);

(statearr_35387_35472[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (34))){
var inst_35253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35254 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_35338__$1 = (function (){var statearr_35388 = state_35338;
(statearr_35388[(21)] = inst_35253);

return statearr_35388;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35338__$1,(37),inst_35254);
} else {
if((state_val_35339 === (17))){
var inst_35202 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35389_35473 = state_35338__$1;
(statearr_35389_35473[(2)] = inst_35202);

(statearr_35389_35473[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (3))){
var inst_35336 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35338__$1,inst_35336);
} else {
if((state_val_35339 === (12))){
var inst_35148 = (state_35338[(22)]);
var inst_35152 = (state_35338[(2)]);
var inst_35153 = fluree.db.util.async.throw_err(inst_35152);
var inst_35154 = [inst_35153,r];
var inst_35155 = (new cljs.core.PersistentVector(null,2,(5),inst_35148,inst_35154,null));
var state_35338__$1 = state_35338;
var statearr_35390_35474 = state_35338__$1;
(statearr_35390_35474[(2)] = inst_35155);

(statearr_35390_35474[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (2))){
var _ = (function (){var statearr_35391 = state_35338;
(statearr_35391[(4)] = cljs.core.cons((5),(state_35338[(4)])));

return statearr_35391;
})();
var inst_35138 = cljs.core.map_QMARK_(clause);
var state_35338__$1 = state_35338;
if(inst_35138){
var statearr_35392_35475 = state_35338__$1;
(statearr_35392_35475[(1)] = (6));

} else {
var statearr_35393_35476 = state_35338__$1;
(statearr_35393_35476[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (23))){
var inst_35187 = (state_35338[(19)]);
var inst_35178 = (state_35338[(16)]);
var inst_35170 = inst_35178;
var inst_35171 = inst_35187;
var state_35338__$1 = (function (){var statearr_35394 = state_35338;
(statearr_35394[(12)] = inst_35170);

(statearr_35394[(15)] = inst_35171);

return statearr_35394;
})();
var statearr_35395_35477 = state_35338__$1;
(statearr_35395_35477[(2)] = null);

(statearr_35395_35477[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (47))){
var inst_35323 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35396_35478 = state_35338__$1;
(statearr_35396_35478[(2)] = inst_35323);

(statearr_35396_35478[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (35))){
var inst_35261 = cljs.core.count(clause);
var inst_35262 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_35261);
var state_35338__$1 = state_35338;
if(inst_35262){
var statearr_35397_35479 = state_35338__$1;
(statearr_35397_35479[(1)] = (38));

} else {
var statearr_35398_35480 = state_35338__$1;
(statearr_35398_35480[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (19))){
var inst_35171 = (state_35338[(15)]);
var inst_35196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35197 = [inst_35171,r];
var inst_35198 = (new cljs.core.PersistentVector(null,2,(5),inst_35196,inst_35197,null));
var state_35338__$1 = state_35338;
var statearr_35399_35481 = state_35338__$1;
(statearr_35399_35481[(2)] = inst_35198);

(statearr_35399_35481[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (57))){
var state_35338__$1 = state_35338;
var statearr_35400_35482 = state_35338__$1;
(statearr_35400_35482[(2)] = null);

(statearr_35400_35482[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (11))){
var inst_35234 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35402_35483 = state_35338__$1;
(statearr_35402_35483[(2)] = inst_35234);

(statearr_35402_35483[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (9))){
var inst_35148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35149 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35150 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_35149,res,fuel,max_fuel,opts);
var state_35338__$1 = (function (){var statearr_35403 = state_35338;
(statearr_35403[(22)] = inst_35148);

return statearr_35403;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35338__$1,(12),inst_35150);
} else {
if((state_val_35339 === (5))){
var _ = (function (){var statearr_35404 = state_35338;
(statearr_35404[(4)] = cljs.core.rest((state_35338[(4)])));

return statearr_35404;
})();
var state_35338__$1 = state_35338;
var ex35401 = (state_35338__$1[(2)]);
var statearr_35405_35484 = state_35338__$1;
(statearr_35405_35484[(5)] = ex35401);


if((ex35401 instanceof Error)){
var statearr_35406_35485 = state_35338__$1;
(statearr_35406_35485[(1)] = (4));

(statearr_35406_35485[(5)] = null);

} else {
throw ex35401;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (14))){
var inst_35145 = (state_35338[(11)]);
var inst_35141 = (state_35338[(18)]);
var inst_35204 = (function (){var G__35407 = cljs.core.cst$kw$bind;
var G__35408 = inst_35141;
return (inst_35145.cljs$core$IFn$_invoke$arity$2 ? inst_35145.cljs$core$IFn$_invoke$arity$2(G__35407,G__35408) : inst_35145.call(null,G__35407,G__35408));
})();
var state_35338__$1 = state_35338;
if(cljs.core.truth_(inst_35204)){
var statearr_35409_35486 = state_35338__$1;
(statearr_35409_35486[(1)] = (25));

} else {
var statearr_35410_35487 = state_35338__$1;
(statearr_35410_35487[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (45))){
var inst_35285 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_35338__$1 = state_35338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35338__$1,(48),inst_35285);
} else {
if((state_val_35339 === (53))){
var inst_35289 = (state_35338[(8)]);
var inst_35290 = (state_35338[(9)]);
var inst_35301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35302 = fluree.db.query.analytical.full_text__GT_tuples(inst_35289,res,inst_35290);
var inst_35303 = [inst_35302,r];
var inst_35304 = (new cljs.core.PersistentVector(null,2,(5),inst_35301,inst_35303,null));
var state_35338__$1 = state_35338;
var statearr_35411_35488 = state_35338__$1;
(statearr_35411_35488[(2)] = inst_35304);

(statearr_35411_35488[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (26))){
var inst_35145 = (state_35338[(11)]);
var inst_35141 = (state_35338[(18)]);
var inst_35216 = (function (){var G__35412 = cljs.core.cst$kw$filter;
var G__35413 = inst_35141;
return (inst_35145.cljs$core$IFn$_invoke$arity$2 ? inst_35145.cljs$core$IFn$_invoke$arity$2(G__35412,G__35413) : inst_35145.call(null,G__35412,G__35413));
})();
var state_35338__$1 = state_35338;
if(cljs.core.truth_(inst_35216)){
var statearr_35414_35489 = state_35338__$1;
(statearr_35414_35489[(1)] = (28));

} else {
var statearr_35415_35490 = state_35338__$1;
(statearr_35415_35490[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (16))){
var inst_35177 = (state_35338[(10)]);
var inst_35170 = (state_35338[(12)]);
var inst_35176 = cljs.core.seq(inst_35170);
var inst_35177__$1 = cljs.core.first(inst_35176);
var inst_35178 = cljs.core.next(inst_35176);
var state_35338__$1 = (function (){var statearr_35416 = state_35338;
(statearr_35416[(10)] = inst_35177__$1);

(statearr_35416[(16)] = inst_35178);

return statearr_35416;
})();
if(cljs.core.truth_(inst_35177__$1)){
var statearr_35417_35491 = state_35338__$1;
(statearr_35417_35491[(1)] = (18));

} else {
var statearr_35418_35492 = state_35338__$1;
(statearr_35418_35492[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (38))){
var inst_35264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35265 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_35338__$1 = (function (){var statearr_35419 = state_35338;
(statearr_35419[(20)] = inst_35264);

return statearr_35419;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35338__$1,(41),inst_35265);
} else {
if((state_val_35339 === (30))){
var inst_35228 = (state_35338[(2)]);
var state_35338__$1 = state_35338;
var statearr_35420_35493 = state_35338__$1;
(statearr_35420_35493[(2)] = inst_35228);

(statearr_35420_35493[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (10))){
var inst_35145 = (state_35338[(11)]);
var inst_35141 = (state_35338[(18)]);
var inst_35157 = (function (){var G__35421 = cljs.core.cst$kw$union;
var G__35422 = inst_35141;
return (inst_35145.cljs$core$IFn$_invoke$arity$2 ? inst_35145.cljs$core$IFn$_invoke$arity$2(G__35421,G__35422) : inst_35145.call(null,G__35421,G__35422));
})();
var state_35338__$1 = state_35338;
if(cljs.core.truth_(inst_35157)){
var statearr_35423_35494 = state_35338__$1;
(statearr_35423_35494[(1)] = (13));

} else {
var statearr_35424_35495 = state_35338__$1;
(statearr_35424_35495[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (18))){
var inst_35177 = (state_35338[(10)]);
var inst_35180 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_35177,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_35177,q_map,vars,fuel,max_fuel,opts));
var state_35338__$1 = state_35338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35338__$1,(21),inst_35180);
} else {
if((state_val_35339 === (52))){
var inst_35295 = (state_35338[(2)]);
var inst_35296 = fluree.db.util.async.throw_err(inst_35295);
var state_35338__$1 = state_35338;
var statearr_35425_35496 = state_35338__$1;
(statearr_35425_35496[(2)] = inst_35296);

(statearr_35425_35496[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (42))){
var inst_35275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35276 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_35277 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_35276);
var inst_35278 = [inst_35277,r];
var inst_35279 = (new cljs.core.PersistentVector(null,2,(5),inst_35275,inst_35278,null));
var state_35338__$1 = state_35338;
var statearr_35426_35497 = state_35338__$1;
(statearr_35426_35497[(2)] = inst_35279);

(statearr_35426_35497[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (37))){
var inst_35253 = (state_35338[(21)]);
var inst_35256 = (state_35338[(2)]);
var inst_35257 = fluree.db.util.async.throw_err(inst_35256);
var inst_35258 = [inst_35257,r];
var inst_35259 = (new cljs.core.PersistentVector(null,2,(5),inst_35253,inst_35258,null));
var state_35338__$1 = state_35338;
var statearr_35427_35498 = state_35338__$1;
(statearr_35427_35498[(2)] = inst_35259);

(statearr_35427_35498[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (8))){
var inst_35333 = (state_35338[(2)]);
var _ = (function (){var statearr_35428 = state_35338;
(statearr_35428[(4)] = cljs.core.rest((state_35338[(4)])));

return statearr_35428;
})();
var state_35338__$1 = state_35338;
var statearr_35429_35499 = state_35338__$1;
(statearr_35429_35499[(2)] = inst_35333);

(statearr_35429_35499[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35339 === (49))){
var inst_35290 = (state_35338[(9)]);
var inst_35293 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_35290,r,res,optional_QMARK_,fuel,max_fuel);
var state_35338__$1 = state_35338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35338__$1,(52),inst_35293);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_35430 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35430[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__);

(statearr_35430[(1)] = (1));

return statearr_35430;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____1 = (function (state_35338){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35338);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35431){var ex__16304__auto__ = e35431;
var statearr_35432_35500 = state_35338;
(statearr_35432_35500[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35338[(4)]))){
var statearr_35433_35501 = state_35338;
(statearr_35433_35501[(1)] = cljs.core.first((state_35338[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35502 = state_35338;
state_35338 = G__35502;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__ = function(state_35338){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____1.call(this,state_35338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35434 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35434[(6)] = c__16375__auto__);

return statearr_35434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__35504 = arguments.length;
switch (G__35504) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35584){
var state_val_35585 = (state_35584[(1)]);
if((state_val_35585 === (7))){
var inst_35579 = (state_35584[(2)]);
var _ = (function (){var statearr_35586 = state_35584;
(statearr_35586[(4)] = cljs.core.rest((state_35584[(4)])));

return statearr_35586;
})();
var state_35584__$1 = state_35584;
var statearr_35587_35635 = state_35584__$1;
(statearr_35587_35635[(2)] = inst_35579);

(statearr_35587_35635[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (20))){
var inst_35544 = (state_35584[(7)]);
var inst_35556 = (state_35584[(2)]);
var inst_35526 = inst_35544;
var inst_35527 = inst_35556;
var state_35584__$1 = (function (){var statearr_35588 = state_35584;
(statearr_35588[(8)] = inst_35526);

(statearr_35588[(9)] = inst_35527);

return statearr_35588;
})();
var statearr_35589_35636 = state_35584__$1;
(statearr_35589_35636[(2)] = null);

(statearr_35589_35636[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (1))){
var state_35584__$1 = state_35584;
var statearr_35590_35637 = state_35584__$1;
(statearr_35590_35637[(2)] = null);

(statearr_35590_35637[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (24))){
var inst_35544 = (state_35584[(7)]);
var inst_35543 = (state_35584[(10)]);
var inst_35527 = (state_35584[(9)]);
var inst_35564 = fluree.db.query.analytical.inner_join(inst_35527,inst_35543);
var inst_35526 = inst_35544;
var inst_35527__$1 = inst_35564;
var state_35584__$1 = (function (){var statearr_35591 = state_35584;
(statearr_35591[(8)] = inst_35526);

(statearr_35591[(9)] = inst_35527__$1);

return statearr_35591;
})();
var statearr_35592_35638 = state_35584__$1;
(statearr_35592_35638[(2)] = null);

(statearr_35592_35638[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (4))){
var inst_35505 = (state_35584[(2)]);
var state_35584__$1 = state_35584;
var statearr_35594_35639 = state_35584__$1;
(statearr_35594_35639[(2)] = inst_35505);

(statearr_35594_35639[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (15))){
var inst_35543 = (state_35584[(10)]);
var state_35584__$1 = state_35584;
if(cljs.core.truth_(inst_35543)){
var statearr_35595_35640 = state_35584__$1;
(statearr_35595_35640[(1)] = (18));

} else {
var statearr_35596_35641 = state_35584__$1;
(statearr_35596_35641[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (21))){
var inst_35544 = (state_35584[(7)]);
var inst_35527 = (state_35584[(9)]);
var tmp35593 = inst_35527;
var inst_35526 = inst_35544;
var inst_35527__$1 = tmp35593;
var state_35584__$1 = (function (){var statearr_35597 = state_35584;
(statearr_35597[(8)] = inst_35526);

(statearr_35597[(9)] = inst_35527__$1);

return statearr_35597;
})();
var statearr_35598_35642 = state_35584__$1;
(statearr_35598_35642[(2)] = null);

(statearr_35598_35642[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (13))){
var inst_35527 = (state_35584[(9)]);
var inst_35550 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_35527,cljs.core.cst$kw$vars);
var inst_35551 = cljs.core.empty_QMARK_(inst_35550);
var state_35584__$1 = state_35584;
if(inst_35551){
var statearr_35599_35643 = state_35584__$1;
(statearr_35599_35643[(1)] = (15));

} else {
var statearr_35600_35644 = state_35584__$1;
(statearr_35600_35644[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (22))){
var state_35584__$1 = state_35584;
var statearr_35601_35645 = state_35584__$1;
(statearr_35601_35645[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (6))){
var inst_35526 = (state_35584[(8)]);
var inst_35533 = (state_35584[(11)]);
var inst_35532 = cljs.core.seq(inst_35526);
var inst_35533__$1 = cljs.core.first(inst_35532);
var inst_35534 = cljs.core.next(inst_35532);
var state_35584__$1 = (function (){var statearr_35603 = state_35584;
(statearr_35603[(11)] = inst_35533__$1);

(statearr_35603[(12)] = inst_35534);

return statearr_35603;
})();
if(cljs.core.truth_(inst_35533__$1)){
var statearr_35604_35646 = state_35584__$1;
(statearr_35604_35646[(1)] = (8));

} else {
var statearr_35605_35647 = state_35584__$1;
(statearr_35605_35647[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (25))){
var state_35584__$1 = state_35584;
var statearr_35606_35648 = state_35584__$1;
(statearr_35606_35648[(2)] = null);

(statearr_35606_35648[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (17))){
var inst_35572 = (state_35584[(2)]);
var state_35584__$1 = state_35584;
var statearr_35607_35649 = state_35584__$1;
(statearr_35607_35649[(2)] = inst_35572);

(statearr_35607_35649[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (3))){
var inst_35582 = (state_35584[(2)]);
var state_35584__$1 = state_35584;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35584__$1,inst_35582);
} else {
if((state_val_35585 === (12))){
var inst_35544 = (state_35584[(7)]);
var inst_35543 = (state_35584[(10)]);
var inst_35526 = inst_35544;
var inst_35527 = inst_35543;
var state_35584__$1 = (function (){var statearr_35608 = state_35584;
(statearr_35608[(8)] = inst_35526);

(statearr_35608[(9)] = inst_35527);

return statearr_35608;
})();
var statearr_35609_35650 = state_35584__$1;
(statearr_35609_35650[(2)] = null);

(statearr_35609_35650[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (2))){
var _ = (function (){var statearr_35610 = state_35584;
(statearr_35610[(4)] = cljs.core.cons((5),(state_35584[(4)])));

return statearr_35610;
})();
var inst_35518 = where;
var inst_35519 = cljs.core.seq(inst_35518);
var inst_35520 = cljs.core.first(inst_35519);
var inst_35521 = cljs.core.next(inst_35519);
var inst_35522 = [cljs.core.cst$kw$vars];
var inst_35523 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_35524 = [inst_35523];
var inst_35525 = cljs.core.PersistentHashMap.fromArrays(inst_35522,inst_35524);
var inst_35526 = inst_35518;
var inst_35527 = inst_35525;
var state_35584__$1 = (function (){var statearr_35611 = state_35584;
(statearr_35611[(8)] = inst_35526);

(statearr_35611[(13)] = inst_35520);

(statearr_35611[(14)] = inst_35521);

(statearr_35611[(9)] = inst_35527);

return statearr_35611;
})();
var statearr_35612_35651 = state_35584__$1;
(statearr_35612_35651[(2)] = null);

(statearr_35612_35651[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (23))){
var inst_35570 = (state_35584[(2)]);
var state_35584__$1 = state_35584;
var statearr_35613_35652 = state_35584__$1;
(statearr_35613_35652[(2)] = inst_35570);

(statearr_35613_35652[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (19))){
var inst_35527 = (state_35584[(9)]);
var state_35584__$1 = state_35584;
var statearr_35614_35653 = state_35584__$1;
(statearr_35614_35653[(2)] = inst_35527);

(statearr_35614_35653[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (11))){
var inst_35533 = (state_35584[(11)]);
var inst_35541 = (state_35584[(2)]);
var inst_35542 = fluree.db.util.async.throw_err(inst_35541);
var inst_35543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35542,(0),null);
var inst_35544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35542,(1),null);
var inst_35545 = cljs.core.count(inst_35533);
var inst_35546 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_35545);
var state_35584__$1 = (function (){var statearr_35616 = state_35584;
(statearr_35616[(7)] = inst_35544);

(statearr_35616[(10)] = inst_35543);

return statearr_35616;
})();
if(inst_35546){
var statearr_35617_35654 = state_35584__$1;
(statearr_35617_35654[(1)] = (12));

} else {
var statearr_35618_35655 = state_35584__$1;
(statearr_35618_35655[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (9))){
var inst_35527 = (state_35584[(9)]);
var state_35584__$1 = state_35584;
var statearr_35619_35656 = state_35584__$1;
(statearr_35619_35656[(2)] = inst_35527);

(statearr_35619_35656[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (5))){
var _ = (function (){var statearr_35620 = state_35584;
(statearr_35620[(4)] = cljs.core.rest((state_35584[(4)])));

return statearr_35620;
})();
var state_35584__$1 = state_35584;
var ex35615 = (state_35584__$1[(2)]);
var statearr_35621_35657 = state_35584__$1;
(statearr_35621_35657[(5)] = ex35615);


if((ex35615 instanceof Error)){
var statearr_35622_35658 = state_35584__$1;
(statearr_35622_35658[(1)] = (4));

(statearr_35622_35658[(5)] = null);

} else {
throw ex35615;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (14))){
var inst_35574 = (state_35584[(2)]);
var state_35584__$1 = state_35584;
var statearr_35623_35659 = state_35584__$1;
(statearr_35623_35659[(2)] = inst_35574);

(statearr_35623_35659[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (26))){
var inst_35568 = (state_35584[(2)]);
var state_35584__$1 = state_35584;
var statearr_35624_35660 = state_35584__$1;
(statearr_35624_35660[(2)] = inst_35568);

(statearr_35624_35660[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (16))){
var inst_35543 = (state_35584[(10)]);
var inst_35559 = (inst_35543 == null);
var state_35584__$1 = state_35584;
if(cljs.core.truth_(inst_35559)){
var statearr_35625_35661 = state_35584__$1;
(statearr_35625_35661[(1)] = (21));

} else {
var statearr_35626_35662 = state_35584__$1;
(statearr_35626_35662[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (10))){
var inst_35577 = (state_35584[(2)]);
var state_35584__$1 = state_35584;
var statearr_35627_35663 = state_35584__$1;
(statearr_35627_35663[(2)] = inst_35577);

(statearr_35627_35663[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (18))){
var inst_35543 = (state_35584[(10)]);
var state_35584__$1 = state_35584;
var statearr_35628_35664 = state_35584__$1;
(statearr_35628_35664[(2)] = inst_35543);

(statearr_35628_35664[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35585 === (8))){
var inst_35533 = (state_35584[(11)]);
var inst_35527 = (state_35584[(9)]);
var inst_35534 = (state_35584[(12)]);
var inst_35539 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_35527,inst_35533,inst_35534,false,fuel,max_fuel,opts);
var state_35584__$1 = state_35584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35584__$1,(11),inst_35539);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16301__auto__ = null;
var fluree$db$query$analytical$state_machine__16301__auto____0 = (function (){
var statearr_35629 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35629[(0)] = fluree$db$query$analytical$state_machine__16301__auto__);

(statearr_35629[(1)] = (1));

return statearr_35629;
});
var fluree$db$query$analytical$state_machine__16301__auto____1 = (function (state_35584){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35584);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35630){var ex__16304__auto__ = e35630;
var statearr_35631_35665 = state_35584;
(statearr_35631_35665[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35584[(4)]))){
var statearr_35632_35666 = state_35584;
(statearr_35632_35666[(1)] = cljs.core.first((state_35584[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35667 = state_35584;
state_35584 = G__35667;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16301__auto__ = function(state_35584){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16301__auto____1.call(this,state_35584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16301__auto____0;
fluree$db$query$analytical$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16301__auto____1;
return fluree$db$query$analytical$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35633 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35633[(6)] = c__16375__auto__);

return statearr_35633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35722){
var state_val_35723 = (state_35722[(1)]);
if((state_val_35723 === (7))){
var state_35722__$1 = state_35722;
var statearr_35724_35762 = state_35722__$1;
(statearr_35724_35762[(2)] = false);

(statearr_35724_35762[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (20))){
var inst_35700 = (state_35722[(7)]);
var inst_35712 = (state_35722[(8)]);
var inst_35714 = fluree.db.query.analytical.tuples__GT_filtered(inst_35712,inst_35700,null);
var state_35722__$1 = state_35722;
var statearr_35725_35763 = state_35722__$1;
(statearr_35725_35763[(2)] = inst_35714);

(statearr_35725_35763[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (1))){
var state_35722__$1 = state_35722;
var statearr_35726_35764 = state_35722__$1;
(statearr_35726_35764[(2)] = null);

(statearr_35726_35764[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (4))){
var inst_35668 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
var statearr_35727_35765 = state_35722__$1;
(statearr_35727_35765[(2)] = inst_35668);

(statearr_35727_35765[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (15))){
var inst_35699 = (state_35722[(9)]);
var inst_35703 = (state_35722[(2)]);
var inst_35704 = fluree.db.util.async.throw_err(inst_35703);
var state_35722__$1 = (function (){var statearr_35728 = state_35722;
(statearr_35728[(10)] = inst_35704);

return statearr_35728;
})();
if(cljs.core.truth_(inst_35699)){
var statearr_35729_35766 = state_35722__$1;
(statearr_35729_35766[(1)] = (16));

} else {
var statearr_35730_35767 = state_35722__$1;
(statearr_35730_35767[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (21))){
var inst_35712 = (state_35722[(8)]);
var state_35722__$1 = state_35722;
var statearr_35731_35768 = state_35722__$1;
(statearr_35731_35768[(2)] = inst_35712);

(statearr_35731_35768[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (13))){
var inst_35675 = (state_35722[(11)]);
var state_35722__$1 = state_35722;
var statearr_35732_35769 = state_35722__$1;
(statearr_35732_35769[(2)] = inst_35675);

(statearr_35732_35769[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (22))){
var inst_35717 = (state_35722[(2)]);
var _ = (function (){var statearr_35733 = state_35722;
(statearr_35733[(4)] = cljs.core.rest((state_35722[(4)])));

return statearr_35733;
})();
var state_35722__$1 = state_35722;
var statearr_35734_35770 = state_35722__$1;
(statearr_35734_35770[(2)] = inst_35717);

(statearr_35734_35770[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (6))){
var inst_35675 = (state_35722[(11)]);
var inst_35680 = inst_35675.cljs$lang$protocol_mask$partition0$;
var inst_35681 = (inst_35680 & (64));
var inst_35682 = inst_35675.cljs$core$ISeq$;
var inst_35683 = (cljs.core.PROTOCOL_SENTINEL === inst_35682);
var inst_35684 = ((inst_35681) || (inst_35683));
var state_35722__$1 = state_35722;
if(cljs.core.truth_(inst_35684)){
var statearr_35735_35771 = state_35722__$1;
(statearr_35735_35771[(1)] = (9));

} else {
var statearr_35736_35772 = state_35722__$1;
(statearr_35736_35772[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (17))){
var inst_35704 = (state_35722[(10)]);
var state_35722__$1 = state_35722;
var statearr_35737_35773 = state_35722__$1;
(statearr_35737_35773[(2)] = inst_35704);

(statearr_35737_35773[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (3))){
var inst_35720 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35722__$1,inst_35720);
} else {
if((state_val_35723 === (12))){
var inst_35675 = (state_35722[(11)]);
var inst_35693 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35675);
var state_35722__$1 = state_35722;
var statearr_35738_35774 = state_35722__$1;
(statearr_35738_35774[(2)] = inst_35693);

(statearr_35738_35774[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (2))){
var inst_35675 = (state_35722[(11)]);
var _ = (function (){var statearr_35739 = state_35722;
(statearr_35739[(4)] = cljs.core.cons((5),(state_35722[(4)])));

return statearr_35739;
})();
var inst_35675__$1 = q_map;
var inst_35677 = (inst_35675__$1 == null);
var inst_35678 = cljs.core.not(inst_35677);
var state_35722__$1 = (function (){var statearr_35740 = state_35722;
(statearr_35740[(11)] = inst_35675__$1);

return statearr_35740;
})();
if(inst_35678){
var statearr_35741_35775 = state_35722__$1;
(statearr_35741_35775[(1)] = (6));

} else {
var statearr_35742_35776 = state_35722__$1;
(statearr_35742_35776[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (19))){
var inst_35708 = (state_35722[(2)]);
var inst_35709 = fluree.db.util.async.throw_err(inst_35708);
var state_35722__$1 = state_35722;
var statearr_35743_35777 = state_35722__$1;
(statearr_35743_35777[(2)] = inst_35709);

(statearr_35743_35777[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (11))){
var inst_35688 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
var statearr_35745_35778 = state_35722__$1;
(statearr_35745_35778[(2)] = inst_35688);

(statearr_35745_35778[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (9))){
var state_35722__$1 = state_35722;
var statearr_35746_35779 = state_35722__$1;
(statearr_35746_35779[(2)] = true);

(statearr_35746_35779[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (5))){
var _ = (function (){var statearr_35747 = state_35722;
(statearr_35747[(4)] = cljs.core.rest((state_35722[(4)])));

return statearr_35747;
})();
var state_35722__$1 = state_35722;
var ex35744 = (state_35722__$1[(2)]);
var statearr_35748_35780 = state_35722__$1;
(statearr_35748_35780[(5)] = ex35744);


if((ex35744 instanceof Error)){
var statearr_35749_35781 = state_35722__$1;
(statearr_35749_35781[(1)] = (4));

(statearr_35749_35781[(5)] = null);

} else {
throw ex35744;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (14))){
var inst_35696 = (state_35722[(2)]);
var inst_35697 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35696,cljs.core.cst$kw$vars);
var inst_35698 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35696,cljs.core.cst$kw$where);
var inst_35699 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35696,cljs.core.cst$kw$optional);
var inst_35700 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35696,cljs.core.cst$kw$filter);
var inst_35701 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_35698,q_map,inst_35697,fuel,max_fuel,opts);
var state_35722__$1 = (function (){var statearr_35750 = state_35722;
(statearr_35750[(7)] = inst_35700);

(statearr_35750[(9)] = inst_35699);

return statearr_35750;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35722__$1,(15),inst_35701);
} else {
if((state_val_35723 === (16))){
var inst_35699 = (state_35722[(9)]);
var inst_35704 = (state_35722[(10)]);
var inst_35706 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_35699,inst_35704,fuel,max_fuel,opts);
var state_35722__$1 = state_35722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35722__$1,(19),inst_35706);
} else {
if((state_val_35723 === (10))){
var state_35722__$1 = state_35722;
var statearr_35751_35782 = state_35722__$1;
(statearr_35751_35782[(2)] = false);

(statearr_35751_35782[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (18))){
var inst_35700 = (state_35722[(7)]);
var inst_35712 = (state_35722[(2)]);
var state_35722__$1 = (function (){var statearr_35752 = state_35722;
(statearr_35752[(8)] = inst_35712);

return statearr_35752;
})();
if(cljs.core.truth_(inst_35700)){
var statearr_35753_35783 = state_35722__$1;
(statearr_35753_35783[(1)] = (20));

} else {
var statearr_35754_35784 = state_35722__$1;
(statearr_35754_35784[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (8))){
var inst_35691 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
if(cljs.core.truth_(inst_35691)){
var statearr_35755_35785 = state_35722__$1;
(statearr_35755_35785[(1)] = (12));

} else {
var statearr_35756_35786 = state_35722__$1;
(statearr_35756_35786[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__16301__auto____0 = (function (){
var statearr_35757 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35757[(0)] = fluree$db$query$analytical$q_$_state_machine__16301__auto__);

(statearr_35757[(1)] = (1));

return statearr_35757;
});
var fluree$db$query$analytical$q_$_state_machine__16301__auto____1 = (function (state_35722){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35722);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35758){var ex__16304__auto__ = e35758;
var statearr_35759_35787 = state_35722;
(statearr_35759_35787[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35722[(4)]))){
var statearr_35760_35788 = state_35722;
(statearr_35760_35788[(1)] = cljs.core.first((state_35722[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35789 = state_35722;
state_35722 = G__35789;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__16301__auto__ = function(state_35722){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__16301__auto____1.call(this,state_35722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__16301__auto____0;
fluree$db$query$analytical$q_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$q_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35761 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35761[(6)] = c__16375__auto__);

return statearr_35761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
