// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33725_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33725_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__33729 = coll;
var vec__33730 = G__33729;
var seq__33731 = cljs.core.seq(vec__33730);
var first__33732 = cljs.core.first(seq__33731);
var seq__33731__$1 = cljs.core.next(seq__33731);
var clause = first__33732;
var r = seq__33731__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__33729__$1 = G__33729;
var res__$1 = res;
while(true){
var vec__33736 = G__33729__$1;
var seq__33737 = cljs.core.seq(vec__33736);
var first__33738 = cljs.core.first(seq__33737);
var seq__33737__$1 = cljs.core.next(seq__33737);
var clause__$1 = first__33738;
var r__$1 = seq__33737__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__33739 = r__$1;
var G__33740 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__33729__$1 = G__33739;
res__$1 = G__33740;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__33744 = coll;
var vec__33745 = G__33744;
var seq__33746 = cljs.core.seq(vec__33745);
var first__33747 = cljs.core.first(seq__33746);
var seq__33746__$1 = cljs.core.next(seq__33746);
var clause = first__33747;
var r = seq__33746__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__33744__$1 = G__33744;
var res__$1 = res;
while(true){
var vec__33751 = G__33744__$1;
var seq__33752 = cljs.core.seq(vec__33751);
var first__33753 = cljs.core.first(seq__33752);
var seq__33752__$1 = cljs.core.next(seq__33752);
var clause__$1 = first__33753;
var r__$1 = seq__33752__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__33754 = r__$1;
var G__33755 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__33744__$1 = G__33754;
res__$1 = G__33755;
continue;
} else {
var G__33756 = r__$1;
var G__33757 = res__$2;
G__33744__$1 = G__33756;
res__$1 = G__33757;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__33761 = coll;
var vec__33762 = G__33761;
var seq__33763 = cljs.core.seq(vec__33762);
var first__33764 = cljs.core.first(seq__33763);
var seq__33763__$1 = cljs.core.next(seq__33763);
var clause = first__33764;
var r = seq__33763__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__33761__$1 = G__33761;
var res__$1 = res;
while(true){
var vec__33768 = G__33761__$1;
var seq__33769 = cljs.core.seq(vec__33768);
var first__33770 = cljs.core.first(seq__33769);
var seq__33769__$1 = cljs.core.next(seq__33769);
var clause__$1 = first__33770;
var r__$1 = seq__33769__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__33771 = r__$1;
var G__33772 = res__$2;
G__33761__$1 = G__33771;
res__$1 = G__33772;
continue;
} else {
var G__33773 = r__$1;
var G__33774 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__33761__$1 = G__33773;
res__$1 = G__33774;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__33778 = opts;
var map__33778__$1 = (((((!((map__33778 == null))))?(((((map__33778.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33778.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33778):map__33778);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33778__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33778__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33778__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33778__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33778__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33775_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33775_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__33776_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__33776_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__33777_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__33777_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33793){
var state_val_33794 = (state_33793[(1)]);
if((state_val_33794 === (1))){
var inst_33780 = fluree.db.util.core.url_encode(query);
var inst_33781 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33780)].join('');
var inst_33782 = ["User-Agent","Accept"];
var inst_33783 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_33784 = cljs.core.PersistentHashMap.fromArrays(inst_33782,inst_33783);
var inst_33785 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_33786 = [inst_33784,(30000),cljs.core.cst$kw$wikidata];
var inst_33787 = cljs.core.PersistentHashMap.fromArrays(inst_33785,inst_33786);
var inst_33788 = fluree.db.util.xhttp.get(inst_33781,inst_33787);
var state_33793__$1 = state_33793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33793__$1,(2),inst_33788);
} else {
if((state_val_33794 === (2))){
var inst_33790 = (state_33793[(2)]);
var inst_33791 = fluree.db.util.async.throw_err(inst_33790);
var state_33793__$1 = state_33793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33793__$1,inst_33791);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____0 = (function (){
var statearr_33795 = [null,null,null,null,null,null,null];
(statearr_33795[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__);

(statearr_33795[(1)] = (1));

return statearr_33795;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____1 = (function (state_33793){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33793);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33796){var ex__16304__auto__ = e33796;
var statearr_33797_33800 = state_33793;
(statearr_33797_33800[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33793[(4)]))){
var statearr_33798_33801 = state_33793;
(statearr_33798_33801[(1)] = cljs.core.first((state_33793[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33802 = state_33793;
state_33793 = G__33802;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__ = function(state_33793){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____1.call(this,state_33793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33799 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33799[(6)] = c__16375__auto__);

return statearr_33799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33820){
var state_val_33821 = (state_33820[(1)]);
if((state_val_33821 === (1))){
var inst_33803 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_33820__$1 = state_33820;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33820__$1,(2),inst_33803);
} else {
if((state_val_33821 === (2))){
var inst_33806 = (state_33820[(7)]);
var inst_33805 = (state_33820[(2)]);
var inst_33806__$1 = fluree.db.util.async.throw_err(inst_33805);
var inst_33807 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33806__$1);
var inst_33808 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_33807);
var state_33820__$1 = (function (){var statearr_33822 = state_33820;
(statearr_33822[(7)] = inst_33806__$1);

return statearr_33822;
})();
if(inst_33808){
var statearr_33823_33832 = state_33820__$1;
(statearr_33823_33832[(1)] = (3));

} else {
var statearr_33824_33833 = state_33820__$1;
(statearr_33824_33833[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33821 === (3))){
var inst_33806 = (state_33820[(7)]);
var state_33820__$1 = state_33820;
var statearr_33825_33834 = state_33820__$1;
(statearr_33825_33834[(2)] = inst_33806);

(statearr_33825_33834[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33821 === (4))){
var inst_33806 = (state_33820[(7)]);
var inst_33811 = (function (){var body = inst_33806;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_33812 = cljs.core.second(inst_33806);
var inst_33813 = cljs.core.second(inst_33812);
var inst_33814 = cljs.core.first(inst_33813);
var inst_33815 = cljs.core.second(inst_33814);
var inst_33816 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_33811,inst_33815);
var state_33820__$1 = state_33820;
var statearr_33826_33835 = state_33820__$1;
(statearr_33826_33835[(2)] = inst_33816);

(statearr_33826_33835[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33821 === (5))){
var inst_33818 = (state_33820[(2)]);
var state_33820__$1 = state_33820;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33820__$1,inst_33818);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____0 = (function (){
var statearr_33827 = [null,null,null,null,null,null,null,null];
(statearr_33827[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__);

(statearr_33827[(1)] = (1));

return statearr_33827;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____1 = (function (state_33820){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33820);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33828){var ex__16304__auto__ = e33828;
var statearr_33829_33836 = state_33820;
(statearr_33829_33836[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33820[(4)]))){
var statearr_33830_33837 = state_33820;
(statearr_33830_33837[(1)] = cljs.core.first((state_33820[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33838 = state_33820;
state_33820 = G__33838;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__ = function(state_33820){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____1.call(this,state_33820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33831 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33831[(6)] = c__16375__auto__);

return statearr_33831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33839_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33839_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33840_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33840_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33841_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__33841_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33841_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__33841_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33907){
var state_val_33908 = (state_33907[(1)]);
if((state_val_33908 === (7))){
var inst_33852 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_33907__$1 = state_33907;
var statearr_33909_33950 = state_33907__$1;
(statearr_33909_33950[(2)] = inst_33852);

(statearr_33909_33950[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (20))){
var inst_33880 = (state_33907[(7)]);
var inst_33900 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_33880,all_vars);
var state_33907__$1 = state_33907;
var statearr_33910_33951 = state_33907__$1;
(statearr_33910_33951[(2)] = inst_33900);

(statearr_33910_33951[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (1))){
var state_33907__$1 = state_33907;
var statearr_33911_33952 = state_33907__$1;
(statearr_33911_33952[(2)] = null);

(statearr_33911_33952[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (24))){
var inst_33881 = (state_33907[(8)]);
var inst_33880 = (state_33907[(7)]);
var inst_33886 = (state_33907[(9)]);
var inst_33891 = (state_33907[(2)]);
var inst_33892 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_33886,(0),inst_33891);
var inst_33893 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33894 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_33880);
var inst_33895 = [inst_33881,inst_33894];
var inst_33896 = cljs.core.PersistentHashMap.fromArrays(inst_33893,inst_33895);
var inst_33897 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33892,inst_33896);
var inst_33898 = (function(){throw inst_33897})();
var state_33907__$1 = state_33907;
var statearr_33912_33953 = state_33907__$1;
(statearr_33912_33953[(2)] = inst_33898);

(statearr_33912_33953[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (4))){
var inst_33842 = (state_33907[(2)]);
var state_33907__$1 = state_33907;
var statearr_33913_33954 = state_33907__$1;
(statearr_33913_33954[(2)] = inst_33842);

(statearr_33913_33954[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (15))){
var inst_33872 = (state_33907[(2)]);
var state_33907__$1 = state_33907;
var statearr_33914_33955 = state_33907__$1;
(statearr_33914_33955[(2)] = inst_33872);

(statearr_33914_33955[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (21))){
var inst_33902 = (state_33907[(2)]);
var _ = (function (){var statearr_33915 = state_33907;
(statearr_33915[(4)] = cljs.core.rest((state_33907[(4)])));

return statearr_33915;
})();
var state_33907__$1 = state_33907;
var statearr_33916_33956 = state_33907__$1;
(statearr_33916_33956[(2)] = inst_33902);

(statearr_33916_33956[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (13))){
var state_33907__$1 = state_33907;
var statearr_33917_33957 = state_33907__$1;
(statearr_33917_33957[(2)] = true);

(statearr_33917_33957[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (22))){
var inst_33885 = (state_33907[(10)]);
var state_33907__$1 = state_33907;
var statearr_33918_33958 = state_33907__$1;
(statearr_33918_33958[(2)] = inst_33885);

(statearr_33918_33958[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (6))){
var state_33907__$1 = state_33907;
var statearr_33919_33959 = state_33907__$1;
(statearr_33919_33959[(2)] = null);

(statearr_33919_33959[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (17))){
var inst_33859 = (state_33907[(11)]);
var state_33907__$1 = state_33907;
var statearr_33920_33960 = state_33907__$1;
(statearr_33920_33960[(2)] = inst_33859);

(statearr_33920_33960[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (3))){
var inst_33905 = (state_33907[(2)]);
var state_33907__$1 = state_33907;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33907__$1,inst_33905);
} else {
if((state_val_33908 === (12))){
var inst_33875 = (state_33907[(2)]);
var state_33907__$1 = state_33907;
if(cljs.core.truth_(inst_33875)){
var statearr_33921_33961 = state_33907__$1;
(statearr_33921_33961[(1)] = (16));

} else {
var statearr_33922_33962 = state_33907__$1;
(statearr_33922_33962[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (2))){
var _ = (function (){var statearr_33923 = state_33907;
(statearr_33923[(4)] = cljs.core.cons((5),(state_33907[(4)])));

return statearr_33923;
})();
var inst_33849 = cljs.core.empty_QMARK_(matching_vars);
var state_33907__$1 = state_33907;
if(inst_33849){
var statearr_33924_33963 = state_33907__$1;
(statearr_33924_33963[(1)] = (6));

} else {
var statearr_33925_33964 = state_33907__$1;
(statearr_33925_33964[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (23))){
var state_33907__$1 = state_33907;
var statearr_33926_33965 = state_33907__$1;
(statearr_33926_33965[(2)] = (1000));

(statearr_33926_33965[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (19))){
var inst_33882 = (state_33907[(12)]);
var inst_33885 = (state_33907[(10)]);
var inst_33880 = (state_33907[(7)]);
var inst_33885__$1 = cljs.core.count(inst_33882);
var inst_33886 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_33880);
var inst_33887 = (inst_33885__$1 < (1000));
var state_33907__$1 = (function (){var statearr_33927 = state_33907;
(statearr_33927[(10)] = inst_33885__$1);

(statearr_33927[(9)] = inst_33886);

return statearr_33927;
})();
if(cljs.core.truth_(inst_33887)){
var statearr_33928_33966 = state_33907__$1;
(statearr_33928_33966[(1)] = (22));

} else {
var statearr_33929_33967 = state_33907__$1;
(statearr_33929_33967[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (11))){
var state_33907__$1 = state_33907;
var statearr_33931_33968 = state_33907__$1;
(statearr_33931_33968[(2)] = false);

(statearr_33931_33968[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (9))){
var inst_33859 = (state_33907[(11)]);
var inst_33858 = (state_33907[(2)]);
var inst_33859__$1 = fluree.db.util.async.throw_err(inst_33858);
var inst_33861 = (inst_33859__$1 == null);
var inst_33862 = cljs.core.not(inst_33861);
var state_33907__$1 = (function (){var statearr_33932 = state_33907;
(statearr_33932[(11)] = inst_33859__$1);

return statearr_33932;
})();
if(inst_33862){
var statearr_33933_33969 = state_33907__$1;
(statearr_33933_33969[(1)] = (10));

} else {
var statearr_33934_33970 = state_33907__$1;
(statearr_33934_33970[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (5))){
var _ = (function (){var statearr_33935 = state_33907;
(statearr_33935[(4)] = cljs.core.rest((state_33907[(4)])));

return statearr_33935;
})();
var state_33907__$1 = state_33907;
var ex33930 = (state_33907__$1[(2)]);
var statearr_33936_33971 = state_33907__$1;
(statearr_33936_33971[(5)] = ex33930);


if((ex33930 instanceof Error)){
var statearr_33937_33972 = state_33907__$1;
(statearr_33937_33972[(1)] = (4));

(statearr_33937_33972[(5)] = null);

} else {
throw ex33930;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (14))){
var state_33907__$1 = state_33907;
var statearr_33938_33973 = state_33907__$1;
(statearr_33938_33973[(2)] = false);

(statearr_33938_33973[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (16))){
var inst_33859 = (state_33907[(11)]);
var inst_33877 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33859);
var state_33907__$1 = state_33907;
var statearr_33939_33974 = state_33907__$1;
(statearr_33939_33974[(2)] = inst_33877);

(statearr_33939_33974[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (10))){
var inst_33859 = (state_33907[(11)]);
var inst_33864 = inst_33859.cljs$lang$protocol_mask$partition0$;
var inst_33865 = (inst_33864 & (64));
var inst_33866 = inst_33859.cljs$core$ISeq$;
var inst_33867 = (cljs.core.PROTOCOL_SENTINEL === inst_33866);
var inst_33868 = ((inst_33865) || (inst_33867));
var state_33907__$1 = state_33907;
if(cljs.core.truth_(inst_33868)){
var statearr_33940_33975 = state_33907__$1;
(statearr_33940_33975[(1)] = (13));

} else {
var statearr_33941_33976 = state_33907__$1;
(statearr_33941_33976[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (18))){
var inst_33881 = (state_33907[(8)]);
var inst_33880 = (state_33907[(7)]);
var inst_33880__$1 = (state_33907[(2)]);
var inst_33881__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33880__$1,cljs.core.cst$kw$status);
var inst_33882 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33880__$1,cljs.core.cst$kw$message);
var inst_33883 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_33881__$1);
var state_33907__$1 = (function (){var statearr_33942 = state_33907;
(statearr_33942[(8)] = inst_33881__$1);

(statearr_33942[(12)] = inst_33882);

(statearr_33942[(7)] = inst_33880__$1);

return statearr_33942;
})();
if(inst_33883){
var statearr_33943_33977 = state_33907__$1;
(statearr_33943_33977[(1)] = (19));

} else {
var statearr_33944_33978 = state_33907__$1;
(statearr_33944_33978[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33908 === (8))){
var inst_33854 = (state_33907[(2)]);
var inst_33855 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_33854,optional_clauses);
var inst_33856 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_33855);
var state_33907__$1 = state_33907;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33907__$1,(9),inst_33856);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_33945 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33945[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__);

(statearr_33945[(1)] = (1));

return statearr_33945;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____1 = (function (state_33907){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33907);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33946){var ex__16304__auto__ = e33946;
var statearr_33947_33979 = state_33907;
(statearr_33947_33979[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33907[(4)]))){
var statearr_33948_33980 = state_33907;
(statearr_33948_33980[(1)] = cljs.core.first((state_33907[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33981 = state_33907;
state_33907 = G__33981;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__ = function(state_33907){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____1.call(this,state_33907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33949 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33949[(6)] = c__16375__auto__);

return statearr_33949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
