// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__37105 = null;
var G__37105__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__37105__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__37105__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__37105 = function(result,flake){
switch(arguments.length){
case 0:
return G__37105__0.call(this);
case 1:
return G__37105__1.call(this,result);
case 2:
return G__37105__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37105.cljs$core$IFn$_invoke$arity$0 = G__37105__0;
G__37105.cljs$core$IFn$_invoke$arity$1 = G__37105__1;
G__37105.cljs$core$IFn$_invoke$arity$2 = G__37105__2;
return G__37105;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__37106 = null;
var G__37106__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__37106__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__37106__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__37106 = function(result,flakes){
switch(arguments.length){
case 0:
return G__37106__0.call(this);
case 1:
return G__37106__1.call(this,result);
case 2:
return G__37106__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37106.cljs$core$IFn$_invoke$arity$0 = G__37106__0;
G__37106.cljs$core$IFn$_invoke$arity$1 = G__37106__1;
G__37106.cljs$core$IFn$_invoke$arity$2 = G__37106__2;
return G__37106;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__37108 = res;
var G__37108__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__37107_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__37107_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__37108):G__37108);
var G__37108__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__37108__$1):G__37108__$1);
var G__37108__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__37108__$2):G__37108__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__37108__$3);
} else {
return G__37108__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__37110 = arguments.length;
switch (G__37110) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_37413){
var state_val_37414 = (state_37413[(1)]);
if((state_val_37414 === (65))){
var inst_37271 = (state_37413[(7)]);
var inst_37140 = (state_37413[(8)]);
var inst_37264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37265 = cljs.core.deref(cache);
var inst_37266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37267 = flake.o;
var inst_37268 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37140);
var inst_37269 = [inst_37267,inst_37268];
var inst_37270 = (new cljs.core.PersistentVector(null,2,(5),inst_37266,inst_37269,null));
var inst_37271__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37265,inst_37270);
var state_37413__$1 = (function (){var statearr_37415 = state_37413;
(statearr_37415[(7)] = inst_37271__$1);

(statearr_37415[(9)] = inst_37264);

return statearr_37415;
})();
if(cljs.core.truth_(inst_37271__$1)){
var statearr_37416_37582 = state_37413__$1;
(statearr_37416_37582[(1)] = (68));

} else {
var statearr_37417_37583 = state_37413__$1;
(statearr_37417_37583[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (70))){
var inst_37264 = (state_37413[(9)]);
var inst_37289 = (state_37413[(2)]);
var inst_37290 = [inst_37289,offset_map];
var inst_37291 = (new cljs.core.PersistentVector(null,2,(5),inst_37264,inst_37290,null));
var state_37413__$1 = state_37413;
var statearr_37418_37584 = state_37413__$1;
(statearr_37418_37584[(2)] = inst_37291);

(statearr_37418_37584[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (62))){
var inst_37173 = (state_37413[(10)]);
var inst_37172 = (state_37413[(11)]);
var inst_37151 = (state_37413[(12)]);
var inst_37134 = (state_37413[(13)]);
var inst_37174 = (state_37413[(14)]);
var inst_37175 = (state_37413[(15)]);
var inst_37177 = (state_37413[(16)]);
var inst_37140 = (state_37413[(8)]);
var inst_37176 = (state_37413[(17)]);
var inst_37178 = (state_37413[(18)]);
var inst_37249 = (state_37413[(19)]);
var inst_37233 = (state_37413[(20)]);
var inst_37251 = (function (){var p = inst_37178;
var pred_spec__$1 = inst_37134;
var orderBy = inst_37176;
var map__37117 = inst_37172;
var nested_select_spec = inst_37233;
var multi_QMARK_ = inst_37173;
var limit = inst_37175;
var offset = inst_37177;
var k = inst_37151;
var G__37235 = inst_37249;
var pred_spec_SINGLEQUOTE_ = inst_37140;
var ref_QMARK_ = inst_37174;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_37252 = (inst_37251.cljs$core$IFn$_invoke$arity$1 ? inst_37251.cljs$core$IFn$_invoke$arity$1(inst_37249) : inst_37251.call(null,inst_37249));
var state_37413__$1 = state_37413;
var statearr_37419_37585 = state_37413__$1;
(statearr_37419_37585[(2)] = inst_37252);

(statearr_37419_37585[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (74))){
var inst_37298 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
if(cljs.core.truth_(inst_37298)){
var statearr_37420_37586 = state_37413__$1;
(statearr_37420_37586[(1)] = (75));

} else {
var statearr_37421_37587 = state_37413__$1;
(statearr_37421_37587[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (7))){
var inst_37121 = (state_37413[(21)]);
var state_37413__$1 = state_37413;
var statearr_37422_37588 = state_37413__$1;
(statearr_37422_37588[(2)] = inst_37121);

(statearr_37422_37588[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (59))){
var inst_37243 = (state_37413[(22)]);
var inst_37245 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_37246 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37245,inst_37243);
var state_37413__$1 = state_37413;
var statearr_37423_37589 = state_37413__$1;
(statearr_37423_37589[(2)] = inst_37246);

(statearr_37423_37589[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (86))){
var inst_37173 = (state_37413[(10)]);
var inst_37172 = (state_37413[(11)]);
var inst_37151 = (state_37413[(12)]);
var inst_37134 = (state_37413[(13)]);
var inst_37174 = (state_37413[(14)]);
var inst_37175 = (state_37413[(15)]);
var inst_37177 = (state_37413[(16)]);
var inst_37140 = (state_37413[(8)]);
var inst_37176 = (state_37413[(17)]);
var inst_37178 = (state_37413[(18)]);
var inst_37329 = (state_37413[(23)]);
var inst_37311 = (state_37413[(24)]);
var inst_37331 = (function (){var p = inst_37178;
var pred_spec__$1 = inst_37134;
var orderBy = inst_37176;
var map__37117 = inst_37172;
var children = inst_37311;
var multi_QMARK_ = inst_37173;
var limit = inst_37175;
var offset = inst_37177;
var k = inst_37151;
var G__37323 = inst_37329;
var pred_spec_SINGLEQUOTE_ = inst_37140;
var ref_QMARK_ = inst_37174;
return (function (n){
var G__37424 = db;
var G__37425 = cache;
var G__37426 = fuel;
var G__37427 = max_fuel;
var G__37428 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$wildcard_QMARK_,true], null);
var G__37429 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__37424,G__37425,G__37426,G__37427,G__37428,G__37429) : fluree.db.query.fql.flakes__GT_res.call(null,G__37424,G__37425,G__37426,G__37427,G__37428,G__37429));
});
})();
var inst_37332 = (inst_37331.cljs$core$IFn$_invoke$arity$1 ? inst_37331.cljs$core$IFn$_invoke$arity$1(inst_37329) : inst_37331.call(null,inst_37329));
var state_37413__$1 = state_37413;
var statearr_37430_37590 = state_37413__$1;
(statearr_37430_37590[(2)] = inst_37332);

(statearr_37430_37590[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (20))){
var inst_37149 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37431_37591 = state_37413__$1;
(statearr_37431_37591[(2)] = inst_37149);

(statearr_37431_37591[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (72))){
var inst_37140 = (state_37413[(8)]);
var inst_37295 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37140);
var state_37413__$1 = state_37413;
var statearr_37432_37592 = state_37413__$1;
(statearr_37432_37592[(2)] = inst_37295);

(statearr_37432_37592[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (58))){
var inst_37242 = (state_37413[(2)]);
var inst_37243 = fluree.db.util.async.throw_err(inst_37242);
var state_37413__$1 = (function (){var statearr_37433 = state_37413;
(statearr_37433[(22)] = inst_37243);

return statearr_37433;
})();
if(cljs.core.truth_(fuel)){
var statearr_37434_37593 = state_37413__$1;
(statearr_37434_37593[(1)] = (59));

} else {
var statearr_37435_37594 = state_37413__$1;
(statearr_37435_37594[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (60))){
var inst_37243 = (state_37413[(22)]);
var state_37413__$1 = state_37413;
var statearr_37436_37595 = state_37413__$1;
(statearr_37436_37595[(2)] = inst_37243);

(statearr_37436_37595[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (27))){
var inst_37140 = (state_37413[(8)]);
var inst_37169 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37140);
var state_37413__$1 = state_37413;
var statearr_37437_37596 = state_37413__$1;
(statearr_37437_37596[(2)] = inst_37169);

(statearr_37437_37596[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (1))){
var state_37413__$1 = state_37413;
var statearr_37438_37597 = state_37413__$1;
(statearr_37438_37597[(2)] = null);

(statearr_37438_37597[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (69))){
var inst_37140 = (state_37413[(8)]);
var inst_37274 = flake.o;
var inst_37275 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37140);
var inst_37276 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_37274,inst_37275);
var state_37413__$1 = state_37413;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37413__$1,(71),inst_37276);
} else {
if((state_val_37414 === (101))){
var inst_37151 = (state_37413[(12)]);
var inst_37374 = (state_37413[(25)]);
var inst_37373 = (state_37413[(26)]);
var inst_37393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37394 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37151,inst_37373);
var inst_37395 = [inst_37394,inst_37374];
var inst_37396 = (new cljs.core.PersistentVector(null,2,(5),inst_37393,inst_37395,null));
var state_37413__$1 = state_37413;
var statearr_37439_37598 = state_37413__$1;
(statearr_37439_37598[(2)] = inst_37396);

(statearr_37439_37598[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (24))){
var state_37413__$1 = state_37413;
var statearr_37440_37599 = state_37413__$1;
(statearr_37440_37599[(2)] = true);

(statearr_37440_37599[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (102))){
var state_37413__$1 = state_37413;
var statearr_37441_37600 = state_37413__$1;
(statearr_37441_37600[(1)] = (104));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (55))){
var inst_37140 = (state_37413[(8)]);
var inst_37262 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37140);
var state_37413__$1 = state_37413;
if(cljs.core.truth_(inst_37262)){
var statearr_37443_37601 = state_37413__$1;
(statearr_37443_37601[(1)] = (65));

} else {
var statearr_37444_37602 = state_37413__$1;
(statearr_37444_37602[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (85))){
var inst_37329 = (state_37413[(2)]);
var state_37413__$1 = (function (){var statearr_37445 = state_37413;
(statearr_37445[(23)] = inst_37329);

return statearr_37445;
})();
var statearr_37446_37603 = state_37413__$1;
(statearr_37446_37603[(1)] = (86));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (39))){
var inst_37178 = (state_37413[(18)]);
var inst_37195 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37178,cljs.core.dec);
var state_37413__$1 = state_37413;
var statearr_37448_37604 = state_37413__$1;
(statearr_37448_37604[(2)] = inst_37195);

(statearr_37448_37604[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (88))){
var inst_37335 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37413__$1,(82),inst_37335);
} else {
if((state_val_37414 === (46))){
var inst_37218 = cljs.core.not(recur_QMARK_);
var state_37413__$1 = state_37413;
if(inst_37218){
var statearr_37449_37605 = state_37413__$1;
(statearr_37449_37605[(1)] = (48));

} else {
var statearr_37450_37606 = state_37413__$1;
(statearr_37450_37606[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (4))){
var inst_37111 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37451_37607 = state_37413__$1;
(statearr_37451_37607[(2)] = inst_37111);

(statearr_37451_37607[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (77))){
var inst_37364 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37452_37608 = state_37413__$1;
(statearr_37452_37608[(2)] = inst_37364);

(statearr_37452_37608[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (106))){
var inst_37404 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37453_37609 = state_37413__$1;
(statearr_37453_37609[(2)] = inst_37404);

(statearr_37453_37609[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (95))){
var inst_37173 = (state_37413[(10)]);
var state_37413__$1 = state_37413;
var statearr_37454_37610 = state_37413__$1;
(statearr_37454_37610[(2)] = inst_37173);

(statearr_37454_37610[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (54))){
var inst_37140 = (state_37413[(8)]);
var inst_37230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37231 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_37232 = (new cljs.core.PersistentVector(null,3,(5),inst_37230,inst_37231,null));
var inst_37233 = cljs.core.select_keys(inst_37140,inst_37232);
var inst_37234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37237 = flake.o;
var inst_37238 = [inst_37237];
var inst_37239 = (new cljs.core.PersistentVector(null,1,(5),inst_37236,inst_37238,null));
var inst_37240 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37239);
var state_37413__$1 = (function (){var statearr_37455 = state_37413;
(statearr_37455[(27)] = inst_37234);

(statearr_37455[(20)] = inst_37233);

return statearr_37455;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37413__$1,(58),inst_37240);
} else {
if((state_val_37414 === (92))){
var inst_37354 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37355 = flake.o;
var inst_37356 = [inst_37355,offset_map];
var inst_37357 = (new cljs.core.PersistentVector(null,2,(5),inst_37354,inst_37356,null));
var state_37413__$1 = state_37413;
var statearr_37456_37611 = state_37413__$1;
(statearr_37456_37611[(2)] = inst_37357);

(statearr_37456_37611[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (104))){
var inst_37374 = (state_37413[(25)]);
var inst_37399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37400 = [acc,inst_37374];
var inst_37401 = (new cljs.core.PersistentVector(null,2,(5),inst_37399,inst_37400,null));
var state_37413__$1 = state_37413;
var statearr_37457_37612 = state_37413__$1;
(statearr_37457_37612[(2)] = inst_37401);

(statearr_37457_37612[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (15))){
var inst_37141 = (state_37413[(28)]);
var state_37413__$1 = state_37413;
var statearr_37458_37613 = state_37413__$1;
(statearr_37458_37613[(2)] = inst_37141);

(statearr_37458_37613[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (48))){
var inst_37140 = (state_37413[(8)]);
var inst_37220 = (state_37413[(29)]);
var inst_37220__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_37140);
var state_37413__$1 = (function (){var statearr_37459 = state_37413;
(statearr_37459[(29)] = inst_37220__$1);

return statearr_37459;
})();
if(cljs.core.truth_(inst_37220__$1)){
var statearr_37460_37614 = state_37413__$1;
(statearr_37460_37614[(1)] = (51));

} else {
var statearr_37461_37615 = state_37413__$1;
(statearr_37461_37615[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (50))){
var inst_37228 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
if(cljs.core.truth_(inst_37228)){
var statearr_37462_37616 = state_37413__$1;
(statearr_37462_37616[(1)] = (54));

} else {
var statearr_37463_37617 = state_37413__$1;
(statearr_37463_37617[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (75))){
var inst_37140 = (state_37413[(8)]);
var inst_37300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37301 = flake.o;
var inst_37302 = [inst_37301];
var inst_37303 = (new cljs.core.PersistentVector(null,1,(5),inst_37300,inst_37302,null));
var inst_37304 = [cljs.core.cst$kw$limit];
var inst_37305 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_37140);
var inst_37306 = [inst_37305];
var inst_37307 = cljs.core.PersistentHashMap.fromArrays(inst_37304,inst_37306);
var inst_37308 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37303,inst_37307);
var state_37413__$1 = state_37413;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37413__$1,(78),inst_37308);
} else {
if((state_val_37414 === (99))){
var inst_37373 = (state_37413[(26)]);
var inst_37390 = (inst_37373 == null);
var inst_37391 = cljs.core.not(inst_37390);
var state_37413__$1 = state_37413;
if(inst_37391){
var statearr_37464_37618 = state_37413__$1;
(statearr_37464_37618[(1)] = (101));

} else {
var statearr_37465_37619 = state_37413__$1;
(statearr_37465_37619[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (21))){
var inst_37140 = (state_37413[(8)]);
var inst_37156 = inst_37140.cljs$lang$protocol_mask$partition0$;
var inst_37157 = (inst_37156 & (64));
var inst_37158 = inst_37140.cljs$core$ISeq$;
var inst_37159 = (cljs.core.PROTOCOL_SENTINEL === inst_37158);
var inst_37160 = ((inst_37157) || (inst_37159));
var state_37413__$1 = state_37413;
if(cljs.core.truth_(inst_37160)){
var statearr_37466_37620 = state_37413__$1;
(statearr_37466_37620[(1)] = (24));

} else {
var statearr_37467_37621 = state_37413__$1;
(statearr_37467_37621[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (31))){
var inst_37173 = (state_37413[(10)]);
var state_37413__$1 = state_37413;
var statearr_37468_37622 = state_37413__$1;
(statearr_37468_37622[(2)] = inst_37173);

(statearr_37468_37622[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (32))){
var inst_37190 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
if(cljs.core.truth_(inst_37190)){
var statearr_37469_37623 = state_37413__$1;
(statearr_37469_37623[(1)] = (36));

} else {
var statearr_37470_37624 = state_37413__$1;
(statearr_37470_37624[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (40))){
var inst_37177 = (state_37413[(16)]);
var inst_37178 = (state_37413[(18)]);
var inst_37197 = (inst_37177 - (1));
var inst_37198 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37178,inst_37197);
var state_37413__$1 = state_37413;
var statearr_37471_37625 = state_37413__$1;
(statearr_37471_37625[(2)] = inst_37198);

(statearr_37471_37625[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (91))){
var inst_37362 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37472_37626 = state_37413__$1;
(statearr_37472_37626[(2)] = inst_37362);

(statearr_37472_37626[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (56))){
var inst_37368 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37473_37627 = state_37413__$1;
(statearr_37473_37627[(2)] = inst_37368);

(statearr_37473_37627[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (33))){
var inst_37177 = (state_37413[(16)]);
var inst_37178 = (state_37413[(18)]);
var inst_37181 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37177);
var inst_37182 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37178);
var inst_37183 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37182);
var inst_37184 = ((inst_37181) && (inst_37183));
var state_37413__$1 = state_37413;
var statearr_37474_37628 = state_37413__$1;
(statearr_37474_37628[(2)] = inst_37184);

(statearr_37474_37628[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (13))){
var inst_37134 = (state_37413[(13)]);
var inst_37138 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37134,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_37413__$1 = state_37413;
var statearr_37475_37629 = state_37413__$1;
(statearr_37475_37629[(2)] = inst_37138);

(statearr_37475_37629[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (22))){
var state_37413__$1 = state_37413;
var statearr_37476_37630 = state_37413__$1;
(statearr_37476_37630[(2)] = false);

(statearr_37476_37630[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (90))){
var state_37413__$1 = state_37413;
var statearr_37477_37631 = state_37413__$1;
(statearr_37477_37631[(1)] = (92));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (36))){
var inst_37178 = (state_37413[(18)]);
var inst_37192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37193 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37178);
var state_37413__$1 = (function (){var statearr_37479 = state_37413;
(statearr_37479[(30)] = inst_37192);

return statearr_37479;
})();
if(cljs.core.truth_(inst_37193)){
var statearr_37480_37632 = state_37413__$1;
(statearr_37480_37632[(1)] = (39));

} else {
var statearr_37481_37633 = state_37413__$1;
(statearr_37481_37633[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (41))){
var inst_37192 = (state_37413[(30)]);
var inst_37200 = (state_37413[(2)]);
var inst_37201 = [null,inst_37200];
var inst_37202 = (new cljs.core.PersistentVector(null,2,(5),inst_37192,inst_37201,null));
var state_37413__$1 = state_37413;
var statearr_37482_37634 = state_37413__$1;
(statearr_37482_37634[(2)] = inst_37202);

(statearr_37482_37634[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (89))){
var inst_37345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37346 = ["_id"];
var inst_37347 = flake.o;
var inst_37348 = [inst_37347];
var inst_37349 = cljs.core.PersistentHashMap.fromArrays(inst_37346,inst_37348);
var inst_37350 = [inst_37349,offset_map];
var inst_37351 = (new cljs.core.PersistentVector(null,2,(5),inst_37345,inst_37350,null));
var state_37413__$1 = state_37413;
var statearr_37483_37635 = state_37413__$1;
(statearr_37483_37635[(2)] = inst_37351);

(statearr_37483_37635[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (100))){
var inst_37408 = (state_37413[(2)]);
var _ = (function (){var statearr_37484 = state_37413;
(statearr_37484[(4)] = cljs.core.rest((state_37413[(4)])));

return statearr_37484;
})();
var state_37413__$1 = state_37413;
var statearr_37485_37636 = state_37413__$1;
(statearr_37485_37636[(2)] = inst_37408);

(statearr_37485_37636[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (43))){
var inst_37173 = (state_37413[(10)]);
var state_37413__$1 = state_37413;
var statearr_37486_37637 = state_37413__$1;
(statearr_37486_37637[(2)] = inst_37173);

(statearr_37486_37637[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (61))){
var inst_37249 = (state_37413[(2)]);
var state_37413__$1 = (function (){var statearr_37487 = state_37413;
(statearr_37487[(19)] = inst_37249);

return statearr_37487;
})();
var statearr_37488_37638 = state_37413__$1;
(statearr_37488_37638[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (29))){
var inst_37173 = (state_37413[(10)]);
var inst_37172 = (state_37413[(11)]);
var inst_37172__$1 = (state_37413[(2)]);
var inst_37173__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37172__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_37174 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37172__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_37175 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37172__$1,cljs.core.cst$kw$limit);
var inst_37176 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37172__$1,cljs.core.cst$kw$orderBy);
var inst_37177 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37172__$1,cljs.core.cst$kw$offset);
var inst_37178 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37172__$1,cljs.core.cst$kw$p);
var state_37413__$1 = (function (){var statearr_37490 = state_37413;
(statearr_37490[(10)] = inst_37173__$1);

(statearr_37490[(11)] = inst_37172__$1);

(statearr_37490[(14)] = inst_37174);

(statearr_37490[(15)] = inst_37175);

(statearr_37490[(16)] = inst_37177);

(statearr_37490[(17)] = inst_37176);

(statearr_37490[(18)] = inst_37178);

return statearr_37490;
})();
if(cljs.core.truth_(inst_37173__$1)){
var statearr_37491_37639 = state_37413__$1;
(statearr_37491_37639[(1)] = (30));

} else {
var statearr_37492_37640 = state_37413__$1;
(statearr_37492_37640[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (44))){
var inst_37212 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
if(cljs.core.truth_(inst_37212)){
var statearr_37493_37641 = state_37413__$1;
(statearr_37493_37641[(1)] = (45));

} else {
var statearr_37494_37642 = state_37413__$1;
(statearr_37494_37642[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (93))){
var state_37413__$1 = state_37413;
var statearr_37495_37643 = state_37413__$1;
(statearr_37495_37643[(2)] = null);

(statearr_37495_37643[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (6))){
var inst_37123 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37124 = (inst_37123 == null);
var state_37413__$1 = state_37413;
var statearr_37496_37644 = state_37413__$1;
(statearr_37496_37644[(2)] = inst_37124);

(statearr_37496_37644[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (28))){
var inst_37140 = (state_37413[(8)]);
var state_37413__$1 = state_37413;
var statearr_37497_37645 = state_37413__$1;
(statearr_37497_37645[(2)] = inst_37140);

(statearr_37497_37645[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (64))){
var inst_37255 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37413__$1,(57),inst_37255);
} else {
if((state_val_37414 === (103))){
var inst_37406 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37498_37646 = state_37413__$1;
(statearr_37498_37646[(2)] = inst_37406);

(statearr_37498_37646[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (51))){
var inst_37220 = (state_37413[(29)]);
var state_37413__$1 = state_37413;
var statearr_37499_37647 = state_37413__$1;
(statearr_37499_37647[(2)] = inst_37220);

(statearr_37499_37647[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (25))){
var state_37413__$1 = state_37413;
var statearr_37500_37648 = state_37413__$1;
(statearr_37500_37648[(2)] = false);

(statearr_37500_37648[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (34))){
var inst_37177 = (state_37413[(16)]);
var state_37413__$1 = state_37413;
var statearr_37501_37649 = state_37413__$1;
(statearr_37501_37649[(2)] = inst_37177);

(statearr_37501_37649[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (17))){
var inst_37140 = (state_37413[(8)]);
var inst_37151 = (state_37413[(2)]);
var inst_37153 = (inst_37140 == null);
var inst_37154 = cljs.core.not(inst_37153);
var state_37413__$1 = (function (){var statearr_37502 = state_37413;
(statearr_37502[(12)] = inst_37151);

return statearr_37502;
})();
if(inst_37154){
var statearr_37503_37650 = state_37413__$1;
(statearr_37503_37650[(1)] = (21));

} else {
var statearr_37504_37651 = state_37413__$1;
(statearr_37504_37651[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (3))){
var inst_37411 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37413__$1,inst_37411);
} else {
if((state_val_37414 === (12))){
var inst_37134 = (state_37413[(13)]);
var state_37413__$1 = state_37413;
var statearr_37505_37652 = state_37413__$1;
(statearr_37505_37652[(2)] = inst_37134);

(statearr_37505_37652[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (2))){
var inst_37121 = (state_37413[(21)]);
var _ = (function (){var statearr_37506 = state_37413;
(statearr_37506[(4)] = cljs.core.cons((5),(state_37413[(4)])));

return statearr_37506;
})();
var inst_37121__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_37413__$1 = (function (){var statearr_37507 = state_37413;
(statearr_37507[(21)] = inst_37121__$1);

return statearr_37507;
})();
if(cljs.core.truth_(inst_37121__$1)){
var statearr_37508_37653 = state_37413__$1;
(statearr_37508_37653[(1)] = (6));

} else {
var statearr_37509_37654 = state_37413__$1;
(statearr_37509_37654[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (66))){
var inst_37293 = (state_37413[(31)]);
var inst_37293__$1 = componentFollow_QMARK_;
var state_37413__$1 = (function (){var statearr_37510 = state_37413;
(statearr_37510[(31)] = inst_37293__$1);

return statearr_37510;
})();
if(cljs.core.truth_(inst_37293__$1)){
var statearr_37511_37655 = state_37413__$1;
(statearr_37511_37655[(1)] = (72));

} else {
var statearr_37512_37656 = state_37413__$1;
(statearr_37512_37656[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (23))){
var inst_37167 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
if(cljs.core.truth_(inst_37167)){
var statearr_37513_37657 = state_37413__$1;
(statearr_37513_37657[(1)] = (27));

} else {
var statearr_37514_37658 = state_37413__$1;
(statearr_37514_37658[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (47))){
var inst_37370 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37515_37659 = state_37413__$1;
(statearr_37515_37659[(2)] = inst_37370);

(statearr_37515_37659[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (35))){
var inst_37187 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37516_37660 = state_37413__$1;
(statearr_37516_37660[(2)] = inst_37187);

(statearr_37516_37660[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (82))){
var inst_37322 = (state_37413[(32)]);
var inst_37337 = (state_37413[(2)]);
var inst_37338 = fluree.db.util.async.throw_err(inst_37337);
var inst_37339 = [inst_37338,offset_map];
var inst_37340 = (new cljs.core.PersistentVector(null,2,(5),inst_37322,inst_37339,null));
var state_37413__$1 = state_37413;
var statearr_37517_37661 = state_37413__$1;
(statearr_37517_37661[(2)] = inst_37340);

(statearr_37517_37661[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (76))){
var inst_37174 = (state_37413[(14)]);
var state_37413__$1 = state_37413;
if(cljs.core.truth_(inst_37174)){
var statearr_37518_37662 = state_37413__$1;
(statearr_37518_37662[(1)] = (89));

} else {
var statearr_37519_37663 = state_37413__$1;
(statearr_37519_37663[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (97))){
var inst_37380 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
if(cljs.core.truth_(inst_37380)){
var statearr_37520_37664 = state_37413__$1;
(statearr_37520_37664[(1)] = (98));

} else {
var statearr_37521_37665 = state_37413__$1;
(statearr_37521_37665[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (19))){
var inst_37140 = (state_37413[(8)]);
var inst_37147 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_37140);
var state_37413__$1 = state_37413;
var statearr_37522_37666 = state_37413__$1;
(statearr_37522_37666[(2)] = inst_37147);

(statearr_37522_37666[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (57))){
var inst_37234 = (state_37413[(27)]);
var inst_37257 = (state_37413[(2)]);
var inst_37258 = fluree.db.util.async.throw_err(inst_37257);
var inst_37259 = [inst_37258,offset_map];
var inst_37260 = (new cljs.core.PersistentVector(null,2,(5),inst_37234,inst_37259,null));
var state_37413__$1 = state_37413;
var statearr_37523_37667 = state_37413__$1;
(statearr_37523_37667[(2)] = inst_37260);

(statearr_37523_37667[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (68))){
var inst_37271 = (state_37413[(7)]);
var state_37413__$1 = state_37413;
var statearr_37524_37668 = state_37413__$1;
(statearr_37524_37668[(2)] = inst_37271);

(statearr_37524_37668[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (11))){
var inst_37134 = (state_37413[(13)]);
var inst_37134__$1 = (state_37413[(2)]);
var inst_37135 = cljs.core.contains_QMARK_(inst_37134__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var state_37413__$1 = (function (){var statearr_37526 = state_37413;
(statearr_37526[(13)] = inst_37134__$1);

return statearr_37526;
})();
if(inst_37135){
var statearr_37527_37669 = state_37413__$1;
(statearr_37527_37669[(1)] = (12));

} else {
var statearr_37528_37670 = state_37413__$1;
(statearr_37528_37670[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (9))){
var inst_37129 = flake.p;
var inst_37130 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37131 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_37129,inst_37130);
var state_37413__$1 = state_37413;
var statearr_37529_37671 = state_37413__$1;
(statearr_37529_37671[(2)] = inst_37131);

(statearr_37529_37671[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (5))){
var _ = (function (){var statearr_37530 = state_37413;
(statearr_37530[(4)] = cljs.core.rest((state_37413[(4)])));

return statearr_37530;
})();
var state_37413__$1 = state_37413;
var ex37525 = (state_37413__$1[(2)]);
var statearr_37531_37672 = state_37413__$1;
(statearr_37531_37672[(5)] = ex37525);


if((ex37525 instanceof Error)){
var statearr_37532_37673 = state_37413__$1;
(statearr_37532_37673[(1)] = (4));

(statearr_37532_37673[(5)] = null);

} else {
throw ex37525;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (83))){
var inst_37311 = (state_37413[(24)]);
var inst_37325 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_37326 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37325,inst_37311);
var state_37413__$1 = state_37413;
var statearr_37533_37674 = state_37413__$1;
(statearr_37533_37674[(2)] = inst_37326);

(statearr_37533_37674[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (14))){
var inst_37140 = (state_37413[(8)]);
var inst_37141 = (state_37413[(28)]);
var inst_37140__$1 = (state_37413[(2)]);
var inst_37141__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_37140__$1);
var state_37413__$1 = (function (){var statearr_37534 = state_37413;
(statearr_37534[(8)] = inst_37140__$1);

(statearr_37534[(28)] = inst_37141__$1);

return statearr_37534;
})();
if(cljs.core.truth_(inst_37141__$1)){
var statearr_37535_37675 = state_37413__$1;
(statearr_37535_37675[(1)] = (15));

} else {
var statearr_37536_37676 = state_37413__$1;
(statearr_37536_37676[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (45))){
var inst_37214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37215 = [null,offset_map];
var inst_37216 = (new cljs.core.PersistentVector(null,2,(5),inst_37214,inst_37215,null));
var state_37413__$1 = state_37413;
var statearr_37537_37677 = state_37413__$1;
(statearr_37537_37677[(2)] = inst_37216);

(statearr_37537_37677[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (53))){
var inst_37225 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37538_37678 = state_37413__$1;
(statearr_37538_37678[(2)] = inst_37225);

(statearr_37538_37678[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (78))){
var inst_37311 = (state_37413[(24)]);
var inst_37310 = (state_37413[(2)]);
var inst_37311__$1 = fluree.db.util.async.throw_err(inst_37310);
var inst_37312 = cljs.core.empty_QMARK_(inst_37311__$1);
var state_37413__$1 = (function (){var statearr_37539 = state_37413;
(statearr_37539[(24)] = inst_37311__$1);

return statearr_37539;
})();
if(inst_37312){
var statearr_37540_37679 = state_37413__$1;
(statearr_37540_37679[(1)] = (79));

} else {
var statearr_37541_37680 = state_37413__$1;
(statearr_37541_37680[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (26))){
var inst_37164 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37542_37681 = state_37413__$1;
(statearr_37542_37681[(2)] = inst_37164);

(statearr_37542_37681[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (16))){
var inst_37140 = (state_37413[(8)]);
var inst_37144 = (state_37413[(33)]);
var inst_37144__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37140);
var state_37413__$1 = (function (){var statearr_37543 = state_37413;
(statearr_37543[(33)] = inst_37144__$1);

return statearr_37543;
})();
if(cljs.core.truth_(inst_37144__$1)){
var statearr_37544_37682 = state_37413__$1;
(statearr_37544_37682[(1)] = (18));

} else {
var statearr_37545_37683 = state_37413__$1;
(statearr_37545_37683[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (81))){
var inst_37342 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37546_37684 = state_37413__$1;
(statearr_37546_37684[(2)] = inst_37342);

(statearr_37546_37684[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (79))){
var inst_37314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37315 = ["_id"];
var inst_37316 = flake.o;
var inst_37317 = [inst_37316];
var inst_37318 = cljs.core.PersistentHashMap.fromArrays(inst_37315,inst_37317);
var inst_37319 = [inst_37318,offset_map];
var inst_37320 = (new cljs.core.PersistentVector(null,2,(5),inst_37314,inst_37319,null));
var state_37413__$1 = state_37413;
var statearr_37547_37685 = state_37413__$1;
(statearr_37547_37685[(2)] = inst_37320);

(statearr_37547_37685[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (38))){
var inst_37373 = (state_37413[(26)]);
var inst_37372 = (state_37413[(2)]);
var inst_37373__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37372,(0),null);
var inst_37374 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37372,(1),null);
var inst_37375 = (inst_37373__$1 == null);
var inst_37376 = cljs.core.not(inst_37375);
var state_37413__$1 = (function (){var statearr_37548 = state_37413;
(statearr_37548[(25)] = inst_37374);

(statearr_37548[(26)] = inst_37373__$1);

return statearr_37548;
})();
if(inst_37376){
var statearr_37549_37686 = state_37413__$1;
(statearr_37549_37686[(1)] = (95));

} else {
var statearr_37550_37687 = state_37413__$1;
(statearr_37550_37687[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (98))){
var inst_37151 = (state_37413[(12)]);
var inst_37374 = (state_37413[(25)]);
var inst_37373 = (state_37413[(26)]);
var inst_37382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37383 = cljs.core.PersistentVector.EMPTY;
var inst_37384 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_37151,inst_37383);
var inst_37385 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37384,inst_37373);
var inst_37386 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37151,inst_37385);
var inst_37387 = [inst_37386,inst_37374];
var inst_37388 = (new cljs.core.PersistentVector(null,2,(5),inst_37382,inst_37387,null));
var state_37413__$1 = state_37413;
var statearr_37551_37688 = state_37413__$1;
(statearr_37551_37688[(2)] = inst_37388);

(statearr_37551_37688[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (87))){
var inst_37329 = (state_37413[(23)]);
var state_37413__$1 = state_37413;
var statearr_37552_37689 = state_37413__$1;
(statearr_37552_37689[(2)] = inst_37329);

(statearr_37552_37689[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (30))){
var inst_37177 = (state_37413[(16)]);
var state_37413__$1 = state_37413;
if(cljs.core.truth_(inst_37177)){
var statearr_37553_37690 = state_37413__$1;
(statearr_37553_37690[(1)] = (33));

} else {
var statearr_37554_37691 = state_37413__$1;
(statearr_37554_37691[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (73))){
var inst_37293 = (state_37413[(31)]);
var state_37413__$1 = state_37413;
var statearr_37555_37692 = state_37413__$1;
(statearr_37555_37692[(2)] = inst_37293);

(statearr_37555_37692[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (96))){
var state_37413__$1 = state_37413;
var statearr_37556_37693 = state_37413__$1;
(statearr_37556_37693[(2)] = false);

(statearr_37556_37693[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (10))){
var state_37413__$1 = state_37413;
var statearr_37557_37694 = state_37413__$1;
(statearr_37557_37694[(2)] = pred_spec);

(statearr_37557_37694[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (18))){
var inst_37144 = (state_37413[(33)]);
var state_37413__$1 = state_37413;
var statearr_37558_37695 = state_37413__$1;
(statearr_37558_37695[(2)] = inst_37144);

(statearr_37558_37695[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (105))){
var state_37413__$1 = state_37413;
var statearr_37559_37696 = state_37413__$1;
(statearr_37559_37696[(2)] = null);

(statearr_37559_37696[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (52))){
var inst_37140 = (state_37413[(8)]);
var inst_37223 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37140);
var state_37413__$1 = state_37413;
var statearr_37560_37697 = state_37413__$1;
(statearr_37560_37697[(2)] = inst_37223);

(statearr_37560_37697[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (67))){
var inst_37366 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37561_37698 = state_37413__$1;
(statearr_37561_37698[(2)] = inst_37366);

(statearr_37561_37698[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (71))){
var inst_37140 = (state_37413[(8)]);
var inst_37278 = (state_37413[(2)]);
var inst_37279 = fluree.db.util.async.throw_err(inst_37278);
var inst_37280 = cljs.core._deref(cache);
var inst_37281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37282 = flake.o;
var inst_37283 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37140);
var inst_37284 = [inst_37282,inst_37283];
var inst_37285 = (new cljs.core.PersistentVector(null,2,(5),inst_37281,inst_37284,null));
var inst_37286 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37280,inst_37285,inst_37279);
var inst_37287 = cljs.core._vreset_BANG_(cache,inst_37286);
var state_37413__$1 = (function (){var statearr_37562 = state_37413;
(statearr_37562[(34)] = inst_37287);

return statearr_37562;
})();
var statearr_37563_37699 = state_37413__$1;
(statearr_37563_37699[(2)] = inst_37279);

(statearr_37563_37699[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (42))){
var inst_37151 = (state_37413[(12)]);
var inst_37175 = (state_37413[(15)]);
var inst_37176 = (state_37413[(17)]);
var inst_37205 = cljs.core.not(inst_37176);
var inst_37206 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_37151);
var inst_37207 = cljs.core.count(inst_37206);
var inst_37208 = (inst_37207 >= inst_37175);
var inst_37209 = ((inst_37205) && (inst_37208));
var state_37413__$1 = state_37413;
var statearr_37564_37700 = state_37413__$1;
(statearr_37564_37700[(2)] = inst_37209);

(statearr_37564_37700[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (80))){
var inst_37322 = cljs.core.PersistentVector.EMPTY_NODE;
var state_37413__$1 = (function (){var statearr_37565 = state_37413;
(statearr_37565[(32)] = inst_37322);

return statearr_37565;
})();
if(cljs.core.truth_(fuel)){
var statearr_37566_37701 = state_37413__$1;
(statearr_37566_37701[(1)] = (83));

} else {
var statearr_37567_37702 = state_37413__$1;
(statearr_37567_37702[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (37))){
var inst_37173 = (state_37413[(10)]);
var state_37413__$1 = state_37413;
if(cljs.core.truth_(inst_37173)){
var statearr_37568_37703 = state_37413__$1;
(statearr_37568_37703[(1)] = (42));

} else {
var statearr_37569_37704 = state_37413__$1;
(statearr_37569_37704[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (63))){
var inst_37249 = (state_37413[(19)]);
var state_37413__$1 = state_37413;
var statearr_37570_37705 = state_37413__$1;
(statearr_37570_37705[(2)] = inst_37249);

(statearr_37570_37705[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (94))){
var inst_37360 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
var statearr_37571_37706 = state_37413__$1;
(statearr_37571_37706[(2)] = inst_37360);

(statearr_37571_37706[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (8))){
var inst_37127 = (state_37413[(2)]);
var state_37413__$1 = state_37413;
if(cljs.core.truth_(inst_37127)){
var statearr_37572_37707 = state_37413__$1;
(statearr_37572_37707[(1)] = (9));

} else {
var statearr_37573_37708 = state_37413__$1;
(statearr_37573_37708[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (49))){
var state_37413__$1 = state_37413;
var statearr_37574_37709 = state_37413__$1;
(statearr_37574_37709[(2)] = false);

(statearr_37574_37709[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37414 === (84))){
var inst_37311 = (state_37413[(24)]);
var state_37413__$1 = state_37413;
var statearr_37575_37710 = state_37413__$1;
(statearr_37575_37710[(2)] = inst_37311);

(statearr_37575_37710[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_37576 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37576[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_37576[(1)] = (1));

return statearr_37576;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_37413){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_37413);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e37577){var ex__16304__auto__ = e37577;
var statearr_37578_37711 = state_37413;
(statearr_37578_37711[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_37413[(4)]))){
var statearr_37579_37712 = state_37413;
(statearr_37579_37712[(1)] = cljs.core.first((state_37413[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__37713 = state_37413;
state_37413 = G__37713;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_37413){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_37413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_37580 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_37580[(6)] = c__16375__auto__);

return statearr_37580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_37893){
var state_val_37894 = (state_37893[(1)]);
if((state_val_37894 === (7))){
var inst_37888 = (state_37893[(2)]);
var _ = (function (){var statearr_37895 = state_37893;
(statearr_37895[(4)] = cljs.core.rest((state_37893[(4)])));

return statearr_37895;
})();
var state_37893__$1 = state_37893;
var statearr_37896_37991 = state_37893__$1;
(statearr_37896_37991[(2)] = inst_37888);

(statearr_37896_37991[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (59))){
var inst_37774 = (state_37893[(7)]);
var state_37893__$1 = state_37893;
var statearr_37897_37992 = state_37893__$1;
(statearr_37897_37992[(2)] = inst_37774);

(statearr_37897_37992[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (20))){
var inst_37783 = (state_37893[(8)]);
var inst_37780 = (state_37893[(2)]);
var inst_37781 = fluree.db.util.async.throw_err(inst_37780);
var inst_37782 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_37781);
var inst_37783__$1 = cljs.core.not_empty(inst_37782);
var state_37893__$1 = (function (){var statearr_37898 = state_37893;
(statearr_37898[(8)] = inst_37783__$1);

return statearr_37898;
})();
if(cljs.core.truth_(inst_37783__$1)){
var statearr_37899_37993 = state_37893__$1;
(statearr_37899_37993[(1)] = (21));

} else {
var statearr_37900_37994 = state_37893__$1;
(statearr_37900_37994[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (58))){
var inst_37773 = (state_37893[(9)]);
var state_37893__$1 = state_37893;
var statearr_37901_37995 = state_37893__$1;
(statearr_37901_37995[(2)] = inst_37773);

(statearr_37901_37995[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (60))){
var inst_37880 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
var statearr_37902_37996 = state_37893__$1;
(statearr_37902_37996[(2)] = inst_37880);

(statearr_37902_37996[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (27))){
var inst_37815 = (state_37893[(10)]);
var inst_37813 = (state_37893[(11)]);
var inst_37805 = (state_37893[(12)]);
var inst_37812 = cljs.core.seq(inst_37805);
var inst_37813__$1 = cljs.core.first(inst_37812);
var inst_37814 = cljs.core.next(inst_37812);
var inst_37815__$1 = cljs.core.not(inst_37813__$1);
var state_37893__$1 = (function (){var statearr_37903 = state_37893;
(statearr_37903[(10)] = inst_37815__$1);

(statearr_37903[(11)] = inst_37813__$1);

(statearr_37903[(13)] = inst_37814);

return statearr_37903;
})();
if(inst_37815__$1){
var statearr_37904_37997 = state_37893__$1;
(statearr_37904_37997[(1)] = (29));

} else {
var statearr_37905_37998 = state_37893__$1;
(statearr_37905_37998[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (1))){
var state_37893__$1 = state_37893;
var statearr_37906_37999 = state_37893__$1;
(statearr_37906_37999[(2)] = null);

(statearr_37906_37999[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (24))){
var inst_37783 = (state_37893[(8)]);
var inst_37789 = cljs.core.count(inst_37783);
var inst_37790 = fluree.db.query.fql.add_fuel(fuel,inst_37789,max_fuel);
var state_37893__$1 = state_37893;
var statearr_37907_38000 = state_37893__$1;
(statearr_37907_38000[(2)] = inst_37790);

(statearr_37907_38000[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (55))){
var inst_37772 = (state_37893[(14)]);
var state_37893__$1 = state_37893;
var statearr_37908_38001 = state_37893__$1;
(statearr_37908_38001[(2)] = inst_37772);

(statearr_37908_38001[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (39))){
var inst_37770 = (state_37893[(15)]);
var state_37893__$1 = state_37893;
var statearr_37909_38002 = state_37893__$1;
(statearr_37909_38002[(2)] = inst_37770);

(statearr_37909_38002[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (46))){
var inst_37868 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
var statearr_37910_38003 = state_37893__$1;
(statearr_37910_38003[(2)] = inst_37868);

(statearr_37910_38003[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (4))){
var inst_37714 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
var statearr_37911_38004 = state_37893__$1;
(statearr_37911_38004[(2)] = inst_37714);

(statearr_37911_38004[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (54))){
var inst_37807 = (state_37893[(16)]);
var inst_37859 = (state_37893[(2)]);
var inst_37860 = fluree.db.util.async.throw_err(inst_37859);
var inst_37861 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37807,inst_37860);
var state_37893__$1 = state_37893;
var statearr_37912_38005 = state_37893__$1;
(statearr_37912_38005[(2)] = inst_37861);

(statearr_37912_38005[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (15))){
var state_37893__$1 = state_37893;
var statearr_37913_38006 = state_37893__$1;
(statearr_37913_38006[(2)] = false);

(statearr_37913_38006[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (48))){
var inst_37807 = (state_37893[(16)]);
var state_37893__$1 = state_37893;
var statearr_37914_38007 = state_37893__$1;
(statearr_37914_38007[(2)] = inst_37807);

(statearr_37914_38007[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (50))){
var inst_37806 = (state_37893[(17)]);
var inst_37814 = (state_37893[(13)]);
var inst_37863 = (state_37893[(2)]);
var inst_37864 = (inst_37806 + (1));
var inst_37805 = inst_37814;
var inst_37806__$1 = inst_37864;
var inst_37807 = inst_37863;
var state_37893__$1 = (function (){var statearr_37915 = state_37893;
(statearr_37915[(16)] = inst_37807);

(statearr_37915[(17)] = inst_37806__$1);

(statearr_37915[(12)] = inst_37805);

return statearr_37915;
})();
var statearr_37916_38008 = state_37893__$1;
(statearr_37916_38008[(2)] = null);

(statearr_37916_38008[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (21))){
var state_37893__$1 = state_37893;
var statearr_37917_38009 = state_37893__$1;
(statearr_37917_38009[(2)] = fuel);

(statearr_37917_38009[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (31))){
var inst_37824 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
if(cljs.core.truth_(inst_37824)){
var statearr_37918_38010 = state_37893__$1;
(statearr_37918_38010[(1)] = (35));

} else {
var statearr_37919_38011 = state_37893__$1;
(statearr_37919_38011[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (32))){
var inst_37771 = (state_37893[(18)]);
var inst_37806 = (state_37893[(17)]);
var inst_37819 = (inst_37806 >= inst_37771);
var state_37893__$1 = state_37893;
var statearr_37920_38012 = state_37893__$1;
(statearr_37920_38012[(2)] = inst_37819);

(statearr_37920_38012[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (40))){
var inst_37831 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
if(cljs.core.truth_(inst_37831)){
var statearr_37921_38013 = state_37893__$1;
(statearr_37921_38013[(1)] = (41));

} else {
var statearr_37922_38014 = state_37893__$1;
(statearr_37922_38014[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (56))){
var inst_37773 = (state_37893[(9)]);
var state_37893__$1 = state_37893;
if(cljs.core.truth_(inst_37773)){
var statearr_37923_38015 = state_37893__$1;
(statearr_37923_38015[(1)] = (58));

} else {
var statearr_37924_38016 = state_37893__$1;
(statearr_37924_38016[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (33))){
var inst_37771 = (state_37893[(18)]);
var state_37893__$1 = state_37893;
var statearr_37925_38017 = state_37893__$1;
(statearr_37925_38017[(2)] = inst_37771);

(statearr_37925_38017[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (13))){
var inst_37764 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
if(cljs.core.truth_(inst_37764)){
var statearr_37926_38018 = state_37893__$1;
(statearr_37926_38018[(1)] = (17));

} else {
var statearr_37927_38019 = state_37893__$1;
(statearr_37927_38019[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (22))){
var inst_37783 = (state_37893[(8)]);
var state_37893__$1 = state_37893;
var statearr_37929_38020 = state_37893__$1;
(statearr_37929_38020[(2)] = inst_37783);

(statearr_37929_38020[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (36))){
var inst_37770 = (state_37893[(15)]);
var state_37893__$1 = state_37893;
if(cljs.core.truth_(inst_37770)){
var statearr_37930_38021 = state_37893__$1;
(statearr_37930_38021[(1)] = (38));

} else {
var statearr_37931_38022 = state_37893__$1;
(statearr_37931_38022[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (41))){
var inst_37807 = (state_37893[(16)]);
var inst_37806 = (state_37893[(17)]);
var inst_37814 = (state_37893[(13)]);
var inst_37833 = (inst_37806 + (1));
var tmp37928 = inst_37807;
var inst_37805 = inst_37814;
var inst_37806__$1 = inst_37833;
var inst_37807__$1 = tmp37928;
var state_37893__$1 = (function (){var statearr_37932 = state_37893;
(statearr_37932[(16)] = inst_37807__$1);

(statearr_37932[(17)] = inst_37806__$1);

(statearr_37932[(12)] = inst_37805);

return statearr_37932;
})();
var statearr_37933_38023 = state_37893__$1;
(statearr_37933_38023[(2)] = null);

(statearr_37933_38023[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (43))){
var inst_37870 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
var statearr_37934_38024 = state_37893__$1;
(statearr_37934_38024[(2)] = inst_37870);

(statearr_37934_38024[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (29))){
var inst_37815 = (state_37893[(10)]);
var state_37893__$1 = state_37893;
var statearr_37935_38025 = state_37893__$1;
(statearr_37935_38025[(2)] = inst_37815);

(statearr_37935_38025[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (44))){
var inst_37813 = (state_37893[(11)]);
var inst_37837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37838 = [inst_37813];
var inst_37839 = (new cljs.core.PersistentVector(null,1,(5),inst_37837,inst_37838,null));
var inst_37840 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37839);
var state_37893__$1 = state_37893;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37893__$1,(47),inst_37840);
} else {
if((state_val_37894 === (6))){
var inst_37738 = (state_37893[(19)]);
var inst_37731 = (state_37893[(20)]);
var inst_37737 = cljs.core.seq(inst_37731);
var inst_37738__$1 = cljs.core.first(inst_37737);
var inst_37739 = cljs.core.next(inst_37737);
var inst_37740 = cljs.core.not(inst_37738__$1);
var state_37893__$1 = (function (){var statearr_37936 = state_37893;
(statearr_37936[(19)] = inst_37738__$1);

(statearr_37936[(21)] = inst_37739);

return statearr_37936;
})();
if(inst_37740){
var statearr_37937_38026 = state_37893__$1;
(statearr_37937_38026[(1)] = (8));

} else {
var statearr_37938_38027 = state_37893__$1;
(statearr_37938_38027[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (28))){
var inst_37772 = (state_37893[(14)]);
var inst_37874 = (state_37893[(2)]);
var state_37893__$1 = (function (){var statearr_37939 = state_37893;
(statearr_37939[(22)] = inst_37874);

return statearr_37939;
})();
if(cljs.core.truth_(inst_37772)){
var statearr_37940_38028 = state_37893__$1;
(statearr_37940_38028[(1)] = (55));

} else {
var statearr_37941_38029 = state_37893__$1;
(statearr_37941_38029[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (51))){
var inst_37843 = (state_37893[(23)]);
var inst_37852 = cljs.core.count(inst_37843);
var inst_37853 = fluree.db.query.fql.add_fuel(fuel,inst_37852,max_fuel);
var state_37893__$1 = state_37893;
var statearr_37942_38030 = state_37893__$1;
(statearr_37942_38030[(2)] = inst_37853);

(statearr_37942_38030[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (25))){
var state_37893__$1 = state_37893;
var statearr_37943_38031 = state_37893__$1;
(statearr_37943_38031[(2)] = null);

(statearr_37943_38031[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (34))){
var inst_37822 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
var statearr_37944_38032 = state_37893__$1;
(statearr_37944_38032[(2)] = inst_37822);

(statearr_37944_38032[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (17))){
var inst_37748 = (state_37893[(24)]);
var inst_37766 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37748);
var state_37893__$1 = state_37893;
var statearr_37945_38033 = state_37893__$1;
(statearr_37945_38033[(2)] = inst_37766);

(statearr_37945_38033[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (3))){
var inst_37891 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37893__$1,inst_37891);
} else {
if((state_val_37894 === (12))){
var state_37893__$1 = state_37893;
var statearr_37946_38034 = state_37893__$1;
(statearr_37946_38034[(2)] = false);

(statearr_37946_38034[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (2))){
var _ = (function (){var statearr_37947 = state_37893;
(statearr_37947[(4)] = cljs.core.cons((5),(state_37893[(4)])));

return statearr_37947;
})();
var inst_37727 = reverse_refs_specs;
var inst_37728 = cljs.core.seq(inst_37727);
var inst_37729 = cljs.core.first(inst_37728);
var inst_37730 = cljs.core.next(inst_37728);
var inst_37731 = inst_37727;
var inst_37732 = null;
var state_37893__$1 = (function (){var statearr_37948 = state_37893;
(statearr_37948[(25)] = inst_37732);

(statearr_37948[(26)] = inst_37729);

(statearr_37948[(27)] = inst_37730);

(statearr_37948[(20)] = inst_37731);

return statearr_37948;
})();
var statearr_37949_38035 = state_37893__$1;
(statearr_37949_38035[(2)] = null);

(statearr_37949_38035[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (23))){
var inst_37787 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
if(cljs.core.truth_(inst_37787)){
var statearr_37950_38036 = state_37893__$1;
(statearr_37950_38036[(1)] = (24));

} else {
var statearr_37951_38037 = state_37893__$1;
(statearr_37951_38037[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (47))){
var inst_37748 = (state_37893[(24)]);
var inst_37843 = (state_37893[(23)]);
var inst_37842 = (state_37893[(2)]);
var inst_37843__$1 = fluree.db.util.async.throw_err(inst_37842);
var inst_37844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37845 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_37846 = (new cljs.core.PersistentVector(null,4,(5),inst_37844,inst_37845,null));
var inst_37847 = cljs.core.select_keys(inst_37748,inst_37846);
var inst_37848 = cljs.core.empty_QMARK_(inst_37843__$1);
var state_37893__$1 = (function (){var statearr_37952 = state_37893;
(statearr_37952[(28)] = inst_37847);

(statearr_37952[(23)] = inst_37843__$1);

return statearr_37952;
})();
if(inst_37848){
var statearr_37953_38038 = state_37893__$1;
(statearr_37953_38038[(1)] = (48));

} else {
var statearr_37954_38039 = state_37893__$1;
(statearr_37954_38039[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (35))){
var inst_37807 = (state_37893[(16)]);
var state_37893__$1 = state_37893;
var statearr_37955_38040 = state_37893__$1;
(statearr_37955_38040[(2)] = inst_37807);

(statearr_37955_38040[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (19))){
var inst_37747 = (state_37893[(29)]);
var inst_37769 = (state_37893[(2)]);
var inst_37770 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37769,cljs.core.cst$kw$offset);
var inst_37771 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37769,cljs.core.cst$kw$limit);
var inst_37772 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37769,cljs.core.cst$kw$as);
var inst_37773 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37769,cljs.core.cst$kw$name);
var inst_37774 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37769,cljs.core.cst$kw$p);
var inst_37775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37776 = [subject_id,inst_37747];
var inst_37777 = (new cljs.core.PersistentVector(null,2,(5),inst_37775,inst_37776,null));
var inst_37778 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_37777);
var state_37893__$1 = (function (){var statearr_37956 = state_37893;
(statearr_37956[(9)] = inst_37773);

(statearr_37956[(14)] = inst_37772);

(statearr_37956[(15)] = inst_37770);

(statearr_37956[(18)] = inst_37771);

(statearr_37956[(7)] = inst_37774);

return statearr_37956;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37893__$1,(20),inst_37778);
} else {
if((state_val_37894 === (57))){
var inst_37732 = (state_37893[(25)]);
var inst_37874 = (state_37893[(22)]);
var inst_37739 = (state_37893[(21)]);
var inst_37882 = (state_37893[(2)]);
var inst_37883 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37732,inst_37882,inst_37874);
var inst_37731 = inst_37739;
var inst_37732__$1 = inst_37883;
var state_37893__$1 = (function (){var statearr_37957 = state_37893;
(statearr_37957[(25)] = inst_37732__$1);

(statearr_37957[(20)] = inst_37731);

return statearr_37957;
})();
var statearr_37958_38041 = state_37893__$1;
(statearr_37958_38041[(2)] = null);

(statearr_37958_38041[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (11))){
var inst_37748 = (state_37893[(24)]);
var inst_37753 = inst_37748.cljs$lang$protocol_mask$partition0$;
var inst_37754 = (inst_37753 & (64));
var inst_37755 = inst_37748.cljs$core$ISeq$;
var inst_37756 = (cljs.core.PROTOCOL_SENTINEL === inst_37755);
var inst_37757 = ((inst_37754) || (inst_37756));
var state_37893__$1 = state_37893;
if(cljs.core.truth_(inst_37757)){
var statearr_37960_38042 = state_37893__$1;
(statearr_37960_38042[(1)] = (14));

} else {
var statearr_37961_38043 = state_37893__$1;
(statearr_37961_38043[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (9))){
var inst_37738 = (state_37893[(19)]);
var inst_37748 = (state_37893[(24)]);
var inst_37747 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37738,(0),null);
var inst_37748__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37738,(1),null);
var inst_37750 = (inst_37748__$1 == null);
var inst_37751 = cljs.core.not(inst_37750);
var state_37893__$1 = (function (){var statearr_37962 = state_37893;
(statearr_37962[(29)] = inst_37747);

(statearr_37962[(24)] = inst_37748__$1);

return statearr_37962;
})();
if(inst_37751){
var statearr_37963_38044 = state_37893__$1;
(statearr_37963_38044[(1)] = (11));

} else {
var statearr_37964_38045 = state_37893__$1;
(statearr_37964_38045[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (5))){
var _ = (function (){var statearr_37965 = state_37893;
(statearr_37965[(4)] = cljs.core.rest((state_37893[(4)])));

return statearr_37965;
})();
var state_37893__$1 = state_37893;
var ex37959 = (state_37893__$1[(2)]);
var statearr_37966_38046 = state_37893__$1;
(statearr_37966_38046[(5)] = ex37959);


if((ex37959 instanceof Error)){
var statearr_37967_38047 = state_37893__$1;
(statearr_37967_38047[(1)] = (4));

(statearr_37967_38047[(5)] = null);

} else {
throw ex37959;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (14))){
var state_37893__$1 = state_37893;
var statearr_37968_38048 = state_37893__$1;
(statearr_37968_38048[(2)] = true);

(statearr_37968_38048[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (45))){
var state_37893__$1 = state_37893;
var statearr_37969_38049 = state_37893__$1;
(statearr_37969_38049[(2)] = null);

(statearr_37969_38049[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (53))){
var inst_37847 = (state_37893[(28)]);
var inst_37843 = (state_37893[(23)]);
var inst_37856 = (state_37893[(2)]);
var inst_37857 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_37847,inst_37843) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_37847,inst_37843));
var state_37893__$1 = (function (){var statearr_37970 = state_37893;
(statearr_37970[(30)] = inst_37856);

return statearr_37970;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37893__$1,(54),inst_37857);
} else {
if((state_val_37894 === (26))){
var inst_37783 = (state_37893[(8)]);
var inst_37793 = (state_37893[(2)]);
var inst_37801 = cljs.core.seq(inst_37783);
var inst_37802 = cljs.core.first(inst_37801);
var inst_37803 = cljs.core.next(inst_37801);
var inst_37804 = cljs.core.PersistentVector.EMPTY;
var inst_37805 = inst_37783;
var inst_37806 = (0);
var inst_37807 = inst_37804;
var state_37893__$1 = (function (){var statearr_37971 = state_37893;
(statearr_37971[(31)] = inst_37802);

(statearr_37971[(16)] = inst_37807);

(statearr_37971[(32)] = inst_37793);

(statearr_37971[(17)] = inst_37806);

(statearr_37971[(33)] = inst_37803);

(statearr_37971[(12)] = inst_37805);

return statearr_37971;
})();
var statearr_37972_38050 = state_37893__$1;
(statearr_37972_38050[(2)] = null);

(statearr_37972_38050[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (16))){
var inst_37761 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
var statearr_37973_38051 = state_37893__$1;
(statearr_37973_38051[(2)] = inst_37761);

(statearr_37973_38051[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (38))){
var inst_37770 = (state_37893[(15)]);
var inst_37806 = (state_37893[(17)]);
var inst_37828 = (inst_37806 < inst_37770);
var state_37893__$1 = state_37893;
var statearr_37974_38052 = state_37893__$1;
(statearr_37974_38052[(2)] = inst_37828);

(statearr_37974_38052[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (30))){
var inst_37771 = (state_37893[(18)]);
var state_37893__$1 = state_37893;
if(cljs.core.truth_(inst_37771)){
var statearr_37975_38053 = state_37893__$1;
(statearr_37975_38053[(1)] = (32));

} else {
var statearr_37976_38054 = state_37893__$1;
(statearr_37976_38054[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (10))){
var inst_37886 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
var statearr_37977_38055 = state_37893__$1;
(statearr_37977_38055[(2)] = inst_37886);

(statearr_37977_38055[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (18))){
var inst_37748 = (state_37893[(24)]);
var state_37893__$1 = state_37893;
var statearr_37978_38056 = state_37893__$1;
(statearr_37978_38056[(2)] = inst_37748);

(statearr_37978_38056[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (52))){
var state_37893__$1 = state_37893;
var statearr_37979_38057 = state_37893__$1;
(statearr_37979_38057[(2)] = null);

(statearr_37979_38057[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (42))){
var state_37893__$1 = state_37893;
var statearr_37980_38058 = state_37893__$1;
(statearr_37980_38058[(1)] = (44));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (37))){
var inst_37872 = (state_37893[(2)]);
var state_37893__$1 = state_37893;
var statearr_37982_38059 = state_37893__$1;
(statearr_37982_38059[(2)] = inst_37872);

(statearr_37982_38059[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (8))){
var inst_37732 = (state_37893[(25)]);
var state_37893__$1 = state_37893;
var statearr_37983_38060 = state_37893__$1;
(statearr_37983_38060[(2)] = inst_37732);

(statearr_37983_38060[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37894 === (49))){
var state_37893__$1 = state_37893;
if(cljs.core.truth_(fuel)){
var statearr_37984_38061 = state_37893__$1;
(statearr_37984_38061[(1)] = (51));

} else {
var statearr_37985_38062 = state_37893__$1;
(statearr_37985_38062[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____0 = (function (){
var statearr_37986 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37986[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__);

(statearr_37986[(1)] = (1));

return statearr_37986;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____1 = (function (state_37893){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_37893);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e37987){var ex__16304__auto__ = e37987;
var statearr_37988_38063 = state_37893;
(statearr_37988_38063[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_37893[(4)]))){
var statearr_37989_38064 = state_37893;
(statearr_37989_38064[(1)] = cljs.core.first((state_37893[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38065 = state_37893;
state_37893 = G__38065;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__ = function(state_37893){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____1.call(this,state_37893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_37990 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_37990[(6)] = c__16375__auto__);

return statearr_37990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__38066 = select_spec;
var map__38066__$1 = (((((!((map__38066 == null))))?(((((map__38066.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38066.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38066):map__38066);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38066__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38066__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38149){
var state_val_38150 = (state_38149[(1)]);
if((state_val_38150 === (7))){
var state_38149__$1 = state_38149;
var statearr_38151_38203 = state_38149__$1;
(statearr_38151_38203[(2)] = false);

(statearr_38151_38203[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (20))){
var inst_38105 = (state_38149[(7)]);
var state_38149__$1 = state_38149;
if(cljs.core.truth_(inst_38105)){
var statearr_38152_38204 = state_38149__$1;
(statearr_38152_38204[(1)] = (22));

} else {
var statearr_38153_38205 = state_38149__$1;
(statearr_38153_38205[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (27))){
var inst_38128 = (state_38149[(8)]);
var inst_38134 = (state_38149[(2)]);
var state_38149__$1 = (function (){var statearr_38154 = state_38149;
(statearr_38154[(9)] = inst_38134);

return statearr_38154;
})();
if(cljs.core.truth_(inst_38128)){
var statearr_38155_38206 = state_38149__$1;
(statearr_38155_38206[(1)] = (28));

} else {
var statearr_38156_38207 = state_38149__$1;
(statearr_38156_38207[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (1))){
var state_38149__$1 = state_38149;
var statearr_38157_38208 = state_38149__$1;
(statearr_38157_38208[(2)] = null);

(statearr_38157_38208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (24))){
var inst_38126 = (state_38149[(2)]);
var state_38149__$1 = state_38149;
var statearr_38158_38209 = state_38149__$1;
(statearr_38158_38209[(2)] = inst_38126);

(statearr_38158_38209[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (4))){
var inst_38068 = (state_38149[(2)]);
var state_38149__$1 = state_38149;
var statearr_38159_38210 = state_38149__$1;
(statearr_38159_38210[(2)] = inst_38068);

(statearr_38159_38210[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (15))){
var inst_38112 = (state_38149[(2)]);
var inst_38113 = fluree.db.util.async.throw_err(inst_38112);
var state_38149__$1 = (function (){var statearr_38160 = state_38149;
(statearr_38160[(10)] = inst_38113);

return statearr_38160;
})();
if(cljs.core.truth_(fuel)){
var statearr_38161_38211 = state_38149__$1;
(statearr_38161_38211[(1)] = (16));

} else {
var statearr_38162_38212 = state_38149__$1;
(statearr_38162_38212[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (21))){
var inst_38098 = (state_38149[(11)]);
var inst_38128 = (state_38149[(2)]);
var state_38149__$1 = (function (){var statearr_38163 = state_38149;
(statearr_38163[(8)] = inst_38128);

return statearr_38163;
})();
if(cljs.core.truth_(inst_38098)){
var statearr_38164_38213 = state_38149__$1;
(statearr_38164_38213[(1)] = (25));

} else {
var statearr_38165_38214 = state_38149__$1;
(statearr_38165_38214[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (31))){
var inst_38134 = (state_38149[(9)]);
var inst_38099 = (state_38149[(12)]);
var inst_38140 = (state_38149[(2)]);
var inst_38141 = fluree.db.util.async.throw_err(inst_38140);
var inst_38142 = (inst_38134.cljs$core$IFn$_invoke$arity$3 ? inst_38134.cljs$core$IFn$_invoke$arity$3(acc,inst_38099,inst_38141) : inst_38134.call(null,acc,inst_38099,inst_38141));
var state_38149__$1 = state_38149;
var statearr_38166_38215 = state_38149__$1;
(statearr_38166_38215[(2)] = inst_38142);

(statearr_38166_38215[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (13))){
var inst_38076 = (state_38149[(13)]);
var state_38149__$1 = state_38149;
var statearr_38167_38216 = state_38149__$1;
(statearr_38167_38216[(2)] = inst_38076);

(statearr_38167_38216[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (22))){
var inst_38105 = (state_38149[(7)]);
var state_38149__$1 = state_38149;
var statearr_38168_38217 = state_38149__$1;
(statearr_38168_38217[(2)] = inst_38105);

(statearr_38168_38217[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (29))){
var inst_38119 = (state_38149[(14)]);
var inst_38137 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_38138 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38137,inst_38119) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38137,inst_38119));
var state_38149__$1 = state_38149;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38149__$1,(31),inst_38138);
} else {
if((state_val_38150 === (6))){
var inst_38076 = (state_38149[(13)]);
var inst_38081 = inst_38076.cljs$lang$protocol_mask$partition0$;
var inst_38082 = (inst_38081 & (64));
var inst_38083 = inst_38076.cljs$core$ISeq$;
var inst_38084 = (cljs.core.PROTOCOL_SENTINEL === inst_38083);
var inst_38085 = ((inst_38082) || (inst_38084));
var state_38149__$1 = state_38149;
if(cljs.core.truth_(inst_38085)){
var statearr_38169_38218 = state_38149__$1;
(statearr_38169_38218[(1)] = (9));

} else {
var statearr_38170_38219 = state_38149__$1;
(statearr_38170_38219[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (28))){
var state_38149__$1 = state_38149;
var statearr_38171_38220 = state_38149__$1;
(statearr_38171_38220[(2)] = acc);

(statearr_38171_38220[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (25))){
var inst_38128 = (state_38149[(8)]);
var inst_38100 = (state_38149[(15)]);
var inst_38102 = (state_38149[(16)]);
var inst_38098 = (state_38149[(11)]);
var inst_38101 = (state_38149[(17)]);
var inst_38104 = (state_38149[(18)]);
var inst_38103 = (state_38149[(19)]);
var inst_38119 = (state_38149[(14)]);
var inst_38097 = (state_38149[(20)]);
var inst_38099 = (state_38149[(12)]);
var inst_38105 = (state_38149[(7)]);
var inst_38075 = (state_38149[(21)]);
var inst_38130 = (function (){var recur_seen = inst_38101;
var recur_subject = inst_38075;
var map__38074 = inst_38097;
var sub_flakes = inst_38119;
var seen_QMARK_ = inst_38104;
var multi_QMARK_ = inst_38098;
var limit = inst_38103;
var recur_depth = inst_38102;
var as = inst_38099;
var max_depth_QMARK_ = inst_38105;
var recur = inst_38100;
var stop_QMARK_ = inst_38128;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_38149__$1 = state_38149;
var statearr_38172_38221 = state_38149__$1;
(statearr_38172_38221[(2)] = inst_38130);

(statearr_38172_38221[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (17))){
var inst_38113 = (state_38149[(10)]);
var state_38149__$1 = state_38149;
var statearr_38173_38222 = state_38149__$1;
(statearr_38173_38222[(2)] = inst_38113);

(statearr_38173_38222[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (3))){
var inst_38147 = (state_38149[(2)]);
var state_38149__$1 = state_38149;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38149__$1,inst_38147);
} else {
if((state_val_38150 === (12))){
var inst_38076 = (state_38149[(13)]);
var inst_38094 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38076);
var state_38149__$1 = state_38149;
var statearr_38174_38223 = state_38149__$1;
(statearr_38174_38223[(2)] = inst_38094);

(statearr_38174_38223[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (2))){
var inst_38076 = (state_38149[(13)]);
var _ = (function (){var statearr_38175 = state_38149;
(statearr_38175[(4)] = cljs.core.cons((5),(state_38149[(4)])));

return statearr_38175;
})();
var inst_38075 = flake.o;
var inst_38076__$1 = select_spec;
var inst_38078 = (inst_38076__$1 == null);
var inst_38079 = cljs.core.not(inst_38078);
var state_38149__$1 = (function (){var statearr_38176 = state_38149;
(statearr_38176[(13)] = inst_38076__$1);

(statearr_38176[(21)] = inst_38075);

return statearr_38176;
})();
if(inst_38079){
var statearr_38177_38224 = state_38149__$1;
(statearr_38177_38224[(1)] = (6));

} else {
var statearr_38178_38225 = state_38149__$1;
(statearr_38178_38225[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (23))){
var inst_38119 = (state_38149[(14)]);
var inst_38124 = cljs.core.empty_QMARK_(inst_38119);
var state_38149__$1 = state_38149;
var statearr_38179_38226 = state_38149__$1;
(statearr_38179_38226[(2)] = inst_38124);

(statearr_38179_38226[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (19))){
var inst_38104 = (state_38149[(18)]);
var state_38149__$1 = state_38149;
var statearr_38180_38227 = state_38149__$1;
(statearr_38180_38227[(2)] = inst_38104);

(statearr_38180_38227[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (11))){
var inst_38089 = (state_38149[(2)]);
var state_38149__$1 = state_38149;
var statearr_38182_38228 = state_38149__$1;
(statearr_38182_38228[(2)] = inst_38089);

(statearr_38182_38228[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (9))){
var state_38149__$1 = state_38149;
var statearr_38183_38229 = state_38149__$1;
(statearr_38183_38229[(2)] = true);

(statearr_38183_38229[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (5))){
var _ = (function (){var statearr_38184 = state_38149;
(statearr_38184[(4)] = cljs.core.rest((state_38149[(4)])));

return statearr_38184;
})();
var state_38149__$1 = state_38149;
var ex38181 = (state_38149__$1[(2)]);
var statearr_38185_38230 = state_38149__$1;
(statearr_38185_38230[(5)] = ex38181);


if((ex38181 instanceof Error)){
var statearr_38186_38231 = state_38149__$1;
(statearr_38186_38231[(1)] = (4));

(statearr_38186_38231[(5)] = null);

} else {
throw ex38181;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (14))){
var inst_38100 = (state_38149[(15)]);
var inst_38102 = (state_38149[(16)]);
var inst_38101 = (state_38149[(17)]);
var inst_38097 = (state_38149[(20)]);
var inst_38075 = (state_38149[(21)]);
var inst_38097__$1 = (state_38149[(2)]);
var inst_38098 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38097__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_38099 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38097__$1,cljs.core.cst$kw$as);
var inst_38100__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38097__$1,cljs.core.cst$kw$recur);
var inst_38101__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38097__$1,cljs.core.cst$kw$recur_DASH_seen);
var inst_38102__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38097__$1,cljs.core.cst$kw$recur_DASH_depth);
var inst_38103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38097__$1,cljs.core.cst$kw$limit);
var inst_38104 = cljs.core.contains_QMARK_(inst_38101__$1,inst_38075);
var inst_38105 = (inst_38102__$1 > inst_38100__$1);
var inst_38107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38108 = [inst_38075];
var inst_38109 = (new cljs.core.PersistentVector(null,1,(5),inst_38107,inst_38108,null));
var inst_38110 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38109);
var state_38149__$1 = (function (){var statearr_38187 = state_38149;
(statearr_38187[(15)] = inst_38100__$1);

(statearr_38187[(16)] = inst_38102__$1);

(statearr_38187[(11)] = inst_38098);

(statearr_38187[(17)] = inst_38101__$1);

(statearr_38187[(18)] = inst_38104);

(statearr_38187[(19)] = inst_38103);

(statearr_38187[(20)] = inst_38097__$1);

(statearr_38187[(12)] = inst_38099);

(statearr_38187[(7)] = inst_38105);

return statearr_38187;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38149__$1,(15),inst_38110);
} else {
if((state_val_38150 === (26))){
var inst_38128 = (state_38149[(8)]);
var inst_38100 = (state_38149[(15)]);
var inst_38102 = (state_38149[(16)]);
var inst_38098 = (state_38149[(11)]);
var inst_38101 = (state_38149[(17)]);
var inst_38104 = (state_38149[(18)]);
var inst_38103 = (state_38149[(19)]);
var inst_38119 = (state_38149[(14)]);
var inst_38097 = (state_38149[(20)]);
var inst_38099 = (state_38149[(12)]);
var inst_38105 = (state_38149[(7)]);
var inst_38075 = (state_38149[(21)]);
var inst_38132 = (function (){var recur_seen = inst_38101;
var recur_subject = inst_38075;
var map__38074 = inst_38097;
var sub_flakes = inst_38119;
var seen_QMARK_ = inst_38104;
var multi_QMARK_ = inst_38098;
var limit = inst_38103;
var recur_depth = inst_38102;
var as = inst_38099;
var max_depth_QMARK_ = inst_38105;
var recur = inst_38100;
var stop_QMARK_ = inst_38128;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_38149__$1 = state_38149;
var statearr_38188_38232 = state_38149__$1;
(statearr_38188_38232[(2)] = inst_38132);

(statearr_38188_38232[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (16))){
var inst_38113 = (state_38149[(10)]);
var inst_38115 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_38116 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38115,inst_38113);
var state_38149__$1 = state_38149;
var statearr_38189_38233 = state_38149__$1;
(statearr_38189_38233[(2)] = inst_38116);

(statearr_38189_38233[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (30))){
var inst_38144 = (state_38149[(2)]);
var _ = (function (){var statearr_38190 = state_38149;
(statearr_38190[(4)] = cljs.core.rest((state_38149[(4)])));

return statearr_38190;
})();
var state_38149__$1 = state_38149;
var statearr_38191_38234 = state_38149__$1;
(statearr_38191_38234[(2)] = inst_38144);

(statearr_38191_38234[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (10))){
var state_38149__$1 = state_38149;
var statearr_38192_38235 = state_38149__$1;
(statearr_38192_38235[(2)] = false);

(statearr_38192_38235[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (18))){
var inst_38104 = (state_38149[(18)]);
var inst_38119 = (state_38149[(2)]);
var state_38149__$1 = (function (){var statearr_38193 = state_38149;
(statearr_38193[(14)] = inst_38119);

return statearr_38193;
})();
if(cljs.core.truth_(inst_38104)){
var statearr_38194_38236 = state_38149__$1;
(statearr_38194_38236[(1)] = (19));

} else {
var statearr_38195_38237 = state_38149__$1;
(statearr_38195_38237[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38150 === (8))){
var inst_38092 = (state_38149[(2)]);
var state_38149__$1 = state_38149;
if(cljs.core.truth_(inst_38092)){
var statearr_38196_38238 = state_38149__$1;
(statearr_38196_38238[(1)] = (12));

} else {
var statearr_38197_38239 = state_38149__$1;
(statearr_38197_38239[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____0 = (function (){
var statearr_38198 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38198[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__);

(statearr_38198[(1)] = (1));

return statearr_38198;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____1 = (function (state_38149){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38149);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38199){var ex__16304__auto__ = e38199;
var statearr_38200_38240 = state_38149;
(statearr_38200_38240[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38149[(4)]))){
var statearr_38201_38241 = state_38149;
(statearr_38201_38241[(1)] = cljs.core.first((state_38149[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38242 = state_38149;
state_38149 = G__38242;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__ = function(state_38149){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____1.call(this,state_38149);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38202 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38202[(6)] = c__16375__auto__);

return statearr_38202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38420){
var state_val_38421 = (state_38420[(1)]);
if((state_val_38421 === (7))){
var state_38420__$1 = state_38420;
var statearr_38422_38507 = state_38420__$1;
(statearr_38422_38507[(2)] = null);

(statearr_38422_38507[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (20))){
var inst_38281 = cljs.core.PersistentHashMap.EMPTY;
var state_38420__$1 = state_38420;
var statearr_38423_38508 = state_38420__$1;
(statearr_38423_38508[(2)] = inst_38281);

(statearr_38423_38508[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (27))){
var inst_38263 = (state_38420[(7)]);
var inst_38299 = (state_38420[(8)]);
var inst_38269 = (state_38420[(9)]);
var inst_38283 = (state_38420[(10)]);
var inst_38399 = (state_38420[(2)]);
var inst_38400 = (function (){var top_level_subject = inst_38263;
var select_spec = inst_38269;
var base_acc = inst_38283;
var acc_PLUS_refs = inst_38299;
var result = inst_38399;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_38401 = cljs.core.PersistentVector.EMPTY;
var inst_38402 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38269);
var inst_38403 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_38402);
var inst_38404 = cljs.core.vals(inst_38403);
var inst_38405 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38269);
var inst_38406 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_38405);
var inst_38407 = cljs.core.vals(inst_38406);
var inst_38408 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38404,inst_38407);
var inst_38409 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_38400,inst_38401,inst_38408);
var inst_38411 = (function (){var top_level_subject = inst_38263;
var select_spec = inst_38269;
var base_acc = inst_38283;
var acc_PLUS_refs = inst_38299;
var result = inst_38399;
var sort_preds = inst_38409;
return (function (acc,p__38410){
var vec__38424 = p__38410;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38424,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38424,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38424,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38424,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_38412 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_38411,inst_38399,inst_38409);
var state_38420__$1 = state_38420;
var statearr_38427_38509 = state_38420__$1;
(statearr_38427_38509[(2)] = inst_38412);

(statearr_38427_38509[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (1))){
var state_38420__$1 = state_38420;
var statearr_38428_38510 = state_38420__$1;
(statearr_38428_38510[(2)] = null);

(statearr_38428_38510[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (24))){
var inst_38299 = (state_38420[(8)]);
var inst_38299__$1 = (state_38420[(2)]);
var inst_38300 = flakes;
var inst_38301 = cljs.core.PersistentHashMap.EMPTY;
var inst_38302 = inst_38300;
var inst_38303 = inst_38299__$1;
var inst_38304 = inst_38301;
var state_38420__$1 = (function (){var statearr_38429 = state_38420;
(statearr_38429[(11)] = inst_38304);

(statearr_38429[(8)] = inst_38299__$1);

(statearr_38429[(12)] = inst_38302);

(statearr_38429[(13)] = inst_38303);

return statearr_38429;
})();
var statearr_38430_38511 = state_38420__$1;
(statearr_38430_38511[(2)] = null);

(statearr_38430_38511[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (39))){
var inst_38318 = (state_38420[(14)]);
var inst_38303 = (state_38420[(13)]);
var inst_38269 = (state_38420[(9)]);
var inst_38312 = (state_38420[(15)]);
var inst_38347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38348 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_38303,inst_38269,inst_38312,inst_38318,false);
var state_38420__$1 = (function (){var statearr_38431 = state_38420;
(statearr_38431[(16)] = inst_38347);

return statearr_38431;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38420__$1,(42),inst_38348);
} else {
if((state_val_38421 === (46))){
var inst_38304 = (state_38420[(11)]);
var inst_38302 = (state_38420[(12)]);
var inst_38312 = (state_38420[(15)]);
var inst_38365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38366 = ["_id"];
var inst_38367 = inst_38312.s;
var inst_38368 = [inst_38367];
var inst_38369 = cljs.core.PersistentHashMap.fromArrays(inst_38366,inst_38368);
var inst_38370 = cljs.core.rest(inst_38302);
var inst_38371 = [inst_38369,inst_38370,inst_38304];
var inst_38372 = (new cljs.core.PersistentVector(null,3,(5),inst_38365,inst_38371,null));
var state_38420__$1 = state_38420;
var statearr_38432_38512 = state_38420__$1;
(statearr_38432_38512[(2)] = inst_38372);

(statearr_38432_38512[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (4))){
var inst_38243 = (state_38420[(2)]);
var state_38420__$1 = state_38420;
var statearr_38433_38513 = state_38420__$1;
(statearr_38433_38513[(2)] = inst_38243);

(statearr_38433_38513[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (15))){
var inst_38269 = (state_38420[(9)]);
var inst_38270 = (state_38420[(17)]);
var inst_38269__$1 = (state_38420[(2)]);
var inst_38270__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38269__$1);
var state_38420__$1 = (function (){var statearr_38434 = state_38420;
(statearr_38434[(9)] = inst_38269__$1);

(statearr_38434[(17)] = inst_38270__$1);

return statearr_38434;
})();
if(cljs.core.truth_(inst_38270__$1)){
var statearr_38435_38514 = state_38420__$1;
(statearr_38435_38514[(1)] = (16));

} else {
var statearr_38436_38515 = state_38420__$1;
(statearr_38436_38515[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (48))){
var inst_38383 = (state_38420[(2)]);
var state_38420__$1 = state_38420;
var statearr_38437_38516 = state_38420__$1;
(statearr_38437_38516[(2)] = inst_38383);

(statearr_38437_38516[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (50))){
var state_38420__$1 = state_38420;
var statearr_38438_38517 = state_38420__$1;
(statearr_38438_38517[(2)] = null);

(statearr_38438_38517[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (21))){
var inst_38269 = (state_38420[(9)]);
var inst_38283 = (state_38420[(2)]);
var inst_38284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38285 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_38286 = (new cljs.core.PersistentVector(null,2,(5),inst_38284,inst_38285,null));
var inst_38287 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38269,inst_38286);
var state_38420__$1 = (function (){var statearr_38439 = state_38420;
(statearr_38439[(10)] = inst_38283);

return statearr_38439;
})();
if(cljs.core.truth_(inst_38287)){
var statearr_38440_38518 = state_38420__$1;
(statearr_38440_38518[(1)] = (22));

} else {
var statearr_38441_38519 = state_38420__$1;
(statearr_38441_38519[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (31))){
var inst_38303 = (state_38420[(13)]);
var inst_38317 = (state_38420[(18)]);
var inst_38312 = (state_38420[(15)]);
var inst_38321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38322 = fluree.db.query.fql.flake__GT_recur(db,inst_38312,inst_38317,inst_38303,fuel,max_fuel,cache);
var state_38420__$1 = (function (){var statearr_38442 = state_38420;
(statearr_38442[(19)] = inst_38321);

return statearr_38442;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38420__$1,(34),inst_38322);
} else {
if((state_val_38421 === (32))){
var inst_38317 = (state_38420[(18)]);
var state_38420__$1 = state_38420;
if(cljs.core.truth_(inst_38317)){
var statearr_38443_38520 = state_38420__$1;
(statearr_38443_38520[(1)] = (35));

} else {
var statearr_38444_38521 = state_38420__$1;
(statearr_38444_38521[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (40))){
var inst_38269 = (state_38420[(9)]);
var inst_38357 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38269);
var inst_38358 = cljs.core.empty_QMARK_(inst_38357);
var state_38420__$1 = state_38420;
if(inst_38358){
var statearr_38445_38522 = state_38420__$1;
(statearr_38445_38522[(1)] = (43));

} else {
var statearr_38446_38523 = state_38420__$1;
(statearr_38446_38523[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (33))){
var inst_38312 = (state_38420[(15)]);
var inst_38389 = (state_38420[(2)]);
var inst_38390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38389,(0),null);
var inst_38391 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38389,(1),null);
var inst_38392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38389,(2),null);
var inst_38393 = inst_38312.s;
var inst_38394 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38390,cljs.core.cst$kw$_id,inst_38393);
var inst_38302 = inst_38391;
var inst_38303 = inst_38394;
var inst_38304 = inst_38392;
var state_38420__$1 = (function (){var statearr_38447 = state_38420;
(statearr_38447[(11)] = inst_38304);

(statearr_38447[(12)] = inst_38302);

(statearr_38447[(13)] = inst_38303);

return statearr_38447;
})();
var statearr_38448_38524 = state_38420__$1;
(statearr_38448_38524[(2)] = null);

(statearr_38448_38524[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (13))){
var inst_38263 = (state_38420[(7)]);
var inst_38266 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_38263);
var state_38420__$1 = state_38420;
var statearr_38449_38525 = state_38420__$1;
(statearr_38449_38525[(2)] = inst_38266);

(statearr_38449_38525[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (22))){
var inst_38269 = (state_38420[(9)]);
var inst_38289 = cljs.core.first(flakes);
var inst_38290 = fluree.db.query.fql.s(inst_38289);
var inst_38291 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_38269);
var inst_38292 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_38290,inst_38291);
var state_38420__$1 = state_38420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38420__$1,(25),inst_38292);
} else {
if((state_val_38421 === (36))){
var inst_38269 = (state_38420[(9)]);
var inst_38345 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38269);
var state_38420__$1 = state_38420;
if(cljs.core.truth_(inst_38345)){
var statearr_38450_38526 = state_38420__$1;
(statearr_38450_38526[(1)] = (39));

} else {
var statearr_38451_38527 = state_38420__$1;
(statearr_38451_38527[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (41))){
var inst_38385 = (state_38420[(2)]);
var state_38420__$1 = state_38420;
var statearr_38452_38528 = state_38420__$1;
(statearr_38452_38528[(2)] = inst_38385);

(statearr_38452_38528[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (43))){
var inst_38269 = (state_38420[(9)]);
var inst_38360 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38269);
var state_38420__$1 = state_38420;
var statearr_38453_38529 = state_38420__$1;
(statearr_38453_38529[(2)] = inst_38360);

(statearr_38453_38529[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (29))){
var inst_38302 = (state_38420[(12)]);
var inst_38317 = (state_38420[(18)]);
var inst_38269 = (state_38420[(9)]);
var inst_38312 = (state_38420[(15)]);
var inst_38312__$1 = cljs.core.first(inst_38302);
var inst_38313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38314 = inst_38312__$1.p;
var inst_38315 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_38314];
var inst_38316 = (new cljs.core.PersistentVector(null,3,(5),inst_38313,inst_38315,null));
var inst_38317__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38269,inst_38316);
var inst_38318 = fluree.db.query.fql.component_follow_QMARK_(inst_38317__$1,inst_38269);
var inst_38319 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_38317__$1);
var state_38420__$1 = (function (){var statearr_38454 = state_38420;
(statearr_38454[(14)] = inst_38318);

(statearr_38454[(18)] = inst_38317__$1);

(statearr_38454[(15)] = inst_38312__$1);

return statearr_38454;
})();
if(cljs.core.truth_(inst_38319)){
var statearr_38455_38530 = state_38420__$1;
(statearr_38455_38530[(1)] = (31));

} else {
var statearr_38456_38531 = state_38420__$1;
(statearr_38456_38531[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (44))){
var state_38420__$1 = state_38420;
var statearr_38457_38532 = state_38420__$1;
(statearr_38457_38532[(2)] = false);

(statearr_38457_38532[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (6))){
var state_38420__$1 = state_38420;
var statearr_38458_38533 = state_38420__$1;
(statearr_38458_38533[(2)] = null);

(statearr_38458_38533[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (28))){
var inst_38303 = (state_38420[(13)]);
var state_38420__$1 = state_38420;
var statearr_38459_38534 = state_38420__$1;
(statearr_38459_38534[(2)] = inst_38303);

(statearr_38459_38534[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (51))){
var inst_38381 = (state_38420[(2)]);
var state_38420__$1 = state_38420;
var statearr_38460_38535 = state_38420__$1;
(statearr_38460_38535[(2)] = inst_38381);

(statearr_38460_38535[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (25))){
var inst_38283 = (state_38420[(10)]);
var inst_38294 = (state_38420[(2)]);
var inst_38295 = fluree.db.util.async.throw_err(inst_38294);
var inst_38296 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38283,inst_38295], 0));
var state_38420__$1 = state_38420;
var statearr_38461_38536 = state_38420__$1;
(statearr_38461_38536[(2)] = inst_38296);

(statearr_38461_38536[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (34))){
var inst_38304 = (state_38420[(11)]);
var inst_38302 = (state_38420[(12)]);
var inst_38321 = (state_38420[(19)]);
var inst_38324 = (state_38420[(2)]);
var inst_38325 = fluree.db.util.async.throw_err(inst_38324);
var inst_38326 = cljs.core.rest(inst_38302);
var inst_38327 = [inst_38325,inst_38326,inst_38304];
var inst_38328 = (new cljs.core.PersistentVector(null,3,(5),inst_38321,inst_38327,null));
var state_38420__$1 = state_38420;
var statearr_38462_38537 = state_38420__$1;
(statearr_38462_38537[(2)] = inst_38328);

(statearr_38462_38537[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (17))){
var inst_38269 = (state_38420[(9)]);
var inst_38273 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38269);
var state_38420__$1 = state_38420;
var statearr_38464_38538 = state_38420__$1;
(statearr_38464_38538[(2)] = inst_38273);

(statearr_38464_38538[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (3))){
var inst_38418 = (state_38420[(2)]);
var state_38420__$1 = state_38420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38420__$1,inst_38418);
} else {
if((state_val_38421 === (12))){
var _ = (function (){var statearr_38465 = state_38420;
(statearr_38465[(4)] = cljs.core.rest((state_38420[(4)])));

return statearr_38465;
})();
var state_38420__$1 = state_38420;
var ex38463 = (state_38420__$1[(2)]);
var statearr_38466_38539 = state_38420__$1;
(statearr_38466_38539[(5)] = ex38463);


var statearr_38467_38540 = state_38420__$1;
(statearr_38467_38540[(1)] = (11));

(statearr_38467_38540[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (2))){
var _ = (function (){var statearr_38468 = state_38420;
(statearr_38468[(4)] = cljs.core.cons((5),(state_38420[(4)])));

return statearr_38468;
})();
var inst_38249 = cljs.core.not_empty(flakes);
var state_38420__$1 = state_38420;
if(cljs.core.truth_(inst_38249)){
var statearr_38469_38541 = state_38420__$1;
(statearr_38469_38541[(1)] = (6));

} else {
var statearr_38470_38542 = state_38420__$1;
(statearr_38470_38542[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (23))){
var inst_38283 = (state_38420[(10)]);
var state_38420__$1 = state_38420;
var statearr_38471_38543 = state_38420__$1;
(statearr_38471_38543[(2)] = inst_38283);

(statearr_38471_38543[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (47))){
var state_38420__$1 = state_38420;
var statearr_38472_38544 = state_38420__$1;
(statearr_38472_38544[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (35))){
var inst_38304 = (state_38420[(11)]);
var inst_38318 = (state_38420[(14)]);
var inst_38303 = (state_38420[(13)]);
var inst_38317 = (state_38420[(18)]);
var inst_38312 = (state_38420[(15)]);
var inst_38334 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_38303,inst_38317,inst_38312,inst_38318,false,inst_38304);
var state_38420__$1 = state_38420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38420__$1,(38),inst_38334);
} else {
if((state_val_38421 === (19))){
var inst_38263 = (state_38420[(7)]);
var inst_38277 = ["_id"];
var inst_38278 = [inst_38263];
var inst_38279 = cljs.core.PersistentHashMap.fromArrays(inst_38277,inst_38278);
var state_38420__$1 = state_38420;
var statearr_38474_38545 = state_38420__$1;
(statearr_38474_38545[(2)] = inst_38279);

(statearr_38474_38545[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (11))){
var inst_38251 = (state_38420[(2)]);
var inst_38252 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38251], 0));
var inst_38253 = (function(){throw inst_38251})();
var state_38420__$1 = (function (){var statearr_38476 = state_38420;
(statearr_38476[(20)] = inst_38252);

return statearr_38476;
})();
var statearr_38477_38546 = state_38420__$1;
(statearr_38477_38546[(2)] = inst_38253);

(statearr_38477_38546[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (9))){
var _ = (function (){var statearr_38478 = state_38420;
(statearr_38478[(4)] = cljs.core.cons((12),(state_38420[(4)])));

return statearr_38478;
})();
var inst_38259 = cljs.core.first(flakes);
var inst_38260 = fluree.db.query.fql.s(inst_38259);
var ___$1 = (function (){var statearr_38479 = state_38420;
(statearr_38479[(4)] = cljs.core.rest((state_38420[(4)])));

return statearr_38479;
})();
var state_38420__$1 = state_38420;
var statearr_38480_38547 = state_38420__$1;
(statearr_38480_38547[(2)] = inst_38260);

(statearr_38480_38547[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (5))){
var _ = (function (){var statearr_38481 = state_38420;
(statearr_38481[(4)] = cljs.core.rest((state_38420[(4)])));

return statearr_38481;
})();
var state_38420__$1 = state_38420;
var ex38475 = (state_38420__$1[(2)]);
var statearr_38482_38548 = state_38420__$1;
(statearr_38482_38548[(5)] = ex38475);


if((ex38475 instanceof Error)){
var statearr_38483_38549 = state_38420__$1;
(statearr_38483_38549[(1)] = (4));

(statearr_38483_38549[(5)] = null);

} else {
throw ex38475;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (14))){
var state_38420__$1 = state_38420;
var statearr_38484_38550 = state_38420__$1;
(statearr_38484_38550[(2)] = base_select_spec);

(statearr_38484_38550[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (45))){
var inst_38363 = (state_38420[(2)]);
var state_38420__$1 = state_38420;
if(cljs.core.truth_(inst_38363)){
var statearr_38485_38551 = state_38420__$1;
(statearr_38485_38551[(1)] = (46));

} else {
var statearr_38486_38552 = state_38420__$1;
(statearr_38486_38552[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (26))){
var inst_38302 = (state_38420[(12)]);
var inst_38306 = cljs.core.empty_QMARK_(inst_38302);
var state_38420__$1 = state_38420;
if(inst_38306){
var statearr_38487_38553 = state_38420__$1;
(statearr_38487_38553[(1)] = (28));

} else {
var statearr_38488_38554 = state_38420__$1;
(statearr_38488_38554[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (16))){
var inst_38270 = (state_38420[(17)]);
var state_38420__$1 = state_38420;
var statearr_38489_38555 = state_38420__$1;
(statearr_38489_38555[(2)] = inst_38270);

(statearr_38489_38555[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (38))){
var inst_38302 = (state_38420[(12)]);
var inst_38336 = (state_38420[(2)]);
var inst_38337 = fluree.db.util.async.throw_err(inst_38336);
var inst_38338 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38337,(0),null);
var inst_38339 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38337,(1),null);
var inst_38340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38341 = cljs.core.rest(inst_38302);
var inst_38342 = [inst_38338,inst_38341,inst_38339];
var inst_38343 = (new cljs.core.PersistentVector(null,3,(5),inst_38340,inst_38342,null));
var state_38420__$1 = state_38420;
var statearr_38490_38556 = state_38420__$1;
(statearr_38490_38556[(2)] = inst_38343);

(statearr_38490_38556[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (30))){
var inst_38397 = (state_38420[(2)]);
var state_38420__$1 = state_38420;
var statearr_38491_38557 = state_38420__$1;
(statearr_38491_38557[(2)] = inst_38397);

(statearr_38491_38557[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (10))){
var inst_38263 = (state_38420[(2)]);
var inst_38264 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_38420__$1 = (function (){var statearr_38492 = state_38420;
(statearr_38492[(7)] = inst_38263);

return statearr_38492;
})();
if(cljs.core.truth_(inst_38264)){
var statearr_38493_38558 = state_38420__$1;
(statearr_38493_38558[(1)] = (13));

} else {
var statearr_38494_38559 = state_38420__$1;
(statearr_38494_38559[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (18))){
var inst_38275 = (state_38420[(2)]);
var state_38420__$1 = state_38420;
if(cljs.core.truth_(inst_38275)){
var statearr_38495_38560 = state_38420__$1;
(statearr_38495_38560[(1)] = (19));

} else {
var statearr_38496_38561 = state_38420__$1;
(statearr_38496_38561[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (42))){
var inst_38304 = (state_38420[(11)]);
var inst_38347 = (state_38420[(16)]);
var inst_38302 = (state_38420[(12)]);
var inst_38350 = (state_38420[(2)]);
var inst_38351 = fluree.db.util.async.throw_err(inst_38350);
var inst_38352 = cljs.core.first(inst_38351);
var inst_38353 = cljs.core.rest(inst_38302);
var inst_38354 = [inst_38352,inst_38353,inst_38304];
var inst_38355 = (new cljs.core.PersistentVector(null,3,(5),inst_38347,inst_38354,null));
var state_38420__$1 = state_38420;
var statearr_38497_38562 = state_38420__$1;
(statearr_38497_38562[(2)] = inst_38355);

(statearr_38497_38562[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (37))){
var inst_38387 = (state_38420[(2)]);
var state_38420__$1 = state_38420;
var statearr_38498_38563 = state_38420__$1;
(statearr_38498_38563[(2)] = inst_38387);

(statearr_38498_38563[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (8))){
var inst_38415 = (state_38420[(2)]);
var _ = (function (){var statearr_38499 = state_38420;
(statearr_38499[(4)] = cljs.core.rest((state_38420[(4)])));

return statearr_38499;
})();
var state_38420__$1 = state_38420;
var statearr_38500_38564 = state_38420__$1;
(statearr_38500_38564[(2)] = inst_38415);

(statearr_38500_38564[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38421 === (49))){
var inst_38304 = (state_38420[(11)]);
var inst_38302 = (state_38420[(12)]);
var inst_38303 = (state_38420[(13)]);
var inst_38375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38376 = cljs.core.rest(inst_38302);
var inst_38377 = [inst_38303,inst_38376,inst_38304];
var inst_38378 = (new cljs.core.PersistentVector(null,3,(5),inst_38375,inst_38377,null));
var state_38420__$1 = state_38420;
var statearr_38501_38565 = state_38420__$1;
(statearr_38501_38565[(2)] = inst_38378);

(statearr_38501_38565[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____0 = (function (){
var statearr_38502 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38502[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__);

(statearr_38502[(1)] = (1));

return statearr_38502;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____1 = (function (state_38420){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38420);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38503){var ex__16304__auto__ = e38503;
var statearr_38504_38566 = state_38420;
(statearr_38504_38566[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38420[(4)]))){
var statearr_38505_38567 = state_38420;
(statearr_38505_38567[(1)] = cljs.core.first((state_38420[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38568 = state_38420;
state_38420 = G__38568;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__ = function(state_38420){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____1.call(this,state_38420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38506 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38506[(6)] = c__16375__auto__);

return statearr_38506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__38571 = arguments.length;
switch (G__38571) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38613){
var state_val_38614 = (state_38613[(1)]);
if((state_val_38614 === (7))){
var inst_38579 = (state_38613[(7)]);
var state_38613__$1 = state_38613;
var statearr_38615_38645 = state_38613__$1;
(statearr_38615_38645[(2)] = inst_38579);

(statearr_38615_38645[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38614 === (1))){
var state_38613__$1 = state_38613;
var statearr_38616_38646 = state_38613__$1;
(statearr_38616_38646[(2)] = null);

(statearr_38616_38646[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38614 === (4))){
var inst_38572 = (state_38613[(2)]);
var state_38613__$1 = state_38613;
var statearr_38617_38647 = state_38613__$1;
(statearr_38617_38647[(2)] = inst_38572);

(statearr_38617_38647[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38614 === (15))){
var inst_38607 = (state_38613[(2)]);
var inst_38608 = fluree.db.util.async.throw_err(inst_38607);
var _ = (function (){var statearr_38618 = state_38613;
(statearr_38618[(4)] = cljs.core.rest((state_38613[(4)])));

return statearr_38618;
})();
var state_38613__$1 = state_38613;
var statearr_38619_38648 = state_38613__$1;
(statearr_38619_38648[(2)] = inst_38608);

(statearr_38619_38648[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38614 === (13))){
var inst_38591 = (state_38613[(8)]);
var state_38613__$1 = state_38613;
var statearr_38620_38649 = state_38613__$1;
(statearr_38620_38649[(2)] = inst_38591);

(statearr_38620_38649[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38614 === (6))){
var inst_38579 = (state_38613[(7)]);
var inst_38581 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_38582 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38579,inst_38581);
var state_38613__$1 = state_38613;
var statearr_38621_38650 = state_38613__$1;
(statearr_38621_38650[(2)] = inst_38582);

(statearr_38621_38650[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38614 === (3))){
var inst_38611 = (state_38613[(2)]);
var state_38613__$1 = state_38613;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38613__$1,inst_38611);
} else {
if((state_val_38614 === (12))){
var inst_38591 = (state_38613[(8)]);
var inst_38593 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_38594 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38591,inst_38593);
var state_38613__$1 = state_38613;
var statearr_38622_38651 = state_38613__$1;
(statearr_38622_38651[(2)] = inst_38594);

(statearr_38622_38651[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38614 === (2))){
var _ = (function (){var statearr_38623 = state_38613;
(statearr_38623[(4)] = cljs.core.cons((5),(state_38613[(4)])));

return statearr_38623;
})();
var inst_38579 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_38613__$1 = (function (){var statearr_38624 = state_38613;
(statearr_38624[(7)] = inst_38579);

return statearr_38624;
})();
if(cljs.core.truth_(fuel)){
var statearr_38625_38652 = state_38613__$1;
(statearr_38625_38652[(1)] = (6));

} else {
var statearr_38626_38653 = state_38613__$1;
(statearr_38626_38653[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38614 === (11))){
var inst_38591 = (state_38613[(2)]);
var state_38613__$1 = (function (){var statearr_38628 = state_38613;
(statearr_38628[(8)] = inst_38591);

return statearr_38628;
})();
if(cljs.core.truth_(limit)){
var statearr_38629_38654 = state_38613__$1;
(statearr_38629_38654[(1)] = (12));

} else {
var statearr_38630_38655 = state_38613__$1;
(statearr_38630_38655[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38614 === (9))){
var inst_38585 = (state_38613[(9)]);
var inst_38587 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_38588 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38585,inst_38587);
var state_38613__$1 = state_38613;
var statearr_38631_38656 = state_38613__$1;
(statearr_38631_38656[(2)] = inst_38588);

(statearr_38631_38656[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38614 === (5))){
var _ = (function (){var statearr_38632 = state_38613;
(statearr_38632[(4)] = cljs.core.rest((state_38613[(4)])));

return statearr_38632;
})();
var state_38613__$1 = state_38613;
var ex38627 = (state_38613__$1[(2)]);
var statearr_38633_38657 = state_38613__$1;
(statearr_38633_38657[(5)] = ex38627);


if((ex38627 instanceof Error)){
var statearr_38634_38658 = state_38613__$1;
(statearr_38634_38658[(1)] = (4));

(statearr_38634_38658[(5)] = null);

} else {
throw ex38627;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38614 === (14))){
var inst_38597 = (state_38613[(2)]);
var inst_38598 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_38599 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_38598);
var inst_38600 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38597,inst_38599);
var inst_38601 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38600,flakes);
var inst_38602 = cljs.core.PersistentVector.EMPTY;
var inst_38603 = (function (){var xf = inst_38600;
var flakes_by_sub = inst_38601;
return (function (p1__38569_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__38569_SHARP_);
});
})();
var inst_38604 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38603,inst_38601);
var inst_38605 = fluree.db.util.async.merge_into_QMARK_(inst_38602,inst_38604);
var state_38613__$1 = state_38613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38613__$1,(15),inst_38605);
} else {
if((state_val_38614 === (10))){
var inst_38585 = (state_38613[(9)]);
var state_38613__$1 = state_38613;
var statearr_38635_38659 = state_38613__$1;
(statearr_38635_38659[(2)] = inst_38585);

(statearr_38635_38659[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38614 === (8))){
var inst_38585 = (state_38613[(2)]);
var state_38613__$1 = (function (){var statearr_38636 = state_38613;
(statearr_38636[(9)] = inst_38585);

return statearr_38636;
})();
if(cljs.core.truth_(offset)){
var statearr_38637_38660 = state_38613__$1;
(statearr_38637_38660[(1)] = (9));

} else {
var statearr_38638_38661 = state_38613__$1;
(statearr_38638_38661[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_38639 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38639[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_38639[(1)] = (1));

return statearr_38639;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_38613){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38613);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38640){var ex__16304__auto__ = e38640;
var statearr_38641_38662 = state_38613;
(statearr_38641_38662[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38613[(4)]))){
var statearr_38642_38663 = state_38613;
(statearr_38642_38663[(1)] = cljs.core.first((state_38613[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38664 = state_38613;
state_38613 = G__38664;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_38613){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_38613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38643 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38643[(6)] = c__16375__auto__);

return statearr_38643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__38666 = arguments.length;
switch (G__38666) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38750){
var state_val_38751 = (state_38750[(1)]);
if((state_val_38751 === (7))){
var inst_38745 = (state_38750[(2)]);
var _ = (function (){var statearr_38753 = state_38750;
(statearr_38753[(4)] = cljs.core.rest((state_38750[(4)])));

return statearr_38753;
})();
var state_38750__$1 = state_38750;
var statearr_38754_38801 = state_38750__$1;
(statearr_38754_38801[(2)] = inst_38745);

(statearr_38754_38801[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (20))){
var inst_38694 = (state_38750[(7)]);
var inst_38687 = (state_38750[(8)]);
var inst_38686 = (state_38750[(9)]);
var inst_38715 = (inst_38686 + (1));
var tmp38752 = inst_38687;
var inst_38685 = inst_38694;
var inst_38686__$1 = inst_38715;
var inst_38687__$1 = tmp38752;
var state_38750__$1 = (function (){var statearr_38755 = state_38750;
(statearr_38755[(10)] = inst_38685);

(statearr_38755[(8)] = inst_38687__$1);

(statearr_38755[(9)] = inst_38686__$1);

return statearr_38755;
})();
var statearr_38756_38802 = state_38750__$1;
(statearr_38756_38802[(2)] = null);

(statearr_38756_38802[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (27))){
var inst_38720 = (state_38750[(11)]);
var inst_38729 = (state_38750[(2)]);
var inst_38730 = fluree.db.util.async.throw_err(inst_38729);
var inst_38731 = (inst_38720.cljs$core$IFn$_invoke$arity$1 ? inst_38720.cljs$core$IFn$_invoke$arity$1(inst_38730) : inst_38720.call(null,inst_38730));
var state_38750__$1 = state_38750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38750__$1,(26),inst_38731);
} else {
if((state_val_38751 === (1))){
var state_38750__$1 = state_38750;
var statearr_38757_38803 = state_38750__$1;
(statearr_38757_38803[(2)] = null);

(statearr_38757_38803[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (24))){
var state_38750__$1 = state_38750;
var statearr_38758_38804 = state_38750__$1;
(statearr_38758_38804[(2)] = null);

(statearr_38758_38804[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (4))){
var inst_38667 = (state_38750[(2)]);
var state_38750__$1 = state_38750;
var statearr_38759_38805 = state_38750__$1;
(statearr_38759_38805[(2)] = inst_38667);

(statearr_38759_38805[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (15))){
var inst_38708 = (state_38750[(12)]);
var inst_38708__$1 = offset;
var state_38750__$1 = (function (){var statearr_38760 = state_38750;
(statearr_38760[(12)] = inst_38708__$1);

return statearr_38760;
})();
if(cljs.core.truth_(inst_38708__$1)){
var statearr_38761_38806 = state_38750__$1;
(statearr_38761_38806[(1)] = (17));

} else {
var statearr_38762_38807 = state_38750__$1;
(statearr_38762_38807[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (21))){
var state_38750__$1 = state_38750;
var statearr_38763_38808 = state_38750__$1;
(statearr_38763_38808[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (13))){
var inst_38703 = (state_38750[(2)]);
var state_38750__$1 = state_38750;
var statearr_38765_38809 = state_38750__$1;
(statearr_38765_38809[(2)] = inst_38703);

(statearr_38765_38809[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (22))){
var inst_38741 = (state_38750[(2)]);
var state_38750__$1 = state_38750;
var statearr_38766_38810 = state_38750__$1;
(statearr_38766_38810[(2)] = inst_38741);

(statearr_38766_38810[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (6))){
var inst_38695 = (state_38750[(13)]);
var inst_38685 = (state_38750[(10)]);
var inst_38693 = (state_38750[(14)]);
var inst_38692 = cljs.core.seq(inst_38685);
var inst_38693__$1 = cljs.core.first(inst_38692);
var inst_38694 = cljs.core.next(inst_38692);
var inst_38695__$1 = (inst_38693__$1 == null);
var state_38750__$1 = (function (){var statearr_38767 = state_38750;
(statearr_38767[(7)] = inst_38694);

(statearr_38767[(13)] = inst_38695__$1);

(statearr_38767[(14)] = inst_38693__$1);

return statearr_38767;
})();
if(cljs.core.truth_(inst_38695__$1)){
var statearr_38768_38811 = state_38750__$1;
(statearr_38768_38811[(1)] = (8));

} else {
var statearr_38769_38812 = state_38750__$1;
(statearr_38769_38812[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (25))){
var inst_38739 = (state_38750[(2)]);
var state_38750__$1 = state_38750;
var statearr_38770_38813 = state_38750__$1;
(statearr_38770_38813[(2)] = inst_38739);

(statearr_38770_38813[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (17))){
var inst_38686 = (state_38750[(9)]);
var inst_38710 = (inst_38686 < offset);
var state_38750__$1 = state_38750;
var statearr_38771_38814 = state_38750__$1;
(statearr_38771_38814[(2)] = inst_38710);

(statearr_38771_38814[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (3))){
var inst_38748 = (state_38750[(2)]);
var state_38750__$1 = state_38750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38750__$1,inst_38748);
} else {
if((state_val_38751 === (12))){
var inst_38698 = (state_38750[(15)]);
var state_38750__$1 = state_38750;
var statearr_38772_38815 = state_38750__$1;
(statearr_38772_38815[(2)] = inst_38698);

(statearr_38772_38815[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (2))){
var inst_38680 = (state_38750[(16)]);
var _ = (function (){var statearr_38773 = state_38750;
(statearr_38773[(4)] = cljs.core.cons((5),(state_38750[(4)])));

return statearr_38773;
})();
var inst_38680__$1 = subjects;
var inst_38681 = cljs.core.seq(inst_38680__$1);
var inst_38682 = cljs.core.first(inst_38681);
var inst_38683 = cljs.core.next(inst_38681);
var inst_38684 = cljs.core.PersistentVector.EMPTY;
var inst_38685 = inst_38680__$1;
var inst_38686 = (0);
var inst_38687 = inst_38684;
var state_38750__$1 = (function (){var statearr_38774 = state_38750;
(statearr_38774[(16)] = inst_38680__$1);

(statearr_38774[(10)] = inst_38685);

(statearr_38774[(8)] = inst_38687);

(statearr_38774[(17)] = inst_38682);

(statearr_38774[(9)] = inst_38686);

(statearr_38774[(18)] = inst_38683);

return statearr_38774;
})();
var statearr_38775_38816 = state_38750__$1;
(statearr_38775_38816[(2)] = null);

(statearr_38775_38816[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (23))){
var inst_38680 = (state_38750[(16)]);
var inst_38694 = (state_38750[(7)]);
var inst_38685 = (state_38750[(10)]);
var inst_38693 = (state_38750[(14)]);
var inst_38687 = (state_38750[(8)]);
var inst_38682 = (state_38750[(17)]);
var inst_38686 = (state_38750[(9)]);
var inst_38683 = (state_38750[(18)]);
var inst_38719 = (inst_38686 + (1));
var inst_38720 = (function (){var first__38691 = inst_38693;
var r = inst_38694;
var first__38679 = inst_38682;
var vec__38689 = inst_38685;
var seq__38690 = inst_38694;
var acc = inst_38687;
var seq__38678 = inst_38683;
var n = inst_38686;
var vec__38677 = inst_38680;
var s = inst_38693;
var G__38676 = inst_38685;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_38721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38722 = [inst_38693];
var inst_38723 = (new cljs.core.PersistentVector(null,1,(5),inst_38721,inst_38722,null));
var inst_38724 = [cljs.core.cst$kw$limit];
var inst_38725 = [limit];
var inst_38726 = cljs.core.PersistentHashMap.fromArrays(inst_38724,inst_38725);
var inst_38727 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38723,inst_38726);
var state_38750__$1 = (function (){var statearr_38776 = state_38750;
(statearr_38776[(19)] = inst_38719);

(statearr_38776[(11)] = inst_38720);

return statearr_38776;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38750__$1,(27),inst_38727);
} else {
if((state_val_38751 === (19))){
var inst_38713 = (state_38750[(2)]);
var state_38750__$1 = state_38750;
if(cljs.core.truth_(inst_38713)){
var statearr_38777_38817 = state_38750__$1;
(statearr_38777_38817[(1)] = (20));

} else {
var statearr_38778_38818 = state_38750__$1;
(statearr_38778_38818[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (11))){
var inst_38686 = (state_38750[(9)]);
var inst_38700 = (inst_38686 > limit);
var state_38750__$1 = state_38750;
var statearr_38780_38819 = state_38750__$1;
(statearr_38780_38819[(2)] = inst_38700);

(statearr_38780_38819[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (9))){
var inst_38698 = (state_38750[(15)]);
var inst_38698__$1 = limit;
var state_38750__$1 = (function (){var statearr_38781 = state_38750;
(statearr_38781[(15)] = inst_38698__$1);

return statearr_38781;
})();
if(cljs.core.truth_(inst_38698__$1)){
var statearr_38782_38820 = state_38750__$1;
(statearr_38782_38820[(1)] = (11));

} else {
var statearr_38783_38821 = state_38750__$1;
(statearr_38783_38821[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (5))){
var _ = (function (){var statearr_38784 = state_38750;
(statearr_38784[(4)] = cljs.core.rest((state_38750[(4)])));

return statearr_38784;
})();
var state_38750__$1 = state_38750;
var ex38779 = (state_38750__$1[(2)]);
var statearr_38785_38822 = state_38750__$1;
(statearr_38785_38822[(5)] = ex38779);


if((ex38779 instanceof Error)){
var statearr_38786_38823 = state_38750__$1;
(statearr_38786_38823[(1)] = (4));

(statearr_38786_38823[(5)] = null);

} else {
throw ex38779;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (14))){
var inst_38687 = (state_38750[(8)]);
var state_38750__$1 = state_38750;
var statearr_38787_38824 = state_38750__$1;
(statearr_38787_38824[(2)] = inst_38687);

(statearr_38787_38824[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (26))){
var inst_38719 = (state_38750[(19)]);
var inst_38694 = (state_38750[(7)]);
var inst_38687 = (state_38750[(8)]);
var inst_38733 = (state_38750[(2)]);
var inst_38734 = fluree.db.util.async.throw_err(inst_38733);
var inst_38735 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38687,inst_38734);
var inst_38685 = inst_38694;
var inst_38686 = inst_38719;
var inst_38687__$1 = inst_38735;
var state_38750__$1 = (function (){var statearr_38788 = state_38750;
(statearr_38788[(10)] = inst_38685);

(statearr_38788[(8)] = inst_38687__$1);

(statearr_38788[(9)] = inst_38686);

return statearr_38788;
})();
var statearr_38789_38825 = state_38750__$1;
(statearr_38789_38825[(2)] = null);

(statearr_38789_38825[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (16))){
var inst_38743 = (state_38750[(2)]);
var state_38750__$1 = state_38750;
var statearr_38790_38826 = state_38750__$1;
(statearr_38790_38826[(2)] = inst_38743);

(statearr_38790_38826[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (10))){
var inst_38705 = (state_38750[(2)]);
var state_38750__$1 = state_38750;
if(cljs.core.truth_(inst_38705)){
var statearr_38791_38827 = state_38750__$1;
(statearr_38791_38827[(1)] = (14));

} else {
var statearr_38792_38828 = state_38750__$1;
(statearr_38792_38828[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (18))){
var inst_38708 = (state_38750[(12)]);
var state_38750__$1 = state_38750;
var statearr_38793_38829 = state_38750__$1;
(statearr_38793_38829[(2)] = inst_38708);

(statearr_38793_38829[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38751 === (8))){
var inst_38695 = (state_38750[(13)]);
var state_38750__$1 = state_38750;
var statearr_38794_38830 = state_38750__$1;
(statearr_38794_38830[(2)] = inst_38695);

(statearr_38794_38830[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_38795 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38795[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_38795[(1)] = (1));

return statearr_38795;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_38750){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38750);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38796){var ex__16304__auto__ = e38796;
var statearr_38797_38831 = state_38750;
(statearr_38797_38831[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38750[(4)]))){
var statearr_38798_38832 = state_38750;
(statearr_38798_38832[(1)] = cljs.core.first((state_38750[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38833 = state_38750;
state_38750 = G__38833;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_38750){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_38750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38799 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38799[(6)] = c__16375__auto__);

return statearr_38799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__38835 = arguments.length;
switch (G__38835) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39023){
var state_val_39024 = (state_39023[(1)]);
if((state_val_39024 === (7))){
var state_39023__$1 = state_39023;
var statearr_39025_39096 = state_39023__$1;
(statearr_39025_39096[(2)] = null);

(statearr_39025_39096[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (20))){
var inst_38878 = (state_39023[(7)]);
var inst_38876 = (state_39023[(8)]);
var inst_38906 = (state_39023[(2)]);
var inst_38907 = fluree.db.util.async.throw_err(inst_38906);
var inst_38908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38909 = [inst_38876];
var inst_38910 = (new cljs.core.PersistentVector(null,1,(5),inst_38908,inst_38909,null));
var inst_38911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38912 = [inst_38876,inst_38878];
var inst_38913 = (new cljs.core.PersistentVector(null,2,(5),inst_38911,inst_38912,null));
var inst_38914 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38910,cljs.core._LT_,inst_38913);
var state_39023__$1 = (function (){var statearr_39026 = state_39023;
(statearr_39026[(9)] = inst_38907);

return statearr_39026;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39023__$1,(21),inst_38914);
} else {
if((state_val_39024 === (27))){
var inst_38877 = (state_39023[(10)]);
var inst_38895 = (state_39023[(11)]);
var inst_38943 = (inst_38895.cljs$core$IFn$_invoke$arity$2 ? inst_38895.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_38877) : inst_38895.call(null,cljs.core._GT__EQ_,inst_38877));
var state_39023__$1 = state_39023;
if(cljs.core.truth_(inst_38943)){
var statearr_39027_39097 = state_39023__$1;
(statearr_39027_39097[(1)] = (30));

} else {
var statearr_39028_39098 = state_39023__$1;
(statearr_39028_39098[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (1))){
var state_39023__$1 = state_39023;
var statearr_39029_39099 = state_39023__$1;
(statearr_39029_39099[(2)] = null);

(statearr_39029_39099[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (24))){
var inst_38992 = (state_39023[(2)]);
var state_39023__$1 = state_39023;
var statearr_39030_39100 = state_39023__$1;
(statearr_39030_39100[(2)] = inst_38992);

(statearr_39030_39100[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (39))){
var inst_38982 = null;
var state_39023__$1 = state_39023;
var statearr_39031_39101 = state_39023__$1;
(statearr_39031_39101[(2)] = inst_38982);

(statearr_39031_39101[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (46))){
var inst_39003 = (state_39023[(12)]);
var inst_38869 = (state_39023[(13)]);
var inst_38861 = inst_38869;
var inst_38862 = inst_39003;
var state_39023__$1 = (function (){var statearr_39032 = state_39023;
(statearr_39032[(14)] = inst_38861);

(statearr_39032[(15)] = inst_38862);

return statearr_39032;
})();
var statearr_39033_39102 = state_39023__$1;
(statearr_39033_39102[(2)] = null);

(statearr_39033_39102[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (4))){
var inst_38836 = (state_39023[(2)]);
var state_39023__$1 = state_39023;
var statearr_39034_39103 = state_39023__$1;
(statearr_39034_39103[(2)] = inst_38836);

(statearr_39034_39103[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (15))){
var state_39023__$1 = state_39023;
var statearr_39035_39104 = state_39023__$1;
(statearr_39035_39104[(2)] = null);

(statearr_39035_39104[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (21))){
var inst_38907 = (state_39023[(9)]);
var inst_38916 = (state_39023[(2)]);
var inst_38917 = fluree.db.util.async.throw_err(inst_38916);
var inst_38918 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38907,inst_38917);
var state_39023__$1 = state_39023;
var statearr_39036_39105 = state_39023__$1;
(statearr_39036_39105[(2)] = inst_38918);

(statearr_39036_39105[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (31))){
var inst_38877 = (state_39023[(10)]);
var inst_38895 = (state_39023[(11)]);
var inst_38956 = (inst_38895.cljs$core$IFn$_invoke$arity$2 ? inst_38895.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_38877) : inst_38895.call(null,cljs.core._LT_,inst_38877));
var state_39023__$1 = state_39023;
if(cljs.core.truth_(inst_38956)){
var statearr_39037_39106 = state_39023__$1;
(statearr_39037_39106[(1)] = (34));

} else {
var statearr_39038_39107 = state_39023__$1;
(statearr_39038_39107[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (32))){
var inst_38988 = (state_39023[(2)]);
var state_39023__$1 = state_39023;
var statearr_39039_39108 = state_39023__$1;
(statearr_39039_39108[(2)] = inst_38988);

(statearr_39039_39108[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (40))){
var inst_38984 = (state_39023[(2)]);
var state_39023__$1 = state_39023;
var statearr_39040_39109 = state_39023__$1;
(statearr_39040_39109[(2)] = inst_38984);

(statearr_39040_39109[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (33))){
var inst_38953 = (state_39023[(2)]);
var inst_38954 = fluree.db.util.async.throw_err(inst_38953);
var state_39023__$1 = state_39023;
var statearr_39041_39110 = state_39023__$1;
(statearr_39041_39110[(2)] = inst_38954);

(statearr_39041_39110[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (13))){
var inst_39013 = (state_39023[(2)]);
var state_39023__$1 = state_39023;
var statearr_39042_39111 = state_39023__$1;
(statearr_39042_39111[(2)] = inst_39013);

(statearr_39042_39111[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (22))){
var inst_38878 = (state_39023[(7)]);
var inst_38876 = (state_39023[(8)]);
var inst_38922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38923 = [inst_38876,inst_38878];
var inst_38924 = (new cljs.core.PersistentVector(null,2,(5),inst_38922,inst_38923,null));
var inst_38925 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_38924);
var state_39023__$1 = state_39023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39023__$1,(25),inst_38925);
} else {
if((state_val_39024 === (36))){
var inst_38986 = (state_39023[(2)]);
var state_39023__$1 = state_39023;
var statearr_39043_39112 = state_39023__$1;
(statearr_39043_39112[(2)] = inst_38986);

(statearr_39043_39112[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (41))){
var inst_38979 = (state_39023[(2)]);
var inst_38980 = fluree.db.util.async.throw_err(inst_38979);
var state_39023__$1 = state_39023;
var statearr_39044_39113 = state_39023__$1;
(statearr_39044_39113[(2)] = inst_38980);

(statearr_39044_39113[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (43))){
var inst_38862 = (state_39023[(15)]);
var inst_38995 = (state_39023[(16)]);
var inst_38996 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38862,inst_38995);
var state_39023__$1 = state_39023;
var statearr_39045_39114 = state_39023__$1;
(statearr_39045_39114[(2)] = inst_38996);

(statearr_39045_39114[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (29))){
var inst_38940 = (state_39023[(2)]);
var inst_38941 = fluree.db.util.async.throw_err(inst_38940);
var state_39023__$1 = state_39023;
var statearr_39046_39115 = state_39023__$1;
(statearr_39046_39115[(2)] = inst_38941);

(statearr_39046_39115[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (44))){
var inst_38862 = (state_39023[(15)]);
var inst_38995 = (state_39023[(16)]);
var inst_38998 = cljs.core.PersistentHashSet.EMPTY;
var inst_38999 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38998,inst_38995);
var inst_39000 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_38862,inst_38999);
var state_39023__$1 = state_39023;
var statearr_39047_39116 = state_39023__$1;
(statearr_39047_39116[(2)] = inst_39000);

(statearr_39047_39116[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (6))){
var inst_38847 = (state_39023[(17)]);
var inst_38857 = cljs.core.seq(inst_38847);
var inst_38858 = cljs.core.first(inst_38857);
var inst_38859 = cljs.core.next(inst_38857);
var inst_38860 = cljs.core.PersistentHashSet.EMPTY;
var inst_38861 = inst_38847;
var inst_38862 = inst_38860;
var state_39023__$1 = (function (){var statearr_39048 = state_39023;
(statearr_39048[(14)] = inst_38861);

(statearr_39048[(15)] = inst_38862);

(statearr_39048[(18)] = inst_38858);

(statearr_39048[(19)] = inst_38859);

return statearr_39048;
})();
var statearr_39049_39117 = state_39023__$1;
(statearr_39049_39117[(2)] = null);

(statearr_39049_39117[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (28))){
var inst_38990 = (state_39023[(2)]);
var state_39023__$1 = state_39023;
var statearr_39050_39118 = state_39023__$1;
(statearr_39050_39118[(2)] = inst_38990);

(statearr_39050_39118[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (25))){
var inst_38927 = (state_39023[(2)]);
var inst_38928 = fluree.db.util.async.throw_err(inst_38927);
var state_39023__$1 = state_39023;
var statearr_39051_39119 = state_39023__$1;
(statearr_39051_39119[(2)] = inst_38928);

(statearr_39051_39119[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (34))){
var inst_38878 = (state_39023[(7)]);
var inst_38876 = (state_39023[(8)]);
var inst_38958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38959 = [inst_38876];
var inst_38960 = (new cljs.core.PersistentVector(null,1,(5),inst_38958,inst_38959,null));
var inst_38961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38962 = [inst_38876,inst_38878];
var inst_38963 = (new cljs.core.PersistentVector(null,2,(5),inst_38961,inst_38962,null));
var inst_38964 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38960,cljs.core._LT_,inst_38963);
var state_39023__$1 = state_39023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39023__$1,(37),inst_38964);
} else {
if((state_val_39024 === (17))){
var inst_38878 = (state_39023[(7)]);
var inst_38876 = (state_39023[(8)]);
var inst_38898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38899 = [inst_38876,inst_38878];
var inst_38900 = (new cljs.core.PersistentVector(null,2,(5),inst_38898,inst_38899,null));
var inst_38901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38902 = [inst_38876];
var inst_38903 = (new cljs.core.PersistentVector(null,1,(5),inst_38901,inst_38902,null));
var inst_38904 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_38900,cljs.core._LT__EQ_,inst_38903);
var state_39023__$1 = state_39023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39023__$1,(20),inst_38904);
} else {
if((state_val_39024 === (3))){
var inst_39021 = (state_39023[(2)]);
var state_39023__$1 = state_39023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39023__$1,inst_39021);
} else {
if((state_val_39024 === (12))){
var inst_38868 = (state_39023[(20)]);
var inst_38876 = (state_39023[(8)]);
var inst_38876__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38868,(0),null);
var inst_38877 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38868,(1),null);
var inst_38878 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38868,(2),null);
var inst_38879 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_38876__$1);
var inst_38880 = cljs.core.not(inst_38879);
var state_39023__$1 = (function (){var statearr_39052 = state_39023;
(statearr_39052[(7)] = inst_38878);

(statearr_39052[(10)] = inst_38877);

(statearr_39052[(8)] = inst_38876__$1);

return statearr_39052;
})();
if(inst_38880){
var statearr_39053_39120 = state_39023__$1;
(statearr_39053_39120[(1)] = (14));

} else {
var statearr_39054_39121 = state_39023__$1;
(statearr_39054_39121[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (2))){
var inst_38847 = (state_39023[(17)]);
var _ = (function (){var statearr_39055 = state_39023;
(statearr_39055[(4)] = cljs.core.cons((5),(state_39023[(4)])));

return statearr_39055;
})();
var inst_38845 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_38846 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38845,(0),null);
var inst_38847__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38845,(1),null);
var inst_38848 = cljs.core.not_empty(inst_38847__$1);
var state_39023__$1 = (function (){var statearr_39056 = state_39023;
(statearr_39056[(17)] = inst_38847__$1);

(statearr_39056[(21)] = inst_38846);

return statearr_39056;
})();
if(cljs.core.truth_(inst_38848)){
var statearr_39057_39122 = state_39023__$1;
(statearr_39057_39122[(1)] = (6));

} else {
var statearr_39058_39123 = state_39023__$1;
(statearr_39058_39123[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (23))){
var inst_38877 = (state_39023[(10)]);
var inst_38895 = (state_39023[(11)]);
var inst_38930 = (inst_38895.cljs$core$IFn$_invoke$arity$2 ? inst_38895.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_38877) : inst_38895.call(null,cljs.core._GT_,inst_38877));
var state_39023__$1 = state_39023;
if(cljs.core.truth_(inst_38930)){
var statearr_39059_39124 = state_39023__$1;
(statearr_39059_39124[(1)] = (26));

} else {
var statearr_39060_39125 = state_39023__$1;
(statearr_39060_39125[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (47))){
var inst_39011 = (state_39023[(2)]);
var state_39023__$1 = state_39023;
var statearr_39061_39126 = state_39023__$1;
(statearr_39061_39126[(2)] = inst_39011);

(statearr_39061_39126[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (35))){
var inst_38877 = (state_39023[(10)]);
var inst_38895 = (state_39023[(11)]);
var inst_38969 = (inst_38895.cljs$core$IFn$_invoke$arity$2 ? inst_38895.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_38877) : inst_38895.call(null,cljs.core._LT__EQ_,inst_38877));
var state_39023__$1 = state_39023;
if(cljs.core.truth_(inst_38969)){
var statearr_39062_39127 = state_39023__$1;
(statearr_39062_39127[(1)] = (38));

} else {
var statearr_39063_39128 = state_39023__$1;
(statearr_39063_39128[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (19))){
var inst_38846 = (state_39023[(21)]);
var inst_38994 = (state_39023[(2)]);
var inst_38995 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_38994);
var state_39023__$1 = (function (){var statearr_39064 = state_39023;
(statearr_39064[(16)] = inst_38995);

return statearr_39064;
})();
var G__39065_39129 = inst_38846;
var G__39065_39130__$1 = (((G__39065_39129 instanceof cljs.core.Keyword))?G__39065_39129.fqn:null);
switch (G__39065_39130__$1) {
case "or":
var statearr_39066_39132 = state_39023__$1;
(statearr_39066_39132[(1)] = (43));


break;
case "and":
var statearr_39067_39133 = state_39023__$1;
(statearr_39067_39133[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39065_39130__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (11))){
var inst_38862 = (state_39023[(15)]);
var state_39023__$1 = state_39023;
var statearr_39069_39134 = state_39023__$1;
(statearr_39069_39134[(2)] = inst_38862);

(statearr_39069_39134[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (9))){
var inst_38868 = (state_39023[(20)]);
var inst_38861 = (state_39023[(14)]);
var inst_38867 = cljs.core.seq(inst_38861);
var inst_38868__$1 = cljs.core.first(inst_38867);
var inst_38869 = cljs.core.next(inst_38867);
var inst_38870 = cljs.core.not(inst_38868__$1);
var state_39023__$1 = (function (){var statearr_39070 = state_39023;
(statearr_39070[(20)] = inst_38868__$1);

(statearr_39070[(13)] = inst_38869);

return statearr_39070;
})();
if(inst_38870){
var statearr_39071_39135 = state_39023__$1;
(statearr_39071_39135[(1)] = (11));

} else {
var statearr_39072_39136 = state_39023__$1;
(statearr_39072_39136[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (5))){
var _ = (function (){var statearr_39073 = state_39023;
(statearr_39073[(4)] = cljs.core.rest((state_39023[(4)])));

return statearr_39073;
})();
var state_39023__$1 = state_39023;
var ex39068 = (state_39023__$1[(2)]);
var statearr_39074_39137 = state_39023__$1;
(statearr_39074_39137[(5)] = ex39068);


if((ex39068 instanceof Error)){
var statearr_39075_39138 = state_39023__$1;
(statearr_39075_39138[(1)] = (4));

(statearr_39075_39138[(5)] = null);

} else {
throw ex39068;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (14))){
var inst_38876 = (state_39023[(8)]);
var inst_38882 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_38876);
var inst_38883 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38882)].join('');
var inst_38884 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38885 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_38886 = cljs.core.PersistentHashMap.fromArrays(inst_38884,inst_38885);
var inst_38887 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38883,inst_38886);
var inst_38888 = (function(){throw inst_38887})();
var state_39023__$1 = state_39023;
var statearr_39076_39139 = state_39023__$1;
(statearr_39076_39139[(2)] = inst_38888);

(statearr_39076_39139[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (45))){
var inst_39003 = (state_39023[(12)]);
var state_39023__$1 = state_39023;
var statearr_39077_39140 = state_39023__$1;
(statearr_39077_39140[(2)] = inst_39003);

(statearr_39077_39140[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (26))){
var inst_38878 = (state_39023[(7)]);
var inst_38876 = (state_39023[(8)]);
var inst_38932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38933 = [inst_38876,inst_38878];
var inst_38934 = (new cljs.core.PersistentVector(null,2,(5),inst_38932,inst_38933,null));
var inst_38935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38936 = [inst_38876];
var inst_38937 = (new cljs.core.PersistentVector(null,1,(5),inst_38935,inst_38936,null));
var inst_38938 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_38934,cljs.core._LT__EQ_,inst_38937);
var state_39023__$1 = state_39023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39023__$1,(29),inst_38938);
} else {
if((state_val_39024 === (16))){
var inst_38877 = (state_39023[(10)]);
var inst_38895 = (state_39023[(11)]);
var inst_38891 = (state_39023[(2)]);
var inst_38895__$1 = cljs.core.identical_QMARK_;
var inst_38896 = (inst_38895__$1.cljs$core$IFn$_invoke$arity$2 ? inst_38895__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_38877) : inst_38895__$1.call(null,cljs.core.not_EQ_,inst_38877));
var state_39023__$1 = (function (){var statearr_39078 = state_39023;
(statearr_39078[(22)] = inst_38891);

(statearr_39078[(11)] = inst_38895__$1);

return statearr_39078;
})();
if(cljs.core.truth_(inst_38896)){
var statearr_39079_39141 = state_39023__$1;
(statearr_39079_39141[(1)] = (17));

} else {
var statearr_39080_39142 = state_39023__$1;
(statearr_39080_39142[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (38))){
var inst_38878 = (state_39023[(7)]);
var inst_38876 = (state_39023[(8)]);
var inst_38971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38972 = [inst_38876];
var inst_38973 = (new cljs.core.PersistentVector(null,1,(5),inst_38971,inst_38972,null));
var inst_38974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38975 = [inst_38876,inst_38878];
var inst_38976 = (new cljs.core.PersistentVector(null,2,(5),inst_38974,inst_38975,null));
var inst_38977 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38973,cljs.core._LT__EQ_,inst_38976);
var state_39023__$1 = state_39023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39023__$1,(41),inst_38977);
} else {
if((state_val_39024 === (30))){
var inst_38878 = (state_39023[(7)]);
var inst_38876 = (state_39023[(8)]);
var inst_38945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38946 = [inst_38876,inst_38878];
var inst_38947 = (new cljs.core.PersistentVector(null,2,(5),inst_38945,inst_38946,null));
var inst_38948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38949 = [inst_38876];
var inst_38950 = (new cljs.core.PersistentVector(null,1,(5),inst_38948,inst_38949,null));
var inst_38951 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38947,cljs.core._LT__EQ_,inst_38950);
var state_39023__$1 = state_39023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39023__$1,(33),inst_38951);
} else {
if((state_val_39024 === (10))){
var inst_39015 = (state_39023[(2)]);
var state_39023__$1 = state_39023;
var statearr_39081_39143 = state_39023__$1;
(statearr_39081_39143[(2)] = inst_39015);

(statearr_39081_39143[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (18))){
var inst_38877 = (state_39023[(10)]);
var inst_38895 = (state_39023[(11)]);
var inst_38920 = (inst_38895.cljs$core$IFn$_invoke$arity$2 ? inst_38895.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_38877) : inst_38895.call(null,cljs.core._EQ_,inst_38877));
var state_39023__$1 = state_39023;
if(cljs.core.truth_(inst_38920)){
var statearr_39082_39144 = state_39023__$1;
(statearr_39082_39144[(1)] = (22));

} else {
var statearr_39083_39145 = state_39023__$1;
(statearr_39083_39145[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (42))){
var inst_39003 = (state_39023[(12)]);
var inst_38846 = (state_39023[(21)]);
var inst_39003__$1 = (state_39023[(2)]);
var inst_39004 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_38846);
var inst_39005 = cljs.core.empty_QMARK_(inst_39003__$1);
var inst_39006 = ((inst_39004) && (inst_39005));
var state_39023__$1 = (function (){var statearr_39084 = state_39023;
(statearr_39084[(12)] = inst_39003__$1);

return statearr_39084;
})();
if(cljs.core.truth_(inst_39006)){
var statearr_39085_39146 = state_39023__$1;
(statearr_39085_39146[(1)] = (45));

} else {
var statearr_39086_39147 = state_39023__$1;
(statearr_39086_39147[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (37))){
var inst_38966 = (state_39023[(2)]);
var inst_38967 = fluree.db.util.async.throw_err(inst_38966);
var state_39023__$1 = state_39023;
var statearr_39087_39148 = state_39023__$1;
(statearr_39087_39148[(2)] = inst_38967);

(statearr_39087_39148[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39024 === (8))){
var inst_39018 = (state_39023[(2)]);
var _ = (function (){var statearr_39088 = state_39023;
(statearr_39088[(4)] = cljs.core.rest((state_39023[(4)])));

return statearr_39088;
})();
var state_39023__$1 = state_39023;
var statearr_39089_39149 = state_39023__$1;
(statearr_39089_39149[(2)] = inst_39018);

(statearr_39089_39149[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_39090 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39090[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_39090[(1)] = (1));

return statearr_39090;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_39023){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39023);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39091){var ex__16304__auto__ = e39091;
var statearr_39092_39150 = state_39023;
(statearr_39092_39150[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39023[(4)]))){
var statearr_39093_39151 = state_39023;
(statearr_39093_39151[(1)] = cljs.core.first((state_39023[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39152 = state_39023;
state_39023 = G__39152;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_39023){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_39023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39094 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39094[(6)] = c__16375__auto__);

return statearr_39094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__39154,offset,limit){
var map__39155 = p__39154;
var map__39155__$1 = (((((!((map__39155 == null))))?(((((map__39155.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39155.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39155):map__39155);
var res = map__39155__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39155__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39155__$1,cljs.core.cst$kw$tuples);
var vec__39157 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39157,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39157,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__39160 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__39153_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__39153_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
var G__39160__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?cljs.core.reverse(G__39160):G__39160);
var G__39160__$2 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__39160__$1):G__39160__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__39160__$2);
} else {
return G__39160__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$tuples,tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_((function (p1__39161_SHARP_){
return ((typeof p1__39161_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__39161_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__39162_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__39162_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__39166 = vars;
var vec__39167 = G__39166;
var seq__39168 = cljs.core.seq(vec__39167);
var first__39169 = cljs.core.first(seq__39168);
var seq__39168__$1 = cljs.core.next(seq__39168);
var var$ = first__39169;
var r = seq__39168__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__39166__$1 = G__39166;
var all_vars__$1 = all_vars;
while(true){
var vec__39174 = G__39166__$1;
var seq__39175 = cljs.core.seq(vec__39174);
var first__39176 = cljs.core.first(seq__39175);
var seq__39175__$1 = cljs.core.next(seq__39175);
var var$__$1 = first__39176;
var r__$1 = seq__39175__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__39177 = cljs.core.set(all_vars__$2);
return (fexpr__39177.cljs$core$IFn$_invoke$arity$1 ? fexpr__39177.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__39177.call(null,var$__$1));
})())){
var G__39178 = r__$1;
var G__39179 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__39166__$1 = G__39178;
all_vars__$1 = G__39179;
continue;
} else {
var G__39180 = r__$1;
var G__39181 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__39166__$1 = G__39180;
all_vars__$1 = G__39181;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39216){
var state_val_39217 = (state_39216[(1)]);
if((state_val_39217 === (1))){
var inst_39189 = functionArray;
var inst_39190 = cljs.core.seq(inst_39189);
var inst_39191 = cljs.core.first(inst_39190);
var inst_39192 = cljs.core.next(inst_39190);
var inst_39193 = cljs.core.PersistentVector.EMPTY;
var inst_39194 = inst_39189;
var inst_39195 = inst_39193;
var state_39216__$1 = (function (){var statearr_39218 = state_39216;
(statearr_39218[(7)] = inst_39195);

(statearr_39218[(8)] = inst_39192);

(statearr_39218[(9)] = inst_39194);

(statearr_39218[(10)] = inst_39191);

return statearr_39218;
})();
var statearr_39219_39232 = state_39216__$1;
(statearr_39219_39232[(2)] = null);

(statearr_39219_39232[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39217 === (2))){
var inst_39194 = (state_39216[(9)]);
var inst_39201 = (state_39216[(11)]);
var inst_39200 = cljs.core.seq(inst_39194);
var inst_39201__$1 = cljs.core.first(inst_39200);
var inst_39202 = cljs.core.next(inst_39200);
var state_39216__$1 = (function (){var statearr_39220 = state_39216;
(statearr_39220[(12)] = inst_39202);

(statearr_39220[(11)] = inst_39201__$1);

return statearr_39220;
})();
if(cljs.core.truth_(inst_39201__$1)){
var statearr_39221_39233 = state_39216__$1;
(statearr_39221_39233[(1)] = (4));

} else {
var statearr_39222_39234 = state_39216__$1;
(statearr_39222_39234[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39217 === (3))){
var inst_39214 = (state_39216[(2)]);
var state_39216__$1 = state_39216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39216__$1,inst_39214);
} else {
if((state_val_39217 === (4))){
var inst_39201 = (state_39216[(11)]);
var inst_39204 = (inst_39201.cljs$core$IFn$_invoke$arity$1 ? inst_39201.cljs$core$IFn$_invoke$arity$1(tuple) : inst_39201.call(null,tuple));
var state_39216__$1 = state_39216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39216__$1,(7),inst_39204);
} else {
if((state_val_39217 === (5))){
var inst_39195 = (state_39216[(7)]);
var state_39216__$1 = state_39216;
var statearr_39223_39235 = state_39216__$1;
(statearr_39223_39235[(2)] = inst_39195);

(statearr_39223_39235[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39217 === (6))){
var inst_39212 = (state_39216[(2)]);
var state_39216__$1 = state_39216;
var statearr_39224_39236 = state_39216__$1;
(statearr_39224_39236[(2)] = inst_39212);

(statearr_39224_39236[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39217 === (7))){
var inst_39195 = (state_39216[(7)]);
var inst_39202 = (state_39216[(12)]);
var inst_39206 = (state_39216[(2)]);
var inst_39207 = fluree.db.util.async.throw_err(inst_39206);
var inst_39208 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39195,inst_39207);
var inst_39194 = inst_39202;
var inst_39195__$1 = inst_39208;
var state_39216__$1 = (function (){var statearr_39225 = state_39216;
(statearr_39225[(7)] = inst_39195__$1);

(statearr_39225[(9)] = inst_39194);

return statearr_39225;
})();
var statearr_39226_39237 = state_39216__$1;
(statearr_39226_39237[(2)] = null);

(statearr_39226_39237[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____0 = (function (){
var statearr_39227 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39227[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__);

(statearr_39227[(1)] = (1));

return statearr_39227;
});
var fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____1 = (function (state_39216){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39216);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39228){var ex__16304__auto__ = e39228;
var statearr_39229_39238 = state_39216;
(statearr_39229_39238[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39216[(4)]))){
var statearr_39230_39239 = state_39216;
(statearr_39230_39239[(1)] = cljs.core.first((state_39216[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39240 = state_39216;
state_39216 = G__39240;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__ = function(state_39216){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____1.call(this,state_39216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39231 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39231[(6)] = c__16375__auto__);

return statearr_39231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__39242,headers,vars,opts){
var map__39243 = p__39242;
var map__39243__$1 = (((((!((map__39243 == null))))?(((((map__39243.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39243.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39243):map__39243);
var select_spec = map__39243__$1;
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39243__$1,cljs.core.cst$kw$prettyPrint);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39243__$1,cljs.core.cst$kw$select);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39243__$1,cljs.core.cst$kw$inVector_QMARK_);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39243__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39330){
var state_val_39331 = (state_39330[(1)]);
if((state_val_39331 === (7))){
var state_39330__$1 = state_39330;
var statearr_39332_39474 = state_39330__$1;
(statearr_39332_39474[(2)] = null);

(statearr_39332_39474[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39331 === (1))){
var state_39330__$1 = state_39330;
var statearr_39333_39475 = state_39330__$1;
(statearr_39333_39475[(2)] = null);

(statearr_39333_39475[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39331 === (4))){
var inst_39245 = (state_39330[(2)]);
var state_39330__$1 = state_39330;
var statearr_39334_39476 = state_39330__$1;
(statearr_39334_39476[(2)] = inst_39245);

(statearr_39334_39476[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39331 === (15))){
var inst_39319 = (state_39330[(2)]);
var inst_39320 = fluree.db.util.async.throw_err(inst_39319);
var state_39330__$1 = state_39330;
var statearr_39335_39477 = state_39330__$1;
(statearr_39335_39477[(2)] = inst_39320);

(statearr_39335_39477[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39331 === (13))){
var inst_39263 = (state_39330[(7)]);
var inst_39255 = (state_39330[(8)]);
var inst_39322 = (function (){var pp = inst_39255;
var functionArray = inst_39263;
return (function (tuple){
var tuple_res = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39241_SHARP_){
return (p1__39241_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__39241_SHARP_.cljs$core$IFn$_invoke$arity$1(tuple) : p1__39241_SHARP_.call(null,tuple));
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap(pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first(tuple_res);

}
}
});
})();
var inst_39323 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39322,tuples);
var state_39330__$1 = state_39330;
var statearr_39336_39478 = state_39330__$1;
(statearr_39336_39478[(2)] = inst_39323);

(statearr_39336_39478[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39331 === (6))){
var inst_39252 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_39330__$1 = state_39330;
var statearr_39337_39479 = state_39330__$1;
(statearr_39337_39479[(2)] = inst_39252);

(statearr_39337_39479[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39331 === (3))){
var inst_39328 = (state_39330[(2)]);
var state_39330__$1 = state_39330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39330__$1,inst_39328);
} else {
if((state_val_39331 === (12))){
var inst_39263 = (state_39330[(7)]);
var inst_39255 = (state_39330[(8)]);
var inst_39315 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_39316 = (function (){var pp = inst_39255;
var functionArray = inst_39263;
var c__16375__auto____$1 = inst_39315;
return (function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39313){
var state_val_39314 = (state_39313[(1)]);
if((state_val_39314 === (7))){
var inst_39289 = (state_39313[(2)]);
var inst_39290 = fluree.db.util.async.throw_err(inst_39289);
var state_39313__$1 = (function (){var statearr_39338 = state_39313;
(statearr_39338[(7)] = inst_39290);

return statearr_39338;
})();
if(cljs.core.truth_(pp)){
var statearr_39339_39480 = state_39313__$1;
(statearr_39339_39480[(1)] = (8));

} else {
var statearr_39340_39481 = state_39313__$1;
(statearr_39340_39481[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (1))){
var inst_39272 = tuples;
var inst_39273 = cljs.core.seq(inst_39272);
var inst_39274 = cljs.core.first(inst_39273);
var inst_39275 = cljs.core.next(inst_39273);
var inst_39276 = cljs.core.PersistentVector.EMPTY;
var inst_39277 = inst_39272;
var inst_39278 = inst_39276;
var state_39313__$1 = (function (){var statearr_39341 = state_39313;
(statearr_39341[(8)] = inst_39274);

(statearr_39341[(9)] = inst_39277);

(statearr_39341[(10)] = inst_39278);

(statearr_39341[(11)] = inst_39275);

return statearr_39341;
})();
var statearr_39342_39482 = state_39313__$1;
(statearr_39342_39482[(2)] = null);

(statearr_39342_39482[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (4))){
var inst_39284 = (state_39313[(12)]);
var inst_39287 = fluree.db.query.fql.format_tuple(functionArray,inst_39284);
var state_39313__$1 = state_39313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39313__$1,(7),inst_39287);
} else {
if((state_val_39314 === (15))){
var state_39313__$1 = state_39313;
var statearr_39343_39483 = state_39313__$1;
(statearr_39343_39483[(2)] = null);

(statearr_39343_39483[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (13))){
var inst_39302 = (state_39313[(2)]);
var state_39313__$1 = state_39313;
var statearr_39344_39484 = state_39313__$1;
(statearr_39344_39484[(2)] = inst_39302);

(statearr_39344_39484[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (6))){
var inst_39309 = (state_39313[(2)]);
var state_39313__$1 = state_39313;
var statearr_39345_39485 = state_39313__$1;
(statearr_39345_39485[(2)] = inst_39309);

(statearr_39345_39485[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (3))){
var inst_39311 = (state_39313[(2)]);
var state_39313__$1 = state_39313;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39313__$1,inst_39311);
} else {
if((state_val_39314 === (12))){
var state_39313__$1 = state_39313;
var statearr_39346_39486 = state_39313__$1;
(statearr_39346_39486[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (2))){
var inst_39277 = (state_39313[(9)]);
var inst_39284 = (state_39313[(12)]);
var inst_39283 = cljs.core.seq(inst_39277);
var inst_39284__$1 = cljs.core.first(inst_39283);
var inst_39285 = cljs.core.next(inst_39283);
var state_39313__$1 = (function (){var statearr_39348 = state_39313;
(statearr_39348[(13)] = inst_39285);

(statearr_39348[(12)] = inst_39284__$1);

return statearr_39348;
})();
if(cljs.core.truth_(inst_39284__$1)){
var statearr_39349_39487 = state_39313__$1;
(statearr_39349_39487[(1)] = (4));

} else {
var statearr_39350_39488 = state_39313__$1;
(statearr_39350_39488[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (11))){
var inst_39290 = (state_39313[(7)]);
var state_39313__$1 = state_39313;
var statearr_39351_39489 = state_39313__$1;
(statearr_39351_39489[(2)] = inst_39290);

(statearr_39351_39489[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (9))){
var state_39313__$1 = state_39313;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_39352_39490 = state_39313__$1;
(statearr_39352_39490[(1)] = (11));

} else {
var statearr_39353_39491 = state_39313__$1;
(statearr_39353_39491[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (5))){
var inst_39278 = (state_39313[(10)]);
var state_39313__$1 = state_39313;
var statearr_39354_39492 = state_39313__$1;
(statearr_39354_39492[(2)] = inst_39278);

(statearr_39354_39492[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (14))){
var inst_39290 = (state_39313[(7)]);
var inst_39297 = cljs.core.first(inst_39290);
var state_39313__$1 = state_39313;
var statearr_39355_39493 = state_39313__$1;
(statearr_39355_39493[(2)] = inst_39297);

(statearr_39355_39493[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (16))){
var inst_39300 = (state_39313[(2)]);
var state_39313__$1 = state_39313;
var statearr_39356_39494 = state_39313__$1;
(statearr_39356_39494[(2)] = inst_39300);

(statearr_39356_39494[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (10))){
var inst_39285 = (state_39313[(13)]);
var inst_39278 = (state_39313[(10)]);
var inst_39304 = (state_39313[(2)]);
var inst_39305 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39278,inst_39304);
var inst_39277 = inst_39285;
var inst_39278__$1 = inst_39305;
var state_39313__$1 = (function (){var statearr_39357 = state_39313;
(statearr_39357[(9)] = inst_39277);

(statearr_39357[(10)] = inst_39278__$1);

return statearr_39357;
})();
var statearr_39358_39495 = state_39313__$1;
(statearr_39358_39495[(2)] = null);

(statearr_39358_39495[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39314 === (8))){
var inst_39290 = (state_39313[(7)]);
var inst_39292 = cljs.core.zipmap(pp,inst_39290);
var state_39313__$1 = state_39313;
var statearr_39359_39496 = state_39313__$1;
(statearr_39359_39496[(2)] = inst_39292);

(statearr_39359_39496[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_39360 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39360[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__);

(statearr_39360[(1)] = (1));

return statearr_39360;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1 = (function (state_39313){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39313);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39361){var ex__16304__auto__ = e39361;
var statearr_39362_39497 = state_39313;
(statearr_39362_39497[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39313[(4)]))){
var statearr_39363_39498 = state_39313;
(statearr_39363_39498[(1)] = cljs.core.first((state_39313[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39499 = state_39313;
state_39313 = G__39499;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = function(state_39313){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1.call(this,state_39313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39364 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39364[(6)] = c__16375__auto____$1);

return statearr_39364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
});
})();
var inst_39317 = cljs.core.async.impl.dispatch.run(inst_39316);
var state_39330__$1 = (function (){var statearr_39365 = state_39330;
(statearr_39365[(9)] = inst_39317);

return statearr_39365;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39330__$1,(15),inst_39315);
} else {
if((state_val_39331 === (2))){
var _ = (function (){var statearr_39366 = state_39330;
(statearr_39366[(4)] = cljs.core.cons((5),(state_39330[(4)])));

return statearr_39366;
})();
var state_39330__$1 = state_39330;
if(cljs.core.truth_(prettyPrint)){
var statearr_39367_39500 = state_39330__$1;
(statearr_39367_39500[(1)] = (6));

} else {
var statearr_39368_39501 = state_39330__$1;
(statearr_39368_39501[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39331 === (11))){
var inst_39263 = (state_39330[(2)]);
var state_39330__$1 = (function (){var statearr_39370 = state_39330;
(statearr_39370[(7)] = inst_39263);

return statearr_39370;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_39371_39502 = state_39330__$1;
(statearr_39371_39502[(1)] = (12));

} else {
var statearr_39372_39503 = state_39330__$1;
(statearr_39372_39503[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39331 === (9))){
var inst_39255 = (state_39330[(8)]);
var inst_39257 = (function (){var pp = inst_39255;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of(headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?(function (tuple){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val);
}):null)));
if(cljs.core.truth_(cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__16375__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39407){
var state_val_39408 = (state_39407[(1)]);
if((state_val_39408 === (7))){
var state_39407__$1 = state_39407;
var statearr_39409_39504 = state_39407__$1;
(statearr_39409_39504[(2)] = null);

(statearr_39409_39504[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39408 === (1))){
var state_39407__$1 = state_39407;
var statearr_39410_39505 = state_39407__$1;
(statearr_39410_39505[(2)] = null);

(statearr_39410_39505[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39408 === (4))){
var inst_39373 = (state_39407[(2)]);
var state_39407__$1 = state_39407;
var statearr_39411_39506 = state_39407__$1;
(statearr_39411_39506[(2)] = inst_39373);

(statearr_39411_39506[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39408 === (6))){
var inst_39383 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_39384 = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_39385 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_39386 = [inst_39384,inst_39385,opts];
var inst_39387 = cljs.core.PersistentHashMap.fromArrays(inst_39383,inst_39386);
var inst_39388 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_39387) : fluree.db.query.fql.query.call(null,db,inst_39387));
var state_39407__$1 = state_39407;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39407__$1,(9),inst_39388);
} else {
if((state_val_39408 === (3))){
var inst_39405 = (state_39407[(2)]);
var state_39407__$1 = state_39407;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39407__$1,inst_39405);
} else {
if((state_val_39408 === (12))){
var inst_39399 = (state_39407[(2)]);
var state_39407__$1 = state_39407;
var statearr_39412_39507 = state_39407__$1;
(statearr_39412_39507[(2)] = inst_39399);

(statearr_39412_39507[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39408 === (2))){
var _ = (function (){var statearr_39413 = state_39407;
(statearr_39413[(4)] = cljs.core.cons((5),(state_39407[(4)])));

return statearr_39413;
})();
var inst_39379 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_39407__$1 = state_39407;
if(cljs.core.truth_(inst_39379)){
var statearr_39414_39508 = state_39407__$1;
(statearr_39414_39508[(1)] = (6));

} else {
var statearr_39415_39509 = state_39407__$1;
(statearr_39415_39509[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39408 === (11))){
var inst_39394 = [cljs.core.cst$kw$_id];
var inst_39395 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_39396 = [inst_39395];
var inst_39397 = cljs.core.PersistentHashMap.fromArrays(inst_39394,inst_39396);
var state_39407__$1 = state_39407;
var statearr_39417_39510 = state_39407__$1;
(statearr_39417_39510[(2)] = inst_39397);

(statearr_39417_39510[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39408 === (9))){
var inst_39391 = (state_39407[(7)]);
var inst_39390 = (state_39407[(2)]);
var inst_39391__$1 = fluree.db.util.async.throw_err(inst_39390);
var state_39407__$1 = (function (){var statearr_39418 = state_39407;
(statearr_39418[(7)] = inst_39391__$1);

return statearr_39418;
})();
if(cljs.core.truth_(inst_39391__$1)){
var statearr_39419_39511 = state_39407__$1;
(statearr_39419_39511[(1)] = (10));

} else {
var statearr_39420_39512 = state_39407__$1;
(statearr_39420_39512[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39408 === (5))){
var _ = (function (){var statearr_39421 = state_39407;
(statearr_39421[(4)] = cljs.core.rest((state_39407[(4)])));

return statearr_39421;
})();
var state_39407__$1 = state_39407;
var ex39416 = (state_39407__$1[(2)]);
var statearr_39422_39513 = state_39407__$1;
(statearr_39422_39513[(5)] = ex39416);


if((ex39416 instanceof Error)){
var statearr_39423_39514 = state_39407__$1;
(statearr_39423_39514[(1)] = (4));

(statearr_39423_39514[(5)] = null);

} else {
throw ex39416;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39408 === (10))){
var inst_39391 = (state_39407[(7)]);
var state_39407__$1 = state_39407;
var statearr_39424_39515 = state_39407__$1;
(statearr_39424_39515[(2)] = inst_39391);

(statearr_39424_39515[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39408 === (8))){
var inst_39402 = (state_39407[(2)]);
var _ = (function (){var statearr_39425 = state_39407;
(statearr_39425[(4)] = cljs.core.rest((state_39407[(4)])));

return statearr_39425;
})();
var state_39407__$1 = state_39407;
var statearr_39426_39516 = state_39407__$1;
(statearr_39426_39516[(2)] = inst_39402);

(statearr_39426_39516[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_39427 = [null,null,null,null,null,null,null,null];
(statearr_39427[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__);

(statearr_39427[(1)] = (1));

return statearr_39427;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1 = (function (state_39407){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39407);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39428){var ex__16304__auto__ = e39428;
var statearr_39429_39517 = state_39407;
(statearr_39429_39517[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39407[(4)]))){
var statearr_39430_39518 = state_39407;
(statearr_39430_39518[(1)] = cljs.core.first((state_39407[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39519 = state_39407;
state_39407 = G__39519;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = function(state_39407){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1.call(this,state_39407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39431 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39431[(6)] = c__16375__auto____$1);

return statearr_39431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto____$1;
});
} else {
return (function (tuple){
var c__16375__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39443){
var state_val_39444 = (state_39443[(1)]);
if((state_val_39444 === (1))){
var state_39443__$1 = state_39443;
var statearr_39445_39520 = state_39443__$1;
(statearr_39445_39520[(2)] = null);

(statearr_39445_39520[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39444 === (2))){
var _ = (function (){var statearr_39446 = state_39443;
(statearr_39446[(4)] = cljs.core.cons((5),(state_39443[(4)])));

return statearr_39446;
})();
var inst_39438 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var ___$1 = (function (){var statearr_39447 = state_39443;
(statearr_39447[(4)] = cljs.core.rest((state_39443[(4)])));

return statearr_39447;
})();
var state_39443__$1 = state_39443;
var statearr_39448_39521 = state_39443__$1;
(statearr_39448_39521[(2)] = inst_39438);

(statearr_39448_39521[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39444 === (3))){
var inst_39441 = (state_39443[(2)]);
var state_39443__$1 = state_39443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39443__$1,inst_39441);
} else {
if((state_val_39444 === (4))){
var inst_39432 = (state_39443[(2)]);
var state_39443__$1 = state_39443;
var statearr_39450_39522 = state_39443__$1;
(statearr_39450_39522[(2)] = inst_39432);

(statearr_39450_39522[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39444 === (5))){
var _ = (function (){var statearr_39451 = state_39443;
(statearr_39451[(4)] = cljs.core.rest((state_39443[(4)])));

return statearr_39451;
})();
var state_39443__$1 = state_39443;
var ex39449 = (state_39443__$1[(2)]);
var statearr_39452_39523 = state_39443__$1;
(statearr_39452_39523[(5)] = ex39449);


if((ex39449 instanceof Error)){
var statearr_39453_39524 = state_39443__$1;
(statearr_39453_39524[(1)] = (4));

(statearr_39453_39524[(5)] = null);

} else {
throw ex39449;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_39454 = [null,null,null,null,null,null,null];
(statearr_39454[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__);

(statearr_39454[(1)] = (1));

return statearr_39454;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1 = (function (state_39443){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39443);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39455){var ex__16304__auto__ = e39455;
var statearr_39456_39525 = state_39443;
(statearr_39456_39525[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39443[(4)]))){
var statearr_39457_39526 = state_39443;
(statearr_39457_39526[(1)] = cljs.core.first((state_39443[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39527 = state_39443;
state_39443 = G__39527;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = function(state_39443){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1.call(this,state_39443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39458 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39458[(6)] = c__16375__auto____$1);

return statearr_39458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto____$1;
});
}
});
})();
var inst_39258 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39257,select);
var state_39330__$1 = state_39330;
var statearr_39459_39528 = state_39330__$1;
(statearr_39459_39528[(2)] = inst_39258);

(statearr_39459_39528[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39331 === (5))){
var _ = (function (){var statearr_39460 = state_39330;
(statearr_39460[(4)] = cljs.core.rest((state_39330[(4)])));

return statearr_39460;
})();
var state_39330__$1 = state_39330;
var ex39369 = (state_39330__$1[(2)]);
var statearr_39461_39529 = state_39330__$1;
(statearr_39461_39529[(5)] = ex39369);


if((ex39369 instanceof Error)){
var statearr_39462_39530 = state_39330__$1;
(statearr_39462_39530[(1)] = (4));

(statearr_39462_39530[(5)] = null);

} else {
throw ex39369;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39331 === (14))){
var inst_39325 = (state_39330[(2)]);
var _ = (function (){var statearr_39463 = state_39330;
(statearr_39463[(4)] = cljs.core.rest((state_39330[(4)])));

return statearr_39463;
})();
var state_39330__$1 = state_39330;
var statearr_39464_39531 = state_39330__$1;
(statearr_39464_39531[(2)] = inst_39325);

(statearr_39464_39531[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39331 === (10))){
var inst_39255 = (state_39330[(8)]);
var inst_39260 = (function (){var pp = inst_39255;
return (function (select__$1){
var temp__5733__auto__ = cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx(headers,select__$1);
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});
}
});
})();
var inst_39261 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39260,select);
var state_39330__$1 = state_39330;
var statearr_39465_39532 = state_39330__$1;
(statearr_39465_39532[(2)] = inst_39261);

(statearr_39465_39532[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39331 === (8))){
var inst_39255 = (state_39330[(2)]);
var state_39330__$1 = (function (){var statearr_39466 = state_39330;
(statearr_39466[(8)] = inst_39255);

return statearr_39466;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_39467_39533 = state_39330__$1;
(statearr_39467_39533[(1)] = (9));

} else {
var statearr_39468_39534 = state_39330__$1;
(statearr_39468_39534[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_39469 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39469[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__);

(statearr_39469[(1)] = (1));

return statearr_39469;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1 = (function (state_39330){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39330);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39470){var ex__16304__auto__ = e39470;
var statearr_39471_39535 = state_39330;
(statearr_39471_39535[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39330[(4)]))){
var statearr_39472_39536 = state_39330;
(statearr_39472_39536[(1)] = cljs.core.first((state_39330[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39537 = state_39330;
state_39330 = G__39537;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = function(state_39330){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1.call(this,state_39330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39473 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39473[(6)] = c__16375__auto__);

return statearr_39473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__39539 = arguments.length;
switch (G__39539) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__39540,p__39541,group_limit,opts){
var map__39542 = p__39540;
var map__39542__$1 = (((((!((map__39542 == null))))?(((((map__39542.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39542.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39542):map__39542);
var res = map__39542__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39542__$1,cljs.core.cst$kw$vars);
var map__39543 = p__39541;
var map__39543__$1 = (((((!((map__39543 == null))))?(((((map__39543.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39543.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39543):map__39543);
var select_spec = map__39543__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39543__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39543__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39543__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39543__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39543__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39543__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39543__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39543__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39543__$1,cljs.core.cst$kw$groupBy);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39655){
var state_val_39656 = (state_39655[(1)]);
if((state_val_39656 === (7))){
var inst_39552 = (state_39655[(7)]);
var state_39655__$1 = state_39655;
var statearr_39657_39737 = state_39655__$1;
(statearr_39657_39737[(2)] = inst_39552);

(statearr_39657_39737[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (20))){
var inst_39587 = (state_39655[(2)]);
var state_39655__$1 = (function (){var statearr_39658 = state_39655;
(statearr_39658[(8)] = inst_39587);

return statearr_39658;
})();
if(cljs.core.truth_(groupBy)){
var statearr_39659_39738 = state_39655__$1;
(statearr_39659_39738[(1)] = (21));

} else {
var statearr_39660_39739 = state_39655__$1;
(statearr_39660_39739[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (27))){
var inst_39596 = (state_39655[(9)]);
var inst_39601 = inst_39596.cljs$lang$protocol_mask$partition0$;
var inst_39602 = (inst_39601 & (64));
var inst_39603 = inst_39596.cljs$core$ISeq$;
var inst_39604 = (cljs.core.PROTOCOL_SENTINEL === inst_39603);
var inst_39605 = ((inst_39602) || (inst_39604));
var state_39655__$1 = state_39655;
if(cljs.core.truth_(inst_39605)){
var statearr_39661_39740 = state_39655__$1;
(statearr_39661_39740[(1)] = (30));

} else {
var statearr_39662_39741 = state_39655__$1;
(statearr_39662_39741[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (1))){
var state_39655__$1 = state_39655;
var statearr_39663_39742 = state_39655__$1;
(statearr_39663_39742[(2)] = null);

(statearr_39663_39742[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (24))){
var inst_39591 = (state_39655[(10)]);
var inst_39587 = (state_39655[(8)]);
var inst_39593 = fluree.db.query.fql.order_offset_and_limit_results(orderBy,inst_39587,inst_39591,group_limit);
var state_39655__$1 = state_39655;
var statearr_39664_39743 = state_39655__$1;
(statearr_39664_39743[(2)] = inst_39593);

(statearr_39664_39743[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (39))){
var inst_39622 = (state_39655[(11)]);
var state_39655__$1 = state_39655;
var statearr_39665_39744 = state_39655__$1;
(statearr_39665_39744[(2)] = inst_39622);

(statearr_39665_39744[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (46))){
var inst_39640 = (state_39655[(12)]);
var inst_39642 = cljs.core.PersistentVector.EMPTY;
var inst_39643 = cljs.core.PersistentHashSet.EMPTY;
var inst_39644 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39643,inst_39640);
var inst_39645 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39642,inst_39644);
var state_39655__$1 = state_39655;
var statearr_39666_39745 = state_39655__$1;
(statearr_39666_39745[(2)] = inst_39645);

(statearr_39666_39745[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (4))){
var inst_39546 = (state_39655[(2)]);
var state_39655__$1 = state_39655;
var statearr_39667_39746 = state_39655__$1;
(statearr_39667_39746[(2)] = inst_39546);

(statearr_39667_39746[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (15))){
var inst_39573 = (state_39655[(13)]);
var inst_39575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39576 = [inst_39573];
var inst_39577 = (new cljs.core.PersistentVector(null,1,(5),inst_39575,inst_39576,null));
var state_39655__$1 = state_39655;
var statearr_39668_39747 = state_39655__$1;
(statearr_39668_39747[(2)] = inst_39577);

(statearr_39668_39747[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (48))){
var inst_39648 = (state_39655[(2)]);
var state_39655__$1 = state_39655;
var statearr_39669_39748 = state_39655__$1;
(statearr_39669_39748[(2)] = inst_39648);

(statearr_39669_39748[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (21))){
var state_39655__$1 = state_39655;
var statearr_39670_39749 = state_39655__$1;
(statearr_39670_39749[(2)] = (0));

(statearr_39670_39749[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (31))){
var state_39655__$1 = state_39655;
var statearr_39671_39750 = state_39655__$1;
(statearr_39671_39750[(2)] = false);

(statearr_39671_39750[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (32))){
var inst_39609 = (state_39655[(2)]);
var state_39655__$1 = state_39655;
var statearr_39672_39751 = state_39655__$1;
(statearr_39672_39751[(2)] = inst_39609);

(statearr_39672_39751[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (40))){
var inst_39591 = (state_39655[(10)]);
var state_39655__$1 = state_39655;
var statearr_39673_39752 = state_39655__$1;
(statearr_39673_39752[(2)] = inst_39591);

(statearr_39673_39752[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (33))){
var inst_39596 = (state_39655[(9)]);
var inst_39614 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_39596);
var state_39655__$1 = state_39655;
var statearr_39674_39753 = state_39655__$1;
(statearr_39674_39753[(2)] = inst_39614);

(statearr_39674_39753[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (13))){
var inst_39562 = (state_39655[(14)]);
var state_39655__$1 = state_39655;
var statearr_39675_39754 = state_39655__$1;
(statearr_39675_39754[(2)] = inst_39562);

(statearr_39675_39754[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (22))){
var state_39655__$1 = state_39655;
var statearr_39676_39755 = state_39655__$1;
(statearr_39676_39755[(2)] = offset);

(statearr_39676_39755[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (36))){
var inst_39622 = (state_39655[(11)]);
var inst_39622__$1 = limit;
var state_39655__$1 = (function (){var statearr_39677 = state_39655;
(statearr_39677[(11)] = inst_39622__$1);

return statearr_39677;
})();
if(cljs.core.truth_(inst_39622__$1)){
var statearr_39678_39756 = state_39655__$1;
(statearr_39678_39756[(1)] = (39));

} else {
var statearr_39679_39757 = state_39655__$1;
(statearr_39679_39757[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (41))){
var inst_39626 = (state_39655[(2)]);
var state_39655__$1 = state_39655;
var statearr_39680_39758 = state_39655__$1;
(statearr_39680_39758[(2)] = inst_39626);

(statearr_39680_39758[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (43))){
var inst_39619 = (state_39655[(15)]);
var state_39655__$1 = state_39655;
var statearr_39681_39759 = state_39655__$1;
(statearr_39681_39759[(2)] = inst_39619);

(statearr_39681_39759[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (29))){
var inst_39612 = (state_39655[(2)]);
var state_39655__$1 = state_39655;
if(cljs.core.truth_(inst_39612)){
var statearr_39682_39760 = state_39655__$1;
(statearr_39682_39760[(1)] = (33));

} else {
var statearr_39683_39761 = state_39655__$1;
(statearr_39683_39761[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (44))){
var inst_39618 = (state_39655[(16)]);
var inst_39635 = (state_39655[(2)]);
var inst_39636 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_39637 = fluree.db.query.fql.format_filter_tuples(db,inst_39635,select_spec,inst_39618,vars,inst_39636);
var state_39655__$1 = state_39655;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39655__$1,(45),inst_39637);
} else {
if((state_val_39656 === (6))){
var inst_39554 = cljs.core.count(select);
var inst_39555 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_39554);
var state_39655__$1 = state_39655;
var statearr_39684_39762 = state_39655__$1;
(statearr_39684_39762[(2)] = inst_39555);

(statearr_39684_39762[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (28))){
var state_39655__$1 = state_39655;
var statearr_39685_39763 = state_39655__$1;
(statearr_39685_39763[(2)] = false);

(statearr_39685_39763[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (25))){
var inst_39587 = (state_39655[(8)]);
var state_39655__$1 = state_39655;
var statearr_39686_39764 = state_39655__$1;
(statearr_39686_39764[(2)] = inst_39587);

(statearr_39686_39764[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (34))){
var inst_39596 = (state_39655[(9)]);
var state_39655__$1 = state_39655;
var statearr_39687_39765 = state_39655__$1;
(statearr_39687_39765[(2)] = inst_39596);

(statearr_39687_39765[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (17))){
var inst_39580 = (state_39655[(2)]);
var state_39655__$1 = state_39655;
var statearr_39688_39766 = state_39655__$1;
(statearr_39688_39766[(2)] = inst_39580);

(statearr_39688_39766[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (3))){
var inst_39653 = (state_39655[(2)]);
var state_39655__$1 = state_39655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39655__$1,inst_39653);
} else {
if((state_val_39656 === (12))){
var inst_39562 = (state_39655[(14)]);
var inst_39564 = cljs.core.first(select);
var inst_39565 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_39564);
var inst_39566 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39565);
var inst_39567 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_39566,(1));
var inst_39568 = [inst_39567];
var inst_39569 = [inst_39562];
var inst_39570 = cljs.core.PersistentHashMap.fromArrays(inst_39568,inst_39569);
var state_39655__$1 = state_39655;
var statearr_39689_39767 = state_39655__$1;
(statearr_39689_39767[(2)] = inst_39570);

(statearr_39689_39767[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (2))){
var inst_39552 = (state_39655[(7)]);
var _ = (function (){var statearr_39690 = state_39655;
(statearr_39690[(4)] = cljs.core.cons((5),(state_39655[(4)])));

return statearr_39690;
})();
var inst_39552__$1 = aggregates;
var state_39655__$1 = (function (){var statearr_39691 = state_39655;
(statearr_39691[(7)] = inst_39552__$1);

return statearr_39691;
})();
if(cljs.core.truth_(inst_39552__$1)){
var statearr_39692_39768 = state_39655__$1;
(statearr_39692_39768[(1)] = (6));

} else {
var statearr_39693_39769 = state_39655__$1;
(statearr_39693_39769[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (23))){
var inst_39591 = (state_39655[(2)]);
var state_39655__$1 = (function (){var statearr_39694 = state_39655;
(statearr_39694[(10)] = inst_39591);

return statearr_39694;
})();
if(cljs.core.truth_(orderBy)){
var statearr_39695_39770 = state_39655__$1;
(statearr_39695_39770[(1)] = (24));

} else {
var statearr_39696_39771 = state_39655__$1;
(statearr_39696_39771[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (47))){
var inst_39640 = (state_39655[(12)]);
var state_39655__$1 = state_39655;
var statearr_39697_39772 = state_39655__$1;
(statearr_39697_39772[(2)] = inst_39640);

(statearr_39697_39772[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (35))){
var inst_39617 = (state_39655[(2)]);
var inst_39618 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39617,cljs.core.cst$kw$headers);
var inst_39619 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39617,cljs.core.cst$kw$tuples);
var inst_39620 = cljs.core.not(orderBy);
var state_39655__$1 = (function (){var statearr_39698 = state_39655;
(statearr_39698[(15)] = inst_39619);

(statearr_39698[(16)] = inst_39618);

return statearr_39698;
})();
if(inst_39620){
var statearr_39699_39773 = state_39655__$1;
(statearr_39699_39773[(1)] = (36));

} else {
var statearr_39700_39774 = state_39655__$1;
(statearr_39700_39774[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (19))){
var state_39655__$1 = state_39655;
var statearr_39701_39775 = state_39655__$1;
(statearr_39701_39775[(2)] = res);

(statearr_39701_39775[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (11))){
var inst_39650 = (state_39655[(2)]);
var _ = (function (){var statearr_39703 = state_39655;
(statearr_39703[(4)] = cljs.core.rest((state_39655[(4)])));

return statearr_39703;
})();
var state_39655__$1 = state_39655;
var statearr_39704_39776 = state_39655__$1;
(statearr_39704_39776[(2)] = inst_39650);

(statearr_39704_39776[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (9))){
var inst_39560 = cljs.core.first(aggregates);
var inst_39561 = fluree.db.query.analytical.calculate_aggregate(res,inst_39560);
var inst_39562 = cljs.core.second(inst_39561);
var state_39655__$1 = (function (){var statearr_39705 = state_39655;
(statearr_39705[(14)] = inst_39562);

return statearr_39705;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_39706_39777 = state_39655__$1;
(statearr_39706_39777[(1)] = (12));

} else {
var statearr_39707_39778 = state_39655__$1;
(statearr_39707_39778[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (5))){
var _ = (function (){var statearr_39708 = state_39655;
(statearr_39708[(4)] = cljs.core.rest((state_39655[(4)])));

return statearr_39708;
})();
var state_39655__$1 = state_39655;
var ex39702 = (state_39655__$1[(2)]);
var statearr_39709_39779 = state_39655__$1;
(statearr_39709_39779[(5)] = ex39702);


if((ex39702 instanceof Error)){
var statearr_39710_39780 = state_39655__$1;
(statearr_39710_39780[(1)] = (4));

(statearr_39710_39780[(5)] = null);

} else {
throw ex39702;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (14))){
var inst_39573 = (state_39655[(2)]);
var state_39655__$1 = (function (){var statearr_39711 = state_39655;
(statearr_39711[(13)] = inst_39573);

return statearr_39711;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_39712_39781 = state_39655__$1;
(statearr_39712_39781[(1)] = (15));

} else {
var statearr_39713_39782 = state_39655__$1;
(statearr_39713_39782[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (45))){
var inst_39639 = (state_39655[(2)]);
var inst_39640 = fluree.db.util.async.throw_err(inst_39639);
var state_39655__$1 = (function (){var statearr_39714 = state_39655;
(statearr_39714[(12)] = inst_39640);

return statearr_39714;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_39715_39783 = state_39655__$1;
(statearr_39715_39783[(1)] = (46));

} else {
var statearr_39716_39784 = state_39655__$1;
(statearr_39716_39784[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (26))){
var inst_39596 = (state_39655[(9)]);
var inst_39596__$1 = (state_39655[(2)]);
var inst_39598 = (inst_39596__$1 == null);
var inst_39599 = cljs.core.not(inst_39598);
var state_39655__$1 = (function (){var statearr_39717 = state_39655;
(statearr_39717[(9)] = inst_39596__$1);

return statearr_39717;
})();
if(inst_39599){
var statearr_39718_39785 = state_39655__$1;
(statearr_39718_39785[(1)] = (27));

} else {
var statearr_39719_39786 = state_39655__$1;
(statearr_39719_39786[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (16))){
var inst_39573 = (state_39655[(13)]);
var state_39655__$1 = state_39655;
var statearr_39720_39787 = state_39655__$1;
(statearr_39720_39787[(2)] = inst_39573);

(statearr_39720_39787[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (38))){
var inst_39629 = (state_39655[(2)]);
var state_39655__$1 = state_39655;
if(cljs.core.truth_(inst_39629)){
var statearr_39721_39788 = state_39655__$1;
(statearr_39721_39788[(1)] = (42));

} else {
var statearr_39722_39789 = state_39655__$1;
(statearr_39722_39789[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (30))){
var state_39655__$1 = state_39655;
var statearr_39723_39790 = state_39655__$1;
(statearr_39723_39790[(2)] = true);

(statearr_39723_39790[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (10))){
var state_39655__$1 = state_39655;
if(cljs.core.truth_(aggregates)){
var statearr_39724_39791 = state_39655__$1;
(statearr_39724_39791[(1)] = (18));

} else {
var statearr_39725_39792 = state_39655__$1;
(statearr_39725_39792[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (18))){
var inst_39584 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_39655__$1 = state_39655;
var statearr_39726_39793 = state_39655__$1;
(statearr_39726_39793[(2)] = inst_39584);

(statearr_39726_39793[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (42))){
var inst_39619 = (state_39655[(15)]);
var inst_39591 = (state_39655[(10)]);
var inst_39631 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_39591,inst_39619);
var inst_39632 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_39631);
var state_39655__$1 = state_39655;
var statearr_39727_39794 = state_39655__$1;
(statearr_39727_39794[(2)] = inst_39632);

(statearr_39727_39794[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (37))){
var state_39655__$1 = state_39655;
var statearr_39728_39795 = state_39655__$1;
(statearr_39728_39795[(2)] = false);

(statearr_39728_39795[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39656 === (8))){
var inst_39558 = (state_39655[(2)]);
var state_39655__$1 = state_39655;
if(cljs.core.truth_(inst_39558)){
var statearr_39729_39796 = state_39655__$1;
(statearr_39729_39796[(1)] = (9));

} else {
var statearr_39730_39797 = state_39655__$1;
(statearr_39730_39797[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_39731 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39731[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_39731[(1)] = (1));

return statearr_39731;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_39655){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39655);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39732){var ex__16304__auto__ = e39732;
var statearr_39733_39798 = state_39655;
(statearr_39733_39798[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39655[(4)]))){
var statearr_39734_39799 = state_39655;
(statearr_39734_39799[(1)] = cljs.core.first((state_39655[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39800 = state_39655;
state_39655 = G__39800;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_39655){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_39655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39735 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39735[(6)] = c__16375__auto__);

return statearr_39735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__39803,groupBy){
var map__39804 = p__39803;
var map__39804__$1 = (((((!((map__39804 == null))))?(((((map__39804.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39804.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39804):map__39804);
var res = map__39804__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39804__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39804__$1,cljs.core.cst$kw$tuples);
var vec__39806 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39806,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39806,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39801_SHARP_){
return fluree.db.util.core.index_of(headers,p1__39801_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39802_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__39802_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__39809,p__39810,opts){
var map__39811 = p__39809;
var map__39811__$1 = (((((!((map__39811 == null))))?(((((map__39811.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39811.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39811):map__39811);
var res = map__39811__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39811__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39811__$1,cljs.core.cst$kw$vars);
var map__39812 = p__39810;
var map__39812__$1 = (((((!((map__39812 == null))))?(((((map__39812.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39812.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39812):map__39812);
var select_spec = map__39812__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39812__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39812__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39812__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39812__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39812__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39812__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39812__$1,cljs.core.cst$kw$offset);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40037){
var state_val_40038 = (state_40037[(1)]);
if((state_val_40038 === (65))){
var inst_39999 = (state_40037[(2)]);
var inst_40000 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,inst_39999,opts);
var state_40037__$1 = state_40037;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40037__$1,(66),inst_40000);
} else {
if((state_val_40038 === (70))){
var inst_40003 = (state_40037[(7)]);
var inst_40008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40009 = [inst_40003];
var inst_40010 = (new cljs.core.PersistentVector(null,1,(5),inst_40008,inst_40009,null));
var state_40037__$1 = state_40037;
var statearr_40039_40162 = state_40037__$1;
(statearr_40039_40162[(2)] = inst_40010);

(statearr_40039_40162[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (62))){
var inst_39992 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40040_40163 = state_40037__$1;
(statearr_40040_40163[(2)] = inst_39992);

(statearr_40040_40163[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (74))){
var state_40037__$1 = state_40037;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40041_40164 = state_40037__$1;
(statearr_40041_40164[(1)] = (76));

} else {
var statearr_40042_40165 = state_40037__$1;
(statearr_40042_40165[(1)] = (77));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (7))){
var state_40037__$1 = state_40037;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40043_40166 = state_40037__$1;
(statearr_40043_40166[(1)] = (63));

} else {
var statearr_40044_40167 = state_40037__$1;
(statearr_40044_40167[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (59))){
var inst_39925 = (state_40037[(8)]);
var inst_39916 = (state_40037[(9)]);
var inst_39968 = (state_40037[(2)]);
var inst_39969 = fluree.db.util.async.throw_err(inst_39968);
var inst_39970 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39916,inst_39925,inst_39969);
var state_40037__$1 = state_40037;
var statearr_40045_40168 = state_40037__$1;
(statearr_40045_40168[(2)] = inst_39970);

(statearr_40045_40168[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (20))){
var inst_39869 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40046_40169 = state_40037__$1;
(statearr_40046_40169[(2)] = inst_39869);

(statearr_40046_40169[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (72))){
var inst_40013 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40047_40170 = state_40037__$1;
(statearr_40047_40170[(2)] = inst_40013);

(statearr_40047_40170[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (58))){
var inst_39973 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40048_40171 = state_40037__$1;
(statearr_40048_40171[(2)] = inst_39973);

(statearr_40048_40171[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (60))){
var inst_39871 = (state_40037[(10)]);
var inst_39986 = (state_40037[(11)]);
var inst_39988 = cljs.core.sorted_map_by(inst_39871);
var inst_39989 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39988,inst_39986);
var state_40037__$1 = state_40037;
var statearr_40049_40172 = state_40037__$1;
(statearr_40049_40172[(2)] = inst_39989);

(statearr_40049_40172[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (27))){
var inst_39822 = (state_40037[(12)]);
var inst_39853 = (state_40037[(13)]);
var inst_39852 = (state_40037[(14)]);
var inst_39856 = (function (){var group_map = inst_39822;
var orderByIdx = inst_39852;
var orderDirection = inst_39853;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
})();
var state_40037__$1 = state_40037;
var statearr_40050_40173 = state_40037__$1;
(statearr_40050_40173[(2)] = inst_39856);

(statearr_40050_40173[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (1))){
var state_40037__$1 = state_40037;
var statearr_40051_40174 = state_40037__$1;
(statearr_40051_40174[(2)] = null);

(statearr_40051_40174[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (69))){
var inst_40030 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40052_40175 = state_40037__$1;
(statearr_40052_40175[(2)] = inst_40030);

(statearr_40052_40175[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (24))){
var inst_39853 = (state_40037[(13)]);
var inst_39851 = cljs.core.second(orderBy);
var inst_39852 = fluree.db.util.core.index_of(groupBy,inst_39851);
var inst_39853__$1 = cljs.core.first(orderBy);
var inst_39854 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",inst_39853__$1);
var state_40037__$1 = (function (){var statearr_40053 = state_40037;
(statearr_40053[(13)] = inst_39853__$1);

(statearr_40053[(14)] = inst_39852);

return statearr_40053;
})();
if(inst_39854){
var statearr_40054_40176 = state_40037__$1;
(statearr_40054_40176[(1)] = (27));

} else {
var statearr_40055_40177 = state_40037__$1;
(statearr_40055_40177[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (55))){
var inst_39925 = (state_40037[(8)]);
var inst_39916 = (state_40037[(9)]);
var inst_39957 = (state_40037[(2)]);
var inst_39958 = fluree.db.util.async.throw_err(inst_39957);
var inst_39959 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39916,inst_39925,inst_39958);
var state_40037__$1 = state_40037;
var statearr_40056_40178 = state_40037__$1;
(statearr_40056_40178[(2)] = inst_39959);

(statearr_40056_40178[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (39))){
var inst_39916 = (state_40037[(9)]);
var state_40037__$1 = state_40037;
var statearr_40057_40179 = state_40037__$1;
(statearr_40057_40179[(2)] = inst_39916);

(statearr_40057_40179[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (46))){
var state_40037__$1 = state_40037;
var statearr_40058_40180 = state_40037__$1;
(statearr_40058_40180[(2)] = null);

(statearr_40058_40180[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (4))){
var inst_39815 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40059_40181 = state_40037__$1;
(statearr_40059_40181[(2)] = inst_39815);

(statearr_40059_40181[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (77))){
var state_40037__$1 = state_40037;
var statearr_40060_40182 = state_40037__$1;
(statearr_40060_40182[(1)] = (79));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (54))){
var inst_39975 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40062_40183 = state_40037__$1;
(statearr_40062_40183[(2)] = inst_39975);

(statearr_40062_40183[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (15))){
var inst_39822 = (state_40037[(12)]);
var inst_39834 = (function (){var group_map = inst_39822;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
})();
var state_40037__$1 = state_40037;
var statearr_40063_40184 = state_40037__$1;
(statearr_40063_40184[(2)] = inst_39834);

(statearr_40063_40184[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (48))){
var inst_39943 = (state_40037[(15)]);
var inst_39946 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_39943,select_spec,opts);
var state_40037__$1 = state_40037;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40037__$1,(51),inst_39946);
} else {
if((state_val_40038 === (50))){
var inst_39977 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40064_40185 = state_40037__$1;
(statearr_40064_40185[(2)] = inst_39977);

(statearr_40064_40185[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (75))){
var inst_40028 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40065_40186 = state_40037__$1;
(statearr_40065_40186[(2)] = inst_40028);

(statearr_40065_40186[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (21))){
var inst_39844 = cljs.core.set(groupBy);
var inst_39845 = cljs.core.second(orderBy);
var inst_39846 = (inst_39844.cljs$core$IFn$_invoke$arity$1 ? inst_39844.cljs$core$IFn$_invoke$arity$1(inst_39845) : inst_39844.call(null,inst_39845));
var state_40037__$1 = state_40037;
var statearr_40066_40187 = state_40037__$1;
(statearr_40066_40187[(2)] = inst_39846);

(statearr_40066_40187[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (31))){
var state_40037__$1 = state_40037;
var statearr_40067_40188 = state_40037__$1;
(statearr_40067_40188[(2)] = null);

(statearr_40067_40188[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (32))){
var inst_39865 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40068_40189 = state_40037__$1;
(statearr_40068_40189[(2)] = inst_39865);

(statearr_40068_40189[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (40))){
var inst_39915 = (state_40037[(16)]);
var inst_39933 = (inst_39915 > (0));
var state_40037__$1 = state_40037;
if(cljs.core.truth_(inst_39933)){
var statearr_40069_40190 = state_40037__$1;
(statearr_40069_40190[(1)] = (42));

} else {
var statearr_40070_40191 = state_40037__$1;
(statearr_40070_40191[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (56))){
var inst_39928 = (state_40037[(17)]);
var inst_39940 = (state_40037[(18)]);
var inst_39943 = (state_40037[(15)]);
var inst_39963 = cljs.core.count(inst_39928);
var inst_39964 = (inst_39940 - limit);
var inst_39965 = (inst_39963 - inst_39964);
var inst_39966 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_39943,select_spec,inst_39965,opts);
var state_40037__$1 = state_40037;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40037__$1,(59),inst_39966);
} else {
if((state_val_40038 === (33))){
var inst_39822 = (state_40037[(12)]);
var inst_39873 = cljs.core.keys(inst_39822);
var inst_39874 = cljs.core.first(inst_39873);
var inst_39875 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_39876 = cljs.core.vals(inst_39822);
var inst_39877 = cljs.core.first(inst_39876);
var inst_39878 = [headers,vars,inst_39877];
var inst_39879 = cljs.core.PersistentHashMap.fromArrays(inst_39875,inst_39878);
var inst_39880 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_39879,select_spec,limit,opts);
var state_40037__$1 = (function (){var statearr_40071 = state_40037;
(statearr_40071[(19)] = inst_39874);

return statearr_40071;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40037__$1,(36),inst_39880);
} else {
if((state_val_40038 === (13))){
var inst_39839 = cljs.core.not(orderBy);
var state_40037__$1 = state_40037;
if(inst_39839){
var statearr_40072_40192 = state_40037__$1;
(statearr_40072_40192[(1)] = (18));

} else {
var statearr_40073_40193 = state_40037__$1;
(statearr_40073_40193[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (22))){
var inst_39842 = (state_40037[(20)]);
var state_40037__$1 = state_40037;
var statearr_40074_40194 = state_40037__$1;
(statearr_40074_40194[(2)] = inst_39842);

(statearr_40074_40194[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (36))){
var inst_39874 = (state_40037[(19)]);
var inst_39882 = (state_40037[(2)]);
var inst_39883 = fluree.db.util.async.throw_err(inst_39882);
var inst_39884 = [inst_39874];
var inst_39885 = [inst_39883];
var inst_39886 = cljs.core.PersistentHashMap.fromArrays(inst_39884,inst_39885);
var state_40037__$1 = state_40037;
var statearr_40075_40195 = state_40037__$1;
(statearr_40075_40195[(2)] = inst_39886);

(statearr_40075_40195[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (41))){
var inst_39984 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40076_40196 = state_40037__$1;
(statearr_40076_40196[(2)] = inst_39984);

(statearr_40076_40196[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (43))){
var state_40037__$1 = state_40037;
var statearr_40077_40197 = state_40037__$1;
(statearr_40077_40197[(1)] = (45));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (61))){
var inst_39986 = (state_40037[(11)]);
var state_40037__$1 = state_40037;
var statearr_40079_40198 = state_40037__$1;
(statearr_40079_40198[(2)] = inst_39986);

(statearr_40079_40198[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (29))){
var inst_39860 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40080_40199 = state_40037__$1;
(statearr_40080_40199[(2)] = inst_39860);

(statearr_40080_40199[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (44))){
var inst_39982 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40081_40200 = state_40037__$1;
(statearr_40081_40200[(2)] = inst_39982);

(statearr_40081_40200[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (6))){
var inst_39823 = (state_40037[(21)]);
var inst_39822 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var inst_39823__$1 = orderBy;
var state_40037__$1 = (function (){var statearr_40082 = state_40037;
(statearr_40082[(12)] = inst_39822);

(statearr_40082[(21)] = inst_39823__$1);

return statearr_40082;
})();
if(cljs.core.truth_(inst_39823__$1)){
var statearr_40083_40201 = state_40037__$1;
(statearr_40083_40201[(1)] = (9));

} else {
var statearr_40084_40202 = state_40037__$1;
(statearr_40084_40202[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (28))){
var inst_39822 = (state_40037[(12)]);
var inst_39853 = (state_40037[(13)]);
var inst_39852 = (state_40037[(14)]);
var inst_39858 = (function (){var group_map = inst_39822;
var orderByIdx = inst_39852;
var orderDirection = inst_39853;
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
})();
var state_40037__$1 = state_40037;
var statearr_40086_40203 = state_40037__$1;
(statearr_40086_40203[(2)] = inst_39858);

(statearr_40086_40203[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (64))){
var state_40037__$1 = state_40037;
var statearr_40087_40204 = state_40037__$1;
(statearr_40087_40204[(2)] = limit);

(statearr_40087_40204[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (51))){
var inst_39929 = (state_40037[(22)]);
var inst_39915 = (state_40037[(16)]);
var inst_39925 = (state_40037[(8)]);
var inst_39940 = (state_40037[(18)]);
var inst_39916 = (state_40037[(9)]);
var inst_39926 = (state_40037[(23)]);
var inst_39948 = (state_40037[(2)]);
var inst_39949 = fluree.db.util.async.throw_err(inst_39948);
var inst_39950 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39916,inst_39925,inst_39949);
var tmp40085 = inst_39915;
var inst_39912 = inst_39926;
var inst_39913 = inst_39929;
var inst_39914 = inst_39940;
var inst_39915__$1 = tmp40085;
var inst_39916__$1 = inst_39950;
var state_40037__$1 = (function (){var statearr_40088 = state_40037;
(statearr_40088[(16)] = inst_39915__$1);

(statearr_40088[(24)] = inst_39913);

(statearr_40088[(25)] = inst_39912);

(statearr_40088[(26)] = inst_39914);

(statearr_40088[(9)] = inst_39916__$1);

return statearr_40088;
})();
var statearr_40089_40205 = state_40037__$1;
(statearr_40089_40205[(2)] = null);

(statearr_40089_40205[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (25))){
var state_40037__$1 = state_40037;
var statearr_40090_40206 = state_40037__$1;
(statearr_40090_40206[(1)] = (30));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (34))){
var inst_39822 = (state_40037[(12)]);
var inst_39902 = cljs.core.keys(inst_39822);
var inst_39903 = cljs.core.seq(inst_39902);
var inst_39904 = cljs.core.first(inst_39903);
var inst_39905 = cljs.core.next(inst_39903);
var inst_39906 = cljs.core.vals(inst_39822);
var inst_39907 = cljs.core.seq(inst_39906);
var inst_39908 = cljs.core.first(inst_39907);
var inst_39909 = cljs.core.next(inst_39907);
var inst_39910 = offset;
var inst_39911 = cljs.core.PersistentHashMap.EMPTY;
var inst_39912 = inst_39902;
var inst_39913 = inst_39906;
var inst_39914 = (0);
var inst_39915 = inst_39910;
var inst_39916 = inst_39911;
var state_40037__$1 = (function (){var statearr_40092 = state_40037;
(statearr_40092[(27)] = inst_39909);

(statearr_40092[(28)] = inst_39905);

(statearr_40092[(16)] = inst_39915);

(statearr_40092[(24)] = inst_39913);

(statearr_40092[(25)] = inst_39912);

(statearr_40092[(29)] = inst_39908);

(statearr_40092[(26)] = inst_39914);

(statearr_40092[(30)] = inst_39904);

(statearr_40092[(9)] = inst_39916);

return statearr_40092;
})();
var statearr_40093_40207 = state_40037__$1;
(statearr_40093_40207[(2)] = null);

(statearr_40093_40207[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (17))){
var inst_39837 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40094_40208 = state_40037__$1;
(statearr_40094_40208[(2)] = inst_39837);

(statearr_40094_40208[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (3))){
var inst_40035 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40037__$1,inst_40035);
} else {
if((state_val_40038 === (12))){
var inst_39831 = cljs.core.first(orderBy);
var inst_39832 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39831,"DESC");
var state_40037__$1 = state_40037;
if(inst_39832){
var statearr_40095_40209 = state_40037__$1;
(statearr_40095_40209[(1)] = (15));

} else {
var statearr_40096_40210 = state_40037__$1;
(statearr_40096_40210[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (2))){
var _ = (function (){var statearr_40097 = state_40037;
(statearr_40097[(4)] = cljs.core.cons((5),(state_40037[(4)])));

return statearr_40097;
})();
var state_40037__$1 = state_40037;
if(cljs.core.truth_(groupBy)){
var statearr_40098_40211 = state_40037__$1;
(statearr_40098_40211[(1)] = (6));

} else {
var statearr_40099_40212 = state_40037__$1;
(statearr_40099_40212[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (66))){
var inst_40003 = (state_40037[(7)]);
var inst_40002 = (state_40037[(2)]);
var inst_40003__$1 = fluree.db.util.async.throw_err(inst_40002);
var inst_40004 = cljs.core.coll_QMARK_(inst_40003__$1);
var inst_40005 = (!(inst_40004));
var state_40037__$1 = (function (){var statearr_40100 = state_40037;
(statearr_40100[(7)] = inst_40003__$1);

return statearr_40100;
})();
if(inst_40005){
var statearr_40101_40213 = state_40037__$1;
(statearr_40101_40213[(1)] = (67));

} else {
var statearr_40102_40214 = state_40037__$1;
(statearr_40102_40214[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (23))){
var inst_39849 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
if(cljs.core.truth_(inst_39849)){
var statearr_40103_40215 = state_40037__$1;
(statearr_40103_40215[(1)] = (24));

} else {
var statearr_40104_40216 = state_40037__$1;
(statearr_40104_40216[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (47))){
var inst_39980 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40105_40217 = state_40037__$1;
(statearr_40105_40217[(2)] = inst_39980);

(statearr_40105_40217[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (35))){
var inst_39994 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40106_40218 = state_40037__$1;
(statearr_40106_40218[(2)] = inst_39994);

(statearr_40106_40218[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (76))){
var inst_40003 = (state_40037[(7)]);
var inst_40019 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_40003);
var state_40037__$1 = state_40037;
var statearr_40107_40219 = state_40037__$1;
(statearr_40107_40219[(2)] = inst_40019);

(statearr_40107_40219[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (19))){
var inst_39842 = (state_40037[(20)]);
var inst_39842__$1 = orderBy;
var state_40037__$1 = (function (){var statearr_40108 = state_40037;
(statearr_40108[(20)] = inst_39842__$1);

return statearr_40108;
})();
if(cljs.core.truth_(inst_39842__$1)){
var statearr_40109_40220 = state_40037__$1;
(statearr_40109_40220[(1)] = (21));

} else {
var statearr_40110_40221 = state_40037__$1;
(statearr_40110_40221[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (57))){
var state_40037__$1 = state_40037;
var statearr_40111_40222 = state_40037__$1;
(statearr_40111_40222[(2)] = null);

(statearr_40111_40222[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (68))){
var state_40037__$1 = state_40037;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40112_40223 = state_40037__$1;
(statearr_40112_40223[(1)] = (73));

} else {
var statearr_40113_40224 = state_40037__$1;
(statearr_40113_40224[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (11))){
var inst_39829 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
if(cljs.core.truth_(inst_39829)){
var statearr_40115_40225 = state_40037__$1;
(statearr_40115_40225[(1)] = (12));

} else {
var statearr_40116_40226 = state_40037__$1;
(statearr_40116_40226[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (9))){
var inst_39825 = cljs.core.second(orderBy);
var inst_39826 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39825,groupBy);
var state_40037__$1 = state_40037;
var statearr_40117_40227 = state_40037__$1;
(statearr_40117_40227[(2)] = inst_39826);

(statearr_40117_40227[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (5))){
var _ = (function (){var statearr_40118 = state_40037;
(statearr_40118[(4)] = cljs.core.rest((state_40037[(4)])));

return statearr_40118;
})();
var state_40037__$1 = state_40037;
var ex40114 = (state_40037__$1[(2)]);
var statearr_40119_40228 = state_40037__$1;
(statearr_40119_40228[(5)] = ex40114);


if((ex40114 instanceof Error)){
var statearr_40120_40229 = state_40037__$1;
(statearr_40120_40229[(1)] = (4));

(statearr_40120_40229[(5)] = null);

} else {
throw ex40114;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (14))){
var inst_39871 = (state_40037[(2)]);
var state_40037__$1 = (function (){var statearr_40121 = state_40037;
(statearr_40121[(10)] = inst_39871);

return statearr_40121;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40122_40230 = state_40037__$1;
(statearr_40122_40230[(1)] = (33));

} else {
var statearr_40123_40231 = state_40037__$1;
(statearr_40123_40231[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (45))){
var inst_39928 = (state_40037[(17)]);
var inst_39914 = (state_40037[(26)]);
var inst_39940 = (state_40037[(18)]);
var inst_39939 = cljs.core.count(inst_39928);
var inst_39940__$1 = (inst_39914 + inst_39939);
var inst_39941 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_39942 = [headers,vars,inst_39928];
var inst_39943 = cljs.core.PersistentHashMap.fromArrays(inst_39941,inst_39942);
var inst_39944 = (limit > inst_39940__$1);
var state_40037__$1 = (function (){var statearr_40124 = state_40037;
(statearr_40124[(18)] = inst_39940__$1);

(statearr_40124[(15)] = inst_39943);

return statearr_40124;
})();
if(cljs.core.truth_(inst_39944)){
var statearr_40125_40232 = state_40037__$1;
(statearr_40125_40232[(1)] = (48));

} else {
var statearr_40126_40233 = state_40037__$1;
(statearr_40126_40233[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (53))){
var inst_39940 = (state_40037[(18)]);
var inst_39961 = (limit < inst_39940);
var state_40037__$1 = state_40037;
if(cljs.core.truth_(inst_39961)){
var statearr_40127_40234 = state_40037__$1;
(statearr_40127_40234[(1)] = (56));

} else {
var statearr_40128_40235 = state_40037__$1;
(statearr_40128_40235[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (78))){
var inst_40026 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40129_40236 = state_40037__$1;
(statearr_40129_40236[(2)] = inst_40026);

(statearr_40129_40236[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (26))){
var inst_39867 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40130_40237 = state_40037__$1;
(statearr_40130_40237[(2)] = inst_39867);

(statearr_40130_40237[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (16))){
var state_40037__$1 = state_40037;
var statearr_40131_40238 = state_40037__$1;
(statearr_40131_40238[(2)] = fluree.db.query.fql.compare_fn);

(statearr_40131_40238[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (81))){
var inst_40024 = (state_40037[(2)]);
var state_40037__$1 = state_40037;
var statearr_40132_40239 = state_40037__$1;
(statearr_40132_40239[(2)] = inst_40024);

(statearr_40132_40239[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (79))){
var inst_40003 = (state_40037[(7)]);
var state_40037__$1 = state_40037;
var statearr_40133_40240 = state_40037__$1;
(statearr_40133_40240[(2)] = inst_40003);

(statearr_40133_40240[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (38))){
var inst_39871 = (state_40037[(10)]);
var inst_39986 = (state_40037[(2)]);
var state_40037__$1 = (function (){var statearr_40134 = state_40037;
(statearr_40134[(11)] = inst_39986);

return statearr_40134;
})();
if(cljs.core.truth_(inst_39871)){
var statearr_40135_40241 = state_40037__$1;
(statearr_40135_40241[(1)] = (60));

} else {
var statearr_40136_40242 = state_40037__$1;
(statearr_40136_40242[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (30))){
var state_40037__$1 = state_40037;
var statearr_40137_40243 = state_40037__$1;
(statearr_40137_40243[(2)] = null);

(statearr_40137_40243[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (73))){
var inst_40003 = (state_40037[(7)]);
var inst_40016 = cljs.core.first(inst_40003);
var state_40037__$1 = state_40037;
var statearr_40138_40244 = state_40037__$1;
(statearr_40138_40244[(2)] = inst_40016);

(statearr_40138_40244[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (10))){
var inst_39823 = (state_40037[(21)]);
var state_40037__$1 = state_40037;
var statearr_40139_40245 = state_40037__$1;
(statearr_40139_40245[(2)] = inst_39823);

(statearr_40139_40245[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (18))){
var state_40037__$1 = state_40037;
var statearr_40140_40246 = state_40037__$1;
(statearr_40140_40246[(2)] = null);

(statearr_40140_40246[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (52))){
var inst_39943 = (state_40037[(15)]);
var inst_39955 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_39943,select_spec,opts);
var state_40037__$1 = state_40037;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40037__$1,(55),inst_39955);
} else {
if((state_val_40038 === (67))){
var state_40037__$1 = state_40037;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_40143_40247 = state_40037__$1;
(statearr_40143_40247[(1)] = (70));

} else {
var statearr_40144_40248 = state_40037__$1;
(statearr_40144_40248[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (71))){
var inst_40003 = (state_40037[(7)]);
var state_40037__$1 = state_40037;
var statearr_40145_40249 = state_40037__$1;
(statearr_40145_40249[(2)] = inst_40003);

(statearr_40145_40249[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (42))){
var inst_39929 = (state_40037[(22)]);
var inst_39915 = (state_40037[(16)]);
var inst_39914 = (state_40037[(26)]);
var inst_39916 = (state_40037[(9)]);
var inst_39926 = (state_40037[(23)]);
var inst_39935 = (inst_39915 - (1));
var tmp40141 = inst_39914;
var tmp40142 = inst_39916;
var inst_39912 = inst_39926;
var inst_39913 = inst_39929;
var inst_39914__$1 = tmp40141;
var inst_39915__$1 = inst_39935;
var inst_39916__$1 = tmp40142;
var state_40037__$1 = (function (){var statearr_40146 = state_40037;
(statearr_40146[(16)] = inst_39915__$1);

(statearr_40146[(24)] = inst_39913);

(statearr_40146[(25)] = inst_39912);

(statearr_40146[(26)] = inst_39914__$1);

(statearr_40146[(9)] = inst_39916__$1);

return statearr_40146;
})();
var statearr_40147_40250 = state_40037__$1;
(statearr_40147_40250[(2)] = null);

(statearr_40147_40250[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (80))){
var state_40037__$1 = state_40037;
var statearr_40148_40251 = state_40037__$1;
(statearr_40148_40251[(2)] = null);

(statearr_40148_40251[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (37))){
var inst_39928 = (state_40037[(17)]);
var inst_39913 = (state_40037[(24)]);
var inst_39912 = (state_40037[(25)]);
var inst_39924 = cljs.core.seq(inst_39912);
var inst_39925 = cljs.core.first(inst_39924);
var inst_39926 = cljs.core.next(inst_39924);
var inst_39927 = cljs.core.seq(inst_39913);
var inst_39928__$1 = cljs.core.first(inst_39927);
var inst_39929 = cljs.core.next(inst_39927);
var inst_39930 = (inst_39928__$1 == null);
var state_40037__$1 = (function (){var statearr_40149 = state_40037;
(statearr_40149[(22)] = inst_39929);

(statearr_40149[(17)] = inst_39928__$1);

(statearr_40149[(8)] = inst_39925);

(statearr_40149[(23)] = inst_39926);

return statearr_40149;
})();
if(cljs.core.truth_(inst_39930)){
var statearr_40150_40252 = state_40037__$1;
(statearr_40150_40252[(1)] = (39));

} else {
var statearr_40151_40253 = state_40037__$1;
(statearr_40151_40253[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (63))){
var state_40037__$1 = state_40037;
var statearr_40152_40254 = state_40037__$1;
(statearr_40152_40254[(2)] = (1));

(statearr_40152_40254[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (8))){
var inst_40032 = (state_40037[(2)]);
var _ = (function (){var statearr_40153 = state_40037;
(statearr_40153[(4)] = cljs.core.rest((state_40037[(4)])));

return statearr_40153;
})();
var state_40037__$1 = state_40037;
var statearr_40154_40255 = state_40037__$1;
(statearr_40154_40255[(2)] = inst_40032);

(statearr_40154_40255[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40038 === (49))){
var inst_39940 = (state_40037[(18)]);
var inst_39953 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(limit,inst_39940);
var state_40037__$1 = state_40037;
if(inst_39953){
var statearr_40155_40256 = state_40037__$1;
(statearr_40155_40256[(1)] = (52));

} else {
var statearr_40156_40257 = state_40037__$1;
(statearr_40156_40257[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____0 = (function (){
var statearr_40157 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40157[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__);

(statearr_40157[(1)] = (1));

return statearr_40157;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____1 = (function (state_40037){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40037);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40158){var ex__16304__auto__ = e40158;
var statearr_40159_40258 = state_40037;
(statearr_40159_40258[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40037[(4)]))){
var statearr_40160_40259 = state_40037;
(statearr_40160_40259[(1)] = cljs.core.first((state_40037[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40260 = state_40037;
state_40037 = G__40260;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__ = function(state_40037){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____1.call(this,state_40037);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40161 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40161[(6)] = c__16375__auto__);

return statearr_40161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__40263,opts){
var map__40264 = p__40263;
var map__40264__$1 = (((((!((map__40264 == null))))?(((((map__40264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40264.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40264):map__40264);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40264__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40264__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40264__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40264__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__40261_SHARP_){
return cljs.core.contains_QMARK_(p1__40261_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__40262_SHARP_){
return cljs.core.contains_QMARK_(p1__40262_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_(orderBy)){
var G__40273 = cljs.core.first(orderBy);
var fexpr__40272 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__40272.cljs$core$IFn$_invoke$arity$1 ? fexpr__40272.cljs$core$IFn$_invoke$arity$1(G__40273) : fexpr__40272.call(null,G__40273));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4126__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4126__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__40274,p__40275){
var map__40276 = p__40274;
var map__40276__$1 = (((((!((map__40276 == null))))?(((((map__40276.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40276.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40276):map__40276);
var query_map = map__40276__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40276__$1,cljs.core.cst$kw$construct);
var map__40277 = p__40275;
var map__40277__$1 = (((((!((map__40277 == null))))?(((((map__40277.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40277.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40277):map__40277);
var where_result = map__40277__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40277__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40277__$1,cljs.core.cst$kw$tuples);
var vec__40280 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40280,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40280,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40280,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40313){
var state_val_40314 = (state_40313[(1)]);
if((state_val_40314 === (7))){
var inst_40292 = (state_40313[(7)]);
var state_40313__$1 = state_40313;
var statearr_40315_40338 = state_40313__$1;
(statearr_40315_40338[(2)] = inst_40292);

(statearr_40315_40338[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40314 === (1))){
var state_40313__$1 = state_40313;
var statearr_40316_40339 = state_40313__$1;
(statearr_40316_40339[(2)] = null);

(statearr_40316_40339[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40314 === (4))){
var inst_40283 = (state_40313[(2)]);
var state_40313__$1 = state_40313;
var statearr_40317_40340 = state_40313__$1;
(statearr_40317_40340[(2)] = inst_40283);

(statearr_40317_40340[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40314 === (13))){
var inst_40302 = (state_40313[(2)]);
var inst_40303 = fluree.db.util.async.throw_err(inst_40302);
var state_40313__$1 = state_40313;
var statearr_40318_40341 = state_40313__$1;
(statearr_40318_40341[(2)] = inst_40303);

(statearr_40318_40341[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40314 === (6))){
var inst_40292 = (state_40313[(7)]);
var inst_40291 = (state_40313[(2)]);
var inst_40292__$1 = fluree.db.util.async.throw_err(inst_40291);
var inst_40293 = fluree.db.util.core.exception_QMARK_(inst_40292__$1);
var state_40313__$1 = (function (){var statearr_40319 = state_40313;
(statearr_40319[(7)] = inst_40292__$1);

return statearr_40319;
})();
if(inst_40293){
var statearr_40320_40342 = state_40313__$1;
(statearr_40320_40342[(1)] = (7));

} else {
var statearr_40321_40343 = state_40313__$1;
(statearr_40321_40343[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40314 === (3))){
var inst_40311 = (state_40313[(2)]);
var state_40313__$1 = state_40313;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40313__$1,inst_40311);
} else {
if((state_val_40314 === (12))){
var inst_40306 = (state_40313[(2)]);
var state_40313__$1 = state_40313;
var statearr_40322_40344 = state_40313__$1;
(statearr_40322_40344[(2)] = inst_40306);

(statearr_40322_40344[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40314 === (2))){
var _ = (function (){var statearr_40323 = state_40313;
(statearr_40323[(4)] = cljs.core.cons((5),(state_40313[(4)])));

return statearr_40323;
})();
var inst_40289 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_40313__$1 = state_40313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40313__$1,(6),inst_40289);
} else {
if((state_val_40314 === (11))){
var state_40313__$1 = state_40313;
var statearr_40325_40345 = state_40313__$1;
(statearr_40325_40345[(2)] = null);

(statearr_40325_40345[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40314 === (9))){
var inst_40308 = (state_40313[(2)]);
var _ = (function (){var statearr_40326 = state_40313;
(statearr_40326[(4)] = cljs.core.rest((state_40313[(4)])));

return statearr_40326;
})();
var state_40313__$1 = state_40313;
var statearr_40327_40346 = state_40313__$1;
(statearr_40327_40346[(2)] = inst_40308);

(statearr_40327_40346[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40314 === (5))){
var _ = (function (){var statearr_40328 = state_40313;
(statearr_40328[(4)] = cljs.core.rest((state_40313[(4)])));

return statearr_40328;
})();
var state_40313__$1 = state_40313;
var ex40324 = (state_40313__$1[(2)]);
var statearr_40329_40347 = state_40313__$1;
(statearr_40329_40347[(5)] = ex40324);


if((ex40324 instanceof Error)){
var statearr_40330_40348 = state_40313__$1;
(statearr_40330_40348[(1)] = (4));

(statearr_40330_40348[(5)] = null);

} else {
throw ex40324;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40314 === (10))){
var inst_40292 = (state_40313[(7)]);
var inst_40297 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_40292);
var inst_40298 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_40292);
var inst_40299 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_40297,inst_40298,query_map,opts);
var inst_40300 = fluree.db.query.fql.process_ad_hoc_res(db,inst_40292,inst_40299,opts);
var state_40313__$1 = state_40313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40313__$1,(13),inst_40300);
} else {
if((state_val_40314 === (8))){
var state_40313__$1 = state_40313;
var statearr_40331_40349 = state_40313__$1;
(statearr_40331_40349[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____0 = (function (){
var statearr_40333 = [null,null,null,null,null,null,null,null];
(statearr_40333[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__);

(statearr_40333[(1)] = (1));

return statearr_40333;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____1 = (function (state_40313){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40313);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40334){var ex__16304__auto__ = e40334;
var statearr_40335_40350 = state_40313;
(statearr_40335_40350[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40313[(4)]))){
var statearr_40336_40351 = state_40313;
(statearr_40336_40351[(1)] = cljs.core.first((state_40313[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40352 = state_40313;
state_40313 = G__40352;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__ = function(state_40313){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____1.call(this,state_40313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40337 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40337[(6)] = c__16375__auto__);

return statearr_40337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__40353 = query_map;
var map__40353__$1 = (((((!((map__40353 == null))))?(((((map__40353.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40353.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40353):map__40353);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40353__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40353__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40353__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40353__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40353__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40353__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40353__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40353__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40353__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40353__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40353__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40353__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__40355 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__40355,cljs.core.cst$kw$limit,(1));
} else {
return G__40355;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4126__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40726){
var state_val_40727 = (state_40726[(1)]);
if((state_val_40727 === (121))){
var inst_40439 = (state_40726[(7)]);
var inst_40671 = (state_40726[(8)]);
var inst_40667 = (state_40726[(9)]);
var inst_40437 = (state_40726[(10)]);
var inst_40675 = (state_40726[(2)]);
var inst_40676 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_40439,fuel,max_fuel,inst_40437,inst_40667,inst_40671,inst_40675);
var state_40726__$1 = state_40726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40726__$1,(115),inst_40676);
} else {
if((state_val_40727 === (65))){
var inst_40427 = (state_40726[(11)]);
var inst_40439 = (state_40726[(7)]);
var inst_40516 = (state_40726[(12)]);
var inst_40437 = (state_40726[(10)]);
var inst_40530 = (state_40726[(2)]);
var inst_40531 = fluree.db.util.async.throw_err(inst_40530);
var inst_40532 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_40516,inst_40531);
var inst_40533 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_40439,fuel,max_fuel,inst_40437,inst_40532,inst_40427);
var state_40726__$1 = state_40726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40726__$1,(66),inst_40533);
} else {
if((state_val_40727 === (70))){
var inst_40426 = (state_40726[(13)]);
var state_40726__$1 = state_40726;
if(cljs.core.truth_(inst_40426)){
var statearr_40728_40920 = state_40726__$1;
(statearr_40728_40920[(1)] = (73));

} else {
var statearr_40729_40921 = state_40726__$1;
(statearr_40729_40921[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (62))){
var inst_40518 = cljs.core.PersistentHashMap.EMPTY;
var state_40726__$1 = state_40726;
var statearr_40730_40922 = state_40726__$1;
(statearr_40730_40922[(2)] = inst_40518);

(statearr_40730_40922[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (74))){
var inst_40427 = (state_40726[(11)]);
var inst_40429 = (state_40726[(14)]);
var inst_40552 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40553 = [inst_40427,inst_40429];
var inst_40554 = cljs.core.PersistentHashMap.fromArrays(inst_40552,inst_40553);
var state_40726__$1 = state_40726;
var statearr_40731_40923 = state_40726__$1;
(statearr_40731_40923[(2)] = inst_40554);

(statearr_40731_40923[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (110))){
var inst_40635 = (state_40726[(15)]);
var inst_40649 = (state_40726[(2)]);
var inst_40650 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_40635,false);
var state_40726__$1 = (function (){var statearr_40732 = state_40726;
(statearr_40732[(16)] = inst_40649);

return statearr_40732;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40726__$1,(111),inst_40650);
} else {
if((state_val_40727 === (130))){
var inst_40716 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
if(cljs.core.truth_(inst_40716)){
var statearr_40733_40924 = state_40726__$1;
(statearr_40733_40924[(1)] = (131));

} else {
var statearr_40734_40925 = state_40726__$1;
(statearr_40734_40925[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (128))){
var inst_40707 = (state_40726[(17)]);
var inst_40710 = cljs.core.coll_QMARK_(inst_40707);
var inst_40711 = fluree.db.util.core.exception_QMARK_(inst_40707);
var inst_40712 = (!(inst_40711));
var inst_40713 = ((inst_40710) && (inst_40712));
var state_40726__$1 = state_40726;
var statearr_40735_40926 = state_40726__$1;
(statearr_40735_40926[(2)] = inst_40713);

(statearr_40735_40926[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (7))){
var inst_40387 = (state_40726[(18)]);
var inst_40387__$1 = selectOne;
var state_40726__$1 = (function (){var statearr_40736 = state_40726;
(statearr_40736[(18)] = inst_40387__$1);

return statearr_40736;
})();
if(cljs.core.truth_(inst_40387__$1)){
var statearr_40737_40927 = state_40726__$1;
(statearr_40737_40927[(1)] = (9));

} else {
var statearr_40738_40928 = state_40726__$1;
(statearr_40738_40928[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (59))){
var inst_40510 = (state_40726[(19)]);
var inst_40512 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_40513 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_40510,inst_40512);
var state_40726__$1 = state_40726;
var statearr_40739_40929 = state_40726__$1;
(statearr_40739_40929[(2)] = inst_40513);

(statearr_40739_40929[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (86))){
var inst_40588 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_40726__$1 = state_40726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40726__$1,(89),inst_40588);
} else {
if((state_val_40727 === (20))){
var inst_40417 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40740_40930 = state_40726__$1;
(statearr_40740_40930[(2)] = inst_40417);

(statearr_40740_40930[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (72))){
var inst_40698 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40741_40931 = state_40726__$1;
(statearr_40741_40931[(2)] = inst_40698);

(statearr_40741_40931[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (58))){
var inst_40510 = (state_40726[(2)]);
var state_40726__$1 = (function (){var statearr_40742 = state_40726;
(statearr_40742[(19)] = inst_40510);

return statearr_40742;
})();
var statearr_40743_40932 = state_40726__$1;
(statearr_40743_40932[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (60))){
var inst_40510 = (state_40726[(19)]);
var state_40726__$1 = state_40726;
var statearr_40745_40933 = state_40726__$1;
(statearr_40745_40933[(2)] = inst_40510);

(statearr_40745_40933[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (27))){
var inst_40426 = (state_40726[(13)]);
var inst_40441 = cljs.core.vector_QMARK_(inst_40426);
var state_40726__$1 = state_40726;
if(inst_40441){
var statearr_40746_40934 = state_40726__$1;
(statearr_40746_40934[(1)] = (30));

} else {
var statearr_40747_40935 = state_40726__$1;
(statearr_40747_40935[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (1))){
var state_40726__$1 = state_40726;
var statearr_40748_40936 = state_40726__$1;
(statearr_40748_40936[(2)] = null);

(statearr_40748_40936[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (69))){
var inst_40547 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
if(cljs.core.truth_(inst_40547)){
var statearr_40749_40937 = state_40726__$1;
(statearr_40749_40937[(1)] = (70));

} else {
var statearr_40750_40938 = state_40726__$1;
(statearr_40750_40938[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (101))){
var inst_40426 = (state_40726[(13)]);
var inst_40665 = (state_40726[(2)]);
var inst_40666 = cljs.core.PersistentVector.EMPTY;
var inst_40667 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40666,inst_40665);
var state_40726__$1 = (function (){var statearr_40751 = state_40726;
(statearr_40751[(9)] = inst_40667);

return statearr_40751;
})();
if(cljs.core.truth_(inst_40426)){
var statearr_40752_40939 = state_40726__$1;
(statearr_40752_40939[(1)] = (116));

} else {
var statearr_40753_40940 = state_40726__$1;
(statearr_40753_40940[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (24))){
var inst_40428 = (state_40726[(20)]);
var inst_40430 = (state_40726[(21)]);
var inst_40434 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40430,cljs.core.cst$kw$componentFollow_QMARK_,inst_40428);
var state_40726__$1 = state_40726;
var statearr_40754_40941 = state_40726__$1;
(statearr_40754_40941[(2)] = inst_40434);

(statearr_40754_40941[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (102))){
var inst_40629 = (state_40726[(22)]);
var state_40726__$1 = state_40726;
var statearr_40755_40942 = state_40726__$1;
(statearr_40755_40942[(2)] = inst_40629);

(statearr_40755_40942[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (55))){
var inst_40700 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40756_40943 = state_40726__$1;
(statearr_40756_40943[(2)] = inst_40700);

(statearr_40756_40943[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (85))){
var inst_40582 = (state_40726[(2)]);
var inst_40583 = fluree.db.util.async.throw_err(inst_40582);
var state_40726__$1 = state_40726;
var statearr_40757_40944 = state_40726__$1;
(statearr_40757_40944[(2)] = inst_40583);

(statearr_40757_40944[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (39))){
var inst_40476 = typeof from === 'string';
var state_40726__$1 = state_40726;
if(cljs.core.truth_(inst_40476)){
var statearr_40758_40945 = state_40726__$1;
(statearr_40758_40945[(1)] = (42));

} else {
var statearr_40759_40946 = state_40726__$1;
(statearr_40759_40946[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (88))){
var inst_40694 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40760_40947 = state_40726__$1;
(statearr_40760_40947[(2)] = inst_40694);

(statearr_40760_40947[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (46))){
var inst_40495 = (state_40726[(2)]);
var inst_40496 = fluree.db.util.async.throw_err(inst_40495);
var state_40726__$1 = state_40726;
var statearr_40761_40948 = state_40726__$1;
(statearr_40761_40948[(2)] = inst_40496);

(statearr_40761_40948[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (4))){
var inst_40374 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40762_40949 = state_40726__$1;
(statearr_40762_40949[(2)] = inst_40374);

(statearr_40762_40949[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (77))){
var inst_40563 = (state_40726[(2)]);
var inst_40564 = fluree.db.util.async.throw_err(inst_40563);
var state_40726__$1 = state_40726;
var statearr_40763_40950 = state_40726__$1;
(statearr_40763_40950[(2)] = inst_40564);

(statearr_40763_40950[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (106))){
var state_40726__$1 = state_40726;
if(cljs.core.truth_(fuel)){
var statearr_40764_40951 = state_40726__$1;
(statearr_40764_40951[(1)] = (108));

} else {
var statearr_40765_40952 = state_40726__$1;
(statearr_40765_40952[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (119))){
var state_40726__$1 = state_40726;
var statearr_40766_40953 = state_40726__$1;
(statearr_40766_40953[(2)] = null);

(statearr_40766_40953[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (95))){
var state_40726__$1 = state_40726;
var statearr_40767_40954 = state_40726__$1;
(statearr_40767_40954[(2)] = null);

(statearr_40767_40954[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (54))){
var inst_40539 = typeof from === 'string';
var state_40726__$1 = state_40726;
if(cljs.core.truth_(inst_40539)){
var statearr_40768_40955 = state_40726__$1;
(statearr_40768_40955[(1)] = (67));

} else {
var statearr_40769_40956 = state_40726__$1;
(statearr_40769_40956[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (92))){
var inst_40427 = (state_40726[(11)]);
var inst_40439 = (state_40726[(7)]);
var inst_40429 = (state_40726[(14)]);
var inst_40437 = (state_40726[(10)]);
var inst_40599 = (state_40726[(2)]);
var inst_40600 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_40439,fuel,max_fuel,inst_40437,inst_40599,inst_40427,inst_40429);
var state_40726__$1 = state_40726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40726__$1,(93),inst_40600);
} else {
if((state_val_40727 === (104))){
var inst_40663 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40770_40957 = state_40726__$1;
(statearr_40770_40957[(2)] = inst_40663);

(statearr_40770_40957[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (15))){
var inst_40404 = (state_40726[(23)]);
var inst_40409 = inst_40404.cljs$lang$protocol_mask$partition0$;
var inst_40410 = (inst_40409 & (64));
var inst_40411 = inst_40404.cljs$core$ISeq$;
var inst_40412 = (cljs.core.PROTOCOL_SENTINEL === inst_40411);
var inst_40413 = ((inst_40410) || (inst_40412));
var state_40726__$1 = state_40726;
if(cljs.core.truth_(inst_40413)){
var statearr_40771_40958 = state_40726__$1;
(statearr_40771_40958[(1)] = (18));

} else {
var statearr_40772_40959 = state_40726__$1;
(statearr_40772_40959[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (48))){
var inst_40427 = (state_40726[(11)]);
var state_40726__$1 = state_40726;
var statearr_40773_40960 = state_40726__$1;
(statearr_40773_40960[(2)] = inst_40427);

(statearr_40773_40960[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (50))){
var state_40726__$1 = state_40726;
var statearr_40774_40961 = state_40726__$1;
(statearr_40774_40961[(2)] = null);

(statearr_40774_40961[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (116))){
var state_40726__$1 = state_40726;
var statearr_40775_40962 = state_40726__$1;
(statearr_40775_40962[(2)] = null);

(statearr_40775_40962[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (75))){
var inst_40556 = (state_40726[(2)]);
var inst_40557 = fluree.db.query.range._block_or_tx_collection(db,inst_40556);
var state_40726__$1 = state_40726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40726__$1,(76),inst_40557);
} else {
if((state_val_40727 === (99))){
var inst_40692 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40776_40963 = state_40726__$1;
(statearr_40776_40963[(2)] = inst_40692);

(statearr_40776_40963[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (21))){
var inst_40404 = (state_40726[(23)]);
var inst_40422 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_40404);
var state_40726__$1 = state_40726;
var statearr_40777_40964 = state_40726__$1;
(statearr_40777_40964[(2)] = inst_40422);

(statearr_40777_40964[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (31))){
var inst_40426 = (state_40726[(13)]);
var inst_40449 = typeof inst_40426 === 'string';
var state_40726__$1 = state_40726;
if(cljs.core.truth_(inst_40449)){
var statearr_40778_40965 = state_40726__$1;
(statearr_40778_40965[(1)] = (33));

} else {
var statearr_40779_40966 = state_40726__$1;
(statearr_40779_40966[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (113))){
var inst_40629 = (state_40726[(22)]);
var state_40726__$1 = state_40726;
var statearr_40780_40967 = state_40726__$1;
(statearr_40780_40967[(2)] = inst_40629);

(statearr_40780_40967[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (32))){
var inst_40465 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40781_40968 = state_40726__$1;
(statearr_40781_40968[(2)] = inst_40465);

(statearr_40781_40968[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (40))){
var inst_40498 = typeof from === 'string';
var inst_40499 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_40500 = clojure.string.includes_QMARK_(inst_40499,"/");
var inst_40501 = ((inst_40498) && (inst_40500));
var state_40726__$1 = state_40726;
if(cljs.core.truth_(inst_40501)){
var statearr_40782_40969 = state_40726__$1;
(statearr_40782_40969[(1)] = (53));

} else {
var statearr_40783_40970 = state_40726__$1;
(statearr_40783_40970[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (129))){
var inst_40708 = (state_40726[(24)]);
var state_40726__$1 = state_40726;
var statearr_40784_40971 = state_40726__$1;
(statearr_40784_40971[(2)] = inst_40708);

(statearr_40784_40971[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (91))){
var inst_40591 = (state_40726[(25)]);
var inst_40595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40596 = [inst_40591];
var inst_40597 = (new cljs.core.PersistentVector(null,1,(5),inst_40595,inst_40596,null));
var state_40726__$1 = state_40726;
var statearr_40785_40972 = state_40726__$1;
(statearr_40785_40972[(2)] = inst_40597);

(statearr_40785_40972[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (117))){
var inst_40427 = (state_40726[(11)]);
var state_40726__$1 = state_40726;
var statearr_40786_40973 = state_40726__$1;
(statearr_40786_40973[(2)] = inst_40427);

(statearr_40786_40973[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (108))){
var inst_40644 = cljs.core._deref(fuel);
var inst_40645 = (inst_40644 + (1));
var inst_40646 = cljs.core._vreset_BANG_(fuel,inst_40645);
var state_40726__$1 = state_40726;
var statearr_40787_40974 = state_40726__$1;
(statearr_40787_40974[(2)] = inst_40646);

(statearr_40787_40974[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (56))){
var inst_40504 = (state_40726[(26)]);
var inst_40506 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_40507 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_40504,inst_40506);
var state_40726__$1 = state_40726;
var statearr_40788_40975 = state_40726__$1;
(statearr_40788_40975[(2)] = inst_40507);

(statearr_40788_40975[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (33))){
var inst_40426 = (state_40726[(13)]);
var inst_40451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40452 = [inst_40426,"ASC"];
var inst_40453 = (new cljs.core.PersistentVector(null,2,(5),inst_40451,inst_40452,null));
var state_40726__$1 = state_40726;
var statearr_40789_40976 = state_40726__$1;
(statearr_40789_40976[(2)] = inst_40453);

(statearr_40789_40976[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (13))){
var inst_40393 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40394 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_40395 = cljs.core.PersistentHashMap.fromArrays(inst_40393,inst_40394);
var inst_40396 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_40395);
var inst_40397 = (function(){throw inst_40396})();
var state_40726__$1 = state_40726;
var statearr_40790_40977 = state_40726__$1;
(statearr_40790_40977[(2)] = inst_40397);

(statearr_40790_40977[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (22))){
var inst_40404 = (state_40726[(23)]);
var state_40726__$1 = state_40726;
var statearr_40791_40978 = state_40726__$1;
(statearr_40791_40978[(2)] = inst_40404);

(statearr_40791_40978[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (90))){
var state_40726__$1 = state_40726;
var statearr_40792_40979 = state_40726__$1;
(statearr_40792_40979[(2)] = null);

(statearr_40792_40979[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (109))){
var state_40726__$1 = state_40726;
var statearr_40793_40980 = state_40726__$1;
(statearr_40793_40980[(2)] = null);

(statearr_40793_40980[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (36))){
var inst_40456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40457 = [null,null];
var inst_40458 = (new cljs.core.PersistentVector(null,2,(5),inst_40456,inst_40457,null));
var state_40726__$1 = state_40726;
var statearr_40794_40981 = state_40726__$1;
(statearr_40794_40981[(2)] = inst_40458);

(statearr_40794_40981[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (41))){
var inst_40472 = (state_40726[(27)]);
var inst_40702 = (state_40726[(2)]);
var state_40726__$1 = (function (){var statearr_40795 = state_40726;
(statearr_40795[(28)] = inst_40702);

return statearr_40795;
})();
if(cljs.core.truth_(inst_40472)){
var statearr_40796_40982 = state_40726__$1;
(statearr_40796_40982[(1)] = (125));

} else {
var statearr_40797_40983 = state_40726__$1;
(statearr_40797_40983[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (118))){
var inst_40426 = (state_40726[(13)]);
var inst_40671 = (state_40726[(2)]);
var state_40726__$1 = (function (){var statearr_40798 = state_40726;
(statearr_40798[(8)] = inst_40671);

return statearr_40798;
})();
if(cljs.core.truth_(inst_40426)){
var statearr_40799_40984 = state_40726__$1;
(statearr_40799_40984[(1)] = (119));

} else {
var statearr_40800_40985 = state_40726__$1;
(statearr_40800_40985[(1)] = (120));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (89))){
var inst_40591 = (state_40726[(25)]);
var inst_40590 = (state_40726[(2)]);
var inst_40591__$1 = fluree.db.util.async.throw_err(inst_40590);
var inst_40592 = (inst_40591__$1 == null);
var state_40726__$1 = (function (){var statearr_40801 = state_40726;
(statearr_40801[(25)] = inst_40591__$1);

return statearr_40801;
})();
if(cljs.core.truth_(inst_40592)){
var statearr_40802_40986 = state_40726__$1;
(statearr_40802_40986[(1)] = (90));

} else {
var statearr_40803_40987 = state_40726__$1;
(statearr_40803_40987[(1)] = (91));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (100))){
var inst_40628 = (state_40726[(29)]);
var inst_40635 = (state_40726[(15)]);
var inst_40634 = cljs.core.seq(inst_40628);
var inst_40635__$1 = cljs.core.first(inst_40634);
var inst_40636 = cljs.core.next(inst_40634);
var inst_40637 = cljs.core.not(inst_40635__$1);
var state_40726__$1 = (function (){var statearr_40804 = state_40726;
(statearr_40804[(30)] = inst_40636);

(statearr_40804[(15)] = inst_40635__$1);

return statearr_40804;
})();
if(inst_40637){
var statearr_40805_40988 = state_40726__$1;
(statearr_40805_40988[(1)] = (102));

} else {
var statearr_40806_40989 = state_40726__$1;
(statearr_40806_40989[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (131))){
var inst_40707 = (state_40726[(17)]);
var inst_40718 = cljs.core.first(inst_40707);
var state_40726__$1 = state_40726;
var statearr_40807_40990 = state_40726__$1;
(statearr_40807_40990[(2)] = inst_40718);

(statearr_40807_40990[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (122))){
var inst_40682 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_40683 = ["Invalid 'from' in query:",inst_40682].join('');
var inst_40684 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40685 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_40686 = cljs.core.PersistentHashMap.fromArrays(inst_40684,inst_40685);
var inst_40687 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40683,inst_40686);
var state_40726__$1 = state_40726;
var statearr_40808_40991 = state_40726__$1;
(statearr_40808_40991[(2)] = inst_40687);

(statearr_40808_40991[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (43))){
var state_40726__$1 = state_40726;
var statearr_40809_40992 = state_40726__$1;
(statearr_40809_40992[(2)] = null);

(statearr_40809_40992[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (61))){
var inst_40426 = (state_40726[(13)]);
var inst_40516 = (state_40726[(2)]);
var state_40726__$1 = (function (){var statearr_40810 = state_40726;
(statearr_40810[(12)] = inst_40516);

return statearr_40810;
})();
if(cljs.core.truth_(inst_40426)){
var statearr_40811_40993 = state_40726__$1;
(statearr_40811_40993[(1)] = (62));

} else {
var statearr_40812_40994 = state_40726__$1;
(statearr_40812_40994[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (29))){
var inst_40471 = (state_40726[(2)]);
var inst_40472 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40471,(0),null);
var inst_40473 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40471,(1),null);
var inst_40474 = typeof where === 'string';
var state_40726__$1 = (function (){var statearr_40813 = state_40726;
(statearr_40813[(31)] = inst_40473);

(statearr_40813[(27)] = inst_40472);

return statearr_40813;
})();
if(cljs.core.truth_(inst_40474)){
var statearr_40814_40995 = state_40726__$1;
(statearr_40814_40995[(1)] = (39));

} else {
var statearr_40815_40996 = state_40726__$1;
(statearr_40815_40996[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (44))){
var inst_40480 = (state_40726[(2)]);
var inst_40481 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_40480);
var state_40726__$1 = state_40726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40726__$1,(45),inst_40481);
} else {
if((state_val_40727 === (93))){
var inst_40602 = (state_40726[(2)]);
var inst_40603 = fluree.db.util.async.throw_err(inst_40602);
var state_40726__$1 = (function (){var statearr_40816 = state_40726;
(statearr_40816[(32)] = inst_40603);

return statearr_40816;
})();
if(cljs.core.truth_(fuel)){
var statearr_40817_40997 = state_40726__$1;
(statearr_40817_40997[(1)] = (94));

} else {
var statearr_40818_40998 = state_40726__$1;
(statearr_40818_40998[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (6))){
var inst_40384 = (state_40726[(33)]);
var state_40726__$1 = state_40726;
var statearr_40819_40999 = state_40726__$1;
(statearr_40819_40999[(2)] = inst_40384);

(statearr_40819_40999[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (111))){
var inst_40652 = (state_40726[(2)]);
var inst_40653 = fluree.db.util.async.throw_err(inst_40652);
var state_40726__$1 = state_40726;
var statearr_40820_41000 = state_40726__$1;
(statearr_40820_41000[(2)] = inst_40653);

(statearr_40820_41000[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (28))){
var inst_40467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40468 = [null,null];
var inst_40469 = (new cljs.core.PersistentVector(null,2,(5),inst_40467,inst_40468,null));
var state_40726__$1 = state_40726;
var statearr_40821_41001 = state_40726__$1;
(statearr_40821_41001[(2)] = inst_40469);

(statearr_40821_41001[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (64))){
var inst_40524 = (state_40726[(2)]);
var inst_40525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40526 = [from];
var inst_40527 = (new cljs.core.PersistentVector(null,1,(5),inst_40525,inst_40526,null));
var inst_40528 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_40527,inst_40524);
var state_40726__$1 = state_40726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40726__$1,(65),inst_40528);
} else {
if((state_val_40727 === (103))){
var inst_40635 = (state_40726[(15)]);
var inst_40640 = cljs.core.int_QMARK_(inst_40635);
var state_40726__$1 = state_40726;
if(inst_40640){
var statearr_40822_41002 = state_40726__$1;
(statearr_40822_41002[(1)] = (105));

} else {
var statearr_40823_41003 = state_40726__$1;
(statearr_40823_41003[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (51))){
var inst_40429 = (state_40726[(14)]);
var state_40726__$1 = state_40726;
var statearr_40824_41004 = state_40726__$1;
(statearr_40824_41004[(2)] = inst_40429);

(statearr_40824_41004[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (25))){
var inst_40430 = (state_40726[(21)]);
var state_40726__$1 = state_40726;
var statearr_40825_41005 = state_40726__$1;
(statearr_40825_41005[(2)] = inst_40430);

(statearr_40825_41005[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (34))){
var state_40726__$1 = state_40726;
var statearr_40826_41006 = state_40726__$1;
(statearr_40826_41006[(1)] = (36));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (125))){
var inst_40473 = (state_40726[(31)]);
var inst_40427 = (state_40726[(11)]);
var inst_40429 = (state_40726[(14)]);
var inst_40702 = (state_40726[(28)]);
var inst_40472 = (state_40726[(27)]);
var inst_40704 = fluree.db.query.fql.sort_offset_and_limit_res(inst_40472,inst_40473,inst_40429,inst_40427,inst_40702);
var state_40726__$1 = state_40726;
var statearr_40828_41007 = state_40726__$1;
(statearr_40828_41007[(2)] = inst_40704);

(statearr_40828_41007[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (17))){
var inst_40420 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
if(cljs.core.truth_(inst_40420)){
var statearr_40829_41008 = state_40726__$1;
(statearr_40829_41008[(1)] = (21));

} else {
var statearr_40830_41009 = state_40726__$1;
(statearr_40830_41009[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (3))){
var inst_40724 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40726__$1,inst_40724);
} else {
if((state_val_40727 === (12))){
var inst_40390 = (state_40726[(34)]);
var state_40726__$1 = state_40726;
var statearr_40831_41010 = state_40726__$1;
(statearr_40831_41010[(2)] = inst_40390);

(statearr_40831_41010[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (2))){
var inst_40384 = (state_40726[(33)]);
var _ = (function (){var statearr_40832 = state_40726;
(statearr_40832[(4)] = cljs.core.cons((5),(state_40726[(4)])));

return statearr_40832;
})();
var inst_40384__$1 = select;
var state_40726__$1 = (function (){var statearr_40833 = state_40726;
(statearr_40833[(33)] = inst_40384__$1);

return statearr_40833;
})();
if(cljs.core.truth_(inst_40384__$1)){
var statearr_40834_41011 = state_40726__$1;
(statearr_40834_41011[(1)] = (6));

} else {
var statearr_40835_41012 = state_40726__$1;
(statearr_40835_41012[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (66))){
var inst_40535 = (state_40726[(2)]);
var inst_40536 = fluree.db.util.async.throw_err(inst_40535);
var state_40726__$1 = state_40726;
var statearr_40836_41013 = state_40726__$1;
(statearr_40836_41013[(2)] = inst_40536);

(statearr_40836_41013[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (107))){
var inst_40655 = (state_40726[(35)]);
var inst_40655__$1 = (state_40726[(2)]);
var state_40726__$1 = (function (){var statearr_40837 = state_40726;
(statearr_40837[(35)] = inst_40655__$1);

return statearr_40837;
})();
if(cljs.core.truth_(inst_40655__$1)){
var statearr_40838_41014 = state_40726__$1;
(statearr_40838_41014[(1)] = (112));

} else {
var statearr_40839_41015 = state_40726__$1;
(statearr_40839_41015[(1)] = (113));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (23))){
var inst_40428 = (state_40726[(20)]);
var inst_40403 = (state_40726[(36)]);
var inst_40425 = (state_40726[(2)]);
var inst_40426 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40425,cljs.core.cst$kw$orderBy);
var inst_40427 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40425,cljs.core.cst$kw$limit);
var inst_40428__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40425,cljs.core.cst$kw$component);
var inst_40429 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40425,cljs.core.cst$kw$offset);
var inst_40430 = fluree.db.query.fql_parser.parse_db(db,inst_40403,opts_SINGLEQUOTE_);
var inst_40431 = (inst_40428__$1 == null);
var inst_40432 = cljs.core.not(inst_40431);
var state_40726__$1 = (function (){var statearr_40840 = state_40726;
(statearr_40840[(11)] = inst_40427);

(statearr_40840[(20)] = inst_40428__$1);

(statearr_40840[(13)] = inst_40426);

(statearr_40840[(14)] = inst_40429);

(statearr_40840[(21)] = inst_40430);

return statearr_40840;
})();
if(inst_40432){
var statearr_40841_41016 = state_40726__$1;
(statearr_40841_41016[(1)] = (24));

} else {
var statearr_40842_41017 = state_40726__$1;
(statearr_40842_41017[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (47))){
var state_40726__$1 = state_40726;
var statearr_40843_41018 = state_40726__$1;
(statearr_40843_41018[(2)] = null);

(statearr_40843_41018[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (35))){
var inst_40463 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40844_41019 = state_40726__$1;
(statearr_40844_41019[(2)] = inst_40463);

(statearr_40844_41019[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (127))){
var inst_40708 = (state_40726[(24)]);
var inst_40707 = (state_40726[(2)]);
var inst_40708__$1 = selectOne;
var state_40726__$1 = (function (){var statearr_40845 = state_40726;
(statearr_40845[(24)] = inst_40708__$1);

(statearr_40845[(17)] = inst_40707);

return statearr_40845;
})();
if(cljs.core.truth_(inst_40708__$1)){
var statearr_40846_41020 = state_40726__$1;
(statearr_40846_41020[(1)] = (128));

} else {
var statearr_40847_41021 = state_40726__$1;
(statearr_40847_41021[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (82))){
var inst_40427 = (state_40726[(11)]);
var inst_40429 = (state_40726[(14)]);
var inst_40571 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40572 = [inst_40427,inst_40429];
var inst_40573 = cljs.core.PersistentHashMap.fromArrays(inst_40571,inst_40572);
var state_40726__$1 = state_40726;
var statearr_40848_41022 = state_40726__$1;
(statearr_40848_41022[(2)] = inst_40573);

(statearr_40848_41022[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (76))){
var inst_40439 = (state_40726[(7)]);
var inst_40437 = (state_40726[(10)]);
var inst_40559 = (state_40726[(2)]);
var inst_40560 = fluree.db.util.async.throw_err(inst_40559);
var inst_40561 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_40439,fuel,max_fuel,inst_40437,inst_40560);
var state_40726__$1 = state_40726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40726__$1,(77),inst_40561);
} else {
if((state_val_40727 === (97))){
var inst_40623 = from;
var inst_40624 = cljs.core.seq(inst_40623);
var inst_40625 = cljs.core.first(inst_40624);
var inst_40626 = cljs.core.next(inst_40624);
var inst_40627 = cljs.core.PersistentVector.EMPTY;
var inst_40628 = inst_40623;
var inst_40629 = inst_40627;
var state_40726__$1 = (function (){var statearr_40849 = state_40726;
(statearr_40849[(22)] = inst_40629);

(statearr_40849[(29)] = inst_40628);

(statearr_40849[(37)] = inst_40625);

(statearr_40849[(38)] = inst_40626);

return statearr_40849;
})();
var statearr_40850_41023 = state_40726__$1;
(statearr_40850_41023[(2)] = null);

(statearr_40850_41023[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (19))){
var state_40726__$1 = state_40726;
var statearr_40851_41024 = state_40726__$1;
(statearr_40851_41024[(2)] = false);

(statearr_40851_41024[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (57))){
var inst_40504 = (state_40726[(26)]);
var state_40726__$1 = state_40726;
var statearr_40852_41025 = state_40726__$1;
(statearr_40852_41025[(2)] = inst_40504);

(statearr_40852_41025[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (68))){
var state_40726__$1 = state_40726;
var statearr_40853_41026 = state_40726__$1;
(statearr_40853_41026[(2)] = false);

(statearr_40853_41026[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (11))){
var inst_40401 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40854_41027 = state_40726__$1;
(statearr_40854_41027[(2)] = inst_40401);

(statearr_40854_41027[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (115))){
var inst_40678 = (state_40726[(2)]);
var inst_40679 = fluree.db.util.async.throw_err(inst_40678);
var state_40726__$1 = state_40726;
var statearr_40856_41028 = state_40726__$1;
(statearr_40856_41028[(2)] = inst_40679);

(statearr_40856_41028[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (9))){
var inst_40387 = (state_40726[(18)]);
var state_40726__$1 = state_40726;
var statearr_40857_41029 = state_40726__$1;
(statearr_40857_41029[(2)] = inst_40387);

(statearr_40857_41029[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (5))){
var _ = (function (){var statearr_40858 = state_40726;
(statearr_40858[(4)] = cljs.core.rest((state_40726[(4)])));

return statearr_40858;
})();
var state_40726__$1 = state_40726;
var ex40855 = (state_40726__$1[(2)]);
var statearr_40859_41030 = state_40726__$1;
(statearr_40859_41030[(5)] = ex40855);


if((ex40855 instanceof Error)){
var statearr_40860_41031 = state_40726__$1;
(statearr_40860_41031[(1)] = (4));

(statearr_40860_41031[(5)] = null);

} else {
throw ex40855;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (112))){
var inst_40629 = (state_40726[(22)]);
var inst_40655 = (state_40726[(35)]);
var inst_40657 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40629,inst_40655);
var state_40726__$1 = state_40726;
var statearr_40861_41032 = state_40726__$1;
(statearr_40861_41032[(2)] = inst_40657);

(statearr_40861_41032[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (83))){
var inst_40575 = (state_40726[(2)]);
var inst_40576 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_40575);
var state_40726__$1 = state_40726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40726__$1,(84),inst_40576);
} else {
if((state_val_40727 === (14))){
var inst_40399 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40862_41033 = state_40726__$1;
(statearr_40862_41033[(2)] = inst_40399);

(statearr_40862_41033[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (45))){
var inst_40426 = (state_40726[(13)]);
var inst_40483 = (state_40726[(2)]);
var inst_40484 = fluree.db.util.async.throw_err(inst_40483);
var state_40726__$1 = (function (){var statearr_40863 = state_40726;
(statearr_40863[(39)] = inst_40484);

return statearr_40863;
})();
if(cljs.core.truth_(inst_40426)){
var statearr_40864_41034 = state_40726__$1;
(statearr_40864_41034[(1)] = (47));

} else {
var statearr_40865_41035 = state_40726__$1;
(statearr_40865_41035[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (53))){
var inst_40504 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_40726__$1 = (function (){var statearr_40866 = state_40726;
(statearr_40866[(26)] = inst_40504);

return statearr_40866;
})();
if(cljs.core.truth_(fuel)){
var statearr_40867_41036 = state_40726__$1;
(statearr_40867_41036[(1)] = (56));

} else {
var statearr_40868_41037 = state_40726__$1;
(statearr_40868_41037[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (78))){
var inst_40426 = (state_40726[(13)]);
var state_40726__$1 = state_40726;
if(cljs.core.truth_(inst_40426)){
var statearr_40869_41038 = state_40726__$1;
(statearr_40869_41038[(1)] = (81));

} else {
var statearr_40870_41039 = state_40726__$1;
(statearr_40870_41039[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (132))){
var inst_40707 = (state_40726[(17)]);
var state_40726__$1 = state_40726;
var statearr_40871_41040 = state_40726__$1;
(statearr_40871_41040[(2)] = inst_40707);

(statearr_40871_41040[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (26))){
var inst_40426 = (state_40726[(13)]);
var inst_40437 = (state_40726[(2)]);
var inst_40438 = cljs.core.PersistentHashMap.EMPTY;
var inst_40439 = cljs.core.volatile_BANG_(inst_40438);
var state_40726__$1 = (function (){var statearr_40872 = state_40726;
(statearr_40872[(7)] = inst_40439);

(statearr_40872[(10)] = inst_40437);

return statearr_40872;
})();
if(cljs.core.truth_(inst_40426)){
var statearr_40873_41041 = state_40726__$1;
(statearr_40873_41041[(1)] = (27));

} else {
var statearr_40874_41042 = state_40726__$1;
(statearr_40874_41042[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (123))){
var state_40726__$1 = state_40726;
var statearr_40875_41043 = state_40726__$1;
(statearr_40875_41043[(2)] = null);

(statearr_40875_41043[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (16))){
var state_40726__$1 = state_40726;
var statearr_40876_41044 = state_40726__$1;
(statearr_40876_41044[(2)] = false);

(statearr_40876_41044[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (133))){
var inst_40721 = (state_40726[(2)]);
var _ = (function (){var statearr_40877 = state_40726;
(statearr_40877[(4)] = cljs.core.rest((state_40726[(4)])));

return statearr_40877;
})();
var state_40726__$1 = state_40726;
var statearr_40878_41045 = state_40726__$1;
(statearr_40878_41045[(2)] = inst_40721);

(statearr_40878_41045[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (81))){
var inst_40569 = cljs.core.PersistentHashMap.EMPTY;
var state_40726__$1 = state_40726;
var statearr_40879_41046 = state_40726__$1;
(statearr_40879_41046[(2)] = inst_40569);

(statearr_40879_41046[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (120))){
var inst_40429 = (state_40726[(14)]);
var state_40726__$1 = state_40726;
var statearr_40880_41047 = state_40726__$1;
(statearr_40880_41047[(2)] = inst_40429);

(statearr_40880_41047[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (79))){
var inst_40585 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_40726__$1 = state_40726;
if(inst_40585){
var statearr_40881_41048 = state_40726__$1;
(statearr_40881_41048[(1)] = (86));

} else {
var statearr_40882_41049 = state_40726__$1;
(statearr_40882_41049[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (38))){
var inst_40461 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40883_41050 = state_40726__$1;
(statearr_40883_41050[(2)] = inst_40461);

(statearr_40883_41050[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (126))){
var inst_40702 = (state_40726[(28)]);
var state_40726__$1 = state_40726;
var statearr_40884_41051 = state_40726__$1;
(statearr_40884_41051[(2)] = inst_40702);

(statearr_40884_41051[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (98))){
var state_40726__$1 = state_40726;
var statearr_40885_41052 = state_40726__$1;
(statearr_40885_41052[(1)] = (122));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (124))){
var inst_40690 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40887_41053 = state_40726__$1;
(statearr_40887_41053[(2)] = inst_40690);

(statearr_40887_41053[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (87))){
var inst_40612 = cljs.core.sequential_QMARK_(from);
var inst_40613 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_40614 = ((inst_40612) && (inst_40613));
var state_40726__$1 = state_40726;
if(cljs.core.truth_(inst_40614)){
var statearr_40888_41054 = state_40726__$1;
(statearr_40888_41054[(1)] = (97));

} else {
var statearr_40889_41055 = state_40726__$1;
(statearr_40889_41055[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (30))){
var inst_40426 = (state_40726[(13)]);
var inst_40443 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40444 = cljs.core.second(inst_40426);
var inst_40445 = cljs.core.first(inst_40426);
var inst_40446 = [inst_40444,inst_40445];
var inst_40447 = (new cljs.core.PersistentVector(null,2,(5),inst_40443,inst_40446,null));
var state_40726__$1 = state_40726;
var statearr_40890_41056 = state_40726__$1;
(statearr_40890_41056[(2)] = inst_40447);

(statearr_40890_41056[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (73))){
var inst_40550 = cljs.core.PersistentHashMap.EMPTY;
var state_40726__$1 = state_40726;
var statearr_40891_41057 = state_40726__$1;
(statearr_40891_41057[(2)] = inst_40550);

(statearr_40891_41057[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (96))){
var inst_40603 = (state_40726[(32)]);
var inst_40610 = (state_40726[(2)]);
var state_40726__$1 = (function (){var statearr_40892 = state_40726;
(statearr_40892[(40)] = inst_40610);

return statearr_40892;
})();
var statearr_40893_41058 = state_40726__$1;
(statearr_40893_41058[(2)] = inst_40603);

(statearr_40893_41058[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (10))){
var inst_40390 = (state_40726[(34)]);
var inst_40390__$1 = selectDistinct;
var state_40726__$1 = (function (){var statearr_40894 = state_40726;
(statearr_40894[(34)] = inst_40390__$1);

return statearr_40894;
})();
if(cljs.core.truth_(inst_40390__$1)){
var statearr_40895_41059 = state_40726__$1;
(statearr_40895_41059[(1)] = (12));

} else {
var statearr_40896_41060 = state_40726__$1;
(statearr_40896_41060[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (18))){
var state_40726__$1 = state_40726;
var statearr_40897_41061 = state_40726__$1;
(statearr_40897_41061[(2)] = true);

(statearr_40897_41061[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (105))){
var inst_40635 = (state_40726[(15)]);
var state_40726__$1 = state_40726;
var statearr_40898_41062 = state_40726__$1;
(statearr_40898_41062[(2)] = inst_40635);

(statearr_40898_41062[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (52))){
var inst_40439 = (state_40726[(7)]);
var inst_40488 = (state_40726[(41)]);
var inst_40484 = (state_40726[(39)]);
var inst_40437 = (state_40726[(10)]);
var inst_40492 = (state_40726[(2)]);
var inst_40493 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_40439,fuel,max_fuel,inst_40437,inst_40484,inst_40488,inst_40492);
var state_40726__$1 = state_40726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40726__$1,(46),inst_40493);
} else {
if((state_val_40727 === (114))){
var inst_40636 = (state_40726[(30)]);
var inst_40660 = (state_40726[(2)]);
var inst_40628 = inst_40636;
var inst_40629 = inst_40660;
var state_40726__$1 = (function (){var statearr_40899 = state_40726;
(statearr_40899[(22)] = inst_40629);

(statearr_40899[(29)] = inst_40628);

return statearr_40899;
})();
var statearr_40900_41063 = state_40726__$1;
(statearr_40900_41063[(2)] = null);

(statearr_40900_41063[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (67))){
var inst_40541 = ["_tx",null,"_block",null];
var inst_40542 = (new cljs.core.PersistentArrayMap(null,2,inst_40541,null));
var inst_40543 = (new cljs.core.PersistentHashSet(null,inst_40542,null));
var inst_40544 = (inst_40543.cljs$core$IFn$_invoke$arity$1 ? inst_40543.cljs$core$IFn$_invoke$arity$1(from) : inst_40543.call(null,from));
var state_40726__$1 = state_40726;
var statearr_40901_41064 = state_40726__$1;
(statearr_40901_41064[(2)] = inst_40544);

(statearr_40901_41064[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (71))){
var inst_40566 = typeof from === 'string';
var state_40726__$1 = state_40726;
if(cljs.core.truth_(inst_40566)){
var statearr_40902_41065 = state_40726__$1;
(statearr_40902_41065[(1)] = (78));

} else {
var statearr_40903_41066 = state_40726__$1;
(statearr_40903_41066[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (42))){
var state_40726__$1 = state_40726;
var statearr_40904_41067 = state_40726__$1;
(statearr_40904_41067[(2)] = from);

(statearr_40904_41067[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (80))){
var inst_40696 = (state_40726[(2)]);
var state_40726__$1 = state_40726;
var statearr_40905_41068 = state_40726__$1;
(statearr_40905_41068[(2)] = inst_40696);

(statearr_40905_41068[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (37))){
var state_40726__$1 = state_40726;
var statearr_40906_41069 = state_40726__$1;
(statearr_40906_41069[(2)] = null);

(statearr_40906_41069[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (63))){
var inst_40427 = (state_40726[(11)]);
var inst_40429 = (state_40726[(14)]);
var inst_40520 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40521 = [inst_40427,inst_40429];
var inst_40522 = cljs.core.PersistentHashMap.fromArrays(inst_40520,inst_40521);
var state_40726__$1 = state_40726;
var statearr_40907_41070 = state_40726__$1;
(statearr_40907_41070[(2)] = inst_40522);

(statearr_40907_41070[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (94))){
var inst_40605 = cljs.core._deref(fuel);
var inst_40606 = (inst_40605 + (1));
var inst_40607 = cljs.core._vreset_BANG_(fuel,inst_40606);
var state_40726__$1 = state_40726;
var statearr_40908_41071 = state_40726__$1;
(statearr_40908_41071[(2)] = inst_40607);

(statearr_40908_41071[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (8))){
var inst_40404 = (state_40726[(23)]);
var inst_40403 = (state_40726[(2)]);
var inst_40404__$1 = opts_SINGLEQUOTE_;
var inst_40406 = (inst_40404__$1 == null);
var inst_40407 = cljs.core.not(inst_40406);
var state_40726__$1 = (function (){var statearr_40909 = state_40726;
(statearr_40909[(23)] = inst_40404__$1);

(statearr_40909[(36)] = inst_40403);

return statearr_40909;
})();
if(inst_40407){
var statearr_40910_41072 = state_40726__$1;
(statearr_40910_41072[(1)] = (15));

} else {
var statearr_40911_41073 = state_40726__$1;
(statearr_40911_41073[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (49))){
var inst_40426 = (state_40726[(13)]);
var inst_40488 = (state_40726[(2)]);
var state_40726__$1 = (function (){var statearr_40912 = state_40726;
(statearr_40912[(41)] = inst_40488);

return statearr_40912;
})();
if(cljs.core.truth_(inst_40426)){
var statearr_40913_41074 = state_40726__$1;
(statearr_40913_41074[(1)] = (50));

} else {
var statearr_40914_41075 = state_40726__$1;
(statearr_40914_41075[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40727 === (84))){
var inst_40439 = (state_40726[(7)]);
var inst_40437 = (state_40726[(10)]);
var inst_40578 = (state_40726[(2)]);
var inst_40579 = fluree.db.util.async.throw_err(inst_40578);
var inst_40580 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_40439,fuel,max_fuel,inst_40437,inst_40579);
var state_40726__$1 = state_40726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40726__$1,(85),inst_40580);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__16301__auto____0 = (function (){
var statearr_40915 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40915[(0)] = fluree$db$query$fql$query_$_state_machine__16301__auto__);

(statearr_40915[(1)] = (1));

return statearr_40915;
});
var fluree$db$query$fql$query_$_state_machine__16301__auto____1 = (function (state_40726){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40726);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40916){var ex__16304__auto__ = e40916;
var statearr_40917_41076 = state_40726;
(statearr_40917_41076[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40726[(4)]))){
var statearr_40918_41077 = state_40726;
(statearr_40918_41077[(1)] = cljs.core.first((state_40726[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41078 = state_40726;
state_40726 = G__41078;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__16301__auto__ = function(state_40726){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__16301__auto____1.call(this,state_40726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__16301__auto____0;
fluree$db$query$fql$query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__16301__auto____1;
return fluree$db$query$fql$query_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40919 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40919[(6)] = c__16375__auto__);

return statearr_40919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}

});
