// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__30882 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30882,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30882,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30882,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30882,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30882,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30882,(5),null);
var G__30885 = idx;
var G__30885__$1 = (((G__30885 instanceof cljs.core.Keyword))?G__30885.fqn:null);
switch (G__30885__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30885__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__30887 = idx;
var G__30887__$1 = (((G__30887 instanceof cljs.core.Keyword))?G__30887.fqn:null);
switch (G__30887__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30887__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__30889 = idx;
var G__30889__$1 = (((G__30889 instanceof cljs.core.Keyword))?G__30889.fqn:null);
switch (G__30889__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30889__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__30892 = arguments.length;
switch (G__30892) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__30893 = (function (){var pred__30896 = cljs.core.identical_QMARK_;
var expr__30897 = test;
if(cljs.core.truth_((pred__30896.cljs$core$IFn$_invoke$arity$2 ? pred__30896.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__30897) : pred__30896.call(null,cljs.core._EQ_,expr__30897)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__30896.cljs$core$IFn$_invoke$arity$2 ? pred__30896.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__30897) : pred__30896.call(null,cljs.core._LT_,expr__30897)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__30896.cljs$core$IFn$_invoke$arity$2 ? pred__30896.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__30897) : pred__30896.call(null,cljs.core._LT__EQ_,expr__30897)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__30896.cljs$core$IFn$_invoke$arity$2 ? pred__30896.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__30897) : pred__30896.call(null,cljs.core._GT_,expr__30897)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__30896.cljs$core$IFn$_invoke$arity$2 ? pred__30896.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__30897) : pred__30896.call(null,cljs.core._GT__EQ_,expr__30897)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__30897)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30893,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30893,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30893,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30893,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31110){
var state_val_31111 = (state_31110[(1)]);
if((state_val_31111 === (65))){
var inst_31031 = (state_31110[(7)]);
var inst_31063 = (state_31110[(8)]);
var inst_31075 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31063,inst_31031);
var state_31110__$1 = state_31110;
var statearr_31112_31228 = state_31110__$1;
(statearr_31112_31228[(2)] = inst_31075);

(statearr_31112_31228[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (70))){
var inst_31093 = (state_31110[(2)]);
var inst_31094 = cljs.core.not(inst_31093);
var state_31110__$1 = state_31110;
if(inst_31094){
var statearr_31113_31229 = state_31110__$1;
(statearr_31113_31229[(1)] = (71));

} else {
var statearr_31114_31230 = state_31110__$1;
(statearr_31114_31230[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (62))){
var inst_31045 = (state_31110[(9)]);
var inst_31084 = (state_31110[(10)]);
var inst_31084__$1 = (state_31110[(2)]);
var inst_31085 = cljs.core.count(inst_31084__$1);
var state_31110__$1 = (function (){var statearr_31115 = state_31110;
(statearr_31115[(10)] = inst_31084__$1);

(statearr_31115[(11)] = inst_31085);

return statearr_31115;
})();
if(cljs.core.truth_(inst_31045)){
var statearr_31116_31231 = state_31110__$1;
(statearr_31116_31231[(1)] = (68));

} else {
var statearr_31117_31232 = state_31110__$1;
(statearr_31117_31232[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (74))){
var inst_31084 = (state_31110[(10)]);
var inst_31085 = (state_31110[(11)]);
var inst_31099 = (state_31110[(2)]);
var inst_31100 = fluree.db.util.async.throw_err(inst_31099);
var inst_31029 = inst_31100;
var inst_31030 = inst_31085;
var inst_31031 = inst_31084;
var state_31110__$1 = (function (){var statearr_31118 = state_31110;
(statearr_31118[(12)] = inst_31030);

(statearr_31118[(7)] = inst_31031);

(statearr_31118[(13)] = inst_31029);

return statearr_31118;
})();
var statearr_31119_31233 = state_31110__$1;
(statearr_31119_31233[(2)] = null);

(statearr_31119_31233[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (7))){
var inst_30912 = (state_31110[(14)]);
var state_31110__$1 = state_31110;
var statearr_31120_31234 = state_31110__$1;
(statearr_31120_31234[(2)] = inst_30912);

(statearr_31120_31234[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (59))){
var inst_31029 = (state_31110[(13)]);
var inst_31044 = (state_31110[(2)]);
var inst_31045 = fluree.db.dbproto._rhs(inst_31029);
var state_31110__$1 = (function (){var statearr_31121 = state_31110;
(statearr_31121[(15)] = inst_31044);

(statearr_31121[(9)] = inst_31045);

return statearr_31121;
})();
var statearr_31122_31235 = state_31110__$1;
(statearr_31122_31235[(1)] = (60));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (20))){
var inst_30913 = (state_31110[(16)]);
var inst_30960 = (state_31110[(2)]);
var inst_30961 = (inst_30913 == null);
var state_31110__$1 = (function (){var statearr_31124 = state_31110;
(statearr_31124[(17)] = inst_30960);

return statearr_31124;
})();
if(cljs.core.truth_(inst_30961)){
var statearr_31125_31236 = state_31110__$1;
(statearr_31125_31236[(1)] = (22));

} else {
var statearr_31126_31237 = state_31110__$1;
(statearr_31126_31237[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (72))){
var inst_31045 = (state_31110[(9)]);
var inst_31024 = (state_31110[(18)]);
var inst_31097 = fluree.db.dbproto._lookup_leaf(inst_31024,inst_31045);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(74),inst_31097);
} else {
if((state_val_31111 === (58))){
var inst_31037 = (state_31110[(19)]);
var state_31110__$1 = state_31110;
var statearr_31127_31238 = state_31110__$1;
(statearr_31127_31238[(2)] = inst_31037);

(statearr_31127_31238[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (60))){
var inst_31044 = (state_31110[(15)]);
var inst_31030 = (state_31110[(12)]);
var inst_31031 = (state_31110[(7)]);
var inst_31003 = (state_31110[(20)]);
var inst_31047 = (inst_31003 - inst_31030);
var inst_31048 = fluree.db.flake.take(inst_31047,inst_31044);
var inst_31049 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31048,inst_31031);
var state_31110__$1 = state_31110;
var statearr_31128_31239 = state_31110__$1;
(statearr_31128_31239[(2)] = inst_31049);

(statearr_31128_31239[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (27))){
var inst_30920 = (state_31110[(21)]);
var inst_30969 = (state_31110[(2)]);
var inst_30970 = (inst_30920 == null);
var state_31110__$1 = (function (){var statearr_31129 = state_31110;
(statearr_31129[(22)] = inst_30969);

return statearr_31129;
})();
if(cljs.core.truth_(inst_30970)){
var statearr_31130_31240 = state_31110__$1;
(statearr_31130_31240[(1)] = (28));

} else {
var statearr_31131_31241 = state_31110__$1;
(statearr_31131_31241[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (1))){
var state_31110__$1 = state_31110;
var statearr_31132_31242 = state_31110__$1;
(statearr_31132_31242[(2)] = null);

(statearr_31132_31242[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (69))){
var inst_31045 = (state_31110[(9)]);
var state_31110__$1 = state_31110;
var statearr_31133_31243 = state_31110__$1;
(statearr_31133_31243[(2)] = inst_31045);

(statearr_31133_31243[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (24))){
var inst_30965 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_30965)){
var statearr_31134_31244 = state_31110__$1;
(statearr_31134_31244[(1)] = (25));

} else {
var statearr_31135_31245 = state_31110__$1;
(statearr_31135_31245[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (55))){
var inst_31105 = (state_31110[(2)]);
var _ = (function (){var statearr_31136 = state_31110;
(statearr_31136[(4)] = cljs.core.rest((state_31110[(4)])));

return statearr_31136;
})();
var state_31110__$1 = state_31110;
var statearr_31137_31246 = state_31110__$1;
(statearr_31137_31246[(2)] = inst_31105);

(statearr_31137_31246[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (39))){
var inst_30985 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31138_31247 = state_31110__$1;
(statearr_31138_31247[(2)] = inst_30985);

(statearr_31138_31247[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (46))){
var inst_30999 = (state_31110[(23)]);
var state_31110__$1 = state_31110;
var statearr_31139_31248 = state_31110__$1;
(statearr_31139_31248[(2)] = inst_30999);

(statearr_31139_31248[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (4))){
var inst_30899 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31140_31249 = state_31110__$1;
(statearr_31140_31249[(2)] = inst_30899);

(statearr_31140_31249[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (54))){
var inst_31014 = (state_31110[(24)]);
var inst_31015 = (state_31110[(25)]);
var inst_31029 = (state_31110[(13)]);
var inst_31019 = (state_31110[(26)]);
var inst_31033 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_31029,inst_31014,inst_31015,inst_31019);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(56),inst_31033);
} else {
if((state_val_31111 === (15))){
var inst_30914 = (state_31110[(27)]);
var state_31110__$1 = state_31110;
var statearr_31141_31250 = state_31110__$1;
(statearr_31141_31250[(2)] = inst_30914);

(statearr_31141_31250[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (48))){
var inst_31009 = (state_31110[(28)]);
var inst_31003 = (state_31110[(2)]);
var inst_31004 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_31005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31006 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_31007 = (new cljs.core.PersistentVector(null,3,(5),inst_31005,inst_31006,null));
var inst_31008 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_31007);
var inst_31009__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_31110__$1 = (function (){var statearr_31142 = state_31110;
(statearr_31142[(29)] = inst_31004);

(statearr_31142[(30)] = inst_31008);

(statearr_31142[(20)] = inst_31003);

(statearr_31142[(28)] = inst_31009__$1);

return statearr_31142;
})();
if(cljs.core.truth_(inst_31009__$1)){
var statearr_31143_31251 = state_31110__$1;
(statearr_31143_31251[(1)] = (49));

} else {
var statearr_31144_31252 = state_31110__$1;
(statearr_31144_31252[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (50))){
var inst_31012 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_31110__$1 = state_31110;
var statearr_31145_31253 = state_31110__$1;
(statearr_31145_31253[(2)] = inst_31012);

(statearr_31145_31253[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (21))){
var inst_30956 = (state_31110[(2)]);
var inst_30957 = fluree.db.util.async.throw_err(inst_30956);
var state_31110__$1 = state_31110;
var statearr_31146_31254 = state_31110__$1;
(statearr_31146_31254[(2)] = inst_30957);

(statearr_31146_31254[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (31))){
var state_31110__$1 = state_31110;
var statearr_31147_31255 = state_31110__$1;
(statearr_31147_31255[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_31147_31255[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (32))){
var inst_30920 = (state_31110[(21)]);
var state_31110__$1 = state_31110;
var statearr_31148_31256 = state_31110__$1;
(statearr_31148_31256[(2)] = inst_30920);

(statearr_31148_31256[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (40))){
var inst_30924 = (state_31110[(31)]);
var state_31110__$1 = state_31110;
var statearr_31149_31257 = state_31110__$1;
(statearr_31149_31257[(2)] = inst_30924);

(statearr_31149_31257[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (56))){
var inst_30997 = (state_31110[(32)]);
var inst_31036 = (state_31110[(33)]);
var inst_30998 = (state_31110[(34)]);
var inst_31035 = (state_31110[(2)]);
var inst_31036__$1 = fluree.db.util.async.throw_err(inst_31035);
var inst_31037 = fluree.db.flake.subrange(inst_31036__$1,start_test,inst_30997,end_test,inst_30998);
var inst_31038 = fluree.db.query.range.value_with_nil_pred(idx,inst_30997,inst_30998);
var state_31110__$1 = (function (){var statearr_31150 = state_31110;
(statearr_31150[(33)] = inst_31036__$1);

(statearr_31150[(19)] = inst_31037);

return statearr_31150;
})();
if(inst_31038){
var statearr_31151_31258 = state_31110__$1;
(statearr_31151_31258[(1)] = (57));

} else {
var statearr_31152_31259 = state_31110__$1;
(statearr_31152_31259[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (33))){
var inst_30917 = (state_31110[(35)]);
var inst_30978 = (state_31110[(2)]);
var state_31110__$1 = (function (){var statearr_31153 = state_31110;
(statearr_31153[(36)] = inst_30978);

return statearr_31153;
})();
if(cljs.core.truth_(inst_30917)){
var statearr_31154_31260 = state_31110__$1;
(statearr_31154_31260[(1)] = (34));

} else {
var statearr_31155_31261 = state_31110__$1;
(statearr_31155_31261[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (13))){
var inst_30938 = (state_31110[(2)]);
var inst_30939 = fluree.db.util.async.throw_err(inst_30938);
var state_31110__$1 = state_31110;
var statearr_31156_31262 = state_31110__$1;
(statearr_31156_31262[(2)] = inst_30939);

(statearr_31156_31262[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (22))){
var inst_30951 = (state_31110[(37)]);
var state_31110__$1 = state_31110;
var statearr_31157_31263 = state_31110__$1;
(statearr_31157_31263[(2)] = inst_30951);

(statearr_31157_31263[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (36))){
var inst_30924 = (state_31110[(31)]);
var inst_30987 = (state_31110[(2)]);
var state_31110__$1 = (function (){var statearr_31158 = state_31110;
(statearr_31158[(38)] = inst_30987);

return statearr_31158;
})();
if(cljs.core.truth_(inst_30924)){
var statearr_31159_31264 = state_31110__$1;
(statearr_31159_31264[(1)] = (40));

} else {
var statearr_31160_31265 = state_31110__$1;
(statearr_31160_31265[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (41))){
var inst_30990 = (cljs.core._LT__EQ_ === end_test);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_30990)){
var statearr_31161_31266 = state_31110__$1;
(statearr_31161_31266[(1)] = (43));

} else {
var statearr_31162_31267 = state_31110__$1;
(statearr_31162_31267[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (43))){
var state_31110__$1 = state_31110;
var statearr_31163_31268 = state_31110__$1;
(statearr_31163_31268[(2)] = (2147483647));

(statearr_31163_31268[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (61))){
var inst_31044 = (state_31110[(15)]);
var inst_31030 = (state_31110[(12)]);
var inst_31058 = cljs.core.seq(inst_31044);
var inst_31059 = cljs.core.first(inst_31058);
var inst_31060 = cljs.core.next(inst_31058);
var inst_31061 = inst_31044;
var inst_31062 = inst_31030;
var inst_31063 = inst_31044;
var state_31110__$1 = (function (){var statearr_31164 = state_31110;
(statearr_31164[(39)] = inst_31060);

(statearr_31164[(40)] = inst_31061);

(statearr_31164[(41)] = inst_31059);

(statearr_31164[(42)] = inst_31062);

(statearr_31164[(8)] = inst_31063);

return statearr_31164;
})();
var statearr_31165_31269 = state_31110__$1;
(statearr_31165_31269[(2)] = null);

(statearr_31165_31269[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (29))){
var state_31110__$1 = state_31110;
var statearr_31166_31270 = state_31110__$1;
(statearr_31166_31270[(2)] = false);

(statearr_31166_31270[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (44))){
var state_31110__$1 = state_31110;
var statearr_31167_31271 = state_31110__$1;
(statearr_31167_31271[(2)] = fluree.db.util.core.min_integer);

(statearr_31167_31271[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (6))){
var inst_30912 = (state_31110[(14)]);
var inst_30927 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30912);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(9),inst_30927);
} else {
if((state_val_31111 === (28))){
var inst_30960 = (state_31110[(17)]);
var state_31110__$1 = state_31110;
var statearr_31168_31272 = state_31110__$1;
(statearr_31168_31272[(2)] = inst_30960);

(statearr_31168_31272[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (64))){
var inst_31082 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31169_31273 = state_31110__$1;
(statearr_31169_31273[(2)] = inst_31082);

(statearr_31169_31273[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (51))){
var inst_31014 = (state_31110[(2)]);
var inst_31015 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_31016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31017 = [cljs.core.cst$kw$novelty,idx];
var inst_31018 = (new cljs.core.PersistentVector(null,2,(5),inst_31016,inst_31017,null));
var inst_31019 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_31018);
var inst_31020 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_31021 = fluree.db.dbproto._resolve(inst_31020);
var state_31110__$1 = (function (){var statearr_31170 = state_31110;
(statearr_31170[(24)] = inst_31014);

(statearr_31170[(25)] = inst_31015);

(statearr_31170[(26)] = inst_31019);

return statearr_31170;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(52),inst_31021);
} else {
if((state_val_31111 === (25))){
var state_31110__$1 = state_31110;
var statearr_31171_31274 = state_31110__$1;
(statearr_31171_31274[(2)] = (-1));

(statearr_31171_31274[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (34))){
var inst_30917 = (state_31110[(35)]);
var state_31110__$1 = state_31110;
var statearr_31172_31275 = state_31110__$1;
(statearr_31172_31275[(2)] = inst_30917);

(statearr_31172_31275[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (17))){
var inst_30947 = (state_31110[(2)]);
var inst_30948 = fluree.db.util.async.throw_err(inst_30947);
var state_31110__$1 = state_31110;
var statearr_31173_31276 = state_31110__$1;
(statearr_31173_31276[(2)] = inst_30948);

(statearr_31173_31276[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (3))){
var inst_31108 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31110__$1,inst_31108);
} else {
if((state_val_31111 === (12))){
var inst_30914 = (state_31110[(27)]);
var inst_30942 = (state_31110[(2)]);
var inst_30943 = fluree.db.util.core.pred_ident_QMARK_(inst_30914);
var state_31110__$1 = (function (){var statearr_31175 = state_31110;
(statearr_31175[(43)] = inst_30942);

return statearr_31175;
})();
if(inst_30943){
var statearr_31176_31277 = state_31110__$1;
(statearr_31176_31277[(1)] = (14));

} else {
var statearr_31177_31278 = state_31110__$1;
(statearr_31177_31278[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (2))){
var inst_30911 = (state_31110[(44)]);
var inst_30912 = (state_31110[(14)]);
var inst_30918 = (state_31110[(45)]);
var _ = (function (){var statearr_31178 = state_31110;
(statearr_31178[(4)] = cljs.core.cons((5),(state_31110[(4)])));

return statearr_31178;
})();
var inst_30911__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_30912__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30911__$1,(0),null);
var inst_30913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30911__$1,(1),null);
var inst_30914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30911__$1,(2),null);
var inst_30915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30911__$1,(3),null);
var inst_30916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30911__$1,(4),null);
var inst_30917 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30911__$1,(5),null);
var inst_30918__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_30919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30918__$1,(0),null);
var inst_30920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30918__$1,(1),null);
var inst_30921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30918__$1,(2),null);
var inst_30922 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30918__$1,(3),null);
var inst_30923 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30918__$1,(4),null);
var inst_30924 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30918__$1,(5),null);
var inst_30925 = fluree.db.util.core.pred_ident_QMARK_(inst_30912__$1);
var state_31110__$1 = (function (){var statearr_31179 = state_31110;
(statearr_31179[(46)] = inst_30915);

(statearr_31179[(27)] = inst_30914);

(statearr_31179[(21)] = inst_30920);

(statearr_31179[(47)] = inst_30921);

(statearr_31179[(48)] = inst_30922);

(statearr_31179[(44)] = inst_30911__$1);

(statearr_31179[(31)] = inst_30924);

(statearr_31179[(49)] = inst_30919);

(statearr_31179[(14)] = inst_30912__$1);

(statearr_31179[(45)] = inst_30918__$1);

(statearr_31179[(16)] = inst_30913);

(statearr_31179[(35)] = inst_30917);

(statearr_31179[(50)] = inst_30923);

(statearr_31179[(51)] = inst_30916);

return statearr_31179;
})();
if(inst_30925){
var statearr_31180_31279 = state_31110__$1;
(statearr_31180_31279[(1)] = (6));

} else {
var statearr_31181_31280 = state_31110__$1;
(statearr_31181_31280[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (66))){
var inst_31062 = (state_31110[(42)]);
var inst_31070 = (state_31110[(52)]);
var inst_31063 = (state_31110[(8)]);
var inst_31077 = (inst_31062 + (1));
var tmp31174 = inst_31063;
var inst_31061 = inst_31070;
var inst_31062__$1 = inst_31077;
var inst_31063__$1 = tmp31174;
var state_31110__$1 = (function (){var statearr_31182 = state_31110;
(statearr_31182[(40)] = inst_31061);

(statearr_31182[(42)] = inst_31062__$1);

(statearr_31182[(8)] = inst_31063__$1);

return statearr_31182;
})();
var statearr_31183_31281 = state_31110__$1;
(statearr_31183_31281[(2)] = null);

(statearr_31183_31281[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (23))){
var state_31110__$1 = state_31110;
var statearr_31184_31282 = state_31110__$1;
(statearr_31184_31282[(2)] = false);

(statearr_31184_31282[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (47))){
var state_31110__$1 = state_31110;
var statearr_31185_31283 = state_31110__$1;
(statearr_31185_31283[(2)] = fluree.db.util.core.max_long);

(statearr_31185_31283[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (35))){
var inst_30981 = (cljs.core._GT__EQ_ === start_test);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_30981)){
var statearr_31186_31284 = state_31110__$1;
(statearr_31186_31284[(1)] = (37));

} else {
var statearr_31187_31285 = state_31110__$1;
(statearr_31187_31285[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (19))){
var inst_30921 = (state_31110[(47)]);
var state_31110__$1 = state_31110;
var statearr_31188_31286 = state_31110__$1;
(statearr_31188_31286[(2)] = inst_30921);

(statearr_31188_31286[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (57))){
var inst_30915 = (state_31110[(46)]);
var inst_30978 = (state_31110[(36)]);
var inst_31004 = (state_31110[(29)]);
var inst_30922 = (state_31110[(48)]);
var inst_30911 = (state_31110[(44)]);
var inst_30997 = (state_31110[(32)]);
var inst_30933 = (state_31110[(53)]);
var inst_30996 = (state_31110[(54)]);
var inst_31030 = (state_31110[(12)]);
var inst_31036 = (state_31110[(33)]);
var inst_31024 = (state_31110[(18)]);
var inst_30951 = (state_31110[(37)]);
var inst_31014 = (state_31110[(24)]);
var inst_30918 = (state_31110[(45)]);
var inst_31031 = (state_31110[(7)]);
var inst_30987 = (state_31110[(38)]);
var inst_31015 = (state_31110[(25)]);
var inst_31029 = (state_31110[(13)]);
var inst_30942 = (state_31110[(43)]);
var inst_31037 = (state_31110[(19)]);
var inst_30969 = (state_31110[(22)]);
var inst_30998 = (state_31110[(34)]);
var inst_30923 = (state_31110[(50)]);
var inst_31008 = (state_31110[(30)]);
var inst_30916 = (state_31110[(51)]);
var inst_30960 = (state_31110[(17)]);
var inst_31003 = (state_31110[(20)]);
var inst_31019 = (state_31110[(26)]);
var inst_31040 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_31029;
var flakes = inst_31036;
var s1 = inst_30933;
var o2 = inst_30960;
var t1 = inst_30915;
var i = inst_31030;
var m1 = inst_30987;
var root_node = inst_31024;
var to_t = inst_31015;
var s2 = inst_30942;
var p2 = inst_30978;
var permissions = inst_31004;
var limit = inst_31003;
var start_flake = inst_30997;
var acc = inst_31031;
var vec__30905 = inst_30911;
var t2 = inst_30922;
var op1 = inst_30916;
var o1 = inst_30951;
var end_flake = inst_30998;
var base_result = inst_31037;
var p1 = inst_30969;
var vec__30908 = inst_30918;
var idx_compare = inst_31008;
var op2 = inst_30923;
var from_t = inst_31014;
var m2 = inst_30996;
var novelty = inst_31019;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_31041 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_31040,inst_31037,inst_31037);
var state_31110__$1 = state_31110;
var statearr_31189_31287 = state_31110__$1;
(statearr_31189_31287[(2)] = inst_31041);

(statearr_31189_31287[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (68))){
var inst_31045 = (state_31110[(9)]);
var inst_31085 = (state_31110[(11)]);
var inst_30998 = (state_31110[(34)]);
var inst_31008 = (state_31110[(30)]);
var inst_31003 = (state_31110[(20)]);
var inst_31087 = (inst_31008.cljs$core$IFn$_invoke$arity$2 ? inst_31008.cljs$core$IFn$_invoke$arity$2(inst_31045,inst_30998) : inst_31008.call(null,inst_31045,inst_30998));
var inst_31088 = (inst_31087 < (0));
var inst_31089 = (inst_31085 < inst_31003);
var inst_31090 = ((inst_31088) && (inst_31089));
var state_31110__$1 = state_31110;
var statearr_31190_31288 = state_31110__$1;
(statearr_31190_31288[(2)] = inst_31090);

(statearr_31190_31288[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (11))){
var inst_30919 = (state_31110[(49)]);
var state_31110__$1 = state_31110;
var statearr_31192_31289 = state_31110__$1;
(statearr_31192_31289[(2)] = inst_30919);

(statearr_31192_31289[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (9))){
var inst_30929 = (state_31110[(2)]);
var inst_30930 = fluree.db.util.async.throw_err(inst_30929);
var state_31110__$1 = state_31110;
var statearr_31193_31290 = state_31110__$1;
(statearr_31193_31290[(2)] = inst_30930);

(statearr_31193_31290[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (5))){
var _ = (function (){var statearr_31194 = state_31110;
(statearr_31194[(4)] = cljs.core.rest((state_31110[(4)])));

return statearr_31194;
})();
var state_31110__$1 = state_31110;
var ex31191 = (state_31110__$1[(2)]);
var statearr_31195_31291 = state_31110__$1;
(statearr_31195_31291[(5)] = ex31191);


if((ex31191 instanceof Error)){
var statearr_31196_31292 = state_31110__$1;
(statearr_31196_31292[(1)] = (4));

(statearr_31196_31292[(5)] = null);

} else {
throw ex31191;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (14))){
var inst_30914 = (state_31110[(27)]);
var inst_30945 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30914);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(17),inst_30945);
} else {
if((state_val_31111 === (45))){
var inst_30994 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31197_31293 = state_31110__$1;
(statearr_31197_31293[(2)] = inst_30994);

(statearr_31197_31293[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (53))){
var inst_31027 = (state_31110[(2)]);
var inst_31028 = fluree.db.util.async.throw_err(inst_31027);
var inst_31029 = inst_31028;
var inst_31030 = (0);
var inst_31031 = null;
var state_31110__$1 = (function (){var statearr_31198 = state_31110;
(statearr_31198[(12)] = inst_31030);

(statearr_31198[(7)] = inst_31031);

(statearr_31198[(13)] = inst_31029);

return statearr_31198;
})();
var statearr_31199_31294 = state_31110__$1;
(statearr_31199_31294[(2)] = null);

(statearr_31199_31294[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (26))){
var inst_30913 = (state_31110[(16)]);
var state_31110__$1 = state_31110;
var statearr_31200_31295 = state_31110__$1;
(statearr_31200_31295[(2)] = inst_30913);

(statearr_31200_31295[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (16))){
var inst_30921 = (state_31110[(47)]);
var inst_30951 = (state_31110[(2)]);
var inst_30952 = fluree.db.util.core.pred_ident_QMARK_(inst_30921);
var state_31110__$1 = (function (){var statearr_31201 = state_31110;
(statearr_31201[(37)] = inst_30951);

return statearr_31201;
})();
if(inst_30952){
var statearr_31202_31296 = state_31110__$1;
(statearr_31202_31296[(1)] = (18));

} else {
var statearr_31203_31297 = state_31110__$1;
(statearr_31203_31297[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (38))){
var state_31110__$1 = state_31110;
var statearr_31204_31298 = state_31110__$1;
(statearr_31204_31298[(2)] = (2147483647));

(statearr_31204_31298[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (30))){
var inst_30974 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_30974)){
var statearr_31205_31299 = state_31110__$1;
(statearr_31205_31299[(1)] = (31));

} else {
var statearr_31206_31300 = state_31110__$1;
(statearr_31206_31300[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (73))){
var inst_31103 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31207_31301 = state_31110__$1;
(statearr_31207_31301[(2)] = inst_31103);

(statearr_31207_31301[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (10))){
var inst_30919 = (state_31110[(49)]);
var inst_30936 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30919);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(13),inst_30936);
} else {
if((state_val_31111 === (18))){
var inst_30921 = (state_31110[(47)]);
var inst_30954 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30921);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(21),inst_30954);
} else {
if((state_val_31111 === (52))){
var inst_30997 = (state_31110[(32)]);
var inst_31024 = (state_31110[(18)]);
var inst_31023 = (state_31110[(2)]);
var inst_31024__$1 = fluree.db.util.async.throw_err(inst_31023);
var inst_31025 = fluree.db.dbproto._lookup_leaf(inst_31024__$1,inst_30997);
var state_31110__$1 = (function (){var statearr_31208 = state_31110;
(statearr_31208[(18)] = inst_31024__$1);

return statearr_31208;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(53),inst_31025);
} else {
if((state_val_31111 === (67))){
var inst_31080 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31209_31302 = state_31110__$1;
(statearr_31209_31302[(2)] = inst_31080);

(statearr_31209_31302[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (71))){
var inst_31084 = (state_31110[(10)]);
var state_31110__$1 = state_31110;
var statearr_31210_31303 = state_31110__$1;
(statearr_31210_31303[(2)] = inst_31084);

(statearr_31210_31303[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (42))){
var inst_30915 = (state_31110[(46)]);
var inst_30978 = (state_31110[(36)]);
var inst_30922 = (state_31110[(48)]);
var inst_30933 = (state_31110[(53)]);
var inst_30996 = (state_31110[(54)]);
var inst_30951 = (state_31110[(37)]);
var inst_30987 = (state_31110[(38)]);
var inst_30942 = (state_31110[(43)]);
var inst_30969 = (state_31110[(22)]);
var inst_30923 = (state_31110[(50)]);
var inst_30916 = (state_31110[(51)]);
var inst_30960 = (state_31110[(17)]);
var inst_30999 = (state_31110[(23)]);
var inst_30996__$1 = (state_31110[(2)]);
var inst_30997 = fluree.db.flake.__GT_Flake(inst_30933,inst_30969,inst_30951,inst_30915,inst_30916,inst_30987);
var inst_30998 = fluree.db.flake.__GT_Flake(inst_30942,inst_30978,inst_30960,inst_30922,inst_30923,inst_30996__$1);
var inst_30999__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_31110__$1 = (function (){var statearr_31211 = state_31110;
(statearr_31211[(32)] = inst_30997);

(statearr_31211[(54)] = inst_30996__$1);

(statearr_31211[(34)] = inst_30998);

(statearr_31211[(23)] = inst_30999__$1);

return statearr_31211;
})();
if(cljs.core.truth_(inst_30999__$1)){
var statearr_31212_31304 = state_31110__$1;
(statearr_31212_31304[(1)] = (46));

} else {
var statearr_31213_31305 = state_31110__$1;
(statearr_31213_31305[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (37))){
var state_31110__$1 = state_31110;
var statearr_31214_31306 = state_31110__$1;
(statearr_31214_31306[(2)] = fluree.db.util.core.min_integer);

(statearr_31214_31306[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (63))){
var inst_31061 = (state_31110[(40)]);
var inst_31062 = (state_31110[(42)]);
var inst_31003 = (state_31110[(20)]);
var inst_31068 = cljs.core.seq(inst_31061);
var inst_31069 = cljs.core.first(inst_31068);
var inst_31070 = cljs.core.next(inst_31068);
var inst_31071 = (inst_31069 == null);
var inst_31072 = (inst_31062 > inst_31003);
var inst_31073 = ((inst_31071) || (inst_31072));
var state_31110__$1 = (function (){var statearr_31215 = state_31110;
(statearr_31215[(52)] = inst_31070);

return statearr_31215;
})();
if(cljs.core.truth_(inst_31073)){
var statearr_31216_31307 = state_31110__$1;
(statearr_31216_31307[(1)] = (65));

} else {
var statearr_31217_31308 = state_31110__$1;
(statearr_31217_31308[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (8))){
var inst_30919 = (state_31110[(49)]);
var inst_30933 = (state_31110[(2)]);
var inst_30934 = fluree.db.util.core.pred_ident_QMARK_(inst_30919);
var state_31110__$1 = (function (){var statearr_31218 = state_31110;
(statearr_31218[(53)] = inst_30933);

return statearr_31218;
})();
if(inst_30934){
var statearr_31219_31309 = state_31110__$1;
(statearr_31219_31309[(1)] = (10));

} else {
var statearr_31220_31310 = state_31110__$1;
(statearr_31220_31310[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (49))){
var inst_31009 = (state_31110[(28)]);
var state_31110__$1 = state_31110;
var statearr_31221_31311 = state_31110__$1;
(statearr_31221_31311[(2)] = inst_31009);

(statearr_31221_31311[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16301__auto__ = null;
var fluree$db$query$range$state_machine__16301__auto____0 = (function (){
var statearr_31222 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31222[(0)] = fluree$db$query$range$state_machine__16301__auto__);

(statearr_31222[(1)] = (1));

return statearr_31222;
});
var fluree$db$query$range$state_machine__16301__auto____1 = (function (state_31110){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31110);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31223){var ex__16304__auto__ = e31223;
var statearr_31224_31312 = state_31110;
(statearr_31224_31312[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31110[(4)]))){
var statearr_31225_31313 = state_31110;
(statearr_31225_31313[(1)] = cljs.core.first((state_31110[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31314 = state_31110;
state_31110 = G__31314;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16301__auto__ = function(state_31110){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16301__auto____1.call(this,state_31110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16301__auto____0;
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16301__auto____1;
return fluree$db$query$range$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31226 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31226[(6)] = c__16375__auto__);

return statearr_31226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31364){
var state_val_31365 = (state_31364[(1)]);
if((state_val_31365 === (7))){
var state_31364__$1 = state_31364;
var statearr_31366_31385 = state_31364__$1;
(statearr_31366_31385[(2)] = (0));

(statearr_31366_31385[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (1))){
var inst_31322 = subject_groups;
var inst_31323 = cljs.core.seq(inst_31322);
var inst_31324 = cljs.core.first(inst_31323);
var inst_31325 = cljs.core.next(inst_31323);
var inst_31326 = flake_start;
var inst_31327 = subject_start;
var inst_31328 = cljs.core.PersistentVector.EMPTY;
var inst_31329 = inst_31322;
var inst_31330 = inst_31326;
var inst_31331 = inst_31327;
var inst_31332 = inst_31328;
var state_31364__$1 = (function (){var statearr_31367 = state_31364;
(statearr_31367[(7)] = inst_31330);

(statearr_31367[(8)] = inst_31325);

(statearr_31367[(9)] = inst_31331);

(statearr_31367[(10)] = inst_31324);

(statearr_31367[(11)] = inst_31332);

(statearr_31367[(12)] = inst_31329);

return statearr_31367;
})();
var statearr_31368_31386 = state_31364__$1;
(statearr_31368_31386[(2)] = null);

(statearr_31368_31386[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (4))){
var inst_31330 = (state_31364[(7)]);
var inst_31331 = (state_31364[(9)]);
var inst_31332 = (state_31364[(11)]);
var inst_31345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31346 = [inst_31330,inst_31331,inst_31332];
var inst_31347 = (new cljs.core.PersistentVector(null,3,(5),inst_31345,inst_31346,null));
var state_31364__$1 = state_31364;
var statearr_31369_31387 = state_31364__$1;
(statearr_31369_31387[(2)] = inst_31347);

(statearr_31369_31387[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (6))){
var inst_31360 = (state_31364[(2)]);
var state_31364__$1 = state_31364;
var statearr_31370_31388 = state_31364__$1;
(statearr_31370_31388[(2)] = inst_31360);

(statearr_31370_31388[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (3))){
var inst_31362 = (state_31364[(2)]);
var state_31364__$1 = state_31364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31364__$1,inst_31362);
} else {
if((state_val_31365 === (2))){
var inst_31330 = (state_31364[(7)]);
var inst_31338 = (state_31364[(13)]);
var inst_31331 = (state_31364[(9)]);
var inst_31329 = (state_31364[(12)]);
var inst_31337 = cljs.core.seq(inst_31329);
var inst_31338__$1 = cljs.core.first(inst_31337);
var inst_31339 = cljs.core.next(inst_31337);
var inst_31340 = (inst_31338__$1 == null);
var inst_31341 = (inst_31330 >= flake_limit);
var inst_31342 = (inst_31331 >= subject_limit);
var inst_31343 = ((inst_31340) || (inst_31341) || (inst_31342));
var state_31364__$1 = (function (){var statearr_31371 = state_31364;
(statearr_31371[(13)] = inst_31338__$1);

(statearr_31371[(14)] = inst_31339);

return statearr_31371;
})();
if(cljs.core.truth_(inst_31343)){
var statearr_31372_31389 = state_31364__$1;
(statearr_31372_31389[(1)] = (4));

} else {
var statearr_31373_31390 = state_31364__$1;
(statearr_31373_31390[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (9))){
var inst_31330 = (state_31364[(7)]);
var inst_31338 = (state_31364[(13)]);
var inst_31339 = (state_31364[(14)]);
var inst_31349 = (state_31364[(15)]);
var inst_31331 = (state_31364[(9)]);
var inst_31332 = (state_31364[(11)]);
var inst_31354 = (state_31364[(2)]);
var inst_31355 = (inst_31330 + inst_31349);
var inst_31356 = (inst_31331 + inst_31354);
var inst_31357 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31332,inst_31338);
var inst_31329 = inst_31339;
var inst_31330__$1 = inst_31355;
var inst_31331__$1 = inst_31356;
var inst_31332__$1 = inst_31357;
var state_31364__$1 = (function (){var statearr_31374 = state_31364;
(statearr_31374[(7)] = inst_31330__$1);

(statearr_31374[(9)] = inst_31331__$1);

(statearr_31374[(11)] = inst_31332__$1);

(statearr_31374[(12)] = inst_31329);

return statearr_31374;
})();
var statearr_31375_31391 = state_31364__$1;
(statearr_31375_31391[(2)] = null);

(statearr_31375_31391[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (5))){
var inst_31338 = (state_31364[(13)]);
var inst_31349 = (state_31364[(15)]);
var inst_31349__$1 = cljs.core.count(inst_31338);
var inst_31350 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_31349__$1);
var state_31364__$1 = (function (){var statearr_31376 = state_31364;
(statearr_31376[(15)] = inst_31349__$1);

return statearr_31376;
})();
if(inst_31350){
var statearr_31377_31392 = state_31364__$1;
(statearr_31377_31392[(1)] = (7));

} else {
var statearr_31378_31393 = state_31364__$1;
(statearr_31378_31393[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (8))){
var state_31364__$1 = state_31364;
var statearr_31379_31394 = state_31364__$1;
(statearr_31379_31394[(2)] = (1));

(statearr_31379_31394[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto____0 = (function (){
var statearr_31380 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31380[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto__);

(statearr_31380[(1)] = (1));

return statearr_31380;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto____1 = (function (state_31364){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31364);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31381){var ex__16304__auto__ = e31381;
var statearr_31382_31395 = state_31364;
(statearr_31382_31395[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31364[(4)]))){
var statearr_31383_31396 = state_31364;
(statearr_31383_31396[(1)] = cljs.core.first((state_31364[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31397 = state_31364;
state_31364 = G__31397;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto__ = function(state_31364){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto____1.call(this,state_31364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31384 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31384[(6)] = c__16375__auto__);

return statearr_31384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31443){
var state_val_31444 = (state_31443[(1)]);
if((state_val_31444 === (7))){
var state_31443__$1 = state_31443;
var statearr_31445_31483 = state_31443__$1;
(statearr_31445_31483[(2)] = null);

(statearr_31445_31483[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (20))){
var inst_31429 = (state_31443[(2)]);
var inst_31430 = fluree.db.util.async.throw_err(inst_31429);
var inst_31408 = inst_31430;
var state_31443__$1 = (function (){var statearr_31446 = state_31443;
(statearr_31446[(7)] = inst_31408);

return statearr_31446;
})();
var statearr_31447_31484 = state_31443__$1;
(statearr_31447_31484[(2)] = null);

(statearr_31447_31484[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (1))){
var state_31443__$1 = state_31443;
var statearr_31448_31485 = state_31443__$1;
(statearr_31448_31485[(2)] = null);

(statearr_31448_31485[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (4))){
var inst_31398 = (state_31443[(2)]);
var state_31443__$1 = state_31443;
var statearr_31449_31486 = state_31443__$1;
(statearr_31449_31486[(2)] = inst_31398);

(statearr_31449_31486[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (15))){
var inst_31408 = (state_31443[(7)]);
var inst_31425 = (state_31443[(8)]);
var inst_31425__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_31408);
var state_31443__$1 = (function (){var statearr_31450 = state_31443;
(statearr_31450[(8)] = inst_31425__$1);

return statearr_31450;
})();
if(cljs.core.truth_(inst_31425__$1)){
var statearr_31451_31487 = state_31443__$1;
(statearr_31451_31487[(1)] = (17));

} else {
var statearr_31452_31488 = state_31443__$1;
(statearr_31452_31488[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (13))){
var inst_31418 = (state_31443[(2)]);
var inst_31419 = fluree.db.util.async.throw_err(inst_31418);
var _ = (function (){var statearr_31453 = state_31443;
(statearr_31453[(4)] = cljs.core.rest((state_31443[(4)])));

return statearr_31453;
})();
var state_31443__$1 = state_31443;
var statearr_31454_31489 = state_31443__$1;
(statearr_31454_31489[(2)] = inst_31419);

(statearr_31454_31489[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (6))){
var inst_31406 = (state_31443[(2)]);
var inst_31407 = fluree.db.util.async.throw_err(inst_31406);
var inst_31408 = inst_31407;
var state_31443__$1 = (function (){var statearr_31455 = state_31443;
(statearr_31455[(7)] = inst_31408);

return statearr_31455;
})();
var statearr_31456_31490 = state_31443__$1;
(statearr_31456_31490[(2)] = null);

(statearr_31456_31490[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (17))){
var inst_31425 = (state_31443[(8)]);
var inst_31427 = fluree.db.dbproto._lookup_leaf(root_node,inst_31425);
var state_31443__$1 = state_31443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31443__$1,(20),inst_31427);
} else {
if((state_val_31444 === (3))){
var inst_31441 = (state_31443[(2)]);
var state_31443__$1 = state_31443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31443__$1,inst_31441);
} else {
if((state_val_31444 === (12))){
var _ = (function (){var statearr_31458 = state_31443;
(statearr_31458[(4)] = cljs.core.rest((state_31443[(4)])));

return statearr_31458;
})();
var state_31443__$1 = state_31443;
var ex31457 = (state_31443__$1[(2)]);
var statearr_31459_31491 = state_31443__$1;
(statearr_31459_31491[(5)] = ex31457);


var statearr_31460_31492 = state_31443__$1;
(statearr_31460_31492[(1)] = (11));

(statearr_31460_31492[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (2))){
var _ = (function (){var statearr_31461 = state_31443;
(statearr_31461[(4)] = cljs.core.cons((5),(state_31443[(4)])));

return statearr_31461;
})();
var inst_31404 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_31443__$1 = state_31443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31443__$1,(6),inst_31404);
} else {
if((state_val_31444 === (19))){
var inst_31434 = (state_31443[(2)]);
var state_31443__$1 = state_31443;
var statearr_31462_31493 = state_31443__$1;
(statearr_31462_31493[(2)] = inst_31434);

(statearr_31462_31493[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (11))){
var inst_31410 = (state_31443[(2)]);
var state_31443__$1 = (function (){var statearr_31464 = state_31443;
(statearr_31464[(9)] = inst_31410);

return statearr_31464;
})();
var statearr_31465_31494 = state_31443__$1;
(statearr_31465_31494[(2)] = null);

(statearr_31465_31494[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (9))){
var inst_31408 = (state_31443[(7)]);
var _ = (function (){var statearr_31466 = state_31443;
(statearr_31466[(4)] = cljs.core.cons((12),(state_31443[(4)])));

return statearr_31466;
})();
var inst_31416 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_31408,t,novelty,fast_forward_db_QMARK_);
var state_31443__$1 = state_31443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31443__$1,(13),inst_31416);
} else {
if((state_val_31444 === (5))){
var _ = (function (){var statearr_31467 = state_31443;
(statearr_31467[(4)] = cljs.core.rest((state_31443[(4)])));

return statearr_31467;
})();
var state_31443__$1 = state_31443;
var ex31463 = (state_31443__$1[(2)]);
var statearr_31468_31495 = state_31443__$1;
(statearr_31468_31495[(5)] = ex31463);


if((ex31463 instanceof Error)){
var statearr_31469_31496 = state_31443__$1;
(statearr_31469_31496[(1)] = (4));

(statearr_31469_31496[(5)] = null);

} else {
throw ex31463;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (14))){
var inst_31422 = (state_31443[(10)]);
var state_31443__$1 = state_31443;
var statearr_31470_31497 = state_31443__$1;
(statearr_31470_31497[(2)] = inst_31422);

(statearr_31470_31497[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (16))){
var inst_31436 = (state_31443[(2)]);
var state_31443__$1 = state_31443;
var statearr_31471_31498 = state_31443__$1;
(statearr_31471_31498[(2)] = inst_31436);

(statearr_31471_31498[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (10))){
var inst_31422 = (state_31443[(10)]);
var inst_31422__$1 = (state_31443[(2)]);
var state_31443__$1 = (function (){var statearr_31472 = state_31443;
(statearr_31472[(10)] = inst_31422__$1);

return statearr_31472;
})();
if(cljs.core.truth_(inst_31422__$1)){
var statearr_31473_31499 = state_31443__$1;
(statearr_31473_31499[(1)] = (14));

} else {
var statearr_31474_31500 = state_31443__$1;
(statearr_31474_31500[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (18))){
var state_31443__$1 = state_31443;
var statearr_31475_31501 = state_31443__$1;
(statearr_31475_31501[(2)] = null);

(statearr_31475_31501[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (8))){
var inst_31438 = (state_31443[(2)]);
var _ = (function (){var statearr_31476 = state_31443;
(statearr_31476[(4)] = cljs.core.rest((state_31443[(4)])));

return statearr_31476;
})();
var state_31443__$1 = state_31443;
var statearr_31477_31502 = state_31443__$1;
(statearr_31477_31502[(2)] = inst_31438);

(statearr_31477_31502[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto____0 = (function (){
var statearr_31478 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31478[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto__);

(statearr_31478[(1)] = (1));

return statearr_31478;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto____1 = (function (state_31443){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31443);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31479){var ex__16304__auto__ = e31479;
var statearr_31480_31503 = state_31443;
(statearr_31480_31503[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31443[(4)]))){
var statearr_31481_31504 = state_31443;
(statearr_31481_31504[(1)] = cljs.core.first((state_31443[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31505 = state_31443;
state_31443 = G__31505;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto__ = function(state_31443){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto____1.call(this,state_31443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31482 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31482[(6)] = c__16375__auto__);

return statearr_31482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__31512 = arguments.length;
switch (G__31512) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__31513 = (function (){var pred__31516 = cljs.core.identical_QMARK_;
var expr__31517 = test;
if(cljs.core.truth_((pred__31516.cljs$core$IFn$_invoke$arity$2 ? pred__31516.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__31517) : pred__31516.call(null,cljs.core._EQ_,expr__31517)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__31516.cljs$core$IFn$_invoke$arity$2 ? pred__31516.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__31517) : pred__31516.call(null,cljs.core._LT_,expr__31517)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__31516.cljs$core$IFn$_invoke$arity$2 ? pred__31516.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__31517) : pred__31516.call(null,cljs.core._LT__EQ_,expr__31517)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__31516.cljs$core$IFn$_invoke$arity$2 ? pred__31516.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__31517) : pred__31516.call(null,cljs.core._GT_,expr__31517)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__31516.cljs$core$IFn$_invoke$arity$2 ? pred__31516.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__31517) : pred__31516.call(null,cljs.core._GT__EQ_,expr__31517)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__31517)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31513,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31513,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31513,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31513,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31915){
var state_val_31916 = (state_31915[(1)]);
if((state_val_31916 === (121))){
var inst_31776 = (state_31915[(7)]);
var state_31915__$1 = state_31915;
var statearr_31917_32123 = state_31915__$1;
(statearr_31917_32123[(2)] = inst_31776);

(statearr_31917_32123[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (65))){
var state_31915__$1 = state_31915;
var statearr_31918_32124 = state_31915__$1;
(statearr_31918_32124[(2)] = fluree.db.util.core.min_integer);

(statearr_31918_32124[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (70))){
var state_31915__$1 = state_31915;
var statearr_31919_32125 = state_31915__$1;
(statearr_31919_32125[(2)] = true);

(statearr_31919_32125[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (62))){
var inst_31678 = (cljs.core._LT__EQ_ === end_test);
var state_31915__$1 = state_31915;
if(cljs.core.truth_(inst_31678)){
var statearr_31920_32126 = state_31915__$1;
(statearr_31920_32126[(1)] = (64));

} else {
var statearr_31921_32127 = state_31915__$1;
(statearr_31921_32127[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (74))){
var inst_31687 = (state_31915[(8)]);
var state_31915__$1 = state_31915;
var statearr_31922_32128 = state_31915__$1;
(statearr_31922_32128[(2)] = inst_31687);

(statearr_31922_32128[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (110))){
var inst_31809 = (state_31915[(9)]);
var inst_31818 = (state_31915[(10)]);
var inst_31817 = (state_31915[(11)]);
var inst_31742 = (state_31915[(12)]);
var inst_31715 = (state_31915[(13)]);
var inst_31819 = (state_31915[(14)]);
var inst_31817__$1 = cljs.core.count(inst_31809);
var inst_31818__$1 = (inst_31742 + inst_31817__$1);
var inst_31819__$1 = (inst_31818__$1 - inst_31715);
var inst_31820 = cljs.core.pos_int_QMARK_(inst_31819__$1);
var state_31915__$1 = (function (){var statearr_31923 = state_31915;
(statearr_31923[(10)] = inst_31818__$1);

(statearr_31923[(11)] = inst_31817__$1);

(statearr_31923[(14)] = inst_31819__$1);

return statearr_31923;
})();
if(inst_31820){
var statearr_31924_32129 = state_31915__$1;
(statearr_31924_32129[(1)] = (113));

} else {
var statearr_31925_32130 = state_31915__$1;
(statearr_31925_32130[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (130))){
var inst_31878 = (state_31915[(15)]);
var state_31915__$1 = state_31915;
var statearr_31926_32131 = state_31915__$1;
(statearr_31926_32131[(2)] = inst_31878);

(statearr_31926_32131[(1)] = (132));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (128))){
var inst_31887 = (state_31915[(16)]);
var state_31915__$1 = state_31915;
var statearr_31927_32132 = state_31915__$1;
(statearr_31927_32132[(2)] = inst_31887);

(statearr_31927_32132[(1)] = (129));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (7))){
var state_31915__$1 = state_31915;
var statearr_31928_32133 = state_31915__$1;
(statearr_31928_32133[(2)] = false);

(statearr_31928_32133[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (59))){
var state_31915__$1 = state_31915;
var statearr_31929_32134 = state_31915__$1;
(statearr_31929_32134[(2)] = (2147483647));

(statearr_31929_32134[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (86))){
var inst_31551 = (state_31915[(17)]);
var inst_31576 = (state_31915[(18)]);
var inst_31657 = (state_31915[(19)]);
var inst_31708 = (state_31915[(20)]);
var inst_31722 = (state_31915[(21)]);
var inst_31586 = (state_31915[(22)]);
var inst_31543 = (state_31915[(23)]);
var inst_31732 = (state_31915[(24)]);
var inst_31575 = (state_31915[(25)]);
var inst_31749 = (state_31915[(26)]);
var inst_31736 = (state_31915[(27)]);
var inst_31546 = (state_31915[(28)]);
var inst_31741 = (state_31915[(29)]);
var inst_31595 = (state_31915[(30)]);
var inst_31721 = (state_31915[(31)]);
var inst_31709 = (state_31915[(32)]);
var inst_31716 = (state_31915[(33)]);
var inst_31742 = (state_31915[(12)]);
var inst_31626 = (state_31915[(34)]);
var inst_31717 = (state_31915[(35)]);
var inst_31715 = (state_31915[(13)]);
var inst_31648 = (state_31915[(36)]);
var inst_31550 = (state_31915[(37)]);
var inst_31685 = (state_31915[(38)]);
var inst_31739 = (state_31915[(39)]);
var inst_31666 = (state_31915[(40)]);
var inst_31627 = (state_31915[(41)]);
var inst_31727 = (state_31915[(42)]);
var inst_31630 = (state_31915[(43)]);
var inst_31539 = (state_31915[(44)]);
var inst_31684 = (state_31915[(45)]);
var inst_31675 = (state_31915[(46)]);
var inst_31743 = (state_31915[(47)]);
var inst_31544 = (state_31915[(48)]);
var inst_31726 = (state_31915[(49)]);
var inst_31686 = (state_31915[(50)]);
var inst_31639 = (state_31915[(51)]);
var inst_31574 = (state_31915[(52)]);
var inst_31740 = (state_31915[(53)]);
var inst_31753 = (function (){var no_filter_QMARK_ = true;
var t = inst_31722;
var max_limit_QMARK_ = inst_31716;
var next_node = inst_31739;
var fast_forward_db_QMARK_ = inst_31727;
var s1 = inst_31586;
var o2 = inst_31648;
var t1 = inst_31543;
var map__31538 = inst_31708;
var G__31750 = inst_31749;
var predicate_fn = inst_31576;
var i = inst_31741;
var m1 = inst_31675;
var root_node = inst_31732;
var s2 = inst_31595;
var vec__31532 = inst_31626;
var p2 = inst_31666;
var permissions = inst_31717;
var limit = inst_31715;
var start_flake = inst_31685;
var map__31531 = inst_31574;
var flake_limit = inst_31709;
var offset = inst_31740;
var acc = inst_31743;
var vec__31528 = inst_31546;
var vec__31535 = inst_31627;
var t2 = inst_31550;
var op1 = inst_31544;
var o1 = inst_31639;
var end_flake = inst_31686;
var base_result = inst_31749;
var s = inst_31742;
var node_start = inst_31736;
var p1 = inst_31657;
var subject_fn = inst_31575;
var object_fn = inst_31630;
var vec__31525 = inst_31539;
var idx_compare = inst_31721;
var op2 = inst_31551;
var m2 = inst_31684;
var novelty = inst_31726;
return (function (p1__31506_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31506_SHARP_.o,start_flake.o);
});
})();
var inst_31754 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_31753,inst_31749);
var state_31915__$1 = state_31915;
var statearr_31930_32135 = state_31915__$1;
(statearr_31930_32135[(2)] = inst_31754);

(statearr_31930_32135[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (20))){
var inst_31547 = (state_31915[(54)]);
var state_31915__$1 = state_31915;
var statearr_31931_32136 = state_31915__$1;
(statearr_31931_32136[(2)] = inst_31547);

(statearr_31931_32136[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (72))){
var inst_31700 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
var statearr_31932_32137 = state_31915__$1;
(statearr_31932_32137[(2)] = inst_31700);

(statearr_31932_32137[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (58))){
var state_31915__$1 = state_31915;
var statearr_31933_32138 = state_31915__$1;
(statearr_31933_32138[(2)] = fluree.db.util.core.min_integer);

(statearr_31933_32138[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (60))){
var inst_31673 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
var statearr_31934_32139 = state_31915__$1;
(statearr_31934_32139[(2)] = inst_31673);

(statearr_31934_32139[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (27))){
var state_31915__$1 = state_31915;
var statearr_31935_32140 = state_31915__$1;
(statearr_31935_32140[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (1))){
var state_31915__$1 = state_31915;
var statearr_31937_32141 = state_31915__$1;
(statearr_31937_32141[(2)] = null);

(statearr_31937_32141[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (69))){
var inst_31703 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
if(cljs.core.truth_(inst_31703)){
var statearr_31938_32142 = state_31915__$1;
(statearr_31938_32142[(1)] = (73));

} else {
var statearr_31939_32143 = state_31915__$1;
(statearr_31939_32143[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (101))){
var state_31915__$1 = state_31915;
var statearr_31940_32144 = state_31915__$1;
(statearr_31940_32144[(2)] = true);

(statearr_31940_32144[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (24))){
var inst_31549 = (state_31915[(55)]);
var inst_31599 = cljs.core.boolean_QMARK_(inst_31549);
var state_31915__$1 = state_31915;
if(inst_31599){
var statearr_31941_32145 = state_31915__$1;
(statearr_31941_32145[(1)] = (26));

} else {
var statearr_31942_32146 = state_31915__$1;
(statearr_31942_32146[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (102))){
var state_31915__$1 = state_31915;
var statearr_31943_32147 = state_31915__$1;
(statearr_31943_32147[(2)] = false);

(statearr_31943_32147[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (55))){
var inst_31545 = (state_31915[(56)]);
var state_31915__$1 = state_31915;
var statearr_31944_32148 = state_31915__$1;
(statearr_31944_32148[(2)] = inst_31545);

(statearr_31944_32148[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (85))){
var inst_31907 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
var statearr_31945_32149 = state_31915__$1;
(statearr_31945_32149[(2)] = inst_31907);

(statearr_31945_32149[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (39))){
var inst_31629 = (state_31915[(57)]);
var inst_31642 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31629);
var state_31915__$1 = state_31915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31915__$1,(42),inst_31642);
} else {
if((state_val_31916 === (88))){
var inst_31575 = (state_31915[(25)]);
var inst_31757 = (state_31915[(2)]);
var state_31915__$1 = (function (){var statearr_31946 = state_31915;
(statearr_31946[(58)] = inst_31757);

return statearr_31946;
})();
if(cljs.core.truth_(inst_31575)){
var statearr_31947_32150 = state_31915__$1;
(statearr_31947_32150[(1)] = (89));

} else {
var statearr_31948_32151 = state_31915__$1;
(statearr_31948_32151[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (46))){
var state_31915__$1 = state_31915;
var statearr_31949_32152 = state_31915__$1;
(statearr_31949_32152[(2)] = (-1));

(statearr_31949_32152[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (4))){
var inst_31519 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
var statearr_31950_32153 = state_31915__$1;
(statearr_31950_32153[(2)] = inst_31519);

(statearr_31950_32153[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (77))){
var state_31915__$1 = state_31915;
var statearr_31951_32154 = state_31915__$1;
(statearr_31951_32154[(2)] = fluree.db.util.core.max_long);

(statearr_31951_32154[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (106))){
var inst_31776 = (state_31915[(7)]);
var inst_31874 = (state_31915[(2)]);
var inst_31875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31874,(0),null);
var inst_31876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31874,(1),null);
var inst_31877 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31874,(2),null);
var inst_31878 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31874,(3),null);
var state_31915__$1 = (function (){var statearr_31952 = state_31915;
(statearr_31952[(59)] = inst_31875);

(statearr_31952[(15)] = inst_31878);

(statearr_31952[(60)] = inst_31877);

(statearr_31952[(61)] = inst_31876);

return statearr_31952;
})();
if(cljs.core.truth_(inst_31776)){
var statearr_31953_32155 = state_31915__$1;
(statearr_31953_32155[(1)] = (120));

} else {
var statearr_31954_32156 = state_31915__$1;
(statearr_31954_32156[(1)] = (121));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (119))){
var inst_31860 = (state_31915[(2)]);
var inst_31861 = fluree.db.util.async.throw_err(inst_31860);
var state_31915__$1 = state_31915;
var statearr_31955_32157 = state_31915__$1;
(statearr_31955_32157[(2)] = inst_31861);

(statearr_31955_32157[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (95))){
var inst_31551 = (state_31915[(17)]);
var inst_31576 = (state_31915[(18)]);
var inst_31657 = (state_31915[(19)]);
var inst_31708 = (state_31915[(20)]);
var inst_31722 = (state_31915[(21)]);
var inst_31586 = (state_31915[(22)]);
var inst_31543 = (state_31915[(23)]);
var inst_31732 = (state_31915[(24)]);
var inst_31575 = (state_31915[(25)]);
var inst_31749 = (state_31915[(26)]);
var inst_31736 = (state_31915[(27)]);
var inst_31546 = (state_31915[(28)]);
var inst_31741 = (state_31915[(29)]);
var inst_31595 = (state_31915[(30)]);
var inst_31721 = (state_31915[(31)]);
var inst_31709 = (state_31915[(32)]);
var inst_31716 = (state_31915[(33)]);
var inst_31742 = (state_31915[(12)]);
var inst_31626 = (state_31915[(34)]);
var inst_31717 = (state_31915[(35)]);
var inst_31715 = (state_31915[(13)]);
var inst_31648 = (state_31915[(36)]);
var inst_31550 = (state_31915[(37)]);
var inst_31685 = (state_31915[(38)]);
var inst_31739 = (state_31915[(39)]);
var inst_31666 = (state_31915[(40)]);
var inst_31627 = (state_31915[(41)]);
var inst_31769 = (state_31915[(62)]);
var inst_31727 = (state_31915[(42)]);
var inst_31630 = (state_31915[(43)]);
var inst_31539 = (state_31915[(44)]);
var inst_31684 = (state_31915[(45)]);
var inst_31675 = (state_31915[(46)]);
var inst_31743 = (state_31915[(47)]);
var inst_31544 = (state_31915[(48)]);
var inst_31726 = (state_31915[(49)]);
var inst_31686 = (state_31915[(50)]);
var inst_31639 = (state_31915[(51)]);
var inst_31574 = (state_31915[(52)]);
var inst_31740 = (state_31915[(53)]);
var inst_31771 = (function (){var no_filter_QMARK_ = true;
var t = inst_31722;
var max_limit_QMARK_ = inst_31716;
var next_node = inst_31739;
var fast_forward_db_QMARK_ = inst_31727;
var s1 = inst_31586;
var o2 = inst_31648;
var t1 = inst_31543;
var map__31538 = inst_31708;
var G__31750 = inst_31769;
var predicate_fn = inst_31576;
var i = inst_31741;
var m1 = inst_31675;
var root_node = inst_31732;
var s2 = inst_31595;
var vec__31532 = inst_31626;
var p2 = inst_31666;
var permissions = inst_31717;
var limit = inst_31715;
var start_flake = inst_31685;
var map__31531 = inst_31574;
var flake_limit = inst_31709;
var offset = inst_31740;
var acc = inst_31743;
var vec__31528 = inst_31546;
var vec__31535 = inst_31627;
var t2 = inst_31550;
var op1 = inst_31544;
var o1 = inst_31639;
var end_flake = inst_31686;
var base_result = inst_31749;
var s = inst_31742;
var node_start = inst_31736;
var p1 = inst_31657;
var subject_fn = inst_31575;
var object_fn = inst_31630;
var vec__31525 = inst_31539;
var idx_compare = inst_31721;
var op2 = inst_31551;
var m2 = inst_31684;
var novelty = inst_31726;
return (function (p1__31509_SHARP_){
var G__31956 = p1__31509_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__31956) : object_fn.call(null,G__31956));
});
})();
var inst_31772 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_31771,inst_31769);
var state_31915__$1 = state_31915;
var statearr_31957_32158 = state_31915__$1;
(statearr_31957_32158[(2)] = inst_31772);

(statearr_31957_32158[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (54))){
var inst_31545 = (state_31915[(56)]);
var inst_31666 = (state_31915[(2)]);
var state_31915__$1 = (function (){var statearr_31958 = state_31915;
(statearr_31958[(40)] = inst_31666);

return statearr_31958;
})();
if(cljs.core.truth_(inst_31545)){
var statearr_31959_32159 = state_31915__$1;
(statearr_31959_32159[(1)] = (55));

} else {
var statearr_31960_32160 = state_31915__$1;
(statearr_31960_32160[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (92))){
var inst_31551 = (state_31915[(17)]);
var inst_31576 = (state_31915[(18)]);
var inst_31657 = (state_31915[(19)]);
var inst_31708 = (state_31915[(20)]);
var inst_31722 = (state_31915[(21)]);
var inst_31586 = (state_31915[(22)]);
var inst_31543 = (state_31915[(23)]);
var inst_31732 = (state_31915[(24)]);
var inst_31575 = (state_31915[(25)]);
var inst_31749 = (state_31915[(26)]);
var inst_31736 = (state_31915[(27)]);
var inst_31546 = (state_31915[(28)]);
var inst_31741 = (state_31915[(29)]);
var inst_31595 = (state_31915[(30)]);
var inst_31721 = (state_31915[(31)]);
var inst_31709 = (state_31915[(32)]);
var inst_31716 = (state_31915[(33)]);
var inst_31742 = (state_31915[(12)]);
var inst_31626 = (state_31915[(34)]);
var inst_31717 = (state_31915[(35)]);
var inst_31715 = (state_31915[(13)]);
var inst_31648 = (state_31915[(36)]);
var inst_31550 = (state_31915[(37)]);
var inst_31685 = (state_31915[(38)]);
var inst_31739 = (state_31915[(39)]);
var inst_31763 = (state_31915[(63)]);
var inst_31666 = (state_31915[(40)]);
var inst_31627 = (state_31915[(41)]);
var inst_31727 = (state_31915[(42)]);
var inst_31630 = (state_31915[(43)]);
var inst_31539 = (state_31915[(44)]);
var inst_31684 = (state_31915[(45)]);
var inst_31675 = (state_31915[(46)]);
var inst_31743 = (state_31915[(47)]);
var inst_31544 = (state_31915[(48)]);
var inst_31726 = (state_31915[(49)]);
var inst_31686 = (state_31915[(50)]);
var inst_31639 = (state_31915[(51)]);
var inst_31574 = (state_31915[(52)]);
var inst_31740 = (state_31915[(53)]);
var inst_31765 = (function (){var no_filter_QMARK_ = true;
var t = inst_31722;
var max_limit_QMARK_ = inst_31716;
var next_node = inst_31739;
var fast_forward_db_QMARK_ = inst_31727;
var s1 = inst_31586;
var o2 = inst_31648;
var t1 = inst_31543;
var map__31538 = inst_31708;
var G__31750 = inst_31763;
var predicate_fn = inst_31576;
var i = inst_31741;
var m1 = inst_31675;
var root_node = inst_31732;
var s2 = inst_31595;
var vec__31532 = inst_31626;
var p2 = inst_31666;
var permissions = inst_31717;
var limit = inst_31715;
var start_flake = inst_31685;
var map__31531 = inst_31574;
var flake_limit = inst_31709;
var offset = inst_31740;
var acc = inst_31743;
var vec__31528 = inst_31546;
var vec__31535 = inst_31627;
var t2 = inst_31550;
var op1 = inst_31544;
var o1 = inst_31639;
var end_flake = inst_31686;
var base_result = inst_31749;
var s = inst_31742;
var node_start = inst_31736;
var p1 = inst_31657;
var subject_fn = inst_31575;
var object_fn = inst_31630;
var vec__31525 = inst_31539;
var idx_compare = inst_31721;
var op2 = inst_31551;
var m2 = inst_31684;
var novelty = inst_31726;
return (function (p1__31508_SHARP_){
var G__31961 = p1__31508_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__31961) : predicate_fn.call(null,G__31961));
});
})();
var inst_31766 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_31765,inst_31763);
var state_31915__$1 = state_31915;
var statearr_31962_32161 = state_31915__$1;
(statearr_31962_32161[(2)] = inst_31766);

(statearr_31962_32161[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (104))){
var inst_31741 = (state_31915[(29)]);
var inst_31709 = (state_31915[(32)]);
var inst_31742 = (state_31915[(12)]);
var inst_31775 = (state_31915[(64)]);
var inst_31743 = (state_31915[(47)]);
var inst_31787 = cljs.core.count(inst_31775);
var inst_31788 = (inst_31709 - inst_31741);
var inst_31789 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_31788,inst_31775);
var inst_31790 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31743,inst_31789);
var inst_31791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31792 = (inst_31741 + inst_31787);
var inst_31793 = [(0),inst_31792,inst_31742,inst_31790];
var inst_31794 = (new cljs.core.PersistentVector(null,4,(5),inst_31791,inst_31793,null));
var state_31915__$1 = state_31915;
var statearr_31963_32162 = state_31915__$1;
(statearr_31963_32162[(2)] = inst_31794);

(statearr_31963_32162[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (15))){
var inst_31540 = (state_31915[(65)]);
var inst_31580 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31540);
var state_31915__$1 = state_31915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31915__$1,(18),inst_31580);
} else {
if((state_val_31916 === (48))){
var inst_31548 = (state_31915[(66)]);
var inst_31657 = (state_31915[(2)]);
var inst_31658 = (inst_31548 == null);
var state_31915__$1 = (function (){var statearr_31964 = state_31915;
(statearr_31964[(19)] = inst_31657);

return statearr_31964;
})();
if(cljs.core.truth_(inst_31658)){
var statearr_31965_32163 = state_31915__$1;
(statearr_31965_32163[(1)] = (49));

} else {
var statearr_31966_32164 = state_31915__$1;
(statearr_31966_32164[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (50))){
var state_31915__$1 = state_31915;
var statearr_31967_32165 = state_31915__$1;
(statearr_31967_32165[(2)] = false);

(statearr_31967_32165[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (116))){
var inst_31709 = (state_31915[(32)]);
var inst_31836 = (state_31915[(67)]);
var inst_31837 = (state_31915[(68)]);
var inst_31835 = (state_31915[(69)]);
var inst_31840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31841 = (inst_31837 - inst_31709);
var inst_31842 = (inst_31836 - inst_31841);
var inst_31843 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_31842,inst_31835);
var inst_31844 = [inst_31709,inst_31843];
var inst_31845 = (new cljs.core.PersistentVector(null,2,(5),inst_31840,inst_31844,null));
var state_31915__$1 = state_31915;
var statearr_31968_32166 = state_31915__$1;
(statearr_31968_32166[(2)] = inst_31845);

(statearr_31968_32166[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (75))){
var inst_31708 = (state_31915[(20)]);
var inst_31710 = (state_31915[(70)]);
var inst_31708__$1 = (state_31915[(2)]);
var inst_31709 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_31708__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_31710__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31708__$1,cljs.core.cst$kw$limit);
var inst_31711 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_31708__$1,cljs.core.cst$kw$offset,(0));
var state_31915__$1 = (function (){var statearr_31969 = state_31915;
(statearr_31969[(20)] = inst_31708__$1);

(statearr_31969[(70)] = inst_31710__$1);

(statearr_31969[(32)] = inst_31709);

(statearr_31969[(71)] = inst_31711);

return statearr_31969;
})();
if(cljs.core.truth_(inst_31710__$1)){
var statearr_31970_32167 = state_31915__$1;
(statearr_31970_32167[(1)] = (76));

} else {
var statearr_31971_32168 = state_31915__$1;
(statearr_31971_32168[(1)] = (77));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (99))){
var inst_31716 = (state_31915[(33)]);
var state_31915__$1 = state_31915;
var statearr_31972_32169 = state_31915__$1;
(statearr_31972_32169[(2)] = inst_31716);

(statearr_31972_32169[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (21))){
var inst_31542 = (state_31915[(72)]);
var inst_31595 = (state_31915[(2)]);
var inst_31596 = cljs.core.boolean_QMARK_(inst_31542);
var state_31915__$1 = (function (){var statearr_31973 = state_31915;
(statearr_31973[(30)] = inst_31595);

return statearr_31973;
})();
if(inst_31596){
var statearr_31974_32170 = state_31915__$1;
(statearr_31974_32170[(1)] = (23));

} else {
var statearr_31975_32171 = state_31915__$1;
(statearr_31975_32171[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (31))){
var inst_31605 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
var statearr_31976_32172 = state_31915__$1;
(statearr_31976_32172[(2)] = inst_31605);

(statearr_31976_32172[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (113))){
var inst_31817 = (state_31915[(11)]);
var inst_31715 = (state_31915[(13)]);
var inst_31819 = (state_31915[(14)]);
var inst_31822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31823 = (inst_31817 - inst_31819);
var inst_31824 = [inst_31715,inst_31823];
var inst_31825 = (new cljs.core.PersistentVector(null,2,(5),inst_31822,inst_31824,null));
var state_31915__$1 = state_31915;
var statearr_31977_32173 = state_31915__$1;
(statearr_31977_32173[(2)] = inst_31825);

(statearr_31977_32173[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (32))){
var inst_31551 = (state_31915[(17)]);
var inst_31576 = (state_31915[(18)]);
var inst_31552 = (state_31915[(73)]);
var inst_31577 = (state_31915[(74)]);
var inst_31586 = (state_31915[(22)]);
var inst_31545 = (state_31915[(56)]);
var inst_31549 = (state_31915[(55)]);
var inst_31543 = (state_31915[(23)]);
var inst_31575 = (state_31915[(25)]);
var inst_31546 = (state_31915[(28)]);
var inst_31541 = (state_31915[(75)]);
var inst_31595 = (state_31915[(30)]);
var inst_31548 = (state_31915[(66)]);
var inst_31550 = (state_31915[(37)]);
var inst_31609 = (state_31915[(76)]);
var inst_31539 = (state_31915[(44)]);
var inst_31542 = (state_31915[(72)]);
var inst_31544 = (state_31915[(48)]);
var inst_31574 = (state_31915[(52)]);
var inst_31611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31613 = [null,null];
var inst_31614 = (new cljs.core.PersistentVector(null,2,(5),inst_31612,inst_31613,null));
var inst_31615 = (function (){var bool = inst_31609;
var temp__5733__auto__ = inst_31609;
var s1 = inst_31586;
var o2 = inst_31549;
var t1 = inst_31543;
var predicate_fn = inst_31576;
var m1 = inst_31545;
var s2 = inst_31595;
var p2 = inst_31548;
var map__31531 = inst_31574;
var vec__31528 = inst_31546;
var t2 = inst_31550;
var op1 = inst_31544;
var o1 = inst_31542;
var p1 = inst_31541;
var subject_fn = inst_31575;
var object_fn = inst_31577;
var vec__31525 = inst_31539;
var op2 = inst_31551;
var m2 = inst_31552;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_31616 = [inst_31614,inst_31615];
var inst_31617 = (new cljs.core.PersistentVector(null,2,(5),inst_31611,inst_31616,null));
var state_31915__$1 = state_31915;
var statearr_31978_32174 = state_31915__$1;
(statearr_31978_32174[(2)] = inst_31617);

(statearr_31978_32174[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (40))){
var inst_31629 = (state_31915[(57)]);
var state_31915__$1 = state_31915;
var statearr_31979_32175 = state_31915__$1;
(statearr_31979_32175[(2)] = inst_31629);

(statearr_31979_32175[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (129))){
var inst_31899 = (state_31915[(2)]);
var inst_31900 = cljs.core.not(inst_31899);
var state_31915__$1 = state_31915;
if(inst_31900){
var statearr_31980_32176 = state_31915__$1;
(statearr_31980_32176[(1)] = (130));

} else {
var statearr_31981_32177 = state_31915__$1;
(statearr_31981_32177[(1)] = (131));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (91))){
var inst_31576 = (state_31915[(18)]);
var inst_31763 = (state_31915[(2)]);
var state_31915__$1 = (function (){var statearr_31982 = state_31915;
(statearr_31982[(63)] = inst_31763);

return statearr_31982;
})();
if(cljs.core.truth_(inst_31576)){
var statearr_31983_32178 = state_31915__$1;
(statearr_31983_32178[(1)] = (92));

} else {
var statearr_31984_32179 = state_31915__$1;
(statearr_31984_32179[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (117))){
var inst_31837 = (state_31915[(68)]);
var inst_31835 = (state_31915[(69)]);
var inst_31847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31848 = [inst_31837,inst_31835];
var inst_31849 = (new cljs.core.PersistentVector(null,2,(5),inst_31847,inst_31848,null));
var state_31915__$1 = state_31915;
var statearr_31985_32180 = state_31915__$1;
(statearr_31985_32180[(2)] = inst_31849);

(statearr_31985_32180[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (108))){
var inst_31797 = (state_31915[(77)]);
var inst_31740 = (state_31915[(53)]);
var inst_31809 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_31740,inst_31797);
var state_31915__$1 = (function (){var statearr_31986 = state_31915;
(statearr_31986[(9)] = inst_31809);

return statearr_31986;
})();
var statearr_31987_32181 = state_31915__$1;
(statearr_31987_32181[(1)] = (110));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (56))){
var inst_31669 = (cljs.core._GT__EQ_ === start_test);
var state_31915__$1 = state_31915;
if(cljs.core.truth_(inst_31669)){
var statearr_31989_32182 = state_31915__$1;
(statearr_31989_32182[(1)] = (58));

} else {
var statearr_31990_32183 = state_31915__$1;
(statearr_31990_32183[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (33))){
var inst_31577 = (state_31915[(74)]);
var inst_31549 = (state_31915[(55)]);
var inst_31542 = (state_31915[(72)]);
var inst_31619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31621 = [inst_31542,inst_31549];
var inst_31622 = (new cljs.core.PersistentVector(null,2,(5),inst_31620,inst_31621,null));
var inst_31623 = [inst_31622,inst_31577];
var inst_31624 = (new cljs.core.PersistentVector(null,2,(5),inst_31619,inst_31623,null));
var state_31915__$1 = state_31915;
var statearr_31991_32184 = state_31915__$1;
(statearr_31991_32184[(2)] = inst_31624);

(statearr_31991_32184[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (13))){
var inst_31553 = (state_31915[(78)]);
var state_31915__$1 = state_31915;
var statearr_31992_32185 = state_31915__$1;
(statearr_31992_32185[(2)] = inst_31553);

(statearr_31992_32185[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (22))){
var inst_31591 = (state_31915[(2)]);
var inst_31592 = fluree.db.util.async.throw_err(inst_31591);
var state_31915__$1 = state_31915;
var statearr_31993_32186 = state_31915__$1;
(statearr_31993_32186[(2)] = inst_31592);

(statearr_31993_32186[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (90))){
var inst_31757 = (state_31915[(58)]);
var state_31915__$1 = state_31915;
var statearr_31994_32187 = state_31915__$1;
(statearr_31994_32187[(2)] = inst_31757);

(statearr_31994_32187[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (109))){
var inst_31872 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
var statearr_31995_32188 = state_31915__$1;
(statearr_31995_32188[(2)] = inst_31872);

(statearr_31995_32188[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (36))){
var inst_31628 = (state_31915[(79)]);
var state_31915__$1 = state_31915;
var statearr_31996_32189 = state_31915__$1;
(statearr_31996_32189[(2)] = inst_31628);

(statearr_31996_32189[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (41))){
var inst_31541 = (state_31915[(75)]);
var inst_31648 = (state_31915[(2)]);
var inst_31649 = (inst_31541 == null);
var state_31915__$1 = (function (){var statearr_31997 = state_31915;
(statearr_31997[(36)] = inst_31648);

return statearr_31997;
})();
if(cljs.core.truth_(inst_31649)){
var statearr_31998_32190 = state_31915__$1;
(statearr_31998_32190[(1)] = (43));

} else {
var statearr_31999_32191 = state_31915__$1;
(statearr_31999_32191[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (118))){
var inst_31832 = (state_31915[(80)]);
var inst_31851 = (state_31915[(2)]);
var inst_31852 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31851,(0),null);
var inst_31853 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31851,(1),null);
var inst_31854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31855 = [inst_31852,inst_31832,inst_31853];
var inst_31856 = (new cljs.core.PersistentVector(null,3,(5),inst_31854,inst_31855,null));
var state_31915__$1 = state_31915;
var statearr_32000_32192 = state_31915__$1;
(statearr_32000_32192[(2)] = inst_31856);

(statearr_32000_32192[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (89))){
var inst_31551 = (state_31915[(17)]);
var inst_31576 = (state_31915[(18)]);
var inst_31657 = (state_31915[(19)]);
var inst_31708 = (state_31915[(20)]);
var inst_31722 = (state_31915[(21)]);
var inst_31586 = (state_31915[(22)]);
var inst_31543 = (state_31915[(23)]);
var inst_31732 = (state_31915[(24)]);
var inst_31575 = (state_31915[(25)]);
var inst_31749 = (state_31915[(26)]);
var inst_31736 = (state_31915[(27)]);
var inst_31546 = (state_31915[(28)]);
var inst_31741 = (state_31915[(29)]);
var inst_31595 = (state_31915[(30)]);
var inst_31721 = (state_31915[(31)]);
var inst_31709 = (state_31915[(32)]);
var inst_31716 = (state_31915[(33)]);
var inst_31742 = (state_31915[(12)]);
var inst_31626 = (state_31915[(34)]);
var inst_31717 = (state_31915[(35)]);
var inst_31715 = (state_31915[(13)]);
var inst_31648 = (state_31915[(36)]);
var inst_31550 = (state_31915[(37)]);
var inst_31685 = (state_31915[(38)]);
var inst_31739 = (state_31915[(39)]);
var inst_31666 = (state_31915[(40)]);
var inst_31757 = (state_31915[(58)]);
var inst_31627 = (state_31915[(41)]);
var inst_31727 = (state_31915[(42)]);
var inst_31630 = (state_31915[(43)]);
var inst_31539 = (state_31915[(44)]);
var inst_31684 = (state_31915[(45)]);
var inst_31675 = (state_31915[(46)]);
var inst_31743 = (state_31915[(47)]);
var inst_31544 = (state_31915[(48)]);
var inst_31726 = (state_31915[(49)]);
var inst_31686 = (state_31915[(50)]);
var inst_31639 = (state_31915[(51)]);
var inst_31574 = (state_31915[(52)]);
var inst_31740 = (state_31915[(53)]);
var inst_31759 = (function (){var no_filter_QMARK_ = true;
var t = inst_31722;
var max_limit_QMARK_ = inst_31716;
var next_node = inst_31739;
var fast_forward_db_QMARK_ = inst_31727;
var s1 = inst_31586;
var o2 = inst_31648;
var t1 = inst_31543;
var map__31538 = inst_31708;
var G__31750 = inst_31757;
var predicate_fn = inst_31576;
var i = inst_31741;
var m1 = inst_31675;
var root_node = inst_31732;
var s2 = inst_31595;
var vec__31532 = inst_31626;
var p2 = inst_31666;
var permissions = inst_31717;
var limit = inst_31715;
var start_flake = inst_31685;
var map__31531 = inst_31574;
var flake_limit = inst_31709;
var offset = inst_31740;
var acc = inst_31743;
var vec__31528 = inst_31546;
var vec__31535 = inst_31627;
var t2 = inst_31550;
var op1 = inst_31544;
var o1 = inst_31639;
var end_flake = inst_31686;
var base_result = inst_31749;
var s = inst_31742;
var node_start = inst_31736;
var p1 = inst_31657;
var subject_fn = inst_31575;
var object_fn = inst_31630;
var vec__31525 = inst_31539;
var idx_compare = inst_31721;
var op2 = inst_31551;
var m2 = inst_31684;
var novelty = inst_31726;
return (function (p1__31507_SHARP_){
var G__32001 = p1__31507_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__32001) : subject_fn.call(null,G__32001));
});
})();
var inst_31760 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_31759,inst_31757);
var state_31915__$1 = state_31915;
var statearr_32002_32193 = state_31915__$1;
(statearr_32002_32193[(2)] = inst_31760);

(statearr_32002_32193[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (100))){
var inst_31785 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
if(cljs.core.truth_(inst_31785)){
var statearr_32003_32194 = state_31915__$1;
(statearr_32003_32194[(1)] = (104));

} else {
var statearr_32004_32195 = state_31915__$1;
(statearr_32004_32195[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (131))){
var inst_31875 = (state_31915[(59)]);
var inst_31878 = (state_31915[(15)]);
var inst_31877 = (state_31915[(60)]);
var inst_31876 = (state_31915[(61)]);
var inst_31895 = (state_31915[(81)]);
var inst_31739 = inst_31895;
var inst_31740 = inst_31875;
var inst_31741 = inst_31876;
var inst_31742 = inst_31877;
var inst_31743 = inst_31878;
var state_31915__$1 = (function (){var statearr_32005 = state_31915;
(statearr_32005[(29)] = inst_31741);

(statearr_32005[(12)] = inst_31742);

(statearr_32005[(39)] = inst_31739);

(statearr_32005[(47)] = inst_31743);

(statearr_32005[(53)] = inst_31740);

return statearr_32005;
})();
var statearr_32006_32196 = state_31915__$1;
(statearr_32006_32196[(2)] = null);

(statearr_32006_32196[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (122))){
var inst_31887 = (state_31915[(16)]);
var inst_31887__$1 = (state_31915[(2)]);
var state_31915__$1 = (function (){var statearr_32007 = state_31915;
(statearr_32007[(16)] = inst_31887__$1);

return statearr_32007;
})();
if(cljs.core.truth_(inst_31887__$1)){
var statearr_32008_32197 = state_31915__$1;
(statearr_32008_32197[(1)] = (123));

} else {
var statearr_32009_32198 = state_31915__$1;
(statearr_32009_32198[(1)] = (124));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (43))){
var inst_31639 = (state_31915[(51)]);
var state_31915__$1 = state_31915;
var statearr_32010_32199 = state_31915__$1;
(statearr_32010_32199[(2)] = inst_31639);

(statearr_32010_32199[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (61))){
var inst_31552 = (state_31915[(73)]);
var state_31915__$1 = state_31915;
var statearr_32011_32200 = state_31915__$1;
(statearr_32011_32200[(2)] = inst_31552);

(statearr_32011_32200[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (29))){
var state_31915__$1 = state_31915;
var statearr_32012_32201 = state_31915__$1;
(statearr_32012_32201[(2)] = null);

(statearr_32012_32201[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (44))){
var state_31915__$1 = state_31915;
var statearr_32013_32202 = state_31915__$1;
(statearr_32013_32202[(2)] = false);

(statearr_32013_32202[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (93))){
var inst_31763 = (state_31915[(63)]);
var state_31915__$1 = state_31915;
var statearr_32014_32203 = state_31915__$1;
(statearr_32014_32203[(2)] = inst_31763);

(statearr_32014_32203[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (6))){
var inst_31553 = (state_31915[(78)]);
var inst_31558 = inst_31553.cljs$lang$protocol_mask$partition0$;
var inst_31559 = (inst_31558 & (64));
var inst_31560 = inst_31553.cljs$core$ISeq$;
var inst_31561 = (cljs.core.PROTOCOL_SENTINEL === inst_31560);
var inst_31562 = ((inst_31559) || (inst_31561));
var state_31915__$1 = state_31915;
if(cljs.core.truth_(inst_31562)){
var statearr_32015_32204 = state_31915__$1;
(statearr_32015_32204[(1)] = (9));

} else {
var statearr_32016_32205 = state_31915__$1;
(statearr_32016_32205[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (111))){
var inst_31809 = (state_31915[(9)]);
var inst_31741 = (state_31915[(29)]);
var inst_31709 = (state_31915[(32)]);
var inst_31742 = (state_31915[(12)]);
var inst_31715 = (state_31915[(13)]);
var inst_31858 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_31809,inst_31741,inst_31742,inst_31709,inst_31715);
var state_31915__$1 = state_31915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31915__$1,(119),inst_31858);
} else {
if((state_val_31916 === (28))){
var inst_31607 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
var statearr_32017_32206 = state_31915__$1;
(statearr_32017_32206[(2)] = inst_31607);

(statearr_32017_32206[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (64))){
var state_31915__$1 = state_31915;
var statearr_32018_32207 = state_31915__$1;
(statearr_32018_32207[(2)] = (2147483647));

(statearr_32018_32207[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (103))){
var inst_31782 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
var statearr_32019_32208 = state_31915__$1;
(statearr_32019_32208[(2)] = inst_31782);

(statearr_32019_32208[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (51))){
var inst_31662 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
if(cljs.core.truth_(inst_31662)){
var statearr_32020_32209 = state_31915__$1;
(statearr_32020_32209[(1)] = (52));

} else {
var statearr_32021_32210 = state_31915__$1;
(statearr_32021_32210[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (25))){
var inst_31609 = (state_31915[(76)]);
var inst_31609__$1 = (state_31915[(2)]);
var state_31915__$1 = (function (){var statearr_32022 = state_31915;
(statearr_32022[(76)] = inst_31609__$1);

return statearr_32022;
})();
if(cljs.core.truth_(inst_31609__$1)){
var statearr_32023_32211 = state_31915__$1;
(statearr_32023_32211[(1)] = (32));

} else {
var statearr_32024_32212 = state_31915__$1;
(statearr_32024_32212[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (34))){
var inst_31628 = (state_31915[(79)]);
var inst_31626 = (state_31915[(34)]);
var inst_31627 = (state_31915[(41)]);
var inst_31626__$1 = (state_31915[(2)]);
var inst_31627__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31626__$1,(0),null);
var inst_31628__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31627__$1,(0),null);
var inst_31629 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31627__$1,(1),null);
var inst_31630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31626__$1,(1),null);
var inst_31631 = fluree.db.util.core.pred_ident_QMARK_(inst_31628__$1);
var state_31915__$1 = (function (){var statearr_32025 = state_31915;
(statearr_32025[(79)] = inst_31628__$1);

(statearr_32025[(34)] = inst_31626__$1);

(statearr_32025[(41)] = inst_31627__$1);

(statearr_32025[(43)] = inst_31630);

(statearr_32025[(57)] = inst_31629);

return statearr_32025;
})();
if(inst_31631){
var statearr_32026_32213 = state_31915__$1;
(statearr_32026_32213[(1)] = (35));

} else {
var statearr_32027_32214 = state_31915__$1;
(statearr_32027_32214[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (125))){
var inst_31887 = (state_31915[(16)]);
var inst_31895 = (state_31915[(2)]);
var state_31915__$1 = (function (){var statearr_32028 = state_31915;
(statearr_32028[(81)] = inst_31895);

return statearr_32028;
})();
if(cljs.core.truth_(inst_31887)){
var statearr_32029_32215 = state_31915__$1;
(statearr_32029_32215[(1)] = (127));

} else {
var statearr_32030_32216 = state_31915__$1;
(statearr_32030_32216[(1)] = (128));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (17))){
var inst_31547 = (state_31915[(54)]);
var inst_31586 = (state_31915[(2)]);
var inst_31587 = fluree.db.util.core.pred_ident_QMARK_(inst_31547);
var state_31915__$1 = (function (){var statearr_32031 = state_31915;
(statearr_32031[(22)] = inst_31586);

return statearr_32031;
})();
if(inst_31587){
var statearr_32032_32217 = state_31915__$1;
(statearr_32032_32217[(1)] = (19));

} else {
var statearr_32033_32218 = state_31915__$1;
(statearr_32033_32218[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (3))){
var inst_31913 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31915__$1,inst_31913);
} else {
if((state_val_31916 === (12))){
var inst_31553 = (state_31915[(78)]);
var inst_31571 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31553);
var state_31915__$1 = state_31915;
var statearr_32034_32219 = state_31915__$1;
(statearr_32034_32219[(2)] = inst_31571);

(statearr_32034_32219[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (2))){
var inst_31553 = (state_31915[(78)]);
var inst_31546 = (state_31915[(28)]);
var inst_31539 = (state_31915[(44)]);
var _ = (function (){var statearr_32035 = state_31915;
(statearr_32035[(4)] = cljs.core.cons((5),(state_31915[(4)])));

return statearr_32035;
})();
var inst_31539__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_31540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,(0),null);
var inst_31541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,(1),null);
var inst_31542 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,(2),null);
var inst_31543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,(3),null);
var inst_31544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,(4),null);
var inst_31545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,(5),null);
var inst_31546__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_31547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31546__$1,(0),null);
var inst_31548 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31546__$1,(1),null);
var inst_31549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31546__$1,(2),null);
var inst_31550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31546__$1,(3),null);
var inst_31551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31546__$1,(4),null);
var inst_31552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31546__$1,(5),null);
var inst_31553__$1 = opts;
var inst_31555 = (inst_31553__$1 == null);
var inst_31556 = cljs.core.not(inst_31555);
var state_31915__$1 = (function (){var statearr_32036 = state_31915;
(statearr_32036[(17)] = inst_31551);

(statearr_32036[(73)] = inst_31552);

(statearr_32036[(65)] = inst_31540);

(statearr_32036[(78)] = inst_31553__$1);

(statearr_32036[(56)] = inst_31545);

(statearr_32036[(55)] = inst_31549);

(statearr_32036[(23)] = inst_31543);

(statearr_32036[(28)] = inst_31546__$1);

(statearr_32036[(54)] = inst_31547);

(statearr_32036[(75)] = inst_31541);

(statearr_32036[(66)] = inst_31548);

(statearr_32036[(37)] = inst_31550);

(statearr_32036[(44)] = inst_31539__$1);

(statearr_32036[(72)] = inst_31542);

(statearr_32036[(48)] = inst_31544);

return statearr_32036;
})();
if(inst_31556){
var statearr_32037_32220 = state_31915__$1;
(statearr_32037_32220[(1)] = (6));

} else {
var statearr_32038_32221 = state_31915__$1;
(statearr_32038_32221[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (66))){
var inst_31682 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
var statearr_32039_32222 = state_31915__$1;
(statearr_32039_32222[(2)] = inst_31682);

(statearr_32039_32222[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (107))){
var inst_31741 = (state_31915[(29)]);
var inst_31742 = (state_31915[(12)]);
var inst_31798 = (state_31915[(82)]);
var inst_31743 = (state_31915[(47)]);
var inst_31740 = (state_31915[(53)]);
var inst_31801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31802 = (inst_31740 - inst_31798);
var inst_31803 = [inst_31802,inst_31741,inst_31742,inst_31743];
var inst_31804 = (new cljs.core.PersistentVector(null,4,(5),inst_31801,inst_31803,null));
var state_31915__$1 = state_31915;
var statearr_32040_32223 = state_31915__$1;
(statearr_32040_32223[(2)] = inst_31804);

(statearr_32040_32223[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (23))){
var inst_31542 = (state_31915[(72)]);
var state_31915__$1 = state_31915;
var statearr_32041_32224 = state_31915__$1;
(statearr_32041_32224[(2)] = inst_31542);

(statearr_32041_32224[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (47))){
var inst_31541 = (state_31915[(75)]);
var state_31915__$1 = state_31915;
var statearr_32042_32225 = state_31915__$1;
(statearr_32042_32225[(2)] = inst_31541);

(statearr_32042_32225[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (35))){
var inst_31628 = (state_31915[(79)]);
var inst_31633 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31628);
var state_31915__$1 = state_31915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31915__$1,(38),inst_31633);
} else {
if((state_val_31916 === (127))){
var inst_31895 = (state_31915[(81)]);
var state_31915__$1 = state_31915;
var statearr_32043_32226 = state_31915__$1;
(statearr_32043_32226[(2)] = inst_31895);

(statearr_32043_32226[(1)] = (129));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (82))){
var state_31915__$1 = state_31915;
var statearr_32044_32227 = state_31915__$1;
(statearr_32044_32227[(2)] = null);

(statearr_32044_32227[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (76))){
var inst_31710 = (state_31915[(70)]);
var state_31915__$1 = state_31915;
var statearr_32045_32228 = state_31915__$1;
(statearr_32045_32228[(2)] = inst_31710);

(statearr_32045_32228[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (97))){
var inst_31716 = (state_31915[(33)]);
var inst_31739 = (state_31915[(39)]);
var inst_31775 = (state_31915[(2)]);
var inst_31776 = fluree.db.dbproto._rhs(inst_31739);
var state_31915__$1 = (function (){var statearr_32046 = state_31915;
(statearr_32046[(64)] = inst_31775);

(statearr_32046[(7)] = inst_31776);

return statearr_32046;
})();
if(cljs.core.truth_(inst_31716)){
var statearr_32047_32229 = state_31915__$1;
(statearr_32047_32229[(1)] = (98));

} else {
var statearr_32048_32230 = state_31915__$1;
(statearr_32048_32230[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (19))){
var inst_31547 = (state_31915[(54)]);
var inst_31589 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31547);
var state_31915__$1 = state_31915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31915__$1,(22),inst_31589);
} else {
if((state_val_31916 === (57))){
var inst_31552 = (state_31915[(73)]);
var inst_31675 = (state_31915[(2)]);
var state_31915__$1 = (function (){var statearr_32049 = state_31915;
(statearr_32049[(46)] = inst_31675);

return statearr_32049;
})();
if(cljs.core.truth_(inst_31552)){
var statearr_32050_32231 = state_31915__$1;
(statearr_32050_32231[(1)] = (61));

} else {
var statearr_32051_32232 = state_31915__$1;
(statearr_32051_32232[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (68))){
var state_31915__$1 = state_31915;
var statearr_32052_32233 = state_31915__$1;
(statearr_32052_32233[(2)] = false);

(statearr_32052_32233[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (11))){
var inst_31566 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
var statearr_32053_32234 = state_31915__$1;
(statearr_32053_32234[(2)] = inst_31566);

(statearr_32053_32234[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (115))){
var inst_31809 = (state_31915[(9)]);
var inst_31741 = (state_31915[(29)]);
var inst_31709 = (state_31915[(32)]);
var inst_31836 = (state_31915[(67)]);
var inst_31837 = (state_31915[(68)]);
var inst_31835 = (state_31915[(69)]);
var inst_31831 = (state_31915[(2)]);
var inst_31832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31831,(0),null);
var inst_31833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31831,(1),null);
var inst_31834 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_31833,inst_31809);
var inst_31835__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_31834);
var inst_31836__$1 = cljs.core.count(inst_31835__$1);
var inst_31837__$1 = (inst_31741 + inst_31836__$1);
var inst_31838 = (inst_31837__$1 > inst_31709);
var state_31915__$1 = (function (){var statearr_32055 = state_31915;
(statearr_32055[(80)] = inst_31832);

(statearr_32055[(67)] = inst_31836__$1);

(statearr_32055[(68)] = inst_31837__$1);

(statearr_32055[(69)] = inst_31835__$1);

return statearr_32055;
})();
if(cljs.core.truth_(inst_31838)){
var statearr_32056_32235 = state_31915__$1;
(statearr_32056_32235[(1)] = (116));

} else {
var statearr_32057_32236 = state_31915__$1;
(statearr_32057_32236[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (9))){
var state_31915__$1 = state_31915;
var statearr_32058_32237 = state_31915__$1;
(statearr_32058_32237[(2)] = true);

(statearr_32058_32237[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (5))){
var _ = (function (){var statearr_32059 = state_31915;
(statearr_32059[(4)] = cljs.core.rest((state_31915[(4)])));

return statearr_32059;
})();
var state_31915__$1 = state_31915;
var ex32054 = (state_31915__$1[(2)]);
var statearr_32060_32238 = state_31915__$1;
(statearr_32060_32238[(5)] = ex32054);


if((ex32054 instanceof Error)){
var statearr_32061_32239 = state_31915__$1;
(statearr_32061_32239[(1)] = (4));

(statearr_32061_32239[(5)] = null);

} else {
throw ex32054;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (112))){
var inst_31743 = (state_31915[(47)]);
var inst_31863 = (state_31915[(2)]);
var inst_31864 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31863,(0),null);
var inst_31865 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31863,(1),null);
var inst_31866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31863,(2),null);
var inst_31867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31868 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31743,inst_31866);
var inst_31869 = [(0),inst_31864,inst_31865,inst_31868];
var inst_31870 = (new cljs.core.PersistentVector(null,4,(5),inst_31867,inst_31869,null));
var state_31915__$1 = state_31915;
var statearr_32062_32240 = state_31915__$1;
(statearr_32062_32240[(2)] = inst_31870);

(statearr_32062_32240[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (83))){
var inst_31910 = (state_31915[(2)]);
var _ = (function (){var statearr_32063 = state_31915;
(statearr_32063[(4)] = cljs.core.rest((state_31915[(4)])));

return statearr_32063;
})();
var state_31915__$1 = state_31915;
var statearr_32064_32241 = state_31915__$1;
(statearr_32064_32241[(2)] = inst_31910);

(statearr_32064_32241[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (14))){
var inst_31540 = (state_31915[(65)]);
var inst_31574 = (state_31915[(52)]);
var inst_31574__$1 = (state_31915[(2)]);
var inst_31575 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31574__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_31576 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31574__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_31577 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31574__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_31578 = fluree.db.util.core.pred_ident_QMARK_(inst_31540);
var state_31915__$1 = (function (){var statearr_32065 = state_31915;
(statearr_32065[(18)] = inst_31576);

(statearr_32065[(74)] = inst_31577);

(statearr_32065[(25)] = inst_31575);

(statearr_32065[(52)] = inst_31574__$1);

return statearr_32065;
})();
if(inst_31578){
var statearr_32066_32242 = state_31915__$1;
(statearr_32066_32242[(1)] = (15));

} else {
var statearr_32067_32243 = state_31915__$1;
(statearr_32067_32243[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (45))){
var inst_31653 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
if(cljs.core.truth_(inst_31653)){
var statearr_32068_32244 = state_31915__$1;
(statearr_32068_32244[(1)] = (46));

} else {
var statearr_32069_32245 = state_31915__$1;
(statearr_32069_32245[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (53))){
var inst_31548 = (state_31915[(66)]);
var state_31915__$1 = state_31915;
var statearr_32070_32246 = state_31915__$1;
(statearr_32070_32246[(2)] = inst_31548);

(statearr_32070_32246[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (78))){
var inst_31715 = (state_31915[(13)]);
var inst_31715__$1 = (state_31915[(2)]);
var inst_31716 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31715__$1,fluree.db.util.core.max_long);
var inst_31717 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_31718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31719 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_31720 = (new cljs.core.PersistentVector(null,3,(5),inst_31718,inst_31719,null));
var inst_31721 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_31720);
var inst_31722 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_31723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31724 = [cljs.core.cst$kw$novelty,idx];
var inst_31725 = (new cljs.core.PersistentVector(null,2,(5),inst_31723,inst_31724,null));
var inst_31726 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_31725);
var inst_31727 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_31728 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_31729 = fluree.db.dbproto._resolve(inst_31728);
var state_31915__$1 = (function (){var statearr_32071 = state_31915;
(statearr_32071[(21)] = inst_31722);

(statearr_32071[(31)] = inst_31721);

(statearr_32071[(33)] = inst_31716);

(statearr_32071[(35)] = inst_31717);

(statearr_32071[(13)] = inst_31715__$1);

(statearr_32071[(42)] = inst_31727);

(statearr_32071[(49)] = inst_31726);

return statearr_32071;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31915__$1,(79),inst_31729);
} else {
if((state_val_31916 === (132))){
var inst_31905 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
var statearr_32072_32247 = state_31915__$1;
(statearr_32072_32247[(2)] = inst_31905);

(statearr_32072_32247[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (26))){
var inst_31549 = (state_31915[(55)]);
var state_31915__$1 = state_31915;
var statearr_32073_32248 = state_31915__$1;
(statearr_32073_32248[(2)] = inst_31549);

(statearr_32073_32248[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (123))){
var inst_31722 = (state_31915[(21)]);
var inst_31732 = (state_31915[(24)]);
var inst_31727 = (state_31915[(42)]);
var inst_31776 = (state_31915[(7)]);
var inst_31726 = (state_31915[(49)]);
var inst_31889 = fluree.db.query.range.find_next_valid_node(inst_31732,inst_31776,inst_31722,inst_31726,inst_31727);
var state_31915__$1 = state_31915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31915__$1,(126),inst_31889);
} else {
if((state_val_31916 === (16))){
var inst_31540 = (state_31915[(65)]);
var state_31915__$1 = state_31915;
var statearr_32074_32249 = state_31915__$1;
(statearr_32074_32249[(2)] = inst_31540);

(statearr_32074_32249[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (81))){
var inst_31736 = (state_31915[(27)]);
var inst_31711 = (state_31915[(71)]);
var inst_31738 = cljs.core.PersistentVector.EMPTY;
var inst_31739 = inst_31736;
var inst_31740 = inst_31711;
var inst_31741 = (0);
var inst_31742 = (0);
var inst_31743 = inst_31738;
var state_31915__$1 = (function (){var statearr_32075 = state_31915;
(statearr_32075[(29)] = inst_31741);

(statearr_32075[(12)] = inst_31742);

(statearr_32075[(39)] = inst_31739);

(statearr_32075[(47)] = inst_31743);

(statearr_32075[(53)] = inst_31740);

return statearr_32075;
})();
var statearr_32076_32250 = state_31915__$1;
(statearr_32076_32250[(2)] = null);

(statearr_32076_32250[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (120))){
var inst_31721 = (state_31915[(31)]);
var inst_31709 = (state_31915[(32)]);
var inst_31877 = (state_31915[(60)]);
var inst_31715 = (state_31915[(13)]);
var inst_31876 = (state_31915[(61)]);
var inst_31776 = (state_31915[(7)]);
var inst_31686 = (state_31915[(50)]);
var inst_31880 = (inst_31721.cljs$core$IFn$_invoke$arity$2 ? inst_31721.cljs$core$IFn$_invoke$arity$2(inst_31776,inst_31686) : inst_31721.call(null,inst_31776,inst_31686));
var inst_31881 = (inst_31880 < (0));
var inst_31882 = (inst_31876 < inst_31709);
var inst_31883 = (inst_31877 < inst_31715);
var inst_31884 = ((inst_31881) && (inst_31882) && (inst_31883));
var state_31915__$1 = state_31915;
var statearr_32077_32251 = state_31915__$1;
(statearr_32077_32251[(2)] = inst_31884);

(statearr_32077_32251[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (79))){
var inst_31722 = (state_31915[(21)]);
var inst_31732 = (state_31915[(24)]);
var inst_31685 = (state_31915[(38)]);
var inst_31727 = (state_31915[(42)]);
var inst_31726 = (state_31915[(49)]);
var inst_31731 = (state_31915[(2)]);
var inst_31732__$1 = fluree.db.util.async.throw_err(inst_31731);
var inst_31733 = fluree.db.query.range.find_next_valid_node(inst_31732__$1,inst_31685,inst_31722,inst_31726,inst_31727);
var state_31915__$1 = (function (){var statearr_32078 = state_31915;
(statearr_32078[(24)] = inst_31732__$1);

return statearr_32078;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31915__$1,(80),inst_31733);
} else {
if((state_val_31916 === (38))){
var inst_31635 = (state_31915[(2)]);
var inst_31636 = fluree.db.util.async.throw_err(inst_31635);
var state_31915__$1 = state_31915;
var statearr_32079_32252 = state_31915__$1;
(statearr_32079_32252[(2)] = inst_31636);

(statearr_32079_32252[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (126))){
var inst_31891 = (state_31915[(2)]);
var inst_31892 = fluree.db.util.async.throw_err(inst_31891);
var state_31915__$1 = state_31915;
var statearr_32080_32253 = state_31915__$1;
(statearr_32080_32253[(2)] = inst_31892);

(statearr_32080_32253[(1)] = (125));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (98))){
var inst_31740 = (state_31915[(53)]);
var inst_31778 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_31740);
var state_31915__$1 = state_31915;
if(inst_31778){
var statearr_32081_32254 = state_31915__$1;
(statearr_32081_32254[(1)] = (101));

} else {
var statearr_32082_32255 = state_31915__$1;
(statearr_32082_32255[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (124))){
var state_31915__$1 = state_31915;
var statearr_32083_32256 = state_31915__$1;
(statearr_32083_32256[(2)] = null);

(statearr_32083_32256[(1)] = (125));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (87))){
var inst_31749 = (state_31915[(26)]);
var state_31915__$1 = state_31915;
var statearr_32084_32257 = state_31915__$1;
(statearr_32084_32257[(2)] = inst_31749);

(statearr_32084_32257[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (30))){
var state_31915__$1 = state_31915;
var statearr_32085_32258 = state_31915__$1;
(statearr_32085_32258[(2)] = null);

(statearr_32085_32258[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (73))){
var inst_31687 = (state_31915[(8)]);
var inst_31705 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31687);
var state_31915__$1 = state_31915;
var statearr_32086_32259 = state_31915__$1;
(statearr_32086_32259[(2)] = inst_31705);

(statearr_32086_32259[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (96))){
var inst_31769 = (state_31915[(62)]);
var state_31915__$1 = state_31915;
var statearr_32087_32260 = state_31915__$1;
(statearr_32087_32260[(2)] = inst_31769);

(statearr_32087_32260[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (10))){
var state_31915__$1 = state_31915;
var statearr_32088_32261 = state_31915__$1;
(statearr_32088_32261[(2)] = false);

(statearr_32088_32261[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (18))){
var inst_31582 = (state_31915[(2)]);
var inst_31583 = fluree.db.util.async.throw_err(inst_31582);
var state_31915__$1 = state_31915;
var statearr_32089_32262 = state_31915__$1;
(statearr_32089_32262[(2)] = inst_31583);

(statearr_32089_32262[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (105))){
var inst_31551 = (state_31915[(17)]);
var inst_31576 = (state_31915[(18)]);
var inst_31657 = (state_31915[(19)]);
var inst_31797 = (state_31915[(77)]);
var inst_31708 = (state_31915[(20)]);
var inst_31722 = (state_31915[(21)]);
var inst_31586 = (state_31915[(22)]);
var inst_31543 = (state_31915[(23)]);
var inst_31732 = (state_31915[(24)]);
var inst_31575 = (state_31915[(25)]);
var inst_31749 = (state_31915[(26)]);
var inst_31736 = (state_31915[(27)]);
var inst_31546 = (state_31915[(28)]);
var inst_31741 = (state_31915[(29)]);
var inst_31595 = (state_31915[(30)]);
var inst_31721 = (state_31915[(31)]);
var inst_31709 = (state_31915[(32)]);
var inst_31716 = (state_31915[(33)]);
var inst_31742 = (state_31915[(12)]);
var inst_31626 = (state_31915[(34)]);
var inst_31717 = (state_31915[(35)]);
var inst_31775 = (state_31915[(64)]);
var inst_31715 = (state_31915[(13)]);
var inst_31648 = (state_31915[(36)]);
var inst_31550 = (state_31915[(37)]);
var inst_31685 = (state_31915[(38)]);
var inst_31739 = (state_31915[(39)]);
var inst_31798 = (state_31915[(82)]);
var inst_31666 = (state_31915[(40)]);
var inst_31627 = (state_31915[(41)]);
var inst_31727 = (state_31915[(42)]);
var inst_31630 = (state_31915[(43)]);
var inst_31776 = (state_31915[(7)]);
var inst_31539 = (state_31915[(44)]);
var inst_31684 = (state_31915[(45)]);
var inst_31675 = (state_31915[(46)]);
var inst_31743 = (state_31915[(47)]);
var inst_31544 = (state_31915[(48)]);
var inst_31726 = (state_31915[(49)]);
var inst_31686 = (state_31915[(50)]);
var inst_31639 = (state_31915[(51)]);
var inst_31574 = (state_31915[(52)]);
var inst_31740 = (state_31915[(53)]);
var inst_31796 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_31775;
var t = inst_31722;
var max_limit_QMARK_ = inst_31716;
var next_node = inst_31739;
var fast_forward_db_QMARK_ = inst_31727;
var s1 = inst_31586;
var o2 = inst_31648;
var t1 = inst_31543;
var map__31538 = inst_31708;
var predicate_fn = inst_31576;
var i = inst_31741;
var rhs = inst_31776;
var m1 = inst_31675;
var root_node = inst_31732;
var s2 = inst_31595;
var vec__31532 = inst_31626;
var p2 = inst_31666;
var permissions = inst_31717;
var limit = inst_31715;
var start_flake = inst_31685;
var map__31531 = inst_31574;
var flake_limit = inst_31709;
var offset = inst_31740;
var acc = inst_31743;
var vec__31528 = inst_31546;
var vec__31535 = inst_31627;
var t2 = inst_31550;
var op1 = inst_31544;
var o1 = inst_31639;
var end_flake = inst_31686;
var base_result = inst_31749;
var s = inst_31742;
var node_start = inst_31736;
var p1 = inst_31657;
var subject_fn = inst_31575;
var object_fn = inst_31630;
var vec__31525 = inst_31539;
var idx_compare = inst_31721;
var op2 = inst_31551;
var m2 = inst_31684;
var novelty = inst_31726;
return (function (p1__31510_SHARP_){
return p1__31510_SHARP_.s;
});
})();
var inst_31797__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_31796,inst_31775);
var inst_31798__$1 = cljs.core.count(inst_31797__$1);
var inst_31799 = (inst_31740 > inst_31798__$1);
var state_31915__$1 = (function (){var statearr_32090 = state_31915;
(statearr_32090[(77)] = inst_31797__$1);

(statearr_32090[(82)] = inst_31798__$1);

return statearr_32090;
})();
if(cljs.core.truth_(inst_31799)){
var statearr_32091_32263 = state_31915__$1;
(statearr_32091_32263[(1)] = (107));

} else {
var statearr_32092_32264 = state_31915__$1;
(statearr_32092_32264[(1)] = (108));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (52))){
var state_31915__$1 = state_31915;
var statearr_32093_32265 = state_31915__$1;
(statearr_32093_32265[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_32093_32265[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (114))){
var inst_31818 = (state_31915[(10)]);
var inst_31827 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31828 = [inst_31818,inst_31818];
var inst_31829 = (new cljs.core.PersistentVector(null,2,(5),inst_31827,inst_31828,null));
var state_31915__$1 = state_31915;
var statearr_32094_32266 = state_31915__$1;
(statearr_32094_32266[(2)] = inst_31829);

(statearr_32094_32266[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (67))){
var inst_31687 = (state_31915[(8)]);
var inst_31692 = inst_31687.cljs$lang$protocol_mask$partition0$;
var inst_31693 = (inst_31692 & (64));
var inst_31694 = inst_31687.cljs$core$ISeq$;
var inst_31695 = (cljs.core.PROTOCOL_SENTINEL === inst_31694);
var inst_31696 = ((inst_31693) || (inst_31695));
var state_31915__$1 = state_31915;
if(cljs.core.truth_(inst_31696)){
var statearr_32095_32267 = state_31915__$1;
(statearr_32095_32267[(1)] = (70));

} else {
var statearr_32096_32268 = state_31915__$1;
(statearr_32096_32268[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (71))){
var state_31915__$1 = state_31915;
var statearr_32097_32269 = state_31915__$1;
(statearr_32097_32269[(2)] = false);

(statearr_32097_32269[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (42))){
var inst_31644 = (state_31915[(2)]);
var inst_31645 = fluree.db.util.async.throw_err(inst_31644);
var state_31915__$1 = state_31915;
var statearr_32098_32270 = state_31915__$1;
(statearr_32098_32270[(2)] = inst_31645);

(statearr_32098_32270[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (80))){
var inst_31736 = (state_31915[(27)]);
var inst_31735 = (state_31915[(2)]);
var inst_31736__$1 = fluree.db.util.async.throw_err(inst_31735);
var state_31915__$1 = (function (){var statearr_32099 = state_31915;
(statearr_32099[(27)] = inst_31736__$1);

return statearr_32099;
})();
if(cljs.core.truth_(inst_31736__$1)){
var statearr_32100_32271 = state_31915__$1;
(statearr_32100_32271[(1)] = (81));

} else {
var statearr_32101_32272 = state_31915__$1;
(statearr_32101_32272[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (37))){
var inst_31629 = (state_31915[(57)]);
var inst_31639 = (state_31915[(2)]);
var inst_31640 = fluree.db.util.core.pred_ident_QMARK_(inst_31629);
var state_31915__$1 = (function (){var statearr_32102 = state_31915;
(statearr_32102[(51)] = inst_31639);

return statearr_32102;
})();
if(inst_31640){
var statearr_32103_32273 = state_31915__$1;
(statearr_32103_32273[(1)] = (39));

} else {
var statearr_32104_32274 = state_31915__$1;
(statearr_32104_32274[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (63))){
var inst_31551 = (state_31915[(17)]);
var inst_31657 = (state_31915[(19)]);
var inst_31586 = (state_31915[(22)]);
var inst_31543 = (state_31915[(23)]);
var inst_31595 = (state_31915[(30)]);
var inst_31687 = (state_31915[(8)]);
var inst_31648 = (state_31915[(36)]);
var inst_31550 = (state_31915[(37)]);
var inst_31666 = (state_31915[(40)]);
var inst_31684 = (state_31915[(45)]);
var inst_31675 = (state_31915[(46)]);
var inst_31544 = (state_31915[(48)]);
var inst_31639 = (state_31915[(51)]);
var inst_31684__$1 = (state_31915[(2)]);
var inst_31685 = fluree.db.flake.__GT_Flake(inst_31586,inst_31657,inst_31639,inst_31543,inst_31544,inst_31675);
var inst_31686 = fluree.db.flake.__GT_Flake(inst_31595,inst_31666,inst_31648,inst_31550,inst_31551,inst_31684__$1);
var inst_31687__$1 = opts;
var inst_31689 = (inst_31687__$1 == null);
var inst_31690 = cljs.core.not(inst_31689);
var state_31915__$1 = (function (){var statearr_32105 = state_31915;
(statearr_32105[(8)] = inst_31687__$1);

(statearr_32105[(38)] = inst_31685);

(statearr_32105[(45)] = inst_31684__$1);

(statearr_32105[(50)] = inst_31686);

return statearr_32105;
})();
if(inst_31690){
var statearr_32106_32275 = state_31915__$1;
(statearr_32106_32275[(1)] = (67));

} else {
var statearr_32107_32276 = state_31915__$1;
(statearr_32107_32276[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (94))){
var inst_31630 = (state_31915[(43)]);
var inst_31769 = (state_31915[(2)]);
var state_31915__$1 = (function (){var statearr_32108 = state_31915;
(statearr_32108[(62)] = inst_31769);

return statearr_32108;
})();
if(cljs.core.truth_(inst_31630)){
var statearr_32109_32277 = state_31915__$1;
(statearr_32109_32277[(1)] = (95));

} else {
var statearr_32110_32278 = state_31915__$1;
(statearr_32110_32278[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (8))){
var inst_31569 = (state_31915[(2)]);
var state_31915__$1 = state_31915;
if(cljs.core.truth_(inst_31569)){
var statearr_32111_32279 = state_31915__$1;
(statearr_32111_32279[(1)] = (12));

} else {
var statearr_32112_32280 = state_31915__$1;
(statearr_32112_32280[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (49))){
var inst_31648 = (state_31915[(36)]);
var state_31915__$1 = state_31915;
var statearr_32113_32281 = state_31915__$1;
(statearr_32113_32281[(2)] = inst_31648);

(statearr_32113_32281[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31916 === (84))){
var inst_31685 = (state_31915[(38)]);
var inst_31739 = (state_31915[(39)]);
var inst_31686 = (state_31915[(50)]);
var inst_31748 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_31739);
var inst_31749 = fluree.db.flake.subrange(inst_31748,start_test,inst_31685,end_test,inst_31686);
var inst_31751 = fluree.db.query.range.value_with_nil_pred(idx,inst_31685,inst_31686);
var state_31915__$1 = (function (){var statearr_32114 = state_31915;
(statearr_32114[(26)] = inst_31749);

return statearr_32114;
})();
if(inst_31751){
var statearr_32115_32282 = state_31915__$1;
(statearr_32115_32282[(1)] = (86));

} else {
var statearr_32116_32283 = state_31915__$1;
(statearr_32116_32283[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16301__auto__ = null;
var fluree$db$query$range$state_machine__16301__auto____0 = (function (){
var statearr_32117 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32117[(0)] = fluree$db$query$range$state_machine__16301__auto__);

(statearr_32117[(1)] = (1));

return statearr_32117;
});
var fluree$db$query$range$state_machine__16301__auto____1 = (function (state_31915){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31915);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e32118){var ex__16304__auto__ = e32118;
var statearr_32119_32284 = state_31915;
(statearr_32119_32284[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31915[(4)]))){
var statearr_32120_32285 = state_31915;
(statearr_32120_32285[(1)] = cljs.core.first((state_31915[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__32286 = state_31915;
state_31915 = G__32286;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16301__auto__ = function(state_31915){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16301__auto____1.call(this,state_31915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16301__auto____0;
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16301__auto____1;
return fluree$db$query$range$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_32121 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_32121[(6)] = c__16375__auto__);

return statearr_32121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_32342){
var state_val_32343 = (state_32342[(1)]);
if((state_val_32343 === (7))){
var inst_32306 = (state_32342[(7)]);
var inst_32316 = (state_32342[(8)]);
var inst_32314 = fluree.db.flake.Flake__GT_parts(inst_32306);
var inst_32315 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32314,(0),null);
var inst_32316__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32314,(1),null);
var inst_32317 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32314,(2),null);
var inst_32318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32314,(3),null);
var inst_32319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32314,(4),null);
var inst_32320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32314,(5),null);
var inst_32321 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_32317,inst_32316__$1);
var state_32342__$1 = (function (){var statearr_32344 = state_32342;
(statearr_32344[(9)] = inst_32320);

(statearr_32344[(10)] = inst_32319);

(statearr_32344[(8)] = inst_32316__$1);

(statearr_32344[(11)] = inst_32318);

(statearr_32344[(12)] = inst_32315);

return statearr_32344;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32342__$1,(10),inst_32321);
} else {
if((state_val_32343 === (1))){
var inst_32294 = flakes;
var inst_32295 = cljs.core.seq(inst_32294);
var inst_32296 = cljs.core.first(inst_32295);
var inst_32297 = cljs.core.next(inst_32295);
var inst_32298 = cljs.core.PersistentVector.EMPTY;
var inst_32299 = inst_32294;
var inst_32300 = inst_32298;
var state_32342__$1 = (function (){var statearr_32345 = state_32342;
(statearr_32345[(13)] = inst_32297);

(statearr_32345[(14)] = inst_32300);

(statearr_32345[(15)] = inst_32299);

(statearr_32345[(16)] = inst_32296);

return statearr_32345;
})();
var statearr_32346_32364 = state_32342__$1;
(statearr_32346_32364[(2)] = null);

(statearr_32346_32364[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32343 === (4))){
var inst_32306 = (state_32342[(7)]);
var inst_32309 = fluree.db.query.range.is_tag_flake_QMARK_(inst_32306);
var state_32342__$1 = state_32342;
if(inst_32309){
var statearr_32347_32365 = state_32342__$1;
(statearr_32347_32365[(1)] = (7));

} else {
var statearr_32348_32366 = state_32342__$1;
(statearr_32348_32366[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32343 === (6))){
var inst_32338 = (state_32342[(2)]);
var state_32342__$1 = state_32342;
var statearr_32349_32367 = state_32342__$1;
(statearr_32349_32367[(2)] = inst_32338);

(statearr_32349_32367[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32343 === (3))){
var inst_32340 = (state_32342[(2)]);
var state_32342__$1 = state_32342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32342__$1,inst_32340);
} else {
if((state_val_32343 === (2))){
var inst_32299 = (state_32342[(15)]);
var inst_32306 = (state_32342[(7)]);
var inst_32305 = cljs.core.seq(inst_32299);
var inst_32306__$1 = cljs.core.first(inst_32305);
var inst_32307 = cljs.core.next(inst_32305);
var state_32342__$1 = (function (){var statearr_32350 = state_32342;
(statearr_32350[(7)] = inst_32306__$1);

(statearr_32350[(17)] = inst_32307);

return statearr_32350;
})();
if(cljs.core.truth_(inst_32306__$1)){
var statearr_32351_32368 = state_32342__$1;
(statearr_32351_32368[(1)] = (4));

} else {
var statearr_32352_32369 = state_32342__$1;
(statearr_32352_32369[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32343 === (9))){
var inst_32335 = (state_32342[(2)]);
var state_32342__$1 = state_32342;
var statearr_32353_32370 = state_32342__$1;
(statearr_32353_32370[(2)] = inst_32335);

(statearr_32353_32370[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32343 === (5))){
var inst_32300 = (state_32342[(14)]);
var state_32342__$1 = state_32342;
var statearr_32354_32371 = state_32342__$1;
(statearr_32354_32371[(2)] = inst_32300);

(statearr_32354_32371[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32343 === (10))){
var inst_32300 = (state_32342[(14)]);
var inst_32320 = (state_32342[(9)]);
var inst_32319 = (state_32342[(10)]);
var inst_32316 = (state_32342[(8)]);
var inst_32318 = (state_32342[(11)]);
var inst_32315 = (state_32342[(12)]);
var inst_32307 = (state_32342[(17)]);
var inst_32323 = (state_32342[(2)]);
var inst_32324 = fluree.db.util.async.throw_err(inst_32323);
var inst_32325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32326 = [inst_32315,inst_32316,inst_32324,inst_32318,inst_32319,inst_32320];
var inst_32327 = (new cljs.core.PersistentVector(null,6,(5),inst_32325,inst_32326,null));
var inst_32328 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_32327);
var inst_32329 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32300,inst_32328);
var inst_32299 = inst_32307;
var inst_32300__$1 = inst_32329;
var state_32342__$1 = (function (){var statearr_32355 = state_32342;
(statearr_32355[(14)] = inst_32300__$1);

(statearr_32355[(15)] = inst_32299);

return statearr_32355;
})();
var statearr_32356_32372 = state_32342__$1;
(statearr_32356_32372[(2)] = null);

(statearr_32356_32372[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32343 === (8))){
var inst_32300 = (state_32342[(14)]);
var inst_32306 = (state_32342[(7)]);
var inst_32307 = (state_32342[(17)]);
var inst_32332 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32300,inst_32306);
var inst_32299 = inst_32307;
var inst_32300__$1 = inst_32332;
var state_32342__$1 = (function (){var statearr_32357 = state_32342;
(statearr_32357[(14)] = inst_32300__$1);

(statearr_32357[(15)] = inst_32299);

return statearr_32357;
})();
var statearr_32358_32373 = state_32342__$1;
(statearr_32358_32373[(2)] = null);

(statearr_32358_32373[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____0 = (function (){
var statearr_32359 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32359[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__);

(statearr_32359[(1)] = (1));

return statearr_32359;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____1 = (function (state_32342){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_32342);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e32360){var ex__16304__auto__ = e32360;
var statearr_32361_32374 = state_32342;
(statearr_32361_32374[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_32342[(4)]))){
var statearr_32362_32375 = state_32342;
(statearr_32362_32375[(1)] = cljs.core.first((state_32342[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__32376 = state_32342;
state_32342 = G__32376;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__ = function(state_32342){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____1.call(this,state_32342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_32363 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_32363[(6)] = c__16375__auto__);

return statearr_32363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__32378 = arguments.length;
switch (G__32378) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_32529){
var state_val_32530 = (state_32529[(1)]);
if((state_val_32530 === (62))){
var inst_32516 = (state_32529[(7)]);
var state_32529__$1 = state_32529;
var statearr_32531_32620 = state_32529__$1;
(statearr_32531_32620[(2)] = inst_32516);

(statearr_32531_32620[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (7))){
var state_32529__$1 = state_32529;
var statearr_32532_32621 = state_32529__$1;
(statearr_32532_32621[(2)] = false);

(statearr_32532_32621[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (59))){
var inst_32508 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
var statearr_32533_32622 = state_32529__$1;
(statearr_32533_32622[(2)] = inst_32508);

(statearr_32533_32622[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (20))){
var state_32529__$1 = state_32529;
var statearr_32534_32623 = state_32529__$1;
(statearr_32534_32623[(2)] = null);

(statearr_32534_32623[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (58))){
var state_32529__$1 = state_32529;
var statearr_32535_32624 = state_32529__$1;
(statearr_32535_32624[(2)] = null);

(statearr_32535_32624[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (60))){
var inst_32504 = (state_32529[(2)]);
var inst_32505 = fluree.db.util.async.throw_err(inst_32504);
var state_32529__$1 = state_32529;
var statearr_32536_32625 = state_32529__$1;
(statearr_32536_32625[(2)] = inst_32505);

(statearr_32536_32625[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (27))){
var inst_32429 = (state_32529[(8)]);
var inst_32440 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_32429);
var state_32529__$1 = state_32529;
if(inst_32440){
var statearr_32537_32626 = state_32529__$1;
(statearr_32537_32626[(1)] = (30));

} else {
var statearr_32538_32627 = state_32529__$1;
(statearr_32538_32627[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (1))){
var state_32529__$1 = state_32529;
var statearr_32539_32628 = state_32529__$1;
(statearr_32539_32628[(2)] = null);

(statearr_32539_32628[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (24))){
var inst_32390 = (state_32529[(9)]);
var state_32529__$1 = state_32529;
if(cljs.core.truth_(inst_32390)){
var statearr_32540_32629 = state_32529__$1;
(statearr_32540_32629[(1)] = (27));

} else {
var statearr_32541_32630 = state_32529__$1;
(statearr_32541_32630[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (55))){
var inst_32510 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
var statearr_32542_32631 = state_32529__$1;
(statearr_32542_32631[(2)] = inst_32510);

(statearr_32542_32631[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (39))){
var inst_32460 = (state_32529[(2)]);
var inst_32461 = fluree.db.util.async.throw_err(inst_32460);
var state_32529__$1 = state_32529;
var statearr_32543_32632 = state_32529__$1;
(statearr_32543_32632[(2)] = inst_32461);

(statearr_32543_32632[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (46))){
var inst_32473 = (state_32529[(10)]);
var inst_32473__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_32529__$1 = (function (){var statearr_32544 = state_32529;
(statearr_32544[(10)] = inst_32473__$1);

return statearr_32544;
})();
if(cljs.core.truth_(inst_32473__$1)){
var statearr_32545_32633 = state_32529__$1;
(statearr_32545_32633[(1)] = (49));

} else {
var statearr_32546_32634 = state_32529__$1;
(statearr_32546_32634[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (4))){
var inst_32379 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
var statearr_32547_32635 = state_32529__$1;
(statearr_32547_32635[(2)] = inst_32379);

(statearr_32547_32635[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (54))){
var inst_32429 = (state_32529[(8)]);
var state_32529__$1 = state_32529;
if(cljs.core.truth_(inst_32429)){
var statearr_32548_32636 = state_32529__$1;
(statearr_32548_32636[(1)] = (57));

} else {
var statearr_32549_32637 = state_32529__$1;
(statearr_32549_32637[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (15))){
var inst_32391 = (state_32529[(11)]);
var inst_32410 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_32391);
var state_32529__$1 = state_32529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32529__$1,(18),inst_32410);
} else {
if((state_val_32530 === (48))){
var inst_32512 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
var statearr_32550_32638 = state_32529__$1;
(statearr_32550_32638[(2)] = inst_32512);

(statearr_32550_32638[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (50))){
var inst_32388 = (state_32529[(12)]);
var inst_32399 = (state_32529[(13)]);
var inst_32473 = (state_32529[(10)]);
var inst_32393 = (state_32529[(14)]);
var inst_32404 = (state_32529[(15)]);
var inst_32390 = (state_32529[(9)]);
var inst_32392 = (state_32529[(16)]);
var inst_32389 = (state_32529[(17)]);
var inst_32429 = (state_32529[(8)]);
var inst_32477 = (function (){var t = inst_32392;
var temp__5733__auto__ = inst_32473;
var p = inst_32390;
var vec__32385 = inst_32388;
var idx_predicate_QMARK_ = inst_32393;
var o = inst_32429;
var tag_predicate_QMARK_ = inst_32399;
var s = inst_32389;
var o_coerce_QMARK_ = inst_32404;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_32529__$1 = state_32529;
var statearr_32551_32639 = state_32529__$1;
(statearr_32551_32639[(2)] = inst_32477);

(statearr_32551_32639[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (21))){
var inst_32425 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
var statearr_32552_32640 = state_32529__$1;
(statearr_32552_32640[(2)] = inst_32425);

(statearr_32552_32640[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (31))){
var state_32529__$1 = state_32529;
var statearr_32553_32641 = state_32529__$1;
(statearr_32553_32641[(2)] = false);

(statearr_32553_32641[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (32))){
var inst_32450 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
var statearr_32554_32642 = state_32529__$1;
(statearr_32554_32642[(2)] = inst_32450);

(statearr_32554_32642[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (40))){
var inst_32393 = (state_32529[(14)]);
var inst_32464 = cljs.core.not(inst_32393);
var state_32529__$1 = state_32529;
if(inst_32464){
var statearr_32555_32643 = state_32529__$1;
(statearr_32555_32643[(1)] = (43));

} else {
var statearr_32556_32644 = state_32529__$1;
(statearr_32556_32644[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (56))){
var inst_32495 = (state_32529[(2)]);
var inst_32496 = fluree.db.util.async.throw_err(inst_32495);
var state_32529__$1 = state_32529;
var statearr_32557_32645 = state_32529__$1;
(statearr_32557_32645[(2)] = inst_32496);

(statearr_32557_32645[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (33))){
var inst_32429 = (state_32529[(8)]);
var inst_32443 = cljs.core.fn_QMARK_(inst_32429);
var inst_32444 = (!(inst_32443));
var state_32529__$1 = state_32529;
var statearr_32558_32646 = state_32529__$1;
(statearr_32558_32646[(2)] = inst_32444);

(statearr_32558_32646[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (13))){
var inst_32391 = (state_32529[(11)]);
var inst_32408 = fluree.db.query.range.tag_string_QMARK_(inst_32391);
var state_32529__$1 = state_32529;
if(cljs.core.truth_(inst_32408)){
var statearr_32559_32647 = state_32529__$1;
(statearr_32559_32647[(1)] = (15));

} else {
var statearr_32560_32648 = state_32529__$1;
(statearr_32560_32648[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (22))){
var inst_32421 = (state_32529[(2)]);
var inst_32422 = fluree.db.util.async.throw_err(inst_32421);
var state_32529__$1 = state_32529;
var statearr_32561_32649 = state_32529__$1;
(statearr_32561_32649[(2)] = inst_32422);

(statearr_32561_32649[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (36))){
var inst_32390 = (state_32529[(9)]);
var inst_32392 = (state_32529[(16)]);
var inst_32389 = (state_32529[(17)]);
var inst_32429 = (state_32529[(8)]);
var inst_32455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32456 = [inst_32390,inst_32429,inst_32389,inst_32392];
var inst_32457 = (new cljs.core.PersistentVector(null,4,(5),inst_32455,inst_32456,null));
var inst_32458 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_32457,opts);
var state_32529__$1 = state_32529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32529__$1,(39),inst_32458);
} else {
if((state_val_32530 === (41))){
var inst_32390 = (state_32529[(9)]);
var state_32529__$1 = state_32529;
var statearr_32562_32650 = state_32529__$1;
(statearr_32562_32650[(2)] = inst_32390);

(statearr_32562_32650[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (43))){
var inst_32429 = (state_32529[(8)]);
var state_32529__$1 = state_32529;
var statearr_32563_32651 = state_32529__$1;
(statearr_32563_32651[(2)] = inst_32429);

(statearr_32563_32651[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (61))){
var inst_32516 = (state_32529[(7)]);
var inst_32518 = fluree.db.query.range.coerce_tag_flakes(db,inst_32516);
var state_32529__$1 = state_32529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32529__$1,(64),inst_32518);
} else {
if((state_val_32530 === (29))){
var inst_32453 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
if(cljs.core.truth_(inst_32453)){
var statearr_32564_32652 = state_32529__$1;
(statearr_32564_32652[(1)] = (36));

} else {
var statearr_32565_32653 = state_32529__$1;
(statearr_32565_32653[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (44))){
var state_32529__$1 = state_32529;
var statearr_32566_32654 = state_32529__$1;
(statearr_32566_32654[(2)] = false);

(statearr_32566_32654[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (6))){
var inst_32390 = (state_32529[(9)]);
var inst_32395 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_32390);
var inst_32396 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_32395);
var state_32529__$1 = state_32529;
var statearr_32567_32655 = state_32529__$1;
(statearr_32567_32655[(2)] = inst_32396);

(statearr_32567_32655[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (28))){
var inst_32390 = (state_32529[(9)]);
var state_32529__$1 = state_32529;
var statearr_32568_32656 = state_32529__$1;
(statearr_32568_32656[(2)] = inst_32390);

(statearr_32568_32656[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (64))){
var inst_32520 = (state_32529[(2)]);
var inst_32521 = fluree.db.util.async.throw_err(inst_32520);
var state_32529__$1 = state_32529;
var statearr_32569_32657 = state_32529__$1;
(statearr_32569_32657[(2)] = inst_32521);

(statearr_32569_32657[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (51))){
var inst_32390 = (state_32529[(9)]);
var inst_32392 = (state_32529[(16)]);
var inst_32389 = (state_32529[(17)]);
var inst_32479 = (state_32529[(2)]);
var inst_32480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32481 = [inst_32390,inst_32389,null,inst_32392];
var inst_32482 = (new cljs.core.PersistentVector(null,4,(5),inst_32480,inst_32481,null));
var inst_32483 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_32479);
var inst_32484 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_32482,inst_32483);
var state_32529__$1 = state_32529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32529__$1,(52),inst_32484);
} else {
if((state_val_32530 === (25))){
var inst_32399 = (state_32529[(13)]);
var inst_32516 = (state_32529[(2)]);
var state_32529__$1 = (function (){var statearr_32570 = state_32529;
(statearr_32570[(7)] = inst_32516);

return statearr_32570;
})();
if(cljs.core.truth_(inst_32399)){
var statearr_32571_32658 = state_32529__$1;
(statearr_32571_32658[(1)] = (61));

} else {
var statearr_32572_32659 = state_32529__$1;
(statearr_32572_32659[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (34))){
var inst_32393 = (state_32529[(14)]);
var state_32529__$1 = state_32529;
var statearr_32573_32660 = state_32529__$1;
(statearr_32573_32660[(2)] = inst_32393);

(statearr_32573_32660[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (17))){
var inst_32427 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
var statearr_32574_32661 = state_32529__$1;
(statearr_32574_32661[(2)] = inst_32427);

(statearr_32574_32661[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (3))){
var inst_32527 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32529__$1,inst_32527);
} else {
if((state_val_32530 === (12))){
var inst_32391 = (state_32529[(11)]);
var state_32529__$1 = state_32529;
var statearr_32575_32662 = state_32529__$1;
(statearr_32575_32662[(2)] = inst_32391);

(statearr_32575_32662[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (2))){
var inst_32388 = (state_32529[(12)]);
var inst_32390 = (state_32529[(9)]);
var _ = (function (){var statearr_32576 = state_32529;
(statearr_32576[(4)] = cljs.core.cons((5),(state_32529[(4)])));

return statearr_32576;
})();
var inst_32388__$1 = fparts;
var inst_32389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32388__$1,(0),null);
var inst_32390__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32388__$1,(1),null);
var inst_32391 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32388__$1,(2),null);
var inst_32392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32388__$1,(3),null);
var inst_32393 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_32390__$1);
var state_32529__$1 = (function (){var statearr_32577 = state_32529;
(statearr_32577[(12)] = inst_32388__$1);

(statearr_32577[(14)] = inst_32393);

(statearr_32577[(11)] = inst_32391);

(statearr_32577[(9)] = inst_32390__$1);

(statearr_32577[(16)] = inst_32392);

(statearr_32577[(17)] = inst_32389);

return statearr_32577;
})();
if(cljs.core.truth_(inst_32390__$1)){
var statearr_32578_32663 = state_32529__$1;
(statearr_32578_32663[(1)] = (6));

} else {
var statearr_32579_32664 = state_32529__$1;
(statearr_32579_32664[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (23))){
var inst_32390 = (state_32529[(9)]);
var inst_32392 = (state_32529[(16)]);
var inst_32389 = (state_32529[(17)]);
var inst_32429 = (state_32529[(8)]);
var inst_32431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32432 = [inst_32389,inst_32390,inst_32429,inst_32392];
var inst_32433 = (new cljs.core.PersistentVector(null,4,(5),inst_32431,inst_32432,null));
var inst_32434 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_32433,opts);
var state_32529__$1 = state_32529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32529__$1,(26),inst_32434);
} else {
if((state_val_32530 === (47))){
var inst_32390 = (state_32529[(9)]);
var state_32529__$1 = state_32529;
if(cljs.core.truth_(inst_32390)){
var statearr_32580_32665 = state_32529__$1;
(statearr_32580_32665[(1)] = (53));

} else {
var statearr_32581_32666 = state_32529__$1;
(statearr_32581_32666[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (35))){
var inst_32447 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
var statearr_32582_32667 = state_32529__$1;
(statearr_32582_32667[(2)] = inst_32447);

(statearr_32582_32667[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (19))){
var inst_32391 = (state_32529[(11)]);
var inst_32390 = (state_32529[(9)]);
var inst_32417 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_32390);
var inst_32418 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32417),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32391)].join('');
var inst_32419 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_32418);
var state_32529__$1 = state_32529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32529__$1,(22),inst_32419);
} else {
if((state_val_32530 === (57))){
var inst_32390 = (state_32529[(9)]);
var inst_32392 = (state_32529[(16)]);
var inst_32389 = (state_32529[(17)]);
var inst_32429 = (state_32529[(8)]);
var inst_32499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32500 = [inst_32429,inst_32390,inst_32389,inst_32392];
var inst_32501 = (new cljs.core.PersistentVector(null,4,(5),inst_32499,inst_32500,null));
var inst_32502 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_32501,opts);
var state_32529__$1 = state_32529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32529__$1,(60),inst_32502);
} else {
if((state_val_32530 === (11))){
var inst_32404 = (state_32529[(15)]);
var inst_32404__$1 = (state_32529[(2)]);
var inst_32405 = cljs.core.not(inst_32404__$1);
var state_32529__$1 = (function (){var statearr_32584 = state_32529;
(statearr_32584[(15)] = inst_32404__$1);

return statearr_32584;
})();
if(inst_32405){
var statearr_32585_32668 = state_32529__$1;
(statearr_32585_32668[(1)] = (12));

} else {
var statearr_32586_32669 = state_32529__$1;
(statearr_32586_32669[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (9))){
var inst_32391 = (state_32529[(11)]);
var inst_32401 = typeof inst_32391 === 'string';
var state_32529__$1 = state_32529;
var statearr_32587_32670 = state_32529__$1;
(statearr_32587_32670[(2)] = inst_32401);

(statearr_32587_32670[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (5))){
var _ = (function (){var statearr_32588 = state_32529;
(statearr_32588[(4)] = cljs.core.rest((state_32529[(4)])));

return statearr_32588;
})();
var state_32529__$1 = state_32529;
var ex32583 = (state_32529__$1[(2)]);
var statearr_32589_32671 = state_32529__$1;
(statearr_32589_32671[(5)] = ex32583);


if((ex32583 instanceof Error)){
var statearr_32590_32672 = state_32529__$1;
(statearr_32590_32672[(1)] = (4));

(statearr_32590_32672[(5)] = null);

} else {
throw ex32583;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (14))){
var inst_32389 = (state_32529[(17)]);
var inst_32429 = (state_32529[(2)]);
var state_32529__$1 = (function (){var statearr_32591 = state_32529;
(statearr_32591[(8)] = inst_32429);

return statearr_32591;
})();
if(cljs.core.truth_(inst_32389)){
var statearr_32592_32673 = state_32529__$1;
(statearr_32592_32673[(1)] = (23));

} else {
var statearr_32593_32674 = state_32529__$1;
(statearr_32593_32674[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (45))){
var inst_32468 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
var statearr_32594_32675 = state_32529__$1;
(statearr_32594_32675[(2)] = inst_32468);

(statearr_32594_32675[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (53))){
var inst_32390 = (state_32529[(9)]);
var inst_32392 = (state_32529[(16)]);
var inst_32389 = (state_32529[(17)]);
var inst_32429 = (state_32529[(8)]);
var inst_32490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32491 = [inst_32390,inst_32389,inst_32429,inst_32392];
var inst_32492 = (new cljs.core.PersistentVector(null,4,(5),inst_32490,inst_32491,null));
var inst_32493 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_32492,opts);
var state_32529__$1 = state_32529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32529__$1,(56),inst_32493);
} else {
if((state_val_32530 === (26))){
var inst_32436 = (state_32529[(2)]);
var inst_32437 = fluree.db.util.async.throw_err(inst_32436);
var state_32529__$1 = state_32529;
var statearr_32595_32676 = state_32529__$1;
(statearr_32595_32676[(2)] = inst_32437);

(statearr_32595_32676[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (16))){
var inst_32391 = (state_32529[(11)]);
var inst_32415 = typeof inst_32391 === 'string';
var state_32529__$1 = state_32529;
if(cljs.core.truth_(inst_32415)){
var statearr_32596_32677 = state_32529__$1;
(statearr_32596_32677[(1)] = (19));

} else {
var statearr_32597_32678 = state_32529__$1;
(statearr_32597_32678[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (38))){
var inst_32514 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
var statearr_32598_32679 = state_32529__$1;
(statearr_32598_32679[(2)] = inst_32514);

(statearr_32598_32679[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (30))){
var inst_32393 = (state_32529[(14)]);
var state_32529__$1 = state_32529;
if(cljs.core.truth_(inst_32393)){
var statearr_32599_32680 = state_32529__$1;
(statearr_32599_32680[(1)] = (33));

} else {
var statearr_32600_32681 = state_32529__$1;
(statearr_32600_32681[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (10))){
var inst_32399 = (state_32529[(13)]);
var state_32529__$1 = state_32529;
var statearr_32601_32682 = state_32529__$1;
(statearr_32601_32682[(2)] = inst_32399);

(statearr_32601_32682[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (18))){
var inst_32412 = (state_32529[(2)]);
var inst_32413 = fluree.db.util.async.throw_err(inst_32412);
var state_32529__$1 = state_32529;
var statearr_32602_32683 = state_32529__$1;
(statearr_32602_32683[(2)] = inst_32413);

(statearr_32602_32683[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (52))){
var inst_32486 = (state_32529[(2)]);
var inst_32487 = fluree.db.util.async.throw_err(inst_32486);
var state_32529__$1 = state_32529;
var statearr_32603_32684 = state_32529__$1;
(statearr_32603_32684[(2)] = inst_32487);

(statearr_32603_32684[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (42))){
var inst_32471 = (state_32529[(2)]);
var state_32529__$1 = state_32529;
if(cljs.core.truth_(inst_32471)){
var statearr_32604_32685 = state_32529__$1;
(statearr_32604_32685[(1)] = (46));

} else {
var statearr_32605_32686 = state_32529__$1;
(statearr_32605_32686[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (37))){
var inst_32390 = (state_32529[(9)]);
var state_32529__$1 = state_32529;
if(cljs.core.truth_(inst_32390)){
var statearr_32606_32687 = state_32529__$1;
(statearr_32606_32687[(1)] = (40));

} else {
var statearr_32607_32688 = state_32529__$1;
(statearr_32607_32688[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (63))){
var inst_32524 = (state_32529[(2)]);
var _ = (function (){var statearr_32608 = state_32529;
(statearr_32608[(4)] = cljs.core.rest((state_32529[(4)])));

return statearr_32608;
})();
var state_32529__$1 = state_32529;
var statearr_32609_32689 = state_32529__$1;
(statearr_32609_32689[(2)] = inst_32524);

(statearr_32609_32689[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (8))){
var inst_32399 = (state_32529[(13)]);
var inst_32399__$1 = (state_32529[(2)]);
var state_32529__$1 = (function (){var statearr_32610 = state_32529;
(statearr_32610[(13)] = inst_32399__$1);

return statearr_32610;
})();
if(cljs.core.truth_(inst_32399__$1)){
var statearr_32611_32690 = state_32529__$1;
(statearr_32611_32690[(1)] = (9));

} else {
var statearr_32612_32691 = state_32529__$1;
(statearr_32612_32691[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32530 === (49))){
var inst_32388 = (state_32529[(12)]);
var inst_32399 = (state_32529[(13)]);
var inst_32473 = (state_32529[(10)]);
var inst_32393 = (state_32529[(14)]);
var inst_32404 = (state_32529[(15)]);
var inst_32390 = (state_32529[(9)]);
var inst_32392 = (state_32529[(16)]);
var inst_32389 = (state_32529[(17)]);
var inst_32429 = (state_32529[(8)]);
var inst_32475 = (function (){var obj_fn = inst_32473;
var t = inst_32392;
var temp__5733__auto__ = inst_32473;
var p = inst_32390;
var vec__32385 = inst_32388;
var idx_predicate_QMARK_ = inst_32393;
var o = inst_32429;
var tag_predicate_QMARK_ = inst_32399;
var s = inst_32389;
var o_coerce_QMARK_ = inst_32404;
return (function (x){
var and__4115__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_32529__$1 = state_32529;
var statearr_32613_32692 = state_32529__$1;
(statearr_32613_32692[(2)] = inst_32475);

(statearr_32613_32692[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16301__auto__ = null;
var fluree$db$query$range$state_machine__16301__auto____0 = (function (){
var statearr_32614 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32614[(0)] = fluree$db$query$range$state_machine__16301__auto__);

(statearr_32614[(1)] = (1));

return statearr_32614;
});
var fluree$db$query$range$state_machine__16301__auto____1 = (function (state_32529){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_32529);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e32615){var ex__16304__auto__ = e32615;
var statearr_32616_32693 = state_32529;
(statearr_32616_32693[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_32529[(4)]))){
var statearr_32617_32694 = state_32529;
(statearr_32617_32694[(1)] = cljs.core.first((state_32529[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__32695 = state_32529;
state_32529 = G__32695;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16301__auto__ = function(state_32529){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16301__auto____1.call(this,state_32529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16301__auto____0;
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16301__auto____1;
return fluree$db$query$range$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_32618 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_32618[(6)] = c__16375__auto__);

return statearr_32618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__32697 = arguments.length;
switch (G__32697) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_32732){
var state_val_32733 = (state_32732[(1)]);
if((state_val_32733 === (7))){
var inst_32719 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_32720 = ["Invalid collection name: ",inst_32719].join('');
var inst_32721 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32722 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_32723 = cljs.core.PersistentHashMap.fromArrays(inst_32721,inst_32722);
var inst_32724 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32720,inst_32723);
var inst_32725 = (function(){throw inst_32724})();
var state_32732__$1 = state_32732;
var statearr_32734_32754 = state_32732__$1;
(statearr_32734_32754[(2)] = inst_32725);

(statearr_32734_32754[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32733 === (1))){
var state_32732__$1 = state_32732;
var statearr_32735_32755 = state_32732__$1;
(statearr_32735_32755[(2)] = null);

(statearr_32735_32755[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32733 === (4))){
var inst_32698 = (state_32732[(2)]);
var state_32732__$1 = state_32732;
var statearr_32736_32756 = state_32732__$1;
(statearr_32736_32756[(2)] = inst_32698);

(statearr_32736_32756[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32733 === (6))){
var inst_32704 = (state_32732[(7)]);
var inst_32706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32707 = fluree.db.flake.max_subject_id(inst_32704);
var inst_32708 = [inst_32707];
var inst_32709 = (new cljs.core.PersistentVector(null,1,(5),inst_32706,inst_32708,null));
var inst_32710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32711 = fluree.db.flake.min_subject_id(inst_32704);
var inst_32712 = [inst_32711];
var inst_32713 = (new cljs.core.PersistentVector(null,1,(5),inst_32710,inst_32712,null));
var inst_32714 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_32709,cljs.core._LT__EQ_,inst_32713,opts);
var state_32732__$1 = state_32732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32732__$1,(9),inst_32714);
} else {
if((state_val_32733 === (3))){
var inst_32730 = (state_32732[(2)]);
var state_32732__$1 = state_32732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32732__$1,inst_32730);
} else {
if((state_val_32733 === (2))){
var inst_32704 = (state_32732[(7)]);
var _ = (function (){var statearr_32738 = state_32732;
(statearr_32738[(4)] = cljs.core.cons((5),(state_32732[(4)])));

return statearr_32738;
})();
var inst_32704__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,name);
var state_32732__$1 = (function (){var statearr_32739 = state_32732;
(statearr_32739[(7)] = inst_32704__$1);

return statearr_32739;
})();
if(cljs.core.truth_(inst_32704__$1)){
var statearr_32740_32757 = state_32732__$1;
(statearr_32740_32757[(1)] = (6));

} else {
var statearr_32741_32758 = state_32732__$1;
(statearr_32741_32758[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32733 === (9))){
var inst_32716 = (state_32732[(2)]);
var inst_32717 = fluree.db.util.async.throw_err(inst_32716);
var state_32732__$1 = state_32732;
var statearr_32742_32759 = state_32732__$1;
(statearr_32742_32759[(2)] = inst_32717);

(statearr_32742_32759[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32733 === (5))){
var _ = (function (){var statearr_32743 = state_32732;
(statearr_32743[(4)] = cljs.core.rest((state_32732[(4)])));

return statearr_32743;
})();
var state_32732__$1 = state_32732;
var ex32737 = (state_32732__$1[(2)]);
var statearr_32744_32760 = state_32732__$1;
(statearr_32744_32760[(5)] = ex32737);


var statearr_32745_32761 = state_32732__$1;
(statearr_32745_32761[(1)] = (4));

(statearr_32745_32761[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32733 === (8))){
var inst_32727 = (state_32732[(2)]);
var _ = (function (){var statearr_32746 = state_32732;
(statearr_32746[(4)] = cljs.core.rest((state_32732[(4)])));

return statearr_32746;
})();
var state_32732__$1 = state_32732;
var statearr_32747_32762 = state_32732__$1;
(statearr_32747_32762[(2)] = inst_32727);

(statearr_32747_32762[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16301__auto__ = null;
var fluree$db$query$range$state_machine__16301__auto____0 = (function (){
var statearr_32748 = [null,null,null,null,null,null,null,null];
(statearr_32748[(0)] = fluree$db$query$range$state_machine__16301__auto__);

(statearr_32748[(1)] = (1));

return statearr_32748;
});
var fluree$db$query$range$state_machine__16301__auto____1 = (function (state_32732){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_32732);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e32749){var ex__16304__auto__ = e32749;
var statearr_32750_32763 = state_32732;
(statearr_32750_32763[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_32732[(4)]))){
var statearr_32751_32764 = state_32732;
(statearr_32751_32764[(1)] = cljs.core.first((state_32732[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__32765 = state_32732;
state_32732 = G__32765;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16301__auto__ = function(state_32732){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16301__auto____1.call(this,state_32732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16301__auto____0;
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16301__auto____1;
return fluree$db$query$range$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_32752 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_32752[(6)] = c__16375__auto__);

return statearr_32752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__32769 = flakes;
var vec__32770 = G__32769;
var seq__32771 = cljs.core.seq(vec__32770);
var first__32772 = cljs.core.first(seq__32771);
var seq__32771__$1 = cljs.core.next(seq__32771);
var flake_SINGLEQUOTE_ = first__32772;
var r = seq__32771__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__32769__$1 = G__32769;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__32779 = G__32769__$1;
var seq__32780 = cljs.core.seq(vec__32779);
var first__32781 = cljs.core.first(seq__32780);
var seq__32780__$1 = cljs.core.next(seq__32780);
var flake_SINGLEQUOTE___$1 = first__32781;
var r__$1 = seq__32780__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e32783){var e = e32783;
return null;
}})();
var map__32782 = cmd_map;
var map__32782__$1 = (((((!((map__32782 == null))))?(((((map__32782.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32782.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32782):map__32782);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32782__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32782__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32782__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32782__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32782__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32782__$1,cljs.core.cst$kw$expire);
var G__32785 = r__$1;
var G__32786 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__32769__$1 = G__32785;
result_STAR___$1 = G__32786;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__32795 = blocks;
var vec__32796 = G__32795;
var seq__32797 = cljs.core.seq(vec__32796);
var first__32798 = cljs.core.first(seq__32797);
var seq__32797__$1 = cljs.core.next(seq__32797);
var block_SINGLEQUOTE_ = first__32798;
var r = seq__32797__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__32795__$1 = G__32795;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__32804 = G__32795__$1;
var seq__32805 = cljs.core.seq(vec__32804);
var first__32806 = cljs.core.first(seq__32805);
var seq__32805__$1 = cljs.core.next(seq__32805);
var block_SINGLEQUOTE___$1 = first__32806;
var r__$1 = seq__32805__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__32807 = block_SINGLEQUOTE___$1;
var map__32807__$1 = (((((!((map__32807 == null))))?(((((map__32807.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32807.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32807):map__32807);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32807__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32807__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32807__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__32795__$1,result_STAR___$1,map__32807,map__32807__$1,block,t,flakes,vec__32804,seq__32805,first__32806,seq__32805__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32795,vec__32796,seq__32797,first__32798,seq__32797__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32787_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32787_SHARP_.p,(2))){
return p1__32787_SHARP_.o;
} else {
return null;
}
});})(G__32795__$1,result_STAR___$1,map__32807,map__32807__$1,block,t,flakes,vec__32804,seq__32805,first__32806,seq__32805__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32795,vec__32796,seq__32797,first__32798,seq__32797__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__32795__$1,result_STAR___$1,map__32807,map__32807__$1,block,t,flakes,prev_hash,vec__32804,seq__32805,first__32806,seq__32805__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32795,vec__32796,seq__32797,first__32798,seq__32797__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32788_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32788_SHARP_.p,(1))){
return p1__32788_SHARP_.o;
} else {
return null;
}
});})(G__32795__$1,result_STAR___$1,map__32807,map__32807__$1,block,t,flakes,prev_hash,vec__32804,seq__32805,first__32806,seq__32805__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32795,vec__32796,seq__32797,first__32798,seq__32797__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__32795__$1,result_STAR___$1,map__32807,map__32807__$1,block,t,flakes,prev_hash,hash,vec__32804,seq__32805,first__32806,seq__32805__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32795,vec__32796,seq__32797,first__32798,seq__32797__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32789_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32789_SHARP_.p,(5))){
return p1__32789_SHARP_.o;
} else {
return null;
}
});})(G__32795__$1,result_STAR___$1,map__32807,map__32807__$1,block,t,flakes,prev_hash,hash,vec__32804,seq__32805,first__32806,seq__32805__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32795,vec__32796,seq__32797,first__32798,seq__32797__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__32795__$1,result_STAR___$1,map__32807,map__32807__$1,block,t,flakes,prev_hash,hash,instant,vec__32804,seq__32805,first__32806,seq__32805__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32795,vec__32796,seq__32797,first__32798,seq__32797__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32790_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32790_SHARP_.p,(7))){
return p1__32790_SHARP_.o;
} else {
return null;
}
});})(G__32795__$1,result_STAR___$1,map__32807,map__32807__$1,block,t,flakes,prev_hash,hash,instant,vec__32804,seq__32805,first__32806,seq__32805__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32795,vec__32796,seq__32797,first__32798,seq__32797__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__32795__$1,result_STAR___$1,map__32807,map__32807__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__32804,seq__32805,first__32806,seq__32805__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32795,vec__32796,seq__32797,first__32798,seq__32797__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32791_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32791_SHARP_.p,(106));
});})(G__32795__$1,result_STAR___$1,map__32807,map__32807__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__32804,seq__32805,first__32806,seq__32805__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32795,vec__32796,seq__32797,first__32798,seq__32797__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__32809 = r__$1;
var G__32810 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__32795__$1 = G__32809;
result_STAR___$1 = G__32810;
continue;
}
break;
}
});
