// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35830){
var state_val_35831 = (state_35830[(1)]);
if((state_val_35831 === (1))){
var state_35830__$1 = state_35830;
var statearr_35832_35846 = state_35830__$1;
(statearr_35832_35846[(2)] = null);

(statearr_35832_35846[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35831 === (2))){
var _ = (function (){var statearr_35833 = state_35830;
(statearr_35833[(4)] = cljs.core.cons((5),(state_35830[(4)])));

return statearr_35833;
})();
var inst_35821 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_35830__$1 = state_35830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35830__$1,(6),inst_35821);
} else {
if((state_val_35831 === (3))){
var inst_35828 = (state_35830[(2)]);
var state_35830__$1 = state_35830;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35830__$1,inst_35828);
} else {
if((state_val_35831 === (4))){
var inst_35815 = (state_35830[(2)]);
var state_35830__$1 = state_35830;
var statearr_35835_35847 = state_35830__$1;
(statearr_35835_35847[(2)] = inst_35815);

(statearr_35835_35847[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35831 === (5))){
var _ = (function (){var statearr_35836 = state_35830;
(statearr_35836[(4)] = cljs.core.rest((state_35830[(4)])));

return statearr_35836;
})();
var state_35830__$1 = state_35830;
var ex35834 = (state_35830__$1[(2)]);
var statearr_35837_35848 = state_35830__$1;
(statearr_35837_35848[(5)] = ex35834);


if((ex35834 instanceof Error)){
var statearr_35838_35849 = state_35830__$1;
(statearr_35838_35849[(1)] = (4));

(statearr_35838_35849[(5)] = null);

} else {
throw ex35834;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35831 === (6))){
var inst_35823 = (state_35830[(2)]);
var inst_35824 = fluree.db.util.async.throw_err(inst_35823);
var inst_35825 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_35824);
var _ = (function (){var statearr_35839 = state_35830;
(statearr_35839[(4)] = cljs.core.rest((state_35830[(4)])));

return statearr_35839;
})();
var state_35830__$1 = state_35830;
var statearr_35840_35850 = state_35830__$1;
(statearr_35840_35850[(2)] = inst_35825);

(statearr_35840_35850[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____0 = (function (){
var statearr_35841 = [null,null,null,null,null,null,null];
(statearr_35841[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__);

(statearr_35841[(1)] = (1));

return statearr_35841;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____1 = (function (state_35830){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35830);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35842){var ex__16304__auto__ = e35842;
var statearr_35843_35851 = state_35830;
(statearr_35843_35851[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35830[(4)]))){
var statearr_35844_35852 = state_35830;
(statearr_35844_35852[(1)] = cljs.core.first((state_35830[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35853 = state_35830;
state_35830 = G__35853;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__ = function(state_35830){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____1.call(this,state_35830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35845 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35845[(6)] = c__16375__auto__);

return statearr_35845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35885){
var state_val_35886 = (state_35885[(1)]);
if((state_val_35886 === (7))){
var inst_35869 = (state_35885[(7)]);
var inst_35871 = cljs.core.empty_QMARK_(inst_35869);
var inst_35872 = (!(inst_35871));
var state_35885__$1 = state_35885;
var statearr_35887_35911 = state_35885__$1;
(statearr_35887_35911[(2)] = inst_35872);

(statearr_35887_35911[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35886 === (1))){
var state_35885__$1 = state_35885;
var statearr_35888_35912 = state_35885__$1;
(statearr_35888_35912[(2)] = null);

(statearr_35888_35912[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35886 === (4))){
var inst_35855 = (state_35885[(2)]);
var state_35885__$1 = state_35885;
var statearr_35889_35913 = state_35885__$1;
(statearr_35889_35913[(2)] = inst_35855);

(statearr_35889_35913[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35886 === (6))){
var inst_35861 = (state_35885[(8)]);
var inst_35869 = (state_35885[(7)]);
var inst_35867 = (state_35885[(2)]);
var inst_35868 = fluree.db.util.async.throw_err(inst_35867);
var inst_35869__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35861,inst_35868);
var state_35885__$1 = (function (){var statearr_35890 = state_35885;
(statearr_35890[(7)] = inst_35869__$1);

return statearr_35890;
})();
if(cljs.core.truth_(inst_35869__$1)){
var statearr_35891_35914 = state_35885__$1;
(statearr_35891_35914[(1)] = (7));

} else {
var statearr_35892_35915 = state_35885__$1;
(statearr_35892_35915[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35886 === (3))){
var inst_35883 = (state_35885[(2)]);
var state_35885__$1 = state_35885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35885__$1,inst_35883);
} else {
if((state_val_35886 === (12))){
var inst_35880 = (state_35885[(2)]);
var _ = (function (){var statearr_35893 = state_35885;
(statearr_35893[(4)] = cljs.core.rest((state_35885[(4)])));

return statearr_35893;
})();
var state_35885__$1 = state_35885;
var statearr_35894_35916 = state_35885__$1;
(statearr_35894_35916[(2)] = inst_35880);

(statearr_35894_35916[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35886 === (2))){
var _ = (function (){var statearr_35895 = state_35885;
(statearr_35895[(4)] = cljs.core.cons((5),(state_35885[(4)])));

return statearr_35895;
})();
var inst_35861 = (function (){return (function (p1__35854_SHARP_){
return p1__35854_SHARP_.o;
});
})();
var inst_35862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35863 = [pred_id];
var inst_35864 = (new cljs.core.PersistentVector(null,1,(5),inst_35862,inst_35863,null));
var inst_35865 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_35864);
var state_35885__$1 = (function (){var statearr_35896 = state_35885;
(statearr_35896[(8)] = inst_35861);

return statearr_35896;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35885__$1,(6),inst_35865);
} else {
if((state_val_35886 === (11))){
var state_35885__$1 = state_35885;
var statearr_35898_35917 = state_35885__$1;
(statearr_35898_35917[(2)] = true);

(statearr_35898_35917[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35886 === (9))){
var inst_35875 = (state_35885[(2)]);
var state_35885__$1 = state_35885;
if(cljs.core.truth_(inst_35875)){
var statearr_35899_35918 = state_35885__$1;
(statearr_35899_35918[(1)] = (10));

} else {
var statearr_35900_35919 = state_35885__$1;
(statearr_35900_35919[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35886 === (5))){
var _ = (function (){var statearr_35901 = state_35885;
(statearr_35901[(4)] = cljs.core.rest((state_35885[(4)])));

return statearr_35901;
})();
var state_35885__$1 = state_35885;
var ex35897 = (state_35885__$1[(2)]);
var statearr_35902_35920 = state_35885__$1;
(statearr_35902_35920[(5)] = ex35897);


if((ex35897 instanceof Error)){
var statearr_35903_35921 = state_35885__$1;
(statearr_35903_35921[(1)] = (4));

(statearr_35903_35921[(5)] = null);

} else {
throw ex35897;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35886 === (10))){
var inst_35869 = (state_35885[(7)]);
var inst_35877 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_35869);
var state_35885__$1 = state_35885;
var statearr_35904_35922 = state_35885__$1;
(statearr_35904_35922[(2)] = inst_35877);

(statearr_35904_35922[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35886 === (8))){
var inst_35869 = (state_35885[(7)]);
var state_35885__$1 = state_35885;
var statearr_35905_35923 = state_35885__$1;
(statearr_35905_35923[(2)] = inst_35869);

(statearr_35905_35923[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____0 = (function (){
var statearr_35906 = [null,null,null,null,null,null,null,null,null];
(statearr_35906[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__);

(statearr_35906[(1)] = (1));

return statearr_35906;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____1 = (function (state_35885){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35885);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35907){var ex__16304__auto__ = e35907;
var statearr_35908_35924 = state_35885;
(statearr_35908_35924[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35885[(4)]))){
var statearr_35909_35925 = state_35885;
(statearr_35909_35925[(1)] = cljs.core.first((state_35885[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35926 = state_35885;
state_35885 = G__35926;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__ = function(state_35885){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____1.call(this,state_35885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35910 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35910[(6)] = c__16375__auto__);

return statearr_35910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_36003){
var state_val_36004 = (state_36003[(1)]);
if((state_val_36004 === (7))){
var inst_35998 = (state_36003[(2)]);
var _ = (function (){var statearr_36005 = state_36003;
(statearr_36005[(4)] = cljs.core.rest((state_36003[(4)])));

return statearr_36005;
})();
var state_36003__$1 = state_36003;
var statearr_36006_36039 = state_36003__$1;
(statearr_36006_36039[(2)] = inst_35998);

(statearr_36006_36039[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (1))){
var state_36003__$1 = state_36003;
var statearr_36007_36040 = state_36003__$1;
(statearr_36007_36040[(2)] = null);

(statearr_36007_36040[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (4))){
var inst_35929 = (state_36003[(2)]);
var state_36003__$1 = state_36003;
var statearr_36008_36041 = state_36003__$1;
(statearr_36008_36041[(2)] = inst_35929);

(statearr_36008_36041[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (15))){
var inst_35979 = (state_36003[(7)]);
var inst_35959 = (state_36003[(8)]);
var inst_35966 = (state_36003[(9)]);
var inst_35953 = (state_36003[(10)]);
var inst_35981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35982 = inst_35959.s;
var inst_35983 = [inst_35982,inst_35966,cljs.core.cst$kw$old];
var inst_35984 = (new cljs.core.PersistentVector(null,3,(5),inst_35981,inst_35983,null));
var inst_35985 = cljs.core.assoc_in(inst_35953,inst_35984,inst_35979);
var state_36003__$1 = state_36003;
var statearr_36009_36042 = state_36003__$1;
(statearr_36009_36042[(2)] = inst_35985);

(statearr_36009_36042[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (13))){
var inst_35968 = (state_36003[(11)]);
var inst_35979 = (state_36003[(2)]);
var state_36003__$1 = (function (){var statearr_36010 = state_36003;
(statearr_36010[(7)] = inst_35979);

return statearr_36010;
})();
if(cljs.core.truth_(inst_35968)){
var statearr_36011_36043 = state_36003__$1;
(statearr_36011_36043[(1)] = (15));

} else {
var statearr_36012_36044 = state_36003__$1;
(statearr_36012_36044[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (6))){
var inst_35952 = (state_36003[(12)]);
var inst_35959 = (state_36003[(8)]);
var inst_35958 = cljs.core.seq(inst_35952);
var inst_35959__$1 = cljs.core.first(inst_35958);
var inst_35960 = cljs.core.next(inst_35958);
var inst_35961 = cljs.core.not(inst_35959__$1);
var state_36003__$1 = (function (){var statearr_36013 = state_36003;
(statearr_36013[(13)] = inst_35960);

(statearr_36013[(8)] = inst_35959__$1);

return statearr_36013;
})();
if(inst_35961){
var statearr_36014_36045 = state_36003__$1;
(statearr_36014_36045[(1)] = (8));

} else {
var statearr_36015_36046 = state_36003__$1;
(statearr_36015_36046[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (17))){
var inst_35960 = (state_36003[(13)]);
var inst_35993 = (state_36003[(2)]);
var inst_35952 = inst_35960;
var inst_35953 = inst_35993;
var state_36003__$1 = (function (){var statearr_36016 = state_36003;
(statearr_36016[(12)] = inst_35952);

(statearr_36016[(10)] = inst_35953);

return statearr_36016;
})();
var statearr_36017_36047 = state_36003__$1;
(statearr_36017_36047[(2)] = null);

(statearr_36017_36047[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (3))){
var inst_36001 = (state_36003[(2)]);
var state_36003__$1 = state_36003;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36003__$1,inst_36001);
} else {
if((state_val_36004 === (12))){
var inst_35959 = (state_36003[(8)]);
var inst_35977 = inst_35959.o;
var state_36003__$1 = state_36003;
var statearr_36018_36048 = state_36003__$1;
(statearr_36018_36048[(2)] = inst_35977);

(statearr_36018_36048[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (2))){
var _ = (function (){var statearr_36019 = state_36003;
(statearr_36019[(4)] = cljs.core.cons((5),(state_36003[(4)])));

return statearr_36019;
})();
var inst_35935 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_35936 = cljs.core.PersistentHashSet.EMPTY;
var inst_35937 = cljs.core.vals(tempids);
var inst_35938 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35936,inst_35937);
var inst_35939 = (function (){var pred_flakes = inst_35935;
var is_new_QMARK_ = inst_35938;
return (function (p1__35927_SHARP_,p2__35928_SHARP_){
return cljs.core.assoc_in(p1__35927_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__35928_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__36020 = p2__35928_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__36020) : is_new_QMARK_.call(null,G__36020));
})()));
});
})();
var inst_35940 = cljs.core.PersistentHashMap.EMPTY;
var inst_35941 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35939,inst_35940,inst_35935);
var inst_35949 = cljs.core.seq(inst_35935);
var inst_35950 = cljs.core.first(inst_35949);
var inst_35951 = cljs.core.next(inst_35949);
var inst_35952 = inst_35935;
var inst_35953 = inst_35941;
var state_36003__$1 = (function (){var statearr_36021 = state_36003;
(statearr_36021[(12)] = inst_35952);

(statearr_36021[(14)] = inst_35950);

(statearr_36021[(15)] = inst_35951);

(statearr_36021[(10)] = inst_35953);

return statearr_36021;
})();
var statearr_36022_36049 = state_36003__$1;
(statearr_36022_36049[(2)] = null);

(statearr_36022_36049[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (11))){
var inst_35959 = (state_36003[(8)]);
var inst_35971 = inst_35959.o;
var inst_35972 = fluree.db.query.schema.convert_type_to_kw(inst_35971,db);
var state_36003__$1 = state_36003;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36003__$1,(14),inst_35972);
} else {
if((state_val_36004 === (9))){
var inst_35959 = (state_36003[(8)]);
var inst_35966 = (state_36003[(9)]);
var inst_35964 = inst_35959.p;
var inst_35965 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_35964);
var inst_35966__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_35965);
var inst_35967 = inst_35959.op;
var inst_35968 = inst_35967 === false;
var inst_35969 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_35966__$1);
var state_36003__$1 = (function (){var statearr_36024 = state_36003;
(statearr_36024[(9)] = inst_35966__$1);

(statearr_36024[(11)] = inst_35968);

return statearr_36024;
})();
if(inst_35969){
var statearr_36025_36050 = state_36003__$1;
(statearr_36025_36050[(1)] = (11));

} else {
var statearr_36026_36051 = state_36003__$1;
(statearr_36026_36051[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (5))){
var _ = (function (){var statearr_36027 = state_36003;
(statearr_36027[(4)] = cljs.core.rest((state_36003[(4)])));

return statearr_36027;
})();
var state_36003__$1 = state_36003;
var ex36023 = (state_36003__$1[(2)]);
var statearr_36028_36052 = state_36003__$1;
(statearr_36028_36052[(5)] = ex36023);


if((ex36023 instanceof Error)){
var statearr_36029_36053 = state_36003__$1;
(statearr_36029_36053[(1)] = (4));

(statearr_36029_36053[(5)] = null);

} else {
throw ex36023;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (14))){
var inst_35974 = (state_36003[(2)]);
var inst_35975 = fluree.db.util.async.throw_err(inst_35974);
var state_36003__$1 = state_36003;
var statearr_36030_36054 = state_36003__$1;
(statearr_36030_36054[(2)] = inst_35975);

(statearr_36030_36054[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (16))){
var inst_35979 = (state_36003[(7)]);
var inst_35959 = (state_36003[(8)]);
var inst_35966 = (state_36003[(9)]);
var inst_35953 = (state_36003[(10)]);
var inst_35987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35988 = inst_35959.s;
var inst_35989 = [inst_35988,inst_35966,cljs.core.cst$kw$new];
var inst_35990 = (new cljs.core.PersistentVector(null,3,(5),inst_35987,inst_35989,null));
var inst_35991 = cljs.core.assoc_in(inst_35953,inst_35990,inst_35979);
var state_36003__$1 = state_36003;
var statearr_36031_36055 = state_36003__$1;
(statearr_36031_36055[(2)] = inst_35991);

(statearr_36031_36055[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (10))){
var inst_35996 = (state_36003[(2)]);
var state_36003__$1 = state_36003;
var statearr_36032_36056 = state_36003__$1;
(statearr_36032_36056[(2)] = inst_35996);

(statearr_36032_36056[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36004 === (8))){
var inst_35953 = (state_36003[(10)]);
var state_36003__$1 = state_36003;
var statearr_36033_36057 = state_36003__$1;
(statearr_36033_36057[(2)] = inst_35953);

(statearr_36033_36057[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____0 = (function (){
var statearr_36034 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36034[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__);

(statearr_36034[(1)] = (1));

return statearr_36034;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____1 = (function (state_36003){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_36003);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e36035){var ex__16304__auto__ = e36035;
var statearr_36036_36058 = state_36003;
(statearr_36036_36058[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_36003[(4)]))){
var statearr_36037_36059 = state_36003;
(statearr_36037_36059[(1)] = cljs.core.first((state_36003[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__36060 = state_36003;
state_36003 = G__36060;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__ = function(state_36003){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____1.call(this,state_36003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_36038 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_36038[(6)] = c__16375__auto__);

return statearr_36038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__36062 = arguments.length;
switch (G__36062) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__36065 = arguments.length;
switch (G__36065) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_36374){
var state_val_36375 = (state_36374[(1)]);
if((state_val_36375 === (65))){
var inst_36327 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36376_36548 = state_36374__$1;
(statearr_36376_36548[(2)] = inst_36327);

(statearr_36376_36548[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (70))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36249 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_36250 = (inst_36237.cljs$core$IFn$_invoke$arity$5 ? inst_36237.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_36249,null) : inst_36237.call(null,cljs.core.PersistentArrayMap,null,2,inst_36249,null));
var inst_36251 = (inst_36237.cljs$core$IFn$_invoke$arity$4 ? inst_36237.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36250,null) : inst_36237.call(null,cljs.core.PersistentHashSet,null,inst_36250,null));
var inst_36252 = (inst_36251.cljs$core$IFn$_invoke$arity$1 ? inst_36251.cljs$core$IFn$_invoke$arity$1(inst_36236) : inst_36251.call(null,inst_36236));
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36252)){
var statearr_36377_36549 = state_36374__$1;
(statearr_36377_36549[(1)] = (71));

} else {
var statearr_36378_36550 = state_36374__$1;
(statearr_36378_36550[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (62))){
var inst_36329 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36379_36551 = state_36374__$1;
(statearr_36379_36551[(2)] = inst_36329);

(statearr_36379_36551[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (74))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36259 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_36260 = (inst_36237.cljs$core$IFn$_invoke$arity$5 ? inst_36237.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_36259,null) : inst_36237.call(null,cljs.core.PersistentArrayMap,null,3,inst_36259,null));
var inst_36261 = (inst_36237.cljs$core$IFn$_invoke$arity$4 ? inst_36237.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36260,null) : inst_36237.call(null,cljs.core.PersistentHashSet,null,inst_36260,null));
var inst_36262 = (inst_36261.cljs$core$IFn$_invoke$arity$1 ? inst_36261.cljs$core$IFn$_invoke$arity$1(inst_36236) : inst_36261.call(null,inst_36236));
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36262)){
var statearr_36380_36552 = state_36374__$1;
(statearr_36380_36552[(1)] = (75));

} else {
var statearr_36381_36553 = state_36374__$1;
(statearr_36381_36553[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (110))){
var inst_36361 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36382_36554 = state_36374__$1;
(statearr_36382_36554[(2)] = inst_36361);

(statearr_36382_36554[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (7))){
var inst_36369 = (state_36374[(2)]);
var _ = (function (){var statearr_36383 = state_36374;
(statearr_36383[(4)] = cljs.core.rest((state_36374[(4)])));

return statearr_36383;
})();
var state_36374__$1 = state_36374;
var statearr_36384_36555 = state_36374__$1;
(statearr_36384_36555[(2)] = inst_36369);

(statearr_36384_36555[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (59))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36235 = (state_36374[(2)]);
var inst_36236__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36235,cljs.core.cst$kw$old);
var inst_36237__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36235,cljs.core.cst$kw$new);
var inst_36238 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36237__$1,inst_36236__$1);
var state_36374__$1 = (function (){var statearr_36385 = state_36374;
(statearr_36385[(7)] = inst_36237__$1);

(statearr_36385[(8)] = inst_36236__$1);

return statearr_36385;
})();
if(inst_36238){
var statearr_36386_36556 = state_36374__$1;
(statearr_36386_36556[(1)] = (60));

} else {
var statearr_36387_36557 = state_36374__$1;
(statearr_36387_36557[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (86))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36289 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_36290 = (inst_36237.cljs$core$IFn$_invoke$arity$5 ? inst_36237.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_36289,null) : inst_36237.call(null,cljs.core.PersistentArrayMap,null,5,inst_36289,null));
var inst_36291 = (inst_36237.cljs$core$IFn$_invoke$arity$4 ? inst_36237.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36290,null) : inst_36237.call(null,cljs.core.PersistentHashSet,null,inst_36290,null));
var inst_36292 = (inst_36291.cljs$core$IFn$_invoke$arity$1 ? inst_36291.cljs$core$IFn$_invoke$arity$1(inst_36236) : inst_36291.call(null,inst_36236));
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36292)){
var statearr_36388_36558 = state_36374__$1;
(statearr_36388_36558[(1)] = (87));

} else {
var statearr_36389_36559 = state_36374__$1;
(statearr_36389_36559[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (20))){
var inst_36105 = (state_36374[(9)]);
var inst_36130 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36131 = inst_36130 === true;
var inst_36132 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36133 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36132);
var inst_36134 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_36133);
var inst_36135 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36136 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36135);
var inst_36137 = inst_36136 === true;
var inst_36138 = ((inst_36131) && (inst_36134) && (inst_36137));
var state_36374__$1 = state_36374;
var statearr_36390_36560 = state_36374__$1;
(statearr_36390_36560[(2)] = inst_36138);

(statearr_36390_36560[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (72))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36255 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36236,inst_36237,throw_QMARK_);
var state_36374__$1 = state_36374;
var statearr_36391_36561 = state_36374__$1;
(statearr_36391_36561[(2)] = inst_36255);

(statearr_36391_36561[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (58))){
var inst_36214 = (state_36374[(10)]);
var state_36374__$1 = state_36374;
var statearr_36392_36562 = state_36374__$1;
(statearr_36392_36562[(2)] = inst_36214);

(statearr_36392_36562[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (60))){
var inst_36204 = (state_36374[(11)]);
var state_36374__$1 = state_36374;
var statearr_36393_36563 = state_36374__$1;
(statearr_36393_36563[(2)] = inst_36204);

(statearr_36393_36563[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (27))){
var inst_36125 = (state_36374[(12)]);
var state_36374__$1 = state_36374;
var statearr_36394_36564 = state_36374__$1;
(statearr_36394_36564[(2)] = inst_36125);

(statearr_36394_36564[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (1))){
var state_36374__$1 = state_36374;
var statearr_36395_36565 = state_36374__$1;
(statearr_36395_36565[(2)] = null);

(statearr_36395_36565[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (69))){
var inst_36322 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36396_36566 = state_36374__$1;
(statearr_36396_36566[(2)] = inst_36322);

(statearr_36396_36566[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (101))){
var inst_36351 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36351)){
var statearr_36397_36567 = state_36374__$1;
(statearr_36397_36567[(1)] = (105));

} else {
var statearr_36398_36568 = state_36374__$1;
(statearr_36398_36568[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (24))){
var inst_36125 = (state_36374[(12)]);
var state_36374__$1 = state_36374;
var statearr_36399_36569 = state_36374__$1;
(statearr_36399_36569[(2)] = inst_36125);

(statearr_36399_36569[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (102))){
var inst_36105 = (state_36374[(9)]);
var inst_36338 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36339 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36338);
var inst_36340 = inst_36339 === true;
var inst_36341 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36342 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36341);
var inst_36343 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_36342);
var inst_36344 = (!(inst_36343));
var inst_36345 = ((inst_36340) && (inst_36344));
var state_36374__$1 = state_36374;
var statearr_36400_36570 = state_36374__$1;
(statearr_36400_36570[(2)] = inst_36345);

(statearr_36400_36570[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (55))){
var state_36374__$1 = state_36374;
var statearr_36401_36571 = state_36374__$1;
(statearr_36401_36571[(2)] = false);

(statearr_36401_36571[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (85))){
var inst_36287 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36402_36572 = state_36374__$1;
(statearr_36402_36572[(2)] = inst_36287);

(statearr_36402_36572[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (39))){
var state_36374__$1 = state_36374;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_36403_36573 = state_36374__$1;
(statearr_36403_36573[(1)] = (42));

} else {
var statearr_36404_36574 = state_36374__$1;
(statearr_36404_36574[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (88))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36295 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36236,inst_36237,throw_QMARK_);
var state_36374__$1 = state_36374;
var statearr_36405_36575 = state_36374__$1;
(statearr_36405_36575[(2)] = inst_36295);

(statearr_36405_36575[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (46))){
var inst_36205 = (state_36374[(13)]);
var state_36374__$1 = state_36374;
var statearr_36406_36576 = state_36374__$1;
(statearr_36406_36576[(2)] = inst_36205);

(statearr_36406_36576[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (4))){
var inst_36066 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36407_36577 = state_36374__$1;
(statearr_36407_36577[(2)] = inst_36066);

(statearr_36407_36577[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (77))){
var inst_36267 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36408_36578 = state_36374__$1;
(statearr_36408_36578[(2)] = inst_36267);

(statearr_36408_36578[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (106))){
var inst_36332 = (state_36374[(14)]);
var state_36374__$1 = state_36374;
var statearr_36409_36579 = state_36374__$1;
(statearr_36409_36579[(2)] = inst_36332);

(statearr_36409_36579[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (95))){
var inst_36204 = (state_36374[(11)]);
var state_36374__$1 = state_36374;
var statearr_36410_36580 = state_36374__$1;
(statearr_36410_36580[(2)] = inst_36204);

(statearr_36410_36580[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (54))){
var state_36374__$1 = state_36374;
var statearr_36411_36581 = state_36374__$1;
(statearr_36411_36581[(2)] = true);

(statearr_36411_36581[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (92))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36305 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36236,inst_36237,throw_QMARK_);
var state_36374__$1 = state_36374;
var statearr_36412_36582 = state_36374__$1;
(statearr_36412_36582[(2)] = inst_36305);

(statearr_36412_36582[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (104))){
var inst_36348 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36413_36583 = state_36374__$1;
(statearr_36413_36583[(2)] = inst_36348);

(statearr_36413_36583[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (15))){
var inst_36093 = (state_36374[(15)]);
var state_36374__$1 = state_36374;
var statearr_36414_36584 = state_36374__$1;
(statearr_36414_36584[(2)] = inst_36093);

(statearr_36414_36584[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (48))){
var inst_36105 = (state_36374[(9)]);
var inst_36214 = (state_36374[(10)]);
var inst_36214__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36216 = (inst_36214__$1 == null);
var inst_36217 = cljs.core.not(inst_36216);
var state_36374__$1 = (function (){var statearr_36415 = state_36374;
(statearr_36415[(10)] = inst_36214__$1);

return statearr_36415;
})();
if(inst_36217){
var statearr_36416_36585 = state_36374__$1;
(statearr_36416_36585[(1)] = (51));

} else {
var statearr_36417_36586 = state_36374__$1;
(statearr_36417_36586[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (50))){
var inst_36105 = (state_36374[(9)]);
var inst_36332 = (state_36374[(2)]);
var inst_36333 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36334 = inst_36333 === true;
var state_36374__$1 = (function (){var statearr_36418 = state_36374;
(statearr_36418[(14)] = inst_36332);

return statearr_36418;
})();
if(cljs.core.truth_(inst_36334)){
var statearr_36419_36587 = state_36374__$1;
(statearr_36419_36587[(1)] = (99));

} else {
var statearr_36420_36588 = state_36374__$1;
(statearr_36420_36588[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (75))){
var inst_36204 = (state_36374[(11)]);
var state_36374__$1 = state_36374;
var statearr_36421_36589 = state_36374__$1;
(statearr_36421_36589[(2)] = inst_36204);

(statearr_36421_36589[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (99))){
var inst_36336 = (state_36374[(16)]);
var inst_36105 = (state_36374[(9)]);
var inst_36336__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_36105);
var state_36374__$1 = (function (){var statearr_36422 = state_36374;
(statearr_36422[(16)] = inst_36336__$1);

return statearr_36422;
})();
if(cljs.core.truth_(inst_36336__$1)){
var statearr_36423_36590 = state_36374__$1;
(statearr_36423_36590[(1)] = (102));

} else {
var statearr_36424_36591 = state_36374__$1;
(statearr_36424_36591[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (21))){
var inst_36128 = (state_36374[(17)]);
var state_36374__$1 = state_36374;
var statearr_36425_36592 = state_36374__$1;
(statearr_36425_36592[(2)] = inst_36128);

(statearr_36425_36592[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (31))){
var inst_36168 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36168)){
var statearr_36426_36593 = state_36374__$1;
(statearr_36426_36593[(1)] = (32));

} else {
var statearr_36427_36594 = state_36374__$1;
(statearr_36427_36594[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (32))){
var inst_36157 = (state_36374[(18)]);
var inst_36170 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_36157,"a component","a non-component",throw_QMARK_);
var state_36374__$1 = state_36374;
var statearr_36428_36595 = state_36374__$1;
(statearr_36428_36595[(2)] = inst_36170);

(statearr_36428_36595[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (40))){
var inst_36173 = (state_36374[(19)]);
var state_36374__$1 = state_36374;
var statearr_36429_36596 = state_36374__$1;
(statearr_36429_36596[(2)] = inst_36173);

(statearr_36429_36596[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (91))){
var inst_36204 = (state_36374[(11)]);
var state_36374__$1 = state_36374;
var statearr_36430_36597 = state_36374__$1;
(statearr_36430_36597[(2)] = inst_36204);

(statearr_36430_36597[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (108))){
var inst_36354 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36355 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_36356 = cljs.core.PersistentHashMap.fromArrays(inst_36354,inst_36355);
var inst_36357 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_36356);
var inst_36358 = (function(){throw inst_36357})();
var state_36374__$1 = state_36374;
var statearr_36431_36598 = state_36374__$1;
(statearr_36431_36598[(2)] = inst_36358);

(statearr_36431_36598[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (56))){
var inst_36227 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36432_36599 = state_36374__$1;
(statearr_36432_36599[(2)] = inst_36227);

(statearr_36432_36599[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (33))){
var inst_36157 = (state_36374[(18)]);
var state_36374__$1 = state_36374;
var statearr_36433_36600 = state_36374__$1;
(statearr_36433_36600[(2)] = inst_36157);

(statearr_36433_36600[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (13))){
var inst_36120 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36120)){
var statearr_36434_36601 = state_36374__$1;
(statearr_36434_36601[(1)] = (14));

} else {
var statearr_36435_36602 = state_36374__$1;
(statearr_36435_36602[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (22))){
var inst_36141 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36436_36603 = state_36374__$1;
(statearr_36436_36603[(2)] = inst_36141);

(statearr_36436_36603[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (90))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36299 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_36300 = (inst_36237.cljs$core$IFn$_invoke$arity$5 ? inst_36237.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_36299,null) : inst_36237.call(null,cljs.core.PersistentArrayMap,null,5,inst_36299,null));
var inst_36301 = (inst_36237.cljs$core$IFn$_invoke$arity$4 ? inst_36237.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36300,null) : inst_36237.call(null,cljs.core.PersistentHashSet,null,inst_36300,null));
var inst_36302 = (inst_36301.cljs$core$IFn$_invoke$arity$1 ? inst_36301.cljs$core$IFn$_invoke$arity$1(inst_36236) : inst_36301.call(null,inst_36236));
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36302)){
var statearr_36437_36604 = state_36374__$1;
(statearr_36437_36604[(1)] = (91));

} else {
var statearr_36438_36605 = state_36374__$1;
(statearr_36438_36605[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (109))){
var inst_36332 = (state_36374[(14)]);
var state_36374__$1 = state_36374;
var statearr_36439_36606 = state_36374__$1;
(statearr_36439_36606[(2)] = inst_36332);

(statearr_36439_36606[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (36))){
var inst_36174 = (state_36374[(20)]);
var state_36374__$1 = state_36374;
var statearr_36440_36607 = state_36374__$1;
(statearr_36440_36607[(2)] = inst_36174);

(statearr_36440_36607[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (41))){
var inst_36105 = (state_36374[(9)]);
var inst_36205 = (state_36374[(13)]);
var inst_36204 = (state_36374[(2)]);
var inst_36205__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36105);
var state_36374__$1 = (function (){var statearr_36441 = state_36374;
(statearr_36441[(13)] = inst_36205__$1);

(statearr_36441[(11)] = inst_36204);

return statearr_36441;
})();
if(cljs.core.truth_(inst_36205__$1)){
var statearr_36442_36608 = state_36374__$1;
(statearr_36442_36608[(1)] = (45));

} else {
var statearr_36443_36609 = state_36374__$1;
(statearr_36443_36609[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (89))){
var inst_36297 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36444_36610 = state_36374__$1;
(statearr_36444_36610[(2)] = inst_36297);

(statearr_36444_36610[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (100))){
var state_36374__$1 = state_36374;
var statearr_36445_36611 = state_36374__$1;
(statearr_36445_36611[(2)] = false);

(statearr_36445_36611[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (43))){
var inst_36173 = (state_36374[(19)]);
var state_36374__$1 = state_36374;
var statearr_36446_36612 = state_36374__$1;
(statearr_36446_36612[(2)] = inst_36173);

(statearr_36446_36612[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (61))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36241 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_36242 = (inst_36237.cljs$core$IFn$_invoke$arity$5 ? inst_36237.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_36241,null) : inst_36237.call(null,cljs.core.PersistentArrayMap,null,3,inst_36241,null));
var inst_36243 = (inst_36237.cljs$core$IFn$_invoke$arity$4 ? inst_36237.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36242,null) : inst_36237.call(null,cljs.core.PersistentHashSet,null,inst_36242,null));
var inst_36244 = (inst_36243.cljs$core$IFn$_invoke$arity$1 ? inst_36243.cljs$core$IFn$_invoke$arity$1(inst_36236) : inst_36243.call(null,inst_36236));
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36244)){
var statearr_36447_36613 = state_36374__$1;
(statearr_36447_36613[(1)] = (63));

} else {
var statearr_36448_36614 = state_36374__$1;
(statearr_36448_36614[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (29))){
var inst_36105 = (state_36374[(9)]);
var inst_36160 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36161 = cljs.core.not(inst_36160);
var inst_36162 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36163 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36162);
var inst_36164 = inst_36163 === true;
var inst_36165 = ((inst_36161) && (inst_36164));
var state_36374__$1 = state_36374;
var statearr_36449_36615 = state_36374__$1;
(statearr_36449_36615[(2)] = inst_36165);

(statearr_36449_36615[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (44))){
var inst_36201 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36450_36616 = state_36374__$1;
(statearr_36450_36616[(2)] = inst_36201);

(statearr_36450_36616[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (93))){
var inst_36307 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36451_36617 = state_36374__$1;
(statearr_36451_36617[(2)] = inst_36307);

(statearr_36451_36617[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (6))){
var inst_36092 = (state_36374[(21)]);
var inst_36104 = (state_36374[(22)]);
var inst_36101 = cljs.core.seq(inst_36092);
var inst_36102 = cljs.core.first(inst_36101);
var inst_36103 = cljs.core.next(inst_36101);
var inst_36104__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36102,(0),null);
var inst_36105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36102,(1),null);
var inst_36106 = cljs.core.not(inst_36104__$1);
var state_36374__$1 = (function (){var statearr_36452 = state_36374;
(statearr_36452[(23)] = inst_36103);

(statearr_36452[(9)] = inst_36105);

(statearr_36452[(22)] = inst_36104__$1);

return statearr_36452;
})();
if(inst_36106){
var statearr_36453_36618 = state_36374__$1;
(statearr_36453_36618[(1)] = (8));

} else {
var statearr_36454_36619 = state_36374__$1;
(statearr_36454_36619[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (28))){
var inst_36154 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36455_36620 = state_36374__$1;
(statearr_36455_36620[(2)] = inst_36154);

(statearr_36455_36620[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (64))){
var state_36374__$1 = state_36374;
var statearr_36456_36621 = state_36374__$1;
(statearr_36456_36621[(1)] = (66));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (103))){
var inst_36336 = (state_36374[(16)]);
var state_36374__$1 = state_36374;
var statearr_36458_36622 = state_36374__$1;
(statearr_36458_36622[(2)] = inst_36336);

(statearr_36458_36622[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (51))){
var inst_36214 = (state_36374[(10)]);
var inst_36219 = inst_36214.cljs$lang$protocol_mask$partition0$;
var inst_36220 = (inst_36219 & (64));
var inst_36221 = inst_36214.cljs$core$ISeq$;
var inst_36222 = (cljs.core.PROTOCOL_SENTINEL === inst_36221);
var inst_36223 = ((inst_36220) || (inst_36222));
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36223)){
var statearr_36459_36623 = state_36374__$1;
(statearr_36459_36623[(1)] = (54));

} else {
var statearr_36460_36624 = state_36374__$1;
(statearr_36460_36624[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (25))){
var inst_36158 = (state_36374[(24)]);
var inst_36105 = (state_36374[(9)]);
var inst_36157 = (state_36374[(2)]);
var inst_36158__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_36105);
var state_36374__$1 = (function (){var statearr_36461 = state_36374;
(statearr_36461[(24)] = inst_36158__$1);

(statearr_36461[(18)] = inst_36157);

return statearr_36461;
})();
if(cljs.core.truth_(inst_36158__$1)){
var statearr_36462_36625 = state_36374__$1;
(statearr_36462_36625[(1)] = (29));

} else {
var statearr_36463_36626 = state_36374__$1;
(statearr_36463_36626[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (34))){
var inst_36174 = (state_36374[(20)]);
var inst_36105 = (state_36374[(9)]);
var inst_36173 = (state_36374[(2)]);
var inst_36174__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_36105);
var state_36374__$1 = (function (){var statearr_36464 = state_36374;
(statearr_36464[(19)] = inst_36173);

(statearr_36464[(20)] = inst_36174__$1);

return statearr_36464;
})();
if(cljs.core.truth_(inst_36174__$1)){
var statearr_36465_36627 = state_36374__$1;
(statearr_36465_36627[(1)] = (35));

} else {
var statearr_36466_36628 = state_36374__$1;
(statearr_36466_36628[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (17))){
var inst_36105 = (state_36374[(9)]);
var inst_36128 = (state_36374[(17)]);
var inst_36128__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36105);
var state_36374__$1 = (function (){var statearr_36467 = state_36374;
(statearr_36467[(17)] = inst_36128__$1);

return statearr_36467;
})();
if(cljs.core.truth_(inst_36128__$1)){
var statearr_36468_36629 = state_36374__$1;
(statearr_36468_36629[(1)] = (20));

} else {
var statearr_36469_36630 = state_36374__$1;
(statearr_36469_36630[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (3))){
var inst_36372 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36374__$1,inst_36372);
} else {
if((state_val_36375 === (12))){
var inst_36109 = (state_36374[(25)]);
var state_36374__$1 = state_36374;
var statearr_36470_36631 = state_36374__$1;
(statearr_36470_36631[(2)] = inst_36109);

(statearr_36470_36631[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (2))){
var _ = (function (){var statearr_36471 = state_36374;
(statearr_36471[(4)] = cljs.core.cons((5),(state_36374[(4)])));

return statearr_36471;
})();
var inst_36085 = pred_changes;
var inst_36086 = cljs.core.seq(inst_36085);
var inst_36087 = cljs.core.first(inst_36086);
var inst_36088 = cljs.core.next(inst_36086);
var inst_36089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36087,(0),null);
var inst_36090 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36087,(1),null);
var inst_36091 = db;
var inst_36092 = inst_36085;
var inst_36093 = inst_36091;
var state_36374__$1 = (function (){var statearr_36472 = state_36374;
(statearr_36472[(21)] = inst_36092);

(statearr_36472[(15)] = inst_36093);

(statearr_36472[(26)] = inst_36089);

(statearr_36472[(27)] = inst_36088);

(statearr_36472[(28)] = inst_36090);

return statearr_36472;
})();
var statearr_36473_36632 = state_36374__$1;
(statearr_36473_36632[(2)] = null);

(statearr_36473_36632[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (66))){
var inst_36237 = (state_36374[(7)]);
var state_36374__$1 = state_36374;
var G__36474_36633 = inst_36237;
var G__36474_36634__$1 = (((G__36474_36633 instanceof cljs.core.Keyword))?G__36474_36633.fqn:null);
switch (G__36474_36634__$1) {
case "long":
var statearr_36475_36636 = state_36374__$1;
(statearr_36475_36636[(1)] = (70));


break;
case "bigint":
var statearr_36476_36637 = state_36374__$1;
(statearr_36476_36637[(1)] = (74));


break;
case "double":
var statearr_36477_36638 = state_36374__$1;
(statearr_36477_36638[(1)] = (78));


break;
case "float":
var statearr_36478_36639 = state_36374__$1;
(statearr_36478_36639[(1)] = (82));


break;
case "bigdec":
var statearr_36479_36640 = state_36374__$1;
(statearr_36479_36640[(1)] = (86));


break;
case "string":
var statearr_36480_36641 = state_36374__$1;
(statearr_36480_36641[(1)] = (90));


break;
case "instant":
var statearr_36481_36642 = state_36374__$1;
(statearr_36481_36642[(1)] = (94));


break;
default:
var statearr_36482_36643 = state_36374__$1;
(statearr_36482_36643[(1)] = (98));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (107))){
var inst_36103 = (state_36374[(23)]);
var inst_36364 = (state_36374[(2)]);
var inst_36092 = inst_36103;
var inst_36093 = inst_36364;
var state_36374__$1 = (function (){var statearr_36483 = state_36374;
(statearr_36483[(21)] = inst_36092);

(statearr_36483[(15)] = inst_36093);

return statearr_36483;
})();
var statearr_36484_36644 = state_36374__$1;
(statearr_36484_36644[(2)] = null);

(statearr_36484_36644[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (23))){
var state_36374__$1 = state_36374;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_36485_36645 = state_36374__$1;
(statearr_36485_36645[(1)] = (26));

} else {
var statearr_36486_36646 = state_36374__$1;
(statearr_36486_36646[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (47))){
var inst_36211 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36211)){
var statearr_36487_36647 = state_36374__$1;
(statearr_36487_36647[(1)] = (48));

} else {
var statearr_36488_36648 = state_36374__$1;
(statearr_36488_36648[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (35))){
var inst_36105 = (state_36374[(9)]);
var inst_36093 = (state_36374[(15)]);
var inst_36104 = (state_36374[(22)]);
var inst_36176 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36177 = cljs.core.not(inst_36176);
var inst_36178 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36179 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36178);
var inst_36180 = inst_36179 === true;
var inst_36181 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_36093,inst_36104);
var state_36374__$1 = (function (){var statearr_36489 = state_36374;
(statearr_36489[(29)] = inst_36177);

(statearr_36489[(30)] = inst_36180);

return statearr_36489;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36374__$1,(38),inst_36181);
} else {
if((state_val_36375 === (82))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36279 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_36280 = (inst_36237.cljs$core$IFn$_invoke$arity$5 ? inst_36237.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_36279,null) : inst_36237.call(null,cljs.core.PersistentArrayMap,null,3,inst_36279,null));
var inst_36281 = (inst_36237.cljs$core$IFn$_invoke$arity$4 ? inst_36237.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36280,null) : inst_36237.call(null,cljs.core.PersistentHashSet,null,inst_36280,null));
var inst_36282 = (inst_36281.cljs$core$IFn$_invoke$arity$1 ? inst_36281.cljs$core$IFn$_invoke$arity$1(inst_36236) : inst_36281.call(null,inst_36236));
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36282)){
var statearr_36490_36649 = state_36374__$1;
(statearr_36490_36649[(1)] = (83));

} else {
var statearr_36491_36650 = state_36374__$1;
(statearr_36491_36650[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (76))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36265 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36236,inst_36237,throw_QMARK_);
var state_36374__$1 = state_36374;
var statearr_36492_36651 = state_36374__$1;
(statearr_36492_36651[(2)] = inst_36265);

(statearr_36492_36651[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (97))){
var inst_36317 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36493_36652 = state_36374__$1;
(statearr_36493_36652[(2)] = inst_36317);

(statearr_36493_36652[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (19))){
var inst_36144 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36144)){
var statearr_36494_36653 = state_36374__$1;
(statearr_36494_36653[(1)] = (23));

} else {
var statearr_36495_36654 = state_36374__$1;
(statearr_36495_36654[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (57))){
var inst_36214 = (state_36374[(10)]);
var inst_36232 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_36214);
var state_36374__$1 = state_36374;
var statearr_36496_36655 = state_36374__$1;
(statearr_36496_36655[(2)] = inst_36232);

(statearr_36496_36655[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (68))){
var inst_36325 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36497_36656 = state_36374__$1;
(statearr_36497_36656[(2)] = inst_36325);

(statearr_36497_36656[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (11))){
var inst_36105 = (state_36374[(9)]);
var inst_36111 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36112 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36111);
var inst_36113 = inst_36112 === false;
var inst_36114 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36115 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_36114);
var inst_36116 = inst_36115 === true;
var inst_36117 = ((inst_36113) && (inst_36116));
var state_36374__$1 = state_36374;
var statearr_36499_36657 = state_36374__$1;
(statearr_36499_36657[(2)] = inst_36117);

(statearr_36499_36657[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (9))){
var inst_36109 = (state_36374[(25)]);
var inst_36105 = (state_36374[(9)]);
var inst_36109__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_36105);
var state_36374__$1 = (function (){var statearr_36500 = state_36374;
(statearr_36500[(25)] = inst_36109__$1);

return statearr_36500;
})();
if(cljs.core.truth_(inst_36109__$1)){
var statearr_36501_36658 = state_36374__$1;
(statearr_36501_36658[(1)] = (11));

} else {
var statearr_36502_36659 = state_36374__$1;
(statearr_36502_36659[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (5))){
var _ = (function (){var statearr_36503 = state_36374;
(statearr_36503[(4)] = cljs.core.rest((state_36374[(4)])));

return statearr_36503;
})();
var state_36374__$1 = state_36374;
var ex36498 = (state_36374__$1[(2)]);
var statearr_36504_36660 = state_36374__$1;
(statearr_36504_36660[(5)] = ex36498);


if((ex36498 instanceof Error)){
var statearr_36505_36661 = state_36374__$1;
(statearr_36505_36661[(1)] = (4));

(statearr_36505_36661[(5)] = null);

} else {
throw ex36498;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (83))){
var inst_36204 = (state_36374[(11)]);
var state_36374__$1 = state_36374;
var statearr_36506_36662 = state_36374__$1;
(statearr_36506_36662[(2)] = inst_36204);

(statearr_36506_36662[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (14))){
var inst_36093 = (state_36374[(15)]);
var inst_36122 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_36093,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_36374__$1 = state_36374;
var statearr_36507_36663 = state_36374__$1;
(statearr_36507_36663[(2)] = inst_36122);

(statearr_36507_36663[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (45))){
var inst_36105 = (state_36374[(9)]);
var inst_36207 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36105);
var inst_36208 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_36207);
var state_36374__$1 = state_36374;
var statearr_36508_36664 = state_36374__$1;
(statearr_36508_36664[(2)] = inst_36208);

(statearr_36508_36664[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (53))){
var inst_36230 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36230)){
var statearr_36509_36665 = state_36374__$1;
(statearr_36509_36665[(1)] = (57));

} else {
var statearr_36510_36666 = state_36374__$1;
(statearr_36510_36666[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (78))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36269 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_36270 = (inst_36237.cljs$core$IFn$_invoke$arity$5 ? inst_36237.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_36269,null) : inst_36237.call(null,cljs.core.PersistentArrayMap,null,3,inst_36269,null));
var inst_36271 = (inst_36237.cljs$core$IFn$_invoke$arity$4 ? inst_36237.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36270,null) : inst_36237.call(null,cljs.core.PersistentHashSet,null,inst_36270,null));
var inst_36272 = (inst_36271.cljs$core$IFn$_invoke$arity$1 ? inst_36271.cljs$core$IFn$_invoke$arity$1(inst_36236) : inst_36271.call(null,inst_36236));
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36272)){
var statearr_36511_36667 = state_36374__$1;
(statearr_36511_36667[(1)] = (79));

} else {
var statearr_36512_36668 = state_36374__$1;
(statearr_36512_36668[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (26))){
var inst_36147 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36148 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_36149 = cljs.core.PersistentHashMap.fromArrays(inst_36147,inst_36148);
var inst_36150 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_36149);
var inst_36151 = (function(){throw inst_36150})();
var state_36374__$1 = state_36374;
var statearr_36513_36669 = state_36374__$1;
(statearr_36513_36669[(2)] = inst_36151);

(statearr_36513_36669[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (16))){
var inst_36126 = (state_36374[(31)]);
var inst_36105 = (state_36374[(9)]);
var inst_36125 = (state_36374[(2)]);
var inst_36126__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_36105);
var state_36374__$1 = (function (){var statearr_36514 = state_36374;
(statearr_36514[(31)] = inst_36126__$1);

(statearr_36514[(12)] = inst_36125);

return statearr_36514;
})();
if(cljs.core.truth_(inst_36126__$1)){
var statearr_36515_36670 = state_36374__$1;
(statearr_36515_36670[(1)] = (17));

} else {
var statearr_36516_36671 = state_36374__$1;
(statearr_36516_36671[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (81))){
var inst_36277 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36517_36672 = state_36374__$1;
(statearr_36517_36672[(2)] = inst_36277);

(statearr_36517_36672[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (79))){
var inst_36204 = (state_36374[(11)]);
var state_36374__$1 = state_36374;
var statearr_36518_36673 = state_36374__$1;
(statearr_36518_36673[(2)] = inst_36204);

(statearr_36518_36673[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (38))){
var inst_36177 = (state_36374[(29)]);
var inst_36180 = (state_36374[(30)]);
var inst_36183 = (state_36374[(2)]);
var inst_36184 = fluree.db.util.async.throw_err(inst_36183);
var inst_36185 = cljs.core.not(inst_36184);
var inst_36186 = ((inst_36177) && (inst_36180) && (inst_36185));
var state_36374__$1 = state_36374;
var statearr_36519_36674 = state_36374__$1;
(statearr_36519_36674[(2)] = inst_36186);

(statearr_36519_36674[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (98))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36319 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36236,inst_36237,throw_QMARK_);
var state_36374__$1 = state_36374;
var statearr_36520_36675 = state_36374__$1;
(statearr_36520_36675[(2)] = inst_36319);

(statearr_36520_36675[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (87))){
var inst_36204 = (state_36374[(11)]);
var state_36374__$1 = state_36374;
var statearr_36521_36676 = state_36374__$1;
(statearr_36521_36676[(2)] = inst_36204);

(statearr_36521_36676[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (30))){
var inst_36158 = (state_36374[(24)]);
var state_36374__$1 = state_36374;
var statearr_36522_36677 = state_36374__$1;
(statearr_36522_36677[(2)] = inst_36158);

(statearr_36522_36677[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (73))){
var inst_36257 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36523_36678 = state_36374__$1;
(statearr_36523_36678[(2)] = inst_36257);

(statearr_36523_36678[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (96))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36315 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36236,inst_36237,throw_QMARK_);
var state_36374__$1 = state_36374;
var statearr_36524_36679 = state_36374__$1;
(statearr_36524_36679[(2)] = inst_36315);

(statearr_36524_36679[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (10))){
var inst_36367 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
var statearr_36525_36680 = state_36374__$1;
(statearr_36525_36680[(2)] = inst_36367);

(statearr_36525_36680[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (18))){
var inst_36126 = (state_36374[(31)]);
var state_36374__$1 = state_36374;
var statearr_36526_36681 = state_36374__$1;
(statearr_36526_36681[(2)] = inst_36126);

(statearr_36526_36681[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (105))){
var state_36374__$1 = state_36374;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_36527_36682 = state_36374__$1;
(statearr_36527_36682[(1)] = (108));

} else {
var statearr_36528_36683 = state_36374__$1;
(statearr_36528_36683[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (52))){
var state_36374__$1 = state_36374;
var statearr_36529_36684 = state_36374__$1;
(statearr_36529_36684[(2)] = false);

(statearr_36529_36684[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (67))){
var state_36374__$1 = state_36374;
var statearr_36530_36685 = state_36374__$1;
(statearr_36530_36685[(2)] = null);

(statearr_36530_36685[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (71))){
var inst_36204 = (state_36374[(11)]);
var state_36374__$1 = state_36374;
var statearr_36531_36686 = state_36374__$1;
(statearr_36531_36686[(2)] = inst_36204);

(statearr_36531_36686[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (42))){
var inst_36093 = (state_36374[(15)]);
var inst_36104 = (state_36374[(22)]);
var inst_36192 = fluree.db.dbproto._p_prop(inst_36093,cljs.core.cst$kw$name,inst_36104);
var inst_36193 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36192)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_36194 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36195 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_36196 = cljs.core.PersistentHashMap.fromArrays(inst_36194,inst_36195);
var inst_36197 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36193,inst_36196);
var inst_36198 = (function(){throw inst_36197})();
var state_36374__$1 = state_36374;
var statearr_36532_36687 = state_36374__$1;
(statearr_36532_36687[(2)] = inst_36198);

(statearr_36532_36687[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (80))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36275 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36236,inst_36237,throw_QMARK_);
var state_36374__$1 = state_36374;
var statearr_36533_36688 = state_36374__$1;
(statearr_36533_36688[(2)] = inst_36275);

(statearr_36533_36688[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (37))){
var inst_36189 = (state_36374[(2)]);
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36189)){
var statearr_36534_36689 = state_36374__$1;
(statearr_36534_36689[(1)] = (39));

} else {
var statearr_36535_36690 = state_36374__$1;
(statearr_36535_36690[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (63))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36246 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36236,inst_36237,throw_QMARK_);
var state_36374__$1 = state_36374;
var statearr_36536_36691 = state_36374__$1;
(statearr_36536_36691[(2)] = inst_36246);

(statearr_36536_36691[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (94))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36309 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_36310 = (inst_36237.cljs$core$IFn$_invoke$arity$5 ? inst_36237.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_36309,null) : inst_36237.call(null,cljs.core.PersistentArrayMap,null,2,inst_36309,null));
var inst_36311 = (inst_36237.cljs$core$IFn$_invoke$arity$4 ? inst_36237.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36310,null) : inst_36237.call(null,cljs.core.PersistentHashSet,null,inst_36310,null));
var inst_36312 = (inst_36311.cljs$core$IFn$_invoke$arity$1 ? inst_36311.cljs$core$IFn$_invoke$arity$1(inst_36236) : inst_36311.call(null,inst_36236));
var state_36374__$1 = state_36374;
if(cljs.core.truth_(inst_36312)){
var statearr_36537_36692 = state_36374__$1;
(statearr_36537_36692[(1)] = (95));

} else {
var statearr_36538_36693 = state_36374__$1;
(statearr_36538_36693[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (8))){
var inst_36093 = (state_36374[(15)]);
var state_36374__$1 = state_36374;
var statearr_36539_36694 = state_36374__$1;
(statearr_36539_36694[(2)] = inst_36093);

(statearr_36539_36694[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (49))){
var inst_36204 = (state_36374[(11)]);
var state_36374__$1 = state_36374;
var statearr_36540_36695 = state_36374__$1;
(statearr_36540_36695[(2)] = inst_36204);

(statearr_36540_36695[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36375 === (84))){
var inst_36237 = (state_36374[(7)]);
var inst_36236 = (state_36374[(8)]);
var inst_36285 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36236,inst_36237,throw_QMARK_);
var state_36374__$1 = state_36374;
var statearr_36541_36696 = state_36374__$1;
(statearr_36541_36696[(2)] = inst_36285);

(statearr_36541_36696[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__16301__auto__ = null;
var fluree$db$query$schema$state_machine__16301__auto____0 = (function (){
var statearr_36542 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36542[(0)] = fluree$db$query$schema$state_machine__16301__auto__);

(statearr_36542[(1)] = (1));

return statearr_36542;
});
var fluree$db$query$schema$state_machine__16301__auto____1 = (function (state_36374){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_36374);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e36543){var ex__16304__auto__ = e36543;
var statearr_36544_36697 = state_36374;
(statearr_36544_36697[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_36374[(4)]))){
var statearr_36545_36698 = state_36374;
(statearr_36545_36698[(1)] = cljs.core.first((state_36374[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__36699 = state_36374;
state_36374 = G__36699;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__16301__auto__ = function(state_36374){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__16301__auto____1.call(this,state_36374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__16301__auto____0;
fluree$db$query$schema$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__16301__auto____1;
return fluree$db$query$schema$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_36546 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_36546[(6)] = c__16375__auto__);

return statearr_36546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_36723){
var state_val_36724 = (state_36723[(1)]);
if((state_val_36724 === (7))){
var state_36723__$1 = state_36723;
var statearr_36725_36744 = state_36723__$1;
(statearr_36725_36744[(2)] = db);

(statearr_36725_36744[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36724 === (1))){
var state_36723__$1 = state_36723;
var statearr_36726_36745 = state_36723__$1;
(statearr_36726_36745[(2)] = null);

(statearr_36726_36745[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36724 === (4))){
var inst_36700 = (state_36723[(2)]);
var state_36723__$1 = state_36723;
var statearr_36727_36746 = state_36723__$1;
(statearr_36727_36746[(2)] = inst_36700);

(statearr_36727_36746[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36724 === (6))){
var inst_36709 = (state_36723[(7)]);
var inst_36708 = (state_36723[(2)]);
var inst_36709__$1 = fluree.db.util.async.throw_err(inst_36708);
var inst_36710 = cljs.core.empty_QMARK_(inst_36709__$1);
var state_36723__$1 = (function (){var statearr_36728 = state_36723;
(statearr_36728[(7)] = inst_36709__$1);

return statearr_36728;
})();
if(inst_36710){
var statearr_36729_36747 = state_36723__$1;
(statearr_36729_36747[(1)] = (7));

} else {
var statearr_36730_36748 = state_36723__$1;
(statearr_36730_36748[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36724 === (3))){
var inst_36721 = (state_36723[(2)]);
var state_36723__$1 = state_36723;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36723__$1,inst_36721);
} else {
if((state_val_36724 === (2))){
var _ = (function (){var statearr_36732 = state_36723;
(statearr_36732[(4)] = cljs.core.cons((5),(state_36723[(4)])));

return statearr_36732;
})();
var inst_36706 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes);
var state_36723__$1 = state_36723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36723__$1,(6),inst_36706);
} else {
if((state_val_36724 === (9))){
var inst_36718 = (state_36723[(2)]);
var _ = (function (){var statearr_36733 = state_36723;
(statearr_36733[(4)] = cljs.core.rest((state_36723[(4)])));

return statearr_36733;
})();
var state_36723__$1 = state_36723;
var statearr_36734_36749 = state_36723__$1;
(statearr_36734_36749[(2)] = inst_36718);

(statearr_36734_36749[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36724 === (5))){
var _ = (function (){var statearr_36735 = state_36723;
(statearr_36735[(4)] = cljs.core.rest((state_36723[(4)])));

return statearr_36735;
})();
var state_36723__$1 = state_36723;
var ex36731 = (state_36723__$1[(2)]);
var statearr_36736_36750 = state_36723__$1;
(statearr_36736_36750[(5)] = ex36731);


if((ex36731 instanceof Error)){
var statearr_36737_36751 = state_36723__$1;
(statearr_36737_36751[(1)] = (4));

(statearr_36737_36751[(5)] = null);

} else {
throw ex36731;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36724 === (10))){
var inst_36715 = (state_36723[(2)]);
var inst_36716 = fluree.db.util.async.throw_err(inst_36715);
var state_36723__$1 = state_36723;
var statearr_36738_36752 = state_36723__$1;
(statearr_36738_36752[(2)] = inst_36716);

(statearr_36738_36752[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36724 === (8))){
var inst_36709 = (state_36723[(7)]);
var inst_36713 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_36709,db,true);
var state_36723__$1 = state_36723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36723__$1,(10),inst_36713);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____0 = (function (){
var statearr_36739 = [null,null,null,null,null,null,null,null];
(statearr_36739[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__);

(statearr_36739[(1)] = (1));

return statearr_36739;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____1 = (function (state_36723){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_36723);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e36740){var ex__16304__auto__ = e36740;
var statearr_36741_36753 = state_36723;
(statearr_36741_36753[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_36723[(4)]))){
var statearr_36742_36754 = state_36723;
(statearr_36742_36754[(1)] = cljs.core.first((state_36723[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__36755 = state_36723;
state_36723 = G__36755;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__ = function(state_36723){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____1.call(this,state_36723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_36743 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_36743[(6)] = c__16375__auto__);

return statearr_36743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__36757 = arguments.length;
switch (G__36757) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__36759 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36759,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36759,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36759,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__36762_SHARP_,p2__36763_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36762_SHARP_,p2__36763_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_36829){
var state_val_36830 = (state_36829[(1)]);
if((state_val_36830 === (1))){
var state_36829__$1 = state_36829;
var statearr_36831_36849 = state_36829__$1;
(statearr_36831_36849[(2)] = null);

(statearr_36831_36849[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36830 === (2))){
var _ = (function (){var statearr_36832 = state_36829;
(statearr_36832[(4)] = cljs.core.cons((5),(state_36829[(4)])));

return statearr_36832;
})();
var inst_36781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36782 = fluree.db.flake.max_subject_id((1));
var inst_36783 = [inst_36782];
var inst_36784 = (new cljs.core.PersistentVector(null,1,(5),inst_36781,inst_36783,null));
var inst_36785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36786 = [(0)];
var inst_36787 = (new cljs.core.PersistentVector(null,1,(5),inst_36785,inst_36786,null));
var inst_36788 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_36784,cljs.core._LT__EQ_,inst_36787);
var state_36829__$1 = state_36829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36829__$1,(6),inst_36788);
} else {
if((state_val_36830 === (3))){
var inst_36827 = (state_36829[(2)]);
var state_36829__$1 = state_36829;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36829__$1,inst_36827);
} else {
if((state_val_36830 === (4))){
var inst_36769 = (state_36829[(2)]);
var state_36829__$1 = state_36829;
var statearr_36834_36850 = state_36829__$1;
(statearr_36834_36850[(2)] = inst_36769);

(statearr_36834_36850[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36830 === (5))){
var _ = (function (){var statearr_36835 = state_36829;
(statearr_36835[(4)] = cljs.core.rest((state_36829[(4)])));

return statearr_36835;
})();
var state_36829__$1 = state_36829;
var ex36833 = (state_36829__$1[(2)]);
var statearr_36836_36851 = state_36829__$1;
(statearr_36836_36851[(5)] = ex36833);


if((ex36833 instanceof Error)){
var statearr_36837_36852 = state_36829__$1;
(statearr_36837_36852[(1)] = (4));

(statearr_36837_36852[(5)] = null);

} else {
throw ex36833;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36830 === (6))){
var inst_36790 = (state_36829[(2)]);
var inst_36791 = fluree.db.util.async.throw_err(inst_36790);
var inst_36792 = (function (){var schema_flakes = inst_36791;
return (function (p1__36764_SHARP_){
return (p1__36764_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_36793 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_36792,inst_36791);
var inst_36794 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36793,(0),null);
var inst_36795 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36793,(1),null);
var inst_36796 = (function (){var schema_flakes = inst_36791;
var vec__36775 = inst_36793;
var collection_flakes = inst_36794;
var predicate_flakes = inst_36795;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var id = fluree.db.flake.sid__GT_i(sid);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__36766_SHARP_,p2__36767_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__36766_SHARP_,p2__36767_SHARP_.p,p2__36767_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43));
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,id], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,id,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_36797 = [(-1),"_tx"];
var inst_36798 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_36799 = ["_tx",(-1),(-1)];
var inst_36800 = cljs.core.PersistentHashMap.fromArrays(inst_36798,inst_36799);
var inst_36801 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_36802 = ["_tx",(-1),(-1)];
var inst_36803 = cljs.core.PersistentHashMap.fromArrays(inst_36801,inst_36802);
var inst_36804 = [inst_36800,inst_36803];
var inst_36805 = cljs.core.PersistentHashMap.fromArrays(inst_36797,inst_36804);
var inst_36806 = (function (){var schema_flakes = inst_36791;
var vec__36775 = inst_36793;
var collection_flakes = inst_36794;
var predicate_flakes = inst_36795;
return (function (p1__36765_SHARP_){
return p1__36765_SHARP_.s;
});
})();
var inst_36807 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_36806,inst_36794);
var inst_36808 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36796,inst_36805,inst_36807);
var inst_36810 = (function (){var schema_flakes = inst_36791;
var vec__36775 = inst_36793;
var collection_flakes = inst_36794;
var predicate_flakes = inst_36795;
var coll = inst_36808;
return (function (p__36809,pred_flakes){
var vec__36838 = p__36809;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36838,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36838,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__36841 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__36841.cljs$core$IFn$_invoke$arity$1 ? fexpr__36841.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__36841.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_36811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36812 = cljs.core.PersistentHashMap.EMPTY;
var inst_36813 = cljs.core.PersistentHashSet.EMPTY;
var inst_36814 = [inst_36812,inst_36813];
var inst_36815 = (new cljs.core.PersistentVector(null,2,(5),inst_36811,inst_36814,null));
var inst_36816 = (function (){var schema_flakes = inst_36791;
var vec__36775 = inst_36793;
var collection_flakes = inst_36794;
var predicate_flakes = inst_36795;
var coll = inst_36808;
return (function (p1__36768_SHARP_){
return p1__36768_SHARP_.s;
});
})();
var inst_36817 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_36816,inst_36795);
var inst_36818 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36810,inst_36815,inst_36817);
var inst_36819 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36818,(0),null);
var inst_36820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36818,(1),null);
var inst_36821 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_36822 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_36823 = [inst_36822,inst_36808,inst_36819,inst_36820];
var inst_36824 = cljs.core.PersistentHashMap.fromArrays(inst_36821,inst_36823);
var _ = (function (){var statearr_36842 = state_36829;
(statearr_36842[(4)] = cljs.core.rest((state_36829[(4)])));

return statearr_36842;
})();
var state_36829__$1 = state_36829;
var statearr_36843_36853 = state_36829__$1;
(statearr_36843_36853[(2)] = inst_36824);

(statearr_36843_36853[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__16301__auto____0 = (function (){
var statearr_36844 = [null,null,null,null,null,null,null];
(statearr_36844[(0)] = fluree$db$query$schema$schema_map_$_state_machine__16301__auto__);

(statearr_36844[(1)] = (1));

return statearr_36844;
});
var fluree$db$query$schema$schema_map_$_state_machine__16301__auto____1 = (function (state_36829){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_36829);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e36845){var ex__16304__auto__ = e36845;
var statearr_36846_36854 = state_36829;
(statearr_36846_36854[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_36829[(4)]))){
var statearr_36847_36855 = state_36829;
(statearr_36847_36855[(1)] = cljs.core.first((state_36829[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__36856 = state_36829;
state_36829 = G__36856;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__16301__auto__ = function(state_36829){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__16301__auto____1.call(this,state_36829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__16301__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__16301__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_36848 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_36848[(6)] = c__16375__auto__);

return statearr_36848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_36898){
var state_val_36899 = (state_36898[(1)]);
if((state_val_36899 === (7))){
var inst_36881 = (state_36898[(2)]);
var inst_36882 = fluree.db.query.schema.flake__GT_pred_map(inst_36881);
var inst_36883 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_36884 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36882,(114));
var inst_36885 = cljs.core.boolean$(inst_36884);
var inst_36886 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36882,(110));
var inst_36887 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36882,(117));
var inst_36888 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_36887);
var inst_36889 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36882,(111));
var inst_36890 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36882,(115));
var inst_36891 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36882,(112));
var inst_36892 = [inst_36885,inst_36886,inst_36888,inst_36889,inst_36890,inst_36891];
var inst_36893 = cljs.core.PersistentHashMap.fromArrays(inst_36883,inst_36892);
var _ = (function (){var statearr_36900 = state_36898;
(statearr_36900[(4)] = cljs.core.rest((state_36898[(4)])));

return statearr_36900;
})();
var state_36898__$1 = state_36898;
var statearr_36901_36924 = state_36898__$1;
(statearr_36901_36924[(2)] = inst_36893);

(statearr_36901_36924[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36899 === (1))){
var state_36898__$1 = state_36898;
var statearr_36902_36925 = state_36898__$1;
(statearr_36902_36925[(2)] = null);

(statearr_36902_36925[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36899 === (4))){
var inst_36857 = (state_36898[(2)]);
var state_36898__$1 = state_36898;
var statearr_36903_36926 = state_36898__$1;
(statearr_36903_36926[(2)] = inst_36857);

(statearr_36903_36926[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36899 === (6))){
var _ = (function (){var statearr_36904 = state_36898;
(statearr_36904[(4)] = cljs.core.cons((9),(state_36898[(4)])));

return statearr_36904;
})();
var inst_36869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36871 = ["_setting/id","root"];
var inst_36872 = (new cljs.core.PersistentVector(null,2,(5),inst_36870,inst_36871,null));
var inst_36873 = [inst_36872];
var inst_36874 = (new cljs.core.PersistentVector(null,1,(5),inst_36869,inst_36873,null));
var inst_36875 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36874);
var state_36898__$1 = state_36898;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36898__$1,(10),inst_36875);
} else {
if((state_val_36899 === (3))){
var inst_36896 = (state_36898[(2)]);
var state_36898__$1 = state_36898;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36898__$1,inst_36896);
} else {
if((state_val_36899 === (2))){
var _ = (function (){var statearr_36907 = state_36898;
(statearr_36907[(4)] = cljs.core.cons((5),(state_36898[(4)])));

return statearr_36907;
})();
var state_36898__$1 = state_36898;
var statearr_36908_36927 = state_36898__$1;
(statearr_36908_36927[(2)] = null);

(statearr_36908_36927[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36899 === (9))){
var _ = (function (){var statearr_36909 = state_36898;
(statearr_36909[(4)] = cljs.core.rest((state_36898[(4)])));

return statearr_36909;
})();
var state_36898__$1 = state_36898;
var ex36905 = (state_36898__$1[(2)]);
var statearr_36910_36928 = state_36898__$1;
(statearr_36910_36928[(5)] = ex36905);


var statearr_36911_36929 = state_36898__$1;
(statearr_36911_36929[(1)] = (8));

(statearr_36911_36929[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_36899 === (5))){
var _ = (function (){var statearr_36912 = state_36898;
(statearr_36912[(4)] = cljs.core.rest((state_36898[(4)])));

return statearr_36912;
})();
var state_36898__$1 = state_36898;
var ex36906 = (state_36898__$1[(2)]);
var statearr_36913_36930 = state_36898__$1;
(statearr_36913_36930[(5)] = ex36906);


if((ex36906 instanceof Error)){
var statearr_36914_36931 = state_36898__$1;
(statearr_36914_36931[(1)] = (4));

(statearr_36914_36931[(5)] = null);

} else {
throw ex36906;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36899 === (10))){
var inst_36877 = (state_36898[(2)]);
var inst_36878 = fluree.db.util.async.throw_err(inst_36877);
var _ = (function (){var statearr_36915 = state_36898;
(statearr_36915[(4)] = cljs.core.rest((state_36898[(4)])));

return statearr_36915;
})();
var state_36898__$1 = state_36898;
var statearr_36916_36932 = state_36898__$1;
(statearr_36916_36932[(2)] = inst_36878);

(statearr_36916_36932[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36899 === (8))){
var inst_36863 = (state_36898[(2)]);
var state_36898__$1 = (function (){var statearr_36917 = state_36898;
(statearr_36917[(7)] = inst_36863);

return statearr_36917;
})();
var statearr_36918_36933 = state_36898__$1;
(statearr_36918_36933[(2)] = null);

(statearr_36918_36933[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__16301__auto____0 = (function (){
var statearr_36919 = [null,null,null,null,null,null,null,null];
(statearr_36919[(0)] = fluree$db$query$schema$setting_map_$_state_machine__16301__auto__);

(statearr_36919[(1)] = (1));

return statearr_36919;
});
var fluree$db$query$schema$setting_map_$_state_machine__16301__auto____1 = (function (state_36898){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_36898);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e36920){var ex__16304__auto__ = e36920;
var statearr_36921_36934 = state_36898;
(statearr_36921_36934[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_36898[(4)]))){
var statearr_36922_36935 = state_36898;
(statearr_36922_36935[(1)] = cljs.core.first((state_36898[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__36936 = state_36898;
state_36898 = G__36936;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__16301__auto__ = function(state_36898){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__16301__auto____1.call(this,state_36898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__16301__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__16301__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_36923 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_36923[(6)] = c__16375__auto__);

return statearr_36923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
