// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__33563 = cljs.core._EQ_;
var expr__33564 = e.getLastErrorCode();
if(cljs.core.truth_((pred__33563.cljs$core$IFn$_invoke$arity$2 ? pred__33563.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__33564) : pred__33563.call(null,goog.net.ErrorCode.NO_ERROR,expr__33564)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__33563.cljs$core$IFn$_invoke$arity$2 ? pred__33563.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__33564) : pred__33563.call(null,goog.net.ErrorCode.EXCEPTION,expr__33564)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__33563.cljs$core$IFn$_invoke$arity$2 ? pred__33563.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__33564) : pred__33563.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__33564)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__33563.cljs$core$IFn$_invoke$arity$2 ? pred__33563.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__33564) : pred__33563.call(null,goog.net.ErrorCode.ABORT,expr__33564)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__33563.cljs$core$IFn$_invoke$arity$2 ? pred__33563.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__33564) : pred__33563.call(null,goog.net.ErrorCode.TIMEOUT,expr__33564)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__33566 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33566,cljs.core.cst$kw$status,status);
} else {
return G__33566;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__33567 = opts;
var map__33567__$1 = (((((!((map__33567 == null))))?(((((map__33567.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33567.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33567):map__33567);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33567__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33567__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33567__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__33569 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__33569__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__33569,headers], 0)):G__33569);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33569__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__33569__$1;
}
})();
try{var G__33571_33577 = url;
var G__33572_33578 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__33573_33579 = "POST";
var G__33574_33580 = fluree.db.util.json.stringify(message);
var G__33575_33581 = cljs.core.clj__GT_js(headers__$1);
var G__33576_33582 = request_timeout;
goog.net.XhrIo.send(G__33571_33577,G__33572_33578,G__33573_33579,G__33574_33580,G__33575_33581,G__33576_33582);
}catch (e33570){var e_33583 = e33570;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_33583);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__33584 = opts;
var map__33584__$1 = (((((!((map__33584 == null))))?(((((map__33584.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33584.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33584):map__33584);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33584__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33584__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33584__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33584__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33584__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__33586 = cljs.core.PersistentArrayMap.EMPTY;
var G__33586__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__33586,headers], 0)):G__33586);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33586__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__33586__$1;
}
})();
try{var G__33588_33595 = url;
var G__33589_33596 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__33594 = output_format;
var G__33594__$1 = (((G__33594 instanceof cljs.core.Keyword))?G__33594.fqn:null);
switch (G__33594__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__33590_33597 = "GET";
var G__33591_33598 = body;
var G__33592_33599 = cljs.core.clj__GT_js(headers__$1);
var G__33593_33600 = request_timeout;
goog.net.XhrIo.send(G__33588_33595,G__33589_33596,G__33590_33597,G__33591_33598,G__33592_33599,G__33593_33600);
}catch (e33587){var e_33602 = e33587;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_33602);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__33603 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33603,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__33603;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33636){
var state_val_33637 = (state_33636[(1)]);
if((state_val_33637 === (7))){
var inst_33632 = (state_33636[(2)]);
var state_33636__$1 = state_33636;
var statearr_33638_33663 = state_33636__$1;
(statearr_33638_33663[(2)] = inst_33632);

(statearr_33638_33663[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33637 === (1))){
var state_33636__$1 = state_33636;
var statearr_33639_33664 = state_33636__$1;
(statearr_33639_33664[(2)] = null);

(statearr_33639_33664[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33637 === (4))){
var inst_33607 = (state_33636[(7)]);
var inst_33607__$1 = (state_33636[(2)]);
var inst_33608 = (inst_33607__$1 == null);
var state_33636__$1 = (function (){var statearr_33640 = state_33636;
(statearr_33640[(7)] = inst_33607__$1);

return statearr_33640;
})();
if(cljs.core.truth_(inst_33608)){
var statearr_33641_33665 = state_33636__$1;
(statearr_33641_33665[(1)] = (5));

} else {
var statearr_33642_33666 = state_33636__$1;
(statearr_33642_33666[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33637 === (6))){
var inst_33607 = (state_33636[(7)]);
var inst_33615 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33607,(0),null);
var inst_33616 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33607,(1),null);
var state_33636__$1 = (function (){var statearr_33643 = state_33636;
(statearr_33643[(8)] = inst_33615);

(statearr_33643[(9)] = inst_33616);

return statearr_33643;
})();
var statearr_33644_33667 = state_33636__$1;
(statearr_33644_33667[(2)] = null);

(statearr_33644_33667[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33637 === (3))){
var inst_33634 = (state_33636[(2)]);
var state_33636__$1 = state_33636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33636__$1,inst_33634);
} else {
if((state_val_33637 === (2))){
var state_33636__$1 = state_33636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33636__$1,(4),pub_chan);
} else {
if((state_val_33637 === (11))){
var _ = (function (){var statearr_33646 = state_33636;
(statearr_33646[(4)] = cljs.core.rest((state_33636[(4)])));

return statearr_33646;
})();
var state_33636__$1 = state_33636;
var ex33645 = (state_33636__$1[(2)]);
var statearr_33647_33668 = state_33636__$1;
(statearr_33647_33668[(5)] = ex33645);


if((ex33645 instanceof Error)){
var statearr_33648_33669 = state_33636__$1;
(statearr_33648_33669[(1)] = (10));

(statearr_33648_33669[(5)] = null);

} else {
throw ex33645;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33637 === (9))){
var inst_33629 = (state_33636[(2)]);
var state_33636__$1 = (function (){var statearr_33649 = state_33636;
(statearr_33649[(10)] = inst_33629);

return statearr_33649;
})();
var statearr_33650_33670 = state_33636__$1;
(statearr_33650_33670[(2)] = null);

(statearr_33650_33670[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33637 === (5))){
var inst_33610 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_33636__$1 = state_33636;
var statearr_33651_33671 = state_33636__$1;
(statearr_33651_33671[(2)] = inst_33610);

(statearr_33651_33671[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33637 === (10))){
var inst_33616 = (state_33636[(9)]);
var inst_33617 = (state_33636[(2)]);
var inst_33618 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_33617,"Websocket send message error:",inst_33617], 0));
var inst_33619 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33616,false);
var state_33636__$1 = (function (){var statearr_33652 = state_33636;
(statearr_33652[(11)] = inst_33618);

return statearr_33652;
})();
var statearr_33653_33672 = state_33636__$1;
(statearr_33653_33672[(2)] = inst_33619);

(statearr_33653_33672[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33637 === (8))){
var inst_33615 = (state_33636[(8)]);
var inst_33616 = (state_33636[(9)]);
var _ = (function (){var statearr_33654 = state_33636;
(statearr_33654[(4)] = cljs.core.cons((11),(state_33636[(4)])));

return statearr_33654;
})();
var inst_33625 = ws.send(inst_33615);
var inst_33626 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33616,true);
var ___$1 = (function (){var statearr_33655 = state_33636;
(statearr_33655[(4)] = cljs.core.rest((state_33636[(4)])));

return statearr_33655;
})();
var state_33636__$1 = (function (){var statearr_33656 = state_33636;
(statearr_33656[(12)] = inst_33625);

return statearr_33656;
})();
var statearr_33657_33673 = state_33636__$1;
(statearr_33657_33673[(2)] = inst_33626);

(statearr_33657_33673[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____0 = (function (){
var statearr_33658 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33658[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__);

(statearr_33658[(1)] = (1));

return statearr_33658;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____1 = (function (state_33636){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33636);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33659){var ex__16304__auto__ = e33659;
var statearr_33660_33674 = state_33636;
(statearr_33660_33674[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33636[(4)]))){
var statearr_33661_33675 = state_33636;
(statearr_33661_33675[(1)] = cljs.core.first((state_33636[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33676 = state_33636;
state_33636 = G__33676;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__ = function(state_33636){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____1.call(this,state_33636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33662 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33662[(6)] = c__16375__auto__);

return statearr_33662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__16375__auto___33715 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33702){
var state_val_33703 = (state_33702[(1)]);
if((state_val_33703 === (1))){
var inst_33681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33682 = [open_QMARK_,timeout_chan];
var inst_33683 = (new cljs.core.PersistentVector(null,2,(5),inst_33681,inst_33682,null));
var state_33702__$1 = state_33702;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_33702__$1,(2),inst_33683,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_33703 === (2))){
var inst_33685 = (state_33702[(2)]);
var inst_33686 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33685,(0),null);
var inst_33687 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33685,(1),null);
var inst_33688 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33687,timeout_chan);
var state_33702__$1 = (function (){var statearr_33704 = state_33702;
(statearr_33704[(7)] = inst_33686);

return statearr_33704;
})();
if(inst_33688){
var statearr_33705_33716 = state_33702__$1;
(statearr_33705_33716[(1)] = (3));

} else {
var statearr_33706_33717 = state_33702__$1;
(statearr_33706_33717[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (3))){
var inst_33690 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_33691 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33692 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_33693 = cljs.core.PersistentHashMap.fromArrays(inst_33691,inst_33692);
var inst_33694 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33690,inst_33693);
var inst_33695 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_33694);
var inst_33696 = fluree.db.util.xhttp.close_websocket(ws);
var state_33702__$1 = (function (){var statearr_33707 = state_33702;
(statearr_33707[(8)] = inst_33695);

return statearr_33707;
})();
var statearr_33708_33718 = state_33702__$1;
(statearr_33708_33718[(2)] = inst_33696);

(statearr_33708_33718[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (4))){
var inst_33698 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_33702__$1 = state_33702;
var statearr_33709_33719 = state_33702__$1;
(statearr_33709_33719[(2)] = inst_33698);

(statearr_33709_33719[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (5))){
var inst_33700 = (state_33702[(2)]);
var state_33702__$1 = state_33702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33702__$1,inst_33700);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____0 = (function (){
var statearr_33710 = [null,null,null,null,null,null,null,null,null];
(statearr_33710[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__);

(statearr_33710[(1)] = (1));

return statearr_33710;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____1 = (function (state_33702){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33702);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33711){var ex__16304__auto__ = e33711;
var statearr_33712_33720 = state_33702;
(statearr_33712_33720[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33702[(4)]))){
var statearr_33713_33721 = state_33702;
(statearr_33713_33721[(1)] = cljs.core.first((state_33702[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33722 = state_33702;
state_33702 = G__33722;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__ = function(state_33702){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____1.call(this,state_33702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33714 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33714[(6)] = c__16375__auto___33715);

return statearr_33714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
