// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__42394 = (line + (1));
var G__42395 = (1);
var G__42396 = (counter + (1));
line = G__42394;
col = G__42395;
counter = G__42396;
continue;
} else {
var G__42397 = line;
var G__42398 = (col + (1));
var G__42399 = (counter + (1));
line = G__42397;
col = G__42398;
counter = G__42399;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__42400 = cljs.core.next(chars);
var G__42401 = (n__$1 - (1));
chars = G__42400;
n__$1 = G__42401;
continue;
} else {
var G__42402 = cljs.core.next(chars);
var G__42403 = n__$1;
chars = G__42402;
n__$1 = G__42403;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__42404){
var map__42405 = p__42404;
var map__42405__$1 = (((((!((map__42405 == null))))?(((((map__42405.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42405.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42405):map__42405);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42405__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42405__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42405__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42405__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__42407_42415 = cljs.core.seq(full_reasons);
var chunk__42408_42416 = null;
var count__42409_42417 = (0);
var i__42410_42418 = (0);
while(true){
if((i__42410_42418 < count__42409_42417)){
var r_42419 = chunk__42408_42416.cljs$core$IIndexed$_nth$arity$2(null,i__42410_42418);
instaparse.failure.print_reason(r_42419);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__42420 = seq__42407_42415;
var G__42421 = chunk__42408_42416;
var G__42422 = count__42409_42417;
var G__42423 = (i__42410_42418 + (1));
seq__42407_42415 = G__42420;
chunk__42408_42416 = G__42421;
count__42409_42417 = G__42422;
i__42410_42418 = G__42423;
continue;
} else {
var temp__5735__auto___42424 = cljs.core.seq(seq__42407_42415);
if(temp__5735__auto___42424){
var seq__42407_42425__$1 = temp__5735__auto___42424;
if(cljs.core.chunked_seq_QMARK_(seq__42407_42425__$1)){
var c__4556__auto___42426 = cljs.core.chunk_first(seq__42407_42425__$1);
var G__42427 = cljs.core.chunk_rest(seq__42407_42425__$1);
var G__42428 = c__4556__auto___42426;
var G__42429 = cljs.core.count(c__4556__auto___42426);
var G__42430 = (0);
seq__42407_42415 = G__42427;
chunk__42408_42416 = G__42428;
count__42409_42417 = G__42429;
i__42410_42418 = G__42430;
continue;
} else {
var r_42431 = cljs.core.first(seq__42407_42425__$1);
instaparse.failure.print_reason(r_42431);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__42432 = cljs.core.next(seq__42407_42425__$1);
var G__42433 = null;
var G__42434 = (0);
var G__42435 = (0);
seq__42407_42415 = G__42432;
chunk__42408_42416 = G__42433;
count__42409_42417 = G__42434;
i__42410_42418 = G__42435;
continue;
}
} else {
}
}
break;
}

var seq__42411 = cljs.core.seq(partial_reasons);
var chunk__42412 = null;
var count__42413 = (0);
var i__42414 = (0);
while(true){
if((i__42414 < count__42413)){
var r = chunk__42412.cljs$core$IIndexed$_nth$arity$2(null,i__42414);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__42436 = seq__42411;
var G__42437 = chunk__42412;
var G__42438 = count__42413;
var G__42439 = (i__42414 + (1));
seq__42411 = G__42436;
chunk__42412 = G__42437;
count__42413 = G__42438;
i__42414 = G__42439;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__42411);
if(temp__5735__auto__){
var seq__42411__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__42411__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__42411__$1);
var G__42440 = cljs.core.chunk_rest(seq__42411__$1);
var G__42441 = c__4556__auto__;
var G__42442 = cljs.core.count(c__4556__auto__);
var G__42443 = (0);
seq__42411 = G__42440;
chunk__42412 = G__42441;
count__42413 = G__42442;
i__42414 = G__42443;
continue;
} else {
var r = cljs.core.first(seq__42411__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__42444 = cljs.core.next(seq__42411__$1);
var G__42445 = null;
var G__42446 = (0);
var G__42447 = (0);
seq__42411 = G__42444;
chunk__42412 = G__42445;
count__42413 = G__42446;
i__42414 = G__42447;
continue;
}
} else {
return null;
}
}
break;
}
});
