// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__7047 = s;
var map__7047__$1 = (((((!((map__7047 == null))))?(((((map__7047.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7047.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7047):map__7047);
var name = cljs.core.get.call(null,map__7047__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__7047__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__7050 = info;
var map__7051 = G__7050;
var map__7051__$1 = (((((!((map__7051 == null))))?(((((map__7051.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7051.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7051):map__7051);
var shadow = cljs.core.get.call(null,map__7051__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__7050__$1 = G__7050;
while(true){
var d__$2 = d__$1;
var map__7055 = G__7050__$1;
var map__7055__$1 = (((((!((map__7055 == null))))?(((((map__7055.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7055.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7055):map__7055);
var shadow__$1 = cljs.core.get.call(null,map__7055__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__7057 = (d__$2 + (1));
var G__7058 = shadow__$1;
d__$1 = G__7057;
G__7050__$1 = G__7058;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__7059){
var map__7060 = p__7059;
var map__7060__$1 = (((((!((map__7060 == null))))?(((((map__7060.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7060.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7060):map__7060);
var name_var = map__7060__$1;
var name = cljs.core.get.call(null,map__7060__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__7060__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__7062 = info;
var map__7062__$1 = (((((!((map__7062 == null))))?(((((map__7062.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7062.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7062):map__7062);
var ns = cljs.core.get.call(null,map__7062__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__7062__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.call(null,reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__7065 = arguments.length;
switch (G__7065) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11501,11501,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)])).call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__7067 = cp;
switch (G__7067) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__7069_7073 = cljs.core.seq.call(null,s);
var chunk__7070_7074 = null;
var count__7071_7075 = (0);
var i__7072_7076 = (0);
while(true){
if((i__7072_7076 < count__7071_7075)){
var c_7077 = cljs.core._nth.call(null,chunk__7070_7074,i__7072_7076);
sb.append(cljs.compiler.escape_char.call(null,c_7077));


var G__7078 = seq__7069_7073;
var G__7079 = chunk__7070_7074;
var G__7080 = count__7071_7075;
var G__7081 = (i__7072_7076 + (1));
seq__7069_7073 = G__7078;
chunk__7070_7074 = G__7079;
count__7071_7075 = G__7080;
i__7072_7076 = G__7081;
continue;
} else {
var temp__5735__auto___7082 = cljs.core.seq.call(null,seq__7069_7073);
if(temp__5735__auto___7082){
var seq__7069_7083__$1 = temp__5735__auto___7082;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7069_7083__$1)){
var c__4556__auto___7084 = cljs.core.chunk_first.call(null,seq__7069_7083__$1);
var G__7085 = cljs.core.chunk_rest.call(null,seq__7069_7083__$1);
var G__7086 = c__4556__auto___7084;
var G__7087 = cljs.core.count.call(null,c__4556__auto___7084);
var G__7088 = (0);
seq__7069_7073 = G__7085;
chunk__7070_7074 = G__7086;
count__7071_7075 = G__7087;
i__7072_7076 = G__7088;
continue;
} else {
var c_7089 = cljs.core.first.call(null,seq__7069_7083__$1);
sb.append(cljs.compiler.escape_char.call(null,c_7089));


var G__7090 = cljs.core.next.call(null,seq__7069_7083__$1);
var G__7091 = null;
var G__7092 = (0);
var G__7093 = (0);
seq__7069_7073 = G__7090;
chunk__7070_7074 = G__7091;
count__7071_7075 = G__7092;
i__7072_7076 = G__7093;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__7094_7099 = ast;
var map__7094_7100__$1 = (((((!((map__7094_7099 == null))))?(((((map__7094_7099.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7094_7099.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7094_7099):map__7094_7099);
var env_7101 = cljs.core.get.call(null,map__7094_7100__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_7101))){
var map__7096_7102 = env_7101;
var map__7096_7103__$1 = (((((!((map__7096_7102 == null))))?(((((map__7096_7102.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7096_7102.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7096_7102):map__7096_7102);
var line_7104 = cljs.core.get.call(null,map__7096_7103__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_7105 = cljs.core.get.call(null,map__7096_7103__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__7098 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast)))){
return cljs.core.assoc.call(null,G__7098,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__7098;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_7104 - (1))], null),cljs.core.fnil.call(null,(function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_7105)?(column_7105 - (1)):(0))], null),cljs.core.fnil.call(null,(function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__7114 = arguments.length;
switch (G__7114) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___7121 = arguments.length;
var i__4737__auto___7122 = (0);
while(true){
if((i__4737__auto___7122 < len__4736__auto___7121)){
args_arr__4757__auto__.push((arguments[i__4737__auto___7122]));

var G__7123 = (i__4737__auto___7122 + (1));
i__4737__auto___7122 = G__7123;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,a)){
cljs.compiler.emit.call(null,a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,a)){
cljs.core.apply.call(null,cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
a.call(null);
} else {
var s_7124 = (function (){var G__7115 = a;
if((!(typeof a === 'string'))){
return G__7115.toString();
} else {
return G__7115;
}
})();
var temp__5739__auto___7125 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___7125 == null)){
} else {
var sm_data_7126 = temp__5739__auto___7125;
cljs.core.swap_BANG_.call(null,sm_data_7126,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__7106_SHARP_){
return (p1__7106_SHARP_ + s_7124.length);
}));
}

cljs.core.print.call(null,s_7124);

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

return cljs.compiler.emits.call(null,b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler.emits.call(null,c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler.emits.call(null,d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler.emits.call(null,e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__7116 = cljs.core.seq.call(null,xs);
var chunk__7117 = null;
var count__7118 = (0);
var i__7119 = (0);
while(true){
if((i__7119 < count__7118)){
var x = cljs.core._nth.call(null,chunk__7117,i__7119);
cljs.compiler.emits.call(null,x);


var G__7127 = seq__7116;
var G__7128 = chunk__7117;
var G__7129 = count__7118;
var G__7130 = (i__7119 + (1));
seq__7116 = G__7127;
chunk__7117 = G__7128;
count__7118 = G__7129;
i__7119 = G__7130;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__7116);
if(temp__5735__auto__){
var seq__7116__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7116__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__7116__$1);
var G__7131 = cljs.core.chunk_rest.call(null,seq__7116__$1);
var G__7132 = c__4556__auto__;
var G__7133 = cljs.core.count.call(null,c__4556__auto__);
var G__7134 = (0);
seq__7116 = G__7131;
chunk__7117 = G__7132;
count__7118 = G__7133;
i__7119 = G__7134;
continue;
} else {
var x = cljs.core.first.call(null,seq__7116__$1);
cljs.compiler.emits.call(null,x);


var G__7135 = cljs.core.next.call(null,seq__7116__$1);
var G__7136 = null;
var G__7137 = (0);
var G__7138 = (0);
seq__7116 = G__7135;
chunk__7117 = G__7136;
count__7118 = G__7137;
i__7119 = G__7138;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq7108){
var G__7109 = cljs.core.first.call(null,seq7108);
var seq7108__$1 = cljs.core.next.call(null,seq7108);
var G__7110 = cljs.core.first.call(null,seq7108__$1);
var seq7108__$2 = cljs.core.next.call(null,seq7108__$1);
var G__7111 = cljs.core.first.call(null,seq7108__$2);
var seq7108__$3 = cljs.core.next.call(null,seq7108__$2);
var G__7112 = cljs.core.first.call(null,seq7108__$3);
var seq7108__$4 = cljs.core.next.call(null,seq7108__$3);
var G__7113 = cljs.core.first.call(null,seq7108__$4);
var seq7108__$5 = cljs.core.next.call(null,seq7108__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7109,G__7110,G__7111,G__7112,G__7113,seq7108__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.call(null);

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__7139){
var map__7140 = p__7139;
var map__7140__$1 = (((((!((map__7140 == null))))?(((((map__7140.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7140.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7140):map__7140);
var m = map__7140__$1;
var gen_line = cljs.core.get.call(null,map__7140__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__7149 = arguments.length;
switch (G__7149) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___7155 = arguments.length;
var i__4737__auto___7156 = (0);
while(true){
if((i__4737__auto___7156 < len__4736__auto___7155)){
args_arr__4757__auto__.push((arguments[i__4737__auto___7156]));

var G__7157 = (i__4737__auto___7156 + (1));
i__4737__auto___7156 = G__7157;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.call(null,a);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__7150_7158 = cljs.core.seq.call(null,xs);
var chunk__7151_7159 = null;
var count__7152_7160 = (0);
var i__7153_7161 = (0);
while(true){
if((i__7153_7161 < count__7152_7160)){
var x_7162 = cljs.core._nth.call(null,chunk__7151_7159,i__7153_7161);
cljs.compiler.emits.call(null,x_7162);


var G__7163 = seq__7150_7158;
var G__7164 = chunk__7151_7159;
var G__7165 = count__7152_7160;
var G__7166 = (i__7153_7161 + (1));
seq__7150_7158 = G__7163;
chunk__7151_7159 = G__7164;
count__7152_7160 = G__7165;
i__7153_7161 = G__7166;
continue;
} else {
var temp__5735__auto___7167 = cljs.core.seq.call(null,seq__7150_7158);
if(temp__5735__auto___7167){
var seq__7150_7168__$1 = temp__5735__auto___7167;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7150_7168__$1)){
var c__4556__auto___7169 = cljs.core.chunk_first.call(null,seq__7150_7168__$1);
var G__7170 = cljs.core.chunk_rest.call(null,seq__7150_7168__$1);
var G__7171 = c__4556__auto___7169;
var G__7172 = cljs.core.count.call(null,c__4556__auto___7169);
var G__7173 = (0);
seq__7150_7158 = G__7170;
chunk__7151_7159 = G__7171;
count__7152_7160 = G__7172;
i__7153_7161 = G__7173;
continue;
} else {
var x_7174 = cljs.core.first.call(null,seq__7150_7168__$1);
cljs.compiler.emits.call(null,x_7174);


var G__7175 = cljs.core.next.call(null,seq__7150_7168__$1);
var G__7176 = null;
var G__7177 = (0);
var G__7178 = (0);
seq__7150_7158 = G__7175;
chunk__7151_7159 = G__7176;
count__7152_7160 = G__7177;
i__7153_7161 = G__7178;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln.call(null);
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq7143){
var G__7144 = cljs.core.first.call(null,seq7143);
var seq7143__$1 = cljs.core.next.call(null,seq7143);
var G__7145 = cljs.core.first.call(null,seq7143__$1);
var seq7143__$2 = cljs.core.next.call(null,seq7143__$1);
var G__7146 = cljs.core.first.call(null,seq7143__$2);
var seq7143__$3 = cljs.core.next.call(null,seq7143__$2);
var G__7147 = cljs.core.first.call(null,seq7143__$3);
var seq7143__$4 = cljs.core.next.call(null,seq7143__$3);
var G__7148 = cljs.core.first.call(null,seq7143__$4);
var seq7143__$5 = cljs.core.next.call(null,seq7143__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7144,G__7145,G__7146,G__7147,G__7148,seq7143__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__7179_7183 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__7180_7184 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__7181_7185 = true;
var _STAR_print_fn_STAR__temp_val__7182_7186 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__7181_7185);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__7182_7186);

try{cljs.compiler.emit.call(null,expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__7180_7184);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__7179_7183);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.call(null,cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x)){
return cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.core.record_QMARK_.call(null,x)){
var vec__7187 = cljs.analyzer.record_ns_PLUS_name.call(null,x);
var ns = cljs.core.nth.call(null,vec__7187,(0),null);
var name = cljs.core.nth.call(null,vec__7187,(1),null);
return cljs.compiler.emit_record_value.call(null,ns,name,(function (){
return cljs.compiler.emit_constant.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,x));
}));
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x)){
return cljs.compiler.emit_map.call(null,cljs.core.keys.call(null,x),cljs.core.vals.call(null,x),cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
if(cljs.analyzer.cljs_vector_QMARK_.call(null,x)){
return cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.analyzer.cljs_set_QMARK_.call(null,x)){
return cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
return cljs.compiler.emit_constant_STAR_.call(null,x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta.call(null,cljs.core.meta.call(null,v));
if((!((cljs.core.seq.call(null,m) == null)))){
return cljs.compiler.emit_with_meta.call(null,(function (){
return cljs.compiler.emit_constant_no_meta.call(null,v);
}),(function (){
return cljs.compiler.emit_constant_no_meta.call(null,m);
}));
} else {
return cljs.compiler.emit_constant_no_meta.call(null,v);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.call(null,cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__7190 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.call(null,vec__7190,(0),null);
var flags = cljs.core.nth.call(null,vec__7190,(1),null);
var pattern = cljs.core.nth.call(null,vec__7190,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.call(null,cljs.core.map_indexed.call(null,(function (i,m){
if(cljs.core.even_QMARK_.call(null,i)){
return cljs.compiler.emit_constant.call(null,m);
} else {
return cljs.compiler.emits.call(null,m);
}
}),cljs.compiler.comma_sep.call(null,cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Date,(function (date){
return cljs.compiler.emits.call(null,"new Date(",date.getTime(),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_.call(null,items)){
return cljs.compiler.emit_js_object.call(null,items,(function (p1__7193_SHARP_){
return (function (){
return cljs.compiler.emit_constant.call(null,p1__7193_SHARP_);
});
}));
} else {
return cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__7195){
var map__7196 = p__7195;
var map__7196__$1 = (((((!((map__7196 == null))))?(((((map__7196.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7196.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7196):map__7196);
var ast = map__7196__$1;
var info = cljs.core.get.call(null,map__7196__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__7196__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__7196__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__7198 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__7198__$1 = (((((!((map__7198 == null))))?(((((map__7198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7198.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7198):map__7198);
var cenv = map__7198__$1;
var options = cljs.core.get.call(null,map__7198__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4126__auto__ = js_module_name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__7200 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.namespace.call(null,var_name) == null)));
} else {
return and__4115__auto__;
}
})())){
return clojure.set.difference.call(null,G__7200,cljs.analyzer.es5_allowed);
} else {
return G__7200;
}
})();
var js_module = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4126__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})()], null));
var info__$2 = (function (){var G__7201 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__7201,reserved);
} else {
return G__7201;
}
})();
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var G__7202_7203 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__7202_7204__$1 = (((G__7202_7203 instanceof cljs.core.Keyword))?G__7202_7203.fqn:null);
switch (G__7202_7204__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace.call(null,var_name))){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"].",cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved));
} else {
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,"default",cljs.core.name.call(null,var_name));
} else {
return and__4115__auto__;
}
})())){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.call(null,info__$2);
}

break;
default:
cljs.compiler.emits.call(null,info__$2);

}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__7206){
var map__7207 = p__7206;
var map__7207__$1 = (((((!((map__7207 == null))))?(((((map__7207.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7207.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7207):map__7207);
var arg = map__7207__$1;
var env = cljs.core.get.call(null,map__7207__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__7207__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__7207__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__7207__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__7209 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__7209__$1 = (((((!((map__7209 == null))))?(((((map__7209.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7209.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7209):map__7209);
var name = cljs.core.get.call(null,map__7209__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__7211){
var map__7212 = p__7211;
var map__7212__$1 = (((((!((map__7212 == null))))?(((((map__7212.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7212.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7212):map__7212);
var expr = cljs.core.get.call(null,map__7212__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__7212__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__7212__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_with_meta.call(null,expr,meta);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_.call(null,(function (p1__7214_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__7214_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count.call(null,keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count.call(null,keys) === (0))){
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(distinct_keys_QMARK_.call(null,keys))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",comma_sep.call(null,keys),"],[",comma_sep.call(null,vals),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__7215){
var map__7216 = p__7215;
var map__7216__$1 = (((((!((map__7216 == null))))?(((((map__7216.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7216.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7216):map__7216);
var env = cljs.core.get.call(null,map__7216__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__7216__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__7216__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_map.call(null,keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.call(null,"cljs.core.list(",comma_sep.call(null,items),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count.call(null,items);
if((cnt < (32))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",comma_sep.call(null,items),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",comma_sep.call(null,items),"], true)");
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__7218){
var map__7219 = p__7218;
var map__7219__$1 = (((((!((map__7219 == null))))?(((((map__7219.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7219.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7219):map__7219);
var items = cljs.core.get.call(null,map__7219__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__7219__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_vector.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_.call(null,(function (p1__7221_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__7221_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count.call(null,items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(distinct_constants_QMARK_.call(null,items))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",comma_sep.call(null,items),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__7222){
var map__7223 = p__7222;
var map__7223__$1 = (((((!((map__7223 == null))))?(((((map__7223.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7223.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7223):map__7223);
var items = cljs.core.get.call(null,map__7223__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__7223__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_set.call(null,items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.call(null,"({");

var temp__5735__auto___7247 = cljs.core.seq.call(null,items);
if(temp__5735__auto___7247){
var items_7248__$1 = temp__5735__auto___7247;
var vec__7225_7249 = items_7248__$1;
var seq__7226_7250 = cljs.core.seq.call(null,vec__7225_7249);
var first__7227_7251 = cljs.core.first.call(null,seq__7226_7250);
var seq__7226_7252__$1 = cljs.core.next.call(null,seq__7226_7250);
var vec__7228_7253 = first__7227_7251;
var k_7254 = cljs.core.nth.call(null,vec__7228_7253,(0),null);
var v_7255 = cljs.core.nth.call(null,vec__7228_7253,(1),null);
var r_7256 = seq__7226_7252__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_7254),"\": ",emit_js_object_val.call(null,v_7255));

var seq__7231_7257 = cljs.core.seq.call(null,r_7256);
var chunk__7232_7258 = null;
var count__7233_7259 = (0);
var i__7234_7260 = (0);
while(true){
if((i__7234_7260 < count__7233_7259)){
var vec__7241_7261 = cljs.core._nth.call(null,chunk__7232_7258,i__7234_7260);
var k_7262__$1 = cljs.core.nth.call(null,vec__7241_7261,(0),null);
var v_7263__$1 = cljs.core.nth.call(null,vec__7241_7261,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_7262__$1),"\": ",emit_js_object_val.call(null,v_7263__$1));


var G__7264 = seq__7231_7257;
var G__7265 = chunk__7232_7258;
var G__7266 = count__7233_7259;
var G__7267 = (i__7234_7260 + (1));
seq__7231_7257 = G__7264;
chunk__7232_7258 = G__7265;
count__7233_7259 = G__7266;
i__7234_7260 = G__7267;
continue;
} else {
var temp__5735__auto___7268__$1 = cljs.core.seq.call(null,seq__7231_7257);
if(temp__5735__auto___7268__$1){
var seq__7231_7269__$1 = temp__5735__auto___7268__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7231_7269__$1)){
var c__4556__auto___7270 = cljs.core.chunk_first.call(null,seq__7231_7269__$1);
var G__7271 = cljs.core.chunk_rest.call(null,seq__7231_7269__$1);
var G__7272 = c__4556__auto___7270;
var G__7273 = cljs.core.count.call(null,c__4556__auto___7270);
var G__7274 = (0);
seq__7231_7257 = G__7271;
chunk__7232_7258 = G__7272;
count__7233_7259 = G__7273;
i__7234_7260 = G__7274;
continue;
} else {
var vec__7244_7275 = cljs.core.first.call(null,seq__7231_7269__$1);
var k_7276__$1 = cljs.core.nth.call(null,vec__7244_7275,(0),null);
var v_7277__$1 = cljs.core.nth.call(null,vec__7244_7275,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_7276__$1),"\": ",emit_js_object_val.call(null,v_7277__$1));


var G__7278 = cljs.core.next.call(null,seq__7231_7269__$1);
var G__7279 = null;
var G__7280 = (0);
var G__7281 = (0);
seq__7231_7257 = G__7278;
chunk__7232_7258 = G__7279;
count__7233_7259 = G__7280;
i__7234_7260 = G__7281;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.call(null,"[",comma_sep.call(null,items),"]");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__7282){
var map__7283 = p__7282;
var map__7283__$1 = (((((!((map__7283 == null))))?(((((map__7283.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7283.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7283):map__7283);
var keys = cljs.core.get.call(null,map__7283__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__7283__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.call(null,map__7283__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_object.call(null,cljs.core.map.call(null,cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__7285){
var map__7286 = p__7285;
var map__7286__$1 = (((((!((map__7286 == null))))?(((((map__7286.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7286.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7286):map__7286);
var items = cljs.core.get.call(null,map__7286__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__7286__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_array.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__7288){
var map__7289 = p__7288;
var map__7289__$1 = (((((!((map__7289 == null))))?(((((map__7289.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7289.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7289):map__7289);
var expr = cljs.core.get.call(null,map__7289__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__7291){
var map__7292 = p__7291;
var map__7292__$1 = (((((!((map__7292 == null))))?(((((map__7292.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7292.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7292):map__7292);
var form = cljs.core.get.call(null,map__7292__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__7292__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__7294 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__7294__$1 = (((((!((map__7294 == null))))?(((((map__7294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7294.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7294):map__7294);
var op = cljs.core.get.call(null,map__7294__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__7294__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__7294__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4126__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4115__auto__ = form;
if(cljs.core.truth_(and__4115__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.call(null,form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4115__auto__;
}
})():false);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__7296 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__7296__$1 = (((((!((map__7296 == null))))?(((((map__7296.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7296.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7296):map__7296);
var op = cljs.core.get.call(null,map__7296__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__7296__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__7296__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4126__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4126__auto__){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__4126__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__7298){
var map__7299 = p__7298;
var map__7299__$1 = (((((!((map__7299 == null))))?(((((map__7299.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7299.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7299):map__7299);
var test = cljs.core.get.call(null,map__7299__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__7299__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__7299__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__7299__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__7299__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__4126__auto__ = unchecked;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__7301){
var map__7302 = p__7301;
var map__7302__$1 = (((((!((map__7302 == null))))?(((((map__7302.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7302.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7302):map__7302);
var v = cljs.core.get.call(null,map__7302__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.call(null,map__7302__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.call(null,map__7302__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__7302__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__7304_7340 = cljs.core.seq.call(null,nodes);
var chunk__7305_7341 = null;
var count__7306_7342 = (0);
var i__7307_7343 = (0);
while(true){
if((i__7307_7343 < count__7306_7342)){
var map__7324_7344 = cljs.core._nth.call(null,chunk__7305_7341,i__7307_7343);
var map__7324_7345__$1 = (((((!((map__7324_7344 == null))))?(((((map__7324_7344.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7324_7344.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7324_7344):map__7324_7344);
var ts_7346 = cljs.core.get.call(null,map__7324_7345__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__7325_7347 = cljs.core.get.call(null,map__7324_7345__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__7325_7348__$1 = (((((!((map__7325_7347 == null))))?(((((map__7325_7347.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7325_7347.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7325_7347):map__7325_7347);
var then_7349 = cljs.core.get.call(null,map__7325_7348__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__7328_7350 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_7346));
var chunk__7329_7351 = null;
var count__7330_7352 = (0);
var i__7331_7353 = (0);
while(true){
if((i__7331_7353 < count__7330_7352)){
var test_7354 = cljs.core._nth.call(null,chunk__7329_7351,i__7331_7353);
cljs.compiler.emitln.call(null,"case ",test_7354,":");


var G__7355 = seq__7328_7350;
var G__7356 = chunk__7329_7351;
var G__7357 = count__7330_7352;
var G__7358 = (i__7331_7353 + (1));
seq__7328_7350 = G__7355;
chunk__7329_7351 = G__7356;
count__7330_7352 = G__7357;
i__7331_7353 = G__7358;
continue;
} else {
var temp__5735__auto___7359 = cljs.core.seq.call(null,seq__7328_7350);
if(temp__5735__auto___7359){
var seq__7328_7360__$1 = temp__5735__auto___7359;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7328_7360__$1)){
var c__4556__auto___7361 = cljs.core.chunk_first.call(null,seq__7328_7360__$1);
var G__7362 = cljs.core.chunk_rest.call(null,seq__7328_7360__$1);
var G__7363 = c__4556__auto___7361;
var G__7364 = cljs.core.count.call(null,c__4556__auto___7361);
var G__7365 = (0);
seq__7328_7350 = G__7362;
chunk__7329_7351 = G__7363;
count__7330_7352 = G__7364;
i__7331_7353 = G__7365;
continue;
} else {
var test_7366 = cljs.core.first.call(null,seq__7328_7360__$1);
cljs.compiler.emitln.call(null,"case ",test_7366,":");


var G__7367 = cljs.core.next.call(null,seq__7328_7360__$1);
var G__7368 = null;
var G__7369 = (0);
var G__7370 = (0);
seq__7328_7350 = G__7367;
chunk__7329_7351 = G__7368;
count__7330_7352 = G__7369;
i__7331_7353 = G__7370;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_7349);
} else {
cljs.compiler.emitln.call(null,then_7349);
}

cljs.compiler.emitln.call(null,"break;");


var G__7371 = seq__7304_7340;
var G__7372 = chunk__7305_7341;
var G__7373 = count__7306_7342;
var G__7374 = (i__7307_7343 + (1));
seq__7304_7340 = G__7371;
chunk__7305_7341 = G__7372;
count__7306_7342 = G__7373;
i__7307_7343 = G__7374;
continue;
} else {
var temp__5735__auto___7375 = cljs.core.seq.call(null,seq__7304_7340);
if(temp__5735__auto___7375){
var seq__7304_7376__$1 = temp__5735__auto___7375;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7304_7376__$1)){
var c__4556__auto___7377 = cljs.core.chunk_first.call(null,seq__7304_7376__$1);
var G__7378 = cljs.core.chunk_rest.call(null,seq__7304_7376__$1);
var G__7379 = c__4556__auto___7377;
var G__7380 = cljs.core.count.call(null,c__4556__auto___7377);
var G__7381 = (0);
seq__7304_7340 = G__7378;
chunk__7305_7341 = G__7379;
count__7306_7342 = G__7380;
i__7307_7343 = G__7381;
continue;
} else {
var map__7332_7382 = cljs.core.first.call(null,seq__7304_7376__$1);
var map__7332_7383__$1 = (((((!((map__7332_7382 == null))))?(((((map__7332_7382.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7332_7382.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7332_7382):map__7332_7382);
var ts_7384 = cljs.core.get.call(null,map__7332_7383__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__7333_7385 = cljs.core.get.call(null,map__7332_7383__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__7333_7386__$1 = (((((!((map__7333_7385 == null))))?(((((map__7333_7385.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7333_7385.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7333_7385):map__7333_7385);
var then_7387 = cljs.core.get.call(null,map__7333_7386__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__7336_7388 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_7384));
var chunk__7337_7389 = null;
var count__7338_7390 = (0);
var i__7339_7391 = (0);
while(true){
if((i__7339_7391 < count__7338_7390)){
var test_7392 = cljs.core._nth.call(null,chunk__7337_7389,i__7339_7391);
cljs.compiler.emitln.call(null,"case ",test_7392,":");


var G__7393 = seq__7336_7388;
var G__7394 = chunk__7337_7389;
var G__7395 = count__7338_7390;
var G__7396 = (i__7339_7391 + (1));
seq__7336_7388 = G__7393;
chunk__7337_7389 = G__7394;
count__7338_7390 = G__7395;
i__7339_7391 = G__7396;
continue;
} else {
var temp__5735__auto___7397__$1 = cljs.core.seq.call(null,seq__7336_7388);
if(temp__5735__auto___7397__$1){
var seq__7336_7398__$1 = temp__5735__auto___7397__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7336_7398__$1)){
var c__4556__auto___7399 = cljs.core.chunk_first.call(null,seq__7336_7398__$1);
var G__7400 = cljs.core.chunk_rest.call(null,seq__7336_7398__$1);
var G__7401 = c__4556__auto___7399;
var G__7402 = cljs.core.count.call(null,c__4556__auto___7399);
var G__7403 = (0);
seq__7336_7388 = G__7400;
chunk__7337_7389 = G__7401;
count__7338_7390 = G__7402;
i__7339_7391 = G__7403;
continue;
} else {
var test_7404 = cljs.core.first.call(null,seq__7336_7398__$1);
cljs.compiler.emitln.call(null,"case ",test_7404,":");


var G__7405 = cljs.core.next.call(null,seq__7336_7398__$1);
var G__7406 = null;
var G__7407 = (0);
var G__7408 = (0);
seq__7336_7388 = G__7405;
chunk__7337_7389 = G__7406;
count__7338_7390 = G__7407;
i__7339_7391 = G__7408;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_7387);
} else {
cljs.compiler.emitln.call(null,then_7387);
}

cljs.compiler.emitln.call(null,"break;");


var G__7409 = cljs.core.next.call(null,seq__7304_7376__$1);
var G__7410 = null;
var G__7411 = (0);
var G__7412 = (0);
seq__7304_7340 = G__7409;
chunk__7305_7341 = G__7410;
count__7306_7342 = G__7411;
i__7307_7343 = G__7412;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__7413){
var map__7414 = p__7413;
var map__7414__$1 = (((((!((map__7414 == null))))?(((((map__7414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7414.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7414):map__7414);
var throw$ = cljs.core.get.call(null,map__7414__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.call(null,map__7414__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__7417 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__7417,(0),null);
var rstr = cljs.core.nth.call(null,vec__7417,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,(function (p1__7416_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__7416_SHARP_);
}),clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__7420 = ["function(",clojure.string.join.call(null,",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__7420,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__7420;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",clojure.string.join.call(null,"|",cljs.core.map.call(null,(function (p1__7421_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__7421_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__7422 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__7423 = cljs.core.seq.call(null,vec__7422);
var first__7424 = cljs.core.first.call(null,seq__7423);
var seq__7423__$1 = cljs.core.next.call(null,seq__7423);
var p = first__7424;
var first__7424__$1 = cljs.core.first.call(null,seq__7423__$1);
var seq__7423__$2 = cljs.core.next.call(null,seq__7423__$1);
var ts = first__7424__$1;
var first__7424__$2 = cljs.core.first.call(null,seq__7423__$2);
var seq__7423__$3 = cljs.core.next.call(null,seq__7423__$2);
var n = first__7424__$2;
var xs = seq__7423__$3;
if(cljs.core.truth_(((cljs.core._EQ_.call(null,"@param",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__7425 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__7426 = cljs.core.seq.call(null,vec__7425);
var first__7427 = cljs.core.first.call(null,seq__7426);
var seq__7426__$1 = cljs.core.next.call(null,seq__7426);
var p = first__7427;
var first__7427__$1 = cljs.core.first.call(null,seq__7426__$1);
var seq__7426__$2 = cljs.core.next.call(null,seq__7426__$1);
var ts = first__7427__$1;
var xs = seq__7426__$2;
if(cljs.core.truth_(((cljs.core._EQ_.call(null,"@return",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__7430 = arguments.length;
switch (G__7430) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__7438 = cljs.core.map.call(null,(function (p1__7428_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__7428_SHARP_);
} else {
return p1__7428_SHARP_;
}
}),clojure.string.split_lines.call(null,e));
var seq__7439 = cljs.core.seq.call(null,vec__7438);
var first__7440 = cljs.core.first.call(null,seq__7439);
var seq__7439__$1 = cljs.core.next.call(null,seq__7439);
var x = first__7440;
var ys = seq__7439__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__7441 = cljs.core.seq.call(null,ys);
var chunk__7442 = null;
var count__7443 = (0);
var i__7444 = (0);
while(true){
if((i__7444 < count__7443)){
var next_line = cljs.core._nth.call(null,chunk__7442,i__7444);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__7450 = seq__7441;
var G__7451 = chunk__7442;
var G__7452 = count__7443;
var G__7453 = (i__7444 + (1));
seq__7441 = G__7450;
chunk__7442 = G__7451;
count__7443 = G__7452;
i__7444 = G__7453;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__7441);
if(temp__5735__auto__){
var seq__7441__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7441__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__7441__$1);
var G__7454 = cljs.core.chunk_rest.call(null,seq__7441__$1);
var G__7455 = c__4556__auto__;
var G__7456 = cljs.core.count.call(null,c__4556__auto__);
var G__7457 = (0);
seq__7441 = G__7454;
chunk__7442 = G__7455;
count__7443 = G__7456;
i__7444 = G__7457;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__7441__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__7458 = cljs.core.next.call(null,seq__7441__$1);
var G__7459 = null;
var G__7460 = (0);
var G__7461 = (0);
seq__7441 = G__7458;
chunk__7442 = G__7459;
count__7443 = G__7460;
i__7444 = G__7461;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__7445_7462 = cljs.core.seq.call(null,docs__$2);
var chunk__7446_7463 = null;
var count__7447_7464 = (0);
var i__7448_7465 = (0);
while(true){
if((i__7448_7465 < count__7447_7464)){
var e_7466 = cljs.core._nth.call(null,chunk__7446_7463,i__7448_7465);
if(cljs.core.truth_(e_7466)){
print_comment_lines.call(null,e_7466);
} else {
}


var G__7467 = seq__7445_7462;
var G__7468 = chunk__7446_7463;
var G__7469 = count__7447_7464;
var G__7470 = (i__7448_7465 + (1));
seq__7445_7462 = G__7467;
chunk__7446_7463 = G__7468;
count__7447_7464 = G__7469;
i__7448_7465 = G__7470;
continue;
} else {
var temp__5735__auto___7471 = cljs.core.seq.call(null,seq__7445_7462);
if(temp__5735__auto___7471){
var seq__7445_7472__$1 = temp__5735__auto___7471;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7445_7472__$1)){
var c__4556__auto___7473 = cljs.core.chunk_first.call(null,seq__7445_7472__$1);
var G__7474 = cljs.core.chunk_rest.call(null,seq__7445_7472__$1);
var G__7475 = c__4556__auto___7473;
var G__7476 = cljs.core.count.call(null,c__4556__auto___7473);
var G__7477 = (0);
seq__7445_7462 = G__7474;
chunk__7446_7463 = G__7475;
count__7447_7464 = G__7476;
i__7448_7465 = G__7477;
continue;
} else {
var e_7478 = cljs.core.first.call(null,seq__7445_7472__$1);
if(cljs.core.truth_(e_7478)){
print_comment_lines.call(null,e_7478);
} else {
}


var G__7479 = cljs.core.next.call(null,seq__7445_7472__$1);
var G__7480 = null;
var G__7481 = (0);
var G__7482 = (0);
seq__7445_7462 = G__7479;
chunk__7446_7463 = G__7480;
count__7447_7464 = G__7481;
i__7448_7465 = G__7482;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4115__auto__ = cljs.core.some.call(null,(function (p1__7484_SHARP_){
return goog.string.startsWith(p1__7484_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = opts;
if(cljs.core.truth_(and__4115__auto____$1)){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_.call(null,define)){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return false;
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__7485){
var map__7486 = p__7485;
var map__7486__$1 = (((((!((map__7486 == null))))?(((((map__7486.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7486.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7486):map__7486);
var doc = cljs.core.get.call(null,map__7486__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__7486__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.call(null,map__7486__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.call(null,map__7486__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.call(null,map__7486__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.call(null,map__7486__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__7486__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.call(null,map__7486__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.call(null,map__7486__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.call(null,map__7486__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4126__auto__ = init;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,(cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
return test;
} else {
return and__4115__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__7488){
var map__7489 = p__7488;
var map__7489__$1 = (((((!((map__7489 == null))))?(((((map__7489.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7489.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7489):map__7489);
var name = cljs.core.get.call(null,map__7489__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7489__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7489__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__7491_7515 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__7492_7516 = null;
var count__7493_7517 = (0);
var i__7494_7518 = (0);
while(true){
if((i__7494_7518 < count__7493_7517)){
var vec__7501_7519 = cljs.core._nth.call(null,chunk__7492_7516,i__7494_7518);
var i_7520 = cljs.core.nth.call(null,vec__7501_7519,(0),null);
var param_7521 = cljs.core.nth.call(null,vec__7501_7519,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_7521);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__7522 = seq__7491_7515;
var G__7523 = chunk__7492_7516;
var G__7524 = count__7493_7517;
var G__7525 = (i__7494_7518 + (1));
seq__7491_7515 = G__7522;
chunk__7492_7516 = G__7523;
count__7493_7517 = G__7524;
i__7494_7518 = G__7525;
continue;
} else {
var temp__5735__auto___7526 = cljs.core.seq.call(null,seq__7491_7515);
if(temp__5735__auto___7526){
var seq__7491_7527__$1 = temp__5735__auto___7526;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7491_7527__$1)){
var c__4556__auto___7528 = cljs.core.chunk_first.call(null,seq__7491_7527__$1);
var G__7529 = cljs.core.chunk_rest.call(null,seq__7491_7527__$1);
var G__7530 = c__4556__auto___7528;
var G__7531 = cljs.core.count.call(null,c__4556__auto___7528);
var G__7532 = (0);
seq__7491_7515 = G__7529;
chunk__7492_7516 = G__7530;
count__7493_7517 = G__7531;
i__7494_7518 = G__7532;
continue;
} else {
var vec__7504_7533 = cljs.core.first.call(null,seq__7491_7527__$1);
var i_7534 = cljs.core.nth.call(null,vec__7504_7533,(0),null);
var param_7535 = cljs.core.nth.call(null,vec__7504_7533,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_7535);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__7536 = cljs.core.next.call(null,seq__7491_7527__$1);
var G__7537 = null;
var G__7538 = (0);
var G__7539 = (0);
seq__7491_7515 = G__7536;
chunk__7492_7516 = G__7537;
count__7493_7517 = G__7538;
i__7494_7518 = G__7539;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__7507_7540 = cljs.core.seq.call(null,params);
var chunk__7508_7541 = null;
var count__7509_7542 = (0);
var i__7510_7543 = (0);
while(true){
if((i__7510_7543 < count__7509_7542)){
var param_7544 = cljs.core._nth.call(null,chunk__7508_7541,i__7510_7543);
cljs.compiler.emit.call(null,param_7544);

if(cljs.core._EQ_.call(null,param_7544,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7545 = seq__7507_7540;
var G__7546 = chunk__7508_7541;
var G__7547 = count__7509_7542;
var G__7548 = (i__7510_7543 + (1));
seq__7507_7540 = G__7545;
chunk__7508_7541 = G__7546;
count__7509_7542 = G__7547;
i__7510_7543 = G__7548;
continue;
} else {
var temp__5735__auto___7549 = cljs.core.seq.call(null,seq__7507_7540);
if(temp__5735__auto___7549){
var seq__7507_7550__$1 = temp__5735__auto___7549;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7507_7550__$1)){
var c__4556__auto___7551 = cljs.core.chunk_first.call(null,seq__7507_7550__$1);
var G__7552 = cljs.core.chunk_rest.call(null,seq__7507_7550__$1);
var G__7553 = c__4556__auto___7551;
var G__7554 = cljs.core.count.call(null,c__4556__auto___7551);
var G__7555 = (0);
seq__7507_7540 = G__7552;
chunk__7508_7541 = G__7553;
count__7509_7542 = G__7554;
i__7510_7543 = G__7555;
continue;
} else {
var param_7556 = cljs.core.first.call(null,seq__7507_7550__$1);
cljs.compiler.emit.call(null,param_7556);

if(cljs.core._EQ_.call(null,param_7556,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7557 = cljs.core.next.call(null,seq__7507_7550__$1);
var G__7558 = null;
var G__7559 = (0);
var G__7560 = (0);
seq__7507_7540 = G__7557;
chunk__7508_7541 = G__7558;
count__7509_7542 = G__7559;
i__7510_7543 = G__7560;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__7511_7561 = cljs.core.seq.call(null,params);
var chunk__7512_7562 = null;
var count__7513_7563 = (0);
var i__7514_7564 = (0);
while(true){
if((i__7514_7564 < count__7513_7563)){
var param_7565 = cljs.core._nth.call(null,chunk__7512_7562,i__7514_7564);
cljs.compiler.emit.call(null,param_7565);

if(cljs.core._EQ_.call(null,param_7565,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7566 = seq__7511_7561;
var G__7567 = chunk__7512_7562;
var G__7568 = count__7513_7563;
var G__7569 = (i__7514_7564 + (1));
seq__7511_7561 = G__7566;
chunk__7512_7562 = G__7567;
count__7513_7563 = G__7568;
i__7514_7564 = G__7569;
continue;
} else {
var temp__5735__auto___7570 = cljs.core.seq.call(null,seq__7511_7561);
if(temp__5735__auto___7570){
var seq__7511_7571__$1 = temp__5735__auto___7570;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7511_7571__$1)){
var c__4556__auto___7572 = cljs.core.chunk_first.call(null,seq__7511_7571__$1);
var G__7573 = cljs.core.chunk_rest.call(null,seq__7511_7571__$1);
var G__7574 = c__4556__auto___7572;
var G__7575 = cljs.core.count.call(null,c__4556__auto___7572);
var G__7576 = (0);
seq__7511_7561 = G__7573;
chunk__7512_7562 = G__7574;
count__7513_7563 = G__7575;
i__7514_7564 = G__7576;
continue;
} else {
var param_7577 = cljs.core.first.call(null,seq__7511_7571__$1);
cljs.compiler.emit.call(null,param_7577);

if(cljs.core._EQ_.call(null,param_7577,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7578 = cljs.core.next.call(null,seq__7511_7571__$1);
var G__7579 = null;
var G__7580 = (0);
var G__7581 = (0);
seq__7511_7561 = G__7578;
chunk__7512_7562 = G__7579;
count__7513_7563 = G__7580;
i__7514_7564 = G__7581;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__7582 = cljs.core.seq.call(null,params);
var chunk__7583 = null;
var count__7584 = (0);
var i__7585 = (0);
while(true){
if((i__7585 < count__7584)){
var param = cljs.core._nth.call(null,chunk__7583,i__7585);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7586 = seq__7582;
var G__7587 = chunk__7583;
var G__7588 = count__7584;
var G__7589 = (i__7585 + (1));
seq__7582 = G__7586;
chunk__7583 = G__7587;
count__7584 = G__7588;
i__7585 = G__7589;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__7582);
if(temp__5735__auto__){
var seq__7582__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7582__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__7582__$1);
var G__7590 = cljs.core.chunk_rest.call(null,seq__7582__$1);
var G__7591 = c__4556__auto__;
var G__7592 = cljs.core.count.call(null,c__4556__auto__);
var G__7593 = (0);
seq__7582 = G__7590;
chunk__7583 = G__7591;
count__7584 = G__7592;
i__7585 = G__7593;
continue;
} else {
var param = cljs.core.first.call(null,seq__7582__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7594 = cljs.core.next.call(null,seq__7582__$1);
var G__7595 = null;
var G__7596 = (0);
var G__7597 = (0);
seq__7582 = G__7594;
chunk__7583 = G__7595;
count__7584 = G__7596;
i__7585 = G__7597;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__7598){
var map__7599 = p__7598;
var map__7599__$1 = (((((!((map__7599 == null))))?(((((map__7599.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7599.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7599):map__7599);
var expr = cljs.core.get.call(null,map__7599__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.call(null,map__7599__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__7599__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7599__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7599__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__7599__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__7601){
var map__7602 = p__7601;
var map__7602__$1 = (((((!((map__7602 == null))))?(((((map__7602.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7602.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7602):map__7602);
var f = map__7602__$1;
var expr = cljs.core.get.call(null,map__7602__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.call(null,map__7602__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.call(null,map__7602__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.call(null,map__7602__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__7602__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7602__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7602__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__7602__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_7612__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_7613 = cljs.compiler.munge.call(null,name_7612__$1);
var delegate_name_7614 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7613),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_7614," = function (");

var seq__7604_7615 = cljs.core.seq.call(null,params);
var chunk__7605_7616 = null;
var count__7606_7617 = (0);
var i__7607_7618 = (0);
while(true){
if((i__7607_7618 < count__7606_7617)){
var param_7619 = cljs.core._nth.call(null,chunk__7605_7616,i__7607_7618);
cljs.compiler.emit.call(null,param_7619);

if(cljs.core._EQ_.call(null,param_7619,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7620 = seq__7604_7615;
var G__7621 = chunk__7605_7616;
var G__7622 = count__7606_7617;
var G__7623 = (i__7607_7618 + (1));
seq__7604_7615 = G__7620;
chunk__7605_7616 = G__7621;
count__7606_7617 = G__7622;
i__7607_7618 = G__7623;
continue;
} else {
var temp__5735__auto___7624 = cljs.core.seq.call(null,seq__7604_7615);
if(temp__5735__auto___7624){
var seq__7604_7625__$1 = temp__5735__auto___7624;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7604_7625__$1)){
var c__4556__auto___7626 = cljs.core.chunk_first.call(null,seq__7604_7625__$1);
var G__7627 = cljs.core.chunk_rest.call(null,seq__7604_7625__$1);
var G__7628 = c__4556__auto___7626;
var G__7629 = cljs.core.count.call(null,c__4556__auto___7626);
var G__7630 = (0);
seq__7604_7615 = G__7627;
chunk__7605_7616 = G__7628;
count__7606_7617 = G__7629;
i__7607_7618 = G__7630;
continue;
} else {
var param_7631 = cljs.core.first.call(null,seq__7604_7625__$1);
cljs.compiler.emit.call(null,param_7631);

if(cljs.core._EQ_.call(null,param_7631,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7632 = cljs.core.next.call(null,seq__7604_7625__$1);
var G__7633 = null;
var G__7634 = (0);
var G__7635 = (0);
seq__7604_7615 = G__7632;
chunk__7605_7616 = G__7633;
count__7606_7617 = G__7634;
i__7607_7618 = G__7635;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_7613," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_7636 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_7636,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_7614,".call(this,");

var seq__7608_7637 = cljs.core.seq.call(null,params);
var chunk__7609_7638 = null;
var count__7610_7639 = (0);
var i__7611_7640 = (0);
while(true){
if((i__7611_7640 < count__7610_7639)){
var param_7641 = cljs.core._nth.call(null,chunk__7609_7638,i__7611_7640);
cljs.compiler.emit.call(null,param_7641);

if(cljs.core._EQ_.call(null,param_7641,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7642 = seq__7608_7637;
var G__7643 = chunk__7609_7638;
var G__7644 = count__7610_7639;
var G__7645 = (i__7611_7640 + (1));
seq__7608_7637 = G__7642;
chunk__7609_7638 = G__7643;
count__7610_7639 = G__7644;
i__7611_7640 = G__7645;
continue;
} else {
var temp__5735__auto___7646 = cljs.core.seq.call(null,seq__7608_7637);
if(temp__5735__auto___7646){
var seq__7608_7647__$1 = temp__5735__auto___7646;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7608_7647__$1)){
var c__4556__auto___7648 = cljs.core.chunk_first.call(null,seq__7608_7647__$1);
var G__7649 = cljs.core.chunk_rest.call(null,seq__7608_7647__$1);
var G__7650 = c__4556__auto___7648;
var G__7651 = cljs.core.count.call(null,c__4556__auto___7648);
var G__7652 = (0);
seq__7608_7637 = G__7649;
chunk__7609_7638 = G__7650;
count__7610_7639 = G__7651;
i__7611_7640 = G__7652;
continue;
} else {
var param_7653 = cljs.core.first.call(null,seq__7608_7647__$1);
cljs.compiler.emit.call(null,param_7653);

if(cljs.core._EQ_.call(null,param_7653,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7654 = cljs.core.next.call(null,seq__7608_7647__$1);
var G__7655 = null;
var G__7656 = (0);
var G__7657 = (0);
seq__7608_7637 = G__7654;
chunk__7609_7638 = G__7655;
count__7610_7639 = G__7656;
i__7611_7640 = G__7657;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_7613,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_7613,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_7612__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_7613,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_7614,";");

cljs.compiler.emitln.call(null,"return ",mname_7613,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__7661){
var map__7662 = p__7661;
var map__7662__$1 = (((((!((map__7662 == null))))?(((((map__7662.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7662.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7662):map__7662);
var variadic = cljs.core.get.call(null,map__7662__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.call(null,map__7662__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__7662__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__7662__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__7662__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.call(null,map__7662__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.call(null,map__7662__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.call(null,map__7662__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,(function (p1__7658_SHARP_){
var and__4115__auto__ = p1__7658_SHARP_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__7658_SHARP_));
} else {
return and__4115__auto__;
}
}),recur_frames));
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,recur_params,(cljs.core.truth_((function (){var or__4126__auto__ = in_loop;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.seq.call(null,recur_params);
}
})())?cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets):null))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_7715__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_7716 = cljs.compiler.munge.call(null,name_7715__$1);
var maxparams_7717 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_7718 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7716),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_7719 = cljs.core.sort_by.call(null,(function (p1__7659_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__7659_SHARP_)));
}),cljs.core.seq.call(null,mmap_7718));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_7716," = null;");

var seq__7664_7720 = cljs.core.seq.call(null,ms_7719);
var chunk__7665_7721 = null;
var count__7666_7722 = (0);
var i__7667_7723 = (0);
while(true){
if((i__7667_7723 < count__7666_7722)){
var vec__7674_7724 = cljs.core._nth.call(null,chunk__7665_7721,i__7667_7723);
var n_7725 = cljs.core.nth.call(null,vec__7674_7724,(0),null);
var meth_7726 = cljs.core.nth.call(null,vec__7674_7724,(1),null);
cljs.compiler.emits.call(null,"var ",n_7725," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7726))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_7726);
} else {
cljs.compiler.emit_fn_method.call(null,meth_7726);
}

cljs.compiler.emitln.call(null,";");


var G__7727 = seq__7664_7720;
var G__7728 = chunk__7665_7721;
var G__7729 = count__7666_7722;
var G__7730 = (i__7667_7723 + (1));
seq__7664_7720 = G__7727;
chunk__7665_7721 = G__7728;
count__7666_7722 = G__7729;
i__7667_7723 = G__7730;
continue;
} else {
var temp__5735__auto___7731 = cljs.core.seq.call(null,seq__7664_7720);
if(temp__5735__auto___7731){
var seq__7664_7732__$1 = temp__5735__auto___7731;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7664_7732__$1)){
var c__4556__auto___7733 = cljs.core.chunk_first.call(null,seq__7664_7732__$1);
var G__7734 = cljs.core.chunk_rest.call(null,seq__7664_7732__$1);
var G__7735 = c__4556__auto___7733;
var G__7736 = cljs.core.count.call(null,c__4556__auto___7733);
var G__7737 = (0);
seq__7664_7720 = G__7734;
chunk__7665_7721 = G__7735;
count__7666_7722 = G__7736;
i__7667_7723 = G__7737;
continue;
} else {
var vec__7677_7738 = cljs.core.first.call(null,seq__7664_7732__$1);
var n_7739 = cljs.core.nth.call(null,vec__7677_7738,(0),null);
var meth_7740 = cljs.core.nth.call(null,vec__7677_7738,(1),null);
cljs.compiler.emits.call(null,"var ",n_7739," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7740))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_7740);
} else {
cljs.compiler.emit_fn_method.call(null,meth_7740);
}

cljs.compiler.emitln.call(null,";");


var G__7741 = cljs.core.next.call(null,seq__7664_7732__$1);
var G__7742 = null;
var G__7743 = (0);
var G__7744 = (0);
seq__7664_7720 = G__7741;
chunk__7665_7721 = G__7742;
count__7666_7722 = G__7743;
i__7667_7723 = G__7744;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_7716," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_7717),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_7717)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_7717));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__7680_7745 = cljs.core.seq.call(null,ms_7719);
var chunk__7681_7746 = null;
var count__7682_7747 = (0);
var i__7683_7748 = (0);
while(true){
if((i__7683_7748 < count__7682_7747)){
var vec__7690_7749 = cljs.core._nth.call(null,chunk__7681_7746,i__7683_7748);
var n_7750 = cljs.core.nth.call(null,vec__7690_7749,(0),null);
var meth_7751 = cljs.core.nth.call(null,vec__7690_7749,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7751))){
cljs.compiler.emitln.call(null,"default:");

var restarg_7752 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_7752," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_7753 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_7752," = new cljs.core.IndexedSeq(",a_7753,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_7750,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_7717)),(((cljs.core.count.call(null,maxparams_7717) > (1)))?", ":null),restarg_7752,");");
} else {
var pcnt_7754 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7751));
cljs.compiler.emitln.call(null,"case ",pcnt_7754,":");

cljs.compiler.emitln.call(null,"return ",n_7750,".call(this",(((pcnt_7754 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_7754,maxparams_7717)),null,(1),null)),(2),null))),");");
}


var G__7755 = seq__7680_7745;
var G__7756 = chunk__7681_7746;
var G__7757 = count__7682_7747;
var G__7758 = (i__7683_7748 + (1));
seq__7680_7745 = G__7755;
chunk__7681_7746 = G__7756;
count__7682_7747 = G__7757;
i__7683_7748 = G__7758;
continue;
} else {
var temp__5735__auto___7759 = cljs.core.seq.call(null,seq__7680_7745);
if(temp__5735__auto___7759){
var seq__7680_7760__$1 = temp__5735__auto___7759;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7680_7760__$1)){
var c__4556__auto___7761 = cljs.core.chunk_first.call(null,seq__7680_7760__$1);
var G__7762 = cljs.core.chunk_rest.call(null,seq__7680_7760__$1);
var G__7763 = c__4556__auto___7761;
var G__7764 = cljs.core.count.call(null,c__4556__auto___7761);
var G__7765 = (0);
seq__7680_7745 = G__7762;
chunk__7681_7746 = G__7763;
count__7682_7747 = G__7764;
i__7683_7748 = G__7765;
continue;
} else {
var vec__7693_7766 = cljs.core.first.call(null,seq__7680_7760__$1);
var n_7767 = cljs.core.nth.call(null,vec__7693_7766,(0),null);
var meth_7768 = cljs.core.nth.call(null,vec__7693_7766,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7768))){
cljs.compiler.emitln.call(null,"default:");

var restarg_7769 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_7769," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_7770 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_7769," = new cljs.core.IndexedSeq(",a_7770,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_7767,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_7717)),(((cljs.core.count.call(null,maxparams_7717) > (1)))?", ":null),restarg_7769,");");
} else {
var pcnt_7771 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7768));
cljs.compiler.emitln.call(null,"case ",pcnt_7771,":");

cljs.compiler.emitln.call(null,"return ",n_7767,".call(this",(((pcnt_7771 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_7771,maxparams_7717)),null,(1),null)),(2),null))),");");
}


var G__7772 = cljs.core.next.call(null,seq__7680_7760__$1);
var G__7773 = null;
var G__7774 = (0);
var G__7775 = (0);
seq__7680_7745 = G__7772;
chunk__7681_7746 = G__7773;
count__7682_7747 = G__7774;
i__7683_7748 = G__7775;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

var arg_count_js_7776 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,cljs.core.first.call(null,ms_7719)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + ",arg_count_js_7776,"));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_7716,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_7716,".cljs$lang$applyTo = ",cljs.core.some.call(null,(function (p1__7660_SHARP_){
var vec__7696 = p1__7660_SHARP_;
var n = cljs.core.nth.call(null,vec__7696,(0),null);
var m = cljs.core.nth.call(null,vec__7696,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_7719),".cljs$lang$applyTo;");
} else {
}

var seq__7699_7777 = cljs.core.seq.call(null,ms_7719);
var chunk__7700_7778 = null;
var count__7701_7779 = (0);
var i__7702_7780 = (0);
while(true){
if((i__7702_7780 < count__7701_7779)){
var vec__7709_7781 = cljs.core._nth.call(null,chunk__7700_7778,i__7702_7780);
var n_7782 = cljs.core.nth.call(null,vec__7709_7781,(0),null);
var meth_7783 = cljs.core.nth.call(null,vec__7709_7781,(1),null);
var c_7784 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7783));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7783))){
cljs.compiler.emitln.call(null,mname_7716,".cljs$core$IFn$_invoke$arity$variadic = ",n_7782,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_7716,".cljs$core$IFn$_invoke$arity$",c_7784," = ",n_7782,";");
}


var G__7785 = seq__7699_7777;
var G__7786 = chunk__7700_7778;
var G__7787 = count__7701_7779;
var G__7788 = (i__7702_7780 + (1));
seq__7699_7777 = G__7785;
chunk__7700_7778 = G__7786;
count__7701_7779 = G__7787;
i__7702_7780 = G__7788;
continue;
} else {
var temp__5735__auto___7789 = cljs.core.seq.call(null,seq__7699_7777);
if(temp__5735__auto___7789){
var seq__7699_7790__$1 = temp__5735__auto___7789;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7699_7790__$1)){
var c__4556__auto___7791 = cljs.core.chunk_first.call(null,seq__7699_7790__$1);
var G__7792 = cljs.core.chunk_rest.call(null,seq__7699_7790__$1);
var G__7793 = c__4556__auto___7791;
var G__7794 = cljs.core.count.call(null,c__4556__auto___7791);
var G__7795 = (0);
seq__7699_7777 = G__7792;
chunk__7700_7778 = G__7793;
count__7701_7779 = G__7794;
i__7702_7780 = G__7795;
continue;
} else {
var vec__7712_7796 = cljs.core.first.call(null,seq__7699_7790__$1);
var n_7797 = cljs.core.nth.call(null,vec__7712_7796,(0),null);
var meth_7798 = cljs.core.nth.call(null,vec__7712_7796,(1),null);
var c_7799 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7798));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7798))){
cljs.compiler.emitln.call(null,mname_7716,".cljs$core$IFn$_invoke$arity$variadic = ",n_7797,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_7716,".cljs$core$IFn$_invoke$arity$",c_7799," = ",n_7797,";");
}


var G__7800 = cljs.core.next.call(null,seq__7699_7790__$1);
var G__7801 = null;
var G__7802 = (0);
var G__7803 = (0);
seq__7699_7777 = G__7800;
chunk__7700_7778 = G__7801;
count__7701_7779 = G__7802;
i__7702_7780 = G__7803;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_7716,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__7804){
var map__7805 = p__7804;
var map__7805__$1 = (((((!((map__7805 == null))))?(((((map__7805.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7805.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7805):map__7805);
var statements = cljs.core.get.call(null,map__7805__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__7805__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__7805__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__7807_7811 = cljs.core.seq.call(null,statements);
var chunk__7808_7812 = null;
var count__7809_7813 = (0);
var i__7810_7814 = (0);
while(true){
if((i__7810_7814 < count__7809_7813)){
var s_7815 = cljs.core._nth.call(null,chunk__7808_7812,i__7810_7814);
cljs.compiler.emitln.call(null,s_7815);


var G__7816 = seq__7807_7811;
var G__7817 = chunk__7808_7812;
var G__7818 = count__7809_7813;
var G__7819 = (i__7810_7814 + (1));
seq__7807_7811 = G__7816;
chunk__7808_7812 = G__7817;
count__7809_7813 = G__7818;
i__7810_7814 = G__7819;
continue;
} else {
var temp__5735__auto___7820 = cljs.core.seq.call(null,seq__7807_7811);
if(temp__5735__auto___7820){
var seq__7807_7821__$1 = temp__5735__auto___7820;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7807_7821__$1)){
var c__4556__auto___7822 = cljs.core.chunk_first.call(null,seq__7807_7821__$1);
var G__7823 = cljs.core.chunk_rest.call(null,seq__7807_7821__$1);
var G__7824 = c__4556__auto___7822;
var G__7825 = cljs.core.count.call(null,c__4556__auto___7822);
var G__7826 = (0);
seq__7807_7811 = G__7823;
chunk__7808_7812 = G__7824;
count__7809_7813 = G__7825;
i__7810_7814 = G__7826;
continue;
} else {
var s_7827 = cljs.core.first.call(null,seq__7807_7821__$1);
cljs.compiler.emitln.call(null,s_7827);


var G__7828 = cljs.core.next.call(null,seq__7807_7821__$1);
var G__7829 = null;
var G__7830 = (0);
var G__7831 = (0);
seq__7807_7811 = G__7828;
chunk__7808_7812 = G__7829;
count__7809_7813 = G__7830;
i__7810_7814 = G__7831;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__7832){
var map__7833 = p__7832;
var map__7833__$1 = (((((!((map__7833 == null))))?(((((map__7833.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7833.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7833):map__7833);
var try$ = cljs.core.get.call(null,map__7833__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.call(null,map__7833__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.call(null,map__7833__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__7833__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__7833__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote.call(null,finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__7835,is_loop){
var map__7836 = p__7835;
var map__7836__$1 = (((((!((map__7836 == null))))?(((((map__7836.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7836.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7836):map__7836);
var expr = cljs.core.get.call(null,map__7836__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__7836__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__7836__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__7838_7852 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__7839_7853 = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,(function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__7839_7853);

try{var seq__7840_7854 = cljs.core.seq.call(null,bindings);
var chunk__7841_7855 = null;
var count__7842_7856 = (0);
var i__7843_7857 = (0);
while(true){
if((i__7843_7857 < count__7842_7856)){
var map__7848_7858 = cljs.core._nth.call(null,chunk__7841_7855,i__7843_7857);
var map__7848_7859__$1 = (((((!((map__7848_7858 == null))))?(((((map__7848_7858.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7848_7858.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7848_7858):map__7848_7858);
var binding_7860 = map__7848_7859__$1;
var init_7861 = cljs.core.get.call(null,map__7848_7859__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_7860);

cljs.compiler.emitln.call(null," = ",init_7861,";");


var G__7862 = seq__7840_7854;
var G__7863 = chunk__7841_7855;
var G__7864 = count__7842_7856;
var G__7865 = (i__7843_7857 + (1));
seq__7840_7854 = G__7862;
chunk__7841_7855 = G__7863;
count__7842_7856 = G__7864;
i__7843_7857 = G__7865;
continue;
} else {
var temp__5735__auto___7866 = cljs.core.seq.call(null,seq__7840_7854);
if(temp__5735__auto___7866){
var seq__7840_7867__$1 = temp__5735__auto___7866;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7840_7867__$1)){
var c__4556__auto___7868 = cljs.core.chunk_first.call(null,seq__7840_7867__$1);
var G__7869 = cljs.core.chunk_rest.call(null,seq__7840_7867__$1);
var G__7870 = c__4556__auto___7868;
var G__7871 = cljs.core.count.call(null,c__4556__auto___7868);
var G__7872 = (0);
seq__7840_7854 = G__7869;
chunk__7841_7855 = G__7870;
count__7842_7856 = G__7871;
i__7843_7857 = G__7872;
continue;
} else {
var map__7850_7873 = cljs.core.first.call(null,seq__7840_7867__$1);
var map__7850_7874__$1 = (((((!((map__7850_7873 == null))))?(((((map__7850_7873.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7850_7873.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7850_7873):map__7850_7873);
var binding_7875 = map__7850_7874__$1;
var init_7876 = cljs.core.get.call(null,map__7850_7874__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_7875);

cljs.compiler.emitln.call(null," = ",init_7876,";");


var G__7877 = cljs.core.next.call(null,seq__7840_7867__$1);
var G__7878 = null;
var G__7879 = (0);
var G__7880 = (0);
seq__7840_7854 = G__7877;
chunk__7841_7855 = G__7878;
count__7842_7856 = G__7879;
i__7843_7857 = G__7880;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__7838_7852);
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__7881){
var map__7882 = p__7881;
var map__7882__$1 = (((((!((map__7882 == null))))?(((((map__7882.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7882.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7882):map__7882);
var frame = cljs.core.get.call(null,map__7882__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__7882__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__7882__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4613__auto___7884 = cljs.core.count.call(null,exprs);
var i_7885 = (0);
while(true){
if((i_7885 < n__4613__auto___7884)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_7885)," = ",exprs.call(null,i_7885),";");

var G__7886 = (i_7885 + (1));
i_7885 = G__7886;
continue;
} else {
}
break;
}

var n__4613__auto___7887 = cljs.core.count.call(null,exprs);
var i_7888 = (0);
while(true){
if((i_7888 < n__4613__auto___7887)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_7888))," = ",temps.call(null,i_7888),";");

var G__7889 = (i_7888 + (1));
i_7888 = G__7889;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__7890){
var map__7891 = p__7890;
var map__7891__$1 = (((((!((map__7891 == null))))?(((((map__7891.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7891.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7891):map__7891);
var expr = cljs.core.get.call(null,map__7891__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__7891__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__7891__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__7893_7905 = cljs.core.seq.call(null,bindings);
var chunk__7894_7906 = null;
var count__7895_7907 = (0);
var i__7896_7908 = (0);
while(true){
if((i__7896_7908 < count__7895_7907)){
var map__7901_7909 = cljs.core._nth.call(null,chunk__7894_7906,i__7896_7908);
var map__7901_7910__$1 = (((((!((map__7901_7909 == null))))?(((((map__7901_7909.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7901_7909.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7901_7909):map__7901_7909);
var binding_7911 = map__7901_7910__$1;
var init_7912 = cljs.core.get.call(null,map__7901_7910__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_7911)," = ",init_7912,";");


var G__7913 = seq__7893_7905;
var G__7914 = chunk__7894_7906;
var G__7915 = count__7895_7907;
var G__7916 = (i__7896_7908 + (1));
seq__7893_7905 = G__7913;
chunk__7894_7906 = G__7914;
count__7895_7907 = G__7915;
i__7896_7908 = G__7916;
continue;
} else {
var temp__5735__auto___7917 = cljs.core.seq.call(null,seq__7893_7905);
if(temp__5735__auto___7917){
var seq__7893_7918__$1 = temp__5735__auto___7917;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7893_7918__$1)){
var c__4556__auto___7919 = cljs.core.chunk_first.call(null,seq__7893_7918__$1);
var G__7920 = cljs.core.chunk_rest.call(null,seq__7893_7918__$1);
var G__7921 = c__4556__auto___7919;
var G__7922 = cljs.core.count.call(null,c__4556__auto___7919);
var G__7923 = (0);
seq__7893_7905 = G__7920;
chunk__7894_7906 = G__7921;
count__7895_7907 = G__7922;
i__7896_7908 = G__7923;
continue;
} else {
var map__7903_7924 = cljs.core.first.call(null,seq__7893_7918__$1);
var map__7903_7925__$1 = (((((!((map__7903_7924 == null))))?(((((map__7903_7924.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7903_7924.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7903_7924):map__7903_7924);
var binding_7926 = map__7903_7925__$1;
var init_7927 = cljs.core.get.call(null,map__7903_7925__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_7926)," = ",init_7927,";");


var G__7928 = cljs.core.next.call(null,seq__7893_7918__$1);
var G__7929 = null;
var G__7930 = (0);
var G__7931 = (0);
seq__7893_7905 = G__7928;
chunk__7894_7906 = G__7929;
count__7895_7907 = G__7930;
i__7896_7908 = G__7931;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__7934){
var map__7935 = p__7934;
var map__7935__$1 = (((((!((map__7935 == null))))?(((((map__7935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7935.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7935):map__7935);
var expr = map__7935__$1;
var f = cljs.core.get.call(null,map__7935__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.call(null,map__7935__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7935__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4115__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4115__auto__ = protocol;
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = tag;
if(cljs.core.truth_(and__4115__auto____$1)){
var or__4126__auto__ = (function (){var and__4115__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto____$2)){
var and__4115__auto____$3 = protocol;
if(cljs.core.truth_(and__4115__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4115__auto____$3;
}
} else {
return and__4115__auto____$2;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto____$2 = (function (){var or__4126__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4115__auto____$2)){
var or__4126__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
if((!(cljs.core.set_QMARK_.call(null,tag)))){
if(cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null).call(null,tag))){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,cljs.core.vary_meta.call(null,tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4115__auto____$2;
}
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null).call(null,first_arg_tag))));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag.call(null,env,f);
var js_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4126__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote.call(null,f);
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__7937 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (arity > mfa);
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7932_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__7932_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7933_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__7933_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__7937,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__7937,(1),null);
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"(!(",cljs.core.first.call(null,args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.call(null,"((",cljs.core.first.call(null,args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_7940 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_7940,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_7941 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_7941,args)),(((mfa_7941 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_7941,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1));
} else {
return and__4115__auto__;
}
})())){
var fprop_7942 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.call(null,"(",f__$1,fprop_7942," ? ",f__$1,fprop_7942,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_7942," ? ",f__$1,fprop_7942,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__7943){
var map__7944 = p__7943;
var map__7944__$1 = (((((!((map__7944 == null))))?(((((map__7944.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7944.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7944):map__7944);
var ctor = cljs.core.get.call(null,map__7944__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.call(null,map__7944__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7944__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__7946){
var map__7947 = p__7946;
var map__7947__$1 = (((((!((map__7947 == null))))?(((((map__7947.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7947.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7947):map__7947);
var target = cljs.core.get.call(null,map__7947__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__7947__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__7947__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(",target," = ",val,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib)," = goog.global",cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.call(null,cljs.core.name.call(null,(function (){var or__4126__auto__ = cljs.core.get.call(null,global_exports,cljs.core.symbol.call(null,lib));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,global_exports,cljs.core.name.call(null,lib));
}
})()),/\./))),";");
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__7949 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__7949__$1 = (((((!((map__7949 == null))))?(((((map__7949.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7949.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7949):map__7949);
var options = cljs.core.get.call(null,map__7949__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__7949__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__7950 = options;
var map__7950__$1 = (((((!((map__7950 == null))))?(((((map__7950.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7950.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7950):map__7950);
var target = cljs.core.get.call(null,map__7950__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.call(null,map__7950__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.call(null,map__7950__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__7951 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__7956 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__7956__$1 = (((((!((map__7956 == null))))?(((((map__7956.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7956.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7956):map__7956);
var node_libs = cljs.core.get.call(null,map__7956__$1,true);
var libs_to_load = cljs.core.get.call(null,map__7956__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__7951,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__7951,(1),null);
var global_exports_libs = cljs.core.filter.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__7958_7978 = cljs.core.seq.call(null,libs_to_load);
var chunk__7959_7979 = null;
var count__7960_7980 = (0);
var i__7961_7981 = (0);
while(true){
if((i__7961_7981 < count__7960_7980)){
var lib_7982 = cljs.core._nth.call(null,chunk__7959_7979,i__7961_7981);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_7982)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7982),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7982),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7982),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7982),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_7982,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7982),"');");
}

}
}
}


var G__7983 = seq__7958_7978;
var G__7984 = chunk__7959_7979;
var G__7985 = count__7960_7980;
var G__7986 = (i__7961_7981 + (1));
seq__7958_7978 = G__7983;
chunk__7959_7979 = G__7984;
count__7960_7980 = G__7985;
i__7961_7981 = G__7986;
continue;
} else {
var temp__5735__auto___7987 = cljs.core.seq.call(null,seq__7958_7978);
if(temp__5735__auto___7987){
var seq__7958_7988__$1 = temp__5735__auto___7987;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7958_7988__$1)){
var c__4556__auto___7989 = cljs.core.chunk_first.call(null,seq__7958_7988__$1);
var G__7990 = cljs.core.chunk_rest.call(null,seq__7958_7988__$1);
var G__7991 = c__4556__auto___7989;
var G__7992 = cljs.core.count.call(null,c__4556__auto___7989);
var G__7993 = (0);
seq__7958_7978 = G__7990;
chunk__7959_7979 = G__7991;
count__7960_7980 = G__7992;
i__7961_7981 = G__7993;
continue;
} else {
var lib_7994 = cljs.core.first.call(null,seq__7958_7988__$1);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_7994)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7994),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7994),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7994),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7994),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_7994,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7994),"');");
}

}
}
}


var G__7995 = cljs.core.next.call(null,seq__7958_7988__$1);
var G__7996 = null;
var G__7997 = (0);
var G__7998 = (0);
seq__7958_7978 = G__7995;
chunk__7959_7979 = G__7996;
count__7960_7980 = G__7997;
i__7961_7981 = G__7998;
continue;
}
} else {
}
}
break;
}

var seq__7962_7999 = cljs.core.seq.call(null,node_libs);
var chunk__7963_8000 = null;
var count__7964_8001 = (0);
var i__7965_8002 = (0);
while(true){
if((i__7965_8002 < count__7964_8001)){
var lib_8003 = cljs.core._nth.call(null,chunk__7963_8000,i__7965_8002);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_8003)," = require('",lib_8003,"');");


var G__8004 = seq__7962_7999;
var G__8005 = chunk__7963_8000;
var G__8006 = count__7964_8001;
var G__8007 = (i__7965_8002 + (1));
seq__7962_7999 = G__8004;
chunk__7963_8000 = G__8005;
count__7964_8001 = G__8006;
i__7965_8002 = G__8007;
continue;
} else {
var temp__5735__auto___8008 = cljs.core.seq.call(null,seq__7962_7999);
if(temp__5735__auto___8008){
var seq__7962_8009__$1 = temp__5735__auto___8008;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7962_8009__$1)){
var c__4556__auto___8010 = cljs.core.chunk_first.call(null,seq__7962_8009__$1);
var G__8011 = cljs.core.chunk_rest.call(null,seq__7962_8009__$1);
var G__8012 = c__4556__auto___8010;
var G__8013 = cljs.core.count.call(null,c__4556__auto___8010);
var G__8014 = (0);
seq__7962_7999 = G__8011;
chunk__7963_8000 = G__8012;
count__7964_8001 = G__8013;
i__7965_8002 = G__8014;
continue;
} else {
var lib_8015 = cljs.core.first.call(null,seq__7962_8009__$1);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_8015)," = require('",lib_8015,"');");


var G__8016 = cljs.core.next.call(null,seq__7962_8009__$1);
var G__8017 = null;
var G__8018 = (0);
var G__8019 = (0);
seq__7962_7999 = G__8016;
chunk__7963_8000 = G__8017;
count__7964_8001 = G__8018;
i__7965_8002 = G__8019;
continue;
}
} else {
}
}
break;
}

var seq__7966_8020 = cljs.core.seq.call(null,global_exports_libs);
var chunk__7967_8021 = null;
var count__7968_8022 = (0);
var i__7969_8023 = (0);
while(true){
if((i__7969_8023 < count__7968_8022)){
var lib_8024 = cljs.core._nth.call(null,chunk__7967_8021,i__7969_8023);
var map__7974_8025 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_8024));
var map__7974_8026__$1 = (((((!((map__7974_8025 == null))))?(((((map__7974_8025.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7974_8025.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7974_8025):map__7974_8025);
var global_exports_8027 = cljs.core.get.call(null,map__7974_8026__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_8027,lib_8024);


var G__8028 = seq__7966_8020;
var G__8029 = chunk__7967_8021;
var G__8030 = count__7968_8022;
var G__8031 = (i__7969_8023 + (1));
seq__7966_8020 = G__8028;
chunk__7967_8021 = G__8029;
count__7968_8022 = G__8030;
i__7969_8023 = G__8031;
continue;
} else {
var temp__5735__auto___8032 = cljs.core.seq.call(null,seq__7966_8020);
if(temp__5735__auto___8032){
var seq__7966_8033__$1 = temp__5735__auto___8032;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7966_8033__$1)){
var c__4556__auto___8034 = cljs.core.chunk_first.call(null,seq__7966_8033__$1);
var G__8035 = cljs.core.chunk_rest.call(null,seq__7966_8033__$1);
var G__8036 = c__4556__auto___8034;
var G__8037 = cljs.core.count.call(null,c__4556__auto___8034);
var G__8038 = (0);
seq__7966_8020 = G__8035;
chunk__7967_8021 = G__8036;
count__7968_8022 = G__8037;
i__7969_8023 = G__8038;
continue;
} else {
var lib_8039 = cljs.core.first.call(null,seq__7966_8033__$1);
var map__7976_8040 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_8039));
var map__7976_8041__$1 = (((((!((map__7976_8040 == null))))?(((((map__7976_8040.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7976_8040.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7976_8040):map__7976_8040);
var global_exports_8042 = cljs.core.get.call(null,map__7976_8041__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_8042,lib_8039);


var G__8043 = cljs.core.next.call(null,seq__7966_8033__$1);
var G__8044 = null;
var G__8045 = (0);
var G__8046 = (0);
seq__7966_8020 = G__8043;
chunk__7967_8021 = G__8044;
count__7968_8022 = G__8045;
i__7969_8023 = G__8046;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__8047){
var map__8048 = p__8047;
var map__8048__$1 = (((((!((map__8048 == null))))?(((((map__8048.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8048.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8048):map__8048);
var name = cljs.core.get.call(null,map__8048__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__8048__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__8048__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__8048__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__8048__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__8048__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__8048__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"'nil';");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__8050){
var map__8051 = p__8050;
var map__8051__$1 = (((((!((map__8051 == null))))?(((((map__8051.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8051.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8051):map__8051);
var name = cljs.core.get.call(null,map__8051__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__8051__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__8051__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__8051__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__8051__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__8051__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__8051__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__8053){
var map__8054 = p__8053;
var map__8054__$1 = (((((!((map__8054 == null))))?(((((map__8054.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8054.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8054):map__8054);
var t = cljs.core.get.call(null,map__8054__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__8054__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__8054__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__8054__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__8054__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__8056_8080 = cljs.core.seq.call(null,protocols);
var chunk__8057_8081 = null;
var count__8058_8082 = (0);
var i__8059_8083 = (0);
while(true){
if((i__8059_8083 < count__8058_8082)){
var protocol_8084 = cljs.core._nth.call(null,chunk__8057_8081,i__8059_8083);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_8084)),"}");


var G__8085 = seq__8056_8080;
var G__8086 = chunk__8057_8081;
var G__8087 = count__8058_8082;
var G__8088 = (i__8059_8083 + (1));
seq__8056_8080 = G__8085;
chunk__8057_8081 = G__8086;
count__8058_8082 = G__8087;
i__8059_8083 = G__8088;
continue;
} else {
var temp__5735__auto___8089 = cljs.core.seq.call(null,seq__8056_8080);
if(temp__5735__auto___8089){
var seq__8056_8090__$1 = temp__5735__auto___8089;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8056_8090__$1)){
var c__4556__auto___8091 = cljs.core.chunk_first.call(null,seq__8056_8090__$1);
var G__8092 = cljs.core.chunk_rest.call(null,seq__8056_8090__$1);
var G__8093 = c__4556__auto___8091;
var G__8094 = cljs.core.count.call(null,c__4556__auto___8091);
var G__8095 = (0);
seq__8056_8080 = G__8092;
chunk__8057_8081 = G__8093;
count__8058_8082 = G__8094;
i__8059_8083 = G__8095;
continue;
} else {
var protocol_8096 = cljs.core.first.call(null,seq__8056_8090__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_8096)),"}");


var G__8097 = cljs.core.next.call(null,seq__8056_8090__$1);
var G__8098 = null;
var G__8099 = (0);
var G__8100 = (0);
seq__8056_8080 = G__8097;
chunk__8057_8081 = G__8098;
count__8058_8082 = G__8099;
i__8059_8083 = G__8100;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__8060_8101 = cljs.core.seq.call(null,fields__$1);
var chunk__8061_8102 = null;
var count__8062_8103 = (0);
var i__8063_8104 = (0);
while(true){
if((i__8063_8104 < count__8062_8103)){
var fld_8105 = cljs.core._nth.call(null,chunk__8061_8102,i__8063_8104);
cljs.compiler.emitln.call(null,"this.",fld_8105," = ",fld_8105,";");


var G__8106 = seq__8060_8101;
var G__8107 = chunk__8061_8102;
var G__8108 = count__8062_8103;
var G__8109 = (i__8063_8104 + (1));
seq__8060_8101 = G__8106;
chunk__8061_8102 = G__8107;
count__8062_8103 = G__8108;
i__8063_8104 = G__8109;
continue;
} else {
var temp__5735__auto___8110 = cljs.core.seq.call(null,seq__8060_8101);
if(temp__5735__auto___8110){
var seq__8060_8111__$1 = temp__5735__auto___8110;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8060_8111__$1)){
var c__4556__auto___8112 = cljs.core.chunk_first.call(null,seq__8060_8111__$1);
var G__8113 = cljs.core.chunk_rest.call(null,seq__8060_8111__$1);
var G__8114 = c__4556__auto___8112;
var G__8115 = cljs.core.count.call(null,c__4556__auto___8112);
var G__8116 = (0);
seq__8060_8101 = G__8113;
chunk__8061_8102 = G__8114;
count__8062_8103 = G__8115;
i__8063_8104 = G__8116;
continue;
} else {
var fld_8117 = cljs.core.first.call(null,seq__8060_8111__$1);
cljs.compiler.emitln.call(null,"this.",fld_8117," = ",fld_8117,";");


var G__8118 = cljs.core.next.call(null,seq__8060_8111__$1);
var G__8119 = null;
var G__8120 = (0);
var G__8121 = (0);
seq__8060_8101 = G__8118;
chunk__8061_8102 = G__8119;
count__8062_8103 = G__8120;
i__8063_8104 = G__8121;
continue;
}
} else {
}
}
break;
}

var seq__8064_8122 = cljs.core.seq.call(null,pmasks);
var chunk__8065_8123 = null;
var count__8066_8124 = (0);
var i__8067_8125 = (0);
while(true){
if((i__8067_8125 < count__8066_8124)){
var vec__8074_8126 = cljs.core._nth.call(null,chunk__8065_8123,i__8067_8125);
var pno_8127 = cljs.core.nth.call(null,vec__8074_8126,(0),null);
var pmask_8128 = cljs.core.nth.call(null,vec__8074_8126,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_8127,"$ = ",pmask_8128,";");


var G__8129 = seq__8064_8122;
var G__8130 = chunk__8065_8123;
var G__8131 = count__8066_8124;
var G__8132 = (i__8067_8125 + (1));
seq__8064_8122 = G__8129;
chunk__8065_8123 = G__8130;
count__8066_8124 = G__8131;
i__8067_8125 = G__8132;
continue;
} else {
var temp__5735__auto___8133 = cljs.core.seq.call(null,seq__8064_8122);
if(temp__5735__auto___8133){
var seq__8064_8134__$1 = temp__5735__auto___8133;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8064_8134__$1)){
var c__4556__auto___8135 = cljs.core.chunk_first.call(null,seq__8064_8134__$1);
var G__8136 = cljs.core.chunk_rest.call(null,seq__8064_8134__$1);
var G__8137 = c__4556__auto___8135;
var G__8138 = cljs.core.count.call(null,c__4556__auto___8135);
var G__8139 = (0);
seq__8064_8122 = G__8136;
chunk__8065_8123 = G__8137;
count__8066_8124 = G__8138;
i__8067_8125 = G__8139;
continue;
} else {
var vec__8077_8140 = cljs.core.first.call(null,seq__8064_8134__$1);
var pno_8141 = cljs.core.nth.call(null,vec__8077_8140,(0),null);
var pmask_8142 = cljs.core.nth.call(null,vec__8077_8140,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_8141,"$ = ",pmask_8142,";");


var G__8143 = cljs.core.next.call(null,seq__8064_8134__$1);
var G__8144 = null;
var G__8145 = (0);
var G__8146 = (0);
seq__8064_8122 = G__8143;
chunk__8065_8123 = G__8144;
count__8066_8124 = G__8145;
i__8067_8125 = G__8146;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__8147){
var map__8148 = p__8147;
var map__8148__$1 = (((((!((map__8148 == null))))?(((((map__8148.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8148.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8148):map__8148);
var t = cljs.core.get.call(null,map__8148__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__8148__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__8148__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__8148__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__8148__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__8150_8174 = cljs.core.seq.call(null,protocols);
var chunk__8151_8175 = null;
var count__8152_8176 = (0);
var i__8153_8177 = (0);
while(true){
if((i__8153_8177 < count__8152_8176)){
var protocol_8178 = cljs.core._nth.call(null,chunk__8151_8175,i__8153_8177);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_8178)),"}");


var G__8179 = seq__8150_8174;
var G__8180 = chunk__8151_8175;
var G__8181 = count__8152_8176;
var G__8182 = (i__8153_8177 + (1));
seq__8150_8174 = G__8179;
chunk__8151_8175 = G__8180;
count__8152_8176 = G__8181;
i__8153_8177 = G__8182;
continue;
} else {
var temp__5735__auto___8183 = cljs.core.seq.call(null,seq__8150_8174);
if(temp__5735__auto___8183){
var seq__8150_8184__$1 = temp__5735__auto___8183;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8150_8184__$1)){
var c__4556__auto___8185 = cljs.core.chunk_first.call(null,seq__8150_8184__$1);
var G__8186 = cljs.core.chunk_rest.call(null,seq__8150_8184__$1);
var G__8187 = c__4556__auto___8185;
var G__8188 = cljs.core.count.call(null,c__4556__auto___8185);
var G__8189 = (0);
seq__8150_8174 = G__8186;
chunk__8151_8175 = G__8187;
count__8152_8176 = G__8188;
i__8153_8177 = G__8189;
continue;
} else {
var protocol_8190 = cljs.core.first.call(null,seq__8150_8184__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_8190)),"}");


var G__8191 = cljs.core.next.call(null,seq__8150_8184__$1);
var G__8192 = null;
var G__8193 = (0);
var G__8194 = (0);
seq__8150_8174 = G__8191;
chunk__8151_8175 = G__8192;
count__8152_8176 = G__8193;
i__8153_8177 = G__8194;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__8154_8195 = cljs.core.seq.call(null,fields__$1);
var chunk__8155_8196 = null;
var count__8156_8197 = (0);
var i__8157_8198 = (0);
while(true){
if((i__8157_8198 < count__8156_8197)){
var fld_8199 = cljs.core._nth.call(null,chunk__8155_8196,i__8157_8198);
cljs.compiler.emitln.call(null,"this.",fld_8199," = ",fld_8199,";");


var G__8200 = seq__8154_8195;
var G__8201 = chunk__8155_8196;
var G__8202 = count__8156_8197;
var G__8203 = (i__8157_8198 + (1));
seq__8154_8195 = G__8200;
chunk__8155_8196 = G__8201;
count__8156_8197 = G__8202;
i__8157_8198 = G__8203;
continue;
} else {
var temp__5735__auto___8204 = cljs.core.seq.call(null,seq__8154_8195);
if(temp__5735__auto___8204){
var seq__8154_8205__$1 = temp__5735__auto___8204;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8154_8205__$1)){
var c__4556__auto___8206 = cljs.core.chunk_first.call(null,seq__8154_8205__$1);
var G__8207 = cljs.core.chunk_rest.call(null,seq__8154_8205__$1);
var G__8208 = c__4556__auto___8206;
var G__8209 = cljs.core.count.call(null,c__4556__auto___8206);
var G__8210 = (0);
seq__8154_8195 = G__8207;
chunk__8155_8196 = G__8208;
count__8156_8197 = G__8209;
i__8157_8198 = G__8210;
continue;
} else {
var fld_8211 = cljs.core.first.call(null,seq__8154_8205__$1);
cljs.compiler.emitln.call(null,"this.",fld_8211," = ",fld_8211,";");


var G__8212 = cljs.core.next.call(null,seq__8154_8205__$1);
var G__8213 = null;
var G__8214 = (0);
var G__8215 = (0);
seq__8154_8195 = G__8212;
chunk__8155_8196 = G__8213;
count__8156_8197 = G__8214;
i__8157_8198 = G__8215;
continue;
}
} else {
}
}
break;
}

var seq__8158_8216 = cljs.core.seq.call(null,pmasks);
var chunk__8159_8217 = null;
var count__8160_8218 = (0);
var i__8161_8219 = (0);
while(true){
if((i__8161_8219 < count__8160_8218)){
var vec__8168_8220 = cljs.core._nth.call(null,chunk__8159_8217,i__8161_8219);
var pno_8221 = cljs.core.nth.call(null,vec__8168_8220,(0),null);
var pmask_8222 = cljs.core.nth.call(null,vec__8168_8220,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_8221,"$ = ",pmask_8222,";");


var G__8223 = seq__8158_8216;
var G__8224 = chunk__8159_8217;
var G__8225 = count__8160_8218;
var G__8226 = (i__8161_8219 + (1));
seq__8158_8216 = G__8223;
chunk__8159_8217 = G__8224;
count__8160_8218 = G__8225;
i__8161_8219 = G__8226;
continue;
} else {
var temp__5735__auto___8227 = cljs.core.seq.call(null,seq__8158_8216);
if(temp__5735__auto___8227){
var seq__8158_8228__$1 = temp__5735__auto___8227;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8158_8228__$1)){
var c__4556__auto___8229 = cljs.core.chunk_first.call(null,seq__8158_8228__$1);
var G__8230 = cljs.core.chunk_rest.call(null,seq__8158_8228__$1);
var G__8231 = c__4556__auto___8229;
var G__8232 = cljs.core.count.call(null,c__4556__auto___8229);
var G__8233 = (0);
seq__8158_8216 = G__8230;
chunk__8159_8217 = G__8231;
count__8160_8218 = G__8232;
i__8161_8219 = G__8233;
continue;
} else {
var vec__8171_8234 = cljs.core.first.call(null,seq__8158_8228__$1);
var pno_8235 = cljs.core.nth.call(null,vec__8171_8234,(0),null);
var pmask_8236 = cljs.core.nth.call(null,vec__8171_8234,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_8235,"$ = ",pmask_8236,";");


var G__8237 = cljs.core.next.call(null,seq__8158_8228__$1);
var G__8238 = null;
var G__8239 = (0);
var G__8240 = (0);
seq__8158_8216 = G__8237;
chunk__8159_8217 = G__8238;
count__8160_8218 = G__8239;
i__8161_8219 = G__8240;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__8241){
var map__8242 = p__8241;
var map__8242__$1 = (((((!((map__8242 == null))))?(((((map__8242.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8242.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8242):map__8242);
var target = cljs.core.get.call(null,map__8242__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__8242__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__8242__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__8242__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__8242__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__8244){
var map__8245 = p__8244;
var map__8245__$1 = (((((!((map__8245 == null))))?(((((map__8245.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8245.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8245):map__8245);
var op = cljs.core.get.call(null,map__8245__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__8245__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__8245__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__8245__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__8245__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4115__auto__ = code;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__4115__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__7039__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__7039__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__8251 = cljs.core.seq.call(null,table);
var chunk__8252 = null;
var count__8253 = (0);
var i__8254 = (0);
while(true){
if((i__8254 < count__8253)){
var vec__8261 = cljs.core._nth.call(null,chunk__8252,i__8254);
var sym = cljs.core.nth.call(null,vec__8261,(0),null);
var value = cljs.core.nth.call(null,vec__8261,(1),null);
var ns_8267 = cljs.core.namespace.call(null,sym);
var name_8268 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__8269 = seq__8251;
var G__8270 = chunk__8252;
var G__8271 = count__8253;
var G__8272 = (i__8254 + (1));
seq__8251 = G__8269;
chunk__8252 = G__8270;
count__8253 = G__8271;
i__8254 = G__8272;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__8251);
if(temp__5735__auto__){
var seq__8251__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8251__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__8251__$1);
var G__8273 = cljs.core.chunk_rest.call(null,seq__8251__$1);
var G__8274 = c__4556__auto__;
var G__8275 = cljs.core.count.call(null,c__4556__auto__);
var G__8276 = (0);
seq__8251 = G__8273;
chunk__8252 = G__8274;
count__8253 = G__8275;
i__8254 = G__8276;
continue;
} else {
var vec__8264 = cljs.core.first.call(null,seq__8251__$1);
var sym = cljs.core.nth.call(null,vec__8264,(0),null);
var value = cljs.core.nth.call(null,vec__8264,(1),null);
var ns_8277 = cljs.core.namespace.call(null,sym);
var name_8278 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__8279 = cljs.core.next.call(null,seq__8251__$1);
var G__8280 = null;
var G__8281 = (0);
var G__8282 = (0);
seq__8251 = G__8279;
chunk__8252 = G__8280;
count__8253 = G__8281;
i__8254 = G__8282;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__8284 = arguments.length;
switch (G__8284) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs.call(null):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_8289 = cljs.core.first.call(null,ks);
var vec__8285_8290 = cljs.core.conj.call(null,prefix,k_8289);
var top_8291 = cljs.core.nth.call(null,vec__8285_8290,(0),null);
var prefix_SINGLEQUOTE__8292 = vec__8285_8290;
if(((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_8289)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__8292) == null)))){
if((!(((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_8291)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_8291)))))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__8292)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_8291);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__8292)),";");
}
} else {
}

var m_8293 = cljs.core.get.call(null,externs,k_8289);
if(cljs.core.empty_QMARK_.call(null,m_8293)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__8292,m_8293,top_level,known_externs);
}

var G__8294 = cljs.core.next.call(null,ks);
ks = G__8294;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

