// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__81289 = arguments.length;
switch (G__81289) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5733__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5733__auto__)){
var block = temp__5733__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__11542__auto___81328 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_81310){
var state_val_81311 = (state_81310[(1)]);
if((state_val_81311 === (1))){
var state_81310__$1 = state_81310;
var statearr_81312_81329 = state_81310__$1;
(statearr_81312_81329[(2)] = null);

(statearr_81312_81329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81311 === (2))){
var _ = (function (){var statearr_81313 = state_81310;
(statearr_81313[(4)] = cljs.core.cons.call(null,(5),(state_81310[(4)])));

return statearr_81313;
})();
var inst_81296 = fluree.db.session.db.call(null,conn,ledger,null);
var state_81310__$1 = state_81310;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81310__$1,(7),inst_81296);
} else {
if((state_val_81311 === (3))){
var inst_81306 = (state_81310[(2)]);
var inst_81307 = cljs.core.async.put_BANG_.call(null,pc,inst_81306);
var inst_81308 = cljs.core.async.close_BANG_.call(null,pc);
var state_81310__$1 = (function (){var statearr_81315 = state_81310;
(statearr_81315[(7)] = inst_81307);

return statearr_81315;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81310__$1,inst_81308);
} else {
if((state_val_81311 === (4))){
var inst_81290 = (state_81310[(2)]);
var state_81310__$1 = state_81310;
var statearr_81316_81330 = state_81310__$1;
(statearr_81316_81330[(2)] = inst_81290);

(statearr_81316_81330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81311 === (5))){
var _ = (function (){var statearr_81317 = state_81310;
(statearr_81317[(4)] = cljs.core.rest.call(null,(state_81310[(4)])));

return statearr_81317;
})();
var state_81310__$1 = state_81310;
var ex81314 = (state_81310__$1[(2)]);
var statearr_81318_81331 = state_81310__$1;
(statearr_81318_81331[(5)] = ex81314);


var statearr_81319_81332 = state_81310__$1;
(statearr_81319_81332[(1)] = (4));

(statearr_81319_81332[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81311 === (6))){
var inst_81302 = (state_81310[(2)]);
var inst_81303 = fluree.db.util.async.throw_err.call(null,inst_81302);
var _ = (function (){var statearr_81320 = state_81310;
(statearr_81320[(4)] = cljs.core.rest.call(null,(state_81310[(4)])));

return statearr_81320;
})();
var state_81310__$1 = state_81310;
var statearr_81321_81333 = state_81310__$1;
(statearr_81321_81333[(2)] = inst_81303);

(statearr_81321_81333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81311 === (7))){
var inst_81298 = (state_81310[(2)]);
var inst_81299 = fluree.db.util.async.throw_err.call(null,inst_81298);
var inst_81300 = fluree.db.time_travel.as_of_block.call(null,inst_81299,block);
var state_81310__$1 = state_81310;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81310__$1,(6),inst_81300);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__11469__auto__ = null;
var fluree$db$api$ledger$state_machine__11469__auto____0 = (function (){
var statearr_81322 = [null,null,null,null,null,null,null,null];
(statearr_81322[(0)] = fluree$db$api$ledger$state_machine__11469__auto__);

(statearr_81322[(1)] = (1));

return statearr_81322;
});
var fluree$db$api$ledger$state_machine__11469__auto____1 = (function (state_81310){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_81310);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e81323){var ex__11472__auto__ = e81323;
var statearr_81324_81334 = state_81310;
(statearr_81324_81334[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_81310[(4)]))){
var statearr_81325_81335 = state_81310;
(statearr_81325_81335[(1)] = cljs.core.first.call(null,(state_81310[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81336 = state_81310;
state_81310 = G__81336;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__11469__auto__ = function(state_81310){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__11469__auto____1.call(this,state_81310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__11469__auto____0;
fluree$db$api$ledger$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__11469__auto____1;
return fluree$db$api$ledger$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_81326 = f__11543__auto__.call(null);
(statearr_81326[(6)] = c__11542__auto___81328);

return statearr_81326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_81377){
var state_val_81378 = (state_81377[(1)]);
if((state_val_81378 === (7))){
var inst_81346 = cljs.core._EQ_.call(null,(0),auth);
var state_81377__$1 = state_81377;
if(inst_81346){
var statearr_81379_81410 = state_81377__$1;
(statearr_81379_81410[(1)] = (9));

} else {
var statearr_81380_81411 = state_81377__$1;
(statearr_81380_81411[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (1))){
var state_81377__$1 = state_81377;
var statearr_81381_81412 = state_81377__$1;
(statearr_81381_81412[(2)] = null);

(statearr_81381_81412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (4))){
var inst_81337 = (state_81377[(2)]);
var state_81377__$1 = state_81377;
var statearr_81382_81413 = state_81377__$1;
(statearr_81382_81413[(2)] = inst_81337);

(statearr_81382_81413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (15))){
var inst_81354 = (state_81377[(7)]);
var inst_81353 = (state_81377[(2)]);
var inst_81354__$1 = fluree.db.util.async.throw_err.call(null,inst_81353);
var state_81377__$1 = (function (){var statearr_81383 = state_81377;
(statearr_81383[(7)] = inst_81354__$1);

return statearr_81383;
})();
if(cljs.core.truth_(inst_81354__$1)){
var statearr_81384_81414 = state_81377__$1;
(statearr_81384_81414[(1)] = (16));

} else {
var statearr_81385_81415 = state_81377__$1;
(statearr_81385_81415[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (13))){
var state_81377__$1 = state_81377;
var statearr_81386_81416 = state_81377__$1;
(statearr_81386_81416[(2)] = null);

(statearr_81386_81416[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (6))){
var state_81377__$1 = state_81377;
var statearr_81387_81417 = state_81377__$1;
(statearr_81387_81417[(2)] = db);

(statearr_81387_81417[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (17))){
var inst_81358 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_81359 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81360 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_81361 = cljs.core.PersistentHashMap.fromArrays(inst_81359,inst_81360);
var inst_81362 = cljs.core.ex_info.call(null,inst_81358,inst_81361);
var inst_81363 = (function(){throw inst_81362})();
var state_81377__$1 = state_81377;
var statearr_81388_81418 = state_81377__$1;
(statearr_81388_81418[(2)] = inst_81363);

(statearr_81388_81418[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (3))){
var inst_81375 = (state_81377[(2)]);
var state_81377__$1 = state_81377;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81377__$1,inst_81375);
} else {
if((state_val_81378 === (12))){
var inst_81351 = fluree.db.dbproto._subid.call(null,db,auth);
var state_81377__$1 = state_81377;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81377__$1,(15),inst_81351);
} else {
if((state_val_81378 === (2))){
var _ = (function (){var statearr_81389 = state_81377;
(statearr_81389[(4)] = cljs.core.cons.call(null,(5),(state_81377[(4)])));

return statearr_81389;
})();
var inst_81343 = cljs.core.not.call(null,auth);
var state_81377__$1 = state_81377;
if(inst_81343){
var statearr_81390_81419 = state_81377__$1;
(statearr_81390_81419[(1)] = (6));

} else {
var statearr_81391_81420 = state_81377__$1;
(statearr_81391_81420[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (11))){
var inst_81370 = (state_81377[(2)]);
var state_81377__$1 = state_81377;
var statearr_81393_81421 = state_81377__$1;
(statearr_81393_81421[(2)] = inst_81370);

(statearr_81393_81421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (9))){
var inst_81348 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_81377__$1 = state_81377;
var statearr_81394_81422 = state_81377__$1;
(statearr_81394_81422[(2)] = inst_81348);

(statearr_81394_81422[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (5))){
var _ = (function (){var statearr_81395 = state_81377;
(statearr_81395[(4)] = cljs.core.rest.call(null,(state_81377[(4)])));

return statearr_81395;
})();
var state_81377__$1 = state_81377;
var ex81392 = (state_81377__$1[(2)]);
var statearr_81396_81423 = state_81377__$1;
(statearr_81396_81423[(5)] = ex81392);


if((ex81392 instanceof Error)){
var statearr_81397_81424 = state_81377__$1;
(statearr_81397_81424[(1)] = (4));

(statearr_81397_81424[(5)] = null);

} else {
throw ex81392;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (14))){
var inst_81368 = (state_81377[(2)]);
var state_81377__$1 = state_81377;
var statearr_81398_81425 = state_81377__$1;
(statearr_81398_81425[(2)] = inst_81368);

(statearr_81398_81425[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (16))){
var inst_81354 = (state_81377[(7)]);
var inst_81356 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_81354);
var state_81377__$1 = state_81377;
var statearr_81399_81426 = state_81377__$1;
(statearr_81399_81426[(2)] = inst_81356);

(statearr_81399_81426[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (10))){
var state_81377__$1 = state_81377;
var statearr_81400_81427 = state_81377__$1;
(statearr_81400_81427[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (18))){
var inst_81365 = (state_81377[(2)]);
var state_81377__$1 = state_81377;
var statearr_81402_81428 = state_81377__$1;
(statearr_81402_81428[(2)] = inst_81365);

(statearr_81402_81428[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81378 === (8))){
var inst_81372 = (state_81377[(2)]);
var _ = (function (){var statearr_81403 = state_81377;
(statearr_81403[(4)] = cljs.core.rest.call(null,(state_81377[(4)])));

return statearr_81403;
})();
var state_81377__$1 = state_81377;
var statearr_81404_81429 = state_81377__$1;
(statearr_81404_81429[(2)] = inst_81372);

(statearr_81404_81429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11469__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11469__auto____0 = (function (){
var statearr_81405 = [null,null,null,null,null,null,null,null];
(statearr_81405[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11469__auto__);

(statearr_81405[(1)] = (1));

return statearr_81405;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11469__auto____1 = (function (state_81377){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_81377);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e81406){var ex__11472__auto__ = e81406;
var statearr_81407_81430 = state_81377;
(statearr_81407_81430[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_81377[(4)]))){
var statearr_81408_81431 = state_81377;
(statearr_81408_81431[(1)] = cljs.core.first.call(null,(state_81377[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81432 = state_81377;
state_81377 = G__81432;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11469__auto__ = function(state_81377){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11469__auto____1.call(this,state_81377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11469__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11469__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_81409 = f__11543__auto__.call(null);
(statearr_81409[(6)] = c__11542__auto__);

return statearr_81409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_81496){
var state_val_81497 = (state_81496[(1)]);
if((state_val_81497 === (7))){
var inst_81442 = cljs.core._EQ_.call(null,(0),auth);
var state_81496__$1 = state_81496;
if(inst_81442){
var statearr_81498_81547 = state_81496__$1;
(statearr_81498_81547[(1)] = (9));

} else {
var statearr_81499_81548 = state_81496__$1;
(statearr_81499_81548[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (20))){
var inst_81466 = (state_81496[(7)]);
var state_81496__$1 = state_81496;
if(cljs.core.truth_(inst_81466)){
var statearr_81500_81549 = state_81496__$1;
(statearr_81500_81549[(1)] = (22));

} else {
var statearr_81501_81550 = state_81496__$1;
(statearr_81501_81550[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (27))){
var state_81496__$1 = state_81496;
var statearr_81502_81551 = state_81496__$1;
(statearr_81502_81551[(2)] = null);

(statearr_81502_81551[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (1))){
var state_81496__$1 = state_81496;
var statearr_81503_81552 = state_81496__$1;
(statearr_81503_81552[(2)] = null);

(statearr_81503_81552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (24))){
var inst_81480 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
var statearr_81504_81553 = state_81496__$1;
(statearr_81504_81553[(2)] = inst_81480);

(statearr_81504_81553[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (4))){
var inst_81433 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
var statearr_81505_81554 = state_81496__$1;
(statearr_81505_81554[(2)] = inst_81433);

(statearr_81505_81554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (15))){
var inst_81449 = (state_81496[(8)]);
var inst_81448 = (state_81496[(2)]);
var inst_81449__$1 = fluree.db.util.async.throw_err.call(null,inst_81448);
var state_81496__$1 = (function (){var statearr_81506 = state_81496;
(statearr_81506[(8)] = inst_81449__$1);

return statearr_81506;
})();
if(cljs.core.truth_(inst_81449__$1)){
var statearr_81507_81555 = state_81496__$1;
(statearr_81507_81555[(1)] = (16));

} else {
var statearr_81508_81556 = state_81496__$1;
(statearr_81508_81556[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (21))){
var inst_81482 = (state_81496[(9)]);
var inst_81482__$1 = (state_81496[(2)]);
var state_81496__$1 = (function (){var statearr_81509 = state_81496;
(statearr_81509[(9)] = inst_81482__$1);

return statearr_81509;
})();
if(cljs.core.truth_(inst_81482__$1)){
var statearr_81510_81557 = state_81496__$1;
(statearr_81510_81557[(1)] = (29));

} else {
var statearr_81511_81558 = state_81496__$1;
(statearr_81511_81558[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (31))){
var inst_81466 = (state_81496[(7)]);
var inst_81482 = (state_81496[(9)]);
var inst_81490 = (state_81496[(2)]);
var inst_81491 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_81466,new cljs.core.Keyword(null,"roles","roles",143379530),inst_81482,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_81490);
var _ = (function (){var statearr_81512 = state_81496;
(statearr_81512[(4)] = cljs.core.rest.call(null,(state_81496[(4)])));

return statearr_81512;
})();
var state_81496__$1 = state_81496;
var statearr_81513_81559 = state_81496__$1;
(statearr_81513_81559[(2)] = inst_81491);

(statearr_81513_81559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (32))){
var inst_81486 = (state_81496[(2)]);
var inst_81487 = fluree.db.util.async.throw_err.call(null,inst_81486);
var state_81496__$1 = state_81496;
var statearr_81514_81560 = state_81496__$1;
(statearr_81514_81560[(2)] = inst_81487);

(statearr_81514_81560[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (13))){
var state_81496__$1 = state_81496;
var statearr_81515_81561 = state_81496__$1;
(statearr_81515_81561[(2)] = null);

(statearr_81515_81561[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (22))){
var inst_81466 = (state_81496[(7)]);
var inst_81470 = fluree.db.auth.roles.call(null,db,inst_81466);
var state_81496__$1 = state_81496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81496__$1,(25),inst_81470);
} else {
if((state_val_81497 === (29))){
var inst_81482 = (state_81496[(9)]);
var inst_81484 = fluree.db.permissions.permission_map.call(null,db,inst_81482,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_81496__$1 = state_81496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81496__$1,(32),inst_81484);
} else {
if((state_val_81497 === (6))){
var state_81496__$1 = state_81496;
var statearr_81516_81562 = state_81496__$1;
(statearr_81516_81562[(2)] = null);

(statearr_81516_81562[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (28))){
var inst_81478 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
var statearr_81517_81563 = state_81496__$1;
(statearr_81517_81563[(2)] = inst_81478);

(statearr_81517_81563[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (25))){
var inst_81472 = (state_81496[(2)]);
var inst_81473 = fluree.db.util.async.throw_err.call(null,inst_81472);
var state_81496__$1 = state_81496;
var statearr_81518_81564 = state_81496__$1;
(statearr_81518_81564[(2)] = inst_81473);

(statearr_81518_81564[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (17))){
var inst_81452 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_81453 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81454 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_81455 = cljs.core.PersistentHashMap.fromArrays(inst_81453,inst_81454);
var inst_81456 = cljs.core.ex_info.call(null,inst_81452,inst_81455);
var inst_81457 = (function(){throw inst_81456})();
var state_81496__$1 = state_81496;
var statearr_81519_81565 = state_81496__$1;
(statearr_81519_81565[(2)] = inst_81457);

(statearr_81519_81565[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (3))){
var inst_81494 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81496__$1,inst_81494);
} else {
if((state_val_81497 === (12))){
var inst_81446 = fluree.db.dbproto._subid.call(null,db,auth);
var state_81496__$1 = state_81496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81496__$1,(15),inst_81446);
} else {
if((state_val_81497 === (2))){
var _ = (function (){var statearr_81520 = state_81496;
(statearr_81520[(4)] = cljs.core.cons.call(null,(5),(state_81496[(4)])));

return statearr_81520;
})();
var inst_81439 = (auth == null);
var state_81496__$1 = state_81496;
if(cljs.core.truth_(inst_81439)){
var statearr_81521_81566 = state_81496__$1;
(statearr_81521_81566[(1)] = (6));

} else {
var statearr_81522_81567 = state_81496__$1;
(statearr_81522_81567[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (23))){
var state_81496__$1 = state_81496;
var statearr_81523_81568 = state_81496__$1;
(statearr_81523_81568[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (19))){
var state_81496__$1 = state_81496;
var statearr_81525_81569 = state_81496__$1;
(statearr_81525_81569[(2)] = roles);

(statearr_81525_81569[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (11))){
var inst_81464 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
var statearr_81527_81570 = state_81496__$1;
(statearr_81527_81570[(2)] = inst_81464);

(statearr_81527_81570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (9))){
var state_81496__$1 = state_81496;
var statearr_81528_81571 = state_81496__$1;
(statearr_81528_81571[(2)] = (0));

(statearr_81528_81571[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (5))){
var _ = (function (){var statearr_81529 = state_81496;
(statearr_81529[(4)] = cljs.core.rest.call(null,(state_81496[(4)])));

return statearr_81529;
})();
var state_81496__$1 = state_81496;
var ex81526 = (state_81496__$1[(2)]);
var statearr_81530_81572 = state_81496__$1;
(statearr_81530_81572[(5)] = ex81526);


if((ex81526 instanceof Error)){
var statearr_81531_81573 = state_81496__$1;
(statearr_81531_81573[(1)] = (4));

(statearr_81531_81573[(5)] = null);

} else {
throw ex81526;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (14))){
var inst_81462 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
var statearr_81532_81574 = state_81496__$1;
(statearr_81532_81574[(2)] = inst_81462);

(statearr_81532_81574[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (26))){
var state_81496__$1 = state_81496;
var statearr_81533_81575 = state_81496__$1;
(statearr_81533_81575[(2)] = null);

(statearr_81533_81575[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (16))){
var inst_81449 = (state_81496[(8)]);
var state_81496__$1 = state_81496;
var statearr_81534_81576 = state_81496__$1;
(statearr_81534_81576[(2)] = inst_81449);

(statearr_81534_81576[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (30))){
var state_81496__$1 = state_81496;
var statearr_81535_81577 = state_81496__$1;
(statearr_81535_81577[(2)] = null);

(statearr_81535_81577[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (10))){
var state_81496__$1 = state_81496;
if(cljs.core.truth_(auth)){
var statearr_81536_81578 = state_81496__$1;
(statearr_81536_81578[(1)] = (12));

} else {
var statearr_81537_81579 = state_81496__$1;
(statearr_81537_81579[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (18))){
var inst_81459 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
var statearr_81538_81580 = state_81496__$1;
(statearr_81538_81580[(2)] = inst_81459);

(statearr_81538_81580[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (8))){
var inst_81466 = (state_81496[(2)]);
var state_81496__$1 = (function (){var statearr_81539 = state_81496;
(statearr_81539[(7)] = inst_81466);

return statearr_81539;
})();
if(cljs.core.truth_(roles)){
var statearr_81540_81581 = state_81496__$1;
(statearr_81540_81581[(1)] = (19));

} else {
var statearr_81541_81582 = state_81496__$1;
(statearr_81541_81582[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__11469__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__11469__auto____0 = (function (){
var statearr_81542 = [null,null,null,null,null,null,null,null,null,null];
(statearr_81542[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__11469__auto__);

(statearr_81542[(1)] = (1));

return statearr_81542;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__11469__auto____1 = (function (state_81496){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_81496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e81543){var ex__11472__auto__ = e81543;
var statearr_81544_81583 = state_81496;
(statearr_81544_81583[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_81496[(4)]))){
var statearr_81545_81584 = state_81496;
(statearr_81545_81584[(1)] = cljs.core.first.call(null,(state_81496[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81585 = state_81496;
state_81496 = G__81585;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__11469__auto__ = function(state_81496){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__11469__auto____1.call(this,state_81496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__11469__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__11469__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_81546 = f__11543__auto__.call(null);
(statearr_81546[(6)] = c__11542__auto__);

return statearr_81546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__81586 = db;
var map__81586__$1 = (((((!((map__81586 == null))))?(((((map__81586.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__81586.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__81586):map__81586);
var conn = cljs.core.get.call(null,map__81586__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__81586__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__81586__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.call(null,"NEW EVENT:",cljs.core.pr_str.call(null,evt),cljs.core.pr_str.call(null,data));

if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);

var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_81594){
var state_val_81595 = (state_81594[(1)]);
if((state_val_81595 === (1))){
var inst_81588 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_81589 = fluree.db.session.db.call(null,conn,inst_81588,null);
var state_81594__$1 = state_81594;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81594__$1,(2),inst_81589);
} else {
if((state_val_81595 === (2))){
var inst_81591 = (state_81594[(2)]);
var inst_81592 = cljs.core.async.put_BANG_.call(null,resp_port,inst_81591);
var state_81594__$1 = state_81594;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81594__$1,inst_81592);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto____0 = (function (){
var statearr_81596 = [null,null,null,null,null,null,null];
(statearr_81596[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto__);

(statearr_81596[(1)] = (1));

return statearr_81596;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto____1 = (function (state_81594){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_81594);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e81597){var ex__11472__auto__ = e81597;
var statearr_81598_81625 = state_81594;
(statearr_81598_81625[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_81594[(4)]))){
var statearr_81599_81626 = state_81594;
(statearr_81599_81626[(1)] = cljs.core.first.call(null,(state_81594[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81627 = state_81594;
state_81594 = G__81627;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto__ = function(state_81594){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto____1.call(this,state_81594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_81600 = f__11543__auto__.call(null);
(statearr_81600[(6)] = c__11542__auto__);

return statearr_81600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,dbid,listen_id,event_fn);

var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_81613){
var state_val_81614 = (state_81613[(1)]);
if((state_val_81614 === (1))){
var inst_81601 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_81602 = fluree.db.session.db.call(null,conn,inst_81601,null);
var state_81613__$1 = state_81613;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81613__$1,(2),inst_81602);
} else {
if((state_val_81614 === (2))){
var inst_81604 = (state_81613[(7)]);
var inst_81604__$1 = (state_81613[(2)]);
var inst_81605 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_81604__$1);
var inst_81606 = newer_block_QMARK_.call(null,inst_81605);
var state_81613__$1 = (function (){var statearr_81615 = state_81613;
(statearr_81615[(7)] = inst_81604__$1);

return statearr_81615;
})();
if(inst_81606){
var statearr_81616_81628 = state_81613__$1;
(statearr_81616_81628[(1)] = (3));

} else {
var statearr_81617_81629 = state_81613__$1;
(statearr_81617_81629[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81614 === (3))){
var inst_81604 = (state_81613[(7)]);
var inst_81608 = cljs.core.async.put_BANG_.call(null,resp_port,inst_81604);
var state_81613__$1 = state_81613;
var statearr_81618_81630 = state_81613__$1;
(statearr_81618_81630[(2)] = inst_81608);

(statearr_81618_81630[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81614 === (4))){
var state_81613__$1 = state_81613;
var statearr_81619_81631 = state_81613__$1;
(statearr_81619_81631[(2)] = null);

(statearr_81619_81631[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81614 === (5))){
var inst_81611 = (state_81613[(2)]);
var state_81613__$1 = state_81613;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81613__$1,inst_81611);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto____0 = (function (){
var statearr_81620 = [null,null,null,null,null,null,null,null];
(statearr_81620[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto__);

(statearr_81620[(1)] = (1));

return statearr_81620;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto____1 = (function (state_81613){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_81613);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e81621){var ex__11472__auto__ = e81621;
var statearr_81622_81632 = state_81613;
(statearr_81622_81632[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_81613[(4)]))){
var statearr_81623_81633 = state_81613;
(statearr_81623_81633[(1)] = cljs.core.first.call(null,(state_81613[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81634 = state_81613;
state_81613 = G__81634;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto__ = function(state_81613){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto____1.call(this,state_81613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_81624 = f__11543__auto__.call(null);
(statearr_81624[(6)] = c__11542__auto__);

return statearr_81624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__81635 = db;
var map__81635__$1 = (((((!((map__81635 == null))))?(((((map__81635.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__81635.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__81635):map__81635);
var conn = cljs.core.get.call(null,map__81635__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__81635__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__81635__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__4217__auto__ = syncTimeout;
var y__4218__auto__ = (120000);
return ((x__4217__auto__ < y__4218__auto__) ? x__4217__auto__ : y__4218__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__11542__auto___81712 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_81686){
var state_val_81687 = (state_81686[(1)]);
if((state_val_81687 === (7))){
var inst_81652 = (state_81686[(7)]);
var inst_81663 = cljs.core._EQ_.call(null,inst_81652,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_81686__$1 = state_81686;
if(inst_81663){
var statearr_81688_81713 = state_81686__$1;
(statearr_81688_81713[(1)] = (9));

} else {
var statearr_81689_81714 = state_81686__$1;
(statearr_81689_81714[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81687 === (1))){
var inst_81645 = (state_81686[(8)]);
var inst_81637 = (state_81686[(9)]);
var inst_81637__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_81645__$1 = res_port;
var inst_81646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81647 = [inst_81637__$1,inst_81645__$1];
var inst_81648 = (new cljs.core.PersistentVector(null,2,(5),inst_81646,inst_81647,null));
var state_81686__$1 = (function (){var statearr_81690 = state_81686;
(statearr_81690[(8)] = inst_81645__$1);

(statearr_81690[(9)] = inst_81637__$1);

return statearr_81690;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_81686__$1,(2),inst_81648);
} else {
if((state_val_81687 === (4))){
var inst_81645 = (state_81686[(8)]);
var inst_81652 = (state_81686[(7)]);
var inst_81656 = cljs.core._EQ_.call(null,inst_81652,inst_81645);
var state_81686__$1 = state_81686;
if(inst_81656){
var statearr_81691_81715 = state_81686__$1;
(statearr_81691_81715[(1)] = (6));

} else {
var statearr_81692_81716 = state_81686__$1;
(statearr_81692_81716[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81687 === (13))){
var inst_81671 = (state_81686[(10)]);
var inst_81682 = cljs.core.async.put_BANG_.call(null,pc,inst_81671);
var state_81686__$1 = state_81686;
var statearr_81693_81717 = state_81686__$1;
(statearr_81693_81717[(2)] = inst_81682);

(statearr_81693_81717[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81687 === (6))){
var inst_81650 = (state_81686[(11)]);
var inst_81661 = cljs.core.nth.call(null,inst_81650,(0),null);
var state_81686__$1 = state_81686;
var statearr_81694_81718 = state_81686__$1;
(statearr_81694_81718[(2)] = inst_81661);

(statearr_81694_81718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81687 === (3))){
var state_81686__$1 = state_81686;
var statearr_81695_81719 = state_81686__$1;
(statearr_81695_81719[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_81695_81719[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81687 === (12))){
var inst_81675 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_81676 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81677 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_81678 = cljs.core.PersistentHashMap.fromArrays(inst_81676,inst_81677);
var inst_81679 = cljs.core.ex_info.call(null,inst_81675,inst_81678);
var inst_81680 = cljs.core.async.put_BANG_.call(null,pc,inst_81679);
var state_81686__$1 = state_81686;
var statearr_81696_81720 = state_81686__$1;
(statearr_81696_81720[(2)] = inst_81680);

(statearr_81696_81720[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81687 === (2))){
var inst_81652 = (state_81686[(7)]);
var inst_81650 = (state_81686[(11)]);
var inst_81637 = (state_81686[(9)]);
var inst_81650__$1 = (state_81686[(2)]);
var inst_81651 = cljs.core.nth.call(null,inst_81650__$1,(0),null);
var inst_81652__$1 = cljs.core.nth.call(null,inst_81650__$1,(1),null);
var inst_81653 = cljs.core._EQ_.call(null,inst_81652__$1,inst_81637);
var state_81686__$1 = (function (){var statearr_81697 = state_81686;
(statearr_81697[(7)] = inst_81652__$1);

(statearr_81697[(11)] = inst_81650__$1);

(statearr_81697[(12)] = inst_81651);

return statearr_81697;
})();
if(inst_81653){
var statearr_81698_81721 = state_81686__$1;
(statearr_81698_81721[(1)] = (3));

} else {
var statearr_81699_81722 = state_81686__$1;
(statearr_81699_81722[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81687 === (11))){
var inst_81667 = (state_81686[(2)]);
var state_81686__$1 = state_81686;
var statearr_81700_81723 = state_81686__$1;
(statearr_81700_81723[(2)] = inst_81667);

(statearr_81700_81723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81687 === (9))){
var inst_81651 = (state_81686[(12)]);
var state_81686__$1 = state_81686;
var statearr_81701_81724 = state_81686__$1;
(statearr_81701_81724[(2)] = inst_81651);

(statearr_81701_81724[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81687 === (5))){
var inst_81671 = (state_81686[(10)]);
var inst_81671__$1 = (state_81686[(2)]);
var inst_81672 = fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);
var inst_81673 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_81671__$1);
var state_81686__$1 = (function (){var statearr_81702 = state_81686;
(statearr_81702[(13)] = inst_81672);

(statearr_81702[(10)] = inst_81671__$1);

return statearr_81702;
})();
if(inst_81673){
var statearr_81703_81725 = state_81686__$1;
(statearr_81703_81725[(1)] = (12));

} else {
var statearr_81704_81726 = state_81686__$1;
(statearr_81704_81726[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81687 === (14))){
var inst_81684 = (state_81686[(2)]);
var state_81686__$1 = state_81686;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81686__$1,inst_81684);
} else {
if((state_val_81687 === (10))){
var state_81686__$1 = state_81686;
var statearr_81705_81727 = state_81686__$1;
(statearr_81705_81727[(2)] = null);

(statearr_81705_81727[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81687 === (8))){
var inst_81669 = (state_81686[(2)]);
var state_81686__$1 = state_81686;
var statearr_81706_81728 = state_81686__$1;
(statearr_81706_81728[(2)] = inst_81669);

(statearr_81706_81728[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__11469__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__11469__auto____0 = (function (){
var statearr_81707 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81707[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__11469__auto__);

(statearr_81707[(1)] = (1));

return statearr_81707;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__11469__auto____1 = (function (state_81686){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_81686);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e81708){var ex__11472__auto__ = e81708;
var statearr_81709_81729 = state_81686;
(statearr_81709_81729[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_81686[(4)]))){
var statearr_81710_81730 = state_81686;
(statearr_81710_81730[(1)] = cljs.core.first.call(null,(state_81686[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81731 = state_81686;
state_81686 = G__81731;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__11469__auto__ = function(state_81686){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__11469__auto____1.call(this,state_81686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__11469__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__11469__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_81711 = f__11543__auto__.call(null);
(statearr_81711[(6)] = c__11542__auto___81712);

return statearr_81711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__81733 = arguments.length;
switch (G__81733) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__81734){
var map__81735 = p__81734;
var map__81735__$1 = (((((!((map__81735 == null))))?(((((map__81735.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__81735.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__81735):map__81735);
var opts = map__81735__$1;
var roles = cljs.core.get.call(null,map__81735__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__81735__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__81735__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__81735__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__81735__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var c__11542__auto___81825 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_81787){
var state_val_81788 = (state_81787[(1)]);
if((state_val_81788 === (7))){
var inst_81749 = (state_81787[(7)]);
var inst_81751 = fluree.db.api.ledger.syncTo_db.call(null,inst_81749,syncTo,syncTimeout);
var state_81787__$1 = state_81787;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81787__$1,(10),inst_81751);
} else {
if((state_val_81788 === (20))){
var inst_81773 = (state_81787[(8)]);
var state_81787__$1 = state_81787;
var statearr_81789_81826 = state_81787__$1;
(statearr_81789_81826[(2)] = inst_81773);

(statearr_81789_81826[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (1))){
var state_81787__$1 = state_81787;
var statearr_81790_81827 = state_81787__$1;
(statearr_81790_81827[(2)] = null);

(statearr_81790_81827[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (4))){
var inst_81737 = (state_81787[(2)]);
var inst_81738 = cljs.core.async.put_BANG_.call(null,pc,inst_81737);
var inst_81739 = cljs.core.async.close_BANG_.call(null,pc);
var state_81787__$1 = (function (){var statearr_81791 = state_81787;
(statearr_81791[(9)] = inst_81738);

return statearr_81791;
})();
var statearr_81792_81828 = state_81787__$1;
(statearr_81792_81828[(2)] = inst_81739);

(statearr_81792_81828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (15))){
var inst_81765 = (state_81787[(10)]);
var inst_81767 = fluree.db.api.ledger.add_db_permissions.call(null,inst_81765,auth,roles);
var state_81787__$1 = state_81787;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81787__$1,(18),inst_81767);
} else {
if((state_val_81788 === (21))){
var inst_81781 = (state_81787[(2)]);
var inst_81782 = cljs.core.async.put_BANG_.call(null,pc,inst_81781);
var _ = (function (){var statearr_81793 = state_81787;
(statearr_81793[(4)] = cljs.core.rest.call(null,(state_81787[(4)])));

return statearr_81793;
})();
var state_81787__$1 = state_81787;
var statearr_81794_81829 = state_81787__$1;
(statearr_81794_81829[(2)] = inst_81782);

(statearr_81794_81829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (13))){
var inst_81765 = (state_81787[(2)]);
var state_81787__$1 = (function (){var statearr_81795 = state_81787;
(statearr_81795[(10)] = inst_81765);

return statearr_81795;
})();
if(cljs.core.truth_(roles)){
var statearr_81796_81830 = state_81787__$1;
(statearr_81796_81830[(1)] = (15));

} else {
var statearr_81797_81831 = state_81787__$1;
(statearr_81797_81831[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (22))){
var inst_81777 = (state_81787[(2)]);
var inst_81778 = fluree.db.util.async.throw_err.call(null,inst_81777);
var state_81787__$1 = state_81787;
var statearr_81798_81832 = state_81787__$1;
(statearr_81798_81832[(2)] = inst_81778);

(statearr_81798_81832[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (6))){
var inst_81748 = (state_81787[(2)]);
var inst_81749 = fluree.db.util.async.throw_err.call(null,inst_81748);
var state_81787__$1 = (function (){var statearr_81799 = state_81787;
(statearr_81799[(7)] = inst_81749);

return statearr_81799;
})();
if(cljs.core.truth_(syncTo)){
var statearr_81800_81833 = state_81787__$1;
(statearr_81800_81833[(1)] = (7));

} else {
var statearr_81801_81834 = state_81787__$1;
(statearr_81801_81834[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (17))){
var inst_81773 = (state_81787[(2)]);
var state_81787__$1 = (function (){var statearr_81802 = state_81787;
(statearr_81802[(8)] = inst_81773);

return statearr_81802;
})();
if(cljs.core.truth_(auth)){
var statearr_81803_81835 = state_81787__$1;
(statearr_81803_81835[(1)] = (19));

} else {
var statearr_81804_81836 = state_81787__$1;
(statearr_81804_81836[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (3))){
var inst_81785 = (state_81787[(2)]);
var state_81787__$1 = state_81787;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81787__$1,inst_81785);
} else {
if((state_val_81788 === (12))){
var inst_81757 = (state_81787[(11)]);
var state_81787__$1 = state_81787;
var statearr_81805_81837 = state_81787__$1;
(statearr_81805_81837[(2)] = inst_81757);

(statearr_81805_81837[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (2))){
var _ = (function (){var statearr_81806 = state_81787;
(statearr_81806[(4)] = cljs.core.cons.call(null,(5),(state_81787[(4)])));

return statearr_81806;
})();
var inst_81746 = fluree.db.session.db.call(null,conn,ledger,null);
var state_81787__$1 = state_81787;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81787__$1,(6),inst_81746);
} else {
if((state_val_81788 === (19))){
var inst_81773 = (state_81787[(8)]);
var inst_81775 = fluree.db.api.ledger.add_db_permissions.call(null,inst_81773,auth,roles);
var state_81787__$1 = state_81787;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81787__$1,(22),inst_81775);
} else {
if((state_val_81788 === (11))){
var inst_81757 = (state_81787[(11)]);
var inst_81759 = fluree.db.time_travel.as_of_block.call(null,inst_81757,block);
var state_81787__$1 = state_81787;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81787__$1,(14),inst_81759);
} else {
if((state_val_81788 === (9))){
var inst_81757 = (state_81787[(2)]);
var state_81787__$1 = (function (){var statearr_81808 = state_81787;
(statearr_81808[(11)] = inst_81757);

return statearr_81808;
})();
if(cljs.core.truth_(block)){
var statearr_81809_81838 = state_81787__$1;
(statearr_81809_81838[(1)] = (11));

} else {
var statearr_81810_81839 = state_81787__$1;
(statearr_81810_81839[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (5))){
var _ = (function (){var statearr_81811 = state_81787;
(statearr_81811[(4)] = cljs.core.rest.call(null,(state_81787[(4)])));

return statearr_81811;
})();
var state_81787__$1 = state_81787;
var ex81807 = (state_81787__$1[(2)]);
var statearr_81812_81840 = state_81787__$1;
(statearr_81812_81840[(5)] = ex81807);


var statearr_81813_81841 = state_81787__$1;
(statearr_81813_81841[(1)] = (4));

(statearr_81813_81841[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (14))){
var inst_81761 = (state_81787[(2)]);
var inst_81762 = fluree.db.util.async.throw_err.call(null,inst_81761);
var state_81787__$1 = state_81787;
var statearr_81814_81842 = state_81787__$1;
(statearr_81814_81842[(2)] = inst_81762);

(statearr_81814_81842[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (16))){
var inst_81765 = (state_81787[(10)]);
var state_81787__$1 = state_81787;
var statearr_81815_81843 = state_81787__$1;
(statearr_81815_81843[(2)] = inst_81765);

(statearr_81815_81843[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (10))){
var inst_81753 = (state_81787[(2)]);
var inst_81754 = fluree.db.util.async.throw_err.call(null,inst_81753);
var state_81787__$1 = state_81787;
var statearr_81816_81844 = state_81787__$1;
(statearr_81816_81844[(2)] = inst_81754);

(statearr_81816_81844[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (18))){
var inst_81769 = (state_81787[(2)]);
var inst_81770 = fluree.db.util.async.throw_err.call(null,inst_81769);
var state_81787__$1 = state_81787;
var statearr_81817_81845 = state_81787__$1;
(statearr_81817_81845[(2)] = inst_81770);

(statearr_81817_81845[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81788 === (8))){
var inst_81749 = (state_81787[(7)]);
var state_81787__$1 = state_81787;
var statearr_81818_81846 = state_81787__$1;
(statearr_81818_81846[(2)] = inst_81749);

(statearr_81818_81846[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__11469__auto__ = null;
var fluree$db$api$ledger$state_machine__11469__auto____0 = (function (){
var statearr_81819 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81819[(0)] = fluree$db$api$ledger$state_machine__11469__auto__);

(statearr_81819[(1)] = (1));

return statearr_81819;
});
var fluree$db$api$ledger$state_machine__11469__auto____1 = (function (state_81787){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_81787);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e81820){var ex__11472__auto__ = e81820;
var statearr_81821_81847 = state_81787;
(statearr_81821_81847[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_81787[(4)]))){
var statearr_81822_81848 = state_81787;
(statearr_81822_81848[(1)] = cljs.core.first.call(null,(state_81787[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81849 = state_81787;
state_81787 = G__81849;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__11469__auto__ = function(state_81787){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__11469__auto____1.call(this,state_81787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__11469__auto____0;
fluree$db$api$ledger$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__11469__auto____1;
return fluree$db$api$ledger$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_81823 = f__11543__auto__.call(null);
(statearr_81823[(6)] = c__11542__auto___81825);

return statearr_81823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

