// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__24179 = match;
var p1 = cljs.core.nth.call(null,vec__24179,(0),null);
var p2 = cljs.core.nth.call(null,vec__24179,(1),null);
var p3 = cljs.core.nth.call(null,vec__24179,(2),null);
var t = cljs.core.nth.call(null,vec__24179,(3),null);
var op = cljs.core.nth.call(null,vec__24179,(4),null);
var m = cljs.core.nth.call(null,vec__24179,(5),null);
var G__24182 = idx;
var G__24182__$1 = (((G__24182 instanceof cljs.core.Keyword))?G__24182.fqn:null);
switch (G__24182__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24182__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__24184 = idx;
var G__24184__$1 = (((G__24184 instanceof cljs.core.Keyword))?G__24184.fqn:null);
switch (G__24184__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24184__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__24186 = idx;
var G__24186__$1 = (((G__24186 instanceof cljs.core.Keyword))?G__24186.fqn:null);
switch (G__24186__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24186__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__24189 = arguments.length;
switch (G__24189) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__24190 = (function (){var pred__24193 = cljs.core.identical_QMARK_;
var expr__24194 = test;
if(cljs.core.truth_(pred__24193.call(null,cljs.core._EQ_,expr__24194))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__24193.call(null,cljs.core._LT_,expr__24194))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__24193.call(null,cljs.core._LT__EQ_,expr__24194))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__24193.call(null,cljs.core._GT_,expr__24194))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__24193.call(null,cljs.core._GT__EQ_,expr__24194))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__24194)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__24190,(0),null);
var start_match = cljs.core.nth.call(null,vec__24190,(1),null);
var end_test = cljs.core.nth.call(null,vec__24190,(2),null);
var end_match = cljs.core.nth.call(null,vec__24190,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_24407){
var state_val_24408 = (state_24407[(1)]);
if((state_val_24408 === (65))){
var inst_24360 = (state_24407[(7)]);
var inst_24328 = (state_24407[(8)]);
var inst_24372 = cljs.core.into.call(null,inst_24360,inst_24328);
var state_24407__$1 = state_24407;
var statearr_24409_24525 = state_24407__$1;
(statearr_24409_24525[(2)] = inst_24372);

(statearr_24409_24525[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (70))){
var inst_24390 = (state_24407[(2)]);
var inst_24391 = cljs.core.not.call(null,inst_24390);
var state_24407__$1 = state_24407;
if(inst_24391){
var statearr_24410_24526 = state_24407__$1;
(statearr_24410_24526[(1)] = (71));

} else {
var statearr_24411_24527 = state_24407__$1;
(statearr_24411_24527[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (62))){
var inst_24381 = (state_24407[(9)]);
var inst_24342 = (state_24407[(10)]);
var inst_24381__$1 = (state_24407[(2)]);
var inst_24382 = cljs.core.count.call(null,inst_24381__$1);
var state_24407__$1 = (function (){var statearr_24412 = state_24407;
(statearr_24412[(11)] = inst_24382);

(statearr_24412[(9)] = inst_24381__$1);

return statearr_24412;
})();
if(cljs.core.truth_(inst_24342)){
var statearr_24413_24528 = state_24407__$1;
(statearr_24413_24528[(1)] = (68));

} else {
var statearr_24414_24529 = state_24407__$1;
(statearr_24414_24529[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (74))){
var inst_24382 = (state_24407[(11)]);
var inst_24381 = (state_24407[(9)]);
var inst_24396 = (state_24407[(2)]);
var inst_24397 = fluree.db.util.async.throw_err.call(null,inst_24396);
var inst_24326 = inst_24397;
var inst_24327 = inst_24382;
var inst_24328 = inst_24381;
var state_24407__$1 = (function (){var statearr_24415 = state_24407;
(statearr_24415[(12)] = inst_24327);

(statearr_24415[(8)] = inst_24328);

(statearr_24415[(13)] = inst_24326);

return statearr_24415;
})();
var statearr_24416_24530 = state_24407__$1;
(statearr_24416_24530[(2)] = null);

(statearr_24416_24530[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (7))){
var inst_24209 = (state_24407[(14)]);
var state_24407__$1 = state_24407;
var statearr_24417_24531 = state_24407__$1;
(statearr_24417_24531[(2)] = inst_24209);

(statearr_24417_24531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (59))){
var inst_24326 = (state_24407[(13)]);
var inst_24341 = (state_24407[(2)]);
var inst_24342 = fluree.db.dbproto._rhs.call(null,inst_24326);
var state_24407__$1 = (function (){var statearr_24418 = state_24407;
(statearr_24418[(15)] = inst_24341);

(statearr_24418[(10)] = inst_24342);

return statearr_24418;
})();
var statearr_24419_24532 = state_24407__$1;
(statearr_24419_24532[(1)] = (60));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (20))){
var inst_24210 = (state_24407[(16)]);
var inst_24257 = (state_24407[(2)]);
var inst_24258 = (inst_24210 == null);
var state_24407__$1 = (function (){var statearr_24421 = state_24407;
(statearr_24421[(17)] = inst_24257);

return statearr_24421;
})();
if(cljs.core.truth_(inst_24258)){
var statearr_24422_24533 = state_24407__$1;
(statearr_24422_24533[(1)] = (22));

} else {
var statearr_24423_24534 = state_24407__$1;
(statearr_24423_24534[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (72))){
var inst_24321 = (state_24407[(18)]);
var inst_24342 = (state_24407[(10)]);
var inst_24394 = fluree.db.dbproto._lookup_leaf.call(null,inst_24321,inst_24342);
var state_24407__$1 = state_24407;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24407__$1,(74),inst_24394);
} else {
if((state_val_24408 === (58))){
var inst_24334 = (state_24407[(19)]);
var state_24407__$1 = state_24407;
var statearr_24424_24535 = state_24407__$1;
(statearr_24424_24535[(2)] = inst_24334);

(statearr_24424_24535[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (60))){
var inst_24327 = (state_24407[(12)]);
var inst_24341 = (state_24407[(15)]);
var inst_24300 = (state_24407[(20)]);
var inst_24328 = (state_24407[(8)]);
var inst_24344 = (inst_24300 - inst_24327);
var inst_24345 = fluree.db.flake.take.call(null,inst_24344,inst_24341);
var inst_24346 = cljs.core.into.call(null,inst_24345,inst_24328);
var state_24407__$1 = state_24407;
var statearr_24425_24536 = state_24407__$1;
(statearr_24425_24536[(2)] = inst_24346);

(statearr_24425_24536[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (27))){
var inst_24217 = (state_24407[(21)]);
var inst_24266 = (state_24407[(2)]);
var inst_24267 = (inst_24217 == null);
var state_24407__$1 = (function (){var statearr_24426 = state_24407;
(statearr_24426[(22)] = inst_24266);

return statearr_24426;
})();
if(cljs.core.truth_(inst_24267)){
var statearr_24427_24537 = state_24407__$1;
(statearr_24427_24537[(1)] = (28));

} else {
var statearr_24428_24538 = state_24407__$1;
(statearr_24428_24538[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (1))){
var state_24407__$1 = state_24407;
var statearr_24429_24539 = state_24407__$1;
(statearr_24429_24539[(2)] = null);

(statearr_24429_24539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (69))){
var inst_24342 = (state_24407[(10)]);
var state_24407__$1 = state_24407;
var statearr_24430_24540 = state_24407__$1;
(statearr_24430_24540[(2)] = inst_24342);

(statearr_24430_24540[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (24))){
var inst_24262 = (state_24407[(2)]);
var state_24407__$1 = state_24407;
if(cljs.core.truth_(inst_24262)){
var statearr_24431_24541 = state_24407__$1;
(statearr_24431_24541[(1)] = (25));

} else {
var statearr_24432_24542 = state_24407__$1;
(statearr_24432_24542[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (55))){
var inst_24402 = (state_24407[(2)]);
var _ = (function (){var statearr_24433 = state_24407;
(statearr_24433[(4)] = cljs.core.rest.call(null,(state_24407[(4)])));

return statearr_24433;
})();
var state_24407__$1 = state_24407;
var statearr_24434_24543 = state_24407__$1;
(statearr_24434_24543[(2)] = inst_24402);

(statearr_24434_24543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (39))){
var inst_24282 = (state_24407[(2)]);
var state_24407__$1 = state_24407;
var statearr_24435_24544 = state_24407__$1;
(statearr_24435_24544[(2)] = inst_24282);

(statearr_24435_24544[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (46))){
var inst_24296 = (state_24407[(23)]);
var state_24407__$1 = state_24407;
var statearr_24436_24545 = state_24407__$1;
(statearr_24436_24545[(2)] = inst_24296);

(statearr_24436_24545[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (4))){
var inst_24196 = (state_24407[(2)]);
var state_24407__$1 = state_24407;
var statearr_24437_24546 = state_24407__$1;
(statearr_24437_24546[(2)] = inst_24196);

(statearr_24437_24546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (54))){
var inst_24311 = (state_24407[(24)]);
var inst_24326 = (state_24407[(13)]);
var inst_24312 = (state_24407[(25)]);
var inst_24316 = (state_24407[(26)]);
var inst_24330 = fluree.db.dbproto._resolve_history_range.call(null,inst_24326,inst_24311,inst_24312,inst_24316);
var state_24407__$1 = state_24407;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24407__$1,(56),inst_24330);
} else {
if((state_val_24408 === (15))){
var inst_24211 = (state_24407[(27)]);
var state_24407__$1 = state_24407;
var statearr_24438_24547 = state_24407__$1;
(statearr_24438_24547[(2)] = inst_24211);

(statearr_24438_24547[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (48))){
var inst_24306 = (state_24407[(28)]);
var inst_24300 = (state_24407[(2)]);
var inst_24301 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_24302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24303 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_24304 = (new cljs.core.PersistentVector(null,3,(5),inst_24302,inst_24303,null));
var inst_24305 = cljs.core.get_in.call(null,db,inst_24304);
var inst_24306__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_24407__$1 = (function (){var statearr_24439 = state_24407;
(statearr_24439[(28)] = inst_24306__$1);

(statearr_24439[(29)] = inst_24301);

(statearr_24439[(30)] = inst_24305);

(statearr_24439[(20)] = inst_24300);

return statearr_24439;
})();
if(cljs.core.truth_(inst_24306__$1)){
var statearr_24440_24548 = state_24407__$1;
(statearr_24440_24548[(1)] = (49));

} else {
var statearr_24441_24549 = state_24407__$1;
(statearr_24441_24549[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (50))){
var inst_24309 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_24407__$1 = state_24407;
var statearr_24442_24550 = state_24407__$1;
(statearr_24442_24550[(2)] = inst_24309);

(statearr_24442_24550[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (21))){
var inst_24253 = (state_24407[(2)]);
var inst_24254 = fluree.db.util.async.throw_err.call(null,inst_24253);
var state_24407__$1 = state_24407;
var statearr_24443_24551 = state_24407__$1;
(statearr_24443_24551[(2)] = inst_24254);

(statearr_24443_24551[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (31))){
var state_24407__$1 = state_24407;
var statearr_24444_24552 = state_24407__$1;
(statearr_24444_24552[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_24444_24552[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (32))){
var inst_24217 = (state_24407[(21)]);
var state_24407__$1 = state_24407;
var statearr_24445_24553 = state_24407__$1;
(statearr_24445_24553[(2)] = inst_24217);

(statearr_24445_24553[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (40))){
var inst_24221 = (state_24407[(31)]);
var state_24407__$1 = state_24407;
var statearr_24446_24554 = state_24407__$1;
(statearr_24446_24554[(2)] = inst_24221);

(statearr_24446_24554[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (56))){
var inst_24295 = (state_24407[(32)]);
var inst_24294 = (state_24407[(33)]);
var inst_24333 = (state_24407[(34)]);
var inst_24332 = (state_24407[(2)]);
var inst_24333__$1 = fluree.db.util.async.throw_err.call(null,inst_24332);
var inst_24334 = fluree.db.flake.subrange.call(null,inst_24333__$1,start_test,inst_24294,end_test,inst_24295);
var inst_24335 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_24294,inst_24295);
var state_24407__$1 = (function (){var statearr_24447 = state_24407;
(statearr_24447[(19)] = inst_24334);

(statearr_24447[(34)] = inst_24333__$1);

return statearr_24447;
})();
if(inst_24335){
var statearr_24448_24555 = state_24407__$1;
(statearr_24448_24555[(1)] = (57));

} else {
var statearr_24449_24556 = state_24407__$1;
(statearr_24449_24556[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (33))){
var inst_24214 = (state_24407[(35)]);
var inst_24275 = (state_24407[(2)]);
var state_24407__$1 = (function (){var statearr_24450 = state_24407;
(statearr_24450[(36)] = inst_24275);

return statearr_24450;
})();
if(cljs.core.truth_(inst_24214)){
var statearr_24451_24557 = state_24407__$1;
(statearr_24451_24557[(1)] = (34));

} else {
var statearr_24452_24558 = state_24407__$1;
(statearr_24452_24558[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (13))){
var inst_24235 = (state_24407[(2)]);
var inst_24236 = fluree.db.util.async.throw_err.call(null,inst_24235);
var state_24407__$1 = state_24407;
var statearr_24453_24559 = state_24407__$1;
(statearr_24453_24559[(2)] = inst_24236);

(statearr_24453_24559[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (22))){
var inst_24248 = (state_24407[(37)]);
var state_24407__$1 = state_24407;
var statearr_24454_24560 = state_24407__$1;
(statearr_24454_24560[(2)] = inst_24248);

(statearr_24454_24560[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (36))){
var inst_24221 = (state_24407[(31)]);
var inst_24284 = (state_24407[(2)]);
var state_24407__$1 = (function (){var statearr_24455 = state_24407;
(statearr_24455[(38)] = inst_24284);

return statearr_24455;
})();
if(cljs.core.truth_(inst_24221)){
var statearr_24456_24561 = state_24407__$1;
(statearr_24456_24561[(1)] = (40));

} else {
var statearr_24457_24562 = state_24407__$1;
(statearr_24457_24562[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (41))){
var inst_24287 = (cljs.core._LT__EQ_ === end_test);
var state_24407__$1 = state_24407;
if(cljs.core.truth_(inst_24287)){
var statearr_24458_24563 = state_24407__$1;
(statearr_24458_24563[(1)] = (43));

} else {
var statearr_24459_24564 = state_24407__$1;
(statearr_24459_24564[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (43))){
var state_24407__$1 = state_24407;
var statearr_24460_24565 = state_24407__$1;
(statearr_24460_24565[(2)] = (2147483647));

(statearr_24460_24565[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (61))){
var inst_24327 = (state_24407[(12)]);
var inst_24341 = (state_24407[(15)]);
var inst_24355 = cljs.core.seq.call(null,inst_24341);
var inst_24356 = cljs.core.first.call(null,inst_24355);
var inst_24357 = cljs.core.next.call(null,inst_24355);
var inst_24358 = inst_24341;
var inst_24359 = inst_24327;
var inst_24360 = inst_24341;
var state_24407__$1 = (function (){var statearr_24461 = state_24407;
(statearr_24461[(7)] = inst_24360);

(statearr_24461[(39)] = inst_24356);

(statearr_24461[(40)] = inst_24357);

(statearr_24461[(41)] = inst_24358);

(statearr_24461[(42)] = inst_24359);

return statearr_24461;
})();
var statearr_24462_24566 = state_24407__$1;
(statearr_24462_24566[(2)] = null);

(statearr_24462_24566[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (29))){
var state_24407__$1 = state_24407;
var statearr_24463_24567 = state_24407__$1;
(statearr_24463_24567[(2)] = false);

(statearr_24463_24567[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (44))){
var state_24407__$1 = state_24407;
var statearr_24464_24568 = state_24407__$1;
(statearr_24464_24568[(2)] = fluree.db.util.core.min_integer);

(statearr_24464_24568[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (6))){
var inst_24209 = (state_24407[(14)]);
var inst_24224 = fluree.db.dbproto._subid.call(null,db,inst_24209);
var state_24407__$1 = state_24407;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24407__$1,(9),inst_24224);
} else {
if((state_val_24408 === (28))){
var inst_24257 = (state_24407[(17)]);
var state_24407__$1 = state_24407;
var statearr_24465_24569 = state_24407__$1;
(statearr_24465_24569[(2)] = inst_24257);

(statearr_24465_24569[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (64))){
var inst_24379 = (state_24407[(2)]);
var state_24407__$1 = state_24407;
var statearr_24466_24570 = state_24407__$1;
(statearr_24466_24570[(2)] = inst_24379);

(statearr_24466_24570[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (51))){
var inst_24311 = (state_24407[(2)]);
var inst_24312 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_24313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24314 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_24315 = (new cljs.core.PersistentVector(null,2,(5),inst_24313,inst_24314,null));
var inst_24316 = cljs.core.get_in.call(null,db,inst_24315);
var inst_24317 = cljs.core.get.call(null,db,idx);
var inst_24318 = fluree.db.dbproto._resolve.call(null,inst_24317);
var state_24407__$1 = (function (){var statearr_24467 = state_24407;
(statearr_24467[(24)] = inst_24311);

(statearr_24467[(25)] = inst_24312);

(statearr_24467[(26)] = inst_24316);

return statearr_24467;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24407__$1,(52),inst_24318);
} else {
if((state_val_24408 === (25))){
var state_24407__$1 = state_24407;
var statearr_24468_24571 = state_24407__$1;
(statearr_24468_24571[(2)] = (-1));

(statearr_24468_24571[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (34))){
var inst_24214 = (state_24407[(35)]);
var state_24407__$1 = state_24407;
var statearr_24469_24572 = state_24407__$1;
(statearr_24469_24572[(2)] = inst_24214);

(statearr_24469_24572[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (17))){
var inst_24244 = (state_24407[(2)]);
var inst_24245 = fluree.db.util.async.throw_err.call(null,inst_24244);
var state_24407__$1 = state_24407;
var statearr_24470_24573 = state_24407__$1;
(statearr_24470_24573[(2)] = inst_24245);

(statearr_24470_24573[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (3))){
var inst_24405 = (state_24407[(2)]);
var state_24407__$1 = state_24407;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24407__$1,inst_24405);
} else {
if((state_val_24408 === (12))){
var inst_24211 = (state_24407[(27)]);
var inst_24239 = (state_24407[(2)]);
var inst_24240 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24211);
var state_24407__$1 = (function (){var statearr_24472 = state_24407;
(statearr_24472[(43)] = inst_24239);

return statearr_24472;
})();
if(inst_24240){
var statearr_24473_24574 = state_24407__$1;
(statearr_24473_24574[(1)] = (14));

} else {
var statearr_24474_24575 = state_24407__$1;
(statearr_24474_24575[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (2))){
var inst_24209 = (state_24407[(14)]);
var inst_24215 = (state_24407[(44)]);
var inst_24208 = (state_24407[(45)]);
var _ = (function (){var statearr_24475 = state_24407;
(statearr_24475[(4)] = cljs.core.cons.call(null,(5),(state_24407[(4)])));

return statearr_24475;
})();
var inst_24208__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_24209__$1 = cljs.core.nth.call(null,inst_24208__$1,(0),null);
var inst_24210 = cljs.core.nth.call(null,inst_24208__$1,(1),null);
var inst_24211 = cljs.core.nth.call(null,inst_24208__$1,(2),null);
var inst_24212 = cljs.core.nth.call(null,inst_24208__$1,(3),null);
var inst_24213 = cljs.core.nth.call(null,inst_24208__$1,(4),null);
var inst_24214 = cljs.core.nth.call(null,inst_24208__$1,(5),null);
var inst_24215__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_24216 = cljs.core.nth.call(null,inst_24215__$1,(0),null);
var inst_24217 = cljs.core.nth.call(null,inst_24215__$1,(1),null);
var inst_24218 = cljs.core.nth.call(null,inst_24215__$1,(2),null);
var inst_24219 = cljs.core.nth.call(null,inst_24215__$1,(3),null);
var inst_24220 = cljs.core.nth.call(null,inst_24215__$1,(4),null);
var inst_24221 = cljs.core.nth.call(null,inst_24215__$1,(5),null);
var inst_24222 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24209__$1);
var state_24407__$1 = (function (){var statearr_24476 = state_24407;
(statearr_24476[(46)] = inst_24216);

(statearr_24476[(27)] = inst_24211);

(statearr_24476[(47)] = inst_24220);

(statearr_24476[(48)] = inst_24212);

(statearr_24476[(14)] = inst_24209__$1);

(statearr_24476[(44)] = inst_24215__$1);

(statearr_24476[(45)] = inst_24208__$1);

(statearr_24476[(49)] = inst_24219);

(statearr_24476[(21)] = inst_24217);

(statearr_24476[(16)] = inst_24210);

(statearr_24476[(50)] = inst_24213);

(statearr_24476[(51)] = inst_24218);

(statearr_24476[(35)] = inst_24214);

(statearr_24476[(31)] = inst_24221);

return statearr_24476;
})();
if(inst_24222){
var statearr_24477_24576 = state_24407__$1;
(statearr_24477_24576[(1)] = (6));

} else {
var statearr_24478_24577 = state_24407__$1;
(statearr_24478_24577[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (66))){
var inst_24360 = (state_24407[(7)]);
var inst_24367 = (state_24407[(52)]);
var inst_24359 = (state_24407[(42)]);
var inst_24374 = (inst_24359 + (1));
var tmp24471 = inst_24360;
var inst_24358 = inst_24367;
var inst_24359__$1 = inst_24374;
var inst_24360__$1 = tmp24471;
var state_24407__$1 = (function (){var statearr_24479 = state_24407;
(statearr_24479[(7)] = inst_24360__$1);

(statearr_24479[(41)] = inst_24358);

(statearr_24479[(42)] = inst_24359__$1);

return statearr_24479;
})();
var statearr_24480_24578 = state_24407__$1;
(statearr_24480_24578[(2)] = null);

(statearr_24480_24578[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (23))){
var state_24407__$1 = state_24407;
var statearr_24481_24579 = state_24407__$1;
(statearr_24481_24579[(2)] = false);

(statearr_24481_24579[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (47))){
var state_24407__$1 = state_24407;
var statearr_24482_24580 = state_24407__$1;
(statearr_24482_24580[(2)] = fluree.db.util.core.max_long);

(statearr_24482_24580[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (35))){
var inst_24278 = (cljs.core._GT__EQ_ === start_test);
var state_24407__$1 = state_24407;
if(cljs.core.truth_(inst_24278)){
var statearr_24483_24581 = state_24407__$1;
(statearr_24483_24581[(1)] = (37));

} else {
var statearr_24484_24582 = state_24407__$1;
(statearr_24484_24582[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (19))){
var inst_24218 = (state_24407[(51)]);
var state_24407__$1 = state_24407;
var statearr_24485_24583 = state_24407__$1;
(statearr_24485_24583[(2)] = inst_24218);

(statearr_24485_24583[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (57))){
var inst_24327 = (state_24407[(12)]);
var inst_24275 = (state_24407[(36)]);
var inst_24248 = (state_24407[(37)]);
var inst_24301 = (state_24407[(29)]);
var inst_24220 = (state_24407[(47)]);
var inst_24266 = (state_24407[(22)]);
var inst_24284 = (state_24407[(38)]);
var inst_24212 = (state_24407[(48)]);
var inst_24311 = (state_24407[(24)]);
var inst_24215 = (state_24407[(44)]);
var inst_24208 = (state_24407[(45)]);
var inst_24305 = (state_24407[(30)]);
var inst_24300 = (state_24407[(20)]);
var inst_24219 = (state_24407[(49)]);
var inst_24328 = (state_24407[(8)]);
var inst_24326 = (state_24407[(13)]);
var inst_24295 = (state_24407[(32)]);
var inst_24239 = (state_24407[(43)]);
var inst_24334 = (state_24407[(19)]);
var inst_24293 = (state_24407[(53)]);
var inst_24294 = (state_24407[(33)]);
var inst_24321 = (state_24407[(18)]);
var inst_24257 = (state_24407[(17)]);
var inst_24312 = (state_24407[(25)]);
var inst_24316 = (state_24407[(26)]);
var inst_24213 = (state_24407[(50)]);
var inst_24333 = (state_24407[(34)]);
var inst_24230 = (state_24407[(54)]);
var inst_24337 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_24326;
var flakes = inst_24333;
var s1 = inst_24230;
var o2 = inst_24257;
var t1 = inst_24212;
var i = inst_24327;
var m1 = inst_24284;
var root_node = inst_24321;
var to_t = inst_24312;
var s2 = inst_24239;
var p2 = inst_24275;
var permissions = inst_24301;
var limit = inst_24300;
var start_flake = inst_24294;
var acc = inst_24328;
var t2 = inst_24219;
var op1 = inst_24213;
var o1 = inst_24248;
var end_flake = inst_24295;
var base_result = inst_24334;
var p1 = inst_24266;
var vec__24205 = inst_24215;
var idx_compare = inst_24305;
var op2 = inst_24220;
var vec__24202 = inst_24208;
var from_t = inst_24311;
var m2 = inst_24293;
var novelty = inst_24316;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_24338 = cljs.core.reduce.call(null,inst_24337,inst_24334,inst_24334);
var state_24407__$1 = state_24407;
var statearr_24486_24584 = state_24407__$1;
(statearr_24486_24584[(2)] = inst_24338);

(statearr_24486_24584[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (68))){
var inst_24382 = (state_24407[(11)]);
var inst_24305 = (state_24407[(30)]);
var inst_24300 = (state_24407[(20)]);
var inst_24295 = (state_24407[(32)]);
var inst_24342 = (state_24407[(10)]);
var inst_24384 = inst_24305.call(null,inst_24342,inst_24295);
var inst_24385 = (inst_24384 < (0));
var inst_24386 = (inst_24382 < inst_24300);
var inst_24387 = ((inst_24385) && (inst_24386));
var state_24407__$1 = state_24407;
var statearr_24487_24585 = state_24407__$1;
(statearr_24487_24585[(2)] = inst_24387);

(statearr_24487_24585[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (11))){
var inst_24216 = (state_24407[(46)]);
var state_24407__$1 = state_24407;
var statearr_24489_24586 = state_24407__$1;
(statearr_24489_24586[(2)] = inst_24216);

(statearr_24489_24586[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (9))){
var inst_24226 = (state_24407[(2)]);
var inst_24227 = fluree.db.util.async.throw_err.call(null,inst_24226);
var state_24407__$1 = state_24407;
var statearr_24490_24587 = state_24407__$1;
(statearr_24490_24587[(2)] = inst_24227);

(statearr_24490_24587[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (5))){
var _ = (function (){var statearr_24491 = state_24407;
(statearr_24491[(4)] = cljs.core.rest.call(null,(state_24407[(4)])));

return statearr_24491;
})();
var state_24407__$1 = state_24407;
var ex24488 = (state_24407__$1[(2)]);
var statearr_24492_24588 = state_24407__$1;
(statearr_24492_24588[(5)] = ex24488);


if((ex24488 instanceof Error)){
var statearr_24493_24589 = state_24407__$1;
(statearr_24493_24589[(1)] = (4));

(statearr_24493_24589[(5)] = null);

} else {
throw ex24488;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (14))){
var inst_24211 = (state_24407[(27)]);
var inst_24242 = fluree.db.dbproto._subid.call(null,db,inst_24211);
var state_24407__$1 = state_24407;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24407__$1,(17),inst_24242);
} else {
if((state_val_24408 === (45))){
var inst_24291 = (state_24407[(2)]);
var state_24407__$1 = state_24407;
var statearr_24494_24590 = state_24407__$1;
(statearr_24494_24590[(2)] = inst_24291);

(statearr_24494_24590[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (53))){
var inst_24324 = (state_24407[(2)]);
var inst_24325 = fluree.db.util.async.throw_err.call(null,inst_24324);
var inst_24326 = inst_24325;
var inst_24327 = (0);
var inst_24328 = null;
var state_24407__$1 = (function (){var statearr_24495 = state_24407;
(statearr_24495[(12)] = inst_24327);

(statearr_24495[(8)] = inst_24328);

(statearr_24495[(13)] = inst_24326);

return statearr_24495;
})();
var statearr_24496_24591 = state_24407__$1;
(statearr_24496_24591[(2)] = null);

(statearr_24496_24591[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (26))){
var inst_24210 = (state_24407[(16)]);
var state_24407__$1 = state_24407;
var statearr_24497_24592 = state_24407__$1;
(statearr_24497_24592[(2)] = inst_24210);

(statearr_24497_24592[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (16))){
var inst_24218 = (state_24407[(51)]);
var inst_24248 = (state_24407[(2)]);
var inst_24249 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24218);
var state_24407__$1 = (function (){var statearr_24498 = state_24407;
(statearr_24498[(37)] = inst_24248);

return statearr_24498;
})();
if(inst_24249){
var statearr_24499_24593 = state_24407__$1;
(statearr_24499_24593[(1)] = (18));

} else {
var statearr_24500_24594 = state_24407__$1;
(statearr_24500_24594[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (38))){
var state_24407__$1 = state_24407;
var statearr_24501_24595 = state_24407__$1;
(statearr_24501_24595[(2)] = (2147483647));

(statearr_24501_24595[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (30))){
var inst_24271 = (state_24407[(2)]);
var state_24407__$1 = state_24407;
if(cljs.core.truth_(inst_24271)){
var statearr_24502_24596 = state_24407__$1;
(statearr_24502_24596[(1)] = (31));

} else {
var statearr_24503_24597 = state_24407__$1;
(statearr_24503_24597[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (73))){
var inst_24400 = (state_24407[(2)]);
var state_24407__$1 = state_24407;
var statearr_24504_24598 = state_24407__$1;
(statearr_24504_24598[(2)] = inst_24400);

(statearr_24504_24598[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (10))){
var inst_24216 = (state_24407[(46)]);
var inst_24233 = fluree.db.dbproto._subid.call(null,db,inst_24216);
var state_24407__$1 = state_24407;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24407__$1,(13),inst_24233);
} else {
if((state_val_24408 === (18))){
var inst_24218 = (state_24407[(51)]);
var inst_24251 = fluree.db.dbproto._subid.call(null,db,inst_24218);
var state_24407__$1 = state_24407;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24407__$1,(21),inst_24251);
} else {
if((state_val_24408 === (52))){
var inst_24294 = (state_24407[(33)]);
var inst_24321 = (state_24407[(18)]);
var inst_24320 = (state_24407[(2)]);
var inst_24321__$1 = fluree.db.util.async.throw_err.call(null,inst_24320);
var inst_24322 = fluree.db.dbproto._lookup_leaf.call(null,inst_24321__$1,inst_24294);
var state_24407__$1 = (function (){var statearr_24505 = state_24407;
(statearr_24505[(18)] = inst_24321__$1);

return statearr_24505;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24407__$1,(53),inst_24322);
} else {
if((state_val_24408 === (67))){
var inst_24377 = (state_24407[(2)]);
var state_24407__$1 = state_24407;
var statearr_24506_24599 = state_24407__$1;
(statearr_24506_24599[(2)] = inst_24377);

(statearr_24506_24599[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (71))){
var inst_24381 = (state_24407[(9)]);
var state_24407__$1 = state_24407;
var statearr_24507_24600 = state_24407__$1;
(statearr_24507_24600[(2)] = inst_24381);

(statearr_24507_24600[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (42))){
var inst_24275 = (state_24407[(36)]);
var inst_24248 = (state_24407[(37)]);
var inst_24220 = (state_24407[(47)]);
var inst_24266 = (state_24407[(22)]);
var inst_24284 = (state_24407[(38)]);
var inst_24212 = (state_24407[(48)]);
var inst_24219 = (state_24407[(49)]);
var inst_24296 = (state_24407[(23)]);
var inst_24239 = (state_24407[(43)]);
var inst_24293 = (state_24407[(53)]);
var inst_24257 = (state_24407[(17)]);
var inst_24213 = (state_24407[(50)]);
var inst_24230 = (state_24407[(54)]);
var inst_24293__$1 = (state_24407[(2)]);
var inst_24294 = fluree.db.flake.__GT_Flake.call(null,inst_24230,inst_24266,inst_24248,inst_24212,inst_24213,inst_24284);
var inst_24295 = fluree.db.flake.__GT_Flake.call(null,inst_24239,inst_24275,inst_24257,inst_24219,inst_24220,inst_24293__$1);
var inst_24296__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_24407__$1 = (function (){var statearr_24508 = state_24407;
(statearr_24508[(23)] = inst_24296__$1);

(statearr_24508[(32)] = inst_24295);

(statearr_24508[(53)] = inst_24293__$1);

(statearr_24508[(33)] = inst_24294);

return statearr_24508;
})();
if(cljs.core.truth_(inst_24296__$1)){
var statearr_24509_24601 = state_24407__$1;
(statearr_24509_24601[(1)] = (46));

} else {
var statearr_24510_24602 = state_24407__$1;
(statearr_24510_24602[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (37))){
var state_24407__$1 = state_24407;
var statearr_24511_24603 = state_24407__$1;
(statearr_24511_24603[(2)] = fluree.db.util.core.min_integer);

(statearr_24511_24603[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (63))){
var inst_24300 = (state_24407[(20)]);
var inst_24358 = (state_24407[(41)]);
var inst_24359 = (state_24407[(42)]);
var inst_24365 = cljs.core.seq.call(null,inst_24358);
var inst_24366 = cljs.core.first.call(null,inst_24365);
var inst_24367 = cljs.core.next.call(null,inst_24365);
var inst_24368 = (inst_24366 == null);
var inst_24369 = (inst_24359 > inst_24300);
var inst_24370 = ((inst_24368) || (inst_24369));
var state_24407__$1 = (function (){var statearr_24512 = state_24407;
(statearr_24512[(52)] = inst_24367);

return statearr_24512;
})();
if(cljs.core.truth_(inst_24370)){
var statearr_24513_24604 = state_24407__$1;
(statearr_24513_24604[(1)] = (65));

} else {
var statearr_24514_24605 = state_24407__$1;
(statearr_24514_24605[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (8))){
var inst_24216 = (state_24407[(46)]);
var inst_24230 = (state_24407[(2)]);
var inst_24231 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24216);
var state_24407__$1 = (function (){var statearr_24515 = state_24407;
(statearr_24515[(54)] = inst_24230);

return statearr_24515;
})();
if(inst_24231){
var statearr_24516_24606 = state_24407__$1;
(statearr_24516_24606[(1)] = (10));

} else {
var statearr_24517_24607 = state_24407__$1;
(statearr_24517_24607[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24408 === (49))){
var inst_24306 = (state_24407[(28)]);
var state_24407__$1 = state_24407;
var statearr_24518_24608 = state_24407__$1;
(statearr_24518_24608[(2)] = inst_24306);

(statearr_24518_24608[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__11469__auto__ = null;
var fluree$db$query$range$state_machine__11469__auto____0 = (function (){
var statearr_24519 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24519[(0)] = fluree$db$query$range$state_machine__11469__auto__);

(statearr_24519[(1)] = (1));

return statearr_24519;
});
var fluree$db$query$range$state_machine__11469__auto____1 = (function (state_24407){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_24407);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e24520){var ex__11472__auto__ = e24520;
var statearr_24521_24609 = state_24407;
(statearr_24521_24609[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_24407[(4)]))){
var statearr_24522_24610 = state_24407;
(statearr_24522_24610[(1)] = cljs.core.first.call(null,(state_24407[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24611 = state_24407;
state_24407 = G__24611;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__11469__auto__ = function(state_24407){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__11469__auto____1.call(this,state_24407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__11469__auto____0;
fluree$db$query$range$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__11469__auto____1;
return fluree$db$query$range$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_24523 = f__11543__auto__.call(null);
(statearr_24523[(6)] = c__11542__auto__);

return statearr_24523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_24661){
var state_val_24662 = (state_24661[(1)]);
if((state_val_24662 === (7))){
var state_24661__$1 = state_24661;
var statearr_24663_24682 = state_24661__$1;
(statearr_24663_24682[(2)] = (0));

(statearr_24663_24682[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24662 === (1))){
var inst_24619 = subject_groups;
var inst_24620 = cljs.core.seq.call(null,inst_24619);
var inst_24621 = cljs.core.first.call(null,inst_24620);
var inst_24622 = cljs.core.next.call(null,inst_24620);
var inst_24623 = flake_start;
var inst_24624 = subject_start;
var inst_24625 = cljs.core.PersistentVector.EMPTY;
var inst_24626 = inst_24619;
var inst_24627 = inst_24623;
var inst_24628 = inst_24624;
var inst_24629 = inst_24625;
var state_24661__$1 = (function (){var statearr_24664 = state_24661;
(statearr_24664[(7)] = inst_24628);

(statearr_24664[(8)] = inst_24627);

(statearr_24664[(9)] = inst_24626);

(statearr_24664[(10)] = inst_24629);

(statearr_24664[(11)] = inst_24621);

(statearr_24664[(12)] = inst_24622);

return statearr_24664;
})();
var statearr_24665_24683 = state_24661__$1;
(statearr_24665_24683[(2)] = null);

(statearr_24665_24683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24662 === (4))){
var inst_24628 = (state_24661[(7)]);
var inst_24627 = (state_24661[(8)]);
var inst_24629 = (state_24661[(10)]);
var inst_24642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24643 = [inst_24627,inst_24628,inst_24629];
var inst_24644 = (new cljs.core.PersistentVector(null,3,(5),inst_24642,inst_24643,null));
var state_24661__$1 = state_24661;
var statearr_24666_24684 = state_24661__$1;
(statearr_24666_24684[(2)] = inst_24644);

(statearr_24666_24684[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24662 === (6))){
var inst_24657 = (state_24661[(2)]);
var state_24661__$1 = state_24661;
var statearr_24667_24685 = state_24661__$1;
(statearr_24667_24685[(2)] = inst_24657);

(statearr_24667_24685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24662 === (3))){
var inst_24659 = (state_24661[(2)]);
var state_24661__$1 = state_24661;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24661__$1,inst_24659);
} else {
if((state_val_24662 === (2))){
var inst_24628 = (state_24661[(7)]);
var inst_24627 = (state_24661[(8)]);
var inst_24626 = (state_24661[(9)]);
var inst_24635 = (state_24661[(13)]);
var inst_24634 = cljs.core.seq.call(null,inst_24626);
var inst_24635__$1 = cljs.core.first.call(null,inst_24634);
var inst_24636 = cljs.core.next.call(null,inst_24634);
var inst_24637 = (inst_24635__$1 == null);
var inst_24638 = (inst_24627 >= flake_limit);
var inst_24639 = (inst_24628 >= subject_limit);
var inst_24640 = ((inst_24637) || (inst_24638) || (inst_24639));
var state_24661__$1 = (function (){var statearr_24668 = state_24661;
(statearr_24668[(14)] = inst_24636);

(statearr_24668[(13)] = inst_24635__$1);

return statearr_24668;
})();
if(cljs.core.truth_(inst_24640)){
var statearr_24669_24686 = state_24661__$1;
(statearr_24669_24686[(1)] = (4));

} else {
var statearr_24670_24687 = state_24661__$1;
(statearr_24670_24687[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24662 === (9))){
var inst_24628 = (state_24661[(7)]);
var inst_24627 = (state_24661[(8)]);
var inst_24636 = (state_24661[(14)]);
var inst_24646 = (state_24661[(15)]);
var inst_24629 = (state_24661[(10)]);
var inst_24635 = (state_24661[(13)]);
var inst_24651 = (state_24661[(2)]);
var inst_24652 = (inst_24627 + inst_24646);
var inst_24653 = (inst_24628 + inst_24651);
var inst_24654 = cljs.core.into.call(null,inst_24629,inst_24635);
var inst_24626 = inst_24636;
var inst_24627__$1 = inst_24652;
var inst_24628__$1 = inst_24653;
var inst_24629__$1 = inst_24654;
var state_24661__$1 = (function (){var statearr_24671 = state_24661;
(statearr_24671[(7)] = inst_24628__$1);

(statearr_24671[(8)] = inst_24627__$1);

(statearr_24671[(9)] = inst_24626);

(statearr_24671[(10)] = inst_24629__$1);

return statearr_24671;
})();
var statearr_24672_24688 = state_24661__$1;
(statearr_24672_24688[(2)] = null);

(statearr_24672_24688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24662 === (5))){
var inst_24646 = (state_24661[(15)]);
var inst_24635 = (state_24661[(13)]);
var inst_24646__$1 = cljs.core.count.call(null,inst_24635);
var inst_24647 = cljs.core._EQ_.call(null,(0),inst_24646__$1);
var state_24661__$1 = (function (){var statearr_24673 = state_24661;
(statearr_24673[(15)] = inst_24646__$1);

return statearr_24673;
})();
if(inst_24647){
var statearr_24674_24689 = state_24661__$1;
(statearr_24674_24689[(1)] = (7));

} else {
var statearr_24675_24690 = state_24661__$1;
(statearr_24675_24690[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24662 === (8))){
var state_24661__$1 = state_24661;
var statearr_24676_24691 = state_24661__$1;
(statearr_24676_24691[(2)] = (1));

(statearr_24676_24691[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11469__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11469__auto____0 = (function (){
var statearr_24677 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24677[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11469__auto__);

(statearr_24677[(1)] = (1));

return statearr_24677;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11469__auto____1 = (function (state_24661){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_24661);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e24678){var ex__11472__auto__ = e24678;
var statearr_24679_24692 = state_24661;
(statearr_24679_24692[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_24661[(4)]))){
var statearr_24680_24693 = state_24661;
(statearr_24680_24693[(1)] = cljs.core.first.call(null,(state_24661[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24694 = state_24661;
state_24661 = G__24694;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11469__auto__ = function(state_24661){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11469__auto____1.call(this,state_24661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11469__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11469__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_24681 = f__11543__auto__.call(null);
(statearr_24681[(6)] = c__11542__auto__);

return statearr_24681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_24740){
var state_val_24741 = (state_24740[(1)]);
if((state_val_24741 === (7))){
var state_24740__$1 = state_24740;
var statearr_24742_24780 = state_24740__$1;
(statearr_24742_24780[(2)] = null);

(statearr_24742_24780[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (20))){
var inst_24726 = (state_24740[(2)]);
var inst_24727 = fluree.db.util.async.throw_err.call(null,inst_24726);
var inst_24705 = inst_24727;
var state_24740__$1 = (function (){var statearr_24743 = state_24740;
(statearr_24743[(7)] = inst_24705);

return statearr_24743;
})();
var statearr_24744_24781 = state_24740__$1;
(statearr_24744_24781[(2)] = null);

(statearr_24744_24781[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (1))){
var state_24740__$1 = state_24740;
var statearr_24745_24782 = state_24740__$1;
(statearr_24745_24782[(2)] = null);

(statearr_24745_24782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (4))){
var inst_24695 = (state_24740[(2)]);
var state_24740__$1 = state_24740;
var statearr_24746_24783 = state_24740__$1;
(statearr_24746_24783[(2)] = inst_24695);

(statearr_24746_24783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (15))){
var inst_24722 = (state_24740[(8)]);
var inst_24705 = (state_24740[(7)]);
var inst_24722__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_24705);
var state_24740__$1 = (function (){var statearr_24747 = state_24740;
(statearr_24747[(8)] = inst_24722__$1);

return statearr_24747;
})();
if(cljs.core.truth_(inst_24722__$1)){
var statearr_24748_24784 = state_24740__$1;
(statearr_24748_24784[(1)] = (17));

} else {
var statearr_24749_24785 = state_24740__$1;
(statearr_24749_24785[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (13))){
var inst_24715 = (state_24740[(2)]);
var inst_24716 = fluree.db.util.async.throw_err.call(null,inst_24715);
var _ = (function (){var statearr_24750 = state_24740;
(statearr_24750[(4)] = cljs.core.rest.call(null,(state_24740[(4)])));

return statearr_24750;
})();
var state_24740__$1 = state_24740;
var statearr_24751_24786 = state_24740__$1;
(statearr_24751_24786[(2)] = inst_24716);

(statearr_24751_24786[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (6))){
var inst_24703 = (state_24740[(2)]);
var inst_24704 = fluree.db.util.async.throw_err.call(null,inst_24703);
var inst_24705 = inst_24704;
var state_24740__$1 = (function (){var statearr_24752 = state_24740;
(statearr_24752[(7)] = inst_24705);

return statearr_24752;
})();
var statearr_24753_24787 = state_24740__$1;
(statearr_24753_24787[(2)] = null);

(statearr_24753_24787[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (17))){
var inst_24722 = (state_24740[(8)]);
var inst_24724 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_24722);
var state_24740__$1 = state_24740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24740__$1,(20),inst_24724);
} else {
if((state_val_24741 === (3))){
var inst_24738 = (state_24740[(2)]);
var state_24740__$1 = state_24740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24740__$1,inst_24738);
} else {
if((state_val_24741 === (12))){
var _ = (function (){var statearr_24755 = state_24740;
(statearr_24755[(4)] = cljs.core.rest.call(null,(state_24740[(4)])));

return statearr_24755;
})();
var state_24740__$1 = state_24740;
var ex24754 = (state_24740__$1[(2)]);
var statearr_24756_24788 = state_24740__$1;
(statearr_24756_24788[(5)] = ex24754);


var statearr_24757_24789 = state_24740__$1;
(statearr_24757_24789[(1)] = (11));

(statearr_24757_24789[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (2))){
var _ = (function (){var statearr_24758 = state_24740;
(statearr_24758[(4)] = cljs.core.cons.call(null,(5),(state_24740[(4)])));

return statearr_24758;
})();
var inst_24701 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_24740__$1 = state_24740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24740__$1,(6),inst_24701);
} else {
if((state_val_24741 === (19))){
var inst_24731 = (state_24740[(2)]);
var state_24740__$1 = state_24740;
var statearr_24759_24790 = state_24740__$1;
(statearr_24759_24790[(2)] = inst_24731);

(statearr_24759_24790[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (11))){
var inst_24707 = (state_24740[(2)]);
var state_24740__$1 = (function (){var statearr_24761 = state_24740;
(statearr_24761[(9)] = inst_24707);

return statearr_24761;
})();
var statearr_24762_24791 = state_24740__$1;
(statearr_24762_24791[(2)] = null);

(statearr_24762_24791[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (9))){
var inst_24705 = (state_24740[(7)]);
var _ = (function (){var statearr_24763 = state_24740;
(statearr_24763[(4)] = cljs.core.cons.call(null,(12),(state_24740[(4)])));

return statearr_24763;
})();
var inst_24713 = fluree.db.dbproto._resolve_to_t.call(null,inst_24705,t,novelty,fast_forward_db_QMARK_);
var state_24740__$1 = state_24740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24740__$1,(13),inst_24713);
} else {
if((state_val_24741 === (5))){
var _ = (function (){var statearr_24764 = state_24740;
(statearr_24764[(4)] = cljs.core.rest.call(null,(state_24740[(4)])));

return statearr_24764;
})();
var state_24740__$1 = state_24740;
var ex24760 = (state_24740__$1[(2)]);
var statearr_24765_24792 = state_24740__$1;
(statearr_24765_24792[(5)] = ex24760);


if((ex24760 instanceof Error)){
var statearr_24766_24793 = state_24740__$1;
(statearr_24766_24793[(1)] = (4));

(statearr_24766_24793[(5)] = null);

} else {
throw ex24760;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (14))){
var inst_24719 = (state_24740[(10)]);
var state_24740__$1 = state_24740;
var statearr_24767_24794 = state_24740__$1;
(statearr_24767_24794[(2)] = inst_24719);

(statearr_24767_24794[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (16))){
var inst_24733 = (state_24740[(2)]);
var state_24740__$1 = state_24740;
var statearr_24768_24795 = state_24740__$1;
(statearr_24768_24795[(2)] = inst_24733);

(statearr_24768_24795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (10))){
var inst_24719 = (state_24740[(10)]);
var inst_24719__$1 = (state_24740[(2)]);
var state_24740__$1 = (function (){var statearr_24769 = state_24740;
(statearr_24769[(10)] = inst_24719__$1);

return statearr_24769;
})();
if(cljs.core.truth_(inst_24719__$1)){
var statearr_24770_24796 = state_24740__$1;
(statearr_24770_24796[(1)] = (14));

} else {
var statearr_24771_24797 = state_24740__$1;
(statearr_24771_24797[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (18))){
var state_24740__$1 = state_24740;
var statearr_24772_24798 = state_24740__$1;
(statearr_24772_24798[(2)] = null);

(statearr_24772_24798[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24741 === (8))){
var inst_24735 = (state_24740[(2)]);
var _ = (function (){var statearr_24773 = state_24740;
(statearr_24773[(4)] = cljs.core.rest.call(null,(state_24740[(4)])));

return statearr_24773;
})();
var state_24740__$1 = state_24740;
var statearr_24774_24799 = state_24740__$1;
(statearr_24774_24799[(2)] = inst_24735);

(statearr_24774_24799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__11469__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__11469__auto____0 = (function (){
var statearr_24775 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24775[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__11469__auto__);

(statearr_24775[(1)] = (1));

return statearr_24775;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__11469__auto____1 = (function (state_24740){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_24740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e24776){var ex__11472__auto__ = e24776;
var statearr_24777_24800 = state_24740;
(statearr_24777_24800[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_24740[(4)]))){
var statearr_24778_24801 = state_24740;
(statearr_24778_24801[(1)] = cljs.core.first.call(null,(state_24740[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24802 = state_24740;
state_24740 = G__24802;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__11469__auto__ = function(state_24740){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__11469__auto____1.call(this,state_24740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__11469__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__11469__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_24779 = f__11543__auto__.call(null);
(statearr_24779[(6)] = c__11542__auto__);

return statearr_24779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__24809 = arguments.length;
switch (G__24809) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__24810 = (function (){var pred__24813 = cljs.core.identical_QMARK_;
var expr__24814 = test;
if(cljs.core.truth_(pred__24813.call(null,cljs.core._EQ_,expr__24814))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__24813.call(null,cljs.core._LT_,expr__24814))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__24813.call(null,cljs.core._LT__EQ_,expr__24814))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__24813.call(null,cljs.core._GT_,expr__24814))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__24813.call(null,cljs.core._GT__EQ_,expr__24814))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__24814)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__24810,(0),null);
var start_match = cljs.core.nth.call(null,vec__24810,(1),null);
var end_test = cljs.core.nth.call(null,vec__24810,(2),null);
var end_match = cljs.core.nth.call(null,vec__24810,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_25212){
var state_val_25213 = (state_25212[(1)]);
if((state_val_25213 === (121))){
var inst_25073 = (state_25212[(7)]);
var state_25212__$1 = state_25212;
var statearr_25214_25417 = state_25212__$1;
(statearr_25214_25417[(2)] = inst_25073);

(statearr_25214_25417[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (65))){
var state_25212__$1 = state_25212;
var statearr_25215_25418 = state_25212__$1;
(statearr_25215_25418[(2)] = fluree.db.util.core.min_integer);

(statearr_25215_25418[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (70))){
var state_25212__$1 = state_25212;
var statearr_25216_25419 = state_25212__$1;
(statearr_25216_25419[(2)] = true);

(statearr_25216_25419[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (62))){
var inst_24975 = (cljs.core._LT__EQ_ === end_test);
var state_25212__$1 = state_25212;
if(cljs.core.truth_(inst_24975)){
var statearr_25217_25420 = state_25212__$1;
(statearr_25217_25420[(1)] = (64));

} else {
var statearr_25218_25421 = state_25212__$1;
(statearr_25218_25421[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (74))){
var inst_24984 = (state_25212[(8)]);
var state_25212__$1 = state_25212;
var statearr_25219_25422 = state_25212__$1;
(statearr_25219_25422[(2)] = inst_24984);

(statearr_25219_25422[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (110))){
var inst_25114 = (state_25212[(9)]);
var inst_25116 = (state_25212[(10)]);
var inst_25106 = (state_25212[(11)]);
var inst_25115 = (state_25212[(12)]);
var inst_25012 = (state_25212[(13)]);
var inst_25039 = (state_25212[(14)]);
var inst_25114__$1 = cljs.core.count.call(null,inst_25106);
var inst_25115__$1 = (inst_25039 + inst_25114__$1);
var inst_25116__$1 = (inst_25115__$1 - inst_25012);
var inst_25117 = cljs.core.pos_int_QMARK_.call(null,inst_25116__$1);
var state_25212__$1 = (function (){var statearr_25220 = state_25212;
(statearr_25220[(9)] = inst_25114__$1);

(statearr_25220[(10)] = inst_25116__$1);

(statearr_25220[(12)] = inst_25115__$1);

return statearr_25220;
})();
if(inst_25117){
var statearr_25221_25423 = state_25212__$1;
(statearr_25221_25423[(1)] = (113));

} else {
var statearr_25222_25424 = state_25212__$1;
(statearr_25222_25424[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (130))){
var inst_25175 = (state_25212[(15)]);
var state_25212__$1 = state_25212;
var statearr_25223_25425 = state_25212__$1;
(statearr_25223_25425[(2)] = inst_25175);

(statearr_25223_25425[(1)] = (132));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (128))){
var inst_25184 = (state_25212[(16)]);
var state_25212__$1 = state_25212;
var statearr_25224_25426 = state_25212__$1;
(statearr_25224_25426[(2)] = inst_25184);

(statearr_25224_25426[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (7))){
var state_25212__$1 = state_25212;
var statearr_25225_25427 = state_25212__$1;
(statearr_25225_25427[(2)] = false);

(statearr_25225_25427[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (59))){
var state_25212__$1 = state_25212;
var statearr_25226_25428 = state_25212__$1;
(statearr_25226_25428[(2)] = (2147483647));

(statearr_25226_25428[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (86))){
var inst_25006 = (state_25212[(17)]);
var inst_25018 = (state_25212[(18)]);
var inst_25013 = (state_25212[(19)]);
var inst_25019 = (state_25212[(20)]);
var inst_24923 = (state_25212[(21)]);
var inst_24872 = (state_25212[(22)]);
var inst_24981 = (state_25212[(23)]);
var inst_24936 = (state_25212[(24)]);
var inst_24873 = (state_25212[(25)]);
var inst_24963 = (state_25212[(26)]);
var inst_24982 = (state_25212[(27)]);
var inst_25024 = (state_25212[(28)]);
var inst_25023 = (state_25212[(29)]);
var inst_24840 = (state_25212[(30)]);
var inst_25037 = (state_25212[(31)]);
var inst_25014 = (state_25212[(32)]);
var inst_25040 = (state_25212[(33)]);
var inst_24892 = (state_25212[(34)]);
var inst_25029 = (state_25212[(35)]);
var inst_24847 = (state_25212[(36)]);
var inst_24883 = (state_25212[(37)]);
var inst_24836 = (state_25212[(38)]);
var inst_25046 = (state_25212[(39)]);
var inst_24871 = (state_25212[(40)]);
var inst_24972 = (state_25212[(41)]);
var inst_25036 = (state_25212[(42)]);
var inst_24954 = (state_25212[(43)]);
var inst_24841 = (state_25212[(44)]);
var inst_24924 = (state_25212[(45)]);
var inst_24983 = (state_25212[(46)]);
var inst_25012 = (state_25212[(13)]);
var inst_24843 = (state_25212[(47)]);
var inst_24848 = (state_25212[(48)]);
var inst_25033 = (state_25212[(49)]);
var inst_24945 = (state_25212[(50)]);
var inst_24927 = (state_25212[(51)]);
var inst_25039 = (state_25212[(14)]);
var inst_25038 = (state_25212[(52)]);
var inst_25005 = (state_25212[(53)]);
var inst_25050 = (function (){var no_filter_QMARK_ = true;
var t = inst_25019;
var max_limit_QMARK_ = inst_25013;
var next_node = inst_25036;
var fast_forward_db_QMARK_ = inst_25024;
var s1 = inst_24883;
var o2 = inst_24945;
var t1 = inst_24840;
var predicate_fn = inst_24873;
var i = inst_25038;
var m1 = inst_24972;
var root_node = inst_25029;
var s2 = inst_24892;
var p2 = inst_24963;
var permissions = inst_25014;
var vec__24829 = inst_24923;
var map__24828 = inst_24871;
var vec__24825 = inst_24843;
var limit = inst_25012;
var start_flake = inst_24982;
var flake_limit = inst_25006;
var offset = inst_25037;
var acc = inst_25040;
var t2 = inst_24847;
var op1 = inst_24841;
var o1 = inst_24936;
var end_flake = inst_24983;
var base_result = inst_25046;
var s = inst_25039;
var node_start = inst_25033;
var p1 = inst_24954;
var subject_fn = inst_24872;
var object_fn = inst_24927;
var idx_compare = inst_25018;
var map__24835 = inst_25005;
var G__25047 = inst_25046;
var op2 = inst_24848;
var m2 = inst_24981;
var vec__24832 = inst_24924;
var vec__24822 = inst_24836;
var novelty = inst_25023;
return (function (p1__24803_SHARP_){
return cljs.core._EQ_.call(null,p1__24803_SHARP_.o,start_flake.o);
});
})();
var inst_25051 = cljs.core.filter.call(null,inst_25050,inst_25046);
var state_25212__$1 = state_25212;
var statearr_25227_25429 = state_25212__$1;
(statearr_25227_25429[(2)] = inst_25051);

(statearr_25227_25429[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (20))){
var inst_24844 = (state_25212[(54)]);
var state_25212__$1 = state_25212;
var statearr_25228_25430 = state_25212__$1;
(statearr_25228_25430[(2)] = inst_24844);

(statearr_25228_25430[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (72))){
var inst_24997 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
var statearr_25229_25431 = state_25212__$1;
(statearr_25229_25431[(2)] = inst_24997);

(statearr_25229_25431[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (58))){
var state_25212__$1 = state_25212;
var statearr_25230_25432 = state_25212__$1;
(statearr_25230_25432[(2)] = fluree.db.util.core.min_integer);

(statearr_25230_25432[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (60))){
var inst_24970 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
var statearr_25231_25433 = state_25212__$1;
(statearr_25231_25433[(2)] = inst_24970);

(statearr_25231_25433[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (27))){
var state_25212__$1 = state_25212;
var statearr_25232_25434 = state_25212__$1;
(statearr_25232_25434[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (1))){
var state_25212__$1 = state_25212;
var statearr_25234_25435 = state_25212__$1;
(statearr_25234_25435[(2)] = null);

(statearr_25234_25435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (69))){
var inst_25000 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
if(cljs.core.truth_(inst_25000)){
var statearr_25235_25436 = state_25212__$1;
(statearr_25235_25436[(1)] = (73));

} else {
var statearr_25236_25437 = state_25212__$1;
(statearr_25236_25437[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (101))){
var state_25212__$1 = state_25212;
var statearr_25237_25438 = state_25212__$1;
(statearr_25237_25438[(2)] = true);

(statearr_25237_25438[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (24))){
var inst_24846 = (state_25212[(55)]);
var inst_24896 = cljs.core.boolean_QMARK_.call(null,inst_24846);
var state_25212__$1 = state_25212;
if(inst_24896){
var statearr_25238_25439 = state_25212__$1;
(statearr_25238_25439[(1)] = (26));

} else {
var statearr_25239_25440 = state_25212__$1;
(statearr_25239_25440[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (102))){
var state_25212__$1 = state_25212;
var statearr_25240_25441 = state_25212__$1;
(statearr_25240_25441[(2)] = false);

(statearr_25240_25441[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (55))){
var inst_24842 = (state_25212[(56)]);
var state_25212__$1 = state_25212;
var statearr_25241_25442 = state_25212__$1;
(statearr_25241_25442[(2)] = inst_24842);

(statearr_25241_25442[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (85))){
var inst_25204 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
var statearr_25242_25443 = state_25212__$1;
(statearr_25242_25443[(2)] = inst_25204);

(statearr_25242_25443[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (39))){
var inst_24926 = (state_25212[(57)]);
var inst_24939 = fluree.db.dbproto._subid.call(null,db,inst_24926);
var state_25212__$1 = state_25212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25212__$1,(42),inst_24939);
} else {
if((state_val_25213 === (88))){
var inst_24872 = (state_25212[(22)]);
var inst_25054 = (state_25212[(2)]);
var state_25212__$1 = (function (){var statearr_25243 = state_25212;
(statearr_25243[(58)] = inst_25054);

return statearr_25243;
})();
if(cljs.core.truth_(inst_24872)){
var statearr_25244_25444 = state_25212__$1;
(statearr_25244_25444[(1)] = (89));

} else {
var statearr_25245_25445 = state_25212__$1;
(statearr_25245_25445[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (46))){
var state_25212__$1 = state_25212;
var statearr_25246_25446 = state_25212__$1;
(statearr_25246_25446[(2)] = (-1));

(statearr_25246_25446[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (4))){
var inst_24816 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
var statearr_25247_25447 = state_25212__$1;
(statearr_25247_25447[(2)] = inst_24816);

(statearr_25247_25447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (77))){
var state_25212__$1 = state_25212;
var statearr_25248_25448 = state_25212__$1;
(statearr_25248_25448[(2)] = fluree.db.util.core.max_long);

(statearr_25248_25448[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (106))){
var inst_25073 = (state_25212[(7)]);
var inst_25171 = (state_25212[(2)]);
var inst_25172 = cljs.core.nth.call(null,inst_25171,(0),null);
var inst_25173 = cljs.core.nth.call(null,inst_25171,(1),null);
var inst_25174 = cljs.core.nth.call(null,inst_25171,(2),null);
var inst_25175 = cljs.core.nth.call(null,inst_25171,(3),null);
var state_25212__$1 = (function (){var statearr_25249 = state_25212;
(statearr_25249[(59)] = inst_25173);

(statearr_25249[(15)] = inst_25175);

(statearr_25249[(60)] = inst_25172);

(statearr_25249[(61)] = inst_25174);

return statearr_25249;
})();
if(cljs.core.truth_(inst_25073)){
var statearr_25250_25449 = state_25212__$1;
(statearr_25250_25449[(1)] = (120));

} else {
var statearr_25251_25450 = state_25212__$1;
(statearr_25251_25450[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (119))){
var inst_25157 = (state_25212[(2)]);
var inst_25158 = fluree.db.util.async.throw_err.call(null,inst_25157);
var state_25212__$1 = state_25212;
var statearr_25252_25451 = state_25212__$1;
(statearr_25252_25451[(2)] = inst_25158);

(statearr_25252_25451[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (95))){
var inst_25006 = (state_25212[(17)]);
var inst_25018 = (state_25212[(18)]);
var inst_25013 = (state_25212[(19)]);
var inst_25019 = (state_25212[(20)]);
var inst_24923 = (state_25212[(21)]);
var inst_24872 = (state_25212[(22)]);
var inst_24981 = (state_25212[(23)]);
var inst_24936 = (state_25212[(24)]);
var inst_24873 = (state_25212[(25)]);
var inst_24963 = (state_25212[(26)]);
var inst_24982 = (state_25212[(27)]);
var inst_25024 = (state_25212[(28)]);
var inst_25023 = (state_25212[(29)]);
var inst_24840 = (state_25212[(30)]);
var inst_25037 = (state_25212[(31)]);
var inst_25014 = (state_25212[(32)]);
var inst_25040 = (state_25212[(33)]);
var inst_24892 = (state_25212[(34)]);
var inst_25066 = (state_25212[(62)]);
var inst_25029 = (state_25212[(35)]);
var inst_24847 = (state_25212[(36)]);
var inst_24883 = (state_25212[(37)]);
var inst_24836 = (state_25212[(38)]);
var inst_25046 = (state_25212[(39)]);
var inst_24871 = (state_25212[(40)]);
var inst_24972 = (state_25212[(41)]);
var inst_25036 = (state_25212[(42)]);
var inst_24954 = (state_25212[(43)]);
var inst_24841 = (state_25212[(44)]);
var inst_24924 = (state_25212[(45)]);
var inst_24983 = (state_25212[(46)]);
var inst_25012 = (state_25212[(13)]);
var inst_24843 = (state_25212[(47)]);
var inst_24848 = (state_25212[(48)]);
var inst_25033 = (state_25212[(49)]);
var inst_24945 = (state_25212[(50)]);
var inst_24927 = (state_25212[(51)]);
var inst_25039 = (state_25212[(14)]);
var inst_25038 = (state_25212[(52)]);
var inst_25005 = (state_25212[(53)]);
var inst_25068 = (function (){var no_filter_QMARK_ = true;
var t = inst_25019;
var max_limit_QMARK_ = inst_25013;
var next_node = inst_25036;
var fast_forward_db_QMARK_ = inst_25024;
var s1 = inst_24883;
var o2 = inst_24945;
var t1 = inst_24840;
var predicate_fn = inst_24873;
var i = inst_25038;
var m1 = inst_24972;
var root_node = inst_25029;
var s2 = inst_24892;
var p2 = inst_24963;
var permissions = inst_25014;
var vec__24829 = inst_24923;
var map__24828 = inst_24871;
var vec__24825 = inst_24843;
var limit = inst_25012;
var start_flake = inst_24982;
var flake_limit = inst_25006;
var offset = inst_25037;
var acc = inst_25040;
var t2 = inst_24847;
var op1 = inst_24841;
var o1 = inst_24936;
var end_flake = inst_24983;
var base_result = inst_25046;
var s = inst_25039;
var node_start = inst_25033;
var p1 = inst_24954;
var subject_fn = inst_24872;
var object_fn = inst_24927;
var idx_compare = inst_25018;
var map__24835 = inst_25005;
var G__25047 = inst_25066;
var op2 = inst_24848;
var m2 = inst_24981;
var vec__24832 = inst_24924;
var vec__24822 = inst_24836;
var novelty = inst_25023;
return (function (p1__24806_SHARP_){
return object_fn.call(null,p1__24806_SHARP_.o);
});
})();
var inst_25069 = cljs.core.filter.call(null,inst_25068,inst_25066);
var state_25212__$1 = state_25212;
var statearr_25253_25452 = state_25212__$1;
(statearr_25253_25452[(2)] = inst_25069);

(statearr_25253_25452[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (54))){
var inst_24842 = (state_25212[(56)]);
var inst_24963 = (state_25212[(2)]);
var state_25212__$1 = (function (){var statearr_25254 = state_25212;
(statearr_25254[(26)] = inst_24963);

return statearr_25254;
})();
if(cljs.core.truth_(inst_24842)){
var statearr_25255_25453 = state_25212__$1;
(statearr_25255_25453[(1)] = (55));

} else {
var statearr_25256_25454 = state_25212__$1;
(statearr_25256_25454[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (92))){
var inst_25006 = (state_25212[(17)]);
var inst_25018 = (state_25212[(18)]);
var inst_25013 = (state_25212[(19)]);
var inst_25019 = (state_25212[(20)]);
var inst_24923 = (state_25212[(21)]);
var inst_24872 = (state_25212[(22)]);
var inst_24981 = (state_25212[(23)]);
var inst_24936 = (state_25212[(24)]);
var inst_24873 = (state_25212[(25)]);
var inst_24963 = (state_25212[(26)]);
var inst_24982 = (state_25212[(27)]);
var inst_25024 = (state_25212[(28)]);
var inst_25023 = (state_25212[(29)]);
var inst_24840 = (state_25212[(30)]);
var inst_25037 = (state_25212[(31)]);
var inst_25014 = (state_25212[(32)]);
var inst_25040 = (state_25212[(33)]);
var inst_24892 = (state_25212[(34)]);
var inst_25029 = (state_25212[(35)]);
var inst_24847 = (state_25212[(36)]);
var inst_25060 = (state_25212[(63)]);
var inst_24883 = (state_25212[(37)]);
var inst_24836 = (state_25212[(38)]);
var inst_25046 = (state_25212[(39)]);
var inst_24871 = (state_25212[(40)]);
var inst_24972 = (state_25212[(41)]);
var inst_25036 = (state_25212[(42)]);
var inst_24954 = (state_25212[(43)]);
var inst_24841 = (state_25212[(44)]);
var inst_24924 = (state_25212[(45)]);
var inst_24983 = (state_25212[(46)]);
var inst_25012 = (state_25212[(13)]);
var inst_24843 = (state_25212[(47)]);
var inst_24848 = (state_25212[(48)]);
var inst_25033 = (state_25212[(49)]);
var inst_24945 = (state_25212[(50)]);
var inst_24927 = (state_25212[(51)]);
var inst_25039 = (state_25212[(14)]);
var inst_25038 = (state_25212[(52)]);
var inst_25005 = (state_25212[(53)]);
var inst_25062 = (function (){var no_filter_QMARK_ = true;
var t = inst_25019;
var max_limit_QMARK_ = inst_25013;
var next_node = inst_25036;
var fast_forward_db_QMARK_ = inst_25024;
var s1 = inst_24883;
var o2 = inst_24945;
var t1 = inst_24840;
var predicate_fn = inst_24873;
var i = inst_25038;
var m1 = inst_24972;
var root_node = inst_25029;
var s2 = inst_24892;
var p2 = inst_24963;
var permissions = inst_25014;
var vec__24829 = inst_24923;
var map__24828 = inst_24871;
var vec__24825 = inst_24843;
var limit = inst_25012;
var start_flake = inst_24982;
var flake_limit = inst_25006;
var offset = inst_25037;
var acc = inst_25040;
var t2 = inst_24847;
var op1 = inst_24841;
var o1 = inst_24936;
var end_flake = inst_24983;
var base_result = inst_25046;
var s = inst_25039;
var node_start = inst_25033;
var p1 = inst_24954;
var subject_fn = inst_24872;
var object_fn = inst_24927;
var idx_compare = inst_25018;
var map__24835 = inst_25005;
var G__25047 = inst_25060;
var op2 = inst_24848;
var m2 = inst_24981;
var vec__24832 = inst_24924;
var vec__24822 = inst_24836;
var novelty = inst_25023;
return (function (p1__24805_SHARP_){
return predicate_fn.call(null,p1__24805_SHARP_.p);
});
})();
var inst_25063 = cljs.core.filter.call(null,inst_25062,inst_25060);
var state_25212__$1 = state_25212;
var statearr_25257_25455 = state_25212__$1;
(statearr_25257_25455[(2)] = inst_25063);

(statearr_25257_25455[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (104))){
var inst_25006 = (state_25212[(17)]);
var inst_25040 = (state_25212[(33)]);
var inst_25072 = (state_25212[(64)]);
var inst_25039 = (state_25212[(14)]);
var inst_25038 = (state_25212[(52)]);
var inst_25084 = cljs.core.count.call(null,inst_25072);
var inst_25085 = (inst_25006 - inst_25038);
var inst_25086 = cljs.core.take.call(null,inst_25085,inst_25072);
var inst_25087 = cljs.core.into.call(null,inst_25040,inst_25086);
var inst_25088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25089 = (inst_25038 + inst_25084);
var inst_25090 = [(0),inst_25089,inst_25039,inst_25087];
var inst_25091 = (new cljs.core.PersistentVector(null,4,(5),inst_25088,inst_25090,null));
var state_25212__$1 = state_25212;
var statearr_25258_25456 = state_25212__$1;
(statearr_25258_25456[(2)] = inst_25091);

(statearr_25258_25456[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (15))){
var inst_24837 = (state_25212[(65)]);
var inst_24877 = fluree.db.dbproto._subid.call(null,db,inst_24837);
var state_25212__$1 = state_25212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25212__$1,(18),inst_24877);
} else {
if((state_val_25213 === (48))){
var inst_24845 = (state_25212[(66)]);
var inst_24954 = (state_25212[(2)]);
var inst_24955 = (inst_24845 == null);
var state_25212__$1 = (function (){var statearr_25259 = state_25212;
(statearr_25259[(43)] = inst_24954);

return statearr_25259;
})();
if(cljs.core.truth_(inst_24955)){
var statearr_25260_25457 = state_25212__$1;
(statearr_25260_25457[(1)] = (49));

} else {
var statearr_25261_25458 = state_25212__$1;
(statearr_25261_25458[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (50))){
var state_25212__$1 = state_25212;
var statearr_25262_25459 = state_25212__$1;
(statearr_25262_25459[(2)] = false);

(statearr_25262_25459[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (116))){
var inst_25006 = (state_25212[(17)]);
var inst_25133 = (state_25212[(67)]);
var inst_25134 = (state_25212[(68)]);
var inst_25132 = (state_25212[(69)]);
var inst_25137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25138 = (inst_25134 - inst_25006);
var inst_25139 = (inst_25133 - inst_25138);
var inst_25140 = cljs.core.take.call(null,inst_25139,inst_25132);
var inst_25141 = [inst_25006,inst_25140];
var inst_25142 = (new cljs.core.PersistentVector(null,2,(5),inst_25137,inst_25141,null));
var state_25212__$1 = state_25212;
var statearr_25263_25460 = state_25212__$1;
(statearr_25263_25460[(2)] = inst_25142);

(statearr_25263_25460[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (75))){
var inst_25005 = (state_25212[(53)]);
var inst_25007 = (state_25212[(70)]);
var inst_25005__$1 = (state_25212[(2)]);
var inst_25006 = cljs.core.get.call(null,inst_25005__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_25007__$1 = cljs.core.get.call(null,inst_25005__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25008 = cljs.core.get.call(null,inst_25005__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_25212__$1 = (function (){var statearr_25264 = state_25212;
(statearr_25264[(17)] = inst_25006);

(statearr_25264[(71)] = inst_25008);

(statearr_25264[(53)] = inst_25005__$1);

(statearr_25264[(70)] = inst_25007__$1);

return statearr_25264;
})();
if(cljs.core.truth_(inst_25007__$1)){
var statearr_25265_25461 = state_25212__$1;
(statearr_25265_25461[(1)] = (76));

} else {
var statearr_25266_25462 = state_25212__$1;
(statearr_25266_25462[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (99))){
var inst_25013 = (state_25212[(19)]);
var state_25212__$1 = state_25212;
var statearr_25267_25463 = state_25212__$1;
(statearr_25267_25463[(2)] = inst_25013);

(statearr_25267_25463[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (21))){
var inst_24839 = (state_25212[(72)]);
var inst_24892 = (state_25212[(2)]);
var inst_24893 = cljs.core.boolean_QMARK_.call(null,inst_24839);
var state_25212__$1 = (function (){var statearr_25268 = state_25212;
(statearr_25268[(34)] = inst_24892);

return statearr_25268;
})();
if(inst_24893){
var statearr_25269_25464 = state_25212__$1;
(statearr_25269_25464[(1)] = (23));

} else {
var statearr_25270_25465 = state_25212__$1;
(statearr_25270_25465[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (31))){
var inst_24902 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
var statearr_25271_25466 = state_25212__$1;
(statearr_25271_25466[(2)] = inst_24902);

(statearr_25271_25466[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (113))){
var inst_25114 = (state_25212[(9)]);
var inst_25116 = (state_25212[(10)]);
var inst_25012 = (state_25212[(13)]);
var inst_25119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25120 = (inst_25114 - inst_25116);
var inst_25121 = [inst_25012,inst_25120];
var inst_25122 = (new cljs.core.PersistentVector(null,2,(5),inst_25119,inst_25121,null));
var state_25212__$1 = state_25212;
var statearr_25272_25467 = state_25212__$1;
(statearr_25272_25467[(2)] = inst_25122);

(statearr_25272_25467[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (32))){
var inst_24872 = (state_25212[(22)]);
var inst_24839 = (state_25212[(72)]);
var inst_24873 = (state_25212[(25)]);
var inst_24906 = (state_25212[(73)]);
var inst_24874 = (state_25212[(74)]);
var inst_24842 = (state_25212[(56)]);
var inst_24840 = (state_25212[(30)]);
var inst_24892 = (state_25212[(34)]);
var inst_24847 = (state_25212[(36)]);
var inst_24883 = (state_25212[(37)]);
var inst_24845 = (state_25212[(66)]);
var inst_24836 = (state_25212[(38)]);
var inst_24846 = (state_25212[(55)]);
var inst_24871 = (state_25212[(40)]);
var inst_24849 = (state_25212[(75)]);
var inst_24841 = (state_25212[(44)]);
var inst_24838 = (state_25212[(76)]);
var inst_24843 = (state_25212[(47)]);
var inst_24848 = (state_25212[(48)]);
var inst_24908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24910 = [null,null];
var inst_24911 = (new cljs.core.PersistentVector(null,2,(5),inst_24909,inst_24910,null));
var inst_24912 = (function (){var bool = inst_24906;
var temp__5733__auto__ = inst_24906;
var s1 = inst_24883;
var o2 = inst_24846;
var t1 = inst_24840;
var predicate_fn = inst_24873;
var m1 = inst_24842;
var s2 = inst_24892;
var p2 = inst_24845;
var map__24828 = inst_24871;
var vec__24825 = inst_24843;
var t2 = inst_24847;
var op1 = inst_24841;
var o1 = inst_24839;
var p1 = inst_24838;
var subject_fn = inst_24872;
var object_fn = inst_24874;
var op2 = inst_24848;
var m2 = inst_24849;
var vec__24822 = inst_24836;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_24913 = [inst_24911,inst_24912];
var inst_24914 = (new cljs.core.PersistentVector(null,2,(5),inst_24908,inst_24913,null));
var state_25212__$1 = state_25212;
var statearr_25273_25468 = state_25212__$1;
(statearr_25273_25468[(2)] = inst_24914);

(statearr_25273_25468[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (40))){
var inst_24926 = (state_25212[(57)]);
var state_25212__$1 = state_25212;
var statearr_25274_25469 = state_25212__$1;
(statearr_25274_25469[(2)] = inst_24926);

(statearr_25274_25469[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (129))){
var inst_25196 = (state_25212[(2)]);
var inst_25197 = cljs.core.not.call(null,inst_25196);
var state_25212__$1 = state_25212;
if(inst_25197){
var statearr_25275_25470 = state_25212__$1;
(statearr_25275_25470[(1)] = (130));

} else {
var statearr_25276_25471 = state_25212__$1;
(statearr_25276_25471[(1)] = (131));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (91))){
var inst_24873 = (state_25212[(25)]);
var inst_25060 = (state_25212[(2)]);
var state_25212__$1 = (function (){var statearr_25277 = state_25212;
(statearr_25277[(63)] = inst_25060);

return statearr_25277;
})();
if(cljs.core.truth_(inst_24873)){
var statearr_25278_25472 = state_25212__$1;
(statearr_25278_25472[(1)] = (92));

} else {
var statearr_25279_25473 = state_25212__$1;
(statearr_25279_25473[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (117))){
var inst_25134 = (state_25212[(68)]);
var inst_25132 = (state_25212[(69)]);
var inst_25144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25145 = [inst_25134,inst_25132];
var inst_25146 = (new cljs.core.PersistentVector(null,2,(5),inst_25144,inst_25145,null));
var state_25212__$1 = state_25212;
var statearr_25280_25474 = state_25212__$1;
(statearr_25280_25474[(2)] = inst_25146);

(statearr_25280_25474[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (108))){
var inst_25094 = (state_25212[(77)]);
var inst_25037 = (state_25212[(31)]);
var inst_25106 = cljs.core.drop.call(null,inst_25037,inst_25094);
var state_25212__$1 = (function (){var statearr_25281 = state_25212;
(statearr_25281[(11)] = inst_25106);

return statearr_25281;
})();
var statearr_25282_25475 = state_25212__$1;
(statearr_25282_25475[(1)] = (110));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (56))){
var inst_24966 = (cljs.core._GT__EQ_ === start_test);
var state_25212__$1 = state_25212;
if(cljs.core.truth_(inst_24966)){
var statearr_25284_25476 = state_25212__$1;
(statearr_25284_25476[(1)] = (58));

} else {
var statearr_25285_25477 = state_25212__$1;
(statearr_25285_25477[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (33))){
var inst_24839 = (state_25212[(72)]);
var inst_24874 = (state_25212[(74)]);
var inst_24846 = (state_25212[(55)]);
var inst_24916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24918 = [inst_24839,inst_24846];
var inst_24919 = (new cljs.core.PersistentVector(null,2,(5),inst_24917,inst_24918,null));
var inst_24920 = [inst_24919,inst_24874];
var inst_24921 = (new cljs.core.PersistentVector(null,2,(5),inst_24916,inst_24920,null));
var state_25212__$1 = state_25212;
var statearr_25286_25478 = state_25212__$1;
(statearr_25286_25478[(2)] = inst_24921);

(statearr_25286_25478[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (13))){
var inst_24850 = (state_25212[(78)]);
var state_25212__$1 = state_25212;
var statearr_25287_25479 = state_25212__$1;
(statearr_25287_25479[(2)] = inst_24850);

(statearr_25287_25479[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (22))){
var inst_24888 = (state_25212[(2)]);
var inst_24889 = fluree.db.util.async.throw_err.call(null,inst_24888);
var state_25212__$1 = state_25212;
var statearr_25288_25480 = state_25212__$1;
(statearr_25288_25480[(2)] = inst_24889);

(statearr_25288_25480[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (90))){
var inst_25054 = (state_25212[(58)]);
var state_25212__$1 = state_25212;
var statearr_25289_25481 = state_25212__$1;
(statearr_25289_25481[(2)] = inst_25054);

(statearr_25289_25481[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (109))){
var inst_25169 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
var statearr_25290_25482 = state_25212__$1;
(statearr_25290_25482[(2)] = inst_25169);

(statearr_25290_25482[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (36))){
var inst_24925 = (state_25212[(79)]);
var state_25212__$1 = state_25212;
var statearr_25291_25483 = state_25212__$1;
(statearr_25291_25483[(2)] = inst_24925);

(statearr_25291_25483[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (41))){
var inst_24838 = (state_25212[(76)]);
var inst_24945 = (state_25212[(2)]);
var inst_24946 = (inst_24838 == null);
var state_25212__$1 = (function (){var statearr_25292 = state_25212;
(statearr_25292[(50)] = inst_24945);

return statearr_25292;
})();
if(cljs.core.truth_(inst_24946)){
var statearr_25293_25484 = state_25212__$1;
(statearr_25293_25484[(1)] = (43));

} else {
var statearr_25294_25485 = state_25212__$1;
(statearr_25294_25485[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (118))){
var inst_25129 = (state_25212[(80)]);
var inst_25148 = (state_25212[(2)]);
var inst_25149 = cljs.core.nth.call(null,inst_25148,(0),null);
var inst_25150 = cljs.core.nth.call(null,inst_25148,(1),null);
var inst_25151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25152 = [inst_25149,inst_25129,inst_25150];
var inst_25153 = (new cljs.core.PersistentVector(null,3,(5),inst_25151,inst_25152,null));
var state_25212__$1 = state_25212;
var statearr_25295_25486 = state_25212__$1;
(statearr_25295_25486[(2)] = inst_25153);

(statearr_25295_25486[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (89))){
var inst_25006 = (state_25212[(17)]);
var inst_25018 = (state_25212[(18)]);
var inst_25013 = (state_25212[(19)]);
var inst_25019 = (state_25212[(20)]);
var inst_24923 = (state_25212[(21)]);
var inst_24872 = (state_25212[(22)]);
var inst_24981 = (state_25212[(23)]);
var inst_24936 = (state_25212[(24)]);
var inst_24873 = (state_25212[(25)]);
var inst_25054 = (state_25212[(58)]);
var inst_24963 = (state_25212[(26)]);
var inst_24982 = (state_25212[(27)]);
var inst_25024 = (state_25212[(28)]);
var inst_25023 = (state_25212[(29)]);
var inst_24840 = (state_25212[(30)]);
var inst_25037 = (state_25212[(31)]);
var inst_25014 = (state_25212[(32)]);
var inst_25040 = (state_25212[(33)]);
var inst_24892 = (state_25212[(34)]);
var inst_25029 = (state_25212[(35)]);
var inst_24847 = (state_25212[(36)]);
var inst_24883 = (state_25212[(37)]);
var inst_24836 = (state_25212[(38)]);
var inst_25046 = (state_25212[(39)]);
var inst_24871 = (state_25212[(40)]);
var inst_24972 = (state_25212[(41)]);
var inst_25036 = (state_25212[(42)]);
var inst_24954 = (state_25212[(43)]);
var inst_24841 = (state_25212[(44)]);
var inst_24924 = (state_25212[(45)]);
var inst_24983 = (state_25212[(46)]);
var inst_25012 = (state_25212[(13)]);
var inst_24843 = (state_25212[(47)]);
var inst_24848 = (state_25212[(48)]);
var inst_25033 = (state_25212[(49)]);
var inst_24945 = (state_25212[(50)]);
var inst_24927 = (state_25212[(51)]);
var inst_25039 = (state_25212[(14)]);
var inst_25038 = (state_25212[(52)]);
var inst_25005 = (state_25212[(53)]);
var inst_25056 = (function (){var no_filter_QMARK_ = true;
var t = inst_25019;
var max_limit_QMARK_ = inst_25013;
var next_node = inst_25036;
var fast_forward_db_QMARK_ = inst_25024;
var s1 = inst_24883;
var o2 = inst_24945;
var t1 = inst_24840;
var predicate_fn = inst_24873;
var i = inst_25038;
var m1 = inst_24972;
var root_node = inst_25029;
var s2 = inst_24892;
var p2 = inst_24963;
var permissions = inst_25014;
var vec__24829 = inst_24923;
var map__24828 = inst_24871;
var vec__24825 = inst_24843;
var limit = inst_25012;
var start_flake = inst_24982;
var flake_limit = inst_25006;
var offset = inst_25037;
var acc = inst_25040;
var t2 = inst_24847;
var op1 = inst_24841;
var o1 = inst_24936;
var end_flake = inst_24983;
var base_result = inst_25046;
var s = inst_25039;
var node_start = inst_25033;
var p1 = inst_24954;
var subject_fn = inst_24872;
var object_fn = inst_24927;
var idx_compare = inst_25018;
var map__24835 = inst_25005;
var G__25047 = inst_25054;
var op2 = inst_24848;
var m2 = inst_24981;
var vec__24832 = inst_24924;
var vec__24822 = inst_24836;
var novelty = inst_25023;
return (function (p1__24804_SHARP_){
return subject_fn.call(null,p1__24804_SHARP_.s);
});
})();
var inst_25057 = cljs.core.filter.call(null,inst_25056,inst_25054);
var state_25212__$1 = state_25212;
var statearr_25296_25487 = state_25212__$1;
(statearr_25296_25487[(2)] = inst_25057);

(statearr_25296_25487[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (100))){
var inst_25082 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
if(cljs.core.truth_(inst_25082)){
var statearr_25297_25488 = state_25212__$1;
(statearr_25297_25488[(1)] = (104));

} else {
var statearr_25298_25489 = state_25212__$1;
(statearr_25298_25489[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (131))){
var inst_25173 = (state_25212[(59)]);
var inst_25175 = (state_25212[(15)]);
var inst_25192 = (state_25212[(81)]);
var inst_25172 = (state_25212[(60)]);
var inst_25174 = (state_25212[(61)]);
var inst_25036 = inst_25192;
var inst_25037 = inst_25172;
var inst_25038 = inst_25173;
var inst_25039 = inst_25174;
var inst_25040 = inst_25175;
var state_25212__$1 = (function (){var statearr_25299 = state_25212;
(statearr_25299[(31)] = inst_25037);

(statearr_25299[(33)] = inst_25040);

(statearr_25299[(42)] = inst_25036);

(statearr_25299[(14)] = inst_25039);

(statearr_25299[(52)] = inst_25038);

return statearr_25299;
})();
var statearr_25300_25490 = state_25212__$1;
(statearr_25300_25490[(2)] = null);

(statearr_25300_25490[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (122))){
var inst_25184 = (state_25212[(16)]);
var inst_25184__$1 = (state_25212[(2)]);
var state_25212__$1 = (function (){var statearr_25301 = state_25212;
(statearr_25301[(16)] = inst_25184__$1);

return statearr_25301;
})();
if(cljs.core.truth_(inst_25184__$1)){
var statearr_25302_25491 = state_25212__$1;
(statearr_25302_25491[(1)] = (123));

} else {
var statearr_25303_25492 = state_25212__$1;
(statearr_25303_25492[(1)] = (124));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (43))){
var inst_24936 = (state_25212[(24)]);
var state_25212__$1 = state_25212;
var statearr_25304_25493 = state_25212__$1;
(statearr_25304_25493[(2)] = inst_24936);

(statearr_25304_25493[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (61))){
var inst_24849 = (state_25212[(75)]);
var state_25212__$1 = state_25212;
var statearr_25305_25494 = state_25212__$1;
(statearr_25305_25494[(2)] = inst_24849);

(statearr_25305_25494[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (29))){
var state_25212__$1 = state_25212;
var statearr_25306_25495 = state_25212__$1;
(statearr_25306_25495[(2)] = null);

(statearr_25306_25495[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (44))){
var state_25212__$1 = state_25212;
var statearr_25307_25496 = state_25212__$1;
(statearr_25307_25496[(2)] = false);

(statearr_25307_25496[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (93))){
var inst_25060 = (state_25212[(63)]);
var state_25212__$1 = state_25212;
var statearr_25308_25497 = state_25212__$1;
(statearr_25308_25497[(2)] = inst_25060);

(statearr_25308_25497[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (6))){
var inst_24850 = (state_25212[(78)]);
var inst_24855 = inst_24850.cljs$lang$protocol_mask$partition0$;
var inst_24856 = (inst_24855 & (64));
var inst_24857 = inst_24850.cljs$core$ISeq$;
var inst_24858 = (cljs.core.PROTOCOL_SENTINEL === inst_24857);
var inst_24859 = ((inst_24856) || (inst_24858));
var state_25212__$1 = state_25212;
if(cljs.core.truth_(inst_24859)){
var statearr_25309_25498 = state_25212__$1;
(statearr_25309_25498[(1)] = (9));

} else {
var statearr_25310_25499 = state_25212__$1;
(statearr_25310_25499[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (111))){
var inst_25006 = (state_25212[(17)]);
var inst_25106 = (state_25212[(11)]);
var inst_25012 = (state_25212[(13)]);
var inst_25039 = (state_25212[(14)]);
var inst_25038 = (state_25212[(52)]);
var inst_25155 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_25106,inst_25038,inst_25039,inst_25006,inst_25012);
var state_25212__$1 = state_25212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25212__$1,(119),inst_25155);
} else {
if((state_val_25213 === (28))){
var inst_24904 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
var statearr_25311_25500 = state_25212__$1;
(statearr_25311_25500[(2)] = inst_24904);

(statearr_25311_25500[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (64))){
var state_25212__$1 = state_25212;
var statearr_25312_25501 = state_25212__$1;
(statearr_25312_25501[(2)] = (2147483647));

(statearr_25312_25501[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (103))){
var inst_25079 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
var statearr_25313_25502 = state_25212__$1;
(statearr_25313_25502[(2)] = inst_25079);

(statearr_25313_25502[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (51))){
var inst_24959 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
if(cljs.core.truth_(inst_24959)){
var statearr_25314_25503 = state_25212__$1;
(statearr_25314_25503[(1)] = (52));

} else {
var statearr_25315_25504 = state_25212__$1;
(statearr_25315_25504[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (25))){
var inst_24906 = (state_25212[(73)]);
var inst_24906__$1 = (state_25212[(2)]);
var state_25212__$1 = (function (){var statearr_25316 = state_25212;
(statearr_25316[(73)] = inst_24906__$1);

return statearr_25316;
})();
if(cljs.core.truth_(inst_24906__$1)){
var statearr_25317_25505 = state_25212__$1;
(statearr_25317_25505[(1)] = (32));

} else {
var statearr_25318_25506 = state_25212__$1;
(statearr_25318_25506[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (34))){
var inst_24923 = (state_25212[(21)]);
var inst_24924 = (state_25212[(45)]);
var inst_24925 = (state_25212[(79)]);
var inst_24923__$1 = (state_25212[(2)]);
var inst_24924__$1 = cljs.core.nth.call(null,inst_24923__$1,(0),null);
var inst_24925__$1 = cljs.core.nth.call(null,inst_24924__$1,(0),null);
var inst_24926 = cljs.core.nth.call(null,inst_24924__$1,(1),null);
var inst_24927 = cljs.core.nth.call(null,inst_24923__$1,(1),null);
var inst_24928 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24925__$1);
var state_25212__$1 = (function (){var statearr_25319 = state_25212;
(statearr_25319[(21)] = inst_24923__$1);

(statearr_25319[(57)] = inst_24926);

(statearr_25319[(45)] = inst_24924__$1);

(statearr_25319[(51)] = inst_24927);

(statearr_25319[(79)] = inst_24925__$1);

return statearr_25319;
})();
if(inst_24928){
var statearr_25320_25507 = state_25212__$1;
(statearr_25320_25507[(1)] = (35));

} else {
var statearr_25321_25508 = state_25212__$1;
(statearr_25321_25508[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (125))){
var inst_25184 = (state_25212[(16)]);
var inst_25192 = (state_25212[(2)]);
var state_25212__$1 = (function (){var statearr_25322 = state_25212;
(statearr_25322[(81)] = inst_25192);

return statearr_25322;
})();
if(cljs.core.truth_(inst_25184)){
var statearr_25323_25509 = state_25212__$1;
(statearr_25323_25509[(1)] = (127));

} else {
var statearr_25324_25510 = state_25212__$1;
(statearr_25324_25510[(1)] = (128));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (17))){
var inst_24844 = (state_25212[(54)]);
var inst_24883 = (state_25212[(2)]);
var inst_24884 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24844);
var state_25212__$1 = (function (){var statearr_25325 = state_25212;
(statearr_25325[(37)] = inst_24883);

return statearr_25325;
})();
if(inst_24884){
var statearr_25326_25511 = state_25212__$1;
(statearr_25326_25511[(1)] = (19));

} else {
var statearr_25327_25512 = state_25212__$1;
(statearr_25327_25512[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (3))){
var inst_25210 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25212__$1,inst_25210);
} else {
if((state_val_25213 === (12))){
var inst_24850 = (state_25212[(78)]);
var inst_24868 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24850);
var state_25212__$1 = state_25212;
var statearr_25328_25513 = state_25212__$1;
(statearr_25328_25513[(2)] = inst_24868);

(statearr_25328_25513[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (2))){
var inst_24836 = (state_25212[(38)]);
var inst_24843 = (state_25212[(47)]);
var inst_24850 = (state_25212[(78)]);
var _ = (function (){var statearr_25329 = state_25212;
(statearr_25329[(4)] = cljs.core.cons.call(null,(5),(state_25212[(4)])));

return statearr_25329;
})();
var inst_24836__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_24837 = cljs.core.nth.call(null,inst_24836__$1,(0),null);
var inst_24838 = cljs.core.nth.call(null,inst_24836__$1,(1),null);
var inst_24839 = cljs.core.nth.call(null,inst_24836__$1,(2),null);
var inst_24840 = cljs.core.nth.call(null,inst_24836__$1,(3),null);
var inst_24841 = cljs.core.nth.call(null,inst_24836__$1,(4),null);
var inst_24842 = cljs.core.nth.call(null,inst_24836__$1,(5),null);
var inst_24843__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_24844 = cljs.core.nth.call(null,inst_24843__$1,(0),null);
var inst_24845 = cljs.core.nth.call(null,inst_24843__$1,(1),null);
var inst_24846 = cljs.core.nth.call(null,inst_24843__$1,(2),null);
var inst_24847 = cljs.core.nth.call(null,inst_24843__$1,(3),null);
var inst_24848 = cljs.core.nth.call(null,inst_24843__$1,(4),null);
var inst_24849 = cljs.core.nth.call(null,inst_24843__$1,(5),null);
var inst_24850__$1 = opts;
var inst_24852 = (inst_24850__$1 == null);
var inst_24853 = cljs.core.not.call(null,inst_24852);
var state_25212__$1 = (function (){var statearr_25330 = state_25212;
(statearr_25330[(72)] = inst_24839);

(statearr_25330[(56)] = inst_24842);

(statearr_25330[(30)] = inst_24840);

(statearr_25330[(54)] = inst_24844);

(statearr_25330[(36)] = inst_24847);

(statearr_25330[(66)] = inst_24845);

(statearr_25330[(38)] = inst_24836__$1);

(statearr_25330[(55)] = inst_24846);

(statearr_25330[(75)] = inst_24849);

(statearr_25330[(44)] = inst_24841);

(statearr_25330[(65)] = inst_24837);

(statearr_25330[(76)] = inst_24838);

(statearr_25330[(47)] = inst_24843__$1);

(statearr_25330[(48)] = inst_24848);

(statearr_25330[(78)] = inst_24850__$1);

return statearr_25330;
})();
if(inst_24853){
var statearr_25331_25514 = state_25212__$1;
(statearr_25331_25514[(1)] = (6));

} else {
var statearr_25332_25515 = state_25212__$1;
(statearr_25332_25515[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (66))){
var inst_24979 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
var statearr_25333_25516 = state_25212__$1;
(statearr_25333_25516[(2)] = inst_24979);

(statearr_25333_25516[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (107))){
var inst_25037 = (state_25212[(31)]);
var inst_25040 = (state_25212[(33)]);
var inst_25095 = (state_25212[(82)]);
var inst_25039 = (state_25212[(14)]);
var inst_25038 = (state_25212[(52)]);
var inst_25098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25099 = (inst_25037 - inst_25095);
var inst_25100 = [inst_25099,inst_25038,inst_25039,inst_25040];
var inst_25101 = (new cljs.core.PersistentVector(null,4,(5),inst_25098,inst_25100,null));
var state_25212__$1 = state_25212;
var statearr_25334_25517 = state_25212__$1;
(statearr_25334_25517[(2)] = inst_25101);

(statearr_25334_25517[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (23))){
var inst_24839 = (state_25212[(72)]);
var state_25212__$1 = state_25212;
var statearr_25335_25518 = state_25212__$1;
(statearr_25335_25518[(2)] = inst_24839);

(statearr_25335_25518[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (47))){
var inst_24838 = (state_25212[(76)]);
var state_25212__$1 = state_25212;
var statearr_25336_25519 = state_25212__$1;
(statearr_25336_25519[(2)] = inst_24838);

(statearr_25336_25519[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (35))){
var inst_24925 = (state_25212[(79)]);
var inst_24930 = fluree.db.dbproto._subid.call(null,db,inst_24925);
var state_25212__$1 = state_25212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25212__$1,(38),inst_24930);
} else {
if((state_val_25213 === (127))){
var inst_25192 = (state_25212[(81)]);
var state_25212__$1 = state_25212;
var statearr_25337_25520 = state_25212__$1;
(statearr_25337_25520[(2)] = inst_25192);

(statearr_25337_25520[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (82))){
var state_25212__$1 = state_25212;
var statearr_25338_25521 = state_25212__$1;
(statearr_25338_25521[(2)] = null);

(statearr_25338_25521[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (76))){
var inst_25007 = (state_25212[(70)]);
var state_25212__$1 = state_25212;
var statearr_25339_25522 = state_25212__$1;
(statearr_25339_25522[(2)] = inst_25007);

(statearr_25339_25522[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (97))){
var inst_25013 = (state_25212[(19)]);
var inst_25036 = (state_25212[(42)]);
var inst_25072 = (state_25212[(2)]);
var inst_25073 = fluree.db.dbproto._rhs.call(null,inst_25036);
var state_25212__$1 = (function (){var statearr_25340 = state_25212;
(statearr_25340[(64)] = inst_25072);

(statearr_25340[(7)] = inst_25073);

return statearr_25340;
})();
if(cljs.core.truth_(inst_25013)){
var statearr_25341_25523 = state_25212__$1;
(statearr_25341_25523[(1)] = (98));

} else {
var statearr_25342_25524 = state_25212__$1;
(statearr_25342_25524[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (19))){
var inst_24844 = (state_25212[(54)]);
var inst_24886 = fluree.db.dbproto._subid.call(null,db,inst_24844);
var state_25212__$1 = state_25212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25212__$1,(22),inst_24886);
} else {
if((state_val_25213 === (57))){
var inst_24849 = (state_25212[(75)]);
var inst_24972 = (state_25212[(2)]);
var state_25212__$1 = (function (){var statearr_25343 = state_25212;
(statearr_25343[(41)] = inst_24972);

return statearr_25343;
})();
if(cljs.core.truth_(inst_24849)){
var statearr_25344_25525 = state_25212__$1;
(statearr_25344_25525[(1)] = (61));

} else {
var statearr_25345_25526 = state_25212__$1;
(statearr_25345_25526[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (68))){
var state_25212__$1 = state_25212;
var statearr_25346_25527 = state_25212__$1;
(statearr_25346_25527[(2)] = false);

(statearr_25346_25527[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (11))){
var inst_24863 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
var statearr_25347_25528 = state_25212__$1;
(statearr_25347_25528[(2)] = inst_24863);

(statearr_25347_25528[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (115))){
var inst_25006 = (state_25212[(17)]);
var inst_25133 = (state_25212[(67)]);
var inst_25106 = (state_25212[(11)]);
var inst_25134 = (state_25212[(68)]);
var inst_25132 = (state_25212[(69)]);
var inst_25038 = (state_25212[(52)]);
var inst_25128 = (state_25212[(2)]);
var inst_25129 = cljs.core.nth.call(null,inst_25128,(0),null);
var inst_25130 = cljs.core.nth.call(null,inst_25128,(1),null);
var inst_25131 = cljs.core.take.call(null,inst_25130,inst_25106);
var inst_25132__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_25131);
var inst_25133__$1 = cljs.core.count.call(null,inst_25132__$1);
var inst_25134__$1 = (inst_25038 + inst_25133__$1);
var inst_25135 = (inst_25134__$1 > inst_25006);
var state_25212__$1 = (function (){var statearr_25349 = state_25212;
(statearr_25349[(67)] = inst_25133__$1);

(statearr_25349[(80)] = inst_25129);

(statearr_25349[(68)] = inst_25134__$1);

(statearr_25349[(69)] = inst_25132__$1);

return statearr_25349;
})();
if(cljs.core.truth_(inst_25135)){
var statearr_25350_25529 = state_25212__$1;
(statearr_25350_25529[(1)] = (116));

} else {
var statearr_25351_25530 = state_25212__$1;
(statearr_25351_25530[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (9))){
var state_25212__$1 = state_25212;
var statearr_25352_25531 = state_25212__$1;
(statearr_25352_25531[(2)] = true);

(statearr_25352_25531[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (5))){
var _ = (function (){var statearr_25353 = state_25212;
(statearr_25353[(4)] = cljs.core.rest.call(null,(state_25212[(4)])));

return statearr_25353;
})();
var state_25212__$1 = state_25212;
var ex25348 = (state_25212__$1[(2)]);
var statearr_25354_25532 = state_25212__$1;
(statearr_25354_25532[(5)] = ex25348);


if((ex25348 instanceof Error)){
var statearr_25355_25533 = state_25212__$1;
(statearr_25355_25533[(1)] = (4));

(statearr_25355_25533[(5)] = null);

} else {
throw ex25348;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (112))){
var inst_25040 = (state_25212[(33)]);
var inst_25160 = (state_25212[(2)]);
var inst_25161 = cljs.core.nth.call(null,inst_25160,(0),null);
var inst_25162 = cljs.core.nth.call(null,inst_25160,(1),null);
var inst_25163 = cljs.core.nth.call(null,inst_25160,(2),null);
var inst_25164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25165 = cljs.core.into.call(null,inst_25040,inst_25163);
var inst_25166 = [(0),inst_25161,inst_25162,inst_25165];
var inst_25167 = (new cljs.core.PersistentVector(null,4,(5),inst_25164,inst_25166,null));
var state_25212__$1 = state_25212;
var statearr_25356_25534 = state_25212__$1;
(statearr_25356_25534[(2)] = inst_25167);

(statearr_25356_25534[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (83))){
var inst_25207 = (state_25212[(2)]);
var _ = (function (){var statearr_25357 = state_25212;
(statearr_25357[(4)] = cljs.core.rest.call(null,(state_25212[(4)])));

return statearr_25357;
})();
var state_25212__$1 = state_25212;
var statearr_25358_25535 = state_25212__$1;
(statearr_25358_25535[(2)] = inst_25207);

(statearr_25358_25535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (14))){
var inst_24871 = (state_25212[(40)]);
var inst_24837 = (state_25212[(65)]);
var inst_24871__$1 = (state_25212[(2)]);
var inst_24872 = cljs.core.get.call(null,inst_24871__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_24873 = cljs.core.get.call(null,inst_24871__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_24874 = cljs.core.get.call(null,inst_24871__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_24875 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24837);
var state_25212__$1 = (function (){var statearr_25359 = state_25212;
(statearr_25359[(22)] = inst_24872);

(statearr_25359[(25)] = inst_24873);

(statearr_25359[(74)] = inst_24874);

(statearr_25359[(40)] = inst_24871__$1);

return statearr_25359;
})();
if(inst_24875){
var statearr_25360_25536 = state_25212__$1;
(statearr_25360_25536[(1)] = (15));

} else {
var statearr_25361_25537 = state_25212__$1;
(statearr_25361_25537[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (45))){
var inst_24950 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
if(cljs.core.truth_(inst_24950)){
var statearr_25362_25538 = state_25212__$1;
(statearr_25362_25538[(1)] = (46));

} else {
var statearr_25363_25539 = state_25212__$1;
(statearr_25363_25539[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (53))){
var inst_24845 = (state_25212[(66)]);
var state_25212__$1 = state_25212;
var statearr_25364_25540 = state_25212__$1;
(statearr_25364_25540[(2)] = inst_24845);

(statearr_25364_25540[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (78))){
var inst_25012 = (state_25212[(13)]);
var inst_25012__$1 = (state_25212[(2)]);
var inst_25013 = cljs.core._EQ_.call(null,inst_25012__$1,fluree.db.util.core.max_long);
var inst_25014 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_25015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25016 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_25017 = (new cljs.core.PersistentVector(null,3,(5),inst_25015,inst_25016,null));
var inst_25018 = cljs.core.get_in.call(null,db,inst_25017);
var inst_25019 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25021 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_25022 = (new cljs.core.PersistentVector(null,2,(5),inst_25020,inst_25021,null));
var inst_25023 = cljs.core.get_in.call(null,db,inst_25022);
var inst_25024 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_25025 = cljs.core.get.call(null,db,idx);
var inst_25026 = fluree.db.dbproto._resolve.call(null,inst_25025);
var state_25212__$1 = (function (){var statearr_25365 = state_25212;
(statearr_25365[(18)] = inst_25018);

(statearr_25365[(19)] = inst_25013);

(statearr_25365[(20)] = inst_25019);

(statearr_25365[(28)] = inst_25024);

(statearr_25365[(29)] = inst_25023);

(statearr_25365[(32)] = inst_25014);

(statearr_25365[(13)] = inst_25012__$1);

return statearr_25365;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25212__$1,(79),inst_25026);
} else {
if((state_val_25213 === (132))){
var inst_25202 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
var statearr_25366_25541 = state_25212__$1;
(statearr_25366_25541[(2)] = inst_25202);

(statearr_25366_25541[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (26))){
var inst_24846 = (state_25212[(55)]);
var state_25212__$1 = state_25212;
var statearr_25367_25542 = state_25212__$1;
(statearr_25367_25542[(2)] = inst_24846);

(statearr_25367_25542[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (123))){
var inst_25019 = (state_25212[(20)]);
var inst_25024 = (state_25212[(28)]);
var inst_25023 = (state_25212[(29)]);
var inst_25029 = (state_25212[(35)]);
var inst_25073 = (state_25212[(7)]);
var inst_25186 = fluree.db.query.range.find_next_valid_node.call(null,inst_25029,inst_25073,inst_25019,inst_25023,inst_25024);
var state_25212__$1 = state_25212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25212__$1,(126),inst_25186);
} else {
if((state_val_25213 === (16))){
var inst_24837 = (state_25212[(65)]);
var state_25212__$1 = state_25212;
var statearr_25368_25543 = state_25212__$1;
(statearr_25368_25543[(2)] = inst_24837);

(statearr_25368_25543[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (81))){
var inst_25008 = (state_25212[(71)]);
var inst_25033 = (state_25212[(49)]);
var inst_25035 = cljs.core.PersistentVector.EMPTY;
var inst_25036 = inst_25033;
var inst_25037 = inst_25008;
var inst_25038 = (0);
var inst_25039 = (0);
var inst_25040 = inst_25035;
var state_25212__$1 = (function (){var statearr_25369 = state_25212;
(statearr_25369[(31)] = inst_25037);

(statearr_25369[(33)] = inst_25040);

(statearr_25369[(42)] = inst_25036);

(statearr_25369[(14)] = inst_25039);

(statearr_25369[(52)] = inst_25038);

return statearr_25369;
})();
var statearr_25370_25544 = state_25212__$1;
(statearr_25370_25544[(2)] = null);

(statearr_25370_25544[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (120))){
var inst_25006 = (state_25212[(17)]);
var inst_25018 = (state_25212[(18)]);
var inst_25173 = (state_25212[(59)]);
var inst_25073 = (state_25212[(7)]);
var inst_25174 = (state_25212[(61)]);
var inst_24983 = (state_25212[(46)]);
var inst_25012 = (state_25212[(13)]);
var inst_25177 = inst_25018.call(null,inst_25073,inst_24983);
var inst_25178 = (inst_25177 < (0));
var inst_25179 = (inst_25173 < inst_25006);
var inst_25180 = (inst_25174 < inst_25012);
var inst_25181 = ((inst_25178) && (inst_25179) && (inst_25180));
var state_25212__$1 = state_25212;
var statearr_25371_25545 = state_25212__$1;
(statearr_25371_25545[(2)] = inst_25181);

(statearr_25371_25545[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (79))){
var inst_25019 = (state_25212[(20)]);
var inst_24982 = (state_25212[(27)]);
var inst_25024 = (state_25212[(28)]);
var inst_25023 = (state_25212[(29)]);
var inst_25029 = (state_25212[(35)]);
var inst_25028 = (state_25212[(2)]);
var inst_25029__$1 = fluree.db.util.async.throw_err.call(null,inst_25028);
var inst_25030 = fluree.db.query.range.find_next_valid_node.call(null,inst_25029__$1,inst_24982,inst_25019,inst_25023,inst_25024);
var state_25212__$1 = (function (){var statearr_25372 = state_25212;
(statearr_25372[(35)] = inst_25029__$1);

return statearr_25372;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25212__$1,(80),inst_25030);
} else {
if((state_val_25213 === (38))){
var inst_24932 = (state_25212[(2)]);
var inst_24933 = fluree.db.util.async.throw_err.call(null,inst_24932);
var state_25212__$1 = state_25212;
var statearr_25373_25546 = state_25212__$1;
(statearr_25373_25546[(2)] = inst_24933);

(statearr_25373_25546[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (126))){
var inst_25188 = (state_25212[(2)]);
var inst_25189 = fluree.db.util.async.throw_err.call(null,inst_25188);
var state_25212__$1 = state_25212;
var statearr_25374_25547 = state_25212__$1;
(statearr_25374_25547[(2)] = inst_25189);

(statearr_25374_25547[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (98))){
var inst_25037 = (state_25212[(31)]);
var inst_25075 = cljs.core._EQ_.call(null,(0),inst_25037);
var state_25212__$1 = state_25212;
if(inst_25075){
var statearr_25375_25548 = state_25212__$1;
(statearr_25375_25548[(1)] = (101));

} else {
var statearr_25376_25549 = state_25212__$1;
(statearr_25376_25549[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (124))){
var state_25212__$1 = state_25212;
var statearr_25377_25550 = state_25212__$1;
(statearr_25377_25550[(2)] = null);

(statearr_25377_25550[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (87))){
var inst_25046 = (state_25212[(39)]);
var state_25212__$1 = state_25212;
var statearr_25378_25551 = state_25212__$1;
(statearr_25378_25551[(2)] = inst_25046);

(statearr_25378_25551[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (30))){
var state_25212__$1 = state_25212;
var statearr_25379_25552 = state_25212__$1;
(statearr_25379_25552[(2)] = null);

(statearr_25379_25552[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (73))){
var inst_24984 = (state_25212[(8)]);
var inst_25002 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24984);
var state_25212__$1 = state_25212;
var statearr_25380_25553 = state_25212__$1;
(statearr_25380_25553[(2)] = inst_25002);

(statearr_25380_25553[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (96))){
var inst_25066 = (state_25212[(62)]);
var state_25212__$1 = state_25212;
var statearr_25381_25554 = state_25212__$1;
(statearr_25381_25554[(2)] = inst_25066);

(statearr_25381_25554[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (10))){
var state_25212__$1 = state_25212;
var statearr_25382_25555 = state_25212__$1;
(statearr_25382_25555[(2)] = false);

(statearr_25382_25555[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (18))){
var inst_24879 = (state_25212[(2)]);
var inst_24880 = fluree.db.util.async.throw_err.call(null,inst_24879);
var state_25212__$1 = state_25212;
var statearr_25383_25556 = state_25212__$1;
(statearr_25383_25556[(2)] = inst_24880);

(statearr_25383_25556[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (105))){
var inst_25006 = (state_25212[(17)]);
var inst_25018 = (state_25212[(18)]);
var inst_25013 = (state_25212[(19)]);
var inst_25019 = (state_25212[(20)]);
var inst_24923 = (state_25212[(21)]);
var inst_24872 = (state_25212[(22)]);
var inst_24981 = (state_25212[(23)]);
var inst_24936 = (state_25212[(24)]);
var inst_24873 = (state_25212[(25)]);
var inst_24963 = (state_25212[(26)]);
var inst_24982 = (state_25212[(27)]);
var inst_25024 = (state_25212[(28)]);
var inst_25023 = (state_25212[(29)]);
var inst_25094 = (state_25212[(77)]);
var inst_24840 = (state_25212[(30)]);
var inst_25037 = (state_25212[(31)]);
var inst_25014 = (state_25212[(32)]);
var inst_25040 = (state_25212[(33)]);
var inst_24892 = (state_25212[(34)]);
var inst_25072 = (state_25212[(64)]);
var inst_25029 = (state_25212[(35)]);
var inst_24847 = (state_25212[(36)]);
var inst_25073 = (state_25212[(7)]);
var inst_24883 = (state_25212[(37)]);
var inst_24836 = (state_25212[(38)]);
var inst_25046 = (state_25212[(39)]);
var inst_24871 = (state_25212[(40)]);
var inst_24972 = (state_25212[(41)]);
var inst_25036 = (state_25212[(42)]);
var inst_24954 = (state_25212[(43)]);
var inst_24841 = (state_25212[(44)]);
var inst_24924 = (state_25212[(45)]);
var inst_25095 = (state_25212[(82)]);
var inst_24983 = (state_25212[(46)]);
var inst_25012 = (state_25212[(13)]);
var inst_24843 = (state_25212[(47)]);
var inst_24848 = (state_25212[(48)]);
var inst_25033 = (state_25212[(49)]);
var inst_24945 = (state_25212[(50)]);
var inst_24927 = (state_25212[(51)]);
var inst_25039 = (state_25212[(14)]);
var inst_25038 = (state_25212[(52)]);
var inst_25005 = (state_25212[(53)]);
var inst_25093 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_25072;
var t = inst_25019;
var max_limit_QMARK_ = inst_25013;
var next_node = inst_25036;
var fast_forward_db_QMARK_ = inst_25024;
var s1 = inst_24883;
var o2 = inst_24945;
var t1 = inst_24840;
var predicate_fn = inst_24873;
var i = inst_25038;
var rhs = inst_25073;
var m1 = inst_24972;
var root_node = inst_25029;
var s2 = inst_24892;
var p2 = inst_24963;
var permissions = inst_25014;
var vec__24829 = inst_24923;
var map__24828 = inst_24871;
var vec__24825 = inst_24843;
var limit = inst_25012;
var start_flake = inst_24982;
var flake_limit = inst_25006;
var offset = inst_25037;
var acc = inst_25040;
var t2 = inst_24847;
var op1 = inst_24841;
var o1 = inst_24936;
var end_flake = inst_24983;
var base_result = inst_25046;
var s = inst_25039;
var node_start = inst_25033;
var p1 = inst_24954;
var subject_fn = inst_24872;
var object_fn = inst_24927;
var idx_compare = inst_25018;
var map__24835 = inst_25005;
var op2 = inst_24848;
var m2 = inst_24981;
var vec__24832 = inst_24924;
var vec__24822 = inst_24836;
var novelty = inst_25023;
return (function (p1__24807_SHARP_){
return p1__24807_SHARP_.s;
});
})();
var inst_25094__$1 = cljs.core.partition_by.call(null,inst_25093,inst_25072);
var inst_25095__$1 = cljs.core.count.call(null,inst_25094__$1);
var inst_25096 = (inst_25037 > inst_25095__$1);
var state_25212__$1 = (function (){var statearr_25384 = state_25212;
(statearr_25384[(77)] = inst_25094__$1);

(statearr_25384[(82)] = inst_25095__$1);

return statearr_25384;
})();
if(cljs.core.truth_(inst_25096)){
var statearr_25385_25557 = state_25212__$1;
(statearr_25385_25557[(1)] = (107));

} else {
var statearr_25386_25558 = state_25212__$1;
(statearr_25386_25558[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (52))){
var state_25212__$1 = state_25212;
var statearr_25387_25559 = state_25212__$1;
(statearr_25387_25559[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_25387_25559[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (114))){
var inst_25115 = (state_25212[(12)]);
var inst_25124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25125 = [inst_25115,inst_25115];
var inst_25126 = (new cljs.core.PersistentVector(null,2,(5),inst_25124,inst_25125,null));
var state_25212__$1 = state_25212;
var statearr_25388_25560 = state_25212__$1;
(statearr_25388_25560[(2)] = inst_25126);

(statearr_25388_25560[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (67))){
var inst_24984 = (state_25212[(8)]);
var inst_24989 = inst_24984.cljs$lang$protocol_mask$partition0$;
var inst_24990 = (inst_24989 & (64));
var inst_24991 = inst_24984.cljs$core$ISeq$;
var inst_24992 = (cljs.core.PROTOCOL_SENTINEL === inst_24991);
var inst_24993 = ((inst_24990) || (inst_24992));
var state_25212__$1 = state_25212;
if(cljs.core.truth_(inst_24993)){
var statearr_25389_25561 = state_25212__$1;
(statearr_25389_25561[(1)] = (70));

} else {
var statearr_25390_25562 = state_25212__$1;
(statearr_25390_25562[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (71))){
var state_25212__$1 = state_25212;
var statearr_25391_25563 = state_25212__$1;
(statearr_25391_25563[(2)] = false);

(statearr_25391_25563[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (42))){
var inst_24941 = (state_25212[(2)]);
var inst_24942 = fluree.db.util.async.throw_err.call(null,inst_24941);
var state_25212__$1 = state_25212;
var statearr_25392_25564 = state_25212__$1;
(statearr_25392_25564[(2)] = inst_24942);

(statearr_25392_25564[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (80))){
var inst_25033 = (state_25212[(49)]);
var inst_25032 = (state_25212[(2)]);
var inst_25033__$1 = fluree.db.util.async.throw_err.call(null,inst_25032);
var state_25212__$1 = (function (){var statearr_25393 = state_25212;
(statearr_25393[(49)] = inst_25033__$1);

return statearr_25393;
})();
if(cljs.core.truth_(inst_25033__$1)){
var statearr_25394_25565 = state_25212__$1;
(statearr_25394_25565[(1)] = (81));

} else {
var statearr_25395_25566 = state_25212__$1;
(statearr_25395_25566[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (37))){
var inst_24926 = (state_25212[(57)]);
var inst_24936 = (state_25212[(2)]);
var inst_24937 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24926);
var state_25212__$1 = (function (){var statearr_25396 = state_25212;
(statearr_25396[(24)] = inst_24936);

return statearr_25396;
})();
if(inst_24937){
var statearr_25397_25567 = state_25212__$1;
(statearr_25397_25567[(1)] = (39));

} else {
var statearr_25398_25568 = state_25212__$1;
(statearr_25398_25568[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (63))){
var inst_24981 = (state_25212[(23)]);
var inst_24936 = (state_25212[(24)]);
var inst_24963 = (state_25212[(26)]);
var inst_24840 = (state_25212[(30)]);
var inst_24984 = (state_25212[(8)]);
var inst_24892 = (state_25212[(34)]);
var inst_24847 = (state_25212[(36)]);
var inst_24883 = (state_25212[(37)]);
var inst_24972 = (state_25212[(41)]);
var inst_24954 = (state_25212[(43)]);
var inst_24841 = (state_25212[(44)]);
var inst_24848 = (state_25212[(48)]);
var inst_24945 = (state_25212[(50)]);
var inst_24981__$1 = (state_25212[(2)]);
var inst_24982 = fluree.db.flake.__GT_Flake.call(null,inst_24883,inst_24954,inst_24936,inst_24840,inst_24841,inst_24972);
var inst_24983 = fluree.db.flake.__GT_Flake.call(null,inst_24892,inst_24963,inst_24945,inst_24847,inst_24848,inst_24981__$1);
var inst_24984__$1 = opts;
var inst_24986 = (inst_24984__$1 == null);
var inst_24987 = cljs.core.not.call(null,inst_24986);
var state_25212__$1 = (function (){var statearr_25399 = state_25212;
(statearr_25399[(23)] = inst_24981__$1);

(statearr_25399[(27)] = inst_24982);

(statearr_25399[(8)] = inst_24984__$1);

(statearr_25399[(46)] = inst_24983);

return statearr_25399;
})();
if(inst_24987){
var statearr_25400_25569 = state_25212__$1;
(statearr_25400_25569[(1)] = (67));

} else {
var statearr_25401_25570 = state_25212__$1;
(statearr_25401_25570[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (94))){
var inst_24927 = (state_25212[(51)]);
var inst_25066 = (state_25212[(2)]);
var state_25212__$1 = (function (){var statearr_25402 = state_25212;
(statearr_25402[(62)] = inst_25066);

return statearr_25402;
})();
if(cljs.core.truth_(inst_24927)){
var statearr_25403_25571 = state_25212__$1;
(statearr_25403_25571[(1)] = (95));

} else {
var statearr_25404_25572 = state_25212__$1;
(statearr_25404_25572[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (8))){
var inst_24866 = (state_25212[(2)]);
var state_25212__$1 = state_25212;
if(cljs.core.truth_(inst_24866)){
var statearr_25405_25573 = state_25212__$1;
(statearr_25405_25573[(1)] = (12));

} else {
var statearr_25406_25574 = state_25212__$1;
(statearr_25406_25574[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (49))){
var inst_24945 = (state_25212[(50)]);
var state_25212__$1 = state_25212;
var statearr_25407_25575 = state_25212__$1;
(statearr_25407_25575[(2)] = inst_24945);

(statearr_25407_25575[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25213 === (84))){
var inst_24982 = (state_25212[(27)]);
var inst_25036 = (state_25212[(42)]);
var inst_24983 = (state_25212[(46)]);
var inst_25045 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_25036);
var inst_25046 = fluree.db.flake.subrange.call(null,inst_25045,start_test,inst_24982,end_test,inst_24983);
var inst_25048 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_24982,inst_24983);
var state_25212__$1 = (function (){var statearr_25408 = state_25212;
(statearr_25408[(39)] = inst_25046);

return statearr_25408;
})();
if(inst_25048){
var statearr_25409_25576 = state_25212__$1;
(statearr_25409_25576[(1)] = (86));

} else {
var statearr_25410_25577 = state_25212__$1;
(statearr_25410_25577[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__11469__auto__ = null;
var fluree$db$query$range$state_machine__11469__auto____0 = (function (){
var statearr_25411 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25411[(0)] = fluree$db$query$range$state_machine__11469__auto__);

(statearr_25411[(1)] = (1));

return statearr_25411;
});
var fluree$db$query$range$state_machine__11469__auto____1 = (function (state_25212){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_25212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e25412){var ex__11472__auto__ = e25412;
var statearr_25413_25578 = state_25212;
(statearr_25413_25578[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_25212[(4)]))){
var statearr_25414_25579 = state_25212;
(statearr_25414_25579[(1)] = cljs.core.first.call(null,(state_25212[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25580 = state_25212;
state_25212 = G__25580;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__11469__auto__ = function(state_25212){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__11469__auto____1.call(this,state_25212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__11469__auto____0;
fluree$db$query$range$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__11469__auto____1;
return fluree$db$query$range$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_25415 = f__11543__auto__.call(null);
(statearr_25415[(6)] = c__11542__auto__);

return statearr_25415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_25636){
var state_val_25637 = (state_25636[(1)]);
if((state_val_25637 === (7))){
var inst_25600 = (state_25636[(7)]);
var inst_25610 = (state_25636[(8)]);
var inst_25608 = fluree.db.flake.Flake__GT_parts.call(null,inst_25600);
var inst_25609 = cljs.core.nth.call(null,inst_25608,(0),null);
var inst_25610__$1 = cljs.core.nth.call(null,inst_25608,(1),null);
var inst_25611 = cljs.core.nth.call(null,inst_25608,(2),null);
var inst_25612 = cljs.core.nth.call(null,inst_25608,(3),null);
var inst_25613 = cljs.core.nth.call(null,inst_25608,(4),null);
var inst_25614 = cljs.core.nth.call(null,inst_25608,(5),null);
var inst_25615 = fluree.db.dbproto._tag.call(null,db,inst_25611,inst_25610__$1);
var state_25636__$1 = (function (){var statearr_25638 = state_25636;
(statearr_25638[(9)] = inst_25609);

(statearr_25638[(10)] = inst_25612);

(statearr_25638[(11)] = inst_25613);

(statearr_25638[(8)] = inst_25610__$1);

(statearr_25638[(12)] = inst_25614);

return statearr_25638;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25636__$1,(10),inst_25615);
} else {
if((state_val_25637 === (1))){
var inst_25588 = flakes;
var inst_25589 = cljs.core.seq.call(null,inst_25588);
var inst_25590 = cljs.core.first.call(null,inst_25589);
var inst_25591 = cljs.core.next.call(null,inst_25589);
var inst_25592 = cljs.core.PersistentVector.EMPTY;
var inst_25593 = inst_25588;
var inst_25594 = inst_25592;
var state_25636__$1 = (function (){var statearr_25639 = state_25636;
(statearr_25639[(13)] = inst_25591);

(statearr_25639[(14)] = inst_25593);

(statearr_25639[(15)] = inst_25594);

(statearr_25639[(16)] = inst_25590);

return statearr_25639;
})();
var statearr_25640_25658 = state_25636__$1;
(statearr_25640_25658[(2)] = null);

(statearr_25640_25658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25637 === (4))){
var inst_25600 = (state_25636[(7)]);
var inst_25603 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_25600);
var state_25636__$1 = state_25636;
if(inst_25603){
var statearr_25641_25659 = state_25636__$1;
(statearr_25641_25659[(1)] = (7));

} else {
var statearr_25642_25660 = state_25636__$1;
(statearr_25642_25660[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25637 === (6))){
var inst_25632 = (state_25636[(2)]);
var state_25636__$1 = state_25636;
var statearr_25643_25661 = state_25636__$1;
(statearr_25643_25661[(2)] = inst_25632);

(statearr_25643_25661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25637 === (3))){
var inst_25634 = (state_25636[(2)]);
var state_25636__$1 = state_25636;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25636__$1,inst_25634);
} else {
if((state_val_25637 === (2))){
var inst_25600 = (state_25636[(7)]);
var inst_25593 = (state_25636[(14)]);
var inst_25599 = cljs.core.seq.call(null,inst_25593);
var inst_25600__$1 = cljs.core.first.call(null,inst_25599);
var inst_25601 = cljs.core.next.call(null,inst_25599);
var state_25636__$1 = (function (){var statearr_25644 = state_25636;
(statearr_25644[(7)] = inst_25600__$1);

(statearr_25644[(17)] = inst_25601);

return statearr_25644;
})();
if(cljs.core.truth_(inst_25600__$1)){
var statearr_25645_25662 = state_25636__$1;
(statearr_25645_25662[(1)] = (4));

} else {
var statearr_25646_25663 = state_25636__$1;
(statearr_25646_25663[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25637 === (9))){
var inst_25629 = (state_25636[(2)]);
var state_25636__$1 = state_25636;
var statearr_25647_25664 = state_25636__$1;
(statearr_25647_25664[(2)] = inst_25629);

(statearr_25647_25664[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25637 === (5))){
var inst_25594 = (state_25636[(15)]);
var state_25636__$1 = state_25636;
var statearr_25648_25665 = state_25636__$1;
(statearr_25648_25665[(2)] = inst_25594);

(statearr_25648_25665[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25637 === (10))){
var inst_25609 = (state_25636[(9)]);
var inst_25612 = (state_25636[(10)]);
var inst_25601 = (state_25636[(17)]);
var inst_25613 = (state_25636[(11)]);
var inst_25594 = (state_25636[(15)]);
var inst_25610 = (state_25636[(8)]);
var inst_25614 = (state_25636[(12)]);
var inst_25617 = (state_25636[(2)]);
var inst_25618 = fluree.db.util.async.throw_err.call(null,inst_25617);
var inst_25619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25620 = [inst_25609,inst_25610,inst_25618,inst_25612,inst_25613,inst_25614];
var inst_25621 = (new cljs.core.PersistentVector(null,6,(5),inst_25619,inst_25620,null));
var inst_25622 = fluree.db.flake.parts__GT_Flake.call(null,inst_25621);
var inst_25623 = cljs.core.conj.call(null,inst_25594,inst_25622);
var inst_25593 = inst_25601;
var inst_25594__$1 = inst_25623;
var state_25636__$1 = (function (){var statearr_25649 = state_25636;
(statearr_25649[(14)] = inst_25593);

(statearr_25649[(15)] = inst_25594__$1);

return statearr_25649;
})();
var statearr_25650_25666 = state_25636__$1;
(statearr_25650_25666[(2)] = null);

(statearr_25650_25666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25637 === (8))){
var inst_25600 = (state_25636[(7)]);
var inst_25601 = (state_25636[(17)]);
var inst_25594 = (state_25636[(15)]);
var inst_25626 = cljs.core.conj.call(null,inst_25594,inst_25600);
var inst_25593 = inst_25601;
var inst_25594__$1 = inst_25626;
var state_25636__$1 = (function (){var statearr_25651 = state_25636;
(statearr_25651[(14)] = inst_25593);

(statearr_25651[(15)] = inst_25594__$1);

return statearr_25651;
})();
var statearr_25652_25667 = state_25636__$1;
(statearr_25652_25667[(2)] = null);

(statearr_25652_25667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__11469__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__11469__auto____0 = (function (){
var statearr_25653 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25653[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__11469__auto__);

(statearr_25653[(1)] = (1));

return statearr_25653;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__11469__auto____1 = (function (state_25636){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_25636);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e25654){var ex__11472__auto__ = e25654;
var statearr_25655_25668 = state_25636;
(statearr_25655_25668[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_25636[(4)]))){
var statearr_25656_25669 = state_25636;
(statearr_25656_25669[(1)] = cljs.core.first.call(null,(state_25636[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25670 = state_25636;
state_25636 = G__25670;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__11469__auto__ = function(state_25636){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__11469__auto____1.call(this,state_25636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__11469__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__11469__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_25657 = f__11543__auto__.call(null);
(statearr_25657[(6)] = c__11542__auto__);

return statearr_25657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__25672 = arguments.length;
switch (G__25672) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_25823){
var state_val_25824 = (state_25823[(1)]);
if((state_val_25824 === (62))){
var inst_25810 = (state_25823[(7)]);
var state_25823__$1 = state_25823;
var statearr_25825_25914 = state_25823__$1;
(statearr_25825_25914[(2)] = inst_25810);

(statearr_25825_25914[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (7))){
var state_25823__$1 = state_25823;
var statearr_25826_25915 = state_25823__$1;
(statearr_25826_25915[(2)] = false);

(statearr_25826_25915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (59))){
var inst_25802 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
var statearr_25827_25916 = state_25823__$1;
(statearr_25827_25916[(2)] = inst_25802);

(statearr_25827_25916[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (20))){
var state_25823__$1 = state_25823;
var statearr_25828_25917 = state_25823__$1;
(statearr_25828_25917[(2)] = null);

(statearr_25828_25917[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (58))){
var state_25823__$1 = state_25823;
var statearr_25829_25918 = state_25823__$1;
(statearr_25829_25918[(2)] = null);

(statearr_25829_25918[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (60))){
var inst_25798 = (state_25823[(2)]);
var inst_25799 = fluree.db.util.async.throw_err.call(null,inst_25798);
var state_25823__$1 = state_25823;
var statearr_25830_25919 = state_25823__$1;
(statearr_25830_25919[(2)] = inst_25799);

(statearr_25830_25919[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (27))){
var inst_25723 = (state_25823[(8)]);
var inst_25734 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_25723);
var state_25823__$1 = state_25823;
if(inst_25734){
var statearr_25831_25920 = state_25823__$1;
(statearr_25831_25920[(1)] = (30));

} else {
var statearr_25832_25921 = state_25823__$1;
(statearr_25832_25921[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (1))){
var state_25823__$1 = state_25823;
var statearr_25833_25922 = state_25823__$1;
(statearr_25833_25922[(2)] = null);

(statearr_25833_25922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (24))){
var inst_25684 = (state_25823[(9)]);
var state_25823__$1 = state_25823;
if(cljs.core.truth_(inst_25684)){
var statearr_25834_25923 = state_25823__$1;
(statearr_25834_25923[(1)] = (27));

} else {
var statearr_25835_25924 = state_25823__$1;
(statearr_25835_25924[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (55))){
var inst_25804 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
var statearr_25836_25925 = state_25823__$1;
(statearr_25836_25925[(2)] = inst_25804);

(statearr_25836_25925[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (39))){
var inst_25754 = (state_25823[(2)]);
var inst_25755 = fluree.db.util.async.throw_err.call(null,inst_25754);
var state_25823__$1 = state_25823;
var statearr_25837_25926 = state_25823__$1;
(statearr_25837_25926[(2)] = inst_25755);

(statearr_25837_25926[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (46))){
var inst_25767 = (state_25823[(10)]);
var inst_25767__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_25823__$1 = (function (){var statearr_25838 = state_25823;
(statearr_25838[(10)] = inst_25767__$1);

return statearr_25838;
})();
if(cljs.core.truth_(inst_25767__$1)){
var statearr_25839_25927 = state_25823__$1;
(statearr_25839_25927[(1)] = (49));

} else {
var statearr_25840_25928 = state_25823__$1;
(statearr_25840_25928[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (4))){
var inst_25673 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
var statearr_25841_25929 = state_25823__$1;
(statearr_25841_25929[(2)] = inst_25673);

(statearr_25841_25929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (54))){
var inst_25723 = (state_25823[(8)]);
var state_25823__$1 = state_25823;
if(cljs.core.truth_(inst_25723)){
var statearr_25842_25930 = state_25823__$1;
(statearr_25842_25930[(1)] = (57));

} else {
var statearr_25843_25931 = state_25823__$1;
(statearr_25843_25931[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (15))){
var inst_25685 = (state_25823[(11)]);
var inst_25704 = fluree.db.dbproto._tag_id.call(null,db,inst_25685);
var state_25823__$1 = state_25823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25823__$1,(18),inst_25704);
} else {
if((state_val_25824 === (48))){
var inst_25806 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
var statearr_25844_25932 = state_25823__$1;
(statearr_25844_25932[(2)] = inst_25806);

(statearr_25844_25932[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (50))){
var inst_25693 = (state_25823[(12)]);
var inst_25684 = (state_25823[(9)]);
var inst_25686 = (state_25823[(13)]);
var inst_25698 = (state_25823[(14)]);
var inst_25767 = (state_25823[(10)]);
var inst_25687 = (state_25823[(15)]);
var inst_25723 = (state_25823[(8)]);
var inst_25682 = (state_25823[(16)]);
var inst_25683 = (state_25823[(17)]);
var inst_25771 = (function (){var t = inst_25686;
var temp__5733__auto__ = inst_25767;
var p = inst_25684;
var idx_predicate_QMARK_ = inst_25687;
var o = inst_25723;
var tag_predicate_QMARK_ = inst_25693;
var s = inst_25683;
var o_coerce_QMARK_ = inst_25698;
var vec__25679 = inst_25682;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_25823__$1 = state_25823;
var statearr_25845_25933 = state_25823__$1;
(statearr_25845_25933[(2)] = inst_25771);

(statearr_25845_25933[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (21))){
var inst_25719 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
var statearr_25846_25934 = state_25823__$1;
(statearr_25846_25934[(2)] = inst_25719);

(statearr_25846_25934[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (31))){
var state_25823__$1 = state_25823;
var statearr_25847_25935 = state_25823__$1;
(statearr_25847_25935[(2)] = false);

(statearr_25847_25935[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (32))){
var inst_25744 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
var statearr_25848_25936 = state_25823__$1;
(statearr_25848_25936[(2)] = inst_25744);

(statearr_25848_25936[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (40))){
var inst_25687 = (state_25823[(15)]);
var inst_25758 = cljs.core.not.call(null,inst_25687);
var state_25823__$1 = state_25823;
if(inst_25758){
var statearr_25849_25937 = state_25823__$1;
(statearr_25849_25937[(1)] = (43));

} else {
var statearr_25850_25938 = state_25823__$1;
(statearr_25850_25938[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (56))){
var inst_25789 = (state_25823[(2)]);
var inst_25790 = fluree.db.util.async.throw_err.call(null,inst_25789);
var state_25823__$1 = state_25823;
var statearr_25851_25939 = state_25823__$1;
(statearr_25851_25939[(2)] = inst_25790);

(statearr_25851_25939[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (33))){
var inst_25723 = (state_25823[(8)]);
var inst_25737 = cljs.core.fn_QMARK_.call(null,inst_25723);
var inst_25738 = (!(inst_25737));
var state_25823__$1 = state_25823;
var statearr_25852_25940 = state_25823__$1;
(statearr_25852_25940[(2)] = inst_25738);

(statearr_25852_25940[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (13))){
var inst_25685 = (state_25823[(11)]);
var inst_25702 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_25685);
var state_25823__$1 = state_25823;
if(cljs.core.truth_(inst_25702)){
var statearr_25853_25941 = state_25823__$1;
(statearr_25853_25941[(1)] = (15));

} else {
var statearr_25854_25942 = state_25823__$1;
(statearr_25854_25942[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (22))){
var inst_25715 = (state_25823[(2)]);
var inst_25716 = fluree.db.util.async.throw_err.call(null,inst_25715);
var state_25823__$1 = state_25823;
var statearr_25855_25943 = state_25823__$1;
(statearr_25855_25943[(2)] = inst_25716);

(statearr_25855_25943[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (36))){
var inst_25684 = (state_25823[(9)]);
var inst_25686 = (state_25823[(13)]);
var inst_25723 = (state_25823[(8)]);
var inst_25683 = (state_25823[(17)]);
var inst_25749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25750 = [inst_25684,inst_25723,inst_25683,inst_25686];
var inst_25751 = (new cljs.core.PersistentVector(null,4,(5),inst_25749,inst_25750,null));
var inst_25752 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_25751,opts);
var state_25823__$1 = state_25823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25823__$1,(39),inst_25752);
} else {
if((state_val_25824 === (41))){
var inst_25684 = (state_25823[(9)]);
var state_25823__$1 = state_25823;
var statearr_25856_25944 = state_25823__$1;
(statearr_25856_25944[(2)] = inst_25684);

(statearr_25856_25944[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (43))){
var inst_25723 = (state_25823[(8)]);
var state_25823__$1 = state_25823;
var statearr_25857_25945 = state_25823__$1;
(statearr_25857_25945[(2)] = inst_25723);

(statearr_25857_25945[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (61))){
var inst_25810 = (state_25823[(7)]);
var inst_25812 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_25810);
var state_25823__$1 = state_25823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25823__$1,(64),inst_25812);
} else {
if((state_val_25824 === (29))){
var inst_25747 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
if(cljs.core.truth_(inst_25747)){
var statearr_25858_25946 = state_25823__$1;
(statearr_25858_25946[(1)] = (36));

} else {
var statearr_25859_25947 = state_25823__$1;
(statearr_25859_25947[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (44))){
var state_25823__$1 = state_25823;
var statearr_25860_25948 = state_25823__$1;
(statearr_25860_25948[(2)] = false);

(statearr_25860_25948[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (6))){
var inst_25684 = (state_25823[(9)]);
var inst_25689 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_25684);
var inst_25690 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_25689);
var state_25823__$1 = state_25823;
var statearr_25861_25949 = state_25823__$1;
(statearr_25861_25949[(2)] = inst_25690);

(statearr_25861_25949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (28))){
var inst_25684 = (state_25823[(9)]);
var state_25823__$1 = state_25823;
var statearr_25862_25950 = state_25823__$1;
(statearr_25862_25950[(2)] = inst_25684);

(statearr_25862_25950[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (64))){
var inst_25814 = (state_25823[(2)]);
var inst_25815 = fluree.db.util.async.throw_err.call(null,inst_25814);
var state_25823__$1 = state_25823;
var statearr_25863_25951 = state_25823__$1;
(statearr_25863_25951[(2)] = inst_25815);

(statearr_25863_25951[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (51))){
var inst_25684 = (state_25823[(9)]);
var inst_25686 = (state_25823[(13)]);
var inst_25683 = (state_25823[(17)]);
var inst_25773 = (state_25823[(2)]);
var inst_25774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25775 = [inst_25684,inst_25683,null,inst_25686];
var inst_25776 = (new cljs.core.PersistentVector(null,4,(5),inst_25774,inst_25775,null));
var inst_25777 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_25773);
var inst_25778 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25776,inst_25777);
var state_25823__$1 = state_25823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25823__$1,(52),inst_25778);
} else {
if((state_val_25824 === (25))){
var inst_25693 = (state_25823[(12)]);
var inst_25810 = (state_25823[(2)]);
var state_25823__$1 = (function (){var statearr_25864 = state_25823;
(statearr_25864[(7)] = inst_25810);

return statearr_25864;
})();
if(cljs.core.truth_(inst_25693)){
var statearr_25865_25952 = state_25823__$1;
(statearr_25865_25952[(1)] = (61));

} else {
var statearr_25866_25953 = state_25823__$1;
(statearr_25866_25953[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (34))){
var inst_25687 = (state_25823[(15)]);
var state_25823__$1 = state_25823;
var statearr_25867_25954 = state_25823__$1;
(statearr_25867_25954[(2)] = inst_25687);

(statearr_25867_25954[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (17))){
var inst_25721 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
var statearr_25868_25955 = state_25823__$1;
(statearr_25868_25955[(2)] = inst_25721);

(statearr_25868_25955[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (3))){
var inst_25821 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25823__$1,inst_25821);
} else {
if((state_val_25824 === (12))){
var inst_25685 = (state_25823[(11)]);
var state_25823__$1 = state_25823;
var statearr_25869_25956 = state_25823__$1;
(statearr_25869_25956[(2)] = inst_25685);

(statearr_25869_25956[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (2))){
var inst_25684 = (state_25823[(9)]);
var inst_25682 = (state_25823[(16)]);
var _ = (function (){var statearr_25870 = state_25823;
(statearr_25870[(4)] = cljs.core.cons.call(null,(5),(state_25823[(4)])));

return statearr_25870;
})();
var inst_25682__$1 = fparts;
var inst_25683 = cljs.core.nth.call(null,inst_25682__$1,(0),null);
var inst_25684__$1 = cljs.core.nth.call(null,inst_25682__$1,(1),null);
var inst_25685 = cljs.core.nth.call(null,inst_25682__$1,(2),null);
var inst_25686 = cljs.core.nth.call(null,inst_25682__$1,(3),null);
var inst_25687 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_25684__$1);
var state_25823__$1 = (function (){var statearr_25871 = state_25823;
(statearr_25871[(11)] = inst_25685);

(statearr_25871[(9)] = inst_25684__$1);

(statearr_25871[(13)] = inst_25686);

(statearr_25871[(15)] = inst_25687);

(statearr_25871[(16)] = inst_25682__$1);

(statearr_25871[(17)] = inst_25683);

return statearr_25871;
})();
if(cljs.core.truth_(inst_25684__$1)){
var statearr_25872_25957 = state_25823__$1;
(statearr_25872_25957[(1)] = (6));

} else {
var statearr_25873_25958 = state_25823__$1;
(statearr_25873_25958[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (23))){
var inst_25684 = (state_25823[(9)]);
var inst_25686 = (state_25823[(13)]);
var inst_25723 = (state_25823[(8)]);
var inst_25683 = (state_25823[(17)]);
var inst_25725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25726 = [inst_25683,inst_25684,inst_25723,inst_25686];
var inst_25727 = (new cljs.core.PersistentVector(null,4,(5),inst_25725,inst_25726,null));
var inst_25728 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_25727,opts);
var state_25823__$1 = state_25823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25823__$1,(26),inst_25728);
} else {
if((state_val_25824 === (47))){
var inst_25684 = (state_25823[(9)]);
var state_25823__$1 = state_25823;
if(cljs.core.truth_(inst_25684)){
var statearr_25874_25959 = state_25823__$1;
(statearr_25874_25959[(1)] = (53));

} else {
var statearr_25875_25960 = state_25823__$1;
(statearr_25875_25960[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (35))){
var inst_25741 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
var statearr_25876_25961 = state_25823__$1;
(statearr_25876_25961[(2)] = inst_25741);

(statearr_25876_25961[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (19))){
var inst_25685 = (state_25823[(11)]);
var inst_25684 = (state_25823[(9)]);
var inst_25711 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_25684);
var inst_25712 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25711),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25685)].join('');
var inst_25713 = fluree.db.dbproto._tag_id.call(null,db,inst_25712);
var state_25823__$1 = state_25823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25823__$1,(22),inst_25713);
} else {
if((state_val_25824 === (57))){
var inst_25684 = (state_25823[(9)]);
var inst_25686 = (state_25823[(13)]);
var inst_25723 = (state_25823[(8)]);
var inst_25683 = (state_25823[(17)]);
var inst_25793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25794 = [inst_25723,inst_25684,inst_25683,inst_25686];
var inst_25795 = (new cljs.core.PersistentVector(null,4,(5),inst_25793,inst_25794,null));
var inst_25796 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_25795,opts);
var state_25823__$1 = state_25823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25823__$1,(60),inst_25796);
} else {
if((state_val_25824 === (11))){
var inst_25698 = (state_25823[(14)]);
var inst_25698__$1 = (state_25823[(2)]);
var inst_25699 = cljs.core.not.call(null,inst_25698__$1);
var state_25823__$1 = (function (){var statearr_25878 = state_25823;
(statearr_25878[(14)] = inst_25698__$1);

return statearr_25878;
})();
if(inst_25699){
var statearr_25879_25962 = state_25823__$1;
(statearr_25879_25962[(1)] = (12));

} else {
var statearr_25880_25963 = state_25823__$1;
(statearr_25880_25963[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (9))){
var inst_25685 = (state_25823[(11)]);
var inst_25695 = typeof inst_25685 === 'string';
var state_25823__$1 = state_25823;
var statearr_25881_25964 = state_25823__$1;
(statearr_25881_25964[(2)] = inst_25695);

(statearr_25881_25964[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (5))){
var _ = (function (){var statearr_25882 = state_25823;
(statearr_25882[(4)] = cljs.core.rest.call(null,(state_25823[(4)])));

return statearr_25882;
})();
var state_25823__$1 = state_25823;
var ex25877 = (state_25823__$1[(2)]);
var statearr_25883_25965 = state_25823__$1;
(statearr_25883_25965[(5)] = ex25877);


if((ex25877 instanceof Error)){
var statearr_25884_25966 = state_25823__$1;
(statearr_25884_25966[(1)] = (4));

(statearr_25884_25966[(5)] = null);

} else {
throw ex25877;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (14))){
var inst_25683 = (state_25823[(17)]);
var inst_25723 = (state_25823[(2)]);
var state_25823__$1 = (function (){var statearr_25885 = state_25823;
(statearr_25885[(8)] = inst_25723);

return statearr_25885;
})();
if(cljs.core.truth_(inst_25683)){
var statearr_25886_25967 = state_25823__$1;
(statearr_25886_25967[(1)] = (23));

} else {
var statearr_25887_25968 = state_25823__$1;
(statearr_25887_25968[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (45))){
var inst_25762 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
var statearr_25888_25969 = state_25823__$1;
(statearr_25888_25969[(2)] = inst_25762);

(statearr_25888_25969[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (53))){
var inst_25684 = (state_25823[(9)]);
var inst_25686 = (state_25823[(13)]);
var inst_25723 = (state_25823[(8)]);
var inst_25683 = (state_25823[(17)]);
var inst_25784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25785 = [inst_25684,inst_25683,inst_25723,inst_25686];
var inst_25786 = (new cljs.core.PersistentVector(null,4,(5),inst_25784,inst_25785,null));
var inst_25787 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25786,opts);
var state_25823__$1 = state_25823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25823__$1,(56),inst_25787);
} else {
if((state_val_25824 === (26))){
var inst_25730 = (state_25823[(2)]);
var inst_25731 = fluree.db.util.async.throw_err.call(null,inst_25730);
var state_25823__$1 = state_25823;
var statearr_25889_25970 = state_25823__$1;
(statearr_25889_25970[(2)] = inst_25731);

(statearr_25889_25970[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (16))){
var inst_25685 = (state_25823[(11)]);
var inst_25709 = typeof inst_25685 === 'string';
var state_25823__$1 = state_25823;
if(cljs.core.truth_(inst_25709)){
var statearr_25890_25971 = state_25823__$1;
(statearr_25890_25971[(1)] = (19));

} else {
var statearr_25891_25972 = state_25823__$1;
(statearr_25891_25972[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (38))){
var inst_25808 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
var statearr_25892_25973 = state_25823__$1;
(statearr_25892_25973[(2)] = inst_25808);

(statearr_25892_25973[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (30))){
var inst_25687 = (state_25823[(15)]);
var state_25823__$1 = state_25823;
if(cljs.core.truth_(inst_25687)){
var statearr_25893_25974 = state_25823__$1;
(statearr_25893_25974[(1)] = (33));

} else {
var statearr_25894_25975 = state_25823__$1;
(statearr_25894_25975[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (10))){
var inst_25693 = (state_25823[(12)]);
var state_25823__$1 = state_25823;
var statearr_25895_25976 = state_25823__$1;
(statearr_25895_25976[(2)] = inst_25693);

(statearr_25895_25976[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (18))){
var inst_25706 = (state_25823[(2)]);
var inst_25707 = fluree.db.util.async.throw_err.call(null,inst_25706);
var state_25823__$1 = state_25823;
var statearr_25896_25977 = state_25823__$1;
(statearr_25896_25977[(2)] = inst_25707);

(statearr_25896_25977[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (52))){
var inst_25780 = (state_25823[(2)]);
var inst_25781 = fluree.db.util.async.throw_err.call(null,inst_25780);
var state_25823__$1 = state_25823;
var statearr_25897_25978 = state_25823__$1;
(statearr_25897_25978[(2)] = inst_25781);

(statearr_25897_25978[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (42))){
var inst_25765 = (state_25823[(2)]);
var state_25823__$1 = state_25823;
if(cljs.core.truth_(inst_25765)){
var statearr_25898_25979 = state_25823__$1;
(statearr_25898_25979[(1)] = (46));

} else {
var statearr_25899_25980 = state_25823__$1;
(statearr_25899_25980[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (37))){
var inst_25684 = (state_25823[(9)]);
var state_25823__$1 = state_25823;
if(cljs.core.truth_(inst_25684)){
var statearr_25900_25981 = state_25823__$1;
(statearr_25900_25981[(1)] = (40));

} else {
var statearr_25901_25982 = state_25823__$1;
(statearr_25901_25982[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (63))){
var inst_25818 = (state_25823[(2)]);
var _ = (function (){var statearr_25902 = state_25823;
(statearr_25902[(4)] = cljs.core.rest.call(null,(state_25823[(4)])));

return statearr_25902;
})();
var state_25823__$1 = state_25823;
var statearr_25903_25983 = state_25823__$1;
(statearr_25903_25983[(2)] = inst_25818);

(statearr_25903_25983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (8))){
var inst_25693 = (state_25823[(12)]);
var inst_25693__$1 = (state_25823[(2)]);
var state_25823__$1 = (function (){var statearr_25904 = state_25823;
(statearr_25904[(12)] = inst_25693__$1);

return statearr_25904;
})();
if(cljs.core.truth_(inst_25693__$1)){
var statearr_25905_25984 = state_25823__$1;
(statearr_25905_25984[(1)] = (9));

} else {
var statearr_25906_25985 = state_25823__$1;
(statearr_25906_25985[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25824 === (49))){
var inst_25693 = (state_25823[(12)]);
var inst_25684 = (state_25823[(9)]);
var inst_25686 = (state_25823[(13)]);
var inst_25698 = (state_25823[(14)]);
var inst_25767 = (state_25823[(10)]);
var inst_25687 = (state_25823[(15)]);
var inst_25723 = (state_25823[(8)]);
var inst_25682 = (state_25823[(16)]);
var inst_25683 = (state_25823[(17)]);
var inst_25769 = (function (){var obj_fn = inst_25767;
var t = inst_25686;
var temp__5733__auto__ = inst_25767;
var p = inst_25684;
var idx_predicate_QMARK_ = inst_25687;
var o = inst_25723;
var tag_predicate_QMARK_ = inst_25693;
var s = inst_25683;
var o_coerce_QMARK_ = inst_25698;
var vec__25679 = inst_25682;
return (function (x){
var and__4115__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_25823__$1 = state_25823;
var statearr_25907_25986 = state_25823__$1;
(statearr_25907_25986[(2)] = inst_25769);

(statearr_25907_25986[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__11469__auto__ = null;
var fluree$db$query$range$state_machine__11469__auto____0 = (function (){
var statearr_25908 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25908[(0)] = fluree$db$query$range$state_machine__11469__auto__);

(statearr_25908[(1)] = (1));

return statearr_25908;
});
var fluree$db$query$range$state_machine__11469__auto____1 = (function (state_25823){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_25823);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e25909){var ex__11472__auto__ = e25909;
var statearr_25910_25987 = state_25823;
(statearr_25910_25987[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_25823[(4)]))){
var statearr_25911_25988 = state_25823;
(statearr_25911_25988[(1)] = cljs.core.first.call(null,(state_25823[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25989 = state_25823;
state_25823 = G__25989;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__11469__auto__ = function(state_25823){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__11469__auto____1.call(this,state_25823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__11469__auto____0;
fluree$db$query$range$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__11469__auto____1;
return fluree$db$query$range$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_25912 = f__11543__auto__.call(null);
(statearr_25912[(6)] = c__11542__auto__);

return statearr_25912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__25991 = arguments.length;
switch (G__25991) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_26026){
var state_val_26027 = (state_26026[(1)]);
if((state_val_26027 === (7))){
var inst_26013 = cljs.core.pr_str.call(null,name);
var inst_26014 = ["Invalid collection name: ",inst_26013].join('');
var inst_26015 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26016 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_26017 = cljs.core.PersistentHashMap.fromArrays(inst_26015,inst_26016);
var inst_26018 = cljs.core.ex_info.call(null,inst_26014,inst_26017);
var inst_26019 = (function(){throw inst_26018})();
var state_26026__$1 = state_26026;
var statearr_26028_26048 = state_26026__$1;
(statearr_26028_26048[(2)] = inst_26019);

(statearr_26028_26048[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (1))){
var state_26026__$1 = state_26026;
var statearr_26029_26049 = state_26026__$1;
(statearr_26029_26049[(2)] = null);

(statearr_26029_26049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (4))){
var inst_25992 = (state_26026[(2)]);
var state_26026__$1 = state_26026;
var statearr_26030_26050 = state_26026__$1;
(statearr_26030_26050[(2)] = inst_25992);

(statearr_26030_26050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (6))){
var inst_25998 = (state_26026[(7)]);
var inst_26000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26001 = fluree.db.flake.max_subject_id.call(null,inst_25998);
var inst_26002 = [inst_26001];
var inst_26003 = (new cljs.core.PersistentVector(null,1,(5),inst_26000,inst_26002,null));
var inst_26004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26005 = fluree.db.flake.min_subject_id.call(null,inst_25998);
var inst_26006 = [inst_26005];
var inst_26007 = (new cljs.core.PersistentVector(null,1,(5),inst_26004,inst_26006,null));
var inst_26008 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_26003,cljs.core._LT__EQ_,inst_26007,opts);
var state_26026__$1 = state_26026;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26026__$1,(9),inst_26008);
} else {
if((state_val_26027 === (3))){
var inst_26024 = (state_26026[(2)]);
var state_26026__$1 = state_26026;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26026__$1,inst_26024);
} else {
if((state_val_26027 === (2))){
var inst_25998 = (state_26026[(7)]);
var _ = (function (){var statearr_26032 = state_26026;
(statearr_26032[(4)] = cljs.core.cons.call(null,(5),(state_26026[(4)])));

return statearr_26032;
})();
var inst_25998__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_26026__$1 = (function (){var statearr_26033 = state_26026;
(statearr_26033[(7)] = inst_25998__$1);

return statearr_26033;
})();
if(cljs.core.truth_(inst_25998__$1)){
var statearr_26034_26051 = state_26026__$1;
(statearr_26034_26051[(1)] = (6));

} else {
var statearr_26035_26052 = state_26026__$1;
(statearr_26035_26052[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (9))){
var inst_26010 = (state_26026[(2)]);
var inst_26011 = fluree.db.util.async.throw_err.call(null,inst_26010);
var state_26026__$1 = state_26026;
var statearr_26036_26053 = state_26026__$1;
(statearr_26036_26053[(2)] = inst_26011);

(statearr_26036_26053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (5))){
var _ = (function (){var statearr_26037 = state_26026;
(statearr_26037[(4)] = cljs.core.rest.call(null,(state_26026[(4)])));

return statearr_26037;
})();
var state_26026__$1 = state_26026;
var ex26031 = (state_26026__$1[(2)]);
var statearr_26038_26054 = state_26026__$1;
(statearr_26038_26054[(5)] = ex26031);


var statearr_26039_26055 = state_26026__$1;
(statearr_26039_26055[(1)] = (4));

(statearr_26039_26055[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (8))){
var inst_26021 = (state_26026[(2)]);
var _ = (function (){var statearr_26040 = state_26026;
(statearr_26040[(4)] = cljs.core.rest.call(null,(state_26026[(4)])));

return statearr_26040;
})();
var state_26026__$1 = state_26026;
var statearr_26041_26056 = state_26026__$1;
(statearr_26041_26056[(2)] = inst_26021);

(statearr_26041_26056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__11469__auto__ = null;
var fluree$db$query$range$state_machine__11469__auto____0 = (function (){
var statearr_26042 = [null,null,null,null,null,null,null,null];
(statearr_26042[(0)] = fluree$db$query$range$state_machine__11469__auto__);

(statearr_26042[(1)] = (1));

return statearr_26042;
});
var fluree$db$query$range$state_machine__11469__auto____1 = (function (state_26026){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_26026);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e26043){var ex__11472__auto__ = e26043;
var statearr_26044_26057 = state_26026;
(statearr_26044_26057[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_26026[(4)]))){
var statearr_26045_26058 = state_26026;
(statearr_26045_26058[(1)] = cljs.core.first.call(null,(state_26026[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26059 = state_26026;
state_26026 = G__26059;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__11469__auto__ = function(state_26026){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__11469__auto____1.call(this,state_26026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__11469__auto____0;
fluree$db$query$range$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__11469__auto____1;
return fluree$db$query$range$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_26046 = f__11543__auto__.call(null);
(statearr_26046[(6)] = c__11542__auto__);

return statearr_26046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__26063 = flakes;
var vec__26064 = G__26063;
var seq__26065 = cljs.core.seq.call(null,vec__26064);
var first__26066 = cljs.core.first.call(null,seq__26065);
var seq__26065__$1 = cljs.core.next.call(null,seq__26065);
var flake_SINGLEQUOTE_ = first__26066;
var r = seq__26065__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__26063__$1 = G__26063;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__26073 = G__26063__$1;
var seq__26074 = cljs.core.seq.call(null,vec__26073);
var first__26075 = cljs.core.first.call(null,seq__26074);
var seq__26074__$1 = cljs.core.next.call(null,seq__26074);
var flake_SINGLEQUOTE___$1 = first__26075;
var r__$1 = seq__26074__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e26077){var e = e26077;
return null;
}})();
var map__26076 = cmd_map;
var map__26076__$1 = (((((!((map__26076 == null))))?(((((map__26076.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26076.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26076):map__26076);
var type = cljs.core.get.call(null,map__26076__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__26076__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__26076__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__26076__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__26076__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__26076__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__26079 = r__$1;
var G__26080 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__26063__$1 = G__26079;
result_STAR___$1 = G__26080;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__26089 = blocks;
var vec__26090 = G__26089;
var seq__26091 = cljs.core.seq.call(null,vec__26090);
var first__26092 = cljs.core.first.call(null,seq__26091);
var seq__26091__$1 = cljs.core.next.call(null,seq__26091);
var block_SINGLEQUOTE_ = first__26092;
var r = seq__26091__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__26089__$1 = G__26089;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__26098 = G__26089__$1;
var seq__26099 = cljs.core.seq.call(null,vec__26098);
var first__26100 = cljs.core.first.call(null,seq__26099);
var seq__26099__$1 = cljs.core.next.call(null,seq__26099);
var block_SINGLEQUOTE___$1 = first__26100;
var r__$1 = seq__26099__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__26101 = block_SINGLEQUOTE___$1;
var map__26101__$1 = (((((!((map__26101 == null))))?(((((map__26101.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26101.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26101):map__26101);
var block = cljs.core.get.call(null,map__26101__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__26101__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__26101__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__26089__$1,result_STAR___$1,map__26101,map__26101__$1,block,t,flakes,vec__26098,seq__26099,first__26100,seq__26099__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26089,vec__26090,seq__26091,first__26092,seq__26091__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26081_SHARP_){
if(cljs.core._EQ_.call(null,p1__26081_SHARP_.p,(2))){
return p1__26081_SHARP_.o;
} else {
return null;
}
});})(G__26089__$1,result_STAR___$1,map__26101,map__26101__$1,block,t,flakes,vec__26098,seq__26099,first__26100,seq__26099__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26089,vec__26090,seq__26091,first__26092,seq__26091__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__26089__$1,result_STAR___$1,map__26101,map__26101__$1,block,t,flakes,prev_hash,vec__26098,seq__26099,first__26100,seq__26099__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26089,vec__26090,seq__26091,first__26092,seq__26091__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26082_SHARP_){
if(cljs.core._EQ_.call(null,p1__26082_SHARP_.p,(1))){
return p1__26082_SHARP_.o;
} else {
return null;
}
});})(G__26089__$1,result_STAR___$1,map__26101,map__26101__$1,block,t,flakes,prev_hash,vec__26098,seq__26099,first__26100,seq__26099__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26089,vec__26090,seq__26091,first__26092,seq__26091__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__26089__$1,result_STAR___$1,map__26101,map__26101__$1,block,t,flakes,prev_hash,hash,vec__26098,seq__26099,first__26100,seq__26099__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26089,vec__26090,seq__26091,first__26092,seq__26091__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26083_SHARP_){
if(cljs.core._EQ_.call(null,p1__26083_SHARP_.p,(5))){
return p1__26083_SHARP_.o;
} else {
return null;
}
});})(G__26089__$1,result_STAR___$1,map__26101,map__26101__$1,block,t,flakes,prev_hash,hash,vec__26098,seq__26099,first__26100,seq__26099__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26089,vec__26090,seq__26091,first__26092,seq__26091__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__26089__$1,result_STAR___$1,map__26101,map__26101__$1,block,t,flakes,prev_hash,hash,instant,vec__26098,seq__26099,first__26100,seq__26099__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26089,vec__26090,seq__26091,first__26092,seq__26091__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26084_SHARP_){
if(cljs.core._EQ_.call(null,p1__26084_SHARP_.p,(7))){
return p1__26084_SHARP_.o;
} else {
return null;
}
});})(G__26089__$1,result_STAR___$1,map__26101,map__26101__$1,block,t,flakes,prev_hash,hash,instant,vec__26098,seq__26099,first__26100,seq__26099__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26089,vec__26090,seq__26091,first__26092,seq__26091__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__26089__$1,result_STAR___$1,map__26101,map__26101__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__26098,seq__26099,first__26100,seq__26099__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26089,vec__26090,seq__26091,first__26092,seq__26091__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26085_SHARP_){
return cljs.core._EQ_.call(null,p1__26085_SHARP_.p,(106));
});})(G__26089__$1,result_STAR___$1,map__26101,map__26101__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__26098,seq__26099,first__26100,seq__26099__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26089,vec__26090,seq__26091,first__26092,seq__26091__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__26103 = r__$1;
var G__26104 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__26089__$1 = G__26103;
result_STAR___$1 = G__26104;
continue;
}
break;
}
});
