// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34661){
var state_val_34662 = (state_34661[(1)]);
if((state_val_34662 === (7))){
var inst_34650 = (state_34661[(7)]);
var inst_34652 = fluree.db.storage.core.serde.call(null,conn);
var inst_34653 = fluree.db.serde.protocol._deserialize_block.call(null,inst_34652,inst_34650);
var state_34661__$1 = state_34661;
var statearr_34663_34682 = state_34661__$1;
(statearr_34663_34682[(2)] = inst_34653);

(statearr_34663_34682[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34662 === (1))){
var state_34661__$1 = state_34661;
var statearr_34664_34683 = state_34661__$1;
(statearr_34664_34683[(2)] = null);

(statearr_34664_34683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34662 === (4))){
var inst_34640 = (state_34661[(2)]);
var state_34661__$1 = state_34661;
var statearr_34665_34684 = state_34661__$1;
(statearr_34665_34684[(2)] = inst_34640);

(statearr_34665_34684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34662 === (6))){
var inst_34650 = (state_34661[(7)]);
var inst_34649 = (state_34661[(2)]);
var inst_34650__$1 = fluree.db.util.async.throw_err.call(null,inst_34649);
var state_34661__$1 = (function (){var statearr_34666 = state_34661;
(statearr_34666[(7)] = inst_34650__$1);

return statearr_34666;
})();
if(cljs.core.truth_(inst_34650__$1)){
var statearr_34667_34685 = state_34661__$1;
(statearr_34667_34685[(1)] = (7));

} else {
var statearr_34668_34686 = state_34661__$1;
(statearr_34668_34686[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34662 === (3))){
var inst_34659 = (state_34661[(2)]);
var state_34661__$1 = state_34661;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34661__$1,inst_34659);
} else {
if((state_val_34662 === (2))){
var _ = (function (){var statearr_34670 = state_34661;
(statearr_34670[(4)] = cljs.core.cons.call(null,(5),(state_34661[(4)])));

return statearr_34670;
})();
var inst_34646 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_34647 = fluree.db.storage.core.storage_read.call(null,conn,inst_34646);
var state_34661__$1 = state_34661;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34661__$1,(6),inst_34647);
} else {
if((state_val_34662 === (9))){
var inst_34656 = (state_34661[(2)]);
var _ = (function (){var statearr_34671 = state_34661;
(statearr_34671[(4)] = cljs.core.rest.call(null,(state_34661[(4)])));

return statearr_34671;
})();
var state_34661__$1 = state_34661;
var statearr_34672_34687 = state_34661__$1;
(statearr_34672_34687[(2)] = inst_34656);

(statearr_34672_34687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34662 === (5))){
var _ = (function (){var statearr_34673 = state_34661;
(statearr_34673[(4)] = cljs.core.rest.call(null,(state_34661[(4)])));

return statearr_34673;
})();
var state_34661__$1 = state_34661;
var ex34669 = (state_34661__$1[(2)]);
var statearr_34674_34688 = state_34661__$1;
(statearr_34674_34688[(5)] = ex34669);


if((ex34669 instanceof Error)){
var statearr_34675_34689 = state_34661__$1;
(statearr_34675_34689[(1)] = (4));

(statearr_34675_34689[(5)] = null);

} else {
throw ex34669;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34662 === (8))){
var state_34661__$1 = state_34661;
var statearr_34676_34690 = state_34661__$1;
(statearr_34676_34690[(2)] = null);

(statearr_34676_34690[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__11469__auto____0 = (function (){
var statearr_34677 = [null,null,null,null,null,null,null,null];
(statearr_34677[(0)] = fluree$db$storage$core$read_block_$_state_machine__11469__auto__);

(statearr_34677[(1)] = (1));

return statearr_34677;
});
var fluree$db$storage$core$read_block_$_state_machine__11469__auto____1 = (function (state_34661){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34661);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34678){var ex__11472__auto__ = e34678;
var statearr_34679_34691 = state_34661;
(statearr_34679_34691[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34661[(4)]))){
var statearr_34680_34692 = state_34661;
(statearr_34680_34692[(1)] = cljs.core.first.call(null,(state_34661[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34693 = state_34661;
state_34661 = G__34693;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__11469__auto__ = function(state_34661){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__11469__auto____1.call(this,state_34661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__11469__auto____0;
fluree$db$storage$core$read_block_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__11469__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34681 = f__11543__auto__.call(null);
(statearr_34681[(6)] = c__11542__auto__);

return statearr_34681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34716){
var state_val_34717 = (state_34716[(1)]);
if((state_val_34717 === (7))){
var inst_34705 = (state_34716[(7)]);
var inst_34707 = fluree.db.storage.core.serde.call(null,conn);
var inst_34708 = fluree.db.serde.protocol._deserialize_block.call(null,inst_34707,inst_34705);
var state_34716__$1 = state_34716;
var statearr_34718_34737 = state_34716__$1;
(statearr_34718_34737[(2)] = inst_34708);

(statearr_34718_34737[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34717 === (1))){
var state_34716__$1 = state_34716;
var statearr_34719_34738 = state_34716__$1;
(statearr_34719_34738[(2)] = null);

(statearr_34719_34738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34717 === (4))){
var inst_34694 = (state_34716[(2)]);
var state_34716__$1 = state_34716;
var statearr_34720_34739 = state_34716__$1;
(statearr_34720_34739[(2)] = inst_34694);

(statearr_34720_34739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34717 === (6))){
var inst_34705 = (state_34716[(7)]);
var inst_34704 = (state_34716[(2)]);
var inst_34705__$1 = fluree.db.util.async.throw_err.call(null,inst_34704);
var state_34716__$1 = (function (){var statearr_34721 = state_34716;
(statearr_34721[(7)] = inst_34705__$1);

return statearr_34721;
})();
if(cljs.core.truth_(inst_34705__$1)){
var statearr_34722_34740 = state_34716__$1;
(statearr_34722_34740[(1)] = (7));

} else {
var statearr_34723_34741 = state_34716__$1;
(statearr_34723_34741[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34717 === (3))){
var inst_34714 = (state_34716[(2)]);
var state_34716__$1 = state_34716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34716__$1,inst_34714);
} else {
if((state_val_34717 === (2))){
var _ = (function (){var statearr_34725 = state_34716;
(statearr_34725[(4)] = cljs.core.cons.call(null,(5),(state_34716[(4)])));

return statearr_34725;
})();
var inst_34700 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_34701 = [inst_34700,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_34702 = fluree.db.storage.core.storage_read.call(null,conn,inst_34701);
var state_34716__$1 = state_34716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34716__$1,(6),inst_34702);
} else {
if((state_val_34717 === (9))){
var inst_34711 = (state_34716[(2)]);
var _ = (function (){var statearr_34726 = state_34716;
(statearr_34726[(4)] = cljs.core.rest.call(null,(state_34716[(4)])));

return statearr_34726;
})();
var state_34716__$1 = state_34716;
var statearr_34727_34742 = state_34716__$1;
(statearr_34727_34742[(2)] = inst_34711);

(statearr_34727_34742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34717 === (5))){
var _ = (function (){var statearr_34728 = state_34716;
(statearr_34728[(4)] = cljs.core.rest.call(null,(state_34716[(4)])));

return statearr_34728;
})();
var state_34716__$1 = state_34716;
var ex34724 = (state_34716__$1[(2)]);
var statearr_34729_34743 = state_34716__$1;
(statearr_34729_34743[(5)] = ex34724);


if((ex34724 instanceof Error)){
var statearr_34730_34744 = state_34716__$1;
(statearr_34730_34744[(1)] = (4));

(statearr_34730_34744[(5)] = null);

} else {
throw ex34724;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34717 === (8))){
var state_34716__$1 = state_34716;
var statearr_34731_34745 = state_34716__$1;
(statearr_34731_34745[(2)] = null);

(statearr_34731_34745[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__11469__auto____0 = (function (){
var statearr_34732 = [null,null,null,null,null,null,null,null];
(statearr_34732[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__11469__auto__);

(statearr_34732[(1)] = (1));

return statearr_34732;
});
var fluree$db$storage$core$read_block_version_$_state_machine__11469__auto____1 = (function (state_34716){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34733){var ex__11472__auto__ = e34733;
var statearr_34734_34746 = state_34716;
(statearr_34734_34746[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34716[(4)]))){
var statearr_34735_34747 = state_34716;
(statearr_34735_34747[(1)] = cljs.core.first.call(null,(state_34716[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34748 = state_34716;
state_34716 = G__34748;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__11469__auto__ = function(state_34716){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__11469__auto____1.call(this,state_34716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__11469__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__11469__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34736 = f__11543__auto__.call(null);
(statearr_34736[(6)] = c__11542__auto__);

return statearr_34736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34772){
var state_val_34773 = (state_34772[(1)]);
if((state_val_34773 === (1))){
var state_34772__$1 = state_34772;
var statearr_34774_34788 = state_34772__$1;
(statearr_34774_34788[(2)] = null);

(statearr_34774_34788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34773 === (2))){
var _ = (function (){var statearr_34775 = state_34772;
(statearr_34775[(4)] = cljs.core.cons.call(null,(5),(state_34772[(4)])));

return statearr_34775;
})();
var inst_34755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34756 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_34757 = (new cljs.core.PersistentVector(null,3,(5),inst_34755,inst_34756,null));
var inst_34758 = cljs.core.select_keys.call(null,block_data,inst_34757);
var inst_34759 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_34758);
var inst_34760 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_34759);
var inst_34761 = [inst_34760,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_34762 = fluree.db.storage.core.serde.call(null,conn);
var inst_34763 = fluree.db.serde.protocol._serialize_block.call(null,inst_34762,inst_34758);
var inst_34764 = fluree.db.storage.core.storage_write.call(null,conn,inst_34761,inst_34763);
var state_34772__$1 = state_34772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34772__$1,(6),inst_34764);
} else {
if((state_val_34773 === (3))){
var inst_34770 = (state_34772[(2)]);
var state_34772__$1 = state_34772;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34772__$1,inst_34770);
} else {
if((state_val_34773 === (4))){
var inst_34749 = (state_34772[(2)]);
var state_34772__$1 = state_34772;
var statearr_34777_34789 = state_34772__$1;
(statearr_34777_34789[(2)] = inst_34749);

(statearr_34777_34789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34773 === (5))){
var _ = (function (){var statearr_34778 = state_34772;
(statearr_34778[(4)] = cljs.core.rest.call(null,(state_34772[(4)])));

return statearr_34778;
})();
var state_34772__$1 = state_34772;
var ex34776 = (state_34772__$1[(2)]);
var statearr_34779_34790 = state_34772__$1;
(statearr_34779_34790[(5)] = ex34776);


if((ex34776 instanceof Error)){
var statearr_34780_34791 = state_34772__$1;
(statearr_34780_34791[(1)] = (4));

(statearr_34780_34791[(5)] = null);

} else {
throw ex34776;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34773 === (6))){
var inst_34766 = (state_34772[(2)]);
var inst_34767 = fluree.db.util.async.throw_err.call(null,inst_34766);
var _ = (function (){var statearr_34781 = state_34772;
(statearr_34781[(4)] = cljs.core.rest.call(null,(state_34772[(4)])));

return statearr_34781;
})();
var state_34772__$1 = state_34772;
var statearr_34782_34792 = state_34772__$1;
(statearr_34782_34792[(2)] = inst_34767);

(statearr_34782_34792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__11469__auto____0 = (function (){
var statearr_34783 = [null,null,null,null,null,null,null];
(statearr_34783[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__11469__auto__);

(statearr_34783[(1)] = (1));

return statearr_34783;
});
var fluree$db$storage$core$write_block_version_$_state_machine__11469__auto____1 = (function (state_34772){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34784){var ex__11472__auto__ = e34784;
var statearr_34785_34793 = state_34772;
(statearr_34785_34793[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34772[(4)]))){
var statearr_34786_34794 = state_34772;
(statearr_34786_34794[(1)] = cljs.core.first.call(null,(state_34772[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34795 = state_34772;
state_34772 = G__34795;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__11469__auto__ = function(state_34772){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__11469__auto____1.call(this,state_34772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__11469__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__11469__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34787 = f__11543__auto__.call(null);
(statearr_34787[(6)] = c__11542__auto__);

return statearr_34787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34818){
var state_val_34819 = (state_34818[(1)]);
if((state_val_34819 === (1))){
var state_34818__$1 = state_34818;
var statearr_34820_34834 = state_34818__$1;
(statearr_34820_34834[(2)] = null);

(statearr_34820_34834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34819 === (2))){
var _ = (function (){var statearr_34821 = state_34818;
(statearr_34821[(4)] = cljs.core.cons.call(null,(5),(state_34818[(4)])));

return statearr_34821;
})();
var inst_34802 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34803 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_34804 = (new cljs.core.PersistentVector(null,3,(5),inst_34802,inst_34803,null));
var inst_34805 = cljs.core.select_keys.call(null,block_data,inst_34804);
var inst_34806 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_34805);
var inst_34807 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_34806);
var inst_34808 = fluree.db.storage.core.serde.call(null,conn);
var inst_34809 = fluree.db.serde.protocol._serialize_block.call(null,inst_34808,inst_34805);
var inst_34810 = fluree.db.storage.core.storage_write.call(null,conn,inst_34807,inst_34809);
var state_34818__$1 = state_34818;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34818__$1,(6),inst_34810);
} else {
if((state_val_34819 === (3))){
var inst_34816 = (state_34818[(2)]);
var state_34818__$1 = state_34818;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34818__$1,inst_34816);
} else {
if((state_val_34819 === (4))){
var inst_34796 = (state_34818[(2)]);
var state_34818__$1 = state_34818;
var statearr_34823_34835 = state_34818__$1;
(statearr_34823_34835[(2)] = inst_34796);

(statearr_34823_34835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34819 === (5))){
var _ = (function (){var statearr_34824 = state_34818;
(statearr_34824[(4)] = cljs.core.rest.call(null,(state_34818[(4)])));

return statearr_34824;
})();
var state_34818__$1 = state_34818;
var ex34822 = (state_34818__$1[(2)]);
var statearr_34825_34836 = state_34818__$1;
(statearr_34825_34836[(5)] = ex34822);


if((ex34822 instanceof Error)){
var statearr_34826_34837 = state_34818__$1;
(statearr_34826_34837[(1)] = (4));

(statearr_34826_34837[(5)] = null);

} else {
throw ex34822;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34819 === (6))){
var inst_34812 = (state_34818[(2)]);
var inst_34813 = fluree.db.util.async.throw_err.call(null,inst_34812);
var _ = (function (){var statearr_34827 = state_34818;
(statearr_34827[(4)] = cljs.core.rest.call(null,(state_34818[(4)])));

return statearr_34827;
})();
var state_34818__$1 = state_34818;
var statearr_34828_34838 = state_34818__$1;
(statearr_34828_34838[(2)] = inst_34813);

(statearr_34828_34838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__11469__auto____0 = (function (){
var statearr_34829 = [null,null,null,null,null,null,null];
(statearr_34829[(0)] = fluree$db$storage$core$write_block_$_state_machine__11469__auto__);

(statearr_34829[(1)] = (1));

return statearr_34829;
});
var fluree$db$storage$core$write_block_$_state_machine__11469__auto____1 = (function (state_34818){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34818);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34830){var ex__11472__auto__ = e34830;
var statearr_34831_34839 = state_34818;
(statearr_34831_34839[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34818[(4)]))){
var statearr_34832_34840 = state_34818;
(statearr_34832_34840[(1)] = cljs.core.first.call(null,(state_34818[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34841 = state_34818;
state_34818 = G__34841;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__11469__auto__ = function(state_34818){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__11469__auto____1.call(this,state_34818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__11469__auto____0;
fluree$db$storage$core$write_block_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__11469__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34833 = f__11543__auto__.call(null);
(statearr_34833[(6)] = c__11542__auto__);

return statearr_34833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34861){
var state_val_34862 = (state_34861[(1)]);
if((state_val_34862 === (1))){
var state_34861__$1 = state_34861;
var statearr_34863_34877 = state_34861__$1;
(statearr_34863_34877[(2)] = null);

(statearr_34863_34877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34862 === (2))){
var _ = (function (){var statearr_34864 = state_34861;
(statearr_34864[(4)] = cljs.core.cons.call(null,(5),(state_34861[(4)])));

return statearr_34864;
})();
var inst_34848 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_34849 = [history,next_his_key];
var inst_34850 = cljs.core.PersistentHashMap.fromArrays(inst_34848,inst_34849);
var inst_34851 = fluree.db.storage.core.serde.call(null,conn);
var inst_34852 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_34851,inst_34850);
var inst_34853 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_34852);
var state_34861__$1 = state_34861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34861__$1,(6),inst_34853);
} else {
if((state_val_34862 === (3))){
var inst_34859 = (state_34861[(2)]);
var state_34861__$1 = state_34861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34861__$1,inst_34859);
} else {
if((state_val_34862 === (4))){
var inst_34842 = (state_34861[(2)]);
var state_34861__$1 = state_34861;
var statearr_34866_34878 = state_34861__$1;
(statearr_34866_34878[(2)] = inst_34842);

(statearr_34866_34878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34862 === (5))){
var _ = (function (){var statearr_34867 = state_34861;
(statearr_34867[(4)] = cljs.core.rest.call(null,(state_34861[(4)])));

return statearr_34867;
})();
var state_34861__$1 = state_34861;
var ex34865 = (state_34861__$1[(2)]);
var statearr_34868_34879 = state_34861__$1;
(statearr_34868_34879[(5)] = ex34865);


if((ex34865 instanceof Error)){
var statearr_34869_34880 = state_34861__$1;
(statearr_34869_34880[(1)] = (4));

(statearr_34869_34880[(5)] = null);

} else {
throw ex34865;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34862 === (6))){
var inst_34855 = (state_34861[(2)]);
var inst_34856 = fluree.db.util.async.throw_err.call(null,inst_34855);
var _ = (function (){var statearr_34870 = state_34861;
(statearr_34870[(4)] = cljs.core.rest.call(null,(state_34861[(4)])));

return statearr_34870;
})();
var state_34861__$1 = state_34861;
var statearr_34871_34881 = state_34861__$1;
(statearr_34871_34881[(2)] = inst_34856);

(statearr_34871_34881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__11469__auto____0 = (function (){
var statearr_34872 = [null,null,null,null,null,null,null];
(statearr_34872[(0)] = fluree$db$storage$core$write_history_$_state_machine__11469__auto__);

(statearr_34872[(1)] = (1));

return statearr_34872;
});
var fluree$db$storage$core$write_history_$_state_machine__11469__auto____1 = (function (state_34861){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34873){var ex__11472__auto__ = e34873;
var statearr_34874_34882 = state_34861;
(statearr_34874_34882[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34861[(4)]))){
var statearr_34875_34883 = state_34861;
(statearr_34875_34883[(1)] = cljs.core.first.call(null,(state_34861[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34884 = state_34861;
state_34861 = G__34884;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__11469__auto__ = function(state_34861){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__11469__auto____1.call(this,state_34861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__11469__auto____0;
fluree$db$storage$core$write_history_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__11469__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34876 = f__11543__auto__.call(null);
(statearr_34876[(6)] = c__11542__auto__);

return statearr_34876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34910){
var state_val_34911 = (state_34910[(1)]);
if((state_val_34911 === (1))){
var state_34910__$1 = state_34910;
var statearr_34912_34929 = state_34910__$1;
(statearr_34912_34929[(2)] = null);

(statearr_34912_34929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34911 === (2))){
var inst_34891 = (state_34910[(7)]);
var _ = (function (){var statearr_34913 = state_34910;
(statearr_34913[(4)] = cljs.core.cons.call(null,(5),(state_34910[(4)])));

return statearr_34913;
})();
var inst_34891__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_34892 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34891__$1),"-his"].join('');
var inst_34893 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_34894 = [flakes,inst_34892];
var inst_34895 = cljs.core.PersistentHashMap.fromArrays(inst_34893,inst_34894);
var inst_34896 = fluree.db.storage.core.serde.call(null,conn);
var inst_34897 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_34896,inst_34895);
var inst_34898 = fluree.db.storage.core.write_history.call(null,conn,history,inst_34892,null);
var inst_34899 = fluree.db.storage.core.storage_write.call(null,conn,inst_34891__$1,inst_34897);
var state_34910__$1 = (function (){var statearr_34914 = state_34910;
(statearr_34914[(7)] = inst_34891__$1);

(statearr_34914[(8)] = inst_34899);

return statearr_34914;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34910__$1,(6),inst_34898);
} else {
if((state_val_34911 === (3))){
var inst_34908 = (state_34910[(2)]);
var state_34910__$1 = state_34910;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34910__$1,inst_34908);
} else {
if((state_val_34911 === (4))){
var inst_34885 = (state_34910[(2)]);
var state_34910__$1 = state_34910;
var statearr_34916_34930 = state_34910__$1;
(statearr_34916_34930[(2)] = inst_34885);

(statearr_34916_34930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34911 === (5))){
var _ = (function (){var statearr_34917 = state_34910;
(statearr_34917[(4)] = cljs.core.rest.call(null,(state_34910[(4)])));

return statearr_34917;
})();
var state_34910__$1 = state_34910;
var ex34915 = (state_34910__$1[(2)]);
var statearr_34918_34931 = state_34910__$1;
(statearr_34918_34931[(5)] = ex34915);


if((ex34915 instanceof Error)){
var statearr_34919_34932 = state_34910__$1;
(statearr_34919_34932[(1)] = (4));

(statearr_34919_34932[(5)] = null);

} else {
throw ex34915;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34911 === (6))){
var inst_34899 = (state_34910[(8)]);
var inst_34901 = (state_34910[(2)]);
var inst_34902 = fluree.db.util.async.throw_err.call(null,inst_34901);
var state_34910__$1 = (function (){var statearr_34920 = state_34910;
(statearr_34920[(9)] = inst_34902);

return statearr_34920;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34910__$1,(7),inst_34899);
} else {
if((state_val_34911 === (7))){
var inst_34891 = (state_34910[(7)]);
var inst_34904 = (state_34910[(2)]);
var inst_34905 = fluree.db.util.async.throw_err.call(null,inst_34904);
var _ = (function (){var statearr_34921 = state_34910;
(statearr_34921[(4)] = cljs.core.rest.call(null,(state_34910[(4)])));

return statearr_34921;
})();
var state_34910__$1 = (function (){var statearr_34922 = state_34910;
(statearr_34922[(10)] = inst_34905);

return statearr_34922;
})();
var statearr_34923_34933 = state_34910__$1;
(statearr_34923_34933[(2)] = inst_34891);

(statearr_34923_34933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__11469__auto____0 = (function (){
var statearr_34924 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34924[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__11469__auto__);

(statearr_34924[(1)] = (1));

return statearr_34924;
});
var fluree$db$storage$core$write_leaf_$_state_machine__11469__auto____1 = (function (state_34910){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34910);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34925){var ex__11472__auto__ = e34925;
var statearr_34926_34934 = state_34910;
(statearr_34926_34934[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34910[(4)]))){
var statearr_34927_34935 = state_34910;
(statearr_34927_34935[(1)] = cljs.core.first.call(null,(state_34910[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34936 = state_34910;
state_34910 = G__34936;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__11469__auto__ = function(state_34910){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__11469__auto____1.call(this,state_34910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__11469__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__11469__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34928 = f__11543__auto__.call(null);
(statearr_34928[(6)] = c__11542__auto__);

return statearr_34928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34953){
var state_val_34954 = (state_34953[(1)]);
if((state_val_34954 === (1))){
var state_34953__$1 = state_34953;
var statearr_34955_34970 = state_34953__$1;
(statearr_34955_34970[(2)] = null);

(statearr_34955_34970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34954 === (2))){
var _ = (function (){var statearr_34956 = state_34953;
(statearr_34956[(4)] = cljs.core.cons.call(null,(5),(state_34953[(4)])));

return statearr_34956;
})();
var inst_34943 = fluree.db.storage.core.serde.call(null,conn);
var inst_34944 = fluree.db.serde.protocol._serialize_branch.call(null,inst_34943,data);
var inst_34945 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_34944);
var state_34953__$1 = state_34953;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34953__$1,(6),inst_34945);
} else {
if((state_val_34954 === (3))){
var inst_34951 = (state_34953[(2)]);
var state_34953__$1 = state_34953;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34953__$1,inst_34951);
} else {
if((state_val_34954 === (4))){
var inst_34937 = (state_34953[(2)]);
var state_34953__$1 = state_34953;
var statearr_34958_34971 = state_34953__$1;
(statearr_34958_34971[(2)] = inst_34937);

(statearr_34958_34971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34954 === (5))){
var _ = (function (){var statearr_34959 = state_34953;
(statearr_34959[(4)] = cljs.core.rest.call(null,(state_34953[(4)])));

return statearr_34959;
})();
var state_34953__$1 = state_34953;
var ex34957 = (state_34953__$1[(2)]);
var statearr_34960_34972 = state_34953__$1;
(statearr_34960_34972[(5)] = ex34957);


if((ex34957 instanceof Error)){
var statearr_34961_34973 = state_34953__$1;
(statearr_34961_34973[(1)] = (4));

(statearr_34961_34973[(5)] = null);

} else {
throw ex34957;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34954 === (6))){
var inst_34947 = (state_34953[(2)]);
var inst_34948 = fluree.db.util.async.throw_err.call(null,inst_34947);
var _ = (function (){var statearr_34962 = state_34953;
(statearr_34962[(4)] = cljs.core.rest.call(null,(state_34953[(4)])));

return statearr_34962;
})();
var state_34953__$1 = (function (){var statearr_34963 = state_34953;
(statearr_34963[(7)] = inst_34948);

return statearr_34963;
})();
var statearr_34964_34974 = state_34953__$1;
(statearr_34964_34974[(2)] = key);

(statearr_34964_34974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__11469__auto____0 = (function (){
var statearr_34965 = [null,null,null,null,null,null,null,null];
(statearr_34965[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__11469__auto__);

(statearr_34965[(1)] = (1));

return statearr_34965;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__11469__auto____1 = (function (state_34953){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34953);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34966){var ex__11472__auto__ = e34966;
var statearr_34967_34975 = state_34953;
(statearr_34967_34975[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34953[(4)]))){
var statearr_34968_34976 = state_34953;
(statearr_34968_34976[(1)] = cljs.core.first.call(null,(state_34953[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34977 = state_34953;
state_34953 = G__34977;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__11469__auto__ = function(state_34953){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__11469__auto____1.call(this,state_34953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__11469__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__11469__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34969 = f__11543__auto__.call(null);
(statearr_34969[(6)] = c__11542__auto__);

return statearr_34969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__34978_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__34978_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__34979){
var map__34980 = p__34979;
var map__34980__$1 = (((((!((map__34980 == null))))?(((((map__34980.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34980.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34980):map__34980);
var progress = map__34980__$1;
var garbage = cljs.core.get.call(null,map__34980__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_35029){
var state_val_35030 = (state_35029[(1)]);
if((state_val_35030 === (7))){
var state_35029__$1 = state_35029;
var statearr_35031_35060 = state_35029__$1;
(statearr_35031_35060[(2)] = false);

(statearr_35031_35060[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35030 === (1))){
var state_35029__$1 = state_35029;
var statearr_35032_35061 = state_35029__$1;
(statearr_35032_35061[(2)] = null);

(statearr_35032_35061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35030 === (4))){
var inst_34982 = (state_35029[(2)]);
var state_35029__$1 = state_35029;
var statearr_35033_35062 = state_35029__$1;
(statearr_35033_35062[(2)] = inst_34982);

(statearr_35033_35062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35030 === (15))){
var inst_35015 = (state_35029[(7)]);
var inst_35023 = (state_35029[(2)]);
var inst_35024 = fluree.db.util.async.throw_err.call(null,inst_35023);
var _ = (function (){var statearr_35034 = state_35029;
(statearr_35034[(4)] = cljs.core.rest.call(null,(state_35029[(4)])));

return statearr_35034;
})();
var state_35029__$1 = (function (){var statearr_35035 = state_35029;
(statearr_35035[(8)] = inst_35024);

return statearr_35035;
})();
var statearr_35036_35063 = state_35029__$1;
(statearr_35036_35063[(2)] = inst_35015);

(statearr_35036_35063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35030 === (13))){
var inst_34989 = (state_35029[(9)]);
var state_35029__$1 = state_35029;
var statearr_35037_35064 = state_35029__$1;
(statearr_35037_35064[(2)] = inst_34989);

(statearr_35037_35064[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35030 === (6))){
var inst_34989 = (state_35029[(9)]);
var inst_34994 = inst_34989.cljs$lang$protocol_mask$partition0$;
var inst_34995 = (inst_34994 & (64));
var inst_34996 = inst_34989.cljs$core$ISeq$;
var inst_34997 = (cljs.core.PROTOCOL_SENTINEL === inst_34996);
var inst_34998 = ((inst_34995) || (inst_34997));
var state_35029__$1 = state_35029;
if(cljs.core.truth_(inst_34998)){
var statearr_35038_35065 = state_35029__$1;
(statearr_35038_35065[(1)] = (9));

} else {
var statearr_35039_35066 = state_35029__$1;
(statearr_35039_35066[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35030 === (3))){
var inst_35027 = (state_35029[(2)]);
var state_35029__$1 = state_35029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35029__$1,inst_35027);
} else {
if((state_val_35030 === (12))){
var inst_34989 = (state_35029[(9)]);
var inst_35007 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34989);
var state_35029__$1 = state_35029;
var statearr_35040_35067 = state_35029__$1;
(statearr_35040_35067[(2)] = inst_35007);

(statearr_35040_35067[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35030 === (2))){
var inst_34989 = (state_35029[(9)]);
var _ = (function (){var statearr_35041 = state_35029;
(statearr_35041[(4)] = cljs.core.cons.call(null,(5),(state_35029[(4)])));

return statearr_35041;
})();
var inst_34989__$1 = db;
var inst_34991 = (inst_34989__$1 == null);
var inst_34992 = cljs.core.not.call(null,inst_34991);
var state_35029__$1 = (function (){var statearr_35042 = state_35029;
(statearr_35042[(9)] = inst_34989__$1);

return statearr_35042;
})();
if(inst_34992){
var statearr_35043_35068 = state_35029__$1;
(statearr_35043_35068[(1)] = (6));

} else {
var statearr_35044_35069 = state_35029__$1;
(statearr_35044_35069[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35030 === (11))){
var inst_35002 = (state_35029[(2)]);
var state_35029__$1 = state_35029;
var statearr_35046_35070 = state_35029__$1;
(statearr_35046_35070[(2)] = inst_35002);

(statearr_35046_35070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35030 === (9))){
var state_35029__$1 = state_35029;
var statearr_35047_35071 = state_35029__$1;
(statearr_35047_35071[(2)] = true);

(statearr_35047_35071[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35030 === (5))){
var _ = (function (){var statearr_35048 = state_35029;
(statearr_35048[(4)] = cljs.core.rest.call(null,(state_35029[(4)])));

return statearr_35048;
})();
var state_35029__$1 = state_35029;
var ex35045 = (state_35029__$1[(2)]);
var statearr_35049_35072 = state_35029__$1;
(statearr_35049_35072[(5)] = ex35045);


if((ex35045 instanceof Error)){
var statearr_35050_35073 = state_35029__$1;
(statearr_35050_35073[(1)] = (4));

(statearr_35050_35073[(5)] = null);

} else {
throw ex35045;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35030 === (14))){
var inst_35015 = (state_35029[(7)]);
var inst_35010 = (state_35029[(2)]);
var inst_35011 = cljs.core.get.call(null,inst_35010,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_35012 = cljs.core.get.call(null,inst_35010,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_35013 = cljs.core.get.call(null,inst_35010,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_35014 = cljs.core.get.call(null,inst_35010,new cljs.core.Keyword(null,"block","block",664686210));
var inst_35015__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_35012,inst_35013,inst_35014);
var inst_35016 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_35017 = [inst_35013,inst_35014,garbage];
var inst_35018 = cljs.core.PersistentHashMap.fromArrays(inst_35016,inst_35017);
var inst_35019 = fluree.db.storage.core.serde.call(null,inst_35011);
var inst_35020 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_35019,inst_35018);
var inst_35021 = fluree.db.storage.core.storage_write.call(null,inst_35011,inst_35015__$1,inst_35020);
var state_35029__$1 = (function (){var statearr_35051 = state_35029;
(statearr_35051[(7)] = inst_35015__$1);

return statearr_35051;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35029__$1,(15),inst_35021);
} else {
if((state_val_35030 === (10))){
var state_35029__$1 = state_35029;
var statearr_35052_35074 = state_35029__$1;
(statearr_35052_35074[(2)] = false);

(statearr_35052_35074[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35030 === (8))){
var inst_35005 = (state_35029[(2)]);
var state_35029__$1 = state_35029;
if(cljs.core.truth_(inst_35005)){
var statearr_35053_35075 = state_35029__$1;
(statearr_35053_35075[(1)] = (12));

} else {
var statearr_35054_35076 = state_35029__$1;
(statearr_35054_35076[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__11469__auto____0 = (function (){
var statearr_35055 = [null,null,null,null,null,null,null,null,null,null];
(statearr_35055[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__11469__auto__);

(statearr_35055[(1)] = (1));

return statearr_35055;
});
var fluree$db$storage$core$write_garbage_$_state_machine__11469__auto____1 = (function (state_35029){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_35029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e35056){var ex__11472__auto__ = e35056;
var statearr_35057_35077 = state_35029;
(statearr_35057_35077[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_35029[(4)]))){
var statearr_35058_35078 = state_35029;
(statearr_35058_35078[(1)] = cljs.core.first.call(null,(state_35029[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35079 = state_35029;
state_35029 = G__35079;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__11469__auto__ = function(state_35029){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__11469__auto____1.call(this,state_35029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__11469__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__11469__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_35059 = f__11543__auto__.call(null);
(statearr_35059[(6)] = c__11542__auto__);

return statearr_35059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__35081 = arguments.length;
switch (G__35081) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_35157){
var state_val_35158 = (state_35157[(1)]);
if((state_val_35158 === (7))){
var state_35157__$1 = state_35157;
var statearr_35159_35198 = state_35157__$1;
(statearr_35159_35198[(2)] = false);

(statearr_35159_35198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (20))){
var inst_35131 = (state_35157[(7)]);
var inst_35122 = (state_35157[(8)]);
var inst_35113 = (state_35157[(9)]);
var inst_35123 = (state_35157[(10)]);
var inst_35121 = (state_35157[(11)]);
var inst_35126 = (state_35157[(12)]);
var inst_35116 = (state_35157[(13)]);
var inst_35115 = (state_35157[(14)]);
var inst_35124 = (state_35157[(15)]);
var inst_35119 = (state_35157[(16)]);
var inst_35112 = (state_35157[(17)]);
var inst_35117 = (state_35157[(18)]);
var inst_35125 = (state_35157[(19)]);
var inst_35114 = (state_35157[(20)]);
var inst_35136 = (state_35157[(2)]);
var inst_35137 = fluree.db.storage.core.child_data.call(null,inst_35121);
var inst_35138 = fluree.db.storage.core.child_data.call(null,inst_35123);
var inst_35139 = fluree.db.util.core.current_time_millis.call(null);
var inst_35140 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35141 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_35142 = (new cljs.core.PersistentVector(null,2,(5),inst_35140,inst_35141,null));
var inst_35143 = cljs.core.select_keys.call(null,inst_35115,inst_35142);
var inst_35144 = fluree.db.storage.core.child_data.call(null,inst_35114);
var inst_35145 = [inst_35117,inst_35126,inst_35119,inst_35131,inst_35136,inst_35137,inst_35138,inst_35112,inst_35139,inst_35113,inst_35122,inst_35143,inst_35144];
var inst_35146 = cljs.core.PersistentHashMap.fromArrays(inst_35125,inst_35145);
var inst_35147 = fluree.db.storage.core.serde.call(null,inst_35116);
var inst_35148 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_35147,inst_35146);
var inst_35149 = fluree.db.storage.core.storage_write.call(null,inst_35116,inst_35124,inst_35148);
var state_35157__$1 = state_35157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35157__$1,(21),inst_35149);
} else {
if((state_val_35158 === (1))){
var state_35157__$1 = state_35157;
var statearr_35160_35199 = state_35157__$1;
(statearr_35160_35199[(2)] = null);

(statearr_35160_35199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (4))){
var inst_35082 = (state_35157[(2)]);
var state_35157__$1 = state_35157;
var statearr_35161_35200 = state_35157__$1;
(statearr_35161_35200[(2)] = inst_35082);

(statearr_35161_35200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (15))){
var inst_35127 = (state_35157[(21)]);
var state_35157__$1 = state_35157;
var statearr_35162_35201 = state_35157__$1;
(statearr_35162_35201[(2)] = inst_35127);

(statearr_35162_35201[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (21))){
var inst_35124 = (state_35157[(15)]);
var inst_35151 = (state_35157[(2)]);
var inst_35152 = fluree.db.util.async.throw_err.call(null,inst_35151);
var _ = (function (){var statearr_35163 = state_35157;
(statearr_35163[(4)] = cljs.core.rest.call(null,(state_35157[(4)])));

return statearr_35163;
})();
var state_35157__$1 = (function (){var statearr_35164 = state_35157;
(statearr_35164[(22)] = inst_35152);

return statearr_35164;
})();
var statearr_35165_35202 = state_35157__$1;
(statearr_35165_35202[(2)] = inst_35124);

(statearr_35165_35202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (13))){
var inst_35089 = (state_35157[(23)]);
var state_35157__$1 = state_35157;
var statearr_35166_35203 = state_35157__$1;
(statearr_35166_35203[(2)] = inst_35089);

(statearr_35166_35203[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (6))){
var inst_35089 = (state_35157[(23)]);
var inst_35094 = inst_35089.cljs$lang$protocol_mask$partition0$;
var inst_35095 = (inst_35094 & (64));
var inst_35096 = inst_35089.cljs$core$ISeq$;
var inst_35097 = (cljs.core.PROTOCOL_SENTINEL === inst_35096);
var inst_35098 = ((inst_35095) || (inst_35097));
var state_35157__$1 = state_35157;
if(cljs.core.truth_(inst_35098)){
var statearr_35167_35204 = state_35157__$1;
(statearr_35167_35204[(1)] = (9));

} else {
var statearr_35168_35205 = state_35157__$1;
(statearr_35168_35205[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (17))){
var inst_35132 = (state_35157[(24)]);
var inst_35131 = (state_35157[(2)]);
var inst_35132__$1 = custom_ecount;
var state_35157__$1 = (function (){var statearr_35169 = state_35157;
(statearr_35169[(7)] = inst_35131);

(statearr_35169[(24)] = inst_35132__$1);

return statearr_35169;
})();
if(cljs.core.truth_(inst_35132__$1)){
var statearr_35170_35206 = state_35157__$1;
(statearr_35170_35206[(1)] = (18));

} else {
var statearr_35171_35207 = state_35157__$1;
(statearr_35171_35207[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (3))){
var inst_35155 = (state_35157[(2)]);
var state_35157__$1 = state_35157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35157__$1,inst_35155);
} else {
if((state_val_35158 === (12))){
var inst_35089 = (state_35157[(23)]);
var inst_35107 = cljs.core.apply.call(null,cljs.core.hash_map,inst_35089);
var state_35157__$1 = state_35157;
var statearr_35172_35208 = state_35157__$1;
(statearr_35172_35208[(2)] = inst_35107);

(statearr_35172_35208[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (2))){
var inst_35089 = (state_35157[(23)]);
var _ = (function (){var statearr_35173 = state_35157;
(statearr_35173[(4)] = cljs.core.cons.call(null,(5),(state_35157[(4)])));

return statearr_35173;
})();
var inst_35089__$1 = db;
var inst_35091 = (inst_35089__$1 == null);
var inst_35092 = cljs.core.not.call(null,inst_35091);
var state_35157__$1 = (function (){var statearr_35174 = state_35157;
(statearr_35174[(23)] = inst_35089__$1);

return statearr_35174;
})();
if(inst_35092){
var statearr_35175_35209 = state_35157__$1;
(statearr_35175_35209[(1)] = (6));

} else {
var statearr_35176_35210 = state_35157__$1;
(statearr_35176_35210[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (19))){
var inst_35120 = (state_35157[(25)]);
var state_35157__$1 = state_35157;
var statearr_35177_35211 = state_35157__$1;
(statearr_35177_35211[(2)] = inst_35120);

(statearr_35177_35211[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (11))){
var inst_35102 = (state_35157[(2)]);
var state_35157__$1 = state_35157;
var statearr_35179_35212 = state_35157__$1;
(statearr_35179_35212[(2)] = inst_35102);

(statearr_35179_35212[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (9))){
var state_35157__$1 = state_35157;
var statearr_35180_35213 = state_35157__$1;
(statearr_35180_35213[(2)] = true);

(statearr_35180_35213[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (5))){
var _ = (function (){var statearr_35181 = state_35157;
(statearr_35181[(4)] = cljs.core.rest.call(null,(state_35157[(4)])));

return statearr_35181;
})();
var state_35157__$1 = state_35157;
var ex35178 = (state_35157__$1[(2)]);
var statearr_35182_35214 = state_35157__$1;
(statearr_35182_35214[(5)] = ex35178);


if((ex35178 instanceof Error)){
var statearr_35183_35215 = state_35157__$1;
(statearr_35183_35215[(1)] = (4));

(statearr_35183_35215[(5)] = null);

} else {
throw ex35178;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (14))){
var inst_35127 = (state_35157[(21)]);
var inst_35115 = (state_35157[(14)]);
var inst_35119 = (state_35157[(16)]);
var inst_35117 = (state_35157[(18)]);
var inst_35110 = (state_35157[(2)]);
var inst_35111 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_35112 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_35113 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_35114 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_35115__$1 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_35116 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_35117__$1 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"block","block",664686210));
var inst_35118 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_35119__$1 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_35120 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_35121 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_35122 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_35123 = cljs.core.get.call(null,inst_35110,new cljs.core.Keyword(null,"post","post",269697687));
var inst_35124 = fluree.db.storage.core.ledger_root_key.call(null,inst_35111,inst_35119__$1,inst_35117__$1);
var inst_35125 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_35126 = fluree.db.storage.core.child_data.call(null,inst_35118);
var inst_35127__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_35115__$1);
var state_35157__$1 = (function (){var statearr_35184 = state_35157;
(statearr_35184[(8)] = inst_35122);

(statearr_35184[(9)] = inst_35113);

(statearr_35184[(10)] = inst_35123);

(statearr_35184[(25)] = inst_35120);

(statearr_35184[(11)] = inst_35121);

(statearr_35184[(12)] = inst_35126);

(statearr_35184[(21)] = inst_35127__$1);

(statearr_35184[(13)] = inst_35116);

(statearr_35184[(14)] = inst_35115__$1);

(statearr_35184[(15)] = inst_35124);

(statearr_35184[(16)] = inst_35119__$1);

(statearr_35184[(17)] = inst_35112);

(statearr_35184[(18)] = inst_35117__$1);

(statearr_35184[(19)] = inst_35125);

(statearr_35184[(20)] = inst_35114);

return statearr_35184;
})();
if(cljs.core.truth_(inst_35127__$1)){
var statearr_35185_35216 = state_35157__$1;
(statearr_35185_35216[(1)] = (15));

} else {
var statearr_35186_35217 = state_35157__$1;
(statearr_35186_35217[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (16))){
var state_35157__$1 = state_35157;
var statearr_35187_35218 = state_35157__$1;
(statearr_35187_35218[(2)] = (0));

(statearr_35187_35218[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (10))){
var state_35157__$1 = state_35157;
var statearr_35188_35219 = state_35157__$1;
(statearr_35188_35219[(2)] = false);

(statearr_35188_35219[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (18))){
var inst_35132 = (state_35157[(24)]);
var state_35157__$1 = state_35157;
var statearr_35189_35220 = state_35157__$1;
(statearr_35189_35220[(2)] = inst_35132);

(statearr_35189_35220[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35158 === (8))){
var inst_35105 = (state_35157[(2)]);
var state_35157__$1 = state_35157;
if(cljs.core.truth_(inst_35105)){
var statearr_35190_35221 = state_35157__$1;
(statearr_35190_35221[(1)] = (12));

} else {
var statearr_35191_35222 = state_35157__$1;
(statearr_35191_35222[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__11469__auto__ = null;
var fluree$db$storage$core$state_machine__11469__auto____0 = (function (){
var statearr_35192 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35192[(0)] = fluree$db$storage$core$state_machine__11469__auto__);

(statearr_35192[(1)] = (1));

return statearr_35192;
});
var fluree$db$storage$core$state_machine__11469__auto____1 = (function (state_35157){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_35157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e35193){var ex__11472__auto__ = e35193;
var statearr_35194_35223 = state_35157;
(statearr_35194_35223[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_35157[(4)]))){
var statearr_35195_35224 = state_35157;
(statearr_35195_35224[(1)] = cljs.core.first.call(null,(state_35157[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35225 = state_35157;
state_35157 = G__35225;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__11469__auto__ = function(state_35157){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__11469__auto____1.call(this,state_35157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__11469__auto____0;
fluree$db$storage$core$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__11469__auto____1;
return fluree$db$storage$core$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_35196 = f__11543__auto__.call(null);
(statearr_35196[(6)] = c__11542__auto__);

return statearr_35196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__11542__auto___35277 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_35255){
var state_val_35256 = (state_35255[(1)]);
if((state_val_35256 === (7))){
var inst_35242 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_35255__$1 = state_35255;
var statearr_35257_35278 = state_35255__$1;
(statearr_35257_35278[(2)] = inst_35242);

(statearr_35257_35278[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35256 === (1))){
var state_35255__$1 = state_35255;
var statearr_35258_35279 = state_35255__$1;
(statearr_35258_35279[(2)] = null);

(statearr_35258_35279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35256 === (4))){
var inst_35226 = (state_35255[(2)]);
var inst_35227 = error_fn.call(null);
var inst_35228 = cljs.core.async.put_BANG_.call(null,return_ch,inst_35226);
var inst_35229 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_35255__$1 = (function (){var statearr_35259 = state_35255;
(statearr_35259[(7)] = inst_35227);

(statearr_35259[(8)] = inst_35228);

return statearr_35259;
})();
var statearr_35260_35280 = state_35255__$1;
(statearr_35260_35280[(2)] = inst_35229);

(statearr_35260_35280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35256 === (6))){
var inst_35237 = (state_35255[(9)]);
var inst_35237__$1 = (state_35255[(2)]);
var inst_35238 = (inst_35237__$1 == null);
var inst_35239 = (inst_35237__$1 instanceof Error);
var inst_35240 = ((inst_35238) || (inst_35239));
var state_35255__$1 = (function (){var statearr_35261 = state_35255;
(statearr_35261[(9)] = inst_35237__$1);

return statearr_35261;
})();
if(cljs.core.truth_(inst_35240)){
var statearr_35262_35281 = state_35255__$1;
(statearr_35262_35281[(1)] = (7));

} else {
var statearr_35263_35282 = state_35255__$1;
(statearr_35263_35282[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35256 === (3))){
var inst_35253 = (state_35255[(2)]);
var state_35255__$1 = state_35255;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35255__$1,inst_35253);
} else {
if((state_val_35256 === (2))){
var _ = (function (){var statearr_35265 = state_35255;
(statearr_35265[(4)] = cljs.core.cons.call(null,(5),(state_35255[(4)])));

return statearr_35265;
})();
var inst_35235 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_35255__$1 = state_35255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35255__$1,(6),inst_35235);
} else {
if((state_val_35256 === (9))){
var inst_35250 = (state_35255[(2)]);
var _ = (function (){var statearr_35266 = state_35255;
(statearr_35266[(4)] = cljs.core.rest.call(null,(state_35255[(4)])));

return statearr_35266;
})();
var state_35255__$1 = state_35255;
var statearr_35267_35283 = state_35255__$1;
(statearr_35267_35283[(2)] = inst_35250);

(statearr_35267_35283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35256 === (5))){
var _ = (function (){var statearr_35268 = state_35255;
(statearr_35268[(4)] = cljs.core.rest.call(null,(state_35255[(4)])));

return statearr_35268;
})();
var state_35255__$1 = state_35255;
var ex35264 = (state_35255__$1[(2)]);
var statearr_35269_35284 = state_35255__$1;
(statearr_35269_35284[(5)] = ex35264);


var statearr_35270_35285 = state_35255__$1;
(statearr_35270_35285[(1)] = (4));

(statearr_35270_35285[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35256 === (8))){
var inst_35237 = (state_35255[(9)]);
var inst_35244 = fluree.db.storage.core.serde.call(null,conn);
var inst_35245 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_35244,inst_35237);
var inst_35246 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_35245);
var inst_35247 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_35246);
var inst_35248 = cljs.core.async.put_BANG_.call(null,return_ch,inst_35247);
var state_35255__$1 = state_35255;
var statearr_35271_35286 = state_35255__$1;
(statearr_35271_35286[(2)] = inst_35248);

(statearr_35271_35286[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__11469__auto____0 = (function (){
var statearr_35272 = [null,null,null,null,null,null,null,null,null,null];
(statearr_35272[(0)] = fluree$db$storage$core$reify_history_$_state_machine__11469__auto__);

(statearr_35272[(1)] = (1));

return statearr_35272;
});
var fluree$db$storage$core$reify_history_$_state_machine__11469__auto____1 = (function (state_35255){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_35255);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e35273){var ex__11472__auto__ = e35273;
var statearr_35274_35287 = state_35255;
(statearr_35274_35287[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_35255[(4)]))){
var statearr_35275_35288 = state_35255;
(statearr_35275_35288[(1)] = cljs.core.first.call(null,(state_35255[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35289 = state_35255;
state_35255 = G__35289;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__11469__auto__ = function(state_35255){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__11469__auto____1.call(this,state_35255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__11469__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__11469__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_35276 = f__11543__auto__.call(null);
(statearr_35276[(6)] = c__11542__auto___35277);

return statearr_35276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__35291 = arguments.length;
switch (G__35291) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return leftmost_QMARK_;
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((((rhs == null))?leftmost_QMARK_:false))?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__11542__auto___35401 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_35354){
var state_val_35355 = (state_35354[(1)]);
if((state_val_35355 === (7))){
var state_35354__$1 = state_35354;
var statearr_35356_35402 = state_35354__$1;
(statearr_35356_35402[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_35356_35402[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (20))){
var inst_35333 = cljs.core.PersistentVector.EMPTY;
var state_35354__$1 = state_35354;
var statearr_35357_35403 = state_35354__$1;
(statearr_35357_35403[(2)] = inst_35333);

(statearr_35357_35403[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (1))){
var state_35354__$1 = state_35354;
var statearr_35358_35404 = state_35354__$1;
(statearr_35358_35404[(2)] = null);

(statearr_35358_35404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (24))){
var state_35354__$1 = state_35354;
var statearr_35359_35405 = state_35354__$1;
(statearr_35359_35405[(2)] = null);

(statearr_35359_35405[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (4))){
var inst_35294 = (state_35354[(2)]);
var inst_35295 = error_fn.call(null);
var inst_35296 = cljs.core.async.put_BANG_.call(null,result_ch,inst_35294);
var inst_35297 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_35354__$1 = (function (){var statearr_35360 = state_35354;
(statearr_35360[(7)] = inst_35296);

(statearr_35360[(8)] = inst_35295);

return statearr_35360;
})();
var statearr_35361_35406 = state_35354__$1;
(statearr_35361_35406[(2)] = inst_35297);

(statearr_35361_35406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (15))){
var inst_35319 = (state_35354[(2)]);
var state_35354__$1 = state_35354;
var statearr_35362_35407 = state_35354__$1;
(statearr_35362_35407[(2)] = inst_35319);

(statearr_35362_35407[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (21))){
var inst_35306 = (state_35354[(9)]);
var inst_35307 = (state_35354[(10)]);
var inst_35308 = (state_35354[(11)]);
var inst_35336 = (state_35354[(12)]);
var inst_35323 = (state_35354[(13)]);
var inst_35343 = (state_35354[(2)]);
var inst_35344 = (function (){var base_node = inst_35306;
var first_flake = inst_35307;
var node_t = inst_35308;
var source = inst_35323;
var coll = inst_35336;
var conj_QMARK_ = inst_35343;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__4126__auto__ = remove_preds;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_35345 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_35306);
var inst_35346 = cljs.core.reduce.call(null,inst_35344,inst_35345,inst_35336);
var inst_35347 = cljs.core.doall.call(null,inst_35346);
var inst_35348 = cljs.core.assoc.call(null,inst_35306,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_35347);
var inst_35349 = cljs.core.async.put_BANG_.call(null,result_ch,inst_35348);
var _ = (function (){var statearr_35363 = state_35354;
(statearr_35363[(4)] = cljs.core.rest.call(null,(state_35354[(4)])));

return statearr_35363;
})();
var state_35354__$1 = state_35354;
var statearr_35364_35408 = state_35354__$1;
(statearr_35364_35408[(2)] = inst_35349);

(statearr_35364_35408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (13))){
var state_35354__$1 = state_35354;
var statearr_35365_35409 = state_35354__$1;
(statearr_35365_35409[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_35365_35409[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (22))){
var inst_35306 = (state_35354[(9)]);
var inst_35307 = (state_35354[(10)]);
var inst_35308 = (state_35354[(11)]);
var inst_35336 = (state_35354[(12)]);
var inst_35323 = (state_35354[(13)]);
var inst_35337 = (function (){var base_node = inst_35306;
var first_flake = inst_35307;
var node_t = inst_35308;
var source = inst_35323;
var coll = inst_35336;
return (function (f){
return f.op === true;
});
})();
var state_35354__$1 = state_35354;
var statearr_35366_35410 = state_35354__$1;
(statearr_35366_35410[(2)] = inst_35337);

(statearr_35366_35410[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (6))){
var inst_35306 = (state_35354[(9)]);
var inst_35308 = (state_35354[(11)]);
var inst_35305 = (state_35354[(2)]);
var inst_35306__$1 = fluree.db.util.async.throw_err.call(null,inst_35305);
var inst_35307 = fluree.db.dbproto._first_flake.call(null,inst_35306__$1);
var inst_35308__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_35306__$1);
var inst_35309 = (inst_35308__$1 > t);
var state_35354__$1 = (function (){var statearr_35367 = state_35354;
(statearr_35367[(9)] = inst_35306__$1);

(statearr_35367[(10)] = inst_35307);

(statearr_35367[(11)] = inst_35308__$1);

return statearr_35367;
})();
if(cljs.core.truth_(inst_35309)){
var statearr_35368_35411 = state_35354__$1;
(statearr_35368_35411[(1)] = (7));

} else {
var statearr_35369_35412 = state_35354__$1;
(statearr_35369_35412[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (17))){
var inst_35307 = (state_35354[(10)]);
var inst_35324 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_35307,rhs,leftmost_QMARK_,t);
var state_35354__$1 = state_35354;
var statearr_35370_35413 = state_35354__$1;
(statearr_35370_35413[(2)] = inst_35324);

(statearr_35370_35413[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (3))){
var inst_35352 = (state_35354[(2)]);
var state_35354__$1 = state_35354;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35354__$1,inst_35352);
} else {
if((state_val_35355 === (12))){
var inst_35321 = (state_35354[(2)]);
var state_35354__$1 = state_35354;
var statearr_35371_35414 = state_35354__$1;
(statearr_35371_35414[(2)] = inst_35321);

(statearr_35371_35414[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (2))){
var _ = (function (){var statearr_35372 = state_35354;
(statearr_35372[(4)] = cljs.core.cons.call(null,(5),(state_35354[(4)])));

return statearr_35372;
})();
var inst_35303 = fluree.db.dbproto._resolve.call(null,node);
var state_35354__$1 = state_35354;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35354__$1,(6),inst_35303);
} else {
if((state_val_35355 === (23))){
var inst_35306 = (state_35354[(9)]);
var inst_35307 = (state_35354[(10)]);
var inst_35308 = (state_35354[(11)]);
var inst_35336 = (state_35354[(12)]);
var inst_35323 = (state_35354[(13)]);
var inst_35339 = (function (){var base_node = inst_35306;
var first_flake = inst_35307;
var node_t = inst_35308;
var source = inst_35323;
var coll = inst_35336;
return (function (f){
return f.op === false;
});
})();
var state_35354__$1 = state_35354;
var statearr_35373_35415 = state_35354__$1;
(statearr_35373_35415[(2)] = inst_35339);

(statearr_35373_35415[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (19))){
var inst_35326 = (state_35354[(14)]);
var inst_35329 = (state_35354[(2)]);
var inst_35330 = fluree.db.util.async.throw_err.call(null,inst_35329);
var inst_35331 = cljs.core.take_while.call(null,inst_35326,inst_35330);
var state_35354__$1 = state_35354;
var statearr_35374_35416 = state_35354__$1;
(statearr_35374_35416[(2)] = inst_35331);

(statearr_35374_35416[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (11))){
var inst_35308 = (state_35354[(11)]);
var inst_35315 = cljs.core._EQ_.call(null,inst_35308,t);
var state_35354__$1 = state_35354;
if(inst_35315){
var statearr_35376_35417 = state_35354__$1;
(statearr_35376_35417[(1)] = (13));

} else {
var statearr_35377_35418 = state_35354__$1;
(statearr_35377_35418[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (9))){
var inst_35323 = (state_35354[(13)]);
var inst_35323__$1 = (state_35354[(2)]);
var state_35354__$1 = (function (){var statearr_35378 = state_35354;
(statearr_35378[(13)] = inst_35323__$1);

return statearr_35378;
})();
var G__35379_35419 = inst_35323__$1;
var G__35379_35420__$1 = (((G__35379_35419 instanceof cljs.core.Keyword))?G__35379_35419.fqn:null);
switch (G__35379_35420__$1) {
case "novelty":
var statearr_35380_35422 = state_35354__$1;
(statearr_35380_35422[(1)] = (17));


break;
case "history":
var statearr_35381_35423 = state_35354__$1;
(statearr_35381_35423[(1)] = (18));


break;
case "none":
var statearr_35382_35424 = state_35354__$1;
(statearr_35382_35424[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35379_35420__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (5))){
var _ = (function (){var statearr_35383 = state_35354;
(statearr_35383[(4)] = cljs.core.rest.call(null,(state_35354[(4)])));

return statearr_35383;
})();
var state_35354__$1 = state_35354;
var ex35375 = (state_35354__$1[(2)]);
var statearr_35384_35425 = state_35354__$1;
(statearr_35384_35425[(5)] = ex35375);


var statearr_35385_35426 = state_35354__$1;
(statearr_35385_35426[(1)] = (4));

(statearr_35385_35426[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (14))){
var state_35354__$1 = state_35354;
var statearr_35386_35427 = state_35354__$1;
(statearr_35386_35427[(2)] = null);

(statearr_35386_35427[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (16))){
var inst_35323 = (state_35354[(13)]);
var inst_35336 = (state_35354[(2)]);
var state_35354__$1 = (function (){var statearr_35387 = state_35354;
(statearr_35387[(12)] = inst_35336);

return statearr_35387;
})();
var G__35388_35428 = inst_35323;
var G__35388_35429__$1 = (((G__35388_35428 instanceof cljs.core.Keyword))?G__35388_35428.fqn:null);
switch (G__35388_35429__$1) {
case "novelty":
var statearr_35389_35431 = state_35354__$1;
(statearr_35389_35431[(1)] = (22));


break;
case "history":
var statearr_35390_35432 = state_35354__$1;
(statearr_35390_35432[(1)] = (23));


break;
case "none":
var statearr_35391_35433 = state_35354__$1;
(statearr_35391_35433[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35388_35429__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (10))){
var state_35354__$1 = state_35354;
var statearr_35392_35434 = state_35354__$1;
(statearr_35392_35434[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_35392_35434[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35355 === (18))){
var inst_35306 = (state_35354[(9)]);
var inst_35307 = (state_35354[(10)]);
var inst_35308 = (state_35354[(11)]);
var inst_35323 = (state_35354[(13)]);
var inst_35326 = (function (){var base_node = inst_35306;
var first_flake = inst_35307;
var node_t = inst_35308;
var source = inst_35323;
return (function (p1__35293_SHARP_){
return (p1__35293_SHARP_.t <= t);
});
})();
var inst_35327 = fluree.db.dbproto._resolve_history.call(null,node);
var state_35354__$1 = (function (){var statearr_35393 = state_35354;
(statearr_35393[(14)] = inst_35326);

return statearr_35393;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35354__$1,(19),inst_35327);
} else {
if((state_val_35355 === (8))){
var inst_35308 = (state_35354[(11)]);
var inst_35312 = (inst_35308 < t);
var state_35354__$1 = state_35354;
if(cljs.core.truth_(inst_35312)){
var statearr_35394_35435 = state_35354__$1;
(statearr_35394_35435[(1)] = (10));

} else {
var statearr_35395_35436 = state_35354__$1;
(statearr_35395_35436[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__11469__auto____0 = (function (){
var statearr_35396 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35396[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__11469__auto__);

(statearr_35396[(1)] = (1));

return statearr_35396;
});
var fluree$db$storage$core$resolve_t_$_state_machine__11469__auto____1 = (function (state_35354){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_35354);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e35397){var ex__11472__auto__ = e35397;
var statearr_35398_35437 = state_35354;
(statearr_35398_35437[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_35354[(4)]))){
var statearr_35399_35438 = state_35354;
(statearr_35399_35438[(1)] = cljs.core.first.call(null,(state_35354[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35439 = state_35354;
state_35354 = G__35439;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__11469__auto__ = function(state_35354){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__11469__auto____1.call(this,state_35354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__11469__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__11469__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_35400 = f__11543__auto__.call(null);
(statearr_35400[(6)] = c__11542__auto___35401);

return statearr_35400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_35496){
var state_val_35497 = (state_35496[(1)]);
if((state_val_35497 === (7))){
var state_35496__$1 = state_35496;
var statearr_35498_35534 = state_35496__$1;
(statearr_35498_35534[(2)] = null);

(statearr_35498_35534[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (1))){
var state_35496__$1 = state_35496;
var statearr_35499_35535 = state_35496__$1;
(statearr_35499_35535[(2)] = null);

(statearr_35499_35535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (4))){
var inst_35442 = (state_35496[(2)]);
var inst_35443 = fluree.db.util.log.error.call(null,inst_35442);
var inst_35444 = (function(){throw inst_35442})();
var state_35496__$1 = (function (){var statearr_35500 = state_35496;
(statearr_35500[(7)] = inst_35443);

return statearr_35500;
})();
var statearr_35501_35536 = state_35496__$1;
(statearr_35501_35536[(2)] = inst_35444);

(statearr_35501_35536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (15))){
var inst_35472 = (state_35496[(2)]);
var state_35496__$1 = state_35496;
var statearr_35502_35537 = state_35496__$1;
(statearr_35502_35537[(2)] = inst_35472);

(statearr_35502_35537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (13))){
var inst_35450 = (state_35496[(8)]);
var inst_35466 = (state_35496[(9)]);
var inst_35468 = (function (){var node_t = inst_35450;
var G__35455 = inst_35466;
return (function (p1__35441_SHARP_){
return (p1__35441_SHARP_.t <= from_t);
});
})();
var inst_35469 = cljs.core.take_while.call(null,inst_35468,inst_35466);
var state_35496__$1 = state_35496;
var statearr_35503_35538 = state_35496__$1;
(statearr_35503_35538[(2)] = inst_35469);

(statearr_35503_35538[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (6))){
var inst_35456 = fluree.db.dbproto._resolve_history.call(null,node);
var state_35496__$1 = state_35496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35496__$1,(9),inst_35456);
} else {
if((state_val_35497 === (17))){
var inst_35481 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_35482 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35481)].join('');
var inst_35483 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_35484 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_35485 = cljs.core.PersistentHashMap.fromArrays(inst_35483,inst_35484);
var inst_35486 = cljs.core.ex_info.call(null,inst_35482,inst_35485);
var inst_35487 = (function(){throw inst_35486})();
var state_35496__$1 = state_35496;
var statearr_35504_35539 = state_35496__$1;
(statearr_35504_35539[(2)] = inst_35487);

(statearr_35504_35539[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (3))){
var inst_35494 = (state_35496[(2)]);
var state_35496__$1 = state_35496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35496__$1,inst_35494);
} else {
if((state_val_35497 === (12))){
var inst_35466 = (state_35496[(2)]);
var state_35496__$1 = (function (){var statearr_35505 = state_35496;
(statearr_35505[(9)] = inst_35466);

return statearr_35505;
})();
if(cljs.core.truth_(from_t)){
var statearr_35506_35540 = state_35496__$1;
(statearr_35506_35540[(1)] = (13));

} else {
var statearr_35507_35541 = state_35496__$1;
(statearr_35507_35541[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (2))){
var inst_35450 = (state_35496[(8)]);
var _ = (function (){var statearr_35508 = state_35496;
(statearr_35508[(4)] = cljs.core.cons.call(null,(5),(state_35496[(4)])));

return statearr_35508;
})();
var inst_35450__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_35451 = (from_t == null);
var inst_35452 = (inst_35450__$1 <= from_t);
var inst_35453 = ((inst_35451) || (inst_35452));
var state_35496__$1 = (function (){var statearr_35509 = state_35496;
(statearr_35509[(8)] = inst_35450__$1);

return statearr_35509;
})();
if(cljs.core.truth_(inst_35453)){
var statearr_35510_35542 = state_35496__$1;
(statearr_35510_35542[(1)] = (6));

} else {
var statearr_35511_35543 = state_35496__$1;
(statearr_35511_35543[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (11))){
var inst_35459 = (state_35496[(10)]);
var state_35496__$1 = state_35496;
var statearr_35513_35544 = state_35496__$1;
(statearr_35513_35544[(2)] = inst_35459);

(statearr_35513_35544[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (9))){
var inst_35450 = (state_35496[(8)]);
var inst_35458 = (state_35496[(2)]);
var inst_35459 = fluree.db.util.async.throw_err.call(null,inst_35458);
var inst_35460 = (to_t > inst_35450);
var state_35496__$1 = (function (){var statearr_35514 = state_35496;
(statearr_35514[(10)] = inst_35459);

return statearr_35514;
})();
if(cljs.core.truth_(inst_35460)){
var statearr_35515_35545 = state_35496__$1;
(statearr_35515_35545[(1)] = (10));

} else {
var statearr_35516_35546 = state_35496__$1;
(statearr_35516_35546[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (5))){
var _ = (function (){var statearr_35517 = state_35496;
(statearr_35517[(4)] = cljs.core.rest.call(null,(state_35496[(4)])));

return statearr_35517;
})();
var state_35496__$1 = state_35496;
var ex35512 = (state_35496__$1[(2)]);
var statearr_35518_35547 = state_35496__$1;
(statearr_35518_35547[(5)] = ex35512);


var statearr_35519_35548 = state_35496__$1;
(statearr_35519_35548[(1)] = (4));

(statearr_35519_35548[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (14))){
var inst_35466 = (state_35496[(9)]);
var state_35496__$1 = state_35496;
var statearr_35520_35549 = state_35496__$1;
(statearr_35520_35549[(2)] = inst_35466);

(statearr_35520_35549[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (16))){
var state_35496__$1 = state_35496;
var statearr_35521_35550 = state_35496__$1;
(statearr_35521_35550[(2)] = null);

(statearr_35521_35550[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (10))){
var inst_35450 = (state_35496[(8)]);
var inst_35459 = (state_35496[(10)]);
var inst_35462 = (function (){var node_t = inst_35450;
var G__35455 = inst_35459;
return (function (p1__35440_SHARP_){
return (p1__35440_SHARP_.t < to_t);
});
})();
var inst_35463 = cljs.core.drop_while.call(null,inst_35462,inst_35459);
var state_35496__$1 = state_35496;
var statearr_35522_35551 = state_35496__$1;
(statearr_35522_35551[(2)] = inst_35463);

(statearr_35522_35551[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (18))){
var inst_35476 = (state_35496[(11)]);
var inst_35475 = (state_35496[(12)]);
var inst_35477 = (state_35496[(13)]);
var inst_35489 = (state_35496[(2)]);
var inst_35490 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_35476,inst_35477,leftmost_QMARK_,to_t);
var inst_35491 = cljs.core.into.call(null,inst_35490,inst_35475);
var _ = (function (){var statearr_35523 = state_35496;
(statearr_35523[(4)] = cljs.core.rest.call(null,(state_35496[(4)])));

return statearr_35523;
})();
var state_35496__$1 = (function (){var statearr_35524 = state_35496;
(statearr_35524[(14)] = inst_35489);

return statearr_35524;
})();
var statearr_35525_35552 = state_35496__$1;
(statearr_35525_35552[(2)] = inst_35491);

(statearr_35525_35552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35497 === (8))){
var inst_35475 = (state_35496[(2)]);
var inst_35476 = fluree.db.dbproto._first_flake.call(null,node);
var inst_35477 = fluree.db.dbproto._rhs.call(null,node);
var inst_35478 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_35496__$1 = (function (){var statearr_35526 = state_35496;
(statearr_35526[(11)] = inst_35476);

(statearr_35526[(12)] = inst_35475);

(statearr_35526[(13)] = inst_35477);

return statearr_35526;
})();
if(cljs.core.truth_(inst_35478)){
var statearr_35527_35553 = state_35496__$1;
(statearr_35527_35553[(1)] = (16));

} else {
var statearr_35528_35554 = state_35496__$1;
(statearr_35528_35554[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__11469__auto____0 = (function (){
var statearr_35529 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35529[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__11469__auto__);

(statearr_35529[(1)] = (1));

return statearr_35529;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__11469__auto____1 = (function (state_35496){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_35496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e35530){var ex__11472__auto__ = e35530;
var statearr_35531_35555 = state_35496;
(statearr_35531_35555[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_35496[(4)]))){
var statearr_35532_35556 = state_35496;
(statearr_35532_35556[(1)] = cljs.core.first.call(null,(state_35496[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35557 = state_35496;
state_35496 = G__35557;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__11469__auto__ = function(state_35496){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__11469__auto____1.call(this,state_35496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__11469__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__11469__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_35533 = f__11543__auto__.call(null);
(statearr_35533[(6)] = c__11542__auto__);

return statearr_35533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4126__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_35578){
var state_val_35579 = (state_35578[(1)]);
if((state_val_35579 === (7))){
var state_35578__$1 = state_35578;
var statearr_35580_35600 = state_35578__$1;
(statearr_35580_35600[(2)] = null);

(statearr_35580_35600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35579 === (1))){
var state_35578__$1 = state_35578;
var statearr_35581_35601 = state_35578__$1;
(statearr_35581_35601[(2)] = null);

(statearr_35581_35601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35579 === (4))){
var inst_35558 = (state_35578[(2)]);
var state_35578__$1 = state_35578;
var statearr_35582_35602 = state_35578__$1;
(statearr_35582_35602[(2)] = inst_35558);

(statearr_35582_35602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35579 === (6))){
var inst_35564 = (state_35578[(7)]);
var inst_35566 = fluree.db.storage.core.serde.call(null,conn);
var state_35578__$1 = (function (){var statearr_35583 = state_35578;
(statearr_35583[(8)] = inst_35566);

return statearr_35583;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35578__$1,(9),inst_35564);
} else {
if((state_val_35579 === (3))){
var inst_35576 = (state_35578[(2)]);
var state_35578__$1 = state_35578;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35578__$1,inst_35576);
} else {
if((state_val_35579 === (2))){
var inst_35564 = (state_35578[(7)]);
var _ = (function (){var statearr_35585 = state_35578;
(statearr_35585[(4)] = cljs.core.cons.call(null,(5),(state_35578[(4)])));

return statearr_35585;
})();
var inst_35564__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_35578__$1 = (function (){var statearr_35586 = state_35578;
(statearr_35586[(7)] = inst_35564__$1);

return statearr_35586;
})();
if(cljs.core.truth_(inst_35564__$1)){
var statearr_35587_35603 = state_35578__$1;
(statearr_35587_35603[(1)] = (6));

} else {
var statearr_35588_35604 = state_35578__$1;
(statearr_35588_35604[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35579 === (9))){
var inst_35566 = (state_35578[(8)]);
var inst_35568 = (state_35578[(2)]);
var inst_35569 = fluree.db.util.async.throw_err.call(null,inst_35568);
var inst_35570 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_35566,inst_35569);
var state_35578__$1 = state_35578;
var statearr_35589_35605 = state_35578__$1;
(statearr_35589_35605[(2)] = inst_35570);

(statearr_35589_35605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35579 === (5))){
var _ = (function (){var statearr_35590 = state_35578;
(statearr_35590[(4)] = cljs.core.rest.call(null,(state_35578[(4)])));

return statearr_35590;
})();
var state_35578__$1 = state_35578;
var ex35584 = (state_35578__$1[(2)]);
var statearr_35591_35606 = state_35578__$1;
(statearr_35591_35606[(5)] = ex35584);


if((ex35584 instanceof Error)){
var statearr_35592_35607 = state_35578__$1;
(statearr_35592_35607[(1)] = (4));

(statearr_35592_35607[(5)] = null);

} else {
throw ex35584;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35579 === (8))){
var inst_35573 = (state_35578[(2)]);
var _ = (function (){var statearr_35593 = state_35578;
(statearr_35593[(4)] = cljs.core.rest.call(null,(state_35578[(4)])));

return statearr_35593;
})();
var state_35578__$1 = state_35578;
var statearr_35594_35608 = state_35578__$1;
(statearr_35594_35608[(2)] = inst_35573);

(statearr_35594_35608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__11469__auto____0 = (function (){
var statearr_35595 = [null,null,null,null,null,null,null,null,null];
(statearr_35595[(0)] = fluree$db$storage$core$read_branch_$_state_machine__11469__auto__);

(statearr_35595[(1)] = (1));

return statearr_35595;
});
var fluree$db$storage$core$read_branch_$_state_machine__11469__auto____1 = (function (state_35578){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_35578);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e35596){var ex__11472__auto__ = e35596;
var statearr_35597_35609 = state_35578;
(statearr_35597_35609[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_35578[(4)]))){
var statearr_35598_35610 = state_35578;
(statearr_35598_35610[(1)] = cljs.core.first.call(null,(state_35578[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35611 = state_35578;
state_35578 = G__35611;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__11469__auto__ = function(state_35578){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__11469__auto____1.call(this,state_35578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__11469__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__11469__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_35599 = f__11543__auto__.call(null);
(statearr_35599[(6)] = c__11542__auto__);

return statearr_35599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__11542__auto___35757 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_35702){
var state_val_35703 = (state_35702[(1)]);
if((state_val_35703 === (7))){
var inst_35629 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_35630 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_35631 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_35632 = cljs.core.PersistentHashMap.fromArrays(inst_35630,inst_35631);
var inst_35633 = cljs.core.ex_info.call(null,inst_35629,inst_35632);
var inst_35634 = (function(){throw inst_35633})();
var state_35702__$1 = state_35702;
var statearr_35704_35758 = state_35702__$1;
(statearr_35704_35758[(2)] = inst_35634);

(statearr_35704_35758[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (20))){
var inst_35626 = (state_35702[(7)]);
var state_35702__$1 = state_35702;
var statearr_35705_35759 = state_35702__$1;
(statearr_35705_35759[(2)] = inst_35626);

(statearr_35705_35759[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (27))){
var inst_35680 = (state_35702[(2)]);
var state_35702__$1 = state_35702;
var statearr_35706_35760 = state_35702__$1;
(statearr_35706_35760[(2)] = inst_35680);

(statearr_35706_35760[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (1))){
var state_35702__$1 = state_35702;
var statearr_35707_35761 = state_35702__$1;
(statearr_35707_35761[(2)] = null);

(statearr_35707_35761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (24))){
var inst_35683 = (state_35702[(2)]);
var state_35702__$1 = state_35702;
if(cljs.core.truth_(inst_35683)){
var statearr_35708_35762 = state_35702__$1;
(statearr_35708_35762[(1)] = (28));

} else {
var statearr_35709_35763 = state_35702__$1;
(statearr_35709_35763[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (4))){
var inst_35612 = (state_35702[(2)]);
var inst_35613 = error_fn.call(null);
var inst_35614 = cljs.core.async.put_BANG_.call(null,return_ch,inst_35612);
var inst_35615 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_35702__$1 = (function (){var statearr_35710 = state_35702;
(statearr_35710[(8)] = inst_35613);

(statearr_35710[(9)] = inst_35614);

return statearr_35710;
})();
var statearr_35711_35764 = state_35702__$1;
(statearr_35711_35764[(2)] = inst_35615);

(statearr_35711_35764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (15))){
var inst_35659 = (state_35702[(2)]);
var state_35702__$1 = state_35702;
if(cljs.core.truth_(inst_35659)){
var statearr_35712_35765 = state_35702__$1;
(statearr_35712_35765[(1)] = (19));

} else {
var statearr_35713_35766 = state_35702__$1;
(statearr_35713_35766[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (21))){
var inst_35667 = (state_35702[(10)]);
var inst_35664 = (state_35702[(11)]);
var inst_35664__$1 = (state_35702[(2)]);
var inst_35665 = cljs.core.get.call(null,inst_35664__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_35666 = cljs.core.get.call(null,inst_35664__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_35667__$1 = config;
var inst_35669 = (inst_35667__$1 == null);
var inst_35670 = cljs.core.not.call(null,inst_35669);
var state_35702__$1 = (function (){var statearr_35714 = state_35702;
(statearr_35714[(10)] = inst_35667__$1);

(statearr_35714[(12)] = inst_35666);

(statearr_35714[(13)] = inst_35665);

(statearr_35714[(11)] = inst_35664__$1);

return statearr_35714;
})();
if(inst_35670){
var statearr_35715_35767 = state_35702__$1;
(statearr_35715_35767[(1)] = (22));

} else {
var statearr_35716_35768 = state_35702__$1;
(statearr_35716_35768[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (13))){
var inst_35626 = (state_35702[(7)]);
var inst_35648 = inst_35626.cljs$lang$protocol_mask$partition0$;
var inst_35649 = (inst_35648 & (64));
var inst_35650 = inst_35626.cljs$core$ISeq$;
var inst_35651 = (cljs.core.PROTOCOL_SENTINEL === inst_35650);
var inst_35652 = ((inst_35649) || (inst_35651));
var state_35702__$1 = state_35702;
if(cljs.core.truth_(inst_35652)){
var statearr_35717_35769 = state_35702__$1;
(statearr_35717_35769[(1)] = (16));

} else {
var statearr_35718_35770 = state_35702__$1;
(statearr_35718_35770[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (22))){
var inst_35667 = (state_35702[(10)]);
var inst_35672 = inst_35667.cljs$lang$protocol_mask$partition0$;
var inst_35673 = (inst_35672 & (64));
var inst_35674 = inst_35667.cljs$core$ISeq$;
var inst_35675 = (cljs.core.PROTOCOL_SENTINEL === inst_35674);
var inst_35676 = ((inst_35673) || (inst_35675));
var state_35702__$1 = state_35702;
if(cljs.core.truth_(inst_35676)){
var statearr_35719_35771 = state_35702__$1;
(statearr_35719_35771[(1)] = (25));

} else {
var statearr_35720_35772 = state_35702__$1;
(statearr_35720_35772[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (29))){
var inst_35667 = (state_35702[(10)]);
var state_35702__$1 = state_35702;
var statearr_35721_35773 = state_35702__$1;
(statearr_35721_35773[(2)] = inst_35667);

(statearr_35721_35773[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (6))){
var inst_35626 = (state_35702[(7)]);
var inst_35625 = (state_35702[(2)]);
var inst_35626__$1 = fluree.db.util.async.throw_err.call(null,inst_35625);
var inst_35627 = (inst_35626__$1 == null);
var state_35702__$1 = (function (){var statearr_35722 = state_35702;
(statearr_35722[(7)] = inst_35626__$1);

return statearr_35722;
})();
if(cljs.core.truth_(inst_35627)){
var statearr_35723_35774 = state_35702__$1;
(statearr_35723_35774[(1)] = (7));

} else {
var statearr_35724_35775 = state_35702__$1;
(statearr_35724_35775[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (28))){
var inst_35667 = (state_35702[(10)]);
var inst_35685 = cljs.core.apply.call(null,cljs.core.hash_map,inst_35667);
var state_35702__$1 = state_35702;
var statearr_35725_35776 = state_35702__$1;
(statearr_35725_35776[(2)] = inst_35685);

(statearr_35725_35776[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (25))){
var state_35702__$1 = state_35702;
var statearr_35726_35777 = state_35702__$1;
(statearr_35726_35777[(2)] = true);

(statearr_35726_35777[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (17))){
var state_35702__$1 = state_35702;
var statearr_35727_35778 = state_35702__$1;
(statearr_35727_35778[(2)] = false);

(statearr_35727_35778[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (3))){
var inst_35700 = (state_35702[(2)]);
var state_35702__$1 = state_35702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35702__$1,inst_35700);
} else {
if((state_val_35703 === (12))){
var inst_35626 = (state_35702[(7)]);
var inst_35643 = (state_35702[(2)]);
var inst_35645 = (inst_35626 == null);
var inst_35646 = cljs.core.not.call(null,inst_35645);
var state_35702__$1 = (function (){var statearr_35728 = state_35702;
(statearr_35728[(14)] = inst_35643);

return statearr_35728;
})();
if(inst_35646){
var statearr_35729_35779 = state_35702__$1;
(statearr_35729_35779[(1)] = (13));

} else {
var statearr_35730_35780 = state_35702__$1;
(statearr_35730_35780[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (2))){
var _ = (function (){var statearr_35731 = state_35702;
(statearr_35731[(4)] = cljs.core.cons.call(null,(5),(state_35702[(4)])));

return statearr_35731;
})();
var inst_35623 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_35702__$1 = state_35702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35702__$1,(6),inst_35623);
} else {
if((state_val_35703 === (23))){
var state_35702__$1 = state_35702;
var statearr_35732_35781 = state_35702__$1;
(statearr_35732_35781[(2)] = false);

(statearr_35732_35781[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (19))){
var inst_35626 = (state_35702[(7)]);
var inst_35661 = cljs.core.apply.call(null,cljs.core.hash_map,inst_35626);
var state_35702__$1 = state_35702;
var statearr_35733_35782 = state_35702__$1;
(statearr_35733_35782[(2)] = inst_35661);

(statearr_35733_35782[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (11))){
var state_35702__$1 = state_35702;
var statearr_35735_35783 = state_35702__$1;
(statearr_35735_35783[(2)] = null);

(statearr_35735_35783[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (9))){
var inst_35626 = (state_35702[(7)]);
var inst_35637 = (state_35702[(2)]);
var inst_35638 = fluree.db.util.core.exception_QMARK_.call(null,inst_35626);
var state_35702__$1 = (function (){var statearr_35736 = state_35702;
(statearr_35736[(15)] = inst_35637);

return statearr_35736;
})();
if(inst_35638){
var statearr_35737_35784 = state_35702__$1;
(statearr_35737_35784[(1)] = (10));

} else {
var statearr_35738_35785 = state_35702__$1;
(statearr_35738_35785[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (5))){
var _ = (function (){var statearr_35739 = state_35702;
(statearr_35739[(4)] = cljs.core.rest.call(null,(state_35702[(4)])));

return statearr_35739;
})();
var state_35702__$1 = state_35702;
var ex35734 = (state_35702__$1[(2)]);
var statearr_35740_35786 = state_35702__$1;
(statearr_35740_35786[(5)] = ex35734);


var statearr_35741_35787 = state_35702__$1;
(statearr_35741_35787[(1)] = (4));

(statearr_35741_35787[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (14))){
var state_35702__$1 = state_35702;
var statearr_35742_35788 = state_35702__$1;
(statearr_35742_35788[(2)] = false);

(statearr_35742_35788[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (26))){
var state_35702__$1 = state_35702;
var statearr_35743_35789 = state_35702__$1;
(statearr_35743_35789[(2)] = false);

(statearr_35743_35789[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (16))){
var state_35702__$1 = state_35702;
var statearr_35744_35790 = state_35702__$1;
(statearr_35744_35790[(2)] = true);

(statearr_35744_35790[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (30))){
var inst_35666 = (state_35702[(12)]);
var inst_35665 = (state_35702[(13)]);
var inst_35626 = (state_35702[(7)]);
var inst_35664 = (state_35702[(11)]);
var inst_35643 = (state_35702[(14)]);
var inst_35688 = (state_35702[(2)]);
var inst_35689 = cljs.core.get.call(null,inst_35688,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_35691 = (function (){var data = inst_35626;
var _ = inst_35643;
var map__35621 = inst_35664;
var children = inst_35665;
var rhs = inst_35666;
var map__35622 = inst_35688;
var comparator = inst_35689;
return (function (idx,p__35690){
var map__35745 = p__35690;
var map__35745__$1 = (((((!((map__35745 == null))))?(((((map__35745.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35745.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35745):map__35745);
var child = map__35745__$1;
var id = cljs.core.get.call(null,map__35745__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__35745__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__35745__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__35745__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__35745__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4115__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (idx === (0));
} else {
return and__4115__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_35692 = cljs.core.map_indexed.call(null,inst_35691,inst_35665);
var inst_35693 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_35692);
var inst_35694 = cljs.core.interleave.call(null,inst_35693,inst_35692);
var inst_35695 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_35689,inst_35694);
var inst_35696 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_35666,inst_35695,config,leftmost_QMARK_);
var inst_35697 = cljs.core.async.put_BANG_.call(null,return_ch,inst_35696);
var _ = (function (){var statearr_35747 = state_35702;
(statearr_35747[(4)] = cljs.core.rest.call(null,(state_35702[(4)])));

return statearr_35747;
})();
var state_35702__$1 = state_35702;
var statearr_35748_35791 = state_35702__$1;
(statearr_35748_35791[(2)] = inst_35697);

(statearr_35748_35791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (10))){
var inst_35626 = (state_35702[(7)]);
var inst_35640 = (function(){throw inst_35626})();
var state_35702__$1 = state_35702;
var statearr_35749_35792 = state_35702__$1;
(statearr_35749_35792[(2)] = inst_35640);

(statearr_35749_35792[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (18))){
var inst_35656 = (state_35702[(2)]);
var state_35702__$1 = state_35702;
var statearr_35750_35793 = state_35702__$1;
(statearr_35750_35793[(2)] = inst_35656);

(statearr_35750_35793[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35703 === (8))){
var state_35702__$1 = state_35702;
var statearr_35751_35794 = state_35702__$1;
(statearr_35751_35794[(2)] = null);

(statearr_35751_35794[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__11469__auto____0 = (function (){
var statearr_35752 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35752[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__11469__auto__);

(statearr_35752[(1)] = (1));

return statearr_35752;
});
var fluree$db$storage$core$reify_branch_$_state_machine__11469__auto____1 = (function (state_35702){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_35702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e35753){var ex__11472__auto__ = e35753;
var statearr_35754_35795 = state_35702;
(statearr_35754_35795[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_35702[(4)]))){
var statearr_35755_35796 = state_35702;
(statearr_35755_35796[(1)] = cljs.core.first.call(null,(state_35702[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35797 = state_35702;
state_35702 = G__35797;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__11469__auto__ = function(state_35702){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__11469__auto____1.call(this,state_35702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__11469__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__11469__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_35756 = f__11543__auto__.call(null);
(statearr_35756[(6)] = c__11542__auto___35757);

return statearr_35756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_35818){
var state_val_35819 = (state_35818[(1)]);
if((state_val_35819 === (7))){
var state_35818__$1 = state_35818;
var statearr_35820_35840 = state_35818__$1;
(statearr_35820_35840[(2)] = null);

(statearr_35820_35840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35819 === (1))){
var state_35818__$1 = state_35818;
var statearr_35821_35841 = state_35818__$1;
(statearr_35821_35841[(2)] = null);

(statearr_35821_35841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35819 === (4))){
var inst_35798 = (state_35818[(2)]);
var state_35818__$1 = state_35818;
var statearr_35822_35842 = state_35818__$1;
(statearr_35822_35842[(2)] = inst_35798);

(statearr_35822_35842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35819 === (6))){
var inst_35804 = (state_35818[(7)]);
var inst_35806 = fluree.db.storage.core.serde.call(null,conn);
var state_35818__$1 = (function (){var statearr_35823 = state_35818;
(statearr_35823[(8)] = inst_35806);

return statearr_35823;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35818__$1,(9),inst_35804);
} else {
if((state_val_35819 === (3))){
var inst_35816 = (state_35818[(2)]);
var state_35818__$1 = state_35818;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35818__$1,inst_35816);
} else {
if((state_val_35819 === (2))){
var inst_35804 = (state_35818[(7)]);
var _ = (function (){var statearr_35825 = state_35818;
(statearr_35825[(4)] = cljs.core.cons.call(null,(5),(state_35818[(4)])));

return statearr_35825;
})();
var inst_35804__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_35818__$1 = (function (){var statearr_35826 = state_35818;
(statearr_35826[(7)] = inst_35804__$1);

return statearr_35826;
})();
if(cljs.core.truth_(inst_35804__$1)){
var statearr_35827_35843 = state_35818__$1;
(statearr_35827_35843[(1)] = (6));

} else {
var statearr_35828_35844 = state_35818__$1;
(statearr_35828_35844[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35819 === (9))){
var inst_35806 = (state_35818[(8)]);
var inst_35808 = (state_35818[(2)]);
var inst_35809 = fluree.db.util.async.throw_err.call(null,inst_35808);
var inst_35810 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_35806,inst_35809);
var state_35818__$1 = state_35818;
var statearr_35829_35845 = state_35818__$1;
(statearr_35829_35845[(2)] = inst_35810);

(statearr_35829_35845[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35819 === (5))){
var _ = (function (){var statearr_35830 = state_35818;
(statearr_35830[(4)] = cljs.core.rest.call(null,(state_35818[(4)])));

return statearr_35830;
})();
var state_35818__$1 = state_35818;
var ex35824 = (state_35818__$1[(2)]);
var statearr_35831_35846 = state_35818__$1;
(statearr_35831_35846[(5)] = ex35824);


if((ex35824 instanceof Error)){
var statearr_35832_35847 = state_35818__$1;
(statearr_35832_35847[(1)] = (4));

(statearr_35832_35847[(5)] = null);

} else {
throw ex35824;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35819 === (8))){
var inst_35813 = (state_35818[(2)]);
var _ = (function (){var statearr_35833 = state_35818;
(statearr_35833[(4)] = cljs.core.rest.call(null,(state_35818[(4)])));

return statearr_35833;
})();
var state_35818__$1 = state_35818;
var statearr_35834_35848 = state_35818__$1;
(statearr_35834_35848[(2)] = inst_35813);

(statearr_35834_35848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__11469__auto____0 = (function (){
var statearr_35835 = [null,null,null,null,null,null,null,null,null];
(statearr_35835[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__11469__auto__);

(statearr_35835[(1)] = (1));

return statearr_35835;
});
var fluree$db$storage$core$read_leaf_$_state_machine__11469__auto____1 = (function (state_35818){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_35818);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e35836){var ex__11472__auto__ = e35836;
var statearr_35837_35849 = state_35818;
(statearr_35837_35849[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_35818[(4)]))){
var statearr_35838_35850 = state_35818;
(statearr_35838_35850[(1)] = cljs.core.first.call(null,(state_35818[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35851 = state_35818;
state_35818 = G__35851;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__11469__auto__ = function(state_35818){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__11469__auto____1.call(this,state_35818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__11469__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__11469__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_35839 = f__11543__auto__.call(null);
(statearr_35839[(6)] = c__11542__auto__);

return statearr_35839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__11542__auto___35989 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_35936){
var state_val_35937 = (state_35936[(1)]);
if((state_val_35937 === (7))){
var inst_35868 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_35869 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_35870 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_35871 = cljs.core.PersistentHashMap.fromArrays(inst_35869,inst_35870);
var inst_35872 = cljs.core.ex_info.call(null,inst_35868,inst_35871);
var inst_35873 = (function(){throw inst_35872})();
var state_35936__$1 = state_35936;
var statearr_35938_35990 = state_35936__$1;
(statearr_35938_35990[(2)] = inst_35873);

(statearr_35938_35990[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (20))){
var inst_35865 = (state_35936[(7)]);
var state_35936__$1 = state_35936;
var statearr_35939_35991 = state_35936__$1;
(statearr_35939_35991[(2)] = inst_35865);

(statearr_35939_35991[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (27))){
var inst_35919 = (state_35936[(2)]);
var state_35936__$1 = state_35936;
var statearr_35940_35992 = state_35936__$1;
(statearr_35940_35992[(2)] = inst_35919);

(statearr_35940_35992[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (1))){
var state_35936__$1 = state_35936;
var statearr_35941_35993 = state_35936__$1;
(statearr_35941_35993[(2)] = null);

(statearr_35941_35993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (24))){
var inst_35922 = (state_35936[(2)]);
var state_35936__$1 = state_35936;
if(cljs.core.truth_(inst_35922)){
var statearr_35942_35994 = state_35936__$1;
(statearr_35942_35994[(1)] = (28));

} else {
var statearr_35943_35995 = state_35936__$1;
(statearr_35943_35995[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (4))){
var inst_35852 = (state_35936[(2)]);
var inst_35853 = error_fn.call(null);
var inst_35854 = cljs.core.async.put_BANG_.call(null,return_ch,inst_35852);
var inst_35855 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_35936__$1 = (function (){var statearr_35944 = state_35936;
(statearr_35944[(8)] = inst_35853);

(statearr_35944[(9)] = inst_35854);

return statearr_35944;
})();
var statearr_35945_35996 = state_35936__$1;
(statearr_35945_35996[(2)] = inst_35855);

(statearr_35945_35996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (15))){
var inst_35898 = (state_35936[(2)]);
var state_35936__$1 = state_35936;
if(cljs.core.truth_(inst_35898)){
var statearr_35946_35997 = state_35936__$1;
(statearr_35946_35997[(1)] = (19));

} else {
var statearr_35947_35998 = state_35936__$1;
(statearr_35947_35998[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (21))){
var inst_35906 = (state_35936[(10)]);
var inst_35903 = (state_35936[(2)]);
var inst_35904 = cljs.core.get.call(null,inst_35903,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_35905 = cljs.core.get.call(null,inst_35903,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_35906__$1 = config;
var inst_35908 = (inst_35906__$1 == null);
var inst_35909 = cljs.core.not.call(null,inst_35908);
var state_35936__$1 = (function (){var statearr_35948 = state_35936;
(statearr_35948[(10)] = inst_35906__$1);

(statearr_35948[(11)] = inst_35905);

(statearr_35948[(12)] = inst_35904);

return statearr_35948;
})();
if(inst_35909){
var statearr_35949_35999 = state_35936__$1;
(statearr_35949_35999[(1)] = (22));

} else {
var statearr_35950_36000 = state_35936__$1;
(statearr_35950_36000[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (13))){
var inst_35865 = (state_35936[(7)]);
var inst_35887 = inst_35865.cljs$lang$protocol_mask$partition0$;
var inst_35888 = (inst_35887 & (64));
var inst_35889 = inst_35865.cljs$core$ISeq$;
var inst_35890 = (cljs.core.PROTOCOL_SENTINEL === inst_35889);
var inst_35891 = ((inst_35888) || (inst_35890));
var state_35936__$1 = state_35936;
if(cljs.core.truth_(inst_35891)){
var statearr_35951_36001 = state_35936__$1;
(statearr_35951_36001[(1)] = (16));

} else {
var statearr_35952_36002 = state_35936__$1;
(statearr_35952_36002[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (22))){
var inst_35906 = (state_35936[(10)]);
var inst_35911 = inst_35906.cljs$lang$protocol_mask$partition0$;
var inst_35912 = (inst_35911 & (64));
var inst_35913 = inst_35906.cljs$core$ISeq$;
var inst_35914 = (cljs.core.PROTOCOL_SENTINEL === inst_35913);
var inst_35915 = ((inst_35912) || (inst_35914));
var state_35936__$1 = state_35936;
if(cljs.core.truth_(inst_35915)){
var statearr_35953_36003 = state_35936__$1;
(statearr_35953_36003[(1)] = (25));

} else {
var statearr_35954_36004 = state_35936__$1;
(statearr_35954_36004[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (29))){
var inst_35906 = (state_35936[(10)]);
var state_35936__$1 = state_35936;
var statearr_35955_36005 = state_35936__$1;
(statearr_35955_36005[(2)] = inst_35906);

(statearr_35955_36005[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (6))){
var inst_35865 = (state_35936[(7)]);
var inst_35865__$1 = (state_35936[(2)]);
var inst_35866 = (inst_35865__$1 == null);
var state_35936__$1 = (function (){var statearr_35956 = state_35936;
(statearr_35956[(7)] = inst_35865__$1);

return statearr_35956;
})();
if(cljs.core.truth_(inst_35866)){
var statearr_35957_36006 = state_35936__$1;
(statearr_35957_36006[(1)] = (7));

} else {
var statearr_35958_36007 = state_35936__$1;
(statearr_35958_36007[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (28))){
var inst_35906 = (state_35936[(10)]);
var inst_35924 = cljs.core.apply.call(null,cljs.core.hash_map,inst_35906);
var state_35936__$1 = state_35936;
var statearr_35959_36008 = state_35936__$1;
(statearr_35959_36008[(2)] = inst_35924);

(statearr_35959_36008[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (25))){
var state_35936__$1 = state_35936;
var statearr_35960_36009 = state_35936__$1;
(statearr_35960_36009[(2)] = true);

(statearr_35960_36009[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (17))){
var state_35936__$1 = state_35936;
var statearr_35961_36010 = state_35936__$1;
(statearr_35961_36010[(2)] = false);

(statearr_35961_36010[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (3))){
var inst_35934 = (state_35936[(2)]);
var state_35936__$1 = state_35936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35936__$1,inst_35934);
} else {
if((state_val_35937 === (12))){
var inst_35865 = (state_35936[(7)]);
var inst_35882 = (state_35936[(2)]);
var inst_35884 = (inst_35865 == null);
var inst_35885 = cljs.core.not.call(null,inst_35884);
var state_35936__$1 = (function (){var statearr_35962 = state_35936;
(statearr_35962[(13)] = inst_35882);

return statearr_35962;
})();
if(inst_35885){
var statearr_35963_36011 = state_35936__$1;
(statearr_35963_36011[(1)] = (13));

} else {
var statearr_35964_36012 = state_35936__$1;
(statearr_35964_36012[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (2))){
var _ = (function (){var statearr_35965 = state_35936;
(statearr_35965[(4)] = cljs.core.cons.call(null,(5),(state_35936[(4)])));

return statearr_35965;
})();
var inst_35863 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_35936__$1 = state_35936;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35936__$1,(6),inst_35863);
} else {
if((state_val_35937 === (23))){
var state_35936__$1 = state_35936;
var statearr_35966_36013 = state_35936__$1;
(statearr_35966_36013[(2)] = false);

(statearr_35966_36013[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (19))){
var inst_35865 = (state_35936[(7)]);
var inst_35900 = cljs.core.apply.call(null,cljs.core.hash_map,inst_35865);
var state_35936__$1 = state_35936;
var statearr_35967_36014 = state_35936__$1;
(statearr_35967_36014[(2)] = inst_35900);

(statearr_35967_36014[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (11))){
var state_35936__$1 = state_35936;
var statearr_35969_36015 = state_35936__$1;
(statearr_35969_36015[(2)] = null);

(statearr_35969_36015[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (9))){
var inst_35865 = (state_35936[(7)]);
var inst_35876 = (state_35936[(2)]);
var inst_35877 = fluree.db.util.core.exception_QMARK_.call(null,inst_35865);
var state_35936__$1 = (function (){var statearr_35970 = state_35936;
(statearr_35970[(14)] = inst_35876);

return statearr_35970;
})();
if(inst_35877){
var statearr_35971_36016 = state_35936__$1;
(statearr_35971_36016[(1)] = (10));

} else {
var statearr_35972_36017 = state_35936__$1;
(statearr_35972_36017[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (5))){
var _ = (function (){var statearr_35973 = state_35936;
(statearr_35973[(4)] = cljs.core.rest.call(null,(state_35936[(4)])));

return statearr_35973;
})();
var state_35936__$1 = state_35936;
var ex35968 = (state_35936__$1[(2)]);
var statearr_35974_36018 = state_35936__$1;
(statearr_35974_36018[(5)] = ex35968);


var statearr_35975_36019 = state_35936__$1;
(statearr_35975_36019[(1)] = (4));

(statearr_35975_36019[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (14))){
var state_35936__$1 = state_35936;
var statearr_35976_36020 = state_35936__$1;
(statearr_35976_36020[(2)] = false);

(statearr_35976_36020[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (26))){
var state_35936__$1 = state_35936;
var statearr_35977_36021 = state_35936__$1;
(statearr_35977_36021[(2)] = false);

(statearr_35977_36021[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (16))){
var state_35936__$1 = state_35936;
var statearr_35978_36022 = state_35936__$1;
(statearr_35978_36022[(2)] = true);

(statearr_35978_36022[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (30))){
var inst_35904 = (state_35936[(12)]);
var inst_35927 = (state_35936[(2)]);
var inst_35928 = cljs.core.get.call(null,inst_35927,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_35929 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_35928,inst_35904);
var inst_35930 = fluree.db.index.data_node.call(null,block,t,inst_35929,rhs,config);
var inst_35931 = cljs.core.async.put_BANG_.call(null,return_ch,inst_35930);
var _ = (function (){var statearr_35979 = state_35936;
(statearr_35979[(4)] = cljs.core.rest.call(null,(state_35936[(4)])));

return statearr_35979;
})();
var state_35936__$1 = state_35936;
var statearr_35980_36023 = state_35936__$1;
(statearr_35980_36023[(2)] = inst_35931);

(statearr_35980_36023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (10))){
var inst_35865 = (state_35936[(7)]);
var inst_35879 = (function(){throw inst_35865})();
var state_35936__$1 = state_35936;
var statearr_35981_36024 = state_35936__$1;
(statearr_35981_36024[(2)] = inst_35879);

(statearr_35981_36024[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (18))){
var inst_35895 = (state_35936[(2)]);
var state_35936__$1 = state_35936;
var statearr_35982_36025 = state_35936__$1;
(statearr_35982_36025[(2)] = inst_35895);

(statearr_35982_36025[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (8))){
var state_35936__$1 = state_35936;
var statearr_35983_36026 = state_35936__$1;
(statearr_35983_36026[(2)] = null);

(statearr_35983_36026[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__11469__auto____0 = (function (){
var statearr_35984 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35984[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__11469__auto__);

(statearr_35984[(1)] = (1));

return statearr_35984;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__11469__auto____1 = (function (state_35936){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_35936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e35985){var ex__11472__auto__ = e35985;
var statearr_35986_36027 = state_35936;
(statearr_35986_36027[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_35936[(4)]))){
var statearr_35987_36028 = state_35936;
(statearr_35987_36028[(1)] = cljs.core.first.call(null,(state_35936[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36029 = state_35936;
state_35936 = G__36029;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__11469__auto__ = function(state_35936){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__11469__auto____1.call(this,state_35936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__11469__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__11469__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_35988 = f__11543__auto__.call(null);
(statearr_35988[(6)] = c__11542__auto___35989);

return statearr_35988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k36031,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__36035 = k36031;
var G__36035__$1 = (((G__36035 instanceof cljs.core.Keyword))?G__36035.fqn:null);
switch (G__36035__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k36031,else__4383__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__36036){
var vec__36037 = p__36036;
var k__4403__auto__ = cljs.core.nth.call(null,vec__36037,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__36037,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__36030){
var self__ = this;
var G__36030__$1 = this;
return (new cljs.core.RecordIter((0),G__36030__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this36032,other36033){
var self__ = this;
var this36032__$1 = this;
return (((!((other36033 == null)))) && ((this36032__$1.constructor === other36033.constructor)) && (cljs.core._EQ_.call(null,this36032__$1.conn,other36033.conn)) && (cljs.core._EQ_.call(null,this36032__$1.config,other36033.config)) && (cljs.core._EQ_.call(null,this36032__$1.network,other36033.network)) && (cljs.core._EQ_.call(null,this36032__$1.dbid,other36033.dbid)) && (cljs.core._EQ_.call(null,this36032__$1.id,other36033.id)) && (cljs.core._EQ_.call(null,this36032__$1.leaf,other36033.leaf)) && (cljs.core._EQ_.call(null,this36032__$1.first,other36033.first)) && (cljs.core._EQ_.call(null,this36032__$1.rhs,other36033.rhs)) && (cljs.core._EQ_.call(null,this36032__$1.size,other36033.size)) && (cljs.core._EQ_.call(null,this36032__$1.block,other36033.block)) && (cljs.core._EQ_.call(null,this36032__$1.t,other36033.t)) && (cljs.core._EQ_.call(null,this36032__$1.tt_id,other36033.tt_id)) && (cljs.core._EQ_.call(null,this36032__$1.leftmost_QMARK_,other36033.leftmost_QMARK_)) && (cljs.core._EQ_.call(null,this36032__$1.tempid,other36033.tempid)) && (cljs.core._EQ_.call(null,this36032__$1.__extmap,other36033.__extmap)));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__36030){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__36040 = cljs.core.keyword_identical_QMARK_;
var expr__36041 = k__4388__auto__;
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(G__36030,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__36030,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__36030,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__36030,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__36030,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__36030,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__36030,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__36030,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__36030,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__36030,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__36030,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__36030,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__36030,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36040.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__36041))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__36030,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__36030),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__36030){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__36030,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__36034){
var extmap__4419__auto__ = (function (){var G__36043 = cljs.core.dissoc.call(null,G__36034,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__36034)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__36043);
} else {
return G__36043;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__36034),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__36034),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4126__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__36045 = blank_db;
var map__36045__$1 = (((((!((map__36045 == null))))?(((((map__36045.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36045.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36045):map__36045);
var network = cljs.core.get.call(null,map__36045__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__36045__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__36045__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__36046 = root_data;
var map__36046__$1 = (((((!((map__36046 == null))))?(((((map__36046.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36046.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36046):map__36046);
var block = cljs.core.get.call(null,map__36046__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__36046__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__36046__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__36046__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_36070){
var state_val_36071 = (state_36070[(1)]);
if((state_val_36071 === (7))){
var state_36070__$1 = state_36070;
var statearr_36072_36092 = state_36070__$1;
(statearr_36072_36092[(2)] = null);

(statearr_36072_36092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36071 === (1))){
var state_36070__$1 = state_36070;
var statearr_36073_36093 = state_36070__$1;
(statearr_36073_36093[(2)] = null);

(statearr_36073_36093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36071 === (4))){
var inst_36049 = (state_36070[(2)]);
var state_36070__$1 = state_36070;
var statearr_36074_36094 = state_36070__$1;
(statearr_36074_36094[(2)] = inst_36049);

(statearr_36074_36094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36071 === (6))){
var inst_36056 = (state_36070[(7)]);
var inst_36058 = fluree.db.storage.core.serde.call(null,conn);
var state_36070__$1 = (function (){var statearr_36075 = state_36070;
(statearr_36075[(8)] = inst_36058);

return statearr_36075;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36070__$1,(9),inst_36056);
} else {
if((state_val_36071 === (3))){
var inst_36068 = (state_36070[(2)]);
var state_36070__$1 = state_36070;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36070__$1,inst_36068);
} else {
if((state_val_36071 === (2))){
var inst_36056 = (state_36070[(7)]);
var _ = (function (){var statearr_36077 = state_36070;
(statearr_36077[(4)] = cljs.core.cons.call(null,(5),(state_36070[(4)])));

return statearr_36077;
})();
var inst_36055 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_36056__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_36055);
var state_36070__$1 = (function (){var statearr_36078 = state_36070;
(statearr_36078[(7)] = inst_36056__$1);

return statearr_36078;
})();
if(cljs.core.truth_(inst_36056__$1)){
var statearr_36079_36095 = state_36070__$1;
(statearr_36079_36095[(1)] = (6));

} else {
var statearr_36080_36096 = state_36070__$1;
(statearr_36080_36096[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36071 === (9))){
var inst_36058 = (state_36070[(8)]);
var inst_36060 = (state_36070[(2)]);
var inst_36061 = fluree.db.util.async.throw_err.call(null,inst_36060);
var inst_36062 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_36058,inst_36061);
var state_36070__$1 = state_36070;
var statearr_36081_36097 = state_36070__$1;
(statearr_36081_36097[(2)] = inst_36062);

(statearr_36081_36097[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36071 === (5))){
var _ = (function (){var statearr_36082 = state_36070;
(statearr_36082[(4)] = cljs.core.rest.call(null,(state_36070[(4)])));

return statearr_36082;
})();
var state_36070__$1 = state_36070;
var ex36076 = (state_36070__$1[(2)]);
var statearr_36083_36098 = state_36070__$1;
(statearr_36083_36098[(5)] = ex36076);


if((ex36076 instanceof Error)){
var statearr_36084_36099 = state_36070__$1;
(statearr_36084_36099[(1)] = (4));

(statearr_36084_36099[(5)] = null);

} else {
throw ex36076;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36071 === (8))){
var inst_36065 = (state_36070[(2)]);
var _ = (function (){var statearr_36085 = state_36070;
(statearr_36085[(4)] = cljs.core.rest.call(null,(state_36070[(4)])));

return statearr_36085;
})();
var state_36070__$1 = state_36070;
var statearr_36086_36100 = state_36070__$1;
(statearr_36086_36100[(2)] = inst_36065);

(statearr_36086_36100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__11469__auto____0 = (function (){
var statearr_36087 = [null,null,null,null,null,null,null,null,null];
(statearr_36087[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__11469__auto__);

(statearr_36087[(1)] = (1));

return statearr_36087;
});
var fluree$db$storage$core$read_garbage_$_state_machine__11469__auto____1 = (function (state_36070){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_36070);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e36088){var ex__11472__auto__ = e36088;
var statearr_36089_36101 = state_36070;
(statearr_36089_36101[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_36070[(4)]))){
var statearr_36090_36102 = state_36070;
(statearr_36090_36102[(1)] = cljs.core.first.call(null,(state_36070[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36103 = state_36070;
state_36070 = G__36103;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__11469__auto__ = function(state_36070){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__11469__auto____1.call(this,state_36070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__11469__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__11469__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_36091 = f__11543__auto__.call(null);
(statearr_36091[(6)] = c__11542__auto__);

return statearr_36091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_36125){
var state_val_36126 = (state_36125[(1)]);
if((state_val_36126 === (7))){
var state_36125__$1 = state_36125;
var statearr_36127_36147 = state_36125__$1;
(statearr_36127_36147[(2)] = null);

(statearr_36127_36147[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36126 === (1))){
var state_36125__$1 = state_36125;
var statearr_36128_36148 = state_36125__$1;
(statearr_36128_36148[(2)] = null);

(statearr_36128_36148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36126 === (4))){
var inst_36104 = (state_36125[(2)]);
var state_36125__$1 = state_36125;
var statearr_36129_36149 = state_36125__$1;
(statearr_36129_36149[(2)] = inst_36104);

(statearr_36129_36149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36126 === (6))){
var inst_36111 = (state_36125[(7)]);
var inst_36113 = fluree.db.storage.core.serde.call(null,conn);
var state_36125__$1 = (function (){var statearr_36130 = state_36125;
(statearr_36130[(8)] = inst_36113);

return statearr_36130;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36125__$1,(9),inst_36111);
} else {
if((state_val_36126 === (3))){
var inst_36123 = (state_36125[(2)]);
var state_36125__$1 = state_36125;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36125__$1,inst_36123);
} else {
if((state_val_36126 === (2))){
var inst_36111 = (state_36125[(7)]);
var _ = (function (){var statearr_36132 = state_36125;
(statearr_36132[(4)] = cljs.core.cons.call(null,(5),(state_36125[(4)])));

return statearr_36132;
})();
var inst_36110 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_36111__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_36110);
var state_36125__$1 = (function (){var statearr_36133 = state_36125;
(statearr_36133[(7)] = inst_36111__$1);

return statearr_36133;
})();
if(cljs.core.truth_(inst_36111__$1)){
var statearr_36134_36150 = state_36125__$1;
(statearr_36134_36150[(1)] = (6));

} else {
var statearr_36135_36151 = state_36125__$1;
(statearr_36135_36151[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36126 === (9))){
var inst_36113 = (state_36125[(8)]);
var inst_36115 = (state_36125[(2)]);
var inst_36116 = fluree.db.util.async.throw_err.call(null,inst_36115);
var inst_36117 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_36113,inst_36116);
var state_36125__$1 = state_36125;
var statearr_36136_36152 = state_36125__$1;
(statearr_36136_36152[(2)] = inst_36117);

(statearr_36136_36152[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36126 === (5))){
var _ = (function (){var statearr_36137 = state_36125;
(statearr_36137[(4)] = cljs.core.rest.call(null,(state_36125[(4)])));

return statearr_36137;
})();
var state_36125__$1 = state_36125;
var ex36131 = (state_36125__$1[(2)]);
var statearr_36138_36153 = state_36125__$1;
(statearr_36138_36153[(5)] = ex36131);


if((ex36131 instanceof Error)){
var statearr_36139_36154 = state_36125__$1;
(statearr_36139_36154[(1)] = (4));

(statearr_36139_36154[(5)] = null);

} else {
throw ex36131;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36126 === (8))){
var inst_36120 = (state_36125[(2)]);
var _ = (function (){var statearr_36140 = state_36125;
(statearr_36140[(4)] = cljs.core.rest.call(null,(state_36125[(4)])));

return statearr_36140;
})();
var state_36125__$1 = state_36125;
var statearr_36141_36155 = state_36125__$1;
(statearr_36141_36155[(2)] = inst_36120);

(statearr_36141_36155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__11469__auto____0 = (function (){
var statearr_36142 = [null,null,null,null,null,null,null,null,null];
(statearr_36142[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__11469__auto__);

(statearr_36142[(1)] = (1));

return statearr_36142;
});
var fluree$db$storage$core$read_db_root_$_state_machine__11469__auto____1 = (function (state_36125){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_36125);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e36143){var ex__11472__auto__ = e36143;
var statearr_36144_36156 = state_36125;
(statearr_36144_36156[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_36125[(4)]))){
var statearr_36145_36157 = state_36125;
(statearr_36145_36157[(1)] = cljs.core.first.call(null,(state_36125[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36158 = state_36125;
state_36125 = G__36158;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__11469__auto__ = function(state_36125){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__11469__auto____1.call(this,state_36125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__11469__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__11469__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_36146 = f__11543__auto__.call(null);
(statearr_36146[(6)] = c__11542__auto__);

return statearr_36146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_36194){
var state_val_36195 = (state_36194[(1)]);
if((state_val_36195 === (7))){
var inst_36168 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_36169 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_36170 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_36171 = cljs.core.PersistentHashMap.fromArrays(inst_36169,inst_36170);
var inst_36172 = cljs.core.ex_info.call(null,inst_36168,inst_36171);
var inst_36173 = (function(){throw inst_36172})();
var state_36194__$1 = state_36194;
var statearr_36196_36218 = state_36194__$1;
(statearr_36196_36218[(2)] = inst_36173);

(statearr_36196_36218[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36195 === (1))){
var state_36194__$1 = state_36194;
var statearr_36197_36219 = state_36194__$1;
(statearr_36197_36219[(2)] = null);

(statearr_36197_36219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36195 === (4))){
var inst_36159 = (state_36194[(2)]);
var state_36194__$1 = state_36194;
var statearr_36198_36220 = state_36194__$1;
(statearr_36198_36220[(2)] = inst_36159);

(statearr_36198_36220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36195 === (6))){
var state_36194__$1 = state_36194;
var statearr_36199_36221 = state_36194__$1;
(statearr_36199_36221[(2)] = null);

(statearr_36199_36221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36195 === (3))){
var inst_36192 = (state_36194[(2)]);
var state_36194__$1 = state_36194;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36194__$1,inst_36192);
} else {
if((state_val_36195 === (2))){
var inst_36165 = (state_36194[(7)]);
var _ = (function (){var statearr_36200 = state_36194;
(statearr_36200[(4)] = cljs.core.cons.call(null,(5),(state_36194[(4)])));

return statearr_36200;
})();
var inst_36165__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_36194__$1 = (function (){var statearr_36201 = state_36194;
(statearr_36201[(7)] = inst_36165__$1);

return statearr_36201;
})();
if(cljs.core.truth_(inst_36165__$1)){
var statearr_36202_36222 = state_36194__$1;
(statearr_36202_36222[(1)] = (6));

} else {
var statearr_36203_36223 = state_36194__$1;
(statearr_36203_36223[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36195 === (11))){
var inst_36184 = (state_36194[(8)]);
var inst_36187 = (state_36194[(2)]);
var inst_36188 = fluree.db.util.async.throw_err.call(null,inst_36187);
var inst_36189 = cljs.core.assoc.call(null,inst_36184,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_36188);
var _ = (function (){var statearr_36205 = state_36194;
(statearr_36205[(4)] = cljs.core.rest.call(null,(state_36194[(4)])));

return statearr_36205;
})();
var state_36194__$1 = state_36194;
var statearr_36206_36224 = state_36194__$1;
(statearr_36206_36224[(2)] = inst_36189);

(statearr_36206_36224[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36195 === (9))){
var inst_36179 = (state_36194[(9)]);
var inst_36177 = (state_36194[(2)]);
var inst_36178 = fluree.db.util.async.throw_err.call(null,inst_36177);
var inst_36179__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_36178);
var inst_36180 = fluree.db.query.schema.schema_map.call(null,inst_36179__$1);
var state_36194__$1 = (function (){var statearr_36207 = state_36194;
(statearr_36207[(9)] = inst_36179__$1);

return statearr_36207;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36194__$1,(10),inst_36180);
} else {
if((state_val_36195 === (5))){
var _ = (function (){var statearr_36208 = state_36194;
(statearr_36208[(4)] = cljs.core.rest.call(null,(state_36194[(4)])));

return statearr_36208;
})();
var state_36194__$1 = state_36194;
var ex36204 = (state_36194__$1[(2)]);
var statearr_36209_36225 = state_36194__$1;
(statearr_36209_36225[(5)] = ex36204);


if((ex36204 instanceof Error)){
var statearr_36210_36226 = state_36194__$1;
(statearr_36210_36226[(1)] = (4));

(statearr_36210_36226[(5)] = null);

} else {
throw ex36204;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36195 === (10))){
var inst_36184 = (state_36194[(8)]);
var inst_36179 = (state_36194[(9)]);
var inst_36182 = (state_36194[(2)]);
var inst_36183 = fluree.db.util.async.throw_err.call(null,inst_36182);
var inst_36184__$1 = cljs.core.assoc.call(null,inst_36179,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_36183);
var inst_36185 = fluree.db.query.schema.setting_map.call(null,inst_36184__$1);
var state_36194__$1 = (function (){var statearr_36211 = state_36194;
(statearr_36211[(8)] = inst_36184__$1);

return statearr_36211;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36194__$1,(11),inst_36185);
} else {
if((state_val_36195 === (8))){
var inst_36165 = (state_36194[(7)]);
var inst_36175 = (state_36194[(2)]);
var state_36194__$1 = (function (){var statearr_36212 = state_36194;
(statearr_36212[(10)] = inst_36175);

return statearr_36212;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36194__$1,(9),inst_36165);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__11469__auto____0 = (function (){
var statearr_36213 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36213[(0)] = fluree$db$storage$core$reify_db_$_state_machine__11469__auto__);

(statearr_36213[(1)] = (1));

return statearr_36213;
});
var fluree$db$storage$core$reify_db_$_state_machine__11469__auto____1 = (function (state_36194){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_36194);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e36214){var ex__11472__auto__ = e36214;
var statearr_36215_36227 = state_36194;
(statearr_36215_36227[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_36194[(4)]))){
var statearr_36216_36228 = state_36194;
(statearr_36216_36228[(1)] = cljs.core.first.call(null,(state_36194[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36229 = state_36194;
state_36194 = G__36229;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__11469__auto__ = function(state_36194){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__11469__auto____1.call(this,state_36194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__11469__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__11469__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_36217 = f__11543__auto__.call(null);
(statearr_36217[(6)] = c__11542__auto__);

return statearr_36217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__36231 = arguments.length;
switch (G__36231) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_36281){
var state_val_36282 = (state_36281[(1)]);
if((state_val_36282 === (7))){
var inst_36241 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_36242 = (new Error(inst_36241));
var inst_36243 = (function(){throw inst_36242})();
var state_36281__$1 = state_36281;
var statearr_36283_36319 = state_36281__$1;
(statearr_36283_36319[(2)] = inst_36243);

(statearr_36283_36319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (20))){
var inst_36270 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
var statearr_36284_36320 = state_36281__$1;
(statearr_36284_36320[(2)] = inst_36270);

(statearr_36284_36320[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (1))){
var state_36281__$1 = state_36281;
var statearr_36285_36321 = state_36281__$1;
(statearr_36285_36321[(2)] = null);

(statearr_36285_36321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (4))){
var inst_36232 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
var statearr_36286_36322 = state_36281__$1;
(statearr_36286_36322[(2)] = inst_36232);

(statearr_36286_36322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (15))){
var inst_36254 = (state_36281[(7)]);
var inst_36250 = (state_36281[(8)]);
var inst_36262 = cljs.core.conj.call(null,inst_36250,inst_36254);
var state_36281__$1 = state_36281;
var statearr_36287_36323 = state_36281__$1;
(statearr_36287_36323[(2)] = inst_36262);

(statearr_36287_36323[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (13))){
var inst_36249 = (state_36281[(9)]);
var inst_36260 = cljs.core._EQ_.call(null,inst_36249,end);
var state_36281__$1 = state_36281;
if(inst_36260){
var statearr_36288_36324 = state_36281__$1;
(statearr_36288_36324[(1)] = (15));

} else {
var statearr_36289_36325 = state_36281__$1;
(statearr_36289_36325[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (6))){
var state_36281__$1 = state_36281;
var statearr_36290_36326 = state_36281__$1;
(statearr_36290_36326[(2)] = null);

(statearr_36290_36326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (17))){
var inst_36272 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
var statearr_36291_36327 = state_36281__$1;
(statearr_36291_36327[(2)] = inst_36272);

(statearr_36291_36327[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (3))){
var inst_36279 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36281__$1,inst_36279);
} else {
if((state_val_36282 === (12))){
var inst_36250 = (state_36281[(8)]);
var state_36281__$1 = state_36281;
var statearr_36292_36328 = state_36281__$1;
(statearr_36292_36328[(2)] = inst_36250);

(statearr_36292_36328[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (2))){
var _ = (function (){var statearr_36293 = state_36281;
(statearr_36293[(4)] = cljs.core.cons.call(null,(5),(state_36281[(4)])));

return statearr_36293;
})();
var inst_36238 = (end >= start);
var state_36281__$1 = state_36281;
if(cljs.core.truth_(inst_36238)){
var statearr_36294_36329 = state_36281__$1;
(statearr_36294_36329[(1)] = (6));

} else {
var statearr_36295_36330 = state_36281__$1;
(statearr_36295_36330[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (19))){
var state_36281__$1 = state_36281;
var statearr_36296_36331 = state_36281__$1;
(statearr_36296_36331[(2)] = null);

(statearr_36296_36331[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (11))){
var inst_36254 = (state_36281[(7)]);
var inst_36254__$1 = (state_36281[(2)]);
var inst_36255 = (inst_36254__$1 == null);
var inst_36256 = (inst_36254__$1 instanceof Error);
var inst_36257 = ((inst_36255) || (inst_36256));
var state_36281__$1 = (function (){var statearr_36298 = state_36281;
(statearr_36298[(7)] = inst_36254__$1);

return statearr_36298;
})();
if(cljs.core.truth_(inst_36257)){
var statearr_36299_36332 = state_36281__$1;
(statearr_36299_36332[(1)] = (12));

} else {
var statearr_36300_36333 = state_36281__$1;
(statearr_36300_36333[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (9))){
var inst_36249 = (state_36281[(9)]);
var inst_36252 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_36249);
var state_36281__$1 = state_36281;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36281__$1,(11),inst_36252);
} else {
if((state_val_36282 === (5))){
var _ = (function (){var statearr_36301 = state_36281;
(statearr_36301[(4)] = cljs.core.rest.call(null,(state_36281[(4)])));

return statearr_36301;
})();
var state_36281__$1 = state_36281;
var ex36297 = (state_36281__$1[(2)]);
var statearr_36302_36334 = state_36281__$1;
(statearr_36302_36334[(5)] = ex36297);


if((ex36297 instanceof Error)){
var statearr_36303_36335 = state_36281__$1;
(statearr_36303_36335[(1)] = (4));

(statearr_36303_36335[(5)] = null);

} else {
throw ex36297;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (14))){
var inst_36274 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
var statearr_36304_36336 = state_36281__$1;
(statearr_36304_36336[(2)] = inst_36274);

(statearr_36304_36336[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (16))){
var state_36281__$1 = state_36281;
var statearr_36305_36337 = state_36281__$1;
(statearr_36305_36337[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (10))){
var inst_36276 = (state_36281[(2)]);
var _ = (function (){var statearr_36307 = state_36281;
(statearr_36307[(4)] = cljs.core.rest.call(null,(state_36281[(4)])));

return statearr_36307;
})();
var state_36281__$1 = state_36281;
var statearr_36308_36338 = state_36281__$1;
(statearr_36308_36338[(2)] = inst_36276);

(statearr_36308_36338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (18))){
var inst_36254 = (state_36281[(7)]);
var inst_36249 = (state_36281[(9)]);
var inst_36250 = (state_36281[(8)]);
var inst_36265 = (inst_36249 + (1));
var inst_36266 = cljs.core.conj.call(null,inst_36250,inst_36254);
var inst_36249__$1 = inst_36265;
var inst_36250__$1 = inst_36266;
var state_36281__$1 = (function (){var statearr_36309 = state_36281;
(statearr_36309[(9)] = inst_36249__$1);

(statearr_36309[(8)] = inst_36250__$1);

return statearr_36309;
})();
var statearr_36310_36339 = state_36281__$1;
(statearr_36310_36339[(2)] = null);

(statearr_36310_36339[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (8))){
var inst_36245 = (state_36281[(2)]);
var inst_36246 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_36247 = start;
var inst_36248 = cljs.core.PersistentVector.EMPTY;
var inst_36249 = inst_36247;
var inst_36250 = inst_36248;
var state_36281__$1 = (function (){var statearr_36311 = state_36281;
(statearr_36311[(9)] = inst_36249);

(statearr_36311[(10)] = inst_36245);

(statearr_36311[(11)] = inst_36246);

(statearr_36311[(8)] = inst_36250);

return statearr_36311;
})();
var statearr_36312_36340 = state_36281__$1;
(statearr_36312_36340[(2)] = null);

(statearr_36312_36340[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__11469__auto__ = null;
var fluree$db$storage$core$state_machine__11469__auto____0 = (function (){
var statearr_36313 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36313[(0)] = fluree$db$storage$core$state_machine__11469__auto__);

(statearr_36313[(1)] = (1));

return statearr_36313;
});
var fluree$db$storage$core$state_machine__11469__auto____1 = (function (state_36281){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_36281);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e36314){var ex__11472__auto__ = e36314;
var statearr_36315_36341 = state_36281;
(statearr_36315_36341[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_36281[(4)]))){
var statearr_36316_36342 = state_36281;
(statearr_36316_36342[(1)] = cljs.core.first.call(null,(state_36281[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36343 = state_36281;
state_36281 = G__36343;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__11469__auto__ = function(state_36281){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__11469__auto____1.call(this,state_36281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__11469__auto____0;
fluree$db$storage$core$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__11469__auto____1;
return fluree$db$storage$core$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_36317 = f__11543__auto__.call(null);
(statearr_36317[(6)] = c__11542__auto__);

return statearr_36317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_36359){
var state_val_36360 = (state_36359[(1)]);
if((state_val_36360 === (1))){
var state_36359__$1 = state_36359;
var statearr_36361_36375 = state_36359__$1;
(statearr_36361_36375[(2)] = null);

(statearr_36361_36375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (2))){
var _ = (function (){var statearr_36362 = state_36359;
(statearr_36362[(4)] = cljs.core.cons.call(null,(5),(state_36359[(4)])));

return statearr_36362;
})();
var inst_36350 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_36359__$1 = state_36359;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36359__$1,(6),inst_36350);
} else {
if((state_val_36360 === (3))){
var inst_36357 = (state_36359[(2)]);
var state_36359__$1 = state_36359;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36359__$1,inst_36357);
} else {
if((state_val_36360 === (4))){
var inst_36344 = (state_36359[(2)]);
var state_36359__$1 = state_36359;
var statearr_36364_36376 = state_36359__$1;
(statearr_36364_36376[(2)] = inst_36344);

(statearr_36364_36376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (5))){
var _ = (function (){var statearr_36365 = state_36359;
(statearr_36365[(4)] = cljs.core.rest.call(null,(state_36359[(4)])));

return statearr_36365;
})();
var state_36359__$1 = state_36359;
var ex36363 = (state_36359__$1[(2)]);
var statearr_36366_36377 = state_36359__$1;
(statearr_36366_36377[(5)] = ex36363);


if((ex36363 instanceof Error)){
var statearr_36367_36378 = state_36359__$1;
(statearr_36367_36378[(1)] = (4));

(statearr_36367_36378[(5)] = null);

} else {
throw ex36363;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (6))){
var inst_36352 = (state_36359[(2)]);
var inst_36353 = fluree.db.util.async.throw_err.call(null,inst_36352);
var inst_36354 = cljs.core.first.call(null,inst_36353);
var _ = (function (){var statearr_36368 = state_36359;
(statearr_36368[(4)] = cljs.core.rest.call(null,(state_36359[(4)])));

return statearr_36368;
})();
var state_36359__$1 = state_36359;
var statearr_36369_36379 = state_36359__$1;
(statearr_36369_36379[(2)] = inst_36354);

(statearr_36369_36379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__11469__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__11469__auto____0 = (function (){
var statearr_36370 = [null,null,null,null,null,null,null];
(statearr_36370[(0)] = fluree$db$storage$core$block_$_state_machine__11469__auto__);

(statearr_36370[(1)] = (1));

return statearr_36370;
});
var fluree$db$storage$core$block_$_state_machine__11469__auto____1 = (function (state_36359){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_36359);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e36371){var ex__11472__auto__ = e36371;
var statearr_36372_36380 = state_36359;
(statearr_36372_36380[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_36359[(4)]))){
var statearr_36373_36381 = state_36359;
(statearr_36373_36381[(1)] = cljs.core.first.call(null,(state_36359[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36382 = state_36359;
state_36359 = G__36382;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__11469__auto__ = function(state_36359){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__11469__auto____1.call(this,state_36359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__11469__auto____0;
fluree$db$storage$core$block_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__11469__auto____1;
return fluree$db$storage$core$block_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_36374 = f__11543__auto__.call(null);
(statearr_36374[(6)] = c__11542__auto__);

return statearr_36374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
