// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__13628 = arguments.length;
switch (G__13628) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13629 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13629 = (function (f,blockable,meta13630){
this.f = f;
this.blockable = blockable;
this.meta13630 = meta13630;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13631,meta13630__$1){
var self__ = this;
var _13631__$1 = this;
return (new cljs.core.async.t_cljs$core$async13629(self__.f,self__.blockable,meta13630__$1));
}));

(cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13631){
var self__ = this;
var _13631__$1 = this;
return self__.meta13630;
}));

(cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async13629.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta13630], null);
}));

(cljs.core.async.t_cljs$core$async13629.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13629.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13629");

(cljs.core.async.t_cljs$core$async13629.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async13629");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13629.
 */
cljs.core.async.__GT_t_cljs$core$async13629 = (function cljs$core$async$__GT_t_cljs$core$async13629(f__$1,blockable__$1,meta13630){
return (new cljs.core.async.t_cljs$core$async13629(f__$1,blockable__$1,meta13630));
});

}

return (new cljs.core.async.t_cljs$core$async13629(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__13635 = arguments.length;
switch (G__13635) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__13638 = arguments.length;
switch (G__13638) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__13641 = arguments.length;
switch (G__13641) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_13643 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_13643) : fn1.call(null,val_13643));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_13643) : fn1.call(null,val_13643));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__13645 = arguments.length;
switch (G__13645) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___13647 = n;
var x_13648 = (0);
while(true){
if((x_13648 < n__4613__auto___13647)){
(a[x_13648] = x_13648);

var G__13649 = (x_13648 + (1));
x_13648 = G__13649;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13650 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13650 = (function (flag,meta13651){
this.flag = flag;
this.meta13651 = meta13651;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13650.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13652,meta13651__$1){
var self__ = this;
var _13652__$1 = this;
return (new cljs.core.async.t_cljs$core$async13650(self__.flag,meta13651__$1));
}));

(cljs.core.async.t_cljs$core$async13650.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13652){
var self__ = this;
var _13652__$1 = this;
return self__.meta13651;
}));

(cljs.core.async.t_cljs$core$async13650.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13650.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async13650.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async13650.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async13650.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta13651], null);
}));

(cljs.core.async.t_cljs$core$async13650.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13650.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13650");

(cljs.core.async.t_cljs$core$async13650.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async13650");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13650.
 */
cljs.core.async.__GT_t_cljs$core$async13650 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async13650(flag__$1,meta13651){
return (new cljs.core.async.t_cljs$core$async13650(flag__$1,meta13651));
});

}

return (new cljs.core.async.t_cljs$core$async13650(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13653 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13653 = (function (flag,cb,meta13654){
this.flag = flag;
this.cb = cb;
this.meta13654 = meta13654;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13653.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13655,meta13654__$1){
var self__ = this;
var _13655__$1 = this;
return (new cljs.core.async.t_cljs$core$async13653(self__.flag,self__.cb,meta13654__$1));
}));

(cljs.core.async.t_cljs$core$async13653.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13655){
var self__ = this;
var _13655__$1 = this;
return self__.meta13654;
}));

(cljs.core.async.t_cljs$core$async13653.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13653.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async13653.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async13653.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async13653.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta13654], null);
}));

(cljs.core.async.t_cljs$core$async13653.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13653.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13653");

(cljs.core.async.t_cljs$core$async13653.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async13653");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13653.
 */
cljs.core.async.__GT_t_cljs$core$async13653 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async13653(flag__$1,cb__$1,meta13654){
return (new cljs.core.async.t_cljs$core$async13653(flag__$1,cb__$1,meta13654));
});

}

return (new cljs.core.async.t_cljs$core$async13653(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13656_SHARP_){
var G__13658 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13656_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__13658) : fret.call(null,G__13658));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13657_SHARP_){
var G__13659 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13657_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__13659) : fret.call(null,G__13659));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__13660 = (i + (1));
i = G__13660;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___13666 = arguments.length;
var i__4737__auto___13667 = (0);
while(true){
if((i__4737__auto___13667 < len__4736__auto___13666)){
args__4742__auto__.push((arguments[i__4737__auto___13667]));

var G__13668 = (i__4737__auto___13667 + (1));
i__4737__auto___13667 = G__13668;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__13663){
var map__13664 = p__13663;
var map__13664__$1 = (((((!((map__13664 == null))))?(((((map__13664.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13664.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13664):map__13664);
var opts = map__13664__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq13661){
var G__13662 = cljs.core.first(seq13661);
var seq13661__$1 = cljs.core.next(seq13661);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13662,seq13661__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__13670 = arguments.length;
switch (G__13670) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__13568__auto___13717 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_13694){
var state_val_13695 = (state_13694[(1)]);
if((state_val_13695 === (7))){
var inst_13690 = (state_13694[(2)]);
var state_13694__$1 = state_13694;
var statearr_13696_13718 = state_13694__$1;
(statearr_13696_13718[(2)] = inst_13690);

(statearr_13696_13718[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13695 === (1))){
var state_13694__$1 = state_13694;
var statearr_13697_13719 = state_13694__$1;
(statearr_13697_13719[(2)] = null);

(statearr_13697_13719[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13695 === (4))){
var inst_13673 = (state_13694[(7)]);
var inst_13673__$1 = (state_13694[(2)]);
var inst_13674 = (inst_13673__$1 == null);
var state_13694__$1 = (function (){var statearr_13698 = state_13694;
(statearr_13698[(7)] = inst_13673__$1);

return statearr_13698;
})();
if(cljs.core.truth_(inst_13674)){
var statearr_13699_13720 = state_13694__$1;
(statearr_13699_13720[(1)] = (5));

} else {
var statearr_13700_13721 = state_13694__$1;
(statearr_13700_13721[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13695 === (13))){
var state_13694__$1 = state_13694;
var statearr_13701_13722 = state_13694__$1;
(statearr_13701_13722[(2)] = null);

(statearr_13701_13722[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13695 === (6))){
var inst_13673 = (state_13694[(7)]);
var state_13694__$1 = state_13694;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13694__$1,(11),to,inst_13673);
} else {
if((state_val_13695 === (3))){
var inst_13692 = (state_13694[(2)]);
var state_13694__$1 = state_13694;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13694__$1,inst_13692);
} else {
if((state_val_13695 === (12))){
var state_13694__$1 = state_13694;
var statearr_13702_13723 = state_13694__$1;
(statearr_13702_13723[(2)] = null);

(statearr_13702_13723[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13695 === (2))){
var state_13694__$1 = state_13694;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13694__$1,(4),from);
} else {
if((state_val_13695 === (11))){
var inst_13683 = (state_13694[(2)]);
var state_13694__$1 = state_13694;
if(cljs.core.truth_(inst_13683)){
var statearr_13703_13724 = state_13694__$1;
(statearr_13703_13724[(1)] = (12));

} else {
var statearr_13704_13725 = state_13694__$1;
(statearr_13704_13725[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13695 === (9))){
var state_13694__$1 = state_13694;
var statearr_13705_13726 = state_13694__$1;
(statearr_13705_13726[(2)] = null);

(statearr_13705_13726[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13695 === (5))){
var state_13694__$1 = state_13694;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13706_13727 = state_13694__$1;
(statearr_13706_13727[(1)] = (8));

} else {
var statearr_13707_13728 = state_13694__$1;
(statearr_13707_13728[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13695 === (14))){
var inst_13688 = (state_13694[(2)]);
var state_13694__$1 = state_13694;
var statearr_13708_13729 = state_13694__$1;
(statearr_13708_13729[(2)] = inst_13688);

(statearr_13708_13729[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13695 === (10))){
var inst_13680 = (state_13694[(2)]);
var state_13694__$1 = state_13694;
var statearr_13709_13730 = state_13694__$1;
(statearr_13709_13730[(2)] = inst_13680);

(statearr_13709_13730[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13695 === (8))){
var inst_13677 = cljs.core.async.close_BANG_(to);
var state_13694__$1 = state_13694;
var statearr_13710_13731 = state_13694__$1;
(statearr_13710_13731[(2)] = inst_13677);

(statearr_13710_13731[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13494__auto__ = null;
var cljs$core$async$state_machine__13494__auto____0 = (function (){
var statearr_13711 = [null,null,null,null,null,null,null,null];
(statearr_13711[(0)] = cljs$core$async$state_machine__13494__auto__);

(statearr_13711[(1)] = (1));

return statearr_13711;
});
var cljs$core$async$state_machine__13494__auto____1 = (function (state_13694){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_13694);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e13712){var ex__13497__auto__ = e13712;
var statearr_13713_13732 = state_13694;
(statearr_13713_13732[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_13694[(4)]))){
var statearr_13714_13733 = state_13694;
(statearr_13714_13733[(1)] = cljs.core.first((state_13694[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__13734 = state_13694;
state_13694 = G__13734;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$state_machine__13494__auto__ = function(state_13694){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13494__auto____1.call(this,state_13694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13494__auto____0;
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13494__auto____1;
return cljs$core$async$state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_13715 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_13715[(6)] = c__13568__auto___13717);

return statearr_13715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__13735){
var vec__13736 = p__13735;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13736,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13736,(1),null);
var job = vec__13736;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__13568__auto___13912 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_13743){
var state_val_13744 = (state_13743[(1)]);
if((state_val_13744 === (1))){
var state_13743__$1 = state_13743;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13743__$1,(2),res,v);
} else {
if((state_val_13744 === (2))){
var inst_13740 = (state_13743[(2)]);
var inst_13741 = cljs.core.async.close_BANG_(res);
var state_13743__$1 = (function (){var statearr_13745 = state_13743;
(statearr_13745[(7)] = inst_13740);

return statearr_13745;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_13743__$1,inst_13741);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0 = (function (){
var statearr_13746 = [null,null,null,null,null,null,null,null];
(statearr_13746[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__);

(statearr_13746[(1)] = (1));

return statearr_13746;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1 = (function (state_13743){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_13743);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e13747){var ex__13497__auto__ = e13747;
var statearr_13748_13913 = state_13743;
(statearr_13748_13913[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_13743[(4)]))){
var statearr_13749_13914 = state_13743;
(statearr_13749_13914[(1)] = cljs.core.first((state_13743[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__13915 = state_13743;
state_13743 = G__13915;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__ = function(state_13743){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1.call(this,state_13743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_13750 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_13750[(6)] = c__13568__auto___13912);

return statearr_13750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__13751){
var vec__13752 = p__13751;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13752,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13752,(1),null);
var job = vec__13752;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___13916 = n;
var __13917 = (0);
while(true){
if((__13917 < n__4613__auto___13916)){
var G__13755_13918 = type;
var G__13755_13919__$1 = (((G__13755_13918 instanceof cljs.core.Keyword))?G__13755_13918.fqn:null);
switch (G__13755_13919__$1) {
case "compute":
var c__13568__auto___13921 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__13917,c__13568__auto___13921,G__13755_13918,G__13755_13919__$1,n__4613__auto___13916,jobs,results,process,async){
return (function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = ((function (__13917,c__13568__auto___13921,G__13755_13918,G__13755_13919__$1,n__4613__auto___13916,jobs,results,process,async){
return (function (state_13768){
var state_val_13769 = (state_13768[(1)]);
if((state_val_13769 === (1))){
var state_13768__$1 = state_13768;
var statearr_13770_13922 = state_13768__$1;
(statearr_13770_13922[(2)] = null);

(statearr_13770_13922[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13769 === (2))){
var state_13768__$1 = state_13768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13768__$1,(4),jobs);
} else {
if((state_val_13769 === (3))){
var inst_13766 = (state_13768[(2)]);
var state_13768__$1 = state_13768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13768__$1,inst_13766);
} else {
if((state_val_13769 === (4))){
var inst_13758 = (state_13768[(2)]);
var inst_13759 = process(inst_13758);
var state_13768__$1 = state_13768;
if(cljs.core.truth_(inst_13759)){
var statearr_13771_13923 = state_13768__$1;
(statearr_13771_13923[(1)] = (5));

} else {
var statearr_13772_13924 = state_13768__$1;
(statearr_13772_13924[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13769 === (5))){
var state_13768__$1 = state_13768;
var statearr_13773_13925 = state_13768__$1;
(statearr_13773_13925[(2)] = null);

(statearr_13773_13925[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13769 === (6))){
var state_13768__$1 = state_13768;
var statearr_13774_13926 = state_13768__$1;
(statearr_13774_13926[(2)] = null);

(statearr_13774_13926[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13769 === (7))){
var inst_13764 = (state_13768[(2)]);
var state_13768__$1 = state_13768;
var statearr_13775_13927 = state_13768__$1;
(statearr_13775_13927[(2)] = inst_13764);

(statearr_13775_13927[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__13917,c__13568__auto___13921,G__13755_13918,G__13755_13919__$1,n__4613__auto___13916,jobs,results,process,async))
;
return ((function (__13917,switch__13493__auto__,c__13568__auto___13921,G__13755_13918,G__13755_13919__$1,n__4613__auto___13916,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0 = (function (){
var statearr_13776 = [null,null,null,null,null,null,null];
(statearr_13776[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__);

(statearr_13776[(1)] = (1));

return statearr_13776;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1 = (function (state_13768){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_13768);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e13777){var ex__13497__auto__ = e13777;
var statearr_13778_13928 = state_13768;
(statearr_13778_13928[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_13768[(4)]))){
var statearr_13779_13929 = state_13768;
(statearr_13779_13929[(1)] = cljs.core.first((state_13768[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__13930 = state_13768;
state_13768 = G__13930;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__ = function(state_13768){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1.call(this,state_13768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__;
})()
;})(__13917,switch__13493__auto__,c__13568__auto___13921,G__13755_13918,G__13755_13919__$1,n__4613__auto___13916,jobs,results,process,async))
})();
var state__13570__auto__ = (function (){var statearr_13780 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_13780[(6)] = c__13568__auto___13921);

return statearr_13780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
});})(__13917,c__13568__auto___13921,G__13755_13918,G__13755_13919__$1,n__4613__auto___13916,jobs,results,process,async))
);


break;
case "async":
var c__13568__auto___13931 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__13917,c__13568__auto___13931,G__13755_13918,G__13755_13919__$1,n__4613__auto___13916,jobs,results,process,async){
return (function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = ((function (__13917,c__13568__auto___13931,G__13755_13918,G__13755_13919__$1,n__4613__auto___13916,jobs,results,process,async){
return (function (state_13793){
var state_val_13794 = (state_13793[(1)]);
if((state_val_13794 === (1))){
var state_13793__$1 = state_13793;
var statearr_13795_13932 = state_13793__$1;
(statearr_13795_13932[(2)] = null);

(statearr_13795_13932[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13794 === (2))){
var state_13793__$1 = state_13793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13793__$1,(4),jobs);
} else {
if((state_val_13794 === (3))){
var inst_13791 = (state_13793[(2)]);
var state_13793__$1 = state_13793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13793__$1,inst_13791);
} else {
if((state_val_13794 === (4))){
var inst_13783 = (state_13793[(2)]);
var inst_13784 = async(inst_13783);
var state_13793__$1 = state_13793;
if(cljs.core.truth_(inst_13784)){
var statearr_13796_13933 = state_13793__$1;
(statearr_13796_13933[(1)] = (5));

} else {
var statearr_13797_13934 = state_13793__$1;
(statearr_13797_13934[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13794 === (5))){
var state_13793__$1 = state_13793;
var statearr_13798_13935 = state_13793__$1;
(statearr_13798_13935[(2)] = null);

(statearr_13798_13935[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13794 === (6))){
var state_13793__$1 = state_13793;
var statearr_13799_13936 = state_13793__$1;
(statearr_13799_13936[(2)] = null);

(statearr_13799_13936[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13794 === (7))){
var inst_13789 = (state_13793[(2)]);
var state_13793__$1 = state_13793;
var statearr_13800_13937 = state_13793__$1;
(statearr_13800_13937[(2)] = inst_13789);

(statearr_13800_13937[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__13917,c__13568__auto___13931,G__13755_13918,G__13755_13919__$1,n__4613__auto___13916,jobs,results,process,async))
;
return ((function (__13917,switch__13493__auto__,c__13568__auto___13931,G__13755_13918,G__13755_13919__$1,n__4613__auto___13916,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0 = (function (){
var statearr_13801 = [null,null,null,null,null,null,null];
(statearr_13801[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__);

(statearr_13801[(1)] = (1));

return statearr_13801;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1 = (function (state_13793){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_13793);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e13802){var ex__13497__auto__ = e13802;
var statearr_13803_13938 = state_13793;
(statearr_13803_13938[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_13793[(4)]))){
var statearr_13804_13939 = state_13793;
(statearr_13804_13939[(1)] = cljs.core.first((state_13793[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__13940 = state_13793;
state_13793 = G__13940;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__ = function(state_13793){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1.call(this,state_13793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__;
})()
;})(__13917,switch__13493__auto__,c__13568__auto___13931,G__13755_13918,G__13755_13919__$1,n__4613__auto___13916,jobs,results,process,async))
})();
var state__13570__auto__ = (function (){var statearr_13805 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_13805[(6)] = c__13568__auto___13931);

return statearr_13805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
});})(__13917,c__13568__auto___13931,G__13755_13918,G__13755_13919__$1,n__4613__auto___13916,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13755_13919__$1)].join('')));

}

var G__13941 = (__13917 + (1));
__13917 = G__13941;
continue;
} else {
}
break;
}

var c__13568__auto___13942 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_13827){
var state_val_13828 = (state_13827[(1)]);
if((state_val_13828 === (7))){
var inst_13823 = (state_13827[(2)]);
var state_13827__$1 = state_13827;
var statearr_13829_13943 = state_13827__$1;
(statearr_13829_13943[(2)] = inst_13823);

(statearr_13829_13943[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13828 === (1))){
var state_13827__$1 = state_13827;
var statearr_13830_13944 = state_13827__$1;
(statearr_13830_13944[(2)] = null);

(statearr_13830_13944[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13828 === (4))){
var inst_13808 = (state_13827[(7)]);
var inst_13808__$1 = (state_13827[(2)]);
var inst_13809 = (inst_13808__$1 == null);
var state_13827__$1 = (function (){var statearr_13831 = state_13827;
(statearr_13831[(7)] = inst_13808__$1);

return statearr_13831;
})();
if(cljs.core.truth_(inst_13809)){
var statearr_13832_13945 = state_13827__$1;
(statearr_13832_13945[(1)] = (5));

} else {
var statearr_13833_13946 = state_13827__$1;
(statearr_13833_13946[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13828 === (6))){
var inst_13808 = (state_13827[(7)]);
var inst_13813 = (state_13827[(8)]);
var inst_13813__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_13814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13815 = [inst_13808,inst_13813__$1];
var inst_13816 = (new cljs.core.PersistentVector(null,2,(5),inst_13814,inst_13815,null));
var state_13827__$1 = (function (){var statearr_13834 = state_13827;
(statearr_13834[(8)] = inst_13813__$1);

return statearr_13834;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13827__$1,(8),jobs,inst_13816);
} else {
if((state_val_13828 === (3))){
var inst_13825 = (state_13827[(2)]);
var state_13827__$1 = state_13827;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13827__$1,inst_13825);
} else {
if((state_val_13828 === (2))){
var state_13827__$1 = state_13827;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13827__$1,(4),from);
} else {
if((state_val_13828 === (9))){
var inst_13820 = (state_13827[(2)]);
var state_13827__$1 = (function (){var statearr_13835 = state_13827;
(statearr_13835[(9)] = inst_13820);

return statearr_13835;
})();
var statearr_13836_13947 = state_13827__$1;
(statearr_13836_13947[(2)] = null);

(statearr_13836_13947[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13828 === (5))){
var inst_13811 = cljs.core.async.close_BANG_(jobs);
var state_13827__$1 = state_13827;
var statearr_13837_13948 = state_13827__$1;
(statearr_13837_13948[(2)] = inst_13811);

(statearr_13837_13948[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13828 === (8))){
var inst_13813 = (state_13827[(8)]);
var inst_13818 = (state_13827[(2)]);
var state_13827__$1 = (function (){var statearr_13838 = state_13827;
(statearr_13838[(10)] = inst_13818);

return statearr_13838;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13827__$1,(9),results,inst_13813);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0 = (function (){
var statearr_13839 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13839[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__);

(statearr_13839[(1)] = (1));

return statearr_13839;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1 = (function (state_13827){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_13827);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e13840){var ex__13497__auto__ = e13840;
var statearr_13841_13949 = state_13827;
(statearr_13841_13949[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_13827[(4)]))){
var statearr_13842_13950 = state_13827;
(statearr_13842_13950[(1)] = cljs.core.first((state_13827[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__13951 = state_13827;
state_13827 = G__13951;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__ = function(state_13827){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1.call(this,state_13827);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_13843 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_13843[(6)] = c__13568__auto___13942);

return statearr_13843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


var c__13568__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_13881){
var state_val_13882 = (state_13881[(1)]);
if((state_val_13882 === (7))){
var inst_13877 = (state_13881[(2)]);
var state_13881__$1 = state_13881;
var statearr_13883_13952 = state_13881__$1;
(statearr_13883_13952[(2)] = inst_13877);

(statearr_13883_13952[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (20))){
var state_13881__$1 = state_13881;
var statearr_13884_13953 = state_13881__$1;
(statearr_13884_13953[(2)] = null);

(statearr_13884_13953[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (1))){
var state_13881__$1 = state_13881;
var statearr_13885_13954 = state_13881__$1;
(statearr_13885_13954[(2)] = null);

(statearr_13885_13954[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (4))){
var inst_13846 = (state_13881[(7)]);
var inst_13846__$1 = (state_13881[(2)]);
var inst_13847 = (inst_13846__$1 == null);
var state_13881__$1 = (function (){var statearr_13886 = state_13881;
(statearr_13886[(7)] = inst_13846__$1);

return statearr_13886;
})();
if(cljs.core.truth_(inst_13847)){
var statearr_13887_13955 = state_13881__$1;
(statearr_13887_13955[(1)] = (5));

} else {
var statearr_13888_13956 = state_13881__$1;
(statearr_13888_13956[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (15))){
var inst_13859 = (state_13881[(8)]);
var state_13881__$1 = state_13881;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13881__$1,(18),to,inst_13859);
} else {
if((state_val_13882 === (21))){
var inst_13872 = (state_13881[(2)]);
var state_13881__$1 = state_13881;
var statearr_13889_13957 = state_13881__$1;
(statearr_13889_13957[(2)] = inst_13872);

(statearr_13889_13957[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (13))){
var inst_13874 = (state_13881[(2)]);
var state_13881__$1 = (function (){var statearr_13890 = state_13881;
(statearr_13890[(9)] = inst_13874);

return statearr_13890;
})();
var statearr_13891_13958 = state_13881__$1;
(statearr_13891_13958[(2)] = null);

(statearr_13891_13958[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (6))){
var inst_13846 = (state_13881[(7)]);
var state_13881__$1 = state_13881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13881__$1,(11),inst_13846);
} else {
if((state_val_13882 === (17))){
var inst_13867 = (state_13881[(2)]);
var state_13881__$1 = state_13881;
if(cljs.core.truth_(inst_13867)){
var statearr_13892_13959 = state_13881__$1;
(statearr_13892_13959[(1)] = (19));

} else {
var statearr_13893_13960 = state_13881__$1;
(statearr_13893_13960[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (3))){
var inst_13879 = (state_13881[(2)]);
var state_13881__$1 = state_13881;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13881__$1,inst_13879);
} else {
if((state_val_13882 === (12))){
var inst_13856 = (state_13881[(10)]);
var state_13881__$1 = state_13881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13881__$1,(14),inst_13856);
} else {
if((state_val_13882 === (2))){
var state_13881__$1 = state_13881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13881__$1,(4),results);
} else {
if((state_val_13882 === (19))){
var state_13881__$1 = state_13881;
var statearr_13894_13961 = state_13881__$1;
(statearr_13894_13961[(2)] = null);

(statearr_13894_13961[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (11))){
var inst_13856 = (state_13881[(2)]);
var state_13881__$1 = (function (){var statearr_13895 = state_13881;
(statearr_13895[(10)] = inst_13856);

return statearr_13895;
})();
var statearr_13896_13962 = state_13881__$1;
(statearr_13896_13962[(2)] = null);

(statearr_13896_13962[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (9))){
var state_13881__$1 = state_13881;
var statearr_13897_13963 = state_13881__$1;
(statearr_13897_13963[(2)] = null);

(statearr_13897_13963[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (5))){
var state_13881__$1 = state_13881;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13898_13964 = state_13881__$1;
(statearr_13898_13964[(1)] = (8));

} else {
var statearr_13899_13965 = state_13881__$1;
(statearr_13899_13965[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (14))){
var inst_13859 = (state_13881[(8)]);
var inst_13859__$1 = (state_13881[(2)]);
var inst_13860 = (inst_13859__$1 == null);
var inst_13861 = cljs.core.not(inst_13860);
var state_13881__$1 = (function (){var statearr_13900 = state_13881;
(statearr_13900[(8)] = inst_13859__$1);

return statearr_13900;
})();
if(inst_13861){
var statearr_13901_13966 = state_13881__$1;
(statearr_13901_13966[(1)] = (15));

} else {
var statearr_13902_13967 = state_13881__$1;
(statearr_13902_13967[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (16))){
var state_13881__$1 = state_13881;
var statearr_13903_13968 = state_13881__$1;
(statearr_13903_13968[(2)] = false);

(statearr_13903_13968[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (10))){
var inst_13853 = (state_13881[(2)]);
var state_13881__$1 = state_13881;
var statearr_13904_13969 = state_13881__$1;
(statearr_13904_13969[(2)] = inst_13853);

(statearr_13904_13969[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (18))){
var inst_13864 = (state_13881[(2)]);
var state_13881__$1 = state_13881;
var statearr_13905_13970 = state_13881__$1;
(statearr_13905_13970[(2)] = inst_13864);

(statearr_13905_13970[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13882 === (8))){
var inst_13850 = cljs.core.async.close_BANG_(to);
var state_13881__$1 = state_13881;
var statearr_13906_13971 = state_13881__$1;
(statearr_13906_13971[(2)] = inst_13850);

(statearr_13906_13971[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0 = (function (){
var statearr_13907 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13907[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__);

(statearr_13907[(1)] = (1));

return statearr_13907;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1 = (function (state_13881){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_13881);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e13908){var ex__13497__auto__ = e13908;
var statearr_13909_13972 = state_13881;
(statearr_13909_13972[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_13881[(4)]))){
var statearr_13910_13973 = state_13881;
(statearr_13910_13973[(1)] = cljs.core.first((state_13881[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__13974 = state_13881;
state_13881 = G__13974;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__ = function(state_13881){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1.call(this,state_13881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13494__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_13911 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_13911[(6)] = c__13568__auto__);

return statearr_13911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));

return c__13568__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__13976 = arguments.length;
switch (G__13976) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__13979 = arguments.length;
switch (G__13979) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__13982 = arguments.length;
switch (G__13982) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__13568__auto___14032 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_14008){
var state_val_14009 = (state_14008[(1)]);
if((state_val_14009 === (7))){
var inst_14004 = (state_14008[(2)]);
var state_14008__$1 = state_14008;
var statearr_14010_14033 = state_14008__$1;
(statearr_14010_14033[(2)] = inst_14004);

(statearr_14010_14033[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14009 === (1))){
var state_14008__$1 = state_14008;
var statearr_14011_14034 = state_14008__$1;
(statearr_14011_14034[(2)] = null);

(statearr_14011_14034[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14009 === (4))){
var inst_13985 = (state_14008[(7)]);
var inst_13985__$1 = (state_14008[(2)]);
var inst_13986 = (inst_13985__$1 == null);
var state_14008__$1 = (function (){var statearr_14012 = state_14008;
(statearr_14012[(7)] = inst_13985__$1);

return statearr_14012;
})();
if(cljs.core.truth_(inst_13986)){
var statearr_14013_14035 = state_14008__$1;
(statearr_14013_14035[(1)] = (5));

} else {
var statearr_14014_14036 = state_14008__$1;
(statearr_14014_14036[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14009 === (13))){
var state_14008__$1 = state_14008;
var statearr_14015_14037 = state_14008__$1;
(statearr_14015_14037[(2)] = null);

(statearr_14015_14037[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14009 === (6))){
var inst_13985 = (state_14008[(7)]);
var inst_13991 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_13985) : p.call(null,inst_13985));
var state_14008__$1 = state_14008;
if(cljs.core.truth_(inst_13991)){
var statearr_14016_14038 = state_14008__$1;
(statearr_14016_14038[(1)] = (9));

} else {
var statearr_14017_14039 = state_14008__$1;
(statearr_14017_14039[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14009 === (3))){
var inst_14006 = (state_14008[(2)]);
var state_14008__$1 = state_14008;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14008__$1,inst_14006);
} else {
if((state_val_14009 === (12))){
var state_14008__$1 = state_14008;
var statearr_14018_14040 = state_14008__$1;
(statearr_14018_14040[(2)] = null);

(statearr_14018_14040[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14009 === (2))){
var state_14008__$1 = state_14008;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14008__$1,(4),ch);
} else {
if((state_val_14009 === (11))){
var inst_13985 = (state_14008[(7)]);
var inst_13995 = (state_14008[(2)]);
var state_14008__$1 = state_14008;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14008__$1,(8),inst_13995,inst_13985);
} else {
if((state_val_14009 === (9))){
var state_14008__$1 = state_14008;
var statearr_14019_14041 = state_14008__$1;
(statearr_14019_14041[(2)] = tc);

(statearr_14019_14041[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14009 === (5))){
var inst_13988 = cljs.core.async.close_BANG_(tc);
var inst_13989 = cljs.core.async.close_BANG_(fc);
var state_14008__$1 = (function (){var statearr_14020 = state_14008;
(statearr_14020[(8)] = inst_13988);

return statearr_14020;
})();
var statearr_14021_14042 = state_14008__$1;
(statearr_14021_14042[(2)] = inst_13989);

(statearr_14021_14042[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14009 === (14))){
var inst_14002 = (state_14008[(2)]);
var state_14008__$1 = state_14008;
var statearr_14022_14043 = state_14008__$1;
(statearr_14022_14043[(2)] = inst_14002);

(statearr_14022_14043[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14009 === (10))){
var state_14008__$1 = state_14008;
var statearr_14023_14044 = state_14008__$1;
(statearr_14023_14044[(2)] = fc);

(statearr_14023_14044[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14009 === (8))){
var inst_13997 = (state_14008[(2)]);
var state_14008__$1 = state_14008;
if(cljs.core.truth_(inst_13997)){
var statearr_14024_14045 = state_14008__$1;
(statearr_14024_14045[(1)] = (12));

} else {
var statearr_14025_14046 = state_14008__$1;
(statearr_14025_14046[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13494__auto__ = null;
var cljs$core$async$state_machine__13494__auto____0 = (function (){
var statearr_14026 = [null,null,null,null,null,null,null,null,null];
(statearr_14026[(0)] = cljs$core$async$state_machine__13494__auto__);

(statearr_14026[(1)] = (1));

return statearr_14026;
});
var cljs$core$async$state_machine__13494__auto____1 = (function (state_14008){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_14008);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e14027){var ex__13497__auto__ = e14027;
var statearr_14028_14047 = state_14008;
(statearr_14028_14047[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_14008[(4)]))){
var statearr_14029_14048 = state_14008;
(statearr_14029_14048[(1)] = cljs.core.first((state_14008[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__14049 = state_14008;
state_14008 = G__14049;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$state_machine__13494__auto__ = function(state_14008){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13494__auto____1.call(this,state_14008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13494__auto____0;
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13494__auto____1;
return cljs$core$async$state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_14030 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_14030[(6)] = c__13568__auto___14032);

return statearr_14030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__13568__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_14071){
var state_val_14072 = (state_14071[(1)]);
if((state_val_14072 === (7))){
var inst_14067 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14073_14092 = state_14071__$1;
(statearr_14073_14092[(2)] = inst_14067);

(statearr_14073_14092[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14072 === (1))){
var inst_14050 = init;
var inst_14051 = inst_14050;
var state_14071__$1 = (function (){var statearr_14074 = state_14071;
(statearr_14074[(7)] = inst_14051);

return statearr_14074;
})();
var statearr_14075_14093 = state_14071__$1;
(statearr_14075_14093[(2)] = null);

(statearr_14075_14093[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14072 === (4))){
var inst_14054 = (state_14071[(8)]);
var inst_14054__$1 = (state_14071[(2)]);
var inst_14055 = (inst_14054__$1 == null);
var state_14071__$1 = (function (){var statearr_14076 = state_14071;
(statearr_14076[(8)] = inst_14054__$1);

return statearr_14076;
})();
if(cljs.core.truth_(inst_14055)){
var statearr_14077_14094 = state_14071__$1;
(statearr_14077_14094[(1)] = (5));

} else {
var statearr_14078_14095 = state_14071__$1;
(statearr_14078_14095[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14072 === (6))){
var inst_14058 = (state_14071[(9)]);
var inst_14051 = (state_14071[(7)]);
var inst_14054 = (state_14071[(8)]);
var inst_14058__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_14051,inst_14054) : f.call(null,inst_14051,inst_14054));
var inst_14059 = cljs.core.reduced_QMARK_(inst_14058__$1);
var state_14071__$1 = (function (){var statearr_14079 = state_14071;
(statearr_14079[(9)] = inst_14058__$1);

return statearr_14079;
})();
if(inst_14059){
var statearr_14080_14096 = state_14071__$1;
(statearr_14080_14096[(1)] = (8));

} else {
var statearr_14081_14097 = state_14071__$1;
(statearr_14081_14097[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14072 === (3))){
var inst_14069 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14071__$1,inst_14069);
} else {
if((state_val_14072 === (2))){
var state_14071__$1 = state_14071;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14071__$1,(4),ch);
} else {
if((state_val_14072 === (9))){
var inst_14058 = (state_14071[(9)]);
var inst_14051 = inst_14058;
var state_14071__$1 = (function (){var statearr_14082 = state_14071;
(statearr_14082[(7)] = inst_14051);

return statearr_14082;
})();
var statearr_14083_14098 = state_14071__$1;
(statearr_14083_14098[(2)] = null);

(statearr_14083_14098[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14072 === (5))){
var inst_14051 = (state_14071[(7)]);
var state_14071__$1 = state_14071;
var statearr_14084_14099 = state_14071__$1;
(statearr_14084_14099[(2)] = inst_14051);

(statearr_14084_14099[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14072 === (10))){
var inst_14065 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14085_14100 = state_14071__$1;
(statearr_14085_14100[(2)] = inst_14065);

(statearr_14085_14100[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14072 === (8))){
var inst_14058 = (state_14071[(9)]);
var inst_14061 = cljs.core.deref(inst_14058);
var state_14071__$1 = state_14071;
var statearr_14086_14101 = state_14071__$1;
(statearr_14086_14101[(2)] = inst_14061);

(statearr_14086_14101[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__13494__auto__ = null;
var cljs$core$async$reduce_$_state_machine__13494__auto____0 = (function (){
var statearr_14087 = [null,null,null,null,null,null,null,null,null,null];
(statearr_14087[(0)] = cljs$core$async$reduce_$_state_machine__13494__auto__);

(statearr_14087[(1)] = (1));

return statearr_14087;
});
var cljs$core$async$reduce_$_state_machine__13494__auto____1 = (function (state_14071){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_14071);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e14088){var ex__13497__auto__ = e14088;
var statearr_14089_14102 = state_14071;
(statearr_14089_14102[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_14071[(4)]))){
var statearr_14090_14103 = state_14071;
(statearr_14090_14103[(1)] = cljs.core.first((state_14071[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__14104 = state_14071;
state_14071 = G__14104;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__13494__auto__ = function(state_14071){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__13494__auto____1.call(this,state_14071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__13494__auto____0;
cljs$core$async$reduce_$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__13494__auto____1;
return cljs$core$async$reduce_$_state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_14091 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_14091[(6)] = c__13568__auto__);

return statearr_14091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));

return c__13568__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__13568__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_14110){
var state_val_14111 = (state_14110[(1)]);
if((state_val_14111 === (1))){
var inst_14105 = cljs.core.async.reduce(f__$1,init,ch);
var state_14110__$1 = state_14110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14110__$1,(2),inst_14105);
} else {
if((state_val_14111 === (2))){
var inst_14107 = (state_14110[(2)]);
var inst_14108 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_14107) : f__$1.call(null,inst_14107));
var state_14110__$1 = state_14110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14110__$1,inst_14108);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__13494__auto__ = null;
var cljs$core$async$transduce_$_state_machine__13494__auto____0 = (function (){
var statearr_14112 = [null,null,null,null,null,null,null];
(statearr_14112[(0)] = cljs$core$async$transduce_$_state_machine__13494__auto__);

(statearr_14112[(1)] = (1));

return statearr_14112;
});
var cljs$core$async$transduce_$_state_machine__13494__auto____1 = (function (state_14110){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_14110);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e14113){var ex__13497__auto__ = e14113;
var statearr_14114_14117 = state_14110;
(statearr_14114_14117[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_14110[(4)]))){
var statearr_14115_14118 = state_14110;
(statearr_14115_14118[(1)] = cljs.core.first((state_14110[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__14119 = state_14110;
state_14110 = G__14119;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__13494__auto__ = function(state_14110){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__13494__auto____1.call(this,state_14110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__13494__auto____0;
cljs$core$async$transduce_$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__13494__auto____1;
return cljs$core$async$transduce_$_state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_14116 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_14116[(6)] = c__13568__auto__);

return statearr_14116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));

return c__13568__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__14121 = arguments.length;
switch (G__14121) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__13568__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_14146){
var state_val_14147 = (state_14146[(1)]);
if((state_val_14147 === (7))){
var inst_14128 = (state_14146[(2)]);
var state_14146__$1 = state_14146;
var statearr_14148_14170 = state_14146__$1;
(statearr_14148_14170[(2)] = inst_14128);

(statearr_14148_14170[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14147 === (1))){
var inst_14122 = cljs.core.seq(coll);
var inst_14123 = inst_14122;
var state_14146__$1 = (function (){var statearr_14149 = state_14146;
(statearr_14149[(7)] = inst_14123);

return statearr_14149;
})();
var statearr_14150_14171 = state_14146__$1;
(statearr_14150_14171[(2)] = null);

(statearr_14150_14171[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14147 === (4))){
var inst_14123 = (state_14146[(7)]);
var inst_14126 = cljs.core.first(inst_14123);
var state_14146__$1 = state_14146;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14146__$1,(7),ch,inst_14126);
} else {
if((state_val_14147 === (13))){
var inst_14140 = (state_14146[(2)]);
var state_14146__$1 = state_14146;
var statearr_14151_14172 = state_14146__$1;
(statearr_14151_14172[(2)] = inst_14140);

(statearr_14151_14172[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14147 === (6))){
var inst_14131 = (state_14146[(2)]);
var state_14146__$1 = state_14146;
if(cljs.core.truth_(inst_14131)){
var statearr_14152_14173 = state_14146__$1;
(statearr_14152_14173[(1)] = (8));

} else {
var statearr_14153_14174 = state_14146__$1;
(statearr_14153_14174[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14147 === (3))){
var inst_14144 = (state_14146[(2)]);
var state_14146__$1 = state_14146;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14146__$1,inst_14144);
} else {
if((state_val_14147 === (12))){
var state_14146__$1 = state_14146;
var statearr_14154_14175 = state_14146__$1;
(statearr_14154_14175[(2)] = null);

(statearr_14154_14175[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14147 === (2))){
var inst_14123 = (state_14146[(7)]);
var state_14146__$1 = state_14146;
if(cljs.core.truth_(inst_14123)){
var statearr_14155_14176 = state_14146__$1;
(statearr_14155_14176[(1)] = (4));

} else {
var statearr_14156_14177 = state_14146__$1;
(statearr_14156_14177[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14147 === (11))){
var inst_14137 = cljs.core.async.close_BANG_(ch);
var state_14146__$1 = state_14146;
var statearr_14157_14178 = state_14146__$1;
(statearr_14157_14178[(2)] = inst_14137);

(statearr_14157_14178[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14147 === (9))){
var state_14146__$1 = state_14146;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14158_14179 = state_14146__$1;
(statearr_14158_14179[(1)] = (11));

} else {
var statearr_14159_14180 = state_14146__$1;
(statearr_14159_14180[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14147 === (5))){
var inst_14123 = (state_14146[(7)]);
var state_14146__$1 = state_14146;
var statearr_14160_14181 = state_14146__$1;
(statearr_14160_14181[(2)] = inst_14123);

(statearr_14160_14181[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14147 === (10))){
var inst_14142 = (state_14146[(2)]);
var state_14146__$1 = state_14146;
var statearr_14161_14182 = state_14146__$1;
(statearr_14161_14182[(2)] = inst_14142);

(statearr_14161_14182[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14147 === (8))){
var inst_14123 = (state_14146[(7)]);
var inst_14133 = cljs.core.next(inst_14123);
var inst_14123__$1 = inst_14133;
var state_14146__$1 = (function (){var statearr_14162 = state_14146;
(statearr_14162[(7)] = inst_14123__$1);

return statearr_14162;
})();
var statearr_14163_14183 = state_14146__$1;
(statearr_14163_14183[(2)] = null);

(statearr_14163_14183[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13494__auto__ = null;
var cljs$core$async$state_machine__13494__auto____0 = (function (){
var statearr_14164 = [null,null,null,null,null,null,null,null];
(statearr_14164[(0)] = cljs$core$async$state_machine__13494__auto__);

(statearr_14164[(1)] = (1));

return statearr_14164;
});
var cljs$core$async$state_machine__13494__auto____1 = (function (state_14146){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_14146);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e14165){var ex__13497__auto__ = e14165;
var statearr_14166_14184 = state_14146;
(statearr_14166_14184[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_14146[(4)]))){
var statearr_14167_14185 = state_14146;
(statearr_14167_14185[(1)] = cljs.core.first((state_14146[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__14186 = state_14146;
state_14146 = G__14186;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$state_machine__13494__auto__ = function(state_14146){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13494__auto____1.call(this,state_14146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13494__auto____0;
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13494__auto____1;
return cljs$core$async$state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_14168 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_14168[(6)] = c__13568__auto__);

return statearr_14168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));

return c__13568__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__14188 = arguments.length;
switch (G__14188) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_14190 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_14190(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_14191 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_14191(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_14192 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_14192(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_14193 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_14193(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14194 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14194 = (function (ch,cs,meta14195){
this.ch = ch;
this.cs = cs;
this.meta14195 = meta14195;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14194.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14196,meta14195__$1){
var self__ = this;
var _14196__$1 = this;
return (new cljs.core.async.t_cljs$core$async14194(self__.ch,self__.cs,meta14195__$1));
}));

(cljs.core.async.t_cljs$core$async14194.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14196){
var self__ = this;
var _14196__$1 = this;
return self__.meta14195;
}));

(cljs.core.async.t_cljs$core$async14194.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14194.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async14194.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14194.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async14194.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async14194.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async14194.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta14195], null);
}));

(cljs.core.async.t_cljs$core$async14194.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14194.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14194");

(cljs.core.async.t_cljs$core$async14194.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async14194");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14194.
 */
cljs.core.async.__GT_t_cljs$core$async14194 = (function cljs$core$async$mult_$___GT_t_cljs$core$async14194(ch__$1,cs__$1,meta14195){
return (new cljs.core.async.t_cljs$core$async14194(ch__$1,cs__$1,meta14195));
});

}

return (new cljs.core.async.t_cljs$core$async14194(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__13568__auto___14413 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_14329){
var state_val_14330 = (state_14329[(1)]);
if((state_val_14330 === (7))){
var inst_14325 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
var statearr_14331_14414 = state_14329__$1;
(statearr_14331_14414[(2)] = inst_14325);

(statearr_14331_14414[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (20))){
var inst_14230 = (state_14329[(7)]);
var inst_14242 = cljs.core.first(inst_14230);
var inst_14243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14242,(0),null);
var inst_14244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14242,(1),null);
var state_14329__$1 = (function (){var statearr_14332 = state_14329;
(statearr_14332[(8)] = inst_14243);

return statearr_14332;
})();
if(cljs.core.truth_(inst_14244)){
var statearr_14333_14415 = state_14329__$1;
(statearr_14333_14415[(1)] = (22));

} else {
var statearr_14334_14416 = state_14329__$1;
(statearr_14334_14416[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (27))){
var inst_14272 = (state_14329[(9)]);
var inst_14199 = (state_14329[(10)]);
var inst_14279 = (state_14329[(11)]);
var inst_14274 = (state_14329[(12)]);
var inst_14279__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_14272,inst_14274);
var inst_14280 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_14279__$1,inst_14199,done);
var state_14329__$1 = (function (){var statearr_14335 = state_14329;
(statearr_14335[(11)] = inst_14279__$1);

return statearr_14335;
})();
if(cljs.core.truth_(inst_14280)){
var statearr_14336_14417 = state_14329__$1;
(statearr_14336_14417[(1)] = (30));

} else {
var statearr_14337_14418 = state_14329__$1;
(statearr_14337_14418[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (1))){
var state_14329__$1 = state_14329;
var statearr_14338_14419 = state_14329__$1;
(statearr_14338_14419[(2)] = null);

(statearr_14338_14419[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (24))){
var inst_14230 = (state_14329[(7)]);
var inst_14249 = (state_14329[(2)]);
var inst_14250 = cljs.core.next(inst_14230);
var inst_14208 = inst_14250;
var inst_14209 = null;
var inst_14210 = (0);
var inst_14211 = (0);
var state_14329__$1 = (function (){var statearr_14339 = state_14329;
(statearr_14339[(13)] = inst_14211);

(statearr_14339[(14)] = inst_14208);

(statearr_14339[(15)] = inst_14210);

(statearr_14339[(16)] = inst_14209);

(statearr_14339[(17)] = inst_14249);

return statearr_14339;
})();
var statearr_14340_14420 = state_14329__$1;
(statearr_14340_14420[(2)] = null);

(statearr_14340_14420[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (39))){
var state_14329__$1 = state_14329;
var statearr_14344_14421 = state_14329__$1;
(statearr_14344_14421[(2)] = null);

(statearr_14344_14421[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (4))){
var inst_14199 = (state_14329[(10)]);
var inst_14199__$1 = (state_14329[(2)]);
var inst_14200 = (inst_14199__$1 == null);
var state_14329__$1 = (function (){var statearr_14345 = state_14329;
(statearr_14345[(10)] = inst_14199__$1);

return statearr_14345;
})();
if(cljs.core.truth_(inst_14200)){
var statearr_14346_14422 = state_14329__$1;
(statearr_14346_14422[(1)] = (5));

} else {
var statearr_14347_14423 = state_14329__$1;
(statearr_14347_14423[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (15))){
var inst_14211 = (state_14329[(13)]);
var inst_14208 = (state_14329[(14)]);
var inst_14210 = (state_14329[(15)]);
var inst_14209 = (state_14329[(16)]);
var inst_14226 = (state_14329[(2)]);
var inst_14227 = (inst_14211 + (1));
var tmp14341 = inst_14208;
var tmp14342 = inst_14210;
var tmp14343 = inst_14209;
var inst_14208__$1 = tmp14341;
var inst_14209__$1 = tmp14343;
var inst_14210__$1 = tmp14342;
var inst_14211__$1 = inst_14227;
var state_14329__$1 = (function (){var statearr_14348 = state_14329;
(statearr_14348[(13)] = inst_14211__$1);

(statearr_14348[(14)] = inst_14208__$1);

(statearr_14348[(15)] = inst_14210__$1);

(statearr_14348[(16)] = inst_14209__$1);

(statearr_14348[(18)] = inst_14226);

return statearr_14348;
})();
var statearr_14349_14424 = state_14329__$1;
(statearr_14349_14424[(2)] = null);

(statearr_14349_14424[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (21))){
var inst_14253 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
var statearr_14353_14425 = state_14329__$1;
(statearr_14353_14425[(2)] = inst_14253);

(statearr_14353_14425[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (31))){
var inst_14279 = (state_14329[(11)]);
var inst_14283 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_14279);
var state_14329__$1 = state_14329;
var statearr_14354_14426 = state_14329__$1;
(statearr_14354_14426[(2)] = inst_14283);

(statearr_14354_14426[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (32))){
var inst_14273 = (state_14329[(19)]);
var inst_14272 = (state_14329[(9)]);
var inst_14271 = (state_14329[(20)]);
var inst_14274 = (state_14329[(12)]);
var inst_14285 = (state_14329[(2)]);
var inst_14286 = (inst_14274 + (1));
var tmp14350 = inst_14273;
var tmp14351 = inst_14272;
var tmp14352 = inst_14271;
var inst_14271__$1 = tmp14352;
var inst_14272__$1 = tmp14351;
var inst_14273__$1 = tmp14350;
var inst_14274__$1 = inst_14286;
var state_14329__$1 = (function (){var statearr_14355 = state_14329;
(statearr_14355[(19)] = inst_14273__$1);

(statearr_14355[(9)] = inst_14272__$1);

(statearr_14355[(20)] = inst_14271__$1);

(statearr_14355[(21)] = inst_14285);

(statearr_14355[(12)] = inst_14274__$1);

return statearr_14355;
})();
var statearr_14356_14427 = state_14329__$1;
(statearr_14356_14427[(2)] = null);

(statearr_14356_14427[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (40))){
var inst_14298 = (state_14329[(22)]);
var inst_14302 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_14298);
var state_14329__$1 = state_14329;
var statearr_14357_14428 = state_14329__$1;
(statearr_14357_14428[(2)] = inst_14302);

(statearr_14357_14428[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (33))){
var inst_14289 = (state_14329[(23)]);
var inst_14291 = cljs.core.chunked_seq_QMARK_(inst_14289);
var state_14329__$1 = state_14329;
if(inst_14291){
var statearr_14358_14429 = state_14329__$1;
(statearr_14358_14429[(1)] = (36));

} else {
var statearr_14359_14430 = state_14329__$1;
(statearr_14359_14430[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (13))){
var inst_14220 = (state_14329[(24)]);
var inst_14223 = cljs.core.async.close_BANG_(inst_14220);
var state_14329__$1 = state_14329;
var statearr_14360_14431 = state_14329__$1;
(statearr_14360_14431[(2)] = inst_14223);

(statearr_14360_14431[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (22))){
var inst_14243 = (state_14329[(8)]);
var inst_14246 = cljs.core.async.close_BANG_(inst_14243);
var state_14329__$1 = state_14329;
var statearr_14361_14432 = state_14329__$1;
(statearr_14361_14432[(2)] = inst_14246);

(statearr_14361_14432[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (36))){
var inst_14289 = (state_14329[(23)]);
var inst_14293 = cljs.core.chunk_first(inst_14289);
var inst_14294 = cljs.core.chunk_rest(inst_14289);
var inst_14295 = cljs.core.count(inst_14293);
var inst_14271 = inst_14294;
var inst_14272 = inst_14293;
var inst_14273 = inst_14295;
var inst_14274 = (0);
var state_14329__$1 = (function (){var statearr_14362 = state_14329;
(statearr_14362[(19)] = inst_14273);

(statearr_14362[(9)] = inst_14272);

(statearr_14362[(20)] = inst_14271);

(statearr_14362[(12)] = inst_14274);

return statearr_14362;
})();
var statearr_14363_14433 = state_14329__$1;
(statearr_14363_14433[(2)] = null);

(statearr_14363_14433[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (41))){
var inst_14289 = (state_14329[(23)]);
var inst_14304 = (state_14329[(2)]);
var inst_14305 = cljs.core.next(inst_14289);
var inst_14271 = inst_14305;
var inst_14272 = null;
var inst_14273 = (0);
var inst_14274 = (0);
var state_14329__$1 = (function (){var statearr_14364 = state_14329;
(statearr_14364[(19)] = inst_14273);

(statearr_14364[(9)] = inst_14272);

(statearr_14364[(20)] = inst_14271);

(statearr_14364[(25)] = inst_14304);

(statearr_14364[(12)] = inst_14274);

return statearr_14364;
})();
var statearr_14365_14434 = state_14329__$1;
(statearr_14365_14434[(2)] = null);

(statearr_14365_14434[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (43))){
var state_14329__$1 = state_14329;
var statearr_14366_14435 = state_14329__$1;
(statearr_14366_14435[(2)] = null);

(statearr_14366_14435[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (29))){
var inst_14313 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
var statearr_14367_14436 = state_14329__$1;
(statearr_14367_14436[(2)] = inst_14313);

(statearr_14367_14436[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (44))){
var inst_14322 = (state_14329[(2)]);
var state_14329__$1 = (function (){var statearr_14368 = state_14329;
(statearr_14368[(26)] = inst_14322);

return statearr_14368;
})();
var statearr_14369_14437 = state_14329__$1;
(statearr_14369_14437[(2)] = null);

(statearr_14369_14437[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (6))){
var inst_14263 = (state_14329[(27)]);
var inst_14262 = cljs.core.deref(cs);
var inst_14263__$1 = cljs.core.keys(inst_14262);
var inst_14264 = cljs.core.count(inst_14263__$1);
var inst_14265 = cljs.core.reset_BANG_(dctr,inst_14264);
var inst_14270 = cljs.core.seq(inst_14263__$1);
var inst_14271 = inst_14270;
var inst_14272 = null;
var inst_14273 = (0);
var inst_14274 = (0);
var state_14329__$1 = (function (){var statearr_14370 = state_14329;
(statearr_14370[(19)] = inst_14273);

(statearr_14370[(9)] = inst_14272);

(statearr_14370[(28)] = inst_14265);

(statearr_14370[(27)] = inst_14263__$1);

(statearr_14370[(20)] = inst_14271);

(statearr_14370[(12)] = inst_14274);

return statearr_14370;
})();
var statearr_14371_14438 = state_14329__$1;
(statearr_14371_14438[(2)] = null);

(statearr_14371_14438[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (28))){
var inst_14289 = (state_14329[(23)]);
var inst_14271 = (state_14329[(20)]);
var inst_14289__$1 = cljs.core.seq(inst_14271);
var state_14329__$1 = (function (){var statearr_14372 = state_14329;
(statearr_14372[(23)] = inst_14289__$1);

return statearr_14372;
})();
if(inst_14289__$1){
var statearr_14373_14439 = state_14329__$1;
(statearr_14373_14439[(1)] = (33));

} else {
var statearr_14374_14440 = state_14329__$1;
(statearr_14374_14440[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (25))){
var inst_14273 = (state_14329[(19)]);
var inst_14274 = (state_14329[(12)]);
var inst_14276 = (inst_14274 < inst_14273);
var inst_14277 = inst_14276;
var state_14329__$1 = state_14329;
if(cljs.core.truth_(inst_14277)){
var statearr_14375_14441 = state_14329__$1;
(statearr_14375_14441[(1)] = (27));

} else {
var statearr_14376_14442 = state_14329__$1;
(statearr_14376_14442[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (34))){
var state_14329__$1 = state_14329;
var statearr_14377_14443 = state_14329__$1;
(statearr_14377_14443[(2)] = null);

(statearr_14377_14443[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (17))){
var state_14329__$1 = state_14329;
var statearr_14378_14444 = state_14329__$1;
(statearr_14378_14444[(2)] = null);

(statearr_14378_14444[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (3))){
var inst_14327 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14329__$1,inst_14327);
} else {
if((state_val_14330 === (12))){
var inst_14258 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
var statearr_14379_14445 = state_14329__$1;
(statearr_14379_14445[(2)] = inst_14258);

(statearr_14379_14445[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (2))){
var state_14329__$1 = state_14329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14329__$1,(4),ch);
} else {
if((state_val_14330 === (23))){
var state_14329__$1 = state_14329;
var statearr_14380_14446 = state_14329__$1;
(statearr_14380_14446[(2)] = null);

(statearr_14380_14446[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (35))){
var inst_14311 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
var statearr_14381_14447 = state_14329__$1;
(statearr_14381_14447[(2)] = inst_14311);

(statearr_14381_14447[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (19))){
var inst_14230 = (state_14329[(7)]);
var inst_14234 = cljs.core.chunk_first(inst_14230);
var inst_14235 = cljs.core.chunk_rest(inst_14230);
var inst_14236 = cljs.core.count(inst_14234);
var inst_14208 = inst_14235;
var inst_14209 = inst_14234;
var inst_14210 = inst_14236;
var inst_14211 = (0);
var state_14329__$1 = (function (){var statearr_14382 = state_14329;
(statearr_14382[(13)] = inst_14211);

(statearr_14382[(14)] = inst_14208);

(statearr_14382[(15)] = inst_14210);

(statearr_14382[(16)] = inst_14209);

return statearr_14382;
})();
var statearr_14383_14448 = state_14329__$1;
(statearr_14383_14448[(2)] = null);

(statearr_14383_14448[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (11))){
var inst_14208 = (state_14329[(14)]);
var inst_14230 = (state_14329[(7)]);
var inst_14230__$1 = cljs.core.seq(inst_14208);
var state_14329__$1 = (function (){var statearr_14384 = state_14329;
(statearr_14384[(7)] = inst_14230__$1);

return statearr_14384;
})();
if(inst_14230__$1){
var statearr_14385_14449 = state_14329__$1;
(statearr_14385_14449[(1)] = (16));

} else {
var statearr_14386_14450 = state_14329__$1;
(statearr_14386_14450[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (9))){
var inst_14260 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
var statearr_14387_14451 = state_14329__$1;
(statearr_14387_14451[(2)] = inst_14260);

(statearr_14387_14451[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (5))){
var inst_14206 = cljs.core.deref(cs);
var inst_14207 = cljs.core.seq(inst_14206);
var inst_14208 = inst_14207;
var inst_14209 = null;
var inst_14210 = (0);
var inst_14211 = (0);
var state_14329__$1 = (function (){var statearr_14388 = state_14329;
(statearr_14388[(13)] = inst_14211);

(statearr_14388[(14)] = inst_14208);

(statearr_14388[(15)] = inst_14210);

(statearr_14388[(16)] = inst_14209);

return statearr_14388;
})();
var statearr_14389_14452 = state_14329__$1;
(statearr_14389_14452[(2)] = null);

(statearr_14389_14452[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (14))){
var state_14329__$1 = state_14329;
var statearr_14390_14453 = state_14329__$1;
(statearr_14390_14453[(2)] = null);

(statearr_14390_14453[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (45))){
var inst_14319 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
var statearr_14391_14454 = state_14329__$1;
(statearr_14391_14454[(2)] = inst_14319);

(statearr_14391_14454[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (26))){
var inst_14263 = (state_14329[(27)]);
var inst_14315 = (state_14329[(2)]);
var inst_14316 = cljs.core.seq(inst_14263);
var state_14329__$1 = (function (){var statearr_14392 = state_14329;
(statearr_14392[(29)] = inst_14315);

return statearr_14392;
})();
if(inst_14316){
var statearr_14393_14455 = state_14329__$1;
(statearr_14393_14455[(1)] = (42));

} else {
var statearr_14394_14456 = state_14329__$1;
(statearr_14394_14456[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (16))){
var inst_14230 = (state_14329[(7)]);
var inst_14232 = cljs.core.chunked_seq_QMARK_(inst_14230);
var state_14329__$1 = state_14329;
if(inst_14232){
var statearr_14395_14457 = state_14329__$1;
(statearr_14395_14457[(1)] = (19));

} else {
var statearr_14396_14458 = state_14329__$1;
(statearr_14396_14458[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (38))){
var inst_14308 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
var statearr_14397_14459 = state_14329__$1;
(statearr_14397_14459[(2)] = inst_14308);

(statearr_14397_14459[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (30))){
var state_14329__$1 = state_14329;
var statearr_14398_14460 = state_14329__$1;
(statearr_14398_14460[(2)] = null);

(statearr_14398_14460[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (10))){
var inst_14211 = (state_14329[(13)]);
var inst_14209 = (state_14329[(16)]);
var inst_14219 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_14209,inst_14211);
var inst_14220 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14219,(0),null);
var inst_14221 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14219,(1),null);
var state_14329__$1 = (function (){var statearr_14399 = state_14329;
(statearr_14399[(24)] = inst_14220);

return statearr_14399;
})();
if(cljs.core.truth_(inst_14221)){
var statearr_14400_14461 = state_14329__$1;
(statearr_14400_14461[(1)] = (13));

} else {
var statearr_14401_14462 = state_14329__$1;
(statearr_14401_14462[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (18))){
var inst_14256 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
var statearr_14402_14463 = state_14329__$1;
(statearr_14402_14463[(2)] = inst_14256);

(statearr_14402_14463[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (42))){
var state_14329__$1 = state_14329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14329__$1,(45),dchan);
} else {
if((state_val_14330 === (37))){
var inst_14199 = (state_14329[(10)]);
var inst_14298 = (state_14329[(22)]);
var inst_14289 = (state_14329[(23)]);
var inst_14298__$1 = cljs.core.first(inst_14289);
var inst_14299 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_14298__$1,inst_14199,done);
var state_14329__$1 = (function (){var statearr_14403 = state_14329;
(statearr_14403[(22)] = inst_14298__$1);

return statearr_14403;
})();
if(cljs.core.truth_(inst_14299)){
var statearr_14404_14464 = state_14329__$1;
(statearr_14404_14464[(1)] = (39));

} else {
var statearr_14405_14465 = state_14329__$1;
(statearr_14405_14465[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14330 === (8))){
var inst_14211 = (state_14329[(13)]);
var inst_14210 = (state_14329[(15)]);
var inst_14213 = (inst_14211 < inst_14210);
var inst_14214 = inst_14213;
var state_14329__$1 = state_14329;
if(cljs.core.truth_(inst_14214)){
var statearr_14406_14466 = state_14329__$1;
(statearr_14406_14466[(1)] = (10));

} else {
var statearr_14407_14467 = state_14329__$1;
(statearr_14407_14467[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__13494__auto__ = null;
var cljs$core$async$mult_$_state_machine__13494__auto____0 = (function (){
var statearr_14408 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14408[(0)] = cljs$core$async$mult_$_state_machine__13494__auto__);

(statearr_14408[(1)] = (1));

return statearr_14408;
});
var cljs$core$async$mult_$_state_machine__13494__auto____1 = (function (state_14329){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_14329);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e14409){var ex__13497__auto__ = e14409;
var statearr_14410_14468 = state_14329;
(statearr_14410_14468[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_14329[(4)]))){
var statearr_14411_14469 = state_14329;
(statearr_14411_14469[(1)] = cljs.core.first((state_14329[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__14470 = state_14329;
state_14329 = G__14470;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__13494__auto__ = function(state_14329){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__13494__auto____1.call(this,state_14329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__13494__auto____0;
cljs$core$async$mult_$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__13494__auto____1;
return cljs$core$async$mult_$_state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_14412 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_14412[(6)] = c__13568__auto___14413);

return statearr_14412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__14472 = arguments.length;
switch (G__14472) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_14474 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_14474(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_14475 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_14475(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_14476 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_14476(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_14477 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_14477(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_14478 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_14478(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___14489 = arguments.length;
var i__4737__auto___14490 = (0);
while(true){
if((i__4737__auto___14490 < len__4736__auto___14489)){
args__4742__auto__.push((arguments[i__4737__auto___14490]));

var G__14491 = (i__4737__auto___14490 + (1));
i__4737__auto___14490 = G__14491;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__14483){
var map__14484 = p__14483;
var map__14484__$1 = (((((!((map__14484 == null))))?(((((map__14484.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14484.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14484):map__14484);
var opts = map__14484__$1;
var statearr_14486_14492 = state;
(statearr_14486_14492[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_14487_14493 = state;
(statearr_14487_14493[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_14488_14494 = state;
(statearr_14488_14494[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq14479){
var G__14480 = cljs.core.first(seq14479);
var seq14479__$1 = cljs.core.next(seq14479);
var G__14481 = cljs.core.first(seq14479__$1);
var seq14479__$2 = cljs.core.next(seq14479__$1);
var G__14482 = cljs.core.first(seq14479__$2);
var seq14479__$3 = cljs.core.next(seq14479__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14480,G__14481,G__14482,seq14479__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14495 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14495 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta14496){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta14496 = meta14496;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14495.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14497,meta14496__$1){
var self__ = this;
var _14497__$1 = this;
return (new cljs.core.async.t_cljs$core$async14495(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta14496__$1));
}));

(cljs.core.async.t_cljs$core$async14495.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14497){
var self__ = this;
var _14497__$1 = this;
return self__.meta14496;
}));

(cljs.core.async.t_cljs$core$async14495.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14495.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async14495.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14495.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14495.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14495.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14495.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14495.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14495.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta14496], null);
}));

(cljs.core.async.t_cljs$core$async14495.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14495.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14495");

(cljs.core.async.t_cljs$core$async14495.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async14495");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14495.
 */
cljs.core.async.__GT_t_cljs$core$async14495 = (function cljs$core$async$mix_$___GT_t_cljs$core$async14495(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta14496){
return (new cljs.core.async.t_cljs$core$async14495(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta14496));
});

}

return (new cljs.core.async.t_cljs$core$async14495(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__13568__auto___14660 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_14599){
var state_val_14600 = (state_14599[(1)]);
if((state_val_14600 === (7))){
var inst_14514 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
var statearr_14601_14661 = state_14599__$1;
(statearr_14601_14661[(2)] = inst_14514);

(statearr_14601_14661[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (20))){
var inst_14526 = (state_14599[(7)]);
var state_14599__$1 = state_14599;
var statearr_14602_14662 = state_14599__$1;
(statearr_14602_14662[(2)] = inst_14526);

(statearr_14602_14662[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (27))){
var state_14599__$1 = state_14599;
var statearr_14603_14663 = state_14599__$1;
(statearr_14603_14663[(2)] = null);

(statearr_14603_14663[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (1))){
var inst_14501 = (state_14599[(8)]);
var inst_14501__$1 = calc_state();
var inst_14503 = (inst_14501__$1 == null);
var inst_14504 = cljs.core.not(inst_14503);
var state_14599__$1 = (function (){var statearr_14604 = state_14599;
(statearr_14604[(8)] = inst_14501__$1);

return statearr_14604;
})();
if(inst_14504){
var statearr_14605_14664 = state_14599__$1;
(statearr_14605_14664[(1)] = (2));

} else {
var statearr_14606_14665 = state_14599__$1;
(statearr_14606_14665[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (24))){
var inst_14559 = (state_14599[(9)]);
var inst_14550 = (state_14599[(10)]);
var inst_14573 = (state_14599[(11)]);
var inst_14573__$1 = (inst_14550.cljs$core$IFn$_invoke$arity$1 ? inst_14550.cljs$core$IFn$_invoke$arity$1(inst_14559) : inst_14550.call(null,inst_14559));
var state_14599__$1 = (function (){var statearr_14607 = state_14599;
(statearr_14607[(11)] = inst_14573__$1);

return statearr_14607;
})();
if(cljs.core.truth_(inst_14573__$1)){
var statearr_14608_14666 = state_14599__$1;
(statearr_14608_14666[(1)] = (29));

} else {
var statearr_14609_14667 = state_14599__$1;
(statearr_14609_14667[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (4))){
var inst_14517 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
if(cljs.core.truth_(inst_14517)){
var statearr_14610_14668 = state_14599__$1;
(statearr_14610_14668[(1)] = (8));

} else {
var statearr_14611_14669 = state_14599__$1;
(statearr_14611_14669[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (15))){
var inst_14544 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
if(cljs.core.truth_(inst_14544)){
var statearr_14612_14670 = state_14599__$1;
(statearr_14612_14670[(1)] = (19));

} else {
var statearr_14613_14671 = state_14599__$1;
(statearr_14613_14671[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (21))){
var inst_14549 = (state_14599[(12)]);
var inst_14549__$1 = (state_14599[(2)]);
var inst_14550 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14549__$1,cljs.core.cst$kw$solos);
var inst_14551 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14549__$1,cljs.core.cst$kw$mutes);
var inst_14552 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14549__$1,cljs.core.cst$kw$reads);
var state_14599__$1 = (function (){var statearr_14614 = state_14599;
(statearr_14614[(12)] = inst_14549__$1);

(statearr_14614[(10)] = inst_14550);

(statearr_14614[(13)] = inst_14551);

return statearr_14614;
})();
return cljs.core.async.ioc_alts_BANG_(state_14599__$1,(22),inst_14552);
} else {
if((state_val_14600 === (31))){
var inst_14581 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
if(cljs.core.truth_(inst_14581)){
var statearr_14615_14672 = state_14599__$1;
(statearr_14615_14672[(1)] = (32));

} else {
var statearr_14616_14673 = state_14599__$1;
(statearr_14616_14673[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (32))){
var inst_14558 = (state_14599[(14)]);
var state_14599__$1 = state_14599;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14599__$1,(35),out,inst_14558);
} else {
if((state_val_14600 === (33))){
var inst_14549 = (state_14599[(12)]);
var inst_14526 = inst_14549;
var state_14599__$1 = (function (){var statearr_14617 = state_14599;
(statearr_14617[(7)] = inst_14526);

return statearr_14617;
})();
var statearr_14618_14674 = state_14599__$1;
(statearr_14618_14674[(2)] = null);

(statearr_14618_14674[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (13))){
var inst_14526 = (state_14599[(7)]);
var inst_14533 = inst_14526.cljs$lang$protocol_mask$partition0$;
var inst_14534 = (inst_14533 & (64));
var inst_14535 = inst_14526.cljs$core$ISeq$;
var inst_14536 = (cljs.core.PROTOCOL_SENTINEL === inst_14535);
var inst_14537 = ((inst_14534) || (inst_14536));
var state_14599__$1 = state_14599;
if(cljs.core.truth_(inst_14537)){
var statearr_14619_14675 = state_14599__$1;
(statearr_14619_14675[(1)] = (16));

} else {
var statearr_14620_14676 = state_14599__$1;
(statearr_14620_14676[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (22))){
var inst_14558 = (state_14599[(14)]);
var inst_14559 = (state_14599[(9)]);
var inst_14557 = (state_14599[(2)]);
var inst_14558__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14557,(0),null);
var inst_14559__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14557,(1),null);
var inst_14560 = (inst_14558__$1 == null);
var inst_14561 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14559__$1,change);
var inst_14562 = ((inst_14560) || (inst_14561));
var state_14599__$1 = (function (){var statearr_14621 = state_14599;
(statearr_14621[(14)] = inst_14558__$1);

(statearr_14621[(9)] = inst_14559__$1);

return statearr_14621;
})();
if(cljs.core.truth_(inst_14562)){
var statearr_14622_14677 = state_14599__$1;
(statearr_14622_14677[(1)] = (23));

} else {
var statearr_14623_14678 = state_14599__$1;
(statearr_14623_14678[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (36))){
var inst_14549 = (state_14599[(12)]);
var inst_14526 = inst_14549;
var state_14599__$1 = (function (){var statearr_14624 = state_14599;
(statearr_14624[(7)] = inst_14526);

return statearr_14624;
})();
var statearr_14625_14679 = state_14599__$1;
(statearr_14625_14679[(2)] = null);

(statearr_14625_14679[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (29))){
var inst_14573 = (state_14599[(11)]);
var state_14599__$1 = state_14599;
var statearr_14626_14680 = state_14599__$1;
(statearr_14626_14680[(2)] = inst_14573);

(statearr_14626_14680[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (6))){
var state_14599__$1 = state_14599;
var statearr_14627_14681 = state_14599__$1;
(statearr_14627_14681[(2)] = false);

(statearr_14627_14681[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (28))){
var inst_14569 = (state_14599[(2)]);
var inst_14570 = calc_state();
var inst_14526 = inst_14570;
var state_14599__$1 = (function (){var statearr_14628 = state_14599;
(statearr_14628[(7)] = inst_14526);

(statearr_14628[(15)] = inst_14569);

return statearr_14628;
})();
var statearr_14629_14682 = state_14599__$1;
(statearr_14629_14682[(2)] = null);

(statearr_14629_14682[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (25))){
var inst_14595 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
var statearr_14630_14683 = state_14599__$1;
(statearr_14630_14683[(2)] = inst_14595);

(statearr_14630_14683[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (34))){
var inst_14593 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
var statearr_14631_14684 = state_14599__$1;
(statearr_14631_14684[(2)] = inst_14593);

(statearr_14631_14684[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (17))){
var state_14599__$1 = state_14599;
var statearr_14632_14685 = state_14599__$1;
(statearr_14632_14685[(2)] = false);

(statearr_14632_14685[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (3))){
var state_14599__$1 = state_14599;
var statearr_14633_14686 = state_14599__$1;
(statearr_14633_14686[(2)] = false);

(statearr_14633_14686[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (12))){
var inst_14597 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14599__$1,inst_14597);
} else {
if((state_val_14600 === (2))){
var inst_14501 = (state_14599[(8)]);
var inst_14506 = inst_14501.cljs$lang$protocol_mask$partition0$;
var inst_14507 = (inst_14506 & (64));
var inst_14508 = inst_14501.cljs$core$ISeq$;
var inst_14509 = (cljs.core.PROTOCOL_SENTINEL === inst_14508);
var inst_14510 = ((inst_14507) || (inst_14509));
var state_14599__$1 = state_14599;
if(cljs.core.truth_(inst_14510)){
var statearr_14634_14687 = state_14599__$1;
(statearr_14634_14687[(1)] = (5));

} else {
var statearr_14635_14688 = state_14599__$1;
(statearr_14635_14688[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (23))){
var inst_14558 = (state_14599[(14)]);
var inst_14564 = (inst_14558 == null);
var state_14599__$1 = state_14599;
if(cljs.core.truth_(inst_14564)){
var statearr_14636_14689 = state_14599__$1;
(statearr_14636_14689[(1)] = (26));

} else {
var statearr_14637_14690 = state_14599__$1;
(statearr_14637_14690[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (35))){
var inst_14584 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
if(cljs.core.truth_(inst_14584)){
var statearr_14638_14691 = state_14599__$1;
(statearr_14638_14691[(1)] = (36));

} else {
var statearr_14639_14692 = state_14599__$1;
(statearr_14639_14692[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (19))){
var inst_14526 = (state_14599[(7)]);
var inst_14546 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_14526);
var state_14599__$1 = state_14599;
var statearr_14640_14693 = state_14599__$1;
(statearr_14640_14693[(2)] = inst_14546);

(statearr_14640_14693[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (11))){
var inst_14526 = (state_14599[(7)]);
var inst_14530 = (inst_14526 == null);
var inst_14531 = cljs.core.not(inst_14530);
var state_14599__$1 = state_14599;
if(inst_14531){
var statearr_14641_14694 = state_14599__$1;
(statearr_14641_14694[(1)] = (13));

} else {
var statearr_14642_14695 = state_14599__$1;
(statearr_14642_14695[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (9))){
var inst_14501 = (state_14599[(8)]);
var state_14599__$1 = state_14599;
var statearr_14643_14696 = state_14599__$1;
(statearr_14643_14696[(2)] = inst_14501);

(statearr_14643_14696[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (5))){
var state_14599__$1 = state_14599;
var statearr_14644_14697 = state_14599__$1;
(statearr_14644_14697[(2)] = true);

(statearr_14644_14697[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (14))){
var state_14599__$1 = state_14599;
var statearr_14645_14698 = state_14599__$1;
(statearr_14645_14698[(2)] = false);

(statearr_14645_14698[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (26))){
var inst_14559 = (state_14599[(9)]);
var inst_14566 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_14559);
var state_14599__$1 = state_14599;
var statearr_14646_14699 = state_14599__$1;
(statearr_14646_14699[(2)] = inst_14566);

(statearr_14646_14699[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (16))){
var state_14599__$1 = state_14599;
var statearr_14647_14700 = state_14599__$1;
(statearr_14647_14700[(2)] = true);

(statearr_14647_14700[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (38))){
var inst_14589 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
var statearr_14648_14701 = state_14599__$1;
(statearr_14648_14701[(2)] = inst_14589);

(statearr_14648_14701[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (30))){
var inst_14559 = (state_14599[(9)]);
var inst_14550 = (state_14599[(10)]);
var inst_14551 = (state_14599[(13)]);
var inst_14576 = cljs.core.empty_QMARK_(inst_14550);
var inst_14577 = (inst_14551.cljs$core$IFn$_invoke$arity$1 ? inst_14551.cljs$core$IFn$_invoke$arity$1(inst_14559) : inst_14551.call(null,inst_14559));
var inst_14578 = cljs.core.not(inst_14577);
var inst_14579 = ((inst_14576) && (inst_14578));
var state_14599__$1 = state_14599;
var statearr_14649_14702 = state_14599__$1;
(statearr_14649_14702[(2)] = inst_14579);

(statearr_14649_14702[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (10))){
var inst_14501 = (state_14599[(8)]);
var inst_14522 = (state_14599[(2)]);
var inst_14523 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14522,cljs.core.cst$kw$solos);
var inst_14524 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14522,cljs.core.cst$kw$mutes);
var inst_14525 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14522,cljs.core.cst$kw$reads);
var inst_14526 = inst_14501;
var state_14599__$1 = (function (){var statearr_14650 = state_14599;
(statearr_14650[(16)] = inst_14525);

(statearr_14650[(17)] = inst_14524);

(statearr_14650[(7)] = inst_14526);

(statearr_14650[(18)] = inst_14523);

return statearr_14650;
})();
var statearr_14651_14703 = state_14599__$1;
(statearr_14651_14703[(2)] = null);

(statearr_14651_14703[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (18))){
var inst_14541 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
var statearr_14652_14704 = state_14599__$1;
(statearr_14652_14704[(2)] = inst_14541);

(statearr_14652_14704[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (37))){
var state_14599__$1 = state_14599;
var statearr_14653_14705 = state_14599__$1;
(statearr_14653_14705[(2)] = null);

(statearr_14653_14705[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14600 === (8))){
var inst_14501 = (state_14599[(8)]);
var inst_14519 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_14501);
var state_14599__$1 = state_14599;
var statearr_14654_14706 = state_14599__$1;
(statearr_14654_14706[(2)] = inst_14519);

(statearr_14654_14706[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__13494__auto__ = null;
var cljs$core$async$mix_$_state_machine__13494__auto____0 = (function (){
var statearr_14655 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14655[(0)] = cljs$core$async$mix_$_state_machine__13494__auto__);

(statearr_14655[(1)] = (1));

return statearr_14655;
});
var cljs$core$async$mix_$_state_machine__13494__auto____1 = (function (state_14599){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_14599);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e14656){var ex__13497__auto__ = e14656;
var statearr_14657_14707 = state_14599;
(statearr_14657_14707[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_14599[(4)]))){
var statearr_14658_14708 = state_14599;
(statearr_14658_14708[(1)] = cljs.core.first((state_14599[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__14709 = state_14599;
state_14599 = G__14709;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__13494__auto__ = function(state_14599){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__13494__auto____1.call(this,state_14599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__13494__auto____0;
cljs$core$async$mix_$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__13494__auto____1;
return cljs$core$async$mix_$_state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_14659 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_14659[(6)] = c__13568__auto___14660);

return statearr_14659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_14712 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_14712(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_14713 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_14713(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_14714 = (function() {
var G__14715 = null;
var G__14715__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__14715__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__14715 = function(p,v){
switch(arguments.length){
case 1:
return G__14715__1.call(this,p);
case 2:
return G__14715__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__14715.cljs$core$IFn$_invoke$arity$1 = G__14715__1;
G__14715.cljs$core$IFn$_invoke$arity$2 = G__14715__2;
return G__14715;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__14711 = arguments.length;
switch (G__14711) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_14714.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_14714.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__14719 = arguments.length;
switch (G__14719) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__14717_SHARP_){
if(cljs.core.truth_((p1__14717_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__14717_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__14717_SHARP_.call(null,topic)))){
return p1__14717_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__14717_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14720 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14720 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta14721){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta14721 = meta14721;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14720.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14722,meta14721__$1){
var self__ = this;
var _14722__$1 = this;
return (new cljs.core.async.t_cljs$core$async14720(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta14721__$1));
}));

(cljs.core.async.t_cljs$core$async14720.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14722){
var self__ = this;
var _14722__$1 = this;
return self__.meta14721;
}));

(cljs.core.async.t_cljs$core$async14720.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14720.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async14720.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14720.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async14720.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async14720.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async14720.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async14720.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta14721], null);
}));

(cljs.core.async.t_cljs$core$async14720.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14720.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14720");

(cljs.core.async.t_cljs$core$async14720.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async14720");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14720.
 */
cljs.core.async.__GT_t_cljs$core$async14720 = (function cljs$core$async$__GT_t_cljs$core$async14720(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta14721){
return (new cljs.core.async.t_cljs$core$async14720(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta14721));
});

}

return (new cljs.core.async.t_cljs$core$async14720(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__13568__auto___14841 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_14794){
var state_val_14795 = (state_14794[(1)]);
if((state_val_14795 === (7))){
var inst_14790 = (state_14794[(2)]);
var state_14794__$1 = state_14794;
var statearr_14796_14842 = state_14794__$1;
(statearr_14796_14842[(2)] = inst_14790);

(statearr_14796_14842[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (20))){
var state_14794__$1 = state_14794;
var statearr_14797_14843 = state_14794__$1;
(statearr_14797_14843[(2)] = null);

(statearr_14797_14843[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (1))){
var state_14794__$1 = state_14794;
var statearr_14798_14844 = state_14794__$1;
(statearr_14798_14844[(2)] = null);

(statearr_14798_14844[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (24))){
var inst_14773 = (state_14794[(7)]);
var inst_14782 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_14773);
var state_14794__$1 = state_14794;
var statearr_14799_14845 = state_14794__$1;
(statearr_14799_14845[(2)] = inst_14782);

(statearr_14799_14845[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (4))){
var inst_14725 = (state_14794[(8)]);
var inst_14725__$1 = (state_14794[(2)]);
var inst_14726 = (inst_14725__$1 == null);
var state_14794__$1 = (function (){var statearr_14800 = state_14794;
(statearr_14800[(8)] = inst_14725__$1);

return statearr_14800;
})();
if(cljs.core.truth_(inst_14726)){
var statearr_14801_14846 = state_14794__$1;
(statearr_14801_14846[(1)] = (5));

} else {
var statearr_14802_14847 = state_14794__$1;
(statearr_14802_14847[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (15))){
var inst_14767 = (state_14794[(2)]);
var state_14794__$1 = state_14794;
var statearr_14803_14848 = state_14794__$1;
(statearr_14803_14848[(2)] = inst_14767);

(statearr_14803_14848[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (21))){
var inst_14787 = (state_14794[(2)]);
var state_14794__$1 = (function (){var statearr_14804 = state_14794;
(statearr_14804[(9)] = inst_14787);

return statearr_14804;
})();
var statearr_14805_14849 = state_14794__$1;
(statearr_14805_14849[(2)] = null);

(statearr_14805_14849[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (13))){
var inst_14749 = (state_14794[(10)]);
var inst_14751 = cljs.core.chunked_seq_QMARK_(inst_14749);
var state_14794__$1 = state_14794;
if(inst_14751){
var statearr_14806_14850 = state_14794__$1;
(statearr_14806_14850[(1)] = (16));

} else {
var statearr_14807_14851 = state_14794__$1;
(statearr_14807_14851[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (22))){
var inst_14779 = (state_14794[(2)]);
var state_14794__$1 = state_14794;
if(cljs.core.truth_(inst_14779)){
var statearr_14808_14852 = state_14794__$1;
(statearr_14808_14852[(1)] = (23));

} else {
var statearr_14809_14853 = state_14794__$1;
(statearr_14809_14853[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (6))){
var inst_14725 = (state_14794[(8)]);
var inst_14775 = (state_14794[(11)]);
var inst_14773 = (state_14794[(7)]);
var inst_14773__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_14725) : topic_fn.call(null,inst_14725));
var inst_14774 = cljs.core.deref(mults);
var inst_14775__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14774,inst_14773__$1);
var state_14794__$1 = (function (){var statearr_14810 = state_14794;
(statearr_14810[(11)] = inst_14775__$1);

(statearr_14810[(7)] = inst_14773__$1);

return statearr_14810;
})();
if(cljs.core.truth_(inst_14775__$1)){
var statearr_14811_14854 = state_14794__$1;
(statearr_14811_14854[(1)] = (19));

} else {
var statearr_14812_14855 = state_14794__$1;
(statearr_14812_14855[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (25))){
var inst_14784 = (state_14794[(2)]);
var state_14794__$1 = state_14794;
var statearr_14813_14856 = state_14794__$1;
(statearr_14813_14856[(2)] = inst_14784);

(statearr_14813_14856[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (17))){
var inst_14749 = (state_14794[(10)]);
var inst_14758 = cljs.core.first(inst_14749);
var inst_14759 = cljs.core.async.muxch_STAR_(inst_14758);
var inst_14760 = cljs.core.async.close_BANG_(inst_14759);
var inst_14761 = cljs.core.next(inst_14749);
var inst_14735 = inst_14761;
var inst_14736 = null;
var inst_14737 = (0);
var inst_14738 = (0);
var state_14794__$1 = (function (){var statearr_14814 = state_14794;
(statearr_14814[(12)] = inst_14736);

(statearr_14814[(13)] = inst_14760);

(statearr_14814[(14)] = inst_14738);

(statearr_14814[(15)] = inst_14737);

(statearr_14814[(16)] = inst_14735);

return statearr_14814;
})();
var statearr_14815_14857 = state_14794__$1;
(statearr_14815_14857[(2)] = null);

(statearr_14815_14857[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (3))){
var inst_14792 = (state_14794[(2)]);
var state_14794__$1 = state_14794;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14794__$1,inst_14792);
} else {
if((state_val_14795 === (12))){
var inst_14769 = (state_14794[(2)]);
var state_14794__$1 = state_14794;
var statearr_14816_14858 = state_14794__$1;
(statearr_14816_14858[(2)] = inst_14769);

(statearr_14816_14858[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (2))){
var state_14794__$1 = state_14794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14794__$1,(4),ch);
} else {
if((state_val_14795 === (23))){
var state_14794__$1 = state_14794;
var statearr_14817_14859 = state_14794__$1;
(statearr_14817_14859[(2)] = null);

(statearr_14817_14859[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (19))){
var inst_14725 = (state_14794[(8)]);
var inst_14775 = (state_14794[(11)]);
var inst_14777 = cljs.core.async.muxch_STAR_(inst_14775);
var state_14794__$1 = state_14794;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14794__$1,(22),inst_14777,inst_14725);
} else {
if((state_val_14795 === (11))){
var inst_14749 = (state_14794[(10)]);
var inst_14735 = (state_14794[(16)]);
var inst_14749__$1 = cljs.core.seq(inst_14735);
var state_14794__$1 = (function (){var statearr_14818 = state_14794;
(statearr_14818[(10)] = inst_14749__$1);

return statearr_14818;
})();
if(inst_14749__$1){
var statearr_14819_14860 = state_14794__$1;
(statearr_14819_14860[(1)] = (13));

} else {
var statearr_14820_14861 = state_14794__$1;
(statearr_14820_14861[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (9))){
var inst_14771 = (state_14794[(2)]);
var state_14794__$1 = state_14794;
var statearr_14821_14862 = state_14794__$1;
(statearr_14821_14862[(2)] = inst_14771);

(statearr_14821_14862[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (5))){
var inst_14732 = cljs.core.deref(mults);
var inst_14733 = cljs.core.vals(inst_14732);
var inst_14734 = cljs.core.seq(inst_14733);
var inst_14735 = inst_14734;
var inst_14736 = null;
var inst_14737 = (0);
var inst_14738 = (0);
var state_14794__$1 = (function (){var statearr_14822 = state_14794;
(statearr_14822[(12)] = inst_14736);

(statearr_14822[(14)] = inst_14738);

(statearr_14822[(15)] = inst_14737);

(statearr_14822[(16)] = inst_14735);

return statearr_14822;
})();
var statearr_14823_14863 = state_14794__$1;
(statearr_14823_14863[(2)] = null);

(statearr_14823_14863[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (14))){
var state_14794__$1 = state_14794;
var statearr_14827_14864 = state_14794__$1;
(statearr_14827_14864[(2)] = null);

(statearr_14827_14864[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (16))){
var inst_14749 = (state_14794[(10)]);
var inst_14753 = cljs.core.chunk_first(inst_14749);
var inst_14754 = cljs.core.chunk_rest(inst_14749);
var inst_14755 = cljs.core.count(inst_14753);
var inst_14735 = inst_14754;
var inst_14736 = inst_14753;
var inst_14737 = inst_14755;
var inst_14738 = (0);
var state_14794__$1 = (function (){var statearr_14828 = state_14794;
(statearr_14828[(12)] = inst_14736);

(statearr_14828[(14)] = inst_14738);

(statearr_14828[(15)] = inst_14737);

(statearr_14828[(16)] = inst_14735);

return statearr_14828;
})();
var statearr_14829_14865 = state_14794__$1;
(statearr_14829_14865[(2)] = null);

(statearr_14829_14865[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (10))){
var inst_14736 = (state_14794[(12)]);
var inst_14738 = (state_14794[(14)]);
var inst_14737 = (state_14794[(15)]);
var inst_14735 = (state_14794[(16)]);
var inst_14743 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_14736,inst_14738);
var inst_14744 = cljs.core.async.muxch_STAR_(inst_14743);
var inst_14745 = cljs.core.async.close_BANG_(inst_14744);
var inst_14746 = (inst_14738 + (1));
var tmp14824 = inst_14736;
var tmp14825 = inst_14737;
var tmp14826 = inst_14735;
var inst_14735__$1 = tmp14826;
var inst_14736__$1 = tmp14824;
var inst_14737__$1 = tmp14825;
var inst_14738__$1 = inst_14746;
var state_14794__$1 = (function (){var statearr_14830 = state_14794;
(statearr_14830[(12)] = inst_14736__$1);

(statearr_14830[(17)] = inst_14745);

(statearr_14830[(14)] = inst_14738__$1);

(statearr_14830[(15)] = inst_14737__$1);

(statearr_14830[(16)] = inst_14735__$1);

return statearr_14830;
})();
var statearr_14831_14866 = state_14794__$1;
(statearr_14831_14866[(2)] = null);

(statearr_14831_14866[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (18))){
var inst_14764 = (state_14794[(2)]);
var state_14794__$1 = state_14794;
var statearr_14832_14867 = state_14794__$1;
(statearr_14832_14867[(2)] = inst_14764);

(statearr_14832_14867[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14795 === (8))){
var inst_14738 = (state_14794[(14)]);
var inst_14737 = (state_14794[(15)]);
var inst_14740 = (inst_14738 < inst_14737);
var inst_14741 = inst_14740;
var state_14794__$1 = state_14794;
if(cljs.core.truth_(inst_14741)){
var statearr_14833_14868 = state_14794__$1;
(statearr_14833_14868[(1)] = (10));

} else {
var statearr_14834_14869 = state_14794__$1;
(statearr_14834_14869[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13494__auto__ = null;
var cljs$core$async$state_machine__13494__auto____0 = (function (){
var statearr_14835 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14835[(0)] = cljs$core$async$state_machine__13494__auto__);

(statearr_14835[(1)] = (1));

return statearr_14835;
});
var cljs$core$async$state_machine__13494__auto____1 = (function (state_14794){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_14794);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e14836){var ex__13497__auto__ = e14836;
var statearr_14837_14870 = state_14794;
(statearr_14837_14870[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_14794[(4)]))){
var statearr_14838_14871 = state_14794;
(statearr_14838_14871[(1)] = cljs.core.first((state_14794[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__14872 = state_14794;
state_14794 = G__14872;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$state_machine__13494__auto__ = function(state_14794){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13494__auto____1.call(this,state_14794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13494__auto____0;
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13494__auto____1;
return cljs$core$async$state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_14839 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_14839[(6)] = c__13568__auto___14841);

return statearr_14839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__14874 = arguments.length;
switch (G__14874) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__14877 = arguments.length;
switch (G__14877) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__14880 = arguments.length;
switch (G__14880) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__13568__auto___14958 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_14923){
var state_val_14924 = (state_14923[(1)]);
if((state_val_14924 === (7))){
var state_14923__$1 = state_14923;
var statearr_14925_14959 = state_14923__$1;
(statearr_14925_14959[(2)] = null);

(statearr_14925_14959[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (1))){
var state_14923__$1 = state_14923;
var statearr_14926_14960 = state_14923__$1;
(statearr_14926_14960[(2)] = null);

(statearr_14926_14960[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (4))){
var inst_14883 = (state_14923[(7)]);
var inst_14884 = (state_14923[(8)]);
var inst_14886 = (inst_14884 < inst_14883);
var state_14923__$1 = state_14923;
if(cljs.core.truth_(inst_14886)){
var statearr_14927_14961 = state_14923__$1;
(statearr_14927_14961[(1)] = (6));

} else {
var statearr_14928_14962 = state_14923__$1;
(statearr_14928_14962[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (15))){
var inst_14909 = (state_14923[(9)]);
var inst_14914 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_14909);
var state_14923__$1 = state_14923;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14923__$1,(17),out,inst_14914);
} else {
if((state_val_14924 === (13))){
var inst_14909 = (state_14923[(9)]);
var inst_14909__$1 = (state_14923[(2)]);
var inst_14910 = cljs.core.some(cljs.core.nil_QMARK_,inst_14909__$1);
var state_14923__$1 = (function (){var statearr_14929 = state_14923;
(statearr_14929[(9)] = inst_14909__$1);

return statearr_14929;
})();
if(cljs.core.truth_(inst_14910)){
var statearr_14930_14963 = state_14923__$1;
(statearr_14930_14963[(1)] = (14));

} else {
var statearr_14931_14964 = state_14923__$1;
(statearr_14931_14964[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (6))){
var state_14923__$1 = state_14923;
var statearr_14932_14965 = state_14923__$1;
(statearr_14932_14965[(2)] = null);

(statearr_14932_14965[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (17))){
var inst_14916 = (state_14923[(2)]);
var state_14923__$1 = (function (){var statearr_14934 = state_14923;
(statearr_14934[(10)] = inst_14916);

return statearr_14934;
})();
var statearr_14935_14966 = state_14923__$1;
(statearr_14935_14966[(2)] = null);

(statearr_14935_14966[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (3))){
var inst_14921 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14923__$1,inst_14921);
} else {
if((state_val_14924 === (12))){
var _ = (function (){var statearr_14936 = state_14923;
(statearr_14936[(4)] = cljs.core.rest((state_14923[(4)])));

return statearr_14936;
})();
var state_14923__$1 = state_14923;
var ex14933 = (state_14923__$1[(2)]);
var statearr_14937_14967 = state_14923__$1;
(statearr_14937_14967[(5)] = ex14933);


if((ex14933 instanceof Object)){
var statearr_14938_14968 = state_14923__$1;
(statearr_14938_14968[(1)] = (11));

(statearr_14938_14968[(5)] = null);

} else {
throw ex14933;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (2))){
var inst_14882 = cljs.core.reset_BANG_(dctr,cnt);
var inst_14883 = cnt;
var inst_14884 = (0);
var state_14923__$1 = (function (){var statearr_14939 = state_14923;
(statearr_14939[(7)] = inst_14883);

(statearr_14939[(11)] = inst_14882);

(statearr_14939[(8)] = inst_14884);

return statearr_14939;
})();
var statearr_14940_14969 = state_14923__$1;
(statearr_14940_14969[(2)] = null);

(statearr_14940_14969[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (11))){
var inst_14888 = (state_14923[(2)]);
var inst_14889 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_14923__$1 = (function (){var statearr_14941 = state_14923;
(statearr_14941[(12)] = inst_14888);

return statearr_14941;
})();
var statearr_14942_14970 = state_14923__$1;
(statearr_14942_14970[(2)] = inst_14889);

(statearr_14942_14970[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (9))){
var inst_14884 = (state_14923[(8)]);
var _ = (function (){var statearr_14943 = state_14923;
(statearr_14943[(4)] = cljs.core.cons((12),(state_14923[(4)])));

return statearr_14943;
})();
var inst_14895 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_14884) : chs__$1.call(null,inst_14884));
var inst_14896 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_14884) : done.call(null,inst_14884));
var inst_14897 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_14895,inst_14896);
var ___$1 = (function (){var statearr_14944 = state_14923;
(statearr_14944[(4)] = cljs.core.rest((state_14923[(4)])));

return statearr_14944;
})();
var state_14923__$1 = state_14923;
var statearr_14945_14971 = state_14923__$1;
(statearr_14945_14971[(2)] = inst_14897);

(statearr_14945_14971[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (5))){
var inst_14907 = (state_14923[(2)]);
var state_14923__$1 = (function (){var statearr_14946 = state_14923;
(statearr_14946[(13)] = inst_14907);

return statearr_14946;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14923__$1,(13),dchan);
} else {
if((state_val_14924 === (14))){
var inst_14912 = cljs.core.async.close_BANG_(out);
var state_14923__$1 = state_14923;
var statearr_14947_14972 = state_14923__$1;
(statearr_14947_14972[(2)] = inst_14912);

(statearr_14947_14972[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (16))){
var inst_14919 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
var statearr_14948_14973 = state_14923__$1;
(statearr_14948_14973[(2)] = inst_14919);

(statearr_14948_14973[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (10))){
var inst_14884 = (state_14923[(8)]);
var inst_14900 = (state_14923[(2)]);
var inst_14901 = (inst_14884 + (1));
var inst_14884__$1 = inst_14901;
var state_14923__$1 = (function (){var statearr_14949 = state_14923;
(statearr_14949[(14)] = inst_14900);

(statearr_14949[(8)] = inst_14884__$1);

return statearr_14949;
})();
var statearr_14950_14974 = state_14923__$1;
(statearr_14950_14974[(2)] = null);

(statearr_14950_14974[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14924 === (8))){
var inst_14905 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
var statearr_14951_14975 = state_14923__$1;
(statearr_14951_14975[(2)] = inst_14905);

(statearr_14951_14975[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13494__auto__ = null;
var cljs$core$async$state_machine__13494__auto____0 = (function (){
var statearr_14952 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14952[(0)] = cljs$core$async$state_machine__13494__auto__);

(statearr_14952[(1)] = (1));

return statearr_14952;
});
var cljs$core$async$state_machine__13494__auto____1 = (function (state_14923){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_14923);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e14953){var ex__13497__auto__ = e14953;
var statearr_14954_14976 = state_14923;
(statearr_14954_14976[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_14923[(4)]))){
var statearr_14955_14977 = state_14923;
(statearr_14955_14977[(1)] = cljs.core.first((state_14923[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__14978 = state_14923;
state_14923 = G__14978;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$state_machine__13494__auto__ = function(state_14923){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13494__auto____1.call(this,state_14923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13494__auto____0;
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13494__auto____1;
return cljs$core$async$state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_14956 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_14956[(6)] = c__13568__auto___14958);

return statearr_14956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__14981 = arguments.length;
switch (G__14981) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13568__auto___15036 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_15013){
var state_val_15014 = (state_15013[(1)]);
if((state_val_15014 === (7))){
var inst_14993 = (state_15013[(7)]);
var inst_14992 = (state_15013[(8)]);
var inst_14992__$1 = (state_15013[(2)]);
var inst_14993__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14992__$1,(0),null);
var inst_14994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14992__$1,(1),null);
var inst_14995 = (inst_14993__$1 == null);
var state_15013__$1 = (function (){var statearr_15015 = state_15013;
(statearr_15015[(9)] = inst_14994);

(statearr_15015[(7)] = inst_14993__$1);

(statearr_15015[(8)] = inst_14992__$1);

return statearr_15015;
})();
if(cljs.core.truth_(inst_14995)){
var statearr_15016_15037 = state_15013__$1;
(statearr_15016_15037[(1)] = (8));

} else {
var statearr_15017_15038 = state_15013__$1;
(statearr_15017_15038[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15014 === (1))){
var inst_14982 = cljs.core.vec(chs);
var inst_14983 = inst_14982;
var state_15013__$1 = (function (){var statearr_15018 = state_15013;
(statearr_15018[(10)] = inst_14983);

return statearr_15018;
})();
var statearr_15019_15039 = state_15013__$1;
(statearr_15019_15039[(2)] = null);

(statearr_15019_15039[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15014 === (4))){
var inst_14983 = (state_15013[(10)]);
var state_15013__$1 = state_15013;
return cljs.core.async.ioc_alts_BANG_(state_15013__$1,(7),inst_14983);
} else {
if((state_val_15014 === (6))){
var inst_15009 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
var statearr_15020_15040 = state_15013__$1;
(statearr_15020_15040[(2)] = inst_15009);

(statearr_15020_15040[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15014 === (3))){
var inst_15011 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15013__$1,inst_15011);
} else {
if((state_val_15014 === (2))){
var inst_14983 = (state_15013[(10)]);
var inst_14985 = cljs.core.count(inst_14983);
var inst_14986 = (inst_14985 > (0));
var state_15013__$1 = state_15013;
if(cljs.core.truth_(inst_14986)){
var statearr_15022_15041 = state_15013__$1;
(statearr_15022_15041[(1)] = (4));

} else {
var statearr_15023_15042 = state_15013__$1;
(statearr_15023_15042[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15014 === (11))){
var inst_14983 = (state_15013[(10)]);
var inst_15002 = (state_15013[(2)]);
var tmp15021 = inst_14983;
var inst_14983__$1 = tmp15021;
var state_15013__$1 = (function (){var statearr_15024 = state_15013;
(statearr_15024[(10)] = inst_14983__$1);

(statearr_15024[(11)] = inst_15002);

return statearr_15024;
})();
var statearr_15025_15043 = state_15013__$1;
(statearr_15025_15043[(2)] = null);

(statearr_15025_15043[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15014 === (9))){
var inst_14993 = (state_15013[(7)]);
var state_15013__$1 = state_15013;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15013__$1,(11),out,inst_14993);
} else {
if((state_val_15014 === (5))){
var inst_15007 = cljs.core.async.close_BANG_(out);
var state_15013__$1 = state_15013;
var statearr_15026_15044 = state_15013__$1;
(statearr_15026_15044[(2)] = inst_15007);

(statearr_15026_15044[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15014 === (10))){
var inst_15005 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
var statearr_15027_15045 = state_15013__$1;
(statearr_15027_15045[(2)] = inst_15005);

(statearr_15027_15045[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15014 === (8))){
var inst_14983 = (state_15013[(10)]);
var inst_14994 = (state_15013[(9)]);
var inst_14993 = (state_15013[(7)]);
var inst_14992 = (state_15013[(8)]);
var inst_14997 = (function (){var cs = inst_14983;
var vec__14988 = inst_14992;
var v = inst_14993;
var c = inst_14994;
return (function (p1__14979_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__14979_SHARP_);
});
})();
var inst_14998 = cljs.core.filterv(inst_14997,inst_14983);
var inst_14983__$1 = inst_14998;
var state_15013__$1 = (function (){var statearr_15028 = state_15013;
(statearr_15028[(10)] = inst_14983__$1);

return statearr_15028;
})();
var statearr_15029_15046 = state_15013__$1;
(statearr_15029_15046[(2)] = null);

(statearr_15029_15046[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13494__auto__ = null;
var cljs$core$async$state_machine__13494__auto____0 = (function (){
var statearr_15030 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15030[(0)] = cljs$core$async$state_machine__13494__auto__);

(statearr_15030[(1)] = (1));

return statearr_15030;
});
var cljs$core$async$state_machine__13494__auto____1 = (function (state_15013){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_15013);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e15031){var ex__13497__auto__ = e15031;
var statearr_15032_15047 = state_15013;
(statearr_15032_15047[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_15013[(4)]))){
var statearr_15033_15048 = state_15013;
(statearr_15033_15048[(1)] = cljs.core.first((state_15013[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__15049 = state_15013;
state_15013 = G__15049;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$state_machine__13494__auto__ = function(state_15013){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13494__auto____1.call(this,state_15013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13494__auto____0;
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13494__auto____1;
return cljs$core$async$state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_15034 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_15034[(6)] = c__13568__auto___15036);

return statearr_15034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__15051 = arguments.length;
switch (G__15051) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13568__auto___15097 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_15075){
var state_val_15076 = (state_15075[(1)]);
if((state_val_15076 === (7))){
var inst_15057 = (state_15075[(7)]);
var inst_15057__$1 = (state_15075[(2)]);
var inst_15058 = (inst_15057__$1 == null);
var inst_15059 = cljs.core.not(inst_15058);
var state_15075__$1 = (function (){var statearr_15077 = state_15075;
(statearr_15077[(7)] = inst_15057__$1);

return statearr_15077;
})();
if(inst_15059){
var statearr_15078_15098 = state_15075__$1;
(statearr_15078_15098[(1)] = (8));

} else {
var statearr_15079_15099 = state_15075__$1;
(statearr_15079_15099[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15076 === (1))){
var inst_15052 = (0);
var state_15075__$1 = (function (){var statearr_15080 = state_15075;
(statearr_15080[(8)] = inst_15052);

return statearr_15080;
})();
var statearr_15081_15100 = state_15075__$1;
(statearr_15081_15100[(2)] = null);

(statearr_15081_15100[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15076 === (4))){
var state_15075__$1 = state_15075;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15075__$1,(7),ch);
} else {
if((state_val_15076 === (6))){
var inst_15070 = (state_15075[(2)]);
var state_15075__$1 = state_15075;
var statearr_15082_15101 = state_15075__$1;
(statearr_15082_15101[(2)] = inst_15070);

(statearr_15082_15101[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15076 === (3))){
var inst_15072 = (state_15075[(2)]);
var inst_15073 = cljs.core.async.close_BANG_(out);
var state_15075__$1 = (function (){var statearr_15083 = state_15075;
(statearr_15083[(9)] = inst_15072);

return statearr_15083;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_15075__$1,inst_15073);
} else {
if((state_val_15076 === (2))){
var inst_15052 = (state_15075[(8)]);
var inst_15054 = (inst_15052 < n);
var state_15075__$1 = state_15075;
if(cljs.core.truth_(inst_15054)){
var statearr_15084_15102 = state_15075__$1;
(statearr_15084_15102[(1)] = (4));

} else {
var statearr_15085_15103 = state_15075__$1;
(statearr_15085_15103[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15076 === (11))){
var inst_15052 = (state_15075[(8)]);
var inst_15062 = (state_15075[(2)]);
var inst_15063 = (inst_15052 + (1));
var inst_15052__$1 = inst_15063;
var state_15075__$1 = (function (){var statearr_15086 = state_15075;
(statearr_15086[(10)] = inst_15062);

(statearr_15086[(8)] = inst_15052__$1);

return statearr_15086;
})();
var statearr_15087_15104 = state_15075__$1;
(statearr_15087_15104[(2)] = null);

(statearr_15087_15104[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15076 === (9))){
var state_15075__$1 = state_15075;
var statearr_15088_15105 = state_15075__$1;
(statearr_15088_15105[(2)] = null);

(statearr_15088_15105[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15076 === (5))){
var state_15075__$1 = state_15075;
var statearr_15089_15106 = state_15075__$1;
(statearr_15089_15106[(2)] = null);

(statearr_15089_15106[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15076 === (10))){
var inst_15067 = (state_15075[(2)]);
var state_15075__$1 = state_15075;
var statearr_15090_15107 = state_15075__$1;
(statearr_15090_15107[(2)] = inst_15067);

(statearr_15090_15107[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15076 === (8))){
var inst_15057 = (state_15075[(7)]);
var state_15075__$1 = state_15075;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15075__$1,(11),out,inst_15057);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13494__auto__ = null;
var cljs$core$async$state_machine__13494__auto____0 = (function (){
var statearr_15091 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15091[(0)] = cljs$core$async$state_machine__13494__auto__);

(statearr_15091[(1)] = (1));

return statearr_15091;
});
var cljs$core$async$state_machine__13494__auto____1 = (function (state_15075){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_15075);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e15092){var ex__13497__auto__ = e15092;
var statearr_15093_15108 = state_15075;
(statearr_15093_15108[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_15075[(4)]))){
var statearr_15094_15109 = state_15075;
(statearr_15094_15109[(1)] = cljs.core.first((state_15075[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__15110 = state_15075;
state_15075 = G__15110;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$state_machine__13494__auto__ = function(state_15075){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13494__auto____1.call(this,state_15075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13494__auto____0;
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13494__auto____1;
return cljs$core$async$state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_15095 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_15095[(6)] = c__13568__auto___15097);

return statearr_15095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15112 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15112 = (function (f,ch,meta15113){
this.f = f;
this.ch = ch;
this.meta15113 = meta15113;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15112.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15114,meta15113__$1){
var self__ = this;
var _15114__$1 = this;
return (new cljs.core.async.t_cljs$core$async15112(self__.f,self__.ch,meta15113__$1));
}));

(cljs.core.async.t_cljs$core$async15112.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15114){
var self__ = this;
var _15114__$1 = this;
return self__.meta15113;
}));

(cljs.core.async.t_cljs$core$async15112.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15112.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15112.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15112.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15112.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15115 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15115 = (function (f,ch,meta15113,_,fn1,meta15116){
this.f = f;
this.ch = ch;
this.meta15113 = meta15113;
this._ = _;
this.fn1 = fn1;
this.meta15116 = meta15116;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15115.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15117,meta15116__$1){
var self__ = this;
var _15117__$1 = this;
return (new cljs.core.async.t_cljs$core$async15115(self__.f,self__.ch,self__.meta15113,self__._,self__.fn1,meta15116__$1));
}));

(cljs.core.async.t_cljs$core$async15115.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15117){
var self__ = this;
var _15117__$1 = this;
return self__.meta15116;
}));

(cljs.core.async.t_cljs$core$async15115.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15115.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async15115.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async15115.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__15111_SHARP_){
var G__15118 = (((p1__15111_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__15111_SHARP_) : self__.f.call(null,p1__15111_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__15118) : f1.call(null,G__15118));
});
}));

(cljs.core.async.t_cljs$core$async15115.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta15113,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async15112], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta15116], null);
}));

(cljs.core.async.t_cljs$core$async15115.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15115.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15115");

(cljs.core.async.t_cljs$core$async15115.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async15115");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15115.
 */
cljs.core.async.__GT_t_cljs$core$async15115 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15115(f__$1,ch__$1,meta15113__$1,___$2,fn1__$1,meta15116){
return (new cljs.core.async.t_cljs$core$async15115(f__$1,ch__$1,meta15113__$1,___$2,fn1__$1,meta15116));
});

}

return (new cljs.core.async.t_cljs$core$async15115(self__.f,self__.ch,self__.meta15113,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__15119 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__15119) : self__.f.call(null,G__15119));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async15112.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15112.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async15112.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta15113], null);
}));

(cljs.core.async.t_cljs$core$async15112.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15112.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15112");

(cljs.core.async.t_cljs$core$async15112.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async15112");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15112.
 */
cljs.core.async.__GT_t_cljs$core$async15112 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15112(f__$1,ch__$1,meta15113){
return (new cljs.core.async.t_cljs$core$async15112(f__$1,ch__$1,meta15113));
});

}

return (new cljs.core.async.t_cljs$core$async15112(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15120 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15120 = (function (f,ch,meta15121){
this.f = f;
this.ch = ch;
this.meta15121 = meta15121;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15120.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15122,meta15121__$1){
var self__ = this;
var _15122__$1 = this;
return (new cljs.core.async.t_cljs$core$async15120(self__.f,self__.ch,meta15121__$1));
}));

(cljs.core.async.t_cljs$core$async15120.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15122){
var self__ = this;
var _15122__$1 = this;
return self__.meta15121;
}));

(cljs.core.async.t_cljs$core$async15120.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15120.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15120.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15120.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async15120.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15120.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async15120.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta15121], null);
}));

(cljs.core.async.t_cljs$core$async15120.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15120.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15120");

(cljs.core.async.t_cljs$core$async15120.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async15120");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15120.
 */
cljs.core.async.__GT_t_cljs$core$async15120 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async15120(f__$1,ch__$1,meta15121){
return (new cljs.core.async.t_cljs$core$async15120(f__$1,ch__$1,meta15121));
});

}

return (new cljs.core.async.t_cljs$core$async15120(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15123 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15123 = (function (p,ch,meta15124){
this.p = p;
this.ch = ch;
this.meta15124 = meta15124;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15123.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15125,meta15124__$1){
var self__ = this;
var _15125__$1 = this;
return (new cljs.core.async.t_cljs$core$async15123(self__.p,self__.ch,meta15124__$1));
}));

(cljs.core.async.t_cljs$core$async15123.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15125){
var self__ = this;
var _15125__$1 = this;
return self__.meta15124;
}));

(cljs.core.async.t_cljs$core$async15123.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15123.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15123.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15123.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15123.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async15123.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15123.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async15123.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta15124], null);
}));

(cljs.core.async.t_cljs$core$async15123.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15123.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15123");

(cljs.core.async.t_cljs$core$async15123.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async15123");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15123.
 */
cljs.core.async.__GT_t_cljs$core$async15123 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async15123(p__$1,ch__$1,meta15124){
return (new cljs.core.async.t_cljs$core$async15123(p__$1,ch__$1,meta15124));
});

}

return (new cljs.core.async.t_cljs$core$async15123(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__15127 = arguments.length;
switch (G__15127) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13568__auto___15168 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_15148){
var state_val_15149 = (state_15148[(1)]);
if((state_val_15149 === (7))){
var inst_15144 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15150_15169 = state_15148__$1;
(statearr_15150_15169[(2)] = inst_15144);

(statearr_15150_15169[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15149 === (1))){
var state_15148__$1 = state_15148;
var statearr_15151_15170 = state_15148__$1;
(statearr_15151_15170[(2)] = null);

(statearr_15151_15170[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15149 === (4))){
var inst_15130 = (state_15148[(7)]);
var inst_15130__$1 = (state_15148[(2)]);
var inst_15131 = (inst_15130__$1 == null);
var state_15148__$1 = (function (){var statearr_15152 = state_15148;
(statearr_15152[(7)] = inst_15130__$1);

return statearr_15152;
})();
if(cljs.core.truth_(inst_15131)){
var statearr_15153_15171 = state_15148__$1;
(statearr_15153_15171[(1)] = (5));

} else {
var statearr_15154_15172 = state_15148__$1;
(statearr_15154_15172[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15149 === (6))){
var inst_15130 = (state_15148[(7)]);
var inst_15135 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_15130) : p.call(null,inst_15130));
var state_15148__$1 = state_15148;
if(cljs.core.truth_(inst_15135)){
var statearr_15155_15173 = state_15148__$1;
(statearr_15155_15173[(1)] = (8));

} else {
var statearr_15156_15174 = state_15148__$1;
(statearr_15156_15174[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15149 === (3))){
var inst_15146 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15148__$1,inst_15146);
} else {
if((state_val_15149 === (2))){
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15148__$1,(4),ch);
} else {
if((state_val_15149 === (11))){
var inst_15138 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15157_15175 = state_15148__$1;
(statearr_15157_15175[(2)] = inst_15138);

(statearr_15157_15175[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15149 === (9))){
var state_15148__$1 = state_15148;
var statearr_15158_15176 = state_15148__$1;
(statearr_15158_15176[(2)] = null);

(statearr_15158_15176[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15149 === (5))){
var inst_15133 = cljs.core.async.close_BANG_(out);
var state_15148__$1 = state_15148;
var statearr_15159_15177 = state_15148__$1;
(statearr_15159_15177[(2)] = inst_15133);

(statearr_15159_15177[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15149 === (10))){
var inst_15141 = (state_15148[(2)]);
var state_15148__$1 = (function (){var statearr_15160 = state_15148;
(statearr_15160[(8)] = inst_15141);

return statearr_15160;
})();
var statearr_15161_15178 = state_15148__$1;
(statearr_15161_15178[(2)] = null);

(statearr_15161_15178[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15149 === (8))){
var inst_15130 = (state_15148[(7)]);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15148__$1,(11),out,inst_15130);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13494__auto__ = null;
var cljs$core$async$state_machine__13494__auto____0 = (function (){
var statearr_15162 = [null,null,null,null,null,null,null,null,null];
(statearr_15162[(0)] = cljs$core$async$state_machine__13494__auto__);

(statearr_15162[(1)] = (1));

return statearr_15162;
});
var cljs$core$async$state_machine__13494__auto____1 = (function (state_15148){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_15148);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e15163){var ex__13497__auto__ = e15163;
var statearr_15164_15179 = state_15148;
(statearr_15164_15179[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_15148[(4)]))){
var statearr_15165_15180 = state_15148;
(statearr_15165_15180[(1)] = cljs.core.first((state_15148[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__15181 = state_15148;
state_15148 = G__15181;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$state_machine__13494__auto__ = function(state_15148){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13494__auto____1.call(this,state_15148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13494__auto____0;
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13494__auto____1;
return cljs$core$async$state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_15166 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_15166[(6)] = c__13568__auto___15168);

return statearr_15166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__15183 = arguments.length;
switch (G__15183) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__13568__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_15246){
var state_val_15247 = (state_15246[(1)]);
if((state_val_15247 === (7))){
var inst_15242 = (state_15246[(2)]);
var state_15246__$1 = state_15246;
var statearr_15248_15287 = state_15246__$1;
(statearr_15248_15287[(2)] = inst_15242);

(statearr_15248_15287[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (20))){
var inst_15212 = (state_15246[(7)]);
var inst_15223 = (state_15246[(2)]);
var inst_15224 = cljs.core.next(inst_15212);
var inst_15198 = inst_15224;
var inst_15199 = null;
var inst_15200 = (0);
var inst_15201 = (0);
var state_15246__$1 = (function (){var statearr_15249 = state_15246;
(statearr_15249[(8)] = inst_15198);

(statearr_15249[(9)] = inst_15199);

(statearr_15249[(10)] = inst_15200);

(statearr_15249[(11)] = inst_15201);

(statearr_15249[(12)] = inst_15223);

return statearr_15249;
})();
var statearr_15250_15288 = state_15246__$1;
(statearr_15250_15288[(2)] = null);

(statearr_15250_15288[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (1))){
var state_15246__$1 = state_15246;
var statearr_15251_15289 = state_15246__$1;
(statearr_15251_15289[(2)] = null);

(statearr_15251_15289[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (4))){
var inst_15187 = (state_15246[(13)]);
var inst_15187__$1 = (state_15246[(2)]);
var inst_15188 = (inst_15187__$1 == null);
var state_15246__$1 = (function (){var statearr_15252 = state_15246;
(statearr_15252[(13)] = inst_15187__$1);

return statearr_15252;
})();
if(cljs.core.truth_(inst_15188)){
var statearr_15253_15290 = state_15246__$1;
(statearr_15253_15290[(1)] = (5));

} else {
var statearr_15254_15291 = state_15246__$1;
(statearr_15254_15291[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (15))){
var state_15246__$1 = state_15246;
var statearr_15258_15292 = state_15246__$1;
(statearr_15258_15292[(2)] = null);

(statearr_15258_15292[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (21))){
var state_15246__$1 = state_15246;
var statearr_15259_15293 = state_15246__$1;
(statearr_15259_15293[(2)] = null);

(statearr_15259_15293[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (13))){
var inst_15198 = (state_15246[(8)]);
var inst_15199 = (state_15246[(9)]);
var inst_15200 = (state_15246[(10)]);
var inst_15201 = (state_15246[(11)]);
var inst_15208 = (state_15246[(2)]);
var inst_15209 = (inst_15201 + (1));
var tmp15255 = inst_15198;
var tmp15256 = inst_15199;
var tmp15257 = inst_15200;
var inst_15198__$1 = tmp15255;
var inst_15199__$1 = tmp15256;
var inst_15200__$1 = tmp15257;
var inst_15201__$1 = inst_15209;
var state_15246__$1 = (function (){var statearr_15260 = state_15246;
(statearr_15260[(8)] = inst_15198__$1);

(statearr_15260[(9)] = inst_15199__$1);

(statearr_15260[(14)] = inst_15208);

(statearr_15260[(10)] = inst_15200__$1);

(statearr_15260[(11)] = inst_15201__$1);

return statearr_15260;
})();
var statearr_15261_15294 = state_15246__$1;
(statearr_15261_15294[(2)] = null);

(statearr_15261_15294[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (22))){
var state_15246__$1 = state_15246;
var statearr_15262_15295 = state_15246__$1;
(statearr_15262_15295[(2)] = null);

(statearr_15262_15295[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (6))){
var inst_15187 = (state_15246[(13)]);
var inst_15196 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_15187) : f.call(null,inst_15187));
var inst_15197 = cljs.core.seq(inst_15196);
var inst_15198 = inst_15197;
var inst_15199 = null;
var inst_15200 = (0);
var inst_15201 = (0);
var state_15246__$1 = (function (){var statearr_15263 = state_15246;
(statearr_15263[(8)] = inst_15198);

(statearr_15263[(9)] = inst_15199);

(statearr_15263[(10)] = inst_15200);

(statearr_15263[(11)] = inst_15201);

return statearr_15263;
})();
var statearr_15264_15296 = state_15246__$1;
(statearr_15264_15296[(2)] = null);

(statearr_15264_15296[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (17))){
var inst_15212 = (state_15246[(7)]);
var inst_15216 = cljs.core.chunk_first(inst_15212);
var inst_15217 = cljs.core.chunk_rest(inst_15212);
var inst_15218 = cljs.core.count(inst_15216);
var inst_15198 = inst_15217;
var inst_15199 = inst_15216;
var inst_15200 = inst_15218;
var inst_15201 = (0);
var state_15246__$1 = (function (){var statearr_15265 = state_15246;
(statearr_15265[(8)] = inst_15198);

(statearr_15265[(9)] = inst_15199);

(statearr_15265[(10)] = inst_15200);

(statearr_15265[(11)] = inst_15201);

return statearr_15265;
})();
var statearr_15266_15297 = state_15246__$1;
(statearr_15266_15297[(2)] = null);

(statearr_15266_15297[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (3))){
var inst_15244 = (state_15246[(2)]);
var state_15246__$1 = state_15246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15246__$1,inst_15244);
} else {
if((state_val_15247 === (12))){
var inst_15232 = (state_15246[(2)]);
var state_15246__$1 = state_15246;
var statearr_15267_15298 = state_15246__$1;
(statearr_15267_15298[(2)] = inst_15232);

(statearr_15267_15298[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (2))){
var state_15246__$1 = state_15246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15246__$1,(4),in$);
} else {
if((state_val_15247 === (23))){
var inst_15240 = (state_15246[(2)]);
var state_15246__$1 = state_15246;
var statearr_15268_15299 = state_15246__$1;
(statearr_15268_15299[(2)] = inst_15240);

(statearr_15268_15299[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (19))){
var inst_15227 = (state_15246[(2)]);
var state_15246__$1 = state_15246;
var statearr_15269_15300 = state_15246__$1;
(statearr_15269_15300[(2)] = inst_15227);

(statearr_15269_15300[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (11))){
var inst_15198 = (state_15246[(8)]);
var inst_15212 = (state_15246[(7)]);
var inst_15212__$1 = cljs.core.seq(inst_15198);
var state_15246__$1 = (function (){var statearr_15270 = state_15246;
(statearr_15270[(7)] = inst_15212__$1);

return statearr_15270;
})();
if(inst_15212__$1){
var statearr_15271_15301 = state_15246__$1;
(statearr_15271_15301[(1)] = (14));

} else {
var statearr_15272_15302 = state_15246__$1;
(statearr_15272_15302[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (9))){
var inst_15234 = (state_15246[(2)]);
var inst_15235 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_15246__$1 = (function (){var statearr_15273 = state_15246;
(statearr_15273[(15)] = inst_15234);

return statearr_15273;
})();
if(cljs.core.truth_(inst_15235)){
var statearr_15274_15303 = state_15246__$1;
(statearr_15274_15303[(1)] = (21));

} else {
var statearr_15275_15304 = state_15246__$1;
(statearr_15275_15304[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (5))){
var inst_15190 = cljs.core.async.close_BANG_(out);
var state_15246__$1 = state_15246;
var statearr_15276_15305 = state_15246__$1;
(statearr_15276_15305[(2)] = inst_15190);

(statearr_15276_15305[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (14))){
var inst_15212 = (state_15246[(7)]);
var inst_15214 = cljs.core.chunked_seq_QMARK_(inst_15212);
var state_15246__$1 = state_15246;
if(inst_15214){
var statearr_15277_15306 = state_15246__$1;
(statearr_15277_15306[(1)] = (17));

} else {
var statearr_15278_15307 = state_15246__$1;
(statearr_15278_15307[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (16))){
var inst_15230 = (state_15246[(2)]);
var state_15246__$1 = state_15246;
var statearr_15279_15308 = state_15246__$1;
(statearr_15279_15308[(2)] = inst_15230);

(statearr_15279_15308[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15247 === (10))){
var inst_15199 = (state_15246[(9)]);
var inst_15201 = (state_15246[(11)]);
var inst_15206 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15199,inst_15201);
var state_15246__$1 = state_15246;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15246__$1,(13),out,inst_15206);
} else {
if((state_val_15247 === (18))){
var inst_15212 = (state_15246[(7)]);
var inst_15221 = cljs.core.first(inst_15212);
var state_15246__$1 = state_15246;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15246__$1,(20),out,inst_15221);
} else {
if((state_val_15247 === (8))){
var inst_15200 = (state_15246[(10)]);
var inst_15201 = (state_15246[(11)]);
var inst_15203 = (inst_15201 < inst_15200);
var inst_15204 = inst_15203;
var state_15246__$1 = state_15246;
if(cljs.core.truth_(inst_15204)){
var statearr_15280_15309 = state_15246__$1;
(statearr_15280_15309[(1)] = (10));

} else {
var statearr_15281_15310 = state_15246__$1;
(statearr_15281_15310[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__13494__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__13494__auto____0 = (function (){
var statearr_15282 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15282[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__13494__auto__);

(statearr_15282[(1)] = (1));

return statearr_15282;
});
var cljs$core$async$mapcat_STAR__$_state_machine__13494__auto____1 = (function (state_15246){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_15246);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e15283){var ex__13497__auto__ = e15283;
var statearr_15284_15311 = state_15246;
(statearr_15284_15311[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_15246[(4)]))){
var statearr_15285_15312 = state_15246;
(statearr_15285_15312[(1)] = cljs.core.first((state_15246[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__15313 = state_15246;
state_15246 = G__15313;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__13494__auto__ = function(state_15246){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__13494__auto____1.call(this,state_15246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__13494__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__13494__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_15286 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_15286[(6)] = c__13568__auto__);

return statearr_15286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));

return c__13568__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__15315 = arguments.length;
switch (G__15315) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__15318 = arguments.length;
switch (G__15318) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__15321 = arguments.length;
switch (G__15321) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13568__auto___15369 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_15345){
var state_val_15346 = (state_15345[(1)]);
if((state_val_15346 === (7))){
var inst_15340 = (state_15345[(2)]);
var state_15345__$1 = state_15345;
var statearr_15347_15370 = state_15345__$1;
(statearr_15347_15370[(2)] = inst_15340);

(statearr_15347_15370[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15346 === (1))){
var inst_15322 = null;
var state_15345__$1 = (function (){var statearr_15348 = state_15345;
(statearr_15348[(7)] = inst_15322);

return statearr_15348;
})();
var statearr_15349_15371 = state_15345__$1;
(statearr_15349_15371[(2)] = null);

(statearr_15349_15371[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15346 === (4))){
var inst_15325 = (state_15345[(8)]);
var inst_15325__$1 = (state_15345[(2)]);
var inst_15326 = (inst_15325__$1 == null);
var inst_15327 = cljs.core.not(inst_15326);
var state_15345__$1 = (function (){var statearr_15350 = state_15345;
(statearr_15350[(8)] = inst_15325__$1);

return statearr_15350;
})();
if(inst_15327){
var statearr_15351_15372 = state_15345__$1;
(statearr_15351_15372[(1)] = (5));

} else {
var statearr_15352_15373 = state_15345__$1;
(statearr_15352_15373[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15346 === (6))){
var state_15345__$1 = state_15345;
var statearr_15353_15374 = state_15345__$1;
(statearr_15353_15374[(2)] = null);

(statearr_15353_15374[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15346 === (3))){
var inst_15342 = (state_15345[(2)]);
var inst_15343 = cljs.core.async.close_BANG_(out);
var state_15345__$1 = (function (){var statearr_15354 = state_15345;
(statearr_15354[(9)] = inst_15342);

return statearr_15354;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_15345__$1,inst_15343);
} else {
if((state_val_15346 === (2))){
var state_15345__$1 = state_15345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15345__$1,(4),ch);
} else {
if((state_val_15346 === (11))){
var inst_15325 = (state_15345[(8)]);
var inst_15334 = (state_15345[(2)]);
var inst_15322 = inst_15325;
var state_15345__$1 = (function (){var statearr_15355 = state_15345;
(statearr_15355[(10)] = inst_15334);

(statearr_15355[(7)] = inst_15322);

return statearr_15355;
})();
var statearr_15356_15375 = state_15345__$1;
(statearr_15356_15375[(2)] = null);

(statearr_15356_15375[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15346 === (9))){
var inst_15325 = (state_15345[(8)]);
var state_15345__$1 = state_15345;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15345__$1,(11),out,inst_15325);
} else {
if((state_val_15346 === (5))){
var inst_15322 = (state_15345[(7)]);
var inst_15325 = (state_15345[(8)]);
var inst_15329 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15325,inst_15322);
var state_15345__$1 = state_15345;
if(inst_15329){
var statearr_15358_15376 = state_15345__$1;
(statearr_15358_15376[(1)] = (8));

} else {
var statearr_15359_15377 = state_15345__$1;
(statearr_15359_15377[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15346 === (10))){
var inst_15337 = (state_15345[(2)]);
var state_15345__$1 = state_15345;
var statearr_15360_15378 = state_15345__$1;
(statearr_15360_15378[(2)] = inst_15337);

(statearr_15360_15378[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15346 === (8))){
var inst_15322 = (state_15345[(7)]);
var tmp15357 = inst_15322;
var inst_15322__$1 = tmp15357;
var state_15345__$1 = (function (){var statearr_15361 = state_15345;
(statearr_15361[(7)] = inst_15322__$1);

return statearr_15361;
})();
var statearr_15362_15379 = state_15345__$1;
(statearr_15362_15379[(2)] = null);

(statearr_15362_15379[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13494__auto__ = null;
var cljs$core$async$state_machine__13494__auto____0 = (function (){
var statearr_15363 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15363[(0)] = cljs$core$async$state_machine__13494__auto__);

(statearr_15363[(1)] = (1));

return statearr_15363;
});
var cljs$core$async$state_machine__13494__auto____1 = (function (state_15345){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_15345);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e15364){var ex__13497__auto__ = e15364;
var statearr_15365_15380 = state_15345;
(statearr_15365_15380[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_15345[(4)]))){
var statearr_15366_15381 = state_15345;
(statearr_15366_15381[(1)] = cljs.core.first((state_15345[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__15382 = state_15345;
state_15345 = G__15382;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$state_machine__13494__auto__ = function(state_15345){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13494__auto____1.call(this,state_15345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13494__auto____0;
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13494__auto____1;
return cljs$core$async$state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_15367 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_15367[(6)] = c__13568__auto___15369);

return statearr_15367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__15384 = arguments.length;
switch (G__15384) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13568__auto___15451 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_15422){
var state_val_15423 = (state_15422[(1)]);
if((state_val_15423 === (7))){
var inst_15418 = (state_15422[(2)]);
var state_15422__$1 = state_15422;
var statearr_15424_15452 = state_15422__$1;
(statearr_15424_15452[(2)] = inst_15418);

(statearr_15424_15452[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15423 === (1))){
var inst_15385 = (new Array(n));
var inst_15386 = inst_15385;
var inst_15387 = (0);
var state_15422__$1 = (function (){var statearr_15425 = state_15422;
(statearr_15425[(7)] = inst_15386);

(statearr_15425[(8)] = inst_15387);

return statearr_15425;
})();
var statearr_15426_15453 = state_15422__$1;
(statearr_15426_15453[(2)] = null);

(statearr_15426_15453[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15423 === (4))){
var inst_15390 = (state_15422[(9)]);
var inst_15390__$1 = (state_15422[(2)]);
var inst_15391 = (inst_15390__$1 == null);
var inst_15392 = cljs.core.not(inst_15391);
var state_15422__$1 = (function (){var statearr_15427 = state_15422;
(statearr_15427[(9)] = inst_15390__$1);

return statearr_15427;
})();
if(inst_15392){
var statearr_15428_15454 = state_15422__$1;
(statearr_15428_15454[(1)] = (5));

} else {
var statearr_15429_15455 = state_15422__$1;
(statearr_15429_15455[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15423 === (15))){
var inst_15412 = (state_15422[(2)]);
var state_15422__$1 = state_15422;
var statearr_15430_15456 = state_15422__$1;
(statearr_15430_15456[(2)] = inst_15412);

(statearr_15430_15456[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15423 === (13))){
var state_15422__$1 = state_15422;
var statearr_15431_15457 = state_15422__$1;
(statearr_15431_15457[(2)] = null);

(statearr_15431_15457[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15423 === (6))){
var inst_15387 = (state_15422[(8)]);
var inst_15408 = (inst_15387 > (0));
var state_15422__$1 = state_15422;
if(cljs.core.truth_(inst_15408)){
var statearr_15432_15458 = state_15422__$1;
(statearr_15432_15458[(1)] = (12));

} else {
var statearr_15433_15459 = state_15422__$1;
(statearr_15433_15459[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15423 === (3))){
var inst_15420 = (state_15422[(2)]);
var state_15422__$1 = state_15422;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15422__$1,inst_15420);
} else {
if((state_val_15423 === (12))){
var inst_15386 = (state_15422[(7)]);
var inst_15410 = cljs.core.vec(inst_15386);
var state_15422__$1 = state_15422;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15422__$1,(15),out,inst_15410);
} else {
if((state_val_15423 === (2))){
var state_15422__$1 = state_15422;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15422__$1,(4),ch);
} else {
if((state_val_15423 === (11))){
var inst_15402 = (state_15422[(2)]);
var inst_15403 = (new Array(n));
var inst_15386 = inst_15403;
var inst_15387 = (0);
var state_15422__$1 = (function (){var statearr_15434 = state_15422;
(statearr_15434[(7)] = inst_15386);

(statearr_15434[(8)] = inst_15387);

(statearr_15434[(10)] = inst_15402);

return statearr_15434;
})();
var statearr_15435_15460 = state_15422__$1;
(statearr_15435_15460[(2)] = null);

(statearr_15435_15460[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15423 === (9))){
var inst_15386 = (state_15422[(7)]);
var inst_15400 = cljs.core.vec(inst_15386);
var state_15422__$1 = state_15422;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15422__$1,(11),out,inst_15400);
} else {
if((state_val_15423 === (5))){
var inst_15386 = (state_15422[(7)]);
var inst_15395 = (state_15422[(11)]);
var inst_15387 = (state_15422[(8)]);
var inst_15390 = (state_15422[(9)]);
var inst_15394 = (inst_15386[inst_15387] = inst_15390);
var inst_15395__$1 = (inst_15387 + (1));
var inst_15396 = (inst_15395__$1 < n);
var state_15422__$1 = (function (){var statearr_15436 = state_15422;
(statearr_15436[(12)] = inst_15394);

(statearr_15436[(11)] = inst_15395__$1);

return statearr_15436;
})();
if(cljs.core.truth_(inst_15396)){
var statearr_15437_15461 = state_15422__$1;
(statearr_15437_15461[(1)] = (8));

} else {
var statearr_15438_15462 = state_15422__$1;
(statearr_15438_15462[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15423 === (14))){
var inst_15415 = (state_15422[(2)]);
var inst_15416 = cljs.core.async.close_BANG_(out);
var state_15422__$1 = (function (){var statearr_15440 = state_15422;
(statearr_15440[(13)] = inst_15415);

return statearr_15440;
})();
var statearr_15441_15463 = state_15422__$1;
(statearr_15441_15463[(2)] = inst_15416);

(statearr_15441_15463[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15423 === (10))){
var inst_15406 = (state_15422[(2)]);
var state_15422__$1 = state_15422;
var statearr_15442_15464 = state_15422__$1;
(statearr_15442_15464[(2)] = inst_15406);

(statearr_15442_15464[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15423 === (8))){
var inst_15386 = (state_15422[(7)]);
var inst_15395 = (state_15422[(11)]);
var tmp15439 = inst_15386;
var inst_15386__$1 = tmp15439;
var inst_15387 = inst_15395;
var state_15422__$1 = (function (){var statearr_15443 = state_15422;
(statearr_15443[(7)] = inst_15386__$1);

(statearr_15443[(8)] = inst_15387);

return statearr_15443;
})();
var statearr_15444_15465 = state_15422__$1;
(statearr_15444_15465[(2)] = null);

(statearr_15444_15465[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13494__auto__ = null;
var cljs$core$async$state_machine__13494__auto____0 = (function (){
var statearr_15445 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15445[(0)] = cljs$core$async$state_machine__13494__auto__);

(statearr_15445[(1)] = (1));

return statearr_15445;
});
var cljs$core$async$state_machine__13494__auto____1 = (function (state_15422){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_15422);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e15446){var ex__13497__auto__ = e15446;
var statearr_15447_15466 = state_15422;
(statearr_15447_15466[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_15422[(4)]))){
var statearr_15448_15467 = state_15422;
(statearr_15448_15467[(1)] = cljs.core.first((state_15422[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__15468 = state_15422;
state_15422 = G__15468;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$state_machine__13494__auto__ = function(state_15422){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13494__auto____1.call(this,state_15422);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13494__auto____0;
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13494__auto____1;
return cljs$core$async$state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_15449 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_15449[(6)] = c__13568__auto___15451);

return statearr_15449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__15470 = arguments.length;
switch (G__15470) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13568__auto___15541 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13569__auto__ = (function (){var switch__13493__auto__ = (function (state_15512){
var state_val_15513 = (state_15512[(1)]);
if((state_val_15513 === (7))){
var inst_15508 = (state_15512[(2)]);
var state_15512__$1 = state_15512;
var statearr_15514_15542 = state_15512__$1;
(statearr_15514_15542[(2)] = inst_15508);

(statearr_15514_15542[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15513 === (1))){
var inst_15471 = [];
var inst_15472 = inst_15471;
var inst_15473 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_15512__$1 = (function (){var statearr_15515 = state_15512;
(statearr_15515[(7)] = inst_15473);

(statearr_15515[(8)] = inst_15472);

return statearr_15515;
})();
var statearr_15516_15543 = state_15512__$1;
(statearr_15516_15543[(2)] = null);

(statearr_15516_15543[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15513 === (4))){
var inst_15476 = (state_15512[(9)]);
var inst_15476__$1 = (state_15512[(2)]);
var inst_15477 = (inst_15476__$1 == null);
var inst_15478 = cljs.core.not(inst_15477);
var state_15512__$1 = (function (){var statearr_15517 = state_15512;
(statearr_15517[(9)] = inst_15476__$1);

return statearr_15517;
})();
if(inst_15478){
var statearr_15518_15544 = state_15512__$1;
(statearr_15518_15544[(1)] = (5));

} else {
var statearr_15519_15545 = state_15512__$1;
(statearr_15519_15545[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15513 === (15))){
var inst_15502 = (state_15512[(2)]);
var state_15512__$1 = state_15512;
var statearr_15520_15546 = state_15512__$1;
(statearr_15520_15546[(2)] = inst_15502);

(statearr_15520_15546[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15513 === (13))){
var state_15512__$1 = state_15512;
var statearr_15521_15547 = state_15512__$1;
(statearr_15521_15547[(2)] = null);

(statearr_15521_15547[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15513 === (6))){
var inst_15472 = (state_15512[(8)]);
var inst_15497 = inst_15472.length;
var inst_15498 = (inst_15497 > (0));
var state_15512__$1 = state_15512;
if(cljs.core.truth_(inst_15498)){
var statearr_15522_15548 = state_15512__$1;
(statearr_15522_15548[(1)] = (12));

} else {
var statearr_15523_15549 = state_15512__$1;
(statearr_15523_15549[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15513 === (3))){
var inst_15510 = (state_15512[(2)]);
var state_15512__$1 = state_15512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15512__$1,inst_15510);
} else {
if((state_val_15513 === (12))){
var inst_15472 = (state_15512[(8)]);
var inst_15500 = cljs.core.vec(inst_15472);
var state_15512__$1 = state_15512;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15512__$1,(15),out,inst_15500);
} else {
if((state_val_15513 === (2))){
var state_15512__$1 = state_15512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15512__$1,(4),ch);
} else {
if((state_val_15513 === (11))){
var inst_15480 = (state_15512[(10)]);
var inst_15476 = (state_15512[(9)]);
var inst_15490 = (state_15512[(2)]);
var inst_15491 = [];
var inst_15492 = inst_15491.push(inst_15476);
var inst_15472 = inst_15491;
var inst_15473 = inst_15480;
var state_15512__$1 = (function (){var statearr_15524 = state_15512;
(statearr_15524[(7)] = inst_15473);

(statearr_15524[(8)] = inst_15472);

(statearr_15524[(11)] = inst_15492);

(statearr_15524[(12)] = inst_15490);

return statearr_15524;
})();
var statearr_15525_15550 = state_15512__$1;
(statearr_15525_15550[(2)] = null);

(statearr_15525_15550[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15513 === (9))){
var inst_15472 = (state_15512[(8)]);
var inst_15488 = cljs.core.vec(inst_15472);
var state_15512__$1 = state_15512;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15512__$1,(11),out,inst_15488);
} else {
if((state_val_15513 === (5))){
var inst_15473 = (state_15512[(7)]);
var inst_15480 = (state_15512[(10)]);
var inst_15476 = (state_15512[(9)]);
var inst_15480__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_15476) : f.call(null,inst_15476));
var inst_15481 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15480__$1,inst_15473);
var inst_15482 = cljs.core.keyword_identical_QMARK_(inst_15473,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_15483 = ((inst_15481) || (inst_15482));
var state_15512__$1 = (function (){var statearr_15526 = state_15512;
(statearr_15526[(10)] = inst_15480__$1);

return statearr_15526;
})();
if(cljs.core.truth_(inst_15483)){
var statearr_15527_15551 = state_15512__$1;
(statearr_15527_15551[(1)] = (8));

} else {
var statearr_15528_15552 = state_15512__$1;
(statearr_15528_15552[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15513 === (14))){
var inst_15505 = (state_15512[(2)]);
var inst_15506 = cljs.core.async.close_BANG_(out);
var state_15512__$1 = (function (){var statearr_15530 = state_15512;
(statearr_15530[(13)] = inst_15505);

return statearr_15530;
})();
var statearr_15531_15553 = state_15512__$1;
(statearr_15531_15553[(2)] = inst_15506);

(statearr_15531_15553[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15513 === (10))){
var inst_15495 = (state_15512[(2)]);
var state_15512__$1 = state_15512;
var statearr_15532_15554 = state_15512__$1;
(statearr_15532_15554[(2)] = inst_15495);

(statearr_15532_15554[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15513 === (8))){
var inst_15480 = (state_15512[(10)]);
var inst_15476 = (state_15512[(9)]);
var inst_15472 = (state_15512[(8)]);
var inst_15485 = inst_15472.push(inst_15476);
var tmp15529 = inst_15472;
var inst_15472__$1 = tmp15529;
var inst_15473 = inst_15480;
var state_15512__$1 = (function (){var statearr_15533 = state_15512;
(statearr_15533[(7)] = inst_15473);

(statearr_15533[(14)] = inst_15485);

(statearr_15533[(8)] = inst_15472__$1);

return statearr_15533;
})();
var statearr_15534_15555 = state_15512__$1;
(statearr_15534_15555[(2)] = null);

(statearr_15534_15555[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13494__auto__ = null;
var cljs$core$async$state_machine__13494__auto____0 = (function (){
var statearr_15535 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15535[(0)] = cljs$core$async$state_machine__13494__auto__);

(statearr_15535[(1)] = (1));

return statearr_15535;
});
var cljs$core$async$state_machine__13494__auto____1 = (function (state_15512){
while(true){
var ret_value__13495__auto__ = (function (){try{while(true){
var result__13496__auto__ = switch__13493__auto__(state_15512);
if(cljs.core.keyword_identical_QMARK_(result__13496__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13496__auto__;
}
break;
}
}catch (e15536){var ex__13497__auto__ = e15536;
var statearr_15537_15556 = state_15512;
(statearr_15537_15556[(2)] = ex__13497__auto__);


if(cljs.core.seq((state_15512[(4)]))){
var statearr_15538_15557 = state_15512;
(statearr_15538_15557[(1)] = cljs.core.first((state_15512[(4)])));

} else {
throw ex__13497__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13495__auto__,cljs.core.cst$kw$recur)){
var G__15558 = state_15512;
state_15512 = G__15558;
continue;
} else {
return ret_value__13495__auto__;
}
break;
}
});
cljs$core$async$state_machine__13494__auto__ = function(state_15512){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13494__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13494__auto____1.call(this,state_15512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13494__auto____0;
cljs$core$async$state_machine__13494__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13494__auto____1;
return cljs$core$async$state_machine__13494__auto__;
})()
})();
var state__13570__auto__ = (function (){var statearr_15539 = (f__13569__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13569__auto__.cljs$core$IFn$_invoke$arity$0() : f__13569__auto__.call(null));
(statearr_15539[(6)] = c__13568__auto___15541);

return statearr_15539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13570__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

