// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.sql.template');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('clojure.walk');
/**
 * Formats `s` by removing any '/' and capitalizing the following character for
 *   each '/' removed
 */
fluree.db.query.sql.template.normalize = (function fluree$db$query$sql$template$normalize(s){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (norm,nxt){
var cap = clojure.string.capitalize(nxt);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(norm),cap].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/\//));
});
/**
 * Formats `s` as a var by prepending '?', filtering out '/', and lowerCamelCasing
 *   the remaining string
 */
fluree.db.query.sql.template.build_var = (function fluree$db$query$sql$template$build_var(s){
return ["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.query.sql.template.normalize(s))].join('');
});
/**
 * Formats the collection string `c` and the field string `f` by joining them
 *   with a '/'
 */
fluree.db.query.sql.template.build_predicate = (function fluree$db$query$sql$template$build_predicate(c,f){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(c),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f)].join('');
});
/**
 * Returns true if `s` is a predicate string
 */
fluree.db.query.sql.template.predicate_QMARK_ = (function fluree$db$query$sql$template$predicate_QMARK_(s){
var and__4115__auto__ = s;
if(cljs.core.truth_(and__4115__auto__)){
return clojure.string.includes_QMARK_(s,"/");
} else {
return and__4115__auto__;
}
});
/**
 * Formats `terms` as a function call
 */
fluree.db.query.sql.template.build_fn_call = (function fluree$db$query$sql$template$build_fn_call(terms){
return ["(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",terms),")"].join('');
});
fluree.db.query.sql.template.template_for = (function fluree$db$query$sql$template$template_for(kw){
return ["@<",cljs.core.str.cljs$core$IFn$_invoke$arity$1(kw),">"].join('');
});
fluree.db.query.sql.template.fill_in = (function fluree$db$query$sql$template$fill_in(tmpl_str,tmpl,v){
return clojure.string.replace(tmpl_str,tmpl,v);
});
/**
 * Template for representing flake collections
 */
fluree.db.query.sql.template.collection = fluree.db.query.sql.template.template_for(cljs.core.cst$kw$collection);
/**
 * Template for storing flake subjects as variables
 */
fluree.db.query.sql.template.collection_var = fluree.db.query.sql.template.build_var(fluree.db.query.sql.template.collection);
/**
 * Fills in the known collection name `coll-name` wherever the collection template
 *   appears in `tmpl-str`
 */
fluree.db.query.sql.template.fill_in_collection = (function fluree$db$query$sql$template$fill_in_collection(coll_name,tmpl_data){
return clojure.walk.postwalk((function (c){
if(typeof c === 'string'){
return fluree.db.query.sql.template.fill_in(c,fluree.db.query.sql.template.collection,coll_name);
} else {
return c;
}
}),tmpl_data);
});
/**
 * Template for represent collection fields
 */
fluree.db.query.sql.template.field = fluree.db.query.sql.template.template_for(cljs.core.cst$kw$field);
/**
 * Template for storing flake fields as variables
 */
fluree.db.query.sql.template.field_var = fluree.db.query.sql.template.build_var(fluree.db.query.sql.template.field);
/**
 * Build a flake predicate template string from the collection template and the
 *   known field value `f`
 */
fluree.db.query.sql.template.field__GT_predicate_template = (function fluree$db$query$sql$template$field__GT_predicate_template(f){
return fluree.db.query.sql.template.build_predicate(fluree.db.query.sql.template.collection,f);
});
/**
 * Template for representing flake predicates with both collection and field
 *   missing
 */
fluree.db.query.sql.template.predicate = fluree.db.query.sql.template.build_predicate(fluree.db.query.sql.template.collection,fluree.db.query.sql.template.field);
