// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_26466){
var state_val_26467 = (state_26466[(1)]);
if((state_val_26467 === (7))){
var inst_26461 = (state_26466[(2)]);
var _ = (function (){var statearr_26468 = state_26466;
(statearr_26468[(4)] = cljs.core.rest((state_26466[(4)])));

return statearr_26468;
})();
var state_26466__$1 = state_26466;
var statearr_26469_26491 = state_26466__$1;
(statearr_26469_26491[(2)] = inst_26461);

(statearr_26469_26491[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26467 === (1))){
var state_26466__$1 = state_26466;
var statearr_26470_26492 = state_26466__$1;
(statearr_26470_26492[(2)] = null);

(statearr_26470_26492[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26467 === (4))){
var inst_26423 = (state_26466[(2)]);
var state_26466__$1 = state_26466;
var statearr_26471_26493 = state_26466__$1;
(statearr_26471_26493[(2)] = inst_26423);

(statearr_26471_26493[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26467 === (6))){
var inst_26441 = (state_26466[(7)]);
var inst_26448 = (state_26466[(8)]);
var inst_26447 = cljs.core.seq(inst_26441);
var inst_26448__$1 = cljs.core.first(inst_26447);
var inst_26449 = cljs.core.next(inst_26447);
var inst_26450 = cljs.core.not(inst_26448__$1);
var state_26466__$1 = (function (){var statearr_26472 = state_26466;
(statearr_26472[(9)] = inst_26449);

(statearr_26472[(8)] = inst_26448__$1);

return statearr_26472;
})();
if(inst_26450){
var statearr_26473_26494 = state_26466__$1;
(statearr_26473_26494[(1)] = (8));

} else {
var statearr_26474_26495 = state_26466__$1;
(statearr_26474_26495[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26467 === (3))){
var inst_26464 = (state_26466[(2)]);
var state_26466__$1 = state_26466;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26466__$1,inst_26464);
} else {
if((state_val_26467 === (2))){
var _ = (function (){var statearr_26475 = state_26466;
(statearr_26475[(4)] = cljs.core.cons((5),(state_26466[(4)])));

return statearr_26475;
})();
var inst_26436 = chs;
var inst_26437 = cljs.core.seq(inst_26436);
var inst_26438 = cljs.core.first(inst_26437);
var inst_26439 = cljs.core.next(inst_26437);
var inst_26440 = coll;
var inst_26441 = inst_26436;
var inst_26442 = inst_26440;
var state_26466__$1 = (function (){var statearr_26476 = state_26466;
(statearr_26476[(7)] = inst_26441);

(statearr_26476[(10)] = inst_26438);

(statearr_26476[(11)] = inst_26442);

(statearr_26476[(12)] = inst_26439);

return statearr_26476;
})();
var statearr_26477_26496 = state_26466__$1;
(statearr_26477_26496[(2)] = null);

(statearr_26477_26496[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26467 === (11))){
var inst_26442 = (state_26466[(11)]);
var inst_26449 = (state_26466[(9)]);
var inst_26454 = (state_26466[(2)]);
var inst_26455 = fluree.db.util.async.throw_err(inst_26454);
var inst_26456 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26442,inst_26455);
var inst_26441 = inst_26449;
var inst_26442__$1 = inst_26456;
var state_26466__$1 = (function (){var statearr_26479 = state_26466;
(statearr_26479[(7)] = inst_26441);

(statearr_26479[(11)] = inst_26442__$1);

return statearr_26479;
})();
var statearr_26480_26497 = state_26466__$1;
(statearr_26480_26497[(2)] = null);

(statearr_26480_26497[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26467 === (9))){
var inst_26448 = (state_26466[(8)]);
var state_26466__$1 = state_26466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26466__$1,(11),inst_26448);
} else {
if((state_val_26467 === (5))){
var _ = (function (){var statearr_26481 = state_26466;
(statearr_26481[(4)] = cljs.core.rest((state_26466[(4)])));

return statearr_26481;
})();
var state_26466__$1 = state_26466;
var ex26478 = (state_26466__$1[(2)]);
var statearr_26482_26498 = state_26466__$1;
(statearr_26482_26498[(5)] = ex26478);


var statearr_26483_26499 = state_26466__$1;
(statearr_26483_26499[(1)] = (4));

(statearr_26483_26499[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_26467 === (10))){
var inst_26459 = (state_26466[(2)]);
var state_26466__$1 = state_26466;
var statearr_26484_26500 = state_26466__$1;
(statearr_26484_26500[(2)] = inst_26459);

(statearr_26484_26500[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26467 === (8))){
var inst_26442 = (state_26466[(11)]);
var state_26466__$1 = state_26466;
var statearr_26485_26501 = state_26466__$1;
(statearr_26485_26501[(2)] = inst_26442);

(statearr_26485_26501[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16291__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16291__auto____0 = (function (){
var statearr_26486 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26486[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__16291__auto__);

(statearr_26486[(1)] = (1));

return statearr_26486;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16291__auto____1 = (function (state_26466){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_26466);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e26487){var ex__16294__auto__ = e26487;
var statearr_26488_26502 = state_26466;
(statearr_26488_26502[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_26466[(4)]))){
var statearr_26489_26503 = state_26466;
(statearr_26489_26503[(1)] = cljs.core.first((state_26466[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__26504 = state_26466;
state_26466 = G__26504;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__16291__auto__ = function(state_26466){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16291__auto____1.call(this,state_26466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__16291__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__16291__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_26490 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_26490[(6)] = c__16328__auto__);

return statearr_26490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_26530){
var state_val_26531 = (state_26530[(1)]);
if((state_val_26531 === (7))){
var inst_26525 = (state_26530[(2)]);
var _ = (function (){var statearr_26532 = state_26530;
(statearr_26532[(4)] = cljs.core.rest((state_26530[(4)])));

return statearr_26532;
})();
var state_26530__$1 = state_26530;
var statearr_26533_26555 = state_26530__$1;
(statearr_26533_26555[(2)] = inst_26525);

(statearr_26533_26555[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26531 === (1))){
var state_26530__$1 = state_26530;
var statearr_26534_26556 = state_26530__$1;
(statearr_26534_26556[(2)] = null);

(statearr_26534_26556[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26531 === (4))){
var inst_26505 = (state_26530[(2)]);
var state_26530__$1 = state_26530;
var statearr_26535_26557 = state_26530__$1;
(statearr_26535_26557[(2)] = inst_26505);

(statearr_26535_26557[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26531 === (6))){
var state_26530__$1 = state_26530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26530__$1,(8),chan);
} else {
if((state_val_26531 === (3))){
var inst_26528 = (state_26530[(2)]);
var state_26530__$1 = state_26530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26530__$1,inst_26528);
} else {
if((state_val_26531 === (2))){
var _ = (function (){var statearr_26536 = state_26530;
(statearr_26536[(4)] = cljs.core.cons((5),(state_26530[(4)])));

return statearr_26536;
})();
var inst_26511 = coll;
var inst_26512 = inst_26511;
var state_26530__$1 = (function (){var statearr_26537 = state_26530;
(statearr_26537[(7)] = inst_26512);

return statearr_26537;
})();
var statearr_26538_26558 = state_26530__$1;
(statearr_26538_26558[(2)] = null);

(statearr_26538_26558[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26531 === (11))){
var inst_26523 = (state_26530[(2)]);
var state_26530__$1 = state_26530;
var statearr_26540_26559 = state_26530__$1;
(statearr_26540_26559[(2)] = inst_26523);

(statearr_26540_26559[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26531 === (9))){
var inst_26512 = (state_26530[(7)]);
var state_26530__$1 = state_26530;
var statearr_26541_26560 = state_26530__$1;
(statearr_26541_26560[(2)] = inst_26512);

(statearr_26541_26560[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26531 === (5))){
var _ = (function (){var statearr_26542 = state_26530;
(statearr_26542[(4)] = cljs.core.rest((state_26530[(4)])));

return statearr_26542;
})();
var state_26530__$1 = state_26530;
var ex26539 = (state_26530__$1[(2)]);
var statearr_26543_26561 = state_26530__$1;
(statearr_26543_26561[(5)] = ex26539);


var statearr_26544_26562 = state_26530__$1;
(statearr_26544_26562[(1)] = (4));

(statearr_26544_26562[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_26531 === (10))){
var inst_26512 = (state_26530[(7)]);
var inst_26516 = (state_26530[(8)]);
var inst_26520 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26512,inst_26516);
var inst_26512__$1 = inst_26520;
var state_26530__$1 = (function (){var statearr_26545 = state_26530;
(statearr_26545[(7)] = inst_26512__$1);

return statearr_26545;
})();
var statearr_26546_26563 = state_26530__$1;
(statearr_26546_26563[(2)] = null);

(statearr_26546_26563[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26531 === (8))){
var inst_26516 = (state_26530[(8)]);
var inst_26515 = (state_26530[(2)]);
var inst_26516__$1 = fluree.db.util.async.throw_err(inst_26515);
var inst_26517 = (inst_26516__$1 == null);
var state_26530__$1 = (function (){var statearr_26547 = state_26530;
(statearr_26547[(8)] = inst_26516__$1);

return statearr_26547;
})();
if(cljs.core.truth_(inst_26517)){
var statearr_26548_26564 = state_26530__$1;
(statearr_26548_26564[(1)] = (9));

} else {
var statearr_26549_26565 = state_26530__$1;
(statearr_26549_26565[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__16291__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__16291__auto____0 = (function (){
var statearr_26550 = [null,null,null,null,null,null,null,null,null];
(statearr_26550[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__16291__auto__);

(statearr_26550[(1)] = (1));

return statearr_26550;
});
var fluree$db$util$async$into_QMARK__$_state_machine__16291__auto____1 = (function (state_26530){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_26530);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e26551){var ex__16294__auto__ = e26551;
var statearr_26552_26566 = state_26530;
(statearr_26552_26566[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_26530[(4)]))){
var statearr_26553_26567 = state_26530;
(statearr_26553_26567[(1)] = cljs.core.first((state_26530[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__26568 = state_26530;
state_26530 = G__26568;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__16291__auto__ = function(state_26530){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__16291__auto____1.call(this,state_26530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__16291__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__16291__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_26554 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_26554[(6)] = c__16328__auto__);

return statearr_26554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
