// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__34355 = cljs.core._EQ_;
var expr__34356 = e.getLastErrorCode();
if(cljs.core.truth_((pred__34355.cljs$core$IFn$_invoke$arity$2 ? pred__34355.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__34356) : pred__34355.call(null,goog.net.ErrorCode.NO_ERROR,expr__34356)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__34355.cljs$core$IFn$_invoke$arity$2 ? pred__34355.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__34356) : pred__34355.call(null,goog.net.ErrorCode.EXCEPTION,expr__34356)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__34355.cljs$core$IFn$_invoke$arity$2 ? pred__34355.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__34356) : pred__34355.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__34356)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__34355.cljs$core$IFn$_invoke$arity$2 ? pred__34355.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__34356) : pred__34355.call(null,goog.net.ErrorCode.ABORT,expr__34356)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__34355.cljs$core$IFn$_invoke$arity$2 ? pred__34355.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__34356) : pred__34355.call(null,goog.net.ErrorCode.TIMEOUT,expr__34356)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__34358 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34358,cljs.core.cst$kw$status,status);
} else {
return G__34358;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__34359 = opts;
var map__34359__$1 = (((((!((map__34359 == null))))?(((((map__34359.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34359.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34359):map__34359);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34359__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34359__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34359__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__34361 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__34361__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__34361,headers], 0)):G__34361);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34361__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__34361__$1;
}
})();
try{var G__34363_34369 = url;
var G__34364_34370 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__34365_34371 = "POST";
var G__34366_34372 = fluree.db.util.json.stringify(message);
var G__34367_34373 = cljs.core.clj__GT_js(headers__$1);
var G__34368_34374 = request_timeout;
goog.net.XhrIo.send(G__34363_34369,G__34364_34370,G__34365_34371,G__34366_34372,G__34367_34373,G__34368_34374);
}catch (e34362){var e_34375 = e34362;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_34375);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__34376 = opts;
var map__34376__$1 = (((((!((map__34376 == null))))?(((((map__34376.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34376.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34376):map__34376);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34376__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34376__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34376__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34376__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34376__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__34378 = cljs.core.PersistentArrayMap.EMPTY;
var G__34378__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__34378,headers], 0)):G__34378);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34378__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__34378__$1;
}
})();
try{var G__34380_34387 = url;
var G__34381_34388 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__34386 = output_format;
var G__34386__$1 = (((G__34386 instanceof cljs.core.Keyword))?G__34386.fqn:null);
switch (G__34386__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__34382_34389 = "GET";
var G__34383_34390 = body;
var G__34384_34391 = cljs.core.clj__GT_js(headers__$1);
var G__34385_34392 = request_timeout;
goog.net.XhrIo.send(G__34380_34387,G__34381_34388,G__34382_34389,G__34383_34390,G__34384_34391,G__34385_34392);
}catch (e34379){var e_34394 = e34379;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_34394);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__34395 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34395,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__34395;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_34428){
var state_val_34429 = (state_34428[(1)]);
if((state_val_34429 === (7))){
var inst_34424 = (state_34428[(2)]);
var state_34428__$1 = state_34428;
var statearr_34430_34455 = state_34428__$1;
(statearr_34430_34455[(2)] = inst_34424);

(statearr_34430_34455[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34429 === (1))){
var state_34428__$1 = state_34428;
var statearr_34431_34456 = state_34428__$1;
(statearr_34431_34456[(2)] = null);

(statearr_34431_34456[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34429 === (4))){
var inst_34399 = (state_34428[(7)]);
var inst_34399__$1 = (state_34428[(2)]);
var inst_34400 = (inst_34399__$1 == null);
var state_34428__$1 = (function (){var statearr_34432 = state_34428;
(statearr_34432[(7)] = inst_34399__$1);

return statearr_34432;
})();
if(cljs.core.truth_(inst_34400)){
var statearr_34433_34457 = state_34428__$1;
(statearr_34433_34457[(1)] = (5));

} else {
var statearr_34434_34458 = state_34428__$1;
(statearr_34434_34458[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34429 === (6))){
var inst_34399 = (state_34428[(7)]);
var inst_34407 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34399,(0),null);
var inst_34408 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34399,(1),null);
var state_34428__$1 = (function (){var statearr_34435 = state_34428;
(statearr_34435[(8)] = inst_34407);

(statearr_34435[(9)] = inst_34408);

return statearr_34435;
})();
var statearr_34436_34459 = state_34428__$1;
(statearr_34436_34459[(2)] = null);

(statearr_34436_34459[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34429 === (3))){
var inst_34426 = (state_34428[(2)]);
var state_34428__$1 = state_34428;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34428__$1,inst_34426);
} else {
if((state_val_34429 === (2))){
var state_34428__$1 = state_34428;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34428__$1,(4),pub_chan);
} else {
if((state_val_34429 === (11))){
var _ = (function (){var statearr_34438 = state_34428;
(statearr_34438[(4)] = cljs.core.rest((state_34428[(4)])));

return statearr_34438;
})();
var state_34428__$1 = state_34428;
var ex34437 = (state_34428__$1[(2)]);
var statearr_34439_34460 = state_34428__$1;
(statearr_34439_34460[(5)] = ex34437);


if((ex34437 instanceof Error)){
var statearr_34440_34461 = state_34428__$1;
(statearr_34440_34461[(1)] = (10));

(statearr_34440_34461[(5)] = null);

} else {
throw ex34437;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34429 === (9))){
var inst_34421 = (state_34428[(2)]);
var state_34428__$1 = (function (){var statearr_34441 = state_34428;
(statearr_34441[(10)] = inst_34421);

return statearr_34441;
})();
var statearr_34442_34462 = state_34428__$1;
(statearr_34442_34462[(2)] = null);

(statearr_34442_34462[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34429 === (5))){
var inst_34402 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_34428__$1 = state_34428;
var statearr_34443_34463 = state_34428__$1;
(statearr_34443_34463[(2)] = inst_34402);

(statearr_34443_34463[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34429 === (10))){
var inst_34408 = (state_34428[(9)]);
var inst_34409 = (state_34428[(2)]);
var inst_34410 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_34409,"Websocket send message error:",inst_34409], 0));
var inst_34411 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_34408,false);
var state_34428__$1 = (function (){var statearr_34444 = state_34428;
(statearr_34444[(11)] = inst_34410);

return statearr_34444;
})();
var statearr_34445_34464 = state_34428__$1;
(statearr_34445_34464[(2)] = inst_34411);

(statearr_34445_34464[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34429 === (8))){
var inst_34407 = (state_34428[(8)]);
var inst_34408 = (state_34428[(9)]);
var _ = (function (){var statearr_34446 = state_34428;
(statearr_34446[(4)] = cljs.core.cons((11),(state_34428[(4)])));

return statearr_34446;
})();
var inst_34417 = ws.send(inst_34407);
var inst_34418 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_34408,true);
var ___$1 = (function (){var statearr_34447 = state_34428;
(statearr_34447[(4)] = cljs.core.rest((state_34428[(4)])));

return statearr_34447;
})();
var state_34428__$1 = (function (){var statearr_34448 = state_34428;
(statearr_34448[(12)] = inst_34417);

return statearr_34448;
})();
var statearr_34449_34465 = state_34428__$1;
(statearr_34449_34465[(2)] = inst_34418);

(statearr_34449_34465[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16291__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16291__auto____0 = (function (){
var statearr_34450 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34450[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16291__auto__);

(statearr_34450[(1)] = (1));

return statearr_34450;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16291__auto____1 = (function (state_34428){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_34428);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e34451){var ex__16294__auto__ = e34451;
var statearr_34452_34466 = state_34428;
(statearr_34452_34466[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_34428[(4)]))){
var statearr_34453_34467 = state_34428;
(statearr_34453_34467[(1)] = cljs.core.first((state_34428[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__34468 = state_34428;
state_34428 = G__34468;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16291__auto__ = function(state_34428){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16291__auto____1.call(this,state_34428);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16291__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16291__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_34454 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_34454[(6)] = c__16328__auto__);

return statearr_34454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__16328__auto___34507 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_34494){
var state_val_34495 = (state_34494[(1)]);
if((state_val_34495 === (1))){
var inst_34473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34474 = [open_QMARK_,timeout_chan];
var inst_34475 = (new cljs.core.PersistentVector(null,2,(5),inst_34473,inst_34474,null));
var state_34494__$1 = state_34494;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_34494__$1,(2),inst_34475,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_34495 === (2))){
var inst_34477 = (state_34494[(2)]);
var inst_34478 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34477,(0),null);
var inst_34479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34477,(1),null);
var inst_34480 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34479,timeout_chan);
var state_34494__$1 = (function (){var statearr_34496 = state_34494;
(statearr_34496[(7)] = inst_34478);

return statearr_34496;
})();
if(inst_34480){
var statearr_34497_34508 = state_34494__$1;
(statearr_34497_34508[(1)] = (3));

} else {
var statearr_34498_34509 = state_34494__$1;
(statearr_34498_34509[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34495 === (3))){
var inst_34482 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_34483 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34484 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_34485 = cljs.core.PersistentHashMap.fromArrays(inst_34483,inst_34484);
var inst_34486 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34482,inst_34485);
var inst_34487 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_34486);
var inst_34488 = fluree.db.util.xhttp.close_websocket(ws);
var state_34494__$1 = (function (){var statearr_34499 = state_34494;
(statearr_34499[(8)] = inst_34487);

return statearr_34499;
})();
var statearr_34500_34510 = state_34494__$1;
(statearr_34500_34510[(2)] = inst_34488);

(statearr_34500_34510[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34495 === (4))){
var inst_34490 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_34494__$1 = state_34494;
var statearr_34501_34511 = state_34494__$1;
(statearr_34501_34511[(2)] = inst_34490);

(statearr_34501_34511[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34495 === (5))){
var inst_34492 = (state_34494[(2)]);
var state_34494__$1 = state_34494;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34494__$1,inst_34492);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__16291__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__16291__auto____0 = (function (){
var statearr_34502 = [null,null,null,null,null,null,null,null,null];
(statearr_34502[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__16291__auto__);

(statearr_34502[(1)] = (1));

return statearr_34502;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__16291__auto____1 = (function (state_34494){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_34494);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e34503){var ex__16294__auto__ = e34503;
var statearr_34504_34512 = state_34494;
(statearr_34504_34512[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_34494[(4)]))){
var statearr_34505_34513 = state_34494;
(statearr_34505_34513[(1)] = cljs.core.first((state_34494[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__34514 = state_34494;
state_34494 = G__34514;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__16291__auto__ = function(state_34494){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__16291__auto____1.call(this,state_34494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__16291__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__16291__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_34506 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_34506[(6)] = c__16328__auto___34507);

return statearr_34506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
