// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__5937){
var vec__5938 = p__5937;
var i = cljs.core.nth.call(null,vec__5938,(0),null);
var v = cljs.core.nth.call(null,vec__5938,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__5941 = seg;
var gcol = cljs.core.nth.call(null,vec__5941,(0),null);
var source = cljs.core.nth.call(null,vec__5941,(1),null);
var line = cljs.core.nth.call(null,vec__5941,(2),null);
var col = cljs.core.nth.call(null,vec__5941,(3),null);
var name = cljs.core.nth.call(null,vec__5941,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__5944 = seg;
var gcol = cljs.core.nth.call(null,vec__5944,(0),null);
var source = cljs.core.nth.call(null,vec__5944,(1),null);
var line = cljs.core.nth.call(null,vec__5944,(2),null);
var col = cljs.core.nth.call(null,vec__5944,(3),null);
var name = cljs.core.nth.call(null,vec__5944,(4),null);
var vec__5947 = relseg;
var rgcol = cljs.core.nth.call(null,vec__5947,(0),null);
var rsource = cljs.core.nth.call(null,vec__5947,(1),null);
var rline = cljs.core.nth.call(null,vec__5947,(2),null);
var rcol = cljs.core.nth.call(null,vec__5947,(3),null);
var rname = cljs.core.nth.call(null,vec__5947,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4126__auto__ = source;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4126__auto__ = line;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4126__auto__ = col;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__5950 = segmap;
var map__5950__$1 = (((((!((map__5950 == null))))?(((((map__5950.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5950.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5950):map__5950);
var gcol = cljs.core.get.call(null,map__5950__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__5950__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__5950__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__5950__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__5950__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,(function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,(function (v){
return cljs.core.conj.call(null,v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__5953 = arguments.length;
switch (G__5953) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__5957 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__5961 = cljs.core.next.call(null,segs__$1);
var G__5962 = nrelseg;
var G__5963 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__5961;
relseg__$1 = G__5962;
result__$1 = G__5963;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__5957,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__5957,(1),null);
var G__5964 = (gline + (1));
var G__5965 = cljs.core.next.call(null,lines__$1);
var G__5966 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__5967 = result__$1;
gline = G__5964;
lines__$1 = G__5965;
relseg = G__5966;
result = G__5967;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__5969 = segmap;
var map__5969__$1 = (((((!((map__5969 == null))))?(((((map__5969.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5969.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5969):map__5969);
var gcol = cljs.core.get.call(null,map__5969__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__5969__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__5969__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__5969__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__5969__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,(function (p1__5968_SHARP_){
return cljs.core.conj.call(null,p1__5968_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__5972 = arguments.length;
switch (G__5972) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__5976 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__5980 = cljs.core.next.call(null,segs__$1);
var G__5981 = nrelseg;
var G__5982 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__5980;
relseg__$1 = G__5981;
result__$1 = G__5982;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__5976,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__5976,(1),null);
var G__5983 = (gline + (1));
var G__5984 = cljs.core.next.call(null,lines__$1);
var G__5985 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__5986 = result__$1;
gline = G__5983;
lines__$1 = G__5984;
relseg = G__5985;
result = G__5986;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,(function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,(function (p__5987){
var vec__5988 = p__5987;
var _ = cljs.core.nth.call(null,vec__5988,(0),null);
var source = cljs.core.nth.call(null,vec__5988,(1),null);
var line = cljs.core.nth.call(null,vec__5988,(2),null);
var col = cljs.core.nth.call(null,vec__5988,(3),null);
var name = cljs.core.nth.call(null,vec__5988,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,(function (cols__$1,p__5991){
var vec__5992 = p__5991;
var gcol = cljs.core.nth.call(null,vec__5992,(0),null);
var sidx = cljs.core.nth.call(null,vec__5992,(1),null);
var line = cljs.core.nth.call(null,vec__5992,(2),null);
var col = cljs.core.nth.call(null,vec__5992,(3),null);
var name = cljs.core.nth.call(null,vec__5992,(4),null);
var seg = vec__5992;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,(function (p__5995){
var vec__5996 = p__5995;
var _ = cljs.core.nth.call(null,vec__5996,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__5996,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__5996,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__5996,(3),null);
var lname = cljs.core.nth.call(null,vec__5996,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__6002 = cljs.core.seq.call(null,infos);
var chunk__6003 = null;
var count__6004 = (0);
var i__6005 = (0);
while(true){
if((i__6005 < count__6004)){
var info = cljs.core._nth.call(null,chunk__6003,i__6005);
var segv_6356 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_6357 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6358 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_6357 > (lc_6358 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__6002,chunk__6003,count__6004,i__6005,segv_6356,gline_6357,lc_6358,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_6357 - (lc_6358 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6356], null));
});})(seq__6002,chunk__6003,count__6004,i__6005,segv_6356,gline_6357,lc_6358,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__6002,chunk__6003,count__6004,i__6005,segv_6356,gline_6357,lc_6358,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6357], null),cljs.core.conj,segv_6356);
});})(seq__6002,chunk__6003,count__6004,i__6005,segv_6356,gline_6357,lc_6358,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6359 = seq__6002;
var G__6360 = chunk__6003;
var G__6361 = count__6004;
var G__6362 = (i__6005 + (1));
seq__6002 = G__6359;
chunk__6003 = G__6360;
count__6004 = G__6361;
i__6005 = G__6362;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__6002);
if(temp__5735__auto__){
var seq__6002__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6002__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__6002__$1);
var G__6363 = cljs.core.chunk_rest.call(null,seq__6002__$1);
var G__6364 = c__4556__auto__;
var G__6365 = cljs.core.count.call(null,c__4556__auto__);
var G__6366 = (0);
seq__6002 = G__6363;
chunk__6003 = G__6364;
count__6004 = G__6365;
i__6005 = G__6366;
continue;
} else {
var info = cljs.core.first.call(null,seq__6002__$1);
var segv_6367 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_6368 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6369 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_6368 > (lc_6369 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__6002,chunk__6003,count__6004,i__6005,segv_6367,gline_6368,lc_6369,info,seq__6002__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_6368 - (lc_6369 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6367], null));
});})(seq__6002,chunk__6003,count__6004,i__6005,segv_6367,gline_6368,lc_6369,info,seq__6002__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__6002,chunk__6003,count__6004,i__6005,segv_6367,gline_6368,lc_6369,info,seq__6002__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6368], null),cljs.core.conj,segv_6367);
});})(seq__6002,chunk__6003,count__6004,i__6005,segv_6367,gline_6368,lc_6369,info,seq__6002__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6370 = cljs.core.next.call(null,seq__6002__$1);
var G__6371 = null;
var G__6372 = (0);
var G__6373 = (0);
seq__6002 = G__6370;
chunk__6003 = G__6371;
count__6004 = G__6372;
i__6005 = G__6373;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__6006_6374 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__6007_6375 = null;
var count__6008_6376 = (0);
var i__6009_6377 = (0);
while(true){
if((i__6009_6377 < count__6008_6376)){
var vec__6182_6378 = cljs.core._nth.call(null,chunk__6007_6375,i__6009_6377);
var source_idx_6379 = cljs.core.nth.call(null,vec__6182_6378,(0),null);
var vec__6185_6380 = cljs.core.nth.call(null,vec__6182_6378,(1),null);
var __6381 = cljs.core.nth.call(null,vec__6185_6380,(0),null);
var lines_6382__$1 = cljs.core.nth.call(null,vec__6185_6380,(1),null);
var seq__6188_6383 = cljs.core.seq.call(null,lines_6382__$1);
var chunk__6189_6384 = null;
var count__6190_6385 = (0);
var i__6191_6386 = (0);
while(true){
if((i__6191_6386 < count__6190_6385)){
var vec__6230_6387 = cljs.core._nth.call(null,chunk__6189_6384,i__6191_6386);
var line_6388 = cljs.core.nth.call(null,vec__6230_6387,(0),null);
var cols_6389 = cljs.core.nth.call(null,vec__6230_6387,(1),null);
var seq__6233_6390 = cljs.core.seq.call(null,cols_6389);
var chunk__6234_6391 = null;
var count__6235_6392 = (0);
var i__6236_6393 = (0);
while(true){
if((i__6236_6393 < count__6235_6392)){
var vec__6243_6394 = cljs.core._nth.call(null,chunk__6234_6391,i__6236_6393);
var col_6395 = cljs.core.nth.call(null,vec__6243_6394,(0),null);
var infos_6396 = cljs.core.nth.call(null,vec__6243_6394,(1),null);
encode_cols.call(null,infos_6396,source_idx_6379,line_6388,col_6395);


var G__6397 = seq__6233_6390;
var G__6398 = chunk__6234_6391;
var G__6399 = count__6235_6392;
var G__6400 = (i__6236_6393 + (1));
seq__6233_6390 = G__6397;
chunk__6234_6391 = G__6398;
count__6235_6392 = G__6399;
i__6236_6393 = G__6400;
continue;
} else {
var temp__5735__auto___6401 = cljs.core.seq.call(null,seq__6233_6390);
if(temp__5735__auto___6401){
var seq__6233_6402__$1 = temp__5735__auto___6401;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6233_6402__$1)){
var c__4556__auto___6403 = cljs.core.chunk_first.call(null,seq__6233_6402__$1);
var G__6404 = cljs.core.chunk_rest.call(null,seq__6233_6402__$1);
var G__6405 = c__4556__auto___6403;
var G__6406 = cljs.core.count.call(null,c__4556__auto___6403);
var G__6407 = (0);
seq__6233_6390 = G__6404;
chunk__6234_6391 = G__6405;
count__6235_6392 = G__6406;
i__6236_6393 = G__6407;
continue;
} else {
var vec__6246_6408 = cljs.core.first.call(null,seq__6233_6402__$1);
var col_6409 = cljs.core.nth.call(null,vec__6246_6408,(0),null);
var infos_6410 = cljs.core.nth.call(null,vec__6246_6408,(1),null);
encode_cols.call(null,infos_6410,source_idx_6379,line_6388,col_6409);


var G__6411 = cljs.core.next.call(null,seq__6233_6402__$1);
var G__6412 = null;
var G__6413 = (0);
var G__6414 = (0);
seq__6233_6390 = G__6411;
chunk__6234_6391 = G__6412;
count__6235_6392 = G__6413;
i__6236_6393 = G__6414;
continue;
}
} else {
}
}
break;
}


var G__6415 = seq__6188_6383;
var G__6416 = chunk__6189_6384;
var G__6417 = count__6190_6385;
var G__6418 = (i__6191_6386 + (1));
seq__6188_6383 = G__6415;
chunk__6189_6384 = G__6416;
count__6190_6385 = G__6417;
i__6191_6386 = G__6418;
continue;
} else {
var temp__5735__auto___6419 = cljs.core.seq.call(null,seq__6188_6383);
if(temp__5735__auto___6419){
var seq__6188_6420__$1 = temp__5735__auto___6419;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6188_6420__$1)){
var c__4556__auto___6421 = cljs.core.chunk_first.call(null,seq__6188_6420__$1);
var G__6422 = cljs.core.chunk_rest.call(null,seq__6188_6420__$1);
var G__6423 = c__4556__auto___6421;
var G__6424 = cljs.core.count.call(null,c__4556__auto___6421);
var G__6425 = (0);
seq__6188_6383 = G__6422;
chunk__6189_6384 = G__6423;
count__6190_6385 = G__6424;
i__6191_6386 = G__6425;
continue;
} else {
var vec__6249_6426 = cljs.core.first.call(null,seq__6188_6420__$1);
var line_6427 = cljs.core.nth.call(null,vec__6249_6426,(0),null);
var cols_6428 = cljs.core.nth.call(null,vec__6249_6426,(1),null);
var seq__6252_6429 = cljs.core.seq.call(null,cols_6428);
var chunk__6253_6430 = null;
var count__6254_6431 = (0);
var i__6255_6432 = (0);
while(true){
if((i__6255_6432 < count__6254_6431)){
var vec__6262_6433 = cljs.core._nth.call(null,chunk__6253_6430,i__6255_6432);
var col_6434 = cljs.core.nth.call(null,vec__6262_6433,(0),null);
var infos_6435 = cljs.core.nth.call(null,vec__6262_6433,(1),null);
encode_cols.call(null,infos_6435,source_idx_6379,line_6427,col_6434);


var G__6436 = seq__6252_6429;
var G__6437 = chunk__6253_6430;
var G__6438 = count__6254_6431;
var G__6439 = (i__6255_6432 + (1));
seq__6252_6429 = G__6436;
chunk__6253_6430 = G__6437;
count__6254_6431 = G__6438;
i__6255_6432 = G__6439;
continue;
} else {
var temp__5735__auto___6440__$1 = cljs.core.seq.call(null,seq__6252_6429);
if(temp__5735__auto___6440__$1){
var seq__6252_6441__$1 = temp__5735__auto___6440__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6252_6441__$1)){
var c__4556__auto___6442 = cljs.core.chunk_first.call(null,seq__6252_6441__$1);
var G__6443 = cljs.core.chunk_rest.call(null,seq__6252_6441__$1);
var G__6444 = c__4556__auto___6442;
var G__6445 = cljs.core.count.call(null,c__4556__auto___6442);
var G__6446 = (0);
seq__6252_6429 = G__6443;
chunk__6253_6430 = G__6444;
count__6254_6431 = G__6445;
i__6255_6432 = G__6446;
continue;
} else {
var vec__6265_6447 = cljs.core.first.call(null,seq__6252_6441__$1);
var col_6448 = cljs.core.nth.call(null,vec__6265_6447,(0),null);
var infos_6449 = cljs.core.nth.call(null,vec__6265_6447,(1),null);
encode_cols.call(null,infos_6449,source_idx_6379,line_6427,col_6448);


var G__6450 = cljs.core.next.call(null,seq__6252_6441__$1);
var G__6451 = null;
var G__6452 = (0);
var G__6453 = (0);
seq__6252_6429 = G__6450;
chunk__6253_6430 = G__6451;
count__6254_6431 = G__6452;
i__6255_6432 = G__6453;
continue;
}
} else {
}
}
break;
}


var G__6454 = cljs.core.next.call(null,seq__6188_6420__$1);
var G__6455 = null;
var G__6456 = (0);
var G__6457 = (0);
seq__6188_6383 = G__6454;
chunk__6189_6384 = G__6455;
count__6190_6385 = G__6456;
i__6191_6386 = G__6457;
continue;
}
} else {
}
}
break;
}


var G__6458 = seq__6006_6374;
var G__6459 = chunk__6007_6375;
var G__6460 = count__6008_6376;
var G__6461 = (i__6009_6377 + (1));
seq__6006_6374 = G__6458;
chunk__6007_6375 = G__6459;
count__6008_6376 = G__6460;
i__6009_6377 = G__6461;
continue;
} else {
var temp__5735__auto___6462 = cljs.core.seq.call(null,seq__6006_6374);
if(temp__5735__auto___6462){
var seq__6006_6463__$1 = temp__5735__auto___6462;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6006_6463__$1)){
var c__4556__auto___6464 = cljs.core.chunk_first.call(null,seq__6006_6463__$1);
var G__6465 = cljs.core.chunk_rest.call(null,seq__6006_6463__$1);
var G__6466 = c__4556__auto___6464;
var G__6467 = cljs.core.count.call(null,c__4556__auto___6464);
var G__6468 = (0);
seq__6006_6374 = G__6465;
chunk__6007_6375 = G__6466;
count__6008_6376 = G__6467;
i__6009_6377 = G__6468;
continue;
} else {
var vec__6268_6469 = cljs.core.first.call(null,seq__6006_6463__$1);
var source_idx_6470 = cljs.core.nth.call(null,vec__6268_6469,(0),null);
var vec__6271_6471 = cljs.core.nth.call(null,vec__6268_6469,(1),null);
var __6472 = cljs.core.nth.call(null,vec__6271_6471,(0),null);
var lines_6473__$1 = cljs.core.nth.call(null,vec__6271_6471,(1),null);
var seq__6274_6474 = cljs.core.seq.call(null,lines_6473__$1);
var chunk__6275_6475 = null;
var count__6276_6476 = (0);
var i__6277_6477 = (0);
while(true){
if((i__6277_6477 < count__6276_6476)){
var vec__6316_6478 = cljs.core._nth.call(null,chunk__6275_6475,i__6277_6477);
var line_6479 = cljs.core.nth.call(null,vec__6316_6478,(0),null);
var cols_6480 = cljs.core.nth.call(null,vec__6316_6478,(1),null);
var seq__6319_6481 = cljs.core.seq.call(null,cols_6480);
var chunk__6320_6482 = null;
var count__6321_6483 = (0);
var i__6322_6484 = (0);
while(true){
if((i__6322_6484 < count__6321_6483)){
var vec__6329_6485 = cljs.core._nth.call(null,chunk__6320_6482,i__6322_6484);
var col_6486 = cljs.core.nth.call(null,vec__6329_6485,(0),null);
var infos_6487 = cljs.core.nth.call(null,vec__6329_6485,(1),null);
encode_cols.call(null,infos_6487,source_idx_6470,line_6479,col_6486);


var G__6488 = seq__6319_6481;
var G__6489 = chunk__6320_6482;
var G__6490 = count__6321_6483;
var G__6491 = (i__6322_6484 + (1));
seq__6319_6481 = G__6488;
chunk__6320_6482 = G__6489;
count__6321_6483 = G__6490;
i__6322_6484 = G__6491;
continue;
} else {
var temp__5735__auto___6492__$1 = cljs.core.seq.call(null,seq__6319_6481);
if(temp__5735__auto___6492__$1){
var seq__6319_6493__$1 = temp__5735__auto___6492__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6319_6493__$1)){
var c__4556__auto___6494 = cljs.core.chunk_first.call(null,seq__6319_6493__$1);
var G__6495 = cljs.core.chunk_rest.call(null,seq__6319_6493__$1);
var G__6496 = c__4556__auto___6494;
var G__6497 = cljs.core.count.call(null,c__4556__auto___6494);
var G__6498 = (0);
seq__6319_6481 = G__6495;
chunk__6320_6482 = G__6496;
count__6321_6483 = G__6497;
i__6322_6484 = G__6498;
continue;
} else {
var vec__6332_6499 = cljs.core.first.call(null,seq__6319_6493__$1);
var col_6500 = cljs.core.nth.call(null,vec__6332_6499,(0),null);
var infos_6501 = cljs.core.nth.call(null,vec__6332_6499,(1),null);
encode_cols.call(null,infos_6501,source_idx_6470,line_6479,col_6500);


var G__6502 = cljs.core.next.call(null,seq__6319_6493__$1);
var G__6503 = null;
var G__6504 = (0);
var G__6505 = (0);
seq__6319_6481 = G__6502;
chunk__6320_6482 = G__6503;
count__6321_6483 = G__6504;
i__6322_6484 = G__6505;
continue;
}
} else {
}
}
break;
}


var G__6506 = seq__6274_6474;
var G__6507 = chunk__6275_6475;
var G__6508 = count__6276_6476;
var G__6509 = (i__6277_6477 + (1));
seq__6274_6474 = G__6506;
chunk__6275_6475 = G__6507;
count__6276_6476 = G__6508;
i__6277_6477 = G__6509;
continue;
} else {
var temp__5735__auto___6510__$1 = cljs.core.seq.call(null,seq__6274_6474);
if(temp__5735__auto___6510__$1){
var seq__6274_6511__$1 = temp__5735__auto___6510__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6274_6511__$1)){
var c__4556__auto___6512 = cljs.core.chunk_first.call(null,seq__6274_6511__$1);
var G__6513 = cljs.core.chunk_rest.call(null,seq__6274_6511__$1);
var G__6514 = c__4556__auto___6512;
var G__6515 = cljs.core.count.call(null,c__4556__auto___6512);
var G__6516 = (0);
seq__6274_6474 = G__6513;
chunk__6275_6475 = G__6514;
count__6276_6476 = G__6515;
i__6277_6477 = G__6516;
continue;
} else {
var vec__6335_6517 = cljs.core.first.call(null,seq__6274_6511__$1);
var line_6518 = cljs.core.nth.call(null,vec__6335_6517,(0),null);
var cols_6519 = cljs.core.nth.call(null,vec__6335_6517,(1),null);
var seq__6338_6520 = cljs.core.seq.call(null,cols_6519);
var chunk__6339_6521 = null;
var count__6340_6522 = (0);
var i__6341_6523 = (0);
while(true){
if((i__6341_6523 < count__6340_6522)){
var vec__6348_6524 = cljs.core._nth.call(null,chunk__6339_6521,i__6341_6523);
var col_6525 = cljs.core.nth.call(null,vec__6348_6524,(0),null);
var infos_6526 = cljs.core.nth.call(null,vec__6348_6524,(1),null);
encode_cols.call(null,infos_6526,source_idx_6470,line_6518,col_6525);


var G__6527 = seq__6338_6520;
var G__6528 = chunk__6339_6521;
var G__6529 = count__6340_6522;
var G__6530 = (i__6341_6523 + (1));
seq__6338_6520 = G__6527;
chunk__6339_6521 = G__6528;
count__6340_6522 = G__6529;
i__6341_6523 = G__6530;
continue;
} else {
var temp__5735__auto___6531__$2 = cljs.core.seq.call(null,seq__6338_6520);
if(temp__5735__auto___6531__$2){
var seq__6338_6532__$1 = temp__5735__auto___6531__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6338_6532__$1)){
var c__4556__auto___6533 = cljs.core.chunk_first.call(null,seq__6338_6532__$1);
var G__6534 = cljs.core.chunk_rest.call(null,seq__6338_6532__$1);
var G__6535 = c__4556__auto___6533;
var G__6536 = cljs.core.count.call(null,c__4556__auto___6533);
var G__6537 = (0);
seq__6338_6520 = G__6534;
chunk__6339_6521 = G__6535;
count__6340_6522 = G__6536;
i__6341_6523 = G__6537;
continue;
} else {
var vec__6351_6538 = cljs.core.first.call(null,seq__6338_6532__$1);
var col_6539 = cljs.core.nth.call(null,vec__6351_6538,(0),null);
var infos_6540 = cljs.core.nth.call(null,vec__6351_6538,(1),null);
encode_cols.call(null,infos_6540,source_idx_6470,line_6518,col_6539);


var G__6541 = cljs.core.next.call(null,seq__6338_6532__$1);
var G__6542 = null;
var G__6543 = (0);
var G__6544 = (0);
seq__6338_6520 = G__6541;
chunk__6339_6521 = G__6542;
count__6340_6522 = G__6543;
i__6341_6523 = G__6544;
continue;
}
} else {
}
}
break;
}


var G__6545 = cljs.core.next.call(null,seq__6274_6511__$1);
var G__6546 = null;
var G__6547 = (0);
var G__6548 = (0);
seq__6274_6474 = G__6545;
chunk__6275_6475 = G__6546;
count__6276_6476 = G__6547;
i__6277_6477 = G__6548;
continue;
}
} else {
}
}
break;
}


var G__6549 = cljs.core.next.call(null,seq__6006_6463__$1);
var G__6550 = null;
var G__6551 = (0);
var G__6552 = (0);
seq__6006_6374 = G__6549;
chunk__6007_6375 = G__6550;
count__6008_6376 = G__6551;
i__6009_6377 = G__6552;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__6354 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__5999_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__5999_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__6000_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__6000_SHARP_,/\//));
}));
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,(function (p1__6001_SHARP_){
return clojure.string.join.call(null,",",p1__6001_SHARP_);
}),cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__6355 = G__6354;
goog.object.set(G__6355,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__6355;
} else {
return G__6354;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__6553 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__6553,(0),null);
var col_map = cljs.core.nth.call(null,vec__6553,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__6556 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__6556,(0),null);
var infos = cljs.core.nth.call(null,vec__6556,(1),null);
var G__6562 = cljs.core.next.call(null,col_map_seq);
var G__6563 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__6556,col,infos,vec__6553,line,col_map){
return (function (v,p__6559){
var map__6560 = p__6559;
var map__6560__$1 = (((((!((map__6560 == null))))?(((((map__6560.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6560.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6560):map__6560);
var gline = cljs.core.get.call(null,map__6560__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__6560__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__6556,col,infos,vec__6553,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__6562;
new_cols = G__6563;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__6564 = cljs.core.next.call(null,line_map_seq);
var G__6565 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__6564;
new_lines = G__6565;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__6566_6838 = cljs.core.seq.call(null,reverse_map);
var chunk__6567_6839 = null;
var count__6568_6840 = (0);
var i__6569_6841 = (0);
while(true){
if((i__6569_6841 < count__6568_6840)){
var vec__6704_6842 = cljs.core._nth.call(null,chunk__6567_6839,i__6569_6841);
var line_6843 = cljs.core.nth.call(null,vec__6704_6842,(0),null);
var columns_6844 = cljs.core.nth.call(null,vec__6704_6842,(1),null);
var seq__6707_6845 = cljs.core.seq.call(null,columns_6844);
var chunk__6708_6846 = null;
var count__6709_6847 = (0);
var i__6710_6848 = (0);
while(true){
if((i__6710_6848 < count__6709_6847)){
var vec__6741_6849 = cljs.core._nth.call(null,chunk__6708_6846,i__6710_6848);
var column_6850 = cljs.core.nth.call(null,vec__6741_6849,(0),null);
var column_info_6851 = cljs.core.nth.call(null,vec__6741_6849,(1),null);
var seq__6744_6852 = cljs.core.seq.call(null,column_info_6851);
var chunk__6745_6853 = null;
var count__6746_6854 = (0);
var i__6747_6855 = (0);
while(true){
if((i__6747_6855 < count__6746_6854)){
var map__6752_6856 = cljs.core._nth.call(null,chunk__6745_6853,i__6747_6855);
var map__6752_6857__$1 = (((((!((map__6752_6856 == null))))?(((((map__6752_6856.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6752_6856.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6752_6856):map__6752_6856);
var gline_6858 = cljs.core.get.call(null,map__6752_6857__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6859 = cljs.core.get.call(null,map__6752_6857__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6860 = cljs.core.get.call(null,map__6752_6857__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6858], null),cljs.core.fnil.call(null,((function (seq__6744_6852,chunk__6745_6853,count__6746_6854,i__6747_6855,seq__6707_6845,chunk__6708_6846,count__6709_6847,i__6710_6848,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6752_6856,map__6752_6857__$1,gline_6858,gcol_6859,name_6860,vec__6741_6849,column_6850,column_info_6851,vec__6704_6842,line_6843,columns_6844,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6859], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6843,new cljs.core.Keyword(null,"col","col",-1959363084),column_6850,new cljs.core.Keyword(null,"name","name",1843675177),name_6860], null));
});})(seq__6744_6852,chunk__6745_6853,count__6746_6854,i__6747_6855,seq__6707_6845,chunk__6708_6846,count__6709_6847,i__6710_6848,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6752_6856,map__6752_6857__$1,gline_6858,gcol_6859,name_6860,vec__6741_6849,column_6850,column_info_6851,vec__6704_6842,line_6843,columns_6844,inverted))
,cljs.core.sorted_map.call(null)));


var G__6861 = seq__6744_6852;
var G__6862 = chunk__6745_6853;
var G__6863 = count__6746_6854;
var G__6864 = (i__6747_6855 + (1));
seq__6744_6852 = G__6861;
chunk__6745_6853 = G__6862;
count__6746_6854 = G__6863;
i__6747_6855 = G__6864;
continue;
} else {
var temp__5735__auto___6865 = cljs.core.seq.call(null,seq__6744_6852);
if(temp__5735__auto___6865){
var seq__6744_6866__$1 = temp__5735__auto___6865;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6744_6866__$1)){
var c__4556__auto___6867 = cljs.core.chunk_first.call(null,seq__6744_6866__$1);
var G__6868 = cljs.core.chunk_rest.call(null,seq__6744_6866__$1);
var G__6869 = c__4556__auto___6867;
var G__6870 = cljs.core.count.call(null,c__4556__auto___6867);
var G__6871 = (0);
seq__6744_6852 = G__6868;
chunk__6745_6853 = G__6869;
count__6746_6854 = G__6870;
i__6747_6855 = G__6871;
continue;
} else {
var map__6754_6872 = cljs.core.first.call(null,seq__6744_6866__$1);
var map__6754_6873__$1 = (((((!((map__6754_6872 == null))))?(((((map__6754_6872.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6754_6872.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6754_6872):map__6754_6872);
var gline_6874 = cljs.core.get.call(null,map__6754_6873__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6875 = cljs.core.get.call(null,map__6754_6873__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6876 = cljs.core.get.call(null,map__6754_6873__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6874], null),cljs.core.fnil.call(null,((function (seq__6744_6852,chunk__6745_6853,count__6746_6854,i__6747_6855,seq__6707_6845,chunk__6708_6846,count__6709_6847,i__6710_6848,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6754_6872,map__6754_6873__$1,gline_6874,gcol_6875,name_6876,seq__6744_6866__$1,temp__5735__auto___6865,vec__6741_6849,column_6850,column_info_6851,vec__6704_6842,line_6843,columns_6844,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6875], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6843,new cljs.core.Keyword(null,"col","col",-1959363084),column_6850,new cljs.core.Keyword(null,"name","name",1843675177),name_6876], null));
});})(seq__6744_6852,chunk__6745_6853,count__6746_6854,i__6747_6855,seq__6707_6845,chunk__6708_6846,count__6709_6847,i__6710_6848,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6754_6872,map__6754_6873__$1,gline_6874,gcol_6875,name_6876,seq__6744_6866__$1,temp__5735__auto___6865,vec__6741_6849,column_6850,column_info_6851,vec__6704_6842,line_6843,columns_6844,inverted))
,cljs.core.sorted_map.call(null)));


var G__6877 = cljs.core.next.call(null,seq__6744_6866__$1);
var G__6878 = null;
var G__6879 = (0);
var G__6880 = (0);
seq__6744_6852 = G__6877;
chunk__6745_6853 = G__6878;
count__6746_6854 = G__6879;
i__6747_6855 = G__6880;
continue;
}
} else {
}
}
break;
}


var G__6881 = seq__6707_6845;
var G__6882 = chunk__6708_6846;
var G__6883 = count__6709_6847;
var G__6884 = (i__6710_6848 + (1));
seq__6707_6845 = G__6881;
chunk__6708_6846 = G__6882;
count__6709_6847 = G__6883;
i__6710_6848 = G__6884;
continue;
} else {
var temp__5735__auto___6885 = cljs.core.seq.call(null,seq__6707_6845);
if(temp__5735__auto___6885){
var seq__6707_6886__$1 = temp__5735__auto___6885;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6707_6886__$1)){
var c__4556__auto___6887 = cljs.core.chunk_first.call(null,seq__6707_6886__$1);
var G__6888 = cljs.core.chunk_rest.call(null,seq__6707_6886__$1);
var G__6889 = c__4556__auto___6887;
var G__6890 = cljs.core.count.call(null,c__4556__auto___6887);
var G__6891 = (0);
seq__6707_6845 = G__6888;
chunk__6708_6846 = G__6889;
count__6709_6847 = G__6890;
i__6710_6848 = G__6891;
continue;
} else {
var vec__6756_6892 = cljs.core.first.call(null,seq__6707_6886__$1);
var column_6893 = cljs.core.nth.call(null,vec__6756_6892,(0),null);
var column_info_6894 = cljs.core.nth.call(null,vec__6756_6892,(1),null);
var seq__6759_6895 = cljs.core.seq.call(null,column_info_6894);
var chunk__6760_6896 = null;
var count__6761_6897 = (0);
var i__6762_6898 = (0);
while(true){
if((i__6762_6898 < count__6761_6897)){
var map__6767_6899 = cljs.core._nth.call(null,chunk__6760_6896,i__6762_6898);
var map__6767_6900__$1 = (((((!((map__6767_6899 == null))))?(((((map__6767_6899.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6767_6899.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6767_6899):map__6767_6899);
var gline_6901 = cljs.core.get.call(null,map__6767_6900__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6902 = cljs.core.get.call(null,map__6767_6900__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6903 = cljs.core.get.call(null,map__6767_6900__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6901], null),cljs.core.fnil.call(null,((function (seq__6759_6895,chunk__6760_6896,count__6761_6897,i__6762_6898,seq__6707_6845,chunk__6708_6846,count__6709_6847,i__6710_6848,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6767_6899,map__6767_6900__$1,gline_6901,gcol_6902,name_6903,vec__6756_6892,column_6893,column_info_6894,seq__6707_6886__$1,temp__5735__auto___6885,vec__6704_6842,line_6843,columns_6844,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6902], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6843,new cljs.core.Keyword(null,"col","col",-1959363084),column_6893,new cljs.core.Keyword(null,"name","name",1843675177),name_6903], null));
});})(seq__6759_6895,chunk__6760_6896,count__6761_6897,i__6762_6898,seq__6707_6845,chunk__6708_6846,count__6709_6847,i__6710_6848,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6767_6899,map__6767_6900__$1,gline_6901,gcol_6902,name_6903,vec__6756_6892,column_6893,column_info_6894,seq__6707_6886__$1,temp__5735__auto___6885,vec__6704_6842,line_6843,columns_6844,inverted))
,cljs.core.sorted_map.call(null)));


var G__6904 = seq__6759_6895;
var G__6905 = chunk__6760_6896;
var G__6906 = count__6761_6897;
var G__6907 = (i__6762_6898 + (1));
seq__6759_6895 = G__6904;
chunk__6760_6896 = G__6905;
count__6761_6897 = G__6906;
i__6762_6898 = G__6907;
continue;
} else {
var temp__5735__auto___6908__$1 = cljs.core.seq.call(null,seq__6759_6895);
if(temp__5735__auto___6908__$1){
var seq__6759_6909__$1 = temp__5735__auto___6908__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6759_6909__$1)){
var c__4556__auto___6910 = cljs.core.chunk_first.call(null,seq__6759_6909__$1);
var G__6911 = cljs.core.chunk_rest.call(null,seq__6759_6909__$1);
var G__6912 = c__4556__auto___6910;
var G__6913 = cljs.core.count.call(null,c__4556__auto___6910);
var G__6914 = (0);
seq__6759_6895 = G__6911;
chunk__6760_6896 = G__6912;
count__6761_6897 = G__6913;
i__6762_6898 = G__6914;
continue;
} else {
var map__6769_6915 = cljs.core.first.call(null,seq__6759_6909__$1);
var map__6769_6916__$1 = (((((!((map__6769_6915 == null))))?(((((map__6769_6915.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6769_6915.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6769_6915):map__6769_6915);
var gline_6917 = cljs.core.get.call(null,map__6769_6916__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6918 = cljs.core.get.call(null,map__6769_6916__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6919 = cljs.core.get.call(null,map__6769_6916__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6917], null),cljs.core.fnil.call(null,((function (seq__6759_6895,chunk__6760_6896,count__6761_6897,i__6762_6898,seq__6707_6845,chunk__6708_6846,count__6709_6847,i__6710_6848,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6769_6915,map__6769_6916__$1,gline_6917,gcol_6918,name_6919,seq__6759_6909__$1,temp__5735__auto___6908__$1,vec__6756_6892,column_6893,column_info_6894,seq__6707_6886__$1,temp__5735__auto___6885,vec__6704_6842,line_6843,columns_6844,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6918], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6843,new cljs.core.Keyword(null,"col","col",-1959363084),column_6893,new cljs.core.Keyword(null,"name","name",1843675177),name_6919], null));
});})(seq__6759_6895,chunk__6760_6896,count__6761_6897,i__6762_6898,seq__6707_6845,chunk__6708_6846,count__6709_6847,i__6710_6848,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6769_6915,map__6769_6916__$1,gline_6917,gcol_6918,name_6919,seq__6759_6909__$1,temp__5735__auto___6908__$1,vec__6756_6892,column_6893,column_info_6894,seq__6707_6886__$1,temp__5735__auto___6885,vec__6704_6842,line_6843,columns_6844,inverted))
,cljs.core.sorted_map.call(null)));


var G__6920 = cljs.core.next.call(null,seq__6759_6909__$1);
var G__6921 = null;
var G__6922 = (0);
var G__6923 = (0);
seq__6759_6895 = G__6920;
chunk__6760_6896 = G__6921;
count__6761_6897 = G__6922;
i__6762_6898 = G__6923;
continue;
}
} else {
}
}
break;
}


var G__6924 = cljs.core.next.call(null,seq__6707_6886__$1);
var G__6925 = null;
var G__6926 = (0);
var G__6927 = (0);
seq__6707_6845 = G__6924;
chunk__6708_6846 = G__6925;
count__6709_6847 = G__6926;
i__6710_6848 = G__6927;
continue;
}
} else {
}
}
break;
}


var G__6928 = seq__6566_6838;
var G__6929 = chunk__6567_6839;
var G__6930 = count__6568_6840;
var G__6931 = (i__6569_6841 + (1));
seq__6566_6838 = G__6928;
chunk__6567_6839 = G__6929;
count__6568_6840 = G__6930;
i__6569_6841 = G__6931;
continue;
} else {
var temp__5735__auto___6932 = cljs.core.seq.call(null,seq__6566_6838);
if(temp__5735__auto___6932){
var seq__6566_6933__$1 = temp__5735__auto___6932;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6566_6933__$1)){
var c__4556__auto___6934 = cljs.core.chunk_first.call(null,seq__6566_6933__$1);
var G__6935 = cljs.core.chunk_rest.call(null,seq__6566_6933__$1);
var G__6936 = c__4556__auto___6934;
var G__6937 = cljs.core.count.call(null,c__4556__auto___6934);
var G__6938 = (0);
seq__6566_6838 = G__6935;
chunk__6567_6839 = G__6936;
count__6568_6840 = G__6937;
i__6569_6841 = G__6938;
continue;
} else {
var vec__6771_6939 = cljs.core.first.call(null,seq__6566_6933__$1);
var line_6940 = cljs.core.nth.call(null,vec__6771_6939,(0),null);
var columns_6941 = cljs.core.nth.call(null,vec__6771_6939,(1),null);
var seq__6774_6942 = cljs.core.seq.call(null,columns_6941);
var chunk__6775_6943 = null;
var count__6776_6944 = (0);
var i__6777_6945 = (0);
while(true){
if((i__6777_6945 < count__6776_6944)){
var vec__6808_6946 = cljs.core._nth.call(null,chunk__6775_6943,i__6777_6945);
var column_6947 = cljs.core.nth.call(null,vec__6808_6946,(0),null);
var column_info_6948 = cljs.core.nth.call(null,vec__6808_6946,(1),null);
var seq__6811_6949 = cljs.core.seq.call(null,column_info_6948);
var chunk__6812_6950 = null;
var count__6813_6951 = (0);
var i__6814_6952 = (0);
while(true){
if((i__6814_6952 < count__6813_6951)){
var map__6819_6953 = cljs.core._nth.call(null,chunk__6812_6950,i__6814_6952);
var map__6819_6954__$1 = (((((!((map__6819_6953 == null))))?(((((map__6819_6953.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6819_6953.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6819_6953):map__6819_6953);
var gline_6955 = cljs.core.get.call(null,map__6819_6954__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6956 = cljs.core.get.call(null,map__6819_6954__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6957 = cljs.core.get.call(null,map__6819_6954__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6955], null),cljs.core.fnil.call(null,((function (seq__6811_6949,chunk__6812_6950,count__6813_6951,i__6814_6952,seq__6774_6942,chunk__6775_6943,count__6776_6944,i__6777_6945,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6819_6953,map__6819_6954__$1,gline_6955,gcol_6956,name_6957,vec__6808_6946,column_6947,column_info_6948,vec__6771_6939,line_6940,columns_6941,seq__6566_6933__$1,temp__5735__auto___6932,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6956], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6940,new cljs.core.Keyword(null,"col","col",-1959363084),column_6947,new cljs.core.Keyword(null,"name","name",1843675177),name_6957], null));
});})(seq__6811_6949,chunk__6812_6950,count__6813_6951,i__6814_6952,seq__6774_6942,chunk__6775_6943,count__6776_6944,i__6777_6945,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6819_6953,map__6819_6954__$1,gline_6955,gcol_6956,name_6957,vec__6808_6946,column_6947,column_info_6948,vec__6771_6939,line_6940,columns_6941,seq__6566_6933__$1,temp__5735__auto___6932,inverted))
,cljs.core.sorted_map.call(null)));


var G__6958 = seq__6811_6949;
var G__6959 = chunk__6812_6950;
var G__6960 = count__6813_6951;
var G__6961 = (i__6814_6952 + (1));
seq__6811_6949 = G__6958;
chunk__6812_6950 = G__6959;
count__6813_6951 = G__6960;
i__6814_6952 = G__6961;
continue;
} else {
var temp__5735__auto___6962__$1 = cljs.core.seq.call(null,seq__6811_6949);
if(temp__5735__auto___6962__$1){
var seq__6811_6963__$1 = temp__5735__auto___6962__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6811_6963__$1)){
var c__4556__auto___6964 = cljs.core.chunk_first.call(null,seq__6811_6963__$1);
var G__6965 = cljs.core.chunk_rest.call(null,seq__6811_6963__$1);
var G__6966 = c__4556__auto___6964;
var G__6967 = cljs.core.count.call(null,c__4556__auto___6964);
var G__6968 = (0);
seq__6811_6949 = G__6965;
chunk__6812_6950 = G__6966;
count__6813_6951 = G__6967;
i__6814_6952 = G__6968;
continue;
} else {
var map__6821_6969 = cljs.core.first.call(null,seq__6811_6963__$1);
var map__6821_6970__$1 = (((((!((map__6821_6969 == null))))?(((((map__6821_6969.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6821_6969.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6821_6969):map__6821_6969);
var gline_6971 = cljs.core.get.call(null,map__6821_6970__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6972 = cljs.core.get.call(null,map__6821_6970__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6973 = cljs.core.get.call(null,map__6821_6970__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6971], null),cljs.core.fnil.call(null,((function (seq__6811_6949,chunk__6812_6950,count__6813_6951,i__6814_6952,seq__6774_6942,chunk__6775_6943,count__6776_6944,i__6777_6945,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6821_6969,map__6821_6970__$1,gline_6971,gcol_6972,name_6973,seq__6811_6963__$1,temp__5735__auto___6962__$1,vec__6808_6946,column_6947,column_info_6948,vec__6771_6939,line_6940,columns_6941,seq__6566_6933__$1,temp__5735__auto___6932,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6972], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6940,new cljs.core.Keyword(null,"col","col",-1959363084),column_6947,new cljs.core.Keyword(null,"name","name",1843675177),name_6973], null));
});})(seq__6811_6949,chunk__6812_6950,count__6813_6951,i__6814_6952,seq__6774_6942,chunk__6775_6943,count__6776_6944,i__6777_6945,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6821_6969,map__6821_6970__$1,gline_6971,gcol_6972,name_6973,seq__6811_6963__$1,temp__5735__auto___6962__$1,vec__6808_6946,column_6947,column_info_6948,vec__6771_6939,line_6940,columns_6941,seq__6566_6933__$1,temp__5735__auto___6932,inverted))
,cljs.core.sorted_map.call(null)));


var G__6974 = cljs.core.next.call(null,seq__6811_6963__$1);
var G__6975 = null;
var G__6976 = (0);
var G__6977 = (0);
seq__6811_6949 = G__6974;
chunk__6812_6950 = G__6975;
count__6813_6951 = G__6976;
i__6814_6952 = G__6977;
continue;
}
} else {
}
}
break;
}


var G__6978 = seq__6774_6942;
var G__6979 = chunk__6775_6943;
var G__6980 = count__6776_6944;
var G__6981 = (i__6777_6945 + (1));
seq__6774_6942 = G__6978;
chunk__6775_6943 = G__6979;
count__6776_6944 = G__6980;
i__6777_6945 = G__6981;
continue;
} else {
var temp__5735__auto___6982__$1 = cljs.core.seq.call(null,seq__6774_6942);
if(temp__5735__auto___6982__$1){
var seq__6774_6983__$1 = temp__5735__auto___6982__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6774_6983__$1)){
var c__4556__auto___6984 = cljs.core.chunk_first.call(null,seq__6774_6983__$1);
var G__6985 = cljs.core.chunk_rest.call(null,seq__6774_6983__$1);
var G__6986 = c__4556__auto___6984;
var G__6987 = cljs.core.count.call(null,c__4556__auto___6984);
var G__6988 = (0);
seq__6774_6942 = G__6985;
chunk__6775_6943 = G__6986;
count__6776_6944 = G__6987;
i__6777_6945 = G__6988;
continue;
} else {
var vec__6823_6989 = cljs.core.first.call(null,seq__6774_6983__$1);
var column_6990 = cljs.core.nth.call(null,vec__6823_6989,(0),null);
var column_info_6991 = cljs.core.nth.call(null,vec__6823_6989,(1),null);
var seq__6826_6992 = cljs.core.seq.call(null,column_info_6991);
var chunk__6827_6993 = null;
var count__6828_6994 = (0);
var i__6829_6995 = (0);
while(true){
if((i__6829_6995 < count__6828_6994)){
var map__6834_6996 = cljs.core._nth.call(null,chunk__6827_6993,i__6829_6995);
var map__6834_6997__$1 = (((((!((map__6834_6996 == null))))?(((((map__6834_6996.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6834_6996.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6834_6996):map__6834_6996);
var gline_6998 = cljs.core.get.call(null,map__6834_6997__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6999 = cljs.core.get.call(null,map__6834_6997__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_7000 = cljs.core.get.call(null,map__6834_6997__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6998], null),cljs.core.fnil.call(null,((function (seq__6826_6992,chunk__6827_6993,count__6828_6994,i__6829_6995,seq__6774_6942,chunk__6775_6943,count__6776_6944,i__6777_6945,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6834_6996,map__6834_6997__$1,gline_6998,gcol_6999,name_7000,vec__6823_6989,column_6990,column_info_6991,seq__6774_6983__$1,temp__5735__auto___6982__$1,vec__6771_6939,line_6940,columns_6941,seq__6566_6933__$1,temp__5735__auto___6932,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6999], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6940,new cljs.core.Keyword(null,"col","col",-1959363084),column_6990,new cljs.core.Keyword(null,"name","name",1843675177),name_7000], null));
});})(seq__6826_6992,chunk__6827_6993,count__6828_6994,i__6829_6995,seq__6774_6942,chunk__6775_6943,count__6776_6944,i__6777_6945,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6834_6996,map__6834_6997__$1,gline_6998,gcol_6999,name_7000,vec__6823_6989,column_6990,column_info_6991,seq__6774_6983__$1,temp__5735__auto___6982__$1,vec__6771_6939,line_6940,columns_6941,seq__6566_6933__$1,temp__5735__auto___6932,inverted))
,cljs.core.sorted_map.call(null)));


var G__7001 = seq__6826_6992;
var G__7002 = chunk__6827_6993;
var G__7003 = count__6828_6994;
var G__7004 = (i__6829_6995 + (1));
seq__6826_6992 = G__7001;
chunk__6827_6993 = G__7002;
count__6828_6994 = G__7003;
i__6829_6995 = G__7004;
continue;
} else {
var temp__5735__auto___7005__$2 = cljs.core.seq.call(null,seq__6826_6992);
if(temp__5735__auto___7005__$2){
var seq__6826_7006__$1 = temp__5735__auto___7005__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6826_7006__$1)){
var c__4556__auto___7007 = cljs.core.chunk_first.call(null,seq__6826_7006__$1);
var G__7008 = cljs.core.chunk_rest.call(null,seq__6826_7006__$1);
var G__7009 = c__4556__auto___7007;
var G__7010 = cljs.core.count.call(null,c__4556__auto___7007);
var G__7011 = (0);
seq__6826_6992 = G__7008;
chunk__6827_6993 = G__7009;
count__6828_6994 = G__7010;
i__6829_6995 = G__7011;
continue;
} else {
var map__6836_7012 = cljs.core.first.call(null,seq__6826_7006__$1);
var map__6836_7013__$1 = (((((!((map__6836_7012 == null))))?(((((map__6836_7012.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6836_7012.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6836_7012):map__6836_7012);
var gline_7014 = cljs.core.get.call(null,map__6836_7013__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_7015 = cljs.core.get.call(null,map__6836_7013__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_7016 = cljs.core.get.call(null,map__6836_7013__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_7014], null),cljs.core.fnil.call(null,((function (seq__6826_6992,chunk__6827_6993,count__6828_6994,i__6829_6995,seq__6774_6942,chunk__6775_6943,count__6776_6944,i__6777_6945,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6836_7012,map__6836_7013__$1,gline_7014,gcol_7015,name_7016,seq__6826_7006__$1,temp__5735__auto___7005__$2,vec__6823_6989,column_6990,column_info_6991,seq__6774_6983__$1,temp__5735__auto___6982__$1,vec__6771_6939,line_6940,columns_6941,seq__6566_6933__$1,temp__5735__auto___6932,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_7015], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6940,new cljs.core.Keyword(null,"col","col",-1959363084),column_6990,new cljs.core.Keyword(null,"name","name",1843675177),name_7016], null));
});})(seq__6826_6992,chunk__6827_6993,count__6828_6994,i__6829_6995,seq__6774_6942,chunk__6775_6943,count__6776_6944,i__6777_6945,seq__6566_6838,chunk__6567_6839,count__6568_6840,i__6569_6841,map__6836_7012,map__6836_7013__$1,gline_7014,gcol_7015,name_7016,seq__6826_7006__$1,temp__5735__auto___7005__$2,vec__6823_6989,column_6990,column_info_6991,seq__6774_6983__$1,temp__5735__auto___6982__$1,vec__6771_6939,line_6940,columns_6941,seq__6566_6933__$1,temp__5735__auto___6932,inverted))
,cljs.core.sorted_map.call(null)));


var G__7017 = cljs.core.next.call(null,seq__6826_7006__$1);
var G__7018 = null;
var G__7019 = (0);
var G__7020 = (0);
seq__6826_6992 = G__7017;
chunk__6827_6993 = G__7018;
count__6828_6994 = G__7019;
i__6829_6995 = G__7020;
continue;
}
} else {
}
}
break;
}


var G__7021 = cljs.core.next.call(null,seq__6774_6983__$1);
var G__7022 = null;
var G__7023 = (0);
var G__7024 = (0);
seq__6774_6942 = G__7021;
chunk__6775_6943 = G__7022;
count__6776_6944 = G__7023;
i__6777_6945 = G__7024;
continue;
}
} else {
}
}
break;
}


var G__7025 = cljs.core.next.call(null,seq__6566_6933__$1);
var G__7026 = null;
var G__7027 = (0);
var G__7028 = (0);
seq__6566_6838 = G__7025;
chunk__6567_6839 = G__7026;
count__6568_6840 = G__7027;
i__6569_6841 = G__7028;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});
