// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__26857 = cljs.core._EQ_;
var expr__26858 = e.getLastErrorCode();
if(cljs.core.truth_(pred__26857.call(null,goog.net.ErrorCode.NO_ERROR,expr__26858))){
return new cljs.core.Keyword("xhttp","no-error","xhttp/no-error",1902047248);
} else {
if(cljs.core.truth_(pred__26857.call(null,goog.net.ErrorCode.EXCEPTION,expr__26858))){
return new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040);
} else {
if(cljs.core.truth_(pred__26857.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__26858))){
return new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305);
} else {
if(cljs.core.truth_(pred__26857.call(null,goog.net.ErrorCode.ABORT,expr__26858))){
return new cljs.core.Keyword("xhttp","abort","xhttp/abort",666776046);
} else {
if(cljs.core.truth_(pred__26857.call(null,goog.net.ErrorCode.TIMEOUT,expr__26858))){
return new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562);
} else {
return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__26860 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__26860,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__26860;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__26861 = opts;
var map__26861__$1 = (((((!((map__26861 == null))))?(((((map__26861.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26861.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26861):map__26861);
var request_timeout = cljs.core.get.call(null,map__26861__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__26861__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__26861__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__26863 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__26863__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__26863,headers):G__26863);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__26863__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__26863__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,cljs.core.js__GT_clj.call(null,xhr.getResponseJson(),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"POST",fluree.db.util.json.stringify.call(null,message),cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e26864){var e_26865 = e26864;
fluree.db.util.log.warn.call(null,"CAUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_26865);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__26866 = opts;
var map__26866__$1 = (((((!((map__26866 == null))))?(((((map__26866.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26866.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26866):map__26866);
var request_timeout = cljs.core.get.call(null,map__26866__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__26866__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__26866__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__26866__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__26866__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__26868 = cljs.core.PersistentArrayMap.EMPTY;
var G__26868__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__26868,headers):G__26868);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__26868__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__26868__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__26870 = output_format;
var G__26870__$1 = (((G__26870 instanceof cljs.core.Keyword))?G__26870.fqn:null);
switch (G__26870__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"GET",body,cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e26869){var e_26872 = e26869;
fluree.db.util.log.warn.call(null,"CAUUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_26872);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__26873 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__26873,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__26873;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_26906){
var state_val_26907 = (state_26906[(1)]);
if((state_val_26907 === (7))){
var inst_26902 = (state_26906[(2)]);
var state_26906__$1 = state_26906;
var statearr_26908_26933 = state_26906__$1;
(statearr_26908_26933[(2)] = inst_26902);

(statearr_26908_26933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (1))){
var state_26906__$1 = state_26906;
var statearr_26909_26934 = state_26906__$1;
(statearr_26909_26934[(2)] = null);

(statearr_26909_26934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (4))){
var inst_26877 = (state_26906[(7)]);
var inst_26877__$1 = (state_26906[(2)]);
var inst_26878 = (inst_26877__$1 == null);
var state_26906__$1 = (function (){var statearr_26910 = state_26906;
(statearr_26910[(7)] = inst_26877__$1);

return statearr_26910;
})();
if(cljs.core.truth_(inst_26878)){
var statearr_26911_26935 = state_26906__$1;
(statearr_26911_26935[(1)] = (5));

} else {
var statearr_26912_26936 = state_26906__$1;
(statearr_26912_26936[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (6))){
var inst_26877 = (state_26906[(7)]);
var inst_26885 = cljs.core.nth.call(null,inst_26877,(0),null);
var inst_26886 = cljs.core.nth.call(null,inst_26877,(1),null);
var state_26906__$1 = (function (){var statearr_26913 = state_26906;
(statearr_26913[(8)] = inst_26885);

(statearr_26913[(9)] = inst_26886);

return statearr_26913;
})();
var statearr_26914_26937 = state_26906__$1;
(statearr_26914_26937[(2)] = null);

(statearr_26914_26937[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (3))){
var inst_26904 = (state_26906[(2)]);
var state_26906__$1 = state_26906;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26906__$1,inst_26904);
} else {
if((state_val_26907 === (2))){
var state_26906__$1 = state_26906;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26906__$1,(4),pub_chan);
} else {
if((state_val_26907 === (11))){
var _ = (function (){var statearr_26916 = state_26906;
(statearr_26916[(4)] = cljs.core.rest.call(null,(state_26906[(4)])));

return statearr_26916;
})();
var state_26906__$1 = state_26906;
var ex26915 = (state_26906__$1[(2)]);
var statearr_26917_26938 = state_26906__$1;
(statearr_26917_26938[(5)] = ex26915);


if((ex26915 instanceof Error)){
var statearr_26918_26939 = state_26906__$1;
(statearr_26918_26939[(1)] = (10));

(statearr_26918_26939[(5)] = null);

} else {
throw ex26915;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (9))){
var inst_26899 = (state_26906[(2)]);
var state_26906__$1 = (function (){var statearr_26919 = state_26906;
(statearr_26919[(10)] = inst_26899);

return statearr_26919;
})();
var statearr_26920_26940 = state_26906__$1;
(statearr_26920_26940[(2)] = null);

(statearr_26920_26940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (5))){
var inst_26880 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_26906__$1 = state_26906;
var statearr_26921_26941 = state_26906__$1;
(statearr_26921_26941[(2)] = inst_26880);

(statearr_26921_26941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (10))){
var inst_26886 = (state_26906[(9)]);
var inst_26887 = (state_26906[(2)]);
var inst_26888 = fluree.db.util.log.error.call(null,inst_26887,"Websocket send message error:",inst_26887);
var inst_26889 = cljs.core.async.put_BANG_.call(null,inst_26886,false);
var state_26906__$1 = (function (){var statearr_26922 = state_26906;
(statearr_26922[(11)] = inst_26888);

return statearr_26922;
})();
var statearr_26923_26942 = state_26906__$1;
(statearr_26923_26942[(2)] = inst_26889);

(statearr_26923_26942[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (8))){
var inst_26885 = (state_26906[(8)]);
var inst_26886 = (state_26906[(9)]);
var _ = (function (){var statearr_26924 = state_26906;
(statearr_26924[(4)] = cljs.core.cons.call(null,(11),(state_26906[(4)])));

return statearr_26924;
})();
var inst_26895 = ws.send(inst_26885);
var inst_26896 = cljs.core.async.put_BANG_.call(null,inst_26886,true);
var ___$1 = (function (){var statearr_26925 = state_26906;
(statearr_26925[(4)] = cljs.core.rest.call(null,(state_26906[(4)])));

return statearr_26925;
})();
var state_26906__$1 = (function (){var statearr_26926 = state_26906;
(statearr_26926[(12)] = inst_26895);

return statearr_26926;
})();
var statearr_26927_26943 = state_26906__$1;
(statearr_26927_26943[(2)] = inst_26896);

(statearr_26927_26943[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11469__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11469__auto____0 = (function (){
var statearr_26928 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26928[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11469__auto__);

(statearr_26928[(1)] = (1));

return statearr_26928;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11469__auto____1 = (function (state_26906){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_26906);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e26929){var ex__11472__auto__ = e26929;
var statearr_26930_26944 = state_26906;
(statearr_26930_26944[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_26906[(4)]))){
var statearr_26931_26945 = state_26906;
(statearr_26931_26945[(1)] = cljs.core.first.call(null,(state_26906[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26946 = state_26906;
state_26906 = G__26946;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11469__auto__ = function(state_26906){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11469__auto____1.call(this,state_26906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11469__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11469__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_26932 = f__11543__auto__.call(null);
(statearr_26932[(6)] = c__11542__auto__);

return statearr_26932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__11542__auto___26985 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_26972){
var state_val_26973 = (state_26972[(1)]);
if((state_val_26973 === (1))){
var inst_26951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26952 = [open_QMARK_,timeout_chan];
var inst_26953 = (new cljs.core.PersistentVector(null,2,(5),inst_26951,inst_26952,null));
var state_26972__$1 = state_26972;
return cljs.core.async.ioc_alts_BANG_.call(null,state_26972__$1,(2),inst_26953,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_26973 === (2))){
var inst_26955 = (state_26972[(2)]);
var inst_26956 = cljs.core.nth.call(null,inst_26955,(0),null);
var inst_26957 = cljs.core.nth.call(null,inst_26955,(1),null);
var inst_26958 = cljs.core._EQ_.call(null,inst_26957,timeout_chan);
var state_26972__$1 = (function (){var statearr_26974 = state_26972;
(statearr_26974[(7)] = inst_26956);

return statearr_26974;
})();
if(inst_26958){
var statearr_26975_26986 = state_26972__$1;
(statearr_26975_26986[(1)] = (3));

} else {
var statearr_26976_26987 = state_26972__$1;
(statearr_26976_26987[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26973 === (3))){
var inst_26960 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_26961 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26962 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_26963 = cljs.core.PersistentHashMap.fromArrays(inst_26961,inst_26962);
var inst_26964 = cljs.core.ex_info.call(null,inst_26960,inst_26963);
var inst_26965 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_26964);
var inst_26966 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_26972__$1 = (function (){var statearr_26977 = state_26972;
(statearr_26977[(8)] = inst_26965);

return statearr_26977;
})();
var statearr_26978_26988 = state_26972__$1;
(statearr_26978_26988[(2)] = inst_26966);

(statearr_26978_26988[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26973 === (4))){
var inst_26968 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_26972__$1 = state_26972;
var statearr_26979_26989 = state_26972__$1;
(statearr_26979_26989[(2)] = inst_26968);

(statearr_26979_26989[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26973 === (5))){
var inst_26970 = (state_26972[(2)]);
var state_26972__$1 = state_26972;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26972__$1,inst_26970);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__11469__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__11469__auto____0 = (function (){
var statearr_26980 = [null,null,null,null,null,null,null,null,null];
(statearr_26980[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__11469__auto__);

(statearr_26980[(1)] = (1));

return statearr_26980;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__11469__auto____1 = (function (state_26972){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_26972);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e26981){var ex__11472__auto__ = e26981;
var statearr_26982_26990 = state_26972;
(statearr_26982_26990[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_26972[(4)]))){
var statearr_26983_26991 = state_26972;
(statearr_26983_26991[(1)] = cljs.core.first.call(null,(state_26972[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26992 = state_26972;
state_26972 = G__26992;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__11469__auto__ = function(state_26972){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__11469__auto____1.call(this,state_26972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__11469__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__11469__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_26984 = f__11543__auto__.call(null);
(statearr_26984[(6)] = c__11542__auto___26985);

return statearr_26984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
