// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.call(null,index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.get.call(null,text,counter))){
var G__79115 = (line + (1));
var G__79116 = (1);
var G__79117 = (counter + (1));
line = G__79115;
col = G__79116;
counter = G__79117;
continue;
} else {
var G__79118 = line;
var G__79119 = (col + (1));
var G__79120 = (counter + (1));
line = G__79118;
col = G__79119;
counter = G__79120;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq.call(null,clojure.string.replace.call(null,text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_.call(null,chars)){
return "";
} else {
if(cljs.core._EQ_.call(null,n__$1,(1))){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.take_while.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.first.call(null,chars))){
var G__79121 = cljs.core.next.call(null,chars);
var G__79122 = (n__$1 - (1));
chars = G__79121;
n__$1 = G__79122;
continue;
} else {
var G__79123 = cljs.core.next.call(null,chars);
var G__79124 = n__$1;
chars = G__79123;
n__$1 = G__79124;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_.call(null,n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.call(null,cljs.core.str,cljs.core.concat.call(null,cljs.core.repeat.call(null,(n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column.call(null,new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.call(null,failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line.call(null,new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.call(null,"NOT ");

return cljs.core.print.call(null,new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.call(null,instaparse.print.char_range__GT_str.call(null,r));
} else {
if((r instanceof RegExp)){
return cljs.core.print.call(null,instaparse.print.regexp__GT_str.call(null,r));
} else {
return cljs.core.pr.call(null,r);

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__79125){
var map__79126 = p__79125;
var map__79126__$1 = (((((!((map__79126 == null))))?(((((map__79126.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__79126.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__79126):map__79126);
var line = cljs.core.get.call(null,map__79126__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__79126__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.call(null,map__79126__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.call(null,map__79126__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.call(null,["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join(''));

cljs.core.println.call(null,text);

cljs.core.println.call(null,instaparse.failure.marker.call(null,column));

var full_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,cljs.core.complement.call(null,new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count.call(null,full_reasons) + cljs.core.count.call(null,partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.call(null,(1),total)){
cljs.core.println.call(null,"Expected:");
} else {
cljs.core.println.call(null,"Expected one of:");

}
}

var seq__79128_79136 = cljs.core.seq.call(null,full_reasons);
var chunk__79129_79137 = null;
var count__79130_79138 = (0);
var i__79131_79139 = (0);
while(true){
if((i__79131_79139 < count__79130_79138)){
var r_79140 = cljs.core._nth.call(null,chunk__79129_79137,i__79131_79139);
instaparse.failure.print_reason.call(null,r_79140);

cljs.core.println.call(null," (followed by end-of-string)");


var G__79141 = seq__79128_79136;
var G__79142 = chunk__79129_79137;
var G__79143 = count__79130_79138;
var G__79144 = (i__79131_79139 + (1));
seq__79128_79136 = G__79141;
chunk__79129_79137 = G__79142;
count__79130_79138 = G__79143;
i__79131_79139 = G__79144;
continue;
} else {
var temp__5735__auto___79145 = cljs.core.seq.call(null,seq__79128_79136);
if(temp__5735__auto___79145){
var seq__79128_79146__$1 = temp__5735__auto___79145;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__79128_79146__$1)){
var c__4556__auto___79147 = cljs.core.chunk_first.call(null,seq__79128_79146__$1);
var G__79148 = cljs.core.chunk_rest.call(null,seq__79128_79146__$1);
var G__79149 = c__4556__auto___79147;
var G__79150 = cljs.core.count.call(null,c__4556__auto___79147);
var G__79151 = (0);
seq__79128_79136 = G__79148;
chunk__79129_79137 = G__79149;
count__79130_79138 = G__79150;
i__79131_79139 = G__79151;
continue;
} else {
var r_79152 = cljs.core.first.call(null,seq__79128_79146__$1);
instaparse.failure.print_reason.call(null,r_79152);

cljs.core.println.call(null," (followed by end-of-string)");


var G__79153 = cljs.core.next.call(null,seq__79128_79146__$1);
var G__79154 = null;
var G__79155 = (0);
var G__79156 = (0);
seq__79128_79136 = G__79153;
chunk__79129_79137 = G__79154;
count__79130_79138 = G__79155;
i__79131_79139 = G__79156;
continue;
}
} else {
}
}
break;
}

var seq__79132 = cljs.core.seq.call(null,partial_reasons);
var chunk__79133 = null;
var count__79134 = (0);
var i__79135 = (0);
while(true){
if((i__79135 < count__79134)){
var r = cljs.core._nth.call(null,chunk__79133,i__79135);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__79157 = seq__79132;
var G__79158 = chunk__79133;
var G__79159 = count__79134;
var G__79160 = (i__79135 + (1));
seq__79132 = G__79157;
chunk__79133 = G__79158;
count__79134 = G__79159;
i__79135 = G__79160;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__79132);
if(temp__5735__auto__){
var seq__79132__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__79132__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__79132__$1);
var G__79161 = cljs.core.chunk_rest.call(null,seq__79132__$1);
var G__79162 = c__4556__auto__;
var G__79163 = cljs.core.count.call(null,c__4556__auto__);
var G__79164 = (0);
seq__79132 = G__79161;
chunk__79133 = G__79162;
count__79134 = G__79163;
i__79135 = G__79164;
continue;
} else {
var r = cljs.core.first.call(null,seq__79132__$1);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__79165 = cljs.core.next.call(null,seq__79132__$1);
var G__79166 = null;
var G__79167 = (0);
var G__79168 = (0);
seq__79132 = G__79165;
chunk__79133 = G__79166;
count__79134 = G__79167;
i__79135 = G__79168;
continue;
}
} else {
return null;
}
}
break;
}
});
