// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__9413 = s;
var map__9413__$1 = (((((!((map__9413 == null))))?(((((map__9413.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9413.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9413):map__9413);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9413__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9413__$1,cljs.core.cst$kw$info);
var d = (0);
var G__9416 = info;
var map__9417 = G__9416;
var map__9417__$1 = (((((!((map__9417 == null))))?(((((map__9417.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9417.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9417):map__9417);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9417__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__9416__$1 = G__9416;
while(true){
var d__$2 = d__$1;
var map__9421 = G__9416__$1;
var map__9421__$1 = (((((!((map__9421 == null))))?(((((map__9421.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9421.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9421):map__9421);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9421__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__9423 = (d__$2 + (1));
var G__9424 = shadow__$1;
d__$1 = G__9423;
G__9416__$1 = G__9424;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__9425){
var map__9426 = p__9425;
var map__9426__$1 = (((((!((map__9426 == null))))?(((((map__9426.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9426.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9426):map__9426);
var name_var = map__9426__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9426__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9426__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__9428 = info;
var map__9428__$1 = (((((!((map__9428 == null))))?(((((map__9428.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9428.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9428):map__9428);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9428__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9428__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__9430 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__9430) : cljs.compiler.munge.call(null,G__9430));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__9432 = arguments.length;
switch (G__9432) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__9433 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",25,1,11501,11501,cljs.core.cst$sym$string,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__9433.cljs$core$IFn$_invoke$arity$1 ? fexpr__9433.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__9433.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__9435 = cp;
switch (G__9435) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__9437_9441 = cljs.core.seq(s);
var chunk__9438_9442 = null;
var count__9439_9443 = (0);
var i__9440_9444 = (0);
while(true){
if((i__9440_9444 < count__9439_9443)){
var c_9445 = chunk__9438_9442.cljs$core$IIndexed$_nth$arity$2(null,i__9440_9444);
sb.append(cljs.compiler.escape_char(c_9445));


var G__9446 = seq__9437_9441;
var G__9447 = chunk__9438_9442;
var G__9448 = count__9439_9443;
var G__9449 = (i__9440_9444 + (1));
seq__9437_9441 = G__9446;
chunk__9438_9442 = G__9447;
count__9439_9443 = G__9448;
i__9440_9444 = G__9449;
continue;
} else {
var temp__5735__auto___9450 = cljs.core.seq(seq__9437_9441);
if(temp__5735__auto___9450){
var seq__9437_9451__$1 = temp__5735__auto___9450;
if(cljs.core.chunked_seq_QMARK_(seq__9437_9451__$1)){
var c__4556__auto___9452 = cljs.core.chunk_first(seq__9437_9451__$1);
var G__9453 = cljs.core.chunk_rest(seq__9437_9451__$1);
var G__9454 = c__4556__auto___9452;
var G__9455 = cljs.core.count(c__4556__auto___9452);
var G__9456 = (0);
seq__9437_9441 = G__9453;
chunk__9438_9442 = G__9454;
count__9439_9443 = G__9455;
i__9440_9444 = G__9456;
continue;
} else {
var c_9457 = cljs.core.first(seq__9437_9451__$1);
sb.append(cljs.compiler.escape_char(c_9457));


var G__9458 = cljs.core.next(seq__9437_9451__$1);
var G__9459 = null;
var G__9460 = (0);
var G__9461 = (0);
seq__9437_9441 = G__9458;
chunk__9438_9442 = G__9459;
count__9439_9443 = G__9460;
i__9440_9444 = G__9461;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__9462 = cljs.core.get_global_hierarchy;
return (fexpr__9462.cljs$core$IFn$_invoke$arity$0 ? fexpr__9462.cljs$core$IFn$_invoke$arity$0() : fexpr__9462.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__9463_9470 = ast;
var map__9463_9471__$1 = (((((!((map__9463_9470 == null))))?(((((map__9463_9470.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9463_9470.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9463_9470):map__9463_9470);
var env_9472 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9463_9471__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_9472))){
var map__9465_9473 = env_9472;
var map__9465_9474__$1 = (((((!((map__9465_9473 == null))))?(((((map__9465_9473.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9465_9473.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9465_9473):map__9465_9473);
var line_9475 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9465_9474__$1,cljs.core.cst$kw$line);
var column_9476 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9465_9474__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__9467 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__9469 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__9468 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__9468.cljs$core$IFn$_invoke$arity$1 ? fexpr__9468.cljs$core$IFn$_invoke$arity$1(G__9469) : fexpr__9468.call(null,G__9469));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__9467,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__9467;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_9475 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_9476)?(column_9476 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__9485 = arguments.length;
switch (G__9485) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___9492 = arguments.length;
var i__4737__auto___9493 = (0);
while(true){
if((i__4737__auto___9493 < len__4736__auto___9492)){
args_arr__4757__auto__.push((arguments[i__4737__auto___9493]));

var G__9494 = (i__4737__auto___9493 + (1));
i__4737__auto___9493 = G__9494;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_9495 = (function (){var G__9486 = a;
if((!(typeof a === 'string'))){
return G__9486.toString();
} else {
return G__9486;
}
})();
var temp__5739__auto___9496 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___9496 == null)){
} else {
var sm_data_9497 = temp__5739__auto___9496;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_9497,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,(function (p1__9477_SHARP_){
return (p1__9477_SHARP_ + s_9495.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_9495], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__9487 = cljs.core.seq(xs);
var chunk__9488 = null;
var count__9489 = (0);
var i__9490 = (0);
while(true){
if((i__9490 < count__9489)){
var x = chunk__9488.cljs$core$IIndexed$_nth$arity$2(null,i__9490);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__9498 = seq__9487;
var G__9499 = chunk__9488;
var G__9500 = count__9489;
var G__9501 = (i__9490 + (1));
seq__9487 = G__9498;
chunk__9488 = G__9499;
count__9489 = G__9500;
i__9490 = G__9501;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__9487);
if(temp__5735__auto__){
var seq__9487__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9487__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__9487__$1);
var G__9502 = cljs.core.chunk_rest(seq__9487__$1);
var G__9503 = c__4556__auto__;
var G__9504 = cljs.core.count(c__4556__auto__);
var G__9505 = (0);
seq__9487 = G__9502;
chunk__9488 = G__9503;
count__9489 = G__9504;
i__9490 = G__9505;
continue;
} else {
var x = cljs.core.first(seq__9487__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__9506 = cljs.core.next(seq__9487__$1);
var G__9507 = null;
var G__9508 = (0);
var G__9509 = (0);
seq__9487 = G__9506;
chunk__9488 = G__9507;
count__9489 = G__9508;
i__9490 = G__9509;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq9479){
var G__9480 = cljs.core.first(seq9479);
var seq9479__$1 = cljs.core.next(seq9479);
var G__9481 = cljs.core.first(seq9479__$1);
var seq9479__$2 = cljs.core.next(seq9479__$1);
var G__9482 = cljs.core.first(seq9479__$2);
var seq9479__$3 = cljs.core.next(seq9479__$2);
var G__9483 = cljs.core.first(seq9479__$3);
var seq9479__$4 = cljs.core.next(seq9479__$3);
var G__9484 = cljs.core.first(seq9479__$4);
var seq9479__$5 = cljs.core.next(seq9479__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9480,G__9481,G__9482,G__9483,G__9484,seq9479__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__9510){
var map__9511 = p__9510;
var map__9511__$1 = (((((!((map__9511 == null))))?(((((map__9511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9511.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9511):map__9511);
var m = map__9511__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9511__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__9520 = arguments.length;
switch (G__9520) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___9526 = arguments.length;
var i__4737__auto___9527 = (0);
while(true){
if((i__4737__auto___9527 < len__4736__auto___9526)){
args_arr__4757__auto__.push((arguments[i__4737__auto___9527]));

var G__9528 = (i__4737__auto___9527 + (1));
i__4737__auto___9527 = G__9528;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__9521_9529 = cljs.core.seq(xs);
var chunk__9522_9530 = null;
var count__9523_9531 = (0);
var i__9524_9532 = (0);
while(true){
if((i__9524_9532 < count__9523_9531)){
var x_9533 = chunk__9522_9530.cljs$core$IIndexed$_nth$arity$2(null,i__9524_9532);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_9533);


var G__9534 = seq__9521_9529;
var G__9535 = chunk__9522_9530;
var G__9536 = count__9523_9531;
var G__9537 = (i__9524_9532 + (1));
seq__9521_9529 = G__9534;
chunk__9522_9530 = G__9535;
count__9523_9531 = G__9536;
i__9524_9532 = G__9537;
continue;
} else {
var temp__5735__auto___9538 = cljs.core.seq(seq__9521_9529);
if(temp__5735__auto___9538){
var seq__9521_9539__$1 = temp__5735__auto___9538;
if(cljs.core.chunked_seq_QMARK_(seq__9521_9539__$1)){
var c__4556__auto___9540 = cljs.core.chunk_first(seq__9521_9539__$1);
var G__9541 = cljs.core.chunk_rest(seq__9521_9539__$1);
var G__9542 = c__4556__auto___9540;
var G__9543 = cljs.core.count(c__4556__auto___9540);
var G__9544 = (0);
seq__9521_9529 = G__9541;
chunk__9522_9530 = G__9542;
count__9523_9531 = G__9543;
i__9524_9532 = G__9544;
continue;
} else {
var x_9545 = cljs.core.first(seq__9521_9539__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_9545);


var G__9546 = cljs.core.next(seq__9521_9539__$1);
var G__9547 = null;
var G__9548 = (0);
var G__9549 = (0);
seq__9521_9529 = G__9546;
chunk__9522_9530 = G__9547;
count__9523_9531 = G__9548;
i__9524_9532 = G__9549;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq9514){
var G__9515 = cljs.core.first(seq9514);
var seq9514__$1 = cljs.core.next(seq9514);
var G__9516 = cljs.core.first(seq9514__$1);
var seq9514__$2 = cljs.core.next(seq9514__$1);
var G__9517 = cljs.core.first(seq9514__$2);
var seq9514__$3 = cljs.core.next(seq9514__$2);
var G__9518 = cljs.core.first(seq9514__$3);
var seq9514__$4 = cljs.core.next(seq9514__$3);
var G__9519 = cljs.core.first(seq9514__$4);
var seq9514__$5 = cljs.core.next(seq9514__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9515,G__9516,G__9517,G__9518,G__9519,seq9514__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__9550_9554 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__9551_9555 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__9552_9556 = true;
var _STAR_print_fn_STAR__temp_val__9553_9557 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__9552_9556);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__9553_9557);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__9551_9555);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__9550_9554);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__9558 = cljs.core.get_global_hierarchy;
return (fexpr__9558.cljs$core$IFn$_invoke$arity$0 ? fexpr__9558.cljs$core$IFn$_invoke$arity$0() : fexpr__9558.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__9559 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9559,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9559,(1),null);
var G__9562 = ns;
var G__9563 = name;
var G__9564 = (function (){
var G__9565 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__9565) : cljs.compiler.emit_constant.call(null,G__9565));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__9562,G__9563,G__9564) : cljs.compiler.emit_record_value.call(null,G__9562,G__9563,G__9564));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__9566 = cljs.core.keys(x);
var G__9567 = cljs.core.vals(x);
var G__9568 = cljs.compiler.emit_constants_comma_sep;
var G__9569 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__9566,G__9567,G__9568,G__9569) : cljs.compiler.emit_map.call(null,G__9566,G__9567,G__9568,G__9569));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__9570 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__9571 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__9570,G__9571) : cljs.compiler.emit_with_meta.call(null,G__9570,G__9571));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__9572 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9572,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9572,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9572,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
var G__9575 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__9575) : x.call(null,G__9575));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
var G__9576 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__9576) : x.call(null,G__9576));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__9578 = items;
var G__9579 = (function (p1__9577_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__9577_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__9578,G__9579) : cljs.compiler.emit_js_object.call(null,G__9578,G__9579));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__9581){
var map__9582 = p__9581;
var map__9582__$1 = (((((!((map__9582 == null))))?(((((map__9582.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9582.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9582):map__9582);
var ast = map__9582__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9582__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9582__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9582__$1,cljs.core.cst$kw$form);
var temp__5733__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__9584 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__9584__$1 = (((((!((map__9584 == null))))?(((((map__9584.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9584.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9584):map__9584);
var cenv = map__9584__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9584__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__4126__auto__ = js_module_name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__9586 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4115__auto__ = (function (){var G__9589 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__9589) : cljs.compiler.es5_GT__EQ_.call(null,G__9589));
})();
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4115__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__9586,cljs.analyzer.es5_allowed);
} else {
return G__9586;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__4126__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__9590 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__9590,reserved);
} else {
return G__9590;
}
})();
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__9591_9592 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__9591_9593__$1 = (((G__9591_9592 instanceof cljs.core.Keyword))?G__9591_9592.fqn:null);
switch (G__9591_9593__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4115__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__9595){
var map__9596 = p__9595;
var map__9596__$1 = (((((!((map__9596 == null))))?(((((map__9596.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9596.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9596):map__9596);
var arg = map__9596__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9596__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9596__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9596__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9596__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__9598 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__9598__$1 = (((((!((map__9598 == null))))?(((((map__9598.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9598.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9598):map__9598);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9598__$1,cljs.core.cst$kw$name);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__9600){
var map__9601 = p__9600;
var map__9601__$1 = (((((!((map__9601 == null))))?(((((map__9601.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9601.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9601):map__9601);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9601__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9601__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9601__$1,cljs.core.cst$kw$env);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__9603_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__9603_SHARP_),cljs.core.cst$kw$const);
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__9604 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__9604) : comma_sep.call(null,G__9604));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__9605 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__9605) : comma_sep.call(null,G__9605));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__9606){
var map__9607 = p__9606;
var map__9607__$1 = (((((!((map__9607 == null))))?(((((map__9607.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9607.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9607):map__9607);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9607__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9607__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9607__$1,cljs.core.cst$kw$vals);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__9609){
var map__9610 = p__9609;
var map__9610__$1 = (((((!((map__9610 == null))))?(((((map__9610.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9610.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9610):map__9610);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9610__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9610__$1,cljs.core.cst$kw$env);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__9612_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__9612_SHARP_),cljs.core.cst$kw$const);
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__9613 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__9613) : comma_sep.call(null,G__9613));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__9614){
var map__9615 = p__9614;
var map__9615__$1 = (((((!((map__9615 == null))))?(((((map__9615.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9615.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9615):map__9615);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9615__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9615__$1,cljs.core.cst$kw$env);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___9639 = cljs.core.seq(items);
if(temp__5735__auto___9639){
var items_9640__$1 = temp__5735__auto___9639;
var vec__9617_9641 = items_9640__$1;
var seq__9618_9642 = cljs.core.seq(vec__9617_9641);
var first__9619_9643 = cljs.core.first(seq__9618_9642);
var seq__9618_9644__$1 = cljs.core.next(seq__9618_9642);
var vec__9620_9645 = first__9619_9643;
var k_9646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9620_9645,(0),null);
var v_9647 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9620_9645,(1),null);
var r_9648 = seq__9618_9644__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_9646),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_9647) : emit_js_object_val.call(null,v_9647)));

var seq__9623_9649 = cljs.core.seq(r_9648);
var chunk__9624_9650 = null;
var count__9625_9651 = (0);
var i__9626_9652 = (0);
while(true){
if((i__9626_9652 < count__9625_9651)){
var vec__9633_9653 = chunk__9624_9650.cljs$core$IIndexed$_nth$arity$2(null,i__9626_9652);
var k_9654__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9633_9653,(0),null);
var v_9655__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9633_9653,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_9654__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_9655__$1) : emit_js_object_val.call(null,v_9655__$1)));


var G__9656 = seq__9623_9649;
var G__9657 = chunk__9624_9650;
var G__9658 = count__9625_9651;
var G__9659 = (i__9626_9652 + (1));
seq__9623_9649 = G__9656;
chunk__9624_9650 = G__9657;
count__9625_9651 = G__9658;
i__9626_9652 = G__9659;
continue;
} else {
var temp__5735__auto___9660__$1 = cljs.core.seq(seq__9623_9649);
if(temp__5735__auto___9660__$1){
var seq__9623_9661__$1 = temp__5735__auto___9660__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9623_9661__$1)){
var c__4556__auto___9662 = cljs.core.chunk_first(seq__9623_9661__$1);
var G__9663 = cljs.core.chunk_rest(seq__9623_9661__$1);
var G__9664 = c__4556__auto___9662;
var G__9665 = cljs.core.count(c__4556__auto___9662);
var G__9666 = (0);
seq__9623_9649 = G__9663;
chunk__9624_9650 = G__9664;
count__9625_9651 = G__9665;
i__9626_9652 = G__9666;
continue;
} else {
var vec__9636_9667 = cljs.core.first(seq__9623_9661__$1);
var k_9668__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9636_9667,(0),null);
var v_9669__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9636_9667,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_9668__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_9669__$1) : emit_js_object_val.call(null,v_9669__$1)));


var G__9670 = cljs.core.next(seq__9623_9661__$1);
var G__9671 = null;
var G__9672 = (0);
var G__9673 = (0);
seq__9623_9649 = G__9670;
chunk__9624_9650 = G__9671;
count__9625_9651 = G__9672;
i__9626_9652 = G__9673;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__9674){
var map__9675 = p__9674;
var map__9675__$1 = (((((!((map__9675 == null))))?(((((map__9675.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9675.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9675):map__9675);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9675__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9675__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9675__$1,cljs.core.cst$kw$env);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__9677){
var map__9678 = p__9677;
var map__9678__$1 = (((((!((map__9678 == null))))?(((((map__9678.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9678.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9678):map__9678);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9678__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9678__$1,cljs.core.cst$kw$env);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__9680){
var map__9681 = p__9680;
var map__9681__$1 = (((((!((map__9681 == null))))?(((((map__9681.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9681.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9681):map__9681);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9681__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__9683){
var map__9684 = p__9683;
var map__9684__$1 = (((((!((map__9684 == null))))?(((((map__9684.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9684.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9684):map__9684);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9684__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9684__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__9686 = cljs.analyzer.unwrap_quote(expr);
var map__9686__$1 = (((((!((map__9686 == null))))?(((((map__9686.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9686.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9686):map__9686);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9686__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9686__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9686__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4126__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const))?(function (){var and__4115__auto__ = form;
if(cljs.core.truth_(and__4115__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4115__auto__;
}
})():false);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__9688 = cljs.analyzer.unwrap_quote(expr);
var map__9688__$1 = (((((!((map__9688 == null))))?(((((map__9688.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9688.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9688):map__9688);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9688__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9688__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9688__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4126__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__4126__auto__){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4126__auto__ = (function (){var fexpr__9691 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__9691.cljs$core$IFn$_invoke$arity$1 ? fexpr__9691.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__9691.call(null,tag));
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__9692){
var map__9693 = p__9692;
var map__9693__$1 = (((((!((map__9693 == null))))?(((((map__9693.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9693.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9693):map__9693);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9693__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9693__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9693__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9693__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9693__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4126__auto__ = unchecked;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__9695){
var map__9696 = p__9695;
var map__9696__$1 = (((((!((map__9696 == null))))?(((((map__9696.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9696.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9696):map__9696);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9696__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9696__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9696__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9696__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__9698_9734 = cljs.core.seq(nodes);
var chunk__9699_9735 = null;
var count__9700_9736 = (0);
var i__9701_9737 = (0);
while(true){
if((i__9701_9737 < count__9700_9736)){
var map__9718_9738 = chunk__9699_9735.cljs$core$IIndexed$_nth$arity$2(null,i__9701_9737);
var map__9718_9739__$1 = (((((!((map__9718_9738 == null))))?(((((map__9718_9738.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9718_9738.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9718_9738):map__9718_9738);
var ts_9740 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9718_9739__$1,cljs.core.cst$kw$tests);
var map__9719_9741 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9718_9739__$1,cljs.core.cst$kw$then);
var map__9719_9742__$1 = (((((!((map__9719_9741 == null))))?(((((map__9719_9741.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9719_9741.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9719_9741):map__9719_9741);
var then_9743 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9719_9742__$1,cljs.core.cst$kw$then);
var seq__9722_9744 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_9740));
var chunk__9723_9745 = null;
var count__9724_9746 = (0);
var i__9725_9747 = (0);
while(true){
if((i__9725_9747 < count__9724_9746)){
var test_9748 = chunk__9723_9745.cljs$core$IIndexed$_nth$arity$2(null,i__9725_9747);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_9748,":");


var G__9749 = seq__9722_9744;
var G__9750 = chunk__9723_9745;
var G__9751 = count__9724_9746;
var G__9752 = (i__9725_9747 + (1));
seq__9722_9744 = G__9749;
chunk__9723_9745 = G__9750;
count__9724_9746 = G__9751;
i__9725_9747 = G__9752;
continue;
} else {
var temp__5735__auto___9753 = cljs.core.seq(seq__9722_9744);
if(temp__5735__auto___9753){
var seq__9722_9754__$1 = temp__5735__auto___9753;
if(cljs.core.chunked_seq_QMARK_(seq__9722_9754__$1)){
var c__4556__auto___9755 = cljs.core.chunk_first(seq__9722_9754__$1);
var G__9756 = cljs.core.chunk_rest(seq__9722_9754__$1);
var G__9757 = c__4556__auto___9755;
var G__9758 = cljs.core.count(c__4556__auto___9755);
var G__9759 = (0);
seq__9722_9744 = G__9756;
chunk__9723_9745 = G__9757;
count__9724_9746 = G__9758;
i__9725_9747 = G__9759;
continue;
} else {
var test_9760 = cljs.core.first(seq__9722_9754__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_9760,":");


var G__9761 = cljs.core.next(seq__9722_9754__$1);
var G__9762 = null;
var G__9763 = (0);
var G__9764 = (0);
seq__9722_9744 = G__9761;
chunk__9723_9745 = G__9762;
count__9724_9746 = G__9763;
i__9725_9747 = G__9764;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_9743);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_9743);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__9765 = seq__9698_9734;
var G__9766 = chunk__9699_9735;
var G__9767 = count__9700_9736;
var G__9768 = (i__9701_9737 + (1));
seq__9698_9734 = G__9765;
chunk__9699_9735 = G__9766;
count__9700_9736 = G__9767;
i__9701_9737 = G__9768;
continue;
} else {
var temp__5735__auto___9769 = cljs.core.seq(seq__9698_9734);
if(temp__5735__auto___9769){
var seq__9698_9770__$1 = temp__5735__auto___9769;
if(cljs.core.chunked_seq_QMARK_(seq__9698_9770__$1)){
var c__4556__auto___9771 = cljs.core.chunk_first(seq__9698_9770__$1);
var G__9772 = cljs.core.chunk_rest(seq__9698_9770__$1);
var G__9773 = c__4556__auto___9771;
var G__9774 = cljs.core.count(c__4556__auto___9771);
var G__9775 = (0);
seq__9698_9734 = G__9772;
chunk__9699_9735 = G__9773;
count__9700_9736 = G__9774;
i__9701_9737 = G__9775;
continue;
} else {
var map__9726_9776 = cljs.core.first(seq__9698_9770__$1);
var map__9726_9777__$1 = (((((!((map__9726_9776 == null))))?(((((map__9726_9776.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9726_9776.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9726_9776):map__9726_9776);
var ts_9778 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9726_9777__$1,cljs.core.cst$kw$tests);
var map__9727_9779 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9726_9777__$1,cljs.core.cst$kw$then);
var map__9727_9780__$1 = (((((!((map__9727_9779 == null))))?(((((map__9727_9779.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9727_9779.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9727_9779):map__9727_9779);
var then_9781 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9727_9780__$1,cljs.core.cst$kw$then);
var seq__9730_9782 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_9778));
var chunk__9731_9783 = null;
var count__9732_9784 = (0);
var i__9733_9785 = (0);
while(true){
if((i__9733_9785 < count__9732_9784)){
var test_9786 = chunk__9731_9783.cljs$core$IIndexed$_nth$arity$2(null,i__9733_9785);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_9786,":");


var G__9787 = seq__9730_9782;
var G__9788 = chunk__9731_9783;
var G__9789 = count__9732_9784;
var G__9790 = (i__9733_9785 + (1));
seq__9730_9782 = G__9787;
chunk__9731_9783 = G__9788;
count__9732_9784 = G__9789;
i__9733_9785 = G__9790;
continue;
} else {
var temp__5735__auto___9791__$1 = cljs.core.seq(seq__9730_9782);
if(temp__5735__auto___9791__$1){
var seq__9730_9792__$1 = temp__5735__auto___9791__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9730_9792__$1)){
var c__4556__auto___9793 = cljs.core.chunk_first(seq__9730_9792__$1);
var G__9794 = cljs.core.chunk_rest(seq__9730_9792__$1);
var G__9795 = c__4556__auto___9793;
var G__9796 = cljs.core.count(c__4556__auto___9793);
var G__9797 = (0);
seq__9730_9782 = G__9794;
chunk__9731_9783 = G__9795;
count__9732_9784 = G__9796;
i__9733_9785 = G__9797;
continue;
} else {
var test_9798 = cljs.core.first(seq__9730_9792__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_9798,":");


var G__9799 = cljs.core.next(seq__9730_9792__$1);
var G__9800 = null;
var G__9801 = (0);
var G__9802 = (0);
seq__9730_9782 = G__9799;
chunk__9731_9783 = G__9800;
count__9732_9784 = G__9801;
i__9733_9785 = G__9802;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_9781);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_9781);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__9803 = cljs.core.next(seq__9698_9770__$1);
var G__9804 = null;
var G__9805 = (0);
var G__9806 = (0);
seq__9698_9734 = G__9803;
chunk__9699_9735 = G__9804;
count__9700_9736 = G__9805;
i__9701_9737 = G__9806;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__9807){
var map__9808 = p__9807;
var map__9808__$1 = (((((!((map__9808 == null))))?(((((map__9808.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9808.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9808):map__9808);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9808__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9808__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__9813 = env;
var G__9814 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__9813,G__9814) : cljs.compiler.resolve_type.call(null,G__9813,G__9814));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__9815 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9815,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9815,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__9810_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__9810_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__9810_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__9818 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__9818,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__9818;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__9821 = env;
var G__9822 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__9821,G__9822) : cljs.compiler.resolve_type.call(null,G__9821,G__9822));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9823_SHARP_){
return cljs.compiler.resolve_type(env,p1__9823_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__9824 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__9825 = cljs.core.seq(vec__9824);
var first__9826 = cljs.core.first(seq__9825);
var seq__9825__$1 = cljs.core.next(seq__9825);
var p = first__9826;
var first__9826__$1 = cljs.core.first(seq__9825__$1);
var seq__9825__$2 = cljs.core.next(seq__9825__$1);
var ts = first__9826__$1;
var first__9826__$2 = cljs.core.first(seq__9825__$2);
var seq__9825__$3 = cljs.core.next(seq__9825__$2);
var n = first__9826__$2;
var xs = seq__9825__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__9827 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__9828 = cljs.core.seq(vec__9827);
var first__9829 = cljs.core.first(seq__9828);
var seq__9828__$1 = cljs.core.next(seq__9828);
var p = first__9829;
var first__9829__$1 = cljs.core.first(seq__9828__$1);
var seq__9828__$2 = cljs.core.next(seq__9828__$1);
var ts = first__9829__$1;
var xs = seq__9828__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__9831 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__9830 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__9830.cljs$core$IFn$_invoke$arity$1 ? fexpr__9830.cljs$core$IFn$_invoke$arity$1(G__9831) : fexpr__9830.call(null,G__9831));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__9834 = arguments.length;
switch (G__9834) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__9842 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9832_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__9832_SHARP_);
} else {
return p1__9832_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__9843 = cljs.core.seq(vec__9842);
var first__9844 = cljs.core.first(seq__9843);
var seq__9843__$1 = cljs.core.next(seq__9843);
var x = first__9844;
var ys = seq__9843__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__9845 = cljs.core.seq(ys);
var chunk__9846 = null;
var count__9847 = (0);
var i__9848 = (0);
while(true){
if((i__9848 < count__9847)){
var next_line = chunk__9846.cljs$core$IIndexed$_nth$arity$2(null,i__9848);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__9854 = seq__9845;
var G__9855 = chunk__9846;
var G__9856 = count__9847;
var G__9857 = (i__9848 + (1));
seq__9845 = G__9854;
chunk__9846 = G__9855;
count__9847 = G__9856;
i__9848 = G__9857;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__9845);
if(temp__5735__auto__){
var seq__9845__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9845__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__9845__$1);
var G__9858 = cljs.core.chunk_rest(seq__9845__$1);
var G__9859 = c__4556__auto__;
var G__9860 = cljs.core.count(c__4556__auto__);
var G__9861 = (0);
seq__9845 = G__9858;
chunk__9846 = G__9859;
count__9847 = G__9860;
i__9848 = G__9861;
continue;
} else {
var next_line = cljs.core.first(seq__9845__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__9862 = cljs.core.next(seq__9845__$1);
var G__9863 = null;
var G__9864 = (0);
var G__9865 = (0);
seq__9845 = G__9862;
chunk__9846 = G__9863;
count__9847 = G__9864;
i__9848 = G__9865;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__9849_9866 = cljs.core.seq(docs__$2);
var chunk__9850_9867 = null;
var count__9851_9868 = (0);
var i__9852_9869 = (0);
while(true){
if((i__9852_9869 < count__9851_9868)){
var e_9870 = chunk__9850_9867.cljs$core$IIndexed$_nth$arity$2(null,i__9852_9869);
if(cljs.core.truth_(e_9870)){
print_comment_lines(e_9870);
} else {
}


var G__9871 = seq__9849_9866;
var G__9872 = chunk__9850_9867;
var G__9873 = count__9851_9868;
var G__9874 = (i__9852_9869 + (1));
seq__9849_9866 = G__9871;
chunk__9850_9867 = G__9872;
count__9851_9868 = G__9873;
i__9852_9869 = G__9874;
continue;
} else {
var temp__5735__auto___9875 = cljs.core.seq(seq__9849_9866);
if(temp__5735__auto___9875){
var seq__9849_9876__$1 = temp__5735__auto___9875;
if(cljs.core.chunked_seq_QMARK_(seq__9849_9876__$1)){
var c__4556__auto___9877 = cljs.core.chunk_first(seq__9849_9876__$1);
var G__9878 = cljs.core.chunk_rest(seq__9849_9876__$1);
var G__9879 = c__4556__auto___9877;
var G__9880 = cljs.core.count(c__4556__auto___9877);
var G__9881 = (0);
seq__9849_9866 = G__9878;
chunk__9850_9867 = G__9879;
count__9851_9868 = G__9880;
i__9852_9869 = G__9881;
continue;
} else {
var e_9882 = cljs.core.first(seq__9849_9876__$1);
if(cljs.core.truth_(e_9882)){
print_comment_lines(e_9882);
} else {
}


var G__9883 = cljs.core.next(seq__9849_9876__$1);
var G__9884 = null;
var G__9885 = (0);
var G__9886 = (0);
seq__9849_9866 = G__9883;
chunk__9850_9867 = G__9884;
count__9851_9868 = G__9885;
i__9852_9869 = G__9886;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__4115__auto__ = cljs.core.some((function (p1__9888_SHARP_){
return goog.string.startsWith(p1__9888_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = opts;
if(cljs.core.truth_(and__4115__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none)){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__9889){
var map__9890 = p__9889;
var map__9890__$1 = (((((!((map__9890 == null))))?(((((map__9890.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9890.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9890):map__9890);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9890__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9890__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9890__$1,cljs.core.cst$kw$test);
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9890__$1,cljs.core.cst$kw$goog_DASH_define);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9890__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9890__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9890__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9890__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9890__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9890__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__4126__auto__ = init;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
return test;
} else {
return and__4115__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__9892){
var map__9893 = p__9892;
var map__9893__$1 = (((((!((map__9893 == null))))?(((((map__9893.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9893.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9893):map__9893);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9893__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9893__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9893__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__9895_9919 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__9896_9920 = null;
var count__9897_9921 = (0);
var i__9898_9922 = (0);
while(true){
if((i__9898_9922 < count__9897_9921)){
var vec__9905_9923 = chunk__9896_9920.cljs$core$IIndexed$_nth$arity$2(null,i__9898_9922);
var i_9924 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9905_9923,(0),null);
var param_9925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9905_9923,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_9925);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__9926 = seq__9895_9919;
var G__9927 = chunk__9896_9920;
var G__9928 = count__9897_9921;
var G__9929 = (i__9898_9922 + (1));
seq__9895_9919 = G__9926;
chunk__9896_9920 = G__9927;
count__9897_9921 = G__9928;
i__9898_9922 = G__9929;
continue;
} else {
var temp__5735__auto___9930 = cljs.core.seq(seq__9895_9919);
if(temp__5735__auto___9930){
var seq__9895_9931__$1 = temp__5735__auto___9930;
if(cljs.core.chunked_seq_QMARK_(seq__9895_9931__$1)){
var c__4556__auto___9932 = cljs.core.chunk_first(seq__9895_9931__$1);
var G__9933 = cljs.core.chunk_rest(seq__9895_9931__$1);
var G__9934 = c__4556__auto___9932;
var G__9935 = cljs.core.count(c__4556__auto___9932);
var G__9936 = (0);
seq__9895_9919 = G__9933;
chunk__9896_9920 = G__9934;
count__9897_9921 = G__9935;
i__9898_9922 = G__9936;
continue;
} else {
var vec__9908_9937 = cljs.core.first(seq__9895_9931__$1);
var i_9938 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9908_9937,(0),null);
var param_9939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9908_9937,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_9939);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__9940 = cljs.core.next(seq__9895_9931__$1);
var G__9941 = null;
var G__9942 = (0);
var G__9943 = (0);
seq__9895_9919 = G__9940;
chunk__9896_9920 = G__9941;
count__9897_9921 = G__9942;
i__9898_9922 = G__9943;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__9911_9944 = cljs.core.seq(params);
var chunk__9912_9945 = null;
var count__9913_9946 = (0);
var i__9914_9947 = (0);
while(true){
if((i__9914_9947 < count__9913_9946)){
var param_9948 = chunk__9912_9945.cljs$core$IIndexed$_nth$arity$2(null,i__9914_9947);
cljs.compiler.emit(param_9948);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_9948,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9949 = seq__9911_9944;
var G__9950 = chunk__9912_9945;
var G__9951 = count__9913_9946;
var G__9952 = (i__9914_9947 + (1));
seq__9911_9944 = G__9949;
chunk__9912_9945 = G__9950;
count__9913_9946 = G__9951;
i__9914_9947 = G__9952;
continue;
} else {
var temp__5735__auto___9953 = cljs.core.seq(seq__9911_9944);
if(temp__5735__auto___9953){
var seq__9911_9954__$1 = temp__5735__auto___9953;
if(cljs.core.chunked_seq_QMARK_(seq__9911_9954__$1)){
var c__4556__auto___9955 = cljs.core.chunk_first(seq__9911_9954__$1);
var G__9956 = cljs.core.chunk_rest(seq__9911_9954__$1);
var G__9957 = c__4556__auto___9955;
var G__9958 = cljs.core.count(c__4556__auto___9955);
var G__9959 = (0);
seq__9911_9944 = G__9956;
chunk__9912_9945 = G__9957;
count__9913_9946 = G__9958;
i__9914_9947 = G__9959;
continue;
} else {
var param_9960 = cljs.core.first(seq__9911_9954__$1);
cljs.compiler.emit(param_9960);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_9960,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9961 = cljs.core.next(seq__9911_9954__$1);
var G__9962 = null;
var G__9963 = (0);
var G__9964 = (0);
seq__9911_9944 = G__9961;
chunk__9912_9945 = G__9962;
count__9913_9946 = G__9963;
i__9914_9947 = G__9964;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__9915_9965 = cljs.core.seq(params);
var chunk__9916_9966 = null;
var count__9917_9967 = (0);
var i__9918_9968 = (0);
while(true){
if((i__9918_9968 < count__9917_9967)){
var param_9969 = chunk__9916_9966.cljs$core$IIndexed$_nth$arity$2(null,i__9918_9968);
cljs.compiler.emit(param_9969);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_9969,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9970 = seq__9915_9965;
var G__9971 = chunk__9916_9966;
var G__9972 = count__9917_9967;
var G__9973 = (i__9918_9968 + (1));
seq__9915_9965 = G__9970;
chunk__9916_9966 = G__9971;
count__9917_9967 = G__9972;
i__9918_9968 = G__9973;
continue;
} else {
var temp__5735__auto___9974 = cljs.core.seq(seq__9915_9965);
if(temp__5735__auto___9974){
var seq__9915_9975__$1 = temp__5735__auto___9974;
if(cljs.core.chunked_seq_QMARK_(seq__9915_9975__$1)){
var c__4556__auto___9976 = cljs.core.chunk_first(seq__9915_9975__$1);
var G__9977 = cljs.core.chunk_rest(seq__9915_9975__$1);
var G__9978 = c__4556__auto___9976;
var G__9979 = cljs.core.count(c__4556__auto___9976);
var G__9980 = (0);
seq__9915_9965 = G__9977;
chunk__9916_9966 = G__9978;
count__9917_9967 = G__9979;
i__9918_9968 = G__9980;
continue;
} else {
var param_9981 = cljs.core.first(seq__9915_9975__$1);
cljs.compiler.emit(param_9981);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_9981,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9982 = cljs.core.next(seq__9915_9975__$1);
var G__9983 = null;
var G__9984 = (0);
var G__9985 = (0);
seq__9915_9965 = G__9982;
chunk__9916_9966 = G__9983;
count__9917_9967 = G__9984;
i__9918_9968 = G__9985;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__9986 = cljs.core.seq(params);
var chunk__9987 = null;
var count__9988 = (0);
var i__9989 = (0);
while(true){
if((i__9989 < count__9988)){
var param = chunk__9987.cljs$core$IIndexed$_nth$arity$2(null,i__9989);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9990 = seq__9986;
var G__9991 = chunk__9987;
var G__9992 = count__9988;
var G__9993 = (i__9989 + (1));
seq__9986 = G__9990;
chunk__9987 = G__9991;
count__9988 = G__9992;
i__9989 = G__9993;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__9986);
if(temp__5735__auto__){
var seq__9986__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9986__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__9986__$1);
var G__9994 = cljs.core.chunk_rest(seq__9986__$1);
var G__9995 = c__4556__auto__;
var G__9996 = cljs.core.count(c__4556__auto__);
var G__9997 = (0);
seq__9986 = G__9994;
chunk__9987 = G__9995;
count__9988 = G__9996;
i__9989 = G__9997;
continue;
} else {
var param = cljs.core.first(seq__9986__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9998 = cljs.core.next(seq__9986__$1);
var G__9999 = null;
var G__10000 = (0);
var G__10001 = (0);
seq__9986 = G__9998;
chunk__9987 = G__9999;
count__9988 = G__10000;
i__9989 = G__10001;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__10002){
var map__10003 = p__10002;
var map__10003__$1 = (((((!((map__10003 == null))))?(((((map__10003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10003.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10003):map__10003);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10003__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10003__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10003__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10003__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10003__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10003__$1,cljs.core.cst$kw$recurs);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__10005){
var map__10006 = p__10005;
var map__10006__$1 = (((((!((map__10006 == null))))?(((((map__10006.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10006.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10006):map__10006);
var f = map__10006__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10006__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10006__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10006__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10006__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10006__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10006__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10006__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10006__$1,cljs.core.cst$kw$recurs);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_10016__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_10017 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_10016__$1);
var delegate_name_10018 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_10017),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_10018," = function (");

var seq__10008_10019 = cljs.core.seq(params);
var chunk__10009_10020 = null;
var count__10010_10021 = (0);
var i__10011_10022 = (0);
while(true){
if((i__10011_10022 < count__10010_10021)){
var param_10023 = chunk__10009_10020.cljs$core$IIndexed$_nth$arity$2(null,i__10011_10022);
cljs.compiler.emit(param_10023);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10023,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10024 = seq__10008_10019;
var G__10025 = chunk__10009_10020;
var G__10026 = count__10010_10021;
var G__10027 = (i__10011_10022 + (1));
seq__10008_10019 = G__10024;
chunk__10009_10020 = G__10025;
count__10010_10021 = G__10026;
i__10011_10022 = G__10027;
continue;
} else {
var temp__5735__auto___10028 = cljs.core.seq(seq__10008_10019);
if(temp__5735__auto___10028){
var seq__10008_10029__$1 = temp__5735__auto___10028;
if(cljs.core.chunked_seq_QMARK_(seq__10008_10029__$1)){
var c__4556__auto___10030 = cljs.core.chunk_first(seq__10008_10029__$1);
var G__10031 = cljs.core.chunk_rest(seq__10008_10029__$1);
var G__10032 = c__4556__auto___10030;
var G__10033 = cljs.core.count(c__4556__auto___10030);
var G__10034 = (0);
seq__10008_10019 = G__10031;
chunk__10009_10020 = G__10032;
count__10010_10021 = G__10033;
i__10011_10022 = G__10034;
continue;
} else {
var param_10035 = cljs.core.first(seq__10008_10029__$1);
cljs.compiler.emit(param_10035);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10035,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10036 = cljs.core.next(seq__10008_10029__$1);
var G__10037 = null;
var G__10038 = (0);
var G__10039 = (0);
seq__10008_10019 = G__10036;
chunk__10009_10020 = G__10037;
count__10010_10021 = G__10038;
i__10011_10022 = G__10039;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_10017," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_10040 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_10040,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_10018,".call(this,");

var seq__10012_10041 = cljs.core.seq(params);
var chunk__10013_10042 = null;
var count__10014_10043 = (0);
var i__10015_10044 = (0);
while(true){
if((i__10015_10044 < count__10014_10043)){
var param_10045 = chunk__10013_10042.cljs$core$IIndexed$_nth$arity$2(null,i__10015_10044);
cljs.compiler.emit(param_10045);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10045,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10046 = seq__10012_10041;
var G__10047 = chunk__10013_10042;
var G__10048 = count__10014_10043;
var G__10049 = (i__10015_10044 + (1));
seq__10012_10041 = G__10046;
chunk__10013_10042 = G__10047;
count__10014_10043 = G__10048;
i__10015_10044 = G__10049;
continue;
} else {
var temp__5735__auto___10050 = cljs.core.seq(seq__10012_10041);
if(temp__5735__auto___10050){
var seq__10012_10051__$1 = temp__5735__auto___10050;
if(cljs.core.chunked_seq_QMARK_(seq__10012_10051__$1)){
var c__4556__auto___10052 = cljs.core.chunk_first(seq__10012_10051__$1);
var G__10053 = cljs.core.chunk_rest(seq__10012_10051__$1);
var G__10054 = c__4556__auto___10052;
var G__10055 = cljs.core.count(c__4556__auto___10052);
var G__10056 = (0);
seq__10012_10041 = G__10053;
chunk__10013_10042 = G__10054;
count__10014_10043 = G__10055;
i__10015_10044 = G__10056;
continue;
} else {
var param_10057 = cljs.core.first(seq__10012_10051__$1);
cljs.compiler.emit(param_10057);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10057,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10058 = cljs.core.next(seq__10012_10051__$1);
var G__10059 = null;
var G__10060 = (0);
var G__10061 = (0);
seq__10012_10041 = G__10058;
chunk__10013_10042 = G__10059;
count__10014_10043 = G__10060;
i__10015_10044 = G__10061;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10017,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_10017,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_10016__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10017,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_10018,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_10017,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__10065){
var map__10066 = p__10065;
var map__10066__$1 = (((((!((map__10066 == null))))?(((((map__10066.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10066.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10066):map__10066);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10066__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10066__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10066__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10066__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10066__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10066__$1,cljs.core.cst$kw$recur_DASH_frames);
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10066__$1,cljs.core.cst$kw$in_DASH_loop);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10066__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__10062_SHARP_){
var and__4115__auto__ = p1__10062_SHARP_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__10062_SHARP_));
} else {
return and__4115__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4126__auto__ = in_loop;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_10119__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_10120 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_10119__$1);
var maxparams_10121 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_10122 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_10120),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_10123 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__10063_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__10063_SHARP_)));
}),cljs.core.seq(mmap_10122));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_10120," = null;");

var seq__10068_10124 = cljs.core.seq(ms_10123);
var chunk__10069_10125 = null;
var count__10070_10126 = (0);
var i__10071_10127 = (0);
while(true){
if((i__10071_10127 < count__10070_10126)){
var vec__10078_10128 = chunk__10069_10125.cljs$core$IIndexed$_nth$arity$2(null,i__10071_10127);
var n_10129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10078_10128,(0),null);
var meth_10130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10078_10128,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_10129," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10130))){
cljs.compiler.emit_variadic_fn_method(meth_10130);
} else {
cljs.compiler.emit_fn_method(meth_10130);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__10131 = seq__10068_10124;
var G__10132 = chunk__10069_10125;
var G__10133 = count__10070_10126;
var G__10134 = (i__10071_10127 + (1));
seq__10068_10124 = G__10131;
chunk__10069_10125 = G__10132;
count__10070_10126 = G__10133;
i__10071_10127 = G__10134;
continue;
} else {
var temp__5735__auto___10135 = cljs.core.seq(seq__10068_10124);
if(temp__5735__auto___10135){
var seq__10068_10136__$1 = temp__5735__auto___10135;
if(cljs.core.chunked_seq_QMARK_(seq__10068_10136__$1)){
var c__4556__auto___10137 = cljs.core.chunk_first(seq__10068_10136__$1);
var G__10138 = cljs.core.chunk_rest(seq__10068_10136__$1);
var G__10139 = c__4556__auto___10137;
var G__10140 = cljs.core.count(c__4556__auto___10137);
var G__10141 = (0);
seq__10068_10124 = G__10138;
chunk__10069_10125 = G__10139;
count__10070_10126 = G__10140;
i__10071_10127 = G__10141;
continue;
} else {
var vec__10081_10142 = cljs.core.first(seq__10068_10136__$1);
var n_10143 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10081_10142,(0),null);
var meth_10144 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10081_10142,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_10143," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10144))){
cljs.compiler.emit_variadic_fn_method(meth_10144);
} else {
cljs.compiler.emit_fn_method(meth_10144);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__10145 = cljs.core.next(seq__10068_10136__$1);
var G__10146 = null;
var G__10147 = (0);
var G__10148 = (0);
seq__10068_10124 = G__10145;
chunk__10069_10125 = G__10146;
count__10070_10126 = G__10147;
i__10071_10127 = G__10148;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10120," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_10121),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_10121)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_10121));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__10084_10149 = cljs.core.seq(ms_10123);
var chunk__10085_10150 = null;
var count__10086_10151 = (0);
var i__10087_10152 = (0);
while(true){
if((i__10087_10152 < count__10086_10151)){
var vec__10094_10153 = chunk__10085_10150.cljs$core$IIndexed$_nth$arity$2(null,i__10087_10152);
var n_10154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10094_10153,(0),null);
var meth_10155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10094_10153,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10155))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_10156 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_10156," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_10157 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_10156," = new cljs.core.IndexedSeq(",a_10157,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_10154,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_10121)),(((cljs.core.count(maxparams_10121) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_10156,");"], 0));
} else {
var pcnt_10158 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10155));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_10158,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_10154,".call(this",(((pcnt_10158 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_10158,maxparams_10121)),null,(1),null)),(2),null))),");");
}


var G__10159 = seq__10084_10149;
var G__10160 = chunk__10085_10150;
var G__10161 = count__10086_10151;
var G__10162 = (i__10087_10152 + (1));
seq__10084_10149 = G__10159;
chunk__10085_10150 = G__10160;
count__10086_10151 = G__10161;
i__10087_10152 = G__10162;
continue;
} else {
var temp__5735__auto___10163 = cljs.core.seq(seq__10084_10149);
if(temp__5735__auto___10163){
var seq__10084_10164__$1 = temp__5735__auto___10163;
if(cljs.core.chunked_seq_QMARK_(seq__10084_10164__$1)){
var c__4556__auto___10165 = cljs.core.chunk_first(seq__10084_10164__$1);
var G__10166 = cljs.core.chunk_rest(seq__10084_10164__$1);
var G__10167 = c__4556__auto___10165;
var G__10168 = cljs.core.count(c__4556__auto___10165);
var G__10169 = (0);
seq__10084_10149 = G__10166;
chunk__10085_10150 = G__10167;
count__10086_10151 = G__10168;
i__10087_10152 = G__10169;
continue;
} else {
var vec__10097_10170 = cljs.core.first(seq__10084_10164__$1);
var n_10171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10097_10170,(0),null);
var meth_10172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10097_10170,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10172))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_10173 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_10173," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_10174 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_10173," = new cljs.core.IndexedSeq(",a_10174,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_10171,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_10121)),(((cljs.core.count(maxparams_10121) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_10173,");"], 0));
} else {
var pcnt_10175 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10172));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_10175,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_10171,".call(this",(((pcnt_10175 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_10175,maxparams_10121)),null,(1),null)),(2),null))),");");
}


var G__10176 = cljs.core.next(seq__10084_10164__$1);
var G__10177 = null;
var G__10178 = (0);
var G__10179 = (0);
seq__10084_10149 = G__10176;
chunk__10085_10150 = G__10177;
count__10086_10151 = G__10178;
i__10087_10152 = G__10179;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_10180 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_10123)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_10180,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10120,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10120,".cljs$lang$applyTo = ",cljs.core.some((function (p1__10064_SHARP_){
var vec__10100 = p1__10064_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10100,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10100,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_10123),".cljs$lang$applyTo;");
} else {
}

var seq__10103_10181 = cljs.core.seq(ms_10123);
var chunk__10104_10182 = null;
var count__10105_10183 = (0);
var i__10106_10184 = (0);
while(true){
if((i__10106_10184 < count__10105_10183)){
var vec__10113_10185 = chunk__10104_10182.cljs$core$IIndexed$_nth$arity$2(null,i__10106_10184);
var n_10186 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10113_10185,(0),null);
var meth_10187 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10113_10185,(1),null);
var c_10188 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10187));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10187))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10120,".cljs$core$IFn$_invoke$arity$variadic = ",n_10186,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_10120,".cljs$core$IFn$_invoke$arity$",c_10188," = ",n_10186,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__10189 = seq__10103_10181;
var G__10190 = chunk__10104_10182;
var G__10191 = count__10105_10183;
var G__10192 = (i__10106_10184 + (1));
seq__10103_10181 = G__10189;
chunk__10104_10182 = G__10190;
count__10105_10183 = G__10191;
i__10106_10184 = G__10192;
continue;
} else {
var temp__5735__auto___10193 = cljs.core.seq(seq__10103_10181);
if(temp__5735__auto___10193){
var seq__10103_10194__$1 = temp__5735__auto___10193;
if(cljs.core.chunked_seq_QMARK_(seq__10103_10194__$1)){
var c__4556__auto___10195 = cljs.core.chunk_first(seq__10103_10194__$1);
var G__10196 = cljs.core.chunk_rest(seq__10103_10194__$1);
var G__10197 = c__4556__auto___10195;
var G__10198 = cljs.core.count(c__4556__auto___10195);
var G__10199 = (0);
seq__10103_10181 = G__10196;
chunk__10104_10182 = G__10197;
count__10105_10183 = G__10198;
i__10106_10184 = G__10199;
continue;
} else {
var vec__10116_10200 = cljs.core.first(seq__10103_10194__$1);
var n_10201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10116_10200,(0),null);
var meth_10202 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10116_10200,(1),null);
var c_10203 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10202));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10202))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10120,".cljs$core$IFn$_invoke$arity$variadic = ",n_10201,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_10120,".cljs$core$IFn$_invoke$arity$",c_10203," = ",n_10201,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__10204 = cljs.core.next(seq__10103_10194__$1);
var G__10205 = null;
var G__10206 = (0);
var G__10207 = (0);
seq__10103_10181 = G__10204;
chunk__10104_10182 = G__10205;
count__10105_10183 = G__10206;
i__10106_10184 = G__10207;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_10120,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__10208){
var map__10209 = p__10208;
var map__10209__$1 = (((((!((map__10209 == null))))?(((((map__10209.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10209.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10209):map__10209);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10209__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10209__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10209__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__10211_10215 = cljs.core.seq(statements);
var chunk__10212_10216 = null;
var count__10213_10217 = (0);
var i__10214_10218 = (0);
while(true){
if((i__10214_10218 < count__10213_10217)){
var s_10219 = chunk__10212_10216.cljs$core$IIndexed$_nth$arity$2(null,i__10214_10218);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_10219);


var G__10220 = seq__10211_10215;
var G__10221 = chunk__10212_10216;
var G__10222 = count__10213_10217;
var G__10223 = (i__10214_10218 + (1));
seq__10211_10215 = G__10220;
chunk__10212_10216 = G__10221;
count__10213_10217 = G__10222;
i__10214_10218 = G__10223;
continue;
} else {
var temp__5735__auto___10224 = cljs.core.seq(seq__10211_10215);
if(temp__5735__auto___10224){
var seq__10211_10225__$1 = temp__5735__auto___10224;
if(cljs.core.chunked_seq_QMARK_(seq__10211_10225__$1)){
var c__4556__auto___10226 = cljs.core.chunk_first(seq__10211_10225__$1);
var G__10227 = cljs.core.chunk_rest(seq__10211_10225__$1);
var G__10228 = c__4556__auto___10226;
var G__10229 = cljs.core.count(c__4556__auto___10226);
var G__10230 = (0);
seq__10211_10215 = G__10227;
chunk__10212_10216 = G__10228;
count__10213_10217 = G__10229;
i__10214_10218 = G__10230;
continue;
} else {
var s_10231 = cljs.core.first(seq__10211_10225__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_10231);


var G__10232 = cljs.core.next(seq__10211_10225__$1);
var G__10233 = null;
var G__10234 = (0);
var G__10235 = (0);
seq__10211_10215 = G__10232;
chunk__10212_10216 = G__10233;
count__10213_10217 = G__10234;
i__10214_10218 = G__10235;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__10236){
var map__10237 = p__10236;
var map__10237__$1 = (((((!((map__10237 == null))))?(((((map__10237.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10237.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10237):map__10237);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10237__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10237__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10237__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10237__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10237__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__10239,is_loop){
var map__10240 = p__10239;
var map__10240__$1 = (((((!((map__10240 == null))))?(((((map__10240.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10240.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10240):map__10240);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10240__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10240__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10240__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__10242_10256 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__10243_10257 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__10243_10257);

try{var seq__10244_10258 = cljs.core.seq(bindings);
var chunk__10245_10259 = null;
var count__10246_10260 = (0);
var i__10247_10261 = (0);
while(true){
if((i__10247_10261 < count__10246_10260)){
var map__10252_10262 = chunk__10245_10259.cljs$core$IIndexed$_nth$arity$2(null,i__10247_10261);
var map__10252_10263__$1 = (((((!((map__10252_10262 == null))))?(((((map__10252_10262.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10252_10262.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10252_10262):map__10252_10262);
var binding_10264 = map__10252_10263__$1;
var init_10265 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10252_10263__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_10264);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_10265,";");


var G__10266 = seq__10244_10258;
var G__10267 = chunk__10245_10259;
var G__10268 = count__10246_10260;
var G__10269 = (i__10247_10261 + (1));
seq__10244_10258 = G__10266;
chunk__10245_10259 = G__10267;
count__10246_10260 = G__10268;
i__10247_10261 = G__10269;
continue;
} else {
var temp__5735__auto___10270 = cljs.core.seq(seq__10244_10258);
if(temp__5735__auto___10270){
var seq__10244_10271__$1 = temp__5735__auto___10270;
if(cljs.core.chunked_seq_QMARK_(seq__10244_10271__$1)){
var c__4556__auto___10272 = cljs.core.chunk_first(seq__10244_10271__$1);
var G__10273 = cljs.core.chunk_rest(seq__10244_10271__$1);
var G__10274 = c__4556__auto___10272;
var G__10275 = cljs.core.count(c__4556__auto___10272);
var G__10276 = (0);
seq__10244_10258 = G__10273;
chunk__10245_10259 = G__10274;
count__10246_10260 = G__10275;
i__10247_10261 = G__10276;
continue;
} else {
var map__10254_10277 = cljs.core.first(seq__10244_10271__$1);
var map__10254_10278__$1 = (((((!((map__10254_10277 == null))))?(((((map__10254_10277.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10254_10277.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10254_10277):map__10254_10277);
var binding_10279 = map__10254_10278__$1;
var init_10280 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10254_10278__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_10279);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_10280,";");


var G__10281 = cljs.core.next(seq__10244_10271__$1);
var G__10282 = null;
var G__10283 = (0);
var G__10284 = (0);
seq__10244_10258 = G__10281;
chunk__10245_10259 = G__10282;
count__10246_10260 = G__10283;
i__10247_10261 = G__10284;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__10242_10256);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__10285){
var map__10286 = p__10285;
var map__10286__$1 = (((((!((map__10286 == null))))?(((((map__10286.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10286.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10286):map__10286);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10286__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10286__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10286__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__4613__auto___10288 = cljs.core.count(exprs);
var i_10289 = (0);
while(true){
if((i_10289 < n__4613__auto___10288)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_10289) : temps.call(null,i_10289))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_10289) : exprs.call(null,i_10289)),";");

var G__10290 = (i_10289 + (1));
i_10289 = G__10290;
continue;
} else {
}
break;
}

var n__4613__auto___10291 = cljs.core.count(exprs);
var i_10292 = (0);
while(true){
if((i_10292 < n__4613__auto___10291)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_10292) : params.call(null,i_10292)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_10292) : temps.call(null,i_10292)),";");

var G__10293 = (i_10292 + (1));
i_10292 = G__10293;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__10294){
var map__10295 = p__10294;
var map__10295__$1 = (((((!((map__10295 == null))))?(((((map__10295.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10295.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10295):map__10295);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10295__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10295__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10295__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__10297_10309 = cljs.core.seq(bindings);
var chunk__10298_10310 = null;
var count__10299_10311 = (0);
var i__10300_10312 = (0);
while(true){
if((i__10300_10312 < count__10299_10311)){
var map__10305_10313 = chunk__10298_10310.cljs$core$IIndexed$_nth$arity$2(null,i__10300_10312);
var map__10305_10314__$1 = (((((!((map__10305_10313 == null))))?(((((map__10305_10313.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10305_10313.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10305_10313):map__10305_10313);
var binding_10315 = map__10305_10314__$1;
var init_10316 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10305_10314__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_10315)," = ",init_10316,";");


var G__10317 = seq__10297_10309;
var G__10318 = chunk__10298_10310;
var G__10319 = count__10299_10311;
var G__10320 = (i__10300_10312 + (1));
seq__10297_10309 = G__10317;
chunk__10298_10310 = G__10318;
count__10299_10311 = G__10319;
i__10300_10312 = G__10320;
continue;
} else {
var temp__5735__auto___10321 = cljs.core.seq(seq__10297_10309);
if(temp__5735__auto___10321){
var seq__10297_10322__$1 = temp__5735__auto___10321;
if(cljs.core.chunked_seq_QMARK_(seq__10297_10322__$1)){
var c__4556__auto___10323 = cljs.core.chunk_first(seq__10297_10322__$1);
var G__10324 = cljs.core.chunk_rest(seq__10297_10322__$1);
var G__10325 = c__4556__auto___10323;
var G__10326 = cljs.core.count(c__4556__auto___10323);
var G__10327 = (0);
seq__10297_10309 = G__10324;
chunk__10298_10310 = G__10325;
count__10299_10311 = G__10326;
i__10300_10312 = G__10327;
continue;
} else {
var map__10307_10328 = cljs.core.first(seq__10297_10322__$1);
var map__10307_10329__$1 = (((((!((map__10307_10328 == null))))?(((((map__10307_10328.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10307_10328.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10307_10328):map__10307_10328);
var binding_10330 = map__10307_10329__$1;
var init_10331 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10307_10329__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_10330)," = ",init_10331,";");


var G__10332 = cljs.core.next(seq__10297_10322__$1);
var G__10333 = null;
var G__10334 = (0);
var G__10335 = (0);
seq__10297_10309 = G__10332;
chunk__10298_10310 = G__10333;
count__10299_10311 = G__10334;
i__10300_10312 = G__10335;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__10338){
var map__10339 = p__10338;
var map__10339__$1 = (((((!((map__10339 == null))))?(((((map__10339.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10339.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10339):map__10339);
var expr = map__10339__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10339__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10339__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10339__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
if(cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info))){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4115__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4115__auto__ = protocol;
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = tag;
if(cljs.core.truth_(and__4115__auto____$1)){
var or__4126__auto__ = (function (){var and__4115__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto____$2)){
var and__4115__auto____$3 = protocol;
if(cljs.core.truth_(and__4115__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__4115__auto____$3;
}
} else {
return and__4115__auto____$2;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto____$2 = (function (){var or__4126__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4115__auto____$2)){
var or__4126__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__10351 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__10351.cljs$core$IFn$_invoke$arity$1 ? fexpr__10351.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__10351.call(null,tag));
})())){
var temp__5735__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true)));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4115__auto____$2;
}
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,cljs.core.cst$sym$boolean)));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_count)) && (cljs.core.boolean$((function (){var fexpr__10353 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null"], null), null);
return (fexpr__10353.cljs$core$IFn$_invoke$arity$1 ? fexpr__10353.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__10353.call(null,first_arg_tag));
})())));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math);
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
return cljs.core.cst$kw$foreign.cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4126__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,ftag);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__10341 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (arity > mfa);
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__10336_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__10336_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__10337_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__10337_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10341,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10341,(1),null);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_10356 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_10356,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_10357 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_10357,args)),(((mfa_10357 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_10357,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
var G__10355 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__10354 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__10354.cljs$core$IFn$_invoke$arity$1 ? fexpr__10354.cljs$core$IFn$_invoke$arity$1(G__10355) : fexpr__10354.call(null,G__10355));
} else {
return and__4115__auto__;
}
})())){
var fprop_10358 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_10358," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_10358,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_10358," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_10358,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__10359){
var map__10360 = p__10359;
var map__10360__$1 = (((((!((map__10360 == null))))?(((((map__10360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10360.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10360):map__10360);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10360__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10360__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10360__$1,cljs.core.cst$kw$env);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__10362){
var map__10363 = p__10362;
var map__10363__$1 = (((((!((map__10363 == null))))?(((((map__10363.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10363.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10363):map__10363);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10363__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10363__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10363__$1,cljs.core.cst$kw$env);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__10365 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__10365__$1 = (((((!((map__10365 == null))))?(((((map__10365.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10365.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10365):map__10365);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10365__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10365__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__10366 = options;
var map__10366__$1 = (((((!((map__10366 == null))))?(((((map__10366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10366.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10366):map__10366);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10366__$1,cljs.core.cst$kw$target);
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10366__$1,cljs.core.cst$kw$nodejs_DASH_rt);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10366__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__10367 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__10372 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__10372__$1 = (((((!((map__10372 == null))))?(((((map__10372.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10372.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10372):map__10372);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10372__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10372__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10367,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10367,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__10374_10394 = cljs.core.seq(libs_to_load);
var chunk__10375_10395 = null;
var count__10376_10396 = (0);
var i__10377_10397 = (0);
while(true){
if((i__10377_10397 < count__10376_10396)){
var lib_10398 = chunk__10375_10395.cljs$core$IIndexed$_nth$arity$2(null,i__10377_10397);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_10398)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10398),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10398),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10398),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10398),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_10398,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10398),"');");
}

}
}
}


var G__10399 = seq__10374_10394;
var G__10400 = chunk__10375_10395;
var G__10401 = count__10376_10396;
var G__10402 = (i__10377_10397 + (1));
seq__10374_10394 = G__10399;
chunk__10375_10395 = G__10400;
count__10376_10396 = G__10401;
i__10377_10397 = G__10402;
continue;
} else {
var temp__5735__auto___10403 = cljs.core.seq(seq__10374_10394);
if(temp__5735__auto___10403){
var seq__10374_10404__$1 = temp__5735__auto___10403;
if(cljs.core.chunked_seq_QMARK_(seq__10374_10404__$1)){
var c__4556__auto___10405 = cljs.core.chunk_first(seq__10374_10404__$1);
var G__10406 = cljs.core.chunk_rest(seq__10374_10404__$1);
var G__10407 = c__4556__auto___10405;
var G__10408 = cljs.core.count(c__4556__auto___10405);
var G__10409 = (0);
seq__10374_10394 = G__10406;
chunk__10375_10395 = G__10407;
count__10376_10396 = G__10408;
i__10377_10397 = G__10409;
continue;
} else {
var lib_10410 = cljs.core.first(seq__10374_10404__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_10410)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10410),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10410),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10410),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10410),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_10410,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10410),"');");
}

}
}
}


var G__10411 = cljs.core.next(seq__10374_10404__$1);
var G__10412 = null;
var G__10413 = (0);
var G__10414 = (0);
seq__10374_10394 = G__10411;
chunk__10375_10395 = G__10412;
count__10376_10396 = G__10413;
i__10377_10397 = G__10414;
continue;
}
} else {
}
}
break;
}

var seq__10378_10415 = cljs.core.seq(node_libs);
var chunk__10379_10416 = null;
var count__10380_10417 = (0);
var i__10381_10418 = (0);
while(true){
if((i__10381_10418 < count__10380_10417)){
var lib_10419 = chunk__10379_10416.cljs$core$IIndexed$_nth$arity$2(null,i__10381_10418);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_10419)," = require('",lib_10419,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__10420 = seq__10378_10415;
var G__10421 = chunk__10379_10416;
var G__10422 = count__10380_10417;
var G__10423 = (i__10381_10418 + (1));
seq__10378_10415 = G__10420;
chunk__10379_10416 = G__10421;
count__10380_10417 = G__10422;
i__10381_10418 = G__10423;
continue;
} else {
var temp__5735__auto___10424 = cljs.core.seq(seq__10378_10415);
if(temp__5735__auto___10424){
var seq__10378_10425__$1 = temp__5735__auto___10424;
if(cljs.core.chunked_seq_QMARK_(seq__10378_10425__$1)){
var c__4556__auto___10426 = cljs.core.chunk_first(seq__10378_10425__$1);
var G__10427 = cljs.core.chunk_rest(seq__10378_10425__$1);
var G__10428 = c__4556__auto___10426;
var G__10429 = cljs.core.count(c__4556__auto___10426);
var G__10430 = (0);
seq__10378_10415 = G__10427;
chunk__10379_10416 = G__10428;
count__10380_10417 = G__10429;
i__10381_10418 = G__10430;
continue;
} else {
var lib_10431 = cljs.core.first(seq__10378_10425__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_10431)," = require('",lib_10431,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__10432 = cljs.core.next(seq__10378_10425__$1);
var G__10433 = null;
var G__10434 = (0);
var G__10435 = (0);
seq__10378_10415 = G__10432;
chunk__10379_10416 = G__10433;
count__10380_10417 = G__10434;
i__10381_10418 = G__10435;
continue;
}
} else {
}
}
break;
}

var seq__10382_10436 = cljs.core.seq(global_exports_libs);
var chunk__10383_10437 = null;
var count__10384_10438 = (0);
var i__10385_10439 = (0);
while(true){
if((i__10385_10439 < count__10384_10438)){
var lib_10440 = chunk__10383_10437.cljs$core$IIndexed$_nth$arity$2(null,i__10385_10439);
var map__10390_10441 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_10440));
var map__10390_10442__$1 = (((((!((map__10390_10441 == null))))?(((((map__10390_10441.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10390_10441.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10390_10441):map__10390_10441);
var global_exports_10443 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10390_10442__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_10443,lib_10440);


var G__10444 = seq__10382_10436;
var G__10445 = chunk__10383_10437;
var G__10446 = count__10384_10438;
var G__10447 = (i__10385_10439 + (1));
seq__10382_10436 = G__10444;
chunk__10383_10437 = G__10445;
count__10384_10438 = G__10446;
i__10385_10439 = G__10447;
continue;
} else {
var temp__5735__auto___10448 = cljs.core.seq(seq__10382_10436);
if(temp__5735__auto___10448){
var seq__10382_10449__$1 = temp__5735__auto___10448;
if(cljs.core.chunked_seq_QMARK_(seq__10382_10449__$1)){
var c__4556__auto___10450 = cljs.core.chunk_first(seq__10382_10449__$1);
var G__10451 = cljs.core.chunk_rest(seq__10382_10449__$1);
var G__10452 = c__4556__auto___10450;
var G__10453 = cljs.core.count(c__4556__auto___10450);
var G__10454 = (0);
seq__10382_10436 = G__10451;
chunk__10383_10437 = G__10452;
count__10384_10438 = G__10453;
i__10385_10439 = G__10454;
continue;
} else {
var lib_10455 = cljs.core.first(seq__10382_10449__$1);
var map__10392_10456 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_10455));
var map__10392_10457__$1 = (((((!((map__10392_10456 == null))))?(((((map__10392_10456.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10392_10456.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10392_10456):map__10392_10456);
var global_exports_10458 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10392_10457__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_10458,lib_10455);


var G__10459 = cljs.core.next(seq__10382_10449__$1);
var G__10460 = null;
var G__10461 = (0);
var G__10462 = (0);
seq__10382_10436 = G__10459;
chunk__10383_10437 = G__10460;
count__10384_10438 = G__10461;
i__10385_10439 = G__10462;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__10463){
var map__10464 = p__10463;
var map__10464__$1 = (((((!((map__10464 == null))))?(((((map__10464.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10464.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10464):map__10464);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10464__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10464__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10464__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10464__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10464__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10464__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10464__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__10466){
var map__10467 = p__10466;
var map__10467__$1 = (((((!((map__10467 == null))))?(((((map__10467.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10467.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10467):map__10467);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10467__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10467__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10467__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10467__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10467__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10467__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10467__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__10469){
var map__10470 = p__10469;
var map__10470__$1 = (((((!((map__10470 == null))))?(((((map__10470.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10470.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10470):map__10470);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10470__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10470__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10470__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10470__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10470__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__10472_10496 = cljs.core.seq(protocols);
var chunk__10473_10497 = null;
var count__10474_10498 = (0);
var i__10475_10499 = (0);
while(true){
if((i__10475_10499 < count__10474_10498)){
var protocol_10500 = chunk__10473_10497.cljs$core$IIndexed$_nth$arity$2(null,i__10475_10499);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10500)),"}");


var G__10501 = seq__10472_10496;
var G__10502 = chunk__10473_10497;
var G__10503 = count__10474_10498;
var G__10504 = (i__10475_10499 + (1));
seq__10472_10496 = G__10501;
chunk__10473_10497 = G__10502;
count__10474_10498 = G__10503;
i__10475_10499 = G__10504;
continue;
} else {
var temp__5735__auto___10505 = cljs.core.seq(seq__10472_10496);
if(temp__5735__auto___10505){
var seq__10472_10506__$1 = temp__5735__auto___10505;
if(cljs.core.chunked_seq_QMARK_(seq__10472_10506__$1)){
var c__4556__auto___10507 = cljs.core.chunk_first(seq__10472_10506__$1);
var G__10508 = cljs.core.chunk_rest(seq__10472_10506__$1);
var G__10509 = c__4556__auto___10507;
var G__10510 = cljs.core.count(c__4556__auto___10507);
var G__10511 = (0);
seq__10472_10496 = G__10508;
chunk__10473_10497 = G__10509;
count__10474_10498 = G__10510;
i__10475_10499 = G__10511;
continue;
} else {
var protocol_10512 = cljs.core.first(seq__10472_10506__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10512)),"}");


var G__10513 = cljs.core.next(seq__10472_10506__$1);
var G__10514 = null;
var G__10515 = (0);
var G__10516 = (0);
seq__10472_10496 = G__10513;
chunk__10473_10497 = G__10514;
count__10474_10498 = G__10515;
i__10475_10499 = G__10516;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__10476_10517 = cljs.core.seq(fields__$1);
var chunk__10477_10518 = null;
var count__10478_10519 = (0);
var i__10479_10520 = (0);
while(true){
if((i__10479_10520 < count__10478_10519)){
var fld_10521 = chunk__10477_10518.cljs$core$IIndexed$_nth$arity$2(null,i__10479_10520);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10521," = ",fld_10521,";");


var G__10522 = seq__10476_10517;
var G__10523 = chunk__10477_10518;
var G__10524 = count__10478_10519;
var G__10525 = (i__10479_10520 + (1));
seq__10476_10517 = G__10522;
chunk__10477_10518 = G__10523;
count__10478_10519 = G__10524;
i__10479_10520 = G__10525;
continue;
} else {
var temp__5735__auto___10526 = cljs.core.seq(seq__10476_10517);
if(temp__5735__auto___10526){
var seq__10476_10527__$1 = temp__5735__auto___10526;
if(cljs.core.chunked_seq_QMARK_(seq__10476_10527__$1)){
var c__4556__auto___10528 = cljs.core.chunk_first(seq__10476_10527__$1);
var G__10529 = cljs.core.chunk_rest(seq__10476_10527__$1);
var G__10530 = c__4556__auto___10528;
var G__10531 = cljs.core.count(c__4556__auto___10528);
var G__10532 = (0);
seq__10476_10517 = G__10529;
chunk__10477_10518 = G__10530;
count__10478_10519 = G__10531;
i__10479_10520 = G__10532;
continue;
} else {
var fld_10533 = cljs.core.first(seq__10476_10527__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10533," = ",fld_10533,";");


var G__10534 = cljs.core.next(seq__10476_10527__$1);
var G__10535 = null;
var G__10536 = (0);
var G__10537 = (0);
seq__10476_10517 = G__10534;
chunk__10477_10518 = G__10535;
count__10478_10519 = G__10536;
i__10479_10520 = G__10537;
continue;
}
} else {
}
}
break;
}

var seq__10480_10538 = cljs.core.seq(pmasks);
var chunk__10481_10539 = null;
var count__10482_10540 = (0);
var i__10483_10541 = (0);
while(true){
if((i__10483_10541 < count__10482_10540)){
var vec__10490_10542 = chunk__10481_10539.cljs$core$IIndexed$_nth$arity$2(null,i__10483_10541);
var pno_10543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10490_10542,(0),null);
var pmask_10544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10490_10542,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10543,"$ = ",pmask_10544,";");


var G__10545 = seq__10480_10538;
var G__10546 = chunk__10481_10539;
var G__10547 = count__10482_10540;
var G__10548 = (i__10483_10541 + (1));
seq__10480_10538 = G__10545;
chunk__10481_10539 = G__10546;
count__10482_10540 = G__10547;
i__10483_10541 = G__10548;
continue;
} else {
var temp__5735__auto___10549 = cljs.core.seq(seq__10480_10538);
if(temp__5735__auto___10549){
var seq__10480_10550__$1 = temp__5735__auto___10549;
if(cljs.core.chunked_seq_QMARK_(seq__10480_10550__$1)){
var c__4556__auto___10551 = cljs.core.chunk_first(seq__10480_10550__$1);
var G__10552 = cljs.core.chunk_rest(seq__10480_10550__$1);
var G__10553 = c__4556__auto___10551;
var G__10554 = cljs.core.count(c__4556__auto___10551);
var G__10555 = (0);
seq__10480_10538 = G__10552;
chunk__10481_10539 = G__10553;
count__10482_10540 = G__10554;
i__10483_10541 = G__10555;
continue;
} else {
var vec__10493_10556 = cljs.core.first(seq__10480_10550__$1);
var pno_10557 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10493_10556,(0),null);
var pmask_10558 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10493_10556,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10557,"$ = ",pmask_10558,";");


var G__10559 = cljs.core.next(seq__10480_10550__$1);
var G__10560 = null;
var G__10561 = (0);
var G__10562 = (0);
seq__10480_10538 = G__10559;
chunk__10481_10539 = G__10560;
count__10482_10540 = G__10561;
i__10483_10541 = G__10562;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__10563){
var map__10564 = p__10563;
var map__10564__$1 = (((((!((map__10564 == null))))?(((((map__10564.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10564.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10564):map__10564);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10564__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10564__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10564__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10564__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10564__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__10566_10590 = cljs.core.seq(protocols);
var chunk__10567_10591 = null;
var count__10568_10592 = (0);
var i__10569_10593 = (0);
while(true){
if((i__10569_10593 < count__10568_10592)){
var protocol_10594 = chunk__10567_10591.cljs$core$IIndexed$_nth$arity$2(null,i__10569_10593);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10594)),"}");


var G__10595 = seq__10566_10590;
var G__10596 = chunk__10567_10591;
var G__10597 = count__10568_10592;
var G__10598 = (i__10569_10593 + (1));
seq__10566_10590 = G__10595;
chunk__10567_10591 = G__10596;
count__10568_10592 = G__10597;
i__10569_10593 = G__10598;
continue;
} else {
var temp__5735__auto___10599 = cljs.core.seq(seq__10566_10590);
if(temp__5735__auto___10599){
var seq__10566_10600__$1 = temp__5735__auto___10599;
if(cljs.core.chunked_seq_QMARK_(seq__10566_10600__$1)){
var c__4556__auto___10601 = cljs.core.chunk_first(seq__10566_10600__$1);
var G__10602 = cljs.core.chunk_rest(seq__10566_10600__$1);
var G__10603 = c__4556__auto___10601;
var G__10604 = cljs.core.count(c__4556__auto___10601);
var G__10605 = (0);
seq__10566_10590 = G__10602;
chunk__10567_10591 = G__10603;
count__10568_10592 = G__10604;
i__10569_10593 = G__10605;
continue;
} else {
var protocol_10606 = cljs.core.first(seq__10566_10600__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10606)),"}");


var G__10607 = cljs.core.next(seq__10566_10600__$1);
var G__10608 = null;
var G__10609 = (0);
var G__10610 = (0);
seq__10566_10590 = G__10607;
chunk__10567_10591 = G__10608;
count__10568_10592 = G__10609;
i__10569_10593 = G__10610;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__10570_10611 = cljs.core.seq(fields__$1);
var chunk__10571_10612 = null;
var count__10572_10613 = (0);
var i__10573_10614 = (0);
while(true){
if((i__10573_10614 < count__10572_10613)){
var fld_10615 = chunk__10571_10612.cljs$core$IIndexed$_nth$arity$2(null,i__10573_10614);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10615," = ",fld_10615,";");


var G__10616 = seq__10570_10611;
var G__10617 = chunk__10571_10612;
var G__10618 = count__10572_10613;
var G__10619 = (i__10573_10614 + (1));
seq__10570_10611 = G__10616;
chunk__10571_10612 = G__10617;
count__10572_10613 = G__10618;
i__10573_10614 = G__10619;
continue;
} else {
var temp__5735__auto___10620 = cljs.core.seq(seq__10570_10611);
if(temp__5735__auto___10620){
var seq__10570_10621__$1 = temp__5735__auto___10620;
if(cljs.core.chunked_seq_QMARK_(seq__10570_10621__$1)){
var c__4556__auto___10622 = cljs.core.chunk_first(seq__10570_10621__$1);
var G__10623 = cljs.core.chunk_rest(seq__10570_10621__$1);
var G__10624 = c__4556__auto___10622;
var G__10625 = cljs.core.count(c__4556__auto___10622);
var G__10626 = (0);
seq__10570_10611 = G__10623;
chunk__10571_10612 = G__10624;
count__10572_10613 = G__10625;
i__10573_10614 = G__10626;
continue;
} else {
var fld_10627 = cljs.core.first(seq__10570_10621__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10627," = ",fld_10627,";");


var G__10628 = cljs.core.next(seq__10570_10621__$1);
var G__10629 = null;
var G__10630 = (0);
var G__10631 = (0);
seq__10570_10611 = G__10628;
chunk__10571_10612 = G__10629;
count__10572_10613 = G__10630;
i__10573_10614 = G__10631;
continue;
}
} else {
}
}
break;
}

var seq__10574_10632 = cljs.core.seq(pmasks);
var chunk__10575_10633 = null;
var count__10576_10634 = (0);
var i__10577_10635 = (0);
while(true){
if((i__10577_10635 < count__10576_10634)){
var vec__10584_10636 = chunk__10575_10633.cljs$core$IIndexed$_nth$arity$2(null,i__10577_10635);
var pno_10637 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10584_10636,(0),null);
var pmask_10638 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10584_10636,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10637,"$ = ",pmask_10638,";");


var G__10639 = seq__10574_10632;
var G__10640 = chunk__10575_10633;
var G__10641 = count__10576_10634;
var G__10642 = (i__10577_10635 + (1));
seq__10574_10632 = G__10639;
chunk__10575_10633 = G__10640;
count__10576_10634 = G__10641;
i__10577_10635 = G__10642;
continue;
} else {
var temp__5735__auto___10643 = cljs.core.seq(seq__10574_10632);
if(temp__5735__auto___10643){
var seq__10574_10644__$1 = temp__5735__auto___10643;
if(cljs.core.chunked_seq_QMARK_(seq__10574_10644__$1)){
var c__4556__auto___10645 = cljs.core.chunk_first(seq__10574_10644__$1);
var G__10646 = cljs.core.chunk_rest(seq__10574_10644__$1);
var G__10647 = c__4556__auto___10645;
var G__10648 = cljs.core.count(c__4556__auto___10645);
var G__10649 = (0);
seq__10574_10632 = G__10646;
chunk__10575_10633 = G__10647;
count__10576_10634 = G__10648;
i__10577_10635 = G__10649;
continue;
} else {
var vec__10587_10650 = cljs.core.first(seq__10574_10644__$1);
var pno_10651 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10587_10650,(0),null);
var pmask_10652 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10587_10650,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10651,"$ = ",pmask_10652,";");


var G__10653 = cljs.core.next(seq__10574_10644__$1);
var G__10654 = null;
var G__10655 = (0);
var G__10656 = (0);
seq__10574_10632 = G__10653;
chunk__10575_10633 = G__10654;
count__10576_10634 = G__10655;
i__10577_10635 = G__10656;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__10657){
var map__10658 = p__10657;
var map__10658__$1 = (((((!((map__10658 == null))))?(((((map__10658.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10658.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10658):map__10658);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10658__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10658__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10658__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10658__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10658__$1,cljs.core.cst$kw$env);
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__10660){
var map__10661 = p__10660;
var map__10661__$1 = (((((!((map__10661 == null))))?(((((map__10661.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10661.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10661):map__10661);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10661__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10661__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10661__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10661__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10661__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__4115__auto__ = code;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4115__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__8105__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8105__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__10667 = cljs.core.seq(table);
var chunk__10668 = null;
var count__10669 = (0);
var i__10670 = (0);
while(true){
if((i__10670 < count__10669)){
var vec__10677 = chunk__10668.cljs$core$IIndexed$_nth$arity$2(null,i__10670);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10677,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10677,(1),null);
var ns_10683 = cljs.core.namespace(sym);
var name_10684 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__10685 = seq__10667;
var G__10686 = chunk__10668;
var G__10687 = count__10669;
var G__10688 = (i__10670 + (1));
seq__10667 = G__10685;
chunk__10668 = G__10686;
count__10669 = G__10687;
i__10670 = G__10688;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__10667);
if(temp__5735__auto__){
var seq__10667__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10667__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__10667__$1);
var G__10689 = cljs.core.chunk_rest(seq__10667__$1);
var G__10690 = c__4556__auto__;
var G__10691 = cljs.core.count(c__4556__auto__);
var G__10692 = (0);
seq__10667 = G__10689;
chunk__10668 = G__10690;
count__10669 = G__10691;
i__10670 = G__10692;
continue;
} else {
var vec__10680 = cljs.core.first(seq__10667__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10680,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10680,(1),null);
var ns_10693 = cljs.core.namespace(sym);
var name_10694 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__10695 = cljs.core.next(seq__10667__$1);
var G__10696 = null;
var G__10697 = (0);
var G__10698 = (0);
seq__10667 = G__10695;
chunk__10668 = G__10696;
count__10669 = G__10697;
i__10670 = G__10698;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__10700 = arguments.length;
switch (G__10700) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_10705 = cljs.core.first(ks);
var vec__10701_10706 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_10705);
var top_10707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10701_10706,(0),null);
var prefix_SINGLEQUOTE__10708 = vec__10701_10706;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_10705)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__10708) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_10707)) || (cljs.core.contains_QMARK_(known_externs,top_10707)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__10708)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_10707);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__10708)),";");
}
} else {
}

var m_10709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_10705);
if(cljs.core.empty_QMARK_(m_10709)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__10708,m_10709,top_level,known_externs);
}

var G__10710 = cljs.core.next(ks);
ks = G__10710;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

