// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e34776){var e = e34776;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__34777_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__34777_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__34777_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__34777_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__34777_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34778_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34778_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34779_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34779_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__34784 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34784,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34784,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34780_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34780_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1)))?cljs.core.re_find(/\+/,key):false))){
var vec__34787 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34787,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34787,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34781_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34781_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34782_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34782_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34783_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34783_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34790_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__34790_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5733__auto__ = (function (){var G__34791 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__34791) : intersecting_vars.call(null,G__34791));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__34794,optional_QMARK_,fuel,max_fuel){
var map__34795 = p__34794;
var map__34795__$1 = (((((!((map__34795 == null))))?(((((map__34795.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34795.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34795):map__34795);
var res = map__34795__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34795__$1,cljs.core.cst$kw$vars);
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_34862){
var state_val_34863 = (state_34862[(1)]);
if((state_val_34863 === (7))){
var inst_34851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34852 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_34853 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34852,clause);
var inst_34854 = [null,inst_34853];
var inst_34855 = (new cljs.core.PersistentVector(null,2,(5),inst_34851,inst_34854,null));
var state_34862__$1 = state_34862;
var statearr_34864_34892 = state_34862__$1;
(statearr_34864_34892[(2)] = inst_34855);

(statearr_34864_34892[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34863 === (1))){
var state_34862__$1 = state_34862;
var statearr_34865_34893 = state_34862__$1;
(statearr_34865_34893[(2)] = null);

(statearr_34865_34893[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34863 === (4))){
var inst_34797 = (state_34862[(2)]);
var state_34862__$1 = state_34862;
var statearr_34866_34894 = state_34862__$1;
(statearr_34866_34894[(2)] = inst_34797);

(statearr_34866_34894[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34863 === (15))){
var inst_34840 = (state_34862[(2)]);
var inst_34841 = fluree.db.util.async.throw_err(inst_34840);
var inst_34842 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_34841);
var inst_34843 = cljs.core.count(inst_34842);
var inst_34844 = fluree.db.query.analytical.add_fuel(inst_34843,fuel,max_fuel);
var inst_34845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34846 = [inst_34841,r];
var inst_34847 = (new cljs.core.PersistentVector(null,2,(5),inst_34845,inst_34846,null));
var state_34862__$1 = (function (){var statearr_34867 = state_34862;
(statearr_34867[(7)] = inst_34844);

return statearr_34867;
})();
var statearr_34868_34895 = state_34862__$1;
(statearr_34868_34895[(2)] = inst_34847);

(statearr_34868_34895[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34863 === (13))){
var inst_34806 = (state_34862[(8)]);
var inst_34819 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_34820 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_34819);
var inst_34821 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_34806);
var inst_34822 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_34821);
var inst_34823 = cljs.core.set(inst_34822);
var inst_34824 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_34820);
var inst_34825 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_34824);
var inst_34826 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34823,inst_34825);
var inst_34827 = (function (){var all_wd = inst_34806;
var optional = inst_34820;
var all_wd_vars = inst_34823;
var all_vars = inst_34826;
return (function (p1__34792_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__34792_SHARP_) : all_vars.call(null,p1__34792_SHARP_));
});
})();
var inst_34828 = cljs.core.keys(vars);
var inst_34829 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34827,inst_34828);
var inst_34830 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_34829);
var inst_34831 = cljs.core.set(inst_34830);
var inst_34832 = (function (){var all_wd = inst_34806;
var optional = inst_34820;
var all_wd_vars = inst_34823;
var all_vars = inst_34826;
var intersecting_vars = inst_34831;
return (function (p1__34793_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__34793_SHARP_);
});
})();
var inst_34833 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34832,inst_34806);
var inst_34834 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_34833);
var inst_34835 = fluree.db.query.analytical.select_from_tuples(inst_34834,res);
var inst_34836 = fluree.db.query.analytical.replace_vars_wikidata(inst_34806,inst_34831,vars);
var inst_34837 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_34831,inst_34826);
var inst_34838 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_34836,inst_34834,inst_34835,inst_34837,inst_34820);
var state_34862__$1 = state_34862;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34862__$1,(15),inst_34838);
} else {
if((state_val_34863 === (6))){
var inst_34807 = (state_34862[(9)]);
var inst_34805 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_34806 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_34805);
var inst_34807__$1 = optional_QMARK_;
var state_34862__$1 = (function (){var statearr_34869 = state_34862;
(statearr_34869[(9)] = inst_34807__$1);

(statearr_34869[(8)] = inst_34806);

return statearr_34869;
})();
if(cljs.core.truth_(inst_34807__$1)){
var statearr_34870_34896 = state_34862__$1;
(statearr_34870_34896[(1)] = (9));

} else {
var statearr_34871_34897 = state_34862__$1;
(statearr_34871_34897[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34863 === (3))){
var inst_34860 = (state_34862[(2)]);
var state_34862__$1 = state_34862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34862__$1,inst_34860);
} else {
if((state_val_34863 === (12))){
var inst_34815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34816 = [null,r];
var inst_34817 = (new cljs.core.PersistentVector(null,2,(5),inst_34815,inst_34816,null));
var state_34862__$1 = state_34862;
var statearr_34872_34898 = state_34862__$1;
(statearr_34872_34898[(2)] = inst_34817);

(statearr_34872_34898[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34863 === (2))){
var _ = (function (){var statearr_34873 = state_34862;
(statearr_34873[(4)] = cljs.core.cons((5),(state_34862[(4)])));

return statearr_34873;
})();
var inst_34803 = (r == null);
var state_34862__$1 = state_34862;
if(cljs.core.truth_(inst_34803)){
var statearr_34874_34899 = state_34862__$1;
(statearr_34874_34899[(1)] = (6));

} else {
var statearr_34875_34900 = state_34862__$1;
(statearr_34875_34900[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34863 === (11))){
var inst_34813 = (state_34862[(2)]);
var state_34862__$1 = state_34862;
if(cljs.core.truth_(inst_34813)){
var statearr_34877_34901 = state_34862__$1;
(statearr_34877_34901[(1)] = (12));

} else {
var statearr_34878_34902 = state_34862__$1;
(statearr_34878_34902[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34863 === (9))){
var inst_34806 = (state_34862[(8)]);
var inst_34809 = cljs.core.empty_QMARK_(inst_34806);
var inst_34810 = (!(inst_34809));
var state_34862__$1 = state_34862;
var statearr_34879_34903 = state_34862__$1;
(statearr_34879_34903[(2)] = inst_34810);

(statearr_34879_34903[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34863 === (5))){
var _ = (function (){var statearr_34880 = state_34862;
(statearr_34880[(4)] = cljs.core.rest((state_34862[(4)])));

return statearr_34880;
})();
var state_34862__$1 = state_34862;
var ex34876 = (state_34862__$1[(2)]);
var statearr_34881_34904 = state_34862__$1;
(statearr_34881_34904[(5)] = ex34876);


if((ex34876 instanceof Error)){
var statearr_34882_34905 = state_34862__$1;
(statearr_34882_34905[(1)] = (4));

(statearr_34882_34905[(5)] = null);

} else {
throw ex34876;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34863 === (14))){
var inst_34849 = (state_34862[(2)]);
var state_34862__$1 = state_34862;
var statearr_34883_34906 = state_34862__$1;
(statearr_34883_34906[(2)] = inst_34849);

(statearr_34883_34906[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34863 === (10))){
var inst_34807 = (state_34862[(9)]);
var state_34862__$1 = state_34862;
var statearr_34884_34907 = state_34862__$1;
(statearr_34884_34907[(2)] = inst_34807);

(statearr_34884_34907[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34863 === (8))){
var inst_34857 = (state_34862[(2)]);
var _ = (function (){var statearr_34885 = state_34862;
(statearr_34885[(4)] = cljs.core.rest((state_34862[(4)])));

return statearr_34885;
})();
var state_34862__$1 = state_34862;
var statearr_34886_34908 = state_34862__$1;
(statearr_34886_34908[(2)] = inst_34857);

(statearr_34886_34908[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16291__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16291__auto____0 = (function (){
var statearr_34887 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34887[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16291__auto__);

(statearr_34887[(1)] = (1));

return statearr_34887;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16291__auto____1 = (function (state_34862){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_34862);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e34888){var ex__16294__auto__ = e34888;
var statearr_34889_34909 = state_34862;
(statearr_34889_34909[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_34862[(4)]))){
var statearr_34890_34910 = state_34862;
(statearr_34890_34910[(1)] = cljs.core.first((state_34862[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__34911 = state_34862;
state_34862 = G__34911;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16291__auto__ = function(state_34862){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16291__auto____1.call(this,state_34862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16291__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16291__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_34891 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_34891[(6)] = c__16328__auto__);

return statearr_34891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__34913 = arguments.length;
switch (G__34913) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_35007){
var state_val_35008 = (state_35007[(1)]);
if((state_val_35008 === (7))){
var inst_34920 = (state_35007[(7)]);
var inst_34930 = clojure.string.starts_with_QMARK_(inst_34920,"$fdb");
var state_35007__$1 = state_35007;
if(inst_34930){
var statearr_35009_35058 = state_35007__$1;
(statearr_35009_35058[(1)] = (9));

} else {
var statearr_35010_35059 = state_35007__$1;
(statearr_35010_35059[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (20))){
var state_35007__$1 = state_35007;
var statearr_35011_35060 = state_35007__$1;
(statearr_35011_35060[(2)] = null);

(statearr_35011_35060[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (27))){
var inst_34970 = (state_35007[(8)]);
var state_35007__$1 = state_35007;
var statearr_35012_35061 = state_35007__$1;
(statearr_35012_35061[(2)] = inst_34970);

(statearr_35012_35061[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (1))){
var state_35007__$1 = state_35007;
var statearr_35013_35062 = state_35007__$1;
(statearr_35013_35062[(2)] = null);

(statearr_35013_35062[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (24))){
var inst_34993 = (state_35007[(2)]);
var state_35007__$1 = state_35007;
var statearr_35014_35063 = state_35007__$1;
(statearr_35014_35063[(2)] = inst_34993);

(statearr_35014_35063[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (4))){
var inst_34914 = (state_35007[(2)]);
var state_35007__$1 = state_35007;
var statearr_35015_35064 = state_35007__$1;
(statearr_35015_35064[(2)] = inst_34914);

(statearr_35015_35064[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (15))){
var inst_34937 = (state_35007[(9)]);
var inst_34943 = (state_35007[(2)]);
var inst_34944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34945 = cljs.core.PersistentVector.EMPTY;
var inst_34946 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34947 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34945,inst_34946);
var inst_34948 = [inst_34937,inst_34947];
var inst_34949 = (new cljs.core.PersistentVector(null,2,(5),inst_34944,inst_34948,null));
var state_35007__$1 = (function (){var statearr_35016 = state_35007;
(statearr_35016[(10)] = inst_34943);

return statearr_35016;
})();
var statearr_35017_35065 = state_35007__$1;
(statearr_35017_35065[(2)] = inst_34949);

(statearr_35017_35065[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (21))){
var inst_34996 = (state_35007[(2)]);
var state_35007__$1 = state_35007;
var statearr_35018_35066 = state_35007__$1;
(statearr_35018_35066[(2)] = inst_34996);

(statearr_35018_35066[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (13))){
var inst_34937 = (state_35007[(9)]);
var inst_34940 = (function(){throw inst_34937})();
var state_35007__$1 = state_35007;
var statearr_35019_35067 = state_35007__$1;
(statearr_35019_35067[(2)] = inst_34940);

(statearr_35019_35067[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (22))){
var inst_34959 = (state_35007[(11)]);
var inst_34961 = (state_35007[(12)]);
var inst_34963 = fluree.db.query.analytical.parse_block_from_source(inst_34959);
var inst_34964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34965 = [cljs.core.cst$kw$sources,inst_34961];
var inst_34966 = (new cljs.core.PersistentVector(null,2,(5),inst_34964,inst_34965,null));
var inst_34967 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_34966);
var state_35007__$1 = (function (){var statearr_35020 = state_35007;
(statearr_35020[(13)] = inst_34963);

return statearr_35020;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35007__$1,(25),inst_34967);
} else {
if((state_val_35008 === (29))){
var inst_34974 = (state_35007[(2)]);
var inst_34975 = fluree.db.util.async.throw_err(inst_34974);
var state_35007__$1 = state_35007;
var statearr_35021_35068 = state_35007__$1;
(statearr_35021_35068[(2)] = inst_34975);

(statearr_35021_35068[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (6))){
var inst_34923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34924 = cljs.core.PersistentVector.EMPTY;
var inst_34925 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34926 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34924,inst_34925);
var inst_34927 = [db,inst_34926];
var inst_34928 = (new cljs.core.PersistentVector(null,2,(5),inst_34923,inst_34927,null));
var state_35007__$1 = state_35007;
var statearr_35022_35069 = state_35007__$1;
(statearr_35022_35069[(2)] = inst_34928);

(statearr_35022_35069[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (28))){
var inst_34978 = (state_35007[(2)]);
var inst_34979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34980 = cljs.core.PersistentVector.EMPTY;
var inst_34981 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34982 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34980,inst_34981);
var inst_34983 = [inst_34978,inst_34982];
var inst_34984 = (new cljs.core.PersistentVector(null,2,(5),inst_34979,inst_34983,null));
var state_35007__$1 = state_35007;
var statearr_35023_35070 = state_35007__$1;
(statearr_35023_35070[(2)] = inst_34984);

(statearr_35023_35070[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (25))){
var inst_34963 = (state_35007[(13)]);
var inst_34969 = (state_35007[(2)]);
var inst_34970 = fluree.db.util.async.throw_err(inst_34969);
var state_35007__$1 = (function (){var statearr_35024 = state_35007;
(statearr_35024[(8)] = inst_34970);

return statearr_35024;
})();
if(cljs.core.truth_(inst_34963)){
var statearr_35025_35071 = state_35007__$1;
(statearr_35025_35071[(1)] = (26));

} else {
var statearr_35026_35072 = state_35007__$1;
(statearr_35026_35072[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (17))){
var state_35007__$1 = state_35007;
var statearr_35027_35073 = state_35007__$1;
(statearr_35027_35073[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (3))){
var inst_35005 = (state_35007[(2)]);
var state_35007__$1 = state_35007;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35007__$1,inst_35005);
} else {
if((state_val_35008 === (12))){
var inst_34937 = (state_35007[(9)]);
var inst_34936 = (state_35007[(2)]);
var inst_34937__$1 = fluree.db.util.async.throw_err(inst_34936);
var inst_34938 = fluree.db.util.core.exception_QMARK_(inst_34937__$1);
var state_35007__$1 = (function (){var statearr_35029 = state_35007;
(statearr_35029[(9)] = inst_34937__$1);

return statearr_35029;
})();
if(inst_34938){
var statearr_35030_35074 = state_35007__$1;
(statearr_35030_35074[(1)] = (13));

} else {
var statearr_35031_35075 = state_35007__$1;
(statearr_35031_35075[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (2))){
var inst_34920 = (state_35007[(7)]);
var _ = (function (){var statearr_35032 = state_35007;
(statearr_35032[(4)] = cljs.core.cons((5),(state_35007[(4)])));

return statearr_35032;
})();
var inst_34920__$1 = cljs.core.first(clause);
var inst_34921 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_34920__$1);
var state_35007__$1 = (function (){var statearr_35033 = state_35007;
(statearr_35033[(7)] = inst_34920__$1);

return statearr_35033;
})();
if(inst_34921){
var statearr_35034_35076 = state_35007__$1;
(statearr_35034_35076[(1)] = (6));

} else {
var statearr_35035_35077 = state_35007__$1;
(statearr_35035_35077[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (23))){
var inst_34920 = (state_35007[(7)]);
var inst_34986 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34920)," is not supported in Fluree"].join('');
var inst_34987 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34988 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34989 = cljs.core.PersistentHashMap.fromArrays(inst_34987,inst_34988);
var inst_34990 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34986,inst_34989);
var inst_34991 = (function(){throw inst_34990})();
var state_35007__$1 = state_35007;
var statearr_35036_35078 = state_35007__$1;
(statearr_35036_35078[(2)] = inst_34991);

(statearr_35036_35078[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (19))){
var inst_34920 = (state_35007[(7)]);
var inst_34961 = (state_35007[(12)]);
var inst_34958 = fluree.db.query.analytical.isolate_source_name(inst_34920);
var inst_34959 = fluree.db.query.analytical.isolate_source_block(inst_34920);
var inst_34960 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_34958);
var inst_34961__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_34960);
var state_35007__$1 = (function (){var statearr_35037 = state_35007;
(statearr_35037[(11)] = inst_34959);

(statearr_35037[(12)] = inst_34961__$1);

return statearr_35037;
})();
if(cljs.core.truth_(inst_34961__$1)){
var statearr_35038_35079 = state_35007__$1;
(statearr_35038_35079[(1)] = (22));

} else {
var statearr_35039_35080 = state_35007__$1;
(statearr_35039_35080[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (11))){
var inst_35000 = (state_35007[(2)]);
var state_35007__$1 = state_35007;
var statearr_35041_35081 = state_35007__$1;
(statearr_35041_35081[(2)] = inst_35000);

(statearr_35041_35081[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (9))){
var inst_34920 = (state_35007[(7)]);
var inst_34932 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_34920,(4));
var inst_34933 = fluree.db.query.analytical.parse_block_from_source(inst_34932);
var inst_34934 = fluree.db.time_travel.as_of_block(db,inst_34933);
var state_35007__$1 = state_35007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35007__$1,(12),inst_34934);
} else {
if((state_val_35008 === (5))){
var _ = (function (){var statearr_35042 = state_35007;
(statearr_35042[(4)] = cljs.core.rest((state_35007[(4)])));

return statearr_35042;
})();
var state_35007__$1 = state_35007;
var ex35040 = (state_35007__$1[(2)]);
var statearr_35043_35082 = state_35007__$1;
(statearr_35043_35082[(5)] = ex35040);


if((ex35040 instanceof Error)){
var statearr_35044_35083 = state_35007__$1;
(statearr_35044_35083[(1)] = (4));

(statearr_35044_35083[(5)] = null);

} else {
throw ex35040;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (14))){
var state_35007__$1 = state_35007;
var statearr_35045_35084 = state_35007__$1;
(statearr_35045_35084[(2)] = null);

(statearr_35045_35084[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (26))){
var inst_34970 = (state_35007[(8)]);
var inst_34963 = (state_35007[(13)]);
var inst_34972 = fluree.db.time_travel.as_of_block(inst_34970,inst_34963);
var state_35007__$1 = state_35007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35007__$1,(29),inst_34972);
} else {
if((state_val_35008 === (16))){
var inst_34953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34954 = ["$wd",clause];
var inst_34955 = (new cljs.core.PersistentVector(null,2,(5),inst_34953,inst_34954,null));
var state_35007__$1 = state_35007;
var statearr_35046_35085 = state_35007__$1;
(statearr_35046_35085[(2)] = inst_34955);

(statearr_35046_35085[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (10))){
var inst_34920 = (state_35007[(7)]);
var inst_34951 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_34920);
var state_35007__$1 = state_35007;
if(inst_34951){
var statearr_35047_35086 = state_35007__$1;
(statearr_35047_35086[(1)] = (16));

} else {
var statearr_35048_35087 = state_35007__$1;
(statearr_35048_35087[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (18))){
var inst_34998 = (state_35007[(2)]);
var state_35007__$1 = state_35007;
var statearr_35049_35088 = state_35007__$1;
(statearr_35049_35088[(2)] = inst_34998);

(statearr_35049_35088[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35008 === (8))){
var inst_35002 = (state_35007[(2)]);
var _ = (function (){var statearr_35050 = state_35007;
(statearr_35050[(4)] = cljs.core.rest((state_35007[(4)])));

return statearr_35050;
})();
var state_35007__$1 = state_35007;
var statearr_35051_35089 = state_35007__$1;
(statearr_35051_35089[(2)] = inst_35002);

(statearr_35051_35089[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16291__auto__ = null;
var fluree$db$query$analytical$state_machine__16291__auto____0 = (function (){
var statearr_35052 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35052[(0)] = fluree$db$query$analytical$state_machine__16291__auto__);

(statearr_35052[(1)] = (1));

return statearr_35052;
});
var fluree$db$query$analytical$state_machine__16291__auto____1 = (function (state_35007){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_35007);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e35053){var ex__16294__auto__ = e35053;
var statearr_35054_35090 = state_35007;
(statearr_35054_35090[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_35007[(4)]))){
var statearr_35055_35091 = state_35007;
(statearr_35055_35091[(1)] = cljs.core.first((state_35007[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__35092 = state_35007;
state_35007 = G__35092;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16291__auto__ = function(state_35007){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16291__auto____1.call(this,state_35007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16291__auto____0;
fluree$db$query$analytical$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16291__auto____1;
return fluree$db$query$analytical$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_35056 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_35056[(6)] = c__16328__auto__);

return statearr_35056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__35093){
var vec__35094 = p__35093;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35094,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35094,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35097_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__35097_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__35101 = subjects;
var vec__35102 = G__35101;
var seq__35103 = cljs.core.seq(vec__35102);
var first__35104 = cljs.core.first(seq__35103);
var seq__35103__$1 = cljs.core.next(seq__35103);
var subject = first__35104;
var r = seq__35103__$1;
var acc = expanded_map;
var G__35101__$1 = G__35101;
var acc__$1 = acc;
while(true){
var vec__35108 = G__35101__$1;
var seq__35109 = cljs.core.seq(vec__35108);
var first__35110 = cljs.core.first(seq__35109);
var seq__35109__$1 = cljs.core.next(seq__35109);
var subject__$1 = first__35110;
var r__$1 = seq__35109__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__35111 = r__$1;
var G__35112 = acc__$2;
G__35101__$1 = G__35111;
acc__$1 = G__35112;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__35101__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__35108,seq__35109,first__35110,seq__35109__$1,subject__$1,r__$1,acc__$2,G__35101,vec__35102,seq__35103,first__35104,seq__35103__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__35101__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__35108,seq__35109,first__35110,seq__35109__$1,subject__$1,r__$1,acc__$2,G__35101,vec__35102,seq__35103,first__35104,seq__35103__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__35101__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__35108,seq__35109,first__35110,seq__35109__$1,subject__$1,r__$1,acc__$2,G__35101,vec__35102,seq__35103,first__35104,seq__35103__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__35101__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__35108,seq__35109,first__35110,seq__35109__$1,subject__$1,r__$1,acc__$2,G__35101,vec__35102,seq__35103,first__35104,seq__35103__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__35101__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__35108,seq__35109,first__35110,seq__35109__$1,subject__$1,r__$1,acc__$2,G__35101,vec__35102,seq__35103,first__35104,seq__35103__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__35101__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__35108,seq__35109,first__35110,seq__35109__$1,subject__$1,r__$1,acc__$2,G__35101,vec__35102,seq__35103,first__35104,seq__35103__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__35113 = r__$1;
var G__35114 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__35101__$1 = G__35113;
acc__$1 = G__35114;
continue;
} else {
var G__35115 = subjects;
var G__35116 = acc_STAR_;
G__35101__$1 = G__35115;
acc__$1 = G__35116;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35117_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__35117_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_35208){
var state_val_35209 = (state_35208[(1)]);
if((state_val_35209 === (7))){
var state_35208__$1 = state_35208;
var statearr_35210_35256 = state_35208__$1;
(statearr_35210_35256[(2)] = (100));

(statearr_35210_35256[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (20))){
var inst_35157 = (state_35208[(7)]);
var state_35208__$1 = state_35208;
var statearr_35211_35257 = state_35208__$1;
(statearr_35211_35257[(2)] = inst_35157);

(statearr_35211_35257[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (1))){
var state_35208__$1 = state_35208;
var statearr_35212_35258 = state_35208__$1;
(statearr_35212_35258[(2)] = null);

(statearr_35212_35258[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (24))){
var inst_35195 = (state_35208[(8)]);
var inst_35129 = (state_35208[(9)]);
var inst_35196 = (state_35208[(10)]);
var inst_35194 = (state_35208[(11)]);
var inst_35199 = (function (){var max_depth = inst_35129;
var recur_map__$1 = inst_35195;
var subjects = inst_35194;
var tuples = inst_35196;
return (function (p1__35118_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__35118_SHARP_)],null));
});
})();
var inst_35200 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35199,inst_35196);
var inst_35201 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_35200);
var state_35208__$1 = state_35208;
var statearr_35213_35259 = state_35208__$1;
(statearr_35213_35259[(2)] = inst_35201);

(statearr_35213_35259[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (4))){
var inst_35119 = (state_35208[(2)]);
var state_35208__$1 = state_35208;
var statearr_35214_35260 = state_35208__$1;
(statearr_35214_35260[(2)] = inst_35119);

(statearr_35214_35260[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (15))){
var inst_35142 = (state_35208[(12)]);
var inst_35153 = cljs.core.PersistentVector.EMPTY;
var inst_35154 = cljs.core.seq(inst_35142);
var inst_35155 = cljs.core.first(inst_35154);
var inst_35156 = cljs.core.next(inst_35154);
var inst_35157 = inst_35153;
var inst_35158 = inst_35142;
var state_35208__$1 = (function (){var statearr_35215 = state_35208;
(statearr_35215[(13)] = inst_35155);

(statearr_35215[(7)] = inst_35157);

(statearr_35215[(14)] = inst_35156);

(statearr_35215[(15)] = inst_35158);

return statearr_35215;
})();
var statearr_35216_35261 = state_35208__$1;
(statearr_35216_35261[(2)] = null);

(statearr_35216_35261[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (21))){
var inst_35178 = (state_35208[(2)]);
var state_35208__$1 = state_35208;
var statearr_35217_35262 = state_35208__$1;
(statearr_35217_35262[(2)] = inst_35178);

(statearr_35217_35262[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (13))){
var inst_35191 = (state_35208[(2)]);
var state_35208__$1 = state_35208;
var statearr_35218_35263 = state_35208__$1;
(statearr_35218_35263[(2)] = inst_35191);

(statearr_35218_35263[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (22))){
var inst_35157 = (state_35208[(7)]);
var inst_35165 = (state_35208[(16)]);
var inst_35172 = (state_35208[(2)]);
var inst_35173 = fluree.db.util.async.throw_err(inst_35172);
var inst_35174 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_35157,inst_35173);
var inst_35157__$1 = inst_35174;
var inst_35158 = inst_35165;
var state_35208__$1 = (function (){var statearr_35219 = state_35208;
(statearr_35219[(7)] = inst_35157__$1);

(statearr_35219[(15)] = inst_35158);

return statearr_35219;
})();
var statearr_35220_35264 = state_35208__$1;
(statearr_35220_35264[(2)] = null);

(statearr_35220_35264[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (6))){
var inst_35125 = (state_35208[(17)]);
var state_35208__$1 = state_35208;
var statearr_35221_35265 = state_35208__$1;
(statearr_35221_35265[(2)] = inst_35125);

(statearr_35221_35265[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (25))){
var inst_35203 = (state_35208[(2)]);
var _ = (function (){var statearr_35222 = state_35208;
(statearr_35222[(4)] = cljs.core.rest((state_35208[(4)])));

return statearr_35222;
})();
var state_35208__$1 = state_35208;
var statearr_35223_35266 = state_35208__$1;
(statearr_35223_35266[(2)] = inst_35203);

(statearr_35223_35266[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (17))){
var inst_35164 = (state_35208[(18)]);
var inst_35158 = (state_35208[(15)]);
var inst_35163 = cljs.core.seq(inst_35158);
var inst_35164__$1 = cljs.core.first(inst_35163);
var inst_35165 = cljs.core.next(inst_35163);
var state_35208__$1 = (function (){var statearr_35224 = state_35208;
(statearr_35224[(18)] = inst_35164__$1);

(statearr_35224[(16)] = inst_35165);

return statearr_35224;
})();
if(cljs.core.truth_(inst_35164__$1)){
var statearr_35225_35267 = state_35208__$1;
(statearr_35225_35267[(1)] = (19));

} else {
var statearr_35226_35268 = state_35208__$1;
(statearr_35226_35268[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (3))){
var inst_35206 = (state_35208[(2)]);
var state_35208__$1 = state_35208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35208__$1,inst_35206);
} else {
if((state_val_35209 === (12))){
var inst_35131 = (state_35208[(19)]);
var inst_35142 = (state_35208[(12)]);
var inst_35137 = cljs.core.vals(inst_35131);
var inst_35138 = cljs.core.flatten(inst_35137);
var inst_35139 = cljs.core.set(inst_35138);
var inst_35140 = cljs.core.keys(inst_35131);
var inst_35141 = cljs.core.set(inst_35140);
var inst_35142__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_35139,inst_35141);
var inst_35143 = cljs.core.empty_QMARK_(inst_35142__$1);
var state_35208__$1 = (function (){var statearr_35227 = state_35208;
(statearr_35227[(12)] = inst_35142__$1);

return statearr_35227;
})();
if(inst_35143){
var statearr_35228_35269 = state_35208__$1;
(statearr_35228_35269[(1)] = (14));

} else {
var statearr_35229_35270 = state_35208__$1;
(statearr_35229_35270[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (2))){
var inst_35125 = (state_35208[(17)]);
var _ = (function (){var statearr_35230 = state_35208;
(statearr_35230[(4)] = cljs.core.cons((5),(state_35208[(4)])));

return statearr_35230;
})();
var inst_35125__$1 = depth;
var state_35208__$1 = (function (){var statearr_35231 = state_35208;
(statearr_35231[(17)] = inst_35125__$1);

return statearr_35231;
})();
if(cljs.core.truth_(inst_35125__$1)){
var statearr_35232_35271 = state_35208__$1;
(statearr_35232_35271[(1)] = (6));

} else {
var statearr_35233_35272 = state_35208__$1;
(statearr_35233_35272[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (23))){
var inst_35196 = (state_35208[(10)]);
var state_35208__$1 = state_35208;
var statearr_35234_35273 = state_35208__$1;
(statearr_35234_35273[(2)] = inst_35196);

(statearr_35234_35273[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (19))){
var inst_35164 = (state_35208[(18)]);
var inst_35167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35168 = [inst_35164,predicate];
var inst_35169 = (new cljs.core.PersistentVector(null,2,(5),inst_35167,inst_35168,null));
var inst_35170 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_35169);
var state_35208__$1 = state_35208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35208__$1,(22),inst_35170);
} else {
if((state_val_35209 === (11))){
var inst_35131 = (state_35208[(19)]);
var state_35208__$1 = state_35208;
var statearr_35236_35274 = state_35208__$1;
(statearr_35236_35274[(2)] = inst_35131);

(statearr_35236_35274[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (9))){
var inst_35129 = (state_35208[(9)]);
var inst_35132 = (state_35208[(20)]);
var inst_35134 = (inst_35132 >= inst_35129);
var state_35208__$1 = state_35208;
if(cljs.core.truth_(inst_35134)){
var statearr_35237_35275 = state_35208__$1;
(statearr_35237_35275[(1)] = (11));

} else {
var statearr_35238_35276 = state_35208__$1;
(statearr_35238_35276[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (5))){
var _ = (function (){var statearr_35239 = state_35208;
(statearr_35239[(4)] = cljs.core.rest((state_35208[(4)])));

return statearr_35239;
})();
var state_35208__$1 = state_35208;
var ex35235 = (state_35208__$1[(2)]);
var statearr_35240_35277 = state_35208__$1;
(statearr_35240_35277[(5)] = ex35235);


if((ex35235 instanceof Error)){
var statearr_35241_35278 = state_35208__$1;
(statearr_35241_35278[(1)] = (4));

(statearr_35241_35278[(5)] = null);

} else {
throw ex35235;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (14))){
var inst_35131 = (state_35208[(19)]);
var state_35208__$1 = state_35208;
var statearr_35242_35279 = state_35208__$1;
(statearr_35242_35279[(2)] = inst_35131);

(statearr_35242_35279[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (16))){
var inst_35189 = (state_35208[(2)]);
var state_35208__$1 = state_35208;
var statearr_35243_35280 = state_35208__$1;
(statearr_35243_35280[(2)] = inst_35189);

(statearr_35243_35280[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (10))){
var inst_35195 = (state_35208[(8)]);
var inst_35194 = (state_35208[(11)]);
var inst_35193 = (state_35208[(2)]);
var inst_35194__$1 = cljs.core.keys(inst_35193);
var inst_35195__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_35194__$1,inst_35193);
var inst_35196 = fluree.db.query.analytical.recur_map__GT_tuples(inst_35194__$1,inst_35195__$1);
var state_35208__$1 = (function (){var statearr_35244 = state_35208;
(statearr_35244[(8)] = inst_35195__$1);

(statearr_35244[(10)] = inst_35196);

(statearr_35244[(11)] = inst_35194__$1);

return statearr_35244;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_35245_35281 = state_35208__$1;
(statearr_35245_35281[(1)] = (23));

} else {
var statearr_35246_35282 = state_35208__$1;
(statearr_35246_35282[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (18))){
var inst_35131 = (state_35208[(19)]);
var inst_35132 = (state_35208[(20)]);
var inst_35180 = (state_35208[(2)]);
var inst_35181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35182 = [(0),(2)];
var inst_35183 = (new cljs.core.PersistentVector(null,2,(5),inst_35181,inst_35182,null));
var inst_35184 = fluree.db.query.analytical.get_ns_arrays(inst_35183,inst_35180);
var inst_35185 = fluree.db.query.analytical.tuples__GT_map(inst_35131,inst_35184);
var inst_35186 = (inst_35132 + (1));
var inst_35131__$1 = inst_35185;
var inst_35132__$1 = inst_35186;
var state_35208__$1 = (function (){var statearr_35247 = state_35208;
(statearr_35247[(19)] = inst_35131__$1);

(statearr_35247[(20)] = inst_35132__$1);

return statearr_35247;
})();
var statearr_35248_35283 = state_35208__$1;
(statearr_35248_35283[(2)] = null);

(statearr_35248_35283[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35209 === (8))){
var inst_35129 = (state_35208[(2)]);
var inst_35130 = recur_map;
var inst_35131 = inst_35130;
var inst_35132 = (1);
var state_35208__$1 = (function (){var statearr_35249 = state_35208;
(statearr_35249[(19)] = inst_35131);

(statearr_35249[(9)] = inst_35129);

(statearr_35249[(20)] = inst_35132);

return statearr_35249;
})();
var statearr_35250_35284 = state_35208__$1;
(statearr_35250_35284[(2)] = null);

(statearr_35250_35284[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16291__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16291__auto____0 = (function (){
var statearr_35251 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35251[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16291__auto__);

(statearr_35251[(1)] = (1));

return statearr_35251;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16291__auto____1 = (function (state_35208){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_35208);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e35252){var ex__16294__auto__ = e35252;
var statearr_35253_35285 = state_35208;
(statearr_35253_35285[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_35208[(4)]))){
var statearr_35254_35286 = state_35208;
(statearr_35254_35286[(1)] = cljs.core.first((state_35208[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__35287 = state_35208;
state_35208 = G__35287;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16291__auto__ = function(state_35208){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16291__auto____1.call(this,state_35208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16291__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16291__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_35255 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_35255[(6)] = c__16328__auto__);

return statearr_35255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__35288,clause,fuel,max_fuel){
var map__35289 = p__35288;
var map__35289__$1 = (((((!((map__35289 == null))))?(((((map__35289.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35289.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35289):map__35289);
var res = map__35289__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35289__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35289__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35289__$1,cljs.core.cst$kw$vars);
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_35421){
var state_val_35422 = (state_35421[(1)]);
if((state_val_35422 === (7))){
var state_35421__$1 = state_35421;
var statearr_35423_35489 = state_35421__$1;
(statearr_35423_35489[(2)] = false);

(statearr_35423_35489[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (20))){
var inst_35353 = (state_35421[(7)]);
var state_35421__$1 = state_35421;
var statearr_35424_35490 = state_35421__$1;
(statearr_35424_35490[(2)] = inst_35353);

(statearr_35424_35490[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (27))){
var inst_35357 = (state_35421[(8)]);
var inst_35381 = (state_35421[(2)]);
var state_35421__$1 = (function (){var statearr_35425 = state_35421;
(statearr_35425[(9)] = inst_35381);

return statearr_35425;
})();
if(cljs.core.truth_(inst_35357)){
var statearr_35426_35491 = state_35421__$1;
(statearr_35426_35491[(1)] = (28));

} else {
var statearr_35427_35492 = state_35421__$1;
(statearr_35427_35492[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (1))){
var state_35421__$1 = state_35421;
var statearr_35428_35493 = state_35421__$1;
(statearr_35428_35493[(2)] = null);

(statearr_35428_35493[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (24))){
var inst_35369 = (state_35421[(2)]);
var inst_35370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_35371 = fluree.db.query.analytical.variable_QMARK_(inst_35370);
var state_35421__$1 = (function (){var statearr_35429 = state_35421;
(statearr_35429[(10)] = inst_35369);

return statearr_35429;
})();
if(cljs.core.truth_(inst_35371)){
var statearr_35430_35494 = state_35421__$1;
(statearr_35430_35494[(1)] = (25));

} else {
var statearr_35431_35495 = state_35421__$1;
(statearr_35431_35495[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (4))){
var inst_35291 = (state_35421[(2)]);
var state_35421__$1 = state_35421;
var statearr_35432_35496 = state_35421__$1;
(statearr_35432_35496[(2)] = inst_35291);

(statearr_35432_35496[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (15))){
var inst_35339 = (state_35421[(11)]);
var state_35421__$1 = state_35421;
var statearr_35433_35497 = state_35421__$1;
(statearr_35433_35497[(2)] = inst_35339);

(statearr_35433_35497[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (21))){
var inst_35324 = (state_35421[(12)]);
var inst_35412 = (state_35421[(2)]);
var inst_35413 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_35414 = cljs.core.keys(inst_35324);
var inst_35415 = [inst_35414,vars,inst_35412];
var inst_35416 = cljs.core.PersistentHashMap.fromArrays(inst_35413,inst_35415);
var _ = (function (){var statearr_35434 = state_35421;
(statearr_35434[(4)] = cljs.core.rest((state_35421[(4)])));

return statearr_35434;
})();
var state_35421__$1 = state_35421;
var statearr_35435_35498 = state_35421__$1;
(statearr_35435_35498[(2)] = inst_35416);

(statearr_35435_35498[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (31))){
var inst_35355 = (state_35421[(13)]);
var inst_35353 = (state_35421[(7)]);
var inst_35388 = cljs.core.PersistentHashMap.EMPTY;
var inst_35389 = cljs.core.flatten(inst_35353);
var inst_35390 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35388,inst_35355,inst_35389);
var state_35421__$1 = state_35421;
var statearr_35436_35499 = state_35421__$1;
(statearr_35436_35499[(2)] = inst_35390);

(statearr_35436_35499[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (32))){
var inst_35355 = (state_35421[(13)]);
var inst_35392 = cljs.core.coll_QMARK_(inst_35355);
var state_35421__$1 = state_35421;
if(inst_35392){
var statearr_35437_35500 = state_35421__$1;
(statearr_35437_35500[(1)] = (34));

} else {
var statearr_35438_35501 = state_35421__$1;
(statearr_35438_35501[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (33))){
var inst_35403 = (state_35421[(2)]);
var state_35421__$1 = state_35421;
var statearr_35439_35502 = state_35421__$1;
(statearr_35439_35502[(2)] = inst_35403);

(statearr_35439_35502[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (13))){
var inst_35301 = (state_35421[(14)]);
var state_35421__$1 = state_35421;
var statearr_35440_35503 = state_35421__$1;
(statearr_35440_35503[(2)] = inst_35301);

(statearr_35440_35503[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (22))){
var inst_35337 = (state_35421[(15)]);
var inst_35361 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35337)].join('');
var inst_35362 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35363 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_35364 = cljs.core.PersistentHashMap.fromArrays(inst_35362,inst_35363);
var inst_35365 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35361,inst_35364);
var inst_35366 = (function(){throw inst_35365})();
var state_35421__$1 = state_35421;
var statearr_35441_35504 = state_35421__$1;
(statearr_35441_35504[(2)] = inst_35366);

(statearr_35441_35504[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (36))){
var inst_35401 = (state_35421[(2)]);
var state_35421__$1 = state_35421;
var statearr_35442_35505 = state_35421__$1;
(statearr_35442_35505[(2)] = inst_35401);

(statearr_35442_35505[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (29))){
var inst_35355 = (state_35421[(13)]);
var inst_35386 = typeof inst_35355 === 'number';
var state_35421__$1 = state_35421;
if(cljs.core.truth_(inst_35386)){
var statearr_35443_35506 = state_35421__$1;
(statearr_35443_35506[(1)] = (31));

} else {
var statearr_35444_35507 = state_35421__$1;
(statearr_35444_35507[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (6))){
var inst_35301 = (state_35421[(14)]);
var inst_35306 = inst_35301.cljs$lang$protocol_mask$partition0$;
var inst_35307 = (inst_35306 & (64));
var inst_35308 = inst_35301.cljs$core$ISeq$;
var inst_35309 = (cljs.core.PROTOCOL_SENTINEL === inst_35308);
var inst_35310 = ((inst_35307) || (inst_35309));
var state_35421__$1 = state_35421;
if(cljs.core.truth_(inst_35310)){
var statearr_35445_35508 = state_35421__$1;
(statearr_35445_35508[(1)] = (9));

} else {
var statearr_35446_35509 = state_35421__$1;
(statearr_35446_35509[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (28))){
var inst_35353 = (state_35421[(7)]);
var inst_35383 = cljs.core.PersistentHashMap.EMPTY;
var inst_35384 = fluree.db.query.analytical.tuples__GT_map(inst_35383,inst_35353);
var state_35421__$1 = state_35421;
var statearr_35447_35510 = state_35421__$1;
(statearr_35447_35510[(2)] = inst_35384);

(statearr_35447_35510[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (25))){
var state_35421__$1 = state_35421;
var statearr_35448_35511 = state_35421__$1;
(statearr_35448_35511[(2)] = null);

(statearr_35448_35511[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (34))){
var inst_35349 = (state_35421[(16)]);
var inst_35353 = (state_35421[(7)]);
var inst_35394 = cljs.core.PersistentHashMap.EMPTY;
var inst_35395 = cljs.core.first(inst_35349);
var inst_35396 = cljs.core.first(inst_35395);
var inst_35397 = cljs.core.flatten(inst_35353);
var inst_35398 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35394,inst_35396,inst_35397);
var state_35421__$1 = state_35421;
var statearr_35449_35512 = state_35421__$1;
(statearr_35449_35512[(2)] = inst_35398);

(statearr_35449_35512[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (17))){
var inst_35337 = (state_35421[(15)]);
var inst_35338 = (state_35421[(17)]);
var inst_35343 = (state_35421[(2)]);
var inst_35344 = [inst_35343];
var inst_35345 = cljs.core.PersistentHashMap.fromArrays(inst_35338,inst_35344);
var inst_35346 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_35337,inst_35345);
var state_35421__$1 = state_35421;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35421__$1,(18),inst_35346);
} else {
if((state_val_35422 === (3))){
var inst_35419 = (state_35421[(2)]);
var state_35421__$1 = state_35421;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35421__$1,inst_35419);
} else {
if((state_val_35422 === (12))){
var inst_35301 = (state_35421[(14)]);
var inst_35319 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35301);
var state_35421__$1 = state_35421;
var statearr_35450_35513 = state_35421__$1;
(statearr_35450_35513[(2)] = inst_35319);

(statearr_35450_35513[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (2))){
var inst_35301 = (state_35421[(14)]);
var _ = (function (){var statearr_35451 = state_35421;
(statearr_35451[(4)] = cljs.core.cons((5),(state_35421[(4)])));

return statearr_35451;
})();
var inst_35301__$1 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_35303 = (inst_35301__$1 == null);
var inst_35304 = cljs.core.not(inst_35303);
var state_35421__$1 = (function (){var statearr_35452 = state_35421;
(statearr_35452[(14)] = inst_35301__$1);

return statearr_35452;
})();
if(inst_35304){
var statearr_35453_35514 = state_35421__$1;
(statearr_35453_35514[(1)] = (6));

} else {
var statearr_35454_35515 = state_35421__$1;
(statearr_35454_35515[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (23))){
var state_35421__$1 = state_35421;
var statearr_35455_35516 = state_35421__$1;
(statearr_35455_35516[(2)] = null);

(statearr_35455_35516[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (35))){
var state_35421__$1 = state_35421;
var statearr_35456_35517 = state_35421__$1;
(statearr_35456_35517[(2)] = null);

(statearr_35456_35517[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (19))){
var inst_35337 = (state_35421[(15)]);
var inst_35358 = (state_35421[(18)]);
var inst_35355 = cljs.core.first(inst_35337);
var inst_35356 = cljs.core.first(clause);
var inst_35357 = fluree.db.query.analytical.variable_QMARK_(inst_35356);
var inst_35358__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_35337,(1));
var inst_35359 = fluree.db.query.analytical.variable_QMARK_(inst_35358__$1);
var state_35421__$1 = (function (){var statearr_35457 = state_35421;
(statearr_35457[(13)] = inst_35355);

(statearr_35457[(8)] = inst_35357);

(statearr_35457[(18)] = inst_35358__$1);

return statearr_35457;
})();
if(cljs.core.truth_(inst_35359)){
var statearr_35458_35518 = state_35421__$1;
(statearr_35458_35518[(1)] = (22));

} else {
var statearr_35459_35519 = state_35421__$1;
(statearr_35459_35519[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (11))){
var inst_35314 = (state_35421[(2)]);
var state_35421__$1 = state_35421;
var statearr_35461_35520 = state_35421__$1;
(statearr_35461_35520[(2)] = inst_35314);

(statearr_35461_35520[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (9))){
var state_35421__$1 = state_35421;
var statearr_35462_35521 = state_35421__$1;
(statearr_35462_35521[(2)] = true);

(statearr_35462_35521[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (5))){
var _ = (function (){var statearr_35463 = state_35421;
(statearr_35463[(4)] = cljs.core.rest((state_35421[(4)])));

return statearr_35463;
})();
var state_35421__$1 = state_35421;
var ex35460 = (state_35421__$1[(2)]);
var statearr_35464_35522 = state_35421__$1;
(statearr_35464_35522[(5)] = ex35460);


if((ex35460 instanceof Error)){
var statearr_35465_35523 = state_35421__$1;
(statearr_35465_35523[(1)] = (4));

(statearr_35465_35523[(5)] = null);

} else {
throw ex35460;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (14))){
var inst_35324 = (state_35421[(12)]);
var inst_35339 = (state_35421[(11)]);
var inst_35328 = (state_35421[(19)]);
var inst_35327 = (state_35421[(20)]);
var inst_35322 = (state_35421[(2)]);
var inst_35323 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35322,cljs.core.cst$kw$search);
var inst_35324__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35322,cljs.core.cst$kw$rel);
var inst_35325 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35322,cljs.core.cst$kw$opts);
var inst_35326 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_35327__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_35325);
var inst_35328__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_35325);
var inst_35330 = (function (){var map__35297 = inst_35322;
var search = inst_35323;
var rel = inst_35324__$1;
var opts = inst_35325;
var common_keys = inst_35326;
var object_fn = inst_35327__$1;
var recur_depth = inst_35328__$1;
return (function (p__35329,common_key){
var vec__35466 = p__35329;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35466,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35466,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__35469 = cljs.core._EQ_;
var expr__35470 = idx_of;
if(cljs.core.truth_((pred__35469.cljs$core$IFn$_invoke$arity$2 ? pred__35469.cljs$core$IFn$_invoke$arity$2((0),expr__35470) : pred__35469.call(null,(0),expr__35470)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__35469.cljs$core$IFn$_invoke$arity$2 ? pred__35469.cljs$core$IFn$_invoke$arity$2((1),expr__35470) : pred__35469.call(null,(1),expr__35470)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__35469.cljs$core$IFn$_invoke$arity$2 ? pred__35469.cljs$core$IFn$_invoke$arity$2((2),expr__35470) : pred__35469.call(null,(2),expr__35470)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__35470)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_35331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35332 = cljs.core.PersistentHashMap.EMPTY;
var inst_35333 = [inst_35332,inst_35323];
var inst_35334 = (new cljs.core.PersistentVector(null,2,(5),inst_35331,inst_35333,null));
var inst_35335 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35330,inst_35334,inst_35326);
var inst_35336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35335,(0),null);
var inst_35337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35335,(1),null);
var inst_35338 = [cljs.core.cst$kw$object_DASH_fn];
var inst_35339__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_35336);
var state_35421__$1 = (function (){var statearr_35472 = state_35421;
(statearr_35472[(12)] = inst_35324__$1);

(statearr_35472[(15)] = inst_35337);

(statearr_35472[(11)] = inst_35339__$1);

(statearr_35472[(19)] = inst_35328__$1);

(statearr_35472[(17)] = inst_35338);

(statearr_35472[(20)] = inst_35327__$1);

return statearr_35472;
})();
if(cljs.core.truth_(inst_35339__$1)){
var statearr_35473_35524 = state_35421__$1;
(statearr_35473_35524[(1)] = (15));

} else {
var statearr_35474_35525 = state_35421__$1;
(statearr_35474_35525[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (26))){
var inst_35337 = (state_35421[(15)]);
var inst_35374 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35337)].join('');
var inst_35375 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35376 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_35377 = cljs.core.PersistentHashMap.fromArrays(inst_35375,inst_35376);
var inst_35378 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35374,inst_35377);
var inst_35379 = (function(){throw inst_35378})();
var state_35421__$1 = state_35421;
var statearr_35475_35526 = state_35421__$1;
(statearr_35475_35526[(2)] = inst_35379);

(statearr_35475_35526[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (16))){
var inst_35327 = (state_35421[(20)]);
var state_35421__$1 = state_35421;
var statearr_35476_35527 = state_35421__$1;
(statearr_35476_35527[(2)] = inst_35327);

(statearr_35476_35527[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (30))){
var inst_35357 = (state_35421[(8)]);
var inst_35328 = (state_35421[(19)]);
var inst_35358 = (state_35421[(18)]);
var inst_35405 = (state_35421[(2)]);
var inst_35406 = fluree.db.query.analytical.tuples__GT_recur(db,inst_35358,inst_35405,inst_35328,inst_35357);
var state_35421__$1 = state_35421;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35421__$1,(37),inst_35406);
} else {
if((state_val_35422 === (10))){
var state_35421__$1 = state_35421;
var statearr_35477_35528 = state_35421__$1;
(statearr_35477_35528[(2)] = false);

(statearr_35477_35528[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (18))){
var inst_35349 = (state_35421[(16)]);
var inst_35324 = (state_35421[(12)]);
var inst_35328 = (state_35421[(19)]);
var inst_35348 = (state_35421[(2)]);
var inst_35349__$1 = fluree.db.util.async.throw_err(inst_35348);
var inst_35350 = cljs.core.count(inst_35349__$1);
var inst_35351 = fluree.db.query.analytical.add_fuel(inst_35350,fuel,max_fuel);
var inst_35352 = cljs.core.vals(inst_35324);
var inst_35353 = fluree.db.query.analytical.get_ns_arrays(inst_35352,inst_35349__$1);
var state_35421__$1 = (function (){var statearr_35478 = state_35421;
(statearr_35478[(16)] = inst_35349__$1);

(statearr_35478[(7)] = inst_35353);

(statearr_35478[(21)] = inst_35351);

return statearr_35478;
})();
if(cljs.core.truth_(inst_35328)){
var statearr_35479_35529 = state_35421__$1;
(statearr_35479_35529[(1)] = (19));

} else {
var statearr_35480_35530 = state_35421__$1;
(statearr_35480_35530[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (37))){
var inst_35408 = (state_35421[(2)]);
var inst_35409 = fluree.db.util.async.throw_err(inst_35408);
var state_35421__$1 = state_35421;
var statearr_35481_35531 = state_35421__$1;
(statearr_35481_35531[(2)] = inst_35409);

(statearr_35481_35531[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35422 === (8))){
var inst_35317 = (state_35421[(2)]);
var state_35421__$1 = state_35421;
if(cljs.core.truth_(inst_35317)){
var statearr_35482_35532 = state_35421__$1;
(statearr_35482_35532[(1)] = (12));

} else {
var statearr_35483_35533 = state_35421__$1;
(statearr_35483_35533[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16291__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16291__auto____0 = (function (){
var statearr_35484 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35484[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16291__auto__);

(statearr_35484[(1)] = (1));

return statearr_35484;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16291__auto____1 = (function (state_35421){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_35421);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e35485){var ex__16294__auto__ = e35485;
var statearr_35486_35534 = state_35421;
(statearr_35486_35534[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_35421[(4)]))){
var statearr_35487_35535 = state_35421;
(statearr_35487_35535[(1)] = cljs.core.first((state_35421[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__35536 = state_35421;
state_35421 = G__35536;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16291__auto__ = function(state_35421){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16291__auto____1.call(this,state_35421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16291__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16291__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_35488 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_35488[(6)] = c__16328__auto__);

return statearr_35488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(db,res,clause){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_35635){
var state_val_35636 = (state_35635[(1)]);
if((state_val_35636 === (7))){
var inst_35546 = (state_35635[(7)]);
var state_35635__$1 = state_35635;
var statearr_35637_35677 = state_35635__$1;
(statearr_35637_35677[(2)] = inst_35546);

(statearr_35637_35677[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (20))){
var inst_35626 = (state_35635[(2)]);
var state_35635__$1 = state_35635;
var statearr_35638_35678 = state_35635__$1;
(statearr_35638_35678[(2)] = inst_35626);

(statearr_35638_35678[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (1))){
var state_35635__$1 = state_35635;
var statearr_35639_35679 = state_35635__$1;
(statearr_35639_35679[(2)] = null);

(statearr_35639_35679[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (24))){
var inst_35605 = (state_35635[(2)]);
var inst_35606 = fluree.db.util.async.throw_err(inst_35605);
var state_35635__$1 = state_35635;
var statearr_35640_35680 = state_35635__$1;
(statearr_35640_35680[(2)] = inst_35606);

(statearr_35640_35680[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (4))){
var inst_35539 = (state_35635[(2)]);
var state_35635__$1 = state_35635;
var statearr_35641_35681 = state_35635__$1;
(statearr_35641_35681[(2)] = inst_35539);

(statearr_35641_35681[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (15))){
var inst_35548 = (state_35635[(8)]);
var inst_35546 = (state_35635[(7)]);
var inst_35567 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_35568 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_35569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35570 = [inst_35546];
var inst_35571 = (new cljs.core.PersistentVector(null,1,(5),inst_35569,inst_35570,null));
var inst_35572 = (function (){var subject_var = inst_35546;
var object_var = inst_35548;
var min_sid = inst_35567;
var max_sid = (0);
return (function (p1__35537_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__35537_SHARP_);
});
})();
var inst_35573 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_35567,(0));
var inst_35574 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35572,inst_35573);
var inst_35575 = cljs.core.PersistentHashMap.EMPTY;
var inst_35576 = [inst_35571,inst_35574,inst_35575];
var inst_35577 = cljs.core.PersistentHashMap.fromArrays(inst_35568,inst_35576);
var state_35635__$1 = state_35635;
var statearr_35642_35682 = state_35635__$1;
(statearr_35642_35682[(2)] = inst_35577);

(statearr_35642_35682[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (21))){
var inst_35599 = (state_35635[(9)]);
var state_35635__$1 = state_35635;
var statearr_35643_35683 = state_35635__$1;
(statearr_35643_35683[(2)] = inst_35599);

(statearr_35643_35683[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (13))){
var inst_35548 = (state_35635[(8)]);
var state_35635__$1 = state_35635;
if(cljs.core.truth_(inst_35548)){
var statearr_35644_35684 = state_35635__$1;
(statearr_35644_35684[(1)] = (18));

} else {
var statearr_35645_35685 = state_35635__$1;
(statearr_35645_35685[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (22))){
var inst_35599 = (state_35635[(9)]);
var inst_35603 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_35599);
var state_35635__$1 = state_35635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35635__$1,(24),inst_35603);
} else {
if((state_val_35636 === (6))){
var inst_35548 = (state_35635[(8)]);
var state_35635__$1 = state_35635;
var statearr_35646_35686 = state_35635__$1;
(statearr_35646_35686[(2)] = inst_35548);

(statearr_35646_35686[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (17))){
var inst_35596 = (state_35635[(2)]);
var state_35635__$1 = state_35635;
var statearr_35647_35687 = state_35635__$1;
(statearr_35647_35687[(2)] = inst_35596);

(statearr_35647_35687[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (3))){
var inst_35633 = (state_35635[(2)]);
var state_35635__$1 = state_35635;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35635__$1,inst_35633);
} else {
if((state_val_35636 === (12))){
var inst_35561 = ["_tx",null,"_block",null];
var inst_35562 = (new cljs.core.PersistentArrayMap(null,2,inst_35561,null));
var inst_35563 = (new cljs.core.PersistentHashSet(null,inst_35562,null));
var inst_35564 = cljs.core.last(clause);
var inst_35565 = (inst_35563.cljs$core$IFn$_invoke$arity$1 ? inst_35563.cljs$core$IFn$_invoke$arity$1(inst_35564) : inst_35563.call(null,inst_35564));
var state_35635__$1 = state_35635;
if(cljs.core.truth_(inst_35565)){
var statearr_35648_35688 = state_35635__$1;
(statearr_35648_35688[(1)] = (15));

} else {
var statearr_35649_35689 = state_35635__$1;
(statearr_35649_35689[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (2))){
var inst_35546 = (state_35635[(7)]);
var _ = (function (){var statearr_35650 = state_35635;
(statearr_35650[(4)] = cljs.core.cons((5),(state_35635[(4)])));

return statearr_35650;
})();
var inst_35545 = cljs.core.first(clause);
var inst_35546__$1 = fluree.db.query.analytical.variable_QMARK_(inst_35545);
var inst_35547 = cljs.core.last(clause);
var inst_35548 = fluree.db.query.analytical.variable_QMARK_(inst_35547);
var state_35635__$1 = (function (){var statearr_35651 = state_35635;
(statearr_35651[(8)] = inst_35548);

(statearr_35651[(7)] = inst_35546__$1);

return statearr_35651;
})();
if(cljs.core.truth_(inst_35546__$1)){
var statearr_35652_35690 = state_35635__$1;
(statearr_35652_35690[(1)] = (6));

} else {
var statearr_35653_35691 = state_35635__$1;
(statearr_35653_35691[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (23))){
var inst_35548 = (state_35635[(8)]);
var inst_35608 = (state_35635[(2)]);
var inst_35609 = fluree.db.flake.sid__GT_cid(inst_35608);
var inst_35610 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_35609);
var inst_35611 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_35612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35613 = [inst_35548];
var inst_35614 = (new cljs.core.PersistentVector(null,1,(5),inst_35612,inst_35613,null));
var inst_35615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35617 = [inst_35610];
var inst_35618 = (new cljs.core.PersistentVector(null,1,(5),inst_35616,inst_35617,null));
var inst_35619 = [inst_35618];
var inst_35620 = (new cljs.core.PersistentVector(null,1,(5),inst_35615,inst_35619,null));
var inst_35621 = cljs.core.PersistentHashMap.EMPTY;
var inst_35622 = [inst_35614,inst_35620,inst_35621];
var inst_35623 = cljs.core.PersistentHashMap.fromArrays(inst_35611,inst_35622);
var state_35635__$1 = state_35635;
var statearr_35654_35692 = state_35635__$1;
(statearr_35654_35692[(2)] = inst_35623);

(statearr_35654_35692[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (19))){
var state_35635__$1 = state_35635;
var statearr_35655_35693 = state_35635__$1;
(statearr_35655_35693[(2)] = null);

(statearr_35655_35693[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (11))){
var inst_35630 = (state_35635[(2)]);
var _ = (function (){var statearr_35657 = state_35635;
(statearr_35657[(4)] = cljs.core.rest((state_35635[(4)])));

return statearr_35657;
})();
var state_35635__$1 = state_35635;
var statearr_35658_35694 = state_35635__$1;
(statearr_35658_35694[(2)] = inst_35630);

(statearr_35658_35694[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (9))){
var inst_35554 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35555 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_35556 = cljs.core.PersistentHashMap.fromArrays(inst_35554,inst_35555);
var inst_35557 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_35556);
var inst_35558 = (function(){throw inst_35557})();
var state_35635__$1 = state_35635;
var statearr_35659_35695 = state_35635__$1;
(statearr_35659_35695[(2)] = inst_35558);

(statearr_35659_35695[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (5))){
var _ = (function (){var statearr_35660 = state_35635;
(statearr_35660[(4)] = cljs.core.rest((state_35635[(4)])));

return statearr_35660;
})();
var state_35635__$1 = state_35635;
var ex35656 = (state_35635__$1[(2)]);
var statearr_35661_35696 = state_35635__$1;
(statearr_35661_35696[(5)] = ex35656);


if((ex35656 instanceof Error)){
var statearr_35662_35697 = state_35635__$1;
(statearr_35662_35697[(1)] = (4));

(statearr_35662_35697[(5)] = null);

} else {
throw ex35656;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (14))){
var inst_35628 = (state_35635[(2)]);
var state_35635__$1 = state_35635;
var statearr_35663_35698 = state_35635__$1;
(statearr_35663_35698[(2)] = inst_35628);

(statearr_35663_35698[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (16))){
var inst_35548 = (state_35635[(8)]);
var inst_35546 = (state_35635[(7)]);
var inst_35579 = cljs.core.last(clause);
var inst_35580 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,inst_35579);
var inst_35581 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_35582 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35581,inst_35580);
var inst_35583 = fluree.db.flake.min_subject_id(inst_35580);
var inst_35584 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_35585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35586 = [inst_35546];
var inst_35587 = (new cljs.core.PersistentVector(null,1,(5),inst_35585,inst_35586,null));
var inst_35588 = (function (){var subject_var = inst_35546;
var object_var = inst_35548;
var cid = inst_35580;
var max_sid = inst_35582;
var min_sid = inst_35583;
return (function (p1__35538_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__35538_SHARP_);
});
})();
var inst_35589 = (inst_35582 + (1));
var inst_35590 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_35583,inst_35589);
var inst_35591 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35588,inst_35590);
var inst_35592 = cljs.core.PersistentHashMap.EMPTY;
var inst_35593 = [inst_35587,inst_35591,inst_35592];
var inst_35594 = cljs.core.PersistentHashMap.fromArrays(inst_35584,inst_35593);
var state_35635__$1 = state_35635;
var statearr_35664_35699 = state_35635__$1;
(statearr_35664_35699[(2)] = inst_35594);

(statearr_35664_35699[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (10))){
var inst_35546 = (state_35635[(7)]);
var state_35635__$1 = state_35635;
if(cljs.core.truth_(inst_35546)){
var statearr_35665_35700 = state_35635__$1;
(statearr_35665_35700[(1)] = (12));

} else {
var statearr_35666_35701 = state_35635__$1;
(statearr_35666_35701[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (18))){
var inst_35599 = (state_35635[(9)]);
var inst_35599__$1 = cljs.core.first(clause);
var inst_35600 = typeof inst_35599__$1 === 'number';
var state_35635__$1 = (function (){var statearr_35667 = state_35635;
(statearr_35667[(9)] = inst_35599__$1);

return statearr_35667;
})();
if(cljs.core.truth_(inst_35600)){
var statearr_35668_35702 = state_35635__$1;
(statearr_35668_35702[(1)] = (21));

} else {
var statearr_35669_35703 = state_35635__$1;
(statearr_35669_35703[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35636 === (8))){
var inst_35552 = (state_35635[(2)]);
var state_35635__$1 = state_35635;
if(cljs.core.truth_(inst_35552)){
var statearr_35670_35704 = state_35635__$1;
(statearr_35670_35704[(1)] = (9));

} else {
var statearr_35671_35705 = state_35635__$1;
(statearr_35671_35705[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16291__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16291__auto____0 = (function (){
var statearr_35672 = [null,null,null,null,null,null,null,null,null,null];
(statearr_35672[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16291__auto__);

(statearr_35672[(1)] = (1));

return statearr_35672;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16291__auto____1 = (function (state_35635){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_35635);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e35673){var ex__16294__auto__ = e35673;
var statearr_35674_35706 = state_35635;
(statearr_35674_35706[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_35635[(4)]))){
var statearr_35675_35707 = state_35635;
(statearr_35675_35707[(1)] = cljs.core.first((state_35635[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__35708 = state_35635;
state_35635 = G__35708;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16291__auto__ = function(state_35635){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16291__auto____1.call(this,state_35635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16291__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16291__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_35676 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_35676[(6)] = c__16328__auto__);

return statearr_35676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__35715 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__35715 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__35715;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__35716(s__35717){
return (new cljs.core.LazySeq(null,(function (){
var s__35717__$1 = s__35717;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__35717__$1);
if(temp__5735__auto__){
var s__35717__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35717__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__35717__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__35719 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__35718 = (0);
while(true){
if((i__35718 < size__4528__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__35718);
var delta = (x - mean);
cljs.core.chunk_append(b__35719,(delta * delta));

var G__35721 = (i__35718 + (1));
i__35718 = G__35721;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35719),fluree$db$query$analytical$variance_$_iter__35716(cljs.core.chunk_rest(s__35717__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35719),null);
}
} else {
var x = cljs.core.first(s__35717__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__35716(cljs.core.rest(s__35717__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__35720 = variance(coll);
return Math.sqrt(G__35720);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__35722 = null;
var G__35722__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__35722__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__35722 = function(n,coll){
switch(arguments.length){
case 1:
return G__35722__1.call(this,n);
case 2:
return G__35722__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35722.cljs$core$IFn$_invoke$arity$1 = G__35722__1;
G__35722.cljs$core$IFn$_invoke$arity$2 = G__35722__2;
return G__35722;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__35723 = null;
var G__35723__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__35723__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__35723 = function(n,coll){
switch(arguments.length){
case 1:
return G__35723__1.call(this,n);
case 2:
return G__35723__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35723.cljs$core$IFn$_invoke$arity$1 = G__35723__1;
G__35723.cljs$core$IFn$_invoke$arity$2 = G__35723__2;
return G__35723;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__35724 = null;
var G__35724__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__35724__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__35724 = function(n,coll){
switch(arguments.length){
case 1:
return G__35724__1.call(this,n);
case 2:
return G__35724__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35724.cljs$core$IFn$_invoke$arity$1 = G__35724__1;
G__35724.cljs$core$IFn$_invoke$arity$2 = G__35724__2;
return G__35724;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__35725 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35725,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35725,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35725,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__35728 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__35731 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__35731) : agg_fn.call(null,G__35731));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35728,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35728,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__35732 = agg;
var map__35732__$1 = (((((!((map__35732 == null))))?(((((map__35732.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35732.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35732):map__35732);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35732__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35732__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35732__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__35735 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35735,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35735,(1),null);
var map__35738 = res__$1;
var map__35738__$1 = (((((!((map__35738 == null))))?(((((map__35738.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35738.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35738):map__35738);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35738__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35738__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35734_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__35734_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35740_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__35740_SHARP_);
}),a_idxs);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,b_tuple){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35741_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__35741_SHARP_);
}),b_idxs))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35742_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__35742_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35743_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__35743_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__35746,row,b_tuple){
var vec__35747 = p__35746;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35747,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35747,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35744_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__35744_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35745_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__35745_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35750_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__35750_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35751_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__35751_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__35756 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__35758 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__35757 = (function (p1__35752_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__35752_SHARP_);
});
return fexpr__35757(G__35758);
})()),cljs.core.set(b_idxs));
var fexpr__35755 = (function (p1__35753_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__35753_SHARP_);
});
return fexpr__35755(G__35756);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
return fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35754_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__35754_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35759_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__35759_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35760_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__35760_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__35765 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__35767 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__35766 = (function (p1__35761_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__35761_SHARP_);
});
return fexpr__35766(G__35767);
})()),cljs.core.set(b_idxs));
var fexpr__35764 = (function (p1__35762_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__35762_SHARP_);
});
return fexpr__35764(G__35765);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
var matches = fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35763_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__35763_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35768_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__35768_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35769_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__35769_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__35778 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__35780 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__35779 = (function (p1__35770_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__35770_SHARP_);
});
return fexpr__35779(G__35780);
})()),cljs.core.set(b_idxs));
var fexpr__35777 = (function (p1__35771_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__35771_SHARP_);
});
return fexpr__35777(G__35778);
})();
var vec__35774 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__35781,a_tuple){
var vec__35782 = p__35781;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35782,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35782,(1),null);
var vec__35785 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35785,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35785,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35774,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35774,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35772_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__35772_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35773_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__35773_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__35789 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35789,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35789,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__35788_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__35788_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__35794 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35794,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35794,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35792_SHARP_){
return fluree.db.util.core.index_of(headers,p1__35792_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__35793_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__35793_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__35797,filters,optional_QMARK_){
var map__35798 = p__35797;
var map__35798__$1 = (((((!((map__35798 == null))))?(((((map__35798.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35798.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35798):map__35798);
var tuple_map = map__35798__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35798__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35798__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35798__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__35800 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35800,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35800,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__35803 = res;
var map__35803__$1 = (((((!((map__35803 == null))))?(((((map__35803.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35803.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35803):map__35803);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35803__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35803__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5733__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_35860){
var state_val_35861 = (state_35860[(1)]);
if((state_val_35861 === (7))){
var inst_35834 = (state_35860[(7)]);
var inst_35832 = (state_35860[(2)]);
var inst_35833 = fluree.db.util.async.throw_err(inst_35832);
var inst_35834__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35833,(0),null);
var inst_35835 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35833,(1),null);
var inst_35836 = (inst_35834__$1 == null);
var state_35860__$1 = (function (){var statearr_35862 = state_35860;
(statearr_35862[(8)] = inst_35835);

(statearr_35862[(7)] = inst_35834__$1);

return statearr_35862;
})();
if(cljs.core.truth_(inst_35836)){
var statearr_35863_35892 = state_35860__$1;
(statearr_35863_35892[(1)] = (8));

} else {
var statearr_35864_35893 = state_35860__$1;
(statearr_35864_35893[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (1))){
var inst_35812 = optional_clauses;
var inst_35813 = cljs.core.seq(inst_35812);
var inst_35814 = cljs.core.first(inst_35813);
var inst_35815 = cljs.core.next(inst_35813);
var inst_35816 = where_tuples;
var inst_35817 = inst_35812;
var inst_35818 = inst_35816;
var state_35860__$1 = (function (){var statearr_35865 = state_35860;
(statearr_35865[(9)] = inst_35817);

(statearr_35865[(10)] = inst_35818);

(statearr_35865[(11)] = inst_35815);

(statearr_35865[(12)] = inst_35814);

return statearr_35865;
})();
var statearr_35866_35894 = state_35860__$1;
(statearr_35866_35894[(2)] = null);

(statearr_35866_35894[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (4))){
var inst_35818 = (state_35860[(10)]);
var inst_35825 = (state_35860[(13)]);
var inst_35824 = (state_35860[(14)]);
var inst_35830 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_35818,inst_35824,inst_35825,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_35818,inst_35824,inst_35825,true,fuel,max_fuel,opts));
var state_35860__$1 = state_35860;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35860__$1,(7),inst_35830);
} else {
if((state_val_35861 === (15))){
var state_35860__$1 = state_35860;
var statearr_35867_35895 = state_35860__$1;
(statearr_35867_35895[(2)] = null);

(statearr_35867_35895[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (13))){
var inst_35851 = (state_35860[(2)]);
var state_35860__$1 = state_35860;
var statearr_35868_35896 = state_35860__$1;
(statearr_35868_35896[(2)] = inst_35851);

(statearr_35868_35896[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (6))){
var inst_35856 = (state_35860[(2)]);
var state_35860__$1 = state_35860;
var statearr_35869_35897 = state_35860__$1;
(statearr_35869_35897[(2)] = inst_35856);

(statearr_35869_35897[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (3))){
var inst_35858 = (state_35860[(2)]);
var state_35860__$1 = state_35860;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35860__$1,inst_35858);
} else {
if((state_val_35861 === (12))){
var state_35860__$1 = state_35860;
var statearr_35870_35898 = state_35860__$1;
(statearr_35870_35898[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (2))){
var inst_35817 = (state_35860[(9)]);
var inst_35824 = (state_35860[(14)]);
var inst_35823 = cljs.core.seq(inst_35817);
var inst_35824__$1 = cljs.core.first(inst_35823);
var inst_35825 = cljs.core.next(inst_35823);
var state_35860__$1 = (function (){var statearr_35872 = state_35860;
(statearr_35872[(13)] = inst_35825);

(statearr_35872[(14)] = inst_35824__$1);

return statearr_35872;
})();
if(cljs.core.truth_(inst_35824__$1)){
var statearr_35873_35899 = state_35860__$1;
(statearr_35873_35899[(1)] = (4));

} else {
var statearr_35874_35900 = state_35860__$1;
(statearr_35874_35900[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (11))){
var inst_35835 = (state_35860[(8)]);
var inst_35834 = (state_35860[(7)]);
var inst_35817 = inst_35835;
var inst_35818 = inst_35834;
var state_35860__$1 = (function (){var statearr_35875 = state_35860;
(statearr_35875[(9)] = inst_35817);

(statearr_35875[(10)] = inst_35818);

return statearr_35875;
})();
var statearr_35876_35901 = state_35860__$1;
(statearr_35876_35901[(2)] = null);

(statearr_35876_35901[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (9))){
var inst_35824 = (state_35860[(14)]);
var inst_35840 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_35824);
var state_35860__$1 = state_35860;
if(cljs.core.truth_(inst_35840)){
var statearr_35877_35902 = state_35860__$1;
(statearr_35877_35902[(1)] = (11));

} else {
var statearr_35878_35903 = state_35860__$1;
(statearr_35878_35903[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (5))){
var inst_35818 = (state_35860[(10)]);
var state_35860__$1 = state_35860;
var statearr_35879_35904 = state_35860__$1;
(statearr_35879_35904[(2)] = inst_35818);

(statearr_35879_35904[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (14))){
var inst_35818 = (state_35860[(10)]);
var inst_35835 = (state_35860[(8)]);
var inst_35834 = (state_35860[(7)]);
var inst_35845 = fluree.db.query.analytical.left_outer_join(inst_35818,inst_35834);
var inst_35817 = inst_35835;
var inst_35818__$1 = inst_35845;
var state_35860__$1 = (function (){var statearr_35880 = state_35860;
(statearr_35880[(9)] = inst_35817);

(statearr_35880[(10)] = inst_35818__$1);

return statearr_35880;
})();
var statearr_35881_35905 = state_35860__$1;
(statearr_35881_35905[(2)] = null);

(statearr_35881_35905[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (16))){
var inst_35849 = (state_35860[(2)]);
var state_35860__$1 = state_35860;
var statearr_35883_35906 = state_35860__$1;
(statearr_35883_35906[(2)] = inst_35849);

(statearr_35883_35906[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (10))){
var inst_35853 = (state_35860[(2)]);
var state_35860__$1 = state_35860;
var statearr_35884_35907 = state_35860__$1;
(statearr_35884_35907[(2)] = inst_35853);

(statearr_35884_35907[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35861 === (8))){
var inst_35818 = (state_35860[(10)]);
var inst_35835 = (state_35860[(8)]);
var tmp35882 = inst_35818;
var inst_35817 = inst_35835;
var inst_35818__$1 = tmp35882;
var state_35860__$1 = (function (){var statearr_35885 = state_35860;
(statearr_35885[(9)] = inst_35817);

(statearr_35885[(10)] = inst_35818__$1);

return statearr_35885;
})();
var statearr_35886_35908 = state_35860__$1;
(statearr_35886_35908[(2)] = null);

(statearr_35886_35908[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16291__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16291__auto____0 = (function (){
var statearr_35887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35887[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16291__auto__);

(statearr_35887[(1)] = (1));

return statearr_35887;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16291__auto____1 = (function (state_35860){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_35860);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e35888){var ex__16294__auto__ = e35888;
var statearr_35889_35909 = state_35860;
(statearr_35889_35909[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_35860[(4)]))){
var statearr_35890_35910 = state_35860;
(statearr_35890_35910[(1)] = cljs.core.first((state_35860[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__35911 = state_35860;
state_35860 = G__35911;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16291__auto__ = function(state_35860){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16291__auto____1.call(this,state_35860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16291__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16291__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_35891 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_35891[(6)] = c__16328__auto__);

return statearr_35891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__35913){
var vec__35914 = p__35913;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35914,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35914,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35912_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35912_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__35918,p__35919,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__35920 = p__35918;
var map__35920__$1 = (((((!((map__35920 == null))))?(((((map__35920.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35920.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35920):map__35920);
var q_map = map__35920__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35920__$1,cljs.core.cst$kw$prefixes);
var map__35921 = p__35919;
var map__35921__$1 = (((((!((map__35921 == null))))?(((((map__35921.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35921.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35921):map__35921);
var res = map__35921__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35921__$1,cljs.core.cst$kw$vars);
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_36130){
var state_val_36131 = (state_36130[(1)]);
if((state_val_36131 === (7))){
var inst_36028 = cljs.core.count(clause);
var inst_36029 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_36028);
var inst_36030 = cljs.core.second(clause);
var inst_36031 = clojure.string.starts_with_QMARK_(inst_36030,"fullText:");
var inst_36032 = ((inst_36029) && (inst_36031));
var state_36130__$1 = state_36130;
if(cljs.core.truth_(inst_36032)){
var statearr_36132_36227 = state_36130__$1;
(statearr_36132_36227[(1)] = (31));

} else {
var statearr_36133_36228 = state_36130__$1;
(statearr_36133_36228[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (59))){
var inst_36099 = (state_36130[(7)]);
var inst_36102 = (state_36130[(2)]);
var inst_36103 = fluree.db.util.async.throw_err(inst_36102);
var inst_36104 = [inst_36103,r];
var inst_36105 = (new cljs.core.PersistentVector(null,2,(5),inst_36099,inst_36104,null));
var state_36130__$1 = state_36130;
var statearr_36134_36229 = state_36130__$1;
(statearr_36134_36229[(2)] = inst_36105);

(statearr_36134_36229[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (20))){
var inst_35992 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36135_36230 = state_36130__$1;
(statearr_36135_36230[(2)] = inst_35992);

(statearr_36135_36230[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (58))){
var inst_36108 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36136_36231 = state_36130__$1;
(statearr_36136_36231[(2)] = inst_36108);

(statearr_36136_36231[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (27))){
var inst_36022 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36137_36232 = state_36130__$1;
(statearr_36137_36232[(2)] = inst_36022);

(statearr_36137_36232[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (1))){
var state_36130__$1 = state_36130;
var statearr_36138_36233 = state_36130__$1;
(statearr_36138_36233[(2)] = null);

(statearr_36138_36233[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (24))){
var inst_35986 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36139_36234 = state_36130__$1;
(statearr_36139_36234[(2)] = inst_35986);

(statearr_36139_36234[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (55))){
var inst_36110 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36140_36235 = state_36130__$1;
(statearr_36140_36235[(2)] = inst_36110);

(statearr_36140_36235[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (39))){
var inst_36064 = cljs.core.count(clause);
var inst_36065 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_36064);
var state_36130__$1 = state_36130;
if(inst_36065){
var statearr_36141_36236 = state_36130__$1;
(statearr_36141_36236[(1)] = (42));

} else {
var statearr_36142_36237 = state_36130__$1;
(statearr_36142_36237[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (46))){
var state_36130__$1 = state_36130;
var statearr_36143_36238 = state_36130__$1;
(statearr_36143_36238[(2)] = null);

(statearr_36143_36238[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (4))){
var inst_35924 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36144_36239 = state_36130__$1;
(statearr_36144_36239[(2)] = inst_35924);

(statearr_36144_36239[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (54))){
var state_36130__$1 = state_36130;
var statearr_36145_36240 = state_36130__$1;
(statearr_36145_36240[(1)] = (56));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (15))){
var inst_36024 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36147_36241 = state_36130__$1;
(statearr_36147_36241[(2)] = inst_36024);

(statearr_36147_36241[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (48))){
var inst_36081 = (state_36130[(8)]);
var inst_36079 = (state_36130[(2)]);
var inst_36080 = fluree.db.util.async.throw_err(inst_36079);
var inst_36081__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36080,(0),null);
var inst_36082 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36080,(1),null);
var inst_36083 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_36081__$1);
var state_36130__$1 = (function (){var statearr_36148 = state_36130;
(statearr_36148[(9)] = inst_36082);

(statearr_36148[(8)] = inst_36081__$1);

return statearr_36148;
})();
if(inst_36083){
var statearr_36149_36242 = state_36130__$1;
(statearr_36149_36242[(1)] = (49));

} else {
var statearr_36150_36243 = state_36130__$1;
(statearr_36150_36243[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (50))){
var inst_36082 = (state_36130[(9)]);
var inst_36090 = cljs.core.second(inst_36082);
var inst_36091 = clojure.string.starts_with_QMARK_(inst_36090,"fullText:");
var state_36130__$1 = state_36130;
if(inst_36091){
var statearr_36151_36244 = state_36130__$1;
(statearr_36151_36244[(1)] = (53));

} else {
var statearr_36152_36245 = state_36130__$1;
(statearr_36152_36245[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (21))){
var inst_35933 = (state_36130[(10)]);
var inst_35961 = (state_36130[(11)]);
var inst_35963 = (state_36130[(12)]);
var inst_35958 = (state_36130[(13)]);
var inst_35969 = (state_36130[(14)]);
var inst_35960 = (state_36130[(15)]);
var inst_35937 = (state_36130[(16)]);
var inst_35970 = (state_36130[(17)]);
var inst_35962 = (state_36130[(18)]);
var inst_35974 = (state_36130[(2)]);
var inst_35975 = fluree.db.util.async.throw_err(inst_35974);
var inst_35976 = (function (){var new_res = inst_35975;
var rest = inst_35970;
var tuples = inst_35963;
var seq__35966 = inst_35970;
var pred__35934 = inst_35937;
var expr__35935 = inst_35933;
var first__35957 = inst_35960;
var vec__35955 = inst_35958;
var seq__35956 = inst_35961;
var segment_type = inst_35933;
var G__35954 = inst_35962;
var first__35967 = inst_35969;
var clause_group = inst_35969;
var vec__35965 = inst_35962;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_35977 = cljs.core.keys(vars);
var inst_35978 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35976,inst_35975,inst_35977);
var inst_35979 = fluree.db.query.analytical.res_absorb_vars(inst_35978);
var state_36130__$1 = (function (){var statearr_36153 = state_36130;
(statearr_36153[(19)] = inst_35979);

return statearr_36153;
})();
if(cljs.core.truth_(inst_35963)){
var statearr_36154_36246 = state_36130__$1;
(statearr_36154_36246[(1)] = (22));

} else {
var statearr_36155_36247 = state_36130__$1;
(statearr_36155_36247[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (31))){
var inst_36034 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36035 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_36036 = [inst_36035,r];
var inst_36037 = (new cljs.core.PersistentVector(null,2,(5),inst_36034,inst_36036,null));
var state_36130__$1 = state_36130;
var statearr_36156_36248 = state_36130__$1;
(statearr_36156_36248[(2)] = inst_36037);

(statearr_36156_36248[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (32))){
var inst_36039 = cljs.core.count(clause);
var inst_36040 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_36039);
var inst_36041 = cljs.core.second(clause);
var inst_36042 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36041,"rdf:type");
var inst_36043 = ((inst_36040) && (inst_36042));
var state_36130__$1 = state_36130;
if(cljs.core.truth_(inst_36043)){
var statearr_36157_36249 = state_36130__$1;
(statearr_36157_36249[(1)] = (34));

} else {
var statearr_36158_36250 = state_36130__$1;
(statearr_36158_36250[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (40))){
var inst_36119 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36159_36251 = state_36130__$1;
(statearr_36159_36251[(2)] = inst_36119);

(statearr_36159_36251[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (56))){
var inst_36082 = (state_36130[(9)]);
var inst_36081 = (state_36130[(8)]);
var inst_36099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36100 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_36081,res,inst_36082,fuel,max_fuel);
var state_36130__$1 = (function (){var statearr_36160 = state_36130;
(statearr_36160[(7)] = inst_36099);

return statearr_36160;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36130__$1,(59),inst_36100);
} else {
if((state_val_36131 === (33))){
var inst_36123 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36161_36252 = state_36130__$1;
(statearr_36161_36252[(2)] = inst_36123);

(statearr_36161_36252[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (13))){
var inst_35958 = (state_36130[(13)]);
var inst_35958__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35959 = cljs.core.seq(inst_35958__$1);
var inst_35960 = cljs.core.first(inst_35959);
var inst_35961 = cljs.core.next(inst_35959);
var inst_35962 = inst_35958__$1;
var inst_35963 = null;
var state_36130__$1 = (function (){var statearr_36162 = state_36130;
(statearr_36162[(11)] = inst_35961);

(statearr_36162[(12)] = inst_35963);

(statearr_36162[(13)] = inst_35958__$1);

(statearr_36162[(15)] = inst_35960);

(statearr_36162[(18)] = inst_35962);

return statearr_36162;
})();
var statearr_36163_36253 = state_36130__$1;
(statearr_36163_36253[(2)] = null);

(statearr_36163_36253[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (22))){
var inst_35963 = (state_36130[(12)]);
var inst_35979 = (state_36130[(19)]);
var inst_35970 = (state_36130[(17)]);
var inst_35981 = fluree.db.query.analytical.outer_union(inst_35963,inst_35979);
var inst_35962 = inst_35970;
var inst_35963__$1 = inst_35981;
var state_36130__$1 = (function (){var statearr_36164 = state_36130;
(statearr_36164[(12)] = inst_35963__$1);

(statearr_36164[(18)] = inst_35962);

return statearr_36164;
})();
var statearr_36165_36254 = state_36130__$1;
(statearr_36165_36254[(2)] = null);

(statearr_36165_36254[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (36))){
var inst_36121 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36166_36255 = state_36130__$1;
(statearr_36166_36255[(2)] = inst_36121);

(statearr_36166_36255[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (41))){
var inst_36056 = (state_36130[(20)]);
var inst_36059 = (state_36130[(2)]);
var inst_36060 = fluree.db.util.async.throw_err(inst_36059);
var inst_36061 = [inst_36060,r];
var inst_36062 = (new cljs.core.PersistentVector(null,2,(5),inst_36056,inst_36061,null));
var state_36130__$1 = state_36130;
var statearr_36167_36256 = state_36130__$1;
(statearr_36167_36256[(2)] = inst_36062);

(statearr_36167_36256[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (43))){
var state_36130__$1 = state_36130;
var statearr_36168_36257 = state_36130__$1;
(statearr_36168_36257[(1)] = (45));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (29))){
var inst_35933 = (state_36130[(10)]);
var inst_36016 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35933)].join('');
var inst_36017 = (new Error(inst_36016));
var inst_36018 = (function(){throw inst_36017})();
var state_36130__$1 = state_36130;
var statearr_36170_36258 = state_36130__$1;
(statearr_36170_36258[(2)] = inst_36018);

(statearr_36170_36258[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (44))){
var inst_36117 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36171_36259 = state_36130__$1;
(statearr_36171_36259[(2)] = inst_36117);

(statearr_36171_36259[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (6))){
var inst_35933 = (state_36130[(10)]);
var inst_35937 = (state_36130[(16)]);
var inst_35932 = cljs.core.keys(clause);
var inst_35933__$1 = cljs.core.first(inst_35932);
var inst_35937__$1 = cljs.core._EQ_;
var inst_35938 = (function (){var G__36172 = cljs.core.cst$kw$optional;
var G__36173 = inst_35933__$1;
return (inst_35937__$1.cljs$core$IFn$_invoke$arity$2 ? inst_35937__$1.cljs$core$IFn$_invoke$arity$2(G__36172,G__36173) : inst_35937__$1.call(null,G__36172,G__36173));
})();
var state_36130__$1 = (function (){var statearr_36174 = state_36130;
(statearr_36174[(10)] = inst_35933__$1);

(statearr_36174[(16)] = inst_35937__$1);

return statearr_36174;
})();
if(cljs.core.truth_(inst_35938)){
var statearr_36175_36260 = state_36130__$1;
(statearr_36175_36260[(1)] = (9));

} else {
var statearr_36176_36261 = state_36130__$1;
(statearr_36176_36261[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (28))){
var inst_36010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36011 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_36012 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_36011,optional_QMARK_);
var inst_36013 = [inst_36012,r];
var inst_36014 = (new cljs.core.PersistentVector(null,2,(5),inst_36010,inst_36013,null));
var state_36130__$1 = state_36130;
var statearr_36177_36262 = state_36130__$1;
(statearr_36177_36262[(2)] = inst_36014);

(statearr_36177_36262[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (51))){
var inst_36112 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36178_36263 = state_36130__$1;
(statearr_36178_36263[(2)] = inst_36112);

(statearr_36178_36263[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (25))){
var inst_35933 = (state_36130[(10)]);
var inst_35937 = (state_36130[(16)]);
var inst_35998 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35999 = (function (){var segment_type = inst_35933;
var pred__35934 = inst_35937;
var expr__35935 = inst_35933;
var bindings = inst_35998;
return (function (p1__35917_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__35917_SHARP_);
});
})();
var inst_36000 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35999,inst_35998);
var inst_36001 = cljs.core.PersistentHashMap.EMPTY;
var inst_36002 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36001,inst_36000);
var inst_36003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36004 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_36002);
var inst_36005 = [inst_36004,r];
var inst_36006 = (new cljs.core.PersistentVector(null,2,(5),inst_36003,inst_36005,null));
var state_36130__$1 = state_36130;
var statearr_36179_36264 = state_36130__$1;
(statearr_36179_36264[(2)] = inst_36006);

(statearr_36179_36264[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (34))){
var inst_36045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36046 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_36130__$1 = (function (){var statearr_36180 = state_36130;
(statearr_36180[(21)] = inst_36045);

return statearr_36180;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36130__$1,(37),inst_36046);
} else {
if((state_val_36131 === (17))){
var inst_35994 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36181_36265 = state_36130__$1;
(statearr_36181_36265[(2)] = inst_35994);

(statearr_36181_36265[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (3))){
var inst_36128 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36130__$1,inst_36128);
} else {
if((state_val_36131 === (12))){
var inst_35940 = (state_36130[(22)]);
var inst_35944 = (state_36130[(2)]);
var inst_35945 = fluree.db.util.async.throw_err(inst_35944);
var inst_35946 = [inst_35945,r];
var inst_35947 = (new cljs.core.PersistentVector(null,2,(5),inst_35940,inst_35946,null));
var state_36130__$1 = state_36130;
var statearr_36182_36266 = state_36130__$1;
(statearr_36182_36266[(2)] = inst_35947);

(statearr_36182_36266[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (2))){
var _ = (function (){var statearr_36183 = state_36130;
(statearr_36183[(4)] = cljs.core.cons((5),(state_36130[(4)])));

return statearr_36183;
})();
var inst_35930 = cljs.core.map_QMARK_(clause);
var state_36130__$1 = state_36130;
if(inst_35930){
var statearr_36184_36267 = state_36130__$1;
(statearr_36184_36267[(1)] = (6));

} else {
var statearr_36185_36268 = state_36130__$1;
(statearr_36185_36268[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (23))){
var inst_35979 = (state_36130[(19)]);
var inst_35970 = (state_36130[(17)]);
var inst_35962 = inst_35970;
var inst_35963 = inst_35979;
var state_36130__$1 = (function (){var statearr_36186 = state_36130;
(statearr_36186[(12)] = inst_35963);

(statearr_36186[(18)] = inst_35962);

return statearr_36186;
})();
var statearr_36187_36269 = state_36130__$1;
(statearr_36187_36269[(2)] = null);

(statearr_36187_36269[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (47))){
var inst_36115 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36188_36270 = state_36130__$1;
(statearr_36188_36270[(2)] = inst_36115);

(statearr_36188_36270[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (35))){
var inst_36053 = cljs.core.count(clause);
var inst_36054 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_36053);
var state_36130__$1 = state_36130;
if(inst_36054){
var statearr_36189_36271 = state_36130__$1;
(statearr_36189_36271[(1)] = (38));

} else {
var statearr_36190_36272 = state_36130__$1;
(statearr_36190_36272[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (19))){
var inst_35963 = (state_36130[(12)]);
var inst_35988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35989 = [inst_35963,r];
var inst_35990 = (new cljs.core.PersistentVector(null,2,(5),inst_35988,inst_35989,null));
var state_36130__$1 = state_36130;
var statearr_36191_36273 = state_36130__$1;
(statearr_36191_36273[(2)] = inst_35990);

(statearr_36191_36273[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (57))){
var state_36130__$1 = state_36130;
var statearr_36192_36274 = state_36130__$1;
(statearr_36192_36274[(2)] = null);

(statearr_36192_36274[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (11))){
var inst_36026 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36194_36275 = state_36130__$1;
(statearr_36194_36275[(2)] = inst_36026);

(statearr_36194_36275[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (9))){
var inst_35940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35941 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35942 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_35941,res,fuel,max_fuel,opts);
var state_36130__$1 = (function (){var statearr_36195 = state_36130;
(statearr_36195[(22)] = inst_35940);

return statearr_36195;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36130__$1,(12),inst_35942);
} else {
if((state_val_36131 === (5))){
var _ = (function (){var statearr_36196 = state_36130;
(statearr_36196[(4)] = cljs.core.rest((state_36130[(4)])));

return statearr_36196;
})();
var state_36130__$1 = state_36130;
var ex36193 = (state_36130__$1[(2)]);
var statearr_36197_36276 = state_36130__$1;
(statearr_36197_36276[(5)] = ex36193);


if((ex36193 instanceof Error)){
var statearr_36198_36277 = state_36130__$1;
(statearr_36198_36277[(1)] = (4));

(statearr_36198_36277[(5)] = null);

} else {
throw ex36193;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (14))){
var inst_35933 = (state_36130[(10)]);
var inst_35937 = (state_36130[(16)]);
var inst_35996 = (function (){var G__36199 = cljs.core.cst$kw$bind;
var G__36200 = inst_35933;
return (inst_35937.cljs$core$IFn$_invoke$arity$2 ? inst_35937.cljs$core$IFn$_invoke$arity$2(G__36199,G__36200) : inst_35937.call(null,G__36199,G__36200));
})();
var state_36130__$1 = state_36130;
if(cljs.core.truth_(inst_35996)){
var statearr_36201_36278 = state_36130__$1;
(statearr_36201_36278[(1)] = (25));

} else {
var statearr_36202_36279 = state_36130__$1;
(statearr_36202_36279[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (45))){
var inst_36077 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_36130__$1 = state_36130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36130__$1,(48),inst_36077);
} else {
if((state_val_36131 === (53))){
var inst_36082 = (state_36130[(9)]);
var inst_36081 = (state_36130[(8)]);
var inst_36093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36094 = fluree.db.query.analytical.full_text__GT_tuples(inst_36081,res,inst_36082);
var inst_36095 = [inst_36094,r];
var inst_36096 = (new cljs.core.PersistentVector(null,2,(5),inst_36093,inst_36095,null));
var state_36130__$1 = state_36130;
var statearr_36203_36280 = state_36130__$1;
(statearr_36203_36280[(2)] = inst_36096);

(statearr_36203_36280[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (26))){
var inst_35933 = (state_36130[(10)]);
var inst_35937 = (state_36130[(16)]);
var inst_36008 = (function (){var G__36204 = cljs.core.cst$kw$filter;
var G__36205 = inst_35933;
return (inst_35937.cljs$core$IFn$_invoke$arity$2 ? inst_35937.cljs$core$IFn$_invoke$arity$2(G__36204,G__36205) : inst_35937.call(null,G__36204,G__36205));
})();
var state_36130__$1 = state_36130;
if(cljs.core.truth_(inst_36008)){
var statearr_36206_36281 = state_36130__$1;
(statearr_36206_36281[(1)] = (28));

} else {
var statearr_36207_36282 = state_36130__$1;
(statearr_36207_36282[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (16))){
var inst_35969 = (state_36130[(14)]);
var inst_35962 = (state_36130[(18)]);
var inst_35968 = cljs.core.seq(inst_35962);
var inst_35969__$1 = cljs.core.first(inst_35968);
var inst_35970 = cljs.core.next(inst_35968);
var state_36130__$1 = (function (){var statearr_36208 = state_36130;
(statearr_36208[(14)] = inst_35969__$1);

(statearr_36208[(17)] = inst_35970);

return statearr_36208;
})();
if(cljs.core.truth_(inst_35969__$1)){
var statearr_36209_36283 = state_36130__$1;
(statearr_36209_36283[(1)] = (18));

} else {
var statearr_36210_36284 = state_36130__$1;
(statearr_36210_36284[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (38))){
var inst_36056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36057 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_36130__$1 = (function (){var statearr_36211 = state_36130;
(statearr_36211[(20)] = inst_36056);

return statearr_36211;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36130__$1,(41),inst_36057);
} else {
if((state_val_36131 === (30))){
var inst_36020 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36212_36285 = state_36130__$1;
(statearr_36212_36285[(2)] = inst_36020);

(statearr_36212_36285[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (10))){
var inst_35933 = (state_36130[(10)]);
var inst_35937 = (state_36130[(16)]);
var inst_35949 = (function (){var G__36213 = cljs.core.cst$kw$union;
var G__36214 = inst_35933;
return (inst_35937.cljs$core$IFn$_invoke$arity$2 ? inst_35937.cljs$core$IFn$_invoke$arity$2(G__36213,G__36214) : inst_35937.call(null,G__36213,G__36214));
})();
var state_36130__$1 = state_36130;
if(cljs.core.truth_(inst_35949)){
var statearr_36215_36286 = state_36130__$1;
(statearr_36215_36286[(1)] = (13));

} else {
var statearr_36216_36287 = state_36130__$1;
(statearr_36216_36287[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (18))){
var inst_35969 = (state_36130[(14)]);
var inst_35972 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_35969,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_35969,q_map,vars,fuel,max_fuel,opts));
var state_36130__$1 = state_36130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36130__$1,(21),inst_35972);
} else {
if((state_val_36131 === (52))){
var inst_36087 = (state_36130[(2)]);
var inst_36088 = fluree.db.util.async.throw_err(inst_36087);
var state_36130__$1 = state_36130;
var statearr_36217_36288 = state_36130__$1;
(statearr_36217_36288[(2)] = inst_36088);

(statearr_36217_36288[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (42))){
var inst_36067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36068 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_36069 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_36068);
var inst_36070 = [inst_36069,r];
var inst_36071 = (new cljs.core.PersistentVector(null,2,(5),inst_36067,inst_36070,null));
var state_36130__$1 = state_36130;
var statearr_36218_36289 = state_36130__$1;
(statearr_36218_36289[(2)] = inst_36071);

(statearr_36218_36289[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (37))){
var inst_36045 = (state_36130[(21)]);
var inst_36048 = (state_36130[(2)]);
var inst_36049 = fluree.db.util.async.throw_err(inst_36048);
var inst_36050 = [inst_36049,r];
var inst_36051 = (new cljs.core.PersistentVector(null,2,(5),inst_36045,inst_36050,null));
var state_36130__$1 = state_36130;
var statearr_36219_36290 = state_36130__$1;
(statearr_36219_36290[(2)] = inst_36051);

(statearr_36219_36290[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (8))){
var inst_36125 = (state_36130[(2)]);
var _ = (function (){var statearr_36220 = state_36130;
(statearr_36220[(4)] = cljs.core.rest((state_36130[(4)])));

return statearr_36220;
})();
var state_36130__$1 = state_36130;
var statearr_36221_36291 = state_36130__$1;
(statearr_36221_36291[(2)] = inst_36125);

(statearr_36221_36291[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36131 === (49))){
var inst_36082 = (state_36130[(9)]);
var inst_36085 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_36082,r,res,optional_QMARK_,fuel,max_fuel);
var state_36130__$1 = state_36130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36130__$1,(52),inst_36085);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16291__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16291__auto____0 = (function (){
var statearr_36222 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36222[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16291__auto__);

(statearr_36222[(1)] = (1));

return statearr_36222;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16291__auto____1 = (function (state_36130){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_36130);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e36223){var ex__16294__auto__ = e36223;
var statearr_36224_36292 = state_36130;
(statearr_36224_36292[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_36130[(4)]))){
var statearr_36225_36293 = state_36130;
(statearr_36225_36293[(1)] = cljs.core.first((state_36130[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__36294 = state_36130;
state_36130 = G__36294;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16291__auto__ = function(state_36130){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16291__auto____1.call(this,state_36130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16291__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16291__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_36226 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_36226[(6)] = c__16328__auto__);

return statearr_36226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__36296 = arguments.length;
switch (G__36296) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_36376){
var state_val_36377 = (state_36376[(1)]);
if((state_val_36377 === (7))){
var inst_36371 = (state_36376[(2)]);
var _ = (function (){var statearr_36378 = state_36376;
(statearr_36378[(4)] = cljs.core.rest((state_36376[(4)])));

return statearr_36378;
})();
var state_36376__$1 = state_36376;
var statearr_36379_36427 = state_36376__$1;
(statearr_36379_36427[(2)] = inst_36371);

(statearr_36379_36427[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (20))){
var inst_36336 = (state_36376[(7)]);
var inst_36348 = (state_36376[(2)]);
var inst_36318 = inst_36336;
var inst_36319 = inst_36348;
var state_36376__$1 = (function (){var statearr_36380 = state_36376;
(statearr_36380[(8)] = inst_36318);

(statearr_36380[(9)] = inst_36319);

return statearr_36380;
})();
var statearr_36381_36428 = state_36376__$1;
(statearr_36381_36428[(2)] = null);

(statearr_36381_36428[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (1))){
var state_36376__$1 = state_36376;
var statearr_36382_36429 = state_36376__$1;
(statearr_36382_36429[(2)] = null);

(statearr_36382_36429[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (24))){
var inst_36319 = (state_36376[(9)]);
var inst_36336 = (state_36376[(7)]);
var inst_36335 = (state_36376[(10)]);
var inst_36356 = fluree.db.query.analytical.inner_join(inst_36319,inst_36335);
var inst_36318 = inst_36336;
var inst_36319__$1 = inst_36356;
var state_36376__$1 = (function (){var statearr_36383 = state_36376;
(statearr_36383[(8)] = inst_36318);

(statearr_36383[(9)] = inst_36319__$1);

return statearr_36383;
})();
var statearr_36384_36430 = state_36376__$1;
(statearr_36384_36430[(2)] = null);

(statearr_36384_36430[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (4))){
var inst_36297 = (state_36376[(2)]);
var state_36376__$1 = state_36376;
var statearr_36386_36431 = state_36376__$1;
(statearr_36386_36431[(2)] = inst_36297);

(statearr_36386_36431[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (15))){
var inst_36335 = (state_36376[(10)]);
var state_36376__$1 = state_36376;
if(cljs.core.truth_(inst_36335)){
var statearr_36387_36432 = state_36376__$1;
(statearr_36387_36432[(1)] = (18));

} else {
var statearr_36388_36433 = state_36376__$1;
(statearr_36388_36433[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (21))){
var inst_36319 = (state_36376[(9)]);
var inst_36336 = (state_36376[(7)]);
var tmp36385 = inst_36319;
var inst_36318 = inst_36336;
var inst_36319__$1 = tmp36385;
var state_36376__$1 = (function (){var statearr_36389 = state_36376;
(statearr_36389[(8)] = inst_36318);

(statearr_36389[(9)] = inst_36319__$1);

return statearr_36389;
})();
var statearr_36390_36434 = state_36376__$1;
(statearr_36390_36434[(2)] = null);

(statearr_36390_36434[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (13))){
var inst_36319 = (state_36376[(9)]);
var inst_36342 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_36319,cljs.core.cst$kw$vars);
var inst_36343 = cljs.core.empty_QMARK_(inst_36342);
var state_36376__$1 = state_36376;
if(inst_36343){
var statearr_36391_36435 = state_36376__$1;
(statearr_36391_36435[(1)] = (15));

} else {
var statearr_36392_36436 = state_36376__$1;
(statearr_36392_36436[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (22))){
var state_36376__$1 = state_36376;
var statearr_36393_36437 = state_36376__$1;
(statearr_36393_36437[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (6))){
var inst_36325 = (state_36376[(11)]);
var inst_36318 = (state_36376[(8)]);
var inst_36324 = cljs.core.seq(inst_36318);
var inst_36325__$1 = cljs.core.first(inst_36324);
var inst_36326 = cljs.core.next(inst_36324);
var state_36376__$1 = (function (){var statearr_36395 = state_36376;
(statearr_36395[(11)] = inst_36325__$1);

(statearr_36395[(12)] = inst_36326);

return statearr_36395;
})();
if(cljs.core.truth_(inst_36325__$1)){
var statearr_36396_36438 = state_36376__$1;
(statearr_36396_36438[(1)] = (8));

} else {
var statearr_36397_36439 = state_36376__$1;
(statearr_36397_36439[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (25))){
var state_36376__$1 = state_36376;
var statearr_36398_36440 = state_36376__$1;
(statearr_36398_36440[(2)] = null);

(statearr_36398_36440[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (17))){
var inst_36364 = (state_36376[(2)]);
var state_36376__$1 = state_36376;
var statearr_36399_36441 = state_36376__$1;
(statearr_36399_36441[(2)] = inst_36364);

(statearr_36399_36441[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (3))){
var inst_36374 = (state_36376[(2)]);
var state_36376__$1 = state_36376;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36376__$1,inst_36374);
} else {
if((state_val_36377 === (12))){
var inst_36336 = (state_36376[(7)]);
var inst_36335 = (state_36376[(10)]);
var inst_36318 = inst_36336;
var inst_36319 = inst_36335;
var state_36376__$1 = (function (){var statearr_36400 = state_36376;
(statearr_36400[(8)] = inst_36318);

(statearr_36400[(9)] = inst_36319);

return statearr_36400;
})();
var statearr_36401_36442 = state_36376__$1;
(statearr_36401_36442[(2)] = null);

(statearr_36401_36442[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (2))){
var _ = (function (){var statearr_36402 = state_36376;
(statearr_36402[(4)] = cljs.core.cons((5),(state_36376[(4)])));

return statearr_36402;
})();
var inst_36310 = where;
var inst_36311 = cljs.core.seq(inst_36310);
var inst_36312 = cljs.core.first(inst_36311);
var inst_36313 = cljs.core.next(inst_36311);
var inst_36314 = [cljs.core.cst$kw$vars];
var inst_36315 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_36316 = [inst_36315];
var inst_36317 = cljs.core.PersistentHashMap.fromArrays(inst_36314,inst_36316);
var inst_36318 = inst_36310;
var inst_36319 = inst_36317;
var state_36376__$1 = (function (){var statearr_36403 = state_36376;
(statearr_36403[(8)] = inst_36318);

(statearr_36403[(13)] = inst_36312);

(statearr_36403[(9)] = inst_36319);

(statearr_36403[(14)] = inst_36313);

return statearr_36403;
})();
var statearr_36404_36443 = state_36376__$1;
(statearr_36404_36443[(2)] = null);

(statearr_36404_36443[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (23))){
var inst_36362 = (state_36376[(2)]);
var state_36376__$1 = state_36376;
var statearr_36405_36444 = state_36376__$1;
(statearr_36405_36444[(2)] = inst_36362);

(statearr_36405_36444[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (19))){
var inst_36319 = (state_36376[(9)]);
var state_36376__$1 = state_36376;
var statearr_36406_36445 = state_36376__$1;
(statearr_36406_36445[(2)] = inst_36319);

(statearr_36406_36445[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (11))){
var inst_36325 = (state_36376[(11)]);
var inst_36333 = (state_36376[(2)]);
var inst_36334 = fluree.db.util.async.throw_err(inst_36333);
var inst_36335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36334,(0),null);
var inst_36336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36334,(1),null);
var inst_36337 = cljs.core.count(inst_36325);
var inst_36338 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_36337);
var state_36376__$1 = (function (){var statearr_36408 = state_36376;
(statearr_36408[(7)] = inst_36336);

(statearr_36408[(10)] = inst_36335);

return statearr_36408;
})();
if(inst_36338){
var statearr_36409_36446 = state_36376__$1;
(statearr_36409_36446[(1)] = (12));

} else {
var statearr_36410_36447 = state_36376__$1;
(statearr_36410_36447[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (9))){
var inst_36319 = (state_36376[(9)]);
var state_36376__$1 = state_36376;
var statearr_36411_36448 = state_36376__$1;
(statearr_36411_36448[(2)] = inst_36319);

(statearr_36411_36448[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (5))){
var _ = (function (){var statearr_36412 = state_36376;
(statearr_36412[(4)] = cljs.core.rest((state_36376[(4)])));

return statearr_36412;
})();
var state_36376__$1 = state_36376;
var ex36407 = (state_36376__$1[(2)]);
var statearr_36413_36449 = state_36376__$1;
(statearr_36413_36449[(5)] = ex36407);


if((ex36407 instanceof Error)){
var statearr_36414_36450 = state_36376__$1;
(statearr_36414_36450[(1)] = (4));

(statearr_36414_36450[(5)] = null);

} else {
throw ex36407;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (14))){
var inst_36366 = (state_36376[(2)]);
var state_36376__$1 = state_36376;
var statearr_36415_36451 = state_36376__$1;
(statearr_36415_36451[(2)] = inst_36366);

(statearr_36415_36451[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (26))){
var inst_36360 = (state_36376[(2)]);
var state_36376__$1 = state_36376;
var statearr_36416_36452 = state_36376__$1;
(statearr_36416_36452[(2)] = inst_36360);

(statearr_36416_36452[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (16))){
var inst_36335 = (state_36376[(10)]);
var inst_36351 = (inst_36335 == null);
var state_36376__$1 = state_36376;
if(cljs.core.truth_(inst_36351)){
var statearr_36417_36453 = state_36376__$1;
(statearr_36417_36453[(1)] = (21));

} else {
var statearr_36418_36454 = state_36376__$1;
(statearr_36418_36454[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (10))){
var inst_36369 = (state_36376[(2)]);
var state_36376__$1 = state_36376;
var statearr_36419_36455 = state_36376__$1;
(statearr_36419_36455[(2)] = inst_36369);

(statearr_36419_36455[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (18))){
var inst_36335 = (state_36376[(10)]);
var state_36376__$1 = state_36376;
var statearr_36420_36456 = state_36376__$1;
(statearr_36420_36456[(2)] = inst_36335);

(statearr_36420_36456[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (8))){
var inst_36325 = (state_36376[(11)]);
var inst_36319 = (state_36376[(9)]);
var inst_36326 = (state_36376[(12)]);
var inst_36331 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_36319,inst_36325,inst_36326,false,fuel,max_fuel,opts);
var state_36376__$1 = state_36376;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36376__$1,(11),inst_36331);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16291__auto__ = null;
var fluree$db$query$analytical$state_machine__16291__auto____0 = (function (){
var statearr_36421 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36421[(0)] = fluree$db$query$analytical$state_machine__16291__auto__);

(statearr_36421[(1)] = (1));

return statearr_36421;
});
var fluree$db$query$analytical$state_machine__16291__auto____1 = (function (state_36376){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_36376);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e36422){var ex__16294__auto__ = e36422;
var statearr_36423_36457 = state_36376;
(statearr_36423_36457[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_36376[(4)]))){
var statearr_36424_36458 = state_36376;
(statearr_36424_36458[(1)] = cljs.core.first((state_36376[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__36459 = state_36376;
state_36376 = G__36459;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16291__auto__ = function(state_36376){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16291__auto____1.call(this,state_36376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16291__auto____0;
fluree$db$query$analytical$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16291__auto____1;
return fluree$db$query$analytical$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_36425 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_36425[(6)] = c__16328__auto__);

return statearr_36425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_36514){
var state_val_36515 = (state_36514[(1)]);
if((state_val_36515 === (7))){
var state_36514__$1 = state_36514;
var statearr_36516_36554 = state_36514__$1;
(statearr_36516_36554[(2)] = false);

(statearr_36516_36554[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (20))){
var inst_36492 = (state_36514[(7)]);
var inst_36504 = (state_36514[(8)]);
var inst_36506 = fluree.db.query.analytical.tuples__GT_filtered(inst_36504,inst_36492,null);
var state_36514__$1 = state_36514;
var statearr_36517_36555 = state_36514__$1;
(statearr_36517_36555[(2)] = inst_36506);

(statearr_36517_36555[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (1))){
var state_36514__$1 = state_36514;
var statearr_36518_36556 = state_36514__$1;
(statearr_36518_36556[(2)] = null);

(statearr_36518_36556[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (4))){
var inst_36460 = (state_36514[(2)]);
var state_36514__$1 = state_36514;
var statearr_36519_36557 = state_36514__$1;
(statearr_36519_36557[(2)] = inst_36460);

(statearr_36519_36557[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (15))){
var inst_36491 = (state_36514[(9)]);
var inst_36495 = (state_36514[(2)]);
var inst_36496 = fluree.db.util.async.throw_err(inst_36495);
var state_36514__$1 = (function (){var statearr_36520 = state_36514;
(statearr_36520[(10)] = inst_36496);

return statearr_36520;
})();
if(cljs.core.truth_(inst_36491)){
var statearr_36521_36558 = state_36514__$1;
(statearr_36521_36558[(1)] = (16));

} else {
var statearr_36522_36559 = state_36514__$1;
(statearr_36522_36559[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (21))){
var inst_36504 = (state_36514[(8)]);
var state_36514__$1 = state_36514;
var statearr_36523_36560 = state_36514__$1;
(statearr_36523_36560[(2)] = inst_36504);

(statearr_36523_36560[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (13))){
var inst_36467 = (state_36514[(11)]);
var state_36514__$1 = state_36514;
var statearr_36524_36561 = state_36514__$1;
(statearr_36524_36561[(2)] = inst_36467);

(statearr_36524_36561[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (22))){
var inst_36509 = (state_36514[(2)]);
var _ = (function (){var statearr_36525 = state_36514;
(statearr_36525[(4)] = cljs.core.rest((state_36514[(4)])));

return statearr_36525;
})();
var state_36514__$1 = state_36514;
var statearr_36526_36562 = state_36514__$1;
(statearr_36526_36562[(2)] = inst_36509);

(statearr_36526_36562[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (6))){
var inst_36467 = (state_36514[(11)]);
var inst_36472 = inst_36467.cljs$lang$protocol_mask$partition0$;
var inst_36473 = (inst_36472 & (64));
var inst_36474 = inst_36467.cljs$core$ISeq$;
var inst_36475 = (cljs.core.PROTOCOL_SENTINEL === inst_36474);
var inst_36476 = ((inst_36473) || (inst_36475));
var state_36514__$1 = state_36514;
if(cljs.core.truth_(inst_36476)){
var statearr_36527_36563 = state_36514__$1;
(statearr_36527_36563[(1)] = (9));

} else {
var statearr_36528_36564 = state_36514__$1;
(statearr_36528_36564[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (17))){
var inst_36496 = (state_36514[(10)]);
var state_36514__$1 = state_36514;
var statearr_36529_36565 = state_36514__$1;
(statearr_36529_36565[(2)] = inst_36496);

(statearr_36529_36565[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (3))){
var inst_36512 = (state_36514[(2)]);
var state_36514__$1 = state_36514;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36514__$1,inst_36512);
} else {
if((state_val_36515 === (12))){
var inst_36467 = (state_36514[(11)]);
var inst_36485 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_36467);
var state_36514__$1 = state_36514;
var statearr_36530_36566 = state_36514__$1;
(statearr_36530_36566[(2)] = inst_36485);

(statearr_36530_36566[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (2))){
var inst_36467 = (state_36514[(11)]);
var _ = (function (){var statearr_36531 = state_36514;
(statearr_36531[(4)] = cljs.core.cons((5),(state_36514[(4)])));

return statearr_36531;
})();
var inst_36467__$1 = q_map;
var inst_36469 = (inst_36467__$1 == null);
var inst_36470 = cljs.core.not(inst_36469);
var state_36514__$1 = (function (){var statearr_36532 = state_36514;
(statearr_36532[(11)] = inst_36467__$1);

return statearr_36532;
})();
if(inst_36470){
var statearr_36533_36567 = state_36514__$1;
(statearr_36533_36567[(1)] = (6));

} else {
var statearr_36534_36568 = state_36514__$1;
(statearr_36534_36568[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (19))){
var inst_36500 = (state_36514[(2)]);
var inst_36501 = fluree.db.util.async.throw_err(inst_36500);
var state_36514__$1 = state_36514;
var statearr_36535_36569 = state_36514__$1;
(statearr_36535_36569[(2)] = inst_36501);

(statearr_36535_36569[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (11))){
var inst_36480 = (state_36514[(2)]);
var state_36514__$1 = state_36514;
var statearr_36537_36570 = state_36514__$1;
(statearr_36537_36570[(2)] = inst_36480);

(statearr_36537_36570[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (9))){
var state_36514__$1 = state_36514;
var statearr_36538_36571 = state_36514__$1;
(statearr_36538_36571[(2)] = true);

(statearr_36538_36571[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (5))){
var _ = (function (){var statearr_36539 = state_36514;
(statearr_36539[(4)] = cljs.core.rest((state_36514[(4)])));

return statearr_36539;
})();
var state_36514__$1 = state_36514;
var ex36536 = (state_36514__$1[(2)]);
var statearr_36540_36572 = state_36514__$1;
(statearr_36540_36572[(5)] = ex36536);


if((ex36536 instanceof Error)){
var statearr_36541_36573 = state_36514__$1;
(statearr_36541_36573[(1)] = (4));

(statearr_36541_36573[(5)] = null);

} else {
throw ex36536;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (14))){
var inst_36488 = (state_36514[(2)]);
var inst_36489 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36488,cljs.core.cst$kw$vars);
var inst_36490 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36488,cljs.core.cst$kw$where);
var inst_36491 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36488,cljs.core.cst$kw$optional);
var inst_36492 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36488,cljs.core.cst$kw$filter);
var inst_36493 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_36490,q_map,inst_36489,fuel,max_fuel,opts);
var state_36514__$1 = (function (){var statearr_36542 = state_36514;
(statearr_36542[(7)] = inst_36492);

(statearr_36542[(9)] = inst_36491);

return statearr_36542;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36514__$1,(15),inst_36493);
} else {
if((state_val_36515 === (16))){
var inst_36491 = (state_36514[(9)]);
var inst_36496 = (state_36514[(10)]);
var inst_36498 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_36491,inst_36496,fuel,max_fuel,opts);
var state_36514__$1 = state_36514;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36514__$1,(19),inst_36498);
} else {
if((state_val_36515 === (10))){
var state_36514__$1 = state_36514;
var statearr_36543_36574 = state_36514__$1;
(statearr_36543_36574[(2)] = false);

(statearr_36543_36574[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (18))){
var inst_36492 = (state_36514[(7)]);
var inst_36504 = (state_36514[(2)]);
var state_36514__$1 = (function (){var statearr_36544 = state_36514;
(statearr_36544[(8)] = inst_36504);

return statearr_36544;
})();
if(cljs.core.truth_(inst_36492)){
var statearr_36545_36575 = state_36514__$1;
(statearr_36545_36575[(1)] = (20));

} else {
var statearr_36546_36576 = state_36514__$1;
(statearr_36546_36576[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36515 === (8))){
var inst_36483 = (state_36514[(2)]);
var state_36514__$1 = state_36514;
if(cljs.core.truth_(inst_36483)){
var statearr_36547_36577 = state_36514__$1;
(statearr_36547_36577[(1)] = (12));

} else {
var statearr_36548_36578 = state_36514__$1;
(statearr_36548_36578[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__16291__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__16291__auto____0 = (function (){
var statearr_36549 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36549[(0)] = fluree$db$query$analytical$q_$_state_machine__16291__auto__);

(statearr_36549[(1)] = (1));

return statearr_36549;
});
var fluree$db$query$analytical$q_$_state_machine__16291__auto____1 = (function (state_36514){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_36514);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e36550){var ex__16294__auto__ = e36550;
var statearr_36551_36579 = state_36514;
(statearr_36551_36579[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_36514[(4)]))){
var statearr_36552_36580 = state_36514;
(statearr_36552_36580[(1)] = cljs.core.first((state_36514[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__36581 = state_36514;
state_36514 = G__36581;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__16291__auto__ = function(state_36514){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__16291__auto____1.call(this,state_36514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__16291__auto____0;
fluree$db$query$analytical$q_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__16291__auto____1;
return fluree$db$query$analytical$q_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_36553 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_36553[(6)] = c__16328__auto__);

return statearr_36553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
