// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k34443,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__34447 = k34443;
var G__34447__$1 = (((G__34447 instanceof cljs.core.Keyword))?G__34447.fqn:null);
switch (G__34447__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k34443,else__4383__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__34448){
var vec__34449 = p__34448;
var k__4403__auto__ = cljs.core.nth.call(null,vec__34449,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__34449,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-type","index-type",500383962),self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparator","comparator",2144896662),self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34442){
var self__ = this;
var G__34442__$1 = this;
return (new cljs.core.RecordIter((0),G__34442__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34444,other34445){
var self__ = this;
var this34444__$1 = this;
return (((!((other34445 == null)))) && ((this34444__$1.constructor === other34445.constructor)) && (cljs.core._EQ_.call(null,this34444__$1.index_type,other34445.index_type)) && (cljs.core._EQ_.call(null,this34444__$1.comparator,other34445.comparator)) && (cljs.core._EQ_.call(null,this34444__$1.historyComparator,other34445.historyComparator)) && (cljs.core._EQ_.call(null,this34444__$1.__extmap,other34445.__extmap)));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),null,new cljs.core.Keyword(null,"comparator","comparator",2144896662),null,new cljs.core.Keyword(null,"index-type","index-type",500383962),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__34442){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__34452 = cljs.core.keyword_identical_QMARK_;
var expr__34453 = k__4388__auto__;
if(cljs.core.truth_(pred__34452.call(null,new cljs.core.Keyword(null,"index-type","index-type",500383962),expr__34453))){
return (new fluree.db.index.IndexConfig(G__34442,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__34452.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662),expr__34453))){
return (new fluree.db.index.IndexConfig(self__.index_type,G__34442,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__34452.call(null,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),expr__34453))){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__34442,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__34442),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-type","index-type",500383962),self__.index_type,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparator","comparator",2144896662),self__.comparator,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__34442){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__34442,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-type","index-type",2140915489,null),new cljs.core.Symbol(null,"comparator","comparator",-509539107,null),new cljs.core.Symbol(null,"historyComparator","historyComparator",236913869,null)], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__34446){
var extmap__4419__auto__ = (function (){var G__34455 = cljs.core.dissoc.call(null,G__34446,new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658));
if(cljs.core.record_QMARK_.call(null,G__34446)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__34455);
} else {
return G__34455;
}
})();
return (new fluree.db.index.IndexConfig(new cljs.core.Keyword(null,"index-type","index-type",500383962).cljs$core$IFn$_invoke$arity$1(G__34446),new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(G__34446),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(G__34446),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k34458,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__34462 = k34458;
var G__34462__$1 = (((G__34462 instanceof cljs.core.Keyword))?G__34462.fqn:null);
switch (G__34462__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k34458,else__4383__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__34463){
var vec__34464 = p__34463;
var k__4403__auto__ = cljs.core.nth.call(null,vec__34464,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__34464,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"children","children",-940561982),self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34457){
var self__ = this;
var G__34457__$1 = this;
return (new cljs.core.RecordIter((0),G__34457__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34468){
var state_val_34469 = (state_34468[(1)]);
if((state_val_34469 === (1))){
var state_34468__$1 = state_34468;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34468__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__11469__auto__ = null;
var fluree$db$index$state_machine__11469__auto____0 = (function (){
var statearr_34470 = [null,null,null,null,null,null,null];
(statearr_34470[(0)] = fluree$db$index$state_machine__11469__auto__);

(statearr_34470[(1)] = (1));

return statearr_34470;
});
var fluree$db$index$state_machine__11469__auto____1 = (function (state_34468){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34468);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34471){var ex__11472__auto__ = e34471;
var statearr_34472_34570 = state_34468;
(statearr_34472_34570[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34468[(4)]))){
var statearr_34473_34571 = state_34468;
(statearr_34473_34571[(1)] = cljs.core.first.call(null,(state_34468[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34572 = state_34468;
state_34468 = G__34572;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$index$state_machine__11469__auto__ = function(state_34468){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__11469__auto____1.call(this,state_34468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__11469__auto____0;
fluree$db$index$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__11469__auto____1;
return fluree$db$index$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34474 = f__11543__auto__.call(null);
(statearr_34474[(6)] = c__11542__auto__);

return statearr_34474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key.call(null,cljs.core.first.call(null,self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (6 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val.call(null,(function (){var or__4126__auto__ = clojure.data.avl.nearest.call(null,self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.first.call(null,self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val.call(null,(function (){var or__4126__auto__ = clojure.data.avl.nearest.call(null,self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.last.call(null,self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34499){
var state_val_34500 = (state_34499[(1)]);
if((state_val_34500 === (7))){
var inst_34481 = (state_34499[(7)]);
var inst_34485 = fluree.db.dbproto._resolve.call(null,inst_34481);
var state_34499__$1 = state_34499;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34499__$1,(10),inst_34485);
} else {
if((state_val_34500 === (1))){
var state_34499__$1 = state_34499;
var statearr_34501_34573 = state_34499__$1;
(statearr_34501_34573[(2)] = null);

(statearr_34501_34573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34500 === (4))){
var inst_34475 = (state_34499[(2)]);
var state_34499__$1 = state_34499;
var statearr_34502_34574 = state_34499__$1;
(statearr_34502_34574[(2)] = inst_34475);

(statearr_34502_34574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34500 === (6))){
var inst_34481 = (state_34499[(7)]);
var state_34499__$1 = state_34499;
var statearr_34503_34575 = state_34499__$1;
(statearr_34503_34575[(2)] = inst_34481);

(statearr_34503_34575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34500 === (3))){
var inst_34497 = (state_34499[(2)]);
var state_34499__$1 = state_34499;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34499__$1,inst_34497);
} else {
if((state_val_34500 === (2))){
var inst_34481 = (state_34499[(7)]);
var _ = (function (){var statearr_34505 = state_34499;
(statearr_34505[(4)] = cljs.core.cons.call(null,(5),(state_34499[(4)])));

return statearr_34505;
})();
var inst_34481__$1 = fluree.db.dbproto._lookup.call(null,this$__$1,flake);
var inst_34482 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(inst_34481__$1);
var state_34499__$1 = (function (){var statearr_34506 = state_34499;
(statearr_34506[(7)] = inst_34481__$1);

return statearr_34506;
})();
if(cljs.core.truth_(inst_34482)){
var statearr_34507_34576 = state_34499__$1;
(statearr_34507_34576[(1)] = (6));

} else {
var statearr_34508_34577 = state_34499__$1;
(statearr_34508_34577[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34500 === (9))){
var inst_34491 = (state_34499[(2)]);
var inst_34492 = fluree.db.util.async.throw_err.call(null,inst_34491);
var state_34499__$1 = state_34499;
var statearr_34509_34578 = state_34499__$1;
(statearr_34509_34578[(2)] = inst_34492);

(statearr_34509_34578[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34500 === (5))){
var _ = (function (){var statearr_34510 = state_34499;
(statearr_34510[(4)] = cljs.core.rest.call(null,(state_34499[(4)])));

return statearr_34510;
})();
var state_34499__$1 = state_34499;
var ex34504 = (state_34499__$1[(2)]);
var statearr_34511_34579 = state_34499__$1;
(statearr_34511_34579[(5)] = ex34504);


if((ex34504 instanceof Error)){
var statearr_34512_34580 = state_34499__$1;
(statearr_34512_34580[(1)] = (4));

(statearr_34512_34580[(5)] = null);

} else {
throw ex34504;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34500 === (10))){
var inst_34487 = (state_34499[(2)]);
var inst_34488 = fluree.db.util.async.throw_err.call(null,inst_34487);
var inst_34489 = fluree.db.dbproto._lookup_leaf.call(null,inst_34488,flake);
var state_34499__$1 = state_34499;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34499__$1,(9),inst_34489);
} else {
if((state_val_34500 === (8))){
var inst_34494 = (state_34499[(2)]);
var _ = (function (){var statearr_34513 = state_34499;
(statearr_34513[(4)] = cljs.core.rest.call(null,(state_34499[(4)])));

return statearr_34513;
})();
var state_34499__$1 = state_34499;
var statearr_34514_34581 = state_34499__$1;
(statearr_34514_34581[(2)] = inst_34494);

(statearr_34514_34581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__11469__auto__ = null;
var fluree$db$index$state_machine__11469__auto____0 = (function (){
var statearr_34515 = [null,null,null,null,null,null,null,null];
(statearr_34515[(0)] = fluree$db$index$state_machine__11469__auto__);

(statearr_34515[(1)] = (1));

return statearr_34515;
});
var fluree$db$index$state_machine__11469__auto____1 = (function (state_34499){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34499);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34516){var ex__11472__auto__ = e34516;
var statearr_34517_34582 = state_34499;
(statearr_34517_34582[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34499[(4)]))){
var statearr_34518_34583 = state_34499;
(statearr_34518_34583[(1)] = cljs.core.first.call(null,(state_34499[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34584 = state_34499;
state_34499 = G__34584;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$index$state_machine__11469__auto__ = function(state_34499){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__11469__auto____1.call(this,state_34499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__11469__auto____0;
fluree$db$index$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__11469__auto____1;
return fluree$db$index$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34519 = f__11543__auto__.call(null);
(statearr_34519[(6)] = c__11542__auto__);

return statearr_34519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34544){
var state_val_34545 = (state_34544[(1)]);
if((state_val_34545 === (7))){
var inst_34526 = (state_34544[(7)]);
var inst_34530 = fluree.db.dbproto._resolve.call(null,inst_34526);
var state_34544__$1 = state_34544;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34544__$1,(10),inst_34530);
} else {
if((state_val_34545 === (1))){
var state_34544__$1 = state_34544;
var statearr_34546_34585 = state_34544__$1;
(statearr_34546_34585[(2)] = null);

(statearr_34546_34585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34545 === (4))){
var inst_34520 = (state_34544[(2)]);
var state_34544__$1 = state_34544;
var statearr_34547_34586 = state_34544__$1;
(statearr_34547_34586[(2)] = inst_34520);

(statearr_34547_34586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34545 === (6))){
var inst_34526 = (state_34544[(7)]);
var state_34544__$1 = state_34544;
var statearr_34548_34587 = state_34544__$1;
(statearr_34548_34587[(2)] = inst_34526);

(statearr_34548_34587[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34545 === (3))){
var inst_34542 = (state_34544[(2)]);
var state_34544__$1 = state_34544;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34544__$1,inst_34542);
} else {
if((state_val_34545 === (2))){
var inst_34526 = (state_34544[(7)]);
var _ = (function (){var statearr_34550 = state_34544;
(statearr_34550[(4)] = cljs.core.cons.call(null,(5),(state_34544[(4)])));

return statearr_34550;
})();
var inst_34526__$1 = fluree.db.dbproto._lookup_after.call(null,this$__$1,flake);
var inst_34527 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(inst_34526__$1);
var state_34544__$1 = (function (){var statearr_34551 = state_34544;
(statearr_34551[(7)] = inst_34526__$1);

return statearr_34551;
})();
if(cljs.core.truth_(inst_34527)){
var statearr_34552_34588 = state_34544__$1;
(statearr_34552_34588[(1)] = (6));

} else {
var statearr_34553_34589 = state_34544__$1;
(statearr_34553_34589[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34545 === (9))){
var inst_34536 = (state_34544[(2)]);
var inst_34537 = fluree.db.util.async.throw_err.call(null,inst_34536);
var state_34544__$1 = state_34544;
var statearr_34554_34590 = state_34544__$1;
(statearr_34554_34590[(2)] = inst_34537);

(statearr_34554_34590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34545 === (5))){
var _ = (function (){var statearr_34555 = state_34544;
(statearr_34555[(4)] = cljs.core.rest.call(null,(state_34544[(4)])));

return statearr_34555;
})();
var state_34544__$1 = state_34544;
var ex34549 = (state_34544__$1[(2)]);
var statearr_34556_34591 = state_34544__$1;
(statearr_34556_34591[(5)] = ex34549);


if((ex34549 instanceof Error)){
var statearr_34557_34592 = state_34544__$1;
(statearr_34557_34592[(1)] = (4));

(statearr_34557_34592[(5)] = null);

} else {
throw ex34549;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34545 === (10))){
var inst_34532 = (state_34544[(2)]);
var inst_34533 = fluree.db.util.async.throw_err.call(null,inst_34532);
var inst_34534 = fluree.db.dbproto._lookup_leaf_after.call(null,inst_34533,flake);
var state_34544__$1 = state_34544;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34544__$1,(9),inst_34534);
} else {
if((state_val_34545 === (8))){
var inst_34539 = (state_34544[(2)]);
var _ = (function (){var statearr_34558 = state_34544;
(statearr_34558[(4)] = cljs.core.rest.call(null,(state_34544[(4)])));

return statearr_34558;
})();
var state_34544__$1 = state_34544;
var statearr_34559_34593 = state_34544__$1;
(statearr_34559_34593[(2)] = inst_34539);

(statearr_34559_34593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__11469__auto__ = null;
var fluree$db$index$state_machine__11469__auto____0 = (function (){
var statearr_34560 = [null,null,null,null,null,null,null,null];
(statearr_34560[(0)] = fluree$db$index$state_machine__11469__auto__);

(statearr_34560[(1)] = (1));

return statearr_34560;
});
var fluree$db$index$state_machine__11469__auto____1 = (function (state_34544){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34544);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34561){var ex__11472__auto__ = e34561;
var statearr_34562_34594 = state_34544;
(statearr_34562_34594[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34544[(4)]))){
var statearr_34563_34595 = state_34544;
(statearr_34563_34595[(1)] = cljs.core.first.call(null,(state_34544[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34596 = state_34544;
state_34544 = G__34596;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$index$state_machine__11469__auto__ = function(state_34544){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__11469__auto____1.call(this,state_34544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__11469__auto____0;
fluree$db$index$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__11469__auto____1;
return fluree$db$index$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34564 = f__11543__auto__.call(null);
(statearr_34564[(6)] = c__11542__auto__);

return statearr_34564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34459,other34460){
var self__ = this;
var this34459__$1 = this;
return (((!((other34460 == null)))) && ((this34459__$1.constructor === other34460.constructor)) && (cljs.core._EQ_.call(null,this34459__$1.block,other34460.block)) && (cljs.core._EQ_.call(null,this34459__$1.t,other34460.t)) && (cljs.core._EQ_.call(null,this34459__$1.rhs,other34460.rhs)) && (cljs.core._EQ_.call(null,this34459__$1.children,other34460.children)) && (cljs.core._EQ_.call(null,this34459__$1.config,other34460.config)) && (cljs.core._EQ_.call(null,this34459__$1.leftmost_QMARK_,other34460.leftmost_QMARK_)) && (cljs.core._EQ_.call(null,this34459__$1.__extmap,other34460.__extmap)));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__34457){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__34565 = cljs.core.keyword_identical_QMARK_;
var expr__34566 = k__4388__auto__;
if(cljs.core.truth_(pred__34565.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__34566))){
return (new fluree.db.index.IndexNode(G__34457,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__34565.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__34566))){
return (new fluree.db.index.IndexNode(self__.block,G__34457,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__34565.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__34566))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__34457,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__34565.call(null,new cljs.core.Keyword(null,"children","children",-940561982),expr__34566))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__34457,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__34565.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__34566))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__34457,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__34565.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__34566))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__34457,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__34457),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"children","children",-940561982),self__.children,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__34457){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__34457,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"children","children",699969545,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null)], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__34461){
var extmap__4419__auto__ = (function (){var G__34568 = cljs.core.dissoc.call(null,G__34461,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
if(cljs.core.record_QMARK_.call(null,G__34461)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__34568);
} else {
return G__34568;
}
})();
return (new fluree.db.index.IndexNode(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__34461),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__34461),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__34461),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(G__34461),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__34461),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__34461),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k34598,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__34602 = k34598;
var G__34602__$1 = (((G__34602 instanceof cljs.core.Keyword))?G__34602.fqn:null);
switch (G__34602__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k34598,else__4383__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__34603){
var vec__34604 = p__34603;
var k__4403__auto__ = cljs.core.nth.call(null,vec__34604,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__34604,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"flakes","flakes",1977895739),self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34597){
var self__ = this;
var G__34597__$1 = this;
return (new cljs.core.RecordIter((0),G__34597__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"config","config",994861415)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34608){
var state_val_34609 = (state_34608[(1)]);
if((state_val_34609 === (1))){
var state_34608__$1 = state_34608;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34608__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__11469__auto__ = null;
var fluree$db$index$state_machine__11469__auto____0 = (function (){
var statearr_34610 = [null,null,null,null,null,null,null];
(statearr_34610[(0)] = fluree$db$index$state_machine__11469__auto__);

(statearr_34610[(1)] = (1));

return statearr_34610;
});
var fluree$db$index$state_machine__11469__auto____1 = (function (state_34608){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34611){var ex__11472__auto__ = e34611;
var statearr_34612_34632 = state_34608;
(statearr_34612_34632[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34608[(4)]))){
var statearr_34613_34633 = state_34608;
(statearr_34613_34633[(1)] = cljs.core.first.call(null,(state_34608[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34634 = state_34608;
state_34608 = G__34634;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$index$state_machine__11469__auto__ = function(state_34608){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__11469__auto____1.call(this,state_34608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__11469__auto____0;
fluree$db$index$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__11469__auto____1;
return fluree$db$index$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34614 = f__11543__auto__.call(null);
(statearr_34614[(6)] = c__11542__auto__);

return statearr_34614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.call(null,"-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first.call(null,self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.call(null,"-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.call(null,"-lookup-leaf was called on a data node, which shouldn't happen!");

var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34620){
var state_val_34621 = (state_34620[(1)]);
if((state_val_34621 === (1))){
var inst_34615 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_34616 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_34617 = cljs.core.PersistentHashMap.fromArrays(inst_34615,inst_34616);
var inst_34618 = cljs.core.ex_info.call(null,"-lookup-leaf was called on a data node, which shouldn't happen!",inst_34617);
var state_34620__$1 = state_34620;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34620__$1,inst_34618);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__11469__auto__ = null;
var fluree$db$index$state_machine__11469__auto____0 = (function (){
var statearr_34622 = [null,null,null,null,null,null,null];
(statearr_34622[(0)] = fluree$db$index$state_machine__11469__auto__);

(statearr_34622[(1)] = (1));

return statearr_34622;
});
var fluree$db$index$state_machine__11469__auto____1 = (function (state_34620){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34620);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34623){var ex__11472__auto__ = e34623;
var statearr_34624_34635 = state_34620;
(statearr_34624_34635[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34620[(4)]))){
var statearr_34625_34636 = state_34620;
(statearr_34625_34636[(1)] = cljs.core.first.call(null,(state_34620[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34637 = state_34620;
state_34620 = G__34637;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$index$state_machine__11469__auto__ = function(state_34620){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__11469__auto____1.call(this,state_34620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__11469__auto____0;
fluree$db$index$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__11469__auto____1;
return fluree$db$index$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34626 = f__11543__auto__.call(null);
(statearr_34626[(6)] = c__11542__auto__);

return statearr_34626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34599,other34600){
var self__ = this;
var this34599__$1 = this;
return (((!((other34600 == null)))) && ((this34599__$1.constructor === other34600.constructor)) && (cljs.core._EQ_.call(null,this34599__$1.block,other34600.block)) && (cljs.core._EQ_.call(null,this34599__$1.t,other34600.t)) && (cljs.core._EQ_.call(null,this34599__$1.flakes,other34600.flakes)) && (cljs.core._EQ_.call(null,this34599__$1.rhs,other34600.rhs)) && (cljs.core._EQ_.call(null,this34599__$1.config,other34600.config)) && (cljs.core._EQ_.call(null,this34599__$1.__extmap,other34600.__extmap)));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"flakes","flakes",1977895739),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__34597){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__34627 = cljs.core.keyword_identical_QMARK_;
var expr__34628 = k__4388__auto__;
if(cljs.core.truth_(pred__34627.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__34628))){
return (new fluree.db.index.DataNode(G__34597,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__34627.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__34628))){
return (new fluree.db.index.DataNode(self__.block,G__34597,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__34627.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739),expr__34628))){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__34597,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__34627.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__34628))){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__34597,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__34627.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__34628))){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__34597,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__34597),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"flakes","flakes",1977895739),self__.flakes,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__34597){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__34597,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"config","config",-1659574354,null)], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__34601){
var extmap__4419__auto__ = (function (){var G__34630 = cljs.core.dissoc.call(null,G__34601,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"config","config",994861415));
if(cljs.core.record_QMARK_.call(null,G__34601)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__34630);
} else {
return G__34630;
}
})();
return (new fluree.db.index.DataNode(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__34601),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__34601),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__34601),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__34601),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__34601),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode.call(null,block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
