// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e27254){var e = e27254;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__27255_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__27255_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__27255_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__27255_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (cljs.core.not.call(null,key_as_var)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__27256_SHARP_){
return cljs.core.conj.call(null,p1__27256_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__27257_SHARP_){
return cljs.core.conj.call(null,p1__27257_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__27262 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__27262,(0),null);
var _ = cljs.core.nth.call(null,vec__27262,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__27258_SHARP_){
return cljs.core.conj.call(null,p1__27258_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.call(null,idx,(1)))?cljs.core.re_find.call(null,/\+/,key):false))){
var vec__27265 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__27265,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__27265,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__27259_SHARP_){
return cljs.core.conj.call(null,p1__27259_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__27260_SHARP_){
return cljs.core.conj.call(null,p1__27260_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__27261_SHARP_){
return cljs.core.conj.call(null,p1__27261_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__27268_SHARP_){
return cljs.core.nth.call(null,array,p1__27268_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5733__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__27271,optional_QMARK_,fuel,max_fuel){
var map__27272 = p__27271;
var map__27272__$1 = (((((!((map__27272 == null))))?(((((map__27272.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27272.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27272):map__27272);
var res = map__27272__$1;
var vars = cljs.core.get.call(null,map__27272__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_27339){
var state_val_27340 = (state_27339[(1)]);
if((state_val_27340 === (7))){
var inst_27328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27329 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_27330 = cljs.core.conj.call(null,inst_27329,clause);
var inst_27331 = [null,inst_27330];
var inst_27332 = (new cljs.core.PersistentVector(null,2,(5),inst_27328,inst_27331,null));
var state_27339__$1 = state_27339;
var statearr_27341_27369 = state_27339__$1;
(statearr_27341_27369[(2)] = inst_27332);

(statearr_27341_27369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27340 === (1))){
var state_27339__$1 = state_27339;
var statearr_27342_27370 = state_27339__$1;
(statearr_27342_27370[(2)] = null);

(statearr_27342_27370[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27340 === (4))){
var inst_27274 = (state_27339[(2)]);
var state_27339__$1 = state_27339;
var statearr_27343_27371 = state_27339__$1;
(statearr_27343_27371[(2)] = inst_27274);

(statearr_27343_27371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27340 === (15))){
var inst_27317 = (state_27339[(2)]);
var inst_27318 = fluree.db.util.async.throw_err.call(null,inst_27317);
var inst_27319 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_27318);
var inst_27320 = cljs.core.count.call(null,inst_27319);
var inst_27321 = fluree.db.query.analytical.add_fuel.call(null,inst_27320,fuel,max_fuel);
var inst_27322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27323 = [inst_27318,r];
var inst_27324 = (new cljs.core.PersistentVector(null,2,(5),inst_27322,inst_27323,null));
var state_27339__$1 = (function (){var statearr_27344 = state_27339;
(statearr_27344[(7)] = inst_27321);

return statearr_27344;
})();
var statearr_27345_27372 = state_27339__$1;
(statearr_27345_27372[(2)] = inst_27324);

(statearr_27345_27372[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27340 === (13))){
var inst_27283 = (state_27339[(8)]);
var inst_27296 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_27297 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_27296);
var inst_27298 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_27283);
var inst_27299 = cljs.core.apply.call(null,cljs.core.concat,inst_27298);
var inst_27300 = cljs.core.set.call(null,inst_27299);
var inst_27301 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_27297);
var inst_27302 = cljs.core.apply.call(null,cljs.core.concat,inst_27301);
var inst_27303 = cljs.core.into.call(null,inst_27300,inst_27302);
var inst_27304 = (function (){var all_wd = inst_27283;
var optional = inst_27297;
var all_wd_vars = inst_27300;
var all_vars = inst_27303;
return (function (p1__27269_SHARP_){
return all_vars.call(null,p1__27269_SHARP_);
});
})();
var inst_27305 = cljs.core.keys.call(null,vars);
var inst_27306 = cljs.core.map.call(null,inst_27304,inst_27305);
var inst_27307 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_27306);
var inst_27308 = cljs.core.set.call(null,inst_27307);
var inst_27309 = (function (){var all_wd = inst_27283;
var optional = inst_27297;
var all_wd_vars = inst_27300;
var all_vars = inst_27303;
var intersecting_vars = inst_27308;
return (function (p1__27270_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__27270_SHARP_);
});
})();
var inst_27310 = cljs.core.map.call(null,inst_27309,inst_27283);
var inst_27311 = cljs.core.apply.call(null,cljs.core.concat,inst_27310);
var inst_27312 = fluree.db.query.analytical.select_from_tuples.call(null,inst_27311,res);
var inst_27313 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_27283,inst_27308,vars);
var inst_27314 = cljs.core.remove.call(null,inst_27308,inst_27303);
var inst_27315 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_27313,inst_27311,inst_27312,inst_27314,inst_27297);
var state_27339__$1 = state_27339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27339__$1,(15),inst_27315);
} else {
if((state_val_27340 === (6))){
var inst_27284 = (state_27339[(9)]);
var inst_27282 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_27283 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_27282);
var inst_27284__$1 = optional_QMARK_;
var state_27339__$1 = (function (){var statearr_27346 = state_27339;
(statearr_27346[(8)] = inst_27283);

(statearr_27346[(9)] = inst_27284__$1);

return statearr_27346;
})();
if(cljs.core.truth_(inst_27284__$1)){
var statearr_27347_27373 = state_27339__$1;
(statearr_27347_27373[(1)] = (9));

} else {
var statearr_27348_27374 = state_27339__$1;
(statearr_27348_27374[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27340 === (3))){
var inst_27337 = (state_27339[(2)]);
var state_27339__$1 = state_27339;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27339__$1,inst_27337);
} else {
if((state_val_27340 === (12))){
var inst_27292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27293 = [null,r];
var inst_27294 = (new cljs.core.PersistentVector(null,2,(5),inst_27292,inst_27293,null));
var state_27339__$1 = state_27339;
var statearr_27349_27375 = state_27339__$1;
(statearr_27349_27375[(2)] = inst_27294);

(statearr_27349_27375[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27340 === (2))){
var _ = (function (){var statearr_27350 = state_27339;
(statearr_27350[(4)] = cljs.core.cons.call(null,(5),(state_27339[(4)])));

return statearr_27350;
})();
var inst_27280 = (r == null);
var state_27339__$1 = state_27339;
if(cljs.core.truth_(inst_27280)){
var statearr_27351_27376 = state_27339__$1;
(statearr_27351_27376[(1)] = (6));

} else {
var statearr_27352_27377 = state_27339__$1;
(statearr_27352_27377[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27340 === (11))){
var inst_27290 = (state_27339[(2)]);
var state_27339__$1 = state_27339;
if(cljs.core.truth_(inst_27290)){
var statearr_27354_27378 = state_27339__$1;
(statearr_27354_27378[(1)] = (12));

} else {
var statearr_27355_27379 = state_27339__$1;
(statearr_27355_27379[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27340 === (9))){
var inst_27283 = (state_27339[(8)]);
var inst_27286 = cljs.core.empty_QMARK_.call(null,inst_27283);
var inst_27287 = (!(inst_27286));
var state_27339__$1 = state_27339;
var statearr_27356_27380 = state_27339__$1;
(statearr_27356_27380[(2)] = inst_27287);

(statearr_27356_27380[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27340 === (5))){
var _ = (function (){var statearr_27357 = state_27339;
(statearr_27357[(4)] = cljs.core.rest.call(null,(state_27339[(4)])));

return statearr_27357;
})();
var state_27339__$1 = state_27339;
var ex27353 = (state_27339__$1[(2)]);
var statearr_27358_27381 = state_27339__$1;
(statearr_27358_27381[(5)] = ex27353);


if((ex27353 instanceof Error)){
var statearr_27359_27382 = state_27339__$1;
(statearr_27359_27382[(1)] = (4));

(statearr_27359_27382[(5)] = null);

} else {
throw ex27353;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27340 === (14))){
var inst_27326 = (state_27339[(2)]);
var state_27339__$1 = state_27339;
var statearr_27360_27383 = state_27339__$1;
(statearr_27360_27383[(2)] = inst_27326);

(statearr_27360_27383[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27340 === (10))){
var inst_27284 = (state_27339[(9)]);
var state_27339__$1 = state_27339;
var statearr_27361_27384 = state_27339__$1;
(statearr_27361_27384[(2)] = inst_27284);

(statearr_27361_27384[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27340 === (8))){
var inst_27334 = (state_27339[(2)]);
var _ = (function (){var statearr_27362 = state_27339;
(statearr_27362[(4)] = cljs.core.rest.call(null,(state_27339[(4)])));

return statearr_27362;
})();
var state_27339__$1 = state_27339;
var statearr_27363_27385 = state_27339__$1;
(statearr_27363_27385[(2)] = inst_27334);

(statearr_27363_27385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11469__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11469__auto____0 = (function (){
var statearr_27364 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27364[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11469__auto__);

(statearr_27364[(1)] = (1));

return statearr_27364;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11469__auto____1 = (function (state_27339){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_27339);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e27365){var ex__11472__auto__ = e27365;
var statearr_27366_27386 = state_27339;
(statearr_27366_27386[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_27339[(4)]))){
var statearr_27367_27387 = state_27339;
(statearr_27367_27387[(1)] = cljs.core.first.call(null,(state_27339[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27388 = state_27339;
state_27339 = G__27388;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11469__auto__ = function(state_27339){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11469__auto____1.call(this,state_27339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11469__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11469__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_27368 = f__11543__auto__.call(null);
(statearr_27368[(6)] = c__11542__auto__);

return statearr_27368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__27390 = arguments.length;
switch (G__27390) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_27484){
var state_val_27485 = (state_27484[(1)]);
if((state_val_27485 === (7))){
var inst_27397 = (state_27484[(7)]);
var inst_27407 = clojure.string.starts_with_QMARK_.call(null,inst_27397,"$fdb");
var state_27484__$1 = state_27484;
if(inst_27407){
var statearr_27486_27535 = state_27484__$1;
(statearr_27486_27535[(1)] = (9));

} else {
var statearr_27487_27536 = state_27484__$1;
(statearr_27487_27536[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (20))){
var state_27484__$1 = state_27484;
var statearr_27488_27537 = state_27484__$1;
(statearr_27488_27537[(2)] = null);

(statearr_27488_27537[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (27))){
var inst_27447 = (state_27484[(8)]);
var state_27484__$1 = state_27484;
var statearr_27489_27538 = state_27484__$1;
(statearr_27489_27538[(2)] = inst_27447);

(statearr_27489_27538[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (1))){
var state_27484__$1 = state_27484;
var statearr_27490_27539 = state_27484__$1;
(statearr_27490_27539[(2)] = null);

(statearr_27490_27539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (24))){
var inst_27470 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
var statearr_27491_27540 = state_27484__$1;
(statearr_27491_27540[(2)] = inst_27470);

(statearr_27491_27540[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (4))){
var inst_27391 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
var statearr_27492_27541 = state_27484__$1;
(statearr_27492_27541[(2)] = inst_27391);

(statearr_27492_27541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (15))){
var inst_27414 = (state_27484[(9)]);
var inst_27420 = (state_27484[(2)]);
var inst_27421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27422 = cljs.core.PersistentVector.EMPTY;
var inst_27423 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_27424 = cljs.core.into.call(null,inst_27422,inst_27423);
var inst_27425 = [inst_27414,inst_27424];
var inst_27426 = (new cljs.core.PersistentVector(null,2,(5),inst_27421,inst_27425,null));
var state_27484__$1 = (function (){var statearr_27493 = state_27484;
(statearr_27493[(10)] = inst_27420);

return statearr_27493;
})();
var statearr_27494_27542 = state_27484__$1;
(statearr_27494_27542[(2)] = inst_27426);

(statearr_27494_27542[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (21))){
var inst_27473 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
var statearr_27495_27543 = state_27484__$1;
(statearr_27495_27543[(2)] = inst_27473);

(statearr_27495_27543[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (13))){
var inst_27414 = (state_27484[(9)]);
var inst_27417 = (function(){throw inst_27414})();
var state_27484__$1 = state_27484;
var statearr_27496_27544 = state_27484__$1;
(statearr_27496_27544[(2)] = inst_27417);

(statearr_27496_27544[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (22))){
var inst_27436 = (state_27484[(11)]);
var inst_27438 = (state_27484[(12)]);
var inst_27440 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_27436);
var inst_27441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27442 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_27438];
var inst_27443 = (new cljs.core.PersistentVector(null,2,(5),inst_27441,inst_27442,null));
var inst_27444 = cljs.core.get_in.call(null,opts,inst_27443);
var state_27484__$1 = (function (){var statearr_27497 = state_27484;
(statearr_27497[(13)] = inst_27440);

return statearr_27497;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27484__$1,(25),inst_27444);
} else {
if((state_val_27485 === (29))){
var inst_27451 = (state_27484[(2)]);
var inst_27452 = fluree.db.util.async.throw_err.call(null,inst_27451);
var state_27484__$1 = state_27484;
var statearr_27498_27545 = state_27484__$1;
(statearr_27498_27545[(2)] = inst_27452);

(statearr_27498_27545[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (6))){
var inst_27400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27401 = cljs.core.PersistentVector.EMPTY;
var inst_27402 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_27403 = cljs.core.into.call(null,inst_27401,inst_27402);
var inst_27404 = [db,inst_27403];
var inst_27405 = (new cljs.core.PersistentVector(null,2,(5),inst_27400,inst_27404,null));
var state_27484__$1 = state_27484;
var statearr_27499_27546 = state_27484__$1;
(statearr_27499_27546[(2)] = inst_27405);

(statearr_27499_27546[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (28))){
var inst_27455 = (state_27484[(2)]);
var inst_27456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27457 = cljs.core.PersistentVector.EMPTY;
var inst_27458 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_27459 = cljs.core.into.call(null,inst_27457,inst_27458);
var inst_27460 = [inst_27455,inst_27459];
var inst_27461 = (new cljs.core.PersistentVector(null,2,(5),inst_27456,inst_27460,null));
var state_27484__$1 = state_27484;
var statearr_27500_27547 = state_27484__$1;
(statearr_27500_27547[(2)] = inst_27461);

(statearr_27500_27547[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (25))){
var inst_27440 = (state_27484[(13)]);
var inst_27446 = (state_27484[(2)]);
var inst_27447 = fluree.db.util.async.throw_err.call(null,inst_27446);
var state_27484__$1 = (function (){var statearr_27501 = state_27484;
(statearr_27501[(8)] = inst_27447);

return statearr_27501;
})();
if(cljs.core.truth_(inst_27440)){
var statearr_27502_27548 = state_27484__$1;
(statearr_27502_27548[(1)] = (26));

} else {
var statearr_27503_27549 = state_27484__$1;
(statearr_27503_27549[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (17))){
var state_27484__$1 = state_27484;
var statearr_27504_27550 = state_27484__$1;
(statearr_27504_27550[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (3))){
var inst_27482 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27484__$1,inst_27482);
} else {
if((state_val_27485 === (12))){
var inst_27414 = (state_27484[(9)]);
var inst_27413 = (state_27484[(2)]);
var inst_27414__$1 = fluree.db.util.async.throw_err.call(null,inst_27413);
var inst_27415 = fluree.db.util.core.exception_QMARK_.call(null,inst_27414__$1);
var state_27484__$1 = (function (){var statearr_27506 = state_27484;
(statearr_27506[(9)] = inst_27414__$1);

return statearr_27506;
})();
if(inst_27415){
var statearr_27507_27551 = state_27484__$1;
(statearr_27507_27551[(1)] = (13));

} else {
var statearr_27508_27552 = state_27484__$1;
(statearr_27508_27552[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (2))){
var inst_27397 = (state_27484[(7)]);
var _ = (function (){var statearr_27509 = state_27484;
(statearr_27509[(4)] = cljs.core.cons.call(null,(5),(state_27484[(4)])));

return statearr_27509;
})();
var inst_27397__$1 = cljs.core.first.call(null,clause);
var inst_27398 = cljs.core._EQ_.call(null,"$fdb",inst_27397__$1);
var state_27484__$1 = (function (){var statearr_27510 = state_27484;
(statearr_27510[(7)] = inst_27397__$1);

return statearr_27510;
})();
if(inst_27398){
var statearr_27511_27553 = state_27484__$1;
(statearr_27511_27553[(1)] = (6));

} else {
var statearr_27512_27554 = state_27484__$1;
(statearr_27512_27554[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (23))){
var inst_27397 = (state_27484[(7)]);
var inst_27463 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27397)," is not supported in Fluree"].join('');
var inst_27464 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27465 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_27466 = cljs.core.PersistentHashMap.fromArrays(inst_27464,inst_27465);
var inst_27467 = cljs.core.ex_info.call(null,inst_27463,inst_27466);
var inst_27468 = (function(){throw inst_27467})();
var state_27484__$1 = state_27484;
var statearr_27513_27555 = state_27484__$1;
(statearr_27513_27555[(2)] = inst_27468);

(statearr_27513_27555[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (19))){
var inst_27397 = (state_27484[(7)]);
var inst_27438 = (state_27484[(12)]);
var inst_27435 = fluree.db.query.analytical.isolate_source_name.call(null,inst_27397);
var inst_27436 = fluree.db.query.analytical.isolate_source_block.call(null,inst_27397);
var inst_27437 = cljs.core.keyword.call(null,inst_27435);
var inst_27438__$1 = cljs.core.get.call(null,prefixes,inst_27437);
var state_27484__$1 = (function (){var statearr_27514 = state_27484;
(statearr_27514[(11)] = inst_27436);

(statearr_27514[(12)] = inst_27438__$1);

return statearr_27514;
})();
if(cljs.core.truth_(inst_27438__$1)){
var statearr_27515_27556 = state_27484__$1;
(statearr_27515_27556[(1)] = (22));

} else {
var statearr_27516_27557 = state_27484__$1;
(statearr_27516_27557[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (11))){
var inst_27477 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
var statearr_27518_27558 = state_27484__$1;
(statearr_27518_27558[(2)] = inst_27477);

(statearr_27518_27558[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (9))){
var inst_27397 = (state_27484[(7)]);
var inst_27409 = cljs.core.subs.call(null,inst_27397,(4));
var inst_27410 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_27409);
var inst_27411 = fluree.db.time_travel.as_of_block.call(null,db,inst_27410);
var state_27484__$1 = state_27484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27484__$1,(12),inst_27411);
} else {
if((state_val_27485 === (5))){
var _ = (function (){var statearr_27519 = state_27484;
(statearr_27519[(4)] = cljs.core.rest.call(null,(state_27484[(4)])));

return statearr_27519;
})();
var state_27484__$1 = state_27484;
var ex27517 = (state_27484__$1[(2)]);
var statearr_27520_27559 = state_27484__$1;
(statearr_27520_27559[(5)] = ex27517);


if((ex27517 instanceof Error)){
var statearr_27521_27560 = state_27484__$1;
(statearr_27521_27560[(1)] = (4));

(statearr_27521_27560[(5)] = null);

} else {
throw ex27517;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (14))){
var state_27484__$1 = state_27484;
var statearr_27522_27561 = state_27484__$1;
(statearr_27522_27561[(2)] = null);

(statearr_27522_27561[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (26))){
var inst_27440 = (state_27484[(13)]);
var inst_27447 = (state_27484[(8)]);
var inst_27449 = fluree.db.time_travel.as_of_block.call(null,inst_27447,inst_27440);
var state_27484__$1 = state_27484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27484__$1,(29),inst_27449);
} else {
if((state_val_27485 === (16))){
var inst_27430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27431 = ["$wd",clause];
var inst_27432 = (new cljs.core.PersistentVector(null,2,(5),inst_27430,inst_27431,null));
var state_27484__$1 = state_27484;
var statearr_27523_27562 = state_27484__$1;
(statearr_27523_27562[(2)] = inst_27432);

(statearr_27523_27562[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (10))){
var inst_27397 = (state_27484[(7)]);
var inst_27428 = cljs.core._EQ_.call(null,"$wd",inst_27397);
var state_27484__$1 = state_27484;
if(inst_27428){
var statearr_27524_27563 = state_27484__$1;
(statearr_27524_27563[(1)] = (16));

} else {
var statearr_27525_27564 = state_27484__$1;
(statearr_27525_27564[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (18))){
var inst_27475 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
var statearr_27526_27565 = state_27484__$1;
(statearr_27526_27565[(2)] = inst_27475);

(statearr_27526_27565[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (8))){
var inst_27479 = (state_27484[(2)]);
var _ = (function (){var statearr_27527 = state_27484;
(statearr_27527[(4)] = cljs.core.rest.call(null,(state_27484[(4)])));

return statearr_27527;
})();
var state_27484__$1 = state_27484;
var statearr_27528_27566 = state_27484__$1;
(statearr_27528_27566[(2)] = inst_27479);

(statearr_27528_27566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__11469__auto__ = null;
var fluree$db$query$analytical$state_machine__11469__auto____0 = (function (){
var statearr_27529 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27529[(0)] = fluree$db$query$analytical$state_machine__11469__auto__);

(statearr_27529[(1)] = (1));

return statearr_27529;
});
var fluree$db$query$analytical$state_machine__11469__auto____1 = (function (state_27484){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_27484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e27530){var ex__11472__auto__ = e27530;
var statearr_27531_27567 = state_27484;
(statearr_27531_27567[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_27484[(4)]))){
var statearr_27532_27568 = state_27484;
(statearr_27532_27568[(1)] = cljs.core.first.call(null,(state_27484[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27569 = state_27484;
state_27484 = G__27569;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__11469__auto__ = function(state_27484){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__11469__auto____1.call(this,state_27484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__11469__auto____0;
fluree$db$query$analytical$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__11469__auto____1;
return fluree$db$query$analytical$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_27533 = f__11543__auto__.call(null);
(statearr_27533[(6)] = c__11542__auto__);

return statearr_27533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__27570){
var vec__27571 = p__27570;
var sub = cljs.core.nth.call(null,vec__27571,(0),null);
var obj = cljs.core.nth.call(null,vec__27571,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__27574_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__27574_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__27578 = subjects;
var vec__27579 = G__27578;
var seq__27580 = cljs.core.seq.call(null,vec__27579);
var first__27581 = cljs.core.first.call(null,seq__27580);
var seq__27580__$1 = cljs.core.next.call(null,seq__27580);
var subject = first__27581;
var r = seq__27580__$1;
var acc = expanded_map;
var G__27578__$1 = G__27578;
var acc__$1 = acc;
while(true){
var vec__27585 = G__27578__$1;
var seq__27586 = cljs.core.seq.call(null,vec__27585);
var first__27587 = cljs.core.first.call(null,seq__27586);
var seq__27586__$1 = cljs.core.next.call(null,seq__27586);
var subject__$1 = first__27587;
var r__$1 = seq__27586__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__27588 = r__$1;
var G__27589 = acc__$2;
G__27578__$1 = G__27588;
acc__$1 = G__27589;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__27578__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__27585,seq__27586,first__27587,seq__27586__$1,subject__$1,r__$1,acc__$2,G__27578,vec__27579,seq__27580,first__27581,seq__27580__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__27578__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__27585,seq__27586,first__27587,seq__27586__$1,subject__$1,r__$1,acc__$2,G__27578,vec__27579,seq__27580,first__27581,seq__27580__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__27578__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__27585,seq__27586,first__27587,seq__27586__$1,subject__$1,r__$1,acc__$2,G__27578,vec__27579,seq__27580,first__27581,seq__27580__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__27578__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__27585,seq__27586,first__27587,seq__27586__$1,subject__$1,r__$1,acc__$2,G__27578,vec__27579,seq__27580,first__27581,seq__27580__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__27578__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__27585,seq__27586,first__27587,seq__27586__$1,subject__$1,r__$1,acc__$2,G__27578,vec__27579,seq__27580,first__27581,seq__27580__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__27578__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__27585,seq__27586,first__27587,seq__27586__$1,subject__$1,r__$1,acc__$2,G__27578,vec__27579,seq__27580,first__27581,seq__27580__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__27590 = r__$1;
var G__27591 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__27578__$1 = G__27590;
acc__$1 = G__27591;
continue;
} else {
var G__27592 = subjects;
var G__27593 = acc_STAR_;
G__27578__$1 = G__27592;
acc__$1 = G__27593;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__27594_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__27594_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_27685){
var state_val_27686 = (state_27685[(1)]);
if((state_val_27686 === (7))){
var state_27685__$1 = state_27685;
var statearr_27687_27733 = state_27685__$1;
(statearr_27687_27733[(2)] = (100));

(statearr_27687_27733[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (20))){
var inst_27634 = (state_27685[(7)]);
var state_27685__$1 = state_27685;
var statearr_27688_27734 = state_27685__$1;
(statearr_27688_27734[(2)] = inst_27634);

(statearr_27688_27734[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (1))){
var state_27685__$1 = state_27685;
var statearr_27689_27735 = state_27685__$1;
(statearr_27689_27735[(2)] = null);

(statearr_27689_27735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (24))){
var inst_27606 = (state_27685[(8)]);
var inst_27673 = (state_27685[(9)]);
var inst_27672 = (state_27685[(10)]);
var inst_27671 = (state_27685[(11)]);
var inst_27676 = (function (){var max_depth = inst_27606;
var recur_map__$1 = inst_27672;
var subjects = inst_27671;
var tuples = inst_27673;
return (function (p1__27595_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__27595_SHARP_)],null));
});
})();
var inst_27677 = cljs.core.map.call(null,inst_27676,inst_27673);
var inst_27678 = cljs.core.distinct.call(null,inst_27677);
var state_27685__$1 = state_27685;
var statearr_27690_27736 = state_27685__$1;
(statearr_27690_27736[(2)] = inst_27678);

(statearr_27690_27736[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (4))){
var inst_27596 = (state_27685[(2)]);
var state_27685__$1 = state_27685;
var statearr_27691_27737 = state_27685__$1;
(statearr_27691_27737[(2)] = inst_27596);

(statearr_27691_27737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (15))){
var inst_27619 = (state_27685[(12)]);
var inst_27630 = cljs.core.PersistentVector.EMPTY;
var inst_27631 = cljs.core.seq.call(null,inst_27619);
var inst_27632 = cljs.core.first.call(null,inst_27631);
var inst_27633 = cljs.core.next.call(null,inst_27631);
var inst_27634 = inst_27630;
var inst_27635 = inst_27619;
var state_27685__$1 = (function (){var statearr_27692 = state_27685;
(statearr_27692[(13)] = inst_27633);

(statearr_27692[(14)] = inst_27635);

(statearr_27692[(15)] = inst_27632);

(statearr_27692[(7)] = inst_27634);

return statearr_27692;
})();
var statearr_27693_27738 = state_27685__$1;
(statearr_27693_27738[(2)] = null);

(statearr_27693_27738[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (21))){
var inst_27655 = (state_27685[(2)]);
var state_27685__$1 = state_27685;
var statearr_27694_27739 = state_27685__$1;
(statearr_27694_27739[(2)] = inst_27655);

(statearr_27694_27739[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (13))){
var inst_27668 = (state_27685[(2)]);
var state_27685__$1 = state_27685;
var statearr_27695_27740 = state_27685__$1;
(statearr_27695_27740[(2)] = inst_27668);

(statearr_27695_27740[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (22))){
var inst_27642 = (state_27685[(16)]);
var inst_27634 = (state_27685[(7)]);
var inst_27649 = (state_27685[(2)]);
var inst_27650 = fluree.db.util.async.throw_err.call(null,inst_27649);
var inst_27651 = cljs.core.concat.call(null,inst_27634,inst_27650);
var inst_27634__$1 = inst_27651;
var inst_27635 = inst_27642;
var state_27685__$1 = (function (){var statearr_27696 = state_27685;
(statearr_27696[(14)] = inst_27635);

(statearr_27696[(7)] = inst_27634__$1);

return statearr_27696;
})();
var statearr_27697_27741 = state_27685__$1;
(statearr_27697_27741[(2)] = null);

(statearr_27697_27741[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (6))){
var inst_27602 = (state_27685[(17)]);
var state_27685__$1 = state_27685;
var statearr_27698_27742 = state_27685__$1;
(statearr_27698_27742[(2)] = inst_27602);

(statearr_27698_27742[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (25))){
var inst_27680 = (state_27685[(2)]);
var _ = (function (){var statearr_27699 = state_27685;
(statearr_27699[(4)] = cljs.core.rest.call(null,(state_27685[(4)])));

return statearr_27699;
})();
var state_27685__$1 = state_27685;
var statearr_27700_27743 = state_27685__$1;
(statearr_27700_27743[(2)] = inst_27680);

(statearr_27700_27743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (17))){
var inst_27635 = (state_27685[(14)]);
var inst_27641 = (state_27685[(18)]);
var inst_27640 = cljs.core.seq.call(null,inst_27635);
var inst_27641__$1 = cljs.core.first.call(null,inst_27640);
var inst_27642 = cljs.core.next.call(null,inst_27640);
var state_27685__$1 = (function (){var statearr_27701 = state_27685;
(statearr_27701[(16)] = inst_27642);

(statearr_27701[(18)] = inst_27641__$1);

return statearr_27701;
})();
if(cljs.core.truth_(inst_27641__$1)){
var statearr_27702_27744 = state_27685__$1;
(statearr_27702_27744[(1)] = (19));

} else {
var statearr_27703_27745 = state_27685__$1;
(statearr_27703_27745[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (3))){
var inst_27683 = (state_27685[(2)]);
var state_27685__$1 = state_27685;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27685__$1,inst_27683);
} else {
if((state_val_27686 === (12))){
var inst_27608 = (state_27685[(19)]);
var inst_27619 = (state_27685[(12)]);
var inst_27614 = cljs.core.vals.call(null,inst_27608);
var inst_27615 = cljs.core.flatten.call(null,inst_27614);
var inst_27616 = cljs.core.set.call(null,inst_27615);
var inst_27617 = cljs.core.keys.call(null,inst_27608);
var inst_27618 = cljs.core.set.call(null,inst_27617);
var inst_27619__$1 = clojure.set.difference.call(null,inst_27616,inst_27618);
var inst_27620 = cljs.core.empty_QMARK_.call(null,inst_27619__$1);
var state_27685__$1 = (function (){var statearr_27704 = state_27685;
(statearr_27704[(12)] = inst_27619__$1);

return statearr_27704;
})();
if(inst_27620){
var statearr_27705_27746 = state_27685__$1;
(statearr_27705_27746[(1)] = (14));

} else {
var statearr_27706_27747 = state_27685__$1;
(statearr_27706_27747[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (2))){
var inst_27602 = (state_27685[(17)]);
var _ = (function (){var statearr_27707 = state_27685;
(statearr_27707[(4)] = cljs.core.cons.call(null,(5),(state_27685[(4)])));

return statearr_27707;
})();
var inst_27602__$1 = depth;
var state_27685__$1 = (function (){var statearr_27708 = state_27685;
(statearr_27708[(17)] = inst_27602__$1);

return statearr_27708;
})();
if(cljs.core.truth_(inst_27602__$1)){
var statearr_27709_27748 = state_27685__$1;
(statearr_27709_27748[(1)] = (6));

} else {
var statearr_27710_27749 = state_27685__$1;
(statearr_27710_27749[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (23))){
var inst_27673 = (state_27685[(9)]);
var state_27685__$1 = state_27685;
var statearr_27711_27750 = state_27685__$1;
(statearr_27711_27750[(2)] = inst_27673);

(statearr_27711_27750[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (19))){
var inst_27641 = (state_27685[(18)]);
var inst_27644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27645 = [inst_27641,predicate];
var inst_27646 = (new cljs.core.PersistentVector(null,2,(5),inst_27644,inst_27645,null));
var inst_27647 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27646);
var state_27685__$1 = state_27685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27685__$1,(22),inst_27647);
} else {
if((state_val_27686 === (11))){
var inst_27608 = (state_27685[(19)]);
var state_27685__$1 = state_27685;
var statearr_27713_27751 = state_27685__$1;
(statearr_27713_27751[(2)] = inst_27608);

(statearr_27713_27751[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (9))){
var inst_27609 = (state_27685[(20)]);
var inst_27606 = (state_27685[(8)]);
var inst_27611 = (inst_27609 >= inst_27606);
var state_27685__$1 = state_27685;
if(cljs.core.truth_(inst_27611)){
var statearr_27714_27752 = state_27685__$1;
(statearr_27714_27752[(1)] = (11));

} else {
var statearr_27715_27753 = state_27685__$1;
(statearr_27715_27753[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (5))){
var _ = (function (){var statearr_27716 = state_27685;
(statearr_27716[(4)] = cljs.core.rest.call(null,(state_27685[(4)])));

return statearr_27716;
})();
var state_27685__$1 = state_27685;
var ex27712 = (state_27685__$1[(2)]);
var statearr_27717_27754 = state_27685__$1;
(statearr_27717_27754[(5)] = ex27712);


if((ex27712 instanceof Error)){
var statearr_27718_27755 = state_27685__$1;
(statearr_27718_27755[(1)] = (4));

(statearr_27718_27755[(5)] = null);

} else {
throw ex27712;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (14))){
var inst_27608 = (state_27685[(19)]);
var state_27685__$1 = state_27685;
var statearr_27719_27756 = state_27685__$1;
(statearr_27719_27756[(2)] = inst_27608);

(statearr_27719_27756[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (16))){
var inst_27666 = (state_27685[(2)]);
var state_27685__$1 = state_27685;
var statearr_27720_27757 = state_27685__$1;
(statearr_27720_27757[(2)] = inst_27666);

(statearr_27720_27757[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (10))){
var inst_27672 = (state_27685[(10)]);
var inst_27671 = (state_27685[(11)]);
var inst_27670 = (state_27685[(2)]);
var inst_27671__$1 = cljs.core.keys.call(null,inst_27670);
var inst_27672__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_27671__$1,inst_27670);
var inst_27673 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_27671__$1,inst_27672__$1);
var state_27685__$1 = (function (){var statearr_27721 = state_27685;
(statearr_27721[(9)] = inst_27673);

(statearr_27721[(10)] = inst_27672__$1);

(statearr_27721[(11)] = inst_27671__$1);

return statearr_27721;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_27722_27758 = state_27685__$1;
(statearr_27722_27758[(1)] = (23));

} else {
var statearr_27723_27759 = state_27685__$1;
(statearr_27723_27759[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (18))){
var inst_27608 = (state_27685[(19)]);
var inst_27609 = (state_27685[(20)]);
var inst_27657 = (state_27685[(2)]);
var inst_27658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27659 = [(0),(2)];
var inst_27660 = (new cljs.core.PersistentVector(null,2,(5),inst_27658,inst_27659,null));
var inst_27661 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_27660,inst_27657);
var inst_27662 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_27608,inst_27661);
var inst_27663 = (inst_27609 + (1));
var inst_27608__$1 = inst_27662;
var inst_27609__$1 = inst_27663;
var state_27685__$1 = (function (){var statearr_27724 = state_27685;
(statearr_27724[(19)] = inst_27608__$1);

(statearr_27724[(20)] = inst_27609__$1);

return statearr_27724;
})();
var statearr_27725_27760 = state_27685__$1;
(statearr_27725_27760[(2)] = null);

(statearr_27725_27760[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27686 === (8))){
var inst_27606 = (state_27685[(2)]);
var inst_27607 = recur_map;
var inst_27608 = inst_27607;
var inst_27609 = (1);
var state_27685__$1 = (function (){var statearr_27726 = state_27685;
(statearr_27726[(19)] = inst_27608);

(statearr_27726[(20)] = inst_27609);

(statearr_27726[(8)] = inst_27606);

return statearr_27726;
})();
var statearr_27727_27761 = state_27685__$1;
(statearr_27727_27761[(2)] = null);

(statearr_27727_27761[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11469__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11469__auto____0 = (function (){
var statearr_27728 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27728[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11469__auto__);

(statearr_27728[(1)] = (1));

return statearr_27728;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11469__auto____1 = (function (state_27685){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_27685);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e27729){var ex__11472__auto__ = e27729;
var statearr_27730_27762 = state_27685;
(statearr_27730_27762[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_27685[(4)]))){
var statearr_27731_27763 = state_27685;
(statearr_27731_27763[(1)] = cljs.core.first.call(null,(state_27685[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27764 = state_27685;
state_27685 = G__27764;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11469__auto__ = function(state_27685){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11469__auto____1.call(this,state_27685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11469__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11469__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_27732 = f__11543__auto__.call(null);
(statearr_27732[(6)] = c__11542__auto__);

return statearr_27732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__27765,clause,fuel,max_fuel){
var map__27766 = p__27765;
var map__27766__$1 = (((((!((map__27766 == null))))?(((((map__27766.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27766.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27766):map__27766);
var res = map__27766__$1;
var headers = cljs.core.get.call(null,map__27766__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__27766__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__27766__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_27898){
var state_val_27899 = (state_27898[(1)]);
if((state_val_27899 === (7))){
var state_27898__$1 = state_27898;
var statearr_27900_27966 = state_27898__$1;
(statearr_27900_27966[(2)] = false);

(statearr_27900_27966[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (20))){
var inst_27830 = (state_27898[(7)]);
var state_27898__$1 = state_27898;
var statearr_27901_27967 = state_27898__$1;
(statearr_27901_27967[(2)] = inst_27830);

(statearr_27901_27967[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (27))){
var inst_27834 = (state_27898[(8)]);
var inst_27858 = (state_27898[(2)]);
var state_27898__$1 = (function (){var statearr_27902 = state_27898;
(statearr_27902[(9)] = inst_27858);

return statearr_27902;
})();
if(cljs.core.truth_(inst_27834)){
var statearr_27903_27968 = state_27898__$1;
(statearr_27903_27968[(1)] = (28));

} else {
var statearr_27904_27969 = state_27898__$1;
(statearr_27904_27969[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (1))){
var state_27898__$1 = state_27898;
var statearr_27905_27970 = state_27898__$1;
(statearr_27905_27970[(2)] = null);

(statearr_27905_27970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (24))){
var inst_27846 = (state_27898[(2)]);
var inst_27847 = cljs.core.nth.call(null,clause,(2));
var inst_27848 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_27847);
var state_27898__$1 = (function (){var statearr_27906 = state_27898;
(statearr_27906[(10)] = inst_27846);

return statearr_27906;
})();
if(cljs.core.truth_(inst_27848)){
var statearr_27907_27971 = state_27898__$1;
(statearr_27907_27971[(1)] = (25));

} else {
var statearr_27908_27972 = state_27898__$1;
(statearr_27908_27972[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (4))){
var inst_27768 = (state_27898[(2)]);
var state_27898__$1 = state_27898;
var statearr_27909_27973 = state_27898__$1;
(statearr_27909_27973[(2)] = inst_27768);

(statearr_27909_27973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (15))){
var inst_27816 = (state_27898[(11)]);
var state_27898__$1 = state_27898;
var statearr_27910_27974 = state_27898__$1;
(statearr_27910_27974[(2)] = inst_27816);

(statearr_27910_27974[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (21))){
var inst_27801 = (state_27898[(12)]);
var inst_27889 = (state_27898[(2)]);
var inst_27890 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_27891 = cljs.core.keys.call(null,inst_27801);
var inst_27892 = [inst_27891,vars,inst_27889];
var inst_27893 = cljs.core.PersistentHashMap.fromArrays(inst_27890,inst_27892);
var _ = (function (){var statearr_27911 = state_27898;
(statearr_27911[(4)] = cljs.core.rest.call(null,(state_27898[(4)])));

return statearr_27911;
})();
var state_27898__$1 = state_27898;
var statearr_27912_27975 = state_27898__$1;
(statearr_27912_27975[(2)] = inst_27893);

(statearr_27912_27975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (31))){
var inst_27830 = (state_27898[(7)]);
var inst_27832 = (state_27898[(13)]);
var inst_27865 = cljs.core.PersistentHashMap.EMPTY;
var inst_27866 = cljs.core.flatten.call(null,inst_27830);
var inst_27867 = cljs.core.assoc.call(null,inst_27865,inst_27832,inst_27866);
var state_27898__$1 = state_27898;
var statearr_27913_27976 = state_27898__$1;
(statearr_27913_27976[(2)] = inst_27867);

(statearr_27913_27976[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (32))){
var inst_27832 = (state_27898[(13)]);
var inst_27869 = cljs.core.coll_QMARK_.call(null,inst_27832);
var state_27898__$1 = state_27898;
if(inst_27869){
var statearr_27914_27977 = state_27898__$1;
(statearr_27914_27977[(1)] = (34));

} else {
var statearr_27915_27978 = state_27898__$1;
(statearr_27915_27978[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (33))){
var inst_27880 = (state_27898[(2)]);
var state_27898__$1 = state_27898;
var statearr_27916_27979 = state_27898__$1;
(statearr_27916_27979[(2)] = inst_27880);

(statearr_27916_27979[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (13))){
var inst_27778 = (state_27898[(14)]);
var state_27898__$1 = state_27898;
var statearr_27917_27980 = state_27898__$1;
(statearr_27917_27980[(2)] = inst_27778);

(statearr_27917_27980[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (22))){
var inst_27814 = (state_27898[(15)]);
var inst_27838 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27814)].join('');
var inst_27839 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27840 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_27841 = cljs.core.PersistentHashMap.fromArrays(inst_27839,inst_27840);
var inst_27842 = cljs.core.ex_info.call(null,inst_27838,inst_27841);
var inst_27843 = (function(){throw inst_27842})();
var state_27898__$1 = state_27898;
var statearr_27918_27981 = state_27898__$1;
(statearr_27918_27981[(2)] = inst_27843);

(statearr_27918_27981[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (36))){
var inst_27878 = (state_27898[(2)]);
var state_27898__$1 = state_27898;
var statearr_27919_27982 = state_27898__$1;
(statearr_27919_27982[(2)] = inst_27878);

(statearr_27919_27982[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (29))){
var inst_27832 = (state_27898[(13)]);
var inst_27863 = typeof inst_27832 === 'number';
var state_27898__$1 = state_27898;
if(cljs.core.truth_(inst_27863)){
var statearr_27920_27983 = state_27898__$1;
(statearr_27920_27983[(1)] = (31));

} else {
var statearr_27921_27984 = state_27898__$1;
(statearr_27921_27984[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (6))){
var inst_27778 = (state_27898[(14)]);
var inst_27783 = inst_27778.cljs$lang$protocol_mask$partition0$;
var inst_27784 = (inst_27783 & (64));
var inst_27785 = inst_27778.cljs$core$ISeq$;
var inst_27786 = (cljs.core.PROTOCOL_SENTINEL === inst_27785);
var inst_27787 = ((inst_27784) || (inst_27786));
var state_27898__$1 = state_27898;
if(cljs.core.truth_(inst_27787)){
var statearr_27922_27985 = state_27898__$1;
(statearr_27922_27985[(1)] = (9));

} else {
var statearr_27923_27986 = state_27898__$1;
(statearr_27923_27986[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (28))){
var inst_27830 = (state_27898[(7)]);
var inst_27860 = cljs.core.PersistentHashMap.EMPTY;
var inst_27861 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_27860,inst_27830);
var state_27898__$1 = state_27898;
var statearr_27924_27987 = state_27898__$1;
(statearr_27924_27987[(2)] = inst_27861);

(statearr_27924_27987[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (25))){
var state_27898__$1 = state_27898;
var statearr_27925_27988 = state_27898__$1;
(statearr_27925_27988[(2)] = null);

(statearr_27925_27988[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (34))){
var inst_27826 = (state_27898[(16)]);
var inst_27830 = (state_27898[(7)]);
var inst_27871 = cljs.core.PersistentHashMap.EMPTY;
var inst_27872 = cljs.core.first.call(null,inst_27826);
var inst_27873 = cljs.core.first.call(null,inst_27872);
var inst_27874 = cljs.core.flatten.call(null,inst_27830);
var inst_27875 = cljs.core.assoc.call(null,inst_27871,inst_27873,inst_27874);
var state_27898__$1 = state_27898;
var statearr_27926_27989 = state_27898__$1;
(statearr_27926_27989[(2)] = inst_27875);

(statearr_27926_27989[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (17))){
var inst_27815 = (state_27898[(17)]);
var inst_27814 = (state_27898[(15)]);
var inst_27820 = (state_27898[(2)]);
var inst_27821 = [inst_27820];
var inst_27822 = cljs.core.PersistentHashMap.fromArrays(inst_27815,inst_27821);
var inst_27823 = fluree.db.query.range.search.call(null,db,inst_27814,inst_27822);
var state_27898__$1 = state_27898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27898__$1,(18),inst_27823);
} else {
if((state_val_27899 === (3))){
var inst_27896 = (state_27898[(2)]);
var state_27898__$1 = state_27898;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27898__$1,inst_27896);
} else {
if((state_val_27899 === (12))){
var inst_27778 = (state_27898[(14)]);
var inst_27796 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27778);
var state_27898__$1 = state_27898;
var statearr_27927_27990 = state_27898__$1;
(statearr_27927_27990[(2)] = inst_27796);

(statearr_27927_27990[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (2))){
var inst_27778 = (state_27898[(14)]);
var _ = (function (){var statearr_27928 = state_27898;
(statearr_27928[(4)] = cljs.core.cons.call(null,(5),(state_27898[(4)])));

return statearr_27928;
})();
var inst_27778__$1 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_27780 = (inst_27778__$1 == null);
var inst_27781 = cljs.core.not.call(null,inst_27780);
var state_27898__$1 = (function (){var statearr_27929 = state_27898;
(statearr_27929[(14)] = inst_27778__$1);

return statearr_27929;
})();
if(inst_27781){
var statearr_27930_27991 = state_27898__$1;
(statearr_27930_27991[(1)] = (6));

} else {
var statearr_27931_27992 = state_27898__$1;
(statearr_27931_27992[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (23))){
var state_27898__$1 = state_27898;
var statearr_27932_27993 = state_27898__$1;
(statearr_27932_27993[(2)] = null);

(statearr_27932_27993[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (35))){
var state_27898__$1 = state_27898;
var statearr_27933_27994 = state_27898__$1;
(statearr_27933_27994[(2)] = null);

(statearr_27933_27994[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (19))){
var inst_27814 = (state_27898[(15)]);
var inst_27835 = (state_27898[(18)]);
var inst_27832 = cljs.core.first.call(null,inst_27814);
var inst_27833 = cljs.core.first.call(null,clause);
var inst_27834 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_27833);
var inst_27835__$1 = cljs.core.nth.call(null,inst_27814,(1));
var inst_27836 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_27835__$1);
var state_27898__$1 = (function (){var statearr_27934 = state_27898;
(statearr_27934[(8)] = inst_27834);

(statearr_27934[(13)] = inst_27832);

(statearr_27934[(18)] = inst_27835__$1);

return statearr_27934;
})();
if(cljs.core.truth_(inst_27836)){
var statearr_27935_27995 = state_27898__$1;
(statearr_27935_27995[(1)] = (22));

} else {
var statearr_27936_27996 = state_27898__$1;
(statearr_27936_27996[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (11))){
var inst_27791 = (state_27898[(2)]);
var state_27898__$1 = state_27898;
var statearr_27938_27997 = state_27898__$1;
(statearr_27938_27997[(2)] = inst_27791);

(statearr_27938_27997[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (9))){
var state_27898__$1 = state_27898;
var statearr_27939_27998 = state_27898__$1;
(statearr_27939_27998[(2)] = true);

(statearr_27939_27998[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (5))){
var _ = (function (){var statearr_27940 = state_27898;
(statearr_27940[(4)] = cljs.core.rest.call(null,(state_27898[(4)])));

return statearr_27940;
})();
var state_27898__$1 = state_27898;
var ex27937 = (state_27898__$1[(2)]);
var statearr_27941_27999 = state_27898__$1;
(statearr_27941_27999[(5)] = ex27937);


if((ex27937 instanceof Error)){
var statearr_27942_28000 = state_27898__$1;
(statearr_27942_28000[(1)] = (4));

(statearr_27942_28000[(5)] = null);

} else {
throw ex27937;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (14))){
var inst_27804 = (state_27898[(19)]);
var inst_27805 = (state_27898[(20)]);
var inst_27816 = (state_27898[(11)]);
var inst_27801 = (state_27898[(12)]);
var inst_27799 = (state_27898[(2)]);
var inst_27800 = cljs.core.get.call(null,inst_27799,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_27801__$1 = cljs.core.get.call(null,inst_27799,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_27802 = cljs.core.get.call(null,inst_27799,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_27803 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_27804__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_27802);
var inst_27805__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_27802);
var inst_27807 = (function (){var map__27774 = inst_27799;
var search = inst_27800;
var rel = inst_27801__$1;
var opts = inst_27802;
var common_keys = inst_27803;
var object_fn = inst_27804__$1;
var recur_depth = inst_27805__$1;
return (function (p__27806,common_key){
var vec__27943 = p__27806;
var acc = cljs.core.nth.call(null,vec__27943,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__27943,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__27946 = cljs.core._EQ_;
var expr__27947 = idx_of;
if(cljs.core.truth_(pred__27946.call(null,(0),expr__27947))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__27946.call(null,(1),expr__27947))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__27946.call(null,(2),expr__27947))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__27947)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_27808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27809 = cljs.core.PersistentHashMap.EMPTY;
var inst_27810 = [inst_27809,inst_27800];
var inst_27811 = (new cljs.core.PersistentVector(null,2,(5),inst_27808,inst_27810,null));
var inst_27812 = cljs.core.reduce.call(null,inst_27807,inst_27811,inst_27803);
var inst_27813 = cljs.core.nth.call(null,inst_27812,(0),null);
var inst_27814 = cljs.core.nth.call(null,inst_27812,(1),null);
var inst_27815 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_27816__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_27813);
var state_27898__$1 = (function (){var statearr_27949 = state_27898;
(statearr_27949[(19)] = inst_27804__$1);

(statearr_27949[(20)] = inst_27805__$1);

(statearr_27949[(17)] = inst_27815);

(statearr_27949[(11)] = inst_27816__$1);

(statearr_27949[(12)] = inst_27801__$1);

(statearr_27949[(15)] = inst_27814);

return statearr_27949;
})();
if(cljs.core.truth_(inst_27816__$1)){
var statearr_27950_28001 = state_27898__$1;
(statearr_27950_28001[(1)] = (15));

} else {
var statearr_27951_28002 = state_27898__$1;
(statearr_27951_28002[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (26))){
var inst_27814 = (state_27898[(15)]);
var inst_27851 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27814)].join('');
var inst_27852 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27853 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_27854 = cljs.core.PersistentHashMap.fromArrays(inst_27852,inst_27853);
var inst_27855 = cljs.core.ex_info.call(null,inst_27851,inst_27854);
var inst_27856 = (function(){throw inst_27855})();
var state_27898__$1 = state_27898;
var statearr_27952_28003 = state_27898__$1;
(statearr_27952_28003[(2)] = inst_27856);

(statearr_27952_28003[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (16))){
var inst_27804 = (state_27898[(19)]);
var state_27898__$1 = state_27898;
var statearr_27953_28004 = state_27898__$1;
(statearr_27953_28004[(2)] = inst_27804);

(statearr_27953_28004[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (30))){
var inst_27834 = (state_27898[(8)]);
var inst_27805 = (state_27898[(20)]);
var inst_27835 = (state_27898[(18)]);
var inst_27882 = (state_27898[(2)]);
var inst_27883 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_27835,inst_27882,inst_27805,inst_27834);
var state_27898__$1 = state_27898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27898__$1,(37),inst_27883);
} else {
if((state_val_27899 === (10))){
var state_27898__$1 = state_27898;
var statearr_27954_28005 = state_27898__$1;
(statearr_27954_28005[(2)] = false);

(statearr_27954_28005[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (18))){
var inst_27805 = (state_27898[(20)]);
var inst_27826 = (state_27898[(16)]);
var inst_27801 = (state_27898[(12)]);
var inst_27825 = (state_27898[(2)]);
var inst_27826__$1 = fluree.db.util.async.throw_err.call(null,inst_27825);
var inst_27827 = cljs.core.count.call(null,inst_27826__$1);
var inst_27828 = fluree.db.query.analytical.add_fuel.call(null,inst_27827,fuel,max_fuel);
var inst_27829 = cljs.core.vals.call(null,inst_27801);
var inst_27830 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_27829,inst_27826__$1);
var state_27898__$1 = (function (){var statearr_27955 = state_27898;
(statearr_27955[(16)] = inst_27826__$1);

(statearr_27955[(7)] = inst_27830);

(statearr_27955[(21)] = inst_27828);

return statearr_27955;
})();
if(cljs.core.truth_(inst_27805)){
var statearr_27956_28006 = state_27898__$1;
(statearr_27956_28006[(1)] = (19));

} else {
var statearr_27957_28007 = state_27898__$1;
(statearr_27957_28007[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (37))){
var inst_27885 = (state_27898[(2)]);
var inst_27886 = fluree.db.util.async.throw_err.call(null,inst_27885);
var state_27898__$1 = state_27898;
var statearr_27958_28008 = state_27898__$1;
(statearr_27958_28008[(2)] = inst_27886);

(statearr_27958_28008[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27899 === (8))){
var inst_27794 = (state_27898[(2)]);
var state_27898__$1 = state_27898;
if(cljs.core.truth_(inst_27794)){
var statearr_27959_28009 = state_27898__$1;
(statearr_27959_28009[(1)] = (12));

} else {
var statearr_27960_28010 = state_27898__$1;
(statearr_27960_28010[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11469__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11469__auto____0 = (function (){
var statearr_27961 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27961[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11469__auto__);

(statearr_27961[(1)] = (1));

return statearr_27961;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11469__auto____1 = (function (state_27898){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_27898);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e27962){var ex__11472__auto__ = e27962;
var statearr_27963_28011 = state_27898;
(statearr_27963_28011[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_27898[(4)]))){
var statearr_27964_28012 = state_27898;
(statearr_27964_28012[(1)] = cljs.core.first.call(null,(state_27898[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28013 = state_27898;
state_27898 = G__28013;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11469__auto__ = function(state_27898){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11469__auto____1.call(this,state_27898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11469__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11469__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_27965 = f__11543__auto__.call(null);
(statearr_27965[(6)] = c__11542__auto__);

return statearr_27965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__28014,res,clause){
var map__28015 = p__28014;
var map__28015__$1 = (((((!((map__28015 == null))))?(((((map__28015.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28015.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28015):map__28015);
var db = map__28015__$1;
var conn = cljs.core.get.call(null,map__28015__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__28015__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__28015__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_28115){
var state_val_28116 = (state_28115[(1)]);
if((state_val_28116 === (7))){
var inst_28026 = (state_28115[(7)]);
var state_28115__$1 = state_28115;
var statearr_28117_28157 = state_28115__$1;
(statearr_28117_28157[(2)] = inst_28026);

(statearr_28117_28157[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (20))){
var inst_28106 = (state_28115[(2)]);
var state_28115__$1 = state_28115;
var statearr_28118_28158 = state_28115__$1;
(statearr_28118_28158[(2)] = inst_28106);

(statearr_28118_28158[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (1))){
var state_28115__$1 = state_28115;
var statearr_28119_28159 = state_28115__$1;
(statearr_28119_28159[(2)] = null);

(statearr_28119_28159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (24))){
var inst_28085 = (state_28115[(2)]);
var inst_28086 = fluree.db.util.async.throw_err.call(null,inst_28085);
var state_28115__$1 = state_28115;
var statearr_28120_28160 = state_28115__$1;
(statearr_28120_28160[(2)] = inst_28086);

(statearr_28120_28160[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (4))){
var inst_28019 = (state_28115[(2)]);
var state_28115__$1 = state_28115;
var statearr_28121_28161 = state_28115__$1;
(statearr_28121_28161[(2)] = inst_28019);

(statearr_28121_28161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (15))){
var inst_28028 = (state_28115[(8)]);
var inst_28026 = (state_28115[(7)]);
var inst_28047 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_28048 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_28049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28050 = [inst_28026];
var inst_28051 = (new cljs.core.PersistentVector(null,1,(5),inst_28049,inst_28050,null));
var inst_28052 = (function (){var subject_var = inst_28026;
var object_var = inst_28028;
var min_sid = inst_28047;
var max_sid = (0);
return (function (p1__28017_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__28017_SHARP_);
});
})();
var inst_28053 = cljs.core.range.call(null,inst_28047,(0));
var inst_28054 = cljs.core.map.call(null,inst_28052,inst_28053);
var inst_28055 = cljs.core.PersistentHashMap.EMPTY;
var inst_28056 = [inst_28051,inst_28054,inst_28055];
var inst_28057 = cljs.core.PersistentHashMap.fromArrays(inst_28048,inst_28056);
var state_28115__$1 = state_28115;
var statearr_28122_28162 = state_28115__$1;
(statearr_28122_28162[(2)] = inst_28057);

(statearr_28122_28162[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (21))){
var inst_28079 = (state_28115[(9)]);
var state_28115__$1 = state_28115;
var statearr_28123_28163 = state_28115__$1;
(statearr_28123_28163[(2)] = inst_28079);

(statearr_28123_28163[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (13))){
var inst_28028 = (state_28115[(8)]);
var state_28115__$1 = state_28115;
if(cljs.core.truth_(inst_28028)){
var statearr_28124_28164 = state_28115__$1;
(statearr_28124_28164[(1)] = (18));

} else {
var statearr_28125_28165 = state_28115__$1;
(statearr_28125_28165[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (22))){
var inst_28079 = (state_28115[(9)]);
var inst_28083 = fluree.db.dbproto._subid.call(null,db,inst_28079);
var state_28115__$1 = state_28115;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28115__$1,(24),inst_28083);
} else {
if((state_val_28116 === (6))){
var inst_28028 = (state_28115[(8)]);
var state_28115__$1 = state_28115;
var statearr_28126_28166 = state_28115__$1;
(statearr_28126_28166[(2)] = inst_28028);

(statearr_28126_28166[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (17))){
var inst_28076 = (state_28115[(2)]);
var state_28115__$1 = state_28115;
var statearr_28127_28167 = state_28115__$1;
(statearr_28127_28167[(2)] = inst_28076);

(statearr_28127_28167[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (3))){
var inst_28113 = (state_28115[(2)]);
var state_28115__$1 = state_28115;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28115__$1,inst_28113);
} else {
if((state_val_28116 === (12))){
var inst_28041 = ["_tx",null,"_block",null];
var inst_28042 = (new cljs.core.PersistentArrayMap(null,2,inst_28041,null));
var inst_28043 = (new cljs.core.PersistentHashSet(null,inst_28042,null));
var inst_28044 = cljs.core.last.call(null,clause);
var inst_28045 = inst_28043.call(null,inst_28044);
var state_28115__$1 = state_28115;
if(cljs.core.truth_(inst_28045)){
var statearr_28128_28168 = state_28115__$1;
(statearr_28128_28168[(1)] = (15));

} else {
var statearr_28129_28169 = state_28115__$1;
(statearr_28129_28169[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (2))){
var inst_28026 = (state_28115[(7)]);
var _ = (function (){var statearr_28130 = state_28115;
(statearr_28130[(4)] = cljs.core.cons.call(null,(5),(state_28115[(4)])));

return statearr_28130;
})();
var inst_28025 = cljs.core.first.call(null,clause);
var inst_28026__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_28025);
var inst_28027 = cljs.core.last.call(null,clause);
var inst_28028 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_28027);
var state_28115__$1 = (function (){var statearr_28131 = state_28115;
(statearr_28131[(8)] = inst_28028);

(statearr_28131[(7)] = inst_28026__$1);

return statearr_28131;
})();
if(cljs.core.truth_(inst_28026__$1)){
var statearr_28132_28170 = state_28115__$1;
(statearr_28132_28170[(1)] = (6));

} else {
var statearr_28133_28171 = state_28115__$1;
(statearr_28133_28171[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (23))){
var inst_28028 = (state_28115[(8)]);
var inst_28088 = (state_28115[(2)]);
var inst_28089 = fluree.db.flake.sid__GT_cid.call(null,inst_28088);
var inst_28090 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_28089);
var inst_28091 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_28092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28093 = [inst_28028];
var inst_28094 = (new cljs.core.PersistentVector(null,1,(5),inst_28092,inst_28093,null));
var inst_28095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28097 = [inst_28090];
var inst_28098 = (new cljs.core.PersistentVector(null,1,(5),inst_28096,inst_28097,null));
var inst_28099 = [inst_28098];
var inst_28100 = (new cljs.core.PersistentVector(null,1,(5),inst_28095,inst_28099,null));
var inst_28101 = cljs.core.PersistentHashMap.EMPTY;
var inst_28102 = [inst_28094,inst_28100,inst_28101];
var inst_28103 = cljs.core.PersistentHashMap.fromArrays(inst_28091,inst_28102);
var state_28115__$1 = state_28115;
var statearr_28134_28172 = state_28115__$1;
(statearr_28134_28172[(2)] = inst_28103);

(statearr_28134_28172[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (19))){
var state_28115__$1 = state_28115;
var statearr_28135_28173 = state_28115__$1;
(statearr_28135_28173[(2)] = null);

(statearr_28135_28173[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (11))){
var inst_28110 = (state_28115[(2)]);
var _ = (function (){var statearr_28137 = state_28115;
(statearr_28137[(4)] = cljs.core.rest.call(null,(state_28115[(4)])));

return statearr_28137;
})();
var state_28115__$1 = state_28115;
var statearr_28138_28174 = state_28115__$1;
(statearr_28138_28174[(2)] = inst_28110);

(statearr_28138_28174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (9))){
var inst_28034 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28035 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_28036 = cljs.core.PersistentHashMap.fromArrays(inst_28034,inst_28035);
var inst_28037 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_28036);
var inst_28038 = (function(){throw inst_28037})();
var state_28115__$1 = state_28115;
var statearr_28139_28175 = state_28115__$1;
(statearr_28139_28175[(2)] = inst_28038);

(statearr_28139_28175[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (5))){
var _ = (function (){var statearr_28140 = state_28115;
(statearr_28140[(4)] = cljs.core.rest.call(null,(state_28115[(4)])));

return statearr_28140;
})();
var state_28115__$1 = state_28115;
var ex28136 = (state_28115__$1[(2)]);
var statearr_28141_28176 = state_28115__$1;
(statearr_28141_28176[(5)] = ex28136);


if((ex28136 instanceof Error)){
var statearr_28142_28177 = state_28115__$1;
(statearr_28142_28177[(1)] = (4));

(statearr_28142_28177[(5)] = null);

} else {
throw ex28136;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (14))){
var inst_28108 = (state_28115[(2)]);
var state_28115__$1 = state_28115;
var statearr_28143_28178 = state_28115__$1;
(statearr_28143_28178[(2)] = inst_28108);

(statearr_28143_28178[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (16))){
var inst_28028 = (state_28115[(8)]);
var inst_28026 = (state_28115[(7)]);
var inst_28059 = cljs.core.last.call(null,clause);
var inst_28060 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_28059);
var inst_28061 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_28062 = cljs.core.get.call(null,inst_28061,inst_28060);
var inst_28063 = fluree.db.flake.min_subject_id.call(null,inst_28060);
var inst_28064 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_28065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28066 = [inst_28026];
var inst_28067 = (new cljs.core.PersistentVector(null,1,(5),inst_28065,inst_28066,null));
var inst_28068 = (function (){var subject_var = inst_28026;
var object_var = inst_28028;
var cid = inst_28060;
var max_sid = inst_28062;
var min_sid = inst_28063;
return (function (p1__28018_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__28018_SHARP_);
});
})();
var inst_28069 = (inst_28062 + (1));
var inst_28070 = cljs.core.range.call(null,inst_28063,inst_28069);
var inst_28071 = cljs.core.map.call(null,inst_28068,inst_28070);
var inst_28072 = cljs.core.PersistentHashMap.EMPTY;
var inst_28073 = [inst_28067,inst_28071,inst_28072];
var inst_28074 = cljs.core.PersistentHashMap.fromArrays(inst_28064,inst_28073);
var state_28115__$1 = state_28115;
var statearr_28144_28179 = state_28115__$1;
(statearr_28144_28179[(2)] = inst_28074);

(statearr_28144_28179[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (10))){
var inst_28026 = (state_28115[(7)]);
var state_28115__$1 = state_28115;
if(cljs.core.truth_(inst_28026)){
var statearr_28145_28180 = state_28115__$1;
(statearr_28145_28180[(1)] = (12));

} else {
var statearr_28146_28181 = state_28115__$1;
(statearr_28146_28181[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (18))){
var inst_28079 = (state_28115[(9)]);
var inst_28079__$1 = cljs.core.first.call(null,clause);
var inst_28080 = typeof inst_28079__$1 === 'number';
var state_28115__$1 = (function (){var statearr_28147 = state_28115;
(statearr_28147[(9)] = inst_28079__$1);

return statearr_28147;
})();
if(cljs.core.truth_(inst_28080)){
var statearr_28148_28182 = state_28115__$1;
(statearr_28148_28182[(1)] = (21));

} else {
var statearr_28149_28183 = state_28115__$1;
(statearr_28149_28183[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28116 === (8))){
var inst_28032 = (state_28115[(2)]);
var state_28115__$1 = state_28115;
if(cljs.core.truth_(inst_28032)){
var statearr_28150_28184 = state_28115__$1;
(statearr_28150_28184[(1)] = (9));

} else {
var statearr_28151_28185 = state_28115__$1;
(statearr_28151_28185[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11469__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11469__auto____0 = (function (){
var statearr_28152 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28152[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11469__auto__);

(statearr_28152[(1)] = (1));

return statearr_28152;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11469__auto____1 = (function (state_28115){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_28115);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e28153){var ex__11472__auto__ = e28153;
var statearr_28154_28186 = state_28115;
(statearr_28154_28186[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_28115[(4)]))){
var statearr_28155_28187 = state_28115;
(statearr_28155_28187[(1)] = cljs.core.first.call(null,(state_28115[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28188 = state_28115;
state_28115 = G__28188;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11469__auto__ = function(state_28115){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11469__auto____1.call(this,state_28115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11469__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11469__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_28156 = f__11543__auto__.call(null);
(statearr_28156[(6)] = c__11542__auto__);

return statearr_28156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__28194 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__28194 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__28194;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__28195(s__28196){
return (new cljs.core.LazySeq(null,(function (){
var s__28196__$1 = s__28196;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__28196__$1);
if(temp__5735__auto__){
var s__28196__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__28196__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__28196__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__28198 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__28197 = (0);
while(true){
if((i__28197 < size__4528__auto__)){
var x = cljs.core._nth.call(null,c__4527__auto__,i__28197);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__28198,(delta * delta));

var G__28199 = (i__28197 + (1));
i__28197 = G__28199;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__28198),fluree$db$query$analytical$variance_$_iter__28195.call(null,cljs.core.chunk_rest.call(null,s__28196__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__28198),null);
}
} else {
var x = cljs.core.first.call(null,s__28196__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__28195.call(null,cljs.core.rest.call(null,s__28196__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__28200 = null;
var G__28200__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__28200__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__28200 = function(n,coll){
switch(arguments.length){
case 1:
return G__28200__1.call(this,n);
case 2:
return G__28200__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28200.cljs$core$IFn$_invoke$arity$1 = G__28200__1;
G__28200.cljs$core$IFn$_invoke$arity$2 = G__28200__2;
return G__28200;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__28201 = null;
var G__28201__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__28201__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__28201 = function(n,coll){
switch(arguments.length){
case 1:
return G__28201__1.call(this,n);
case 2:
return G__28201__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28201.cljs$core$IFn$_invoke$arity$1 = G__28201__1;
G__28201.cljs$core$IFn$_invoke$arity$2 = G__28201__2;
return G__28201;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__28202 = null;
var G__28202__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__28202__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__28202 = function(n,coll){
switch(arguments.length){
case 1:
return G__28202__1.call(this,n);
case 2:
return G__28202__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28202.cljs$core$IFn$_invoke$arity$1 = G__28202__1;
G__28202.cljs$core$IFn$_invoke$arity$2 = G__28202__2;
return G__28202;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__28203 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__28203,(0),null);
var arg = cljs.core.nth.call(null,vec__28203,(1),null);
var var$ = cljs.core.nth.call(null,vec__28203,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__28206 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__28206,(0),null);
var variable = cljs.core.nth.call(null,vec__28206,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__28209 = agg;
var map__28209__$1 = (((((!((map__28209 == null))))?(((((map__28209.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28209.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28209):map__28209);
var variable = cljs.core.get.call(null,map__28209__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__28209__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__28209__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__28212 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__28212,(0),null);
var agg_result = cljs.core.nth.call(null,vec__28212,(1),null);
var map__28215 = res__$1;
var map__28215__$1 = (((((!((map__28215 == null))))?(((((map__28215.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28215.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28215):map__28215);
var headers = cljs.core.get.call(null,map__28215__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__28215__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__28211_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__28211_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__28217_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__28217_SHARP_);
}),a_idxs);
return cljs.core.reduce.call(null,(function (acc,b_tuple){
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__28218_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__28218_SHARP_);
}),b_idxs))){
return cljs.core.conj.call(null,(function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__28219_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__28219_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__28220_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__28220_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__28223,row,b_tuple){
var vec__28224 = p__28223;
var acc = cljs.core.nth.call(null,vec__28224,(0),null);
var b_rows = cljs.core.nth.call(null,vec__28224,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__28221_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__28221_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__28222_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__28222_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__28227_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__28227_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__28228_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__28228_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__28230_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__28230_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__28229_SHARP_){
return cljs.core.range.call(null,(0),p1__28229_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,(function (a_tuple){
return fluree.db.query.analytical.find_match.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__28231_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__28231_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__28232_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__28232_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__28233_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__28233_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__28235_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__28235_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__28234_SHARP_){
return cljs.core.range.call(null,(0),p1__28234_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,(function (a_tuple){
var matches = fluree.db.query.analytical.find_match.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null))], null);
}
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__28236_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__28236_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__28237_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__28237_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__28238_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__28238_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__28240_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__28240_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__28239_SHARP_){
return cljs.core.range.call(null,(0),p1__28239_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var vec__28243 = cljs.core.reduce.call(null,(function (p__28246,a_tuple){
var vec__28247 = p__28246;
var c_tuples = cljs.core.nth.call(null,vec__28247,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__28247,(1),null);
var vec__28250 = fluree.db.query.analytical.find_match_PLUS_row_nums.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.call(null,vec__28250,(0),null);
var matched_rows = cljs.core.nth.call(null,vec__28250,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,c_tuples,matches__$1),clojure.set.union.call(null,b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.call(null,vec__28243,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__28243,(1),null);
var b_unmatched_rows = cljs.core.remove.call(null,b_matched_rows,cljs.core.range.call(null,(0),cljs.core.count.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__28241_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__28241_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.call(null,(function (p1__28242_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__28242_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.call(null,(function (b_row){
var b_tuple = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.nth.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.call(null,(function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.call(null,b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.call(null,c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__28254 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__28254,(0),null);
var _ = cljs.core.nth.call(null,vec__28254,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__28253_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__28253_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__28259 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__28259,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__28259,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__28257_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__28257_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__28258_SHARP_){
return cljs.core.nth.call(null,clause,p1__28258_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__28262,filters,optional_QMARK_){
var map__28263 = p__28262;
var map__28263__$1 = (((((!((map__28263 == null))))?(((((map__28263.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28263.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28263):map__28263);
var tuple_map = map__28263__$1;
var headers = cljs.core.get.call(null,map__28263__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__28263__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__28263__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__28265 = clause;
var k = cljs.core.nth.call(null,vec__28265,(0),null);
var v = cljs.core.nth.call(null,vec__28265,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__28268 = res;
var map__28268__$1 = (((((!((map__28268 == null))))?(((((map__28268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28268.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28268):map__28268);
var headers = cljs.core.get.call(null,map__28268__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__28268__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5733__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_28325){
var state_val_28326 = (state_28325[(1)]);
if((state_val_28326 === (7))){
var inst_28299 = (state_28325[(7)]);
var inst_28297 = (state_28325[(2)]);
var inst_28298 = fluree.db.util.async.throw_err.call(null,inst_28297);
var inst_28299__$1 = cljs.core.nth.call(null,inst_28298,(0),null);
var inst_28300 = cljs.core.nth.call(null,inst_28298,(1),null);
var inst_28301 = (inst_28299__$1 == null);
var state_28325__$1 = (function (){var statearr_28327 = state_28325;
(statearr_28327[(8)] = inst_28300);

(statearr_28327[(7)] = inst_28299__$1);

return statearr_28327;
})();
if(cljs.core.truth_(inst_28301)){
var statearr_28328_28357 = state_28325__$1;
(statearr_28328_28357[(1)] = (8));

} else {
var statearr_28329_28358 = state_28325__$1;
(statearr_28329_28358[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (1))){
var inst_28277 = optional_clauses;
var inst_28278 = cljs.core.seq.call(null,inst_28277);
var inst_28279 = cljs.core.first.call(null,inst_28278);
var inst_28280 = cljs.core.next.call(null,inst_28278);
var inst_28281 = where_tuples;
var inst_28282 = inst_28277;
var inst_28283 = inst_28281;
var state_28325__$1 = (function (){var statearr_28330 = state_28325;
(statearr_28330[(9)] = inst_28280);

(statearr_28330[(10)] = inst_28279);

(statearr_28330[(11)] = inst_28283);

(statearr_28330[(12)] = inst_28282);

return statearr_28330;
})();
var statearr_28331_28359 = state_28325__$1;
(statearr_28331_28359[(2)] = null);

(statearr_28331_28359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (4))){
var inst_28289 = (state_28325[(13)]);
var inst_28283 = (state_28325[(11)]);
var inst_28290 = (state_28325[(14)]);
var inst_28295 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_28283,inst_28289,inst_28290,true,fuel,max_fuel,opts);
var state_28325__$1 = state_28325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28325__$1,(7),inst_28295);
} else {
if((state_val_28326 === (15))){
var state_28325__$1 = state_28325;
var statearr_28332_28360 = state_28325__$1;
(statearr_28332_28360[(2)] = null);

(statearr_28332_28360[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (13))){
var inst_28316 = (state_28325[(2)]);
var state_28325__$1 = state_28325;
var statearr_28333_28361 = state_28325__$1;
(statearr_28333_28361[(2)] = inst_28316);

(statearr_28333_28361[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (6))){
var inst_28321 = (state_28325[(2)]);
var state_28325__$1 = state_28325;
var statearr_28334_28362 = state_28325__$1;
(statearr_28334_28362[(2)] = inst_28321);

(statearr_28334_28362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (3))){
var inst_28323 = (state_28325[(2)]);
var state_28325__$1 = state_28325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28325__$1,inst_28323);
} else {
if((state_val_28326 === (12))){
var state_28325__$1 = state_28325;
var statearr_28335_28363 = state_28325__$1;
(statearr_28335_28363[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (2))){
var inst_28289 = (state_28325[(13)]);
var inst_28282 = (state_28325[(12)]);
var inst_28288 = cljs.core.seq.call(null,inst_28282);
var inst_28289__$1 = cljs.core.first.call(null,inst_28288);
var inst_28290 = cljs.core.next.call(null,inst_28288);
var state_28325__$1 = (function (){var statearr_28337 = state_28325;
(statearr_28337[(13)] = inst_28289__$1);

(statearr_28337[(14)] = inst_28290);

return statearr_28337;
})();
if(cljs.core.truth_(inst_28289__$1)){
var statearr_28338_28364 = state_28325__$1;
(statearr_28338_28364[(1)] = (4));

} else {
var statearr_28339_28365 = state_28325__$1;
(statearr_28339_28365[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (11))){
var inst_28300 = (state_28325[(8)]);
var inst_28299 = (state_28325[(7)]);
var inst_28282 = inst_28300;
var inst_28283 = inst_28299;
var state_28325__$1 = (function (){var statearr_28340 = state_28325;
(statearr_28340[(11)] = inst_28283);

(statearr_28340[(12)] = inst_28282);

return statearr_28340;
})();
var statearr_28341_28366 = state_28325__$1;
(statearr_28341_28366[(2)] = null);

(statearr_28341_28366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (9))){
var inst_28289 = (state_28325[(13)]);
var inst_28305 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_28289);
var state_28325__$1 = state_28325;
if(cljs.core.truth_(inst_28305)){
var statearr_28342_28367 = state_28325__$1;
(statearr_28342_28367[(1)] = (11));

} else {
var statearr_28343_28368 = state_28325__$1;
(statearr_28343_28368[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (5))){
var inst_28283 = (state_28325[(11)]);
var state_28325__$1 = state_28325;
var statearr_28344_28369 = state_28325__$1;
(statearr_28344_28369[(2)] = inst_28283);

(statearr_28344_28369[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (14))){
var inst_28300 = (state_28325[(8)]);
var inst_28299 = (state_28325[(7)]);
var inst_28283 = (state_28325[(11)]);
var inst_28310 = fluree.db.query.analytical.left_outer_join.call(null,inst_28283,inst_28299);
var inst_28282 = inst_28300;
var inst_28283__$1 = inst_28310;
var state_28325__$1 = (function (){var statearr_28345 = state_28325;
(statearr_28345[(11)] = inst_28283__$1);

(statearr_28345[(12)] = inst_28282);

return statearr_28345;
})();
var statearr_28346_28370 = state_28325__$1;
(statearr_28346_28370[(2)] = null);

(statearr_28346_28370[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (16))){
var inst_28314 = (state_28325[(2)]);
var state_28325__$1 = state_28325;
var statearr_28348_28371 = state_28325__$1;
(statearr_28348_28371[(2)] = inst_28314);

(statearr_28348_28371[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (10))){
var inst_28318 = (state_28325[(2)]);
var state_28325__$1 = state_28325;
var statearr_28349_28372 = state_28325__$1;
(statearr_28349_28372[(2)] = inst_28318);

(statearr_28349_28372[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28326 === (8))){
var inst_28300 = (state_28325[(8)]);
var inst_28283 = (state_28325[(11)]);
var tmp28347 = inst_28283;
var inst_28282 = inst_28300;
var inst_28283__$1 = tmp28347;
var state_28325__$1 = (function (){var statearr_28350 = state_28325;
(statearr_28350[(11)] = inst_28283__$1);

(statearr_28350[(12)] = inst_28282);

return statearr_28350;
})();
var statearr_28351_28373 = state_28325__$1;
(statearr_28351_28373[(2)] = null);

(statearr_28351_28373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11469__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11469__auto____0 = (function (){
var statearr_28352 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28352[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11469__auto__);

(statearr_28352[(1)] = (1));

return statearr_28352;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11469__auto____1 = (function (state_28325){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_28325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e28353){var ex__11472__auto__ = e28353;
var statearr_28354_28374 = state_28325;
(statearr_28354_28374[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_28325[(4)]))){
var statearr_28355_28375 = state_28325;
(statearr_28355_28375[(1)] = cljs.core.first.call(null,(state_28325[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28376 = state_28325;
state_28325 = G__28376;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11469__auto__ = function(state_28325){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11469__auto____1.call(this,state_28325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11469__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11469__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_28356 = f__11543__auto__.call(null);
(statearr_28356[(6)] = c__11542__auto__);

return statearr_28356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__28378){
var vec__28379 = p__28378;
var var_name = cljs.core.nth.call(null,vec__28379,(0),null);
var var_val = cljs.core.nth.call(null,vec__28379,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__28377_SHARP_){
return cljs.core.conj.call(null,p1__28377_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__28383,p__28384,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__28385 = p__28383;
var map__28385__$1 = (((((!((map__28385 == null))))?(((((map__28385.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28385.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28385):map__28385);
var q_map = map__28385__$1;
var prefixes = cljs.core.get.call(null,map__28385__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__28386 = p__28384;
var map__28386__$1 = (((((!((map__28386 == null))))?(((((map__28386.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28386.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28386):map__28386);
var res = map__28386__$1;
var vars = cljs.core.get.call(null,map__28386__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_28595){
var state_val_28596 = (state_28595[(1)]);
if((state_val_28596 === (7))){
var inst_28493 = cljs.core.count.call(null,clause);
var inst_28494 = cljs.core._EQ_.call(null,(3),inst_28493);
var inst_28495 = cljs.core.second.call(null,clause);
var inst_28496 = clojure.string.starts_with_QMARK_.call(null,inst_28495,"fullText:");
var inst_28497 = ((inst_28494) && (inst_28496));
var state_28595__$1 = state_28595;
if(cljs.core.truth_(inst_28497)){
var statearr_28597_28684 = state_28595__$1;
(statearr_28597_28684[(1)] = (31));

} else {
var statearr_28598_28685 = state_28595__$1;
(statearr_28598_28685[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (59))){
var inst_28564 = (state_28595[(7)]);
var inst_28567 = (state_28595[(2)]);
var inst_28568 = fluree.db.util.async.throw_err.call(null,inst_28567);
var inst_28569 = [inst_28568,r];
var inst_28570 = (new cljs.core.PersistentVector(null,2,(5),inst_28564,inst_28569,null));
var state_28595__$1 = state_28595;
var statearr_28599_28686 = state_28595__$1;
(statearr_28599_28686[(2)] = inst_28570);

(statearr_28599_28686[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (20))){
var inst_28457 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28600_28687 = state_28595__$1;
(statearr_28600_28687[(2)] = inst_28457);

(statearr_28600_28687[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (58))){
var inst_28573 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28601_28688 = state_28595__$1;
(statearr_28601_28688[(2)] = inst_28573);

(statearr_28601_28688[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (27))){
var inst_28487 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28602_28689 = state_28595__$1;
(statearr_28602_28689[(2)] = inst_28487);

(statearr_28602_28689[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (1))){
var state_28595__$1 = state_28595;
var statearr_28603_28690 = state_28595__$1;
(statearr_28603_28690[(2)] = null);

(statearr_28603_28690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (24))){
var inst_28451 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28604_28691 = state_28595__$1;
(statearr_28604_28691[(2)] = inst_28451);

(statearr_28604_28691[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (55))){
var inst_28575 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28605_28692 = state_28595__$1;
(statearr_28605_28692[(2)] = inst_28575);

(statearr_28605_28692[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (39))){
var inst_28529 = cljs.core.count.call(null,clause);
var inst_28530 = cljs.core._EQ_.call(null,(2),inst_28529);
var state_28595__$1 = state_28595;
if(inst_28530){
var statearr_28606_28693 = state_28595__$1;
(statearr_28606_28693[(1)] = (42));

} else {
var statearr_28607_28694 = state_28595__$1;
(statearr_28607_28694[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (46))){
var state_28595__$1 = state_28595;
var statearr_28608_28695 = state_28595__$1;
(statearr_28608_28695[(2)] = null);

(statearr_28608_28695[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (4))){
var inst_28389 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28609_28696 = state_28595__$1;
(statearr_28609_28696[(2)] = inst_28389);

(statearr_28609_28696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (54))){
var state_28595__$1 = state_28595;
var statearr_28610_28697 = state_28595__$1;
(statearr_28610_28697[(1)] = (56));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (15))){
var inst_28489 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28612_28698 = state_28595__$1;
(statearr_28612_28698[(2)] = inst_28489);

(statearr_28612_28698[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (48))){
var inst_28546 = (state_28595[(8)]);
var inst_28544 = (state_28595[(2)]);
var inst_28545 = fluree.db.util.async.throw_err.call(null,inst_28544);
var inst_28546__$1 = cljs.core.nth.call(null,inst_28545,(0),null);
var inst_28547 = cljs.core.nth.call(null,inst_28545,(1),null);
var inst_28548 = cljs.core._EQ_.call(null,"$wd",inst_28546__$1);
var state_28595__$1 = (function (){var statearr_28613 = state_28595;
(statearr_28613[(9)] = inst_28547);

(statearr_28613[(8)] = inst_28546__$1);

return statearr_28613;
})();
if(inst_28548){
var statearr_28614_28699 = state_28595__$1;
(statearr_28614_28699[(1)] = (49));

} else {
var statearr_28615_28700 = state_28595__$1;
(statearr_28615_28700[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (50))){
var inst_28547 = (state_28595[(9)]);
var inst_28555 = cljs.core.second.call(null,inst_28547);
var inst_28556 = clojure.string.starts_with_QMARK_.call(null,inst_28555,"fullText:");
var state_28595__$1 = state_28595;
if(inst_28556){
var statearr_28616_28701 = state_28595__$1;
(statearr_28616_28701[(1)] = (53));

} else {
var statearr_28617_28702 = state_28595__$1;
(statearr_28617_28702[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (21))){
var inst_28402 = (state_28595[(10)]);
var inst_28428 = (state_28595[(11)]);
var inst_28425 = (state_28595[(12)]);
var inst_28426 = (state_28595[(13)]);
var inst_28398 = (state_28595[(14)]);
var inst_28435 = (state_28595[(15)]);
var inst_28434 = (state_28595[(16)]);
var inst_28423 = (state_28595[(17)]);
var inst_28427 = (state_28595[(18)]);
var inst_28439 = (state_28595[(2)]);
var inst_28440 = fluree.db.util.async.throw_err.call(null,inst_28439);
var inst_28441 = (function (){var new_res = inst_28440;
var rest = inst_28435;
var tuples = inst_28428;
var vec__28420 = inst_28423;
var seq__28431 = inst_28435;
var pred__28399 = inst_28402;
var seq__28421 = inst_28426;
var G__28419 = inst_28427;
var first__28432 = inst_28434;
var first__28422 = inst_28425;
var vec__28430 = inst_28427;
var segment_type = inst_28398;
var expr__28400 = inst_28398;
var clause_group = inst_28434;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_28442 = cljs.core.keys.call(null,vars);
var inst_28443 = cljs.core.reduce.call(null,inst_28441,inst_28440,inst_28442);
var inst_28444 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_28443);
var state_28595__$1 = (function (){var statearr_28618 = state_28595;
(statearr_28618[(19)] = inst_28444);

return statearr_28618;
})();
if(cljs.core.truth_(inst_28428)){
var statearr_28619_28703 = state_28595__$1;
(statearr_28619_28703[(1)] = (22));

} else {
var statearr_28620_28704 = state_28595__$1;
(statearr_28620_28704[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (31))){
var inst_28499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28500 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_28501 = [inst_28500,r];
var inst_28502 = (new cljs.core.PersistentVector(null,2,(5),inst_28499,inst_28501,null));
var state_28595__$1 = state_28595;
var statearr_28621_28705 = state_28595__$1;
(statearr_28621_28705[(2)] = inst_28502);

(statearr_28621_28705[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (32))){
var inst_28504 = cljs.core.count.call(null,clause);
var inst_28505 = cljs.core._EQ_.call(null,(3),inst_28504);
var inst_28506 = cljs.core.second.call(null,clause);
var inst_28507 = cljs.core._EQ_.call(null,inst_28506,"rdf:type");
var inst_28508 = ((inst_28505) && (inst_28507));
var state_28595__$1 = state_28595;
if(cljs.core.truth_(inst_28508)){
var statearr_28622_28706 = state_28595__$1;
(statearr_28622_28706[(1)] = (34));

} else {
var statearr_28623_28707 = state_28595__$1;
(statearr_28623_28707[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (40))){
var inst_28584 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28624_28708 = state_28595__$1;
(statearr_28624_28708[(2)] = inst_28584);

(statearr_28624_28708[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (56))){
var inst_28547 = (state_28595[(9)]);
var inst_28546 = (state_28595[(8)]);
var inst_28564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28565 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_28546,res,inst_28547,fuel,max_fuel);
var state_28595__$1 = (function (){var statearr_28625 = state_28595;
(statearr_28625[(7)] = inst_28564);

return statearr_28625;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28595__$1,(59),inst_28565);
} else {
if((state_val_28596 === (33))){
var inst_28588 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28626_28709 = state_28595__$1;
(statearr_28626_28709[(2)] = inst_28588);

(statearr_28626_28709[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (13))){
var inst_28423 = (state_28595[(17)]);
var inst_28423__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_28424 = cljs.core.seq.call(null,inst_28423__$1);
var inst_28425 = cljs.core.first.call(null,inst_28424);
var inst_28426 = cljs.core.next.call(null,inst_28424);
var inst_28427 = inst_28423__$1;
var inst_28428 = null;
var state_28595__$1 = (function (){var statearr_28627 = state_28595;
(statearr_28627[(11)] = inst_28428);

(statearr_28627[(12)] = inst_28425);

(statearr_28627[(13)] = inst_28426);

(statearr_28627[(17)] = inst_28423__$1);

(statearr_28627[(18)] = inst_28427);

return statearr_28627;
})();
var statearr_28628_28710 = state_28595__$1;
(statearr_28628_28710[(2)] = null);

(statearr_28628_28710[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (22))){
var inst_28428 = (state_28595[(11)]);
var inst_28435 = (state_28595[(15)]);
var inst_28444 = (state_28595[(19)]);
var inst_28446 = fluree.db.query.analytical.outer_union.call(null,inst_28428,inst_28444);
var inst_28427 = inst_28435;
var inst_28428__$1 = inst_28446;
var state_28595__$1 = (function (){var statearr_28629 = state_28595;
(statearr_28629[(11)] = inst_28428__$1);

(statearr_28629[(18)] = inst_28427);

return statearr_28629;
})();
var statearr_28630_28711 = state_28595__$1;
(statearr_28630_28711[(2)] = null);

(statearr_28630_28711[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (36))){
var inst_28586 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28631_28712 = state_28595__$1;
(statearr_28631_28712[(2)] = inst_28586);

(statearr_28631_28712[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (41))){
var inst_28521 = (state_28595[(20)]);
var inst_28524 = (state_28595[(2)]);
var inst_28525 = fluree.db.util.async.throw_err.call(null,inst_28524);
var inst_28526 = [inst_28525,r];
var inst_28527 = (new cljs.core.PersistentVector(null,2,(5),inst_28521,inst_28526,null));
var state_28595__$1 = state_28595;
var statearr_28632_28713 = state_28595__$1;
(statearr_28632_28713[(2)] = inst_28527);

(statearr_28632_28713[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (43))){
var state_28595__$1 = state_28595;
var statearr_28633_28714 = state_28595__$1;
(statearr_28633_28714[(1)] = (45));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (29))){
var inst_28398 = (state_28595[(14)]);
var inst_28481 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28398)].join('');
var inst_28482 = (new Error(inst_28481));
var inst_28483 = (function(){throw inst_28482})();
var state_28595__$1 = state_28595;
var statearr_28635_28715 = state_28595__$1;
(statearr_28635_28715[(2)] = inst_28483);

(statearr_28635_28715[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (44))){
var inst_28582 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28636_28716 = state_28595__$1;
(statearr_28636_28716[(2)] = inst_28582);

(statearr_28636_28716[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (6))){
var inst_28402 = (state_28595[(10)]);
var inst_28398 = (state_28595[(14)]);
var inst_28397 = cljs.core.keys.call(null,clause);
var inst_28398__$1 = cljs.core.first.call(null,inst_28397);
var inst_28402__$1 = cljs.core._EQ_;
var inst_28403 = inst_28402__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_28398__$1);
var state_28595__$1 = (function (){var statearr_28637 = state_28595;
(statearr_28637[(10)] = inst_28402__$1);

(statearr_28637[(14)] = inst_28398__$1);

return statearr_28637;
})();
if(cljs.core.truth_(inst_28403)){
var statearr_28638_28717 = state_28595__$1;
(statearr_28638_28717[(1)] = (9));

} else {
var statearr_28639_28718 = state_28595__$1;
(statearr_28639_28718[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (28))){
var inst_28475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28476 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_28477 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_28476,optional_QMARK_);
var inst_28478 = [inst_28477,r];
var inst_28479 = (new cljs.core.PersistentVector(null,2,(5),inst_28475,inst_28478,null));
var state_28595__$1 = state_28595;
var statearr_28640_28719 = state_28595__$1;
(statearr_28640_28719[(2)] = inst_28479);

(statearr_28640_28719[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (51))){
var inst_28577 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28641_28720 = state_28595__$1;
(statearr_28641_28720[(2)] = inst_28577);

(statearr_28641_28720[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (25))){
var inst_28402 = (state_28595[(10)]);
var inst_28398 = (state_28595[(14)]);
var inst_28463 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_28464 = (function (){var segment_type = inst_28398;
var pred__28399 = inst_28402;
var expr__28400 = inst_28398;
var bindings = inst_28463;
return (function (p1__28382_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__28382_SHARP_);
});
})();
var inst_28465 = cljs.core.map.call(null,inst_28464,inst_28463);
var inst_28466 = cljs.core.PersistentHashMap.EMPTY;
var inst_28467 = cljs.core.into.call(null,inst_28466,inst_28465);
var inst_28468 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28469 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_28467);
var inst_28470 = [inst_28469,r];
var inst_28471 = (new cljs.core.PersistentVector(null,2,(5),inst_28468,inst_28470,null));
var state_28595__$1 = state_28595;
var statearr_28642_28721 = state_28595__$1;
(statearr_28642_28721[(2)] = inst_28471);

(statearr_28642_28721[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (34))){
var inst_28510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28511 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_28595__$1 = (function (){var statearr_28643 = state_28595;
(statearr_28643[(21)] = inst_28510);

return statearr_28643;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28595__$1,(37),inst_28511);
} else {
if((state_val_28596 === (17))){
var inst_28459 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28644_28722 = state_28595__$1;
(statearr_28644_28722[(2)] = inst_28459);

(statearr_28644_28722[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (3))){
var inst_28593 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28595__$1,inst_28593);
} else {
if((state_val_28596 === (12))){
var inst_28405 = (state_28595[(22)]);
var inst_28409 = (state_28595[(2)]);
var inst_28410 = fluree.db.util.async.throw_err.call(null,inst_28409);
var inst_28411 = [inst_28410,r];
var inst_28412 = (new cljs.core.PersistentVector(null,2,(5),inst_28405,inst_28411,null));
var state_28595__$1 = state_28595;
var statearr_28645_28723 = state_28595__$1;
(statearr_28645_28723[(2)] = inst_28412);

(statearr_28645_28723[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (2))){
var _ = (function (){var statearr_28646 = state_28595;
(statearr_28646[(4)] = cljs.core.cons.call(null,(5),(state_28595[(4)])));

return statearr_28646;
})();
var inst_28395 = cljs.core.map_QMARK_.call(null,clause);
var state_28595__$1 = state_28595;
if(inst_28395){
var statearr_28647_28724 = state_28595__$1;
(statearr_28647_28724[(1)] = (6));

} else {
var statearr_28648_28725 = state_28595__$1;
(statearr_28648_28725[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (23))){
var inst_28435 = (state_28595[(15)]);
var inst_28444 = (state_28595[(19)]);
var inst_28427 = inst_28435;
var inst_28428 = inst_28444;
var state_28595__$1 = (function (){var statearr_28649 = state_28595;
(statearr_28649[(11)] = inst_28428);

(statearr_28649[(18)] = inst_28427);

return statearr_28649;
})();
var statearr_28650_28726 = state_28595__$1;
(statearr_28650_28726[(2)] = null);

(statearr_28650_28726[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (47))){
var inst_28580 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28651_28727 = state_28595__$1;
(statearr_28651_28727[(2)] = inst_28580);

(statearr_28651_28727[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (35))){
var inst_28518 = cljs.core.count.call(null,clause);
var inst_28519 = cljs.core._EQ_.call(null,(3),inst_28518);
var state_28595__$1 = state_28595;
if(inst_28519){
var statearr_28652_28728 = state_28595__$1;
(statearr_28652_28728[(1)] = (38));

} else {
var statearr_28653_28729 = state_28595__$1;
(statearr_28653_28729[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (19))){
var inst_28428 = (state_28595[(11)]);
var inst_28453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28454 = [inst_28428,r];
var inst_28455 = (new cljs.core.PersistentVector(null,2,(5),inst_28453,inst_28454,null));
var state_28595__$1 = state_28595;
var statearr_28654_28730 = state_28595__$1;
(statearr_28654_28730[(2)] = inst_28455);

(statearr_28654_28730[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (57))){
var state_28595__$1 = state_28595;
var statearr_28655_28731 = state_28595__$1;
(statearr_28655_28731[(2)] = null);

(statearr_28655_28731[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (11))){
var inst_28491 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28657_28732 = state_28595__$1;
(statearr_28657_28732[(2)] = inst_28491);

(statearr_28657_28732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (9))){
var inst_28405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28406 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_28407 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_28406,res,fuel,max_fuel,opts);
var state_28595__$1 = (function (){var statearr_28658 = state_28595;
(statearr_28658[(22)] = inst_28405);

return statearr_28658;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28595__$1,(12),inst_28407);
} else {
if((state_val_28596 === (5))){
var _ = (function (){var statearr_28659 = state_28595;
(statearr_28659[(4)] = cljs.core.rest.call(null,(state_28595[(4)])));

return statearr_28659;
})();
var state_28595__$1 = state_28595;
var ex28656 = (state_28595__$1[(2)]);
var statearr_28660_28733 = state_28595__$1;
(statearr_28660_28733[(5)] = ex28656);


if((ex28656 instanceof Error)){
var statearr_28661_28734 = state_28595__$1;
(statearr_28661_28734[(1)] = (4));

(statearr_28661_28734[(5)] = null);

} else {
throw ex28656;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (14))){
var inst_28402 = (state_28595[(10)]);
var inst_28398 = (state_28595[(14)]);
var inst_28461 = inst_28402.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_28398);
var state_28595__$1 = state_28595;
if(cljs.core.truth_(inst_28461)){
var statearr_28662_28735 = state_28595__$1;
(statearr_28662_28735[(1)] = (25));

} else {
var statearr_28663_28736 = state_28595__$1;
(statearr_28663_28736[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (45))){
var inst_28542 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_28595__$1 = state_28595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28595__$1,(48),inst_28542);
} else {
if((state_val_28596 === (53))){
var inst_28547 = (state_28595[(9)]);
var inst_28546 = (state_28595[(8)]);
var inst_28558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28559 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_28546,res,inst_28547);
var inst_28560 = [inst_28559,r];
var inst_28561 = (new cljs.core.PersistentVector(null,2,(5),inst_28558,inst_28560,null));
var state_28595__$1 = state_28595;
var statearr_28664_28737 = state_28595__$1;
(statearr_28664_28737[(2)] = inst_28561);

(statearr_28664_28737[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (26))){
var inst_28402 = (state_28595[(10)]);
var inst_28398 = (state_28595[(14)]);
var inst_28473 = inst_28402.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_28398);
var state_28595__$1 = state_28595;
if(cljs.core.truth_(inst_28473)){
var statearr_28665_28738 = state_28595__$1;
(statearr_28665_28738[(1)] = (28));

} else {
var statearr_28666_28739 = state_28595__$1;
(statearr_28666_28739[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (16))){
var inst_28434 = (state_28595[(16)]);
var inst_28427 = (state_28595[(18)]);
var inst_28433 = cljs.core.seq.call(null,inst_28427);
var inst_28434__$1 = cljs.core.first.call(null,inst_28433);
var inst_28435 = cljs.core.next.call(null,inst_28433);
var state_28595__$1 = (function (){var statearr_28667 = state_28595;
(statearr_28667[(15)] = inst_28435);

(statearr_28667[(16)] = inst_28434__$1);

return statearr_28667;
})();
if(cljs.core.truth_(inst_28434__$1)){
var statearr_28668_28740 = state_28595__$1;
(statearr_28668_28740[(1)] = (18));

} else {
var statearr_28669_28741 = state_28595__$1;
(statearr_28669_28741[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (38))){
var inst_28521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28522 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_28595__$1 = (function (){var statearr_28670 = state_28595;
(statearr_28670[(20)] = inst_28521);

return statearr_28670;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28595__$1,(41),inst_28522);
} else {
if((state_val_28596 === (30))){
var inst_28485 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28671_28742 = state_28595__$1;
(statearr_28671_28742[(2)] = inst_28485);

(statearr_28671_28742[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (10))){
var inst_28402 = (state_28595[(10)]);
var inst_28398 = (state_28595[(14)]);
var inst_28414 = inst_28402.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_28398);
var state_28595__$1 = state_28595;
if(cljs.core.truth_(inst_28414)){
var statearr_28672_28743 = state_28595__$1;
(statearr_28672_28743[(1)] = (13));

} else {
var statearr_28673_28744 = state_28595__$1;
(statearr_28673_28744[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (18))){
var inst_28434 = (state_28595[(16)]);
var inst_28437 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_28434,q_map,vars,fuel,max_fuel,opts);
var state_28595__$1 = state_28595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28595__$1,(21),inst_28437);
} else {
if((state_val_28596 === (52))){
var inst_28552 = (state_28595[(2)]);
var inst_28553 = fluree.db.util.async.throw_err.call(null,inst_28552);
var state_28595__$1 = state_28595;
var statearr_28674_28745 = state_28595__$1;
(statearr_28674_28745[(2)] = inst_28553);

(statearr_28674_28745[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (42))){
var inst_28532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28533 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_28534 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_28533);
var inst_28535 = [inst_28534,r];
var inst_28536 = (new cljs.core.PersistentVector(null,2,(5),inst_28532,inst_28535,null));
var state_28595__$1 = state_28595;
var statearr_28675_28746 = state_28595__$1;
(statearr_28675_28746[(2)] = inst_28536);

(statearr_28675_28746[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (37))){
var inst_28510 = (state_28595[(21)]);
var inst_28513 = (state_28595[(2)]);
var inst_28514 = fluree.db.util.async.throw_err.call(null,inst_28513);
var inst_28515 = [inst_28514,r];
var inst_28516 = (new cljs.core.PersistentVector(null,2,(5),inst_28510,inst_28515,null));
var state_28595__$1 = state_28595;
var statearr_28676_28747 = state_28595__$1;
(statearr_28676_28747[(2)] = inst_28516);

(statearr_28676_28747[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (8))){
var inst_28590 = (state_28595[(2)]);
var _ = (function (){var statearr_28677 = state_28595;
(statearr_28677[(4)] = cljs.core.rest.call(null,(state_28595[(4)])));

return statearr_28677;
})();
var state_28595__$1 = state_28595;
var statearr_28678_28748 = state_28595__$1;
(statearr_28678_28748[(2)] = inst_28590);

(statearr_28678_28748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (49))){
var inst_28547 = (state_28595[(9)]);
var inst_28550 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_28547,r,res,optional_QMARK_,fuel,max_fuel);
var state_28595__$1 = state_28595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28595__$1,(52),inst_28550);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11469__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11469__auto____0 = (function (){
var statearr_28679 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28679[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11469__auto__);

(statearr_28679[(1)] = (1));

return statearr_28679;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11469__auto____1 = (function (state_28595){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_28595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e28680){var ex__11472__auto__ = e28680;
var statearr_28681_28749 = state_28595;
(statearr_28681_28749[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_28595[(4)]))){
var statearr_28682_28750 = state_28595;
(statearr_28682_28750[(1)] = cljs.core.first.call(null,(state_28595[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28751 = state_28595;
state_28595 = G__28751;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11469__auto__ = function(state_28595){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11469__auto____1.call(this,state_28595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11469__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11469__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_28683 = f__11543__auto__.call(null);
(statearr_28683[(6)] = c__11542__auto__);

return statearr_28683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__28753 = arguments.length;
switch (G__28753) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_28833){
var state_val_28834 = (state_28833[(1)]);
if((state_val_28834 === (7))){
var inst_28828 = (state_28833[(2)]);
var _ = (function (){var statearr_28835 = state_28833;
(statearr_28835[(4)] = cljs.core.rest.call(null,(state_28833[(4)])));

return statearr_28835;
})();
var state_28833__$1 = state_28833;
var statearr_28836_28884 = state_28833__$1;
(statearr_28836_28884[(2)] = inst_28828);

(statearr_28836_28884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (20))){
var inst_28793 = (state_28833[(7)]);
var inst_28805 = (state_28833[(2)]);
var inst_28775 = inst_28793;
var inst_28776 = inst_28805;
var state_28833__$1 = (function (){var statearr_28837 = state_28833;
(statearr_28837[(8)] = inst_28775);

(statearr_28837[(9)] = inst_28776);

return statearr_28837;
})();
var statearr_28838_28885 = state_28833__$1;
(statearr_28838_28885[(2)] = null);

(statearr_28838_28885[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (1))){
var state_28833__$1 = state_28833;
var statearr_28839_28886 = state_28833__$1;
(statearr_28839_28886[(2)] = null);

(statearr_28839_28886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (24))){
var inst_28793 = (state_28833[(7)]);
var inst_28776 = (state_28833[(9)]);
var inst_28792 = (state_28833[(10)]);
var inst_28813 = fluree.db.query.analytical.inner_join.call(null,inst_28776,inst_28792);
var inst_28775 = inst_28793;
var inst_28776__$1 = inst_28813;
var state_28833__$1 = (function (){var statearr_28840 = state_28833;
(statearr_28840[(8)] = inst_28775);

(statearr_28840[(9)] = inst_28776__$1);

return statearr_28840;
})();
var statearr_28841_28887 = state_28833__$1;
(statearr_28841_28887[(2)] = null);

(statearr_28841_28887[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (4))){
var inst_28754 = (state_28833[(2)]);
var state_28833__$1 = state_28833;
var statearr_28843_28888 = state_28833__$1;
(statearr_28843_28888[(2)] = inst_28754);

(statearr_28843_28888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (15))){
var inst_28792 = (state_28833[(10)]);
var state_28833__$1 = state_28833;
if(cljs.core.truth_(inst_28792)){
var statearr_28844_28889 = state_28833__$1;
(statearr_28844_28889[(1)] = (18));

} else {
var statearr_28845_28890 = state_28833__$1;
(statearr_28845_28890[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (21))){
var inst_28793 = (state_28833[(7)]);
var inst_28776 = (state_28833[(9)]);
var tmp28842 = inst_28776;
var inst_28775 = inst_28793;
var inst_28776__$1 = tmp28842;
var state_28833__$1 = (function (){var statearr_28846 = state_28833;
(statearr_28846[(8)] = inst_28775);

(statearr_28846[(9)] = inst_28776__$1);

return statearr_28846;
})();
var statearr_28847_28891 = state_28833__$1;
(statearr_28847_28891[(2)] = null);

(statearr_28847_28891[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (13))){
var inst_28776 = (state_28833[(9)]);
var inst_28799 = cljs.core.dissoc.call(null,inst_28776,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_28800 = cljs.core.empty_QMARK_.call(null,inst_28799);
var state_28833__$1 = state_28833;
if(inst_28800){
var statearr_28848_28892 = state_28833__$1;
(statearr_28848_28892[(1)] = (15));

} else {
var statearr_28849_28893 = state_28833__$1;
(statearr_28849_28893[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (22))){
var state_28833__$1 = state_28833;
var statearr_28850_28894 = state_28833__$1;
(statearr_28850_28894[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (6))){
var inst_28775 = (state_28833[(8)]);
var inst_28782 = (state_28833[(11)]);
var inst_28781 = cljs.core.seq.call(null,inst_28775);
var inst_28782__$1 = cljs.core.first.call(null,inst_28781);
var inst_28783 = cljs.core.next.call(null,inst_28781);
var state_28833__$1 = (function (){var statearr_28852 = state_28833;
(statearr_28852[(11)] = inst_28782__$1);

(statearr_28852[(12)] = inst_28783);

return statearr_28852;
})();
if(cljs.core.truth_(inst_28782__$1)){
var statearr_28853_28895 = state_28833__$1;
(statearr_28853_28895[(1)] = (8));

} else {
var statearr_28854_28896 = state_28833__$1;
(statearr_28854_28896[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (25))){
var state_28833__$1 = state_28833;
var statearr_28855_28897 = state_28833__$1;
(statearr_28855_28897[(2)] = null);

(statearr_28855_28897[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (17))){
var inst_28821 = (state_28833[(2)]);
var state_28833__$1 = state_28833;
var statearr_28856_28898 = state_28833__$1;
(statearr_28856_28898[(2)] = inst_28821);

(statearr_28856_28898[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (3))){
var inst_28831 = (state_28833[(2)]);
var state_28833__$1 = state_28833;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28833__$1,inst_28831);
} else {
if((state_val_28834 === (12))){
var inst_28793 = (state_28833[(7)]);
var inst_28792 = (state_28833[(10)]);
var inst_28775 = inst_28793;
var inst_28776 = inst_28792;
var state_28833__$1 = (function (){var statearr_28857 = state_28833;
(statearr_28857[(8)] = inst_28775);

(statearr_28857[(9)] = inst_28776);

return statearr_28857;
})();
var statearr_28858_28899 = state_28833__$1;
(statearr_28858_28899[(2)] = null);

(statearr_28858_28899[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (2))){
var _ = (function (){var statearr_28859 = state_28833;
(statearr_28859[(4)] = cljs.core.cons.call(null,(5),(state_28833[(4)])));

return statearr_28859;
})();
var inst_28767 = where;
var inst_28768 = cljs.core.seq.call(null,inst_28767);
var inst_28769 = cljs.core.first.call(null,inst_28768);
var inst_28770 = cljs.core.next.call(null,inst_28768);
var inst_28771 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_28772 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_28773 = [inst_28772];
var inst_28774 = cljs.core.PersistentHashMap.fromArrays(inst_28771,inst_28773);
var inst_28775 = inst_28767;
var inst_28776 = inst_28774;
var state_28833__$1 = (function (){var statearr_28860 = state_28833;
(statearr_28860[(13)] = inst_28770);

(statearr_28860[(8)] = inst_28775);

(statearr_28860[(14)] = inst_28769);

(statearr_28860[(9)] = inst_28776);

return statearr_28860;
})();
var statearr_28861_28900 = state_28833__$1;
(statearr_28861_28900[(2)] = null);

(statearr_28861_28900[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (23))){
var inst_28819 = (state_28833[(2)]);
var state_28833__$1 = state_28833;
var statearr_28862_28901 = state_28833__$1;
(statearr_28862_28901[(2)] = inst_28819);

(statearr_28862_28901[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (19))){
var inst_28776 = (state_28833[(9)]);
var state_28833__$1 = state_28833;
var statearr_28863_28902 = state_28833__$1;
(statearr_28863_28902[(2)] = inst_28776);

(statearr_28863_28902[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (11))){
var inst_28782 = (state_28833[(11)]);
var inst_28790 = (state_28833[(2)]);
var inst_28791 = fluree.db.util.async.throw_err.call(null,inst_28790);
var inst_28792 = cljs.core.nth.call(null,inst_28791,(0),null);
var inst_28793 = cljs.core.nth.call(null,inst_28791,(1),null);
var inst_28794 = cljs.core.count.call(null,inst_28782);
var inst_28795 = cljs.core._EQ_.call(null,(2),inst_28794);
var state_28833__$1 = (function (){var statearr_28865 = state_28833;
(statearr_28865[(7)] = inst_28793);

(statearr_28865[(10)] = inst_28792);

return statearr_28865;
})();
if(inst_28795){
var statearr_28866_28903 = state_28833__$1;
(statearr_28866_28903[(1)] = (12));

} else {
var statearr_28867_28904 = state_28833__$1;
(statearr_28867_28904[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (9))){
var inst_28776 = (state_28833[(9)]);
var state_28833__$1 = state_28833;
var statearr_28868_28905 = state_28833__$1;
(statearr_28868_28905[(2)] = inst_28776);

(statearr_28868_28905[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (5))){
var _ = (function (){var statearr_28869 = state_28833;
(statearr_28869[(4)] = cljs.core.rest.call(null,(state_28833[(4)])));

return statearr_28869;
})();
var state_28833__$1 = state_28833;
var ex28864 = (state_28833__$1[(2)]);
var statearr_28870_28906 = state_28833__$1;
(statearr_28870_28906[(5)] = ex28864);


if((ex28864 instanceof Error)){
var statearr_28871_28907 = state_28833__$1;
(statearr_28871_28907[(1)] = (4));

(statearr_28871_28907[(5)] = null);

} else {
throw ex28864;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (14))){
var inst_28823 = (state_28833[(2)]);
var state_28833__$1 = state_28833;
var statearr_28872_28908 = state_28833__$1;
(statearr_28872_28908[(2)] = inst_28823);

(statearr_28872_28908[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (26))){
var inst_28817 = (state_28833[(2)]);
var state_28833__$1 = state_28833;
var statearr_28873_28909 = state_28833__$1;
(statearr_28873_28909[(2)] = inst_28817);

(statearr_28873_28909[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (16))){
var inst_28792 = (state_28833[(10)]);
var inst_28808 = (inst_28792 == null);
var state_28833__$1 = state_28833;
if(cljs.core.truth_(inst_28808)){
var statearr_28874_28910 = state_28833__$1;
(statearr_28874_28910[(1)] = (21));

} else {
var statearr_28875_28911 = state_28833__$1;
(statearr_28875_28911[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (10))){
var inst_28826 = (state_28833[(2)]);
var state_28833__$1 = state_28833;
var statearr_28876_28912 = state_28833__$1;
(statearr_28876_28912[(2)] = inst_28826);

(statearr_28876_28912[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (18))){
var inst_28792 = (state_28833[(10)]);
var state_28833__$1 = state_28833;
var statearr_28877_28913 = state_28833__$1;
(statearr_28877_28913[(2)] = inst_28792);

(statearr_28877_28913[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (8))){
var inst_28782 = (state_28833[(11)]);
var inst_28783 = (state_28833[(12)]);
var inst_28776 = (state_28833[(9)]);
var inst_28788 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_28776,inst_28782,inst_28783,false,fuel,max_fuel,opts);
var state_28833__$1 = state_28833;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28833__$1,(11),inst_28788);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__11469__auto__ = null;
var fluree$db$query$analytical$state_machine__11469__auto____0 = (function (){
var statearr_28878 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28878[(0)] = fluree$db$query$analytical$state_machine__11469__auto__);

(statearr_28878[(1)] = (1));

return statearr_28878;
});
var fluree$db$query$analytical$state_machine__11469__auto____1 = (function (state_28833){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_28833);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e28879){var ex__11472__auto__ = e28879;
var statearr_28880_28914 = state_28833;
(statearr_28880_28914[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_28833[(4)]))){
var statearr_28881_28915 = state_28833;
(statearr_28881_28915[(1)] = cljs.core.first.call(null,(state_28833[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28916 = state_28833;
state_28833 = G__28916;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__11469__auto__ = function(state_28833){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__11469__auto____1.call(this,state_28833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__11469__auto____0;
fluree$db$query$analytical$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__11469__auto____1;
return fluree$db$query$analytical$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_28882 = f__11543__auto__.call(null);
(statearr_28882[(6)] = c__11542__auto__);

return statearr_28882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_28971){
var state_val_28972 = (state_28971[(1)]);
if((state_val_28972 === (7))){
var state_28971__$1 = state_28971;
var statearr_28973_29011 = state_28971__$1;
(statearr_28973_29011[(2)] = false);

(statearr_28973_29011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (20))){
var inst_28949 = (state_28971[(7)]);
var inst_28961 = (state_28971[(8)]);
var inst_28963 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_28961,inst_28949,null);
var state_28971__$1 = state_28971;
var statearr_28974_29012 = state_28971__$1;
(statearr_28974_29012[(2)] = inst_28963);

(statearr_28974_29012[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (1))){
var state_28971__$1 = state_28971;
var statearr_28975_29013 = state_28971__$1;
(statearr_28975_29013[(2)] = null);

(statearr_28975_29013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (4))){
var inst_28917 = (state_28971[(2)]);
var state_28971__$1 = state_28971;
var statearr_28976_29014 = state_28971__$1;
(statearr_28976_29014[(2)] = inst_28917);

(statearr_28976_29014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (15))){
var inst_28948 = (state_28971[(9)]);
var inst_28952 = (state_28971[(2)]);
var inst_28953 = fluree.db.util.async.throw_err.call(null,inst_28952);
var state_28971__$1 = (function (){var statearr_28977 = state_28971;
(statearr_28977[(10)] = inst_28953);

return statearr_28977;
})();
if(cljs.core.truth_(inst_28948)){
var statearr_28978_29015 = state_28971__$1;
(statearr_28978_29015[(1)] = (16));

} else {
var statearr_28979_29016 = state_28971__$1;
(statearr_28979_29016[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (21))){
var inst_28961 = (state_28971[(8)]);
var state_28971__$1 = state_28971;
var statearr_28980_29017 = state_28971__$1;
(statearr_28980_29017[(2)] = inst_28961);

(statearr_28980_29017[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (13))){
var inst_28924 = (state_28971[(11)]);
var state_28971__$1 = state_28971;
var statearr_28981_29018 = state_28971__$1;
(statearr_28981_29018[(2)] = inst_28924);

(statearr_28981_29018[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (22))){
var inst_28966 = (state_28971[(2)]);
var _ = (function (){var statearr_28982 = state_28971;
(statearr_28982[(4)] = cljs.core.rest.call(null,(state_28971[(4)])));

return statearr_28982;
})();
var state_28971__$1 = state_28971;
var statearr_28983_29019 = state_28971__$1;
(statearr_28983_29019[(2)] = inst_28966);

(statearr_28983_29019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (6))){
var inst_28924 = (state_28971[(11)]);
var inst_28929 = inst_28924.cljs$lang$protocol_mask$partition0$;
var inst_28930 = (inst_28929 & (64));
var inst_28931 = inst_28924.cljs$core$ISeq$;
var inst_28932 = (cljs.core.PROTOCOL_SENTINEL === inst_28931);
var inst_28933 = ((inst_28930) || (inst_28932));
var state_28971__$1 = state_28971;
if(cljs.core.truth_(inst_28933)){
var statearr_28984_29020 = state_28971__$1;
(statearr_28984_29020[(1)] = (9));

} else {
var statearr_28985_29021 = state_28971__$1;
(statearr_28985_29021[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (17))){
var inst_28953 = (state_28971[(10)]);
var state_28971__$1 = state_28971;
var statearr_28986_29022 = state_28971__$1;
(statearr_28986_29022[(2)] = inst_28953);

(statearr_28986_29022[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (3))){
var inst_28969 = (state_28971[(2)]);
var state_28971__$1 = state_28971;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28971__$1,inst_28969);
} else {
if((state_val_28972 === (12))){
var inst_28924 = (state_28971[(11)]);
var inst_28942 = cljs.core.apply.call(null,cljs.core.hash_map,inst_28924);
var state_28971__$1 = state_28971;
var statearr_28987_29023 = state_28971__$1;
(statearr_28987_29023[(2)] = inst_28942);

(statearr_28987_29023[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (2))){
var inst_28924 = (state_28971[(11)]);
var _ = (function (){var statearr_28988 = state_28971;
(statearr_28988[(4)] = cljs.core.cons.call(null,(5),(state_28971[(4)])));

return statearr_28988;
})();
var inst_28924__$1 = q_map;
var inst_28926 = (inst_28924__$1 == null);
var inst_28927 = cljs.core.not.call(null,inst_28926);
var state_28971__$1 = (function (){var statearr_28989 = state_28971;
(statearr_28989[(11)] = inst_28924__$1);

return statearr_28989;
})();
if(inst_28927){
var statearr_28990_29024 = state_28971__$1;
(statearr_28990_29024[(1)] = (6));

} else {
var statearr_28991_29025 = state_28971__$1;
(statearr_28991_29025[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (19))){
var inst_28957 = (state_28971[(2)]);
var inst_28958 = fluree.db.util.async.throw_err.call(null,inst_28957);
var state_28971__$1 = state_28971;
var statearr_28992_29026 = state_28971__$1;
(statearr_28992_29026[(2)] = inst_28958);

(statearr_28992_29026[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (11))){
var inst_28937 = (state_28971[(2)]);
var state_28971__$1 = state_28971;
var statearr_28994_29027 = state_28971__$1;
(statearr_28994_29027[(2)] = inst_28937);

(statearr_28994_29027[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (9))){
var state_28971__$1 = state_28971;
var statearr_28995_29028 = state_28971__$1;
(statearr_28995_29028[(2)] = true);

(statearr_28995_29028[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (5))){
var _ = (function (){var statearr_28996 = state_28971;
(statearr_28996[(4)] = cljs.core.rest.call(null,(state_28971[(4)])));

return statearr_28996;
})();
var state_28971__$1 = state_28971;
var ex28993 = (state_28971__$1[(2)]);
var statearr_28997_29029 = state_28971__$1;
(statearr_28997_29029[(5)] = ex28993);


if((ex28993 instanceof Error)){
var statearr_28998_29030 = state_28971__$1;
(statearr_28998_29030[(1)] = (4));

(statearr_28998_29030[(5)] = null);

} else {
throw ex28993;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (14))){
var inst_28945 = (state_28971[(2)]);
var inst_28946 = cljs.core.get.call(null,inst_28945,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_28947 = cljs.core.get.call(null,inst_28945,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_28948 = cljs.core.get.call(null,inst_28945,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_28949 = cljs.core.get.call(null,inst_28945,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_28950 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_28947,q_map,inst_28946,fuel,max_fuel,opts);
var state_28971__$1 = (function (){var statearr_28999 = state_28971;
(statearr_28999[(7)] = inst_28949);

(statearr_28999[(9)] = inst_28948);

return statearr_28999;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28971__$1,(15),inst_28950);
} else {
if((state_val_28972 === (16))){
var inst_28948 = (state_28971[(9)]);
var inst_28953 = (state_28971[(10)]);
var inst_28955 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_28948,inst_28953,fuel,max_fuel,opts);
var state_28971__$1 = state_28971;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28971__$1,(19),inst_28955);
} else {
if((state_val_28972 === (10))){
var state_28971__$1 = state_28971;
var statearr_29000_29031 = state_28971__$1;
(statearr_29000_29031[(2)] = false);

(statearr_29000_29031[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (18))){
var inst_28949 = (state_28971[(7)]);
var inst_28961 = (state_28971[(2)]);
var state_28971__$1 = (function (){var statearr_29001 = state_28971;
(statearr_29001[(8)] = inst_28961);

return statearr_29001;
})();
if(cljs.core.truth_(inst_28949)){
var statearr_29002_29032 = state_28971__$1;
(statearr_29002_29032[(1)] = (20));

} else {
var statearr_29003_29033 = state_28971__$1;
(statearr_29003_29033[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (8))){
var inst_28940 = (state_28971[(2)]);
var state_28971__$1 = state_28971;
if(cljs.core.truth_(inst_28940)){
var statearr_29004_29034 = state_28971__$1;
(statearr_29004_29034[(1)] = (12));

} else {
var statearr_29005_29035 = state_28971__$1;
(statearr_29005_29035[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__11469__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__11469__auto____0 = (function (){
var statearr_29006 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29006[(0)] = fluree$db$query$analytical$q_$_state_machine__11469__auto__);

(statearr_29006[(1)] = (1));

return statearr_29006;
});
var fluree$db$query$analytical$q_$_state_machine__11469__auto____1 = (function (state_28971){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_28971);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e29007){var ex__11472__auto__ = e29007;
var statearr_29008_29036 = state_28971;
(statearr_29008_29036[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_28971[(4)]))){
var statearr_29009_29037 = state_28971;
(statearr_29009_29037[(1)] = cljs.core.first.call(null,(state_28971[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29038 = state_28971;
state_28971 = G__29038;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__11469__auto__ = function(state_28971){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__11469__auto____1.call(this,state_28971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__11469__auto____0;
fluree$db$query$analytical$q_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__11469__auto____1;
return fluree$db$query$analytical$q_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_29010 = f__11543__auto__.call(null);
(statearr_29010[(6)] = c__11542__auto__);

return statearr_29010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
