// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__30409 = null;
var G__30409__0 = (function (){
return xf.call(null);
});
var G__30409__1 = (function (result){
return xf.call(null,result);
});
var G__30409__2 = (function (result,flake){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__30409 = function(result,flake){
switch(arguments.length){
case 0:
return G__30409__0.call(this);
case 1:
return G__30409__1.call(this,result);
case 2:
return G__30409__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__30409.cljs$core$IFn$_invoke$arity$0 = G__30409__0;
G__30409.cljs$core$IFn$_invoke$arity$1 = G__30409__1;
G__30409.cljs$core$IFn$_invoke$arity$2 = G__30409__2;
return G__30409;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__30410 = null;
var G__30410__0 = (function (){
return xf.call(null);
});
var G__30410__1 = (function (result){
return xf.call(null,result);
});
var G__30410__2 = (function (result,flakes){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + cljs.core.count.call(null,flakes)));

return xf.call(null,result,flakes);
});
G__30410 = function(result,flakes){
switch(arguments.length){
case 0:
return G__30410__0.call(this);
case 1:
return G__30410__1.call(this,result);
case 2:
return G__30410__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__30410.cljs$core$IFn$_invoke$arity$0 = G__30410__0;
G__30410.cljs$core$IFn$_invoke$arity$1 = G__30410__1;
G__30410.cljs$core$IFn$_invoke$arity$2 = G__30410__2;
return G__30410;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
cljs.core._vreset_BANG_.call(null,cache,cljs.core.assoc_in.call(null,cljs.core._deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__30412 = res;
var G__30412__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__30411_SHARP_){
return cljs.core.get.call(null,p1__30411_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__30412):G__30412);
var G__30412__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__30412__$1):G__30412__$1);
var G__30412__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__30412__$2):G__30412__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__30412__$3);
} else {
return G__30412__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__30414 = arguments.length;
switch (G__30414) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_30717){
var state_val_30718 = (state_30717[(1)]);
if((state_val_30718 === (65))){
var inst_30444 = (state_30717[(7)]);
var inst_30575 = (state_30717[(8)]);
var inst_30568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30569 = cljs.core.deref.call(null,cache);
var inst_30570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30571 = flake.o;
var inst_30572 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_30444);
var inst_30573 = [inst_30571,inst_30572];
var inst_30574 = (new cljs.core.PersistentVector(null,2,(5),inst_30570,inst_30573,null));
var inst_30575__$1 = cljs.core.get.call(null,inst_30569,inst_30574);
var state_30717__$1 = (function (){var statearr_30719 = state_30717;
(statearr_30719[(8)] = inst_30575__$1);

(statearr_30719[(9)] = inst_30568);

return statearr_30719;
})();
if(cljs.core.truth_(inst_30575__$1)){
var statearr_30720_30880 = state_30717__$1;
(statearr_30720_30880[(1)] = (68));

} else {
var statearr_30721_30881 = state_30717__$1;
(statearr_30721_30881[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (70))){
var inst_30568 = (state_30717[(9)]);
var inst_30593 = (state_30717[(2)]);
var inst_30594 = [inst_30593,offset_map];
var inst_30595 = (new cljs.core.PersistentVector(null,2,(5),inst_30568,inst_30594,null));
var state_30717__$1 = state_30717;
var statearr_30722_30882 = state_30717__$1;
(statearr_30722_30882[(2)] = inst_30595);

(statearr_30722_30882[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (62))){
var inst_30479 = (state_30717[(10)]);
var inst_30478 = (state_30717[(11)]);
var inst_30537 = (state_30717[(12)]);
var inst_30480 = (state_30717[(13)]);
var inst_30476 = (state_30717[(14)]);
var inst_30481 = (state_30717[(15)]);
var inst_30477 = (state_30717[(16)]);
var inst_30455 = (state_30717[(17)]);
var inst_30444 = (state_30717[(7)]);
var inst_30438 = (state_30717[(18)]);
var inst_30553 = (state_30717[(19)]);
var inst_30482 = (state_30717[(20)]);
var inst_30555 = (function (){var p = inst_30482;
var pred_spec__$1 = inst_30438;
var orderBy = inst_30480;
var nested_select_spec = inst_30537;
var multi_QMARK_ = inst_30477;
var G__30539 = inst_30553;
var limit = inst_30479;
var map__30421 = inst_30476;
var offset = inst_30481;
var k = inst_30455;
var pred_spec_SINGLEQUOTE_ = inst_30444;
var ref_QMARK_ = inst_30478;
return (function (n){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n);
});
})();
var inst_30556 = inst_30555.call(null,inst_30553);
var state_30717__$1 = state_30717;
var statearr_30723_30883 = state_30717__$1;
(statearr_30723_30883[(2)] = inst_30556);

(statearr_30723_30883[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (74))){
var inst_30602 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30602)){
var statearr_30724_30884 = state_30717__$1;
(statearr_30724_30884[(1)] = (75));

} else {
var statearr_30725_30885 = state_30717__$1;
(statearr_30725_30885[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (7))){
var inst_30425 = (state_30717[(21)]);
var state_30717__$1 = state_30717;
var statearr_30726_30886 = state_30717__$1;
(statearr_30726_30886[(2)] = inst_30425);

(statearr_30726_30886[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (59))){
var inst_30547 = (state_30717[(22)]);
var inst_30549 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_30550 = cljs.core.sequence.call(null,inst_30549,inst_30547);
var state_30717__$1 = state_30717;
var statearr_30727_30887 = state_30717__$1;
(statearr_30727_30887[(2)] = inst_30550);

(statearr_30727_30887[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (86))){
var inst_30479 = (state_30717[(10)]);
var inst_30478 = (state_30717[(11)]);
var inst_30480 = (state_30717[(13)]);
var inst_30633 = (state_30717[(23)]);
var inst_30476 = (state_30717[(14)]);
var inst_30481 = (state_30717[(15)]);
var inst_30477 = (state_30717[(16)]);
var inst_30455 = (state_30717[(17)]);
var inst_30444 = (state_30717[(7)]);
var inst_30615 = (state_30717[(24)]);
var inst_30438 = (state_30717[(18)]);
var inst_30482 = (state_30717[(20)]);
var inst_30635 = (function (){var p = inst_30482;
var pred_spec__$1 = inst_30438;
var orderBy = inst_30480;
var children = inst_30615;
var multi_QMARK_ = inst_30477;
var limit = inst_30479;
var map__30421 = inst_30476;
var offset = inst_30481;
var G__30627 = inst_30633;
var k = inst_30455;
var pred_spec_SINGLEQUOTE_ = inst_30444;
var ref_QMARK_ = inst_30478;
return (function (n){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),true], null),n);
});
})();
var inst_30636 = inst_30635.call(null,inst_30633);
var state_30717__$1 = state_30717;
var statearr_30728_30888 = state_30717__$1;
(statearr_30728_30888[(2)] = inst_30636);

(statearr_30728_30888[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (20))){
var inst_30453 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30729_30889 = state_30717__$1;
(statearr_30729_30889[(2)] = inst_30453);

(statearr_30729_30889[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (72))){
var inst_30444 = (state_30717[(7)]);
var inst_30599 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_30444);
var state_30717__$1 = state_30717;
var statearr_30730_30890 = state_30717__$1;
(statearr_30730_30890[(2)] = inst_30599);

(statearr_30730_30890[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (58))){
var inst_30546 = (state_30717[(2)]);
var inst_30547 = fluree.db.util.async.throw_err.call(null,inst_30546);
var state_30717__$1 = (function (){var statearr_30731 = state_30717;
(statearr_30731[(22)] = inst_30547);

return statearr_30731;
})();
if(cljs.core.truth_(fuel)){
var statearr_30732_30891 = state_30717__$1;
(statearr_30732_30891[(1)] = (59));

} else {
var statearr_30733_30892 = state_30717__$1;
(statearr_30733_30892[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (60))){
var inst_30547 = (state_30717[(22)]);
var state_30717__$1 = state_30717;
var statearr_30734_30893 = state_30717__$1;
(statearr_30734_30893[(2)] = inst_30547);

(statearr_30734_30893[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (27))){
var inst_30444 = (state_30717[(7)]);
var inst_30473 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30444);
var state_30717__$1 = state_30717;
var statearr_30735_30894 = state_30717__$1;
(statearr_30735_30894[(2)] = inst_30473);

(statearr_30735_30894[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (1))){
var state_30717__$1 = state_30717;
var statearr_30736_30895 = state_30717__$1;
(statearr_30736_30895[(2)] = null);

(statearr_30736_30895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (69))){
var inst_30444 = (state_30717[(7)]);
var inst_30578 = flake.o;
var inst_30579 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_30444);
var inst_30580 = fluree.db.dbproto._tag.call(null,db,inst_30578,inst_30579);
var state_30717__$1 = state_30717;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30717__$1,(71),inst_30580);
} else {
if((state_val_30718 === (101))){
var inst_30677 = (state_30717[(25)]);
var inst_30678 = (state_30717[(26)]);
var inst_30455 = (state_30717[(17)]);
var inst_30697 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30698 = cljs.core.assoc.call(null,acc,inst_30455,inst_30677);
var inst_30699 = [inst_30698,inst_30678];
var inst_30700 = (new cljs.core.PersistentVector(null,2,(5),inst_30697,inst_30699,null));
var state_30717__$1 = state_30717;
var statearr_30737_30896 = state_30717__$1;
(statearr_30737_30896[(2)] = inst_30700);

(statearr_30737_30896[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (24))){
var state_30717__$1 = state_30717;
var statearr_30738_30897 = state_30717__$1;
(statearr_30738_30897[(2)] = true);

(statearr_30738_30897[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (102))){
var state_30717__$1 = state_30717;
var statearr_30739_30898 = state_30717__$1;
(statearr_30739_30898[(1)] = (104));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (55))){
var inst_30444 = (state_30717[(7)]);
var inst_30566 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_30444);
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30566)){
var statearr_30741_30899 = state_30717__$1;
(statearr_30741_30899[(1)] = (65));

} else {
var statearr_30742_30900 = state_30717__$1;
(statearr_30742_30900[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (85))){
var inst_30633 = (state_30717[(2)]);
var state_30717__$1 = (function (){var statearr_30743 = state_30717;
(statearr_30743[(23)] = inst_30633);

return statearr_30743;
})();
var statearr_30744_30901 = state_30717__$1;
(statearr_30744_30901[(1)] = (86));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (39))){
var inst_30482 = (state_30717[(20)]);
var inst_30499 = cljs.core.update.call(null,offset_map,inst_30482,cljs.core.dec);
var state_30717__$1 = state_30717;
var statearr_30746_30902 = state_30717__$1;
(statearr_30746_30902[(2)] = inst_30499);

(statearr_30746_30902[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (88))){
var inst_30639 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30717__$1,(82),inst_30639);
} else {
if((state_val_30718 === (46))){
var inst_30522 = cljs.core.not.call(null,recur_QMARK_);
var state_30717__$1 = state_30717;
if(inst_30522){
var statearr_30747_30903 = state_30717__$1;
(statearr_30747_30903[(1)] = (48));

} else {
var statearr_30748_30904 = state_30717__$1;
(statearr_30748_30904[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (4))){
var inst_30415 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30749_30905 = state_30717__$1;
(statearr_30749_30905[(2)] = inst_30415);

(statearr_30749_30905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (77))){
var inst_30668 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30750_30906 = state_30717__$1;
(statearr_30750_30906[(2)] = inst_30668);

(statearr_30750_30906[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (106))){
var inst_30708 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30751_30907 = state_30717__$1;
(statearr_30751_30907[(2)] = inst_30708);

(statearr_30751_30907[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (95))){
var inst_30477 = (state_30717[(16)]);
var state_30717__$1 = state_30717;
var statearr_30752_30908 = state_30717__$1;
(statearr_30752_30908[(2)] = inst_30477);

(statearr_30752_30908[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (54))){
var inst_30444 = (state_30717[(7)]);
var inst_30534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30535 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_30536 = (new cljs.core.PersistentVector(null,3,(5),inst_30534,inst_30535,null));
var inst_30537 = cljs.core.select_keys.call(null,inst_30444,inst_30536);
var inst_30538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30541 = flake.o;
var inst_30542 = [inst_30541];
var inst_30543 = (new cljs.core.PersistentVector(null,1,(5),inst_30540,inst_30542,null));
var inst_30544 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_30543);
var state_30717__$1 = (function (){var statearr_30753 = state_30717;
(statearr_30753[(12)] = inst_30537);

(statearr_30753[(27)] = inst_30538);

return statearr_30753;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30717__$1,(58),inst_30544);
} else {
if((state_val_30718 === (92))){
var inst_30658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30659 = flake.o;
var inst_30660 = [inst_30659,offset_map];
var inst_30661 = (new cljs.core.PersistentVector(null,2,(5),inst_30658,inst_30660,null));
var state_30717__$1 = state_30717;
var statearr_30754_30909 = state_30717__$1;
(statearr_30754_30909[(2)] = inst_30661);

(statearr_30754_30909[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (104))){
var inst_30678 = (state_30717[(26)]);
var inst_30703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30704 = [acc,inst_30678];
var inst_30705 = (new cljs.core.PersistentVector(null,2,(5),inst_30703,inst_30704,null));
var state_30717__$1 = state_30717;
var statearr_30755_30910 = state_30717__$1;
(statearr_30755_30910[(2)] = inst_30705);

(statearr_30755_30910[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (15))){
var inst_30445 = (state_30717[(28)]);
var state_30717__$1 = state_30717;
var statearr_30756_30911 = state_30717__$1;
(statearr_30756_30911[(2)] = inst_30445);

(statearr_30756_30911[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (48))){
var inst_30444 = (state_30717[(7)]);
var inst_30524 = (state_30717[(29)]);
var inst_30524__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_30444);
var state_30717__$1 = (function (){var statearr_30757 = state_30717;
(statearr_30757[(29)] = inst_30524__$1);

return statearr_30757;
})();
if(cljs.core.truth_(inst_30524__$1)){
var statearr_30758_30912 = state_30717__$1;
(statearr_30758_30912[(1)] = (51));

} else {
var statearr_30759_30913 = state_30717__$1;
(statearr_30759_30913[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (50))){
var inst_30532 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30532)){
var statearr_30760_30914 = state_30717__$1;
(statearr_30760_30914[(1)] = (54));

} else {
var statearr_30761_30915 = state_30717__$1;
(statearr_30761_30915[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (75))){
var inst_30444 = (state_30717[(7)]);
var inst_30604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30605 = flake.o;
var inst_30606 = [inst_30605];
var inst_30607 = (new cljs.core.PersistentVector(null,1,(5),inst_30604,inst_30606,null));
var inst_30608 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_30609 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_30444);
var inst_30610 = [inst_30609];
var inst_30611 = cljs.core.PersistentHashMap.fromArrays(inst_30608,inst_30610);
var inst_30612 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_30607,inst_30611);
var state_30717__$1 = state_30717;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30717__$1,(78),inst_30612);
} else {
if((state_val_30718 === (99))){
var inst_30677 = (state_30717[(25)]);
var inst_30694 = (inst_30677 == null);
var inst_30695 = cljs.core.not.call(null,inst_30694);
var state_30717__$1 = state_30717;
if(inst_30695){
var statearr_30762_30916 = state_30717__$1;
(statearr_30762_30916[(1)] = (101));

} else {
var statearr_30763_30917 = state_30717__$1;
(statearr_30763_30917[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (21))){
var inst_30444 = (state_30717[(7)]);
var inst_30460 = inst_30444.cljs$lang$protocol_mask$partition0$;
var inst_30461 = (inst_30460 & (64));
var inst_30462 = inst_30444.cljs$core$ISeq$;
var inst_30463 = (cljs.core.PROTOCOL_SENTINEL === inst_30462);
var inst_30464 = ((inst_30461) || (inst_30463));
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30464)){
var statearr_30764_30918 = state_30717__$1;
(statearr_30764_30918[(1)] = (24));

} else {
var statearr_30765_30919 = state_30717__$1;
(statearr_30765_30919[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (31))){
var inst_30477 = (state_30717[(16)]);
var state_30717__$1 = state_30717;
var statearr_30766_30920 = state_30717__$1;
(statearr_30766_30920[(2)] = inst_30477);

(statearr_30766_30920[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (32))){
var inst_30494 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30494)){
var statearr_30767_30921 = state_30717__$1;
(statearr_30767_30921[(1)] = (36));

} else {
var statearr_30768_30922 = state_30717__$1;
(statearr_30768_30922[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (40))){
var inst_30481 = (state_30717[(15)]);
var inst_30482 = (state_30717[(20)]);
var inst_30501 = (inst_30481 - (1));
var inst_30502 = cljs.core.assoc.call(null,offset_map,inst_30482,inst_30501);
var state_30717__$1 = state_30717;
var statearr_30769_30923 = state_30717__$1;
(statearr_30769_30923[(2)] = inst_30502);

(statearr_30769_30923[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (91))){
var inst_30666 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30770_30924 = state_30717__$1;
(statearr_30770_30924[(2)] = inst_30666);

(statearr_30770_30924[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (56))){
var inst_30672 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30771_30925 = state_30717__$1;
(statearr_30771_30925[(2)] = inst_30672);

(statearr_30771_30925[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (33))){
var inst_30481 = (state_30717[(15)]);
var inst_30482 = (state_30717[(20)]);
var inst_30485 = cljs.core.not_EQ_.call(null,(0),inst_30481);
var inst_30486 = cljs.core.get.call(null,offset_map,inst_30482);
var inst_30487 = cljs.core.not_EQ_.call(null,(0),inst_30486);
var inst_30488 = ((inst_30485) && (inst_30487));
var state_30717__$1 = state_30717;
var statearr_30772_30926 = state_30717__$1;
(statearr_30772_30926[(2)] = inst_30488);

(statearr_30772_30926[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (13))){
var inst_30438 = (state_30717[(18)]);
var inst_30442 = cljs.core.assoc.call(null,inst_30438,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_30717__$1 = state_30717;
var statearr_30773_30927 = state_30717__$1;
(statearr_30773_30927[(2)] = inst_30442);

(statearr_30773_30927[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (22))){
var state_30717__$1 = state_30717;
var statearr_30774_30928 = state_30717__$1;
(statearr_30774_30928[(2)] = false);

(statearr_30774_30928[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (90))){
var state_30717__$1 = state_30717;
var statearr_30775_30929 = state_30717__$1;
(statearr_30775_30929[(1)] = (92));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (36))){
var inst_30482 = (state_30717[(20)]);
var inst_30496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30497 = cljs.core.get.call(null,offset_map,inst_30482);
var state_30717__$1 = (function (){var statearr_30777 = state_30717;
(statearr_30777[(30)] = inst_30496);

return statearr_30777;
})();
if(cljs.core.truth_(inst_30497)){
var statearr_30778_30930 = state_30717__$1;
(statearr_30778_30930[(1)] = (39));

} else {
var statearr_30779_30931 = state_30717__$1;
(statearr_30779_30931[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (41))){
var inst_30496 = (state_30717[(30)]);
var inst_30504 = (state_30717[(2)]);
var inst_30505 = [null,inst_30504];
var inst_30506 = (new cljs.core.PersistentVector(null,2,(5),inst_30496,inst_30505,null));
var state_30717__$1 = state_30717;
var statearr_30780_30932 = state_30717__$1;
(statearr_30780_30932[(2)] = inst_30506);

(statearr_30780_30932[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (89))){
var inst_30649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30650 = ["_id"];
var inst_30651 = flake.o;
var inst_30652 = [inst_30651];
var inst_30653 = cljs.core.PersistentHashMap.fromArrays(inst_30650,inst_30652);
var inst_30654 = [inst_30653,offset_map];
var inst_30655 = (new cljs.core.PersistentVector(null,2,(5),inst_30649,inst_30654,null));
var state_30717__$1 = state_30717;
var statearr_30781_30933 = state_30717__$1;
(statearr_30781_30933[(2)] = inst_30655);

(statearr_30781_30933[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (100))){
var inst_30712 = (state_30717[(2)]);
var _ = (function (){var statearr_30782 = state_30717;
(statearr_30782[(4)] = cljs.core.rest.call(null,(state_30717[(4)])));

return statearr_30782;
})();
var state_30717__$1 = state_30717;
var statearr_30783_30934 = state_30717__$1;
(statearr_30783_30934[(2)] = inst_30712);

(statearr_30783_30934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (43))){
var inst_30477 = (state_30717[(16)]);
var state_30717__$1 = state_30717;
var statearr_30784_30935 = state_30717__$1;
(statearr_30784_30935[(2)] = inst_30477);

(statearr_30784_30935[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (61))){
var inst_30553 = (state_30717[(2)]);
var state_30717__$1 = (function (){var statearr_30785 = state_30717;
(statearr_30785[(19)] = inst_30553);

return statearr_30785;
})();
var statearr_30786_30936 = state_30717__$1;
(statearr_30786_30936[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (29))){
var inst_30476 = (state_30717[(14)]);
var inst_30477 = (state_30717[(16)]);
var inst_30476__$1 = (state_30717[(2)]);
var inst_30477__$1 = cljs.core.get.call(null,inst_30476__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_30478 = cljs.core.get.call(null,inst_30476__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_30479 = cljs.core.get.call(null,inst_30476__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_30480 = cljs.core.get.call(null,inst_30476__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_30481 = cljs.core.get.call(null,inst_30476__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_30482 = cljs.core.get.call(null,inst_30476__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_30717__$1 = (function (){var statearr_30788 = state_30717;
(statearr_30788[(10)] = inst_30479);

(statearr_30788[(11)] = inst_30478);

(statearr_30788[(13)] = inst_30480);

(statearr_30788[(14)] = inst_30476__$1);

(statearr_30788[(15)] = inst_30481);

(statearr_30788[(16)] = inst_30477__$1);

(statearr_30788[(20)] = inst_30482);

return statearr_30788;
})();
if(cljs.core.truth_(inst_30477__$1)){
var statearr_30789_30937 = state_30717__$1;
(statearr_30789_30937[(1)] = (30));

} else {
var statearr_30790_30938 = state_30717__$1;
(statearr_30790_30938[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (44))){
var inst_30516 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30516)){
var statearr_30791_30939 = state_30717__$1;
(statearr_30791_30939[(1)] = (45));

} else {
var statearr_30792_30940 = state_30717__$1;
(statearr_30792_30940[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (93))){
var state_30717__$1 = state_30717;
var statearr_30793_30941 = state_30717__$1;
(statearr_30793_30941[(2)] = null);

(statearr_30793_30941[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (6))){
var inst_30427 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_30428 = (inst_30427 == null);
var state_30717__$1 = state_30717;
var statearr_30794_30942 = state_30717__$1;
(statearr_30794_30942[(2)] = inst_30428);

(statearr_30794_30942[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (28))){
var inst_30444 = (state_30717[(7)]);
var state_30717__$1 = state_30717;
var statearr_30795_30943 = state_30717__$1;
(statearr_30795_30943[(2)] = inst_30444);

(statearr_30795_30943[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (64))){
var inst_30559 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30717__$1,(57),inst_30559);
} else {
if((state_val_30718 === (103))){
var inst_30710 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30796_30944 = state_30717__$1;
(statearr_30796_30944[(2)] = inst_30710);

(statearr_30796_30944[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (51))){
var inst_30524 = (state_30717[(29)]);
var state_30717__$1 = state_30717;
var statearr_30797_30945 = state_30717__$1;
(statearr_30797_30945[(2)] = inst_30524);

(statearr_30797_30945[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (25))){
var state_30717__$1 = state_30717;
var statearr_30798_30946 = state_30717__$1;
(statearr_30798_30946[(2)] = false);

(statearr_30798_30946[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (34))){
var inst_30481 = (state_30717[(15)]);
var state_30717__$1 = state_30717;
var statearr_30799_30947 = state_30717__$1;
(statearr_30799_30947[(2)] = inst_30481);

(statearr_30799_30947[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (17))){
var inst_30444 = (state_30717[(7)]);
var inst_30455 = (state_30717[(2)]);
var inst_30457 = (inst_30444 == null);
var inst_30458 = cljs.core.not.call(null,inst_30457);
var state_30717__$1 = (function (){var statearr_30800 = state_30717;
(statearr_30800[(17)] = inst_30455);

return statearr_30800;
})();
if(inst_30458){
var statearr_30801_30948 = state_30717__$1;
(statearr_30801_30948[(1)] = (21));

} else {
var statearr_30802_30949 = state_30717__$1;
(statearr_30802_30949[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (3))){
var inst_30715 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30717__$1,inst_30715);
} else {
if((state_val_30718 === (12))){
var inst_30438 = (state_30717[(18)]);
var state_30717__$1 = state_30717;
var statearr_30803_30950 = state_30717__$1;
(statearr_30803_30950[(2)] = inst_30438);

(statearr_30803_30950[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (2))){
var inst_30425 = (state_30717[(21)]);
var _ = (function (){var statearr_30804 = state_30717;
(statearr_30804[(4)] = cljs.core.cons.call(null,(5),(state_30717[(4)])));

return statearr_30804;
})();
var inst_30425__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_30717__$1 = (function (){var statearr_30805 = state_30717;
(statearr_30805[(21)] = inst_30425__$1);

return statearr_30805;
})();
if(cljs.core.truth_(inst_30425__$1)){
var statearr_30806_30951 = state_30717__$1;
(statearr_30806_30951[(1)] = (6));

} else {
var statearr_30807_30952 = state_30717__$1;
(statearr_30807_30952[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (66))){
var inst_30597 = (state_30717[(31)]);
var inst_30597__$1 = componentFollow_QMARK_;
var state_30717__$1 = (function (){var statearr_30808 = state_30717;
(statearr_30808[(31)] = inst_30597__$1);

return statearr_30808;
})();
if(cljs.core.truth_(inst_30597__$1)){
var statearr_30809_30953 = state_30717__$1;
(statearr_30809_30953[(1)] = (72));

} else {
var statearr_30810_30954 = state_30717__$1;
(statearr_30810_30954[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (23))){
var inst_30471 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30471)){
var statearr_30811_30955 = state_30717__$1;
(statearr_30811_30955[(1)] = (27));

} else {
var statearr_30812_30956 = state_30717__$1;
(statearr_30812_30956[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (47))){
var inst_30674 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30813_30957 = state_30717__$1;
(statearr_30813_30957[(2)] = inst_30674);

(statearr_30813_30957[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (35))){
var inst_30491 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30814_30958 = state_30717__$1;
(statearr_30814_30958[(2)] = inst_30491);

(statearr_30814_30958[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (82))){
var inst_30626 = (state_30717[(32)]);
var inst_30641 = (state_30717[(2)]);
var inst_30642 = fluree.db.util.async.throw_err.call(null,inst_30641);
var inst_30643 = [inst_30642,offset_map];
var inst_30644 = (new cljs.core.PersistentVector(null,2,(5),inst_30626,inst_30643,null));
var state_30717__$1 = state_30717;
var statearr_30815_30959 = state_30717__$1;
(statearr_30815_30959[(2)] = inst_30644);

(statearr_30815_30959[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (76))){
var inst_30478 = (state_30717[(11)]);
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30478)){
var statearr_30816_30960 = state_30717__$1;
(statearr_30816_30960[(1)] = (89));

} else {
var statearr_30817_30961 = state_30717__$1;
(statearr_30817_30961[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (97))){
var inst_30684 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30684)){
var statearr_30818_30962 = state_30717__$1;
(statearr_30818_30962[(1)] = (98));

} else {
var statearr_30819_30963 = state_30717__$1;
(statearr_30819_30963[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (19))){
var inst_30444 = (state_30717[(7)]);
var inst_30451 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_30444);
var state_30717__$1 = state_30717;
var statearr_30820_30964 = state_30717__$1;
(statearr_30820_30964[(2)] = inst_30451);

(statearr_30820_30964[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (57))){
var inst_30538 = (state_30717[(27)]);
var inst_30561 = (state_30717[(2)]);
var inst_30562 = fluree.db.util.async.throw_err.call(null,inst_30561);
var inst_30563 = [inst_30562,offset_map];
var inst_30564 = (new cljs.core.PersistentVector(null,2,(5),inst_30538,inst_30563,null));
var state_30717__$1 = state_30717;
var statearr_30821_30965 = state_30717__$1;
(statearr_30821_30965[(2)] = inst_30564);

(statearr_30821_30965[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (68))){
var inst_30575 = (state_30717[(8)]);
var state_30717__$1 = state_30717;
var statearr_30822_30966 = state_30717__$1;
(statearr_30822_30966[(2)] = inst_30575);

(statearr_30822_30966[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (11))){
var inst_30438 = (state_30717[(18)]);
var inst_30438__$1 = (state_30717[(2)]);
var inst_30439 = cljs.core.contains_QMARK_.call(null,inst_30438__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var state_30717__$1 = (function (){var statearr_30824 = state_30717;
(statearr_30824[(18)] = inst_30438__$1);

return statearr_30824;
})();
if(inst_30439){
var statearr_30825_30967 = state_30717__$1;
(statearr_30825_30967[(1)] = (12));

} else {
var statearr_30826_30968 = state_30717__$1;
(statearr_30826_30968[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (9))){
var inst_30433 = flake.p;
var inst_30434 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_30435 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_30433,inst_30434);
var state_30717__$1 = state_30717;
var statearr_30827_30969 = state_30717__$1;
(statearr_30827_30969[(2)] = inst_30435);

(statearr_30827_30969[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (5))){
var _ = (function (){var statearr_30828 = state_30717;
(statearr_30828[(4)] = cljs.core.rest.call(null,(state_30717[(4)])));

return statearr_30828;
})();
var state_30717__$1 = state_30717;
var ex30823 = (state_30717__$1[(2)]);
var statearr_30829_30970 = state_30717__$1;
(statearr_30829_30970[(5)] = ex30823);


if((ex30823 instanceof Error)){
var statearr_30830_30971 = state_30717__$1;
(statearr_30830_30971[(1)] = (4));

(statearr_30830_30971[(5)] = null);

} else {
throw ex30823;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (83))){
var inst_30615 = (state_30717[(24)]);
var inst_30629 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_30630 = cljs.core.sequence.call(null,inst_30629,inst_30615);
var state_30717__$1 = state_30717;
var statearr_30831_30972 = state_30717__$1;
(statearr_30831_30972[(2)] = inst_30630);

(statearr_30831_30972[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (14))){
var inst_30445 = (state_30717[(28)]);
var inst_30444 = (state_30717[(7)]);
var inst_30444__$1 = (state_30717[(2)]);
var inst_30445__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_30444__$1);
var state_30717__$1 = (function (){var statearr_30832 = state_30717;
(statearr_30832[(28)] = inst_30445__$1);

(statearr_30832[(7)] = inst_30444__$1);

return statearr_30832;
})();
if(cljs.core.truth_(inst_30445__$1)){
var statearr_30833_30973 = state_30717__$1;
(statearr_30833_30973[(1)] = (15));

} else {
var statearr_30834_30974 = state_30717__$1;
(statearr_30834_30974[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (45))){
var inst_30518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30519 = [null,offset_map];
var inst_30520 = (new cljs.core.PersistentVector(null,2,(5),inst_30518,inst_30519,null));
var state_30717__$1 = state_30717;
var statearr_30835_30975 = state_30717__$1;
(statearr_30835_30975[(2)] = inst_30520);

(statearr_30835_30975[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (53))){
var inst_30529 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30836_30976 = state_30717__$1;
(statearr_30836_30976[(2)] = inst_30529);

(statearr_30836_30976[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (78))){
var inst_30615 = (state_30717[(24)]);
var inst_30614 = (state_30717[(2)]);
var inst_30615__$1 = fluree.db.util.async.throw_err.call(null,inst_30614);
var inst_30616 = cljs.core.empty_QMARK_.call(null,inst_30615__$1);
var state_30717__$1 = (function (){var statearr_30837 = state_30717;
(statearr_30837[(24)] = inst_30615__$1);

return statearr_30837;
})();
if(inst_30616){
var statearr_30838_30977 = state_30717__$1;
(statearr_30838_30977[(1)] = (79));

} else {
var statearr_30839_30978 = state_30717__$1;
(statearr_30839_30978[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (26))){
var inst_30468 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30840_30979 = state_30717__$1;
(statearr_30840_30979[(2)] = inst_30468);

(statearr_30840_30979[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (16))){
var inst_30444 = (state_30717[(7)]);
var inst_30448 = (state_30717[(33)]);
var inst_30448__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_30444);
var state_30717__$1 = (function (){var statearr_30841 = state_30717;
(statearr_30841[(33)] = inst_30448__$1);

return statearr_30841;
})();
if(cljs.core.truth_(inst_30448__$1)){
var statearr_30842_30980 = state_30717__$1;
(statearr_30842_30980[(1)] = (18));

} else {
var statearr_30843_30981 = state_30717__$1;
(statearr_30843_30981[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (81))){
var inst_30646 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30844_30982 = state_30717__$1;
(statearr_30844_30982[(2)] = inst_30646);

(statearr_30844_30982[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (79))){
var inst_30618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30619 = ["_id"];
var inst_30620 = flake.o;
var inst_30621 = [inst_30620];
var inst_30622 = cljs.core.PersistentHashMap.fromArrays(inst_30619,inst_30621);
var inst_30623 = [inst_30622,offset_map];
var inst_30624 = (new cljs.core.PersistentVector(null,2,(5),inst_30618,inst_30623,null));
var state_30717__$1 = state_30717;
var statearr_30845_30983 = state_30717__$1;
(statearr_30845_30983[(2)] = inst_30624);

(statearr_30845_30983[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (38))){
var inst_30677 = (state_30717[(25)]);
var inst_30676 = (state_30717[(2)]);
var inst_30677__$1 = cljs.core.nth.call(null,inst_30676,(0),null);
var inst_30678 = cljs.core.nth.call(null,inst_30676,(1),null);
var inst_30679 = (inst_30677__$1 == null);
var inst_30680 = cljs.core.not.call(null,inst_30679);
var state_30717__$1 = (function (){var statearr_30846 = state_30717;
(statearr_30846[(25)] = inst_30677__$1);

(statearr_30846[(26)] = inst_30678);

return statearr_30846;
})();
if(inst_30680){
var statearr_30847_30984 = state_30717__$1;
(statearr_30847_30984[(1)] = (95));

} else {
var statearr_30848_30985 = state_30717__$1;
(statearr_30848_30985[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (98))){
var inst_30677 = (state_30717[(25)]);
var inst_30678 = (state_30717[(26)]);
var inst_30455 = (state_30717[(17)]);
var inst_30686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30687 = cljs.core.PersistentVector.EMPTY;
var inst_30688 = cljs.core.get.call(null,acc,inst_30455,inst_30687);
var inst_30689 = cljs.core.conj.call(null,inst_30688,inst_30677);
var inst_30690 = cljs.core.assoc.call(null,acc,inst_30455,inst_30689);
var inst_30691 = [inst_30690,inst_30678];
var inst_30692 = (new cljs.core.PersistentVector(null,2,(5),inst_30686,inst_30691,null));
var state_30717__$1 = state_30717;
var statearr_30849_30986 = state_30717__$1;
(statearr_30849_30986[(2)] = inst_30692);

(statearr_30849_30986[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (87))){
var inst_30633 = (state_30717[(23)]);
var state_30717__$1 = state_30717;
var statearr_30850_30987 = state_30717__$1;
(statearr_30850_30987[(2)] = inst_30633);

(statearr_30850_30987[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (30))){
var inst_30481 = (state_30717[(15)]);
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30481)){
var statearr_30851_30988 = state_30717__$1;
(statearr_30851_30988[(1)] = (33));

} else {
var statearr_30852_30989 = state_30717__$1;
(statearr_30852_30989[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (73))){
var inst_30597 = (state_30717[(31)]);
var state_30717__$1 = state_30717;
var statearr_30853_30990 = state_30717__$1;
(statearr_30853_30990[(2)] = inst_30597);

(statearr_30853_30990[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (96))){
var state_30717__$1 = state_30717;
var statearr_30854_30991 = state_30717__$1;
(statearr_30854_30991[(2)] = false);

(statearr_30854_30991[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (10))){
var state_30717__$1 = state_30717;
var statearr_30855_30992 = state_30717__$1;
(statearr_30855_30992[(2)] = pred_spec);

(statearr_30855_30992[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (18))){
var inst_30448 = (state_30717[(33)]);
var state_30717__$1 = state_30717;
var statearr_30856_30993 = state_30717__$1;
(statearr_30856_30993[(2)] = inst_30448);

(statearr_30856_30993[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (105))){
var state_30717__$1 = state_30717;
var statearr_30857_30994 = state_30717__$1;
(statearr_30857_30994[(2)] = null);

(statearr_30857_30994[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (52))){
var inst_30444 = (state_30717[(7)]);
var inst_30527 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_30444);
var state_30717__$1 = state_30717;
var statearr_30858_30995 = state_30717__$1;
(statearr_30858_30995[(2)] = inst_30527);

(statearr_30858_30995[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (67))){
var inst_30670 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30859_30996 = state_30717__$1;
(statearr_30859_30996[(2)] = inst_30670);

(statearr_30859_30996[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (71))){
var inst_30444 = (state_30717[(7)]);
var inst_30582 = (state_30717[(2)]);
var inst_30583 = fluree.db.util.async.throw_err.call(null,inst_30582);
var inst_30584 = cljs.core._deref.call(null,cache);
var inst_30585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30586 = flake.o;
var inst_30587 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_30444);
var inst_30588 = [inst_30586,inst_30587];
var inst_30589 = (new cljs.core.PersistentVector(null,2,(5),inst_30585,inst_30588,null));
var inst_30590 = cljs.core.assoc.call(null,inst_30584,inst_30589,inst_30583);
var inst_30591 = cljs.core._vreset_BANG_.call(null,cache,inst_30590);
var state_30717__$1 = (function (){var statearr_30860 = state_30717;
(statearr_30860[(34)] = inst_30591);

return statearr_30860;
})();
var statearr_30861_30997 = state_30717__$1;
(statearr_30861_30997[(2)] = inst_30583);

(statearr_30861_30997[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (42))){
var inst_30479 = (state_30717[(10)]);
var inst_30480 = (state_30717[(13)]);
var inst_30455 = (state_30717[(17)]);
var inst_30509 = cljs.core.not.call(null,inst_30480);
var inst_30510 = cljs.core.get.call(null,acc,inst_30455);
var inst_30511 = cljs.core.count.call(null,inst_30510);
var inst_30512 = (inst_30511 >= inst_30479);
var inst_30513 = ((inst_30509) && (inst_30512));
var state_30717__$1 = state_30717;
var statearr_30862_30998 = state_30717__$1;
(statearr_30862_30998[(2)] = inst_30513);

(statearr_30862_30998[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (80))){
var inst_30626 = cljs.core.PersistentVector.EMPTY_NODE;
var state_30717__$1 = (function (){var statearr_30863 = state_30717;
(statearr_30863[(32)] = inst_30626);

return statearr_30863;
})();
if(cljs.core.truth_(fuel)){
var statearr_30864_30999 = state_30717__$1;
(statearr_30864_30999[(1)] = (83));

} else {
var statearr_30865_31000 = state_30717__$1;
(statearr_30865_31000[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (37))){
var inst_30477 = (state_30717[(16)]);
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30477)){
var statearr_30866_31001 = state_30717__$1;
(statearr_30866_31001[(1)] = (42));

} else {
var statearr_30867_31002 = state_30717__$1;
(statearr_30867_31002[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (63))){
var inst_30553 = (state_30717[(19)]);
var state_30717__$1 = state_30717;
var statearr_30868_31003 = state_30717__$1;
(statearr_30868_31003[(2)] = inst_30553);

(statearr_30868_31003[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (94))){
var inst_30664 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30869_31004 = state_30717__$1;
(statearr_30869_31004[(2)] = inst_30664);

(statearr_30869_31004[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (8))){
var inst_30431 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30431)){
var statearr_30870_31005 = state_30717__$1;
(statearr_30870_31005[(1)] = (9));

} else {
var statearr_30871_31006 = state_30717__$1;
(statearr_30871_31006[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (49))){
var state_30717__$1 = state_30717;
var statearr_30872_31007 = state_30717__$1;
(statearr_30872_31007[(2)] = false);

(statearr_30872_31007[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30718 === (84))){
var inst_30615 = (state_30717[(24)]);
var state_30717__$1 = state_30717;
var statearr_30873_31008 = state_30717__$1;
(statearr_30873_31008[(2)] = inst_30615);

(statearr_30873_31008[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11469__auto__ = null;
var fluree$db$query$fql$state_machine__11469__auto____0 = (function (){
var statearr_30874 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30874[(0)] = fluree$db$query$fql$state_machine__11469__auto__);

(statearr_30874[(1)] = (1));

return statearr_30874;
});
var fluree$db$query$fql$state_machine__11469__auto____1 = (function (state_30717){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_30717);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e30875){var ex__11472__auto__ = e30875;
var statearr_30876_31009 = state_30717;
(statearr_30876_31009[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_30717[(4)]))){
var statearr_30877_31010 = state_30717;
(statearr_30877_31010[(1)] = cljs.core.first.call(null,(state_30717[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31011 = state_30717;
state_30717 = G__31011;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11469__auto__ = function(state_30717){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11469__auto____1.call(this,state_30717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11469__auto____0;
fluree$db$query$fql$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11469__auto____1;
return fluree$db$query$fql$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_30878 = f__11543__auto__.call(null);
(statearr_30878[(6)] = c__11542__auto__);

return statearr_30878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
cljs.core._vreset_BANG_.call(null,cache,cljs.core.assoc.call(null,cljs.core._deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_31191){
var state_val_31192 = (state_31191[(1)]);
if((state_val_31192 === (7))){
var inst_31186 = (state_31191[(2)]);
var _ = (function (){var statearr_31193 = state_31191;
(statearr_31193[(4)] = cljs.core.rest.call(null,(state_31191[(4)])));

return statearr_31193;
})();
var state_31191__$1 = state_31191;
var statearr_31194_31289 = state_31191__$1;
(statearr_31194_31289[(2)] = inst_31186);

(statearr_31194_31289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (59))){
var inst_31072 = (state_31191[(7)]);
var state_31191__$1 = state_31191;
var statearr_31195_31290 = state_31191__$1;
(statearr_31195_31290[(2)] = inst_31072);

(statearr_31195_31290[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (20))){
var inst_31081 = (state_31191[(8)]);
var inst_31078 = (state_31191[(2)]);
var inst_31079 = fluree.db.util.async.throw_err.call(null,inst_31078);
var inst_31080 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_31079);
var inst_31081__$1 = cljs.core.not_empty.call(null,inst_31080);
var state_31191__$1 = (function (){var statearr_31196 = state_31191;
(statearr_31196[(8)] = inst_31081__$1);

return statearr_31196;
})();
if(cljs.core.truth_(inst_31081__$1)){
var statearr_31197_31291 = state_31191__$1;
(statearr_31197_31291[(1)] = (21));

} else {
var statearr_31198_31292 = state_31191__$1;
(statearr_31198_31292[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (58))){
var inst_31071 = (state_31191[(9)]);
var state_31191__$1 = state_31191;
var statearr_31199_31293 = state_31191__$1;
(statearr_31199_31293[(2)] = inst_31071);

(statearr_31199_31293[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (60))){
var inst_31178 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
var statearr_31200_31294 = state_31191__$1;
(statearr_31200_31294[(2)] = inst_31178);

(statearr_31200_31294[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (27))){
var inst_31103 = (state_31191[(10)]);
var inst_31111 = (state_31191[(11)]);
var inst_31113 = (state_31191[(12)]);
var inst_31110 = cljs.core.seq.call(null,inst_31103);
var inst_31111__$1 = cljs.core.first.call(null,inst_31110);
var inst_31112 = cljs.core.next.call(null,inst_31110);
var inst_31113__$1 = cljs.core.not.call(null,inst_31111__$1);
var state_31191__$1 = (function (){var statearr_31201 = state_31191;
(statearr_31201[(11)] = inst_31111__$1);

(statearr_31201[(13)] = inst_31112);

(statearr_31201[(12)] = inst_31113__$1);

return statearr_31201;
})();
if(inst_31113__$1){
var statearr_31202_31295 = state_31191__$1;
(statearr_31202_31295[(1)] = (29));

} else {
var statearr_31203_31296 = state_31191__$1;
(statearr_31203_31296[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (1))){
var state_31191__$1 = state_31191;
var statearr_31204_31297 = state_31191__$1;
(statearr_31204_31297[(2)] = null);

(statearr_31204_31297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (24))){
var inst_31081 = (state_31191[(8)]);
var inst_31087 = cljs.core.count.call(null,inst_31081);
var inst_31088 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_31087,max_fuel);
var state_31191__$1 = state_31191;
var statearr_31205_31298 = state_31191__$1;
(statearr_31205_31298[(2)] = inst_31088);

(statearr_31205_31298[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (55))){
var inst_31070 = (state_31191[(14)]);
var state_31191__$1 = state_31191;
var statearr_31206_31299 = state_31191__$1;
(statearr_31206_31299[(2)] = inst_31070);

(statearr_31206_31299[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (39))){
var inst_31068 = (state_31191[(15)]);
var state_31191__$1 = state_31191;
var statearr_31207_31300 = state_31191__$1;
(statearr_31207_31300[(2)] = inst_31068);

(statearr_31207_31300[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (46))){
var inst_31166 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
var statearr_31208_31301 = state_31191__$1;
(statearr_31208_31301[(2)] = inst_31166);

(statearr_31208_31301[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (4))){
var inst_31012 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
var statearr_31209_31302 = state_31191__$1;
(statearr_31209_31302[(2)] = inst_31012);

(statearr_31209_31302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (54))){
var inst_31105 = (state_31191[(16)]);
var inst_31157 = (state_31191[(2)]);
var inst_31158 = fluree.db.util.async.throw_err.call(null,inst_31157);
var inst_31159 = cljs.core.conj.call(null,inst_31105,inst_31158);
var state_31191__$1 = state_31191;
var statearr_31210_31303 = state_31191__$1;
(statearr_31210_31303[(2)] = inst_31159);

(statearr_31210_31303[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (15))){
var state_31191__$1 = state_31191;
var statearr_31211_31304 = state_31191__$1;
(statearr_31211_31304[(2)] = false);

(statearr_31211_31304[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (48))){
var inst_31105 = (state_31191[(16)]);
var state_31191__$1 = state_31191;
var statearr_31212_31305 = state_31191__$1;
(statearr_31212_31305[(2)] = inst_31105);

(statearr_31212_31305[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (50))){
var inst_31104 = (state_31191[(17)]);
var inst_31112 = (state_31191[(13)]);
var inst_31161 = (state_31191[(2)]);
var inst_31162 = (inst_31104 + (1));
var inst_31103 = inst_31112;
var inst_31104__$1 = inst_31162;
var inst_31105 = inst_31161;
var state_31191__$1 = (function (){var statearr_31213 = state_31191;
(statearr_31213[(10)] = inst_31103);

(statearr_31213[(17)] = inst_31104__$1);

(statearr_31213[(16)] = inst_31105);

return statearr_31213;
})();
var statearr_31214_31306 = state_31191__$1;
(statearr_31214_31306[(2)] = null);

(statearr_31214_31306[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (21))){
var state_31191__$1 = state_31191;
var statearr_31215_31307 = state_31191__$1;
(statearr_31215_31307[(2)] = fuel);

(statearr_31215_31307[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (31))){
var inst_31122 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
if(cljs.core.truth_(inst_31122)){
var statearr_31216_31308 = state_31191__$1;
(statearr_31216_31308[(1)] = (35));

} else {
var statearr_31217_31309 = state_31191__$1;
(statearr_31217_31309[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (32))){
var inst_31069 = (state_31191[(18)]);
var inst_31104 = (state_31191[(17)]);
var inst_31117 = (inst_31104 >= inst_31069);
var state_31191__$1 = state_31191;
var statearr_31218_31310 = state_31191__$1;
(statearr_31218_31310[(2)] = inst_31117);

(statearr_31218_31310[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (40))){
var inst_31129 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
if(cljs.core.truth_(inst_31129)){
var statearr_31219_31311 = state_31191__$1;
(statearr_31219_31311[(1)] = (41));

} else {
var statearr_31220_31312 = state_31191__$1;
(statearr_31220_31312[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (56))){
var inst_31071 = (state_31191[(9)]);
var state_31191__$1 = state_31191;
if(cljs.core.truth_(inst_31071)){
var statearr_31221_31313 = state_31191__$1;
(statearr_31221_31313[(1)] = (58));

} else {
var statearr_31222_31314 = state_31191__$1;
(statearr_31222_31314[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (33))){
var inst_31069 = (state_31191[(18)]);
var state_31191__$1 = state_31191;
var statearr_31223_31315 = state_31191__$1;
(statearr_31223_31315[(2)] = inst_31069);

(statearr_31223_31315[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (13))){
var inst_31062 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
if(cljs.core.truth_(inst_31062)){
var statearr_31224_31316 = state_31191__$1;
(statearr_31224_31316[(1)] = (17));

} else {
var statearr_31225_31317 = state_31191__$1;
(statearr_31225_31317[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (22))){
var inst_31081 = (state_31191[(8)]);
var state_31191__$1 = state_31191;
var statearr_31227_31318 = state_31191__$1;
(statearr_31227_31318[(2)] = inst_31081);

(statearr_31227_31318[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (36))){
var inst_31068 = (state_31191[(15)]);
var state_31191__$1 = state_31191;
if(cljs.core.truth_(inst_31068)){
var statearr_31228_31319 = state_31191__$1;
(statearr_31228_31319[(1)] = (38));

} else {
var statearr_31229_31320 = state_31191__$1;
(statearr_31229_31320[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (41))){
var inst_31104 = (state_31191[(17)]);
var inst_31105 = (state_31191[(16)]);
var inst_31112 = (state_31191[(13)]);
var inst_31131 = (inst_31104 + (1));
var tmp31226 = inst_31105;
var inst_31103 = inst_31112;
var inst_31104__$1 = inst_31131;
var inst_31105__$1 = tmp31226;
var state_31191__$1 = (function (){var statearr_31230 = state_31191;
(statearr_31230[(10)] = inst_31103);

(statearr_31230[(17)] = inst_31104__$1);

(statearr_31230[(16)] = inst_31105__$1);

return statearr_31230;
})();
var statearr_31231_31321 = state_31191__$1;
(statearr_31231_31321[(2)] = null);

(statearr_31231_31321[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (43))){
var inst_31168 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
var statearr_31232_31322 = state_31191__$1;
(statearr_31232_31322[(2)] = inst_31168);

(statearr_31232_31322[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (29))){
var inst_31113 = (state_31191[(12)]);
var state_31191__$1 = state_31191;
var statearr_31233_31323 = state_31191__$1;
(statearr_31233_31323[(2)] = inst_31113);

(statearr_31233_31323[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (44))){
var inst_31111 = (state_31191[(11)]);
var inst_31135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31136 = [inst_31111];
var inst_31137 = (new cljs.core.PersistentVector(null,1,(5),inst_31135,inst_31136,null));
var inst_31138 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_31137);
var state_31191__$1 = state_31191;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31191__$1,(47),inst_31138);
} else {
if((state_val_31192 === (6))){
var inst_31036 = (state_31191[(19)]);
var inst_31029 = (state_31191[(20)]);
var inst_31035 = cljs.core.seq.call(null,inst_31029);
var inst_31036__$1 = cljs.core.first.call(null,inst_31035);
var inst_31037 = cljs.core.next.call(null,inst_31035);
var inst_31038 = cljs.core.not.call(null,inst_31036__$1);
var state_31191__$1 = (function (){var statearr_31234 = state_31191;
(statearr_31234[(19)] = inst_31036__$1);

(statearr_31234[(21)] = inst_31037);

return statearr_31234;
})();
if(inst_31038){
var statearr_31235_31324 = state_31191__$1;
(statearr_31235_31324[(1)] = (8));

} else {
var statearr_31236_31325 = state_31191__$1;
(statearr_31236_31325[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (28))){
var inst_31070 = (state_31191[(14)]);
var inst_31172 = (state_31191[(2)]);
var state_31191__$1 = (function (){var statearr_31237 = state_31191;
(statearr_31237[(22)] = inst_31172);

return statearr_31237;
})();
if(cljs.core.truth_(inst_31070)){
var statearr_31238_31326 = state_31191__$1;
(statearr_31238_31326[(1)] = (55));

} else {
var statearr_31239_31327 = state_31191__$1;
(statearr_31239_31327[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (51))){
var inst_31141 = (state_31191[(23)]);
var inst_31150 = cljs.core.count.call(null,inst_31141);
var inst_31151 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_31150,max_fuel);
var state_31191__$1 = state_31191;
var statearr_31240_31328 = state_31191__$1;
(statearr_31240_31328[(2)] = inst_31151);

(statearr_31240_31328[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (25))){
var state_31191__$1 = state_31191;
var statearr_31241_31329 = state_31191__$1;
(statearr_31241_31329[(2)] = null);

(statearr_31241_31329[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (34))){
var inst_31120 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
var statearr_31242_31330 = state_31191__$1;
(statearr_31242_31330[(2)] = inst_31120);

(statearr_31242_31330[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (17))){
var inst_31046 = (state_31191[(24)]);
var inst_31064 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31046);
var state_31191__$1 = state_31191;
var statearr_31243_31331 = state_31191__$1;
(statearr_31243_31331[(2)] = inst_31064);

(statearr_31243_31331[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (3))){
var inst_31189 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31191__$1,inst_31189);
} else {
if((state_val_31192 === (12))){
var state_31191__$1 = state_31191;
var statearr_31244_31332 = state_31191__$1;
(statearr_31244_31332[(2)] = false);

(statearr_31244_31332[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (2))){
var _ = (function (){var statearr_31245 = state_31191;
(statearr_31245[(4)] = cljs.core.cons.call(null,(5),(state_31191[(4)])));

return statearr_31245;
})();
var inst_31025 = reverse_refs_specs;
var inst_31026 = cljs.core.seq.call(null,inst_31025);
var inst_31027 = cljs.core.first.call(null,inst_31026);
var inst_31028 = cljs.core.next.call(null,inst_31026);
var inst_31029 = inst_31025;
var inst_31030 = null;
var state_31191__$1 = (function (){var statearr_31246 = state_31191;
(statearr_31246[(25)] = inst_31030);

(statearr_31246[(26)] = inst_31028);

(statearr_31246[(20)] = inst_31029);

(statearr_31246[(27)] = inst_31027);

return statearr_31246;
})();
var statearr_31247_31333 = state_31191__$1;
(statearr_31247_31333[(2)] = null);

(statearr_31247_31333[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (23))){
var inst_31085 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
if(cljs.core.truth_(inst_31085)){
var statearr_31248_31334 = state_31191__$1;
(statearr_31248_31334[(1)] = (24));

} else {
var statearr_31249_31335 = state_31191__$1;
(statearr_31249_31335[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (47))){
var inst_31046 = (state_31191[(24)]);
var inst_31141 = (state_31191[(23)]);
var inst_31140 = (state_31191[(2)]);
var inst_31141__$1 = fluree.db.util.async.throw_err.call(null,inst_31140);
var inst_31142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31143 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_31144 = (new cljs.core.PersistentVector(null,4,(5),inst_31142,inst_31143,null));
var inst_31145 = cljs.core.select_keys.call(null,inst_31046,inst_31144);
var inst_31146 = cljs.core.empty_QMARK_.call(null,inst_31141__$1);
var state_31191__$1 = (function (){var statearr_31250 = state_31191;
(statearr_31250[(28)] = inst_31145);

(statearr_31250[(23)] = inst_31141__$1);

return statearr_31250;
})();
if(inst_31146){
var statearr_31251_31336 = state_31191__$1;
(statearr_31251_31336[(1)] = (48));

} else {
var statearr_31252_31337 = state_31191__$1;
(statearr_31252_31337[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (35))){
var inst_31105 = (state_31191[(16)]);
var state_31191__$1 = state_31191;
var statearr_31253_31338 = state_31191__$1;
(statearr_31253_31338[(2)] = inst_31105);

(statearr_31253_31338[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (19))){
var inst_31045 = (state_31191[(29)]);
var inst_31067 = (state_31191[(2)]);
var inst_31068 = cljs.core.get.call(null,inst_31067,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_31069 = cljs.core.get.call(null,inst_31067,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_31070 = cljs.core.get.call(null,inst_31067,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_31071 = cljs.core.get.call(null,inst_31067,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_31072 = cljs.core.get.call(null,inst_31067,new cljs.core.Keyword(null,"p","p",151049309));
var inst_31073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31074 = [subject_id,inst_31045];
var inst_31075 = (new cljs.core.PersistentVector(null,2,(5),inst_31073,inst_31074,null));
var inst_31076 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_31075);
var state_31191__$1 = (function (){var statearr_31254 = state_31191;
(statearr_31254[(7)] = inst_31072);

(statearr_31254[(9)] = inst_31071);

(statearr_31254[(15)] = inst_31068);

(statearr_31254[(18)] = inst_31069);

(statearr_31254[(14)] = inst_31070);

return statearr_31254;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31191__$1,(20),inst_31076);
} else {
if((state_val_31192 === (57))){
var inst_31172 = (state_31191[(22)]);
var inst_31030 = (state_31191[(25)]);
var inst_31037 = (state_31191[(21)]);
var inst_31180 = (state_31191[(2)]);
var inst_31181 = cljs.core.assoc.call(null,inst_31030,inst_31180,inst_31172);
var inst_31029 = inst_31037;
var inst_31030__$1 = inst_31181;
var state_31191__$1 = (function (){var statearr_31255 = state_31191;
(statearr_31255[(25)] = inst_31030__$1);

(statearr_31255[(20)] = inst_31029);

return statearr_31255;
})();
var statearr_31256_31339 = state_31191__$1;
(statearr_31256_31339[(2)] = null);

(statearr_31256_31339[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (11))){
var inst_31046 = (state_31191[(24)]);
var inst_31051 = inst_31046.cljs$lang$protocol_mask$partition0$;
var inst_31052 = (inst_31051 & (64));
var inst_31053 = inst_31046.cljs$core$ISeq$;
var inst_31054 = (cljs.core.PROTOCOL_SENTINEL === inst_31053);
var inst_31055 = ((inst_31052) || (inst_31054));
var state_31191__$1 = state_31191;
if(cljs.core.truth_(inst_31055)){
var statearr_31258_31340 = state_31191__$1;
(statearr_31258_31340[(1)] = (14));

} else {
var statearr_31259_31341 = state_31191__$1;
(statearr_31259_31341[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (9))){
var inst_31046 = (state_31191[(24)]);
var inst_31036 = (state_31191[(19)]);
var inst_31045 = cljs.core.nth.call(null,inst_31036,(0),null);
var inst_31046__$1 = cljs.core.nth.call(null,inst_31036,(1),null);
var inst_31048 = (inst_31046__$1 == null);
var inst_31049 = cljs.core.not.call(null,inst_31048);
var state_31191__$1 = (function (){var statearr_31260 = state_31191;
(statearr_31260[(24)] = inst_31046__$1);

(statearr_31260[(29)] = inst_31045);

return statearr_31260;
})();
if(inst_31049){
var statearr_31261_31342 = state_31191__$1;
(statearr_31261_31342[(1)] = (11));

} else {
var statearr_31262_31343 = state_31191__$1;
(statearr_31262_31343[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (5))){
var _ = (function (){var statearr_31263 = state_31191;
(statearr_31263[(4)] = cljs.core.rest.call(null,(state_31191[(4)])));

return statearr_31263;
})();
var state_31191__$1 = state_31191;
var ex31257 = (state_31191__$1[(2)]);
var statearr_31264_31344 = state_31191__$1;
(statearr_31264_31344[(5)] = ex31257);


if((ex31257 instanceof Error)){
var statearr_31265_31345 = state_31191__$1;
(statearr_31265_31345[(1)] = (4));

(statearr_31265_31345[(5)] = null);

} else {
throw ex31257;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (14))){
var state_31191__$1 = state_31191;
var statearr_31266_31346 = state_31191__$1;
(statearr_31266_31346[(2)] = true);

(statearr_31266_31346[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (45))){
var state_31191__$1 = state_31191;
var statearr_31267_31347 = state_31191__$1;
(statearr_31267_31347[(2)] = null);

(statearr_31267_31347[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (53))){
var inst_31145 = (state_31191[(28)]);
var inst_31141 = (state_31191[(23)]);
var inst_31154 = (state_31191[(2)]);
var inst_31155 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_31145,inst_31141);
var state_31191__$1 = (function (){var statearr_31268 = state_31191;
(statearr_31268[(30)] = inst_31154);

return statearr_31268;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31191__$1,(54),inst_31155);
} else {
if((state_val_31192 === (26))){
var inst_31081 = (state_31191[(8)]);
var inst_31091 = (state_31191[(2)]);
var inst_31099 = cljs.core.seq.call(null,inst_31081);
var inst_31100 = cljs.core.first.call(null,inst_31099);
var inst_31101 = cljs.core.next.call(null,inst_31099);
var inst_31102 = cljs.core.PersistentVector.EMPTY;
var inst_31103 = inst_31081;
var inst_31104 = (0);
var inst_31105 = inst_31102;
var state_31191__$1 = (function (){var statearr_31269 = state_31191;
(statearr_31269[(31)] = inst_31091);

(statearr_31269[(10)] = inst_31103);

(statearr_31269[(17)] = inst_31104);

(statearr_31269[(32)] = inst_31101);

(statearr_31269[(16)] = inst_31105);

(statearr_31269[(33)] = inst_31100);

return statearr_31269;
})();
var statearr_31270_31348 = state_31191__$1;
(statearr_31270_31348[(2)] = null);

(statearr_31270_31348[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (16))){
var inst_31059 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
var statearr_31271_31349 = state_31191__$1;
(statearr_31271_31349[(2)] = inst_31059);

(statearr_31271_31349[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (38))){
var inst_31068 = (state_31191[(15)]);
var inst_31104 = (state_31191[(17)]);
var inst_31126 = (inst_31104 < inst_31068);
var state_31191__$1 = state_31191;
var statearr_31272_31350 = state_31191__$1;
(statearr_31272_31350[(2)] = inst_31126);

(statearr_31272_31350[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (30))){
var inst_31069 = (state_31191[(18)]);
var state_31191__$1 = state_31191;
if(cljs.core.truth_(inst_31069)){
var statearr_31273_31351 = state_31191__$1;
(statearr_31273_31351[(1)] = (32));

} else {
var statearr_31274_31352 = state_31191__$1;
(statearr_31274_31352[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (10))){
var inst_31184 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
var statearr_31275_31353 = state_31191__$1;
(statearr_31275_31353[(2)] = inst_31184);

(statearr_31275_31353[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (18))){
var inst_31046 = (state_31191[(24)]);
var state_31191__$1 = state_31191;
var statearr_31276_31354 = state_31191__$1;
(statearr_31276_31354[(2)] = inst_31046);

(statearr_31276_31354[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (52))){
var state_31191__$1 = state_31191;
var statearr_31277_31355 = state_31191__$1;
(statearr_31277_31355[(2)] = null);

(statearr_31277_31355[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (42))){
var state_31191__$1 = state_31191;
var statearr_31278_31356 = state_31191__$1;
(statearr_31278_31356[(1)] = (44));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (37))){
var inst_31170 = (state_31191[(2)]);
var state_31191__$1 = state_31191;
var statearr_31280_31357 = state_31191__$1;
(statearr_31280_31357[(2)] = inst_31170);

(statearr_31280_31357[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (8))){
var inst_31030 = (state_31191[(25)]);
var state_31191__$1 = state_31191;
var statearr_31281_31358 = state_31191__$1;
(statearr_31281_31358[(2)] = inst_31030);

(statearr_31281_31358[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31192 === (49))){
var state_31191__$1 = state_31191;
if(cljs.core.truth_(fuel)){
var statearr_31282_31359 = state_31191__$1;
(statearr_31282_31359[(1)] = (51));

} else {
var statearr_31283_31360 = state_31191__$1;
(statearr_31283_31360[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11469__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11469__auto____0 = (function (){
var statearr_31284 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31284[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11469__auto__);

(statearr_31284[(1)] = (1));

return statearr_31284;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11469__auto____1 = (function (state_31191){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_31191);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e31285){var ex__11472__auto__ = e31285;
var statearr_31286_31361 = state_31191;
(statearr_31286_31361[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_31191[(4)]))){
var statearr_31287_31362 = state_31191;
(statearr_31287_31362[(1)] = cljs.core.first.call(null,(state_31191[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31363 = state_31191;
state_31191 = G__31363;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11469__auto__ = function(state_31191){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11469__auto____1.call(this,state_31191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11469__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11469__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_31288 = f__11543__auto__.call(null);
(statearr_31288[(6)] = c__11542__auto__);

return statearr_31288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.call(null,coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__31364 = select_spec;
var map__31364__$1 = (((((!((map__31364 == null))))?(((((map__31364.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31364.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31364):map__31364);
var recur_seen = cljs.core.get.call(null,map__31364__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__31364__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_31447){
var state_val_31448 = (state_31447[(1)]);
if((state_val_31448 === (7))){
var state_31447__$1 = state_31447;
var statearr_31449_31501 = state_31447__$1;
(statearr_31449_31501[(2)] = false);

(statearr_31449_31501[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (20))){
var inst_31403 = (state_31447[(7)]);
var state_31447__$1 = state_31447;
if(cljs.core.truth_(inst_31403)){
var statearr_31450_31502 = state_31447__$1;
(statearr_31450_31502[(1)] = (22));

} else {
var statearr_31451_31503 = state_31447__$1;
(statearr_31451_31503[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (27))){
var inst_31426 = (state_31447[(8)]);
var inst_31432 = (state_31447[(2)]);
var state_31447__$1 = (function (){var statearr_31452 = state_31447;
(statearr_31452[(9)] = inst_31432);

return statearr_31452;
})();
if(cljs.core.truth_(inst_31426)){
var statearr_31453_31504 = state_31447__$1;
(statearr_31453_31504[(1)] = (28));

} else {
var statearr_31454_31505 = state_31447__$1;
(statearr_31454_31505[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (1))){
var state_31447__$1 = state_31447;
var statearr_31455_31506 = state_31447__$1;
(statearr_31455_31506[(2)] = null);

(statearr_31455_31506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (24))){
var inst_31424 = (state_31447[(2)]);
var state_31447__$1 = state_31447;
var statearr_31456_31507 = state_31447__$1;
(statearr_31456_31507[(2)] = inst_31424);

(statearr_31456_31507[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (4))){
var inst_31366 = (state_31447[(2)]);
var state_31447__$1 = state_31447;
var statearr_31457_31508 = state_31447__$1;
(statearr_31457_31508[(2)] = inst_31366);

(statearr_31457_31508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (15))){
var inst_31410 = (state_31447[(2)]);
var inst_31411 = fluree.db.util.async.throw_err.call(null,inst_31410);
var state_31447__$1 = (function (){var statearr_31458 = state_31447;
(statearr_31458[(10)] = inst_31411);

return statearr_31458;
})();
if(cljs.core.truth_(fuel)){
var statearr_31459_31509 = state_31447__$1;
(statearr_31459_31509[(1)] = (16));

} else {
var statearr_31460_31510 = state_31447__$1;
(statearr_31460_31510[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (21))){
var inst_31396 = (state_31447[(11)]);
var inst_31426 = (state_31447[(2)]);
var state_31447__$1 = (function (){var statearr_31461 = state_31447;
(statearr_31461[(8)] = inst_31426);

return statearr_31461;
})();
if(cljs.core.truth_(inst_31396)){
var statearr_31462_31511 = state_31447__$1;
(statearr_31462_31511[(1)] = (25));

} else {
var statearr_31463_31512 = state_31447__$1;
(statearr_31463_31512[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (31))){
var inst_31397 = (state_31447[(12)]);
var inst_31432 = (state_31447[(9)]);
var inst_31438 = (state_31447[(2)]);
var inst_31439 = fluree.db.util.async.throw_err.call(null,inst_31438);
var inst_31440 = inst_31432.call(null,acc,inst_31397,inst_31439);
var state_31447__$1 = state_31447;
var statearr_31464_31513 = state_31447__$1;
(statearr_31464_31513[(2)] = inst_31440);

(statearr_31464_31513[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (13))){
var inst_31374 = (state_31447[(13)]);
var state_31447__$1 = state_31447;
var statearr_31465_31514 = state_31447__$1;
(statearr_31465_31514[(2)] = inst_31374);

(statearr_31465_31514[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (22))){
var inst_31403 = (state_31447[(7)]);
var state_31447__$1 = state_31447;
var statearr_31466_31515 = state_31447__$1;
(statearr_31466_31515[(2)] = inst_31403);

(statearr_31466_31515[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (29))){
var inst_31417 = (state_31447[(14)]);
var inst_31435 = fluree.db.query.fql.recur_select_spec.call(null,select_spec,flake);
var inst_31436 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_31435,inst_31417);
var state_31447__$1 = state_31447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31447__$1,(31),inst_31436);
} else {
if((state_val_31448 === (6))){
var inst_31374 = (state_31447[(13)]);
var inst_31379 = inst_31374.cljs$lang$protocol_mask$partition0$;
var inst_31380 = (inst_31379 & (64));
var inst_31381 = inst_31374.cljs$core$ISeq$;
var inst_31382 = (cljs.core.PROTOCOL_SENTINEL === inst_31381);
var inst_31383 = ((inst_31380) || (inst_31382));
var state_31447__$1 = state_31447;
if(cljs.core.truth_(inst_31383)){
var statearr_31467_31516 = state_31447__$1;
(statearr_31467_31516[(1)] = (9));

} else {
var statearr_31468_31517 = state_31447__$1;
(statearr_31468_31517[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (28))){
var state_31447__$1 = state_31447;
var statearr_31469_31518 = state_31447__$1;
(statearr_31469_31518[(2)] = acc);

(statearr_31469_31518[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (25))){
var inst_31373 = (state_31447[(15)]);
var inst_31399 = (state_31447[(16)]);
var inst_31397 = (state_31447[(12)]);
var inst_31396 = (state_31447[(11)]);
var inst_31402 = (state_31447[(17)]);
var inst_31398 = (state_31447[(18)]);
var inst_31395 = (state_31447[(19)]);
var inst_31417 = (state_31447[(14)]);
var inst_31400 = (state_31447[(20)]);
var inst_31403 = (state_31447[(7)]);
var inst_31426 = (state_31447[(8)]);
var inst_31401 = (state_31447[(21)]);
var inst_31428 = (function (){var recur_seen = inst_31399;
var recur_subject = inst_31373;
var sub_flakes = inst_31417;
var seen_QMARK_ = inst_31402;
var map__31372 = inst_31395;
var multi_QMARK_ = inst_31396;
var limit = inst_31401;
var recur_depth = inst_31400;
var as = inst_31397;
var max_depth_QMARK_ = inst_31403;
var recur = inst_31398;
var stop_QMARK_ = inst_31426;
return (function (results,as__$1,new_result){
return cljs.core.update.call(null,results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_31447__$1 = state_31447;
var statearr_31470_31519 = state_31447__$1;
(statearr_31470_31519[(2)] = inst_31428);

(statearr_31470_31519[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (17))){
var inst_31411 = (state_31447[(10)]);
var state_31447__$1 = state_31447;
var statearr_31471_31520 = state_31447__$1;
(statearr_31471_31520[(2)] = inst_31411);

(statearr_31471_31520[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (3))){
var inst_31445 = (state_31447[(2)]);
var state_31447__$1 = state_31447;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31447__$1,inst_31445);
} else {
if((state_val_31448 === (12))){
var inst_31374 = (state_31447[(13)]);
var inst_31392 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31374);
var state_31447__$1 = state_31447;
var statearr_31472_31521 = state_31447__$1;
(statearr_31472_31521[(2)] = inst_31392);

(statearr_31472_31521[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (2))){
var inst_31374 = (state_31447[(13)]);
var _ = (function (){var statearr_31473 = state_31447;
(statearr_31473[(4)] = cljs.core.cons.call(null,(5),(state_31447[(4)])));

return statearr_31473;
})();
var inst_31373 = flake.o;
var inst_31374__$1 = select_spec;
var inst_31376 = (inst_31374__$1 == null);
var inst_31377 = cljs.core.not.call(null,inst_31376);
var state_31447__$1 = (function (){var statearr_31474 = state_31447;
(statearr_31474[(15)] = inst_31373);

(statearr_31474[(13)] = inst_31374__$1);

return statearr_31474;
})();
if(inst_31377){
var statearr_31475_31522 = state_31447__$1;
(statearr_31475_31522[(1)] = (6));

} else {
var statearr_31476_31523 = state_31447__$1;
(statearr_31476_31523[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (23))){
var inst_31417 = (state_31447[(14)]);
var inst_31422 = cljs.core.empty_QMARK_.call(null,inst_31417);
var state_31447__$1 = state_31447;
var statearr_31477_31524 = state_31447__$1;
(statearr_31477_31524[(2)] = inst_31422);

(statearr_31477_31524[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (19))){
var inst_31402 = (state_31447[(17)]);
var state_31447__$1 = state_31447;
var statearr_31478_31525 = state_31447__$1;
(statearr_31478_31525[(2)] = inst_31402);

(statearr_31478_31525[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (11))){
var inst_31387 = (state_31447[(2)]);
var state_31447__$1 = state_31447;
var statearr_31480_31526 = state_31447__$1;
(statearr_31480_31526[(2)] = inst_31387);

(statearr_31480_31526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (9))){
var state_31447__$1 = state_31447;
var statearr_31481_31527 = state_31447__$1;
(statearr_31481_31527[(2)] = true);

(statearr_31481_31527[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (5))){
var _ = (function (){var statearr_31482 = state_31447;
(statearr_31482[(4)] = cljs.core.rest.call(null,(state_31447[(4)])));

return statearr_31482;
})();
var state_31447__$1 = state_31447;
var ex31479 = (state_31447__$1[(2)]);
var statearr_31483_31528 = state_31447__$1;
(statearr_31483_31528[(5)] = ex31479);


if((ex31479 instanceof Error)){
var statearr_31484_31529 = state_31447__$1;
(statearr_31484_31529[(1)] = (4));

(statearr_31484_31529[(5)] = null);

} else {
throw ex31479;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (14))){
var inst_31373 = (state_31447[(15)]);
var inst_31399 = (state_31447[(16)]);
var inst_31398 = (state_31447[(18)]);
var inst_31395 = (state_31447[(19)]);
var inst_31400 = (state_31447[(20)]);
var inst_31395__$1 = (state_31447[(2)]);
var inst_31396 = cljs.core.get.call(null,inst_31395__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_31397 = cljs.core.get.call(null,inst_31395__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_31398__$1 = cljs.core.get.call(null,inst_31395__$1,new cljs.core.Keyword(null,"recur","recur",-437573268));
var inst_31399__$1 = cljs.core.get.call(null,inst_31395__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_31400__$1 = cljs.core.get.call(null,inst_31395__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_31401 = cljs.core.get.call(null,inst_31395__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_31402 = cljs.core.contains_QMARK_.call(null,inst_31399__$1,inst_31373);
var inst_31403 = (inst_31400__$1 > inst_31398__$1);
var inst_31405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31406 = [inst_31373];
var inst_31407 = (new cljs.core.PersistentVector(null,1,(5),inst_31405,inst_31406,null));
var inst_31408 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_31407);
var state_31447__$1 = (function (){var statearr_31485 = state_31447;
(statearr_31485[(16)] = inst_31399__$1);

(statearr_31485[(12)] = inst_31397);

(statearr_31485[(11)] = inst_31396);

(statearr_31485[(17)] = inst_31402);

(statearr_31485[(18)] = inst_31398__$1);

(statearr_31485[(19)] = inst_31395__$1);

(statearr_31485[(20)] = inst_31400__$1);

(statearr_31485[(7)] = inst_31403);

(statearr_31485[(21)] = inst_31401);

return statearr_31485;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31447__$1,(15),inst_31408);
} else {
if((state_val_31448 === (26))){
var inst_31373 = (state_31447[(15)]);
var inst_31399 = (state_31447[(16)]);
var inst_31397 = (state_31447[(12)]);
var inst_31396 = (state_31447[(11)]);
var inst_31402 = (state_31447[(17)]);
var inst_31398 = (state_31447[(18)]);
var inst_31395 = (state_31447[(19)]);
var inst_31417 = (state_31447[(14)]);
var inst_31400 = (state_31447[(20)]);
var inst_31403 = (state_31447[(7)]);
var inst_31426 = (state_31447[(8)]);
var inst_31401 = (state_31447[(21)]);
var inst_31430 = (function (){var recur_seen = inst_31399;
var recur_subject = inst_31373;
var sub_flakes = inst_31417;
var seen_QMARK_ = inst_31402;
var map__31372 = inst_31395;
var multi_QMARK_ = inst_31396;
var limit = inst_31401;
var recur_depth = inst_31400;
var as = inst_31397;
var max_depth_QMARK_ = inst_31403;
var recur = inst_31398;
var stop_QMARK_ = inst_31426;
return (function (results,as__$1,new_result){
return cljs.core.assoc.call(null,results,as__$1,new_result);
});
})();
var state_31447__$1 = state_31447;
var statearr_31486_31530 = state_31447__$1;
(statearr_31486_31530[(2)] = inst_31430);

(statearr_31486_31530[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (16))){
var inst_31411 = (state_31447[(10)]);
var inst_31413 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_31414 = cljs.core.sequence.call(null,inst_31413,inst_31411);
var state_31447__$1 = state_31447;
var statearr_31487_31531 = state_31447__$1;
(statearr_31487_31531[(2)] = inst_31414);

(statearr_31487_31531[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (30))){
var inst_31442 = (state_31447[(2)]);
var _ = (function (){var statearr_31488 = state_31447;
(statearr_31488[(4)] = cljs.core.rest.call(null,(state_31447[(4)])));

return statearr_31488;
})();
var state_31447__$1 = state_31447;
var statearr_31489_31532 = state_31447__$1;
(statearr_31489_31532[(2)] = inst_31442);

(statearr_31489_31532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (10))){
var state_31447__$1 = state_31447;
var statearr_31490_31533 = state_31447__$1;
(statearr_31490_31533[(2)] = false);

(statearr_31490_31533[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (18))){
var inst_31402 = (state_31447[(17)]);
var inst_31417 = (state_31447[(2)]);
var state_31447__$1 = (function (){var statearr_31491 = state_31447;
(statearr_31491[(14)] = inst_31417);

return statearr_31491;
})();
if(cljs.core.truth_(inst_31402)){
var statearr_31492_31534 = state_31447__$1;
(statearr_31492_31534[(1)] = (19));

} else {
var statearr_31493_31535 = state_31447__$1;
(statearr_31493_31535[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31448 === (8))){
var inst_31390 = (state_31447[(2)]);
var state_31447__$1 = state_31447;
if(cljs.core.truth_(inst_31390)){
var statearr_31494_31536 = state_31447__$1;
(statearr_31494_31536[(1)] = (12));

} else {
var statearr_31495_31537 = state_31447__$1;
(statearr_31495_31537[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__11469__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__11469__auto____0 = (function (){
var statearr_31496 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31496[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__11469__auto__);

(statearr_31496[(1)] = (1));

return statearr_31496;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__11469__auto____1 = (function (state_31447){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_31447);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e31497){var ex__11472__auto__ = e31497;
var statearr_31498_31538 = state_31447;
(statearr_31498_31538[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_31447[(4)]))){
var statearr_31499_31539 = state_31447;
(statearr_31499_31539[(1)] = cljs.core.first.call(null,(state_31447[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31540 = state_31447;
state_31447 = G__31540;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__11469__auto__ = function(state_31447){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__11469__auto____1.call(this,state_31447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__11469__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__11469__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_31500 = f__11543__auto__.call(null);
(statearr_31500[(6)] = c__11542__auto__);

return statearr_31500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_31718){
var state_val_31719 = (state_31718[(1)]);
if((state_val_31719 === (7))){
var state_31718__$1 = state_31718;
var statearr_31720_31805 = state_31718__$1;
(statearr_31720_31805[(2)] = null);

(statearr_31720_31805[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (20))){
var inst_31579 = cljs.core.PersistentHashMap.EMPTY;
var state_31718__$1 = state_31718;
var statearr_31721_31806 = state_31718__$1;
(statearr_31721_31806[(2)] = inst_31579);

(statearr_31721_31806[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (27))){
var inst_31567 = (state_31718[(7)]);
var inst_31561 = (state_31718[(8)]);
var inst_31597 = (state_31718[(9)]);
var inst_31581 = (state_31718[(10)]);
var inst_31697 = (state_31718[(2)]);
var inst_31698 = (function (){var top_level_subject = inst_31561;
var select_spec = inst_31567;
var base_acc = inst_31581;
var acc_PLUS_refs = inst_31597;
var result = inst_31697;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_31699 = cljs.core.PersistentVector.EMPTY;
var inst_31700 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_31567);
var inst_31701 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_31700);
var inst_31702 = cljs.core.vals.call(null,inst_31701);
var inst_31703 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_31567);
var inst_31704 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_31703);
var inst_31705 = cljs.core.vals.call(null,inst_31704);
var inst_31706 = cljs.core.concat.call(null,inst_31702,inst_31705);
var inst_31707 = cljs.core.reduce.call(null,inst_31698,inst_31699,inst_31706);
var inst_31709 = (function (){var top_level_subject = inst_31561;
var select_spec = inst_31567;
var base_acc = inst_31581;
var acc_PLUS_refs = inst_31597;
var result = inst_31697;
var sort_preds = inst_31707;
return (function (acc,p__31708){
var vec__31722 = p__31708;
var selectPred = cljs.core.nth.call(null,vec__31722,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__31722,(1),null);
var sortPred = cljs.core.nth.call(null,vec__31722,(2),null);
var limit = cljs.core.nth.call(null,vec__31722,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_31710 = cljs.core.reduce.call(null,inst_31709,inst_31697,inst_31707);
var state_31718__$1 = state_31718;
var statearr_31725_31807 = state_31718__$1;
(statearr_31725_31807[(2)] = inst_31710);

(statearr_31725_31807[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (1))){
var state_31718__$1 = state_31718;
var statearr_31726_31808 = state_31718__$1;
(statearr_31726_31808[(2)] = null);

(statearr_31726_31808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (24))){
var inst_31597 = (state_31718[(9)]);
var inst_31597__$1 = (state_31718[(2)]);
var inst_31598 = flakes;
var inst_31599 = cljs.core.PersistentHashMap.EMPTY;
var inst_31600 = inst_31598;
var inst_31601 = inst_31597__$1;
var inst_31602 = inst_31599;
var state_31718__$1 = (function (){var statearr_31727 = state_31718;
(statearr_31727[(11)] = inst_31601);

(statearr_31727[(9)] = inst_31597__$1);

(statearr_31727[(12)] = inst_31602);

(statearr_31727[(13)] = inst_31600);

return statearr_31727;
})();
var statearr_31728_31809 = state_31718__$1;
(statearr_31728_31809[(2)] = null);

(statearr_31728_31809[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (39))){
var inst_31567 = (state_31718[(7)]);
var inst_31610 = (state_31718[(14)]);
var inst_31601 = (state_31718[(11)]);
var inst_31616 = (state_31718[(15)]);
var inst_31645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31646 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_31601,inst_31567,inst_31610,inst_31616,false);
var state_31718__$1 = (function (){var statearr_31729 = state_31718;
(statearr_31729[(16)] = inst_31645);

return statearr_31729;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31718__$1,(42),inst_31646);
} else {
if((state_val_31719 === (46))){
var inst_31610 = (state_31718[(14)]);
var inst_31602 = (state_31718[(12)]);
var inst_31600 = (state_31718[(13)]);
var inst_31663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31664 = ["_id"];
var inst_31665 = inst_31610.s;
var inst_31666 = [inst_31665];
var inst_31667 = cljs.core.PersistentHashMap.fromArrays(inst_31664,inst_31666);
var inst_31668 = cljs.core.rest.call(null,inst_31600);
var inst_31669 = [inst_31667,inst_31668,inst_31602];
var inst_31670 = (new cljs.core.PersistentVector(null,3,(5),inst_31663,inst_31669,null));
var state_31718__$1 = state_31718;
var statearr_31730_31810 = state_31718__$1;
(statearr_31730_31810[(2)] = inst_31670);

(statearr_31730_31810[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (4))){
var inst_31541 = (state_31718[(2)]);
var state_31718__$1 = state_31718;
var statearr_31731_31811 = state_31718__$1;
(statearr_31731_31811[(2)] = inst_31541);

(statearr_31731_31811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (15))){
var inst_31567 = (state_31718[(7)]);
var inst_31568 = (state_31718[(17)]);
var inst_31567__$1 = (state_31718[(2)]);
var inst_31568__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_31567__$1);
var state_31718__$1 = (function (){var statearr_31732 = state_31718;
(statearr_31732[(7)] = inst_31567__$1);

(statearr_31732[(17)] = inst_31568__$1);

return statearr_31732;
})();
if(cljs.core.truth_(inst_31568__$1)){
var statearr_31733_31812 = state_31718__$1;
(statearr_31733_31812[(1)] = (16));

} else {
var statearr_31734_31813 = state_31718__$1;
(statearr_31734_31813[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (48))){
var inst_31681 = (state_31718[(2)]);
var state_31718__$1 = state_31718;
var statearr_31735_31814 = state_31718__$1;
(statearr_31735_31814[(2)] = inst_31681);

(statearr_31735_31814[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (50))){
var state_31718__$1 = state_31718;
var statearr_31736_31815 = state_31718__$1;
(statearr_31736_31815[(2)] = null);

(statearr_31736_31815[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (21))){
var inst_31567 = (state_31718[(7)]);
var inst_31581 = (state_31718[(2)]);
var inst_31582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31583 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_31584 = (new cljs.core.PersistentVector(null,2,(5),inst_31582,inst_31583,null));
var inst_31585 = cljs.core.get_in.call(null,inst_31567,inst_31584);
var state_31718__$1 = (function (){var statearr_31737 = state_31718;
(statearr_31737[(10)] = inst_31581);

return statearr_31737;
})();
if(cljs.core.truth_(inst_31585)){
var statearr_31738_31816 = state_31718__$1;
(statearr_31738_31816[(1)] = (22));

} else {
var statearr_31739_31817 = state_31718__$1;
(statearr_31739_31817[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (31))){
var inst_31610 = (state_31718[(14)]);
var inst_31601 = (state_31718[(11)]);
var inst_31615 = (state_31718[(18)]);
var inst_31619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31620 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_31610,inst_31615,inst_31601,fuel,max_fuel,cache);
var state_31718__$1 = (function (){var statearr_31740 = state_31718;
(statearr_31740[(19)] = inst_31619);

return statearr_31740;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31718__$1,(34),inst_31620);
} else {
if((state_val_31719 === (32))){
var inst_31615 = (state_31718[(18)]);
var state_31718__$1 = state_31718;
if(cljs.core.truth_(inst_31615)){
var statearr_31741_31818 = state_31718__$1;
(statearr_31741_31818[(1)] = (35));

} else {
var statearr_31742_31819 = state_31718__$1;
(statearr_31742_31819[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (40))){
var inst_31567 = (state_31718[(7)]);
var inst_31655 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_31567);
var inst_31656 = cljs.core.empty_QMARK_.call(null,inst_31655);
var state_31718__$1 = state_31718;
if(inst_31656){
var statearr_31743_31820 = state_31718__$1;
(statearr_31743_31820[(1)] = (43));

} else {
var statearr_31744_31821 = state_31718__$1;
(statearr_31744_31821[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (33))){
var inst_31610 = (state_31718[(14)]);
var inst_31687 = (state_31718[(2)]);
var inst_31688 = cljs.core.nth.call(null,inst_31687,(0),null);
var inst_31689 = cljs.core.nth.call(null,inst_31687,(1),null);
var inst_31690 = cljs.core.nth.call(null,inst_31687,(2),null);
var inst_31691 = inst_31610.s;
var inst_31692 = cljs.core.assoc.call(null,inst_31688,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_31691);
var inst_31600 = inst_31689;
var inst_31601 = inst_31692;
var inst_31602 = inst_31690;
var state_31718__$1 = (function (){var statearr_31745 = state_31718;
(statearr_31745[(11)] = inst_31601);

(statearr_31745[(12)] = inst_31602);

(statearr_31745[(13)] = inst_31600);

return statearr_31745;
})();
var statearr_31746_31822 = state_31718__$1;
(statearr_31746_31822[(2)] = null);

(statearr_31746_31822[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (13))){
var inst_31561 = (state_31718[(8)]);
var inst_31564 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_31561);
var state_31718__$1 = state_31718;
var statearr_31747_31823 = state_31718__$1;
(statearr_31747_31823[(2)] = inst_31564);

(statearr_31747_31823[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (22))){
var inst_31567 = (state_31718[(7)]);
var inst_31587 = cljs.core.first.call(null,flakes);
var inst_31588 = fluree.db.query.fql.s.call(null,inst_31587);
var inst_31589 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_31567);
var inst_31590 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_31588,inst_31589);
var state_31718__$1 = state_31718;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31718__$1,(25),inst_31590);
} else {
if((state_val_31719 === (36))){
var inst_31567 = (state_31718[(7)]);
var inst_31643 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_31567);
var state_31718__$1 = state_31718;
if(cljs.core.truth_(inst_31643)){
var statearr_31748_31824 = state_31718__$1;
(statearr_31748_31824[(1)] = (39));

} else {
var statearr_31749_31825 = state_31718__$1;
(statearr_31749_31825[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (41))){
var inst_31683 = (state_31718[(2)]);
var state_31718__$1 = state_31718;
var statearr_31750_31826 = state_31718__$1;
(statearr_31750_31826[(2)] = inst_31683);

(statearr_31750_31826[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (43))){
var inst_31567 = (state_31718[(7)]);
var inst_31658 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_31567);
var state_31718__$1 = state_31718;
var statearr_31751_31827 = state_31718__$1;
(statearr_31751_31827[(2)] = inst_31658);

(statearr_31751_31827[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (29))){
var inst_31567 = (state_31718[(7)]);
var inst_31610 = (state_31718[(14)]);
var inst_31615 = (state_31718[(18)]);
var inst_31600 = (state_31718[(13)]);
var inst_31610__$1 = cljs.core.first.call(null,inst_31600);
var inst_31611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31612 = inst_31610__$1.p;
var inst_31613 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_31612];
var inst_31614 = (new cljs.core.PersistentVector(null,3,(5),inst_31611,inst_31613,null));
var inst_31615__$1 = cljs.core.get_in.call(null,inst_31567,inst_31614);
var inst_31616 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_31615__$1,inst_31567);
var inst_31617 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_31615__$1);
var state_31718__$1 = (function (){var statearr_31752 = state_31718;
(statearr_31752[(14)] = inst_31610__$1);

(statearr_31752[(18)] = inst_31615__$1);

(statearr_31752[(15)] = inst_31616);

return statearr_31752;
})();
if(cljs.core.truth_(inst_31617)){
var statearr_31753_31828 = state_31718__$1;
(statearr_31753_31828[(1)] = (31));

} else {
var statearr_31754_31829 = state_31718__$1;
(statearr_31754_31829[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (44))){
var state_31718__$1 = state_31718;
var statearr_31755_31830 = state_31718__$1;
(statearr_31755_31830[(2)] = false);

(statearr_31755_31830[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (6))){
var state_31718__$1 = state_31718;
var statearr_31756_31831 = state_31718__$1;
(statearr_31756_31831[(2)] = null);

(statearr_31756_31831[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (28))){
var inst_31601 = (state_31718[(11)]);
var state_31718__$1 = state_31718;
var statearr_31757_31832 = state_31718__$1;
(statearr_31757_31832[(2)] = inst_31601);

(statearr_31757_31832[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (51))){
var inst_31679 = (state_31718[(2)]);
var state_31718__$1 = state_31718;
var statearr_31758_31833 = state_31718__$1;
(statearr_31758_31833[(2)] = inst_31679);

(statearr_31758_31833[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (25))){
var inst_31581 = (state_31718[(10)]);
var inst_31592 = (state_31718[(2)]);
var inst_31593 = fluree.db.util.async.throw_err.call(null,inst_31592);
var inst_31594 = cljs.core.merge.call(null,inst_31581,inst_31593);
var state_31718__$1 = state_31718;
var statearr_31759_31834 = state_31718__$1;
(statearr_31759_31834[(2)] = inst_31594);

(statearr_31759_31834[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (34))){
var inst_31619 = (state_31718[(19)]);
var inst_31602 = (state_31718[(12)]);
var inst_31600 = (state_31718[(13)]);
var inst_31622 = (state_31718[(2)]);
var inst_31623 = fluree.db.util.async.throw_err.call(null,inst_31622);
var inst_31624 = cljs.core.rest.call(null,inst_31600);
var inst_31625 = [inst_31623,inst_31624,inst_31602];
var inst_31626 = (new cljs.core.PersistentVector(null,3,(5),inst_31619,inst_31625,null));
var state_31718__$1 = state_31718;
var statearr_31760_31835 = state_31718__$1;
(statearr_31760_31835[(2)] = inst_31626);

(statearr_31760_31835[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (17))){
var inst_31567 = (state_31718[(7)]);
var inst_31571 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_31567);
var state_31718__$1 = state_31718;
var statearr_31762_31836 = state_31718__$1;
(statearr_31762_31836[(2)] = inst_31571);

(statearr_31762_31836[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (3))){
var inst_31716 = (state_31718[(2)]);
var state_31718__$1 = state_31718;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31718__$1,inst_31716);
} else {
if((state_val_31719 === (12))){
var _ = (function (){var statearr_31763 = state_31718;
(statearr_31763[(4)] = cljs.core.rest.call(null,(state_31718[(4)])));

return statearr_31763;
})();
var state_31718__$1 = state_31718;
var ex31761 = (state_31718__$1[(2)]);
var statearr_31764_31837 = state_31718__$1;
(statearr_31764_31837[(5)] = ex31761);


var statearr_31765_31838 = state_31718__$1;
(statearr_31765_31838[(1)] = (11));

(statearr_31765_31838[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (2))){
var _ = (function (){var statearr_31766 = state_31718;
(statearr_31766[(4)] = cljs.core.cons.call(null,(5),(state_31718[(4)])));

return statearr_31766;
})();
var inst_31547 = cljs.core.not_empty.call(null,flakes);
var state_31718__$1 = state_31718;
if(cljs.core.truth_(inst_31547)){
var statearr_31767_31839 = state_31718__$1;
(statearr_31767_31839[(1)] = (6));

} else {
var statearr_31768_31840 = state_31718__$1;
(statearr_31768_31840[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (23))){
var inst_31581 = (state_31718[(10)]);
var state_31718__$1 = state_31718;
var statearr_31769_31841 = state_31718__$1;
(statearr_31769_31841[(2)] = inst_31581);

(statearr_31769_31841[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (47))){
var state_31718__$1 = state_31718;
var statearr_31770_31842 = state_31718__$1;
(statearr_31770_31842[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (35))){
var inst_31610 = (state_31718[(14)]);
var inst_31601 = (state_31718[(11)]);
var inst_31615 = (state_31718[(18)]);
var inst_31602 = (state_31718[(12)]);
var inst_31616 = (state_31718[(15)]);
var inst_31632 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_31601,inst_31615,inst_31610,inst_31616,false,inst_31602);
var state_31718__$1 = state_31718;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31718__$1,(38),inst_31632);
} else {
if((state_val_31719 === (19))){
var inst_31561 = (state_31718[(8)]);
var inst_31575 = ["_id"];
var inst_31576 = [inst_31561];
var inst_31577 = cljs.core.PersistentHashMap.fromArrays(inst_31575,inst_31576);
var state_31718__$1 = state_31718;
var statearr_31772_31843 = state_31718__$1;
(statearr_31772_31843[(2)] = inst_31577);

(statearr_31772_31843[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (11))){
var inst_31549 = (state_31718[(2)]);
var inst_31550 = fluree.db.util.log.error.call(null,inst_31549);
var inst_31551 = (function(){throw inst_31549})();
var state_31718__$1 = (function (){var statearr_31774 = state_31718;
(statearr_31774[(20)] = inst_31550);

return statearr_31774;
})();
var statearr_31775_31844 = state_31718__$1;
(statearr_31775_31844[(2)] = inst_31551);

(statearr_31775_31844[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (9))){
var _ = (function (){var statearr_31776 = state_31718;
(statearr_31776[(4)] = cljs.core.cons.call(null,(12),(state_31718[(4)])));

return statearr_31776;
})();
var inst_31557 = cljs.core.first.call(null,flakes);
var inst_31558 = fluree.db.query.fql.s.call(null,inst_31557);
var ___$1 = (function (){var statearr_31777 = state_31718;
(statearr_31777[(4)] = cljs.core.rest.call(null,(state_31718[(4)])));

return statearr_31777;
})();
var state_31718__$1 = state_31718;
var statearr_31778_31845 = state_31718__$1;
(statearr_31778_31845[(2)] = inst_31558);

(statearr_31778_31845[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (5))){
var _ = (function (){var statearr_31779 = state_31718;
(statearr_31779[(4)] = cljs.core.rest.call(null,(state_31718[(4)])));

return statearr_31779;
})();
var state_31718__$1 = state_31718;
var ex31773 = (state_31718__$1[(2)]);
var statearr_31780_31846 = state_31718__$1;
(statearr_31780_31846[(5)] = ex31773);


if((ex31773 instanceof Error)){
var statearr_31781_31847 = state_31718__$1;
(statearr_31781_31847[(1)] = (4));

(statearr_31781_31847[(5)] = null);

} else {
throw ex31773;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (14))){
var state_31718__$1 = state_31718;
var statearr_31782_31848 = state_31718__$1;
(statearr_31782_31848[(2)] = base_select_spec);

(statearr_31782_31848[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (45))){
var inst_31661 = (state_31718[(2)]);
var state_31718__$1 = state_31718;
if(cljs.core.truth_(inst_31661)){
var statearr_31783_31849 = state_31718__$1;
(statearr_31783_31849[(1)] = (46));

} else {
var statearr_31784_31850 = state_31718__$1;
(statearr_31784_31850[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (26))){
var inst_31600 = (state_31718[(13)]);
var inst_31604 = cljs.core.empty_QMARK_.call(null,inst_31600);
var state_31718__$1 = state_31718;
if(inst_31604){
var statearr_31785_31851 = state_31718__$1;
(statearr_31785_31851[(1)] = (28));

} else {
var statearr_31786_31852 = state_31718__$1;
(statearr_31786_31852[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (16))){
var inst_31568 = (state_31718[(17)]);
var state_31718__$1 = state_31718;
var statearr_31787_31853 = state_31718__$1;
(statearr_31787_31853[(2)] = inst_31568);

(statearr_31787_31853[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (38))){
var inst_31600 = (state_31718[(13)]);
var inst_31634 = (state_31718[(2)]);
var inst_31635 = fluree.db.util.async.throw_err.call(null,inst_31634);
var inst_31636 = cljs.core.nth.call(null,inst_31635,(0),null);
var inst_31637 = cljs.core.nth.call(null,inst_31635,(1),null);
var inst_31638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31639 = cljs.core.rest.call(null,inst_31600);
var inst_31640 = [inst_31636,inst_31639,inst_31637];
var inst_31641 = (new cljs.core.PersistentVector(null,3,(5),inst_31638,inst_31640,null));
var state_31718__$1 = state_31718;
var statearr_31788_31854 = state_31718__$1;
(statearr_31788_31854[(2)] = inst_31641);

(statearr_31788_31854[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (30))){
var inst_31695 = (state_31718[(2)]);
var state_31718__$1 = state_31718;
var statearr_31789_31855 = state_31718__$1;
(statearr_31789_31855[(2)] = inst_31695);

(statearr_31789_31855[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (10))){
var inst_31561 = (state_31718[(2)]);
var inst_31562 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_31718__$1 = (function (){var statearr_31790 = state_31718;
(statearr_31790[(8)] = inst_31561);

return statearr_31790;
})();
if(cljs.core.truth_(inst_31562)){
var statearr_31791_31856 = state_31718__$1;
(statearr_31791_31856[(1)] = (13));

} else {
var statearr_31792_31857 = state_31718__$1;
(statearr_31792_31857[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (18))){
var inst_31573 = (state_31718[(2)]);
var state_31718__$1 = state_31718;
if(cljs.core.truth_(inst_31573)){
var statearr_31793_31858 = state_31718__$1;
(statearr_31793_31858[(1)] = (19));

} else {
var statearr_31794_31859 = state_31718__$1;
(statearr_31794_31859[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (42))){
var inst_31645 = (state_31718[(16)]);
var inst_31602 = (state_31718[(12)]);
var inst_31600 = (state_31718[(13)]);
var inst_31648 = (state_31718[(2)]);
var inst_31649 = fluree.db.util.async.throw_err.call(null,inst_31648);
var inst_31650 = cljs.core.first.call(null,inst_31649);
var inst_31651 = cljs.core.rest.call(null,inst_31600);
var inst_31652 = [inst_31650,inst_31651,inst_31602];
var inst_31653 = (new cljs.core.PersistentVector(null,3,(5),inst_31645,inst_31652,null));
var state_31718__$1 = state_31718;
var statearr_31795_31860 = state_31718__$1;
(statearr_31795_31860[(2)] = inst_31653);

(statearr_31795_31860[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (37))){
var inst_31685 = (state_31718[(2)]);
var state_31718__$1 = state_31718;
var statearr_31796_31861 = state_31718__$1;
(statearr_31796_31861[(2)] = inst_31685);

(statearr_31796_31861[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (8))){
var inst_31713 = (state_31718[(2)]);
var _ = (function (){var statearr_31797 = state_31718;
(statearr_31797[(4)] = cljs.core.rest.call(null,(state_31718[(4)])));

return statearr_31797;
})();
var state_31718__$1 = state_31718;
var statearr_31798_31862 = state_31718__$1;
(statearr_31798_31862[(2)] = inst_31713);

(statearr_31798_31862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31719 === (49))){
var inst_31601 = (state_31718[(11)]);
var inst_31602 = (state_31718[(12)]);
var inst_31600 = (state_31718[(13)]);
var inst_31673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31674 = cljs.core.rest.call(null,inst_31600);
var inst_31675 = [inst_31601,inst_31674,inst_31602];
var inst_31676 = (new cljs.core.PersistentVector(null,3,(5),inst_31673,inst_31675,null));
var state_31718__$1 = state_31718;
var statearr_31799_31863 = state_31718__$1;
(statearr_31799_31863[(2)] = inst_31676);

(statearr_31799_31863[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__11469__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__11469__auto____0 = (function (){
var statearr_31800 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31800[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__11469__auto__);

(statearr_31800[(1)] = (1));

return statearr_31800;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__11469__auto____1 = (function (state_31718){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_31718);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e31801){var ex__11472__auto__ = e31801;
var statearr_31802_31864 = state_31718;
(statearr_31802_31864[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_31718[(4)]))){
var statearr_31803_31865 = state_31718;
(statearr_31803_31865[(1)] = cljs.core.first.call(null,(state_31718[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31866 = state_31718;
state_31718 = G__31866;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__11469__auto__ = function(state_31718){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__11469__auto____1.call(this,state_31718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__11469__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__11469__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_31804 = f__11543__auto__.call(null);
(statearr_31804[(6)] = c__11542__auto__);

return statearr_31804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__31869 = arguments.length;
switch (G__31869) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_31911){
var state_val_31912 = (state_31911[(1)]);
if((state_val_31912 === (7))){
var inst_31877 = (state_31911[(7)]);
var state_31911__$1 = state_31911;
var statearr_31913_31943 = state_31911__$1;
(statearr_31913_31943[(2)] = inst_31877);

(statearr_31913_31943[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31912 === (1))){
var state_31911__$1 = state_31911;
var statearr_31914_31944 = state_31911__$1;
(statearr_31914_31944[(2)] = null);

(statearr_31914_31944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31912 === (4))){
var inst_31870 = (state_31911[(2)]);
var state_31911__$1 = state_31911;
var statearr_31915_31945 = state_31911__$1;
(statearr_31915_31945[(2)] = inst_31870);

(statearr_31915_31945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31912 === (15))){
var inst_31905 = (state_31911[(2)]);
var inst_31906 = fluree.db.util.async.throw_err.call(null,inst_31905);
var _ = (function (){var statearr_31916 = state_31911;
(statearr_31916[(4)] = cljs.core.rest.call(null,(state_31911[(4)])));

return statearr_31916;
})();
var state_31911__$1 = state_31911;
var statearr_31917_31946 = state_31911__$1;
(statearr_31917_31946[(2)] = inst_31906);

(statearr_31917_31946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31912 === (13))){
var inst_31889 = (state_31911[(8)]);
var state_31911__$1 = state_31911;
var statearr_31918_31947 = state_31911__$1;
(statearr_31918_31947[(2)] = inst_31889);

(statearr_31918_31947[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31912 === (6))){
var inst_31877 = (state_31911[(7)]);
var inst_31879 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_31880 = cljs.core.comp.call(null,inst_31877,inst_31879);
var state_31911__$1 = state_31911;
var statearr_31919_31948 = state_31911__$1;
(statearr_31919_31948[(2)] = inst_31880);

(statearr_31919_31948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31912 === (3))){
var inst_31909 = (state_31911[(2)]);
var state_31911__$1 = state_31911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31911__$1,inst_31909);
} else {
if((state_val_31912 === (12))){
var inst_31889 = (state_31911[(8)]);
var inst_31891 = cljs.core.take.call(null,limit);
var inst_31892 = cljs.core.comp.call(null,inst_31889,inst_31891);
var state_31911__$1 = state_31911;
var statearr_31920_31949 = state_31911__$1;
(statearr_31920_31949[(2)] = inst_31892);

(statearr_31920_31949[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31912 === (2))){
var _ = (function (){var statearr_31921 = state_31911;
(statearr_31921[(4)] = cljs.core.cons.call(null,(5),(state_31911[(4)])));

return statearr_31921;
})();
var inst_31877 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_31911__$1 = (function (){var statearr_31922 = state_31911;
(statearr_31922[(7)] = inst_31877);

return statearr_31922;
})();
if(cljs.core.truth_(fuel)){
var statearr_31923_31950 = state_31911__$1;
(statearr_31923_31950[(1)] = (6));

} else {
var statearr_31924_31951 = state_31911__$1;
(statearr_31924_31951[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31912 === (11))){
var inst_31889 = (state_31911[(2)]);
var state_31911__$1 = (function (){var statearr_31926 = state_31911;
(statearr_31926[(8)] = inst_31889);

return statearr_31926;
})();
if(cljs.core.truth_(limit)){
var statearr_31927_31952 = state_31911__$1;
(statearr_31927_31952[(1)] = (12));

} else {
var statearr_31928_31953 = state_31911__$1;
(statearr_31928_31953[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31912 === (9))){
var inst_31883 = (state_31911[(9)]);
var inst_31885 = cljs.core.drop.call(null,offset);
var inst_31886 = cljs.core.comp.call(null,inst_31883,inst_31885);
var state_31911__$1 = state_31911;
var statearr_31929_31954 = state_31911__$1;
(statearr_31929_31954[(2)] = inst_31886);

(statearr_31929_31954[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31912 === (5))){
var _ = (function (){var statearr_31930 = state_31911;
(statearr_31930[(4)] = cljs.core.rest.call(null,(state_31911[(4)])));

return statearr_31930;
})();
var state_31911__$1 = state_31911;
var ex31925 = (state_31911__$1[(2)]);
var statearr_31931_31955 = state_31911__$1;
(statearr_31931_31955[(5)] = ex31925);


if((ex31925 instanceof Error)){
var statearr_31932_31956 = state_31911__$1;
(statearr_31932_31956[(1)] = (4));

(statearr_31932_31956[(5)] = null);

} else {
throw ex31925;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31912 === (14))){
var inst_31895 = (state_31911[(2)]);
var inst_31896 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_31897 = cljs.core.halt_when.call(null,inst_31896);
var inst_31898 = cljs.core.comp.call(null,inst_31895,inst_31897);
var inst_31899 = cljs.core.sequence.call(null,inst_31898,flakes);
var inst_31900 = cljs.core.PersistentVector.EMPTY;
var inst_31901 = (function (){var xf = inst_31898;
var flakes_by_sub = inst_31899;
return (function (p1__31867_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__31867_SHARP_);
});
})();
var inst_31902 = cljs.core.map.call(null,inst_31901,inst_31899);
var inst_31903 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_31900,inst_31902);
var state_31911__$1 = state_31911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31911__$1,(15),inst_31903);
} else {
if((state_val_31912 === (10))){
var inst_31883 = (state_31911[(9)]);
var state_31911__$1 = state_31911;
var statearr_31933_31957 = state_31911__$1;
(statearr_31933_31957[(2)] = inst_31883);

(statearr_31933_31957[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31912 === (8))){
var inst_31883 = (state_31911[(2)]);
var state_31911__$1 = (function (){var statearr_31934 = state_31911;
(statearr_31934[(9)] = inst_31883);

return statearr_31934;
})();
if(cljs.core.truth_(offset)){
var statearr_31935_31958 = state_31911__$1;
(statearr_31935_31958[(1)] = (9));

} else {
var statearr_31936_31959 = state_31911__$1;
(statearr_31936_31959[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11469__auto__ = null;
var fluree$db$query$fql$state_machine__11469__auto____0 = (function (){
var statearr_31937 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31937[(0)] = fluree$db$query$fql$state_machine__11469__auto__);

(statearr_31937[(1)] = (1));

return statearr_31937;
});
var fluree$db$query$fql$state_machine__11469__auto____1 = (function (state_31911){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_31911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e31938){var ex__11472__auto__ = e31938;
var statearr_31939_31960 = state_31911;
(statearr_31939_31960[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_31911[(4)]))){
var statearr_31940_31961 = state_31911;
(statearr_31940_31961[(1)] = cljs.core.first.call(null,(state_31911[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31962 = state_31911;
state_31911 = G__31962;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11469__auto__ = function(state_31911){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11469__auto____1.call(this,state_31911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11469__auto____0;
fluree$db$query$fql$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11469__auto____1;
return fluree$db$query$fql$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_31941 = f__11543__auto__.call(null);
(statearr_31941[(6)] = c__11542__auto__);

return statearr_31941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__31964 = arguments.length;
switch (G__31964) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_32048){
var state_val_32049 = (state_32048[(1)]);
if((state_val_32049 === (7))){
var inst_32043 = (state_32048[(2)]);
var _ = (function (){var statearr_32051 = state_32048;
(statearr_32051[(4)] = cljs.core.rest.call(null,(state_32048[(4)])));

return statearr_32051;
})();
var state_32048__$1 = state_32048;
var statearr_32052_32099 = state_32048__$1;
(statearr_32052_32099[(2)] = inst_32043);

(statearr_32052_32099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (20))){
var inst_31984 = (state_32048[(7)]);
var inst_31992 = (state_32048[(8)]);
var inst_31985 = (state_32048[(9)]);
var inst_32013 = (inst_31984 + (1));
var tmp32050 = inst_31985;
var inst_31983 = inst_31992;
var inst_31984__$1 = inst_32013;
var inst_31985__$1 = tmp32050;
var state_32048__$1 = (function (){var statearr_32053 = state_32048;
(statearr_32053[(7)] = inst_31984__$1);

(statearr_32053[(9)] = inst_31985__$1);

(statearr_32053[(10)] = inst_31983);

return statearr_32053;
})();
var statearr_32054_32100 = state_32048__$1;
(statearr_32054_32100[(2)] = null);

(statearr_32054_32100[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (27))){
var inst_32018 = (state_32048[(11)]);
var inst_32027 = (state_32048[(2)]);
var inst_32028 = fluree.db.util.async.throw_err.call(null,inst_32027);
var inst_32029 = inst_32018.call(null,inst_32028);
var state_32048__$1 = state_32048;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32048__$1,(26),inst_32029);
} else {
if((state_val_32049 === (1))){
var state_32048__$1 = state_32048;
var statearr_32055_32101 = state_32048__$1;
(statearr_32055_32101[(2)] = null);

(statearr_32055_32101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (24))){
var state_32048__$1 = state_32048;
var statearr_32056_32102 = state_32048__$1;
(statearr_32056_32102[(2)] = null);

(statearr_32056_32102[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (4))){
var inst_31965 = (state_32048[(2)]);
var state_32048__$1 = state_32048;
var statearr_32057_32103 = state_32048__$1;
(statearr_32057_32103[(2)] = inst_31965);

(statearr_32057_32103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (15))){
var inst_32006 = (state_32048[(12)]);
var inst_32006__$1 = offset;
var state_32048__$1 = (function (){var statearr_32058 = state_32048;
(statearr_32058[(12)] = inst_32006__$1);

return statearr_32058;
})();
if(cljs.core.truth_(inst_32006__$1)){
var statearr_32059_32104 = state_32048__$1;
(statearr_32059_32104[(1)] = (17));

} else {
var statearr_32060_32105 = state_32048__$1;
(statearr_32060_32105[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (21))){
var state_32048__$1 = state_32048;
var statearr_32061_32106 = state_32048__$1;
(statearr_32061_32106[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (13))){
var inst_32001 = (state_32048[(2)]);
var state_32048__$1 = state_32048;
var statearr_32063_32107 = state_32048__$1;
(statearr_32063_32107[(2)] = inst_32001);

(statearr_32063_32107[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (22))){
var inst_32039 = (state_32048[(2)]);
var state_32048__$1 = state_32048;
var statearr_32064_32108 = state_32048__$1;
(statearr_32064_32108[(2)] = inst_32039);

(statearr_32064_32108[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (6))){
var inst_31991 = (state_32048[(13)]);
var inst_31993 = (state_32048[(14)]);
var inst_31983 = (state_32048[(10)]);
var inst_31990 = cljs.core.seq.call(null,inst_31983);
var inst_31991__$1 = cljs.core.first.call(null,inst_31990);
var inst_31992 = cljs.core.next.call(null,inst_31990);
var inst_31993__$1 = (inst_31991__$1 == null);
var state_32048__$1 = (function (){var statearr_32065 = state_32048;
(statearr_32065[(8)] = inst_31992);

(statearr_32065[(13)] = inst_31991__$1);

(statearr_32065[(14)] = inst_31993__$1);

return statearr_32065;
})();
if(cljs.core.truth_(inst_31993__$1)){
var statearr_32066_32109 = state_32048__$1;
(statearr_32066_32109[(1)] = (8));

} else {
var statearr_32067_32110 = state_32048__$1;
(statearr_32067_32110[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (25))){
var inst_32037 = (state_32048[(2)]);
var state_32048__$1 = state_32048;
var statearr_32068_32111 = state_32048__$1;
(statearr_32068_32111[(2)] = inst_32037);

(statearr_32068_32111[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (17))){
var inst_31984 = (state_32048[(7)]);
var inst_32008 = (inst_31984 < offset);
var state_32048__$1 = state_32048;
var statearr_32069_32112 = state_32048__$1;
(statearr_32069_32112[(2)] = inst_32008);

(statearr_32069_32112[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (3))){
var inst_32046 = (state_32048[(2)]);
var state_32048__$1 = state_32048;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32048__$1,inst_32046);
} else {
if((state_val_32049 === (12))){
var inst_31996 = (state_32048[(15)]);
var state_32048__$1 = state_32048;
var statearr_32070_32113 = state_32048__$1;
(statearr_32070_32113[(2)] = inst_31996);

(statearr_32070_32113[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (2))){
var inst_31978 = (state_32048[(16)]);
var _ = (function (){var statearr_32071 = state_32048;
(statearr_32071[(4)] = cljs.core.cons.call(null,(5),(state_32048[(4)])));

return statearr_32071;
})();
var inst_31978__$1 = subjects;
var inst_31979 = cljs.core.seq.call(null,inst_31978__$1);
var inst_31980 = cljs.core.first.call(null,inst_31979);
var inst_31981 = cljs.core.next.call(null,inst_31979);
var inst_31982 = cljs.core.PersistentVector.EMPTY;
var inst_31983 = inst_31978__$1;
var inst_31984 = (0);
var inst_31985 = inst_31982;
var state_32048__$1 = (function (){var statearr_32072 = state_32048;
(statearr_32072[(17)] = inst_31980);

(statearr_32072[(7)] = inst_31984);

(statearr_32072[(16)] = inst_31978__$1);

(statearr_32072[(9)] = inst_31985);

(statearr_32072[(18)] = inst_31981);

(statearr_32072[(10)] = inst_31983);

return statearr_32072;
})();
var statearr_32073_32114 = state_32048__$1;
(statearr_32073_32114[(2)] = null);

(statearr_32073_32114[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (23))){
var inst_31980 = (state_32048[(17)]);
var inst_31984 = (state_32048[(7)]);
var inst_31992 = (state_32048[(8)]);
var inst_31991 = (state_32048[(13)]);
var inst_31978 = (state_32048[(16)]);
var inst_31985 = (state_32048[(9)]);
var inst_31981 = (state_32048[(18)]);
var inst_31983 = (state_32048[(10)]);
var inst_32017 = (inst_31984 + (1));
var inst_32018 = (function (){var first__31989 = inst_31991;
var r = inst_31992;
var seq__31988 = inst_31992;
var G__31974 = inst_31983;
var acc = inst_31985;
var n = inst_31984;
var s = inst_31991;
var first__31977 = inst_31980;
var vec__31975 = inst_31978;
var seq__31976 = inst_31981;
var vec__31987 = inst_31983;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_32019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32020 = [inst_31991];
var inst_32021 = (new cljs.core.PersistentVector(null,1,(5),inst_32019,inst_32020,null));
var inst_32022 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_32023 = [limit];
var inst_32024 = cljs.core.PersistentHashMap.fromArrays(inst_32022,inst_32023);
var inst_32025 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_32021,inst_32024);
var state_32048__$1 = (function (){var statearr_32074 = state_32048;
(statearr_32074[(11)] = inst_32018);

(statearr_32074[(19)] = inst_32017);

return statearr_32074;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32048__$1,(27),inst_32025);
} else {
if((state_val_32049 === (19))){
var inst_32011 = (state_32048[(2)]);
var state_32048__$1 = state_32048;
if(cljs.core.truth_(inst_32011)){
var statearr_32075_32115 = state_32048__$1;
(statearr_32075_32115[(1)] = (20));

} else {
var statearr_32076_32116 = state_32048__$1;
(statearr_32076_32116[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (11))){
var inst_31984 = (state_32048[(7)]);
var inst_31998 = (inst_31984 > limit);
var state_32048__$1 = state_32048;
var statearr_32078_32117 = state_32048__$1;
(statearr_32078_32117[(2)] = inst_31998);

(statearr_32078_32117[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (9))){
var inst_31996 = (state_32048[(15)]);
var inst_31996__$1 = limit;
var state_32048__$1 = (function (){var statearr_32079 = state_32048;
(statearr_32079[(15)] = inst_31996__$1);

return statearr_32079;
})();
if(cljs.core.truth_(inst_31996__$1)){
var statearr_32080_32118 = state_32048__$1;
(statearr_32080_32118[(1)] = (11));

} else {
var statearr_32081_32119 = state_32048__$1;
(statearr_32081_32119[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (5))){
var _ = (function (){var statearr_32082 = state_32048;
(statearr_32082[(4)] = cljs.core.rest.call(null,(state_32048[(4)])));

return statearr_32082;
})();
var state_32048__$1 = state_32048;
var ex32077 = (state_32048__$1[(2)]);
var statearr_32083_32120 = state_32048__$1;
(statearr_32083_32120[(5)] = ex32077);


if((ex32077 instanceof Error)){
var statearr_32084_32121 = state_32048__$1;
(statearr_32084_32121[(1)] = (4));

(statearr_32084_32121[(5)] = null);

} else {
throw ex32077;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (14))){
var inst_31985 = (state_32048[(9)]);
var state_32048__$1 = state_32048;
var statearr_32085_32122 = state_32048__$1;
(statearr_32085_32122[(2)] = inst_31985);

(statearr_32085_32122[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (26))){
var inst_32017 = (state_32048[(19)]);
var inst_31992 = (state_32048[(8)]);
var inst_31985 = (state_32048[(9)]);
var inst_32031 = (state_32048[(2)]);
var inst_32032 = fluree.db.util.async.throw_err.call(null,inst_32031);
var inst_32033 = cljs.core.conj.call(null,inst_31985,inst_32032);
var inst_31983 = inst_31992;
var inst_31984 = inst_32017;
var inst_31985__$1 = inst_32033;
var state_32048__$1 = (function (){var statearr_32086 = state_32048;
(statearr_32086[(7)] = inst_31984);

(statearr_32086[(9)] = inst_31985__$1);

(statearr_32086[(10)] = inst_31983);

return statearr_32086;
})();
var statearr_32087_32123 = state_32048__$1;
(statearr_32087_32123[(2)] = null);

(statearr_32087_32123[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (16))){
var inst_32041 = (state_32048[(2)]);
var state_32048__$1 = state_32048;
var statearr_32088_32124 = state_32048__$1;
(statearr_32088_32124[(2)] = inst_32041);

(statearr_32088_32124[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (10))){
var inst_32003 = (state_32048[(2)]);
var state_32048__$1 = state_32048;
if(cljs.core.truth_(inst_32003)){
var statearr_32089_32125 = state_32048__$1;
(statearr_32089_32125[(1)] = (14));

} else {
var statearr_32090_32126 = state_32048__$1;
(statearr_32090_32126[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (18))){
var inst_32006 = (state_32048[(12)]);
var state_32048__$1 = state_32048;
var statearr_32091_32127 = state_32048__$1;
(statearr_32091_32127[(2)] = inst_32006);

(statearr_32091_32127[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32049 === (8))){
var inst_31993 = (state_32048[(14)]);
var state_32048__$1 = state_32048;
var statearr_32092_32128 = state_32048__$1;
(statearr_32092_32128[(2)] = inst_31993);

(statearr_32092_32128[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11469__auto__ = null;
var fluree$db$query$fql$state_machine__11469__auto____0 = (function (){
var statearr_32093 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32093[(0)] = fluree$db$query$fql$state_machine__11469__auto__);

(statearr_32093[(1)] = (1));

return statearr_32093;
});
var fluree$db$query$fql$state_machine__11469__auto____1 = (function (state_32048){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_32048);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e32094){var ex__11472__auto__ = e32094;
var statearr_32095_32129 = state_32048;
(statearr_32095_32129[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_32048[(4)]))){
var statearr_32096_32130 = state_32048;
(statearr_32096_32130[(1)] = cljs.core.first.call(null,(state_32048[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32131 = state_32048;
state_32048 = G__32131;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11469__auto__ = function(state_32048){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11469__auto____1.call(this,state_32048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11469__auto____0;
fluree$db$query$fql$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11469__auto____1;
return fluree$db$query$fql$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_32097 = f__11543__auto__.call(null);
(statearr_32097[(6)] = c__11542__auto__);

return statearr_32097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__32133 = arguments.length;
switch (G__32133) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_32321){
var state_val_32322 = (state_32321[(1)]);
if((state_val_32322 === (7))){
var state_32321__$1 = state_32321;
var statearr_32323_32394 = state_32321__$1;
(statearr_32323_32394[(2)] = null);

(statearr_32323_32394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (20))){
var inst_32176 = (state_32321[(7)]);
var inst_32174 = (state_32321[(8)]);
var inst_32204 = (state_32321[(2)]);
var inst_32205 = fluree.db.util.async.throw_err.call(null,inst_32204);
var inst_32206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32207 = [inst_32174];
var inst_32208 = (new cljs.core.PersistentVector(null,1,(5),inst_32206,inst_32207,null));
var inst_32209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32210 = [inst_32174,inst_32176];
var inst_32211 = (new cljs.core.PersistentVector(null,2,(5),inst_32209,inst_32210,null));
var inst_32212 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_32208,cljs.core._LT_,inst_32211);
var state_32321__$1 = (function (){var statearr_32324 = state_32321;
(statearr_32324[(9)] = inst_32205);

return statearr_32324;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32321__$1,(21),inst_32212);
} else {
if((state_val_32322 === (27))){
var inst_32175 = (state_32321[(10)]);
var inst_32193 = (state_32321[(11)]);
var inst_32241 = inst_32193.call(null,cljs.core._GT__EQ_,inst_32175);
var state_32321__$1 = state_32321;
if(cljs.core.truth_(inst_32241)){
var statearr_32325_32395 = state_32321__$1;
(statearr_32325_32395[(1)] = (30));

} else {
var statearr_32326_32396 = state_32321__$1;
(statearr_32326_32396[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (1))){
var state_32321__$1 = state_32321;
var statearr_32327_32397 = state_32321__$1;
(statearr_32327_32397[(2)] = null);

(statearr_32327_32397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (24))){
var inst_32290 = (state_32321[(2)]);
var state_32321__$1 = state_32321;
var statearr_32328_32398 = state_32321__$1;
(statearr_32328_32398[(2)] = inst_32290);

(statearr_32328_32398[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (39))){
var inst_32280 = null;
var state_32321__$1 = state_32321;
var statearr_32329_32399 = state_32321__$1;
(statearr_32329_32399[(2)] = inst_32280);

(statearr_32329_32399[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (46))){
var inst_32301 = (state_32321[(12)]);
var inst_32167 = (state_32321[(13)]);
var inst_32159 = inst_32167;
var inst_32160 = inst_32301;
var state_32321__$1 = (function (){var statearr_32330 = state_32321;
(statearr_32330[(14)] = inst_32160);

(statearr_32330[(15)] = inst_32159);

return statearr_32330;
})();
var statearr_32331_32400 = state_32321__$1;
(statearr_32331_32400[(2)] = null);

(statearr_32331_32400[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (4))){
var inst_32134 = (state_32321[(2)]);
var state_32321__$1 = state_32321;
var statearr_32332_32401 = state_32321__$1;
(statearr_32332_32401[(2)] = inst_32134);

(statearr_32332_32401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (15))){
var state_32321__$1 = state_32321;
var statearr_32333_32402 = state_32321__$1;
(statearr_32333_32402[(2)] = null);

(statearr_32333_32402[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (21))){
var inst_32205 = (state_32321[(9)]);
var inst_32214 = (state_32321[(2)]);
var inst_32215 = fluree.db.util.async.throw_err.call(null,inst_32214);
var inst_32216 = cljs.core.concat.call(null,inst_32205,inst_32215);
var state_32321__$1 = state_32321;
var statearr_32334_32403 = state_32321__$1;
(statearr_32334_32403[(2)] = inst_32216);

(statearr_32334_32403[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (31))){
var inst_32175 = (state_32321[(10)]);
var inst_32193 = (state_32321[(11)]);
var inst_32254 = inst_32193.call(null,cljs.core._LT_,inst_32175);
var state_32321__$1 = state_32321;
if(cljs.core.truth_(inst_32254)){
var statearr_32335_32404 = state_32321__$1;
(statearr_32335_32404[(1)] = (34));

} else {
var statearr_32336_32405 = state_32321__$1;
(statearr_32336_32405[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (32))){
var inst_32286 = (state_32321[(2)]);
var state_32321__$1 = state_32321;
var statearr_32337_32406 = state_32321__$1;
(statearr_32337_32406[(2)] = inst_32286);

(statearr_32337_32406[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (40))){
var inst_32282 = (state_32321[(2)]);
var state_32321__$1 = state_32321;
var statearr_32338_32407 = state_32321__$1;
(statearr_32338_32407[(2)] = inst_32282);

(statearr_32338_32407[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (33))){
var inst_32251 = (state_32321[(2)]);
var inst_32252 = fluree.db.util.async.throw_err.call(null,inst_32251);
var state_32321__$1 = state_32321;
var statearr_32339_32408 = state_32321__$1;
(statearr_32339_32408[(2)] = inst_32252);

(statearr_32339_32408[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (13))){
var inst_32311 = (state_32321[(2)]);
var state_32321__$1 = state_32321;
var statearr_32340_32409 = state_32321__$1;
(statearr_32340_32409[(2)] = inst_32311);

(statearr_32340_32409[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (22))){
var inst_32176 = (state_32321[(7)]);
var inst_32174 = (state_32321[(8)]);
var inst_32220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32221 = [inst_32174,inst_32176];
var inst_32222 = (new cljs.core.PersistentVector(null,2,(5),inst_32220,inst_32221,null));
var inst_32223 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_32222);
var state_32321__$1 = state_32321;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32321__$1,(25),inst_32223);
} else {
if((state_val_32322 === (36))){
var inst_32284 = (state_32321[(2)]);
var state_32321__$1 = state_32321;
var statearr_32341_32410 = state_32321__$1;
(statearr_32341_32410[(2)] = inst_32284);

(statearr_32341_32410[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (41))){
var inst_32277 = (state_32321[(2)]);
var inst_32278 = fluree.db.util.async.throw_err.call(null,inst_32277);
var state_32321__$1 = state_32321;
var statearr_32342_32411 = state_32321__$1;
(statearr_32342_32411[(2)] = inst_32278);

(statearr_32342_32411[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (43))){
var inst_32160 = (state_32321[(14)]);
var inst_32293 = (state_32321[(16)]);
var inst_32294 = cljs.core.into.call(null,inst_32160,inst_32293);
var state_32321__$1 = state_32321;
var statearr_32343_32412 = state_32321__$1;
(statearr_32343_32412[(2)] = inst_32294);

(statearr_32343_32412[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (29))){
var inst_32238 = (state_32321[(2)]);
var inst_32239 = fluree.db.util.async.throw_err.call(null,inst_32238);
var state_32321__$1 = state_32321;
var statearr_32344_32413 = state_32321__$1;
(statearr_32344_32413[(2)] = inst_32239);

(statearr_32344_32413[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (44))){
var inst_32160 = (state_32321[(14)]);
var inst_32293 = (state_32321[(16)]);
var inst_32296 = cljs.core.PersistentHashSet.EMPTY;
var inst_32297 = cljs.core.into.call(null,inst_32296,inst_32293);
var inst_32298 = clojure.set.intersection.call(null,inst_32160,inst_32297);
var state_32321__$1 = state_32321;
var statearr_32345_32414 = state_32321__$1;
(statearr_32345_32414[(2)] = inst_32298);

(statearr_32345_32414[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (6))){
var inst_32145 = (state_32321[(17)]);
var inst_32155 = cljs.core.seq.call(null,inst_32145);
var inst_32156 = cljs.core.first.call(null,inst_32155);
var inst_32157 = cljs.core.next.call(null,inst_32155);
var inst_32158 = cljs.core.PersistentHashSet.EMPTY;
var inst_32159 = inst_32145;
var inst_32160 = inst_32158;
var state_32321__$1 = (function (){var statearr_32346 = state_32321;
(statearr_32346[(14)] = inst_32160);

(statearr_32346[(18)] = inst_32157);

(statearr_32346[(19)] = inst_32156);

(statearr_32346[(15)] = inst_32159);

return statearr_32346;
})();
var statearr_32347_32415 = state_32321__$1;
(statearr_32347_32415[(2)] = null);

(statearr_32347_32415[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (28))){
var inst_32288 = (state_32321[(2)]);
var state_32321__$1 = state_32321;
var statearr_32348_32416 = state_32321__$1;
(statearr_32348_32416[(2)] = inst_32288);

(statearr_32348_32416[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (25))){
var inst_32225 = (state_32321[(2)]);
var inst_32226 = fluree.db.util.async.throw_err.call(null,inst_32225);
var state_32321__$1 = state_32321;
var statearr_32349_32417 = state_32321__$1;
(statearr_32349_32417[(2)] = inst_32226);

(statearr_32349_32417[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (34))){
var inst_32176 = (state_32321[(7)]);
var inst_32174 = (state_32321[(8)]);
var inst_32256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32257 = [inst_32174];
var inst_32258 = (new cljs.core.PersistentVector(null,1,(5),inst_32256,inst_32257,null));
var inst_32259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32260 = [inst_32174,inst_32176];
var inst_32261 = (new cljs.core.PersistentVector(null,2,(5),inst_32259,inst_32260,null));
var inst_32262 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_32258,cljs.core._LT_,inst_32261);
var state_32321__$1 = state_32321;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32321__$1,(37),inst_32262);
} else {
if((state_val_32322 === (17))){
var inst_32176 = (state_32321[(7)]);
var inst_32174 = (state_32321[(8)]);
var inst_32196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32197 = [inst_32174,inst_32176];
var inst_32198 = (new cljs.core.PersistentVector(null,2,(5),inst_32196,inst_32197,null));
var inst_32199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32200 = [inst_32174];
var inst_32201 = (new cljs.core.PersistentVector(null,1,(5),inst_32199,inst_32200,null));
var inst_32202 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_32198,cljs.core._LT__EQ_,inst_32201);
var state_32321__$1 = state_32321;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32321__$1,(20),inst_32202);
} else {
if((state_val_32322 === (3))){
var inst_32319 = (state_32321[(2)]);
var state_32321__$1 = state_32321;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32321__$1,inst_32319);
} else {
if((state_val_32322 === (12))){
var inst_32166 = (state_32321[(20)]);
var inst_32174 = (state_32321[(8)]);
var inst_32174__$1 = cljs.core.nth.call(null,inst_32166,(0),null);
var inst_32175 = cljs.core.nth.call(null,inst_32166,(1),null);
var inst_32176 = cljs.core.nth.call(null,inst_32166,(2),null);
var inst_32177 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_32174__$1);
var inst_32178 = cljs.core.not.call(null,inst_32177);
var state_32321__$1 = (function (){var statearr_32350 = state_32321;
(statearr_32350[(7)] = inst_32176);

(statearr_32350[(10)] = inst_32175);

(statearr_32350[(8)] = inst_32174__$1);

return statearr_32350;
})();
if(inst_32178){
var statearr_32351_32418 = state_32321__$1;
(statearr_32351_32418[(1)] = (14));

} else {
var statearr_32352_32419 = state_32321__$1;
(statearr_32352_32419[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (2))){
var inst_32145 = (state_32321[(17)]);
var _ = (function (){var statearr_32353 = state_32321;
(statearr_32353[(4)] = cljs.core.cons.call(null,(5),(state_32321[(4)])));

return statearr_32353;
})();
var inst_32143 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_32144 = cljs.core.nth.call(null,inst_32143,(0),null);
var inst_32145__$1 = cljs.core.nth.call(null,inst_32143,(1),null);
var inst_32146 = cljs.core.not_empty.call(null,inst_32145__$1);
var state_32321__$1 = (function (){var statearr_32354 = state_32321;
(statearr_32354[(21)] = inst_32144);

(statearr_32354[(17)] = inst_32145__$1);

return statearr_32354;
})();
if(cljs.core.truth_(inst_32146)){
var statearr_32355_32420 = state_32321__$1;
(statearr_32355_32420[(1)] = (6));

} else {
var statearr_32356_32421 = state_32321__$1;
(statearr_32356_32421[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (23))){
var inst_32175 = (state_32321[(10)]);
var inst_32193 = (state_32321[(11)]);
var inst_32228 = inst_32193.call(null,cljs.core._GT_,inst_32175);
var state_32321__$1 = state_32321;
if(cljs.core.truth_(inst_32228)){
var statearr_32357_32422 = state_32321__$1;
(statearr_32357_32422[(1)] = (26));

} else {
var statearr_32358_32423 = state_32321__$1;
(statearr_32358_32423[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (47))){
var inst_32309 = (state_32321[(2)]);
var state_32321__$1 = state_32321;
var statearr_32359_32424 = state_32321__$1;
(statearr_32359_32424[(2)] = inst_32309);

(statearr_32359_32424[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (35))){
var inst_32175 = (state_32321[(10)]);
var inst_32193 = (state_32321[(11)]);
var inst_32267 = inst_32193.call(null,cljs.core._LT__EQ_,inst_32175);
var state_32321__$1 = state_32321;
if(cljs.core.truth_(inst_32267)){
var statearr_32360_32425 = state_32321__$1;
(statearr_32360_32425[(1)] = (38));

} else {
var statearr_32361_32426 = state_32321__$1;
(statearr_32361_32426[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (19))){
var inst_32144 = (state_32321[(21)]);
var inst_32292 = (state_32321[(2)]);
var inst_32293 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_32292);
var state_32321__$1 = (function (){var statearr_32362 = state_32321;
(statearr_32362[(16)] = inst_32293);

return statearr_32362;
})();
var G__32363_32427 = inst_32144;
var G__32363_32428__$1 = (((G__32363_32427 instanceof cljs.core.Keyword))?G__32363_32427.fqn:null);
switch (G__32363_32428__$1) {
case "or":
var statearr_32364_32430 = state_32321__$1;
(statearr_32364_32430[(1)] = (43));


break;
case "and":
var statearr_32365_32431 = state_32321__$1;
(statearr_32365_32431[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32363_32428__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (11))){
var inst_32160 = (state_32321[(14)]);
var state_32321__$1 = state_32321;
var statearr_32367_32432 = state_32321__$1;
(statearr_32367_32432[(2)] = inst_32160);

(statearr_32367_32432[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (9))){
var inst_32159 = (state_32321[(15)]);
var inst_32166 = (state_32321[(20)]);
var inst_32165 = cljs.core.seq.call(null,inst_32159);
var inst_32166__$1 = cljs.core.first.call(null,inst_32165);
var inst_32167 = cljs.core.next.call(null,inst_32165);
var inst_32168 = cljs.core.not.call(null,inst_32166__$1);
var state_32321__$1 = (function (){var statearr_32368 = state_32321;
(statearr_32368[(20)] = inst_32166__$1);

(statearr_32368[(13)] = inst_32167);

return statearr_32368;
})();
if(inst_32168){
var statearr_32369_32433 = state_32321__$1;
(statearr_32369_32433[(1)] = (11));

} else {
var statearr_32370_32434 = state_32321__$1;
(statearr_32370_32434[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (5))){
var _ = (function (){var statearr_32371 = state_32321;
(statearr_32371[(4)] = cljs.core.rest.call(null,(state_32321[(4)])));

return statearr_32371;
})();
var state_32321__$1 = state_32321;
var ex32366 = (state_32321__$1[(2)]);
var statearr_32372_32435 = state_32321__$1;
(statearr_32372_32435[(5)] = ex32366);


if((ex32366 instanceof Error)){
var statearr_32373_32436 = state_32321__$1;
(statearr_32373_32436[(1)] = (4));

(statearr_32373_32436[(5)] = null);

} else {
throw ex32366;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (14))){
var inst_32174 = (state_32321[(8)]);
var inst_32180 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_32174);
var inst_32181 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32180)].join('');
var inst_32182 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_32183 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_32184 = cljs.core.PersistentHashMap.fromArrays(inst_32182,inst_32183);
var inst_32185 = cljs.core.ex_info.call(null,inst_32181,inst_32184);
var inst_32186 = (function(){throw inst_32185})();
var state_32321__$1 = state_32321;
var statearr_32374_32437 = state_32321__$1;
(statearr_32374_32437[(2)] = inst_32186);

(statearr_32374_32437[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (45))){
var inst_32301 = (state_32321[(12)]);
var state_32321__$1 = state_32321;
var statearr_32375_32438 = state_32321__$1;
(statearr_32375_32438[(2)] = inst_32301);

(statearr_32375_32438[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (26))){
var inst_32176 = (state_32321[(7)]);
var inst_32174 = (state_32321[(8)]);
var inst_32230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32231 = [inst_32174,inst_32176];
var inst_32232 = (new cljs.core.PersistentVector(null,2,(5),inst_32230,inst_32231,null));
var inst_32233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32234 = [inst_32174];
var inst_32235 = (new cljs.core.PersistentVector(null,1,(5),inst_32233,inst_32234,null));
var inst_32236 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_32232,cljs.core._LT__EQ_,inst_32235);
var state_32321__$1 = state_32321;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32321__$1,(29),inst_32236);
} else {
if((state_val_32322 === (16))){
var inst_32175 = (state_32321[(10)]);
var inst_32193 = (state_32321[(11)]);
var inst_32189 = (state_32321[(2)]);
var inst_32193__$1 = cljs.core.identical_QMARK_;
var inst_32194 = inst_32193__$1.call(null,cljs.core.not_EQ_,inst_32175);
var state_32321__$1 = (function (){var statearr_32376 = state_32321;
(statearr_32376[(11)] = inst_32193__$1);

(statearr_32376[(22)] = inst_32189);

return statearr_32376;
})();
if(cljs.core.truth_(inst_32194)){
var statearr_32377_32439 = state_32321__$1;
(statearr_32377_32439[(1)] = (17));

} else {
var statearr_32378_32440 = state_32321__$1;
(statearr_32378_32440[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (38))){
var inst_32176 = (state_32321[(7)]);
var inst_32174 = (state_32321[(8)]);
var inst_32269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32270 = [inst_32174];
var inst_32271 = (new cljs.core.PersistentVector(null,1,(5),inst_32269,inst_32270,null));
var inst_32272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32273 = [inst_32174,inst_32176];
var inst_32274 = (new cljs.core.PersistentVector(null,2,(5),inst_32272,inst_32273,null));
var inst_32275 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_32271,cljs.core._LT__EQ_,inst_32274);
var state_32321__$1 = state_32321;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32321__$1,(41),inst_32275);
} else {
if((state_val_32322 === (30))){
var inst_32176 = (state_32321[(7)]);
var inst_32174 = (state_32321[(8)]);
var inst_32243 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32244 = [inst_32174,inst_32176];
var inst_32245 = (new cljs.core.PersistentVector(null,2,(5),inst_32243,inst_32244,null));
var inst_32246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32247 = [inst_32174];
var inst_32248 = (new cljs.core.PersistentVector(null,1,(5),inst_32246,inst_32247,null));
var inst_32249 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_32245,cljs.core._LT__EQ_,inst_32248);
var state_32321__$1 = state_32321;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32321__$1,(33),inst_32249);
} else {
if((state_val_32322 === (10))){
var inst_32313 = (state_32321[(2)]);
var state_32321__$1 = state_32321;
var statearr_32379_32441 = state_32321__$1;
(statearr_32379_32441[(2)] = inst_32313);

(statearr_32379_32441[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (18))){
var inst_32175 = (state_32321[(10)]);
var inst_32193 = (state_32321[(11)]);
var inst_32218 = inst_32193.call(null,cljs.core._EQ_,inst_32175);
var state_32321__$1 = state_32321;
if(cljs.core.truth_(inst_32218)){
var statearr_32380_32442 = state_32321__$1;
(statearr_32380_32442[(1)] = (22));

} else {
var statearr_32381_32443 = state_32321__$1;
(statearr_32381_32443[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (42))){
var inst_32144 = (state_32321[(21)]);
var inst_32301 = (state_32321[(12)]);
var inst_32301__$1 = (state_32321[(2)]);
var inst_32302 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_32144);
var inst_32303 = cljs.core.empty_QMARK_.call(null,inst_32301__$1);
var inst_32304 = ((inst_32302) && (inst_32303));
var state_32321__$1 = (function (){var statearr_32382 = state_32321;
(statearr_32382[(12)] = inst_32301__$1);

return statearr_32382;
})();
if(cljs.core.truth_(inst_32304)){
var statearr_32383_32444 = state_32321__$1;
(statearr_32383_32444[(1)] = (45));

} else {
var statearr_32384_32445 = state_32321__$1;
(statearr_32384_32445[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (37))){
var inst_32264 = (state_32321[(2)]);
var inst_32265 = fluree.db.util.async.throw_err.call(null,inst_32264);
var state_32321__$1 = state_32321;
var statearr_32385_32446 = state_32321__$1;
(statearr_32385_32446[(2)] = inst_32265);

(statearr_32385_32446[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32322 === (8))){
var inst_32316 = (state_32321[(2)]);
var _ = (function (){var statearr_32386 = state_32321;
(statearr_32386[(4)] = cljs.core.rest.call(null,(state_32321[(4)])));

return statearr_32386;
})();
var state_32321__$1 = state_32321;
var statearr_32387_32447 = state_32321__$1;
(statearr_32387_32447[(2)] = inst_32316);

(statearr_32387_32447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11469__auto__ = null;
var fluree$db$query$fql$state_machine__11469__auto____0 = (function (){
var statearr_32388 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32388[(0)] = fluree$db$query$fql$state_machine__11469__auto__);

(statearr_32388[(1)] = (1));

return statearr_32388;
});
var fluree$db$query$fql$state_machine__11469__auto____1 = (function (state_32321){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_32321);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e32389){var ex__11472__auto__ = e32389;
var statearr_32390_32448 = state_32321;
(statearr_32390_32448[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_32321[(4)]))){
var statearr_32391_32449 = state_32321;
(statearr_32391_32449[(1)] = cljs.core.first.call(null,(state_32321[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32450 = state_32321;
state_32321 = G__32450;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11469__auto__ = function(state_32321){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11469__auto____1.call(this,state_32321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11469__auto____0;
fluree$db$query$fql$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11469__auto____1;
return fluree$db$query$fql$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_32392 = f__11543__auto__.call(null);
(statearr_32392[(6)] = c__11542__auto__);

return statearr_32392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__32452,offset,limit){
var map__32453 = p__32452;
var map__32453__$1 = (((((!((map__32453 == null))))?(((((map__32453.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32453.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32453):map__32453);
var res = map__32453__$1;
var headers = cljs.core.get.call(null,map__32453__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__32453__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__32455 = orderBy;
var order = cljs.core.nth.call(null,vec__32455,(0),null);
var var$ = cljs.core.nth.call(null,vec__32455,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__32458 = cljs.core.sort_by.call(null,(function (p1__32451_SHARP_){
return cljs.core.nth.call(null,p1__32451_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
var G__32458__$1 = ((cljs.core._EQ_.call(null,"DESC",order))?cljs.core.reverse.call(null,G__32458):G__32458);
var G__32458__$2 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__32458__$1):G__32458__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__32458__$2);
} else {
return G__32458__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__32459_SHARP_){
return ((typeof p1__32459_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__32459_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__32460_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__32460_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__32464 = vars;
var vec__32465 = G__32464;
var seq__32466 = cljs.core.seq.call(null,vec__32465);
var first__32467 = cljs.core.first.call(null,seq__32466);
var seq__32466__$1 = cljs.core.next.call(null,seq__32466);
var var$ = first__32467;
var r = seq__32466__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__32464__$1 = G__32464;
var all_vars__$1 = all_vars;
while(true){
var vec__32471 = G__32464__$1;
var seq__32472 = cljs.core.seq.call(null,vec__32471);
var first__32473 = cljs.core.first.call(null,seq__32472);
var seq__32472__$1 = cljs.core.next.call(null,seq__32472);
var var$__$1 = first__32473;
var r__$1 = seq__32472__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__32474 = r__$1;
var G__32475 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__32464__$1 = G__32474;
all_vars__$1 = G__32475;
continue;
} else {
var G__32476 = r__$1;
var G__32477 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__32464__$1 = G__32476;
all_vars__$1 = G__32477;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_32512){
var state_val_32513 = (state_32512[(1)]);
if((state_val_32513 === (1))){
var inst_32485 = functionArray;
var inst_32486 = cljs.core.seq.call(null,inst_32485);
var inst_32487 = cljs.core.first.call(null,inst_32486);
var inst_32488 = cljs.core.next.call(null,inst_32486);
var inst_32489 = cljs.core.PersistentVector.EMPTY;
var inst_32490 = inst_32485;
var inst_32491 = inst_32489;
var state_32512__$1 = (function (){var statearr_32514 = state_32512;
(statearr_32514[(7)] = inst_32488);

(statearr_32514[(8)] = inst_32487);

(statearr_32514[(9)] = inst_32490);

(statearr_32514[(10)] = inst_32491);

return statearr_32514;
})();
var statearr_32515_32528 = state_32512__$1;
(statearr_32515_32528[(2)] = null);

(statearr_32515_32528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32513 === (2))){
var inst_32497 = (state_32512[(11)]);
var inst_32490 = (state_32512[(9)]);
var inst_32496 = cljs.core.seq.call(null,inst_32490);
var inst_32497__$1 = cljs.core.first.call(null,inst_32496);
var inst_32498 = cljs.core.next.call(null,inst_32496);
var state_32512__$1 = (function (){var statearr_32516 = state_32512;
(statearr_32516[(12)] = inst_32498);

(statearr_32516[(11)] = inst_32497__$1);

return statearr_32516;
})();
if(cljs.core.truth_(inst_32497__$1)){
var statearr_32517_32529 = state_32512__$1;
(statearr_32517_32529[(1)] = (4));

} else {
var statearr_32518_32530 = state_32512__$1;
(statearr_32518_32530[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32513 === (3))){
var inst_32510 = (state_32512[(2)]);
var state_32512__$1 = state_32512;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32512__$1,inst_32510);
} else {
if((state_val_32513 === (4))){
var inst_32497 = (state_32512[(11)]);
var inst_32500 = inst_32497.call(null,tuple);
var state_32512__$1 = state_32512;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32512__$1,(7),inst_32500);
} else {
if((state_val_32513 === (5))){
var inst_32491 = (state_32512[(10)]);
var state_32512__$1 = state_32512;
var statearr_32519_32531 = state_32512__$1;
(statearr_32519_32531[(2)] = inst_32491);

(statearr_32519_32531[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32513 === (6))){
var inst_32508 = (state_32512[(2)]);
var state_32512__$1 = state_32512;
var statearr_32520_32532 = state_32512__$1;
(statearr_32520_32532[(2)] = inst_32508);

(statearr_32520_32532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32513 === (7))){
var inst_32498 = (state_32512[(12)]);
var inst_32491 = (state_32512[(10)]);
var inst_32502 = (state_32512[(2)]);
var inst_32503 = fluree.db.util.async.throw_err.call(null,inst_32502);
var inst_32504 = cljs.core.conj.call(null,inst_32491,inst_32503);
var inst_32490 = inst_32498;
var inst_32491__$1 = inst_32504;
var state_32512__$1 = (function (){var statearr_32521 = state_32512;
(statearr_32521[(9)] = inst_32490);

(statearr_32521[(10)] = inst_32491__$1);

return statearr_32521;
})();
var statearr_32522_32533 = state_32512__$1;
(statearr_32522_32533[(2)] = null);

(statearr_32522_32533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__11469__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__11469__auto____0 = (function (){
var statearr_32523 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32523[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__11469__auto__);

(statearr_32523[(1)] = (1));

return statearr_32523;
});
var fluree$db$query$fql$format_tuple_$_state_machine__11469__auto____1 = (function (state_32512){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_32512);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e32524){var ex__11472__auto__ = e32524;
var statearr_32525_32534 = state_32512;
(statearr_32525_32534[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_32512[(4)]))){
var statearr_32526_32535 = state_32512;
(statearr_32526_32535[(1)] = cljs.core.first.call(null,(state_32512[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32536 = state_32512;
state_32512 = G__32536;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__11469__auto__ = function(state_32512){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__11469__auto____1.call(this,state_32512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__11469__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__11469__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_32527 = f__11543__auto__.call(null);
(statearr_32527[(6)] = c__11542__auto__);

return statearr_32527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__32538,headers,vars,opts){
var map__32539 = p__32538;
var map__32539__$1 = (((((!((map__32539 == null))))?(((((map__32539.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32539.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32539):map__32539);
var select_spec = map__32539__$1;
var prettyPrint = cljs.core.get.call(null,map__32539__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var select = cljs.core.get.call(null,map__32539__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inVector_QMARK_ = cljs.core.get.call(null,map__32539__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__32539__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_32626){
var state_val_32627 = (state_32626[(1)]);
if((state_val_32627 === (7))){
var state_32626__$1 = state_32626;
var statearr_32628_32768 = state_32626__$1;
(statearr_32628_32768[(2)] = null);

(statearr_32628_32768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32627 === (1))){
var state_32626__$1 = state_32626;
var statearr_32629_32769 = state_32626__$1;
(statearr_32629_32769[(2)] = null);

(statearr_32629_32769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32627 === (4))){
var inst_32541 = (state_32626[(2)]);
var state_32626__$1 = state_32626;
var statearr_32630_32770 = state_32626__$1;
(statearr_32630_32770[(2)] = inst_32541);

(statearr_32630_32770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32627 === (15))){
var inst_32615 = (state_32626[(2)]);
var inst_32616 = fluree.db.util.async.throw_err.call(null,inst_32615);
var state_32626__$1 = state_32626;
var statearr_32631_32771 = state_32626__$1;
(statearr_32631_32771[(2)] = inst_32616);

(statearr_32631_32771[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32627 === (13))){
var inst_32551 = (state_32626[(7)]);
var inst_32559 = (state_32626[(8)]);
var inst_32618 = (function (){var pp = inst_32551;
var functionArray = inst_32559;
return (function (tuple){
var tuple_res = cljs.core.map.call(null,(function (p1__32537_SHARP_){
return p1__32537_SHARP_.call(null,tuple);
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap.call(null,pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first.call(null,tuple_res);

}
}
});
})();
var inst_32619 = cljs.core.map.call(null,inst_32618,tuples);
var state_32626__$1 = state_32626;
var statearr_32632_32772 = state_32626__$1;
(statearr_32632_32772[(2)] = inst_32619);

(statearr_32632_32772[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32627 === (6))){
var inst_32548 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_32626__$1 = state_32626;
var statearr_32633_32773 = state_32626__$1;
(statearr_32633_32773[(2)] = inst_32548);

(statearr_32633_32773[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32627 === (3))){
var inst_32624 = (state_32626[(2)]);
var state_32626__$1 = state_32626;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32626__$1,inst_32624);
} else {
if((state_val_32627 === (12))){
var inst_32551 = (state_32626[(7)]);
var inst_32559 = (state_32626[(8)]);
var inst_32611 = cljs.core.async.chan.call(null,(1));
var inst_32612 = (function (){var pp = inst_32551;
var functionArray = inst_32559;
var c__11542__auto____$1 = inst_32611;
return (function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_32609){
var state_val_32610 = (state_32609[(1)]);
if((state_val_32610 === (7))){
var inst_32585 = (state_32609[(2)]);
var inst_32586 = fluree.db.util.async.throw_err.call(null,inst_32585);
var state_32609__$1 = (function (){var statearr_32634 = state_32609;
(statearr_32634[(7)] = inst_32586);

return statearr_32634;
})();
if(cljs.core.truth_(pp)){
var statearr_32635_32774 = state_32609__$1;
(statearr_32635_32774[(1)] = (8));

} else {
var statearr_32636_32775 = state_32609__$1;
(statearr_32636_32775[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (1))){
var inst_32568 = tuples;
var inst_32569 = cljs.core.seq.call(null,inst_32568);
var inst_32570 = cljs.core.first.call(null,inst_32569);
var inst_32571 = cljs.core.next.call(null,inst_32569);
var inst_32572 = cljs.core.PersistentVector.EMPTY;
var inst_32573 = inst_32568;
var inst_32574 = inst_32572;
var state_32609__$1 = (function (){var statearr_32637 = state_32609;
(statearr_32637[(8)] = inst_32573);

(statearr_32637[(9)] = inst_32571);

(statearr_32637[(10)] = inst_32574);

(statearr_32637[(11)] = inst_32570);

return statearr_32637;
})();
var statearr_32638_32776 = state_32609__$1;
(statearr_32638_32776[(2)] = null);

(statearr_32638_32776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (4))){
var inst_32580 = (state_32609[(12)]);
var inst_32583 = fluree.db.query.fql.format_tuple.call(null,functionArray,inst_32580);
var state_32609__$1 = state_32609;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32609__$1,(7),inst_32583);
} else {
if((state_val_32610 === (15))){
var state_32609__$1 = state_32609;
var statearr_32639_32777 = state_32609__$1;
(statearr_32639_32777[(2)] = null);

(statearr_32639_32777[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (13))){
var inst_32598 = (state_32609[(2)]);
var state_32609__$1 = state_32609;
var statearr_32640_32778 = state_32609__$1;
(statearr_32640_32778[(2)] = inst_32598);

(statearr_32640_32778[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (6))){
var inst_32605 = (state_32609[(2)]);
var state_32609__$1 = state_32609;
var statearr_32641_32779 = state_32609__$1;
(statearr_32641_32779[(2)] = inst_32605);

(statearr_32641_32779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (3))){
var inst_32607 = (state_32609[(2)]);
var state_32609__$1 = state_32609;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32609__$1,inst_32607);
} else {
if((state_val_32610 === (12))){
var state_32609__$1 = state_32609;
var statearr_32642_32780 = state_32609__$1;
(statearr_32642_32780[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (2))){
var inst_32573 = (state_32609[(8)]);
var inst_32580 = (state_32609[(12)]);
var inst_32579 = cljs.core.seq.call(null,inst_32573);
var inst_32580__$1 = cljs.core.first.call(null,inst_32579);
var inst_32581 = cljs.core.next.call(null,inst_32579);
var state_32609__$1 = (function (){var statearr_32644 = state_32609;
(statearr_32644[(13)] = inst_32581);

(statearr_32644[(12)] = inst_32580__$1);

return statearr_32644;
})();
if(cljs.core.truth_(inst_32580__$1)){
var statearr_32645_32781 = state_32609__$1;
(statearr_32645_32781[(1)] = (4));

} else {
var statearr_32646_32782 = state_32609__$1;
(statearr_32646_32782[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (11))){
var inst_32586 = (state_32609[(7)]);
var state_32609__$1 = state_32609;
var statearr_32647_32783 = state_32609__$1;
(statearr_32647_32783[(2)] = inst_32586);

(statearr_32647_32783[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (9))){
var state_32609__$1 = state_32609;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_32648_32784 = state_32609__$1;
(statearr_32648_32784[(1)] = (11));

} else {
var statearr_32649_32785 = state_32609__$1;
(statearr_32649_32785[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (5))){
var inst_32574 = (state_32609[(10)]);
var state_32609__$1 = state_32609;
var statearr_32650_32786 = state_32609__$1;
(statearr_32650_32786[(2)] = inst_32574);

(statearr_32650_32786[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (14))){
var inst_32586 = (state_32609[(7)]);
var inst_32593 = cljs.core.first.call(null,inst_32586);
var state_32609__$1 = state_32609;
var statearr_32651_32787 = state_32609__$1;
(statearr_32651_32787[(2)] = inst_32593);

(statearr_32651_32787[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (16))){
var inst_32596 = (state_32609[(2)]);
var state_32609__$1 = state_32609;
var statearr_32652_32788 = state_32609__$1;
(statearr_32652_32788[(2)] = inst_32596);

(statearr_32652_32788[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (10))){
var inst_32581 = (state_32609[(13)]);
var inst_32574 = (state_32609[(10)]);
var inst_32600 = (state_32609[(2)]);
var inst_32601 = cljs.core.conj.call(null,inst_32574,inst_32600);
var inst_32573 = inst_32581;
var inst_32574__$1 = inst_32601;
var state_32609__$1 = (function (){var statearr_32653 = state_32609;
(statearr_32653[(8)] = inst_32573);

(statearr_32653[(10)] = inst_32574__$1);

return statearr_32653;
})();
var statearr_32654_32789 = state_32609__$1;
(statearr_32654_32789[(2)] = null);

(statearr_32654_32789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32610 === (8))){
var inst_32586 = (state_32609[(7)]);
var inst_32588 = cljs.core.zipmap.call(null,pp,inst_32586);
var state_32609__$1 = state_32609;
var statearr_32655_32790 = state_32609__$1;
(statearr_32655_32790[(2)] = inst_32588);

(statearr_32655_32790[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____0 = (function (){
var statearr_32656 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32656[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__);

(statearr_32656[(1)] = (1));

return statearr_32656;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____1 = (function (state_32609){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_32609);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e32657){var ex__11472__auto__ = e32657;
var statearr_32658_32791 = state_32609;
(statearr_32658_32791[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_32609[(4)]))){
var statearr_32659_32792 = state_32609;
(statearr_32659_32792[(1)] = cljs.core.first.call(null,(state_32609[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32793 = state_32609;
state_32609 = G__32793;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__ = function(state_32609){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____1.call(this,state_32609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_32660 = f__11543__auto__.call(null);
(statearr_32660[(6)] = c__11542__auto____$1);

return statearr_32660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
});
})();
var inst_32613 = cljs.core.async.impl.dispatch.run.call(null,inst_32612);
var state_32626__$1 = (function (){var statearr_32661 = state_32626;
(statearr_32661[(9)] = inst_32613);

return statearr_32661;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32626__$1,(15),inst_32611);
} else {
if((state_val_32627 === (2))){
var _ = (function (){var statearr_32662 = state_32626;
(statearr_32662[(4)] = cljs.core.cons.call(null,(5),(state_32626[(4)])));

return statearr_32662;
})();
var state_32626__$1 = state_32626;
if(cljs.core.truth_(prettyPrint)){
var statearr_32663_32794 = state_32626__$1;
(statearr_32663_32794[(1)] = (6));

} else {
var statearr_32664_32795 = state_32626__$1;
(statearr_32664_32795[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32627 === (11))){
var inst_32559 = (state_32626[(2)]);
var state_32626__$1 = (function (){var statearr_32666 = state_32626;
(statearr_32666[(8)] = inst_32559);

return statearr_32666;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_32667_32796 = state_32626__$1;
(statearr_32667_32796[(1)] = (12));

} else {
var statearr_32668_32797 = state_32626__$1;
(statearr_32668_32797[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32627 === (9))){
var inst_32551 = (state_32626[(7)]);
var inst_32553 = (function (){var pp = inst_32551;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of.call(null,headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?(function (tuple){
return cljs.core.get.call(null,vars,select_val);
}):null)));
if(cljs.core.truth_(new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__11542__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_32701){
var state_val_32702 = (state_32701[(1)]);
if((state_val_32702 === (7))){
var state_32701__$1 = state_32701;
var statearr_32703_32798 = state_32701__$1;
(statearr_32703_32798[(2)] = null);

(statearr_32703_32798[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32702 === (1))){
var state_32701__$1 = state_32701;
var statearr_32704_32799 = state_32701__$1;
(statearr_32704_32799[(2)] = null);

(statearr_32704_32799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32702 === (4))){
var inst_32669 = (state_32701[(2)]);
var state_32701__$1 = state_32701;
var statearr_32705_32800 = state_32701__$1;
(statearr_32705_32800[(2)] = inst_32669);

(statearr_32705_32800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32702 === (6))){
var inst_32677 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_32678 = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_32679 = select_fn.call(null,tuple);
var inst_32680 = [inst_32678,inst_32679,opts];
var inst_32681 = cljs.core.PersistentHashMap.fromArrays(inst_32677,inst_32680);
var inst_32682 = fluree.db.query.fql.query.call(null,db,inst_32681);
var state_32701__$1 = state_32701;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32701__$1,(9),inst_32682);
} else {
if((state_val_32702 === (3))){
var inst_32699 = (state_32701[(2)]);
var state_32701__$1 = state_32701;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32701__$1,inst_32699);
} else {
if((state_val_32702 === (12))){
var inst_32693 = (state_32701[(2)]);
var state_32701__$1 = state_32701;
var statearr_32706_32801 = state_32701__$1;
(statearr_32706_32801[(2)] = inst_32693);

(statearr_32706_32801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32702 === (2))){
var _ = (function (){var statearr_32707 = state_32701;
(statearr_32707[(4)] = cljs.core.cons.call(null,(5),(state_32701[(4)])));

return statearr_32707;
})();
var inst_32675 = select_fn.call(null,tuple);
var state_32701__$1 = state_32701;
if(cljs.core.truth_(inst_32675)){
var statearr_32708_32802 = state_32701__$1;
(statearr_32708_32802[(1)] = (6));

} else {
var statearr_32709_32803 = state_32701__$1;
(statearr_32709_32803[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32702 === (11))){
var inst_32688 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_32689 = select_fn.call(null,tuple);
var inst_32690 = [inst_32689];
var inst_32691 = cljs.core.PersistentHashMap.fromArrays(inst_32688,inst_32690);
var state_32701__$1 = state_32701;
var statearr_32711_32804 = state_32701__$1;
(statearr_32711_32804[(2)] = inst_32691);

(statearr_32711_32804[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32702 === (9))){
var inst_32685 = (state_32701[(7)]);
var inst_32684 = (state_32701[(2)]);
var inst_32685__$1 = fluree.db.util.async.throw_err.call(null,inst_32684);
var state_32701__$1 = (function (){var statearr_32712 = state_32701;
(statearr_32712[(7)] = inst_32685__$1);

return statearr_32712;
})();
if(cljs.core.truth_(inst_32685__$1)){
var statearr_32713_32805 = state_32701__$1;
(statearr_32713_32805[(1)] = (10));

} else {
var statearr_32714_32806 = state_32701__$1;
(statearr_32714_32806[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32702 === (5))){
var _ = (function (){var statearr_32715 = state_32701;
(statearr_32715[(4)] = cljs.core.rest.call(null,(state_32701[(4)])));

return statearr_32715;
})();
var state_32701__$1 = state_32701;
var ex32710 = (state_32701__$1[(2)]);
var statearr_32716_32807 = state_32701__$1;
(statearr_32716_32807[(5)] = ex32710);


if((ex32710 instanceof Error)){
var statearr_32717_32808 = state_32701__$1;
(statearr_32717_32808[(1)] = (4));

(statearr_32717_32808[(5)] = null);

} else {
throw ex32710;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32702 === (10))){
var inst_32685 = (state_32701[(7)]);
var state_32701__$1 = state_32701;
var statearr_32718_32809 = state_32701__$1;
(statearr_32718_32809[(2)] = inst_32685);

(statearr_32718_32809[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32702 === (8))){
var inst_32696 = (state_32701[(2)]);
var _ = (function (){var statearr_32719 = state_32701;
(statearr_32719[(4)] = cljs.core.rest.call(null,(state_32701[(4)])));

return statearr_32719;
})();
var state_32701__$1 = state_32701;
var statearr_32720_32810 = state_32701__$1;
(statearr_32720_32810[(2)] = inst_32696);

(statearr_32720_32810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____0 = (function (){
var statearr_32721 = [null,null,null,null,null,null,null,null];
(statearr_32721[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__);

(statearr_32721[(1)] = (1));

return statearr_32721;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____1 = (function (state_32701){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_32701);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e32722){var ex__11472__auto__ = e32722;
var statearr_32723_32811 = state_32701;
(statearr_32723_32811[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_32701[(4)]))){
var statearr_32724_32812 = state_32701;
(statearr_32724_32812[(1)] = cljs.core.first.call(null,(state_32701[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32813 = state_32701;
state_32701 = G__32813;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__ = function(state_32701){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____1.call(this,state_32701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_32725 = f__11543__auto__.call(null);
(statearr_32725[(6)] = c__11542__auto____$1);

return statearr_32725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto____$1;
});
} else {
return (function (tuple){
var c__11542__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_32737){
var state_val_32738 = (state_32737[(1)]);
if((state_val_32738 === (1))){
var state_32737__$1 = state_32737;
var statearr_32739_32814 = state_32737__$1;
(statearr_32739_32814[(2)] = null);

(statearr_32739_32814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32738 === (2))){
var _ = (function (){var statearr_32740 = state_32737;
(statearr_32740[(4)] = cljs.core.cons.call(null,(5),(state_32737[(4)])));

return statearr_32740;
})();
var inst_32732 = select_fn.call(null,tuple);
var ___$1 = (function (){var statearr_32741 = state_32737;
(statearr_32741[(4)] = cljs.core.rest.call(null,(state_32737[(4)])));

return statearr_32741;
})();
var state_32737__$1 = state_32737;
var statearr_32742_32815 = state_32737__$1;
(statearr_32742_32815[(2)] = inst_32732);

(statearr_32742_32815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32738 === (3))){
var inst_32735 = (state_32737[(2)]);
var state_32737__$1 = state_32737;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32737__$1,inst_32735);
} else {
if((state_val_32738 === (4))){
var inst_32726 = (state_32737[(2)]);
var state_32737__$1 = state_32737;
var statearr_32744_32816 = state_32737__$1;
(statearr_32744_32816[(2)] = inst_32726);

(statearr_32744_32816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32738 === (5))){
var _ = (function (){var statearr_32745 = state_32737;
(statearr_32745[(4)] = cljs.core.rest.call(null,(state_32737[(4)])));

return statearr_32745;
})();
var state_32737__$1 = state_32737;
var ex32743 = (state_32737__$1[(2)]);
var statearr_32746_32817 = state_32737__$1;
(statearr_32746_32817[(5)] = ex32743);


if((ex32743 instanceof Error)){
var statearr_32747_32818 = state_32737__$1;
(statearr_32747_32818[(1)] = (4));

(statearr_32747_32818[(5)] = null);

} else {
throw ex32743;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____0 = (function (){
var statearr_32748 = [null,null,null,null,null,null,null];
(statearr_32748[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__);

(statearr_32748[(1)] = (1));

return statearr_32748;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____1 = (function (state_32737){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_32737);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e32749){var ex__11472__auto__ = e32749;
var statearr_32750_32819 = state_32737;
(statearr_32750_32819[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_32737[(4)]))){
var statearr_32751_32820 = state_32737;
(statearr_32751_32820[(1)] = cljs.core.first.call(null,(state_32737[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32821 = state_32737;
state_32737 = G__32821;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__ = function(state_32737){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____1.call(this,state_32737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_32752 = f__11543__auto__.call(null);
(statearr_32752[(6)] = c__11542__auto____$1);

return statearr_32752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto____$1;
});
}
});
})();
var inst_32554 = cljs.core.map.call(null,inst_32553,select);
var state_32626__$1 = state_32626;
var statearr_32753_32822 = state_32626__$1;
(statearr_32753_32822[(2)] = inst_32554);

(statearr_32753_32822[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32627 === (5))){
var _ = (function (){var statearr_32754 = state_32626;
(statearr_32754[(4)] = cljs.core.rest.call(null,(state_32626[(4)])));

return statearr_32754;
})();
var state_32626__$1 = state_32626;
var ex32665 = (state_32626__$1[(2)]);
var statearr_32755_32823 = state_32626__$1;
(statearr_32755_32823[(5)] = ex32665);


if((ex32665 instanceof Error)){
var statearr_32756_32824 = state_32626__$1;
(statearr_32756_32824[(1)] = (4));

(statearr_32756_32824[(5)] = null);

} else {
throw ex32665;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32627 === (14))){
var inst_32621 = (state_32626[(2)]);
var _ = (function (){var statearr_32757 = state_32626;
(statearr_32757[(4)] = cljs.core.rest.call(null,(state_32626[(4)])));

return statearr_32757;
})();
var state_32626__$1 = state_32626;
var statearr_32758_32825 = state_32626__$1;
(statearr_32758_32825[(2)] = inst_32621);

(statearr_32758_32825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32627 === (10))){
var inst_32551 = (state_32626[(7)]);
var inst_32556 = (function (){var pp = inst_32551;
return (function (select__$1){
var temp__5733__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select__$1);
return (function (tuple){
return cljs.core.nth.call(null,tuple,idx);
});
}
});
})();
var inst_32557 = cljs.core.map.call(null,inst_32556,select);
var state_32626__$1 = state_32626;
var statearr_32759_32826 = state_32626__$1;
(statearr_32759_32826[(2)] = inst_32557);

(statearr_32759_32826[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32627 === (8))){
var inst_32551 = (state_32626[(2)]);
var state_32626__$1 = (function (){var statearr_32760 = state_32626;
(statearr_32760[(7)] = inst_32551);

return statearr_32760;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_32761_32827 = state_32626__$1;
(statearr_32761_32827[(1)] = (9));

} else {
var statearr_32762_32828 = state_32626__$1;
(statearr_32762_32828[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____0 = (function (){
var statearr_32763 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32763[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__);

(statearr_32763[(1)] = (1));

return statearr_32763;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____1 = (function (state_32626){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_32626);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e32764){var ex__11472__auto__ = e32764;
var statearr_32765_32829 = state_32626;
(statearr_32765_32829[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_32626[(4)]))){
var statearr_32766_32830 = state_32626;
(statearr_32766_32830[(1)] = cljs.core.first.call(null,(state_32626[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32831 = state_32626;
state_32626 = G__32831;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__ = function(state_32626){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____1.call(this,state_32626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_32767 = f__11543__auto__.call(null);
(statearr_32767[(6)] = c__11542__auto__);

return statearr_32767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__32833 = arguments.length;
switch (G__32833) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__32834,p__32835,group_limit,opts){
var map__32836 = p__32834;
var map__32836__$1 = (((((!((map__32836 == null))))?(((((map__32836.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32836.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32836):map__32836);
var res = map__32836__$1;
var vars = cljs.core.get.call(null,map__32836__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__32837 = p__32835;
var map__32837__$1 = (((((!((map__32837 == null))))?(((((map__32837.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32837.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32837):map__32837);
var select_spec = map__32837__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__32837__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__32837__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__32837__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__32837__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__32837__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__32837__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__32837__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__32837__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__32837__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_32949){
var state_val_32950 = (state_32949[(1)]);
if((state_val_32950 === (7))){
var inst_32846 = (state_32949[(7)]);
var state_32949__$1 = state_32949;
var statearr_32951_33031 = state_32949__$1;
(statearr_32951_33031[(2)] = inst_32846);

(statearr_32951_33031[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (20))){
var inst_32881 = (state_32949[(2)]);
var state_32949__$1 = (function (){var statearr_32952 = state_32949;
(statearr_32952[(8)] = inst_32881);

return statearr_32952;
})();
if(cljs.core.truth_(groupBy)){
var statearr_32953_33032 = state_32949__$1;
(statearr_32953_33032[(1)] = (21));

} else {
var statearr_32954_33033 = state_32949__$1;
(statearr_32954_33033[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (27))){
var inst_32890 = (state_32949[(9)]);
var inst_32895 = inst_32890.cljs$lang$protocol_mask$partition0$;
var inst_32896 = (inst_32895 & (64));
var inst_32897 = inst_32890.cljs$core$ISeq$;
var inst_32898 = (cljs.core.PROTOCOL_SENTINEL === inst_32897);
var inst_32899 = ((inst_32896) || (inst_32898));
var state_32949__$1 = state_32949;
if(cljs.core.truth_(inst_32899)){
var statearr_32955_33034 = state_32949__$1;
(statearr_32955_33034[(1)] = (30));

} else {
var statearr_32956_33035 = state_32949__$1;
(statearr_32956_33035[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (1))){
var state_32949__$1 = state_32949;
var statearr_32957_33036 = state_32949__$1;
(statearr_32957_33036[(2)] = null);

(statearr_32957_33036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (24))){
var inst_32885 = (state_32949[(10)]);
var inst_32881 = (state_32949[(8)]);
var inst_32887 = fluree.db.query.fql.order_offset_and_limit_results.call(null,orderBy,inst_32881,inst_32885,group_limit);
var state_32949__$1 = state_32949;
var statearr_32958_33037 = state_32949__$1;
(statearr_32958_33037[(2)] = inst_32887);

(statearr_32958_33037[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (39))){
var inst_32916 = (state_32949[(11)]);
var state_32949__$1 = state_32949;
var statearr_32959_33038 = state_32949__$1;
(statearr_32959_33038[(2)] = inst_32916);

(statearr_32959_33038[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (46))){
var inst_32934 = (state_32949[(12)]);
var inst_32936 = cljs.core.PersistentVector.EMPTY;
var inst_32937 = cljs.core.PersistentHashSet.EMPTY;
var inst_32938 = cljs.core.into.call(null,inst_32937,inst_32934);
var inst_32939 = cljs.core.into.call(null,inst_32936,inst_32938);
var state_32949__$1 = state_32949;
var statearr_32960_33039 = state_32949__$1;
(statearr_32960_33039[(2)] = inst_32939);

(statearr_32960_33039[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (4))){
var inst_32840 = (state_32949[(2)]);
var state_32949__$1 = state_32949;
var statearr_32961_33040 = state_32949__$1;
(statearr_32961_33040[(2)] = inst_32840);

(statearr_32961_33040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (15))){
var inst_32867 = (state_32949[(13)]);
var inst_32869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32870 = [inst_32867];
var inst_32871 = (new cljs.core.PersistentVector(null,1,(5),inst_32869,inst_32870,null));
var state_32949__$1 = state_32949;
var statearr_32962_33041 = state_32949__$1;
(statearr_32962_33041[(2)] = inst_32871);

(statearr_32962_33041[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (48))){
var inst_32942 = (state_32949[(2)]);
var state_32949__$1 = state_32949;
var statearr_32963_33042 = state_32949__$1;
(statearr_32963_33042[(2)] = inst_32942);

(statearr_32963_33042[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (21))){
var state_32949__$1 = state_32949;
var statearr_32964_33043 = state_32949__$1;
(statearr_32964_33043[(2)] = (0));

(statearr_32964_33043[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (31))){
var state_32949__$1 = state_32949;
var statearr_32965_33044 = state_32949__$1;
(statearr_32965_33044[(2)] = false);

(statearr_32965_33044[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (32))){
var inst_32903 = (state_32949[(2)]);
var state_32949__$1 = state_32949;
var statearr_32966_33045 = state_32949__$1;
(statearr_32966_33045[(2)] = inst_32903);

(statearr_32966_33045[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (40))){
var inst_32885 = (state_32949[(10)]);
var state_32949__$1 = state_32949;
var statearr_32967_33046 = state_32949__$1;
(statearr_32967_33046[(2)] = inst_32885);

(statearr_32967_33046[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (33))){
var inst_32890 = (state_32949[(9)]);
var inst_32908 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32890);
var state_32949__$1 = state_32949;
var statearr_32968_33047 = state_32949__$1;
(statearr_32968_33047[(2)] = inst_32908);

(statearr_32968_33047[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (13))){
var inst_32856 = (state_32949[(14)]);
var state_32949__$1 = state_32949;
var statearr_32969_33048 = state_32949__$1;
(statearr_32969_33048[(2)] = inst_32856);

(statearr_32969_33048[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (22))){
var state_32949__$1 = state_32949;
var statearr_32970_33049 = state_32949__$1;
(statearr_32970_33049[(2)] = offset);

(statearr_32970_33049[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (36))){
var inst_32916 = (state_32949[(11)]);
var inst_32916__$1 = limit;
var state_32949__$1 = (function (){var statearr_32971 = state_32949;
(statearr_32971[(11)] = inst_32916__$1);

return statearr_32971;
})();
if(cljs.core.truth_(inst_32916__$1)){
var statearr_32972_33050 = state_32949__$1;
(statearr_32972_33050[(1)] = (39));

} else {
var statearr_32973_33051 = state_32949__$1;
(statearr_32973_33051[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (41))){
var inst_32920 = (state_32949[(2)]);
var state_32949__$1 = state_32949;
var statearr_32974_33052 = state_32949__$1;
(statearr_32974_33052[(2)] = inst_32920);

(statearr_32974_33052[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (43))){
var inst_32913 = (state_32949[(15)]);
var state_32949__$1 = state_32949;
var statearr_32975_33053 = state_32949__$1;
(statearr_32975_33053[(2)] = inst_32913);

(statearr_32975_33053[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (29))){
var inst_32906 = (state_32949[(2)]);
var state_32949__$1 = state_32949;
if(cljs.core.truth_(inst_32906)){
var statearr_32976_33054 = state_32949__$1;
(statearr_32976_33054[(1)] = (33));

} else {
var statearr_32977_33055 = state_32949__$1;
(statearr_32977_33055[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (44))){
var inst_32912 = (state_32949[(16)]);
var inst_32929 = (state_32949[(2)]);
var inst_32930 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_32931 = fluree.db.query.fql.format_filter_tuples.call(null,db,inst_32929,select_spec,inst_32912,vars,inst_32930);
var state_32949__$1 = state_32949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32949__$1,(45),inst_32931);
} else {
if((state_val_32950 === (6))){
var inst_32848 = cljs.core.count.call(null,select);
var inst_32849 = cljs.core._EQ_.call(null,(1),inst_32848);
var state_32949__$1 = state_32949;
var statearr_32978_33056 = state_32949__$1;
(statearr_32978_33056[(2)] = inst_32849);

(statearr_32978_33056[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (28))){
var state_32949__$1 = state_32949;
var statearr_32979_33057 = state_32949__$1;
(statearr_32979_33057[(2)] = false);

(statearr_32979_33057[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (25))){
var inst_32881 = (state_32949[(8)]);
var state_32949__$1 = state_32949;
var statearr_32980_33058 = state_32949__$1;
(statearr_32980_33058[(2)] = inst_32881);

(statearr_32980_33058[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (34))){
var inst_32890 = (state_32949[(9)]);
var state_32949__$1 = state_32949;
var statearr_32981_33059 = state_32949__$1;
(statearr_32981_33059[(2)] = inst_32890);

(statearr_32981_33059[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (17))){
var inst_32874 = (state_32949[(2)]);
var state_32949__$1 = state_32949;
var statearr_32982_33060 = state_32949__$1;
(statearr_32982_33060[(2)] = inst_32874);

(statearr_32982_33060[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (3))){
var inst_32947 = (state_32949[(2)]);
var state_32949__$1 = state_32949;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32949__$1,inst_32947);
} else {
if((state_val_32950 === (12))){
var inst_32856 = (state_32949[(14)]);
var inst_32858 = cljs.core.first.call(null,select);
var inst_32859 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_32858);
var inst_32860 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32859);
var inst_32861 = cljs.core.subs.call(null,inst_32860,(1));
var inst_32862 = [inst_32861];
var inst_32863 = [inst_32856];
var inst_32864 = cljs.core.PersistentHashMap.fromArrays(inst_32862,inst_32863);
var state_32949__$1 = state_32949;
var statearr_32983_33061 = state_32949__$1;
(statearr_32983_33061[(2)] = inst_32864);

(statearr_32983_33061[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (2))){
var inst_32846 = (state_32949[(7)]);
var _ = (function (){var statearr_32984 = state_32949;
(statearr_32984[(4)] = cljs.core.cons.call(null,(5),(state_32949[(4)])));

return statearr_32984;
})();
var inst_32846__$1 = aggregates;
var state_32949__$1 = (function (){var statearr_32985 = state_32949;
(statearr_32985[(7)] = inst_32846__$1);

return statearr_32985;
})();
if(cljs.core.truth_(inst_32846__$1)){
var statearr_32986_33062 = state_32949__$1;
(statearr_32986_33062[(1)] = (6));

} else {
var statearr_32987_33063 = state_32949__$1;
(statearr_32987_33063[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (23))){
var inst_32885 = (state_32949[(2)]);
var state_32949__$1 = (function (){var statearr_32988 = state_32949;
(statearr_32988[(10)] = inst_32885);

return statearr_32988;
})();
if(cljs.core.truth_(orderBy)){
var statearr_32989_33064 = state_32949__$1;
(statearr_32989_33064[(1)] = (24));

} else {
var statearr_32990_33065 = state_32949__$1;
(statearr_32990_33065[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (47))){
var inst_32934 = (state_32949[(12)]);
var state_32949__$1 = state_32949;
var statearr_32991_33066 = state_32949__$1;
(statearr_32991_33066[(2)] = inst_32934);

(statearr_32991_33066[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (35))){
var inst_32911 = (state_32949[(2)]);
var inst_32912 = cljs.core.get.call(null,inst_32911,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_32913 = cljs.core.get.call(null,inst_32911,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_32914 = cljs.core.not.call(null,orderBy);
var state_32949__$1 = (function (){var statearr_32992 = state_32949;
(statearr_32992[(15)] = inst_32913);

(statearr_32992[(16)] = inst_32912);

return statearr_32992;
})();
if(inst_32914){
var statearr_32993_33067 = state_32949__$1;
(statearr_32993_33067[(1)] = (36));

} else {
var statearr_32994_33068 = state_32949__$1;
(statearr_32994_33068[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (19))){
var state_32949__$1 = state_32949;
var statearr_32995_33069 = state_32949__$1;
(statearr_32995_33069[(2)] = res);

(statearr_32995_33069[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (11))){
var inst_32944 = (state_32949[(2)]);
var _ = (function (){var statearr_32997 = state_32949;
(statearr_32997[(4)] = cljs.core.rest.call(null,(state_32949[(4)])));

return statearr_32997;
})();
var state_32949__$1 = state_32949;
var statearr_32998_33070 = state_32949__$1;
(statearr_32998_33070[(2)] = inst_32944);

(statearr_32998_33070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (9))){
var inst_32854 = cljs.core.first.call(null,aggregates);
var inst_32855 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_32854);
var inst_32856 = cljs.core.second.call(null,inst_32855);
var state_32949__$1 = (function (){var statearr_32999 = state_32949;
(statearr_32999[(14)] = inst_32856);

return statearr_32999;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_33000_33071 = state_32949__$1;
(statearr_33000_33071[(1)] = (12));

} else {
var statearr_33001_33072 = state_32949__$1;
(statearr_33001_33072[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (5))){
var _ = (function (){var statearr_33002 = state_32949;
(statearr_33002[(4)] = cljs.core.rest.call(null,(state_32949[(4)])));

return statearr_33002;
})();
var state_32949__$1 = state_32949;
var ex32996 = (state_32949__$1[(2)]);
var statearr_33003_33073 = state_32949__$1;
(statearr_33003_33073[(5)] = ex32996);


if((ex32996 instanceof Error)){
var statearr_33004_33074 = state_32949__$1;
(statearr_33004_33074[(1)] = (4));

(statearr_33004_33074[(5)] = null);

} else {
throw ex32996;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (14))){
var inst_32867 = (state_32949[(2)]);
var state_32949__$1 = (function (){var statearr_33005 = state_32949;
(statearr_33005[(13)] = inst_32867);

return statearr_33005;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_33006_33075 = state_32949__$1;
(statearr_33006_33075[(1)] = (15));

} else {
var statearr_33007_33076 = state_32949__$1;
(statearr_33007_33076[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (45))){
var inst_32933 = (state_32949[(2)]);
var inst_32934 = fluree.db.util.async.throw_err.call(null,inst_32933);
var state_32949__$1 = (function (){var statearr_33008 = state_32949;
(statearr_33008[(12)] = inst_32934);

return statearr_33008;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_33009_33077 = state_32949__$1;
(statearr_33009_33077[(1)] = (46));

} else {
var statearr_33010_33078 = state_32949__$1;
(statearr_33010_33078[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (26))){
var inst_32890 = (state_32949[(9)]);
var inst_32890__$1 = (state_32949[(2)]);
var inst_32892 = (inst_32890__$1 == null);
var inst_32893 = cljs.core.not.call(null,inst_32892);
var state_32949__$1 = (function (){var statearr_33011 = state_32949;
(statearr_33011[(9)] = inst_32890__$1);

return statearr_33011;
})();
if(inst_32893){
var statearr_33012_33079 = state_32949__$1;
(statearr_33012_33079[(1)] = (27));

} else {
var statearr_33013_33080 = state_32949__$1;
(statearr_33013_33080[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (16))){
var inst_32867 = (state_32949[(13)]);
var state_32949__$1 = state_32949;
var statearr_33014_33081 = state_32949__$1;
(statearr_33014_33081[(2)] = inst_32867);

(statearr_33014_33081[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (38))){
var inst_32923 = (state_32949[(2)]);
var state_32949__$1 = state_32949;
if(cljs.core.truth_(inst_32923)){
var statearr_33015_33082 = state_32949__$1;
(statearr_33015_33082[(1)] = (42));

} else {
var statearr_33016_33083 = state_32949__$1;
(statearr_33016_33083[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (30))){
var state_32949__$1 = state_32949;
var statearr_33017_33084 = state_32949__$1;
(statearr_33017_33084[(2)] = true);

(statearr_33017_33084[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (10))){
var state_32949__$1 = state_32949;
if(cljs.core.truth_(aggregates)){
var statearr_33018_33085 = state_32949__$1;
(statearr_33018_33085[(1)] = (18));

} else {
var statearr_33019_33086 = state_32949__$1;
(statearr_33019_33086[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (18))){
var inst_32878 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_32949__$1 = state_32949;
var statearr_33020_33087 = state_32949__$1;
(statearr_33020_33087[(2)] = inst_32878);

(statearr_33020_33087[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (42))){
var inst_32885 = (state_32949[(10)]);
var inst_32913 = (state_32949[(15)]);
var inst_32925 = cljs.core.drop.call(null,inst_32885,inst_32913);
var inst_32926 = cljs.core.take.call(null,limit,inst_32925);
var state_32949__$1 = state_32949;
var statearr_33021_33088 = state_32949__$1;
(statearr_33021_33088[(2)] = inst_32926);

(statearr_33021_33088[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (37))){
var state_32949__$1 = state_32949;
var statearr_33022_33089 = state_32949__$1;
(statearr_33022_33089[(2)] = false);

(statearr_33022_33089[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32950 === (8))){
var inst_32852 = (state_32949[(2)]);
var state_32949__$1 = state_32949;
if(cljs.core.truth_(inst_32852)){
var statearr_33023_33090 = state_32949__$1;
(statearr_33023_33090[(1)] = (9));

} else {
var statearr_33024_33091 = state_32949__$1;
(statearr_33024_33091[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11469__auto__ = null;
var fluree$db$query$fql$state_machine__11469__auto____0 = (function (){
var statearr_33025 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33025[(0)] = fluree$db$query$fql$state_machine__11469__auto__);

(statearr_33025[(1)] = (1));

return statearr_33025;
});
var fluree$db$query$fql$state_machine__11469__auto____1 = (function (state_32949){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_32949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e33026){var ex__11472__auto__ = e33026;
var statearr_33027_33092 = state_32949;
(statearr_33027_33092[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_32949[(4)]))){
var statearr_33028_33093 = state_32949;
(statearr_33028_33093[(1)] = cljs.core.first.call(null,(state_32949[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33094 = state_32949;
state_32949 = G__33094;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11469__auto__ = function(state_32949){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11469__auto____1.call(this,state_32949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11469__auto____0;
fluree$db$query$fql$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11469__auto____1;
return fluree$db$query$fql$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_33029 = f__11543__auto__.call(null);
(statearr_33029[(6)] = c__11542__auto__);

return statearr_33029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__33097,groupBy){
var map__33098 = p__33097;
var map__33098__$1 = (((((!((map__33098 == null))))?(((((map__33098.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33098.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33098):map__33098);
var res = map__33098__$1;
var headers = cljs.core.get.call(null,map__33098__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__33098__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__33100 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__33100,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__33100,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__33095_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__33095_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__33096_SHARP_){
return cljs.core.nth.call(null,tuple,p1__33096_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__33103,p__33104,opts){
var map__33105 = p__33103;
var map__33105__$1 = (((((!((map__33105 == null))))?(((((map__33105.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33105.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33105):map__33105);
var res = map__33105__$1;
var headers = cljs.core.get.call(null,map__33105__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__33105__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__33106 = p__33104;
var map__33106__$1 = (((((!((map__33106 == null))))?(((((map__33106.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33106.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33106):map__33106);
var select_spec = map__33106__$1;
var groupBy = cljs.core.get.call(null,map__33106__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__33106__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__33106__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__33106__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__33106__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__33106__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__33106__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_33331){
var state_val_33332 = (state_33331[(1)]);
if((state_val_33332 === (65))){
var inst_33293 = (state_33331[(2)]);
var inst_33294 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,res,select_spec,inst_33293,opts);
var state_33331__$1 = state_33331;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33331__$1,(66),inst_33294);
} else {
if((state_val_33332 === (70))){
var inst_33297 = (state_33331[(7)]);
var inst_33302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33303 = [inst_33297];
var inst_33304 = (new cljs.core.PersistentVector(null,1,(5),inst_33302,inst_33303,null));
var state_33331__$1 = state_33331;
var statearr_33333_33456 = state_33331__$1;
(statearr_33333_33456[(2)] = inst_33304);

(statearr_33333_33456[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (62))){
var inst_33286 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33334_33457 = state_33331__$1;
(statearr_33334_33457[(2)] = inst_33286);

(statearr_33334_33457[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (74))){
var state_33331__$1 = state_33331;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_33335_33458 = state_33331__$1;
(statearr_33335_33458[(1)] = (76));

} else {
var statearr_33336_33459 = state_33331__$1;
(statearr_33336_33459[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (7))){
var state_33331__$1 = state_33331;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_33337_33460 = state_33331__$1;
(statearr_33337_33460[(1)] = (63));

} else {
var statearr_33338_33461 = state_33331__$1;
(statearr_33338_33461[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (59))){
var inst_33219 = (state_33331[(8)]);
var inst_33210 = (state_33331[(9)]);
var inst_33262 = (state_33331[(2)]);
var inst_33263 = fluree.db.util.async.throw_err.call(null,inst_33262);
var inst_33264 = cljs.core.assoc.call(null,inst_33210,inst_33219,inst_33263);
var state_33331__$1 = state_33331;
var statearr_33339_33462 = state_33331__$1;
(statearr_33339_33462[(2)] = inst_33264);

(statearr_33339_33462[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (20))){
var inst_33163 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33340_33463 = state_33331__$1;
(statearr_33340_33463[(2)] = inst_33163);

(statearr_33340_33463[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (72))){
var inst_33307 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33341_33464 = state_33331__$1;
(statearr_33341_33464[(2)] = inst_33307);

(statearr_33341_33464[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (58))){
var inst_33267 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33342_33465 = state_33331__$1;
(statearr_33342_33465[(2)] = inst_33267);

(statearr_33342_33465[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (60))){
var inst_33165 = (state_33331[(10)]);
var inst_33280 = (state_33331[(11)]);
var inst_33282 = cljs.core.sorted_map_by.call(null,inst_33165);
var inst_33283 = cljs.core.into.call(null,inst_33282,inst_33280);
var state_33331__$1 = state_33331;
var statearr_33343_33466 = state_33331__$1;
(statearr_33343_33466[(2)] = inst_33283);

(statearr_33343_33466[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (27))){
var inst_33146 = (state_33331[(12)]);
var inst_33116 = (state_33331[(13)]);
var inst_33147 = (state_33331[(14)]);
var inst_33150 = (function (){var group_map = inst_33116;
var orderByIdx = inst_33146;
var orderDirection = inst_33147;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
})();
var state_33331__$1 = state_33331;
var statearr_33344_33467 = state_33331__$1;
(statearr_33344_33467[(2)] = inst_33150);

(statearr_33344_33467[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (1))){
var state_33331__$1 = state_33331;
var statearr_33345_33468 = state_33331__$1;
(statearr_33345_33468[(2)] = null);

(statearr_33345_33468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (69))){
var inst_33324 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33346_33469 = state_33331__$1;
(statearr_33346_33469[(2)] = inst_33324);

(statearr_33346_33469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (24))){
var inst_33147 = (state_33331[(14)]);
var inst_33145 = cljs.core.second.call(null,orderBy);
var inst_33146 = fluree.db.util.core.index_of.call(null,groupBy,inst_33145);
var inst_33147__$1 = cljs.core.first.call(null,orderBy);
var inst_33148 = cljs.core._EQ_.call(null,"DESC",inst_33147__$1);
var state_33331__$1 = (function (){var statearr_33347 = state_33331;
(statearr_33347[(12)] = inst_33146);

(statearr_33347[(14)] = inst_33147__$1);

return statearr_33347;
})();
if(inst_33148){
var statearr_33348_33470 = state_33331__$1;
(statearr_33348_33470[(1)] = (27));

} else {
var statearr_33349_33471 = state_33331__$1;
(statearr_33349_33471[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (55))){
var inst_33219 = (state_33331[(8)]);
var inst_33210 = (state_33331[(9)]);
var inst_33251 = (state_33331[(2)]);
var inst_33252 = fluree.db.util.async.throw_err.call(null,inst_33251);
var inst_33253 = cljs.core.assoc.call(null,inst_33210,inst_33219,inst_33252);
var state_33331__$1 = state_33331;
var statearr_33350_33472 = state_33331__$1;
(statearr_33350_33472[(2)] = inst_33253);

(statearr_33350_33472[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (39))){
var inst_33210 = (state_33331[(9)]);
var state_33331__$1 = state_33331;
var statearr_33351_33473 = state_33331__$1;
(statearr_33351_33473[(2)] = inst_33210);

(statearr_33351_33473[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (46))){
var state_33331__$1 = state_33331;
var statearr_33352_33474 = state_33331__$1;
(statearr_33352_33474[(2)] = null);

(statearr_33352_33474[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (4))){
var inst_33109 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33353_33475 = state_33331__$1;
(statearr_33353_33475[(2)] = inst_33109);

(statearr_33353_33475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (77))){
var state_33331__$1 = state_33331;
var statearr_33354_33476 = state_33331__$1;
(statearr_33354_33476[(1)] = (79));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (54))){
var inst_33269 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33356_33477 = state_33331__$1;
(statearr_33356_33477[(2)] = inst_33269);

(statearr_33356_33477[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (15))){
var inst_33116 = (state_33331[(13)]);
var inst_33128 = (function (){var group_map = inst_33116;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
})();
var state_33331__$1 = state_33331;
var statearr_33357_33478 = state_33331__$1;
(statearr_33357_33478[(2)] = inst_33128);

(statearr_33357_33478[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (48))){
var inst_33237 = (state_33331[(15)]);
var inst_33240 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_33237,select_spec,opts);
var state_33331__$1 = state_33331;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33331__$1,(51),inst_33240);
} else {
if((state_val_33332 === (50))){
var inst_33271 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33358_33479 = state_33331__$1;
(statearr_33358_33479[(2)] = inst_33271);

(statearr_33358_33479[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (75))){
var inst_33322 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33359_33480 = state_33331__$1;
(statearr_33359_33480[(2)] = inst_33322);

(statearr_33359_33480[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (21))){
var inst_33138 = cljs.core.set.call(null,groupBy);
var inst_33139 = cljs.core.second.call(null,orderBy);
var inst_33140 = inst_33138.call(null,inst_33139);
var state_33331__$1 = state_33331;
var statearr_33360_33481 = state_33331__$1;
(statearr_33360_33481[(2)] = inst_33140);

(statearr_33360_33481[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (31))){
var state_33331__$1 = state_33331;
var statearr_33361_33482 = state_33331__$1;
(statearr_33361_33482[(2)] = null);

(statearr_33361_33482[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (32))){
var inst_33159 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33362_33483 = state_33331__$1;
(statearr_33362_33483[(2)] = inst_33159);

(statearr_33362_33483[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (40))){
var inst_33209 = (state_33331[(16)]);
var inst_33227 = (inst_33209 > (0));
var state_33331__$1 = state_33331;
if(cljs.core.truth_(inst_33227)){
var statearr_33363_33484 = state_33331__$1;
(statearr_33363_33484[(1)] = (42));

} else {
var statearr_33364_33485 = state_33331__$1;
(statearr_33364_33485[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (56))){
var inst_33222 = (state_33331[(17)]);
var inst_33237 = (state_33331[(15)]);
var inst_33234 = (state_33331[(18)]);
var inst_33257 = cljs.core.count.call(null,inst_33222);
var inst_33258 = (inst_33234 - limit);
var inst_33259 = (inst_33257 - inst_33258);
var inst_33260 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_33237,select_spec,inst_33259,opts);
var state_33331__$1 = state_33331;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33331__$1,(59),inst_33260);
} else {
if((state_val_33332 === (33))){
var inst_33116 = (state_33331[(13)]);
var inst_33167 = cljs.core.keys.call(null,inst_33116);
var inst_33168 = cljs.core.first.call(null,inst_33167);
var inst_33169 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_33170 = cljs.core.vals.call(null,inst_33116);
var inst_33171 = cljs.core.first.call(null,inst_33170);
var inst_33172 = [headers,vars,inst_33171];
var inst_33173 = cljs.core.PersistentHashMap.fromArrays(inst_33169,inst_33172);
var inst_33174 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_33173,select_spec,limit,opts);
var state_33331__$1 = (function (){var statearr_33365 = state_33331;
(statearr_33365[(19)] = inst_33168);

return statearr_33365;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33331__$1,(36),inst_33174);
} else {
if((state_val_33332 === (13))){
var inst_33133 = cljs.core.not.call(null,orderBy);
var state_33331__$1 = state_33331;
if(inst_33133){
var statearr_33366_33486 = state_33331__$1;
(statearr_33366_33486[(1)] = (18));

} else {
var statearr_33367_33487 = state_33331__$1;
(statearr_33367_33487[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (22))){
var inst_33136 = (state_33331[(20)]);
var state_33331__$1 = state_33331;
var statearr_33368_33488 = state_33331__$1;
(statearr_33368_33488[(2)] = inst_33136);

(statearr_33368_33488[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (36))){
var inst_33168 = (state_33331[(19)]);
var inst_33176 = (state_33331[(2)]);
var inst_33177 = fluree.db.util.async.throw_err.call(null,inst_33176);
var inst_33178 = [inst_33168];
var inst_33179 = [inst_33177];
var inst_33180 = cljs.core.PersistentHashMap.fromArrays(inst_33178,inst_33179);
var state_33331__$1 = state_33331;
var statearr_33369_33489 = state_33331__$1;
(statearr_33369_33489[(2)] = inst_33180);

(statearr_33369_33489[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (41))){
var inst_33278 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33370_33490 = state_33331__$1;
(statearr_33370_33490[(2)] = inst_33278);

(statearr_33370_33490[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (43))){
var state_33331__$1 = state_33331;
var statearr_33371_33491 = state_33331__$1;
(statearr_33371_33491[(1)] = (45));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (61))){
var inst_33280 = (state_33331[(11)]);
var state_33331__$1 = state_33331;
var statearr_33373_33492 = state_33331__$1;
(statearr_33373_33492[(2)] = inst_33280);

(statearr_33373_33492[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (29))){
var inst_33154 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33374_33493 = state_33331__$1;
(statearr_33374_33493[(2)] = inst_33154);

(statearr_33374_33493[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (44))){
var inst_33276 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33375_33494 = state_33331__$1;
(statearr_33375_33494[(2)] = inst_33276);

(statearr_33375_33494[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (6))){
var inst_33117 = (state_33331[(21)]);
var inst_33116 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var inst_33117__$1 = orderBy;
var state_33331__$1 = (function (){var statearr_33376 = state_33331;
(statearr_33376[(21)] = inst_33117__$1);

(statearr_33376[(13)] = inst_33116);

return statearr_33376;
})();
if(cljs.core.truth_(inst_33117__$1)){
var statearr_33377_33495 = state_33331__$1;
(statearr_33377_33495[(1)] = (9));

} else {
var statearr_33378_33496 = state_33331__$1;
(statearr_33378_33496[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (28))){
var inst_33146 = (state_33331[(12)]);
var inst_33116 = (state_33331[(13)]);
var inst_33147 = (state_33331[(14)]);
var inst_33152 = (function (){var group_map = inst_33116;
var orderByIdx = inst_33146;
var orderDirection = inst_33147;
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
})();
var state_33331__$1 = state_33331;
var statearr_33380_33497 = state_33331__$1;
(statearr_33380_33497[(2)] = inst_33152);

(statearr_33380_33497[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (64))){
var state_33331__$1 = state_33331;
var statearr_33381_33498 = state_33331__$1;
(statearr_33381_33498[(2)] = limit);

(statearr_33381_33498[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (51))){
var inst_33223 = (state_33331[(22)]);
var inst_33219 = (state_33331[(8)]);
var inst_33220 = (state_33331[(23)]);
var inst_33210 = (state_33331[(9)]);
var inst_33234 = (state_33331[(18)]);
var inst_33209 = (state_33331[(16)]);
var inst_33242 = (state_33331[(2)]);
var inst_33243 = fluree.db.util.async.throw_err.call(null,inst_33242);
var inst_33244 = cljs.core.assoc.call(null,inst_33210,inst_33219,inst_33243);
var tmp33379 = inst_33209;
var inst_33206 = inst_33220;
var inst_33207 = inst_33223;
var inst_33208 = inst_33234;
var inst_33209__$1 = tmp33379;
var inst_33210__$1 = inst_33244;
var state_33331__$1 = (function (){var statearr_33382 = state_33331;
(statearr_33382[(24)] = inst_33208);

(statearr_33382[(9)] = inst_33210__$1);

(statearr_33382[(25)] = inst_33206);

(statearr_33382[(26)] = inst_33207);

(statearr_33382[(16)] = inst_33209__$1);

return statearr_33382;
})();
var statearr_33383_33499 = state_33331__$1;
(statearr_33383_33499[(2)] = null);

(statearr_33383_33499[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (25))){
var state_33331__$1 = state_33331;
var statearr_33384_33500 = state_33331__$1;
(statearr_33384_33500[(1)] = (30));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (34))){
var inst_33116 = (state_33331[(13)]);
var inst_33196 = cljs.core.keys.call(null,inst_33116);
var inst_33197 = cljs.core.seq.call(null,inst_33196);
var inst_33198 = cljs.core.first.call(null,inst_33197);
var inst_33199 = cljs.core.next.call(null,inst_33197);
var inst_33200 = cljs.core.vals.call(null,inst_33116);
var inst_33201 = cljs.core.seq.call(null,inst_33200);
var inst_33202 = cljs.core.first.call(null,inst_33201);
var inst_33203 = cljs.core.next.call(null,inst_33201);
var inst_33204 = offset;
var inst_33205 = cljs.core.PersistentHashMap.EMPTY;
var inst_33206 = inst_33196;
var inst_33207 = inst_33200;
var inst_33208 = (0);
var inst_33209 = inst_33204;
var inst_33210 = inst_33205;
var state_33331__$1 = (function (){var statearr_33386 = state_33331;
(statearr_33386[(27)] = inst_33203);

(statearr_33386[(28)] = inst_33198);

(statearr_33386[(29)] = inst_33202);

(statearr_33386[(24)] = inst_33208);

(statearr_33386[(9)] = inst_33210);

(statearr_33386[(30)] = inst_33199);

(statearr_33386[(25)] = inst_33206);

(statearr_33386[(26)] = inst_33207);

(statearr_33386[(16)] = inst_33209);

return statearr_33386;
})();
var statearr_33387_33501 = state_33331__$1;
(statearr_33387_33501[(2)] = null);

(statearr_33387_33501[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (17))){
var inst_33131 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33388_33502 = state_33331__$1;
(statearr_33388_33502[(2)] = inst_33131);

(statearr_33388_33502[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (3))){
var inst_33329 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33331__$1,inst_33329);
} else {
if((state_val_33332 === (12))){
var inst_33125 = cljs.core.first.call(null,orderBy);
var inst_33126 = cljs.core._EQ_.call(null,inst_33125,"DESC");
var state_33331__$1 = state_33331;
if(inst_33126){
var statearr_33389_33503 = state_33331__$1;
(statearr_33389_33503[(1)] = (15));

} else {
var statearr_33390_33504 = state_33331__$1;
(statearr_33390_33504[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (2))){
var _ = (function (){var statearr_33391 = state_33331;
(statearr_33391[(4)] = cljs.core.cons.call(null,(5),(state_33331[(4)])));

return statearr_33391;
})();
var state_33331__$1 = state_33331;
if(cljs.core.truth_(groupBy)){
var statearr_33392_33505 = state_33331__$1;
(statearr_33392_33505[(1)] = (6));

} else {
var statearr_33393_33506 = state_33331__$1;
(statearr_33393_33506[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (66))){
var inst_33297 = (state_33331[(7)]);
var inst_33296 = (state_33331[(2)]);
var inst_33297__$1 = fluree.db.util.async.throw_err.call(null,inst_33296);
var inst_33298 = cljs.core.coll_QMARK_.call(null,inst_33297__$1);
var inst_33299 = (!(inst_33298));
var state_33331__$1 = (function (){var statearr_33394 = state_33331;
(statearr_33394[(7)] = inst_33297__$1);

return statearr_33394;
})();
if(inst_33299){
var statearr_33395_33507 = state_33331__$1;
(statearr_33395_33507[(1)] = (67));

} else {
var statearr_33396_33508 = state_33331__$1;
(statearr_33396_33508[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (23))){
var inst_33143 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
if(cljs.core.truth_(inst_33143)){
var statearr_33397_33509 = state_33331__$1;
(statearr_33397_33509[(1)] = (24));

} else {
var statearr_33398_33510 = state_33331__$1;
(statearr_33398_33510[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (47))){
var inst_33274 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33399_33511 = state_33331__$1;
(statearr_33399_33511[(2)] = inst_33274);

(statearr_33399_33511[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (35))){
var inst_33288 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33400_33512 = state_33331__$1;
(statearr_33400_33512[(2)] = inst_33288);

(statearr_33400_33512[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (76))){
var inst_33297 = (state_33331[(7)]);
var inst_33313 = cljs.core.distinct.call(null,inst_33297);
var state_33331__$1 = state_33331;
var statearr_33401_33513 = state_33331__$1;
(statearr_33401_33513[(2)] = inst_33313);

(statearr_33401_33513[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (19))){
var inst_33136 = (state_33331[(20)]);
var inst_33136__$1 = orderBy;
var state_33331__$1 = (function (){var statearr_33402 = state_33331;
(statearr_33402[(20)] = inst_33136__$1);

return statearr_33402;
})();
if(cljs.core.truth_(inst_33136__$1)){
var statearr_33403_33514 = state_33331__$1;
(statearr_33403_33514[(1)] = (21));

} else {
var statearr_33404_33515 = state_33331__$1;
(statearr_33404_33515[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (57))){
var state_33331__$1 = state_33331;
var statearr_33405_33516 = state_33331__$1;
(statearr_33405_33516[(2)] = null);

(statearr_33405_33516[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (68))){
var state_33331__$1 = state_33331;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_33406_33517 = state_33331__$1;
(statearr_33406_33517[(1)] = (73));

} else {
var statearr_33407_33518 = state_33331__$1;
(statearr_33407_33518[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (11))){
var inst_33123 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
if(cljs.core.truth_(inst_33123)){
var statearr_33409_33519 = state_33331__$1;
(statearr_33409_33519[(1)] = (12));

} else {
var statearr_33410_33520 = state_33331__$1;
(statearr_33410_33520[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (9))){
var inst_33119 = cljs.core.second.call(null,orderBy);
var inst_33120 = cljs.core._EQ_.call(null,inst_33119,groupBy);
var state_33331__$1 = state_33331;
var statearr_33411_33521 = state_33331__$1;
(statearr_33411_33521[(2)] = inst_33120);

(statearr_33411_33521[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (5))){
var _ = (function (){var statearr_33412 = state_33331;
(statearr_33412[(4)] = cljs.core.rest.call(null,(state_33331[(4)])));

return statearr_33412;
})();
var state_33331__$1 = state_33331;
var ex33408 = (state_33331__$1[(2)]);
var statearr_33413_33522 = state_33331__$1;
(statearr_33413_33522[(5)] = ex33408);


if((ex33408 instanceof Error)){
var statearr_33414_33523 = state_33331__$1;
(statearr_33414_33523[(1)] = (4));

(statearr_33414_33523[(5)] = null);

} else {
throw ex33408;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (14))){
var inst_33165 = (state_33331[(2)]);
var state_33331__$1 = (function (){var statearr_33415 = state_33331;
(statearr_33415[(10)] = inst_33165);

return statearr_33415;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_33416_33524 = state_33331__$1;
(statearr_33416_33524[(1)] = (33));

} else {
var statearr_33417_33525 = state_33331__$1;
(statearr_33417_33525[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (45))){
var inst_33222 = (state_33331[(17)]);
var inst_33208 = (state_33331[(24)]);
var inst_33234 = (state_33331[(18)]);
var inst_33233 = cljs.core.count.call(null,inst_33222);
var inst_33234__$1 = (inst_33208 + inst_33233);
var inst_33235 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_33236 = [headers,vars,inst_33222];
var inst_33237 = cljs.core.PersistentHashMap.fromArrays(inst_33235,inst_33236);
var inst_33238 = (limit > inst_33234__$1);
var state_33331__$1 = (function (){var statearr_33418 = state_33331;
(statearr_33418[(15)] = inst_33237);

(statearr_33418[(18)] = inst_33234__$1);

return statearr_33418;
})();
if(cljs.core.truth_(inst_33238)){
var statearr_33419_33526 = state_33331__$1;
(statearr_33419_33526[(1)] = (48));

} else {
var statearr_33420_33527 = state_33331__$1;
(statearr_33420_33527[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (53))){
var inst_33234 = (state_33331[(18)]);
var inst_33255 = (limit < inst_33234);
var state_33331__$1 = state_33331;
if(cljs.core.truth_(inst_33255)){
var statearr_33421_33528 = state_33331__$1;
(statearr_33421_33528[(1)] = (56));

} else {
var statearr_33422_33529 = state_33331__$1;
(statearr_33422_33529[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (78))){
var inst_33320 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33423_33530 = state_33331__$1;
(statearr_33423_33530[(2)] = inst_33320);

(statearr_33423_33530[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (26))){
var inst_33161 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33424_33531 = state_33331__$1;
(statearr_33424_33531[(2)] = inst_33161);

(statearr_33424_33531[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (16))){
var state_33331__$1 = state_33331;
var statearr_33425_33532 = state_33331__$1;
(statearr_33425_33532[(2)] = fluree.db.query.fql.compare_fn);

(statearr_33425_33532[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (81))){
var inst_33318 = (state_33331[(2)]);
var state_33331__$1 = state_33331;
var statearr_33426_33533 = state_33331__$1;
(statearr_33426_33533[(2)] = inst_33318);

(statearr_33426_33533[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (79))){
var inst_33297 = (state_33331[(7)]);
var state_33331__$1 = state_33331;
var statearr_33427_33534 = state_33331__$1;
(statearr_33427_33534[(2)] = inst_33297);

(statearr_33427_33534[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (38))){
var inst_33165 = (state_33331[(10)]);
var inst_33280 = (state_33331[(2)]);
var state_33331__$1 = (function (){var statearr_33428 = state_33331;
(statearr_33428[(11)] = inst_33280);

return statearr_33428;
})();
if(cljs.core.truth_(inst_33165)){
var statearr_33429_33535 = state_33331__$1;
(statearr_33429_33535[(1)] = (60));

} else {
var statearr_33430_33536 = state_33331__$1;
(statearr_33430_33536[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (30))){
var state_33331__$1 = state_33331;
var statearr_33431_33537 = state_33331__$1;
(statearr_33431_33537[(2)] = null);

(statearr_33431_33537[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (73))){
var inst_33297 = (state_33331[(7)]);
var inst_33310 = cljs.core.first.call(null,inst_33297);
var state_33331__$1 = state_33331;
var statearr_33432_33538 = state_33331__$1;
(statearr_33432_33538[(2)] = inst_33310);

(statearr_33432_33538[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (10))){
var inst_33117 = (state_33331[(21)]);
var state_33331__$1 = state_33331;
var statearr_33433_33539 = state_33331__$1;
(statearr_33433_33539[(2)] = inst_33117);

(statearr_33433_33539[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (18))){
var state_33331__$1 = state_33331;
var statearr_33434_33540 = state_33331__$1;
(statearr_33434_33540[(2)] = null);

(statearr_33434_33540[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (52))){
var inst_33237 = (state_33331[(15)]);
var inst_33249 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_33237,select_spec,opts);
var state_33331__$1 = state_33331;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33331__$1,(55),inst_33249);
} else {
if((state_val_33332 === (67))){
var state_33331__$1 = state_33331;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_33437_33541 = state_33331__$1;
(statearr_33437_33541[(1)] = (70));

} else {
var statearr_33438_33542 = state_33331__$1;
(statearr_33438_33542[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (71))){
var inst_33297 = (state_33331[(7)]);
var state_33331__$1 = state_33331;
var statearr_33439_33543 = state_33331__$1;
(statearr_33439_33543[(2)] = inst_33297);

(statearr_33439_33543[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (42))){
var inst_33223 = (state_33331[(22)]);
var inst_33220 = (state_33331[(23)]);
var inst_33208 = (state_33331[(24)]);
var inst_33210 = (state_33331[(9)]);
var inst_33209 = (state_33331[(16)]);
var inst_33229 = (inst_33209 - (1));
var tmp33435 = inst_33208;
var tmp33436 = inst_33210;
var inst_33206 = inst_33220;
var inst_33207 = inst_33223;
var inst_33208__$1 = tmp33435;
var inst_33209__$1 = inst_33229;
var inst_33210__$1 = tmp33436;
var state_33331__$1 = (function (){var statearr_33440 = state_33331;
(statearr_33440[(24)] = inst_33208__$1);

(statearr_33440[(9)] = inst_33210__$1);

(statearr_33440[(25)] = inst_33206);

(statearr_33440[(26)] = inst_33207);

(statearr_33440[(16)] = inst_33209__$1);

return statearr_33440;
})();
var statearr_33441_33544 = state_33331__$1;
(statearr_33441_33544[(2)] = null);

(statearr_33441_33544[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (80))){
var state_33331__$1 = state_33331;
var statearr_33442_33545 = state_33331__$1;
(statearr_33442_33545[(2)] = null);

(statearr_33442_33545[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (37))){
var inst_33222 = (state_33331[(17)]);
var inst_33206 = (state_33331[(25)]);
var inst_33207 = (state_33331[(26)]);
var inst_33218 = cljs.core.seq.call(null,inst_33206);
var inst_33219 = cljs.core.first.call(null,inst_33218);
var inst_33220 = cljs.core.next.call(null,inst_33218);
var inst_33221 = cljs.core.seq.call(null,inst_33207);
var inst_33222__$1 = cljs.core.first.call(null,inst_33221);
var inst_33223 = cljs.core.next.call(null,inst_33221);
var inst_33224 = (inst_33222__$1 == null);
var state_33331__$1 = (function (){var statearr_33443 = state_33331;
(statearr_33443[(22)] = inst_33223);

(statearr_33443[(17)] = inst_33222__$1);

(statearr_33443[(8)] = inst_33219);

(statearr_33443[(23)] = inst_33220);

return statearr_33443;
})();
if(cljs.core.truth_(inst_33224)){
var statearr_33444_33546 = state_33331__$1;
(statearr_33444_33546[(1)] = (39));

} else {
var statearr_33445_33547 = state_33331__$1;
(statearr_33445_33547[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (63))){
var state_33331__$1 = state_33331;
var statearr_33446_33548 = state_33331__$1;
(statearr_33446_33548[(2)] = (1));

(statearr_33446_33548[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (8))){
var inst_33326 = (state_33331[(2)]);
var _ = (function (){var statearr_33447 = state_33331;
(statearr_33447[(4)] = cljs.core.rest.call(null,(state_33331[(4)])));

return statearr_33447;
})();
var state_33331__$1 = state_33331;
var statearr_33448_33549 = state_33331__$1;
(statearr_33448_33549[(2)] = inst_33326);

(statearr_33448_33549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33332 === (49))){
var inst_33234 = (state_33331[(18)]);
var inst_33247 = cljs.core._EQ_.call(null,limit,inst_33234);
var state_33331__$1 = state_33331;
if(inst_33247){
var statearr_33449_33550 = state_33331__$1;
(statearr_33449_33550[(1)] = (52));

} else {
var statearr_33450_33551 = state_33331__$1;
(statearr_33450_33551[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11469__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11469__auto____0 = (function (){
var statearr_33451 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33451[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11469__auto__);

(statearr_33451[(1)] = (1));

return statearr_33451;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11469__auto____1 = (function (state_33331){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_33331);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e33452){var ex__11472__auto__ = e33452;
var statearr_33453_33552 = state_33331;
(statearr_33453_33552[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_33331[(4)]))){
var statearr_33454_33553 = state_33331;
(statearr_33454_33553[(1)] = cljs.core.first.call(null,(state_33331[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33554 = state_33331;
state_33331 = G__33554;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11469__auto__ = function(state_33331){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11469__auto____1.call(this,state_33331);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11469__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11469__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_33455 = f__11543__auto__.call(null);
(statearr_33455[(6)] = c__11542__auto__);

return statearr_33455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__33557,opts){
var map__33558 = p__33557;
var map__33558__$1 = (((((!((map__33558 == null))))?(((((map__33558.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33558.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33558):map__33558);
var selectOne = cljs.core.get.call(null,map__33558__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__33558__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__33558__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__33558__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__33555_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__33555_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__33556_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__33556_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__33560,p__33561){
var map__33562 = p__33560;
var map__33562__$1 = (((((!((map__33562 == null))))?(((((map__33562.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33562.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33562):map__33562);
var query_map = map__33562__$1;
var construct = cljs.core.get.call(null,map__33562__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__33563 = p__33561;
var map__33563__$1 = (((((!((map__33563 == null))))?(((((map__33563.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33563.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33563):map__33563);
var where_result = map__33563__$1;
var headers = cljs.core.get.call(null,map__33563__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__33563__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__33566 = cljs.core.map.call(null,(function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__33566,(0),null);
var fn2 = cljs.core.nth.call(null,vec__33566,(1),null);
var fn3 = cljs.core.nth.call(null,vec__33566,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_33599){
var state_val_33600 = (state_33599[(1)]);
if((state_val_33600 === (7))){
var inst_33578 = (state_33599[(7)]);
var state_33599__$1 = state_33599;
var statearr_33601_33624 = state_33599__$1;
(statearr_33601_33624[(2)] = inst_33578);

(statearr_33601_33624[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33600 === (1))){
var state_33599__$1 = state_33599;
var statearr_33602_33625 = state_33599__$1;
(statearr_33602_33625[(2)] = null);

(statearr_33602_33625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33600 === (4))){
var inst_33569 = (state_33599[(2)]);
var state_33599__$1 = state_33599;
var statearr_33603_33626 = state_33599__$1;
(statearr_33603_33626[(2)] = inst_33569);

(statearr_33603_33626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33600 === (13))){
var inst_33588 = (state_33599[(2)]);
var inst_33589 = fluree.db.util.async.throw_err.call(null,inst_33588);
var state_33599__$1 = state_33599;
var statearr_33604_33627 = state_33599__$1;
(statearr_33604_33627[(2)] = inst_33589);

(statearr_33604_33627[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33600 === (6))){
var inst_33578 = (state_33599[(7)]);
var inst_33577 = (state_33599[(2)]);
var inst_33578__$1 = fluree.db.util.async.throw_err.call(null,inst_33577);
var inst_33579 = fluree.db.util.core.exception_QMARK_.call(null,inst_33578__$1);
var state_33599__$1 = (function (){var statearr_33605 = state_33599;
(statearr_33605[(7)] = inst_33578__$1);

return statearr_33605;
})();
if(inst_33579){
var statearr_33606_33628 = state_33599__$1;
(statearr_33606_33628[(1)] = (7));

} else {
var statearr_33607_33629 = state_33599__$1;
(statearr_33607_33629[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33600 === (3))){
var inst_33597 = (state_33599[(2)]);
var state_33599__$1 = state_33599;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33599__$1,inst_33597);
} else {
if((state_val_33600 === (12))){
var inst_33592 = (state_33599[(2)]);
var state_33599__$1 = state_33599;
var statearr_33608_33630 = state_33599__$1;
(statearr_33608_33630[(2)] = inst_33592);

(statearr_33608_33630[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33600 === (2))){
var _ = (function (){var statearr_33609 = state_33599;
(statearr_33609[(4)] = cljs.core.cons.call(null,(5),(state_33599[(4)])));

return statearr_33609;
})();
var inst_33575 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_33599__$1 = state_33599;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33599__$1,(6),inst_33575);
} else {
if((state_val_33600 === (11))){
var state_33599__$1 = state_33599;
var statearr_33611_33631 = state_33599__$1;
(statearr_33611_33631[(2)] = null);

(statearr_33611_33631[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33600 === (9))){
var inst_33594 = (state_33599[(2)]);
var _ = (function (){var statearr_33612 = state_33599;
(statearr_33612[(4)] = cljs.core.rest.call(null,(state_33599[(4)])));

return statearr_33612;
})();
var state_33599__$1 = state_33599;
var statearr_33613_33632 = state_33599__$1;
(statearr_33613_33632[(2)] = inst_33594);

(statearr_33613_33632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33600 === (5))){
var _ = (function (){var statearr_33614 = state_33599;
(statearr_33614[(4)] = cljs.core.rest.call(null,(state_33599[(4)])));

return statearr_33614;
})();
var state_33599__$1 = state_33599;
var ex33610 = (state_33599__$1[(2)]);
var statearr_33615_33633 = state_33599__$1;
(statearr_33615_33633[(5)] = ex33610);


if((ex33610 instanceof Error)){
var statearr_33616_33634 = state_33599__$1;
(statearr_33616_33634[(1)] = (4));

(statearr_33616_33634[(5)] = null);

} else {
throw ex33610;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33600 === (10))){
var inst_33578 = (state_33599[(7)]);
var inst_33583 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_33578);
var inst_33584 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_33578);
var inst_33585 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_33583,inst_33584,query_map,opts);
var inst_33586 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,inst_33578,inst_33585,opts);
var state_33599__$1 = state_33599;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33599__$1,(13),inst_33586);
} else {
if((state_val_33600 === (8))){
var state_33599__$1 = state_33599;
var statearr_33617_33635 = state_33599__$1;
(statearr_33617_33635[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__11469__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__11469__auto____0 = (function (){
var statearr_33619 = [null,null,null,null,null,null,null,null];
(statearr_33619[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__11469__auto__);

(statearr_33619[(1)] = (1));

return statearr_33619;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__11469__auto____1 = (function (state_33599){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_33599);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e33620){var ex__11472__auto__ = e33620;
var statearr_33621_33636 = state_33599;
(statearr_33621_33636[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_33599[(4)]))){
var statearr_33622_33637 = state_33599;
(statearr_33622_33637[(1)] = cljs.core.first.call(null,(state_33599[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33638 = state_33599;
state_33599 = G__33638;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__11469__auto__ = function(state_33599){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__11469__auto____1.call(this,state_33599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__11469__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__11469__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_33623 = f__11543__auto__.call(null);
(statearr_33623[(6)] = c__11542__auto__);

return statearr_33623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__33639 = query_map;
var map__33639__$1 = (((((!((map__33639 == null))))?(((((map__33639.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33639.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33639):map__33639);
var select = cljs.core.get.call(null,map__33639__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__33639__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__33639__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__33639__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__33639__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__33639__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__33639__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__33639__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__33639__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__33639__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.call(null,map__33639__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.call(null,map__33639__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__33641 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.call(null,G__33641,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__33641;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_34009){
var state_val_34010 = (state_34009[(1)]);
if((state_val_34010 === (121))){
var inst_33950 = (state_34009[(7)]);
var inst_33723 = (state_34009[(8)]);
var inst_33721 = (state_34009[(9)]);
var inst_33954 = (state_34009[(10)]);
var inst_33958 = (state_34009[(2)]);
var inst_33959 = fluree.db.query.fql.subject_select.call(null,db,inst_33723,fuel,max_fuel,inst_33721,inst_33950,inst_33954,inst_33958);
var state_34009__$1 = state_34009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34009__$1,(115),inst_33959);
} else {
if((state_val_34010 === (65))){
var inst_33723 = (state_34009[(8)]);
var inst_33721 = (state_34009[(9)]);
var inst_33711 = (state_34009[(11)]);
var inst_33800 = (state_34009[(12)]);
var inst_33814 = (state_34009[(2)]);
var inst_33815 = fluree.db.util.async.throw_err.call(null,inst_33814);
var inst_33816 = cljs.core.sequence.call(null,inst_33800,inst_33815);
var inst_33817 = fluree.db.query.fql.subject_select.call(null,db,inst_33723,fuel,max_fuel,inst_33721,inst_33816,inst_33711);
var state_34009__$1 = state_34009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34009__$1,(66),inst_33817);
} else {
if((state_val_34010 === (70))){
var inst_33710 = (state_34009[(13)]);
var state_34009__$1 = state_34009;
if(cljs.core.truth_(inst_33710)){
var statearr_34011_34203 = state_34009__$1;
(statearr_34011_34203[(1)] = (73));

} else {
var statearr_34012_34204 = state_34009__$1;
(statearr_34012_34204[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (62))){
var inst_33802 = cljs.core.PersistentHashMap.EMPTY;
var state_34009__$1 = state_34009;
var statearr_34013_34205 = state_34009__$1;
(statearr_34013_34205[(2)] = inst_33802);

(statearr_34013_34205[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (74))){
var inst_33713 = (state_34009[(14)]);
var inst_33711 = (state_34009[(11)]);
var inst_33835 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_33836 = [inst_33711,inst_33713];
var inst_33837 = cljs.core.PersistentHashMap.fromArrays(inst_33835,inst_33836);
var state_34009__$1 = state_34009;
var statearr_34014_34206 = state_34009__$1;
(statearr_34014_34206[(2)] = inst_33837);

(statearr_34014_34206[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (110))){
var inst_33918 = (state_34009[(15)]);
var inst_33932 = (state_34009[(2)]);
var inst_33933 = fluree.db.dbproto._subid.call(null,db,inst_33918,false);
var state_34009__$1 = (function (){var statearr_34015 = state_34009;
(statearr_34015[(16)] = inst_33932);

return statearr_34015;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34009__$1,(111),inst_33933);
} else {
if((state_val_34010 === (130))){
var inst_33999 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
if(cljs.core.truth_(inst_33999)){
var statearr_34016_34207 = state_34009__$1;
(statearr_34016_34207[(1)] = (131));

} else {
var statearr_34017_34208 = state_34009__$1;
(statearr_34017_34208[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (128))){
var inst_33990 = (state_34009[(17)]);
var inst_33993 = cljs.core.coll_QMARK_.call(null,inst_33990);
var inst_33994 = fluree.db.util.core.exception_QMARK_.call(null,inst_33990);
var inst_33995 = (!(inst_33994));
var inst_33996 = ((inst_33993) && (inst_33995));
var state_34009__$1 = state_34009;
var statearr_34018_34209 = state_34009__$1;
(statearr_34018_34209[(2)] = inst_33996);

(statearr_34018_34209[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (7))){
var inst_33671 = (state_34009[(18)]);
var inst_33671__$1 = selectOne;
var state_34009__$1 = (function (){var statearr_34019 = state_34009;
(statearr_34019[(18)] = inst_33671__$1);

return statearr_34019;
})();
if(cljs.core.truth_(inst_33671__$1)){
var statearr_34020_34210 = state_34009__$1;
(statearr_34020_34210[(1)] = (9));

} else {
var statearr_34021_34211 = state_34009__$1;
(statearr_34021_34211[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (59))){
var inst_33794 = (state_34009[(19)]);
var inst_33796 = cljs.core.distinct.call(null);
var inst_33797 = cljs.core.comp.call(null,inst_33794,inst_33796);
var state_34009__$1 = state_34009;
var statearr_34022_34212 = state_34009__$1;
(statearr_34022_34212[(2)] = inst_33797);

(statearr_34022_34212[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (86))){
var inst_33871 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_34009__$1 = state_34009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34009__$1,(89),inst_33871);
} else {
if((state_val_34010 === (20))){
var inst_33701 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34023_34213 = state_34009__$1;
(statearr_34023_34213[(2)] = inst_33701);

(statearr_34023_34213[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (72))){
var inst_33981 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34024_34214 = state_34009__$1;
(statearr_34024_34214[(2)] = inst_33981);

(statearr_34024_34214[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (58))){
var inst_33794 = (state_34009[(2)]);
var state_34009__$1 = (function (){var statearr_34025 = state_34009;
(statearr_34025[(19)] = inst_33794);

return statearr_34025;
})();
var statearr_34026_34215 = state_34009__$1;
(statearr_34026_34215[(1)] = (59));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (60))){
var inst_33794 = (state_34009[(19)]);
var state_34009__$1 = state_34009;
var statearr_34028_34216 = state_34009__$1;
(statearr_34028_34216[(2)] = inst_33794);

(statearr_34028_34216[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (27))){
var inst_33710 = (state_34009[(13)]);
var inst_33725 = cljs.core.vector_QMARK_.call(null,inst_33710);
var state_34009__$1 = state_34009;
if(inst_33725){
var statearr_34029_34217 = state_34009__$1;
(statearr_34029_34217[(1)] = (30));

} else {
var statearr_34030_34218 = state_34009__$1;
(statearr_34030_34218[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (1))){
var state_34009__$1 = state_34009;
var statearr_34031_34219 = state_34009__$1;
(statearr_34031_34219[(2)] = null);

(statearr_34031_34219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (69))){
var inst_33830 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
if(cljs.core.truth_(inst_33830)){
var statearr_34032_34220 = state_34009__$1;
(statearr_34032_34220[(1)] = (70));

} else {
var statearr_34033_34221 = state_34009__$1;
(statearr_34033_34221[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (101))){
var inst_33710 = (state_34009[(13)]);
var inst_33948 = (state_34009[(2)]);
var inst_33949 = cljs.core.PersistentVector.EMPTY;
var inst_33950 = cljs.core.into.call(null,inst_33949,inst_33948);
var state_34009__$1 = (function (){var statearr_34034 = state_34009;
(statearr_34034[(7)] = inst_33950);

return statearr_34034;
})();
if(cljs.core.truth_(inst_33710)){
var statearr_34035_34222 = state_34009__$1;
(statearr_34035_34222[(1)] = (116));

} else {
var statearr_34036_34223 = state_34009__$1;
(statearr_34036_34223[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (24))){
var inst_33714 = (state_34009[(20)]);
var inst_33712 = (state_34009[(21)]);
var inst_33718 = cljs.core.assoc.call(null,inst_33714,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_33712);
var state_34009__$1 = state_34009;
var statearr_34037_34224 = state_34009__$1;
(statearr_34037_34224[(2)] = inst_33718);

(statearr_34037_34224[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (102))){
var inst_33912 = (state_34009[(22)]);
var state_34009__$1 = state_34009;
var statearr_34038_34225 = state_34009__$1;
(statearr_34038_34225[(2)] = inst_33912);

(statearr_34038_34225[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (55))){
var inst_33983 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34039_34226 = state_34009__$1;
(statearr_34039_34226[(2)] = inst_33983);

(statearr_34039_34226[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (85))){
var inst_33865 = (state_34009[(2)]);
var inst_33866 = fluree.db.util.async.throw_err.call(null,inst_33865);
var state_34009__$1 = state_34009;
var statearr_34040_34227 = state_34009__$1;
(statearr_34040_34227[(2)] = inst_33866);

(statearr_34040_34227[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (39))){
var inst_33760 = typeof from === 'string';
var state_34009__$1 = state_34009;
if(cljs.core.truth_(inst_33760)){
var statearr_34041_34228 = state_34009__$1;
(statearr_34041_34228[(1)] = (42));

} else {
var statearr_34042_34229 = state_34009__$1;
(statearr_34042_34229[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (88))){
var inst_33977 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34043_34230 = state_34009__$1;
(statearr_34043_34230[(2)] = inst_33977);

(statearr_34043_34230[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (46))){
var inst_33779 = (state_34009[(2)]);
var inst_33780 = fluree.db.util.async.throw_err.call(null,inst_33779);
var state_34009__$1 = state_34009;
var statearr_34044_34231 = state_34009__$1;
(statearr_34044_34231[(2)] = inst_33780);

(statearr_34044_34231[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (4))){
var inst_33658 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34045_34232 = state_34009__$1;
(statearr_34045_34232[(2)] = inst_33658);

(statearr_34045_34232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (77))){
var inst_33846 = (state_34009[(2)]);
var inst_33847 = fluree.db.util.async.throw_err.call(null,inst_33846);
var state_34009__$1 = state_34009;
var statearr_34046_34233 = state_34009__$1;
(statearr_34046_34233[(2)] = inst_33847);

(statearr_34046_34233[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (106))){
var state_34009__$1 = state_34009;
if(cljs.core.truth_(fuel)){
var statearr_34047_34234 = state_34009__$1;
(statearr_34047_34234[(1)] = (108));

} else {
var statearr_34048_34235 = state_34009__$1;
(statearr_34048_34235[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (119))){
var state_34009__$1 = state_34009;
var statearr_34049_34236 = state_34009__$1;
(statearr_34049_34236[(2)] = null);

(statearr_34049_34236[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (95))){
var state_34009__$1 = state_34009;
var statearr_34050_34237 = state_34009__$1;
(statearr_34050_34237[(2)] = null);

(statearr_34050_34237[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (54))){
var inst_33822 = typeof from === 'string';
var state_34009__$1 = state_34009;
if(cljs.core.truth_(inst_33822)){
var statearr_34051_34238 = state_34009__$1;
(statearr_34051_34238[(1)] = (67));

} else {
var statearr_34052_34239 = state_34009__$1;
(statearr_34052_34239[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (92))){
var inst_33723 = (state_34009[(8)]);
var inst_33721 = (state_34009[(9)]);
var inst_33713 = (state_34009[(14)]);
var inst_33711 = (state_34009[(11)]);
var inst_33882 = (state_34009[(2)]);
var inst_33883 = fluree.db.query.fql.subject_select.call(null,db,inst_33723,fuel,max_fuel,inst_33721,inst_33882,inst_33711,inst_33713);
var state_34009__$1 = state_34009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34009__$1,(93),inst_33883);
} else {
if((state_val_34010 === (104))){
var inst_33946 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34053_34240 = state_34009__$1;
(statearr_34053_34240[(2)] = inst_33946);

(statearr_34053_34240[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (15))){
var inst_33688 = (state_34009[(23)]);
var inst_33693 = inst_33688.cljs$lang$protocol_mask$partition0$;
var inst_33694 = (inst_33693 & (64));
var inst_33695 = inst_33688.cljs$core$ISeq$;
var inst_33696 = (cljs.core.PROTOCOL_SENTINEL === inst_33695);
var inst_33697 = ((inst_33694) || (inst_33696));
var state_34009__$1 = state_34009;
if(cljs.core.truth_(inst_33697)){
var statearr_34054_34241 = state_34009__$1;
(statearr_34054_34241[(1)] = (18));

} else {
var statearr_34055_34242 = state_34009__$1;
(statearr_34055_34242[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (48))){
var inst_33711 = (state_34009[(11)]);
var state_34009__$1 = state_34009;
var statearr_34056_34243 = state_34009__$1;
(statearr_34056_34243[(2)] = inst_33711);

(statearr_34056_34243[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (50))){
var state_34009__$1 = state_34009;
var statearr_34057_34244 = state_34009__$1;
(statearr_34057_34244[(2)] = null);

(statearr_34057_34244[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (116))){
var state_34009__$1 = state_34009;
var statearr_34058_34245 = state_34009__$1;
(statearr_34058_34245[(2)] = null);

(statearr_34058_34245[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (75))){
var inst_33839 = (state_34009[(2)]);
var inst_33840 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_33839);
var state_34009__$1 = state_34009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34009__$1,(76),inst_33840);
} else {
if((state_val_34010 === (99))){
var inst_33975 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34059_34246 = state_34009__$1;
(statearr_34059_34246[(2)] = inst_33975);

(statearr_34059_34246[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (21))){
var inst_33688 = (state_34009[(23)]);
var inst_33706 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33688);
var state_34009__$1 = state_34009;
var statearr_34060_34247 = state_34009__$1;
(statearr_34060_34247[(2)] = inst_33706);

(statearr_34060_34247[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (31))){
var inst_33710 = (state_34009[(13)]);
var inst_33733 = typeof inst_33710 === 'string';
var state_34009__$1 = state_34009;
if(cljs.core.truth_(inst_33733)){
var statearr_34061_34248 = state_34009__$1;
(statearr_34061_34248[(1)] = (33));

} else {
var statearr_34062_34249 = state_34009__$1;
(statearr_34062_34249[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (113))){
var inst_33912 = (state_34009[(22)]);
var state_34009__$1 = state_34009;
var statearr_34063_34250 = state_34009__$1;
(statearr_34063_34250[(2)] = inst_33912);

(statearr_34063_34250[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (32))){
var inst_33749 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34064_34251 = state_34009__$1;
(statearr_34064_34251[(2)] = inst_33749);

(statearr_34064_34251[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (40))){
var inst_33782 = typeof from === 'string';
var inst_33783 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_33784 = clojure.string.includes_QMARK_.call(null,inst_33783,"/");
var inst_33785 = ((inst_33782) && (inst_33784));
var state_34009__$1 = state_34009;
if(cljs.core.truth_(inst_33785)){
var statearr_34065_34252 = state_34009__$1;
(statearr_34065_34252[(1)] = (53));

} else {
var statearr_34066_34253 = state_34009__$1;
(statearr_34066_34253[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (129))){
var inst_33991 = (state_34009[(24)]);
var state_34009__$1 = state_34009;
var statearr_34067_34254 = state_34009__$1;
(statearr_34067_34254[(2)] = inst_33991);

(statearr_34067_34254[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (91))){
var inst_33874 = (state_34009[(25)]);
var inst_33878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33879 = [inst_33874];
var inst_33880 = (new cljs.core.PersistentVector(null,1,(5),inst_33878,inst_33879,null));
var state_34009__$1 = state_34009;
var statearr_34068_34255 = state_34009__$1;
(statearr_34068_34255[(2)] = inst_33880);

(statearr_34068_34255[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (117))){
var inst_33711 = (state_34009[(11)]);
var state_34009__$1 = state_34009;
var statearr_34069_34256 = state_34009__$1;
(statearr_34069_34256[(2)] = inst_33711);

(statearr_34069_34256[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (108))){
var inst_33927 = cljs.core._deref.call(null,fuel);
var inst_33928 = (inst_33927 + (1));
var inst_33929 = cljs.core._vreset_BANG_.call(null,fuel,inst_33928);
var state_34009__$1 = state_34009;
var statearr_34070_34257 = state_34009__$1;
(statearr_34070_34257[(2)] = inst_33929);

(statearr_34070_34257[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (56))){
var inst_33788 = (state_34009[(26)]);
var inst_33790 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_33791 = cljs.core.comp.call(null,inst_33788,inst_33790);
var state_34009__$1 = state_34009;
var statearr_34071_34258 = state_34009__$1;
(statearr_34071_34258[(2)] = inst_33791);

(statearr_34071_34258[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (33))){
var inst_33710 = (state_34009[(13)]);
var inst_33735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33736 = [inst_33710,"ASC"];
var inst_33737 = (new cljs.core.PersistentVector(null,2,(5),inst_33735,inst_33736,null));
var state_34009__$1 = state_34009;
var statearr_34072_34259 = state_34009__$1;
(statearr_34072_34259[(2)] = inst_33737);

(statearr_34072_34259[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (13))){
var inst_33677 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_33678 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_33679 = cljs.core.PersistentHashMap.fromArrays(inst_33677,inst_33678);
var inst_33680 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_33679);
var inst_33681 = (function(){throw inst_33680})();
var state_34009__$1 = state_34009;
var statearr_34073_34260 = state_34009__$1;
(statearr_34073_34260[(2)] = inst_33681);

(statearr_34073_34260[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (22))){
var inst_33688 = (state_34009[(23)]);
var state_34009__$1 = state_34009;
var statearr_34074_34261 = state_34009__$1;
(statearr_34074_34261[(2)] = inst_33688);

(statearr_34074_34261[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (90))){
var state_34009__$1 = state_34009;
var statearr_34075_34262 = state_34009__$1;
(statearr_34075_34262[(2)] = null);

(statearr_34075_34262[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (109))){
var state_34009__$1 = state_34009;
var statearr_34076_34263 = state_34009__$1;
(statearr_34076_34263[(2)] = null);

(statearr_34076_34263[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (36))){
var inst_33740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33741 = [null,null];
var inst_33742 = (new cljs.core.PersistentVector(null,2,(5),inst_33740,inst_33741,null));
var state_34009__$1 = state_34009;
var statearr_34077_34264 = state_34009__$1;
(statearr_34077_34264[(2)] = inst_33742);

(statearr_34077_34264[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (41))){
var inst_33756 = (state_34009[(27)]);
var inst_33985 = (state_34009[(2)]);
var state_34009__$1 = (function (){var statearr_34078 = state_34009;
(statearr_34078[(28)] = inst_33985);

return statearr_34078;
})();
if(cljs.core.truth_(inst_33756)){
var statearr_34079_34265 = state_34009__$1;
(statearr_34079_34265[(1)] = (125));

} else {
var statearr_34080_34266 = state_34009__$1;
(statearr_34080_34266[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (118))){
var inst_33710 = (state_34009[(13)]);
var inst_33954 = (state_34009[(2)]);
var state_34009__$1 = (function (){var statearr_34081 = state_34009;
(statearr_34081[(10)] = inst_33954);

return statearr_34081;
})();
if(cljs.core.truth_(inst_33710)){
var statearr_34082_34267 = state_34009__$1;
(statearr_34082_34267[(1)] = (119));

} else {
var statearr_34083_34268 = state_34009__$1;
(statearr_34083_34268[(1)] = (120));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (89))){
var inst_33874 = (state_34009[(25)]);
var inst_33873 = (state_34009[(2)]);
var inst_33874__$1 = fluree.db.util.async.throw_err.call(null,inst_33873);
var inst_33875 = (inst_33874__$1 == null);
var state_34009__$1 = (function (){var statearr_34084 = state_34009;
(statearr_34084[(25)] = inst_33874__$1);

return statearr_34084;
})();
if(cljs.core.truth_(inst_33875)){
var statearr_34085_34269 = state_34009__$1;
(statearr_34085_34269[(1)] = (90));

} else {
var statearr_34086_34270 = state_34009__$1;
(statearr_34086_34270[(1)] = (91));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (100))){
var inst_33918 = (state_34009[(15)]);
var inst_33911 = (state_34009[(29)]);
var inst_33917 = cljs.core.seq.call(null,inst_33911);
var inst_33918__$1 = cljs.core.first.call(null,inst_33917);
var inst_33919 = cljs.core.next.call(null,inst_33917);
var inst_33920 = cljs.core.not.call(null,inst_33918__$1);
var state_34009__$1 = (function (){var statearr_34087 = state_34009;
(statearr_34087[(15)] = inst_33918__$1);

(statearr_34087[(30)] = inst_33919);

return statearr_34087;
})();
if(inst_33920){
var statearr_34088_34271 = state_34009__$1;
(statearr_34088_34271[(1)] = (102));

} else {
var statearr_34089_34272 = state_34009__$1;
(statearr_34089_34272[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (131))){
var inst_33990 = (state_34009[(17)]);
var inst_34001 = cljs.core.first.call(null,inst_33990);
var state_34009__$1 = state_34009;
var statearr_34090_34273 = state_34009__$1;
(statearr_34090_34273[(2)] = inst_34001);

(statearr_34090_34273[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (122))){
var inst_33965 = cljs.core.pr_str.call(null,query_map);
var inst_33966 = ["Invalid 'from' in query:",inst_33965].join('');
var inst_33967 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_33968 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_33969 = cljs.core.PersistentHashMap.fromArrays(inst_33967,inst_33968);
var inst_33970 = cljs.core.ex_info.call(null,inst_33966,inst_33969);
var state_34009__$1 = state_34009;
var statearr_34091_34274 = state_34009__$1;
(statearr_34091_34274[(2)] = inst_33970);

(statearr_34091_34274[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (43))){
var state_34009__$1 = state_34009;
var statearr_34092_34275 = state_34009__$1;
(statearr_34092_34275[(2)] = null);

(statearr_34092_34275[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (61))){
var inst_33710 = (state_34009[(13)]);
var inst_33800 = (state_34009[(2)]);
var state_34009__$1 = (function (){var statearr_34093 = state_34009;
(statearr_34093[(12)] = inst_33800);

return statearr_34093;
})();
if(cljs.core.truth_(inst_33710)){
var statearr_34094_34276 = state_34009__$1;
(statearr_34094_34276[(1)] = (62));

} else {
var statearr_34095_34277 = state_34009__$1;
(statearr_34095_34277[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (29))){
var inst_33755 = (state_34009[(2)]);
var inst_33756 = cljs.core.nth.call(null,inst_33755,(0),null);
var inst_33757 = cljs.core.nth.call(null,inst_33755,(1),null);
var inst_33758 = typeof where === 'string';
var state_34009__$1 = (function (){var statearr_34096 = state_34009;
(statearr_34096[(27)] = inst_33756);

(statearr_34096[(31)] = inst_33757);

return statearr_34096;
})();
if(cljs.core.truth_(inst_33758)){
var statearr_34097_34278 = state_34009__$1;
(statearr_34097_34278[(1)] = (39));

} else {
var statearr_34098_34279 = state_34009__$1;
(statearr_34098_34279[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (44))){
var inst_33764 = (state_34009[(2)]);
var inst_33765 = fluree.db.query.fql.where_filter.call(null,db,where,inst_33764);
var state_34009__$1 = state_34009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34009__$1,(45),inst_33765);
} else {
if((state_val_34010 === (93))){
var inst_33885 = (state_34009[(2)]);
var inst_33886 = fluree.db.util.async.throw_err.call(null,inst_33885);
var state_34009__$1 = (function (){var statearr_34099 = state_34009;
(statearr_34099[(32)] = inst_33886);

return statearr_34099;
})();
if(cljs.core.truth_(fuel)){
var statearr_34100_34280 = state_34009__$1;
(statearr_34100_34280[(1)] = (94));

} else {
var statearr_34101_34281 = state_34009__$1;
(statearr_34101_34281[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (6))){
var inst_33668 = (state_34009[(33)]);
var state_34009__$1 = state_34009;
var statearr_34102_34282 = state_34009__$1;
(statearr_34102_34282[(2)] = inst_33668);

(statearr_34102_34282[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (111))){
var inst_33935 = (state_34009[(2)]);
var inst_33936 = fluree.db.util.async.throw_err.call(null,inst_33935);
var state_34009__$1 = state_34009;
var statearr_34103_34283 = state_34009__$1;
(statearr_34103_34283[(2)] = inst_33936);

(statearr_34103_34283[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (28))){
var inst_33751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33752 = [null,null];
var inst_33753 = (new cljs.core.PersistentVector(null,2,(5),inst_33751,inst_33752,null));
var state_34009__$1 = state_34009;
var statearr_34104_34284 = state_34009__$1;
(statearr_34104_34284[(2)] = inst_33753);

(statearr_34104_34284[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (64))){
var inst_33808 = (state_34009[(2)]);
var inst_33809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33810 = [from];
var inst_33811 = (new cljs.core.PersistentVector(null,1,(5),inst_33809,inst_33810,null));
var inst_33812 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_33811,inst_33808);
var state_34009__$1 = state_34009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34009__$1,(65),inst_33812);
} else {
if((state_val_34010 === (103))){
var inst_33918 = (state_34009[(15)]);
var inst_33923 = cljs.core.int_QMARK_.call(null,inst_33918);
var state_34009__$1 = state_34009;
if(inst_33923){
var statearr_34105_34285 = state_34009__$1;
(statearr_34105_34285[(1)] = (105));

} else {
var statearr_34106_34286 = state_34009__$1;
(statearr_34106_34286[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (51))){
var inst_33713 = (state_34009[(14)]);
var state_34009__$1 = state_34009;
var statearr_34107_34287 = state_34009__$1;
(statearr_34107_34287[(2)] = inst_33713);

(statearr_34107_34287[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (25))){
var inst_33714 = (state_34009[(20)]);
var state_34009__$1 = state_34009;
var statearr_34108_34288 = state_34009__$1;
(statearr_34108_34288[(2)] = inst_33714);

(statearr_34108_34288[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (34))){
var state_34009__$1 = state_34009;
var statearr_34109_34289 = state_34009__$1;
(statearr_34109_34289[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (125))){
var inst_33985 = (state_34009[(28)]);
var inst_33756 = (state_34009[(27)]);
var inst_33713 = (state_34009[(14)]);
var inst_33757 = (state_34009[(31)]);
var inst_33711 = (state_34009[(11)]);
var inst_33987 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_33756,inst_33757,inst_33713,inst_33711,inst_33985);
var state_34009__$1 = state_34009;
var statearr_34111_34290 = state_34009__$1;
(statearr_34111_34290[(2)] = inst_33987);

(statearr_34111_34290[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (17))){
var inst_33704 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
if(cljs.core.truth_(inst_33704)){
var statearr_34112_34291 = state_34009__$1;
(statearr_34112_34291[(1)] = (21));

} else {
var statearr_34113_34292 = state_34009__$1;
(statearr_34113_34292[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (3))){
var inst_34007 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34009__$1,inst_34007);
} else {
if((state_val_34010 === (12))){
var inst_33674 = (state_34009[(34)]);
var state_34009__$1 = state_34009;
var statearr_34114_34293 = state_34009__$1;
(statearr_34114_34293[(2)] = inst_33674);

(statearr_34114_34293[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (2))){
var inst_33668 = (state_34009[(33)]);
var _ = (function (){var statearr_34115 = state_34009;
(statearr_34115[(4)] = cljs.core.cons.call(null,(5),(state_34009[(4)])));

return statearr_34115;
})();
var inst_33668__$1 = select;
var state_34009__$1 = (function (){var statearr_34116 = state_34009;
(statearr_34116[(33)] = inst_33668__$1);

return statearr_34116;
})();
if(cljs.core.truth_(inst_33668__$1)){
var statearr_34117_34294 = state_34009__$1;
(statearr_34117_34294[(1)] = (6));

} else {
var statearr_34118_34295 = state_34009__$1;
(statearr_34118_34295[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (66))){
var inst_33819 = (state_34009[(2)]);
var inst_33820 = fluree.db.util.async.throw_err.call(null,inst_33819);
var state_34009__$1 = state_34009;
var statearr_34119_34296 = state_34009__$1;
(statearr_34119_34296[(2)] = inst_33820);

(statearr_34119_34296[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (107))){
var inst_33938 = (state_34009[(35)]);
var inst_33938__$1 = (state_34009[(2)]);
var state_34009__$1 = (function (){var statearr_34120 = state_34009;
(statearr_34120[(35)] = inst_33938__$1);

return statearr_34120;
})();
if(cljs.core.truth_(inst_33938__$1)){
var statearr_34121_34297 = state_34009__$1;
(statearr_34121_34297[(1)] = (112));

} else {
var statearr_34122_34298 = state_34009__$1;
(statearr_34122_34298[(1)] = (113));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (23))){
var inst_33687 = (state_34009[(36)]);
var inst_33712 = (state_34009[(21)]);
var inst_33709 = (state_34009[(2)]);
var inst_33710 = cljs.core.get.call(null,inst_33709,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_33711 = cljs.core.get.call(null,inst_33709,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_33712__$1 = cljs.core.get.call(null,inst_33709,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_33713 = cljs.core.get.call(null,inst_33709,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_33714 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_33687,opts_SINGLEQUOTE_);
var inst_33715 = (inst_33712__$1 == null);
var inst_33716 = cljs.core.not.call(null,inst_33715);
var state_34009__$1 = (function (){var statearr_34123 = state_34009;
(statearr_34123[(20)] = inst_33714);

(statearr_34123[(14)] = inst_33713);

(statearr_34123[(13)] = inst_33710);

(statearr_34123[(21)] = inst_33712__$1);

(statearr_34123[(11)] = inst_33711);

return statearr_34123;
})();
if(inst_33716){
var statearr_34124_34299 = state_34009__$1;
(statearr_34124_34299[(1)] = (24));

} else {
var statearr_34125_34300 = state_34009__$1;
(statearr_34125_34300[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (47))){
var state_34009__$1 = state_34009;
var statearr_34126_34301 = state_34009__$1;
(statearr_34126_34301[(2)] = null);

(statearr_34126_34301[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (35))){
var inst_33747 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34127_34302 = state_34009__$1;
(statearr_34127_34302[(2)] = inst_33747);

(statearr_34127_34302[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (127))){
var inst_33991 = (state_34009[(24)]);
var inst_33990 = (state_34009[(2)]);
var inst_33991__$1 = selectOne;
var state_34009__$1 = (function (){var statearr_34128 = state_34009;
(statearr_34128[(17)] = inst_33990);

(statearr_34128[(24)] = inst_33991__$1);

return statearr_34128;
})();
if(cljs.core.truth_(inst_33991__$1)){
var statearr_34129_34303 = state_34009__$1;
(statearr_34129_34303[(1)] = (128));

} else {
var statearr_34130_34304 = state_34009__$1;
(statearr_34130_34304[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (82))){
var inst_33713 = (state_34009[(14)]);
var inst_33711 = (state_34009[(11)]);
var inst_33854 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_33855 = [inst_33711,inst_33713];
var inst_33856 = cljs.core.PersistentHashMap.fromArrays(inst_33854,inst_33855);
var state_34009__$1 = state_34009;
var statearr_34131_34305 = state_34009__$1;
(statearr_34131_34305[(2)] = inst_33856);

(statearr_34131_34305[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (76))){
var inst_33723 = (state_34009[(8)]);
var inst_33721 = (state_34009[(9)]);
var inst_33842 = (state_34009[(2)]);
var inst_33843 = fluree.db.util.async.throw_err.call(null,inst_33842);
var inst_33844 = fluree.db.query.fql.flake_select.call(null,db,inst_33723,fuel,max_fuel,inst_33721,inst_33843);
var state_34009__$1 = state_34009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34009__$1,(77),inst_33844);
} else {
if((state_val_34010 === (97))){
var inst_33906 = from;
var inst_33907 = cljs.core.seq.call(null,inst_33906);
var inst_33908 = cljs.core.first.call(null,inst_33907);
var inst_33909 = cljs.core.next.call(null,inst_33907);
var inst_33910 = cljs.core.PersistentVector.EMPTY;
var inst_33911 = inst_33906;
var inst_33912 = inst_33910;
var state_34009__$1 = (function (){var statearr_34132 = state_34009;
(statearr_34132[(37)] = inst_33909);

(statearr_34132[(38)] = inst_33908);

(statearr_34132[(29)] = inst_33911);

(statearr_34132[(22)] = inst_33912);

return statearr_34132;
})();
var statearr_34133_34306 = state_34009__$1;
(statearr_34133_34306[(2)] = null);

(statearr_34133_34306[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (19))){
var state_34009__$1 = state_34009;
var statearr_34134_34307 = state_34009__$1;
(statearr_34134_34307[(2)] = false);

(statearr_34134_34307[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (57))){
var inst_33788 = (state_34009[(26)]);
var state_34009__$1 = state_34009;
var statearr_34135_34308 = state_34009__$1;
(statearr_34135_34308[(2)] = inst_33788);

(statearr_34135_34308[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (68))){
var state_34009__$1 = state_34009;
var statearr_34136_34309 = state_34009__$1;
(statearr_34136_34309[(2)] = false);

(statearr_34136_34309[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (11))){
var inst_33685 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34137_34310 = state_34009__$1;
(statearr_34137_34310[(2)] = inst_33685);

(statearr_34137_34310[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (115))){
var inst_33961 = (state_34009[(2)]);
var inst_33962 = fluree.db.util.async.throw_err.call(null,inst_33961);
var state_34009__$1 = state_34009;
var statearr_34139_34311 = state_34009__$1;
(statearr_34139_34311[(2)] = inst_33962);

(statearr_34139_34311[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (9))){
var inst_33671 = (state_34009[(18)]);
var state_34009__$1 = state_34009;
var statearr_34140_34312 = state_34009__$1;
(statearr_34140_34312[(2)] = inst_33671);

(statearr_34140_34312[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (5))){
var _ = (function (){var statearr_34141 = state_34009;
(statearr_34141[(4)] = cljs.core.rest.call(null,(state_34009[(4)])));

return statearr_34141;
})();
var state_34009__$1 = state_34009;
var ex34138 = (state_34009__$1[(2)]);
var statearr_34142_34313 = state_34009__$1;
(statearr_34142_34313[(5)] = ex34138);


if((ex34138 instanceof Error)){
var statearr_34143_34314 = state_34009__$1;
(statearr_34143_34314[(1)] = (4));

(statearr_34143_34314[(5)] = null);

} else {
throw ex34138;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (112))){
var inst_33938 = (state_34009[(35)]);
var inst_33912 = (state_34009[(22)]);
var inst_33940 = cljs.core.conj.call(null,inst_33912,inst_33938);
var state_34009__$1 = state_34009;
var statearr_34144_34315 = state_34009__$1;
(statearr_34144_34315[(2)] = inst_33940);

(statearr_34144_34315[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (83))){
var inst_33858 = (state_34009[(2)]);
var inst_33859 = fluree.db.query.range.collection.call(null,db,from,inst_33858);
var state_34009__$1 = state_34009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34009__$1,(84),inst_33859);
} else {
if((state_val_34010 === (14))){
var inst_33683 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34145_34316 = state_34009__$1;
(statearr_34145_34316[(2)] = inst_33683);

(statearr_34145_34316[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (45))){
var inst_33710 = (state_34009[(13)]);
var inst_33767 = (state_34009[(2)]);
var inst_33768 = fluree.db.util.async.throw_err.call(null,inst_33767);
var state_34009__$1 = (function (){var statearr_34146 = state_34009;
(statearr_34146[(39)] = inst_33768);

return statearr_34146;
})();
if(cljs.core.truth_(inst_33710)){
var statearr_34147_34317 = state_34009__$1;
(statearr_34147_34317[(1)] = (47));

} else {
var statearr_34148_34318 = state_34009__$1;
(statearr_34148_34318[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (53))){
var inst_33788 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_34009__$1 = (function (){var statearr_34149 = state_34009;
(statearr_34149[(26)] = inst_33788);

return statearr_34149;
})();
if(cljs.core.truth_(fuel)){
var statearr_34150_34319 = state_34009__$1;
(statearr_34150_34319[(1)] = (56));

} else {
var statearr_34151_34320 = state_34009__$1;
(statearr_34151_34320[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (78))){
var inst_33710 = (state_34009[(13)]);
var state_34009__$1 = state_34009;
if(cljs.core.truth_(inst_33710)){
var statearr_34152_34321 = state_34009__$1;
(statearr_34152_34321[(1)] = (81));

} else {
var statearr_34153_34322 = state_34009__$1;
(statearr_34153_34322[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (132))){
var inst_33990 = (state_34009[(17)]);
var state_34009__$1 = state_34009;
var statearr_34154_34323 = state_34009__$1;
(statearr_34154_34323[(2)] = inst_33990);

(statearr_34154_34323[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (26))){
var inst_33710 = (state_34009[(13)]);
var inst_33721 = (state_34009[(2)]);
var inst_33722 = cljs.core.PersistentHashMap.EMPTY;
var inst_33723 = cljs.core.volatile_BANG_.call(null,inst_33722);
var state_34009__$1 = (function (){var statearr_34155 = state_34009;
(statearr_34155[(8)] = inst_33723);

(statearr_34155[(9)] = inst_33721);

return statearr_34155;
})();
if(cljs.core.truth_(inst_33710)){
var statearr_34156_34324 = state_34009__$1;
(statearr_34156_34324[(1)] = (27));

} else {
var statearr_34157_34325 = state_34009__$1;
(statearr_34157_34325[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (123))){
var state_34009__$1 = state_34009;
var statearr_34158_34326 = state_34009__$1;
(statearr_34158_34326[(2)] = null);

(statearr_34158_34326[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (16))){
var state_34009__$1 = state_34009;
var statearr_34159_34327 = state_34009__$1;
(statearr_34159_34327[(2)] = false);

(statearr_34159_34327[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (133))){
var inst_34004 = (state_34009[(2)]);
var _ = (function (){var statearr_34160 = state_34009;
(statearr_34160[(4)] = cljs.core.rest.call(null,(state_34009[(4)])));

return statearr_34160;
})();
var state_34009__$1 = state_34009;
var statearr_34161_34328 = state_34009__$1;
(statearr_34161_34328[(2)] = inst_34004);

(statearr_34161_34328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (81))){
var inst_33852 = cljs.core.PersistentHashMap.EMPTY;
var state_34009__$1 = state_34009;
var statearr_34162_34329 = state_34009__$1;
(statearr_34162_34329[(2)] = inst_33852);

(statearr_34162_34329[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (120))){
var inst_33713 = (state_34009[(14)]);
var state_34009__$1 = state_34009;
var statearr_34163_34330 = state_34009__$1;
(statearr_34163_34330[(2)] = inst_33713);

(statearr_34163_34330[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (79))){
var inst_33868 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_34009__$1 = state_34009;
if(inst_33868){
var statearr_34164_34331 = state_34009__$1;
(statearr_34164_34331[(1)] = (86));

} else {
var statearr_34165_34332 = state_34009__$1;
(statearr_34165_34332[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (38))){
var inst_33745 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34166_34333 = state_34009__$1;
(statearr_34166_34333[(2)] = inst_33745);

(statearr_34166_34333[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (126))){
var inst_33985 = (state_34009[(28)]);
var state_34009__$1 = state_34009;
var statearr_34167_34334 = state_34009__$1;
(statearr_34167_34334[(2)] = inst_33985);

(statearr_34167_34334[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (98))){
var state_34009__$1 = state_34009;
var statearr_34168_34335 = state_34009__$1;
(statearr_34168_34335[(1)] = (122));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (124))){
var inst_33973 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34170_34336 = state_34009__$1;
(statearr_34170_34336[(2)] = inst_33973);

(statearr_34170_34336[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (87))){
var inst_33895 = cljs.core.sequential_QMARK_.call(null,from);
var inst_33896 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var inst_33897 = ((inst_33895) && (inst_33896));
var state_34009__$1 = state_34009;
if(cljs.core.truth_(inst_33897)){
var statearr_34171_34337 = state_34009__$1;
(statearr_34171_34337[(1)] = (97));

} else {
var statearr_34172_34338 = state_34009__$1;
(statearr_34172_34338[(1)] = (98));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (30))){
var inst_33710 = (state_34009[(13)]);
var inst_33727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33728 = cljs.core.second.call(null,inst_33710);
var inst_33729 = cljs.core.first.call(null,inst_33710);
var inst_33730 = [inst_33728,inst_33729];
var inst_33731 = (new cljs.core.PersistentVector(null,2,(5),inst_33727,inst_33730,null));
var state_34009__$1 = state_34009;
var statearr_34173_34339 = state_34009__$1;
(statearr_34173_34339[(2)] = inst_33731);

(statearr_34173_34339[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (73))){
var inst_33833 = cljs.core.PersistentHashMap.EMPTY;
var state_34009__$1 = state_34009;
var statearr_34174_34340 = state_34009__$1;
(statearr_34174_34340[(2)] = inst_33833);

(statearr_34174_34340[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (96))){
var inst_33886 = (state_34009[(32)]);
var inst_33893 = (state_34009[(2)]);
var state_34009__$1 = (function (){var statearr_34175 = state_34009;
(statearr_34175[(40)] = inst_33893);

return statearr_34175;
})();
var statearr_34176_34341 = state_34009__$1;
(statearr_34176_34341[(2)] = inst_33886);

(statearr_34176_34341[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (10))){
var inst_33674 = (state_34009[(34)]);
var inst_33674__$1 = selectDistinct;
var state_34009__$1 = (function (){var statearr_34177 = state_34009;
(statearr_34177[(34)] = inst_33674__$1);

return statearr_34177;
})();
if(cljs.core.truth_(inst_33674__$1)){
var statearr_34178_34342 = state_34009__$1;
(statearr_34178_34342[(1)] = (12));

} else {
var statearr_34179_34343 = state_34009__$1;
(statearr_34179_34343[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (18))){
var state_34009__$1 = state_34009;
var statearr_34180_34344 = state_34009__$1;
(statearr_34180_34344[(2)] = true);

(statearr_34180_34344[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (105))){
var inst_33918 = (state_34009[(15)]);
var state_34009__$1 = state_34009;
var statearr_34181_34345 = state_34009__$1;
(statearr_34181_34345[(2)] = inst_33918);

(statearr_34181_34345[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (52))){
var inst_33723 = (state_34009[(8)]);
var inst_33721 = (state_34009[(9)]);
var inst_33772 = (state_34009[(41)]);
var inst_33768 = (state_34009[(39)]);
var inst_33776 = (state_34009[(2)]);
var inst_33777 = fluree.db.query.fql.subject_select.call(null,db,inst_33723,fuel,max_fuel,inst_33721,inst_33768,inst_33772,inst_33776);
var state_34009__$1 = state_34009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34009__$1,(46),inst_33777);
} else {
if((state_val_34010 === (114))){
var inst_33919 = (state_34009[(30)]);
var inst_33943 = (state_34009[(2)]);
var inst_33911 = inst_33919;
var inst_33912 = inst_33943;
var state_34009__$1 = (function (){var statearr_34182 = state_34009;
(statearr_34182[(29)] = inst_33911);

(statearr_34182[(22)] = inst_33912);

return statearr_34182;
})();
var statearr_34183_34346 = state_34009__$1;
(statearr_34183_34346[(2)] = null);

(statearr_34183_34346[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (67))){
var inst_33824 = ["_tx",null,"_block",null];
var inst_33825 = (new cljs.core.PersistentArrayMap(null,2,inst_33824,null));
var inst_33826 = (new cljs.core.PersistentHashSet(null,inst_33825,null));
var inst_33827 = inst_33826.call(null,from);
var state_34009__$1 = state_34009;
var statearr_34184_34347 = state_34009__$1;
(statearr_34184_34347[(2)] = inst_33827);

(statearr_34184_34347[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (71))){
var inst_33849 = typeof from === 'string';
var state_34009__$1 = state_34009;
if(cljs.core.truth_(inst_33849)){
var statearr_34185_34348 = state_34009__$1;
(statearr_34185_34348[(1)] = (78));

} else {
var statearr_34186_34349 = state_34009__$1;
(statearr_34186_34349[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (42))){
var state_34009__$1 = state_34009;
var statearr_34187_34350 = state_34009__$1;
(statearr_34187_34350[(2)] = from);

(statearr_34187_34350[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (80))){
var inst_33979 = (state_34009[(2)]);
var state_34009__$1 = state_34009;
var statearr_34188_34351 = state_34009__$1;
(statearr_34188_34351[(2)] = inst_33979);

(statearr_34188_34351[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (37))){
var state_34009__$1 = state_34009;
var statearr_34189_34352 = state_34009__$1;
(statearr_34189_34352[(2)] = null);

(statearr_34189_34352[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (63))){
var inst_33713 = (state_34009[(14)]);
var inst_33711 = (state_34009[(11)]);
var inst_33804 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_33805 = [inst_33711,inst_33713];
var inst_33806 = cljs.core.PersistentHashMap.fromArrays(inst_33804,inst_33805);
var state_34009__$1 = state_34009;
var statearr_34190_34353 = state_34009__$1;
(statearr_34190_34353[(2)] = inst_33806);

(statearr_34190_34353[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (94))){
var inst_33888 = cljs.core._deref.call(null,fuel);
var inst_33889 = (inst_33888 + (1));
var inst_33890 = cljs.core._vreset_BANG_.call(null,fuel,inst_33889);
var state_34009__$1 = state_34009;
var statearr_34191_34354 = state_34009__$1;
(statearr_34191_34354[(2)] = inst_33890);

(statearr_34191_34354[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (8))){
var inst_33688 = (state_34009[(23)]);
var inst_33687 = (state_34009[(2)]);
var inst_33688__$1 = opts_SINGLEQUOTE_;
var inst_33690 = (inst_33688__$1 == null);
var inst_33691 = cljs.core.not.call(null,inst_33690);
var state_34009__$1 = (function (){var statearr_34192 = state_34009;
(statearr_34192[(36)] = inst_33687);

(statearr_34192[(23)] = inst_33688__$1);

return statearr_34192;
})();
if(inst_33691){
var statearr_34193_34355 = state_34009__$1;
(statearr_34193_34355[(1)] = (15));

} else {
var statearr_34194_34356 = state_34009__$1;
(statearr_34194_34356[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (49))){
var inst_33710 = (state_34009[(13)]);
var inst_33772 = (state_34009[(2)]);
var state_34009__$1 = (function (){var statearr_34195 = state_34009;
(statearr_34195[(41)] = inst_33772);

return statearr_34195;
})();
if(cljs.core.truth_(inst_33710)){
var statearr_34196_34357 = state_34009__$1;
(statearr_34196_34357[(1)] = (50));

} else {
var statearr_34197_34358 = state_34009__$1;
(statearr_34197_34358[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34010 === (84))){
var inst_33723 = (state_34009[(8)]);
var inst_33721 = (state_34009[(9)]);
var inst_33861 = (state_34009[(2)]);
var inst_33862 = fluree.db.util.async.throw_err.call(null,inst_33861);
var inst_33863 = fluree.db.query.fql.flake_select.call(null,db,inst_33723,fuel,max_fuel,inst_33721,inst_33862);
var state_34009__$1 = state_34009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34009__$1,(85),inst_33863);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__11469__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__11469__auto____0 = (function (){
var statearr_34198 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34198[(0)] = fluree$db$query$fql$query_$_state_machine__11469__auto__);

(statearr_34198[(1)] = (1));

return statearr_34198;
});
var fluree$db$query$fql$query_$_state_machine__11469__auto____1 = (function (state_34009){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_34009);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e34199){var ex__11472__auto__ = e34199;
var statearr_34200_34359 = state_34009;
(statearr_34200_34359[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_34009[(4)]))){
var statearr_34201_34360 = state_34009;
(statearr_34201_34360[(1)] = cljs.core.first.call(null,(state_34009[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34361 = state_34009;
state_34009 = G__34361;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__11469__auto__ = function(state_34009){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__11469__auto____1.call(this,state_34009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__11469__auto____0;
fluree$db$query$fql$query_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__11469__auto____1;
return fluree$db$query$fql$query_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_34202 = f__11543__auto__.call(null);
(statearr_34202[(6)] = c__11542__auto__);

return statearr_34202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}

});
