// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_29146){
var state_val_29147 = (state_29146[(1)]);
if((state_val_29147 === (1))){
var state_29146__$1 = state_29146;
var statearr_29148_29162 = state_29146__$1;
(statearr_29148_29162[(2)] = null);

(statearr_29148_29162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29147 === (2))){
var _ = (function (){var statearr_29149 = state_29146;
(statearr_29149[(4)] = cljs.core.cons.call(null,(5),(state_29146[(4)])));

return statearr_29149;
})();
var inst_29137 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_29146__$1 = state_29146;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29146__$1,(6),inst_29137);
} else {
if((state_val_29147 === (3))){
var inst_29144 = (state_29146[(2)]);
var state_29146__$1 = state_29146;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29146__$1,inst_29144);
} else {
if((state_val_29147 === (4))){
var inst_29131 = (state_29146[(2)]);
var state_29146__$1 = state_29146;
var statearr_29151_29163 = state_29146__$1;
(statearr_29151_29163[(2)] = inst_29131);

(statearr_29151_29163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29147 === (5))){
var _ = (function (){var statearr_29152 = state_29146;
(statearr_29152[(4)] = cljs.core.rest.call(null,(state_29146[(4)])));

return statearr_29152;
})();
var state_29146__$1 = state_29146;
var ex29150 = (state_29146__$1[(2)]);
var statearr_29153_29164 = state_29146__$1;
(statearr_29153_29164[(5)] = ex29150);


if((ex29150 instanceof Error)){
var statearr_29154_29165 = state_29146__$1;
(statearr_29154_29165[(1)] = (4));

(statearr_29154_29165[(5)] = null);

} else {
throw ex29150;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29147 === (6))){
var inst_29139 = (state_29146[(2)]);
var inst_29140 = fluree.db.util.async.throw_err.call(null,inst_29139);
var inst_29141 = cljs.core.keyword.call(null,inst_29140);
var _ = (function (){var statearr_29155 = state_29146;
(statearr_29155[(4)] = cljs.core.rest.call(null,(state_29146[(4)])));

return statearr_29155;
})();
var state_29146__$1 = state_29146;
var statearr_29156_29166 = state_29146__$1;
(statearr_29156_29166[(2)] = inst_29141);

(statearr_29156_29166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__11469__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__11469__auto____0 = (function (){
var statearr_29157 = [null,null,null,null,null,null,null];
(statearr_29157[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__11469__auto__);

(statearr_29157[(1)] = (1));

return statearr_29157;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__11469__auto____1 = (function (state_29146){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_29146);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e29158){var ex__11472__auto__ = e29158;
var statearr_29159_29167 = state_29146;
(statearr_29159_29167[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_29146[(4)]))){
var statearr_29160_29168 = state_29146;
(statearr_29160_29168[(1)] = cljs.core.first.call(null,(state_29146[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29169 = state_29146;
state_29146 = G__29169;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__11469__auto__ = function(state_29146){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__11469__auto____1.call(this,state_29146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__11469__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__11469__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_29161 = f__11543__auto__.call(null);
(statearr_29161[(6)] = c__11542__auto__);

return statearr_29161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_29201){
var state_val_29202 = (state_29201[(1)]);
if((state_val_29202 === (7))){
var inst_29185 = (state_29201[(7)]);
var inst_29187 = cljs.core.empty_QMARK_.call(null,inst_29185);
var inst_29188 = (!(inst_29187));
var state_29201__$1 = state_29201;
var statearr_29203_29227 = state_29201__$1;
(statearr_29203_29227[(2)] = inst_29188);

(statearr_29203_29227[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29202 === (1))){
var state_29201__$1 = state_29201;
var statearr_29204_29228 = state_29201__$1;
(statearr_29204_29228[(2)] = null);

(statearr_29204_29228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29202 === (4))){
var inst_29171 = (state_29201[(2)]);
var state_29201__$1 = state_29201;
var statearr_29205_29229 = state_29201__$1;
(statearr_29205_29229[(2)] = inst_29171);

(statearr_29205_29229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29202 === (6))){
var inst_29177 = (state_29201[(8)]);
var inst_29185 = (state_29201[(7)]);
var inst_29183 = (state_29201[(2)]);
var inst_29184 = fluree.db.util.async.throw_err.call(null,inst_29183);
var inst_29185__$1 = cljs.core.map.call(null,inst_29177,inst_29184);
var state_29201__$1 = (function (){var statearr_29206 = state_29201;
(statearr_29206[(7)] = inst_29185__$1);

return statearr_29206;
})();
if(cljs.core.truth_(inst_29185__$1)){
var statearr_29207_29230 = state_29201__$1;
(statearr_29207_29230[(1)] = (7));

} else {
var statearr_29208_29231 = state_29201__$1;
(statearr_29208_29231[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29202 === (3))){
var inst_29199 = (state_29201[(2)]);
var state_29201__$1 = state_29201;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29201__$1,inst_29199);
} else {
if((state_val_29202 === (12))){
var inst_29196 = (state_29201[(2)]);
var _ = (function (){var statearr_29209 = state_29201;
(statearr_29209[(4)] = cljs.core.rest.call(null,(state_29201[(4)])));

return statearr_29209;
})();
var state_29201__$1 = state_29201;
var statearr_29210_29232 = state_29201__$1;
(statearr_29210_29232[(2)] = inst_29196);

(statearr_29210_29232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29202 === (2))){
var _ = (function (){var statearr_29211 = state_29201;
(statearr_29211[(4)] = cljs.core.cons.call(null,(5),(state_29201[(4)])));

return statearr_29211;
})();
var inst_29177 = (function (){return (function (p1__29170_SHARP_){
return p1__29170_SHARP_.o;
});
})();
var inst_29178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29179 = [pred_id];
var inst_29180 = (new cljs.core.PersistentVector(null,1,(5),inst_29178,inst_29179,null));
var inst_29181 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_29180);
var state_29201__$1 = (function (){var statearr_29212 = state_29201;
(statearr_29212[(8)] = inst_29177);

return statearr_29212;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29201__$1,(6),inst_29181);
} else {
if((state_val_29202 === (11))){
var state_29201__$1 = state_29201;
var statearr_29214_29233 = state_29201__$1;
(statearr_29214_29233[(2)] = true);

(statearr_29214_29233[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29202 === (9))){
var inst_29191 = (state_29201[(2)]);
var state_29201__$1 = state_29201;
if(cljs.core.truth_(inst_29191)){
var statearr_29215_29234 = state_29201__$1;
(statearr_29215_29234[(1)] = (10));

} else {
var statearr_29216_29235 = state_29201__$1;
(statearr_29216_29235[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29202 === (5))){
var _ = (function (){var statearr_29217 = state_29201;
(statearr_29217[(4)] = cljs.core.rest.call(null,(state_29201[(4)])));

return statearr_29217;
})();
var state_29201__$1 = state_29201;
var ex29213 = (state_29201__$1[(2)]);
var statearr_29218_29236 = state_29201__$1;
(statearr_29218_29236[(5)] = ex29213);


if((ex29213 instanceof Error)){
var statearr_29219_29237 = state_29201__$1;
(statearr_29219_29237[(1)] = (4));

(statearr_29219_29237[(5)] = null);

} else {
throw ex29213;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29202 === (10))){
var inst_29185 = (state_29201[(7)]);
var inst_29193 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_29185);
var state_29201__$1 = state_29201;
var statearr_29220_29238 = state_29201__$1;
(statearr_29220_29238[(2)] = inst_29193);

(statearr_29220_29238[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29202 === (8))){
var inst_29185 = (state_29201[(7)]);
var state_29201__$1 = state_29201;
var statearr_29221_29239 = state_29201__$1;
(statearr_29221_29239[(2)] = inst_29185);

(statearr_29221_29239[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11469__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11469__auto____0 = (function (){
var statearr_29222 = [null,null,null,null,null,null,null,null,null];
(statearr_29222[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11469__auto__);

(statearr_29222[(1)] = (1));

return statearr_29222;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11469__auto____1 = (function (state_29201){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_29201);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e29223){var ex__11472__auto__ = e29223;
var statearr_29224_29240 = state_29201;
(statearr_29224_29240[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_29201[(4)]))){
var statearr_29225_29241 = state_29201;
(statearr_29225_29241[(1)] = cljs.core.first.call(null,(state_29201[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29242 = state_29201;
state_29201 = G__29242;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11469__auto__ = function(state_29201){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11469__auto____1.call(this,state_29201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11469__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11469__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_29226 = f__11543__auto__.call(null);
(statearr_29226[(6)] = c__11542__auto__);

return statearr_29226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_29319){
var state_val_29320 = (state_29319[(1)]);
if((state_val_29320 === (7))){
var inst_29314 = (state_29319[(2)]);
var _ = (function (){var statearr_29321 = state_29319;
(statearr_29321[(4)] = cljs.core.rest.call(null,(state_29319[(4)])));

return statearr_29321;
})();
var state_29319__$1 = state_29319;
var statearr_29322_29354 = state_29319__$1;
(statearr_29322_29354[(2)] = inst_29314);

(statearr_29322_29354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (1))){
var state_29319__$1 = state_29319;
var statearr_29323_29355 = state_29319__$1;
(statearr_29323_29355[(2)] = null);

(statearr_29323_29355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (4))){
var inst_29245 = (state_29319[(2)]);
var state_29319__$1 = state_29319;
var statearr_29324_29356 = state_29319__$1;
(statearr_29324_29356[(2)] = inst_29245);

(statearr_29324_29356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (15))){
var inst_29282 = (state_29319[(7)]);
var inst_29295 = (state_29319[(8)]);
var inst_29275 = (state_29319[(9)]);
var inst_29269 = (state_29319[(10)]);
var inst_29297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29298 = inst_29275.s;
var inst_29299 = [inst_29298,inst_29282,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_29300 = (new cljs.core.PersistentVector(null,3,(5),inst_29297,inst_29299,null));
var inst_29301 = cljs.core.assoc_in.call(null,inst_29269,inst_29300,inst_29295);
var state_29319__$1 = state_29319;
var statearr_29325_29357 = state_29319__$1;
(statearr_29325_29357[(2)] = inst_29301);

(statearr_29325_29357[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (13))){
var inst_29284 = (state_29319[(11)]);
var inst_29295 = (state_29319[(2)]);
var state_29319__$1 = (function (){var statearr_29326 = state_29319;
(statearr_29326[(8)] = inst_29295);

return statearr_29326;
})();
if(cljs.core.truth_(inst_29284)){
var statearr_29327_29358 = state_29319__$1;
(statearr_29327_29358[(1)] = (15));

} else {
var statearr_29328_29359 = state_29319__$1;
(statearr_29328_29359[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (6))){
var inst_29275 = (state_29319[(9)]);
var inst_29268 = (state_29319[(12)]);
var inst_29274 = cljs.core.seq.call(null,inst_29268);
var inst_29275__$1 = cljs.core.first.call(null,inst_29274);
var inst_29276 = cljs.core.next.call(null,inst_29274);
var inst_29277 = cljs.core.not.call(null,inst_29275__$1);
var state_29319__$1 = (function (){var statearr_29329 = state_29319;
(statearr_29329[(9)] = inst_29275__$1);

(statearr_29329[(13)] = inst_29276);

return statearr_29329;
})();
if(inst_29277){
var statearr_29330_29360 = state_29319__$1;
(statearr_29330_29360[(1)] = (8));

} else {
var statearr_29331_29361 = state_29319__$1;
(statearr_29331_29361[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (17))){
var inst_29276 = (state_29319[(13)]);
var inst_29309 = (state_29319[(2)]);
var inst_29268 = inst_29276;
var inst_29269 = inst_29309;
var state_29319__$1 = (function (){var statearr_29332 = state_29319;
(statearr_29332[(10)] = inst_29269);

(statearr_29332[(12)] = inst_29268);

return statearr_29332;
})();
var statearr_29333_29362 = state_29319__$1;
(statearr_29333_29362[(2)] = null);

(statearr_29333_29362[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (3))){
var inst_29317 = (state_29319[(2)]);
var state_29319__$1 = state_29319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29319__$1,inst_29317);
} else {
if((state_val_29320 === (12))){
var inst_29275 = (state_29319[(9)]);
var inst_29293 = inst_29275.o;
var state_29319__$1 = state_29319;
var statearr_29334_29363 = state_29319__$1;
(statearr_29334_29363[(2)] = inst_29293);

(statearr_29334_29363[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (2))){
var _ = (function (){var statearr_29335 = state_29319;
(statearr_29335[(4)] = cljs.core.cons.call(null,(5),(state_29319[(4)])));

return statearr_29335;
})();
var inst_29251 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_29252 = cljs.core.PersistentHashSet.EMPTY;
var inst_29253 = cljs.core.vals.call(null,tempids);
var inst_29254 = cljs.core.into.call(null,inst_29252,inst_29253);
var inst_29255 = (function (){var pred_flakes = inst_29251;
var is_new_QMARK_ = inst_29254;
return (function (p1__29243_SHARP_,p2__29244_SHARP_){
return cljs.core.assoc_in.call(null,p1__29243_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__29244_SHARP_.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,p2__29244_SHARP_.s)));
});
})();
var inst_29256 = cljs.core.PersistentHashMap.EMPTY;
var inst_29257 = cljs.core.reduce.call(null,inst_29255,inst_29256,inst_29251);
var inst_29265 = cljs.core.seq.call(null,inst_29251);
var inst_29266 = cljs.core.first.call(null,inst_29265);
var inst_29267 = cljs.core.next.call(null,inst_29265);
var inst_29268 = inst_29251;
var inst_29269 = inst_29257;
var state_29319__$1 = (function (){var statearr_29336 = state_29319;
(statearr_29336[(14)] = inst_29267);

(statearr_29336[(15)] = inst_29266);

(statearr_29336[(10)] = inst_29269);

(statearr_29336[(12)] = inst_29268);

return statearr_29336;
})();
var statearr_29337_29364 = state_29319__$1;
(statearr_29337_29364[(2)] = null);

(statearr_29337_29364[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (11))){
var inst_29275 = (state_29319[(9)]);
var inst_29287 = inst_29275.o;
var inst_29288 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_29287,db);
var state_29319__$1 = state_29319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29319__$1,(14),inst_29288);
} else {
if((state_val_29320 === (9))){
var inst_29282 = (state_29319[(7)]);
var inst_29275 = (state_29319[(9)]);
var inst_29280 = inst_29275.p;
var inst_29281 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_29280);
var inst_29282__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_29281);
var inst_29283 = inst_29275.op;
var inst_29284 = inst_29283 === false;
var inst_29285 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_29282__$1);
var state_29319__$1 = (function (){var statearr_29339 = state_29319;
(statearr_29339[(7)] = inst_29282__$1);

(statearr_29339[(11)] = inst_29284);

return statearr_29339;
})();
if(inst_29285){
var statearr_29340_29365 = state_29319__$1;
(statearr_29340_29365[(1)] = (11));

} else {
var statearr_29341_29366 = state_29319__$1;
(statearr_29341_29366[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (5))){
var _ = (function (){var statearr_29342 = state_29319;
(statearr_29342[(4)] = cljs.core.rest.call(null,(state_29319[(4)])));

return statearr_29342;
})();
var state_29319__$1 = state_29319;
var ex29338 = (state_29319__$1[(2)]);
var statearr_29343_29367 = state_29319__$1;
(statearr_29343_29367[(5)] = ex29338);


if((ex29338 instanceof Error)){
var statearr_29344_29368 = state_29319__$1;
(statearr_29344_29368[(1)] = (4));

(statearr_29344_29368[(5)] = null);

} else {
throw ex29338;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (14))){
var inst_29290 = (state_29319[(2)]);
var inst_29291 = fluree.db.util.async.throw_err.call(null,inst_29290);
var state_29319__$1 = state_29319;
var statearr_29345_29369 = state_29319__$1;
(statearr_29345_29369[(2)] = inst_29291);

(statearr_29345_29369[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (16))){
var inst_29282 = (state_29319[(7)]);
var inst_29295 = (state_29319[(8)]);
var inst_29275 = (state_29319[(9)]);
var inst_29269 = (state_29319[(10)]);
var inst_29303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29304 = inst_29275.s;
var inst_29305 = [inst_29304,inst_29282,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_29306 = (new cljs.core.PersistentVector(null,3,(5),inst_29303,inst_29305,null));
var inst_29307 = cljs.core.assoc_in.call(null,inst_29269,inst_29306,inst_29295);
var state_29319__$1 = state_29319;
var statearr_29346_29370 = state_29319__$1;
(statearr_29346_29370[(2)] = inst_29307);

(statearr_29346_29370[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (10))){
var inst_29312 = (state_29319[(2)]);
var state_29319__$1 = state_29319;
var statearr_29347_29371 = state_29319__$1;
(statearr_29347_29371[(2)] = inst_29312);

(statearr_29347_29371[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29320 === (8))){
var inst_29269 = (state_29319[(10)]);
var state_29319__$1 = state_29319;
var statearr_29348_29372 = state_29319__$1;
(statearr_29348_29372[(2)] = inst_29269);

(statearr_29348_29372[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__11469__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__11469__auto____0 = (function (){
var statearr_29349 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29349[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__11469__auto__);

(statearr_29349[(1)] = (1));

return statearr_29349;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__11469__auto____1 = (function (state_29319){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_29319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e29350){var ex__11472__auto__ = e29350;
var statearr_29351_29373 = state_29319;
(statearr_29351_29373[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_29319[(4)]))){
var statearr_29352_29374 = state_29319;
(statearr_29352_29374[(1)] = cljs.core.first.call(null,(state_29319[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29375 = state_29319;
state_29319 = G__29375;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__11469__auto__ = function(state_29319){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__11469__auto____1.call(this,state_29319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__11469__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__11469__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_29353 = f__11543__auto__.call(null);
(statearr_29353[(6)] = c__11542__auto__);

return statearr_29353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__29377 = arguments.length;
switch (G__29377) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__29380 = arguments.length;
switch (G__29380) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_29689){
var state_val_29690 = (state_29689[(1)]);
if((state_val_29690 === (65))){
var inst_29642 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29691_29863 = state_29689__$1;
(statearr_29691_29863[(2)] = inst_29642);

(statearr_29691_29863[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (70))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29564 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_29565 = inst_29552.call(null,cljs.core.PersistentArrayMap,null,2,inst_29564,null);
var inst_29566 = inst_29552.call(null,cljs.core.PersistentHashSet,null,inst_29565,null);
var inst_29567 = inst_29566.call(null,inst_29551);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29567)){
var statearr_29692_29864 = state_29689__$1;
(statearr_29692_29864[(1)] = (71));

} else {
var statearr_29693_29865 = state_29689__$1;
(statearr_29693_29865[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (62))){
var inst_29644 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29694_29866 = state_29689__$1;
(statearr_29694_29866[(2)] = inst_29644);

(statearr_29694_29866[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (74))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29574 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_29575 = inst_29552.call(null,cljs.core.PersistentArrayMap,null,3,inst_29574,null);
var inst_29576 = inst_29552.call(null,cljs.core.PersistentHashSet,null,inst_29575,null);
var inst_29577 = inst_29576.call(null,inst_29551);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29577)){
var statearr_29695_29867 = state_29689__$1;
(statearr_29695_29867[(1)] = (75));

} else {
var statearr_29696_29868 = state_29689__$1;
(statearr_29696_29868[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (110))){
var inst_29676 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29697_29869 = state_29689__$1;
(statearr_29697_29869[(2)] = inst_29676);

(statearr_29697_29869[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (7))){
var inst_29684 = (state_29689[(2)]);
var _ = (function (){var statearr_29698 = state_29689;
(statearr_29698[(4)] = cljs.core.rest.call(null,(state_29689[(4)])));

return statearr_29698;
})();
var state_29689__$1 = state_29689;
var statearr_29699_29870 = state_29689__$1;
(statearr_29699_29870[(2)] = inst_29684);

(statearr_29699_29870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (59))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29550 = (state_29689[(2)]);
var inst_29551__$1 = cljs.core.get.call(null,inst_29550,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_29552__$1 = cljs.core.get.call(null,inst_29550,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_29553 = cljs.core._EQ_.call(null,inst_29552__$1,inst_29551__$1);
var state_29689__$1 = (function (){var statearr_29700 = state_29689;
(statearr_29700[(7)] = inst_29552__$1);

(statearr_29700[(8)] = inst_29551__$1);

return statearr_29700;
})();
if(inst_29553){
var statearr_29701_29871 = state_29689__$1;
(statearr_29701_29871[(1)] = (60));

} else {
var statearr_29702_29872 = state_29689__$1;
(statearr_29702_29872[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (86))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29604 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_29605 = inst_29552.call(null,cljs.core.PersistentArrayMap,null,5,inst_29604,null);
var inst_29606 = inst_29552.call(null,cljs.core.PersistentHashSet,null,inst_29605,null);
var inst_29607 = inst_29606.call(null,inst_29551);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29607)){
var statearr_29703_29873 = state_29689__$1;
(statearr_29703_29873[(1)] = (87));

} else {
var statearr_29704_29874 = state_29689__$1;
(statearr_29704_29874[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (20))){
var inst_29420 = (state_29689[(9)]);
var inst_29445 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29446 = inst_29445 === true;
var inst_29447 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29448 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_29447);
var inst_29449 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_29448);
var inst_29450 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29451 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_29450);
var inst_29452 = inst_29451 === true;
var inst_29453 = ((inst_29446) && (inst_29449) && (inst_29452));
var state_29689__$1 = state_29689;
var statearr_29705_29875 = state_29689__$1;
(statearr_29705_29875[(2)] = inst_29453);

(statearr_29705_29875[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (72))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29570 = fluree.db.query.schema.type_error.call(null,inst_29551,inst_29552,throw_QMARK_);
var state_29689__$1 = state_29689;
var statearr_29706_29876 = state_29689__$1;
(statearr_29706_29876[(2)] = inst_29570);

(statearr_29706_29876[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (58))){
var inst_29529 = (state_29689[(10)]);
var state_29689__$1 = state_29689;
var statearr_29707_29877 = state_29689__$1;
(statearr_29707_29877[(2)] = inst_29529);

(statearr_29707_29877[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (60))){
var inst_29519 = (state_29689[(11)]);
var state_29689__$1 = state_29689;
var statearr_29708_29878 = state_29689__$1;
(statearr_29708_29878[(2)] = inst_29519);

(statearr_29708_29878[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (27))){
var inst_29440 = (state_29689[(12)]);
var state_29689__$1 = state_29689;
var statearr_29709_29879 = state_29689__$1;
(statearr_29709_29879[(2)] = inst_29440);

(statearr_29709_29879[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (1))){
var state_29689__$1 = state_29689;
var statearr_29710_29880 = state_29689__$1;
(statearr_29710_29880[(2)] = null);

(statearr_29710_29880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (69))){
var inst_29637 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29711_29881 = state_29689__$1;
(statearr_29711_29881[(2)] = inst_29637);

(statearr_29711_29881[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (101))){
var inst_29666 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29666)){
var statearr_29712_29882 = state_29689__$1;
(statearr_29712_29882[(1)] = (105));

} else {
var statearr_29713_29883 = state_29689__$1;
(statearr_29713_29883[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (24))){
var inst_29440 = (state_29689[(12)]);
var state_29689__$1 = state_29689;
var statearr_29714_29884 = state_29689__$1;
(statearr_29714_29884[(2)] = inst_29440);

(statearr_29714_29884[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (102))){
var inst_29420 = (state_29689[(9)]);
var inst_29653 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29654 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_29653);
var inst_29655 = inst_29654 === true;
var inst_29656 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29657 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_29656);
var inst_29658 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_29657);
var inst_29659 = (!(inst_29658));
var inst_29660 = ((inst_29655) && (inst_29659));
var state_29689__$1 = state_29689;
var statearr_29715_29885 = state_29689__$1;
(statearr_29715_29885[(2)] = inst_29660);

(statearr_29715_29885[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (55))){
var state_29689__$1 = state_29689;
var statearr_29716_29886 = state_29689__$1;
(statearr_29716_29886[(2)] = false);

(statearr_29716_29886[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (85))){
var inst_29602 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29717_29887 = state_29689__$1;
(statearr_29717_29887[(2)] = inst_29602);

(statearr_29717_29887[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (39))){
var state_29689__$1 = state_29689;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_29718_29888 = state_29689__$1;
(statearr_29718_29888[(1)] = (42));

} else {
var statearr_29719_29889 = state_29689__$1;
(statearr_29719_29889[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (88))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29610 = fluree.db.query.schema.type_error.call(null,inst_29551,inst_29552,throw_QMARK_);
var state_29689__$1 = state_29689;
var statearr_29720_29890 = state_29689__$1;
(statearr_29720_29890[(2)] = inst_29610);

(statearr_29720_29890[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (46))){
var inst_29520 = (state_29689[(13)]);
var state_29689__$1 = state_29689;
var statearr_29721_29891 = state_29689__$1;
(statearr_29721_29891[(2)] = inst_29520);

(statearr_29721_29891[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (4))){
var inst_29381 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29722_29892 = state_29689__$1;
(statearr_29722_29892[(2)] = inst_29381);

(statearr_29722_29892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (77))){
var inst_29582 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29723_29893 = state_29689__$1;
(statearr_29723_29893[(2)] = inst_29582);

(statearr_29723_29893[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (106))){
var inst_29647 = (state_29689[(14)]);
var state_29689__$1 = state_29689;
var statearr_29724_29894 = state_29689__$1;
(statearr_29724_29894[(2)] = inst_29647);

(statearr_29724_29894[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (95))){
var inst_29519 = (state_29689[(11)]);
var state_29689__$1 = state_29689;
var statearr_29725_29895 = state_29689__$1;
(statearr_29725_29895[(2)] = inst_29519);

(statearr_29725_29895[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (54))){
var state_29689__$1 = state_29689;
var statearr_29726_29896 = state_29689__$1;
(statearr_29726_29896[(2)] = true);

(statearr_29726_29896[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (92))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29620 = fluree.db.query.schema.type_error.call(null,inst_29551,inst_29552,throw_QMARK_);
var state_29689__$1 = state_29689;
var statearr_29727_29897 = state_29689__$1;
(statearr_29727_29897[(2)] = inst_29620);

(statearr_29727_29897[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (104))){
var inst_29663 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29728_29898 = state_29689__$1;
(statearr_29728_29898[(2)] = inst_29663);

(statearr_29728_29898[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (15))){
var inst_29408 = (state_29689[(15)]);
var state_29689__$1 = state_29689;
var statearr_29729_29899 = state_29689__$1;
(statearr_29729_29899[(2)] = inst_29408);

(statearr_29729_29899[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (48))){
var inst_29529 = (state_29689[(10)]);
var inst_29420 = (state_29689[(9)]);
var inst_29529__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29531 = (inst_29529__$1 == null);
var inst_29532 = cljs.core.not.call(null,inst_29531);
var state_29689__$1 = (function (){var statearr_29730 = state_29689;
(statearr_29730[(10)] = inst_29529__$1);

return statearr_29730;
})();
if(inst_29532){
var statearr_29731_29900 = state_29689__$1;
(statearr_29731_29900[(1)] = (51));

} else {
var statearr_29732_29901 = state_29689__$1;
(statearr_29732_29901[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (50))){
var inst_29420 = (state_29689[(9)]);
var inst_29647 = (state_29689[(2)]);
var inst_29648 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29649 = inst_29648 === true;
var state_29689__$1 = (function (){var statearr_29733 = state_29689;
(statearr_29733[(14)] = inst_29647);

return statearr_29733;
})();
if(cljs.core.truth_(inst_29649)){
var statearr_29734_29902 = state_29689__$1;
(statearr_29734_29902[(1)] = (99));

} else {
var statearr_29735_29903 = state_29689__$1;
(statearr_29735_29903[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (75))){
var inst_29519 = (state_29689[(11)]);
var state_29689__$1 = state_29689;
var statearr_29736_29904 = state_29689__$1;
(statearr_29736_29904[(2)] = inst_29519);

(statearr_29736_29904[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (99))){
var inst_29651 = (state_29689[(16)]);
var inst_29420 = (state_29689[(9)]);
var inst_29651__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_29420);
var state_29689__$1 = (function (){var statearr_29737 = state_29689;
(statearr_29737[(16)] = inst_29651__$1);

return statearr_29737;
})();
if(cljs.core.truth_(inst_29651__$1)){
var statearr_29738_29905 = state_29689__$1;
(statearr_29738_29905[(1)] = (102));

} else {
var statearr_29739_29906 = state_29689__$1;
(statearr_29739_29906[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (21))){
var inst_29443 = (state_29689[(17)]);
var state_29689__$1 = state_29689;
var statearr_29740_29907 = state_29689__$1;
(statearr_29740_29907[(2)] = inst_29443);

(statearr_29740_29907[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (31))){
var inst_29483 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29483)){
var statearr_29741_29908 = state_29689__$1;
(statearr_29741_29908[(1)] = (32));

} else {
var statearr_29742_29909 = state_29689__$1;
(statearr_29742_29909[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (32))){
var inst_29472 = (state_29689[(18)]);
var inst_29485 = fluree.db.query.schema.type_error.call(null,inst_29472,"a component","a non-component",throw_QMARK_);
var state_29689__$1 = state_29689;
var statearr_29743_29910 = state_29689__$1;
(statearr_29743_29910[(2)] = inst_29485);

(statearr_29743_29910[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (40))){
var inst_29488 = (state_29689[(19)]);
var state_29689__$1 = state_29689;
var statearr_29744_29911 = state_29689__$1;
(statearr_29744_29911[(2)] = inst_29488);

(statearr_29744_29911[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (91))){
var inst_29519 = (state_29689[(11)]);
var state_29689__$1 = state_29689;
var statearr_29745_29912 = state_29689__$1;
(statearr_29745_29912[(2)] = inst_29519);

(statearr_29745_29912[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (108))){
var inst_29669 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29670 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_29671 = cljs.core.PersistentHashMap.fromArrays(inst_29669,inst_29670);
var inst_29672 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_29671);
var inst_29673 = (function(){throw inst_29672})();
var state_29689__$1 = state_29689;
var statearr_29746_29913 = state_29689__$1;
(statearr_29746_29913[(2)] = inst_29673);

(statearr_29746_29913[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (56))){
var inst_29542 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29747_29914 = state_29689__$1;
(statearr_29747_29914[(2)] = inst_29542);

(statearr_29747_29914[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (33))){
var inst_29472 = (state_29689[(18)]);
var state_29689__$1 = state_29689;
var statearr_29748_29915 = state_29689__$1;
(statearr_29748_29915[(2)] = inst_29472);

(statearr_29748_29915[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (13))){
var inst_29435 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29435)){
var statearr_29749_29916 = state_29689__$1;
(statearr_29749_29916[(1)] = (14));

} else {
var statearr_29750_29917 = state_29689__$1;
(statearr_29750_29917[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (22))){
var inst_29456 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29751_29918 = state_29689__$1;
(statearr_29751_29918[(2)] = inst_29456);

(statearr_29751_29918[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (90))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29614 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_29615 = inst_29552.call(null,cljs.core.PersistentArrayMap,null,5,inst_29614,null);
var inst_29616 = inst_29552.call(null,cljs.core.PersistentHashSet,null,inst_29615,null);
var inst_29617 = inst_29616.call(null,inst_29551);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29617)){
var statearr_29752_29919 = state_29689__$1;
(statearr_29752_29919[(1)] = (91));

} else {
var statearr_29753_29920 = state_29689__$1;
(statearr_29753_29920[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (109))){
var inst_29647 = (state_29689[(14)]);
var state_29689__$1 = state_29689;
var statearr_29754_29921 = state_29689__$1;
(statearr_29754_29921[(2)] = inst_29647);

(statearr_29754_29921[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (36))){
var inst_29489 = (state_29689[(20)]);
var state_29689__$1 = state_29689;
var statearr_29755_29922 = state_29689__$1;
(statearr_29755_29922[(2)] = inst_29489);

(statearr_29755_29922[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (41))){
var inst_29420 = (state_29689[(9)]);
var inst_29520 = (state_29689[(13)]);
var inst_29519 = (state_29689[(2)]);
var inst_29520__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_29420);
var state_29689__$1 = (function (){var statearr_29756 = state_29689;
(statearr_29756[(11)] = inst_29519);

(statearr_29756[(13)] = inst_29520__$1);

return statearr_29756;
})();
if(cljs.core.truth_(inst_29520__$1)){
var statearr_29757_29923 = state_29689__$1;
(statearr_29757_29923[(1)] = (45));

} else {
var statearr_29758_29924 = state_29689__$1;
(statearr_29758_29924[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (89))){
var inst_29612 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29759_29925 = state_29689__$1;
(statearr_29759_29925[(2)] = inst_29612);

(statearr_29759_29925[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (100))){
var state_29689__$1 = state_29689;
var statearr_29760_29926 = state_29689__$1;
(statearr_29760_29926[(2)] = false);

(statearr_29760_29926[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (43))){
var inst_29488 = (state_29689[(19)]);
var state_29689__$1 = state_29689;
var statearr_29761_29927 = state_29689__$1;
(statearr_29761_29927[(2)] = inst_29488);

(statearr_29761_29927[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (61))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29556 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_29557 = inst_29552.call(null,cljs.core.PersistentArrayMap,null,3,inst_29556,null);
var inst_29558 = inst_29552.call(null,cljs.core.PersistentHashSet,null,inst_29557,null);
var inst_29559 = inst_29558.call(null,inst_29551);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29559)){
var statearr_29762_29928 = state_29689__$1;
(statearr_29762_29928[(1)] = (63));

} else {
var statearr_29763_29929 = state_29689__$1;
(statearr_29763_29929[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (29))){
var inst_29420 = (state_29689[(9)]);
var inst_29475 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29476 = cljs.core.not.call(null,inst_29475);
var inst_29477 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29478 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_29477);
var inst_29479 = inst_29478 === true;
var inst_29480 = ((inst_29476) && (inst_29479));
var state_29689__$1 = state_29689;
var statearr_29764_29930 = state_29689__$1;
(statearr_29764_29930[(2)] = inst_29480);

(statearr_29764_29930[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (44))){
var inst_29516 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29765_29931 = state_29689__$1;
(statearr_29765_29931[(2)] = inst_29516);

(statearr_29765_29931[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (93))){
var inst_29622 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29766_29932 = state_29689__$1;
(statearr_29766_29932[(2)] = inst_29622);

(statearr_29766_29932[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (6))){
var inst_29407 = (state_29689[(21)]);
var inst_29419 = (state_29689[(22)]);
var inst_29416 = cljs.core.seq.call(null,inst_29407);
var inst_29417 = cljs.core.first.call(null,inst_29416);
var inst_29418 = cljs.core.next.call(null,inst_29416);
var inst_29419__$1 = cljs.core.nth.call(null,inst_29417,(0),null);
var inst_29420 = cljs.core.nth.call(null,inst_29417,(1),null);
var inst_29421 = cljs.core.not.call(null,inst_29419__$1);
var state_29689__$1 = (function (){var statearr_29767 = state_29689;
(statearr_29767[(23)] = inst_29418);

(statearr_29767[(9)] = inst_29420);

(statearr_29767[(22)] = inst_29419__$1);

return statearr_29767;
})();
if(inst_29421){
var statearr_29768_29933 = state_29689__$1;
(statearr_29768_29933[(1)] = (8));

} else {
var statearr_29769_29934 = state_29689__$1;
(statearr_29769_29934[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (28))){
var inst_29469 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29770_29935 = state_29689__$1;
(statearr_29770_29935[(2)] = inst_29469);

(statearr_29770_29935[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (64))){
var state_29689__$1 = state_29689;
var statearr_29771_29936 = state_29689__$1;
(statearr_29771_29936[(1)] = (66));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (103))){
var inst_29651 = (state_29689[(16)]);
var state_29689__$1 = state_29689;
var statearr_29773_29937 = state_29689__$1;
(statearr_29773_29937[(2)] = inst_29651);

(statearr_29773_29937[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (51))){
var inst_29529 = (state_29689[(10)]);
var inst_29534 = inst_29529.cljs$lang$protocol_mask$partition0$;
var inst_29535 = (inst_29534 & (64));
var inst_29536 = inst_29529.cljs$core$ISeq$;
var inst_29537 = (cljs.core.PROTOCOL_SENTINEL === inst_29536);
var inst_29538 = ((inst_29535) || (inst_29537));
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29538)){
var statearr_29774_29938 = state_29689__$1;
(statearr_29774_29938[(1)] = (54));

} else {
var statearr_29775_29939 = state_29689__$1;
(statearr_29775_29939[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (25))){
var inst_29473 = (state_29689[(24)]);
var inst_29420 = (state_29689[(9)]);
var inst_29472 = (state_29689[(2)]);
var inst_29473__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_29420);
var state_29689__$1 = (function (){var statearr_29776 = state_29689;
(statearr_29776[(24)] = inst_29473__$1);

(statearr_29776[(18)] = inst_29472);

return statearr_29776;
})();
if(cljs.core.truth_(inst_29473__$1)){
var statearr_29777_29940 = state_29689__$1;
(statearr_29777_29940[(1)] = (29));

} else {
var statearr_29778_29941 = state_29689__$1;
(statearr_29778_29941[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (34))){
var inst_29489 = (state_29689[(20)]);
var inst_29420 = (state_29689[(9)]);
var inst_29488 = (state_29689[(2)]);
var inst_29489__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_29420);
var state_29689__$1 = (function (){var statearr_29779 = state_29689;
(statearr_29779[(19)] = inst_29488);

(statearr_29779[(20)] = inst_29489__$1);

return statearr_29779;
})();
if(cljs.core.truth_(inst_29489__$1)){
var statearr_29780_29942 = state_29689__$1;
(statearr_29780_29942[(1)] = (35));

} else {
var statearr_29781_29943 = state_29689__$1;
(statearr_29781_29943[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (17))){
var inst_29443 = (state_29689[(17)]);
var inst_29420 = (state_29689[(9)]);
var inst_29443__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_29420);
var state_29689__$1 = (function (){var statearr_29782 = state_29689;
(statearr_29782[(17)] = inst_29443__$1);

return statearr_29782;
})();
if(cljs.core.truth_(inst_29443__$1)){
var statearr_29783_29944 = state_29689__$1;
(statearr_29783_29944[(1)] = (20));

} else {
var statearr_29784_29945 = state_29689__$1;
(statearr_29784_29945[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (3))){
var inst_29687 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29689__$1,inst_29687);
} else {
if((state_val_29690 === (12))){
var inst_29424 = (state_29689[(25)]);
var state_29689__$1 = state_29689;
var statearr_29785_29946 = state_29689__$1;
(statearr_29785_29946[(2)] = inst_29424);

(statearr_29785_29946[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (2))){
var _ = (function (){var statearr_29786 = state_29689;
(statearr_29786[(4)] = cljs.core.cons.call(null,(5),(state_29689[(4)])));

return statearr_29786;
})();
var inst_29400 = pred_changes;
var inst_29401 = cljs.core.seq.call(null,inst_29400);
var inst_29402 = cljs.core.first.call(null,inst_29401);
var inst_29403 = cljs.core.next.call(null,inst_29401);
var inst_29404 = cljs.core.nth.call(null,inst_29402,(0),null);
var inst_29405 = cljs.core.nth.call(null,inst_29402,(1),null);
var inst_29406 = db;
var inst_29407 = inst_29400;
var inst_29408 = inst_29406;
var state_29689__$1 = (function (){var statearr_29787 = state_29689;
(statearr_29787[(21)] = inst_29407);

(statearr_29787[(15)] = inst_29408);

(statearr_29787[(26)] = inst_29404);

(statearr_29787[(27)] = inst_29403);

(statearr_29787[(28)] = inst_29405);

return statearr_29787;
})();
var statearr_29788_29947 = state_29689__$1;
(statearr_29788_29947[(2)] = null);

(statearr_29788_29947[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (66))){
var inst_29552 = (state_29689[(7)]);
var state_29689__$1 = state_29689;
var G__29789_29948 = inst_29552;
var G__29789_29949__$1 = (((G__29789_29948 instanceof cljs.core.Keyword))?G__29789_29948.fqn:null);
switch (G__29789_29949__$1) {
case "long":
var statearr_29790_29951 = state_29689__$1;
(statearr_29790_29951[(1)] = (70));


break;
case "bigint":
var statearr_29791_29952 = state_29689__$1;
(statearr_29791_29952[(1)] = (74));


break;
case "double":
var statearr_29792_29953 = state_29689__$1;
(statearr_29792_29953[(1)] = (78));


break;
case "float":
var statearr_29793_29954 = state_29689__$1;
(statearr_29793_29954[(1)] = (82));


break;
case "bigdec":
var statearr_29794_29955 = state_29689__$1;
(statearr_29794_29955[(1)] = (86));


break;
case "string":
var statearr_29795_29956 = state_29689__$1;
(statearr_29795_29956[(1)] = (90));


break;
case "instant":
var statearr_29796_29957 = state_29689__$1;
(statearr_29796_29957[(1)] = (94));


break;
default:
var statearr_29797_29958 = state_29689__$1;
(statearr_29797_29958[(1)] = (98));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (107))){
var inst_29418 = (state_29689[(23)]);
var inst_29679 = (state_29689[(2)]);
var inst_29407 = inst_29418;
var inst_29408 = inst_29679;
var state_29689__$1 = (function (){var statearr_29798 = state_29689;
(statearr_29798[(21)] = inst_29407);

(statearr_29798[(15)] = inst_29408);

return statearr_29798;
})();
var statearr_29799_29959 = state_29689__$1;
(statearr_29799_29959[(2)] = null);

(statearr_29799_29959[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (23))){
var state_29689__$1 = state_29689;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_29800_29960 = state_29689__$1;
(statearr_29800_29960[(1)] = (26));

} else {
var statearr_29801_29961 = state_29689__$1;
(statearr_29801_29961[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (47))){
var inst_29526 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29526)){
var statearr_29802_29962 = state_29689__$1;
(statearr_29802_29962[(1)] = (48));

} else {
var statearr_29803_29963 = state_29689__$1;
(statearr_29803_29963[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (35))){
var inst_29408 = (state_29689[(15)]);
var inst_29420 = (state_29689[(9)]);
var inst_29419 = (state_29689[(22)]);
var inst_29491 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29492 = cljs.core.not.call(null,inst_29491);
var inst_29493 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29494 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_29493);
var inst_29495 = inst_29494 === true;
var inst_29496 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_29408,inst_29419);
var state_29689__$1 = (function (){var statearr_29804 = state_29689;
(statearr_29804[(29)] = inst_29495);

(statearr_29804[(30)] = inst_29492);

return statearr_29804;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29689__$1,(38),inst_29496);
} else {
if((state_val_29690 === (82))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29594 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_29595 = inst_29552.call(null,cljs.core.PersistentArrayMap,null,3,inst_29594,null);
var inst_29596 = inst_29552.call(null,cljs.core.PersistentHashSet,null,inst_29595,null);
var inst_29597 = inst_29596.call(null,inst_29551);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29597)){
var statearr_29805_29964 = state_29689__$1;
(statearr_29805_29964[(1)] = (83));

} else {
var statearr_29806_29965 = state_29689__$1;
(statearr_29806_29965[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (76))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29580 = fluree.db.query.schema.type_error.call(null,inst_29551,inst_29552,throw_QMARK_);
var state_29689__$1 = state_29689;
var statearr_29807_29966 = state_29689__$1;
(statearr_29807_29966[(2)] = inst_29580);

(statearr_29807_29966[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (97))){
var inst_29632 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29808_29967 = state_29689__$1;
(statearr_29808_29967[(2)] = inst_29632);

(statearr_29808_29967[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (19))){
var inst_29459 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29459)){
var statearr_29809_29968 = state_29689__$1;
(statearr_29809_29968[(1)] = (23));

} else {
var statearr_29810_29969 = state_29689__$1;
(statearr_29810_29969[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (57))){
var inst_29529 = (state_29689[(10)]);
var inst_29547 = cljs.core.apply.call(null,cljs.core.hash_map,inst_29529);
var state_29689__$1 = state_29689;
var statearr_29811_29970 = state_29689__$1;
(statearr_29811_29970[(2)] = inst_29547);

(statearr_29811_29970[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (68))){
var inst_29640 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29812_29971 = state_29689__$1;
(statearr_29812_29971[(2)] = inst_29640);

(statearr_29812_29971[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (11))){
var inst_29420 = (state_29689[(9)]);
var inst_29426 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29427 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_29426);
var inst_29428 = inst_29427 === false;
var inst_29429 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29430 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_29429);
var inst_29431 = inst_29430 === true;
var inst_29432 = ((inst_29428) && (inst_29431));
var state_29689__$1 = state_29689;
var statearr_29814_29972 = state_29689__$1;
(statearr_29814_29972[(2)] = inst_29432);

(statearr_29814_29972[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (9))){
var inst_29424 = (state_29689[(25)]);
var inst_29420 = (state_29689[(9)]);
var inst_29424__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_29420);
var state_29689__$1 = (function (){var statearr_29815 = state_29689;
(statearr_29815[(25)] = inst_29424__$1);

return statearr_29815;
})();
if(cljs.core.truth_(inst_29424__$1)){
var statearr_29816_29973 = state_29689__$1;
(statearr_29816_29973[(1)] = (11));

} else {
var statearr_29817_29974 = state_29689__$1;
(statearr_29817_29974[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (5))){
var _ = (function (){var statearr_29818 = state_29689;
(statearr_29818[(4)] = cljs.core.rest.call(null,(state_29689[(4)])));

return statearr_29818;
})();
var state_29689__$1 = state_29689;
var ex29813 = (state_29689__$1[(2)]);
var statearr_29819_29975 = state_29689__$1;
(statearr_29819_29975[(5)] = ex29813);


if((ex29813 instanceof Error)){
var statearr_29820_29976 = state_29689__$1;
(statearr_29820_29976[(1)] = (4));

(statearr_29820_29976[(5)] = null);

} else {
throw ex29813;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (83))){
var inst_29519 = (state_29689[(11)]);
var state_29689__$1 = state_29689;
var statearr_29821_29977 = state_29689__$1;
(statearr_29821_29977[(2)] = inst_29519);

(statearr_29821_29977[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (14))){
var inst_29408 = (state_29689[(15)]);
var inst_29437 = fluree.db.query.schema.type_error.call(null,inst_29408,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_29689__$1 = state_29689;
var statearr_29822_29978 = state_29689__$1;
(statearr_29822_29978[(2)] = inst_29437);

(statearr_29822_29978[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (45))){
var inst_29420 = (state_29689[(9)]);
var inst_29522 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_29420);
var inst_29523 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_29522);
var state_29689__$1 = state_29689;
var statearr_29823_29979 = state_29689__$1;
(statearr_29823_29979[(2)] = inst_29523);

(statearr_29823_29979[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (53))){
var inst_29545 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29545)){
var statearr_29824_29980 = state_29689__$1;
(statearr_29824_29980[(1)] = (57));

} else {
var statearr_29825_29981 = state_29689__$1;
(statearr_29825_29981[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (78))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29584 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_29585 = inst_29552.call(null,cljs.core.PersistentArrayMap,null,3,inst_29584,null);
var inst_29586 = inst_29552.call(null,cljs.core.PersistentHashSet,null,inst_29585,null);
var inst_29587 = inst_29586.call(null,inst_29551);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29587)){
var statearr_29826_29982 = state_29689__$1;
(statearr_29826_29982[(1)] = (79));

} else {
var statearr_29827_29983 = state_29689__$1;
(statearr_29827_29983[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (26))){
var inst_29462 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29463 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_29464 = cljs.core.PersistentHashMap.fromArrays(inst_29462,inst_29463);
var inst_29465 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_29464);
var inst_29466 = (function(){throw inst_29465})();
var state_29689__$1 = state_29689;
var statearr_29828_29984 = state_29689__$1;
(statearr_29828_29984[(2)] = inst_29466);

(statearr_29828_29984[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (16))){
var inst_29441 = (state_29689[(31)]);
var inst_29420 = (state_29689[(9)]);
var inst_29440 = (state_29689[(2)]);
var inst_29441__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_29420);
var state_29689__$1 = (function (){var statearr_29829 = state_29689;
(statearr_29829[(31)] = inst_29441__$1);

(statearr_29829[(12)] = inst_29440);

return statearr_29829;
})();
if(cljs.core.truth_(inst_29441__$1)){
var statearr_29830_29985 = state_29689__$1;
(statearr_29830_29985[(1)] = (17));

} else {
var statearr_29831_29986 = state_29689__$1;
(statearr_29831_29986[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (81))){
var inst_29592 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29832_29987 = state_29689__$1;
(statearr_29832_29987[(2)] = inst_29592);

(statearr_29832_29987[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (79))){
var inst_29519 = (state_29689[(11)]);
var state_29689__$1 = state_29689;
var statearr_29833_29988 = state_29689__$1;
(statearr_29833_29988[(2)] = inst_29519);

(statearr_29833_29988[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (38))){
var inst_29495 = (state_29689[(29)]);
var inst_29492 = (state_29689[(30)]);
var inst_29498 = (state_29689[(2)]);
var inst_29499 = fluree.db.util.async.throw_err.call(null,inst_29498);
var inst_29500 = cljs.core.not.call(null,inst_29499);
var inst_29501 = ((inst_29492) && (inst_29495) && (inst_29500));
var state_29689__$1 = state_29689;
var statearr_29834_29989 = state_29689__$1;
(statearr_29834_29989[(2)] = inst_29501);

(statearr_29834_29989[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (98))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29634 = fluree.db.query.schema.type_error.call(null,inst_29551,inst_29552,throw_QMARK_);
var state_29689__$1 = state_29689;
var statearr_29835_29990 = state_29689__$1;
(statearr_29835_29990[(2)] = inst_29634);

(statearr_29835_29990[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (87))){
var inst_29519 = (state_29689[(11)]);
var state_29689__$1 = state_29689;
var statearr_29836_29991 = state_29689__$1;
(statearr_29836_29991[(2)] = inst_29519);

(statearr_29836_29991[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (30))){
var inst_29473 = (state_29689[(24)]);
var state_29689__$1 = state_29689;
var statearr_29837_29992 = state_29689__$1;
(statearr_29837_29992[(2)] = inst_29473);

(statearr_29837_29992[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (73))){
var inst_29572 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29838_29993 = state_29689__$1;
(statearr_29838_29993[(2)] = inst_29572);

(statearr_29838_29993[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (96))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29630 = fluree.db.query.schema.type_error.call(null,inst_29551,inst_29552,throw_QMARK_);
var state_29689__$1 = state_29689;
var statearr_29839_29994 = state_29689__$1;
(statearr_29839_29994[(2)] = inst_29630);

(statearr_29839_29994[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (10))){
var inst_29682 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
var statearr_29840_29995 = state_29689__$1;
(statearr_29840_29995[(2)] = inst_29682);

(statearr_29840_29995[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (18))){
var inst_29441 = (state_29689[(31)]);
var state_29689__$1 = state_29689;
var statearr_29841_29996 = state_29689__$1;
(statearr_29841_29996[(2)] = inst_29441);

(statearr_29841_29996[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (105))){
var state_29689__$1 = state_29689;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_29842_29997 = state_29689__$1;
(statearr_29842_29997[(1)] = (108));

} else {
var statearr_29843_29998 = state_29689__$1;
(statearr_29843_29998[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (52))){
var state_29689__$1 = state_29689;
var statearr_29844_29999 = state_29689__$1;
(statearr_29844_29999[(2)] = false);

(statearr_29844_29999[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (67))){
var state_29689__$1 = state_29689;
var statearr_29845_30000 = state_29689__$1;
(statearr_29845_30000[(2)] = null);

(statearr_29845_30000[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (71))){
var inst_29519 = (state_29689[(11)]);
var state_29689__$1 = state_29689;
var statearr_29846_30001 = state_29689__$1;
(statearr_29846_30001[(2)] = inst_29519);

(statearr_29846_30001[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (42))){
var inst_29408 = (state_29689[(15)]);
var inst_29419 = (state_29689[(22)]);
var inst_29507 = fluree.db.dbproto._p_prop.call(null,inst_29408,new cljs.core.Keyword(null,"name","name",1843675177),inst_29419);
var inst_29508 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29507)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_29509 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29510 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_29511 = cljs.core.PersistentHashMap.fromArrays(inst_29509,inst_29510);
var inst_29512 = cljs.core.ex_info.call(null,inst_29508,inst_29511);
var inst_29513 = (function(){throw inst_29512})();
var state_29689__$1 = state_29689;
var statearr_29847_30002 = state_29689__$1;
(statearr_29847_30002[(2)] = inst_29513);

(statearr_29847_30002[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (80))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29590 = fluree.db.query.schema.type_error.call(null,inst_29551,inst_29552,throw_QMARK_);
var state_29689__$1 = state_29689;
var statearr_29848_30003 = state_29689__$1;
(statearr_29848_30003[(2)] = inst_29590);

(statearr_29848_30003[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (37))){
var inst_29504 = (state_29689[(2)]);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29504)){
var statearr_29849_30004 = state_29689__$1;
(statearr_29849_30004[(1)] = (39));

} else {
var statearr_29850_30005 = state_29689__$1;
(statearr_29850_30005[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (63))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29561 = fluree.db.query.schema.type_error.call(null,inst_29551,inst_29552,throw_QMARK_);
var state_29689__$1 = state_29689;
var statearr_29851_30006 = state_29689__$1;
(statearr_29851_30006[(2)] = inst_29561);

(statearr_29851_30006[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (94))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29624 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_29625 = inst_29552.call(null,cljs.core.PersistentArrayMap,null,2,inst_29624,null);
var inst_29626 = inst_29552.call(null,cljs.core.PersistentHashSet,null,inst_29625,null);
var inst_29627 = inst_29626.call(null,inst_29551);
var state_29689__$1 = state_29689;
if(cljs.core.truth_(inst_29627)){
var statearr_29852_30007 = state_29689__$1;
(statearr_29852_30007[(1)] = (95));

} else {
var statearr_29853_30008 = state_29689__$1;
(statearr_29853_30008[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (8))){
var inst_29408 = (state_29689[(15)]);
var state_29689__$1 = state_29689;
var statearr_29854_30009 = state_29689__$1;
(statearr_29854_30009[(2)] = inst_29408);

(statearr_29854_30009[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (49))){
var inst_29519 = (state_29689[(11)]);
var state_29689__$1 = state_29689;
var statearr_29855_30010 = state_29689__$1;
(statearr_29855_30010[(2)] = inst_29519);

(statearr_29855_30010[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29690 === (84))){
var inst_29552 = (state_29689[(7)]);
var inst_29551 = (state_29689[(8)]);
var inst_29600 = fluree.db.query.schema.type_error.call(null,inst_29551,inst_29552,throw_QMARK_);
var state_29689__$1 = state_29689;
var statearr_29856_30011 = state_29689__$1;
(statearr_29856_30011[(2)] = inst_29600);

(statearr_29856_30011[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__11469__auto__ = null;
var fluree$db$query$schema$state_machine__11469__auto____0 = (function (){
var statearr_29857 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29857[(0)] = fluree$db$query$schema$state_machine__11469__auto__);

(statearr_29857[(1)] = (1));

return statearr_29857;
});
var fluree$db$query$schema$state_machine__11469__auto____1 = (function (state_29689){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_29689);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e29858){var ex__11472__auto__ = e29858;
var statearr_29859_30012 = state_29689;
(statearr_29859_30012[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_29689[(4)]))){
var statearr_29860_30013 = state_29689;
(statearr_29860_30013[(1)] = cljs.core.first.call(null,(state_29689[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30014 = state_29689;
state_29689 = G__30014;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__11469__auto__ = function(state_29689){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__11469__auto____1.call(this,state_29689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__11469__auto____0;
fluree$db$query$schema$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__11469__auto____1;
return fluree$db$query$schema$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_29861 = f__11543__auto__.call(null);
(statearr_29861[(6)] = c__11542__auto__);

return statearr_29861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_30038){
var state_val_30039 = (state_30038[(1)]);
if((state_val_30039 === (7))){
var state_30038__$1 = state_30038;
var statearr_30040_30059 = state_30038__$1;
(statearr_30040_30059[(2)] = db);

(statearr_30040_30059[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30039 === (1))){
var state_30038__$1 = state_30038;
var statearr_30041_30060 = state_30038__$1;
(statearr_30041_30060[(2)] = null);

(statearr_30041_30060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30039 === (4))){
var inst_30015 = (state_30038[(2)]);
var state_30038__$1 = state_30038;
var statearr_30042_30061 = state_30038__$1;
(statearr_30042_30061[(2)] = inst_30015);

(statearr_30042_30061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30039 === (6))){
var inst_30024 = (state_30038[(7)]);
var inst_30023 = (state_30038[(2)]);
var inst_30024__$1 = fluree.db.util.async.throw_err.call(null,inst_30023);
var inst_30025 = cljs.core.empty_QMARK_.call(null,inst_30024__$1);
var state_30038__$1 = (function (){var statearr_30043 = state_30038;
(statearr_30043[(7)] = inst_30024__$1);

return statearr_30043;
})();
if(inst_30025){
var statearr_30044_30062 = state_30038__$1;
(statearr_30044_30062[(1)] = (7));

} else {
var statearr_30045_30063 = state_30038__$1;
(statearr_30045_30063[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30039 === (3))){
var inst_30036 = (state_30038[(2)]);
var state_30038__$1 = state_30038;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30038__$1,inst_30036);
} else {
if((state_val_30039 === (2))){
var _ = (function (){var statearr_30047 = state_30038;
(statearr_30047[(4)] = cljs.core.cons.call(null,(5),(state_30038[(4)])));

return statearr_30047;
})();
var inst_30021 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes);
var state_30038__$1 = state_30038;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30038__$1,(6),inst_30021);
} else {
if((state_val_30039 === (9))){
var inst_30033 = (state_30038[(2)]);
var _ = (function (){var statearr_30048 = state_30038;
(statearr_30048[(4)] = cljs.core.rest.call(null,(state_30038[(4)])));

return statearr_30048;
})();
var state_30038__$1 = state_30038;
var statearr_30049_30064 = state_30038__$1;
(statearr_30049_30064[(2)] = inst_30033);

(statearr_30049_30064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30039 === (5))){
var _ = (function (){var statearr_30050 = state_30038;
(statearr_30050[(4)] = cljs.core.rest.call(null,(state_30038[(4)])));

return statearr_30050;
})();
var state_30038__$1 = state_30038;
var ex30046 = (state_30038__$1[(2)]);
var statearr_30051_30065 = state_30038__$1;
(statearr_30051_30065[(5)] = ex30046);


if((ex30046 instanceof Error)){
var statearr_30052_30066 = state_30038__$1;
(statearr_30052_30066[(1)] = (4));

(statearr_30052_30066[(5)] = null);

} else {
throw ex30046;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30039 === (10))){
var inst_30030 = (state_30038[(2)]);
var inst_30031 = fluree.db.util.async.throw_err.call(null,inst_30030);
var state_30038__$1 = state_30038;
var statearr_30053_30067 = state_30038__$1;
(statearr_30053_30067[(2)] = inst_30031);

(statearr_30053_30067[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30039 === (8))){
var inst_30024 = (state_30038[(7)]);
var inst_30028 = fluree.db.query.schema.predicate_change_error.call(null,inst_30024,db,true);
var state_30038__$1 = state_30038;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30038__$1,(10),inst_30028);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__11469__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__11469__auto____0 = (function (){
var statearr_30054 = [null,null,null,null,null,null,null,null];
(statearr_30054[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__11469__auto__);

(statearr_30054[(1)] = (1));

return statearr_30054;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__11469__auto____1 = (function (state_30038){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_30038);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e30055){var ex__11472__auto__ = e30055;
var statearr_30056_30068 = state_30038;
(statearr_30056_30068[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_30038[(4)]))){
var statearr_30057_30069 = state_30038;
(statearr_30057_30069[(1)] = cljs.core.first.call(null,(state_30038[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30070 = state_30038;
state_30038 = G__30070;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__11469__auto__ = function(state_30038){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__11469__auto____1.call(this,state_30038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__11469__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__11469__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_30058 = f__11543__auto__.call(null);
(statearr_30058[(6)] = c__11542__auto__);

return statearr_30058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__30072 = arguments.length;
switch (G__30072) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__30074 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__30074,(0),null);
var ns = cljs.core.nth.call(null,vec__30074,(1),null);
var name = cljs.core.nth.call(null,vec__30074,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__30077_SHARP_,p2__30078_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30077_SHARP_,p2__30078_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_30144){
var state_val_30145 = (state_30144[(1)]);
if((state_val_30145 === (1))){
var state_30144__$1 = state_30144;
var statearr_30146_30163 = state_30144__$1;
(statearr_30146_30163[(2)] = null);

(statearr_30146_30163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30145 === (2))){
var _ = (function (){var statearr_30147 = state_30144;
(statearr_30147[(4)] = cljs.core.cons.call(null,(5),(state_30144[(4)])));

return statearr_30147;
})();
var inst_30096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30097 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_30098 = [inst_30097];
var inst_30099 = (new cljs.core.PersistentVector(null,1,(5),inst_30096,inst_30098,null));
var inst_30100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30101 = [(0)];
var inst_30102 = (new cljs.core.PersistentVector(null,1,(5),inst_30100,inst_30101,null));
var inst_30103 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_30099,cljs.core._LT__EQ_,inst_30102);
var state_30144__$1 = state_30144;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30144__$1,(6),inst_30103);
} else {
if((state_val_30145 === (3))){
var inst_30142 = (state_30144[(2)]);
var state_30144__$1 = state_30144;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30144__$1,inst_30142);
} else {
if((state_val_30145 === (4))){
var inst_30084 = (state_30144[(2)]);
var state_30144__$1 = state_30144;
var statearr_30149_30164 = state_30144__$1;
(statearr_30149_30164[(2)] = inst_30084);

(statearr_30149_30164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30145 === (5))){
var _ = (function (){var statearr_30150 = state_30144;
(statearr_30150[(4)] = cljs.core.rest.call(null,(state_30144[(4)])));

return statearr_30150;
})();
var state_30144__$1 = state_30144;
var ex30148 = (state_30144__$1[(2)]);
var statearr_30151_30165 = state_30144__$1;
(statearr_30151_30165[(5)] = ex30148);


if((ex30148 instanceof Error)){
var statearr_30152_30166 = state_30144__$1;
(statearr_30152_30166[(1)] = (4));

(statearr_30152_30166[(5)] = null);

} else {
throw ex30148;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30145 === (6))){
var inst_30105 = (state_30144[(2)]);
var inst_30106 = fluree.db.util.async.throw_err.call(null,inst_30105);
var inst_30107 = (function (){var schema_flakes = inst_30106;
return (function (p1__30079_SHARP_){
return (p1__30079_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_30108 = cljs.core.partition_by.call(null,inst_30107,inst_30106);
var inst_30109 = cljs.core.nth.call(null,inst_30108,(0),null);
var inst_30110 = cljs.core.nth.call(null,inst_30108,(1),null);
var inst_30111 = (function (){var schema_flakes = inst_30106;
var vec__30090 = inst_30108;
var collection_flakes = inst_30109;
var predicate_flakes = inst_30110;
return (function (acc,coll_flakes){
var sid = cljs.core.first.call(null,coll_flakes).s;
var id = fluree.db.flake.sid__GT_i.call(null,sid);
var p__GT_v = cljs.core.reduce.call(null,(function (p1__30081_SHARP_,p2__30082_SHARP_){
return cljs.core.assoc.call(null,p1__30081_SHARP_,p2__30082_SHARP_.p,p2__30082_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var spec = cljs.core.get.call(null,p__GT_v,(43));
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),id], null);
return cljs.core.assoc.call(null,acc,id,c_props,c_name,c_props);
});
})();
var inst_30112 = [(-1),"_tx"];
var inst_30113 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_30114 = ["_tx",(-1),(-1)];
var inst_30115 = cljs.core.PersistentHashMap.fromArrays(inst_30113,inst_30114);
var inst_30116 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_30117 = ["_tx",(-1),(-1)];
var inst_30118 = cljs.core.PersistentHashMap.fromArrays(inst_30116,inst_30117);
var inst_30119 = [inst_30115,inst_30118];
var inst_30120 = cljs.core.PersistentHashMap.fromArrays(inst_30112,inst_30119);
var inst_30121 = (function (){var schema_flakes = inst_30106;
var vec__30090 = inst_30108;
var collection_flakes = inst_30109;
var predicate_flakes = inst_30110;
return (function (p1__30080_SHARP_){
return p1__30080_SHARP_.s;
});
})();
var inst_30122 = cljs.core.partition_by.call(null,inst_30121,inst_30109);
var inst_30123 = cljs.core.reduce.call(null,inst_30111,inst_30120,inst_30122);
var inst_30125 = (function (){var schema_flakes = inst_30106;
var vec__30090 = inst_30108;
var collection_flakes = inst_30109;
var predicate_flakes = inst_30110;
var coll = inst_30123;
return (function (p__30124,pred_flakes){
var vec__30153 = p__30124;
var pred = cljs.core.nth.call(null,vec__30153,(0),null);
var fullText = cljs.core.nth.call(null,vec__30153,(1),null);
var id = cljs.core.first.call(null,pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,cljs.core.get.call(null,p__GT_v,(24)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),cljs.core.get.call(null,p__GT_v,(20)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_30126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30127 = cljs.core.PersistentHashMap.EMPTY;
var inst_30128 = cljs.core.PersistentHashSet.EMPTY;
var inst_30129 = [inst_30127,inst_30128];
var inst_30130 = (new cljs.core.PersistentVector(null,2,(5),inst_30126,inst_30129,null));
var inst_30131 = (function (){var schema_flakes = inst_30106;
var vec__30090 = inst_30108;
var collection_flakes = inst_30109;
var predicate_flakes = inst_30110;
var coll = inst_30123;
return (function (p1__30083_SHARP_){
return p1__30083_SHARP_.s;
});
})();
var inst_30132 = cljs.core.partition_by.call(null,inst_30131,inst_30110);
var inst_30133 = cljs.core.reduce.call(null,inst_30125,inst_30130,inst_30132);
var inst_30134 = cljs.core.nth.call(null,inst_30133,(0),null);
var inst_30135 = cljs.core.nth.call(null,inst_30133,(1),null);
var inst_30136 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_30137 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_30138 = [inst_30137,inst_30123,inst_30134,inst_30135];
var inst_30139 = cljs.core.PersistentHashMap.fromArrays(inst_30136,inst_30138);
var _ = (function (){var statearr_30156 = state_30144;
(statearr_30156[(4)] = cljs.core.rest.call(null,(state_30144[(4)])));

return statearr_30156;
})();
var state_30144__$1 = state_30144;
var statearr_30157_30167 = state_30144__$1;
(statearr_30157_30167[(2)] = inst_30139);

(statearr_30157_30167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__11469__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__11469__auto____0 = (function (){
var statearr_30158 = [null,null,null,null,null,null,null];
(statearr_30158[(0)] = fluree$db$query$schema$schema_map_$_state_machine__11469__auto__);

(statearr_30158[(1)] = (1));

return statearr_30158;
});
var fluree$db$query$schema$schema_map_$_state_machine__11469__auto____1 = (function (state_30144){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_30144);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e30159){var ex__11472__auto__ = e30159;
var statearr_30160_30168 = state_30144;
(statearr_30160_30168[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_30144[(4)]))){
var statearr_30161_30169 = state_30144;
(statearr_30161_30169[(1)] = cljs.core.first.call(null,(state_30144[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30170 = state_30144;
state_30144 = G__30170;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__11469__auto__ = function(state_30144){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__11469__auto____1.call(this,state_30144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__11469__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__11469__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_30162 = f__11543__auto__.call(null);
(statearr_30162[(6)] = c__11542__auto__);

return statearr_30162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_30212){
var state_val_30213 = (state_30212[(1)]);
if((state_val_30213 === (7))){
var inst_30195 = (state_30212[(2)]);
var inst_30196 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_30195);
var inst_30197 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_30198 = cljs.core.get.call(null,inst_30196,(114));
var inst_30199 = cljs.core.boolean$.call(null,inst_30198);
var inst_30200 = cljs.core.get.call(null,inst_30196,(110));
var inst_30201 = cljs.core.get.call(null,inst_30196,(117));
var inst_30202 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_30201);
var inst_30203 = cljs.core.get.call(null,inst_30196,(111));
var inst_30204 = cljs.core.get.call(null,inst_30196,(115));
var inst_30205 = cljs.core.get.call(null,inst_30196,(112));
var inst_30206 = [inst_30199,inst_30200,inst_30202,inst_30203,inst_30204,inst_30205];
var inst_30207 = cljs.core.PersistentHashMap.fromArrays(inst_30197,inst_30206);
var _ = (function (){var statearr_30214 = state_30212;
(statearr_30214[(4)] = cljs.core.rest.call(null,(state_30212[(4)])));

return statearr_30214;
})();
var state_30212__$1 = state_30212;
var statearr_30215_30238 = state_30212__$1;
(statearr_30215_30238[(2)] = inst_30207);

(statearr_30215_30238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30213 === (1))){
var state_30212__$1 = state_30212;
var statearr_30216_30239 = state_30212__$1;
(statearr_30216_30239[(2)] = null);

(statearr_30216_30239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30213 === (4))){
var inst_30171 = (state_30212[(2)]);
var state_30212__$1 = state_30212;
var statearr_30217_30240 = state_30212__$1;
(statearr_30217_30240[(2)] = inst_30171);

(statearr_30217_30240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30213 === (6))){
var _ = (function (){var statearr_30218 = state_30212;
(statearr_30218[(4)] = cljs.core.cons.call(null,(9),(state_30212[(4)])));

return statearr_30218;
})();
var inst_30183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30185 = ["_setting/id","root"];
var inst_30186 = (new cljs.core.PersistentVector(null,2,(5),inst_30184,inst_30185,null));
var inst_30187 = [inst_30186];
var inst_30188 = (new cljs.core.PersistentVector(null,1,(5),inst_30183,inst_30187,null));
var inst_30189 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_30188);
var state_30212__$1 = state_30212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30212__$1,(10),inst_30189);
} else {
if((state_val_30213 === (3))){
var inst_30210 = (state_30212[(2)]);
var state_30212__$1 = state_30212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30212__$1,inst_30210);
} else {
if((state_val_30213 === (2))){
var _ = (function (){var statearr_30221 = state_30212;
(statearr_30221[(4)] = cljs.core.cons.call(null,(5),(state_30212[(4)])));

return statearr_30221;
})();
var state_30212__$1 = state_30212;
var statearr_30222_30241 = state_30212__$1;
(statearr_30222_30241[(2)] = null);

(statearr_30222_30241[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30213 === (9))){
var _ = (function (){var statearr_30223 = state_30212;
(statearr_30223[(4)] = cljs.core.rest.call(null,(state_30212[(4)])));

return statearr_30223;
})();
var state_30212__$1 = state_30212;
var ex30219 = (state_30212__$1[(2)]);
var statearr_30224_30242 = state_30212__$1;
(statearr_30224_30242[(5)] = ex30219);


var statearr_30225_30243 = state_30212__$1;
(statearr_30225_30243[(1)] = (8));

(statearr_30225_30243[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30213 === (5))){
var _ = (function (){var statearr_30226 = state_30212;
(statearr_30226[(4)] = cljs.core.rest.call(null,(state_30212[(4)])));

return statearr_30226;
})();
var state_30212__$1 = state_30212;
var ex30220 = (state_30212__$1[(2)]);
var statearr_30227_30244 = state_30212__$1;
(statearr_30227_30244[(5)] = ex30220);


if((ex30220 instanceof Error)){
var statearr_30228_30245 = state_30212__$1;
(statearr_30228_30245[(1)] = (4));

(statearr_30228_30245[(5)] = null);

} else {
throw ex30220;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30213 === (10))){
var inst_30191 = (state_30212[(2)]);
var inst_30192 = fluree.db.util.async.throw_err.call(null,inst_30191);
var _ = (function (){var statearr_30229 = state_30212;
(statearr_30229[(4)] = cljs.core.rest.call(null,(state_30212[(4)])));

return statearr_30229;
})();
var state_30212__$1 = state_30212;
var statearr_30230_30246 = state_30212__$1;
(statearr_30230_30246[(2)] = inst_30192);

(statearr_30230_30246[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30213 === (8))){
var inst_30177 = (state_30212[(2)]);
var state_30212__$1 = (function (){var statearr_30231 = state_30212;
(statearr_30231[(7)] = inst_30177);

return statearr_30231;
})();
var statearr_30232_30247 = state_30212__$1;
(statearr_30232_30247[(2)] = null);

(statearr_30232_30247[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__11469__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__11469__auto____0 = (function (){
var statearr_30233 = [null,null,null,null,null,null,null,null];
(statearr_30233[(0)] = fluree$db$query$schema$setting_map_$_state_machine__11469__auto__);

(statearr_30233[(1)] = (1));

return statearr_30233;
});
var fluree$db$query$schema$setting_map_$_state_machine__11469__auto____1 = (function (state_30212){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_30212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e30234){var ex__11472__auto__ = e30234;
var statearr_30235_30248 = state_30212;
(statearr_30235_30248[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_30212[(4)]))){
var statearr_30236_30249 = state_30212;
(statearr_30236_30249[(1)] = cljs.core.first.call(null,(state_30212[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30250 = state_30212;
state_30212 = G__30250;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__11469__auto__ = function(state_30212){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__11469__auto____1.call(this,state_30212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__11469__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__11469__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_30237 = f__11543__auto__.call(null);
(statearr_30237[(6)] = c__11542__auto__);

return statearr_30237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
