// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_22051){
var state_val_22052 = (state_22051[(1)]);
if((state_val_22052 === (7))){
var inst_22046 = (state_22051[(2)]);
var _ = (function (){var statearr_22053 = state_22051;
(statearr_22053[(4)] = cljs.core.rest.call(null,(state_22051[(4)])));

return statearr_22053;
})();
var state_22051__$1 = state_22051;
var statearr_22054_22076 = state_22051__$1;
(statearr_22054_22076[(2)] = inst_22046);

(statearr_22054_22076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22052 === (1))){
var state_22051__$1 = state_22051;
var statearr_22055_22077 = state_22051__$1;
(statearr_22055_22077[(2)] = null);

(statearr_22055_22077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22052 === (4))){
var inst_22008 = (state_22051[(2)]);
var state_22051__$1 = state_22051;
var statearr_22056_22078 = state_22051__$1;
(statearr_22056_22078[(2)] = inst_22008);

(statearr_22056_22078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22052 === (6))){
var inst_22033 = (state_22051[(7)]);
var inst_22026 = (state_22051[(8)]);
var inst_22032 = cljs.core.seq.call(null,inst_22026);
var inst_22033__$1 = cljs.core.first.call(null,inst_22032);
var inst_22034 = cljs.core.next.call(null,inst_22032);
var inst_22035 = cljs.core.not.call(null,inst_22033__$1);
var state_22051__$1 = (function (){var statearr_22057 = state_22051;
(statearr_22057[(7)] = inst_22033__$1);

(statearr_22057[(9)] = inst_22034);

return statearr_22057;
})();
if(inst_22035){
var statearr_22058_22079 = state_22051__$1;
(statearr_22058_22079[(1)] = (8));

} else {
var statearr_22059_22080 = state_22051__$1;
(statearr_22059_22080[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22052 === (3))){
var inst_22049 = (state_22051[(2)]);
var state_22051__$1 = state_22051;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22051__$1,inst_22049);
} else {
if((state_val_22052 === (2))){
var _ = (function (){var statearr_22060 = state_22051;
(statearr_22060[(4)] = cljs.core.cons.call(null,(5),(state_22051[(4)])));

return statearr_22060;
})();
var inst_22021 = chs;
var inst_22022 = cljs.core.seq.call(null,inst_22021);
var inst_22023 = cljs.core.first.call(null,inst_22022);
var inst_22024 = cljs.core.next.call(null,inst_22022);
var inst_22025 = coll;
var inst_22026 = inst_22021;
var inst_22027 = inst_22025;
var state_22051__$1 = (function (){var statearr_22061 = state_22051;
(statearr_22061[(10)] = inst_22023);

(statearr_22061[(8)] = inst_22026);

(statearr_22061[(11)] = inst_22024);

(statearr_22061[(12)] = inst_22027);

return statearr_22061;
})();
var statearr_22062_22081 = state_22051__$1;
(statearr_22062_22081[(2)] = null);

(statearr_22062_22081[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22052 === (11))){
var inst_22034 = (state_22051[(9)]);
var inst_22027 = (state_22051[(12)]);
var inst_22039 = (state_22051[(2)]);
var inst_22040 = fluree.db.util.async.throw_err.call(null,inst_22039);
var inst_22041 = cljs.core.conj.call(null,inst_22027,inst_22040);
var inst_22026 = inst_22034;
var inst_22027__$1 = inst_22041;
var state_22051__$1 = (function (){var statearr_22064 = state_22051;
(statearr_22064[(8)] = inst_22026);

(statearr_22064[(12)] = inst_22027__$1);

return statearr_22064;
})();
var statearr_22065_22082 = state_22051__$1;
(statearr_22065_22082[(2)] = null);

(statearr_22065_22082[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22052 === (9))){
var inst_22033 = (state_22051[(7)]);
var state_22051__$1 = state_22051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22051__$1,(11),inst_22033);
} else {
if((state_val_22052 === (5))){
var _ = (function (){var statearr_22066 = state_22051;
(statearr_22066[(4)] = cljs.core.rest.call(null,(state_22051[(4)])));

return statearr_22066;
})();
var state_22051__$1 = state_22051;
var ex22063 = (state_22051__$1[(2)]);
var statearr_22067_22083 = state_22051__$1;
(statearr_22067_22083[(5)] = ex22063);


var statearr_22068_22084 = state_22051__$1;
(statearr_22068_22084[(1)] = (4));

(statearr_22068_22084[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22052 === (10))){
var inst_22044 = (state_22051[(2)]);
var state_22051__$1 = state_22051;
var statearr_22069_22085 = state_22051__$1;
(statearr_22069_22085[(2)] = inst_22044);

(statearr_22069_22085[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22052 === (8))){
var inst_22027 = (state_22051[(12)]);
var state_22051__$1 = state_22051;
var statearr_22070_22086 = state_22051__$1;
(statearr_22070_22086[(2)] = inst_22027);

(statearr_22070_22086[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__11469__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__11469__auto____0 = (function (){
var statearr_22071 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22071[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__11469__auto__);

(statearr_22071[(1)] = (1));

return statearr_22071;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__11469__auto____1 = (function (state_22051){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_22051);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e22072){var ex__11472__auto__ = e22072;
var statearr_22073_22087 = state_22051;
(statearr_22073_22087[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_22051[(4)]))){
var statearr_22074_22088 = state_22051;
(statearr_22074_22088[(1)] = cljs.core.first.call(null,(state_22051[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22089 = state_22051;
state_22051 = G__22089;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__11469__auto__ = function(state_22051){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__11469__auto____1.call(this,state_22051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__11469__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__11469__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_22075 = f__11543__auto__.call(null);
(statearr_22075[(6)] = c__11542__auto__);

return statearr_22075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_22115){
var state_val_22116 = (state_22115[(1)]);
if((state_val_22116 === (7))){
var inst_22110 = (state_22115[(2)]);
var _ = (function (){var statearr_22117 = state_22115;
(statearr_22117[(4)] = cljs.core.rest.call(null,(state_22115[(4)])));

return statearr_22117;
})();
var state_22115__$1 = state_22115;
var statearr_22118_22140 = state_22115__$1;
(statearr_22118_22140[(2)] = inst_22110);

(statearr_22118_22140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (1))){
var state_22115__$1 = state_22115;
var statearr_22119_22141 = state_22115__$1;
(statearr_22119_22141[(2)] = null);

(statearr_22119_22141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (4))){
var inst_22090 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22120_22142 = state_22115__$1;
(statearr_22120_22142[(2)] = inst_22090);

(statearr_22120_22142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (6))){
var state_22115__$1 = state_22115;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22115__$1,(8),chan);
} else {
if((state_val_22116 === (3))){
var inst_22113 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22115__$1,inst_22113);
} else {
if((state_val_22116 === (2))){
var _ = (function (){var statearr_22121 = state_22115;
(statearr_22121[(4)] = cljs.core.cons.call(null,(5),(state_22115[(4)])));

return statearr_22121;
})();
var inst_22096 = coll;
var inst_22097 = inst_22096;
var state_22115__$1 = (function (){var statearr_22122 = state_22115;
(statearr_22122[(7)] = inst_22097);

return statearr_22122;
})();
var statearr_22123_22143 = state_22115__$1;
(statearr_22123_22143[(2)] = null);

(statearr_22123_22143[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (11))){
var inst_22108 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22125_22144 = state_22115__$1;
(statearr_22125_22144[(2)] = inst_22108);

(statearr_22125_22144[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (9))){
var inst_22097 = (state_22115[(7)]);
var state_22115__$1 = state_22115;
var statearr_22126_22145 = state_22115__$1;
(statearr_22126_22145[(2)] = inst_22097);

(statearr_22126_22145[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (5))){
var _ = (function (){var statearr_22127 = state_22115;
(statearr_22127[(4)] = cljs.core.rest.call(null,(state_22115[(4)])));

return statearr_22127;
})();
var state_22115__$1 = state_22115;
var ex22124 = (state_22115__$1[(2)]);
var statearr_22128_22146 = state_22115__$1;
(statearr_22128_22146[(5)] = ex22124);


var statearr_22129_22147 = state_22115__$1;
(statearr_22129_22147[(1)] = (4));

(statearr_22129_22147[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (10))){
var inst_22101 = (state_22115[(8)]);
var inst_22097 = (state_22115[(7)]);
var inst_22105 = cljs.core.conj.call(null,inst_22097,inst_22101);
var inst_22097__$1 = inst_22105;
var state_22115__$1 = (function (){var statearr_22130 = state_22115;
(statearr_22130[(7)] = inst_22097__$1);

return statearr_22130;
})();
var statearr_22131_22148 = state_22115__$1;
(statearr_22131_22148[(2)] = null);

(statearr_22131_22148[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (8))){
var inst_22101 = (state_22115[(8)]);
var inst_22100 = (state_22115[(2)]);
var inst_22101__$1 = fluree.db.util.async.throw_err.call(null,inst_22100);
var inst_22102 = (inst_22101__$1 == null);
var state_22115__$1 = (function (){var statearr_22132 = state_22115;
(statearr_22132[(8)] = inst_22101__$1);

return statearr_22132;
})();
if(cljs.core.truth_(inst_22102)){
var statearr_22133_22149 = state_22115__$1;
(statearr_22133_22149[(1)] = (9));

} else {
var statearr_22134_22150 = state_22115__$1;
(statearr_22134_22150[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__11469__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__11469__auto____0 = (function (){
var statearr_22135 = [null,null,null,null,null,null,null,null,null];
(statearr_22135[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__11469__auto__);

(statearr_22135[(1)] = (1));

return statearr_22135;
});
var fluree$db$util$async$into_QMARK__$_state_machine__11469__auto____1 = (function (state_22115){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_22115);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e22136){var ex__11472__auto__ = e22136;
var statearr_22137_22151 = state_22115;
(statearr_22137_22151[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_22115[(4)]))){
var statearr_22138_22152 = state_22115;
(statearr_22138_22152[(1)] = cljs.core.first.call(null,(state_22115[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22153 = state_22115;
state_22115 = G__22153;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__11469__auto__ = function(state_22115){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__11469__auto____1.call(this,state_22115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__11469__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__11469__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_22139 = f__11543__auto__.call(null);
(statearr_22139[(6)] = c__11542__auto__);

return statearr_22139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
