// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('flureenjs');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.auth');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.flake');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.operations');
goog.require('fluree.db.permissions');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.graphql_parser');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.sparql_parser');
goog.require('fluree.db.query.sql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('goog.string.format');
goog.require('cljs.nodejs');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.api_js');
goog.require('cljs.js');
goog.require('cljs.analyzer');
goog.require('cljs.env');
goog.require('cljs.compiler');
cljs.nodejs.enable_util_print_BANG_.call(null);
flureenjs.init_state = (function flureenjs$init_state(state){
return cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"rename-macros","rename-macros",1076432512),new cljs.core.Keyword(null,"renames","renames",343278368),new cljs.core.Keyword(null,"use-macros","use-macros",-905638393),new cljs.core.Keyword(null,"excludes","excludes",-1791725945),new cljs.core.Keyword(null,"macros","macros",811339431),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"imports","imports",-1249933394),new cljs.core.Keyword(null,"requires","requires",-1201390927),new cljs.core.Keyword("cljs.spec","speced-vars","cljs.spec/speced-vars",1010010387),new cljs.core.Keyword(null,"uses","uses",232664692),new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.Keyword("cljs.spec","registry-ref","cljs.spec/registry-ref",-71711915),new cljs.core.Keyword(null,"require-macros","require-macros",707947416),new cljs.core.Keyword("cljs.analyzer","constants","cljs.analyzer/constants",1697083770),new cljs.core.Keyword(null,"doc","doc",1913296891)],[cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 34, [new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"null",new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"null",new cljs.core.Symbol(null,"subs","subs",1453849536,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"dec","dec",-766002333,null),"null",new cljs.core.Symbol(null,"<","<",993667236,null),"null",new cljs.core.Symbol(null,"<=","<=",1244895369,null),"null",new cljs.core.Symbol(null,"*","*",345799209,null),"null",new cljs.core.Symbol(null,"min","min",2085523049,null),"null",new cljs.core.Symbol(null,"get","get",-971253014,null),"null",new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"null",new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"null",new cljs.core.Symbol(null,"not=","not=",1466536204,null),"null",new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"null",new cljs.core.Symbol(null,">",">",1085014381,null),"null",new cljs.core.Symbol(null,"mod","mod",1510044207,null),"null",new cljs.core.Symbol(null,"-","-",-471816912,null),"null",new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"null",new cljs.core.Symbol(null,"or","or",1876275696,null),"null",new cljs.core.Symbol(null,"rem","rem",664046770,null),"null",new cljs.core.Symbol(null,"nth","nth",1529209554,null),"null",new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"null",new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"null",new cljs.core.Symbol(null,"not","not",1044554643,null),"null",new cljs.core.Symbol(null,"/","/",-1371932971,null),"null",new cljs.core.Symbol(null,">=",">=",1016916022,null),"null",new cljs.core.Symbol(null,"inc","inc",324505433,null),"null",new cljs.core.Symbol(null,"+","+",-740910886,null),"null",new cljs.core.Symbol(null,"str","str",-1564826950,null),"null",new cljs.core.Symbol(null,"max","max",1701898075,null),"null",new cljs.core.Symbol(null,"==","==",-234118149,null),"null",new cljs.core.Symbol(null,"count","count",-514511684,null),"null",new cljs.core.Symbol(null,"and","and",668631710,null),"null",new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"null"], null), null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block.",new cljs.core.Keyword(null,"line","line",212345235),12,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null)], null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"log","log",45015523,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fdb","fdb",-1644172664,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"util","util",1147903249,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)],[new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.with_meta(new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Finds the maximum predicate value.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null))))], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(30)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"query","query",352022017,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Executes a query",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Fuel required for query"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the flakes from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerce to boolean. Everything except false and nil is true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Decrements any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the floor of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?o","?o",-1814741084,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the object of an predicate from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(1)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objF","objF",-104129083,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all false flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the ceiling of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"add-stack","add-stack",1221952039,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns product of all the numbers in the sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in *"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets min value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get","get",-971253014,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets a value from an subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the most recent object of an predicate, as of the previous block",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if empty or #{nil}, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Quot[ient] of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"now","now",-9994004,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns current epoch milliseconds on the executing machine.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if two (or more) values are not equal.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"raise","raise",1824672588,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates test.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Modulus of num and div. Truncates toward negative infinity.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string lower case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns difference of all the numbers in the sequence with the first number as the minuend.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in -"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a hash-set of values",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of items in hash-set"], null)))),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if any in the sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in or"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether an email is valid, based on its pattern",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"coerce-args","coerce-args",494321873,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?s","?s",456183954,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remainder of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nth","nth",1529209554,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the nth item in a collection",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in collection"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if nil, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cas","cas",1188988307,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Does a compare and set/swap operation as a transaction function.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(20)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Execute a re-find operation of regex pattern on provided string.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a boolean, true returns false, false returns true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string upper-case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Increments any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns sum of each argument.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in +"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenates all in sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objT","objT",1212205659,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all true flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets max value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if arguments in sequence equal each other.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in count"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Follows an subject down the provided path and returns a set of all matching subjects.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + length of path"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?p","?p",-10896580,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate predicates",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"stack","stack",847125597,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current auth _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current user _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether there is a relationship between two subjects",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if all in a sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in and"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))))], null))],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,777,null,777,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,777,null,new cljs.core.Symbol(null,"any","any",-948528346,null),777,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,7,521,null,521,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),null,cljs.core.list(null,null),1,false,521,null,new cljs.core.Symbol(null,"any","any",-948528346,null),521,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),347,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),347,new cljs.core.Keyword(null,"end-column","end-column",1425389514),16,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null))))], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,347,new cljs.core.Symbol(null,"any","any",-948528346,null),347,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null))))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,133,null,133,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,133,null,new cljs.core.Symbol(null,"any","any",-948528346,null),133,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,479,null,479,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),"Executes a query","Fuel required for query"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),null,6,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),479,null,479,6,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query","Fuel required for query"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,7,750,null,750,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,750,null,new cljs.core.Symbol(null,"any","any",-948528346,null),750,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,659,null,659,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),1,false,659,null,new cljs.core.Symbol(null,"any","any",-948528346,null),659,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,545,null,545,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,545,null,new cljs.core.Symbol(null,"any","any",-948528346,null),545,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,401,null,401,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),401,null,new cljs.core.Symbol(null,"any","any",-948528346,null),401,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,7,799,null,799,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,799,null,new cljs.core.Symbol(null,"any","any",-948528346,null),799,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,7,288,null,288,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,288,null,new cljs.core.Symbol(null,"any","any",-948528346,null),288,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,169,null,169,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,169,null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),169,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,738,null,738,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,738,null,new cljs.core.Symbol(null,"any","any",-948528346,null),738,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,787,null,787,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,787,null,new cljs.core.Symbol(null,"any","any",-948528346,null),787,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),39,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),39,new cljs.core.Keyword(null,"end-column","end-column",1425389514),17,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","add-stack","fluree.db.dbfunctions.fns/add-stack",-218303854,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null)),null,cljs.core.list(null,null),1,false,39,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),39,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),"Adds an entry to the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,414,null,414,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),414,null,new cljs.core.Symbol(null,"any","any",-948528346,null),414,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,594,null,594,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),594,null,new cljs.core.Symbol(null,"any","any",-948528346,null),594,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,466,null,466,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets min value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),466,null,new cljs.core.Symbol(null,"any","any",-948528346,null),466,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,270,null,270,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),null,cljs.core.list(null,null),1,false,270,null,new cljs.core.Symbol(null,"any","any",-948528346,null),270,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,300,null,300,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,300,null,new cljs.core.Symbol(null,"any","any",-948528346,null),300,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,7,109,null,109,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,109,null,new cljs.core.Symbol(null,"any","any",-948528346,null),109,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,620,null,620,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,620,null,new cljs.core.Symbol(null,"any","any",-948528346,null),620,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,558,null,558,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,558,null,new cljs.core.Symbol(null,"any","any",-948528346,null),558,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,440,null,440,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),440,null,new cljs.core.Symbol(null,"any","any",-948528346,null),440,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),50,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),50,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","raise","fluree.db.dbfunctions.fns/raise",-2030365545,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null)),null,cljs.core.list(null,null),1,false,50,new cljs.core.Symbol(null,"ignore","ignore",8989494,null),50,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),"Throws an exception with the provided message."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,73,null,73,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),null,cljs.core.list(null,null),1,false,73,null,new cljs.core.Symbol(null,"any","any",-948528346,null),73,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,762,null,762,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),null,3,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),762,null,762,3,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,388,null,388,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),388,null,new cljs.core.Symbol(null,"any","any",-948528346,null),388,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,633,null,633,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,633,null,new cljs.core.Symbol(null,"any","any",-948528346,null),633,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,7,145,null,145,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,145,null,new cljs.core.Symbol(null,"any","any",-948528346,null),145,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,581,null,581,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),581,null,new cljs.core.Symbol(null,"any","any",-948528346,null),581,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),361,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),361,new cljs.core.Keyword(null,"end-column","end-column",1425389514),15,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a hash-set of values",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of items in hash-set"], null)))),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),361,new cljs.core.Symbol(null,"any","any",-948528346,null),361,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,243,null,243,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),243,null,new cljs.core.Symbol(null,"any","any",-948528346,null),243,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,7,684,null,684,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),null,cljs.core.list(null,null),1,false,684,null,new cljs.core.Symbol(null,"any","any",-948528346,null),684,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),20,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),20,new cljs.core.Keyword(null,"end-column","end-column",1425389514),19,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","coerce-args","fluree.db.dbfunctions.fns/coerce-args",1196396954,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,20,new cljs.core.Symbol(null,"any","any",-948528346,null),20,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,201,null,201,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),201,null,201,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,646,null,646,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,646,null,new cljs.core.Symbol(null,"any","any",-948528346,null),646,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,58,null,58,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,58,null,new cljs.core.Symbol(null,"any","any",-948528346,null),58,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,86,null,86,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,86,null,new cljs.core.Symbol(null,"any","any",-948528346,null),86,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,811,null,811,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),null,cljs.core.list(null,null),1,false,811,null,new cljs.core.Symbol(null,"any","any",-948528346,null),811,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,671,null,671,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),null,cljs.core.list(null,null),1,false,671,null,new cljs.core.Symbol(null,"any","any",-948528346,null),671,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,98,null,98,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,98,null,new cljs.core.Symbol(null,"any","any",-948528346,null),98,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword(null,"file","file",-1269645878),null], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),607,null,new cljs.core.Symbol(null,"any","any",-948528346,null),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence","9 + count of numbers in /"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,427,null,427,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),427,null,new cljs.core.Symbol(null,"any","any",-948528346,null),427,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,7,157,null,157,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,157,null,new cljs.core.Symbol(null,"any","any",-948528346,null),157,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,533,null,533,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,533,null,new cljs.core.Symbol(null,"any","any",-948528346,null),533,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,568,null,568,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns sum of each argument.","9 + count of numbers in +"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),568,null,new cljs.core.Symbol(null,"any","any",-948528346,null),568,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.","9 + count of numbers in +"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,121,null,121,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Concatenates all in sequence.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),121,null,new cljs.core.Symbol(null,"any","any",-948528346,null),121,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,726,null,726,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,726,null,new cljs.core.Symbol(null,"any","any",-948528346,null),726,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,453,null,453,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets max value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),453,null,new cljs.core.Symbol(null,"any","any",-948528346,null),453,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,375,null,375,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),375,null,new cljs.core.Symbol(null,"any","any",-948528346,null),375,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,7,256,null,256,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),1,false,256,null,new cljs.core.Symbol(null,"any","any",-948528346,null),256,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,313,null,313,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Follows an subject down the provided path and returns a set of all matching subjects.","9 + length of path"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,313,null,new cljs.core.Symbol(null,"any","any",-948528346,null),313,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Follows an subject down the provided path and returns a set of all matching subjects.","9 + length of path"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,214,null,214,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),214,null,214,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),33,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),33,new cljs.core.Keyword(null,"end-column","end-column",1425389514),12,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","stack","fluree.db.dbfunctions.fns/stack",-729322264,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,33,new cljs.core.Symbol(null,"any","any",-948528346,null),33,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,7,714,null,714,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,714,null,new cljs.core.Symbol(null,"any","any",-948528346,null),714,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),12,new cljs.core.Keyword(null,"column","column",2078222095),11,new cljs.core.Keyword(null,"end-line","end-line",1837326455),12,new cljs.core.Keyword(null,"end-column","end-column",1425389514),18,new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",18,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&form","&form",1482799337,null),new cljs.core.Symbol(null,"&env","&env",-919163083,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),1,false,12,true,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),"null",new cljs.core.Symbol("cljs.core","IList","cljs.core/IList",1015168964,null),"null"], null), null),12,3,false,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"Resolves a value if a channel.\n  Must be used inside of a go-block."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,7,696,null,696,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,696,null,new cljs.core.Symbol(null,"any","any",-948528346,null),696,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,7,506,null,506,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),null,cljs.core.list(null,null),1,false,506,null,new cljs.core.Symbol(null,"any","any",-948528346,null),506,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,230,null,230,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),230,null,new cljs.core.Symbol(null,"any","any",-948528346,null),230,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,188,null,188,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,188,null,new cljs.core.Symbol(null,"any","any",-948528346,null),188,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),332,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),332,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))))], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,332,new cljs.core.Symbol(null,"any","any",-948528346,null),332,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))))])]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"seen","seen",-518999789),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 25, [new cljs.core.Keyword(null,"_id","_id",-789960287),"null",new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),"null",new cljs.core.Keyword(null,"o","o",-1350007228),"null",new cljs.core.Keyword(null,"spent","spent",-62769180),"null",new cljs.core.Keyword(null,"instant","instant",655498374),"null",new cljs.core.Keyword(null,"else","else",-1508377146),"null",new cljs.core.Keyword(null,"db","db",993250759),"null",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"null",new cljs.core.Keyword(null,"recur","recur",-437573268),"null",new cljs.core.Keyword(null,"state","state",-1988618099),"null",new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),"null",new cljs.core.Symbol(null,"if","if",1181717262,null),"null",new cljs.core.Keyword(null,"s","s",1705939918),"null",new cljs.core.Keyword(null,"function","function",-2127255473),"null",new cljs.core.Keyword(null,"pid","pid",1018387698),"null",new cljs.core.Keyword(null,"status","status",-1997798413),"null",new cljs.core.Keyword(null,"result","result",1415092211),"null",new cljs.core.Keyword(null,"credits","credits",785860820),"null",new cljs.core.Keyword(null,"stack","stack",-793405930),"null",new cljs.core.Keyword(null,"user_id","user_id",993497112),"null",new cljs.core.Keyword(null,"error","error",-978969032),"null",new cljs.core.Keyword(null,"flakes","flakes",1977895739),"null",new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),"null",new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),"null",new cljs.core.Keyword(null,"sid","sid",1815016414),"null"], null), null),new cljs.core.Keyword(null,"order","order",-1254677256),new cljs.core.PersistentVector(null, 25, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),new cljs.core.Keyword(null,"recur","recur",-437573268),new cljs.core.Keyword(null,"else","else",-1508377146),new cljs.core.Keyword(null,"stack","stack",-793405930),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"credits","credits",785860820),new cljs.core.Keyword(null,"spent","spent",-62769180),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"o","o",-1350007228),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"user_id","user_id",993497112),new cljs.core.Keyword(null,"flakes","flakes",1977895739)], null)], null),null]));
});
flureenjs.nj_state = cljs.js.empty_state.call(null,flureenjs.init_state);
var st_81879 = flureenjs.nj_state;
(cljs.core._STAR_eval_STAR_ = (function (form){
var result = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"result","result",1415092211),null], null));
var form_str = ((typeof form === 'string')?form:cljs.core.str.cljs$core$IFn$_invoke$arity$1(form));
var name = "rtm";
var opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"eval","eval",-1103567905),cljs.js.js_eval,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.find_ns.call(null,cljs.analyzer._STAR_cljs_ns_STAR_),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"nodejs","nodejs",321212524)], null);
var cb = (function (res){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res))){
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res));
} else {
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(res));
}
});
cljs.js.eval_str.call(null,st_81879,form_str,name,opts,cb);

return new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,result));
}));
if((typeof flureenjs !== 'undefined') && (typeof flureenjs.app_state !== 'undefined')){
} else {
flureenjs.app_state = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"Fluree NodeJs Library",new cljs.core.Keyword(null,"version","version",425292698),"v1.0.0-rc5"], null));
}
cljs.core.println.call(null,new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs.app_state)));
fluree.db.util.log.set_level_BANG_.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureenjs.set_logging = (function flureenjs$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var map__81880 = opts_SINGLEQUOTE_;
var map__81880__$1 = (((((!((map__81880 == null))))?(((((map__81880.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__81880.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__81880):map__81880);
var level = cljs.core.get.call(null,map__81880__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_.call(null,cljs.core.keyword.call(null,level));
});
goog.exportSymbol('flureenjs.set_logging', flureenjs.set_logging);
/**
 * Returns account id from either a public key or message and signature.
 */
flureenjs.account_id = (function flureenjs$account_id(var_args){
var G__81883 = arguments.length;
switch (G__81883) {
case 1:
return flureenjs.account_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureenjs.account_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.account_id', flureenjs.account_id);

(flureenjs.account_id.cljs$core$IFn$_invoke$arity$1 = (function (public_key){
return fluree.crypto.account_id_from_public.call(null,public_key);
}));

(flureenjs.account_id.cljs$core$IFn$_invoke$arity$2 = (function (message,signature){
return fluree.crypto.account_id_from_message.call(null,message,signature);
}));

(flureenjs.account_id.cljs$lang$maxFixedArity = 2);

/**
 * Takes an http request and creates an http signature using a private key
 */
flureenjs.http_signature = (function flureenjs$http_signature(var_args){
var G__81886 = arguments.length;
switch (G__81886) {
case 4:
return flureenjs.http_signature.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.http_signature.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.http_signature', flureenjs.http_signature);

(flureenjs.http_signature.cljs$core$IFn$_invoke$arity$4 = (function (req_method,url,request,private_key){
return flureenjs.http_signature.call(null,req_method,url,request,private_key,null);
}));

(flureenjs.http_signature.cljs$core$IFn$_invoke$arity$5 = (function (req_method,url,request,private_key,auth){
var request__$1 = cljs.core.js__GT_clj.call(null,request);
return fluree.db.query.http_signatures.sign_request.call(null,req_method,url,request__$1,private_key,auth);
}));

(flureenjs.http_signature.cljs$lang$maxFixedArity = 5);

/**
 * Returns a public key given a private key.
 */
flureenjs.public_key_from_private = (function flureenjs$public_key_from_private(private_key){
return fluree.crypto.pub_key_from_private.call(null,private_key);
});
goog.exportSymbol('flureenjs.public_key_from_private', flureenjs.public_key_from_private);
/**
 * Returns a public key from a message and a signature.
 */
flureenjs.public_key = (function flureenjs$public_key(message,signature){
return fluree.crypto.pub_key_from_message.call(null,message,signature);
});
goog.exportSymbol('flureenjs.public_key', flureenjs.public_key);
/**
 * Returns a signature for a message given provided private key.
 */
flureenjs.sign = (function flureenjs$sign(message,private_key){
return fluree.crypto.sign_message.call(null,message,private_key);
});
goog.exportSymbol('flureenjs.sign', flureenjs.sign);
/**
 * Sets a new default private key for the entire tx-group, network or db level.
 *   This will only succeed if signed by the default private key for the tx-group,
 *   or if setting for a dbid, either the tx-group or network.
 * 
 *   It will overwrite any existing default private key.
 * 
 *   It will respond with true or false.
 * 
 *   Returns promise that eventually contains the results. 
 */
flureenjs.set_default_key = (function flureenjs$set_default_key(var_args){
var G__81889 = arguments.length;
switch (G__81889) {
case 2:
return flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.set_default_key', flureenjs.set_default_key);

(flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$2 = (function (conn,private_key){
return flureenjs.set_default_key.call(null,conn,null,null,private_key,null);
}));

(flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$3 = (function (conn,network,private_key){
return flureenjs.set_default_key.call(null,conn,network,null,private_key,null);
}));

(flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,private_key){
return flureenjs.set_default_key.call(null,conn,network,dbid,private_key,null);
}));

(flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,private_key,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_81965){
var state_val_81966 = (state_81965[(1)]);
if((state_val_81966 === (7))){
var state_81965__$1 = state_81965;
var statearr_81967_82021 = state_81965__$1;
(statearr_81967_82021[(2)] = false);

(statearr_81967_82021[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (20))){
var inst_81928 = (state_81965[(7)]);
var inst_81923 = (state_81965[(8)]);
var inst_81933 = (state_81965[(2)]);
var inst_81934 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"private-key","private-key",426483388),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_81935 = [new cljs.core.Keyword(null,"default-key","default-key",-2094960617),network,dbid,private_key,inst_81928,inst_81933];
var inst_81936 = cljs.core.PersistentHashMap.fromArrays(inst_81934,inst_81935);
var state_81965__$1 = (function (){var statearr_81968 = state_81965;
(statearr_81968[(9)] = inst_81936);

return statearr_81968;
})();
if(cljs.core.truth_(inst_81923)){
var statearr_81969_82022 = state_81965__$1;
(statearr_81969_82022[(1)] = (21));

} else {
var statearr_81970_82023 = state_81965__$1;
(statearr_81970_82023[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (27))){
var inst_81958 = (state_81965[(2)]);
var inst_81959 = cljs.core.clj__GT_js.call(null,inst_81958);
var inst_81960 = resolve.call(null,inst_81959);
var _ = (function (){var statearr_81971 = state_81965;
(statearr_81971[(4)] = cljs.core.rest.call(null,(state_81965[(4)])));

return statearr_81971;
})();
var state_81965__$1 = state_81965;
var statearr_81972_82024 = state_81965__$1;
(statearr_81972_82024[(2)] = inst_81960);

(statearr_81972_82024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (1))){
var state_81965__$1 = state_81965;
var statearr_81973_82025 = state_81965__$1;
(statearr_81973_82025[(2)] = null);

(statearr_81973_82025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (24))){
var inst_81942 = (state_81965[(10)]);
var inst_81923 = (state_81965[(8)]);
var inst_81944 = fluree.crypto.sign_message.call(null,inst_81942,inst_81923);
var state_81965__$1 = state_81965;
var statearr_81974_82026 = state_81965__$1;
(statearr_81974_82026[(2)] = inst_81944);

(statearr_81974_82026[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (4))){
var inst_81890 = (state_81965[(2)]);
var inst_81891 = fluree.db.util.log.error.call(null,inst_81890);
var inst_81892 = reject.call(null,inst_81890);
var state_81965__$1 = (function (){var statearr_81975 = state_81965;
(statearr_81975[(11)] = inst_81891);

return statearr_81975;
})();
var statearr_81976_82027 = state_81965__$1;
(statearr_81976_82027[(2)] = inst_81892);

(statearr_81976_82027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (15))){
var inst_81921 = (state_81965[(12)]);
var state_81965__$1 = state_81965;
var statearr_81977_82028 = state_81965__$1;
(statearr_81977_82028[(2)] = inst_81921);

(statearr_81977_82028[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (21))){
var inst_81936 = (state_81965[(9)]);
var inst_81938 = fluree.db.util.core.without_nils.call(null,inst_81936);
var inst_81939 = fluree.db.util.json.stringify.call(null,inst_81938);
var state_81965__$1 = state_81965;
var statearr_81978_82029 = state_81965__$1;
(statearr_81978_82029[(2)] = inst_81939);

(statearr_81978_82029[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (13))){
var inst_81899 = (state_81965[(13)]);
var state_81965__$1 = state_81965;
var statearr_81979_82030 = state_81965__$1;
(statearr_81979_82030[(2)] = inst_81899);

(statearr_81979_82030[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (22))){
var state_81965__$1 = state_81965;
var statearr_81980_82031 = state_81965__$1;
(statearr_81980_82031[(2)] = null);

(statearr_81980_82031[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (29))){
var inst_81936 = (state_81965[(9)]);
var inst_81954 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_81936);
var state_81965__$1 = state_81965;
var statearr_81981_82032 = state_81965__$1;
(statearr_81981_82032[(2)] = inst_81954);

(statearr_81981_82032[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (6))){
var inst_81899 = (state_81965[(13)]);
var inst_81904 = inst_81899.cljs$lang$protocol_mask$partition0$;
var inst_81905 = (inst_81904 & (64));
var inst_81906 = inst_81899.cljs$core$ISeq$;
var inst_81907 = (cljs.core.PROTOCOL_SENTINEL === inst_81906);
var inst_81908 = ((inst_81905) || (inst_81907));
var state_81965__$1 = state_81965;
if(cljs.core.truth_(inst_81908)){
var statearr_81982_82033 = state_81965__$1;
(statearr_81982_82033[(1)] = (9));

} else {
var statearr_81983_82034 = state_81965__$1;
(statearr_81983_82034[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (28))){
var inst_81942 = (state_81965[(10)]);
var inst_81947 = (state_81965[(14)]);
var inst_81949 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_81950 = [inst_81942,inst_81947];
var inst_81951 = cljs.core.PersistentHashMap.fromArrays(inst_81949,inst_81950);
var inst_81952 = fluree.db.operations.command_async.call(null,conn,inst_81951);
var state_81965__$1 = state_81965;
var statearr_81984_82035 = state_81965__$1;
(statearr_81984_82035[(2)] = inst_81952);

(statearr_81984_82035[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (25))){
var state_81965__$1 = state_81965;
var statearr_81985_82036 = state_81965__$1;
(statearr_81985_82036[(2)] = null);

(statearr_81985_82036[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (17))){
var inst_81922 = (state_81965[(15)]);
var inst_81928 = (state_81965[(2)]);
var state_81965__$1 = (function (){var statearr_81986 = state_81965;
(statearr_81986[(7)] = inst_81928);

return statearr_81986;
})();
if(cljs.core.truth_(inst_81922)){
var statearr_81987_82037 = state_81965__$1;
(statearr_81987_82037[(1)] = (18));

} else {
var statearr_81988_82038 = state_81965__$1;
(statearr_81988_82038[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (3))){
var inst_81963 = (state_81965[(2)]);
var state_81965__$1 = state_81965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81965__$1,inst_81963);
} else {
if((state_val_81966 === (12))){
var inst_81899 = (state_81965[(13)]);
var inst_81917 = cljs.core.apply.call(null,cljs.core.hash_map,inst_81899);
var state_81965__$1 = state_81965;
var statearr_81989_82039 = state_81965__$1;
(statearr_81989_82039[(2)] = inst_81917);

(statearr_81989_82039[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (2))){
var inst_81899 = (state_81965[(13)]);
var _ = (function (){var statearr_81990 = state_81965;
(statearr_81990[(4)] = cljs.core.cons.call(null,(5),(state_81965[(4)])));

return statearr_81990;
})();
var inst_81899__$1 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_81901 = (inst_81899__$1 == null);
var inst_81902 = cljs.core.not.call(null,inst_81901);
var state_81965__$1 = (function (){var statearr_81991 = state_81965;
(statearr_81991[(13)] = inst_81899__$1);

return statearr_81991;
})();
if(inst_81902){
var statearr_81992_82040 = state_81965__$1;
(statearr_81992_82040[(1)] = (6));

} else {
var statearr_81993_82041 = state_81965__$1;
(statearr_81993_82041[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (23))){
var inst_81923 = (state_81965[(8)]);
var inst_81942 = (state_81965[(2)]);
var state_81965__$1 = (function (){var statearr_81994 = state_81965;
(statearr_81994[(10)] = inst_81942);

return statearr_81994;
})();
if(cljs.core.truth_(inst_81923)){
var statearr_81995_82042 = state_81965__$1;
(statearr_81995_82042[(1)] = (24));

} else {
var statearr_81996_82043 = state_81965__$1;
(statearr_81996_82043[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (19))){
var inst_81924 = (state_81965[(16)]);
var inst_81931 = (inst_81924 + (30000));
var state_81965__$1 = state_81965;
var statearr_81997_82044 = state_81965__$1;
(statearr_81997_82044[(2)] = inst_81931);

(statearr_81997_82044[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (11))){
var inst_81912 = (state_81965[(2)]);
var state_81965__$1 = state_81965;
var statearr_81999_82045 = state_81965__$1;
(statearr_81999_82045[(2)] = inst_81912);

(statearr_81999_82045[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (9))){
var state_81965__$1 = state_81965;
var statearr_82000_82046 = state_81965__$1;
(statearr_82000_82046[(2)] = true);

(statearr_82000_82046[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (5))){
var _ = (function (){var statearr_82001 = state_81965;
(statearr_82001[(4)] = cljs.core.rest.call(null,(state_81965[(4)])));

return statearr_82001;
})();
var state_81965__$1 = state_81965;
var ex81998 = (state_81965__$1[(2)]);
var statearr_82002_82047 = state_81965__$1;
(statearr_82002_82047[(5)] = ex81998);


var statearr_82003_82048 = state_81965__$1;
(statearr_82003_82048[(1)] = (4));

(statearr_82003_82048[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (14))){
var inst_81921 = (state_81965[(12)]);
var inst_81920 = (state_81965[(2)]);
var inst_81921__$1 = cljs.core.get.call(null,inst_81920,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_81922 = cljs.core.get.call(null,inst_81920,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_81923 = cljs.core.get.call(null,inst_81920,new cljs.core.Keyword(null,"signing-key","signing-key",1285642632));
var inst_81924 = fluree.db.util.core.current_time_millis.call(null);
var state_81965__$1 = (function (){var statearr_82004 = state_81965;
(statearr_82004[(16)] = inst_81924);

(statearr_82004[(15)] = inst_81922);

(statearr_82004[(12)] = inst_81921__$1);

(statearr_82004[(8)] = inst_81923);

return statearr_82004;
})();
if(cljs.core.truth_(inst_81921__$1)){
var statearr_82005_82049 = state_81965__$1;
(statearr_82005_82049[(1)] = (15));

} else {
var statearr_82006_82050 = state_81965__$1;
(statearr_82006_82050[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (26))){
var inst_81923 = (state_81965[(8)]);
var inst_81947 = (state_81965[(2)]);
var state_81965__$1 = (function (){var statearr_82007 = state_81965;
(statearr_82007[(14)] = inst_81947);

return statearr_82007;
})();
if(cljs.core.truth_(inst_81923)){
var statearr_82008_82051 = state_81965__$1;
(statearr_82008_82051[(1)] = (28));

} else {
var statearr_82009_82052 = state_81965__$1;
(statearr_82009_82052[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (16))){
var inst_81924 = (state_81965[(16)]);
var state_81965__$1 = state_81965;
var statearr_82010_82053 = state_81965__$1;
(statearr_82010_82053[(2)] = inst_81924);

(statearr_82010_82053[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (30))){
var inst_81956 = (state_81965[(2)]);
var state_81965__$1 = state_81965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81965__$1,(27),inst_81956);
} else {
if((state_val_81966 === (10))){
var state_81965__$1 = state_81965;
var statearr_82011_82054 = state_81965__$1;
(statearr_82011_82054[(2)] = false);

(statearr_82011_82054[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (18))){
var inst_81922 = (state_81965[(15)]);
var state_81965__$1 = state_81965;
var statearr_82012_82055 = state_81965__$1;
(statearr_82012_82055[(2)] = inst_81922);

(statearr_82012_82055[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81966 === (8))){
var inst_81915 = (state_81965[(2)]);
var state_81965__$1 = state_81965;
if(cljs.core.truth_(inst_81915)){
var statearr_82013_82056 = state_81965__$1;
(statearr_82013_82056[(1)] = (12));

} else {
var statearr_82014_82057 = state_81965__$1;
(statearr_82014_82057[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_82015 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82015[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_82015[(1)] = (1));

return statearr_82015;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_81965){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_81965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e82016){var ex__11472__auto__ = e82016;
var statearr_82017_82058 = state_81965;
(statearr_82017_82058[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_81965[(4)]))){
var statearr_82018_82059 = state_81965;
(statearr_82018_82059[(1)] = cljs.core.first.call(null,(state_81965[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82060 = state_81965;
state_81965 = G__82060;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_81965){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_81965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_82019 = f__11543__auto__.call(null);
(statearr_82019[(6)] = c__11542__auto__);

return statearr_82019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.set_default_key.cljs$lang$maxFixedArity = 5);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureenjs.connect = (function flureenjs$connect(var_args){
var args__4742__auto__ = [];
var len__4736__auto___82067 = arguments.length;
var i__4737__auto___82068 = (0);
while(true){
if((i__4737__auto___82068 < len__4736__auto___82067)){
args__4742__auto__.push((arguments[i__4737__auto___82068]));

var G__82069 = (i__4737__auto___82068 + (1));
i__4737__auto___82068 = G__82069;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});
goog.exportSymbol('flureenjs.connect', flureenjs.connect);

(flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers_string,p__82063){
var vec__82064 = p__82063;
var opts = cljs.core.nth.call(null,vec__82064,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect.call(null,servers_string,clj_opts);
}));

(flureenjs.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(flureenjs.connect.cljs$lang$applyTo = (function (seq82061){
var G__82062 = cljs.core.first.call(null,seq82061);
var seq82061__$1 = cljs.core.next.call(null,seq82061);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82062,seq82061__$1);
}));

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * Returns a promise that eventually contains the connection object.
 */
flureenjs.connect_p = (function flureenjs$connect_p(var_args){
var args__4742__auto__ = [];
var len__4736__auto___82076 = arguments.length;
var i__4737__auto___82077 = (0);
while(true){
if((i__4737__auto___82077 < len__4736__auto___82076)){
args__4742__auto__.push((arguments[i__4737__auto___82077]));

var G__82078 = (i__4737__auto___82077 + (1));
i__4737__auto___82077 = G__82078;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return flureenjs.connect_p.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});
goog.exportSymbol('flureenjs.connect_p', flureenjs.connect_p);

(flureenjs.connect_p.cljs$core$IFn$_invoke$arity$variadic = (function (servers_string,p__82072){
var vec__82073 = p__82072;
var opts = cljs.core.nth.call(null,vec__82073,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect_p.call(null,servers_string,clj_opts);
}));

(flureenjs.connect_p.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(flureenjs.connect_p.cljs$lang$applyTo = (function (seq82070){
var G__82071 = cljs.core.first.call(null,seq82070);
var seq82070__$1 = cljs.core.next.call(null,seq82070);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82071,seq82070__$1);
}));

/**
 * Closes a connection
 */
flureenjs.close = (function flureenjs$close(conn){
return fluree.db.connection_js.close.call(null,conn);
});
goog.exportSymbol('flureenjs.close', flureenjs.close);
/**
 * Attempts to generate a new user auth record account.
 * 
 *   Returns a promise that eventually contains the token or an exception.
 */
flureenjs.password_generate = (function flureenjs$password_generate(var_args){
var G__82080 = arguments.length;
switch (G__82080) {
case 4:
return flureenjs.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.password_generate', flureenjs.password_generate);

(flureenjs.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureenjs.password_generate.call(null,conn,ledger,password,user,null);
}));

(flureenjs.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var data = cljs.core.assoc.call(null,cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true),new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate.call(null,conn,ledger,password,data);
}));

(flureenjs.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 * 
 *   Returns a promise that eventually contains the token or an exception.
 */
flureenjs.password_login = (function flureenjs$password_login(var_args){
var G__82083 = arguments.length;
switch (G__82083) {
case 4:
return flureenjs.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureenjs.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.password_login', flureenjs.password_login);

(flureenjs.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user);
}));

(flureenjs.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,auth,expire);
}));

(flureenjs.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureenjs.renew_token = (function flureenjs$renew_token(var_args){
var G__82086 = arguments.length;
switch (G__82086) {
case 2:
return flureenjs.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.renew_token', flureenjs.renew_token);

(flureenjs.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(flureenjs.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,expire);
}));

(flureenjs.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Takes block event data from (listen...) and adds an :added and
 *   :retracted key containing maps of data organized by subject
 *   and containing full predicate names.
 */
flureenjs.block_event__GT_map = (function flureenjs$block_event__GT_map(conn,ledger,block_event){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_82137){
var state_val_82138 = (state_82137[(1)]);
if((state_val_82138 === (7))){
var inst_82104 = (state_82137[(7)]);
var inst_82109 = inst_82104.cljs$lang$protocol_mask$partition0$;
var inst_82110 = (inst_82109 & (64));
var inst_82111 = inst_82104.cljs$core$ISeq$;
var inst_82112 = (cljs.core.PROTOCOL_SENTINEL === inst_82111);
var inst_82113 = ((inst_82110) || (inst_82112));
var state_82137__$1 = state_82137;
if(cljs.core.truth_(inst_82113)){
var statearr_82139_82167 = state_82137__$1;
(statearr_82139_82167[(1)] = (10));

} else {
var statearr_82140_82168 = state_82137__$1;
(statearr_82140_82168[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82138 === (1))){
var state_82137__$1 = state_82137;
var statearr_82141_82169 = state_82137__$1;
(statearr_82141_82169[(2)] = null);

(statearr_82141_82169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82138 === (4))){
var inst_82089 = (state_82137[(2)]);
var inst_82090 = fluree.db.util.log.error.call(null,inst_82089);
var inst_82091 = reject.call(null,inst_82089);
var state_82137__$1 = (function (){var statearr_82142 = state_82137;
(statearr_82142[(8)] = inst_82090);

return statearr_82142;
})();
var statearr_82143_82170 = state_82137__$1;
(statearr_82143_82170[(2)] = inst_82091);

(statearr_82143_82170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82138 === (15))){
var inst_82101 = (state_82137[(9)]);
var inst_82125 = (state_82137[(2)]);
var inst_82126 = cljs.core.get.call(null,inst_82125,true);
var inst_82127 = cljs.core.get.call(null,inst_82125,false);
var inst_82128 = (function (){var db = inst_82101;
var map__82097 = inst_82125;
var add = inst_82126;
var retract = inst_82127;
return (function (flakes){
var by_subj = cljs.core.group_by.call(null,cljs.core.first,flakes);
return cljs.core.reduce_kv.call(null,(function (acc,sid,flakes__$1){
return cljs.core.conj.call(null,acc,cljs.core.reduce.call(null,(function (m,flake){
var p_schema = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"pred","pred",1927423397),cljs.core.second.call(null,flake)], null));
var v = cljs.core.nth.call(null,flake,(2));
if(cljs.core.truth_(new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(p_schema))){
return cljs.core.update.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),cljs.core.conj,v);
} else {
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),v);
}
}),new cljs.core.PersistentArrayMap(null, 1, ["_id",sid], null),flakes__$1));
}),cljs.core.PersistentVector.EMPTY,by_subj);
});
})();
var inst_82129 = inst_82128.call(null,inst_82126);
var inst_82130 = inst_82128.call(null,inst_82127);
var inst_82131 = cljs.core.assoc.call(null,block_event,new cljs.core.Keyword(null,"added","added",2057651688),inst_82129,new cljs.core.Keyword(null,"retracted","retracted",-1399687854),inst_82130);
var inst_82132 = resolve.call(null,inst_82131);
var _ = (function (){var statearr_82144 = state_82137;
(statearr_82144[(4)] = cljs.core.rest.call(null,(state_82137[(4)])));

return statearr_82144;
})();
var state_82137__$1 = state_82137;
var statearr_82145_82171 = state_82137__$1;
(statearr_82145_82171[(2)] = inst_82132);

(statearr_82145_82171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82138 === (13))){
var inst_82104 = (state_82137[(7)]);
var inst_82122 = cljs.core.apply.call(null,cljs.core.hash_map,inst_82104);
var state_82137__$1 = state_82137;
var statearr_82146_82172 = state_82137__$1;
(statearr_82146_82172[(2)] = inst_82122);

(statearr_82146_82172[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82138 === (6))){
var inst_82101 = (state_82137[(9)]);
var inst_82104 = (state_82137[(7)]);
var inst_82100 = (state_82137[(2)]);
var inst_82101__$1 = fluree.db.util.async.throw_err.call(null,inst_82100);
var inst_82102 = (function (){var db = inst_82101__$1;
return (function (p1__82088_SHARP_){
return cljs.core.nth.call(null,p1__82088_SHARP_,(4));
});
})();
var inst_82103 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block_event);
var inst_82104__$1 = cljs.core.group_by.call(null,inst_82102,inst_82103);
var inst_82106 = (inst_82104__$1 == null);
var inst_82107 = cljs.core.not.call(null,inst_82106);
var state_82137__$1 = (function (){var statearr_82147 = state_82137;
(statearr_82147[(9)] = inst_82101__$1);

(statearr_82147[(7)] = inst_82104__$1);

return statearr_82147;
})();
if(inst_82107){
var statearr_82148_82173 = state_82137__$1;
(statearr_82148_82173[(1)] = (7));

} else {
var statearr_82149_82174 = state_82137__$1;
(statearr_82149_82174[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82138 === (3))){
var inst_82135 = (state_82137[(2)]);
var state_82137__$1 = state_82137;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82137__$1,inst_82135);
} else {
if((state_val_82138 === (12))){
var inst_82117 = (state_82137[(2)]);
var state_82137__$1 = state_82137;
var statearr_82150_82175 = state_82137__$1;
(statearr_82150_82175[(2)] = inst_82117);

(statearr_82150_82175[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82138 === (2))){
var _ = (function (){var statearr_82151 = state_82137;
(statearr_82151[(4)] = cljs.core.cons.call(null,(5),(state_82137[(4)])));

return statearr_82151;
})();
var inst_82098 = flureenjs.db_instance.call(null,conn,ledger);
var state_82137__$1 = state_82137;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82137__$1,(6),inst_82098);
} else {
if((state_val_82138 === (11))){
var state_82137__$1 = state_82137;
var statearr_82153_82176 = state_82137__$1;
(statearr_82153_82176[(2)] = false);

(statearr_82153_82176[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82138 === (9))){
var inst_82120 = (state_82137[(2)]);
var state_82137__$1 = state_82137;
if(cljs.core.truth_(inst_82120)){
var statearr_82154_82177 = state_82137__$1;
(statearr_82154_82177[(1)] = (13));

} else {
var statearr_82155_82178 = state_82137__$1;
(statearr_82155_82178[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82138 === (5))){
var _ = (function (){var statearr_82156 = state_82137;
(statearr_82156[(4)] = cljs.core.rest.call(null,(state_82137[(4)])));

return statearr_82156;
})();
var state_82137__$1 = state_82137;
var ex82152 = (state_82137__$1[(2)]);
var statearr_82157_82179 = state_82137__$1;
(statearr_82157_82179[(5)] = ex82152);


var statearr_82158_82180 = state_82137__$1;
(statearr_82158_82180[(1)] = (4));

(statearr_82158_82180[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82138 === (14))){
var inst_82104 = (state_82137[(7)]);
var state_82137__$1 = state_82137;
var statearr_82159_82181 = state_82137__$1;
(statearr_82159_82181[(2)] = inst_82104);

(statearr_82159_82181[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82138 === (10))){
var state_82137__$1 = state_82137;
var statearr_82160_82182 = state_82137__$1;
(statearr_82160_82182[(2)] = true);

(statearr_82160_82182[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82138 === (8))){
var state_82137__$1 = state_82137;
var statearr_82161_82183 = state_82137__$1;
(statearr_82161_82183[(2)] = false);

(statearr_82161_82183[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$block_event__GT_map_$_state_machine__11469__auto__ = null;
var flureenjs$block_event__GT_map_$_state_machine__11469__auto____0 = (function (){
var statearr_82162 = [null,null,null,null,null,null,null,null,null,null];
(statearr_82162[(0)] = flureenjs$block_event__GT_map_$_state_machine__11469__auto__);

(statearr_82162[(1)] = (1));

return statearr_82162;
});
var flureenjs$block_event__GT_map_$_state_machine__11469__auto____1 = (function (state_82137){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_82137);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e82163){var ex__11472__auto__ = e82163;
var statearr_82164_82184 = state_82137;
(statearr_82164_82184[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_82137[(4)]))){
var statearr_82165_82185 = state_82137;
(statearr_82165_82185[(1)] = cljs.core.first.call(null,(state_82137[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82186 = state_82137;
state_82137 = G__82186;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$block_event__GT_map_$_state_machine__11469__auto__ = function(state_82137){
switch(arguments.length){
case 0:
return flureenjs$block_event__GT_map_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$block_event__GT_map_$_state_machine__11469__auto____1.call(this,state_82137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$block_event__GT_map_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$block_event__GT_map_$_state_machine__11469__auto____0;
flureenjs$block_event__GT_map_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$block_event__GT_map_$_state_machine__11469__auto____1;
return flureenjs$block_event__GT_map_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_82166 = f__11543__auto__.call(null);
(statearr_82166[(6)] = c__11542__auto__);

return statearr_82166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureenjs.listen = (function flureenjs$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen.call(null,conn,ledger,key,callback);
});
goog.exportSymbol('flureenjs.listen', flureenjs.listen);
/**
 * Closes a listener.
 */
flureenjs.close_listener = (function flureenjs$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener.call(null,conn,ledger,key);
});
goog.exportSymbol('flureenjs.close_listener', flureenjs.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureenjs.listeners = (function flureenjs$listeners(conn){
return fluree.db.connection_js.listeners.call(null,conn);
});
goog.exportSymbol('flureenjs.listeners', flureenjs.listeners);
/**
 * Returns a queryable database from the connection.
 */
flureenjs.db = (function flureenjs$db(var_args){
var args__4742__auto__ = [];
var len__4736__auto___82194 = arguments.length;
var i__4737__auto___82195 = (0);
while(true){
if((i__4737__auto___82195 < len__4736__auto___82194)){
args__4742__auto__.push((arguments[i__4737__auto___82195]));

var G__82196 = (i__4737__auto___82195 + (1));
i__4737__auto___82195 = G__82196;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return flureenjs.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});
goog.exportSymbol('flureenjs.db', flureenjs.db);

(flureenjs.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__82190){
var vec__82191 = p__82190;
var opts = cljs.core.nth.call(null,vec__82191,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return flureenjs.db_instance.call(null,conn,ledger,clj_opts);
}));

(flureenjs.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db.cljs$lang$applyTo = (function (seq82187){
var G__82188 = cljs.core.first.call(null,seq82187);
var seq82187__$1 = cljs.core.next.call(null,seq82187);
var G__82189 = cljs.core.first.call(null,seq82187__$1);
var seq82187__$2 = cljs.core.next.call(null,seq82187__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82188,G__82189,seq82187__$2);
}));

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db_instance = (function flureenjs$db_instance(var_args){
var G__82198 = arguments.length;
switch (G__82198) {
case 2:
return flureenjs.db_instance.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.db_instance.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs.db_instance.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.db_instance.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.db_instance.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__11542__auto___82304 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_82264){
var state_val_82265 = (state_82264[(1)]);
if((state_val_82265 === (7))){
var state_82264__$1 = state_82264;
var statearr_82266_82305 = state_82264__$1;
(statearr_82266_82305[(2)] = false);

(statearr_82266_82305[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (20))){
var inst_82250 = (state_82264[(2)]);
var state_82264__$1 = state_82264;
var statearr_82267_82306 = state_82264__$1;
(statearr_82267_82306[(2)] = inst_82250);

(statearr_82267_82306[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (1))){
var state_82264__$1 = state_82264;
var statearr_82268_82307 = state_82264__$1;
(statearr_82268_82307[(2)] = null);

(statearr_82268_82307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (4))){
var inst_82199 = (state_82264[(2)]);
var inst_82200 = fluree.db.util.log.error.call(null,inst_82199);
var inst_82201 = cljs.core.async.put_BANG_.call(null,pc,inst_82199);
var inst_82202 = cljs.core.async.close_BANG_.call(null,pc);
var state_82264__$1 = (function (){var statearr_82269 = state_82264;
(statearr_82269[(7)] = inst_82201);

(statearr_82269[(8)] = inst_82200);

return statearr_82269;
})();
var statearr_82270_82308 = state_82264__$1;
(statearr_82270_82308[(2)] = inst_82202);

(statearr_82270_82308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (15))){
var inst_82234 = (state_82264[(9)]);
var state_82264__$1 = state_82264;
var statearr_82271_82309 = state_82264__$1;
(statearr_82271_82309[(2)] = inst_82234);

(statearr_82271_82309[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (21))){
var inst_82239 = (state_82264[(10)]);
var inst_82238 = (state_82264[(11)]);
var inst_82256 = (state_82264[(2)]);
var inst_82257 = fluree.db.util.async.throw_err.call(null,inst_82256);
var inst_82258 = cljs.core.assoc.call(null,inst_82257,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_82238,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_82239);
var inst_82259 = cljs.core.async.put_BANG_.call(null,pc,inst_82258);
var _ = (function (){var statearr_82272 = state_82264;
(statearr_82272[(4)] = cljs.core.rest.call(null,(state_82264[(4)])));

return statearr_82272;
})();
var state_82264__$1 = state_82264;
var statearr_82273_82310 = state_82264__$1;
(statearr_82273_82310[(2)] = inst_82259);

(statearr_82273_82310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (13))){
var inst_82212 = (state_82264[(12)]);
var state_82264__$1 = state_82264;
var statearr_82274_82311 = state_82264__$1;
(statearr_82274_82311[(2)] = inst_82212);

(statearr_82274_82311[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (6))){
var inst_82212 = (state_82264[(12)]);
var inst_82217 = inst_82212.cljs$lang$protocol_mask$partition0$;
var inst_82218 = (inst_82217 & (64));
var inst_82219 = inst_82212.cljs$core$ISeq$;
var inst_82220 = (cljs.core.PROTOCOL_SENTINEL === inst_82219);
var inst_82221 = ((inst_82218) || (inst_82220));
var state_82264__$1 = state_82264;
if(cljs.core.truth_(inst_82221)){
var statearr_82275_82312 = state_82264__$1;
(statearr_82275_82312[(1)] = (9));

} else {
var statearr_82276_82313 = state_82264__$1;
(statearr_82276_82313[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (17))){
var inst_82252 = (state_82264[(2)]);
var inst_82253 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_82252);
var inst_82254 = fluree.db.api.ledger.db.call(null,conn,ledger,inst_82253);
var state_82264__$1 = state_82264;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82264__$1,(21),inst_82254);
} else {
if((state_val_82265 === (3))){
var inst_82262 = (state_82264[(2)]);
var state_82264__$1 = state_82264;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82264__$1,inst_82262);
} else {
if((state_val_82265 === (12))){
var inst_82212 = (state_82264[(12)]);
var inst_82230 = cljs.core.apply.call(null,cljs.core.hash_map,inst_82212);
var state_82264__$1 = state_82264;
var statearr_82277_82314 = state_82264__$1;
(statearr_82277_82314[(2)] = inst_82230);

(statearr_82277_82314[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (2))){
var inst_82212 = (state_82264[(12)]);
var _ = (function (){var statearr_82278 = state_82264;
(statearr_82278[(4)] = cljs.core.cons.call(null,(5),(state_82264[(4)])));

return statearr_82278;
})();
var inst_82212__$1 = opts;
var inst_82214 = (inst_82212__$1 == null);
var inst_82215 = cljs.core.not.call(null,inst_82214);
var state_82264__$1 = (function (){var statearr_82279 = state_82264;
(statearr_82279[(12)] = inst_82212__$1);

return statearr_82279;
})();
if(inst_82215){
var statearr_82280_82315 = state_82264__$1;
(statearr_82280_82315[(1)] = (6));

} else {
var statearr_82281_82316 = state_82264__$1;
(statearr_82281_82316[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (19))){
var state_82264__$1 = state_82264;
var statearr_82282_82317 = state_82264__$1;
(statearr_82282_82317[(2)] = null);

(statearr_82282_82317[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (11))){
var inst_82225 = (state_82264[(2)]);
var state_82264__$1 = state_82264;
var statearr_82284_82318 = state_82264__$1;
(statearr_82284_82318[(2)] = inst_82225);

(statearr_82284_82318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (9))){
var state_82264__$1 = state_82264;
var statearr_82285_82319 = state_82264__$1;
(statearr_82285_82319[(2)] = true);

(statearr_82285_82319[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (5))){
var _ = (function (){var statearr_82286 = state_82264;
(statearr_82286[(4)] = cljs.core.rest.call(null,(state_82264[(4)])));

return statearr_82286;
})();
var state_82264__$1 = state_82264;
var ex82283 = (state_82264__$1[(2)]);
var statearr_82287_82320 = state_82264__$1;
(statearr_82287_82320[(5)] = ex82283);


var statearr_82288_82321 = state_82264__$1;
(statearr_82288_82321[(1)] = (4));

(statearr_82288_82321[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (14))){
var inst_82234 = (state_82264[(9)]);
var inst_82233 = (state_82264[(2)]);
var inst_82234__$1 = cljs.core.get.call(null,inst_82233,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_82235 = cljs.core.get.call(null,inst_82233,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_82236 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_82237 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_82238 = cljs.core.nth.call(null,inst_82237,(0),null);
var inst_82239 = cljs.core.nth.call(null,inst_82237,(1),null);
var state_82264__$1 = (function (){var statearr_82289 = state_82264;
(statearr_82289[(9)] = inst_82234__$1);

(statearr_82289[(10)] = inst_82239);

(statearr_82289[(11)] = inst_82238);

(statearr_82289[(13)] = inst_82235);

(statearr_82289[(14)] = inst_82236);

return statearr_82289;
})();
if(cljs.core.truth_(inst_82234__$1)){
var statearr_82290_82322 = state_82264__$1;
(statearr_82290_82322[(1)] = (15));

} else {
var statearr_82291_82323 = state_82264__$1;
(statearr_82291_82323[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (16))){
var inst_82235 = (state_82264[(13)]);
var state_82264__$1 = state_82264;
if(cljs.core.truth_(inst_82235)){
var statearr_82292_82324 = state_82264__$1;
(statearr_82292_82324[(1)] = (18));

} else {
var statearr_82293_82325 = state_82264__$1;
(statearr_82293_82325[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (10))){
var state_82264__$1 = state_82264;
var statearr_82294_82326 = state_82264__$1;
(statearr_82294_82326[(2)] = false);

(statearr_82294_82326[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (18))){
var inst_82235 = (state_82264[(13)]);
var inst_82243 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82244 = fluree.db.connection_js.validate_token.call(null,conn,inst_82235);
var inst_82245 = new cljs.core.Keyword(null,"sub","sub",-2093760025).cljs$core$IFn$_invoke$arity$1(inst_82244);
var inst_82246 = ["_auth/id",inst_82245];
var inst_82247 = (new cljs.core.PersistentVector(null,2,(5),inst_82243,inst_82246,null));
var state_82264__$1 = state_82264;
var statearr_82295_82327 = state_82264__$1;
(statearr_82295_82327[(2)] = inst_82247);

(statearr_82295_82327[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82265 === (8))){
var inst_82228 = (state_82264[(2)]);
var state_82264__$1 = state_82264;
if(cljs.core.truth_(inst_82228)){
var statearr_82296_82328 = state_82264__$1;
(statearr_82296_82328[(1)] = (12));

} else {
var statearr_82297_82329 = state_82264__$1;
(statearr_82297_82329[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_82298 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82298[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_82298[(1)] = (1));

return statearr_82298;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_82264){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_82264);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e82299){var ex__11472__auto__ = e82299;
var statearr_82300_82330 = state_82264;
(statearr_82300_82330[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_82264[(4)]))){
var statearr_82301_82331 = state_82264;
(statearr_82301_82331[(1)] = cljs.core.first.call(null,(state_82264[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82332 = state_82264;
state_82264 = G__82332;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_82264){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_82264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_82302 = f__11543__auto__.call(null);
(statearr_82302[(6)] = c__11542__auto___82304);

return statearr_82302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return pc;
}));

(flureenjs.db_instance.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db_p = (function flureenjs$db_p(var_args){
var args__4742__auto__ = [];
var len__4736__auto___82372 = arguments.length;
var i__4737__auto___82373 = (0);
while(true){
if((i__4737__auto___82373 < len__4736__auto___82372)){
args__4742__auto__.push((arguments[i__4737__auto___82373]));

var G__82374 = (i__4737__auto___82373 + (1));
i__4737__auto___82373 = G__82374;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return flureenjs.db_p.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});
goog.exportSymbol('flureenjs.db_p', flureenjs.db_p);

(flureenjs.db_p.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__82336){
var vec__82337 = p__82336;
var opts = cljs.core.nth.call(null,vec__82337,(0),null);
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_82355){
var state_val_82356 = (state_82355[(1)]);
if((state_val_82356 === (1))){
var state_82355__$1 = state_82355;
var statearr_82357_82375 = state_82355__$1;
(statearr_82357_82375[(2)] = null);

(statearr_82357_82375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82356 === (2))){
var _ = (function (){var statearr_82358 = state_82355;
(statearr_82358[(4)] = cljs.core.cons.call(null,(5),(state_82355[(4)])));

return statearr_82358;
})();
var inst_82348 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_82349 = flureenjs.db_instance.call(null,conn,ledger,inst_82348);
var inst_82350 = resolve.call(null,inst_82349);
var ___$1 = (function (){var statearr_82359 = state_82355;
(statearr_82359[(4)] = cljs.core.rest.call(null,(state_82355[(4)])));

return statearr_82359;
})();
var state_82355__$1 = state_82355;
var statearr_82360_82376 = state_82355__$1;
(statearr_82360_82376[(2)] = inst_82350);

(statearr_82360_82376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82356 === (3))){
var inst_82353 = (state_82355[(2)]);
var state_82355__$1 = state_82355;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82355__$1,inst_82353);
} else {
if((state_val_82356 === (4))){
var inst_82340 = (state_82355[(2)]);
var inst_82341 = fluree.db.util.log.error.call(null,inst_82340);
var inst_82342 = reject.call(null,inst_82340);
var state_82355__$1 = (function (){var statearr_82362 = state_82355;
(statearr_82362[(7)] = inst_82341);

return statearr_82362;
})();
var statearr_82363_82377 = state_82355__$1;
(statearr_82363_82377[(2)] = inst_82342);

(statearr_82363_82377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82356 === (5))){
var _ = (function (){var statearr_82364 = state_82355;
(statearr_82364[(4)] = cljs.core.rest.call(null,(state_82355[(4)])));

return statearr_82364;
})();
var state_82355__$1 = state_82355;
var ex82361 = (state_82355__$1[(2)]);
var statearr_82365_82378 = state_82355__$1;
(statearr_82365_82378[(5)] = ex82361);


var statearr_82366_82379 = state_82355__$1;
(statearr_82366_82379[(1)] = (4));

(statearr_82366_82379[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_82367 = [null,null,null,null,null,null,null,null];
(statearr_82367[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_82367[(1)] = (1));

return statearr_82367;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_82355){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_82355);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e82368){var ex__11472__auto__ = e82368;
var statearr_82369_82380 = state_82355;
(statearr_82369_82380[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_82355[(4)]))){
var statearr_82370_82381 = state_82355;
(statearr_82370_82381[(1)] = cljs.core.first.call(null,(state_82355[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82382 = state_82355;
state_82355 = G__82382;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_82355){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_82355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_82371 = f__11543__auto__.call(null);
(statearr_82371[(6)] = c__11542__auto__);

return statearr_82371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.db_p.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db_p.cljs$lang$applyTo = (function (seq82333){
var G__82334 = cljs.core.first.call(null,seq82333);
var seq82333__$1 = cljs.core.next.call(null,seq82333);
var G__82335 = cljs.core.first.call(null,seq82333__$1);
var seq82333__$2 = cljs.core.next.call(null,seq82333__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82334,G__82335,seq82333__$2);
}));

/**
 * Returns promise containing collection id given a collection name.
 *   If collection doesn't exist, returns nil.
 */
flureenjs.collection_id = (function flureenjs$collection_id(db,collection){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_82402){
var state_val_82403 = (state_82402[(1)]);
if((state_val_82403 === (1))){
var state_82402__$1 = state_82402;
var statearr_82404_82420 = state_82402__$1;
(statearr_82404_82420[(2)] = null);

(statearr_82404_82420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82403 === (2))){
var _ = (function (){var statearr_82405 = state_82402;
(statearr_82405[(4)] = cljs.core.cons.call(null,(5),(state_82402[(4)])));

return statearr_82405;
})();
var inst_82391 = cljs.core.js__GT_clj.call(null,collection,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82402__$1 = (function (){var statearr_82406 = state_82402;
(statearr_82406[(7)] = inst_82391);

return statearr_82406;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82402__$1,(6),db);
} else {
if((state_val_82403 === (3))){
var inst_82400 = (state_82402[(2)]);
var state_82402__$1 = state_82402;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82402__$1,inst_82400);
} else {
if((state_val_82403 === (4))){
var inst_82383 = (state_82402[(2)]);
var inst_82384 = fluree.db.util.log.error.call(null,inst_82383);
var inst_82385 = reject.call(null,inst_82383);
var state_82402__$1 = (function (){var statearr_82408 = state_82402;
(statearr_82408[(8)] = inst_82384);

return statearr_82408;
})();
var statearr_82409_82421 = state_82402__$1;
(statearr_82409_82421[(2)] = inst_82385);

(statearr_82409_82421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82403 === (5))){
var _ = (function (){var statearr_82410 = state_82402;
(statearr_82410[(4)] = cljs.core.rest.call(null,(state_82402[(4)])));

return statearr_82410;
})();
var state_82402__$1 = state_82402;
var ex82407 = (state_82402__$1[(2)]);
var statearr_82411_82422 = state_82402__$1;
(statearr_82411_82422[(5)] = ex82407);


var statearr_82412_82423 = state_82402__$1;
(statearr_82412_82423[(1)] = (4));

(statearr_82412_82423[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82403 === (6))){
var inst_82391 = (state_82402[(7)]);
var inst_82393 = (state_82402[(2)]);
var inst_82394 = fluree.db.util.async.throw_err.call(null,inst_82393);
var inst_82395 = fluree.db.dbproto._c_prop.call(null,inst_82394,new cljs.core.Keyword(null,"id","id",-1388402092),inst_82391);
var inst_82396 = cljs.core.clj__GT_js.call(null,inst_82395);
var inst_82397 = resolve.call(null,inst_82396);
var _ = (function (){var statearr_82413 = state_82402;
(statearr_82413[(4)] = cljs.core.rest.call(null,(state_82402[(4)])));

return statearr_82413;
})();
var state_82402__$1 = state_82402;
var statearr_82414_82424 = state_82402__$1;
(statearr_82414_82424[(2)] = inst_82397);

(statearr_82414_82424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$collection_id_$_state_machine__11469__auto__ = null;
var flureenjs$collection_id_$_state_machine__11469__auto____0 = (function (){
var statearr_82415 = [null,null,null,null,null,null,null,null,null];
(statearr_82415[(0)] = flureenjs$collection_id_$_state_machine__11469__auto__);

(statearr_82415[(1)] = (1));

return statearr_82415;
});
var flureenjs$collection_id_$_state_machine__11469__auto____1 = (function (state_82402){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_82402);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e82416){var ex__11472__auto__ = e82416;
var statearr_82417_82425 = state_82402;
(statearr_82417_82425[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_82402[(4)]))){
var statearr_82418_82426 = state_82402;
(statearr_82418_82426[(1)] = cljs.core.first.call(null,(state_82402[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82427 = state_82402;
state_82402 = G__82427;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$collection_id_$_state_machine__11469__auto__ = function(state_82402){
switch(arguments.length){
case 0:
return flureenjs$collection_id_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$collection_id_$_state_machine__11469__auto____1.call(this,state_82402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collection_id_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collection_id_$_state_machine__11469__auto____0;
flureenjs$collection_id_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collection_id_$_state_machine__11469__auto____1;
return flureenjs$collection_id_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_82419 = f__11543__auto__.call(null);
(statearr_82419[(6)] = c__11542__auto__);

return statearr_82419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.collection_id', flureenjs.collection_id);
/**
 * Returns promise containing predicate id given a predicate.
 *   If predicate doesn't exist, returns nil.
 */
flureenjs.predicate_id = (function flureenjs$predicate_id(db,predicate){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_82447){
var state_val_82448 = (state_82447[(1)]);
if((state_val_82448 === (1))){
var state_82447__$1 = state_82447;
var statearr_82449_82465 = state_82447__$1;
(statearr_82449_82465[(2)] = null);

(statearr_82449_82465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82448 === (2))){
var _ = (function (){var statearr_82450 = state_82447;
(statearr_82450[(4)] = cljs.core.cons.call(null,(5),(state_82447[(4)])));

return statearr_82450;
})();
var inst_82436 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82447__$1 = (function (){var statearr_82451 = state_82447;
(statearr_82451[(7)] = inst_82436);

return statearr_82451;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82447__$1,(6),db);
} else {
if((state_val_82448 === (3))){
var inst_82445 = (state_82447[(2)]);
var state_82447__$1 = state_82447;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82447__$1,inst_82445);
} else {
if((state_val_82448 === (4))){
var inst_82428 = (state_82447[(2)]);
var inst_82429 = fluree.db.util.log.error.call(null,inst_82428);
var inst_82430 = reject.call(null,inst_82428);
var state_82447__$1 = (function (){var statearr_82453 = state_82447;
(statearr_82453[(8)] = inst_82429);

return statearr_82453;
})();
var statearr_82454_82466 = state_82447__$1;
(statearr_82454_82466[(2)] = inst_82430);

(statearr_82454_82466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82448 === (5))){
var _ = (function (){var statearr_82455 = state_82447;
(statearr_82455[(4)] = cljs.core.rest.call(null,(state_82447[(4)])));

return statearr_82455;
})();
var state_82447__$1 = state_82447;
var ex82452 = (state_82447__$1[(2)]);
var statearr_82456_82467 = state_82447__$1;
(statearr_82456_82467[(5)] = ex82452);


var statearr_82457_82468 = state_82447__$1;
(statearr_82457_82468[(1)] = (4));

(statearr_82457_82468[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82448 === (6))){
var inst_82436 = (state_82447[(7)]);
var inst_82438 = (state_82447[(2)]);
var inst_82439 = fluree.db.util.async.throw_err.call(null,inst_82438);
var inst_82440 = fluree.db.dbproto._p_prop.call(null,inst_82439,new cljs.core.Keyword(null,"id","id",-1388402092),inst_82436);
var inst_82441 = cljs.core.clj__GT_js.call(null,inst_82440);
var inst_82442 = resolve.call(null,inst_82441);
var _ = (function (){var statearr_82458 = state_82447;
(statearr_82458[(4)] = cljs.core.rest.call(null,(state_82447[(4)])));

return statearr_82458;
})();
var state_82447__$1 = state_82447;
var statearr_82459_82469 = state_82447__$1;
(statearr_82459_82469[(2)] = inst_82442);

(statearr_82459_82469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicate_id_$_state_machine__11469__auto__ = null;
var flureenjs$predicate_id_$_state_machine__11469__auto____0 = (function (){
var statearr_82460 = [null,null,null,null,null,null,null,null,null];
(statearr_82460[(0)] = flureenjs$predicate_id_$_state_machine__11469__auto__);

(statearr_82460[(1)] = (1));

return statearr_82460;
});
var flureenjs$predicate_id_$_state_machine__11469__auto____1 = (function (state_82447){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_82447);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e82461){var ex__11472__auto__ = e82461;
var statearr_82462_82470 = state_82447;
(statearr_82462_82470[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_82447[(4)]))){
var statearr_82463_82471 = state_82447;
(statearr_82463_82471[(1)] = cljs.core.first.call(null,(state_82447[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82472 = state_82447;
state_82447 = G__82472;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$predicate_id_$_state_machine__11469__auto__ = function(state_82447){
switch(arguments.length){
case 0:
return flureenjs$predicate_id_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$predicate_id_$_state_machine__11469__auto____1.call(this,state_82447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicate_id_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicate_id_$_state_machine__11469__auto____0;
flureenjs$predicate_id_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicate_id_$_state_machine__11469__auto____1;
return flureenjs$predicate_id_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_82464 = f__11543__auto__.call(null);
(statearr_82464[(6)] = c__11542__auto__);

return statearr_82464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.predicate_id', flureenjs.predicate_id);
/**
 * Returns promise containing predicate name given a predicate.
 *   If predicate doesn't exist, returns nil.
 */
flureenjs.predicate_name = (function flureenjs$predicate_name(db,predicate){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_82492){
var state_val_82493 = (state_82492[(1)]);
if((state_val_82493 === (1))){
var state_82492__$1 = state_82492;
var statearr_82494_82510 = state_82492__$1;
(statearr_82494_82510[(2)] = null);

(statearr_82494_82510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82493 === (2))){
var _ = (function (){var statearr_82495 = state_82492;
(statearr_82495[(4)] = cljs.core.cons.call(null,(5),(state_82492[(4)])));

return statearr_82495;
})();
var inst_82481 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82492__$1 = (function (){var statearr_82496 = state_82492;
(statearr_82496[(7)] = inst_82481);

return statearr_82496;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82492__$1,(6),db);
} else {
if((state_val_82493 === (3))){
var inst_82490 = (state_82492[(2)]);
var state_82492__$1 = state_82492;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82492__$1,inst_82490);
} else {
if((state_val_82493 === (4))){
var inst_82473 = (state_82492[(2)]);
var inst_82474 = fluree.db.util.log.error.call(null,inst_82473);
var inst_82475 = reject.call(null,inst_82473);
var state_82492__$1 = (function (){var statearr_82498 = state_82492;
(statearr_82498[(8)] = inst_82474);

return statearr_82498;
})();
var statearr_82499_82511 = state_82492__$1;
(statearr_82499_82511[(2)] = inst_82475);

(statearr_82499_82511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82493 === (5))){
var _ = (function (){var statearr_82500 = state_82492;
(statearr_82500[(4)] = cljs.core.rest.call(null,(state_82492[(4)])));

return statearr_82500;
})();
var state_82492__$1 = state_82492;
var ex82497 = (state_82492__$1[(2)]);
var statearr_82501_82512 = state_82492__$1;
(statearr_82501_82512[(5)] = ex82497);


var statearr_82502_82513 = state_82492__$1;
(statearr_82502_82513[(1)] = (4));

(statearr_82502_82513[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82493 === (6))){
var inst_82481 = (state_82492[(7)]);
var inst_82483 = (state_82492[(2)]);
var inst_82484 = fluree.db.util.async.throw_err.call(null,inst_82483);
var inst_82485 = fluree.db.dbproto._p_prop.call(null,inst_82484,new cljs.core.Keyword(null,"name","name",1843675177),inst_82481);
var inst_82486 = cljs.core.clj__GT_js.call(null,inst_82485);
var inst_82487 = resolve.call(null,inst_82486);
var _ = (function (){var statearr_82503 = state_82492;
(statearr_82503[(4)] = cljs.core.rest.call(null,(state_82492[(4)])));

return statearr_82503;
})();
var state_82492__$1 = state_82492;
var statearr_82504_82514 = state_82492__$1;
(statearr_82504_82514[(2)] = inst_82487);

(statearr_82504_82514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicate_name_$_state_machine__11469__auto__ = null;
var flureenjs$predicate_name_$_state_machine__11469__auto____0 = (function (){
var statearr_82505 = [null,null,null,null,null,null,null,null,null];
(statearr_82505[(0)] = flureenjs$predicate_name_$_state_machine__11469__auto__);

(statearr_82505[(1)] = (1));

return statearr_82505;
});
var flureenjs$predicate_name_$_state_machine__11469__auto____1 = (function (state_82492){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_82492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e82506){var ex__11472__auto__ = e82506;
var statearr_82507_82515 = state_82492;
(statearr_82507_82515[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_82492[(4)]))){
var statearr_82508_82516 = state_82492;
(statearr_82508_82516[(1)] = cljs.core.first.call(null,(state_82492[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82517 = state_82492;
state_82492 = G__82517;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$predicate_name_$_state_machine__11469__auto__ = function(state_82492){
switch(arguments.length){
case 0:
return flureenjs$predicate_name_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$predicate_name_$_state_machine__11469__auto____1.call(this,state_82492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicate_name_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicate_name_$_state_machine__11469__auto____0;
flureenjs$predicate_name_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicate_name_$_state_machine__11469__auto____1;
return flureenjs$predicate_name_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_82509 = f__11543__auto__.call(null);
(statearr_82509[(6)] = c__11542__auto__);

return statearr_82509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.predicate_name', flureenjs.predicate_name);
/**
 * Returns promise containing subject id given a subject
 *   identity or a subject id.
 *   If subject doesn't exist, returns nil.
 */
flureenjs.subid = (function flureenjs$subid(db,ident){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_82540){
var state_val_82541 = (state_82540[(1)]);
if((state_val_82541 === (1))){
var state_82540__$1 = state_82540;
var statearr_82542_82558 = state_82540__$1;
(statearr_82542_82558[(2)] = null);

(statearr_82542_82558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82541 === (2))){
var _ = (function (){var statearr_82543 = state_82540;
(statearr_82543[(4)] = cljs.core.cons.call(null,(5),(state_82540[(4)])));

return statearr_82543;
})();
var inst_82526 = cljs.core.js__GT_clj.call(null,ident,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82540__$1 = (function (){var statearr_82544 = state_82540;
(statearr_82544[(7)] = inst_82526);

return statearr_82544;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82540__$1,(7),db);
} else {
if((state_val_82541 === (3))){
var inst_82538 = (state_82540[(2)]);
var state_82540__$1 = state_82540;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82540__$1,inst_82538);
} else {
if((state_val_82541 === (4))){
var inst_82518 = (state_82540[(2)]);
var inst_82519 = fluree.db.util.log.error.call(null,inst_82518);
var inst_82520 = reject.call(null,inst_82518);
var state_82540__$1 = (function (){var statearr_82546 = state_82540;
(statearr_82546[(8)] = inst_82519);

return statearr_82546;
})();
var statearr_82547_82559 = state_82540__$1;
(statearr_82547_82559[(2)] = inst_82520);

(statearr_82547_82559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82541 === (5))){
var _ = (function (){var statearr_82548 = state_82540;
(statearr_82548[(4)] = cljs.core.rest.call(null,(state_82540[(4)])));

return statearr_82548;
})();
var state_82540__$1 = state_82540;
var ex82545 = (state_82540__$1[(2)]);
var statearr_82549_82560 = state_82540__$1;
(statearr_82549_82560[(5)] = ex82545);


var statearr_82550_82561 = state_82540__$1;
(statearr_82550_82561[(1)] = (4));

(statearr_82550_82561[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82541 === (6))){
var inst_82532 = (state_82540[(2)]);
var inst_82533 = fluree.db.util.async.throw_err.call(null,inst_82532);
var inst_82534 = cljs.core.clj__GT_js.call(null,inst_82533);
var inst_82535 = resolve.call(null,inst_82534);
var _ = (function (){var statearr_82551 = state_82540;
(statearr_82551[(4)] = cljs.core.rest.call(null,(state_82540[(4)])));

return statearr_82551;
})();
var state_82540__$1 = state_82540;
var statearr_82552_82562 = state_82540__$1;
(statearr_82552_82562[(2)] = inst_82535);

(statearr_82552_82562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82541 === (7))){
var inst_82526 = (state_82540[(7)]);
var inst_82528 = (state_82540[(2)]);
var inst_82529 = fluree.db.util.async.throw_err.call(null,inst_82528);
var inst_82530 = fluree.db.dbproto._subid.call(null,inst_82529,inst_82526,false);
var state_82540__$1 = state_82540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82540__$1,(6),inst_82530);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$subid_$_state_machine__11469__auto__ = null;
var flureenjs$subid_$_state_machine__11469__auto____0 = (function (){
var statearr_82553 = [null,null,null,null,null,null,null,null,null];
(statearr_82553[(0)] = flureenjs$subid_$_state_machine__11469__auto__);

(statearr_82553[(1)] = (1));

return statearr_82553;
});
var flureenjs$subid_$_state_machine__11469__auto____1 = (function (state_82540){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_82540);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e82554){var ex__11472__auto__ = e82554;
var statearr_82555_82563 = state_82540;
(statearr_82555_82563[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_82540[(4)]))){
var statearr_82556_82564 = state_82540;
(statearr_82556_82564[(1)] = cljs.core.first.call(null,(state_82540[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82565 = state_82540;
state_82540 = G__82565;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$subid_$_state_machine__11469__auto__ = function(state_82540){
switch(arguments.length){
case 0:
return flureenjs$subid_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$subid_$_state_machine__11469__auto____1.call(this,state_82540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$subid_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$subid_$_state_machine__11469__auto____0;
flureenjs$subid_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$subid_$_state_machine__11469__auto____1;
return flureenjs$subid_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_82557 = f__11543__auto__.call(null);
(statearr_82557[(6)] = c__11542__auto__);

return statearr_82557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.subid', flureenjs.subid);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureenjs.delete_ledger = (function flureenjs$delete_ledger(var_args){
var G__82567 = arguments.length;
switch (G__82567) {
case 2:
return flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.delete_ledger', flureenjs.delete_ledger);

(flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.delete_ledger.call(null,conn,ledger,null);
}));

(flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_82657){
var state_val_82658 = (state_82657[(1)]);
if((state_val_82658 === (7))){
var inst_82580 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82657__$1 = state_82657;
var statearr_82659_82717 = state_82657__$1;
(statearr_82659_82717[(2)] = inst_82580);

(statearr_82659_82717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (20))){
var inst_82606 = (state_82657[(7)]);
var inst_82613 = (state_82657[(2)]);
var state_82657__$1 = (function (){var statearr_82660 = state_82657;
(statearr_82660[(8)] = inst_82613);

return statearr_82660;
})();
if(cljs.core.truth_(inst_82606)){
var statearr_82661_82718 = state_82657__$1;
(statearr_82661_82718[(1)] = (21));

} else {
var statearr_82662_82719 = state_82657__$1;
(statearr_82662_82719[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (27))){
var inst_82608 = (state_82657[(9)]);
var inst_82627 = (state_82657[(10)]);
var inst_82629 = fluree.crypto.sign_message.call(null,inst_82627,inst_82608);
var state_82657__$1 = state_82657;
var statearr_82663_82720 = state_82657__$1;
(statearr_82663_82720[(2)] = inst_82629);

(statearr_82663_82720[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (1))){
var state_82657__$1 = state_82657;
var statearr_82664_82721 = state_82657__$1;
(statearr_82664_82721[(2)] = null);

(statearr_82664_82721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (24))){
var inst_82621 = (state_82657[(11)]);
var inst_82623 = fluree.db.util.core.without_nils.call(null,inst_82621);
var inst_82624 = fluree.db.util.json.stringify.call(null,inst_82623);
var state_82657__$1 = state_82657;
var statearr_82665_82722 = state_82657__$1;
(statearr_82665_82722[(2)] = inst_82624);

(statearr_82665_82722[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (4))){
var inst_82568 = (state_82657[(2)]);
var inst_82569 = fluree.db.util.log.error.call(null,inst_82568);
var inst_82570 = reject.call(null,inst_82568);
var state_82657__$1 = (function (){var statearr_82666 = state_82657;
(statearr_82666[(12)] = inst_82569);

return statearr_82666;
})();
var statearr_82667_82723 = state_82657__$1;
(statearr_82667_82723[(2)] = inst_82570);

(statearr_82667_82723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (15))){
var inst_82582 = (state_82657[(13)]);
var inst_82601 = cljs.core.apply.call(null,cljs.core.hash_map,inst_82582);
var state_82657__$1 = state_82657;
var statearr_82668_82724 = state_82657__$1;
(statearr_82668_82724[(2)] = inst_82601);

(statearr_82668_82724[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (21))){
var inst_82606 = (state_82657[(7)]);
var state_82657__$1 = state_82657;
var statearr_82669_82725 = state_82657__$1;
(statearr_82669_82725[(2)] = inst_82606);

(statearr_82669_82725[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (31))){
var inst_82621 = (state_82657[(11)]);
var inst_82642 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_82621);
var state_82657__$1 = state_82657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82657__$1,(34),inst_82642);
} else {
if((state_val_82658 === (32))){
var inst_82647 = (state_82657[(2)]);
var inst_82648 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_82649 = [(200),inst_82647];
var inst_82650 = cljs.core.PersistentHashMap.fromArrays(inst_82648,inst_82649);
var inst_82651 = cljs.core.clj__GT_js.call(null,inst_82650);
var inst_82652 = resolve.call(null,inst_82651);
var _ = (function (){var statearr_82670 = state_82657;
(statearr_82670[(4)] = cljs.core.rest.call(null,(state_82657[(4)])));

return statearr_82670;
})();
var state_82657__$1 = state_82657;
var statearr_82671_82726 = state_82657__$1;
(statearr_82671_82726[(2)] = inst_82652);

(statearr_82671_82726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (33))){
var inst_82639 = (state_82657[(2)]);
var inst_82640 = fluree.db.util.async.throw_err.call(null,inst_82639);
var state_82657__$1 = state_82657;
var statearr_82672_82727 = state_82657__$1;
(statearr_82672_82727[(2)] = inst_82640);

(statearr_82672_82727[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (13))){
var state_82657__$1 = state_82657;
var statearr_82673_82728 = state_82657__$1;
(statearr_82673_82728[(2)] = false);

(statearr_82673_82728[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (22))){
var inst_82609 = (state_82657[(14)]);
var inst_82616 = (inst_82609 + (30000));
var state_82657__$1 = state_82657;
var statearr_82674_82729 = state_82657__$1;
(statearr_82674_82729[(2)] = inst_82616);

(statearr_82674_82729[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (29))){
var inst_82608 = (state_82657[(9)]);
var inst_82632 = (state_82657[(2)]);
var state_82657__$1 = (function (){var statearr_82675 = state_82657;
(statearr_82675[(15)] = inst_82632);

return statearr_82675;
})();
if(cljs.core.truth_(inst_82608)){
var statearr_82676_82730 = state_82657__$1;
(statearr_82676_82730[(1)] = (30));

} else {
var statearr_82677_82731 = state_82657__$1;
(statearr_82677_82731[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (6))){
var state_82657__$1 = state_82657;
var statearr_82678_82732 = state_82657__$1;
(statearr_82678_82732[(2)] = null);

(statearr_82678_82732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (28))){
var state_82657__$1 = state_82657;
var statearr_82679_82733 = state_82657__$1;
(statearr_82679_82733[(2)] = null);

(statearr_82679_82733[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (25))){
var state_82657__$1 = state_82657;
var statearr_82680_82734 = state_82657__$1;
(statearr_82680_82734[(2)] = null);

(statearr_82680_82734[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (34))){
var inst_82644 = (state_82657[(2)]);
var inst_82645 = fluree.db.util.async.throw_err.call(null,inst_82644);
var state_82657__$1 = state_82657;
var statearr_82681_82735 = state_82657__$1;
(statearr_82681_82735[(2)] = inst_82645);

(statearr_82681_82735[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (17))){
var inst_82605 = (state_82657[(16)]);
var inst_82604 = (state_82657[(2)]);
var inst_82605__$1 = cljs.core.get.call(null,inst_82604,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_82606 = cljs.core.get.call(null,inst_82604,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_82607 = cljs.core.get.call(null,inst_82604,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_82608 = cljs.core.get.call(null,inst_82604,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_82609 = fluree.db.util.core.current_time_millis.call(null);
var state_82657__$1 = (function (){var statearr_82682 = state_82657;
(statearr_82682[(17)] = inst_82607);

(statearr_82682[(7)] = inst_82606);

(statearr_82682[(9)] = inst_82608);

(statearr_82682[(16)] = inst_82605__$1);

(statearr_82682[(14)] = inst_82609);

return statearr_82682;
})();
if(cljs.core.truth_(inst_82605__$1)){
var statearr_82683_82736 = state_82657__$1;
(statearr_82683_82736[(1)] = (18));

} else {
var statearr_82684_82737 = state_82657__$1;
(statearr_82684_82737[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (3))){
var inst_82655 = (state_82657[(2)]);
var state_82657__$1 = state_82657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82657__$1,inst_82655);
} else {
if((state_val_82658 === (12))){
var state_82657__$1 = state_82657;
var statearr_82685_82738 = state_82657__$1;
(statearr_82685_82738[(2)] = true);

(statearr_82685_82738[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (2))){
var _ = (function (){var statearr_82686 = state_82657;
(statearr_82686[(4)] = cljs.core.cons.call(null,(5),(state_82657[(4)])));

return statearr_82686;
})();
var inst_82577 = (opts == null);
var state_82657__$1 = state_82657;
if(cljs.core.truth_(inst_82577)){
var statearr_82687_82739 = state_82657__$1;
(statearr_82687_82739[(1)] = (6));

} else {
var statearr_82688_82740 = state_82657__$1;
(statearr_82688_82740[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (23))){
var inst_82608 = (state_82657[(9)]);
var inst_82613 = (state_82657[(8)]);
var inst_82618 = (state_82657[(2)]);
var inst_82619 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_82620 = [new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),ledger,inst_82613,inst_82618];
var inst_82621 = cljs.core.PersistentHashMap.fromArrays(inst_82619,inst_82620);
var state_82657__$1 = (function (){var statearr_82689 = state_82657;
(statearr_82689[(11)] = inst_82621);

return statearr_82689;
})();
if(cljs.core.truth_(inst_82608)){
var statearr_82690_82741 = state_82657__$1;
(statearr_82690_82741[(1)] = (24));

} else {
var statearr_82691_82742 = state_82657__$1;
(statearr_82691_82742[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (19))){
var inst_82609 = (state_82657[(14)]);
var state_82657__$1 = state_82657;
var statearr_82692_82743 = state_82657__$1;
(statearr_82692_82743[(2)] = inst_82609);

(statearr_82692_82743[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (11))){
var inst_82599 = (state_82657[(2)]);
var state_82657__$1 = state_82657;
if(cljs.core.truth_(inst_82599)){
var statearr_82694_82744 = state_82657__$1;
(statearr_82694_82744[(1)] = (15));

} else {
var statearr_82695_82745 = state_82657__$1;
(statearr_82695_82745[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (9))){
var inst_82582 = (state_82657[(13)]);
var inst_82588 = inst_82582.cljs$lang$protocol_mask$partition0$;
var inst_82589 = (inst_82588 & (64));
var inst_82590 = inst_82582.cljs$core$ISeq$;
var inst_82591 = (cljs.core.PROTOCOL_SENTINEL === inst_82590);
var inst_82592 = ((inst_82589) || (inst_82591));
var state_82657__$1 = state_82657;
if(cljs.core.truth_(inst_82592)){
var statearr_82696_82746 = state_82657__$1;
(statearr_82696_82746[(1)] = (12));

} else {
var statearr_82697_82747 = state_82657__$1;
(statearr_82697_82747[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (5))){
var _ = (function (){var statearr_82698 = state_82657;
(statearr_82698[(4)] = cljs.core.rest.call(null,(state_82657[(4)])));

return statearr_82698;
})();
var state_82657__$1 = state_82657;
var ex82693 = (state_82657__$1[(2)]);
var statearr_82699_82748 = state_82657__$1;
(statearr_82699_82748[(5)] = ex82693);


var statearr_82700_82749 = state_82657__$1;
(statearr_82700_82749[(1)] = (4));

(statearr_82700_82749[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (14))){
var inst_82596 = (state_82657[(2)]);
var state_82657__$1 = state_82657;
var statearr_82701_82750 = state_82657__$1;
(statearr_82701_82750[(2)] = inst_82596);

(statearr_82701_82750[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (26))){
var inst_82608 = (state_82657[(9)]);
var inst_82627 = (state_82657[(2)]);
var state_82657__$1 = (function (){var statearr_82702 = state_82657;
(statearr_82702[(10)] = inst_82627);

return statearr_82702;
})();
if(cljs.core.truth_(inst_82608)){
var statearr_82703_82751 = state_82657__$1;
(statearr_82703_82751[(1)] = (27));

} else {
var statearr_82704_82752 = state_82657__$1;
(statearr_82704_82752[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (16))){
var inst_82582 = (state_82657[(13)]);
var state_82657__$1 = state_82657;
var statearr_82705_82753 = state_82657__$1;
(statearr_82705_82753[(2)] = inst_82582);

(statearr_82705_82753[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (30))){
var inst_82627 = (state_82657[(10)]);
var inst_82632 = (state_82657[(15)]);
var inst_82634 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_82635 = [inst_82627,inst_82632];
var inst_82636 = cljs.core.PersistentHashMap.fromArrays(inst_82634,inst_82635);
var inst_82637 = fluree.db.operations.command_async.call(null,conn,inst_82636);
var state_82657__$1 = state_82657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82657__$1,(33),inst_82637);
} else {
if((state_val_82658 === (10))){
var state_82657__$1 = state_82657;
var statearr_82706_82754 = state_82657__$1;
(statearr_82706_82754[(2)] = false);

(statearr_82706_82754[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (18))){
var inst_82605 = (state_82657[(16)]);
var state_82657__$1 = state_82657;
var statearr_82707_82755 = state_82657__$1;
(statearr_82707_82755[(2)] = inst_82605);

(statearr_82707_82755[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82658 === (8))){
var inst_82582 = (state_82657[(13)]);
var inst_82582__$1 = (state_82657[(2)]);
var inst_82583 = fluree.db.connection_js.check_connection.call(null,conn,inst_82582__$1);
var inst_82585 = (inst_82582__$1 == null);
var inst_82586 = cljs.core.not.call(null,inst_82585);
var state_82657__$1 = (function (){var statearr_82708 = state_82657;
(statearr_82708[(13)] = inst_82582__$1);

(statearr_82708[(18)] = inst_82583);

return statearr_82708;
})();
if(inst_82586){
var statearr_82709_82756 = state_82657__$1;
(statearr_82709_82756[(1)] = (9));

} else {
var statearr_82710_82757 = state_82657__$1;
(statearr_82710_82757[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_82711 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82711[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_82711[(1)] = (1));

return statearr_82711;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_82657){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_82657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e82712){var ex__11472__auto__ = e82712;
var statearr_82713_82758 = state_82657;
(statearr_82713_82758[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_82657[(4)]))){
var statearr_82714_82759 = state_82657;
(statearr_82714_82759[(1)] = cljs.core.first.call(null,(state_82657[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82760 = state_82657;
state_82657 = G__82760;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_82657){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_82657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_82715 = f__11543__auto__.call(null);
(statearr_82715[(6)] = c__11542__auto__);

return statearr_82715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise with ledger's status as a map, including index, indexes, block, and status.
 *   If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledger_info = (function flureenjs$ledger_info(conn,ledger){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_82779){
var state_val_82780 = (state_82779[(1)]);
if((state_val_82780 === (1))){
var state_82779__$1 = state_82779;
var statearr_82781_82796 = state_82779__$1;
(statearr_82781_82796[(2)] = null);

(statearr_82781_82796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82780 === (2))){
var _ = (function (){var statearr_82782 = state_82779;
(statearr_82782[(4)] = cljs.core.cons.call(null,(5),(state_82779[(4)])));

return statearr_82782;
})();
var inst_82769 = fluree.db.operations.ledger_info_async.call(null,conn,ledger);
var state_82779__$1 = state_82779;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82779__$1,(6),inst_82769);
} else {
if((state_val_82780 === (3))){
var inst_82777 = (state_82779[(2)]);
var state_82779__$1 = state_82779;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82779__$1,inst_82777);
} else {
if((state_val_82780 === (4))){
var inst_82761 = (state_82779[(2)]);
var inst_82762 = fluree.db.util.log.error.call(null,inst_82761);
var inst_82763 = reject.call(null,inst_82761);
var state_82779__$1 = (function (){var statearr_82784 = state_82779;
(statearr_82784[(7)] = inst_82762);

return statearr_82784;
})();
var statearr_82785_82797 = state_82779__$1;
(statearr_82785_82797[(2)] = inst_82763);

(statearr_82785_82797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82780 === (5))){
var _ = (function (){var statearr_82786 = state_82779;
(statearr_82786[(4)] = cljs.core.rest.call(null,(state_82779[(4)])));

return statearr_82786;
})();
var state_82779__$1 = state_82779;
var ex82783 = (state_82779__$1[(2)]);
var statearr_82787_82798 = state_82779__$1;
(statearr_82787_82798[(5)] = ex82783);


var statearr_82788_82799 = state_82779__$1;
(statearr_82788_82799[(1)] = (4));

(statearr_82788_82799[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82780 === (6))){
var inst_82771 = (state_82779[(2)]);
var inst_82772 = fluree.db.util.async.throw_err.call(null,inst_82771);
var inst_82773 = cljs.core.clj__GT_js.call(null,inst_82772);
var inst_82774 = resolve.call(null,inst_82773);
var _ = (function (){var statearr_82789 = state_82779;
(statearr_82789[(4)] = cljs.core.rest.call(null,(state_82779[(4)])));

return statearr_82789;
})();
var state_82779__$1 = state_82779;
var statearr_82790_82800 = state_82779__$1;
(statearr_82790_82800[(2)] = inst_82774);

(statearr_82790_82800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledger_info_$_state_machine__11469__auto__ = null;
var flureenjs$ledger_info_$_state_machine__11469__auto____0 = (function (){
var statearr_82791 = [null,null,null,null,null,null,null,null];
(statearr_82791[(0)] = flureenjs$ledger_info_$_state_machine__11469__auto__);

(statearr_82791[(1)] = (1));

return statearr_82791;
});
var flureenjs$ledger_info_$_state_machine__11469__auto____1 = (function (state_82779){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_82779);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e82792){var ex__11472__auto__ = e82792;
var statearr_82793_82801 = state_82779;
(statearr_82793_82801[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_82779[(4)]))){
var statearr_82794_82802 = state_82779;
(statearr_82794_82802[(1)] = cljs.core.first.call(null,(state_82779[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82803 = state_82779;
state_82779 = G__82803;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$ledger_info_$_state_machine__11469__auto__ = function(state_82779){
switch(arguments.length){
case 0:
return flureenjs$ledger_info_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$ledger_info_$_state_machine__11469__auto____1.call(this,state_82779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledger_info_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledger_info_$_state_machine__11469__auto____0;
flureenjs$ledger_info_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledger_info_$_state_machine__11469__auto____1;
return flureenjs$ledger_info_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_82795 = f__11543__auto__.call(null);
(statearr_82795[(6)] = c__11542__auto__);

return statearr_82795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.ledger_info', flureenjs.ledger_info);
/**
 * Returns promise with a list of ledgers the connected server is currently serving.
 */
flureenjs.ledger_list = (function flureenjs$ledger_list(conn){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_82822){
var state_val_82823 = (state_82822[(1)]);
if((state_val_82823 === (1))){
var state_82822__$1 = state_82822;
var statearr_82824_82839 = state_82822__$1;
(statearr_82824_82839[(2)] = null);

(statearr_82824_82839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82823 === (2))){
var _ = (function (){var statearr_82825 = state_82822;
(statearr_82825[(4)] = cljs.core.cons.call(null,(5),(state_82822[(4)])));

return statearr_82825;
})();
var inst_82812 = fluree.db.operations.ledgers_async.call(null,conn);
var state_82822__$1 = state_82822;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82822__$1,(6),inst_82812);
} else {
if((state_val_82823 === (3))){
var inst_82820 = (state_82822[(2)]);
var state_82822__$1 = state_82822;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82822__$1,inst_82820);
} else {
if((state_val_82823 === (4))){
var inst_82804 = (state_82822[(2)]);
var inst_82805 = fluree.db.util.log.error.call(null,inst_82804);
var inst_82806 = reject.call(null,inst_82804);
var state_82822__$1 = (function (){var statearr_82827 = state_82822;
(statearr_82827[(7)] = inst_82805);

return statearr_82827;
})();
var statearr_82828_82840 = state_82822__$1;
(statearr_82828_82840[(2)] = inst_82806);

(statearr_82828_82840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82823 === (5))){
var _ = (function (){var statearr_82829 = state_82822;
(statearr_82829[(4)] = cljs.core.rest.call(null,(state_82822[(4)])));

return statearr_82829;
})();
var state_82822__$1 = state_82822;
var ex82826 = (state_82822__$1[(2)]);
var statearr_82830_82841 = state_82822__$1;
(statearr_82830_82841[(5)] = ex82826);


var statearr_82831_82842 = state_82822__$1;
(statearr_82831_82842[(1)] = (4));

(statearr_82831_82842[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82823 === (6))){
var inst_82814 = (state_82822[(2)]);
var inst_82815 = fluree.db.util.async.throw_err.call(null,inst_82814);
var inst_82816 = cljs.core.clj__GT_js.call(null,inst_82815);
var inst_82817 = resolve.call(null,inst_82816);
var _ = (function (){var statearr_82832 = state_82822;
(statearr_82832[(4)] = cljs.core.rest.call(null,(state_82822[(4)])));

return statearr_82832;
})();
var state_82822__$1 = state_82822;
var statearr_82833_82843 = state_82822__$1;
(statearr_82833_82843[(2)] = inst_82817);

(statearr_82833_82843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledger_list_$_state_machine__11469__auto__ = null;
var flureenjs$ledger_list_$_state_machine__11469__auto____0 = (function (){
var statearr_82834 = [null,null,null,null,null,null,null,null];
(statearr_82834[(0)] = flureenjs$ledger_list_$_state_machine__11469__auto__);

(statearr_82834[(1)] = (1));

return statearr_82834;
});
var flureenjs$ledger_list_$_state_machine__11469__auto____1 = (function (state_82822){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_82822);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e82835){var ex__11472__auto__ = e82835;
var statearr_82836_82844 = state_82822;
(statearr_82836_82844[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_82822[(4)]))){
var statearr_82837_82845 = state_82822;
(statearr_82837_82845[(1)] = cljs.core.first.call(null,(state_82822[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82846 = state_82822;
state_82822 = G__82846;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$ledger_list_$_state_machine__11469__auto__ = function(state_82822){
switch(arguments.length){
case 0:
return flureenjs$ledger_list_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$ledger_list_$_state_machine__11469__auto____1.call(this,state_82822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledger_list_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledger_list_$_state_machine__11469__auto____0;
flureenjs$ledger_list_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledger_list_$_state_machine__11469__auto____1;
return flureenjs$ledger_list_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_82838 = f__11543__auto__.call(null);
(statearr_82838[(6)] = c__11542__auto__);

return statearr_82838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.ledger_list', flureenjs.ledger_list);
/**
 * Returns promise with ledger's  with ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledger_stats = (function flureenjs$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_82865){
var state_val_82866 = (state_82865[(1)]);
if((state_val_82866 === (1))){
var state_82865__$1 = state_82865;
var statearr_82867_82882 = state_82865__$1;
(statearr_82867_82882[(2)] = null);

(statearr_82867_82882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82866 === (2))){
var _ = (function (){var statearr_82868 = state_82865;
(statearr_82868[(4)] = cljs.core.cons.call(null,(5),(state_82865[(4)])));

return statearr_82868;
})();
var inst_82855 = fluree.db.operations.ledger_stats_async.call(null,conn,ledger);
var state_82865__$1 = state_82865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82865__$1,(6),inst_82855);
} else {
if((state_val_82866 === (3))){
var inst_82863 = (state_82865[(2)]);
var state_82865__$1 = state_82865;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82865__$1,inst_82863);
} else {
if((state_val_82866 === (4))){
var inst_82847 = (state_82865[(2)]);
var inst_82848 = fluree.db.util.log.error.call(null,inst_82847);
var inst_82849 = reject.call(null,inst_82847);
var state_82865__$1 = (function (){var statearr_82870 = state_82865;
(statearr_82870[(7)] = inst_82848);

return statearr_82870;
})();
var statearr_82871_82883 = state_82865__$1;
(statearr_82871_82883[(2)] = inst_82849);

(statearr_82871_82883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82866 === (5))){
var _ = (function (){var statearr_82872 = state_82865;
(statearr_82872[(4)] = cljs.core.rest.call(null,(state_82865[(4)])));

return statearr_82872;
})();
var state_82865__$1 = state_82865;
var ex82869 = (state_82865__$1[(2)]);
var statearr_82873_82884 = state_82865__$1;
(statearr_82873_82884[(5)] = ex82869);


var statearr_82874_82885 = state_82865__$1;
(statearr_82874_82885[(1)] = (4));

(statearr_82874_82885[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82866 === (6))){
var inst_82857 = (state_82865[(2)]);
var inst_82858 = fluree.db.util.async.throw_err.call(null,inst_82857);
var inst_82859 = cljs.core.clj__GT_js.call(null,inst_82858);
var inst_82860 = resolve.call(null,inst_82859);
var _ = (function (){var statearr_82875 = state_82865;
(statearr_82875[(4)] = cljs.core.rest.call(null,(state_82865[(4)])));

return statearr_82875;
})();
var state_82865__$1 = state_82865;
var statearr_82876_82886 = state_82865__$1;
(statearr_82876_82886[(2)] = inst_82860);

(statearr_82876_82886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledger_stats_$_state_machine__11469__auto__ = null;
var flureenjs$ledger_stats_$_state_machine__11469__auto____0 = (function (){
var statearr_82877 = [null,null,null,null,null,null,null,null];
(statearr_82877[(0)] = flureenjs$ledger_stats_$_state_machine__11469__auto__);

(statearr_82877[(1)] = (1));

return statearr_82877;
});
var flureenjs$ledger_stats_$_state_machine__11469__auto____1 = (function (state_82865){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_82865);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e82878){var ex__11472__auto__ = e82878;
var statearr_82879_82887 = state_82865;
(statearr_82879_82887[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_82865[(4)]))){
var statearr_82880_82888 = state_82865;
(statearr_82880_82888[(1)] = cljs.core.first.call(null,(state_82865[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82889 = state_82865;
state_82865 = G__82889;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$ledger_stats_$_state_machine__11469__auto__ = function(state_82865){
switch(arguments.length){
case 0:
return flureenjs$ledger_stats_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$ledger_stats_$_state_machine__11469__auto____1.call(this,state_82865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledger_stats_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledger_stats_$_state_machine__11469__auto____0;
flureenjs$ledger_stats_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledger_stats_$_state_machine__11469__auto____1;
return flureenjs$ledger_stats_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_82881 = f__11543__auto__.call(null);
(statearr_82881[(6)] = c__11542__auto__);

return statearr_82881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.ledger_stats', flureenjs.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than db-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 * 
 */
flureenjs.new_ledger = (function flureenjs$new_ledger(var_args){
var G__82891 = arguments.length;
switch (G__82891) {
case 2:
return flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.new_ledger', flureenjs.new_ledger);

(flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.new_ledger.call(null,conn,ledger,null);
}));

(flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_83029){
var state_val_83030 = (state_83029[(1)]);
if((state_val_83030 === (7))){
var inst_82914 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_83029__$1 = state_83029;
var statearr_83031_83109 = state_83029__$1;
(statearr_83031_83109[(2)] = inst_82914);

(statearr_83031_83109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (20))){
var inst_82953 = (state_83029[(7)]);
var inst_82950 = (state_83029[(8)]);
var inst_82960 = (state_83029[(9)]);
var inst_82960__$1 = (state_83029[(2)]);
var inst_82961 = fluree.db.graphdb.validate_ledger_name.call(null,inst_82960__$1,"ledger");
var inst_82962 = fluree.db.graphdb.validate_ledger_name.call(null,inst_82953,"network");
var state_83029__$1 = (function (){var statearr_83032 = state_83029;
(statearr_83032[(10)] = inst_82962);

(statearr_83032[(9)] = inst_82960__$1);

(statearr_83032[(11)] = inst_82961);

return statearr_83032;
})();
if(cljs.core.truth_(inst_82950)){
var statearr_83033_83110 = state_83029__$1;
(statearr_83033_83110[(1)] = (21));

} else {
var statearr_83034_83111 = state_83029__$1;
(statearr_83034_83111[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (27))){
var inst_82968 = (state_83029[(12)]);
var inst_82969 = (state_83029[(13)]);
var inst_82976 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_82968),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_82969)].join('');
var state_83029__$1 = state_83029;
var statearr_83035_83112 = state_83029__$1;
(statearr_83035_83112[(2)] = inst_82976);

(statearr_83035_83112[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (1))){
var state_83029__$1 = state_83029;
var statearr_83036_83113 = state_83029__$1;
(statearr_83036_83113[(2)] = null);

(statearr_83036_83113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (24))){
var inst_82969 = (state_83029[(13)]);
var inst_82971 = fluree.db.graphdb.validate_ledger_name.call(null,inst_82969,"alias");
var state_83029__$1 = state_83029;
var statearr_83037_83114 = state_83029__$1;
(statearr_83037_83114[(2)] = inst_82971);

(statearr_83037_83114[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (39))){
var inst_82999 = (state_83029[(14)]);
var inst_82943 = (state_83029[(15)]);
var inst_83001 = fluree.crypto.sign_message.call(null,inst_82999,inst_82943);
var state_83029__$1 = state_83029;
var statearr_83038_83115 = state_83029__$1;
(statearr_83038_83115[(2)] = inst_83001);

(statearr_83038_83115[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (46))){
var inst_83016 = (state_83029[(2)]);
var inst_83017 = fluree.db.util.async.throw_err.call(null,inst_83016);
var state_83029__$1 = state_83029;
var statearr_83039_83116 = state_83029__$1;
(statearr_83039_83116[(2)] = inst_83017);

(statearr_83039_83116[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (4))){
var inst_82892 = (state_83029[(2)]);
var inst_82893 = fluree.db.util.log.error.call(null,inst_82892);
var inst_82894 = cljs.core.ex_data.call(null,inst_82892);
var inst_82895 = cljs.core.ex_message.call(null,inst_82892);
var inst_82896 = cljs.core.assoc.call(null,inst_82894,new cljs.core.Keyword(null,"message","message",-406056002),inst_82895);
var inst_82897 = cljs.core.clj__GT_js.call(null,inst_82896);
var inst_82898 = reject.call(null,inst_82897);
var state_83029__$1 = (function (){var statearr_83040 = state_83029;
(statearr_83040[(16)] = inst_82893);

return statearr_83040;
})();
var statearr_83041_83117 = state_83029__$1;
(statearr_83041_83117[(2)] = inst_82898);

(statearr_83041_83117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (15))){
var inst_82916 = (state_83029[(17)]);
var inst_82935 = cljs.core.apply.call(null,cljs.core.hash_map,inst_82916);
var state_83029__$1 = state_83029;
var statearr_83042_83118 = state_83029__$1;
(statearr_83042_83118[(2)] = inst_82935);

(statearr_83042_83118[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (21))){
var inst_82964 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var state_83029__$1 = state_83029;
var statearr_83043_83119 = state_83029__$1;
(statearr_83043_83119[(2)] = inst_82964);

(statearr_83043_83119[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (31))){
var inst_82980 = (state_83029[(18)]);
var state_83029__$1 = state_83029;
var statearr_83044_83120 = state_83029__$1;
(statearr_83044_83120[(2)] = inst_82980);

(statearr_83044_83120[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (32))){
var inst_82947 = (state_83029[(19)]);
var inst_82984 = (state_83029[(2)]);
var state_83029__$1 = (function (){var statearr_83045 = state_83029;
(statearr_83045[(20)] = inst_82984);

return statearr_83045;
})();
if(cljs.core.truth_(inst_82947)){
var statearr_83046_83121 = state_83029__$1;
(statearr_83046_83121[(1)] = (33));

} else {
var statearr_83047_83122 = state_83029__$1;
(statearr_83047_83122[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (40))){
var state_83029__$1 = state_83029;
var statearr_83048_83123 = state_83029__$1;
(statearr_83048_83123[(2)] = null);

(statearr_83048_83123[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (33))){
var inst_82947 = (state_83029[(19)]);
var state_83029__$1 = state_83029;
var statearr_83049_83124 = state_83029__$1;
(statearr_83049_83124[(2)] = inst_82947);

(statearr_83049_83124[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (13))){
var state_83029__$1 = state_83029;
var statearr_83050_83125 = state_83029__$1;
(statearr_83050_83125[(2)] = false);

(statearr_83050_83125[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (22))){
var state_83029__$1 = state_83029;
var statearr_83051_83126 = state_83029__$1;
(statearr_83051_83126[(2)] = null);

(statearr_83051_83126[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (36))){
var inst_82993 = (state_83029[(21)]);
var inst_82995 = fluree.db.util.core.without_nils.call(null,inst_82993);
var inst_82996 = fluree.db.util.json.stringify.call(null,inst_82995);
var state_83029__$1 = state_83029;
var statearr_83052_83127 = state_83029__$1;
(statearr_83052_83127[(2)] = inst_82996);

(statearr_83052_83127[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (41))){
var inst_82943 = (state_83029[(15)]);
var inst_83004 = (state_83029[(2)]);
var state_83029__$1 = (function (){var statearr_83053 = state_83029;
(statearr_83053[(22)] = inst_83004);

return statearr_83053;
})();
if(cljs.core.truth_(inst_82943)){
var statearr_83054_83128 = state_83029__$1;
(statearr_83054_83128[(1)] = (42));

} else {
var statearr_83055_83129 = state_83029__$1;
(statearr_83055_83129[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (43))){
var inst_82993 = (state_83029[(21)]);
var inst_83014 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_82993);
var state_83029__$1 = state_83029;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83029__$1,(46),inst_83014);
} else {
if((state_val_83030 === (29))){
var inst_82941 = (state_83029[(23)]);
var inst_82979 = (state_83029[(2)]);
var inst_82980 = fluree.db.util.core.current_time_millis.call(null);
var state_83029__$1 = (function (){var statearr_83056 = state_83029;
(statearr_83056[(24)] = inst_82979);

(statearr_83056[(18)] = inst_82980);

return statearr_83056;
})();
if(cljs.core.truth_(inst_82941)){
var statearr_83057_83130 = state_83029__$1;
(statearr_83057_83130[(1)] = (30));

} else {
var statearr_83058_83131 = state_83029__$1;
(statearr_83058_83131[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (44))){
var inst_83019 = (state_83029[(2)]);
var inst_83020 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_83021 = [(200),inst_83019];
var inst_83022 = cljs.core.PersistentHashMap.fromArrays(inst_83020,inst_83021);
var inst_83023 = cljs.core.clj__GT_js.call(null,inst_83022);
var inst_83024 = resolve.call(null,inst_83023);
var _ = (function (){var statearr_83059 = state_83029;
(statearr_83059[(4)] = cljs.core.rest.call(null,(state_83029[(4)])));

return statearr_83059;
})();
var state_83029__$1 = state_83029;
var statearr_83060_83132 = state_83029__$1;
(statearr_83060_83132[(2)] = inst_83024);

(statearr_83060_83132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (6))){
var state_83029__$1 = state_83029;
var statearr_83061_83133 = state_83029__$1;
(statearr_83061_83133[(2)] = null);

(statearr_83061_83133[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (28))){
var state_83029__$1 = state_83029;
var statearr_83062_83134 = state_83029__$1;
(statearr_83062_83134[(2)] = null);

(statearr_83062_83134[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (25))){
var state_83029__$1 = state_83029;
var statearr_83063_83135 = state_83029__$1;
(statearr_83063_83135[(2)] = null);

(statearr_83063_83135[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (34))){
var inst_82980 = (state_83029[(18)]);
var inst_82987 = (inst_82980 + (30000));
var state_83029__$1 = state_83029;
var statearr_83064_83136 = state_83029__$1;
(statearr_83064_83136[(2)] = inst_82987);

(statearr_83064_83136[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (17))){
var inst_82954 = (state_83029[(25)]);
var inst_82938 = (state_83029[(2)]);
var inst_82939 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_82940 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_82941 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_82942 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_82943 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_82944 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_82945 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_82946 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_82947 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_82948 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_82949 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_82950 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_82951 = cljs.core.get.call(null,inst_82938,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_82952 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var inst_82953 = cljs.core.nth.call(null,inst_82952,(0),null);
var inst_82954__$1 = cljs.core.nth.call(null,inst_82952,(1),null);
var inst_82955 = clojure.string.starts_with_QMARK_.call(null,inst_82954__$1,"$");
var state_83029__$1 = (function (){var statearr_83065 = state_83029;
(statearr_83065[(26)] = inst_82944);

(statearr_83065[(19)] = inst_82947);

(statearr_83065[(7)] = inst_82953);

(statearr_83065[(27)] = inst_82945);

(statearr_83065[(28)] = inst_82940);

(statearr_83065[(29)] = inst_82949);

(statearr_83065[(8)] = inst_82950);

(statearr_83065[(25)] = inst_82954__$1);

(statearr_83065[(30)] = inst_82946);

(statearr_83065[(31)] = inst_82942);

(statearr_83065[(32)] = inst_82939);

(statearr_83065[(33)] = inst_82951);

(statearr_83065[(34)] = inst_82948);

(statearr_83065[(15)] = inst_82943);

(statearr_83065[(23)] = inst_82941);

return statearr_83065;
})();
if(inst_82955){
var statearr_83066_83137 = state_83029__$1;
(statearr_83066_83137[(1)] = (18));

} else {
var statearr_83067_83138 = state_83029__$1;
(statearr_83067_83138[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (3))){
var inst_83027 = (state_83029[(2)]);
var state_83029__$1 = state_83029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83029__$1,inst_83027);
} else {
if((state_val_83030 === (12))){
var state_83029__$1 = state_83029;
var statearr_83068_83139 = state_83029__$1;
(statearr_83068_83139[(2)] = true);

(statearr_83068_83139[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (2))){
var _ = (function (){var statearr_83069 = state_83029;
(statearr_83069[(4)] = cljs.core.cons.call(null,(5),(state_83029[(4)])));

return statearr_83069;
})();
var inst_82911 = (opts == null);
var state_83029__$1 = state_83029;
if(cljs.core.truth_(inst_82911)){
var statearr_83070_83140 = state_83029__$1;
(statearr_83070_83140[(1)] = (6));

} else {
var statearr_83071_83141 = state_83029__$1;
(statearr_83071_83141[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (23))){
var inst_82950 = (state_83029[(8)]);
var inst_82967 = (state_83029[(2)]);
var inst_82968 = cljs.core.nth.call(null,inst_82967,(0),null);
var inst_82969 = cljs.core.nth.call(null,inst_82967,(1),null);
var state_83029__$1 = (function (){var statearr_83072 = state_83029;
(statearr_83072[(12)] = inst_82968);

(statearr_83072[(13)] = inst_82969);

return statearr_83072;
})();
if(cljs.core.truth_(inst_82950)){
var statearr_83073_83142 = state_83029__$1;
(statearr_83073_83142[(1)] = (24));

} else {
var statearr_83074_83143 = state_83029__$1;
(statearr_83074_83143[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (35))){
var inst_82944 = (state_83029[(26)]);
var inst_82953 = (state_83029[(7)]);
var inst_82945 = (state_83029[(27)]);
var inst_82940 = (state_83029[(28)]);
var inst_82949 = (state_83029[(29)]);
var inst_82979 = (state_83029[(24)]);
var inst_82946 = (state_83029[(30)]);
var inst_82942 = (state_83029[(31)]);
var inst_82951 = (state_83029[(33)]);
var inst_82948 = (state_83029[(34)]);
var inst_82984 = (state_83029[(20)]);
var inst_82960 = (state_83029[(9)]);
var inst_82943 = (state_83029[(15)]);
var inst_82989 = (state_83029[(2)]);
var inst_82990 = [new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_82991 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_82953),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_82960)].join('');
var inst_82992 = [inst_82945,inst_82946,inst_82991,new cljs.core.Keyword(null,"new-db","new-db",1305352401),inst_82989,inst_82948,inst_82979,inst_82951,inst_82949,inst_82940,inst_82984,inst_82942,inst_82944];
var inst_82993 = cljs.core.PersistentHashMap.fromArrays(inst_82990,inst_82992);
var state_83029__$1 = (function (){var statearr_83075 = state_83029;
(statearr_83075[(21)] = inst_82993);

return statearr_83075;
})();
if(cljs.core.truth_(inst_82943)){
var statearr_83076_83144 = state_83029__$1;
(statearr_83076_83144[(1)] = (36));

} else {
var statearr_83077_83145 = state_83029__$1;
(statearr_83077_83145[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (19))){
var inst_82954 = (state_83029[(25)]);
var state_83029__$1 = state_83029;
var statearr_83078_83146 = state_83029__$1;
(statearr_83078_83146[(2)] = inst_82954);

(statearr_83078_83146[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (11))){
var inst_82933 = (state_83029[(2)]);
var state_83029__$1 = state_83029;
if(cljs.core.truth_(inst_82933)){
var statearr_83080_83147 = state_83029__$1;
(statearr_83080_83147[(1)] = (15));

} else {
var statearr_83081_83148 = state_83029__$1;
(statearr_83081_83148[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (9))){
var inst_82916 = (state_83029[(17)]);
var inst_82922 = inst_82916.cljs$lang$protocol_mask$partition0$;
var inst_82923 = (inst_82922 & (64));
var inst_82924 = inst_82916.cljs$core$ISeq$;
var inst_82925 = (cljs.core.PROTOCOL_SENTINEL === inst_82924);
var inst_82926 = ((inst_82923) || (inst_82925));
var state_83029__$1 = state_83029;
if(cljs.core.truth_(inst_82926)){
var statearr_83082_83149 = state_83029__$1;
(statearr_83082_83149[(1)] = (12));

} else {
var statearr_83083_83150 = state_83029__$1;
(statearr_83083_83150[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (5))){
var _ = (function (){var statearr_83084 = state_83029;
(statearr_83084[(4)] = cljs.core.rest.call(null,(state_83029[(4)])));

return statearr_83084;
})();
var state_83029__$1 = state_83029;
var ex83079 = (state_83029__$1[(2)]);
var statearr_83085_83151 = state_83029__$1;
(statearr_83085_83151[(5)] = ex83079);


var statearr_83086_83152 = state_83029__$1;
(statearr_83086_83152[(1)] = (4));

(statearr_83086_83152[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (14))){
var inst_82930 = (state_83029[(2)]);
var state_83029__$1 = state_83029;
var statearr_83087_83153 = state_83029__$1;
(statearr_83087_83153[(2)] = inst_82930);

(statearr_83087_83153[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (45))){
var inst_83011 = (state_83029[(2)]);
var inst_83012 = fluree.db.util.async.throw_err.call(null,inst_83011);
var state_83029__$1 = state_83029;
var statearr_83088_83154 = state_83029__$1;
(statearr_83088_83154[(2)] = inst_83012);

(statearr_83088_83154[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (26))){
var inst_82950 = (state_83029[(8)]);
var inst_82974 = (state_83029[(2)]);
var state_83029__$1 = (function (){var statearr_83089 = state_83029;
(statearr_83089[(35)] = inst_82974);

return statearr_83089;
})();
if(cljs.core.truth_(inst_82950)){
var statearr_83090_83155 = state_83029__$1;
(statearr_83090_83155[(1)] = (27));

} else {
var statearr_83091_83156 = state_83029__$1;
(statearr_83091_83156[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (16))){
var inst_82916 = (state_83029[(17)]);
var state_83029__$1 = state_83029;
var statearr_83092_83157 = state_83029__$1;
(statearr_83092_83157[(2)] = inst_82916);

(statearr_83092_83157[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (38))){
var inst_82943 = (state_83029[(15)]);
var inst_82999 = (state_83029[(2)]);
var state_83029__$1 = (function (){var statearr_83093 = state_83029;
(statearr_83093[(14)] = inst_82999);

return statearr_83093;
})();
if(cljs.core.truth_(inst_82943)){
var statearr_83094_83158 = state_83029__$1;
(statearr_83094_83158[(1)] = (39));

} else {
var statearr_83095_83159 = state_83029__$1;
(statearr_83095_83159[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (30))){
var inst_82941 = (state_83029[(23)]);
var state_83029__$1 = state_83029;
var statearr_83096_83160 = state_83029__$1;
(statearr_83096_83160[(2)] = inst_82941);

(statearr_83096_83160[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (10))){
var state_83029__$1 = state_83029;
var statearr_83097_83161 = state_83029__$1;
(statearr_83097_83161[(2)] = false);

(statearr_83097_83161[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (18))){
var inst_82954 = (state_83029[(25)]);
var inst_82957 = cljs.core.subs.call(null,inst_82954,(1));
var state_83029__$1 = state_83029;
var statearr_83098_83162 = state_83029__$1;
(statearr_83098_83162[(2)] = inst_82957);

(statearr_83098_83162[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (42))){
var inst_82999 = (state_83029[(14)]);
var inst_83004 = (state_83029[(22)]);
var inst_83006 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_83007 = [inst_82999,inst_83004];
var inst_83008 = cljs.core.PersistentHashMap.fromArrays(inst_83006,inst_83007);
var inst_83009 = fluree.db.operations.command_async.call(null,conn,inst_83008);
var state_83029__$1 = state_83029;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83029__$1,(45),inst_83009);
} else {
if((state_val_83030 === (37))){
var state_83029__$1 = state_83029;
var statearr_83099_83163 = state_83029__$1;
(statearr_83099_83163[(2)] = null);

(statearr_83099_83163[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83030 === (8))){
var inst_82916 = (state_83029[(17)]);
var inst_82916__$1 = (state_83029[(2)]);
var inst_82917 = fluree.db.connection_js.check_connection.call(null,conn,inst_82916__$1);
var inst_82919 = (inst_82916__$1 == null);
var inst_82920 = cljs.core.not.call(null,inst_82919);
var state_83029__$1 = (function (){var statearr_83100 = state_83029;
(statearr_83100[(36)] = inst_82917);

(statearr_83100[(17)] = inst_82916__$1);

return statearr_83100;
})();
if(inst_82920){
var statearr_83101_83164 = state_83029__$1;
(statearr_83101_83164[(1)] = (9));

} else {
var statearr_83102_83165 = state_83029__$1;
(statearr_83102_83165[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_83103 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83103[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_83103[(1)] = (1));

return statearr_83103;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_83029){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_83029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e83104){var ex__11472__auto__ = e83104;
var statearr_83105_83166 = state_83029;
(statearr_83105_83166[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_83029[(4)]))){
var statearr_83106_83167 = state_83029;
(statearr_83106_83167[(1)] = cljs.core.first.call(null,(state_83029[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83168 = state_83029;
state_83029 = G__83168;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_83029){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_83029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_83107 = f__11543__auto__.call(null);
(statearr_83107[(6)] = c__11542__auto__);

return statearr_83107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Resolves a ledger identity in the form of 'network/ledger-or-alias' and returns a
 *   tuple of either [network ledger alias] or [network ledger].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger id.
 * 
 *   If you are providing a ledger id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the db-ident.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias or id of testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 */
flureenjs.resolve_ledger = (function flureenjs$resolve_ledger(conn,ledger){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_83184){
var state_val_83185 = (state_83184[(1)]);
if((state_val_83185 === (1))){
var state_83184__$1 = state_83184;
var statearr_83186_83201 = state_83184__$1;
(statearr_83186_83201[(2)] = null);

(statearr_83186_83201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83185 === (2))){
var _ = (function (){var statearr_83187 = state_83184;
(statearr_83187[(4)] = cljs.core.cons.call(null,(5),(state_83184[(4)])));

return statearr_83187;
})();
var inst_83177 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_83178 = cljs.core.clj__GT_js.call(null,inst_83177);
var inst_83179 = resolve.call(null,inst_83178);
var ___$1 = (function (){var statearr_83188 = state_83184;
(statearr_83188[(4)] = cljs.core.rest.call(null,(state_83184[(4)])));

return statearr_83188;
})();
var state_83184__$1 = state_83184;
var statearr_83189_83202 = state_83184__$1;
(statearr_83189_83202[(2)] = inst_83179);

(statearr_83189_83202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83185 === (3))){
var inst_83182 = (state_83184[(2)]);
var state_83184__$1 = state_83184;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83184__$1,inst_83182);
} else {
if((state_val_83185 === (4))){
var inst_83169 = (state_83184[(2)]);
var inst_83170 = fluree.db.util.log.error.call(null,inst_83169);
var inst_83171 = reject.call(null,inst_83169);
var state_83184__$1 = (function (){var statearr_83191 = state_83184;
(statearr_83191[(7)] = inst_83170);

return statearr_83191;
})();
var statearr_83192_83203 = state_83184__$1;
(statearr_83192_83203[(2)] = inst_83171);

(statearr_83192_83203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83185 === (5))){
var _ = (function (){var statearr_83193 = state_83184;
(statearr_83193[(4)] = cljs.core.rest.call(null,(state_83184[(4)])));

return statearr_83193;
})();
var state_83184__$1 = state_83184;
var ex83190 = (state_83184__$1[(2)]);
var statearr_83194_83204 = state_83184__$1;
(statearr_83194_83204[(5)] = ex83190);


var statearr_83195_83205 = state_83184__$1;
(statearr_83195_83205[(1)] = (4));

(statearr_83195_83205[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$resolve_ledger_$_state_machine__11469__auto__ = null;
var flureenjs$resolve_ledger_$_state_machine__11469__auto____0 = (function (){
var statearr_83196 = [null,null,null,null,null,null,null,null];
(statearr_83196[(0)] = flureenjs$resolve_ledger_$_state_machine__11469__auto__);

(statearr_83196[(1)] = (1));

return statearr_83196;
});
var flureenjs$resolve_ledger_$_state_machine__11469__auto____1 = (function (state_83184){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_83184);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e83197){var ex__11472__auto__ = e83197;
var statearr_83198_83206 = state_83184;
(statearr_83198_83206[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_83184[(4)]))){
var statearr_83199_83207 = state_83184;
(statearr_83199_83207[(1)] = cljs.core.first.call(null,(state_83184[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83208 = state_83184;
state_83184 = G__83208;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$resolve_ledger_$_state_machine__11469__auto__ = function(state_83184){
switch(arguments.length){
case 0:
return flureenjs$resolve_ledger_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$resolve_ledger_$_state_machine__11469__auto____1.call(this,state_83184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$resolve_ledger_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$resolve_ledger_$_state_machine__11469__auto____0;
flureenjs$resolve_ledger_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$resolve_ledger_$_state_machine__11469__auto____1;
return flureenjs$resolve_ledger_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_83200 = f__11543__auto__.call(null);
(statearr_83200[(6)] = c__11542__auto__);

return statearr_83200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.resolve_ledger', flureenjs.resolve_ledger);
/**
 * Returns actual session object for a given ledger.
 */
flureenjs.session = (function flureenjs$session(conn,ledger){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_83224){
var state_val_83225 = (state_83224[(1)]);
if((state_val_83225 === (1))){
var state_83224__$1 = state_83224;
var statearr_83226_83241 = state_83224__$1;
(statearr_83226_83241[(2)] = null);

(statearr_83226_83241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83225 === (2))){
var _ = (function (){var statearr_83227 = state_83224;
(statearr_83227[(4)] = cljs.core.cons.call(null,(5),(state_83224[(4)])));

return statearr_83227;
})();
var inst_83217 = fluree.db.session.session.call(null,conn,ledger);
var inst_83218 = cljs.core.clj__GT_js.call(null,inst_83217);
var inst_83219 = resolve.call(null,inst_83218);
var ___$1 = (function (){var statearr_83228 = state_83224;
(statearr_83228[(4)] = cljs.core.rest.call(null,(state_83224[(4)])));

return statearr_83228;
})();
var state_83224__$1 = state_83224;
var statearr_83229_83242 = state_83224__$1;
(statearr_83229_83242[(2)] = inst_83219);

(statearr_83229_83242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83225 === (3))){
var inst_83222 = (state_83224[(2)]);
var state_83224__$1 = state_83224;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83224__$1,inst_83222);
} else {
if((state_val_83225 === (4))){
var inst_83209 = (state_83224[(2)]);
var inst_83210 = fluree.db.util.log.error.call(null,inst_83209);
var inst_83211 = reject.call(null,inst_83209);
var state_83224__$1 = (function (){var statearr_83231 = state_83224;
(statearr_83231[(7)] = inst_83210);

return statearr_83231;
})();
var statearr_83232_83243 = state_83224__$1;
(statearr_83232_83243[(2)] = inst_83211);

(statearr_83232_83243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83225 === (5))){
var _ = (function (){var statearr_83233 = state_83224;
(statearr_83233[(4)] = cljs.core.rest.call(null,(state_83224[(4)])));

return statearr_83233;
})();
var state_83224__$1 = state_83224;
var ex83230 = (state_83224__$1[(2)]);
var statearr_83234_83244 = state_83224__$1;
(statearr_83234_83244[(5)] = ex83230);


var statearr_83235_83245 = state_83224__$1;
(statearr_83235_83245[(1)] = (4));

(statearr_83235_83245[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$session_$_state_machine__11469__auto__ = null;
var flureenjs$session_$_state_machine__11469__auto____0 = (function (){
var statearr_83236 = [null,null,null,null,null,null,null,null];
(statearr_83236[(0)] = flureenjs$session_$_state_machine__11469__auto__);

(statearr_83236[(1)] = (1));

return statearr_83236;
});
var flureenjs$session_$_state_machine__11469__auto____1 = (function (state_83224){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_83224);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e83237){var ex__11472__auto__ = e83237;
var statearr_83238_83246 = state_83224;
(statearr_83238_83246[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_83224[(4)]))){
var statearr_83239_83247 = state_83224;
(statearr_83239_83247[(1)] = cljs.core.first.call(null,(state_83224[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83248 = state_83224;
state_83224 = G__83248;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$session_$_state_machine__11469__auto__ = function(state_83224){
switch(arguments.length){
case 0:
return flureenjs$session_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$session_$_state_machine__11469__auto____1.call(this,state_83224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$session_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$session_$_state_machine__11469__auto____0;
flureenjs$session_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$session_$_state_machine__11469__auto____1;
return flureenjs$session_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_83240 = f__11543__auto__.call(null);
(statearr_83240[(6)] = c__11542__auto__);

return statearr_83240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.session', flureenjs.session);
flureenjs.block_Flakes__GT_vector = (function flureenjs$block_Flakes__GT_vector(blocks){
var G__83252 = blocks;
var vec__83253 = G__83252;
var seq__83254 = cljs.core.seq.call(null,vec__83253);
var first__83255 = cljs.core.first.call(null,seq__83254);
var seq__83254__$1 = cljs.core.next.call(null,seq__83254);
var block = first__83255;
var r = seq__83254__$1;
var acc = cljs.core.PersistentVector.EMPTY;
var G__83252__$1 = G__83252;
var acc__$1 = acc;
while(true){
var vec__83259 = G__83252__$1;
var seq__83260 = cljs.core.seq.call(null,vec__83259);
var first__83261 = cljs.core.first.call(null,seq__83260);
var seq__83260__$1 = cljs.core.next.call(null,seq__83260);
var block__$1 = first__83261;
var r__$1 = seq__83260__$1;
var acc__$2 = acc__$1;
if(cljs.core.truth_(block__$1)){
var flakes = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block__$1));
var G__83262 = r__$1;
var G__83263 = cljs.core.into.call(null,acc__$2,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,block__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes)], null));
G__83252__$1 = G__83262;
acc__$1 = G__83263;
continue;
} else {
return acc__$2;
}
break;
}
});
/**
 * Returns a promise containing search results of flake parts (flake-parts).
 */
flureenjs.search = (function flureenjs$search(db,flake_parts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_83287){
var state_val_83288 = (state_83287[(1)]);
if((state_val_83288 === (1))){
var state_83287__$1 = state_83287;
var statearr_83289_83305 = state_83287__$1;
(statearr_83289_83305[(2)] = null);

(statearr_83289_83305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83288 === (2))){
var _ = (function (){var statearr_83290 = state_83287;
(statearr_83290[(4)] = cljs.core.cons.call(null,(5),(state_83287[(4)])));

return statearr_83290;
})();
var inst_83272 = cljs.core.js__GT_clj.call(null,flake_parts);
var state_83287__$1 = (function (){var statearr_83291 = state_83287;
(statearr_83291[(7)] = inst_83272);

return statearr_83291;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83287__$1,(7),db);
} else {
if((state_val_83288 === (3))){
var inst_83285 = (state_83287[(2)]);
var state_83287__$1 = state_83287;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83287__$1,inst_83285);
} else {
if((state_val_83288 === (4))){
var inst_83264 = (state_83287[(2)]);
var inst_83265 = fluree.db.util.log.error.call(null,inst_83264);
var inst_83266 = reject.call(null,inst_83264);
var state_83287__$1 = (function (){var statearr_83293 = state_83287;
(statearr_83293[(8)] = inst_83265);

return statearr_83293;
})();
var statearr_83294_83306 = state_83287__$1;
(statearr_83294_83306[(2)] = inst_83266);

(statearr_83294_83306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83288 === (5))){
var _ = (function (){var statearr_83295 = state_83287;
(statearr_83295[(4)] = cljs.core.rest.call(null,(state_83287[(4)])));

return statearr_83295;
})();
var state_83287__$1 = state_83287;
var ex83292 = (state_83287__$1[(2)]);
var statearr_83296_83307 = state_83287__$1;
(statearr_83296_83307[(5)] = ex83292);


var statearr_83297_83308 = state_83287__$1;
(statearr_83297_83308[(1)] = (4));

(statearr_83297_83308[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83288 === (6))){
var inst_83278 = (state_83287[(2)]);
var inst_83279 = fluree.db.util.async.throw_err.call(null,inst_83278);
var inst_83280 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_83279);
var inst_83281 = cljs.core.clj__GT_js.call(null,inst_83280);
var inst_83282 = resolve.call(null,inst_83281);
var _ = (function (){var statearr_83298 = state_83287;
(statearr_83298[(4)] = cljs.core.rest.call(null,(state_83287[(4)])));

return statearr_83298;
})();
var state_83287__$1 = state_83287;
var statearr_83299_83309 = state_83287__$1;
(statearr_83299_83309[(2)] = inst_83282);

(statearr_83299_83309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83288 === (7))){
var inst_83272 = (state_83287[(7)]);
var inst_83274 = (state_83287[(2)]);
var inst_83275 = fluree.db.util.async.throw_err.call(null,inst_83274);
var inst_83276 = fluree.db.dbproto._search.call(null,inst_83275,inst_83272);
var state_83287__$1 = state_83287;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83287__$1,(6),inst_83276);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$search_$_state_machine__11469__auto__ = null;
var flureenjs$search_$_state_machine__11469__auto____0 = (function (){
var statearr_83300 = [null,null,null,null,null,null,null,null,null];
(statearr_83300[(0)] = flureenjs$search_$_state_machine__11469__auto__);

(statearr_83300[(1)] = (1));

return statearr_83300;
});
var flureenjs$search_$_state_machine__11469__auto____1 = (function (state_83287){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_83287);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e83301){var ex__11472__auto__ = e83301;
var statearr_83302_83310 = state_83287;
(statearr_83302_83310[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_83287[(4)]))){
var statearr_83303_83311 = state_83287;
(statearr_83303_83311[(1)] = cljs.core.first.call(null,(state_83287[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83312 = state_83287;
state_83287 = G__83312;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$search_$_state_machine__11469__auto__ = function(state_83287){
switch(arguments.length){
case 0:
return flureenjs$search_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$search_$_state_machine__11469__auto____1.call(this,state_83287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$search_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$search_$_state_machine__11469__auto____0;
flureenjs$search_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$search_$_state_machine__11469__auto____1;
return flureenjs$search_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_83304 = f__11543__auto__.call(null);
(statearr_83304[(6)] = c__11542__auto__);

return statearr_83304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.search', flureenjs.search);
/**
 * Returns a promise containing a new db based on the provided db,
 * including the provided flakes. Flakes can contain one or more 't's,
 * but should be sequential and start after the current 't' of the provided
 * db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.). Remember
 * 't' is negative and thus should be in descending order.
 * 
 * A forward-time-travel db can be further forward-time-traveled.
 * 
 * A forward-time travel DB is held in memory, and is not shared across servers.
 * Ensure you have adequate memory to hold the flakes you generate and add. If
 * access is provided via an external API, do any desired size restrictions or
 * controls within your API endpoint.
 * 
 * Remember schema operations done via forward-time-travel should be done in a
 * 't' prior to the flakes that end up requiring the schema change.
 */
flureenjs.forward_time_travel = (function flureenjs$forward_time_travel(db,flakes){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_83333){
var state_val_83334 = (state_83333[(1)]);
if((state_val_83334 === (1))){
var state_83333__$1 = state_83333;
var statearr_83335_83351 = state_83333__$1;
(statearr_83335_83351[(2)] = null);

(statearr_83335_83351[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83334 === (2))){
var _ = (function (){var statearr_83336 = state_83333;
(statearr_83336[(4)] = cljs.core.cons.call(null,(5),(state_83333[(4)])));

return statearr_83336;
})();
var inst_83321 = cljs.core.js__GT_clj.call(null,flakes);
var inst_83322 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_83321);
var state_83333__$1 = (function (){var statearr_83337 = state_83333;
(statearr_83337[(7)] = inst_83322);

return statearr_83337;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83333__$1,(6),db);
} else {
if((state_val_83334 === (3))){
var inst_83331 = (state_83333[(2)]);
var state_83333__$1 = state_83333;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83333__$1,inst_83331);
} else {
if((state_val_83334 === (4))){
var inst_83313 = (state_83333[(2)]);
var inst_83314 = fluree.db.util.log.error.call(null,inst_83313);
var inst_83315 = reject.call(null,inst_83313);
var state_83333__$1 = (function (){var statearr_83339 = state_83333;
(statearr_83339[(8)] = inst_83314);

return statearr_83339;
})();
var statearr_83340_83352 = state_83333__$1;
(statearr_83340_83352[(2)] = inst_83315);

(statearr_83340_83352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83334 === (5))){
var _ = (function (){var statearr_83341 = state_83333;
(statearr_83341[(4)] = cljs.core.rest.call(null,(state_83333[(4)])));

return statearr_83341;
})();
var state_83333__$1 = state_83333;
var ex83338 = (state_83333__$1[(2)]);
var statearr_83342_83353 = state_83333__$1;
(statearr_83342_83353[(5)] = ex83338);


var statearr_83343_83354 = state_83333__$1;
(statearr_83343_83354[(1)] = (4));

(statearr_83343_83354[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83334 === (6))){
var inst_83322 = (state_83333[(7)]);
var inst_83324 = (state_83333[(2)]);
var inst_83325 = fluree.db.util.async.throw_err.call(null,inst_83324);
var inst_83326 = fluree.db.graphdb.forward_time_travel.call(null,inst_83325,null,inst_83322);
var inst_83327 = cljs.core.clj__GT_js.call(null,inst_83326);
var inst_83328 = resolve.call(null,inst_83327);
var _ = (function (){var statearr_83344 = state_83333;
(statearr_83344[(4)] = cljs.core.rest.call(null,(state_83333[(4)])));

return statearr_83344;
})();
var state_83333__$1 = state_83333;
var statearr_83345_83355 = state_83333__$1;
(statearr_83345_83355[(2)] = inst_83328);

(statearr_83345_83355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$forward_time_travel_$_state_machine__11469__auto__ = null;
var flureenjs$forward_time_travel_$_state_machine__11469__auto____0 = (function (){
var statearr_83346 = [null,null,null,null,null,null,null,null,null];
(statearr_83346[(0)] = flureenjs$forward_time_travel_$_state_machine__11469__auto__);

(statearr_83346[(1)] = (1));

return statearr_83346;
});
var flureenjs$forward_time_travel_$_state_machine__11469__auto____1 = (function (state_83333){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_83333);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e83347){var ex__11472__auto__ = e83347;
var statearr_83348_83356 = state_83333;
(statearr_83348_83356[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_83333[(4)]))){
var statearr_83349_83357 = state_83333;
(statearr_83349_83357[(1)] = cljs.core.first.call(null,(state_83333[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83358 = state_83333;
state_83333 = G__83358;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$forward_time_travel_$_state_machine__11469__auto__ = function(state_83333){
switch(arguments.length){
case 0:
return flureenjs$forward_time_travel_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$forward_time_travel_$_state_machine__11469__auto____1.call(this,state_83333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$forward_time_travel_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$forward_time_travel_$_state_machine__11469__auto____0;
flureenjs$forward_time_travel_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$forward_time_travel_$_state_machine__11469__auto____1;
return flureenjs$forward_time_travel_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_83350 = f__11543__auto__.call(null);
(statearr_83350[(6)] = c__11542__auto__);

return statearr_83350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.forward_time_travel', flureenjs.forward_time_travel);
/**
 * Returns true if provided db is a forward-time-travel db.
 */
flureenjs.is_forward_time_travel_db = (function flureenjs$is_forward_time_travel_db(db){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_83382){
var state_val_83383 = (state_83382[(1)]);
if((state_val_83383 === (7))){
var state_83382__$1 = state_83382;
var statearr_83384_83403 = state_83382__$1;
(statearr_83384_83403[(2)] = db);

(statearr_83384_83403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83383 === (1))){
var state_83382__$1 = state_83382;
var statearr_83385_83404 = state_83382__$1;
(statearr_83385_83404[(2)] = null);

(statearr_83385_83404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83383 === (4))){
var inst_83359 = (state_83382[(2)]);
var inst_83360 = fluree.db.util.log.error.call(null,inst_83359);
var inst_83361 = reject.call(null,inst_83359);
var state_83382__$1 = (function (){var statearr_83386 = state_83382;
(statearr_83386[(7)] = inst_83360);

return statearr_83386;
})();
var statearr_83387_83405 = state_83382__$1;
(statearr_83387_83405[(2)] = inst_83361);

(statearr_83387_83405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83383 === (6))){
var state_83382__$1 = state_83382;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83382__$1,(9),db);
} else {
if((state_val_83383 === (3))){
var inst_83380 = (state_83382[(2)]);
var state_83382__$1 = state_83382;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83382__$1,inst_83380);
} else {
if((state_val_83383 === (2))){
var _ = (function (){var statearr_83389 = state_83382;
(statearr_83389[(4)] = cljs.core.cons.call(null,(5),(state_83382[(4)])));

return statearr_83389;
})();
var inst_83367 = fluree.db.util.async.channel_QMARK_.call(null,db);
var state_83382__$1 = state_83382;
if(inst_83367){
var statearr_83390_83406 = state_83382__$1;
(statearr_83390_83406[(1)] = (6));

} else {
var statearr_83391_83407 = state_83382__$1;
(statearr_83391_83407[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83383 === (9))){
var inst_83370 = (state_83382[(2)]);
var inst_83371 = fluree.db.util.async.throw_err.call(null,inst_83370);
var state_83382__$1 = state_83382;
var statearr_83392_83408 = state_83382__$1;
(statearr_83392_83408[(2)] = inst_83371);

(statearr_83392_83408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83383 === (5))){
var _ = (function (){var statearr_83393 = state_83382;
(statearr_83393[(4)] = cljs.core.rest.call(null,(state_83382[(4)])));

return statearr_83393;
})();
var state_83382__$1 = state_83382;
var ex83388 = (state_83382__$1[(2)]);
var statearr_83394_83409 = state_83382__$1;
(statearr_83394_83409[(5)] = ex83388);


var statearr_83395_83410 = state_83382__$1;
(statearr_83395_83410[(1)] = (4));

(statearr_83395_83410[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83383 === (8))){
var inst_83374 = (state_83382[(2)]);
var inst_83375 = fluree.db.graphdb.forward_time_travel_db_QMARK_.call(null,inst_83374);
var inst_83376 = cljs.core.clj__GT_js.call(null,inst_83375);
var inst_83377 = resolve.call(null,inst_83376);
var _ = (function (){var statearr_83396 = state_83382;
(statearr_83396[(4)] = cljs.core.rest.call(null,(state_83382[(4)])));

return statearr_83396;
})();
var state_83382__$1 = state_83382;
var statearr_83397_83411 = state_83382__$1;
(statearr_83397_83411[(2)] = inst_83377);

(statearr_83397_83411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$is_forward_time_travel_db_$_state_machine__11469__auto__ = null;
var flureenjs$is_forward_time_travel_db_$_state_machine__11469__auto____0 = (function (){
var statearr_83398 = [null,null,null,null,null,null,null,null];
(statearr_83398[(0)] = flureenjs$is_forward_time_travel_db_$_state_machine__11469__auto__);

(statearr_83398[(1)] = (1));

return statearr_83398;
});
var flureenjs$is_forward_time_travel_db_$_state_machine__11469__auto____1 = (function (state_83382){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_83382);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e83399){var ex__11472__auto__ = e83399;
var statearr_83400_83412 = state_83382;
(statearr_83400_83412[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_83382[(4)]))){
var statearr_83401_83413 = state_83382;
(statearr_83401_83413[(1)] = cljs.core.first.call(null,(state_83382[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83414 = state_83382;
state_83382 = G__83414;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$is_forward_time_travel_db_$_state_machine__11469__auto__ = function(state_83382){
switch(arguments.length){
case 0:
return flureenjs$is_forward_time_travel_db_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$is_forward_time_travel_db_$_state_machine__11469__auto____1.call(this,state_83382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$is_forward_time_travel_db_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$is_forward_time_travel_db_$_state_machine__11469__auto____0;
flureenjs$is_forward_time_travel_db_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$is_forward_time_travel_db_$_state_machine__11469__auto____1;
return flureenjs$is_forward_time_travel_db_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_83402 = f__11543__auto__.call(null);
(statearr_83402[(6)] = c__11542__auto__);

return statearr_83402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.is_forward_time_travel_db', flureenjs.is_forward_time_travel_db);
/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureenjs.monitor_tx = (function flureenjs$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_83434){
var state_val_83435 = (state_83434[(1)]);
if((state_val_83435 === (1))){
var state_83434__$1 = state_83434;
var statearr_83436_83452 = state_83434__$1;
(statearr_83436_83452[(2)] = null);

(statearr_83436_83452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83435 === (2))){
var _ = (function (){var statearr_83437 = state_83434;
(statearr_83437[(4)] = cljs.core.cons.call(null,(5),(state_83434[(4)])));

return statearr_83437;
})();
var inst_83424 = fluree.db.connection_js.check_connection.call(null,conn);
var inst_83425 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,txid,timeout_ms);
var state_83434__$1 = (function (){var statearr_83438 = state_83434;
(statearr_83438[(7)] = inst_83424);

return statearr_83438;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83434__$1,(6),inst_83425);
} else {
if((state_val_83435 === (3))){
var inst_83432 = (state_83434[(2)]);
var state_83434__$1 = state_83434;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83434__$1,inst_83432);
} else {
if((state_val_83435 === (4))){
var inst_83415 = (state_83434[(2)]);
var inst_83416 = fluree.db.util.log.error.call(null,inst_83415);
var inst_83417 = cljs.core.clj__GT_js.call(null,inst_83415);
var inst_83418 = reject.call(null,inst_83417);
var state_83434__$1 = (function (){var statearr_83440 = state_83434;
(statearr_83440[(8)] = inst_83416);

return statearr_83440;
})();
var statearr_83441_83453 = state_83434__$1;
(statearr_83441_83453[(2)] = inst_83418);

(statearr_83441_83453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83435 === (5))){
var _ = (function (){var statearr_83442 = state_83434;
(statearr_83442[(4)] = cljs.core.rest.call(null,(state_83434[(4)])));

return statearr_83442;
})();
var state_83434__$1 = state_83434;
var ex83439 = (state_83434__$1[(2)]);
var statearr_83443_83454 = state_83434__$1;
(statearr_83443_83454[(5)] = ex83439);


var statearr_83444_83455 = state_83434__$1;
(statearr_83444_83455[(1)] = (4));

(statearr_83444_83455[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83435 === (6))){
var inst_83427 = (state_83434[(2)]);
var inst_83428 = cljs.core.clj__GT_js.call(null,inst_83427);
var inst_83429 = resolve.call(null,inst_83428);
var _ = (function (){var statearr_83445 = state_83434;
(statearr_83445[(4)] = cljs.core.rest.call(null,(state_83434[(4)])));

return statearr_83445;
})();
var state_83434__$1 = state_83434;
var statearr_83446_83456 = state_83434__$1;
(statearr_83446_83456[(2)] = inst_83429);

(statearr_83446_83456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$monitor_tx_$_state_machine__11469__auto__ = null;
var flureenjs$monitor_tx_$_state_machine__11469__auto____0 = (function (){
var statearr_83447 = [null,null,null,null,null,null,null,null,null];
(statearr_83447[(0)] = flureenjs$monitor_tx_$_state_machine__11469__auto__);

(statearr_83447[(1)] = (1));

return statearr_83447;
});
var flureenjs$monitor_tx_$_state_machine__11469__auto____1 = (function (state_83434){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_83434);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e83448){var ex__11472__auto__ = e83448;
var statearr_83449_83457 = state_83434;
(statearr_83449_83457[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_83434[(4)]))){
var statearr_83450_83458 = state_83434;
(statearr_83450_83458[(1)] = cljs.core.first.call(null,(state_83434[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83459 = state_83434;
state_83434 = G__83459;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$monitor_tx_$_state_machine__11469__auto__ = function(state_83434){
switch(arguments.length){
case 0:
return flureenjs$monitor_tx_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$monitor_tx_$_state_machine__11469__auto____1.call(this,state_83434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$monitor_tx_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$monitor_tx_$_state_machine__11469__auto____0;
flureenjs$monitor_tx_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$monitor_tx_$_state_machine__11469__auto____1;
return flureenjs$monitor_tx_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_83451 = f__11543__auto__.call(null);
(statearr_83451[(6)] = c__11542__auto__);

return statearr_83451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.monitor_tx', flureenjs.monitor_tx);
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
flureenjs.tx__GT_command = (function flureenjs$tx__GT_command(var_args){
var G__83461 = arguments.length;
switch (G__83461) {
case 3:
return flureenjs.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return flureenjs.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(flureenjs.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_83590){
var state_val_83591 = (state_83590[(1)]);
if((state_val_83591 === (7))){
var state_83590__$1 = state_83590;
var statearr_83592_83672 = state_83590__$1;
(statearr_83592_83672[(2)] = ledger);

(statearr_83592_83672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (20))){
var inst_83505 = (state_83590[(7)]);
var inst_83520 = (state_83590[(2)]);
var inst_83521 = fluree.crypto.account_id_from_private.call(null,private_key);
var state_83590__$1 = (function (){var statearr_83593 = state_83590;
(statearr_83593[(8)] = inst_83521);

(statearr_83593[(9)] = inst_83520);

return statearr_83593;
})();
if(cljs.core.truth_(inst_83505)){
var statearr_83594_83673 = state_83590__$1;
(statearr_83594_83673[(1)] = (24));

} else {
var statearr_83595_83674 = state_83590__$1;
(statearr_83595_83674[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (27))){
var inst_83505 = (state_83590[(7)]);
var inst_83521 = (state_83590[(8)]);
var inst_83528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83529 = [inst_83505,inst_83521];
var inst_83530 = (new cljs.core.PersistentVector(null,2,(5),inst_83528,inst_83529,null));
var state_83590__$1 = state_83590;
var statearr_83596_83675 = state_83590__$1;
(statearr_83596_83675[(2)] = inst_83530);

(statearr_83596_83675[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (1))){
var state_83590__$1 = state_83590;
var statearr_83597_83676 = state_83590__$1;
(statearr_83597_83676[(2)] = null);

(statearr_83597_83676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (24))){
var inst_83505 = (state_83590[(7)]);
var inst_83521 = (state_83590[(8)]);
var inst_83523 = cljs.core.not_EQ_.call(null,inst_83505,inst_83521);
var state_83590__$1 = state_83590;
var statearr_83598_83677 = state_83590__$1;
(statearr_83598_83677[(2)] = inst_83523);

(statearr_83598_83677[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (39))){
var inst_83506 = (state_83590[(10)]);
var state_83590__$1 = state_83590;
var statearr_83599_83678 = state_83590__$1;
(statearr_83599_83678[(2)] = inst_83506);

(statearr_83599_83678[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (4))){
var inst_83462 = (state_83590[(2)]);
var inst_83463 = fluree.db.util.log.error.call(null,inst_83462);
var inst_83464 = cljs.core.clj__GT_js.call(null,inst_83462);
var inst_83465 = reject.call(null,inst_83464);
var state_83590__$1 = (function (){var statearr_83600 = state_83590;
(statearr_83600[(11)] = inst_83463);

return statearr_83600;
})();
var statearr_83601_83679 = state_83590__$1;
(statearr_83601_83679[(2)] = inst_83465);

(statearr_83601_83679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (15))){
var inst_83483 = (state_83590[(12)]);
var inst_83501 = cljs.core.apply.call(null,cljs.core.hash_map,inst_83483);
var state_83590__$1 = state_83590;
var statearr_83602_83680 = state_83590__$1;
(statearr_83602_83680[(2)] = inst_83501);

(statearr_83602_83680[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (21))){
var state_83590__$1 = state_83590;
var statearr_83603_83681 = state_83590__$1;
(statearr_83603_83681[(2)] = null);

(statearr_83603_83681[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (31))){
var state_83590__$1 = state_83590;
var statearr_83604_83682 = state_83590__$1;
(statearr_83604_83682[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (32))){
var inst_83545 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83606_83683 = state_83590__$1;
(statearr_83606_83683[(2)] = inst_83545);

(statearr_83606_83683[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (40))){
var inst_83550 = (state_83590[(13)]);
var inst_83557 = (inst_83550 + (30000));
var state_83590__$1 = state_83590;
var statearr_83607_83684 = state_83590__$1;
(statearr_83607_83684[(2)] = inst_83557);

(statearr_83607_83684[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (33))){
var inst_83521 = (state_83590[(8)]);
var inst_83538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83539 = [inst_83521,null];
var inst_83540 = (new cljs.core.PersistentVector(null,2,(5),inst_83538,inst_83539,null));
var state_83590__$1 = state_83590;
var statearr_83608_83685 = state_83590__$1;
(statearr_83608_83685[(2)] = inst_83540);

(statearr_83608_83685[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (13))){
var state_83590__$1 = state_83590;
var statearr_83609_83686 = state_83590__$1;
(statearr_83609_83686[(2)] = false);

(statearr_83609_83686[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (22))){
var inst_83513 = ["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('');
var inst_83514 = (new Error(inst_83513));
var inst_83515 = (function(){throw inst_83514})();
var state_83590__$1 = state_83590;
var statearr_83610_83687 = state_83590__$1;
(statearr_83610_83687[(2)] = inst_83515);

(statearr_83610_83687[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (36))){
var inst_83507 = (state_83590[(14)]);
var state_83590__$1 = state_83590;
var statearr_83611_83688 = state_83590__$1;
(statearr_83611_83688[(2)] = inst_83507);

(statearr_83611_83688[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (41))){
var inst_83559 = (state_83590[(2)]);
var state_83590__$1 = (function (){var statearr_83612 = state_83590;
(statearr_83612[(15)] = inst_83559);

return statearr_83612;
})();
var statearr_83613_83689 = state_83590__$1;
(statearr_83613_83689[(2)] = null);

(statearr_83613_83689[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (43))){
var inst_83579 = (state_83590[(2)]);
var inst_83580 = fluree.crypto.sign_message.call(null,inst_83579,private_key);
var inst_83581 = fluree.crypto.sha3_256.call(null,inst_83579);
var inst_83582 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"db","db",993250759)];
var inst_83583 = [inst_83579,inst_83580,inst_83581,ledger];
var inst_83584 = cljs.core.PersistentHashMap.fromArrays(inst_83582,inst_83583);
var inst_83585 = resolve.call(null,inst_83584);
var _ = (function (){var statearr_83614 = state_83590;
(statearr_83614[(4)] = cljs.core.rest.call(null,(state_83590[(4)])));

return statearr_83614;
})();
var state_83590__$1 = state_83590;
var statearr_83615_83690 = state_83590__$1;
(statearr_83615_83690[(2)] = inst_83585);

(statearr_83615_83690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (29))){
var inst_83507 = (state_83590[(14)]);
var inst_83547 = (state_83590[(2)]);
var inst_83548 = cljs.core.nth.call(null,inst_83547,(0),null);
var inst_83549 = cljs.core.nth.call(null,inst_83547,(1),null);
var inst_83550 = fluree.db.util.core.current_time_millis.call(null);
var state_83590__$1 = (function (){var statearr_83616 = state_83590;
(statearr_83616[(13)] = inst_83550);

(statearr_83616[(16)] = inst_83549);

(statearr_83616[(17)] = inst_83548);

return statearr_83616;
})();
if(cljs.core.truth_(inst_83507)){
var statearr_83617_83691 = state_83590__$1;
(statearr_83617_83691[(1)] = (36));

} else {
var statearr_83618_83692 = state_83590__$1;
(statearr_83618_83692[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (44))){
var inst_83560 = (state_83590[(2)]);
var inst_83561 = fluree.db.util.log.error.call(null,inst_83560);
var inst_83562 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_83563 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_83564 = cljs.core.PersistentHashMap.fromArrays(inst_83562,inst_83563);
var inst_83565 = cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",inst_83564);
var inst_83566 = (function(){throw inst_83565})();
var state_83590__$1 = (function (){var statearr_83619 = state_83590;
(statearr_83619[(18)] = inst_83561);

return statearr_83619;
})();
var statearr_83620_83693 = state_83590__$1;
(statearr_83620_83693[(2)] = inst_83566);

(statearr_83620_83693[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (6))){
var inst_83477 = cljs.core.first.call(null,ledger);
var inst_83478 = cljs.core.second.call(null,ledger);
var inst_83479 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83477),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83478)].join('');
var state_83590__$1 = state_83590;
var statearr_83621_83694 = state_83590__$1;
(statearr_83621_83694[(2)] = inst_83479);

(statearr_83621_83694[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (28))){
var inst_83505 = (state_83590[(7)]);
var state_83590__$1 = state_83590;
if(cljs.core.truth_(inst_83505)){
var statearr_83622_83695 = state_83590__$1;
(statearr_83622_83695[(1)] = (30));

} else {
var statearr_83623_83696 = state_83590__$1;
(statearr_83623_83696[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (25))){
var inst_83505 = (state_83590[(7)]);
var state_83590__$1 = state_83590;
var statearr_83624_83697 = state_83590__$1;
(statearr_83624_83697[(2)] = inst_83505);

(statearr_83624_83697[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (34))){
var state_83590__$1 = state_83590;
var statearr_83625_83698 = state_83590__$1;
(statearr_83625_83698[(2)] = null);

(statearr_83625_83698[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (17))){
var inst_83508 = (state_83590[(19)]);
var inst_83504 = (state_83590[(2)]);
var inst_83505 = cljs.core.get.call(null,inst_83504,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_83506 = cljs.core.get.call(null,inst_83504,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_83507 = cljs.core.get.call(null,inst_83504,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_83508__$1 = cljs.core.get.call(null,inst_83504,new cljs.core.Keyword(null,"deps","deps",1883360319));
var state_83590__$1 = (function (){var statearr_83626 = state_83590;
(statearr_83626[(7)] = inst_83505);

(statearr_83626[(19)] = inst_83508__$1);

(statearr_83626[(14)] = inst_83507);

(statearr_83626[(10)] = inst_83506);

return statearr_83626;
})();
if(cljs.core.truth_(inst_83508__$1)){
var statearr_83627_83699 = state_83590__$1;
(statearr_83627_83699[(1)] = (18));

} else {
var statearr_83628_83700 = state_83590__$1;
(statearr_83628_83700[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (3))){
var inst_83588 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83590__$1,inst_83588);
} else {
if((state_val_83591 === (12))){
var state_83590__$1 = state_83590;
var statearr_83629_83701 = state_83590__$1;
(statearr_83629_83701[(2)] = true);

(statearr_83629_83701[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (2))){
var _ = (function (){var statearr_83630 = state_83590;
(statearr_83630[(4)] = cljs.core.cons.call(null,(5),(state_83590[(4)])));

return statearr_83630;
})();
var inst_83475 = cljs.core.sequential_QMARK_.call(null,ledger);
var state_83590__$1 = state_83590;
if(inst_83475){
var statearr_83631_83702 = state_83590__$1;
(statearr_83631_83702[(1)] = (6));

} else {
var statearr_83632_83703 = state_83590__$1;
(statearr_83632_83703[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (23))){
var inst_83517 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83633_83704 = state_83590__$1;
(statearr_83633_83704[(2)] = inst_83517);

(statearr_83633_83704[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (35))){
var inst_83543 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83634_83705 = state_83590__$1;
(statearr_83634_83705[(2)] = inst_83543);

(statearr_83634_83705[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (19))){
var state_83590__$1 = state_83590;
var statearr_83635_83706 = state_83590__$1;
(statearr_83635_83706[(2)] = null);

(statearr_83635_83706[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (11))){
var inst_83499 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
if(cljs.core.truth_(inst_83499)){
var statearr_83637_83707 = state_83590__$1;
(statearr_83637_83707[(1)] = (15));

} else {
var statearr_83638_83708 = state_83590__$1;
(statearr_83638_83708[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (9))){
var inst_83483 = (state_83590[(12)]);
var inst_83488 = inst_83483.cljs$lang$protocol_mask$partition0$;
var inst_83489 = (inst_83488 & (64));
var inst_83490 = inst_83483.cljs$core$ISeq$;
var inst_83491 = (cljs.core.PROTOCOL_SENTINEL === inst_83490);
var inst_83492 = ((inst_83489) || (inst_83491));
var state_83590__$1 = state_83590;
if(cljs.core.truth_(inst_83492)){
var statearr_83639_83709 = state_83590__$1;
(statearr_83639_83709[(1)] = (12));

} else {
var statearr_83640_83710 = state_83590__$1;
(statearr_83640_83710[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (5))){
var _ = (function (){var statearr_83642 = state_83590;
(statearr_83642[(4)] = cljs.core.rest.call(null,(state_83590[(4)])));

return statearr_83642;
})();
var state_83590__$1 = state_83590;
var ex83636 = (state_83590__$1[(2)]);
var statearr_83643_83711 = state_83590__$1;
(statearr_83643_83711[(5)] = ex83636);


var statearr_83644_83712 = state_83590__$1;
(statearr_83644_83712[(1)] = (4));

(statearr_83644_83712[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (14))){
var inst_83496 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83645_83713 = state_83590__$1;
(statearr_83645_83713[(2)] = inst_83496);

(statearr_83645_83713[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (45))){
var _ = (function (){var statearr_83646 = state_83590;
(statearr_83646[(4)] = cljs.core.rest.call(null,(state_83590[(4)])));

return statearr_83646;
})();
var state_83590__$1 = state_83590;
var ex83641 = (state_83590__$1[(2)]);
var statearr_83647_83714 = state_83590__$1;
(statearr_83647_83714[(5)] = ex83641);


var statearr_83648_83715 = state_83590__$1;
(statearr_83648_83715[(1)] = (44));

(statearr_83648_83715[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (26))){
var inst_83526 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
if(cljs.core.truth_(inst_83526)){
var statearr_83649_83716 = state_83590__$1;
(statearr_83649_83716[(1)] = (27));

} else {
var statearr_83650_83717 = state_83590__$1;
(statearr_83650_83717[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (16))){
var inst_83483 = (state_83590[(12)]);
var state_83590__$1 = state_83590;
var statearr_83651_83718 = state_83590__$1;
(statearr_83651_83718[(2)] = inst_83483);

(statearr_83651_83718[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (38))){
var inst_83506 = (state_83590[(10)]);
var inst_83554 = (state_83590[(2)]);
var state_83590__$1 = (function (){var statearr_83652 = state_83590;
(statearr_83652[(20)] = inst_83554);

return statearr_83652;
})();
if(cljs.core.truth_(inst_83506)){
var statearr_83653_83719 = state_83590__$1;
(statearr_83653_83719[(1)] = (39));

} else {
var statearr_83654_83720 = state_83590__$1;
(statearr_83654_83720[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (30))){
var inst_83505 = (state_83590[(7)]);
var inst_83533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83534 = [inst_83505,null];
var inst_83535 = (new cljs.core.PersistentVector(null,2,(5),inst_83533,inst_83534,null));
var state_83590__$1 = state_83590;
var statearr_83655_83721 = state_83590__$1;
(statearr_83655_83721[(2)] = inst_83535);

(statearr_83655_83721[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (10))){
var state_83590__$1 = state_83590;
var statearr_83656_83722 = state_83590__$1;
(statearr_83656_83722[(2)] = false);

(statearr_83656_83722[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (18))){
var inst_83508 = (state_83590[(19)]);
var inst_83510 = cljs.core.sequential_QMARK_.call(null,inst_83508);
var state_83590__$1 = state_83590;
if(inst_83510){
var statearr_83657_83723 = state_83590__$1;
(statearr_83657_83723[(1)] = (21));

} else {
var statearr_83658_83724 = state_83590__$1;
(statearr_83658_83724[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (42))){
var inst_83508 = (state_83590[(19)]);
var inst_83554 = (state_83590[(20)]);
var inst_83559 = (state_83590[(15)]);
var inst_83549 = (state_83590[(16)]);
var inst_83548 = (state_83590[(17)]);
var inst_83482 = (state_83590[(21)]);
var _ = (function (){var statearr_83659 = state_83590;
(statearr_83659[(4)] = cljs.core.cons.call(null,(45),(state_83590[(4)])));

return statearr_83659;
})();
var inst_83572 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"authority","authority",-551669367),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"deps","deps",1883360319)];
var inst_83573 = [new cljs.core.Keyword(null,"tx","tx",466630418),inst_83482,txn,inst_83554,inst_83548,inst_83549,inst_83559,inst_83508];
var inst_83574 = cljs.core.PersistentHashMap.fromArrays(inst_83572,inst_83573);
var inst_83575 = fluree.db.util.core.without_nils.call(null,inst_83574);
var inst_83576 = fluree.db.util.json.stringify.call(null,inst_83575);
var ___$1 = (function (){var statearr_83660 = state_83590;
(statearr_83660[(4)] = cljs.core.rest.call(null,(state_83590[(4)])));

return statearr_83660;
})();
var state_83590__$1 = state_83590;
var statearr_83661_83725 = state_83590__$1;
(statearr_83661_83725[(2)] = inst_83576);

(statearr_83661_83725[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (37))){
var inst_83550 = (state_83590[(13)]);
var state_83590__$1 = state_83590;
var statearr_83662_83726 = state_83590__$1;
(statearr_83662_83726[(2)] = inst_83550);

(statearr_83662_83726[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83591 === (8))){
var inst_83483 = (state_83590[(12)]);
var inst_83482 = (state_83590[(2)]);
var inst_83483__$1 = opts;
var inst_83485 = (inst_83483__$1 == null);
var inst_83486 = cljs.core.not.call(null,inst_83485);
var state_83590__$1 = (function (){var statearr_83663 = state_83590;
(statearr_83663[(12)] = inst_83483__$1);

(statearr_83663[(21)] = inst_83482);

return statearr_83663;
})();
if(inst_83486){
var statearr_83664_83727 = state_83590__$1;
(statearr_83664_83727[(1)] = (9));

} else {
var statearr_83665_83728 = state_83590__$1;
(statearr_83665_83728[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_83666 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83666[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_83666[(1)] = (1));

return statearr_83666;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_83590){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_83590);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e83667){var ex__11472__auto__ = e83667;
var statearr_83668_83729 = state_83590;
(statearr_83668_83729[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_83590[(4)]))){
var statearr_83669_83730 = state_83590;
(statearr_83669_83730[(1)] = cljs.core.first.call(null,(state_83590[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83731 = state_83590;
state_83590 = G__83731;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_83590){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_83590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_83670 = f__11543__auto__.call(null);
(statearr_83670[(6)] = c__11542__auto__);

return statearr_83670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.tx__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 */
flureenjs.transact = (function flureenjs$transact(var_args){
var G__83733 = arguments.length;
switch (G__83733) {
case 3:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.transact', flureenjs.transact);

(flureenjs.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureenjs.transact.call(null,conn,ledger,txn,null);
}));

(flureenjs.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_83759){
var state_val_83760 = (state_83759[(1)]);
if((state_val_83760 === (7))){
var inst_83745 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_83759__$1 = state_83759;
var statearr_83761_83782 = state_83759__$1;
(statearr_83761_83782[(2)] = inst_83745);

(statearr_83761_83782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83760 === (1))){
var state_83759__$1 = state_83759;
var statearr_83762_83783 = state_83759__$1;
(statearr_83762_83783[(2)] = null);

(statearr_83762_83783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83760 === (4))){
var inst_83734 = (state_83759[(2)]);
var inst_83735 = fluree.db.util.log.error.call(null,inst_83734);
var inst_83736 = reject.call(null,inst_83734);
var state_83759__$1 = (function (){var statearr_83763 = state_83759;
(statearr_83763[(7)] = inst_83735);

return statearr_83763;
})();
var statearr_83764_83784 = state_83759__$1;
(statearr_83764_83784[(2)] = inst_83736);

(statearr_83764_83784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83760 === (6))){
var state_83759__$1 = state_83759;
var statearr_83765_83785 = state_83759__$1;
(statearr_83765_83785[(2)] = null);

(statearr_83765_83785[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83760 === (3))){
var inst_83757 = (state_83759[(2)]);
var state_83759__$1 = state_83759;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83759__$1,inst_83757);
} else {
if((state_val_83760 === (2))){
var _ = (function (){var statearr_83767 = state_83759;
(statearr_83767[(4)] = cljs.core.cons.call(null,(5),(state_83759[(4)])));

return statearr_83767;
})();
var inst_83742 = (opts == null);
var state_83759__$1 = state_83759;
if(cljs.core.truth_(inst_83742)){
var statearr_83768_83786 = state_83759__$1;
(statearr_83768_83786[(1)] = (6));

} else {
var statearr_83769_83787 = state_83759__$1;
(statearr_83769_83787[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83760 === (9))){
var inst_83752 = (state_83759[(2)]);
var inst_83753 = cljs.core.clj__GT_js.call(null,inst_83752);
var inst_83754 = resolve.call(null,inst_83753);
var _ = (function (){var statearr_83770 = state_83759;
(statearr_83770[(4)] = cljs.core.rest.call(null,(state_83759[(4)])));

return statearr_83770;
})();
var state_83759__$1 = state_83759;
var statearr_83771_83788 = state_83759__$1;
(statearr_83771_83788[(2)] = inst_83754);

(statearr_83771_83788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83760 === (5))){
var _ = (function (){var statearr_83772 = state_83759;
(statearr_83772[(4)] = cljs.core.rest.call(null,(state_83759[(4)])));

return statearr_83772;
})();
var state_83759__$1 = state_83759;
var ex83766 = (state_83759__$1[(2)]);
var statearr_83773_83789 = state_83759__$1;
(statearr_83773_83789[(5)] = ex83766);


var statearr_83774_83790 = state_83759__$1;
(statearr_83774_83790[(1)] = (4));

(statearr_83774_83790[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83760 === (8))){
var inst_83747 = (state_83759[(2)]);
var inst_83748 = fluree.db.connection_js.check_connection.call(null,conn,inst_83747);
var inst_83749 = cljs.core.js__GT_clj.call(null,txn,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_83750 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_83749,inst_83747);
var state_83759__$1 = (function (){var statearr_83775 = state_83759;
(statearr_83775[(8)] = inst_83748);

return statearr_83775;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83759__$1,(9),inst_83750);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_83776 = [null,null,null,null,null,null,null,null,null];
(statearr_83776[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_83776[(1)] = (1));

return statearr_83776;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_83759){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_83759);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e83777){var ex__11472__auto__ = e83777;
var statearr_83778_83791 = state_83759;
(statearr_83778_83791[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_83759[(4)]))){
var statearr_83779_83792 = state_83759;
(statearr_83779_83792[(1)] = cljs.core.first.call(null,(state_83759[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83793 = state_83759;
state_83759 = G__83793;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_83759){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_83759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_83780 = f__11543__auto__.call(null);
(statearr_83780[(6)] = c__11542__auto__);

return statearr_83780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureenjs.block_range_with_txn = (function flureenjs$block_range_with_txn(var_args){
var G__83795 = arguments.length;
switch (G__83795) {
case 3:
return flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_range_with_txn', flureenjs.block_range_with_txn);

(flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureenjs.block_range_with_txn.call(null,conn,ledger,block_map,null);
}));

(flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_83844){
var state_val_83845 = (state_83844[(1)]);
if((state_val_83845 === (7))){
var state_83844__$1 = state_83844;
var statearr_83846_83876 = state_83844__$1;
(statearr_83846_83876[(2)] = false);

(statearr_83846_83876[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83845 === (1))){
var state_83844__$1 = state_83844;
var statearr_83847_83877 = state_83844__$1;
(statearr_83847_83877[(2)] = null);

(statearr_83847_83877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83845 === (4))){
var inst_83796 = (state_83844[(2)]);
var inst_83797 = fluree.db.util.log.error.call(null,inst_83796);
var inst_83798 = reject.call(null,inst_83796);
var state_83844__$1 = (function (){var statearr_83848 = state_83844;
(statearr_83848[(7)] = inst_83797);

return statearr_83848;
})();
var statearr_83849_83878 = state_83844__$1;
(statearr_83849_83878[(2)] = inst_83798);

(statearr_83849_83878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83845 === (15))){
var inst_83805 = (state_83844[(8)]);
var inst_83829 = (state_83844[(9)]);
var inst_83828 = (state_83844[(10)]);
var inst_83832 = (state_83844[(2)]);
var inst_83833 = fluree.db.query.block.block_range.call(null,inst_83832,inst_83828,inst_83829,inst_83805);
var state_83844__$1 = state_83844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83844__$1,(16),inst_83833);
} else {
if((state_val_83845 === (13))){
var inst_83806 = (state_83844[(11)]);
var state_83844__$1 = state_83844;
var statearr_83850_83879 = state_83844__$1;
(statearr_83850_83879[(2)] = inst_83806);

(statearr_83850_83879[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83845 === (6))){
var inst_83806 = (state_83844[(11)]);
var inst_83811 = inst_83806.cljs$lang$protocol_mask$partition0$;
var inst_83812 = (inst_83811 & (64));
var inst_83813 = inst_83806.cljs$core$ISeq$;
var inst_83814 = (cljs.core.PROTOCOL_SENTINEL === inst_83813);
var inst_83815 = ((inst_83812) || (inst_83814));
var state_83844__$1 = state_83844;
if(cljs.core.truth_(inst_83815)){
var statearr_83851_83880 = state_83844__$1;
(statearr_83851_83880[(1)] = (9));

} else {
var statearr_83852_83881 = state_83844__$1;
(statearr_83852_83881[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83845 === (3))){
var inst_83842 = (state_83844[(2)]);
var state_83844__$1 = state_83844;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83844__$1,inst_83842);
} else {
if((state_val_83845 === (12))){
var inst_83806 = (state_83844[(11)]);
var inst_83824 = cljs.core.apply.call(null,cljs.core.hash_map,inst_83806);
var state_83844__$1 = state_83844;
var statearr_83853_83882 = state_83844__$1;
(statearr_83853_83882[(2)] = inst_83824);

(statearr_83853_83882[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83845 === (2))){
var inst_83806 = (state_83844[(11)]);
var _ = (function (){var statearr_83854 = state_83844;
(statearr_83854[(4)] = cljs.core.cons.call(null,(5),(state_83844[(4)])));

return statearr_83854;
})();
var inst_83805 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_83806__$1 = cljs.core.js__GT_clj.call(null,block_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_83808 = (inst_83806__$1 == null);
var inst_83809 = cljs.core.not.call(null,inst_83808);
var state_83844__$1 = (function (){var statearr_83855 = state_83844;
(statearr_83855[(11)] = inst_83806__$1);

(statearr_83855[(8)] = inst_83805);

return statearr_83855;
})();
if(inst_83809){
var statearr_83856_83883 = state_83844__$1;
(statearr_83856_83883[(1)] = (6));

} else {
var statearr_83857_83884 = state_83844__$1;
(statearr_83857_83884[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83845 === (11))){
var inst_83819 = (state_83844[(2)]);
var state_83844__$1 = state_83844;
var statearr_83859_83885 = state_83844__$1;
(statearr_83859_83885[(2)] = inst_83819);

(statearr_83859_83885[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83845 === (9))){
var state_83844__$1 = state_83844;
var statearr_83860_83886 = state_83844__$1;
(statearr_83860_83886[(2)] = true);

(statearr_83860_83886[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83845 === (5))){
var _ = (function (){var statearr_83861 = state_83844;
(statearr_83861[(4)] = cljs.core.rest.call(null,(state_83844[(4)])));

return statearr_83861;
})();
var state_83844__$1 = state_83844;
var ex83858 = (state_83844__$1[(2)]);
var statearr_83862_83887 = state_83844__$1;
(statearr_83862_83887[(5)] = ex83858);


var statearr_83863_83888 = state_83844__$1;
(statearr_83863_83888[(1)] = (4));

(statearr_83863_83888[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83845 === (14))){
var inst_83805 = (state_83844[(8)]);
var inst_83827 = (state_83844[(2)]);
var inst_83828 = cljs.core.get.call(null,inst_83827,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_83829 = cljs.core.get.call(null,inst_83827,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_83830 = flureenjs.db_instance.call(null,conn,ledger,inst_83805);
var state_83844__$1 = (function (){var statearr_83864 = state_83844;
(statearr_83864[(9)] = inst_83829);

(statearr_83864[(10)] = inst_83828);

return statearr_83864;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83844__$1,(15),inst_83830);
} else {
if((state_val_83845 === (16))){
var inst_83835 = (state_83844[(2)]);
var inst_83836 = fluree.db.util.async.throw_err.call(null,inst_83835);
var inst_83837 = fluree.db.query.range.block_with_tx_data.call(null,inst_83836);
var inst_83838 = cljs.core.clj__GT_js.call(null,inst_83837);
var inst_83839 = resolve.call(null,inst_83838);
var _ = (function (){var statearr_83865 = state_83844;
(statearr_83865[(4)] = cljs.core.rest.call(null,(state_83844[(4)])));

return statearr_83865;
})();
var state_83844__$1 = state_83844;
var statearr_83866_83889 = state_83844__$1;
(statearr_83866_83889[(2)] = inst_83839);

(statearr_83866_83889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83845 === (10))){
var state_83844__$1 = state_83844;
var statearr_83867_83890 = state_83844__$1;
(statearr_83867_83890[(2)] = false);

(statearr_83867_83890[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83845 === (8))){
var inst_83822 = (state_83844[(2)]);
var state_83844__$1 = state_83844;
if(cljs.core.truth_(inst_83822)){
var statearr_83868_83891 = state_83844__$1;
(statearr_83868_83891[(1)] = (12));

} else {
var statearr_83869_83892 = state_83844__$1;
(statearr_83869_83892[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_83870 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83870[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_83870[(1)] = (1));

return statearr_83870;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_83844){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_83844);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e83871){var ex__11472__auto__ = e83871;
var statearr_83872_83893 = state_83844;
(statearr_83872_83893[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_83844[(4)]))){
var statearr_83873_83894 = state_83844;
(statearr_83873_83894[(1)] = cljs.core.first.call(null,(state_83844[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83895 = state_83844;
state_83844 = G__83895;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_83844){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_83844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_83874 = f__11543__auto__.call(null);
(statearr_83874[(6)] = c__11542__auto__);

return statearr_83874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureenjs.block_query = (function flureenjs$block_query(var_args){
var G__83897 = arguments.length;
switch (G__83897) {
case 3:
return flureenjs.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_query', flureenjs.block_query);

(flureenjs.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureenjs.block_query.call(null,conn,ledger,query_map,null);
}));

(flureenjs.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_83955){
var state_val_83956 = (state_83955[(1)]);
if((state_val_83956 === (7))){
var state_83955__$1 = state_83955;
var statearr_83957_83998 = state_83955__$1;
(statearr_83957_83998[(2)] = null);

(statearr_83957_83998[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (20))){
var inst_83934 = (state_83955[(2)]);
var state_83955__$1 = state_83955;
var statearr_83958_83999 = state_83955__$1;
(statearr_83958_83999[(2)] = inst_83934);

(statearr_83958_83999[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (1))){
var state_83955__$1 = state_83955;
var statearr_83959_84000 = state_83955__$1;
(statearr_83959_84000[(2)] = null);

(statearr_83959_84000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (4))){
var inst_83898 = (state_83955[(2)]);
var inst_83899 = fluree.db.util.log.error.call(null,inst_83898);
var inst_83900 = reject.call(null,inst_83898);
var state_83955__$1 = (function (){var statearr_83960 = state_83955;
(statearr_83960[(7)] = inst_83899);

return statearr_83960;
})();
var statearr_83961_84001 = state_83955__$1;
(statearr_83961_84001[(2)] = inst_83900);

(statearr_83961_84001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (15))){
var state_83955__$1 = state_83955;
var statearr_83962_84002 = state_83955__$1;
(statearr_83962_84002[(2)] = null);

(statearr_83962_84002[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (21))){
var inst_83947 = (state_83955[(2)]);
var inst_83948 = fluree.db.util.async.throw_err.call(null,inst_83947);
var inst_83949 = cljs.core.clj__GT_js.call(null,inst_83948);
var inst_83950 = resolve.call(null,inst_83949);
var _ = (function (){var statearr_83963 = state_83955;
(statearr_83963[(4)] = cljs.core.rest.call(null,(state_83955[(4)])));

return statearr_83963;
})();
var state_83955__$1 = state_83955;
var statearr_83964_84003 = state_83955__$1;
(statearr_83964_84003[(2)] = inst_83950);

(statearr_83964_84003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (13))){
var inst_83922 = (state_83955[(8)]);
var inst_83913 = (state_83955[(9)]);
var inst_83922__$1 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_83913);
var inst_83923 = (inst_83922__$1 == null);
var state_83955__$1 = (function (){var statearr_83965 = state_83955;
(statearr_83965[(8)] = inst_83922__$1);

return statearr_83965;
})();
if(cljs.core.truth_(inst_83923)){
var statearr_83966_84004 = state_83955__$1;
(statearr_83966_84004[(1)] = (15));

} else {
var statearr_83967_84005 = state_83955__$1;
(statearr_83967_84005[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (6))){
var inst_83909 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_83955__$1 = state_83955;
var statearr_83968_84006 = state_83955__$1;
(statearr_83968_84006[(2)] = inst_83909);

(statearr_83968_84006[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (17))){
var inst_83928 = (state_83955[(10)]);
var inst_83928__$1 = (state_83955[(2)]);
var inst_83929 = (inst_83928__$1 == null);
var state_83955__$1 = (function (){var statearr_83969 = state_83955;
(statearr_83969[(10)] = inst_83928__$1);

return statearr_83969;
})();
if(cljs.core.truth_(inst_83929)){
var statearr_83970_84007 = state_83955__$1;
(statearr_83970_84007[(1)] = (18));

} else {
var statearr_83971_84008 = state_83955__$1;
(statearr_83971_84008[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (3))){
var inst_83953 = (state_83955[(2)]);
var state_83955__$1 = state_83955;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83955__$1,inst_83953);
} else {
if((state_val_83956 === (12))){
var inst_83918 = (state_83955[(11)]);
var state_83955__$1 = state_83955;
var statearr_83972_84009 = state_83955__$1;
(statearr_83972_84009[(2)] = inst_83918);

(statearr_83972_84009[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (2))){
var inst_83906 = (state_83955[(12)]);
var _ = (function (){var statearr_83973 = state_83955;
(statearr_83973[(4)] = cljs.core.cons.call(null,(5),(state_83955[(4)])));

return statearr_83973;
})();
var inst_83906__$1 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_83907 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_83906__$1);
var state_83955__$1 = (function (){var statearr_83974 = state_83955;
(statearr_83974[(13)] = inst_83907);

(statearr_83974[(12)] = inst_83906__$1);

return statearr_83974;
})();
if(cljs.core.truth_(opts)){
var statearr_83975_84010 = state_83955__$1;
(statearr_83975_84010[(1)] = (6));

} else {
var statearr_83976_84011 = state_83955__$1;
(statearr_83976_84011[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (19))){
var inst_83928 = (state_83955[(10)]);
var inst_83932 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_83928);
var state_83955__$1 = state_83955;
var statearr_83977_84012 = state_83955__$1;
(statearr_83977_84012[(2)] = inst_83932);

(statearr_83977_84012[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (11))){
var inst_83913 = (state_83955[(9)]);
var inst_83906 = (state_83955[(12)]);
var inst_83938 = (state_83955[(2)]);
var inst_83939 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_83940 = [inst_83938];
var inst_83941 = cljs.core.PersistentHashMap.fromArrays(inst_83939,inst_83940);
var inst_83942 = fluree.db.util.core.without_nils.call(null,inst_83941);
var inst_83943 = cljs.core.merge.call(null,inst_83913,inst_83942);
var inst_83944 = cljs.core.update.call(null,inst_83906,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_83943);
var inst_83945 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_83944);
var state_83955__$1 = state_83955;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83955__$1,(21),inst_83945);
} else {
if((state_val_83956 === (9))){
var inst_83915 = (state_83955[(14)]);
var state_83955__$1 = state_83955;
var statearr_83979_84013 = state_83955__$1;
(statearr_83979_84013[(2)] = inst_83915);

(statearr_83979_84013[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (5))){
var _ = (function (){var statearr_83980 = state_83955;
(statearr_83980[(4)] = cljs.core.rest.call(null,(state_83955[(4)])));

return statearr_83980;
})();
var state_83955__$1 = state_83955;
var ex83978 = (state_83955__$1[(2)]);
var statearr_83981_84014 = state_83955__$1;
(statearr_83981_84014[(5)] = ex83978);


var statearr_83982_84015 = state_83955__$1;
(statearr_83982_84015[(1)] = (4));

(statearr_83982_84015[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (14))){
var inst_83936 = (state_83955[(2)]);
var state_83955__$1 = state_83955;
var statearr_83983_84016 = state_83955__$1;
(statearr_83983_84016[(2)] = inst_83936);

(statearr_83983_84016[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (16))){
var inst_83922 = (state_83955[(8)]);
var inst_83926 = fluree.db.connection_js.validate_token.call(null,conn,inst_83922);
var state_83955__$1 = state_83955;
var statearr_83984_84017 = state_83955__$1;
(statearr_83984_84017[(2)] = inst_83926);

(statearr_83984_84017[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (10))){
var inst_83918 = (state_83955[(11)]);
var inst_83913 = (state_83955[(9)]);
var inst_83918__$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_83913);
var state_83955__$1 = (function (){var statearr_83985 = state_83955;
(statearr_83985[(11)] = inst_83918__$1);

return statearr_83985;
})();
if(cljs.core.truth_(inst_83918__$1)){
var statearr_83986_84018 = state_83955__$1;
(statearr_83986_84018[(1)] = (12));

} else {
var statearr_83987_84019 = state_83955__$1;
(statearr_83987_84019[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (18))){
var state_83955__$1 = state_83955;
var statearr_83988_84020 = state_83955__$1;
(statearr_83988_84020[(2)] = null);

(statearr_83988_84020[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83956 === (8))){
var inst_83915 = (state_83955[(14)]);
var inst_83913 = (state_83955[(9)]);
var inst_83907 = (state_83955[(13)]);
var inst_83912 = (state_83955[(2)]);
var inst_83913__$1 = cljs.core.merge.call(null,inst_83907,inst_83912);
var inst_83914 = fluree.db.connection_js.check_connection.call(null,conn,inst_83913__$1);
var inst_83915__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_83913__$1);
var state_83955__$1 = (function (){var statearr_83989 = state_83955;
(statearr_83989[(15)] = inst_83914);

(statearr_83989[(14)] = inst_83915__$1);

(statearr_83989[(9)] = inst_83913__$1);

return statearr_83989;
})();
if(cljs.core.truth_(inst_83915__$1)){
var statearr_83990_84021 = state_83955__$1;
(statearr_83990_84021[(1)] = (9));

} else {
var statearr_83991_84022 = state_83955__$1;
(statearr_83991_84022[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_83992 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83992[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_83992[(1)] = (1));

return statearr_83992;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_83955){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_83955);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e83993){var ex__11472__auto__ = e83993;
var statearr_83994_84023 = state_83955;
(statearr_83994_84023[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_83955[(4)]))){
var statearr_83995_84024 = state_83955;
(statearr_83995_84024[(1)] = cljs.core.first.call(null,(state_83955[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84025 = state_83955;
state_83955 = G__84025;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_83955){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_83955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_83996 = f__11543__auto__.call(null);
(statearr_83996[(6)] = c__11542__auto__);

return statearr_83996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.block_query.cljs$lang$maxFixedArity = 4);

/**
 * Returns a promise containing blocks from start (inclusive)
 * to end if provided (exclusive).
 * 
 * Each block is a separate map, containing keys :block, :t and :flakes.
 */
flureenjs.block_range = (function flureenjs$block_range(var_args){
var G__84027 = arguments.length;
switch (G__84027) {
case 2:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_range', flureenjs.block_range);

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return flureenjs.block_range.call(null,db,start,null,null);
}));

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return flureenjs.block_range.call(null,db,start,end,null);
}));

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_84051){
var state_val_84052 = (state_84051[(1)]);
if((state_val_84052 === (1))){
var state_84051__$1 = state_84051;
var statearr_84053_84070 = state_84051__$1;
(statearr_84053_84070[(2)] = null);

(statearr_84053_84070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84052 === (2))){
var _ = (function (){var statearr_84054 = state_84051;
(statearr_84054[(4)] = cljs.core.cons.call(null,(5),(state_84051[(4)])));

return statearr_84054;
})();
var inst_84036 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_84051__$1 = (function (){var statearr_84055 = state_84051;
(statearr_84055[(7)] = inst_84036);

return statearr_84055;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84051__$1,(7),db);
} else {
if((state_val_84052 === (3))){
var inst_84049 = (state_84051[(2)]);
var state_84051__$1 = state_84051;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84051__$1,inst_84049);
} else {
if((state_val_84052 === (4))){
var inst_84028 = (state_84051[(2)]);
var inst_84029 = fluree.db.util.log.error.call(null,inst_84028);
var inst_84030 = reject.call(null,inst_84028);
var state_84051__$1 = (function (){var statearr_84057 = state_84051;
(statearr_84057[(8)] = inst_84029);

return statearr_84057;
})();
var statearr_84058_84071 = state_84051__$1;
(statearr_84058_84071[(2)] = inst_84030);

(statearr_84058_84071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84052 === (5))){
var _ = (function (){var statearr_84059 = state_84051;
(statearr_84059[(4)] = cljs.core.rest.call(null,(state_84051[(4)])));

return statearr_84059;
})();
var state_84051__$1 = state_84051;
var ex84056 = (state_84051__$1[(2)]);
var statearr_84060_84072 = state_84051__$1;
(statearr_84060_84072[(5)] = ex84056);


var statearr_84061_84073 = state_84051__$1;
(statearr_84061_84073[(1)] = (4));

(statearr_84061_84073[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84052 === (6))){
var inst_84042 = (state_84051[(2)]);
var inst_84043 = fluree.db.util.async.throw_err.call(null,inst_84042);
var inst_84044 = flureenjs.block_Flakes__GT_vector.call(null,inst_84043);
var inst_84045 = cljs.core.clj__GT_js.call(null,inst_84044);
var inst_84046 = resolve.call(null,inst_84045);
var _ = (function (){var statearr_84062 = state_84051;
(statearr_84062[(4)] = cljs.core.rest.call(null,(state_84051[(4)])));

return statearr_84062;
})();
var state_84051__$1 = state_84051;
var statearr_84063_84074 = state_84051__$1;
(statearr_84063_84074[(2)] = inst_84046);

(statearr_84063_84074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84052 === (7))){
var inst_84036 = (state_84051[(7)]);
var inst_84038 = (state_84051[(2)]);
var inst_84039 = fluree.db.util.async.throw_err.call(null,inst_84038);
var inst_84040 = fluree.db.query.block.block_range.call(null,inst_84039,start,end,inst_84036);
var state_84051__$1 = state_84051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84051__$1,(6),inst_84040);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_84064 = [null,null,null,null,null,null,null,null,null];
(statearr_84064[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_84064[(1)] = (1));

return statearr_84064;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_84051){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_84051);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e84065){var ex__11472__auto__ = e84065;
var statearr_84066_84075 = state_84051;
(statearr_84066_84075[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_84051[(4)]))){
var statearr_84067_84076 = state_84051;
(statearr_84067_84076[(1)] = cljs.core.first.call(null,(state_84051[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84077 = state_84051;
state_84051 = G__84077;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_84051){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_84051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_84068 = f__11543__auto__.call(null);
(statearr_84068[(6)] = c__11542__auto__);

return statearr_84068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.block_range.cljs$lang$maxFixedArity = 4);

/**
 * Returns spot index range for only the requested collection.
 */
flureenjs.collection_flakes = (function flureenjs$collection_flakes(db,collection){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_84100){
var state_val_84101 = (state_84100[(1)]);
if((state_val_84101 === (1))){
var state_84100__$1 = state_84100;
var statearr_84102_84117 = state_84100__$1;
(statearr_84102_84117[(2)] = null);

(statearr_84102_84117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84101 === (2))){
var _ = (function (){var statearr_84103 = state_84100;
(statearr_84103[(4)] = cljs.core.cons.call(null,(5),(state_84100[(4)])));

return statearr_84103;
})();
var state_84100__$1 = state_84100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84100__$1,(7),db);
} else {
if((state_val_84101 === (3))){
var inst_84098 = (state_84100[(2)]);
var state_84100__$1 = state_84100;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84100__$1,inst_84098);
} else {
if((state_val_84101 === (4))){
var inst_84078 = (state_84100[(2)]);
var inst_84079 = fluree.db.util.log.error.call(null,inst_84078);
var inst_84080 = reject.call(null,inst_84078);
var state_84100__$1 = (function (){var statearr_84105 = state_84100;
(statearr_84105[(7)] = inst_84079);

return statearr_84105;
})();
var statearr_84106_84118 = state_84100__$1;
(statearr_84106_84118[(2)] = inst_84080);

(statearr_84106_84118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84101 === (5))){
var _ = (function (){var statearr_84107 = state_84100;
(statearr_84107[(4)] = cljs.core.rest.call(null,(state_84100[(4)])));

return statearr_84107;
})();
var state_84100__$1 = state_84100;
var ex84104 = (state_84100__$1[(2)]);
var statearr_84108_84119 = state_84100__$1;
(statearr_84108_84119[(5)] = ex84104);


var statearr_84109_84120 = state_84100__$1;
(statearr_84109_84120[(1)] = (4));

(statearr_84109_84120[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84101 === (6))){
var inst_84091 = (state_84100[(2)]);
var inst_84092 = fluree.db.util.async.throw_err.call(null,inst_84091);
var inst_84093 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_84092);
var inst_84094 = cljs.core.clj__GT_js.call(null,inst_84093);
var inst_84095 = resolve.call(null,inst_84094);
var _ = (function (){var statearr_84110 = state_84100;
(statearr_84110[(4)] = cljs.core.rest.call(null,(state_84100[(4)])));

return statearr_84110;
})();
var state_84100__$1 = state_84100;
var statearr_84111_84121 = state_84100__$1;
(statearr_84111_84121[(2)] = inst_84095);

(statearr_84111_84121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84101 === (7))){
var inst_84087 = (state_84100[(2)]);
var inst_84088 = fluree.db.util.async.throw_err.call(null,inst_84087);
var inst_84089 = fluree.db.query.range.collection.call(null,inst_84088,collection);
var state_84100__$1 = state_84100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84100__$1,(6),inst_84089);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$collection_flakes_$_state_machine__11469__auto__ = null;
var flureenjs$collection_flakes_$_state_machine__11469__auto____0 = (function (){
var statearr_84112 = [null,null,null,null,null,null,null,null];
(statearr_84112[(0)] = flureenjs$collection_flakes_$_state_machine__11469__auto__);

(statearr_84112[(1)] = (1));

return statearr_84112;
});
var flureenjs$collection_flakes_$_state_machine__11469__auto____1 = (function (state_84100){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_84100);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e84113){var ex__11472__auto__ = e84113;
var statearr_84114_84122 = state_84100;
(statearr_84114_84122[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_84100[(4)]))){
var statearr_84115_84123 = state_84100;
(statearr_84115_84123[(1)] = cljs.core.first.call(null,(state_84100[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84124 = state_84100;
state_84100 = G__84124;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$collection_flakes_$_state_machine__11469__auto__ = function(state_84100){
switch(arguments.length){
case 0:
return flureenjs$collection_flakes_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$collection_flakes_$_state_machine__11469__auto____1.call(this,state_84100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collection_flakes_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collection_flakes_$_state_machine__11469__auto____0;
flureenjs$collection_flakes_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collection_flakes_$_state_machine__11469__auto____1;
return flureenjs$collection_flakes_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_84116 = f__11543__auto__.call(null);
(statearr_84116[(6)] = c__11542__auto__);

return statearr_84116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.collection_flakes', flureenjs.collection_flakes);
/**
 * Execute a graphql query against the specified database.
 */
flureenjs.graphql = (function flureenjs$graphql(var_args){
var G__84126 = arguments.length;
switch (G__84126) {
case 3:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.graphql', flureenjs.graphql);

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,param){
return flureenjs.graphql.call(null,conn,ledger,param,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,param,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_84248){
var state_val_84249 = (state_84248[(1)]);
if((state_val_84249 === (7))){
var state_84248__$1 = state_84248;
var statearr_84250_84315 = state_84248__$1;
(statearr_84250_84315[(2)] = null);

(statearr_84250_84315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (20))){
var inst_84176 = (state_84248[(7)]);
var state_84248__$1 = state_84248;
var statearr_84251_84316 = state_84248__$1;
(statearr_84251_84316[(2)] = inst_84176);

(statearr_84251_84316[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (27))){
var inst_84176 = (state_84248[(7)]);
var inst_84190 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_84176);
var state_84248__$1 = state_84248;
var statearr_84252_84317 = state_84248__$1;
(statearr_84252_84317[(2)] = inst_84190);

(statearr_84252_84317[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (1))){
var state_84248__$1 = state_84248;
var statearr_84253_84318 = state_84248__$1;
(statearr_84253_84318[(2)] = null);

(statearr_84253_84318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (24))){
var inst_84176 = (state_84248[(7)]);
var inst_84194 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_84176);
var inst_84195 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"history","history",-247395220),inst_84194);
var state_84248__$1 = state_84248;
if(inst_84195){
var statearr_84254_84319 = state_84248__$1;
(statearr_84254_84319[(1)] = (29));

} else {
var statearr_84255_84320 = state_84248__$1;
(statearr_84255_84320[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (39))){
var inst_84233 = (state_84248[(2)]);
var state_84248__$1 = state_84248;
var statearr_84256_84321 = state_84248__$1;
(statearr_84256_84321[(2)] = inst_84233);

(statearr_84256_84321[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (4))){
var inst_84127 = (state_84248[(2)]);
var inst_84128 = fluree.db.util.log.error.call(null,inst_84127);
var inst_84129 = cljs.core.clj__GT_js.call(null,inst_84127);
var inst_84130 = reject.call(null,inst_84129);
var state_84248__$1 = (function (){var statearr_84257 = state_84248;
(statearr_84257[(8)] = inst_84128);

return statearr_84257;
})();
var statearr_84258_84322 = state_84248__$1;
(statearr_84258_84322[(2)] = inst_84130);

(statearr_84258_84322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (15))){
var inst_84138 = (state_84248[(9)]);
var inst_84163 = cljs.core.apply.call(null,cljs.core.hash_map,inst_84138);
var state_84248__$1 = state_84248;
var statearr_84259_84323 = state_84248__$1;
(statearr_84259_84323[(2)] = inst_84163);

(statearr_84259_84323[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (21))){
var inst_84176 = (state_84248[(7)]);
var inst_84180 = [new cljs.core.Keyword(null,"__schema","__schema",-305244223),null,new cljs.core.Keyword(null,"__type","__type",1665433236),null];
var inst_84181 = (new cljs.core.PersistentArrayMap(null,2,inst_84180,null));
var inst_84182 = (new cljs.core.PersistentHashSet(null,inst_84181,null));
var inst_84183 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_84176);
var inst_84184 = inst_84182.call(null,inst_84183);
var state_84248__$1 = state_84248;
if(cljs.core.truth_(inst_84184)){
var statearr_84260_84324 = state_84248__$1;
(statearr_84260_84324[(1)] = (23));

} else {
var statearr_84261_84325 = state_84248__$1;
(statearr_84261_84325[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (31))){
var inst_84237 = (state_84248[(2)]);
var state_84248__$1 = state_84248;
var statearr_84262_84326 = state_84248__$1;
(statearr_84262_84326[(2)] = inst_84237);

(statearr_84262_84326[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (32))){
var inst_84201 = (state_84248[(2)]);
var inst_84202 = fluree.db.util.async.throw_err.call(null,inst_84201);
var state_84248__$1 = state_84248;
var statearr_84263_84327 = state_84248__$1;
(statearr_84263_84327[(2)] = inst_84202);

(statearr_84263_84327[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (40))){
var inst_84219 = (state_84248[(2)]);
var inst_84220 = fluree.db.util.async.throw_err.call(null,inst_84219);
var state_84248__$1 = state_84248;
var statearr_84264_84328 = state_84248__$1;
(statearr_84264_84328[(2)] = inst_84220);

(statearr_84264_84328[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (33))){
var inst_84176 = (state_84248[(7)]);
var inst_84145 = (state_84248[(10)]);
var inst_84207 = cljs.core.dissoc.call(null,inst_84176,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_84208 = cljs.core.assoc.call(null,inst_84207,new cljs.core.Keyword(null,"opts","opts",155075701),inst_84145);
var inst_84209 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_84208);
var state_84248__$1 = state_84248;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84248__$1,(36),inst_84209);
} else {
if((state_val_84249 === (13))){
var state_84248__$1 = state_84248;
var statearr_84265_84329 = state_84248__$1;
(statearr_84265_84329[(2)] = false);

(statearr_84265_84329[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (22))){
var inst_84241 = (state_84248[(2)]);
var inst_84242 = cljs.core.clj__GT_js.call(null,inst_84241);
var inst_84243 = resolve.call(null,inst_84242);
var _ = (function (){var statearr_84266 = state_84248;
(statearr_84266[(4)] = cljs.core.rest.call(null,(state_84248[(4)])));

return statearr_84266;
})();
var state_84248__$1 = state_84248;
var statearr_84267_84330 = state_84248__$1;
(statearr_84267_84330[(2)] = inst_84243);

(statearr_84267_84330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (36))){
var inst_84211 = (state_84248[(2)]);
var inst_84212 = fluree.db.util.async.throw_err.call(null,inst_84211);
var state_84248__$1 = state_84248;
var statearr_84268_84331 = state_84248__$1;
(statearr_84268_84331[(2)] = inst_84212);

(statearr_84268_84331[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (41))){
var inst_84176 = (state_84248[(7)]);
var inst_84169 = (state_84248[(11)]);
var inst_84145 = (state_84248[(10)]);
var inst_84223 = cljs.core.dissoc.call(null,inst_84176,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_84224 = cljs.core.assoc.call(null,inst_84223,new cljs.core.Keyword(null,"opts","opts",155075701),inst_84145);
var inst_84225 = fluree.db.api.query.multi_query_async.call(null,inst_84169,inst_84224);
var state_84248__$1 = state_84248;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84248__$1,(44),inst_84225);
} else {
if((state_val_84249 === (43))){
var inst_84231 = (state_84248[(2)]);
var state_84248__$1 = state_84248;
var statearr_84269_84332 = state_84248__$1;
(statearr_84269_84332[(2)] = inst_84231);

(statearr_84269_84332[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (29))){
var inst_84176 = (state_84248[(7)]);
var inst_84172 = (state_84248[(12)]);
var inst_84145 = (state_84248[(10)]);
var inst_84197 = cljs.core.dissoc.call(null,inst_84176,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_84198 = cljs.core.assoc.call(null,inst_84197,new cljs.core.Keyword(null,"opts","opts",155075701),inst_84145);
var inst_84199 = fluree.db.api.query.history_query_async.call(null,inst_84172,inst_84198);
var state_84248__$1 = state_84248;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84248__$1,(32),inst_84199);
} else {
if((state_val_84249 === (44))){
var inst_84227 = (state_84248[(2)]);
var inst_84228 = fluree.db.util.async.throw_err.call(null,inst_84227);
var state_84248__$1 = state_84248;
var statearr_84270_84333 = state_84248__$1;
(statearr_84270_84333[(2)] = inst_84228);

(statearr_84270_84333[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (6))){
var inst_84141 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_84248__$1 = state_84248;
var statearr_84271_84334 = state_84248__$1;
(statearr_84271_84334[(2)] = inst_84141);

(statearr_84271_84334[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (28))){
var inst_84192 = (state_84248[(2)]);
var state_84248__$1 = state_84248;
var statearr_84272_84335 = state_84248__$1;
(statearr_84272_84335[(2)] = inst_84192);

(statearr_84272_84335[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (25))){
var inst_84239 = (state_84248[(2)]);
var state_84248__$1 = state_84248;
var statearr_84273_84336 = state_84248__$1;
(statearr_84273_84336[(2)] = inst_84239);

(statearr_84273_84336[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (34))){
var inst_84176 = (state_84248[(7)]);
var inst_84214 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_84176);
var state_84248__$1 = state_84248;
if(cljs.core.truth_(inst_84214)){
var statearr_84274_84337 = state_84248__$1;
(statearr_84274_84337[(1)] = (37));

} else {
var statearr_84275_84338 = state_84248__$1;
(statearr_84275_84338[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (17))){
var inst_84169 = (state_84248[(11)]);
var inst_84145 = (state_84248[(10)]);
var inst_84166 = (state_84248[(2)]);
var inst_84167 = cljs.core.get.call(null,inst_84166,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_84168 = cljs.core.get.call(null,inst_84166,new cljs.core.Keyword(null,"variables","variables",1563680814));
var inst_84169__$1 = flureenjs.db_instance.call(null,conn,ledger,inst_84145);
var state_84248__$1 = (function (){var statearr_84276 = state_84248;
(statearr_84276[(13)] = inst_84168);

(statearr_84276[(11)] = inst_84169__$1);

(statearr_84276[(14)] = inst_84167);

return statearr_84276;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84248__$1,(18),inst_84169__$1);
} else {
if((state_val_84249 === (3))){
var inst_84246 = (state_84248[(2)]);
var state_84248__$1 = state_84248;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84248__$1,inst_84246);
} else {
if((state_val_84249 === (12))){
var state_84248__$1 = state_84248;
var statearr_84277_84339 = state_84248__$1;
(statearr_84277_84339[(2)] = true);

(statearr_84277_84339[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (2))){
var inst_84138 = (state_84248[(9)]);
var _ = (function (){var statearr_84278 = state_84248;
(statearr_84278[(4)] = cljs.core.cons.call(null,(5),(state_84248[(4)])));

return statearr_84278;
})();
var inst_84137 = fluree.db.util.json.parse.call(null,param);
var inst_84138__$1 = cljs.core.js__GT_clj.call(null,inst_84137,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84139 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_84138__$1);
var state_84248__$1 = (function (){var statearr_84279 = state_84248;
(statearr_84279[(9)] = inst_84138__$1);

(statearr_84279[(15)] = inst_84139);

return statearr_84279;
})();
if(cljs.core.truth_(opts)){
var statearr_84280_84340 = state_84248__$1;
(statearr_84280_84340[(1)] = (6));

} else {
var statearr_84281_84341 = state_84248__$1;
(statearr_84281_84341[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (23))){
var inst_84145 = (state_84248[(10)]);
var inst_84186 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_84145);
var state_84248__$1 = state_84248;
if(cljs.core.truth_(inst_84186)){
var statearr_84282_84342 = state_84248__$1;
(statearr_84282_84342[(1)] = (26));

} else {
var statearr_84283_84343 = state_84248__$1;
(statearr_84283_84343[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (35))){
var inst_84235 = (state_84248[(2)]);
var state_84248__$1 = state_84248;
var statearr_84284_84344 = state_84248__$1;
(statearr_84284_84344[(2)] = inst_84235);

(statearr_84284_84344[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (19))){
var inst_84176 = (state_84248[(7)]);
var inst_84175 = (state_84248[(2)]);
var inst_84176__$1 = fluree.db.util.async.throw_err.call(null,inst_84175);
var inst_84177 = fluree.db.util.core.exception_QMARK_.call(null,inst_84176__$1);
var state_84248__$1 = (function (){var statearr_84285 = state_84248;
(statearr_84285[(7)] = inst_84176__$1);

return statearr_84285;
})();
if(inst_84177){
var statearr_84286_84345 = state_84248__$1;
(statearr_84286_84345[(1)] = (20));

} else {
var statearr_84287_84346 = state_84248__$1;
(statearr_84287_84346[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (11))){
var inst_84161 = (state_84248[(2)]);
var state_84248__$1 = state_84248;
if(cljs.core.truth_(inst_84161)){
var statearr_84289_84347 = state_84248__$1;
(statearr_84289_84347[(1)] = (15));

} else {
var statearr_84290_84348 = state_84248__$1;
(statearr_84290_84348[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (9))){
var inst_84138 = (state_84248[(9)]);
var inst_84150 = inst_84138.cljs$lang$protocol_mask$partition0$;
var inst_84151 = (inst_84150 & (64));
var inst_84152 = inst_84138.cljs$core$ISeq$;
var inst_84153 = (cljs.core.PROTOCOL_SENTINEL === inst_84152);
var inst_84154 = ((inst_84151) || (inst_84153));
var state_84248__$1 = state_84248;
if(cljs.core.truth_(inst_84154)){
var statearr_84291_84349 = state_84248__$1;
(statearr_84291_84349[(1)] = (12));

} else {
var statearr_84292_84350 = state_84248__$1;
(statearr_84292_84350[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (5))){
var _ = (function (){var statearr_84293 = state_84248;
(statearr_84293[(4)] = cljs.core.rest.call(null,(state_84248[(4)])));

return statearr_84293;
})();
var state_84248__$1 = state_84248;
var ex84288 = (state_84248__$1[(2)]);
var statearr_84294_84351 = state_84248__$1;
(statearr_84294_84351[(5)] = ex84288);


var statearr_84295_84352 = state_84248__$1;
(statearr_84295_84352[(1)] = (4));

(statearr_84295_84352[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (14))){
var inst_84158 = (state_84248[(2)]);
var state_84248__$1 = state_84248;
var statearr_84296_84353 = state_84248__$1;
(statearr_84296_84353[(2)] = inst_84158);

(statearr_84296_84353[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (26))){
var inst_84176 = (state_84248[(7)]);
var inst_84188 = cljs.core.dissoc.call(null,inst_84176,new cljs.core.Keyword(null,"type","type",1174270348));
var state_84248__$1 = state_84248;
var statearr_84297_84354 = state_84248__$1;
(statearr_84297_84354[(2)] = inst_84188);

(statearr_84297_84354[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (16))){
var inst_84138 = (state_84248[(9)]);
var state_84248__$1 = state_84248;
var statearr_84298_84355 = state_84248__$1;
(statearr_84298_84355[(2)] = inst_84138);

(statearr_84298_84355[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (38))){
var state_84248__$1 = state_84248;
var statearr_84299_84356 = state_84248__$1;
(statearr_84299_84356[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (30))){
var inst_84176 = (state_84248[(7)]);
var inst_84204 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_84176);
var inst_84205 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),inst_84204);
var state_84248__$1 = state_84248;
if(inst_84205){
var statearr_84301_84357 = state_84248__$1;
(statearr_84301_84357[(1)] = (33));

} else {
var statearr_84302_84358 = state_84248__$1;
(statearr_84302_84358[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (10))){
var state_84248__$1 = state_84248;
var statearr_84303_84359 = state_84248__$1;
(statearr_84303_84359[(2)] = false);

(statearr_84303_84359[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (18))){
var inst_84168 = (state_84248[(13)]);
var inst_84172 = (state_84248[(12)]);
var inst_84167 = (state_84248[(14)]);
var inst_84145 = (state_84248[(10)]);
var inst_84171 = (state_84248[(2)]);
var inst_84172__$1 = fluree.db.util.async.throw_err.call(null,inst_84171);
var inst_84173 = fluree.db.query.graphql_parser.parse_graphql_to_flureeql.call(null,inst_84172__$1,inst_84167,inst_84168,inst_84145);
var state_84248__$1 = (function (){var statearr_84304 = state_84248;
(statearr_84304[(12)] = inst_84172__$1);

return statearr_84304;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84248__$1,(19),inst_84173);
} else {
if((state_val_84249 === (42))){
var state_84248__$1 = state_84248;
var statearr_84305_84360 = state_84248__$1;
(statearr_84305_84360[(2)] = null);

(statearr_84305_84360[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84249 === (37))){
var inst_84176 = (state_84248[(7)]);
var inst_84145 = (state_84248[(10)]);
var inst_84216 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_84176);
var inst_84217 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_84216,inst_84145);
var state_84248__$1 = state_84248;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84248__$1,(40),inst_84217);
} else {
if((state_val_84249 === (8))){
var inst_84138 = (state_84248[(9)]);
var inst_84139 = (state_84248[(15)]);
var inst_84144 = (state_84248[(2)]);
var inst_84145 = cljs.core.merge.call(null,inst_84139,inst_84144);
var inst_84147 = (inst_84138 == null);
var inst_84148 = cljs.core.not.call(null,inst_84147);
var state_84248__$1 = (function (){var statearr_84306 = state_84248;
(statearr_84306[(10)] = inst_84145);

return statearr_84306;
})();
if(inst_84148){
var statearr_84307_84361 = state_84248__$1;
(statearr_84307_84361[(1)] = (9));

} else {
var statearr_84308_84362 = state_84248__$1;
(statearr_84308_84362[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_84309 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_84309[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_84309[(1)] = (1));

return statearr_84309;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_84248){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_84248);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e84310){var ex__11472__auto__ = e84310;
var statearr_84311_84363 = state_84248;
(statearr_84311_84363[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_84248[(4)]))){
var statearr_84312_84364 = state_84248;
(statearr_84312_84364[(1)] = cljs.core.first.call(null,(state_84248[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84365 = state_84248;
state_84248 = G__84365;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_84248){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_84248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_84313 = f__11543__auto__.call(null);
(statearr_84313[(6)] = c__11542__auto__);

return statearr_84313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.graphql.cljs$lang$maxFixedArity = 4);

flureenjs.history_query = (function flureenjs$history_query(var_args){
var G__84367 = arguments.length;
switch (G__84367) {
case 2:
return flureenjs.history_query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.history_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.history_query', flureenjs.history_query);

(flureenjs.history_query.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return flureenjs.history_query.call(null,sources,query_map,null);
}));

(flureenjs.history_query.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_84394){
var state_val_84395 = (state_84394[(1)]);
if((state_val_84395 === (1))){
var state_84394__$1 = state_84394;
var statearr_84396_84412 = state_84394__$1;
(statearr_84396_84412[(2)] = null);

(statearr_84396_84412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84395 === (2))){
var _ = (function (){var statearr_84397 = state_84394;
(statearr_84397[(4)] = cljs.core.cons.call(null,(5),(state_84394[(4)])));

return statearr_84397;
})();
var inst_84376 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84377 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_84376);
var inst_84378 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84379 = cljs.core.merge.call(null,inst_84377,inst_84378);
var inst_84380 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_84381 = [inst_84379];
var inst_84382 = cljs.core.PersistentHashMap.fromArrays(inst_84380,inst_84381);
var inst_84383 = cljs.core.merge.call(null,inst_84376,inst_84382);
var inst_84384 = fluree.db.api.query.history_query_async.call(null,sources,inst_84383);
var state_84394__$1 = state_84394;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84394__$1,(6),inst_84384);
} else {
if((state_val_84395 === (3))){
var inst_84392 = (state_84394[(2)]);
var state_84394__$1 = state_84394;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84394__$1,inst_84392);
} else {
if((state_val_84395 === (4))){
var inst_84368 = (state_84394[(2)]);
var inst_84369 = fluree.db.util.log.error.call(null,inst_84368);
var inst_84370 = reject.call(null,inst_84368);
var state_84394__$1 = (function (){var statearr_84399 = state_84394;
(statearr_84399[(7)] = inst_84369);

return statearr_84399;
})();
var statearr_84400_84413 = state_84394__$1;
(statearr_84400_84413[(2)] = inst_84370);

(statearr_84400_84413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84395 === (5))){
var _ = (function (){var statearr_84401 = state_84394;
(statearr_84401[(4)] = cljs.core.rest.call(null,(state_84394[(4)])));

return statearr_84401;
})();
var state_84394__$1 = state_84394;
var ex84398 = (state_84394__$1[(2)]);
var statearr_84402_84414 = state_84394__$1;
(statearr_84402_84414[(5)] = ex84398);


var statearr_84403_84415 = state_84394__$1;
(statearr_84403_84415[(1)] = (4));

(statearr_84403_84415[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84395 === (6))){
var inst_84386 = (state_84394[(2)]);
var inst_84387 = fluree.db.util.async.throw_err.call(null,inst_84386);
var inst_84388 = cljs.core.clj__GT_js.call(null,inst_84387);
var inst_84389 = resolve.call(null,inst_84388);
var _ = (function (){var statearr_84404 = state_84394;
(statearr_84404[(4)] = cljs.core.rest.call(null,(state_84394[(4)])));

return statearr_84404;
})();
var state_84394__$1 = state_84394;
var statearr_84405_84416 = state_84394__$1;
(statearr_84405_84416[(2)] = inst_84389);

(statearr_84405_84416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_84406 = [null,null,null,null,null,null,null,null];
(statearr_84406[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_84406[(1)] = (1));

return statearr_84406;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_84394){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_84394);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e84407){var ex__11472__auto__ = e84407;
var statearr_84408_84417 = state_84394;
(statearr_84408_84417[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_84394[(4)]))){
var statearr_84409_84418 = state_84394;
(statearr_84409_84418[(1)] = cljs.core.first.call(null,(state_84394[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84419 = state_84394;
state_84394 = G__84419;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_84394){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_84394);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_84410 = f__11543__auto__.call(null);
(statearr_84410[(6)] = c__11542__auto__);

return statearr_84410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.history_query.cljs$lang$maxFixedArity = 3);

flureenjs.multi_query = (function flureenjs$multi_query(var_args){
var G__84421 = arguments.length;
switch (G__84421) {
case 2:
return flureenjs.multi_query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.multi_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.multi_query', flureenjs.multi_query);

(flureenjs.multi_query.cljs$core$IFn$_invoke$arity$2 = (function (source,multi_query_map){
return flureenjs.multi_query.call(null,source,multi_query_map,null);
}));

(flureenjs.multi_query.cljs$core$IFn$_invoke$arity$3 = (function (source,multi_query_map,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_84448){
var state_val_84449 = (state_84448[(1)]);
if((state_val_84449 === (1))){
var state_84448__$1 = state_84448;
var statearr_84450_84466 = state_84448__$1;
(statearr_84450_84466[(2)] = null);

(statearr_84450_84466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84449 === (2))){
var _ = (function (){var statearr_84451 = state_84448;
(statearr_84451[(4)] = cljs.core.cons.call(null,(5),(state_84448[(4)])));

return statearr_84451;
})();
var inst_84430 = cljs.core.js__GT_clj.call(null,multi_query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84431 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_84430);
var inst_84432 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84433 = cljs.core.merge.call(null,inst_84431,inst_84432);
var inst_84434 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_84435 = [inst_84433];
var inst_84436 = cljs.core.PersistentHashMap.fromArrays(inst_84434,inst_84435);
var inst_84437 = cljs.core.merge.call(null,inst_84430,inst_84436);
var inst_84438 = fluree.db.api.query.multi_query_async.call(null,source,inst_84437);
var state_84448__$1 = state_84448;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84448__$1,(6),inst_84438);
} else {
if((state_val_84449 === (3))){
var inst_84446 = (state_84448[(2)]);
var state_84448__$1 = state_84448;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84448__$1,inst_84446);
} else {
if((state_val_84449 === (4))){
var inst_84422 = (state_84448[(2)]);
var inst_84423 = fluree.db.util.log.error.call(null,inst_84422);
var inst_84424 = reject.call(null,inst_84422);
var state_84448__$1 = (function (){var statearr_84453 = state_84448;
(statearr_84453[(7)] = inst_84423);

return statearr_84453;
})();
var statearr_84454_84467 = state_84448__$1;
(statearr_84454_84467[(2)] = inst_84424);

(statearr_84454_84467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84449 === (5))){
var _ = (function (){var statearr_84455 = state_84448;
(statearr_84455[(4)] = cljs.core.rest.call(null,(state_84448[(4)])));

return statearr_84455;
})();
var state_84448__$1 = state_84448;
var ex84452 = (state_84448__$1[(2)]);
var statearr_84456_84468 = state_84448__$1;
(statearr_84456_84468[(5)] = ex84452);


var statearr_84457_84469 = state_84448__$1;
(statearr_84457_84469[(1)] = (4));

(statearr_84457_84469[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84449 === (6))){
var inst_84440 = (state_84448[(2)]);
var inst_84441 = fluree.db.util.async.throw_err.call(null,inst_84440);
var inst_84442 = cljs.core.clj__GT_js.call(null,inst_84441);
var inst_84443 = resolve.call(null,inst_84442);
var _ = (function (){var statearr_84458 = state_84448;
(statearr_84458[(4)] = cljs.core.rest.call(null,(state_84448[(4)])));

return statearr_84458;
})();
var state_84448__$1 = state_84448;
var statearr_84459_84470 = state_84448__$1;
(statearr_84459_84470[(2)] = inst_84443);

(statearr_84459_84470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_84460 = [null,null,null,null,null,null,null,null];
(statearr_84460[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_84460[(1)] = (1));

return statearr_84460;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_84448){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_84448);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e84461){var ex__11472__auto__ = e84461;
var statearr_84462_84471 = state_84448;
(statearr_84462_84471[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_84448[(4)]))){
var statearr_84463_84472 = state_84448;
(statearr_84463_84472[(1)] = cljs.core.first.call(null,(state_84448[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84473 = state_84448;
state_84448 = G__84473;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_84448){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_84448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_84464 = f__11543__auto__.call(null);
(statearr_84464[(6)] = c__11542__auto__);

return statearr_84464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.multi_query.cljs$lang$maxFixedArity = 3);

/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise that eventually contains the results or
 *   an exception.
 */
flureenjs.query = (function flureenjs$query(source,query_map){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_84494){
var state_val_84495 = (state_84494[(1)]);
if((state_val_84495 === (1))){
var state_84494__$1 = state_84494;
var statearr_84496_84511 = state_84494__$1;
(statearr_84496_84511[(2)] = null);

(statearr_84496_84511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84495 === (2))){
var _ = (function (){var statearr_84497 = state_84494;
(statearr_84497[(4)] = cljs.core.cons.call(null,(5),(state_84494[(4)])));

return statearr_84497;
})();
var inst_84483 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84484 = fluree.db.api.query.query.call(null,source,inst_84483);
var state_84494__$1 = state_84494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84494__$1,(6),inst_84484);
} else {
if((state_val_84495 === (3))){
var inst_84492 = (state_84494[(2)]);
var state_84494__$1 = state_84494;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84494__$1,inst_84492);
} else {
if((state_val_84495 === (4))){
var inst_84474 = (state_84494[(2)]);
var inst_84475 = fluree.db.util.log.error.call(null,inst_84474);
var inst_84476 = cljs.core.clj__GT_js.call(null,inst_84474);
var inst_84477 = reject.call(null,inst_84476);
var state_84494__$1 = (function (){var statearr_84499 = state_84494;
(statearr_84499[(7)] = inst_84475);

return statearr_84499;
})();
var statearr_84500_84512 = state_84494__$1;
(statearr_84500_84512[(2)] = inst_84477);

(statearr_84500_84512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84495 === (5))){
var _ = (function (){var statearr_84501 = state_84494;
(statearr_84501[(4)] = cljs.core.rest.call(null,(state_84494[(4)])));

return statearr_84501;
})();
var state_84494__$1 = state_84494;
var ex84498 = (state_84494__$1[(2)]);
var statearr_84502_84513 = state_84494__$1;
(statearr_84502_84513[(5)] = ex84498);


var statearr_84503_84514 = state_84494__$1;
(statearr_84503_84514[(1)] = (4));

(statearr_84503_84514[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84495 === (6))){
var inst_84486 = (state_84494[(2)]);
var inst_84487 = fluree.db.util.async.throw_err.call(null,inst_84486);
var inst_84488 = cljs.core.clj__GT_js.call(null,inst_84487);
var inst_84489 = resolve.call(null,inst_84488);
var _ = (function (){var statearr_84504 = state_84494;
(statearr_84504[(4)] = cljs.core.rest.call(null,(state_84494[(4)])));

return statearr_84504;
})();
var state_84494__$1 = state_84494;
var statearr_84505_84515 = state_84494__$1;
(statearr_84505_84515[(2)] = inst_84489);

(statearr_84505_84515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$query_$_state_machine__11469__auto__ = null;
var flureenjs$query_$_state_machine__11469__auto____0 = (function (){
var statearr_84506 = [null,null,null,null,null,null,null,null];
(statearr_84506[(0)] = flureenjs$query_$_state_machine__11469__auto__);

(statearr_84506[(1)] = (1));

return statearr_84506;
});
var flureenjs$query_$_state_machine__11469__auto____1 = (function (state_84494){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_84494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e84507){var ex__11472__auto__ = e84507;
var statearr_84508_84516 = state_84494;
(statearr_84508_84516[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_84494[(4)]))){
var statearr_84509_84517 = state_84494;
(statearr_84509_84517[(1)] = cljs.core.first.call(null,(state_84494[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84518 = state_84494;
state_84494 = G__84518;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$query_$_state_machine__11469__auto__ = function(state_84494){
switch(arguments.length){
case 0:
return flureenjs$query_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$query_$_state_machine__11469__auto____1.call(this,state_84494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$query_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$query_$_state_machine__11469__auto____0;
flureenjs$query_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$query_$_state_machine__11469__auto____1;
return flureenjs$query_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_84510 = f__11543__auto__.call(null);
(statearr_84510[(6)] = c__11542__auto__);

return statearr_84510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.query', flureenjs.query);
/**
 * Execute a query against a database source, with the
 *   given flakes applied.
 * 
 *   Returns promise that eventually contains the results or
 *   an exception.
 */
flureenjs.query_with = (function flureenjs$query_with(db,param){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_84568){
var state_val_84569 = (state_84568[(1)]);
if((state_val_84569 === (7))){
var state_84568__$1 = state_84568;
var statearr_84570_84599 = state_84568__$1;
(statearr_84570_84599[(2)] = false);

(statearr_84570_84599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84569 === (1))){
var state_84568__$1 = state_84568;
var statearr_84571_84600 = state_84568__$1;
(statearr_84571_84600[(2)] = null);

(statearr_84571_84600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84569 === (4))){
var inst_84519 = (state_84568[(2)]);
var inst_84520 = fluree.db.util.log.error.call(null,inst_84519);
var inst_84521 = cljs.core.clj__GT_js.call(null,inst_84519);
var inst_84522 = reject.call(null,inst_84521);
var state_84568__$1 = (function (){var statearr_84572 = state_84568;
(statearr_84572[(7)] = inst_84520);

return statearr_84572;
})();
var statearr_84573_84601 = state_84568__$1;
(statearr_84573_84601[(2)] = inst_84522);

(statearr_84573_84601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84569 === (15))){
var inst_84553 = (state_84568[(8)]);
var inst_84551 = (state_84568[(9)]);
var inst_84555 = (state_84568[(2)]);
var inst_84556 = fluree.db.util.async.throw_err.call(null,inst_84555);
var inst_84557 = fluree.db.dbproto._forward_time_travel.call(null,inst_84556,inst_84553);
var inst_84558 = fluree.db.api.query.query.call(null,inst_84557,inst_84551);
var state_84568__$1 = state_84568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84568__$1,(16),inst_84558);
} else {
if((state_val_84569 === (13))){
var inst_84529 = (state_84568[(10)]);
var state_84568__$1 = state_84568;
var statearr_84574_84602 = state_84568__$1;
(statearr_84574_84602[(2)] = inst_84529);

(statearr_84574_84602[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84569 === (6))){
var inst_84529 = (state_84568[(10)]);
var inst_84534 = inst_84529.cljs$lang$protocol_mask$partition0$;
var inst_84535 = (inst_84534 & (64));
var inst_84536 = inst_84529.cljs$core$ISeq$;
var inst_84537 = (cljs.core.PROTOCOL_SENTINEL === inst_84536);
var inst_84538 = ((inst_84535) || (inst_84537));
var state_84568__$1 = state_84568;
if(cljs.core.truth_(inst_84538)){
var statearr_84575_84603 = state_84568__$1;
(statearr_84575_84603[(1)] = (9));

} else {
var statearr_84576_84604 = state_84568__$1;
(statearr_84576_84604[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84569 === (3))){
var inst_84566 = (state_84568[(2)]);
var state_84568__$1 = state_84568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84568__$1,inst_84566);
} else {
if((state_val_84569 === (12))){
var inst_84529 = (state_84568[(10)]);
var inst_84547 = cljs.core.apply.call(null,cljs.core.hash_map,inst_84529);
var state_84568__$1 = state_84568;
var statearr_84577_84605 = state_84568__$1;
(statearr_84577_84605[(2)] = inst_84547);

(statearr_84577_84605[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84569 === (2))){
var inst_84529 = (state_84568[(10)]);
var _ = (function (){var statearr_84578 = state_84568;
(statearr_84578[(4)] = cljs.core.cons.call(null,(5),(state_84568[(4)])));

return statearr_84578;
})();
var inst_84529__$1 = cljs.core.js__GT_clj.call(null,param,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84531 = (inst_84529__$1 == null);
var inst_84532 = cljs.core.not.call(null,inst_84531);
var state_84568__$1 = (function (){var statearr_84579 = state_84568;
(statearr_84579[(10)] = inst_84529__$1);

return statearr_84579;
})();
if(inst_84532){
var statearr_84580_84606 = state_84568__$1;
(statearr_84580_84606[(1)] = (6));

} else {
var statearr_84581_84607 = state_84568__$1;
(statearr_84581_84607[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84569 === (11))){
var inst_84542 = (state_84568[(2)]);
var state_84568__$1 = state_84568;
var statearr_84583_84608 = state_84568__$1;
(statearr_84583_84608[(2)] = inst_84542);

(statearr_84583_84608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84569 === (9))){
var state_84568__$1 = state_84568;
var statearr_84584_84609 = state_84568__$1;
(statearr_84584_84609[(2)] = true);

(statearr_84584_84609[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84569 === (5))){
var _ = (function (){var statearr_84585 = state_84568;
(statearr_84585[(4)] = cljs.core.rest.call(null,(state_84568[(4)])));

return statearr_84585;
})();
var state_84568__$1 = state_84568;
var ex84582 = (state_84568__$1[(2)]);
var statearr_84586_84610 = state_84568__$1;
(statearr_84586_84610[(5)] = ex84582);


var statearr_84587_84611 = state_84568__$1;
(statearr_84587_84611[(1)] = (4));

(statearr_84587_84611[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84569 === (14))){
var inst_84550 = (state_84568[(2)]);
var inst_84551 = cljs.core.get.call(null,inst_84550,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_84552 = cljs.core.get.call(null,inst_84550,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_84553 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_84552);
var state_84568__$1 = (function (){var statearr_84588 = state_84568;
(statearr_84588[(8)] = inst_84553);

(statearr_84588[(9)] = inst_84551);

return statearr_84588;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84568__$1,(15),db);
} else {
if((state_val_84569 === (16))){
var inst_84560 = (state_84568[(2)]);
var inst_84561 = fluree.db.util.async.throw_err.call(null,inst_84560);
var inst_84562 = cljs.core.clj__GT_js.call(null,inst_84561);
var inst_84563 = resolve.call(null,inst_84562);
var _ = (function (){var statearr_84589 = state_84568;
(statearr_84589[(4)] = cljs.core.rest.call(null,(state_84568[(4)])));

return statearr_84589;
})();
var state_84568__$1 = state_84568;
var statearr_84590_84612 = state_84568__$1;
(statearr_84590_84612[(2)] = inst_84563);

(statearr_84590_84612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84569 === (10))){
var state_84568__$1 = state_84568;
var statearr_84591_84613 = state_84568__$1;
(statearr_84591_84613[(2)] = false);

(statearr_84591_84613[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84569 === (8))){
var inst_84545 = (state_84568[(2)]);
var state_84568__$1 = state_84568;
if(cljs.core.truth_(inst_84545)){
var statearr_84592_84614 = state_84568__$1;
(statearr_84592_84614[(1)] = (12));

} else {
var statearr_84593_84615 = state_84568__$1;
(statearr_84593_84615[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$query_with_$_state_machine__11469__auto__ = null;
var flureenjs$query_with_$_state_machine__11469__auto____0 = (function (){
var statearr_84594 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_84594[(0)] = flureenjs$query_with_$_state_machine__11469__auto__);

(statearr_84594[(1)] = (1));

return statearr_84594;
});
var flureenjs$query_with_$_state_machine__11469__auto____1 = (function (state_84568){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_84568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e84595){var ex__11472__auto__ = e84595;
var statearr_84596_84616 = state_84568;
(statearr_84596_84616[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_84568[(4)]))){
var statearr_84597_84617 = state_84568;
(statearr_84597_84617[(1)] = cljs.core.first.call(null,(state_84568[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84618 = state_84568;
state_84568 = G__84618;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$query_with_$_state_machine__11469__auto__ = function(state_84568){
switch(arguments.length){
case 0:
return flureenjs$query_with_$_state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$query_with_$_state_machine__11469__auto____1.call(this,state_84568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$query_with_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$query_with_$_state_machine__11469__auto____0;
flureenjs$query_with_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$query_with_$_state_machine__11469__auto____1;
return flureenjs$query_with_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_84598 = f__11543__auto__.call(null);
(statearr_84598[(6)] = c__11542__auto__);

return statearr_84598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
goog.exportSymbol('flureenjs.query_with', flureenjs.query_with);
/**
 * Exceute a sparql query against a specified database
 */
flureenjs.sparql = (function flureenjs$sparql(var_args){
var G__84620 = arguments.length;
switch (G__84620) {
case 2:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sparql', flureenjs.sparql);

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$2 = (function (db,sparql_str){
return flureenjs.sparql.call(null,db,sparql_str,null);
}));

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$3 = (function (db,sparql_str,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_84650){
var state_val_84651 = (state_84650[(1)]);
if((state_val_84651 === (7))){
var state_84650__$1 = state_84650;
var statearr_84652_84673 = state_84650__$1;
(statearr_84652_84673[(2)] = null);

(statearr_84652_84673[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84651 === (1))){
var state_84650__$1 = state_84650;
var statearr_84653_84674 = state_84650__$1;
(statearr_84653_84674[(2)] = null);

(statearr_84653_84674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84651 === (4))){
var inst_84621 = (state_84650[(2)]);
var inst_84622 = fluree.db.util.log.error.call(null,inst_84621);
var inst_84623 = cljs.core.clj__GT_js.call(null,inst_84621);
var inst_84624 = reject.call(null,inst_84623);
var state_84650__$1 = (function (){var statearr_84654 = state_84650;
(statearr_84654[(7)] = inst_84622);

return statearr_84654;
})();
var statearr_84655_84675 = state_84650__$1;
(statearr_84655_84675[(2)] = inst_84624);

(statearr_84655_84675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84651 === (6))){
var inst_84634 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_84650__$1 = state_84650;
var statearr_84656_84676 = state_84650__$1;
(statearr_84656_84676[(2)] = inst_84634);

(statearr_84656_84676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84651 === (3))){
var inst_84648 = (state_84650[(2)]);
var state_84650__$1 = state_84650;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84650__$1,inst_84648);
} else {
if((state_val_84651 === (2))){
var inst_84631 = (state_84650[(8)]);
var _ = (function (){var statearr_84658 = state_84650;
(statearr_84658[(4)] = cljs.core.cons.call(null,(5),(state_84650[(4)])));

return statearr_84658;
})();
var inst_84630 = fluree.db.util.json.parse.call(null,sparql_str);
var inst_84631__$1 = fluree.db.query.sparql_parser.sparql_to_ad_hoc.call(null,inst_84630);
var inst_84632 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_84631__$1);
var state_84650__$1 = (function (){var statearr_84659 = state_84650;
(statearr_84659[(9)] = inst_84632);

(statearr_84659[(8)] = inst_84631__$1);

return statearr_84659;
})();
if(cljs.core.truth_(opts)){
var statearr_84660_84677 = state_84650__$1;
(statearr_84660_84677[(1)] = (6));

} else {
var statearr_84661_84678 = state_84650__$1;
(statearr_84661_84678[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84651 === (9))){
var inst_84642 = (state_84650[(2)]);
var inst_84643 = fluree.db.util.async.throw_err.call(null,inst_84642);
var inst_84644 = cljs.core.clj__GT_js.call(null,inst_84643);
var inst_84645 = resolve.call(null,inst_84644);
var _ = (function (){var statearr_84662 = state_84650;
(statearr_84662[(4)] = cljs.core.rest.call(null,(state_84650[(4)])));

return statearr_84662;
})();
var state_84650__$1 = state_84650;
var statearr_84663_84679 = state_84650__$1;
(statearr_84663_84679[(2)] = inst_84645);

(statearr_84663_84679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84651 === (5))){
var _ = (function (){var statearr_84664 = state_84650;
(statearr_84664[(4)] = cljs.core.rest.call(null,(state_84650[(4)])));

return statearr_84664;
})();
var state_84650__$1 = state_84650;
var ex84657 = (state_84650__$1[(2)]);
var statearr_84665_84680 = state_84650__$1;
(statearr_84665_84680[(5)] = ex84657);


var statearr_84666_84681 = state_84650__$1;
(statearr_84666_84681[(1)] = (4));

(statearr_84666_84681[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84651 === (8))){
var inst_84632 = (state_84650[(9)]);
var inst_84631 = (state_84650[(8)]);
var inst_84637 = (state_84650[(2)]);
var inst_84638 = cljs.core.merge.call(null,inst_84632,inst_84637);
var inst_84639 = cljs.core.assoc.call(null,inst_84631,new cljs.core.Keyword(null,"opts","opts",155075701),inst_84638);
var inst_84640 = fluree.db.api.query.query_async.call(null,db,inst_84639);
var state_84650__$1 = state_84650;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84650__$1,(9),inst_84640);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_84667 = [null,null,null,null,null,null,null,null,null,null];
(statearr_84667[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_84667[(1)] = (1));

return statearr_84667;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_84650){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_84650);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e84668){var ex__11472__auto__ = e84668;
var statearr_84669_84682 = state_84650;
(statearr_84669_84682[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_84650[(4)]))){
var statearr_84670_84683 = state_84650;
(statearr_84670_84683[(1)] = cljs.core.first.call(null,(state_84650[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84684 = state_84650;
state_84650 = G__84684;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_84650){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_84650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_84671 = f__11543__auto__.call(null);
(statearr_84671[(6)] = c__11542__auto__);

return statearr_84671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.sparql.cljs$lang$maxFixedArity = 3);

/**
 * Exceute a sql query against a specified database
 */
flureenjs.sql = (function flureenjs$sql(var_args){
var G__84686 = arguments.length;
switch (G__84686) {
case 2:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sql', flureenjs.sql);

(flureenjs.sql.cljs$core$IFn$_invoke$arity$2 = (function (db,sql_str){
return flureenjs.sql.call(null,db,sql_str,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.sql.cljs$core$IFn$_invoke$arity$3 = (function (db,sql_str,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_84710){
var state_val_84711 = (state_84710[(1)]);
if((state_val_84711 === (1))){
var state_84710__$1 = state_84710;
var statearr_84712_84728 = state_84710__$1;
(statearr_84712_84728[(2)] = null);

(statearr_84712_84728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84711 === (2))){
var _ = (function (){var statearr_84713 = state_84710;
(statearr_84713[(4)] = cljs.core.cons.call(null,(5),(state_84710[(4)])));

return statearr_84713;
})();
var inst_84696 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84697 = fluree.db.util.json.parse.call(null,sql_str);
var inst_84698 = fluree.db.query.sql.parse.call(null,inst_84697);
var inst_84699 = cljs.core.update.call(null,inst_84698,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_84696);
var inst_84700 = fluree.db.api.query.query_async.call(null,db,inst_84699);
var state_84710__$1 = state_84710;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84710__$1,(6),inst_84700);
} else {
if((state_val_84711 === (3))){
var inst_84708 = (state_84710[(2)]);
var state_84710__$1 = state_84710;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84710__$1,inst_84708);
} else {
if((state_val_84711 === (4))){
var inst_84687 = (state_84710[(2)]);
var inst_84688 = fluree.db.util.log.error.call(null,inst_84687);
var inst_84689 = cljs.core.clj__GT_js.call(null,inst_84687);
var inst_84690 = reject.call(null,inst_84689);
var state_84710__$1 = (function (){var statearr_84715 = state_84710;
(statearr_84715[(7)] = inst_84688);

return statearr_84715;
})();
var statearr_84716_84729 = state_84710__$1;
(statearr_84716_84729[(2)] = inst_84690);

(statearr_84716_84729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84711 === (5))){
var _ = (function (){var statearr_84717 = state_84710;
(statearr_84717[(4)] = cljs.core.rest.call(null,(state_84710[(4)])));

return statearr_84717;
})();
var state_84710__$1 = state_84710;
var ex84714 = (state_84710__$1[(2)]);
var statearr_84718_84730 = state_84710__$1;
(statearr_84718_84730[(5)] = ex84714);


var statearr_84719_84731 = state_84710__$1;
(statearr_84719_84731[(1)] = (4));

(statearr_84719_84731[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84711 === (6))){
var inst_84702 = (state_84710[(2)]);
var inst_84703 = fluree.db.util.async.throw_err.call(null,inst_84702);
var inst_84704 = cljs.core.clj__GT_js.call(null,inst_84703);
var inst_84705 = resolve.call(null,inst_84704);
var _ = (function (){var statearr_84720 = state_84710;
(statearr_84720[(4)] = cljs.core.rest.call(null,(state_84710[(4)])));

return statearr_84720;
})();
var state_84710__$1 = state_84710;
var statearr_84721_84732 = state_84710__$1;
(statearr_84721_84732[(2)] = inst_84705);

(statearr_84721_84732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__11469__auto__ = null;
var flureenjs$state_machine__11469__auto____0 = (function (){
var statearr_84722 = [null,null,null,null,null,null,null,null];
(statearr_84722[(0)] = flureenjs$state_machine__11469__auto__);

(statearr_84722[(1)] = (1));

return statearr_84722;
});
var flureenjs$state_machine__11469__auto____1 = (function (state_84710){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_84710);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e84723){var ex__11472__auto__ = e84723;
var statearr_84724_84733 = state_84710;
(statearr_84724_84733[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_84710[(4)]))){
var statearr_84725_84734 = state_84710;
(statearr_84725_84734[(1)] = cljs.core.first.call(null,(state_84710[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84735 = state_84710;
state_84710 = G__84735;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
flureenjs$state_machine__11469__auto__ = function(state_84710){
switch(arguments.length){
case 0:
return flureenjs$state_machine__11469__auto____0.call(this);
case 1:
return flureenjs$state_machine__11469__auto____1.call(this,state_84710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__11469__auto____0;
flureenjs$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__11469__auto____1;
return flureenjs$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_84726 = f__11543__auto__.call(null);
(statearr_84726[(6)] = c__11542__auto__);

return statearr_84726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(flureenjs.sql.cljs$lang$maxFixedArity = 3);

