// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('alphabase.bytes');
goog.require('cljs.core');
goog.require('cljs.core.constants');
/**
 * Coerces a number to a byte value.
 */
alphabase.bytes.to_byte = (function alphabase$bytes$to_byte(x){
return x;
});
/**
 * Coerces a byte value to a number.
 */
alphabase.bytes.from_byte = (function alphabase$bytes$from_byte(x){
return x;
});
/**
 * Reads a byte value out of an array and coerces it to a number.
 */
alphabase.bytes.get_byte = (function alphabase$bytes$get_byte(array,i){
return alphabase.bytes.from_byte((array[i]));
});
/**
 * Sets a byte value in an array after coercing it from a number.
 */
alphabase.bytes.set_byte = (function alphabase$bytes$set_byte(array,i,x){
return (array[i] = alphabase.bytes.to_byte(x));
});
/**
 * Return a sequence of the bytes in an array, after coercion.
 */
alphabase.bytes.byte_seq = (function alphabase$bytes$byte_seq(array){
if(cljs.core.truth_(array)){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15698_SHARP_){
return (array[p1__15698_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(array.length));
} else {
return null;
}
});
/**
 * True if the argument is a byte array compatible with this library.
 */
alphabase.bytes.bytes_QMARK_ = (function alphabase$bytes$bytes_QMARK_(x){
return (((x instanceof Uint8Array)) || ((((x instanceof Array)) && (((cljs.core.empty_QMARK_(x)) || (cljs.core.integer_QMARK_(cljs.core.first(x))))))));
});
/**
 * Returns true if two byte sequences are the same length and have the same
 *   byte content.
 */
alphabase.bytes.bytes_EQ_ = (function alphabase$bytes$bytes_EQ_(a,b){
if(alphabase.bytes.bytes_QMARK_(a)){
if(alphabase.bytes.bytes_QMARK_(b)){
var a__$1 = a;
var b__$1 = b;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a__$1.length,b__$1.length)){
var i = (0);
while(true){
if((i < a__$1.length)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(alphabase.bytes.get_byte(a__$1,i),alphabase.bytes.get_byte(b__$1,i))){
var G__15699 = (i + (1));
i = G__15699;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return false;
}
} else {
return false;
}
});
/**
 * Creates a new array to hold byte data.
 */
alphabase.bytes.byte_array = (function alphabase$bytes$byte_array(length){
return (new Uint8Array((new ArrayBuffer(length))));
});
/**
 * Copies bytes from one array to another.
 * 
 *   - If only a source is given, returns a full copy of the byte array.
 *   - If a source and a destination with offset are given, copies all of the
 *  bytes from the source into the destination at that offset. Returns the
 *  number of bytes copied.
 *   - If all arguments are given, copies `length` bytes from the source at the
 *  given offset to the destination at its offset. Returns the number of bytes
 *  copied.
 */
alphabase.bytes.copy = (function alphabase$bytes$copy(var_args){
var G__15701 = arguments.length;
switch (G__15701) {
case 1:
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$1 = (function (src){
var dst = alphabase.bytes.byte_array(src.length);
alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$3(src,dst,(0));

return dst;
}));

(alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$3 = (function (src,dst,dst_offset){
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5(src,(0),dst,dst_offset,src.length);
}));

(alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5 = (function (src,src_offset,dst,dst_offset,length){
var n__4613__auto___15703 = length;
var i_15704 = (0);
while(true){
if((i_15704 < n__4613__auto___15703)){
alphabase.bytes.set_byte(dst,(i_15704 + dst_offset),alphabase.bytes.get_byte(src,(i_15704 + src_offset)));

var G__15705 = (i_15704 + (1));
i_15704 = G__15705;
continue;
} else {
}
break;
}

return length;
}));

(alphabase.bytes.copy.cljs$lang$maxFixedArity = 5);

/**
 * Initialize a new array with the given sequence of byte values.
 */
alphabase.bytes.init_bytes = (function alphabase$bytes$init_bytes(values){
var length = cljs.core.count(values);
var data = alphabase.bytes.byte_array(length);
var n__4613__auto___15706 = length;
var i_15707 = (0);
while(true){
if((i_15707 < n__4613__auto___15706)){
alphabase.bytes.set_byte(data,i_15707,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(values,i_15707));

var G__15708 = (i_15707 + (1));
i_15707 = G__15708;
continue;
} else {
}
break;
}

return data;
});
/**
 * Returns a byte array `length` bytes long with random content.
 */
alphabase.bytes.random_bytes = (function alphabase$bytes$random_bytes(length){
var data = alphabase.bytes.byte_array(length);
var n__4613__auto___15709 = length;
var i_15710 = (0);
while(true){
if((i_15710 < n__4613__auto___15709)){
alphabase.bytes.set_byte(data,i_15710,cljs.core.rand_int((256)));

var G__15711 = (i_15710 + (1));
i_15710 = G__15711;
continue;
} else {
}
break;
}

return data;
});
/**
 * Lexicographically compares two byte-arrays for order. Returns a negative
 *   number, zero, or a positive number if `a` is less than, equal to, or greater
 *   than `b`, respectively.
 * 
 *   This ranking compares each byte in the keys in order; the first byte which
 *   differs determines the ordering; if the byte in `a` is less than the byte in
 *   `b`, `a` ranks before `b`, and vice versa.
 * 
 *   If the keys differ in length, and all the bytes in the shorter key match the
 *   longer key, the shorter key ranks first.
 */
alphabase.bytes.compare = (function alphabase$bytes$compare(a,b){
var prefix_len = (function (){var x__4217__auto__ = a.length;
var y__4218__auto__ = b.length;
return ((x__4217__auto__ < y__4218__auto__) ? x__4217__auto__ : y__4218__auto__);
})();
var i = (0);
while(true){
if((i < prefix_len)){
var ai = alphabase.bytes.get_byte(a,i);
var bi = alphabase.bytes.get_byte(b,i);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ai,bi)){
var G__15712 = (i + (1));
i = G__15712;
continue;
} else {
return (ai - bi);
}
} else {
return (a.length - b.length);
}
break;
}
});
/**
 * Copy a slice (defined by offset, length) from a byte array.
 * 
 *   Omitting the slice `len` argument will copy remainder of
 *   `src` array from offset (e.g, `(- (alength src) offset)` bytes).
 */
alphabase.bytes.copy_slice = (function alphabase$bytes$copy_slice(var_args){
var G__15714 = arguments.length;
switch (G__15714) {
case 3:
return alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$3 = (function (src,offset,len){
var dst = alphabase.bytes.byte_array(len);
alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5(src,offset,dst,(0),len);

return dst;
}));

(alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$2 = (function (src,offset){
return alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$3(src,offset,(src.length - offset));
}));

(alphabase.bytes.copy_slice.cljs$lang$maxFixedArity = 3);

/**
 * Concatenate bytes arrays into a single new byte array.
 */
alphabase.bytes.concat = (function alphabase$bytes$concat(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15718 = arguments.length;
var i__4737__auto___15719 = (0);
while(true){
if((i__4737__auto___15719 < len__4736__auto___15718)){
args__4742__auto__.push((arguments[i__4737__auto___15719]));

var G__15720 = (i__4737__auto___15719 + (1));
i__4737__auto___15719 = G__15720;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return alphabase.bytes.concat.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(alphabase.bytes.concat.cljs$core$IFn$_invoke$arity$variadic = (function (arrs){
var arrs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,arrs);
var total_len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15716_SHARP_){
return p1__15716_SHARP_.length;
}),arrs__$1));
var dst = alphabase.bytes.byte_array(total_len);
var arrs_15721__$2 = arrs__$1;
var offset_15722 = (0);
while(true){
var temp__5735__auto___15723 = cljs.core.first(arrs_15721__$2);
if(cljs.core.truth_(temp__5735__auto___15723)){
var src_15724 = temp__5735__auto___15723;
alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5(src_15724,(0),dst,offset_15722,src_15724.length);

var G__15725 = cljs.core.rest(arrs_15721__$2);
var G__15726 = (offset_15722 + src_15724.length);
arrs_15721__$2 = G__15725;
offset_15722 = G__15726;
continue;
} else {
}
break;
}

return dst;
}));

(alphabase.bytes.concat.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(alphabase.bytes.concat.cljs$lang$applyTo = (function (seq15717){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq15717));
}));

