// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_36622){
var state_val_36623 = (state_36622[(1)]);
if((state_val_36623 === (1))){
var state_36622__$1 = state_36622;
var statearr_36624_36638 = state_36622__$1;
(statearr_36624_36638[(2)] = null);

(statearr_36624_36638[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (2))){
var _ = (function (){var statearr_36625 = state_36622;
(statearr_36625[(4)] = cljs.core.cons((5),(state_36622[(4)])));

return statearr_36625;
})();
var inst_36613 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_36622__$1 = state_36622;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36622__$1,(6),inst_36613);
} else {
if((state_val_36623 === (3))){
var inst_36620 = (state_36622[(2)]);
var state_36622__$1 = state_36622;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36622__$1,inst_36620);
} else {
if((state_val_36623 === (4))){
var inst_36607 = (state_36622[(2)]);
var state_36622__$1 = state_36622;
var statearr_36627_36639 = state_36622__$1;
(statearr_36627_36639[(2)] = inst_36607);

(statearr_36627_36639[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (5))){
var _ = (function (){var statearr_36628 = state_36622;
(statearr_36628[(4)] = cljs.core.rest((state_36622[(4)])));

return statearr_36628;
})();
var state_36622__$1 = state_36622;
var ex36626 = (state_36622__$1[(2)]);
var statearr_36629_36640 = state_36622__$1;
(statearr_36629_36640[(5)] = ex36626);


if((ex36626 instanceof Error)){
var statearr_36630_36641 = state_36622__$1;
(statearr_36630_36641[(1)] = (4));

(statearr_36630_36641[(5)] = null);

} else {
throw ex36626;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (6))){
var inst_36615 = (state_36622[(2)]);
var inst_36616 = fluree.db.util.async.throw_err(inst_36615);
var inst_36617 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_36616);
var _ = (function (){var statearr_36631 = state_36622;
(statearr_36631[(4)] = cljs.core.rest((state_36622[(4)])));

return statearr_36631;
})();
var state_36622__$1 = state_36622;
var statearr_36632_36642 = state_36622__$1;
(statearr_36632_36642[(2)] = inst_36617);

(statearr_36632_36642[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16291__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16291__auto____0 = (function (){
var statearr_36633 = [null,null,null,null,null,null,null];
(statearr_36633[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16291__auto__);

(statearr_36633[(1)] = (1));

return statearr_36633;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16291__auto____1 = (function (state_36622){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_36622);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e36634){var ex__16294__auto__ = e36634;
var statearr_36635_36643 = state_36622;
(statearr_36635_36643[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_36622[(4)]))){
var statearr_36636_36644 = state_36622;
(statearr_36636_36644[(1)] = cljs.core.first((state_36622[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__36645 = state_36622;
state_36622 = G__36645;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16291__auto__ = function(state_36622){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16291__auto____1.call(this,state_36622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16291__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16291__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_36637 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_36637[(6)] = c__16328__auto__);

return statearr_36637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_36677){
var state_val_36678 = (state_36677[(1)]);
if((state_val_36678 === (7))){
var inst_36661 = (state_36677[(7)]);
var inst_36663 = cljs.core.empty_QMARK_(inst_36661);
var inst_36664 = (!(inst_36663));
var state_36677__$1 = state_36677;
var statearr_36679_36703 = state_36677__$1;
(statearr_36679_36703[(2)] = inst_36664);

(statearr_36679_36703[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36678 === (1))){
var state_36677__$1 = state_36677;
var statearr_36680_36704 = state_36677__$1;
(statearr_36680_36704[(2)] = null);

(statearr_36680_36704[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36678 === (4))){
var inst_36647 = (state_36677[(2)]);
var state_36677__$1 = state_36677;
var statearr_36681_36705 = state_36677__$1;
(statearr_36681_36705[(2)] = inst_36647);

(statearr_36681_36705[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36678 === (6))){
var inst_36653 = (state_36677[(8)]);
var inst_36661 = (state_36677[(7)]);
var inst_36659 = (state_36677[(2)]);
var inst_36660 = fluree.db.util.async.throw_err(inst_36659);
var inst_36661__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_36653,inst_36660);
var state_36677__$1 = (function (){var statearr_36682 = state_36677;
(statearr_36682[(7)] = inst_36661__$1);

return statearr_36682;
})();
if(cljs.core.truth_(inst_36661__$1)){
var statearr_36683_36706 = state_36677__$1;
(statearr_36683_36706[(1)] = (7));

} else {
var statearr_36684_36707 = state_36677__$1;
(statearr_36684_36707[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36678 === (3))){
var inst_36675 = (state_36677[(2)]);
var state_36677__$1 = state_36677;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36677__$1,inst_36675);
} else {
if((state_val_36678 === (12))){
var inst_36672 = (state_36677[(2)]);
var _ = (function (){var statearr_36685 = state_36677;
(statearr_36685[(4)] = cljs.core.rest((state_36677[(4)])));

return statearr_36685;
})();
var state_36677__$1 = state_36677;
var statearr_36686_36708 = state_36677__$1;
(statearr_36686_36708[(2)] = inst_36672);

(statearr_36686_36708[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36678 === (2))){
var _ = (function (){var statearr_36687 = state_36677;
(statearr_36687[(4)] = cljs.core.cons((5),(state_36677[(4)])));

return statearr_36687;
})();
var inst_36653 = (function (){return (function (p1__36646_SHARP_){
return p1__36646_SHARP_.o;
});
})();
var inst_36654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36655 = [pred_id];
var inst_36656 = (new cljs.core.PersistentVector(null,1,(5),inst_36654,inst_36655,null));
var inst_36657 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_36656);
var state_36677__$1 = (function (){var statearr_36688 = state_36677;
(statearr_36688[(8)] = inst_36653);

return statearr_36688;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36677__$1,(6),inst_36657);
} else {
if((state_val_36678 === (11))){
var state_36677__$1 = state_36677;
var statearr_36690_36709 = state_36677__$1;
(statearr_36690_36709[(2)] = true);

(statearr_36690_36709[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36678 === (9))){
var inst_36667 = (state_36677[(2)]);
var state_36677__$1 = state_36677;
if(cljs.core.truth_(inst_36667)){
var statearr_36691_36710 = state_36677__$1;
(statearr_36691_36710[(1)] = (10));

} else {
var statearr_36692_36711 = state_36677__$1;
(statearr_36692_36711[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36678 === (5))){
var _ = (function (){var statearr_36693 = state_36677;
(statearr_36693[(4)] = cljs.core.rest((state_36677[(4)])));

return statearr_36693;
})();
var state_36677__$1 = state_36677;
var ex36689 = (state_36677__$1[(2)]);
var statearr_36694_36712 = state_36677__$1;
(statearr_36694_36712[(5)] = ex36689);


if((ex36689 instanceof Error)){
var statearr_36695_36713 = state_36677__$1;
(statearr_36695_36713[(1)] = (4));

(statearr_36695_36713[(5)] = null);

} else {
throw ex36689;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36678 === (10))){
var inst_36661 = (state_36677[(7)]);
var inst_36669 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_36661);
var state_36677__$1 = state_36677;
var statearr_36696_36714 = state_36677__$1;
(statearr_36696_36714[(2)] = inst_36669);

(statearr_36696_36714[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36678 === (8))){
var inst_36661 = (state_36677[(7)]);
var state_36677__$1 = state_36677;
var statearr_36697_36715 = state_36677__$1;
(statearr_36697_36715[(2)] = inst_36661);

(statearr_36697_36715[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16291__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16291__auto____0 = (function (){
var statearr_36698 = [null,null,null,null,null,null,null,null,null];
(statearr_36698[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16291__auto__);

(statearr_36698[(1)] = (1));

return statearr_36698;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16291__auto____1 = (function (state_36677){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_36677);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e36699){var ex__16294__auto__ = e36699;
var statearr_36700_36716 = state_36677;
(statearr_36700_36716[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_36677[(4)]))){
var statearr_36701_36717 = state_36677;
(statearr_36701_36717[(1)] = cljs.core.first((state_36677[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__36718 = state_36677;
state_36677 = G__36718;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16291__auto__ = function(state_36677){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16291__auto____1.call(this,state_36677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16291__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16291__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_36702 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_36702[(6)] = c__16328__auto__);

return statearr_36702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_36795){
var state_val_36796 = (state_36795[(1)]);
if((state_val_36796 === (7))){
var inst_36790 = (state_36795[(2)]);
var _ = (function (){var statearr_36797 = state_36795;
(statearr_36797[(4)] = cljs.core.rest((state_36795[(4)])));

return statearr_36797;
})();
var state_36795__$1 = state_36795;
var statearr_36798_36831 = state_36795__$1;
(statearr_36798_36831[(2)] = inst_36790);

(statearr_36798_36831[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (1))){
var state_36795__$1 = state_36795;
var statearr_36799_36832 = state_36795__$1;
(statearr_36799_36832[(2)] = null);

(statearr_36799_36832[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (4))){
var inst_36721 = (state_36795[(2)]);
var state_36795__$1 = state_36795;
var statearr_36800_36833 = state_36795__$1;
(statearr_36800_36833[(2)] = inst_36721);

(statearr_36800_36833[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (15))){
var inst_36745 = (state_36795[(7)]);
var inst_36758 = (state_36795[(8)]);
var inst_36751 = (state_36795[(9)]);
var inst_36771 = (state_36795[(10)]);
var inst_36773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36774 = inst_36751.s;
var inst_36775 = [inst_36774,inst_36758,cljs.core.cst$kw$old];
var inst_36776 = (new cljs.core.PersistentVector(null,3,(5),inst_36773,inst_36775,null));
var inst_36777 = cljs.core.assoc_in(inst_36745,inst_36776,inst_36771);
var state_36795__$1 = state_36795;
var statearr_36801_36834 = state_36795__$1;
(statearr_36801_36834[(2)] = inst_36777);

(statearr_36801_36834[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (13))){
var inst_36760 = (state_36795[(11)]);
var inst_36771 = (state_36795[(2)]);
var state_36795__$1 = (function (){var statearr_36802 = state_36795;
(statearr_36802[(10)] = inst_36771);

return statearr_36802;
})();
if(cljs.core.truth_(inst_36760)){
var statearr_36803_36835 = state_36795__$1;
(statearr_36803_36835[(1)] = (15));

} else {
var statearr_36804_36836 = state_36795__$1;
(statearr_36804_36836[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (6))){
var inst_36751 = (state_36795[(9)]);
var inst_36744 = (state_36795[(12)]);
var inst_36750 = cljs.core.seq(inst_36744);
var inst_36751__$1 = cljs.core.first(inst_36750);
var inst_36752 = cljs.core.next(inst_36750);
var inst_36753 = cljs.core.not(inst_36751__$1);
var state_36795__$1 = (function (){var statearr_36805 = state_36795;
(statearr_36805[(9)] = inst_36751__$1);

(statearr_36805[(13)] = inst_36752);

return statearr_36805;
})();
if(inst_36753){
var statearr_36806_36837 = state_36795__$1;
(statearr_36806_36837[(1)] = (8));

} else {
var statearr_36807_36838 = state_36795__$1;
(statearr_36807_36838[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (17))){
var inst_36752 = (state_36795[(13)]);
var inst_36785 = (state_36795[(2)]);
var inst_36744 = inst_36752;
var inst_36745 = inst_36785;
var state_36795__$1 = (function (){var statearr_36808 = state_36795;
(statearr_36808[(7)] = inst_36745);

(statearr_36808[(12)] = inst_36744);

return statearr_36808;
})();
var statearr_36809_36839 = state_36795__$1;
(statearr_36809_36839[(2)] = null);

(statearr_36809_36839[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (3))){
var inst_36793 = (state_36795[(2)]);
var state_36795__$1 = state_36795;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36795__$1,inst_36793);
} else {
if((state_val_36796 === (12))){
var inst_36751 = (state_36795[(9)]);
var inst_36769 = inst_36751.o;
var state_36795__$1 = state_36795;
var statearr_36810_36840 = state_36795__$1;
(statearr_36810_36840[(2)] = inst_36769);

(statearr_36810_36840[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (2))){
var _ = (function (){var statearr_36811 = state_36795;
(statearr_36811[(4)] = cljs.core.cons((5),(state_36795[(4)])));

return statearr_36811;
})();
var inst_36727 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_36728 = cljs.core.PersistentHashSet.EMPTY;
var inst_36729 = cljs.core.vals(tempids);
var inst_36730 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36728,inst_36729);
var inst_36731 = (function (){var pred_flakes = inst_36727;
var is_new_QMARK_ = inst_36730;
return (function (p1__36719_SHARP_,p2__36720_SHARP_){
return cljs.core.assoc_in(p1__36719_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__36720_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__36812 = p2__36720_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__36812) : is_new_QMARK_.call(null,G__36812));
})()));
});
})();
var inst_36732 = cljs.core.PersistentHashMap.EMPTY;
var inst_36733 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36731,inst_36732,inst_36727);
var inst_36741 = cljs.core.seq(inst_36727);
var inst_36742 = cljs.core.first(inst_36741);
var inst_36743 = cljs.core.next(inst_36741);
var inst_36744 = inst_36727;
var inst_36745 = inst_36733;
var state_36795__$1 = (function (){var statearr_36813 = state_36795;
(statearr_36813[(7)] = inst_36745);

(statearr_36813[(12)] = inst_36744);

(statearr_36813[(14)] = inst_36743);

(statearr_36813[(15)] = inst_36742);

return statearr_36813;
})();
var statearr_36814_36841 = state_36795__$1;
(statearr_36814_36841[(2)] = null);

(statearr_36814_36841[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (11))){
var inst_36751 = (state_36795[(9)]);
var inst_36763 = inst_36751.o;
var inst_36764 = fluree.db.query.schema.convert_type_to_kw(inst_36763,db);
var state_36795__$1 = state_36795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36795__$1,(14),inst_36764);
} else {
if((state_val_36796 === (9))){
var inst_36758 = (state_36795[(8)]);
var inst_36751 = (state_36795[(9)]);
var inst_36756 = inst_36751.p;
var inst_36757 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_36756);
var inst_36758__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_36757);
var inst_36759 = inst_36751.op;
var inst_36760 = inst_36759 === false;
var inst_36761 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_36758__$1);
var state_36795__$1 = (function (){var statearr_36816 = state_36795;
(statearr_36816[(8)] = inst_36758__$1);

(statearr_36816[(11)] = inst_36760);

return statearr_36816;
})();
if(inst_36761){
var statearr_36817_36842 = state_36795__$1;
(statearr_36817_36842[(1)] = (11));

} else {
var statearr_36818_36843 = state_36795__$1;
(statearr_36818_36843[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (5))){
var _ = (function (){var statearr_36819 = state_36795;
(statearr_36819[(4)] = cljs.core.rest((state_36795[(4)])));

return statearr_36819;
})();
var state_36795__$1 = state_36795;
var ex36815 = (state_36795__$1[(2)]);
var statearr_36820_36844 = state_36795__$1;
(statearr_36820_36844[(5)] = ex36815);


if((ex36815 instanceof Error)){
var statearr_36821_36845 = state_36795__$1;
(statearr_36821_36845[(1)] = (4));

(statearr_36821_36845[(5)] = null);

} else {
throw ex36815;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (14))){
var inst_36766 = (state_36795[(2)]);
var inst_36767 = fluree.db.util.async.throw_err(inst_36766);
var state_36795__$1 = state_36795;
var statearr_36822_36846 = state_36795__$1;
(statearr_36822_36846[(2)] = inst_36767);

(statearr_36822_36846[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (16))){
var inst_36745 = (state_36795[(7)]);
var inst_36758 = (state_36795[(8)]);
var inst_36751 = (state_36795[(9)]);
var inst_36771 = (state_36795[(10)]);
var inst_36779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36780 = inst_36751.s;
var inst_36781 = [inst_36780,inst_36758,cljs.core.cst$kw$new];
var inst_36782 = (new cljs.core.PersistentVector(null,3,(5),inst_36779,inst_36781,null));
var inst_36783 = cljs.core.assoc_in(inst_36745,inst_36782,inst_36771);
var state_36795__$1 = state_36795;
var statearr_36823_36847 = state_36795__$1;
(statearr_36823_36847[(2)] = inst_36783);

(statearr_36823_36847[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (10))){
var inst_36788 = (state_36795[(2)]);
var state_36795__$1 = state_36795;
var statearr_36824_36848 = state_36795__$1;
(statearr_36824_36848[(2)] = inst_36788);

(statearr_36824_36848[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (8))){
var inst_36745 = (state_36795[(7)]);
var state_36795__$1 = state_36795;
var statearr_36825_36849 = state_36795__$1;
(statearr_36825_36849[(2)] = inst_36745);

(statearr_36825_36849[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__16291__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__16291__auto____0 = (function (){
var statearr_36826 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36826[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__16291__auto__);

(statearr_36826[(1)] = (1));

return statearr_36826;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__16291__auto____1 = (function (state_36795){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_36795);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e36827){var ex__16294__auto__ = e36827;
var statearr_36828_36850 = state_36795;
(statearr_36828_36850[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_36795[(4)]))){
var statearr_36829_36851 = state_36795;
(statearr_36829_36851[(1)] = cljs.core.first((state_36795[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__36852 = state_36795;
state_36795 = G__36852;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__16291__auto__ = function(state_36795){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16291__auto____1.call(this,state_36795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__16291__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__16291__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_36830 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_36830[(6)] = c__16328__auto__);

return statearr_36830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__36854 = arguments.length;
switch (G__36854) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__36857 = arguments.length;
switch (G__36857) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_37166){
var state_val_37167 = (state_37166[(1)]);
if((state_val_37167 === (65))){
var inst_37119 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37168_37340 = state_37166__$1;
(statearr_37168_37340[(2)] = inst_37119);

(statearr_37168_37340[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (70))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37041 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_37042 = (inst_37029.cljs$core$IFn$_invoke$arity$5 ? inst_37029.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_37041,null) : inst_37029.call(null,cljs.core.PersistentArrayMap,null,2,inst_37041,null));
var inst_37043 = (inst_37029.cljs$core$IFn$_invoke$arity$4 ? inst_37029.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_37042,null) : inst_37029.call(null,cljs.core.PersistentHashSet,null,inst_37042,null));
var inst_37044 = (inst_37043.cljs$core$IFn$_invoke$arity$1 ? inst_37043.cljs$core$IFn$_invoke$arity$1(inst_37028) : inst_37043.call(null,inst_37028));
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_37044)){
var statearr_37169_37341 = state_37166__$1;
(statearr_37169_37341[(1)] = (71));

} else {
var statearr_37170_37342 = state_37166__$1;
(statearr_37170_37342[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (62))){
var inst_37121 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37171_37343 = state_37166__$1;
(statearr_37171_37343[(2)] = inst_37121);

(statearr_37171_37343[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (74))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37051 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_37052 = (inst_37029.cljs$core$IFn$_invoke$arity$5 ? inst_37029.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_37051,null) : inst_37029.call(null,cljs.core.PersistentArrayMap,null,3,inst_37051,null));
var inst_37053 = (inst_37029.cljs$core$IFn$_invoke$arity$4 ? inst_37029.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_37052,null) : inst_37029.call(null,cljs.core.PersistentHashSet,null,inst_37052,null));
var inst_37054 = (inst_37053.cljs$core$IFn$_invoke$arity$1 ? inst_37053.cljs$core$IFn$_invoke$arity$1(inst_37028) : inst_37053.call(null,inst_37028));
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_37054)){
var statearr_37172_37344 = state_37166__$1;
(statearr_37172_37344[(1)] = (75));

} else {
var statearr_37173_37345 = state_37166__$1;
(statearr_37173_37345[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (110))){
var inst_37153 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37174_37346 = state_37166__$1;
(statearr_37174_37346[(2)] = inst_37153);

(statearr_37174_37346[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (7))){
var inst_37161 = (state_37166[(2)]);
var _ = (function (){var statearr_37175 = state_37166;
(statearr_37175[(4)] = cljs.core.rest((state_37166[(4)])));

return statearr_37175;
})();
var state_37166__$1 = state_37166;
var statearr_37176_37347 = state_37166__$1;
(statearr_37176_37347[(2)] = inst_37161);

(statearr_37176_37347[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (59))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37027 = (state_37166[(2)]);
var inst_37028__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37027,cljs.core.cst$kw$old);
var inst_37029__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37027,cljs.core.cst$kw$new);
var inst_37030 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37029__$1,inst_37028__$1);
var state_37166__$1 = (function (){var statearr_37177 = state_37166;
(statearr_37177[(7)] = inst_37028__$1);

(statearr_37177[(8)] = inst_37029__$1);

return statearr_37177;
})();
if(inst_37030){
var statearr_37178_37348 = state_37166__$1;
(statearr_37178_37348[(1)] = (60));

} else {
var statearr_37179_37349 = state_37166__$1;
(statearr_37179_37349[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (86))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37081 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_37082 = (inst_37029.cljs$core$IFn$_invoke$arity$5 ? inst_37029.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_37081,null) : inst_37029.call(null,cljs.core.PersistentArrayMap,null,5,inst_37081,null));
var inst_37083 = (inst_37029.cljs$core$IFn$_invoke$arity$4 ? inst_37029.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_37082,null) : inst_37029.call(null,cljs.core.PersistentHashSet,null,inst_37082,null));
var inst_37084 = (inst_37083.cljs$core$IFn$_invoke$arity$1 ? inst_37083.cljs$core$IFn$_invoke$arity$1(inst_37028) : inst_37083.call(null,inst_37028));
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_37084)){
var statearr_37180_37350 = state_37166__$1;
(statearr_37180_37350[(1)] = (87));

} else {
var statearr_37181_37351 = state_37166__$1;
(statearr_37181_37351[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (20))){
var inst_36897 = (state_37166[(9)]);
var inst_36922 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_36923 = inst_36922 === true;
var inst_36924 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_36925 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36924);
var inst_36926 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_36925);
var inst_36927 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_36928 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36927);
var inst_36929 = inst_36928 === true;
var inst_36930 = ((inst_36923) && (inst_36926) && (inst_36929));
var state_37166__$1 = state_37166;
var statearr_37182_37352 = state_37166__$1;
(statearr_37182_37352[(2)] = inst_36930);

(statearr_37182_37352[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (72))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37047 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_37028,inst_37029,throw_QMARK_);
var state_37166__$1 = state_37166;
var statearr_37183_37353 = state_37166__$1;
(statearr_37183_37353[(2)] = inst_37047);

(statearr_37183_37353[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (58))){
var inst_37006 = (state_37166[(10)]);
var state_37166__$1 = state_37166;
var statearr_37184_37354 = state_37166__$1;
(statearr_37184_37354[(2)] = inst_37006);

(statearr_37184_37354[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (60))){
var inst_36996 = (state_37166[(11)]);
var state_37166__$1 = state_37166;
var statearr_37185_37355 = state_37166__$1;
(statearr_37185_37355[(2)] = inst_36996);

(statearr_37185_37355[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (27))){
var inst_36917 = (state_37166[(12)]);
var state_37166__$1 = state_37166;
var statearr_37186_37356 = state_37166__$1;
(statearr_37186_37356[(2)] = inst_36917);

(statearr_37186_37356[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (1))){
var state_37166__$1 = state_37166;
var statearr_37187_37357 = state_37166__$1;
(statearr_37187_37357[(2)] = null);

(statearr_37187_37357[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (69))){
var inst_37114 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37188_37358 = state_37166__$1;
(statearr_37188_37358[(2)] = inst_37114);

(statearr_37188_37358[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (101))){
var inst_37143 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_37143)){
var statearr_37189_37359 = state_37166__$1;
(statearr_37189_37359[(1)] = (105));

} else {
var statearr_37190_37360 = state_37166__$1;
(statearr_37190_37360[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (24))){
var inst_36917 = (state_37166[(12)]);
var state_37166__$1 = state_37166;
var statearr_37191_37361 = state_37166__$1;
(statearr_37191_37361[(2)] = inst_36917);

(statearr_37191_37361[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (102))){
var inst_36897 = (state_37166[(9)]);
var inst_37130 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_37131 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_37130);
var inst_37132 = inst_37131 === true;
var inst_37133 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_37134 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_37133);
var inst_37135 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_37134);
var inst_37136 = (!(inst_37135));
var inst_37137 = ((inst_37132) && (inst_37136));
var state_37166__$1 = state_37166;
var statearr_37192_37362 = state_37166__$1;
(statearr_37192_37362[(2)] = inst_37137);

(statearr_37192_37362[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (55))){
var state_37166__$1 = state_37166;
var statearr_37193_37363 = state_37166__$1;
(statearr_37193_37363[(2)] = false);

(statearr_37193_37363[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (85))){
var inst_37079 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37194_37364 = state_37166__$1;
(statearr_37194_37364[(2)] = inst_37079);

(statearr_37194_37364[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (39))){
var state_37166__$1 = state_37166;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_37195_37365 = state_37166__$1;
(statearr_37195_37365[(1)] = (42));

} else {
var statearr_37196_37366 = state_37166__$1;
(statearr_37196_37366[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (88))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37087 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_37028,inst_37029,throw_QMARK_);
var state_37166__$1 = state_37166;
var statearr_37197_37367 = state_37166__$1;
(statearr_37197_37367[(2)] = inst_37087);

(statearr_37197_37367[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (46))){
var inst_36997 = (state_37166[(13)]);
var state_37166__$1 = state_37166;
var statearr_37198_37368 = state_37166__$1;
(statearr_37198_37368[(2)] = inst_36997);

(statearr_37198_37368[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (4))){
var inst_36858 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37199_37369 = state_37166__$1;
(statearr_37199_37369[(2)] = inst_36858);

(statearr_37199_37369[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (77))){
var inst_37059 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37200_37370 = state_37166__$1;
(statearr_37200_37370[(2)] = inst_37059);

(statearr_37200_37370[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (106))){
var inst_37124 = (state_37166[(14)]);
var state_37166__$1 = state_37166;
var statearr_37201_37371 = state_37166__$1;
(statearr_37201_37371[(2)] = inst_37124);

(statearr_37201_37371[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (95))){
var inst_36996 = (state_37166[(11)]);
var state_37166__$1 = state_37166;
var statearr_37202_37372 = state_37166__$1;
(statearr_37202_37372[(2)] = inst_36996);

(statearr_37202_37372[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (54))){
var state_37166__$1 = state_37166;
var statearr_37203_37373 = state_37166__$1;
(statearr_37203_37373[(2)] = true);

(statearr_37203_37373[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (92))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37097 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_37028,inst_37029,throw_QMARK_);
var state_37166__$1 = state_37166;
var statearr_37204_37374 = state_37166__$1;
(statearr_37204_37374[(2)] = inst_37097);

(statearr_37204_37374[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (104))){
var inst_37140 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37205_37375 = state_37166__$1;
(statearr_37205_37375[(2)] = inst_37140);

(statearr_37205_37375[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (15))){
var inst_36885 = (state_37166[(15)]);
var state_37166__$1 = state_37166;
var statearr_37206_37376 = state_37166__$1;
(statearr_37206_37376[(2)] = inst_36885);

(statearr_37206_37376[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (48))){
var inst_37006 = (state_37166[(10)]);
var inst_36897 = (state_37166[(9)]);
var inst_37006__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_37008 = (inst_37006__$1 == null);
var inst_37009 = cljs.core.not(inst_37008);
var state_37166__$1 = (function (){var statearr_37207 = state_37166;
(statearr_37207[(10)] = inst_37006__$1);

return statearr_37207;
})();
if(inst_37009){
var statearr_37208_37377 = state_37166__$1;
(statearr_37208_37377[(1)] = (51));

} else {
var statearr_37209_37378 = state_37166__$1;
(statearr_37209_37378[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (50))){
var inst_36897 = (state_37166[(9)]);
var inst_37124 = (state_37166[(2)]);
var inst_37125 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_37126 = inst_37125 === true;
var state_37166__$1 = (function (){var statearr_37210 = state_37166;
(statearr_37210[(14)] = inst_37124);

return statearr_37210;
})();
if(cljs.core.truth_(inst_37126)){
var statearr_37211_37379 = state_37166__$1;
(statearr_37211_37379[(1)] = (99));

} else {
var statearr_37212_37380 = state_37166__$1;
(statearr_37212_37380[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (75))){
var inst_36996 = (state_37166[(11)]);
var state_37166__$1 = state_37166;
var statearr_37213_37381 = state_37166__$1;
(statearr_37213_37381[(2)] = inst_36996);

(statearr_37213_37381[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (99))){
var inst_36897 = (state_37166[(9)]);
var inst_37128 = (state_37166[(16)]);
var inst_37128__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_36897);
var state_37166__$1 = (function (){var statearr_37214 = state_37166;
(statearr_37214[(16)] = inst_37128__$1);

return statearr_37214;
})();
if(cljs.core.truth_(inst_37128__$1)){
var statearr_37215_37382 = state_37166__$1;
(statearr_37215_37382[(1)] = (102));

} else {
var statearr_37216_37383 = state_37166__$1;
(statearr_37216_37383[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (21))){
var inst_36920 = (state_37166[(17)]);
var state_37166__$1 = state_37166;
var statearr_37217_37384 = state_37166__$1;
(statearr_37217_37384[(2)] = inst_36920);

(statearr_37217_37384[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (31))){
var inst_36960 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_36960)){
var statearr_37218_37385 = state_37166__$1;
(statearr_37218_37385[(1)] = (32));

} else {
var statearr_37219_37386 = state_37166__$1;
(statearr_37219_37386[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (32))){
var inst_36949 = (state_37166[(18)]);
var inst_36962 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_36949,"a component","a non-component",throw_QMARK_);
var state_37166__$1 = state_37166;
var statearr_37220_37387 = state_37166__$1;
(statearr_37220_37387[(2)] = inst_36962);

(statearr_37220_37387[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (40))){
var inst_36965 = (state_37166[(19)]);
var state_37166__$1 = state_37166;
var statearr_37221_37388 = state_37166__$1;
(statearr_37221_37388[(2)] = inst_36965);

(statearr_37221_37388[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (91))){
var inst_36996 = (state_37166[(11)]);
var state_37166__$1 = state_37166;
var statearr_37222_37389 = state_37166__$1;
(statearr_37222_37389[(2)] = inst_36996);

(statearr_37222_37389[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (108))){
var inst_37146 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37147 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_37148 = cljs.core.PersistentHashMap.fromArrays(inst_37146,inst_37147);
var inst_37149 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_37148);
var inst_37150 = (function(){throw inst_37149})();
var state_37166__$1 = state_37166;
var statearr_37223_37390 = state_37166__$1;
(statearr_37223_37390[(2)] = inst_37150);

(statearr_37223_37390[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (56))){
var inst_37019 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37224_37391 = state_37166__$1;
(statearr_37224_37391[(2)] = inst_37019);

(statearr_37224_37391[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (33))){
var inst_36949 = (state_37166[(18)]);
var state_37166__$1 = state_37166;
var statearr_37225_37392 = state_37166__$1;
(statearr_37225_37392[(2)] = inst_36949);

(statearr_37225_37392[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (13))){
var inst_36912 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_36912)){
var statearr_37226_37393 = state_37166__$1;
(statearr_37226_37393[(1)] = (14));

} else {
var statearr_37227_37394 = state_37166__$1;
(statearr_37227_37394[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (22))){
var inst_36933 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37228_37395 = state_37166__$1;
(statearr_37228_37395[(2)] = inst_36933);

(statearr_37228_37395[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (90))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37091 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_37092 = (inst_37029.cljs$core$IFn$_invoke$arity$5 ? inst_37029.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_37091,null) : inst_37029.call(null,cljs.core.PersistentArrayMap,null,5,inst_37091,null));
var inst_37093 = (inst_37029.cljs$core$IFn$_invoke$arity$4 ? inst_37029.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_37092,null) : inst_37029.call(null,cljs.core.PersistentHashSet,null,inst_37092,null));
var inst_37094 = (inst_37093.cljs$core$IFn$_invoke$arity$1 ? inst_37093.cljs$core$IFn$_invoke$arity$1(inst_37028) : inst_37093.call(null,inst_37028));
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_37094)){
var statearr_37229_37396 = state_37166__$1;
(statearr_37229_37396[(1)] = (91));

} else {
var statearr_37230_37397 = state_37166__$1;
(statearr_37230_37397[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (109))){
var inst_37124 = (state_37166[(14)]);
var state_37166__$1 = state_37166;
var statearr_37231_37398 = state_37166__$1;
(statearr_37231_37398[(2)] = inst_37124);

(statearr_37231_37398[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (36))){
var inst_36966 = (state_37166[(20)]);
var state_37166__$1 = state_37166;
var statearr_37232_37399 = state_37166__$1;
(statearr_37232_37399[(2)] = inst_36966);

(statearr_37232_37399[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (41))){
var inst_36897 = (state_37166[(9)]);
var inst_36997 = (state_37166[(13)]);
var inst_36996 = (state_37166[(2)]);
var inst_36997__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36897);
var state_37166__$1 = (function (){var statearr_37233 = state_37166;
(statearr_37233[(13)] = inst_36997__$1);

(statearr_37233[(11)] = inst_36996);

return statearr_37233;
})();
if(cljs.core.truth_(inst_36997__$1)){
var statearr_37234_37400 = state_37166__$1;
(statearr_37234_37400[(1)] = (45));

} else {
var statearr_37235_37401 = state_37166__$1;
(statearr_37235_37401[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (89))){
var inst_37089 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37236_37402 = state_37166__$1;
(statearr_37236_37402[(2)] = inst_37089);

(statearr_37236_37402[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (100))){
var state_37166__$1 = state_37166;
var statearr_37237_37403 = state_37166__$1;
(statearr_37237_37403[(2)] = false);

(statearr_37237_37403[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (43))){
var inst_36965 = (state_37166[(19)]);
var state_37166__$1 = state_37166;
var statearr_37238_37404 = state_37166__$1;
(statearr_37238_37404[(2)] = inst_36965);

(statearr_37238_37404[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (61))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37033 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_37034 = (inst_37029.cljs$core$IFn$_invoke$arity$5 ? inst_37029.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_37033,null) : inst_37029.call(null,cljs.core.PersistentArrayMap,null,3,inst_37033,null));
var inst_37035 = (inst_37029.cljs$core$IFn$_invoke$arity$4 ? inst_37029.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_37034,null) : inst_37029.call(null,cljs.core.PersistentHashSet,null,inst_37034,null));
var inst_37036 = (inst_37035.cljs$core$IFn$_invoke$arity$1 ? inst_37035.cljs$core$IFn$_invoke$arity$1(inst_37028) : inst_37035.call(null,inst_37028));
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_37036)){
var statearr_37239_37405 = state_37166__$1;
(statearr_37239_37405[(1)] = (63));

} else {
var statearr_37240_37406 = state_37166__$1;
(statearr_37240_37406[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (29))){
var inst_36897 = (state_37166[(9)]);
var inst_36952 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_36953 = cljs.core.not(inst_36952);
var inst_36954 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_36955 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36954);
var inst_36956 = inst_36955 === true;
var inst_36957 = ((inst_36953) && (inst_36956));
var state_37166__$1 = state_37166;
var statearr_37241_37407 = state_37166__$1;
(statearr_37241_37407[(2)] = inst_36957);

(statearr_37241_37407[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (44))){
var inst_36993 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37242_37408 = state_37166__$1;
(statearr_37242_37408[(2)] = inst_36993);

(statearr_37242_37408[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (93))){
var inst_37099 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37243_37409 = state_37166__$1;
(statearr_37243_37409[(2)] = inst_37099);

(statearr_37243_37409[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (6))){
var inst_36884 = (state_37166[(21)]);
var inst_36896 = (state_37166[(22)]);
var inst_36893 = cljs.core.seq(inst_36884);
var inst_36894 = cljs.core.first(inst_36893);
var inst_36895 = cljs.core.next(inst_36893);
var inst_36896__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36894,(0),null);
var inst_36897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36894,(1),null);
var inst_36898 = cljs.core.not(inst_36896__$1);
var state_37166__$1 = (function (){var statearr_37244 = state_37166;
(statearr_37244[(9)] = inst_36897);

(statearr_37244[(23)] = inst_36895);

(statearr_37244[(22)] = inst_36896__$1);

return statearr_37244;
})();
if(inst_36898){
var statearr_37245_37410 = state_37166__$1;
(statearr_37245_37410[(1)] = (8));

} else {
var statearr_37246_37411 = state_37166__$1;
(statearr_37246_37411[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (28))){
var inst_36946 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37247_37412 = state_37166__$1;
(statearr_37247_37412[(2)] = inst_36946);

(statearr_37247_37412[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (64))){
var state_37166__$1 = state_37166;
var statearr_37248_37413 = state_37166__$1;
(statearr_37248_37413[(1)] = (66));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (103))){
var inst_37128 = (state_37166[(16)]);
var state_37166__$1 = state_37166;
var statearr_37250_37414 = state_37166__$1;
(statearr_37250_37414[(2)] = inst_37128);

(statearr_37250_37414[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (51))){
var inst_37006 = (state_37166[(10)]);
var inst_37011 = inst_37006.cljs$lang$protocol_mask$partition0$;
var inst_37012 = (inst_37011 & (64));
var inst_37013 = inst_37006.cljs$core$ISeq$;
var inst_37014 = (cljs.core.PROTOCOL_SENTINEL === inst_37013);
var inst_37015 = ((inst_37012) || (inst_37014));
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_37015)){
var statearr_37251_37415 = state_37166__$1;
(statearr_37251_37415[(1)] = (54));

} else {
var statearr_37252_37416 = state_37166__$1;
(statearr_37252_37416[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (25))){
var inst_36897 = (state_37166[(9)]);
var inst_36950 = (state_37166[(24)]);
var inst_36949 = (state_37166[(2)]);
var inst_36950__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_36897);
var state_37166__$1 = (function (){var statearr_37253 = state_37166;
(statearr_37253[(24)] = inst_36950__$1);

(statearr_37253[(18)] = inst_36949);

return statearr_37253;
})();
if(cljs.core.truth_(inst_36950__$1)){
var statearr_37254_37417 = state_37166__$1;
(statearr_37254_37417[(1)] = (29));

} else {
var statearr_37255_37418 = state_37166__$1;
(statearr_37255_37418[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (34))){
var inst_36897 = (state_37166[(9)]);
var inst_36966 = (state_37166[(20)]);
var inst_36965 = (state_37166[(2)]);
var inst_36966__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_36897);
var state_37166__$1 = (function (){var statearr_37256 = state_37166;
(statearr_37256[(20)] = inst_36966__$1);

(statearr_37256[(19)] = inst_36965);

return statearr_37256;
})();
if(cljs.core.truth_(inst_36966__$1)){
var statearr_37257_37419 = state_37166__$1;
(statearr_37257_37419[(1)] = (35));

} else {
var statearr_37258_37420 = state_37166__$1;
(statearr_37258_37420[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (17))){
var inst_36897 = (state_37166[(9)]);
var inst_36920 = (state_37166[(17)]);
var inst_36920__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36897);
var state_37166__$1 = (function (){var statearr_37259 = state_37166;
(statearr_37259[(17)] = inst_36920__$1);

return statearr_37259;
})();
if(cljs.core.truth_(inst_36920__$1)){
var statearr_37260_37421 = state_37166__$1;
(statearr_37260_37421[(1)] = (20));

} else {
var statearr_37261_37422 = state_37166__$1;
(statearr_37261_37422[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (3))){
var inst_37164 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37166__$1,inst_37164);
} else {
if((state_val_37167 === (12))){
var inst_36901 = (state_37166[(25)]);
var state_37166__$1 = state_37166;
var statearr_37262_37423 = state_37166__$1;
(statearr_37262_37423[(2)] = inst_36901);

(statearr_37262_37423[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (2))){
var _ = (function (){var statearr_37263 = state_37166;
(statearr_37263[(4)] = cljs.core.cons((5),(state_37166[(4)])));

return statearr_37263;
})();
var inst_36877 = pred_changes;
var inst_36878 = cljs.core.seq(inst_36877);
var inst_36879 = cljs.core.first(inst_36878);
var inst_36880 = cljs.core.next(inst_36878);
var inst_36881 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36879,(0),null);
var inst_36882 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36879,(1),null);
var inst_36883 = db;
var inst_36884 = inst_36877;
var inst_36885 = inst_36883;
var state_37166__$1 = (function (){var statearr_37264 = state_37166;
(statearr_37264[(21)] = inst_36884);

(statearr_37264[(15)] = inst_36885);

(statearr_37264[(26)] = inst_36880);

(statearr_37264[(27)] = inst_36882);

(statearr_37264[(28)] = inst_36881);

return statearr_37264;
})();
var statearr_37265_37424 = state_37166__$1;
(statearr_37265_37424[(2)] = null);

(statearr_37265_37424[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (66))){
var inst_37029 = (state_37166[(8)]);
var state_37166__$1 = state_37166;
var G__37266_37425 = inst_37029;
var G__37266_37426__$1 = (((G__37266_37425 instanceof cljs.core.Keyword))?G__37266_37425.fqn:null);
switch (G__37266_37426__$1) {
case "long":
var statearr_37267_37428 = state_37166__$1;
(statearr_37267_37428[(1)] = (70));


break;
case "bigint":
var statearr_37268_37429 = state_37166__$1;
(statearr_37268_37429[(1)] = (74));


break;
case "double":
var statearr_37269_37430 = state_37166__$1;
(statearr_37269_37430[(1)] = (78));


break;
case "float":
var statearr_37270_37431 = state_37166__$1;
(statearr_37270_37431[(1)] = (82));


break;
case "bigdec":
var statearr_37271_37432 = state_37166__$1;
(statearr_37271_37432[(1)] = (86));


break;
case "string":
var statearr_37272_37433 = state_37166__$1;
(statearr_37272_37433[(1)] = (90));


break;
case "instant":
var statearr_37273_37434 = state_37166__$1;
(statearr_37273_37434[(1)] = (94));


break;
default:
var statearr_37274_37435 = state_37166__$1;
(statearr_37274_37435[(1)] = (98));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (107))){
var inst_36895 = (state_37166[(23)]);
var inst_37156 = (state_37166[(2)]);
var inst_36884 = inst_36895;
var inst_36885 = inst_37156;
var state_37166__$1 = (function (){var statearr_37275 = state_37166;
(statearr_37275[(21)] = inst_36884);

(statearr_37275[(15)] = inst_36885);

return statearr_37275;
})();
var statearr_37276_37436 = state_37166__$1;
(statearr_37276_37436[(2)] = null);

(statearr_37276_37436[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (23))){
var state_37166__$1 = state_37166;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_37277_37437 = state_37166__$1;
(statearr_37277_37437[(1)] = (26));

} else {
var statearr_37278_37438 = state_37166__$1;
(statearr_37278_37438[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (47))){
var inst_37003 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_37003)){
var statearr_37279_37439 = state_37166__$1;
(statearr_37279_37439[(1)] = (48));

} else {
var statearr_37280_37440 = state_37166__$1;
(statearr_37280_37440[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (35))){
var inst_36897 = (state_37166[(9)]);
var inst_36885 = (state_37166[(15)]);
var inst_36896 = (state_37166[(22)]);
var inst_36968 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_36969 = cljs.core.not(inst_36968);
var inst_36970 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_36971 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36970);
var inst_36972 = inst_36971 === true;
var inst_36973 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_36885,inst_36896);
var state_37166__$1 = (function (){var statearr_37281 = state_37166;
(statearr_37281[(29)] = inst_36972);

(statearr_37281[(30)] = inst_36969);

return statearr_37281;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37166__$1,(38),inst_36973);
} else {
if((state_val_37167 === (82))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37071 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_37072 = (inst_37029.cljs$core$IFn$_invoke$arity$5 ? inst_37029.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_37071,null) : inst_37029.call(null,cljs.core.PersistentArrayMap,null,3,inst_37071,null));
var inst_37073 = (inst_37029.cljs$core$IFn$_invoke$arity$4 ? inst_37029.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_37072,null) : inst_37029.call(null,cljs.core.PersistentHashSet,null,inst_37072,null));
var inst_37074 = (inst_37073.cljs$core$IFn$_invoke$arity$1 ? inst_37073.cljs$core$IFn$_invoke$arity$1(inst_37028) : inst_37073.call(null,inst_37028));
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_37074)){
var statearr_37282_37441 = state_37166__$1;
(statearr_37282_37441[(1)] = (83));

} else {
var statearr_37283_37442 = state_37166__$1;
(statearr_37283_37442[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (76))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37057 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_37028,inst_37029,throw_QMARK_);
var state_37166__$1 = state_37166;
var statearr_37284_37443 = state_37166__$1;
(statearr_37284_37443[(2)] = inst_37057);

(statearr_37284_37443[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (97))){
var inst_37109 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37285_37444 = state_37166__$1;
(statearr_37285_37444[(2)] = inst_37109);

(statearr_37285_37444[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (19))){
var inst_36936 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_36936)){
var statearr_37286_37445 = state_37166__$1;
(statearr_37286_37445[(1)] = (23));

} else {
var statearr_37287_37446 = state_37166__$1;
(statearr_37287_37446[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (57))){
var inst_37006 = (state_37166[(10)]);
var inst_37024 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37006);
var state_37166__$1 = state_37166;
var statearr_37288_37447 = state_37166__$1;
(statearr_37288_37447[(2)] = inst_37024);

(statearr_37288_37447[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (68))){
var inst_37117 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37289_37448 = state_37166__$1;
(statearr_37289_37448[(2)] = inst_37117);

(statearr_37289_37448[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (11))){
var inst_36897 = (state_37166[(9)]);
var inst_36903 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_36904 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36903);
var inst_36905 = inst_36904 === false;
var inst_36906 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_36907 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_36906);
var inst_36908 = inst_36907 === true;
var inst_36909 = ((inst_36905) && (inst_36908));
var state_37166__$1 = state_37166;
var statearr_37291_37449 = state_37166__$1;
(statearr_37291_37449[(2)] = inst_36909);

(statearr_37291_37449[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (9))){
var inst_36897 = (state_37166[(9)]);
var inst_36901 = (state_37166[(25)]);
var inst_36901__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_36897);
var state_37166__$1 = (function (){var statearr_37292 = state_37166;
(statearr_37292[(25)] = inst_36901__$1);

return statearr_37292;
})();
if(cljs.core.truth_(inst_36901__$1)){
var statearr_37293_37450 = state_37166__$1;
(statearr_37293_37450[(1)] = (11));

} else {
var statearr_37294_37451 = state_37166__$1;
(statearr_37294_37451[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (5))){
var _ = (function (){var statearr_37295 = state_37166;
(statearr_37295[(4)] = cljs.core.rest((state_37166[(4)])));

return statearr_37295;
})();
var state_37166__$1 = state_37166;
var ex37290 = (state_37166__$1[(2)]);
var statearr_37296_37452 = state_37166__$1;
(statearr_37296_37452[(5)] = ex37290);


if((ex37290 instanceof Error)){
var statearr_37297_37453 = state_37166__$1;
(statearr_37297_37453[(1)] = (4));

(statearr_37297_37453[(5)] = null);

} else {
throw ex37290;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (83))){
var inst_36996 = (state_37166[(11)]);
var state_37166__$1 = state_37166;
var statearr_37298_37454 = state_37166__$1;
(statearr_37298_37454[(2)] = inst_36996);

(statearr_37298_37454[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (14))){
var inst_36885 = (state_37166[(15)]);
var inst_36914 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_36885,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_37166__$1 = state_37166;
var statearr_37299_37455 = state_37166__$1;
(statearr_37299_37455[(2)] = inst_36914);

(statearr_37299_37455[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (45))){
var inst_36897 = (state_37166[(9)]);
var inst_36999 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36897);
var inst_37000 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_36999);
var state_37166__$1 = state_37166;
var statearr_37300_37456 = state_37166__$1;
(statearr_37300_37456[(2)] = inst_37000);

(statearr_37300_37456[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (53))){
var inst_37022 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_37022)){
var statearr_37301_37457 = state_37166__$1;
(statearr_37301_37457[(1)] = (57));

} else {
var statearr_37302_37458 = state_37166__$1;
(statearr_37302_37458[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (78))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37061 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_37062 = (inst_37029.cljs$core$IFn$_invoke$arity$5 ? inst_37029.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_37061,null) : inst_37029.call(null,cljs.core.PersistentArrayMap,null,3,inst_37061,null));
var inst_37063 = (inst_37029.cljs$core$IFn$_invoke$arity$4 ? inst_37029.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_37062,null) : inst_37029.call(null,cljs.core.PersistentHashSet,null,inst_37062,null));
var inst_37064 = (inst_37063.cljs$core$IFn$_invoke$arity$1 ? inst_37063.cljs$core$IFn$_invoke$arity$1(inst_37028) : inst_37063.call(null,inst_37028));
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_37064)){
var statearr_37303_37459 = state_37166__$1;
(statearr_37303_37459[(1)] = (79));

} else {
var statearr_37304_37460 = state_37166__$1;
(statearr_37304_37460[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (26))){
var inst_36939 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36940 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_36941 = cljs.core.PersistentHashMap.fromArrays(inst_36939,inst_36940);
var inst_36942 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_36941);
var inst_36943 = (function(){throw inst_36942})();
var state_37166__$1 = state_37166;
var statearr_37305_37461 = state_37166__$1;
(statearr_37305_37461[(2)] = inst_36943);

(statearr_37305_37461[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (16))){
var inst_36897 = (state_37166[(9)]);
var inst_36918 = (state_37166[(31)]);
var inst_36917 = (state_37166[(2)]);
var inst_36918__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_36897);
var state_37166__$1 = (function (){var statearr_37306 = state_37166;
(statearr_37306[(12)] = inst_36917);

(statearr_37306[(31)] = inst_36918__$1);

return statearr_37306;
})();
if(cljs.core.truth_(inst_36918__$1)){
var statearr_37307_37462 = state_37166__$1;
(statearr_37307_37462[(1)] = (17));

} else {
var statearr_37308_37463 = state_37166__$1;
(statearr_37308_37463[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (81))){
var inst_37069 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37309_37464 = state_37166__$1;
(statearr_37309_37464[(2)] = inst_37069);

(statearr_37309_37464[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (79))){
var inst_36996 = (state_37166[(11)]);
var state_37166__$1 = state_37166;
var statearr_37310_37465 = state_37166__$1;
(statearr_37310_37465[(2)] = inst_36996);

(statearr_37310_37465[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (38))){
var inst_36972 = (state_37166[(29)]);
var inst_36969 = (state_37166[(30)]);
var inst_36975 = (state_37166[(2)]);
var inst_36976 = fluree.db.util.async.throw_err(inst_36975);
var inst_36977 = cljs.core.not(inst_36976);
var inst_36978 = ((inst_36969) && (inst_36972) && (inst_36977));
var state_37166__$1 = state_37166;
var statearr_37311_37466 = state_37166__$1;
(statearr_37311_37466[(2)] = inst_36978);

(statearr_37311_37466[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (98))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37111 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_37028,inst_37029,throw_QMARK_);
var state_37166__$1 = state_37166;
var statearr_37312_37467 = state_37166__$1;
(statearr_37312_37467[(2)] = inst_37111);

(statearr_37312_37467[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (87))){
var inst_36996 = (state_37166[(11)]);
var state_37166__$1 = state_37166;
var statearr_37313_37468 = state_37166__$1;
(statearr_37313_37468[(2)] = inst_36996);

(statearr_37313_37468[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (30))){
var inst_36950 = (state_37166[(24)]);
var state_37166__$1 = state_37166;
var statearr_37314_37469 = state_37166__$1;
(statearr_37314_37469[(2)] = inst_36950);

(statearr_37314_37469[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (73))){
var inst_37049 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37315_37470 = state_37166__$1;
(statearr_37315_37470[(2)] = inst_37049);

(statearr_37315_37470[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (96))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37107 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_37028,inst_37029,throw_QMARK_);
var state_37166__$1 = state_37166;
var statearr_37316_37471 = state_37166__$1;
(statearr_37316_37471[(2)] = inst_37107);

(statearr_37316_37471[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (10))){
var inst_37159 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
var statearr_37317_37472 = state_37166__$1;
(statearr_37317_37472[(2)] = inst_37159);

(statearr_37317_37472[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (18))){
var inst_36918 = (state_37166[(31)]);
var state_37166__$1 = state_37166;
var statearr_37318_37473 = state_37166__$1;
(statearr_37318_37473[(2)] = inst_36918);

(statearr_37318_37473[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (105))){
var state_37166__$1 = state_37166;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_37319_37474 = state_37166__$1;
(statearr_37319_37474[(1)] = (108));

} else {
var statearr_37320_37475 = state_37166__$1;
(statearr_37320_37475[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (52))){
var state_37166__$1 = state_37166;
var statearr_37321_37476 = state_37166__$1;
(statearr_37321_37476[(2)] = false);

(statearr_37321_37476[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (67))){
var state_37166__$1 = state_37166;
var statearr_37322_37477 = state_37166__$1;
(statearr_37322_37477[(2)] = null);

(statearr_37322_37477[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (71))){
var inst_36996 = (state_37166[(11)]);
var state_37166__$1 = state_37166;
var statearr_37323_37478 = state_37166__$1;
(statearr_37323_37478[(2)] = inst_36996);

(statearr_37323_37478[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (42))){
var inst_36885 = (state_37166[(15)]);
var inst_36896 = (state_37166[(22)]);
var inst_36984 = fluree.db.dbproto._p_prop(inst_36885,cljs.core.cst$kw$name,inst_36896);
var inst_36985 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36984)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_36986 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36987 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_36988 = cljs.core.PersistentHashMap.fromArrays(inst_36986,inst_36987);
var inst_36989 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36985,inst_36988);
var inst_36990 = (function(){throw inst_36989})();
var state_37166__$1 = state_37166;
var statearr_37324_37479 = state_37166__$1;
(statearr_37324_37479[(2)] = inst_36990);

(statearr_37324_37479[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (80))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37067 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_37028,inst_37029,throw_QMARK_);
var state_37166__$1 = state_37166;
var statearr_37325_37480 = state_37166__$1;
(statearr_37325_37480[(2)] = inst_37067);

(statearr_37325_37480[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (37))){
var inst_36981 = (state_37166[(2)]);
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_36981)){
var statearr_37326_37481 = state_37166__$1;
(statearr_37326_37481[(1)] = (39));

} else {
var statearr_37327_37482 = state_37166__$1;
(statearr_37327_37482[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (63))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37038 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_37028,inst_37029,throw_QMARK_);
var state_37166__$1 = state_37166;
var statearr_37328_37483 = state_37166__$1;
(statearr_37328_37483[(2)] = inst_37038);

(statearr_37328_37483[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (94))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37101 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_37102 = (inst_37029.cljs$core$IFn$_invoke$arity$5 ? inst_37029.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_37101,null) : inst_37029.call(null,cljs.core.PersistentArrayMap,null,2,inst_37101,null));
var inst_37103 = (inst_37029.cljs$core$IFn$_invoke$arity$4 ? inst_37029.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_37102,null) : inst_37029.call(null,cljs.core.PersistentHashSet,null,inst_37102,null));
var inst_37104 = (inst_37103.cljs$core$IFn$_invoke$arity$1 ? inst_37103.cljs$core$IFn$_invoke$arity$1(inst_37028) : inst_37103.call(null,inst_37028));
var state_37166__$1 = state_37166;
if(cljs.core.truth_(inst_37104)){
var statearr_37329_37484 = state_37166__$1;
(statearr_37329_37484[(1)] = (95));

} else {
var statearr_37330_37485 = state_37166__$1;
(statearr_37330_37485[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (8))){
var inst_36885 = (state_37166[(15)]);
var state_37166__$1 = state_37166;
var statearr_37331_37486 = state_37166__$1;
(statearr_37331_37486[(2)] = inst_36885);

(statearr_37331_37486[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (49))){
var inst_36996 = (state_37166[(11)]);
var state_37166__$1 = state_37166;
var statearr_37332_37487 = state_37166__$1;
(statearr_37332_37487[(2)] = inst_36996);

(statearr_37332_37487[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37167 === (84))){
var inst_37028 = (state_37166[(7)]);
var inst_37029 = (state_37166[(8)]);
var inst_37077 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_37028,inst_37029,throw_QMARK_);
var state_37166__$1 = state_37166;
var statearr_37333_37488 = state_37166__$1;
(statearr_37333_37488[(2)] = inst_37077);

(statearr_37333_37488[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__16291__auto__ = null;
var fluree$db$query$schema$state_machine__16291__auto____0 = (function (){
var statearr_37334 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37334[(0)] = fluree$db$query$schema$state_machine__16291__auto__);

(statearr_37334[(1)] = (1));

return statearr_37334;
});
var fluree$db$query$schema$state_machine__16291__auto____1 = (function (state_37166){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_37166);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e37335){var ex__16294__auto__ = e37335;
var statearr_37336_37489 = state_37166;
(statearr_37336_37489[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_37166[(4)]))){
var statearr_37337_37490 = state_37166;
(statearr_37337_37490[(1)] = cljs.core.first((state_37166[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__37491 = state_37166;
state_37166 = G__37491;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__16291__auto__ = function(state_37166){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__16291__auto____1.call(this,state_37166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__16291__auto____0;
fluree$db$query$schema$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__16291__auto____1;
return fluree$db$query$schema$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_37338 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_37338[(6)] = c__16328__auto__);

return statearr_37338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_37515){
var state_val_37516 = (state_37515[(1)]);
if((state_val_37516 === (7))){
var state_37515__$1 = state_37515;
var statearr_37517_37536 = state_37515__$1;
(statearr_37517_37536[(2)] = db);

(statearr_37517_37536[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37516 === (1))){
var state_37515__$1 = state_37515;
var statearr_37518_37537 = state_37515__$1;
(statearr_37518_37537[(2)] = null);

(statearr_37518_37537[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37516 === (4))){
var inst_37492 = (state_37515[(2)]);
var state_37515__$1 = state_37515;
var statearr_37519_37538 = state_37515__$1;
(statearr_37519_37538[(2)] = inst_37492);

(statearr_37519_37538[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37516 === (6))){
var inst_37501 = (state_37515[(7)]);
var inst_37500 = (state_37515[(2)]);
var inst_37501__$1 = fluree.db.util.async.throw_err(inst_37500);
var inst_37502 = cljs.core.empty_QMARK_(inst_37501__$1);
var state_37515__$1 = (function (){var statearr_37520 = state_37515;
(statearr_37520[(7)] = inst_37501__$1);

return statearr_37520;
})();
if(inst_37502){
var statearr_37521_37539 = state_37515__$1;
(statearr_37521_37539[(1)] = (7));

} else {
var statearr_37522_37540 = state_37515__$1;
(statearr_37522_37540[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37516 === (3))){
var inst_37513 = (state_37515[(2)]);
var state_37515__$1 = state_37515;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37515__$1,inst_37513);
} else {
if((state_val_37516 === (2))){
var _ = (function (){var statearr_37524 = state_37515;
(statearr_37524[(4)] = cljs.core.cons((5),(state_37515[(4)])));

return statearr_37524;
})();
var inst_37498 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes);
var state_37515__$1 = state_37515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37515__$1,(6),inst_37498);
} else {
if((state_val_37516 === (9))){
var inst_37510 = (state_37515[(2)]);
var _ = (function (){var statearr_37525 = state_37515;
(statearr_37525[(4)] = cljs.core.rest((state_37515[(4)])));

return statearr_37525;
})();
var state_37515__$1 = state_37515;
var statearr_37526_37541 = state_37515__$1;
(statearr_37526_37541[(2)] = inst_37510);

(statearr_37526_37541[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37516 === (5))){
var _ = (function (){var statearr_37527 = state_37515;
(statearr_37527[(4)] = cljs.core.rest((state_37515[(4)])));

return statearr_37527;
})();
var state_37515__$1 = state_37515;
var ex37523 = (state_37515__$1[(2)]);
var statearr_37528_37542 = state_37515__$1;
(statearr_37528_37542[(5)] = ex37523);


if((ex37523 instanceof Error)){
var statearr_37529_37543 = state_37515__$1;
(statearr_37529_37543[(1)] = (4));

(statearr_37529_37543[(5)] = null);

} else {
throw ex37523;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37516 === (10))){
var inst_37507 = (state_37515[(2)]);
var inst_37508 = fluree.db.util.async.throw_err(inst_37507);
var state_37515__$1 = state_37515;
var statearr_37530_37544 = state_37515__$1;
(statearr_37530_37544[(2)] = inst_37508);

(statearr_37530_37544[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37516 === (8))){
var inst_37501 = (state_37515[(7)]);
var inst_37505 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_37501,db,true);
var state_37515__$1 = state_37515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37515__$1,(10),inst_37505);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__16291__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__16291__auto____0 = (function (){
var statearr_37531 = [null,null,null,null,null,null,null,null];
(statearr_37531[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__16291__auto__);

(statearr_37531[(1)] = (1));

return statearr_37531;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__16291__auto____1 = (function (state_37515){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_37515);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e37532){var ex__16294__auto__ = e37532;
var statearr_37533_37545 = state_37515;
(statearr_37533_37545[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_37515[(4)]))){
var statearr_37534_37546 = state_37515;
(statearr_37534_37546[(1)] = cljs.core.first((state_37515[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__37547 = state_37515;
state_37515 = G__37547;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__16291__auto__ = function(state_37515){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__16291__auto____1.call(this,state_37515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__16291__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__16291__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_37535 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_37535[(6)] = c__16328__auto__);

return statearr_37535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__37549 = arguments.length;
switch (G__37549) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__37551 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37551,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37551,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37551,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__37554_SHARP_,p2__37555_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37554_SHARP_,p2__37555_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_37621){
var state_val_37622 = (state_37621[(1)]);
if((state_val_37622 === (1))){
var state_37621__$1 = state_37621;
var statearr_37623_37641 = state_37621__$1;
(statearr_37623_37641[(2)] = null);

(statearr_37623_37641[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37622 === (2))){
var _ = (function (){var statearr_37624 = state_37621;
(statearr_37624[(4)] = cljs.core.cons((5),(state_37621[(4)])));

return statearr_37624;
})();
var inst_37573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37574 = fluree.db.flake.max_subject_id((1));
var inst_37575 = [inst_37574];
var inst_37576 = (new cljs.core.PersistentVector(null,1,(5),inst_37573,inst_37575,null));
var inst_37577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37578 = [(0)];
var inst_37579 = (new cljs.core.PersistentVector(null,1,(5),inst_37577,inst_37578,null));
var inst_37580 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_37576,cljs.core._LT__EQ_,inst_37579);
var state_37621__$1 = state_37621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37621__$1,(6),inst_37580);
} else {
if((state_val_37622 === (3))){
var inst_37619 = (state_37621[(2)]);
var state_37621__$1 = state_37621;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37621__$1,inst_37619);
} else {
if((state_val_37622 === (4))){
var inst_37561 = (state_37621[(2)]);
var state_37621__$1 = state_37621;
var statearr_37626_37642 = state_37621__$1;
(statearr_37626_37642[(2)] = inst_37561);

(statearr_37626_37642[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37622 === (5))){
var _ = (function (){var statearr_37627 = state_37621;
(statearr_37627[(4)] = cljs.core.rest((state_37621[(4)])));

return statearr_37627;
})();
var state_37621__$1 = state_37621;
var ex37625 = (state_37621__$1[(2)]);
var statearr_37628_37643 = state_37621__$1;
(statearr_37628_37643[(5)] = ex37625);


if((ex37625 instanceof Error)){
var statearr_37629_37644 = state_37621__$1;
(statearr_37629_37644[(1)] = (4));

(statearr_37629_37644[(5)] = null);

} else {
throw ex37625;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37622 === (6))){
var inst_37582 = (state_37621[(2)]);
var inst_37583 = fluree.db.util.async.throw_err(inst_37582);
var inst_37584 = (function (){var schema_flakes = inst_37583;
return (function (p1__37556_SHARP_){
return (p1__37556_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_37585 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_37584,inst_37583);
var inst_37586 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37585,(0),null);
var inst_37587 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37585,(1),null);
var inst_37588 = (function (){var schema_flakes = inst_37583;
var vec__37567 = inst_37585;
var collection_flakes = inst_37586;
var predicate_flakes = inst_37587;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var id = fluree.db.flake.sid__GT_i(sid);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__37558_SHARP_,p2__37559_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__37558_SHARP_,p2__37559_SHARP_.p,p2__37559_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43));
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,id], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,id,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_37589 = [(-1),"_tx"];
var inst_37590 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_37591 = ["_tx",(-1),(-1)];
var inst_37592 = cljs.core.PersistentHashMap.fromArrays(inst_37590,inst_37591);
var inst_37593 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_37594 = ["_tx",(-1),(-1)];
var inst_37595 = cljs.core.PersistentHashMap.fromArrays(inst_37593,inst_37594);
var inst_37596 = [inst_37592,inst_37595];
var inst_37597 = cljs.core.PersistentHashMap.fromArrays(inst_37589,inst_37596);
var inst_37598 = (function (){var schema_flakes = inst_37583;
var vec__37567 = inst_37585;
var collection_flakes = inst_37586;
var predicate_flakes = inst_37587;
return (function (p1__37557_SHARP_){
return p1__37557_SHARP_.s;
});
})();
var inst_37599 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_37598,inst_37586);
var inst_37600 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_37588,inst_37597,inst_37599);
var inst_37602 = (function (){var schema_flakes = inst_37583;
var vec__37567 = inst_37585;
var collection_flakes = inst_37586;
var predicate_flakes = inst_37587;
var coll = inst_37600;
return (function (p__37601,pred_flakes){
var vec__37630 = p__37601;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37630,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37630,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__37633 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__37633.cljs$core$IFn$_invoke$arity$1 ? fexpr__37633.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__37633.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_37603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37604 = cljs.core.PersistentHashMap.EMPTY;
var inst_37605 = cljs.core.PersistentHashSet.EMPTY;
var inst_37606 = [inst_37604,inst_37605];
var inst_37607 = (new cljs.core.PersistentVector(null,2,(5),inst_37603,inst_37606,null));
var inst_37608 = (function (){var schema_flakes = inst_37583;
var vec__37567 = inst_37585;
var collection_flakes = inst_37586;
var predicate_flakes = inst_37587;
var coll = inst_37600;
return (function (p1__37560_SHARP_){
return p1__37560_SHARP_.s;
});
})();
var inst_37609 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_37608,inst_37587);
var inst_37610 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_37602,inst_37607,inst_37609);
var inst_37611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37610,(0),null);
var inst_37612 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37610,(1),null);
var inst_37613 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_37614 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_37615 = [inst_37614,inst_37600,inst_37611,inst_37612];
var inst_37616 = cljs.core.PersistentHashMap.fromArrays(inst_37613,inst_37615);
var _ = (function (){var statearr_37634 = state_37621;
(statearr_37634[(4)] = cljs.core.rest((state_37621[(4)])));

return statearr_37634;
})();
var state_37621__$1 = state_37621;
var statearr_37635_37645 = state_37621__$1;
(statearr_37635_37645[(2)] = inst_37616);

(statearr_37635_37645[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__16291__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__16291__auto____0 = (function (){
var statearr_37636 = [null,null,null,null,null,null,null];
(statearr_37636[(0)] = fluree$db$query$schema$schema_map_$_state_machine__16291__auto__);

(statearr_37636[(1)] = (1));

return statearr_37636;
});
var fluree$db$query$schema$schema_map_$_state_machine__16291__auto____1 = (function (state_37621){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_37621);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e37637){var ex__16294__auto__ = e37637;
var statearr_37638_37646 = state_37621;
(statearr_37638_37646[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_37621[(4)]))){
var statearr_37639_37647 = state_37621;
(statearr_37639_37647[(1)] = cljs.core.first((state_37621[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__37648 = state_37621;
state_37621 = G__37648;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__16291__auto__ = function(state_37621){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__16291__auto____1.call(this,state_37621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__16291__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__16291__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_37640 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_37640[(6)] = c__16328__auto__);

return statearr_37640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_37690){
var state_val_37691 = (state_37690[(1)]);
if((state_val_37691 === (7))){
var inst_37673 = (state_37690[(2)]);
var inst_37674 = fluree.db.query.schema.flake__GT_pred_map(inst_37673);
var inst_37675 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_37676 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37674,(114));
var inst_37677 = cljs.core.boolean$(inst_37676);
var inst_37678 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37674,(110));
var inst_37679 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37674,(117));
var inst_37680 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_37679);
var inst_37681 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37674,(111));
var inst_37682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37674,(115));
var inst_37683 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37674,(112));
var inst_37684 = [inst_37677,inst_37678,inst_37680,inst_37681,inst_37682,inst_37683];
var inst_37685 = cljs.core.PersistentHashMap.fromArrays(inst_37675,inst_37684);
var _ = (function (){var statearr_37692 = state_37690;
(statearr_37692[(4)] = cljs.core.rest((state_37690[(4)])));

return statearr_37692;
})();
var state_37690__$1 = state_37690;
var statearr_37693_37716 = state_37690__$1;
(statearr_37693_37716[(2)] = inst_37685);

(statearr_37693_37716[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37691 === (1))){
var state_37690__$1 = state_37690;
var statearr_37694_37717 = state_37690__$1;
(statearr_37694_37717[(2)] = null);

(statearr_37694_37717[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37691 === (4))){
var inst_37649 = (state_37690[(2)]);
var state_37690__$1 = state_37690;
var statearr_37695_37718 = state_37690__$1;
(statearr_37695_37718[(2)] = inst_37649);

(statearr_37695_37718[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37691 === (6))){
var _ = (function (){var statearr_37696 = state_37690;
(statearr_37696[(4)] = cljs.core.cons((9),(state_37690[(4)])));

return statearr_37696;
})();
var inst_37661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37663 = ["_setting/id","root"];
var inst_37664 = (new cljs.core.PersistentVector(null,2,(5),inst_37662,inst_37663,null));
var inst_37665 = [inst_37664];
var inst_37666 = (new cljs.core.PersistentVector(null,1,(5),inst_37661,inst_37665,null));
var inst_37667 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37666);
var state_37690__$1 = state_37690;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37690__$1,(10),inst_37667);
} else {
if((state_val_37691 === (3))){
var inst_37688 = (state_37690[(2)]);
var state_37690__$1 = state_37690;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37690__$1,inst_37688);
} else {
if((state_val_37691 === (2))){
var _ = (function (){var statearr_37699 = state_37690;
(statearr_37699[(4)] = cljs.core.cons((5),(state_37690[(4)])));

return statearr_37699;
})();
var state_37690__$1 = state_37690;
var statearr_37700_37719 = state_37690__$1;
(statearr_37700_37719[(2)] = null);

(statearr_37700_37719[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37691 === (9))){
var _ = (function (){var statearr_37701 = state_37690;
(statearr_37701[(4)] = cljs.core.rest((state_37690[(4)])));

return statearr_37701;
})();
var state_37690__$1 = state_37690;
var ex37697 = (state_37690__$1[(2)]);
var statearr_37702_37720 = state_37690__$1;
(statearr_37702_37720[(5)] = ex37697);


var statearr_37703_37721 = state_37690__$1;
(statearr_37703_37721[(1)] = (8));

(statearr_37703_37721[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_37691 === (5))){
var _ = (function (){var statearr_37704 = state_37690;
(statearr_37704[(4)] = cljs.core.rest((state_37690[(4)])));

return statearr_37704;
})();
var state_37690__$1 = state_37690;
var ex37698 = (state_37690__$1[(2)]);
var statearr_37705_37722 = state_37690__$1;
(statearr_37705_37722[(5)] = ex37698);


if((ex37698 instanceof Error)){
var statearr_37706_37723 = state_37690__$1;
(statearr_37706_37723[(1)] = (4));

(statearr_37706_37723[(5)] = null);

} else {
throw ex37698;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37691 === (10))){
var inst_37669 = (state_37690[(2)]);
var inst_37670 = fluree.db.util.async.throw_err(inst_37669);
var _ = (function (){var statearr_37707 = state_37690;
(statearr_37707[(4)] = cljs.core.rest((state_37690[(4)])));

return statearr_37707;
})();
var state_37690__$1 = state_37690;
var statearr_37708_37724 = state_37690__$1;
(statearr_37708_37724[(2)] = inst_37670);

(statearr_37708_37724[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37691 === (8))){
var inst_37655 = (state_37690[(2)]);
var state_37690__$1 = (function (){var statearr_37709 = state_37690;
(statearr_37709[(7)] = inst_37655);

return statearr_37709;
})();
var statearr_37710_37725 = state_37690__$1;
(statearr_37710_37725[(2)] = null);

(statearr_37710_37725[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__16291__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__16291__auto____0 = (function (){
var statearr_37711 = [null,null,null,null,null,null,null,null];
(statearr_37711[(0)] = fluree$db$query$schema$setting_map_$_state_machine__16291__auto__);

(statearr_37711[(1)] = (1));

return statearr_37711;
});
var fluree$db$query$schema$setting_map_$_state_machine__16291__auto____1 = (function (state_37690){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_37690);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e37712){var ex__16294__auto__ = e37712;
var statearr_37713_37726 = state_37690;
(statearr_37713_37726[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_37690[(4)]))){
var statearr_37714_37727 = state_37690;
(statearr_37714_37727[(1)] = cljs.core.first((state_37690[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__37728 = state_37690;
state_37690 = G__37728;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__16291__auto__ = function(state_37690){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__16291__auto____1.call(this,state_37690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__16291__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__16291__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_37715 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_37715[(6)] = c__16328__auto__);

return statearr_37715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
