// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.cache');
goog.require('cljs.core');
goog.require('tailrecursion.priority_map');

/**
 * This is the protocol describing the basic cache capability.
 * @interface
 */
cljs.cache.CacheProtocol = function(){};

var cljs$cache$CacheProtocol$lookup$dyn_38874 = (function() {
var G__38875 = null;
var G__38875__2 = (function (cache,e){
var x__4550__auto__ = (((cache == null))?null:cache);
var m__4551__auto__ = (cljs.cache.lookup[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(cache,e) : m__4551__auto__.call(null,cache,e));
} else {
var m__4549__auto__ = (cljs.cache.lookup["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(cache,e) : m__4549__auto__.call(null,cache,e));
} else {
throw cljs.core.missing_protocol("CacheProtocol.lookup",cache);
}
}
});
var G__38875__3 = (function (cache,e,not_found){
var x__4550__auto__ = (((cache == null))?null:cache);
var m__4551__auto__ = (cljs.cache.lookup[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(cache,e,not_found) : m__4551__auto__.call(null,cache,e,not_found));
} else {
var m__4549__auto__ = (cljs.cache.lookup["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(cache,e,not_found) : m__4549__auto__.call(null,cache,e,not_found));
} else {
throw cljs.core.missing_protocol("CacheProtocol.lookup",cache);
}
}
});
G__38875 = function(cache,e,not_found){
switch(arguments.length){
case 2:
return G__38875__2.call(this,cache,e);
case 3:
return G__38875__3.call(this,cache,e,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__38875.cljs$core$IFn$_invoke$arity$2 = G__38875__2;
G__38875.cljs$core$IFn$_invoke$arity$3 = G__38875__3;
return G__38875;
})()
;
/**
 * Retrieve the value associated with `e` if it exists, else `nil` in
 *   the 2-arg case. Retrieve the value associated with `e` if it exists,
 *   else `not-found` in the 3-arg case.
 */
cljs.cache.lookup = (function cljs$cache$lookup(var_args){
var G__38873 = arguments.length;
switch (G__38873) {
case 2:
return cljs.cache.lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.cache.lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.cache.lookup.cljs$core$IFn$_invoke$arity$2 = (function (cache,e){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$lookup$arity$2 == null)))))){
return cache.cljs$cache$CacheProtocol$lookup$arity$2(cache,e);
} else {
return cljs$cache$CacheProtocol$lookup$dyn_38874.cljs$core$IFn$_invoke$arity$2(cache,e);
}
}));

(cljs.cache.lookup.cljs$core$IFn$_invoke$arity$3 = (function (cache,e,not_found){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$lookup$arity$3 == null)))))){
return cache.cljs$cache$CacheProtocol$lookup$arity$3(cache,e,not_found);
} else {
return cljs$cache$CacheProtocol$lookup$dyn_38874.cljs$core$IFn$_invoke$arity$3(cache,e,not_found);
}
}));

(cljs.cache.lookup.cljs$lang$maxFixedArity = 3);


var cljs$cache$CacheProtocol$has_QMARK_$dyn_38877 = (function (cache,e){
var x__4550__auto__ = (((cache == null))?null:cache);
var m__4551__auto__ = (cljs.cache.has_QMARK_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(cache,e) : m__4551__auto__.call(null,cache,e));
} else {
var m__4549__auto__ = (cljs.cache.has_QMARK_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(cache,e) : m__4549__auto__.call(null,cache,e));
} else {
throw cljs.core.missing_protocol("CacheProtocol.has?",cache);
}
}
});
/**
 * Checks if the cache contains a value associated with `e`
 */
cljs.cache.has_QMARK_ = (function cljs$cache$has_QMARK_(cache,e){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$has_QMARK_$arity$2 == null)))))){
return cache.cljs$cache$CacheProtocol$has_QMARK_$arity$2(cache,e);
} else {
return cljs$cache$CacheProtocol$has_QMARK_$dyn_38877(cache,e);
}
});

var cljs$cache$CacheProtocol$hit$dyn_38878 = (function (cache,e){
var x__4550__auto__ = (((cache == null))?null:cache);
var m__4551__auto__ = (cljs.cache.hit[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(cache,e) : m__4551__auto__.call(null,cache,e));
} else {
var m__4549__auto__ = (cljs.cache.hit["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(cache,e) : m__4549__auto__.call(null,cache,e));
} else {
throw cljs.core.missing_protocol("CacheProtocol.hit",cache);
}
}
});
/**
 * Is meant to be called if the cache is determined to contain a value
 *   associated with `e`
 */
cljs.cache.hit = (function cljs$cache$hit(cache,e){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$hit$arity$2 == null)))))){
return cache.cljs$cache$CacheProtocol$hit$arity$2(cache,e);
} else {
return cljs$cache$CacheProtocol$hit$dyn_38878(cache,e);
}
});

var cljs$cache$CacheProtocol$miss$dyn_38879 = (function (cache,e,ret){
var x__4550__auto__ = (((cache == null))?null:cache);
var m__4551__auto__ = (cljs.cache.miss[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(cache,e,ret) : m__4551__auto__.call(null,cache,e,ret));
} else {
var m__4549__auto__ = (cljs.cache.miss["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(cache,e,ret) : m__4549__auto__.call(null,cache,e,ret));
} else {
throw cljs.core.missing_protocol("CacheProtocol.miss",cache);
}
}
});
/**
 * Is meant to be called if the cache is determined to **not** contain a
 *   value associated with `e`
 */
cljs.cache.miss = (function cljs$cache$miss(cache,e,ret){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$miss$arity$3 == null)))))){
return cache.cljs$cache$CacheProtocol$miss$arity$3(cache,e,ret);
} else {
return cljs$cache$CacheProtocol$miss$dyn_38879(cache,e,ret);
}
});

var cljs$cache$CacheProtocol$evict$dyn_38880 = (function (cache,e){
var x__4550__auto__ = (((cache == null))?null:cache);
var m__4551__auto__ = (cljs.cache.evict[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(cache,e) : m__4551__auto__.call(null,cache,e));
} else {
var m__4549__auto__ = (cljs.cache.evict["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(cache,e) : m__4549__auto__.call(null,cache,e));
} else {
throw cljs.core.missing_protocol("CacheProtocol.evict",cache);
}
}
});
/**
 * Removes an entry from the cache
 */
cljs.cache.evict = (function cljs$cache$evict(cache,e){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$evict$arity$2 == null)))))){
return cache.cljs$cache$CacheProtocol$evict$arity$2(cache,e);
} else {
return cljs$cache$CacheProtocol$evict$dyn_38880(cache,e);
}
});

var cljs$cache$CacheProtocol$seed$dyn_38881 = (function (cache,base){
var x__4550__auto__ = (((cache == null))?null:cache);
var m__4551__auto__ = (cljs.cache.seed[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(cache,base) : m__4551__auto__.call(null,cache,base));
} else {
var m__4549__auto__ = (cljs.cache.seed["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(cache,base) : m__4549__auto__.call(null,cache,base));
} else {
throw cljs.core.missing_protocol("CacheProtocol.seed",cache);
}
}
});
/**
 * Is used to signal that the cache should be created with a seed.
 *   The contract is that said cache should return an instance of its
 *   own type.
 */
cljs.cache.seed = (function cljs$cache$seed(cache,base){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$seed$arity$2 == null)))))){
return cache.cljs$cache$CacheProtocol$seed$arity$2(cache,base);
} else {
return cljs$cache$CacheProtocol$seed$dyn_38881(cache,base);
}
});

cljs.cache.default_wrapper_fn = (function cljs$cache$default_wrapper_fn(p1__38882_SHARP_,p2__38883_SHARP_){
return (p1__38882_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__38882_SHARP_.cljs$core$IFn$_invoke$arity$1(p2__38883_SHARP_) : p1__38882_SHARP_.call(null,p2__38883_SHARP_));
});
/**
 * The basic hit/miss logic for the cache system. Expects a wrap function and
 *   value function.  The wrap function takes the value function and the item in
 *   question and is expected to run the value function with the item whenever a
 *   cache miss occurs.  The intent is to hide any cache-specific cells from
 *   leaking into the cache logic itelf.
 */
cljs.cache.through = (function cljs$cache$through(var_args){
var G__38886 = arguments.length;
switch (G__38886) {
case 2:
return cljs.cache.through.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.cache.through.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.cache.through.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.cache.through.cljs$core$IFn$_invoke$arity$2 = (function (cache,item){
return cljs.cache.through.cljs$core$IFn$_invoke$arity$4(cljs.cache.default_wrapper_fn,cljs.core.identity,cache,item);
}));

(cljs.cache.through.cljs$core$IFn$_invoke$arity$3 = (function (value_fn,cache,item){
return cljs.cache.through.cljs$core$IFn$_invoke$arity$4(cljs.cache.default_wrapper_fn,value_fn,cache,item);
}));

(cljs.cache.through.cljs$core$IFn$_invoke$arity$4 = (function (wrap_fn,value_fn,cache,item){
if(cljs.core.truth_(cljs.cache.has_QMARK_(cache,item))){
return cljs.cache.hit(cache,item);
} else {
return cljs.cache.miss(cache,item,(function (){var G__38887 = (function (p1__38884_SHARP_){
return (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(p1__38884_SHARP_) : value_fn.call(null,p1__38884_SHARP_));
});
var G__38888 = item;
return (wrap_fn.cljs$core$IFn$_invoke$arity$2 ? wrap_fn.cljs$core$IFn$_invoke$arity$2(G__38887,G__38888) : wrap_fn.call(null,G__38887,G__38888));
})());
}
}));

(cljs.cache.through.cljs$lang$maxFixedArity = 4);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.cache.CacheProtocol}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.cache.Object}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.cache.BasicCache = (function (cache){
this.cache = cache;
this.cljs$lang$protocol_mask$partition0$ = 10487566;
this.cljs$lang$protocol_mask$partition1$ = 131072;
});
(cljs.cache.BasicCache.prototype.toString = (function (){
var self__ = this;
var _ = this;
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cache);
}));

(cljs.cache.BasicCache.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__38854__auto__,other__38861__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(other__38861__auto__,self__.cache);
}));

(cljs.cache.BasicCache.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__38854__auto__,elem__38860__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$seed$arity$2(null,(function (){var fexpr__38890 = new cljs.core.Symbol("cljs.cache","-conj","cljs.cache/-conj",837886777,null);
return (fexpr__38890.cljs$core$IFn$_invoke$arity$2 ? fexpr__38890.cljs$core$IFn$_invoke$arity$2(self__.cache,elem__38860__auto__) : fexpr__38890.call(null,self__.cache,elem__38860__auto__));
})());
}));

(cljs.cache.BasicCache.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this__38854__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$seed$arity$2(null,(function (){var fexpr__38891 = new cljs.core.Symbol("cljs.cache","-empty","cljs.cache/-empty",-190310872,null);
return (fexpr__38891.cljs$core$IFn$_invoke$arity$1 ? fexpr__38891.cljs$core$IFn$_invoke$arity$1(self__.cache) : fexpr__38891.call(null,self__.cache));
})());
}));

(cljs.cache.BasicCache.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__38854__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return cljs.core._count(self__.cache);
}));

(cljs.cache.BasicCache.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (___38857__auto__){
var self__ = this;
var ___38857__auto____$1 = this;
return cljs.core._seq(self__.cache);
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$lookup$arity$2 = (function (_,item){
var self__ = this;
var ___$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.cache,item);
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$lookup$arity$3 = (function (_,item,not_found){
var self__ = this;
var ___$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.cache,item,not_found);
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$has_QMARK_$arity$2 = (function (_,item){
var self__ = this;
var ___$1 = this;
return cljs.core.contains_QMARK_(self__.cache,item);
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$hit$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$miss$arity$3 = (function (_,item,result){
var self__ = this;
var ___$1 = this;
return (new cljs.cache.BasicCache(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.cache,item,result)));
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$evict$arity$2 = (function (_,key){
var self__ = this;
var ___$1 = this;
return (new cljs.cache.BasicCache(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.cache,key)));
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$seed$arity$2 = (function (_,base){
var self__ = this;
var ___$1 = this;
return (new cljs.cache.BasicCache(base));
}));

(cljs.cache.BasicCache.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (___38857__auto__){
var self__ = this;
var ___38857__auto____$1 = this;
return self__.cache.iterator();
}));

(cljs.cache.BasicCache.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__38854__auto__,k__38858__auto__,v__38859__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$miss$arity$3(null,k__38858__auto__,v__38859__auto__);
}));

(cljs.cache.BasicCache.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__38854__auto__,k__38858__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$has_QMARK_$arity$2(null,k__38858__auto__);
}));

(cljs.cache.BasicCache.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__38854__auto__,k__38858__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$evict$arity$2(null,k__38858__auto__);
}));

(cljs.cache.BasicCache.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__38854__auto__,key__38855__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,key__38855__auto__,null);
}));

(cljs.cache.BasicCache.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__38854__auto__,key__38855__auto__,not_found__38856__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
if(cljs.core.truth_(this__38854__auto____$1.cljs$cache$CacheProtocol$has_QMARK_$arity$2(null,key__38855__auto__))){
return this__38854__auto____$1.cljs$cache$CacheProtocol$lookup$arity$2(null,key__38855__auto__);
} else {
return not_found__38856__auto__;
}
}));

(cljs.cache.BasicCache.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null)], null);
}));

(cljs.cache.BasicCache.cljs$lang$type = true);

(cljs.cache.BasicCache.cljs$lang$ctorStr = "cljs.cache/BasicCache");

(cljs.cache.BasicCache.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.cache/BasicCache");
}));

/**
 * Positional factory function for cljs.cache/BasicCache.
 */
cljs.cache.__GT_BasicCache = (function cljs$cache$__GT_BasicCache(cache){
return (new cljs.cache.BasicCache(cache));
});

cljs.cache.get_time = (function cljs$cache$get_time(){
return (new Date()).getTime();
});
/**
 * returns a fn that dissocs expired keys from a map
 */
cljs.cache.key_killer_fn = (function cljs$cache$key_killer_fn(ttl,expiry,now){
var ks = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__38892_SHARP_){
return ((now - cljs.core.val(p1__38892_SHARP_)) > expiry);
}),ttl));
return (function (p1__38893_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,p1__38893_SHARP_,ks);
});
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.cache.CacheProtocol}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.cache.Object}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.cache.TTLCache = (function (cache,ttl,ttl_ms){
this.cache = cache;
this.ttl = ttl;
this.ttl_ms = ttl_ms;
this.cljs$lang$protocol_mask$partition0$ = 10487566;
this.cljs$lang$protocol_mask$partition1$ = 131072;
});
(cljs.cache.TTLCache.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cache),","," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.ttl),","," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.ttl_ms)].join('');
}));

(cljs.cache.TTLCache.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__38854__auto__,other__38861__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(other__38861__auto__,self__.cache);
}));

(cljs.cache.TTLCache.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__38854__auto__,elem__38860__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$seed$arity$2(null,(function (){var fexpr__38894 = new cljs.core.Symbol("cljs.cache","-conj","cljs.cache/-conj",837886777,null);
return (fexpr__38894.cljs$core$IFn$_invoke$arity$2 ? fexpr__38894.cljs$core$IFn$_invoke$arity$2(self__.cache,elem__38860__auto__) : fexpr__38894.call(null,self__.cache,elem__38860__auto__));
})());
}));

(cljs.cache.TTLCache.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this__38854__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$seed$arity$2(null,(function (){var fexpr__38895 = new cljs.core.Symbol("cljs.cache","-empty","cljs.cache/-empty",-190310872,null);
return (fexpr__38895.cljs$core$IFn$_invoke$arity$1 ? fexpr__38895.cljs$core$IFn$_invoke$arity$1(self__.cache) : fexpr__38895.call(null,self__.cache));
})());
}));

(cljs.cache.TTLCache.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__38854__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return cljs.core._count(self__.cache);
}));

(cljs.cache.TTLCache.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (___38857__auto__){
var self__ = this;
var ___38857__auto____$1 = this;
return cljs.core._seq(self__.cache);
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var ret = this$__$1.cljs$cache$CacheProtocol$lookup$arity$3(null,item,new cljs.core.Keyword("cljs.cache","nope","cljs.cache/nope",968062453));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ret,new cljs.core.Keyword("cljs.cache","nope","cljs.cache/nope",968062453))){
return null;
} else {
return ret;
}
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$lookup$arity$3 = (function (this$,item,not_found){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(this$__$1.cljs$cache$CacheProtocol$has_QMARK_$arity$2(null,item))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.cache,item);
} else {
return not_found;
}
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$has_QMARK_$arity$2 = (function (_,item){
var self__ = this;
var ___$1 = this;
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.ttl,item,(- self__.ttl_ms));
return ((cljs.cache.get_time() - t) < self__.ttl_ms);
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$hit$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$miss$arity$3 = (function (this$,item,result){
var self__ = this;
var this$__$1 = this;
var now = cljs.cache.get_time();
var kill_old = cljs.cache.key_killer_fn(self__.ttl,self__.ttl_ms,now);
return (new cljs.cache.TTLCache(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((kill_old.cljs$core$IFn$_invoke$arity$1 ? kill_old.cljs$core$IFn$_invoke$arity$1(self__.cache) : kill_old.call(null,self__.cache)),item,result),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((kill_old.cljs$core$IFn$_invoke$arity$1 ? kill_old.cljs$core$IFn$_invoke$arity$1(self__.ttl) : kill_old.call(null,self__.ttl)),item,now),self__.ttl_ms));
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$seed$arity$2 = (function (_,base){
var self__ = this;
var ___$1 = this;
var now = cljs.cache.get_time();
return (new cljs.cache.TTLCache(base,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4652__auto__ = (function cljs$cache$iter__38896(s__38897){
return (new cljs.core.LazySeq(null,(function (){
var s__38897__$1 = s__38897;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38897__$1);
if(temp__5753__auto__){
var s__38897__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38897__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__38897__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__38899 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__38898 = (0);
while(true){
if((i__38898 < size__4651__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__38898);
cljs.core.chunk_append(b__38899,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.key(x),now], null));

var G__38900 = (i__38898 + (1));
i__38898 = G__38900;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38899),cljs$cache$iter__38896(cljs.core.chunk_rest(s__38897__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38899),null);
}
} else {
var x = cljs.core.first(s__38897__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.key(x),now], null),cljs$cache$iter__38896(cljs.core.rest(s__38897__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(base);
})()),self__.ttl_ms));
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$evict$arity$2 = (function (_,key){
var self__ = this;
var ___$1 = this;
return (new cljs.cache.TTLCache(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.cache,key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.ttl,key),self__.ttl_ms));
}));

(cljs.cache.TTLCache.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (___38857__auto__){
var self__ = this;
var ___38857__auto____$1 = this;
return self__.cache.iterator();
}));

(cljs.cache.TTLCache.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__38854__auto__,k__38858__auto__,v__38859__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$miss$arity$3(null,k__38858__auto__,v__38859__auto__);
}));

(cljs.cache.TTLCache.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__38854__auto__,k__38858__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$has_QMARK_$arity$2(null,k__38858__auto__);
}));

(cljs.cache.TTLCache.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__38854__auto__,k__38858__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$evict$arity$2(null,k__38858__auto__);
}));

(cljs.cache.TTLCache.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__38854__auto__,key__38855__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,key__38855__auto__,null);
}));

(cljs.cache.TTLCache.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__38854__auto__,key__38855__auto__,not_found__38856__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
if(cljs.core.truth_(this__38854__auto____$1.cljs$cache$CacheProtocol$has_QMARK_$arity$2(null,key__38855__auto__))){
return this__38854__auto____$1.cljs$cache$CacheProtocol$lookup$arity$2(null,key__38855__auto__);
} else {
return not_found__38856__auto__;
}
}));

(cljs.cache.TTLCache.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"ttl","ttl",525256409,null),new cljs.core.Symbol(null,"ttl-ms","ttl-ms",-1349172894,null)], null);
}));

(cljs.cache.TTLCache.cljs$lang$type = true);

(cljs.cache.TTLCache.cljs$lang$ctorStr = "cljs.cache/TTLCache");

(cljs.cache.TTLCache.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.cache/TTLCache");
}));

/**
 * Positional factory function for cljs.cache/TTLCache.
 */
cljs.cache.__GT_TTLCache = (function cljs$cache$__GT_TTLCache(cache,ttl,ttl_ms){
return (new cljs.cache.TTLCache(cache,ttl,ttl_ms));
});

cljs.cache.build_leastness_queue = (function cljs$cache$build_leastness_queue(base,limit,start_at){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.priority_map(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.take.cljs$core$IFn$_invoke$arity$2((limit - cljs.core.count(base)),(function (){var iter__4652__auto__ = (function cljs$cache$build_leastness_queue_$_iter__38901(s__38902){
return (new cljs.core.LazySeq(null,(function (){
var s__38902__$1 = s__38902;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38902__$1);
if(temp__5753__auto__){
var s__38902__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38902__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__38902__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__38904 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__38903 = (0);
while(true){
if((i__38903 < size__4651__auto__)){
var k = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__38903);
cljs.core.chunk_append(b__38904,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,k], null));

var G__38915 = (i__38903 + (1));
i__38903 = G__38915;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38904),cljs$cache$build_leastness_queue_$_iter__38901(cljs.core.chunk_rest(s__38902__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38904),null);
}
} else {
var k = cljs.core.first(s__38902__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,k], null),cljs$cache$build_leastness_queue_$_iter__38901(cljs.core.rest(s__38902__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$2((- limit),(0)));
})()),(function (){var iter__4652__auto__ = (function cljs$cache$build_leastness_queue_$_iter__38905(s__38906){
return (new cljs.core.LazySeq(null,(function (){
var s__38906__$1 = s__38906;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38906__$1);
if(temp__5753__auto__){
var s__38906__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38906__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__38906__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__38908 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__38907 = (0);
while(true){
if((i__38907 < size__4651__auto__)){
var vec__38909 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__38907);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38909,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38909,(1),null);
cljs.core.chunk_append(b__38908,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,start_at], null));

var G__38916 = (i__38907 + (1));
i__38907 = G__38916;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38908),cljs$cache$build_leastness_queue_$_iter__38905(cljs.core.chunk_rest(s__38906__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38908),null);
}
} else {
var vec__38912 = cljs.core.first(s__38906__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38912,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38912,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,start_at], null),cljs$cache$build_leastness_queue_$_iter__38905(cljs.core.rest(s__38906__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(base);
})()));
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.cache.CacheProtocol}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.cache.Object}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.cache.LRUCache = (function (cache,lru,tick,limit){
this.cache = cache;
this.lru = lru;
this.tick = tick;
this.limit = limit;
this.cljs$lang$protocol_mask$partition0$ = 10487566;
this.cljs$lang$protocol_mask$partition1$ = 131072;
});
(cljs.cache.LRUCache.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cache),","," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.lru),","," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.tick),","," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.limit)].join('');
}));

(cljs.cache.LRUCache.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__38854__auto__,other__38861__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(other__38861__auto__,self__.cache);
}));

(cljs.cache.LRUCache.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__38854__auto__,elem__38860__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$seed$arity$2(null,(function (){var fexpr__38917 = new cljs.core.Symbol("cljs.cache","-conj","cljs.cache/-conj",837886777,null);
return (fexpr__38917.cljs$core$IFn$_invoke$arity$2 ? fexpr__38917.cljs$core$IFn$_invoke$arity$2(self__.cache,elem__38860__auto__) : fexpr__38917.call(null,self__.cache,elem__38860__auto__));
})());
}));

(cljs.cache.LRUCache.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this__38854__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$seed$arity$2(null,(function (){var fexpr__38918 = new cljs.core.Symbol("cljs.cache","-empty","cljs.cache/-empty",-190310872,null);
return (fexpr__38918.cljs$core$IFn$_invoke$arity$1 ? fexpr__38918.cljs$core$IFn$_invoke$arity$1(self__.cache) : fexpr__38918.call(null,self__.cache));
})());
}));

(cljs.cache.LRUCache.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__38854__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return cljs.core._count(self__.cache);
}));

(cljs.cache.LRUCache.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (___38857__auto__){
var self__ = this;
var ___38857__auto____$1 = this;
return cljs.core._seq(self__.cache);
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$lookup$arity$2 = (function (_,item){
var self__ = this;
var ___$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.cache,item);
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$lookup$arity$3 = (function (_,item,not_found){
var self__ = this;
var ___$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.cache,item,not_found);
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$has_QMARK_$arity$2 = (function (_,item){
var self__ = this;
var ___$1 = this;
return cljs.core.contains_QMARK_(self__.cache,item);
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$hit$arity$2 = (function (_,item){
var self__ = this;
var ___$1 = this;
var tick_PLUS_ = (self__.tick + (1));
return (new cljs.cache.LRUCache(self__.cache,((cljs.core.contains_QMARK_(self__.cache,item))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.lru,item,tick_PLUS_):self__.lru),tick_PLUS_,self__.limit));
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$miss$arity$3 = (function (_,item,result){
var self__ = this;
var ___$1 = this;
var tick_PLUS_ = (self__.tick + (1));
if((cljs.core.count(self__.lru) >= self__.limit)){
var k = ((cljs.core.contains_QMARK_(self__.lru,item))?item:cljs.core.first(cljs.core.peek(self__.lru)));
var c = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.cache,k),item,result);
var l = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.lru,k),item,tick_PLUS_);
return (new cljs.cache.LRUCache(c,l,tick_PLUS_,self__.limit));
} else {
return (new cljs.cache.LRUCache(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.cache,item,result),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.lru,item,tick_PLUS_),tick_PLUS_,self__.limit));
}
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$evict$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(self__.cache,key)){
return (new cljs.cache.LRUCache(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.cache,key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.lru,key),(self__.tick + (1)),self__.limit));
} else {
return this$__$1;
}
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$seed$arity$2 = (function (_,base){
var self__ = this;
var ___$1 = this;
return (new cljs.cache.LRUCache(base,cljs.cache.build_leastness_queue(base,self__.limit,(0)),(0),self__.limit));
}));

(cljs.cache.LRUCache.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (___38857__auto__){
var self__ = this;
var ___38857__auto____$1 = this;
return self__.cache.iterator();
}));

(cljs.cache.LRUCache.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__38854__auto__,k__38858__auto__,v__38859__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$miss$arity$3(null,k__38858__auto__,v__38859__auto__);
}));

(cljs.cache.LRUCache.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__38854__auto__,k__38858__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$has_QMARK_$arity$2(null,k__38858__auto__);
}));

(cljs.cache.LRUCache.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__38854__auto__,k__38858__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$cache$CacheProtocol$evict$arity$2(null,k__38858__auto__);
}));

(cljs.cache.LRUCache.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__38854__auto__,key__38855__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
return this__38854__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,key__38855__auto__,null);
}));

(cljs.cache.LRUCache.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__38854__auto__,key__38855__auto__,not_found__38856__auto__){
var self__ = this;
var this__38854__auto____$1 = this;
if(cljs.core.truth_(this__38854__auto____$1.cljs$cache$CacheProtocol$has_QMARK_$arity$2(null,key__38855__auto__))){
return this__38854__auto____$1.cljs$cache$CacheProtocol$lookup$arity$2(null,key__38855__auto__);
} else {
return not_found__38856__auto__;
}
}));

(cljs.cache.LRUCache.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"lru","lru",-315566379,null),new cljs.core.Symbol(null,"tick","tick",804644551,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null);
}));

(cljs.cache.LRUCache.cljs$lang$type = true);

(cljs.cache.LRUCache.cljs$lang$ctorStr = "cljs.cache/LRUCache");

(cljs.cache.LRUCache.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.cache/LRUCache");
}));

/**
 * Positional factory function for cljs.cache/LRUCache.
 */
cljs.cache.__GT_LRUCache = (function cljs$cache$__GT_LRUCache(cache,lru,tick,limit){
return (new cljs.cache.LRUCache(cache,lru,tick,limit));
});

/**
 * Returns a pluggable basic cache initialied to `base`
 */
cljs.cache.basic_cache_factory = (function cljs$cache$basic_cache_factory(base){
if(cljs.core.map_QMARK_(base)){
} else {
throw (new Error("Assert failed: (map? base)"));
}

return (new cljs.cache.BasicCache(base));
});
/**
 * Returns a TTL cache with the cache and expiration-table initialied to `base` --
 * each with the same time-to-live.
 * 
 * This function also allows an optional `:ttl` argument that defines the default
 * time in milliseconds that entries are allowed to reside in the cache.
 */
cljs.cache.ttl_cache_factory = (function cljs$cache$ttl_cache_factory(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38923 = arguments.length;
var i__4865__auto___38924 = (0);
while(true){
if((i__4865__auto___38924 < len__4864__auto___38923)){
args__4870__auto__.push((arguments[i__4865__auto___38924]));

var G__38925 = (i__4865__auto___38924 + (1));
i__4865__auto___38924 = G__38925;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic = (function (base,p__38921){
var map__38922 = p__38921;
var map__38922__$1 = cljs.core.__destructure_map(map__38922);
var ttl = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38922__$1,new cljs.core.Keyword(null,"ttl","ttl",-1115275118),(2000));
if(typeof ttl === 'number'){
} else {
throw (new Error("Assert failed: (number? ttl)"));
}

if(((0) <= ttl)){
} else {
throw (new Error("Assert failed: (<= 0 ttl)"));
}

if(cljs.core.map_QMARK_(base)){
} else {
throw (new Error("Assert failed: (map? base)"));
}

return (new cljs.cache.TTLCache(cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,ttl)).cljs$cache$CacheProtocol$seed$arity$2(null,base);
}));

(cljs.cache.ttl_cache_factory.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.cache.ttl_cache_factory.cljs$lang$applyTo = (function (seq38919){
var G__38920 = cljs.core.first(seq38919);
var seq38919__$1 = cljs.core.next(seq38919);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38920,seq38919__$1);
}));

/**
 * Returns an LRU cache with the cache and usage-table initialied to `base` --
 * each entry is initialized with the same usage value.
 * This function takes an optional `:threshold` argument that defines the maximum number
 * of elements in the cache before the LRU semantics apply (default is 32).
 */
cljs.cache.lru_cache_factory = (function cljs$cache$lru_cache_factory(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38930 = arguments.length;
var i__4865__auto___38931 = (0);
while(true){
if((i__4865__auto___38931 < len__4864__auto___38930)){
args__4870__auto__.push((arguments[i__4865__auto___38931]));

var G__38932 = (i__4865__auto___38931 + (1));
i__4865__auto___38931 = G__38932;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic = (function (base,p__38928){
var map__38929 = p__38928;
var map__38929__$1 = cljs.core.__destructure_map(map__38929);
var threshold = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38929__$1,new cljs.core.Keyword(null,"threshold","threshold",204221583),(32));
if(typeof threshold === 'number'){
} else {
throw (new Error("Assert failed: (number? threshold)"));
}

if(((0) < threshold)){
} else {
throw (new Error("Assert failed: (< 0 threshold)"));
}

if(cljs.core.map_QMARK_(base)){
} else {
throw (new Error("Assert failed: (map? base)"));
}

return (new cljs.cache.LRUCache(cljs.core.PersistentArrayMap.EMPTY,tailrecursion.priority_map.priority_map(),(0),threshold)).cljs$cache$CacheProtocol$seed$arity$2(null,base);
}));

(cljs.cache.lru_cache_factory.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.cache.lru_cache_factory.cljs$lang$applyTo = (function (seq38926){
var G__38927 = cljs.core.first(seq38926);
var seq38926__$1 = cljs.core.next(seq38926);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38927,seq38926__$1);
}));

