// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('alphabase.core');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('fluree.crypto.pkcs7');
fluree.crypto.aes.encrypt_STAR_ = (function fluree$crypto$aes$encrypt_STAR_(iv,key_ba,ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var padded = fluree.crypto.pkcs7.encode((16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js(iv));
});
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__4870__auto__ = [];
var len__4864__auto___61419 = arguments.length;
var i__4865__auto___61420 = (0);
while(true){
if((i__4865__auto___61420 < len__4864__auto___61419)){
args__4870__auto__.push((arguments[i__4865__auto___61420]));

var G__61421 = (i__4865__auto___61420 + (1));
i__4865__auto___61420 = G__61421;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

(fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__61413){
var vec__61414 = p__61413;
var map__61417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61414,(0),null);
var map__61417__$1 = cljs.core.__destructure_map(map__61417);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__61417__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__61417__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"hex","hex",41691346));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes(x):x);
var encrypted = fluree.crypto.aes.encrypt_STAR_(iv,key_ba,ba);
var G__61418 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__61418__$1 = (((G__61418 instanceof cljs.core.Keyword))?G__61418.fqn:null);
switch (G__61418__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex(encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64(encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61418__$1)].join('')));

}
}));

(fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq61410){
var G__61411 = cljs.core.first(seq61410);
var seq61410__$1 = cljs.core.next(seq61410);
var G__61412 = cljs.core.first(seq61410__$1);
var seq61410__$2 = cljs.core.next(seq61410__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__61411,G__61412,seq61410__$2);
}));

fluree.crypto.aes.decrypt_STAR_ = (function fluree$crypto$aes$decrypt_STAR_(iv,key_ba,x_ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
return fluree.crypto.pkcs7.decode((16),cbc.decrypt(x_ba,cljs.core.clj__GT_js(iv)));
});
/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__4870__auto__ = [];
var len__4864__auto___61434 = arguments.length;
var i__4865__auto___61435 = (0);
while(true){
if((i__4865__auto___61435 < len__4864__auto___61434)){
args__4870__auto__.push((arguments[i__4865__auto___61435]));

var G__61436 = (i__4865__auto___61435 + (1));
i__4865__auto___61435 = G__61436;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

(fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__61427){
var vec__61428 = p__61427;
var map__61431 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61428,(0),null);
var map__61431__$1 = cljs.core.__destructure_map(map__61431);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__61431__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__61431__$1,new cljs.core.Keyword(null,"input-format","input-format",-422703481),new cljs.core.Keyword(null,"hex","hex",41691346));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__61431__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"string","string",-1989541586));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__61432 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(input_format);
var G__61432__$1 = (((G__61432 instanceof cljs.core.Keyword))?G__61432.fqn:null);
switch (G__61432__$1) {
case "hex":
return alphabase.core.hex__GT_bytes(x);

break;
case "base64":
return alphabase.core.base64__GT_bytes(x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61432__$1)].join('')));

}
})():x);
var decrypt_ba = fluree.crypto.aes.decrypt_STAR_(iv,key_ba,x_ba);
var G__61433 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__61433__$1 = (((G__61433 instanceof cljs.core.Keyword))?G__61433.fqn:null);
switch (G__61433__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex(decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string(decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61433__$1)].join('')));

}
}));

(fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq61424){
var G__61425 = cljs.core.first(seq61424);
var seq61424__$1 = cljs.core.next(seq61424);
var G__61426 = cljs.core.first(seq61424__$1);
var seq61424__$2 = cljs.core.next(seq61424__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__61425,G__61426,seq61424__$2);
}));

