// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__61624_61793 = cljs.core.seq(servers);
var chunk__61625_61794 = null;
var count__61626_61795 = (0);
var i__61627_61796 = (0);
while(true){
if((i__61627_61796 < count__61626_61795)){
var server_61797 = chunk__61625_61794.cljs$core$IIndexed$_nth$arity$2(null,i__61627_61796);
var healthcheck_uri_61798 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61797),"/fdb/health"].join('');
var resp_chan_61799 = fluree.db.util.xhttp.post_json(healthcheck_uri_61798,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2763__auto___61800 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__61624_61793,chunk__61625_61794,count__61626_61795,i__61627_61796,c__2763__auto___61800,healthcheck_uri_61798,resp_chan_61799,server_61797){
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = ((function (seq__61624_61793,chunk__61625_61794,count__61626_61795,i__61627_61796,c__2763__auto___61800,healthcheck_uri_61798,resp_chan_61799,server_61797){
return (function (state_61688){
var state_val_61689 = (state_61688[(1)]);
if((state_val_61689 === (1))){
var state_61688__$1 = state_61688;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61688__$1,(2),resp_chan_61799);
} else {
if((state_val_61689 === (2))){
var inst_61677 = (state_61688[(7)]);
var inst_61677__$1 = (state_61688[(2)]);
var inst_61678 = fluree.db.util.core.exception_QMARK_(inst_61677__$1);
var state_61688__$1 = (function (){var statearr_61690 = state_61688;
(statearr_61690[(7)] = inst_61677__$1);

return statearr_61690;
})();
if(inst_61678){
var statearr_61691_61801 = state_61688__$1;
(statearr_61691_61801[(1)] = (3));

} else {
var statearr_61692_61802 = state_61688__$1;
(statearr_61692_61802[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61689 === (3))){
var inst_61677 = (state_61688[(7)]);
var inst_61680 = cljs.core.ex_message(inst_61677);
var inst_61681 = cljs.core.ex_data(inst_61677);
var inst_61682 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_61680,inst_61681], 0));
var state_61688__$1 = state_61688;
var statearr_61693_61803 = state_61688__$1;
(statearr_61693_61803[(2)] = inst_61682);

(statearr_61693_61803[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61689 === (4))){
var inst_61684 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_61797);
var state_61688__$1 = state_61688;
var statearr_61694_61804 = state_61688__$1;
(statearr_61694_61804[(2)] = inst_61684);

(statearr_61694_61804[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61689 === (5))){
var inst_61686 = (state_61688[(2)]);
var state_61688__$1 = state_61688;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61688__$1,inst_61686);
} else {
return null;
}
}
}
}
}
});})(seq__61624_61793,chunk__61625_61794,count__61626_61795,i__61627_61796,c__2763__auto___61800,healthcheck_uri_61798,resp_chan_61799,server_61797))
;
return ((function (seq__61624_61793,chunk__61625_61794,count__61626_61795,i__61627_61796,switch__2740__auto__,c__2763__auto___61800,healthcheck_uri_61798,resp_chan_61799,server_61797){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0 = (function (){
var statearr_61695 = [null,null,null,null,null,null,null,null];
(statearr_61695[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__);

(statearr_61695[(1)] = (1));

return statearr_61695;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1 = (function (state_61688){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_61688);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61696){var ex__2744__auto__ = e61696;
var statearr_61697_61805 = state_61688;
(statearr_61697_61805[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_61688[(4)]))){
var statearr_61698_61806 = state_61688;
(statearr_61698_61806[(1)] = cljs.core.first((state_61688[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61807 = state_61688;
state_61688 = G__61807;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = function(state_61688){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1.call(this,state_61688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__;
})()
;})(seq__61624_61793,chunk__61625_61794,count__61626_61795,i__61627_61796,switch__2740__auto__,c__2763__auto___61800,healthcheck_uri_61798,resp_chan_61799,server_61797))
})();
var state__2765__auto__ = (function (){var statearr_61699 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_61699[(6)] = c__2763__auto___61800);

return statearr_61699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
});})(seq__61624_61793,chunk__61625_61794,count__61626_61795,i__61627_61796,c__2763__auto___61800,healthcheck_uri_61798,resp_chan_61799,server_61797))
);



var G__61808 = seq__61624_61793;
var G__61809 = chunk__61625_61794;
var G__61810 = count__61626_61795;
var G__61811 = (i__61627_61796 + (1));
seq__61624_61793 = G__61808;
chunk__61625_61794 = G__61809;
count__61626_61795 = G__61810;
i__61627_61796 = G__61811;
continue;
} else {
var temp__5753__auto___61812 = cljs.core.seq(seq__61624_61793);
if(temp__5753__auto___61812){
var seq__61624_61813__$1 = temp__5753__auto___61812;
if(cljs.core.chunked_seq_QMARK_(seq__61624_61813__$1)){
var c__4679__auto___61814 = cljs.core.chunk_first(seq__61624_61813__$1);
var G__61815 = cljs.core.chunk_rest(seq__61624_61813__$1);
var G__61816 = c__4679__auto___61814;
var G__61817 = cljs.core.count(c__4679__auto___61814);
var G__61818 = (0);
seq__61624_61793 = G__61815;
chunk__61625_61794 = G__61816;
count__61626_61795 = G__61817;
i__61627_61796 = G__61818;
continue;
} else {
var server_61819 = cljs.core.first(seq__61624_61813__$1);
var healthcheck_uri_61820 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61819),"/fdb/health"].join('');
var resp_chan_61821 = fluree.db.util.xhttp.post_json(healthcheck_uri_61820,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2763__auto___61822 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__61624_61793,chunk__61625_61794,count__61626_61795,i__61627_61796,c__2763__auto___61822,healthcheck_uri_61820,resp_chan_61821,server_61819,seq__61624_61813__$1,temp__5753__auto___61812){
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = ((function (seq__61624_61793,chunk__61625_61794,count__61626_61795,i__61627_61796,c__2763__auto___61822,healthcheck_uri_61820,resp_chan_61821,server_61819,seq__61624_61813__$1,temp__5753__auto___61812){
return (function (state_61712){
var state_val_61713 = (state_61712[(1)]);
if((state_val_61713 === (1))){
var state_61712__$1 = state_61712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61712__$1,(2),resp_chan_61821);
} else {
if((state_val_61713 === (2))){
var inst_61701 = (state_61712[(7)]);
var inst_61701__$1 = (state_61712[(2)]);
var inst_61702 = fluree.db.util.core.exception_QMARK_(inst_61701__$1);
var state_61712__$1 = (function (){var statearr_61714 = state_61712;
(statearr_61714[(7)] = inst_61701__$1);

return statearr_61714;
})();
if(inst_61702){
var statearr_61715_61823 = state_61712__$1;
(statearr_61715_61823[(1)] = (3));

} else {
var statearr_61716_61824 = state_61712__$1;
(statearr_61716_61824[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61713 === (3))){
var inst_61701 = (state_61712[(7)]);
var inst_61704 = cljs.core.ex_message(inst_61701);
var inst_61705 = cljs.core.ex_data(inst_61701);
var inst_61706 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_61704,inst_61705], 0));
var state_61712__$1 = state_61712;
var statearr_61717_61825 = state_61712__$1;
(statearr_61717_61825[(2)] = inst_61706);

(statearr_61717_61825[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61713 === (4))){
var inst_61708 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_61819);
var state_61712__$1 = state_61712;
var statearr_61718_61826 = state_61712__$1;
(statearr_61718_61826[(2)] = inst_61708);

(statearr_61718_61826[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61713 === (5))){
var inst_61710 = (state_61712[(2)]);
var state_61712__$1 = state_61712;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61712__$1,inst_61710);
} else {
return null;
}
}
}
}
}
});})(seq__61624_61793,chunk__61625_61794,count__61626_61795,i__61627_61796,c__2763__auto___61822,healthcheck_uri_61820,resp_chan_61821,server_61819,seq__61624_61813__$1,temp__5753__auto___61812))
;
return ((function (seq__61624_61793,chunk__61625_61794,count__61626_61795,i__61627_61796,switch__2740__auto__,c__2763__auto___61822,healthcheck_uri_61820,resp_chan_61821,server_61819,seq__61624_61813__$1,temp__5753__auto___61812){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0 = (function (){
var statearr_61719 = [null,null,null,null,null,null,null,null];
(statearr_61719[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__);

(statearr_61719[(1)] = (1));

return statearr_61719;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1 = (function (state_61712){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_61712);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61720){var ex__2744__auto__ = e61720;
var statearr_61721_61827 = state_61712;
(statearr_61721_61827[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_61712[(4)]))){
var statearr_61722_61828 = state_61712;
(statearr_61722_61828[(1)] = cljs.core.first((state_61712[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61829 = state_61712;
state_61712 = G__61829;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = function(state_61712){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1.call(this,state_61712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__;
})()
;})(seq__61624_61793,chunk__61625_61794,count__61626_61795,i__61627_61796,switch__2740__auto__,c__2763__auto___61822,healthcheck_uri_61820,resp_chan_61821,server_61819,seq__61624_61813__$1,temp__5753__auto___61812))
})();
var state__2765__auto__ = (function (){var statearr_61723 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_61723[(6)] = c__2763__auto___61822);

return statearr_61723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
});})(seq__61624_61793,chunk__61625_61794,count__61626_61795,i__61627_61796,c__2763__auto___61822,healthcheck_uri_61820,resp_chan_61821,server_61819,seq__61624_61813__$1,temp__5753__auto___61812))
);



var G__61830 = cljs.core.next(seq__61624_61813__$1);
var G__61831 = null;
var G__61832 = (0);
var G__61833 = (0);
seq__61624_61793 = G__61830;
chunk__61625_61794 = G__61831;
count__61626_61795 = G__61832;
i__61627_61796 = G__61833;
continue;
}
} else {
}
}
break;
}

var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61767){
var state_val_61768 = (state_61767[(1)]);
if((state_val_61768 === (7))){
var inst_61739 = (state_61767[(7)]);
var inst_61746 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61739,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_61767__$1 = state_61767;
if(inst_61746){
var statearr_61769_61834 = state_61767__$1;
(statearr_61769_61834[(1)] = (9));

} else {
var statearr_61770_61835 = state_61767__$1;
(statearr_61770_61835[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61768 === (1))){
var inst_61731 = (state_61767[(8)]);
var inst_61732 = (state_61767[(9)]);
var inst_61731__$1 = promise_chan;
var inst_61732__$1 = cljs.core.async.timeout((60000));
var inst_61733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61734 = [inst_61731__$1,inst_61732__$1];
var inst_61735 = (new cljs.core.PersistentVector(null,2,(5),inst_61733,inst_61734,null));
var state_61767__$1 = (function (){var statearr_61771 = state_61767;
(statearr_61771[(8)] = inst_61731__$1);

(statearr_61771[(9)] = inst_61732__$1);

return statearr_61771;
})();
return cljs.core.async.ioc_alts_BANG_(state_61767__$1,(2),inst_61735);
} else {
if((state_val_61768 === (4))){
var inst_61739 = (state_61767[(7)]);
var inst_61732 = (state_61767[(9)]);
var inst_61743 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61739,inst_61732);
var state_61767__$1 = state_61767;
if(inst_61743){
var statearr_61772_61836 = state_61767__$1;
(statearr_61772_61836[(1)] = (6));

} else {
var statearr_61773_61837 = state_61767__$1;
(statearr_61773_61837[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61768 === (13))){
var state_61767__$1 = state_61767;
var statearr_61774_61838 = state_61767__$1;
(statearr_61774_61838[(2)] = null);

(statearr_61774_61838[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61768 === (6))){
var state_61767__$1 = state_61767;
var statearr_61775_61839 = state_61767__$1;
(statearr_61775_61839[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_61775_61839[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61768 === (3))){
var state_61767__$1 = state_61767;
var statearr_61776_61840 = state_61767__$1;
(statearr_61776_61840[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_61776_61840[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61768 === (12))){
var inst_61757 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_61758 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61759 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_61760 = cljs.core.PersistentHashMap.fromArrays(inst_61758,inst_61759);
var inst_61761 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_61760);
var inst_61762 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_61761);
var state_61767__$1 = (function (){var statearr_61777 = state_61767;
(statearr_61777[(10)] = inst_61757);

return statearr_61777;
})();
var statearr_61778_61841 = state_61767__$1;
(statearr_61778_61841[(2)] = inst_61762);

(statearr_61778_61841[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61768 === (2))){
var inst_61731 = (state_61767[(8)]);
var inst_61739 = (state_61767[(7)]);
var inst_61737 = (state_61767[(2)]);
var inst_61738 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61737,(0),null);
var inst_61739__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61737,(1),null);
var inst_61740 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61739__$1,inst_61731);
var state_61767__$1 = (function (){var statearr_61779 = state_61767;
(statearr_61779[(7)] = inst_61739__$1);

(statearr_61779[(11)] = inst_61738);

return statearr_61779;
})();
if(inst_61740){
var statearr_61780_61842 = state_61767__$1;
(statearr_61780_61842[(1)] = (3));

} else {
var statearr_61781_61843 = state_61767__$1;
(statearr_61781_61843[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61768 === (11))){
var inst_61750 = (state_61767[(2)]);
var state_61767__$1 = state_61767;
var statearr_61782_61844 = state_61767__$1;
(statearr_61782_61844[(2)] = inst_61750);

(statearr_61782_61844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61768 === (9))){
var inst_61738 = (state_61767[(11)]);
var state_61767__$1 = state_61767;
var statearr_61783_61845 = state_61767__$1;
(statearr_61783_61845[(2)] = inst_61738);

(statearr_61783_61845[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61768 === (5))){
var inst_61754 = (state_61767[(2)]);
var inst_61755 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_61754);
var state_61767__$1 = state_61767;
if(inst_61755){
var statearr_61784_61846 = state_61767__$1;
(statearr_61784_61846[(1)] = (12));

} else {
var statearr_61785_61847 = state_61767__$1;
(statearr_61785_61847[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61768 === (14))){
var inst_61765 = (state_61767[(2)]);
var state_61767__$1 = state_61767;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61767__$1,inst_61765);
} else {
if((state_val_61768 === (10))){
var state_61767__$1 = state_61767;
var statearr_61786_61848 = state_61767__$1;
(statearr_61786_61848[(2)] = null);

(statearr_61786_61848[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61768 === (8))){
var inst_61752 = (state_61767[(2)]);
var state_61767__$1 = state_61767;
var statearr_61787_61849 = state_61767__$1;
(statearr_61787_61849[(2)] = inst_61752);

(statearr_61787_61849[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0 = (function (){
var statearr_61788 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61788[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__);

(statearr_61788[(1)] = (1));

return statearr_61788;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1 = (function (state_61767){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_61767);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61789){var ex__2744__auto__ = e61789;
var statearr_61790_61850 = state_61767;
(statearr_61790_61850[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_61767[(4)]))){
var statearr_61791_61851 = state_61767;
(statearr_61791_61851[(1)] = cljs.core.first((state_61767[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61852 = state_61767;
state_61767 = G__61852;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = function(state_61767){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1.call(this,state_61767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61792 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_61792[(6)] = c__2763__auto__);

return statearr_61792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61896){
var state_val_61897 = (state_61896[(1)]);
if((state_val_61897 === (7))){
var state_61896__$1 = state_61896;
var statearr_61898_61924 = state_61896__$1;
(statearr_61898_61924[(2)] = null);

(statearr_61898_61924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61897 === (1))){
var state_61896__$1 = state_61896;
var statearr_61899_61925 = state_61896__$1;
(statearr_61899_61925[(2)] = null);

(statearr_61899_61925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61897 === (4))){
var inst_61853 = (state_61896[(2)]);
var state_61896__$1 = state_61896;
var statearr_61900_61926 = state_61896__$1;
(statearr_61900_61926[(2)] = inst_61853);

(statearr_61900_61926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61897 === (6))){
var inst_61875 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_61896__$1 = state_61896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61896__$1,(9),inst_61875);
} else {
if((state_val_61897 === (3))){
var inst_61894 = (state_61896[(2)]);
var state_61896__$1 = state_61896;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61896__$1,inst_61894);
} else {
if((state_val_61897 === (12))){
var inst_61888 = (state_61896[(2)]);
var state_61896__$1 = state_61896;
var statearr_61901_61927 = state_61896__$1;
(statearr_61901_61927[(2)] = inst_61888);

(statearr_61901_61927[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61897 === (2))){
var inst_61859 = (state_61896[(7)]);
var inst_61864 = (state_61896[(8)]);
var inst_61869 = (state_61896[(9)]);
var _ = (function (){var statearr_61902 = state_61896;
(statearr_61902[(4)] = cljs.core.cons((5),(state_61896[(4)])));

return statearr_61902;
})();
var inst_61859__$1 = fluree.db.util.core.random_uuid();
var inst_61860 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61861 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_61862 = (new cljs.core.PersistentVector(null,2,(5),inst_61860,inst_61861,null));
var inst_61863 = (function (){var lock_id = inst_61859__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_61864__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_61862,inst_61863);
var inst_61865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61866 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_61867 = (new cljs.core.PersistentVector(null,3,(5),inst_61865,inst_61866,null));
var inst_61868 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61864__$1,inst_61867);
var inst_61869__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61859__$1,inst_61868);
var inst_61870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61871 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61872 = (new cljs.core.PersistentVector(null,3,(5),inst_61870,inst_61871,null));
var inst_61873 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61864__$1,inst_61872);
var state_61896__$1 = (function (){var statearr_61903 = state_61896;
(statearr_61903[(10)] = inst_61873);

(statearr_61903[(7)] = inst_61859__$1);

(statearr_61903[(8)] = inst_61864__$1);

(statearr_61903[(9)] = inst_61869__$1);

return statearr_61903;
})();
if(inst_61869__$1){
var statearr_61904_61928 = state_61896__$1;
(statearr_61904_61928[(1)] = (6));

} else {
var statearr_61905_61929 = state_61896__$1;
(statearr_61905_61929[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61897 === (11))){
var inst_61873 = (state_61896[(10)]);
var inst_61879 = (state_61896[(11)]);
var inst_61880 = (state_61896[(12)]);
var inst_61886 = fluree.db.util.xhttp.try_socket(inst_61879,sub_chan,pub_chan,inst_61873,(60000),inst_61880);
var state_61896__$1 = state_61896;
var statearr_61907_61930 = state_61896__$1;
(statearr_61907_61930[(2)] = inst_61886);

(statearr_61907_61930[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61897 === (9))){
var inst_61873 = (state_61896[(10)]);
var inst_61879 = (state_61896[(11)]);
var inst_61859 = (state_61896[(7)]);
var inst_61864 = (state_61896[(8)]);
var inst_61869 = (state_61896[(9)]);
var inst_61877 = (state_61896[(13)]);
var inst_61877__$1 = (state_61896[(2)]);
var inst_61878 = clojure.string.replace(inst_61877__$1,"http","ws");
var inst_61879__$1 = [inst_61878,"/fdb/ws"].join('');
var inst_61880 = (function (){var lock_id = inst_61859;
var state = inst_61864;
var have_lock_QMARK_ = inst_61869;
var resp_chan = inst_61873;
var healthy_server = inst_61877__$1;
var ws_url = inst_61879__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_61881 = fluree.db.util.core.exception_QMARK_(inst_61877__$1);
var state_61896__$1 = (function (){var statearr_61908 = state_61896;
(statearr_61908[(11)] = inst_61879__$1);

(statearr_61908[(12)] = inst_61880);

(statearr_61908[(13)] = inst_61877__$1);

return statearr_61908;
})();
if(inst_61881){
var statearr_61909_61931 = state_61896__$1;
(statearr_61909_61931[(1)] = (10));

} else {
var statearr_61910_61932 = state_61896__$1;
(statearr_61910_61932[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61897 === (5))){
var _ = (function (){var statearr_61911 = state_61896;
(statearr_61911[(4)] = cljs.core.rest((state_61896[(4)])));

return statearr_61911;
})();
var state_61896__$1 = state_61896;
var ex61906 = (state_61896__$1[(2)]);
var statearr_61912_61933 = state_61896__$1;
(statearr_61912_61933[(5)] = ex61906);


if((ex61906 instanceof Error)){
var statearr_61913_61934 = state_61896__$1;
(statearr_61913_61934[(1)] = (4));

(statearr_61913_61934[(5)] = null);

} else {
throw ex61906;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61897 === (10))){
var inst_61873 = (state_61896[(10)]);
var inst_61877 = (state_61896[(13)]);
var inst_61883 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_61884 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_61873,inst_61877);
var state_61896__$1 = (function (){var statearr_61914 = state_61896;
(statearr_61914[(14)] = inst_61883);

return statearr_61914;
})();
var statearr_61915_61935 = state_61896__$1;
(statearr_61915_61935[(2)] = inst_61884);

(statearr_61915_61935[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61897 === (8))){
var inst_61873 = (state_61896[(10)]);
var inst_61891 = (state_61896[(2)]);
var _ = (function (){var statearr_61916 = state_61896;
(statearr_61916[(4)] = cljs.core.rest((state_61896[(4)])));

return statearr_61916;
})();
var state_61896__$1 = (function (){var statearr_61917 = state_61896;
(statearr_61917[(15)] = inst_61891);

return statearr_61917;
})();
var statearr_61918_61936 = state_61896__$1;
(statearr_61918_61936[(2)] = inst_61873);

(statearr_61918_61936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2741__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2741__auto____0 = (function (){
var statearr_61919 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61919[(0)] = fluree$db$connection$establish_socket_$_state_machine__2741__auto__);

(statearr_61919[(1)] = (1));

return statearr_61919;
});
var fluree$db$connection$establish_socket_$_state_machine__2741__auto____1 = (function (state_61896){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_61896);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61920){var ex__2744__auto__ = e61920;
var statearr_61921_61937 = state_61896;
(statearr_61921_61937[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_61896[(4)]))){
var statearr_61922_61938 = state_61896;
(statearr_61922_61938[(1)] = cljs.core.first((state_61896[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61939 = state_61896;
state_61896 = G__61939;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2741__auto__ = function(state_61896){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2741__auto____1.call(this,state_61896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2741__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2741__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61923 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_61923[(6)] = c__2763__auto__);

return statearr_61923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k61941,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__61945 = k61941;
var G__61945__$1 = (((G__61945 instanceof cljs.core.Keyword))?G__61945.fqn:null);
switch (G__61945__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k61941,else__4505__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__61946){
var vec__61947 = p__61946;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61947,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61947,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__61940){
var self__ = this;
var G__61940__$1 = this;
return (new cljs.core.RecordIter((0),G__61940__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (22 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__61950 = (function (coll__4499__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__61950(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this61942,other61943){
var self__ = this;
var this61942__$1 = this;
return (((!((other61943 == null)))) && ((((this61942__$1.constructor === other61943.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.id,other61943.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.servers,other61943.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.state,other61943.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.req_chan,other61943.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.sub_chan,other61943.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.pub_chan,other61943.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.group,other61943.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.storage_read,other61943.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.storage_write,other61943.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.object_cache,other61943.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.parallelism,other61943.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.serializer,other61943.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.default_network,other61943.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.transactor_QMARK_,other61943.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.publish,other61943.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.transact_handler,other61943.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.tx_private_key,other61943.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.tx_key_id,other61943.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.meta,other61943.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.add_listener,other61943.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.remove_listener,other61943.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.close,other61943.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61942__$1.__extmap,other61943.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k61941){
var self__ = this;
var this__4509__auto____$1 = this;
var G__61951 = k61941;
var G__61951__$1 = (((G__61951 instanceof cljs.core.Keyword))?G__61951.fqn:null);
switch (G__61951__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k61941);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__61940){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__61952 = cljs.core.keyword_identical_QMARK_;
var expr__61953 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__61955 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__61956 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61955,G__61956) : pred__61952.call(null,G__61955,G__61956));
})())){
return (new fluree.db.connection.Connection(G__61940,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61957 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__61958 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61957,G__61958) : pred__61952.call(null,G__61957,G__61958));
})())){
return (new fluree.db.connection.Connection(self__.id,G__61940,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61959 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__61960 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61959,G__61960) : pred__61952.call(null,G__61959,G__61960));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__61940,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61961 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__61962 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61961,G__61962) : pred__61952.call(null,G__61961,G__61962));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__61940,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61963 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__61964 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61963,G__61964) : pred__61952.call(null,G__61963,G__61964));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__61940,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61965 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__61966 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61965,G__61966) : pred__61952.call(null,G__61965,G__61966));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__61940,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61967 = new cljs.core.Keyword(null,"group","group",582596132);
var G__61968 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61967,G__61968) : pred__61952.call(null,G__61967,G__61968));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__61940,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61969 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__61970 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61969,G__61970) : pred__61952.call(null,G__61969,G__61970));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__61940,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61971 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__61972 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61971,G__61972) : pred__61952.call(null,G__61971,G__61972));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__61940,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61973 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__61974 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61973,G__61974) : pred__61952.call(null,G__61973,G__61974));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__61940,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61975 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__61976 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61975,G__61976) : pred__61952.call(null,G__61975,G__61976));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__61940,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61977 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__61978 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61977,G__61978) : pred__61952.call(null,G__61977,G__61978));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__61940,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61979 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__61980 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61979,G__61980) : pred__61952.call(null,G__61979,G__61980));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__61940,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61981 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__61982 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61981,G__61982) : pred__61952.call(null,G__61981,G__61982));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__61940,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61983 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__61984 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61983,G__61984) : pred__61952.call(null,G__61983,G__61984));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__61940,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61985 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__61986 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61985,G__61986) : pred__61952.call(null,G__61985,G__61986));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__61940,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61987 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__61988 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61987,G__61988) : pred__61952.call(null,G__61987,G__61988));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__61940,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61989 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__61990 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61989,G__61990) : pred__61952.call(null,G__61989,G__61990));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__61940,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61991 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__61992 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61991,G__61992) : pred__61952.call(null,G__61991,G__61992));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__61940,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61993 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__61994 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61993,G__61994) : pred__61952.call(null,G__61993,G__61994));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__61940,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61995 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__61996 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61995,G__61996) : pred__61952.call(null,G__61995,G__61996));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__61940,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61997 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__61998 = expr__61953;
return (pred__61952.cljs$core$IFn$_invoke$arity$2 ? pred__61952.cljs$core$IFn$_invoke$arity$2(G__61997,G__61998) : pred__61952.call(null,G__61997,G__61998));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__61940,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__61940),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__61940){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__61940,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__61944){
var extmap__4542__auto__ = (function (){var G__61999 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__61944,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__61944)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__61999);
} else {
return G__61999;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__61944),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__61944),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__62005 = servers_STAR_;
var vec__62006 = G__62005;
var seq__62007 = cljs.core.seq(vec__62006);
var first__62008 = cljs.core.first(seq__62007);
var seq__62007__$1 = cljs.core.next(seq__62007);
var server = first__62008;
var r = seq__62007__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__62005__$1 = G__62005;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__62012 = G__62005__$1;
var seq__62013 = cljs.core.seq(vec__62012);
var first__62014 = cljs.core.first(seq__62013);
var seq__62013__$1 = cljs.core.next(seq__62013);
var server__$1 = first__62014;
var r__$1 = seq__62013__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__62015 = r__$1;
var G__62016 = is_https_QMARK_;
var G__62017 = result_STAR_;
G__62005__$1 = G__62015;
https_QMARK___$1 = G__62016;
result__$1 = G__62017;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__62018 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__62018 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__62018);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62047){
var state_val_62048 = (state_62047[(1)]);
if((state_val_62048 === (7))){
var inst_62033 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62034 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62035 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62036 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62037 = fluree.db.connection.establish_socket(inst_62033,inst_62034,inst_62035,inst_62036);
var state_62047__$1 = state_62047;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62047__$1,(9),inst_62037);
} else {
if((state_val_62048 === (1))){
var state_62047__$1 = state_62047;
var statearr_62049_62068 = state_62047__$1;
(statearr_62049_62068[(2)] = null);

(statearr_62049_62068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62048 === (4))){
var inst_62019 = (state_62047[(2)]);
var state_62047__$1 = state_62047;
var statearr_62050_62069 = state_62047__$1;
(statearr_62050_62069[(2)] = inst_62019);

(statearr_62050_62069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62048 === (6))){
var inst_62030 = (state_62047[(7)]);
var state_62047__$1 = state_62047;
var statearr_62051_62070 = state_62047__$1;
(statearr_62051_62070[(2)] = inst_62030);

(statearr_62051_62070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62048 === (3))){
var inst_62045 = (state_62047[(2)]);
var state_62047__$1 = state_62047;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62047__$1,inst_62045);
} else {
if((state_val_62048 === (2))){
var inst_62030 = (state_62047[(7)]);
var _ = (function (){var statearr_62053 = state_62047;
(statearr_62053[(4)] = cljs.core.cons((5),(state_62047[(4)])));

return statearr_62053;
})();
var inst_62025 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62027 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62028 = [inst_62027,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62029 = (new cljs.core.PersistentVector(null,3,(5),inst_62026,inst_62028,null));
var inst_62030__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62025,inst_62029);
var state_62047__$1 = (function (){var statearr_62054 = state_62047;
(statearr_62054[(7)] = inst_62030__$1);

return statearr_62054;
})();
if(cljs.core.truth_(inst_62030__$1)){
var statearr_62055_62071 = state_62047__$1;
(statearr_62055_62071[(1)] = (6));

} else {
var statearr_62056_62072 = state_62047__$1;
(statearr_62056_62072[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62048 === (9))){
var inst_62039 = (state_62047[(2)]);
var inst_62040 = fluree.db.util.async.throw_err(inst_62039);
var state_62047__$1 = state_62047;
var statearr_62057_62073 = state_62047__$1;
(statearr_62057_62073[(2)] = inst_62040);

(statearr_62057_62073[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62048 === (5))){
var _ = (function (){var statearr_62058 = state_62047;
(statearr_62058[(4)] = cljs.core.rest((state_62047[(4)])));

return statearr_62058;
})();
var state_62047__$1 = state_62047;
var ex62052 = (state_62047__$1[(2)]);
var statearr_62059_62074 = state_62047__$1;
(statearr_62059_62074[(5)] = ex62052);


if((ex62052 instanceof Error)){
var statearr_62060_62075 = state_62047__$1;
(statearr_62060_62075[(1)] = (4));

(statearr_62060_62075[(5)] = null);

} else {
throw ex62052;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62048 === (8))){
var inst_62042 = (state_62047[(2)]);
var _ = (function (){var statearr_62061 = state_62047;
(statearr_62061[(4)] = cljs.core.rest((state_62047[(4)])));

return statearr_62061;
})();
var state_62047__$1 = state_62047;
var statearr_62062_62076 = state_62047__$1;
(statearr_62062_62076[(2)] = inst_62042);

(statearr_62062_62076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2741__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2741__auto____0 = (function (){
var statearr_62063 = [null,null,null,null,null,null,null,null];
(statearr_62063[(0)] = fluree$db$connection$get_socket_$_state_machine__2741__auto__);

(statearr_62063[(1)] = (1));

return statearr_62063;
});
var fluree$db$connection$get_socket_$_state_machine__2741__auto____1 = (function (state_62047){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62047);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62064){var ex__2744__auto__ = e62064;
var statearr_62065_62077 = state_62047;
(statearr_62065_62077[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62047[(4)]))){
var statearr_62066_62078 = state_62047;
(statearr_62066_62078[(1)] = cljs.core.first((state_62047[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62079 = state_62047;
state_62047 = G__62079;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2741__auto__ = function(state_62047){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2741__auto____1.call(this,state_62047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2741__auto____0;
fluree$db$connection$get_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2741__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62067 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62067[(6)] = c__2763__auto__);

return statearr_62067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e62080){var e = e62080;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62207){
var state_val_62208 = (state_62207[(1)]);
if((state_val_62208 === (7))){
var inst_62203 = (state_62207[(2)]);
var state_62207__$1 = state_62207;
var statearr_62210_62280 = state_62207__$1;
(statearr_62210_62280[(2)] = inst_62203);

(statearr_62210_62280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (20))){
var _ = (function (){var statearr_62211 = state_62207;
(statearr_62211[(4)] = cljs.core.rest((state_62207[(4)])));

return statearr_62211;
})();
var state_62207__$1 = state_62207;
var ex62209 = (state_62207__$1[(2)]);
var statearr_62212_62281 = state_62207__$1;
(statearr_62212_62281[(5)] = ex62209);


var statearr_62213_62282 = state_62207__$1;
(statearr_62213_62282[(1)] = (10));

(statearr_62213_62282[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (27))){
var inst_62195 = (state_62207[(2)]);
var _ = (function (){var statearr_62214 = state_62207;
(statearr_62214[(4)] = cljs.core.rest((state_62207[(4)])));

return statearr_62214;
})();
var state_62207__$1 = state_62207;
var statearr_62215_62283 = state_62207__$1;
(statearr_62215_62283[(2)] = inst_62195);

(statearr_62215_62283[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (1))){
var inst_62082 = (0);
var state_62207__$1 = (function (){var statearr_62216 = state_62207;
(statearr_62216[(7)] = inst_62082);

return statearr_62216;
})();
var statearr_62217_62284 = state_62207__$1;
(statearr_62217_62284[(2)] = null);

(statearr_62217_62284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (24))){
var inst_62173 = (state_62207[(8)]);
var inst_62173__$1 = (state_62207[(2)]);
var inst_62174 = inst_62173__$1 === true;
var state_62207__$1 = (function (){var statearr_62218 = state_62207;
(statearr_62218[(8)] = inst_62173__$1);

return statearr_62218;
})();
if(cljs.core.truth_(inst_62174)){
var statearr_62219_62285 = state_62207__$1;
(statearr_62219_62285[(1)] = (25));

} else {
var statearr_62220_62286 = state_62207__$1;
(statearr_62220_62286[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (4))){
var inst_62085 = (state_62207[(9)]);
var inst_62085__$1 = (state_62207[(2)]);
var state_62207__$1 = (function (){var statearr_62221 = state_62207;
(statearr_62221[(9)] = inst_62085__$1);

return statearr_62221;
})();
if(cljs.core.truth_(inst_62085__$1)){
var statearr_62222_62287 = state_62207__$1;
(statearr_62222_62287[(1)] = (5));

} else {
var statearr_62223_62288 = state_62207__$1;
(statearr_62223_62288[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (15))){
var inst_62098 = (state_62207[(10)]);
var state_62207__$1 = state_62207;
var statearr_62224_62289 = state_62207__$1;
(statearr_62224_62289[(2)] = inst_62098);

(statearr_62224_62289[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (21))){
var inst_62125 = (state_62207[(11)]);
var inst_62123 = (state_62207[(12)]);
var inst_62085 = (state_62207[(9)]);
var inst_62129 = (state_62207[(13)]);
var inst_62122 = (state_62207[(14)]);
var inst_62121 = (state_62207[(15)]);
var inst_62124 = (state_62207[(16)]);
var inst_62126 = (state_62207[(17)]);
var inst_62130 = (state_62207[(18)]);
var inst_62082 = (state_62207[(7)]);
var inst_62132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62133 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62129];
var inst_62134 = (new cljs.core.PersistentVector(null,2,(5),inst_62132,inst_62133,null));
var inst_62135 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_62134,inst_62124);
var inst_62162 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_62163 = (function (){var resp_chan = inst_62124;
var timeout = inst_62130;
var i = inst_62082;
var data = inst_62123;
var vec__62117 = inst_62085;
var _ = inst_62121;
var req_id = inst_62129;
var operation = inst_62122;
var map__62120 = inst_62126;
var msg = inst_62085;
var c__2763__auto____$1 = inst_62162;
var opts = inst_62125;
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62160){
var state_val_62161 = (state_62160[(1)]);
if((state_val_62161 === (1))){
var inst_62139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62140 = cljs.core.async.timeout(timeout);
var inst_62141 = [resp_chan,inst_62140];
var inst_62142 = (new cljs.core.PersistentVector(null,2,(5),inst_62139,inst_62141,null));
var state_62160__$1 = state_62160;
return cljs.core.async.ioc_alts_BANG_(state_62160__$1,(2),inst_62142);
} else {
if((state_val_62161 === (2))){
var inst_62145 = (state_62160[(7)]);
var inst_62144 = (state_62160[(2)]);
var inst_62145__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62144,(0),null);
var inst_62146 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62144,(1),null);
var inst_62147 = (function (){var vec__62136 = inst_62144;
var resp = inst_62145__$1;
var c = inst_62146;
return (function (p1__62081_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__62081_SHARP_,req_id);
});
})();
var inst_62148 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62147);
var inst_62149 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62146,resp_chan);
var state_62160__$1 = (function (){var statearr_62225 = state_62160;
(statearr_62225[(7)] = inst_62145__$1);

(statearr_62225[(8)] = inst_62148);

return statearr_62225;
})();
if(inst_62149){
var statearr_62226_62290 = state_62160__$1;
(statearr_62226_62290[(1)] = (3));

} else {
var statearr_62227_62291 = state_62160__$1;
(statearr_62227_62291[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62161 === (3))){
var inst_62145 = (state_62160[(7)]);
var state_62160__$1 = state_62160;
var statearr_62228_62292 = state_62160__$1;
(statearr_62228_62292[(2)] = inst_62145);

(statearr_62228_62292[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62161 === (4))){
var inst_62152 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_62153 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62154 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_62155 = cljs.core.PersistentHashMap.fromArrays(inst_62153,inst_62154);
var inst_62156 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_62152,inst_62155);
var state_62160__$1 = state_62160;
var statearr_62229_62293 = state_62160__$1;
(statearr_62229_62293[(2)] = inst_62156);

(statearr_62229_62293[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62161 === (5))){
var inst_62158 = (state_62160[(2)]);
var state_62160__$1 = state_62160;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62160__$1,inst_62158);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2741__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2741__auto____0 = (function (){
var statearr_62230 = [null,null,null,null,null,null,null,null,null];
(statearr_62230[(0)] = fluree$db$connection$msg_producer_$_state_machine__2741__auto__);

(statearr_62230[(1)] = (1));

return statearr_62230;
});
var fluree$db$connection$msg_producer_$_state_machine__2741__auto____1 = (function (state_62160){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62160);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62231){var ex__2744__auto__ = e62231;
var statearr_62232_62294 = state_62160;
(statearr_62232_62294[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62160[(4)]))){
var statearr_62233_62295 = state_62160;
(statearr_62233_62295[(1)] = cljs.core.first((state_62160[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62296 = state_62160;
state_62160 = G__62296;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2741__auto__ = function(state_62160){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2741__auto____1.call(this,state_62160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2741__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2741__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62234 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62234[(6)] = c__2763__auto____$1);

return statearr_62234;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
});
})();
var inst_62164 = cljs.core.async.impl.dispatch.run(inst_62163);
var state_62207__$1 = (function (){var statearr_62235 = state_62207;
(statearr_62235[(19)] = inst_62164);

(statearr_62235[(20)] = inst_62135);

return statearr_62235;
})();
var statearr_62236_62297 = state_62207__$1;
(statearr_62236_62297[(2)] = inst_62162);

(statearr_62236_62297[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (31))){
var inst_62183 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_62207__$1 = state_62207;
var statearr_62237_62298 = state_62207__$1;
(statearr_62237_62298[(2)] = inst_62183);

(statearr_62237_62298[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (32))){
var state_62207__$1 = state_62207;
var statearr_62238_62299 = state_62207__$1;
(statearr_62238_62299[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (33))){
var inst_62191 = (state_62207[(2)]);
var state_62207__$1 = state_62207;
var statearr_62240_62300 = state_62207__$1;
(statearr_62240_62300[(2)] = inst_62191);

(statearr_62240_62300[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (13))){
var inst_62098 = (state_62207[(10)]);
var inst_62095 = (state_62207[(2)]);
var inst_62096 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62095,(0),null);
var inst_62097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62095,(1),null);
var inst_62098__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62095,(2),null);
var state_62207__$1 = (function (){var statearr_62241 = state_62207;
(statearr_62241[(10)] = inst_62098__$1);

(statearr_62241[(21)] = inst_62096);

(statearr_62241[(22)] = inst_62097);

return statearr_62241;
})();
if(cljs.core.truth_(inst_62098__$1)){
var statearr_62242_62301 = state_62207__$1;
(statearr_62242_62301[(1)] = (14));

} else {
var statearr_62243_62302 = state_62207__$1;
(statearr_62243_62302[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (22))){
var state_62207__$1 = state_62207;
var statearr_62244_62303 = state_62207__$1;
(statearr_62244_62303[(2)] = null);

(statearr_62244_62303[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (36))){
var inst_62189 = (state_62207[(2)]);
var state_62207__$1 = state_62207;
var statearr_62245_62304 = state_62207__$1;
(statearr_62245_62304[(2)] = inst_62189);

(statearr_62245_62304[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (29))){
var inst_62173 = (state_62207[(8)]);
var inst_62181 = (inst_62173 == null);
var state_62207__$1 = state_62207;
if(cljs.core.truth_(inst_62181)){
var statearr_62246_62305 = state_62207__$1;
(statearr_62246_62305[(1)] = (31));

} else {
var statearr_62247_62306 = state_62207__$1;
(statearr_62247_62306[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (6))){
var state_62207__$1 = state_62207;
var statearr_62248_62307 = state_62207__$1;
(statearr_62248_62307[(2)] = null);

(statearr_62248_62307[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (28))){
var inst_62173 = (state_62207[(8)]);
var inst_62179 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62173,"Error processing message in producer."], 0));
var state_62207__$1 = state_62207;
var statearr_62249_62308 = state_62207__$1;
(statearr_62249_62308[(2)] = inst_62179);

(statearr_62249_62308[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (25))){
var state_62207__$1 = state_62207;
var statearr_62250_62309 = state_62207__$1;
(statearr_62250_62309[(2)] = null);

(statearr_62250_62309[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (34))){
var inst_62173 = (state_62207[(8)]);
var inst_62186 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_62173], 0));
var state_62207__$1 = state_62207;
var statearr_62251_62310 = state_62207__$1;
(statearr_62251_62310[(2)] = inst_62186);

(statearr_62251_62310[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (17))){
var inst_62087 = (state_62207[(23)]);
var inst_62098 = (state_62207[(10)]);
var inst_62105 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62098,inst_62087);
var state_62207__$1 = state_62207;
var statearr_62252_62311 = state_62207__$1;
(statearr_62252_62311[(2)] = inst_62105);

(statearr_62252_62311[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (3))){
var inst_62205 = (state_62207[(2)]);
var state_62207__$1 = state_62207;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62207__$1,inst_62205);
} else {
if((state_val_62208 === (12))){
var state_62207__$1 = state_62207;
var statearr_62253_62312 = state_62207__$1;
(statearr_62253_62312[(2)] = null);

(statearr_62253_62312[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (2))){
var state_62207__$1 = state_62207;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62207__$1,(4),req_chan);
} else {
if((state_val_62208 === (23))){
var inst_62123 = (state_62207[(12)]);
var inst_62129 = (state_62207[(13)]);
var inst_62122 = (state_62207[(14)]);
var inst_62167 = (state_62207[(2)]);
var inst_62168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62169 = [inst_62122,inst_62129,inst_62123];
var inst_62170 = (new cljs.core.PersistentVector(null,3,(5),inst_62168,inst_62169,null));
var inst_62171 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_62170) : publish_fn.call(null,conn,inst_62170));
var state_62207__$1 = (function (){var statearr_62254 = state_62207;
(statearr_62254[(24)] = inst_62167);

return statearr_62254;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62207__$1,(24),inst_62171);
} else {
if((state_val_62208 === (35))){
var state_62207__$1 = state_62207;
var statearr_62255_62313 = state_62207__$1;
(statearr_62255_62313[(2)] = null);

(statearr_62255_62313[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (19))){
var inst_62111 = (state_62207[(2)]);
var state_62207__$1 = state_62207;
var statearr_62256_62314 = state_62207__$1;
(statearr_62256_62314[(2)] = inst_62111);

(statearr_62256_62314[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (11))){
var inst_62085 = (state_62207[(9)]);
var state_62207__$1 = state_62207;
var statearr_62257_62315 = state_62207__$1;
(statearr_62257_62315[(2)] = inst_62085);

(statearr_62257_62315[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (9))){
var inst_62082 = (state_62207[(7)]);
var inst_62198 = (state_62207[(2)]);
var inst_62199 = (inst_62082 + (1));
var inst_62082__$1 = inst_62199;
var state_62207__$1 = (function (){var statearr_62258 = state_62207;
(statearr_62258[(7)] = inst_62082__$1);

(statearr_62258[(25)] = inst_62198);

return statearr_62258;
})();
var statearr_62259_62316 = state_62207__$1;
(statearr_62259_62316[(2)] = null);

(statearr_62259_62316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (5))){
var state_62207__$1 = state_62207;
var statearr_62260_62317 = state_62207__$1;
(statearr_62260_62317[(2)] = null);

(statearr_62260_62317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (14))){
var inst_62098 = (state_62207[(10)]);
var inst_62100 = fluree.db.util.async.channel_QMARK_(inst_62098);
var state_62207__$1 = state_62207;
var statearr_62261_62318 = state_62207__$1;
(statearr_62261_62318[(2)] = inst_62100);

(statearr_62261_62318[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (26))){
var inst_62173 = (state_62207[(8)]);
var inst_62177 = fluree.db.util.core.exception_QMARK_(inst_62173);
var state_62207__$1 = state_62207;
if(inst_62177){
var statearr_62262_62319 = state_62207__$1;
(statearr_62262_62319[(1)] = (28));

} else {
var statearr_62263_62320 = state_62207__$1;
(statearr_62263_62320[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (16))){
var inst_62103 = (state_62207[(2)]);
var state_62207__$1 = state_62207;
if(cljs.core.truth_(inst_62103)){
var statearr_62264_62321 = state_62207__$1;
(statearr_62264_62321[(1)] = (17));

} else {
var statearr_62265_62322 = state_62207__$1;
(statearr_62265_62322[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (30))){
var inst_62193 = (state_62207[(2)]);
var state_62207__$1 = state_62207;
var statearr_62266_62323 = state_62207__$1;
(statearr_62266_62323[(2)] = inst_62193);

(statearr_62266_62323[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (10))){
var inst_62085 = (state_62207[(9)]);
var inst_62087 = (state_62207[(2)]);
var inst_62091 = cljs.core.sequential_QMARK_(inst_62085);
var state_62207__$1 = (function (){var statearr_62267 = state_62207;
(statearr_62267[(23)] = inst_62087);

return statearr_62267;
})();
if(inst_62091){
var statearr_62268_62324 = state_62207__$1;
(statearr_62268_62324[(1)] = (11));

} else {
var statearr_62269_62325 = state_62207__$1;
(statearr_62269_62325[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (18))){
var inst_62087 = (state_62207[(23)]);
var inst_62085 = (state_62207[(9)]);
var inst_62107 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62085], 0));
var inst_62108 = ["Error processing ledger request, no valid return channel: ",inst_62107].join('');
var inst_62109 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62087,inst_62108], 0));
var state_62207__$1 = state_62207;
var statearr_62270_62326 = state_62207__$1;
(statearr_62270_62326[(2)] = inst_62109);

(statearr_62270_62326[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62208 === (8))){
var inst_62125 = (state_62207[(11)]);
var inst_62085 = (state_62207[(9)]);
var inst_62124 = (state_62207[(16)]);
var inst_62126 = (state_62207[(17)]);
var _ = (function (){var statearr_62271 = state_62207;
(statearr_62271[(4)] = cljs.core.cons((20),(state_62207[(4)])));

return statearr_62271;
})();
var inst_62121 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_62085], 0));
var inst_62122 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62085,(0),null);
var inst_62123 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62085,(1),null);
var inst_62124__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62085,(2),null);
var inst_62125__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62085,(3),null);
var inst_62126__$1 = cljs.core.__destructure_map(inst_62125__$1);
var inst_62127 = fluree.db.util.core.random_uuid();
var inst_62128 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62127);
var inst_62129 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62126__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_62128);
var inst_62130 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62126__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_62207__$1 = (function (){var statearr_62272 = state_62207;
(statearr_62272[(11)] = inst_62125__$1);

(statearr_62272[(12)] = inst_62123);

(statearr_62272[(13)] = inst_62129);

(statearr_62272[(14)] = inst_62122);

(statearr_62272[(15)] = inst_62121);

(statearr_62272[(16)] = inst_62124__$1);

(statearr_62272[(17)] = inst_62126__$1);

(statearr_62272[(18)] = inst_62130);

return statearr_62272;
})();
if(cljs.core.truth_(inst_62124__$1)){
var statearr_62273_62327 = state_62207__$1;
(statearr_62273_62327[(1)] = (21));

} else {
var statearr_62274_62328 = state_62207__$1;
(statearr_62274_62328[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2741__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2741__auto____0 = (function (){
var statearr_62275 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62275[(0)] = fluree$db$connection$msg_producer_$_state_machine__2741__auto__);

(statearr_62275[(1)] = (1));

return statearr_62275;
});
var fluree$db$connection$msg_producer_$_state_machine__2741__auto____1 = (function (state_62207){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62207);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62276){var ex__2744__auto__ = e62276;
var statearr_62277_62329 = state_62207;
(statearr_62277_62329[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62207[(4)]))){
var statearr_62278_62330 = state_62207;
(statearr_62278_62330[(1)] = cljs.core.first((state_62207[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62331 = state_62207;
state_62207 = G__62331;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2741__auto__ = function(state_62207){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2741__auto____1.call(this,state_62207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2741__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2741__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62279 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62279[(6)] = c__2763__auto__);

return statearr_62279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__62332 = conn;
var map__62332__$1 = cljs.core.__destructure_map(map__62332);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62332__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62417){
var state_val_62418 = (state_62417[(1)]);
if((state_val_62418 === (7))){
var inst_62413 = (state_62417[(2)]);
var state_62417__$1 = state_62417;
var statearr_62419_62470 = state_62417__$1;
(statearr_62419_62470[(2)] = inst_62413);

(statearr_62419_62470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (20))){
var inst_62351 = (state_62417[(7)]);
var inst_62365 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_62366 = [inst_62351];
var inst_62367 = cljs.core.PersistentHashMap.fromArrays(inst_62365,inst_62366);
var inst_62368 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_62367], 0));
var state_62417__$1 = state_62417;
var statearr_62420_62471 = state_62417__$1;
(statearr_62420_62471[(2)] = inst_62368);

(statearr_62420_62471[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (27))){
var state_62417__$1 = state_62417;
var statearr_62421_62472 = state_62417__$1;
(statearr_62421_62472[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (1))){
var inst_62333 = (0);
var state_62417__$1 = (function (){var statearr_62423 = state_62417;
(statearr_62423[(8)] = inst_62333);

return statearr_62423;
})();
var statearr_62424_62473 = state_62417__$1;
(statearr_62424_62473[(2)] = null);

(statearr_62424_62473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (24))){
var inst_62344 = (state_62417[(9)]);
var inst_62393 = fluree.db.util.core.exception_QMARK_(inst_62344);
var state_62417__$1 = state_62417;
if(inst_62393){
var statearr_62425_62474 = state_62417__$1;
(statearr_62425_62474[(1)] = (26));

} else {
var statearr_62426_62475 = state_62417__$1;
(statearr_62426_62475[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (4))){
var inst_62338 = (state_62417[(10)]);
var inst_62343 = (state_62417[(2)]);
var inst_62344 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62343,(0),null);
var inst_62345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62343,(1),null);
var inst_62346 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62345,inst_62338);
var state_62417__$1 = (function (){var statearr_62427 = state_62417;
(statearr_62427[(9)] = inst_62344);

return statearr_62427;
})();
if(inst_62346){
var statearr_62428_62476 = state_62417__$1;
(statearr_62428_62476[(1)] = (5));

} else {
var statearr_62429_62477 = state_62417__$1;
(statearr_62429_62477[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (15))){
var inst_62351 = (state_62417[(7)]);
var inst_62360 = typeof inst_62351 === 'string';
var state_62417__$1 = state_62417;
if(cljs.core.truth_(inst_62360)){
var statearr_62430_62478 = state_62417__$1;
(statearr_62430_62478[(1)] = (17));

} else {
var statearr_62431_62479 = state_62417__$1;
(statearr_62431_62479[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (21))){
var state_62417__$1 = state_62417;
var statearr_62432_62480 = state_62417__$1;
(statearr_62432_62480[(2)] = null);

(statearr_62432_62480[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (31))){
var inst_62407 = (state_62417[(2)]);
var state_62417__$1 = state_62417;
var statearr_62433_62481 = state_62417__$1;
(statearr_62433_62481[(2)] = inst_62407);

(statearr_62433_62481[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (13))){
var inst_62377 = (state_62417[(2)]);
var inst_62378 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62379 = fluree.db.connection.close_websocket(inst_62378);
var inst_62380 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62381 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_62380);
var state_62417__$1 = (function (){var statearr_62434 = state_62417;
(statearr_62434[(11)] = inst_62379);

(statearr_62434[(12)] = inst_62377);

return statearr_62434;
})();
var statearr_62435_62482 = state_62417__$1;
(statearr_62435_62482[(2)] = inst_62381);

(statearr_62435_62482[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (22))){
var inst_62371 = (state_62417[(2)]);
var state_62417__$1 = state_62417;
var statearr_62436_62483 = state_62417__$1;
(statearr_62436_62483[(2)] = inst_62371);

(statearr_62436_62483[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (29))){
var inst_62344 = (state_62417[(9)]);
var inst_62399 = fluree.db.util.json.parse(inst_62344);
var inst_62400 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62399], 0));
var inst_62401 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_62400], 0));
var inst_62402 = fluree.db.util.json.parse(inst_62344);
var inst_62403 = fluree.db.conn_events.process_events(conn,inst_62402);
var inst_62333 = (0);
var state_62417__$1 = (function (){var statearr_62437 = state_62417;
(statearr_62437[(13)] = inst_62403);

(statearr_62437[(14)] = inst_62401);

(statearr_62437[(8)] = inst_62333);

return statearr_62437;
})();
var statearr_62438_62484 = state_62417__$1;
(statearr_62438_62484[(2)] = null);

(statearr_62438_62484[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (6))){
var inst_62344 = (state_62417[(9)]);
var inst_62389 = (inst_62344 == null);
var state_62417__$1 = state_62417;
if(cljs.core.truth_(inst_62389)){
var statearr_62439_62485 = state_62417__$1;
(statearr_62439_62485[(1)] = (23));

} else {
var statearr_62440_62486 = state_62417__$1;
(statearr_62440_62486[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (28))){
var inst_62409 = (state_62417[(2)]);
var state_62417__$1 = state_62417;
var statearr_62441_62487 = state_62417__$1;
(statearr_62441_62487[(2)] = inst_62409);

(statearr_62441_62487[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (25))){
var inst_62411 = (state_62417[(2)]);
var state_62417__$1 = state_62417;
var statearr_62442_62488 = state_62417__$1;
(statearr_62442_62488[(2)] = inst_62411);

(statearr_62442_62488[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (17))){
var inst_62351 = (state_62417[(7)]);
var inst_62362 = cljs.core.eval(inst_62351);
var state_62417__$1 = state_62417;
var statearr_62443_62489 = state_62417__$1;
(statearr_62443_62489[(2)] = inst_62362);

(statearr_62443_62489[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (3))){
var inst_62415 = (state_62417[(2)]);
var state_62417__$1 = state_62417;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62417__$1,inst_62415);
} else {
if((state_val_62418 === (12))){
var inst_62351 = (state_62417[(7)]);
var inst_62356 = cljs.core.fn_QMARK_(inst_62351);
var state_62417__$1 = state_62417;
if(inst_62356){
var statearr_62444_62490 = state_62417__$1;
(statearr_62444_62490[(1)] = (14));

} else {
var statearr_62445_62491 = state_62417__$1;
(statearr_62445_62491[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (2))){
var inst_62338 = (state_62417[(10)]);
var inst_62338__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_62339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62340 = [sub_chan,inst_62338__$1];
var inst_62341 = (new cljs.core.PersistentVector(null,2,(5),inst_62339,inst_62340,null));
var state_62417__$1 = (function (){var statearr_62446 = state_62417;
(statearr_62446[(10)] = inst_62338__$1);

return statearr_62446;
})();
return cljs.core.async.ioc_alts_BANG_(state_62417__$1,(4),inst_62341);
} else {
if((state_val_62418 === (23))){
var inst_62391 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_62417__$1 = state_62417;
var statearr_62447_62492 = state_62417__$1;
(statearr_62447_62492[(2)] = inst_62391);

(statearr_62447_62492[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (19))){
var inst_62373 = (state_62417[(2)]);
var state_62417__$1 = state_62417;
var statearr_62448_62493 = state_62417__$1;
(statearr_62448_62493[(2)] = inst_62373);

(statearr_62448_62493[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (11))){
var inst_62354 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_62417__$1 = state_62417;
var statearr_62449_62494 = state_62417__$1;
(statearr_62449_62494[(2)] = inst_62354);

(statearr_62449_62494[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (9))){
var inst_62333 = (state_62417[(8)]);
var inst_62383 = fluree.db.connection.ping_transactor(conn);
var inst_62384 = (inst_62333 + (1));
var inst_62333__$1 = inst_62384;
var state_62417__$1 = (function (){var statearr_62450 = state_62417;
(statearr_62450[(15)] = inst_62383);

(statearr_62450[(8)] = inst_62333__$1);

return statearr_62450;
})();
var statearr_62451_62495 = state_62417__$1;
(statearr_62451_62495[(2)] = null);

(statearr_62451_62495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (5))){
var inst_62333 = (state_62417[(8)]);
var inst_62348 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_62333);
var state_62417__$1 = state_62417;
if(inst_62348){
var statearr_62452_62496 = state_62417__$1;
(statearr_62452_62496[(1)] = (8));

} else {
var statearr_62453_62497 = state_62417__$1;
(statearr_62453_62497[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (14))){
var inst_62351 = (state_62417[(7)]);
var inst_62358 = (inst_62351.cljs$core$IFn$_invoke$arity$0 ? inst_62351.cljs$core$IFn$_invoke$arity$0() : inst_62351.call(null));
var state_62417__$1 = state_62417;
var statearr_62454_62498 = state_62417__$1;
(statearr_62454_62498[(2)] = inst_62358);

(statearr_62454_62498[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (26))){
var inst_62344 = (state_62417[(9)]);
var inst_62395 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62344], 0));
var inst_62333 = (0);
var state_62417__$1 = (function (){var statearr_62455 = state_62417;
(statearr_62455[(16)] = inst_62395);

(statearr_62455[(8)] = inst_62333);

return statearr_62455;
})();
var statearr_62456_62499 = state_62417__$1;
(statearr_62456_62499[(2)] = null);

(statearr_62456_62499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (16))){
var inst_62375 = (state_62417[(2)]);
var state_62417__$1 = state_62417;
var statearr_62457_62500 = state_62417__$1;
(statearr_62457_62500[(2)] = inst_62375);

(statearr_62457_62500[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (30))){
var state_62417__$1 = state_62417;
var statearr_62458_62501 = state_62417__$1;
(statearr_62458_62501[(2)] = null);

(statearr_62458_62501[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (10))){
var inst_62387 = (state_62417[(2)]);
var state_62417__$1 = state_62417;
var statearr_62459_62502 = state_62417__$1;
(statearr_62459_62502[(2)] = inst_62387);

(statearr_62459_62502[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (18))){
var state_62417__$1 = state_62417;
var statearr_62460_62503 = state_62417__$1;
(statearr_62460_62503[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62418 === (8))){
var inst_62351 = (state_62417[(7)]);
var inst_62350 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_62351__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62352 = (inst_62351__$1 == null);
var state_62417__$1 = (function (){var statearr_62462 = state_62417;
(statearr_62462[(7)] = inst_62351__$1);

(statearr_62462[(17)] = inst_62350);

return statearr_62462;
})();
if(cljs.core.truth_(inst_62352)){
var statearr_62463_62504 = state_62417__$1;
(statearr_62463_62504[(1)] = (11));

} else {
var statearr_62464_62505 = state_62417__$1;
(statearr_62464_62505[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2741__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2741__auto____0 = (function (){
var statearr_62465 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62465[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2741__auto__);

(statearr_62465[(1)] = (1));

return statearr_62465;
});
var fluree$db$connection$msg_consumer_$_state_machine__2741__auto____1 = (function (state_62417){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62417);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62466){var ex__2744__auto__ = e62466;
var statearr_62467_62506 = state_62417;
(statearr_62467_62506[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62417[(4)]))){
var statearr_62468_62507 = state_62417;
(statearr_62468_62507[(1)] = cljs.core.first((state_62417[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62508 = state_62417;
state_62417 = G__62508;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2741__auto__ = function(state_62417){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2741__auto____1.call(this,state_62417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2741__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2741__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62469 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62469[(6)] = c__2763__auto__);

return statearr_62469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__62510 = arguments.length;
switch (G__62510) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__62511 = opts;
var map__62511__$1 = cljs.core.__destructure_map(map__62511);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62511__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62511__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62563){
var state_val_62564 = (state_62563[(1)]);
if((state_val_62564 === (7))){
var inst_62521 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62523 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62524 = (new cljs.core.PersistentVector(null,2,(5),inst_62522,inst_62523,null));
var inst_62525 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62521,inst_62524);
var state_62563__$1 = state_62563;
var statearr_62565_62596 = state_62563__$1;
(statearr_62565_62596[(2)] = inst_62525);

(statearr_62565_62596[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (1))){
var state_62563__$1 = state_62563;
var statearr_62566_62597 = state_62563__$1;
(statearr_62566_62597[(2)] = null);

(statearr_62566_62597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (4))){
var inst_62512 = (state_62563[(2)]);
var state_62563__$1 = state_62563;
var statearr_62567_62598 = state_62563__$1;
(statearr_62567_62598[(2)] = inst_62512);

(statearr_62567_62598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (15))){
var inst_62532 = (state_62563[(7)]);
var inst_62551 = (state_62563[(2)]);
var inst_62552 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_62553 = [(5000),inst_62551,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_62554 = cljs.core.PersistentHashMap.fromArrays(inst_62552,inst_62553);
var inst_62555 = fluree.db.util.xhttp.get(inst_62532,inst_62554);
var state_62563__$1 = state_62563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62563__$1,(16),inst_62555);
} else {
if((state_val_62564 === (13))){
var inst_62532 = (state_62563[(7)]);
var inst_62542 = (state_62563[(8)]);
var inst_62544 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_62545 = [inst_62542];
var inst_62546 = cljs.core.PersistentHashMap.fromArrays(inst_62544,inst_62545);
var inst_62547 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_62532,inst_62546,private$);
var inst_62548 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_62547);
var state_62563__$1 = state_62563;
var statearr_62568_62599 = state_62563__$1;
(statearr_62568_62599[(2)] = inst_62548);

(statearr_62568_62599[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (6))){
var inst_62518 = (state_62563[(9)]);
var state_62563__$1 = state_62563;
var statearr_62569_62600 = state_62563__$1;
(statearr_62569_62600[(2)] = inst_62518);

(statearr_62569_62600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (3))){
var inst_62561 = (state_62563[(2)]);
var state_62563__$1 = state_62563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62563__$1,inst_62561);
} else {
if((state_val_62564 === (12))){
var inst_62542 = (state_62563[(2)]);
var state_62563__$1 = (function (){var statearr_62570 = state_62563;
(statearr_62570[(8)] = inst_62542);

return statearr_62570;
})();
if(cljs.core.truth_(private$)){
var statearr_62571_62601 = state_62563__$1;
(statearr_62571_62601[(1)] = (13));

} else {
var statearr_62572_62602 = state_62563__$1;
(statearr_62572_62602[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (2))){
var inst_62518 = (state_62563[(9)]);
var _ = (function (){var statearr_62573 = state_62563;
(statearr_62573[(4)] = cljs.core.cons((5),(state_62563[(4)])));

return statearr_62573;
})();
var inst_62518__$1 = jwt;
var state_62563__$1 = (function (){var statearr_62574 = state_62563;
(statearr_62574[(9)] = inst_62518__$1);

return statearr_62574;
})();
if(cljs.core.truth_(inst_62518__$1)){
var statearr_62575_62603 = state_62563__$1;
(statearr_62575_62603[(1)] = (6));

} else {
var statearr_62576_62604 = state_62563__$1;
(statearr_62576_62604[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (11))){
var inst_62536 = (state_62563[(10)]);
var state_62563__$1 = state_62563;
var statearr_62578_62605 = state_62563__$1;
(statearr_62578_62605[(2)] = inst_62536);

(statearr_62578_62605[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (9))){
var inst_62528 = (state_62563[(11)]);
var inst_62527 = (state_62563[(12)]);
var inst_62531 = (state_62563[(2)]);
var inst_62532 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62531),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62528)].join('');
var inst_62534 = ["Accept"];
var inst_62535 = ["application/json"];
var inst_62536 = cljs.core.PersistentHashMap.fromArrays(inst_62534,inst_62535);
var state_62563__$1 = (function (){var statearr_62579 = state_62563;
(statearr_62579[(10)] = inst_62536);

(statearr_62579[(7)] = inst_62532);

return statearr_62579;
})();
if(cljs.core.truth_(inst_62527)){
var statearr_62580_62606 = state_62563__$1;
(statearr_62580_62606[(1)] = (10));

} else {
var statearr_62581_62607 = state_62563__$1;
(statearr_62581_62607[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (5))){
var _ = (function (){var statearr_62582 = state_62563;
(statearr_62582[(4)] = cljs.core.rest((state_62563[(4)])));

return statearr_62582;
})();
var state_62563__$1 = state_62563;
var ex62577 = (state_62563__$1[(2)]);
var statearr_62583_62608 = state_62563__$1;
(statearr_62583_62608[(5)] = ex62577);


if((ex62577 instanceof Error)){
var statearr_62584_62609 = state_62563__$1;
(statearr_62584_62609[(1)] = (4));

(statearr_62584_62609[(5)] = null);

} else {
throw ex62577;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (14))){
var inst_62542 = (state_62563[(8)]);
var state_62563__$1 = state_62563;
var statearr_62585_62610 = state_62563__$1;
(statearr_62585_62610[(2)] = inst_62542);

(statearr_62585_62610[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (16))){
var inst_62557 = (state_62563[(2)]);
var inst_62558 = fluree.db.util.async.throw_err(inst_62557);
var _ = (function (){var statearr_62586 = state_62563;
(statearr_62586[(4)] = cljs.core.rest((state_62563[(4)])));

return statearr_62586;
})();
var state_62563__$1 = state_62563;
var statearr_62587_62611 = state_62563__$1;
(statearr_62587_62611[(2)] = inst_62558);

(statearr_62587_62611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (10))){
var inst_62527 = (state_62563[(12)]);
var inst_62536 = (state_62563[(10)]);
var inst_62538 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62527)].join('');
var inst_62539 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62536,"Authorization",inst_62538);
var state_62563__$1 = state_62563;
var statearr_62588_62612 = state_62563__$1;
(statearr_62588_62612[(2)] = inst_62539);

(statearr_62588_62612[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62564 === (8))){
var inst_62527 = (state_62563[(2)]);
var inst_62528 = clojure.string.replace(k,"_","/");
var inst_62529 = fluree.db.connection.get_server(conn_id,servers);
var state_62563__$1 = (function (){var statearr_62589 = state_62563;
(statearr_62589[(11)] = inst_62528);

(statearr_62589[(12)] = inst_62527);

return statearr_62589;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62563__$1,(9),inst_62529);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2741__auto__ = null;
var fluree$db$connection$state_machine__2741__auto____0 = (function (){
var statearr_62590 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62590[(0)] = fluree$db$connection$state_machine__2741__auto__);

(statearr_62590[(1)] = (1));

return statearr_62590;
});
var fluree$db$connection$state_machine__2741__auto____1 = (function (state_62563){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62563);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62591){var ex__2744__auto__ = e62591;
var statearr_62592_62613 = state_62563;
(statearr_62592_62613[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62563[(4)]))){
var statearr_62593_62614 = state_62563;
(statearr_62593_62614[(1)] = cljs.core.first((state_62563[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62615 = state_62563;
state_62563 = G__62615;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2741__auto__ = function(state_62563){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2741__auto____1.call(this,state_62563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2741__auto____0;
fluree$db$connection$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2741__auto____1;
return fluree$db$connection$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62594 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62594[(6)] = c__2763__auto__);

return statearr_62594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__62616_SHARP_){
if(cljs.core.truth_(p1__62616_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__62617_SHARP_){
var or__4253__auto__ = p1__62617_SHARP_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return token;
}
}));

return true;
}catch (e62618){var e = e62618;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__62619 = opts;
var map__62619__$1 = cljs.core.__destructure_map(map__62619);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62619__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62619__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62619__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62619__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62619__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62619__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62619__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62619__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62619__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62619__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62619__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4253__auto__ = object_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4253__auto__ = storage_read;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4253__auto__ = storage_exists;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = storage_read;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4251__auto__ = storage_write;
if(cljs.core.truth_(and__4251__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__62620_62621 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__62620_62621.cljs$core$IFn$_invoke$arity$0 ? fexpr__62620_62621.cljs$core$IFn$_invoke$arity$0() : fexpr__62620_62621.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___62662 = arguments.length;
var i__4865__auto___62663 = (0);
while(true){
if((i__4865__auto___62663 < len__4864__auto___62662)){
args__4870__auto__.push((arguments[i__4865__auto___62663]));

var G__62664 = (i__4865__auto___62663 + (1));
i__4865__auto___62663 = G__62664;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__62624){
var vec__62625 = p__62624;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62625,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2763__auto___62665 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62645){
var state_val_62646 = (state_62645[(1)]);
if((state_val_62646 === (1))){
var inst_62628 = fluree.db.connection.get_socket(conn);
var state_62645__$1 = state_62645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62645__$1,(2),inst_62628);
} else {
if((state_val_62646 === (2))){
var inst_62631 = (state_62645[(7)]);
var inst_62630 = (state_62645[(8)]);
var inst_62630__$1 = (state_62645[(2)]);
var inst_62631__$1 = (inst_62630__$1 == null);
var state_62645__$1 = (function (){var statearr_62647 = state_62645;
(statearr_62647[(7)] = inst_62631__$1);

(statearr_62647[(8)] = inst_62630__$1);

return statearr_62647;
})();
if(cljs.core.truth_(inst_62631__$1)){
var statearr_62648_62666 = state_62645__$1;
(statearr_62648_62666[(1)] = (3));

} else {
var statearr_62649_62667 = state_62645__$1;
(statearr_62649_62667[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62646 === (3))){
var inst_62631 = (state_62645[(7)]);
var state_62645__$1 = state_62645;
var statearr_62650_62668 = state_62645__$1;
(statearr_62650_62668[(2)] = inst_62631);

(statearr_62650_62668[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62646 === (4))){
var inst_62630 = (state_62645[(8)]);
var inst_62634 = fluree.db.util.core.exception_QMARK_(inst_62630);
var state_62645__$1 = state_62645;
var statearr_62651_62669 = state_62645__$1;
(statearr_62651_62669[(2)] = inst_62634);

(statearr_62651_62669[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62646 === (5))){
var inst_62636 = (state_62645[(2)]);
var state_62645__$1 = state_62645;
if(cljs.core.truth_(inst_62636)){
var statearr_62652_62670 = state_62645__$1;
(statearr_62652_62670[(1)] = (6));

} else {
var statearr_62653_62671 = state_62645__$1;
(statearr_62653_62671[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62646 === (6))){
var inst_62630 = (state_62645[(8)]);
var inst_62638 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62630,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_62639 = cljs.core.async.close_BANG_(conn);
var state_62645__$1 = (function (){var statearr_62654 = state_62645;
(statearr_62654[(9)] = inst_62638);

return statearr_62654;
})();
var statearr_62655_62672 = state_62645__$1;
(statearr_62655_62672[(2)] = inst_62639);

(statearr_62655_62672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62646 === (7))){
var inst_62641 = fluree.db.connection.msg_consumer(conn);
var state_62645__$1 = state_62645;
var statearr_62656_62673 = state_62645__$1;
(statearr_62656_62673[(2)] = inst_62641);

(statearr_62656_62673[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62646 === (8))){
var inst_62643 = (state_62645[(2)]);
var state_62645__$1 = state_62645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62645__$1,inst_62643);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2741__auto__ = null;
var fluree$db$connection$state_machine__2741__auto____0 = (function (){
var statearr_62657 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62657[(0)] = fluree$db$connection$state_machine__2741__auto__);

(statearr_62657[(1)] = (1));

return statearr_62657;
});
var fluree$db$connection$state_machine__2741__auto____1 = (function (state_62645){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62645);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62658){var ex__2744__auto__ = e62658;
var statearr_62659_62674 = state_62645;
(statearr_62659_62674[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62645[(4)]))){
var statearr_62660_62675 = state_62645;
(statearr_62660_62675[(1)] = cljs.core.first((state_62645[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62676 = state_62645;
state_62645 = G__62676;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2741__auto__ = function(state_62645){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2741__auto____1.call(this,state_62645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2741__auto____0;
fluree$db$connection$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2741__auto____1;
return fluree$db$connection$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62661 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62661[(6)] = c__2763__auto___62665);

return statearr_62661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq62622){
var G__62623 = cljs.core.first(seq62622);
var seq62622__$1 = cljs.core.next(seq62622);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62623,seq62622__$1);
}));

