// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__62687 = arguments.length;
switch (G__62687) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62729){
var state_val_62730 = (state_62729[(1)]);
if((state_val_62730 === (7))){
var inst_62699 = typeof user === 'string';
var state_62729__$1 = state_62729;
if(cljs.core.truth_(inst_62699)){
var statearr_62731_62760 = state_62729__$1;
(statearr_62731_62760[(1)] = (9));

} else {
var statearr_62732_62761 = state_62729__$1;
(statearr_62732_62761[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (1))){
var state_62729__$1 = state_62729;
var statearr_62733_62762 = state_62729__$1;
(statearr_62733_62762[(2)] = null);

(statearr_62733_62762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (4))){
var inst_62688 = (state_62729[(2)]);
var inst_62689 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62688], 0));
var inst_62690 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62688) : reject.call(null,inst_62688));
var state_62729__$1 = (function (){var statearr_62734 = state_62729;
(statearr_62734[(7)] = inst_62689);

return statearr_62734;
})();
var statearr_62735_62763 = state_62729__$1;
(statearr_62735_62763[(2)] = inst_62690);

(statearr_62735_62763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (15))){
var inst_62718 = (state_62729[(2)]);
var inst_62719 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_62718);
var inst_62720 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62721 = cljs.core.constantly(inst_62719);
var inst_62722 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62720,inst_62721);
var inst_62723 = fluree.db.connection.add_token(conn,inst_62719);
var inst_62724 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_62718) : resolve.call(null,inst_62718));
var _ = (function (){var statearr_62736 = state_62729;
(statearr_62736[(4)] = cljs.core.rest((state_62729[(4)])));

return statearr_62736;
})();
var state_62729__$1 = (function (){var statearr_62737 = state_62729;
(statearr_62737[(8)] = inst_62723);

(statearr_62737[(9)] = inst_62722);

return statearr_62737;
})();
var statearr_62738_62764 = state_62729__$1;
(statearr_62738_62764[(2)] = inst_62724);

(statearr_62738_62764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (13))){
var state_62729__$1 = state_62729;
var statearr_62739_62765 = state_62729__$1;
(statearr_62739_62765[(2)] = null);

(statearr_62739_62765[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (6))){
var state_62729__$1 = state_62729;
var statearr_62740_62766 = state_62729__$1;
(statearr_62740_62766[(2)] = user);

(statearr_62740_62766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (3))){
var inst_62727 = (state_62729[(2)]);
var state_62729__$1 = state_62729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62729__$1,inst_62727);
} else {
if((state_val_62730 === (12))){
var state_62729__$1 = state_62729;
var statearr_62741_62767 = state_62729__$1;
(statearr_62741_62767[(2)] = user);

(statearr_62741_62767[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (2))){
var _ = (function (){var statearr_62742 = state_62729;
(statearr_62742[(4)] = cljs.core.cons((5),(state_62729[(4)])));

return statearr_62742;
})();
var inst_62696 = typeof user === 'number';
var state_62729__$1 = state_62729;
if(cljs.core.truth_(inst_62696)){
var statearr_62743_62768 = state_62729__$1;
(statearr_62743_62768[(1)] = (6));

} else {
var statearr_62744_62769 = state_62729__$1;
(statearr_62744_62769[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (11))){
var inst_62710 = (state_62729[(2)]);
var state_62729__$1 = state_62729;
var statearr_62746_62770 = state_62729__$1;
(statearr_62746_62770[(2)] = inst_62710);

(statearr_62746_62770[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (9))){
var inst_62701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62702 = ["_user/username",user];
var inst_62703 = (new cljs.core.PersistentVector(null,2,(5),inst_62701,inst_62702,null));
var state_62729__$1 = state_62729;
var statearr_62747_62771 = state_62729__$1;
(statearr_62747_62771[(2)] = inst_62703);

(statearr_62747_62771[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (5))){
var _ = (function (){var statearr_62748 = state_62729;
(statearr_62748[(4)] = cljs.core.rest((state_62729[(4)])));

return statearr_62748;
})();
var state_62729__$1 = state_62729;
var ex62745 = (state_62729__$1[(2)]);
var statearr_62749_62772 = state_62729__$1;
(statearr_62749_62772[(5)] = ex62745);


var statearr_62750_62773 = state_62729__$1;
(statearr_62750_62773[(1)] = (4));

(statearr_62750_62773[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (14))){
var inst_62708 = (state_62729[(2)]);
var state_62729__$1 = state_62729;
var statearr_62751_62774 = state_62729__$1;
(statearr_62751_62774[(2)] = inst_62708);

(statearr_62751_62774[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (10))){
var state_62729__$1 = state_62729;
var statearr_62752_62775 = state_62729__$1;
(statearr_62752_62775[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62730 === (8))){
var inst_62712 = (state_62729[(2)]);
var inst_62713 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_62714 = [account,inst_62712,password,expireSeconds,syncTo];
var inst_62715 = cljs.core.PersistentHashMap.fromArrays(inst_62713,inst_62714);
var inst_62716 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_62715);
var state_62729__$1 = state_62729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62729__$1,(15),inst_62716);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_62754 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62754[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_62754[(1)] = (1));

return statearr_62754;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_62729){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62729);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62755){var ex__2744__auto__ = e62755;
var statearr_62756_62776 = state_62729;
(statearr_62756_62776[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62729[(4)]))){
var statearr_62757_62777 = state_62729;
(statearr_62757_62777[(1)] = cljs.core.first((state_62729[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62778 = state_62729;
state_62729 = G__62778;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_62729){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_62729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62758 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62758[(6)] = c__2763__auto__);

return statearr_62758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__62780 = arguments.length;
switch (G__62780) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62789){
var state_val_62790 = (state_62789[(1)]);
if((state_val_62790 === (1))){
var inst_62781 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62783 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_62784 = (new cljs.core.PersistentVector(null,4,(5),inst_62782,inst_62783,null));
var inst_62785 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62781,inst_62784);
var inst_62786 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__62791 = cljs.core.seq(cljs.core.keys(x));
var chunk__62792 = null;
var count__62793 = (0);
var i__62794 = (0);
while(true){
if((i__62794 < count__62793)){
var k = chunk__62792.cljs$core$IIndexed$_nth$arity$2(null,i__62794);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__62802 = seq__62791;
var G__62803 = chunk__62792;
var G__62804 = count__62793;
var G__62805 = (i__62794 + (1));
seq__62791 = G__62802;
chunk__62792 = G__62803;
count__62793 = G__62804;
i__62794 = G__62805;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__62791);
if(temp__5753__auto__){
var seq__62791__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__62791__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__62791__$1);
var G__62806 = cljs.core.chunk_rest(seq__62791__$1);
var G__62807 = c__4679__auto__;
var G__62808 = cljs.core.count(c__4679__auto__);
var G__62809 = (0);
seq__62791 = G__62806;
chunk__62792 = G__62807;
count__62793 = G__62808;
i__62794 = G__62809;
continue;
} else {
var k = cljs.core.first(seq__62791__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__62810 = cljs.core.next(seq__62791__$1);
var G__62811 = null;
var G__62812 = (0);
var G__62813 = (0);
seq__62791 = G__62810;
chunk__62792 = G__62811;
count__62793 = G__62812;
i__62794 = G__62813;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_62787 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_62786);
var state_62789__$1 = (function (){var statearr_62795 = state_62789;
(statearr_62795[(7)] = inst_62785);

return statearr_62795;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_62789__$1,inst_62787);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_62796 = [null,null,null,null,null,null,null,null];
(statearr_62796[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_62796[(1)] = (1));

return statearr_62796;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_62789){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62789);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62797){var ex__2744__auto__ = e62797;
var statearr_62798_62814 = state_62789;
(statearr_62798_62814[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62789[(4)]))){
var statearr_62799_62815 = state_62789;
(statearr_62799_62815[(1)] = cljs.core.first((state_62789[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62816 = state_62789;
state_62789 = G__62816;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_62789){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_62789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62800 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62800[(6)] = c__2763__auto__);

return statearr_62800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__62818 = arguments.length;
switch (G__62818) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62852){
var state_val_62853 = (state_62852[(1)]);
if((state_val_62853 === (1))){
var state_62852__$1 = state_62852;
var statearr_62854_62875 = state_62852__$1;
(statearr_62854_62875[(2)] = null);

(statearr_62854_62875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62853 === (2))){
var _ = (function (){var statearr_62855 = state_62852;
(statearr_62855[(4)] = cljs.core.cons((5),(state_62852[(4)])));

return statearr_62855;
})();
var inst_62827 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_62828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62829 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_62830 = (new cljs.core.PersistentVector(null,1,(5),inst_62828,inst_62829,null));
var inst_62831 = cljs.core.PersistentHashMap.EMPTY;
var inst_62832 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_62831);
var inst_62833 = cljs.core.assoc_in(inst_62827,inst_62830,inst_62832);
var inst_62834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62835 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62836 = (new cljs.core.PersistentVector(null,1,(5),inst_62834,inst_62835,null));
var inst_62837 = cljs.core.PersistentHashMap.EMPTY;
var inst_62838 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_62837);
var inst_62839 = cljs.core.assoc_in(inst_62833,inst_62836,inst_62838);
var inst_62840 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62841 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_62839);
var inst_62842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62843 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_62840,null];
var inst_62844 = (new cljs.core.PersistentVector(null,4,(5),inst_62842,inst_62843,null));
var inst_62845 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62841,inst_62844);
var inst_62846 = (function (){var conn = inst_62839;
var pc = inst_62840;
return (function (x){
if((x == null)){
} else {
var seq__62856_62876 = cljs.core.seq(cljs.core.keys(x));
var chunk__62857_62877 = null;
var count__62858_62878 = (0);
var i__62859_62879 = (0);
while(true){
if((i__62859_62879 < count__62858_62878)){
var k_62880 = chunk__62857_62877.cljs$core$IIndexed$_nth$arity$2(null,i__62859_62879);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62880], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_62880,null));


var G__62881 = seq__62856_62876;
var G__62882 = chunk__62857_62877;
var G__62883 = count__62858_62878;
var G__62884 = (i__62859_62879 + (1));
seq__62856_62876 = G__62881;
chunk__62857_62877 = G__62882;
count__62858_62878 = G__62883;
i__62859_62879 = G__62884;
continue;
} else {
var temp__5753__auto___62885 = cljs.core.seq(seq__62856_62876);
if(temp__5753__auto___62885){
var seq__62856_62886__$1 = temp__5753__auto___62885;
if(cljs.core.chunked_seq_QMARK_(seq__62856_62886__$1)){
var c__4679__auto___62887 = cljs.core.chunk_first(seq__62856_62886__$1);
var G__62888 = cljs.core.chunk_rest(seq__62856_62886__$1);
var G__62889 = c__4679__auto___62887;
var G__62890 = cljs.core.count(c__4679__auto___62887);
var G__62891 = (0);
seq__62856_62876 = G__62888;
chunk__62857_62877 = G__62889;
count__62858_62878 = G__62890;
i__62859_62879 = G__62891;
continue;
} else {
var k_62892 = cljs.core.first(seq__62856_62886__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62892], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_62892,null));


var G__62893 = cljs.core.next(seq__62856_62886__$1);
var G__62894 = null;
var G__62895 = (0);
var G__62896 = (0);
seq__62856_62876 = G__62893;
chunk__62857_62877 = G__62894;
count__62858_62878 = G__62895;
i__62859_62879 = G__62896;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_62847 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62840,inst_62846);
var ___$1 = (function (){var statearr_62860 = state_62852;
(statearr_62860[(4)] = cljs.core.rest((state_62852[(4)])));

return statearr_62860;
})();
var state_62852__$1 = (function (){var statearr_62861 = state_62852;
(statearr_62861[(7)] = inst_62845);

return statearr_62861;
})();
var statearr_62862_62897 = state_62852__$1;
(statearr_62862_62897[(2)] = inst_62847);

(statearr_62862_62897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62853 === (3))){
var inst_62850 = (state_62852[(2)]);
var state_62852__$1 = state_62852;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62852__$1,inst_62850);
} else {
if((state_val_62853 === (4))){
var inst_62819 = (state_62852[(2)]);
var inst_62820 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62819], 0));
var inst_62821 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62819) : reject.call(null,inst_62819));
var state_62852__$1 = (function (){var statearr_62864 = state_62852;
(statearr_62864[(8)] = inst_62820);

return statearr_62864;
})();
var statearr_62865_62898 = state_62852__$1;
(statearr_62865_62898[(2)] = inst_62821);

(statearr_62865_62898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62853 === (5))){
var _ = (function (){var statearr_62866 = state_62852;
(statearr_62866[(4)] = cljs.core.rest((state_62852[(4)])));

return statearr_62866;
})();
var state_62852__$1 = state_62852;
var ex62863 = (state_62852__$1[(2)]);
var statearr_62867_62899 = state_62852__$1;
(statearr_62867_62899[(5)] = ex62863);


var statearr_62868_62900 = state_62852__$1;
(statearr_62868_62900[(1)] = (4));

(statearr_62868_62900[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_62869 = [null,null,null,null,null,null,null,null,null];
(statearr_62869[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_62869[(1)] = (1));

return statearr_62869;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_62852){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62852);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62870){var ex__2744__auto__ = e62870;
var statearr_62871_62901 = state_62852;
(statearr_62871_62901[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62852[(4)]))){
var statearr_62872_62902 = state_62852;
(statearr_62872_62902[(1)] = cljs.core.first((state_62852[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62903 = state_62852;
state_62852 = G__62903;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_62852){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_62852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62873 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62873[(6)] = c__2763__auto__);

return statearr_62873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__62905 = arguments.length;
switch (G__62905) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__62907 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62907,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62907,(1),null);
var cb_STAR_ = (function (header,data){
var G__62910 = cljs.core.clj__GT_js(header);
var G__62911 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__62910,G__62911) : callback.call(null,G__62910,G__62911));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__62912 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62912,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62912,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62965){
var state_val_62966 = (state_62965[(1)]);
if((state_val_62966 === (7))){
var inst_62926 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62927 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62928 = cljs.core.PersistentHashMap.fromArrays(inst_62926,inst_62927);
var inst_62929 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_62928);
var inst_62930 = (function(){throw inst_62929})();
var state_62965__$1 = state_62965;
var statearr_62967_62999 = state_62965__$1;
(statearr_62967_62999[(2)] = inst_62930);

(statearr_62967_62999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (1))){
var state_62965__$1 = state_62965;
var statearr_62968_63000 = state_62965__$1;
(statearr_62968_63000[(2)] = null);

(statearr_62968_63000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (4))){
var inst_62915 = (state_62965[(2)]);
var inst_62916 = cljs.core.clj__GT_js(inst_62915);
var inst_62917 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62916) : reject.call(null,inst_62916));
var state_62965__$1 = state_62965;
var statearr_62969_63001 = state_62965__$1;
(statearr_62969_63001[(2)] = inst_62917);

(statearr_62969_63001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (13))){
var inst_62944 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62945 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62946 = cljs.core.PersistentHashMap.fromArrays(inst_62944,inst_62945);
var inst_62947 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_62946);
var inst_62948 = (function(){throw inst_62947})();
var state_62965__$1 = state_62965;
var statearr_62970_63002 = state_62965__$1;
(statearr_62970_63002[(2)] = inst_62948);

(statearr_62970_63002[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (6))){
var state_62965__$1 = state_62965;
var statearr_62971_63003 = state_62965__$1;
(statearr_62971_63003[(2)] = null);

(statearr_62971_63003[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (3))){
var inst_62963 = (state_62965[(2)]);
var state_62965__$1 = state_62965;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62965__$1,inst_62963);
} else {
if((state_val_62966 === (12))){
var state_62965__$1 = state_62965;
var statearr_62972_63004 = state_62965__$1;
(statearr_62972_63004[(2)] = null);

(statearr_62972_63004[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (2))){
var _ = (function (){var statearr_62973 = state_62965;
(statearr_62973[(4)] = cljs.core.cons((5),(state_62965[(4)])));

return statearr_62973;
})();
var inst_62923 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_62965__$1 = state_62965;
if(cljs.core.truth_(inst_62923)){
var statearr_62974_63005 = state_62965__$1;
(statearr_62974_63005[(1)] = (6));

} else {
var statearr_62975_63006 = state_62965__$1;
(statearr_62975_63006[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (11))){
var inst_62941 = (state_62965[(2)]);
var state_62965__$1 = (function (){var statearr_62977 = state_62965;
(statearr_62977[(7)] = inst_62941);

return statearr_62977;
})();
if(cljs.core.truth_(password)){
var statearr_62978_63007 = state_62965__$1;
(statearr_62978_63007[(1)] = (12));

} else {
var statearr_62979_63008 = state_62965__$1;
(statearr_62979_63008[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (9))){
var state_62965__$1 = state_62965;
var statearr_62980_63009 = state_62965__$1;
(statearr_62980_63009[(2)] = null);

(statearr_62980_63009[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (5))){
var _ = (function (){var statearr_62981 = state_62965;
(statearr_62981[(4)] = cljs.core.rest((state_62965[(4)])));

return statearr_62981;
})();
var state_62965__$1 = state_62965;
var ex62976 = (state_62965__$1[(2)]);
var statearr_62982_63010 = state_62965__$1;
(statearr_62982_63010[(5)] = ex62976);


var statearr_62983_63011 = state_62965__$1;
(statearr_62983_63011[(1)] = (4));

(statearr_62983_63011[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (14))){
var inst_62950 = (state_62965[(2)]);
var inst_62951 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_62952 = fluree.db.util.core.without_nils(inst_62951);
var inst_62953 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62954 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62956 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_62952,inst_62953,null];
var inst_62957 = (new cljs.core.PersistentVector(null,4,(5),inst_62955,inst_62956,null));
var inst_62958 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62954,inst_62957);
var inst_62959 = (function (){var _ = inst_62950;
var data = inst_62952;
var pc = inst_62953;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__62984 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62984) : reject.call(null,G__62984));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__62985 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62985) : reject.call(null,G__62985));
} else {
var G__62986 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__62986) : resolve.call(null,G__62986));

}
}
});
})();
var inst_62960 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62953,inst_62959);
var _ = (function (){var statearr_62987 = state_62965;
(statearr_62987[(4)] = cljs.core.rest((state_62965[(4)])));

return statearr_62987;
})();
var state_62965__$1 = (function (){var statearr_62988 = state_62965;
(statearr_62988[(8)] = inst_62958);

return statearr_62988;
})();
var statearr_62989_63012 = state_62965__$1;
(statearr_62989_63012[(2)] = inst_62960);

(statearr_62989_63012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (10))){
var inst_62935 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62936 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62937 = cljs.core.PersistentHashMap.fromArrays(inst_62935,inst_62936);
var inst_62938 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_62937);
var inst_62939 = (function(){throw inst_62938})();
var state_62965__$1 = state_62965;
var statearr_62990_63013 = state_62965__$1;
(statearr_62990_63013[(2)] = inst_62939);

(statearr_62990_63013[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (8))){
var inst_62932 = (state_62965[(2)]);
var state_62965__$1 = (function (){var statearr_62991 = state_62965;
(statearr_62991[(9)] = inst_62932);

return statearr_62991;
})();
if(cljs.core.truth_(ledger)){
var statearr_62992_63014 = state_62965__$1;
(statearr_62992_63014[(1)] = (9));

} else {
var statearr_62993_63015 = state_62965__$1;
(statearr_62993_63015[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2741__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2741__auto____0 = (function (){
var statearr_62994 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62994[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2741__auto__);

(statearr_62994[(1)] = (1));

return statearr_62994;
});
var fluree$db$connection_js$password_generate_$_state_machine__2741__auto____1 = (function (state_62965){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62965);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62995){var ex__2744__auto__ = e62995;
var statearr_62996_63016 = state_62965;
(statearr_62996_63016[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62965[(4)]))){
var statearr_62997_63017 = state_62965;
(statearr_62997_63017[(1)] = cljs.core.first((state_62965[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63018 = state_62965;
state_62965 = G__63018;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2741__auto__ = function(state_62965){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2741__auto____1.call(this,state_62965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2741__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2741__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62998 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62998[(6)] = c__2763__auto__);

return statearr_62998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__63020 = arguments.length;
switch (G__63020) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63087){
var state_val_63088 = (state_63087[(1)]);
if((state_val_63088 === (7))){
var inst_63032 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63033 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63034 = cljs.core.PersistentHashMap.fromArrays(inst_63032,inst_63033);
var inst_63035 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63034);
var inst_63036 = (function(){throw inst_63035})();
var state_63087__$1 = state_63087;
var statearr_63089_63131 = state_63087__$1;
(statearr_63089_63131[(2)] = inst_63036);

(statearr_63089_63131[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (20))){
var inst_63070 = (state_63087[(2)]);
var inst_63071 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63072 = [ledger,password,user,auth,expire];
var inst_63073 = cljs.core.PersistentHashMap.fromArrays(inst_63071,inst_63072);
var inst_63074 = fluree.db.util.core.without_nils(inst_63073);
var inst_63075 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63076 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63078 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_63074,inst_63075,null];
var inst_63079 = (new cljs.core.PersistentVector(null,4,(5),inst_63077,inst_63078,null));
var inst_63080 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63076,inst_63079);
var inst_63081 = (function (){var _ = inst_63070;
var data = inst_63074;
var pc = inst_63075;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63090 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63090) : reject.call(null,G__63090));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63091 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63091) : reject.call(null,G__63091));
} else {
fluree.db.connection.add_token(conn,result);

var G__63092 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63092) : resolve.call(null,G__63092));

}
}
});
})();
var inst_63082 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63075,inst_63081);
var _ = (function (){var statearr_63093 = state_63087;
(statearr_63093[(4)] = cljs.core.rest((state_63087[(4)])));

return statearr_63093;
})();
var state_63087__$1 = (function (){var statearr_63094 = state_63087;
(statearr_63094[(7)] = inst_63080);

return statearr_63094;
})();
var statearr_63095_63132 = state_63087__$1;
(statearr_63095_63132[(2)] = inst_63082);

(statearr_63095_63132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (1))){
var state_63087__$1 = state_63087;
var statearr_63096_63133 = state_63087__$1;
(statearr_63096_63133[(2)] = null);

(statearr_63096_63133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (4))){
var inst_63021 = (state_63087[(2)]);
var inst_63022 = cljs.core.clj__GT_js(inst_63021);
var inst_63023 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63022) : reject.call(null,inst_63022));
var state_63087__$1 = state_63087;
var statearr_63097_63134 = state_63087__$1;
(statearr_63097_63134[(2)] = inst_63023);

(statearr_63097_63134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (15))){
var inst_63057 = (state_63087[(8)]);
var state_63087__$1 = state_63087;
var statearr_63098_63135 = state_63087__$1;
(statearr_63098_63135[(2)] = inst_63057);

(statearr_63098_63135[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (13))){
var inst_63050 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63051 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63052 = cljs.core.PersistentHashMap.fromArrays(inst_63050,inst_63051);
var inst_63053 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_63052);
var inst_63054 = (function(){throw inst_63053})();
var state_63087__$1 = state_63087;
var statearr_63099_63136 = state_63087__$1;
(statearr_63099_63136[(2)] = inst_63054);

(statearr_63099_63136[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (6))){
var state_63087__$1 = state_63087;
var statearr_63100_63137 = state_63087__$1;
(statearr_63100_63137[(2)] = null);

(statearr_63100_63137[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (17))){
var inst_63061 = (state_63087[(2)]);
var state_63087__$1 = state_63087;
if(cljs.core.truth_(inst_63061)){
var statearr_63101_63138 = state_63087__$1;
(statearr_63101_63138[(1)] = (18));

} else {
var statearr_63102_63139 = state_63087__$1;
(statearr_63102_63139[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (3))){
var inst_63085 = (state_63087[(2)]);
var state_63087__$1 = state_63087;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63087__$1,inst_63085);
} else {
if((state_val_63088 === (12))){
var state_63087__$1 = state_63087;
var statearr_63103_63140 = state_63087__$1;
(statearr_63103_63140[(2)] = null);

(statearr_63103_63140[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (2))){
var _ = (function (){var statearr_63104 = state_63087;
(statearr_63104[(4)] = cljs.core.cons((5),(state_63087[(4)])));

return statearr_63104;
})();
var inst_63029 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63087__$1 = state_63087;
if(cljs.core.truth_(inst_63029)){
var statearr_63105_63141 = state_63087__$1;
(statearr_63105_63141[(1)] = (6));

} else {
var statearr_63106_63142 = state_63087__$1;
(statearr_63106_63142[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (19))){
var inst_63064 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63065 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63066 = cljs.core.PersistentHashMap.fromArrays(inst_63064,inst_63065);
var inst_63067 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_63066);
var inst_63068 = (function(){throw inst_63067})();
var state_63087__$1 = state_63087;
var statearr_63107_63143 = state_63087__$1;
(statearr_63107_63143[(2)] = inst_63068);

(statearr_63107_63143[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (11))){
var inst_63047 = (state_63087[(2)]);
var state_63087__$1 = (function (){var statearr_63109 = state_63087;
(statearr_63109[(9)] = inst_63047);

return statearr_63109;
})();
if(cljs.core.truth_(password)){
var statearr_63110_63144 = state_63087__$1;
(statearr_63110_63144[(1)] = (12));

} else {
var statearr_63111_63145 = state_63087__$1;
(statearr_63111_63145[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (9))){
var state_63087__$1 = state_63087;
var statearr_63112_63146 = state_63087__$1;
(statearr_63112_63146[(2)] = null);

(statearr_63112_63146[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (5))){
var _ = (function (){var statearr_63113 = state_63087;
(statearr_63113[(4)] = cljs.core.rest((state_63087[(4)])));

return statearr_63113;
})();
var state_63087__$1 = state_63087;
var ex63108 = (state_63087__$1[(2)]);
var statearr_63114_63147 = state_63087__$1;
(statearr_63114_63147[(5)] = ex63108);


var statearr_63115_63148 = state_63087__$1;
(statearr_63115_63148[(1)] = (4));

(statearr_63115_63148[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (14))){
var inst_63057 = (state_63087[(8)]);
var inst_63056 = (state_63087[(2)]);
var inst_63057__$1 = user;
var state_63087__$1 = (function (){var statearr_63116 = state_63087;
(statearr_63116[(8)] = inst_63057__$1);

(statearr_63116[(10)] = inst_63056);

return statearr_63116;
})();
if(cljs.core.truth_(inst_63057__$1)){
var statearr_63117_63149 = state_63087__$1;
(statearr_63117_63149[(1)] = (15));

} else {
var statearr_63118_63150 = state_63087__$1;
(statearr_63118_63150[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (16))){
var state_63087__$1 = state_63087;
var statearr_63119_63151 = state_63087__$1;
(statearr_63119_63151[(2)] = auth);

(statearr_63119_63151[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (10))){
var inst_63041 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63042 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63043 = cljs.core.PersistentHashMap.fromArrays(inst_63041,inst_63042);
var inst_63044 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_63043);
var inst_63045 = (function(){throw inst_63044})();
var state_63087__$1 = state_63087;
var statearr_63120_63152 = state_63087__$1;
(statearr_63120_63152[(2)] = inst_63045);

(statearr_63120_63152[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (18))){
var state_63087__$1 = state_63087;
var statearr_63121_63153 = state_63087__$1;
(statearr_63121_63153[(2)] = null);

(statearr_63121_63153[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63088 === (8))){
var inst_63038 = (state_63087[(2)]);
var state_63087__$1 = (function (){var statearr_63122 = state_63087;
(statearr_63122[(11)] = inst_63038);

return statearr_63122;
})();
if(cljs.core.truth_(ledger)){
var statearr_63123_63154 = state_63087__$1;
(statearr_63123_63154[(1)] = (9));

} else {
var statearr_63124_63155 = state_63087__$1;
(statearr_63124_63155[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_63125 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63125[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_63125[(1)] = (1));

return statearr_63125;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_63087){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63087);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63126){var ex__2744__auto__ = e63126;
var statearr_63127_63156 = state_63087;
(statearr_63127_63156[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63087[(4)]))){
var statearr_63128_63157 = state_63087;
(statearr_63128_63157[(1)] = cljs.core.first((state_63087[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63158 = state_63087;
state_63087 = G__63158;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_63087){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_63087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63129 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63129[(6)] = c__2763__auto__);

return statearr_63129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__63160 = arguments.length;
switch (G__63160) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63195){
var state_val_63196 = (state_63195[(1)]);
if((state_val_63196 === (1))){
var state_63195__$1 = state_63195;
var statearr_63197_63219 = state_63195__$1;
(statearr_63197_63219[(2)] = null);

(statearr_63197_63219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63196 === (2))){
var _ = (function (){var statearr_63198 = state_63195;
(statearr_63198[(4)] = cljs.core.cons((5),(state_63195[(4)])));

return statearr_63198;
})();
var inst_63169 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63195__$1 = state_63195;
if(cljs.core.truth_(inst_63169)){
var statearr_63199_63220 = state_63195__$1;
(statearr_63199_63220[(1)] = (6));

} else {
var statearr_63200_63221 = state_63195__$1;
(statearr_63200_63221[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63196 === (3))){
var inst_63193 = (state_63195[(2)]);
var state_63195__$1 = state_63195;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63195__$1,inst_63193);
} else {
if((state_val_63196 === (4))){
var inst_63161 = (state_63195[(2)]);
var inst_63162 = cljs.core.clj__GT_js(inst_63161);
var inst_63163 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63162) : reject.call(null,inst_63162));
var state_63195__$1 = state_63195;
var statearr_63202_63222 = state_63195__$1;
(statearr_63202_63222[(2)] = inst_63163);

(statearr_63202_63222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63196 === (5))){
var _ = (function (){var statearr_63203 = state_63195;
(statearr_63203[(4)] = cljs.core.rest((state_63195[(4)])));

return statearr_63203;
})();
var state_63195__$1 = state_63195;
var ex63201 = (state_63195__$1[(2)]);
var statearr_63204_63223 = state_63195__$1;
(statearr_63204_63223[(5)] = ex63201);


var statearr_63205_63224 = state_63195__$1;
(statearr_63205_63224[(1)] = (4));

(statearr_63205_63224[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63196 === (6))){
var state_63195__$1 = state_63195;
var statearr_63206_63225 = state_63195__$1;
(statearr_63206_63225[(2)] = null);

(statearr_63206_63225[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63196 === (7))){
var inst_63172 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63173 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63174 = cljs.core.PersistentHashMap.fromArrays(inst_63172,inst_63173);
var inst_63175 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63174);
var inst_63176 = (function(){throw inst_63175})();
var state_63195__$1 = state_63195;
var statearr_63207_63226 = state_63195__$1;
(statearr_63207_63226[(2)] = inst_63176);

(statearr_63207_63226[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63196 === (8))){
var inst_63178 = (state_63195[(2)]);
var inst_63179 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63180 = [jwt,expire];
var inst_63181 = cljs.core.PersistentHashMap.fromArrays(inst_63179,inst_63180);
var inst_63182 = fluree.db.util.core.without_nils(inst_63181);
var inst_63183 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63184 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63186 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_63182,inst_63183,null];
var inst_63187 = (new cljs.core.PersistentVector(null,4,(5),inst_63185,inst_63186,null));
var inst_63188 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63184,inst_63187);
var inst_63189 = (function (){var _ = inst_63178;
var data = inst_63182;
var pc = inst_63183;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63208 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63208) : reject.call(null,G__63208));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__63209 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63209) : resolve.call(null,G__63209));

}
});
})();
var inst_63190 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63183,inst_63189);
var _ = (function (){var statearr_63210 = state_63195;
(statearr_63210[(4)] = cljs.core.rest((state_63195[(4)])));

return statearr_63210;
})();
var state_63195__$1 = (function (){var statearr_63211 = state_63195;
(statearr_63211[(7)] = inst_63188);

return statearr_63211;
})();
var statearr_63212_63227 = state_63195__$1;
(statearr_63212_63227[(2)] = inst_63190);

(statearr_63212_63227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_63213 = [null,null,null,null,null,null,null,null];
(statearr_63213[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_63213[(1)] = (1));

return statearr_63213;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_63195){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63195);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63214){var ex__2744__auto__ = e63214;
var statearr_63215_63228 = state_63195;
(statearr_63215_63228[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63195[(4)]))){
var statearr_63216_63229 = state_63195;
(statearr_63216_63229[(1)] = cljs.core.first((state_63195[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63230 = state_63195;
state_63195 = G__63230;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_63195){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_63195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63217 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63217[(6)] = c__2763__auto__);

return statearr_63217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

