// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__6508 = s;
var map__6508__$1 = cljs.core.__destructure_map.call(null,map__6508);
var name = cljs.core.get.call(null,map__6508__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__6508__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__6510 = info;
var map__6511 = G__6510;
var map__6511__$1 = cljs.core.__destructure_map.call(null,map__6511);
var shadow = cljs.core.get.call(null,map__6511__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__6510__$1 = G__6510;
while(true){
var d__$2 = d__$1;
var map__6513 = G__6510__$1;
var map__6513__$1 = cljs.core.__destructure_map.call(null,map__6513);
var shadow__$1 = cljs.core.get.call(null,map__6513__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__6514 = (d__$2 + (1));
var G__6515 = shadow__$1;
d__$1 = G__6514;
G__6510__$1 = G__6515;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__6516){
var map__6517 = p__6516;
var map__6517__$1 = cljs.core.__destructure_map.call(null,map__6517);
var name_var = map__6517__$1;
var name = cljs.core.get.call(null,map__6517__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__6517__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__6518 = info;
var map__6518__$1 = cljs.core.__destructure_map.call(null,map__6518);
var ns = cljs.core.get.call(null,map__6518__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__6518__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.call(null,reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__6520 = arguments.length;
switch (G__6520) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11648,11648,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)])).call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__6522 = cp;
switch (G__6522) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__6524_6528 = cljs.core.seq.call(null,s);
var chunk__6525_6529 = null;
var count__6526_6530 = (0);
var i__6527_6531 = (0);
while(true){
if((i__6527_6531 < count__6526_6530)){
var c_6532 = cljs.core._nth.call(null,chunk__6525_6529,i__6527_6531);
sb.append(cljs.compiler.escape_char.call(null,c_6532));


var G__6533 = seq__6524_6528;
var G__6534 = chunk__6525_6529;
var G__6535 = count__6526_6530;
var G__6536 = (i__6527_6531 + (1));
seq__6524_6528 = G__6533;
chunk__6525_6529 = G__6534;
count__6526_6530 = G__6535;
i__6527_6531 = G__6536;
continue;
} else {
var temp__5753__auto___6537 = cljs.core.seq.call(null,seq__6524_6528);
if(temp__5753__auto___6537){
var seq__6524_6538__$1 = temp__5753__auto___6537;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6524_6538__$1)){
var c__4679__auto___6539 = cljs.core.chunk_first.call(null,seq__6524_6538__$1);
var G__6540 = cljs.core.chunk_rest.call(null,seq__6524_6538__$1);
var G__6541 = c__4679__auto___6539;
var G__6542 = cljs.core.count.call(null,c__4679__auto___6539);
var G__6543 = (0);
seq__6524_6528 = G__6540;
chunk__6525_6529 = G__6541;
count__6526_6530 = G__6542;
i__6527_6531 = G__6543;
continue;
} else {
var c_6544 = cljs.core.first.call(null,seq__6524_6538__$1);
sb.append(cljs.compiler.escape_char.call(null,c_6544));


var G__6545 = cljs.core.next.call(null,seq__6524_6538__$1);
var G__6546 = null;
var G__6547 = (0);
var G__6548 = (0);
seq__6524_6528 = G__6545;
chunk__6525_6529 = G__6546;
count__6526_6530 = G__6547;
i__6527_6531 = G__6548;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4747__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__6549_6552 = ast;
var map__6549_6553__$1 = cljs.core.__destructure_map.call(null,map__6549_6552);
var env_6554 = cljs.core.get.call(null,map__6549_6553__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_6554))){
var map__6550_6555 = env_6554;
var map__6550_6556__$1 = cljs.core.__destructure_map.call(null,map__6550_6555);
var line_6557 = cljs.core.get.call(null,map__6550_6556__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_6558 = cljs.core.get.call(null,map__6550_6556__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__6551 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast)))){
return cljs.core.assoc.call(null,G__6551,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__6551;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_6557 - (1))], null),cljs.core.fnil.call(null,(function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_6558)?(column_6558 - (1)):(0))], null),cljs.core.fnil.call(null,(function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__6567 = arguments.length;
switch (G__6567) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4885__auto__ = [];
var len__4864__auto___6574 = arguments.length;
var i__4865__auto___6575 = (0);
while(true){
if((i__4865__auto___6575 < len__4864__auto___6574)){
args_arr__4885__auto__.push((arguments[i__4865__auto___6575]));

var G__6576 = (i__4865__auto___6575 + (1));
i__4865__auto___6575 = G__6576;
continue;
} else {
}
break;
}

var argseq__4886__auto__ = (new cljs.core.IndexedSeq(args_arr__4885__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4886__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,a)){
cljs.compiler.emit.call(null,a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_.call(null,a)){
cljs.core.apply.call(null,cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
a.call(null);
} else {
var s_6577 = (function (){var G__6568 = a;
if((!(typeof a === 'string'))){
return G__6568.toString();
} else {
return G__6568;
}
})();
var temp__5757__auto___6578 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___6578 == null)){
} else {
var sm_data_6579 = temp__5757__auto___6578;
cljs.core.swap_BANG_.call(null,sm_data_6579,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__6559_SHARP_){
return (p1__6559_SHARP_ + s_6577.length);
}));
}

cljs.core.print.call(null,s_6577);

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

return cljs.compiler.emits.call(null,b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler.emits.call(null,c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler.emits.call(null,d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler.emits.call(null,e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__6569 = cljs.core.seq.call(null,xs);
var chunk__6570 = null;
var count__6571 = (0);
var i__6572 = (0);
while(true){
if((i__6572 < count__6571)){
var x = cljs.core._nth.call(null,chunk__6570,i__6572);
cljs.compiler.emits.call(null,x);


var G__6580 = seq__6569;
var G__6581 = chunk__6570;
var G__6582 = count__6571;
var G__6583 = (i__6572 + (1));
seq__6569 = G__6580;
chunk__6570 = G__6581;
count__6571 = G__6582;
i__6572 = G__6583;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__6569);
if(temp__5753__auto__){
var seq__6569__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6569__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__6569__$1);
var G__6584 = cljs.core.chunk_rest.call(null,seq__6569__$1);
var G__6585 = c__4679__auto__;
var G__6586 = cljs.core.count.call(null,c__4679__auto__);
var G__6587 = (0);
seq__6569 = G__6584;
chunk__6570 = G__6585;
count__6571 = G__6586;
i__6572 = G__6587;
continue;
} else {
var x = cljs.core.first.call(null,seq__6569__$1);
cljs.compiler.emits.call(null,x);


var G__6588 = cljs.core.next.call(null,seq__6569__$1);
var G__6589 = null;
var G__6590 = (0);
var G__6591 = (0);
seq__6569 = G__6588;
chunk__6570 = G__6589;
count__6571 = G__6590;
i__6572 = G__6591;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq6561){
var G__6562 = cljs.core.first.call(null,seq6561);
var seq6561__$1 = cljs.core.next.call(null,seq6561);
var G__6563 = cljs.core.first.call(null,seq6561__$1);
var seq6561__$2 = cljs.core.next.call(null,seq6561__$1);
var G__6564 = cljs.core.first.call(null,seq6561__$2);
var seq6561__$3 = cljs.core.next.call(null,seq6561__$2);
var G__6565 = cljs.core.first.call(null,seq6561__$3);
var seq6561__$4 = cljs.core.next.call(null,seq6561__$3);
var G__6566 = cljs.core.first.call(null,seq6561__$4);
var seq6561__$5 = cljs.core.next.call(null,seq6561__$4);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6562,G__6563,G__6564,G__6565,G__6566,seq6561__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.call(null);

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__6592){
var map__6593 = p__6592;
var map__6593__$1 = cljs.core.__destructure_map.call(null,map__6593);
var m = map__6593__$1;
var gen_line = cljs.core.get.call(null,map__6593__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__6601 = arguments.length;
switch (G__6601) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4885__auto__ = [];
var len__4864__auto___6607 = arguments.length;
var i__4865__auto___6608 = (0);
while(true){
if((i__4865__auto___6608 < len__4864__auto___6607)){
args_arr__4885__auto__.push((arguments[i__4865__auto___6608]));

var G__6609 = (i__4865__auto___6608 + (1));
i__4865__auto___6608 = G__6609;
continue;
} else {
}
break;
}

var argseq__4886__auto__ = (new cljs.core.IndexedSeq(args_arr__4885__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4886__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.call(null,a);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__6602_6610 = cljs.core.seq.call(null,xs);
var chunk__6603_6611 = null;
var count__6604_6612 = (0);
var i__6605_6613 = (0);
while(true){
if((i__6605_6613 < count__6604_6612)){
var x_6614 = cljs.core._nth.call(null,chunk__6603_6611,i__6605_6613);
cljs.compiler.emits.call(null,x_6614);


var G__6615 = seq__6602_6610;
var G__6616 = chunk__6603_6611;
var G__6617 = count__6604_6612;
var G__6618 = (i__6605_6613 + (1));
seq__6602_6610 = G__6615;
chunk__6603_6611 = G__6616;
count__6604_6612 = G__6617;
i__6605_6613 = G__6618;
continue;
} else {
var temp__5753__auto___6619 = cljs.core.seq.call(null,seq__6602_6610);
if(temp__5753__auto___6619){
var seq__6602_6620__$1 = temp__5753__auto___6619;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6602_6620__$1)){
var c__4679__auto___6621 = cljs.core.chunk_first.call(null,seq__6602_6620__$1);
var G__6622 = cljs.core.chunk_rest.call(null,seq__6602_6620__$1);
var G__6623 = c__4679__auto___6621;
var G__6624 = cljs.core.count.call(null,c__4679__auto___6621);
var G__6625 = (0);
seq__6602_6610 = G__6622;
chunk__6603_6611 = G__6623;
count__6604_6612 = G__6624;
i__6605_6613 = G__6625;
continue;
} else {
var x_6626 = cljs.core.first.call(null,seq__6602_6620__$1);
cljs.compiler.emits.call(null,x_6626);


var G__6627 = cljs.core.next.call(null,seq__6602_6620__$1);
var G__6628 = null;
var G__6629 = (0);
var G__6630 = (0);
seq__6602_6610 = G__6627;
chunk__6603_6611 = G__6628;
count__6604_6612 = G__6629;
i__6605_6613 = G__6630;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln.call(null);
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq6595){
var G__6596 = cljs.core.first.call(null,seq6595);
var seq6595__$1 = cljs.core.next.call(null,seq6595);
var G__6597 = cljs.core.first.call(null,seq6595__$1);
var seq6595__$2 = cljs.core.next.call(null,seq6595__$1);
var G__6598 = cljs.core.first.call(null,seq6595__$2);
var seq6595__$3 = cljs.core.next.call(null,seq6595__$2);
var G__6599 = cljs.core.first.call(null,seq6595__$3);
var seq6595__$4 = cljs.core.next.call(null,seq6595__$3);
var G__6600 = cljs.core.first.call(null,seq6595__$4);
var seq6595__$5 = cljs.core.next.call(null,seq6595__$4);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6596,G__6597,G__6598,G__6599,G__6600,seq6595__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4795__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__6631_6635 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__6632_6636 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__6633_6637 = true;
var _STAR_print_fn_STAR__temp_val__6634_6638 = (function (x__4796__auto__){
return sb__4795__auto__.append(x__4796__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__6633_6637);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__6634_6638);

try{cljs.compiler.emit.call(null,expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__6632_6636);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__6631_6635);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4795__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4747__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.call(null,cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_.call(null,x)){
return cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.core.record_QMARK_.call(null,x)){
var vec__6639 = cljs.analyzer.record_ns_PLUS_name.call(null,x);
var ns = cljs.core.nth.call(null,vec__6639,(0),null);
var name = cljs.core.nth.call(null,vec__6639,(1),null);
return cljs.compiler.emit_record_value.call(null,ns,name,(function (){
return cljs.compiler.emit_constant.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,x));
}));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,x)){
return cljs.compiler.emit_map.call(null,cljs.core.keys.call(null,x),cljs.core.vals.call(null,x),cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_.call(null,x)){
return cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_.call(null,x)){
return cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
return cljs.compiler.emit_constant_STAR_.call(null,x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta.call(null,cljs.core.meta.call(null,v));
if((!((cljs.core.seq.call(null,m) == null)))){
return cljs.compiler.emit_with_meta.call(null,(function (){
return cljs.compiler.emit_constant_no_meta.call(null,v);
}),(function (){
return cljs.compiler.emit_constant_no_meta.call(null,m);
}));
} else {
return cljs.compiler.emit_constant_no_meta.call(null,v);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.call(null,cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__6642 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.call(null,vec__6642,(0),null);
var flags = cljs.core.nth.call(null,vec__6642,(1),null);
var pattern = cljs.core.nth.call(null,vec__6642,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4251__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4251__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.call(null,cljs.core.map_indexed.call(null,(function (i,m){
if(cljs.core.even_QMARK_.call(null,i)){
return cljs.compiler.emit_constant.call(null,m);
} else {
return cljs.compiler.emits.call(null,m);
}
}),cljs.compiler.comma_sep.call(null,cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.call(null,"new Date(",inst_ms,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Date,(function (date){
return cljs.compiler.emit_inst.call(null,date.getTime());
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_.call(null,items)){
return cljs.compiler.emit_js_object.call(null,items,(function (p1__6645_SHARP_){
return (function (){
return cljs.compiler.emit_constant.call(null,p1__6645_SHARP_);
});
}));
} else {
return cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__6647){
var map__6648 = p__6647;
var map__6648__$1 = cljs.core.__destructure_map.call(null,map__6648);
var ast = map__6648__$1;
var info = cljs.core.get.call(null,map__6648__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__6648__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__6648__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5751__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__6649 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__6649__$1 = cljs.core.__destructure_map.call(null,map__6649);
var cenv = map__6649__$1;
var options = cljs.core.get.call(null,map__6649__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4253__auto__ = js_module_name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__6650 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.namespace.call(null,var_name) == null)));
} else {
return and__4251__auto__;
}
})())){
return clojure.set.difference.call(null,G__6650,cljs.analyzer.es5_allowed);
} else {
return G__6650;
}
})();
var js_module = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4253__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})()], null));
var info__$2 = (function (){var G__6651 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__6651,reserved);
} else {
return G__6651;
}
})();
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var G__6652_6653 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__6652_6654__$1 = (((G__6652_6653 instanceof cljs.core.Keyword))?G__6652_6653.fqn:null);
switch (G__6652_6654__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace.call(null,var_name))){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"].",cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved));
} else {
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.call(null,"default",cljs.core.name.call(null,var_name));
} else {
return and__4251__auto__;
}
})())){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.call(null,info__$2);
}

break;
default:
cljs.compiler.emits.call(null,info__$2);

}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__6656){
var map__6657 = p__6656;
var map__6657__$1 = cljs.core.__destructure_map.call(null,map__6657);
var arg = map__6657__$1;
var env = cljs.core.get.call(null,map__6657__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__6657__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__6657__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__6657__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__6658 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__6658__$1 = cljs.core.__destructure_map.call(null,map__6658);
var name = cljs.core.get.call(null,map__6658__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__6659){
var map__6660 = p__6659;
var map__6660__$1 = cljs.core.__destructure_map.call(null,map__6660);
var expr = cljs.core.get.call(null,map__6660__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__6660__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__6660__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_with_meta.call(null,expr,meta);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_.call(null,(function (p1__6661_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6661_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count.call(null,keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count.call(null,keys) === (0))){
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(distinct_keys_QMARK_.call(null,keys))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",comma_sep.call(null,keys),"],[",comma_sep.call(null,vals),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__6662){
var map__6663 = p__6662;
var map__6663__$1 = cljs.core.__destructure_map.call(null,map__6663);
var env = cljs.core.get.call(null,map__6663__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__6663__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__6663__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_map.call(null,keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.call(null,"cljs.core.list(",comma_sep.call(null,items),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count.call(null,items);
if((cnt < (32))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",comma_sep.call(null,items),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",comma_sep.call(null,items),"], true)");
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__6664){
var map__6665 = p__6664;
var map__6665__$1 = cljs.core.__destructure_map.call(null,map__6665);
var items = cljs.core.get.call(null,map__6665__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6665__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_vector.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_.call(null,(function (p1__6666_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6666_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count.call(null,items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(distinct_constants_QMARK_.call(null,items))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",comma_sep.call(null,items),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__6667){
var map__6668 = p__6667;
var map__6668__$1 = cljs.core.__destructure_map.call(null,map__6668);
var items = cljs.core.get.call(null,map__6668__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6668__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_set.call(null,items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.call(null,"({");

var temp__5753__auto___6691 = cljs.core.seq.call(null,items);
if(temp__5753__auto___6691){
var items_6692__$1 = temp__5753__auto___6691;
var vec__6669_6693 = items_6692__$1;
var seq__6670_6694 = cljs.core.seq.call(null,vec__6669_6693);
var first__6671_6695 = cljs.core.first.call(null,seq__6670_6694);
var seq__6670_6696__$1 = cljs.core.next.call(null,seq__6670_6694);
var vec__6672_6697 = first__6671_6695;
var k_6698 = cljs.core.nth.call(null,vec__6672_6697,(0),null);
var v_6699 = cljs.core.nth.call(null,vec__6672_6697,(1),null);
var r_6700 = seq__6670_6696__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_6698),"\": ",emit_js_object_val.call(null,v_6699));

var seq__6675_6701 = cljs.core.seq.call(null,r_6700);
var chunk__6676_6702 = null;
var count__6677_6703 = (0);
var i__6678_6704 = (0);
while(true){
if((i__6678_6704 < count__6677_6703)){
var vec__6685_6705 = cljs.core._nth.call(null,chunk__6676_6702,i__6678_6704);
var k_6706__$1 = cljs.core.nth.call(null,vec__6685_6705,(0),null);
var v_6707__$1 = cljs.core.nth.call(null,vec__6685_6705,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_6706__$1),"\": ",emit_js_object_val.call(null,v_6707__$1));


var G__6708 = seq__6675_6701;
var G__6709 = chunk__6676_6702;
var G__6710 = count__6677_6703;
var G__6711 = (i__6678_6704 + (1));
seq__6675_6701 = G__6708;
chunk__6676_6702 = G__6709;
count__6677_6703 = G__6710;
i__6678_6704 = G__6711;
continue;
} else {
var temp__5753__auto___6712__$1 = cljs.core.seq.call(null,seq__6675_6701);
if(temp__5753__auto___6712__$1){
var seq__6675_6713__$1 = temp__5753__auto___6712__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6675_6713__$1)){
var c__4679__auto___6714 = cljs.core.chunk_first.call(null,seq__6675_6713__$1);
var G__6715 = cljs.core.chunk_rest.call(null,seq__6675_6713__$1);
var G__6716 = c__4679__auto___6714;
var G__6717 = cljs.core.count.call(null,c__4679__auto___6714);
var G__6718 = (0);
seq__6675_6701 = G__6715;
chunk__6676_6702 = G__6716;
count__6677_6703 = G__6717;
i__6678_6704 = G__6718;
continue;
} else {
var vec__6688_6719 = cljs.core.first.call(null,seq__6675_6713__$1);
var k_6720__$1 = cljs.core.nth.call(null,vec__6688_6719,(0),null);
var v_6721__$1 = cljs.core.nth.call(null,vec__6688_6719,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_6720__$1),"\": ",emit_js_object_val.call(null,v_6721__$1));


var G__6722 = cljs.core.next.call(null,seq__6675_6713__$1);
var G__6723 = null;
var G__6724 = (0);
var G__6725 = (0);
seq__6675_6701 = G__6722;
chunk__6676_6702 = G__6723;
count__6677_6703 = G__6724;
i__6678_6704 = G__6725;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.call(null,"[",comma_sep.call(null,items),"]");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__6726){
var map__6727 = p__6726;
var map__6727__$1 = cljs.core.__destructure_map.call(null,map__6727);
var keys = cljs.core.get.call(null,map__6727__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__6727__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.call(null,map__6727__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_object.call(null,cljs.core.map.call(null,cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__6728){
var map__6729 = p__6728;
var map__6729__$1 = cljs.core.__destructure_map.call(null,map__6729);
var items = cljs.core.get.call(null,map__6729__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6729__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_array.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__6730){
var map__6731 = p__6730;
var map__6731__$1 = cljs.core.__destructure_map.call(null,map__6731);
var expr = cljs.core.get.call(null,map__6731__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__6732){
var map__6733 = p__6732;
var map__6733__$1 = cljs.core.__destructure_map.call(null,map__6733);
var form = cljs.core.get.call(null,map__6733__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__6733__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__6734 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__6734__$1 = cljs.core.__destructure_map.call(null,map__6734);
var op = cljs.core.get.call(null,map__6734__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__6734__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__6734__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4253__auto__ = (function (){var and__4251__auto__ = cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__4251__auto__){
var and__4251__auto____$1 = form;
if(cljs.core.truth_(and__4251__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.call(null,form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = (!((const_expr == null)));
if(and__4251__auto__){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return and__4251__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__6735 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__6735__$1 = cljs.core.__destructure_map.call(null,map__6735);
var op = cljs.core.get.call(null,map__6735__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__6735__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__6735__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4253__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4253__auto__){
return or__4253__auto__;
} else {
var and__4251__auto__ = (!((const_expr == null)));
if(and__4251__auto__){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return and__4251__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__4253__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__6736){
var map__6737 = p__6736;
var map__6737__$1 = cljs.core.__destructure_map.call(null,map__6737);
var test = cljs.core.get.call(null,map__6737__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__6737__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__6737__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__6737__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__6737__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__4253__auto__ = unchecked;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__6738){
var map__6739 = p__6738;
var map__6739__$1 = cljs.core.__destructure_map.call(null,map__6739);
var v = cljs.core.get.call(null,map__6739__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.call(null,map__6739__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.call(null,map__6739__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__6739__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__6740_6768 = cljs.core.seq.call(null,nodes);
var chunk__6741_6769 = null;
var count__6742_6770 = (0);
var i__6743_6771 = (0);
while(true){
if((i__6743_6771 < count__6742_6770)){
var map__6756_6772 = cljs.core._nth.call(null,chunk__6741_6769,i__6743_6771);
var map__6756_6773__$1 = cljs.core.__destructure_map.call(null,map__6756_6772);
var ts_6774 = cljs.core.get.call(null,map__6756_6773__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6757_6775 = cljs.core.get.call(null,map__6756_6773__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6757_6776__$1 = cljs.core.__destructure_map.call(null,map__6757_6775);
var then_6777 = cljs.core.get.call(null,map__6757_6776__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6758_6778 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_6774));
var chunk__6759_6779 = null;
var count__6760_6780 = (0);
var i__6761_6781 = (0);
while(true){
if((i__6761_6781 < count__6760_6780)){
var test_6782 = cljs.core._nth.call(null,chunk__6759_6779,i__6761_6781);
cljs.compiler.emitln.call(null,"case ",test_6782,":");


var G__6783 = seq__6758_6778;
var G__6784 = chunk__6759_6779;
var G__6785 = count__6760_6780;
var G__6786 = (i__6761_6781 + (1));
seq__6758_6778 = G__6783;
chunk__6759_6779 = G__6784;
count__6760_6780 = G__6785;
i__6761_6781 = G__6786;
continue;
} else {
var temp__5753__auto___6787 = cljs.core.seq.call(null,seq__6758_6778);
if(temp__5753__auto___6787){
var seq__6758_6788__$1 = temp__5753__auto___6787;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6758_6788__$1)){
var c__4679__auto___6789 = cljs.core.chunk_first.call(null,seq__6758_6788__$1);
var G__6790 = cljs.core.chunk_rest.call(null,seq__6758_6788__$1);
var G__6791 = c__4679__auto___6789;
var G__6792 = cljs.core.count.call(null,c__4679__auto___6789);
var G__6793 = (0);
seq__6758_6778 = G__6790;
chunk__6759_6779 = G__6791;
count__6760_6780 = G__6792;
i__6761_6781 = G__6793;
continue;
} else {
var test_6794 = cljs.core.first.call(null,seq__6758_6788__$1);
cljs.compiler.emitln.call(null,"case ",test_6794,":");


var G__6795 = cljs.core.next.call(null,seq__6758_6788__$1);
var G__6796 = null;
var G__6797 = (0);
var G__6798 = (0);
seq__6758_6778 = G__6795;
chunk__6759_6779 = G__6796;
count__6760_6780 = G__6797;
i__6761_6781 = G__6798;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_6777);
} else {
cljs.compiler.emitln.call(null,then_6777);
}

cljs.compiler.emitln.call(null,"break;");


var G__6799 = seq__6740_6768;
var G__6800 = chunk__6741_6769;
var G__6801 = count__6742_6770;
var G__6802 = (i__6743_6771 + (1));
seq__6740_6768 = G__6799;
chunk__6741_6769 = G__6800;
count__6742_6770 = G__6801;
i__6743_6771 = G__6802;
continue;
} else {
var temp__5753__auto___6803 = cljs.core.seq.call(null,seq__6740_6768);
if(temp__5753__auto___6803){
var seq__6740_6804__$1 = temp__5753__auto___6803;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6740_6804__$1)){
var c__4679__auto___6805 = cljs.core.chunk_first.call(null,seq__6740_6804__$1);
var G__6806 = cljs.core.chunk_rest.call(null,seq__6740_6804__$1);
var G__6807 = c__4679__auto___6805;
var G__6808 = cljs.core.count.call(null,c__4679__auto___6805);
var G__6809 = (0);
seq__6740_6768 = G__6806;
chunk__6741_6769 = G__6807;
count__6742_6770 = G__6808;
i__6743_6771 = G__6809;
continue;
} else {
var map__6762_6810 = cljs.core.first.call(null,seq__6740_6804__$1);
var map__6762_6811__$1 = cljs.core.__destructure_map.call(null,map__6762_6810);
var ts_6812 = cljs.core.get.call(null,map__6762_6811__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6763_6813 = cljs.core.get.call(null,map__6762_6811__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6763_6814__$1 = cljs.core.__destructure_map.call(null,map__6763_6813);
var then_6815 = cljs.core.get.call(null,map__6763_6814__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6764_6816 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_6812));
var chunk__6765_6817 = null;
var count__6766_6818 = (0);
var i__6767_6819 = (0);
while(true){
if((i__6767_6819 < count__6766_6818)){
var test_6820 = cljs.core._nth.call(null,chunk__6765_6817,i__6767_6819);
cljs.compiler.emitln.call(null,"case ",test_6820,":");


var G__6821 = seq__6764_6816;
var G__6822 = chunk__6765_6817;
var G__6823 = count__6766_6818;
var G__6824 = (i__6767_6819 + (1));
seq__6764_6816 = G__6821;
chunk__6765_6817 = G__6822;
count__6766_6818 = G__6823;
i__6767_6819 = G__6824;
continue;
} else {
var temp__5753__auto___6825__$1 = cljs.core.seq.call(null,seq__6764_6816);
if(temp__5753__auto___6825__$1){
var seq__6764_6826__$1 = temp__5753__auto___6825__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6764_6826__$1)){
var c__4679__auto___6827 = cljs.core.chunk_first.call(null,seq__6764_6826__$1);
var G__6828 = cljs.core.chunk_rest.call(null,seq__6764_6826__$1);
var G__6829 = c__4679__auto___6827;
var G__6830 = cljs.core.count.call(null,c__4679__auto___6827);
var G__6831 = (0);
seq__6764_6816 = G__6828;
chunk__6765_6817 = G__6829;
count__6766_6818 = G__6830;
i__6767_6819 = G__6831;
continue;
} else {
var test_6832 = cljs.core.first.call(null,seq__6764_6826__$1);
cljs.compiler.emitln.call(null,"case ",test_6832,":");


var G__6833 = cljs.core.next.call(null,seq__6764_6826__$1);
var G__6834 = null;
var G__6835 = (0);
var G__6836 = (0);
seq__6764_6816 = G__6833;
chunk__6765_6817 = G__6834;
count__6766_6818 = G__6835;
i__6767_6819 = G__6836;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_6815);
} else {
cljs.compiler.emitln.call(null,then_6815);
}

cljs.compiler.emitln.call(null,"break;");


var G__6837 = cljs.core.next.call(null,seq__6740_6804__$1);
var G__6838 = null;
var G__6839 = (0);
var G__6840 = (0);
seq__6740_6768 = G__6837;
chunk__6741_6769 = G__6838;
count__6742_6770 = G__6839;
i__6743_6771 = G__6840;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__6841){
var map__6842 = p__6841;
var map__6842__$1 = cljs.core.__destructure_map.call(null,map__6842);
var throw$ = cljs.core.get.call(null,map__6842__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.call(null,map__6842__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__6844 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__6844,(0),null);
var rstr = cljs.core.nth.call(null,vec__6844,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,(function (p1__6843_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__6843_SHARP_);
}),clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__6847 = ["function(",clojure.string.join.call(null,",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__6847,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__6847;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",clojure.string.join.call(null,"|",cljs.core.map.call(null,(function (p1__6848_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__6848_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__6849 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__6850 = cljs.core.seq.call(null,vec__6849);
var first__6851 = cljs.core.first.call(null,seq__6850);
var seq__6850__$1 = cljs.core.next.call(null,seq__6850);
var p = first__6851;
var first__6851__$1 = cljs.core.first.call(null,seq__6850__$1);
var seq__6850__$2 = cljs.core.next.call(null,seq__6850__$1);
var ts = first__6851__$1;
var first__6851__$2 = cljs.core.first.call(null,seq__6850__$2);
var seq__6850__$3 = cljs.core.next.call(null,seq__6850__$2);
var n = first__6851__$2;
var xs = seq__6850__$3;
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.call(null,"@param",p);
if(and__4251__auto__){
var and__4251__auto____$1 = ts;
if(cljs.core.truth_(and__4251__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__6852 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__6853 = cljs.core.seq.call(null,vec__6852);
var first__6854 = cljs.core.first.call(null,seq__6853);
var seq__6853__$1 = cljs.core.next.call(null,seq__6853);
var p = first__6854;
var first__6854__$1 = cljs.core.first.call(null,seq__6853__$1);
var seq__6853__$2 = cljs.core.next.call(null,seq__6853__$1);
var ts = first__6854__$1;
var xs = seq__6853__$2;
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.call(null,"@return",p);
if(and__4251__auto__){
var and__4251__auto____$1 = ts;
if(cljs.core.truth_(and__4251__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__6857 = arguments.length;
switch (G__6857) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__6865 = cljs.core.map.call(null,(function (p1__6855_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__6855_SHARP_);
} else {
return p1__6855_SHARP_;
}
}),clojure.string.split_lines.call(null,e));
var seq__6866 = cljs.core.seq.call(null,vec__6865);
var first__6867 = cljs.core.first.call(null,seq__6866);
var seq__6866__$1 = cljs.core.next.call(null,seq__6866);
var x = first__6867;
var ys = seq__6866__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__6868 = cljs.core.seq.call(null,ys);
var chunk__6869 = null;
var count__6870 = (0);
var i__6871 = (0);
while(true){
if((i__6871 < count__6870)){
var next_line = cljs.core._nth.call(null,chunk__6869,i__6871);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__6877 = seq__6868;
var G__6878 = chunk__6869;
var G__6879 = count__6870;
var G__6880 = (i__6871 + (1));
seq__6868 = G__6877;
chunk__6869 = G__6878;
count__6870 = G__6879;
i__6871 = G__6880;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__6868);
if(temp__5753__auto__){
var seq__6868__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6868__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__6868__$1);
var G__6881 = cljs.core.chunk_rest.call(null,seq__6868__$1);
var G__6882 = c__4679__auto__;
var G__6883 = cljs.core.count.call(null,c__4679__auto__);
var G__6884 = (0);
seq__6868 = G__6881;
chunk__6869 = G__6882;
count__6870 = G__6883;
i__6871 = G__6884;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__6868__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__6885 = cljs.core.next.call(null,seq__6868__$1);
var G__6886 = null;
var G__6887 = (0);
var G__6888 = (0);
seq__6868 = G__6885;
chunk__6869 = G__6886;
count__6870 = G__6887;
i__6871 = G__6888;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__6872_6889 = cljs.core.seq.call(null,docs__$2);
var chunk__6873_6890 = null;
var count__6874_6891 = (0);
var i__6875_6892 = (0);
while(true){
if((i__6875_6892 < count__6874_6891)){
var e_6893 = cljs.core._nth.call(null,chunk__6873_6890,i__6875_6892);
if(cljs.core.truth_(e_6893)){
print_comment_lines.call(null,e_6893);
} else {
}


var G__6894 = seq__6872_6889;
var G__6895 = chunk__6873_6890;
var G__6896 = count__6874_6891;
var G__6897 = (i__6875_6892 + (1));
seq__6872_6889 = G__6894;
chunk__6873_6890 = G__6895;
count__6874_6891 = G__6896;
i__6875_6892 = G__6897;
continue;
} else {
var temp__5753__auto___6898 = cljs.core.seq.call(null,seq__6872_6889);
if(temp__5753__auto___6898){
var seq__6872_6899__$1 = temp__5753__auto___6898;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6872_6899__$1)){
var c__4679__auto___6900 = cljs.core.chunk_first.call(null,seq__6872_6899__$1);
var G__6901 = cljs.core.chunk_rest.call(null,seq__6872_6899__$1);
var G__6902 = c__4679__auto___6900;
var G__6903 = cljs.core.count.call(null,c__4679__auto___6900);
var G__6904 = (0);
seq__6872_6889 = G__6901;
chunk__6873_6890 = G__6902;
count__6874_6891 = G__6903;
i__6875_6892 = G__6904;
continue;
} else {
var e_6905 = cljs.core.first.call(null,seq__6872_6899__$1);
if(cljs.core.truth_(e_6905)){
print_comment_lines.call(null,e_6905);
} else {
}


var G__6906 = cljs.core.next.call(null,seq__6872_6899__$1);
var G__6907 = null;
var G__6908 = (0);
var G__6909 = (0);
seq__6872_6889 = G__6906;
chunk__6873_6890 = G__6907;
count__6874_6891 = G__6908;
i__6875_6892 = G__6909;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4251__auto__ = cljs.core.some.call(null,(function (p1__6911_SHARP_){
return goog.string.startsWith(p1__6911_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = opts;
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__4251__auto____$2){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_.call(null,define)){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__6912){
var map__6913 = p__6912;
var map__6913__$1 = cljs.core.__destructure_map.call(null,map__6913);
var doc = cljs.core.get.call(null,map__6913__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__6913__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.call(null,map__6913__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.call(null,map__6913__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.call(null,map__6913__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.call(null,map__6913__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__6913__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.call(null,map__6913__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.call(null,map__6913__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.call(null,map__6913__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4253__auto__ = init;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,(cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
return test;
} else {
return and__4251__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__6914){
var map__6915 = p__6914;
var map__6915__$1 = cljs.core.__destructure_map.call(null,map__6915);
var name = cljs.core.get.call(null,map__6915__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__6915__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__6915__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__6916_6940 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__6917_6941 = null;
var count__6918_6942 = (0);
var i__6919_6943 = (0);
while(true){
if((i__6919_6943 < count__6918_6942)){
var vec__6926_6944 = cljs.core._nth.call(null,chunk__6917_6941,i__6919_6943);
var i_6945 = cljs.core.nth.call(null,vec__6926_6944,(0),null);
var param_6946 = cljs.core.nth.call(null,vec__6926_6944,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_6946);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__6947 = seq__6916_6940;
var G__6948 = chunk__6917_6941;
var G__6949 = count__6918_6942;
var G__6950 = (i__6919_6943 + (1));
seq__6916_6940 = G__6947;
chunk__6917_6941 = G__6948;
count__6918_6942 = G__6949;
i__6919_6943 = G__6950;
continue;
} else {
var temp__5753__auto___6951 = cljs.core.seq.call(null,seq__6916_6940);
if(temp__5753__auto___6951){
var seq__6916_6952__$1 = temp__5753__auto___6951;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6916_6952__$1)){
var c__4679__auto___6953 = cljs.core.chunk_first.call(null,seq__6916_6952__$1);
var G__6954 = cljs.core.chunk_rest.call(null,seq__6916_6952__$1);
var G__6955 = c__4679__auto___6953;
var G__6956 = cljs.core.count.call(null,c__4679__auto___6953);
var G__6957 = (0);
seq__6916_6940 = G__6954;
chunk__6917_6941 = G__6955;
count__6918_6942 = G__6956;
i__6919_6943 = G__6957;
continue;
} else {
var vec__6929_6958 = cljs.core.first.call(null,seq__6916_6952__$1);
var i_6959 = cljs.core.nth.call(null,vec__6929_6958,(0),null);
var param_6960 = cljs.core.nth.call(null,vec__6929_6958,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_6960);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__6961 = cljs.core.next.call(null,seq__6916_6952__$1);
var G__6962 = null;
var G__6963 = (0);
var G__6964 = (0);
seq__6916_6940 = G__6961;
chunk__6917_6941 = G__6962;
count__6918_6942 = G__6963;
i__6919_6943 = G__6964;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__6932_6965 = cljs.core.seq.call(null,params);
var chunk__6933_6966 = null;
var count__6934_6967 = (0);
var i__6935_6968 = (0);
while(true){
if((i__6935_6968 < count__6934_6967)){
var param_6969 = cljs.core._nth.call(null,chunk__6933_6966,i__6935_6968);
cljs.compiler.emit.call(null,param_6969);

if(cljs.core._EQ_.call(null,param_6969,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6970 = seq__6932_6965;
var G__6971 = chunk__6933_6966;
var G__6972 = count__6934_6967;
var G__6973 = (i__6935_6968 + (1));
seq__6932_6965 = G__6970;
chunk__6933_6966 = G__6971;
count__6934_6967 = G__6972;
i__6935_6968 = G__6973;
continue;
} else {
var temp__5753__auto___6974 = cljs.core.seq.call(null,seq__6932_6965);
if(temp__5753__auto___6974){
var seq__6932_6975__$1 = temp__5753__auto___6974;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6932_6975__$1)){
var c__4679__auto___6976 = cljs.core.chunk_first.call(null,seq__6932_6975__$1);
var G__6977 = cljs.core.chunk_rest.call(null,seq__6932_6975__$1);
var G__6978 = c__4679__auto___6976;
var G__6979 = cljs.core.count.call(null,c__4679__auto___6976);
var G__6980 = (0);
seq__6932_6965 = G__6977;
chunk__6933_6966 = G__6978;
count__6934_6967 = G__6979;
i__6935_6968 = G__6980;
continue;
} else {
var param_6981 = cljs.core.first.call(null,seq__6932_6975__$1);
cljs.compiler.emit.call(null,param_6981);

if(cljs.core._EQ_.call(null,param_6981,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6982 = cljs.core.next.call(null,seq__6932_6975__$1);
var G__6983 = null;
var G__6984 = (0);
var G__6985 = (0);
seq__6932_6965 = G__6982;
chunk__6933_6966 = G__6983;
count__6934_6967 = G__6984;
i__6935_6968 = G__6985;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__6936_6986 = cljs.core.seq.call(null,params);
var chunk__6937_6987 = null;
var count__6938_6988 = (0);
var i__6939_6989 = (0);
while(true){
if((i__6939_6989 < count__6938_6988)){
var param_6990 = cljs.core._nth.call(null,chunk__6937_6987,i__6939_6989);
cljs.compiler.emit.call(null,param_6990);

if(cljs.core._EQ_.call(null,param_6990,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6991 = seq__6936_6986;
var G__6992 = chunk__6937_6987;
var G__6993 = count__6938_6988;
var G__6994 = (i__6939_6989 + (1));
seq__6936_6986 = G__6991;
chunk__6937_6987 = G__6992;
count__6938_6988 = G__6993;
i__6939_6989 = G__6994;
continue;
} else {
var temp__5753__auto___6995 = cljs.core.seq.call(null,seq__6936_6986);
if(temp__5753__auto___6995){
var seq__6936_6996__$1 = temp__5753__auto___6995;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6936_6996__$1)){
var c__4679__auto___6997 = cljs.core.chunk_first.call(null,seq__6936_6996__$1);
var G__6998 = cljs.core.chunk_rest.call(null,seq__6936_6996__$1);
var G__6999 = c__4679__auto___6997;
var G__7000 = cljs.core.count.call(null,c__4679__auto___6997);
var G__7001 = (0);
seq__6936_6986 = G__6998;
chunk__6937_6987 = G__6999;
count__6938_6988 = G__7000;
i__6939_6989 = G__7001;
continue;
} else {
var param_7002 = cljs.core.first.call(null,seq__6936_6996__$1);
cljs.compiler.emit.call(null,param_7002);

if(cljs.core._EQ_.call(null,param_7002,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7003 = cljs.core.next.call(null,seq__6936_6996__$1);
var G__7004 = null;
var G__7005 = (0);
var G__7006 = (0);
seq__6936_6986 = G__7003;
chunk__6937_6987 = G__7004;
count__6938_6988 = G__7005;
i__6939_6989 = G__7006;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__7007 = cljs.core.seq.call(null,params);
var chunk__7008 = null;
var count__7009 = (0);
var i__7010 = (0);
while(true){
if((i__7010 < count__7009)){
var param = cljs.core._nth.call(null,chunk__7008,i__7010);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7011 = seq__7007;
var G__7012 = chunk__7008;
var G__7013 = count__7009;
var G__7014 = (i__7010 + (1));
seq__7007 = G__7011;
chunk__7008 = G__7012;
count__7009 = G__7013;
i__7010 = G__7014;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__7007);
if(temp__5753__auto__){
var seq__7007__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7007__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__7007__$1);
var G__7015 = cljs.core.chunk_rest.call(null,seq__7007__$1);
var G__7016 = c__4679__auto__;
var G__7017 = cljs.core.count.call(null,c__4679__auto__);
var G__7018 = (0);
seq__7007 = G__7015;
chunk__7008 = G__7016;
count__7009 = G__7017;
i__7010 = G__7018;
continue;
} else {
var param = cljs.core.first.call(null,seq__7007__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7019 = cljs.core.next.call(null,seq__7007__$1);
var G__7020 = null;
var G__7021 = (0);
var G__7022 = (0);
seq__7007 = G__7019;
chunk__7008 = G__7020;
count__7009 = G__7021;
i__7010 = G__7022;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__7023){
var map__7024 = p__7023;
var map__7024__$1 = cljs.core.__destructure_map.call(null,map__7024);
var expr = cljs.core.get.call(null,map__7024__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.call(null,map__7024__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__7024__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7024__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7024__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__7024__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__7025){
var map__7026 = p__7025;
var map__7026__$1 = cljs.core.__destructure_map.call(null,map__7026);
var f = map__7026__$1;
var expr = cljs.core.get.call(null,map__7026__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.call(null,map__7026__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.call(null,map__7026__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.call(null,map__7026__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__7026__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7026__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7026__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__7026__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_7035__$1 = (function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_7036 = cljs.compiler.munge.call(null,name_7035__$1);
var delegate_name_7037 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7036),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_7037," = function (");

var seq__7027_7038 = cljs.core.seq.call(null,params);
var chunk__7028_7039 = null;
var count__7029_7040 = (0);
var i__7030_7041 = (0);
while(true){
if((i__7030_7041 < count__7029_7040)){
var param_7042 = cljs.core._nth.call(null,chunk__7028_7039,i__7030_7041);
cljs.compiler.emit.call(null,param_7042);

if(cljs.core._EQ_.call(null,param_7042,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7043 = seq__7027_7038;
var G__7044 = chunk__7028_7039;
var G__7045 = count__7029_7040;
var G__7046 = (i__7030_7041 + (1));
seq__7027_7038 = G__7043;
chunk__7028_7039 = G__7044;
count__7029_7040 = G__7045;
i__7030_7041 = G__7046;
continue;
} else {
var temp__5753__auto___7047 = cljs.core.seq.call(null,seq__7027_7038);
if(temp__5753__auto___7047){
var seq__7027_7048__$1 = temp__5753__auto___7047;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7027_7048__$1)){
var c__4679__auto___7049 = cljs.core.chunk_first.call(null,seq__7027_7048__$1);
var G__7050 = cljs.core.chunk_rest.call(null,seq__7027_7048__$1);
var G__7051 = c__4679__auto___7049;
var G__7052 = cljs.core.count.call(null,c__4679__auto___7049);
var G__7053 = (0);
seq__7027_7038 = G__7050;
chunk__7028_7039 = G__7051;
count__7029_7040 = G__7052;
i__7030_7041 = G__7053;
continue;
} else {
var param_7054 = cljs.core.first.call(null,seq__7027_7048__$1);
cljs.compiler.emit.call(null,param_7054);

if(cljs.core._EQ_.call(null,param_7054,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7055 = cljs.core.next.call(null,seq__7027_7048__$1);
var G__7056 = null;
var G__7057 = (0);
var G__7058 = (0);
seq__7027_7038 = G__7055;
chunk__7028_7039 = G__7056;
count__7029_7040 = G__7057;
i__7030_7041 = G__7058;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_7036," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_7059 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_7059,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_7037,".call(this,");

var seq__7031_7060 = cljs.core.seq.call(null,params);
var chunk__7032_7061 = null;
var count__7033_7062 = (0);
var i__7034_7063 = (0);
while(true){
if((i__7034_7063 < count__7033_7062)){
var param_7064 = cljs.core._nth.call(null,chunk__7032_7061,i__7034_7063);
cljs.compiler.emit.call(null,param_7064);

if(cljs.core._EQ_.call(null,param_7064,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7065 = seq__7031_7060;
var G__7066 = chunk__7032_7061;
var G__7067 = count__7033_7062;
var G__7068 = (i__7034_7063 + (1));
seq__7031_7060 = G__7065;
chunk__7032_7061 = G__7066;
count__7033_7062 = G__7067;
i__7034_7063 = G__7068;
continue;
} else {
var temp__5753__auto___7069 = cljs.core.seq.call(null,seq__7031_7060);
if(temp__5753__auto___7069){
var seq__7031_7070__$1 = temp__5753__auto___7069;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7031_7070__$1)){
var c__4679__auto___7071 = cljs.core.chunk_first.call(null,seq__7031_7070__$1);
var G__7072 = cljs.core.chunk_rest.call(null,seq__7031_7070__$1);
var G__7073 = c__4679__auto___7071;
var G__7074 = cljs.core.count.call(null,c__4679__auto___7071);
var G__7075 = (0);
seq__7031_7060 = G__7072;
chunk__7032_7061 = G__7073;
count__7033_7062 = G__7074;
i__7034_7063 = G__7075;
continue;
} else {
var param_7076 = cljs.core.first.call(null,seq__7031_7070__$1);
cljs.compiler.emit.call(null,param_7076);

if(cljs.core._EQ_.call(null,param_7076,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7077 = cljs.core.next.call(null,seq__7031_7070__$1);
var G__7078 = null;
var G__7079 = (0);
var G__7080 = (0);
seq__7031_7060 = G__7077;
chunk__7032_7061 = G__7078;
count__7033_7062 = G__7079;
i__7034_7063 = G__7080;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_7036,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_7036,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_7035__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_7036,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_7037,";");

cljs.compiler.emitln.call(null,"return ",mname_7036,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__7084){
var map__7085 = p__7084;
var map__7085__$1 = cljs.core.__destructure_map.call(null,map__7085);
var variadic = cljs.core.get.call(null,map__7085__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.call(null,map__7085__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__7085__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__7085__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__7085__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.call(null,map__7085__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.call(null,map__7085__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.call(null,map__7085__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,(function (p1__7081_SHARP_){
var and__4251__auto__ = p1__7081_SHARP_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__7081_SHARP_));
} else {
return and__4251__auto__;
}
}),recur_frames));
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,recur_params,(cljs.core.truth_((function (){var or__4253__auto__ = in_loop;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.seq.call(null,recur_params);
}
})())?cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets):null))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_7137__$1 = (function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_7138 = cljs.compiler.munge.call(null,name_7137__$1);
var maxparams_7139 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_7140 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7138),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_7141 = cljs.core.sort_by.call(null,(function (p1__7082_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__7082_SHARP_)));
}),cljs.core.seq.call(null,mmap_7140));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_7138," = null;");

var seq__7086_7142 = cljs.core.seq.call(null,ms_7141);
var chunk__7087_7143 = null;
var count__7088_7144 = (0);
var i__7089_7145 = (0);
while(true){
if((i__7089_7145 < count__7088_7144)){
var vec__7096_7146 = cljs.core._nth.call(null,chunk__7087_7143,i__7089_7145);
var n_7147 = cljs.core.nth.call(null,vec__7096_7146,(0),null);
var meth_7148 = cljs.core.nth.call(null,vec__7096_7146,(1),null);
cljs.compiler.emits.call(null,"var ",n_7147," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7148))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_7148);
} else {
cljs.compiler.emit_fn_method.call(null,meth_7148);
}

cljs.compiler.emitln.call(null,";");


var G__7149 = seq__7086_7142;
var G__7150 = chunk__7087_7143;
var G__7151 = count__7088_7144;
var G__7152 = (i__7089_7145 + (1));
seq__7086_7142 = G__7149;
chunk__7087_7143 = G__7150;
count__7088_7144 = G__7151;
i__7089_7145 = G__7152;
continue;
} else {
var temp__5753__auto___7153 = cljs.core.seq.call(null,seq__7086_7142);
if(temp__5753__auto___7153){
var seq__7086_7154__$1 = temp__5753__auto___7153;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7086_7154__$1)){
var c__4679__auto___7155 = cljs.core.chunk_first.call(null,seq__7086_7154__$1);
var G__7156 = cljs.core.chunk_rest.call(null,seq__7086_7154__$1);
var G__7157 = c__4679__auto___7155;
var G__7158 = cljs.core.count.call(null,c__4679__auto___7155);
var G__7159 = (0);
seq__7086_7142 = G__7156;
chunk__7087_7143 = G__7157;
count__7088_7144 = G__7158;
i__7089_7145 = G__7159;
continue;
} else {
var vec__7099_7160 = cljs.core.first.call(null,seq__7086_7154__$1);
var n_7161 = cljs.core.nth.call(null,vec__7099_7160,(0),null);
var meth_7162 = cljs.core.nth.call(null,vec__7099_7160,(1),null);
cljs.compiler.emits.call(null,"var ",n_7161," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7162))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_7162);
} else {
cljs.compiler.emit_fn_method.call(null,meth_7162);
}

cljs.compiler.emitln.call(null,";");


var G__7163 = cljs.core.next.call(null,seq__7086_7154__$1);
var G__7164 = null;
var G__7165 = (0);
var G__7166 = (0);
seq__7086_7142 = G__7163;
chunk__7087_7143 = G__7164;
count__7088_7144 = G__7165;
i__7089_7145 = G__7166;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_7138," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_7139),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_7139)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_7139));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__7102_7167 = cljs.core.seq.call(null,ms_7141);
var chunk__7103_7168 = null;
var count__7104_7169 = (0);
var i__7105_7170 = (0);
while(true){
if((i__7105_7170 < count__7104_7169)){
var vec__7112_7171 = cljs.core._nth.call(null,chunk__7103_7168,i__7105_7170);
var n_7172 = cljs.core.nth.call(null,vec__7112_7171,(0),null);
var meth_7173 = cljs.core.nth.call(null,vec__7112_7171,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7173))){
cljs.compiler.emitln.call(null,"default:");

var restarg_7174 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_7174," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_7175 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_7174," = new cljs.core.IndexedSeq(",a_7175,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_7172,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_7139)),(((cljs.core.count.call(null,maxparams_7139) > (1)))?", ":null),restarg_7174,");");
} else {
var pcnt_7176 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7173));
cljs.compiler.emitln.call(null,"case ",pcnt_7176,":");

cljs.compiler.emitln.call(null,"return ",n_7172,".call(this",(((pcnt_7176 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_7176,maxparams_7139)),null,(1),null)),(2),null))),");");
}


var G__7177 = seq__7102_7167;
var G__7178 = chunk__7103_7168;
var G__7179 = count__7104_7169;
var G__7180 = (i__7105_7170 + (1));
seq__7102_7167 = G__7177;
chunk__7103_7168 = G__7178;
count__7104_7169 = G__7179;
i__7105_7170 = G__7180;
continue;
} else {
var temp__5753__auto___7181 = cljs.core.seq.call(null,seq__7102_7167);
if(temp__5753__auto___7181){
var seq__7102_7182__$1 = temp__5753__auto___7181;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7102_7182__$1)){
var c__4679__auto___7183 = cljs.core.chunk_first.call(null,seq__7102_7182__$1);
var G__7184 = cljs.core.chunk_rest.call(null,seq__7102_7182__$1);
var G__7185 = c__4679__auto___7183;
var G__7186 = cljs.core.count.call(null,c__4679__auto___7183);
var G__7187 = (0);
seq__7102_7167 = G__7184;
chunk__7103_7168 = G__7185;
count__7104_7169 = G__7186;
i__7105_7170 = G__7187;
continue;
} else {
var vec__7115_7188 = cljs.core.first.call(null,seq__7102_7182__$1);
var n_7189 = cljs.core.nth.call(null,vec__7115_7188,(0),null);
var meth_7190 = cljs.core.nth.call(null,vec__7115_7188,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7190))){
cljs.compiler.emitln.call(null,"default:");

var restarg_7191 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_7191," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_7192 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_7191," = new cljs.core.IndexedSeq(",a_7192,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_7189,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_7139)),(((cljs.core.count.call(null,maxparams_7139) > (1)))?", ":null),restarg_7191,");");
} else {
var pcnt_7193 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7190));
cljs.compiler.emitln.call(null,"case ",pcnt_7193,":");

cljs.compiler.emitln.call(null,"return ",n_7189,".call(this",(((pcnt_7193 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_7193,maxparams_7139)),null,(1),null)),(2),null))),");");
}


var G__7194 = cljs.core.next.call(null,seq__7102_7182__$1);
var G__7195 = null;
var G__7196 = (0);
var G__7197 = (0);
seq__7102_7167 = G__7194;
chunk__7103_7168 = G__7195;
count__7104_7169 = G__7196;
i__7105_7170 = G__7197;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

var arg_count_js_7198 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,cljs.core.first.call(null,ms_7141)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + ",arg_count_js_7198,"));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_7138,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_7138,".cljs$lang$applyTo = ",cljs.core.some.call(null,(function (p1__7083_SHARP_){
var vec__7118 = p1__7083_SHARP_;
var n = cljs.core.nth.call(null,vec__7118,(0),null);
var m = cljs.core.nth.call(null,vec__7118,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_7141),".cljs$lang$applyTo;");
} else {
}

var seq__7121_7199 = cljs.core.seq.call(null,ms_7141);
var chunk__7122_7200 = null;
var count__7123_7201 = (0);
var i__7124_7202 = (0);
while(true){
if((i__7124_7202 < count__7123_7201)){
var vec__7131_7203 = cljs.core._nth.call(null,chunk__7122_7200,i__7124_7202);
var n_7204 = cljs.core.nth.call(null,vec__7131_7203,(0),null);
var meth_7205 = cljs.core.nth.call(null,vec__7131_7203,(1),null);
var c_7206 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7205));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7205))){
cljs.compiler.emitln.call(null,mname_7138,".cljs$core$IFn$_invoke$arity$variadic = ",n_7204,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_7138,".cljs$core$IFn$_invoke$arity$",c_7206," = ",n_7204,";");
}


var G__7207 = seq__7121_7199;
var G__7208 = chunk__7122_7200;
var G__7209 = count__7123_7201;
var G__7210 = (i__7124_7202 + (1));
seq__7121_7199 = G__7207;
chunk__7122_7200 = G__7208;
count__7123_7201 = G__7209;
i__7124_7202 = G__7210;
continue;
} else {
var temp__5753__auto___7211 = cljs.core.seq.call(null,seq__7121_7199);
if(temp__5753__auto___7211){
var seq__7121_7212__$1 = temp__5753__auto___7211;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7121_7212__$1)){
var c__4679__auto___7213 = cljs.core.chunk_first.call(null,seq__7121_7212__$1);
var G__7214 = cljs.core.chunk_rest.call(null,seq__7121_7212__$1);
var G__7215 = c__4679__auto___7213;
var G__7216 = cljs.core.count.call(null,c__4679__auto___7213);
var G__7217 = (0);
seq__7121_7199 = G__7214;
chunk__7122_7200 = G__7215;
count__7123_7201 = G__7216;
i__7124_7202 = G__7217;
continue;
} else {
var vec__7134_7218 = cljs.core.first.call(null,seq__7121_7212__$1);
var n_7219 = cljs.core.nth.call(null,vec__7134_7218,(0),null);
var meth_7220 = cljs.core.nth.call(null,vec__7134_7218,(1),null);
var c_7221 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7220));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7220))){
cljs.compiler.emitln.call(null,mname_7138,".cljs$core$IFn$_invoke$arity$variadic = ",n_7219,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_7138,".cljs$core$IFn$_invoke$arity$",c_7221," = ",n_7219,";");
}


var G__7222 = cljs.core.next.call(null,seq__7121_7212__$1);
var G__7223 = null;
var G__7224 = (0);
var G__7225 = (0);
seq__7121_7199 = G__7222;
chunk__7122_7200 = G__7223;
count__7123_7201 = G__7224;
i__7124_7202 = G__7225;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_7138,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__7226){
var map__7227 = p__7226;
var map__7227__$1 = cljs.core.__destructure_map.call(null,map__7227);
var statements = cljs.core.get.call(null,map__7227__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__7227__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__7227__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__7228_7232 = cljs.core.seq.call(null,statements);
var chunk__7229_7233 = null;
var count__7230_7234 = (0);
var i__7231_7235 = (0);
while(true){
if((i__7231_7235 < count__7230_7234)){
var s_7236 = cljs.core._nth.call(null,chunk__7229_7233,i__7231_7235);
cljs.compiler.emitln.call(null,s_7236);


var G__7237 = seq__7228_7232;
var G__7238 = chunk__7229_7233;
var G__7239 = count__7230_7234;
var G__7240 = (i__7231_7235 + (1));
seq__7228_7232 = G__7237;
chunk__7229_7233 = G__7238;
count__7230_7234 = G__7239;
i__7231_7235 = G__7240;
continue;
} else {
var temp__5753__auto___7241 = cljs.core.seq.call(null,seq__7228_7232);
if(temp__5753__auto___7241){
var seq__7228_7242__$1 = temp__5753__auto___7241;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7228_7242__$1)){
var c__4679__auto___7243 = cljs.core.chunk_first.call(null,seq__7228_7242__$1);
var G__7244 = cljs.core.chunk_rest.call(null,seq__7228_7242__$1);
var G__7245 = c__4679__auto___7243;
var G__7246 = cljs.core.count.call(null,c__4679__auto___7243);
var G__7247 = (0);
seq__7228_7232 = G__7244;
chunk__7229_7233 = G__7245;
count__7230_7234 = G__7246;
i__7231_7235 = G__7247;
continue;
} else {
var s_7248 = cljs.core.first.call(null,seq__7228_7242__$1);
cljs.compiler.emitln.call(null,s_7248);


var G__7249 = cljs.core.next.call(null,seq__7228_7242__$1);
var G__7250 = null;
var G__7251 = (0);
var G__7252 = (0);
seq__7228_7232 = G__7249;
chunk__7229_7233 = G__7250;
count__7230_7234 = G__7251;
i__7231_7235 = G__7252;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__7253){
var map__7254 = p__7253;
var map__7254__$1 = cljs.core.__destructure_map.call(null,map__7254);
var try$ = cljs.core.get.call(null,map__7254__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.call(null,map__7254__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.call(null,map__7254__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__7254__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__7254__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote.call(null,finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__7255,is_loop){
var map__7256 = p__7255;
var map__7256__$1 = cljs.core.__destructure_map.call(null,map__7256);
var expr = cljs.core.get.call(null,map__7256__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__7256__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__7256__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__7257_7267 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__7258_7268 = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,(function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__7258_7268);

try{var seq__7259_7269 = cljs.core.seq.call(null,bindings);
var chunk__7260_7270 = null;
var count__7261_7271 = (0);
var i__7262_7272 = (0);
while(true){
if((i__7262_7272 < count__7261_7271)){
var map__7265_7273 = cljs.core._nth.call(null,chunk__7260_7270,i__7262_7272);
var map__7265_7274__$1 = cljs.core.__destructure_map.call(null,map__7265_7273);
var binding_7275 = map__7265_7274__$1;
var init_7276 = cljs.core.get.call(null,map__7265_7274__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_7275);

cljs.compiler.emitln.call(null," = ",init_7276,";");


var G__7277 = seq__7259_7269;
var G__7278 = chunk__7260_7270;
var G__7279 = count__7261_7271;
var G__7280 = (i__7262_7272 + (1));
seq__7259_7269 = G__7277;
chunk__7260_7270 = G__7278;
count__7261_7271 = G__7279;
i__7262_7272 = G__7280;
continue;
} else {
var temp__5753__auto___7281 = cljs.core.seq.call(null,seq__7259_7269);
if(temp__5753__auto___7281){
var seq__7259_7282__$1 = temp__5753__auto___7281;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7259_7282__$1)){
var c__4679__auto___7283 = cljs.core.chunk_first.call(null,seq__7259_7282__$1);
var G__7284 = cljs.core.chunk_rest.call(null,seq__7259_7282__$1);
var G__7285 = c__4679__auto___7283;
var G__7286 = cljs.core.count.call(null,c__4679__auto___7283);
var G__7287 = (0);
seq__7259_7269 = G__7284;
chunk__7260_7270 = G__7285;
count__7261_7271 = G__7286;
i__7262_7272 = G__7287;
continue;
} else {
var map__7266_7288 = cljs.core.first.call(null,seq__7259_7282__$1);
var map__7266_7289__$1 = cljs.core.__destructure_map.call(null,map__7266_7288);
var binding_7290 = map__7266_7289__$1;
var init_7291 = cljs.core.get.call(null,map__7266_7289__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_7290);

cljs.compiler.emitln.call(null," = ",init_7291,";");


var G__7292 = cljs.core.next.call(null,seq__7259_7282__$1);
var G__7293 = null;
var G__7294 = (0);
var G__7295 = (0);
seq__7259_7269 = G__7292;
chunk__7260_7270 = G__7293;
count__7261_7271 = G__7294;
i__7262_7272 = G__7295;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__7257_7267);
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__7296){
var map__7297 = p__7296;
var map__7297__$1 = cljs.core.__destructure_map.call(null,map__7297);
var frame = cljs.core.get.call(null,map__7297__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__7297__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__7297__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4741__auto___7298 = cljs.core.count.call(null,exprs);
var i_7299 = (0);
while(true){
if((i_7299 < n__4741__auto___7298)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_7299)," = ",exprs.call(null,i_7299),";");

var G__7300 = (i_7299 + (1));
i_7299 = G__7300;
continue;
} else {
}
break;
}

var n__4741__auto___7301 = cljs.core.count.call(null,exprs);
var i_7302 = (0);
while(true){
if((i_7302 < n__4741__auto___7301)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_7302))," = ",temps.call(null,i_7302),";");

var G__7303 = (i_7302 + (1));
i_7302 = G__7303;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__7304){
var map__7305 = p__7304;
var map__7305__$1 = cljs.core.__destructure_map.call(null,map__7305);
var expr = cljs.core.get.call(null,map__7305__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__7305__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__7305__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__7306_7314 = cljs.core.seq.call(null,bindings);
var chunk__7307_7315 = null;
var count__7308_7316 = (0);
var i__7309_7317 = (0);
while(true){
if((i__7309_7317 < count__7308_7316)){
var map__7312_7318 = cljs.core._nth.call(null,chunk__7307_7315,i__7309_7317);
var map__7312_7319__$1 = cljs.core.__destructure_map.call(null,map__7312_7318);
var binding_7320 = map__7312_7319__$1;
var init_7321 = cljs.core.get.call(null,map__7312_7319__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_7320)," = ",init_7321,";");


var G__7322 = seq__7306_7314;
var G__7323 = chunk__7307_7315;
var G__7324 = count__7308_7316;
var G__7325 = (i__7309_7317 + (1));
seq__7306_7314 = G__7322;
chunk__7307_7315 = G__7323;
count__7308_7316 = G__7324;
i__7309_7317 = G__7325;
continue;
} else {
var temp__5753__auto___7326 = cljs.core.seq.call(null,seq__7306_7314);
if(temp__5753__auto___7326){
var seq__7306_7327__$1 = temp__5753__auto___7326;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7306_7327__$1)){
var c__4679__auto___7328 = cljs.core.chunk_first.call(null,seq__7306_7327__$1);
var G__7329 = cljs.core.chunk_rest.call(null,seq__7306_7327__$1);
var G__7330 = c__4679__auto___7328;
var G__7331 = cljs.core.count.call(null,c__4679__auto___7328);
var G__7332 = (0);
seq__7306_7314 = G__7329;
chunk__7307_7315 = G__7330;
count__7308_7316 = G__7331;
i__7309_7317 = G__7332;
continue;
} else {
var map__7313_7333 = cljs.core.first.call(null,seq__7306_7327__$1);
var map__7313_7334__$1 = cljs.core.__destructure_map.call(null,map__7313_7333);
var binding_7335 = map__7313_7334__$1;
var init_7336 = cljs.core.get.call(null,map__7313_7334__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_7335)," = ",init_7336,";");


var G__7337 = cljs.core.next.call(null,seq__7306_7327__$1);
var G__7338 = null;
var G__7339 = (0);
var G__7340 = (0);
seq__7306_7314 = G__7337;
chunk__7307_7315 = G__7338;
count__7308_7316 = G__7339;
i__7309_7317 = G__7340;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__7343){
var map__7344 = p__7343;
var map__7344__$1 = cljs.core.__destructure_map.call(null,map__7344);
var expr = map__7344__$1;
var f = cljs.core.get.call(null,map__7344__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.call(null,map__7344__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7344__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4251__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__4251__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4251__auto__ = protocol;
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = tag;
if(cljs.core.truth_(and__4251__auto____$1)){
var or__4253__auto__ = (function (){var and__4251__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = protocol;
if(cljs.core.truth_(and__4251__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto____$2 = (function (){var or__4253__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4251__auto____$2)){
var or__4253__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__4253__auto____$1){
return or__4253__auto____$1;
} else {
var and__4251__auto____$3 = (!(cljs.core.set_QMARK_.call(null,tag)));
if(and__4251__auto____$3){
var and__4251__auto____$4 = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null).call(null,tag));
if(and__4251__auto____$4){
var temp__5753__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,cljs.core.vary_meta.call(null,tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
}
} else {
return and__4251__auto____$2;
}
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null).call(null,first_arg_tag))));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag.call(null,env,f);
var js_QMARK_ = (function (){var or__4253__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4253__auto____$1){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4253__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4253__auto__ = cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4253__auto__){
return or__4253__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote.call(null,f);
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__7345 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (arity > mfa);
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7341_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__7341_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7342_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__7342_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__7345,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__7345,(1),null);
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"(!(",cljs.core.first.call(null,args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.call(null,"((",cljs.core.first.call(null,args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_7348 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_7348,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_7349 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_7349,args)),(((mfa_7349 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_7349,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1));
} else {
return and__4251__auto__;
}
})())){
var fprop_7350 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.call(null,"(",f__$1,fprop_7350," ? ",f__$1,fprop_7350,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_7350," ? ",f__$1,fprop_7350,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__7351){
var map__7352 = p__7351;
var map__7352__$1 = cljs.core.__destructure_map.call(null,map__7352);
var ctor = cljs.core.get.call(null,map__7352__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.call(null,map__7352__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7352__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__7353){
var map__7354 = p__7353;
var map__7354__$1 = cljs.core.__destructure_map.call(null,map__7354);
var target = cljs.core.get.call(null,map__7354__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__7354__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__7354__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(",target," = ",val,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.call(null,sublib,/\./);
return cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (p1__7355_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__7355_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__7356 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__7356,(0),null);
var sublib = cljs.core.nth.call(null,vec__7356,(1),null);
return cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib)," = goog.global",cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.call(null,cljs.core.name.call(null,(function (){var or__4253__auto__ = cljs.core.get.call(null,global_exports,cljs.core.symbol.call(null,lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,global_exports,cljs.core.name.call(null,lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.compiler.sublib_select.call(null,sublib),";");
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__7359 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__7359__$1 = cljs.core.__destructure_map.call(null,map__7359);
var options = cljs.core.get.call(null,map__7359__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__7359__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__7360 = options;
var map__7360__$1 = cljs.core.__destructure_map.call(null,map__7360);
var target = cljs.core.get.call(null,map__7360__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.call(null,map__7360__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.call(null,map__7360__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__7361 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__7367 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__7367__$1 = cljs.core.__destructure_map.call(null,map__7367);
var node_libs = cljs.core.get.call(null,map__7367__$1,true);
var libs_to_load = cljs.core.get.call(null,map__7367__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__7361,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__7361,(1),null);
var vec__7364 = (function (){var map__7368 = cljs.core.group_by.call(null,cljs.analyzer.goog_module_dep_QMARK_,libs_to_load);
var map__7368__$1 = cljs.core.__destructure_map.call(null,map__7368);
var goog_modules = cljs.core.get.call(null,map__7368__$1,true);
var libs_to_load__$1 = cljs.core.get.call(null,map__7368__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goog_modules,libs_to_load__$1], null);
})();
var goog_modules = cljs.core.nth.call(null,vec__7364,(0),null);
var libs_to_load__$1 = cljs.core.nth.call(null,vec__7364,(1),null);
var global_exports_libs = cljs.core.filter.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load__$1);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__7369_7413 = cljs.core.seq.call(null,libs_to_load__$1);
var chunk__7370_7414 = null;
var count__7371_7415 = (0);
var i__7372_7416 = (0);
while(true){
if((i__7372_7416 < count__7371_7415)){
var lib_7417 = cljs.core._nth.call(null,chunk__7370_7414,i__7372_7416);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_7417)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7417),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7417),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7417),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7417),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_7417,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7417),"');");
}

}
}
}


var G__7418 = seq__7369_7413;
var G__7419 = chunk__7370_7414;
var G__7420 = count__7371_7415;
var G__7421 = (i__7372_7416 + (1));
seq__7369_7413 = G__7418;
chunk__7370_7414 = G__7419;
count__7371_7415 = G__7420;
i__7372_7416 = G__7421;
continue;
} else {
var temp__5753__auto___7422 = cljs.core.seq.call(null,seq__7369_7413);
if(temp__5753__auto___7422){
var seq__7369_7423__$1 = temp__5753__auto___7422;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7369_7423__$1)){
var c__4679__auto___7424 = cljs.core.chunk_first.call(null,seq__7369_7423__$1);
var G__7425 = cljs.core.chunk_rest.call(null,seq__7369_7423__$1);
var G__7426 = c__4679__auto___7424;
var G__7427 = cljs.core.count.call(null,c__4679__auto___7424);
var G__7428 = (0);
seq__7369_7413 = G__7425;
chunk__7370_7414 = G__7426;
count__7371_7415 = G__7427;
i__7372_7416 = G__7428;
continue;
} else {
var lib_7429 = cljs.core.first.call(null,seq__7369_7423__$1);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_7429)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7429),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7429),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7429),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7429),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_7429,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7429),"');");
}

}
}
}


var G__7430 = cljs.core.next.call(null,seq__7369_7423__$1);
var G__7431 = null;
var G__7432 = (0);
var G__7433 = (0);
seq__7369_7413 = G__7430;
chunk__7370_7414 = G__7431;
count__7371_7415 = G__7432;
i__7372_7416 = G__7433;
continue;
}
} else {
}
}
break;
}

var seq__7373_7434 = cljs.core.seq.call(null,node_libs);
var chunk__7374_7435 = null;
var count__7375_7436 = (0);
var i__7376_7437 = (0);
while(true){
if((i__7376_7437 < count__7375_7436)){
var lib_7438 = cljs.core._nth.call(null,chunk__7374_7435,i__7376_7437);
var vec__7383_7439 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7438);
var lib_SINGLEQUOTE__7440 = cljs.core.nth.call(null,vec__7383_7439,(0),null);
var sublib_7441 = cljs.core.nth.call(null,vec__7383_7439,(1),null);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_7438)," = require('",lib_SINGLEQUOTE__7440,"')",cljs.compiler.sublib_select.call(null,sublib_7441),";");


var G__7442 = seq__7373_7434;
var G__7443 = chunk__7374_7435;
var G__7444 = count__7375_7436;
var G__7445 = (i__7376_7437 + (1));
seq__7373_7434 = G__7442;
chunk__7374_7435 = G__7443;
count__7375_7436 = G__7444;
i__7376_7437 = G__7445;
continue;
} else {
var temp__5753__auto___7446 = cljs.core.seq.call(null,seq__7373_7434);
if(temp__5753__auto___7446){
var seq__7373_7447__$1 = temp__5753__auto___7446;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7373_7447__$1)){
var c__4679__auto___7448 = cljs.core.chunk_first.call(null,seq__7373_7447__$1);
var G__7449 = cljs.core.chunk_rest.call(null,seq__7373_7447__$1);
var G__7450 = c__4679__auto___7448;
var G__7451 = cljs.core.count.call(null,c__4679__auto___7448);
var G__7452 = (0);
seq__7373_7434 = G__7449;
chunk__7374_7435 = G__7450;
count__7375_7436 = G__7451;
i__7376_7437 = G__7452;
continue;
} else {
var lib_7453 = cljs.core.first.call(null,seq__7373_7447__$1);
var vec__7386_7454 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7453);
var lib_SINGLEQUOTE__7455 = cljs.core.nth.call(null,vec__7386_7454,(0),null);
var sublib_7456 = cljs.core.nth.call(null,vec__7386_7454,(1),null);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_7453)," = require('",lib_SINGLEQUOTE__7455,"')",cljs.compiler.sublib_select.call(null,sublib_7456),";");


var G__7457 = cljs.core.next.call(null,seq__7373_7447__$1);
var G__7458 = null;
var G__7459 = (0);
var G__7460 = (0);
seq__7373_7434 = G__7457;
chunk__7374_7435 = G__7458;
count__7375_7436 = G__7459;
i__7376_7437 = G__7460;
continue;
}
} else {
}
}
break;
}

var seq__7389_7461 = cljs.core.seq.call(null,goog_modules);
var chunk__7390_7462 = null;
var count__7391_7463 = (0);
var i__7392_7464 = (0);
while(true){
if((i__7392_7464 < count__7391_7463)){
var lib_7465 = cljs.core._nth.call(null,chunk__7390_7462,i__7392_7464);
var vec__7399_7466 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7465);
var lib_SINGLEQUOTE__7467 = cljs.core.nth.call(null,vec__7399_7466,(0),null);
var sublib_7468 = cljs.core.nth.call(null,vec__7399_7466,(1),null);
cljs.compiler.emitln.call(null,"goog.require('",lib_SINGLEQUOTE__7467,"');");

cljs.compiler.emitln.call(null,"goog.scope(function(){");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_goog_module_lib.call(null,lib_7465)," = goog.module.get('",lib_SINGLEQUOTE__7467,"')",cljs.compiler.sublib_select.call(null,sublib_7468),";");

cljs.compiler.emitln.call(null,"});");


var G__7469 = seq__7389_7461;
var G__7470 = chunk__7390_7462;
var G__7471 = count__7391_7463;
var G__7472 = (i__7392_7464 + (1));
seq__7389_7461 = G__7469;
chunk__7390_7462 = G__7470;
count__7391_7463 = G__7471;
i__7392_7464 = G__7472;
continue;
} else {
var temp__5753__auto___7473 = cljs.core.seq.call(null,seq__7389_7461);
if(temp__5753__auto___7473){
var seq__7389_7474__$1 = temp__5753__auto___7473;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7389_7474__$1)){
var c__4679__auto___7475 = cljs.core.chunk_first.call(null,seq__7389_7474__$1);
var G__7476 = cljs.core.chunk_rest.call(null,seq__7389_7474__$1);
var G__7477 = c__4679__auto___7475;
var G__7478 = cljs.core.count.call(null,c__4679__auto___7475);
var G__7479 = (0);
seq__7389_7461 = G__7476;
chunk__7390_7462 = G__7477;
count__7391_7463 = G__7478;
i__7392_7464 = G__7479;
continue;
} else {
var lib_7480 = cljs.core.first.call(null,seq__7389_7474__$1);
var vec__7402_7481 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7480);
var lib_SINGLEQUOTE__7482 = cljs.core.nth.call(null,vec__7402_7481,(0),null);
var sublib_7483 = cljs.core.nth.call(null,vec__7402_7481,(1),null);
cljs.compiler.emitln.call(null,"goog.require('",lib_SINGLEQUOTE__7482,"');");

cljs.compiler.emitln.call(null,"goog.scope(function(){");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_goog_module_lib.call(null,lib_7480)," = goog.module.get('",lib_SINGLEQUOTE__7482,"')",cljs.compiler.sublib_select.call(null,sublib_7483),";");

cljs.compiler.emitln.call(null,"});");


var G__7484 = cljs.core.next.call(null,seq__7389_7474__$1);
var G__7485 = null;
var G__7486 = (0);
var G__7487 = (0);
seq__7389_7461 = G__7484;
chunk__7390_7462 = G__7485;
count__7391_7463 = G__7486;
i__7392_7464 = G__7487;
continue;
}
} else {
}
}
break;
}

var seq__7405_7488 = cljs.core.seq.call(null,global_exports_libs);
var chunk__7406_7489 = null;
var count__7407_7490 = (0);
var i__7408_7491 = (0);
while(true){
if((i__7408_7491 < count__7407_7490)){
var lib_7492 = cljs.core._nth.call(null,chunk__7406_7489,i__7408_7491);
var map__7411_7493 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,cljs.core.first.call(null,cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7492))));
var map__7411_7494__$1 = cljs.core.__destructure_map.call(null,map__7411_7493);
var global_exports_7495 = cljs.core.get.call(null,map__7411_7494__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_7495,lib_7492);


var G__7496 = seq__7405_7488;
var G__7497 = chunk__7406_7489;
var G__7498 = count__7407_7490;
var G__7499 = (i__7408_7491 + (1));
seq__7405_7488 = G__7496;
chunk__7406_7489 = G__7497;
count__7407_7490 = G__7498;
i__7408_7491 = G__7499;
continue;
} else {
var temp__5753__auto___7500 = cljs.core.seq.call(null,seq__7405_7488);
if(temp__5753__auto___7500){
var seq__7405_7501__$1 = temp__5753__auto___7500;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7405_7501__$1)){
var c__4679__auto___7502 = cljs.core.chunk_first.call(null,seq__7405_7501__$1);
var G__7503 = cljs.core.chunk_rest.call(null,seq__7405_7501__$1);
var G__7504 = c__4679__auto___7502;
var G__7505 = cljs.core.count.call(null,c__4679__auto___7502);
var G__7506 = (0);
seq__7405_7488 = G__7503;
chunk__7406_7489 = G__7504;
count__7407_7490 = G__7505;
i__7408_7491 = G__7506;
continue;
} else {
var lib_7507 = cljs.core.first.call(null,seq__7405_7501__$1);
var map__7412_7508 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,cljs.core.first.call(null,cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7507))));
var map__7412_7509__$1 = cljs.core.__destructure_map.call(null,map__7412_7508);
var global_exports_7510 = cljs.core.get.call(null,map__7412_7509__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_7510,lib_7507);


var G__7511 = cljs.core.next.call(null,seq__7405_7501__$1);
var G__7512 = null;
var G__7513 = (0);
var G__7514 = (0);
seq__7405_7488 = G__7511;
chunk__7406_7489 = G__7512;
count__7407_7490 = G__7513;
i__7408_7491 = G__7514;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__7515){
var map__7516 = p__7515;
var map__7516__$1 = cljs.core.__destructure_map.call(null,map__7516);
var name = cljs.core.get.call(null,map__7516__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__7516__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__7516__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__7516__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__7516__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__7516__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__7516__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"'nil';");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__7517){
var map__7518 = p__7517;
var map__7518__$1 = cljs.core.__destructure_map.call(null,map__7518);
var name = cljs.core.get.call(null,map__7518__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__7518__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__7518__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__7518__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__7518__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__7518__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__7518__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__7519){
var map__7520 = p__7519;
var map__7520__$1 = cljs.core.__destructure_map.call(null,map__7520);
var t = cljs.core.get.call(null,map__7520__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__7520__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__7520__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__7520__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__7520__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__7521_7545 = cljs.core.seq.call(null,protocols);
var chunk__7522_7546 = null;
var count__7523_7547 = (0);
var i__7524_7548 = (0);
while(true){
if((i__7524_7548 < count__7523_7547)){
var protocol_7549 = cljs.core._nth.call(null,chunk__7522_7546,i__7524_7548);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7549)),"}");


var G__7550 = seq__7521_7545;
var G__7551 = chunk__7522_7546;
var G__7552 = count__7523_7547;
var G__7553 = (i__7524_7548 + (1));
seq__7521_7545 = G__7550;
chunk__7522_7546 = G__7551;
count__7523_7547 = G__7552;
i__7524_7548 = G__7553;
continue;
} else {
var temp__5753__auto___7554 = cljs.core.seq.call(null,seq__7521_7545);
if(temp__5753__auto___7554){
var seq__7521_7555__$1 = temp__5753__auto___7554;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7521_7555__$1)){
var c__4679__auto___7556 = cljs.core.chunk_first.call(null,seq__7521_7555__$1);
var G__7557 = cljs.core.chunk_rest.call(null,seq__7521_7555__$1);
var G__7558 = c__4679__auto___7556;
var G__7559 = cljs.core.count.call(null,c__4679__auto___7556);
var G__7560 = (0);
seq__7521_7545 = G__7557;
chunk__7522_7546 = G__7558;
count__7523_7547 = G__7559;
i__7524_7548 = G__7560;
continue;
} else {
var protocol_7561 = cljs.core.first.call(null,seq__7521_7555__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7561)),"}");


var G__7562 = cljs.core.next.call(null,seq__7521_7555__$1);
var G__7563 = null;
var G__7564 = (0);
var G__7565 = (0);
seq__7521_7545 = G__7562;
chunk__7522_7546 = G__7563;
count__7523_7547 = G__7564;
i__7524_7548 = G__7565;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__7525_7566 = cljs.core.seq.call(null,fields__$1);
var chunk__7526_7567 = null;
var count__7527_7568 = (0);
var i__7528_7569 = (0);
while(true){
if((i__7528_7569 < count__7527_7568)){
var fld_7570 = cljs.core._nth.call(null,chunk__7526_7567,i__7528_7569);
cljs.compiler.emitln.call(null,"this.",fld_7570," = ",fld_7570,";");


var G__7571 = seq__7525_7566;
var G__7572 = chunk__7526_7567;
var G__7573 = count__7527_7568;
var G__7574 = (i__7528_7569 + (1));
seq__7525_7566 = G__7571;
chunk__7526_7567 = G__7572;
count__7527_7568 = G__7573;
i__7528_7569 = G__7574;
continue;
} else {
var temp__5753__auto___7575 = cljs.core.seq.call(null,seq__7525_7566);
if(temp__5753__auto___7575){
var seq__7525_7576__$1 = temp__5753__auto___7575;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7525_7576__$1)){
var c__4679__auto___7577 = cljs.core.chunk_first.call(null,seq__7525_7576__$1);
var G__7578 = cljs.core.chunk_rest.call(null,seq__7525_7576__$1);
var G__7579 = c__4679__auto___7577;
var G__7580 = cljs.core.count.call(null,c__4679__auto___7577);
var G__7581 = (0);
seq__7525_7566 = G__7578;
chunk__7526_7567 = G__7579;
count__7527_7568 = G__7580;
i__7528_7569 = G__7581;
continue;
} else {
var fld_7582 = cljs.core.first.call(null,seq__7525_7576__$1);
cljs.compiler.emitln.call(null,"this.",fld_7582," = ",fld_7582,";");


var G__7583 = cljs.core.next.call(null,seq__7525_7576__$1);
var G__7584 = null;
var G__7585 = (0);
var G__7586 = (0);
seq__7525_7566 = G__7583;
chunk__7526_7567 = G__7584;
count__7527_7568 = G__7585;
i__7528_7569 = G__7586;
continue;
}
} else {
}
}
break;
}

var seq__7529_7587 = cljs.core.seq.call(null,pmasks);
var chunk__7530_7588 = null;
var count__7531_7589 = (0);
var i__7532_7590 = (0);
while(true){
if((i__7532_7590 < count__7531_7589)){
var vec__7539_7591 = cljs.core._nth.call(null,chunk__7530_7588,i__7532_7590);
var pno_7592 = cljs.core.nth.call(null,vec__7539_7591,(0),null);
var pmask_7593 = cljs.core.nth.call(null,vec__7539_7591,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7592,"$ = ",pmask_7593,";");


var G__7594 = seq__7529_7587;
var G__7595 = chunk__7530_7588;
var G__7596 = count__7531_7589;
var G__7597 = (i__7532_7590 + (1));
seq__7529_7587 = G__7594;
chunk__7530_7588 = G__7595;
count__7531_7589 = G__7596;
i__7532_7590 = G__7597;
continue;
} else {
var temp__5753__auto___7598 = cljs.core.seq.call(null,seq__7529_7587);
if(temp__5753__auto___7598){
var seq__7529_7599__$1 = temp__5753__auto___7598;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7529_7599__$1)){
var c__4679__auto___7600 = cljs.core.chunk_first.call(null,seq__7529_7599__$1);
var G__7601 = cljs.core.chunk_rest.call(null,seq__7529_7599__$1);
var G__7602 = c__4679__auto___7600;
var G__7603 = cljs.core.count.call(null,c__4679__auto___7600);
var G__7604 = (0);
seq__7529_7587 = G__7601;
chunk__7530_7588 = G__7602;
count__7531_7589 = G__7603;
i__7532_7590 = G__7604;
continue;
} else {
var vec__7542_7605 = cljs.core.first.call(null,seq__7529_7599__$1);
var pno_7606 = cljs.core.nth.call(null,vec__7542_7605,(0),null);
var pmask_7607 = cljs.core.nth.call(null,vec__7542_7605,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7606,"$ = ",pmask_7607,";");


var G__7608 = cljs.core.next.call(null,seq__7529_7599__$1);
var G__7609 = null;
var G__7610 = (0);
var G__7611 = (0);
seq__7529_7587 = G__7608;
chunk__7530_7588 = G__7609;
count__7531_7589 = G__7610;
i__7532_7590 = G__7611;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__7612){
var map__7613 = p__7612;
var map__7613__$1 = cljs.core.__destructure_map.call(null,map__7613);
var t = cljs.core.get.call(null,map__7613__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__7613__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__7613__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__7613__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__7613__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__7614_7638 = cljs.core.seq.call(null,protocols);
var chunk__7615_7639 = null;
var count__7616_7640 = (0);
var i__7617_7641 = (0);
while(true){
if((i__7617_7641 < count__7616_7640)){
var protocol_7642 = cljs.core._nth.call(null,chunk__7615_7639,i__7617_7641);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7642)),"}");


var G__7643 = seq__7614_7638;
var G__7644 = chunk__7615_7639;
var G__7645 = count__7616_7640;
var G__7646 = (i__7617_7641 + (1));
seq__7614_7638 = G__7643;
chunk__7615_7639 = G__7644;
count__7616_7640 = G__7645;
i__7617_7641 = G__7646;
continue;
} else {
var temp__5753__auto___7647 = cljs.core.seq.call(null,seq__7614_7638);
if(temp__5753__auto___7647){
var seq__7614_7648__$1 = temp__5753__auto___7647;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7614_7648__$1)){
var c__4679__auto___7649 = cljs.core.chunk_first.call(null,seq__7614_7648__$1);
var G__7650 = cljs.core.chunk_rest.call(null,seq__7614_7648__$1);
var G__7651 = c__4679__auto___7649;
var G__7652 = cljs.core.count.call(null,c__4679__auto___7649);
var G__7653 = (0);
seq__7614_7638 = G__7650;
chunk__7615_7639 = G__7651;
count__7616_7640 = G__7652;
i__7617_7641 = G__7653;
continue;
} else {
var protocol_7654 = cljs.core.first.call(null,seq__7614_7648__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7654)),"}");


var G__7655 = cljs.core.next.call(null,seq__7614_7648__$1);
var G__7656 = null;
var G__7657 = (0);
var G__7658 = (0);
seq__7614_7638 = G__7655;
chunk__7615_7639 = G__7656;
count__7616_7640 = G__7657;
i__7617_7641 = G__7658;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__7618_7659 = cljs.core.seq.call(null,fields__$1);
var chunk__7619_7660 = null;
var count__7620_7661 = (0);
var i__7621_7662 = (0);
while(true){
if((i__7621_7662 < count__7620_7661)){
var fld_7663 = cljs.core._nth.call(null,chunk__7619_7660,i__7621_7662);
cljs.compiler.emitln.call(null,"this.",fld_7663," = ",fld_7663,";");


var G__7664 = seq__7618_7659;
var G__7665 = chunk__7619_7660;
var G__7666 = count__7620_7661;
var G__7667 = (i__7621_7662 + (1));
seq__7618_7659 = G__7664;
chunk__7619_7660 = G__7665;
count__7620_7661 = G__7666;
i__7621_7662 = G__7667;
continue;
} else {
var temp__5753__auto___7668 = cljs.core.seq.call(null,seq__7618_7659);
if(temp__5753__auto___7668){
var seq__7618_7669__$1 = temp__5753__auto___7668;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7618_7669__$1)){
var c__4679__auto___7670 = cljs.core.chunk_first.call(null,seq__7618_7669__$1);
var G__7671 = cljs.core.chunk_rest.call(null,seq__7618_7669__$1);
var G__7672 = c__4679__auto___7670;
var G__7673 = cljs.core.count.call(null,c__4679__auto___7670);
var G__7674 = (0);
seq__7618_7659 = G__7671;
chunk__7619_7660 = G__7672;
count__7620_7661 = G__7673;
i__7621_7662 = G__7674;
continue;
} else {
var fld_7675 = cljs.core.first.call(null,seq__7618_7669__$1);
cljs.compiler.emitln.call(null,"this.",fld_7675," = ",fld_7675,";");


var G__7676 = cljs.core.next.call(null,seq__7618_7669__$1);
var G__7677 = null;
var G__7678 = (0);
var G__7679 = (0);
seq__7618_7659 = G__7676;
chunk__7619_7660 = G__7677;
count__7620_7661 = G__7678;
i__7621_7662 = G__7679;
continue;
}
} else {
}
}
break;
}

var seq__7622_7680 = cljs.core.seq.call(null,pmasks);
var chunk__7623_7681 = null;
var count__7624_7682 = (0);
var i__7625_7683 = (0);
while(true){
if((i__7625_7683 < count__7624_7682)){
var vec__7632_7684 = cljs.core._nth.call(null,chunk__7623_7681,i__7625_7683);
var pno_7685 = cljs.core.nth.call(null,vec__7632_7684,(0),null);
var pmask_7686 = cljs.core.nth.call(null,vec__7632_7684,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7685,"$ = ",pmask_7686,";");


var G__7687 = seq__7622_7680;
var G__7688 = chunk__7623_7681;
var G__7689 = count__7624_7682;
var G__7690 = (i__7625_7683 + (1));
seq__7622_7680 = G__7687;
chunk__7623_7681 = G__7688;
count__7624_7682 = G__7689;
i__7625_7683 = G__7690;
continue;
} else {
var temp__5753__auto___7691 = cljs.core.seq.call(null,seq__7622_7680);
if(temp__5753__auto___7691){
var seq__7622_7692__$1 = temp__5753__auto___7691;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7622_7692__$1)){
var c__4679__auto___7693 = cljs.core.chunk_first.call(null,seq__7622_7692__$1);
var G__7694 = cljs.core.chunk_rest.call(null,seq__7622_7692__$1);
var G__7695 = c__4679__auto___7693;
var G__7696 = cljs.core.count.call(null,c__4679__auto___7693);
var G__7697 = (0);
seq__7622_7680 = G__7694;
chunk__7623_7681 = G__7695;
count__7624_7682 = G__7696;
i__7625_7683 = G__7697;
continue;
} else {
var vec__7635_7698 = cljs.core.first.call(null,seq__7622_7692__$1);
var pno_7699 = cljs.core.nth.call(null,vec__7635_7698,(0),null);
var pmask_7700 = cljs.core.nth.call(null,vec__7635_7698,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7699,"$ = ",pmask_7700,";");


var G__7701 = cljs.core.next.call(null,seq__7622_7692__$1);
var G__7702 = null;
var G__7703 = (0);
var G__7704 = (0);
seq__7622_7680 = G__7701;
chunk__7623_7681 = G__7702;
count__7624_7682 = G__7703;
i__7625_7683 = G__7704;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__7705){
var map__7706 = p__7705;
var map__7706__$1 = cljs.core.__destructure_map.call(null,map__7706);
var target = cljs.core.get.call(null,map__7706__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__7706__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__7706__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__7706__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7706__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__7707){
var map__7708 = p__7707;
var map__7708__$1 = cljs.core.__destructure_map.call(null,map__7708);
var op = cljs.core.get.call(null,map__7708__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__7708__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__7708__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__7708__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__7708__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4251__auto__ = code;
if(cljs.core.truth_(and__4251__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__4251__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__6500__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6500__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__7713 = cljs.core.seq.call(null,table);
var chunk__7714 = null;
var count__7715 = (0);
var i__7716 = (0);
while(true){
if((i__7716 < count__7715)){
var vec__7723 = cljs.core._nth.call(null,chunk__7714,i__7716);
var sym = cljs.core.nth.call(null,vec__7723,(0),null);
var value = cljs.core.nth.call(null,vec__7723,(1),null);
var ns_7729 = cljs.core.namespace.call(null,sym);
var name_7730 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__7731 = seq__7713;
var G__7732 = chunk__7714;
var G__7733 = count__7715;
var G__7734 = (i__7716 + (1));
seq__7713 = G__7731;
chunk__7714 = G__7732;
count__7715 = G__7733;
i__7716 = G__7734;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__7713);
if(temp__5753__auto__){
var seq__7713__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7713__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__7713__$1);
var G__7735 = cljs.core.chunk_rest.call(null,seq__7713__$1);
var G__7736 = c__4679__auto__;
var G__7737 = cljs.core.count.call(null,c__4679__auto__);
var G__7738 = (0);
seq__7713 = G__7735;
chunk__7714 = G__7736;
count__7715 = G__7737;
i__7716 = G__7738;
continue;
} else {
var vec__7726 = cljs.core.first.call(null,seq__7713__$1);
var sym = cljs.core.nth.call(null,vec__7726,(0),null);
var value = cljs.core.nth.call(null,vec__7726,(1),null);
var ns_7739 = cljs.core.namespace.call(null,sym);
var name_7740 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__7741 = cljs.core.next.call(null,seq__7713__$1);
var G__7742 = null;
var G__7743 = (0);
var G__7744 = (0);
seq__7713 = G__7741;
chunk__7714 = G__7742;
count__7715 = G__7743;
i__7716 = G__7744;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__7746 = arguments.length;
switch (G__7746) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs.call(null):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_7751 = cljs.core.first.call(null,ks);
var vec__7747_7752 = cljs.core.conj.call(null,prefix,k_7751);
var top_7753 = cljs.core.nth.call(null,vec__7747_7752,(0),null);
var prefix_SINGLEQUOTE__7754 = vec__7747_7752;
if(((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_7751)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__7754) == null)))){
if((!(((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_7753)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_7753)))))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__7754)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_7753);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__7754)),";");
}
} else {
}

var m_7755 = cljs.core.get.call(null,externs,k_7751);
if(cljs.core.empty_QMARK_.call(null,m_7755)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__7754,m_7755,top_level,known_externs);
}

var G__7756 = cljs.core.next.call(null,ks);
ks = G__7756;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

