// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
goog.require('goog.object');
goog.scope(function(){
cljs.source_map.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__5465){
var vec__5466 = p__5465;
var i = cljs.core.nth.call(null,vec__5466,(0),null);
var v = cljs.core.nth.call(null,vec__5466,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__5469 = seg;
var gcol = cljs.core.nth.call(null,vec__5469,(0),null);
var source = cljs.core.nth.call(null,vec__5469,(1),null);
var line = cljs.core.nth.call(null,vec__5469,(2),null);
var col = cljs.core.nth.call(null,vec__5469,(3),null);
var name = cljs.core.nth.call(null,vec__5469,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (cljs.source_map.goog$module$goog$object.get.call(null,source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__5472 = seg;
var gcol = cljs.core.nth.call(null,vec__5472,(0),null);
var source = cljs.core.nth.call(null,vec__5472,(1),null);
var line = cljs.core.nth.call(null,vec__5472,(2),null);
var col = cljs.core.nth.call(null,vec__5472,(3),null);
var name = cljs.core.nth.call(null,vec__5472,(4),null);
var vec__5475 = relseg;
var rgcol = cljs.core.nth.call(null,vec__5475,(0),null);
var rsource = cljs.core.nth.call(null,vec__5475,(1),null);
var rline = cljs.core.nth.call(null,vec__5475,(2),null);
var rcol = cljs.core.nth.call(null,vec__5475,(3),null);
var rname = cljs.core.nth.call(null,vec__5475,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4253__auto__ = source;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4253__auto__ = line;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4253__auto__ = col;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__5478 = segmap;
var map__5478__$1 = cljs.core.__destructure_map.call(null,map__5478);
var gcol = cljs.core.get.call(null,map__5478__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__5478__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__5478__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__5478__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__5478__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,(function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,(function (v){
return cljs.core.conj.call(null,v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__5480 = arguments.length;
switch (G__5480) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__5484 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__5488 = cljs.core.next.call(null,segs__$1);
var G__5489 = nrelseg;
var G__5490 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__5488;
relseg__$1 = G__5489;
result__$1 = G__5490;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__5484,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__5484,(1),null);
var G__5491 = (gline + (1));
var G__5492 = cljs.core.next.call(null,lines__$1);
var G__5493 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__5494 = result__$1;
gline = G__5491;
lines__$1 = G__5492;
relseg = G__5493;
result = G__5494;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__5496 = segmap;
var map__5496__$1 = cljs.core.__destructure_map.call(null,map__5496);
var gcol = cljs.core.get.call(null,map__5496__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__5496__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__5496__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__5496__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__5496__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,(function (p1__5495_SHARP_){
return cljs.core.conj.call(null,p1__5495_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__5498 = arguments.length;
switch (G__5498) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__5502 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__5506 = cljs.core.next.call(null,segs__$1);
var G__5507 = nrelseg;
var G__5508 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__5506;
relseg__$1 = G__5507;
result__$1 = G__5508;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__5502,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__5502,(1),null);
var G__5509 = (gline + (1));
var G__5510 = cljs.core.next.call(null,lines__$1);
var G__5511 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__5512 = result__$1;
gline = G__5509;
lines__$1 = G__5510;
relseg = G__5511;
result = G__5512;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,(function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,(function (p__5513){
var vec__5514 = p__5513;
var _ = cljs.core.nth.call(null,vec__5514,(0),null);
var source = cljs.core.nth.call(null,vec__5514,(1),null);
var line = cljs.core.nth.call(null,vec__5514,(2),null);
var col = cljs.core.nth.call(null,vec__5514,(3),null);
var name = cljs.core.nth.call(null,vec__5514,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,(function (cols__$1,p__5517){
var vec__5518 = p__5517;
var gcol = cljs.core.nth.call(null,vec__5518,(0),null);
var sidx = cljs.core.nth.call(null,vec__5518,(1),null);
var line = cljs.core.nth.call(null,vec__5518,(2),null);
var col = cljs.core.nth.call(null,vec__5518,(3),null);
var name = cljs.core.nth.call(null,vec__5518,(4),null);
var seg = vec__5518;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,(function (p__5521){
var vec__5522 = p__5521;
var _ = cljs.core.nth.call(null,vec__5522,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__5522,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__5522,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__5522,(3),null);
var lname = cljs.core.nth.call(null,vec__5522,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__5528 = cljs.core.seq.call(null,infos);
var chunk__5529 = null;
var count__5530 = (0);
var i__5531 = (0);
while(true){
if((i__5531 < count__5530)){
var info = cljs.core._nth.call(null,chunk__5529,i__5531);
var segv_5882 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_5883 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_5884 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_5883 > (lc_5884 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__5528,chunk__5529,count__5530,i__5531,segv_5882,gline_5883,lc_5884,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_5883 - (lc_5884 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_5882], null));
});})(seq__5528,chunk__5529,count__5530,i__5531,segv_5882,gline_5883,lc_5884,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__5528,chunk__5529,count__5530,i__5531,segv_5882,gline_5883,lc_5884,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5883], null),cljs.core.conj,segv_5882);
});})(seq__5528,chunk__5529,count__5530,i__5531,segv_5882,gline_5883,lc_5884,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__5885 = seq__5528;
var G__5886 = chunk__5529;
var G__5887 = count__5530;
var G__5888 = (i__5531 + (1));
seq__5528 = G__5885;
chunk__5529 = G__5886;
count__5530 = G__5887;
i__5531 = G__5888;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__5528);
if(temp__5753__auto__){
var seq__5528__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5528__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__5528__$1);
var G__5889 = cljs.core.chunk_rest.call(null,seq__5528__$1);
var G__5890 = c__4679__auto__;
var G__5891 = cljs.core.count.call(null,c__4679__auto__);
var G__5892 = (0);
seq__5528 = G__5889;
chunk__5529 = G__5890;
count__5530 = G__5891;
i__5531 = G__5892;
continue;
} else {
var info = cljs.core.first.call(null,seq__5528__$1);
var segv_5893 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_5894 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_5895 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_5894 > (lc_5895 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__5528,chunk__5529,count__5530,i__5531,segv_5893,gline_5894,lc_5895,info,seq__5528__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_5894 - (lc_5895 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_5893], null));
});})(seq__5528,chunk__5529,count__5530,i__5531,segv_5893,gline_5894,lc_5895,info,seq__5528__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__5528,chunk__5529,count__5530,i__5531,segv_5893,gline_5894,lc_5895,info,seq__5528__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5894], null),cljs.core.conj,segv_5893);
});})(seq__5528,chunk__5529,count__5530,i__5531,segv_5893,gline_5894,lc_5895,info,seq__5528__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__5896 = cljs.core.next.call(null,seq__5528__$1);
var G__5897 = null;
var G__5898 = (0);
var G__5899 = (0);
seq__5528 = G__5896;
chunk__5529 = G__5897;
count__5530 = G__5898;
i__5531 = G__5899;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__5532_5900 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__5533_5901 = null;
var count__5534_5902 = (0);
var i__5535_5903 = (0);
while(true){
if((i__5535_5903 < count__5534_5902)){
var vec__5708_5904 = cljs.core._nth.call(null,chunk__5533_5901,i__5535_5903);
var source_idx_5905 = cljs.core.nth.call(null,vec__5708_5904,(0),null);
var vec__5711_5906 = cljs.core.nth.call(null,vec__5708_5904,(1),null);
var __5907 = cljs.core.nth.call(null,vec__5711_5906,(0),null);
var lines_5908__$1 = cljs.core.nth.call(null,vec__5711_5906,(1),null);
var seq__5714_5909 = cljs.core.seq.call(null,lines_5908__$1);
var chunk__5715_5910 = null;
var count__5716_5911 = (0);
var i__5717_5912 = (0);
while(true){
if((i__5717_5912 < count__5716_5911)){
var vec__5756_5913 = cljs.core._nth.call(null,chunk__5715_5910,i__5717_5912);
var line_5914 = cljs.core.nth.call(null,vec__5756_5913,(0),null);
var cols_5915 = cljs.core.nth.call(null,vec__5756_5913,(1),null);
var seq__5759_5916 = cljs.core.seq.call(null,cols_5915);
var chunk__5760_5917 = null;
var count__5761_5918 = (0);
var i__5762_5919 = (0);
while(true){
if((i__5762_5919 < count__5761_5918)){
var vec__5769_5920 = cljs.core._nth.call(null,chunk__5760_5917,i__5762_5919);
var col_5921 = cljs.core.nth.call(null,vec__5769_5920,(0),null);
var infos_5922 = cljs.core.nth.call(null,vec__5769_5920,(1),null);
encode_cols.call(null,infos_5922,source_idx_5905,line_5914,col_5921);


var G__5923 = seq__5759_5916;
var G__5924 = chunk__5760_5917;
var G__5925 = count__5761_5918;
var G__5926 = (i__5762_5919 + (1));
seq__5759_5916 = G__5923;
chunk__5760_5917 = G__5924;
count__5761_5918 = G__5925;
i__5762_5919 = G__5926;
continue;
} else {
var temp__5753__auto___5927 = cljs.core.seq.call(null,seq__5759_5916);
if(temp__5753__auto___5927){
var seq__5759_5928__$1 = temp__5753__auto___5927;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5759_5928__$1)){
var c__4679__auto___5929 = cljs.core.chunk_first.call(null,seq__5759_5928__$1);
var G__5930 = cljs.core.chunk_rest.call(null,seq__5759_5928__$1);
var G__5931 = c__4679__auto___5929;
var G__5932 = cljs.core.count.call(null,c__4679__auto___5929);
var G__5933 = (0);
seq__5759_5916 = G__5930;
chunk__5760_5917 = G__5931;
count__5761_5918 = G__5932;
i__5762_5919 = G__5933;
continue;
} else {
var vec__5772_5934 = cljs.core.first.call(null,seq__5759_5928__$1);
var col_5935 = cljs.core.nth.call(null,vec__5772_5934,(0),null);
var infos_5936 = cljs.core.nth.call(null,vec__5772_5934,(1),null);
encode_cols.call(null,infos_5936,source_idx_5905,line_5914,col_5935);


var G__5937 = cljs.core.next.call(null,seq__5759_5928__$1);
var G__5938 = null;
var G__5939 = (0);
var G__5940 = (0);
seq__5759_5916 = G__5937;
chunk__5760_5917 = G__5938;
count__5761_5918 = G__5939;
i__5762_5919 = G__5940;
continue;
}
} else {
}
}
break;
}


var G__5941 = seq__5714_5909;
var G__5942 = chunk__5715_5910;
var G__5943 = count__5716_5911;
var G__5944 = (i__5717_5912 + (1));
seq__5714_5909 = G__5941;
chunk__5715_5910 = G__5942;
count__5716_5911 = G__5943;
i__5717_5912 = G__5944;
continue;
} else {
var temp__5753__auto___5945 = cljs.core.seq.call(null,seq__5714_5909);
if(temp__5753__auto___5945){
var seq__5714_5946__$1 = temp__5753__auto___5945;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5714_5946__$1)){
var c__4679__auto___5947 = cljs.core.chunk_first.call(null,seq__5714_5946__$1);
var G__5948 = cljs.core.chunk_rest.call(null,seq__5714_5946__$1);
var G__5949 = c__4679__auto___5947;
var G__5950 = cljs.core.count.call(null,c__4679__auto___5947);
var G__5951 = (0);
seq__5714_5909 = G__5948;
chunk__5715_5910 = G__5949;
count__5716_5911 = G__5950;
i__5717_5912 = G__5951;
continue;
} else {
var vec__5775_5952 = cljs.core.first.call(null,seq__5714_5946__$1);
var line_5953 = cljs.core.nth.call(null,vec__5775_5952,(0),null);
var cols_5954 = cljs.core.nth.call(null,vec__5775_5952,(1),null);
var seq__5778_5955 = cljs.core.seq.call(null,cols_5954);
var chunk__5779_5956 = null;
var count__5780_5957 = (0);
var i__5781_5958 = (0);
while(true){
if((i__5781_5958 < count__5780_5957)){
var vec__5788_5959 = cljs.core._nth.call(null,chunk__5779_5956,i__5781_5958);
var col_5960 = cljs.core.nth.call(null,vec__5788_5959,(0),null);
var infos_5961 = cljs.core.nth.call(null,vec__5788_5959,(1),null);
encode_cols.call(null,infos_5961,source_idx_5905,line_5953,col_5960);


var G__5962 = seq__5778_5955;
var G__5963 = chunk__5779_5956;
var G__5964 = count__5780_5957;
var G__5965 = (i__5781_5958 + (1));
seq__5778_5955 = G__5962;
chunk__5779_5956 = G__5963;
count__5780_5957 = G__5964;
i__5781_5958 = G__5965;
continue;
} else {
var temp__5753__auto___5966__$1 = cljs.core.seq.call(null,seq__5778_5955);
if(temp__5753__auto___5966__$1){
var seq__5778_5967__$1 = temp__5753__auto___5966__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5778_5967__$1)){
var c__4679__auto___5968 = cljs.core.chunk_first.call(null,seq__5778_5967__$1);
var G__5969 = cljs.core.chunk_rest.call(null,seq__5778_5967__$1);
var G__5970 = c__4679__auto___5968;
var G__5971 = cljs.core.count.call(null,c__4679__auto___5968);
var G__5972 = (0);
seq__5778_5955 = G__5969;
chunk__5779_5956 = G__5970;
count__5780_5957 = G__5971;
i__5781_5958 = G__5972;
continue;
} else {
var vec__5791_5973 = cljs.core.first.call(null,seq__5778_5967__$1);
var col_5974 = cljs.core.nth.call(null,vec__5791_5973,(0),null);
var infos_5975 = cljs.core.nth.call(null,vec__5791_5973,(1),null);
encode_cols.call(null,infos_5975,source_idx_5905,line_5953,col_5974);


var G__5976 = cljs.core.next.call(null,seq__5778_5967__$1);
var G__5977 = null;
var G__5978 = (0);
var G__5979 = (0);
seq__5778_5955 = G__5976;
chunk__5779_5956 = G__5977;
count__5780_5957 = G__5978;
i__5781_5958 = G__5979;
continue;
}
} else {
}
}
break;
}


var G__5980 = cljs.core.next.call(null,seq__5714_5946__$1);
var G__5981 = null;
var G__5982 = (0);
var G__5983 = (0);
seq__5714_5909 = G__5980;
chunk__5715_5910 = G__5981;
count__5716_5911 = G__5982;
i__5717_5912 = G__5983;
continue;
}
} else {
}
}
break;
}


var G__5984 = seq__5532_5900;
var G__5985 = chunk__5533_5901;
var G__5986 = count__5534_5902;
var G__5987 = (i__5535_5903 + (1));
seq__5532_5900 = G__5984;
chunk__5533_5901 = G__5985;
count__5534_5902 = G__5986;
i__5535_5903 = G__5987;
continue;
} else {
var temp__5753__auto___5988 = cljs.core.seq.call(null,seq__5532_5900);
if(temp__5753__auto___5988){
var seq__5532_5989__$1 = temp__5753__auto___5988;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5532_5989__$1)){
var c__4679__auto___5990 = cljs.core.chunk_first.call(null,seq__5532_5989__$1);
var G__5991 = cljs.core.chunk_rest.call(null,seq__5532_5989__$1);
var G__5992 = c__4679__auto___5990;
var G__5993 = cljs.core.count.call(null,c__4679__auto___5990);
var G__5994 = (0);
seq__5532_5900 = G__5991;
chunk__5533_5901 = G__5992;
count__5534_5902 = G__5993;
i__5535_5903 = G__5994;
continue;
} else {
var vec__5794_5995 = cljs.core.first.call(null,seq__5532_5989__$1);
var source_idx_5996 = cljs.core.nth.call(null,vec__5794_5995,(0),null);
var vec__5797_5997 = cljs.core.nth.call(null,vec__5794_5995,(1),null);
var __5998 = cljs.core.nth.call(null,vec__5797_5997,(0),null);
var lines_5999__$1 = cljs.core.nth.call(null,vec__5797_5997,(1),null);
var seq__5800_6000 = cljs.core.seq.call(null,lines_5999__$1);
var chunk__5801_6001 = null;
var count__5802_6002 = (0);
var i__5803_6003 = (0);
while(true){
if((i__5803_6003 < count__5802_6002)){
var vec__5842_6004 = cljs.core._nth.call(null,chunk__5801_6001,i__5803_6003);
var line_6005 = cljs.core.nth.call(null,vec__5842_6004,(0),null);
var cols_6006 = cljs.core.nth.call(null,vec__5842_6004,(1),null);
var seq__5845_6007 = cljs.core.seq.call(null,cols_6006);
var chunk__5846_6008 = null;
var count__5847_6009 = (0);
var i__5848_6010 = (0);
while(true){
if((i__5848_6010 < count__5847_6009)){
var vec__5855_6011 = cljs.core._nth.call(null,chunk__5846_6008,i__5848_6010);
var col_6012 = cljs.core.nth.call(null,vec__5855_6011,(0),null);
var infos_6013 = cljs.core.nth.call(null,vec__5855_6011,(1),null);
encode_cols.call(null,infos_6013,source_idx_5996,line_6005,col_6012);


var G__6014 = seq__5845_6007;
var G__6015 = chunk__5846_6008;
var G__6016 = count__5847_6009;
var G__6017 = (i__5848_6010 + (1));
seq__5845_6007 = G__6014;
chunk__5846_6008 = G__6015;
count__5847_6009 = G__6016;
i__5848_6010 = G__6017;
continue;
} else {
var temp__5753__auto___6018__$1 = cljs.core.seq.call(null,seq__5845_6007);
if(temp__5753__auto___6018__$1){
var seq__5845_6019__$1 = temp__5753__auto___6018__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5845_6019__$1)){
var c__4679__auto___6020 = cljs.core.chunk_first.call(null,seq__5845_6019__$1);
var G__6021 = cljs.core.chunk_rest.call(null,seq__5845_6019__$1);
var G__6022 = c__4679__auto___6020;
var G__6023 = cljs.core.count.call(null,c__4679__auto___6020);
var G__6024 = (0);
seq__5845_6007 = G__6021;
chunk__5846_6008 = G__6022;
count__5847_6009 = G__6023;
i__5848_6010 = G__6024;
continue;
} else {
var vec__5858_6025 = cljs.core.first.call(null,seq__5845_6019__$1);
var col_6026 = cljs.core.nth.call(null,vec__5858_6025,(0),null);
var infos_6027 = cljs.core.nth.call(null,vec__5858_6025,(1),null);
encode_cols.call(null,infos_6027,source_idx_5996,line_6005,col_6026);


var G__6028 = cljs.core.next.call(null,seq__5845_6019__$1);
var G__6029 = null;
var G__6030 = (0);
var G__6031 = (0);
seq__5845_6007 = G__6028;
chunk__5846_6008 = G__6029;
count__5847_6009 = G__6030;
i__5848_6010 = G__6031;
continue;
}
} else {
}
}
break;
}


var G__6032 = seq__5800_6000;
var G__6033 = chunk__5801_6001;
var G__6034 = count__5802_6002;
var G__6035 = (i__5803_6003 + (1));
seq__5800_6000 = G__6032;
chunk__5801_6001 = G__6033;
count__5802_6002 = G__6034;
i__5803_6003 = G__6035;
continue;
} else {
var temp__5753__auto___6036__$1 = cljs.core.seq.call(null,seq__5800_6000);
if(temp__5753__auto___6036__$1){
var seq__5800_6037__$1 = temp__5753__auto___6036__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5800_6037__$1)){
var c__4679__auto___6038 = cljs.core.chunk_first.call(null,seq__5800_6037__$1);
var G__6039 = cljs.core.chunk_rest.call(null,seq__5800_6037__$1);
var G__6040 = c__4679__auto___6038;
var G__6041 = cljs.core.count.call(null,c__4679__auto___6038);
var G__6042 = (0);
seq__5800_6000 = G__6039;
chunk__5801_6001 = G__6040;
count__5802_6002 = G__6041;
i__5803_6003 = G__6042;
continue;
} else {
var vec__5861_6043 = cljs.core.first.call(null,seq__5800_6037__$1);
var line_6044 = cljs.core.nth.call(null,vec__5861_6043,(0),null);
var cols_6045 = cljs.core.nth.call(null,vec__5861_6043,(1),null);
var seq__5864_6046 = cljs.core.seq.call(null,cols_6045);
var chunk__5865_6047 = null;
var count__5866_6048 = (0);
var i__5867_6049 = (0);
while(true){
if((i__5867_6049 < count__5866_6048)){
var vec__5874_6050 = cljs.core._nth.call(null,chunk__5865_6047,i__5867_6049);
var col_6051 = cljs.core.nth.call(null,vec__5874_6050,(0),null);
var infos_6052 = cljs.core.nth.call(null,vec__5874_6050,(1),null);
encode_cols.call(null,infos_6052,source_idx_5996,line_6044,col_6051);


var G__6053 = seq__5864_6046;
var G__6054 = chunk__5865_6047;
var G__6055 = count__5866_6048;
var G__6056 = (i__5867_6049 + (1));
seq__5864_6046 = G__6053;
chunk__5865_6047 = G__6054;
count__5866_6048 = G__6055;
i__5867_6049 = G__6056;
continue;
} else {
var temp__5753__auto___6057__$2 = cljs.core.seq.call(null,seq__5864_6046);
if(temp__5753__auto___6057__$2){
var seq__5864_6058__$1 = temp__5753__auto___6057__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5864_6058__$1)){
var c__4679__auto___6059 = cljs.core.chunk_first.call(null,seq__5864_6058__$1);
var G__6060 = cljs.core.chunk_rest.call(null,seq__5864_6058__$1);
var G__6061 = c__4679__auto___6059;
var G__6062 = cljs.core.count.call(null,c__4679__auto___6059);
var G__6063 = (0);
seq__5864_6046 = G__6060;
chunk__5865_6047 = G__6061;
count__5866_6048 = G__6062;
i__5867_6049 = G__6063;
continue;
} else {
var vec__5877_6064 = cljs.core.first.call(null,seq__5864_6058__$1);
var col_6065 = cljs.core.nth.call(null,vec__5877_6064,(0),null);
var infos_6066 = cljs.core.nth.call(null,vec__5877_6064,(1),null);
encode_cols.call(null,infos_6066,source_idx_5996,line_6044,col_6065);


var G__6067 = cljs.core.next.call(null,seq__5864_6058__$1);
var G__6068 = null;
var G__6069 = (0);
var G__6070 = (0);
seq__5864_6046 = G__6067;
chunk__5865_6047 = G__6068;
count__5866_6048 = G__6069;
i__5867_6049 = G__6070;
continue;
}
} else {
}
}
break;
}


var G__6071 = cljs.core.next.call(null,seq__5800_6037__$1);
var G__6072 = null;
var G__6073 = (0);
var G__6074 = (0);
seq__5800_6000 = G__6071;
chunk__5801_6001 = G__6072;
count__5802_6002 = G__6073;
i__5803_6003 = G__6074;
continue;
}
} else {
}
}
break;
}


var G__6075 = cljs.core.next.call(null,seq__5532_5989__$1);
var G__6076 = null;
var G__6077 = (0);
var G__6078 = (0);
seq__5532_5900 = G__6075;
chunk__5533_5901 = G__6076;
count__5534_5902 = G__6077;
i__5535_5903 = G__6078;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__5880 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__5525_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__5525_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__5526_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__5526_SHARP_,/\//));
}));
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,(function (p1__5527_SHARP_){
return clojure.string.join.call(null,",",p1__5527_SHARP_);
}),cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__5881 = G__5880;
cljs.source_map.goog$module$goog$object.set.call(null,G__5881,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__5881;
} else {
return G__5880;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__6079 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__6079,(0),null);
var col_map = cljs.core.nth.call(null,vec__6079,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__6082 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__6082,(0),null);
var infos = cljs.core.nth.call(null,vec__6082,(1),null);
var G__6087 = cljs.core.next.call(null,col_map_seq);
var G__6088 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__6082,col,infos,vec__6079,line,col_map){
return (function (v,p__6085){
var map__6086 = p__6085;
var map__6086__$1 = cljs.core.__destructure_map.call(null,map__6086);
var gline = cljs.core.get.call(null,map__6086__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__6086__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__6082,col,infos,vec__6079,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__6087;
new_cols = G__6088;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__6089 = cljs.core.next.call(null,line_map_seq);
var G__6090 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__6089;
new_lines = G__6090;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__6091_6299 = cljs.core.seq.call(null,reverse_map);
var chunk__6092_6300 = null;
var count__6093_6301 = (0);
var i__6094_6302 = (0);
while(true){
if((i__6094_6302 < count__6093_6301)){
var vec__6197_6303 = cljs.core._nth.call(null,chunk__6092_6300,i__6094_6302);
var line_6304 = cljs.core.nth.call(null,vec__6197_6303,(0),null);
var columns_6305 = cljs.core.nth.call(null,vec__6197_6303,(1),null);
var seq__6200_6306 = cljs.core.seq.call(null,columns_6305);
var chunk__6201_6307 = null;
var count__6202_6308 = (0);
var i__6203_6309 = (0);
while(true){
if((i__6203_6309 < count__6202_6308)){
var vec__6226_6310 = cljs.core._nth.call(null,chunk__6201_6307,i__6203_6309);
var column_6311 = cljs.core.nth.call(null,vec__6226_6310,(0),null);
var column_info_6312 = cljs.core.nth.call(null,vec__6226_6310,(1),null);
var seq__6229_6313 = cljs.core.seq.call(null,column_info_6312);
var chunk__6230_6314 = null;
var count__6231_6315 = (0);
var i__6232_6316 = (0);
while(true){
if((i__6232_6316 < count__6231_6315)){
var map__6235_6317 = cljs.core._nth.call(null,chunk__6230_6314,i__6232_6316);
var map__6235_6318__$1 = cljs.core.__destructure_map.call(null,map__6235_6317);
var gline_6319 = cljs.core.get.call(null,map__6235_6318__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6320 = cljs.core.get.call(null,map__6235_6318__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6321 = cljs.core.get.call(null,map__6235_6318__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6319], null),cljs.core.fnil.call(null,((function (seq__6229_6313,chunk__6230_6314,count__6231_6315,i__6232_6316,seq__6200_6306,chunk__6201_6307,count__6202_6308,i__6203_6309,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6235_6317,map__6235_6318__$1,gline_6319,gcol_6320,name_6321,vec__6226_6310,column_6311,column_info_6312,vec__6197_6303,line_6304,columns_6305,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6320], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6304,new cljs.core.Keyword(null,"col","col",-1959363084),column_6311,new cljs.core.Keyword(null,"name","name",1843675177),name_6321], null));
});})(seq__6229_6313,chunk__6230_6314,count__6231_6315,i__6232_6316,seq__6200_6306,chunk__6201_6307,count__6202_6308,i__6203_6309,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6235_6317,map__6235_6318__$1,gline_6319,gcol_6320,name_6321,vec__6226_6310,column_6311,column_info_6312,vec__6197_6303,line_6304,columns_6305,inverted))
,cljs.core.sorted_map.call(null)));


var G__6322 = seq__6229_6313;
var G__6323 = chunk__6230_6314;
var G__6324 = count__6231_6315;
var G__6325 = (i__6232_6316 + (1));
seq__6229_6313 = G__6322;
chunk__6230_6314 = G__6323;
count__6231_6315 = G__6324;
i__6232_6316 = G__6325;
continue;
} else {
var temp__5753__auto___6326 = cljs.core.seq.call(null,seq__6229_6313);
if(temp__5753__auto___6326){
var seq__6229_6327__$1 = temp__5753__auto___6326;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6229_6327__$1)){
var c__4679__auto___6328 = cljs.core.chunk_first.call(null,seq__6229_6327__$1);
var G__6329 = cljs.core.chunk_rest.call(null,seq__6229_6327__$1);
var G__6330 = c__4679__auto___6328;
var G__6331 = cljs.core.count.call(null,c__4679__auto___6328);
var G__6332 = (0);
seq__6229_6313 = G__6329;
chunk__6230_6314 = G__6330;
count__6231_6315 = G__6331;
i__6232_6316 = G__6332;
continue;
} else {
var map__6236_6333 = cljs.core.first.call(null,seq__6229_6327__$1);
var map__6236_6334__$1 = cljs.core.__destructure_map.call(null,map__6236_6333);
var gline_6335 = cljs.core.get.call(null,map__6236_6334__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6336 = cljs.core.get.call(null,map__6236_6334__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6337 = cljs.core.get.call(null,map__6236_6334__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6335], null),cljs.core.fnil.call(null,((function (seq__6229_6313,chunk__6230_6314,count__6231_6315,i__6232_6316,seq__6200_6306,chunk__6201_6307,count__6202_6308,i__6203_6309,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6236_6333,map__6236_6334__$1,gline_6335,gcol_6336,name_6337,seq__6229_6327__$1,temp__5753__auto___6326,vec__6226_6310,column_6311,column_info_6312,vec__6197_6303,line_6304,columns_6305,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6336], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6304,new cljs.core.Keyword(null,"col","col",-1959363084),column_6311,new cljs.core.Keyword(null,"name","name",1843675177),name_6337], null));
});})(seq__6229_6313,chunk__6230_6314,count__6231_6315,i__6232_6316,seq__6200_6306,chunk__6201_6307,count__6202_6308,i__6203_6309,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6236_6333,map__6236_6334__$1,gline_6335,gcol_6336,name_6337,seq__6229_6327__$1,temp__5753__auto___6326,vec__6226_6310,column_6311,column_info_6312,vec__6197_6303,line_6304,columns_6305,inverted))
,cljs.core.sorted_map.call(null)));


var G__6338 = cljs.core.next.call(null,seq__6229_6327__$1);
var G__6339 = null;
var G__6340 = (0);
var G__6341 = (0);
seq__6229_6313 = G__6338;
chunk__6230_6314 = G__6339;
count__6231_6315 = G__6340;
i__6232_6316 = G__6341;
continue;
}
} else {
}
}
break;
}


var G__6342 = seq__6200_6306;
var G__6343 = chunk__6201_6307;
var G__6344 = count__6202_6308;
var G__6345 = (i__6203_6309 + (1));
seq__6200_6306 = G__6342;
chunk__6201_6307 = G__6343;
count__6202_6308 = G__6344;
i__6203_6309 = G__6345;
continue;
} else {
var temp__5753__auto___6346 = cljs.core.seq.call(null,seq__6200_6306);
if(temp__5753__auto___6346){
var seq__6200_6347__$1 = temp__5753__auto___6346;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6200_6347__$1)){
var c__4679__auto___6348 = cljs.core.chunk_first.call(null,seq__6200_6347__$1);
var G__6349 = cljs.core.chunk_rest.call(null,seq__6200_6347__$1);
var G__6350 = c__4679__auto___6348;
var G__6351 = cljs.core.count.call(null,c__4679__auto___6348);
var G__6352 = (0);
seq__6200_6306 = G__6349;
chunk__6201_6307 = G__6350;
count__6202_6308 = G__6351;
i__6203_6309 = G__6352;
continue;
} else {
var vec__6237_6353 = cljs.core.first.call(null,seq__6200_6347__$1);
var column_6354 = cljs.core.nth.call(null,vec__6237_6353,(0),null);
var column_info_6355 = cljs.core.nth.call(null,vec__6237_6353,(1),null);
var seq__6240_6356 = cljs.core.seq.call(null,column_info_6355);
var chunk__6241_6357 = null;
var count__6242_6358 = (0);
var i__6243_6359 = (0);
while(true){
if((i__6243_6359 < count__6242_6358)){
var map__6246_6360 = cljs.core._nth.call(null,chunk__6241_6357,i__6243_6359);
var map__6246_6361__$1 = cljs.core.__destructure_map.call(null,map__6246_6360);
var gline_6362 = cljs.core.get.call(null,map__6246_6361__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6363 = cljs.core.get.call(null,map__6246_6361__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6364 = cljs.core.get.call(null,map__6246_6361__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6362], null),cljs.core.fnil.call(null,((function (seq__6240_6356,chunk__6241_6357,count__6242_6358,i__6243_6359,seq__6200_6306,chunk__6201_6307,count__6202_6308,i__6203_6309,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6246_6360,map__6246_6361__$1,gline_6362,gcol_6363,name_6364,vec__6237_6353,column_6354,column_info_6355,seq__6200_6347__$1,temp__5753__auto___6346,vec__6197_6303,line_6304,columns_6305,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6363], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6304,new cljs.core.Keyword(null,"col","col",-1959363084),column_6354,new cljs.core.Keyword(null,"name","name",1843675177),name_6364], null));
});})(seq__6240_6356,chunk__6241_6357,count__6242_6358,i__6243_6359,seq__6200_6306,chunk__6201_6307,count__6202_6308,i__6203_6309,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6246_6360,map__6246_6361__$1,gline_6362,gcol_6363,name_6364,vec__6237_6353,column_6354,column_info_6355,seq__6200_6347__$1,temp__5753__auto___6346,vec__6197_6303,line_6304,columns_6305,inverted))
,cljs.core.sorted_map.call(null)));


var G__6365 = seq__6240_6356;
var G__6366 = chunk__6241_6357;
var G__6367 = count__6242_6358;
var G__6368 = (i__6243_6359 + (1));
seq__6240_6356 = G__6365;
chunk__6241_6357 = G__6366;
count__6242_6358 = G__6367;
i__6243_6359 = G__6368;
continue;
} else {
var temp__5753__auto___6369__$1 = cljs.core.seq.call(null,seq__6240_6356);
if(temp__5753__auto___6369__$1){
var seq__6240_6370__$1 = temp__5753__auto___6369__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6240_6370__$1)){
var c__4679__auto___6371 = cljs.core.chunk_first.call(null,seq__6240_6370__$1);
var G__6372 = cljs.core.chunk_rest.call(null,seq__6240_6370__$1);
var G__6373 = c__4679__auto___6371;
var G__6374 = cljs.core.count.call(null,c__4679__auto___6371);
var G__6375 = (0);
seq__6240_6356 = G__6372;
chunk__6241_6357 = G__6373;
count__6242_6358 = G__6374;
i__6243_6359 = G__6375;
continue;
} else {
var map__6247_6376 = cljs.core.first.call(null,seq__6240_6370__$1);
var map__6247_6377__$1 = cljs.core.__destructure_map.call(null,map__6247_6376);
var gline_6378 = cljs.core.get.call(null,map__6247_6377__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6379 = cljs.core.get.call(null,map__6247_6377__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6380 = cljs.core.get.call(null,map__6247_6377__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6378], null),cljs.core.fnil.call(null,((function (seq__6240_6356,chunk__6241_6357,count__6242_6358,i__6243_6359,seq__6200_6306,chunk__6201_6307,count__6202_6308,i__6203_6309,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6247_6376,map__6247_6377__$1,gline_6378,gcol_6379,name_6380,seq__6240_6370__$1,temp__5753__auto___6369__$1,vec__6237_6353,column_6354,column_info_6355,seq__6200_6347__$1,temp__5753__auto___6346,vec__6197_6303,line_6304,columns_6305,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6379], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6304,new cljs.core.Keyword(null,"col","col",-1959363084),column_6354,new cljs.core.Keyword(null,"name","name",1843675177),name_6380], null));
});})(seq__6240_6356,chunk__6241_6357,count__6242_6358,i__6243_6359,seq__6200_6306,chunk__6201_6307,count__6202_6308,i__6203_6309,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6247_6376,map__6247_6377__$1,gline_6378,gcol_6379,name_6380,seq__6240_6370__$1,temp__5753__auto___6369__$1,vec__6237_6353,column_6354,column_info_6355,seq__6200_6347__$1,temp__5753__auto___6346,vec__6197_6303,line_6304,columns_6305,inverted))
,cljs.core.sorted_map.call(null)));


var G__6381 = cljs.core.next.call(null,seq__6240_6370__$1);
var G__6382 = null;
var G__6383 = (0);
var G__6384 = (0);
seq__6240_6356 = G__6381;
chunk__6241_6357 = G__6382;
count__6242_6358 = G__6383;
i__6243_6359 = G__6384;
continue;
}
} else {
}
}
break;
}


var G__6385 = cljs.core.next.call(null,seq__6200_6347__$1);
var G__6386 = null;
var G__6387 = (0);
var G__6388 = (0);
seq__6200_6306 = G__6385;
chunk__6201_6307 = G__6386;
count__6202_6308 = G__6387;
i__6203_6309 = G__6388;
continue;
}
} else {
}
}
break;
}


var G__6389 = seq__6091_6299;
var G__6390 = chunk__6092_6300;
var G__6391 = count__6093_6301;
var G__6392 = (i__6094_6302 + (1));
seq__6091_6299 = G__6389;
chunk__6092_6300 = G__6390;
count__6093_6301 = G__6391;
i__6094_6302 = G__6392;
continue;
} else {
var temp__5753__auto___6393 = cljs.core.seq.call(null,seq__6091_6299);
if(temp__5753__auto___6393){
var seq__6091_6394__$1 = temp__5753__auto___6393;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6091_6394__$1)){
var c__4679__auto___6395 = cljs.core.chunk_first.call(null,seq__6091_6394__$1);
var G__6396 = cljs.core.chunk_rest.call(null,seq__6091_6394__$1);
var G__6397 = c__4679__auto___6395;
var G__6398 = cljs.core.count.call(null,c__4679__auto___6395);
var G__6399 = (0);
seq__6091_6299 = G__6396;
chunk__6092_6300 = G__6397;
count__6093_6301 = G__6398;
i__6094_6302 = G__6399;
continue;
} else {
var vec__6248_6400 = cljs.core.first.call(null,seq__6091_6394__$1);
var line_6401 = cljs.core.nth.call(null,vec__6248_6400,(0),null);
var columns_6402 = cljs.core.nth.call(null,vec__6248_6400,(1),null);
var seq__6251_6403 = cljs.core.seq.call(null,columns_6402);
var chunk__6252_6404 = null;
var count__6253_6405 = (0);
var i__6254_6406 = (0);
while(true){
if((i__6254_6406 < count__6253_6405)){
var vec__6277_6407 = cljs.core._nth.call(null,chunk__6252_6404,i__6254_6406);
var column_6408 = cljs.core.nth.call(null,vec__6277_6407,(0),null);
var column_info_6409 = cljs.core.nth.call(null,vec__6277_6407,(1),null);
var seq__6280_6410 = cljs.core.seq.call(null,column_info_6409);
var chunk__6281_6411 = null;
var count__6282_6412 = (0);
var i__6283_6413 = (0);
while(true){
if((i__6283_6413 < count__6282_6412)){
var map__6286_6414 = cljs.core._nth.call(null,chunk__6281_6411,i__6283_6413);
var map__6286_6415__$1 = cljs.core.__destructure_map.call(null,map__6286_6414);
var gline_6416 = cljs.core.get.call(null,map__6286_6415__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6417 = cljs.core.get.call(null,map__6286_6415__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6418 = cljs.core.get.call(null,map__6286_6415__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6416], null),cljs.core.fnil.call(null,((function (seq__6280_6410,chunk__6281_6411,count__6282_6412,i__6283_6413,seq__6251_6403,chunk__6252_6404,count__6253_6405,i__6254_6406,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6286_6414,map__6286_6415__$1,gline_6416,gcol_6417,name_6418,vec__6277_6407,column_6408,column_info_6409,vec__6248_6400,line_6401,columns_6402,seq__6091_6394__$1,temp__5753__auto___6393,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6417], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6401,new cljs.core.Keyword(null,"col","col",-1959363084),column_6408,new cljs.core.Keyword(null,"name","name",1843675177),name_6418], null));
});})(seq__6280_6410,chunk__6281_6411,count__6282_6412,i__6283_6413,seq__6251_6403,chunk__6252_6404,count__6253_6405,i__6254_6406,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6286_6414,map__6286_6415__$1,gline_6416,gcol_6417,name_6418,vec__6277_6407,column_6408,column_info_6409,vec__6248_6400,line_6401,columns_6402,seq__6091_6394__$1,temp__5753__auto___6393,inverted))
,cljs.core.sorted_map.call(null)));


var G__6419 = seq__6280_6410;
var G__6420 = chunk__6281_6411;
var G__6421 = count__6282_6412;
var G__6422 = (i__6283_6413 + (1));
seq__6280_6410 = G__6419;
chunk__6281_6411 = G__6420;
count__6282_6412 = G__6421;
i__6283_6413 = G__6422;
continue;
} else {
var temp__5753__auto___6423__$1 = cljs.core.seq.call(null,seq__6280_6410);
if(temp__5753__auto___6423__$1){
var seq__6280_6424__$1 = temp__5753__auto___6423__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6280_6424__$1)){
var c__4679__auto___6425 = cljs.core.chunk_first.call(null,seq__6280_6424__$1);
var G__6426 = cljs.core.chunk_rest.call(null,seq__6280_6424__$1);
var G__6427 = c__4679__auto___6425;
var G__6428 = cljs.core.count.call(null,c__4679__auto___6425);
var G__6429 = (0);
seq__6280_6410 = G__6426;
chunk__6281_6411 = G__6427;
count__6282_6412 = G__6428;
i__6283_6413 = G__6429;
continue;
} else {
var map__6287_6430 = cljs.core.first.call(null,seq__6280_6424__$1);
var map__6287_6431__$1 = cljs.core.__destructure_map.call(null,map__6287_6430);
var gline_6432 = cljs.core.get.call(null,map__6287_6431__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6433 = cljs.core.get.call(null,map__6287_6431__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6434 = cljs.core.get.call(null,map__6287_6431__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6432], null),cljs.core.fnil.call(null,((function (seq__6280_6410,chunk__6281_6411,count__6282_6412,i__6283_6413,seq__6251_6403,chunk__6252_6404,count__6253_6405,i__6254_6406,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6287_6430,map__6287_6431__$1,gline_6432,gcol_6433,name_6434,seq__6280_6424__$1,temp__5753__auto___6423__$1,vec__6277_6407,column_6408,column_info_6409,vec__6248_6400,line_6401,columns_6402,seq__6091_6394__$1,temp__5753__auto___6393,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6433], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6401,new cljs.core.Keyword(null,"col","col",-1959363084),column_6408,new cljs.core.Keyword(null,"name","name",1843675177),name_6434], null));
});})(seq__6280_6410,chunk__6281_6411,count__6282_6412,i__6283_6413,seq__6251_6403,chunk__6252_6404,count__6253_6405,i__6254_6406,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6287_6430,map__6287_6431__$1,gline_6432,gcol_6433,name_6434,seq__6280_6424__$1,temp__5753__auto___6423__$1,vec__6277_6407,column_6408,column_info_6409,vec__6248_6400,line_6401,columns_6402,seq__6091_6394__$1,temp__5753__auto___6393,inverted))
,cljs.core.sorted_map.call(null)));


var G__6435 = cljs.core.next.call(null,seq__6280_6424__$1);
var G__6436 = null;
var G__6437 = (0);
var G__6438 = (0);
seq__6280_6410 = G__6435;
chunk__6281_6411 = G__6436;
count__6282_6412 = G__6437;
i__6283_6413 = G__6438;
continue;
}
} else {
}
}
break;
}


var G__6439 = seq__6251_6403;
var G__6440 = chunk__6252_6404;
var G__6441 = count__6253_6405;
var G__6442 = (i__6254_6406 + (1));
seq__6251_6403 = G__6439;
chunk__6252_6404 = G__6440;
count__6253_6405 = G__6441;
i__6254_6406 = G__6442;
continue;
} else {
var temp__5753__auto___6443__$1 = cljs.core.seq.call(null,seq__6251_6403);
if(temp__5753__auto___6443__$1){
var seq__6251_6444__$1 = temp__5753__auto___6443__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6251_6444__$1)){
var c__4679__auto___6445 = cljs.core.chunk_first.call(null,seq__6251_6444__$1);
var G__6446 = cljs.core.chunk_rest.call(null,seq__6251_6444__$1);
var G__6447 = c__4679__auto___6445;
var G__6448 = cljs.core.count.call(null,c__4679__auto___6445);
var G__6449 = (0);
seq__6251_6403 = G__6446;
chunk__6252_6404 = G__6447;
count__6253_6405 = G__6448;
i__6254_6406 = G__6449;
continue;
} else {
var vec__6288_6450 = cljs.core.first.call(null,seq__6251_6444__$1);
var column_6451 = cljs.core.nth.call(null,vec__6288_6450,(0),null);
var column_info_6452 = cljs.core.nth.call(null,vec__6288_6450,(1),null);
var seq__6291_6453 = cljs.core.seq.call(null,column_info_6452);
var chunk__6292_6454 = null;
var count__6293_6455 = (0);
var i__6294_6456 = (0);
while(true){
if((i__6294_6456 < count__6293_6455)){
var map__6297_6457 = cljs.core._nth.call(null,chunk__6292_6454,i__6294_6456);
var map__6297_6458__$1 = cljs.core.__destructure_map.call(null,map__6297_6457);
var gline_6459 = cljs.core.get.call(null,map__6297_6458__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6460 = cljs.core.get.call(null,map__6297_6458__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6461 = cljs.core.get.call(null,map__6297_6458__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6459], null),cljs.core.fnil.call(null,((function (seq__6291_6453,chunk__6292_6454,count__6293_6455,i__6294_6456,seq__6251_6403,chunk__6252_6404,count__6253_6405,i__6254_6406,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6297_6457,map__6297_6458__$1,gline_6459,gcol_6460,name_6461,vec__6288_6450,column_6451,column_info_6452,seq__6251_6444__$1,temp__5753__auto___6443__$1,vec__6248_6400,line_6401,columns_6402,seq__6091_6394__$1,temp__5753__auto___6393,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6460], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6401,new cljs.core.Keyword(null,"col","col",-1959363084),column_6451,new cljs.core.Keyword(null,"name","name",1843675177),name_6461], null));
});})(seq__6291_6453,chunk__6292_6454,count__6293_6455,i__6294_6456,seq__6251_6403,chunk__6252_6404,count__6253_6405,i__6254_6406,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6297_6457,map__6297_6458__$1,gline_6459,gcol_6460,name_6461,vec__6288_6450,column_6451,column_info_6452,seq__6251_6444__$1,temp__5753__auto___6443__$1,vec__6248_6400,line_6401,columns_6402,seq__6091_6394__$1,temp__5753__auto___6393,inverted))
,cljs.core.sorted_map.call(null)));


var G__6462 = seq__6291_6453;
var G__6463 = chunk__6292_6454;
var G__6464 = count__6293_6455;
var G__6465 = (i__6294_6456 + (1));
seq__6291_6453 = G__6462;
chunk__6292_6454 = G__6463;
count__6293_6455 = G__6464;
i__6294_6456 = G__6465;
continue;
} else {
var temp__5753__auto___6466__$2 = cljs.core.seq.call(null,seq__6291_6453);
if(temp__5753__auto___6466__$2){
var seq__6291_6467__$1 = temp__5753__auto___6466__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6291_6467__$1)){
var c__4679__auto___6468 = cljs.core.chunk_first.call(null,seq__6291_6467__$1);
var G__6469 = cljs.core.chunk_rest.call(null,seq__6291_6467__$1);
var G__6470 = c__4679__auto___6468;
var G__6471 = cljs.core.count.call(null,c__4679__auto___6468);
var G__6472 = (0);
seq__6291_6453 = G__6469;
chunk__6292_6454 = G__6470;
count__6293_6455 = G__6471;
i__6294_6456 = G__6472;
continue;
} else {
var map__6298_6473 = cljs.core.first.call(null,seq__6291_6467__$1);
var map__6298_6474__$1 = cljs.core.__destructure_map.call(null,map__6298_6473);
var gline_6475 = cljs.core.get.call(null,map__6298_6474__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6476 = cljs.core.get.call(null,map__6298_6474__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6477 = cljs.core.get.call(null,map__6298_6474__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6475], null),cljs.core.fnil.call(null,((function (seq__6291_6453,chunk__6292_6454,count__6293_6455,i__6294_6456,seq__6251_6403,chunk__6252_6404,count__6253_6405,i__6254_6406,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6298_6473,map__6298_6474__$1,gline_6475,gcol_6476,name_6477,seq__6291_6467__$1,temp__5753__auto___6466__$2,vec__6288_6450,column_6451,column_info_6452,seq__6251_6444__$1,temp__5753__auto___6443__$1,vec__6248_6400,line_6401,columns_6402,seq__6091_6394__$1,temp__5753__auto___6393,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6476], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6401,new cljs.core.Keyword(null,"col","col",-1959363084),column_6451,new cljs.core.Keyword(null,"name","name",1843675177),name_6477], null));
});})(seq__6291_6453,chunk__6292_6454,count__6293_6455,i__6294_6456,seq__6251_6403,chunk__6252_6404,count__6253_6405,i__6254_6406,seq__6091_6299,chunk__6092_6300,count__6093_6301,i__6094_6302,map__6298_6473,map__6298_6474__$1,gline_6475,gcol_6476,name_6477,seq__6291_6467__$1,temp__5753__auto___6466__$2,vec__6288_6450,column_6451,column_info_6452,seq__6251_6444__$1,temp__5753__auto___6443__$1,vec__6248_6400,line_6401,columns_6402,seq__6091_6394__$1,temp__5753__auto___6393,inverted))
,cljs.core.sorted_map.call(null)));


var G__6478 = cljs.core.next.call(null,seq__6291_6467__$1);
var G__6479 = null;
var G__6480 = (0);
var G__6481 = (0);
seq__6291_6453 = G__6478;
chunk__6292_6454 = G__6479;
count__6293_6455 = G__6480;
i__6294_6456 = G__6481;
continue;
}
} else {
}
}
break;
}


var G__6482 = cljs.core.next.call(null,seq__6251_6444__$1);
var G__6483 = null;
var G__6484 = (0);
var G__6485 = (0);
seq__6251_6403 = G__6482;
chunk__6252_6404 = G__6483;
count__6253_6405 = G__6484;
i__6254_6406 = G__6485;
continue;
}
} else {
}
}
break;
}


var G__6486 = cljs.core.next.call(null,seq__6091_6394__$1);
var G__6487 = null;
var G__6488 = (0);
var G__6489 = (0);
seq__6091_6299 = G__6486;
chunk__6092_6300 = G__6487;
count__6093_6301 = G__6488;
i__6094_6302 = G__6489;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});
