// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__67097 = arguments.length;
switch (G__67097) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2763__auto___67136 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_67118){
var state_val_67119 = (state_67118[(1)]);
if((state_val_67119 === (1))){
var state_67118__$1 = state_67118;
var statearr_67120_67137 = state_67118__$1;
(statearr_67120_67137[(2)] = null);

(statearr_67120_67137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67119 === (2))){
var _ = (function (){var statearr_67121 = state_67118;
(statearr_67121[(4)] = cljs.core.cons.call(null,(5),(state_67118[(4)])));

return statearr_67121;
})();
var inst_67104 = fluree.db.session.db.call(null,conn,ledger,null);
var state_67118__$1 = state_67118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67118__$1,(7),inst_67104);
} else {
if((state_val_67119 === (3))){
var inst_67114 = (state_67118[(2)]);
var inst_67115 = cljs.core.async.put_BANG_.call(null,pc,inst_67114);
var inst_67116 = cljs.core.async.close_BANG_.call(null,pc);
var state_67118__$1 = (function (){var statearr_67123 = state_67118;
(statearr_67123[(7)] = inst_67115);

return statearr_67123;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67118__$1,inst_67116);
} else {
if((state_val_67119 === (4))){
var inst_67098 = (state_67118[(2)]);
var state_67118__$1 = state_67118;
var statearr_67124_67138 = state_67118__$1;
(statearr_67124_67138[(2)] = inst_67098);

(statearr_67124_67138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67119 === (5))){
var _ = (function (){var statearr_67125 = state_67118;
(statearr_67125[(4)] = cljs.core.rest.call(null,(state_67118[(4)])));

return statearr_67125;
})();
var state_67118__$1 = state_67118;
var ex67122 = (state_67118__$1[(2)]);
var statearr_67126_67139 = state_67118__$1;
(statearr_67126_67139[(5)] = ex67122);


var statearr_67127_67140 = state_67118__$1;
(statearr_67127_67140[(1)] = (4));

(statearr_67127_67140[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67119 === (6))){
var inst_67110 = (state_67118[(2)]);
var inst_67111 = fluree.db.util.async.throw_err.call(null,inst_67110);
var _ = (function (){var statearr_67128 = state_67118;
(statearr_67128[(4)] = cljs.core.rest.call(null,(state_67118[(4)])));

return statearr_67128;
})();
var state_67118__$1 = state_67118;
var statearr_67129_67141 = state_67118__$1;
(statearr_67129_67141[(2)] = inst_67111);

(statearr_67129_67141[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67119 === (7))){
var inst_67106 = (state_67118[(2)]);
var inst_67107 = fluree.db.util.async.throw_err.call(null,inst_67106);
var inst_67108 = fluree.db.time_travel.as_of_block.call(null,inst_67107,block);
var state_67118__$1 = state_67118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67118__$1,(6),inst_67108);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2741__auto__ = null;
var fluree$db$api$ledger$state_machine__2741__auto____0 = (function (){
var statearr_67130 = [null,null,null,null,null,null,null,null];
(statearr_67130[(0)] = fluree$db$api$ledger$state_machine__2741__auto__);

(statearr_67130[(1)] = (1));

return statearr_67130;
});
var fluree$db$api$ledger$state_machine__2741__auto____1 = (function (state_67118){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_67118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e67131){var ex__2744__auto__ = e67131;
var statearr_67132_67142 = state_67118;
(statearr_67132_67142[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_67118[(4)]))){
var statearr_67133_67143 = state_67118;
(statearr_67133_67143[(1)] = cljs.core.first.call(null,(state_67118[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67144 = state_67118;
state_67118 = G__67144;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2741__auto__ = function(state_67118){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2741__auto____1.call(this,state_67118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2741__auto____0;
fluree$db$api$ledger$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2741__auto____1;
return fluree$db$api$ledger$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_67134 = f__2764__auto__.call(null);
(statearr_67134[(6)] = c__2763__auto___67136);

return statearr_67134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_67185){
var state_val_67186 = (state_67185[(1)]);
if((state_val_67186 === (7))){
var inst_67154 = cljs.core._EQ_.call(null,(0),auth);
var state_67185__$1 = state_67185;
if(inst_67154){
var statearr_67187_67218 = state_67185__$1;
(statearr_67187_67218[(1)] = (9));

} else {
var statearr_67188_67219 = state_67185__$1;
(statearr_67188_67219[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (1))){
var state_67185__$1 = state_67185;
var statearr_67189_67220 = state_67185__$1;
(statearr_67189_67220[(2)] = null);

(statearr_67189_67220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (4))){
var inst_67145 = (state_67185[(2)]);
var state_67185__$1 = state_67185;
var statearr_67190_67221 = state_67185__$1;
(statearr_67190_67221[(2)] = inst_67145);

(statearr_67190_67221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (15))){
var inst_67162 = (state_67185[(7)]);
var inst_67161 = (state_67185[(2)]);
var inst_67162__$1 = fluree.db.util.async.throw_err.call(null,inst_67161);
var state_67185__$1 = (function (){var statearr_67191 = state_67185;
(statearr_67191[(7)] = inst_67162__$1);

return statearr_67191;
})();
if(cljs.core.truth_(inst_67162__$1)){
var statearr_67192_67222 = state_67185__$1;
(statearr_67192_67222[(1)] = (16));

} else {
var statearr_67193_67223 = state_67185__$1;
(statearr_67193_67223[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (13))){
var state_67185__$1 = state_67185;
var statearr_67194_67224 = state_67185__$1;
(statearr_67194_67224[(2)] = null);

(statearr_67194_67224[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (6))){
var state_67185__$1 = state_67185;
var statearr_67195_67225 = state_67185__$1;
(statearr_67195_67225[(2)] = db);

(statearr_67195_67225[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (17))){
var inst_67166 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_67167 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67168 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_67169 = cljs.core.PersistentHashMap.fromArrays(inst_67167,inst_67168);
var inst_67170 = cljs.core.ex_info.call(null,inst_67166,inst_67169);
var inst_67171 = (function(){throw inst_67170})();
var state_67185__$1 = state_67185;
var statearr_67196_67226 = state_67185__$1;
(statearr_67196_67226[(2)] = inst_67171);

(statearr_67196_67226[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (3))){
var inst_67183 = (state_67185[(2)]);
var state_67185__$1 = state_67185;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67185__$1,inst_67183);
} else {
if((state_val_67186 === (12))){
var inst_67159 = fluree.db.dbproto._subid.call(null,db,auth);
var state_67185__$1 = state_67185;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67185__$1,(15),inst_67159);
} else {
if((state_val_67186 === (2))){
var _ = (function (){var statearr_67197 = state_67185;
(statearr_67197[(4)] = cljs.core.cons.call(null,(5),(state_67185[(4)])));

return statearr_67197;
})();
var inst_67151 = cljs.core.not.call(null,auth);
var state_67185__$1 = state_67185;
if(inst_67151){
var statearr_67198_67227 = state_67185__$1;
(statearr_67198_67227[(1)] = (6));

} else {
var statearr_67199_67228 = state_67185__$1;
(statearr_67199_67228[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (11))){
var inst_67178 = (state_67185[(2)]);
var state_67185__$1 = state_67185;
var statearr_67201_67229 = state_67185__$1;
(statearr_67201_67229[(2)] = inst_67178);

(statearr_67201_67229[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (9))){
var inst_67156 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_67185__$1 = state_67185;
var statearr_67202_67230 = state_67185__$1;
(statearr_67202_67230[(2)] = inst_67156);

(statearr_67202_67230[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (5))){
var _ = (function (){var statearr_67203 = state_67185;
(statearr_67203[(4)] = cljs.core.rest.call(null,(state_67185[(4)])));

return statearr_67203;
})();
var state_67185__$1 = state_67185;
var ex67200 = (state_67185__$1[(2)]);
var statearr_67204_67231 = state_67185__$1;
(statearr_67204_67231[(5)] = ex67200);


if((ex67200 instanceof Error)){
var statearr_67205_67232 = state_67185__$1;
(statearr_67205_67232[(1)] = (4));

(statearr_67205_67232[(5)] = null);

} else {
throw ex67200;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (14))){
var inst_67176 = (state_67185[(2)]);
var state_67185__$1 = state_67185;
var statearr_67206_67233 = state_67185__$1;
(statearr_67206_67233[(2)] = inst_67176);

(statearr_67206_67233[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (16))){
var inst_67162 = (state_67185[(7)]);
var inst_67164 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_67162);
var state_67185__$1 = state_67185;
var statearr_67207_67234 = state_67185__$1;
(statearr_67207_67234[(2)] = inst_67164);

(statearr_67207_67234[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (10))){
var state_67185__$1 = state_67185;
var statearr_67208_67235 = state_67185__$1;
(statearr_67208_67235[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (18))){
var inst_67173 = (state_67185[(2)]);
var state_67185__$1 = state_67185;
var statearr_67210_67236 = state_67185__$1;
(statearr_67210_67236[(2)] = inst_67173);

(statearr_67210_67236[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67186 === (8))){
var inst_67180 = (state_67185[(2)]);
var _ = (function (){var statearr_67211 = state_67185;
(statearr_67211[(4)] = cljs.core.rest.call(null,(state_67185[(4)])));

return statearr_67211;
})();
var state_67185__$1 = state_67185;
var statearr_67212_67237 = state_67185__$1;
(statearr_67212_67237[(2)] = inst_67180);

(statearr_67212_67237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____0 = (function (){
var statearr_67213 = [null,null,null,null,null,null,null,null];
(statearr_67213[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__);

(statearr_67213[(1)] = (1));

return statearr_67213;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____1 = (function (state_67185){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_67185);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e67214){var ex__2744__auto__ = e67214;
var statearr_67215_67238 = state_67185;
(statearr_67215_67238[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_67185[(4)]))){
var statearr_67216_67239 = state_67185;
(statearr_67216_67239[(1)] = cljs.core.first.call(null,(state_67185[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67240 = state_67185;
state_67185 = G__67240;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__ = function(state_67185){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____1.call(this,state_67185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_67217 = f__2764__auto__.call(null);
(statearr_67217[(6)] = c__2763__auto__);

return statearr_67217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_67304){
var state_val_67305 = (state_67304[(1)]);
if((state_val_67305 === (7))){
var inst_67250 = cljs.core._EQ_.call(null,(0),auth);
var state_67304__$1 = state_67304;
if(inst_67250){
var statearr_67306_67355 = state_67304__$1;
(statearr_67306_67355[(1)] = (9));

} else {
var statearr_67307_67356 = state_67304__$1;
(statearr_67307_67356[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (20))){
var inst_67274 = (state_67304[(7)]);
var state_67304__$1 = state_67304;
if(cljs.core.truth_(inst_67274)){
var statearr_67308_67357 = state_67304__$1;
(statearr_67308_67357[(1)] = (22));

} else {
var statearr_67309_67358 = state_67304__$1;
(statearr_67309_67358[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (27))){
var state_67304__$1 = state_67304;
var statearr_67310_67359 = state_67304__$1;
(statearr_67310_67359[(2)] = null);

(statearr_67310_67359[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (1))){
var state_67304__$1 = state_67304;
var statearr_67311_67360 = state_67304__$1;
(statearr_67311_67360[(2)] = null);

(statearr_67311_67360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (24))){
var inst_67288 = (state_67304[(2)]);
var state_67304__$1 = state_67304;
var statearr_67312_67361 = state_67304__$1;
(statearr_67312_67361[(2)] = inst_67288);

(statearr_67312_67361[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (4))){
var inst_67241 = (state_67304[(2)]);
var state_67304__$1 = state_67304;
var statearr_67313_67362 = state_67304__$1;
(statearr_67313_67362[(2)] = inst_67241);

(statearr_67313_67362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (15))){
var inst_67257 = (state_67304[(8)]);
var inst_67256 = (state_67304[(2)]);
var inst_67257__$1 = fluree.db.util.async.throw_err.call(null,inst_67256);
var state_67304__$1 = (function (){var statearr_67314 = state_67304;
(statearr_67314[(8)] = inst_67257__$1);

return statearr_67314;
})();
if(cljs.core.truth_(inst_67257__$1)){
var statearr_67315_67363 = state_67304__$1;
(statearr_67315_67363[(1)] = (16));

} else {
var statearr_67316_67364 = state_67304__$1;
(statearr_67316_67364[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (21))){
var inst_67290 = (state_67304[(9)]);
var inst_67290__$1 = (state_67304[(2)]);
var state_67304__$1 = (function (){var statearr_67317 = state_67304;
(statearr_67317[(9)] = inst_67290__$1);

return statearr_67317;
})();
if(cljs.core.truth_(inst_67290__$1)){
var statearr_67318_67365 = state_67304__$1;
(statearr_67318_67365[(1)] = (29));

} else {
var statearr_67319_67366 = state_67304__$1;
(statearr_67319_67366[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (31))){
var inst_67274 = (state_67304[(7)]);
var inst_67290 = (state_67304[(9)]);
var inst_67298 = (state_67304[(2)]);
var inst_67299 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_67274,new cljs.core.Keyword(null,"roles","roles",143379530),inst_67290,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_67298);
var _ = (function (){var statearr_67320 = state_67304;
(statearr_67320[(4)] = cljs.core.rest.call(null,(state_67304[(4)])));

return statearr_67320;
})();
var state_67304__$1 = state_67304;
var statearr_67321_67367 = state_67304__$1;
(statearr_67321_67367[(2)] = inst_67299);

(statearr_67321_67367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (32))){
var inst_67294 = (state_67304[(2)]);
var inst_67295 = fluree.db.util.async.throw_err.call(null,inst_67294);
var state_67304__$1 = state_67304;
var statearr_67322_67368 = state_67304__$1;
(statearr_67322_67368[(2)] = inst_67295);

(statearr_67322_67368[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (13))){
var state_67304__$1 = state_67304;
var statearr_67323_67369 = state_67304__$1;
(statearr_67323_67369[(2)] = null);

(statearr_67323_67369[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (22))){
var inst_67274 = (state_67304[(7)]);
var inst_67278 = fluree.db.auth.roles.call(null,db,inst_67274);
var state_67304__$1 = state_67304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67304__$1,(25),inst_67278);
} else {
if((state_val_67305 === (29))){
var inst_67290 = (state_67304[(9)]);
var inst_67292 = fluree.db.permissions.permission_map.call(null,db,inst_67290,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_67304__$1 = state_67304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67304__$1,(32),inst_67292);
} else {
if((state_val_67305 === (6))){
var state_67304__$1 = state_67304;
var statearr_67324_67370 = state_67304__$1;
(statearr_67324_67370[(2)] = null);

(statearr_67324_67370[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (28))){
var inst_67286 = (state_67304[(2)]);
var state_67304__$1 = state_67304;
var statearr_67325_67371 = state_67304__$1;
(statearr_67325_67371[(2)] = inst_67286);

(statearr_67325_67371[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (25))){
var inst_67280 = (state_67304[(2)]);
var inst_67281 = fluree.db.util.async.throw_err.call(null,inst_67280);
var state_67304__$1 = state_67304;
var statearr_67326_67372 = state_67304__$1;
(statearr_67326_67372[(2)] = inst_67281);

(statearr_67326_67372[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (17))){
var inst_67260 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_67261 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67262 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_67263 = cljs.core.PersistentHashMap.fromArrays(inst_67261,inst_67262);
var inst_67264 = cljs.core.ex_info.call(null,inst_67260,inst_67263);
var inst_67265 = (function(){throw inst_67264})();
var state_67304__$1 = state_67304;
var statearr_67327_67373 = state_67304__$1;
(statearr_67327_67373[(2)] = inst_67265);

(statearr_67327_67373[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (3))){
var inst_67302 = (state_67304[(2)]);
var state_67304__$1 = state_67304;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67304__$1,inst_67302);
} else {
if((state_val_67305 === (12))){
var inst_67254 = fluree.db.dbproto._subid.call(null,db,auth);
var state_67304__$1 = state_67304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67304__$1,(15),inst_67254);
} else {
if((state_val_67305 === (2))){
var _ = (function (){var statearr_67328 = state_67304;
(statearr_67328[(4)] = cljs.core.cons.call(null,(5),(state_67304[(4)])));

return statearr_67328;
})();
var inst_67247 = (auth == null);
var state_67304__$1 = state_67304;
if(cljs.core.truth_(inst_67247)){
var statearr_67329_67374 = state_67304__$1;
(statearr_67329_67374[(1)] = (6));

} else {
var statearr_67330_67375 = state_67304__$1;
(statearr_67330_67375[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (23))){
var state_67304__$1 = state_67304;
var statearr_67331_67376 = state_67304__$1;
(statearr_67331_67376[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (19))){
var state_67304__$1 = state_67304;
var statearr_67333_67377 = state_67304__$1;
(statearr_67333_67377[(2)] = roles);

(statearr_67333_67377[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (11))){
var inst_67272 = (state_67304[(2)]);
var state_67304__$1 = state_67304;
var statearr_67335_67378 = state_67304__$1;
(statearr_67335_67378[(2)] = inst_67272);

(statearr_67335_67378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (9))){
var state_67304__$1 = state_67304;
var statearr_67336_67379 = state_67304__$1;
(statearr_67336_67379[(2)] = (0));

(statearr_67336_67379[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (5))){
var _ = (function (){var statearr_67337 = state_67304;
(statearr_67337[(4)] = cljs.core.rest.call(null,(state_67304[(4)])));

return statearr_67337;
})();
var state_67304__$1 = state_67304;
var ex67334 = (state_67304__$1[(2)]);
var statearr_67338_67380 = state_67304__$1;
(statearr_67338_67380[(5)] = ex67334);


if((ex67334 instanceof Error)){
var statearr_67339_67381 = state_67304__$1;
(statearr_67339_67381[(1)] = (4));

(statearr_67339_67381[(5)] = null);

} else {
throw ex67334;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (14))){
var inst_67270 = (state_67304[(2)]);
var state_67304__$1 = state_67304;
var statearr_67340_67382 = state_67304__$1;
(statearr_67340_67382[(2)] = inst_67270);

(statearr_67340_67382[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (26))){
var state_67304__$1 = state_67304;
var statearr_67341_67383 = state_67304__$1;
(statearr_67341_67383[(2)] = null);

(statearr_67341_67383[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (16))){
var inst_67257 = (state_67304[(8)]);
var state_67304__$1 = state_67304;
var statearr_67342_67384 = state_67304__$1;
(statearr_67342_67384[(2)] = inst_67257);

(statearr_67342_67384[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (30))){
var state_67304__$1 = state_67304;
var statearr_67343_67385 = state_67304__$1;
(statearr_67343_67385[(2)] = null);

(statearr_67343_67385[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (10))){
var state_67304__$1 = state_67304;
if(cljs.core.truth_(auth)){
var statearr_67344_67386 = state_67304__$1;
(statearr_67344_67386[(1)] = (12));

} else {
var statearr_67345_67387 = state_67304__$1;
(statearr_67345_67387[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (18))){
var inst_67267 = (state_67304[(2)]);
var state_67304__$1 = state_67304;
var statearr_67346_67388 = state_67304__$1;
(statearr_67346_67388[(2)] = inst_67267);

(statearr_67346_67388[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67305 === (8))){
var inst_67274 = (state_67304[(2)]);
var state_67304__$1 = (function (){var statearr_67347 = state_67304;
(statearr_67347[(7)] = inst_67274);

return statearr_67347;
})();
if(cljs.core.truth_(roles)){
var statearr_67348_67389 = state_67304__$1;
(statearr_67348_67389[(1)] = (19));

} else {
var statearr_67349_67390 = state_67304__$1;
(statearr_67349_67390[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____0 = (function (){
var statearr_67350 = [null,null,null,null,null,null,null,null,null,null];
(statearr_67350[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__);

(statearr_67350[(1)] = (1));

return statearr_67350;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____1 = (function (state_67304){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_67304);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e67351){var ex__2744__auto__ = e67351;
var statearr_67352_67391 = state_67304;
(statearr_67352_67391[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_67304[(4)]))){
var statearr_67353_67392 = state_67304;
(statearr_67353_67392[(1)] = cljs.core.first.call(null,(state_67304[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67393 = state_67304;
state_67304 = G__67393;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__ = function(state_67304){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____1.call(this,state_67304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_67354 = f__2764__auto__.call(null);
(statearr_67354[(6)] = c__2763__auto__);

return statearr_67354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__67394 = db;
var map__67394__$1 = cljs.core.__destructure_map.call(null,map__67394);
var conn = cljs.core.get.call(null,map__67394__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__67394__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__67394__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.call(null,"NEW EVENT:",cljs.core.pr_str.call(null,evt),cljs.core.pr_str.call(null,data));

if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);

var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_67401){
var state_val_67402 = (state_67401[(1)]);
if((state_val_67402 === (1))){
var inst_67395 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_67396 = fluree.db.session.db.call(null,conn,inst_67395,null);
var state_67401__$1 = state_67401;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67401__$1,(2),inst_67396);
} else {
if((state_val_67402 === (2))){
var inst_67398 = (state_67401[(2)]);
var inst_67399 = cljs.core.async.put_BANG_.call(null,resp_port,inst_67398);
var state_67401__$1 = state_67401;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67401__$1,inst_67399);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0 = (function (){
var statearr_67403 = [null,null,null,null,null,null,null];
(statearr_67403[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__);

(statearr_67403[(1)] = (1));

return statearr_67403;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1 = (function (state_67401){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_67401);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e67404){var ex__2744__auto__ = e67404;
var statearr_67405_67432 = state_67401;
(statearr_67405_67432[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_67401[(4)]))){
var statearr_67406_67433 = state_67401;
(statearr_67406_67433[(1)] = cljs.core.first.call(null,(state_67401[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67434 = state_67401;
state_67401 = G__67434;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__ = function(state_67401){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1.call(this,state_67401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_67407 = f__2764__auto__.call(null);
(statearr_67407[(6)] = c__2763__auto__);

return statearr_67407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,dbid,listen_id,event_fn);

var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_67420){
var state_val_67421 = (state_67420[(1)]);
if((state_val_67421 === (1))){
var inst_67408 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_67409 = fluree.db.session.db.call(null,conn,inst_67408,null);
var state_67420__$1 = state_67420;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67420__$1,(2),inst_67409);
} else {
if((state_val_67421 === (2))){
var inst_67411 = (state_67420[(7)]);
var inst_67411__$1 = (state_67420[(2)]);
var inst_67412 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_67411__$1);
var inst_67413 = newer_block_QMARK_.call(null,inst_67412);
var state_67420__$1 = (function (){var statearr_67422 = state_67420;
(statearr_67422[(7)] = inst_67411__$1);

return statearr_67422;
})();
if(inst_67413){
var statearr_67423_67435 = state_67420__$1;
(statearr_67423_67435[(1)] = (3));

} else {
var statearr_67424_67436 = state_67420__$1;
(statearr_67424_67436[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67421 === (3))){
var inst_67411 = (state_67420[(7)]);
var inst_67415 = cljs.core.async.put_BANG_.call(null,resp_port,inst_67411);
var state_67420__$1 = state_67420;
var statearr_67425_67437 = state_67420__$1;
(statearr_67425_67437[(2)] = inst_67415);

(statearr_67425_67437[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67421 === (4))){
var state_67420__$1 = state_67420;
var statearr_67426_67438 = state_67420__$1;
(statearr_67426_67438[(2)] = null);

(statearr_67426_67438[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67421 === (5))){
var inst_67418 = (state_67420[(2)]);
var state_67420__$1 = state_67420;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67420__$1,inst_67418);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0 = (function (){
var statearr_67427 = [null,null,null,null,null,null,null,null];
(statearr_67427[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__);

(statearr_67427[(1)] = (1));

return statearr_67427;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1 = (function (state_67420){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_67420);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e67428){var ex__2744__auto__ = e67428;
var statearr_67429_67439 = state_67420;
(statearr_67429_67439[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_67420[(4)]))){
var statearr_67430_67440 = state_67420;
(statearr_67430_67440[(1)] = cljs.core.first.call(null,(state_67420[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67441 = state_67420;
state_67420 = G__67441;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__ = function(state_67420){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1.call(this,state_67420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_67431 = f__2764__auto__.call(null);
(statearr_67431[(6)] = c__2763__auto__);

return statearr_67431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__67442 = db;
var map__67442__$1 = cljs.core.__destructure_map.call(null,map__67442);
var conn = cljs.core.get.call(null,map__67442__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__67442__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__67442__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2763__auto___67518 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_67492){
var state_val_67493 = (state_67492[(1)]);
if((state_val_67493 === (7))){
var inst_67458 = (state_67492[(7)]);
var inst_67469 = cljs.core._EQ_.call(null,inst_67458,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_67492__$1 = state_67492;
if(inst_67469){
var statearr_67494_67519 = state_67492__$1;
(statearr_67494_67519[(1)] = (9));

} else {
var statearr_67495_67520 = state_67492__$1;
(statearr_67495_67520[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67493 === (1))){
var inst_67443 = (state_67492[(8)]);
var inst_67451 = (state_67492[(9)]);
var inst_67443__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_67451__$1 = res_port;
var inst_67452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67453 = [inst_67443__$1,inst_67451__$1];
var inst_67454 = (new cljs.core.PersistentVector(null,2,(5),inst_67452,inst_67453,null));
var state_67492__$1 = (function (){var statearr_67496 = state_67492;
(statearr_67496[(8)] = inst_67443__$1);

(statearr_67496[(9)] = inst_67451__$1);

return statearr_67496;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_67492__$1,(2),inst_67454);
} else {
if((state_val_67493 === (4))){
var inst_67451 = (state_67492[(9)]);
var inst_67458 = (state_67492[(7)]);
var inst_67462 = cljs.core._EQ_.call(null,inst_67458,inst_67451);
var state_67492__$1 = state_67492;
if(inst_67462){
var statearr_67497_67521 = state_67492__$1;
(statearr_67497_67521[(1)] = (6));

} else {
var statearr_67498_67522 = state_67492__$1;
(statearr_67498_67522[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67493 === (13))){
var inst_67477 = (state_67492[(10)]);
var inst_67488 = cljs.core.async.put_BANG_.call(null,pc,inst_67477);
var state_67492__$1 = state_67492;
var statearr_67499_67523 = state_67492__$1;
(statearr_67499_67523[(2)] = inst_67488);

(statearr_67499_67523[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67493 === (6))){
var inst_67456 = (state_67492[(11)]);
var inst_67467 = cljs.core.nth.call(null,inst_67456,(0),null);
var state_67492__$1 = state_67492;
var statearr_67500_67524 = state_67492__$1;
(statearr_67500_67524[(2)] = inst_67467);

(statearr_67500_67524[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67493 === (3))){
var state_67492__$1 = state_67492;
var statearr_67501_67525 = state_67492__$1;
(statearr_67501_67525[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_67501_67525[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67493 === (12))){
var inst_67481 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_67482 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67483 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_67484 = cljs.core.PersistentHashMap.fromArrays(inst_67482,inst_67483);
var inst_67485 = cljs.core.ex_info.call(null,inst_67481,inst_67484);
var inst_67486 = cljs.core.async.put_BANG_.call(null,pc,inst_67485);
var state_67492__$1 = state_67492;
var statearr_67502_67526 = state_67492__$1;
(statearr_67502_67526[(2)] = inst_67486);

(statearr_67502_67526[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67493 === (2))){
var inst_67443 = (state_67492[(8)]);
var inst_67458 = (state_67492[(7)]);
var inst_67456 = (state_67492[(11)]);
var inst_67456__$1 = (state_67492[(2)]);
var inst_67457 = cljs.core.nth.call(null,inst_67456__$1,(0),null);
var inst_67458__$1 = cljs.core.nth.call(null,inst_67456__$1,(1),null);
var inst_67459 = cljs.core._EQ_.call(null,inst_67458__$1,inst_67443);
var state_67492__$1 = (function (){var statearr_67503 = state_67492;
(statearr_67503[(12)] = inst_67457);

(statearr_67503[(7)] = inst_67458__$1);

(statearr_67503[(11)] = inst_67456__$1);

return statearr_67503;
})();
if(inst_67459){
var statearr_67504_67527 = state_67492__$1;
(statearr_67504_67527[(1)] = (3));

} else {
var statearr_67505_67528 = state_67492__$1;
(statearr_67505_67528[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67493 === (11))){
var inst_67473 = (state_67492[(2)]);
var state_67492__$1 = state_67492;
var statearr_67506_67529 = state_67492__$1;
(statearr_67506_67529[(2)] = inst_67473);

(statearr_67506_67529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67493 === (9))){
var inst_67457 = (state_67492[(12)]);
var state_67492__$1 = state_67492;
var statearr_67507_67530 = state_67492__$1;
(statearr_67507_67530[(2)] = inst_67457);

(statearr_67507_67530[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67493 === (5))){
var inst_67477 = (state_67492[(10)]);
var inst_67477__$1 = (state_67492[(2)]);
var inst_67478 = fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);
var inst_67479 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_67477__$1);
var state_67492__$1 = (function (){var statearr_67508 = state_67492;
(statearr_67508[(13)] = inst_67478);

(statearr_67508[(10)] = inst_67477__$1);

return statearr_67508;
})();
if(inst_67479){
var statearr_67509_67531 = state_67492__$1;
(statearr_67509_67531[(1)] = (12));

} else {
var statearr_67510_67532 = state_67492__$1;
(statearr_67510_67532[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67493 === (14))){
var inst_67490 = (state_67492[(2)]);
var state_67492__$1 = state_67492;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67492__$1,inst_67490);
} else {
if((state_val_67493 === (10))){
var state_67492__$1 = state_67492;
var statearr_67511_67533 = state_67492__$1;
(statearr_67511_67533[(2)] = null);

(statearr_67511_67533[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67493 === (8))){
var inst_67475 = (state_67492[(2)]);
var state_67492__$1 = state_67492;
var statearr_67512_67534 = state_67492__$1;
(statearr_67512_67534[(2)] = inst_67475);

(statearr_67512_67534[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____0 = (function (){
var statearr_67513 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67513[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__);

(statearr_67513[(1)] = (1));

return statearr_67513;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____1 = (function (state_67492){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_67492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e67514){var ex__2744__auto__ = e67514;
var statearr_67515_67535 = state_67492;
(statearr_67515_67535[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_67492[(4)]))){
var statearr_67516_67536 = state_67492;
(statearr_67516_67536[(1)] = cljs.core.first.call(null,(state_67492[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67537 = state_67492;
state_67492 = G__67537;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__ = function(state_67492){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____1.call(this,state_67492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_67517 = f__2764__auto__.call(null);
(statearr_67517[(6)] = c__2763__auto___67518);

return statearr_67517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__67539 = arguments.length;
switch (G__67539) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__67540){
var map__67541 = p__67540;
var map__67541__$1 = cljs.core.__destructure_map.call(null,map__67541);
var opts = map__67541__$1;
var roles = cljs.core.get.call(null,map__67541__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__67541__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__67541__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__67541__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__67541__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2763__auto___67630 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_67592){
var state_val_67593 = (state_67592[(1)]);
if((state_val_67593 === (7))){
var inst_67554 = (state_67592[(7)]);
var inst_67556 = fluree.db.api.ledger.syncTo_db.call(null,inst_67554,syncTo,syncTimeout);
var state_67592__$1 = state_67592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67592__$1,(10),inst_67556);
} else {
if((state_val_67593 === (20))){
var inst_67578 = (state_67592[(8)]);
var state_67592__$1 = state_67592;
var statearr_67594_67631 = state_67592__$1;
(statearr_67594_67631[(2)] = inst_67578);

(statearr_67594_67631[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (1))){
var state_67592__$1 = state_67592;
var statearr_67595_67632 = state_67592__$1;
(statearr_67595_67632[(2)] = null);

(statearr_67595_67632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (4))){
var inst_67542 = (state_67592[(2)]);
var inst_67543 = cljs.core.async.put_BANG_.call(null,pc,inst_67542);
var inst_67544 = cljs.core.async.close_BANG_.call(null,pc);
var state_67592__$1 = (function (){var statearr_67596 = state_67592;
(statearr_67596[(9)] = inst_67543);

return statearr_67596;
})();
var statearr_67597_67633 = state_67592__$1;
(statearr_67597_67633[(2)] = inst_67544);

(statearr_67597_67633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (15))){
var inst_67570 = (state_67592[(10)]);
var inst_67572 = fluree.db.api.ledger.add_db_permissions.call(null,inst_67570,auth,roles);
var state_67592__$1 = state_67592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67592__$1,(18),inst_67572);
} else {
if((state_val_67593 === (21))){
var inst_67586 = (state_67592[(2)]);
var inst_67587 = cljs.core.async.put_BANG_.call(null,pc,inst_67586);
var _ = (function (){var statearr_67598 = state_67592;
(statearr_67598[(4)] = cljs.core.rest.call(null,(state_67592[(4)])));

return statearr_67598;
})();
var state_67592__$1 = state_67592;
var statearr_67599_67634 = state_67592__$1;
(statearr_67599_67634[(2)] = inst_67587);

(statearr_67599_67634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (13))){
var inst_67570 = (state_67592[(2)]);
var state_67592__$1 = (function (){var statearr_67600 = state_67592;
(statearr_67600[(10)] = inst_67570);

return statearr_67600;
})();
if(cljs.core.truth_(roles)){
var statearr_67601_67635 = state_67592__$1;
(statearr_67601_67635[(1)] = (15));

} else {
var statearr_67602_67636 = state_67592__$1;
(statearr_67602_67636[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (22))){
var inst_67582 = (state_67592[(2)]);
var inst_67583 = fluree.db.util.async.throw_err.call(null,inst_67582);
var state_67592__$1 = state_67592;
var statearr_67603_67637 = state_67592__$1;
(statearr_67603_67637[(2)] = inst_67583);

(statearr_67603_67637[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (6))){
var inst_67553 = (state_67592[(2)]);
var inst_67554 = fluree.db.util.async.throw_err.call(null,inst_67553);
var state_67592__$1 = (function (){var statearr_67604 = state_67592;
(statearr_67604[(7)] = inst_67554);

return statearr_67604;
})();
if(cljs.core.truth_(syncTo)){
var statearr_67605_67638 = state_67592__$1;
(statearr_67605_67638[(1)] = (7));

} else {
var statearr_67606_67639 = state_67592__$1;
(statearr_67606_67639[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (17))){
var inst_67578 = (state_67592[(2)]);
var state_67592__$1 = (function (){var statearr_67607 = state_67592;
(statearr_67607[(8)] = inst_67578);

return statearr_67607;
})();
if(cljs.core.truth_(auth)){
var statearr_67608_67640 = state_67592__$1;
(statearr_67608_67640[(1)] = (19));

} else {
var statearr_67609_67641 = state_67592__$1;
(statearr_67609_67641[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (3))){
var inst_67590 = (state_67592[(2)]);
var state_67592__$1 = state_67592;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67592__$1,inst_67590);
} else {
if((state_val_67593 === (12))){
var inst_67562 = (state_67592[(11)]);
var state_67592__$1 = state_67592;
var statearr_67610_67642 = state_67592__$1;
(statearr_67610_67642[(2)] = inst_67562);

(statearr_67610_67642[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (2))){
var _ = (function (){var statearr_67611 = state_67592;
(statearr_67611[(4)] = cljs.core.cons.call(null,(5),(state_67592[(4)])));

return statearr_67611;
})();
var inst_67551 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_67592__$1 = state_67592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67592__$1,(6),inst_67551);
} else {
if((state_val_67593 === (19))){
var inst_67578 = (state_67592[(8)]);
var inst_67580 = fluree.db.api.ledger.add_db_permissions.call(null,inst_67578,auth,roles);
var state_67592__$1 = state_67592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67592__$1,(22),inst_67580);
} else {
if((state_val_67593 === (11))){
var inst_67562 = (state_67592[(11)]);
var inst_67564 = fluree.db.time_travel.as_of_block.call(null,inst_67562,block);
var state_67592__$1 = state_67592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67592__$1,(14),inst_67564);
} else {
if((state_val_67593 === (9))){
var inst_67562 = (state_67592[(2)]);
var state_67592__$1 = (function (){var statearr_67613 = state_67592;
(statearr_67613[(11)] = inst_67562);

return statearr_67613;
})();
if(cljs.core.truth_(block)){
var statearr_67614_67643 = state_67592__$1;
(statearr_67614_67643[(1)] = (11));

} else {
var statearr_67615_67644 = state_67592__$1;
(statearr_67615_67644[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (5))){
var _ = (function (){var statearr_67616 = state_67592;
(statearr_67616[(4)] = cljs.core.rest.call(null,(state_67592[(4)])));

return statearr_67616;
})();
var state_67592__$1 = state_67592;
var ex67612 = (state_67592__$1[(2)]);
var statearr_67617_67645 = state_67592__$1;
(statearr_67617_67645[(5)] = ex67612);


var statearr_67618_67646 = state_67592__$1;
(statearr_67618_67646[(1)] = (4));

(statearr_67618_67646[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (14))){
var inst_67566 = (state_67592[(2)]);
var inst_67567 = fluree.db.util.async.throw_err.call(null,inst_67566);
var state_67592__$1 = state_67592;
var statearr_67619_67647 = state_67592__$1;
(statearr_67619_67647[(2)] = inst_67567);

(statearr_67619_67647[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (16))){
var inst_67570 = (state_67592[(10)]);
var state_67592__$1 = state_67592;
var statearr_67620_67648 = state_67592__$1;
(statearr_67620_67648[(2)] = inst_67570);

(statearr_67620_67648[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (10))){
var inst_67558 = (state_67592[(2)]);
var inst_67559 = fluree.db.util.async.throw_err.call(null,inst_67558);
var state_67592__$1 = state_67592;
var statearr_67621_67649 = state_67592__$1;
(statearr_67621_67649[(2)] = inst_67559);

(statearr_67621_67649[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (18))){
var inst_67574 = (state_67592[(2)]);
var inst_67575 = fluree.db.util.async.throw_err.call(null,inst_67574);
var state_67592__$1 = state_67592;
var statearr_67622_67650 = state_67592__$1;
(statearr_67622_67650[(2)] = inst_67575);

(statearr_67622_67650[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67593 === (8))){
var inst_67554 = (state_67592[(7)]);
var state_67592__$1 = state_67592;
var statearr_67623_67651 = state_67592__$1;
(statearr_67623_67651[(2)] = inst_67554);

(statearr_67623_67651[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2741__auto__ = null;
var fluree$db$api$ledger$state_machine__2741__auto____0 = (function (){
var statearr_67624 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67624[(0)] = fluree$db$api$ledger$state_machine__2741__auto__);

(statearr_67624[(1)] = (1));

return statearr_67624;
});
var fluree$db$api$ledger$state_machine__2741__auto____1 = (function (state_67592){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_67592);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e67625){var ex__2744__auto__ = e67625;
var statearr_67626_67652 = state_67592;
(statearr_67626_67652[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_67592[(4)]))){
var statearr_67627_67653 = state_67592;
(statearr_67627_67653[(1)] = cljs.core.first.call(null,(state_67592[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67654 = state_67592;
state_67592 = G__67654;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2741__auto__ = function(state_67592){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2741__auto____1.call(this,state_67592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2741__auto____0;
fluree$db$api$ledger$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2741__auto____1;
return fluree$db$api$ledger$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_67628 = f__2764__auto__.call(null);
(statearr_67628[(6)] = c__2763__auto___67630);

return statearr_67628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

