// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__59065 = arguments.length;
switch (G__59065) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2763__auto___59213 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_59152){
var state_val_59153 = (state_59152[(1)]);
if((state_val_59153 === (7))){
var inst_59083 = (state_59152[(7)]);
var inst_59086 = cljs.core.not_EQ_.call(null,(0),inst_59083);
var state_59152__$1 = state_59152;
var statearr_59154_59214 = state_59152__$1;
(statearr_59154_59214[(2)] = inst_59086);

(statearr_59154_59214[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (20))){
var inst_59107 = (state_59152[(8)]);
var inst_59078 = (state_59152[(9)]);
var inst_59111 = fluree.db.auth.roles.call(null,inst_59078,inst_59107);
var state_59152__$1 = state_59152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59152__$1,(23),inst_59111);
} else {
if((state_val_59153 === (27))){
var inst_59078 = (state_59152[(9)]);
var inst_59126 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_59127 = fluree.db.time_travel.as_of_block.call(null,inst_59078,inst_59126);
var state_59152__$1 = state_59152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59152__$1,(30),inst_59127);
} else {
if((state_val_59153 === (1))){
var state_59152__$1 = state_59152;
var statearr_59155_59215 = state_59152__$1;
(statearr_59155_59215[(2)] = null);

(statearr_59155_59215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (24))){
var inst_59119 = (state_59152[(10)]);
var inst_59078 = (state_59152[(9)]);
var inst_59121 = fluree.db.permissions.permission_map.call(null,inst_59078,inst_59119,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_59152__$1 = state_59152;
var statearr_59156_59216 = state_59152__$1;
(statearr_59156_59216[(2)] = inst_59121);

(statearr_59156_59216[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (4))){
var inst_59066 = (state_59152[(2)]);
var inst_59067 = cljs.core.async.put_BANG_.call(null,pc,inst_59066);
var inst_59068 = cljs.core.async.close_BANG_.call(null,pc);
var state_59152__$1 = (function (){var statearr_59157 = state_59152;
(statearr_59157[(11)] = inst_59067);

return statearr_59157;
})();
var statearr_59158_59217 = state_59152__$1;
(statearr_59158_59217[(2)] = inst_59068);

(statearr_59158_59217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (15))){
var inst_59083 = (state_59152[(7)]);
var inst_59097 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_59083)," unknown."].join('');
var inst_59098 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59099 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_59100 = cljs.core.PersistentHashMap.fromArrays(inst_59098,inst_59099);
var inst_59101 = cljs.core.ex_info.call(null,inst_59097,inst_59100);
var inst_59102 = (function(){throw inst_59101})();
var state_59152__$1 = state_59152;
var statearr_59159_59218 = state_59152__$1;
(statearr_59159_59218[(2)] = inst_59102);

(statearr_59159_59218[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (21))){
var state_59152__$1 = state_59152;
var statearr_59160_59219 = state_59152__$1;
(statearr_59160_59219[(2)] = null);

(statearr_59160_59219[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (31))){
var inst_59083 = (state_59152[(7)]);
var inst_59133 = (state_59152[(12)]);
var inst_59135 = cljs.core.assoc.call(null,inst_59133,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_59083);
var state_59152__$1 = state_59152;
var statearr_59161_59220 = state_59152__$1;
(statearr_59161_59220[(2)] = inst_59135);

(statearr_59161_59220[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (32))){
var inst_59133 = (state_59152[(12)]);
var state_59152__$1 = state_59152;
var statearr_59162_59221 = state_59152__$1;
(statearr_59162_59221[(2)] = inst_59133);

(statearr_59162_59221[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (33))){
var inst_59119 = (state_59152[(10)]);
var inst_59138 = (state_59152[(2)]);
var state_59152__$1 = (function (){var statearr_59163 = state_59152;
(statearr_59163[(13)] = inst_59138);

return statearr_59163;
})();
if(cljs.core.truth_(inst_59119)){
var statearr_59164_59222 = state_59152__$1;
(statearr_59164_59222[(1)] = (34));

} else {
var statearr_59165_59223 = state_59152__$1;
(statearr_59165_59223[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (13))){
var inst_59094 = (state_59152[(14)]);
var inst_59093 = (state_59152[(2)]);
var inst_59094__$1 = fluree.db.util.async.throw_err.call(null,inst_59093);
var state_59152__$1 = (function (){var statearr_59166 = state_59152;
(statearr_59166[(14)] = inst_59094__$1);

return statearr_59166;
})();
if(cljs.core.truth_(inst_59094__$1)){
var statearr_59167_59224 = state_59152__$1;
(statearr_59167_59224[(1)] = (14));

} else {
var statearr_59168_59225 = state_59152__$1;
(statearr_59168_59225[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (22))){
var inst_59117 = (state_59152[(2)]);
var state_59152__$1 = state_59152;
var statearr_59169_59226 = state_59152__$1;
(statearr_59169_59226[(2)] = inst_59117);

(statearr_59169_59226[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (36))){
var inst_59146 = (state_59152[(2)]);
var inst_59147 = cljs.core.async.put_BANG_.call(null,pc,inst_59146);
var _ = (function (){var statearr_59170 = state_59152;
(statearr_59170[(4)] = cljs.core.rest.call(null,(state_59152[(4)])));

return statearr_59170;
})();
var state_59152__$1 = state_59152;
var statearr_59171_59227 = state_59152__$1;
(statearr_59171_59227[(2)] = inst_59147);

(statearr_59171_59227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (29))){
var inst_59083 = (state_59152[(7)]);
var inst_59133 = (state_59152[(2)]);
var state_59152__$1 = (function (){var statearr_59172 = state_59152;
(statearr_59172[(12)] = inst_59133);

return statearr_59172;
})();
if(cljs.core.truth_(inst_59083)){
var statearr_59173_59228 = state_59152__$1;
(statearr_59173_59228[(1)] = (31));

} else {
var statearr_59174_59229 = state_59152__$1;
(statearr_59174_59229[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (6))){
var inst_59083 = (state_59152[(7)]);
var inst_59077 = (state_59152[(2)]);
var inst_59078 = fluree.db.util.async.throw_err.call(null,inst_59077);
var inst_59079 = opts;
var inst_59080 = cljs.core.__destructure_map.call(null,inst_59079);
var inst_59081 = cljs.core.get.call(null,inst_59080,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_59082 = cljs.core.get.call(null,inst_59080,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_59083__$1 = cljs.core.get.call(null,inst_59080,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_59084 = cljs.core.get.call(null,inst_59080,new cljs.core.Keyword(null,"block","block",664686210));
var state_59152__$1 = (function (){var statearr_59175 = state_59152;
(statearr_59175[(7)] = inst_59083__$1);

(statearr_59175[(15)] = inst_59082);

(statearr_59175[(9)] = inst_59078);

(statearr_59175[(16)] = inst_59084);

(statearr_59175[(17)] = inst_59081);

return statearr_59175;
})();
if(cljs.core.truth_(inst_59083__$1)){
var statearr_59176_59230 = state_59152__$1;
(statearr_59176_59230[(1)] = (7));

} else {
var statearr_59177_59231 = state_59152__$1;
(statearr_59177_59231[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (28))){
var inst_59078 = (state_59152[(9)]);
var state_59152__$1 = state_59152;
var statearr_59178_59232 = state_59152__$1;
(statearr_59178_59232[(2)] = inst_59078);

(statearr_59178_59232[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (25))){
var state_59152__$1 = state_59152;
var statearr_59179_59233 = state_59152__$1;
(statearr_59179_59233[(2)] = null);

(statearr_59179_59233[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (34))){
var inst_59124 = (state_59152[(18)]);
var state_59152__$1 = state_59152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59152__$1,(37),inst_59124);
} else {
if((state_val_59153 === (17))){
var inst_59081 = (state_59152[(17)]);
var state_59152__$1 = state_59152;
var statearr_59180_59234 = state_59152__$1;
(statearr_59180_59234[(2)] = inst_59081);

(statearr_59180_59234[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (3))){
var inst_59150 = (state_59152[(2)]);
var state_59152__$1 = state_59152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59152__$1,inst_59150);
} else {
if((state_val_59153 === (12))){
var inst_59081 = (state_59152[(17)]);
var inst_59107 = (state_59152[(2)]);
var state_59152__$1 = (function (){var statearr_59181 = state_59152;
(statearr_59181[(8)] = inst_59107);

return statearr_59181;
})();
if(cljs.core.truth_(inst_59081)){
var statearr_59182_59235 = state_59152__$1;
(statearr_59182_59235[(1)] = (17));

} else {
var statearr_59183_59236 = state_59152__$1;
(statearr_59183_59236[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (2))){
var _ = (function (){var statearr_59184 = state_59152;
(statearr_59184[(4)] = cljs.core.cons.call(null,(5),(state_59152[(4)])));

return statearr_59184;
})();
var inst_59075 = fluree.db.session.db.call(null,conn,ledger,null);
var state_59152__$1 = state_59152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59152__$1,(6),inst_59075);
} else {
if((state_val_59153 === (23))){
var inst_59113 = (state_59152[(2)]);
var inst_59114 = fluree.db.util.async.throw_err.call(null,inst_59113);
var state_59152__$1 = state_59152;
var statearr_59185_59237 = state_59152__$1;
(statearr_59185_59237[(2)] = inst_59114);

(statearr_59185_59237[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (35))){
var inst_59138 = (state_59152[(13)]);
var state_59152__$1 = state_59152;
var statearr_59186_59238 = state_59152__$1;
(statearr_59186_59238[(2)] = inst_59138);

(statearr_59186_59238[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (19))){
var inst_59119 = (state_59152[(10)]);
var inst_59119__$1 = (state_59152[(2)]);
var state_59152__$1 = (function (){var statearr_59187 = state_59152;
(statearr_59187[(10)] = inst_59119__$1);

return statearr_59187;
})();
if(cljs.core.truth_(inst_59119__$1)){
var statearr_59188_59239 = state_59152__$1;
(statearr_59188_59239[(1)] = (24));

} else {
var statearr_59189_59240 = state_59152__$1;
(statearr_59189_59240[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (11))){
var state_59152__$1 = state_59152;
var statearr_59191_59241 = state_59152__$1;
(statearr_59191_59241[(2)] = null);

(statearr_59191_59241[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (9))){
var inst_59089 = (state_59152[(2)]);
var state_59152__$1 = state_59152;
if(cljs.core.truth_(inst_59089)){
var statearr_59192_59242 = state_59152__$1;
(statearr_59192_59242[(1)] = (10));

} else {
var statearr_59193_59243 = state_59152__$1;
(statearr_59193_59243[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (5))){
var _ = (function (){var statearr_59194 = state_59152;
(statearr_59194[(4)] = cljs.core.rest.call(null,(state_59152[(4)])));

return statearr_59194;
})();
var state_59152__$1 = state_59152;
var ex59190 = (state_59152__$1[(2)]);
var statearr_59195_59244 = state_59152__$1;
(statearr_59195_59244[(5)] = ex59190);


var statearr_59196_59245 = state_59152__$1;
(statearr_59196_59245[(1)] = (4));

(statearr_59196_59245[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (14))){
var inst_59094 = (state_59152[(14)]);
var state_59152__$1 = state_59152;
var statearr_59197_59246 = state_59152__$1;
(statearr_59197_59246[(2)] = inst_59094);

(statearr_59197_59246[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (26))){
var inst_59084 = (state_59152[(16)]);
var inst_59124 = (state_59152[(2)]);
var state_59152__$1 = (function (){var statearr_59198 = state_59152;
(statearr_59198[(18)] = inst_59124);

return statearr_59198;
})();
if(cljs.core.truth_(inst_59084)){
var statearr_59199_59247 = state_59152__$1;
(statearr_59199_59247[(1)] = (27));

} else {
var statearr_59200_59248 = state_59152__$1;
(statearr_59200_59248[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (16))){
var inst_59104 = (state_59152[(2)]);
var state_59152__$1 = state_59152;
var statearr_59201_59249 = state_59152__$1;
(statearr_59201_59249[(2)] = inst_59104);

(statearr_59201_59249[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (30))){
var inst_59129 = (state_59152[(2)]);
var inst_59130 = fluree.db.util.async.throw_err.call(null,inst_59129);
var state_59152__$1 = state_59152;
var statearr_59202_59250 = state_59152__$1;
(statearr_59202_59250[(2)] = inst_59130);

(statearr_59202_59250[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (10))){
var inst_59083 = (state_59152[(7)]);
var inst_59078 = (state_59152[(9)]);
var inst_59091 = fluree.db.dbproto._subid.call(null,inst_59078,inst_59083);
var state_59152__$1 = state_59152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59152__$1,(13),inst_59091);
} else {
if((state_val_59153 === (18))){
var inst_59107 = (state_59152[(8)]);
var state_59152__$1 = state_59152;
if(cljs.core.truth_(inst_59107)){
var statearr_59203_59251 = state_59152__$1;
(statearr_59203_59251[(1)] = (20));

} else {
var statearr_59204_59252 = state_59152__$1;
(statearr_59204_59252[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (37))){
var inst_59138 = (state_59152[(13)]);
var inst_59141 = (state_59152[(2)]);
var inst_59142 = fluree.db.util.async.throw_err.call(null,inst_59141);
var inst_59143 = cljs.core.assoc.call(null,inst_59138,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_59142);
var state_59152__$1 = state_59152;
var statearr_59205_59253 = state_59152__$1;
(statearr_59205_59253[(2)] = inst_59143);

(statearr_59205_59253[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59153 === (8))){
var inst_59083 = (state_59152[(7)]);
var state_59152__$1 = state_59152;
var statearr_59206_59254 = state_59152__$1;
(statearr_59206_59254[(2)] = inst_59083);

(statearr_59206_59254[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2741__auto__ = null;
var fluree$db$api$query$state_machine__2741__auto____0 = (function (){
var statearr_59207 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59207[(0)] = fluree$db$api$query$state_machine__2741__auto__);

(statearr_59207[(1)] = (1));

return statearr_59207;
});
var fluree$db$api$query$state_machine__2741__auto____1 = (function (state_59152){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_59152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e59208){var ex__2744__auto__ = e59208;
var statearr_59209_59255 = state_59152;
(statearr_59209_59255[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_59152[(4)]))){
var statearr_59210_59256 = state_59152;
(statearr_59210_59256[(1)] = cljs.core.first.call(null,(state_59152[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59257 = state_59152;
state_59152 = G__59257;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2741__auto__ = function(state_59152){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2741__auto____1.call(this,state_59152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2741__auto____0;
fluree$db$api$query$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2741__auto____1;
return fluree$db$api$query$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_59211 = f__2764__auto__.call(null);
(statearr_59211[(6)] = c__2763__auto___59213);

return statearr_59211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_59398){
var state_val_59399 = (state_59398[(1)]);
if((state_val_59399 === (7))){
var inst_59278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59279 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59280 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59281 = [inst_59279,inst_59280];
var inst_59282 = (new cljs.core.PersistentVector(null,2,(5),inst_59278,inst_59281,null));
var state_59398__$1 = state_59398;
var statearr_59400_59470 = state_59398__$1;
(statearr_59400_59470[(2)] = inst_59282);

(statearr_59400_59470[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (20))){
var inst_59308 = (state_59398[(7)]);
var state_59398__$1 = state_59398;
var statearr_59401_59471 = state_59398__$1;
(statearr_59401_59471[(2)] = inst_59308);

(statearr_59401_59471[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (27))){
var state_59398__$1 = state_59398;
var statearr_59402_59472 = state_59398__$1;
(statearr_59402_59472[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (1))){
var state_59398__$1 = state_59398;
var statearr_59404_59473 = state_59398__$1;
(statearr_59404_59473[(2)] = null);

(statearr_59404_59473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (24))){
var inst_59307 = (state_59398[(8)]);
var state_59398__$1 = state_59398;
if(cljs.core.truth_(inst_59307)){
var statearr_59405_59474 = state_59398__$1;
(statearr_59405_59474[(1)] = (26));

} else {
var statearr_59406_59475 = state_59398__$1;
(statearr_59406_59475[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (39))){
var inst_59354 = (state_59398[(9)]);
var inst_59353 = (state_59398[(10)]);
var inst_59379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59380 = [inst_59353,inst_59354];
var inst_59381 = (new cljs.core.PersistentVector(null,2,(5),inst_59379,inst_59380,null));
var state_59398__$1 = state_59398;
var statearr_59407_59476 = state_59398__$1;
(statearr_59407_59476[(2)] = inst_59381);

(statearr_59407_59476[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (4))){
var inst_59258 = (state_59398[(2)]);
var state_59398__$1 = state_59398;
var statearr_59408_59477 = state_59398__$1;
(statearr_59408_59477[(2)] = inst_59258);

(statearr_59408_59477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (15))){
var inst_59292 = (state_59398[(11)]);
var inst_59287 = (state_59398[(12)]);
var inst_59301 = (state_59398[(2)]);
var inst_59302 = [inst_59292,inst_59301];
var inst_59303 = (new cljs.core.PersistentVector(null,2,(5),inst_59287,inst_59302,null));
var state_59398__$1 = state_59398;
var statearr_59409_59478 = state_59398__$1;
(statearr_59409_59478[(2)] = inst_59303);

(statearr_59409_59478[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (21))){
var inst_59307 = (state_59398[(8)]);
var state_59398__$1 = state_59398;
var statearr_59410_59479 = state_59398__$1;
(statearr_59410_59479[(2)] = inst_59307);

(statearr_59410_59479[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (31))){
var inst_59348 = (state_59398[(2)]);
var state_59398__$1 = state_59398;
var statearr_59411_59480 = state_59398__$1;
(statearr_59411_59480[(2)] = inst_59348);

(statearr_59411_59480[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (32))){
var inst_59354 = (state_59398[(9)]);
var inst_59357 = cljs.core.pos_int_QMARK_.call(null,inst_59354);
var state_59398__$1 = state_59398;
var statearr_59412_59481 = state_59398__$1;
(statearr_59412_59481[(2)] = inst_59357);

(statearr_59412_59481[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (40))){
var inst_59309 = (state_59398[(13)]);
var inst_59385 = (state_59398[(14)]);
var inst_59383 = (state_59398[(2)]);
var inst_59384 = cljs.core.nth.call(null,inst_59383,(0),null);
var inst_59385__$1 = cljs.core.nth.call(null,inst_59383,(1),null);
var inst_59386 = (inst_59385__$1 > inst_59309);
var state_59398__$1 = (function (){var statearr_59413 = state_59398;
(statearr_59413[(15)] = inst_59384);

(statearr_59413[(14)] = inst_59385__$1);

return statearr_59413;
})();
if(cljs.core.truth_(inst_59386)){
var statearr_59414_59482 = state_59398__$1;
(statearr_59414_59482[(1)] = (41));

} else {
var statearr_59415_59483 = state_59398__$1;
(statearr_59415_59483[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (33))){
var inst_59355 = (state_59398[(16)]);
var state_59398__$1 = state_59398;
var statearr_59416_59484 = state_59398__$1;
(statearr_59416_59484[(2)] = inst_59355);

(statearr_59416_59484[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (13))){
var inst_59293 = (state_59398[(17)]);
var inst_59295 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_59293);
var state_59398__$1 = state_59398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59398__$1,(16),inst_59295);
} else {
if((state_val_59399 === (22))){
var inst_59326 = (state_59398[(2)]);
var state_59398__$1 = state_59398;
if(cljs.core.truth_(inst_59326)){
var statearr_59417_59485 = state_59398__$1;
(statearr_59417_59485[(1)] = (23));

} else {
var statearr_59418_59486 = state_59398__$1;
(statearr_59418_59486[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (36))){
var state_59398__$1 = state_59398;
var statearr_59419_59487 = state_59398__$1;
(statearr_59419_59487[(2)] = null);

(statearr_59419_59487[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (41))){
var inst_59309 = (state_59398[(13)]);
var state_59398__$1 = state_59398;
var statearr_59420_59488 = state_59398__$1;
(statearr_59420_59488[(2)] = inst_59309);

(statearr_59420_59488[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (43))){
var inst_59384 = (state_59398[(15)]);
var inst_59390 = (state_59398[(2)]);
var inst_59391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59392 = [inst_59384,inst_59390];
var inst_59393 = (new cljs.core.PersistentVector(null,2,(5),inst_59391,inst_59392,null));
var _ = (function (){var statearr_59421 = state_59398;
(statearr_59421[(4)] = cljs.core.rest.call(null,(state_59398[(4)])));

return statearr_59421;
})();
var state_59398__$1 = state_59398;
var statearr_59422_59489 = state_59398__$1;
(statearr_59422_59489[(2)] = inst_59393);

(statearr_59422_59489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (29))){
var inst_59284 = (state_59398[(18)]);
var inst_59339 = cljs.core.pr_str.call(null,inst_59284);
var inst_59340 = ["Invalid block range provided: ",inst_59339].join('');
var inst_59341 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59342 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59343 = cljs.core.PersistentHashMap.fromArrays(inst_59341,inst_59342);
var inst_59344 = cljs.core.ex_info.call(null,inst_59340,inst_59343);
var inst_59345 = (function(){throw inst_59344})();
var state_59398__$1 = state_59398;
var statearr_59423_59490 = state_59398__$1;
(statearr_59423_59490[(2)] = inst_59345);

(statearr_59423_59490[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (6))){
var inst_59276 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_59398__$1 = state_59398;
var statearr_59424_59491 = state_59398__$1;
(statearr_59424_59491[(2)] = inst_59276);

(statearr_59424_59491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (28))){
var inst_59350 = (state_59398[(2)]);
var state_59398__$1 = state_59398;
var statearr_59425_59492 = state_59398__$1;
(statearr_59425_59492[(2)] = inst_59350);

(statearr_59425_59492[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (25))){
var inst_59355 = (state_59398[(16)]);
var inst_59353 = (state_59398[(10)]);
var inst_59352 = (state_59398[(2)]);
var inst_59353__$1 = cljs.core.nth.call(null,inst_59352,(0),null);
var inst_59354 = cljs.core.nth.call(null,inst_59352,(1),null);
var inst_59355__$1 = cljs.core.pos_int_QMARK_.call(null,inst_59353__$1);
var state_59398__$1 = (function (){var statearr_59426 = state_59398;
(statearr_59426[(16)] = inst_59355__$1);

(statearr_59426[(9)] = inst_59354);

(statearr_59426[(10)] = inst_59353__$1);

return statearr_59426;
})();
if(inst_59355__$1){
var statearr_59427_59493 = state_59398__$1;
(statearr_59427_59493[(1)] = (32));

} else {
var statearr_59428_59494 = state_59398__$1;
(statearr_59428_59494[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (34))){
var inst_59360 = (state_59398[(2)]);
var inst_59361 = cljs.core.not.call(null,inst_59360);
var state_59398__$1 = state_59398;
if(inst_59361){
var statearr_59429_59495 = state_59398__$1;
(statearr_59429_59495[(1)] = (35));

} else {
var statearr_59430_59496 = state_59398__$1;
(statearr_59430_59496[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (17))){
var inst_59309 = (state_59398[(13)]);
var inst_59307 = (state_59398[(8)]);
var inst_59312 = cljs.core.pr_str.call(null,inst_59307);
var inst_59313 = cljs.core.pr_str.call(null,inst_59309);
var inst_59314 = ["Start block is out of range for this ledger. Start block provided: ",inst_59312,". Database block: ",inst_59313].join('');
var inst_59315 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59316 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59317 = cljs.core.PersistentHashMap.fromArrays(inst_59315,inst_59316);
var inst_59318 = cljs.core.ex_info.call(null,inst_59314,inst_59317);
var inst_59319 = (function(){throw inst_59318})();
var state_59398__$1 = state_59398;
var statearr_59431_59497 = state_59398__$1;
(statearr_59431_59497[(2)] = inst_59319);

(statearr_59431_59497[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (3))){
var inst_59396 = (state_59398[(2)]);
var state_59398__$1 = state_59398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59398__$1,inst_59396);
} else {
if((state_val_59399 === (12))){
var inst_59293 = (state_59398[(17)]);
var inst_59284 = (state_59398[(18)]);
var inst_59291 = (state_59398[(2)]);
var inst_59292 = fluree.db.util.async.throw_err.call(null,inst_59291);
var inst_59293__$1 = cljs.core.second.call(null,inst_59284);
var state_59398__$1 = (function (){var statearr_59432 = state_59398;
(statearr_59432[(11)] = inst_59292);

(statearr_59432[(17)] = inst_59293__$1);

return statearr_59432;
})();
if(cljs.core.truth_(inst_59293__$1)){
var statearr_59433_59498 = state_59398__$1;
(statearr_59433_59498[(1)] = (13));

} else {
var statearr_59434_59499 = state_59398__$1;
(statearr_59434_59499[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (2))){
var _ = (function (){var statearr_59435 = state_59398;
(statearr_59435[(4)] = cljs.core.cons.call(null,(5),(state_59398[(4)])));

return statearr_59435;
})();
var inst_59273 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59274 = cljs.core.sequential_QMARK_.call(null,inst_59273);
var state_59398__$1 = state_59398;
if(inst_59274){
var statearr_59436_59500 = state_59398__$1;
(statearr_59436_59500[(1)] = (6));

} else {
var statearr_59437_59501 = state_59398__$1;
(statearr_59437_59501[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (23))){
var inst_59308 = (state_59398[(7)]);
var inst_59307 = (state_59398[(8)]);
var inst_59328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59329 = [inst_59307,inst_59308];
var inst_59330 = (new cljs.core.PersistentVector(null,2,(5),inst_59328,inst_59329,null));
var state_59398__$1 = state_59398;
var statearr_59438_59502 = state_59398__$1;
(statearr_59438_59502[(2)] = inst_59330);

(statearr_59438_59502[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (35))){
var inst_59284 = (state_59398[(18)]);
var inst_59363 = cljs.core.pr_str.call(null,inst_59284);
var inst_59364 = ["Invalid block range provided: ",inst_59363].join('');
var inst_59365 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59366 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59367 = cljs.core.PersistentHashMap.fromArrays(inst_59365,inst_59366);
var inst_59368 = cljs.core.ex_info.call(null,inst_59364,inst_59367);
var inst_59369 = (function(){throw inst_59368})();
var state_59398__$1 = state_59398;
var statearr_59439_59503 = state_59398__$1;
(statearr_59439_59503[(2)] = inst_59369);

(statearr_59439_59503[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (19))){
var inst_59307 = (state_59398[(8)]);
var inst_59322 = (state_59398[(2)]);
var state_59398__$1 = (function (){var statearr_59440 = state_59398;
(statearr_59440[(19)] = inst_59322);

return statearr_59440;
})();
if(cljs.core.truth_(inst_59307)){
var statearr_59441_59504 = state_59398__$1;
(statearr_59441_59504[(1)] = (20));

} else {
var statearr_59442_59505 = state_59398__$1;
(statearr_59442_59505[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (11))){
var inst_59309 = (state_59398[(13)]);
var inst_59307 = (state_59398[(8)]);
var inst_59306 = (state_59398[(2)]);
var inst_59307__$1 = cljs.core.nth.call(null,inst_59306,(0),null);
var inst_59308 = cljs.core.nth.call(null,inst_59306,(1),null);
var inst_59309__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59310 = (inst_59307__$1 > inst_59309__$1);
var state_59398__$1 = (function (){var statearr_59444 = state_59398;
(statearr_59444[(7)] = inst_59308);

(statearr_59444[(13)] = inst_59309__$1);

(statearr_59444[(8)] = inst_59307__$1);

return statearr_59444;
})();
if(cljs.core.truth_(inst_59310)){
var statearr_59445_59506 = state_59398__$1;
(statearr_59445_59506[(1)] = (17));

} else {
var statearr_59446_59507 = state_59398__$1;
(statearr_59446_59507[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (9))){
var inst_59284 = (state_59398[(18)]);
var inst_59287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59288 = cljs.core.first.call(null,inst_59284);
var inst_59289 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_59288);
var state_59398__$1 = (function (){var statearr_59447 = state_59398;
(statearr_59447[(12)] = inst_59287);

return statearr_59447;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59398__$1,(12),inst_59289);
} else {
if((state_val_59399 === (5))){
var _ = (function (){var statearr_59448 = state_59398;
(statearr_59448[(4)] = cljs.core.rest.call(null,(state_59398[(4)])));

return statearr_59448;
})();
var state_59398__$1 = state_59398;
var ex59443 = (state_59398__$1[(2)]);
var statearr_59449_59508 = state_59398__$1;
(statearr_59449_59508[(5)] = ex59443);


if((ex59443 instanceof Error)){
var statearr_59450_59509 = state_59398__$1;
(statearr_59450_59509[(1)] = (4));

(statearr_59450_59509[(5)] = null);

} else {
throw ex59443;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (14))){
var state_59398__$1 = state_59398;
var statearr_59451_59510 = state_59398__$1;
(statearr_59451_59510[(2)] = null);

(statearr_59451_59510[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (26))){
var inst_59307 = (state_59398[(8)]);
var inst_59333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59334 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59335 = [inst_59307,inst_59334];
var inst_59336 = (new cljs.core.PersistentVector(null,2,(5),inst_59333,inst_59335,null));
var state_59398__$1 = state_59398;
var statearr_59452_59511 = state_59398__$1;
(statearr_59452_59511[(2)] = inst_59336);

(statearr_59452_59511[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (16))){
var inst_59297 = (state_59398[(2)]);
var inst_59298 = fluree.db.util.async.throw_err.call(null,inst_59297);
var state_59398__$1 = state_59398;
var statearr_59453_59512 = state_59398__$1;
(statearr_59453_59512[(2)] = inst_59298);

(statearr_59453_59512[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (38))){
var inst_59354 = (state_59398[(9)]);
var inst_59353 = (state_59398[(10)]);
var inst_59375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59376 = [inst_59354,inst_59353];
var inst_59377 = (new cljs.core.PersistentVector(null,2,(5),inst_59375,inst_59376,null));
var state_59398__$1 = state_59398;
var statearr_59454_59513 = state_59398__$1;
(statearr_59454_59513[(2)] = inst_59377);

(statearr_59454_59513[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (30))){
var state_59398__$1 = state_59398;
var statearr_59455_59514 = state_59398__$1;
(statearr_59455_59514[(2)] = null);

(statearr_59455_59514[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (10))){
var inst_59284 = (state_59398[(18)]);
var state_59398__$1 = state_59398;
var statearr_59456_59515 = state_59398__$1;
(statearr_59456_59515[(2)] = inst_59284);

(statearr_59456_59515[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (18))){
var state_59398__$1 = state_59398;
var statearr_59457_59516 = state_59398__$1;
(statearr_59457_59516[(2)] = null);

(statearr_59457_59516[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (42))){
var inst_59385 = (state_59398[(14)]);
var state_59398__$1 = state_59398;
var statearr_59458_59517 = state_59398__$1;
(statearr_59458_59517[(2)] = inst_59385);

(statearr_59458_59517[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (37))){
var inst_59354 = (state_59398[(9)]);
var inst_59353 = (state_59398[(10)]);
var inst_59372 = (state_59398[(2)]);
var inst_59373 = (inst_59354 < inst_59353);
var state_59398__$1 = (function (){var statearr_59459 = state_59398;
(statearr_59459[(20)] = inst_59372);

return statearr_59459;
})();
if(cljs.core.truth_(inst_59373)){
var statearr_59460_59518 = state_59398__$1;
(statearr_59460_59518[(1)] = (38));

} else {
var statearr_59461_59519 = state_59398__$1;
(statearr_59461_59519[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59399 === (8))){
var inst_59284 = (state_59398[(18)]);
var inst_59284__$1 = (state_59398[(2)]);
var inst_59285 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_59284__$1);
var state_59398__$1 = (function (){var statearr_59462 = state_59398;
(statearr_59462[(18)] = inst_59284__$1);

return statearr_59462;
})();
if(cljs.core.truth_(inst_59285)){
var statearr_59463_59520 = state_59398__$1;
(statearr_59463_59520[(1)] = (9));

} else {
var statearr_59464_59521 = state_59398__$1;
(statearr_59464_59521[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto____0 = (function (){
var statearr_59465 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59465[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto__);

(statearr_59465[(1)] = (1));

return statearr_59465;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto____1 = (function (state_59398){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_59398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e59466){var ex__2744__auto__ = e59466;
var statearr_59467_59522 = state_59398;
(statearr_59467_59522[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_59398[(4)]))){
var statearr_59468_59523 = state_59398;
(statearr_59468_59523[(1)] = cljs.core.first.call(null,(state_59398[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59524 = state_59398;
state_59398 = G__59524;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto__ = function(state_59398){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto____1.call(this,state_59398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_59469 = f__2764__auto__.call(null);
(statearr_59469[(6)] = c__2763__auto__);

return statearr_59469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_59674){
var state_val_59675 = (state_59674[(1)]);
if((state_val_59675 === (7))){
var inst_59586 = (state_59674[(2)]);
var inst_59587 = cljs.core.nth.call(null,inst_59586,(0),null);
var inst_59588 = cljs.core.nth.call(null,inst_59586,(1),null);
var inst_59596 = cljs.core.vals.call(null,inst_59588);
var inst_59597 = cljs.core.seq.call(null,inst_59596);
var inst_59598 = cljs.core.first.call(null,inst_59597);
var inst_59599 = cljs.core.next.call(null,inst_59597);
var inst_59600 = cljs.core.PersistentVector.EMPTY;
var inst_59601 = inst_59596;
var inst_59602 = inst_59600;
var state_59674__$1 = (function (){var statearr_59676 = state_59674;
(statearr_59676[(7)] = inst_59601);

(statearr_59676[(8)] = inst_59598);

(statearr_59676[(9)] = inst_59602);

(statearr_59676[(10)] = inst_59599);

(statearr_59676[(11)] = inst_59587);

return statearr_59676;
})();
var statearr_59677_59730 = state_59674__$1;
(statearr_59677_59730[(2)] = null);

(statearr_59677_59730[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (20))){
var inst_59608 = (state_59674[(12)]);
var inst_59613 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59614 = cljs.core.PersistentHashMap.EMPTY;
var inst_59615 = [true,inst_59614];
var inst_59616 = cljs.core.PersistentHashMap.fromArrays(inst_59613,inst_59615);
var inst_59617 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_59616,inst_59608);
var state_59674__$1 = state_59674;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59674__$1,(22),inst_59617);
} else {
if((state_val_59675 === (27))){
var inst_59662 = (state_59674[(2)]);
var state_59674__$1 = state_59674;
var statearr_59678_59731 = state_59674__$1;
(statearr_59678_59731[(2)] = inst_59662);

(statearr_59678_59731[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (1))){
var state_59674__$1 = state_59674;
var statearr_59679_59732 = state_59674__$1;
(statearr_59679_59732[(2)] = null);

(statearr_59679_59732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (24))){
var inst_59626 = (state_59674[(13)]);
var inst_59664 = (state_59674[(2)]);
var inst_59665 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_59666 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59667 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59668 = [inst_59666,inst_59667,inst_59626,inst_59664];
var inst_59669 = cljs.core.PersistentHashMap.fromArrays(inst_59665,inst_59668);
var _ = (function (){var statearr_59681 = state_59674;
(statearr_59681[(4)] = cljs.core.rest.call(null,(state_59674[(4)])));

return statearr_59681;
})();
var state_59674__$1 = state_59674;
var statearr_59682_59733 = state_59674__$1;
(statearr_59682_59733[(2)] = inst_59669);

(statearr_59682_59733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (4))){
var inst_59527 = (state_59674[(2)]);
var state_59674__$1 = state_59674;
var statearr_59683_59734 = state_59674__$1;
(statearr_59683_59734[(2)] = inst_59527);

(statearr_59683_59734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (15))){
var inst_59567 = (state_59674[(14)]);
var inst_59565 = (state_59674[(15)]);
var inst_59545 = (state_59674[(16)]);
var inst_59546 = (state_59674[(17)]);
var inst_59557 = (state_59674[(18)]);
var inst_59572 = (state_59674[(19)]);
var inst_59543 = (state_59674[(20)]);
var inst_59551 = (state_59674[(21)]);
var inst_59550 = (state_59674[(22)]);
var inst_59549 = (state_59674[(23)]);
var inst_59558 = (state_59674[(24)]);
var inst_59578 = (function (){var subject = inst_59565;
var flake = inst_59557;
var seq__59541 = inst_59546;
var seq__59554 = inst_59558;
var r = inst_59558;
var asserted_subjects = inst_59550;
var flake_SINGLEQUOTE_ = inst_59572;
var retracted_subjects = inst_59551;
var vec__59553 = inst_59549;
var vec__59540 = inst_59543;
var first__59555 = inst_59557;
var G__59539 = inst_59549;
var asserted_QMARK_ = inst_59567;
var first__59542 = inst_59545;
return (function (p1__59526_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__59526_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59579 = cljs.core.update.call(null,inst_59551,inst_59565,inst_59578);
var tmp59680 = inst_59550;
var inst_59549__$1 = inst_59558;
var inst_59550__$1 = tmp59680;
var inst_59551__$1 = inst_59579;
var state_59674__$1 = (function (){var statearr_59684 = state_59674;
(statearr_59684[(21)] = inst_59551__$1);

(statearr_59684[(22)] = inst_59550__$1);

(statearr_59684[(23)] = inst_59549__$1);

return statearr_59684;
})();
var statearr_59685_59735 = state_59674__$1;
(statearr_59685_59735[(2)] = null);

(statearr_59685_59735[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (21))){
var inst_59624 = (state_59674[(2)]);
var state_59674__$1 = state_59674;
var statearr_59686_59736 = state_59674__$1;
(statearr_59686_59736[(2)] = inst_59624);

(statearr_59686_59736[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (13))){
var inst_59567 = (state_59674[(14)]);
var inst_59572 = (state_59674[(2)]);
var state_59674__$1 = (function (){var statearr_59687 = state_59674;
(statearr_59687[(19)] = inst_59572);

return statearr_59687;
})();
if(cljs.core.truth_(inst_59567)){
var statearr_59688_59737 = state_59674__$1;
(statearr_59688_59737[(1)] = (14));

} else {
var statearr_59689_59738 = state_59674__$1;
(statearr_59689_59738[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (22))){
var inst_59602 = (state_59674[(9)]);
var inst_59609 = (state_59674[(25)]);
var inst_59619 = (state_59674[(2)]);
var inst_59620 = fluree.db.util.async.throw_err.call(null,inst_59619);
var inst_59621 = cljs.core.conj.call(null,inst_59602,inst_59620);
var inst_59601 = inst_59609;
var inst_59602__$1 = inst_59621;
var state_59674__$1 = (function (){var statearr_59690 = state_59674;
(statearr_59690[(7)] = inst_59601);

(statearr_59690[(9)] = inst_59602__$1);

return statearr_59690;
})();
var statearr_59691_59739 = state_59674__$1;
(statearr_59691_59739[(2)] = null);

(statearr_59691_59739[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (6))){
var inst_59557 = (state_59674[(18)]);
var inst_59549 = (state_59674[(23)]);
var inst_59556 = cljs.core.seq.call(null,inst_59549);
var inst_59557__$1 = cljs.core.first.call(null,inst_59556);
var inst_59558 = cljs.core.next.call(null,inst_59556);
var inst_59559 = cljs.core.not.call(null,inst_59557__$1);
var state_59674__$1 = (function (){var statearr_59692 = state_59674;
(statearr_59692[(18)] = inst_59557__$1);

(statearr_59692[(24)] = inst_59558);

return statearr_59692;
})();
if(inst_59559){
var statearr_59693_59740 = state_59674__$1;
(statearr_59693_59740[(1)] = (8));

} else {
var statearr_59694_59741 = state_59674__$1;
(statearr_59694_59741[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (28))){
var inst_59640 = (state_59674[(26)]);
var inst_59647 = (state_59674[(27)]);
var inst_59657 = (state_59674[(2)]);
var inst_59658 = fluree.db.util.async.throw_err.call(null,inst_59657);
var inst_59659 = cljs.core.conj.call(null,inst_59640,inst_59658);
var inst_59639 = inst_59647;
var inst_59640__$1 = inst_59659;
var state_59674__$1 = (function (){var statearr_59695 = state_59674;
(statearr_59695[(28)] = inst_59639);

(statearr_59695[(26)] = inst_59640__$1);

return statearr_59695;
})();
var statearr_59696_59742 = state_59674__$1;
(statearr_59696_59742[(2)] = null);

(statearr_59696_59742[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (25))){
var inst_59640 = (state_59674[(26)]);
var state_59674__$1 = state_59674;
var statearr_59697_59743 = state_59674__$1;
(statearr_59697_59743[(2)] = inst_59640);

(statearr_59697_59743[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (17))){
var inst_59601 = (state_59674[(7)]);
var inst_59608 = (state_59674[(12)]);
var inst_59607 = cljs.core.seq.call(null,inst_59601);
var inst_59608__$1 = cljs.core.first.call(null,inst_59607);
var inst_59609 = cljs.core.next.call(null,inst_59607);
var inst_59610 = cljs.core.not.call(null,inst_59608__$1);
var state_59674__$1 = (function (){var statearr_59698 = state_59674;
(statearr_59698[(25)] = inst_59609);

(statearr_59698[(12)] = inst_59608__$1);

return statearr_59698;
})();
if(inst_59610){
var statearr_59699_59744 = state_59674__$1;
(statearr_59699_59744[(1)] = (19));

} else {
var statearr_59700_59745 = state_59674__$1;
(statearr_59700_59745[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (3))){
var inst_59672 = (state_59674[(2)]);
var state_59674__$1 = state_59674;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59674__$1,inst_59672);
} else {
if((state_val_59675 === (12))){
var inst_59557 = (state_59674[(18)]);
var inst_59570 = fluree.db.flake.flip_flake.call(null,inst_59557);
var state_59674__$1 = state_59674;
var statearr_59701_59746 = state_59674__$1;
(statearr_59701_59746[(2)] = inst_59570);

(statearr_59701_59746[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (2))){
var inst_59543 = (state_59674[(20)]);
var _ = (function (){var statearr_59702 = state_59674;
(statearr_59702[(4)] = cljs.core.cons.call(null,(5),(state_59674[(4)])));

return statearr_59702;
})();
var inst_59543__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59544 = cljs.core.seq.call(null,inst_59543__$1);
var inst_59545 = cljs.core.first.call(null,inst_59544);
var inst_59546 = cljs.core.next.call(null,inst_59544);
var inst_59547 = cljs.core.PersistentHashMap.EMPTY;
var inst_59548 = cljs.core.PersistentHashMap.EMPTY;
var inst_59549 = inst_59543__$1;
var inst_59550 = inst_59547;
var inst_59551 = inst_59548;
var state_59674__$1 = (function (){var statearr_59703 = state_59674;
(statearr_59703[(16)] = inst_59545);

(statearr_59703[(17)] = inst_59546);

(statearr_59703[(20)] = inst_59543__$1);

(statearr_59703[(21)] = inst_59551);

(statearr_59703[(22)] = inst_59550);

(statearr_59703[(23)] = inst_59549);

return statearr_59703;
})();
var statearr_59704_59747 = state_59674__$1;
(statearr_59704_59747[(2)] = null);

(statearr_59704_59747[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (23))){
var inst_59639 = (state_59674[(28)]);
var inst_59646 = (state_59674[(29)]);
var inst_59645 = cljs.core.seq.call(null,inst_59639);
var inst_59646__$1 = cljs.core.first.call(null,inst_59645);
var inst_59647 = cljs.core.next.call(null,inst_59645);
var inst_59648 = cljs.core.not.call(null,inst_59646__$1);
var state_59674__$1 = (function (){var statearr_59705 = state_59674;
(statearr_59705[(27)] = inst_59647);

(statearr_59705[(29)] = inst_59646__$1);

return statearr_59705;
})();
if(inst_59648){
var statearr_59706_59748 = state_59674__$1;
(statearr_59706_59748[(1)] = (25));

} else {
var statearr_59707_59749 = state_59674__$1;
(statearr_59707_59749[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (19))){
var inst_59602 = (state_59674[(9)]);
var state_59674__$1 = state_59674;
var statearr_59708_59750 = state_59674__$1;
(statearr_59708_59750[(2)] = inst_59602);

(statearr_59708_59750[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (11))){
var inst_59557 = (state_59674[(18)]);
var state_59674__$1 = state_59674;
var statearr_59710_59751 = state_59674__$1;
(statearr_59710_59751[(2)] = inst_59557);

(statearr_59710_59751[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (9))){
var inst_59567 = (state_59674[(14)]);
var inst_59557 = (state_59674[(18)]);
var inst_59565 = inst_59557.s;
var inst_59566 = inst_59557.op;
var inst_59567__$1 = inst_59566 === true;
var state_59674__$1 = (function (){var statearr_59712 = state_59674;
(statearr_59712[(14)] = inst_59567__$1);

(statearr_59712[(15)] = inst_59565);

return statearr_59712;
})();
if(cljs.core.truth_(inst_59567__$1)){
var statearr_59713_59752 = state_59674__$1;
(statearr_59713_59752[(1)] = (11));

} else {
var statearr_59714_59753 = state_59674__$1;
(statearr_59714_59753[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (5))){
var _ = (function (){var statearr_59715 = state_59674;
(statearr_59715[(4)] = cljs.core.rest.call(null,(state_59674[(4)])));

return statearr_59715;
})();
var state_59674__$1 = state_59674;
var ex59709 = (state_59674__$1[(2)]);
var statearr_59716_59754 = state_59674__$1;
(statearr_59716_59754[(5)] = ex59709);


if((ex59709 instanceof Error)){
var statearr_59717_59755 = state_59674__$1;
(statearr_59717_59755[(1)] = (4));

(statearr_59717_59755[(5)] = null);

} else {
throw ex59709;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (14))){
var inst_59567 = (state_59674[(14)]);
var inst_59565 = (state_59674[(15)]);
var inst_59545 = (state_59674[(16)]);
var inst_59546 = (state_59674[(17)]);
var inst_59557 = (state_59674[(18)]);
var inst_59572 = (state_59674[(19)]);
var inst_59543 = (state_59674[(20)]);
var inst_59551 = (state_59674[(21)]);
var inst_59550 = (state_59674[(22)]);
var inst_59549 = (state_59674[(23)]);
var inst_59558 = (state_59674[(24)]);
var inst_59574 = (function (){var subject = inst_59565;
var flake = inst_59557;
var seq__59541 = inst_59546;
var seq__59554 = inst_59558;
var r = inst_59558;
var asserted_subjects = inst_59550;
var flake_SINGLEQUOTE_ = inst_59572;
var retracted_subjects = inst_59551;
var vec__59553 = inst_59549;
var vec__59540 = inst_59543;
var first__59555 = inst_59557;
var G__59539 = inst_59549;
var asserted_QMARK_ = inst_59567;
var first__59542 = inst_59545;
return (function (p1__59525_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__59525_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59575 = cljs.core.update.call(null,inst_59550,inst_59565,inst_59574);
var tmp59711 = inst_59551;
var inst_59549__$1 = inst_59558;
var inst_59550__$1 = inst_59575;
var inst_59551__$1 = tmp59711;
var state_59674__$1 = (function (){var statearr_59718 = state_59674;
(statearr_59718[(21)] = inst_59551__$1);

(statearr_59718[(22)] = inst_59550__$1);

(statearr_59718[(23)] = inst_59549__$1);

return statearr_59718;
})();
var statearr_59719_59756 = state_59674__$1;
(statearr_59719_59756[(2)] = null);

(statearr_59719_59756[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (26))){
var inst_59646 = (state_59674[(29)]);
var inst_59651 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59652 = cljs.core.PersistentHashMap.EMPTY;
var inst_59653 = [true,inst_59652];
var inst_59654 = cljs.core.PersistentHashMap.fromArrays(inst_59651,inst_59653);
var inst_59655 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_59654,inst_59646);
var state_59674__$1 = state_59674;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59674__$1,(28),inst_59655);
} else {
if((state_val_59675 === (16))){
var inst_59582 = (state_59674[(2)]);
var state_59674__$1 = state_59674;
var statearr_59720_59757 = state_59674__$1;
(statearr_59720_59757[(2)] = inst_59582);

(statearr_59720_59757[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (10))){
var inst_59584 = (state_59674[(2)]);
var state_59674__$1 = state_59674;
var statearr_59721_59758 = state_59674__$1;
(statearr_59721_59758[(2)] = inst_59584);

(statearr_59721_59758[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (18))){
var inst_59587 = (state_59674[(11)]);
var inst_59626 = (state_59674[(2)]);
var inst_59634 = cljs.core.vals.call(null,inst_59587);
var inst_59635 = cljs.core.seq.call(null,inst_59634);
var inst_59636 = cljs.core.first.call(null,inst_59635);
var inst_59637 = cljs.core.next.call(null,inst_59635);
var inst_59638 = cljs.core.PersistentVector.EMPTY;
var inst_59639 = inst_59634;
var inst_59640 = inst_59638;
var state_59674__$1 = (function (){var statearr_59722 = state_59674;
(statearr_59722[(28)] = inst_59639);

(statearr_59722[(30)] = inst_59637);

(statearr_59722[(31)] = inst_59636);

(statearr_59722[(26)] = inst_59640);

(statearr_59722[(13)] = inst_59626);

return statearr_59722;
})();
var statearr_59723_59759 = state_59674__$1;
(statearr_59723_59759[(2)] = null);

(statearr_59723_59759[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59675 === (8))){
var inst_59551 = (state_59674[(21)]);
var inst_59550 = (state_59674[(22)]);
var inst_59561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59562 = [inst_59550,inst_59551];
var inst_59563 = (new cljs.core.PersistentVector(null,2,(5),inst_59561,inst_59562,null));
var state_59674__$1 = state_59674;
var statearr_59724_59760 = state_59674__$1;
(statearr_59724_59760[(2)] = inst_59563);

(statearr_59724_59760[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto____0 = (function (){
var statearr_59725 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59725[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto__);

(statearr_59725[(1)] = (1));

return statearr_59725;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto____1 = (function (state_59674){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_59674);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e59726){var ex__2744__auto__ = e59726;
var statearr_59727_59761 = state_59674;
(statearr_59727_59761[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_59674[(4)]))){
var statearr_59728_59762 = state_59674;
(statearr_59728_59762[(1)] = cljs.core.first.call(null,(state_59674[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59763 = state_59674;
state_59674 = G__59763;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto__ = function(state_59674){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto____1.call(this,state_59674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_59729 = f__2764__auto__.call(null);
(statearr_59729[(6)] = c__2763__auto__);

return statearr_59729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_59795){
var state_val_59796 = (state_59795[(1)]);
if((state_val_59796 === (1))){
var inst_59764 = cljs.core.volatile_BANG_.call(null,(0));
var inst_59765 = cljs.core.PersistentHashMap.EMPTY;
var inst_59766 = cljs.core.volatile_BANG_.call(null,inst_59765);
var inst_59767 = cljs.core.first.call(null,resp);
var inst_59768 = cljs.core.rest.call(null,resp);
var inst_59769 = cljs.core.PersistentVector.EMPTY;
var inst_59770 = inst_59764;
var inst_59771 = inst_59766;
var inst_59772 = inst_59767;
var inst_59773 = inst_59768;
var inst_59774 = inst_59769;
var state_59795__$1 = (function (){var statearr_59797 = state_59795;
(statearr_59797[(7)] = inst_59772);

(statearr_59797[(8)] = inst_59774);

(statearr_59797[(9)] = inst_59771);

(statearr_59797[(10)] = inst_59773);

(statearr_59797[(11)] = inst_59770);

return statearr_59797;
})();
var statearr_59798_59813 = state_59795__$1;
(statearr_59798_59813[(2)] = null);

(statearr_59798_59813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59796 === (2))){
var inst_59772 = (state_59795[(7)]);
var inst_59771 = (state_59795[(9)]);
var inst_59770 = (state_59795[(11)]);
var inst_59776 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_59772,inst_59771,inst_59770);
var state_59795__$1 = state_59795;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59795__$1,(4),inst_59776);
} else {
if((state_val_59796 === (3))){
var inst_59793 = (state_59795[(2)]);
var state_59795__$1 = state_59795;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59795__$1,inst_59793);
} else {
if((state_val_59796 === (4))){
var inst_59774 = (state_59795[(8)]);
var inst_59773 = (state_59795[(10)]);
var inst_59778 = (state_59795[(2)]);
var inst_59779 = fluree.db.util.async.throw_err.call(null,inst_59778);
var inst_59780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59781 = [inst_59779];
var inst_59782 = (new cljs.core.PersistentVector(null,1,(5),inst_59780,inst_59781,null));
var inst_59783 = cljs.core.concat.call(null,inst_59774,inst_59782);
var inst_59784 = cljs.core.first.call(null,inst_59773);
var state_59795__$1 = (function (){var statearr_59801 = state_59795;
(statearr_59801[(12)] = inst_59783);

return statearr_59801;
})();
if(cljs.core.truth_(inst_59784)){
var statearr_59802_59814 = state_59795__$1;
(statearr_59802_59814[(1)] = (5));

} else {
var statearr_59803_59815 = state_59795__$1;
(statearr_59803_59815[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59796 === (5))){
var inst_59783 = (state_59795[(12)]);
var inst_59771 = (state_59795[(9)]);
var inst_59773 = (state_59795[(10)]);
var inst_59770 = (state_59795[(11)]);
var inst_59786 = cljs.core.first.call(null,inst_59773);
var inst_59787 = cljs.core.rest.call(null,inst_59773);
var tmp59799 = inst_59771;
var tmp59800 = inst_59770;
var inst_59770__$1 = tmp59800;
var inst_59771__$1 = tmp59799;
var inst_59772 = inst_59786;
var inst_59773__$1 = inst_59787;
var inst_59774 = inst_59783;
var state_59795__$1 = (function (){var statearr_59804 = state_59795;
(statearr_59804[(7)] = inst_59772);

(statearr_59804[(8)] = inst_59774);

(statearr_59804[(9)] = inst_59771__$1);

(statearr_59804[(10)] = inst_59773__$1);

(statearr_59804[(11)] = inst_59770__$1);

return statearr_59804;
})();
var statearr_59805_59816 = state_59795__$1;
(statearr_59805_59816[(2)] = null);

(statearr_59805_59816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59796 === (6))){
var inst_59783 = (state_59795[(12)]);
var state_59795__$1 = state_59795;
var statearr_59806_59817 = state_59795__$1;
(statearr_59806_59817[(2)] = inst_59783);

(statearr_59806_59817[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59796 === (7))){
var inst_59791 = (state_59795[(2)]);
var state_59795__$1 = state_59795;
var statearr_59807_59818 = state_59795__$1;
(statearr_59807_59818[(2)] = inst_59791);

(statearr_59807_59818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto____0 = (function (){
var statearr_59808 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59808[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto__);

(statearr_59808[(1)] = (1));

return statearr_59808;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto____1 = (function (state_59795){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_59795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e59809){var ex__2744__auto__ = e59809;
var statearr_59810_59819 = state_59795;
(statearr_59810_59819[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_59795[(4)]))){
var statearr_59811_59820 = state_59795;
(statearr_59811_59820[(1)] = cljs.core.first.call(null,(state_59795[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59821 = state_59795;
state_59795 = G__59821;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto__ = function(state_59795){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto____1.call(this,state_59795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_59812 = f__2764__auto__.call(null);
(statearr_59812[(6)] = c__2763__auto__);

return statearr_59812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__59823 = arguments.length;
switch (G__59823) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__59825){
var map__59826 = p__59825;
var map__59826__$1 = cljs.core.__destructure_map.call(null,map__59826);
var query = map__59826__$1;
var opts = cljs.core.get.call(null,map__59826__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_59911){
var state_val_59912 = (state_59911[(1)]);
if((state_val_59912 === (7))){
var inst_59837 = (state_59911[(7)]);
var inst_59841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59842 = ["_auth/id",inst_59837];
var inst_59843 = (new cljs.core.PersistentVector(null,2,(5),inst_59841,inst_59842,null));
var state_59911__$1 = state_59911;
var statearr_59913_59957 = state_59911__$1;
(statearr_59913_59957[(2)] = inst_59843);

(statearr_59913_59957[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (20))){
var inst_59891 = (state_59911[(2)]);
var inst_59892 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_59911__$1 = (function (){var statearr_59914 = state_59911;
(statearr_59914[(8)] = inst_59891);

return statearr_59914;
})();
if(cljs.core.truth_(inst_59892)){
var statearr_59915_59958 = state_59911__$1;
(statearr_59915_59958[(1)] = (22));

} else {
var statearr_59916_59959 = state_59911__$1;
(statearr_59916_59959[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (27))){
var inst_59894 = (state_59911[(9)]);
var inst_59838 = (state_59911[(10)]);
var inst_59900 = (state_59911[(2)]);
var inst_59901 = fluree.db.util.core.response_time_formatted.call(null,inst_59838);
var inst_59902 = [(200),inst_59900,(100),inst_59901];
var inst_59903 = cljs.core.PersistentHashMap.fromArrays(inst_59894,inst_59902);
var state_59911__$1 = state_59911;
var statearr_59917_59960 = state_59911__$1;
(statearr_59917_59960[(2)] = inst_59903);

(statearr_59917_59960[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (1))){
var state_59911__$1 = state_59911;
var statearr_59918_59961 = state_59911__$1;
(statearr_59918_59961[(2)] = null);

(statearr_59918_59961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (24))){
var inst_59906 = (state_59911[(2)]);
var _ = (function (){var statearr_59919 = state_59911;
(statearr_59919[(4)] = cljs.core.rest.call(null,(state_59911[(4)])));

return statearr_59919;
})();
var state_59911__$1 = state_59911;
var statearr_59920_59962 = state_59911__$1;
(statearr_59920_59962[(2)] = inst_59906);

(statearr_59920_59962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (4))){
var inst_59827 = (state_59911[(2)]);
var state_59911__$1 = state_59911;
var statearr_59921_59963 = state_59911__$1;
(statearr_59921_59963[(2)] = inst_59827);

(statearr_59921_59963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (15))){
var inst_59878 = (state_59911[(11)]);
var state_59911__$1 = state_59911;
var statearr_59922_59964 = state_59911__$1;
(statearr_59922_59964[(2)] = inst_59878);

(statearr_59922_59964[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (21))){
var inst_59887 = (state_59911[(2)]);
var inst_59888 = fluree.db.util.async.throw_err.call(null,inst_59887);
var state_59911__$1 = state_59911;
var statearr_59923_59965 = state_59911__$1;
(statearr_59923_59965[(2)] = inst_59888);

(statearr_59923_59965[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (13))){
var inst_59836 = (state_59911[(12)]);
var inst_59878 = (state_59911[(11)]);
var inst_59877 = (state_59911[(2)]);
var inst_59878__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_59836);
var state_59911__$1 = (function (){var statearr_59924 = state_59911;
(statearr_59924[(13)] = inst_59877);

(statearr_59924[(11)] = inst_59878__$1);

return statearr_59924;
})();
if(cljs.core.truth_(inst_59878__$1)){
var statearr_59925_59966 = state_59911__$1;
(statearr_59925_59966[(1)] = (15));

} else {
var statearr_59926_59967 = state_59911__$1;
(statearr_59926_59967[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (22))){
var inst_59891 = (state_59911[(8)]);
var inst_59894 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_59895 = cljs.core.sequential_QMARK_.call(null,inst_59891);
var state_59911__$1 = (function (){var statearr_59927 = state_59911;
(statearr_59927[(9)] = inst_59894);

return statearr_59927;
})();
if(inst_59895){
var statearr_59928_59968 = state_59911__$1;
(statearr_59928_59968[(1)] = (25));

} else {
var statearr_59929_59969 = state_59911__$1;
(statearr_59929_59969[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (6))){
var inst_59836 = (state_59911[(12)]);
var inst_59852 = (state_59911[(14)]);
var inst_59851 = (state_59911[(2)]);
var inst_59852__$1 = fluree.db.util.async.throw_err.call(null,inst_59851);
var inst_59853 = fluree.db.api.query.resolve_block_range.call(null,inst_59852__$1,inst_59836);
var state_59911__$1 = (function (){var statearr_59930 = state_59911;
(statearr_59930[(14)] = inst_59852__$1);

return statearr_59930;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59911__$1,(10),inst_59853);
} else {
if((state_val_59912 === (25))){
var inst_59891 = (state_59911[(8)]);
var inst_59897 = cljs.core.doall.call(null,inst_59891);
var state_59911__$1 = state_59911;
var statearr_59931_59970 = state_59911__$1;
(statearr_59931_59970[(2)] = inst_59897);

(statearr_59931_59970[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (17))){
var inst_59883 = (state_59911[(2)]);
var state_59911__$1 = state_59911;
if(cljs.core.truth_(inst_59883)){
var statearr_59932_59971 = state_59911__$1;
(statearr_59932_59971[(1)] = (18));

} else {
var statearr_59933_59972 = state_59911__$1;
(statearr_59933_59972[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (3))){
var inst_59909 = (state_59911[(2)]);
var state_59911__$1 = state_59911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59911__$1,inst_59909);
} else {
if((state_val_59912 === (12))){
var inst_59836 = (state_59911[(12)]);
var inst_59869 = cljs.core.pr_str.call(null,inst_59836);
var inst_59870 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_59869].join('');
var inst_59871 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59872 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59873 = cljs.core.PersistentHashMap.fromArrays(inst_59871,inst_59872);
var inst_59874 = cljs.core.ex_info.call(null,inst_59870,inst_59873);
var inst_59875 = (function(){throw inst_59874})();
var state_59911__$1 = state_59911;
var statearr_59934_59973 = state_59911__$1;
(statearr_59934_59973[(2)] = inst_59875);

(statearr_59934_59973[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (2))){
var inst_59837 = (state_59911[(7)]);
var _ = (function (){var statearr_59935 = state_59911;
(statearr_59935[(4)] = cljs.core.cons.call(null,(5),(state_59911[(4)])));

return statearr_59935;
})();
var inst_59836 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_59837__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_59838 = fluree.db.util.core.current_time_millis.call(null);
var inst_59839 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_59911__$1 = (function (){var statearr_59936 = state_59911;
(statearr_59936[(7)] = inst_59837__$1);

(statearr_59936[(12)] = inst_59836);

(statearr_59936[(15)] = inst_59839);

(statearr_59936[(10)] = inst_59838);

return statearr_59936;
})();
if(cljs.core.truth_(inst_59837__$1)){
var statearr_59937_59974 = state_59911__$1;
(statearr_59937_59974[(1)] = (7));

} else {
var statearr_59938_59975 = state_59911__$1;
(statearr_59938_59975[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (23))){
var inst_59891 = (state_59911[(8)]);
var state_59911__$1 = state_59911;
var statearr_59939_59976 = state_59911__$1;
(statearr_59939_59976[(2)] = inst_59891);

(statearr_59939_59976[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (19))){
var inst_59877 = (state_59911[(13)]);
var state_59911__$1 = state_59911;
var statearr_59940_59977 = state_59911__$1;
(statearr_59940_59977[(2)] = inst_59877);

(statearr_59940_59977[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (11))){
var inst_59858 = (state_59911[(16)]);
var inst_59852 = (state_59911[(14)]);
var inst_59857 = (state_59911[(17)]);
var inst_59864 = fluree.db.api.query.block_range.call(null,inst_59852,inst_59857,inst_59858,opts);
var state_59911__$1 = state_59911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59911__$1,(14),inst_59864);
} else {
if((state_val_59912 === (9))){
var inst_59839 = (state_59911[(15)]);
var inst_59846 = (state_59911[(2)]);
var inst_59847 = [inst_59846];
var inst_59848 = cljs.core.PersistentHashMap.fromArrays(inst_59839,inst_59847);
var inst_59849 = fluree.db.api.query.db.call(null,conn,ledger,inst_59848);
var state_59911__$1 = state_59911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59911__$1,(6),inst_59849);
} else {
if((state_val_59912 === (5))){
var _ = (function (){var statearr_59942 = state_59911;
(statearr_59942[(4)] = cljs.core.rest.call(null,(state_59911[(4)])));

return statearr_59942;
})();
var state_59911__$1 = state_59911;
var ex59941 = (state_59911__$1[(2)]);
var statearr_59943_59978 = state_59911__$1;
(statearr_59943_59978[(5)] = ex59941);


if((ex59941 instanceof Error)){
var statearr_59944_59979 = state_59911__$1;
(statearr_59944_59979[(1)] = (4));

(statearr_59944_59979[(5)] = null);

} else {
throw ex59941;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (14))){
var inst_59866 = (state_59911[(2)]);
var inst_59867 = fluree.db.util.async.throw_err.call(null,inst_59866);
var state_59911__$1 = state_59911;
var statearr_59945_59980 = state_59911__$1;
(statearr_59945_59980[(2)] = inst_59867);

(statearr_59945_59980[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (26))){
var inst_59891 = (state_59911[(8)]);
var state_59911__$1 = state_59911;
var statearr_59946_59981 = state_59911__$1;
(statearr_59946_59981[(2)] = inst_59891);

(statearr_59946_59981[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (16))){
var inst_59836 = (state_59911[(12)]);
var inst_59881 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_59836);
var state_59911__$1 = state_59911;
var statearr_59947_59982 = state_59911__$1;
(statearr_59947_59982[(2)] = inst_59881);

(statearr_59947_59982[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (10))){
var inst_59836 = (state_59911[(12)]);
var inst_59855 = (state_59911[(2)]);
var inst_59856 = fluree.db.util.async.throw_err.call(null,inst_59855);
var inst_59857 = cljs.core.nth.call(null,inst_59856,(0),null);
var inst_59858 = cljs.core.nth.call(null,inst_59856,(1),null);
var inst_59859 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_59860 = cljs.core.dissoc.call(null,inst_59836,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_59861 = cljs.core.keys.call(null,inst_59860);
var inst_59862 = cljs.core._EQ_.call(null,inst_59859,inst_59861);
var state_59911__$1 = (function (){var statearr_59948 = state_59911;
(statearr_59948[(16)] = inst_59858);

(statearr_59948[(17)] = inst_59857);

return statearr_59948;
})();
if(inst_59862){
var statearr_59949_59983 = state_59911__$1;
(statearr_59949_59983[(1)] = (11));

} else {
var statearr_59950_59984 = state_59911__$1;
(statearr_59950_59984[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59912 === (18))){
var inst_59877 = (state_59911[(13)]);
var inst_59852 = (state_59911[(14)]);
var inst_59885 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_59852,inst_59877);
var state_59911__$1 = state_59911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59911__$1,(21),inst_59885);
} else {
if((state_val_59912 === (8))){
var state_59911__$1 = state_59911;
var statearr_59951_59985 = state_59911__$1;
(statearr_59951_59985[(2)] = null);

(statearr_59951_59985[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2741__auto____0 = (function (){
var statearr_59952 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59952[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2741__auto__);

(statearr_59952[(1)] = (1));

return statearr_59952;
});
var fluree$db$api$query$block_query_async_$_state_machine__2741__auto____1 = (function (state_59911){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_59911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e59953){var ex__2744__auto__ = e59953;
var statearr_59954_59986 = state_59911;
(statearr_59954_59986[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_59911[(4)]))){
var statearr_59955_59987 = state_59911;
(statearr_59955_59987[(1)] = cljs.core.first.call(null,(state_59911[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59988 = state_59911;
state_59911 = G__59988;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2741__auto__ = function(state_59911){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2741__auto____1.call(this,state_59911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2741__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2741__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_59956 = f__2764__auto__.call(null);
(statearr_59956[(6)] = c__2763__auto__);

return statearr_59956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__59989 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__59989,(0),null);
var p = cljs.core.nth.call(null,vec__59989,(1),null);
var o = cljs.core.nth.call(null,vec__59989,(2),null);
var t = cljs.core.nth.call(null,vec__59989,(3),null);
var vec__59992 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__59992,(0),null);
var idx = cljs.core.nth.call(null,vec__59992,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__59995 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__59995,(0),null);
var id = cljs.core.nth.call(null,vec__59995,(1),null);
var or__4253__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___59999 = arguments.length;
var i__4865__auto___60000 = (0);
while(true){
if((i__4865__auto___60000 < len__4864__auto___59999)){
args__4870__auto__.push((arguments[i__4865__auto___60000]));

var G__60001 = (i__4865__auto___60000 + (1));
i__4865__auto___60000 = G__60001;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq59998){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq59998));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_60197){
var state_val_60198 = (state_60197[(1)]);
if((state_val_60198 === (7))){
var inst_60124 = (state_60197[(7)]);
var inst_60117 = (state_60197[(8)]);
var inst_60123 = cljs.core.seq.call(null,inst_60117);
var inst_60124__$1 = cljs.core.first.call(null,inst_60123);
var inst_60125 = cljs.core.next.call(null,inst_60123);
var state_60197__$1 = (function (){var statearr_60199 = state_60197;
(statearr_60199[(9)] = inst_60125);

(statearr_60199[(7)] = inst_60124__$1);

return statearr_60199;
})();
if(cljs.core.truth_(inst_60124__$1)){
var statearr_60200_60300 = state_60197__$1;
(statearr_60200_60300[(1)] = (9));

} else {
var statearr_60201_60301 = state_60197__$1;
(statearr_60201_60301[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (20))){
var inst_60187 = (state_60197[(2)]);
var state_60197__$1 = state_60197;
var statearr_60202_60302 = state_60197__$1;
(statearr_60202_60302[(2)] = inst_60187);

(statearr_60202_60302[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (27))){
var inst_60163 = (state_60197[(10)]);
var inst_60145 = (state_60197[(11)]);
var inst_60142 = (state_60197[(12)]);
var inst_60165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60166 = [inst_60145,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_60167 = (new cljs.core.PersistentVector(null,2,(5),inst_60165,inst_60166,null));
var inst_60168 = cljs.core.update_in.call(null,inst_60163,inst_60167,fluree.db.api.query.min_safe,inst_60142);
var state_60197__$1 = state_60197;
var statearr_60203_60303 = state_60197__$1;
(statearr_60203_60303[(2)] = inst_60168);

(statearr_60203_60303[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (1))){
var state_60197__$1 = state_60197;
var statearr_60204_60304 = state_60197__$1;
(statearr_60204_60304[(2)] = null);

(statearr_60204_60304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (24))){
var inst_60145 = (state_60197[(11)]);
var inst_60155 = (state_60197[(13)]);
var inst_60124 = (state_60197[(7)]);
var inst_60157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60158 = [inst_60145,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_60159 = (new cljs.core.PersistentVector(null,2,(5),inst_60157,inst_60158,null));
var inst_60160 = cljs.core.update_in.call(null,inst_60155,inst_60159,cljs.core.conj,inst_60124);
var state_60197__$1 = state_60197;
var statearr_60206_60305 = state_60197__$1;
(statearr_60206_60305[(2)] = inst_60160);

(statearr_60206_60305[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (4))){
var inst_60003 = (state_60197[(2)]);
var state_60197__$1 = state_60197;
var statearr_60207_60306 = state_60197__$1;
(statearr_60207_60306[(2)] = inst_60003);

(statearr_60207_60306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (15))){
var inst_60125 = (state_60197[(9)]);
var inst_60118 = (state_60197[(14)]);
var tmp60205 = inst_60118;
var inst_60117 = inst_60125;
var inst_60118__$1 = tmp60205;
var state_60197__$1 = (function (){var statearr_60208 = state_60197;
(statearr_60208[(14)] = inst_60118__$1);

(statearr_60208[(8)] = inst_60117);

return statearr_60208;
})();
var statearr_60209_60307 = state_60197__$1;
(statearr_60209_60307[(2)] = null);

(statearr_60209_60307[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (21))){
var inst_60145 = (state_60197[(11)]);
var inst_60118 = (state_60197[(14)]);
var inst_60149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60150 = [inst_60145,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60151 = (new cljs.core.PersistentVector(null,2,(5),inst_60149,inst_60150,null));
var inst_60152 = cljs.core.assoc_in.call(null,inst_60118,inst_60151,inst_60145);
var state_60197__$1 = state_60197;
var statearr_60210_60308 = state_60197__$1;
(statearr_60210_60308[(2)] = inst_60152);

(statearr_60210_60308[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (31))){
var inst_60171 = (state_60197[(15)]);
var state_60197__$1 = state_60197;
var statearr_60211_60309 = state_60197__$1;
(statearr_60211_60309[(2)] = inst_60171);

(statearr_60211_60309[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (32))){
var inst_60125 = (state_60197[(9)]);
var inst_60179 = (state_60197[(2)]);
var inst_60117 = inst_60125;
var inst_60118 = inst_60179;
var state_60197__$1 = (function (){var statearr_60212 = state_60197;
(statearr_60212[(14)] = inst_60118);

(statearr_60212[(8)] = inst_60117);

return statearr_60212;
})();
var statearr_60213_60310 = state_60197__$1;
(statearr_60213_60310[(2)] = null);

(statearr_60213_60310[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (33))){
var inst_60118 = (state_60197[(14)]);
var state_60197__$1 = state_60197;
var statearr_60214_60311 = state_60197__$1;
(statearr_60214_60311[(2)] = inst_60118);

(statearr_60214_60311[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (13))){
var inst_60127 = (state_60197[(16)]);
var state_60197__$1 = state_60197;
var statearr_60215_60312 = state_60197__$1;
(statearr_60215_60312[(2)] = inst_60127);

(statearr_60215_60312[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (22))){
var inst_60118 = (state_60197[(14)]);
var state_60197__$1 = state_60197;
var statearr_60216_60313 = state_60197__$1;
(statearr_60216_60313[(2)] = inst_60118);

(statearr_60216_60313[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (29))){
var inst_60171 = (state_60197[(2)]);
var state_60197__$1 = (function (){var statearr_60217 = state_60197;
(statearr_60217[(15)] = inst_60171);

return statearr_60217;
})();
if(cljs.core.truth_(show_auth)){
var statearr_60218_60314 = state_60197__$1;
(statearr_60218_60314[(1)] = (30));

} else {
var statearr_60219_60315 = state_60197__$1;
(statearr_60219_60315[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (6))){
var inst_60103 = (state_60197[(2)]);
var inst_60104 = fluree.db.util.async.throw_err.call(null,inst_60103);
var inst_60112 = resp;
var inst_60113 = cljs.core.seq.call(null,inst_60112);
var inst_60114 = cljs.core.first.call(null,inst_60113);
var inst_60115 = cljs.core.next.call(null,inst_60113);
var inst_60116 = cljs.core.PersistentHashMap.EMPTY;
var inst_60117 = inst_60112;
var inst_60118 = inst_60116;
var state_60197__$1 = (function (){var statearr_60220 = state_60197;
(statearr_60220[(17)] = inst_60114);

(statearr_60220[(18)] = inst_60104);

(statearr_60220[(14)] = inst_60118);

(statearr_60220[(8)] = inst_60117);

(statearr_60220[(19)] = inst_60115);

return statearr_60220;
})();
var statearr_60221_60316 = state_60197__$1;
(statearr_60221_60316[(2)] = null);

(statearr_60221_60316[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (28))){
var inst_60163 = (state_60197[(10)]);
var state_60197__$1 = state_60197;
var statearr_60222_60317 = state_60197__$1;
(statearr_60222_60317[(2)] = inst_60163);

(statearr_60222_60317[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (25))){
var inst_60155 = (state_60197[(13)]);
var state_60197__$1 = state_60197;
var statearr_60223_60318 = state_60197__$1;
(statearr_60223_60318[(2)] = inst_60155);

(statearr_60223_60318[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (34))){
var state_60197__$1 = state_60197;
var statearr_60224_60319 = state_60197__$1;
(statearr_60224_60319[(2)] = null);

(statearr_60224_60319[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (17))){
var inst_60189 = (state_60197[(2)]);
var state_60197__$1 = state_60197;
var statearr_60225_60320 = state_60197__$1;
(statearr_60225_60320[(2)] = inst_60189);

(statearr_60225_60320[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (3))){
var inst_60195 = (state_60197[(2)]);
var state_60197__$1 = state_60197;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60197__$1,inst_60195);
} else {
if((state_val_60198 === (12))){
var inst_60104 = (state_60197[(18)]);
var inst_60124 = (state_60197[(7)]);
var inst_60129 = fluree.db.api.query.auth_match.call(null,auth,inst_60104,inst_60124);
var inst_60130 = cljs.core.not.call(null,inst_60129);
var state_60197__$1 = state_60197;
var statearr_60226_60321 = state_60197__$1;
(statearr_60226_60321[(2)] = inst_60130);

(statearr_60226_60321[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (2))){
var _ = (function (){var statearr_60227 = state_60197;
(statearr_60227[(4)] = cljs.core.cons.call(null,(5),(state_60197[(4)])));

return statearr_60227;
})();
var inst_60009 = (function (){return (function (p1__60002_SHARP_){
return p1__60002_SHARP_.t;
});
})();
var inst_60010 = cljs.core.map.call(null,inst_60009,resp);
var inst_60011 = cljs.core.set.call(null,inst_60010);
var inst_60099 = cljs.core.async.chan.call(null,(1));
var inst_60100 = (function (){var ts = inst_60011;
var c__2763__auto____$1 = inst_60099;
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_60097){
var state_val_60098 = (state_60097[(1)]);
if((state_val_60098 === (7))){
var inst_60043 = (state_60097[(7)]);
var inst_60031 = (state_60097[(8)]);
var inst_60025 = (state_60097[(9)]);
var inst_60037 = (state_60097[(10)]);
var inst_60036 = (state_60097[(2)]);
var inst_60037__$1 = fluree.db.util.async.throw_err.call(null,inst_60036);
var inst_60039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60040 = [inst_60031,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60041 = (new cljs.core.PersistentVector(null,2,(5),inst_60039,inst_60040,null));
var inst_60042 = cljs.core.assoc_in.call(null,inst_60025,inst_60041,inst_60037__$1);
var inst_60043__$1 = auth;
var state_60097__$1 = (function (){var statearr_60228 = state_60097;
(statearr_60228[(7)] = inst_60043__$1);

(statearr_60228[(11)] = inst_60042);

(statearr_60228[(10)] = inst_60037__$1);

return statearr_60228;
})();
if(cljs.core.truth_(inst_60043__$1)){
var statearr_60229_60322 = state_60097__$1;
(statearr_60229_60322[(1)] = (8));

} else {
var statearr_60230_60323 = state_60097__$1;
(statearr_60230_60323[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60098 === (1))){
var inst_60019 = (state_60097[(12)]);
var inst_60019__$1 = ts;
var inst_60020 = cljs.core.seq.call(null,inst_60019__$1);
var inst_60021 = cljs.core.first.call(null,inst_60020);
var inst_60022 = cljs.core.next.call(null,inst_60020);
var inst_60023 = cljs.core.PersistentHashMap.EMPTY;
var inst_60024 = inst_60019__$1;
var inst_60025 = inst_60023;
var state_60097__$1 = (function (){var statearr_60231 = state_60097;
(statearr_60231[(13)] = inst_60021);

(statearr_60231[(12)] = inst_60019__$1);

(statearr_60231[(14)] = inst_60024);

(statearr_60231[(15)] = inst_60022);

(statearr_60231[(9)] = inst_60025);

return statearr_60231;
})();
var statearr_60232_60324 = state_60097__$1;
(statearr_60232_60324[(2)] = null);

(statearr_60232_60324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60098 === (4))){
var inst_60031 = (state_60097[(8)]);
var inst_60034 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_60031);
var state_60097__$1 = state_60097;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60097__$1,(7),inst_60034);
} else {
if((state_val_60098 === (13))){
var inst_60032 = (state_60097[(16)]);
var inst_60089 = (state_60097[(2)]);
var inst_60024 = inst_60032;
var inst_60025 = inst_60089;
var state_60097__$1 = (function (){var statearr_60233 = state_60097;
(statearr_60233[(14)] = inst_60024);

(statearr_60233[(9)] = inst_60025);

return statearr_60233;
})();
var statearr_60234_60325 = state_60097__$1;
(statearr_60234_60325[(2)] = null);

(statearr_60234_60325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60098 === (6))){
var inst_60093 = (state_60097[(2)]);
var state_60097__$1 = state_60097;
var statearr_60235_60326 = state_60097__$1;
(statearr_60235_60326[(2)] = inst_60093);

(statearr_60235_60326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60098 === (3))){
var inst_60095 = (state_60097[(2)]);
var state_60097__$1 = state_60097;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60097__$1,inst_60095);
} else {
if((state_val_60098 === (12))){
var inst_60042 = (state_60097[(11)]);
var state_60097__$1 = state_60097;
var statearr_60236_60327 = state_60097__$1;
(statearr_60236_60327[(2)] = inst_60042);

(statearr_60236_60327[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60098 === (2))){
var inst_60024 = (state_60097[(14)]);
var inst_60031 = (state_60097[(8)]);
var inst_60030 = cljs.core.seq.call(null,inst_60024);
var inst_60031__$1 = cljs.core.first.call(null,inst_60030);
var inst_60032 = cljs.core.next.call(null,inst_60030);
var state_60097__$1 = (function (){var statearr_60237 = state_60097;
(statearr_60237[(16)] = inst_60032);

(statearr_60237[(8)] = inst_60031__$1);

return statearr_60237;
})();
if(cljs.core.truth_(inst_60031__$1)){
var statearr_60238_60328 = state_60097__$1;
(statearr_60238_60328[(1)] = (4));

} else {
var statearr_60239_60329 = state_60097__$1;
(statearr_60239_60329[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60098 === (11))){
var inst_60021 = (state_60097[(13)]);
var inst_60019 = (state_60097[(12)]);
var inst_60032 = (state_60097[(16)]);
var inst_60024 = (state_60097[(14)]);
var inst_60022 = (state_60097[(15)]);
var inst_60031 = (state_60097[(8)]);
var inst_60025 = (state_60097[(9)]);
var inst_60042 = (state_60097[(11)]);
var inst_60037 = (state_60097[(10)]);
var inst_60049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60050 = [inst_60031,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60051 = (new cljs.core.PersistentVector(null,2,(5),inst_60049,inst_60050,null));
var inst_60064 = cljs.core.async.chan.call(null,(1));
var inst_60065 = (function (){var t = inst_60031;
var block = inst_60037;
var r = inst_60032;
var vec__60016 = inst_60019;
var seq__60028 = inst_60032;
var acc = inst_60025;
var G__60038 = inst_60042;
var c__2763__auto____$2 = inst_60064;
var G__60015 = inst_60024;
var first__60029 = inst_60031;
var seq__60017 = inst_60022;
var first__60018 = inst_60021;
var vec__60027 = inst_60024;
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_60062){
var state_val_60063 = (state_60062[(1)]);
if((state_val_60063 === (1))){
var state_60062__$1 = state_60062;
var statearr_60240_60330 = state_60062__$1;
(statearr_60240_60330[(2)] = null);

(statearr_60240_60330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60063 === (2))){
var ___$1 = (function (){var statearr_60241 = state_60062;
(statearr_60241[(4)] = cljs.core.cons.call(null,(5),(state_60062[(4)])));

return statearr_60241;
})();
var ___$2 = (function (){var statearr_60242 = state_60062;
(statearr_60242[(4)] = cljs.core.rest.call(null,(state_60062[(4)])));

return statearr_60242;
})();
var state_60062__$1 = state_60062;
var statearr_60243_60331 = state_60062__$1;
(statearr_60243_60331[(2)] = db);

(statearr_60243_60331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60063 === (3))){
var inst_60060 = (state_60062[(2)]);
var state_60062__$1 = state_60062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60062__$1,inst_60060);
} else {
if((state_val_60063 === (4))){
var inst_60052 = (state_60062[(2)]);
var state_60062__$1 = state_60062;
var statearr_60245_60332 = state_60062__$1;
(statearr_60245_60332[(2)] = inst_60052);

(statearr_60245_60332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60063 === (5))){
var ___$1 = (function (){var statearr_60246 = state_60062;
(statearr_60246[(4)] = cljs.core.rest.call(null,(state_60062[(4)])));

return statearr_60246;
})();
var state_60062__$1 = state_60062;
var ex60244 = (state_60062__$1[(2)]);
var statearr_60247_60333 = state_60062__$1;
(statearr_60247_60333[(5)] = ex60244);


if((ex60244 instanceof Error)){
var statearr_60248_60334 = state_60062__$1;
(statearr_60248_60334[(1)] = (4));

(statearr_60248_60334[(5)] = null);

} else {
throw ex60244;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0 = (function (){
var statearr_60249 = [null,null,null,null,null,null,null];
(statearr_60249[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__);

(statearr_60249[(1)] = (1));

return statearr_60249;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1 = (function (state_60062){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_60062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e60250){var ex__2744__auto__ = e60250;
var statearr_60251_60335 = state_60062;
(statearr_60251_60335[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_60062[(4)]))){
var statearr_60252_60336 = state_60062;
(statearr_60252_60336[(1)] = cljs.core.first.call(null,(state_60062[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60337 = state_60062;
state_60062 = G__60337;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__ = function(state_60062){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1.call(this,state_60062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_60253 = f__2764__auto__.call(null);
(statearr_60253[(6)] = c__2763__auto____$2);

return statearr_60253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
});
})();
var inst_60066 = cljs.core.async.impl.dispatch.run.call(null,inst_60065);
var inst_60067 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_60068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60069 = ["?auth","?id"];
var inst_60070 = (new cljs.core.PersistentVector(null,2,(5),inst_60068,inst_60069,null));
var inst_60071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60073 = [inst_60031,"_tx/auth","?auth"];
var inst_60074 = (new cljs.core.PersistentVector(null,3,(5),inst_60072,inst_60073,null));
var inst_60075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60076 = ["?auth","_auth/id","?id"];
var inst_60077 = (new cljs.core.PersistentVector(null,3,(5),inst_60075,inst_60076,null));
var inst_60078 = [inst_60074,inst_60077];
var inst_60079 = (new cljs.core.PersistentVector(null,2,(5),inst_60071,inst_60078,null));
var inst_60080 = [inst_60070,inst_60079];
var inst_60081 = cljs.core.PersistentHashMap.fromArrays(inst_60067,inst_60080);
var inst_60082 = fluree.db.api.query.query_async.call(null,inst_60064,inst_60081);
var state_60097__$1 = (function (){var statearr_60254 = state_60097;
(statearr_60254[(17)] = inst_60051);

(statearr_60254[(18)] = inst_60066);

return statearr_60254;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60097__$1,(14),inst_60082);
} else {
if((state_val_60098 === (9))){
var state_60097__$1 = state_60097;
var statearr_60255_60338 = state_60097__$1;
(statearr_60255_60338[(2)] = show_auth);

(statearr_60255_60338[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60098 === (5))){
var inst_60025 = (state_60097[(9)]);
var state_60097__$1 = state_60097;
var statearr_60256_60339 = state_60097__$1;
(statearr_60256_60339[(2)] = inst_60025);

(statearr_60256_60339[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60098 === (14))){
var inst_60051 = (state_60097[(17)]);
var inst_60042 = (state_60097[(11)]);
var inst_60084 = (state_60097[(2)]);
var inst_60085 = fluree.db.util.async.throw_err.call(null,inst_60084);
var inst_60086 = cljs.core.assoc_in.call(null,inst_60042,inst_60051,inst_60085);
var state_60097__$1 = state_60097;
var statearr_60257_60340 = state_60097__$1;
(statearr_60257_60340[(2)] = inst_60086);

(statearr_60257_60340[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60098 === (10))){
var inst_60047 = (state_60097[(2)]);
var state_60097__$1 = state_60097;
if(cljs.core.truth_(inst_60047)){
var statearr_60258_60341 = state_60097__$1;
(statearr_60258_60341[(1)] = (11));

} else {
var statearr_60259_60342 = state_60097__$1;
(statearr_60259_60342[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60098 === (8))){
var inst_60043 = (state_60097[(7)]);
var state_60097__$1 = state_60097;
var statearr_60260_60343 = state_60097__$1;
(statearr_60260_60343[(2)] = inst_60043);

(statearr_60260_60343[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0 = (function (){
var statearr_60261 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60261[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__);

(statearr_60261[(1)] = (1));

return statearr_60261;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1 = (function (state_60097){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_60097);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e60262){var ex__2744__auto__ = e60262;
var statearr_60263_60344 = state_60097;
(statearr_60263_60344[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_60097[(4)]))){
var statearr_60264_60345 = state_60097;
(statearr_60264_60345[(1)] = cljs.core.first.call(null,(state_60097[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60346 = state_60097;
state_60097 = G__60346;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__ = function(state_60097){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1.call(this,state_60097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_60265 = f__2764__auto__.call(null);
(statearr_60265[(6)] = c__2763__auto____$1);

return statearr_60265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
});
})();
var inst_60101 = cljs.core.async.impl.dispatch.run.call(null,inst_60100);
var state_60197__$1 = (function (){var statearr_60266 = state_60197;
(statearr_60266[(20)] = inst_60101);

return statearr_60266;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60197__$1,(6),inst_60099);
} else {
if((state_val_60198 === (23))){
var inst_60155 = (state_60197[(2)]);
var state_60197__$1 = (function (){var statearr_60267 = state_60197;
(statearr_60267[(13)] = inst_60155);

return statearr_60267;
})();
var statearr_60268_60347 = state_60197__$1;
(statearr_60268_60347[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (35))){
var inst_60185 = (state_60197[(2)]);
var state_60197__$1 = state_60197;
var statearr_60270_60348 = state_60197__$1;
(statearr_60270_60348[(2)] = inst_60185);

(statearr_60270_60348[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (19))){
var state_60197__$1 = state_60197;
var statearr_60271_60349 = state_60197__$1;
(statearr_60271_60349[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (11))){
var inst_60136 = (state_60197[(2)]);
var state_60197__$1 = state_60197;
if(cljs.core.truth_(inst_60136)){
var statearr_60274_60350 = state_60197__$1;
(statearr_60274_60350[(1)] = (15));

} else {
var statearr_60275_60351 = state_60197__$1;
(statearr_60275_60351[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (9))){
var inst_60127 = (state_60197[(16)]);
var inst_60127__$1 = auth;
var state_60197__$1 = (function (){var statearr_60276 = state_60197;
(statearr_60276[(16)] = inst_60127__$1);

return statearr_60276;
})();
if(cljs.core.truth_(inst_60127__$1)){
var statearr_60277_60352 = state_60197__$1;
(statearr_60277_60352[(1)] = (12));

} else {
var statearr_60278_60353 = state_60197__$1;
(statearr_60278_60353[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (5))){
var _ = (function (){var statearr_60279 = state_60197;
(statearr_60279[(4)] = cljs.core.rest.call(null,(state_60197[(4)])));

return statearr_60279;
})();
var state_60197__$1 = state_60197;
var ex60273 = (state_60197__$1[(2)]);
var statearr_60280_60354 = state_60197__$1;
(statearr_60280_60354[(5)] = ex60273);


if((ex60273 instanceof Error)){
var statearr_60281_60355 = state_60197__$1;
(statearr_60281_60355[(1)] = (4));

(statearr_60281_60355[(5)] = null);

} else {
throw ex60273;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (14))){
var inst_60133 = (state_60197[(2)]);
var state_60197__$1 = state_60197;
var statearr_60282_60356 = state_60197__$1;
(statearr_60282_60356[(2)] = inst_60133);

(statearr_60282_60356[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (26))){
var inst_60163 = (state_60197[(2)]);
var state_60197__$1 = (function (){var statearr_60283 = state_60197;
(statearr_60283[(10)] = inst_60163);

return statearr_60283;
})();
var statearr_60284_60357 = state_60197__$1;
(statearr_60284_60357[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (16))){
var inst_60124 = (state_60197[(7)]);
var state_60197__$1 = state_60197;
if(cljs.core.truth_(inst_60124)){
var statearr_60286_60358 = state_60197__$1;
(statearr_60286_60358[(1)] = (18));

} else {
var statearr_60287_60359 = state_60197__$1;
(statearr_60287_60359[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (30))){
var inst_60171 = (state_60197[(15)]);
var inst_60145 = (state_60197[(11)]);
var inst_60146 = (state_60197[(21)]);
var inst_60173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60174 = [inst_60145,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60175 = (new cljs.core.PersistentVector(null,2,(5),inst_60173,inst_60174,null));
var inst_60176 = cljs.core.assoc_in.call(null,inst_60171,inst_60175,inst_60146);
var state_60197__$1 = state_60197;
var statearr_60288_60360 = state_60197__$1;
(statearr_60288_60360[(2)] = inst_60176);

(statearr_60288_60360[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (10))){
var inst_60124 = (state_60197[(7)]);
var state_60197__$1 = state_60197;
var statearr_60289_60361 = state_60197__$1;
(statearr_60289_60361[(2)] = inst_60124);

(statearr_60289_60361[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (18))){
var inst_60104 = (state_60197[(18)]);
var inst_60124 = (state_60197[(7)]);
var inst_60142 = (state_60197[(12)]);
var inst_60142__$1 = inst_60124.t;
var inst_60143 = cljs.core.get.call(null,inst_60104,inst_60142__$1);
var inst_60144 = cljs.core.__destructure_map.call(null,inst_60143);
var inst_60145 = cljs.core.get.call(null,inst_60144,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60146 = cljs.core.get.call(null,inst_60144,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_60197__$1 = (function (){var statearr_60290 = state_60197;
(statearr_60290[(11)] = inst_60145);

(statearr_60290[(12)] = inst_60142__$1);

(statearr_60290[(21)] = inst_60146);

return statearr_60290;
})();
var statearr_60291_60362 = state_60197__$1;
(statearr_60291_60362[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60198 === (8))){
var inst_60191 = (state_60197[(2)]);
var inst_60192 = cljs.core.vals.call(null,inst_60191);
var _ = (function (){var statearr_60293 = state_60197;
(statearr_60293[(4)] = cljs.core.rest.call(null,(state_60197[(4)])));

return statearr_60293;
})();
var state_60197__$1 = state_60197;
var statearr_60294_60363 = state_60197__$1;
(statearr_60294_60363[(2)] = inst_60192);

(statearr_60294_60363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0 = (function (){
var statearr_60295 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60295[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__);

(statearr_60295[(1)] = (1));

return statearr_60295;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1 = (function (state_60197){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_60197);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e60296){var ex__2744__auto__ = e60296;
var statearr_60297_60364 = state_60197;
(statearr_60297_60364[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_60197[(4)]))){
var statearr_60298_60365 = state_60197;
(statearr_60298_60365[(1)] = cljs.core.first.call(null,(state_60197[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60366 = state_60197;
state_60197 = G__60366;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__ = function(state_60197){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1.call(this,state_60197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_60299 = f__2764__auto__.call(null);
(statearr_60299[(6)] = c__2763__auto__);

return statearr_60299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_60493){
var state_val_60494 = (state_60493[(1)]);
if((state_val_60494 === (7))){
var inst_60389 = (state_60493[(7)]);
var inst_60391 = fluree.db.api.query.resolve_block_range.call(null,inst_60389,query_map);
var state_60493__$1 = state_60493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60493__$1,(10),inst_60391);
} else {
if((state_val_60494 === (20))){
var inst_60418 = (state_60493[(2)]);
var inst_60419 = fluree.db.util.async.throw_err.call(null,inst_60418);
var inst_60420 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60419);
var inst_60421 = (inst_60420 - (1));
var state_60493__$1 = state_60493;
var statearr_60495_60558 = state_60493__$1;
(statearr_60495_60558[(2)] = inst_60421);

(statearr_60495_60558[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (27))){
var state_60493__$1 = state_60493;
var statearr_60496_60559 = state_60493__$1;
(statearr_60496_60559[(2)] = null);

(statearr_60496_60559[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (1))){
var state_60493__$1 = state_60493;
var statearr_60497_60560 = state_60493__$1;
(statearr_60497_60560[(2)] = null);

(statearr_60497_60560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (24))){
var inst_60428 = (state_60493[(2)]);
var inst_60429 = fluree.db.util.async.throw_err.call(null,inst_60428);
var inst_60430 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60429);
var state_60493__$1 = state_60493;
var statearr_60498_60561 = state_60493__$1;
(statearr_60498_60561[(2)] = inst_60430);

(statearr_60498_60561[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (39))){
var inst_60465 = (state_60493[(2)]);
var inst_60466 = fluree.db.util.async.throw_err.call(null,inst_60465);
var state_60493__$1 = state_60493;
var statearr_60499_60562 = state_60493__$1;
(statearr_60499_60562[(2)] = inst_60466);

(statearr_60499_60562[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (4))){
var inst_60367 = (state_60493[(2)]);
var state_60493__$1 = state_60493;
var statearr_60500_60563 = state_60493__$1;
(statearr_60500_60563[(2)] = inst_60367);

(statearr_60500_60563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (15))){
var inst_60398 = (state_60493[(8)]);
var state_60493__$1 = state_60493;
var statearr_60501_60564 = state_60493__$1;
(statearr_60501_60564[(2)] = inst_60398);

(statearr_60501_60564[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (21))){
var inst_60399 = (state_60493[(9)]);
var inst_60389 = (state_60493[(7)]);
var inst_60426 = fluree.db.time_travel.as_of_block.call(null,inst_60389,inst_60399);
var state_60493__$1 = state_60493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60493__$1,(24),inst_60426);
} else {
if((state_val_60494 === (31))){
var inst_60383 = (state_60493[(10)]);
var state_60493__$1 = state_60493;
var statearr_60502_60565 = state_60493__$1;
(statearr_60502_60565[(2)] = inst_60383);

(statearr_60502_60565[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (32))){
var inst_60444 = (state_60493[(11)]);
var inst_60449 = (state_60493[(12)]);
var inst_60389 = (state_60493[(7)]);
var inst_60453 = (state_60493[(2)]);
var inst_60454 = fluree.db.api.query.format_history_resp.call(null,inst_60389,inst_60444,inst_60449,inst_60453);
var state_60493__$1 = state_60493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60493__$1,(29),inst_60454);
} else {
if((state_val_60494 === (40))){
var inst_60470 = (state_60493[(13)]);
var inst_60444 = (state_60493[(11)]);
var inst_60472 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_60473 = cljs.core.count.call(null,inst_60444);
var inst_60474 = [inst_60470,inst_60473,(200)];
var inst_60475 = cljs.core.PersistentHashMap.fromArrays(inst_60472,inst_60474);
var state_60493__$1 = state_60493;
var statearr_60503_60566 = state_60493__$1;
(statearr_60503_60566[(2)] = inst_60475);

(statearr_60503_60566[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (33))){
var inst_60382 = (state_60493[(14)]);
var state_60493__$1 = state_60493;
var statearr_60504_60567 = state_60493__$1;
(statearr_60504_60567[(2)] = inst_60382);

(statearr_60504_60567[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (13))){
var inst_60488 = (state_60493[(2)]);
var _ = (function (){var statearr_60505 = state_60493;
(statearr_60505[(4)] = cljs.core.rest.call(null,(state_60493[(4)])));

return statearr_60505;
})();
var state_60493__$1 = state_60493;
var statearr_60506_60568 = state_60493__$1;
(statearr_60506_60568[(2)] = inst_60488);

(statearr_60506_60568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (22))){
var inst_60389 = (state_60493[(7)]);
var inst_60432 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60389);
var state_60493__$1 = state_60493;
var statearr_60507_60569 = state_60493__$1;
(statearr_60507_60569[(2)] = inst_60432);

(statearr_60507_60569[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (36))){
var inst_60389 = (state_60493[(7)]);
var inst_60457 = (state_60493[(15)]);
var inst_60463 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_60389,inst_60457);
var state_60493__$1 = state_60493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60493__$1,(39),inst_60463);
} else {
if((state_val_60494 === (41))){
var inst_60470 = (state_60493[(13)]);
var state_60493__$1 = state_60493;
var statearr_60508_60570 = state_60493__$1;
(statearr_60508_60570[(2)] = inst_60470);

(statearr_60508_60570[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (29))){
var inst_60382 = (state_60493[(14)]);
var inst_60456 = (state_60493[(2)]);
var inst_60457 = fluree.db.util.async.throw_err.call(null,inst_60456);
var state_60493__$1 = (function (){var statearr_60509 = state_60493;
(statearr_60509[(15)] = inst_60457);

return statearr_60509;
})();
if(cljs.core.truth_(inst_60382)){
var statearr_60510_60571 = state_60493__$1;
(statearr_60510_60571[(1)] = (33));

} else {
var statearr_60511_60572 = state_60493__$1;
(statearr_60511_60572[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (6))){
var inst_60379 = (state_60493[(16)]);
var inst_60388 = (state_60493[(2)]);
var inst_60389 = fluree.db.util.async.throw_err.call(null,inst_60388);
var state_60493__$1 = (function (){var statearr_60512 = state_60493;
(statearr_60512[(7)] = inst_60389);

return statearr_60512;
})();
if(cljs.core.truth_(inst_60379)){
var statearr_60513_60573 = state_60493__$1;
(statearr_60513_60573[(1)] = (7));

} else {
var statearr_60514_60574 = state_60493__$1;
(statearr_60514_60574[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (28))){
var inst_60384 = (state_60493[(17)]);
var inst_60449 = (state_60493[(2)]);
var state_60493__$1 = (function (){var statearr_60515 = state_60493;
(statearr_60515[(12)] = inst_60449);

return statearr_60515;
})();
if(cljs.core.truth_(inst_60384)){
var statearr_60516_60575 = state_60493__$1;
(statearr_60516_60575[(1)] = (30));

} else {
var statearr_60517_60576 = state_60493__$1;
(statearr_60517_60576[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (25))){
var inst_60385 = (state_60493[(18)]);
var inst_60443 = (state_60493[(2)]);
var inst_60444 = fluree.db.util.async.throw_err.call(null,inst_60443);
var state_60493__$1 = (function (){var statearr_60518 = state_60493;
(statearr_60518[(11)] = inst_60444);

return statearr_60518;
})();
if(cljs.core.truth_(inst_60385)){
var statearr_60519_60577 = state_60493__$1;
(statearr_60519_60577[(1)] = (26));

} else {
var statearr_60520_60578 = state_60493__$1;
(statearr_60520_60578[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (34))){
var inst_60381 = (state_60493[(19)]);
var state_60493__$1 = state_60493;
var statearr_60521_60579 = state_60493__$1;
(statearr_60521_60579[(2)] = inst_60381);

(statearr_60521_60579[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (17))){
var inst_60398 = (state_60493[(8)]);
var inst_60389 = (state_60493[(7)]);
var inst_60415 = (inst_60398 - (1));
var inst_60416 = fluree.db.time_travel.as_of_block.call(null,inst_60389,inst_60415);
var state_60493__$1 = state_60493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60493__$1,(20),inst_60416);
} else {
if((state_val_60494 === (3))){
var inst_60491 = (state_60493[(2)]);
var state_60493__$1 = state_60493;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60493__$1,inst_60491);
} else {
if((state_val_60494 === (12))){
var inst_60480 = cljs.core.pr_str.call(null,query_map);
var inst_60481 = ["History query not properly formatted. Provided ",inst_60480].join('');
var inst_60482 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60483 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60484 = cljs.core.PersistentHashMap.fromArrays(inst_60482,inst_60483);
var inst_60485 = cljs.core.ex_info.call(null,inst_60481,inst_60484);
var inst_60486 = (function(){throw inst_60485})();
var state_60493__$1 = state_60493;
var statearr_60522_60580 = state_60493__$1;
(statearr_60522_60580[(2)] = inst_60486);

(statearr_60522_60580[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (2))){
var _ = (function (){var statearr_60523 = state_60493;
(statearr_60523[(4)] = cljs.core.cons.call(null,(5),(state_60493[(4)])));

return statearr_60523;
})();
var inst_60377 = query_map;
var inst_60378 = cljs.core.__destructure_map.call(null,inst_60377);
var inst_60379 = cljs.core.get.call(null,inst_60378,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60380 = cljs.core.get.call(null,inst_60378,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60381 = cljs.core.get.call(null,inst_60378,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_60382 = cljs.core.get.call(null,inst_60378,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_60383 = cljs.core.get.call(null,inst_60378,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_60384 = cljs.core.get.call(null,inst_60378,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_60385 = cljs.core.get.call(null,inst_60378,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60386 = cljs.core.get.call(null,inst_60378,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_60493__$1 = (function (){var statearr_60524 = state_60493;
(statearr_60524[(16)] = inst_60379);

(statearr_60524[(14)] = inst_60382);

(statearr_60524[(18)] = inst_60385);

(statearr_60524[(20)] = inst_60386);

(statearr_60524[(19)] = inst_60381);

(statearr_60524[(17)] = inst_60384);

(statearr_60524[(10)] = inst_60383);

(statearr_60524[(21)] = inst_60380);

return statearr_60524;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60493__$1,(6),sources);
} else {
if((state_val_60494 === (23))){
var inst_60424 = (state_60493[(22)]);
var inst_60389 = (state_60493[(7)]);
var inst_60380 = (state_60493[(21)]);
var inst_60434 = (state_60493[(2)]);
var inst_60435 = fluree.db.api.query.get_history_pattern.call(null,inst_60380);
var inst_60436 = cljs.core.nth.call(null,inst_60435,(0),null);
var inst_60437 = cljs.core.nth.call(null,inst_60435,(1),null);
var inst_60438 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_60439 = [inst_60424,inst_60434];
var inst_60440 = cljs.core.PersistentHashMap.fromArrays(inst_60438,inst_60439);
var inst_60441 = fluree.db.query.range.time_range.call(null,inst_60389,inst_60437,cljs.core._EQ_,inst_60436,inst_60440);
var state_60493__$1 = state_60493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60493__$1,(25),inst_60441);
} else {
if((state_val_60494 === (35))){
var inst_60461 = (state_60493[(2)]);
var state_60493__$1 = state_60493;
if(cljs.core.truth_(inst_60461)){
var statearr_60525_60581 = state_60493__$1;
(statearr_60525_60581[(1)] = (36));

} else {
var statearr_60526_60582 = state_60493__$1;
(statearr_60526_60582[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (19))){
var inst_60399 = (state_60493[(9)]);
var inst_60424 = (state_60493[(2)]);
var state_60493__$1 = (function (){var statearr_60527 = state_60493;
(statearr_60527[(22)] = inst_60424);

return statearr_60527;
})();
if(cljs.core.truth_(inst_60399)){
var statearr_60528_60583 = state_60493__$1;
(statearr_60528_60583[(1)] = (21));

} else {
var statearr_60529_60584 = state_60493__$1;
(statearr_60529_60584[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (11))){
var inst_60398 = (state_60493[(8)]);
var inst_60386 = (state_60493[(20)]);
var inst_60408 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60386);
var state_60493__$1 = (function (){var statearr_60531 = state_60493;
(statearr_60531[(23)] = inst_60408);

return statearr_60531;
})();
if(cljs.core.truth_(inst_60398)){
var statearr_60532_60585 = state_60493__$1;
(statearr_60532_60585[(1)] = (14));

} else {
var statearr_60533_60586 = state_60493__$1;
(statearr_60533_60586[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (9))){
var inst_60397 = (state_60493[(2)]);
var inst_60398 = cljs.core.nth.call(null,inst_60397,(0),null);
var inst_60399 = cljs.core.nth.call(null,inst_60397,(1),null);
var inst_60400 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60401 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60402 = cljs.core.keys.call(null,inst_60401);
var inst_60403 = cljs.core._EQ_.call(null,inst_60400,inst_60402);
var state_60493__$1 = (function (){var statearr_60534 = state_60493;
(statearr_60534[(8)] = inst_60398);

(statearr_60534[(9)] = inst_60399);

return statearr_60534;
})();
if(inst_60403){
var statearr_60535_60587 = state_60493__$1;
(statearr_60535_60587[(1)] = (11));

} else {
var statearr_60536_60588 = state_60493__$1;
(statearr_60536_60588[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (5))){
var _ = (function (){var statearr_60537 = state_60493;
(statearr_60537[(4)] = cljs.core.rest.call(null,(state_60493[(4)])));

return statearr_60537;
})();
var state_60493__$1 = state_60493;
var ex60530 = (state_60493__$1[(2)]);
var statearr_60538_60589 = state_60493__$1;
(statearr_60538_60589[(5)] = ex60530);


if((ex60530 instanceof Error)){
var statearr_60539_60590 = state_60493__$1;
(statearr_60539_60590[(1)] = (4));

(statearr_60539_60590[(5)] = null);

} else {
throw ex60530;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (14))){
var inst_60398 = (state_60493[(8)]);
var inst_60410 = cljs.core.not_EQ_.call(null,(1),inst_60398);
var state_60493__$1 = state_60493;
var statearr_60540_60591 = state_60493__$1;
(statearr_60540_60591[(2)] = inst_60410);

(statearr_60540_60591[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (26))){
var inst_60385 = (state_60493[(18)]);
var inst_60446 = cljs.core.set.call(null,inst_60385);
var state_60493__$1 = state_60493;
var statearr_60541_60592 = state_60493__$1;
(statearr_60541_60592[(2)] = inst_60446);

(statearr_60541_60592[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (16))){
var inst_60413 = (state_60493[(2)]);
var state_60493__$1 = state_60493;
if(cljs.core.truth_(inst_60413)){
var statearr_60542_60593 = state_60493__$1;
(statearr_60542_60593[(1)] = (17));

} else {
var statearr_60543_60594 = state_60493__$1;
(statearr_60543_60594[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (38))){
var inst_60408 = (state_60493[(23)]);
var inst_60470 = (state_60493[(2)]);
var state_60493__$1 = (function (){var statearr_60544 = state_60493;
(statearr_60544[(13)] = inst_60470);

return statearr_60544;
})();
if(cljs.core.truth_(inst_60408)){
var statearr_60545_60595 = state_60493__$1;
(statearr_60545_60595[(1)] = (40));

} else {
var statearr_60546_60596 = state_60493__$1;
(statearr_60546_60596[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (30))){
var inst_60384 = (state_60493[(17)]);
var state_60493__$1 = state_60493;
var statearr_60547_60597 = state_60493__$1;
(statearr_60547_60597[(2)] = inst_60384);

(statearr_60547_60597[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (10))){
var inst_60393 = (state_60493[(2)]);
var inst_60394 = fluree.db.util.async.throw_err.call(null,inst_60393);
var state_60493__$1 = state_60493;
var statearr_60548_60598 = state_60493__$1;
(statearr_60548_60598[(2)] = inst_60394);

(statearr_60548_60598[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (18))){
var state_60493__$1 = state_60493;
var statearr_60549_60599 = state_60493__$1;
(statearr_60549_60599[(2)] = (-1));

(statearr_60549_60599[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (42))){
var inst_60478 = (state_60493[(2)]);
var state_60493__$1 = state_60493;
var statearr_60550_60600 = state_60493__$1;
(statearr_60550_60600[(2)] = inst_60478);

(statearr_60550_60600[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (37))){
var inst_60457 = (state_60493[(15)]);
var inst_60468 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_60457);
var state_60493__$1 = state_60493;
var statearr_60551_60601 = state_60493__$1;
(statearr_60551_60601[(2)] = inst_60468);

(statearr_60551_60601[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60494 === (8))){
var state_60493__$1 = state_60493;
var statearr_60552_60602 = state_60493__$1;
(statearr_60552_60602[(2)] = null);

(statearr_60552_60602[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2741__auto____0 = (function (){
var statearr_60553 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60553[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2741__auto__);

(statearr_60553[(1)] = (1));

return statearr_60553;
});
var fluree$db$api$query$history_query_async_$_state_machine__2741__auto____1 = (function (state_60493){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_60493);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e60554){var ex__2744__auto__ = e60554;
var statearr_60555_60603 = state_60493;
(statearr_60555_60603[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_60493[(4)]))){
var statearr_60556_60604 = state_60493;
(statearr_60556_60604[(1)] = cljs.core.first.call(null,(state_60493[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60605 = state_60493;
state_60493 = G__60605;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2741__auto__ = function(state_60493){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2741__auto____1.call(this,state_60493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2741__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2741__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_60557 = f__2764__auto__.call(null);
(statearr_60557[(6)] = c__2763__auto__);

return statearr_60557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_60738){
var state_val_60739 = (state_60738[(1)]);
if((state_val_60739 === (7))){
var inst_60635 = cljs.core.pr_str.call(null,flureeQL);
var inst_60636 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_60635].join('');
var inst_60637 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60638 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60639 = cljs.core.PersistentHashMap.fromArrays(inst_60637,inst_60638);
var inst_60640 = cljs.core.ex_info.call(null,inst_60636,inst_60639);
var inst_60641 = (function(){throw inst_60640})();
var state_60738__$1 = state_60738;
var statearr_60740_60819 = state_60738__$1;
(statearr_60740_60819[(2)] = inst_60641);

(statearr_60740_60819[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (20))){
var inst_60673 = (state_60738[(2)]);
var state_60738__$1 = state_60738;
if(cljs.core.truth_(inst_60673)){
var statearr_60741_60820 = state_60738__$1;
(statearr_60741_60820[(1)] = (21));

} else {
var statearr_60742_60821 = state_60738__$1;
(statearr_60742_60821[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (27))){
var inst_60617 = (state_60738[(7)]);
var state_60738__$1 = state_60738;
var statearr_60743_60822 = state_60738__$1;
(statearr_60743_60822[(2)] = inst_60617);

(statearr_60743_60822[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (1))){
var state_60738__$1 = state_60738;
var statearr_60744_60823 = state_60738__$1;
(statearr_60744_60823[(2)] = null);

(statearr_60744_60823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (24))){
var inst_60679 = (state_60738[(8)]);
var state_60738__$1 = state_60738;
var statearr_60745_60824 = state_60738__$1;
(statearr_60745_60824[(2)] = inst_60679);

(statearr_60745_60824[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (39))){
var inst_60623 = (state_60738[(9)]);
var state_60738__$1 = state_60738;
if(cljs.core.truth_(inst_60623)){
var statearr_60746_60825 = state_60738__$1;
(statearr_60746_60825[(1)] = (42));

} else {
var statearr_60747_60826 = state_60738__$1;
(statearr_60747_60826[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (46))){
var inst_60711 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60712 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60713 = cljs.core.PersistentHashMap.fromArrays(inst_60711,inst_60712);
var inst_60714 = cljs.core.ex_info.call(null,"Invalid query.",inst_60713);
var inst_60715 = (function(){throw inst_60714})();
var state_60738__$1 = state_60738;
var statearr_60748_60827 = state_60738__$1;
(statearr_60748_60827[(2)] = inst_60715);

(statearr_60748_60827[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (4))){
var inst_60607 = (state_60738[(2)]);
var state_60738__$1 = state_60738;
var statearr_60749_60828 = state_60738__$1;
(statearr_60749_60828[(2)] = inst_60607);

(statearr_60749_60828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (15))){
var inst_60658 = (state_60738[(10)]);
var inst_60620 = (state_60738[(11)]);
var inst_60660 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_60658);
var inst_60661 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_60658);
var inst_60662 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_60658);
var inst_60663 = fluree.db.api.query.get_sources.call(null,inst_60660,inst_60661,inst_60662,inst_60620);
var state_60738__$1 = state_60738;
var statearr_60750_60829 = state_60738__$1;
(statearr_60750_60829[(2)] = inst_60663);

(statearr_60750_60829[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (48))){
var inst_60668 = (state_60738[(12)]);
var inst_60722 = (state_60738[(2)]);
var inst_60723 = fluree.db.util.async.throw_err.call(null,inst_60722);
var state_60738__$1 = (function (){var statearr_60751 = state_60738;
(statearr_60751[(13)] = inst_60723);

return statearr_60751;
})();
if(cljs.core.truth_(inst_60668)){
var statearr_60752_60830 = state_60738__$1;
(statearr_60752_60830[(1)] = (49));

} else {
var statearr_60753_60831 = state_60738__$1;
(statearr_60753_60831[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (50))){
var inst_60723 = (state_60738[(13)]);
var state_60738__$1 = state_60738;
var statearr_60754_60832 = state_60738__$1;
(statearr_60754_60832[(2)] = inst_60723);

(statearr_60754_60832[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (21))){
var inst_60675 = cljs.core.volatile_BANG_.call(null,(0));
var state_60738__$1 = state_60738;
var statearr_60755_60833 = state_60738__$1;
(statearr_60755_60833[(2)] = inst_60675);

(statearr_60755_60833[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (31))){
var inst_60621 = (state_60738[(14)]);
var state_60738__$1 = state_60738;
if(cljs.core.truth_(inst_60621)){
var statearr_60756_60834 = state_60738__$1;
(statearr_60756_60834[(1)] = (33));

} else {
var statearr_60757_60835 = state_60738__$1;
(statearr_60757_60835[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (32))){
var inst_60698 = (state_60738[(2)]);
var state_60738__$1 = state_60738;
var statearr_60758_60836 = state_60738__$1;
(statearr_60758_60836[(2)] = inst_60698);

(statearr_60758_60836[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (40))){
var inst_60700 = (state_60738[(15)]);
var state_60738__$1 = state_60738;
var statearr_60759_60837 = state_60738__$1;
(statearr_60759_60837[(2)] = inst_60700);

(statearr_60759_60837[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (33))){
var inst_60621 = (state_60738[(14)]);
var state_60738__$1 = state_60738;
var statearr_60760_60838 = state_60738__$1;
(statearr_60760_60838[(2)] = inst_60621);

(statearr_60760_60838[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (13))){
var inst_60618 = (state_60738[(16)]);
var inst_60647 = (state_60738[(2)]);
var inst_60648 = fluree.db.util.async.throw_err.call(null,inst_60647);
var inst_60649 = fluree.db.time_travel.as_of_block.call(null,inst_60648,inst_60618);
var state_60738__$1 = state_60738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60738__$1,(12),inst_60649);
} else {
if((state_val_60739 === (22))){
var state_60738__$1 = state_60738;
var statearr_60761_60839 = state_60738__$1;
(statearr_60761_60839[(2)] = null);

(statearr_60761_60839[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (36))){
var inst_60625 = (state_60738[(17)]);
var state_60738__$1 = state_60738;
var statearr_60762_60840 = state_60738__$1;
(statearr_60762_60840[(2)] = inst_60625);

(statearr_60762_60840[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (41))){
var inst_60708 = (state_60738[(2)]);
var state_60738__$1 = state_60738;
if(cljs.core.truth_(inst_60708)){
var statearr_60763_60841 = state_60738__$1;
(statearr_60763_60841[(1)] = (45));

} else {
var statearr_60764_60842 = state_60738__$1;
(statearr_60764_60842[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (43))){
var inst_60619 = (state_60738[(18)]);
var state_60738__$1 = state_60738;
var statearr_60765_60843 = state_60738__$1;
(statearr_60765_60843[(2)] = inst_60619);

(statearr_60765_60843[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (29))){
var inst_60700 = (state_60738[(15)]);
var inst_60700__$1 = (state_60738[(2)]);
var state_60738__$1 = (function (){var statearr_60766 = state_60738;
(statearr_60766[(15)] = inst_60700__$1);

return statearr_60766;
})();
if(cljs.core.truth_(inst_60700__$1)){
var statearr_60767_60844 = state_60738__$1;
(statearr_60767_60844[(1)] = (39));

} else {
var statearr_60768_60845 = state_60738__$1;
(statearr_60768_60845[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (44))){
var inst_60705 = (state_60738[(2)]);
var state_60738__$1 = state_60738;
var statearr_60769_60846 = state_60738__$1;
(statearr_60769_60846[(2)] = inst_60705);

(statearr_60769_60846[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (6))){
var state_60738__$1 = state_60738;
var statearr_60770_60847 = state_60738__$1;
(statearr_60770_60847[(2)] = null);

(statearr_60770_60847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (28))){
var inst_60622 = (state_60738[(19)]);
var state_60738__$1 = state_60738;
if(cljs.core.truth_(inst_60622)){
var statearr_60771_60848 = state_60738__$1;
(statearr_60771_60848[(1)] = (30));

} else {
var statearr_60772_60849 = state_60738__$1;
(statearr_60772_60849[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (51))){
var inst_60733 = (state_60738[(2)]);
var _ = (function (){var statearr_60773 = state_60738;
(statearr_60773[(4)] = cljs.core.rest.call(null,(state_60738[(4)])));

return statearr_60773;
})();
var state_60738__$1 = state_60738;
var statearr_60774_60850 = state_60738__$1;
(statearr_60774_60850[(2)] = inst_60733);

(statearr_60774_60850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (25))){
var state_60738__$1 = state_60738;
var statearr_60775_60851 = state_60738__$1;
(statearr_60775_60851[(2)] = (1000000));

(statearr_60775_60851[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (34))){
var inst_60625 = (state_60738[(17)]);
var state_60738__$1 = state_60738;
if(cljs.core.truth_(inst_60625)){
var statearr_60776_60852 = state_60738__$1;
(statearr_60776_60852[(1)] = (36));

} else {
var statearr_60777_60853 = state_60738__$1;
(statearr_60777_60853[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (17))){
var inst_60624 = (state_60738[(20)]);
var inst_60669 = (state_60738[(21)]);
var inst_60667 = (state_60738[(2)]);
var inst_60668 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60624);
var inst_60669__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_60624);
var state_60738__$1 = (function (){var statearr_60778 = state_60738;
(statearr_60778[(22)] = inst_60667);

(statearr_60778[(21)] = inst_60669__$1);

(statearr_60778[(12)] = inst_60668);

return statearr_60778;
})();
if(cljs.core.truth_(inst_60669__$1)){
var statearr_60779_60854 = state_60738__$1;
(statearr_60779_60854[(1)] = (18));

} else {
var statearr_60780_60855 = state_60738__$1;
(statearr_60780_60855[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (3))){
var inst_60736 = (state_60738[(2)]);
var state_60738__$1 = state_60738;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60738__$1,inst_60736);
} else {
if((state_val_60739 === (12))){
var inst_60651 = (state_60738[(2)]);
var inst_60652 = fluree.db.util.async.throw_err.call(null,inst_60651);
var state_60738__$1 = state_60738;
var statearr_60781_60856 = state_60738__$1;
(statearr_60781_60856[(2)] = inst_60652);

(statearr_60781_60856[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (2))){
var inst_60624 = (state_60738[(20)]);
var inst_60616 = (state_60738[(23)]);
var inst_60617 = (state_60738[(7)]);
var inst_60621 = (state_60738[(14)]);
var inst_60625 = (state_60738[(17)]);
var inst_60620 = (state_60738[(11)]);
var inst_60623 = (state_60738[(9)]);
var inst_60619 = (state_60738[(18)]);
var inst_60618 = (state_60738[(16)]);
var inst_60622 = (state_60738[(19)]);
var _ = (function (){var statearr_60782 = state_60738;
(statearr_60782[(4)] = cljs.core.cons.call(null,(5),(state_60738[(4)])));

return statearr_60782;
})();
var inst_60614 = flureeQL;
var inst_60615 = cljs.core.__destructure_map.call(null,inst_60614);
var inst_60616__$1 = cljs.core.get.call(null,inst_60615,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_60617__$1 = cljs.core.get.call(null,inst_60615,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_60618__$1 = cljs.core.get.call(null,inst_60615,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60619__$1 = cljs.core.get.call(null,inst_60615,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_60620__$1 = cljs.core.get.call(null,inst_60615,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_60621__$1 = cljs.core.get.call(null,inst_60615,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_60622__$1 = cljs.core.get.call(null,inst_60615,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_60623__$1 = cljs.core.get.call(null,inst_60615,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_60624__$1 = cljs.core.get.call(null,inst_60615,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60625__$1 = cljs.core.get.call(null,inst_60615,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_60626 = (function (){var construct = inst_60616__$1;
var select = inst_60617__$1;
var map__60613 = inst_60615;
var block = inst_60618__$1;
var where = inst_60619__$1;
var prefixes = inst_60620__$1;
var selectDistinct = inst_60621__$1;
var selectOne = inst_60622__$1;
var from = inst_60623__$1;
var opts = inst_60624__$1;
var selectReduced = inst_60625__$1;
return (function (p1__60606_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__60606_SHARP_);
});
})();
var inst_60627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60628 = [inst_60617__$1,inst_60622__$1,inst_60621__$1,inst_60625__$1];
var inst_60629 = (new cljs.core.PersistentVector(null,4,(5),inst_60627,inst_60628,null));
var inst_60630 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_60629);
var inst_60631 = cljs.core.count.call(null,inst_60630);
var inst_60632 = inst_60626.call(null,inst_60631);
var state_60738__$1 = (function (){var statearr_60783 = state_60738;
(statearr_60783[(20)] = inst_60624__$1);

(statearr_60783[(23)] = inst_60616__$1);

(statearr_60783[(7)] = inst_60617__$1);

(statearr_60783[(14)] = inst_60621__$1);

(statearr_60783[(17)] = inst_60625__$1);

(statearr_60783[(11)] = inst_60620__$1);

(statearr_60783[(9)] = inst_60623__$1);

(statearr_60783[(18)] = inst_60619__$1);

(statearr_60783[(16)] = inst_60618__$1);

(statearr_60783[(19)] = inst_60622__$1);

return statearr_60783;
})();
if(cljs.core.truth_(inst_60632)){
var statearr_60784_60857 = state_60738__$1;
(statearr_60784_60857[(1)] = (6));

} else {
var statearr_60785_60858 = state_60738__$1;
(statearr_60785_60858[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (23))){
var inst_60679 = (state_60738[(8)]);
var inst_60624 = (state_60738[(20)]);
var inst_60678 = (state_60738[(2)]);
var inst_60679__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_60624);
var state_60738__$1 = (function (){var statearr_60786 = state_60738;
(statearr_60786[(8)] = inst_60679__$1);

(statearr_60786[(24)] = inst_60678);

return statearr_60786;
})();
if(cljs.core.truth_(inst_60679__$1)){
var statearr_60787_60859 = state_60738__$1;
(statearr_60787_60859[(1)] = (24));

} else {
var statearr_60788_60860 = state_60738__$1;
(statearr_60788_60860[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (47))){
var inst_60684 = (state_60738[(25)]);
var inst_60658 = (state_60738[(10)]);
var inst_60717 = (state_60738[(2)]);
var inst_60718 = fluree.db.util.core.current_time_millis.call(null);
var inst_60719 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_60684);
var inst_60720 = fluree.db.query.fql.query.call(null,inst_60658,inst_60719);
var state_60738__$1 = (function (){var statearr_60789 = state_60738;
(statearr_60789[(26)] = inst_60717);

(statearr_60789[(27)] = inst_60718);

return statearr_60789;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60738__$1,(48),inst_60720);
} else {
if((state_val_60739 === (35))){
var inst_60696 = (state_60738[(2)]);
var state_60738__$1 = state_60738;
var statearr_60790_60861 = state_60738__$1;
(statearr_60790_60861[(2)] = inst_60696);

(statearr_60790_60861[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (19))){
var inst_60668 = (state_60738[(12)]);
var state_60738__$1 = state_60738;
var statearr_60791_60862 = state_60738__$1;
(statearr_60791_60862[(2)] = inst_60668);

(statearr_60791_60862[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (11))){
var inst_60620 = (state_60738[(11)]);
var inst_60658 = (state_60738[(2)]);
var state_60738__$1 = (function (){var statearr_60793 = state_60738;
(statearr_60793[(10)] = inst_60658);

return statearr_60793;
})();
if(cljs.core.truth_(inst_60620)){
var statearr_60794_60863 = state_60738__$1;
(statearr_60794_60863[(1)] = (15));

} else {
var statearr_60795_60864 = state_60738__$1;
(statearr_60795_60864[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (9))){
var inst_60644 = (state_60738[(28)]);
var state_60738__$1 = state_60738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60738__$1,(13),inst_60644);
} else {
if((state_val_60739 === (5))){
var _ = (function (){var statearr_60796 = state_60738;
(statearr_60796[(4)] = cljs.core.rest.call(null,(state_60738[(4)])));

return statearr_60796;
})();
var state_60738__$1 = state_60738;
var ex60792 = (state_60738__$1[(2)]);
var statearr_60797_60865 = state_60738__$1;
(statearr_60797_60865[(5)] = ex60792);


if((ex60792 instanceof Error)){
var statearr_60798_60866 = state_60738__$1;
(statearr_60798_60866[(1)] = (4));

(statearr_60798_60866[(5)] = null);

} else {
throw ex60792;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (14))){
var inst_60655 = (state_60738[(2)]);
var inst_60656 = fluree.db.util.async.throw_err.call(null,inst_60655);
var state_60738__$1 = state_60738;
var statearr_60799_60867 = state_60738__$1;
(statearr_60799_60867[(2)] = inst_60656);

(statearr_60799_60867[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (45))){
var state_60738__$1 = state_60738;
var statearr_60800_60868 = state_60738__$1;
(statearr_60800_60868[(2)] = null);

(statearr_60800_60868[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (26))){
var inst_60624 = (state_60738[(20)]);
var inst_60667 = (state_60738[(22)]);
var inst_60617 = (state_60738[(7)]);
var inst_60678 = (state_60738[(24)]);
var inst_60683 = (state_60738[(2)]);
var inst_60684 = cljs.core.assoc.call(null,inst_60624,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_60667,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_60683,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_60678);
var state_60738__$1 = (function (){var statearr_60801 = state_60738;
(statearr_60801[(25)] = inst_60684);

return statearr_60801;
})();
if(cljs.core.truth_(inst_60617)){
var statearr_60802_60869 = state_60738__$1;
(statearr_60802_60869[(1)] = (27));

} else {
var statearr_60803_60870 = state_60738__$1;
(statearr_60803_60870[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (16))){
var inst_60665 = cljs.core.PersistentHashMap.EMPTY;
var state_60738__$1 = state_60738;
var statearr_60804_60871 = state_60738__$1;
(statearr_60804_60871[(2)] = inst_60665);

(statearr_60804_60871[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (38))){
var inst_60694 = (state_60738[(2)]);
var state_60738__$1 = state_60738;
var statearr_60805_60872 = state_60738__$1;
(statearr_60805_60872[(2)] = inst_60694);

(statearr_60805_60872[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (30))){
var inst_60622 = (state_60738[(19)]);
var state_60738__$1 = state_60738;
var statearr_60806_60873 = state_60738__$1;
(statearr_60806_60873[(2)] = inst_60622);

(statearr_60806_60873[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (10))){
var inst_60644 = (state_60738[(28)]);
var state_60738__$1 = state_60738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60738__$1,(14),inst_60644);
} else {
if((state_val_60739 === (18))){
var inst_60669 = (state_60738[(21)]);
var state_60738__$1 = state_60738;
var statearr_60807_60874 = state_60738__$1;
(statearr_60807_60874[(2)] = inst_60669);

(statearr_60807_60874[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (42))){
var inst_60623 = (state_60738[(9)]);
var state_60738__$1 = state_60738;
var statearr_60808_60875 = state_60738__$1;
(statearr_60808_60875[(2)] = inst_60623);

(statearr_60808_60875[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (37))){
var inst_60616 = (state_60738[(23)]);
var state_60738__$1 = state_60738;
var statearr_60809_60876 = state_60738__$1;
(statearr_60809_60876[(2)] = inst_60616);

(statearr_60809_60876[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (8))){
var inst_60618 = (state_60738[(16)]);
var inst_60643 = (state_60738[(2)]);
var inst_60644 = sources;
var state_60738__$1 = (function (){var statearr_60810 = state_60738;
(statearr_60810[(28)] = inst_60644);

(statearr_60810[(29)] = inst_60643);

return statearr_60810;
})();
if(cljs.core.truth_(inst_60618)){
var statearr_60811_60877 = state_60738__$1;
(statearr_60811_60877[(1)] = (9));

} else {
var statearr_60812_60878 = state_60738__$1;
(statearr_60812_60878[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60739 === (49))){
var inst_60723 = (state_60738[(13)]);
var inst_60678 = (state_60738[(24)]);
var inst_60658 = (state_60738[(10)]);
var inst_60718 = (state_60738[(27)]);
var inst_60725 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60726 = cljs.core.deref.call(null,inst_60678);
var inst_60727 = fluree.db.util.core.response_time_formatted.call(null,inst_60718);
var inst_60728 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_60658);
var inst_60729 = [(200),inst_60723,inst_60726,inst_60727,inst_60728];
var inst_60730 = cljs.core.PersistentHashMap.fromArrays(inst_60725,inst_60729);
var state_60738__$1 = state_60738;
var statearr_60813_60879 = state_60738__$1;
(statearr_60813_60879[(2)] = inst_60730);

(statearr_60813_60879[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2741__auto____0 = (function (){
var statearr_60814 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60814[(0)] = fluree$db$api$query$query_async_$_state_machine__2741__auto__);

(statearr_60814[(1)] = (1));

return statearr_60814;
});
var fluree$db$api$query$query_async_$_state_machine__2741__auto____1 = (function (state_60738){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_60738);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e60815){var ex__2744__auto__ = e60815;
var statearr_60816_60880 = state_60738;
(statearr_60816_60880[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_60738[(4)]))){
var statearr_60817_60881 = state_60738;
(statearr_60817_60881[(1)] = cljs.core.first.call(null,(state_60738[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60882 = state_60738;
state_60738 = G__60882;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2741__auto__ = function(state_60738){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2741__auto____1.call(this,state_60738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2741__auto____0;
fluree$db$api$query$query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2741__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_60818 = f__2764__auto__.call(null);
(statearr_60818[(6)] = c__2763__auto__);

return statearr_60818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61023){
var state_val_61024 = (state_61023[(1)]);
if((state_val_61024 === (7))){
var inst_61018 = (state_61023[(2)]);
var _ = (function (){var statearr_61025 = state_61023;
(statearr_61025[(4)] = cljs.core.rest.call(null,(state_61023[(4)])));

return statearr_61025;
})();
var state_61023__$1 = state_61023;
var statearr_61026_61102 = state_61023__$1;
(statearr_61026_61102[(2)] = inst_61018);

(statearr_61026_61102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (20))){
var inst_60990 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
var statearr_61027_61103 = state_61023__$1;
(statearr_61027_61103[(2)] = inst_60990);

(statearr_61027_61103[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (27))){
var inst_60970 = (state_61023[(7)]);
var state_61023__$1 = state_61023;
var statearr_61028_61104 = state_61023__$1;
(statearr_61028_61104[(2)] = inst_60970);

(statearr_61028_61104[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (1))){
var state_61023__$1 = state_61023;
var statearr_61029_61105 = state_61023__$1;
(statearr_61029_61105[(2)] = null);

(statearr_61029_61105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (24))){
var inst_60967 = (state_61023[(8)]);
var state_61023__$1 = state_61023;
var statearr_61030_61106 = state_61023__$1;
(statearr_61030_61106[(2)] = inst_60967);

(statearr_61030_61106[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (39))){
var inst_60935 = (state_61023[(9)]);
var inst_60924 = (state_61023[(10)]);
var inst_60957 = (state_61023[(11)]);
var inst_61001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61002 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_60935];
var inst_61003 = (new cljs.core.PersistentVector(null,2,(5),inst_61001,inst_61002,null));
var inst_61004 = cljs.core.assoc_in.call(null,inst_60924,inst_61003,inst_60957);
var state_61023__$1 = state_61023;
var statearr_61031_61107 = state_61023__$1;
(statearr_61031_61107[(2)] = inst_61004);

(statearr_61031_61107[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (4))){
var inst_60883 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
var statearr_61032_61108 = state_61023__$1;
(statearr_61032_61108[(2)] = inst_60883);

(statearr_61032_61108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (15))){
var inst_60922 = (state_61023[(12)]);
var inst_60957 = (state_61023[(11)]);
var inst_60960 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_60957);
var inst_60961 = (inst_60922 == null);
var state_61023__$1 = (function (){var statearr_61033 = state_61023;
(statearr_61033[(13)] = inst_60960);

return statearr_61033;
})();
if(cljs.core.truth_(inst_60961)){
var statearr_61034_61109 = state_61023__$1;
(statearr_61034_61109[(1)] = (18));

} else {
var statearr_61035_61110 = state_61023__$1;
(statearr_61035_61110[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (21))){
var inst_60960 = (state_61023[(13)]);
var state_61023__$1 = state_61023;
var statearr_61036_61111 = state_61023__$1;
(statearr_61036_61111[(2)] = inst_60960);

(statearr_61036_61111[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (31))){
var state_61023__$1 = state_61023;
var statearr_61037_61112 = state_61023__$1;
(statearr_61037_61112[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (32))){
var inst_60986 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
var statearr_61039_61113 = state_61023__$1;
(statearr_61039_61113[(2)] = inst_60986);

(statearr_61039_61113[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (40))){
var inst_60955 = (state_61023[(14)]);
var state_61023__$1 = state_61023;
if(cljs.core.truth_(inst_60955)){
var statearr_61040_61114 = state_61023__$1;
(statearr_61040_61114[(1)] = (42));

} else {
var statearr_61041_61115 = state_61023__$1;
(statearr_61041_61115[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (33))){
var inst_60960 = (state_61023[(13)]);
var inst_60922 = (state_61023[(12)]);
var inst_60981 = ((inst_60960 > inst_60922) ? inst_60960 : inst_60922);
var state_61023__$1 = state_61023;
var statearr_61042_61116 = state_61023__$1;
(statearr_61042_61116[(2)] = inst_60981);

(statearr_61042_61116[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (13))){
var inst_60946 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
var statearr_61043_61117 = state_61023__$1;
(statearr_61043_61117[(2)] = inst_60946);

(statearr_61043_61117[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (22))){
var inst_60960 = (state_61023[(13)]);
var inst_60967 = (state_61023[(8)]);
var inst_60967__$1 = cljs.core._EQ_.call(null,(200),inst_60960);
var state_61023__$1 = (function (){var statearr_61044 = state_61023;
(statearr_61044[(8)] = inst_60967__$1);

return statearr_61044;
})();
if(inst_60967__$1){
var statearr_61045_61118 = state_61023__$1;
(statearr_61045_61118[(1)] = (24));

} else {
var statearr_61046_61119 = state_61023__$1;
(statearr_61046_61119[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (36))){
var inst_60923 = (state_61023[(15)]);
var inst_60957 = (state_61023[(11)]);
var inst_60995 = cljs.core.get.call(null,inst_60957,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_60996 = (inst_60923 + inst_60995);
var state_61023__$1 = state_61023;
var statearr_61047_61120 = state_61023__$1;
(statearr_61047_61120[(2)] = inst_60996);

(statearr_61047_61120[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (41))){
var inst_60999 = (state_61023[(16)]);
var inst_60993 = (state_61023[(17)]);
var inst_60934 = (state_61023[(18)]);
var inst_61013 = (state_61023[(2)]);
var inst_60921 = inst_60934;
var inst_60922 = inst_60993;
var inst_60923 = inst_60999;
var inst_60924 = inst_61013;
var state_61023__$1 = (function (){var statearr_61048 = state_61023;
(statearr_61048[(15)] = inst_60923);

(statearr_61048[(10)] = inst_60924);

(statearr_61048[(19)] = inst_60921);

(statearr_61048[(12)] = inst_60922);

return statearr_61048;
})();
var statearr_61049_61121 = state_61023__$1;
(statearr_61049_61121[(2)] = null);

(statearr_61049_61121[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (43))){
var inst_60957 = (state_61023[(11)]);
var state_61023__$1 = state_61023;
var statearr_61050_61122 = state_61023__$1;
(statearr_61050_61122[(2)] = inst_60957);

(statearr_61050_61122[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (29))){
var inst_60975 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
var statearr_61051_61123 = state_61023__$1;
(statearr_61051_61123[(2)] = inst_60975);

(statearr_61051_61123[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (44))){
var inst_60935 = (state_61023[(9)]);
var inst_60924 = (state_61023[(10)]);
var inst_61010 = (state_61023[(2)]);
var inst_61011 = cljs.core.assoc.call(null,inst_60924,inst_60935,inst_61010);
var state_61023__$1 = state_61023;
var statearr_61052_61124 = state_61023__$1;
(statearr_61052_61124[(2)] = inst_61011);

(statearr_61052_61124[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (6))){
var inst_60936 = (state_61023[(20)]);
var inst_60921 = (state_61023[(19)]);
var inst_60932 = cljs.core.seq.call(null,inst_60921);
var inst_60933 = cljs.core.first.call(null,inst_60932);
var inst_60934 = cljs.core.next.call(null,inst_60932);
var inst_60935 = cljs.core.nth.call(null,inst_60933,(0),null);
var inst_60936__$1 = cljs.core.nth.call(null,inst_60933,(1),null);
var inst_60937 = (inst_60936__$1 == null);
var state_61023__$1 = (function (){var statearr_61053 = state_61023;
(statearr_61053[(9)] = inst_60935);

(statearr_61053[(20)] = inst_60936__$1);

(statearr_61053[(18)] = inst_60934);

return statearr_61053;
})();
if(cljs.core.truth_(inst_60937)){
var statearr_61054_61125 = state_61023__$1;
(statearr_61054_61125[(1)] = (8));

} else {
var statearr_61055_61126 = state_61023__$1;
(statearr_61055_61126[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (28))){
var inst_60922 = (state_61023[(12)]);
var inst_60973 = cljs.core._EQ_.call(null,(207),inst_60922);
var state_61023__$1 = state_61023;
var statearr_61056_61127 = state_61023__$1;
(statearr_61056_61127[(2)] = inst_60973);

(statearr_61056_61127[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (25))){
var inst_60970 = (state_61023[(7)]);
var inst_60922 = (state_61023[(12)]);
var inst_60970__$1 = cljs.core._EQ_.call(null,(200),inst_60922);
var state_61023__$1 = (function (){var statearr_61057 = state_61023;
(statearr_61057[(7)] = inst_60970__$1);

return statearr_61057;
})();
if(inst_60970__$1){
var statearr_61058_61128 = state_61023__$1;
(statearr_61058_61128[(1)] = (27));

} else {
var statearr_61059_61129 = state_61023__$1;
(statearr_61059_61129[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (34))){
var state_61023__$1 = state_61023;
var statearr_61060_61130 = state_61023__$1;
(statearr_61060_61130[(2)] = null);

(statearr_61060_61130[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (17))){
var inst_60954 = (state_61023[(21)]);
var inst_60993 = (state_61023[(2)]);
var state_61023__$1 = (function (){var statearr_61061 = state_61023;
(statearr_61061[(17)] = inst_60993);

return statearr_61061;
})();
if(cljs.core.truth_(inst_60954)){
var statearr_61062_61131 = state_61023__$1;
(statearr_61062_61131[(1)] = (36));

} else {
var statearr_61063_61132 = state_61023__$1;
(statearr_61063_61132[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (3))){
var inst_61021 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61023__$1,inst_61021);
} else {
if((state_val_61024 === (12))){
var inst_60924 = (state_61023[(10)]);
var state_61023__$1 = state_61023;
var statearr_61064_61133 = state_61023__$1;
(statearr_61064_61133[(2)] = inst_60924);

(statearr_61064_61133[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (2))){
var inst_60897 = (state_61023[(22)]);
var inst_60893 = (state_61023[(23)]);
var inst_60898 = (state_61023[(24)]);
var _ = (function (){var statearr_61065 = state_61023;
(statearr_61065[(4)] = cljs.core.cons.call(null,(5),(state_61023[(4)])));

return statearr_61065;
})();
var inst_60889 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_60890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60891 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_60892 = (new cljs.core.PersistentVector(null,2,(5),inst_60890,inst_60891,null));
var inst_60893__$1 = cljs.core.get_in.call(null,flureeQL,inst_60892);
var inst_60894 = (function (){var global_block = inst_60889;
var global_meta_QMARK_ = inst_60893__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4253__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4251__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__4251__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_60895 = cljs.core.PersistentHashMap.EMPTY;
var inst_60896 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_60897__$1 = cljs.core.reduce_kv.call(null,inst_60894,inst_60895,inst_60896);
var inst_60898__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_60900 = (function (){var global_block = inst_60889;
var global_meta_QMARK_ = inst_60893__$1;
var queries = inst_60897__$1;
var start_time = inst_60898__$1;
return (function (p__60899){
var vec__61066 = p__60899;
var alias = cljs.core.nth.call(null,vec__61066,(0),null);
var q = cljs.core.nth.call(null,vec__61066,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_60901 = cljs.core.map.call(null,inst_60900,inst_60897__$1);
var inst_60915 = cljs.core.seq.call(null,inst_60901);
var inst_60916 = cljs.core.first.call(null,inst_60915);
var inst_60917 = cljs.core.next.call(null,inst_60915);
var inst_60918 = cljs.core.nth.call(null,inst_60916,(0),null);
var inst_60919 = cljs.core.nth.call(null,inst_60916,(1),null);
var inst_60920 = cljs.core.PersistentHashMap.EMPTY;
var inst_60921 = inst_60901;
var inst_60922 = null;
var inst_60923 = (0);
var inst_60924 = inst_60920;
var state_61023__$1 = (function (){var statearr_61069 = state_61023;
(statearr_61069[(22)] = inst_60897__$1);

(statearr_61069[(15)] = inst_60923);

(statearr_61069[(10)] = inst_60924);

(statearr_61069[(19)] = inst_60921);

(statearr_61069[(23)] = inst_60893__$1);

(statearr_61069[(12)] = inst_60922);

(statearr_61069[(25)] = inst_60919);

(statearr_61069[(26)] = inst_60918);

(statearr_61069[(24)] = inst_60898__$1);

(statearr_61069[(27)] = inst_60917);

return statearr_61069;
})();
var statearr_61070_61134 = state_61023__$1;
(statearr_61070_61134[(2)] = null);

(statearr_61070_61134[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (23))){
var inst_60988 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
var statearr_61071_61135 = state_61023__$1;
(statearr_61071_61135[(2)] = inst_60988);

(statearr_61071_61135[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (35))){
var inst_60984 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
var statearr_61072_61136 = state_61023__$1;
(statearr_61072_61136[(2)] = inst_60984);

(statearr_61072_61136[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (19))){
var inst_60960 = (state_61023[(13)]);
var inst_60922 = (state_61023[(12)]);
var inst_60964 = cljs.core._EQ_.call(null,inst_60922,inst_60960);
var state_61023__$1 = state_61023;
if(inst_60964){
var statearr_61073_61137 = state_61023__$1;
(statearr_61073_61137[(1)] = (21));

} else {
var statearr_61074_61138 = state_61023__$1;
(statearr_61074_61138[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (11))){
var inst_60923 = (state_61023[(15)]);
var inst_60924 = (state_61023[(10)]);
var inst_60922 = (state_61023[(12)]);
var inst_60898 = (state_61023[(24)]);
var inst_60940 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_60941 = fluree.db.util.core.response_time_formatted.call(null,inst_60898);
var inst_60942 = [inst_60924,inst_60923,inst_60922,inst_60941];
var inst_60943 = cljs.core.PersistentHashMap.fromArrays(inst_60940,inst_60942);
var state_61023__$1 = state_61023;
var statearr_61076_61139 = state_61023__$1;
(statearr_61076_61139[(2)] = inst_60943);

(statearr_61076_61139[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (9))){
var inst_60935 = (state_61023[(9)]);
var inst_60936 = (state_61023[(20)]);
var inst_60897 = (state_61023[(22)]);
var inst_60949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60950 = [inst_60935,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_60951 = (new cljs.core.PersistentVector(null,2,(5),inst_60949,inst_60950,null));
var inst_60952 = cljs.core.get_in.call(null,inst_60897,inst_60951);
var inst_60953 = cljs.core.__destructure_map.call(null,inst_60952);
var inst_60954 = cljs.core.get.call(null,inst_60953,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_60955 = cljs.core.get.call(null,inst_60953,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_61023__$1 = (function (){var statearr_61077 = state_61023;
(statearr_61077[(14)] = inst_60955);

(statearr_61077[(21)] = inst_60954);

return statearr_61077;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61023__$1,(14),inst_60936);
} else {
if((state_val_61024 === (5))){
var _ = (function (){var statearr_61078 = state_61023;
(statearr_61078[(4)] = cljs.core.rest.call(null,(state_61023[(4)])));

return statearr_61078;
})();
var state_61023__$1 = state_61023;
var ex61075 = (state_61023__$1[(2)]);
var statearr_61079_61140 = state_61023__$1;
(statearr_61079_61140[(5)] = ex61075);


var statearr_61080_61141 = state_61023__$1;
(statearr_61080_61141[(1)] = (4));

(statearr_61080_61141[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (14))){
var inst_60954 = (state_61023[(21)]);
var inst_60957 = (state_61023[(11)]);
var inst_60957__$1 = (state_61023[(2)]);
var inst_60958 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_60957__$1);
var state_61023__$1 = (function (){var statearr_61081 = state_61023;
(statearr_61081[(28)] = inst_60958);

(statearr_61081[(11)] = inst_60957__$1);

return statearr_61081;
})();
if(cljs.core.truth_(inst_60954)){
var statearr_61082_61142 = state_61023__$1;
(statearr_61082_61142[(1)] = (15));

} else {
var statearr_61083_61143 = state_61023__$1;
(statearr_61083_61143[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (26))){
var inst_60977 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
if(cljs.core.truth_(inst_60977)){
var statearr_61084_61144 = state_61023__$1;
(statearr_61084_61144[(1)] = (30));

} else {
var statearr_61085_61145 = state_61023__$1;
(statearr_61085_61145[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (16))){
var state_61023__$1 = state_61023;
var statearr_61086_61146 = state_61023__$1;
(statearr_61086_61146[(2)] = null);

(statearr_61086_61146[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (38))){
var inst_60958 = (state_61023[(28)]);
var inst_60999 = (state_61023[(2)]);
var state_61023__$1 = (function (){var statearr_61087 = state_61023;
(statearr_61087[(16)] = inst_60999);

return statearr_61087;
})();
if(cljs.core.truth_(inst_60958)){
var statearr_61088_61147 = state_61023__$1;
(statearr_61088_61147[(1)] = (39));

} else {
var statearr_61089_61148 = state_61023__$1;
(statearr_61089_61148[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (30))){
var state_61023__$1 = state_61023;
var statearr_61090_61149 = state_61023__$1;
(statearr_61090_61149[(2)] = (207));

(statearr_61090_61149[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (10))){
var inst_61016 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
var statearr_61091_61150 = state_61023__$1;
(statearr_61091_61150[(2)] = inst_61016);

(statearr_61091_61150[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (18))){
var inst_60960 = (state_61023[(13)]);
var state_61023__$1 = state_61023;
var statearr_61092_61151 = state_61023__$1;
(statearr_61092_61151[(2)] = inst_60960);

(statearr_61092_61151[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (42))){
var inst_60957 = (state_61023[(11)]);
var inst_61007 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_60957);
var state_61023__$1 = state_61023;
var statearr_61093_61152 = state_61023__$1;
(statearr_61093_61152[(2)] = inst_61007);

(statearr_61093_61152[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (37))){
var state_61023__$1 = state_61023;
var statearr_61094_61153 = state_61023__$1;
(statearr_61094_61153[(2)] = null);

(statearr_61094_61153[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (8))){
var inst_60893 = (state_61023[(23)]);
var state_61023__$1 = state_61023;
if(cljs.core.truth_(inst_60893)){
var statearr_61095_61154 = state_61023__$1;
(statearr_61095_61154[(1)] = (11));

} else {
var statearr_61096_61155 = state_61023__$1;
(statearr_61096_61155[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2741__auto____0 = (function (){
var statearr_61097 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61097[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2741__auto__);

(statearr_61097[(1)] = (1));

return statearr_61097;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2741__auto____1 = (function (state_61023){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_61023);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61098){var ex__2744__auto__ = e61098;
var statearr_61099_61156 = state_61023;
(statearr_61099_61156[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_61023[(4)]))){
var statearr_61100_61157 = state_61023;
(statearr_61100_61157[(1)] = cljs.core.first.call(null,(state_61023[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61158 = state_61023;
state_61023 = G__61158;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2741__auto__ = function(state_61023){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2741__auto____1.call(this,state_61023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2741__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2741__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61101 = f__2764__auto__.call(null);
(statearr_61101[(6)] = c__2763__auto__);

return statearr_61101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__61159 = query_type;
var G__61159__$1 = (((G__61159 instanceof cljs.core.Keyword))?G__61159.fqn:null);
switch (G__61159__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61159__$1)].join('')));

}
});
