// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___62985 = arguments.length;
var i__4865__auto___62986 = (0);
while(true){
if((i__4865__auto___62986 < len__4864__auto___62985)){
args__4870__auto__.push((arguments[i__4865__auto___62986]));

var G__62987 = (i__4865__auto___62986 + (1));
i__4865__auto___62986 = G__62987;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__62917){
var vec__62918 = p__62917;
var opts = cljs.core.nth.call(null,vec__62918,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2763__auto___62988 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62962){
var state_val_62963 = (state_62962[(1)]);
if((state_val_62963 === (7))){
var inst_62948 = (state_62962[(7)]);
var inst_62939 = (state_62962[(8)]);
var inst_62950 = fluree.db.time_travel.as_of_block.call(null,inst_62948,inst_62939);
var state_62962__$1 = state_62962;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62962__$1,(10),inst_62950);
} else {
if((state_val_62963 === (1))){
var state_62962__$1 = state_62962;
var statearr_62964_62989 = state_62962__$1;
(statearr_62964_62989[(2)] = null);

(statearr_62964_62989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62963 === (4))){
var inst_62921 = (state_62962[(2)]);
var inst_62922 = fluree.db.util.log.error.call(null,inst_62921);
var inst_62923 = cljs.core.async.put_BANG_.call(null,pc,inst_62921);
var inst_62924 = cljs.core.async.close_BANG_.call(null,pc);
var state_62962__$1 = (function (){var statearr_62965 = state_62962;
(statearr_62965[(9)] = inst_62922);

(statearr_62965[(10)] = inst_62923);

return statearr_62965;
})();
var statearr_62966_62990 = state_62962__$1;
(statearr_62966_62990[(2)] = inst_62924);

(statearr_62966_62990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62963 === (6))){
var inst_62942 = (state_62962[(11)]);
var inst_62939 = (state_62962[(8)]);
var inst_62943 = (state_62962[(12)]);
var inst_62946 = (state_62962[(2)]);
var inst_62947 = fluree.db.util.async.throw_err.call(null,inst_62946);
var inst_62948 = cljs.core.assoc.call(null,inst_62947,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_62942,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_62943);
var state_62962__$1 = (function (){var statearr_62967 = state_62962;
(statearr_62967[(7)] = inst_62948);

return statearr_62967;
})();
if(cljs.core.truth_(inst_62939)){
var statearr_62968_62991 = state_62962__$1;
(statearr_62968_62991[(1)] = (7));

} else {
var statearr_62969_62992 = state_62962__$1;
(statearr_62969_62992[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62963 === (3))){
var inst_62960 = (state_62962[(2)]);
var state_62962__$1 = state_62962;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62962__$1,inst_62960);
} else {
if((state_val_62963 === (2))){
var _ = (function (){var statearr_62971 = state_62962;
(statearr_62971[(4)] = cljs.core.cons.call(null,(5),(state_62962[(4)])));

return statearr_62971;
})();
var inst_62934 = opts;
var inst_62935 = cljs.core.__destructure_map.call(null,inst_62934);
var inst_62936 = cljs.core.get.call(null,inst_62935,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_62937 = cljs.core.get.call(null,inst_62935,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_62938 = cljs.core.get.call(null,inst_62935,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_62939 = cljs.core.get.call(null,inst_62935,new cljs.core.Keyword(null,"block","block",664686210));
var inst_62940 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_62941 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_62942 = cljs.core.nth.call(null,inst_62941,(0),null);
var inst_62943 = cljs.core.nth.call(null,inst_62941,(1),null);
var inst_62944 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_62962__$1 = (function (){var statearr_62972 = state_62962;
(statearr_62972[(13)] = inst_62937);

(statearr_62972[(14)] = inst_62936);

(statearr_62972[(15)] = inst_62938);

(statearr_62972[(11)] = inst_62942);

(statearr_62972[(16)] = inst_62940);

(statearr_62972[(8)] = inst_62939);

(statearr_62972[(12)] = inst_62943);

return statearr_62972;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62962__$1,(6),inst_62944);
} else {
if((state_val_62963 === (9))){
var inst_62956 = (state_62962[(2)]);
var inst_62957 = cljs.core.async.put_BANG_.call(null,pc,inst_62956);
var _ = (function (){var statearr_62973 = state_62962;
(statearr_62973[(4)] = cljs.core.rest.call(null,(state_62962[(4)])));

return statearr_62973;
})();
var state_62962__$1 = state_62962;
var statearr_62974_62993 = state_62962__$1;
(statearr_62974_62993[(2)] = inst_62957);

(statearr_62974_62993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62963 === (5))){
var _ = (function (){var statearr_62975 = state_62962;
(statearr_62975[(4)] = cljs.core.rest.call(null,(state_62962[(4)])));

return statearr_62975;
})();
var state_62962__$1 = state_62962;
var ex62970 = (state_62962__$1[(2)]);
var statearr_62976_62994 = state_62962__$1;
(statearr_62976_62994[(5)] = ex62970);


var statearr_62977_62995 = state_62962__$1;
(statearr_62977_62995[(1)] = (4));

(statearr_62977_62995[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62963 === (10))){
var inst_62952 = (state_62962[(2)]);
var inst_62953 = fluree.db.util.async.throw_err.call(null,inst_62952);
var state_62962__$1 = state_62962;
var statearr_62978_62996 = state_62962__$1;
(statearr_62978_62996[(2)] = inst_62953);

(statearr_62978_62996[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62963 === (8))){
var inst_62948 = (state_62962[(7)]);
var state_62962__$1 = state_62962;
var statearr_62979_62997 = state_62962__$1;
(statearr_62979_62997[(2)] = inst_62948);

(statearr_62979_62997[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_62980 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62980[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_62980[(1)] = (1));

return statearr_62980;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_62962){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_62962);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62981){var ex__2744__auto__ = e62981;
var statearr_62982_62998 = state_62962;
(statearr_62982_62998[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_62962[(4)]))){
var statearr_62983_62999 = state_62962;
(statearr_62983_62999[(1)] = cljs.core.first.call(null,(state_62962[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63000 = state_62962;
state_62962 = G__63000;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_62962){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_62962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62984 = f__2764__auto__.call(null);
(statearr_62984[(6)] = c__2763__auto___62988);

return statearr_62984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq62914){
var G__62915 = cljs.core.first.call(null,seq62914);
var seq62914__$1 = cljs.core.next.call(null,seq62914);
var G__62916 = cljs.core.first.call(null,seq62914__$1);
var seq62914__$2 = cljs.core.next.call(null,seq62914__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62915,G__62916,seq62914__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
var and__4251__auto____$1 = open_api;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
return open_api;
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
return auth;
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__63002 = arguments.length;
switch (G__63002) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63128){
var state_val_63129 = (state_63128[(1)]);
if((state_val_63129 === (7))){
var inst_63028 = (state_63128[(7)]);
var inst_63018 = (state_63128[(8)]);
var inst_63030 = fluree.db.time_travel.as_of_block.call(null,inst_63028,inst_63018);
var state_63128__$1 = state_63128;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63128__$1,(10),inst_63030);
} else {
if((state_val_63129 === (20))){
var inst_63022 = (state_63128[(9)]);
var state_63128__$1 = state_63128;
var statearr_63130_63210 = state_63128__$1;
(statearr_63130_63210[(2)] = inst_63022);

(statearr_63130_63210[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (27))){
var inst_63016 = (state_63128[(10)]);
var state_63128__$1 = state_63128;
var statearr_63131_63211 = state_63128__$1;
(statearr_63131_63211[(2)] = inst_63016);

(statearr_63131_63211[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (1))){
var state_63128__$1 = state_63128;
var statearr_63132_63212 = state_63128__$1;
(statearr_63132_63212[(2)] = null);

(statearr_63132_63212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (24))){
var inst_63025 = (state_63128[(11)]);
var state_63128__$1 = state_63128;
if(cljs.core.truth_(inst_63025)){
var statearr_63133_63213 = state_63128__$1;
(statearr_63133_63213[(1)] = (26));

} else {
var statearr_63134_63214 = state_63128__$1;
(statearr_63134_63214[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (39))){
var inst_63090 = (state_63128[(12)]);
var inst_63093 = cljs.core.ex_data.call(null,inst_63090);
var inst_63094 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63095 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_63093);
var inst_63096 = cljs.core.ex_message.call(null,inst_63090);
var inst_63097 = [inst_63095,inst_63096,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63098 = cljs.core.PersistentHashMap.fromArrays(inst_63094,inst_63097);
var state_63128__$1 = state_63128;
var statearr_63135_63215 = state_63128__$1;
(statearr_63135_63215[(2)] = inst_63098);

(statearr_63135_63215[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (46))){
var inst_63090 = (state_63128[(12)]);
var state_63128__$1 = state_63128;
var statearr_63136_63216 = state_63128__$1;
(statearr_63136_63216[(2)] = inst_63090);

(statearr_63136_63216[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (4))){
var inst_63003 = (state_63128[(2)]);
var inst_63004 = fluree.db.util.log.error.call(null,inst_63003);
var inst_63005 = cljs.core.ex_data.call(null,inst_63003);
var inst_63006 = cljs.core.ex_message.call(null,inst_63003);
var inst_63007 = cljs.core.assoc.call(null,inst_63005,new cljs.core.Keyword(null,"message","message",-406056002),inst_63006);
var state_63128__$1 = (function (){var statearr_63137 = state_63128;
(statearr_63137[(13)] = inst_63004);

return statearr_63137;
})();
var statearr_63138_63217 = state_63128__$1;
(statearr_63138_63217[(2)] = inst_63007);

(statearr_63138_63217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (15))){
var state_63128__$1 = state_63128;
var statearr_63139_63218 = state_63128__$1;
(statearr_63139_63218[(2)] = (1000000));

(statearr_63139_63218[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (48))){
var inst_63090 = (state_63128[(12)]);
var state_63128__$1 = state_63128;
var statearr_63140_63219 = state_63128__$1;
(statearr_63140_63219[(2)] = inst_63090);

(statearr_63140_63219[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (50))){
var inst_63117 = (state_63128[(2)]);
var state_63128__$1 = state_63128;
var statearr_63141_63220 = state_63128__$1;
(statearr_63141_63220[(2)] = inst_63117);

(statearr_63141_63220[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (21))){
var inst_63021 = (state_63128[(14)]);
var state_63128__$1 = state_63128;
if(cljs.core.truth_(inst_63021)){
var statearr_63142_63221 = state_63128__$1;
(statearr_63142_63221[(1)] = (23));

} else {
var statearr_63143_63222 = state_63128__$1;
(statearr_63143_63222[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (31))){
var inst_63079 = (state_63128[(2)]);
var inst_63080 = cljs.core.not.call(null,inst_63079);
var state_63128__$1 = state_63128;
if(inst_63080){
var statearr_63144_63223 = state_63128__$1;
(statearr_63144_63223[(1)] = (35));

} else {
var statearr_63145_63224 = state_63128__$1;
(statearr_63145_63224[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (32))){
var inst_63023 = (state_63128[(15)]);
var state_63128__$1 = state_63128;
var statearr_63146_63225 = state_63128__$1;
(statearr_63146_63225[(2)] = inst_63023);

(statearr_63146_63225[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (40))){
var inst_63053 = (state_63128[(16)]);
var state_63128__$1 = state_63128;
if(cljs.core.truth_(inst_63053)){
var statearr_63147_63226 = state_63128__$1;
(statearr_63147_63226[(1)] = (42));

} else {
var statearr_63148_63227 = state_63128__$1;
(statearr_63148_63227[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (33))){
var inst_63019 = (state_63128[(17)]);
var state_63128__$1 = state_63128;
var statearr_63149_63228 = state_63128__$1;
(statearr_63149_63228[(2)] = inst_63019);

(statearr_63149_63228[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (13))){
var inst_63024 = (state_63128[(18)]);
var inst_63048 = (state_63128[(19)]);
var inst_63046 = (state_63128[(2)]);
var inst_63047 = cljs.core.volatile_BANG_.call(null,(0));
var inst_63048__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_63024);
var state_63128__$1 = (function (){var statearr_63150 = state_63128;
(statearr_63150[(20)] = inst_63046);

(statearr_63150[(19)] = inst_63048__$1);

(statearr_63150[(21)] = inst_63047);

return statearr_63150;
})();
if(cljs.core.truth_(inst_63048__$1)){
var statearr_63151_63229 = state_63128__$1;
(statearr_63151_63229[(1)] = (14));

} else {
var statearr_63152_63230 = state_63128__$1;
(statearr_63152_63230[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (22))){
var inst_63069 = (state_63128[(2)]);
var state_63128__$1 = state_63128;
var statearr_63153_63231 = state_63128__$1;
(statearr_63153_63231[(2)] = inst_63069);

(statearr_63153_63231[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (36))){
var inst_63055 = (state_63128[(22)]);
var inst_63036 = (state_63128[(23)]);
var inst_63086 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_63055);
var inst_63087 = fluree.db.query.fql.query.call(null,inst_63036,inst_63086);
var state_63128__$1 = state_63128;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63128__$1,(38),inst_63087);
} else {
if((state_val_63129 === (41))){
var inst_63121 = (state_63128[(2)]);
var state_63128__$1 = state_63128;
var statearr_63154_63232 = state_63128__$1;
(statearr_63154_63232[(2)] = inst_63121);

(statearr_63154_63232[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (43))){
var state_63128__$1 = state_63128;
var statearr_63155_63233 = state_63128__$1;
(statearr_63155_63233[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (29))){
var inst_63023 = (state_63128[(15)]);
var state_63128__$1 = state_63128;
if(cljs.core.truth_(inst_63023)){
var statearr_63157_63234 = state_63128__$1;
(statearr_63157_63234[(1)] = (32));

} else {
var statearr_63158_63235 = state_63128__$1;
(statearr_63158_63235[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (44))){
var inst_63119 = (state_63128[(2)]);
var state_63128__$1 = state_63128;
var statearr_63159_63236 = state_63128__$1;
(statearr_63159_63236[(2)] = inst_63119);

(statearr_63159_63236[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (6))){
var inst_63018 = (state_63128[(8)]);
var inst_63027 = (state_63128[(2)]);
var inst_63028 = fluree.db.util.async.throw_err.call(null,inst_63027);
var state_63128__$1 = (function (){var statearr_63160 = state_63128;
(statearr_63160[(7)] = inst_63028);

return statearr_63160;
})();
if(cljs.core.truth_(inst_63018)){
var statearr_63161_63237 = state_63128__$1;
(statearr_63161_63237[(1)] = (7));

} else {
var statearr_63162_63238 = state_63128__$1;
(statearr_63162_63238[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (28))){
var inst_63065 = (state_63128[(2)]);
var state_63128__$1 = state_63128;
var statearr_63163_63239 = state_63128__$1;
(statearr_63163_63239[(2)] = inst_63065);

(statearr_63163_63239[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (25))){
var inst_63067 = (state_63128[(2)]);
var state_63128__$1 = state_63128;
var statearr_63164_63240 = state_63128__$1;
(statearr_63164_63240[(2)] = inst_63067);

(statearr_63164_63240[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (34))){
var inst_63076 = (state_63128[(2)]);
var state_63128__$1 = state_63128;
var statearr_63165_63241 = state_63128__$1;
(statearr_63165_63241[(2)] = inst_63076);

(statearr_63165_63241[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (17))){
var inst_63017 = (state_63128[(24)]);
var state_63128__$1 = state_63128;
var statearr_63166_63242 = state_63128__$1;
(statearr_63166_63242[(2)] = inst_63017);

(statearr_63166_63242[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (3))){
var inst_63126 = (state_63128[(2)]);
var state_63128__$1 = state_63128;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63128__$1,inst_63126);
} else {
if((state_val_63129 === (12))){
var inst_63044 = cljs.core.PersistentHashMap.EMPTY;
var state_63128__$1 = state_63128;
var statearr_63167_63243 = state_63128__$1;
(statearr_63167_63243[(2)] = inst_63044);

(statearr_63167_63243[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (2))){
var _ = (function (){var statearr_63168 = state_63128;
(statearr_63168[(4)] = cljs.core.cons.call(null,(5),(state_63128[(4)])));

return statearr_63168;
})();
var inst_63014 = query_map;
var inst_63015 = cljs.core.__destructure_map.call(null,inst_63014);
var inst_63016 = cljs.core.get.call(null,inst_63015,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_63017 = cljs.core.get.call(null,inst_63015,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_63018 = cljs.core.get.call(null,inst_63015,new cljs.core.Keyword(null,"block","block",664686210));
var inst_63019 = cljs.core.get.call(null,inst_63015,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_63020 = cljs.core.get.call(null,inst_63015,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_63021 = cljs.core.get.call(null,inst_63015,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_63022 = cljs.core.get.call(null,inst_63015,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_63023 = cljs.core.get.call(null,inst_63015,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_63024 = cljs.core.get.call(null,inst_63015,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_63025 = cljs.core.get.call(null,inst_63015,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_63128__$1 = (function (){var statearr_63169 = state_63128;
(statearr_63169[(15)] = inst_63023);

(statearr_63169[(14)] = inst_63021);

(statearr_63169[(18)] = inst_63024);

(statearr_63169[(25)] = inst_63020);

(statearr_63169[(17)] = inst_63019);

(statearr_63169[(8)] = inst_63018);

(statearr_63169[(10)] = inst_63016);

(statearr_63169[(24)] = inst_63017);

(statearr_63169[(9)] = inst_63022);

(statearr_63169[(11)] = inst_63025);

return statearr_63169;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63128__$1,(6),sources);
} else {
if((state_val_63129 === (23))){
var inst_63021 = (state_63128[(14)]);
var state_63128__$1 = state_63128;
var statearr_63170_63244 = state_63128__$1;
(statearr_63170_63244[(2)] = inst_63021);

(statearr_63170_63244[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (47))){
var inst_63054 = (state_63128[(26)]);
var inst_63101 = (state_63128[(27)]);
var inst_63036 = (state_63128[(23)]);
var inst_63047 = (state_63128[(21)]);
var inst_63107 = (state_63128[(2)]);
var inst_63108 = cljs.core.deref.call(null,inst_63047);
var inst_63109 = fluree.db.util.core.response_time_formatted.call(null,inst_63054);
var inst_63110 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_63036);
var inst_63111 = [(200),inst_63107,inst_63108,inst_63109,inst_63110];
var inst_63112 = cljs.core.PersistentHashMap.fromArrays(inst_63101,inst_63111);
var state_63128__$1 = state_63128;
var statearr_63171_63245 = state_63128__$1;
(statearr_63171_63245[(2)] = inst_63112);

(statearr_63171_63245[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (35))){
var inst_63082 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63083 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63084 = cljs.core.PersistentHashMap.fromArrays(inst_63082,inst_63083);
var state_63128__$1 = state_63128;
var statearr_63172_63246 = state_63128__$1;
(statearr_63172_63246[(2)] = inst_63084);

(statearr_63172_63246[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (19))){
var inst_63071 = (state_63128[(28)]);
var inst_63071__$1 = (state_63128[(2)]);
var state_63128__$1 = (function (){var statearr_63173 = state_63128;
(statearr_63173[(28)] = inst_63071__$1);

return statearr_63173;
})();
if(cljs.core.truth_(inst_63071__$1)){
var statearr_63174_63247 = state_63128__$1;
(statearr_63174_63247[(1)] = (29));

} else {
var statearr_63175_63248 = state_63128__$1;
(statearr_63175_63248[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (11))){
var inst_63037 = (state_63128[(29)]);
var inst_63020 = (state_63128[(25)]);
var inst_63036 = (state_63128[(23)]);
var inst_63039 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_63036);
var inst_63040 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_63037);
var inst_63041 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_63036);
var inst_63042 = fluree.db.api_js.get_sources.call(null,inst_63037,inst_63039,inst_63040,inst_63041,inst_63020,db_fn);
var state_63128__$1 = state_63128;
var statearr_63177_63249 = state_63128__$1;
(statearr_63177_63249[(2)] = inst_63042);

(statearr_63177_63249[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (9))){
var inst_63020 = (state_63128[(25)]);
var inst_63036 = (state_63128[(23)]);
var inst_63036__$1 = (state_63128[(2)]);
var inst_63037 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_63036__$1);
var state_63128__$1 = (function (){var statearr_63178 = state_63128;
(statearr_63178[(29)] = inst_63037);

(statearr_63178[(23)] = inst_63036__$1);

return statearr_63178;
})();
if(cljs.core.truth_(inst_63020)){
var statearr_63179_63250 = state_63128__$1;
(statearr_63179_63250[(1)] = (11));

} else {
var statearr_63180_63251 = state_63128__$1;
(statearr_63180_63251[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (5))){
var _ = (function (){var statearr_63181 = state_63128;
(statearr_63181[(4)] = cljs.core.rest.call(null,(state_63128[(4)])));

return statearr_63181;
})();
var state_63128__$1 = state_63128;
var ex63176 = (state_63128__$1[(2)]);
var statearr_63182_63252 = state_63128__$1;
(statearr_63182_63252[(5)] = ex63176);


var statearr_63183_63253 = state_63128__$1;
(statearr_63183_63253[(1)] = (4));

(statearr_63183_63253[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (14))){
var inst_63048 = (state_63128[(19)]);
var state_63128__$1 = state_63128;
var statearr_63184_63254 = state_63128__$1;
(statearr_63184_63254[(2)] = inst_63048);

(statearr_63184_63254[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (45))){
var inst_63090 = (state_63128[(12)]);
var inst_63104 = cljs.core.doall.call(null,inst_63090);
var state_63128__$1 = state_63128;
var statearr_63185_63255 = state_63128__$1;
(statearr_63185_63255[(2)] = inst_63104);

(statearr_63185_63255[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (26))){
var inst_63025 = (state_63128[(11)]);
var state_63128__$1 = state_63128;
var statearr_63186_63256 = state_63128__$1;
(statearr_63186_63256[(2)] = inst_63025);

(statearr_63186_63256[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (16))){
var inst_63046 = (state_63128[(20)]);
var inst_63024 = (state_63128[(18)]);
var inst_63047 = (state_63128[(21)]);
var inst_63017 = (state_63128[(24)]);
var inst_63052 = (state_63128[(2)]);
var inst_63053 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_63024);
var inst_63054 = fluree.db.util.core.current_time_millis.call(null);
var inst_63055 = cljs.core.assoc.call(null,inst_63024,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_63046,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_63052,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_63047);
var state_63128__$1 = (function (){var statearr_63187 = state_63128;
(statearr_63187[(26)] = inst_63054);

(statearr_63187[(16)] = inst_63053);

(statearr_63187[(22)] = inst_63055);

return statearr_63187;
})();
if(cljs.core.truth_(inst_63017)){
var statearr_63188_63257 = state_63128__$1;
(statearr_63188_63257[(1)] = (17));

} else {
var statearr_63189_63258 = state_63128__$1;
(statearr_63189_63258[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (38))){
var inst_63090 = (state_63128[(12)]);
var inst_63089 = (state_63128[(2)]);
var inst_63090__$1 = fluree.db.util.async.throw_err.call(null,inst_63089);
var inst_63091 = (inst_63090__$1 instanceof cljs.core.ExceptionInfo);
var state_63128__$1 = (function (){var statearr_63190 = state_63128;
(statearr_63190[(12)] = inst_63090__$1);

return statearr_63190;
})();
if(cljs.core.truth_(inst_63091)){
var statearr_63191_63259 = state_63128__$1;
(statearr_63191_63259[(1)] = (39));

} else {
var statearr_63192_63260 = state_63128__$1;
(statearr_63192_63260[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (30))){
var inst_63071 = (state_63128[(28)]);
var state_63128__$1 = state_63128;
var statearr_63193_63261 = state_63128__$1;
(statearr_63193_63261[(2)] = inst_63071);

(statearr_63193_63261[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (10))){
var inst_63032 = (state_63128[(2)]);
var inst_63033 = fluree.db.util.async.throw_err.call(null,inst_63032);
var state_63128__$1 = state_63128;
var statearr_63194_63262 = state_63128__$1;
(statearr_63194_63262[(2)] = inst_63033);

(statearr_63194_63262[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (18))){
var inst_63022 = (state_63128[(9)]);
var state_63128__$1 = state_63128;
if(cljs.core.truth_(inst_63022)){
var statearr_63195_63263 = state_63128__$1;
(statearr_63195_63263[(1)] = (20));

} else {
var statearr_63196_63264 = state_63128__$1;
(statearr_63196_63264[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (42))){
var inst_63090 = (state_63128[(12)]);
var inst_63101 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_63102 = cljs.core.sequential_QMARK_.call(null,inst_63090);
var state_63128__$1 = (function (){var statearr_63197 = state_63128;
(statearr_63197[(27)] = inst_63101);

return statearr_63197;
})();
if(inst_63102){
var statearr_63198_63265 = state_63128__$1;
(statearr_63198_63265[(1)] = (45));

} else {
var statearr_63199_63266 = state_63128__$1;
(statearr_63199_63266[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (37))){
var inst_63123 = (state_63128[(2)]);
var _ = (function (){var statearr_63200 = state_63128;
(statearr_63200[(4)] = cljs.core.rest.call(null,(state_63128[(4)])));

return statearr_63200;
})();
var state_63128__$1 = state_63128;
var statearr_63201_63267 = state_63128__$1;
(statearr_63201_63267[(2)] = inst_63123);

(statearr_63201_63267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (8))){
var inst_63028 = (state_63128[(7)]);
var state_63128__$1 = state_63128;
var statearr_63202_63268 = state_63128__$1;
(statearr_63202_63268[(2)] = inst_63028);

(statearr_63202_63268[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63129 === (49))){
var state_63128__$1 = state_63128;
var statearr_63203_63269 = state_63128__$1;
(statearr_63203_63269[(2)] = null);

(statearr_63203_63269[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_63204 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63204[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_63204[(1)] = (1));

return statearr_63204;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_63128){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_63128);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63205){var ex__2744__auto__ = e63205;
var statearr_63206_63270 = state_63128;
(statearr_63206_63270[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_63128[(4)]))){
var statearr_63207_63271 = state_63128;
(statearr_63207_63271[(1)] = cljs.core.first.call(null,(state_63128[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63272 = state_63128;
state_63128 = G__63272;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_63128){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_63128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63208 = f__2764__auto__.call(null);
(statearr_63208[(6)] = c__2763__auto__);

return statearr_63208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__63273_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__63273_SHARP_);
}));

var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63295){
var state_val_63296 = (state_63295[(1)]);
if((state_val_63296 === (1))){
var inst_63277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63278 = [resp_chan,timeout_chan];
var inst_63279 = (new cljs.core.PersistentVector(null,2,(5),inst_63277,inst_63278,null));
var state_63295__$1 = state_63295;
return cljs.core.async.ioc_alts_BANG_.call(null,state_63295__$1,(2),inst_63279);
} else {
if((state_val_63296 === (2))){
var inst_63281 = (state_63295[(2)]);
var inst_63282 = cljs.core.nth.call(null,inst_63281,(0),null);
var inst_63283 = cljs.core.nth.call(null,inst_63281,(1),null);
var inst_63284 = cljs.core._EQ_.call(null,timeout_chan,inst_63283);
var state_63295__$1 = (function (){var statearr_63297 = state_63295;
(statearr_63297[(7)] = inst_63282);

return statearr_63297;
})();
if(inst_63284){
var statearr_63298_63308 = state_63295__$1;
(statearr_63298_63308[(1)] = (3));

} else {
var statearr_63299_63309 = state_63295__$1;
(statearr_63299_63309[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63296 === (3))){
var inst_63286 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_63287 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_63288 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_63289 = [tid,(408),inst_63288];
var inst_63290 = cljs.core.PersistentHashMap.fromArrays(inst_63287,inst_63289);
var state_63295__$1 = (function (){var statearr_63300 = state_63295;
(statearr_63300[(8)] = inst_63286);

return statearr_63300;
})();
var statearr_63301_63310 = state_63295__$1;
(statearr_63301_63310[(2)] = inst_63290);

(statearr_63301_63310[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63296 === (4))){
var inst_63282 = (state_63295[(7)]);
var state_63295__$1 = state_63295;
var statearr_63302_63311 = state_63295__$1;
(statearr_63302_63311[(2)] = inst_63282);

(statearr_63302_63311[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63296 === (5))){
var inst_63293 = (state_63295[(2)]);
var state_63295__$1 = state_63295;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63295__$1,inst_63293);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2741__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2741__auto____0 = (function (){
var statearr_63303 = [null,null,null,null,null,null,null,null,null];
(statearr_63303[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2741__auto__);

(statearr_63303[(1)] = (1));

return statearr_63303;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2741__auto____1 = (function (state_63295){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_63295);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63304){var ex__2744__auto__ = e63304;
var statearr_63305_63312 = state_63295;
(statearr_63305_63312[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_63295[(4)]))){
var statearr_63306_63313 = state_63295;
(statearr_63306_63313[(1)] = cljs.core.first.call(null,(state_63295[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63314 = state_63295;
state_63295 = G__63314;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2741__auto__ = function(state_63295){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2741__auto____1.call(this,state_63295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2741__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2741__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63307 = f__2764__auto__.call(null);
(statearr_63307[(6)] = c__2763__auto__);

return statearr_63307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__63316 = arguments.length;
switch (G__63316) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__63317 = opts;
var map__63317__$1 = cljs.core.__destructure_map.call(null,map__63317);
var auth = cljs.core.get.call(null,map__63317__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__63317__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__63317__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__63317__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__63318 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__63318,(0),null);
var authority = cljs.core.nth.call(null,vec__63318,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e63321){var e = e63321;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__63324 = arguments.length;
switch (G__63324) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63390){
var state_val_63391 = (state_63390[(1)]);
if((state_val_63391 === (7))){
var inst_63346 = (state_63390[(7)]);
var inst_63341 = (state_63390[(8)]);
var inst_63345 = (state_63390[(9)]);
var inst_63343 = (state_63390[(10)]);
var inst_63344 = (state_63390[(11)]);
var inst_63359 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_63360 = [ledger,txn,inst_63341,inst_63343,inst_63344,inst_63345,inst_63346];
var inst_63361 = cljs.core.PersistentHashMap.fromArrays(inst_63359,inst_63360);
var inst_63362 = fluree.db.util.core.without_nils.call(null,inst_63361);
var inst_63363 = fluree.db.operations.transact_async.call(null,conn,inst_63362);
var state_63390__$1 = state_63390;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63390__$1,(13),inst_63363);
} else {
if((state_val_63391 === (20))){
var inst_63381 = (state_63390[(2)]);
var state_63390__$1 = state_63390;
var statearr_63392_63428 = state_63390__$1;
(statearr_63392_63428[(2)] = inst_63381);

(statearr_63392_63428[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (1))){
var state_63390__$1 = state_63390;
var statearr_63393_63429 = state_63390__$1;
(statearr_63393_63429[(2)] = null);

(statearr_63393_63429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (4))){
var inst_63325 = (state_63390[(2)]);
var inst_63326 = fluree.db.util.log.error.call(null,inst_63325);
var inst_63327 = cljs.core.ex_data.call(null,inst_63325);
var inst_63328 = cljs.core.ex_message.call(null,inst_63325);
var inst_63329 = cljs.core.assoc.call(null,inst_63327,new cljs.core.Keyword(null,"message","message",-406056002),inst_63328);
var state_63390__$1 = (function (){var statearr_63394 = state_63390;
(statearr_63394[(12)] = inst_63326);

return statearr_63394;
})();
var statearr_63395_63430 = state_63390__$1;
(statearr_63395_63430[(2)] = inst_63329);

(statearr_63395_63430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (15))){
var inst_63365 = (state_63390[(13)]);
var inst_63340 = (state_63390[(14)]);
var inst_63368 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_63365,inst_63340);
var state_63390__$1 = state_63390;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63390__$1,(17),inst_63368);
} else {
if((state_val_63391 === (13))){
var inst_63339 = (state_63390[(15)]);
var inst_63365 = (state_63390[(2)]);
var state_63390__$1 = (function (){var statearr_63396 = state_63390;
(statearr_63396[(13)] = inst_63365);

return statearr_63396;
})();
if(cljs.core.truth_(inst_63339)){
var statearr_63397_63431 = state_63390__$1;
(statearr_63397_63431[(1)] = (14));

} else {
var statearr_63398_63432 = state_63390__$1;
(statearr_63398_63432[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (6))){
var inst_63339 = (state_63390[(15)]);
var inst_63338 = (state_63390[(16)]);
var inst_63348 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_63338,opts);
var inst_63349 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_63348);
var inst_63350 = fluree.db.operations.command_async.call(null,conn,inst_63348);
var state_63390__$1 = (function (){var statearr_63399 = state_63390;
(statearr_63399[(17)] = inst_63349);

(statearr_63399[(18)] = inst_63350);

return statearr_63399;
})();
if(cljs.core.truth_(inst_63339)){
var statearr_63400_63433 = state_63390__$1;
(statearr_63400_63433[(1)] = (9));

} else {
var statearr_63401_63434 = state_63390__$1;
(statearr_63401_63434[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (17))){
var inst_63370 = (state_63390[(19)]);
var inst_63370__$1 = (state_63390[(2)]);
var inst_63371 = (inst_63370__$1 instanceof cljs.core.ExceptionInfo);
var state_63390__$1 = (function (){var statearr_63402 = state_63390;
(statearr_63402[(19)] = inst_63370__$1);

return statearr_63402;
})();
if(cljs.core.truth_(inst_63371)){
var statearr_63403_63435 = state_63390__$1;
(statearr_63403_63435[(1)] = (18));

} else {
var statearr_63404_63436 = state_63390__$1;
(statearr_63404_63436[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (3))){
var inst_63388 = (state_63390[(2)]);
var state_63390__$1 = state_63390;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63390__$1,inst_63388);
} else {
if((state_val_63391 === (12))){
var inst_63355 = (state_63390[(2)]);
var state_63390__$1 = state_63390;
var statearr_63405_63437 = state_63390__$1;
(statearr_63405_63437[(2)] = inst_63355);

(statearr_63405_63437[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (2))){
var inst_63338 = (state_63390[(16)]);
var _ = (function (){var statearr_63406 = state_63390;
(statearr_63406[(4)] = cljs.core.cons.call(null,(5),(state_63390[(4)])));

return statearr_63406;
})();
var inst_63336 = opts;
var inst_63337 = cljs.core.__destructure_map.call(null,inst_63336);
var inst_63338__$1 = cljs.core.get.call(null,inst_63337,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_63339 = cljs.core.get.call(null,inst_63337,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_63340 = cljs.core.get.call(null,inst_63337,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_63341 = cljs.core.get.call(null,inst_63337,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_63342 = fluree.db.util.core.current_time_millis.call(null);
var inst_63343 = cljs.core.get.call(null,inst_63337,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_63342);
var inst_63344 = cljs.core.get.call(null,inst_63337,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_63345 = cljs.core.get.call(null,inst_63337,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_63346 = cljs.core.get.call(null,inst_63337,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_63390__$1 = (function (){var statearr_63407 = state_63390;
(statearr_63407[(15)] = inst_63339);

(statearr_63407[(7)] = inst_63346);

(statearr_63407[(8)] = inst_63341);

(statearr_63407[(16)] = inst_63338__$1);

(statearr_63407[(9)] = inst_63345);

(statearr_63407[(10)] = inst_63343);

(statearr_63407[(14)] = inst_63340);

(statearr_63407[(11)] = inst_63344);

return statearr_63407;
})();
if(cljs.core.truth_(inst_63338__$1)){
var statearr_63408_63438 = state_63390__$1;
(statearr_63408_63438[(1)] = (6));

} else {
var statearr_63409_63439 = state_63390__$1;
(statearr_63409_63439[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (19))){
var inst_63370 = (state_63390[(19)]);
var state_63390__$1 = state_63390;
var statearr_63410_63440 = state_63390__$1;
(statearr_63410_63440[(2)] = inst_63370);

(statearr_63410_63440[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (11))){
var inst_63357 = (state_63390[(2)]);
var state_63390__$1 = state_63390;
var statearr_63412_63441 = state_63390__$1;
(statearr_63412_63441[(2)] = inst_63357);

(statearr_63412_63441[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (9))){
var inst_63350 = (state_63390[(18)]);
var state_63390__$1 = state_63390;
var statearr_63413_63442 = state_63390__$1;
(statearr_63413_63442[(2)] = inst_63350);

(statearr_63413_63442[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (5))){
var _ = (function (){var statearr_63414 = state_63390;
(statearr_63414[(4)] = cljs.core.rest.call(null,(state_63390[(4)])));

return statearr_63414;
})();
var state_63390__$1 = state_63390;
var ex63411 = (state_63390__$1[(2)]);
var statearr_63415_63443 = state_63390__$1;
(statearr_63415_63443[(5)] = ex63411);


var statearr_63416_63444 = state_63390__$1;
(statearr_63416_63444[(1)] = (4));

(statearr_63416_63444[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (14))){
var inst_63365 = (state_63390[(13)]);
var state_63390__$1 = state_63390;
var statearr_63417_63445 = state_63390__$1;
(statearr_63417_63445[(2)] = inst_63365);

(statearr_63417_63445[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (16))){
var inst_63383 = (state_63390[(2)]);
var state_63390__$1 = state_63390;
var statearr_63418_63446 = state_63390__$1;
(statearr_63418_63446[(2)] = inst_63383);

(statearr_63418_63446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (10))){
var inst_63349 = (state_63390[(17)]);
var inst_63340 = (state_63390[(14)]);
var inst_63353 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_63349,inst_63340);
var state_63390__$1 = state_63390;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63390__$1,(12),inst_63353);
} else {
if((state_val_63391 === (18))){
var inst_63370 = (state_63390[(19)]);
var inst_63373 = cljs.core.ex_data.call(null,inst_63370);
var inst_63374 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63375 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_63373);
var inst_63376 = cljs.core.ex_message.call(null,inst_63370);
var inst_63377 = [inst_63375,inst_63376,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_63378 = cljs.core.PersistentHashMap.fromArrays(inst_63374,inst_63377);
var state_63390__$1 = state_63390;
var statearr_63419_63447 = state_63390__$1;
(statearr_63419_63447[(2)] = inst_63378);

(statearr_63419_63447[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63391 === (8))){
var inst_63385 = (state_63390[(2)]);
var _ = (function (){var statearr_63420 = state_63390;
(statearr_63420[(4)] = cljs.core.rest.call(null,(state_63390[(4)])));

return statearr_63420;
})();
var state_63390__$1 = state_63390;
var statearr_63421_63448 = state_63390__$1;
(statearr_63421_63448[(2)] = inst_63385);

(statearr_63421_63448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_63422 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63422[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_63422[(1)] = (1));

return statearr_63422;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_63390){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_63390);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63423){var ex__2744__auto__ = e63423;
var statearr_63424_63449 = state_63390;
(statearr_63424_63449[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_63390[(4)]))){
var statearr_63425_63450 = state_63390;
(statearr_63425_63450[(1)] = cljs.core.first.call(null,(state_63390[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63451 = state_63390;
state_63390 = G__63451;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_63390){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_63390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63426 = f__2764__auto__.call(null);
(statearr_63426[(6)] = c__2763__auto__);

return statearr_63426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___63453 = arguments.length;
var i__4865__auto___63454 = (0);
while(true){
if((i__4865__auto___63454 < len__4864__auto___63453)){
args__4870__auto__.push((arguments[i__4865__auto___63454]));

var G__63455 = (i__4865__auto___63454 + (1));
i__4865__auto___63454 = G__63455;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq63452){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq63452));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63486){
var state_val_63487 = (state_63486[(1)]);
if((state_val_63487 === (1))){
var inst_63456 = cljs.core.first.call(null,flakes);
var inst_63457 = cljs.core.rest.call(null,flakes);
var inst_63458 = cljs.core.PersistentVector.EMPTY;
var inst_63459 = inst_63456;
var inst_63460 = inst_63457;
var inst_63461 = inst_63458;
var state_63486__$1 = (function (){var statearr_63488 = state_63486;
(statearr_63488[(7)] = inst_63460);

(statearr_63488[(8)] = inst_63461);

(statearr_63488[(9)] = inst_63459);

return statearr_63488;
})();
var statearr_63489_63502 = state_63486__$1;
(statearr_63489_63502[(2)] = null);

(statearr_63489_63502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63487 === (2))){
var inst_63459 = (state_63486[(9)]);
var inst_63463 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_63464 = cljs.core.PersistentHashMap.EMPTY;
var inst_63465 = [true,inst_63464];
var inst_63466 = cljs.core.PersistentHashMap.fromArrays(inst_63463,inst_63465);
var inst_63467 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_63466,inst_63459);
var state_63486__$1 = state_63486;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63486__$1,(4),inst_63467);
} else {
if((state_val_63487 === (3))){
var inst_63484 = (state_63486[(2)]);
var state_63486__$1 = state_63486;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63486__$1,inst_63484);
} else {
if((state_val_63487 === (4))){
var inst_63460 = (state_63486[(7)]);
var inst_63461 = (state_63486[(8)]);
var inst_63469 = (state_63486[(2)]);
var inst_63470 = fluree.db.util.async.throw_err.call(null,inst_63469);
var inst_63471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63472 = [inst_63470];
var inst_63473 = (new cljs.core.PersistentVector(null,1,(5),inst_63471,inst_63472,null));
var inst_63474 = cljs.core.concat.call(null,inst_63461,inst_63473);
var inst_63475 = cljs.core.first.call(null,inst_63460);
var state_63486__$1 = (function (){var statearr_63490 = state_63486;
(statearr_63490[(10)] = inst_63474);

return statearr_63490;
})();
if(cljs.core.truth_(inst_63475)){
var statearr_63491_63503 = state_63486__$1;
(statearr_63491_63503[(1)] = (5));

} else {
var statearr_63492_63504 = state_63486__$1;
(statearr_63492_63504[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63487 === (5))){
var inst_63460 = (state_63486[(7)]);
var inst_63474 = (state_63486[(10)]);
var inst_63477 = cljs.core.first.call(null,inst_63460);
var inst_63478 = cljs.core.rest.call(null,inst_63460);
var inst_63459 = inst_63477;
var inst_63460__$1 = inst_63478;
var inst_63461 = inst_63474;
var state_63486__$1 = (function (){var statearr_63493 = state_63486;
(statearr_63493[(7)] = inst_63460__$1);

(statearr_63493[(8)] = inst_63461);

(statearr_63493[(9)] = inst_63459);

return statearr_63493;
})();
var statearr_63494_63505 = state_63486__$1;
(statearr_63494_63505[(2)] = null);

(statearr_63494_63505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63487 === (6))){
var inst_63474 = (state_63486[(10)]);
var state_63486__$1 = state_63486;
var statearr_63495_63506 = state_63486__$1;
(statearr_63495_63506[(2)] = inst_63474);

(statearr_63495_63506[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63487 === (7))){
var inst_63482 = (state_63486[(2)]);
var state_63486__$1 = state_63486;
var statearr_63496_63507 = state_63486__$1;
(statearr_63496_63507[(2)] = inst_63482);

(statearr_63496_63507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto____0 = (function (){
var statearr_63497 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_63497[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto__);

(statearr_63497[(1)] = (1));

return statearr_63497;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto____1 = (function (state_63486){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_63486);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63498){var ex__2744__auto__ = e63498;
var statearr_63499_63508 = state_63486;
(statearr_63499_63508[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_63486[(4)]))){
var statearr_63500_63509 = state_63486;
(statearr_63500_63509[(1)] = cljs.core.first.call(null,(state_63486[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63510 = state_63486;
state_63486 = G__63510;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto__ = function(state_63486){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto____1.call(this,state_63486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63501 = f__2764__auto__.call(null);
(statearr_63501[(6)] = c__2763__auto__);

return statearr_63501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63578){
var state_val_63579 = (state_63578[(1)]);
if((state_val_63579 === (7))){
var inst_63538 = (state_63578[(2)]);
var inst_63539 = fluree.db.util.async.throw_err.call(null,inst_63538);
var state_63578__$1 = state_63578;
var statearr_63580_63606 = state_63578__$1;
(statearr_63580_63606[(2)] = inst_63539);

(statearr_63580_63606[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63579 === (1))){
var inst_63515 = cljs.core.volatile_BANG_.call(null,(0));
var inst_63516 = cljs.core.PersistentHashMap.EMPTY;
var inst_63517 = cljs.core.volatile_BANG_.call(null,inst_63516);
var inst_63518 = cljs.core.first.call(null,resp);
var inst_63519 = cljs.core.rest.call(null,resp);
var inst_63520 = cljs.core.PersistentVector.EMPTY;
var inst_63521 = inst_63515;
var inst_63522 = inst_63517;
var inst_63523 = inst_63518;
var inst_63524 = inst_63519;
var inst_63525 = inst_63520;
var state_63578__$1 = (function (){var statearr_63581 = state_63578;
(statearr_63581[(7)] = inst_63525);

(statearr_63581[(8)] = inst_63521);

(statearr_63581[(9)] = inst_63523);

(statearr_63581[(10)] = inst_63522);

(statearr_63581[(11)] = inst_63524);

return statearr_63581;
})();
var statearr_63582_63607 = state_63578__$1;
(statearr_63582_63607[(2)] = null);

(statearr_63582_63607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63579 === (4))){
var inst_63525 = (state_63578[(7)]);
var inst_63527 = (state_63578[(12)]);
var inst_63521 = (state_63578[(8)]);
var inst_63523 = (state_63578[(9)]);
var inst_63522 = (state_63578[(10)]);
var inst_63524 = (state_63578[(11)]);
var inst_63529 = (state_63578[(13)]);
var inst_63533 = (function (){var fuel = inst_63521;
var cache = inst_63522;
var curr_block = inst_63523;
var rest_blocks = inst_63524;
var acc = inst_63525;
var flakes = inst_63527;
var asserted = inst_63529;
return (function (p1__63512_SHARP_){
return p1__63512_SHARP_.s;
});
})();
var inst_63534 = cljs.core.group_by.call(null,inst_63533,inst_63529);
var inst_63535 = cljs.core.vals.call(null,inst_63534);
var inst_63536 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_63522,inst_63521,inst_63535);
var state_63578__$1 = state_63578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63578__$1,(7),inst_63536);
} else {
if((state_val_63579 === (13))){
var inst_63566 = (state_63578[(14)]);
var state_63578__$1 = state_63578;
var statearr_63583_63608 = state_63578__$1;
(statearr_63583_63608[(2)] = inst_63566);

(statearr_63583_63608[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63579 === (6))){
var inst_63525 = (state_63578[(7)]);
var inst_63527 = (state_63578[(12)]);
var inst_63544 = (state_63578[(15)]);
var inst_63542 = (state_63578[(16)]);
var inst_63521 = (state_63578[(8)]);
var inst_63523 = (state_63578[(9)]);
var inst_63522 = (state_63578[(10)]);
var inst_63524 = (state_63578[(11)]);
var inst_63529 = (state_63578[(13)]);
var inst_63542__$1 = (state_63578[(2)]);
var inst_63543 = (function (){var fuel = inst_63521;
var cache = inst_63522;
var curr_block = inst_63523;
var rest_blocks = inst_63524;
var acc = inst_63525;
var flakes = inst_63527;
var asserted = inst_63529;
var asserted_SINGLEQUOTE_ = inst_63542__$1;
return (function (p1__63513_SHARP_){
return p1__63513_SHARP_.op === false;
});
})();
var inst_63544__$1 = cljs.core.filter.call(null,inst_63543,inst_63527);
var inst_63545 = cljs.core.empty_QMARK_.call(null,inst_63544__$1);
var inst_63546 = (!(inst_63545));
var state_63578__$1 = (function (){var statearr_63586 = state_63578;
(statearr_63586[(15)] = inst_63544__$1);

(statearr_63586[(16)] = inst_63542__$1);

return statearr_63586;
})();
if(inst_63546){
var statearr_63587_63609 = state_63578__$1;
(statearr_63587_63609[(1)] = (8));

} else {
var statearr_63588_63610 = state_63578__$1;
(statearr_63588_63610[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63579 === (3))){
var inst_63576 = (state_63578[(2)]);
var state_63578__$1 = state_63578;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63578__$1,inst_63576);
} else {
if((state_val_63579 === (12))){
var inst_63566 = (state_63578[(14)]);
var inst_63521 = (state_63578[(8)]);
var inst_63522 = (state_63578[(10)]);
var inst_63524 = (state_63578[(11)]);
var inst_63569 = cljs.core.first.call(null,inst_63524);
var inst_63570 = cljs.core.rest.call(null,inst_63524);
var tmp63584 = inst_63521;
var tmp63585 = inst_63522;
var inst_63521__$1 = tmp63584;
var inst_63522__$1 = tmp63585;
var inst_63523 = inst_63569;
var inst_63524__$1 = inst_63570;
var inst_63525 = inst_63566;
var state_63578__$1 = (function (){var statearr_63589 = state_63578;
(statearr_63589[(7)] = inst_63525);

(statearr_63589[(8)] = inst_63521__$1);

(statearr_63589[(9)] = inst_63523);

(statearr_63589[(10)] = inst_63522__$1);

(statearr_63589[(11)] = inst_63524__$1);

return statearr_63589;
})();
var statearr_63590_63611 = state_63578__$1;
(statearr_63590_63611[(2)] = null);

(statearr_63590_63611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63579 === (2))){
var inst_63525 = (state_63578[(7)]);
var inst_63527 = (state_63578[(12)]);
var inst_63521 = (state_63578[(8)]);
var inst_63523 = (state_63578[(9)]);
var inst_63522 = (state_63578[(10)]);
var inst_63524 = (state_63578[(11)]);
var inst_63529 = (state_63578[(13)]);
var inst_63527__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_63523);
var inst_63528 = (function (){var fuel = inst_63521;
var cache = inst_63522;
var curr_block = inst_63523;
var rest_blocks = inst_63524;
var acc = inst_63525;
var flakes = inst_63527__$1;
return (function (p1__63511_SHARP_){
return p1__63511_SHARP_.op;
});
})();
var inst_63529__$1 = cljs.core.filter.call(null,inst_63528,inst_63527__$1);
var inst_63530 = cljs.core.empty_QMARK_.call(null,inst_63529__$1);
var inst_63531 = (!(inst_63530));
var state_63578__$1 = (function (){var statearr_63591 = state_63578;
(statearr_63591[(12)] = inst_63527__$1);

(statearr_63591[(13)] = inst_63529__$1);

return statearr_63591;
})();
if(inst_63531){
var statearr_63592_63612 = state_63578__$1;
(statearr_63592_63612[(1)] = (4));

} else {
var statearr_63593_63613 = state_63578__$1;
(statearr_63593_63613[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63579 === (11))){
var inst_63554 = (state_63578[(2)]);
var inst_63555 = fluree.db.util.async.throw_err.call(null,inst_63554);
var state_63578__$1 = state_63578;
var statearr_63594_63614 = state_63578__$1;
(statearr_63594_63614[(2)] = inst_63555);

(statearr_63594_63614[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63579 === (9))){
var state_63578__$1 = state_63578;
var statearr_63595_63615 = state_63578__$1;
(statearr_63595_63615[(2)] = null);

(statearr_63595_63615[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63579 === (5))){
var state_63578__$1 = state_63578;
var statearr_63596_63616 = state_63578__$1;
(statearr_63596_63616[(2)] = null);

(statearr_63596_63616[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63579 === (14))){
var inst_63574 = (state_63578[(2)]);
var state_63578__$1 = state_63578;
var statearr_63597_63617 = state_63578__$1;
(statearr_63597_63617[(2)] = inst_63574);

(statearr_63597_63617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63579 === (10))){
var inst_63525 = (state_63578[(7)]);
var inst_63542 = (state_63578[(16)]);
var inst_63523 = (state_63578[(9)]);
var inst_63524 = (state_63578[(11)]);
var inst_63558 = (state_63578[(2)]);
var inst_63559 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_63560 = [inst_63542,inst_63558];
var inst_63561 = cljs.core.PersistentHashMap.fromArrays(inst_63559,inst_63560);
var inst_63562 = cljs.core.assoc.call(null,inst_63523,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_63561);
var inst_63563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63564 = [inst_63562];
var inst_63565 = (new cljs.core.PersistentVector(null,1,(5),inst_63563,inst_63564,null));
var inst_63566 = cljs.core.concat.call(null,inst_63525,inst_63565);
var inst_63567 = cljs.core.first.call(null,inst_63524);
var state_63578__$1 = (function (){var statearr_63598 = state_63578;
(statearr_63598[(14)] = inst_63566);

return statearr_63598;
})();
if(cljs.core.truth_(inst_63567)){
var statearr_63599_63618 = state_63578__$1;
(statearr_63599_63618[(1)] = (12));

} else {
var statearr_63600_63619 = state_63578__$1;
(statearr_63600_63619[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63579 === (8))){
var inst_63525 = (state_63578[(7)]);
var inst_63527 = (state_63578[(12)]);
var inst_63544 = (state_63578[(15)]);
var inst_63542 = (state_63578[(16)]);
var inst_63521 = (state_63578[(8)]);
var inst_63523 = (state_63578[(9)]);
var inst_63522 = (state_63578[(10)]);
var inst_63524 = (state_63578[(11)]);
var inst_63529 = (state_63578[(13)]);
var inst_63548 = (function (){var flakes = inst_63527;
var rest_blocks = inst_63524;
var curr_block = inst_63523;
var asserted_SINGLEQUOTE_ = inst_63542;
var acc = inst_63525;
var fuel = inst_63521;
var cache = inst_63522;
var retracted = inst_63544;
var asserted = inst_63529;
return (function (p1__63514_SHARP_){
return p1__63514_SHARP_.s;
});
})();
var inst_63549 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_63544);
var inst_63550 = cljs.core.group_by.call(null,inst_63548,inst_63549);
var inst_63551 = cljs.core.vals.call(null,inst_63550);
var inst_63552 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_63522,inst_63521,inst_63551);
var state_63578__$1 = state_63578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63578__$1,(11),inst_63552);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto____0 = (function (){
var statearr_63601 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63601[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto__);

(statearr_63601[(1)] = (1));

return statearr_63601;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto____1 = (function (state_63578){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_63578);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63602){var ex__2744__auto__ = e63602;
var statearr_63603_63620 = state_63578;
(statearr_63603_63620[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_63578[(4)]))){
var statearr_63604_63621 = state_63578;
(statearr_63604_63621[(1)] = cljs.core.first.call(null,(state_63578[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63622 = state_63578;
state_63578 = G__63622;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto__ = function(state_63578){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto____1.call(this,state_63578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63605 = f__2764__auto__.call(null);
(statearr_63605[(6)] = c__2763__auto__);

return statearr_63605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63722){
var state_val_63723 = (state_63722[(1)]);
if((state_val_63723 === (7))){
var inst_63687 = (state_63722[(7)]);
var inst_63694 = (state_63722[(8)]);
var inst_63693 = cljs.core.seq.call(null,inst_63687);
var inst_63694__$1 = cljs.core.first.call(null,inst_63693);
var inst_63695 = cljs.core.next.call(null,inst_63693);
var state_63722__$1 = (function (){var statearr_63724 = state_63722;
(statearr_63724[(8)] = inst_63694__$1);

(statearr_63724[(9)] = inst_63695);

return statearr_63724;
})();
if(cljs.core.truth_(inst_63694__$1)){
var statearr_63725_63762 = state_63722__$1;
(statearr_63725_63762[(1)] = (9));

} else {
var statearr_63726_63763 = state_63722__$1;
(statearr_63726_63763[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63723 === (1))){
var state_63722__$1 = state_63722;
var statearr_63727_63764 = state_63722__$1;
(statearr_63727_63764[(2)] = null);

(statearr_63727_63764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63723 === (4))){
var inst_63624 = (state_63722[(2)]);
var state_63722__$1 = state_63722;
var statearr_63728_63765 = state_63722__$1;
(statearr_63728_63765[(2)] = inst_63624);

(statearr_63728_63765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63723 === (6))){
var inst_63673 = (state_63722[(2)]);
var inst_63674 = fluree.db.util.async.throw_err.call(null,inst_63673);
var inst_63682 = resp;
var inst_63683 = cljs.core.seq.call(null,inst_63682);
var inst_63684 = cljs.core.first.call(null,inst_63683);
var inst_63685 = cljs.core.next.call(null,inst_63683);
var inst_63686 = cljs.core.PersistentHashMap.EMPTY;
var inst_63687 = inst_63682;
var inst_63688 = inst_63686;
var state_63722__$1 = (function (){var statearr_63729 = state_63722;
(statearr_63729[(7)] = inst_63687);

(statearr_63729[(10)] = inst_63674);

(statearr_63729[(11)] = inst_63688);

(statearr_63729[(12)] = inst_63685);

(statearr_63729[(13)] = inst_63684);

return statearr_63729;
})();
var statearr_63730_63766 = state_63722__$1;
(statearr_63730_63766[(2)] = null);

(statearr_63730_63766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63723 === (3))){
var inst_63720 = (state_63722[(2)]);
var state_63722__$1 = state_63722;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63722__$1,inst_63720);
} else {
if((state_val_63723 === (2))){
var _ = (function (){var statearr_63731 = state_63722;
(statearr_63731[(4)] = cljs.core.cons.call(null,(5),(state_63722[(4)])));

return statearr_63731;
})();
var inst_63630 = (function (){return (function (p1__63623_SHARP_){
return p1__63623_SHARP_.t;
});
})();
var inst_63631 = cljs.core.map.call(null,inst_63630,resp);
var inst_63632 = cljs.core.set.call(null,inst_63631);
var inst_63669 = cljs.core.async.chan.call(null,(1));
var inst_63670 = (function (){var ts = inst_63632;
var c__2763__auto____$1 = inst_63669;
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63667){
var state_val_63668 = (state_63667[(1)]);
if((state_val_63668 === (1))){
var inst_63640 = ts;
var inst_63641 = cljs.core.seq.call(null,inst_63640);
var inst_63642 = cljs.core.first.call(null,inst_63641);
var inst_63643 = cljs.core.next.call(null,inst_63641);
var inst_63644 = cljs.core.PersistentHashMap.EMPTY;
var inst_63645 = inst_63640;
var inst_63646 = inst_63644;
var state_63667__$1 = (function (){var statearr_63732 = state_63667;
(statearr_63732[(7)] = inst_63646);

(statearr_63732[(8)] = inst_63645);

(statearr_63732[(9)] = inst_63642);

(statearr_63732[(10)] = inst_63643);

return statearr_63732;
})();
var statearr_63733_63767 = state_63667__$1;
(statearr_63733_63767[(2)] = null);

(statearr_63733_63767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63668 === (2))){
var inst_63652 = (state_63667[(11)]);
var inst_63645 = (state_63667[(8)]);
var inst_63651 = cljs.core.seq.call(null,inst_63645);
var inst_63652__$1 = cljs.core.first.call(null,inst_63651);
var inst_63653 = cljs.core.next.call(null,inst_63651);
var state_63667__$1 = (function (){var statearr_63734 = state_63667;
(statearr_63734[(11)] = inst_63652__$1);

(statearr_63734[(12)] = inst_63653);

return statearr_63734;
})();
if(cljs.core.truth_(inst_63652__$1)){
var statearr_63735_63768 = state_63667__$1;
(statearr_63735_63768[(1)] = (4));

} else {
var statearr_63736_63769 = state_63667__$1;
(statearr_63736_63769[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63668 === (3))){
var inst_63665 = (state_63667[(2)]);
var state_63667__$1 = state_63667;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63667__$1,inst_63665);
} else {
if((state_val_63668 === (4))){
var inst_63652 = (state_63667[(11)]);
var inst_63655 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_63652);
var state_63667__$1 = state_63667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63667__$1,(7),inst_63655);
} else {
if((state_val_63668 === (5))){
var inst_63646 = (state_63667[(7)]);
var state_63667__$1 = state_63667;
var statearr_63737_63770 = state_63667__$1;
(statearr_63737_63770[(2)] = inst_63646);

(statearr_63737_63770[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63668 === (6))){
var inst_63663 = (state_63667[(2)]);
var state_63667__$1 = state_63667;
var statearr_63738_63771 = state_63667__$1;
(statearr_63738_63771[(2)] = inst_63663);

(statearr_63738_63771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63668 === (7))){
var inst_63652 = (state_63667[(11)]);
var inst_63646 = (state_63667[(7)]);
var inst_63653 = (state_63667[(12)]);
var inst_63657 = (state_63667[(2)]);
var inst_63658 = fluree.db.util.async.throw_err.call(null,inst_63657);
var inst_63659 = cljs.core.assoc.call(null,inst_63646,inst_63652,inst_63658);
var inst_63645 = inst_63653;
var inst_63646__$1 = inst_63659;
var state_63667__$1 = (function (){var statearr_63739 = state_63667;
(statearr_63739[(7)] = inst_63646__$1);

(statearr_63739[(8)] = inst_63645);

return statearr_63739;
})();
var statearr_63740_63772 = state_63667__$1;
(statearr_63740_63772[(2)] = null);

(statearr_63740_63772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____0 = (function (){
var statearr_63741 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63741[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__);

(statearr_63741[(1)] = (1));

return statearr_63741;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____1 = (function (state_63667){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_63667);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63742){var ex__2744__auto__ = e63742;
var statearr_63743_63773 = state_63667;
(statearr_63743_63773[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_63667[(4)]))){
var statearr_63744_63774 = state_63667;
(statearr_63744_63774[(1)] = cljs.core.first.call(null,(state_63667[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63775 = state_63667;
state_63667 = G__63775;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__ = function(state_63667){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____1.call(this,state_63667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63745 = f__2764__auto__.call(null);
(statearr_63745[(6)] = c__2763__auto____$1);

return statearr_63745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
});
})();
var inst_63671 = cljs.core.async.impl.dispatch.run.call(null,inst_63670);
var state_63722__$1 = (function (){var statearr_63746 = state_63722;
(statearr_63746[(14)] = inst_63671);

return statearr_63746;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63722__$1,(6),inst_63669);
} else {
if((state_val_63723 === (11))){
var inst_63714 = (state_63722[(2)]);
var state_63722__$1 = state_63722;
var statearr_63748_63776 = state_63722__$1;
(statearr_63748_63776[(2)] = inst_63714);

(statearr_63748_63776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63723 === (9))){
var inst_63674 = (state_63722[(10)]);
var inst_63694 = (state_63722[(8)]);
var inst_63695 = (state_63722[(9)]);
var inst_63688 = (state_63722[(11)]);
var inst_63697 = inst_63694.t;
var inst_63698 = cljs.core.get.call(null,inst_63674,inst_63697);
var inst_63699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63700 = [inst_63698,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_63701 = (new cljs.core.PersistentVector(null,2,(5),inst_63699,inst_63700,null));
var inst_63702 = cljs.core.assoc_in.call(null,inst_63688,inst_63701,inst_63698);
var inst_63703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63704 = [inst_63698,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_63705 = (new cljs.core.PersistentVector(null,2,(5),inst_63703,inst_63704,null));
var inst_63706 = cljs.core.update_in.call(null,inst_63702,inst_63705,cljs.core.conj,inst_63694);
var inst_63707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63708 = [inst_63698,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_63709 = (new cljs.core.PersistentVector(null,2,(5),inst_63707,inst_63708,null));
var inst_63710 = cljs.core.update_in.call(null,inst_63706,inst_63709,fluree.db.api_js.min_safe,inst_63697);
var inst_63687 = inst_63695;
var inst_63688__$1 = inst_63710;
var state_63722__$1 = (function (){var statearr_63749 = state_63722;
(statearr_63749[(7)] = inst_63687);

(statearr_63749[(11)] = inst_63688__$1);

return statearr_63749;
})();
var statearr_63750_63777 = state_63722__$1;
(statearr_63750_63777[(2)] = null);

(statearr_63750_63777[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63723 === (5))){
var _ = (function (){var statearr_63751 = state_63722;
(statearr_63751[(4)] = cljs.core.rest.call(null,(state_63722[(4)])));

return statearr_63751;
})();
var state_63722__$1 = state_63722;
var ex63747 = (state_63722__$1[(2)]);
var statearr_63752_63778 = state_63722__$1;
(statearr_63752_63778[(5)] = ex63747);


if((ex63747 instanceof Error)){
var statearr_63753_63779 = state_63722__$1;
(statearr_63753_63779[(1)] = (4));

(statearr_63753_63779[(5)] = null);

} else {
throw ex63747;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63723 === (10))){
var inst_63688 = (state_63722[(11)]);
var state_63722__$1 = state_63722;
var statearr_63754_63780 = state_63722__$1;
(statearr_63754_63780[(2)] = inst_63688);

(statearr_63754_63780[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63723 === (8))){
var inst_63716 = (state_63722[(2)]);
var inst_63717 = cljs.core.vals.call(null,inst_63716);
var _ = (function (){var statearr_63755 = state_63722;
(statearr_63755[(4)] = cljs.core.rest.call(null,(state_63722[(4)])));

return statearr_63755;
})();
var state_63722__$1 = state_63722;
var statearr_63756_63781 = state_63722__$1;
(statearr_63756_63781[(2)] = inst_63717);

(statearr_63756_63781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____0 = (function (){
var statearr_63757 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63757[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__);

(statearr_63757[(1)] = (1));

return statearr_63757;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____1 = (function (state_63722){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_63722);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63758){var ex__2744__auto__ = e63758;
var statearr_63759_63782 = state_63722;
(statearr_63759_63782[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_63722[(4)]))){
var statearr_63760_63783 = state_63722;
(statearr_63760_63783[(1)] = cljs.core.first.call(null,(state_63722[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63784 = state_63722;
state_63722 = G__63784;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__ = function(state_63722){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____1.call(this,state_63722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63761 = f__2764__auto__.call(null);
(statearr_63761[(6)] = c__2763__auto__);

return statearr_63761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63929){
var state_val_63930 = (state_63929[(1)]);
if((state_val_63930 === (7))){
var inst_63809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63810 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_63811 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_63812 = [inst_63810,inst_63811];
var inst_63813 = (new cljs.core.PersistentVector(null,2,(5),inst_63809,inst_63812,null));
var state_63929__$1 = state_63929;
var statearr_63931_64002 = state_63929__$1;
(statearr_63931_64002[(2)] = inst_63813);

(statearr_63931_64002[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (20))){
var inst_63839 = (state_63929[(7)]);
var state_63929__$1 = state_63929;
var statearr_63932_64003 = state_63929__$1;
(statearr_63932_64003[(2)] = inst_63839);

(statearr_63932_64003[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (27))){
var state_63929__$1 = state_63929;
var statearr_63933_64004 = state_63929__$1;
(statearr_63933_64004[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (1))){
var state_63929__$1 = state_63929;
var statearr_63935_64005 = state_63929__$1;
(statearr_63935_64005[(2)] = null);

(statearr_63935_64005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (24))){
var inst_63838 = (state_63929[(8)]);
var state_63929__$1 = state_63929;
if(cljs.core.truth_(inst_63838)){
var statearr_63936_64006 = state_63929__$1;
(statearr_63936_64006[(1)] = (26));

} else {
var statearr_63937_64007 = state_63929__$1;
(statearr_63937_64007[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (39))){
var inst_63884 = (state_63929[(9)]);
var inst_63885 = (state_63929[(10)]);
var inst_63910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63911 = [inst_63884,inst_63885];
var inst_63912 = (new cljs.core.PersistentVector(null,2,(5),inst_63910,inst_63911,null));
var state_63929__$1 = state_63929;
var statearr_63938_64008 = state_63929__$1;
(statearr_63938_64008[(2)] = inst_63912);

(statearr_63938_64008[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (4))){
var inst_63785 = (state_63929[(2)]);
var inst_63786 = fluree.db.util.log.error.call(null,inst_63785);
var inst_63787 = cljs.core.ex_data.call(null,inst_63785);
var inst_63788 = cljs.core.ex_message.call(null,inst_63785);
var inst_63789 = cljs.core.assoc.call(null,inst_63787,new cljs.core.Keyword(null,"message","message",-406056002),inst_63788);
var state_63929__$1 = (function (){var statearr_63939 = state_63929;
(statearr_63939[(11)] = inst_63786);

return statearr_63939;
})();
var statearr_63940_64009 = state_63929__$1;
(statearr_63940_64009[(2)] = inst_63789);

(statearr_63940_64009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (15))){
var inst_63823 = (state_63929[(12)]);
var inst_63818 = (state_63929[(13)]);
var inst_63832 = (state_63929[(2)]);
var inst_63833 = [inst_63823,inst_63832];
var inst_63834 = (new cljs.core.PersistentVector(null,2,(5),inst_63818,inst_63833,null));
var state_63929__$1 = state_63929;
var statearr_63941_64010 = state_63929__$1;
(statearr_63941_64010[(2)] = inst_63834);

(statearr_63941_64010[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (21))){
var inst_63838 = (state_63929[(8)]);
var state_63929__$1 = state_63929;
var statearr_63942_64011 = state_63929__$1;
(statearr_63942_64011[(2)] = inst_63838);

(statearr_63942_64011[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (31))){
var inst_63879 = (state_63929[(2)]);
var state_63929__$1 = state_63929;
var statearr_63943_64012 = state_63929__$1;
(statearr_63943_64012[(2)] = inst_63879);

(statearr_63943_64012[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (32))){
var inst_63885 = (state_63929[(10)]);
var inst_63888 = cljs.core.pos_int_QMARK_.call(null,inst_63885);
var state_63929__$1 = state_63929;
var statearr_63944_64013 = state_63929__$1;
(statearr_63944_64013[(2)] = inst_63888);

(statearr_63944_64013[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (40))){
var inst_63840 = (state_63929[(14)]);
var inst_63916 = (state_63929[(15)]);
var inst_63914 = (state_63929[(2)]);
var inst_63915 = cljs.core.nth.call(null,inst_63914,(0),null);
var inst_63916__$1 = cljs.core.nth.call(null,inst_63914,(1),null);
var inst_63917 = (inst_63916__$1 > inst_63840);
var state_63929__$1 = (function (){var statearr_63945 = state_63929;
(statearr_63945[(15)] = inst_63916__$1);

(statearr_63945[(16)] = inst_63915);

return statearr_63945;
})();
if(cljs.core.truth_(inst_63917)){
var statearr_63946_64014 = state_63929__$1;
(statearr_63946_64014[(1)] = (41));

} else {
var statearr_63947_64015 = state_63929__$1;
(statearr_63947_64015[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (33))){
var inst_63886 = (state_63929[(17)]);
var state_63929__$1 = state_63929;
var statearr_63948_64016 = state_63929__$1;
(statearr_63948_64016[(2)] = inst_63886);

(statearr_63948_64016[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (13))){
var inst_63824 = (state_63929[(18)]);
var inst_63826 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_63824);
var state_63929__$1 = state_63929;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63929__$1,(16),inst_63826);
} else {
if((state_val_63930 === (22))){
var inst_63857 = (state_63929[(2)]);
var state_63929__$1 = state_63929;
if(cljs.core.truth_(inst_63857)){
var statearr_63949_64017 = state_63929__$1;
(statearr_63949_64017[(1)] = (23));

} else {
var statearr_63950_64018 = state_63929__$1;
(statearr_63950_64018[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (36))){
var state_63929__$1 = state_63929;
var statearr_63951_64019 = state_63929__$1;
(statearr_63951_64019[(2)] = null);

(statearr_63951_64019[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (41))){
var inst_63840 = (state_63929[(14)]);
var state_63929__$1 = state_63929;
var statearr_63952_64020 = state_63929__$1;
(statearr_63952_64020[(2)] = inst_63840);

(statearr_63952_64020[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (43))){
var inst_63915 = (state_63929[(16)]);
var inst_63921 = (state_63929[(2)]);
var inst_63922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63923 = [inst_63915,inst_63921];
var inst_63924 = (new cljs.core.PersistentVector(null,2,(5),inst_63922,inst_63923,null));
var _ = (function (){var statearr_63953 = state_63929;
(statearr_63953[(4)] = cljs.core.rest.call(null,(state_63929[(4)])));

return statearr_63953;
})();
var state_63929__$1 = state_63929;
var statearr_63954_64021 = state_63929__$1;
(statearr_63954_64021[(2)] = inst_63924);

(statearr_63954_64021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (29))){
var inst_63815 = (state_63929[(19)]);
var inst_63870 = cljs.core.pr_str.call(null,inst_63815);
var inst_63871 = ["Invalid block range provided: ",inst_63870].join('');
var inst_63872 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63873 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63874 = cljs.core.PersistentHashMap.fromArrays(inst_63872,inst_63873);
var inst_63875 = cljs.core.ex_info.call(null,inst_63871,inst_63874);
var inst_63876 = (function(){throw inst_63875})();
var state_63929__$1 = state_63929;
var statearr_63955_64022 = state_63929__$1;
(statearr_63955_64022[(2)] = inst_63876);

(statearr_63955_64022[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (6))){
var inst_63807 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_63929__$1 = state_63929;
var statearr_63956_64023 = state_63929__$1;
(statearr_63956_64023[(2)] = inst_63807);

(statearr_63956_64023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (28))){
var inst_63881 = (state_63929[(2)]);
var state_63929__$1 = state_63929;
var statearr_63957_64024 = state_63929__$1;
(statearr_63957_64024[(2)] = inst_63881);

(statearr_63957_64024[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (25))){
var inst_63884 = (state_63929[(9)]);
var inst_63886 = (state_63929[(17)]);
var inst_63883 = (state_63929[(2)]);
var inst_63884__$1 = cljs.core.nth.call(null,inst_63883,(0),null);
var inst_63885 = cljs.core.nth.call(null,inst_63883,(1),null);
var inst_63886__$1 = cljs.core.pos_int_QMARK_.call(null,inst_63884__$1);
var state_63929__$1 = (function (){var statearr_63958 = state_63929;
(statearr_63958[(9)] = inst_63884__$1);

(statearr_63958[(10)] = inst_63885);

(statearr_63958[(17)] = inst_63886__$1);

return statearr_63958;
})();
if(inst_63886__$1){
var statearr_63959_64025 = state_63929__$1;
(statearr_63959_64025[(1)] = (32));

} else {
var statearr_63960_64026 = state_63929__$1;
(statearr_63960_64026[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (34))){
var inst_63891 = (state_63929[(2)]);
var inst_63892 = cljs.core.not.call(null,inst_63891);
var state_63929__$1 = state_63929;
if(inst_63892){
var statearr_63961_64027 = state_63929__$1;
(statearr_63961_64027[(1)] = (35));

} else {
var statearr_63962_64028 = state_63929__$1;
(statearr_63962_64028[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (17))){
var inst_63840 = (state_63929[(14)]);
var inst_63838 = (state_63929[(8)]);
var inst_63843 = cljs.core.pr_str.call(null,inst_63838);
var inst_63844 = cljs.core.pr_str.call(null,inst_63840);
var inst_63845 = ["Start block is out of range for this ledger. Start block provided: ",inst_63843,". Database block: ",inst_63844].join('');
var inst_63846 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63847 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63848 = cljs.core.PersistentHashMap.fromArrays(inst_63846,inst_63847);
var inst_63849 = cljs.core.ex_info.call(null,inst_63845,inst_63848);
var inst_63850 = (function(){throw inst_63849})();
var state_63929__$1 = state_63929;
var statearr_63963_64029 = state_63929__$1;
(statearr_63963_64029[(2)] = inst_63850);

(statearr_63963_64029[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (3))){
var inst_63927 = (state_63929[(2)]);
var state_63929__$1 = state_63929;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63929__$1,inst_63927);
} else {
if((state_val_63930 === (12))){
var inst_63824 = (state_63929[(18)]);
var inst_63815 = (state_63929[(19)]);
var inst_63822 = (state_63929[(2)]);
var inst_63823 = fluree.db.util.async.throw_err.call(null,inst_63822);
var inst_63824__$1 = cljs.core.second.call(null,inst_63815);
var state_63929__$1 = (function (){var statearr_63964 = state_63929;
(statearr_63964[(18)] = inst_63824__$1);

(statearr_63964[(12)] = inst_63823);

return statearr_63964;
})();
if(cljs.core.truth_(inst_63824__$1)){
var statearr_63965_64030 = state_63929__$1;
(statearr_63965_64030[(1)] = (13));

} else {
var statearr_63966_64031 = state_63929__$1;
(statearr_63966_64031[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (2))){
var _ = (function (){var statearr_63967 = state_63929;
(statearr_63967[(4)] = cljs.core.cons.call(null,(5),(state_63929[(4)])));

return statearr_63967;
})();
var inst_63804 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_63805 = cljs.core.sequential_QMARK_.call(null,inst_63804);
var state_63929__$1 = state_63929;
if(inst_63805){
var statearr_63968_64032 = state_63929__$1;
(statearr_63968_64032[(1)] = (6));

} else {
var statearr_63969_64033 = state_63929__$1;
(statearr_63969_64033[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (23))){
var inst_63838 = (state_63929[(8)]);
var inst_63839 = (state_63929[(7)]);
var inst_63859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63860 = [inst_63838,inst_63839];
var inst_63861 = (new cljs.core.PersistentVector(null,2,(5),inst_63859,inst_63860,null));
var state_63929__$1 = state_63929;
var statearr_63970_64034 = state_63929__$1;
(statearr_63970_64034[(2)] = inst_63861);

(statearr_63970_64034[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (35))){
var inst_63815 = (state_63929[(19)]);
var inst_63894 = cljs.core.pr_str.call(null,inst_63815);
var inst_63895 = ["Invalid block range provided: ",inst_63894].join('');
var inst_63896 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63897 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63898 = cljs.core.PersistentHashMap.fromArrays(inst_63896,inst_63897);
var inst_63899 = cljs.core.ex_info.call(null,inst_63895,inst_63898);
var inst_63900 = (function(){throw inst_63899})();
var state_63929__$1 = state_63929;
var statearr_63971_64035 = state_63929__$1;
(statearr_63971_64035[(2)] = inst_63900);

(statearr_63971_64035[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (19))){
var inst_63838 = (state_63929[(8)]);
var inst_63853 = (state_63929[(2)]);
var state_63929__$1 = (function (){var statearr_63972 = state_63929;
(statearr_63972[(20)] = inst_63853);

return statearr_63972;
})();
if(cljs.core.truth_(inst_63838)){
var statearr_63973_64036 = state_63929__$1;
(statearr_63973_64036[(1)] = (20));

} else {
var statearr_63974_64037 = state_63929__$1;
(statearr_63974_64037[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (11))){
var inst_63840 = (state_63929[(14)]);
var inst_63838 = (state_63929[(8)]);
var inst_63837 = (state_63929[(2)]);
var inst_63838__$1 = cljs.core.nth.call(null,inst_63837,(0),null);
var inst_63839 = cljs.core.nth.call(null,inst_63837,(1),null);
var inst_63840__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_63841 = (inst_63838__$1 > inst_63840__$1);
var state_63929__$1 = (function (){var statearr_63976 = state_63929;
(statearr_63976[(14)] = inst_63840__$1);

(statearr_63976[(8)] = inst_63838__$1);

(statearr_63976[(7)] = inst_63839);

return statearr_63976;
})();
if(cljs.core.truth_(inst_63841)){
var statearr_63977_64038 = state_63929__$1;
(statearr_63977_64038[(1)] = (17));

} else {
var statearr_63978_64039 = state_63929__$1;
(statearr_63978_64039[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (9))){
var inst_63815 = (state_63929[(19)]);
var inst_63818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63819 = cljs.core.first.call(null,inst_63815);
var inst_63820 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_63819);
var state_63929__$1 = (function (){var statearr_63979 = state_63929;
(statearr_63979[(13)] = inst_63818);

return statearr_63979;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63929__$1,(12),inst_63820);
} else {
if((state_val_63930 === (5))){
var _ = (function (){var statearr_63980 = state_63929;
(statearr_63980[(4)] = cljs.core.rest.call(null,(state_63929[(4)])));

return statearr_63980;
})();
var state_63929__$1 = state_63929;
var ex63975 = (state_63929__$1[(2)]);
var statearr_63981_64040 = state_63929__$1;
(statearr_63981_64040[(5)] = ex63975);


var statearr_63982_64041 = state_63929__$1;
(statearr_63982_64041[(1)] = (4));

(statearr_63982_64041[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (14))){
var state_63929__$1 = state_63929;
var statearr_63983_64042 = state_63929__$1;
(statearr_63983_64042[(2)] = null);

(statearr_63983_64042[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (26))){
var inst_63838 = (state_63929[(8)]);
var inst_63864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63865 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_63866 = [inst_63838,inst_63865];
var inst_63867 = (new cljs.core.PersistentVector(null,2,(5),inst_63864,inst_63866,null));
var state_63929__$1 = state_63929;
var statearr_63984_64043 = state_63929__$1;
(statearr_63984_64043[(2)] = inst_63867);

(statearr_63984_64043[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (16))){
var inst_63828 = (state_63929[(2)]);
var inst_63829 = fluree.db.util.async.throw_err.call(null,inst_63828);
var state_63929__$1 = state_63929;
var statearr_63985_64044 = state_63929__$1;
(statearr_63985_64044[(2)] = inst_63829);

(statearr_63985_64044[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (38))){
var inst_63884 = (state_63929[(9)]);
var inst_63885 = (state_63929[(10)]);
var inst_63906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63907 = [inst_63885,inst_63884];
var inst_63908 = (new cljs.core.PersistentVector(null,2,(5),inst_63906,inst_63907,null));
var state_63929__$1 = state_63929;
var statearr_63986_64045 = state_63929__$1;
(statearr_63986_64045[(2)] = inst_63908);

(statearr_63986_64045[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (30))){
var state_63929__$1 = state_63929;
var statearr_63987_64046 = state_63929__$1;
(statearr_63987_64046[(2)] = null);

(statearr_63987_64046[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (10))){
var inst_63815 = (state_63929[(19)]);
var state_63929__$1 = state_63929;
var statearr_63988_64047 = state_63929__$1;
(statearr_63988_64047[(2)] = inst_63815);

(statearr_63988_64047[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (18))){
var state_63929__$1 = state_63929;
var statearr_63989_64048 = state_63929__$1;
(statearr_63989_64048[(2)] = null);

(statearr_63989_64048[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (42))){
var inst_63916 = (state_63929[(15)]);
var state_63929__$1 = state_63929;
var statearr_63990_64049 = state_63929__$1;
(statearr_63990_64049[(2)] = inst_63916);

(statearr_63990_64049[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (37))){
var inst_63884 = (state_63929[(9)]);
var inst_63885 = (state_63929[(10)]);
var inst_63903 = (state_63929[(2)]);
var inst_63904 = (inst_63885 < inst_63884);
var state_63929__$1 = (function (){var statearr_63991 = state_63929;
(statearr_63991[(21)] = inst_63903);

return statearr_63991;
})();
if(cljs.core.truth_(inst_63904)){
var statearr_63992_64050 = state_63929__$1;
(statearr_63992_64050[(1)] = (38));

} else {
var statearr_63993_64051 = state_63929__$1;
(statearr_63993_64051[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63930 === (8))){
var inst_63815 = (state_63929[(19)]);
var inst_63815__$1 = (state_63929[(2)]);
var inst_63816 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_63815__$1);
var state_63929__$1 = (function (){var statearr_63994 = state_63929;
(statearr_63994[(19)] = inst_63815__$1);

return statearr_63994;
})();
if(cljs.core.truth_(inst_63816)){
var statearr_63995_64052 = state_63929__$1;
(statearr_63995_64052[(1)] = (9));

} else {
var statearr_63996_64053 = state_63929__$1;
(statearr_63996_64053[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto____0 = (function (){
var statearr_63997 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63997[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto__);

(statearr_63997[(1)] = (1));

return statearr_63997;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto____1 = (function (state_63929){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_63929);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63998){var ex__2744__auto__ = e63998;
var statearr_63999_64054 = state_63929;
(statearr_63999_64054[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_63929[(4)]))){
var statearr_64000_64055 = state_63929;
(statearr_64000_64055[(1)] = cljs.core.first.call(null,(state_63929[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64056 = state_63929;
state_63929 = G__64056;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto__ = function(state_63929){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto____1.call(this,state_63929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_64001 = f__2764__auto__.call(null);
(statearr_64001[(6)] = c__2763__auto__);

return statearr_64001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__64058 = arguments.length;
switch (G__64058) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_64149){
var state_val_64150 = (state_64149[(1)]);
if((state_val_64150 === (7))){
var inst_64081 = (state_64149[(7)]);
var inst_64084 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_64081);
var state_64149__$1 = state_64149;
var statearr_64151_64202 = state_64149__$1;
(statearr_64151_64202[(2)] = inst_64084);

(statearr_64151_64202[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (20))){
var inst_64120 = (state_64149[(8)]);
var inst_64123 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_64120);
var state_64149__$1 = state_64149;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64149__$1,(23),inst_64123);
} else {
if((state_val_64150 === (27))){
var inst_64129 = (state_64149[(9)]);
var inst_64135 = cljs.core.doall.call(null,inst_64129);
var state_64149__$1 = state_64149;
var statearr_64152_64203 = state_64149__$1;
(statearr_64152_64203[(2)] = inst_64135);

(statearr_64152_64203[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (1))){
var state_64149__$1 = state_64149;
var statearr_64153_64204 = state_64149__$1;
(statearr_64153_64204[(2)] = null);

(statearr_64153_64204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (24))){
var inst_64129 = (state_64149[(9)]);
var inst_64132 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_64133 = cljs.core.sequential_QMARK_.call(null,inst_64129);
var state_64149__$1 = (function (){var statearr_64154 = state_64149;
(statearr_64154[(10)] = inst_64132);

return statearr_64154;
})();
if(inst_64133){
var statearr_64155_64205 = state_64149__$1;
(statearr_64155_64205[(1)] = (27));

} else {
var statearr_64156_64206 = state_64149__$1;
(statearr_64156_64206[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (4))){
var inst_64059 = (state_64149[(2)]);
var inst_64060 = fluree.db.util.log.error.call(null,inst_64059);
var inst_64061 = cljs.core.ex_data.call(null,inst_64059);
var inst_64062 = cljs.core.ex_message.call(null,inst_64059);
var inst_64063 = cljs.core.assoc.call(null,inst_64061,new cljs.core.Keyword(null,"message","message",-406056002),inst_64062);
var state_64149__$1 = (function (){var statearr_64157 = state_64149;
(statearr_64157[(11)] = inst_64060);

return statearr_64157;
})();
var statearr_64158_64207 = state_64149__$1;
(statearr_64158_64207[(2)] = inst_64063);

(statearr_64158_64207[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (15))){
var inst_64081 = (state_64149[(7)]);
var inst_64094 = (state_64149[(2)]);
var inst_64095 = cljs.core.ex_info.call(null,inst_64094,inst_64081);
var inst_64096 = (function(){throw inst_64095})();
var state_64149__$1 = state_64149;
var statearr_64159_64208 = state_64149__$1;
(statearr_64159_64208[(2)] = inst_64096);

(statearr_64159_64208[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (21))){
var inst_64120 = (state_64149[(8)]);
var state_64149__$1 = state_64149;
var statearr_64160_64209 = state_64149__$1;
(statearr_64160_64209[(2)] = inst_64120);

(statearr_64160_64209[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (13))){
var inst_64089 = (state_64149[(12)]);
var state_64149__$1 = state_64149;
var statearr_64161_64210 = state_64149__$1;
(statearr_64161_64210[(2)] = inst_64089);

(statearr_64161_64210[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (22))){
var inst_64129 = (state_64149[(2)]);
var inst_64130 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_64149__$1 = (function (){var statearr_64162 = state_64149;
(statearr_64162[(9)] = inst_64129);

return statearr_64162;
})();
if(cljs.core.truth_(inst_64130)){
var statearr_64163_64211 = state_64149__$1;
(statearr_64163_64211[(1)] = (24));

} else {
var statearr_64164_64212 = state_64149__$1;
(statearr_64164_64212[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (29))){
var inst_64073 = (state_64149[(13)]);
var inst_64132 = (state_64149[(10)]);
var inst_64138 = (state_64149[(2)]);
var inst_64139 = fluree.db.util.core.response_time_formatted.call(null,inst_64073);
var inst_64140 = [(200),inst_64138,(100),inst_64139];
var inst_64141 = cljs.core.PersistentHashMap.fromArrays(inst_64132,inst_64140);
var state_64149__$1 = state_64149;
var statearr_64165_64213 = state_64149__$1;
(statearr_64165_64213[(2)] = inst_64141);

(statearr_64165_64213[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (6))){
var inst_64081 = (state_64149[(7)]);
var inst_64082 = (state_64149[(14)]);
var inst_64080 = (state_64149[(2)]);
var inst_64081__$1 = fluree.db.util.async.throw_err.call(null,inst_64080);
var inst_64082__$1 = cljs.core.map_QMARK_.call(null,inst_64081__$1);
var state_64149__$1 = (function (){var statearr_64166 = state_64149;
(statearr_64166[(7)] = inst_64081__$1);

(statearr_64166[(14)] = inst_64082__$1);

return statearr_64166;
})();
if(inst_64082__$1){
var statearr_64167_64214 = state_64149__$1;
(statearr_64167_64214[(1)] = (7));

} else {
var statearr_64168_64215 = state_64149__$1;
(statearr_64168_64215[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (28))){
var inst_64129 = (state_64149[(9)]);
var state_64149__$1 = state_64149;
var statearr_64169_64216 = state_64149__$1;
(statearr_64169_64216[(2)] = inst_64129);

(statearr_64169_64216[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (25))){
var inst_64129 = (state_64149[(9)]);
var state_64149__$1 = state_64149;
var statearr_64170_64217 = state_64149__$1;
(statearr_64170_64217[(2)] = inst_64129);

(statearr_64170_64217[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (17))){
var inst_64112 = cljs.core.pr_str.call(null,query_map);
var inst_64113 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_64112].join('');
var inst_64114 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64115 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64116 = cljs.core.PersistentHashMap.fromArrays(inst_64114,inst_64115);
var inst_64117 = cljs.core.ex_info.call(null,inst_64113,inst_64116);
var inst_64118 = (function(){throw inst_64117})();
var state_64149__$1 = state_64149;
var statearr_64171_64218 = state_64149__$1;
(statearr_64171_64218[(2)] = inst_64118);

(statearr_64171_64218[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (3))){
var inst_64147 = (state_64149[(2)]);
var state_64149__$1 = state_64149;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64149__$1,inst_64147);
} else {
if((state_val_64150 === (12))){
var inst_64081 = (state_64149[(7)]);
var inst_64099 = (state_64149[(2)]);
var inst_64100 = cljs.core.nth.call(null,inst_64081,(0),null);
var inst_64101 = cljs.core.nth.call(null,inst_64081,(1),null);
var inst_64102 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_64103 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_64104 = cljs.core.keys.call(null,inst_64103);
var inst_64105 = cljs.core._EQ_.call(null,inst_64102,inst_64104);
var state_64149__$1 = (function (){var statearr_64172 = state_64149;
(statearr_64172[(15)] = inst_64100);

(statearr_64172[(16)] = inst_64099);

(statearr_64172[(17)] = inst_64101);

return statearr_64172;
})();
if(inst_64105){
var statearr_64173_64219 = state_64149__$1;
(statearr_64173_64219[(1)] = (16));

} else {
var statearr_64174_64220 = state_64149__$1;
(statearr_64174_64220[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (2))){
var _ = (function (){var statearr_64175 = state_64149;
(statearr_64175[(4)] = cljs.core.cons.call(null,(5),(state_64149[(4)])));

return statearr_64175;
})();
var inst_64073 = fluree.db.util.core.current_time_millis.call(null);
var inst_64074 = db;
var inst_64075 = cljs.core.__destructure_map.call(null,inst_64074);
var inst_64076 = cljs.core.get.call(null,inst_64075,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_64077 = cljs.core.get.call(null,inst_64075,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_64078 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_64149__$1 = (function (){var statearr_64176 = state_64149;
(statearr_64176[(13)] = inst_64073);

(statearr_64176[(18)] = inst_64076);

(statearr_64176[(19)] = inst_64077);

return statearr_64176;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64149__$1,(6),inst_64078);
} else {
if((state_val_64150 === (23))){
var inst_64125 = (state_64149[(2)]);
var inst_64126 = fluree.db.util.async.throw_err.call(null,inst_64125);
var state_64149__$1 = state_64149;
var statearr_64177_64221 = state_64149__$1;
(statearr_64177_64221[(2)] = inst_64126);

(statearr_64177_64221[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (19))){
var inst_64109 = (state_64149[(2)]);
var inst_64110 = fluree.db.util.async.throw_err.call(null,inst_64109);
var state_64149__$1 = state_64149;
var statearr_64178_64222 = state_64149__$1;
(statearr_64178_64222[(2)] = inst_64110);

(statearr_64178_64222[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (11))){
var state_64149__$1 = state_64149;
var statearr_64180_64223 = state_64149__$1;
(statearr_64180_64223[(2)] = null);

(statearr_64180_64223[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (9))){
var inst_64087 = (state_64149[(2)]);
var state_64149__$1 = state_64149;
if(cljs.core.truth_(inst_64087)){
var statearr_64181_64224 = state_64149__$1;
(statearr_64181_64224[(1)] = (10));

} else {
var statearr_64182_64225 = state_64149__$1;
(statearr_64182_64225[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (5))){
var _ = (function (){var statearr_64183 = state_64149;
(statearr_64183[(4)] = cljs.core.rest.call(null,(state_64149[(4)])));

return statearr_64183;
})();
var state_64149__$1 = state_64149;
var ex64179 = (state_64149__$1[(2)]);
var statearr_64184_64226 = state_64149__$1;
(statearr_64184_64226[(5)] = ex64179);


var statearr_64185_64227 = state_64149__$1;
(statearr_64185_64227[(1)] = (4));

(statearr_64185_64227[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (14))){
var inst_64076 = (state_64149[(18)]);
var inst_64077 = (state_64149[(19)]);
var inst_64092 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64076),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64077)].join('');
var state_64149__$1 = state_64149;
var statearr_64186_64228 = state_64149__$1;
(statearr_64186_64228[(2)] = inst_64092);

(statearr_64186_64228[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (26))){
var inst_64144 = (state_64149[(2)]);
var _ = (function (){var statearr_64187 = state_64149;
(statearr_64187[(4)] = cljs.core.rest.call(null,(state_64149[(4)])));

return statearr_64187;
})();
var state_64149__$1 = state_64149;
var statearr_64188_64229 = state_64149__$1;
(statearr_64188_64229[(2)] = inst_64144);

(statearr_64188_64229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (16))){
var inst_64100 = (state_64149[(15)]);
var inst_64101 = (state_64149[(17)]);
var inst_64107 = fluree.db.query.block.block_range.call(null,db,inst_64100,inst_64101,opts);
var state_64149__$1 = state_64149;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64149__$1,(19),inst_64107);
} else {
if((state_val_64150 === (10))){
var inst_64081 = (state_64149[(7)]);
var inst_64089 = (state_64149[(12)]);
var inst_64089__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_64081);
var state_64149__$1 = (function (){var statearr_64189 = state_64149;
(statearr_64189[(12)] = inst_64089__$1);

return statearr_64189;
})();
if(cljs.core.truth_(inst_64089__$1)){
var statearr_64190_64230 = state_64149__$1;
(statearr_64190_64230[(1)] = (13));

} else {
var statearr_64191_64231 = state_64149__$1;
(statearr_64191_64231[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (18))){
var inst_64120 = (state_64149[(2)]);
var inst_64121 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_64149__$1 = (function (){var statearr_64192 = state_64149;
(statearr_64192[(8)] = inst_64120);

return statearr_64192;
})();
if(cljs.core.truth_(inst_64121)){
var statearr_64193_64232 = state_64149__$1;
(statearr_64193_64232[(1)] = (20));

} else {
var statearr_64194_64233 = state_64149__$1;
(statearr_64194_64233[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64150 === (8))){
var inst_64082 = (state_64149[(14)]);
var state_64149__$1 = state_64149;
var statearr_64195_64234 = state_64149__$1;
(statearr_64195_64234[(2)] = inst_64082);

(statearr_64195_64234[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_64196 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64196[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_64196[(1)] = (1));

return statearr_64196;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_64149){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_64149);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e64197){var ex__2744__auto__ = e64197;
var statearr_64198_64235 = state_64149;
(statearr_64198_64235[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_64149[(4)]))){
var statearr_64199_64236 = state_64149;
(statearr_64199_64236[(1)] = cljs.core.first.call(null,(state_64149[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64237 = state_64149;
state_64149 = G__64237;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_64149){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_64149);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_64200 = f__2764__auto__.call(null);
(statearr_64200[(6)] = c__2763__auto__);

return statearr_64200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__64239 = arguments.length;
switch (G__64239) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_64434){
var state_val_64435 = (state_64434[(1)]);
if((state_val_64435 === (62))){
var inst_64432 = (state_64434[(2)]);
var state_64434__$1 = state_64434;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64434__$1,inst_64432);
} else {
if((state_val_64435 === (7))){
var inst_64260 = (state_64434[(7)]);
var inst_64270 = cljs.core.not_EQ_.call(null,(1),inst_64260);
var state_64434__$1 = state_64434;
var statearr_64436_64527 = state_64434__$1;
(statearr_64436_64527[(2)] = inst_64270);

(statearr_64436_64527[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (59))){
var inst_64420 = (state_64434[(2)]);
var inst_64421 = fluree.db.util.async.throw_err.call(null,inst_64420);
var state_64434__$1 = state_64434;
var statearr_64437_64528 = state_64434__$1;
(statearr_64437_64528[(2)] = inst_64421);

(statearr_64437_64528[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (20))){
var inst_64328 = (state_64434[(8)]);
var inst_64336 = (state_64434[(9)]);
var inst_64328__$1 = (state_64434[(2)]);
var inst_64329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64330 = cljs.core.get.call(null,inst_64328__$1,(0));
var inst_64331 = cljs.core.get.call(null,inst_64328__$1,(1));
var inst_64332 = cljs.core.get.call(null,inst_64328__$1,(2));
var inst_64333 = cljs.core.get.call(null,inst_64328__$1,(3));
var inst_64334 = [inst_64330,inst_64331,inst_64332,inst_64333];
var inst_64335 = (new cljs.core.PersistentVector(null,4,(5),inst_64329,inst_64334,null));
var inst_64336__$1 = cljs.core.nth.call(null,inst_64335,(0),null);
var inst_64337 = cljs.core.nth.call(null,inst_64335,(1),null);
var inst_64338 = cljs.core.nth.call(null,inst_64335,(2),null);
var inst_64339 = cljs.core.nth.call(null,inst_64335,(3),null);
var inst_64340 = (inst_64336__$1 == null);
var inst_64341 = cljs.core.not.call(null,inst_64340);
var state_64434__$1 = (function (){var statearr_64438 = state_64434;
(statearr_64438[(10)] = inst_64338);

(statearr_64438[(11)] = inst_64337);

(statearr_64438[(12)] = inst_64339);

(statearr_64438[(8)] = inst_64328__$1);

(statearr_64438[(9)] = inst_64336__$1);

return statearr_64438;
})();
if(inst_64341){
var statearr_64439_64529 = state_64434__$1;
(statearr_64439_64529[(1)] = (30));

} else {
var statearr_64440_64530 = state_64434__$1;
(statearr_64440_64530[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (58))){
var inst_64268 = (state_64434[(13)]);
var inst_64424 = (state_64434[(2)]);
var state_64434__$1 = (function (){var statearr_64441 = state_64434;
(statearr_64441[(14)] = inst_64424);

return statearr_64441;
})();
if(cljs.core.truth_(inst_64268)){
var statearr_64442_64531 = state_64434__$1;
(statearr_64442_64531[(1)] = (60));

} else {
var statearr_64443_64532 = state_64434__$1;
(statearr_64443_64532[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (60))){
var inst_64412 = (state_64434[(15)]);
var inst_64424 = (state_64434[(14)]);
var inst_64426 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_64427 = cljs.core.count.call(null,inst_64412);
var inst_64428 = [inst_64424,inst_64427,(200)];
var inst_64429 = cljs.core.PersistentHashMap.fromArrays(inst_64426,inst_64428);
var state_64434__$1 = state_64434;
var statearr_64444_64533 = state_64434__$1;
(statearr_64444_64533[(2)] = inst_64429);

(statearr_64444_64533[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (27))){
var inst_64247 = (state_64434[(16)]);
var inst_64316 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64247)].join('');
var inst_64317 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64318 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64319 = cljs.core.PersistentHashMap.fromArrays(inst_64317,inst_64318);
var inst_64320 = cljs.core.ex_info.call(null,inst_64316,inst_64319);
var inst_64321 = (function(){throw inst_64320})();
var state_64434__$1 = state_64434;
var statearr_64445_64534 = state_64434__$1;
(statearr_64445_64534[(2)] = inst_64321);

(statearr_64445_64534[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (1))){
var inst_64244 = query_map;
var inst_64245 = cljs.core.__destructure_map.call(null,inst_64244);
var inst_64246 = cljs.core.get.call(null,inst_64245,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64247 = cljs.core.get.call(null,inst_64245,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_64248 = cljs.core.get.call(null,inst_64245,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_64434__$1 = (function (){var statearr_64446 = state_64434;
(statearr_64446[(17)] = inst_64246);

(statearr_64446[(16)] = inst_64247);

(statearr_64446[(18)] = inst_64248);

return statearr_64446;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64434__$1,(2),sources);
} else {
if((state_val_64435 === (24))){
var inst_64247 = (state_64434[(16)]);
var inst_64305 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64247)].join('');
var inst_64306 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64307 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64308 = cljs.core.PersistentHashMap.fromArrays(inst_64306,inst_64307);
var inst_64309 = cljs.core.ex_info.call(null,inst_64305,inst_64308);
var inst_64310 = (function(){throw inst_64309})();
var state_64434__$1 = state_64434;
var statearr_64447_64535 = state_64434__$1;
(statearr_64447_64535[(2)] = inst_64310);

(statearr_64447_64535[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (55))){
var inst_64248 = (state_64434[(18)]);
var inst_64415 = (state_64434[(2)]);
var inst_64416 = fluree.db.util.async.throw_err.call(null,inst_64415);
var state_64434__$1 = (function (){var statearr_64448 = state_64434;
(statearr_64448[(19)] = inst_64416);

return statearr_64448;
})();
if(cljs.core.truth_(inst_64248)){
var statearr_64449_64536 = state_64434__$1;
(statearr_64449_64536[(1)] = (56));

} else {
var statearr_64450_64537 = state_64434__$1;
(statearr_64450_64537[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (39))){
var inst_64338 = (state_64434[(10)]);
var inst_64337 = (state_64434[(11)]);
var inst_64339 = (state_64434[(12)]);
var inst_64336 = (state_64434[(9)]);
var inst_64360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64362 = [inst_64337,inst_64336,inst_64338,inst_64339];
var inst_64363 = (new cljs.core.PersistentVector(null,4,(5),inst_64361,inst_64362,null));
var inst_64364 = [inst_64363,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_64365 = (new cljs.core.PersistentVector(null,2,(5),inst_64360,inst_64364,null));
var state_64434__$1 = state_64434;
var statearr_64451_64538 = state_64434__$1;
(statearr_64451_64538[(2)] = inst_64365);

(statearr_64451_64538[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (46))){
var inst_64370 = (state_64434[(20)]);
var state_64434__$1 = state_64434;
var statearr_64452_64539 = state_64434__$1;
(statearr_64452_64539[(2)] = inst_64370);

(statearr_64452_64539[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (4))){
var state_64434__$1 = state_64434;
var statearr_64453_64540 = state_64434__$1;
(statearr_64453_64540[(2)] = null);

(statearr_64453_64540[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (54))){
var inst_64251 = (state_64434[(21)]);
var inst_64412 = (state_64434[(15)]);
var inst_64411 = (state_64434[(2)]);
var inst_64412__$1 = fluree.db.util.async.throw_err.call(null,inst_64411);
var inst_64413 = fluree.db.api_js.format_history_resp.call(null,inst_64251,inst_64412__$1);
var state_64434__$1 = (function (){var statearr_64454 = state_64434;
(statearr_64454[(15)] = inst_64412__$1);

return statearr_64454;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64434__$1,(55),inst_64413);
} else {
if((state_val_64435 === (15))){
var inst_64251 = (state_64434[(21)]);
var inst_64292 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64251);
var state_64434__$1 = state_64434;
var statearr_64455_64541 = state_64434__$1;
(statearr_64455_64541[(2)] = inst_64292);

(statearr_64455_64541[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (48))){
var inst_64338 = (state_64434[(10)]);
var inst_64337 = (state_64434[(11)]);
var inst_64339 = (state_64434[(12)]);
var inst_64336 = (state_64434[(9)]);
var inst_64381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64383 = [inst_64337,inst_64338,inst_64336,inst_64339];
var inst_64384 = (new cljs.core.PersistentVector(null,4,(5),inst_64382,inst_64383,null));
var inst_64385 = [inst_64384,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_64386 = (new cljs.core.PersistentVector(null,2,(5),inst_64381,inst_64385,null));
var state_64434__$1 = state_64434;
var statearr_64456_64542 = state_64434__$1;
(statearr_64456_64542[(2)] = inst_64386);

(statearr_64456_64542[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (50))){
var inst_64399 = (state_64434[(2)]);
var state_64434__$1 = state_64434;
var statearr_64457_64543 = state_64434__$1;
(statearr_64457_64543[(2)] = inst_64399);

(statearr_64457_64543[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (21))){
var inst_64247 = (state_64434[(16)]);
var inst_64303 = cljs.core.empty_QMARK_.call(null,inst_64247);
var state_64434__$1 = state_64434;
if(inst_64303){
var statearr_64458_64544 = state_64434__$1;
(statearr_64458_64544[(1)] = (24));

} else {
var statearr_64459_64545 = state_64434__$1;
(statearr_64459_64545[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (31))){
var inst_64347 = (state_64434[(22)]);
var inst_64336 = (state_64434[(9)]);
var inst_64347__$1 = (inst_64336 == null);
var state_64434__$1 = (function (){var statearr_64460 = state_64434;
(statearr_64460[(22)] = inst_64347__$1);

return statearr_64460;
})();
if(cljs.core.truth_(inst_64347__$1)){
var statearr_64461_64546 = state_64434__$1;
(statearr_64461_64546[(1)] = (33));

} else {
var statearr_64462_64547 = state_64434__$1;
(statearr_64462_64547[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (32))){
var inst_64284 = (state_64434[(23)]);
var inst_64294 = (state_64434[(24)]);
var inst_64251 = (state_64434[(21)]);
var inst_64403 = (state_64434[(2)]);
var inst_64404 = cljs.core.nth.call(null,inst_64403,(0),null);
var inst_64405 = cljs.core.nth.call(null,inst_64403,(1),null);
var inst_64406 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_64407 = [inst_64284,inst_64294];
var inst_64408 = cljs.core.PersistentHashMap.fromArrays(inst_64406,inst_64407);
var inst_64409 = fluree.db.query.range.time_range.call(null,inst_64251,inst_64405,cljs.core._EQ_,inst_64404,inst_64408);
var state_64434__$1 = state_64434;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64434__$1,(54),inst_64409);
} else {
if((state_val_64435 === (40))){
var inst_64367 = (state_64434[(25)]);
var inst_64336 = (state_64434[(9)]);
var inst_64367__$1 = (inst_64336 == null);
var state_64434__$1 = (function (){var statearr_64463 = state_64434;
(statearr_64463[(25)] = inst_64367__$1);

return statearr_64463;
})();
if(cljs.core.truth_(inst_64367__$1)){
var statearr_64464_64548 = state_64434__$1;
(statearr_64464_64548[(1)] = (42));

} else {
var statearr_64465_64549 = state_64434__$1;
(statearr_64465_64549[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (56))){
var inst_64416 = (state_64434[(19)]);
var inst_64251 = (state_64434[(21)]);
var inst_64418 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_64251,inst_64416);
var state_64434__$1 = state_64434;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64434__$1,(59),inst_64418);
} else {
if((state_val_64435 === (33))){
var inst_64337 = (state_64434[(11)]);
var inst_64350 = (state_64434[(26)]);
var inst_64349 = (inst_64337 == null);
var inst_64350__$1 = cljs.core.not.call(null,inst_64349);
var state_64434__$1 = (function (){var statearr_64466 = state_64434;
(statearr_64466[(26)] = inst_64350__$1);

return statearr_64466;
})();
if(inst_64350__$1){
var statearr_64467_64550 = state_64434__$1;
(statearr_64467_64550[(1)] = (36));

} else {
var statearr_64468_64551 = state_64434__$1;
(statearr_64468_64551[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (13))){
var inst_64278 = (state_64434[(2)]);
var inst_64279 = fluree.db.util.async.throw_err.call(null,inst_64278);
var inst_64280 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64279);
var inst_64281 = (inst_64280 - (1));
var state_64434__$1 = state_64434;
var statearr_64469_64552 = state_64434__$1;
(statearr_64469_64552[(2)] = inst_64281);

(statearr_64469_64552[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (22))){
var state_64434__$1 = state_64434;
var statearr_64470_64553 = state_64434__$1;
(statearr_64470_64553[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (36))){
var inst_64338 = (state_64434[(10)]);
var inst_64352 = (inst_64338 == null);
var state_64434__$1 = state_64434;
var statearr_64472_64554 = state_64434__$1;
(statearr_64472_64554[(2)] = inst_64352);

(statearr_64472_64554[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (41))){
var inst_64401 = (state_64434[(2)]);
var state_64434__$1 = state_64434;
var statearr_64473_64555 = state_64434__$1;
(statearr_64473_64555[(2)] = inst_64401);

(statearr_64473_64555[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (43))){
var inst_64367 = (state_64434[(25)]);
var state_64434__$1 = state_64434;
var statearr_64474_64556 = state_64434__$1;
(statearr_64474_64556[(2)] = inst_64367);

(statearr_64474_64556[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (61))){
var inst_64424 = (state_64434[(14)]);
var state_64434__$1 = state_64434;
var statearr_64475_64557 = state_64434__$1;
(statearr_64475_64557[(2)] = inst_64424);

(statearr_64475_64557[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (29))){
var inst_64324 = (state_64434[(2)]);
var state_64434__$1 = state_64434;
var statearr_64476_64558 = state_64434__$1;
(statearr_64476_64558[(2)] = inst_64324);

(statearr_64476_64558[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (44))){
var inst_64379 = (state_64434[(2)]);
var state_64434__$1 = state_64434;
if(cljs.core.truth_(inst_64379)){
var statearr_64477_64559 = state_64434__$1;
(statearr_64477_64559[(1)] = (48));

} else {
var statearr_64478_64560 = state_64434__$1;
(statearr_64478_64560[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (6))){
var inst_64255 = (state_64434[(2)]);
var inst_64256 = fluree.db.util.async.throw_err.call(null,inst_64255);
var state_64434__$1 = state_64434;
var statearr_64479_64561 = state_64434__$1;
(statearr_64479_64561[(2)] = inst_64256);

(statearr_64479_64561[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (28))){
var state_64434__$1 = state_64434;
var statearr_64480_64562 = state_64434__$1;
(statearr_64480_64562[(2)] = null);

(statearr_64480_64562[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (51))){
var inst_64247 = (state_64434[(16)]);
var inst_64389 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64247)].join('');
var inst_64390 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64391 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64392 = cljs.core.PersistentHashMap.fromArrays(inst_64390,inst_64391);
var inst_64393 = cljs.core.ex_info.call(null,inst_64389,inst_64392);
var inst_64394 = (function(){throw inst_64393})();
var state_64434__$1 = state_64434;
var statearr_64481_64563 = state_64434__$1;
(statearr_64481_64563[(2)] = inst_64394);

(statearr_64481_64563[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (25))){
var inst_64247 = (state_64434[(16)]);
var state_64434__$1 = state_64434;
var statearr_64482_64564 = state_64434__$1;
(statearr_64482_64564[(2)] = inst_64247);

(statearr_64482_64564[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (34))){
var inst_64347 = (state_64434[(22)]);
var state_64434__$1 = state_64434;
var statearr_64483_64565 = state_64434__$1;
(statearr_64483_64565[(2)] = inst_64347);

(statearr_64483_64565[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (17))){
var inst_64288 = (state_64434[(2)]);
var inst_64289 = fluree.db.util.async.throw_err.call(null,inst_64288);
var inst_64290 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64289);
var state_64434__$1 = state_64434;
var statearr_64484_64566 = state_64434__$1;
(statearr_64484_64566[(2)] = inst_64290);

(statearr_64484_64566[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (3))){
var inst_64251 = (state_64434[(21)]);
var inst_64253 = fluree.db.api_js.resolve_block_range.call(null,inst_64251,query_map);
var state_64434__$1 = state_64434;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64434__$1,(6),inst_64253);
} else {
if((state_val_64435 === (12))){
var inst_64261 = (state_64434[(27)]);
var inst_64284 = (state_64434[(2)]);
var state_64434__$1 = (function (){var statearr_64485 = state_64434;
(statearr_64485[(23)] = inst_64284);

return statearr_64485;
})();
if(cljs.core.truth_(inst_64261)){
var statearr_64486_64567 = state_64434__$1;
(statearr_64486_64567[(1)] = (14));

} else {
var statearr_64487_64568 = state_64434__$1;
(statearr_64487_64568[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (2))){
var inst_64246 = (state_64434[(17)]);
var inst_64250 = (state_64434[(2)]);
var inst_64251 = fluree.db.util.async.throw_err.call(null,inst_64250);
var state_64434__$1 = (function (){var statearr_64488 = state_64434;
(statearr_64488[(21)] = inst_64251);

return statearr_64488;
})();
if(cljs.core.truth_(inst_64246)){
var statearr_64489_64569 = state_64434__$1;
(statearr_64489_64569[(1)] = (3));

} else {
var statearr_64490_64570 = state_64434__$1;
(statearr_64490_64570[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (23))){
var inst_64326 = (state_64434[(2)]);
var state_64434__$1 = state_64434;
var statearr_64491_64571 = state_64434__$1;
(statearr_64491_64571[(2)] = inst_64326);

(statearr_64491_64571[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (47))){
var inst_64376 = (state_64434[(2)]);
var state_64434__$1 = state_64434;
var statearr_64492_64572 = state_64434__$1;
(statearr_64492_64572[(2)] = inst_64376);

(statearr_64492_64572[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (35))){
var inst_64358 = (state_64434[(2)]);
var state_64434__$1 = state_64434;
if(cljs.core.truth_(inst_64358)){
var statearr_64493_64573 = state_64434__$1;
(statearr_64493_64573[(1)] = (39));

} else {
var statearr_64494_64574 = state_64434__$1;
(statearr_64494_64574[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (19))){
var inst_64247 = (state_64434[(16)]);
var inst_64301 = cljs.core.sequential_QMARK_.call(null,inst_64247);
var state_64434__$1 = state_64434;
if(inst_64301){
var statearr_64495_64575 = state_64434__$1;
(statearr_64495_64575[(1)] = (21));

} else {
var statearr_64496_64576 = state_64434__$1;
(statearr_64496_64576[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (57))){
var inst_64416 = (state_64434[(19)]);
var state_64434__$1 = state_64434;
var statearr_64497_64577 = state_64434__$1;
(statearr_64497_64577[(2)] = inst_64416);

(statearr_64497_64577[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (11))){
var state_64434__$1 = state_64434;
var statearr_64498_64578 = state_64434__$1;
(statearr_64498_64578[(2)] = (-1));

(statearr_64498_64578[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (9))){
var inst_64273 = (state_64434[(2)]);
var state_64434__$1 = state_64434;
if(cljs.core.truth_(inst_64273)){
var statearr_64499_64579 = state_64434__$1;
(statearr_64499_64579[(1)] = (10));

} else {
var statearr_64500_64580 = state_64434__$1;
(statearr_64500_64580[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (5))){
var inst_64260 = (state_64434[(7)]);
var inst_64259 = (state_64434[(2)]);
var inst_64260__$1 = cljs.core.nth.call(null,inst_64259,(0),null);
var inst_64261 = cljs.core.nth.call(null,inst_64259,(1),null);
var inst_64268 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_64434__$1 = (function (){var statearr_64501 = state_64434;
(statearr_64501[(7)] = inst_64260__$1);

(statearr_64501[(27)] = inst_64261);

(statearr_64501[(13)] = inst_64268);

return statearr_64501;
})();
if(cljs.core.truth_(inst_64260__$1)){
var statearr_64502_64581 = state_64434__$1;
(statearr_64502_64581[(1)] = (7));

} else {
var statearr_64503_64582 = state_64434__$1;
(statearr_64503_64582[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (14))){
var inst_64261 = (state_64434[(27)]);
var inst_64251 = (state_64434[(21)]);
var inst_64286 = fluree.db.time_travel.as_of_block.call(null,inst_64251,inst_64261);
var state_64434__$1 = state_64434;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64434__$1,(17),inst_64286);
} else {
if((state_val_64435 === (45))){
var inst_64338 = (state_64434[(10)]);
var inst_64372 = (inst_64338 == null);
var inst_64373 = cljs.core.not.call(null,inst_64372);
var state_64434__$1 = state_64434;
var statearr_64504_64583 = state_64434__$1;
(statearr_64504_64583[(2)] = inst_64373);

(statearr_64504_64583[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (53))){
var inst_64397 = (state_64434[(2)]);
var state_64434__$1 = state_64434;
var statearr_64505_64584 = state_64434__$1;
(statearr_64505_64584[(2)] = inst_64397);

(statearr_64505_64584[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (26))){
var inst_64313 = (state_64434[(2)]);
var state_64434__$1 = state_64434;
var statearr_64506_64585 = state_64434__$1;
(statearr_64506_64585[(2)] = inst_64313);

(statearr_64506_64585[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (16))){
var inst_64247 = (state_64434[(16)]);
var inst_64294 = (state_64434[(2)]);
var inst_64295 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_64247);
var state_64434__$1 = (function (){var statearr_64507 = state_64434;
(statearr_64507[(24)] = inst_64294);

return statearr_64507;
})();
if(inst_64295){
var statearr_64508_64586 = state_64434__$1;
(statearr_64508_64586[(1)] = (18));

} else {
var statearr_64509_64587 = state_64434__$1;
(statearr_64509_64587[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (38))){
var inst_64355 = (state_64434[(2)]);
var state_64434__$1 = state_64434;
var statearr_64510_64588 = state_64434__$1;
(statearr_64510_64588[(2)] = inst_64355);

(statearr_64510_64588[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (30))){
var inst_64328 = (state_64434[(8)]);
var inst_64343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64344 = [inst_64328,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_64345 = (new cljs.core.PersistentVector(null,2,(5),inst_64343,inst_64344,null));
var state_64434__$1 = state_64434;
var statearr_64511_64589 = state_64434__$1;
(statearr_64511_64589[(2)] = inst_64345);

(statearr_64511_64589[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (10))){
var inst_64260 = (state_64434[(7)]);
var inst_64251 = (state_64434[(21)]);
var inst_64275 = (inst_64260 - (1));
var inst_64276 = fluree.db.time_travel.as_of_block.call(null,inst_64251,inst_64275);
var state_64434__$1 = state_64434;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64434__$1,(13),inst_64276);
} else {
if((state_val_64435 === (18))){
var inst_64247 = (state_64434[(16)]);
var inst_64297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64298 = [inst_64247];
var inst_64299 = (new cljs.core.PersistentVector(null,1,(5),inst_64297,inst_64298,null));
var state_64434__$1 = state_64434;
var statearr_64512_64590 = state_64434__$1;
(statearr_64512_64590[(2)] = inst_64299);

(statearr_64512_64590[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (52))){
var state_64434__$1 = state_64434;
var statearr_64513_64591 = state_64434__$1;
(statearr_64513_64591[(2)] = null);

(statearr_64513_64591[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (42))){
var inst_64370 = (state_64434[(20)]);
var inst_64337 = (state_64434[(11)]);
var inst_64369 = (inst_64337 == null);
var inst_64370__$1 = cljs.core.not.call(null,inst_64369);
var state_64434__$1 = (function (){var statearr_64514 = state_64434;
(statearr_64514[(20)] = inst_64370__$1);

return statearr_64514;
})();
if(inst_64370__$1){
var statearr_64515_64592 = state_64434__$1;
(statearr_64515_64592[(1)] = (45));

} else {
var statearr_64516_64593 = state_64434__$1;
(statearr_64516_64593[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (37))){
var inst_64350 = (state_64434[(26)]);
var state_64434__$1 = state_64434;
var statearr_64517_64594 = state_64434__$1;
(statearr_64517_64594[(2)] = inst_64350);

(statearr_64517_64594[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (8))){
var inst_64260 = (state_64434[(7)]);
var state_64434__$1 = state_64434;
var statearr_64518_64595 = state_64434__$1;
(statearr_64518_64595[(2)] = inst_64260);

(statearr_64518_64595[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64435 === (49))){
var state_64434__$1 = state_64434;
var statearr_64519_64596 = state_64434__$1;
(statearr_64519_64596[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_64521 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64521[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_64521[(1)] = (1));

return statearr_64521;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_64434){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_64434);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e64522){var ex__2744__auto__ = e64522;
var statearr_64523_64597 = state_64434;
(statearr_64523_64597[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_64434[(4)]))){
var statearr_64524_64598 = state_64434;
(statearr_64524_64598[(1)] = cljs.core.first.call(null,(state_64434[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64599 = state_64434;
state_64434 = G__64599;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_64434){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_64434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_64525 = f__2764__auto__.call(null);
(statearr_64525[(6)] = c__2763__auto__);

return statearr_64525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__64607 = arguments.length;
switch (G__64607) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5753__auto__)){
var block = temp__5753__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__64600_SHARP_){
return cljs.core.dissoc.call(null,p1__64600_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_64696){
var state_val_64697 = (state_64696[(1)]);
if((state_val_64697 === (7))){
var inst_64647 = (state_64696[(7)]);
var inst_64650 = (state_64696[(8)]);
var inst_64657 = (state_64696[(9)]);
var inst_64653 = (state_64696[(10)]);
var inst_64663 = (function (){var responses = inst_64647;
var responses_STAR_ = inst_64650;
var statuses = inst_64653;
var fuel = inst_64657;
return (function (p1__64603_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__64603_SHARP_);
});
})();
var inst_64664 = cljs.core.some.call(null,inst_64663,inst_64653);
var state_64696__$1 = state_64696;
if(cljs.core.truth_(inst_64664)){
var statearr_64698_64746 = state_64696__$1;
(statearr_64698_64746[(1)] = (9));

} else {
var statearr_64699_64747 = state_64696__$1;
(statearr_64699_64747[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (20))){
var inst_64691 = (state_64696[(2)]);
var state_64696__$1 = state_64696;
var statearr_64700_64748 = state_64696__$1;
(statearr_64700_64748[(2)] = inst_64691);

(statearr_64700_64748[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (1))){
var inst_64642 = cljs.core.async.chan.call(null,(1));
var inst_64643 = (function (){var c__2763__auto____$1 = inst_64642;
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_64640){
var state_val_64641 = (state_64640[(1)]);
if((state_val_64641 === (1))){
var inst_64608 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_64609 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_64610 = cljs.core.assoc.call(null,inst_64609,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_64611 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_64612 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_64613 = cljs.core.PersistentHashMap.EMPTY;
var inst_64614 = inst_64608;
var inst_64615 = inst_64610;
var inst_64616 = inst_64611;
var inst_64617 = inst_64612;
var inst_64618 = inst_64613;
var state_64640__$1 = (function (){var statearr_64701 = state_64640;
(statearr_64701[(7)] = inst_64618);

(statearr_64701[(8)] = inst_64615);

(statearr_64701[(9)] = inst_64614);

(statearr_64701[(10)] = inst_64617);

(statearr_64701[(11)] = inst_64616);

return statearr_64701;
})();
var statearr_64702_64749 = state_64640__$1;
(statearr_64702_64749[(2)] = null);

(statearr_64702_64749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64641 === (2))){
var inst_64615 = (state_64640[(8)]);
var inst_64620 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_64615);
var inst_64621 = cljs.core.merge.call(null,opts,inst_64620);
var inst_64622 = cljs.core.assoc.call(null,inst_64615,new cljs.core.Keyword(null,"opts","opts",155075701),inst_64621);
var inst_64623 = fluree.db.api_js.query_async.call(null,db,inst_64622,db_fn);
var state_64640__$1 = state_64640;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64640__$1,(4),inst_64623);
} else {
if((state_val_64641 === (3))){
var inst_64638 = (state_64640[(2)]);
var state_64640__$1 = state_64640;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64640__$1,inst_64638);
} else {
if((state_val_64641 === (4))){
var inst_64618 = (state_64640[(7)]);
var inst_64614 = (state_64640[(9)]);
var inst_64616 = (state_64640[(11)]);
var inst_64625 = (state_64640[(2)]);
var inst_64626 = cljs.core.assoc.call(null,inst_64618,inst_64614,inst_64625);
var inst_64627 = cljs.core.first.call(null,inst_64616);
var state_64640__$1 = (function (){var statearr_64703 = state_64640;
(statearr_64703[(12)] = inst_64626);

return statearr_64703;
})();
if(cljs.core.truth_(inst_64627)){
var statearr_64704_64750 = state_64640__$1;
(statearr_64704_64750[(1)] = (5));

} else {
var statearr_64705_64751 = state_64640__$1;
(statearr_64705_64751[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64641 === (5))){
var inst_64626 = (state_64640[(12)]);
var inst_64617 = (state_64640[(10)]);
var inst_64616 = (state_64640[(11)]);
var inst_64629 = cljs.core.first.call(null,inst_64616);
var inst_64630 = cljs.core.first.call(null,inst_64617);
var inst_64631 = cljs.core.rest.call(null,inst_64616);
var inst_64632 = cljs.core.rest.call(null,inst_64617);
var inst_64614 = inst_64629;
var inst_64615 = inst_64630;
var inst_64616__$1 = inst_64631;
var inst_64617__$1 = inst_64632;
var inst_64618 = inst_64626;
var state_64640__$1 = (function (){var statearr_64706 = state_64640;
(statearr_64706[(7)] = inst_64618);

(statearr_64706[(8)] = inst_64615);

(statearr_64706[(9)] = inst_64614);

(statearr_64706[(10)] = inst_64617__$1);

(statearr_64706[(11)] = inst_64616__$1);

return statearr_64706;
})();
var statearr_64707_64752 = state_64640__$1;
(statearr_64707_64752[(2)] = null);

(statearr_64707_64752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64641 === (6))){
var inst_64626 = (state_64640[(12)]);
var state_64640__$1 = state_64640;
var statearr_64708_64753 = state_64640__$1;
(statearr_64708_64753[(2)] = inst_64626);

(statearr_64708_64753[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64641 === (7))){
var inst_64636 = (state_64640[(2)]);
var state_64640__$1 = state_64640;
var statearr_64709_64754 = state_64640__$1;
(statearr_64709_64754[(2)] = inst_64636);

(statearr_64709_64754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_64710 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64710[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_64710[(1)] = (1));

return statearr_64710;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_64640){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_64640);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e64711){var ex__2744__auto__ = e64711;
var statearr_64712_64755 = state_64640;
(statearr_64712_64755[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_64640[(4)]))){
var statearr_64713_64756 = state_64640;
(statearr_64713_64756[(1)] = cljs.core.first.call(null,(state_64640[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64757 = state_64640;
state_64640 = G__64757;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_64640){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_64640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_64714 = f__2764__auto__.call(null);
(statearr_64714[(6)] = c__2763__auto____$1);

return statearr_64714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
});
})();
var inst_64644 = cljs.core.async.impl.dispatch.run.call(null,inst_64643);
var state_64696__$1 = (function (){var statearr_64715 = state_64696;
(statearr_64715[(11)] = inst_64644);

return statearr_64715;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64696__$1,(2),inst_64642);
} else {
if((state_val_64697 === (4))){
var inst_64647 = (state_64696[(7)]);
var state_64696__$1 = state_64696;
var statearr_64716_64758 = state_64696__$1;
(statearr_64716_64758[(2)] = inst_64647);

(statearr_64716_64758[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (15))){
var state_64696__$1 = state_64696;
var statearr_64717_64759 = state_64696__$1;
(statearr_64717_64759[(2)] = (400));

(statearr_64717_64759[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (13))){
var state_64696__$1 = state_64696;
var statearr_64718_64760 = state_64696__$1;
(statearr_64718_64760[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (6))){
var inst_64653 = (state_64696[(10)]);
var inst_64661 = cljs.core.first.call(null,inst_64653);
var state_64696__$1 = state_64696;
var statearr_64720_64761 = state_64696__$1;
(statearr_64720_64761[(2)] = inst_64661);

(statearr_64720_64761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (17))){
var inst_64674 = (state_64696[(2)]);
var state_64696__$1 = state_64696;
var statearr_64721_64762 = state_64696__$1;
(statearr_64721_64762[(2)] = inst_64674);

(statearr_64721_64762[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (3))){
var inst_64647 = (state_64696[(7)]);
var inst_64650 = (state_64696[(8)]);
var inst_64657 = (state_64696[(9)]);
var inst_64653 = (state_64696[(10)]);
var inst_64652 = cljs.core.vals.call(null,inst_64647);
var inst_64653__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_64652);
var inst_64654 = (function (){var responses = inst_64647;
var responses_STAR_ = inst_64650;
var statuses = inst_64653__$1;
return (function (p1__64601_SHARP_){
var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__64601_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
});
})();
var inst_64655 = cljs.core.vals.call(null,inst_64647);
var inst_64656 = cljs.core.map.call(null,inst_64654,inst_64655);
var inst_64657__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_64656);
var inst_64658 = (function (){var responses = inst_64647;
var responses_STAR_ = inst_64650;
var statuses = inst_64653__$1;
var fuel = inst_64657__$1;
return (function (p1__64602_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__64602_SHARP_);
});
})();
var inst_64659 = cljs.core.every_QMARK_.call(null,inst_64658,inst_64653__$1);
var state_64696__$1 = (function (){var statearr_64722 = state_64696;
(statearr_64722[(9)] = inst_64657__$1);

(statearr_64722[(10)] = inst_64653__$1);

return statearr_64722;
})();
if(inst_64659){
var statearr_64723_64763 = state_64696__$1;
(statearr_64723_64763[(1)] = (6));

} else {
var statearr_64724_64764 = state_64696__$1;
(statearr_64724_64764[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (12))){
var state_64696__$1 = state_64696;
var statearr_64725_64765 = state_64696__$1;
(statearr_64725_64765[(2)] = (500));

(statearr_64725_64765[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (2))){
var inst_64647 = (state_64696[(7)]);
var inst_64646 = (state_64696[(2)]);
var inst_64647__$1 = fluree.db.util.async.throw_err.call(null,inst_64646);
var inst_64648 = (function (){var responses = inst_64647__$1;
return (function (acc,index,response){
var resp = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_64649 = cljs.core.PersistentHashMap.EMPTY;
var inst_64650 = cljs.core.reduce_kv.call(null,inst_64648,inst_64649,inst_64647__$1);
var state_64696__$1 = (function (){var statearr_64726 = state_64696;
(statearr_64726[(7)] = inst_64647__$1);

(statearr_64726[(8)] = inst_64650);

return statearr_64726;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_64727_64766 = state_64696__$1;
(statearr_64727_64766[(1)] = (3));

} else {
var statearr_64728_64767 = state_64696__$1;
(statearr_64728_64767[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (19))){
var inst_64650 = (state_64696[(8)]);
var inst_64680 = (state_64696[(12)]);
var inst_64657 = (state_64696[(9)]);
var inst_64689 = cljs.core.assoc.call(null,inst_64650,new cljs.core.Keyword(null,"status","status",-1997798413),inst_64680,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64657);
var state_64696__$1 = state_64696;
var statearr_64729_64768 = state_64696__$1;
(statearr_64729_64768[(2)] = inst_64689);

(statearr_64729_64768[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (11))){
var inst_64678 = (state_64696[(2)]);
var state_64696__$1 = state_64696;
var statearr_64730_64769 = state_64696__$1;
(statearr_64730_64769[(2)] = inst_64678);

(statearr_64730_64769[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (9))){
var state_64696__$1 = state_64696;
var statearr_64731_64770 = state_64696__$1;
(statearr_64731_64770[(2)] = (207));

(statearr_64731_64770[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (5))){
var inst_64694 = (state_64696[(2)]);
var state_64696__$1 = state_64696;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64696__$1,inst_64694);
} else {
if((state_val_64697 === (14))){
var inst_64676 = (state_64696[(2)]);
var state_64696__$1 = state_64696;
var statearr_64732_64771 = state_64696__$1;
(statearr_64732_64771[(2)] = inst_64676);

(statearr_64732_64771[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (16))){
var state_64696__$1 = state_64696;
var statearr_64733_64772 = state_64696__$1;
(statearr_64733_64772[(2)] = null);

(statearr_64733_64772[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (10))){
var inst_64647 = (state_64696[(7)]);
var inst_64650 = (state_64696[(8)]);
var inst_64657 = (state_64696[(9)]);
var inst_64653 = (state_64696[(10)]);
var inst_64667 = (function (){var responses = inst_64647;
var responses_STAR_ = inst_64650;
var statuses = inst_64653;
var fuel = inst_64657;
return (function (p1__64604_SHARP_){
return ((499) < p1__64604_SHARP_);
});
})();
var inst_64668 = cljs.core.some.call(null,inst_64667,inst_64653);
var state_64696__$1 = state_64696;
if(cljs.core.truth_(inst_64668)){
var statearr_64734_64773 = state_64696__$1;
(statearr_64734_64773[(1)] = (12));

} else {
var statearr_64735_64774 = state_64696__$1;
(statearr_64735_64774[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (18))){
var inst_64650 = (state_64696[(8)]);
var inst_64680 = (state_64696[(12)]);
var inst_64657 = (state_64696[(9)]);
var inst_64685 = (state_64696[(13)]);
var inst_64687 = cljs.core.assoc.call(null,inst_64650,new cljs.core.Keyword(null,"status","status",-1997798413),inst_64680,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64657,new cljs.core.Keyword(null,"block","block",664686210),inst_64685);
var state_64696__$1 = state_64696;
var statearr_64736_64775 = state_64696__$1;
(statearr_64736_64775[(2)] = inst_64687);

(statearr_64736_64775[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64697 === (8))){
var inst_64647 = (state_64696[(7)]);
var inst_64650 = (state_64696[(8)]);
var inst_64680 = (state_64696[(12)]);
var inst_64657 = (state_64696[(9)]);
var inst_64685 = (state_64696[(13)]);
var inst_64653 = (state_64696[(10)]);
var inst_64680__$1 = (state_64696[(2)]);
var inst_64681 = (function (){var responses = inst_64647;
var responses_STAR_ = inst_64650;
var statuses = inst_64653;
var fuel = inst_64657;
var status = inst_64680__$1;
return (function (p1__64605_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__64605_SHARP_));
});
})();
var inst_64682 = cljs.core.vals.call(null,inst_64647);
var inst_64683 = cljs.core.filter.call(null,inst_64681,inst_64682);
var inst_64684 = cljs.core.first.call(null,inst_64683);
var inst_64685__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64684);
var state_64696__$1 = (function (){var statearr_64737 = state_64696;
(statearr_64737[(12)] = inst_64680__$1);

(statearr_64737[(13)] = inst_64685__$1);

return statearr_64737;
})();
if(cljs.core.truth_(inst_64685__$1)){
var statearr_64738_64776 = state_64696__$1;
(statearr_64738_64776[(1)] = (18));

} else {
var statearr_64739_64777 = state_64696__$1;
(statearr_64739_64777[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_64740 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64740[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_64740[(1)] = (1));

return statearr_64740;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_64696){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_64696);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e64741){var ex__2744__auto__ = e64741;
var statearr_64742_64778 = state_64696;
(statearr_64742_64778[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_64696[(4)]))){
var statearr_64743_64779 = state_64696;
(statearr_64743_64779[(1)] = cljs.core.first.call(null,(state_64696[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64780 = state_64696;
state_64696 = G__64780;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_64696){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_64696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_64744 = f__2764__auto__.call(null);
(statearr_64744[(6)] = c__2763__auto__);

return statearr_64744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__64782 = arguments.length;
switch (G__64782) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__64783 = opts;
var map__64783__$1 = cljs.core.__destructure_map.call(null,map__64783);
var auth = cljs.core.get.call(null,map__64783__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__64783__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__64783__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__64783__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__64784 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__64784,(0),null);
var authority = cljs.core.nth.call(null,vec__64784,(1),null);
var action__$1 = (function (){var or__4253__auto__ = action;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e64787){var e = e64787;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__64790 = arguments.length;
switch (G__64790) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_64821){
var state_val_64822 = (state_64821[(1)]);
if((state_val_64822 === (7))){
var state_64821__$1 = state_64821;
var statearr_64823_64844 = state_64821__$1;
(statearr_64823_64844[(2)] = opts);

(statearr_64823_64844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (1))){
var state_64821__$1 = state_64821;
var statearr_64824_64845 = state_64821__$1;
(statearr_64824_64845[(2)] = null);

(statearr_64824_64845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (4))){
var inst_64791 = (state_64821[(2)]);
var inst_64792 = fluree.db.util.log.error.call(null,inst_64791);
var inst_64793 = cljs.core.ex_data.call(null,inst_64791);
var inst_64794 = cljs.core.ex_message.call(null,inst_64791);
var inst_64795 = cljs.core.assoc.call(null,inst_64793,new cljs.core.Keyword(null,"message","message",-406056002),inst_64794);
var state_64821__$1 = (function (){var statearr_64825 = state_64821;
(statearr_64825[(7)] = inst_64792);

return statearr_64825;
})();
var statearr_64826_64846 = state_64821__$1;
(statearr_64826_64846[(2)] = inst_64795);

(statearr_64826_64846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (6))){
var inst_64805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64806 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_64807 = (new cljs.core.PersistentVector(null,1,(5),inst_64805,inst_64806,null));
var inst_64808 = cljs.core.assoc_in.call(null,opts,inst_64807,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_64821__$1 = state_64821;
var statearr_64827_64847 = state_64821__$1;
(statearr_64827_64847[(2)] = inst_64808);

(statearr_64827_64847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (3))){
var inst_64819 = (state_64821[(2)]);
var state_64821__$1 = state_64821;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64821__$1,inst_64819);
} else {
if((state_val_64822 === (2))){
var _ = (function (){var statearr_64829 = state_64821;
(statearr_64829[(4)] = cljs.core.cons.call(null,(5),(state_64821[(4)])));

return statearr_64829;
})();
var inst_64801 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_64802 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_64803 = (inst_64802 == null);
var state_64821__$1 = (function (){var statearr_64830 = state_64821;
(statearr_64830[(8)] = inst_64801);

return statearr_64830;
})();
if(cljs.core.truth_(inst_64803)){
var statearr_64831_64848 = state_64821__$1;
(statearr_64831_64848[(1)] = (6));

} else {
var statearr_64832_64849 = state_64821__$1;
(statearr_64832_64849[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (9))){
var inst_64815 = (state_64821[(2)]);
var inst_64816 = fluree.db.util.async.throw_err.call(null,inst_64815);
var _ = (function (){var statearr_64833 = state_64821;
(statearr_64833[(4)] = cljs.core.rest.call(null,(state_64821[(4)])));

return statearr_64833;
})();
var state_64821__$1 = state_64821;
var statearr_64834_64850 = state_64821__$1;
(statearr_64834_64850[(2)] = inst_64816);

(statearr_64834_64850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (5))){
var _ = (function (){var statearr_64835 = state_64821;
(statearr_64835[(4)] = cljs.core.rest.call(null,(state_64821[(4)])));

return statearr_64835;
})();
var state_64821__$1 = state_64821;
var ex64828 = (state_64821__$1[(2)]);
var statearr_64836_64851 = state_64821__$1;
(statearr_64836_64851[(5)] = ex64828);


var statearr_64837_64852 = state_64821__$1;
(statearr_64837_64852[(1)] = (4));

(statearr_64837_64852[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (8))){
var inst_64801 = (state_64821[(8)]);
var inst_64811 = (state_64821[(2)]);
var inst_64812 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_64801,inst_64811);
var inst_64813 = fluree.db.operations.command_async.call(null,conn,inst_64812);
var state_64821__$1 = state_64821;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64821__$1,(9),inst_64813);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_64838 = [null,null,null,null,null,null,null,null,null];
(statearr_64838[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_64838[(1)] = (1));

return statearr_64838;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_64821){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_64821);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e64839){var ex__2744__auto__ = e64839;
var statearr_64840_64853 = state_64821;
(statearr_64840_64853[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_64821[(4)]))){
var statearr_64841_64854 = state_64821;
(statearr_64841_64854[(1)] = cljs.core.first.call(null,(state_64821[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64855 = state_64821;
state_64821 = G__64855;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_64821){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_64821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_64842 = f__2764__auto__.call(null);
(statearr_64842[(6)] = c__2763__auto__);

return statearr_64842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

