// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__62378 = arguments.length;
switch (G__62378) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62420){
var state_val_62421 = (state_62420[(1)]);
if((state_val_62421 === (7))){
var inst_62390 = typeof user === 'string';
var state_62420__$1 = state_62420;
if(cljs.core.truth_(inst_62390)){
var statearr_62422_62451 = state_62420__$1;
(statearr_62422_62451[(1)] = (9));

} else {
var statearr_62423_62452 = state_62420__$1;
(statearr_62423_62452[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (1))){
var state_62420__$1 = state_62420;
var statearr_62424_62453 = state_62420__$1;
(statearr_62424_62453[(2)] = null);

(statearr_62424_62453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (4))){
var inst_62379 = (state_62420[(2)]);
var inst_62380 = fluree.db.util.log.error.call(null,inst_62379);
var inst_62381 = reject.call(null,inst_62379);
var state_62420__$1 = (function (){var statearr_62425 = state_62420;
(statearr_62425[(7)] = inst_62380);

return statearr_62425;
})();
var statearr_62426_62454 = state_62420__$1;
(statearr_62426_62454[(2)] = inst_62381);

(statearr_62426_62454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (15))){
var inst_62409 = (state_62420[(2)]);
var inst_62410 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_62409);
var inst_62411 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62412 = cljs.core.constantly.call(null,inst_62410);
var inst_62413 = cljs.core.swap_BANG_.call(null,inst_62411,inst_62412);
var inst_62414 = fluree.db.connection.add_token.call(null,conn,inst_62410);
var inst_62415 = resolve.call(null,inst_62409);
var _ = (function (){var statearr_62427 = state_62420;
(statearr_62427[(4)] = cljs.core.rest.call(null,(state_62420[(4)])));

return statearr_62427;
})();
var state_62420__$1 = (function (){var statearr_62428 = state_62420;
(statearr_62428[(8)] = inst_62414);

(statearr_62428[(9)] = inst_62413);

return statearr_62428;
})();
var statearr_62429_62455 = state_62420__$1;
(statearr_62429_62455[(2)] = inst_62415);

(statearr_62429_62455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (13))){
var state_62420__$1 = state_62420;
var statearr_62430_62456 = state_62420__$1;
(statearr_62430_62456[(2)] = null);

(statearr_62430_62456[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (6))){
var state_62420__$1 = state_62420;
var statearr_62431_62457 = state_62420__$1;
(statearr_62431_62457[(2)] = user);

(statearr_62431_62457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (3))){
var inst_62418 = (state_62420[(2)]);
var state_62420__$1 = state_62420;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62420__$1,inst_62418);
} else {
if((state_val_62421 === (12))){
var state_62420__$1 = state_62420;
var statearr_62432_62458 = state_62420__$1;
(statearr_62432_62458[(2)] = user);

(statearr_62432_62458[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (2))){
var _ = (function (){var statearr_62433 = state_62420;
(statearr_62433[(4)] = cljs.core.cons.call(null,(5),(state_62420[(4)])));

return statearr_62433;
})();
var inst_62387 = typeof user === 'number';
var state_62420__$1 = state_62420;
if(cljs.core.truth_(inst_62387)){
var statearr_62434_62459 = state_62420__$1;
(statearr_62434_62459[(1)] = (6));

} else {
var statearr_62435_62460 = state_62420__$1;
(statearr_62435_62460[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (11))){
var inst_62401 = (state_62420[(2)]);
var state_62420__$1 = state_62420;
var statearr_62437_62461 = state_62420__$1;
(statearr_62437_62461[(2)] = inst_62401);

(statearr_62437_62461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (9))){
var inst_62392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62393 = ["_user/username",user];
var inst_62394 = (new cljs.core.PersistentVector(null,2,(5),inst_62392,inst_62393,null));
var state_62420__$1 = state_62420;
var statearr_62438_62462 = state_62420__$1;
(statearr_62438_62462[(2)] = inst_62394);

(statearr_62438_62462[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (5))){
var _ = (function (){var statearr_62439 = state_62420;
(statearr_62439[(4)] = cljs.core.rest.call(null,(state_62420[(4)])));

return statearr_62439;
})();
var state_62420__$1 = state_62420;
var ex62436 = (state_62420__$1[(2)]);
var statearr_62440_62463 = state_62420__$1;
(statearr_62440_62463[(5)] = ex62436);


var statearr_62441_62464 = state_62420__$1;
(statearr_62441_62464[(1)] = (4));

(statearr_62441_62464[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (14))){
var inst_62399 = (state_62420[(2)]);
var state_62420__$1 = state_62420;
var statearr_62442_62465 = state_62420__$1;
(statearr_62442_62465[(2)] = inst_62399);

(statearr_62442_62465[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (10))){
var state_62420__$1 = state_62420;
var statearr_62443_62466 = state_62420__$1;
(statearr_62443_62466[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (8))){
var inst_62403 = (state_62420[(2)]);
var inst_62404 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_62405 = [account,inst_62403,password,expireSeconds,syncTo];
var inst_62406 = cljs.core.PersistentHashMap.fromArrays(inst_62404,inst_62405);
var inst_62407 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_62406);
var state_62420__$1 = state_62420;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62420__$1,(15),inst_62407);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_62445 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62445[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_62445[(1)] = (1));

return statearr_62445;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_62420){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_62420);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62446){var ex__2744__auto__ = e62446;
var statearr_62447_62467 = state_62420;
(statearr_62447_62467[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_62420[(4)]))){
var statearr_62448_62468 = state_62420;
(statearr_62448_62468[(1)] = cljs.core.first.call(null,(state_62420[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62469 = state_62420;
state_62420 = G__62469;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_62420){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_62420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62449 = f__2764__auto__.call(null);
(statearr_62449[(6)] = c__2763__auto__);

return statearr_62449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__62471 = arguments.length;
switch (G__62471) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62480){
var state_val_62481 = (state_62480[(1)]);
if((state_val_62481 === (1))){
var inst_62472 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62474 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_62475 = (new cljs.core.PersistentVector(null,4,(5),inst_62473,inst_62474,null));
var inst_62476 = cljs.core.async.put_BANG_.call(null,inst_62472,inst_62475);
var inst_62477 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__62482 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__62483 = null;
var count__62484 = (0);
var i__62485 = (0);
while(true){
if((i__62485 < count__62484)){
var k = cljs.core._nth.call(null,chunk__62483,i__62485);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__62493 = seq__62482;
var G__62494 = chunk__62483;
var G__62495 = count__62484;
var G__62496 = (i__62485 + (1));
seq__62482 = G__62493;
chunk__62483 = G__62494;
count__62484 = G__62495;
i__62485 = G__62496;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__62482);
if(temp__5753__auto__){
var seq__62482__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62482__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__62482__$1);
var G__62497 = cljs.core.chunk_rest.call(null,seq__62482__$1);
var G__62498 = c__4679__auto__;
var G__62499 = cljs.core.count.call(null,c__4679__auto__);
var G__62500 = (0);
seq__62482 = G__62497;
chunk__62483 = G__62498;
count__62484 = G__62499;
i__62485 = G__62500;
continue;
} else {
var k = cljs.core.first.call(null,seq__62482__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__62501 = cljs.core.next.call(null,seq__62482__$1);
var G__62502 = null;
var G__62503 = (0);
var G__62504 = (0);
seq__62482 = G__62501;
chunk__62483 = G__62502;
count__62484 = G__62503;
i__62485 = G__62504;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_62478 = cljs.core.async.take_BANG_.call(null,pc,inst_62477);
var state_62480__$1 = (function (){var statearr_62486 = state_62480;
(statearr_62486[(7)] = inst_62476);

return statearr_62486;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62480__$1,inst_62478);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_62487 = [null,null,null,null,null,null,null,null];
(statearr_62487[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_62487[(1)] = (1));

return statearr_62487;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_62480){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_62480);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62488){var ex__2744__auto__ = e62488;
var statearr_62489_62505 = state_62480;
(statearr_62489_62505[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_62480[(4)]))){
var statearr_62490_62506 = state_62480;
(statearr_62490_62506[(1)] = cljs.core.first.call(null,(state_62480[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62507 = state_62480;
state_62480 = G__62507;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_62480){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_62480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62491 = f__2764__auto__.call(null);
(statearr_62491[(6)] = c__2763__auto__);

return statearr_62491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__62509 = arguments.length;
switch (G__62509) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62543){
var state_val_62544 = (state_62543[(1)]);
if((state_val_62544 === (1))){
var state_62543__$1 = state_62543;
var statearr_62545_62566 = state_62543__$1;
(statearr_62545_62566[(2)] = null);

(statearr_62545_62566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62544 === (2))){
var _ = (function (){var statearr_62546 = state_62543;
(statearr_62546[(4)] = cljs.core.cons.call(null,(5),(state_62543[(4)])));

return statearr_62546;
})();
var inst_62518 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_62519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62520 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_62521 = (new cljs.core.PersistentVector(null,1,(5),inst_62519,inst_62520,null));
var inst_62522 = cljs.core.PersistentHashMap.EMPTY;
var inst_62523 = cljs.core.atom.call(null,inst_62522);
var inst_62524 = cljs.core.assoc_in.call(null,inst_62518,inst_62521,inst_62523);
var inst_62525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62526 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62527 = (new cljs.core.PersistentVector(null,1,(5),inst_62525,inst_62526,null));
var inst_62528 = cljs.core.PersistentHashMap.EMPTY;
var inst_62529 = cljs.core.atom.call(null,inst_62528);
var inst_62530 = cljs.core.assoc_in.call(null,inst_62524,inst_62527,inst_62529);
var inst_62531 = cljs.core.async.promise_chan.call(null);
var inst_62532 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_62530);
var inst_62533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62534 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_62531,null];
var inst_62535 = (new cljs.core.PersistentVector(null,4,(5),inst_62533,inst_62534,null));
var inst_62536 = cljs.core.async.put_BANG_.call(null,inst_62532,inst_62535);
var inst_62537 = (function (){var conn = inst_62530;
var pc = inst_62531;
return (function (x){
if((x == null)){
} else {
var seq__62547_62567 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__62548_62568 = null;
var count__62549_62569 = (0);
var i__62550_62570 = (0);
while(true){
if((i__62550_62570 < count__62549_62569)){
var k_62571 = cljs.core._nth.call(null,chunk__62548_62568,i__62550_62570);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62571], null),cljs.core.get.call(null,x,k_62571,null));


var G__62572 = seq__62547_62567;
var G__62573 = chunk__62548_62568;
var G__62574 = count__62549_62569;
var G__62575 = (i__62550_62570 + (1));
seq__62547_62567 = G__62572;
chunk__62548_62568 = G__62573;
count__62549_62569 = G__62574;
i__62550_62570 = G__62575;
continue;
} else {
var temp__5753__auto___62576 = cljs.core.seq.call(null,seq__62547_62567);
if(temp__5753__auto___62576){
var seq__62547_62577__$1 = temp__5753__auto___62576;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62547_62577__$1)){
var c__4679__auto___62578 = cljs.core.chunk_first.call(null,seq__62547_62577__$1);
var G__62579 = cljs.core.chunk_rest.call(null,seq__62547_62577__$1);
var G__62580 = c__4679__auto___62578;
var G__62581 = cljs.core.count.call(null,c__4679__auto___62578);
var G__62582 = (0);
seq__62547_62567 = G__62579;
chunk__62548_62568 = G__62580;
count__62549_62569 = G__62581;
i__62550_62570 = G__62582;
continue;
} else {
var k_62583 = cljs.core.first.call(null,seq__62547_62577__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62583], null),cljs.core.get.call(null,x,k_62583,null));


var G__62584 = cljs.core.next.call(null,seq__62547_62577__$1);
var G__62585 = null;
var G__62586 = (0);
var G__62587 = (0);
seq__62547_62567 = G__62584;
chunk__62548_62568 = G__62585;
count__62549_62569 = G__62586;
i__62550_62570 = G__62587;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_62538 = cljs.core.async.take_BANG_.call(null,inst_62531,inst_62537);
var ___$1 = (function (){var statearr_62551 = state_62543;
(statearr_62551[(4)] = cljs.core.rest.call(null,(state_62543[(4)])));

return statearr_62551;
})();
var state_62543__$1 = (function (){var statearr_62552 = state_62543;
(statearr_62552[(7)] = inst_62536);

return statearr_62552;
})();
var statearr_62553_62588 = state_62543__$1;
(statearr_62553_62588[(2)] = inst_62538);

(statearr_62553_62588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62544 === (3))){
var inst_62541 = (state_62543[(2)]);
var state_62543__$1 = state_62543;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62543__$1,inst_62541);
} else {
if((state_val_62544 === (4))){
var inst_62510 = (state_62543[(2)]);
var inst_62511 = fluree.db.util.log.error.call(null,inst_62510);
var inst_62512 = reject.call(null,inst_62510);
var state_62543__$1 = (function (){var statearr_62555 = state_62543;
(statearr_62555[(8)] = inst_62511);

return statearr_62555;
})();
var statearr_62556_62589 = state_62543__$1;
(statearr_62556_62589[(2)] = inst_62512);

(statearr_62556_62589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62544 === (5))){
var _ = (function (){var statearr_62557 = state_62543;
(statearr_62557[(4)] = cljs.core.rest.call(null,(state_62543[(4)])));

return statearr_62557;
})();
var state_62543__$1 = state_62543;
var ex62554 = (state_62543__$1[(2)]);
var statearr_62558_62590 = state_62543__$1;
(statearr_62558_62590[(5)] = ex62554);


var statearr_62559_62591 = state_62543__$1;
(statearr_62559_62591[(1)] = (4));

(statearr_62559_62591[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_62560 = [null,null,null,null,null,null,null,null,null];
(statearr_62560[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_62560[(1)] = (1));

return statearr_62560;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_62543){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_62543);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62561){var ex__2744__auto__ = e62561;
var statearr_62562_62592 = state_62543;
(statearr_62562_62592[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_62543[(4)]))){
var statearr_62563_62593 = state_62543;
(statearr_62563_62593[(1)] = cljs.core.first.call(null,(state_62543[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62594 = state_62543;
state_62543 = G__62594;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_62543){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_62543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62564 = f__2764__auto__.call(null);
(statearr_62564[(6)] = c__2763__auto__);

return statearr_62564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__62596 = arguments.length;
switch (G__62596) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__62598 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__62598,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__62598,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__62601 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__62601,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__62601,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62654){
var state_val_62655 = (state_62654[(1)]);
if((state_val_62655 === (7))){
var inst_62615 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62616 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62617 = cljs.core.PersistentHashMap.fromArrays(inst_62615,inst_62616);
var inst_62618 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_62617);
var inst_62619 = (function(){throw inst_62618})();
var state_62654__$1 = state_62654;
var statearr_62656_62685 = state_62654__$1;
(statearr_62656_62685[(2)] = inst_62619);

(statearr_62656_62685[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62655 === (1))){
var state_62654__$1 = state_62654;
var statearr_62657_62686 = state_62654__$1;
(statearr_62657_62686[(2)] = null);

(statearr_62657_62686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62655 === (4))){
var inst_62604 = (state_62654[(2)]);
var inst_62605 = cljs.core.clj__GT_js.call(null,inst_62604);
var inst_62606 = reject.call(null,inst_62605);
var state_62654__$1 = state_62654;
var statearr_62658_62687 = state_62654__$1;
(statearr_62658_62687[(2)] = inst_62606);

(statearr_62658_62687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62655 === (13))){
var inst_62633 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62634 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62635 = cljs.core.PersistentHashMap.fromArrays(inst_62633,inst_62634);
var inst_62636 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_62635);
var inst_62637 = (function(){throw inst_62636})();
var state_62654__$1 = state_62654;
var statearr_62659_62688 = state_62654__$1;
(statearr_62659_62688[(2)] = inst_62637);

(statearr_62659_62688[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62655 === (6))){
var state_62654__$1 = state_62654;
var statearr_62660_62689 = state_62654__$1;
(statearr_62660_62689[(2)] = null);

(statearr_62660_62689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62655 === (3))){
var inst_62652 = (state_62654[(2)]);
var state_62654__$1 = state_62654;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62654__$1,inst_62652);
} else {
if((state_val_62655 === (12))){
var state_62654__$1 = state_62654;
var statearr_62661_62690 = state_62654__$1;
(statearr_62661_62690[(2)] = null);

(statearr_62661_62690[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62655 === (2))){
var _ = (function (){var statearr_62662 = state_62654;
(statearr_62662[(4)] = cljs.core.cons.call(null,(5),(state_62654[(4)])));

return statearr_62662;
})();
var inst_62612 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_62654__$1 = state_62654;
if(cljs.core.truth_(inst_62612)){
var statearr_62663_62691 = state_62654__$1;
(statearr_62663_62691[(1)] = (6));

} else {
var statearr_62664_62692 = state_62654__$1;
(statearr_62664_62692[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62655 === (11))){
var inst_62630 = (state_62654[(2)]);
var state_62654__$1 = (function (){var statearr_62666 = state_62654;
(statearr_62666[(7)] = inst_62630);

return statearr_62666;
})();
if(cljs.core.truth_(password)){
var statearr_62667_62693 = state_62654__$1;
(statearr_62667_62693[(1)] = (12));

} else {
var statearr_62668_62694 = state_62654__$1;
(statearr_62668_62694[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62655 === (9))){
var state_62654__$1 = state_62654;
var statearr_62669_62695 = state_62654__$1;
(statearr_62669_62695[(2)] = null);

(statearr_62669_62695[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62655 === (5))){
var _ = (function (){var statearr_62670 = state_62654;
(statearr_62670[(4)] = cljs.core.rest.call(null,(state_62654[(4)])));

return statearr_62670;
})();
var state_62654__$1 = state_62654;
var ex62665 = (state_62654__$1[(2)]);
var statearr_62671_62696 = state_62654__$1;
(statearr_62671_62696[(5)] = ex62665);


var statearr_62672_62697 = state_62654__$1;
(statearr_62672_62697[(1)] = (4));

(statearr_62672_62697[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62655 === (14))){
var inst_62639 = (state_62654[(2)]);
var inst_62640 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_62641 = fluree.db.util.core.without_nils.call(null,inst_62640);
var inst_62642 = cljs.core.async.promise_chan.call(null);
var inst_62643 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62645 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_62641,inst_62642,null];
var inst_62646 = (new cljs.core.PersistentVector(null,4,(5),inst_62644,inst_62645,null));
var inst_62647 = cljs.core.async.put_BANG_.call(null,inst_62643,inst_62646);
var inst_62648 = (function (){var _ = inst_62639;
var data = inst_62641;
var pc = inst_62642;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_62649 = cljs.core.async.take_BANG_.call(null,inst_62642,inst_62648);
var _ = (function (){var statearr_62673 = state_62654;
(statearr_62673[(4)] = cljs.core.rest.call(null,(state_62654[(4)])));

return statearr_62673;
})();
var state_62654__$1 = (function (){var statearr_62674 = state_62654;
(statearr_62674[(8)] = inst_62647);

return statearr_62674;
})();
var statearr_62675_62698 = state_62654__$1;
(statearr_62675_62698[(2)] = inst_62649);

(statearr_62675_62698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62655 === (10))){
var inst_62624 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62625 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62626 = cljs.core.PersistentHashMap.fromArrays(inst_62624,inst_62625);
var inst_62627 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_62626);
var inst_62628 = (function(){throw inst_62627})();
var state_62654__$1 = state_62654;
var statearr_62676_62699 = state_62654__$1;
(statearr_62676_62699[(2)] = inst_62628);

(statearr_62676_62699[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62655 === (8))){
var inst_62621 = (state_62654[(2)]);
var state_62654__$1 = (function (){var statearr_62677 = state_62654;
(statearr_62677[(9)] = inst_62621);

return statearr_62677;
})();
if(cljs.core.truth_(ledger)){
var statearr_62678_62700 = state_62654__$1;
(statearr_62678_62700[(1)] = (9));

} else {
var statearr_62679_62701 = state_62654__$1;
(statearr_62679_62701[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2741__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2741__auto____0 = (function (){
var statearr_62680 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62680[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2741__auto__);

(statearr_62680[(1)] = (1));

return statearr_62680;
});
var fluree$db$connection_js$password_generate_$_state_machine__2741__auto____1 = (function (state_62654){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_62654);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62681){var ex__2744__auto__ = e62681;
var statearr_62682_62702 = state_62654;
(statearr_62682_62702[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_62654[(4)]))){
var statearr_62683_62703 = state_62654;
(statearr_62683_62703[(1)] = cljs.core.first.call(null,(state_62654[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62704 = state_62654;
state_62654 = G__62704;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2741__auto__ = function(state_62654){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2741__auto____1.call(this,state_62654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2741__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2741__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62684 = f__2764__auto__.call(null);
(statearr_62684[(6)] = c__2763__auto__);

return statearr_62684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__62706 = arguments.length;
switch (G__62706) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62773){
var state_val_62774 = (state_62773[(1)]);
if((state_val_62774 === (7))){
var inst_62718 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62719 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62720 = cljs.core.PersistentHashMap.fromArrays(inst_62718,inst_62719);
var inst_62721 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_62720);
var inst_62722 = (function(){throw inst_62721})();
var state_62773__$1 = state_62773;
var statearr_62775_62814 = state_62773__$1;
(statearr_62775_62814[(2)] = inst_62722);

(statearr_62775_62814[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (20))){
var inst_62756 = (state_62773[(2)]);
var inst_62757 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_62758 = [ledger,password,user,auth,expire];
var inst_62759 = cljs.core.PersistentHashMap.fromArrays(inst_62757,inst_62758);
var inst_62760 = fluree.db.util.core.without_nils.call(null,inst_62759);
var inst_62761 = cljs.core.async.promise_chan.call(null);
var inst_62762 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62764 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_62760,inst_62761,null];
var inst_62765 = (new cljs.core.PersistentVector(null,4,(5),inst_62763,inst_62764,null));
var inst_62766 = cljs.core.async.put_BANG_.call(null,inst_62762,inst_62765);
var inst_62767 = (function (){var _ = inst_62756;
var data = inst_62760;
var pc = inst_62761;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_62768 = cljs.core.async.take_BANG_.call(null,inst_62761,inst_62767);
var _ = (function (){var statearr_62776 = state_62773;
(statearr_62776[(4)] = cljs.core.rest.call(null,(state_62773[(4)])));

return statearr_62776;
})();
var state_62773__$1 = (function (){var statearr_62777 = state_62773;
(statearr_62777[(7)] = inst_62766);

return statearr_62777;
})();
var statearr_62778_62815 = state_62773__$1;
(statearr_62778_62815[(2)] = inst_62768);

(statearr_62778_62815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (1))){
var state_62773__$1 = state_62773;
var statearr_62779_62816 = state_62773__$1;
(statearr_62779_62816[(2)] = null);

(statearr_62779_62816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (4))){
var inst_62707 = (state_62773[(2)]);
var inst_62708 = cljs.core.clj__GT_js.call(null,inst_62707);
var inst_62709 = reject.call(null,inst_62708);
var state_62773__$1 = state_62773;
var statearr_62780_62817 = state_62773__$1;
(statearr_62780_62817[(2)] = inst_62709);

(statearr_62780_62817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (15))){
var inst_62743 = (state_62773[(8)]);
var state_62773__$1 = state_62773;
var statearr_62781_62818 = state_62773__$1;
(statearr_62781_62818[(2)] = inst_62743);

(statearr_62781_62818[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (13))){
var inst_62736 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62737 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62738 = cljs.core.PersistentHashMap.fromArrays(inst_62736,inst_62737);
var inst_62739 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_62738);
var inst_62740 = (function(){throw inst_62739})();
var state_62773__$1 = state_62773;
var statearr_62782_62819 = state_62773__$1;
(statearr_62782_62819[(2)] = inst_62740);

(statearr_62782_62819[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (6))){
var state_62773__$1 = state_62773;
var statearr_62783_62820 = state_62773__$1;
(statearr_62783_62820[(2)] = null);

(statearr_62783_62820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (17))){
var inst_62747 = (state_62773[(2)]);
var state_62773__$1 = state_62773;
if(cljs.core.truth_(inst_62747)){
var statearr_62784_62821 = state_62773__$1;
(statearr_62784_62821[(1)] = (18));

} else {
var statearr_62785_62822 = state_62773__$1;
(statearr_62785_62822[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (3))){
var inst_62771 = (state_62773[(2)]);
var state_62773__$1 = state_62773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62773__$1,inst_62771);
} else {
if((state_val_62774 === (12))){
var state_62773__$1 = state_62773;
var statearr_62786_62823 = state_62773__$1;
(statearr_62786_62823[(2)] = null);

(statearr_62786_62823[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (2))){
var _ = (function (){var statearr_62787 = state_62773;
(statearr_62787[(4)] = cljs.core.cons.call(null,(5),(state_62773[(4)])));

return statearr_62787;
})();
var inst_62715 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_62773__$1 = state_62773;
if(cljs.core.truth_(inst_62715)){
var statearr_62788_62824 = state_62773__$1;
(statearr_62788_62824[(1)] = (6));

} else {
var statearr_62789_62825 = state_62773__$1;
(statearr_62789_62825[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (19))){
var inst_62750 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62751 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62752 = cljs.core.PersistentHashMap.fromArrays(inst_62750,inst_62751);
var inst_62753 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_62752);
var inst_62754 = (function(){throw inst_62753})();
var state_62773__$1 = state_62773;
var statearr_62790_62826 = state_62773__$1;
(statearr_62790_62826[(2)] = inst_62754);

(statearr_62790_62826[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (11))){
var inst_62733 = (state_62773[(2)]);
var state_62773__$1 = (function (){var statearr_62792 = state_62773;
(statearr_62792[(9)] = inst_62733);

return statearr_62792;
})();
if(cljs.core.truth_(password)){
var statearr_62793_62827 = state_62773__$1;
(statearr_62793_62827[(1)] = (12));

} else {
var statearr_62794_62828 = state_62773__$1;
(statearr_62794_62828[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (9))){
var state_62773__$1 = state_62773;
var statearr_62795_62829 = state_62773__$1;
(statearr_62795_62829[(2)] = null);

(statearr_62795_62829[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (5))){
var _ = (function (){var statearr_62796 = state_62773;
(statearr_62796[(4)] = cljs.core.rest.call(null,(state_62773[(4)])));

return statearr_62796;
})();
var state_62773__$1 = state_62773;
var ex62791 = (state_62773__$1[(2)]);
var statearr_62797_62830 = state_62773__$1;
(statearr_62797_62830[(5)] = ex62791);


var statearr_62798_62831 = state_62773__$1;
(statearr_62798_62831[(1)] = (4));

(statearr_62798_62831[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (14))){
var inst_62743 = (state_62773[(8)]);
var inst_62742 = (state_62773[(2)]);
var inst_62743__$1 = user;
var state_62773__$1 = (function (){var statearr_62799 = state_62773;
(statearr_62799[(10)] = inst_62742);

(statearr_62799[(8)] = inst_62743__$1);

return statearr_62799;
})();
if(cljs.core.truth_(inst_62743__$1)){
var statearr_62800_62832 = state_62773__$1;
(statearr_62800_62832[(1)] = (15));

} else {
var statearr_62801_62833 = state_62773__$1;
(statearr_62801_62833[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (16))){
var state_62773__$1 = state_62773;
var statearr_62802_62834 = state_62773__$1;
(statearr_62802_62834[(2)] = auth);

(statearr_62802_62834[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (10))){
var inst_62727 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62728 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62729 = cljs.core.PersistentHashMap.fromArrays(inst_62727,inst_62728);
var inst_62730 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_62729);
var inst_62731 = (function(){throw inst_62730})();
var state_62773__$1 = state_62773;
var statearr_62803_62835 = state_62773__$1;
(statearr_62803_62835[(2)] = inst_62731);

(statearr_62803_62835[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (18))){
var state_62773__$1 = state_62773;
var statearr_62804_62836 = state_62773__$1;
(statearr_62804_62836[(2)] = null);

(statearr_62804_62836[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62774 === (8))){
var inst_62724 = (state_62773[(2)]);
var state_62773__$1 = (function (){var statearr_62805 = state_62773;
(statearr_62805[(11)] = inst_62724);

return statearr_62805;
})();
if(cljs.core.truth_(ledger)){
var statearr_62806_62837 = state_62773__$1;
(statearr_62806_62837[(1)] = (9));

} else {
var statearr_62807_62838 = state_62773__$1;
(statearr_62807_62838[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_62808 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62808[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_62808[(1)] = (1));

return statearr_62808;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_62773){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_62773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62809){var ex__2744__auto__ = e62809;
var statearr_62810_62839 = state_62773;
(statearr_62810_62839[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_62773[(4)]))){
var statearr_62811_62840 = state_62773;
(statearr_62811_62840[(1)] = cljs.core.first.call(null,(state_62773[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62841 = state_62773;
state_62773 = G__62841;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_62773){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_62773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62812 = f__2764__auto__.call(null);
(statearr_62812[(6)] = c__2763__auto__);

return statearr_62812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__62843 = arguments.length;
switch (G__62843) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62878){
var state_val_62879 = (state_62878[(1)]);
if((state_val_62879 === (1))){
var state_62878__$1 = state_62878;
var statearr_62880_62900 = state_62878__$1;
(statearr_62880_62900[(2)] = null);

(statearr_62880_62900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62879 === (2))){
var _ = (function (){var statearr_62881 = state_62878;
(statearr_62881[(4)] = cljs.core.cons.call(null,(5),(state_62878[(4)])));

return statearr_62881;
})();
var inst_62852 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_62878__$1 = state_62878;
if(cljs.core.truth_(inst_62852)){
var statearr_62882_62901 = state_62878__$1;
(statearr_62882_62901[(1)] = (6));

} else {
var statearr_62883_62902 = state_62878__$1;
(statearr_62883_62902[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62879 === (3))){
var inst_62876 = (state_62878[(2)]);
var state_62878__$1 = state_62878;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62878__$1,inst_62876);
} else {
if((state_val_62879 === (4))){
var inst_62844 = (state_62878[(2)]);
var inst_62845 = cljs.core.clj__GT_js.call(null,inst_62844);
var inst_62846 = reject.call(null,inst_62845);
var state_62878__$1 = state_62878;
var statearr_62885_62903 = state_62878__$1;
(statearr_62885_62903[(2)] = inst_62846);

(statearr_62885_62903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62879 === (5))){
var _ = (function (){var statearr_62886 = state_62878;
(statearr_62886[(4)] = cljs.core.rest.call(null,(state_62878[(4)])));

return statearr_62886;
})();
var state_62878__$1 = state_62878;
var ex62884 = (state_62878__$1[(2)]);
var statearr_62887_62904 = state_62878__$1;
(statearr_62887_62904[(5)] = ex62884);


var statearr_62888_62905 = state_62878__$1;
(statearr_62888_62905[(1)] = (4));

(statearr_62888_62905[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62879 === (6))){
var state_62878__$1 = state_62878;
var statearr_62889_62906 = state_62878__$1;
(statearr_62889_62906[(2)] = null);

(statearr_62889_62906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62879 === (7))){
var inst_62855 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62856 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62857 = cljs.core.PersistentHashMap.fromArrays(inst_62855,inst_62856);
var inst_62858 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_62857);
var inst_62859 = (function(){throw inst_62858})();
var state_62878__$1 = state_62878;
var statearr_62890_62907 = state_62878__$1;
(statearr_62890_62907[(2)] = inst_62859);

(statearr_62890_62907[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62879 === (8))){
var inst_62861 = (state_62878[(2)]);
var inst_62862 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_62863 = [jwt,expire];
var inst_62864 = cljs.core.PersistentHashMap.fromArrays(inst_62862,inst_62863);
var inst_62865 = fluree.db.util.core.without_nils.call(null,inst_62864);
var inst_62866 = cljs.core.async.promise_chan.call(null);
var inst_62867 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62869 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_62865,inst_62866,null];
var inst_62870 = (new cljs.core.PersistentVector(null,4,(5),inst_62868,inst_62869,null));
var inst_62871 = cljs.core.async.put_BANG_.call(null,inst_62867,inst_62870);
var inst_62872 = (function (){var _ = inst_62861;
var data = inst_62865;
var pc = inst_62866;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_62873 = cljs.core.async.take_BANG_.call(null,inst_62866,inst_62872);
var _ = (function (){var statearr_62891 = state_62878;
(statearr_62891[(4)] = cljs.core.rest.call(null,(state_62878[(4)])));

return statearr_62891;
})();
var state_62878__$1 = (function (){var statearr_62892 = state_62878;
(statearr_62892[(7)] = inst_62871);

return statearr_62892;
})();
var statearr_62893_62908 = state_62878__$1;
(statearr_62893_62908[(2)] = inst_62873);

(statearr_62893_62908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_62894 = [null,null,null,null,null,null,null,null];
(statearr_62894[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_62894[(1)] = (1));

return statearr_62894;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_62878){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_62878);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62895){var ex__2744__auto__ = e62895;
var statearr_62896_62909 = state_62878;
(statearr_62896_62909[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_62878[(4)]))){
var statearr_62897_62910 = state_62878;
(statearr_62897_62910[(1)] = cljs.core.first.call(null,(state_62878[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62911 = state_62878;
state_62878 = G__62911;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_62878){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_62878);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62898 = f__2764__auto__.call(null);
(statearr_62898[(6)] = c__2763__auto__);

return statearr_62898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

