// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__26456 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__26456,(0),null);
var network = cljs.core.nth.call(null,vec__26456,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__26456,(2),null);
if(cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__26459){
var map__26460 = p__26459;
var map__26460__$1 = cljs.core.__destructure_map.call(null,map__26460);
var opts = map__26460__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__26460__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_26520){
var state_val_26521 = (state_26520[(1)]);
if((state_val_26521 === (7))){
var inst_26491 = cljs.core.not.call(null,reindex_QMARK_);
var state_26520__$1 = state_26520;
var statearr_26522_26546 = state_26520__$1;
(statearr_26522_26546[(2)] = inst_26491);

(statearr_26522_26546[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26521 === (1))){
var state_26520__$1 = state_26520;
var statearr_26523_26547 = state_26520__$1;
(statearr_26523_26547[(2)] = null);

(statearr_26523_26547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26521 === (4))){
var inst_26461 = (state_26520[(2)]);
var state_26520__$1 = state_26520;
var statearr_26524_26548 = state_26520__$1;
(statearr_26524_26548[(2)] = inst_26461);

(statearr_26524_26548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26521 === (6))){
var inst_26481 = (state_26520[(7)]);
var inst_26475 = (state_26520[(8)]);
var inst_26489 = (state_26520[(9)]);
var inst_26474 = (state_26520[(2)]);
var inst_26475__$1 = fluree.db.util.async.throw_err.call(null,inst_26474);
var inst_26476 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_26477 = cljs.core.__destructure_map.call(null,inst_26476);
var inst_26478 = cljs.core.get.call(null,inst_26477,new cljs.core.Keyword(null,"post","post",269697687));
var inst_26479 = cljs.core.get.call(null,inst_26477,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_26480 = fluree.db.flake.size_bytes.call(null,inst_26475__$1);
var inst_26481__$1 = (inst_26479 + inst_26480);
var inst_26482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26483 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_26484 = (new cljs.core.PersistentVector(null,2,(5),inst_26482,inst_26483,null));
var inst_26485 = cljs.core.get_in.call(null,db,inst_26484);
var inst_26486 = cljs.core.__destructure_map.call(null,inst_26485);
var inst_26487 = cljs.core.get.call(null,inst_26486,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_26488 = cljs.core.get.call(null,inst_26486,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_26489__$1 = (inst_26481__$1 > inst_26488);
var state_26520__$1 = (function (){var statearr_26525 = state_26520;
(statearr_26525[(10)] = inst_26487);

(statearr_26525[(7)] = inst_26481__$1);

(statearr_26525[(11)] = inst_26478);

(statearr_26525[(8)] = inst_26475__$1);

(statearr_26525[(9)] = inst_26489__$1);

return statearr_26525;
})();
if(cljs.core.truth_(inst_26489__$1)){
var statearr_26526_26549 = state_26520__$1;
(statearr_26526_26549[(1)] = (7));

} else {
var statearr_26527_26550 = state_26520__$1;
(statearr_26527_26550[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26521 === (3))){
var inst_26518 = (state_26520[(2)]);
var state_26520__$1 = state_26520;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26520__$1,inst_26518);
} else {
if((state_val_26521 === (12))){
var inst_26481 = (state_26520[(7)]);
var inst_26478 = (state_26520[(11)]);
var inst_26475 = (state_26520[(8)]);
var inst_26504 = (state_26520[(2)]);
var inst_26505 = cljs.core.into.call(null,inst_26478,inst_26475);
var inst_26506 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_26507 = cljs.core.swap_BANG_.call(null,inst_26506,cljs.core.empty);
var inst_26508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26509 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26510 = (new cljs.core.PersistentVector(null,2,(5),inst_26508,inst_26509,null));
var inst_26511 = cljs.core.assoc_in.call(null,db,inst_26510,inst_26505);
var inst_26512 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26513 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26514 = (new cljs.core.PersistentVector(null,2,(5),inst_26512,inst_26513,null));
var inst_26515 = cljs.core.assoc_in.call(null,inst_26511,inst_26514,inst_26481);
var _ = (function (){var statearr_26528 = state_26520;
(statearr_26528[(4)] = cljs.core.rest.call(null,(state_26520[(4)])));

return statearr_26528;
})();
var state_26520__$1 = (function (){var statearr_26529 = state_26520;
(statearr_26529[(12)] = inst_26504);

(statearr_26529[(13)] = inst_26507);

return statearr_26529;
})();
var statearr_26530_26551 = state_26520__$1;
(statearr_26530_26551[(2)] = inst_26515);

(statearr_26530_26551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26521 === (2))){
var _ = (function (){var statearr_26531 = state_26520;
(statearr_26531[(4)] = cljs.core.cons.call(null,(5),(state_26520[(4)])));

return statearr_26531;
})();
var inst_26469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26470 = [pred_id];
var inst_26471 = (new cljs.core.PersistentVector(null,1,(5),inst_26469,inst_26470,null));
var inst_26472 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26471);
var state_26520__$1 = state_26520;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26520__$1,(6),inst_26472);
} else {
if((state_val_26521 === (11))){
var state_26520__$1 = state_26520;
var statearr_26533_26552 = state_26520__$1;
(statearr_26533_26552[(2)] = null);

(statearr_26533_26552[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26521 === (9))){
var inst_26494 = (state_26520[(2)]);
var state_26520__$1 = state_26520;
if(cljs.core.truth_(inst_26494)){
var statearr_26534_26553 = state_26520__$1;
(statearr_26534_26553[(1)] = (10));

} else {
var statearr_26535_26554 = state_26520__$1;
(statearr_26535_26554[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26521 === (5))){
var _ = (function (){var statearr_26536 = state_26520;
(statearr_26536[(4)] = cljs.core.rest.call(null,(state_26520[(4)])));

return statearr_26536;
})();
var state_26520__$1 = state_26520;
var ex26532 = (state_26520__$1[(2)]);
var statearr_26537_26555 = state_26520__$1;
(statearr_26537_26555[(5)] = ex26532);


if((ex26532 instanceof Error)){
var statearr_26538_26556 = state_26520__$1;
(statearr_26538_26556[(1)] = (4));

(statearr_26538_26556[(5)] = null);

} else {
throw ex26532;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26521 === (10))){
var inst_26496 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_26497 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_26498 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_26499 = cljs.core.PersistentHashMap.fromArrays(inst_26497,inst_26498);
var inst_26500 = cljs.core.ex_info.call(null,inst_26496,inst_26499);
var inst_26501 = (function(){throw inst_26500})();
var state_26520__$1 = state_26520;
var statearr_26539_26557 = state_26520__$1;
(statearr_26539_26557[(2)] = inst_26501);

(statearr_26539_26557[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26521 === (8))){
var inst_26489 = (state_26520[(9)]);
var state_26520__$1 = state_26520;
var statearr_26540_26558 = state_26520__$1;
(statearr_26540_26558[(2)] = inst_26489);

(statearr_26540_26558[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto____0 = (function (){
var statearr_26541 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26541[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto__);

(statearr_26541[(1)] = (1));

return statearr_26541;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto____1 = (function (state_26520){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_26520);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e26542){var ex__2744__auto__ = e26542;
var statearr_26543_26559 = state_26520;
(statearr_26543_26559[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_26520[(4)]))){
var statearr_26544_26560 = state_26520;
(statearr_26544_26560[(1)] = cljs.core.first.call(null,(state_26520[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26561 = state_26520;
state_26520 = G__26561;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto__ = function(state_26520){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto____1.call(this,state_26520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_26545 = f__2764__auto__.call(null);
(statearr_26545[(6)] = c__2763__auto__);

return statearr_26545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__26566 = arguments.length;
switch (G__26566) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_26762){
var state_val_26763 = (state_26762[(1)]);
if((state_val_26763 === (7))){
var state_26762__$1 = state_26762;
var statearr_26764_26831 = state_26762__$1;
(statearr_26764_26831[(2)] = null);

(statearr_26764_26831[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (20))){
var inst_26686 = (state_26762[(7)]);
var inst_26684 = (state_26762[(8)]);
var inst_26605 = (state_26762[(9)]);
var inst_26685 = (state_26762[(10)]);
var inst_26604 = (state_26762[(11)]);
var inst_26655 = (state_26762[(12)]);
var inst_26687 = (state_26762[(13)]);
var inst_26688 = (state_26762[(14)]);
var inst_26698 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26700 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26701 = (new cljs.core.PersistentVector(null,2,(5),inst_26699,inst_26700,null));
var inst_26702 = cljs.core.get_in.call(null,inst_26655,inst_26701);
var inst_26703 = (inst_26604 + inst_26702);
var inst_26704 = [inst_26684,inst_26685,inst_26686,inst_26687,inst_26703];
var inst_26705 = cljs.core.PersistentHashMap.fromArrays(inst_26698,inst_26704);
var inst_26706 = cljs.core.assoc.call(null,inst_26655,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26688,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26705);
var state_26762__$1 = (function (){var statearr_26765 = state_26762;
(statearr_26765[(15)] = inst_26706);

return statearr_26765;
})();
if(cljs.core.truth_(inst_26605)){
var statearr_26766_26832 = state_26762__$1;
(statearr_26766_26832[(1)] = (23));

} else {
var statearr_26767_26833 = state_26762__$1;
(statearr_26767_26833[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (27))){
var inst_26706 = (state_26762[(15)]);
var state_26762__$1 = state_26762;
var statearr_26768_26834 = state_26762__$1;
(statearr_26768_26834[(2)] = inst_26706);

(statearr_26768_26834[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (1))){
var state_26762__$1 = state_26762;
var statearr_26769_26835 = state_26762__$1;
(statearr_26769_26835[(2)] = null);

(statearr_26769_26835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (24))){
var inst_26706 = (state_26762[(15)]);
var inst_26709 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26706);
var inst_26710 = (inst_26709 == null);
var state_26762__$1 = state_26762;
var statearr_26770_26836 = state_26762__$1;
(statearr_26770_26836[(2)] = inst_26710);

(statearr_26770_26836[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (39))){
var inst_26737 = (state_26762[(16)]);
var inst_26745 = (state_26762[(17)]);
var inst_26738 = (state_26762[(18)]);
var inst_26695 = (state_26762[(19)]);
var inst_26736 = (state_26762[(20)]);
var inst_26752 = (state_26762[(2)]);
var inst_26683 = inst_26695;
var inst_26684 = inst_26737;
var inst_26685 = inst_26738;
var inst_26686 = inst_26745;
var inst_26687 = inst_26752;
var inst_26688 = inst_26736;
var state_26762__$1 = (function (){var statearr_26771 = state_26762;
(statearr_26771[(7)] = inst_26686);

(statearr_26771[(8)] = inst_26684);

(statearr_26771[(21)] = inst_26683);

(statearr_26771[(10)] = inst_26685);

(statearr_26771[(13)] = inst_26687);

(statearr_26771[(14)] = inst_26688);

return statearr_26771;
})();
var statearr_26772_26837 = state_26762__$1;
(statearr_26772_26837[(2)] = null);

(statearr_26772_26837[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (4))){
var inst_26567 = (state_26762[(2)]);
var state_26762__$1 = state_26762;
var statearr_26773_26838 = state_26762__$1;
(statearr_26773_26838[(2)] = inst_26567);

(statearr_26773_26838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (15))){
var inst_26627 = (state_26762[(22)]);
var state_26762__$1 = state_26762;
var statearr_26774_26839 = state_26762__$1;
(statearr_26774_26839[(2)] = inst_26627);

(statearr_26774_26839[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (21))){
var inst_26664 = (state_26762[(23)]);
var inst_26606 = (state_26762[(24)]);
var inst_26589 = (state_26762[(25)]);
var inst_26603 = (state_26762[(26)]);
var inst_26686 = (state_26762[(7)]);
var inst_26595 = (state_26762[(27)]);
var inst_26684 = (state_26762[(8)]);
var inst_26683 = (state_26762[(21)]);
var inst_26614 = (state_26762[(28)]);
var inst_26665 = (state_26762[(29)]);
var inst_26695 = (state_26762[(19)]);
var inst_26605 = (state_26762[(9)]);
var inst_26685 = (state_26762[(10)]);
var inst_26604 = (state_26762[(11)]);
var inst_26655 = (state_26762[(12)]);
var inst_26694 = (state_26762[(30)]);
var inst_26687 = (state_26762[(13)]);
var inst_26591 = (state_26762[(31)]);
var inst_26574 = (state_26762[(32)]);
var inst_26608 = (state_26762[(33)]);
var inst_26688 = (state_26762[(14)]);
var inst_26599 = (state_26762[(34)]);
var inst_26733 = inst_26694.s;
var inst_26734 = fluree.db.flake.sid__GT_cid.call(null,inst_26733);
var inst_26735 = (function (){var flakes_bytes = inst_26604;
var t = inst_26574;
var spot = inst_26684;
var add_flakes = inst_26591;
var root_setting_change_QMARK_ = inst_26606;
var ref_QMARK__map = inst_26603;
var r = inst_26695;
var psot = inst_26685;
var vec__26660 = inst_26591;
var vec__26690 = inst_26683;
var add_pred_to_idx_QMARK_ = inst_26614;
var _ = inst_26589;
var cid = inst_26734;
var ecount = inst_26688;
var seq__26691 = inst_26695;
var pred_ecount = inst_26608;
var seq__26661 = inst_26665;
var db_STAR_ = inst_26655;
var schema_change_QMARK_ = inst_26605;
var G__26659 = inst_26683;
var add_preds = inst_26595;
var first__26692 = inst_26694;
var opst = inst_26687;
var first__26662 = inst_26664;
var idx_QMARK__map = inst_26599;
var post = inst_26686;
var f = inst_26694;
return (function (p1__26564_SHARP_){
if(cljs.core.truth_(p1__26564_SHARP_)){
var x__4336__auto__ = p1__26564_SHARP_;
var y__4337__auto__ = f.s;
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
} else {
return f.s;
}
});
})();
var inst_26736 = cljs.core.update.call(null,inst_26688,inst_26734,inst_26735);
var inst_26737 = cljs.core.conj.call(null,inst_26684,inst_26694);
var inst_26738 = cljs.core.conj.call(null,inst_26685,inst_26694);
var inst_26739 = inst_26694.p;
var inst_26740 = cljs.core.get.call(null,inst_26599,inst_26739);
var state_26762__$1 = (function (){var statearr_26775 = state_26762;
(statearr_26775[(16)] = inst_26737);

(statearr_26775[(18)] = inst_26738);

(statearr_26775[(20)] = inst_26736);

return statearr_26775;
})();
if(cljs.core.truth_(inst_26740)){
var statearr_26776_26840 = state_26762__$1;
(statearr_26776_26840[(1)] = (34));

} else {
var statearr_26777_26841 = state_26762__$1;
(statearr_26777_26841[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (31))){
var inst_26721 = (state_26762[(35)]);
var state_26762__$1 = state_26762;
var statearr_26778_26842 = state_26762__$1;
(statearr_26778_26842[(2)] = inst_26721);

(statearr_26778_26842[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (32))){
var inst_26731 = (state_26762[(2)]);
var state_26762__$1 = state_26762;
var statearr_26779_26843 = state_26762__$1;
(statearr_26779_26843[(2)] = inst_26731);

(statearr_26779_26843[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (33))){
var inst_26721 = (state_26762[(35)]);
var inst_26726 = (state_26762[(2)]);
var inst_26727 = fluree.db.util.async.throw_err.call(null,inst_26726);
var inst_26728 = cljs.core.assoc.call(null,inst_26721,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26727);
var state_26762__$1 = state_26762;
var statearr_26780_26844 = state_26762__$1;
(statearr_26780_26844[(2)] = inst_26728);

(statearr_26780_26844[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (13))){
var inst_26604 = (state_26762[(11)]);
var inst_26655 = (state_26762[(12)]);
var inst_26591 = (state_26762[(31)]);
var inst_26574 = (state_26762[(32)]);
var inst_26645 = (state_26762[(2)]);
var inst_26646 = cljs.core.assoc.call(null,inst_26645,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26574);
var inst_26647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26648 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26649 = (new cljs.core.PersistentVector(null,2,(5),inst_26647,inst_26648,null));
var inst_26650 = cljs.core.update_in.call(null,inst_26646,inst_26649,cljs.core._PLUS_,inst_26604);
var inst_26651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26652 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26653 = (new cljs.core.PersistentVector(null,2,(5),inst_26651,inst_26652,null));
var inst_26654 = cljs.core.count.call(null,inst_26591);
var inst_26655__$1 = cljs.core.update_in.call(null,inst_26650,inst_26653,cljs.core._PLUS_,inst_26654);
var inst_26663 = cljs.core.seq.call(null,inst_26591);
var inst_26664 = cljs.core.first.call(null,inst_26663);
var inst_26665 = cljs.core.next.call(null,inst_26663);
var inst_26666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26667 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26668 = (new cljs.core.PersistentVector(null,2,(5),inst_26666,inst_26667,null));
var inst_26669 = cljs.core.get_in.call(null,inst_26655__$1,inst_26668);
var inst_26670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26671 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26672 = (new cljs.core.PersistentVector(null,2,(5),inst_26670,inst_26671,null));
var inst_26673 = cljs.core.get_in.call(null,inst_26655__$1,inst_26672);
var inst_26674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26675 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26676 = (new cljs.core.PersistentVector(null,2,(5),inst_26674,inst_26675,null));
var inst_26677 = cljs.core.get_in.call(null,inst_26655__$1,inst_26676);
var inst_26678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26679 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26680 = (new cljs.core.PersistentVector(null,2,(5),inst_26678,inst_26679,null));
var inst_26681 = cljs.core.get_in.call(null,inst_26655__$1,inst_26680);
var inst_26682 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26683 = inst_26591;
var inst_26684 = inst_26669;
var inst_26685 = inst_26673;
var inst_26686 = inst_26677;
var inst_26687 = inst_26681;
var inst_26688 = inst_26682;
var state_26762__$1 = (function (){var statearr_26781 = state_26762;
(statearr_26781[(23)] = inst_26664);

(statearr_26781[(7)] = inst_26686);

(statearr_26781[(8)] = inst_26684);

(statearr_26781[(21)] = inst_26683);

(statearr_26781[(29)] = inst_26665);

(statearr_26781[(10)] = inst_26685);

(statearr_26781[(12)] = inst_26655__$1);

(statearr_26781[(13)] = inst_26687);

(statearr_26781[(14)] = inst_26688);

return statearr_26781;
})();
var statearr_26782_26845 = state_26762__$1;
(statearr_26782_26845[(2)] = null);

(statearr_26782_26845[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (22))){
var inst_26755 = (state_26762[(2)]);
var state_26762__$1 = state_26762;
var statearr_26783_26846 = state_26762__$1;
(statearr_26783_26846[(2)] = inst_26755);

(statearr_26783_26846[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (36))){
var inst_26603 = (state_26762[(26)]);
var inst_26694 = (state_26762[(30)]);
var inst_26745 = (state_26762[(2)]);
var inst_26746 = inst_26694.p;
var inst_26747 = cljs.core.get.call(null,inst_26603,inst_26746);
var state_26762__$1 = (function (){var statearr_26784 = state_26762;
(statearr_26784[(17)] = inst_26745);

return statearr_26784;
})();
if(cljs.core.truth_(inst_26747)){
var statearr_26785_26847 = state_26762__$1;
(statearr_26785_26847[(1)] = (37));

} else {
var statearr_26786_26848 = state_26762__$1;
(statearr_26786_26848[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (29))){
var inst_26706 = (state_26762[(15)]);
var inst_26716 = (state_26762[(2)]);
var inst_26717 = fluree.db.util.async.throw_err.call(null,inst_26716);
var inst_26718 = cljs.core.assoc.call(null,inst_26706,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26717);
var state_26762__$1 = state_26762;
var statearr_26787_26849 = state_26762__$1;
(statearr_26787_26849[(2)] = inst_26718);

(statearr_26787_26849[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (6))){
var inst_26574 = (state_26762[(32)]);
var inst_26579 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26580 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26581 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26579)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26580)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26574),"."].join('');
var inst_26582 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26583 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26584 = cljs.core.PersistentHashMap.fromArrays(inst_26582,inst_26583);
var inst_26585 = cljs.core.ex_info.call(null,inst_26581,inst_26584);
var inst_26586 = (function(){throw inst_26585})();
var state_26762__$1 = state_26762;
var statearr_26788_26850 = state_26762__$1;
(statearr_26788_26850[(2)] = inst_26586);

(statearr_26788_26850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (28))){
var inst_26606 = (state_26762[(24)]);
var inst_26721 = (state_26762[(2)]);
var state_26762__$1 = (function (){var statearr_26789 = state_26762;
(statearr_26789[(35)] = inst_26721);

return statearr_26789;
})();
if(cljs.core.truth_(inst_26606)){
var statearr_26790_26851 = state_26762__$1;
(statearr_26790_26851[(1)] = (30));

} else {
var statearr_26791_26852 = state_26762__$1;
(statearr_26791_26852[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (25))){
var inst_26712 = (state_26762[(2)]);
var state_26762__$1 = state_26762;
if(cljs.core.truth_(inst_26712)){
var statearr_26792_26853 = state_26762__$1;
(statearr_26792_26853[(1)] = (26));

} else {
var statearr_26793_26854 = state_26762__$1;
(statearr_26793_26854[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (34))){
var inst_26686 = (state_26762[(7)]);
var inst_26694 = (state_26762[(30)]);
var inst_26742 = cljs.core.conj.call(null,inst_26686,inst_26694);
var state_26762__$1 = state_26762;
var statearr_26794_26855 = state_26762__$1;
(statearr_26794_26855[(2)] = inst_26742);

(statearr_26794_26855[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (17))){
var inst_26634 = (state_26762[(36)]);
var inst_26638 = (state_26762[(2)]);
var inst_26639 = fluree.db.util.async.throw_err.call(null,inst_26638);
var inst_26626 = inst_26634;
var inst_26627 = inst_26639;
var state_26762__$1 = (function (){var statearr_26795 = state_26762;
(statearr_26795[(37)] = inst_26626);

(statearr_26795[(22)] = inst_26627);

return statearr_26795;
})();
var statearr_26796_26856 = state_26762__$1;
(statearr_26796_26856[(2)] = null);

(statearr_26796_26856[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (3))){
var inst_26760 = (state_26762[(2)]);
var state_26762__$1 = state_26762;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26762__$1,inst_26760);
} else {
if((state_val_26763 === (12))){
var inst_26633 = (state_26762[(38)]);
var inst_26626 = (state_26762[(37)]);
var inst_26632 = cljs.core.seq.call(null,inst_26626);
var inst_26633__$1 = cljs.core.first.call(null,inst_26632);
var inst_26634 = cljs.core.next.call(null,inst_26632);
var state_26762__$1 = (function (){var statearr_26797 = state_26762;
(statearr_26797[(38)] = inst_26633__$1);

(statearr_26797[(36)] = inst_26634);

return statearr_26797;
})();
if(cljs.core.truth_(inst_26633__$1)){
var statearr_26798_26857 = state_26762__$1;
(statearr_26798_26857[(1)] = (14));

} else {
var statearr_26799_26858 = state_26762__$1;
(statearr_26799_26858[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (2))){
var inst_26574 = (state_26762[(32)]);
var _ = (function (){var statearr_26800 = state_26762;
(statearr_26800[(4)] = cljs.core.cons.call(null,(5),(state_26762[(4)])));

return statearr_26800;
})();
var inst_26573 = cljs.core.first.call(null,flakes);
var inst_26574__$1 = inst_26573.t;
var inst_26575 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26576 = (inst_26575 - (1));
var inst_26577 = cljs.core.not_EQ_.call(null,inst_26574__$1,inst_26576);
var state_26762__$1 = (function (){var statearr_26801 = state_26762;
(statearr_26801[(32)] = inst_26574__$1);

return statearr_26801;
})();
if(inst_26577){
var statearr_26802_26859 = state_26762__$1;
(statearr_26802_26859[(1)] = (6));

} else {
var statearr_26803_26860 = state_26762__$1;
(statearr_26803_26860[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (23))){
var inst_26605 = (state_26762[(9)]);
var state_26762__$1 = state_26762;
var statearr_26804_26861 = state_26762__$1;
(statearr_26804_26861[(2)] = inst_26605);

(statearr_26804_26861[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (35))){
var inst_26686 = (state_26762[(7)]);
var state_26762__$1 = state_26762;
var statearr_26805_26862 = state_26762__$1;
(statearr_26805_26862[(2)] = inst_26686);

(statearr_26805_26862[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (19))){
var inst_26757 = (state_26762[(2)]);
var _ = (function (){var statearr_26806 = state_26762;
(statearr_26806[(4)] = cljs.core.rest.call(null,(state_26762[(4)])));

return statearr_26806;
})();
var state_26762__$1 = state_26762;
var statearr_26807_26863 = state_26762__$1;
(statearr_26807_26863[(2)] = inst_26757);

(statearr_26807_26863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (11))){
var inst_26614 = (state_26762[(28)]);
var inst_26614__$1 = (state_26762[(2)]);
var inst_26622 = cljs.core.seq.call(null,inst_26614__$1);
var inst_26623 = cljs.core.first.call(null,inst_26622);
var inst_26624 = cljs.core.next.call(null,inst_26622);
var inst_26625 = db;
var inst_26626 = inst_26614__$1;
var inst_26627 = inst_26625;
var state_26762__$1 = (function (){var statearr_26809 = state_26762;
(statearr_26809[(37)] = inst_26626);

(statearr_26809[(28)] = inst_26614__$1);

(statearr_26809[(39)] = inst_26624);

(statearr_26809[(40)] = inst_26623);

(statearr_26809[(22)] = inst_26627);

return statearr_26809;
})();
var statearr_26810_26864 = state_26762__$1;
(statearr_26810_26864[(2)] = null);

(statearr_26810_26864[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (9))){
var inst_26591 = (state_26762[(31)]);
var inst_26608 = (state_26762[(33)]);
var inst_26610 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_26591,inst_26608);
var state_26762__$1 = state_26762;
var statearr_26811_26865 = state_26762__$1;
(statearr_26811_26865[(2)] = inst_26610);

(statearr_26811_26865[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (5))){
var _ = (function (){var statearr_26812 = state_26762;
(statearr_26812[(4)] = cljs.core.rest.call(null,(state_26762[(4)])));

return statearr_26812;
})();
var state_26762__$1 = state_26762;
var ex26808 = (state_26762__$1[(2)]);
var statearr_26813_26866 = state_26762__$1;
(statearr_26813_26866[(5)] = ex26808);


if((ex26808 instanceof Error)){
var statearr_26814_26867 = state_26762__$1;
(statearr_26814_26867[(1)] = (4));

(statearr_26814_26867[(5)] = null);

} else {
throw ex26808;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (14))){
var inst_26633 = (state_26762[(38)]);
var inst_26627 = (state_26762[(22)]);
var inst_26636 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_26627,inst_26633,opts);
var state_26762__$1 = state_26762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26762__$1,(17),inst_26636);
} else {
if((state_val_26763 === (26))){
var inst_26706 = (state_26762[(15)]);
var inst_26714 = fluree.db.query.schema.schema_map.call(null,inst_26706);
var state_26762__$1 = state_26762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26762__$1,(29),inst_26714);
} else {
if((state_val_26763 === (16))){
var inst_26643 = (state_26762[(2)]);
var state_26762__$1 = state_26762;
var statearr_26815_26868 = state_26762__$1;
(statearr_26815_26868[(2)] = inst_26643);

(statearr_26815_26868[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (38))){
var inst_26687 = (state_26762[(13)]);
var state_26762__$1 = state_26762;
var statearr_26816_26869 = state_26762__$1;
(statearr_26816_26869[(2)] = inst_26687);

(statearr_26816_26869[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (30))){
var inst_26721 = (state_26762[(35)]);
var inst_26724 = fluree.db.query.schema.setting_map.call(null,inst_26721);
var state_26762__$1 = state_26762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26762__$1,(33),inst_26724);
} else {
if((state_val_26763 === (10))){
var inst_26612 = cljs.core.PersistentVector.EMPTY;
var state_26762__$1 = state_26762;
var statearr_26817_26870 = state_26762__$1;
(statearr_26817_26870[(2)] = inst_26612);

(statearr_26817_26870[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (18))){
var inst_26683 = (state_26762[(21)]);
var inst_26694 = (state_26762[(30)]);
var inst_26693 = cljs.core.seq.call(null,inst_26683);
var inst_26694__$1 = cljs.core.first.call(null,inst_26693);
var inst_26695 = cljs.core.next.call(null,inst_26693);
var inst_26696 = cljs.core.not.call(null,inst_26694__$1);
var state_26762__$1 = (function (){var statearr_26818 = state_26762;
(statearr_26818[(19)] = inst_26695);

(statearr_26818[(30)] = inst_26694__$1);

return statearr_26818;
})();
if(inst_26696){
var statearr_26819_26871 = state_26762__$1;
(statearr_26819_26871[(1)] = (20));

} else {
var statearr_26820_26872 = state_26762__$1;
(statearr_26820_26872[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (37))){
var inst_26694 = (state_26762[(30)]);
var inst_26687 = (state_26762[(13)]);
var inst_26749 = cljs.core.conj.call(null,inst_26687,inst_26694);
var state_26762__$1 = state_26762;
var statearr_26821_26873 = state_26762__$1;
(statearr_26821_26873[(2)] = inst_26749);

(statearr_26821_26873[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (8))){
var inst_26589 = (state_26762[(25)]);
var inst_26595 = (state_26762[(27)]);
var inst_26605 = (state_26762[(9)]);
var inst_26591 = (state_26762[(31)]);
var inst_26574 = (state_26762[(32)]);
var inst_26599 = (state_26762[(34)]);
var inst_26589__$1 = (state_26762[(2)]);
var inst_26590 = (function (){var t = inst_26574;
var _ = inst_26589__$1;
return (function (p1__26562_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__26562_SHARP_.p));
});
})();
var inst_26591__$1 = cljs.core.filter.call(null,inst_26590,flakes);
var inst_26592 = cljs.core.PersistentHashSet.EMPTY;
var inst_26593 = (function (){var t = inst_26574;
var _ = inst_26589__$1;
var add_flakes = inst_26591__$1;
return (function (p1__26563_SHARP_){
return p1__26563_SHARP_.p;
});
})();
var inst_26594 = cljs.core.map.call(null,inst_26593,inst_26591__$1);
var inst_26595__$1 = cljs.core.into.call(null,inst_26592,inst_26594);
var inst_26596 = cljs.core.PersistentHashMap.EMPTY;
var inst_26597 = (function (){var t = inst_26574;
var _ = inst_26589__$1;
var add_flakes = inst_26591__$1;
var add_preds = inst_26595__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26598 = cljs.core.map.call(null,inst_26597,inst_26595__$1);
var inst_26599__$1 = cljs.core.into.call(null,inst_26596,inst_26598);
var inst_26600 = cljs.core.PersistentHashMap.EMPTY;
var inst_26601 = (function (){var t = inst_26574;
var _ = inst_26589__$1;
var add_flakes = inst_26591__$1;
var add_preds = inst_26595__$1;
var idx_QMARK__map = inst_26599__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26602 = cljs.core.map.call(null,inst_26601,inst_26595__$1);
var inst_26603 = cljs.core.into.call(null,inst_26600,inst_26602);
var inst_26604 = fluree.db.flake.size_bytes.call(null,inst_26591__$1);
var inst_26605__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_26591__$1);
var inst_26606 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_26591__$1);
var inst_26607 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26608 = cljs.core.get.call(null,inst_26607,(0));
var state_26762__$1 = (function (){var statearr_26822 = state_26762;
(statearr_26822[(24)] = inst_26606);

(statearr_26822[(25)] = inst_26589__$1);

(statearr_26822[(26)] = inst_26603);

(statearr_26822[(27)] = inst_26595__$1);

(statearr_26822[(9)] = inst_26605__$1);

(statearr_26822[(11)] = inst_26604);

(statearr_26822[(31)] = inst_26591__$1);

(statearr_26822[(33)] = inst_26608);

(statearr_26822[(34)] = inst_26599__$1);

return statearr_26822;
})();
if(cljs.core.truth_(inst_26605__$1)){
var statearr_26823_26874 = state_26762__$1;
(statearr_26823_26874[(1)] = (9));

} else {
var statearr_26824_26875 = state_26762__$1;
(statearr_26824_26875[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2741__auto__ = null;
var fluree$db$graphdb$state_machine__2741__auto____0 = (function (){
var statearr_26825 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26825[(0)] = fluree$db$graphdb$state_machine__2741__auto__);

(statearr_26825[(1)] = (1));

return statearr_26825;
});
var fluree$db$graphdb$state_machine__2741__auto____1 = (function (state_26762){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_26762);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e26826){var ex__2744__auto__ = e26826;
var statearr_26827_26876 = state_26762;
(statearr_26827_26876[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_26762[(4)]))){
var statearr_26828_26877 = state_26762;
(statearr_26828_26877[(1)] = cljs.core.first.call(null,(state_26762[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26878 = state_26762;
state_26762 = G__26878;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2741__auto__ = function(state_26762){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2741__auto____1.call(this,state_26762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2741__auto____0;
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2741__auto____1;
return fluree$db$graphdb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_26829 = f__2764__auto__.call(null);
(statearr_26829[(6)] = c__2763__auto__);

return statearr_26829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26880 = arguments.length;
switch (G__26880) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2763__auto___27027 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_26976){
var state_val_26977 = (state_26976[(1)]);
if((state_val_26977 === (7))){
var state_26976__$1 = state_26976;
var statearr_26978_27028 = state_26976__$1;
(statearr_26978_27028[(2)] = null);

(statearr_26978_27028[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (20))){
var inst_26925 = (state_26976[(7)]);
var inst_26926 = (state_26976[(8)]);
var inst_26924 = (state_26976[(9)]);
var inst_26945 = (inst_26924 + (1));
var inst_26946 = cljs.core.assoc.call(null,inst_26926,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26945);
var inst_26947 = fluree.db.graphdb.with_t.call(null,inst_26946,inst_26925,opts);
var state_26976__$1 = state_26976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26976__$1,(23),inst_26947);
} else {
if((state_val_26977 === (1))){
var state_26976__$1 = state_26976;
var statearr_26979_27029 = state_26976__$1;
(statearr_26979_27029[(2)] = null);

(statearr_26979_27029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (24))){
var inst_26950 = (state_26976[(10)]);
var inst_26953 = cljs.core.assoc.call(null,inst_26950,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26976__$1 = state_26976;
var statearr_26980_27030 = state_26976__$1;
(statearr_26980_27030[(2)] = inst_26953);

(statearr_26980_27030[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (4))){
var inst_26881 = (state_26976[(2)]);
var inst_26882 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26881);
var state_26976__$1 = state_26976;
var statearr_26981_27031 = state_26976__$1;
(statearr_26981_27031[(2)] = inst_26882);

(statearr_26981_27031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (15))){
var inst_26932 = (state_26976[(11)]);
var state_26976__$1 = state_26976;
var statearr_26982_27032 = state_26976__$1;
(statearr_26982_27032[(2)] = inst_26932);

(statearr_26982_27032[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (21))){
var state_26976__$1 = state_26976;
var statearr_26983_27033 = state_26976__$1;
(statearr_26983_27033[(2)] = null);

(statearr_26983_27033[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (13))){
var inst_26968 = (state_26976[(2)]);
var inst_26969 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26968);
var state_26976__$1 = state_26976;
var statearr_26984_27034 = state_26976__$1;
(statearr_26984_27034[(2)] = inst_26969);

(statearr_26984_27034[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (22))){
var inst_26964 = (state_26976[(2)]);
var state_26976__$1 = state_26976;
var statearr_26985_27035 = state_26976__$1;
(statearr_26985_27035[(2)] = inst_26964);

(statearr_26985_27035[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (6))){
var inst_26892 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26893 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26894 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26892)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26893)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26895 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26896 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26897 = cljs.core.PersistentHashMap.fromArrays(inst_26895,inst_26896);
var inst_26898 = cljs.core.ex_info.call(null,inst_26894,inst_26897);
var inst_26899 = (function(){throw inst_26898})();
var state_26976__$1 = state_26976;
var statearr_26988_27036 = state_26976__$1;
(statearr_26988_27036[(2)] = inst_26899);

(statearr_26988_27036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (25))){
var inst_26933 = (state_26976[(12)]);
var inst_26932 = (state_26976[(11)]);
var inst_26950 = (state_26976[(10)]);
var inst_26955 = inst_26932.t;
var inst_26956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26957 = [inst_26932];
var inst_26958 = (new cljs.core.PersistentVector(null,1,(5),inst_26956,inst_26957,null));
var inst_26923 = inst_26933;
var inst_26924 = inst_26955;
var inst_26925 = inst_26958;
var inst_26926 = inst_26950;
var state_26976__$1 = (function (){var statearr_26989 = state_26976;
(statearr_26989[(7)] = inst_26925);

(statearr_26989[(8)] = inst_26926);

(statearr_26989[(9)] = inst_26924);

(statearr_26989[(13)] = inst_26923);

return statearr_26989;
})();
var statearr_26990_27037 = state_26976__$1;
(statearr_26990_27037[(2)] = null);

(statearr_26990_27037[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (17))){
var inst_26925 = (state_26976[(7)]);
var inst_26926 = (state_26976[(8)]);
var inst_26933 = (state_26976[(12)]);
var inst_26924 = (state_26976[(9)]);
var inst_26932 = (state_26976[(11)]);
var inst_26941 = cljs.core.conj.call(null,inst_26925,inst_26932);
var tmp26986 = inst_26926;
var tmp26987 = inst_26924;
var inst_26923 = inst_26933;
var inst_26924__$1 = tmp26987;
var inst_26925__$1 = inst_26941;
var inst_26926__$1 = tmp26986;
var state_26976__$1 = (function (){var statearr_26991 = state_26976;
(statearr_26991[(7)] = inst_26925__$1);

(statearr_26991[(8)] = inst_26926__$1);

(statearr_26991[(9)] = inst_26924__$1);

(statearr_26991[(13)] = inst_26923);

return statearr_26991;
})();
var statearr_26992_27038 = state_26976__$1;
(statearr_26992_27038[(2)] = null);

(statearr_26992_27038[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (3))){
var inst_26974 = (state_26976[(2)]);
var state_26976__$1 = state_26976;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26976__$1,inst_26974);
} else {
if((state_val_26977 === (12))){
var inst_26923 = (state_26976[(13)]);
var inst_26932 = (state_26976[(11)]);
var inst_26931 = cljs.core.seq.call(null,inst_26923);
var inst_26932__$1 = cljs.core.first.call(null,inst_26931);
var inst_26933 = cljs.core.next.call(null,inst_26931);
var state_26976__$1 = (function (){var statearr_26993 = state_26976;
(statearr_26993[(12)] = inst_26933);

(statearr_26993[(11)] = inst_26932__$1);

return statearr_26993;
})();
if(cljs.core.truth_(inst_26932__$1)){
var statearr_26994_27039 = state_26976__$1;
(statearr_26994_27039[(1)] = (14));

} else {
var statearr_26995_27040 = state_26976__$1;
(statearr_26995_27040[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (2))){
var _ = (function (){var statearr_26996 = state_26976;
(statearr_26996[(4)] = cljs.core.cons.call(null,(5),(state_26976[(4)])));

return statearr_26996;
})();
var inst_26888 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26889 = (inst_26888 + (1));
var inst_26890 = cljs.core.not_EQ_.call(null,block,inst_26889);
var state_26976__$1 = state_26976;
if(inst_26890){
var statearr_26997_27041 = state_26976__$1;
(statearr_26997_27041[(1)] = (6));

} else {
var statearr_26998_27042 = state_26976__$1;
(statearr_26998_27042[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (23))){
var inst_26932 = (state_26976[(11)]);
var inst_26949 = (state_26976[(2)]);
var inst_26950 = fluree.db.util.async.throw_err.call(null,inst_26949);
var inst_26951 = (inst_26932 == null);
var state_26976__$1 = (function (){var statearr_26999 = state_26976;
(statearr_26999[(10)] = inst_26950);

return statearr_26999;
})();
if(cljs.core.truth_(inst_26951)){
var statearr_27000_27043 = state_26976__$1;
(statearr_27000_27043[(1)] = (24));

} else {
var statearr_27001_27044 = state_26976__$1;
(statearr_27001_27044[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (19))){
var inst_26966 = (state_26976[(2)]);
var state_26976__$1 = state_26976;
var statearr_27002_27045 = state_26976__$1;
(statearr_27002_27045[(2)] = inst_26966);

(statearr_27002_27045[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (11))){
var inst_26971 = (state_26976[(2)]);
var _ = (function (){var statearr_27004 = state_26976;
(statearr_27004[(4)] = cljs.core.rest.call(null,(state_26976[(4)])));

return statearr_27004;
})();
var state_26976__$1 = state_26976;
var statearr_27005_27046 = state_26976__$1;
(statearr_27005_27046[(2)] = inst_26971);

(statearr_27005_27046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (9))){
var inst_26905 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26906 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26905);
var state_26976__$1 = state_26976;
var statearr_27006_27047 = state_26976__$1;
(statearr_27006_27047[(2)] = inst_26906);

(statearr_27006_27047[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (5))){
var _ = (function (){var statearr_27007 = state_26976;
(statearr_27007[(4)] = cljs.core.rest.call(null,(state_26976[(4)])));

return statearr_27007;
})();
var state_26976__$1 = state_26976;
var ex27003 = (state_26976__$1[(2)]);
var statearr_27008_27048 = state_26976__$1;
(statearr_27008_27048[(5)] = ex27003);


var statearr_27009_27049 = state_26976__$1;
(statearr_27009_27049[(1)] = (4));

(statearr_27009_27049[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (14))){
var inst_26924 = (state_26976[(9)]);
var inst_26932 = (state_26976[(11)]);
var inst_26935 = inst_26932.t;
var inst_26936 = cljs.core._EQ_.call(null,inst_26924,inst_26935);
var state_26976__$1 = state_26976;
var statearr_27010_27050 = state_26976__$1;
(statearr_27010_27050[(2)] = inst_26936);

(statearr_27010_27050[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (26))){
var inst_26961 = (state_26976[(2)]);
var state_26976__$1 = state_26976;
var statearr_27011_27051 = state_26976__$1;
(statearr_27011_27051[(2)] = inst_26961);

(statearr_27011_27051[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (16))){
var inst_26939 = (state_26976[(2)]);
var state_26976__$1 = state_26976;
if(cljs.core.truth_(inst_26939)){
var statearr_27012_27052 = state_26976__$1;
(statearr_27012_27052[(1)] = (17));

} else {
var statearr_27013_27053 = state_26976__$1;
(statearr_27013_27053[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (10))){
var inst_26908 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_26909 = cljs.core.first.call(null,inst_26908);
var inst_26917 = cljs.core.seq.call(null,inst_26908);
var inst_26918 = cljs.core.first.call(null,inst_26917);
var inst_26919 = cljs.core.next.call(null,inst_26917);
var inst_26920 = inst_26909.t;
var inst_26921 = cljs.core.PersistentVector.EMPTY;
var inst_26922 = db;
var inst_26923 = inst_26908;
var inst_26924 = inst_26920;
var inst_26925 = inst_26921;
var inst_26926 = inst_26922;
var state_26976__$1 = (function (){var statearr_27014 = state_26976;
(statearr_27014[(7)] = inst_26925);

(statearr_27014[(8)] = inst_26926);

(statearr_27014[(14)] = inst_26919);

(statearr_27014[(9)] = inst_26924);

(statearr_27014[(15)] = inst_26918);

(statearr_27014[(13)] = inst_26923);

return statearr_27014;
})();
var statearr_27015_27054 = state_26976__$1;
(statearr_27015_27054[(2)] = null);

(statearr_27015_27054[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (18))){
var state_26976__$1 = state_26976;
var statearr_27016_27055 = state_26976__$1;
(statearr_27016_27055[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (8))){
var inst_26902 = (state_26976[(2)]);
var inst_26903 = cljs.core.empty_QMARK_.call(null,flakes);
var state_26976__$1 = (function (){var statearr_27018 = state_26976;
(statearr_27018[(16)] = inst_26902);

return statearr_27018;
})();
if(inst_26903){
var statearr_27019_27056 = state_26976__$1;
(statearr_27019_27056[(1)] = (9));

} else {
var statearr_27020_27057 = state_26976__$1;
(statearr_27020_27057[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2741__auto__ = null;
var fluree$db$graphdb$state_machine__2741__auto____0 = (function (){
var statearr_27021 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27021[(0)] = fluree$db$graphdb$state_machine__2741__auto__);

(statearr_27021[(1)] = (1));

return statearr_27021;
});
var fluree$db$graphdb$state_machine__2741__auto____1 = (function (state_26976){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_26976);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27022){var ex__2744__auto__ = e27022;
var statearr_27023_27058 = state_26976;
(statearr_27023_27058[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_26976[(4)]))){
var statearr_27024_27059 = state_26976;
(statearr_27024_27059[(1)] = cljs.core.first.call(null,(state_26976[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27060 = state_26976;
state_26976 = G__27060;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2741__auto__ = function(state_26976){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2741__auto____1.call(this,state_26976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2741__auto____0;
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2741__auto____1;
return fluree$db$graphdb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27025 = f__2764__auto__.call(null);
(statearr_27025[(6)] = c__2763__auto___27027);

return statearr_27025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27116){
var state_val_27117 = (state_27116[(1)]);
if((state_val_27117 === (7))){
var state_27116__$1 = state_27116;
var statearr_27118_27145 = state_27116__$1;
(statearr_27118_27145[(2)] = tt_id);

(statearr_27118_27145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27117 === (1))){
var state_27116__$1 = state_27116;
var statearr_27119_27146 = state_27116__$1;
(statearr_27119_27146[(2)] = null);

(statearr_27119_27146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27117 === (4))){
var inst_27061 = (state_27116[(2)]);
var state_27116__$1 = state_27116;
var statearr_27120_27147 = state_27116__$1;
(statearr_27120_27147[(2)] = inst_27061);

(statearr_27120_27147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27117 === (13))){
var inst_27109 = (state_27116[(2)]);
var state_27116__$1 = state_27116;
var statearr_27121_27148 = state_27116__$1;
(statearr_27121_27148[(2)] = inst_27109);

(statearr_27121_27148[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27117 === (6))){
var inst_27069 = fluree.db.util.core.random_uuid.call(null);
var state_27116__$1 = state_27116;
var statearr_27122_27149 = state_27116__$1;
(statearr_27122_27149[(2)] = inst_27069);

(statearr_27122_27149[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27117 === (3))){
var inst_27114 = (state_27116[(2)]);
var state_27116__$1 = state_27116;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27116__$1,inst_27114);
} else {
if((state_val_27117 === (12))){
var inst_27092 = (state_27116[(7)]);
var state_27116__$1 = state_27116;
var statearr_27123_27150 = state_27116__$1;
(statearr_27123_27150[(2)] = inst_27092);

(statearr_27123_27150[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27117 === (2))){
var _ = (function (){var statearr_27124 = state_27116;
(statearr_27124[(4)] = cljs.core.cons.call(null,(5),(state_27116[(4)])));

return statearr_27124;
})();
var inst_27067 = (tt_id == null);
var state_27116__$1 = state_27116;
if(cljs.core.truth_(inst_27067)){
var statearr_27125_27151 = state_27116__$1;
(statearr_27125_27151[(1)] = (6));

} else {
var statearr_27126_27152 = state_27116__$1;
(statearr_27126_27152[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27117 === (11))){
var inst_27092 = (state_27116[(7)]);
var inst_27099 = (state_27116[(8)]);
var inst_27102 = fluree.db.graphdb.with_t.call(null,inst_27092,inst_27099);
var state_27116__$1 = state_27116;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27116__$1,(14),inst_27102);
} else {
if((state_val_27117 === (9))){
var inst_27099 = (state_27116[(8)]);
var inst_27093 = (state_27116[(9)]);
var inst_27098 = cljs.core.seq.call(null,inst_27093);
var inst_27099__$1 = cljs.core.first.call(null,inst_27098);
var inst_27100 = cljs.core.next.call(null,inst_27098);
var state_27116__$1 = (function (){var statearr_27128 = state_27116;
(statearr_27128[(8)] = inst_27099__$1);

(statearr_27128[(10)] = inst_27100);

return statearr_27128;
})();
if(cljs.core.truth_(inst_27099__$1)){
var statearr_27129_27153 = state_27116__$1;
(statearr_27129_27153[(1)] = (11));

} else {
var statearr_27130_27154 = state_27116__$1;
(statearr_27130_27154[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27117 === (5))){
var _ = (function (){var statearr_27131 = state_27116;
(statearr_27131[(4)] = cljs.core.rest.call(null,(state_27116[(4)])));

return statearr_27131;
})();
var state_27116__$1 = state_27116;
var ex27127 = (state_27116__$1[(2)]);
var statearr_27132_27155 = state_27116__$1;
(statearr_27132_27155[(5)] = ex27127);


if((ex27127 instanceof Error)){
var statearr_27133_27156 = state_27116__$1;
(statearr_27133_27156[(1)] = (4));

(statearr_27133_27156[(5)] = null);

} else {
throw ex27127;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27117 === (14))){
var inst_27100 = (state_27116[(10)]);
var inst_27104 = (state_27116[(2)]);
var inst_27105 = fluree.db.util.async.throw_err.call(null,inst_27104);
var inst_27092 = inst_27105;
var inst_27093 = inst_27100;
var state_27116__$1 = (function (){var statearr_27134 = state_27116;
(statearr_27134[(7)] = inst_27092);

(statearr_27134[(9)] = inst_27093);

return statearr_27134;
})();
var statearr_27135_27157 = state_27116__$1;
(statearr_27135_27157[(2)] = null);

(statearr_27135_27157[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27117 === (10))){
var inst_27111 = (state_27116[(2)]);
var _ = (function (){var statearr_27136 = state_27116;
(statearr_27136[(4)] = cljs.core.rest.call(null,(state_27116[(4)])));

return statearr_27136;
})();
var state_27116__$1 = state_27116;
var statearr_27137_27158 = state_27116__$1;
(statearr_27137_27158[(2)] = inst_27111);

(statearr_27137_27158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27117 === (8))){
var inst_27072 = (state_27116[(2)]);
var inst_27073 = (function (){var tt_id_SINGLEQUOTE_ = inst_27072;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_27074 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_27072);
var inst_27075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27076 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27077 = (new cljs.core.PersistentVector(null,4,(5),inst_27075,inst_27076,null));
var inst_27078 = cljs.core.reduce.call(null,inst_27073,inst_27074,inst_27077);
var inst_27079 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_27080 = cljs.core.reverse.call(null,inst_27079);
var inst_27081 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27080);
var inst_27089 = cljs.core.seq.call(null,inst_27081);
var inst_27090 = cljs.core.first.call(null,inst_27089);
var inst_27091 = cljs.core.next.call(null,inst_27089);
var inst_27092 = inst_27078;
var inst_27093 = inst_27081;
var state_27116__$1 = (function (){var statearr_27138 = state_27116;
(statearr_27138[(7)] = inst_27092);

(statearr_27138[(11)] = inst_27090);

(statearr_27138[(12)] = inst_27091);

(statearr_27138[(9)] = inst_27093);

return statearr_27138;
})();
var statearr_27139_27159 = state_27116__$1;
(statearr_27139_27159[(2)] = null);

(statearr_27139_27159[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto____0 = (function (){
var statearr_27140 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27140[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto__);

(statearr_27140[(1)] = (1));

return statearr_27140;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto____1 = (function (state_27116){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_27116);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27141){var ex__2744__auto__ = e27141;
var statearr_27142_27160 = state_27116;
(statearr_27142_27160[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_27116[(4)]))){
var statearr_27143_27161 = state_27116;
(statearr_27143_27161[(1)] = cljs.core.first.call(null,(state_27116[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27162 = state_27116;
state_27116 = G__27162;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto__ = function(state_27116){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto____1.call(this,state_27116);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27144 = f__2764__auto__.call(null);
(statearr_27144[(6)] = c__2763__auto__);

return statearr_27144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2763__auto___27349 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27280){
var state_val_27281 = (state_27280[(1)]);
if((state_val_27281 === (7))){
var inst_27190 = (state_27280[(7)]);
var inst_27190__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_27280__$1 = (function (){var statearr_27282 = state_27280;
(statearr_27282[(7)] = inst_27190__$1);

return statearr_27282;
})();
if(inst_27190__$1){
var statearr_27283_27350 = state_27280__$1;
(statearr_27283_27350[(1)] = (13));

} else {
var statearr_27284_27351 = state_27280__$1;
(statearr_27284_27351[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (20))){
var state_27280__$1 = state_27280;
var statearr_27285_27352 = state_27280__$1;
(statearr_27285_27352[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (27))){
var inst_27226 = (state_27280[(8)]);
var inst_27230 = inst_27226.s;
var state_27280__$1 = state_27280;
var statearr_27287_27353 = state_27280__$1;
(statearr_27287_27353[(2)] = inst_27230);

(statearr_27287_27353[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (1))){
var state_27280__$1 = state_27280;
var statearr_27288_27354 = state_27280__$1;
(statearr_27288_27354[(2)] = null);

(statearr_27288_27354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (24))){
var inst_27220 = (state_27280[(9)]);
var inst_27224 = cljs.core.first.call(null,inst_27220);
var state_27280__$1 = state_27280;
var statearr_27289_27355 = state_27280__$1;
(statearr_27289_27355[(2)] = inst_27224);

(statearr_27289_27355[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (39))){
var state_27280__$1 = state_27280;
var statearr_27290_27356 = state_27280__$1;
(statearr_27290_27356[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (4))){
var inst_27163 = (state_27280[(2)]);
var inst_27164 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27165 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27166 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27167 = cljs.core.PersistentHashMap.fromArrays(inst_27165,inst_27166);
var inst_27168 = cljs.core.ex_info.call(null,inst_27164,inst_27167,inst_27163);
var inst_27169 = cljs.core.async.put_BANG_.call(null,return_chan,inst_27168);
var state_27280__$1 = state_27280;
var statearr_27292_27357 = state_27280__$1;
(statearr_27292_27357[(2)] = inst_27169);

(statearr_27292_27357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (15))){
var inst_27197 = (state_27280[(2)]);
var state_27280__$1 = state_27280;
if(cljs.core.truth_(inst_27197)){
var statearr_27293_27358 = state_27280__$1;
(statearr_27293_27358[(1)] = (16));

} else {
var statearr_27294_27359 = state_27280__$1;
(statearr_27294_27359[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (21))){
var inst_27246 = (state_27280[(2)]);
var state_27280__$1 = state_27280;
var statearr_27295_27360 = state_27280__$1;
(statearr_27295_27360[(2)] = inst_27246);

(statearr_27295_27360[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (31))){
var inst_27244 = (state_27280[(2)]);
var state_27280__$1 = state_27280;
var statearr_27296_27361 = state_27280__$1;
(statearr_27296_27361[(2)] = inst_27244);

(statearr_27296_27361[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (32))){
var inst_27250 = (state_27280[(10)]);
var inst_27252 = cljs.core.async.put_BANG_.call(null,return_chan,inst_27250);
var state_27280__$1 = state_27280;
var statearr_27297_27362 = state_27280__$1;
(statearr_27297_27362[(2)] = inst_27252);

(statearr_27297_27362[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (40))){
var inst_27273 = (state_27280[(2)]);
var state_27280__$1 = state_27280;
var statearr_27298_27363 = state_27280__$1;
(statearr_27298_27363[(2)] = inst_27273);

(statearr_27298_27363[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (33))){
var inst_27254 = (state_27280[(11)]);
var inst_27250 = (state_27280[(10)]);
var inst_27254__$1 = (inst_27250 == null);
var state_27280__$1 = (function (){var statearr_27299 = state_27280;
(statearr_27299[(11)] = inst_27254__$1);

return statearr_27299;
})();
if(cljs.core.truth_(inst_27254__$1)){
var statearr_27300_27364 = state_27280__$1;
(statearr_27300_27364[(1)] = (35));

} else {
var statearr_27301_27365 = state_27280__$1;
(statearr_27301_27365[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (13))){
var inst_27192 = cljs.core.first.call(null,ident);
var inst_27193 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27192);
var inst_27194 = (inst_27193 == null);
var state_27280__$1 = state_27280;
var statearr_27302_27366 = state_27280__$1;
(statearr_27302_27366[(2)] = inst_27194);

(statearr_27302_27366[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (22))){
var inst_27220 = (state_27280[(9)]);
var inst_27219 = (state_27280[(2)]);
var inst_27220__$1 = fluree.db.util.async.throw_err.call(null,inst_27219);
var inst_27221 = (inst_27220__$1 == null);
var state_27280__$1 = (function (){var statearr_27303 = state_27280;
(statearr_27303[(9)] = inst_27220__$1);

return statearr_27303;
})();
if(cljs.core.truth_(inst_27221)){
var statearr_27304_27367 = state_27280__$1;
(statearr_27304_27367[(1)] = (23));

} else {
var statearr_27305_27368 = state_27280__$1;
(statearr_27305_27368[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (36))){
var inst_27254 = (state_27280[(11)]);
var state_27280__$1 = state_27280;
var statearr_27306_27369 = state_27280__$1;
(statearr_27306_27369[(2)] = inst_27254);

(statearr_27306_27369[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (41))){
var inst_27268 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_27280__$1 = state_27280;
var statearr_27307_27370 = state_27280__$1;
(statearr_27307_27370[(2)] = inst_27268);

(statearr_27307_27370[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (43))){
var inst_27271 = (state_27280[(2)]);
var state_27280__$1 = state_27280;
var statearr_27308_27371 = state_27280__$1;
(statearr_27308_27371[(2)] = inst_27271);

(statearr_27308_27371[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (29))){
var inst_27235 = cljs.core.pr_str.call(null,ident);
var inst_27236 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_27235].join('');
var inst_27237 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27238 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27239 = cljs.core.PersistentHashMap.fromArrays(inst_27237,inst_27238);
var inst_27240 = cljs.core.ex_info.call(null,inst_27236,inst_27239);
var inst_27241 = (function(){throw inst_27240})();
var state_27280__$1 = state_27280;
var statearr_27309_27372 = state_27280__$1;
(statearr_27309_27372[(2)] = inst_27241);

(statearr_27309_27372[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (6))){
var inst_27177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27178 = [ident];
var inst_27179 = (new cljs.core.PersistentVector(null,1,(5),inst_27177,inst_27178,null));
var inst_27180 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27179);
var state_27280__$1 = state_27280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27280__$1,(9),inst_27180);
} else {
if((state_val_27281 === (28))){
var inst_27232 = (state_27280[(2)]);
var state_27280__$1 = state_27280;
var statearr_27310_27373 = state_27280__$1;
(statearr_27310_27373[(2)] = inst_27232);

(statearr_27310_27373[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (25))){
var inst_27226 = (state_27280[(8)]);
var inst_27226__$1 = (state_27280[(2)]);
var inst_27227 = (inst_27226__$1 == null);
var state_27280__$1 = (function (){var statearr_27311 = state_27280;
(statearr_27311[(8)] = inst_27226__$1);

return statearr_27311;
})();
if(cljs.core.truth_(inst_27227)){
var statearr_27312_27374 = state_27280__$1;
(statearr_27312_27374[(1)] = (26));

} else {
var statearr_27313_27375 = state_27280__$1;
(statearr_27313_27375[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (34))){
var inst_27275 = (state_27280[(2)]);
var _ = (function (){var statearr_27314 = state_27280;
(statearr_27314[(4)] = cljs.core.rest.call(null,(state_27280[(4)])));

return statearr_27314;
})();
var state_27280__$1 = state_27280;
var statearr_27315_27376 = state_27280__$1;
(statearr_27315_27376[(2)] = inst_27275);

(statearr_27315_27376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (17))){
var inst_27208 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_27280__$1 = state_27280;
if(inst_27208){
var statearr_27316_27377 = state_27280__$1;
(statearr_27316_27377[(1)] = (19));

} else {
var statearr_27317_27378 = state_27280__$1;
(statearr_27317_27378[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (3))){
var inst_27278 = (state_27280[(2)]);
var state_27280__$1 = state_27280;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27280__$1,inst_27278);
} else {
if((state_val_27281 === (12))){
var inst_27188 = (state_27280[(2)]);
var state_27280__$1 = state_27280;
var statearr_27318_27379 = state_27280__$1;
(statearr_27318_27379[(2)] = inst_27188);

(statearr_27318_27379[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (2))){
var _ = (function (){var statearr_27319 = state_27280;
(statearr_27319[(4)] = cljs.core.cons.call(null,(5),(state_27280[(4)])));

return statearr_27319;
})();
var inst_27175 = typeof ident === 'number';
var state_27280__$1 = state_27280;
if(cljs.core.truth_(inst_27175)){
var statearr_27320_27380 = state_27280__$1;
(statearr_27320_27380[(1)] = (6));

} else {
var statearr_27321_27381 = state_27280__$1;
(statearr_27321_27381[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (23))){
var state_27280__$1 = state_27280;
var statearr_27322_27382 = state_27280__$1;
(statearr_27322_27382[(2)] = null);

(statearr_27322_27382[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (35))){
var state_27280__$1 = state_27280;
var statearr_27323_27383 = state_27280__$1;
(statearr_27323_27383[(2)] = strict_QMARK_);

(statearr_27323_27383[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (19))){
var inst_27211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27212 = cljs.core.first.call(null,ident);
var inst_27213 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27212);
var inst_27214 = cljs.core.second.call(null,ident);
var inst_27215 = [inst_27213,inst_27214];
var inst_27216 = (new cljs.core.PersistentVector(null,2,(5),inst_27211,inst_27215,null));
var inst_27217 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27216);
var state_27280__$1 = state_27280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27280__$1,(22),inst_27217);
} else {
if((state_val_27281 === (11))){
var state_27280__$1 = state_27280;
var statearr_27325_27384 = state_27280__$1;
(statearr_27325_27384[(2)] = null);

(statearr_27325_27384[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (9))){
var inst_27182 = (state_27280[(2)]);
var inst_27183 = fluree.db.util.async.throw_err.call(null,inst_27182);
var inst_27184 = cljs.core.not_empty.call(null,inst_27183);
var state_27280__$1 = state_27280;
if(cljs.core.truth_(inst_27184)){
var statearr_27326_27385 = state_27280__$1;
(statearr_27326_27385[(1)] = (10));

} else {
var statearr_27327_27386 = state_27280__$1;
(statearr_27327_27386[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (5))){
var _ = (function (){var statearr_27328 = state_27280;
(statearr_27328[(4)] = cljs.core.rest.call(null,(state_27280[(4)])));

return statearr_27328;
})();
var state_27280__$1 = state_27280;
var ex27324 = (state_27280__$1[(2)]);
var statearr_27329_27387 = state_27280__$1;
(statearr_27329_27387[(5)] = ex27324);


var statearr_27330_27388 = state_27280__$1;
(statearr_27330_27388[(1)] = (4));

(statearr_27330_27388[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (14))){
var inst_27190 = (state_27280[(7)]);
var state_27280__$1 = state_27280;
var statearr_27331_27389 = state_27280__$1;
(statearr_27331_27389[(2)] = inst_27190);

(statearr_27331_27389[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (26))){
var state_27280__$1 = state_27280;
var statearr_27332_27390 = state_27280__$1;
(statearr_27332_27390[(2)] = null);

(statearr_27332_27390[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (16))){
var inst_27199 = cljs.core.first.call(null,ident);
var inst_27200 = cljs.core.pr_str.call(null,inst_27199);
var inst_27201 = ["Subject ID lookup failed. The predicate ",inst_27200," does not exist."].join('');
var inst_27202 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27203 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27204 = cljs.core.PersistentHashMap.fromArrays(inst_27202,inst_27203);
var inst_27205 = cljs.core.ex_info.call(null,inst_27201,inst_27204);
var inst_27206 = (function(){throw inst_27205})();
var state_27280__$1 = state_27280;
var statearr_27333_27391 = state_27280__$1;
(statearr_27333_27391[(2)] = inst_27206);

(statearr_27333_27391[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (38))){
var inst_27260 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27261 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27262 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27263 = cljs.core.PersistentHashMap.fromArrays(inst_27261,inst_27262);
var inst_27264 = cljs.core.ex_info.call(null,inst_27260,inst_27263);
var inst_27265 = cljs.core.async.put_BANG_.call(null,return_chan,inst_27264);
var state_27280__$1 = state_27280;
var statearr_27334_27392 = state_27280__$1;
(statearr_27334_27392[(2)] = inst_27265);

(statearr_27334_27392[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (30))){
var state_27280__$1 = state_27280;
var statearr_27335_27393 = state_27280__$1;
(statearr_27335_27393[(2)] = null);

(statearr_27335_27393[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (10))){
var state_27280__$1 = state_27280;
var statearr_27336_27394 = state_27280__$1;
(statearr_27336_27394[(2)] = ident);

(statearr_27336_27394[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (18))){
var inst_27248 = (state_27280[(2)]);
var state_27280__$1 = state_27280;
var statearr_27337_27395 = state_27280__$1;
(statearr_27337_27395[(2)] = inst_27248);

(statearr_27337_27395[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (42))){
var state_27280__$1 = state_27280;
var statearr_27338_27396 = state_27280__$1;
(statearr_27338_27396[(2)] = null);

(statearr_27338_27396[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (37))){
var inst_27258 = (state_27280[(2)]);
var state_27280__$1 = state_27280;
if(cljs.core.truth_(inst_27258)){
var statearr_27339_27397 = state_27280__$1;
(statearr_27339_27397[(1)] = (38));

} else {
var statearr_27340_27398 = state_27280__$1;
(statearr_27340_27398[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27281 === (8))){
var inst_27250 = (state_27280[(10)]);
var inst_27250__$1 = (state_27280[(2)]);
var state_27280__$1 = (function (){var statearr_27341 = state_27280;
(statearr_27341[(10)] = inst_27250__$1);

return statearr_27341;
})();
if(cljs.core.truth_(inst_27250__$1)){
var statearr_27342_27399 = state_27280__$1;
(statearr_27342_27399[(1)] = (32));

} else {
var statearr_27343_27400 = state_27280__$1;
(statearr_27343_27400[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2741__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2741__auto____0 = (function (){
var statearr_27344 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27344[(0)] = fluree$db$graphdb$subid_$_state_machine__2741__auto__);

(statearr_27344[(1)] = (1));

return statearr_27344;
});
var fluree$db$graphdb$subid_$_state_machine__2741__auto____1 = (function (state_27280){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_27280);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27345){var ex__2744__auto__ = e27345;
var statearr_27346_27401 = state_27280;
(statearr_27346_27401[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_27280[(4)]))){
var statearr_27347_27402 = state_27280;
(statearr_27347_27402[(1)] = cljs.core.first.call(null,(state_27280[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27403 = state_27280;
state_27280 = G__27403;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2741__auto__ = function(state_27280){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2741__auto____1.call(this,state_27280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2741__auto____0;
fluree$db$graphdb$subid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2741__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27348 = f__2764__auto__.call(null);
(statearr_27348[(6)] = c__2763__auto___27349);

return statearr_27348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__27404){
var map__27405 = p__27404;
var map__27405__$1 = cljs.core.__destructure_map.call(null,map__27405);
var current_db_fn = cljs.core.get.call(null,map__27405__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__27405__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27421){
var state_val_27422 = (state_27421[(1)]);
if((state_val_27422 === (1))){
var state_27421__$1 = state_27421;
var statearr_27423_27437 = state_27421__$1;
(statearr_27423_27437[(2)] = null);

(statearr_27423_27437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27422 === (2))){
var _ = (function (){var statearr_27424 = state_27421;
(statearr_27424[(4)] = cljs.core.cons.call(null,(5),(state_27421[(4)])));

return statearr_27424;
})();
var inst_27412 = current_db_fn.call(null);
var state_27421__$1 = state_27421;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27421__$1,(6),inst_27412);
} else {
if((state_val_27422 === (3))){
var inst_27419 = (state_27421[(2)]);
var state_27421__$1 = state_27421;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27421__$1,inst_27419);
} else {
if((state_val_27422 === (4))){
var inst_27406 = (state_27421[(2)]);
var state_27421__$1 = state_27421;
var statearr_27426_27438 = state_27421__$1;
(statearr_27426_27438[(2)] = inst_27406);

(statearr_27426_27438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27422 === (5))){
var _ = (function (){var statearr_27427 = state_27421;
(statearr_27427[(4)] = cljs.core.rest.call(null,(state_27421[(4)])));

return statearr_27427;
})();
var state_27421__$1 = state_27421;
var ex27425 = (state_27421__$1[(2)]);
var statearr_27428_27439 = state_27421__$1;
(statearr_27428_27439[(5)] = ex27425);


if((ex27425 instanceof Error)){
var statearr_27429_27440 = state_27421__$1;
(statearr_27429_27440[(1)] = (4));

(statearr_27429_27440[(5)] = null);

} else {
throw ex27425;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27422 === (6))){
var inst_27414 = (state_27421[(2)]);
var inst_27415 = fluree.db.util.async.throw_err.call(null,inst_27414);
var inst_27416 = cljs.core.assoc.call(null,inst_27415,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_27430 = state_27421;
(statearr_27430[(4)] = cljs.core.rest.call(null,(state_27421[(4)])));

return statearr_27430;
})();
var state_27421__$1 = state_27421;
var statearr_27431_27441 = state_27421__$1;
(statearr_27431_27441[(2)] = inst_27416);

(statearr_27431_27441[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto____0 = (function (){
var statearr_27432 = [null,null,null,null,null,null,null];
(statearr_27432[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto__);

(statearr_27432[(1)] = (1));

return statearr_27432;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto____1 = (function (state_27421){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_27421);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27433){var ex__2744__auto__ = e27433;
var statearr_27434_27442 = state_27421;
(statearr_27434_27442[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_27421[(4)]))){
var statearr_27435_27443 = state_27421;
(statearr_27435_27443[(1)] = cljs.core.first.call(null,(state_27421[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27444 = state_27421;
state_27421 = G__27444;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto__ = function(state_27421){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto____1.call(this,state_27421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27436 = f__2764__auto__.call(null);
(statearr_27436[(6)] = c__2763__auto__);

return statearr_27436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__27445,property,collection){
var map__27446 = p__27445;
var map__27446__$1 = cljs.core.__destructure_map.call(null,map__27446);
var schema = cljs.core.get.call(null,map__27446__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__27447,property,predicate){
var map__27448 = p__27447;
var map__27448__$1 = cljs.core.__destructure_map.call(null,map__27448);
var this$ = map__27448__$1;
var schema = cljs.core.get.call(null,map__27448__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__27449 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__27449);
} else {
return G__27449;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__27451 = arguments.length;
switch (G__27451) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27483){
var state_val_27484 = (state_27483[(1)]);
if((state_val_27484 === (7))){
var state_27483__$1 = state_27483;
var statearr_27485_27579 = state_27483__$1;
(statearr_27485_27579[(2)] = null);

(statearr_27485_27579[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27484 === (1))){
var state_27483__$1 = state_27483;
var statearr_27486_27580 = state_27483__$1;
(statearr_27486_27580[(2)] = null);

(statearr_27486_27580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27484 === (4))){
var inst_27452 = (state_27483[(2)]);
var state_27483__$1 = state_27483;
var statearr_27487_27581 = state_27483__$1;
(statearr_27487_27581[(2)] = inst_27452);

(statearr_27487_27581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27484 === (6))){
var inst_27466 = (state_27483[(7)]);
var inst_27465 = (state_27483[(2)]);
var inst_27466__$1 = fluree.db.util.async.throw_err.call(null,inst_27465);
var inst_27467 = (inst_27466__$1 == null);
var state_27483__$1 = (function (){var statearr_27488 = state_27483;
(statearr_27488[(7)] = inst_27466__$1);

return statearr_27488;
})();
if(cljs.core.truth_(inst_27467)){
var statearr_27489_27582 = state_27483__$1;
(statearr_27489_27582[(1)] = (7));

} else {
var statearr_27490_27583 = state_27483__$1;
(statearr_27490_27583[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27484 === (3))){
var inst_27481 = (state_27483[(2)]);
var state_27483__$1 = state_27483;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27483__$1,inst_27481);
} else {
if((state_val_27484 === (12))){
var inst_27478 = (state_27483[(2)]);
var _ = (function (){var statearr_27491 = state_27483;
(statearr_27491[(4)] = cljs.core.rest.call(null,(state_27483[(4)])));

return statearr_27491;
})();
var state_27483__$1 = state_27483;
var statearr_27492_27584 = state_27483__$1;
(statearr_27492_27584[(2)] = inst_27478);

(statearr_27492_27584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27484 === (2))){
var _ = (function (){var statearr_27493 = state_27483;
(statearr_27493[(4)] = cljs.core.cons.call(null,(5),(state_27483[(4)])));

return statearr_27493;
})();
var inst_27459 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_27460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27461 = [tag_id,(30)];
var inst_27462 = (new cljs.core.PersistentVector(null,2,(5),inst_27460,inst_27461,null));
var inst_27463 = fluree.db.query.range.index_range.call(null,inst_27459,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27462);
var state_27483__$1 = state_27483;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27483__$1,(6),inst_27463);
} else {
if((state_val_27484 === (11))){
var inst_27472 = (state_27483[(8)]);
var inst_27476 = inst_27472.o;
var state_27483__$1 = state_27483;
var statearr_27495_27585 = state_27483__$1;
(statearr_27495_27585[(2)] = inst_27476);

(statearr_27495_27585[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27484 === (9))){
var inst_27472 = (state_27483[(8)]);
var inst_27472__$1 = (state_27483[(2)]);
var inst_27473 = (inst_27472__$1 == null);
var state_27483__$1 = (function (){var statearr_27496 = state_27483;
(statearr_27496[(8)] = inst_27472__$1);

return statearr_27496;
})();
if(cljs.core.truth_(inst_27473)){
var statearr_27497_27586 = state_27483__$1;
(statearr_27497_27586[(1)] = (10));

} else {
var statearr_27498_27587 = state_27483__$1;
(statearr_27498_27587[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27484 === (5))){
var _ = (function (){var statearr_27499 = state_27483;
(statearr_27499[(4)] = cljs.core.rest.call(null,(state_27483[(4)])));

return statearr_27499;
})();
var state_27483__$1 = state_27483;
var ex27494 = (state_27483__$1[(2)]);
var statearr_27500_27588 = state_27483__$1;
(statearr_27500_27588[(5)] = ex27494);


if((ex27494 instanceof Error)){
var statearr_27501_27589 = state_27483__$1;
(statearr_27501_27589[(1)] = (4));

(statearr_27501_27589[(5)] = null);

} else {
throw ex27494;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27484 === (10))){
var state_27483__$1 = state_27483;
var statearr_27502_27590 = state_27483__$1;
(statearr_27502_27590[(2)] = null);

(statearr_27502_27590[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27484 === (8))){
var inst_27466 = (state_27483[(7)]);
var inst_27470 = cljs.core.first.call(null,inst_27466);
var state_27483__$1 = state_27483;
var statearr_27503_27591 = state_27483__$1;
(statearr_27503_27591[(2)] = inst_27470);

(statearr_27503_27591[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2741__auto__ = null;
var fluree$db$graphdb$state_machine__2741__auto____0 = (function (){
var statearr_27504 = [null,null,null,null,null,null,null,null,null];
(statearr_27504[(0)] = fluree$db$graphdb$state_machine__2741__auto__);

(statearr_27504[(1)] = (1));

return statearr_27504;
});
var fluree$db$graphdb$state_machine__2741__auto____1 = (function (state_27483){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_27483);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27505){var ex__2744__auto__ = e27505;
var statearr_27506_27592 = state_27483;
(statearr_27506_27592[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_27483[(4)]))){
var statearr_27507_27593 = state_27483;
(statearr_27507_27593[(1)] = cljs.core.first.call(null,(state_27483[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27594 = state_27483;
state_27483 = G__27594;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2741__auto__ = function(state_27483){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2741__auto____1.call(this,state_27483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2741__auto____0;
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2741__auto____1;
return fluree$db$graphdb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27508 = f__2764__auto__.call(null);
(statearr_27508[(6)] = c__2763__auto__);

return statearr_27508;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27544){
var state_val_27545 = (state_27544[(1)]);
if((state_val_27545 === (7))){
var inst_27518 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27544__$1 = state_27544;
var statearr_27546_27595 = state_27544__$1;
(statearr_27546_27595[(2)] = inst_27518);

(statearr_27546_27595[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (1))){
var state_27544__$1 = state_27544;
var statearr_27547_27596 = state_27544__$1;
(statearr_27547_27596[(2)] = null);

(statearr_27547_27596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (4))){
var inst_27509 = (state_27544[(2)]);
var state_27544__$1 = state_27544;
var statearr_27548_27597 = state_27544__$1;
(statearr_27548_27597[(2)] = inst_27509);

(statearr_27548_27597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (15))){
var inst_27539 = (state_27544[(2)]);
var _ = (function (){var statearr_27549 = state_27544;
(statearr_27549[(4)] = cljs.core.rest.call(null,(state_27544[(4)])));

return statearr_27549;
})();
var state_27544__$1 = state_27544;
var statearr_27550_27598 = state_27544__$1;
(statearr_27550_27598[(2)] = inst_27539);

(statearr_27550_27598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (13))){
var inst_27524 = (state_27544[(7)]);
var inst_27530 = clojure.string.includes_QMARK_.call(null,inst_27524,":");
var state_27544__$1 = state_27544;
if(inst_27530){
var statearr_27551_27599 = state_27544__$1;
(statearr_27551_27599[(1)] = (16));

} else {
var statearr_27552_27600 = state_27544__$1;
(statearr_27552_27600[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (6))){
var state_27544__$1 = state_27544;
var statearr_27553_27601 = state_27544__$1;
(statearr_27553_27601[(2)] = pred);

(statearr_27553_27601[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (17))){
var inst_27524 = (state_27544[(7)]);
var state_27544__$1 = state_27544;
var statearr_27554_27602 = state_27544__$1;
(statearr_27554_27602[(2)] = inst_27524);

(statearr_27554_27602[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (3))){
var inst_27542 = (state_27544[(2)]);
var state_27544__$1 = state_27544;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27544__$1,inst_27542);
} else {
if((state_val_27545 === (12))){
var inst_27528 = (state_27544[(2)]);
var state_27544__$1 = state_27544;
if(cljs.core.truth_(inst_27528)){
var statearr_27555_27603 = state_27544__$1;
(statearr_27555_27603[(1)] = (13));

} else {
var statearr_27556_27604 = state_27544__$1;
(statearr_27556_27604[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (2))){
var _ = (function (){var statearr_27557 = state_27544;
(statearr_27557[(4)] = cljs.core.cons.call(null,(5),(state_27544[(4)])));

return statearr_27557;
})();
var inst_27515 = typeof pred === 'string';
var state_27544__$1 = state_27544;
if(cljs.core.truth_(inst_27515)){
var statearr_27558_27605 = state_27544__$1;
(statearr_27558_27605[(1)] = (6));

} else {
var statearr_27559_27606 = state_27544__$1;
(statearr_27559_27606[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (11))){
var inst_27520 = (state_27544[(8)]);
var state_27544__$1 = state_27544;
var statearr_27561_27607 = state_27544__$1;
(statearr_27561_27607[(2)] = inst_27520);

(statearr_27561_27607[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (9))){
var inst_27520 = (state_27544[(8)]);
var inst_27523 = (state_27544[(2)]);
var inst_27524 = fluree.db.util.async.throw_err.call(null,inst_27523);
var state_27544__$1 = (function (){var statearr_27562 = state_27544;
(statearr_27562[(7)] = inst_27524);

return statearr_27562;
})();
if(cljs.core.truth_(inst_27520)){
var statearr_27563_27608 = state_27544__$1;
(statearr_27563_27608[(1)] = (10));

} else {
var statearr_27564_27609 = state_27544__$1;
(statearr_27564_27609[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (5))){
var _ = (function (){var statearr_27565 = state_27544;
(statearr_27565[(4)] = cljs.core.rest.call(null,(state_27544[(4)])));

return statearr_27565;
})();
var state_27544__$1 = state_27544;
var ex27560 = (state_27544__$1[(2)]);
var statearr_27566_27610 = state_27544__$1;
(statearr_27566_27610[(5)] = ex27560);


if((ex27560 instanceof Error)){
var statearr_27567_27611 = state_27544__$1;
(statearr_27567_27611[(1)] = (4));

(statearr_27567_27611[(5)] = null);

} else {
throw ex27560;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (14))){
var state_27544__$1 = state_27544;
var statearr_27568_27612 = state_27544__$1;
(statearr_27568_27612[(2)] = null);

(statearr_27568_27612[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (16))){
var inst_27524 = (state_27544[(7)]);
var inst_27532 = clojure.string.split.call(null,inst_27524,/:/);
var inst_27533 = cljs.core.second.call(null,inst_27532);
var state_27544__$1 = state_27544;
var statearr_27569_27613 = state_27544__$1;
(statearr_27569_27613[(2)] = inst_27533);

(statearr_27569_27613[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (10))){
var inst_27524 = (state_27544[(7)]);
var state_27544__$1 = state_27544;
var statearr_27570_27614 = state_27544__$1;
(statearr_27570_27614[(2)] = inst_27524);

(statearr_27570_27614[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (18))){
var inst_27536 = (state_27544[(2)]);
var state_27544__$1 = state_27544;
var statearr_27571_27615 = state_27544__$1;
(statearr_27571_27615[(2)] = inst_27536);

(statearr_27571_27615[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27545 === (8))){
var inst_27520 = (state_27544[(2)]);
var inst_27521 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_27544__$1 = (function (){var statearr_27572 = state_27544;
(statearr_27572[(8)] = inst_27520);

return statearr_27572;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27544__$1,(9),inst_27521);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2741__auto__ = null;
var fluree$db$graphdb$state_machine__2741__auto____0 = (function (){
var statearr_27573 = [null,null,null,null,null,null,null,null,null];
(statearr_27573[(0)] = fluree$db$graphdb$state_machine__2741__auto__);

(statearr_27573[(1)] = (1));

return statearr_27573;
});
var fluree$db$graphdb$state_machine__2741__auto____1 = (function (state_27544){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_27544);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27574){var ex__2744__auto__ = e27574;
var statearr_27575_27616 = state_27544;
(statearr_27575_27616[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_27544[(4)]))){
var statearr_27576_27617 = state_27544;
(statearr_27576_27617[(1)] = cljs.core.first.call(null,(state_27544[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27618 = state_27544;
state_27544 = G__27618;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2741__auto__ = function(state_27544){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2741__auto____1.call(this,state_27544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2741__auto____0;
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2741__auto____1;
return fluree$db$graphdb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27577 = f__2764__auto__.call(null);
(statearr_27577[(6)] = c__2763__auto__);

return statearr_27577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__27620 = arguments.length;
switch (G__27620) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27653){
var state_val_27654 = (state_27653[(1)]);
if((state_val_27654 === (7))){
var state_27653__$1 = state_27653;
var statearr_27655_27743 = state_27653__$1;
(statearr_27655_27743[(2)] = null);

(statearr_27655_27743[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (1))){
var state_27653__$1 = state_27653;
var statearr_27656_27744 = state_27653__$1;
(statearr_27656_27744[(2)] = null);

(statearr_27656_27744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (4))){
var inst_27621 = (state_27653[(2)]);
var state_27653__$1 = state_27653;
var statearr_27657_27745 = state_27653__$1;
(statearr_27657_27745[(2)] = inst_27621);

(statearr_27657_27745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (6))){
var inst_27636 = (state_27653[(7)]);
var inst_27635 = (state_27653[(2)]);
var inst_27636__$1 = fluree.db.util.async.throw_err.call(null,inst_27635);
var inst_27637 = (inst_27636__$1 == null);
var state_27653__$1 = (function (){var statearr_27658 = state_27653;
(statearr_27658[(7)] = inst_27636__$1);

return statearr_27658;
})();
if(cljs.core.truth_(inst_27637)){
var statearr_27659_27746 = state_27653__$1;
(statearr_27659_27746[(1)] = (7));

} else {
var statearr_27660_27747 = state_27653__$1;
(statearr_27660_27747[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (3))){
var inst_27651 = (state_27653[(2)]);
var state_27653__$1 = state_27653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27653__$1,inst_27651);
} else {
if((state_val_27654 === (12))){
var inst_27648 = (state_27653[(2)]);
var _ = (function (){var statearr_27661 = state_27653;
(statearr_27661[(4)] = cljs.core.rest.call(null,(state_27653[(4)])));

return statearr_27661;
})();
var state_27653__$1 = state_27653;
var statearr_27662_27748 = state_27653__$1;
(statearr_27662_27748[(2)] = inst_27648);

(statearr_27662_27748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (2))){
var _ = (function (){var statearr_27663 = state_27653;
(statearr_27663[(4)] = cljs.core.cons.call(null,(5),(state_27653[(4)])));

return statearr_27663;
})();
var inst_27627 = (30);
var inst_27629 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_27630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27631 = [inst_27627,tag_name];
var inst_27632 = (new cljs.core.PersistentVector(null,2,(5),inst_27630,inst_27631,null));
var inst_27633 = fluree.db.query.range.index_range.call(null,inst_27629,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27632);
var state_27653__$1 = state_27653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27653__$1,(6),inst_27633);
} else {
if((state_val_27654 === (11))){
var inst_27642 = (state_27653[(8)]);
var inst_27646 = inst_27642.s;
var state_27653__$1 = state_27653;
var statearr_27665_27749 = state_27653__$1;
(statearr_27665_27749[(2)] = inst_27646);

(statearr_27665_27749[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (9))){
var inst_27642 = (state_27653[(8)]);
var inst_27642__$1 = (state_27653[(2)]);
var inst_27643 = (inst_27642__$1 == null);
var state_27653__$1 = (function (){var statearr_27666 = state_27653;
(statearr_27666[(8)] = inst_27642__$1);

return statearr_27666;
})();
if(cljs.core.truth_(inst_27643)){
var statearr_27667_27750 = state_27653__$1;
(statearr_27667_27750[(1)] = (10));

} else {
var statearr_27668_27751 = state_27653__$1;
(statearr_27668_27751[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (5))){
var _ = (function (){var statearr_27669 = state_27653;
(statearr_27669[(4)] = cljs.core.rest.call(null,(state_27653[(4)])));

return statearr_27669;
})();
var state_27653__$1 = state_27653;
var ex27664 = (state_27653__$1[(2)]);
var statearr_27670_27752 = state_27653__$1;
(statearr_27670_27752[(5)] = ex27664);


if((ex27664 instanceof Error)){
var statearr_27671_27753 = state_27653__$1;
(statearr_27671_27753[(1)] = (4));

(statearr_27671_27753[(5)] = null);

} else {
throw ex27664;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (10))){
var state_27653__$1 = state_27653;
var statearr_27672_27754 = state_27653__$1;
(statearr_27672_27754[(2)] = null);

(statearr_27672_27754[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (8))){
var inst_27636 = (state_27653[(7)]);
var inst_27640 = cljs.core.first.call(null,inst_27636);
var state_27653__$1 = state_27653;
var statearr_27673_27755 = state_27653__$1;
(statearr_27673_27755[(2)] = inst_27640);

(statearr_27673_27755[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2741__auto__ = null;
var fluree$db$graphdb$state_machine__2741__auto____0 = (function (){
var statearr_27674 = [null,null,null,null,null,null,null,null,null];
(statearr_27674[(0)] = fluree$db$graphdb$state_machine__2741__auto__);

(statearr_27674[(1)] = (1));

return statearr_27674;
});
var fluree$db$graphdb$state_machine__2741__auto____1 = (function (state_27653){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_27653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27675){var ex__2744__auto__ = e27675;
var statearr_27676_27756 = state_27653;
(statearr_27676_27756[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_27653[(4)]))){
var statearr_27677_27757 = state_27653;
(statearr_27677_27757[(1)] = cljs.core.first.call(null,(state_27653[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27758 = state_27653;
state_27653 = G__27758;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2741__auto__ = function(state_27653){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2741__auto____1.call(this,state_27653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2741__auto____0;
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2741__auto____1;
return fluree$db$graphdb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27678 = f__2764__auto__.call(null);
(statearr_27678[(6)] = c__2763__auto__);

return statearr_27678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27713){
var state_val_27714 = (state_27713[(1)]);
if((state_val_27714 === (7))){
var inst_27692 = typeof pred === 'string';
var state_27713__$1 = state_27713;
if(cljs.core.truth_(inst_27692)){
var statearr_27715_27759 = state_27713__$1;
(statearr_27715_27759[(1)] = (10));

} else {
var statearr_27716_27760 = state_27713__$1;
(statearr_27716_27760[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27714 === (1))){
var state_27713__$1 = state_27713;
var statearr_27717_27761 = state_27713__$1;
(statearr_27717_27761[(2)] = null);

(statearr_27717_27761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27714 === (4))){
var inst_27679 = (state_27713[(2)]);
var state_27713__$1 = state_27713;
var statearr_27718_27762 = state_27713__$1;
(statearr_27718_27762[(2)] = inst_27679);

(statearr_27718_27762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27714 === (15))){
var inst_27706 = (state_27713[(2)]);
var state_27713__$1 = state_27713;
var statearr_27719_27763 = state_27713__$1;
(statearr_27719_27763[(2)] = inst_27706);

(statearr_27719_27763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27714 === (13))){
var inst_27697 = (state_27713[(7)]);
var inst_27699 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27697),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27700 = fluree.db.dbproto._tag_id.call(null,this$,inst_27699);
var state_27713__$1 = state_27713;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27713__$1,(16),inst_27700);
} else {
if((state_val_27714 === (6))){
var inst_27687 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_27713__$1 = state_27713;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27713__$1,(9),inst_27687);
} else {
if((state_val_27714 === (3))){
var inst_27711 = (state_27713[(2)]);
var state_27713__$1 = state_27713;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27713__$1,inst_27711);
} else {
if((state_val_27714 === (12))){
var inst_27697 = (state_27713[(7)]);
var inst_27697__$1 = (state_27713[(2)]);
var state_27713__$1 = (function (){var statearr_27720 = state_27713;
(statearr_27720[(7)] = inst_27697__$1);

return statearr_27720;
})();
if(cljs.core.truth_(inst_27697__$1)){
var statearr_27721_27764 = state_27713__$1;
(statearr_27721_27764[(1)] = (13));

} else {
var statearr_27722_27765 = state_27713__$1;
(statearr_27722_27765[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27714 === (2))){
var _ = (function (){var statearr_27723 = state_27713;
(statearr_27723[(4)] = cljs.core.cons.call(null,(5),(state_27713[(4)])));

return statearr_27723;
})();
var inst_27685 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_27713__$1 = state_27713;
if(inst_27685){
var statearr_27724_27766 = state_27713__$1;
(statearr_27724_27766[(1)] = (6));

} else {
var statearr_27725_27767 = state_27713__$1;
(statearr_27725_27767[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27714 === (11))){
var inst_27695 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27713__$1 = state_27713;
var statearr_27727_27768 = state_27713__$1;
(statearr_27727_27768[(2)] = inst_27695);

(statearr_27727_27768[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27714 === (9))){
var inst_27689 = (state_27713[(2)]);
var inst_27690 = fluree.db.util.async.throw_err.call(null,inst_27689);
var state_27713__$1 = state_27713;
var statearr_27728_27769 = state_27713__$1;
(statearr_27728_27769[(2)] = inst_27690);

(statearr_27728_27769[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27714 === (5))){
var _ = (function (){var statearr_27729 = state_27713;
(statearr_27729[(4)] = cljs.core.rest.call(null,(state_27713[(4)])));

return statearr_27729;
})();
var state_27713__$1 = state_27713;
var ex27726 = (state_27713__$1[(2)]);
var statearr_27730_27770 = state_27713__$1;
(statearr_27730_27770[(5)] = ex27726);


if((ex27726 instanceof Error)){
var statearr_27731_27771 = state_27713__$1;
(statearr_27731_27771[(1)] = (4));

(statearr_27731_27771[(5)] = null);

} else {
throw ex27726;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27714 === (14))){
var state_27713__$1 = state_27713;
var statearr_27732_27772 = state_27713__$1;
(statearr_27732_27772[(2)] = null);

(statearr_27732_27772[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27714 === (16))){
var inst_27702 = (state_27713[(2)]);
var inst_27703 = fluree.db.util.async.throw_err.call(null,inst_27702);
var state_27713__$1 = state_27713;
var statearr_27733_27773 = state_27713__$1;
(statearr_27733_27773[(2)] = inst_27703);

(statearr_27733_27773[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27714 === (10))){
var state_27713__$1 = state_27713;
var statearr_27734_27774 = state_27713__$1;
(statearr_27734_27774[(2)] = pred);

(statearr_27734_27774[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27714 === (8))){
var inst_27708 = (state_27713[(2)]);
var _ = (function (){var statearr_27735 = state_27713;
(statearr_27735[(4)] = cljs.core.rest.call(null,(state_27713[(4)])));

return statearr_27735;
})();
var state_27713__$1 = state_27713;
var statearr_27736_27775 = state_27713__$1;
(statearr_27736_27775[(2)] = inst_27708);

(statearr_27736_27775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2741__auto__ = null;
var fluree$db$graphdb$state_machine__2741__auto____0 = (function (){
var statearr_27737 = [null,null,null,null,null,null,null,null];
(statearr_27737[(0)] = fluree$db$graphdb$state_machine__2741__auto__);

(statearr_27737[(1)] = (1));

return statearr_27737;
});
var fluree$db$graphdb$state_machine__2741__auto____1 = (function (state_27713){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_27713);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27738){var ex__2744__auto__ = e27738;
var statearr_27739_27776 = state_27713;
(statearr_27739_27776[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_27713[(4)]))){
var statearr_27740_27777 = state_27713;
(statearr_27740_27777[(1)] = cljs.core.first.call(null,(state_27713[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27778 = state_27713;
state_27713 = G__27778;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2741__auto__ = function(state_27713){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2741__auto____1.call(this,state_27713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2741__auto____0;
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2741__auto____1;
return fluree$db$graphdb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27741 = f__2764__auto__.call(null);
(statearr_27741[(6)] = c__2763__auto__);

return statearr_27741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k27780,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__27784 = k27780;
var G__27784__$1 = (((G__27784 instanceof cljs.core.Keyword))?G__27784.fqn:null);
switch (G__27784__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27780,else__4505__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__27785){
var vec__27786 = p__27785;
var k__4526__auto__ = cljs.core.nth.call(null,vec__27786,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__27786,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27779){
var self__ = this;
var G__27779__$1 = this;
return (new cljs.core.RecordIter((0),G__27779__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27781,other27782){
var self__ = this;
var this27781__$1 = this;
return (((!((other27782 == null)))) && ((((this27781__$1.constructor === other27782.constructor)) && (((cljs.core._EQ_.call(null,this27781__$1.conn,other27782.conn)) && (((cljs.core._EQ_.call(null,this27781__$1.network,other27782.network)) && (((cljs.core._EQ_.call(null,this27781__$1.dbid,other27782.dbid)) && (((cljs.core._EQ_.call(null,this27781__$1.block,other27782.block)) && (((cljs.core._EQ_.call(null,this27781__$1.t,other27782.t)) && (((cljs.core._EQ_.call(null,this27781__$1.tt_id,other27782.tt_id)) && (((cljs.core._EQ_.call(null,this27781__$1.stats,other27782.stats)) && (((cljs.core._EQ_.call(null,this27781__$1.spot,other27782.spot)) && (((cljs.core._EQ_.call(null,this27781__$1.psot,other27782.psot)) && (((cljs.core._EQ_.call(null,this27781__$1.post,other27782.post)) && (((cljs.core._EQ_.call(null,this27781__$1.opst,other27782.opst)) && (((cljs.core._EQ_.call(null,this27781__$1.schema,other27782.schema)) && (((cljs.core._EQ_.call(null,this27781__$1.settings,other27782.settings)) && (((cljs.core._EQ_.call(null,this27781__$1.index_configs,other27782.index_configs)) && (((cljs.core._EQ_.call(null,this27781__$1.schema_cache,other27782.schema_cache)) && (((cljs.core._EQ_.call(null,this27781__$1.novelty,other27782.novelty)) && (((cljs.core._EQ_.call(null,this27781__$1.permissions,other27782.permissions)) && (((cljs.core._EQ_.call(null,this27781__$1.fork,other27782.fork)) && (((cljs.core._EQ_.call(null,this27781__$1.fork_block,other27782.fork_block)) && (((cljs.core._EQ_.call(null,this27781__$1.current_db_fn,other27782.current_db_fn)) && (cljs.core._EQ_.call(null,this27781__$1.__extmap,other27782.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k27780){
var self__ = this;
var this__4509__auto____$1 = this;
var G__27789 = k27780;
var G__27789__$1 = (((G__27789 instanceof cljs.core.Keyword))?G__27789.fqn:null);
switch (G__27789__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k27780);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__27779){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__27790 = cljs.core.keyword_identical_QMARK_;
var expr__27791 = k__4511__auto__;
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27791))){
return (new fluree.db.graphdb.GraphDb(G__27779,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27779,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27779,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__27779,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__27779,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__27779,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__27779,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__27779,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27779,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27779,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27779,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27779,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__27779,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__27779,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__27779,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__27779,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__27779,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__27779,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27779,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27790.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__27791))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27779,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__27779),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__27779){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27779,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27783){
var extmap__4542__auto__ = (function (){var G__27793 = cljs.core.dissoc.call(null,G__27783,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__27783)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27793);
} else {
return G__27793;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27783),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27783),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
