// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (((cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4253__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__13729 = match;
var p1 = cljs.core.nth.call(null,vec__13729,(0),null);
var p2 = cljs.core.nth.call(null,vec__13729,(1),null);
var p3 = cljs.core.nth.call(null,vec__13729,(2),null);
var t = cljs.core.nth.call(null,vec__13729,(3),null);
var op = cljs.core.nth.call(null,vec__13729,(4),null);
var m = cljs.core.nth.call(null,vec__13729,(5),null);
var G__13732 = idx;
var G__13732__$1 = (((G__13732 instanceof cljs.core.Keyword))?G__13732.fqn:null);
switch (G__13732__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13732__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__13734 = idx;
var G__13734__$1 = (((G__13734 instanceof cljs.core.Keyword))?G__13734.fqn:null);
switch (G__13734__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13734__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__13736 = idx;
var G__13736__$1 = (((G__13736 instanceof cljs.core.Keyword))?G__13736.fqn:null);
switch (G__13736__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13736__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__13739 = arguments.length;
switch (G__13739) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13740 = (function (){var pred__13743 = cljs.core.identical_QMARK_;
var expr__13744 = test;
if(cljs.core.truth_(pred__13743.call(null,cljs.core._EQ_,expr__13744))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13743.call(null,cljs.core._LT_,expr__13744))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__13743.call(null,cljs.core._LT__EQ_,expr__13744))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13743.call(null,cljs.core._GT_,expr__13744))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__13743.call(null,cljs.core._GT__EQ_,expr__13744))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13744)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__13740,(0),null);
var start_match = cljs.core.nth.call(null,vec__13740,(1),null);
var end_test = cljs.core.nth.call(null,vec__13740,(2),null);
var end_match = cljs.core.nth.call(null,vec__13740,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_13983){
var state_val_13984 = (state_13983[(1)]);
if((state_val_13984 === (65))){
var inst_13954 = (state_13983[(7)]);
var inst_13898 = (state_13983[(8)]);
var inst_13954__$1 = (state_13983[(2)]);
var inst_13955 = cljs.core.count.call(null,inst_13954__$1);
var state_13983__$1 = (function (){var statearr_13985 = state_13983;
(statearr_13985[(9)] = inst_13955);

(statearr_13985[(7)] = inst_13954__$1);

return statearr_13985;
})();
if(cljs.core.truth_(inst_13898)){
var statearr_13986_14123 = state_13983__$1;
(statearr_13986_14123[(1)] = (81));

} else {
var statearr_13987_14124 = state_13983__$1;
(statearr_13987_14124[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (70))){
var inst_13929 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13929)){
var statearr_13988_14125 = state_13983__$1;
(statearr_13988_14125[(1)] = (71));

} else {
var statearr_13989_14126 = state_13983__$1;
(statearr_13989_14126[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (62))){
var inst_13882 = (state_13983[(10)]);
var inst_13868 = (state_13983[(11)]);
var inst_13897 = (state_13983[(2)]);
var inst_13898 = fluree.db.dbproto._rhs.call(null,inst_13882);
var state_13983__$1 = (function (){var statearr_13990 = state_13983;
(statearr_13990[(12)] = inst_13897);

(statearr_13990[(8)] = inst_13898);

return statearr_13990;
})();
if(cljs.core.truth_(inst_13868)){
var statearr_13991_14127 = state_13983__$1;
(statearr_13991_14127[(1)] = (63));

} else {
var statearr_13992_14128 = state_13983__$1;
(statearr_13992_14128[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (74))){
var inst_13922 = (state_13983[(13)]);
var inst_13936 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_13922);
var state_13983__$1 = state_13983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13983__$1,(77),inst_13936);
} else {
if((state_val_13984 === (7))){
var inst_13759 = (state_13983[(14)]);
var state_13983__$1 = state_13983;
var statearr_13993_14129 = state_13983__$1;
(statearr_13993_14129[(2)] = inst_13759);

(statearr_13993_14129[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (59))){
var inst_13844 = (state_13983[(15)]);
var inst_13845 = (state_13983[(16)]);
var inst_13889 = (state_13983[(17)]);
var inst_13888 = (state_13983[(2)]);
var inst_13889__$1 = fluree.db.util.async.throw_err.call(null,inst_13888);
var inst_13890 = fluree.db.flake.subrange.call(null,inst_13889__$1,start_test,inst_13844,end_test,inst_13845);
var inst_13891 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_13844,inst_13845);
var state_13983__$1 = (function (){var statearr_13994 = state_13983;
(statearr_13994[(17)] = inst_13889__$1);

(statearr_13994[(18)] = inst_13890);

return statearr_13994;
})();
if(inst_13891){
var statearr_13995_14130 = state_13983__$1;
(statearr_13995_14130[(1)] = (60));

} else {
var statearr_13996_14131 = state_13983__$1;
(statearr_13996_14131[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (86))){
var inst_13963 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_13997_14132 = state_13983__$1;
(statearr_13997_14132[(2)] = inst_13963);

(statearr_13997_14132[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (20))){
var inst_13760 = (state_13983[(19)]);
var inst_13808 = (state_13983[(20)]);
var inst_13807 = (state_13983[(2)]);
var inst_13808__$1 = (inst_13760 == null);
var state_13983__$1 = (function (){var statearr_13998 = state_13983;
(statearr_13998[(20)] = inst_13808__$1);

(statearr_13998[(21)] = inst_13807);

return statearr_13998;
})();
if(cljs.core.truth_(inst_13808__$1)){
var statearr_13999_14133 = state_13983__$1;
(statearr_13999_14133[(1)] = (22));

} else {
var statearr_14000_14134 = state_13983__$1;
(statearr_14000_14134[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (72))){
var inst_13915 = (state_13983[(22)]);
var inst_13933 = (inst_13915 + (1));
var inst_13934 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_13983__$1 = (function (){var statearr_14001 = state_13983;
(statearr_14001[(23)] = inst_13933);

return statearr_14001;
})();
if(cljs.core.truth_(inst_13934)){
var statearr_14002_14135 = state_13983__$1;
(statearr_14002_14135[(1)] = (74));

} else {
var statearr_14003_14136 = state_13983__$1;
(statearr_14003_14136[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (58))){
var inst_13978 = (state_13983[(2)]);
var _ = (function (){var statearr_14004 = state_13983;
(statearr_14004[(4)] = cljs.core.rest.call(null,(state_13983[(4)])));

return statearr_14004;
})();
var state_13983__$1 = state_13983;
var statearr_14005_14137 = state_13983__$1;
(statearr_14005_14137[(2)] = inst_13978);

(statearr_14005_14137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (60))){
var inst_13765 = (state_13983[(24)]);
var inst_13883 = (state_13983[(25)]);
var inst_13769 = (state_13983[(26)]);
var inst_13850 = (state_13983[(27)]);
var inst_13882 = (state_13983[(10)]);
var inst_13834 = (state_13983[(28)]);
var inst_13789 = (state_13983[(29)]);
var inst_13862 = (state_13983[(30)]);
var inst_13872 = (state_13983[(31)]);
var inst_13762 = (state_13983[(32)]);
var inst_13855 = (state_13983[(33)]);
var inst_13798 = (state_13983[(34)]);
var inst_13844 = (state_13983[(15)]);
var inst_13825 = (state_13983[(35)]);
var inst_13868 = (state_13983[(11)]);
var inst_13758 = (state_13983[(36)]);
var inst_13763 = (state_13983[(37)]);
var inst_13770 = (state_13983[(38)]);
var inst_13884 = (state_13983[(39)]);
var inst_13851 = (state_13983[(40)]);
var inst_13780 = (state_13983[(41)]);
var inst_13845 = (state_13983[(16)]);
var inst_13877 = (state_13983[(42)]);
var inst_13816 = (state_13983[(43)]);
var inst_13861 = (state_13983[(44)]);
var inst_13889 = (state_13983[(17)]);
var inst_13890 = (state_13983[(18)]);
var inst_13807 = (state_13983[(21)]);
var inst_13843 = (state_13983[(45)]);
var inst_13893 = (function (){var no_filter_QMARK_ = inst_13868;
var next_node = inst_13882;
var flakes = inst_13889;
var vec__13755 = inst_13765;
var s1 = inst_13780;
var o2 = inst_13807;
var t1 = inst_13762;
var i = inst_13883;
var m1 = inst_13834;
var root_node = inst_13877;
var to_t = inst_13862;
var s2 = inst_13789;
var p2 = inst_13825;
var permissions = inst_13851;
var limit = inst_13850;
var start_flake = inst_13844;
var vec__13752 = inst_13758;
var acc = inst_13884;
var t2 = inst_13769;
var op1 = inst_13763;
var o1 = inst_13798;
var end_flake = inst_13845;
var base_result = inst_13890;
var p1 = inst_13816;
var idx_compare = inst_13855;
var op2 = inst_13770;
var from_t = inst_13861;
var m2 = inst_13843;
var novelty = inst_13872;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_13894 = cljs.core.reduce.call(null,inst_13893,inst_13890,inst_13890);
var state_13983__$1 = state_13983;
var statearr_14006_14138 = state_13983__$1;
(statearr_14006_14138[(2)] = inst_13894);

(statearr_14006_14138[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (27))){
var inst_13767 = (state_13983[(46)]);
var inst_13817 = (state_13983[(47)]);
var inst_13816 = (state_13983[(2)]);
var inst_13817__$1 = (inst_13767 == null);
var state_13983__$1 = (function (){var statearr_14007 = state_13983;
(statearr_14007[(47)] = inst_13817__$1);

(statearr_14007[(43)] = inst_13816);

return statearr_14007;
})();
if(cljs.core.truth_(inst_13817__$1)){
var statearr_14008_14139 = state_13983__$1;
(statearr_14008_14139[(1)] = (28));

} else {
var statearr_14009_14140 = state_13983__$1;
(statearr_14009_14140[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (1))){
var state_13983__$1 = state_13983;
var statearr_14010_14141 = state_13983__$1;
(statearr_14010_14141[(2)] = null);

(statearr_14010_14141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (69))){
var inst_13850 = (state_13983[(27)]);
var inst_13915 = (state_13983[(22)]);
var inst_13927 = (inst_13915 > inst_13850);
var state_13983__$1 = state_13983;
var statearr_14011_14142 = state_13983__$1;
(statearr_14011_14142[(2)] = inst_13927);

(statearr_14011_14142[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (24))){
var inst_13812 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13812)){
var statearr_14012_14143 = state_13983__$1;
(statearr_14012_14143[(1)] = (25));

} else {
var statearr_14013_14144 = state_13983__$1;
(statearr_14013_14144[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (55))){
var inst_13844 = (state_13983[(15)]);
var inst_13877 = (state_13983[(42)]);
var inst_13876 = (state_13983[(2)]);
var inst_13877__$1 = fluree.db.util.async.throw_err.call(null,inst_13876);
var inst_13878 = fluree.db.dbproto._lookup_leaf.call(null,inst_13877__$1,inst_13844);
var state_13983__$1 = (function (){var statearr_14014 = state_13983;
(statearr_14014[(42)] = inst_13877__$1);

return statearr_14014;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13983__$1,(56),inst_13878);
} else {
if((state_val_13984 === (85))){
var inst_13958 = (state_13983[(48)]);
var state_13983__$1 = state_13983;
var statearr_14015_14145 = state_13983__$1;
(statearr_14015_14145[(2)] = inst_13958);

(statearr_14015_14145[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (39))){
var inst_13832 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_14016_14146 = state_13983__$1;
(statearr_14016_14146[(2)] = inst_13832);

(statearr_14016_14146[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (88))){
var inst_13877 = (state_13983[(42)]);
var inst_13898 = (state_13983[(8)]);
var inst_13970 = fluree.db.dbproto._lookup_leaf.call(null,inst_13877,inst_13898);
var state_13983__$1 = state_13983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13983__$1,(90),inst_13970);
} else {
if((state_val_13984 === (46))){
var inst_13846 = (state_13983[(49)]);
var state_13983__$1 = state_13983;
var statearr_14017_14147 = state_13983__$1;
(statearr_14017_14147[(2)] = inst_13846);

(statearr_14017_14147[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (4))){
var inst_13746 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_14018_14148 = state_13983__$1;
(statearr_14018_14148[(2)] = inst_13746);

(statearr_14018_14148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (77))){
var inst_13938 = (state_13983[(2)]);
var inst_13939 = fluree.db.util.async.throw_err.call(null,inst_13938);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13939)){
var statearr_14019_14149 = state_13983__$1;
(statearr_14019_14149[(1)] = (78));

} else {
var statearr_14020_14150 = state_13983__$1;
(statearr_14020_14150[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (54))){
var inst_13868 = (state_13983[(2)]);
var inst_13869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13870 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13871 = (new cljs.core.PersistentVector(null,2,(5),inst_13869,inst_13870,null));
var inst_13872 = cljs.core.get_in.call(null,db,inst_13871);
var inst_13873 = cljs.core.get.call(null,db,idx);
var inst_13874 = fluree.db.dbproto._resolve.call(null,inst_13873);
var state_13983__$1 = (function (){var statearr_14021 = state_13983;
(statearr_14021[(31)] = inst_13872);

(statearr_14021[(11)] = inst_13868);

return statearr_14021;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13983__$1,(55),inst_13874);
} else {
if((state_val_13984 === (15))){
var inst_13761 = (state_13983[(50)]);
var state_13983__$1 = state_13983;
var statearr_14022_14151 = state_13983__$1;
(statearr_14022_14151[(2)] = inst_13761);

(statearr_14022_14151[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (48))){
var inst_13856 = (state_13983[(51)]);
var inst_13850 = (state_13983[(2)]);
var inst_13851 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13853 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13854 = (new cljs.core.PersistentVector(null,3,(5),inst_13852,inst_13853,null));
var inst_13855 = cljs.core.get_in.call(null,db,inst_13854);
var inst_13856__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_13983__$1 = (function (){var statearr_14023 = state_13983;
(statearr_14023[(27)] = inst_13850);

(statearr_14023[(33)] = inst_13855);

(statearr_14023[(40)] = inst_13851);

(statearr_14023[(51)] = inst_13856__$1);

return statearr_14023;
})();
if(cljs.core.truth_(inst_13856__$1)){
var statearr_14024_14152 = state_13983__$1;
(statearr_14024_14152[(1)] = (49));

} else {
var statearr_14025_14153 = state_13983__$1;
(statearr_14025_14153[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (50))){
var inst_13859 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_13983__$1 = state_13983;
var statearr_14026_14154 = state_13983__$1;
(statearr_14026_14154[(2)] = inst_13859);

(statearr_14026_14154[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (75))){
var inst_13916 = (state_13983[(52)]);
var state_13983__$1 = state_13983;
var statearr_14027_14155 = state_13983__$1;
(statearr_14027_14155[(2)] = inst_13916);

(statearr_14027_14155[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (21))){
var inst_13803 = (state_13983[(2)]);
var inst_13804 = fluree.db.util.async.throw_err.call(null,inst_13803);
var state_13983__$1 = state_13983;
var statearr_14028_14156 = state_13983__$1;
(statearr_14028_14156[(2)] = inst_13804);

(statearr_14028_14156[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (31))){
var state_13983__$1 = state_13983;
var statearr_14029_14157 = state_13983__$1;
(statearr_14029_14157[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14029_14157[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (32))){
var inst_13767 = (state_13983[(46)]);
var state_13983__$1 = state_13983;
var statearr_14030_14158 = state_13983__$1;
(statearr_14030_14158[(2)] = inst_13767);

(statearr_14030_14158[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (40))){
var inst_13771 = (state_13983[(53)]);
var state_13983__$1 = state_13983;
var statearr_14031_14159 = state_13983__$1;
(statearr_14031_14159[(2)] = inst_13771);

(statearr_14031_14159[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (56))){
var inst_13880 = (state_13983[(2)]);
var inst_13881 = fluree.db.util.async.throw_err.call(null,inst_13880);
var inst_13882 = inst_13881;
var inst_13883 = (0);
var inst_13884 = null;
var state_13983__$1 = (function (){var statearr_14032 = state_13983;
(statearr_14032[(25)] = inst_13883);

(statearr_14032[(10)] = inst_13882);

(statearr_14032[(39)] = inst_13884);

return statearr_14032;
})();
var statearr_14033_14160 = state_13983__$1;
(statearr_14033_14160[(2)] = null);

(statearr_14033_14160[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (33))){
var inst_13764 = (state_13983[(54)]);
var inst_13825 = (state_13983[(2)]);
var state_13983__$1 = (function (){var statearr_14034 = state_13983;
(statearr_14034[(35)] = inst_13825);

return statearr_14034;
})();
if(cljs.core.truth_(inst_13764)){
var statearr_14035_14161 = state_13983__$1;
(statearr_14035_14161[(1)] = (34));

} else {
var statearr_14036_14162 = state_13983__$1;
(statearr_14036_14162[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (13))){
var inst_13785 = (state_13983[(2)]);
var inst_13786 = fluree.db.util.async.throw_err.call(null,inst_13785);
var state_13983__$1 = state_13983;
var statearr_14037_14163 = state_13983__$1;
(statearr_14037_14163[(2)] = inst_13786);

(statearr_14037_14163[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (22))){
var inst_13798 = (state_13983[(34)]);
var state_13983__$1 = state_13983;
var statearr_14038_14164 = state_13983__$1;
(statearr_14038_14164[(2)] = inst_13798);

(statearr_14038_14164[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (90))){
var inst_13955 = (state_13983[(9)]);
var inst_13954 = (state_13983[(7)]);
var inst_13972 = (state_13983[(2)]);
var inst_13973 = fluree.db.util.async.throw_err.call(null,inst_13972);
var inst_13882 = inst_13973;
var inst_13883 = inst_13955;
var inst_13884 = inst_13954;
var state_13983__$1 = (function (){var statearr_14039 = state_13983;
(statearr_14039[(25)] = inst_13883);

(statearr_14039[(10)] = inst_13882);

(statearr_14039[(39)] = inst_13884);

return statearr_14039;
})();
var statearr_14040_14165 = state_13983__$1;
(statearr_14040_14165[(2)] = null);

(statearr_14040_14165[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (36))){
var inst_13771 = (state_13983[(53)]);
var inst_13834 = (state_13983[(2)]);
var state_13983__$1 = (function (){var statearr_14041 = state_13983;
(statearr_14041[(28)] = inst_13834);

return statearr_14041;
})();
if(cljs.core.truth_(inst_13771)){
var statearr_14042_14166 = state_13983__$1;
(statearr_14042_14166[(1)] = (40));

} else {
var statearr_14043_14167 = state_13983__$1;
(statearr_14043_14167[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (41))){
var inst_13837 = (cljs.core._LT__EQ_ === end_test);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13837)){
var statearr_14044_14168 = state_13983__$1;
(statearr_14044_14168[(1)] = (43));

} else {
var statearr_14045_14169 = state_13983__$1;
(statearr_14045_14169[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (89))){
var inst_13976 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_14046_14170 = state_13983__$1;
(statearr_14046_14170[(2)] = inst_13976);

(statearr_14046_14170[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (43))){
var state_13983__$1 = state_13983;
var statearr_14047_14171 = state_13983__$1;
(statearr_14047_14171[(2)] = (2147483647));

(statearr_14047_14171[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (61))){
var inst_13890 = (state_13983[(18)]);
var state_13983__$1 = state_13983;
var statearr_14048_14172 = state_13983__$1;
(statearr_14048_14172[(2)] = inst_13890);

(statearr_14048_14172[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (29))){
var inst_13817 = (state_13983[(47)]);
var state_13983__$1 = state_13983;
var statearr_14049_14173 = state_13983__$1;
(statearr_14049_14173[(2)] = inst_13817);

(statearr_14049_14173[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (44))){
var state_13983__$1 = state_13983;
var statearr_14050_14174 = state_13983__$1;
(statearr_14050_14174[(2)] = fluree.db.util.core.min_integer);

(statearr_14050_14174[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (6))){
var inst_13759 = (state_13983[(14)]);
var inst_13774 = fluree.db.dbproto._subid.call(null,db,inst_13759);
var state_13983__$1 = state_13983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13983__$1,(9),inst_13774);
} else {
if((state_val_13984 === (28))){
var inst_13807 = (state_13983[(21)]);
var state_13983__$1 = state_13983;
var statearr_14051_14175 = state_13983__$1;
(statearr_14051_14175[(2)] = inst_13807);

(statearr_14051_14175[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (64))){
var inst_13883 = (state_13983[(25)]);
var inst_13897 = (state_13983[(12)]);
var inst_13911 = cljs.core.seq.call(null,inst_13897);
var inst_13912 = cljs.core.first.call(null,inst_13911);
var inst_13913 = cljs.core.next.call(null,inst_13911);
var inst_13914 = inst_13897;
var inst_13915 = inst_13883;
var inst_13916 = inst_13897;
var state_13983__$1 = (function (){var statearr_14052 = state_13983;
(statearr_14052[(22)] = inst_13915);

(statearr_14052[(55)] = inst_13914);

(statearr_14052[(56)] = inst_13912);

(statearr_14052[(52)] = inst_13916);

(statearr_14052[(57)] = inst_13913);

return statearr_14052;
})();
var statearr_14053_14176 = state_13983__$1;
(statearr_14053_14176[(2)] = null);

(statearr_14053_14176[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (51))){
var inst_13861 = (state_13983[(2)]);
var inst_13862 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_13863 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_13983__$1 = (function (){var statearr_14054 = state_13983;
(statearr_14054[(30)] = inst_13862);

(statearr_14054[(44)] = inst_13861);

return statearr_14054;
})();
if(cljs.core.truth_(inst_13863)){
var statearr_14055_14177 = state_13983__$1;
(statearr_14055_14177[(1)] = (52));

} else {
var statearr_14056_14178 = state_13983__$1;
(statearr_14056_14178[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (25))){
var state_13983__$1 = state_13983;
var statearr_14057_14179 = state_13983__$1;
(statearr_14057_14179[(2)] = (-1));

(statearr_14057_14179[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (34))){
var inst_13764 = (state_13983[(54)]);
var state_13983__$1 = state_13983;
var statearr_14058_14180 = state_13983__$1;
(statearr_14058_14180[(2)] = inst_13764);

(statearr_14058_14180[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (17))){
var inst_13794 = (state_13983[(2)]);
var inst_13795 = fluree.db.util.async.throw_err.call(null,inst_13794);
var state_13983__$1 = state_13983;
var statearr_14059_14181 = state_13983__$1;
(statearr_14059_14181[(2)] = inst_13795);

(statearr_14059_14181[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (3))){
var inst_13981 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13983__$1,inst_13981);
} else {
if((state_val_13984 === (12))){
var inst_13761 = (state_13983[(50)]);
var inst_13789 = (state_13983[(2)]);
var inst_13790 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13761);
var state_13983__$1 = (function (){var statearr_14060 = state_13983;
(statearr_14060[(29)] = inst_13789);

return statearr_14060;
})();
if(inst_13790){
var statearr_14061_14182 = state_13983__$1;
(statearr_14061_14182[(1)] = (14));

} else {
var statearr_14062_14183 = state_13983__$1;
(statearr_14062_14183[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (2))){
var inst_13765 = (state_13983[(24)]);
var inst_13758 = (state_13983[(36)]);
var inst_13759 = (state_13983[(14)]);
var _ = (function (){var statearr_14063 = state_13983;
(statearr_14063[(4)] = cljs.core.cons.call(null,(5),(state_13983[(4)])));

return statearr_14063;
})();
var inst_13758__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_13759__$1 = cljs.core.nth.call(null,inst_13758__$1,(0),null);
var inst_13760 = cljs.core.nth.call(null,inst_13758__$1,(1),null);
var inst_13761 = cljs.core.nth.call(null,inst_13758__$1,(2),null);
var inst_13762 = cljs.core.nth.call(null,inst_13758__$1,(3),null);
var inst_13763 = cljs.core.nth.call(null,inst_13758__$1,(4),null);
var inst_13764 = cljs.core.nth.call(null,inst_13758__$1,(5),null);
var inst_13765__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_13766 = cljs.core.nth.call(null,inst_13765__$1,(0),null);
var inst_13767 = cljs.core.nth.call(null,inst_13765__$1,(1),null);
var inst_13768 = cljs.core.nth.call(null,inst_13765__$1,(2),null);
var inst_13769 = cljs.core.nth.call(null,inst_13765__$1,(3),null);
var inst_13770 = cljs.core.nth.call(null,inst_13765__$1,(4),null);
var inst_13771 = cljs.core.nth.call(null,inst_13765__$1,(5),null);
var inst_13772 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13759__$1);
var state_13983__$1 = (function (){var statearr_14064 = state_13983;
(statearr_14064[(50)] = inst_13761);

(statearr_14064[(19)] = inst_13760);

(statearr_14064[(24)] = inst_13765__$1);

(statearr_14064[(26)] = inst_13769);

(statearr_14064[(46)] = inst_13767);

(statearr_14064[(54)] = inst_13764);

(statearr_14064[(32)] = inst_13762);

(statearr_14064[(36)] = inst_13758__$1);

(statearr_14064[(37)] = inst_13763);

(statearr_14064[(58)] = inst_13766);

(statearr_14064[(38)] = inst_13770);

(statearr_14064[(53)] = inst_13771);

(statearr_14064[(59)] = inst_13768);

(statearr_14064[(14)] = inst_13759__$1);

return statearr_14064;
})();
if(inst_13772){
var statearr_14065_14184 = state_13983__$1;
(statearr_14065_14184[(1)] = (6));

} else {
var statearr_14066_14185 = state_13983__$1;
(statearr_14066_14185[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (66))){
var inst_13922 = (state_13983[(13)]);
var inst_13924 = (state_13983[(60)]);
var inst_13914 = (state_13983[(55)]);
var inst_13921 = cljs.core.seq.call(null,inst_13914);
var inst_13922__$1 = cljs.core.first.call(null,inst_13921);
var inst_13923 = cljs.core.next.call(null,inst_13921);
var inst_13924__$1 = (inst_13922__$1 == null);
var state_13983__$1 = (function (){var statearr_14067 = state_13983;
(statearr_14067[(61)] = inst_13923);

(statearr_14067[(13)] = inst_13922__$1);

(statearr_14067[(60)] = inst_13924__$1);

return statearr_14067;
})();
if(cljs.core.truth_(inst_13924__$1)){
var statearr_14068_14186 = state_13983__$1;
(statearr_14068_14186[(1)] = (68));

} else {
var statearr_14069_14187 = state_13983__$1;
(statearr_14069_14187[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (23))){
var inst_13808 = (state_13983[(20)]);
var state_13983__$1 = state_13983;
var statearr_14070_14188 = state_13983__$1;
(statearr_14070_14188[(2)] = inst_13808);

(statearr_14070_14188[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (47))){
var state_13983__$1 = state_13983;
var statearr_14071_14189 = state_13983__$1;
(statearr_14071_14189[(2)] = fluree.db.util.core.max_long);

(statearr_14071_14189[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (35))){
var inst_13828 = (cljs.core._GT__EQ_ === start_test);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13828)){
var statearr_14072_14190 = state_13983__$1;
(statearr_14072_14190[(1)] = (37));

} else {
var statearr_14073_14191 = state_13983__$1;
(statearr_14073_14191[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (82))){
var inst_13898 = (state_13983[(8)]);
var state_13983__$1 = state_13983;
var statearr_14074_14192 = state_13983__$1;
(statearr_14074_14192[(2)] = inst_13898);

(statearr_14074_14192[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (76))){
var inst_13923 = (state_13983[(61)]);
var inst_13933 = (state_13983[(23)]);
var inst_13947 = (state_13983[(2)]);
var inst_13914 = inst_13923;
var inst_13915 = inst_13933;
var inst_13916 = inst_13947;
var state_13983__$1 = (function (){var statearr_14075 = state_13983;
(statearr_14075[(22)] = inst_13915);

(statearr_14075[(55)] = inst_13914);

(statearr_14075[(52)] = inst_13916);

return statearr_14075;
})();
var statearr_14076_14193 = state_13983__$1;
(statearr_14076_14193[(2)] = null);

(statearr_14076_14193[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (19))){
var inst_13768 = (state_13983[(59)]);
var state_13983__$1 = state_13983;
var statearr_14077_14194 = state_13983__$1;
(statearr_14077_14194[(2)] = inst_13768);

(statearr_14077_14194[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (57))){
var inst_13882 = (state_13983[(10)]);
var inst_13862 = (state_13983[(30)]);
var inst_13872 = (state_13983[(31)]);
var inst_13861 = (state_13983[(44)]);
var inst_13886 = fluree.db.dbproto._resolve_history_range.call(null,inst_13882,inst_13861,inst_13862,inst_13872);
var state_13983__$1 = state_13983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13983__$1,(59),inst_13886);
} else {
if((state_val_13984 === (68))){
var inst_13924 = (state_13983[(60)]);
var state_13983__$1 = state_13983;
var statearr_14078_14195 = state_13983__$1;
(statearr_14078_14195[(2)] = inst_13924);

(statearr_14078_14195[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (11))){
var inst_13766 = (state_13983[(58)]);
var state_13983__$1 = state_13983;
var statearr_14080_14196 = state_13983__$1;
(statearr_14080_14196[(2)] = inst_13766);

(statearr_14080_14196[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (9))){
var inst_13776 = (state_13983[(2)]);
var inst_13777 = fluree.db.util.async.throw_err.call(null,inst_13776);
var state_13983__$1 = state_13983;
var statearr_14081_14197 = state_13983__$1;
(statearr_14081_14197[(2)] = inst_13777);

(statearr_14081_14197[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (5))){
var _ = (function (){var statearr_14082 = state_13983;
(statearr_14082[(4)] = cljs.core.rest.call(null,(state_13983[(4)])));

return statearr_14082;
})();
var state_13983__$1 = state_13983;
var ex14079 = (state_13983__$1[(2)]);
var statearr_14083_14198 = state_13983__$1;
(statearr_14083_14198[(5)] = ex14079);


if((ex14079 instanceof Error)){
var statearr_14084_14199 = state_13983__$1;
(statearr_14084_14199[(1)] = (4));

(statearr_14084_14199[(5)] = null);

} else {
throw ex14079;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (83))){
var inst_13966 = (state_13983[(2)]);
var inst_13967 = cljs.core.not.call(null,inst_13966);
var state_13983__$1 = state_13983;
if(inst_13967){
var statearr_14085_14200 = state_13983__$1;
(statearr_14085_14200[(1)] = (87));

} else {
var statearr_14086_14201 = state_13983__$1;
(statearr_14086_14201[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (14))){
var inst_13761 = (state_13983[(50)]);
var inst_13792 = fluree.db.dbproto._subid.call(null,db,inst_13761);
var state_13983__$1 = state_13983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13983__$1,(17),inst_13792);
} else {
if((state_val_13984 === (45))){
var inst_13841 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_14087_14202 = state_13983__$1;
(statearr_14087_14202[(2)] = inst_13841);

(statearr_14087_14202[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (53))){
var state_13983__$1 = state_13983;
var statearr_14088_14203 = state_13983__$1;
(statearr_14088_14203[(2)] = true);

(statearr_14088_14203[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (78))){
var inst_13916 = (state_13983[(52)]);
var state_13983__$1 = state_13983;
var statearr_14089_14204 = state_13983__$1;
(statearr_14089_14204[(2)] = inst_13916);

(statearr_14089_14204[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (26))){
var inst_13760 = (state_13983[(19)]);
var state_13983__$1 = state_13983;
var statearr_14090_14205 = state_13983__$1;
(statearr_14090_14205[(2)] = inst_13760);

(statearr_14090_14205[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (16))){
var inst_13768 = (state_13983[(59)]);
var inst_13798 = (state_13983[(2)]);
var inst_13799 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13768);
var state_13983__$1 = (function (){var statearr_14091 = state_13983;
(statearr_14091[(34)] = inst_13798);

return statearr_14091;
})();
if(inst_13799){
var statearr_14092_14206 = state_13983__$1;
(statearr_14092_14206[(1)] = (18));

} else {
var statearr_14093_14207 = state_13983__$1;
(statearr_14093_14207[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (81))){
var inst_13855 = (state_13983[(33)]);
var inst_13958 = (state_13983[(48)]);
var inst_13845 = (state_13983[(16)]);
var inst_13898 = (state_13983[(8)]);
var inst_13957 = inst_13855.call(null,inst_13898,inst_13845);
var inst_13958__$1 = (inst_13957 < (0));
var state_13983__$1 = (function (){var statearr_14094 = state_13983;
(statearr_14094[(48)] = inst_13958__$1);

return statearr_14094;
})();
if(cljs.core.truth_(inst_13958__$1)){
var statearr_14095_14208 = state_13983__$1;
(statearr_14095_14208[(1)] = (84));

} else {
var statearr_14096_14209 = state_13983__$1;
(statearr_14096_14209[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (79))){
var inst_13922 = (state_13983[(13)]);
var inst_13916 = (state_13983[(52)]);
var inst_13942 = cljs.core.disj.call(null,inst_13916,inst_13922);
var state_13983__$1 = state_13983;
var statearr_14097_14210 = state_13983__$1;
(statearr_14097_14210[(2)] = inst_13942);

(statearr_14097_14210[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (38))){
var state_13983__$1 = state_13983;
var statearr_14098_14211 = state_13983__$1;
(statearr_14098_14211[(2)] = (2147483647));

(statearr_14098_14211[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (87))){
var inst_13954 = (state_13983[(7)]);
var state_13983__$1 = state_13983;
var statearr_14099_14212 = state_13983__$1;
(statearr_14099_14212[(2)] = inst_13954);

(statearr_14099_14212[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (30))){
var inst_13821 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13821)){
var statearr_14100_14213 = state_13983__$1;
(statearr_14100_14213[(1)] = (31));

} else {
var statearr_14101_14214 = state_13983__$1;
(statearr_14101_14214[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (73))){
var inst_13950 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_14102_14215 = state_13983__$1;
(statearr_14102_14215[(2)] = inst_13950);

(statearr_14102_14215[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (10))){
var inst_13766 = (state_13983[(58)]);
var inst_13783 = fluree.db.dbproto._subid.call(null,db,inst_13766);
var state_13983__$1 = state_13983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13983__$1,(13),inst_13783);
} else {
if((state_val_13984 === (18))){
var inst_13768 = (state_13983[(59)]);
var inst_13801 = fluree.db.dbproto._subid.call(null,db,inst_13768);
var state_13983__$1 = state_13983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13983__$1,(21),inst_13801);
} else {
if((state_val_13984 === (52))){
var inst_13789 = (state_13983[(29)]);
var inst_13825 = (state_13983[(35)]);
var inst_13851 = (state_13983[(40)]);
var inst_13780 = (state_13983[(41)]);
var inst_13816 = (state_13983[(43)]);
var inst_13865 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_13851,inst_13780,inst_13789,inst_13816,inst_13825);
var state_13983__$1 = state_13983;
var statearr_14103_14216 = state_13983__$1;
(statearr_14103_14216[(2)] = inst_13865);

(statearr_14103_14216[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (67))){
var inst_13952 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_14104_14217 = state_13983__$1;
(statearr_14104_14217[(2)] = inst_13952);

(statearr_14104_14217[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (71))){
var inst_13884 = (state_13983[(39)]);
var inst_13916 = (state_13983[(52)]);
var inst_13931 = cljs.core.into.call(null,inst_13916,inst_13884);
var state_13983__$1 = state_13983;
var statearr_14105_14218 = state_13983__$1;
(statearr_14105_14218[(2)] = inst_13931);

(statearr_14105_14218[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (42))){
var inst_13769 = (state_13983[(26)]);
var inst_13834 = (state_13983[(28)]);
var inst_13789 = (state_13983[(29)]);
var inst_13762 = (state_13983[(32)]);
var inst_13798 = (state_13983[(34)]);
var inst_13825 = (state_13983[(35)]);
var inst_13763 = (state_13983[(37)]);
var inst_13770 = (state_13983[(38)]);
var inst_13780 = (state_13983[(41)]);
var inst_13816 = (state_13983[(43)]);
var inst_13846 = (state_13983[(49)]);
var inst_13807 = (state_13983[(21)]);
var inst_13843 = (state_13983[(45)]);
var inst_13843__$1 = (state_13983[(2)]);
var inst_13844 = fluree.db.flake.__GT_Flake.call(null,inst_13780,inst_13816,inst_13798,inst_13762,inst_13763,inst_13834);
var inst_13845 = fluree.db.flake.__GT_Flake.call(null,inst_13789,inst_13825,inst_13807,inst_13769,inst_13770,inst_13843__$1);
var inst_13846__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_13983__$1 = (function (){var statearr_14106 = state_13983;
(statearr_14106[(15)] = inst_13844);

(statearr_14106[(16)] = inst_13845);

(statearr_14106[(49)] = inst_13846__$1);

(statearr_14106[(45)] = inst_13843__$1);

return statearr_14106;
})();
if(cljs.core.truth_(inst_13846__$1)){
var statearr_14107_14219 = state_13983__$1;
(statearr_14107_14219[(1)] = (46));

} else {
var statearr_14108_14220 = state_13983__$1;
(statearr_14108_14220[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (80))){
var inst_13944 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_14109_14221 = state_13983__$1;
(statearr_14109_14221[(2)] = inst_13944);

(statearr_14109_14221[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (37))){
var state_13983__$1 = state_13983;
var statearr_14110_14222 = state_13983__$1;
(statearr_14110_14222[(2)] = fluree.db.util.core.min_integer);

(statearr_14110_14222[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (63))){
var inst_13883 = (state_13983[(25)]);
var inst_13850 = (state_13983[(27)]);
var inst_13897 = (state_13983[(12)]);
var inst_13884 = (state_13983[(39)]);
var inst_13900 = (inst_13850 - inst_13883);
var inst_13901 = fluree.db.flake.take.call(null,inst_13900,inst_13897);
var inst_13902 = cljs.core.into.call(null,inst_13901,inst_13884);
var state_13983__$1 = state_13983;
var statearr_14111_14223 = state_13983__$1;
(statearr_14111_14223[(2)] = inst_13902);

(statearr_14111_14223[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (8))){
var inst_13766 = (state_13983[(58)]);
var inst_13780 = (state_13983[(2)]);
var inst_13781 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13766);
var state_13983__$1 = (function (){var statearr_14112 = state_13983;
(statearr_14112[(41)] = inst_13780);

return statearr_14112;
})();
if(inst_13781){
var statearr_14113_14224 = state_13983__$1;
(statearr_14113_14224[(1)] = (10));

} else {
var statearr_14114_14225 = state_13983__$1;
(statearr_14114_14225[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (49))){
var inst_13856 = (state_13983[(51)]);
var state_13983__$1 = state_13983;
var statearr_14115_14226 = state_13983__$1;
(statearr_14115_14226[(2)] = inst_13856);

(statearr_14115_14226[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (84))){
var inst_13850 = (state_13983[(27)]);
var inst_13955 = (state_13983[(9)]);
var inst_13960 = (inst_13955 < inst_13850);
var state_13983__$1 = state_13983;
var statearr_14116_14227 = state_13983__$1;
(statearr_14116_14227[(2)] = inst_13960);

(statearr_14116_14227[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2741__auto__ = null;
var fluree$db$query$range$state_machine__2741__auto____0 = (function (){
var statearr_14117 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14117[(0)] = fluree$db$query$range$state_machine__2741__auto__);

(statearr_14117[(1)] = (1));

return statearr_14117;
});
var fluree$db$query$range$state_machine__2741__auto____1 = (function (state_13983){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_13983);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e14118){var ex__2744__auto__ = e14118;
var statearr_14119_14228 = state_13983;
(statearr_14119_14228[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_13983[(4)]))){
var statearr_14120_14229 = state_13983;
(statearr_14120_14229[(1)] = cljs.core.first.call(null,(state_13983[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14230 = state_13983;
state_13983 = G__14230;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2741__auto__ = function(state_13983){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2741__auto____1.call(this,state_13983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2741__auto____0;
fluree$db$query$range$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2741__auto____1;
return fluree$db$query$range$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_14121 = f__2764__auto__.call(null);
(statearr_14121[(6)] = c__2763__auto__);

return statearr_14121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_14305){
var state_val_14306 = (state_14305[(1)]);
if((state_val_14306 === (7))){
var inst_14300 = (state_14305[(2)]);
var _ = (function (){var statearr_14307 = state_14305;
(statearr_14307[(4)] = cljs.core.rest.call(null,(state_14305[(4)])));

return statearr_14307;
})();
var state_14305__$1 = state_14305;
var statearr_14308_14348 = state_14305__$1;
(statearr_14308_14348[(2)] = inst_14300);

(statearr_14308_14348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (20))){
var inst_14282 = (state_14305[(2)]);
var inst_14283 = fluree.db.util.async.throw_err.call(null,inst_14282);
var state_14305__$1 = state_14305;
var statearr_14309_14349 = state_14305__$1;
(statearr_14309_14349[(2)] = inst_14283);

(statearr_14309_14349[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (1))){
var state_14305__$1 = state_14305;
var statearr_14310_14350 = state_14305__$1;
(statearr_14310_14350[(2)] = null);

(statearr_14310_14350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (4))){
var inst_14231 = (state_14305[(2)]);
var state_14305__$1 = state_14305;
var statearr_14311_14351 = state_14305__$1;
(statearr_14311_14351[(2)] = inst_14231);

(statearr_14311_14351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (15))){
var inst_14278 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14305__$1 = state_14305;
if(cljs.core.truth_(inst_14278)){
var statearr_14312_14352 = state_14305__$1;
(statearr_14312_14352[(1)] = (17));

} else {
var statearr_14313_14353 = state_14305__$1;
(statearr_14313_14353[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (21))){
var state_14305__$1 = state_14305;
var statearr_14314_14354 = state_14305__$1;
(statearr_14314_14354[(2)] = (0));

(statearr_14314_14354[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (13))){
var inst_14270 = (state_14305[(2)]);
var state_14305__$1 = state_14305;
var statearr_14315_14355 = state_14305__$1;
(statearr_14315_14355[(2)] = inst_14270);

(statearr_14315_14355[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (22))){
var state_14305__$1 = state_14305;
var statearr_14316_14356 = state_14305__$1;
(statearr_14316_14356[(2)] = (1));

(statearr_14316_14356[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (6))){
var inst_14260 = (state_14305[(7)]);
var inst_14251 = (state_14305[(8)]);
var inst_14262 = (state_14305[(9)]);
var inst_14259 = cljs.core.seq.call(null,inst_14251);
var inst_14260__$1 = cljs.core.first.call(null,inst_14259);
var inst_14261 = cljs.core.next.call(null,inst_14259);
var inst_14262__$1 = (inst_14260__$1 == null);
var state_14305__$1 = (function (){var statearr_14317 = state_14305;
(statearr_14317[(7)] = inst_14260__$1);

(statearr_14317[(9)] = inst_14262__$1);

(statearr_14317[(10)] = inst_14261);

return statearr_14317;
})();
if(cljs.core.truth_(inst_14262__$1)){
var statearr_14318_14357 = state_14305__$1;
(statearr_14318_14357[(1)] = (8));

} else {
var statearr_14319_14358 = state_14305__$1;
(statearr_14319_14358[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (17))){
var inst_14260 = (state_14305[(7)]);
var inst_14280 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,inst_14260);
var state_14305__$1 = state_14305;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14305__$1,(20),inst_14280);
} else {
if((state_val_14306 === (3))){
var inst_14303 = (state_14305[(2)]);
var state_14305__$1 = state_14305;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14305__$1,inst_14303);
} else {
if((state_val_14306 === (12))){
var inst_14253 = (state_14305[(11)]);
var inst_14268 = (inst_14253 >= subject_limit);
var state_14305__$1 = state_14305;
var statearr_14320_14359 = state_14305__$1;
(statearr_14320_14359[(2)] = inst_14268);

(statearr_14320_14359[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (2))){
var _ = (function (){var statearr_14321 = state_14305;
(statearr_14321[(4)] = cljs.core.cons.call(null,(5),(state_14305[(4)])));

return statearr_14321;
})();
var inst_14244 = subject_groups;
var inst_14245 = cljs.core.seq.call(null,inst_14244);
var inst_14246 = cljs.core.first.call(null,inst_14245);
var inst_14247 = cljs.core.next.call(null,inst_14245);
var inst_14248 = flake_start;
var inst_14249 = subject_start;
var inst_14250 = cljs.core.PersistentVector.EMPTY;
var inst_14251 = inst_14244;
var inst_14252 = inst_14248;
var inst_14253 = inst_14249;
var inst_14254 = inst_14250;
var state_14305__$1 = (function (){var statearr_14322 = state_14305;
(statearr_14322[(12)] = inst_14252);

(statearr_14322[(11)] = inst_14253);

(statearr_14322[(13)] = inst_14246);

(statearr_14322[(14)] = inst_14247);

(statearr_14322[(8)] = inst_14251);

(statearr_14322[(15)] = inst_14254);

return statearr_14322;
})();
var statearr_14323_14360 = state_14305__$1;
(statearr_14323_14360[(2)] = null);

(statearr_14323_14360[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (23))){
var inst_14252 = (state_14305[(12)]);
var inst_14253 = (state_14305[(11)]);
var inst_14287 = (state_14305[(16)]);
var inst_14286 = (state_14305[(17)]);
var inst_14254 = (state_14305[(15)]);
var inst_14261 = (state_14305[(10)]);
var inst_14292 = (state_14305[(2)]);
var inst_14293 = (inst_14252 + inst_14287);
var inst_14294 = (inst_14253 + inst_14292);
var inst_14295 = cljs.core.into.call(null,inst_14254,inst_14286);
var inst_14251 = inst_14261;
var inst_14252__$1 = inst_14293;
var inst_14253__$1 = inst_14294;
var inst_14254__$1 = inst_14295;
var state_14305__$1 = (function (){var statearr_14324 = state_14305;
(statearr_14324[(12)] = inst_14252__$1);

(statearr_14324[(11)] = inst_14253__$1);

(statearr_14324[(8)] = inst_14251);

(statearr_14324[(15)] = inst_14254__$1);

return statearr_14324;
})();
var statearr_14325_14361 = state_14305__$1;
(statearr_14325_14361[(2)] = null);

(statearr_14325_14361[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (19))){
var inst_14287 = (state_14305[(16)]);
var inst_14286 = (state_14305[(17)]);
var inst_14286__$1 = (state_14305[(2)]);
var inst_14287__$1 = cljs.core.count.call(null,inst_14286__$1);
var inst_14288 = cljs.core._EQ_.call(null,(0),inst_14287__$1);
var state_14305__$1 = (function (){var statearr_14326 = state_14305;
(statearr_14326[(16)] = inst_14287__$1);

(statearr_14326[(17)] = inst_14286__$1);

return statearr_14326;
})();
if(inst_14288){
var statearr_14327_14362 = state_14305__$1;
(statearr_14327_14362[(1)] = (21));

} else {
var statearr_14328_14363 = state_14305__$1;
(statearr_14328_14363[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (11))){
var inst_14265 = (state_14305[(18)]);
var state_14305__$1 = state_14305;
var statearr_14330_14364 = state_14305__$1;
(statearr_14330_14364[(2)] = inst_14265);

(statearr_14330_14364[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (9))){
var inst_14252 = (state_14305[(12)]);
var inst_14265 = (state_14305[(18)]);
var inst_14265__$1 = (inst_14252 >= flake_limit);
var state_14305__$1 = (function (){var statearr_14331 = state_14305;
(statearr_14331[(18)] = inst_14265__$1);

return statearr_14331;
})();
if(cljs.core.truth_(inst_14265__$1)){
var statearr_14332_14365 = state_14305__$1;
(statearr_14332_14365[(1)] = (11));

} else {
var statearr_14333_14366 = state_14305__$1;
(statearr_14333_14366[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (5))){
var _ = (function (){var statearr_14334 = state_14305;
(statearr_14334[(4)] = cljs.core.rest.call(null,(state_14305[(4)])));

return statearr_14334;
})();
var state_14305__$1 = state_14305;
var ex14329 = (state_14305__$1[(2)]);
var statearr_14335_14367 = state_14305__$1;
(statearr_14335_14367[(5)] = ex14329);


if((ex14329 instanceof Error)){
var statearr_14336_14368 = state_14305__$1;
(statearr_14336_14368[(1)] = (4));

(statearr_14336_14368[(5)] = null);

} else {
throw ex14329;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (14))){
var inst_14252 = (state_14305[(12)]);
var inst_14253 = (state_14305[(11)]);
var inst_14254 = (state_14305[(15)]);
var inst_14274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14275 = [inst_14252,inst_14253,inst_14254];
var inst_14276 = (new cljs.core.PersistentVector(null,3,(5),inst_14274,inst_14275,null));
var state_14305__$1 = state_14305;
var statearr_14337_14369 = state_14305__$1;
(statearr_14337_14369[(2)] = inst_14276);

(statearr_14337_14369[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (16))){
var inst_14298 = (state_14305[(2)]);
var state_14305__$1 = state_14305;
var statearr_14338_14370 = state_14305__$1;
(statearr_14338_14370[(2)] = inst_14298);

(statearr_14338_14370[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (10))){
var inst_14272 = (state_14305[(2)]);
var state_14305__$1 = state_14305;
if(cljs.core.truth_(inst_14272)){
var statearr_14339_14371 = state_14305__$1;
(statearr_14339_14371[(1)] = (14));

} else {
var statearr_14340_14372 = state_14305__$1;
(statearr_14340_14372[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (18))){
var inst_14260 = (state_14305[(7)]);
var state_14305__$1 = state_14305;
var statearr_14341_14373 = state_14305__$1;
(statearr_14341_14373[(2)] = inst_14260);

(statearr_14341_14373[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (8))){
var inst_14262 = (state_14305[(9)]);
var state_14305__$1 = state_14305;
var statearr_14342_14374 = state_14305__$1;
(statearr_14342_14374[(2)] = inst_14262);

(statearr_14342_14374[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2741__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2741__auto____0 = (function (){
var statearr_14343 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14343[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2741__auto__);

(statearr_14343[(1)] = (1));

return statearr_14343;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2741__auto____1 = (function (state_14305){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_14305);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e14344){var ex__2744__auto__ = e14344;
var statearr_14345_14375 = state_14305;
(statearr_14345_14375[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_14305[(4)]))){
var statearr_14346_14376 = state_14305;
(statearr_14346_14376[(1)] = cljs.core.first.call(null,(state_14305[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14377 = state_14305;
state_14305 = G__14377;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2741__auto__ = function(state_14305){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2741__auto____1.call(this,state_14305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2741__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2741__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_14347 = f__2764__auto__.call(null);
(statearr_14347[(6)] = c__2763__auto__);

return statearr_14347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_14423){
var state_val_14424 = (state_14423[(1)]);
if((state_val_14424 === (7))){
var state_14423__$1 = state_14423;
var statearr_14425_14463 = state_14423__$1;
(statearr_14425_14463[(2)] = null);

(statearr_14425_14463[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (20))){
var inst_14409 = (state_14423[(2)]);
var inst_14410 = fluree.db.util.async.throw_err.call(null,inst_14409);
var inst_14388 = inst_14410;
var state_14423__$1 = (function (){var statearr_14426 = state_14423;
(statearr_14426[(7)] = inst_14388);

return statearr_14426;
})();
var statearr_14427_14464 = state_14423__$1;
(statearr_14427_14464[(2)] = null);

(statearr_14427_14464[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (1))){
var state_14423__$1 = state_14423;
var statearr_14428_14465 = state_14423__$1;
(statearr_14428_14465[(2)] = null);

(statearr_14428_14465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (4))){
var inst_14378 = (state_14423[(2)]);
var state_14423__$1 = state_14423;
var statearr_14429_14466 = state_14423__$1;
(statearr_14429_14466[(2)] = inst_14378);

(statearr_14429_14466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (15))){
var inst_14388 = (state_14423[(7)]);
var inst_14405 = (state_14423[(8)]);
var inst_14405__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_14388);
var state_14423__$1 = (function (){var statearr_14430 = state_14423;
(statearr_14430[(8)] = inst_14405__$1);

return statearr_14430;
})();
if(cljs.core.truth_(inst_14405__$1)){
var statearr_14431_14467 = state_14423__$1;
(statearr_14431_14467[(1)] = (17));

} else {
var statearr_14432_14468 = state_14423__$1;
(statearr_14432_14468[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (13))){
var inst_14398 = (state_14423[(2)]);
var inst_14399 = fluree.db.util.async.throw_err.call(null,inst_14398);
var _ = (function (){var statearr_14433 = state_14423;
(statearr_14433[(4)] = cljs.core.rest.call(null,(state_14423[(4)])));

return statearr_14433;
})();
var state_14423__$1 = state_14423;
var statearr_14434_14469 = state_14423__$1;
(statearr_14434_14469[(2)] = inst_14399);

(statearr_14434_14469[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (6))){
var inst_14386 = (state_14423[(2)]);
var inst_14387 = fluree.db.util.async.throw_err.call(null,inst_14386);
var inst_14388 = inst_14387;
var state_14423__$1 = (function (){var statearr_14435 = state_14423;
(statearr_14435[(7)] = inst_14388);

return statearr_14435;
})();
var statearr_14436_14470 = state_14423__$1;
(statearr_14436_14470[(2)] = null);

(statearr_14436_14470[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (17))){
var inst_14405 = (state_14423[(8)]);
var inst_14407 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_14405);
var state_14423__$1 = state_14423;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14423__$1,(20),inst_14407);
} else {
if((state_val_14424 === (3))){
var inst_14421 = (state_14423[(2)]);
var state_14423__$1 = state_14423;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14423__$1,inst_14421);
} else {
if((state_val_14424 === (12))){
var _ = (function (){var statearr_14438 = state_14423;
(statearr_14438[(4)] = cljs.core.rest.call(null,(state_14423[(4)])));

return statearr_14438;
})();
var state_14423__$1 = state_14423;
var ex14437 = (state_14423__$1[(2)]);
var statearr_14439_14471 = state_14423__$1;
(statearr_14439_14471[(5)] = ex14437);


var statearr_14440_14472 = state_14423__$1;
(statearr_14440_14472[(1)] = (11));

(statearr_14440_14472[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (2))){
var _ = (function (){var statearr_14441 = state_14423;
(statearr_14441[(4)] = cljs.core.cons.call(null,(5),(state_14423[(4)])));

return statearr_14441;
})();
var inst_14384 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_14423__$1 = state_14423;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14423__$1,(6),inst_14384);
} else {
if((state_val_14424 === (19))){
var inst_14414 = (state_14423[(2)]);
var state_14423__$1 = state_14423;
var statearr_14442_14473 = state_14423__$1;
(statearr_14442_14473[(2)] = inst_14414);

(statearr_14442_14473[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (11))){
var inst_14390 = (state_14423[(2)]);
var state_14423__$1 = (function (){var statearr_14444 = state_14423;
(statearr_14444[(9)] = inst_14390);

return statearr_14444;
})();
var statearr_14445_14474 = state_14423__$1;
(statearr_14445_14474[(2)] = null);

(statearr_14445_14474[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (9))){
var inst_14388 = (state_14423[(7)]);
var _ = (function (){var statearr_14446 = state_14423;
(statearr_14446[(4)] = cljs.core.cons.call(null,(12),(state_14423[(4)])));

return statearr_14446;
})();
var inst_14396 = fluree.db.dbproto._resolve_to_t.call(null,inst_14388,t,novelty,fast_forward_db_QMARK_);
var state_14423__$1 = state_14423;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14423__$1,(13),inst_14396);
} else {
if((state_val_14424 === (5))){
var _ = (function (){var statearr_14447 = state_14423;
(statearr_14447[(4)] = cljs.core.rest.call(null,(state_14423[(4)])));

return statearr_14447;
})();
var state_14423__$1 = state_14423;
var ex14443 = (state_14423__$1[(2)]);
var statearr_14448_14475 = state_14423__$1;
(statearr_14448_14475[(5)] = ex14443);


if((ex14443 instanceof Error)){
var statearr_14449_14476 = state_14423__$1;
(statearr_14449_14476[(1)] = (4));

(statearr_14449_14476[(5)] = null);

} else {
throw ex14443;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (14))){
var inst_14402 = (state_14423[(10)]);
var state_14423__$1 = state_14423;
var statearr_14450_14477 = state_14423__$1;
(statearr_14450_14477[(2)] = inst_14402);

(statearr_14450_14477[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (16))){
var inst_14416 = (state_14423[(2)]);
var state_14423__$1 = state_14423;
var statearr_14451_14478 = state_14423__$1;
(statearr_14451_14478[(2)] = inst_14416);

(statearr_14451_14478[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (10))){
var inst_14402 = (state_14423[(10)]);
var inst_14402__$1 = (state_14423[(2)]);
var state_14423__$1 = (function (){var statearr_14452 = state_14423;
(statearr_14452[(10)] = inst_14402__$1);

return statearr_14452;
})();
if(cljs.core.truth_(inst_14402__$1)){
var statearr_14453_14479 = state_14423__$1;
(statearr_14453_14479[(1)] = (14));

} else {
var statearr_14454_14480 = state_14423__$1;
(statearr_14454_14480[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (18))){
var state_14423__$1 = state_14423;
var statearr_14455_14481 = state_14423__$1;
(statearr_14455_14481[(2)] = null);

(statearr_14455_14481[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (8))){
var inst_14418 = (state_14423[(2)]);
var _ = (function (){var statearr_14456 = state_14423;
(statearr_14456[(4)] = cljs.core.rest.call(null,(state_14423[(4)])));

return statearr_14456;
})();
var state_14423__$1 = state_14423;
var statearr_14457_14482 = state_14423__$1;
(statearr_14457_14482[(2)] = inst_14418);

(statearr_14457_14482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2741__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2741__auto____0 = (function (){
var statearr_14458 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14458[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2741__auto__);

(statearr_14458[(1)] = (1));

return statearr_14458;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2741__auto____1 = (function (state_14423){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_14423);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e14459){var ex__2744__auto__ = e14459;
var statearr_14460_14483 = state_14423;
(statearr_14460_14483[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_14423[(4)]))){
var statearr_14461_14484 = state_14423;
(statearr_14461_14484[(1)] = cljs.core.first.call(null,(state_14423[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14485 = state_14423;
state_14423 = G__14485;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2741__auto__ = function(state_14423){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2741__auto____1.call(this,state_14423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2741__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2741__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_14462 = f__2764__auto__.call(null);
(statearr_14462[(6)] = c__2763__auto__);

return statearr_14462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14492 = arguments.length;
switch (G__14492) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14493 = (function (){var pred__14496 = cljs.core.identical_QMARK_;
var expr__14497 = test;
if(cljs.core.truth_(pred__14496.call(null,cljs.core._EQ_,expr__14497))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14496.call(null,cljs.core._LT_,expr__14497))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__14496.call(null,cljs.core._LT__EQ_,expr__14497))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14496.call(null,cljs.core._GT_,expr__14497))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__14496.call(null,cljs.core._GT__EQ_,expr__14497))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14497)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__14493,(0),null);
var start_match = cljs.core.nth.call(null,vec__14493,(1),null);
var end_test = cljs.core.nth.call(null,vec__14493,(2),null);
var end_match = cljs.core.nth.call(null,vec__14493,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_14869){
var state_val_14870 = (state_14869[(1)]);
if((state_val_14870 === (121))){
var inst_14825 = (state_14869[(7)]);
var state_14869__$1 = state_14869;
var statearr_14871_15064 = state_14869__$1;
(statearr_14871_15064[(2)] = inst_14825);

(statearr_14871_15064[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (65))){
var inst_14677 = (state_14869[(8)]);
var inst_14683 = (state_14869[(2)]);
var state_14869__$1 = (function (){var statearr_14872 = state_14869;
(statearr_14872[(9)] = inst_14683);

return statearr_14872;
})();
if(cljs.core.truth_(inst_14677)){
var statearr_14873_15065 = state_14869__$1;
(statearr_14873_15065[(1)] = (66));

} else {
var statearr_14874_15066 = state_14869__$1;
(statearr_14874_15066[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (70))){
var inst_14861 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
var statearr_14875_15067 = state_14869__$1;
(statearr_14875_15067[(2)] = inst_14861);

(statearr_14875_15067[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (62))){
var inst_14676 = (state_14869[(2)]);
var inst_14677 = fluree.db.util.async.throw_err.call(null,inst_14676);
var inst_14678 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14869__$1 = (function (){var statearr_14876 = state_14869;
(statearr_14876[(8)] = inst_14677);

return statearr_14876;
})();
if(cljs.core.truth_(inst_14678)){
var statearr_14877_15068 = state_14869__$1;
(statearr_14877_15068[(1)] = (63));

} else {
var statearr_14878_15069 = state_14869__$1;
(statearr_14878_15069[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (74))){
var inst_14668 = (state_14869[(10)]);
var inst_14662 = (state_14869[(11)]);
var inst_14627 = (state_14869[(12)]);
var inst_14636 = (state_14869[(13)]);
var inst_14688 = (state_14869[(14)]);
var inst_14588 = (state_14869[(15)]);
var inst_14650 = (state_14869[(16)]);
var inst_14696 = (state_14869[(17)]);
var inst_14618 = (state_14869[(18)]);
var inst_14587 = (state_14869[(19)]);
var inst_14656 = (state_14869[(20)]);
var inst_14524 = (state_14869[(21)]);
var inst_14646 = (state_14869[(22)]);
var inst_14667 = (state_14869[(23)]);
var inst_14683 = (state_14869[(9)]);
var inst_14526 = (state_14869[(24)]);
var inst_14658 = (state_14869[(25)]);
var inst_14647 = (state_14869[(26)]);
var inst_14519 = (state_14869[(27)]);
var inst_14531 = (state_14869[(28)]);
var inst_14535 = (state_14869[(29)]);
var inst_14645 = (state_14869[(30)]);
var inst_14649 = (state_14869[(31)]);
var inst_14677 = (state_14869[(8)]);
var inst_14609 = (state_14869[(32)]);
var inst_14687 = (state_14869[(33)]);
var inst_14600 = (state_14869[(34)]);
var inst_14523 = (state_14869[(35)]);
var inst_14663 = (state_14869[(36)]);
var inst_14689 = (state_14869[(37)]);
var inst_14686 = (state_14869[(38)]);
var inst_14657 = (state_14869[(39)]);
var inst_14704 = (state_14869[(40)]);
var inst_14555 = (state_14869[(41)]);
var inst_14546 = (state_14869[(42)]);
var inst_14690 = (state_14869[(43)]);
var inst_14536 = (state_14869[(44)]);
var inst_14530 = (state_14869[(45)]);
var inst_14591 = (state_14869[(46)]);
var inst_14534 = (state_14869[(47)]);
var inst_14673 = (state_14869[(48)]);
var inst_14706 = (function (){var no_filter_QMARK_ = inst_14683;
var t = inst_14663;
var max_limit_QMARK_ = inst_14657;
var next_node = inst_14686;
var fast_forward_db_QMARK_ = inst_14668;
var s1 = inst_14546;
var o2 = inst_14609;
var t1 = inst_14523;
var predicate_fn = inst_14536;
var i = inst_14688;
var m1 = inst_14636;
var map__14518 = inst_14649;
var root_node = inst_14673;
var G__14697 = inst_14704;
var s2 = inst_14555;
var vec__14515 = inst_14588;
var map__14511 = inst_14534;
var vec__14508 = inst_14526;
var p2 = inst_14627;
var permissions = inst_14658;
var limit = inst_14656;
var start_flake = inst_14646;
var flake_limit = inst_14650;
var offset = inst_14687;
var acc = inst_14690;
var t2 = inst_14530;
var vec__14512 = inst_14587;
var op1 = inst_14524;
var o1 = inst_14600;
var end_flake = inst_14647;
var base_result = inst_14696;
var s = inst_14689;
var node_start = inst_14677;
var p1 = inst_14618;
var subject_fn = inst_14535;
var object_fn = inst_14591;
var idx_compare = inst_14662;
var op2 = inst_14531;
var m2 = inst_14645;
var vec__14505 = inst_14519;
var novelty = inst_14667;
return (function (p1__14487_SHARP_){
return subject_fn.call(null,p1__14487_SHARP_.s);
});
})();
var inst_14707 = cljs.core.filter.call(null,inst_14706,inst_14704);
var state_14869__$1 = state_14869;
var statearr_14879_15070 = state_14869__$1;
(statearr_14879_15070[(2)] = inst_14707);

(statearr_14879_15070[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (110))){
var inst_14838 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
var statearr_14880_15071 = state_14869__$1;
(statearr_14880_15071[(2)] = inst_14838);

(statearr_14880_15071[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (7))){
var inst_14520 = (state_14869[(49)]);
var state_14869__$1 = state_14869;
var statearr_14881_15072 = state_14869__$1;
(statearr_14881_15072[(2)] = inst_14520);

(statearr_14881_15072[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (59))){
var state_14869__$1 = state_14869;
var statearr_14882_15073 = state_14869__$1;
(statearr_14882_15073[(2)] = fluree.db.util.core.max_long);

(statearr_14882_15073[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (86))){
var inst_14683 = (state_14869[(9)]);
var state_14869__$1 = state_14869;
var statearr_14883_15074 = state_14869__$1;
(statearr_14883_15074[(2)] = inst_14683);

(statearr_14883_15074[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (20))){
var state_14869__$1 = state_14869;
var statearr_14884_15075 = state_14869__$1;
(statearr_14884_15075[(2)] = null);

(statearr_14884_15075[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (72))){
var inst_14696 = (state_14869[(17)]);
var state_14869__$1 = state_14869;
var statearr_14885_15076 = state_14869__$1;
(statearr_14885_15076[(2)] = inst_14696);

(statearr_14885_15076[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (58))){
var inst_14651 = (state_14869[(50)]);
var state_14869__$1 = state_14869;
var statearr_14886_15077 = state_14869__$1;
(statearr_14886_15077[(2)] = inst_14651);

(statearr_14886_15077[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (60))){
var inst_14656 = (state_14869[(20)]);
var inst_14656__$1 = (state_14869[(2)]);
var inst_14657 = cljs.core._EQ_.call(null,inst_14656__$1,fluree.db.util.core.max_long);
var inst_14658 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14660 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14661 = (new cljs.core.PersistentVector(null,3,(5),inst_14659,inst_14660,null));
var inst_14662 = cljs.core.get_in.call(null,db,inst_14661);
var inst_14663 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_14664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14665 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14666 = (new cljs.core.PersistentVector(null,2,(5),inst_14664,inst_14665,null));
var inst_14667 = cljs.core.get_in.call(null,db,inst_14666);
var inst_14668 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_14669 = cljs.core.get.call(null,db,idx);
var inst_14670 = fluree.db.dbproto._resolve.call(null,inst_14669);
var state_14869__$1 = (function (){var statearr_14887 = state_14869;
(statearr_14887[(10)] = inst_14668);

(statearr_14887[(11)] = inst_14662);

(statearr_14887[(20)] = inst_14656__$1);

(statearr_14887[(23)] = inst_14667);

(statearr_14887[(25)] = inst_14658);

(statearr_14887[(36)] = inst_14663);

(statearr_14887[(39)] = inst_14657);

return statearr_14887;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14869__$1,(61),inst_14670);
} else {
if((state_val_14870 === (27))){
var inst_14589 = (state_14869[(51)]);
var state_14869__$1 = state_14869;
var statearr_14888_15078 = state_14869__$1;
(statearr_14888_15078[(2)] = inst_14589);

(statearr_14888_15078[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (1))){
var state_14869__$1 = state_14869;
var statearr_14889_15079 = state_14869__$1;
(statearr_14889_15079[(2)] = null);

(statearr_14889_15079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (69))){
var inst_14646 = (state_14869[(22)]);
var inst_14647 = (state_14869[(26)]);
var inst_14686 = (state_14869[(38)]);
var inst_14695 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_14686);
var inst_14696 = fluree.db.flake.subrange.call(null,inst_14695,start_test,inst_14646,end_test,inst_14647);
var inst_14698 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_14646,inst_14647);
var state_14869__$1 = (function (){var statearr_14890 = state_14869;
(statearr_14890[(17)] = inst_14696);

return statearr_14890;
})();
if(inst_14698){
var statearr_14891_15080 = state_14869__$1;
(statearr_14891_15080[(1)] = (71));

} else {
var statearr_14892_15081 = state_14869__$1;
(statearr_14892_15081[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (101))){
var inst_14783 = (state_14869[(52)]);
var inst_14650 = (state_14869[(16)]);
var inst_14782 = (state_14869[(53)]);
var inst_14784 = (state_14869[(54)]);
var inst_14787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14788 = (inst_14784 - inst_14650);
var inst_14789 = (inst_14783 - inst_14788);
var inst_14790 = cljs.core.take.call(null,inst_14789,inst_14782);
var inst_14791 = [inst_14650,inst_14790];
var inst_14792 = (new cljs.core.PersistentVector(null,2,(5),inst_14787,inst_14791,null));
var state_14869__$1 = state_14869;
var statearr_14893_15082 = state_14869__$1;
(statearr_14893_15082[(2)] = inst_14792);

(statearr_14893_15082[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (24))){
var inst_14529 = (state_14869[(55)]);
var inst_14525 = (state_14869[(56)]);
var inst_14532 = (state_14869[(57)]);
var inst_14524 = (state_14869[(21)]);
var inst_14528 = (state_14869[(58)]);
var inst_14522 = (state_14869[(59)]);
var inst_14526 = (state_14869[(24)]);
var inst_14519 = (state_14869[(27)]);
var inst_14531 = (state_14869[(28)]);
var inst_14535 = (state_14869[(29)]);
var inst_14523 = (state_14869[(35)]);
var inst_14521 = (state_14869[(60)]);
var inst_14537 = (state_14869[(61)]);
var inst_14555 = (state_14869[(41)]);
var inst_14546 = (state_14869[(42)]);
var inst_14536 = (state_14869[(44)]);
var inst_14530 = (state_14869[(45)]);
var inst_14534 = (state_14869[(47)]);
var inst_14569 = (state_14869[(62)]);
var inst_14579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14581 = [null,null];
var inst_14582 = (new cljs.core.PersistentVector(null,2,(5),inst_14580,inst_14581,null));
var inst_14583 = (function (){var bool = inst_14569;
var s1 = inst_14546;
var o2 = inst_14529;
var t1 = inst_14523;
var predicate_fn = inst_14536;
var m1 = inst_14525;
var s2 = inst_14555;
var map__14511 = inst_14534;
var vec__14508 = inst_14526;
var p2 = inst_14528;
var t2 = inst_14530;
var op1 = inst_14524;
var o1 = inst_14522;
var p1 = inst_14521;
var subject_fn = inst_14535;
var object_fn = inst_14537;
var op2 = inst_14531;
var m2 = inst_14532;
var temp__5755__auto__ = inst_14569;
var vec__14505 = inst_14519;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_14584 = [inst_14582,inst_14583];
var inst_14585 = (new cljs.core.PersistentVector(null,2,(5),inst_14579,inst_14584,null));
var state_14869__$1 = state_14869;
var statearr_14894_15083 = state_14869__$1;
(statearr_14894_15083[(2)] = inst_14585);

(statearr_14894_15083[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (102))){
var inst_14782 = (state_14869[(53)]);
var inst_14784 = (state_14869[(54)]);
var inst_14794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14795 = [inst_14784,inst_14782];
var inst_14796 = (new cljs.core.PersistentVector(null,2,(5),inst_14794,inst_14795,null));
var state_14869__$1 = state_14869;
var statearr_14895_15084 = state_14869__$1;
(statearr_14895_15084[(2)] = inst_14796);

(statearr_14895_15084[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (55))){
var state_14869__$1 = state_14869;
var statearr_14896_15085 = state_14869__$1;
(statearr_14896_15085[(2)] = (2147483647));

(statearr_14896_15085[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (85))){
var inst_14732 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
if(cljs.core.truth_(inst_14732)){
var statearr_14897_15086 = state_14869__$1;
(statearr_14897_15086[(1)] = (89));

} else {
var statearr_14898_15087 = state_14869__$1;
(statearr_14898_15087[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (39))){
var inst_14619 = (state_14869[(63)]);
var inst_14528 = (state_14869[(58)]);
var inst_14618 = (state_14869[(2)]);
var inst_14619__$1 = (inst_14528 == null);
var state_14869__$1 = (function (){var statearr_14899 = state_14869;
(statearr_14899[(18)] = inst_14618);

(statearr_14899[(63)] = inst_14619__$1);

return statearr_14899;
})();
if(cljs.core.truth_(inst_14619__$1)){
var statearr_14900_15088 = state_14869__$1;
(statearr_14900_15088[(1)] = (40));

} else {
var statearr_14901_15089 = state_14869__$1;
(statearr_14901_15089[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (88))){
var inst_14729 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
var statearr_14902_15090 = state_14869__$1;
(statearr_14902_15090[(2)] = inst_14729);

(statearr_14902_15090[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (46))){
var inst_14525 = (state_14869[(56)]);
var state_14869__$1 = state_14869;
var statearr_14903_15091 = state_14869__$1;
(statearr_14903_15091[(2)] = inst_14525);

(statearr_14903_15091[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (4))){
var inst_14499 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
var statearr_14904_15092 = state_14869__$1;
(statearr_14904_15092[(2)] = inst_14499);

(statearr_14904_15092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (77))){
var inst_14668 = (state_14869[(10)]);
var inst_14662 = (state_14869[(11)]);
var inst_14627 = (state_14869[(12)]);
var inst_14636 = (state_14869[(13)]);
var inst_14688 = (state_14869[(14)]);
var inst_14588 = (state_14869[(15)]);
var inst_14650 = (state_14869[(16)]);
var inst_14696 = (state_14869[(17)]);
var inst_14618 = (state_14869[(18)]);
var inst_14587 = (state_14869[(19)]);
var inst_14656 = (state_14869[(20)]);
var inst_14524 = (state_14869[(21)]);
var inst_14646 = (state_14869[(22)]);
var inst_14667 = (state_14869[(23)]);
var inst_14683 = (state_14869[(9)]);
var inst_14526 = (state_14869[(24)]);
var inst_14658 = (state_14869[(25)]);
var inst_14647 = (state_14869[(26)]);
var inst_14519 = (state_14869[(27)]);
var inst_14531 = (state_14869[(28)]);
var inst_14535 = (state_14869[(29)]);
var inst_14645 = (state_14869[(30)]);
var inst_14649 = (state_14869[(31)]);
var inst_14677 = (state_14869[(8)]);
var inst_14609 = (state_14869[(32)]);
var inst_14687 = (state_14869[(33)]);
var inst_14600 = (state_14869[(34)]);
var inst_14523 = (state_14869[(35)]);
var inst_14663 = (state_14869[(36)]);
var inst_14689 = (state_14869[(37)]);
var inst_14686 = (state_14869[(38)]);
var inst_14657 = (state_14869[(39)]);
var inst_14555 = (state_14869[(41)]);
var inst_14546 = (state_14869[(42)]);
var inst_14690 = (state_14869[(43)]);
var inst_14536 = (state_14869[(44)]);
var inst_14530 = (state_14869[(45)]);
var inst_14710 = (state_14869[(64)]);
var inst_14591 = (state_14869[(46)]);
var inst_14534 = (state_14869[(47)]);
var inst_14673 = (state_14869[(48)]);
var inst_14712 = (function (){var no_filter_QMARK_ = inst_14683;
var t = inst_14663;
var max_limit_QMARK_ = inst_14657;
var next_node = inst_14686;
var fast_forward_db_QMARK_ = inst_14668;
var s1 = inst_14546;
var o2 = inst_14609;
var t1 = inst_14523;
var predicate_fn = inst_14536;
var i = inst_14688;
var m1 = inst_14636;
var map__14518 = inst_14649;
var root_node = inst_14673;
var G__14697 = inst_14710;
var s2 = inst_14555;
var vec__14515 = inst_14588;
var map__14511 = inst_14534;
var vec__14508 = inst_14526;
var p2 = inst_14627;
var permissions = inst_14658;
var limit = inst_14656;
var start_flake = inst_14646;
var flake_limit = inst_14650;
var offset = inst_14687;
var acc = inst_14690;
var t2 = inst_14530;
var vec__14512 = inst_14587;
var op1 = inst_14524;
var o1 = inst_14600;
var end_flake = inst_14647;
var base_result = inst_14696;
var s = inst_14689;
var node_start = inst_14677;
var p1 = inst_14618;
var subject_fn = inst_14535;
var object_fn = inst_14591;
var idx_compare = inst_14662;
var op2 = inst_14531;
var m2 = inst_14645;
var vec__14505 = inst_14519;
var novelty = inst_14667;
return (function (p1__14488_SHARP_){
return predicate_fn.call(null,p1__14488_SHARP_.p);
});
})();
var inst_14713 = cljs.core.filter.call(null,inst_14712,inst_14710);
var state_14869__$1 = state_14869;
var statearr_14905_15093 = state_14869__$1;
(statearr_14905_15093[(2)] = inst_14713);

(statearr_14905_15093[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (106))){
var inst_14723 = (state_14869[(65)]);
var state_14869__$1 = state_14869;
var statearr_14906_15094 = state_14869__$1;
(statearr_14906_15094[(2)] = inst_14723);

(statearr_14906_15094[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (119))){
var inst_14841 = (state_14869[(66)]);
var state_14869__$1 = state_14869;
var statearr_14907_15095 = state_14869__$1;
(statearr_14907_15095[(2)] = inst_14841);

(statearr_14907_15095[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (95))){
var inst_14656 = (state_14869[(20)]);
var inst_14765 = (state_14869[(67)]);
var inst_14756 = (state_14869[(68)]);
var inst_14689 = (state_14869[(37)]);
var inst_14764 = (state_14869[(69)]);
var inst_14766 = (state_14869[(70)]);
var inst_14764__$1 = cljs.core.count.call(null,inst_14756);
var inst_14765__$1 = (inst_14689 + inst_14764__$1);
var inst_14766__$1 = (inst_14765__$1 - inst_14656);
var inst_14767 = cljs.core.pos_int_QMARK_.call(null,inst_14766__$1);
var state_14869__$1 = (function (){var statearr_14908 = state_14869;
(statearr_14908[(67)] = inst_14765__$1);

(statearr_14908[(69)] = inst_14764__$1);

(statearr_14908[(70)] = inst_14766__$1);

return statearr_14908;
})();
if(inst_14767){
var statearr_14909_15096 = state_14869__$1;
(statearr_14909_15096[(1)] = (98));

} else {
var statearr_14910_15097 = state_14869__$1;
(statearr_14910_15097[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (54))){
var inst_14627 = (state_14869[(12)]);
var inst_14636 = (state_14869[(13)]);
var inst_14618 = (state_14869[(18)]);
var inst_14524 = (state_14869[(21)]);
var inst_14531 = (state_14869[(28)]);
var inst_14645 = (state_14869[(30)]);
var inst_14649 = (state_14869[(31)]);
var inst_14609 = (state_14869[(32)]);
var inst_14600 = (state_14869[(34)]);
var inst_14523 = (state_14869[(35)]);
var inst_14555 = (state_14869[(41)]);
var inst_14546 = (state_14869[(42)]);
var inst_14530 = (state_14869[(45)]);
var inst_14651 = (state_14869[(50)]);
var inst_14645__$1 = (state_14869[(2)]);
var inst_14646 = fluree.db.flake.__GT_Flake.call(null,inst_14546,inst_14618,inst_14600,inst_14523,inst_14524,inst_14636);
var inst_14647 = fluree.db.flake.__GT_Flake.call(null,inst_14555,inst_14627,inst_14609,inst_14530,inst_14531,inst_14645__$1);
var inst_14648 = opts;
var inst_14649__$1 = cljs.core.__destructure_map.call(null,inst_14648);
var inst_14650 = cljs.core.get.call(null,inst_14649__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_14651__$1 = cljs.core.get.call(null,inst_14649__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_14652 = cljs.core.get.call(null,inst_14649__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_14869__$1 = (function (){var statearr_14911 = state_14869;
(statearr_14911[(16)] = inst_14650);

(statearr_14911[(22)] = inst_14646);

(statearr_14911[(26)] = inst_14647);

(statearr_14911[(30)] = inst_14645__$1);

(statearr_14911[(31)] = inst_14649__$1);

(statearr_14911[(71)] = inst_14652);

(statearr_14911[(50)] = inst_14651__$1);

return statearr_14911;
})();
if(cljs.core.truth_(inst_14651__$1)){
var statearr_14912_15098 = state_14869__$1;
(statearr_14912_15098[(1)] = (58));

} else {
var statearr_14913_15099 = state_14869__$1;
(statearr_14913_15099[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (92))){
var inst_14688 = (state_14869[(14)]);
var inst_14745 = (state_14869[(72)]);
var inst_14687 = (state_14869[(33)]);
var inst_14689 = (state_14869[(37)]);
var inst_14690 = (state_14869[(43)]);
var inst_14748 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14749 = (inst_14687 - inst_14745);
var inst_14750 = [inst_14749,inst_14688,inst_14689,inst_14690];
var inst_14751 = (new cljs.core.PersistentVector(null,4,(5),inst_14748,inst_14750,null));
var state_14869__$1 = state_14869;
var statearr_14914_15100 = state_14869__$1;
(statearr_14914_15100[(2)] = inst_14751);

(statearr_14914_15100[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (104))){
var inst_14807 = (state_14869[(2)]);
var inst_14808 = fluree.db.util.async.throw_err.call(null,inst_14807);
var state_14869__$1 = state_14869;
var statearr_14915_15101 = state_14869__$1;
(statearr_14915_15101[(2)] = inst_14808);

(statearr_14915_15101[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (15))){
var inst_14529 = (state_14869[(55)]);
var inst_14559 = cljs.core.boolean_QMARK_.call(null,inst_14529);
var state_14869__$1 = state_14869;
if(inst_14559){
var statearr_14916_15102 = state_14869__$1;
(statearr_14916_15102[(1)] = (17));

} else {
var statearr_14917_15103 = state_14869__$1;
(statearr_14917_15103[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (48))){
var inst_14532 = (state_14869[(57)]);
var inst_14636 = (state_14869[(2)]);
var state_14869__$1 = (function (){var statearr_14918 = state_14869;
(statearr_14918[(13)] = inst_14636);

return statearr_14918;
})();
if(cljs.core.truth_(inst_14532)){
var statearr_14919_15104 = state_14869__$1;
(statearr_14919_15104[(1)] = (52));

} else {
var statearr_14920_15105 = state_14869__$1;
(statearr_14920_15105[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (50))){
var state_14869__$1 = state_14869;
var statearr_14921_15106 = state_14869__$1;
(statearr_14921_15106[(2)] = (2147483647));

(statearr_14921_15106[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (116))){
var inst_14841 = (state_14869[(66)]);
var inst_14849 = (state_14869[(2)]);
var state_14869__$1 = (function (){var statearr_14922 = state_14869;
(statearr_14922[(73)] = inst_14849);

return statearr_14922;
})();
if(cljs.core.truth_(inst_14841)){
var statearr_14923_15107 = state_14869__$1;
(statearr_14923_15107[(1)] = (118));

} else {
var statearr_14924_15108 = state_14869__$1;
(statearr_14924_15108[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (75))){
var inst_14704 = (state_14869[(40)]);
var state_14869__$1 = state_14869;
var statearr_14925_15109 = state_14869__$1;
(statearr_14925_15109[(2)] = inst_14704);

(statearr_14925_15109[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (99))){
var inst_14765 = (state_14869[(67)]);
var inst_14774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14775 = [inst_14765,inst_14765];
var inst_14776 = (new cljs.core.PersistentVector(null,2,(5),inst_14774,inst_14775,null));
var state_14869__$1 = state_14869;
var statearr_14926_15110 = state_14869__$1;
(statearr_14926_15110[(2)] = inst_14776);

(statearr_14926_15110[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (21))){
var state_14869__$1 = state_14869;
var statearr_14927_15111 = state_14869__$1;
(statearr_14927_15111[(2)] = null);

(statearr_14927_15111[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (31))){
var inst_14590 = (state_14869[(74)]);
var state_14869__$1 = state_14869;
var statearr_14928_15112 = state_14869__$1;
(statearr_14928_15112[(2)] = inst_14590);

(statearr_14928_15112[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (113))){
var inst_14835 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
var statearr_14929_15113 = state_14869__$1;
(statearr_14929_15113[(2)] = inst_14835);

(statearr_14929_15113[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (32))){
var inst_14610 = (state_14869[(75)]);
var inst_14521 = (state_14869[(60)]);
var inst_14609 = (state_14869[(2)]);
var inst_14610__$1 = (inst_14521 == null);
var state_14869__$1 = (function (){var statearr_14930 = state_14869;
(statearr_14930[(75)] = inst_14610__$1);

(statearr_14930[(32)] = inst_14609);

return statearr_14930;
})();
if(cljs.core.truth_(inst_14610__$1)){
var statearr_14931_15114 = state_14869__$1;
(statearr_14931_15114[(1)] = (34));

} else {
var statearr_14932_15115 = state_14869__$1;
(statearr_14932_15115[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (40))){
var inst_14609 = (state_14869[(32)]);
var state_14869__$1 = state_14869;
var statearr_14933_15116 = state_14869__$1;
(statearr_14933_15116[(2)] = inst_14609);

(statearr_14933_15116[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (91))){
var inst_14723 = (state_14869[(65)]);
var inst_14821 = (state_14869[(2)]);
var inst_14822 = cljs.core.nth.call(null,inst_14821,(0),null);
var inst_14823 = cljs.core.nth.call(null,inst_14821,(1),null);
var inst_14824 = cljs.core.nth.call(null,inst_14821,(2),null);
var inst_14825 = cljs.core.nth.call(null,inst_14821,(3),null);
var state_14869__$1 = (function (){var statearr_14934 = state_14869;
(statearr_14934[(76)] = inst_14823);

(statearr_14934[(7)] = inst_14825);

(statearr_14934[(77)] = inst_14824);

(statearr_14934[(78)] = inst_14822);

return statearr_14934;
})();
if(cljs.core.truth_(inst_14723)){
var statearr_14935_15117 = state_14869__$1;
(statearr_14935_15117[(1)] = (105));

} else {
var statearr_14936_15118 = state_14869__$1;
(statearr_14936_15118[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (117))){
var inst_14845 = (state_14869[(2)]);
var inst_14846 = fluree.db.util.async.throw_err.call(null,inst_14845);
var state_14869__$1 = state_14869;
var statearr_14937_15119 = state_14869__$1;
(statearr_14937_15119[(2)] = inst_14846);

(statearr_14937_15119[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (108))){
var inst_14823 = (state_14869[(76)]);
var inst_14650 = (state_14869[(16)]);
var inst_14830 = (state_14869[(79)]);
var inst_14830__$1 = (inst_14823 < inst_14650);
var state_14869__$1 = (function (){var statearr_14938 = state_14869;
(statearr_14938[(79)] = inst_14830__$1);

return statearr_14938;
})();
if(cljs.core.truth_(inst_14830__$1)){
var statearr_14939_15120 = state_14869__$1;
(statearr_14939_15120[(1)] = (111));

} else {
var statearr_14940_15121 = state_14869__$1;
(statearr_14940_15121[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (56))){
var state_14869__$1 = state_14869;
var statearr_14941_15122 = state_14869__$1;
(statearr_14941_15122[(2)] = fluree.db.util.core.min_integer);

(statearr_14941_15122[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (33))){
var inst_14605 = (state_14869[(2)]);
var inst_14606 = fluree.db.util.async.throw_err.call(null,inst_14605);
var state_14869__$1 = state_14869;
var statearr_14942_15123 = state_14869__$1;
(statearr_14942_15123[(2)] = inst_14606);

(statearr_14942_15123[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (13))){
var inst_14551 = (state_14869[(2)]);
var inst_14552 = fluree.db.util.async.throw_err.call(null,inst_14551);
var state_14869__$1 = state_14869;
var statearr_14943_15124 = state_14869__$1;
(statearr_14943_15124[(2)] = inst_14552);

(statearr_14943_15124[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (22))){
var inst_14565 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
var statearr_14944_15125 = state_14869__$1;
(statearr_14944_15125[(2)] = inst_14565);

(statearr_14944_15125[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (90))){
var inst_14668 = (state_14869[(10)]);
var inst_14662 = (state_14869[(11)]);
var inst_14627 = (state_14869[(12)]);
var inst_14636 = (state_14869[(13)]);
var inst_14688 = (state_14869[(14)]);
var inst_14588 = (state_14869[(15)]);
var inst_14650 = (state_14869[(16)]);
var inst_14696 = (state_14869[(17)]);
var inst_14618 = (state_14869[(18)]);
var inst_14587 = (state_14869[(19)]);
var inst_14656 = (state_14869[(20)]);
var inst_14524 = (state_14869[(21)]);
var inst_14646 = (state_14869[(22)]);
var inst_14722 = (state_14869[(80)]);
var inst_14667 = (state_14869[(23)]);
var inst_14683 = (state_14869[(9)]);
var inst_14526 = (state_14869[(24)]);
var inst_14658 = (state_14869[(25)]);
var inst_14647 = (state_14869[(26)]);
var inst_14519 = (state_14869[(27)]);
var inst_14531 = (state_14869[(28)]);
var inst_14745 = (state_14869[(72)]);
var inst_14535 = (state_14869[(29)]);
var inst_14645 = (state_14869[(30)]);
var inst_14649 = (state_14869[(31)]);
var inst_14677 = (state_14869[(8)]);
var inst_14723 = (state_14869[(65)]);
var inst_14609 = (state_14869[(32)]);
var inst_14687 = (state_14869[(33)]);
var inst_14600 = (state_14869[(34)]);
var inst_14523 = (state_14869[(35)]);
var inst_14663 = (state_14869[(36)]);
var inst_14689 = (state_14869[(37)]);
var inst_14744 = (state_14869[(81)]);
var inst_14686 = (state_14869[(38)]);
var inst_14657 = (state_14869[(39)]);
var inst_14555 = (state_14869[(41)]);
var inst_14546 = (state_14869[(42)]);
var inst_14690 = (state_14869[(43)]);
var inst_14536 = (state_14869[(44)]);
var inst_14530 = (state_14869[(45)]);
var inst_14591 = (state_14869[(46)]);
var inst_14534 = (state_14869[(47)]);
var inst_14673 = (state_14869[(48)]);
var inst_14743 = (function (){var no_filter_QMARK_ = inst_14683;
var base_result_SINGLEQUOTE_ = inst_14722;
var t = inst_14663;
var max_limit_QMARK_ = inst_14657;
var next_node = inst_14686;
var fast_forward_db_QMARK_ = inst_14668;
var s1 = inst_14546;
var o2 = inst_14609;
var t1 = inst_14523;
var predicate_fn = inst_14536;
var i = inst_14688;
var rhs = inst_14723;
var m1 = inst_14636;
var map__14518 = inst_14649;
var root_node = inst_14673;
var s2 = inst_14555;
var vec__14515 = inst_14588;
var map__14511 = inst_14534;
var vec__14508 = inst_14526;
var p2 = inst_14627;
var permissions = inst_14658;
var limit = inst_14656;
var start_flake = inst_14646;
var flake_limit = inst_14650;
var offset = inst_14687;
var acc = inst_14690;
var t2 = inst_14530;
var vec__14512 = inst_14587;
var op1 = inst_14524;
var o1 = inst_14600;
var end_flake = inst_14647;
var base_result = inst_14696;
var s = inst_14689;
var node_start = inst_14677;
var p1 = inst_14618;
var subject_fn = inst_14535;
var object_fn = inst_14591;
var idx_compare = inst_14662;
var op2 = inst_14531;
var m2 = inst_14645;
var vec__14505 = inst_14519;
var novelty = inst_14667;
return (function (p1__14490_SHARP_){
return p1__14490_SHARP_.s;
});
})();
var inst_14744__$1 = cljs.core.partition_by.call(null,inst_14743,inst_14722);
var inst_14745__$1 = cljs.core.count.call(null,inst_14744__$1);
var inst_14746 = (inst_14687 > inst_14745__$1);
var state_14869__$1 = (function (){var statearr_14945 = state_14869;
(statearr_14945[(72)] = inst_14745__$1);

(statearr_14945[(81)] = inst_14744__$1);

return statearr_14945;
})();
if(cljs.core.truth_(inst_14746)){
var statearr_14946_15126 = state_14869__$1;
(statearr_14946_15126[(1)] = (92));

} else {
var statearr_14947_15127 = state_14869__$1;
(statearr_14947_15127[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (109))){
var inst_14828 = (state_14869[(82)]);
var state_14869__$1 = state_14869;
var statearr_14948_15128 = state_14869__$1;
(statearr_14948_15128[(2)] = inst_14828);

(statearr_14948_15128[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (36))){
var inst_14614 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
if(cljs.core.truth_(inst_14614)){
var statearr_14949_15129 = state_14869__$1;
(statearr_14949_15129[(1)] = (37));

} else {
var statearr_14950_15130 = state_14869__$1;
(statearr_14950_15130[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (41))){
var inst_14619 = (state_14869[(63)]);
var state_14869__$1 = state_14869;
var statearr_14951_15131 = state_14869__$1;
(statearr_14951_15131[(2)] = inst_14619);

(statearr_14951_15131[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (118))){
var inst_14849 = (state_14869[(73)]);
var state_14869__$1 = state_14869;
var statearr_14952_15132 = state_14869__$1;
(statearr_14952_15132[(2)] = inst_14849);

(statearr_14952_15132[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (89))){
var inst_14688 = (state_14869[(14)]);
var inst_14650 = (state_14869[(16)]);
var inst_14722 = (state_14869[(80)]);
var inst_14689 = (state_14869[(37)]);
var inst_14690 = (state_14869[(43)]);
var inst_14734 = cljs.core.count.call(null,inst_14722);
var inst_14735 = (inst_14650 - inst_14688);
var inst_14736 = cljs.core.take.call(null,inst_14735,inst_14722);
var inst_14737 = cljs.core.into.call(null,inst_14690,inst_14736);
var inst_14738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14739 = (inst_14688 + inst_14734);
var inst_14740 = [(0),inst_14739,inst_14689,inst_14737];
var inst_14741 = (new cljs.core.PersistentVector(null,4,(5),inst_14738,inst_14740,null));
var state_14869__$1 = state_14869;
var statearr_14953_15133 = state_14869__$1;
(statearr_14953_15133[(2)] = inst_14741);

(statearr_14953_15133[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (100))){
var inst_14783 = (state_14869[(52)]);
var inst_14688 = (state_14869[(14)]);
var inst_14650 = (state_14869[(16)]);
var inst_14756 = (state_14869[(68)]);
var inst_14782 = (state_14869[(53)]);
var inst_14784 = (state_14869[(54)]);
var inst_14778 = (state_14869[(2)]);
var inst_14779 = cljs.core.nth.call(null,inst_14778,(0),null);
var inst_14780 = cljs.core.nth.call(null,inst_14778,(1),null);
var inst_14781 = cljs.core.take.call(null,inst_14780,inst_14756);
var inst_14782__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_14781);
var inst_14783__$1 = cljs.core.count.call(null,inst_14782__$1);
var inst_14784__$1 = (inst_14688 + inst_14783__$1);
var inst_14785 = (inst_14784__$1 > inst_14650);
var state_14869__$1 = (function (){var statearr_14954 = state_14869;
(statearr_14954[(52)] = inst_14783__$1);

(statearr_14954[(83)] = inst_14779);

(statearr_14954[(53)] = inst_14782__$1);

(statearr_14954[(54)] = inst_14784__$1);

return statearr_14954;
})();
if(cljs.core.truth_(inst_14785)){
var statearr_14955_15134 = state_14869__$1;
(statearr_14955_15134[(1)] = (101));

} else {
var statearr_14956_15135 = state_14869__$1;
(statearr_14956_15135[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (122))){
var inst_14823 = (state_14869[(76)]);
var inst_14825 = (state_14869[(7)]);
var inst_14824 = (state_14869[(77)]);
var inst_14822 = (state_14869[(78)]);
var inst_14849 = (state_14869[(73)]);
var inst_14686 = inst_14849;
var inst_14687 = inst_14822;
var inst_14688 = inst_14823;
var inst_14689 = inst_14824;
var inst_14690 = inst_14825;
var state_14869__$1 = (function (){var statearr_14957 = state_14869;
(statearr_14957[(14)] = inst_14688);

(statearr_14957[(33)] = inst_14687);

(statearr_14957[(37)] = inst_14689);

(statearr_14957[(38)] = inst_14686);

(statearr_14957[(43)] = inst_14690);

return statearr_14957;
})();
var statearr_14958_15136 = state_14869__$1;
(statearr_14958_15136[(2)] = null);

(statearr_14958_15136[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (43))){
var state_14869__$1 = state_14869;
var statearr_14959_15137 = state_14869__$1;
(statearr_14959_15137[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14959_15137[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (61))){
var inst_14668 = (state_14869[(10)]);
var inst_14646 = (state_14869[(22)]);
var inst_14667 = (state_14869[(23)]);
var inst_14663 = (state_14869[(36)]);
var inst_14673 = (state_14869[(48)]);
var inst_14672 = (state_14869[(2)]);
var inst_14673__$1 = fluree.db.util.async.throw_err.call(null,inst_14672);
var inst_14674 = fluree.db.query.range.find_next_valid_node.call(null,inst_14673__$1,inst_14646,inst_14663,inst_14667,inst_14668);
var state_14869__$1 = (function (){var statearr_14960 = state_14869;
(statearr_14960[(48)] = inst_14673__$1);

return statearr_14960;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14869__$1,(62),inst_14674);
} else {
if((state_val_14870 === (29))){
var inst_14596 = (state_14869[(2)]);
var inst_14597 = fluree.db.util.async.throw_err.call(null,inst_14596);
var state_14869__$1 = state_14869;
var statearr_14961_15138 = state_14869__$1;
(statearr_14961_15138[(2)] = inst_14597);

(statearr_14961_15138[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (44))){
var inst_14528 = (state_14869[(58)]);
var state_14869__$1 = state_14869;
var statearr_14962_15139 = state_14869__$1;
(statearr_14962_15139[(2)] = inst_14528);

(statearr_14962_15139[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (93))){
var inst_14683 = (state_14869[(9)]);
var inst_14687 = (state_14869[(33)]);
var inst_14744 = (state_14869[(81)]);
var inst_14756 = cljs.core.drop.call(null,inst_14687,inst_14744);
var state_14869__$1 = (function (){var statearr_14963 = state_14869;
(statearr_14963[(68)] = inst_14756);

return statearr_14963;
})();
if(cljs.core.truth_(inst_14683)){
var statearr_14964_15140 = state_14869__$1;
(statearr_14964_15140[(1)] = (95));

} else {
var statearr_14965_15141 = state_14869__$1;
(statearr_14965_15141[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (6))){
var inst_14520 = (state_14869[(49)]);
var inst_14540 = fluree.db.dbproto._subid.call(null,db,inst_14520);
var state_14869__$1 = state_14869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14869__$1,(9),inst_14540);
} else {
if((state_val_14870 === (111))){
var inst_14656 = (state_14869[(20)]);
var inst_14824 = (state_14869[(77)]);
var inst_14832 = (inst_14824 < inst_14656);
var state_14869__$1 = state_14869;
var statearr_14966_15142 = state_14869__$1;
(statearr_14966_15142[(2)] = inst_14832);

(statearr_14966_15142[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (28))){
var inst_14590 = (state_14869[(74)]);
var inst_14600 = (state_14869[(2)]);
var inst_14601 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14590);
var state_14869__$1 = (function (){var statearr_14967 = state_14869;
(statearr_14967[(34)] = inst_14600);

return statearr_14967;
})();
if(inst_14601){
var statearr_14968_15143 = state_14869__$1;
(statearr_14968_15143[(1)] = (30));

} else {
var statearr_14969_15144 = state_14869__$1;
(statearr_14969_15144[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (64))){
var state_14869__$1 = state_14869;
var statearr_14970_15145 = state_14869__$1;
(statearr_14970_15145[(2)] = true);

(statearr_14970_15145[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (103))){
var inst_14779 = (state_14869[(83)]);
var inst_14798 = (state_14869[(2)]);
var inst_14799 = cljs.core.nth.call(null,inst_14798,(0),null);
var inst_14800 = cljs.core.nth.call(null,inst_14798,(1),null);
var inst_14801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14802 = [inst_14799,inst_14779,inst_14800];
var inst_14803 = (new cljs.core.PersistentVector(null,3,(5),inst_14801,inst_14802,null));
var state_14869__$1 = state_14869;
var statearr_14971_15146 = state_14869__$1;
(statearr_14971_15146[(2)] = inst_14803);

(statearr_14971_15146[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (51))){
var inst_14634 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
var statearr_14972_15147 = state_14869__$1;
(statearr_14972_15147[(2)] = inst_14634);

(statearr_14972_15147[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (25))){
var inst_14589 = (state_14869[(51)]);
var inst_14588 = (state_14869[(15)]);
var inst_14587 = (state_14869[(19)]);
var inst_14587__$1 = (state_14869[(2)]);
var inst_14588__$1 = cljs.core.nth.call(null,inst_14587__$1,(0),null);
var inst_14589__$1 = cljs.core.nth.call(null,inst_14588__$1,(0),null);
var inst_14590 = cljs.core.nth.call(null,inst_14588__$1,(1),null);
var inst_14591 = cljs.core.nth.call(null,inst_14587__$1,(1),null);
var inst_14592 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14589__$1);
var state_14869__$1 = (function (){var statearr_14973 = state_14869;
(statearr_14973[(51)] = inst_14589__$1);

(statearr_14973[(15)] = inst_14588__$1);

(statearr_14973[(19)] = inst_14587__$1);

(statearr_14973[(74)] = inst_14590);

(statearr_14973[(46)] = inst_14591);

return statearr_14973;
})();
if(inst_14592){
var statearr_14974_15148 = state_14869__$1;
(statearr_14974_15148[(1)] = (26));

} else {
var statearr_14975_15149 = state_14869__$1;
(statearr_14975_15149[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (34))){
var inst_14600 = (state_14869[(34)]);
var state_14869__$1 = state_14869;
var statearr_14976_15150 = state_14869__$1;
(statearr_14976_15150[(2)] = inst_14600);

(statearr_14976_15150[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (17))){
var inst_14529 = (state_14869[(55)]);
var state_14869__$1 = state_14869;
var statearr_14977_15151 = state_14869__$1;
(statearr_14977_15151[(2)] = inst_14529);

(statearr_14977_15151[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (3))){
var inst_14867 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14869__$1,inst_14867);
} else {
if((state_val_14870 === (12))){
var inst_14522 = (state_14869[(59)]);
var inst_14555 = (state_14869[(2)]);
var inst_14556 = cljs.core.boolean_QMARK_.call(null,inst_14522);
var state_14869__$1 = (function (){var statearr_14978 = state_14869;
(statearr_14978[(41)] = inst_14555);

return statearr_14978;
})();
if(inst_14556){
var statearr_14979_15152 = state_14869__$1;
(statearr_14979_15152[(1)] = (14));

} else {
var statearr_14980_15153 = state_14869__$1;
(statearr_14980_15153[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (2))){
var inst_14526 = (state_14869[(24)]);
var inst_14519 = (state_14869[(27)]);
var inst_14520 = (state_14869[(49)]);
var inst_14534 = (state_14869[(47)]);
var _ = (function (){var statearr_14981 = state_14869;
(statearr_14981[(4)] = cljs.core.cons.call(null,(5),(state_14869[(4)])));

return statearr_14981;
})();
var inst_14519__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_14520__$1 = cljs.core.nth.call(null,inst_14519__$1,(0),null);
var inst_14521 = cljs.core.nth.call(null,inst_14519__$1,(1),null);
var inst_14522 = cljs.core.nth.call(null,inst_14519__$1,(2),null);
var inst_14523 = cljs.core.nth.call(null,inst_14519__$1,(3),null);
var inst_14524 = cljs.core.nth.call(null,inst_14519__$1,(4),null);
var inst_14525 = cljs.core.nth.call(null,inst_14519__$1,(5),null);
var inst_14526__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_14527 = cljs.core.nth.call(null,inst_14526__$1,(0),null);
var inst_14528 = cljs.core.nth.call(null,inst_14526__$1,(1),null);
var inst_14529 = cljs.core.nth.call(null,inst_14526__$1,(2),null);
var inst_14530 = cljs.core.nth.call(null,inst_14526__$1,(3),null);
var inst_14531 = cljs.core.nth.call(null,inst_14526__$1,(4),null);
var inst_14532 = cljs.core.nth.call(null,inst_14526__$1,(5),null);
var inst_14533 = opts;
var inst_14534__$1 = cljs.core.__destructure_map.call(null,inst_14533);
var inst_14535 = cljs.core.get.call(null,inst_14534__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_14536 = cljs.core.get.call(null,inst_14534__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_14537 = cljs.core.get.call(null,inst_14534__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_14538 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14520__$1);
var state_14869__$1 = (function (){var statearr_14982 = state_14869;
(statearr_14982[(55)] = inst_14529);

(statearr_14982[(56)] = inst_14525);

(statearr_14982[(57)] = inst_14532);

(statearr_14982[(21)] = inst_14524);

(statearr_14982[(58)] = inst_14528);

(statearr_14982[(59)] = inst_14522);

(statearr_14982[(24)] = inst_14526__$1);

(statearr_14982[(27)] = inst_14519__$1);

(statearr_14982[(28)] = inst_14531);

(statearr_14982[(29)] = inst_14535);

(statearr_14982[(84)] = inst_14527);

(statearr_14982[(35)] = inst_14523);

(statearr_14982[(60)] = inst_14521);

(statearr_14982[(61)] = inst_14537);

(statearr_14982[(49)] = inst_14520__$1);

(statearr_14982[(44)] = inst_14536);

(statearr_14982[(45)] = inst_14530);

(statearr_14982[(47)] = inst_14534__$1);

return statearr_14982;
})();
if(inst_14538){
var statearr_14983_15154 = state_14869__$1;
(statearr_14983_15154[(1)] = (6));

} else {
var statearr_14984_15155 = state_14869__$1;
(statearr_14984_15155[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (66))){
var inst_14677 = (state_14869[(8)]);
var inst_14652 = (state_14869[(71)]);
var inst_14685 = cljs.core.PersistentVector.EMPTY;
var inst_14686 = inst_14677;
var inst_14687 = inst_14652;
var inst_14688 = (0);
var inst_14689 = (0);
var inst_14690 = inst_14685;
var state_14869__$1 = (function (){var statearr_14985 = state_14869;
(statearr_14985[(14)] = inst_14688);

(statearr_14985[(33)] = inst_14687);

(statearr_14985[(37)] = inst_14689);

(statearr_14985[(38)] = inst_14686);

(statearr_14985[(43)] = inst_14690);

return statearr_14985;
})();
var statearr_14986_15156 = state_14869__$1;
(statearr_14986_15156[(2)] = null);

(statearr_14986_15156[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (107))){
var inst_14841 = (state_14869[(66)]);
var inst_14841__$1 = (state_14869[(2)]);
var state_14869__$1 = (function (){var statearr_14987 = state_14869;
(statearr_14987[(66)] = inst_14841__$1);

return statearr_14987;
})();
if(cljs.core.truth_(inst_14841__$1)){
var statearr_14988_15157 = state_14869__$1;
(statearr_14988_15157[(1)] = (114));

} else {
var statearr_14989_15158 = state_14869__$1;
(statearr_14989_15158[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (23))){
var inst_14529 = (state_14869[(55)]);
var inst_14522 = (state_14869[(59)]);
var inst_14537 = (state_14869[(61)]);
var inst_14572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14574 = [inst_14522,inst_14529];
var inst_14575 = (new cljs.core.PersistentVector(null,2,(5),inst_14573,inst_14574,null));
var inst_14576 = [inst_14575,inst_14537];
var inst_14577 = (new cljs.core.PersistentVector(null,2,(5),inst_14572,inst_14576,null));
var state_14869__$1 = state_14869;
var statearr_14990_15159 = state_14869__$1;
(statearr_14990_15159[(2)] = inst_14577);

(statearr_14990_15159[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (47))){
var inst_14630 = (cljs.core._GT__EQ_ === start_test);
var state_14869__$1 = state_14869;
if(cljs.core.truth_(inst_14630)){
var statearr_14991_15160 = state_14869__$1;
(statearr_14991_15160[(1)] = (49));

} else {
var statearr_14992_15161 = state_14869__$1;
(statearr_14992_15161[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (35))){
var inst_14610 = (state_14869[(75)]);
var state_14869__$1 = state_14869;
var statearr_14993_15162 = state_14869__$1;
(statearr_14993_15162[(2)] = inst_14610);

(statearr_14993_15162[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (82))){
var inst_14686 = (state_14869[(38)]);
var inst_14657 = (state_14869[(39)]);
var inst_14722 = (state_14869[(2)]);
var inst_14723 = fluree.db.dbproto._rhs.call(null,inst_14686);
var state_14869__$1 = (function (){var statearr_14994 = state_14869;
(statearr_14994[(80)] = inst_14722);

(statearr_14994[(65)] = inst_14723);

return statearr_14994;
})();
if(cljs.core.truth_(inst_14657)){
var statearr_14995_15163 = state_14869__$1;
(statearr_14995_15163[(1)] = (83));

} else {
var statearr_14996_15164 = state_14869__$1;
(statearr_14996_15164[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (76))){
var inst_14536 = (state_14869[(44)]);
var inst_14710 = (state_14869[(2)]);
var state_14869__$1 = (function (){var statearr_14997 = state_14869;
(statearr_14997[(64)] = inst_14710);

return statearr_14997;
})();
if(cljs.core.truth_(inst_14536)){
var statearr_14998_15165 = state_14869__$1;
(statearr_14998_15165[(1)] = (77));

} else {
var statearr_14999_15166 = state_14869__$1;
(statearr_14999_15166[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (97))){
var inst_14690 = (state_14869[(43)]);
var inst_14810 = (state_14869[(2)]);
var inst_14811 = cljs.core.nth.call(null,inst_14810,(0),null);
var inst_14812 = cljs.core.nth.call(null,inst_14810,(1),null);
var inst_14813 = cljs.core.nth.call(null,inst_14810,(2),null);
var inst_14814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14815 = cljs.core.into.call(null,inst_14690,inst_14813);
var inst_14816 = [(0),inst_14811,inst_14812,inst_14815];
var inst_14817 = (new cljs.core.PersistentVector(null,4,(5),inst_14814,inst_14816,null));
var state_14869__$1 = state_14869;
var statearr_15000_15167 = state_14869__$1;
(statearr_15000_15167[(2)] = inst_14817);

(statearr_15000_15167[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (19))){
var inst_14567 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
var statearr_15001_15168 = state_14869__$1;
(statearr_15001_15168[(2)] = inst_14567);

(statearr_15001_15168[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (57))){
var inst_14643 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
var statearr_15002_15169 = state_14869__$1;
(statearr_15002_15169[(2)] = inst_14643);

(statearr_15002_15169[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (68))){
var inst_14864 = (state_14869[(2)]);
var _ = (function (){var statearr_15003 = state_14869;
(statearr_15003[(4)] = cljs.core.rest.call(null,(state_14869[(4)])));

return statearr_15003;
})();
var state_14869__$1 = state_14869;
var statearr_15004_15170 = state_14869__$1;
(statearr_15004_15170[(2)] = inst_14864);

(statearr_15004_15170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (11))){
var inst_14527 = (state_14869[(84)]);
var state_14869__$1 = state_14869;
var statearr_15005_15171 = state_14869__$1;
(statearr_15005_15171[(2)] = inst_14527);

(statearr_15005_15171[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (115))){
var state_14869__$1 = state_14869;
var statearr_15007_15172 = state_14869__$1;
(statearr_15007_15172[(2)] = null);

(statearr_15007_15172[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (9))){
var inst_14542 = (state_14869[(2)]);
var inst_14543 = fluree.db.util.async.throw_err.call(null,inst_14542);
var state_14869__$1 = state_14869;
var statearr_15008_15173 = state_14869__$1;
(statearr_15008_15173[(2)] = inst_14543);

(statearr_15008_15173[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (5))){
var _ = (function (){var statearr_15009 = state_14869;
(statearr_15009[(4)] = cljs.core.rest.call(null,(state_14869[(4)])));

return statearr_15009;
})();
var state_14869__$1 = state_14869;
var ex15006 = (state_14869__$1[(2)]);
var statearr_15010_15174 = state_14869__$1;
(statearr_15010_15174[(5)] = ex15006);


if((ex15006 instanceof Error)){
var statearr_15011_15175 = state_14869__$1;
(statearr_15011_15175[(1)] = (4));

(statearr_15011_15175[(5)] = null);

} else {
throw ex15006;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (112))){
var inst_14830 = (state_14869[(79)]);
var state_14869__$1 = state_14869;
var statearr_15012_15176 = state_14869__$1;
(statearr_15012_15176[(2)] = inst_14830);

(statearr_15012_15176[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (83))){
var inst_14725 = (state_14869[(85)]);
var inst_14687 = (state_14869[(33)]);
var inst_14725__$1 = cljs.core._EQ_.call(null,(0),inst_14687);
var state_14869__$1 = (function (){var statearr_15013 = state_14869;
(statearr_15013[(85)] = inst_14725__$1);

return statearr_15013;
})();
if(inst_14725__$1){
var statearr_15014_15177 = state_14869__$1;
(statearr_15014_15177[(1)] = (86));

} else {
var statearr_15015_15178 = state_14869__$1;
(statearr_15015_15178[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (14))){
var inst_14522 = (state_14869[(59)]);
var state_14869__$1 = state_14869;
var statearr_15016_15179 = state_14869__$1;
(statearr_15016_15179[(2)] = inst_14522);

(statearr_15016_15179[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (45))){
var inst_14525 = (state_14869[(56)]);
var inst_14627 = (state_14869[(2)]);
var state_14869__$1 = (function (){var statearr_15017 = state_14869;
(statearr_15017[(12)] = inst_14627);

return statearr_15017;
})();
if(cljs.core.truth_(inst_14525)){
var statearr_15018_15180 = state_14869__$1;
(statearr_15018_15180[(1)] = (46));

} else {
var statearr_15019_15181 = state_14869__$1;
(statearr_15019_15181[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (53))){
var inst_14639 = (cljs.core._LT__EQ_ === end_test);
var state_14869__$1 = state_14869;
if(cljs.core.truth_(inst_14639)){
var statearr_15020_15182 = state_14869__$1;
(statearr_15020_15182[(1)] = (55));

} else {
var statearr_15021_15183 = state_14869__$1;
(statearr_15021_15183[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (78))){
var inst_14710 = (state_14869[(64)]);
var state_14869__$1 = state_14869;
var statearr_15022_15184 = state_14869__$1;
(statearr_15022_15184[(2)] = inst_14710);

(statearr_15022_15184[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (26))){
var inst_14589 = (state_14869[(51)]);
var inst_14594 = fluree.db.dbproto._subid.call(null,db,inst_14589);
var state_14869__$1 = state_14869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14869__$1,(29),inst_14594);
} else {
if((state_val_14870 === (123))){
var inst_14859 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
var statearr_15023_15185 = state_14869__$1;
(statearr_15023_15185[(2)] = inst_14859);

(statearr_15023_15185[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (16))){
var inst_14569 = (state_14869[(62)]);
var inst_14569__$1 = (state_14869[(2)]);
var inst_14570 = (inst_14569__$1 == null);
var state_14869__$1 = (function (){var statearr_15024 = state_14869;
(statearr_15024[(62)] = inst_14569__$1);

return statearr_15024;
})();
if(cljs.core.truth_(inst_14570)){
var statearr_15025_15186 = state_14869__$1;
(statearr_15025_15186[(1)] = (23));

} else {
var statearr_15026_15187 = state_14869__$1;
(statearr_15026_15187[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (81))){
var inst_14716 = (state_14869[(86)]);
var state_14869__$1 = state_14869;
var statearr_15027_15188 = state_14869__$1;
(statearr_15027_15188[(2)] = inst_14716);

(statearr_15027_15188[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (120))){
var inst_14853 = (state_14869[(2)]);
var inst_14854 = cljs.core.not.call(null,inst_14853);
var state_14869__$1 = state_14869;
if(inst_14854){
var statearr_15028_15189 = state_14869__$1;
(statearr_15028_15189[(1)] = (121));

} else {
var statearr_15029_15190 = state_14869__$1;
(statearr_15029_15190[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (79))){
var inst_14591 = (state_14869[(46)]);
var inst_14716 = (state_14869[(2)]);
var state_14869__$1 = (function (){var statearr_15030 = state_14869;
(statearr_15030[(86)] = inst_14716);

return statearr_15030;
})();
if(cljs.core.truth_(inst_14591)){
var statearr_15031_15191 = state_14869__$1;
(statearr_15031_15191[(1)] = (80));

} else {
var statearr_15032_15192 = state_14869__$1;
(statearr_15032_15192[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (38))){
var inst_14521 = (state_14869[(60)]);
var state_14869__$1 = state_14869;
var statearr_15033_15193 = state_14869__$1;
(statearr_15033_15193[(2)] = inst_14521);

(statearr_15033_15193[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (98))){
var inst_14656 = (state_14869[(20)]);
var inst_14764 = (state_14869[(69)]);
var inst_14766 = (state_14869[(70)]);
var inst_14769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14770 = (inst_14764 - inst_14766);
var inst_14771 = [inst_14656,inst_14770];
var inst_14772 = (new cljs.core.PersistentVector(null,2,(5),inst_14769,inst_14771,null));
var state_14869__$1 = state_14869;
var statearr_15034_15194 = state_14869__$1;
(statearr_15034_15194[(2)] = inst_14772);

(statearr_15034_15194[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (87))){
var inst_14725 = (state_14869[(85)]);
var state_14869__$1 = state_14869;
var statearr_15035_15195 = state_14869__$1;
(statearr_15035_15195[(2)] = inst_14725);

(statearr_15035_15195[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (30))){
var inst_14590 = (state_14869[(74)]);
var inst_14603 = fluree.db.dbproto._subid.call(null,db,inst_14590);
var state_14869__$1 = state_14869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14869__$1,(33),inst_14603);
} else {
if((state_val_14870 === (73))){
var inst_14535 = (state_14869[(29)]);
var inst_14704 = (state_14869[(2)]);
var state_14869__$1 = (function (){var statearr_15036 = state_14869;
(statearr_15036[(40)] = inst_14704);

return statearr_15036;
})();
if(cljs.core.truth_(inst_14535)){
var statearr_15037_15196 = state_14869__$1;
(statearr_15037_15196[(1)] = (74));

} else {
var statearr_15038_15197 = state_14869__$1;
(statearr_15038_15197[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (96))){
var inst_14688 = (state_14869[(14)]);
var inst_14650 = (state_14869[(16)]);
var inst_14656 = (state_14869[(20)]);
var inst_14756 = (state_14869[(68)]);
var inst_14689 = (state_14869[(37)]);
var inst_14805 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_14756,inst_14688,inst_14689,inst_14650,inst_14656);
var state_14869__$1 = state_14869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14869__$1,(104),inst_14805);
} else {
if((state_val_14870 === (10))){
var inst_14527 = (state_14869[(84)]);
var inst_14549 = fluree.db.dbproto._subid.call(null,db,inst_14527);
var state_14869__$1 = state_14869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14869__$1,(13),inst_14549);
} else {
if((state_val_14870 === (18))){
var state_14869__$1 = state_14869;
var statearr_15039_15198 = state_14869__$1;
(statearr_15039_15198[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (105))){
var inst_14662 = (state_14869[(11)]);
var inst_14647 = (state_14869[(26)]);
var inst_14828 = (state_14869[(82)]);
var inst_14723 = (state_14869[(65)]);
var inst_14827 = inst_14662.call(null,inst_14723,inst_14647);
var inst_14828__$1 = (inst_14827 < (0));
var state_14869__$1 = (function (){var statearr_15041 = state_14869;
(statearr_15041[(82)] = inst_14828__$1);

return statearr_15041;
})();
if(cljs.core.truth_(inst_14828__$1)){
var statearr_15042_15199 = state_14869__$1;
(statearr_15042_15199[(1)] = (108));

} else {
var statearr_15043_15200 = state_14869__$1;
(statearr_15043_15200[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (52))){
var inst_14532 = (state_14869[(57)]);
var state_14869__$1 = state_14869;
var statearr_15044_15201 = state_14869__$1;
(statearr_15044_15201[(2)] = inst_14532);

(statearr_15044_15201[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (114))){
var inst_14668 = (state_14869[(10)]);
var inst_14667 = (state_14869[(23)]);
var inst_14723 = (state_14869[(65)]);
var inst_14663 = (state_14869[(36)]);
var inst_14673 = (state_14869[(48)]);
var inst_14843 = fluree.db.query.range.find_next_valid_node.call(null,inst_14673,inst_14723,inst_14663,inst_14667,inst_14668);
var state_14869__$1 = state_14869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14869__$1,(117),inst_14843);
} else {
if((state_val_14870 === (67))){
var state_14869__$1 = state_14869;
var statearr_15045_15202 = state_14869__$1;
(statearr_15045_15202[(2)] = null);

(statearr_15045_15202[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (71))){
var inst_14668 = (state_14869[(10)]);
var inst_14662 = (state_14869[(11)]);
var inst_14627 = (state_14869[(12)]);
var inst_14636 = (state_14869[(13)]);
var inst_14688 = (state_14869[(14)]);
var inst_14588 = (state_14869[(15)]);
var inst_14650 = (state_14869[(16)]);
var inst_14696 = (state_14869[(17)]);
var inst_14618 = (state_14869[(18)]);
var inst_14587 = (state_14869[(19)]);
var inst_14656 = (state_14869[(20)]);
var inst_14524 = (state_14869[(21)]);
var inst_14646 = (state_14869[(22)]);
var inst_14667 = (state_14869[(23)]);
var inst_14683 = (state_14869[(9)]);
var inst_14526 = (state_14869[(24)]);
var inst_14658 = (state_14869[(25)]);
var inst_14647 = (state_14869[(26)]);
var inst_14519 = (state_14869[(27)]);
var inst_14531 = (state_14869[(28)]);
var inst_14535 = (state_14869[(29)]);
var inst_14645 = (state_14869[(30)]);
var inst_14649 = (state_14869[(31)]);
var inst_14677 = (state_14869[(8)]);
var inst_14609 = (state_14869[(32)]);
var inst_14687 = (state_14869[(33)]);
var inst_14600 = (state_14869[(34)]);
var inst_14523 = (state_14869[(35)]);
var inst_14663 = (state_14869[(36)]);
var inst_14689 = (state_14869[(37)]);
var inst_14686 = (state_14869[(38)]);
var inst_14657 = (state_14869[(39)]);
var inst_14555 = (state_14869[(41)]);
var inst_14546 = (state_14869[(42)]);
var inst_14690 = (state_14869[(43)]);
var inst_14536 = (state_14869[(44)]);
var inst_14530 = (state_14869[(45)]);
var inst_14591 = (state_14869[(46)]);
var inst_14534 = (state_14869[(47)]);
var inst_14673 = (state_14869[(48)]);
var inst_14700 = (function (){var no_filter_QMARK_ = inst_14683;
var t = inst_14663;
var max_limit_QMARK_ = inst_14657;
var next_node = inst_14686;
var fast_forward_db_QMARK_ = inst_14668;
var s1 = inst_14546;
var o2 = inst_14609;
var t1 = inst_14523;
var predicate_fn = inst_14536;
var i = inst_14688;
var m1 = inst_14636;
var map__14518 = inst_14649;
var root_node = inst_14673;
var G__14697 = inst_14696;
var s2 = inst_14555;
var vec__14515 = inst_14588;
var map__14511 = inst_14534;
var vec__14508 = inst_14526;
var p2 = inst_14627;
var permissions = inst_14658;
var limit = inst_14656;
var start_flake = inst_14646;
var flake_limit = inst_14650;
var offset = inst_14687;
var acc = inst_14690;
var t2 = inst_14530;
var vec__14512 = inst_14587;
var op1 = inst_14524;
var o1 = inst_14600;
var end_flake = inst_14647;
var base_result = inst_14696;
var s = inst_14689;
var node_start = inst_14677;
var p1 = inst_14618;
var subject_fn = inst_14535;
var object_fn = inst_14591;
var idx_compare = inst_14662;
var op2 = inst_14531;
var m2 = inst_14645;
var vec__14505 = inst_14519;
var novelty = inst_14667;
return (function (p1__14486_SHARP_){
return cljs.core._EQ_.call(null,p1__14486_SHARP_.o,start_flake.o);
});
})();
var inst_14701 = cljs.core.filter.call(null,inst_14700,inst_14696);
var state_14869__$1 = state_14869;
var statearr_15046_15203 = state_14869__$1;
(statearr_15046_15203[(2)] = inst_14701);

(statearr_15046_15203[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (42))){
var inst_14623 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
if(cljs.core.truth_(inst_14623)){
var statearr_15047_15204 = state_14869__$1;
(statearr_15047_15204[(1)] = (43));

} else {
var statearr_15048_15205 = state_14869__$1;
(statearr_15048_15205[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (80))){
var inst_14668 = (state_14869[(10)]);
var inst_14662 = (state_14869[(11)]);
var inst_14627 = (state_14869[(12)]);
var inst_14636 = (state_14869[(13)]);
var inst_14688 = (state_14869[(14)]);
var inst_14588 = (state_14869[(15)]);
var inst_14650 = (state_14869[(16)]);
var inst_14696 = (state_14869[(17)]);
var inst_14618 = (state_14869[(18)]);
var inst_14587 = (state_14869[(19)]);
var inst_14656 = (state_14869[(20)]);
var inst_14524 = (state_14869[(21)]);
var inst_14646 = (state_14869[(22)]);
var inst_14667 = (state_14869[(23)]);
var inst_14683 = (state_14869[(9)]);
var inst_14526 = (state_14869[(24)]);
var inst_14658 = (state_14869[(25)]);
var inst_14647 = (state_14869[(26)]);
var inst_14519 = (state_14869[(27)]);
var inst_14531 = (state_14869[(28)]);
var inst_14535 = (state_14869[(29)]);
var inst_14645 = (state_14869[(30)]);
var inst_14649 = (state_14869[(31)]);
var inst_14677 = (state_14869[(8)]);
var inst_14609 = (state_14869[(32)]);
var inst_14687 = (state_14869[(33)]);
var inst_14600 = (state_14869[(34)]);
var inst_14523 = (state_14869[(35)]);
var inst_14663 = (state_14869[(36)]);
var inst_14689 = (state_14869[(37)]);
var inst_14686 = (state_14869[(38)]);
var inst_14657 = (state_14869[(39)]);
var inst_14555 = (state_14869[(41)]);
var inst_14546 = (state_14869[(42)]);
var inst_14690 = (state_14869[(43)]);
var inst_14536 = (state_14869[(44)]);
var inst_14530 = (state_14869[(45)]);
var inst_14591 = (state_14869[(46)]);
var inst_14534 = (state_14869[(47)]);
var inst_14673 = (state_14869[(48)]);
var inst_14716 = (state_14869[(86)]);
var inst_14718 = (function (){var no_filter_QMARK_ = inst_14683;
var t = inst_14663;
var max_limit_QMARK_ = inst_14657;
var next_node = inst_14686;
var fast_forward_db_QMARK_ = inst_14668;
var s1 = inst_14546;
var o2 = inst_14609;
var t1 = inst_14523;
var predicate_fn = inst_14536;
var i = inst_14688;
var m1 = inst_14636;
var map__14518 = inst_14649;
var root_node = inst_14673;
var G__14697 = inst_14716;
var s2 = inst_14555;
var vec__14515 = inst_14588;
var map__14511 = inst_14534;
var vec__14508 = inst_14526;
var p2 = inst_14627;
var permissions = inst_14658;
var limit = inst_14656;
var start_flake = inst_14646;
var flake_limit = inst_14650;
var offset = inst_14687;
var acc = inst_14690;
var t2 = inst_14530;
var vec__14512 = inst_14587;
var op1 = inst_14524;
var o1 = inst_14600;
var end_flake = inst_14647;
var base_result = inst_14696;
var s = inst_14689;
var node_start = inst_14677;
var p1 = inst_14618;
var subject_fn = inst_14535;
var object_fn = inst_14591;
var idx_compare = inst_14662;
var op2 = inst_14531;
var m2 = inst_14645;
var vec__14505 = inst_14519;
var novelty = inst_14667;
return (function (p1__14489_SHARP_){
return object_fn.call(null,p1__14489_SHARP_.o);
});
})();
var inst_14719 = cljs.core.filter.call(null,inst_14718,inst_14716);
var state_14869__$1 = state_14869;
var statearr_15049_15206 = state_14869__$1;
(statearr_15049_15206[(2)] = inst_14719);

(statearr_15049_15206[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (37))){
var state_14869__$1 = state_14869;
var statearr_15050_15207 = state_14869__$1;
(statearr_15050_15207[(2)] = (-1));

(statearr_15050_15207[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (63))){
var inst_14627 = (state_14869[(12)]);
var inst_14618 = (state_14869[(18)]);
var inst_14658 = (state_14869[(25)]);
var inst_14555 = (state_14869[(41)]);
var inst_14546 = (state_14869[(42)]);
var inst_14680 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_14658,inst_14546,inst_14555,inst_14618,inst_14627);
var state_14869__$1 = state_14869;
var statearr_15051_15208 = state_14869__$1;
(statearr_15051_15208[(2)] = inst_14680);

(statearr_15051_15208[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (94))){
var inst_14819 = (state_14869[(2)]);
var state_14869__$1 = state_14869;
var statearr_15052_15209 = state_14869__$1;
(statearr_15052_15209[(2)] = inst_14819);

(statearr_15052_15209[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (8))){
var inst_14527 = (state_14869[(84)]);
var inst_14546 = (state_14869[(2)]);
var inst_14547 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14527);
var state_14869__$1 = (function (){var statearr_15053 = state_14869;
(statearr_15053[(42)] = inst_14546);

return statearr_15053;
})();
if(inst_14547){
var statearr_15054_15210 = state_14869__$1;
(statearr_15054_15210[(1)] = (10));

} else {
var statearr_15055_15211 = state_14869__$1;
(statearr_15055_15211[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (49))){
var state_14869__$1 = state_14869;
var statearr_15056_15212 = state_14869__$1;
(statearr_15056_15212[(2)] = fluree.db.util.core.min_integer);

(statearr_15056_15212[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14870 === (84))){
var inst_14657 = (state_14869[(39)]);
var state_14869__$1 = state_14869;
var statearr_15057_15213 = state_14869__$1;
(statearr_15057_15213[(2)] = inst_14657);

(statearr_15057_15213[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2741__auto__ = null;
var fluree$db$query$range$state_machine__2741__auto____0 = (function (){
var statearr_15058 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15058[(0)] = fluree$db$query$range$state_machine__2741__auto__);

(statearr_15058[(1)] = (1));

return statearr_15058;
});
var fluree$db$query$range$state_machine__2741__auto____1 = (function (state_14869){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_14869);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e15059){var ex__2744__auto__ = e15059;
var statearr_15060_15214 = state_14869;
(statearr_15060_15214[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_14869[(4)]))){
var statearr_15061_15215 = state_14869;
(statearr_15061_15215[(1)] = cljs.core.first.call(null,(state_14869[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15216 = state_14869;
state_14869 = G__15216;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2741__auto__ = function(state_14869){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2741__auto____1.call(this,state_14869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2741__auto____0;
fluree$db$query$range$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2741__auto____1;
return fluree$db$query$range$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_15062 = f__2764__auto__.call(null);
(statearr_15062[(6)] = c__2763__auto__);

return statearr_15062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_15272){
var state_val_15273 = (state_15272[(1)]);
if((state_val_15273 === (7))){
var inst_15236 = (state_15272[(7)]);
var inst_15246 = (state_15272[(8)]);
var inst_15244 = fluree.db.flake.Flake__GT_parts.call(null,inst_15236);
var inst_15245 = cljs.core.nth.call(null,inst_15244,(0),null);
var inst_15246__$1 = cljs.core.nth.call(null,inst_15244,(1),null);
var inst_15247 = cljs.core.nth.call(null,inst_15244,(2),null);
var inst_15248 = cljs.core.nth.call(null,inst_15244,(3),null);
var inst_15249 = cljs.core.nth.call(null,inst_15244,(4),null);
var inst_15250 = cljs.core.nth.call(null,inst_15244,(5),null);
var inst_15251 = fluree.db.dbproto._tag.call(null,db,inst_15247,inst_15246__$1);
var state_15272__$1 = (function (){var statearr_15274 = state_15272;
(statearr_15274[(9)] = inst_15248);

(statearr_15274[(10)] = inst_15250);

(statearr_15274[(11)] = inst_15249);

(statearr_15274[(8)] = inst_15246__$1);

(statearr_15274[(12)] = inst_15245);

return statearr_15274;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15272__$1,(10),inst_15251);
} else {
if((state_val_15273 === (1))){
var inst_15224 = flakes;
var inst_15225 = cljs.core.seq.call(null,inst_15224);
var inst_15226 = cljs.core.first.call(null,inst_15225);
var inst_15227 = cljs.core.next.call(null,inst_15225);
var inst_15228 = cljs.core.PersistentVector.EMPTY;
var inst_15229 = inst_15224;
var inst_15230 = inst_15228;
var state_15272__$1 = (function (){var statearr_15275 = state_15272;
(statearr_15275[(13)] = inst_15227);

(statearr_15275[(14)] = inst_15229);

(statearr_15275[(15)] = inst_15226);

(statearr_15275[(16)] = inst_15230);

return statearr_15275;
})();
var statearr_15276_15294 = state_15272__$1;
(statearr_15276_15294[(2)] = null);

(statearr_15276_15294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15273 === (4))){
var inst_15236 = (state_15272[(7)]);
var inst_15239 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_15236);
var state_15272__$1 = state_15272;
if(inst_15239){
var statearr_15277_15295 = state_15272__$1;
(statearr_15277_15295[(1)] = (7));

} else {
var statearr_15278_15296 = state_15272__$1;
(statearr_15278_15296[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15273 === (6))){
var inst_15268 = (state_15272[(2)]);
var state_15272__$1 = state_15272;
var statearr_15279_15297 = state_15272__$1;
(statearr_15279_15297[(2)] = inst_15268);

(statearr_15279_15297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15273 === (3))){
var inst_15270 = (state_15272[(2)]);
var state_15272__$1 = state_15272;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15272__$1,inst_15270);
} else {
if((state_val_15273 === (2))){
var inst_15229 = (state_15272[(14)]);
var inst_15236 = (state_15272[(7)]);
var inst_15235 = cljs.core.seq.call(null,inst_15229);
var inst_15236__$1 = cljs.core.first.call(null,inst_15235);
var inst_15237 = cljs.core.next.call(null,inst_15235);
var state_15272__$1 = (function (){var statearr_15280 = state_15272;
(statearr_15280[(17)] = inst_15237);

(statearr_15280[(7)] = inst_15236__$1);

return statearr_15280;
})();
if(cljs.core.truth_(inst_15236__$1)){
var statearr_15281_15298 = state_15272__$1;
(statearr_15281_15298[(1)] = (4));

} else {
var statearr_15282_15299 = state_15272__$1;
(statearr_15282_15299[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15273 === (9))){
var inst_15265 = (state_15272[(2)]);
var state_15272__$1 = state_15272;
var statearr_15283_15300 = state_15272__$1;
(statearr_15283_15300[(2)] = inst_15265);

(statearr_15283_15300[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15273 === (5))){
var inst_15230 = (state_15272[(16)]);
var state_15272__$1 = state_15272;
var statearr_15284_15301 = state_15272__$1;
(statearr_15284_15301[(2)] = inst_15230);

(statearr_15284_15301[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15273 === (10))){
var inst_15248 = (state_15272[(9)]);
var inst_15250 = (state_15272[(10)]);
var inst_15237 = (state_15272[(17)]);
var inst_15249 = (state_15272[(11)]);
var inst_15246 = (state_15272[(8)]);
var inst_15245 = (state_15272[(12)]);
var inst_15230 = (state_15272[(16)]);
var inst_15253 = (state_15272[(2)]);
var inst_15254 = fluree.db.util.async.throw_err.call(null,inst_15253);
var inst_15255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15256 = [inst_15245,inst_15246,inst_15254,inst_15248,inst_15249,inst_15250];
var inst_15257 = (new cljs.core.PersistentVector(null,6,(5),inst_15255,inst_15256,null));
var inst_15258 = fluree.db.flake.parts__GT_Flake.call(null,inst_15257);
var inst_15259 = cljs.core.conj.call(null,inst_15230,inst_15258);
var inst_15229 = inst_15237;
var inst_15230__$1 = inst_15259;
var state_15272__$1 = (function (){var statearr_15285 = state_15272;
(statearr_15285[(14)] = inst_15229);

(statearr_15285[(16)] = inst_15230__$1);

return statearr_15285;
})();
var statearr_15286_15302 = state_15272__$1;
(statearr_15286_15302[(2)] = null);

(statearr_15286_15302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15273 === (8))){
var inst_15237 = (state_15272[(17)]);
var inst_15236 = (state_15272[(7)]);
var inst_15230 = (state_15272[(16)]);
var inst_15262 = cljs.core.conj.call(null,inst_15230,inst_15236);
var inst_15229 = inst_15237;
var inst_15230__$1 = inst_15262;
var state_15272__$1 = (function (){var statearr_15287 = state_15272;
(statearr_15287[(14)] = inst_15229);

(statearr_15287[(16)] = inst_15230__$1);

return statearr_15287;
})();
var statearr_15288_15303 = state_15272__$1;
(statearr_15288_15303[(2)] = null);

(statearr_15288_15303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2741__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2741__auto____0 = (function (){
var statearr_15289 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15289[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2741__auto__);

(statearr_15289[(1)] = (1));

return statearr_15289;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2741__auto____1 = (function (state_15272){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_15272);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e15290){var ex__2744__auto__ = e15290;
var statearr_15291_15304 = state_15272;
(statearr_15291_15304[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_15272[(4)]))){
var statearr_15292_15305 = state_15272;
(statearr_15292_15305[(1)] = cljs.core.first.call(null,(state_15272[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15306 = state_15272;
state_15272 = G__15306;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2741__auto__ = function(state_15272){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2741__auto____1.call(this,state_15272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2741__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2741__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_15293 = f__2764__auto__.call(null);
(statearr_15293[(6)] = c__2763__auto__);

return statearr_15293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15308 = arguments.length;
switch (G__15308) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_15478){
var state_val_15479 = (state_15478[(1)]);
if((state_val_15479 === (65))){
var state_15478__$1 = state_15478;
var statearr_15480_15580 = state_15478__$1;
(statearr_15480_15580[(2)] = null);

(statearr_15480_15580[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (70))){
var inst_15473 = (state_15478[(2)]);
var _ = (function (){var statearr_15481 = state_15478;
(statearr_15481[(4)] = cljs.core.rest.call(null,(state_15478[(4)])));

return statearr_15481;
})();
var state_15478__$1 = state_15478;
var statearr_15482_15581 = state_15478__$1;
(statearr_15482_15581[(2)] = inst_15473);

(statearr_15482_15581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (62))){
var inst_15459 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
var statearr_15483_15582 = state_15478__$1;
(statearr_15483_15582[(2)] = inst_15459);

(statearr_15483_15582[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (7))){
var state_15478__$1 = state_15478;
var statearr_15484_15583 = state_15478__$1;
(statearr_15484_15583[(2)] = false);

(statearr_15484_15583[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (59))){
var inst_15433 = (state_15478[(2)]);
var inst_15434 = fluree.db.util.async.throw_err.call(null,inst_15433);
var state_15478__$1 = state_15478;
var statearr_15485_15584 = state_15478__$1;
(statearr_15485_15584[(2)] = inst_15434);

(statearr_15485_15584[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (20))){
var state_15478__$1 = state_15478;
var statearr_15486_15585 = state_15478__$1;
(statearr_15486_15585[(2)] = null);

(statearr_15486_15585[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (58))){
var inst_15423 = (state_15478[(2)]);
var inst_15424 = fluree.db.util.async.throw_err.call(null,inst_15423);
var inst_15425 = cljs.core.take.call(null,(1),inst_15424);
var state_15478__$1 = state_15478;
var statearr_15487_15586 = state_15478__$1;
(statearr_15487_15586[(2)] = inst_15425);

(statearr_15487_15586[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (60))){
var inst_15319 = (state_15478[(7)]);
var inst_15320 = (state_15478[(8)]);
var inst_15322 = (state_15478[(9)]);
var inst_15359 = (state_15478[(10)]);
var inst_15439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15440 = [inst_15320,inst_15319,inst_15359,inst_15322];
var inst_15441 = (new cljs.core.PersistentVector(null,4,(5),inst_15439,inst_15440,null));
var inst_15442 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15441,opts);
var state_15478__$1 = state_15478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15478__$1,(63),inst_15442);
} else {
if((state_val_15479 === (27))){
var inst_15370 = (state_15478[(11)]);
var inst_15359 = (state_15478[(10)]);
var inst_15370__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_15359);
var state_15478__$1 = (function (){var statearr_15488 = state_15478;
(statearr_15488[(11)] = inst_15370__$1);

return statearr_15488;
})();
if(inst_15370__$1){
var statearr_15489_15587 = state_15478__$1;
(statearr_15489_15587[(1)] = (30));

} else {
var statearr_15490_15588 = state_15478__$1;
(statearr_15490_15588[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (1))){
var state_15478__$1 = state_15478;
var statearr_15491_15589 = state_15478__$1;
(statearr_15491_15589[(2)] = null);

(statearr_15491_15589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (69))){
var inst_15465 = (state_15478[(12)]);
var state_15478__$1 = state_15478;
var statearr_15492_15590 = state_15478__$1;
(statearr_15492_15590[(2)] = inst_15465);

(statearr_15492_15590[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (24))){
var inst_15320 = (state_15478[(8)]);
var state_15478__$1 = state_15478;
if(cljs.core.truth_(inst_15320)){
var statearr_15493_15591 = state_15478__$1;
(statearr_15493_15591[(1)] = (27));

} else {
var statearr_15494_15592 = state_15478__$1;
(statearr_15494_15592[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (55))){
var inst_15359 = (state_15478[(10)]);
var inst_15417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15418 = [inst_15359];
var inst_15419 = (new cljs.core.PersistentVector(null,1,(5),inst_15417,inst_15418,null));
var inst_15420 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15421 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15419,inst_15420);
var state_15478__$1 = state_15478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15478__$1,(58),inst_15421);
} else {
if((state_val_15479 === (39))){
var inst_15390 = (state_15478[(2)]);
var inst_15391 = fluree.db.util.async.throw_err.call(null,inst_15390);
var state_15478__$1 = state_15478;
var statearr_15495_15593 = state_15478__$1;
(statearr_15495_15593[(2)] = inst_15391);

(statearr_15495_15593[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (46))){
var inst_15403 = (state_15478[(13)]);
var inst_15403__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15478__$1 = (function (){var statearr_15496 = state_15478;
(statearr_15496[(13)] = inst_15403__$1);

return statearr_15496;
})();
if(cljs.core.truth_(inst_15403__$1)){
var statearr_15497_15594 = state_15478__$1;
(statearr_15497_15594[(1)] = (49));

} else {
var statearr_15498_15595 = state_15478__$1;
(statearr_15498_15595[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (4))){
var inst_15309 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
var statearr_15499_15596 = state_15478__$1;
(statearr_15499_15596[(2)] = inst_15309);

(statearr_15499_15596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (54))){
var inst_15415 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
if(cljs.core.truth_(inst_15415)){
var statearr_15500_15597 = state_15478__$1;
(statearr_15500_15597[(1)] = (55));

} else {
var statearr_15501_15598 = state_15478__$1;
(statearr_15501_15598[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (15))){
var inst_15321 = (state_15478[(14)]);
var inst_15340 = fluree.db.dbproto._tag_id.call(null,db,inst_15321);
var state_15478__$1 = state_15478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15478__$1,(18),inst_15340);
} else {
if((state_val_15479 === (48))){
var inst_15461 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
var statearr_15502_15599 = state_15478__$1;
(statearr_15502_15599[(2)] = inst_15461);

(statearr_15502_15599[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (50))){
var inst_15323 = (state_15478[(15)]);
var inst_15403 = (state_15478[(13)]);
var inst_15319 = (state_15478[(7)]);
var inst_15318 = (state_15478[(16)]);
var inst_15334 = (state_15478[(17)]);
var inst_15320 = (state_15478[(8)]);
var inst_15322 = (state_15478[(9)]);
var inst_15329 = (state_15478[(18)]);
var inst_15359 = (state_15478[(10)]);
var inst_15407 = (function (){var t = inst_15322;
var p = inst_15320;
var idx_predicate_QMARK_ = inst_15323;
var o = inst_15359;
var vec__15315 = inst_15318;
var tag_predicate_QMARK_ = inst_15329;
var temp__5751__auto__ = inst_15403;
var s = inst_15319;
var o_coerce_QMARK_ = inst_15334;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_15478__$1 = state_15478;
var statearr_15503_15600 = state_15478__$1;
(statearr_15503_15600[(2)] = inst_15407);

(statearr_15503_15600[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (21))){
var inst_15355 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
var statearr_15504_15601 = state_15478__$1;
(statearr_15504_15601[(2)] = inst_15355);

(statearr_15504_15601[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (31))){
var inst_15370 = (state_15478[(11)]);
var state_15478__$1 = state_15478;
var statearr_15505_15602 = state_15478__$1;
(statearr_15505_15602[(2)] = inst_15370);

(statearr_15505_15602[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (32))){
var inst_15380 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
var statearr_15506_15603 = state_15478__$1;
(statearr_15506_15603[(2)] = inst_15380);

(statearr_15506_15603[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (40))){
var inst_15394 = (state_15478[(19)]);
var inst_15323 = (state_15478[(15)]);
var inst_15394__$1 = cljs.core.not.call(null,inst_15323);
var state_15478__$1 = (function (){var statearr_15507 = state_15478;
(statearr_15507[(19)] = inst_15394__$1);

return statearr_15507;
})();
if(inst_15394__$1){
var statearr_15508_15604 = state_15478__$1;
(statearr_15508_15604[(1)] = (43));

} else {
var statearr_15509_15605 = state_15478__$1;
(statearr_15509_15605[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (56))){
var inst_15409 = (state_15478[(20)]);
var inst_15319 = (state_15478[(7)]);
var inst_15320 = (state_15478[(8)]);
var inst_15322 = (state_15478[(9)]);
var inst_15427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15428 = [inst_15320,inst_15319,null,inst_15322];
var inst_15429 = (new cljs.core.PersistentVector(null,4,(5),inst_15427,inst_15428,null));
var inst_15430 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15409);
var inst_15431 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15429,inst_15430);
var state_15478__$1 = state_15478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15478__$1,(59),inst_15431);
} else {
if((state_val_15479 === (33))){
var inst_15359 = (state_15478[(10)]);
var inst_15373 = cljs.core.fn_QMARK_.call(null,inst_15359);
var inst_15374 = (!(inst_15373));
var state_15478__$1 = state_15478;
var statearr_15510_15606 = state_15478__$1;
(statearr_15510_15606[(2)] = inst_15374);

(statearr_15510_15606[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (13))){
var inst_15321 = (state_15478[(14)]);
var inst_15338 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_15321);
var state_15478__$1 = state_15478;
if(cljs.core.truth_(inst_15338)){
var statearr_15511_15607 = state_15478__$1;
(statearr_15511_15607[(1)] = (15));

} else {
var statearr_15512_15608 = state_15478__$1;
(statearr_15512_15608[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (22))){
var inst_15351 = (state_15478[(2)]);
var inst_15352 = fluree.db.util.async.throw_err.call(null,inst_15351);
var state_15478__$1 = state_15478;
var statearr_15513_15609 = state_15478__$1;
(statearr_15513_15609[(2)] = inst_15352);

(statearr_15513_15609[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (36))){
var inst_15319 = (state_15478[(7)]);
var inst_15320 = (state_15478[(8)]);
var inst_15322 = (state_15478[(9)]);
var inst_15359 = (state_15478[(10)]);
var inst_15385 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15386 = [inst_15320,inst_15359,inst_15319,inst_15322];
var inst_15387 = (new cljs.core.PersistentVector(null,4,(5),inst_15385,inst_15386,null));
var inst_15388 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15387,opts);
var state_15478__$1 = state_15478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15478__$1,(39),inst_15388);
} else {
if((state_val_15479 === (41))){
var inst_15320 = (state_15478[(8)]);
var state_15478__$1 = state_15478;
var statearr_15514_15610 = state_15478__$1;
(statearr_15514_15610[(2)] = inst_15320);

(statearr_15514_15610[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (43))){
var inst_15359 = (state_15478[(10)]);
var state_15478__$1 = state_15478;
var statearr_15515_15611 = state_15478__$1;
(statearr_15515_15611[(2)] = inst_15359);

(statearr_15515_15611[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (61))){
var inst_15359 = (state_15478[(10)]);
var state_15478__$1 = state_15478;
if(cljs.core.truth_(inst_15359)){
var statearr_15516_15612 = state_15478__$1;
(statearr_15516_15612[(1)] = (64));

} else {
var statearr_15517_15613 = state_15478__$1;
(statearr_15517_15613[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (29))){
var inst_15383 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
if(cljs.core.truth_(inst_15383)){
var statearr_15518_15614 = state_15478__$1;
(statearr_15518_15614[(1)] = (36));

} else {
var statearr_15519_15615 = state_15478__$1;
(statearr_15519_15615[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (44))){
var inst_15394 = (state_15478[(19)]);
var state_15478__$1 = state_15478;
var statearr_15520_15616 = state_15478__$1;
(statearr_15520_15616[(2)] = inst_15394);

(statearr_15520_15616[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (6))){
var inst_15320 = (state_15478[(8)]);
var inst_15325 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15320);
var inst_15326 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15325);
var state_15478__$1 = state_15478;
var statearr_15521_15617 = state_15478__$1;
(statearr_15521_15617[(2)] = inst_15326);

(statearr_15521_15617[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (28))){
var inst_15320 = (state_15478[(8)]);
var state_15478__$1 = state_15478;
var statearr_15522_15618 = state_15478__$1;
(statearr_15522_15618[(2)] = inst_15320);

(statearr_15522_15618[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (64))){
var inst_15319 = (state_15478[(7)]);
var inst_15320 = (state_15478[(8)]);
var inst_15322 = (state_15478[(9)]);
var inst_15359 = (state_15478[(10)]);
var inst_15448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15449 = [inst_15359,inst_15320,inst_15319,inst_15322];
var inst_15450 = (new cljs.core.PersistentVector(null,4,(5),inst_15448,inst_15449,null));
var inst_15451 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15450,opts);
var state_15478__$1 = state_15478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15478__$1,(67),inst_15451);
} else {
if((state_val_15479 === (51))){
var inst_15320 = (state_15478[(8)]);
var inst_15410 = (state_15478[(21)]);
var inst_15409 = (state_15478[(2)]);
var inst_15410__$1 = cljs.core._EQ_.call(null,"_id",inst_15320);
var state_15478__$1 = (function (){var statearr_15523 = state_15478;
(statearr_15523[(20)] = inst_15409);

(statearr_15523[(21)] = inst_15410__$1);

return statearr_15523;
})();
if(inst_15410__$1){
var statearr_15524_15619 = state_15478__$1;
(statearr_15524_15619[(1)] = (52));

} else {
var statearr_15525_15620 = state_15478__$1;
(statearr_15525_15620[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (25))){
var inst_15329 = (state_15478[(18)]);
var inst_15465 = (state_15478[(2)]);
var state_15478__$1 = (function (){var statearr_15526 = state_15478;
(statearr_15526[(12)] = inst_15465);

return statearr_15526;
})();
if(cljs.core.truth_(inst_15329)){
var statearr_15527_15621 = state_15478__$1;
(statearr_15527_15621[(1)] = (68));

} else {
var statearr_15528_15622 = state_15478__$1;
(statearr_15528_15622[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (34))){
var inst_15323 = (state_15478[(15)]);
var state_15478__$1 = state_15478;
var statearr_15529_15623 = state_15478__$1;
(statearr_15529_15623[(2)] = inst_15323);

(statearr_15529_15623[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (17))){
var inst_15357 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
var statearr_15530_15624 = state_15478__$1;
(statearr_15530_15624[(2)] = inst_15357);

(statearr_15530_15624[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (3))){
var inst_15476 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15478__$1,inst_15476);
} else {
if((state_val_15479 === (12))){
var inst_15321 = (state_15478[(14)]);
var state_15478__$1 = state_15478;
var statearr_15531_15625 = state_15478__$1;
(statearr_15531_15625[(2)] = inst_15321);

(statearr_15531_15625[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (2))){
var inst_15318 = (state_15478[(16)]);
var inst_15320 = (state_15478[(8)]);
var _ = (function (){var statearr_15532 = state_15478;
(statearr_15532[(4)] = cljs.core.cons.call(null,(5),(state_15478[(4)])));

return statearr_15532;
})();
var inst_15318__$1 = fparts;
var inst_15319 = cljs.core.nth.call(null,inst_15318__$1,(0),null);
var inst_15320__$1 = cljs.core.nth.call(null,inst_15318__$1,(1),null);
var inst_15321 = cljs.core.nth.call(null,inst_15318__$1,(2),null);
var inst_15322 = cljs.core.nth.call(null,inst_15318__$1,(3),null);
var inst_15323 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15320__$1);
var state_15478__$1 = (function (){var statearr_15533 = state_15478;
(statearr_15533[(14)] = inst_15321);

(statearr_15533[(15)] = inst_15323);

(statearr_15533[(7)] = inst_15319);

(statearr_15533[(16)] = inst_15318__$1);

(statearr_15533[(8)] = inst_15320__$1);

(statearr_15533[(9)] = inst_15322);

return statearr_15533;
})();
if(cljs.core.truth_(inst_15320__$1)){
var statearr_15534_15626 = state_15478__$1;
(statearr_15534_15626[(1)] = (6));

} else {
var statearr_15535_15627 = state_15478__$1;
(statearr_15535_15627[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (66))){
var inst_15457 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
var statearr_15536_15628 = state_15478__$1;
(statearr_15536_15628[(2)] = inst_15457);

(statearr_15536_15628[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (23))){
var inst_15319 = (state_15478[(7)]);
var inst_15320 = (state_15478[(8)]);
var inst_15322 = (state_15478[(9)]);
var inst_15359 = (state_15478[(10)]);
var inst_15361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15362 = [inst_15319,inst_15320,inst_15359,inst_15322];
var inst_15363 = (new cljs.core.PersistentVector(null,4,(5),inst_15361,inst_15362,null));
var inst_15364 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15363,opts);
var state_15478__$1 = state_15478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15478__$1,(26),inst_15364);
} else {
if((state_val_15479 === (47))){
var inst_15320 = (state_15478[(8)]);
var state_15478__$1 = state_15478;
if(cljs.core.truth_(inst_15320)){
var statearr_15537_15629 = state_15478__$1;
(statearr_15537_15629[(1)] = (60));

} else {
var statearr_15538_15630 = state_15478__$1;
(statearr_15538_15630[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (35))){
var inst_15377 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
var statearr_15539_15631 = state_15478__$1;
(statearr_15539_15631[(2)] = inst_15377);

(statearr_15539_15631[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (19))){
var inst_15321 = (state_15478[(14)]);
var inst_15320 = (state_15478[(8)]);
var inst_15347 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15320);
var inst_15348 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15347),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15321)].join('');
var inst_15349 = fluree.db.dbproto._tag_id.call(null,db,inst_15348);
var state_15478__$1 = state_15478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15478__$1,(22),inst_15349);
} else {
if((state_val_15479 === (57))){
var inst_15436 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
var statearr_15540_15632 = state_15478__$1;
(statearr_15540_15632[(2)] = inst_15436);

(statearr_15540_15632[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (68))){
var inst_15465 = (state_15478[(12)]);
var inst_15467 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_15465);
var state_15478__$1 = state_15478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15478__$1,(71),inst_15467);
} else {
if((state_val_15479 === (11))){
var inst_15334 = (state_15478[(17)]);
var inst_15334__$1 = (state_15478[(2)]);
var inst_15335 = cljs.core.not.call(null,inst_15334__$1);
var state_15478__$1 = (function (){var statearr_15542 = state_15478;
(statearr_15542[(17)] = inst_15334__$1);

return statearr_15542;
})();
if(inst_15335){
var statearr_15543_15633 = state_15478__$1;
(statearr_15543_15633[(1)] = (12));

} else {
var statearr_15544_15634 = state_15478__$1;
(statearr_15544_15634[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (9))){
var inst_15321 = (state_15478[(14)]);
var inst_15331 = typeof inst_15321 === 'string';
var state_15478__$1 = state_15478;
var statearr_15545_15635 = state_15478__$1;
(statearr_15545_15635[(2)] = inst_15331);

(statearr_15545_15635[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (5))){
var _ = (function (){var statearr_15546 = state_15478;
(statearr_15546[(4)] = cljs.core.rest.call(null,(state_15478[(4)])));

return statearr_15546;
})();
var state_15478__$1 = state_15478;
var ex15541 = (state_15478__$1[(2)]);
var statearr_15547_15636 = state_15478__$1;
(statearr_15547_15636[(5)] = ex15541);


if((ex15541 instanceof Error)){
var statearr_15548_15637 = state_15478__$1;
(statearr_15548_15637[(1)] = (4));

(statearr_15548_15637[(5)] = null);

} else {
throw ex15541;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (14))){
var inst_15319 = (state_15478[(7)]);
var inst_15359 = (state_15478[(2)]);
var state_15478__$1 = (function (){var statearr_15549 = state_15478;
(statearr_15549[(10)] = inst_15359);

return statearr_15549;
})();
if(cljs.core.truth_(inst_15319)){
var statearr_15550_15638 = state_15478__$1;
(statearr_15550_15638[(1)] = (23));

} else {
var statearr_15551_15639 = state_15478__$1;
(statearr_15551_15639[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (45))){
var inst_15398 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
var statearr_15552_15640 = state_15478__$1;
(statearr_15552_15640[(2)] = inst_15398);

(statearr_15552_15640[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (53))){
var inst_15410 = (state_15478[(21)]);
var state_15478__$1 = state_15478;
var statearr_15553_15641 = state_15478__$1;
(statearr_15553_15641[(2)] = inst_15410);

(statearr_15553_15641[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (26))){
var inst_15366 = (state_15478[(2)]);
var inst_15367 = fluree.db.util.async.throw_err.call(null,inst_15366);
var state_15478__$1 = state_15478;
var statearr_15554_15642 = state_15478__$1;
(statearr_15554_15642[(2)] = inst_15367);

(statearr_15554_15642[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (16))){
var inst_15321 = (state_15478[(14)]);
var inst_15345 = typeof inst_15321 === 'string';
var state_15478__$1 = state_15478;
if(cljs.core.truth_(inst_15345)){
var statearr_15555_15643 = state_15478__$1;
(statearr_15555_15643[(1)] = (19));

} else {
var statearr_15556_15644 = state_15478__$1;
(statearr_15556_15644[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (38))){
var inst_15463 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
var statearr_15557_15645 = state_15478__$1;
(statearr_15557_15645[(2)] = inst_15463);

(statearr_15557_15645[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (30))){
var inst_15323 = (state_15478[(15)]);
var state_15478__$1 = state_15478;
if(cljs.core.truth_(inst_15323)){
var statearr_15558_15646 = state_15478__$1;
(statearr_15558_15646[(1)] = (33));

} else {
var statearr_15559_15647 = state_15478__$1;
(statearr_15559_15647[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (10))){
var inst_15329 = (state_15478[(18)]);
var state_15478__$1 = state_15478;
var statearr_15560_15648 = state_15478__$1;
(statearr_15560_15648[(2)] = inst_15329);

(statearr_15560_15648[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (18))){
var inst_15342 = (state_15478[(2)]);
var inst_15343 = fluree.db.util.async.throw_err.call(null,inst_15342);
var state_15478__$1 = state_15478;
var statearr_15561_15649 = state_15478__$1;
(statearr_15561_15649[(2)] = inst_15343);

(statearr_15561_15649[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (52))){
var inst_15359 = (state_15478[(10)]);
var inst_15412 = cljs.core.int_QMARK_.call(null,inst_15359);
var state_15478__$1 = state_15478;
var statearr_15562_15650 = state_15478__$1;
(statearr_15562_15650[(2)] = inst_15412);

(statearr_15562_15650[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (67))){
var inst_15453 = (state_15478[(2)]);
var inst_15454 = fluree.db.util.async.throw_err.call(null,inst_15453);
var state_15478__$1 = state_15478;
var statearr_15563_15651 = state_15478__$1;
(statearr_15563_15651[(2)] = inst_15454);

(statearr_15563_15651[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (71))){
var inst_15469 = (state_15478[(2)]);
var inst_15470 = fluree.db.util.async.throw_err.call(null,inst_15469);
var state_15478__$1 = state_15478;
var statearr_15564_15652 = state_15478__$1;
(statearr_15564_15652[(2)] = inst_15470);

(statearr_15564_15652[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (42))){
var inst_15401 = (state_15478[(2)]);
var state_15478__$1 = state_15478;
if(cljs.core.truth_(inst_15401)){
var statearr_15565_15653 = state_15478__$1;
(statearr_15565_15653[(1)] = (46));

} else {
var statearr_15566_15654 = state_15478__$1;
(statearr_15566_15654[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (37))){
var inst_15320 = (state_15478[(8)]);
var state_15478__$1 = state_15478;
if(cljs.core.truth_(inst_15320)){
var statearr_15567_15655 = state_15478__$1;
(statearr_15567_15655[(1)] = (40));

} else {
var statearr_15568_15656 = state_15478__$1;
(statearr_15568_15656[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (63))){
var inst_15444 = (state_15478[(2)]);
var inst_15445 = fluree.db.util.async.throw_err.call(null,inst_15444);
var state_15478__$1 = state_15478;
var statearr_15569_15657 = state_15478__$1;
(statearr_15569_15657[(2)] = inst_15445);

(statearr_15569_15657[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (8))){
var inst_15329 = (state_15478[(18)]);
var inst_15329__$1 = (state_15478[(2)]);
var state_15478__$1 = (function (){var statearr_15570 = state_15478;
(statearr_15570[(18)] = inst_15329__$1);

return statearr_15570;
})();
if(cljs.core.truth_(inst_15329__$1)){
var statearr_15571_15658 = state_15478__$1;
(statearr_15571_15658[(1)] = (9));

} else {
var statearr_15572_15659 = state_15478__$1;
(statearr_15572_15659[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15479 === (49))){
var inst_15323 = (state_15478[(15)]);
var inst_15403 = (state_15478[(13)]);
var inst_15319 = (state_15478[(7)]);
var inst_15318 = (state_15478[(16)]);
var inst_15334 = (state_15478[(17)]);
var inst_15320 = (state_15478[(8)]);
var inst_15322 = (state_15478[(9)]);
var inst_15329 = (state_15478[(18)]);
var inst_15359 = (state_15478[(10)]);
var inst_15405 = (function (){var obj_fn = inst_15403;
var t = inst_15322;
var p = inst_15320;
var idx_predicate_QMARK_ = inst_15323;
var o = inst_15359;
var vec__15315 = inst_15318;
var tag_predicate_QMARK_ = inst_15329;
var temp__5751__auto__ = inst_15403;
var s = inst_15319;
var o_coerce_QMARK_ = inst_15334;
return (function (x){
var and__4251__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4251__auto__;
}
});
})();
var state_15478__$1 = state_15478;
var statearr_15573_15660 = state_15478__$1;
(statearr_15573_15660[(2)] = inst_15405);

(statearr_15573_15660[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2741__auto__ = null;
var fluree$db$query$range$state_machine__2741__auto____0 = (function (){
var statearr_15574 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15574[(0)] = fluree$db$query$range$state_machine__2741__auto__);

(statearr_15574[(1)] = (1));

return statearr_15574;
});
var fluree$db$query$range$state_machine__2741__auto____1 = (function (state_15478){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_15478);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e15575){var ex__2744__auto__ = e15575;
var statearr_15576_15661 = state_15478;
(statearr_15576_15661[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_15478[(4)]))){
var statearr_15577_15662 = state_15478;
(statearr_15577_15662[(1)] = cljs.core.first.call(null,(state_15478[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15663 = state_15478;
state_15478 = G__15663;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2741__auto__ = function(state_15478){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2741__auto____1.call(this,state_15478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2741__auto____0;
fluree$db$query$range$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2741__auto____1;
return fluree$db$query$range$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_15578 = f__2764__auto__.call(null);
(statearr_15578[(6)] = c__2763__auto__);

return statearr_15578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15665 = arguments.length;
switch (G__15665) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_15700){
var state_val_15701 = (state_15700[(1)]);
if((state_val_15701 === (7))){
var inst_15687 = cljs.core.pr_str.call(null,name);
var inst_15688 = ["Invalid collection name: ",inst_15687].join('');
var inst_15689 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15690 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15691 = cljs.core.PersistentHashMap.fromArrays(inst_15689,inst_15690);
var inst_15692 = cljs.core.ex_info.call(null,inst_15688,inst_15691);
var inst_15693 = (function(){throw inst_15692})();
var state_15700__$1 = state_15700;
var statearr_15702_15722 = state_15700__$1;
(statearr_15702_15722[(2)] = inst_15693);

(statearr_15702_15722[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15701 === (1))){
var state_15700__$1 = state_15700;
var statearr_15703_15723 = state_15700__$1;
(statearr_15703_15723[(2)] = null);

(statearr_15703_15723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15701 === (4))){
var inst_15666 = (state_15700[(2)]);
var state_15700__$1 = state_15700;
var statearr_15704_15724 = state_15700__$1;
(statearr_15704_15724[(2)] = inst_15666);

(statearr_15704_15724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15701 === (6))){
var inst_15672 = (state_15700[(7)]);
var inst_15674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15675 = fluree.db.flake.max_subject_id.call(null,inst_15672);
var inst_15676 = [inst_15675];
var inst_15677 = (new cljs.core.PersistentVector(null,1,(5),inst_15674,inst_15676,null));
var inst_15678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15679 = fluree.db.flake.min_subject_id.call(null,inst_15672);
var inst_15680 = [inst_15679];
var inst_15681 = (new cljs.core.PersistentVector(null,1,(5),inst_15678,inst_15680,null));
var inst_15682 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15677,cljs.core._LT__EQ_,inst_15681,opts);
var state_15700__$1 = state_15700;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15700__$1,(9),inst_15682);
} else {
if((state_val_15701 === (3))){
var inst_15698 = (state_15700[(2)]);
var state_15700__$1 = state_15700;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15700__$1,inst_15698);
} else {
if((state_val_15701 === (2))){
var inst_15672 = (state_15700[(7)]);
var _ = (function (){var statearr_15706 = state_15700;
(statearr_15706[(4)] = cljs.core.cons.call(null,(5),(state_15700[(4)])));

return statearr_15706;
})();
var inst_15672__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_15700__$1 = (function (){var statearr_15707 = state_15700;
(statearr_15707[(7)] = inst_15672__$1);

return statearr_15707;
})();
if(cljs.core.truth_(inst_15672__$1)){
var statearr_15708_15725 = state_15700__$1;
(statearr_15708_15725[(1)] = (6));

} else {
var statearr_15709_15726 = state_15700__$1;
(statearr_15709_15726[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15701 === (9))){
var inst_15684 = (state_15700[(2)]);
var inst_15685 = fluree.db.util.async.throw_err.call(null,inst_15684);
var state_15700__$1 = state_15700;
var statearr_15710_15727 = state_15700__$1;
(statearr_15710_15727[(2)] = inst_15685);

(statearr_15710_15727[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15701 === (5))){
var _ = (function (){var statearr_15711 = state_15700;
(statearr_15711[(4)] = cljs.core.rest.call(null,(state_15700[(4)])));

return statearr_15711;
})();
var state_15700__$1 = state_15700;
var ex15705 = (state_15700__$1[(2)]);
var statearr_15712_15728 = state_15700__$1;
(statearr_15712_15728[(5)] = ex15705);


var statearr_15713_15729 = state_15700__$1;
(statearr_15713_15729[(1)] = (4));

(statearr_15713_15729[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15701 === (8))){
var inst_15695 = (state_15700[(2)]);
var _ = (function (){var statearr_15714 = state_15700;
(statearr_15714[(4)] = cljs.core.rest.call(null,(state_15700[(4)])));

return statearr_15714;
})();
var state_15700__$1 = state_15700;
var statearr_15715_15730 = state_15700__$1;
(statearr_15715_15730[(2)] = inst_15695);

(statearr_15715_15730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2741__auto__ = null;
var fluree$db$query$range$state_machine__2741__auto____0 = (function (){
var statearr_15716 = [null,null,null,null,null,null,null,null];
(statearr_15716[(0)] = fluree$db$query$range$state_machine__2741__auto__);

(statearr_15716[(1)] = (1));

return statearr_15716;
});
var fluree$db$query$range$state_machine__2741__auto____1 = (function (state_15700){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_15700);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e15717){var ex__2744__auto__ = e15717;
var statearr_15718_15731 = state_15700;
(statearr_15718_15731[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_15700[(4)]))){
var statearr_15719_15732 = state_15700;
(statearr_15719_15732[(1)] = cljs.core.first.call(null,(state_15700[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15733 = state_15700;
state_15700 = G__15733;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2741__auto__ = function(state_15700){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2741__auto____1.call(this,state_15700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2741__auto____0;
fluree$db$query$range$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2741__auto____1;
return fluree$db$query$range$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_15720 = f__2764__auto__.call(null);
(statearr_15720[(6)] = c__2763__auto__);

return statearr_15720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15737 = flakes;
var vec__15738 = G__15737;
var seq__15739 = cljs.core.seq.call(null,vec__15738);
var first__15740 = cljs.core.first.call(null,seq__15739);
var seq__15739__$1 = cljs.core.next.call(null,seq__15739);
var flake_SINGLEQUOTE_ = first__15740;
var r = seq__15739__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15737__$1 = G__15737;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15746 = G__15737__$1;
var seq__15747 = cljs.core.seq.call(null,vec__15746);
var first__15748 = cljs.core.first.call(null,seq__15747);
var seq__15747__$1 = cljs.core.next.call(null,seq__15747);
var flake_SINGLEQUOTE___$1 = first__15748;
var r__$1 = seq__15747__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e15750){var e = e15750;
return null;
}})();
var map__15749 = cmd_map;
var map__15749__$1 = cljs.core.__destructure_map.call(null,map__15749);
var type = cljs.core.get.call(null,map__15749__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__15749__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__15749__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__15749__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__15749__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__15749__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15751 = r__$1;
var G__15752 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15737__$1 = G__15751;
result_STAR___$1 = G__15752;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15761 = blocks;
var vec__15762 = G__15761;
var seq__15763 = cljs.core.seq.call(null,vec__15762);
var first__15764 = cljs.core.first.call(null,seq__15763);
var seq__15763__$1 = cljs.core.next.call(null,seq__15763);
var block_SINGLEQUOTE_ = first__15764;
var r = seq__15763__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15761__$1 = G__15761;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15769 = G__15761__$1;
var seq__15770 = cljs.core.seq.call(null,vec__15769);
var first__15771 = cljs.core.first.call(null,seq__15770);
var seq__15770__$1 = cljs.core.next.call(null,seq__15770);
var block_SINGLEQUOTE___$1 = first__15771;
var r__$1 = seq__15770__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15772 = block_SINGLEQUOTE___$1;
var map__15772__$1 = cljs.core.__destructure_map.call(null,map__15772);
var block = cljs.core.get.call(null,map__15772__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__15772__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__15772__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__15761__$1,result_STAR___$1,map__15772,map__15772__$1,block,t,flakes,vec__15769,seq__15770,first__15771,seq__15770__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15761,vec__15762,seq__15763,first__15764,seq__15763__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15753_SHARP_){
var f = p1__15753_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__15761__$1,result_STAR___$1,map__15772,map__15772__$1,block,t,flakes,vec__15769,seq__15770,first__15771,seq__15770__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15761,vec__15762,seq__15763,first__15764,seq__15763__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__15761__$1,result_STAR___$1,map__15772,map__15772__$1,block,t,flakes,prev_hash,vec__15769,seq__15770,first__15771,seq__15770__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15761,vec__15762,seq__15763,first__15764,seq__15763__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15754_SHARP_){
var f = p1__15754_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__15761__$1,result_STAR___$1,map__15772,map__15772__$1,block,t,flakes,prev_hash,vec__15769,seq__15770,first__15771,seq__15770__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15761,vec__15762,seq__15763,first__15764,seq__15763__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__15761__$1,result_STAR___$1,map__15772,map__15772__$1,block,t,flakes,prev_hash,hash,vec__15769,seq__15770,first__15771,seq__15770__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15761,vec__15762,seq__15763,first__15764,seq__15763__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15755_SHARP_){
var f = p1__15755_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__15761__$1,result_STAR___$1,map__15772,map__15772__$1,block,t,flakes,prev_hash,hash,vec__15769,seq__15770,first__15771,seq__15770__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15761,vec__15762,seq__15763,first__15764,seq__15763__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__15761__$1,result_STAR___$1,map__15772,map__15772__$1,block,t,flakes,prev_hash,hash,instant,vec__15769,seq__15770,first__15771,seq__15770__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15761,vec__15762,seq__15763,first__15764,seq__15763__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15756_SHARP_){
var f = p1__15756_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__15761__$1,result_STAR___$1,map__15772,map__15772__$1,block,t,flakes,prev_hash,hash,instant,vec__15769,seq__15770,first__15771,seq__15770__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15761,vec__15762,seq__15763,first__15764,seq__15763__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__15761__$1,result_STAR___$1,map__15772,map__15772__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15769,seq__15770,first__15771,seq__15770__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15761,vec__15762,seq__15763,first__15764,seq__15763__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15757_SHARP_){
return cljs.core._EQ_.call(null,p1__15757_SHARP_.p,(106));
});})(G__15761__$1,result_STAR___$1,map__15772,map__15772__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15769,seq__15770,first__15771,seq__15770__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15761,vec__15762,seq__15763,first__15764,seq__15763__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__15773 = r__$1;
var G__15774 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15761__$1 = G__15773;
result_STAR___$1 = G__15774;
continue;
}
break;
}
});
