// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k27825,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__27829 = k27825;
var G__27829__$1 = (((G__27829 instanceof cljs.core.Keyword))?G__27829.fqn:null);
switch (G__27829__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27825,else__4505__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__27830){
var vec__27831 = p__27830;
var k__4526__auto__ = cljs.core.nth.call(null,vec__27831,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__27831,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27824){
var self__ = this;
var G__27824__$1 = this;
return (new cljs.core.RecordIter((0),G__27824__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27826,other27827){
var self__ = this;
var this27826__$1 = this;
return (((!((other27827 == null)))) && ((((this27826__$1.constructor === other27827.constructor)) && (((cljs.core._EQ_.call(null,this27826__$1.conn,other27827.conn)) && (((cljs.core._EQ_.call(null,this27826__$1.network,other27827.network)) && (((cljs.core._EQ_.call(null,this27826__$1.dbid,other27827.dbid)) && (((cljs.core._EQ_.call(null,this27826__$1.db_name,other27827.db_name)) && (((cljs.core._EQ_.call(null,this27826__$1.update_chan,other27827.update_chan)) && (((cljs.core._EQ_.call(null,this27826__$1.transact_chan,other27827.transact_chan)) && (((cljs.core._EQ_.call(null,this27826__$1.state,other27827.state)) && (((cljs.core._EQ_.call(null,this27826__$1.schema_cache,other27827.schema_cache)) && (((cljs.core._EQ_.call(null,this27826__$1.blank_db,other27827.blank_db)) && (((cljs.core._EQ_.call(null,this27826__$1.close,other27827.close)) && (((cljs.core._EQ_.call(null,this27826__$1.id,other27827.id)) && (cljs.core._EQ_.call(null,this27826__$1.__extmap,other27827.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k27825){
var self__ = this;
var this__4509__auto____$1 = this;
var G__27834 = k27825;
var G__27834__$1 = (((G__27834 instanceof cljs.core.Keyword))?G__27834.fqn:null);
switch (G__27834__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k27825);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__27824){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__27835 = cljs.core.keyword_identical_QMARK_;
var expr__27836 = k__4511__auto__;
if(cljs.core.truth_(pred__27835.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27836))){
return (new fluree.db.session.DbSession(G__27824,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27835.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27836))){
return (new fluree.db.session.DbSession(self__.conn,G__27824,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27835.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__27836))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27824,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27835.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__27836))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__27824,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27835.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__27836))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__27824,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27835.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__27836))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__27824,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27835.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__27836))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__27824,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27835.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27836))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27824,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27835.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__27836))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27824,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27835.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__27836))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27824,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27835.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__27836))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27824,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__27824),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__27824){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27824,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27828){
var extmap__4542__auto__ = (function (){var G__27838 = cljs.core.dissoc.call(null,G__27828,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__27828)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27838);
} else {
return G__27838;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27828),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27828),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27828),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27828),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27828),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27828),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27828),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27828),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27828),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27828),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27828),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27841 = session;
var map__27841__$1 = cljs.core.__destructure_map.call(null,map__27841);
var network = cljs.core.get.call(null,map__27841__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__27841__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.call(null);
var c__2763__auto___27992 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27944){
var state_val_27945 = (state_27944[(1)]);
if((state_val_27945 === (7))){
var inst_27862 = (state_27944[(7)]);
var inst_27867 = cljs.core.empty_QMARK_.call(null,inst_27862);
var state_27944__$1 = state_27944;
if(inst_27867){
var statearr_27946_27993 = state_27944__$1;
(statearr_27946_27993[(1)] = (10));

} else {
var statearr_27947_27994 = state_27944__$1;
(statearr_27947_27994[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (20))){
var inst_27893 = (state_27944[(8)]);
var inst_27853 = (state_27944[(9)]);
var inst_27854 = (state_27944[(10)]);
var inst_27855 = (state_27944[(11)]);
var inst_27898 = fluree.db.storage.core.read_block.call(null,inst_27853,inst_27854,inst_27855,inst_27893);
var state_27944__$1 = state_27944;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27944__$1,(22),inst_27898);
} else {
if((state_val_27945 === (27))){
var inst_27931 = (state_27944[(12)]);
var inst_27933 = (state_27944[(2)]);
var inst_27934 = fluree.db.util.async.throw_err.call(null,inst_27933);
var state_27944__$1 = (function (){var statearr_27948 = state_27944;
(statearr_27948[(13)] = inst_27934);

return statearr_27948;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27944__$1,(28),inst_27931);
} else {
if((state_val_27945 === (1))){
var state_27944__$1 = state_27944;
var statearr_27949_27995 = state_27944__$1;
(statearr_27949_27995[(2)] = null);

(statearr_27949_27995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (24))){
var inst_27893 = (state_27944[(8)]);
var inst_27854 = (state_27944[(10)]);
var inst_27855 = (state_27944[(11)]);
var inst_27915 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27893)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27854),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27855),"."].join('');
var inst_27916 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27917 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27918 = cljs.core.PersistentHashMap.fromArrays(inst_27916,inst_27917);
var inst_27919 = cljs.core.ex_info.call(null,inst_27915,inst_27918);
var inst_27920 = (function(){throw inst_27919})();
var state_27944__$1 = state_27944;
var statearr_27950_27996 = state_27944__$1;
(statearr_27950_27996[(2)] = inst_27920);

(statearr_27950_27996[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (4))){
var inst_27842 = (state_27944[(2)]);
var inst_27843 = cljs.core.async.put_BANG_.call(null,pc,inst_27842);
var state_27944__$1 = state_27944;
var statearr_27951_27997 = state_27944__$1;
(statearr_27951_27997[(2)] = inst_27843);

(statearr_27951_27997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (15))){
var state_27944__$1 = state_27944;
var statearr_27952_27998 = state_27944__$1;
(statearr_27952_27998[(2)] = null);

(statearr_27952_27998[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (21))){
var inst_27924 = (state_27944[(2)]);
var state_27944__$1 = state_27944;
var statearr_27953_27999 = state_27944__$1;
(statearr_27953_27999[(2)] = inst_27924);

(statearr_27953_27999[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (13))){
var inst_27887 = (state_27944[(14)]);
var inst_27862 = (state_27944[(7)]);
var inst_27886 = (state_27944[(2)]);
var inst_27887__$1 = fluree.db.util.async.throw_err.call(null,inst_27886);
var inst_27888 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27862);
var state_27944__$1 = (function (){var statearr_27954 = state_27944;
(statearr_27954[(14)] = inst_27887__$1);

(statearr_27954[(15)] = inst_27888);

return statearr_27954;
})();
if(cljs.core.truth_(inst_27887__$1)){
var statearr_27955_28000 = state_27944__$1;
(statearr_27955_28000[(1)] = (14));

} else {
var statearr_27956_28001 = state_27944__$1;
(statearr_27956_28001[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (22))){
var inst_27901 = (state_27944[(16)]);
var inst_27900 = (state_27944[(2)]);
var inst_27901__$1 = fluree.db.util.async.throw_err.call(null,inst_27900);
var state_27944__$1 = (function (){var statearr_27957 = state_27944;
(statearr_27957[(16)] = inst_27901__$1);

return statearr_27957;
})();
if(cljs.core.truth_(inst_27901__$1)){
var statearr_27958_28002 = state_27944__$1;
(statearr_27958_28002[(1)] = (23));

} else {
var statearr_27959_28003 = state_27944__$1;
(statearr_27959_28003[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (6))){
var inst_27862 = (state_27944[(7)]);
var inst_27861 = (state_27944[(2)]);
var inst_27862__$1 = fluree.db.util.async.throw_err.call(null,inst_27861);
var inst_27863 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27862__$1);
var inst_27864 = cljs.core.keyword.call(null,inst_27863);
var inst_27865 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),inst_27864);
var state_27944__$1 = (function (){var statearr_27960 = state_27944;
(statearr_27960[(7)] = inst_27862__$1);

return statearr_27960;
})();
if(inst_27865){
var statearr_27961_28004 = state_27944__$1;
(statearr_27961_28004[(1)] = (7));

} else {
var statearr_27962_28005 = state_27944__$1;
(statearr_27962_28005[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (28))){
var inst_27929 = (state_27944[(17)]);
var inst_27934 = (state_27944[(13)]);
var inst_27936 = (state_27944[(2)]);
var inst_27937 = fluree.db.util.async.throw_err.call(null,inst_27936);
var inst_27938 = cljs.core.assoc.call(null,inst_27929,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27934,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27937);
var inst_27939 = cljs.core.async.put_BANG_.call(null,pc,inst_27938);
var _ = (function (){var statearr_27963 = state_27944;
(statearr_27963[(4)] = cljs.core.rest.call(null,(state_27944[(4)])));

return statearr_27963;
})();
var state_27944__$1 = state_27944;
var statearr_27964_28006 = state_27944__$1;
(statearr_27964_28006[(2)] = inst_27939);

(statearr_27964_28006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (25))){
var inst_27922 = (state_27944[(2)]);
var state_27944__$1 = state_27944;
var statearr_27965_28007 = state_27944__$1;
(statearr_27965_28007[(2)] = inst_27922);

(statearr_27965_28007[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (17))){
var inst_27893 = (state_27944[(8)]);
var inst_27888 = (state_27944[(15)]);
var inst_27895 = (inst_27893 > inst_27888);
var state_27944__$1 = state_27944;
if(cljs.core.truth_(inst_27895)){
var statearr_27966_28008 = state_27944__$1;
(statearr_27966_28008[(1)] = (19));

} else {
var statearr_27967_28009 = state_27944__$1;
(statearr_27967_28009[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (3))){
var inst_27942 = (state_27944[(2)]);
var state_27944__$1 = state_27944;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27944__$1,inst_27942);
} else {
if((state_val_27945 === (12))){
var inst_27874 = (state_27944[(2)]);
var inst_27875 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27876 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27877 = cljs.core.PersistentHashMap.fromArrays(inst_27875,inst_27876);
var inst_27878 = cljs.core.ex_info.call(null,inst_27874,inst_27877);
var inst_27879 = (function(){throw inst_27878})();
var state_27944__$1 = state_27944;
var statearr_27968_28010 = state_27944__$1;
(statearr_27968_28010[(2)] = inst_27879);

(statearr_27968_28010[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (2))){
var inst_27853 = (state_27944[(9)]);
var inst_27854 = (state_27944[(10)]);
var inst_27855 = (state_27944[(11)]);
var _ = (function (){var statearr_27969 = state_27944;
(statearr_27969[(4)] = cljs.core.cons.call(null,(5),(state_27944[(4)])));

return statearr_27969;
})();
var inst_27850 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_27851 = session;
var inst_27852 = cljs.core.__destructure_map.call(null,inst_27851);
var inst_27853__$1 = cljs.core.get.call(null,inst_27852,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_27854__$1 = cljs.core.get.call(null,inst_27852,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_27855__$1 = cljs.core.get.call(null,inst_27852,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_27856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27857 = [inst_27854__$1,inst_27855__$1];
var inst_27858 = (new cljs.core.PersistentVector(null,2,(5),inst_27856,inst_27857,null));
var inst_27859 = fluree.db.operations.ledger_info_async.call(null,inst_27853__$1,inst_27858);
var state_27944__$1 = (function (){var statearr_27970 = state_27944;
(statearr_27970[(18)] = inst_27850);

(statearr_27970[(9)] = inst_27853__$1);

(statearr_27970[(10)] = inst_27854__$1);

(statearr_27970[(11)] = inst_27855__$1);

return statearr_27970;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27944__$1,(6),inst_27859);
} else {
if((state_val_27945 === (23))){
var inst_27901 = (state_27944[(16)]);
var inst_27892 = (state_27944[(19)]);
var inst_27904 = cljs.core.__destructure_map.call(null,inst_27901);
var inst_27905 = cljs.core.get.call(null,inst_27904,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27906 = cljs.core.get.call(null,inst_27904,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27907 = cljs.core.get.call(null,inst_27904,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27908 = fluree.db.dbproto._with.call(null,inst_27892,inst_27906,inst_27905);
var state_27944__$1 = (function (){var statearr_27971 = state_27944;
(statearr_27971[(20)] = inst_27907);

return statearr_27971;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27944__$1,(26),inst_27908);
} else {
if((state_val_27945 === (19))){
var inst_27892 = (state_27944[(19)]);
var state_27944__$1 = state_27944;
var statearr_27972_28011 = state_27944__$1;
(statearr_27972_28011[(2)] = inst_27892);

(statearr_27972_28011[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (11))){
var inst_27854 = (state_27944[(10)]);
var inst_27855 = (state_27944[(11)]);
var inst_27862 = (state_27944[(7)]);
var inst_27871 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27862);
var inst_27872 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27854),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27855)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27871),"."].join('');
var state_27944__$1 = state_27944;
var statearr_27974_28012 = state_27944__$1;
(statearr_27974_28012[(2)] = inst_27872);

(statearr_27974_28012[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (9))){
var inst_27850 = (state_27944[(18)]);
var inst_27853 = (state_27944[(9)]);
var inst_27854 = (state_27944[(10)]);
var inst_27855 = (state_27944[(11)]);
var inst_27862 = (state_27944[(7)]);
var inst_27882 = (state_27944[(2)]);
var inst_27883 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_27862);
var inst_27884 = fluree.db.storage.core.reify_db.call(null,inst_27853,inst_27854,inst_27855,inst_27850,inst_27883);
var state_27944__$1 = (function (){var statearr_27975 = state_27944;
(statearr_27975[(21)] = inst_27882);

return statearr_27975;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27944__$1,(13),inst_27884);
} else {
if((state_val_27945 === (5))){
var _ = (function (){var statearr_27976 = state_27944;
(statearr_27976[(4)] = cljs.core.rest.call(null,(state_27944[(4)])));

return statearr_27976;
})();
var state_27944__$1 = state_27944;
var ex27973 = (state_27944__$1[(2)]);
var statearr_27977_28013 = state_27944__$1;
(statearr_27977_28013[(5)] = ex27973);


var statearr_27978_28014 = state_27944__$1;
(statearr_27978_28014[(1)] = (4));

(statearr_27978_28014[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (14))){
var inst_27887 = (state_27944[(14)]);
var inst_27890 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27887);
var inst_27891 = (inst_27890 + (1));
var inst_27892 = inst_27887;
var inst_27893 = inst_27891;
var state_27944__$1 = (function (){var statearr_27979 = state_27944;
(statearr_27979[(8)] = inst_27893);

(statearr_27979[(19)] = inst_27892);

return statearr_27979;
})();
var statearr_27980_28015 = state_27944__$1;
(statearr_27980_28015[(2)] = null);

(statearr_27980_28015[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (26))){
var inst_27893 = (state_27944[(8)]);
var inst_27910 = (state_27944[(2)]);
var inst_27911 = fluree.db.util.async.throw_err.call(null,inst_27910);
var inst_27912 = (inst_27893 + (1));
var inst_27892 = inst_27911;
var inst_27893__$1 = inst_27912;
var state_27944__$1 = (function (){var statearr_27981 = state_27944;
(statearr_27981[(8)] = inst_27893__$1);

(statearr_27981[(19)] = inst_27892);

return statearr_27981;
})();
var statearr_27982_28016 = state_27944__$1;
(statearr_27982_28016[(2)] = null);

(statearr_27982_28016[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (16))){
var inst_27929 = (state_27944[(17)]);
var inst_27929__$1 = (state_27944[(2)]);
var inst_27930 = fluree.db.query.schema.schema_map.call(null,inst_27929__$1);
var inst_27931 = fluree.db.query.schema.setting_map.call(null,inst_27929__$1);
var state_27944__$1 = (function (){var statearr_27983 = state_27944;
(statearr_27983[(17)] = inst_27929__$1);

(statearr_27983[(12)] = inst_27931);

return statearr_27983;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27944__$1,(27),inst_27930);
} else {
if((state_val_27945 === (10))){
var inst_27854 = (state_27944[(10)]);
var inst_27855 = (state_27944[(11)]);
var inst_27869 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27854),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27855)," is not found on this ledger group."].join('');
var state_27944__$1 = state_27944;
var statearr_27984_28017 = state_27944__$1;
(statearr_27984_28017[(2)] = inst_27869);

(statearr_27984_28017[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (18))){
var inst_27926 = (state_27944[(2)]);
var state_27944__$1 = state_27944;
var statearr_27985_28018 = state_27944__$1;
(statearr_27985_28018[(2)] = inst_27926);

(statearr_27985_28018[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27945 === (8))){
var state_27944__$1 = state_27944;
var statearr_27986_28019 = state_27944__$1;
(statearr_27986_28019[(2)] = null);

(statearr_27986_28019[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2741__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2741__auto____0 = (function (){
var statearr_27987 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27987[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2741__auto__);

(statearr_27987[(1)] = (1));

return statearr_27987;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2741__auto____1 = (function (state_27944){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_27944);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27988){var ex__2744__auto__ = e27988;
var statearr_27989_28020 = state_27944;
(statearr_27989_28020[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_27944[(4)]))){
var statearr_27990_28021 = state_27944;
(statearr_27990_28021[(1)] = cljs.core.first.call(null,(state_27944[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28022 = state_27944;
state_27944 = G__28022;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2741__auto__ = function(state_27944){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2741__auto____1.call(this,state_27944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2741__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2741__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27991 = f__2764__auto__.call(null);
(statearr_27991[(6)] = c__2763__auto___27992);

return statearr_27991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.call(null,old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.call(null,new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.call(null,pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4747__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28024){
var state_val_28025 = (state_28024[(1)]);
if((state_val_28025 === (1))){
var state_28024__$1 = state_28024;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28024__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2741__auto__ = null;
var fluree$db$session$state_machine__2741__auto____0 = (function (){
var statearr_28026 = [null,null,null,null,null,null,null];
(statearr_28026[(0)] = fluree$db$session$state_machine__2741__auto__);

(statearr_28026[(1)] = (1));

return statearr_28026;
});
var fluree$db$session$state_machine__2741__auto____1 = (function (state_28024){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_28024);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28027){var ex__2744__auto__ = e28027;
var statearr_28028_28031 = state_28024;
(statearr_28028_28031[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_28024[(4)]))){
var statearr_28029_28032 = state_28024;
(statearr_28029_28032[(1)] = cljs.core.first.call(null,(state_28024[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28033 = state_28024;
state_28024 = G__28033;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$session$state_machine__2741__auto__ = function(state_28024){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2741__auto____1.call(this,state_28024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2741__auto____0;
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2741__auto____1;
return fluree$db$session$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28030 = f__2764__auto__.call(null);
(statearr_28030[(6)] = c__2763__auto__);

return statearr_28030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__28035){
var map__28036 = p__28035;
var map__28036__$1 = cljs.core.__destructure_map.call(null,map__28036);
var data = map__28036__$1;
var block = cljs.core.get.call(null,map__28036__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__28036__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__28036__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28095){
var state_val_28096 = (state_28095[(1)]);
if((state_val_28096 === (7))){
var inst_28047 = (state_28095[(7)]);
var inst_28050 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28051 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28052 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28050),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28051),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28047),". No-op."].join('');
var inst_28053 = fluree.db.util.log.info.call(null,inst_28052);
var state_28095__$1 = state_28095;
var statearr_28097_28131 = state_28095__$1;
(statearr_28097_28131[(2)] = inst_28053);

(statearr_28097_28131[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (1))){
var state_28095__$1 = state_28095;
var statearr_28098_28132 = state_28095__$1;
(statearr_28098_28132[(2)] = null);

(statearr_28098_28132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (4))){
var inst_28037 = (state_28095[(2)]);
var state_28095__$1 = state_28095;
var statearr_28099_28133 = state_28095__$1;
(statearr_28099_28133[(2)] = inst_28037);

(statearr_28099_28133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (15))){
var inst_28076 = (state_28095[(2)]);
var state_28095__$1 = state_28095;
var statearr_28100_28134 = state_28095__$1;
(statearr_28100_28134[(2)] = inst_28076);

(statearr_28100_28134[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (13))){
var inst_28067 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_28068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28069 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28070 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28071 = [inst_28069,inst_28070];
var inst_28072 = (new cljs.core.PersistentVector(null,2,(5),inst_28068,inst_28071,null));
var inst_28073 = fluree.db.conn_events.process_event.call(null,inst_28067,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_28072,data);
var state_28095__$1 = state_28095;
var statearr_28101_28135 = state_28095__$1;
(statearr_28101_28135[(2)] = inst_28073);

(statearr_28101_28135[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (6))){
var inst_28047 = (state_28095[(7)]);
var inst_28046 = (state_28095[(8)]);
var inst_28045 = (state_28095[(2)]);
var inst_28046__$1 = fluree.db.util.async.throw_err.call(null,inst_28045);
var inst_28047__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28046__$1);
var inst_28048 = (block <= inst_28047__$1);
var state_28095__$1 = (function (){var statearr_28102 = state_28095;
(statearr_28102[(7)] = inst_28047__$1);

(statearr_28102[(8)] = inst_28046__$1);

return statearr_28102;
})();
if(cljs.core.truth_(inst_28048)){
var statearr_28103_28136 = state_28095__$1;
(statearr_28103_28136[(1)] = (7));

} else {
var statearr_28104_28137 = state_28095__$1;
(statearr_28104_28137[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (17))){
var state_28095__$1 = state_28095;
var statearr_28105_28138 = state_28095__$1;
(statearr_28105_28138[(2)] = null);

(statearr_28105_28138[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (3))){
var inst_28093 = (state_28095[(2)]);
var state_28095__$1 = state_28095;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28095__$1,inst_28093);
} else {
if((state_val_28096 === (12))){
var inst_28088 = (state_28095[(2)]);
var state_28095__$1 = state_28095;
var statearr_28106_28139 = state_28095__$1;
(statearr_28106_28139[(2)] = inst_28088);

(statearr_28106_28139[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (2))){
var inst_28043 = (state_28095[(9)]);
var _ = (function (){var statearr_28107 = state_28095;
(statearr_28107[(4)] = cljs.core.cons.call(null,(5),(state_28095[(4)])));

return statearr_28107;
})();
var inst_28043__$1 = fluree.db.session.current_db.call(null,session);
var state_28095__$1 = (function (){var statearr_28108 = state_28095;
(statearr_28108[(9)] = inst_28043__$1);

return statearr_28108;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28095__$1,(6),inst_28043__$1);
} else {
if((state_val_28096 === (11))){
var state_28095__$1 = state_28095;
var statearr_28110_28140 = state_28095__$1;
(statearr_28110_28140[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (9))){
var inst_28090 = (state_28095[(2)]);
var _ = (function (){var statearr_28112 = state_28095;
(statearr_28112[(4)] = cljs.core.rest.call(null,(state_28095[(4)])));

return statearr_28112;
})();
var state_28095__$1 = state_28095;
var statearr_28113_28141 = state_28095__$1;
(statearr_28113_28141[(2)] = inst_28090);

(statearr_28113_28141[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (5))){
var _ = (function (){var statearr_28114 = state_28095;
(statearr_28114[(4)] = cljs.core.rest.call(null,(state_28095[(4)])));

return statearr_28114;
})();
var state_28095__$1 = state_28095;
var ex28109 = (state_28095__$1[(2)]);
var statearr_28115_28142 = state_28095__$1;
(statearr_28115_28142[(5)] = ex28109);


if((ex28109 instanceof Error)){
var statearr_28116_28143 = state_28095__$1;
(statearr_28116_28143[(1)] = (4));

(statearr_28116_28143[(5)] = null);

} else {
throw ex28109;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (14))){
var state_28095__$1 = state_28095;
var statearr_28117_28144 = state_28095__$1;
(statearr_28117_28144[(2)] = null);

(statearr_28117_28144[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (16))){
var inst_28047 = (state_28095[(7)]);
var inst_28079 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28080 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28081 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28079),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28080),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28047),". Forcing a db reload."].join('');
var inst_28082 = fluree.db.util.log.info.call(null,inst_28081);
var inst_28083 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_28095__$1 = (function (){var statearr_28118 = state_28095;
(statearr_28118[(10)] = inst_28082);

return statearr_28118;
})();
var statearr_28119_28145 = state_28095__$1;
(statearr_28119_28145[(2)] = inst_28083);

(statearr_28119_28145[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (10))){
var inst_28043 = (state_28095[(9)]);
var inst_28047 = (state_28095[(7)]);
var inst_28046 = (state_28095[(8)]);
var inst_28058 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28059 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28060 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28058),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28059),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_28061 = fluree.db.util.log.trace.call(null,inst_28060);
var inst_28062 = (function (){var current_db_ch = inst_28043;
var current_db = inst_28046;
var current_block = inst_28047;
return (function (p1__28034_SHARP_){
if((p1__28034_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__28034_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,p1__28034_SHARP_);
}
});
})();
var inst_28063 = cljs.core.map.call(null,inst_28062,flakes);
var inst_28064 = fluree.db.dbproto._with.call(null,inst_28046,block,inst_28063);
var inst_28065 = fluree.db.session.cas_db_BANG_.call(null,session,inst_28043,inst_28064);
var state_28095__$1 = (function (){var statearr_28120 = state_28095;
(statearr_28120[(11)] = inst_28061);

return statearr_28120;
})();
if(inst_28065){
var statearr_28121_28146 = state_28095__$1;
(statearr_28121_28146[(1)] = (13));

} else {
var statearr_28122_28147 = state_28095__$1;
(statearr_28122_28147[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (18))){
var inst_28086 = (state_28095[(2)]);
var state_28095__$1 = state_28095;
var statearr_28123_28148 = state_28095__$1;
(statearr_28123_28148[(2)] = inst_28086);

(statearr_28123_28148[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28096 === (8))){
var inst_28047 = (state_28095[(7)]);
var inst_28055 = ((1) + inst_28047);
var inst_28056 = cljs.core._EQ_.call(null,block,inst_28055);
var state_28095__$1 = state_28095;
if(inst_28056){
var statearr_28124_28149 = state_28095__$1;
(statearr_28124_28149[(1)] = (10));

} else {
var statearr_28125_28150 = state_28095__$1;
(statearr_28125_28150[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2741__auto__ = null;
var fluree$db$session$state_machine__2741__auto____0 = (function (){
var statearr_28126 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28126[(0)] = fluree$db$session$state_machine__2741__auto__);

(statearr_28126[(1)] = (1));

return statearr_28126;
});
var fluree$db$session$state_machine__2741__auto____1 = (function (state_28095){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_28095);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28127){var ex__2744__auto__ = e28127;
var statearr_28128_28151 = state_28095;
(statearr_28128_28151[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_28095[(4)]))){
var statearr_28129_28152 = state_28095;
(statearr_28129_28152[(1)] = cljs.core.first.call(null,(state_28095[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28153 = state_28095;
state_28095 = G__28153;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$session$state_machine__2741__auto__ = function(state_28095){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2741__auto____1.call(this,state_28095);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2741__auto____0;
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2741__auto____1;
return fluree$db$session$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28130 = f__2764__auto__.call(null);
(statearr_28130[(6)] = c__2763__auto__);

return statearr_28130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28160){
var state_val_28161 = (state_28160[(1)]);
if((state_val_28161 === (1))){
var inst_28154 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_28155 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28156 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28157 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28155),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28156)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_28158 = fluree.db.util.log.debug.call(null,inst_28157);
var state_28160__$1 = (function (){var statearr_28162 = state_28160;
(statearr_28162[(7)] = inst_28154);

(statearr_28162[(8)] = inst_28158);

return statearr_28162;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28160__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2741__auto__ = null;
var fluree$db$session$state_machine__2741__auto____0 = (function (){
var statearr_28163 = [null,null,null,null,null,null,null,null,null];
(statearr_28163[(0)] = fluree$db$session$state_machine__2741__auto__);

(statearr_28163[(1)] = (1));

return statearr_28163;
});
var fluree$db$session$state_machine__2741__auto____1 = (function (state_28160){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_28160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28164){var ex__2744__auto__ = e28164;
var statearr_28165_28168 = state_28160;
(statearr_28165_28168[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_28160[(4)]))){
var statearr_28166_28169 = state_28160;
(statearr_28166_28169[(1)] = cljs.core.first.call(null,(state_28160[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28170 = state_28160;
state_28160 = G__28170;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$session$state_machine__2741__auto__ = function(state_28160){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2741__auto____1.call(this,state_28160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2741__auto____0;
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2741__auto____1;
return fluree$db$session$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28167 = f__2764__auto__.call(null);
(statearr_28167[(6)] = c__2763__auto__);

return statearr_28167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__28172 = arguments.length;
switch (G__28172) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
var map__28173 = session;
var map__28173__$1 = cljs.core.__destructure_map.call(null,map__28173);
var conn = cljs.core.get.call(null,map__28173__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__28173__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__28173__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__28173__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__28173__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__28173__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.call(null,map__28173__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_.call(null,session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,dbid,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache.call(null,network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28227){
var state_val_28228 = (state_28227[(1)]);
if((state_val_28228 === (7))){
var inst_28223 = (state_28227[(2)]);
var state_28227__$1 = state_28227;
var statearr_28229_28260 = state_28227__$1;
(statearr_28229_28260[(2)] = inst_28223);

(statearr_28229_28260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (1))){
var state_28227__$1 = state_28227;
var statearr_28230_28261 = state_28227__$1;
(statearr_28230_28261[(2)] = null);

(statearr_28230_28261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (4))){
var inst_28178 = (state_28227[(7)]);
var inst_28177 = (state_28227[(2)]);
var inst_28178__$1 = fluree.db.util.async.throw_err.call(null,inst_28177);
var inst_28179 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_28180 = (inst_28178__$1 == null);
var state_28227__$1 = (function (){var statearr_28231 = state_28227;
(statearr_28231[(7)] = inst_28178__$1);

(statearr_28231[(8)] = inst_28179);

return statearr_28231;
})();
if(cljs.core.truth_(inst_28180)){
var statearr_28232_28262 = state_28227__$1;
(statearr_28232_28262[(1)] = (5));

} else {
var statearr_28233_28263 = state_28227__$1;
(statearr_28233_28263[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (15))){
var inst_28215 = (state_28227[(2)]);
var state_28227__$1 = (function (){var statearr_28234 = state_28227;
(statearr_28234[(9)] = inst_28215);

return statearr_28234;
})();
var statearr_28235_28264 = state_28227__$1;
(statearr_28235_28264[(2)] = null);

(statearr_28235_28264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (13))){
var inst_28219 = (state_28227[(2)]);
var state_28227__$1 = state_28227;
var statearr_28237_28265 = state_28227__$1;
(statearr_28237_28265[(2)] = inst_28219);

(statearr_28237_28265[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (6))){
var inst_28179 = (state_28227[(8)]);
var inst_28185 = (inst_28179 == null);
var state_28227__$1 = state_28227;
if(cljs.core.truth_(inst_28185)){
var statearr_28238_28266 = state_28227__$1;
(statearr_28238_28266[(1)] = (8));

} else {
var statearr_28239_28267 = state_28227__$1;
(statearr_28239_28267[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (17))){
var _ = (function (){var statearr_28240 = state_28227;
(statearr_28240[(4)] = cljs.core.rest.call(null,(state_28227[(4)])));

return statearr_28240;
})();
var state_28227__$1 = state_28227;
var ex28236 = (state_28227__$1[(2)]);
var statearr_28241_28268 = state_28227__$1;
(statearr_28241_28268[(5)] = ex28236);


var statearr_28242_28269 = state_28227__$1;
(statearr_28242_28269[(1)] = (16));

(statearr_28242_28269[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (3))){
var inst_28225 = (state_28227[(2)]);
var state_28227__$1 = state_28227;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28227__$1,inst_28225);
} else {
if((state_val_28228 === (12))){
var state_28227__$1 = state_28227;
var statearr_28243_28270 = state_28227__$1;
(statearr_28243_28270[(2)] = null);

(statearr_28243_28270[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (2))){
var state_28227__$1 = state_28227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28227__$1,(4),update_chan);
} else {
if((state_val_28228 === (11))){
var state_28227__$1 = state_28227;
var statearr_28244_28271 = state_28227__$1;
(statearr_28244_28271[(2)] = null);

(statearr_28244_28271[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (9))){
var state_28227__$1 = state_28227;
var statearr_28245_28272 = state_28227__$1;
(statearr_28245_28272[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (5))){
var inst_28182 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_28183 = fluree.db.util.log.info.call(null,inst_28182);
var state_28227__$1 = state_28227;
var statearr_28247_28273 = state_28227__$1;
(statearr_28247_28273[(2)] = inst_28183);

(statearr_28247_28273[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (14))){
var inst_28178 = (state_28227[(7)]);
var inst_28179 = (state_28227[(8)]);
var _ = (function (){var statearr_28248 = state_28227;
(statearr_28248[(4)] = cljs.core.cons.call(null,(17),(state_28227[(4)])));

return statearr_28248;
})();
var inst_28203 = cljs.core.nth.call(null,inst_28178,(0),null);
var inst_28204 = cljs.core.nth.call(null,inst_28178,(1),null);
var inst_28205 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_28206 = cljs.core.pr_str.call(null,inst_28178);
var inst_28207 = fluree.db.util.core.trunc.call(null,inst_28206,(200));
var inst_28208 = fluree.db.util.log.trace.call(null,inst_28205,inst_28207);
var inst_28209 = fluree.db.session.process_ledger_update.call(null,inst_28179,inst_28203,inst_28204);
var state_28227__$1 = (function (){var statearr_28249 = state_28227;
(statearr_28249[(10)] = inst_28208);

return statearr_28249;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28227__$1,(18),inst_28209);
} else {
if((state_val_28228 === (16))){
var inst_28178 = (state_28227[(7)]);
var inst_28193 = (state_28227[(2)]);
var inst_28194 = fluree.db.util.log.error.call(null,inst_28193,"Exception processing ledger updates for message: ",inst_28178);
var state_28227__$1 = state_28227;
var statearr_28250_28274 = state_28227__$1;
(statearr_28250_28274[(2)] = inst_28194);

(statearr_28250_28274[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (10))){
var inst_28221 = (state_28227[(2)]);
var state_28227__$1 = state_28227;
var statearr_28251_28275 = state_28227__$1;
(statearr_28251_28275[(2)] = inst_28221);

(statearr_28251_28275[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (18))){
var inst_28211 = (state_28227[(2)]);
var inst_28212 = fluree.db.util.async.throw_err.call(null,inst_28211);
var _ = (function (){var statearr_28252 = state_28227;
(statearr_28252[(4)] = cljs.core.rest.call(null,(state_28227[(4)])));

return statearr_28252;
})();
var state_28227__$1 = state_28227;
var statearr_28253_28276 = state_28227__$1;
(statearr_28253_28276[(2)] = inst_28212);

(statearr_28253_28276[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (8))){
var inst_28178 = (state_28227[(7)]);
var inst_28187 = cljs.core.first.call(null,inst_28178);
var inst_28188 = cljs.core.pr_str.call(null,inst_28187);
var inst_28189 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_28188].join('');
var inst_28190 = fluree.db.util.log.warn.call(null,inst_28189);
var state_28227__$1 = state_28227;
var statearr_28254_28277 = state_28227__$1;
(statearr_28254_28277[(2)] = inst_28190);

(statearr_28254_28277[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2741__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2741__auto____0 = (function (){
var statearr_28255 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28255[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2741__auto__);

(statearr_28255[(1)] = (1));

return statearr_28255;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2741__auto____1 = (function (state_28227){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_28227);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28256){var ex__2744__auto__ = e28256;
var statearr_28257_28278 = state_28227;
(statearr_28257_28278[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_28227[(4)]))){
var statearr_28258_28279 = state_28227;
(statearr_28258_28279[(1)] = cljs.core.first.call(null,(state_28227[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28280 = state_28227;
state_28227 = G__28280;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2741__auto__ = function(state_28227){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2741__auto____1.call(this,state_28227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2741__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2741__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28259 = f__2764__auto__.call(null);
(statearr_28259[(6)] = c__2763__auto__);

return statearr_28259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__28281){
var map__28282 = p__28281;
var map__28282__$1 = cljs.core.__destructure_map.call(null,map__28282);
var network = cljs.core.get.call(null,map__28282__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__28282__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.call(null,map__28282__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.call(null,map__28282__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.call(null,map__28282__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__28282__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__28282__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__28282__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__28282__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.call(null);
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return fluree.db.session.current_db.call(null,session);
});
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__28286 = block_result;
var map__28286__$1 = cljs.core.__destructure_map.call(null,map__28286);
var block = cljs.core.get.call(null,map__28286__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__28286__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__28286__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__28286__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__28286__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4253__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__28287 = tx_result;
var map__28287__$1 = cljs.core.__destructure_map.call(null,map__28287);
var t = cljs.core.get.call(null,map__28287__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__28287__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__28283_SHARP_){
return cljs.core._EQ_.call(null,t,p1__28283_SHARP_.t);
}):(function (p1__28284_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__28284_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__28285_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__28285_SHARP_))){
return cljs.core.nth.call(null,p1__28285_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__28288 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__28288,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__28288,(1),null);
var error = cljs.core.nth.call(null,vec__28288,(2),null);
var message = cljs.core.nth.call(null,vec__28288,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__4253__auto__ = message;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));
var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__28292 = arguments.length;
switch (G__28292) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__28293){
var map__28294 = p__28293;
var map__28294__$1 = cljs.core.__destructure_map.call(null,map__28294);
var state = cljs.core.get.call(null,map__28294__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__28294__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__28294__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__28294__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__28295 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__28295,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__28295,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__28295,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4253__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4253__auto____$1 = state;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5753__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__28298 = cljs.core.seq.call(null,tids);
var chunk__28299 = null;
var count__28300 = (0);
var i__28301 = (0);
while(true){
if((i__28301 < count__28300)){
var tid = cljs.core._nth.call(null,chunk__28299,i__28301);
var temp__5753__auto___28414__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5753__auto___28414__$1)){
var keyed_callbacks_28415 = temp__5753__auto___28414__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_28416 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__28342_28417 = cljs.core.seq.call(null,keyed_callbacks_28415);
var chunk__28343_28418 = null;
var count__28344_28419 = (0);
var i__28345_28420 = (0);
while(true){
if((i__28345_28420 < count__28344_28419)){
var vec__28354_28421 = cljs.core._nth.call(null,chunk__28343_28418,i__28345_28420);
var k_28422 = cljs.core.nth.call(null,vec__28354_28421,(0),null);
var f_28423 = cljs.core.nth.call(null,vec__28354_28421,(1),null);
try{f_28423.call(null,tx_response_28416);
}catch (e28357){var e_28424 = e28357;
fluree.db.util.log.error.call(null,e_28424,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__28425 = seq__28342_28417;
var G__28426 = chunk__28343_28418;
var G__28427 = count__28344_28419;
var G__28428 = (i__28345_28420 + (1));
seq__28342_28417 = G__28425;
chunk__28343_28418 = G__28426;
count__28344_28419 = G__28427;
i__28345_28420 = G__28428;
continue;
} else {
var temp__5753__auto___28429__$2 = cljs.core.seq.call(null,seq__28342_28417);
if(temp__5753__auto___28429__$2){
var seq__28342_28430__$1 = temp__5753__auto___28429__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28342_28430__$1)){
var c__4679__auto___28431 = cljs.core.chunk_first.call(null,seq__28342_28430__$1);
var G__28432 = cljs.core.chunk_rest.call(null,seq__28342_28430__$1);
var G__28433 = c__4679__auto___28431;
var G__28434 = cljs.core.count.call(null,c__4679__auto___28431);
var G__28435 = (0);
seq__28342_28417 = G__28432;
chunk__28343_28418 = G__28433;
count__28344_28419 = G__28434;
i__28345_28420 = G__28435;
continue;
} else {
var vec__28358_28436 = cljs.core.first.call(null,seq__28342_28430__$1);
var k_28437 = cljs.core.nth.call(null,vec__28358_28436,(0),null);
var f_28438 = cljs.core.nth.call(null,vec__28358_28436,(1),null);
try{f_28438.call(null,tx_response_28416);
}catch (e28361){var e_28439 = e28361;
fluree.db.util.log.error.call(null,e_28439,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__28440 = cljs.core.next.call(null,seq__28342_28430__$1);
var G__28441 = null;
var G__28442 = (0);
var G__28443 = (0);
seq__28342_28417 = G__28440;
chunk__28343_28418 = G__28441;
count__28344_28419 = G__28442;
i__28345_28420 = G__28443;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28444 = seq__28298;
var G__28445 = chunk__28299;
var G__28446 = count__28300;
var G__28447 = (i__28301 + (1));
seq__28298 = G__28444;
chunk__28299 = G__28445;
count__28300 = G__28446;
i__28301 = G__28447;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq.call(null,seq__28298);
if(temp__5753__auto____$1){
var seq__28298__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28298__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__28298__$1);
var G__28448 = cljs.core.chunk_rest.call(null,seq__28298__$1);
var G__28449 = c__4679__auto__;
var G__28450 = cljs.core.count.call(null,c__4679__auto__);
var G__28451 = (0);
seq__28298 = G__28448;
chunk__28299 = G__28449;
count__28300 = G__28450;
i__28301 = G__28451;
continue;
} else {
var tid = cljs.core.first.call(null,seq__28298__$1);
var temp__5753__auto___28452__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5753__auto___28452__$2)){
var keyed_callbacks_28453 = temp__5753__auto___28452__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_28454 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__28362_28455 = cljs.core.seq.call(null,keyed_callbacks_28453);
var chunk__28363_28456 = null;
var count__28364_28457 = (0);
var i__28365_28458 = (0);
while(true){
if((i__28365_28458 < count__28364_28457)){
var vec__28374_28459 = cljs.core._nth.call(null,chunk__28363_28456,i__28365_28458);
var k_28460 = cljs.core.nth.call(null,vec__28374_28459,(0),null);
var f_28461 = cljs.core.nth.call(null,vec__28374_28459,(1),null);
try{f_28461.call(null,tx_response_28454);
}catch (e28377){var e_28462 = e28377;
fluree.db.util.log.error.call(null,e_28462,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__28463 = seq__28362_28455;
var G__28464 = chunk__28363_28456;
var G__28465 = count__28364_28457;
var G__28466 = (i__28365_28458 + (1));
seq__28362_28455 = G__28463;
chunk__28363_28456 = G__28464;
count__28364_28457 = G__28465;
i__28365_28458 = G__28466;
continue;
} else {
var temp__5753__auto___28467__$3 = cljs.core.seq.call(null,seq__28362_28455);
if(temp__5753__auto___28467__$3){
var seq__28362_28468__$1 = temp__5753__auto___28467__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28362_28468__$1)){
var c__4679__auto___28469 = cljs.core.chunk_first.call(null,seq__28362_28468__$1);
var G__28470 = cljs.core.chunk_rest.call(null,seq__28362_28468__$1);
var G__28471 = c__4679__auto___28469;
var G__28472 = cljs.core.count.call(null,c__4679__auto___28469);
var G__28473 = (0);
seq__28362_28455 = G__28470;
chunk__28363_28456 = G__28471;
count__28364_28457 = G__28472;
i__28365_28458 = G__28473;
continue;
} else {
var vec__28378_28474 = cljs.core.first.call(null,seq__28362_28468__$1);
var k_28475 = cljs.core.nth.call(null,vec__28378_28474,(0),null);
var f_28476 = cljs.core.nth.call(null,vec__28378_28474,(1),null);
try{f_28476.call(null,tx_response_28454);
}catch (e28381){var e_28477 = e28381;
fluree.db.util.log.error.call(null,e_28477,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__28478 = cljs.core.next.call(null,seq__28362_28468__$1);
var G__28479 = null;
var G__28480 = (0);
var G__28481 = (0);
seq__28362_28455 = G__28478;
chunk__28363_28456 = G__28479;
count__28364_28457 = G__28480;
i__28365_28458 = G__28481;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28482 = cljs.core.next.call(null,seq__28298__$1);
var G__28483 = null;
var G__28484 = (0);
var G__28485 = (0);
seq__28298 = G__28482;
chunk__28299 = G__28483;
count__28300 = G__28484;
i__28301 = G__28485;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28486 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2763__auto___28487 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28398){
var state_val_28399 = (state_28398[(1)]);
if((state_val_28399 === (1))){
var state_28398__$1 = state_28398;
var statearr_28400_28488 = state_28398__$1;
(statearr_28400_28488[(2)] = null);

(statearr_28400_28488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28399 === (2))){
var inst_28383 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_28398__$1 = state_28398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28398__$1,(4),inst_28383);
} else {
if((state_val_28399 === (3))){
var inst_28396 = (state_28398[(2)]);
var state_28398__$1 = state_28398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28398__$1,inst_28396);
} else {
if((state_val_28399 === (4))){
var inst_28385 = (state_28398[(7)]);
var inst_28385__$1 = (state_28398[(2)]);
var inst_28386 = (inst_28385__$1 == null);
var state_28398__$1 = (function (){var statearr_28401 = state_28398;
(statearr_28401[(7)] = inst_28385__$1);

return statearr_28401;
})();
if(cljs.core.truth_(inst_28386)){
var statearr_28402_28489 = state_28398__$1;
(statearr_28402_28489[(1)] = (5));

} else {
var statearr_28403_28490 = state_28398__$1;
(statearr_28403_28490[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28399 === (5))){
var inst_28388 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_28389 = fluree.db.util.log.info.call(null,inst_28388);
var state_28398__$1 = state_28398;
var statearr_28404_28491 = state_28398__$1;
(statearr_28404_28491[(2)] = inst_28389);

(statearr_28404_28491[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28399 === (6))){
var inst_28385 = (state_28398[(7)]);
var inst_28391 = transact_handler_28486.call(null,conn,inst_28385);
var state_28398__$1 = (function (){var statearr_28405 = state_28398;
(statearr_28405[(8)] = inst_28391);

return statearr_28405;
})();
var statearr_28406_28492 = state_28398__$1;
(statearr_28406_28492[(2)] = null);

(statearr_28406_28492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28399 === (7))){
var inst_28394 = (state_28398[(2)]);
var state_28398__$1 = state_28398;
var statearr_28407_28493 = state_28398__$1;
(statearr_28407_28493[(2)] = inst_28394);

(statearr_28407_28493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2741__auto__ = null;
var fluree$db$session$state_machine__2741__auto____0 = (function (){
var statearr_28408 = [null,null,null,null,null,null,null,null,null];
(statearr_28408[(0)] = fluree$db$session$state_machine__2741__auto__);

(statearr_28408[(1)] = (1));

return statearr_28408;
});
var fluree$db$session$state_machine__2741__auto____1 = (function (state_28398){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_28398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28409){var ex__2744__auto__ = e28409;
var statearr_28410_28494 = state_28398;
(statearr_28410_28494[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_28398[(4)]))){
var statearr_28411_28495 = state_28398;
(statearr_28411_28495[(1)] = cljs.core.first.call(null,(state_28398[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28496 = state_28398;
state_28398 = G__28496;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$session$state_machine__2741__auto__ = function(state_28398){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2741__auto____1.call(this,state_28398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2741__auto____0;
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2741__auto____1;
return fluree$db$session$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28412 = f__2764__auto__.call(null);
(statearr_28412[(6)] = c__2763__auto___28487);

return statearr_28412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(p__28498){
var map__28499 = p__28498;
var map__28499__$1 = cljs.core.__destructure_map.call(null,map__28499);
var session = map__28499__$1;
var state = cljs.core.get.call(null,map__28499__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.call(null,state,(function (p1__28497_SHARP_){
return cljs.core.assoc.call(null,p1__28497_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__28497_SHARP_) + (1)));
}));

var or__4253__auto__ = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var _ = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);
var new_state = cljs.core.swap_BANG_.call(null,state,(function (st){
if(cljs.core.truth_(new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(st))){
return st;
} else {
return cljs.core.assoc.call(null,st,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
}
}));
return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state);
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28502 = arguments.length;
switch (G__28502) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28503 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__28500_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__28500_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28503);
} else {
return G__28503;
}
})();
var seq__28504 = cljs.core.seq.call(null,sessions);
var chunk__28505 = null;
var count__28506 = (0);
var i__28507 = (0);
while(true){
if((i__28507 < count__28506)){
var session = cljs.core._nth.call(null,chunk__28505,i__28507);
fluree.db.session.close.call(null,session);


var G__28509 = seq__28504;
var G__28510 = chunk__28505;
var G__28511 = count__28506;
var G__28512 = (i__28507 + (1));
seq__28504 = G__28509;
chunk__28505 = G__28510;
count__28506 = G__28511;
i__28507 = G__28512;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__28504);
if(temp__5753__auto__){
var seq__28504__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28504__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__28504__$1);
var G__28513 = cljs.core.chunk_rest.call(null,seq__28504__$1);
var G__28514 = c__4679__auto__;
var G__28515 = cljs.core.count.call(null,c__4679__auto__);
var G__28516 = (0);
seq__28504 = G__28513;
chunk__28505 = G__28514;
count__28506 = G__28515;
i__28507 = G__28516;
continue;
} else {
var session = cljs.core.first.call(null,seq__28504__$1);
fluree.db.session.close.call(null,session);


var G__28517 = cljs.core.next.call(null,seq__28504__$1);
var G__28518 = null;
var G__28519 = (0);
var G__28520 = (0);
seq__28504 = G__28517;
chunk__28505 = G__28518;
count__28506 = G__28519;
i__28507 = G__28520;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
