// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('flureenjs');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.auth');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.flake');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.operations');
goog.require('fluree.db.permissions');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.graphql_parser');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.sparql_parser');
goog.require('fluree.db.query.sql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.nodejs');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.api_js');
goog.require('cljs.js');
goog.require('cljs.analyzer');
goog.require('cljs.env');
goog.require('cljs.compiler');
cljs.nodejs.enable_util_print_BANG_.call(null);
flureenjs._init_state = (function flureenjs$_init_state(state){
return cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"rename-macros","rename-macros",1076432512),new cljs.core.Keyword(null,"renames","renames",343278368),new cljs.core.Keyword(null,"use-macros","use-macros",-905638393),new cljs.core.Keyword(null,"excludes","excludes",-1791725945),new cljs.core.Keyword(null,"macros","macros",811339431),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"imports","imports",-1249933394),new cljs.core.Keyword(null,"requires","requires",-1201390927),new cljs.core.Keyword("cljs.spec","speced-vars","cljs.spec/speced-vars",1010010387),new cljs.core.Keyword(null,"uses","uses",232664692),new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.Keyword("cljs.spec","registry-ref","cljs.spec/registry-ref",-71711915),new cljs.core.Keyword(null,"require-macros","require-macros",707947416),new cljs.core.Keyword("cljs.analyzer","constants","cljs.analyzer/constants",1697083770),new cljs.core.Keyword(null,"doc","doc",1913296891)],[cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 34, [new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"null",new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"null",new cljs.core.Symbol(null,"subs","subs",1453849536,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"dec","dec",-766002333,null),"null",new cljs.core.Symbol(null,"<","<",993667236,null),"null",new cljs.core.Symbol(null,"<=","<=",1244895369,null),"null",new cljs.core.Symbol(null,"*","*",345799209,null),"null",new cljs.core.Symbol(null,"min","min",2085523049,null),"null",new cljs.core.Symbol(null,"get","get",-971253014,null),"null",new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"null",new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"null",new cljs.core.Symbol(null,"not=","not=",1466536204,null),"null",new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"null",new cljs.core.Symbol(null,">",">",1085014381,null),"null",new cljs.core.Symbol(null,"mod","mod",1510044207,null),"null",new cljs.core.Symbol(null,"-","-",-471816912,null),"null",new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"null",new cljs.core.Symbol(null,"or","or",1876275696,null),"null",new cljs.core.Symbol(null,"rem","rem",664046770,null),"null",new cljs.core.Symbol(null,"nth","nth",1529209554,null),"null",new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"null",new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"null",new cljs.core.Symbol(null,"not","not",1044554643,null),"null",new cljs.core.Symbol(null,"/","/",-1371932971,null),"null",new cljs.core.Symbol(null,">=",">=",1016916022,null),"null",new cljs.core.Symbol(null,"inc","inc",324505433,null),"null",new cljs.core.Symbol(null,"+","+",-740910886,null),"null",new cljs.core.Symbol(null,"str","str",-1564826950,null),"null",new cljs.core.Symbol(null,"max","max",1701898075,null),"null",new cljs.core.Symbol(null,"==","==",-234118149,null),"null",new cljs.core.Symbol(null,"count","count",-514511684,null),"null",new cljs.core.Symbol(null,"and","and",668631710,null),"null",new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"null"], null), null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block.",new cljs.core.Keyword(null,"line","line",212345235),14,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null)], null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"log","log",45015523,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fdb","fdb",-1644172664,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"util","util",1147903249,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)],[new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.with_meta(new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Finds the maximum predicate value.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(30)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"query","query",352022017,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Executes a query",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Fuel required for query"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the flakes from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerce to boolean. Everything except false and nil is true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Decrements any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the floor of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?o","?o",-1814741084,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the object of an predicate from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(1)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objF","objF",-104129083,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all false flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the ceiling of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"add-stack","add-stack",1221952039,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns product of all the numbers in the sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in *"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets min value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get","get",-971253014,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets a value from an subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the most recent object of an predicate, as of the previous block",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if empty or #{nil}, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Quot[ient] of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"now","now",-9994004,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns current epoch milliseconds on the executing machine.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if two (or more) values are not equal.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"raise","raise",1824672588,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates test.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Modulus of num and div. Truncates toward negative infinity.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string lower case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns difference of all the numbers in the sequence with the first number as the minuend.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in -"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a hash-set of values",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of items in hash-set"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if any in the sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in or"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether an email is valid, based on its pattern",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"coerce-args","coerce-args",494321873,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?s","?s",456183954,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remainder of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nth","nth",1529209554,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the nth item in a collection",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in collection"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if nil, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cas","cas",1188988307,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Does a compare and set/swap operation as a transaction function.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(20)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Execute a re-find operation of regex pattern on provided string.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a boolean, true returns false, false returns true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string upper-case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Increments any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns sum of each argument.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in +"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenates all in sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objT","objT",1212205659,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all true flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets max value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if arguments in sequence equal each other.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in count"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Follows an subject down the provided path and returns a set of all matching subjects.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + length of path"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?p","?p",-10896580,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate predicates",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"stack","stack",847125597,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current auth _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current user _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether there is a relationship between two subjects",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if all in a sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in and"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,779,null,779,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,779,null,new cljs.core.Symbol(null,"any","any",-948528346,null),779,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,7,522,null,522,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),null,cljs.core.list(null,null),1,false,522,null,new cljs.core.Symbol(null,"any","any",-948528346,null),522,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,7,348,null,348,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns true if key is present.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,348,null,new cljs.core.Symbol(null,"any","any",-948528346,null),348,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns true if key is present.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,135,null,135,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,135,null,new cljs.core.Symbol(null,"any","any",-948528346,null),135,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,480,null,480,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),"Executes a query","Fuel required for query"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),null,6,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),480,null,480,6,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query","Fuel required for query"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,7,751,null,751,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,751,null,new cljs.core.Symbol(null,"any","any",-948528346,null),751,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,660,null,660,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),1,false,660,null,new cljs.core.Symbol(null,"any","any",-948528346,null),660,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,546,null,546,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,546,null,new cljs.core.Symbol(null,"any","any",-948528346,null),546,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,402,null,402,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),402,null,new cljs.core.Symbol(null,"any","any",-948528346,null),402,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,7,801,null,801,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,801,null,new cljs.core.Symbol(null,"any","any",-948528346,null),801,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,7,290,null,290,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,290,null,new cljs.core.Symbol(null,"any","any",-948528346,null),290,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,171,null,171,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,171,null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),171,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,739,null,739,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,739,null,new cljs.core.Symbol(null,"any","any",-948528346,null),739,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,789,null,789,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,789,null,new cljs.core.Symbol(null,"any","any",-948528346,null),789,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),41,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),41,new cljs.core.Keyword(null,"end-column","end-column",1425389514),17,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","add-stack","fluree.db.dbfunctions.fns/add-stack",-218303854,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null)),null,cljs.core.list(null,null),1,false,41,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),41,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),"Adds an entry to the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,415,null,415,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),415,null,new cljs.core.Symbol(null,"any","any",-948528346,null),415,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,595,null,595,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),595,null,new cljs.core.Symbol(null,"any","any",-948528346,null),595,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,467,null,467,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets min value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),467,null,new cljs.core.Symbol(null,"any","any",-948528346,null),467,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,272,null,272,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),null,cljs.core.list(null,null),1,false,272,null,new cljs.core.Symbol(null,"any","any",-948528346,null),272,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,302,null,302,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,302,null,new cljs.core.Symbol(null,"any","any",-948528346,null),302,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,7,111,null,111,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,111,null,new cljs.core.Symbol(null,"any","any",-948528346,null),111,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,621,null,621,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,621,null,new cljs.core.Symbol(null,"any","any",-948528346,null),621,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,559,null,559,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,559,null,new cljs.core.Symbol(null,"any","any",-948528346,null),559,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,441,null,441,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),441,null,new cljs.core.Symbol(null,"any","any",-948528346,null),441,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),52,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),52,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","raise","fluree.db.dbfunctions.fns/raise",-2030365545,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null)),null,cljs.core.list(null,null),1,false,52,new cljs.core.Symbol(null,"ignore","ignore",8989494,null),52,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),"Throws an exception with the provided message."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,75,null,75,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),null,cljs.core.list(null,null),1,false,75,null,new cljs.core.Symbol(null,"any","any",-948528346,null),75,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,763,null,763,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),null,3,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),763,null,763,3,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,389,null,389,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),389,null,new cljs.core.Symbol(null,"any","any",-948528346,null),389,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,634,null,634,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,634,null,new cljs.core.Symbol(null,"any","any",-948528346,null),634,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,7,147,null,147,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,147,null,new cljs.core.Symbol(null,"any","any",-948528346,null),147,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,582,null,582,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),582,null,new cljs.core.Symbol(null,"any","any",-948528346,null),582,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,362,null,362,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns a hash-set of values","9 + count of items in hash-set"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),362,null,new cljs.core.Symbol(null,"any","any",-948528346,null),362,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values","9 + count of items in hash-set"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,245,null,245,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),245,null,new cljs.core.Symbol(null,"any","any",-948528346,null),245,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,7,685,null,685,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),null,cljs.core.list(null,null),1,false,685,null,new cljs.core.Symbol(null,"any","any",-948528346,null),685,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),22,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),22,new cljs.core.Keyword(null,"end-column","end-column",1425389514),19,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","coerce-args","fluree.db.dbfunctions.fns/coerce-args",1196396954,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,22,new cljs.core.Symbol(null,"any","any",-948528346,null),22,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,203,null,203,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),203,null,203,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,647,null,647,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,647,null,new cljs.core.Symbol(null,"any","any",-948528346,null),647,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,60,null,60,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,60,null,new cljs.core.Symbol(null,"any","any",-948528346,null),60,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,88,null,88,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,88,null,new cljs.core.Symbol(null,"any","any",-948528346,null),88,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,813,null,813,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),null,cljs.core.list(null,null),1,false,813,null,new cljs.core.Symbol(null,"any","any",-948528346,null),813,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,672,null,672,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),null,cljs.core.list(null,null),1,false,672,null,new cljs.core.Symbol(null,"any","any",-948528346,null),672,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,100,null,100,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,100,null,new cljs.core.Symbol(null,"any","any",-948528346,null),100,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword(null,"file","file",-1269645878),null], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),608,null,new cljs.core.Symbol(null,"any","any",-948528346,null),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence","9 + count of numbers in /"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,428,null,428,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),428,null,new cljs.core.Symbol(null,"any","any",-948528346,null),428,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,7,159,null,159,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,159,null,new cljs.core.Symbol(null,"any","any",-948528346,null),159,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,534,null,534,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,534,null,new cljs.core.Symbol(null,"any","any",-948528346,null),534,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,569,null,569,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns sum of each argument.","9 + count of numbers in +"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),569,null,new cljs.core.Symbol(null,"any","any",-948528346,null),569,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.","9 + count of numbers in +"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,123,null,123,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Concatenates all in sequence.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),123,null,new cljs.core.Symbol(null,"any","any",-948528346,null),123,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,727,null,727,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,727,null,new cljs.core.Symbol(null,"any","any",-948528346,null),727,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,454,null,454,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets max value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),454,null,new cljs.core.Symbol(null,"any","any",-948528346,null),454,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,376,null,376,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),376,null,new cljs.core.Symbol(null,"any","any",-948528346,null),376,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,7,258,null,258,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),1,false,258,null,new cljs.core.Symbol(null,"any","any",-948528346,null),258,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,315,null,315,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Follows an subject down the provided path and returns a set of all matching subjects.","9 + length of path"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,315,null,new cljs.core.Symbol(null,"any","any",-948528346,null),315,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Follows an subject down the provided path and returns a set of all matching subjects.","9 + length of path"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,216,null,216,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),216,null,216,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),35,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),35,new cljs.core.Keyword(null,"end-column","end-column",1425389514),12,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","stack","fluree.db.dbfunctions.fns/stack",-729322264,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,35,new cljs.core.Symbol(null,"any","any",-948528346,null),35,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,7,715,null,715,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,715,null,new cljs.core.Symbol(null,"any","any",-948528346,null),715,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),14,new cljs.core.Keyword(null,"column","column",2078222095),11,new cljs.core.Keyword(null,"end-line","end-line",1837326455),14,new cljs.core.Keyword(null,"end-column","end-column",1425389514),18,new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",18,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&form","&form",1482799337,null),new cljs.core.Symbol(null,"&env","&env",-919163083,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),1,false,14,true,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),"null",new cljs.core.Symbol("cljs.core","IList","cljs.core/IList",1015168964,null),"null"], null), null),14,3,false,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"Resolves a value if a channel.\n  Must be used inside of a go-block."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,7,697,null,697,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,697,null,new cljs.core.Symbol(null,"any","any",-948528346,null),697,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,7,507,null,507,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),null,cljs.core.list(null,null),1,false,507,null,new cljs.core.Symbol(null,"any","any",-948528346,null),507,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,232,null,232,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),232,null,new cljs.core.Symbol(null,"any","any",-948528346,null),232,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,190,null,190,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,190,null,new cljs.core.Symbol(null,"any","any",-948528346,null),190,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,7,334,null,334,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Returns the value of a nested structure","Length of path"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,334,null,new cljs.core.Symbol(null,"any","any",-948528346,null),334,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Returns the value of a nested structure","Length of path"])]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"seen","seen",-518999789),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 25, [new cljs.core.Keyword(null,"_id","_id",-789960287),"null",new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),"null",new cljs.core.Keyword(null,"o","o",-1350007228),"null",new cljs.core.Keyword(null,"spent","spent",-62769180),"null",new cljs.core.Keyword(null,"instant","instant",655498374),"null",new cljs.core.Keyword(null,"else","else",-1508377146),"null",new cljs.core.Keyword(null,"db","db",993250759),"null",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"null",new cljs.core.Keyword(null,"recur","recur",-437573268),"null",new cljs.core.Keyword(null,"state","state",-1988618099),"null",new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),"null",new cljs.core.Symbol(null,"if","if",1181717262,null),"null",new cljs.core.Keyword(null,"s","s",1705939918),"null",new cljs.core.Keyword(null,"function","function",-2127255473),"null",new cljs.core.Keyword(null,"pid","pid",1018387698),"null",new cljs.core.Keyword(null,"status","status",-1997798413),"null",new cljs.core.Keyword(null,"result","result",1415092211),"null",new cljs.core.Keyword(null,"credits","credits",785860820),"null",new cljs.core.Keyword(null,"stack","stack",-793405930),"null",new cljs.core.Keyword(null,"user_id","user_id",993497112),"null",new cljs.core.Keyword(null,"error","error",-978969032),"null",new cljs.core.Keyword(null,"flakes","flakes",1977895739),"null",new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),"null",new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),"null",new cljs.core.Keyword(null,"sid","sid",1815016414),"null"], null), null),new cljs.core.Keyword(null,"order","order",-1254677256),new cljs.core.PersistentVector(null, 25, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),new cljs.core.Keyword(null,"recur","recur",-437573268),new cljs.core.Keyword(null,"else","else",-1508377146),new cljs.core.Keyword(null,"stack","stack",-793405930),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"credits","credits",785860820),new cljs.core.Keyword(null,"spent","spent",-62769180),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"o","o",-1350007228),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"user_id","user_id",993497112),new cljs.core.Keyword(null,"flakes","flakes",1977895739)], null)], null),null]));
});
flureenjs._ns_state = cljs.js.empty_state.call(null,flureenjs._init_state);
var st_67684 = flureenjs._ns_state;
(cljs.core._STAR_eval_STAR_ = (function (form){
var result = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"result","result",1415092211),null], null));
var form_str = ((typeof form === 'string')?form:cljs.core.str.cljs$core$IFn$_invoke$arity$1(form));
var name = "rtm";
var opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"eval","eval",-1103567905),cljs.js.js_eval,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.find_ns.call(null,cljs.analyzer._STAR_cljs_ns_STAR_),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"nodejs","nodejs",321212524)], null);
var cb = (function (res){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res))){
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res));
} else {
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(res));
}
});
cljs.js.eval_str.call(null,st_67684,form_str,name,opts,cb);

return new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,result));
}));
if((typeof flureenjs !== 'undefined') && (typeof flureenjs._app_state !== 'undefined')){
} else {
flureenjs._app_state = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"Fluree NodeJs Library",new cljs.core.Keyword(null,"version","version",425292698),"v1.0.0-rc21"], null));
}
cljs.core.println.call(null,new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs._app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs._app_state)));
flureenjs._njs_crypto = (function (){try{return require("crypto");
}catch (e67685){var ex = e67685;
fluree.db.util.log.warn.call(null,["Error: Unable to access Node.js crypto module:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ex)].join(''));

fluree.db.util.log.warn.call(null,"Private key generation is not available.");

return null;
}})();
fluree.db.util.log.set_level_BANG_.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *    1. level [Values: severe, warning, info, config, fine, finer, finest]
 *    
 */
flureenjs.setLogging = (function flureenjs$setLogging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var map__67687 = opts_SINGLEQUOTE_;
var map__67687__$1 = cljs.core.__destructure_map.call(null,map__67687);
var level = cljs.core.get.call(null,map__67687__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_.call(null,cljs.core.keyword.call(null,level));
});
goog.exportSymbol('flureenjs.setLogging', flureenjs.setLogging);
/**
 * Returns account id from either a public key or message and signature.
 */
flureenjs.accountId = (function flureenjs$accountId(var_args){
var G__67689 = arguments.length;
switch (G__67689) {
case 1:
return flureenjs.accountId.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureenjs.accountId.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.accountId', flureenjs.accountId);

(flureenjs.accountId.cljs$core$IFn$_invoke$arity$1 = (function (public_key){
return fluree.crypto.account_id_from_public.call(null,public_key);
}));

(flureenjs.accountId.cljs$core$IFn$_invoke$arity$2 = (function (message,signature){
return fluree.crypto.account_id_from_message.call(null,message,signature);
}));

(flureenjs.accountId.cljs$lang$maxFixedArity = 2);

/**
 * Takes an http request and creates an http signature using a private key
 */
flureenjs.httpSignature = (function flureenjs$httpSignature(var_args){
var G__67692 = arguments.length;
switch (G__67692) {
case 4:
return flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.httpSignature', flureenjs.httpSignature);

(flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$4 = (function (req_method,url,request,private_key){
return flureenjs.httpSignature.call(null,req_method,url,request,private_key,null);
}));

(flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$5 = (function (req_method,url,request,private_key,auth){
var request__$1 = cljs.core.js__GT_clj.call(null,request);
return fluree.db.query.http_signatures.sign_request.call(null,req_method,url,request__$1,private_key,auth);
}));

(flureenjs.httpSignature.cljs$lang$maxFixedArity = 5);

/**
 * Returns a public key given a private key.
 */
flureenjs.publicKeyFromPrivate = (function flureenjs$publicKeyFromPrivate(private_key){
return fluree.crypto.pub_key_from_private.call(null,private_key);
});
goog.exportSymbol('flureenjs.publicKeyFromPrivate', flureenjs.publicKeyFromPrivate);
/**
 * Returns a public key from a message and a signature.
 */
flureenjs.publicKey = (function flureenjs$publicKey(message,signature){
return fluree.crypto.pub_key_from_message.call(null,message,signature);
});
goog.exportSymbol('flureenjs.publicKey', flureenjs.publicKey);
/**
 * Generates a private-public key pair using the Node.js
 *     crypto module. The JavaScript code looks like:
 * 
 *        const ecdh = crypto.createECDH('secp256k1');
 *        ecdh.generateKeys()
 *        return { private: ecdh.getPrivateKey('hex'),
 *                 public:  ecdh.getPublicKey('hex','compressed')};
 *     
 */
flureenjs._generate_key_pair = (function flureenjs$_generate_key_pair(){
if(cljs.core.truth_(flureenjs._njs_crypto)){
var ecdh = cljs.core.js_invoke.call(null,flureenjs._njs_crypto,"createECDH","secp256k1");
var _ = cljs.core.js_invoke.call(null,ecdh,"generateKeys");
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),cljs.core.js_invoke.call(null,ecdh,"getPrivateKey","hex"),new cljs.core.Keyword(null,"public","public",1566243851),cljs.core.js_invoke.call(null,ecdh,"getPublicKey","hex","compressed")], null);
} else {
throw "Node.js crypto module not accessible";
}
});
/**
 * Generates a new private key, returned in a map along with
 *    the public key and account id. Return keys are :public,
 *    :private, and :id.
 *    
 */
flureenjs.newPrivateKey = (function flureenjs$newPrivateKey(){
try{var kp = flureenjs._generate_key_pair.call(null);
var account = fluree.crypto.account_id_from_private.call(null,new cljs.core.Keyword(null,"private","private",-558947994).cljs$core$IFn$_invoke$arity$1(kp));
return cljs.core.assoc.call(null,kp,new cljs.core.Keyword(null,"id","id",-1388402092),account);
}catch (e67694){var e = e67694;
fluree.db.util.log.error.call(null,["Unable to generate private key. Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e)].join(''));

throw e;
}});
goog.exportSymbol('flureenjs.newPrivateKey', flureenjs.newPrivateKey);
/**
 * Returns a signature for a message given a private key.
 */
flureenjs.sign = (function flureenjs$sign(message,private_key){
return fluree.crypto.sign_message.call(null,message,private_key);
});
goog.exportSymbol('flureenjs.sign', flureenjs.sign);
/**
 * Sets a new default private key for the entire tx-group, network or db level.
 *    This will only succeed if signed by the default private key for the tx-group,
 *    or if setting for a ledger-id, either the tx-group or network.
 * 
 *    It will overwrite any existing default private key.
 * 
 *    It will respond with true or false.
 * 
 *    Returns promise that eventually contains the results. 
 */
flureenjs.setDefaultKey = (function flureenjs$setDefaultKey(var_args){
var G__67696 = arguments.length;
switch (G__67696) {
case 2:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.setDefaultKey', flureenjs.setDefaultKey);

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$2 = (function (conn,private_key){
return flureenjs.setDefaultKey.call(null,conn,null,null,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$3 = (function (conn,network,private_key){
return flureenjs.setDefaultKey.call(null,conn,network,null,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,ledger_id,private_key){
return flureenjs.setDefaultKey.call(null,conn,network,ledger_id,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,private_key,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_67752){
var state_val_67753 = (state_67752[(1)]);
if((state_val_67753 === (7))){
var inst_67711 = (state_67752[(7)]);
var state_67752__$1 = state_67752;
var statearr_67754_67795 = state_67752__$1;
(statearr_67754_67795[(2)] = inst_67711);

(statearr_67754_67795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (20))){
var inst_67723 = (state_67752[(8)]);
var inst_67741 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_67723);
var state_67752__$1 = state_67752;
var statearr_67755_67796 = state_67752__$1;
(statearr_67755_67796[(2)] = inst_67741);

(statearr_67755_67796[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (1))){
var state_67752__$1 = state_67752;
var statearr_67756_67797 = state_67752__$1;
(statearr_67756_67797[(2)] = null);

(statearr_67756_67797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (4))){
var inst_67697 = (state_67752[(2)]);
var inst_67698 = fluree.db.util.log.error.call(null,inst_67697);
var inst_67699 = reject.call(null,inst_67697);
var state_67752__$1 = (function (){var statearr_67757 = state_67752;
(statearr_67757[(9)] = inst_67698);

return statearr_67757;
})();
var statearr_67758_67798 = state_67752__$1;
(statearr_67758_67798[(2)] = inst_67699);

(statearr_67758_67798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (15))){
var inst_67710 = (state_67752[(10)]);
var inst_67729 = (state_67752[(11)]);
var inst_67731 = fluree.crypto.sign_message.call(null,inst_67729,inst_67710);
var state_67752__$1 = state_67752;
var statearr_67759_67799 = state_67752__$1;
(statearr_67759_67799[(2)] = inst_67731);

(statearr_67759_67799[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (21))){
var inst_67743 = (state_67752[(2)]);
var state_67752__$1 = state_67752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67752__$1,(18),inst_67743);
} else {
if((state_val_67753 === (13))){
var state_67752__$1 = state_67752;
var statearr_67760_67800 = state_67752__$1;
(statearr_67760_67800[(2)] = null);

(statearr_67760_67800[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (6))){
var inst_67708 = (state_67752[(12)]);
var state_67752__$1 = state_67752;
var statearr_67761_67801 = state_67752__$1;
(statearr_67761_67801[(2)] = inst_67708);

(statearr_67761_67801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (17))){
var inst_67710 = (state_67752[(10)]);
var inst_67734 = (state_67752[(2)]);
var state_67752__$1 = (function (){var statearr_67762 = state_67752;
(statearr_67762[(13)] = inst_67734);

return statearr_67762;
})();
if(cljs.core.truth_(inst_67710)){
var statearr_67763_67802 = state_67752__$1;
(statearr_67763_67802[(1)] = (19));

} else {
var statearr_67764_67803 = state_67752__$1;
(statearr_67764_67803[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (3))){
var inst_67750 = (state_67752[(2)]);
var state_67752__$1 = state_67752;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67752__$1,inst_67750);
} else {
if((state_val_67753 === (12))){
var inst_67723 = (state_67752[(8)]);
var inst_67725 = fluree.db.util.core.without_nils.call(null,inst_67723);
var inst_67726 = fluree.db.util.json.stringify.call(null,inst_67725);
var state_67752__$1 = state_67752;
var statearr_67765_67804 = state_67752__$1;
(statearr_67765_67804[(2)] = inst_67726);

(statearr_67765_67804[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (2))){
var inst_67708 = (state_67752[(12)]);
var _ = (function (){var statearr_67766 = state_67752;
(statearr_67766[(4)] = cljs.core.cons.call(null,(5),(state_67752[(4)])));

return statearr_67766;
})();
var inst_67706 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_67707 = cljs.core.__destructure_map.call(null,inst_67706);
var inst_67708__$1 = cljs.core.get.call(null,inst_67707,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_67709 = cljs.core.get.call(null,inst_67707,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_67710 = cljs.core.get.call(null,inst_67707,new cljs.core.Keyword(null,"signing-key","signing-key",1285642632));
var inst_67711 = fluree.db.util.core.current_time_millis.call(null);
var state_67752__$1 = (function (){var statearr_67767 = state_67752;
(statearr_67767[(12)] = inst_67708__$1);

(statearr_67767[(10)] = inst_67710);

(statearr_67767[(14)] = inst_67709);

(statearr_67767[(7)] = inst_67711);

return statearr_67767;
})();
if(cljs.core.truth_(inst_67708__$1)){
var statearr_67768_67805 = state_67752__$1;
(statearr_67768_67805[(1)] = (6));

} else {
var statearr_67769_67806 = state_67752__$1;
(statearr_67769_67806[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (19))){
var inst_67729 = (state_67752[(11)]);
var inst_67734 = (state_67752[(13)]);
var inst_67736 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_67737 = [inst_67729,inst_67734];
var inst_67738 = cljs.core.PersistentHashMap.fromArrays(inst_67736,inst_67737);
var inst_67739 = fluree.db.operations.command_async.call(null,conn,inst_67738);
var state_67752__$1 = state_67752;
var statearr_67770_67807 = state_67752__$1;
(statearr_67770_67807[(2)] = inst_67739);

(statearr_67770_67807[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (11))){
var inst_67710 = (state_67752[(10)]);
var inst_67715 = (state_67752[(15)]);
var inst_67720 = (state_67752[(2)]);
var inst_67721 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"private-key","private-key",426483388),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_67722 = [new cljs.core.Keyword(null,"default-key","default-key",-2094960617),network,ledger_id,private_key,inst_67715,inst_67720];
var inst_67723 = cljs.core.PersistentHashMap.fromArrays(inst_67721,inst_67722);
var state_67752__$1 = (function (){var statearr_67772 = state_67752;
(statearr_67772[(8)] = inst_67723);

return statearr_67772;
})();
if(cljs.core.truth_(inst_67710)){
var statearr_67773_67808 = state_67752__$1;
(statearr_67773_67808[(1)] = (12));

} else {
var statearr_67774_67809 = state_67752__$1;
(statearr_67774_67809[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (9))){
var inst_67709 = (state_67752[(14)]);
var state_67752__$1 = state_67752;
var statearr_67775_67810 = state_67752__$1;
(statearr_67775_67810[(2)] = inst_67709);

(statearr_67775_67810[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (5))){
var _ = (function (){var statearr_67776 = state_67752;
(statearr_67776[(4)] = cljs.core.rest.call(null,(state_67752[(4)])));

return statearr_67776;
})();
var state_67752__$1 = state_67752;
var ex67771 = (state_67752__$1[(2)]);
var statearr_67777_67811 = state_67752__$1;
(statearr_67777_67811[(5)] = ex67771);


var statearr_67778_67812 = state_67752__$1;
(statearr_67778_67812[(1)] = (4));

(statearr_67778_67812[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (14))){
var inst_67710 = (state_67752[(10)]);
var inst_67729 = (state_67752[(2)]);
var state_67752__$1 = (function (){var statearr_67779 = state_67752;
(statearr_67779[(11)] = inst_67729);

return statearr_67779;
})();
if(cljs.core.truth_(inst_67710)){
var statearr_67780_67813 = state_67752__$1;
(statearr_67780_67813[(1)] = (15));

} else {
var statearr_67781_67814 = state_67752__$1;
(statearr_67781_67814[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (16))){
var state_67752__$1 = state_67752;
var statearr_67782_67815 = state_67752__$1;
(statearr_67782_67815[(2)] = null);

(statearr_67782_67815[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (10))){
var inst_67711 = (state_67752[(7)]);
var inst_67718 = (inst_67711 + (30000));
var state_67752__$1 = state_67752;
var statearr_67783_67816 = state_67752__$1;
(statearr_67783_67816[(2)] = inst_67718);

(statearr_67783_67816[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (18))){
var inst_67745 = (state_67752[(2)]);
var inst_67746 = cljs.core.clj__GT_js.call(null,inst_67745);
var inst_67747 = resolve.call(null,inst_67746);
var _ = (function (){var statearr_67784 = state_67752;
(statearr_67784[(4)] = cljs.core.rest.call(null,(state_67752[(4)])));

return statearr_67784;
})();
var state_67752__$1 = state_67752;
var statearr_67785_67817 = state_67752__$1;
(statearr_67785_67817[(2)] = inst_67747);

(statearr_67785_67817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67753 === (8))){
var inst_67709 = (state_67752[(14)]);
var inst_67715 = (state_67752[(2)]);
var state_67752__$1 = (function (){var statearr_67786 = state_67752;
(statearr_67786[(15)] = inst_67715);

return statearr_67786;
})();
if(cljs.core.truth_(inst_67709)){
var statearr_67787_67818 = state_67752__$1;
(statearr_67787_67818[(1)] = (9));

} else {
var statearr_67788_67819 = state_67752__$1;
(statearr_67788_67819[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_67789 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67789[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_67789[(1)] = (1));

return statearr_67789;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_67752){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_67752);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e67790){var ex__2744__auto__ = e67790;
var statearr_67791_67820 = state_67752;
(statearr_67791_67820[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_67752[(4)]))){
var statearr_67792_67821 = state_67752;
(statearr_67792_67821[(1)] = cljs.core.first.call(null,(state_67752[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67822 = state_67752;
state_67752 = G__67822;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_67752){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_67752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_67793 = f__2764__auto__.call(null);
(statearr_67793[(6)] = c__2763__auto__);

return statearr_67793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.setDefaultKey.cljs$lang$maxFixedArity = 5);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 *     Returns a promise that eventually contains the connection object.
 */
flureenjs.connect = (function flureenjs$connect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___67829 = arguments.length;
var i__4865__auto___67830 = (0);
while(true){
if((i__4865__auto___67830 < len__4864__auto___67829)){
args__4870__auto__.push((arguments[i__4865__auto___67830]));

var G__67831 = (i__4865__auto___67830 + (1));
i__4865__auto___67830 = G__67831;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});
goog.exportSymbol('flureenjs.connect', flureenjs.connect);

(flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers_string,p__67825){
var vec__67826 = p__67825;
var opts = cljs.core.nth.call(null,vec__67826,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect_p.call(null,servers_string,clj_opts);
}));

(flureenjs.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(flureenjs.connect.cljs$lang$applyTo = (function (seq67823){
var G__67824 = cljs.core.first.call(null,seq67823);
var seq67823__$1 = cljs.core.next.call(null,seq67823);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67824,seq67823__$1);
}));

/**
 * Closes a connection
 */
flureenjs.close = (function flureenjs$close(conn){
return fluree.db.connection_js.close.call(null,conn);
});
goog.exportSymbol('flureenjs.close', flureenjs.close);
/**
 * Attempts to generate a new user auth record account.
 * 
 *    Returns a promise that eventually contains the token or an exception.
 */
flureenjs.passwordGenerate = (function flureenjs$passwordGenerate(var_args){
var G__67833 = arguments.length;
switch (G__67833) {
case 4:
return flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.passwordGenerate', flureenjs.passwordGenerate);

(flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureenjs.passwordGenerate.call(null,conn,ledger,password,user,null);
}));

(flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var data = cljs.core.assoc.call(null,cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true),new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate.call(null,conn,ledger,password,data);
}));

(flureenjs.passwordGenerate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *    Must supply ledger, password and either user or auth identifier.
 *    Expire is optional
 *    - connection - connection object to server
 *    - ledger     - ledger identifier
 *    - password   - plain-text password
 *    - user       - _user/username (TODO: should allow any _user ident in the future)
 *    - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *    - expire     - requested time to expire in milliseconds
 * 
 *    Returns a promise that eventually contains the token or an exception.
 */
flureenjs.passwordLogin = (function flureenjs$passwordLogin(var_args){
var G__67836 = arguments.length;
switch (G__67836) {
case 4:
return flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.passwordLogin', flureenjs.passwordLogin);

(flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user);
}));

(flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,auth,expire);
}));

(flureenjs.passwordLogin.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *    Returns a promise that eventually contains the token or an exception
 */
flureenjs.renewToken = (function flureenjs$renewToken(var_args){
var G__67839 = arguments.length;
switch (G__67839) {
case 2:
return flureenjs.renewToken.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.renewToken.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.renewToken', flureenjs.renewToken);

(flureenjs.renewToken.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(flureenjs.renewToken.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,expire);
}));

(flureenjs.renewToken.cljs$lang$maxFixedArity = 3);

/**
 * Takes block event data from (listen...) and adds an :added and
 *    :retracted key containing maps of data organized by subject
 *    and containing full predicate names.
 */
flureenjs.blockEventToMap = (function flureenjs$blockEventToMap(conn,ledger,block_event){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_67870){
var state_val_67871 = (state_67870[(1)]);
if((state_val_67871 === (1))){
var state_67870__$1 = state_67870;
var statearr_67872_67887 = state_67870__$1;
(statearr_67872_67887[(2)] = null);

(statearr_67872_67887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67871 === (2))){
var _ = (function (){var statearr_67873 = state_67870;
(statearr_67873[(4)] = cljs.core.cons.call(null,(5),(state_67870[(4)])));

return statearr_67873;
})();
var inst_67851 = flureenjs._db_instance.call(null,conn,ledger);
var state_67870__$1 = state_67870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67870__$1,(6),inst_67851);
} else {
if((state_val_67871 === (3))){
var inst_67868 = (state_67870[(2)]);
var state_67870__$1 = state_67870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67870__$1,inst_67868);
} else {
if((state_val_67871 === (4))){
var inst_67842 = (state_67870[(2)]);
var inst_67843 = fluree.db.util.log.error.call(null,inst_67842);
var inst_67844 = reject.call(null,inst_67842);
var state_67870__$1 = (function (){var statearr_67875 = state_67870;
(statearr_67875[(7)] = inst_67843);

return statearr_67875;
})();
var statearr_67876_67888 = state_67870__$1;
(statearr_67876_67888[(2)] = inst_67844);

(statearr_67876_67888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67871 === (5))){
var _ = (function (){var statearr_67877 = state_67870;
(statearr_67877[(4)] = cljs.core.rest.call(null,(state_67870[(4)])));

return statearr_67877;
})();
var state_67870__$1 = state_67870;
var ex67874 = (state_67870__$1[(2)]);
var statearr_67878_67889 = state_67870__$1;
(statearr_67878_67889[(5)] = ex67874);


var statearr_67879_67890 = state_67870__$1;
(statearr_67879_67890[(1)] = (4));

(statearr_67879_67890[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67871 === (6))){
var inst_67853 = (state_67870[(2)]);
var inst_67854 = fluree.db.util.async.throw_err.call(null,inst_67853);
var inst_67855 = (function (){var db = inst_67854;
return (function (p1__67841_SHARP_){
return cljs.core.nth.call(null,p1__67841_SHARP_,(4));
});
})();
var inst_67856 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block_event);
var inst_67857 = cljs.core.group_by.call(null,inst_67855,inst_67856);
var inst_67858 = cljs.core.__destructure_map.call(null,inst_67857);
var inst_67859 = cljs.core.get.call(null,inst_67858,true);
var inst_67860 = cljs.core.get.call(null,inst_67858,false);
var inst_67861 = (function (){var db = inst_67854;
var map__67850 = inst_67858;
var add = inst_67859;
var retract = inst_67860;
return (function (flakes){
var by_subj = cljs.core.group_by.call(null,cljs.core.first,flakes);
return cljs.core.reduce_kv.call(null,(function (acc,sid,flakes__$1){
return cljs.core.conj.call(null,acc,cljs.core.reduce.call(null,(function (m,flake){
var p_schema = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"pred","pred",1927423397),cljs.core.second.call(null,flake)], null));
var v = cljs.core.nth.call(null,flake,(2));
if(cljs.core.truth_(new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(p_schema))){
return cljs.core.update.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),cljs.core.conj,v);
} else {
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),v);
}
}),new cljs.core.PersistentArrayMap(null, 1, ["_id",sid], null),flakes__$1));
}),cljs.core.PersistentVector.EMPTY,by_subj);
});
})();
var inst_67862 = inst_67861.call(null,inst_67859);
var inst_67863 = inst_67861.call(null,inst_67860);
var inst_67864 = cljs.core.assoc.call(null,block_event,new cljs.core.Keyword(null,"added","added",2057651688),inst_67862,new cljs.core.Keyword(null,"retracted","retracted",-1399687854),inst_67863);
var inst_67865 = resolve.call(null,inst_67864);
var _ = (function (){var statearr_67880 = state_67870;
(statearr_67880[(4)] = cljs.core.rest.call(null,(state_67870[(4)])));

return statearr_67880;
})();
var state_67870__$1 = state_67870;
var statearr_67881_67891 = state_67870__$1;
(statearr_67881_67891[(2)] = inst_67865);

(statearr_67881_67891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$blockEventToMap_$_state_machine__2741__auto__ = null;
var flureenjs$blockEventToMap_$_state_machine__2741__auto____0 = (function (){
var statearr_67882 = [null,null,null,null,null,null,null,null];
(statearr_67882[(0)] = flureenjs$blockEventToMap_$_state_machine__2741__auto__);

(statearr_67882[(1)] = (1));

return statearr_67882;
});
var flureenjs$blockEventToMap_$_state_machine__2741__auto____1 = (function (state_67870){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_67870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e67883){var ex__2744__auto__ = e67883;
var statearr_67884_67892 = state_67870;
(statearr_67884_67892[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_67870[(4)]))){
var statearr_67885_67893 = state_67870;
(statearr_67885_67893[(1)] = cljs.core.first.call(null,(state_67870[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67894 = state_67870;
state_67870 = G__67894;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$blockEventToMap_$_state_machine__2741__auto__ = function(state_67870){
switch(arguments.length){
case 0:
return flureenjs$blockEventToMap_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$blockEventToMap_$_state_machine__2741__auto____1.call(this,state_67870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$blockEventToMap_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$blockEventToMap_$_state_machine__2741__auto____0;
flureenjs$blockEventToMap_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$blockEventToMap_$_state_machine__2741__auto____1;
return flureenjs$blockEventToMap_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_67886 = f__2764__auto__.call(null);
(statearr_67886[(6)] = c__2763__auto__);

return statearr_67886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *    any key, and a two-argument function that will be called with each event.
 *    The key is any arbitrary key, and is only used to close the listener via close-listener,
 *    otherwise it is opaque to the listener.
 *    The callback function's first argument is the event header/metadata and the second argument
 *    is the event data itself.
 */
flureenjs.listen = (function flureenjs$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen.call(null,conn,ledger,key,callback);
});
goog.exportSymbol('flureenjs.listen', flureenjs.listen);
/**
 * Closes a listener.
 */
flureenjs.closeListener = (function flureenjs$closeListener(conn,ledger,key){
return fluree.db.connection_js.close_listener.call(null,conn,ledger,key);
});
goog.exportSymbol('flureenjs.closeListener', flureenjs.closeListener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureenjs.listeners = (function flureenjs$listeners(conn){
return fluree.db.connection_js.listeners.call(null,conn);
});
goog.exportSymbol('flureenjs.listeners', flureenjs.listeners);
/**
 * Returns a queryable database from the connection.
 */
flureenjs._db_instance = (function flureenjs$_db_instance(var_args){
var G__67896 = arguments.length;
switch (G__67896) {
case 2:
return flureenjs._db_instance.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs._db_instance.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs._db_instance.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs._db_instance.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs._db_instance.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2763__auto___67969 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_67942){
var state_val_67943 = (state_67942[(1)]);
if((state_val_67943 === (7))){
var inst_67913 = (state_67942[(7)]);
var state_67942__$1 = state_67942;
if(cljs.core.truth_(inst_67913)){
var statearr_67944_67970 = state_67942__$1;
(statearr_67944_67970[(1)] = (9));

} else {
var statearr_67945_67971 = state_67942__$1;
(statearr_67945_67971[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67943 === (1))){
var state_67942__$1 = state_67942;
var statearr_67946_67972 = state_67942__$1;
(statearr_67946_67972[(2)] = null);

(statearr_67946_67972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67943 === (4))){
var inst_67897 = (state_67942[(2)]);
var inst_67898 = fluree.db.util.log.error.call(null,inst_67897);
var inst_67899 = cljs.core.async.put_BANG_.call(null,pc,inst_67897);
var inst_67900 = cljs.core.async.close_BANG_.call(null,pc);
var state_67942__$1 = (function (){var statearr_67947 = state_67942;
(statearr_67947[(8)] = inst_67899);

(statearr_67947[(9)] = inst_67898);

return statearr_67947;
})();
var statearr_67948_67973 = state_67942__$1;
(statearr_67948_67973[(2)] = inst_67900);

(statearr_67948_67973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67943 === (6))){
var inst_67912 = (state_67942[(10)]);
var state_67942__$1 = state_67942;
var statearr_67949_67974 = state_67942__$1;
(statearr_67949_67974[(2)] = inst_67912);

(statearr_67949_67974[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67943 === (3))){
var inst_67940 = (state_67942[(2)]);
var state_67942__$1 = state_67942;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67942__$1,inst_67940);
} else {
if((state_val_67943 === (12))){
var inst_67917 = (state_67942[(11)]);
var inst_67916 = (state_67942[(12)]);
var inst_67934 = (state_67942[(2)]);
var inst_67935 = fluree.db.util.async.throw_err.call(null,inst_67934);
var inst_67936 = cljs.core.assoc.call(null,inst_67935,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_67916,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_67917);
var inst_67937 = cljs.core.async.put_BANG_.call(null,pc,inst_67936);
var _ = (function (){var statearr_67950 = state_67942;
(statearr_67950[(4)] = cljs.core.rest.call(null,(state_67942[(4)])));

return statearr_67950;
})();
var state_67942__$1 = state_67942;
var statearr_67951_67975 = state_67942__$1;
(statearr_67951_67975[(2)] = inst_67937);

(statearr_67951_67975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67943 === (2))){
var inst_67912 = (state_67942[(10)]);
var _ = (function (){var statearr_67952 = state_67942;
(statearr_67952[(4)] = cljs.core.cons.call(null,(5),(state_67942[(4)])));

return statearr_67952;
})();
var inst_67910 = opts;
var inst_67911 = cljs.core.__destructure_map.call(null,inst_67910);
var inst_67912__$1 = cljs.core.get.call(null,inst_67911,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_67913 = cljs.core.get.call(null,inst_67911,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_67914 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_67915 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_67916 = cljs.core.nth.call(null,inst_67915,(0),null);
var inst_67917 = cljs.core.nth.call(null,inst_67915,(1),null);
var state_67942__$1 = (function (){var statearr_67953 = state_67942;
(statearr_67953[(11)] = inst_67917);

(statearr_67953[(7)] = inst_67913);

(statearr_67953[(10)] = inst_67912__$1);

(statearr_67953[(12)] = inst_67916);

(statearr_67953[(13)] = inst_67914);

return statearr_67953;
})();
if(cljs.core.truth_(inst_67912__$1)){
var statearr_67954_67976 = state_67942__$1;
(statearr_67954_67976[(1)] = (6));

} else {
var statearr_67955_67977 = state_67942__$1;
(statearr_67955_67977[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67943 === (11))){
var inst_67928 = (state_67942[(2)]);
var state_67942__$1 = state_67942;
var statearr_67957_67978 = state_67942__$1;
(statearr_67957_67978[(2)] = inst_67928);

(statearr_67957_67978[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67943 === (9))){
var inst_67913 = (state_67942[(7)]);
var inst_67921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67922 = fluree.db.connection_js.validate_token.call(null,conn,inst_67913);
var inst_67923 = new cljs.core.Keyword(null,"sub","sub",-2093760025).cljs$core$IFn$_invoke$arity$1(inst_67922);
var inst_67924 = ["_auth/id",inst_67923];
var inst_67925 = (new cljs.core.PersistentVector(null,2,(5),inst_67921,inst_67924,null));
var state_67942__$1 = state_67942;
var statearr_67958_67979 = state_67942__$1;
(statearr_67958_67979[(2)] = inst_67925);

(statearr_67958_67979[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67943 === (5))){
var _ = (function (){var statearr_67959 = state_67942;
(statearr_67959[(4)] = cljs.core.rest.call(null,(state_67942[(4)])));

return statearr_67959;
})();
var state_67942__$1 = state_67942;
var ex67956 = (state_67942__$1[(2)]);
var statearr_67960_67980 = state_67942__$1;
(statearr_67960_67980[(5)] = ex67956);


var statearr_67961_67981 = state_67942__$1;
(statearr_67961_67981[(1)] = (4));

(statearr_67961_67981[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67943 === (10))){
var state_67942__$1 = state_67942;
var statearr_67962_67982 = state_67942__$1;
(statearr_67962_67982[(2)] = null);

(statearr_67962_67982[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67943 === (8))){
var inst_67930 = (state_67942[(2)]);
var inst_67931 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_67930);
var inst_67932 = fluree.db.api.ledger.db.call(null,conn,ledger,inst_67931);
var state_67942__$1 = state_67942;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67942__$1,(12),inst_67932);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_67963 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67963[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_67963[(1)] = (1));

return statearr_67963;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_67942){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_67942);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e67964){var ex__2744__auto__ = e67964;
var statearr_67965_67983 = state_67942;
(statearr_67965_67983[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_67942[(4)]))){
var statearr_67966_67984 = state_67942;
(statearr_67966_67984[(1)] = cljs.core.first.call(null,(state_67942[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67985 = state_67942;
state_67942 = G__67985;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_67942){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_67942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_67967 = f__2764__auto__.call(null);
(statearr_67967[(6)] = c__2763__auto___67969);

return statearr_67967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return pc;
}));

(flureenjs._db_instance.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db = (function flureenjs$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___68025 = arguments.length;
var i__4865__auto___68026 = (0);
while(true){
if((i__4865__auto___68026 < len__4864__auto___68025)){
args__4870__auto__.push((arguments[i__4865__auto___68026]));

var G__68027 = (i__4865__auto___68026 + (1));
i__4865__auto___68026 = G__68027;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return flureenjs.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});
goog.exportSymbol('flureenjs.db', flureenjs.db);

(flureenjs.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__67989){
var vec__67990 = p__67989;
var opts = cljs.core.nth.call(null,vec__67990,(0),null);
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68008){
var state_val_68009 = (state_68008[(1)]);
if((state_val_68009 === (1))){
var state_68008__$1 = state_68008;
var statearr_68010_68028 = state_68008__$1;
(statearr_68010_68028[(2)] = null);

(statearr_68010_68028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68009 === (2))){
var _ = (function (){var statearr_68011 = state_68008;
(statearr_68011[(4)] = cljs.core.cons.call(null,(5),(state_68008[(4)])));

return statearr_68011;
})();
var inst_68001 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_68002 = flureenjs._db_instance.call(null,conn,ledger,inst_68001);
var inst_68003 = resolve.call(null,inst_68002);
var ___$1 = (function (){var statearr_68012 = state_68008;
(statearr_68012[(4)] = cljs.core.rest.call(null,(state_68008[(4)])));

return statearr_68012;
})();
var state_68008__$1 = state_68008;
var statearr_68013_68029 = state_68008__$1;
(statearr_68013_68029[(2)] = inst_68003);

(statearr_68013_68029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68009 === (3))){
var inst_68006 = (state_68008[(2)]);
var state_68008__$1 = state_68008;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68008__$1,inst_68006);
} else {
if((state_val_68009 === (4))){
var inst_67993 = (state_68008[(2)]);
var inst_67994 = fluree.db.util.log.error.call(null,inst_67993);
var inst_67995 = reject.call(null,inst_67993);
var state_68008__$1 = (function (){var statearr_68015 = state_68008;
(statearr_68015[(7)] = inst_67994);

return statearr_68015;
})();
var statearr_68016_68030 = state_68008__$1;
(statearr_68016_68030[(2)] = inst_67995);

(statearr_68016_68030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68009 === (5))){
var _ = (function (){var statearr_68017 = state_68008;
(statearr_68017[(4)] = cljs.core.rest.call(null,(state_68008[(4)])));

return statearr_68017;
})();
var state_68008__$1 = state_68008;
var ex68014 = (state_68008__$1[(2)]);
var statearr_68018_68031 = state_68008__$1;
(statearr_68018_68031[(5)] = ex68014);


var statearr_68019_68032 = state_68008__$1;
(statearr_68019_68032[(1)] = (4));

(statearr_68019_68032[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_68020 = [null,null,null,null,null,null,null,null];
(statearr_68020[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_68020[(1)] = (1));

return statearr_68020;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_68008){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68008);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68021){var ex__2744__auto__ = e68021;
var statearr_68022_68033 = state_68008;
(statearr_68022_68033[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68008[(4)]))){
var statearr_68023_68034 = state_68008;
(statearr_68023_68034[(1)] = cljs.core.first.call(null,(state_68008[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68035 = state_68008;
state_68008 = G__68035;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_68008){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_68008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68024 = f__2764__auto__.call(null);
(statearr_68024[(6)] = c__2763__auto__);

return statearr_68024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db.cljs$lang$applyTo = (function (seq67986){
var G__67987 = cljs.core.first.call(null,seq67986);
var seq67986__$1 = cljs.core.next.call(null,seq67986);
var G__67988 = cljs.core.first.call(null,seq67986__$1);
var seq67986__$2 = cljs.core.next.call(null,seq67986__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67987,G__67988,seq67986__$2);
}));

/**
 * Returns promise containing collection id given a collection name.
 *    If collection doesn't exist, returns nil.
 */
flureenjs.collectionId = (function flureenjs$collectionId(db,collection){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68055){
var state_val_68056 = (state_68055[(1)]);
if((state_val_68056 === (1))){
var state_68055__$1 = state_68055;
var statearr_68057_68073 = state_68055__$1;
(statearr_68057_68073[(2)] = null);

(statearr_68057_68073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68056 === (2))){
var _ = (function (){var statearr_68058 = state_68055;
(statearr_68058[(4)] = cljs.core.cons.call(null,(5),(state_68055[(4)])));

return statearr_68058;
})();
var inst_68044 = cljs.core.js__GT_clj.call(null,collection,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_68055__$1 = (function (){var statearr_68059 = state_68055;
(statearr_68059[(7)] = inst_68044);

return statearr_68059;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68055__$1,(6),db);
} else {
if((state_val_68056 === (3))){
var inst_68053 = (state_68055[(2)]);
var state_68055__$1 = state_68055;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68055__$1,inst_68053);
} else {
if((state_val_68056 === (4))){
var inst_68036 = (state_68055[(2)]);
var inst_68037 = fluree.db.util.log.error.call(null,inst_68036);
var inst_68038 = reject.call(null,inst_68036);
var state_68055__$1 = (function (){var statearr_68061 = state_68055;
(statearr_68061[(8)] = inst_68037);

return statearr_68061;
})();
var statearr_68062_68074 = state_68055__$1;
(statearr_68062_68074[(2)] = inst_68038);

(statearr_68062_68074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68056 === (5))){
var _ = (function (){var statearr_68063 = state_68055;
(statearr_68063[(4)] = cljs.core.rest.call(null,(state_68055[(4)])));

return statearr_68063;
})();
var state_68055__$1 = state_68055;
var ex68060 = (state_68055__$1[(2)]);
var statearr_68064_68075 = state_68055__$1;
(statearr_68064_68075[(5)] = ex68060);


var statearr_68065_68076 = state_68055__$1;
(statearr_68065_68076[(1)] = (4));

(statearr_68065_68076[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68056 === (6))){
var inst_68044 = (state_68055[(7)]);
var inst_68046 = (state_68055[(2)]);
var inst_68047 = fluree.db.util.async.throw_err.call(null,inst_68046);
var inst_68048 = fluree.db.dbproto._c_prop.call(null,inst_68047,new cljs.core.Keyword(null,"id","id",-1388402092),inst_68044);
var inst_68049 = cljs.core.clj__GT_js.call(null,inst_68048);
var inst_68050 = resolve.call(null,inst_68049);
var _ = (function (){var statearr_68066 = state_68055;
(statearr_68066[(4)] = cljs.core.rest.call(null,(state_68055[(4)])));

return statearr_68066;
})();
var state_68055__$1 = state_68055;
var statearr_68067_68077 = state_68055__$1;
(statearr_68067_68077[(2)] = inst_68050);

(statearr_68067_68077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$collectionId_$_state_machine__2741__auto__ = null;
var flureenjs$collectionId_$_state_machine__2741__auto____0 = (function (){
var statearr_68068 = [null,null,null,null,null,null,null,null,null];
(statearr_68068[(0)] = flureenjs$collectionId_$_state_machine__2741__auto__);

(statearr_68068[(1)] = (1));

return statearr_68068;
});
var flureenjs$collectionId_$_state_machine__2741__auto____1 = (function (state_68055){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68055);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68069){var ex__2744__auto__ = e68069;
var statearr_68070_68078 = state_68055;
(statearr_68070_68078[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68055[(4)]))){
var statearr_68071_68079 = state_68055;
(statearr_68071_68079[(1)] = cljs.core.first.call(null,(state_68055[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68080 = state_68055;
state_68055 = G__68080;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$collectionId_$_state_machine__2741__auto__ = function(state_68055){
switch(arguments.length){
case 0:
return flureenjs$collectionId_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$collectionId_$_state_machine__2741__auto____1.call(this,state_68055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collectionId_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collectionId_$_state_machine__2741__auto____0;
flureenjs$collectionId_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collectionId_$_state_machine__2741__auto____1;
return flureenjs$collectionId_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68072 = f__2764__auto__.call(null);
(statearr_68072[(6)] = c__2763__auto__);

return statearr_68072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.collectionId', flureenjs.collectionId);
/**
 * Returns promise containing predicate id given a predicate.
 *    If predicate doesn't exist, returns nil.
 */
flureenjs.predicateId = (function flureenjs$predicateId(db,predicate){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68100){
var state_val_68101 = (state_68100[(1)]);
if((state_val_68101 === (1))){
var state_68100__$1 = state_68100;
var statearr_68102_68118 = state_68100__$1;
(statearr_68102_68118[(2)] = null);

(statearr_68102_68118[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68101 === (2))){
var _ = (function (){var statearr_68103 = state_68100;
(statearr_68103[(4)] = cljs.core.cons.call(null,(5),(state_68100[(4)])));

return statearr_68103;
})();
var inst_68089 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_68100__$1 = (function (){var statearr_68104 = state_68100;
(statearr_68104[(7)] = inst_68089);

return statearr_68104;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68100__$1,(6),db);
} else {
if((state_val_68101 === (3))){
var inst_68098 = (state_68100[(2)]);
var state_68100__$1 = state_68100;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68100__$1,inst_68098);
} else {
if((state_val_68101 === (4))){
var inst_68081 = (state_68100[(2)]);
var inst_68082 = fluree.db.util.log.error.call(null,inst_68081);
var inst_68083 = reject.call(null,inst_68081);
var state_68100__$1 = (function (){var statearr_68106 = state_68100;
(statearr_68106[(8)] = inst_68082);

return statearr_68106;
})();
var statearr_68107_68119 = state_68100__$1;
(statearr_68107_68119[(2)] = inst_68083);

(statearr_68107_68119[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68101 === (5))){
var _ = (function (){var statearr_68108 = state_68100;
(statearr_68108[(4)] = cljs.core.rest.call(null,(state_68100[(4)])));

return statearr_68108;
})();
var state_68100__$1 = state_68100;
var ex68105 = (state_68100__$1[(2)]);
var statearr_68109_68120 = state_68100__$1;
(statearr_68109_68120[(5)] = ex68105);


var statearr_68110_68121 = state_68100__$1;
(statearr_68110_68121[(1)] = (4));

(statearr_68110_68121[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68101 === (6))){
var inst_68089 = (state_68100[(7)]);
var inst_68091 = (state_68100[(2)]);
var inst_68092 = fluree.db.util.async.throw_err.call(null,inst_68091);
var inst_68093 = fluree.db.dbproto._p_prop.call(null,inst_68092,new cljs.core.Keyword(null,"id","id",-1388402092),inst_68089);
var inst_68094 = cljs.core.clj__GT_js.call(null,inst_68093);
var inst_68095 = resolve.call(null,inst_68094);
var _ = (function (){var statearr_68111 = state_68100;
(statearr_68111[(4)] = cljs.core.rest.call(null,(state_68100[(4)])));

return statearr_68111;
})();
var state_68100__$1 = state_68100;
var statearr_68112_68122 = state_68100__$1;
(statearr_68112_68122[(2)] = inst_68095);

(statearr_68112_68122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicateId_$_state_machine__2741__auto__ = null;
var flureenjs$predicateId_$_state_machine__2741__auto____0 = (function (){
var statearr_68113 = [null,null,null,null,null,null,null,null,null];
(statearr_68113[(0)] = flureenjs$predicateId_$_state_machine__2741__auto__);

(statearr_68113[(1)] = (1));

return statearr_68113;
});
var flureenjs$predicateId_$_state_machine__2741__auto____1 = (function (state_68100){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68100);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68114){var ex__2744__auto__ = e68114;
var statearr_68115_68123 = state_68100;
(statearr_68115_68123[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68100[(4)]))){
var statearr_68116_68124 = state_68100;
(statearr_68116_68124[(1)] = cljs.core.first.call(null,(state_68100[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68125 = state_68100;
state_68100 = G__68125;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$predicateId_$_state_machine__2741__auto__ = function(state_68100){
switch(arguments.length){
case 0:
return flureenjs$predicateId_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$predicateId_$_state_machine__2741__auto____1.call(this,state_68100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicateId_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicateId_$_state_machine__2741__auto____0;
flureenjs$predicateId_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicateId_$_state_machine__2741__auto____1;
return flureenjs$predicateId_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68117 = f__2764__auto__.call(null);
(statearr_68117[(6)] = c__2763__auto__);

return statearr_68117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.predicateId', flureenjs.predicateId);
/**
 * Returns promise containing predicate name given a predicate.
 *    If predicate doesn't exist, returns nil.
 */
flureenjs.predicateName = (function flureenjs$predicateName(db,predicate){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68145){
var state_val_68146 = (state_68145[(1)]);
if((state_val_68146 === (1))){
var state_68145__$1 = state_68145;
var statearr_68147_68163 = state_68145__$1;
(statearr_68147_68163[(2)] = null);

(statearr_68147_68163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68146 === (2))){
var _ = (function (){var statearr_68148 = state_68145;
(statearr_68148[(4)] = cljs.core.cons.call(null,(5),(state_68145[(4)])));

return statearr_68148;
})();
var inst_68134 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_68145__$1 = (function (){var statearr_68149 = state_68145;
(statearr_68149[(7)] = inst_68134);

return statearr_68149;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68145__$1,(6),db);
} else {
if((state_val_68146 === (3))){
var inst_68143 = (state_68145[(2)]);
var state_68145__$1 = state_68145;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68145__$1,inst_68143);
} else {
if((state_val_68146 === (4))){
var inst_68126 = (state_68145[(2)]);
var inst_68127 = fluree.db.util.log.error.call(null,inst_68126);
var inst_68128 = reject.call(null,inst_68126);
var state_68145__$1 = (function (){var statearr_68151 = state_68145;
(statearr_68151[(8)] = inst_68127);

return statearr_68151;
})();
var statearr_68152_68164 = state_68145__$1;
(statearr_68152_68164[(2)] = inst_68128);

(statearr_68152_68164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68146 === (5))){
var _ = (function (){var statearr_68153 = state_68145;
(statearr_68153[(4)] = cljs.core.rest.call(null,(state_68145[(4)])));

return statearr_68153;
})();
var state_68145__$1 = state_68145;
var ex68150 = (state_68145__$1[(2)]);
var statearr_68154_68165 = state_68145__$1;
(statearr_68154_68165[(5)] = ex68150);


var statearr_68155_68166 = state_68145__$1;
(statearr_68155_68166[(1)] = (4));

(statearr_68155_68166[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68146 === (6))){
var inst_68134 = (state_68145[(7)]);
var inst_68136 = (state_68145[(2)]);
var inst_68137 = fluree.db.util.async.throw_err.call(null,inst_68136);
var inst_68138 = fluree.db.dbproto._p_prop.call(null,inst_68137,new cljs.core.Keyword(null,"name","name",1843675177),inst_68134);
var inst_68139 = cljs.core.clj__GT_js.call(null,inst_68138);
var inst_68140 = resolve.call(null,inst_68139);
var _ = (function (){var statearr_68156 = state_68145;
(statearr_68156[(4)] = cljs.core.rest.call(null,(state_68145[(4)])));

return statearr_68156;
})();
var state_68145__$1 = state_68145;
var statearr_68157_68167 = state_68145__$1;
(statearr_68157_68167[(2)] = inst_68140);

(statearr_68157_68167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicateName_$_state_machine__2741__auto__ = null;
var flureenjs$predicateName_$_state_machine__2741__auto____0 = (function (){
var statearr_68158 = [null,null,null,null,null,null,null,null,null];
(statearr_68158[(0)] = flureenjs$predicateName_$_state_machine__2741__auto__);

(statearr_68158[(1)] = (1));

return statearr_68158;
});
var flureenjs$predicateName_$_state_machine__2741__auto____1 = (function (state_68145){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68145);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68159){var ex__2744__auto__ = e68159;
var statearr_68160_68168 = state_68145;
(statearr_68160_68168[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68145[(4)]))){
var statearr_68161_68169 = state_68145;
(statearr_68161_68169[(1)] = cljs.core.first.call(null,(state_68145[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68170 = state_68145;
state_68145 = G__68170;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$predicateName_$_state_machine__2741__auto__ = function(state_68145){
switch(arguments.length){
case 0:
return flureenjs$predicateName_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$predicateName_$_state_machine__2741__auto____1.call(this,state_68145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicateName_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicateName_$_state_machine__2741__auto____0;
flureenjs$predicateName_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicateName_$_state_machine__2741__auto____1;
return flureenjs$predicateName_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68162 = f__2764__auto__.call(null);
(statearr_68162[(6)] = c__2763__auto__);

return statearr_68162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.predicateName', flureenjs.predicateName);
/**
 * Returns promise containing subject id given a subject
 *    identity or a subject id.
 *    If subject doesn't exist, returns nil.
 */
flureenjs.subid = (function flureenjs$subid(db,ident){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68193){
var state_val_68194 = (state_68193[(1)]);
if((state_val_68194 === (1))){
var state_68193__$1 = state_68193;
var statearr_68195_68211 = state_68193__$1;
(statearr_68195_68211[(2)] = null);

(statearr_68195_68211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68194 === (2))){
var _ = (function (){var statearr_68196 = state_68193;
(statearr_68196[(4)] = cljs.core.cons.call(null,(5),(state_68193[(4)])));

return statearr_68196;
})();
var inst_68179 = cljs.core.js__GT_clj.call(null,ident,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_68193__$1 = (function (){var statearr_68197 = state_68193;
(statearr_68197[(7)] = inst_68179);

return statearr_68197;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68193__$1,(7),db);
} else {
if((state_val_68194 === (3))){
var inst_68191 = (state_68193[(2)]);
var state_68193__$1 = state_68193;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68193__$1,inst_68191);
} else {
if((state_val_68194 === (4))){
var inst_68171 = (state_68193[(2)]);
var inst_68172 = fluree.db.util.log.error.call(null,inst_68171);
var inst_68173 = reject.call(null,inst_68171);
var state_68193__$1 = (function (){var statearr_68199 = state_68193;
(statearr_68199[(8)] = inst_68172);

return statearr_68199;
})();
var statearr_68200_68212 = state_68193__$1;
(statearr_68200_68212[(2)] = inst_68173);

(statearr_68200_68212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68194 === (5))){
var _ = (function (){var statearr_68201 = state_68193;
(statearr_68201[(4)] = cljs.core.rest.call(null,(state_68193[(4)])));

return statearr_68201;
})();
var state_68193__$1 = state_68193;
var ex68198 = (state_68193__$1[(2)]);
var statearr_68202_68213 = state_68193__$1;
(statearr_68202_68213[(5)] = ex68198);


var statearr_68203_68214 = state_68193__$1;
(statearr_68203_68214[(1)] = (4));

(statearr_68203_68214[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68194 === (6))){
var inst_68185 = (state_68193[(2)]);
var inst_68186 = fluree.db.util.async.throw_err.call(null,inst_68185);
var inst_68187 = cljs.core.clj__GT_js.call(null,inst_68186);
var inst_68188 = resolve.call(null,inst_68187);
var _ = (function (){var statearr_68204 = state_68193;
(statearr_68204[(4)] = cljs.core.rest.call(null,(state_68193[(4)])));

return statearr_68204;
})();
var state_68193__$1 = state_68193;
var statearr_68205_68215 = state_68193__$1;
(statearr_68205_68215[(2)] = inst_68188);

(statearr_68205_68215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68194 === (7))){
var inst_68179 = (state_68193[(7)]);
var inst_68181 = (state_68193[(2)]);
var inst_68182 = fluree.db.util.async.throw_err.call(null,inst_68181);
var inst_68183 = fluree.db.dbproto._subid.call(null,inst_68182,inst_68179,false);
var state_68193__$1 = state_68193;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68193__$1,(6),inst_68183);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$subid_$_state_machine__2741__auto__ = null;
var flureenjs$subid_$_state_machine__2741__auto____0 = (function (){
var statearr_68206 = [null,null,null,null,null,null,null,null,null];
(statearr_68206[(0)] = flureenjs$subid_$_state_machine__2741__auto__);

(statearr_68206[(1)] = (1));

return statearr_68206;
});
var flureenjs$subid_$_state_machine__2741__auto____1 = (function (state_68193){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68193);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68207){var ex__2744__auto__ = e68207;
var statearr_68208_68216 = state_68193;
(statearr_68208_68216[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68193[(4)]))){
var statearr_68209_68217 = state_68193;
(statearr_68209_68217[(1)] = cljs.core.first.call(null,(state_68193[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68218 = state_68193;
state_68193 = G__68218;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$subid_$_state_machine__2741__auto__ = function(state_68193){
switch(arguments.length){
case 0:
return flureenjs$subid_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$subid_$_state_machine__2741__auto____1.call(this,state_68193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$subid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$subid_$_state_machine__2741__auto____0;
flureenjs$subid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$subid_$_state_machine__2741__auto____1;
return flureenjs$subid_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68210 = f__2764__auto__.call(null);
(statearr_68210[(6)] = c__2763__auto__);

return statearr_68210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.subid', flureenjs.subid);
/**
 * Completely deletes a ledger.
 *    Returns a promise that will have a response with a corresponding status of success.
 * 
 *    A 200 status indicates the deletion has been successfully initiated.
 *    The full deletion happens in the background on the respective ledger.
 * 
 *    Query servers get notified when this process initiates, and ledger will be marked as
 *    being in a deletion state during the deletion process.
 * 
 *    Attempts to use a ledger in a deletion state will throw an exception.
 */
flureenjs.deleteLedger = (function flureenjs$deleteLedger(var_args){
var G__68220 = arguments.length;
switch (G__68220) {
case 2:
return flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.deleteLedger', flureenjs.deleteLedger);

(flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.deleteLedger.call(null,conn,ledger,null);
}));

(flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68290){
var state_val_68291 = (state_68290[(1)]);
if((state_val_68291 === (7))){
var inst_68233 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_68290__$1 = state_68290;
var statearr_68292_68337 = state_68290__$1;
(statearr_68292_68337[(2)] = inst_68233);

(statearr_68292_68337[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (20))){
var inst_68241 = (state_68290[(7)]);
var inst_68265 = (state_68290[(2)]);
var state_68290__$1 = (function (){var statearr_68293 = state_68290;
(statearr_68293[(8)] = inst_68265);

return statearr_68293;
})();
if(cljs.core.truth_(inst_68241)){
var statearr_68294_68338 = state_68290__$1;
(statearr_68294_68338[(1)] = (21));

} else {
var statearr_68295_68339 = state_68290__$1;
(statearr_68295_68339[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (1))){
var state_68290__$1 = state_68290;
var statearr_68296_68340 = state_68290__$1;
(statearr_68296_68340[(2)] = null);

(statearr_68296_68340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (24))){
var inst_68272 = (state_68290[(2)]);
var inst_68273 = fluree.db.util.async.throw_err.call(null,inst_68272);
var state_68290__$1 = state_68290;
var statearr_68297_68341 = state_68290__$1;
(statearr_68297_68341[(2)] = inst_68273);

(statearr_68297_68341[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (4))){
var inst_68221 = (state_68290[(2)]);
var inst_68222 = fluree.db.util.log.error.call(null,inst_68221);
var inst_68223 = reject.call(null,inst_68221);
var state_68290__$1 = (function (){var statearr_68298 = state_68290;
(statearr_68298[(9)] = inst_68222);

return statearr_68298;
})();
var statearr_68299_68342 = state_68290__$1;
(statearr_68299_68342[(2)] = inst_68223);

(statearr_68299_68342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (15))){
var inst_68254 = (state_68290[(10)]);
var inst_68256 = fluree.db.util.core.without_nils.call(null,inst_68254);
var inst_68257 = fluree.db.util.json.stringify.call(null,inst_68256);
var state_68290__$1 = state_68290;
var statearr_68300_68343 = state_68290__$1;
(statearr_68300_68343[(2)] = inst_68257);

(statearr_68300_68343[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (21))){
var inst_68260 = (state_68290[(11)]);
var inst_68265 = (state_68290[(8)]);
var inst_68267 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_68268 = [inst_68260,inst_68265];
var inst_68269 = cljs.core.PersistentHashMap.fromArrays(inst_68267,inst_68268);
var inst_68270 = fluree.db.operations.command_async.call(null,conn,inst_68269);
var state_68290__$1 = state_68290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68290__$1,(24),inst_68270);
} else {
if((state_val_68291 === (13))){
var inst_68242 = (state_68290[(12)]);
var inst_68249 = (inst_68242 + (30000));
var state_68290__$1 = state_68290;
var statearr_68301_68344 = state_68290__$1;
(statearr_68301_68344[(2)] = inst_68249);

(statearr_68301_68344[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (22))){
var inst_68254 = (state_68290[(10)]);
var inst_68275 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_68254);
var state_68290__$1 = state_68290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68290__$1,(25),inst_68275);
} else {
if((state_val_68291 === (6))){
var state_68290__$1 = state_68290;
var statearr_68302_68345 = state_68290__$1;
(statearr_68302_68345[(2)] = null);

(statearr_68302_68345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (25))){
var inst_68277 = (state_68290[(2)]);
var inst_68278 = fluree.db.util.async.throw_err.call(null,inst_68277);
var state_68290__$1 = state_68290;
var statearr_68303_68346 = state_68290__$1;
(statearr_68303_68346[(2)] = inst_68278);

(statearr_68303_68346[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (17))){
var inst_68241 = (state_68290[(7)]);
var inst_68260 = (state_68290[(2)]);
var state_68290__$1 = (function (){var statearr_68304 = state_68290;
(statearr_68304[(11)] = inst_68260);

return statearr_68304;
})();
if(cljs.core.truth_(inst_68241)){
var statearr_68305_68347 = state_68290__$1;
(statearr_68305_68347[(1)] = (18));

} else {
var statearr_68306_68348 = state_68290__$1;
(statearr_68306_68348[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (3))){
var inst_68288 = (state_68290[(2)]);
var state_68290__$1 = state_68290;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68290__$1,inst_68288);
} else {
if((state_val_68291 === (12))){
var inst_68239 = (state_68290[(13)]);
var state_68290__$1 = state_68290;
var statearr_68307_68349 = state_68290__$1;
(statearr_68307_68349[(2)] = inst_68239);

(statearr_68307_68349[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (2))){
var _ = (function (){var statearr_68308 = state_68290;
(statearr_68308[(4)] = cljs.core.cons.call(null,(5),(state_68290[(4)])));

return statearr_68308;
})();
var inst_68230 = (opts == null);
var state_68290__$1 = state_68290;
if(cljs.core.truth_(inst_68230)){
var statearr_68309_68350 = state_68290__$1;
(statearr_68309_68350[(1)] = (6));

} else {
var statearr_68310_68351 = state_68290__$1;
(statearr_68310_68351[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (23))){
var inst_68280 = (state_68290[(2)]);
var inst_68281 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68282 = [(200),inst_68280];
var inst_68283 = cljs.core.PersistentHashMap.fromArrays(inst_68281,inst_68282);
var inst_68284 = cljs.core.clj__GT_js.call(null,inst_68283);
var inst_68285 = resolve.call(null,inst_68284);
var _ = (function (){var statearr_68311 = state_68290;
(statearr_68311[(4)] = cljs.core.rest.call(null,(state_68290[(4)])));

return statearr_68311;
})();
var state_68290__$1 = state_68290;
var statearr_68312_68352 = state_68290__$1;
(statearr_68312_68352[(2)] = inst_68285);

(statearr_68312_68352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (19))){
var state_68290__$1 = state_68290;
var statearr_68313_68353 = state_68290__$1;
(statearr_68313_68353[(2)] = null);

(statearr_68313_68353[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (11))){
var inst_68239 = (state_68290[(13)]);
var inst_68246 = (state_68290[(2)]);
var state_68290__$1 = (function (){var statearr_68315 = state_68290;
(statearr_68315[(14)] = inst_68246);

return statearr_68315;
})();
if(cljs.core.truth_(inst_68239)){
var statearr_68316_68354 = state_68290__$1;
(statearr_68316_68354[(1)] = (12));

} else {
var statearr_68317_68355 = state_68290__$1;
(statearr_68317_68355[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (9))){
var inst_68238 = (state_68290[(15)]);
var state_68290__$1 = state_68290;
var statearr_68318_68356 = state_68290__$1;
(statearr_68318_68356[(2)] = inst_68238);

(statearr_68318_68356[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (5))){
var _ = (function (){var statearr_68319 = state_68290;
(statearr_68319[(4)] = cljs.core.rest.call(null,(state_68290[(4)])));

return statearr_68319;
})();
var state_68290__$1 = state_68290;
var ex68314 = (state_68290__$1[(2)]);
var statearr_68320_68357 = state_68290__$1;
(statearr_68320_68357[(5)] = ex68314);


var statearr_68321_68358 = state_68290__$1;
(statearr_68321_68358[(1)] = (4));

(statearr_68321_68358[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (14))){
var inst_68246 = (state_68290[(14)]);
var inst_68241 = (state_68290[(7)]);
var inst_68251 = (state_68290[(2)]);
var inst_68252 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_68253 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_68246,inst_68251];
var inst_68254 = cljs.core.PersistentHashMap.fromArrays(inst_68252,inst_68253);
var state_68290__$1 = (function (){var statearr_68322 = state_68290;
(statearr_68322[(10)] = inst_68254);

return statearr_68322;
})();
if(cljs.core.truth_(inst_68241)){
var statearr_68323_68359 = state_68290__$1;
(statearr_68323_68359[(1)] = (15));

} else {
var statearr_68324_68360 = state_68290__$1;
(statearr_68324_68360[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (16))){
var state_68290__$1 = state_68290;
var statearr_68325_68361 = state_68290__$1;
(statearr_68325_68361[(2)] = null);

(statearr_68325_68361[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (10))){
var inst_68242 = (state_68290[(12)]);
var state_68290__$1 = state_68290;
var statearr_68326_68362 = state_68290__$1;
(statearr_68326_68362[(2)] = inst_68242);

(statearr_68326_68362[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (18))){
var inst_68260 = (state_68290[(11)]);
var inst_68241 = (state_68290[(7)]);
var inst_68262 = fluree.crypto.sign_message.call(null,inst_68260,inst_68241);
var state_68290__$1 = state_68290;
var statearr_68327_68363 = state_68290__$1;
(statearr_68327_68363[(2)] = inst_68262);

(statearr_68327_68363[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68291 === (8))){
var inst_68238 = (state_68290[(15)]);
var inst_68235 = (state_68290[(2)]);
var inst_68236 = fluree.db.connection_js.check_connection.call(null,conn,inst_68235);
var inst_68237 = cljs.core.__destructure_map.call(null,inst_68235);
var inst_68238__$1 = cljs.core.get.call(null,inst_68237,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_68239 = cljs.core.get.call(null,inst_68237,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_68240 = cljs.core.get.call(null,inst_68237,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_68241 = cljs.core.get.call(null,inst_68237,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_68242 = fluree.db.util.core.current_time_millis.call(null);
var state_68290__$1 = (function (){var statearr_68328 = state_68290;
(statearr_68328[(12)] = inst_68242);

(statearr_68328[(7)] = inst_68241);

(statearr_68328[(16)] = inst_68236);

(statearr_68328[(13)] = inst_68239);

(statearr_68328[(17)] = inst_68240);

(statearr_68328[(15)] = inst_68238__$1);

return statearr_68328;
})();
if(cljs.core.truth_(inst_68238__$1)){
var statearr_68329_68364 = state_68290__$1;
(statearr_68329_68364[(1)] = (9));

} else {
var statearr_68330_68365 = state_68290__$1;
(statearr_68330_68365[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_68331 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68331[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_68331[(1)] = (1));

return statearr_68331;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_68290){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68332){var ex__2744__auto__ = e68332;
var statearr_68333_68366 = state_68290;
(statearr_68333_68366[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68290[(4)]))){
var statearr_68334_68367 = state_68290;
(statearr_68334_68367[(1)] = cljs.core.first.call(null,(state_68290[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68368 = state_68290;
state_68290 = G__68368;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_68290){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_68290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68335 = f__2764__auto__.call(null);
(statearr_68335[(6)] = c__2763__auto__);

return statearr_68335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.deleteLedger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise with ledger's status as a map, including index, indexes, block, and status.
 *    If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledgerInfo = (function flureenjs$ledgerInfo(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68387){
var state_val_68388 = (state_68387[(1)]);
if((state_val_68388 === (1))){
var state_68387__$1 = state_68387;
var statearr_68389_68404 = state_68387__$1;
(statearr_68389_68404[(2)] = null);

(statearr_68389_68404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68388 === (2))){
var _ = (function (){var statearr_68390 = state_68387;
(statearr_68390[(4)] = cljs.core.cons.call(null,(5),(state_68387[(4)])));

return statearr_68390;
})();
var inst_68377 = fluree.db.operations.ledger_stats_async.call(null,conn,ledger);
var state_68387__$1 = state_68387;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68387__$1,(6),inst_68377);
} else {
if((state_val_68388 === (3))){
var inst_68385 = (state_68387[(2)]);
var state_68387__$1 = state_68387;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68387__$1,inst_68385);
} else {
if((state_val_68388 === (4))){
var inst_68369 = (state_68387[(2)]);
var inst_68370 = fluree.db.util.log.error.call(null,inst_68369);
var inst_68371 = reject.call(null,inst_68369);
var state_68387__$1 = (function (){var statearr_68392 = state_68387;
(statearr_68392[(7)] = inst_68370);

return statearr_68392;
})();
var statearr_68393_68405 = state_68387__$1;
(statearr_68393_68405[(2)] = inst_68371);

(statearr_68393_68405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68388 === (5))){
var _ = (function (){var statearr_68394 = state_68387;
(statearr_68394[(4)] = cljs.core.rest.call(null,(state_68387[(4)])));

return statearr_68394;
})();
var state_68387__$1 = state_68387;
var ex68391 = (state_68387__$1[(2)]);
var statearr_68395_68406 = state_68387__$1;
(statearr_68395_68406[(5)] = ex68391);


var statearr_68396_68407 = state_68387__$1;
(statearr_68396_68407[(1)] = (4));

(statearr_68396_68407[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68388 === (6))){
var inst_68379 = (state_68387[(2)]);
var inst_68380 = fluree.db.util.async.throw_err.call(null,inst_68379);
var inst_68381 = cljs.core.clj__GT_js.call(null,inst_68380);
var inst_68382 = resolve.call(null,inst_68381);
var _ = (function (){var statearr_68397 = state_68387;
(statearr_68397[(4)] = cljs.core.rest.call(null,(state_68387[(4)])));

return statearr_68397;
})();
var state_68387__$1 = state_68387;
var statearr_68398_68408 = state_68387__$1;
(statearr_68398_68408[(2)] = inst_68382);

(statearr_68398_68408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledgerInfo_$_state_machine__2741__auto__ = null;
var flureenjs$ledgerInfo_$_state_machine__2741__auto____0 = (function (){
var statearr_68399 = [null,null,null,null,null,null,null,null];
(statearr_68399[(0)] = flureenjs$ledgerInfo_$_state_machine__2741__auto__);

(statearr_68399[(1)] = (1));

return statearr_68399;
});
var flureenjs$ledgerInfo_$_state_machine__2741__auto____1 = (function (state_68387){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68387);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68400){var ex__2744__auto__ = e68400;
var statearr_68401_68409 = state_68387;
(statearr_68401_68409[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68387[(4)]))){
var statearr_68402_68410 = state_68387;
(statearr_68402_68410[(1)] = cljs.core.first.call(null,(state_68387[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68411 = state_68387;
state_68387 = G__68411;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$ledgerInfo_$_state_machine__2741__auto__ = function(state_68387){
switch(arguments.length){
case 0:
return flureenjs$ledgerInfo_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$ledgerInfo_$_state_machine__2741__auto____1.call(this,state_68387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledgerInfo_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledgerInfo_$_state_machine__2741__auto____0;
flureenjs$ledgerInfo_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledgerInfo_$_state_machine__2741__auto____1;
return flureenjs$ledgerInfo_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68403 = f__2764__auto__.call(null);
(statearr_68403[(6)] = c__2763__auto__);

return statearr_68403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.ledgerInfo', flureenjs.ledgerInfo);
/**
 * Returns promise with a list of ledgers the connected server is currently serving.
 */
flureenjs.ledgerList = (function flureenjs$ledgerList(conn){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68430){
var state_val_68431 = (state_68430[(1)]);
if((state_val_68431 === (1))){
var state_68430__$1 = state_68430;
var statearr_68432_68447 = state_68430__$1;
(statearr_68432_68447[(2)] = null);

(statearr_68432_68447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68431 === (2))){
var _ = (function (){var statearr_68433 = state_68430;
(statearr_68433[(4)] = cljs.core.cons.call(null,(5),(state_68430[(4)])));

return statearr_68433;
})();
var inst_68420 = fluree.db.operations.ledgers_async.call(null,conn);
var state_68430__$1 = state_68430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68430__$1,(6),inst_68420);
} else {
if((state_val_68431 === (3))){
var inst_68428 = (state_68430[(2)]);
var state_68430__$1 = state_68430;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68430__$1,inst_68428);
} else {
if((state_val_68431 === (4))){
var inst_68412 = (state_68430[(2)]);
var inst_68413 = fluree.db.util.log.error.call(null,inst_68412);
var inst_68414 = reject.call(null,inst_68412);
var state_68430__$1 = (function (){var statearr_68435 = state_68430;
(statearr_68435[(7)] = inst_68413);

return statearr_68435;
})();
var statearr_68436_68448 = state_68430__$1;
(statearr_68436_68448[(2)] = inst_68414);

(statearr_68436_68448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68431 === (5))){
var _ = (function (){var statearr_68437 = state_68430;
(statearr_68437[(4)] = cljs.core.rest.call(null,(state_68430[(4)])));

return statearr_68437;
})();
var state_68430__$1 = state_68430;
var ex68434 = (state_68430__$1[(2)]);
var statearr_68438_68449 = state_68430__$1;
(statearr_68438_68449[(5)] = ex68434);


var statearr_68439_68450 = state_68430__$1;
(statearr_68439_68450[(1)] = (4));

(statearr_68439_68450[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68431 === (6))){
var inst_68422 = (state_68430[(2)]);
var inst_68423 = fluree.db.util.async.throw_err.call(null,inst_68422);
var inst_68424 = cljs.core.clj__GT_js.call(null,inst_68423);
var inst_68425 = resolve.call(null,inst_68424);
var _ = (function (){var statearr_68440 = state_68430;
(statearr_68440[(4)] = cljs.core.rest.call(null,(state_68430[(4)])));

return statearr_68440;
})();
var state_68430__$1 = state_68430;
var statearr_68441_68451 = state_68430__$1;
(statearr_68441_68451[(2)] = inst_68425);

(statearr_68441_68451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledgerList_$_state_machine__2741__auto__ = null;
var flureenjs$ledgerList_$_state_machine__2741__auto____0 = (function (){
var statearr_68442 = [null,null,null,null,null,null,null,null];
(statearr_68442[(0)] = flureenjs$ledgerList_$_state_machine__2741__auto__);

(statearr_68442[(1)] = (1));

return statearr_68442;
});
var flureenjs$ledgerList_$_state_machine__2741__auto____1 = (function (state_68430){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68443){var ex__2744__auto__ = e68443;
var statearr_68444_68452 = state_68430;
(statearr_68444_68452[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68430[(4)]))){
var statearr_68445_68453 = state_68430;
(statearr_68445_68453[(1)] = cljs.core.first.call(null,(state_68430[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68454 = state_68430;
state_68430 = G__68454;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$ledgerList_$_state_machine__2741__auto__ = function(state_68430){
switch(arguments.length){
case 0:
return flureenjs$ledgerList_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$ledgerList_$_state_machine__2741__auto____1.call(this,state_68430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledgerList_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledgerList_$_state_machine__2741__auto____0;
flureenjs$ledgerList_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledgerList_$_state_machine__2741__auto____1;
return flureenjs$ledgerList_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68446 = f__2764__auto__.call(null);
(statearr_68446[(6)] = c__2763__auto__);

return statearr_68446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.ledgerList', flureenjs.ledgerList);
/**
 * Attempts to create new ledger.
 * 
 *     A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 *     Once successful, will return with a command-id.
 * 
 *     Ledger creation is handled asynchronously and may not be immediately available.
 * 
 *     Options include:
 *     - :alias       - Alias, if different than db-ident.
 *     - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 *     - :doc         - Optional doc string about this db.
 *     - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 *     - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 *     - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 *     
 */
flureenjs.newLedger = (function flureenjs$newLedger(var_args){
var G__68456 = arguments.length;
switch (G__68456) {
case 2:
return flureenjs.newLedger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.newLedger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.newLedger', flureenjs.newLedger);

(flureenjs.newLedger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.newLedger.call(null,conn,ledger,null);
}));

(flureenjs.newLedger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68574){
var state_val_68575 = (state_68574[(1)]);
if((state_val_68575 === (7))){
var inst_68479 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_68574__$1 = state_68574;
var statearr_68576_68641 = state_68574__$1;
(statearr_68576_68641[(2)] = inst_68479);

(statearr_68576_68641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (20))){
var inst_68486 = (state_68574[(7)]);
var inst_68524 = (state_68574[(2)]);
var inst_68525 = fluree.db.util.core.current_time_millis.call(null);
var state_68574__$1 = (function (){var statearr_68577 = state_68574;
(statearr_68577[(8)] = inst_68524);

(statearr_68577[(9)] = inst_68525);

return statearr_68577;
})();
if(cljs.core.truth_(inst_68486)){
var statearr_68578_68642 = state_68574__$1;
(statearr_68578_68642[(1)] = (21));

} else {
var statearr_68579_68643 = state_68574__$1;
(statearr_68579_68643[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (27))){
var inst_68538 = (state_68574[(10)]);
var inst_68540 = fluree.db.util.core.without_nils.call(null,inst_68538);
var inst_68541 = fluree.db.util.json.stringify.call(null,inst_68540);
var state_68574__$1 = state_68574;
var statearr_68580_68644 = state_68574__$1;
(statearr_68580_68644[(2)] = inst_68541);

(statearr_68580_68644[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (1))){
var state_68574__$1 = state_68574;
var statearr_68581_68645 = state_68574__$1;
(statearr_68581_68645[(2)] = null);

(statearr_68581_68645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (24))){
var inst_68492 = (state_68574[(11)]);
var state_68574__$1 = state_68574;
var statearr_68582_68646 = state_68574__$1;
(statearr_68582_68646[(2)] = inst_68492);

(statearr_68582_68646[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (4))){
var inst_68457 = (state_68574[(2)]);
var inst_68458 = fluree.db.util.log.error.call(null,inst_68457);
var inst_68459 = cljs.core.ex_data.call(null,inst_68457);
var inst_68460 = cljs.core.ex_message.call(null,inst_68457);
var inst_68461 = cljs.core.assoc.call(null,inst_68459,new cljs.core.Keyword(null,"message","message",-406056002),inst_68460);
var inst_68462 = cljs.core.clj__GT_js.call(null,inst_68461);
var inst_68463 = reject.call(null,inst_68462);
var state_68574__$1 = (function (){var statearr_68583 = state_68574;
(statearr_68583[(12)] = inst_68458);

return statearr_68583;
})();
var statearr_68584_68647 = state_68574__$1;
(statearr_68584_68647[(2)] = inst_68463);

(statearr_68584_68647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (15))){
var inst_68514 = (state_68574[(13)]);
var inst_68516 = fluree.db.graphdb.validate_ledger_name.call(null,inst_68514,"alias");
var state_68574__$1 = state_68574;
var statearr_68585_68648 = state_68574__$1;
(statearr_68585_68648[(2)] = inst_68516);

(statearr_68585_68648[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (21))){
var inst_68486 = (state_68574[(7)]);
var state_68574__$1 = state_68574;
var statearr_68586_68649 = state_68574__$1;
(statearr_68586_68649[(2)] = inst_68486);

(statearr_68586_68649[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (31))){
var state_68574__$1 = state_68574;
var statearr_68587_68650 = state_68574__$1;
(statearr_68587_68650[(2)] = null);

(statearr_68587_68650[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (32))){
var inst_68488 = (state_68574[(14)]);
var inst_68549 = (state_68574[(2)]);
var state_68574__$1 = (function (){var statearr_68588 = state_68574;
(statearr_68588[(15)] = inst_68549);

return statearr_68588;
})();
if(cljs.core.truth_(inst_68488)){
var statearr_68589_68651 = state_68574__$1;
(statearr_68589_68651[(1)] = (33));

} else {
var statearr_68590_68652 = state_68574__$1;
(statearr_68590_68652[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (33))){
var inst_68544 = (state_68574[(16)]);
var inst_68549 = (state_68574[(15)]);
var inst_68551 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_68552 = [inst_68544,inst_68549];
var inst_68553 = cljs.core.PersistentHashMap.fromArrays(inst_68551,inst_68552);
var inst_68554 = fluree.db.operations.command_async.call(null,conn,inst_68553);
var state_68574__$1 = state_68574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68574__$1,(36),inst_68554);
} else {
if((state_val_68575 === (13))){
var state_68574__$1 = state_68574;
var statearr_68591_68653 = state_68574__$1;
(statearr_68591_68653[(2)] = null);

(statearr_68591_68653[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (22))){
var inst_68525 = (state_68574[(9)]);
var state_68574__$1 = state_68574;
var statearr_68592_68654 = state_68574__$1;
(statearr_68592_68654[(2)] = inst_68525);

(statearr_68592_68654[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (36))){
var inst_68556 = (state_68574[(2)]);
var inst_68557 = fluree.db.util.async.throw_err.call(null,inst_68556);
var state_68574__$1 = state_68574;
var statearr_68593_68655 = state_68574__$1;
(statearr_68593_68655[(2)] = inst_68557);

(statearr_68593_68655[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (29))){
var inst_68488 = (state_68574[(14)]);
var inst_68544 = (state_68574[(2)]);
var state_68574__$1 = (function (){var statearr_68594 = state_68574;
(statearr_68594[(16)] = inst_68544);

return statearr_68594;
})();
if(cljs.core.truth_(inst_68488)){
var statearr_68595_68656 = state_68574__$1;
(statearr_68595_68656[(1)] = (30));

} else {
var statearr_68596_68657 = state_68574__$1;
(statearr_68596_68657[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (6))){
var state_68574__$1 = state_68574;
var statearr_68597_68658 = state_68574__$1;
(statearr_68597_68658[(2)] = null);

(statearr_68597_68658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (28))){
var state_68574__$1 = state_68574;
var statearr_68598_68659 = state_68574__$1;
(statearr_68598_68659[(2)] = null);

(statearr_68598_68659[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (25))){
var inst_68525 = (state_68574[(9)]);
var inst_68532 = (inst_68525 + (30000));
var state_68574__$1 = state_68574;
var statearr_68599_68660 = state_68574__$1;
(statearr_68599_68660[(2)] = inst_68532);

(statearr_68599_68660[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (34))){
var inst_68538 = (state_68574[(10)]);
var inst_68559 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_68538);
var state_68574__$1 = state_68574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68574__$1,(37),inst_68559);
} else {
if((state_val_68575 === (17))){
var inst_68495 = (state_68574[(17)]);
var inst_68519 = (state_68574[(2)]);
var state_68574__$1 = (function (){var statearr_68600 = state_68574;
(statearr_68600[(18)] = inst_68519);

return statearr_68600;
})();
if(cljs.core.truth_(inst_68495)){
var statearr_68601_68661 = state_68574__$1;
(statearr_68601_68661[(1)] = (18));

} else {
var statearr_68602_68662 = state_68574__$1;
(statearr_68602_68662[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (3))){
var inst_68572 = (state_68574[(2)]);
var state_68574__$1 = state_68574;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68574__$1,inst_68572);
} else {
if((state_val_68575 === (12))){
var inst_68509 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var state_68574__$1 = state_68574;
var statearr_68603_68663 = state_68574__$1;
(statearr_68603_68663[(2)] = inst_68509);

(statearr_68603_68663[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (2))){
var _ = (function (){var statearr_68604 = state_68574;
(statearr_68604[(4)] = cljs.core.cons.call(null,(5),(state_68574[(4)])));

return statearr_68604;
})();
var inst_68476 = (opts == null);
var state_68574__$1 = state_68574;
if(cljs.core.truth_(inst_68476)){
var statearr_68605_68664 = state_68574__$1;
(statearr_68605_68664[(1)] = (6));

} else {
var statearr_68606_68665 = state_68574__$1;
(statearr_68606_68665[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (23))){
var inst_68492 = (state_68574[(11)]);
var inst_68529 = (state_68574[(2)]);
var state_68574__$1 = (function (){var statearr_68607 = state_68574;
(statearr_68607[(19)] = inst_68529);

return statearr_68607;
})();
if(cljs.core.truth_(inst_68492)){
var statearr_68608_68666 = state_68574__$1;
(statearr_68608_68666[(1)] = (24));

} else {
var statearr_68609_68667 = state_68574__$1;
(statearr_68609_68667[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (35))){
var inst_68564 = (state_68574[(2)]);
var inst_68565 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68566 = [(200),inst_68564];
var inst_68567 = cljs.core.PersistentHashMap.fromArrays(inst_68565,inst_68566);
var inst_68568 = cljs.core.clj__GT_js.call(null,inst_68567);
var inst_68569 = resolve.call(null,inst_68568);
var _ = (function (){var statearr_68610 = state_68574;
(statearr_68610[(4)] = cljs.core.rest.call(null,(state_68574[(4)])));

return statearr_68610;
})();
var state_68574__$1 = state_68574;
var statearr_68611_68668 = state_68574__$1;
(statearr_68611_68668[(2)] = inst_68569);

(statearr_68611_68668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (19))){
var state_68574__$1 = state_68574;
var statearr_68612_68669 = state_68574__$1;
(statearr_68612_68669[(2)] = null);

(statearr_68612_68669[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (11))){
var inst_68498 = (state_68574[(20)]);
var inst_68505 = (state_68574[(21)]);
var inst_68495 = (state_68574[(17)]);
var inst_68505__$1 = (state_68574[(2)]);
var inst_68506 = fluree.db.graphdb.validate_ledger_name.call(null,inst_68505__$1,"ledger");
var inst_68507 = fluree.db.graphdb.validate_ledger_name.call(null,inst_68498,"network");
var state_68574__$1 = (function (){var statearr_68614 = state_68574;
(statearr_68614[(22)] = inst_68506);

(statearr_68614[(21)] = inst_68505__$1);

(statearr_68614[(23)] = inst_68507);

return statearr_68614;
})();
if(cljs.core.truth_(inst_68495)){
var statearr_68615_68670 = state_68574__$1;
(statearr_68615_68670[(1)] = (12));

} else {
var statearr_68616_68671 = state_68574__$1;
(statearr_68616_68671[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (9))){
var inst_68499 = (state_68574[(24)]);
var inst_68502 = cljs.core.subs.call(null,inst_68499,(1));
var state_68574__$1 = state_68574;
var statearr_68617_68672 = state_68574__$1;
(statearr_68617_68672[(2)] = inst_68502);

(statearr_68617_68672[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (5))){
var _ = (function (){var statearr_68618 = state_68574;
(statearr_68618[(4)] = cljs.core.rest.call(null,(state_68574[(4)])));

return statearr_68618;
})();
var state_68574__$1 = state_68574;
var ex68613 = (state_68574__$1[(2)]);
var statearr_68619_68673 = state_68574__$1;
(statearr_68619_68673[(5)] = ex68613);


var statearr_68620_68674 = state_68574__$1;
(statearr_68620_68674[(1)] = (4));

(statearr_68620_68674[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (14))){
var inst_68495 = (state_68574[(17)]);
var inst_68512 = (state_68574[(2)]);
var inst_68513 = cljs.core.nth.call(null,inst_68512,(0),null);
var inst_68514 = cljs.core.nth.call(null,inst_68512,(1),null);
var state_68574__$1 = (function (){var statearr_68621 = state_68574;
(statearr_68621[(13)] = inst_68514);

(statearr_68621[(25)] = inst_68513);

return statearr_68621;
})();
if(cljs.core.truth_(inst_68495)){
var statearr_68622_68675 = state_68574__$1;
(statearr_68622_68675[(1)] = (15));

} else {
var statearr_68623_68676 = state_68574__$1;
(statearr_68623_68676[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (26))){
var inst_68498 = (state_68574[(20)]);
var inst_68489 = (state_68574[(26)]);
var inst_68529 = (state_68574[(19)]);
var inst_68490 = (state_68574[(27)]);
var inst_68505 = (state_68574[(21)]);
var inst_68524 = (state_68574[(8)]);
var inst_68487 = (state_68574[(28)]);
var inst_68493 = (state_68574[(29)]);
var inst_68494 = (state_68574[(30)]);
var inst_68491 = (state_68574[(31)]);
var inst_68496 = (state_68574[(32)]);
var inst_68488 = (state_68574[(14)]);
var inst_68485 = (state_68574[(33)]);
var inst_68534 = (state_68574[(2)]);
var inst_68535 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_68536 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68498),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68505)].join('');
var inst_68537 = [inst_68536,inst_68490,inst_68491,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_68534,inst_68493,inst_68524,inst_68496,inst_68494,inst_68485,inst_68529,inst_68487,inst_68489];
var inst_68538 = cljs.core.PersistentHashMap.fromArrays(inst_68535,inst_68537);
var state_68574__$1 = (function (){var statearr_68624 = state_68574;
(statearr_68624[(10)] = inst_68538);

return statearr_68624;
})();
if(cljs.core.truth_(inst_68488)){
var statearr_68625_68677 = state_68574__$1;
(statearr_68625_68677[(1)] = (27));

} else {
var statearr_68626_68678 = state_68574__$1;
(statearr_68626_68678[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (16))){
var state_68574__$1 = state_68574;
var statearr_68627_68679 = state_68574__$1;
(statearr_68627_68679[(2)] = null);

(statearr_68627_68679[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (30))){
var inst_68544 = (state_68574[(16)]);
var inst_68488 = (state_68574[(14)]);
var inst_68546 = fluree.crypto.sign_message.call(null,inst_68544,inst_68488);
var state_68574__$1 = state_68574;
var statearr_68628_68680 = state_68574__$1;
(statearr_68628_68680[(2)] = inst_68546);

(statearr_68628_68680[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (10))){
var inst_68499 = (state_68574[(24)]);
var state_68574__$1 = state_68574;
var statearr_68629_68681 = state_68574__$1;
(statearr_68629_68681[(2)] = inst_68499);

(statearr_68629_68681[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (18))){
var inst_68514 = (state_68574[(13)]);
var inst_68513 = (state_68574[(25)]);
var inst_68521 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68513),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68514)].join('');
var state_68574__$1 = state_68574;
var statearr_68630_68682 = state_68574__$1;
(statearr_68630_68682[(2)] = inst_68521);

(statearr_68630_68682[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (37))){
var inst_68561 = (state_68574[(2)]);
var inst_68562 = fluree.db.util.async.throw_err.call(null,inst_68561);
var state_68574__$1 = state_68574;
var statearr_68631_68683 = state_68574__$1;
(statearr_68631_68683[(2)] = inst_68562);

(statearr_68631_68683[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68575 === (8))){
var inst_68499 = (state_68574[(24)]);
var inst_68481 = (state_68574[(2)]);
var inst_68482 = fluree.db.connection_js.check_connection.call(null,conn,inst_68481);
var inst_68483 = cljs.core.__destructure_map.call(null,inst_68481);
var inst_68484 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_68485 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_68486 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_68487 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_68488 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_68489 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_68490 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_68491 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_68492 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_68493 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_68494 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_68495 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_68496 = cljs.core.get.call(null,inst_68483,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_68497 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var inst_68498 = cljs.core.nth.call(null,inst_68497,(0),null);
var inst_68499__$1 = cljs.core.nth.call(null,inst_68497,(1),null);
var inst_68500 = clojure.string.starts_with_QMARK_.call(null,inst_68499__$1,"$");
var state_68574__$1 = (function (){var statearr_68632 = state_68574;
(statearr_68632[(20)] = inst_68498);

(statearr_68632[(26)] = inst_68489);

(statearr_68632[(27)] = inst_68490);

(statearr_68632[(34)] = inst_68484);

(statearr_68632[(35)] = inst_68482);

(statearr_68632[(11)] = inst_68492);

(statearr_68632[(7)] = inst_68486);

(statearr_68632[(24)] = inst_68499__$1);

(statearr_68632[(17)] = inst_68495);

(statearr_68632[(28)] = inst_68487);

(statearr_68632[(29)] = inst_68493);

(statearr_68632[(30)] = inst_68494);

(statearr_68632[(31)] = inst_68491);

(statearr_68632[(32)] = inst_68496);

(statearr_68632[(14)] = inst_68488);

(statearr_68632[(33)] = inst_68485);

return statearr_68632;
})();
if(inst_68500){
var statearr_68633_68684 = state_68574__$1;
(statearr_68633_68684[(1)] = (9));

} else {
var statearr_68634_68685 = state_68574__$1;
(statearr_68634_68685[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_68635 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68635[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_68635[(1)] = (1));

return statearr_68635;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_68574){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68574);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68636){var ex__2744__auto__ = e68636;
var statearr_68637_68686 = state_68574;
(statearr_68637_68686[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68574[(4)]))){
var statearr_68638_68687 = state_68574;
(statearr_68638_68687[(1)] = cljs.core.first.call(null,(state_68574[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68688 = state_68574;
state_68574 = G__68688;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_68574){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_68574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68639 = f__2764__auto__.call(null);
(statearr_68639[(6)] = c__2763__auto__);

return statearr_68639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.newLedger.cljs$lang$maxFixedArity = 3);

/**
 * Resolves a ledger identity in the form of 'network/ledger-or-alias' and returns a
 *    tuple of either [network ledger alias] or [network ledger].
 * 
 *    An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *    the provided name is a ledger id.
 * 
 *    If you are providing a ledger id, and wish to skip an alias lookup, a prefix of '$'
 *    can be used for the name portion of the db-ident.
 * 
 *    i.e.
 *    - testnet/testledger - Look for ledger with an alias or id of testledger on network testnet.
 *    - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 */
flureenjs.resolveLedger = (function flureenjs$resolveLedger(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68704){
var state_val_68705 = (state_68704[(1)]);
if((state_val_68705 === (1))){
var state_68704__$1 = state_68704;
var statearr_68706_68721 = state_68704__$1;
(statearr_68706_68721[(2)] = null);

(statearr_68706_68721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68705 === (2))){
var _ = (function (){var statearr_68707 = state_68704;
(statearr_68707[(4)] = cljs.core.cons.call(null,(5),(state_68704[(4)])));

return statearr_68707;
})();
var inst_68697 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_68698 = cljs.core.clj__GT_js.call(null,inst_68697);
var inst_68699 = resolve.call(null,inst_68698);
var ___$1 = (function (){var statearr_68708 = state_68704;
(statearr_68708[(4)] = cljs.core.rest.call(null,(state_68704[(4)])));

return statearr_68708;
})();
var state_68704__$1 = state_68704;
var statearr_68709_68722 = state_68704__$1;
(statearr_68709_68722[(2)] = inst_68699);

(statearr_68709_68722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68705 === (3))){
var inst_68702 = (state_68704[(2)]);
var state_68704__$1 = state_68704;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68704__$1,inst_68702);
} else {
if((state_val_68705 === (4))){
var inst_68689 = (state_68704[(2)]);
var inst_68690 = fluree.db.util.log.error.call(null,inst_68689);
var inst_68691 = reject.call(null,inst_68689);
var state_68704__$1 = (function (){var statearr_68711 = state_68704;
(statearr_68711[(7)] = inst_68690);

return statearr_68711;
})();
var statearr_68712_68723 = state_68704__$1;
(statearr_68712_68723[(2)] = inst_68691);

(statearr_68712_68723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68705 === (5))){
var _ = (function (){var statearr_68713 = state_68704;
(statearr_68713[(4)] = cljs.core.rest.call(null,(state_68704[(4)])));

return statearr_68713;
})();
var state_68704__$1 = state_68704;
var ex68710 = (state_68704__$1[(2)]);
var statearr_68714_68724 = state_68704__$1;
(statearr_68714_68724[(5)] = ex68710);


var statearr_68715_68725 = state_68704__$1;
(statearr_68715_68725[(1)] = (4));

(statearr_68715_68725[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$resolveLedger_$_state_machine__2741__auto__ = null;
var flureenjs$resolveLedger_$_state_machine__2741__auto____0 = (function (){
var statearr_68716 = [null,null,null,null,null,null,null,null];
(statearr_68716[(0)] = flureenjs$resolveLedger_$_state_machine__2741__auto__);

(statearr_68716[(1)] = (1));

return statearr_68716;
});
var flureenjs$resolveLedger_$_state_machine__2741__auto____1 = (function (state_68704){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68704);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68717){var ex__2744__auto__ = e68717;
var statearr_68718_68726 = state_68704;
(statearr_68718_68726[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68704[(4)]))){
var statearr_68719_68727 = state_68704;
(statearr_68719_68727[(1)] = cljs.core.first.call(null,(state_68704[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68728 = state_68704;
state_68704 = G__68728;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$resolveLedger_$_state_machine__2741__auto__ = function(state_68704){
switch(arguments.length){
case 0:
return flureenjs$resolveLedger_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$resolveLedger_$_state_machine__2741__auto____1.call(this,state_68704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$resolveLedger_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$resolveLedger_$_state_machine__2741__auto____0;
flureenjs$resolveLedger_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$resolveLedger_$_state_machine__2741__auto____1;
return flureenjs$resolveLedger_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68720 = f__2764__auto__.call(null);
(statearr_68720[(6)] = c__2763__auto__);

return statearr_68720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.resolveLedger', flureenjs.resolveLedger);
/**
 * Returns session object for a given ledger.
 */
flureenjs.session = (function flureenjs$session(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68744){
var state_val_68745 = (state_68744[(1)]);
if((state_val_68745 === (1))){
var state_68744__$1 = state_68744;
var statearr_68746_68761 = state_68744__$1;
(statearr_68746_68761[(2)] = null);

(statearr_68746_68761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68745 === (2))){
var _ = (function (){var statearr_68747 = state_68744;
(statearr_68747[(4)] = cljs.core.cons.call(null,(5),(state_68744[(4)])));

return statearr_68747;
})();
var inst_68737 = fluree.db.session.session.call(null,conn,ledger);
var inst_68738 = cljs.core.clj__GT_js.call(null,inst_68737);
var inst_68739 = resolve.call(null,inst_68738);
var ___$1 = (function (){var statearr_68748 = state_68744;
(statearr_68748[(4)] = cljs.core.rest.call(null,(state_68744[(4)])));

return statearr_68748;
})();
var state_68744__$1 = state_68744;
var statearr_68749_68762 = state_68744__$1;
(statearr_68749_68762[(2)] = inst_68739);

(statearr_68749_68762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68745 === (3))){
var inst_68742 = (state_68744[(2)]);
var state_68744__$1 = state_68744;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68744__$1,inst_68742);
} else {
if((state_val_68745 === (4))){
var inst_68729 = (state_68744[(2)]);
var inst_68730 = fluree.db.util.log.error.call(null,inst_68729);
var inst_68731 = reject.call(null,inst_68729);
var state_68744__$1 = (function (){var statearr_68751 = state_68744;
(statearr_68751[(7)] = inst_68730);

return statearr_68751;
})();
var statearr_68752_68763 = state_68744__$1;
(statearr_68752_68763[(2)] = inst_68731);

(statearr_68752_68763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68745 === (5))){
var _ = (function (){var statearr_68753 = state_68744;
(statearr_68753[(4)] = cljs.core.rest.call(null,(state_68744[(4)])));

return statearr_68753;
})();
var state_68744__$1 = state_68744;
var ex68750 = (state_68744__$1[(2)]);
var statearr_68754_68764 = state_68744__$1;
(statearr_68754_68764[(5)] = ex68750);


var statearr_68755_68765 = state_68744__$1;
(statearr_68755_68765[(1)] = (4));

(statearr_68755_68765[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$session_$_state_machine__2741__auto__ = null;
var flureenjs$session_$_state_machine__2741__auto____0 = (function (){
var statearr_68756 = [null,null,null,null,null,null,null,null];
(statearr_68756[(0)] = flureenjs$session_$_state_machine__2741__auto__);

(statearr_68756[(1)] = (1));

return statearr_68756;
});
var flureenjs$session_$_state_machine__2741__auto____1 = (function (state_68744){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68744);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68757){var ex__2744__auto__ = e68757;
var statearr_68758_68766 = state_68744;
(statearr_68758_68766[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68744[(4)]))){
var statearr_68759_68767 = state_68744;
(statearr_68759_68767[(1)] = cljs.core.first.call(null,(state_68744[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68768 = state_68744;
state_68744 = G__68768;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$session_$_state_machine__2741__auto__ = function(state_68744){
switch(arguments.length){
case 0:
return flureenjs$session_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$session_$_state_machine__2741__auto____1.call(this,state_68744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$session_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$session_$_state_machine__2741__auto____0;
flureenjs$session_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$session_$_state_machine__2741__auto____1;
return flureenjs$session_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68760 = f__2764__auto__.call(null);
(statearr_68760[(6)] = c__2763__auto__);

return statearr_68760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.session', flureenjs.session);
/**
 * Returns a promise containing search results of flake parts (flake-parts).
 */
flureenjs.search = (function flureenjs$search(db,flake_parts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68792){
var state_val_68793 = (state_68792[(1)]);
if((state_val_68793 === (1))){
var state_68792__$1 = state_68792;
var statearr_68794_68810 = state_68792__$1;
(statearr_68794_68810[(2)] = null);

(statearr_68794_68810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68793 === (2))){
var _ = (function (){var statearr_68795 = state_68792;
(statearr_68795[(4)] = cljs.core.cons.call(null,(5),(state_68792[(4)])));

return statearr_68795;
})();
var inst_68777 = cljs.core.js__GT_clj.call(null,flake_parts);
var state_68792__$1 = (function (){var statearr_68796 = state_68792;
(statearr_68796[(7)] = inst_68777);

return statearr_68796;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68792__$1,(7),db);
} else {
if((state_val_68793 === (3))){
var inst_68790 = (state_68792[(2)]);
var state_68792__$1 = state_68792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68792__$1,inst_68790);
} else {
if((state_val_68793 === (4))){
var inst_68769 = (state_68792[(2)]);
var inst_68770 = fluree.db.util.log.error.call(null,inst_68769);
var inst_68771 = reject.call(null,inst_68769);
var state_68792__$1 = (function (){var statearr_68798 = state_68792;
(statearr_68798[(8)] = inst_68770);

return statearr_68798;
})();
var statearr_68799_68811 = state_68792__$1;
(statearr_68799_68811[(2)] = inst_68771);

(statearr_68799_68811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68793 === (5))){
var _ = (function (){var statearr_68800 = state_68792;
(statearr_68800[(4)] = cljs.core.rest.call(null,(state_68792[(4)])));

return statearr_68800;
})();
var state_68792__$1 = state_68792;
var ex68797 = (state_68792__$1[(2)]);
var statearr_68801_68812 = state_68792__$1;
(statearr_68801_68812[(5)] = ex68797);


var statearr_68802_68813 = state_68792__$1;
(statearr_68802_68813[(1)] = (4));

(statearr_68802_68813[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68793 === (6))){
var inst_68783 = (state_68792[(2)]);
var inst_68784 = fluree.db.util.async.throw_err.call(null,inst_68783);
var inst_68785 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_68784);
var inst_68786 = cljs.core.clj__GT_js.call(null,inst_68785);
var inst_68787 = resolve.call(null,inst_68786);
var _ = (function (){var statearr_68803 = state_68792;
(statearr_68803[(4)] = cljs.core.rest.call(null,(state_68792[(4)])));

return statearr_68803;
})();
var state_68792__$1 = state_68792;
var statearr_68804_68814 = state_68792__$1;
(statearr_68804_68814[(2)] = inst_68787);

(statearr_68804_68814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68793 === (7))){
var inst_68777 = (state_68792[(7)]);
var inst_68779 = (state_68792[(2)]);
var inst_68780 = fluree.db.util.async.throw_err.call(null,inst_68779);
var inst_68781 = fluree.db.dbproto._search.call(null,inst_68780,inst_68777);
var state_68792__$1 = state_68792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68792__$1,(6),inst_68781);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$search_$_state_machine__2741__auto__ = null;
var flureenjs$search_$_state_machine__2741__auto____0 = (function (){
var statearr_68805 = [null,null,null,null,null,null,null,null,null];
(statearr_68805[(0)] = flureenjs$search_$_state_machine__2741__auto__);

(statearr_68805[(1)] = (1));

return statearr_68805;
});
var flureenjs$search_$_state_machine__2741__auto____1 = (function (state_68792){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68806){var ex__2744__auto__ = e68806;
var statearr_68807_68815 = state_68792;
(statearr_68807_68815[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68792[(4)]))){
var statearr_68808_68816 = state_68792;
(statearr_68808_68816[(1)] = cljs.core.first.call(null,(state_68792[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68817 = state_68792;
state_68792 = G__68817;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$search_$_state_machine__2741__auto__ = function(state_68792){
switch(arguments.length){
case 0:
return flureenjs$search_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$search_$_state_machine__2741__auto____1.call(this,state_68792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$search_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$search_$_state_machine__2741__auto____0;
flureenjs$search_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$search_$_state_machine__2741__auto____1;
return flureenjs$search_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68809 = f__2764__auto__.call(null);
(statearr_68809[(6)] = c__2763__auto__);

return statearr_68809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.search', flureenjs.search);
/**
 * Returns a promise containing a new db based on the provided db,
 *     including the provided flakes. Flakes can contain one or more 't's,
 *     but should be sequential and start after the current 't' of the provided
 *     db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.). Remember
 *     't' is negative and thus should be in descending order.
 * 
 *     A forward-time-travel db can be further forward-time-traveled.
 * 
 *     A forward-time travel DB is held in memory, and is not shared across servers.
 *     Ensure you have adequate memory to hold the flakes you generate and add. If
 *     access is provided via an external API, do any desired size restrictions or
 *     controls within your API endpoint.
 * 
 *     Remember schema operations done via forward-time-travel should be done in a
 *     't' prior to the flakes that end up requiring the schema change.
 */
flureenjs.forwardTimeTravel = (function flureenjs$forwardTimeTravel(db,flakes){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68838){
var state_val_68839 = (state_68838[(1)]);
if((state_val_68839 === (1))){
var state_68838__$1 = state_68838;
var statearr_68840_68856 = state_68838__$1;
(statearr_68840_68856[(2)] = null);

(statearr_68840_68856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68839 === (2))){
var _ = (function (){var statearr_68841 = state_68838;
(statearr_68841[(4)] = cljs.core.cons.call(null,(5),(state_68838[(4)])));

return statearr_68841;
})();
var inst_68826 = cljs.core.js__GT_clj.call(null,flakes);
var inst_68827 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_68826);
var state_68838__$1 = (function (){var statearr_68842 = state_68838;
(statearr_68842[(7)] = inst_68827);

return statearr_68842;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68838__$1,(6),db);
} else {
if((state_val_68839 === (3))){
var inst_68836 = (state_68838[(2)]);
var state_68838__$1 = state_68838;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68838__$1,inst_68836);
} else {
if((state_val_68839 === (4))){
var inst_68818 = (state_68838[(2)]);
var inst_68819 = fluree.db.util.log.error.call(null,inst_68818);
var inst_68820 = reject.call(null,inst_68818);
var state_68838__$1 = (function (){var statearr_68844 = state_68838;
(statearr_68844[(8)] = inst_68819);

return statearr_68844;
})();
var statearr_68845_68857 = state_68838__$1;
(statearr_68845_68857[(2)] = inst_68820);

(statearr_68845_68857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68839 === (5))){
var _ = (function (){var statearr_68846 = state_68838;
(statearr_68846[(4)] = cljs.core.rest.call(null,(state_68838[(4)])));

return statearr_68846;
})();
var state_68838__$1 = state_68838;
var ex68843 = (state_68838__$1[(2)]);
var statearr_68847_68858 = state_68838__$1;
(statearr_68847_68858[(5)] = ex68843);


var statearr_68848_68859 = state_68838__$1;
(statearr_68848_68859[(1)] = (4));

(statearr_68848_68859[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68839 === (6))){
var inst_68827 = (state_68838[(7)]);
var inst_68829 = (state_68838[(2)]);
var inst_68830 = fluree.db.util.async.throw_err.call(null,inst_68829);
var inst_68831 = fluree.db.graphdb.forward_time_travel.call(null,inst_68830,null,inst_68827);
var inst_68832 = cljs.core.clj__GT_js.call(null,inst_68831);
var inst_68833 = resolve.call(null,inst_68832);
var _ = (function (){var statearr_68849 = state_68838;
(statearr_68849[(4)] = cljs.core.rest.call(null,(state_68838[(4)])));

return statearr_68849;
})();
var state_68838__$1 = state_68838;
var statearr_68850_68860 = state_68838__$1;
(statearr_68850_68860[(2)] = inst_68833);

(statearr_68850_68860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$forwardTimeTravel_$_state_machine__2741__auto__ = null;
var flureenjs$forwardTimeTravel_$_state_machine__2741__auto____0 = (function (){
var statearr_68851 = [null,null,null,null,null,null,null,null,null];
(statearr_68851[(0)] = flureenjs$forwardTimeTravel_$_state_machine__2741__auto__);

(statearr_68851[(1)] = (1));

return statearr_68851;
});
var flureenjs$forwardTimeTravel_$_state_machine__2741__auto____1 = (function (state_68838){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68838);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68852){var ex__2744__auto__ = e68852;
var statearr_68853_68861 = state_68838;
(statearr_68853_68861[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68838[(4)]))){
var statearr_68854_68862 = state_68838;
(statearr_68854_68862[(1)] = cljs.core.first.call(null,(state_68838[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68863 = state_68838;
state_68838 = G__68863;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$forwardTimeTravel_$_state_machine__2741__auto__ = function(state_68838){
switch(arguments.length){
case 0:
return flureenjs$forwardTimeTravel_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$forwardTimeTravel_$_state_machine__2741__auto____1.call(this,state_68838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$forwardTimeTravel_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$forwardTimeTravel_$_state_machine__2741__auto____0;
flureenjs$forwardTimeTravel_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$forwardTimeTravel_$_state_machine__2741__auto____1;
return flureenjs$forwardTimeTravel_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68855 = f__2764__auto__.call(null);
(statearr_68855[(6)] = c__2763__auto__);

return statearr_68855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.forwardTimeTravel', flureenjs.forwardTimeTravel);
/**
 * Returns true if provided db is a forward-time-travel db.
 */
flureenjs.isForwardTimeTravelDb = (function flureenjs$isForwardTimeTravelDb(db){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68887){
var state_val_68888 = (state_68887[(1)]);
if((state_val_68888 === (7))){
var state_68887__$1 = state_68887;
var statearr_68889_68908 = state_68887__$1;
(statearr_68889_68908[(2)] = db);

(statearr_68889_68908[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68888 === (1))){
var state_68887__$1 = state_68887;
var statearr_68890_68909 = state_68887__$1;
(statearr_68890_68909[(2)] = null);

(statearr_68890_68909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68888 === (4))){
var inst_68864 = (state_68887[(2)]);
var inst_68865 = fluree.db.util.log.error.call(null,inst_68864);
var inst_68866 = reject.call(null,inst_68864);
var state_68887__$1 = (function (){var statearr_68891 = state_68887;
(statearr_68891[(7)] = inst_68865);

return statearr_68891;
})();
var statearr_68892_68910 = state_68887__$1;
(statearr_68892_68910[(2)] = inst_68866);

(statearr_68892_68910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68888 === (6))){
var state_68887__$1 = state_68887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68887__$1,(9),db);
} else {
if((state_val_68888 === (3))){
var inst_68885 = (state_68887[(2)]);
var state_68887__$1 = state_68887;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68887__$1,inst_68885);
} else {
if((state_val_68888 === (2))){
var _ = (function (){var statearr_68894 = state_68887;
(statearr_68894[(4)] = cljs.core.cons.call(null,(5),(state_68887[(4)])));

return statearr_68894;
})();
var inst_68872 = fluree.db.util.async.channel_QMARK_.call(null,db);
var state_68887__$1 = state_68887;
if(inst_68872){
var statearr_68895_68911 = state_68887__$1;
(statearr_68895_68911[(1)] = (6));

} else {
var statearr_68896_68912 = state_68887__$1;
(statearr_68896_68912[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68888 === (9))){
var inst_68875 = (state_68887[(2)]);
var inst_68876 = fluree.db.util.async.throw_err.call(null,inst_68875);
var state_68887__$1 = state_68887;
var statearr_68897_68913 = state_68887__$1;
(statearr_68897_68913[(2)] = inst_68876);

(statearr_68897_68913[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68888 === (5))){
var _ = (function (){var statearr_68898 = state_68887;
(statearr_68898[(4)] = cljs.core.rest.call(null,(state_68887[(4)])));

return statearr_68898;
})();
var state_68887__$1 = state_68887;
var ex68893 = (state_68887__$1[(2)]);
var statearr_68899_68914 = state_68887__$1;
(statearr_68899_68914[(5)] = ex68893);


var statearr_68900_68915 = state_68887__$1;
(statearr_68900_68915[(1)] = (4));

(statearr_68900_68915[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68888 === (8))){
var inst_68879 = (state_68887[(2)]);
var inst_68880 = fluree.db.graphdb.forward_time_travel_db_QMARK_.call(null,inst_68879);
var inst_68881 = cljs.core.clj__GT_js.call(null,inst_68880);
var inst_68882 = resolve.call(null,inst_68881);
var _ = (function (){var statearr_68901 = state_68887;
(statearr_68901[(4)] = cljs.core.rest.call(null,(state_68887[(4)])));

return statearr_68901;
})();
var state_68887__$1 = state_68887;
var statearr_68902_68916 = state_68887__$1;
(statearr_68902_68916[(2)] = inst_68882);

(statearr_68902_68916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$isForwardTimeTravelDb_$_state_machine__2741__auto__ = null;
var flureenjs$isForwardTimeTravelDb_$_state_machine__2741__auto____0 = (function (){
var statearr_68903 = [null,null,null,null,null,null,null,null];
(statearr_68903[(0)] = flureenjs$isForwardTimeTravelDb_$_state_machine__2741__auto__);

(statearr_68903[(1)] = (1));

return statearr_68903;
});
var flureenjs$isForwardTimeTravelDb_$_state_machine__2741__auto____1 = (function (state_68887){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68887);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68904){var ex__2744__auto__ = e68904;
var statearr_68905_68917 = state_68887;
(statearr_68905_68917[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68887[(4)]))){
var statearr_68906_68918 = state_68887;
(statearr_68906_68918[(1)] = cljs.core.first.call(null,(state_68887[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68919 = state_68887;
state_68887 = G__68919;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$isForwardTimeTravelDb_$_state_machine__2741__auto__ = function(state_68887){
switch(arguments.length){
case 0:
return flureenjs$isForwardTimeTravelDb_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$isForwardTimeTravelDb_$_state_machine__2741__auto____1.call(this,state_68887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$isForwardTimeTravelDb_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$isForwardTimeTravelDb_$_state_machine__2741__auto____0;
flureenjs$isForwardTimeTravelDb_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$isForwardTimeTravelDb_$_state_machine__2741__auto____1;
return flureenjs$isForwardTimeTravelDb_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68907 = f__2764__auto__.call(null);
(statearr_68907[(6)] = c__2763__auto__);

return statearr_68907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.isForwardTimeTravelDb', flureenjs.isForwardTimeTravelDb);
/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *    Returns a promise that will eventually contain a response or an exception
 *    if the timeout period has expired.
 * 
 *    Response may contain an exception, if the tx resulted in an exception.
 */
flureenjs.monitorTx = (function flureenjs$monitorTx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_68939){
var state_val_68940 = (state_68939[(1)]);
if((state_val_68940 === (1))){
var state_68939__$1 = state_68939;
var statearr_68941_68957 = state_68939__$1;
(statearr_68941_68957[(2)] = null);

(statearr_68941_68957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68940 === (2))){
var _ = (function (){var statearr_68942 = state_68939;
(statearr_68942[(4)] = cljs.core.cons.call(null,(5),(state_68939[(4)])));

return statearr_68942;
})();
var inst_68929 = fluree.db.connection_js.check_connection.call(null,conn);
var inst_68930 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,txid,timeout_ms);
var state_68939__$1 = (function (){var statearr_68943 = state_68939;
(statearr_68943[(7)] = inst_68929);

return statearr_68943;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68939__$1,(6),inst_68930);
} else {
if((state_val_68940 === (3))){
var inst_68937 = (state_68939[(2)]);
var state_68939__$1 = state_68939;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68939__$1,inst_68937);
} else {
if((state_val_68940 === (4))){
var inst_68920 = (state_68939[(2)]);
var inst_68921 = fluree.db.util.log.error.call(null,inst_68920);
var inst_68922 = cljs.core.clj__GT_js.call(null,inst_68920);
var inst_68923 = reject.call(null,inst_68922);
var state_68939__$1 = (function (){var statearr_68945 = state_68939;
(statearr_68945[(8)] = inst_68921);

return statearr_68945;
})();
var statearr_68946_68958 = state_68939__$1;
(statearr_68946_68958[(2)] = inst_68923);

(statearr_68946_68958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68940 === (5))){
var _ = (function (){var statearr_68947 = state_68939;
(statearr_68947[(4)] = cljs.core.rest.call(null,(state_68939[(4)])));

return statearr_68947;
})();
var state_68939__$1 = state_68939;
var ex68944 = (state_68939__$1[(2)]);
var statearr_68948_68959 = state_68939__$1;
(statearr_68948_68959[(5)] = ex68944);


var statearr_68949_68960 = state_68939__$1;
(statearr_68949_68960[(1)] = (4));

(statearr_68949_68960[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68940 === (6))){
var inst_68932 = (state_68939[(2)]);
var inst_68933 = cljs.core.clj__GT_js.call(null,inst_68932);
var inst_68934 = resolve.call(null,inst_68933);
var _ = (function (){var statearr_68950 = state_68939;
(statearr_68950[(4)] = cljs.core.rest.call(null,(state_68939[(4)])));

return statearr_68950;
})();
var state_68939__$1 = state_68939;
var statearr_68951_68961 = state_68939__$1;
(statearr_68951_68961[(2)] = inst_68934);

(statearr_68951_68961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$monitorTx_$_state_machine__2741__auto__ = null;
var flureenjs$monitorTx_$_state_machine__2741__auto____0 = (function (){
var statearr_68952 = [null,null,null,null,null,null,null,null,null];
(statearr_68952[(0)] = flureenjs$monitorTx_$_state_machine__2741__auto__);

(statearr_68952[(1)] = (1));

return statearr_68952;
});
var flureenjs$monitorTx_$_state_machine__2741__auto____1 = (function (state_68939){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_68939);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e68953){var ex__2744__auto__ = e68953;
var statearr_68954_68962 = state_68939;
(statearr_68954_68962[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_68939[(4)]))){
var statearr_68955_68963 = state_68939;
(statearr_68955_68963[(1)] = cljs.core.first.call(null,(state_68939[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68964 = state_68939;
state_68939 = G__68964;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$monitorTx_$_state_machine__2741__auto__ = function(state_68939){
switch(arguments.length){
case 0:
return flureenjs$monitorTx_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$monitorTx_$_state_machine__2741__auto____1.call(this,state_68939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$monitorTx_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$monitorTx_$_state_machine__2741__auto____0;
flureenjs$monitorTx_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$monitorTx_$_state_machine__2741__auto____1;
return flureenjs$monitorTx_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_68956 = f__2764__auto__.call(null);
(statearr_68956[(6)] = c__2763__auto__);

return statearr_68956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.monitorTx', flureenjs.monitorTx);
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *    producing a signed command.
 * 
 *    Optional opts is a map with the following keys. If not provided,
 *    defaults will be attempted.
 *    - auth        - The auth id for the auth record being used. The private key must
 *                    correspond to this auth record, or an authority of this auth record.
 *    - expire      - When this transaction should expire if not yet attempted.
 *                    Defaults to 5 minutes.
 *    - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                    By default epoch milliseconds is used.
 *    - deps        - Not yet implemented, list of dependent transactions.
 * 
 *    If successful, will return a map with four keys:
 *      - cmd  - a map with the command/transaction data as a JSON string
 *      - sig  - the signature of the above stringified map
 *      - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *      - db   - the ledger for this transaction
 */
flureenjs.txToCommand = (function flureenjs$txToCommand(var_args){
var G__68966 = arguments.length;
switch (G__68966) {
case 3:
return flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return flureenjs.txToCommand.call(null,ledger,txn,private_key,null);
}));

(flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_69075){
var state_val_69076 = (state_69075[(1)]);
if((state_val_69076 === (7))){
var state_69075__$1 = state_69075;
var statearr_69077_69144 = state_69075__$1;
(statearr_69077_69144[(2)] = ledger);

(statearr_69077_69144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (20))){
var inst_68992 = (state_69075[(7)]);
var inst_69032 = (state_69075[(2)]);
var inst_69033 = cljs.core.nth.call(null,inst_69032,(0),null);
var inst_69034 = cljs.core.nth.call(null,inst_69032,(1),null);
var inst_69035 = fluree.db.util.core.current_time_millis.call(null);
var state_69075__$1 = (function (){var statearr_69078 = state_69075;
(statearr_69078[(8)] = inst_69034);

(statearr_69078[(9)] = inst_69035);

(statearr_69078[(10)] = inst_69033);

return statearr_69078;
})();
if(cljs.core.truth_(inst_68992)){
var statearr_69079_69145 = state_69075__$1;
(statearr_69079_69145[(1)] = (27));

} else {
var statearr_69080_69146 = state_69075__$1;
(statearr_69080_69146[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (27))){
var inst_68992 = (state_69075[(7)]);
var state_69075__$1 = state_69075;
var statearr_69081_69147 = state_69075__$1;
(statearr_69081_69147[(2)] = inst_68992);

(statearr_69081_69147[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (1))){
var state_69075__$1 = state_69075;
var statearr_69082_69148 = state_69075__$1;
(statearr_69082_69148[(2)] = null);

(statearr_69082_69148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (24))){
var inst_69006 = (state_69075[(11)]);
var inst_69023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69024 = [inst_69006,null];
var inst_69025 = (new cljs.core.PersistentVector(null,2,(5),inst_69023,inst_69024,null));
var state_69075__$1 = state_69075;
var statearr_69083_69149 = state_69075__$1;
(statearr_69083_69149[(2)] = inst_69025);

(statearr_69083_69149[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (4))){
var inst_68967 = (state_69075[(2)]);
var inst_68968 = fluree.db.util.log.error.call(null,inst_68967);
var inst_68969 = cljs.core.clj__GT_js.call(null,inst_68967);
var inst_68970 = reject.call(null,inst_68969);
var state_69075__$1 = (function (){var statearr_69084 = state_69075;
(statearr_69084[(12)] = inst_68968);

return statearr_69084;
})();
var statearr_69085_69150 = state_69075__$1;
(statearr_69085_69150[(2)] = inst_68970);

(statearr_69085_69150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (15))){
var inst_68990 = (state_69075[(13)]);
var inst_69006 = (state_69075[(11)]);
var inst_69008 = cljs.core.not_EQ_.call(null,inst_68990,inst_69006);
var state_69075__$1 = state_69075;
var statearr_69086_69151 = state_69075__$1;
(statearr_69086_69151[(2)] = inst_69008);

(statearr_69086_69151[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (21))){
var inst_68990 = (state_69075[(13)]);
var inst_69018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69019 = [inst_68990,null];
var inst_69020 = (new cljs.core.PersistentVector(null,2,(5),inst_69018,inst_69019,null));
var state_69075__$1 = state_69075;
var statearr_69087_69152 = state_69075__$1;
(statearr_69087_69152[(2)] = inst_69020);

(statearr_69087_69152[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (31))){
var inst_69035 = (state_69075[(9)]);
var inst_69042 = (inst_69035 + (30000));
var state_69075__$1 = state_69075;
var statearr_69088_69153 = state_69075__$1;
(statearr_69088_69153[(2)] = inst_69042);

(statearr_69088_69153[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (32))){
var inst_69044 = (state_69075[(2)]);
var state_69075__$1 = (function (){var statearr_69089 = state_69075;
(statearr_69089[(14)] = inst_69044);

return statearr_69089;
})();
var statearr_69090_69154 = state_69075__$1;
(statearr_69090_69154[(2)] = null);

(statearr_69090_69154[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (33))){
var inst_69034 = (state_69075[(8)]);
var inst_68987 = (state_69075[(15)]);
var inst_69044 = (state_69075[(14)]);
var inst_69033 = (state_69075[(10)]);
var inst_68993 = (state_69075[(16)]);
var inst_69039 = (state_69075[(17)]);
var _ = (function (){var statearr_69091 = state_69075;
(statearr_69091[(4)] = cljs.core.cons.call(null,(36),(state_69075[(4)])));

return statearr_69091;
})();
var inst_69057 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"authority","authority",-551669367),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"deps","deps",1883360319)];
var inst_69058 = [new cljs.core.Keyword(null,"tx","tx",466630418),inst_68987,txn,inst_69039,inst_69033,inst_69034,inst_69044,inst_68993];
var inst_69059 = cljs.core.PersistentHashMap.fromArrays(inst_69057,inst_69058);
var inst_69060 = fluree.db.util.core.without_nils.call(null,inst_69059);
var inst_69061 = fluree.db.util.json.stringify.call(null,inst_69060);
var ___$1 = (function (){var statearr_69092 = state_69075;
(statearr_69092[(4)] = cljs.core.rest.call(null,(state_69075[(4)])));

return statearr_69092;
})();
var state_69075__$1 = state_69075;
var statearr_69093_69155 = state_69075__$1;
(statearr_69093_69155[(2)] = inst_69061);

(statearr_69093_69155[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (13))){
var inst_68998 = ["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('');
var inst_68999 = (new Error(inst_68998));
var inst_69000 = (function(){throw inst_68999})();
var state_69075__$1 = state_69075;
var statearr_69095_69156 = state_69075__$1;
(statearr_69095_69156[(2)] = inst_69000);

(statearr_69095_69156[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (22))){
var state_69075__$1 = state_69075;
var statearr_69096_69157 = state_69075__$1;
(statearr_69096_69157[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (36))){
var _ = (function (){var statearr_69098 = state_69075;
(statearr_69098[(4)] = cljs.core.rest.call(null,(state_69075[(4)])));

return statearr_69098;
})();
var state_69075__$1 = state_69075;
var ex69094 = (state_69075__$1[(2)]);
var statearr_69099_69158 = state_69075__$1;
(statearr_69099_69158[(5)] = ex69094);


var statearr_69100_69159 = state_69075__$1;
(statearr_69100_69159[(1)] = (35));

(statearr_69100_69159[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (29))){
var inst_68991 = (state_69075[(18)]);
var inst_69039 = (state_69075[(2)]);
var state_69075__$1 = (function (){var statearr_69101 = state_69075;
(statearr_69101[(17)] = inst_69039);

return statearr_69101;
})();
if(cljs.core.truth_(inst_68991)){
var statearr_69102_69160 = state_69075__$1;
(statearr_69102_69160[(1)] = (30));

} else {
var statearr_69103_69161 = state_69075__$1;
(statearr_69103_69161[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (6))){
var inst_68982 = cljs.core.first.call(null,ledger);
var inst_68983 = cljs.core.second.call(null,ledger);
var inst_68984 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68982),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68983)].join('');
var state_69075__$1 = state_69075;
var statearr_69104_69162 = state_69075__$1;
(statearr_69104_69162[(2)] = inst_68984);

(statearr_69104_69162[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (28))){
var inst_69035 = (state_69075[(9)]);
var state_69075__$1 = state_69075;
var statearr_69105_69163 = state_69075__$1;
(statearr_69105_69163[(2)] = inst_69035);

(statearr_69105_69163[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (25))){
var state_69075__$1 = state_69075;
var statearr_69106_69164 = state_69075__$1;
(statearr_69106_69164[(2)] = null);

(statearr_69106_69164[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (34))){
var inst_69064 = (state_69075[(2)]);
var inst_69065 = fluree.crypto.sign_message.call(null,inst_69064,private_key);
var inst_69066 = fluree.crypto.sha3_256.call(null,inst_69064);
var inst_69067 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"db","db",993250759)];
var inst_69068 = [inst_69064,inst_69065,inst_69066,ledger];
var inst_69069 = cljs.core.PersistentHashMap.fromArrays(inst_69067,inst_69068);
var inst_69070 = resolve.call(null,inst_69069);
var _ = (function (){var statearr_69107 = state_69075;
(statearr_69107[(4)] = cljs.core.rest.call(null,(state_69075[(4)])));

return statearr_69107;
})();
var state_69075__$1 = state_69075;
var statearr_69108_69165 = state_69075__$1;
(statearr_69108_69165[(2)] = inst_69070);

(statearr_69108_69165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (17))){
var inst_69011 = (state_69075[(2)]);
var state_69075__$1 = state_69075;
if(cljs.core.truth_(inst_69011)){
var statearr_69109_69166 = state_69075__$1;
(statearr_69109_69166[(1)] = (18));

} else {
var statearr_69110_69167 = state_69075__$1;
(statearr_69110_69167[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (3))){
var inst_69073 = (state_69075[(2)]);
var state_69075__$1 = state_69075;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69075__$1,inst_69073);
} else {
if((state_val_69076 === (12))){
var state_69075__$1 = state_69075;
var statearr_69111_69168 = state_69075__$1;
(statearr_69111_69168[(2)] = null);

(statearr_69111_69168[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (2))){
var _ = (function (){var statearr_69112 = state_69075;
(statearr_69112[(4)] = cljs.core.cons.call(null,(5),(state_69075[(4)])));

return statearr_69112;
})();
var inst_68980 = cljs.core.sequential_QMARK_.call(null,ledger);
var state_69075__$1 = state_69075;
if(inst_68980){
var statearr_69113_69169 = state_69075__$1;
(statearr_69113_69169[(1)] = (6));

} else {
var statearr_69114_69170 = state_69075__$1;
(statearr_69114_69170[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (23))){
var inst_69030 = (state_69075[(2)]);
var state_69075__$1 = state_69075;
var statearr_69115_69171 = state_69075__$1;
(statearr_69115_69171[(2)] = inst_69030);

(statearr_69115_69171[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (35))){
var inst_69045 = (state_69075[(2)]);
var inst_69046 = fluree.db.util.log.error.call(null,inst_69045);
var inst_69047 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69048 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_69049 = cljs.core.PersistentHashMap.fromArrays(inst_69047,inst_69048);
var inst_69050 = cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",inst_69049);
var inst_69051 = (function(){throw inst_69050})();
var state_69075__$1 = (function (){var statearr_69116 = state_69075;
(statearr_69116[(19)] = inst_69046);

return statearr_69116;
})();
var statearr_69117_69172 = state_69075__$1;
(statearr_69117_69172[(2)] = inst_69051);

(statearr_69117_69172[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (19))){
var inst_68990 = (state_69075[(13)]);
var state_69075__$1 = state_69075;
if(cljs.core.truth_(inst_68990)){
var statearr_69118_69173 = state_69075__$1;
(statearr_69118_69173[(1)] = (21));

} else {
var statearr_69119_69174 = state_69075__$1;
(statearr_69119_69174[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (11))){
var inst_68990 = (state_69075[(13)]);
var inst_69005 = (state_69075[(2)]);
var inst_69006 = fluree.crypto.account_id_from_private.call(null,private_key);
var state_69075__$1 = (function (){var statearr_69121 = state_69075;
(statearr_69121[(20)] = inst_69005);

(statearr_69121[(11)] = inst_69006);

return statearr_69121;
})();
if(cljs.core.truth_(inst_68990)){
var statearr_69122_69175 = state_69075__$1;
(statearr_69122_69175[(1)] = (15));

} else {
var statearr_69123_69176 = state_69075__$1;
(statearr_69123_69176[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (9))){
var inst_68993 = (state_69075[(16)]);
var inst_68995 = cljs.core.sequential_QMARK_.call(null,inst_68993);
var state_69075__$1 = state_69075;
if(inst_68995){
var statearr_69124_69177 = state_69075__$1;
(statearr_69124_69177[(1)] = (12));

} else {
var statearr_69125_69178 = state_69075__$1;
(statearr_69125_69178[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (5))){
var _ = (function (){var statearr_69126 = state_69075;
(statearr_69126[(4)] = cljs.core.rest.call(null,(state_69075[(4)])));

return statearr_69126;
})();
var state_69075__$1 = state_69075;
var ex69120 = (state_69075__$1[(2)]);
var statearr_69127_69179 = state_69075__$1;
(statearr_69127_69179[(5)] = ex69120);


var statearr_69128_69180 = state_69075__$1;
(statearr_69128_69180[(1)] = (4));

(statearr_69128_69180[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (14))){
var inst_69002 = (state_69075[(2)]);
var state_69075__$1 = state_69075;
var statearr_69129_69181 = state_69075__$1;
(statearr_69129_69181[(2)] = inst_69002);

(statearr_69129_69181[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (26))){
var inst_69028 = (state_69075[(2)]);
var state_69075__$1 = state_69075;
var statearr_69130_69182 = state_69075__$1;
(statearr_69130_69182[(2)] = inst_69028);

(statearr_69130_69182[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (16))){
var inst_68990 = (state_69075[(13)]);
var state_69075__$1 = state_69075;
var statearr_69131_69183 = state_69075__$1;
(statearr_69131_69183[(2)] = inst_68990);

(statearr_69131_69183[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (30))){
var inst_68991 = (state_69075[(18)]);
var state_69075__$1 = state_69075;
var statearr_69132_69184 = state_69075__$1;
(statearr_69132_69184[(2)] = inst_68991);

(statearr_69132_69184[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (10))){
var state_69075__$1 = state_69075;
var statearr_69133_69185 = state_69075__$1;
(statearr_69133_69185[(2)] = null);

(statearr_69133_69185[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (18))){
var inst_68990 = (state_69075[(13)]);
var inst_69006 = (state_69075[(11)]);
var inst_69013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69014 = [inst_68990,inst_69006];
var inst_69015 = (new cljs.core.PersistentVector(null,2,(5),inst_69013,inst_69014,null));
var state_69075__$1 = state_69075;
var statearr_69134_69186 = state_69075__$1;
(statearr_69134_69186[(2)] = inst_69015);

(statearr_69134_69186[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (8))){
var inst_68993 = (state_69075[(16)]);
var inst_68987 = (state_69075[(2)]);
var inst_68988 = opts;
var inst_68989 = cljs.core.__destructure_map.call(null,inst_68988);
var inst_68990 = cljs.core.get.call(null,inst_68989,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_68991 = cljs.core.get.call(null,inst_68989,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_68992 = cljs.core.get.call(null,inst_68989,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_68993__$1 = cljs.core.get.call(null,inst_68989,new cljs.core.Keyword(null,"deps","deps",1883360319));
var state_69075__$1 = (function (){var statearr_69135 = state_69075;
(statearr_69135[(15)] = inst_68987);

(statearr_69135[(13)] = inst_68990);

(statearr_69135[(18)] = inst_68991);

(statearr_69135[(7)] = inst_68992);

(statearr_69135[(16)] = inst_68993__$1);

return statearr_69135;
})();
if(cljs.core.truth_(inst_68993__$1)){
var statearr_69136_69187 = state_69075__$1;
(statearr_69136_69187[(1)] = (9));

} else {
var statearr_69137_69188 = state_69075__$1;
(statearr_69137_69188[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_69138 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69138[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_69138[(1)] = (1));

return statearr_69138;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_69075){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_69075);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e69139){var ex__2744__auto__ = e69139;
var statearr_69140_69189 = state_69075;
(statearr_69140_69189[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_69075[(4)]))){
var statearr_69141_69190 = state_69075;
(statearr_69141_69190[(1)] = cljs.core.first.call(null,(state_69075[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69191 = state_69075;
state_69075 = G__69191;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_69075){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_69075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_69142 = f__2764__auto__.call(null);
(statearr_69142[(6)] = c__2763__auto__);

return statearr_69142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.txToCommand.cljs$lang$maxFixedArity = 4);

/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 *     that will eventually have the result of the tx, the txid (if :txid-only option used), or
 *     an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 *     Will locally sign a final transaction command if a private key is provided via :private-key
 *     in the options, otherwise will submit the transaction to the connected ledger and request signature,
 *     provided the ledger group has a default private key available for signing.
 * 
 *     Options (opts) is a map with the following possible keys:
 *     - private-key - The private key to use for signing. If not present, a default
 *                     private key will attempt to be used from the connection, if available.
 *     - auth        - The auth id for the auth record being used. The private key must
 *                     correspond to this auth record, or an authority of this auth record.
 *     - expire      - When this transaction should expire if not yet attempted.
 *                     Defaults to 5 minutes.
 *     - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                     By default epoch milliseconds is used.
 *     - deps        - List of one or more txids that must be successfully processed before
 *                     this tx is processed. If any fail, this tx will fail. (not yet implemented)
 *     - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                     but instead return with the txid once it is successfully persisted by the
 *                     transactors. The txid can be used to look up/monitor the response at a later time.
 *     - timeout     - will respond with an exception if timeout reached before response available.
 */
flureenjs.transact = (function flureenjs$transact(var_args){
var G__69193 = arguments.length;
switch (G__69193) {
case 3:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.transact', flureenjs.transact);

(flureenjs.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureenjs.transact.call(null,conn,ledger,txn,null);
}));

(flureenjs.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_69219){
var state_val_69220 = (state_69219[(1)]);
if((state_val_69220 === (7))){
var inst_69205 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_69219__$1 = state_69219;
var statearr_69221_69242 = state_69219__$1;
(statearr_69221_69242[(2)] = inst_69205);

(statearr_69221_69242[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (1))){
var state_69219__$1 = state_69219;
var statearr_69222_69243 = state_69219__$1;
(statearr_69222_69243[(2)] = null);

(statearr_69222_69243[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (4))){
var inst_69194 = (state_69219[(2)]);
var inst_69195 = fluree.db.util.log.error.call(null,inst_69194);
var inst_69196 = reject.call(null,inst_69194);
var state_69219__$1 = (function (){var statearr_69223 = state_69219;
(statearr_69223[(7)] = inst_69195);

return statearr_69223;
})();
var statearr_69224_69244 = state_69219__$1;
(statearr_69224_69244[(2)] = inst_69196);

(statearr_69224_69244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (6))){
var state_69219__$1 = state_69219;
var statearr_69225_69245 = state_69219__$1;
(statearr_69225_69245[(2)] = null);

(statearr_69225_69245[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (3))){
var inst_69217 = (state_69219[(2)]);
var state_69219__$1 = state_69219;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69219__$1,inst_69217);
} else {
if((state_val_69220 === (2))){
var _ = (function (){var statearr_69227 = state_69219;
(statearr_69227[(4)] = cljs.core.cons.call(null,(5),(state_69219[(4)])));

return statearr_69227;
})();
var inst_69202 = (opts == null);
var state_69219__$1 = state_69219;
if(cljs.core.truth_(inst_69202)){
var statearr_69228_69246 = state_69219__$1;
(statearr_69228_69246[(1)] = (6));

} else {
var statearr_69229_69247 = state_69219__$1;
(statearr_69229_69247[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (9))){
var inst_69212 = (state_69219[(2)]);
var inst_69213 = cljs.core.clj__GT_js.call(null,inst_69212);
var inst_69214 = resolve.call(null,inst_69213);
var _ = (function (){var statearr_69230 = state_69219;
(statearr_69230[(4)] = cljs.core.rest.call(null,(state_69219[(4)])));

return statearr_69230;
})();
var state_69219__$1 = state_69219;
var statearr_69231_69248 = state_69219__$1;
(statearr_69231_69248[(2)] = inst_69214);

(statearr_69231_69248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (5))){
var _ = (function (){var statearr_69232 = state_69219;
(statearr_69232[(4)] = cljs.core.rest.call(null,(state_69219[(4)])));

return statearr_69232;
})();
var state_69219__$1 = state_69219;
var ex69226 = (state_69219__$1[(2)]);
var statearr_69233_69249 = state_69219__$1;
(statearr_69233_69249[(5)] = ex69226);


var statearr_69234_69250 = state_69219__$1;
(statearr_69234_69250[(1)] = (4));

(statearr_69234_69250[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (8))){
var inst_69207 = (state_69219[(2)]);
var inst_69208 = fluree.db.connection_js.check_connection.call(null,conn,inst_69207);
var inst_69209 = cljs.core.js__GT_clj.call(null,txn,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69210 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_69209,inst_69207);
var state_69219__$1 = (function (){var statearr_69235 = state_69219;
(statearr_69235[(8)] = inst_69208);

return statearr_69235;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69219__$1,(9),inst_69210);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_69236 = [null,null,null,null,null,null,null,null,null];
(statearr_69236[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_69236[(1)] = (1));

return statearr_69236;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_69219){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_69219);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e69237){var ex__2744__auto__ = e69237;
var statearr_69238_69251 = state_69219;
(statearr_69238_69251[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_69219[(4)]))){
var statearr_69239_69252 = state_69219;
(statearr_69239_69252[(1)] = cljs.core.first.call(null,(state_69219[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69253 = state_69219;
state_69219 = G__69253;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_69219){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_69219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_69240 = f__2764__auto__.call(null);
(statearr_69240[(6)] = c__2763__auto__);

return statearr_69240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 *     start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 *     containing keys :block :tx
 */
flureenjs.blockRangeWithTxn = (function flureenjs$blockRangeWithTxn(var_args){
var G__69255 = arguments.length;
switch (G__69255) {
case 3:
return flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockRangeWithTxn', flureenjs.blockRangeWithTxn);

(flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureenjs.blockRangeWithTxn.call(null,conn,ledger,block_map,null);
}));

(flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_69284){
var state_val_69285 = (state_69284[(1)]);
if((state_val_69285 === (1))){
var state_69284__$1 = state_69284;
var statearr_69286_69303 = state_69284__$1;
(statearr_69286_69303[(2)] = null);

(statearr_69286_69303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69285 === (2))){
var inst_69265 = (state_69284[(7)]);
var _ = (function (){var statearr_69287 = state_69284;
(statearr_69287[(4)] = cljs.core.cons.call(null,(5),(state_69284[(4)])));

return statearr_69287;
})();
var inst_69265__$1 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69266 = cljs.core.js__GT_clj.call(null,block_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69267 = cljs.core.__destructure_map.call(null,inst_69266);
var inst_69268 = cljs.core.get.call(null,inst_69267,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_69269 = cljs.core.get.call(null,inst_69267,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_69270 = flureenjs._db_instance.call(null,conn,ledger,inst_69265__$1);
var state_69284__$1 = (function (){var statearr_69288 = state_69284;
(statearr_69288[(8)] = inst_69268);

(statearr_69288[(7)] = inst_69265__$1);

(statearr_69288[(9)] = inst_69269);

return statearr_69288;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69284__$1,(6),inst_69270);
} else {
if((state_val_69285 === (3))){
var inst_69282 = (state_69284[(2)]);
var state_69284__$1 = state_69284;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69284__$1,inst_69282);
} else {
if((state_val_69285 === (4))){
var inst_69256 = (state_69284[(2)]);
var inst_69257 = fluree.db.util.log.error.call(null,inst_69256);
var inst_69258 = reject.call(null,inst_69256);
var state_69284__$1 = (function (){var statearr_69290 = state_69284;
(statearr_69290[(10)] = inst_69257);

return statearr_69290;
})();
var statearr_69291_69304 = state_69284__$1;
(statearr_69291_69304[(2)] = inst_69258);

(statearr_69291_69304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69285 === (5))){
var _ = (function (){var statearr_69292 = state_69284;
(statearr_69292[(4)] = cljs.core.rest.call(null,(state_69284[(4)])));

return statearr_69292;
})();
var state_69284__$1 = state_69284;
var ex69289 = (state_69284__$1[(2)]);
var statearr_69293_69305 = state_69284__$1;
(statearr_69293_69305[(5)] = ex69289);


var statearr_69294_69306 = state_69284__$1;
(statearr_69294_69306[(1)] = (4));

(statearr_69294_69306[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69285 === (6))){
var inst_69268 = (state_69284[(8)]);
var inst_69265 = (state_69284[(7)]);
var inst_69269 = (state_69284[(9)]);
var inst_69272 = (state_69284[(2)]);
var inst_69273 = fluree.db.query.block.block_range.call(null,inst_69272,inst_69268,inst_69269,inst_69265);
var state_69284__$1 = state_69284;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69284__$1,(7),inst_69273);
} else {
if((state_val_69285 === (7))){
var inst_69275 = (state_69284[(2)]);
var inst_69276 = fluree.db.util.async.throw_err.call(null,inst_69275);
var inst_69277 = fluree.db.query.range.block_with_tx_data.call(null,inst_69276);
var inst_69278 = cljs.core.clj__GT_js.call(null,inst_69277);
var inst_69279 = resolve.call(null,inst_69278);
var _ = (function (){var statearr_69295 = state_69284;
(statearr_69295[(4)] = cljs.core.rest.call(null,(state_69284[(4)])));

return statearr_69295;
})();
var state_69284__$1 = state_69284;
var statearr_69296_69307 = state_69284__$1;
(statearr_69296_69307[(2)] = inst_69279);

(statearr_69296_69307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_69297 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_69297[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_69297[(1)] = (1));

return statearr_69297;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_69284){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_69284);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e69298){var ex__2744__auto__ = e69298;
var statearr_69299_69308 = state_69284;
(statearr_69299_69308[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_69284[(4)]))){
var statearr_69300_69309 = state_69284;
(statearr_69300_69309[(1)] = cljs.core.first.call(null,(state_69284[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69310 = state_69284;
state_69284 = G__69310;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_69284){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_69284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_69301 = f__2764__auto__.call(null);
(statearr_69301[(6)] = c__2763__auto__);

return statearr_69301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.blockRangeWithTxn.cljs$lang$maxFixedArity = 4);

flureenjs.blockQuery = (function flureenjs$blockQuery(var_args){
var G__69312 = arguments.length;
switch (G__69312) {
case 3:
return flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockQuery', flureenjs.blockQuery);

(flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureenjs.blockQuery.call(null,conn,ledger,query_map,null);
}));

(flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_69370){
var state_val_69371 = (state_69370[(1)]);
if((state_val_69371 === (7))){
var state_69370__$1 = state_69370;
var statearr_69372_69413 = state_69370__$1;
(statearr_69372_69413[(2)] = null);

(statearr_69372_69413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (20))){
var inst_69349 = (state_69370[(2)]);
var state_69370__$1 = state_69370;
var statearr_69373_69414 = state_69370__$1;
(statearr_69373_69414[(2)] = inst_69349);

(statearr_69373_69414[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (1))){
var state_69370__$1 = state_69370;
var statearr_69374_69415 = state_69370__$1;
(statearr_69374_69415[(2)] = null);

(statearr_69374_69415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (4))){
var inst_69313 = (state_69370[(2)]);
var inst_69314 = fluree.db.util.log.error.call(null,inst_69313);
var inst_69315 = reject.call(null,inst_69313);
var state_69370__$1 = (function (){var statearr_69375 = state_69370;
(statearr_69375[(7)] = inst_69314);

return statearr_69375;
})();
var statearr_69376_69416 = state_69370__$1;
(statearr_69376_69416[(2)] = inst_69315);

(statearr_69376_69416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (15))){
var state_69370__$1 = state_69370;
var statearr_69377_69417 = state_69370__$1;
(statearr_69377_69417[(2)] = null);

(statearr_69377_69417[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (21))){
var inst_69362 = (state_69370[(2)]);
var inst_69363 = fluree.db.util.async.throw_err.call(null,inst_69362);
var inst_69364 = cljs.core.clj__GT_js.call(null,inst_69363);
var inst_69365 = resolve.call(null,inst_69364);
var _ = (function (){var statearr_69378 = state_69370;
(statearr_69378[(4)] = cljs.core.rest.call(null,(state_69370[(4)])));

return statearr_69378;
})();
var state_69370__$1 = state_69370;
var statearr_69379_69418 = state_69370__$1;
(statearr_69379_69418[(2)] = inst_69365);

(statearr_69379_69418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (13))){
var inst_69337 = (state_69370[(8)]);
var inst_69328 = (state_69370[(9)]);
var inst_69337__$1 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_69328);
var inst_69338 = (inst_69337__$1 == null);
var state_69370__$1 = (function (){var statearr_69380 = state_69370;
(statearr_69380[(8)] = inst_69337__$1);

return statearr_69380;
})();
if(cljs.core.truth_(inst_69338)){
var statearr_69381_69419 = state_69370__$1;
(statearr_69381_69419[(1)] = (15));

} else {
var statearr_69382_69420 = state_69370__$1;
(statearr_69382_69420[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (6))){
var inst_69324 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_69370__$1 = state_69370;
var statearr_69383_69421 = state_69370__$1;
(statearr_69383_69421[(2)] = inst_69324);

(statearr_69383_69421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (17))){
var inst_69343 = (state_69370[(10)]);
var inst_69343__$1 = (state_69370[(2)]);
var inst_69344 = (inst_69343__$1 == null);
var state_69370__$1 = (function (){var statearr_69384 = state_69370;
(statearr_69384[(10)] = inst_69343__$1);

return statearr_69384;
})();
if(cljs.core.truth_(inst_69344)){
var statearr_69385_69422 = state_69370__$1;
(statearr_69385_69422[(1)] = (18));

} else {
var statearr_69386_69423 = state_69370__$1;
(statearr_69386_69423[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (3))){
var inst_69368 = (state_69370[(2)]);
var state_69370__$1 = state_69370;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69370__$1,inst_69368);
} else {
if((state_val_69371 === (12))){
var inst_69333 = (state_69370[(11)]);
var state_69370__$1 = state_69370;
var statearr_69387_69424 = state_69370__$1;
(statearr_69387_69424[(2)] = inst_69333);

(statearr_69387_69424[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (2))){
var inst_69321 = (state_69370[(12)]);
var _ = (function (){var statearr_69388 = state_69370;
(statearr_69388[(4)] = cljs.core.cons.call(null,(5),(state_69370[(4)])));

return statearr_69388;
})();
var inst_69321__$1 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69322 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_69321__$1);
var state_69370__$1 = (function (){var statearr_69389 = state_69370;
(statearr_69389[(13)] = inst_69322);

(statearr_69389[(12)] = inst_69321__$1);

return statearr_69389;
})();
if(cljs.core.truth_(opts)){
var statearr_69390_69425 = state_69370__$1;
(statearr_69390_69425[(1)] = (6));

} else {
var statearr_69391_69426 = state_69370__$1;
(statearr_69391_69426[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (19))){
var inst_69343 = (state_69370[(10)]);
var inst_69347 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_69343);
var state_69370__$1 = state_69370;
var statearr_69392_69427 = state_69370__$1;
(statearr_69392_69427[(2)] = inst_69347);

(statearr_69392_69427[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (11))){
var inst_69321 = (state_69370[(12)]);
var inst_69328 = (state_69370[(9)]);
var inst_69353 = (state_69370[(2)]);
var inst_69354 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_69355 = [inst_69353];
var inst_69356 = cljs.core.PersistentHashMap.fromArrays(inst_69354,inst_69355);
var inst_69357 = fluree.db.util.core.without_nils.call(null,inst_69356);
var inst_69358 = cljs.core.merge.call(null,inst_69328,inst_69357);
var inst_69359 = cljs.core.update.call(null,inst_69321,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_69358);
var inst_69360 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_69359);
var state_69370__$1 = state_69370;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69370__$1,(21),inst_69360);
} else {
if((state_val_69371 === (9))){
var inst_69330 = (state_69370[(14)]);
var state_69370__$1 = state_69370;
var statearr_69394_69428 = state_69370__$1;
(statearr_69394_69428[(2)] = inst_69330);

(statearr_69394_69428[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (5))){
var _ = (function (){var statearr_69395 = state_69370;
(statearr_69395[(4)] = cljs.core.rest.call(null,(state_69370[(4)])));

return statearr_69395;
})();
var state_69370__$1 = state_69370;
var ex69393 = (state_69370__$1[(2)]);
var statearr_69396_69429 = state_69370__$1;
(statearr_69396_69429[(5)] = ex69393);


var statearr_69397_69430 = state_69370__$1;
(statearr_69397_69430[(1)] = (4));

(statearr_69397_69430[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (14))){
var inst_69351 = (state_69370[(2)]);
var state_69370__$1 = state_69370;
var statearr_69398_69431 = state_69370__$1;
(statearr_69398_69431[(2)] = inst_69351);

(statearr_69398_69431[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (16))){
var inst_69337 = (state_69370[(8)]);
var inst_69341 = fluree.db.connection_js.validate_token.call(null,conn,inst_69337);
var state_69370__$1 = state_69370;
var statearr_69399_69432 = state_69370__$1;
(statearr_69399_69432[(2)] = inst_69341);

(statearr_69399_69432[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (10))){
var inst_69333 = (state_69370[(11)]);
var inst_69328 = (state_69370[(9)]);
var inst_69333__$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_69328);
var state_69370__$1 = (function (){var statearr_69400 = state_69370;
(statearr_69400[(11)] = inst_69333__$1);

return statearr_69400;
})();
if(cljs.core.truth_(inst_69333__$1)){
var statearr_69401_69433 = state_69370__$1;
(statearr_69401_69433[(1)] = (12));

} else {
var statearr_69402_69434 = state_69370__$1;
(statearr_69402_69434[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (18))){
var state_69370__$1 = state_69370;
var statearr_69403_69435 = state_69370__$1;
(statearr_69403_69435[(2)] = null);

(statearr_69403_69435[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69371 === (8))){
var inst_69322 = (state_69370[(13)]);
var inst_69330 = (state_69370[(14)]);
var inst_69328 = (state_69370[(9)]);
var inst_69327 = (state_69370[(2)]);
var inst_69328__$1 = cljs.core.merge.call(null,inst_69322,inst_69327);
var inst_69329 = fluree.db.connection_js.check_connection.call(null,conn,inst_69328__$1);
var inst_69330__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_69328__$1);
var state_69370__$1 = (function (){var statearr_69404 = state_69370;
(statearr_69404[(15)] = inst_69329);

(statearr_69404[(14)] = inst_69330__$1);

(statearr_69404[(9)] = inst_69328__$1);

return statearr_69404;
})();
if(cljs.core.truth_(inst_69330__$1)){
var statearr_69405_69436 = state_69370__$1;
(statearr_69405_69436[(1)] = (9));

} else {
var statearr_69406_69437 = state_69370__$1;
(statearr_69406_69437[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_69407 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69407[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_69407[(1)] = (1));

return statearr_69407;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_69370){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_69370);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e69408){var ex__2744__auto__ = e69408;
var statearr_69409_69438 = state_69370;
(statearr_69409_69438[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_69370[(4)]))){
var statearr_69410_69439 = state_69370;
(statearr_69410_69439[(1)] = cljs.core.first.call(null,(state_69370[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69440 = state_69370;
state_69370 = G__69440;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_69370){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_69370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_69411 = f__2764__auto__.call(null);
(statearr_69411[(6)] = c__2763__auto__);

return statearr_69411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.blockQuery.cljs$lang$maxFixedArity = 4);

/**
 * Returns a promise containing blocks from start (inclusive)
 *     to end if provided (exclusive).
 * 
 *     Each block is a separate map, containing keys :block, :t and :flakes.
 */
flureenjs.blockRange = (function flureenjs$blockRange(var_args){
var G__69442 = arguments.length;
switch (G__69442) {
case 2:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockRange', flureenjs.blockRange);

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return flureenjs.blockRange.call(null,db,start,null,null);
}));

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return flureenjs.blockRange.call(null,db,start,end,null);
}));

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_69466){
var state_val_69467 = (state_69466[(1)]);
if((state_val_69467 === (1))){
var state_69466__$1 = state_69466;
var statearr_69468_69485 = state_69466__$1;
(statearr_69468_69485[(2)] = null);

(statearr_69468_69485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69467 === (2))){
var _ = (function (){var statearr_69469 = state_69466;
(statearr_69469[(4)] = cljs.core.cons.call(null,(5),(state_69466[(4)])));

return statearr_69469;
})();
var inst_69451 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_69466__$1 = (function (){var statearr_69470 = state_69466;
(statearr_69470[(7)] = inst_69451);

return statearr_69470;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69466__$1,(7),db);
} else {
if((state_val_69467 === (3))){
var inst_69464 = (state_69466[(2)]);
var state_69466__$1 = state_69466;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69466__$1,inst_69464);
} else {
if((state_val_69467 === (4))){
var inst_69443 = (state_69466[(2)]);
var inst_69444 = fluree.db.util.log.error.call(null,inst_69443);
var inst_69445 = reject.call(null,inst_69443);
var state_69466__$1 = (function (){var statearr_69472 = state_69466;
(statearr_69472[(8)] = inst_69444);

return statearr_69472;
})();
var statearr_69473_69486 = state_69466__$1;
(statearr_69473_69486[(2)] = inst_69445);

(statearr_69473_69486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69467 === (5))){
var _ = (function (){var statearr_69474 = state_69466;
(statearr_69474[(4)] = cljs.core.rest.call(null,(state_69466[(4)])));

return statearr_69474;
})();
var state_69466__$1 = state_69466;
var ex69471 = (state_69466__$1[(2)]);
var statearr_69475_69487 = state_69466__$1;
(statearr_69475_69487[(5)] = ex69471);


var statearr_69476_69488 = state_69466__$1;
(statearr_69476_69488[(1)] = (4));

(statearr_69476_69488[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69467 === (6))){
var inst_69457 = (state_69466[(2)]);
var inst_69458 = fluree.db.util.async.throw_err.call(null,inst_69457);
var inst_69459 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_69458);
var inst_69460 = cljs.core.clj__GT_js.call(null,inst_69459);
var inst_69461 = resolve.call(null,inst_69460);
var _ = (function (){var statearr_69477 = state_69466;
(statearr_69477[(4)] = cljs.core.rest.call(null,(state_69466[(4)])));

return statearr_69477;
})();
var state_69466__$1 = state_69466;
var statearr_69478_69489 = state_69466__$1;
(statearr_69478_69489[(2)] = inst_69461);

(statearr_69478_69489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69467 === (7))){
var inst_69451 = (state_69466[(7)]);
var inst_69453 = (state_69466[(2)]);
var inst_69454 = fluree.db.util.async.throw_err.call(null,inst_69453);
var inst_69455 = fluree.db.query.block.block_range.call(null,inst_69454,start,end,inst_69451);
var state_69466__$1 = state_69466;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69466__$1,(6),inst_69455);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_69479 = [null,null,null,null,null,null,null,null,null];
(statearr_69479[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_69479[(1)] = (1));

return statearr_69479;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_69466){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_69466);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e69480){var ex__2744__auto__ = e69480;
var statearr_69481_69490 = state_69466;
(statearr_69481_69490[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_69466[(4)]))){
var statearr_69482_69491 = state_69466;
(statearr_69482_69491[(1)] = cljs.core.first.call(null,(state_69466[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69492 = state_69466;
state_69466 = G__69492;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_69466){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_69466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_69483 = f__2764__auto__.call(null);
(statearr_69483[(6)] = c__2763__auto__);

return statearr_69483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.blockRange.cljs$lang$maxFixedArity = 4);

/**
 * Returns spot index range for only the requested collection.
 */
flureenjs.collectionFlakes = (function flureenjs$collectionFlakes(db,collection){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_69515){
var state_val_69516 = (state_69515[(1)]);
if((state_val_69516 === (1))){
var state_69515__$1 = state_69515;
var statearr_69517_69532 = state_69515__$1;
(statearr_69517_69532[(2)] = null);

(statearr_69517_69532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69516 === (2))){
var _ = (function (){var statearr_69518 = state_69515;
(statearr_69518[(4)] = cljs.core.cons.call(null,(5),(state_69515[(4)])));

return statearr_69518;
})();
var state_69515__$1 = state_69515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69515__$1,(7),db);
} else {
if((state_val_69516 === (3))){
var inst_69513 = (state_69515[(2)]);
var state_69515__$1 = state_69515;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69515__$1,inst_69513);
} else {
if((state_val_69516 === (4))){
var inst_69493 = (state_69515[(2)]);
var inst_69494 = fluree.db.util.log.error.call(null,inst_69493);
var inst_69495 = reject.call(null,inst_69493);
var state_69515__$1 = (function (){var statearr_69520 = state_69515;
(statearr_69520[(7)] = inst_69494);

return statearr_69520;
})();
var statearr_69521_69533 = state_69515__$1;
(statearr_69521_69533[(2)] = inst_69495);

(statearr_69521_69533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69516 === (5))){
var _ = (function (){var statearr_69522 = state_69515;
(statearr_69522[(4)] = cljs.core.rest.call(null,(state_69515[(4)])));

return statearr_69522;
})();
var state_69515__$1 = state_69515;
var ex69519 = (state_69515__$1[(2)]);
var statearr_69523_69534 = state_69515__$1;
(statearr_69523_69534[(5)] = ex69519);


var statearr_69524_69535 = state_69515__$1;
(statearr_69524_69535[(1)] = (4));

(statearr_69524_69535[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69516 === (6))){
var inst_69506 = (state_69515[(2)]);
var inst_69507 = fluree.db.util.async.throw_err.call(null,inst_69506);
var inst_69508 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_69507);
var inst_69509 = cljs.core.clj__GT_js.call(null,inst_69508);
var inst_69510 = resolve.call(null,inst_69509);
var _ = (function (){var statearr_69525 = state_69515;
(statearr_69525[(4)] = cljs.core.rest.call(null,(state_69515[(4)])));

return statearr_69525;
})();
var state_69515__$1 = state_69515;
var statearr_69526_69536 = state_69515__$1;
(statearr_69526_69536[(2)] = inst_69510);

(statearr_69526_69536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69516 === (7))){
var inst_69502 = (state_69515[(2)]);
var inst_69503 = fluree.db.util.async.throw_err.call(null,inst_69502);
var inst_69504 = fluree.db.query.range.collection.call(null,inst_69503,collection);
var state_69515__$1 = state_69515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69515__$1,(6),inst_69504);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$collectionFlakes_$_state_machine__2741__auto__ = null;
var flureenjs$collectionFlakes_$_state_machine__2741__auto____0 = (function (){
var statearr_69527 = [null,null,null,null,null,null,null,null];
(statearr_69527[(0)] = flureenjs$collectionFlakes_$_state_machine__2741__auto__);

(statearr_69527[(1)] = (1));

return statearr_69527;
});
var flureenjs$collectionFlakes_$_state_machine__2741__auto____1 = (function (state_69515){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_69515);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e69528){var ex__2744__auto__ = e69528;
var statearr_69529_69537 = state_69515;
(statearr_69529_69537[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_69515[(4)]))){
var statearr_69530_69538 = state_69515;
(statearr_69530_69538[(1)] = cljs.core.first.call(null,(state_69515[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69539 = state_69515;
state_69515 = G__69539;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$collectionFlakes_$_state_machine__2741__auto__ = function(state_69515){
switch(arguments.length){
case 0:
return flureenjs$collectionFlakes_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$collectionFlakes_$_state_machine__2741__auto____1.call(this,state_69515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collectionFlakes_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collectionFlakes_$_state_machine__2741__auto____0;
flureenjs$collectionFlakes_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collectionFlakes_$_state_machine__2741__auto____1;
return flureenjs$collectionFlakes_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_69531 = f__2764__auto__.call(null);
(statearr_69531[(6)] = c__2763__auto__);

return statearr_69531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.collectionFlakes', flureenjs.collectionFlakes);
/**
 * Execute a graphql query against the specified database.
 */
flureenjs.graphql = (function flureenjs$graphql(var_args){
var G__69541 = arguments.length;
switch (G__69541) {
case 3:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.graphql', flureenjs.graphql);

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,param){
return flureenjs.graphql.call(null,conn,ledger,param,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,param,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_69643){
var state_val_69644 = (state_69643[(1)]);
if((state_val_69644 === (7))){
var state_69643__$1 = state_69643;
var statearr_69645_69697 = state_69643__$1;
(statearr_69645_69697[(2)] = null);

(statearr_69645_69697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (20))){
var inst_69560 = (state_69643[(7)]);
var inst_69567 = (state_69643[(8)]);
var inst_69571 = (state_69643[(9)]);
var inst_69592 = cljs.core.dissoc.call(null,inst_69571,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_69593 = cljs.core.assoc.call(null,inst_69592,new cljs.core.Keyword(null,"opts","opts",155075701),inst_69560);
var inst_69594 = fluree.db.api.query.history_query_async.call(null,inst_69567,inst_69593);
var state_69643__$1 = state_69643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69643__$1,(23),inst_69594);
} else {
if((state_val_69644 === (27))){
var inst_69606 = (state_69643[(2)]);
var inst_69607 = fluree.db.util.async.throw_err.call(null,inst_69606);
var state_69643__$1 = state_69643;
var statearr_69646_69698 = state_69643__$1;
(statearr_69646_69698[(2)] = inst_69607);

(statearr_69646_69698[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (1))){
var state_69643__$1 = state_69643;
var statearr_69647_69699 = state_69643__$1;
(statearr_69647_69699[(2)] = null);

(statearr_69647_69699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (24))){
var inst_69560 = (state_69643[(7)]);
var inst_69571 = (state_69643[(9)]);
var inst_69602 = cljs.core.dissoc.call(null,inst_69571,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_69603 = cljs.core.assoc.call(null,inst_69602,new cljs.core.Keyword(null,"opts","opts",155075701),inst_69560);
var inst_69604 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_69603);
var state_69643__$1 = state_69643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69643__$1,(27),inst_69604);
} else {
if((state_val_69644 === (4))){
var inst_69542 = (state_69643[(2)]);
var inst_69543 = fluree.db.util.log.error.call(null,inst_69542);
var inst_69544 = cljs.core.clj__GT_js.call(null,inst_69542);
var inst_69545 = reject.call(null,inst_69544);
var state_69643__$1 = (function (){var statearr_69648 = state_69643;
(statearr_69648[(10)] = inst_69543);

return statearr_69648;
})();
var statearr_69649_69700 = state_69643__$1;
(statearr_69649_69700[(2)] = inst_69545);

(statearr_69649_69700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (15))){
var inst_69571 = (state_69643[(9)]);
var inst_69589 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_69571);
var inst_69590 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"history","history",-247395220),inst_69589);
var state_69643__$1 = state_69643;
if(inst_69590){
var statearr_69650_69701 = state_69643__$1;
(statearr_69650_69701[(1)] = (20));

} else {
var statearr_69651_69702 = state_69643__$1;
(statearr_69651_69702[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (21))){
var inst_69571 = (state_69643[(9)]);
var inst_69599 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_69571);
var inst_69600 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),inst_69599);
var state_69643__$1 = state_69643;
if(inst_69600){
var statearr_69652_69703 = state_69643__$1;
(statearr_69652_69703[(1)] = (24));

} else {
var statearr_69653_69704 = state_69643__$1;
(statearr_69653_69704[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (31))){
var inst_69614 = (state_69643[(2)]);
var inst_69615 = fluree.db.util.async.throw_err.call(null,inst_69614);
var state_69643__$1 = state_69643;
var statearr_69654_69705 = state_69643__$1;
(statearr_69654_69705[(2)] = inst_69615);

(statearr_69654_69705[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (32))){
var inst_69564 = (state_69643[(11)]);
var inst_69560 = (state_69643[(7)]);
var inst_69571 = (state_69643[(9)]);
var inst_69618 = cljs.core.dissoc.call(null,inst_69571,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_69619 = cljs.core.assoc.call(null,inst_69618,new cljs.core.Keyword(null,"opts","opts",155075701),inst_69560);
var inst_69620 = fluree.db.api.query.multi_query_async.call(null,inst_69564,inst_69619);
var state_69643__$1 = state_69643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69643__$1,(35),inst_69620);
} else {
if((state_val_69644 === (33))){
var state_69643__$1 = state_69643;
var statearr_69655_69706 = state_69643__$1;
(statearr_69655_69706[(2)] = null);

(statearr_69655_69706[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (13))){
var inst_69636 = (state_69643[(2)]);
var inst_69637 = cljs.core.clj__GT_js.call(null,inst_69636);
var inst_69638 = resolve.call(null,inst_69637);
var _ = (function (){var statearr_69656 = state_69643;
(statearr_69656[(4)] = cljs.core.rest.call(null,(state_69643[(4)])));

return statearr_69656;
})();
var state_69643__$1 = state_69643;
var statearr_69657_69707 = state_69643__$1;
(statearr_69657_69707[(2)] = inst_69638);

(statearr_69657_69707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (22))){
var inst_69632 = (state_69643[(2)]);
var state_69643__$1 = state_69643;
var statearr_69658_69708 = state_69643__$1;
(statearr_69658_69708[(2)] = inst_69632);

(statearr_69658_69708[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (29))){
var state_69643__$1 = state_69643;
var statearr_69659_69709 = state_69643__$1;
(statearr_69659_69709[(1)] = (32));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (6))){
var inst_69556 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_69643__$1 = state_69643;
var statearr_69661_69710 = state_69643__$1;
(statearr_69661_69710[(2)] = inst_69556);

(statearr_69661_69710[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (28))){
var inst_69560 = (state_69643[(7)]);
var inst_69571 = (state_69643[(9)]);
var inst_69611 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_69571);
var inst_69612 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_69611,inst_69560);
var state_69643__$1 = state_69643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69643__$1,(31),inst_69612);
} else {
if((state_val_69644 === (25))){
var inst_69571 = (state_69643[(9)]);
var inst_69609 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_69571);
var state_69643__$1 = state_69643;
if(cljs.core.truth_(inst_69609)){
var statearr_69662_69711 = state_69643__$1;
(statearr_69662_69711[(1)] = (28));

} else {
var statearr_69663_69712 = state_69643__$1;
(statearr_69663_69712[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (34))){
var inst_69626 = (state_69643[(2)]);
var state_69643__$1 = state_69643;
var statearr_69664_69713 = state_69643__$1;
(statearr_69664_69713[(2)] = inst_69626);

(statearr_69664_69713[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (17))){
var inst_69571 = (state_69643[(9)]);
var inst_69583 = cljs.core.dissoc.call(null,inst_69571,new cljs.core.Keyword(null,"type","type",1174270348));
var state_69643__$1 = state_69643;
var statearr_69665_69714 = state_69643__$1;
(statearr_69665_69714[(2)] = inst_69583);

(statearr_69665_69714[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (3))){
var inst_69641 = (state_69643[(2)]);
var state_69643__$1 = state_69643;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69643__$1,inst_69641);
} else {
if((state_val_69644 === (12))){
var inst_69571 = (state_69643[(9)]);
var inst_69575 = [new cljs.core.Keyword(null,"__schema","__schema",-305244223),null,new cljs.core.Keyword(null,"__type","__type",1665433236),null];
var inst_69576 = (new cljs.core.PersistentArrayMap(null,2,inst_69575,null));
var inst_69577 = (new cljs.core.PersistentHashSet(null,inst_69576,null));
var inst_69578 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_69571);
var inst_69579 = inst_69577.call(null,inst_69578);
var state_69643__$1 = state_69643;
if(cljs.core.truth_(inst_69579)){
var statearr_69666_69715 = state_69643__$1;
(statearr_69666_69715[(1)] = (14));

} else {
var statearr_69667_69716 = state_69643__$1;
(statearr_69667_69716[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (2))){
var inst_69553 = (state_69643[(12)]);
var _ = (function (){var statearr_69668 = state_69643;
(statearr_69668[(4)] = cljs.core.cons.call(null,(5),(state_69643[(4)])));

return statearr_69668;
})();
var inst_69552 = fluree.db.util.json.parse.call(null,param);
var inst_69553__$1 = cljs.core.js__GT_clj.call(null,inst_69552,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69554 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_69553__$1);
var state_69643__$1 = (function (){var statearr_69669 = state_69643;
(statearr_69669[(13)] = inst_69554);

(statearr_69669[(12)] = inst_69553__$1);

return statearr_69669;
})();
if(cljs.core.truth_(opts)){
var statearr_69670_69717 = state_69643__$1;
(statearr_69670_69717[(1)] = (6));

} else {
var statearr_69671_69718 = state_69643__$1;
(statearr_69671_69718[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (23))){
var inst_69596 = (state_69643[(2)]);
var inst_69597 = fluree.db.util.async.throw_err.call(null,inst_69596);
var state_69643__$1 = state_69643;
var statearr_69672_69719 = state_69643__$1;
(statearr_69672_69719[(2)] = inst_69597);

(statearr_69672_69719[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (35))){
var inst_69622 = (state_69643[(2)]);
var inst_69623 = fluree.db.util.async.throw_err.call(null,inst_69622);
var state_69643__$1 = state_69643;
var statearr_69673_69720 = state_69643__$1;
(statearr_69673_69720[(2)] = inst_69623);

(statearr_69673_69720[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (19))){
var inst_69587 = (state_69643[(2)]);
var state_69643__$1 = state_69643;
var statearr_69674_69721 = state_69643__$1;
(statearr_69674_69721[(2)] = inst_69587);

(statearr_69674_69721[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (11))){
var inst_69571 = (state_69643[(9)]);
var state_69643__$1 = state_69643;
var statearr_69676_69722 = state_69643__$1;
(statearr_69676_69722[(2)] = inst_69571);

(statearr_69676_69722[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (9))){
var inst_69560 = (state_69643[(7)]);
var inst_69567 = (state_69643[(8)]);
var inst_69562 = (state_69643[(14)]);
var inst_69563 = (state_69643[(15)]);
var inst_69566 = (state_69643[(2)]);
var inst_69567__$1 = fluree.db.util.async.throw_err.call(null,inst_69566);
var inst_69568 = fluree.db.query.graphql_parser.parse_graphql_to_flureeql.call(null,inst_69567__$1,inst_69562,inst_69563,inst_69560);
var state_69643__$1 = (function (){var statearr_69677 = state_69643;
(statearr_69677[(8)] = inst_69567__$1);

return statearr_69677;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69643__$1,(10),inst_69568);
} else {
if((state_val_69644 === (5))){
var _ = (function (){var statearr_69678 = state_69643;
(statearr_69678[(4)] = cljs.core.rest.call(null,(state_69643[(4)])));

return statearr_69678;
})();
var state_69643__$1 = state_69643;
var ex69675 = (state_69643__$1[(2)]);
var statearr_69679_69723 = state_69643__$1;
(statearr_69679_69723[(5)] = ex69675);


var statearr_69680_69724 = state_69643__$1;
(statearr_69680_69724[(1)] = (4));

(statearr_69680_69724[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (14))){
var inst_69560 = (state_69643[(7)]);
var inst_69581 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_69560);
var state_69643__$1 = state_69643;
if(cljs.core.truth_(inst_69581)){
var statearr_69681_69725 = state_69643__$1;
(statearr_69681_69725[(1)] = (17));

} else {
var statearr_69682_69726 = state_69643__$1;
(statearr_69682_69726[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (26))){
var inst_69630 = (state_69643[(2)]);
var state_69643__$1 = state_69643;
var statearr_69683_69727 = state_69643__$1;
(statearr_69683_69727[(2)] = inst_69630);

(statearr_69683_69727[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (16))){
var inst_69634 = (state_69643[(2)]);
var state_69643__$1 = state_69643;
var statearr_69684_69728 = state_69643__$1;
(statearr_69684_69728[(2)] = inst_69634);

(statearr_69684_69728[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (30))){
var inst_69628 = (state_69643[(2)]);
var state_69643__$1 = state_69643;
var statearr_69685_69729 = state_69643__$1;
(statearr_69685_69729[(2)] = inst_69628);

(statearr_69685_69729[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (10))){
var inst_69571 = (state_69643[(9)]);
var inst_69570 = (state_69643[(2)]);
var inst_69571__$1 = fluree.db.util.async.throw_err.call(null,inst_69570);
var inst_69572 = fluree.db.util.core.exception_QMARK_.call(null,inst_69571__$1);
var state_69643__$1 = (function (){var statearr_69686 = state_69643;
(statearr_69686[(9)] = inst_69571__$1);

return statearr_69686;
})();
if(inst_69572){
var statearr_69687_69730 = state_69643__$1;
(statearr_69687_69730[(1)] = (11));

} else {
var statearr_69688_69731 = state_69643__$1;
(statearr_69688_69731[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (18))){
var inst_69571 = (state_69643[(9)]);
var inst_69585 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_69571);
var state_69643__$1 = state_69643;
var statearr_69689_69732 = state_69643__$1;
(statearr_69689_69732[(2)] = inst_69585);

(statearr_69689_69732[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69644 === (8))){
var inst_69564 = (state_69643[(11)]);
var inst_69560 = (state_69643[(7)]);
var inst_69554 = (state_69643[(13)]);
var inst_69553 = (state_69643[(12)]);
var inst_69559 = (state_69643[(2)]);
var inst_69560__$1 = cljs.core.merge.call(null,inst_69554,inst_69559);
var inst_69561 = cljs.core.__destructure_map.call(null,inst_69553);
var inst_69562 = cljs.core.get.call(null,inst_69561,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_69563 = cljs.core.get.call(null,inst_69561,new cljs.core.Keyword(null,"variables","variables",1563680814));
var inst_69564__$1 = flureenjs._db_instance.call(null,conn,ledger,inst_69560__$1);
var state_69643__$1 = (function (){var statearr_69690 = state_69643;
(statearr_69690[(11)] = inst_69564__$1);

(statearr_69690[(7)] = inst_69560__$1);

(statearr_69690[(14)] = inst_69562);

(statearr_69690[(15)] = inst_69563);

return statearr_69690;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69643__$1,(9),inst_69564__$1);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_69691 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69691[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_69691[(1)] = (1));

return statearr_69691;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_69643){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_69643);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e69692){var ex__2744__auto__ = e69692;
var statearr_69693_69733 = state_69643;
(statearr_69693_69733[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_69643[(4)]))){
var statearr_69694_69734 = state_69643;
(statearr_69694_69734[(1)] = cljs.core.first.call(null,(state_69643[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69735 = state_69643;
state_69643 = G__69735;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_69643){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_69643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_69695 = f__2764__auto__.call(null);
(statearr_69695[(6)] = c__2763__auto__);

return statearr_69695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.graphql.cljs$lang$maxFixedArity = 4);

flureenjs.historyQuery = (function flureenjs$historyQuery(var_args){
var G__69737 = arguments.length;
switch (G__69737) {
case 2:
return flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.historyQuery', flureenjs.historyQuery);

(flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return flureenjs.historyQuery.call(null,sources,query_map,null);
}));

(flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_69764){
var state_val_69765 = (state_69764[(1)]);
if((state_val_69765 === (1))){
var state_69764__$1 = state_69764;
var statearr_69766_69782 = state_69764__$1;
(statearr_69766_69782[(2)] = null);

(statearr_69766_69782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69765 === (2))){
var _ = (function (){var statearr_69767 = state_69764;
(statearr_69767[(4)] = cljs.core.cons.call(null,(5),(state_69764[(4)])));

return statearr_69767;
})();
var inst_69746 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69747 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_69746);
var inst_69748 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69749 = cljs.core.merge.call(null,inst_69747,inst_69748);
var inst_69750 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_69751 = [inst_69749];
var inst_69752 = cljs.core.PersistentHashMap.fromArrays(inst_69750,inst_69751);
var inst_69753 = cljs.core.merge.call(null,inst_69746,inst_69752);
var inst_69754 = fluree.db.api.query.history_query_async.call(null,sources,inst_69753);
var state_69764__$1 = state_69764;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69764__$1,(6),inst_69754);
} else {
if((state_val_69765 === (3))){
var inst_69762 = (state_69764[(2)]);
var state_69764__$1 = state_69764;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69764__$1,inst_69762);
} else {
if((state_val_69765 === (4))){
var inst_69738 = (state_69764[(2)]);
var inst_69739 = fluree.db.util.log.error.call(null,inst_69738);
var inst_69740 = reject.call(null,inst_69738);
var state_69764__$1 = (function (){var statearr_69769 = state_69764;
(statearr_69769[(7)] = inst_69739);

return statearr_69769;
})();
var statearr_69770_69783 = state_69764__$1;
(statearr_69770_69783[(2)] = inst_69740);

(statearr_69770_69783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69765 === (5))){
var _ = (function (){var statearr_69771 = state_69764;
(statearr_69771[(4)] = cljs.core.rest.call(null,(state_69764[(4)])));

return statearr_69771;
})();
var state_69764__$1 = state_69764;
var ex69768 = (state_69764__$1[(2)]);
var statearr_69772_69784 = state_69764__$1;
(statearr_69772_69784[(5)] = ex69768);


var statearr_69773_69785 = state_69764__$1;
(statearr_69773_69785[(1)] = (4));

(statearr_69773_69785[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69765 === (6))){
var inst_69756 = (state_69764[(2)]);
var inst_69757 = fluree.db.util.async.throw_err.call(null,inst_69756);
var inst_69758 = cljs.core.clj__GT_js.call(null,inst_69757);
var inst_69759 = resolve.call(null,inst_69758);
var _ = (function (){var statearr_69774 = state_69764;
(statearr_69774[(4)] = cljs.core.rest.call(null,(state_69764[(4)])));

return statearr_69774;
})();
var state_69764__$1 = state_69764;
var statearr_69775_69786 = state_69764__$1;
(statearr_69775_69786[(2)] = inst_69759);

(statearr_69775_69786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_69776 = [null,null,null,null,null,null,null,null];
(statearr_69776[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_69776[(1)] = (1));

return statearr_69776;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_69764){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_69764);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e69777){var ex__2744__auto__ = e69777;
var statearr_69778_69787 = state_69764;
(statearr_69778_69787[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_69764[(4)]))){
var statearr_69779_69788 = state_69764;
(statearr_69779_69788[(1)] = cljs.core.first.call(null,(state_69764[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69789 = state_69764;
state_69764 = G__69789;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_69764){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_69764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_69780 = f__2764__auto__.call(null);
(statearr_69780[(6)] = c__2763__auto__);

return statearr_69780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.historyQuery.cljs$lang$maxFixedArity = 3);

flureenjs.multiQuery = (function flureenjs$multiQuery(var_args){
var G__69791 = arguments.length;
switch (G__69791) {
case 2:
return flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.multiQuery', flureenjs.multiQuery);

(flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$2 = (function (source,multi_query_map){
return flureenjs.multiQuery.call(null,source,multi_query_map,null);
}));

(flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$3 = (function (source,multi_query_map,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_69818){
var state_val_69819 = (state_69818[(1)]);
if((state_val_69819 === (1))){
var state_69818__$1 = state_69818;
var statearr_69820_69836 = state_69818__$1;
(statearr_69820_69836[(2)] = null);

(statearr_69820_69836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69819 === (2))){
var _ = (function (){var statearr_69821 = state_69818;
(statearr_69821[(4)] = cljs.core.cons.call(null,(5),(state_69818[(4)])));

return statearr_69821;
})();
var inst_69800 = cljs.core.js__GT_clj.call(null,multi_query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69801 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_69800);
var inst_69802 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69803 = cljs.core.merge.call(null,inst_69801,inst_69802);
var inst_69804 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_69805 = [inst_69803];
var inst_69806 = cljs.core.PersistentHashMap.fromArrays(inst_69804,inst_69805);
var inst_69807 = cljs.core.merge.call(null,inst_69800,inst_69806);
var inst_69808 = fluree.db.api.query.multi_query_async.call(null,source,inst_69807);
var state_69818__$1 = state_69818;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69818__$1,(6),inst_69808);
} else {
if((state_val_69819 === (3))){
var inst_69816 = (state_69818[(2)]);
var state_69818__$1 = state_69818;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69818__$1,inst_69816);
} else {
if((state_val_69819 === (4))){
var inst_69792 = (state_69818[(2)]);
var inst_69793 = fluree.db.util.log.error.call(null,inst_69792);
var inst_69794 = reject.call(null,inst_69792);
var state_69818__$1 = (function (){var statearr_69823 = state_69818;
(statearr_69823[(7)] = inst_69793);

return statearr_69823;
})();
var statearr_69824_69837 = state_69818__$1;
(statearr_69824_69837[(2)] = inst_69794);

(statearr_69824_69837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69819 === (5))){
var _ = (function (){var statearr_69825 = state_69818;
(statearr_69825[(4)] = cljs.core.rest.call(null,(state_69818[(4)])));

return statearr_69825;
})();
var state_69818__$1 = state_69818;
var ex69822 = (state_69818__$1[(2)]);
var statearr_69826_69838 = state_69818__$1;
(statearr_69826_69838[(5)] = ex69822);


var statearr_69827_69839 = state_69818__$1;
(statearr_69827_69839[(1)] = (4));

(statearr_69827_69839[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69819 === (6))){
var inst_69810 = (state_69818[(2)]);
var inst_69811 = fluree.db.util.async.throw_err.call(null,inst_69810);
var inst_69812 = cljs.core.clj__GT_js.call(null,inst_69811);
var inst_69813 = resolve.call(null,inst_69812);
var _ = (function (){var statearr_69828 = state_69818;
(statearr_69828[(4)] = cljs.core.rest.call(null,(state_69818[(4)])));

return statearr_69828;
})();
var state_69818__$1 = state_69818;
var statearr_69829_69840 = state_69818__$1;
(statearr_69829_69840[(2)] = inst_69813);

(statearr_69829_69840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_69830 = [null,null,null,null,null,null,null,null];
(statearr_69830[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_69830[(1)] = (1));

return statearr_69830;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_69818){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_69818);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e69831){var ex__2744__auto__ = e69831;
var statearr_69832_69841 = state_69818;
(statearr_69832_69841[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_69818[(4)]))){
var statearr_69833_69842 = state_69818;
(statearr_69833_69842[(1)] = cljs.core.first.call(null,(state_69818[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69843 = state_69818;
state_69818 = G__69843;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_69818){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_69818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_69834 = f__2764__auto__.call(null);
(statearr_69834[(6)] = c__2763__auto__);

return statearr_69834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.multiQuery.cljs$lang$maxFixedArity = 3);

/**
 * Execute a query against a database source, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise that eventually contains the results or
 *    an exception.
 */
flureenjs.query = (function flureenjs$query(source,query_map){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_69864){
var state_val_69865 = (state_69864[(1)]);
if((state_val_69865 === (1))){
var state_69864__$1 = state_69864;
var statearr_69866_69881 = state_69864__$1;
(statearr_69866_69881[(2)] = null);

(statearr_69866_69881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69865 === (2))){
var _ = (function (){var statearr_69867 = state_69864;
(statearr_69867[(4)] = cljs.core.cons.call(null,(5),(state_69864[(4)])));

return statearr_69867;
})();
var inst_69853 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69854 = fluree.db.api.query.query.call(null,source,inst_69853);
var state_69864__$1 = state_69864;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69864__$1,(6),inst_69854);
} else {
if((state_val_69865 === (3))){
var inst_69862 = (state_69864[(2)]);
var state_69864__$1 = state_69864;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69864__$1,inst_69862);
} else {
if((state_val_69865 === (4))){
var inst_69844 = (state_69864[(2)]);
var inst_69845 = fluree.db.util.log.error.call(null,inst_69844);
var inst_69846 = cljs.core.clj__GT_js.call(null,inst_69844);
var inst_69847 = reject.call(null,inst_69846);
var state_69864__$1 = (function (){var statearr_69869 = state_69864;
(statearr_69869[(7)] = inst_69845);

return statearr_69869;
})();
var statearr_69870_69882 = state_69864__$1;
(statearr_69870_69882[(2)] = inst_69847);

(statearr_69870_69882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69865 === (5))){
var _ = (function (){var statearr_69871 = state_69864;
(statearr_69871[(4)] = cljs.core.rest.call(null,(state_69864[(4)])));

return statearr_69871;
})();
var state_69864__$1 = state_69864;
var ex69868 = (state_69864__$1[(2)]);
var statearr_69872_69883 = state_69864__$1;
(statearr_69872_69883[(5)] = ex69868);


var statearr_69873_69884 = state_69864__$1;
(statearr_69873_69884[(1)] = (4));

(statearr_69873_69884[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69865 === (6))){
var inst_69856 = (state_69864[(2)]);
var inst_69857 = fluree.db.util.async.throw_err.call(null,inst_69856);
var inst_69858 = cljs.core.clj__GT_js.call(null,inst_69857);
var inst_69859 = resolve.call(null,inst_69858);
var _ = (function (){var statearr_69874 = state_69864;
(statearr_69874[(4)] = cljs.core.rest.call(null,(state_69864[(4)])));

return statearr_69874;
})();
var state_69864__$1 = state_69864;
var statearr_69875_69885 = state_69864__$1;
(statearr_69875_69885[(2)] = inst_69859);

(statearr_69875_69885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$query_$_state_machine__2741__auto__ = null;
var flureenjs$query_$_state_machine__2741__auto____0 = (function (){
var statearr_69876 = [null,null,null,null,null,null,null,null];
(statearr_69876[(0)] = flureenjs$query_$_state_machine__2741__auto__);

(statearr_69876[(1)] = (1));

return statearr_69876;
});
var flureenjs$query_$_state_machine__2741__auto____1 = (function (state_69864){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_69864);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e69877){var ex__2744__auto__ = e69877;
var statearr_69878_69886 = state_69864;
(statearr_69878_69886[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_69864[(4)]))){
var statearr_69879_69887 = state_69864;
(statearr_69879_69887[(1)] = cljs.core.first.call(null,(state_69864[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69888 = state_69864;
state_69864 = G__69888;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$query_$_state_machine__2741__auto__ = function(state_69864){
switch(arguments.length){
case 0:
return flureenjs$query_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$query_$_state_machine__2741__auto____1.call(this,state_69864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$query_$_state_machine__2741__auto____0;
flureenjs$query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$query_$_state_machine__2741__auto____1;
return flureenjs$query_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_69880 = f__2764__auto__.call(null);
(statearr_69880[(6)] = c__2763__auto__);

return statearr_69880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.query', flureenjs.query);
/**
 * Execute a query against a database source, with the
 *    given flakes applied.
 * 
 *    Returns promise that eventually contains the results or
 *    an exception.
 */
flureenjs.queryWith = (function flureenjs$queryWith(db,param){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_69918){
var state_val_69919 = (state_69918[(1)]);
if((state_val_69919 === (1))){
var state_69918__$1 = state_69918;
var statearr_69920_69936 = state_69918__$1;
(statearr_69920_69936[(2)] = null);

(statearr_69920_69936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69919 === (2))){
var _ = (function (){var statearr_69921 = state_69918;
(statearr_69921[(4)] = cljs.core.cons.call(null,(5),(state_69918[(4)])));

return statearr_69921;
})();
var inst_69899 = cljs.core.js__GT_clj.call(null,param,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69900 = cljs.core.__destructure_map.call(null,inst_69899);
var inst_69901 = cljs.core.get.call(null,inst_69900,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_69902 = cljs.core.get.call(null,inst_69900,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_69903 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_69902);
var state_69918__$1 = (function (){var statearr_69922 = state_69918;
(statearr_69922[(7)] = inst_69903);

(statearr_69922[(8)] = inst_69901);

return statearr_69922;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69918__$1,(6),db);
} else {
if((state_val_69919 === (3))){
var inst_69916 = (state_69918[(2)]);
var state_69918__$1 = state_69918;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69918__$1,inst_69916);
} else {
if((state_val_69919 === (4))){
var inst_69889 = (state_69918[(2)]);
var inst_69890 = fluree.db.util.log.error.call(null,inst_69889);
var inst_69891 = cljs.core.clj__GT_js.call(null,inst_69889);
var inst_69892 = reject.call(null,inst_69891);
var state_69918__$1 = (function (){var statearr_69924 = state_69918;
(statearr_69924[(9)] = inst_69890);

return statearr_69924;
})();
var statearr_69925_69937 = state_69918__$1;
(statearr_69925_69937[(2)] = inst_69892);

(statearr_69925_69937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69919 === (5))){
var _ = (function (){var statearr_69926 = state_69918;
(statearr_69926[(4)] = cljs.core.rest.call(null,(state_69918[(4)])));

return statearr_69926;
})();
var state_69918__$1 = state_69918;
var ex69923 = (state_69918__$1[(2)]);
var statearr_69927_69938 = state_69918__$1;
(statearr_69927_69938[(5)] = ex69923);


var statearr_69928_69939 = state_69918__$1;
(statearr_69928_69939[(1)] = (4));

(statearr_69928_69939[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69919 === (6))){
var inst_69903 = (state_69918[(7)]);
var inst_69901 = (state_69918[(8)]);
var inst_69905 = (state_69918[(2)]);
var inst_69906 = fluree.db.util.async.throw_err.call(null,inst_69905);
var inst_69907 = fluree.db.dbproto._forward_time_travel.call(null,inst_69906,inst_69903);
var inst_69908 = fluree.db.api.query.query.call(null,inst_69907,inst_69901);
var state_69918__$1 = state_69918;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69918__$1,(7),inst_69908);
} else {
if((state_val_69919 === (7))){
var inst_69910 = (state_69918[(2)]);
var inst_69911 = fluree.db.util.async.throw_err.call(null,inst_69910);
var inst_69912 = cljs.core.clj__GT_js.call(null,inst_69911);
var inst_69913 = resolve.call(null,inst_69912);
var _ = (function (){var statearr_69929 = state_69918;
(statearr_69929[(4)] = cljs.core.rest.call(null,(state_69918[(4)])));

return statearr_69929;
})();
var state_69918__$1 = state_69918;
var statearr_69930_69940 = state_69918__$1;
(statearr_69930_69940[(2)] = inst_69913);

(statearr_69930_69940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$queryWith_$_state_machine__2741__auto__ = null;
var flureenjs$queryWith_$_state_machine__2741__auto____0 = (function (){
var statearr_69931 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69931[(0)] = flureenjs$queryWith_$_state_machine__2741__auto__);

(statearr_69931[(1)] = (1));

return statearr_69931;
});
var flureenjs$queryWith_$_state_machine__2741__auto____1 = (function (state_69918){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_69918);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e69932){var ex__2744__auto__ = e69932;
var statearr_69933_69941 = state_69918;
(statearr_69933_69941[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_69918[(4)]))){
var statearr_69934_69942 = state_69918;
(statearr_69934_69942[(1)] = cljs.core.first.call(null,(state_69918[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69943 = state_69918;
state_69918 = G__69943;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$queryWith_$_state_machine__2741__auto__ = function(state_69918){
switch(arguments.length){
case 0:
return flureenjs$queryWith_$_state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$queryWith_$_state_machine__2741__auto____1.call(this,state_69918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$queryWith_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$queryWith_$_state_machine__2741__auto____0;
flureenjs$queryWith_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$queryWith_$_state_machine__2741__auto____1;
return flureenjs$queryWith_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_69935 = f__2764__auto__.call(null);
(statearr_69935[(6)] = c__2763__auto__);

return statearr_69935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureenjs.queryWith', flureenjs.queryWith);
/**
 * Exceute a sparql query against a specified database
 */
flureenjs.sparql = (function flureenjs$sparql(var_args){
var G__69945 = arguments.length;
switch (G__69945) {
case 2:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sparql', flureenjs.sparql);

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$2 = (function (db,sparql_str){
return flureenjs.sparql.call(null,db,sparql_str,null);
}));

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$3 = (function (db,sparql_str,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_69975){
var state_val_69976 = (state_69975[(1)]);
if((state_val_69976 === (7))){
var state_69975__$1 = state_69975;
var statearr_69977_69998 = state_69975__$1;
(statearr_69977_69998[(2)] = null);

(statearr_69977_69998[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69976 === (1))){
var state_69975__$1 = state_69975;
var statearr_69978_69999 = state_69975__$1;
(statearr_69978_69999[(2)] = null);

(statearr_69978_69999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69976 === (4))){
var inst_69946 = (state_69975[(2)]);
var inst_69947 = fluree.db.util.log.error.call(null,inst_69946);
var inst_69948 = cljs.core.clj__GT_js.call(null,inst_69946);
var inst_69949 = reject.call(null,inst_69948);
var state_69975__$1 = (function (){var statearr_69979 = state_69975;
(statearr_69979[(7)] = inst_69947);

return statearr_69979;
})();
var statearr_69980_70000 = state_69975__$1;
(statearr_69980_70000[(2)] = inst_69949);

(statearr_69980_70000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69976 === (6))){
var inst_69959 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_69975__$1 = state_69975;
var statearr_69981_70001 = state_69975__$1;
(statearr_69981_70001[(2)] = inst_69959);

(statearr_69981_70001[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69976 === (3))){
var inst_69973 = (state_69975[(2)]);
var state_69975__$1 = state_69975;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69975__$1,inst_69973);
} else {
if((state_val_69976 === (2))){
var inst_69956 = (state_69975[(8)]);
var _ = (function (){var statearr_69983 = state_69975;
(statearr_69983[(4)] = cljs.core.cons.call(null,(5),(state_69975[(4)])));

return statearr_69983;
})();
var inst_69955 = fluree.db.util.json.parse.call(null,sparql_str);
var inst_69956__$1 = fluree.db.query.sparql_parser.sparql_to_ad_hoc.call(null,inst_69955);
var inst_69957 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_69956__$1);
var state_69975__$1 = (function (){var statearr_69984 = state_69975;
(statearr_69984[(8)] = inst_69956__$1);

(statearr_69984[(9)] = inst_69957);

return statearr_69984;
})();
if(cljs.core.truth_(opts)){
var statearr_69985_70002 = state_69975__$1;
(statearr_69985_70002[(1)] = (6));

} else {
var statearr_69986_70003 = state_69975__$1;
(statearr_69986_70003[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69976 === (9))){
var inst_69967 = (state_69975[(2)]);
var inst_69968 = fluree.db.util.async.throw_err.call(null,inst_69967);
var inst_69969 = cljs.core.clj__GT_js.call(null,inst_69968);
var inst_69970 = resolve.call(null,inst_69969);
var _ = (function (){var statearr_69987 = state_69975;
(statearr_69987[(4)] = cljs.core.rest.call(null,(state_69975[(4)])));

return statearr_69987;
})();
var state_69975__$1 = state_69975;
var statearr_69988_70004 = state_69975__$1;
(statearr_69988_70004[(2)] = inst_69970);

(statearr_69988_70004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69976 === (5))){
var _ = (function (){var statearr_69989 = state_69975;
(statearr_69989[(4)] = cljs.core.rest.call(null,(state_69975[(4)])));

return statearr_69989;
})();
var state_69975__$1 = state_69975;
var ex69982 = (state_69975__$1[(2)]);
var statearr_69990_70005 = state_69975__$1;
(statearr_69990_70005[(5)] = ex69982);


var statearr_69991_70006 = state_69975__$1;
(statearr_69991_70006[(1)] = (4));

(statearr_69991_70006[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69976 === (8))){
var inst_69956 = (state_69975[(8)]);
var inst_69957 = (state_69975[(9)]);
var inst_69962 = (state_69975[(2)]);
var inst_69963 = cljs.core.merge.call(null,inst_69957,inst_69962);
var inst_69964 = cljs.core.assoc.call(null,inst_69956,new cljs.core.Keyword(null,"opts","opts",155075701),inst_69963);
var inst_69965 = fluree.db.api.query.query_async.call(null,db,inst_69964);
var state_69975__$1 = state_69975;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69975__$1,(9),inst_69965);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_69992 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69992[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_69992[(1)] = (1));

return statearr_69992;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_69975){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_69975);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e69993){var ex__2744__auto__ = e69993;
var statearr_69994_70007 = state_69975;
(statearr_69994_70007[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_69975[(4)]))){
var statearr_69995_70008 = state_69975;
(statearr_69995_70008[(1)] = cljs.core.first.call(null,(state_69975[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70009 = state_69975;
state_69975 = G__70009;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_69975){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_69975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_69996 = f__2764__auto__.call(null);
(statearr_69996[(6)] = c__2763__auto__);

return statearr_69996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.sparql.cljs$lang$maxFixedArity = 3);

/**
 * Exceute a sql query against a specified database
 */
flureenjs.sql = (function flureenjs$sql(var_args){
var G__70011 = arguments.length;
switch (G__70011) {
case 2:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sql', flureenjs.sql);

(flureenjs.sql.cljs$core$IFn$_invoke$arity$2 = (function (db,sql_str){
return flureenjs.sql.call(null,db,sql_str,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.sql.cljs$core$IFn$_invoke$arity$3 = (function (db,sql_str,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_70035){
var state_val_70036 = (state_70035[(1)]);
if((state_val_70036 === (1))){
var state_70035__$1 = state_70035;
var statearr_70037_70053 = state_70035__$1;
(statearr_70037_70053[(2)] = null);

(statearr_70037_70053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (2))){
var _ = (function (){var statearr_70038 = state_70035;
(statearr_70038[(4)] = cljs.core.cons.call(null,(5),(state_70035[(4)])));

return statearr_70038;
})();
var inst_70021 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70022 = fluree.db.util.json.parse.call(null,sql_str);
var inst_70023 = fluree.db.query.sql.parse.call(null,inst_70022);
var inst_70024 = cljs.core.update.call(null,inst_70023,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_70021);
var inst_70025 = fluree.db.api.query.query_async.call(null,db,inst_70024);
var state_70035__$1 = state_70035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70035__$1,(6),inst_70025);
} else {
if((state_val_70036 === (3))){
var inst_70033 = (state_70035[(2)]);
var state_70035__$1 = state_70035;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70035__$1,inst_70033);
} else {
if((state_val_70036 === (4))){
var inst_70012 = (state_70035[(2)]);
var inst_70013 = fluree.db.util.log.error.call(null,inst_70012);
var inst_70014 = cljs.core.clj__GT_js.call(null,inst_70012);
var inst_70015 = reject.call(null,inst_70014);
var state_70035__$1 = (function (){var statearr_70040 = state_70035;
(statearr_70040[(7)] = inst_70013);

return statearr_70040;
})();
var statearr_70041_70054 = state_70035__$1;
(statearr_70041_70054[(2)] = inst_70015);

(statearr_70041_70054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (5))){
var _ = (function (){var statearr_70042 = state_70035;
(statearr_70042[(4)] = cljs.core.rest.call(null,(state_70035[(4)])));

return statearr_70042;
})();
var state_70035__$1 = state_70035;
var ex70039 = (state_70035__$1[(2)]);
var statearr_70043_70055 = state_70035__$1;
(statearr_70043_70055[(5)] = ex70039);


var statearr_70044_70056 = state_70035__$1;
(statearr_70044_70056[(1)] = (4));

(statearr_70044_70056[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (6))){
var inst_70027 = (state_70035[(2)]);
var inst_70028 = fluree.db.util.async.throw_err.call(null,inst_70027);
var inst_70029 = cljs.core.clj__GT_js.call(null,inst_70028);
var inst_70030 = resolve.call(null,inst_70029);
var _ = (function (){var statearr_70045 = state_70035;
(statearr_70045[(4)] = cljs.core.rest.call(null,(state_70035[(4)])));

return statearr_70045;
})();
var state_70035__$1 = state_70035;
var statearr_70046_70057 = state_70035__$1;
(statearr_70046_70057[(2)] = inst_70030);

(statearr_70046_70057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2741__auto__ = null;
var flureenjs$state_machine__2741__auto____0 = (function (){
var statearr_70047 = [null,null,null,null,null,null,null,null];
(statearr_70047[(0)] = flureenjs$state_machine__2741__auto__);

(statearr_70047[(1)] = (1));

return statearr_70047;
});
var flureenjs$state_machine__2741__auto____1 = (function (state_70035){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_70035);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e70048){var ex__2744__auto__ = e70048;
var statearr_70049_70058 = state_70035;
(statearr_70049_70058[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_70035[(4)]))){
var statearr_70050_70059 = state_70035;
(statearr_70050_70059[(1)] = cljs.core.first.call(null,(state_70035[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70060 = state_70035;
state_70035 = G__70060;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureenjs$state_machine__2741__auto__ = function(state_70035){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2741__auto____0.call(this);
case 1:
return flureenjs$state_machine__2741__auto____1.call(this,state_70035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2741__auto____0;
flureenjs$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2741__auto____1;
return flureenjs$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_70051 = f__2764__auto__.call(null);
(statearr_70051[(6)] = c__2763__auto__);

return statearr_70051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureenjs.sql.cljs$lang$maxFixedArity = 3);

