// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.call(null,index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.get.call(null,text,counter))){
var G__77447 = (line + (1));
var G__77448 = (1);
var G__77449 = (counter + (1));
line = G__77447;
col = G__77448;
counter = G__77449;
continue;
} else {
var G__77450 = line;
var G__77451 = (col + (1));
var G__77452 = (counter + (1));
line = G__77450;
col = G__77451;
counter = G__77452;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq.call(null,clojure.string.replace.call(null,text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_.call(null,chars)){
return "";
} else {
if(cljs.core._EQ_.call(null,n__$1,(1))){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.take_while.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.first.call(null,chars))){
var G__77453 = cljs.core.next.call(null,chars);
var G__77454 = (n__$1 - (1));
chars = G__77453;
n__$1 = G__77454;
continue;
} else {
var G__77455 = cljs.core.next.call(null,chars);
var G__77456 = n__$1;
chars = G__77455;
n__$1 = G__77456;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_.call(null,n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.call(null,cljs.core.str,cljs.core.concat.call(null,cljs.core.repeat.call(null,(n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column.call(null,new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.call(null,failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line.call(null,new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.call(null,"NOT ");

return cljs.core.print.call(null,new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.call(null,instaparse.print.char_range__GT_str.call(null,r));
} else {
if((r instanceof RegExp)){
return cljs.core.print.call(null,instaparse.print.regexp__GT_str.call(null,r));
} else {
return cljs.core.pr.call(null,r);

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__77457){
var map__77458 = p__77457;
var map__77458__$1 = cljs.core.__destructure_map.call(null,map__77458);
var line = cljs.core.get.call(null,map__77458__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__77458__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.call(null,map__77458__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.call(null,map__77458__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.call(null,["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join(''));

cljs.core.println.call(null,text);

cljs.core.println.call(null,instaparse.failure.marker.call(null,column));

var full_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,cljs.core.complement.call(null,new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count.call(null,full_reasons) + cljs.core.count.call(null,partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.call(null,(1),total)){
cljs.core.println.call(null,"Expected:");
} else {
cljs.core.println.call(null,"Expected one of:");

}
}

var seq__77459_77467 = cljs.core.seq.call(null,full_reasons);
var chunk__77460_77468 = null;
var count__77461_77469 = (0);
var i__77462_77470 = (0);
while(true){
if((i__77462_77470 < count__77461_77469)){
var r_77471 = cljs.core._nth.call(null,chunk__77460_77468,i__77462_77470);
instaparse.failure.print_reason.call(null,r_77471);

cljs.core.println.call(null," (followed by end-of-string)");


var G__77472 = seq__77459_77467;
var G__77473 = chunk__77460_77468;
var G__77474 = count__77461_77469;
var G__77475 = (i__77462_77470 + (1));
seq__77459_77467 = G__77472;
chunk__77460_77468 = G__77473;
count__77461_77469 = G__77474;
i__77462_77470 = G__77475;
continue;
} else {
var temp__5753__auto___77476 = cljs.core.seq.call(null,seq__77459_77467);
if(temp__5753__auto___77476){
var seq__77459_77477__$1 = temp__5753__auto___77476;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__77459_77477__$1)){
var c__4679__auto___77478 = cljs.core.chunk_first.call(null,seq__77459_77477__$1);
var G__77479 = cljs.core.chunk_rest.call(null,seq__77459_77477__$1);
var G__77480 = c__4679__auto___77478;
var G__77481 = cljs.core.count.call(null,c__4679__auto___77478);
var G__77482 = (0);
seq__77459_77467 = G__77479;
chunk__77460_77468 = G__77480;
count__77461_77469 = G__77481;
i__77462_77470 = G__77482;
continue;
} else {
var r_77483 = cljs.core.first.call(null,seq__77459_77477__$1);
instaparse.failure.print_reason.call(null,r_77483);

cljs.core.println.call(null," (followed by end-of-string)");


var G__77484 = cljs.core.next.call(null,seq__77459_77477__$1);
var G__77485 = null;
var G__77486 = (0);
var G__77487 = (0);
seq__77459_77467 = G__77484;
chunk__77460_77468 = G__77485;
count__77461_77469 = G__77486;
i__77462_77470 = G__77487;
continue;
}
} else {
}
}
break;
}

var seq__77463 = cljs.core.seq.call(null,partial_reasons);
var chunk__77464 = null;
var count__77465 = (0);
var i__77466 = (0);
while(true){
if((i__77466 < count__77465)){
var r = cljs.core._nth.call(null,chunk__77464,i__77466);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__77488 = seq__77463;
var G__77489 = chunk__77464;
var G__77490 = count__77465;
var G__77491 = (i__77466 + (1));
seq__77463 = G__77488;
chunk__77464 = G__77489;
count__77465 = G__77490;
i__77466 = G__77491;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__77463);
if(temp__5753__auto__){
var seq__77463__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__77463__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__77463__$1);
var G__77492 = cljs.core.chunk_rest.call(null,seq__77463__$1);
var G__77493 = c__4679__auto__;
var G__77494 = cljs.core.count.call(null,c__4679__auto__);
var G__77495 = (0);
seq__77463 = G__77492;
chunk__77464 = G__77493;
count__77465 = G__77494;
i__77466 = G__77495;
continue;
} else {
var r = cljs.core.first.call(null,seq__77463__$1);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__77496 = cljs.core.next.call(null,seq__77463__$1);
var G__77497 = null;
var G__77498 = (0);
var G__77499 = (0);
seq__77463 = G__77496;
chunk__77464 = G__77497;
count__77465 = G__77498;
i__77466 = G__77499;
continue;
}
} else {
return null;
}
}
break;
}
});
