// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
goog.require('goog.object');
goog.scope(function(){
cljs.source_map.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__5735){
var vec__5736 = p__5735;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5736,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5736,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__5739 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5739,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5739,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5739,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5739,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5739,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (cljs.source_map.goog$module$goog$object.get.call(null,source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__5742 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5742,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5742,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5742,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5742,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5742,(4),null);
var vec__5745 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5745,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5745,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5745,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5745,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5745,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4253__auto__ = source;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4253__auto__ = line;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4253__auto__ = col;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__5748 = segmap;
var map__5748__$1 = cljs.core.__destructure_map(map__5748);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5748__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5748__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5748__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5748__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5748__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__5750 = arguments.length;
switch (G__5750) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__5754 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__5758 = cljs.core.next(segs__$1);
var G__5759 = nrelseg;
var G__5760 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__5758;
relseg__$1 = G__5759;
result__$1 = G__5760;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5754,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5754,(1),null);
var G__5761 = (gline + (1));
var G__5762 = cljs.core.next(lines__$1);
var G__5763 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__5764 = result__$1;
gline = G__5761;
lines__$1 = G__5762;
relseg = G__5763;
result = G__5764;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__5766 = segmap;
var map__5766__$1 = cljs.core.__destructure_map(map__5766);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5766__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5766__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5766__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5766__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5766__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__5765_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__5765_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__5768 = arguments.length;
switch (G__5768) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__5772 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__5776 = cljs.core.next(segs__$1);
var G__5777 = nrelseg;
var G__5778 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__5776;
relseg__$1 = G__5777;
result__$1 = G__5778;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5772,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5772,(1),null);
var G__5779 = (gline + (1));
var G__5780 = cljs.core.next(lines__$1);
var G__5781 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__5782 = result__$1;
gline = G__5779;
lines__$1 = G__5780;
relseg = G__5781;
result = G__5782;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__5783){
var vec__5784 = p__5783;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5784,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5784,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5784,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5784,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5784,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__5787){
var vec__5788 = p__5787;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5788,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5788,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5788,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5788,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5788,(4),null);
var seg = vec__5788;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__5791){
var vec__5792 = p__5791;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5792,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5792,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5792,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5792,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5792,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__5798 = cljs.core.seq(infos);
var chunk__5799 = null;
var count__5800 = (0);
var i__5801 = (0);
while(true){
if((i__5801 < count__5800)){
var info = chunk__5799.cljs$core$IIndexed$_nth$arity$2(null,i__5801);
var segv_6155 = info__GT_segv(info,source_idx,line,col);
var gline_6156 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6157 = cljs.core.count(cljs.core.deref(lines));
if((gline_6156 > (lc_6157 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5798,chunk__5799,count__5800,i__5801,segv_6155,gline_6156,lc_6157,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_6156 - (lc_6157 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6155], null));
});})(seq__5798,chunk__5799,count__5800,i__5801,segv_6155,gline_6156,lc_6157,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5798,chunk__5799,count__5800,i__5801,segv_6155,gline_6156,lc_6157,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6156], null),cljs.core.conj,segv_6155);
});})(seq__5798,chunk__5799,count__5800,i__5801,segv_6155,gline_6156,lc_6157,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6158 = seq__5798;
var G__6159 = chunk__5799;
var G__6160 = count__5800;
var G__6161 = (i__5801 + (1));
seq__5798 = G__6158;
chunk__5799 = G__6159;
count__5800 = G__6160;
i__5801 = G__6161;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__5798);
if(temp__5753__auto__){
var seq__5798__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5798__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__5798__$1);
var G__6162 = cljs.core.chunk_rest(seq__5798__$1);
var G__6163 = c__4679__auto__;
var G__6164 = cljs.core.count(c__4679__auto__);
var G__6165 = (0);
seq__5798 = G__6162;
chunk__5799 = G__6163;
count__5800 = G__6164;
i__5801 = G__6165;
continue;
} else {
var info = cljs.core.first(seq__5798__$1);
var segv_6166 = info__GT_segv(info,source_idx,line,col);
var gline_6167 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6168 = cljs.core.count(cljs.core.deref(lines));
if((gline_6167 > (lc_6168 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5798,chunk__5799,count__5800,i__5801,segv_6166,gline_6167,lc_6168,info,seq__5798__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_6167 - (lc_6168 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6166], null));
});})(seq__5798,chunk__5799,count__5800,i__5801,segv_6166,gline_6167,lc_6168,info,seq__5798__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5798,chunk__5799,count__5800,i__5801,segv_6166,gline_6167,lc_6168,info,seq__5798__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6167], null),cljs.core.conj,segv_6166);
});})(seq__5798,chunk__5799,count__5800,i__5801,segv_6166,gline_6167,lc_6168,info,seq__5798__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6169 = cljs.core.next(seq__5798__$1);
var G__6170 = null;
var G__6171 = (0);
var G__6172 = (0);
seq__5798 = G__6169;
chunk__5799 = G__6170;
count__5800 = G__6171;
i__5801 = G__6172;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__5802_6173 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__5803_6174 = null;
var count__5804_6175 = (0);
var i__5805_6176 = (0);
while(true){
if((i__5805_6176 < count__5804_6175)){
var vec__5978_6177 = chunk__5803_6174.cljs$core$IIndexed$_nth$arity$2(null,i__5805_6176);
var source_idx_6178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5978_6177,(0),null);
var vec__5981_6179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5978_6177,(1),null);
var __6180 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5981_6179,(0),null);
var lines_6181__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5981_6179,(1),null);
var seq__5984_6182 = cljs.core.seq(lines_6181__$1);
var chunk__5985_6183 = null;
var count__5986_6184 = (0);
var i__5987_6185 = (0);
while(true){
if((i__5987_6185 < count__5986_6184)){
var vec__6026_6186 = chunk__5985_6183.cljs$core$IIndexed$_nth$arity$2(null,i__5987_6185);
var line_6187 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6026_6186,(0),null);
var cols_6188 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6026_6186,(1),null);
var seq__6029_6189 = cljs.core.seq(cols_6188);
var chunk__6030_6190 = null;
var count__6031_6191 = (0);
var i__6032_6192 = (0);
while(true){
if((i__6032_6192 < count__6031_6191)){
var vec__6039_6193 = chunk__6030_6190.cljs$core$IIndexed$_nth$arity$2(null,i__6032_6192);
var col_6194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6039_6193,(0),null);
var infos_6195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6039_6193,(1),null);
encode_cols(infos_6195,source_idx_6178,line_6187,col_6194);


var G__6196 = seq__6029_6189;
var G__6197 = chunk__6030_6190;
var G__6198 = count__6031_6191;
var G__6199 = (i__6032_6192 + (1));
seq__6029_6189 = G__6196;
chunk__6030_6190 = G__6197;
count__6031_6191 = G__6198;
i__6032_6192 = G__6199;
continue;
} else {
var temp__5753__auto___6200 = cljs.core.seq(seq__6029_6189);
if(temp__5753__auto___6200){
var seq__6029_6201__$1 = temp__5753__auto___6200;
if(cljs.core.chunked_seq_QMARK_(seq__6029_6201__$1)){
var c__4679__auto___6202 = cljs.core.chunk_first(seq__6029_6201__$1);
var G__6203 = cljs.core.chunk_rest(seq__6029_6201__$1);
var G__6204 = c__4679__auto___6202;
var G__6205 = cljs.core.count(c__4679__auto___6202);
var G__6206 = (0);
seq__6029_6189 = G__6203;
chunk__6030_6190 = G__6204;
count__6031_6191 = G__6205;
i__6032_6192 = G__6206;
continue;
} else {
var vec__6042_6207 = cljs.core.first(seq__6029_6201__$1);
var col_6208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6042_6207,(0),null);
var infos_6209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6042_6207,(1),null);
encode_cols(infos_6209,source_idx_6178,line_6187,col_6208);


var G__6210 = cljs.core.next(seq__6029_6201__$1);
var G__6211 = null;
var G__6212 = (0);
var G__6213 = (0);
seq__6029_6189 = G__6210;
chunk__6030_6190 = G__6211;
count__6031_6191 = G__6212;
i__6032_6192 = G__6213;
continue;
}
} else {
}
}
break;
}


var G__6214 = seq__5984_6182;
var G__6215 = chunk__5985_6183;
var G__6216 = count__5986_6184;
var G__6217 = (i__5987_6185 + (1));
seq__5984_6182 = G__6214;
chunk__5985_6183 = G__6215;
count__5986_6184 = G__6216;
i__5987_6185 = G__6217;
continue;
} else {
var temp__5753__auto___6218 = cljs.core.seq(seq__5984_6182);
if(temp__5753__auto___6218){
var seq__5984_6219__$1 = temp__5753__auto___6218;
if(cljs.core.chunked_seq_QMARK_(seq__5984_6219__$1)){
var c__4679__auto___6220 = cljs.core.chunk_first(seq__5984_6219__$1);
var G__6221 = cljs.core.chunk_rest(seq__5984_6219__$1);
var G__6222 = c__4679__auto___6220;
var G__6223 = cljs.core.count(c__4679__auto___6220);
var G__6224 = (0);
seq__5984_6182 = G__6221;
chunk__5985_6183 = G__6222;
count__5986_6184 = G__6223;
i__5987_6185 = G__6224;
continue;
} else {
var vec__6045_6225 = cljs.core.first(seq__5984_6219__$1);
var line_6226 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6045_6225,(0),null);
var cols_6227 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6045_6225,(1),null);
var seq__6048_6228 = cljs.core.seq(cols_6227);
var chunk__6049_6229 = null;
var count__6050_6230 = (0);
var i__6051_6231 = (0);
while(true){
if((i__6051_6231 < count__6050_6230)){
var vec__6058_6232 = chunk__6049_6229.cljs$core$IIndexed$_nth$arity$2(null,i__6051_6231);
var col_6233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6058_6232,(0),null);
var infos_6234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6058_6232,(1),null);
encode_cols(infos_6234,source_idx_6178,line_6226,col_6233);


var G__6235 = seq__6048_6228;
var G__6236 = chunk__6049_6229;
var G__6237 = count__6050_6230;
var G__6238 = (i__6051_6231 + (1));
seq__6048_6228 = G__6235;
chunk__6049_6229 = G__6236;
count__6050_6230 = G__6237;
i__6051_6231 = G__6238;
continue;
} else {
var temp__5753__auto___6239__$1 = cljs.core.seq(seq__6048_6228);
if(temp__5753__auto___6239__$1){
var seq__6048_6240__$1 = temp__5753__auto___6239__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6048_6240__$1)){
var c__4679__auto___6241 = cljs.core.chunk_first(seq__6048_6240__$1);
var G__6242 = cljs.core.chunk_rest(seq__6048_6240__$1);
var G__6243 = c__4679__auto___6241;
var G__6244 = cljs.core.count(c__4679__auto___6241);
var G__6245 = (0);
seq__6048_6228 = G__6242;
chunk__6049_6229 = G__6243;
count__6050_6230 = G__6244;
i__6051_6231 = G__6245;
continue;
} else {
var vec__6061_6246 = cljs.core.first(seq__6048_6240__$1);
var col_6247 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6061_6246,(0),null);
var infos_6248 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6061_6246,(1),null);
encode_cols(infos_6248,source_idx_6178,line_6226,col_6247);


var G__6249 = cljs.core.next(seq__6048_6240__$1);
var G__6250 = null;
var G__6251 = (0);
var G__6252 = (0);
seq__6048_6228 = G__6249;
chunk__6049_6229 = G__6250;
count__6050_6230 = G__6251;
i__6051_6231 = G__6252;
continue;
}
} else {
}
}
break;
}


var G__6253 = cljs.core.next(seq__5984_6219__$1);
var G__6254 = null;
var G__6255 = (0);
var G__6256 = (0);
seq__5984_6182 = G__6253;
chunk__5985_6183 = G__6254;
count__5986_6184 = G__6255;
i__5987_6185 = G__6256;
continue;
}
} else {
}
}
break;
}


var G__6257 = seq__5802_6173;
var G__6258 = chunk__5803_6174;
var G__6259 = count__5804_6175;
var G__6260 = (i__5805_6176 + (1));
seq__5802_6173 = G__6257;
chunk__5803_6174 = G__6258;
count__5804_6175 = G__6259;
i__5805_6176 = G__6260;
continue;
} else {
var temp__5753__auto___6261 = cljs.core.seq(seq__5802_6173);
if(temp__5753__auto___6261){
var seq__5802_6262__$1 = temp__5753__auto___6261;
if(cljs.core.chunked_seq_QMARK_(seq__5802_6262__$1)){
var c__4679__auto___6263 = cljs.core.chunk_first(seq__5802_6262__$1);
var G__6264 = cljs.core.chunk_rest(seq__5802_6262__$1);
var G__6265 = c__4679__auto___6263;
var G__6266 = cljs.core.count(c__4679__auto___6263);
var G__6267 = (0);
seq__5802_6173 = G__6264;
chunk__5803_6174 = G__6265;
count__5804_6175 = G__6266;
i__5805_6176 = G__6267;
continue;
} else {
var vec__6064_6268 = cljs.core.first(seq__5802_6262__$1);
var source_idx_6269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6064_6268,(0),null);
var vec__6067_6270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6064_6268,(1),null);
var __6271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6067_6270,(0),null);
var lines_6272__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6067_6270,(1),null);
var seq__6070_6273 = cljs.core.seq(lines_6272__$1);
var chunk__6071_6274 = null;
var count__6072_6275 = (0);
var i__6073_6276 = (0);
while(true){
if((i__6073_6276 < count__6072_6275)){
var vec__6112_6277 = chunk__6071_6274.cljs$core$IIndexed$_nth$arity$2(null,i__6073_6276);
var line_6278 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6112_6277,(0),null);
var cols_6279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6112_6277,(1),null);
var seq__6115_6280 = cljs.core.seq(cols_6279);
var chunk__6116_6281 = null;
var count__6117_6282 = (0);
var i__6118_6283 = (0);
while(true){
if((i__6118_6283 < count__6117_6282)){
var vec__6125_6284 = chunk__6116_6281.cljs$core$IIndexed$_nth$arity$2(null,i__6118_6283);
var col_6285 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6125_6284,(0),null);
var infos_6286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6125_6284,(1),null);
encode_cols(infos_6286,source_idx_6269,line_6278,col_6285);


var G__6287 = seq__6115_6280;
var G__6288 = chunk__6116_6281;
var G__6289 = count__6117_6282;
var G__6290 = (i__6118_6283 + (1));
seq__6115_6280 = G__6287;
chunk__6116_6281 = G__6288;
count__6117_6282 = G__6289;
i__6118_6283 = G__6290;
continue;
} else {
var temp__5753__auto___6291__$1 = cljs.core.seq(seq__6115_6280);
if(temp__5753__auto___6291__$1){
var seq__6115_6292__$1 = temp__5753__auto___6291__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6115_6292__$1)){
var c__4679__auto___6293 = cljs.core.chunk_first(seq__6115_6292__$1);
var G__6294 = cljs.core.chunk_rest(seq__6115_6292__$1);
var G__6295 = c__4679__auto___6293;
var G__6296 = cljs.core.count(c__4679__auto___6293);
var G__6297 = (0);
seq__6115_6280 = G__6294;
chunk__6116_6281 = G__6295;
count__6117_6282 = G__6296;
i__6118_6283 = G__6297;
continue;
} else {
var vec__6128_6298 = cljs.core.first(seq__6115_6292__$1);
var col_6299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6128_6298,(0),null);
var infos_6300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6128_6298,(1),null);
encode_cols(infos_6300,source_idx_6269,line_6278,col_6299);


var G__6301 = cljs.core.next(seq__6115_6292__$1);
var G__6302 = null;
var G__6303 = (0);
var G__6304 = (0);
seq__6115_6280 = G__6301;
chunk__6116_6281 = G__6302;
count__6117_6282 = G__6303;
i__6118_6283 = G__6304;
continue;
}
} else {
}
}
break;
}


var G__6305 = seq__6070_6273;
var G__6306 = chunk__6071_6274;
var G__6307 = count__6072_6275;
var G__6308 = (i__6073_6276 + (1));
seq__6070_6273 = G__6305;
chunk__6071_6274 = G__6306;
count__6072_6275 = G__6307;
i__6073_6276 = G__6308;
continue;
} else {
var temp__5753__auto___6309__$1 = cljs.core.seq(seq__6070_6273);
if(temp__5753__auto___6309__$1){
var seq__6070_6310__$1 = temp__5753__auto___6309__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6070_6310__$1)){
var c__4679__auto___6311 = cljs.core.chunk_first(seq__6070_6310__$1);
var G__6312 = cljs.core.chunk_rest(seq__6070_6310__$1);
var G__6313 = c__4679__auto___6311;
var G__6314 = cljs.core.count(c__4679__auto___6311);
var G__6315 = (0);
seq__6070_6273 = G__6312;
chunk__6071_6274 = G__6313;
count__6072_6275 = G__6314;
i__6073_6276 = G__6315;
continue;
} else {
var vec__6131_6316 = cljs.core.first(seq__6070_6310__$1);
var line_6317 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6131_6316,(0),null);
var cols_6318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6131_6316,(1),null);
var seq__6134_6319 = cljs.core.seq(cols_6318);
var chunk__6135_6320 = null;
var count__6136_6321 = (0);
var i__6137_6322 = (0);
while(true){
if((i__6137_6322 < count__6136_6321)){
var vec__6144_6323 = chunk__6135_6320.cljs$core$IIndexed$_nth$arity$2(null,i__6137_6322);
var col_6324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6144_6323,(0),null);
var infos_6325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6144_6323,(1),null);
encode_cols(infos_6325,source_idx_6269,line_6317,col_6324);


var G__6326 = seq__6134_6319;
var G__6327 = chunk__6135_6320;
var G__6328 = count__6136_6321;
var G__6329 = (i__6137_6322 + (1));
seq__6134_6319 = G__6326;
chunk__6135_6320 = G__6327;
count__6136_6321 = G__6328;
i__6137_6322 = G__6329;
continue;
} else {
var temp__5753__auto___6330__$2 = cljs.core.seq(seq__6134_6319);
if(temp__5753__auto___6330__$2){
var seq__6134_6331__$1 = temp__5753__auto___6330__$2;
if(cljs.core.chunked_seq_QMARK_(seq__6134_6331__$1)){
var c__4679__auto___6332 = cljs.core.chunk_first(seq__6134_6331__$1);
var G__6333 = cljs.core.chunk_rest(seq__6134_6331__$1);
var G__6334 = c__4679__auto___6332;
var G__6335 = cljs.core.count(c__4679__auto___6332);
var G__6336 = (0);
seq__6134_6319 = G__6333;
chunk__6135_6320 = G__6334;
count__6136_6321 = G__6335;
i__6137_6322 = G__6336;
continue;
} else {
var vec__6147_6337 = cljs.core.first(seq__6134_6331__$1);
var col_6338 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6147_6337,(0),null);
var infos_6339 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6147_6337,(1),null);
encode_cols(infos_6339,source_idx_6269,line_6317,col_6338);


var G__6340 = cljs.core.next(seq__6134_6331__$1);
var G__6341 = null;
var G__6342 = (0);
var G__6343 = (0);
seq__6134_6319 = G__6340;
chunk__6135_6320 = G__6341;
count__6136_6321 = G__6342;
i__6137_6322 = G__6343;
continue;
}
} else {
}
}
break;
}


var G__6344 = cljs.core.next(seq__6070_6310__$1);
var G__6345 = null;
var G__6346 = (0);
var G__6347 = (0);
seq__6070_6273 = G__6344;
chunk__6071_6274 = G__6345;
count__6072_6275 = G__6346;
i__6073_6276 = G__6347;
continue;
}
} else {
}
}
break;
}


var G__6348 = cljs.core.next(seq__5802_6262__$1);
var G__6349 = null;
var G__6350 = (0);
var G__6351 = (0);
seq__5802_6173 = G__6348;
chunk__5803_6174 = G__6349;
count__5804_6175 = G__6350;
i__5805_6176 = G__6351;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__6150 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__5795_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__5795_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__5796_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__5796_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__5797_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__5797_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__6151 = G__6150;
var G__6152_6352 = G__6151;
var G__6153_6353 = "sourcesContent";
var G__6154_6354 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
cljs.source_map.goog$module$goog$object.set.call(null,G__6152_6352,G__6153_6353,G__6154_6354);

return G__6151;
} else {
return G__6150;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__6355 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6355,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6355,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__6358 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6358,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6358,(1),null);
var G__6363 = cljs.core.next(col_map_seq);
var G__6364 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__6358,col,infos,vec__6355,line,col_map){
return (function (v,p__6361){
var map__6362 = p__6361;
var map__6362__$1 = cljs.core.__destructure_map(map__6362);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6362__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6362__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__6358,col,infos,vec__6355,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__6363;
new_cols = G__6364;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__6365 = cljs.core.next(line_map_seq);
var G__6366 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__6365;
new_lines = G__6366;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__6367_6575 = cljs.core.seq(reverse_map);
var chunk__6368_6576 = null;
var count__6369_6577 = (0);
var i__6370_6578 = (0);
while(true){
if((i__6370_6578 < count__6369_6577)){
var vec__6473_6579 = chunk__6368_6576.cljs$core$IIndexed$_nth$arity$2(null,i__6370_6578);
var line_6580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6473_6579,(0),null);
var columns_6581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6473_6579,(1),null);
var seq__6476_6582 = cljs.core.seq(columns_6581);
var chunk__6477_6583 = null;
var count__6478_6584 = (0);
var i__6479_6585 = (0);
while(true){
if((i__6479_6585 < count__6478_6584)){
var vec__6502_6586 = chunk__6477_6583.cljs$core$IIndexed$_nth$arity$2(null,i__6479_6585);
var column_6587 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6502_6586,(0),null);
var column_info_6588 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6502_6586,(1),null);
var seq__6505_6589 = cljs.core.seq(column_info_6588);
var chunk__6506_6590 = null;
var count__6507_6591 = (0);
var i__6508_6592 = (0);
while(true){
if((i__6508_6592 < count__6507_6591)){
var map__6511_6593 = chunk__6506_6590.cljs$core$IIndexed$_nth$arity$2(null,i__6508_6592);
var map__6511_6594__$1 = cljs.core.__destructure_map(map__6511_6593);
var gline_6595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6511_6594__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6596 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6511_6594__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6597 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6511_6594__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6595], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6505_6589,chunk__6506_6590,count__6507_6591,i__6508_6592,seq__6476_6582,chunk__6477_6583,count__6478_6584,i__6479_6585,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6511_6593,map__6511_6594__$1,gline_6595,gcol_6596,name_6597,vec__6502_6586,column_6587,column_info_6588,vec__6473_6579,line_6580,columns_6581,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6596], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6580,new cljs.core.Keyword(null,"col","col",-1959363084),column_6587,new cljs.core.Keyword(null,"name","name",1843675177),name_6597], null));
});})(seq__6505_6589,chunk__6506_6590,count__6507_6591,i__6508_6592,seq__6476_6582,chunk__6477_6583,count__6478_6584,i__6479_6585,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6511_6593,map__6511_6594__$1,gline_6595,gcol_6596,name_6597,vec__6502_6586,column_6587,column_info_6588,vec__6473_6579,line_6580,columns_6581,inverted))
,cljs.core.sorted_map()));


var G__6598 = seq__6505_6589;
var G__6599 = chunk__6506_6590;
var G__6600 = count__6507_6591;
var G__6601 = (i__6508_6592 + (1));
seq__6505_6589 = G__6598;
chunk__6506_6590 = G__6599;
count__6507_6591 = G__6600;
i__6508_6592 = G__6601;
continue;
} else {
var temp__5753__auto___6602 = cljs.core.seq(seq__6505_6589);
if(temp__5753__auto___6602){
var seq__6505_6603__$1 = temp__5753__auto___6602;
if(cljs.core.chunked_seq_QMARK_(seq__6505_6603__$1)){
var c__4679__auto___6604 = cljs.core.chunk_first(seq__6505_6603__$1);
var G__6605 = cljs.core.chunk_rest(seq__6505_6603__$1);
var G__6606 = c__4679__auto___6604;
var G__6607 = cljs.core.count(c__4679__auto___6604);
var G__6608 = (0);
seq__6505_6589 = G__6605;
chunk__6506_6590 = G__6606;
count__6507_6591 = G__6607;
i__6508_6592 = G__6608;
continue;
} else {
var map__6512_6609 = cljs.core.first(seq__6505_6603__$1);
var map__6512_6610__$1 = cljs.core.__destructure_map(map__6512_6609);
var gline_6611 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6512_6610__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6612 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6512_6610__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6613 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6512_6610__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6611], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6505_6589,chunk__6506_6590,count__6507_6591,i__6508_6592,seq__6476_6582,chunk__6477_6583,count__6478_6584,i__6479_6585,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6512_6609,map__6512_6610__$1,gline_6611,gcol_6612,name_6613,seq__6505_6603__$1,temp__5753__auto___6602,vec__6502_6586,column_6587,column_info_6588,vec__6473_6579,line_6580,columns_6581,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6612], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6580,new cljs.core.Keyword(null,"col","col",-1959363084),column_6587,new cljs.core.Keyword(null,"name","name",1843675177),name_6613], null));
});})(seq__6505_6589,chunk__6506_6590,count__6507_6591,i__6508_6592,seq__6476_6582,chunk__6477_6583,count__6478_6584,i__6479_6585,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6512_6609,map__6512_6610__$1,gline_6611,gcol_6612,name_6613,seq__6505_6603__$1,temp__5753__auto___6602,vec__6502_6586,column_6587,column_info_6588,vec__6473_6579,line_6580,columns_6581,inverted))
,cljs.core.sorted_map()));


var G__6614 = cljs.core.next(seq__6505_6603__$1);
var G__6615 = null;
var G__6616 = (0);
var G__6617 = (0);
seq__6505_6589 = G__6614;
chunk__6506_6590 = G__6615;
count__6507_6591 = G__6616;
i__6508_6592 = G__6617;
continue;
}
} else {
}
}
break;
}


var G__6618 = seq__6476_6582;
var G__6619 = chunk__6477_6583;
var G__6620 = count__6478_6584;
var G__6621 = (i__6479_6585 + (1));
seq__6476_6582 = G__6618;
chunk__6477_6583 = G__6619;
count__6478_6584 = G__6620;
i__6479_6585 = G__6621;
continue;
} else {
var temp__5753__auto___6622 = cljs.core.seq(seq__6476_6582);
if(temp__5753__auto___6622){
var seq__6476_6623__$1 = temp__5753__auto___6622;
if(cljs.core.chunked_seq_QMARK_(seq__6476_6623__$1)){
var c__4679__auto___6624 = cljs.core.chunk_first(seq__6476_6623__$1);
var G__6625 = cljs.core.chunk_rest(seq__6476_6623__$1);
var G__6626 = c__4679__auto___6624;
var G__6627 = cljs.core.count(c__4679__auto___6624);
var G__6628 = (0);
seq__6476_6582 = G__6625;
chunk__6477_6583 = G__6626;
count__6478_6584 = G__6627;
i__6479_6585 = G__6628;
continue;
} else {
var vec__6513_6629 = cljs.core.first(seq__6476_6623__$1);
var column_6630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6513_6629,(0),null);
var column_info_6631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6513_6629,(1),null);
var seq__6516_6632 = cljs.core.seq(column_info_6631);
var chunk__6517_6633 = null;
var count__6518_6634 = (0);
var i__6519_6635 = (0);
while(true){
if((i__6519_6635 < count__6518_6634)){
var map__6522_6636 = chunk__6517_6633.cljs$core$IIndexed$_nth$arity$2(null,i__6519_6635);
var map__6522_6637__$1 = cljs.core.__destructure_map(map__6522_6636);
var gline_6638 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6522_6637__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6639 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6522_6637__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6640 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6522_6637__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6638], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6516_6632,chunk__6517_6633,count__6518_6634,i__6519_6635,seq__6476_6582,chunk__6477_6583,count__6478_6584,i__6479_6585,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6522_6636,map__6522_6637__$1,gline_6638,gcol_6639,name_6640,vec__6513_6629,column_6630,column_info_6631,seq__6476_6623__$1,temp__5753__auto___6622,vec__6473_6579,line_6580,columns_6581,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6639], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6580,new cljs.core.Keyword(null,"col","col",-1959363084),column_6630,new cljs.core.Keyword(null,"name","name",1843675177),name_6640], null));
});})(seq__6516_6632,chunk__6517_6633,count__6518_6634,i__6519_6635,seq__6476_6582,chunk__6477_6583,count__6478_6584,i__6479_6585,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6522_6636,map__6522_6637__$1,gline_6638,gcol_6639,name_6640,vec__6513_6629,column_6630,column_info_6631,seq__6476_6623__$1,temp__5753__auto___6622,vec__6473_6579,line_6580,columns_6581,inverted))
,cljs.core.sorted_map()));


var G__6641 = seq__6516_6632;
var G__6642 = chunk__6517_6633;
var G__6643 = count__6518_6634;
var G__6644 = (i__6519_6635 + (1));
seq__6516_6632 = G__6641;
chunk__6517_6633 = G__6642;
count__6518_6634 = G__6643;
i__6519_6635 = G__6644;
continue;
} else {
var temp__5753__auto___6645__$1 = cljs.core.seq(seq__6516_6632);
if(temp__5753__auto___6645__$1){
var seq__6516_6646__$1 = temp__5753__auto___6645__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6516_6646__$1)){
var c__4679__auto___6647 = cljs.core.chunk_first(seq__6516_6646__$1);
var G__6648 = cljs.core.chunk_rest(seq__6516_6646__$1);
var G__6649 = c__4679__auto___6647;
var G__6650 = cljs.core.count(c__4679__auto___6647);
var G__6651 = (0);
seq__6516_6632 = G__6648;
chunk__6517_6633 = G__6649;
count__6518_6634 = G__6650;
i__6519_6635 = G__6651;
continue;
} else {
var map__6523_6652 = cljs.core.first(seq__6516_6646__$1);
var map__6523_6653__$1 = cljs.core.__destructure_map(map__6523_6652);
var gline_6654 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6523_6653__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6655 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6523_6653__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6656 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6523_6653__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6654], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6516_6632,chunk__6517_6633,count__6518_6634,i__6519_6635,seq__6476_6582,chunk__6477_6583,count__6478_6584,i__6479_6585,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6523_6652,map__6523_6653__$1,gline_6654,gcol_6655,name_6656,seq__6516_6646__$1,temp__5753__auto___6645__$1,vec__6513_6629,column_6630,column_info_6631,seq__6476_6623__$1,temp__5753__auto___6622,vec__6473_6579,line_6580,columns_6581,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6655], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6580,new cljs.core.Keyword(null,"col","col",-1959363084),column_6630,new cljs.core.Keyword(null,"name","name",1843675177),name_6656], null));
});})(seq__6516_6632,chunk__6517_6633,count__6518_6634,i__6519_6635,seq__6476_6582,chunk__6477_6583,count__6478_6584,i__6479_6585,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6523_6652,map__6523_6653__$1,gline_6654,gcol_6655,name_6656,seq__6516_6646__$1,temp__5753__auto___6645__$1,vec__6513_6629,column_6630,column_info_6631,seq__6476_6623__$1,temp__5753__auto___6622,vec__6473_6579,line_6580,columns_6581,inverted))
,cljs.core.sorted_map()));


var G__6657 = cljs.core.next(seq__6516_6646__$1);
var G__6658 = null;
var G__6659 = (0);
var G__6660 = (0);
seq__6516_6632 = G__6657;
chunk__6517_6633 = G__6658;
count__6518_6634 = G__6659;
i__6519_6635 = G__6660;
continue;
}
} else {
}
}
break;
}


var G__6661 = cljs.core.next(seq__6476_6623__$1);
var G__6662 = null;
var G__6663 = (0);
var G__6664 = (0);
seq__6476_6582 = G__6661;
chunk__6477_6583 = G__6662;
count__6478_6584 = G__6663;
i__6479_6585 = G__6664;
continue;
}
} else {
}
}
break;
}


var G__6665 = seq__6367_6575;
var G__6666 = chunk__6368_6576;
var G__6667 = count__6369_6577;
var G__6668 = (i__6370_6578 + (1));
seq__6367_6575 = G__6665;
chunk__6368_6576 = G__6666;
count__6369_6577 = G__6667;
i__6370_6578 = G__6668;
continue;
} else {
var temp__5753__auto___6669 = cljs.core.seq(seq__6367_6575);
if(temp__5753__auto___6669){
var seq__6367_6670__$1 = temp__5753__auto___6669;
if(cljs.core.chunked_seq_QMARK_(seq__6367_6670__$1)){
var c__4679__auto___6671 = cljs.core.chunk_first(seq__6367_6670__$1);
var G__6672 = cljs.core.chunk_rest(seq__6367_6670__$1);
var G__6673 = c__4679__auto___6671;
var G__6674 = cljs.core.count(c__4679__auto___6671);
var G__6675 = (0);
seq__6367_6575 = G__6672;
chunk__6368_6576 = G__6673;
count__6369_6577 = G__6674;
i__6370_6578 = G__6675;
continue;
} else {
var vec__6524_6676 = cljs.core.first(seq__6367_6670__$1);
var line_6677 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6524_6676,(0),null);
var columns_6678 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6524_6676,(1),null);
var seq__6527_6679 = cljs.core.seq(columns_6678);
var chunk__6528_6680 = null;
var count__6529_6681 = (0);
var i__6530_6682 = (0);
while(true){
if((i__6530_6682 < count__6529_6681)){
var vec__6553_6683 = chunk__6528_6680.cljs$core$IIndexed$_nth$arity$2(null,i__6530_6682);
var column_6684 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6553_6683,(0),null);
var column_info_6685 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6553_6683,(1),null);
var seq__6556_6686 = cljs.core.seq(column_info_6685);
var chunk__6557_6687 = null;
var count__6558_6688 = (0);
var i__6559_6689 = (0);
while(true){
if((i__6559_6689 < count__6558_6688)){
var map__6562_6690 = chunk__6557_6687.cljs$core$IIndexed$_nth$arity$2(null,i__6559_6689);
var map__6562_6691__$1 = cljs.core.__destructure_map(map__6562_6690);
var gline_6692 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6562_6691__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6693 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6562_6691__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6694 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6562_6691__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6692], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6556_6686,chunk__6557_6687,count__6558_6688,i__6559_6689,seq__6527_6679,chunk__6528_6680,count__6529_6681,i__6530_6682,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6562_6690,map__6562_6691__$1,gline_6692,gcol_6693,name_6694,vec__6553_6683,column_6684,column_info_6685,vec__6524_6676,line_6677,columns_6678,seq__6367_6670__$1,temp__5753__auto___6669,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6693], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6677,new cljs.core.Keyword(null,"col","col",-1959363084),column_6684,new cljs.core.Keyword(null,"name","name",1843675177),name_6694], null));
});})(seq__6556_6686,chunk__6557_6687,count__6558_6688,i__6559_6689,seq__6527_6679,chunk__6528_6680,count__6529_6681,i__6530_6682,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6562_6690,map__6562_6691__$1,gline_6692,gcol_6693,name_6694,vec__6553_6683,column_6684,column_info_6685,vec__6524_6676,line_6677,columns_6678,seq__6367_6670__$1,temp__5753__auto___6669,inverted))
,cljs.core.sorted_map()));


var G__6695 = seq__6556_6686;
var G__6696 = chunk__6557_6687;
var G__6697 = count__6558_6688;
var G__6698 = (i__6559_6689 + (1));
seq__6556_6686 = G__6695;
chunk__6557_6687 = G__6696;
count__6558_6688 = G__6697;
i__6559_6689 = G__6698;
continue;
} else {
var temp__5753__auto___6699__$1 = cljs.core.seq(seq__6556_6686);
if(temp__5753__auto___6699__$1){
var seq__6556_6700__$1 = temp__5753__auto___6699__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6556_6700__$1)){
var c__4679__auto___6701 = cljs.core.chunk_first(seq__6556_6700__$1);
var G__6702 = cljs.core.chunk_rest(seq__6556_6700__$1);
var G__6703 = c__4679__auto___6701;
var G__6704 = cljs.core.count(c__4679__auto___6701);
var G__6705 = (0);
seq__6556_6686 = G__6702;
chunk__6557_6687 = G__6703;
count__6558_6688 = G__6704;
i__6559_6689 = G__6705;
continue;
} else {
var map__6563_6706 = cljs.core.first(seq__6556_6700__$1);
var map__6563_6707__$1 = cljs.core.__destructure_map(map__6563_6706);
var gline_6708 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6563_6707__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6563_6707__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6710 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6563_6707__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6708], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6556_6686,chunk__6557_6687,count__6558_6688,i__6559_6689,seq__6527_6679,chunk__6528_6680,count__6529_6681,i__6530_6682,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6563_6706,map__6563_6707__$1,gline_6708,gcol_6709,name_6710,seq__6556_6700__$1,temp__5753__auto___6699__$1,vec__6553_6683,column_6684,column_info_6685,vec__6524_6676,line_6677,columns_6678,seq__6367_6670__$1,temp__5753__auto___6669,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6709], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6677,new cljs.core.Keyword(null,"col","col",-1959363084),column_6684,new cljs.core.Keyword(null,"name","name",1843675177),name_6710], null));
});})(seq__6556_6686,chunk__6557_6687,count__6558_6688,i__6559_6689,seq__6527_6679,chunk__6528_6680,count__6529_6681,i__6530_6682,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6563_6706,map__6563_6707__$1,gline_6708,gcol_6709,name_6710,seq__6556_6700__$1,temp__5753__auto___6699__$1,vec__6553_6683,column_6684,column_info_6685,vec__6524_6676,line_6677,columns_6678,seq__6367_6670__$1,temp__5753__auto___6669,inverted))
,cljs.core.sorted_map()));


var G__6711 = cljs.core.next(seq__6556_6700__$1);
var G__6712 = null;
var G__6713 = (0);
var G__6714 = (0);
seq__6556_6686 = G__6711;
chunk__6557_6687 = G__6712;
count__6558_6688 = G__6713;
i__6559_6689 = G__6714;
continue;
}
} else {
}
}
break;
}


var G__6715 = seq__6527_6679;
var G__6716 = chunk__6528_6680;
var G__6717 = count__6529_6681;
var G__6718 = (i__6530_6682 + (1));
seq__6527_6679 = G__6715;
chunk__6528_6680 = G__6716;
count__6529_6681 = G__6717;
i__6530_6682 = G__6718;
continue;
} else {
var temp__5753__auto___6719__$1 = cljs.core.seq(seq__6527_6679);
if(temp__5753__auto___6719__$1){
var seq__6527_6720__$1 = temp__5753__auto___6719__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6527_6720__$1)){
var c__4679__auto___6721 = cljs.core.chunk_first(seq__6527_6720__$1);
var G__6722 = cljs.core.chunk_rest(seq__6527_6720__$1);
var G__6723 = c__4679__auto___6721;
var G__6724 = cljs.core.count(c__4679__auto___6721);
var G__6725 = (0);
seq__6527_6679 = G__6722;
chunk__6528_6680 = G__6723;
count__6529_6681 = G__6724;
i__6530_6682 = G__6725;
continue;
} else {
var vec__6564_6726 = cljs.core.first(seq__6527_6720__$1);
var column_6727 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6564_6726,(0),null);
var column_info_6728 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6564_6726,(1),null);
var seq__6567_6729 = cljs.core.seq(column_info_6728);
var chunk__6568_6730 = null;
var count__6569_6731 = (0);
var i__6570_6732 = (0);
while(true){
if((i__6570_6732 < count__6569_6731)){
var map__6573_6733 = chunk__6568_6730.cljs$core$IIndexed$_nth$arity$2(null,i__6570_6732);
var map__6573_6734__$1 = cljs.core.__destructure_map(map__6573_6733);
var gline_6735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6573_6734__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6573_6734__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6737 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6573_6734__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6735], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6567_6729,chunk__6568_6730,count__6569_6731,i__6570_6732,seq__6527_6679,chunk__6528_6680,count__6529_6681,i__6530_6682,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6573_6733,map__6573_6734__$1,gline_6735,gcol_6736,name_6737,vec__6564_6726,column_6727,column_info_6728,seq__6527_6720__$1,temp__5753__auto___6719__$1,vec__6524_6676,line_6677,columns_6678,seq__6367_6670__$1,temp__5753__auto___6669,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6736], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6677,new cljs.core.Keyword(null,"col","col",-1959363084),column_6727,new cljs.core.Keyword(null,"name","name",1843675177),name_6737], null));
});})(seq__6567_6729,chunk__6568_6730,count__6569_6731,i__6570_6732,seq__6527_6679,chunk__6528_6680,count__6529_6681,i__6530_6682,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6573_6733,map__6573_6734__$1,gline_6735,gcol_6736,name_6737,vec__6564_6726,column_6727,column_info_6728,seq__6527_6720__$1,temp__5753__auto___6719__$1,vec__6524_6676,line_6677,columns_6678,seq__6367_6670__$1,temp__5753__auto___6669,inverted))
,cljs.core.sorted_map()));


var G__6738 = seq__6567_6729;
var G__6739 = chunk__6568_6730;
var G__6740 = count__6569_6731;
var G__6741 = (i__6570_6732 + (1));
seq__6567_6729 = G__6738;
chunk__6568_6730 = G__6739;
count__6569_6731 = G__6740;
i__6570_6732 = G__6741;
continue;
} else {
var temp__5753__auto___6742__$2 = cljs.core.seq(seq__6567_6729);
if(temp__5753__auto___6742__$2){
var seq__6567_6743__$1 = temp__5753__auto___6742__$2;
if(cljs.core.chunked_seq_QMARK_(seq__6567_6743__$1)){
var c__4679__auto___6744 = cljs.core.chunk_first(seq__6567_6743__$1);
var G__6745 = cljs.core.chunk_rest(seq__6567_6743__$1);
var G__6746 = c__4679__auto___6744;
var G__6747 = cljs.core.count(c__4679__auto___6744);
var G__6748 = (0);
seq__6567_6729 = G__6745;
chunk__6568_6730 = G__6746;
count__6569_6731 = G__6747;
i__6570_6732 = G__6748;
continue;
} else {
var map__6574_6749 = cljs.core.first(seq__6567_6743__$1);
var map__6574_6750__$1 = cljs.core.__destructure_map(map__6574_6749);
var gline_6751 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6574_6750__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6752 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6574_6750__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6753 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6574_6750__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6751], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6567_6729,chunk__6568_6730,count__6569_6731,i__6570_6732,seq__6527_6679,chunk__6528_6680,count__6529_6681,i__6530_6682,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6574_6749,map__6574_6750__$1,gline_6751,gcol_6752,name_6753,seq__6567_6743__$1,temp__5753__auto___6742__$2,vec__6564_6726,column_6727,column_info_6728,seq__6527_6720__$1,temp__5753__auto___6719__$1,vec__6524_6676,line_6677,columns_6678,seq__6367_6670__$1,temp__5753__auto___6669,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6752], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6677,new cljs.core.Keyword(null,"col","col",-1959363084),column_6727,new cljs.core.Keyword(null,"name","name",1843675177),name_6753], null));
});})(seq__6567_6729,chunk__6568_6730,count__6569_6731,i__6570_6732,seq__6527_6679,chunk__6528_6680,count__6529_6681,i__6530_6682,seq__6367_6575,chunk__6368_6576,count__6369_6577,i__6370_6578,map__6574_6749,map__6574_6750__$1,gline_6751,gcol_6752,name_6753,seq__6567_6743__$1,temp__5753__auto___6742__$2,vec__6564_6726,column_6727,column_info_6728,seq__6527_6720__$1,temp__5753__auto___6719__$1,vec__6524_6676,line_6677,columns_6678,seq__6367_6670__$1,temp__5753__auto___6669,inverted))
,cljs.core.sorted_map()));


var G__6754 = cljs.core.next(seq__6567_6743__$1);
var G__6755 = null;
var G__6756 = (0);
var G__6757 = (0);
seq__6567_6729 = G__6754;
chunk__6568_6730 = G__6755;
count__6569_6731 = G__6756;
i__6570_6732 = G__6757;
continue;
}
} else {
}
}
break;
}


var G__6758 = cljs.core.next(seq__6527_6720__$1);
var G__6759 = null;
var G__6760 = (0);
var G__6761 = (0);
seq__6527_6679 = G__6758;
chunk__6528_6680 = G__6759;
count__6529_6681 = G__6760;
i__6530_6682 = G__6761;
continue;
}
} else {
}
}
break;
}


var G__6762 = cljs.core.next(seq__6367_6670__$1);
var G__6763 = null;
var G__6764 = (0);
var G__6765 = (0);
seq__6367_6575 = G__6762;
chunk__6368_6576 = G__6763;
count__6369_6577 = G__6764;
i__6370_6578 = G__6765;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
