// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__59294 = arguments.length;
switch (G__59294) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2763__auto___59442 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_59381){
var state_val_59382 = (state_59381[(1)]);
if((state_val_59382 === (7))){
var inst_59312 = (state_59381[(7)]);
var inst_59315 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_59312);
var state_59381__$1 = state_59381;
var statearr_59383_59443 = state_59381__$1;
(statearr_59383_59443[(2)] = inst_59315);

(statearr_59383_59443[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (20))){
var inst_59336 = (state_59381[(8)]);
var inst_59307 = (state_59381[(9)]);
var inst_59340 = fluree.db.auth.roles(inst_59307,inst_59336);
var state_59381__$1 = state_59381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59381__$1,(23),inst_59340);
} else {
if((state_val_59382 === (27))){
var inst_59307 = (state_59381[(9)]);
var inst_59355 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_59356 = fluree.db.time_travel.as_of_block(inst_59307,inst_59355);
var state_59381__$1 = state_59381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59381__$1,(30),inst_59356);
} else {
if((state_val_59382 === (1))){
var state_59381__$1 = state_59381;
var statearr_59384_59444 = state_59381__$1;
(statearr_59384_59444[(2)] = null);

(statearr_59384_59444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (24))){
var inst_59307 = (state_59381[(9)]);
var inst_59348 = (state_59381[(10)]);
var inst_59350 = fluree.db.permissions.permission_map(inst_59307,inst_59348,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_59381__$1 = state_59381;
var statearr_59385_59445 = state_59381__$1;
(statearr_59385_59445[(2)] = inst_59350);

(statearr_59385_59445[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (4))){
var inst_59295 = (state_59381[(2)]);
var inst_59296 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_59295);
var inst_59297 = cljs.core.async.close_BANG_(pc);
var state_59381__$1 = (function (){var statearr_59386 = state_59381;
(statearr_59386[(11)] = inst_59296);

return statearr_59386;
})();
var statearr_59387_59446 = state_59381__$1;
(statearr_59387_59446[(2)] = inst_59297);

(statearr_59387_59446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (15))){
var inst_59312 = (state_59381[(7)]);
var inst_59326 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_59312)," unknown."].join('');
var inst_59327 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59328 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_59329 = cljs.core.PersistentHashMap.fromArrays(inst_59327,inst_59328);
var inst_59330 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59326,inst_59329);
var inst_59331 = (function(){throw inst_59330})();
var state_59381__$1 = state_59381;
var statearr_59388_59447 = state_59381__$1;
(statearr_59388_59447[(2)] = inst_59331);

(statearr_59388_59447[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (21))){
var state_59381__$1 = state_59381;
var statearr_59389_59448 = state_59381__$1;
(statearr_59389_59448[(2)] = null);

(statearr_59389_59448[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (31))){
var inst_59312 = (state_59381[(7)]);
var inst_59362 = (state_59381[(12)]);
var inst_59364 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_59362,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_59312);
var state_59381__$1 = state_59381;
var statearr_59390_59449 = state_59381__$1;
(statearr_59390_59449[(2)] = inst_59364);

(statearr_59390_59449[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (32))){
var inst_59362 = (state_59381[(12)]);
var state_59381__$1 = state_59381;
var statearr_59391_59450 = state_59381__$1;
(statearr_59391_59450[(2)] = inst_59362);

(statearr_59391_59450[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (33))){
var inst_59348 = (state_59381[(10)]);
var inst_59367 = (state_59381[(2)]);
var state_59381__$1 = (function (){var statearr_59392 = state_59381;
(statearr_59392[(13)] = inst_59367);

return statearr_59392;
})();
if(cljs.core.truth_(inst_59348)){
var statearr_59393_59451 = state_59381__$1;
(statearr_59393_59451[(1)] = (34));

} else {
var statearr_59394_59452 = state_59381__$1;
(statearr_59394_59452[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (13))){
var inst_59323 = (state_59381[(14)]);
var inst_59322 = (state_59381[(2)]);
var inst_59323__$1 = fluree.db.util.async.throw_err(inst_59322);
var state_59381__$1 = (function (){var statearr_59395 = state_59381;
(statearr_59395[(14)] = inst_59323__$1);

return statearr_59395;
})();
if(cljs.core.truth_(inst_59323__$1)){
var statearr_59396_59453 = state_59381__$1;
(statearr_59396_59453[(1)] = (14));

} else {
var statearr_59397_59454 = state_59381__$1;
(statearr_59397_59454[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (22))){
var inst_59346 = (state_59381[(2)]);
var state_59381__$1 = state_59381;
var statearr_59398_59455 = state_59381__$1;
(statearr_59398_59455[(2)] = inst_59346);

(statearr_59398_59455[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (36))){
var inst_59375 = (state_59381[(2)]);
var inst_59376 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_59375);
var _ = (function (){var statearr_59399 = state_59381;
(statearr_59399[(4)] = cljs.core.rest((state_59381[(4)])));

return statearr_59399;
})();
var state_59381__$1 = state_59381;
var statearr_59400_59456 = state_59381__$1;
(statearr_59400_59456[(2)] = inst_59376);

(statearr_59400_59456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (29))){
var inst_59312 = (state_59381[(7)]);
var inst_59362 = (state_59381[(2)]);
var state_59381__$1 = (function (){var statearr_59401 = state_59381;
(statearr_59401[(12)] = inst_59362);

return statearr_59401;
})();
if(cljs.core.truth_(inst_59312)){
var statearr_59402_59457 = state_59381__$1;
(statearr_59402_59457[(1)] = (31));

} else {
var statearr_59403_59458 = state_59381__$1;
(statearr_59403_59458[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (6))){
var inst_59312 = (state_59381[(7)]);
var inst_59306 = (state_59381[(2)]);
var inst_59307 = fluree.db.util.async.throw_err(inst_59306);
var inst_59308 = opts;
var inst_59309 = cljs.core.__destructure_map(inst_59308);
var inst_59310 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59309,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_59311 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59309,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_59312__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59309,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_59313 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59309,new cljs.core.Keyword(null,"block","block",664686210));
var state_59381__$1 = (function (){var statearr_59404 = state_59381;
(statearr_59404[(15)] = inst_59310);

(statearr_59404[(16)] = inst_59313);

(statearr_59404[(7)] = inst_59312__$1);

(statearr_59404[(17)] = inst_59311);

(statearr_59404[(9)] = inst_59307);

return statearr_59404;
})();
if(cljs.core.truth_(inst_59312__$1)){
var statearr_59405_59459 = state_59381__$1;
(statearr_59405_59459[(1)] = (7));

} else {
var statearr_59406_59460 = state_59381__$1;
(statearr_59406_59460[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (28))){
var inst_59307 = (state_59381[(9)]);
var state_59381__$1 = state_59381;
var statearr_59407_59461 = state_59381__$1;
(statearr_59407_59461[(2)] = inst_59307);

(statearr_59407_59461[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (25))){
var state_59381__$1 = state_59381;
var statearr_59408_59462 = state_59381__$1;
(statearr_59408_59462[(2)] = null);

(statearr_59408_59462[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (34))){
var inst_59353 = (state_59381[(18)]);
var state_59381__$1 = state_59381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59381__$1,(37),inst_59353);
} else {
if((state_val_59382 === (17))){
var inst_59310 = (state_59381[(15)]);
var state_59381__$1 = state_59381;
var statearr_59409_59463 = state_59381__$1;
(statearr_59409_59463[(2)] = inst_59310);

(statearr_59409_59463[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (3))){
var inst_59379 = (state_59381[(2)]);
var state_59381__$1 = state_59381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59381__$1,inst_59379);
} else {
if((state_val_59382 === (12))){
var inst_59310 = (state_59381[(15)]);
var inst_59336 = (state_59381[(2)]);
var state_59381__$1 = (function (){var statearr_59410 = state_59381;
(statearr_59410[(8)] = inst_59336);

return statearr_59410;
})();
if(cljs.core.truth_(inst_59310)){
var statearr_59411_59464 = state_59381__$1;
(statearr_59411_59464[(1)] = (17));

} else {
var statearr_59412_59465 = state_59381__$1;
(statearr_59412_59465[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (2))){
var _ = (function (){var statearr_59413 = state_59381;
(statearr_59413[(4)] = cljs.core.cons((5),(state_59381[(4)])));

return statearr_59413;
})();
var inst_59304 = fluree.db.session.db(conn,ledger,null);
var state_59381__$1 = state_59381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59381__$1,(6),inst_59304);
} else {
if((state_val_59382 === (23))){
var inst_59342 = (state_59381[(2)]);
var inst_59343 = fluree.db.util.async.throw_err(inst_59342);
var state_59381__$1 = state_59381;
var statearr_59414_59466 = state_59381__$1;
(statearr_59414_59466[(2)] = inst_59343);

(statearr_59414_59466[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (35))){
var inst_59367 = (state_59381[(13)]);
var state_59381__$1 = state_59381;
var statearr_59415_59467 = state_59381__$1;
(statearr_59415_59467[(2)] = inst_59367);

(statearr_59415_59467[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (19))){
var inst_59348 = (state_59381[(10)]);
var inst_59348__$1 = (state_59381[(2)]);
var state_59381__$1 = (function (){var statearr_59416 = state_59381;
(statearr_59416[(10)] = inst_59348__$1);

return statearr_59416;
})();
if(cljs.core.truth_(inst_59348__$1)){
var statearr_59417_59468 = state_59381__$1;
(statearr_59417_59468[(1)] = (24));

} else {
var statearr_59418_59469 = state_59381__$1;
(statearr_59418_59469[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (11))){
var state_59381__$1 = state_59381;
var statearr_59420_59470 = state_59381__$1;
(statearr_59420_59470[(2)] = null);

(statearr_59420_59470[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (9))){
var inst_59318 = (state_59381[(2)]);
var state_59381__$1 = state_59381;
if(cljs.core.truth_(inst_59318)){
var statearr_59421_59471 = state_59381__$1;
(statearr_59421_59471[(1)] = (10));

} else {
var statearr_59422_59472 = state_59381__$1;
(statearr_59422_59472[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (5))){
var _ = (function (){var statearr_59423 = state_59381;
(statearr_59423[(4)] = cljs.core.rest((state_59381[(4)])));

return statearr_59423;
})();
var state_59381__$1 = state_59381;
var ex59419 = (state_59381__$1[(2)]);
var statearr_59424_59473 = state_59381__$1;
(statearr_59424_59473[(5)] = ex59419);


var statearr_59425_59474 = state_59381__$1;
(statearr_59425_59474[(1)] = (4));

(statearr_59425_59474[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (14))){
var inst_59323 = (state_59381[(14)]);
var state_59381__$1 = state_59381;
var statearr_59426_59475 = state_59381__$1;
(statearr_59426_59475[(2)] = inst_59323);

(statearr_59426_59475[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (26))){
var inst_59313 = (state_59381[(16)]);
var inst_59353 = (state_59381[(2)]);
var state_59381__$1 = (function (){var statearr_59427 = state_59381;
(statearr_59427[(18)] = inst_59353);

return statearr_59427;
})();
if(cljs.core.truth_(inst_59313)){
var statearr_59428_59476 = state_59381__$1;
(statearr_59428_59476[(1)] = (27));

} else {
var statearr_59429_59477 = state_59381__$1;
(statearr_59429_59477[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (16))){
var inst_59333 = (state_59381[(2)]);
var state_59381__$1 = state_59381;
var statearr_59430_59478 = state_59381__$1;
(statearr_59430_59478[(2)] = inst_59333);

(statearr_59430_59478[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (30))){
var inst_59358 = (state_59381[(2)]);
var inst_59359 = fluree.db.util.async.throw_err(inst_59358);
var state_59381__$1 = state_59381;
var statearr_59431_59479 = state_59381__$1;
(statearr_59431_59479[(2)] = inst_59359);

(statearr_59431_59479[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (10))){
var inst_59312 = (state_59381[(7)]);
var inst_59307 = (state_59381[(9)]);
var inst_59320 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_59307,inst_59312);
var state_59381__$1 = state_59381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59381__$1,(13),inst_59320);
} else {
if((state_val_59382 === (18))){
var inst_59336 = (state_59381[(8)]);
var state_59381__$1 = state_59381;
if(cljs.core.truth_(inst_59336)){
var statearr_59432_59480 = state_59381__$1;
(statearr_59432_59480[(1)] = (20));

} else {
var statearr_59433_59481 = state_59381__$1;
(statearr_59433_59481[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (37))){
var inst_59367 = (state_59381[(13)]);
var inst_59370 = (state_59381[(2)]);
var inst_59371 = fluree.db.util.async.throw_err(inst_59370);
var inst_59372 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_59367,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_59371);
var state_59381__$1 = state_59381;
var statearr_59434_59482 = state_59381__$1;
(statearr_59434_59482[(2)] = inst_59372);

(statearr_59434_59482[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59382 === (8))){
var inst_59312 = (state_59381[(7)]);
var state_59381__$1 = state_59381;
var statearr_59435_59483 = state_59381__$1;
(statearr_59435_59483[(2)] = inst_59312);

(statearr_59435_59483[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2741__auto__ = null;
var fluree$db$api$query$state_machine__2741__auto____0 = (function (){
var statearr_59436 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59436[(0)] = fluree$db$api$query$state_machine__2741__auto__);

(statearr_59436[(1)] = (1));

return statearr_59436;
});
var fluree$db$api$query$state_machine__2741__auto____1 = (function (state_59381){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_59381);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e59437){var ex__2744__auto__ = e59437;
var statearr_59438_59484 = state_59381;
(statearr_59438_59484[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_59381[(4)]))){
var statearr_59439_59485 = state_59381;
(statearr_59439_59485[(1)] = cljs.core.first((state_59381[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59486 = state_59381;
state_59381 = G__59486;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2741__auto__ = function(state_59381){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2741__auto____1.call(this,state_59381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2741__auto____0;
fluree$db$api$query$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2741__auto____1;
return fluree$db$api$query$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_59440 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_59440[(6)] = c__2763__auto___59442);

return statearr_59440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_59627){
var state_val_59628 = (state_59627[(1)]);
if((state_val_59628 === (7))){
var inst_59507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59508 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59509 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59510 = [inst_59508,inst_59509];
var inst_59511 = (new cljs.core.PersistentVector(null,2,(5),inst_59507,inst_59510,null));
var state_59627__$1 = state_59627;
var statearr_59629_59699 = state_59627__$1;
(statearr_59629_59699[(2)] = inst_59511);

(statearr_59629_59699[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (20))){
var inst_59537 = (state_59627[(7)]);
var state_59627__$1 = state_59627;
var statearr_59630_59700 = state_59627__$1;
(statearr_59630_59700[(2)] = inst_59537);

(statearr_59630_59700[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (27))){
var state_59627__$1 = state_59627;
var statearr_59631_59701 = state_59627__$1;
(statearr_59631_59701[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (1))){
var state_59627__$1 = state_59627;
var statearr_59633_59702 = state_59627__$1;
(statearr_59633_59702[(2)] = null);

(statearr_59633_59702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (24))){
var inst_59536 = (state_59627[(8)]);
var state_59627__$1 = state_59627;
if(cljs.core.truth_(inst_59536)){
var statearr_59634_59703 = state_59627__$1;
(statearr_59634_59703[(1)] = (26));

} else {
var statearr_59635_59704 = state_59627__$1;
(statearr_59635_59704[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (39))){
var inst_59583 = (state_59627[(9)]);
var inst_59582 = (state_59627[(10)]);
var inst_59608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59609 = [inst_59582,inst_59583];
var inst_59610 = (new cljs.core.PersistentVector(null,2,(5),inst_59608,inst_59609,null));
var state_59627__$1 = state_59627;
var statearr_59636_59705 = state_59627__$1;
(statearr_59636_59705[(2)] = inst_59610);

(statearr_59636_59705[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (4))){
var inst_59487 = (state_59627[(2)]);
var state_59627__$1 = state_59627;
var statearr_59637_59706 = state_59627__$1;
(statearr_59637_59706[(2)] = inst_59487);

(statearr_59637_59706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (15))){
var inst_59516 = (state_59627[(11)]);
var inst_59521 = (state_59627[(12)]);
var inst_59530 = (state_59627[(2)]);
var inst_59531 = [inst_59521,inst_59530];
var inst_59532 = (new cljs.core.PersistentVector(null,2,(5),inst_59516,inst_59531,null));
var state_59627__$1 = state_59627;
var statearr_59638_59707 = state_59627__$1;
(statearr_59638_59707[(2)] = inst_59532);

(statearr_59638_59707[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (21))){
var inst_59536 = (state_59627[(8)]);
var state_59627__$1 = state_59627;
var statearr_59639_59708 = state_59627__$1;
(statearr_59639_59708[(2)] = inst_59536);

(statearr_59639_59708[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (31))){
var inst_59577 = (state_59627[(2)]);
var state_59627__$1 = state_59627;
var statearr_59640_59709 = state_59627__$1;
(statearr_59640_59709[(2)] = inst_59577);

(statearr_59640_59709[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (32))){
var inst_59583 = (state_59627[(9)]);
var inst_59586 = cljs.core.pos_int_QMARK_(inst_59583);
var state_59627__$1 = state_59627;
var statearr_59641_59710 = state_59627__$1;
(statearr_59641_59710[(2)] = inst_59586);

(statearr_59641_59710[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (40))){
var inst_59614 = (state_59627[(13)]);
var inst_59538 = (state_59627[(14)]);
var inst_59612 = (state_59627[(2)]);
var inst_59613 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59612,(0),null);
var inst_59614__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59612,(1),null);
var inst_59615 = (inst_59614__$1 > inst_59538);
var state_59627__$1 = (function (){var statearr_59642 = state_59627;
(statearr_59642[(15)] = inst_59613);

(statearr_59642[(13)] = inst_59614__$1);

return statearr_59642;
})();
if(cljs.core.truth_(inst_59615)){
var statearr_59643_59711 = state_59627__$1;
(statearr_59643_59711[(1)] = (41));

} else {
var statearr_59644_59712 = state_59627__$1;
(statearr_59644_59712[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (33))){
var inst_59584 = (state_59627[(16)]);
var state_59627__$1 = state_59627;
var statearr_59645_59713 = state_59627__$1;
(statearr_59645_59713[(2)] = inst_59584);

(statearr_59645_59713[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (13))){
var inst_59522 = (state_59627[(17)]);
var inst_59524 = fluree.db.time_travel.block_to_int_format(db,inst_59522);
var state_59627__$1 = state_59627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59627__$1,(16),inst_59524);
} else {
if((state_val_59628 === (22))){
var inst_59555 = (state_59627[(2)]);
var state_59627__$1 = state_59627;
if(cljs.core.truth_(inst_59555)){
var statearr_59646_59714 = state_59627__$1;
(statearr_59646_59714[(1)] = (23));

} else {
var statearr_59647_59715 = state_59627__$1;
(statearr_59647_59715[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (36))){
var state_59627__$1 = state_59627;
var statearr_59648_59716 = state_59627__$1;
(statearr_59648_59716[(2)] = null);

(statearr_59648_59716[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (41))){
var inst_59538 = (state_59627[(14)]);
var state_59627__$1 = state_59627;
var statearr_59649_59717 = state_59627__$1;
(statearr_59649_59717[(2)] = inst_59538);

(statearr_59649_59717[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (43))){
var inst_59613 = (state_59627[(15)]);
var inst_59619 = (state_59627[(2)]);
var inst_59620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59621 = [inst_59613,inst_59619];
var inst_59622 = (new cljs.core.PersistentVector(null,2,(5),inst_59620,inst_59621,null));
var _ = (function (){var statearr_59650 = state_59627;
(statearr_59650[(4)] = cljs.core.rest((state_59627[(4)])));

return statearr_59650;
})();
var state_59627__$1 = state_59627;
var statearr_59651_59718 = state_59627__$1;
(statearr_59651_59718[(2)] = inst_59622);

(statearr_59651_59718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (29))){
var inst_59513 = (state_59627[(18)]);
var inst_59568 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59513], 0));
var inst_59569 = ["Invalid block range provided: ",inst_59568].join('');
var inst_59570 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59571 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59572 = cljs.core.PersistentHashMap.fromArrays(inst_59570,inst_59571);
var inst_59573 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59569,inst_59572);
var inst_59574 = (function(){throw inst_59573})();
var state_59627__$1 = state_59627;
var statearr_59652_59719 = state_59627__$1;
(statearr_59652_59719[(2)] = inst_59574);

(statearr_59652_59719[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (6))){
var inst_59505 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_59627__$1 = state_59627;
var statearr_59653_59720 = state_59627__$1;
(statearr_59653_59720[(2)] = inst_59505);

(statearr_59653_59720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (28))){
var inst_59579 = (state_59627[(2)]);
var state_59627__$1 = state_59627;
var statearr_59654_59721 = state_59627__$1;
(statearr_59654_59721[(2)] = inst_59579);

(statearr_59654_59721[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (25))){
var inst_59584 = (state_59627[(16)]);
var inst_59582 = (state_59627[(10)]);
var inst_59581 = (state_59627[(2)]);
var inst_59582__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59581,(0),null);
var inst_59583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59581,(1),null);
var inst_59584__$1 = cljs.core.pos_int_QMARK_(inst_59582__$1);
var state_59627__$1 = (function (){var statearr_59655 = state_59627;
(statearr_59655[(16)] = inst_59584__$1);

(statearr_59655[(9)] = inst_59583);

(statearr_59655[(10)] = inst_59582__$1);

return statearr_59655;
})();
if(inst_59584__$1){
var statearr_59656_59722 = state_59627__$1;
(statearr_59656_59722[(1)] = (32));

} else {
var statearr_59657_59723 = state_59627__$1;
(statearr_59657_59723[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (34))){
var inst_59589 = (state_59627[(2)]);
var inst_59590 = cljs.core.not(inst_59589);
var state_59627__$1 = state_59627;
if(inst_59590){
var statearr_59658_59724 = state_59627__$1;
(statearr_59658_59724[(1)] = (35));

} else {
var statearr_59659_59725 = state_59627__$1;
(statearr_59659_59725[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (17))){
var inst_59538 = (state_59627[(14)]);
var inst_59536 = (state_59627[(8)]);
var inst_59541 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59536], 0));
var inst_59542 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59538], 0));
var inst_59543 = ["Start block is out of range for this ledger. Start block provided: ",inst_59541,". Database block: ",inst_59542].join('');
var inst_59544 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59545 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59546 = cljs.core.PersistentHashMap.fromArrays(inst_59544,inst_59545);
var inst_59547 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59543,inst_59546);
var inst_59548 = (function(){throw inst_59547})();
var state_59627__$1 = state_59627;
var statearr_59660_59726 = state_59627__$1;
(statearr_59660_59726[(2)] = inst_59548);

(statearr_59660_59726[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (3))){
var inst_59625 = (state_59627[(2)]);
var state_59627__$1 = state_59627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59627__$1,inst_59625);
} else {
if((state_val_59628 === (12))){
var inst_59522 = (state_59627[(17)]);
var inst_59513 = (state_59627[(18)]);
var inst_59520 = (state_59627[(2)]);
var inst_59521 = fluree.db.util.async.throw_err(inst_59520);
var inst_59522__$1 = cljs.core.second(inst_59513);
var state_59627__$1 = (function (){var statearr_59661 = state_59627;
(statearr_59661[(12)] = inst_59521);

(statearr_59661[(17)] = inst_59522__$1);

return statearr_59661;
})();
if(cljs.core.truth_(inst_59522__$1)){
var statearr_59662_59727 = state_59627__$1;
(statearr_59662_59727[(1)] = (13));

} else {
var statearr_59663_59728 = state_59627__$1;
(statearr_59663_59728[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (2))){
var _ = (function (){var statearr_59664 = state_59627;
(statearr_59664[(4)] = cljs.core.cons((5),(state_59627[(4)])));

return statearr_59664;
})();
var inst_59502 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59503 = cljs.core.sequential_QMARK_(inst_59502);
var state_59627__$1 = state_59627;
if(inst_59503){
var statearr_59665_59729 = state_59627__$1;
(statearr_59665_59729[(1)] = (6));

} else {
var statearr_59666_59730 = state_59627__$1;
(statearr_59666_59730[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (23))){
var inst_59537 = (state_59627[(7)]);
var inst_59536 = (state_59627[(8)]);
var inst_59557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59558 = [inst_59536,inst_59537];
var inst_59559 = (new cljs.core.PersistentVector(null,2,(5),inst_59557,inst_59558,null));
var state_59627__$1 = state_59627;
var statearr_59667_59731 = state_59627__$1;
(statearr_59667_59731[(2)] = inst_59559);

(statearr_59667_59731[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (35))){
var inst_59513 = (state_59627[(18)]);
var inst_59592 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59513], 0));
var inst_59593 = ["Invalid block range provided: ",inst_59592].join('');
var inst_59594 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59595 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59596 = cljs.core.PersistentHashMap.fromArrays(inst_59594,inst_59595);
var inst_59597 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59593,inst_59596);
var inst_59598 = (function(){throw inst_59597})();
var state_59627__$1 = state_59627;
var statearr_59668_59732 = state_59627__$1;
(statearr_59668_59732[(2)] = inst_59598);

(statearr_59668_59732[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (19))){
var inst_59536 = (state_59627[(8)]);
var inst_59551 = (state_59627[(2)]);
var state_59627__$1 = (function (){var statearr_59669 = state_59627;
(statearr_59669[(19)] = inst_59551);

return statearr_59669;
})();
if(cljs.core.truth_(inst_59536)){
var statearr_59670_59733 = state_59627__$1;
(statearr_59670_59733[(1)] = (20));

} else {
var statearr_59671_59734 = state_59627__$1;
(statearr_59671_59734[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (11))){
var inst_59538 = (state_59627[(14)]);
var inst_59536 = (state_59627[(8)]);
var inst_59535 = (state_59627[(2)]);
var inst_59536__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59535,(0),null);
var inst_59537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59535,(1),null);
var inst_59538__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59539 = (inst_59536__$1 > inst_59538__$1);
var state_59627__$1 = (function (){var statearr_59673 = state_59627;
(statearr_59673[(7)] = inst_59537);

(statearr_59673[(14)] = inst_59538__$1);

(statearr_59673[(8)] = inst_59536__$1);

return statearr_59673;
})();
if(cljs.core.truth_(inst_59539)){
var statearr_59674_59735 = state_59627__$1;
(statearr_59674_59735[(1)] = (17));

} else {
var statearr_59675_59736 = state_59627__$1;
(statearr_59675_59736[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (9))){
var inst_59513 = (state_59627[(18)]);
var inst_59516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59517 = cljs.core.first(inst_59513);
var inst_59518 = fluree.db.time_travel.block_to_int_format(db,inst_59517);
var state_59627__$1 = (function (){var statearr_59676 = state_59627;
(statearr_59676[(11)] = inst_59516);

return statearr_59676;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59627__$1,(12),inst_59518);
} else {
if((state_val_59628 === (5))){
var _ = (function (){var statearr_59677 = state_59627;
(statearr_59677[(4)] = cljs.core.rest((state_59627[(4)])));

return statearr_59677;
})();
var state_59627__$1 = state_59627;
var ex59672 = (state_59627__$1[(2)]);
var statearr_59678_59737 = state_59627__$1;
(statearr_59678_59737[(5)] = ex59672);


if((ex59672 instanceof Error)){
var statearr_59679_59738 = state_59627__$1;
(statearr_59679_59738[(1)] = (4));

(statearr_59679_59738[(5)] = null);

} else {
throw ex59672;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (14))){
var state_59627__$1 = state_59627;
var statearr_59680_59739 = state_59627__$1;
(statearr_59680_59739[(2)] = null);

(statearr_59680_59739[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (26))){
var inst_59536 = (state_59627[(8)]);
var inst_59562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59563 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59564 = [inst_59536,inst_59563];
var inst_59565 = (new cljs.core.PersistentVector(null,2,(5),inst_59562,inst_59564,null));
var state_59627__$1 = state_59627;
var statearr_59681_59740 = state_59627__$1;
(statearr_59681_59740[(2)] = inst_59565);

(statearr_59681_59740[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (16))){
var inst_59526 = (state_59627[(2)]);
var inst_59527 = fluree.db.util.async.throw_err(inst_59526);
var state_59627__$1 = state_59627;
var statearr_59682_59741 = state_59627__$1;
(statearr_59682_59741[(2)] = inst_59527);

(statearr_59682_59741[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (38))){
var inst_59583 = (state_59627[(9)]);
var inst_59582 = (state_59627[(10)]);
var inst_59604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59605 = [inst_59583,inst_59582];
var inst_59606 = (new cljs.core.PersistentVector(null,2,(5),inst_59604,inst_59605,null));
var state_59627__$1 = state_59627;
var statearr_59683_59742 = state_59627__$1;
(statearr_59683_59742[(2)] = inst_59606);

(statearr_59683_59742[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (30))){
var state_59627__$1 = state_59627;
var statearr_59684_59743 = state_59627__$1;
(statearr_59684_59743[(2)] = null);

(statearr_59684_59743[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (10))){
var inst_59513 = (state_59627[(18)]);
var state_59627__$1 = state_59627;
var statearr_59685_59744 = state_59627__$1;
(statearr_59685_59744[(2)] = inst_59513);

(statearr_59685_59744[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (18))){
var state_59627__$1 = state_59627;
var statearr_59686_59745 = state_59627__$1;
(statearr_59686_59745[(2)] = null);

(statearr_59686_59745[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (42))){
var inst_59614 = (state_59627[(13)]);
var state_59627__$1 = state_59627;
var statearr_59687_59746 = state_59627__$1;
(statearr_59687_59746[(2)] = inst_59614);

(statearr_59687_59746[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (37))){
var inst_59583 = (state_59627[(9)]);
var inst_59582 = (state_59627[(10)]);
var inst_59601 = (state_59627[(2)]);
var inst_59602 = (inst_59583 < inst_59582);
var state_59627__$1 = (function (){var statearr_59688 = state_59627;
(statearr_59688[(20)] = inst_59601);

return statearr_59688;
})();
if(cljs.core.truth_(inst_59602)){
var statearr_59689_59747 = state_59627__$1;
(statearr_59689_59747[(1)] = (38));

} else {
var statearr_59690_59748 = state_59627__$1;
(statearr_59690_59748[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59628 === (8))){
var inst_59513 = (state_59627[(18)]);
var inst_59513__$1 = (state_59627[(2)]);
var inst_59514 = cljs.core.some(cljs.core.string_QMARK_,inst_59513__$1);
var state_59627__$1 = (function (){var statearr_59691 = state_59627;
(statearr_59691[(18)] = inst_59513__$1);

return statearr_59691;
})();
if(cljs.core.truth_(inst_59514)){
var statearr_59692_59749 = state_59627__$1;
(statearr_59692_59749[(1)] = (9));

} else {
var statearr_59693_59750 = state_59627__$1;
(statearr_59693_59750[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto____0 = (function (){
var statearr_59694 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59694[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto__);

(statearr_59694[(1)] = (1));

return statearr_59694;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto____1 = (function (state_59627){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_59627);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e59695){var ex__2744__auto__ = e59695;
var statearr_59696_59751 = state_59627;
(statearr_59696_59751[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_59627[(4)]))){
var statearr_59697_59752 = state_59627;
(statearr_59697_59752[(1)] = cljs.core.first((state_59627[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59753 = state_59627;
state_59627 = G__59753;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto__ = function(state_59627){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto____1.call(this,state_59627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_59698 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_59698[(6)] = c__2763__auto__);

return statearr_59698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_59903){
var state_val_59904 = (state_59903[(1)]);
if((state_val_59904 === (7))){
var inst_59815 = (state_59903[(2)]);
var inst_59816 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59815,(0),null);
var inst_59817 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59815,(1),null);
var inst_59825 = cljs.core.vals(inst_59817);
var inst_59826 = cljs.core.seq(inst_59825);
var inst_59827 = cljs.core.first(inst_59826);
var inst_59828 = cljs.core.next(inst_59826);
var inst_59829 = cljs.core.PersistentVector.EMPTY;
var inst_59830 = inst_59825;
var inst_59831 = inst_59829;
var state_59903__$1 = (function (){var statearr_59905 = state_59903;
(statearr_59905[(7)] = inst_59831);

(statearr_59905[(8)] = inst_59828);

(statearr_59905[(9)] = inst_59830);

(statearr_59905[(10)] = inst_59816);

(statearr_59905[(11)] = inst_59827);

return statearr_59905;
})();
var statearr_59906_59959 = state_59903__$1;
(statearr_59906_59959[(2)] = null);

(statearr_59906_59959[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (20))){
var inst_59837 = (state_59903[(12)]);
var inst_59842 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59843 = cljs.core.PersistentHashMap.EMPTY;
var inst_59844 = [true,inst_59843];
var inst_59845 = cljs.core.PersistentHashMap.fromArrays(inst_59842,inst_59844);
var inst_59846 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_59845,inst_59837);
var state_59903__$1 = state_59903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59903__$1,(22),inst_59846);
} else {
if((state_val_59904 === (27))){
var inst_59891 = (state_59903[(2)]);
var state_59903__$1 = state_59903;
var statearr_59907_59960 = state_59903__$1;
(statearr_59907_59960[(2)] = inst_59891);

(statearr_59907_59960[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (1))){
var state_59903__$1 = state_59903;
var statearr_59908_59961 = state_59903__$1;
(statearr_59908_59961[(2)] = null);

(statearr_59908_59961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (24))){
var inst_59855 = (state_59903[(13)]);
var inst_59893 = (state_59903[(2)]);
var inst_59894 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_59895 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59896 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59897 = [inst_59895,inst_59896,inst_59855,inst_59893];
var inst_59898 = cljs.core.PersistentHashMap.fromArrays(inst_59894,inst_59897);
var _ = (function (){var statearr_59910 = state_59903;
(statearr_59910[(4)] = cljs.core.rest((state_59903[(4)])));

return statearr_59910;
})();
var state_59903__$1 = state_59903;
var statearr_59911_59962 = state_59903__$1;
(statearr_59911_59962[(2)] = inst_59898);

(statearr_59911_59962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (4))){
var inst_59756 = (state_59903[(2)]);
var state_59903__$1 = state_59903;
var statearr_59912_59963 = state_59903__$1;
(statearr_59912_59963[(2)] = inst_59756);

(statearr_59912_59963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (15))){
var inst_59780 = (state_59903[(14)]);
var inst_59801 = (state_59903[(15)]);
var inst_59796 = (state_59903[(16)]);
var inst_59779 = (state_59903[(17)]);
var inst_59772 = (state_59903[(18)]);
var inst_59794 = (state_59903[(19)]);
var inst_59787 = (state_59903[(20)]);
var inst_59774 = (state_59903[(21)]);
var inst_59775 = (state_59903[(22)]);
var inst_59786 = (state_59903[(23)]);
var inst_59778 = (state_59903[(24)]);
var inst_59807 = (function (){var subject = inst_59794;
var flake = inst_59786;
var vec__59769 = inst_59772;
var r = inst_59787;
var seq__59770 = inst_59775;
var asserted_subjects = inst_59779;
var flake_SINGLEQUOTE_ = inst_59801;
var retracted_subjects = inst_59780;
var seq__59783 = inst_59787;
var asserted_QMARK_ = inst_59796;
var first__59784 = inst_59786;
var vec__59782 = inst_59778;
var first__59771 = inst_59774;
var G__59768 = inst_59778;
return (function (p1__59755_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__59755_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59808 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_59780,inst_59794,inst_59807);
var tmp59909 = inst_59779;
var inst_59778__$1 = inst_59787;
var inst_59779__$1 = tmp59909;
var inst_59780__$1 = inst_59808;
var state_59903__$1 = (function (){var statearr_59913 = state_59903;
(statearr_59913[(14)] = inst_59780__$1);

(statearr_59913[(17)] = inst_59779__$1);

(statearr_59913[(24)] = inst_59778__$1);

return statearr_59913;
})();
var statearr_59914_59964 = state_59903__$1;
(statearr_59914_59964[(2)] = null);

(statearr_59914_59964[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (21))){
var inst_59853 = (state_59903[(2)]);
var state_59903__$1 = state_59903;
var statearr_59915_59965 = state_59903__$1;
(statearr_59915_59965[(2)] = inst_59853);

(statearr_59915_59965[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (13))){
var inst_59796 = (state_59903[(16)]);
var inst_59801 = (state_59903[(2)]);
var state_59903__$1 = (function (){var statearr_59916 = state_59903;
(statearr_59916[(15)] = inst_59801);

return statearr_59916;
})();
if(cljs.core.truth_(inst_59796)){
var statearr_59917_59966 = state_59903__$1;
(statearr_59917_59966[(1)] = (14));

} else {
var statearr_59918_59967 = state_59903__$1;
(statearr_59918_59967[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (22))){
var inst_59831 = (state_59903[(7)]);
var inst_59838 = (state_59903[(25)]);
var inst_59848 = (state_59903[(2)]);
var inst_59849 = fluree.db.util.async.throw_err(inst_59848);
var inst_59850 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_59831,inst_59849);
var inst_59830 = inst_59838;
var inst_59831__$1 = inst_59850;
var state_59903__$1 = (function (){var statearr_59919 = state_59903;
(statearr_59919[(7)] = inst_59831__$1);

(statearr_59919[(9)] = inst_59830);

return statearr_59919;
})();
var statearr_59920_59968 = state_59903__$1;
(statearr_59920_59968[(2)] = null);

(statearr_59920_59968[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (6))){
var inst_59786 = (state_59903[(23)]);
var inst_59778 = (state_59903[(24)]);
var inst_59785 = cljs.core.seq(inst_59778);
var inst_59786__$1 = cljs.core.first(inst_59785);
var inst_59787 = cljs.core.next(inst_59785);
var inst_59788 = cljs.core.not(inst_59786__$1);
var state_59903__$1 = (function (){var statearr_59921 = state_59903;
(statearr_59921[(20)] = inst_59787);

(statearr_59921[(23)] = inst_59786__$1);

return statearr_59921;
})();
if(inst_59788){
var statearr_59922_59969 = state_59903__$1;
(statearr_59922_59969[(1)] = (8));

} else {
var statearr_59923_59970 = state_59903__$1;
(statearr_59923_59970[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (28))){
var inst_59869 = (state_59903[(26)]);
var inst_59876 = (state_59903[(27)]);
var inst_59886 = (state_59903[(2)]);
var inst_59887 = fluree.db.util.async.throw_err(inst_59886);
var inst_59888 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_59869,inst_59887);
var inst_59868 = inst_59876;
var inst_59869__$1 = inst_59888;
var state_59903__$1 = (function (){var statearr_59924 = state_59903;
(statearr_59924[(26)] = inst_59869__$1);

(statearr_59924[(28)] = inst_59868);

return statearr_59924;
})();
var statearr_59925_59971 = state_59903__$1;
(statearr_59925_59971[(2)] = null);

(statearr_59925_59971[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (25))){
var inst_59869 = (state_59903[(26)]);
var state_59903__$1 = state_59903;
var statearr_59926_59972 = state_59903__$1;
(statearr_59926_59972[(2)] = inst_59869);

(statearr_59926_59972[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (17))){
var inst_59837 = (state_59903[(12)]);
var inst_59830 = (state_59903[(9)]);
var inst_59836 = cljs.core.seq(inst_59830);
var inst_59837__$1 = cljs.core.first(inst_59836);
var inst_59838 = cljs.core.next(inst_59836);
var inst_59839 = cljs.core.not(inst_59837__$1);
var state_59903__$1 = (function (){var statearr_59927 = state_59903;
(statearr_59927[(12)] = inst_59837__$1);

(statearr_59927[(25)] = inst_59838);

return statearr_59927;
})();
if(inst_59839){
var statearr_59928_59973 = state_59903__$1;
(statearr_59928_59973[(1)] = (19));

} else {
var statearr_59929_59974 = state_59903__$1;
(statearr_59929_59974[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (3))){
var inst_59901 = (state_59903[(2)]);
var state_59903__$1 = state_59903;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59903__$1,inst_59901);
} else {
if((state_val_59904 === (12))){
var inst_59786 = (state_59903[(23)]);
var inst_59799 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_59786);
var state_59903__$1 = state_59903;
var statearr_59930_59975 = state_59903__$1;
(statearr_59930_59975[(2)] = inst_59799);

(statearr_59930_59975[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (2))){
var inst_59772 = (state_59903[(18)]);
var _ = (function (){var statearr_59931 = state_59903;
(statearr_59931[(4)] = cljs.core.cons((5),(state_59903[(4)])));

return statearr_59931;
})();
var inst_59772__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59773 = cljs.core.seq(inst_59772__$1);
var inst_59774 = cljs.core.first(inst_59773);
var inst_59775 = cljs.core.next(inst_59773);
var inst_59776 = cljs.core.PersistentHashMap.EMPTY;
var inst_59777 = cljs.core.PersistentHashMap.EMPTY;
var inst_59778 = inst_59772__$1;
var inst_59779 = inst_59776;
var inst_59780 = inst_59777;
var state_59903__$1 = (function (){var statearr_59932 = state_59903;
(statearr_59932[(14)] = inst_59780);

(statearr_59932[(17)] = inst_59779);

(statearr_59932[(18)] = inst_59772__$1);

(statearr_59932[(21)] = inst_59774);

(statearr_59932[(22)] = inst_59775);

(statearr_59932[(24)] = inst_59778);

return statearr_59932;
})();
var statearr_59933_59976 = state_59903__$1;
(statearr_59933_59976[(2)] = null);

(statearr_59933_59976[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (23))){
var inst_59868 = (state_59903[(28)]);
var inst_59875 = (state_59903[(29)]);
var inst_59874 = cljs.core.seq(inst_59868);
var inst_59875__$1 = cljs.core.first(inst_59874);
var inst_59876 = cljs.core.next(inst_59874);
var inst_59877 = cljs.core.not(inst_59875__$1);
var state_59903__$1 = (function (){var statearr_59934 = state_59903;
(statearr_59934[(27)] = inst_59876);

(statearr_59934[(29)] = inst_59875__$1);

return statearr_59934;
})();
if(inst_59877){
var statearr_59935_59977 = state_59903__$1;
(statearr_59935_59977[(1)] = (25));

} else {
var statearr_59936_59978 = state_59903__$1;
(statearr_59936_59978[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (19))){
var inst_59831 = (state_59903[(7)]);
var state_59903__$1 = state_59903;
var statearr_59937_59979 = state_59903__$1;
(statearr_59937_59979[(2)] = inst_59831);

(statearr_59937_59979[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (11))){
var inst_59786 = (state_59903[(23)]);
var state_59903__$1 = state_59903;
var statearr_59939_59980 = state_59903__$1;
(statearr_59939_59980[(2)] = inst_59786);

(statearr_59939_59980[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (9))){
var inst_59796 = (state_59903[(16)]);
var inst_59786 = (state_59903[(23)]);
var inst_59794 = inst_59786.s;
var inst_59795 = inst_59786.op;
var inst_59796__$1 = inst_59795 === true;
var state_59903__$1 = (function (){var statearr_59941 = state_59903;
(statearr_59941[(16)] = inst_59796__$1);

(statearr_59941[(19)] = inst_59794);

return statearr_59941;
})();
if(cljs.core.truth_(inst_59796__$1)){
var statearr_59942_59981 = state_59903__$1;
(statearr_59942_59981[(1)] = (11));

} else {
var statearr_59943_59982 = state_59903__$1;
(statearr_59943_59982[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (5))){
var _ = (function (){var statearr_59944 = state_59903;
(statearr_59944[(4)] = cljs.core.rest((state_59903[(4)])));

return statearr_59944;
})();
var state_59903__$1 = state_59903;
var ex59938 = (state_59903__$1[(2)]);
var statearr_59945_59983 = state_59903__$1;
(statearr_59945_59983[(5)] = ex59938);


if((ex59938 instanceof Error)){
var statearr_59946_59984 = state_59903__$1;
(statearr_59946_59984[(1)] = (4));

(statearr_59946_59984[(5)] = null);

} else {
throw ex59938;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (14))){
var inst_59780 = (state_59903[(14)]);
var inst_59801 = (state_59903[(15)]);
var inst_59796 = (state_59903[(16)]);
var inst_59779 = (state_59903[(17)]);
var inst_59772 = (state_59903[(18)]);
var inst_59794 = (state_59903[(19)]);
var inst_59787 = (state_59903[(20)]);
var inst_59774 = (state_59903[(21)]);
var inst_59775 = (state_59903[(22)]);
var inst_59786 = (state_59903[(23)]);
var inst_59778 = (state_59903[(24)]);
var inst_59803 = (function (){var subject = inst_59794;
var flake = inst_59786;
var vec__59769 = inst_59772;
var r = inst_59787;
var seq__59770 = inst_59775;
var asserted_subjects = inst_59779;
var flake_SINGLEQUOTE_ = inst_59801;
var retracted_subjects = inst_59780;
var seq__59783 = inst_59787;
var asserted_QMARK_ = inst_59796;
var first__59784 = inst_59786;
var vec__59782 = inst_59778;
var first__59771 = inst_59774;
var G__59768 = inst_59778;
return (function (p1__59754_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__59754_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59804 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_59779,inst_59794,inst_59803);
var tmp59940 = inst_59780;
var inst_59778__$1 = inst_59787;
var inst_59779__$1 = inst_59804;
var inst_59780__$1 = tmp59940;
var state_59903__$1 = (function (){var statearr_59947 = state_59903;
(statearr_59947[(14)] = inst_59780__$1);

(statearr_59947[(17)] = inst_59779__$1);

(statearr_59947[(24)] = inst_59778__$1);

return statearr_59947;
})();
var statearr_59948_59985 = state_59903__$1;
(statearr_59948_59985[(2)] = null);

(statearr_59948_59985[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (26))){
var inst_59875 = (state_59903[(29)]);
var inst_59880 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59881 = cljs.core.PersistentHashMap.EMPTY;
var inst_59882 = [true,inst_59881];
var inst_59883 = cljs.core.PersistentHashMap.fromArrays(inst_59880,inst_59882);
var inst_59884 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_59883,inst_59875);
var state_59903__$1 = state_59903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59903__$1,(28),inst_59884);
} else {
if((state_val_59904 === (16))){
var inst_59811 = (state_59903[(2)]);
var state_59903__$1 = state_59903;
var statearr_59949_59986 = state_59903__$1;
(statearr_59949_59986[(2)] = inst_59811);

(statearr_59949_59986[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (10))){
var inst_59813 = (state_59903[(2)]);
var state_59903__$1 = state_59903;
var statearr_59950_59987 = state_59903__$1;
(statearr_59950_59987[(2)] = inst_59813);

(statearr_59950_59987[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (18))){
var inst_59816 = (state_59903[(10)]);
var inst_59855 = (state_59903[(2)]);
var inst_59863 = cljs.core.vals(inst_59816);
var inst_59864 = cljs.core.seq(inst_59863);
var inst_59865 = cljs.core.first(inst_59864);
var inst_59866 = cljs.core.next(inst_59864);
var inst_59867 = cljs.core.PersistentVector.EMPTY;
var inst_59868 = inst_59863;
var inst_59869 = inst_59867;
var state_59903__$1 = (function (){var statearr_59951 = state_59903;
(statearr_59951[(26)] = inst_59869);

(statearr_59951[(28)] = inst_59868);

(statearr_59951[(30)] = inst_59865);

(statearr_59951[(31)] = inst_59866);

(statearr_59951[(13)] = inst_59855);

return statearr_59951;
})();
var statearr_59952_59988 = state_59903__$1;
(statearr_59952_59988[(2)] = null);

(statearr_59952_59988[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59904 === (8))){
var inst_59780 = (state_59903[(14)]);
var inst_59779 = (state_59903[(17)]);
var inst_59790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59791 = [inst_59779,inst_59780];
var inst_59792 = (new cljs.core.PersistentVector(null,2,(5),inst_59790,inst_59791,null));
var state_59903__$1 = state_59903;
var statearr_59953_59989 = state_59903__$1;
(statearr_59953_59989[(2)] = inst_59792);

(statearr_59953_59989[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto____0 = (function (){
var statearr_59954 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59954[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto__);

(statearr_59954[(1)] = (1));

return statearr_59954;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto____1 = (function (state_59903){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_59903);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e59955){var ex__2744__auto__ = e59955;
var statearr_59956_59990 = state_59903;
(statearr_59956_59990[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_59903[(4)]))){
var statearr_59957_59991 = state_59903;
(statearr_59957_59991[(1)] = cljs.core.first((state_59903[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59992 = state_59903;
state_59903 = G__59992;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto__ = function(state_59903){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto____1.call(this,state_59903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_59958 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_59958[(6)] = c__2763__auto__);

return statearr_59958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_60024){
var state_val_60025 = (state_60024[(1)]);
if((state_val_60025 === (1))){
var inst_59993 = cljs.core.volatile_BANG_((0));
var inst_59994 = cljs.core.PersistentHashMap.EMPTY;
var inst_59995 = cljs.core.volatile_BANG_(inst_59994);
var inst_59996 = cljs.core.first(resp);
var inst_59997 = cljs.core.rest(resp);
var inst_59998 = cljs.core.PersistentVector.EMPTY;
var inst_59999 = inst_59993;
var inst_60000 = inst_59995;
var inst_60001 = inst_59996;
var inst_60002 = inst_59997;
var inst_60003 = inst_59998;
var state_60024__$1 = (function (){var statearr_60026 = state_60024;
(statearr_60026[(7)] = inst_60000);

(statearr_60026[(8)] = inst_60002);

(statearr_60026[(9)] = inst_59999);

(statearr_60026[(10)] = inst_60003);

(statearr_60026[(11)] = inst_60001);

return statearr_60026;
})();
var statearr_60027_60042 = state_60024__$1;
(statearr_60027_60042[(2)] = null);

(statearr_60027_60042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60025 === (2))){
var inst_60000 = (state_60024[(7)]);
var inst_59999 = (state_60024[(9)]);
var inst_60001 = (state_60024[(11)]);
var inst_60005 = fluree.db.api.query.format_block_resp_pretty(db,inst_60001,inst_60000,inst_59999);
var state_60024__$1 = state_60024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60024__$1,(4),inst_60005);
} else {
if((state_val_60025 === (3))){
var inst_60022 = (state_60024[(2)]);
var state_60024__$1 = state_60024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60024__$1,inst_60022);
} else {
if((state_val_60025 === (4))){
var inst_60002 = (state_60024[(8)]);
var inst_60003 = (state_60024[(10)]);
var inst_60007 = (state_60024[(2)]);
var inst_60008 = fluree.db.util.async.throw_err(inst_60007);
var inst_60009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60010 = [inst_60008];
var inst_60011 = (new cljs.core.PersistentVector(null,1,(5),inst_60009,inst_60010,null));
var inst_60012 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_60003,inst_60011);
var inst_60013 = cljs.core.first(inst_60002);
var state_60024__$1 = (function (){var statearr_60030 = state_60024;
(statearr_60030[(12)] = inst_60012);

return statearr_60030;
})();
if(cljs.core.truth_(inst_60013)){
var statearr_60031_60043 = state_60024__$1;
(statearr_60031_60043[(1)] = (5));

} else {
var statearr_60032_60044 = state_60024__$1;
(statearr_60032_60044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60025 === (5))){
var inst_60000 = (state_60024[(7)]);
var inst_60002 = (state_60024[(8)]);
var inst_59999 = (state_60024[(9)]);
var inst_60012 = (state_60024[(12)]);
var inst_60015 = cljs.core.first(inst_60002);
var inst_60016 = cljs.core.rest(inst_60002);
var tmp60028 = inst_60000;
var tmp60029 = inst_59999;
var inst_59999__$1 = tmp60029;
var inst_60000__$1 = tmp60028;
var inst_60001 = inst_60015;
var inst_60002__$1 = inst_60016;
var inst_60003 = inst_60012;
var state_60024__$1 = (function (){var statearr_60033 = state_60024;
(statearr_60033[(7)] = inst_60000__$1);

(statearr_60033[(8)] = inst_60002__$1);

(statearr_60033[(9)] = inst_59999__$1);

(statearr_60033[(10)] = inst_60003);

(statearr_60033[(11)] = inst_60001);

return statearr_60033;
})();
var statearr_60034_60045 = state_60024__$1;
(statearr_60034_60045[(2)] = null);

(statearr_60034_60045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60025 === (6))){
var inst_60012 = (state_60024[(12)]);
var state_60024__$1 = state_60024;
var statearr_60035_60046 = state_60024__$1;
(statearr_60035_60046[(2)] = inst_60012);

(statearr_60035_60046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60025 === (7))){
var inst_60020 = (state_60024[(2)]);
var state_60024__$1 = state_60024;
var statearr_60036_60047 = state_60024__$1;
(statearr_60036_60047[(2)] = inst_60020);

(statearr_60036_60047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto____0 = (function (){
var statearr_60037 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60037[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto__);

(statearr_60037[(1)] = (1));

return statearr_60037;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto____1 = (function (state_60024){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_60024);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e60038){var ex__2744__auto__ = e60038;
var statearr_60039_60048 = state_60024;
(statearr_60039_60048[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_60024[(4)]))){
var statearr_60040_60049 = state_60024;
(statearr_60040_60049[(1)] = cljs.core.first((state_60024[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60050 = state_60024;
state_60024 = G__60050;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto__ = function(state_60024){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto____1.call(this,state_60024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_60041 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_60041[(6)] = c__2763__auto__);

return statearr_60041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__60052 = arguments.length;
switch (G__60052) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__60054){
var map__60055 = p__60054;
var map__60055__$1 = cljs.core.__destructure_map(map__60055);
var query = map__60055__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60055__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_60140){
var state_val_60141 = (state_60140[(1)]);
if((state_val_60141 === (7))){
var inst_60066 = (state_60140[(7)]);
var inst_60070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60071 = ["_auth/id",inst_60066];
var inst_60072 = (new cljs.core.PersistentVector(null,2,(5),inst_60070,inst_60071,null));
var state_60140__$1 = state_60140;
var statearr_60142_60186 = state_60140__$1;
(statearr_60142_60186[(2)] = inst_60072);

(statearr_60142_60186[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (20))){
var inst_60120 = (state_60140[(2)]);
var inst_60121 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_60140__$1 = (function (){var statearr_60143 = state_60140;
(statearr_60143[(8)] = inst_60120);

return statearr_60143;
})();
if(cljs.core.truth_(inst_60121)){
var statearr_60144_60187 = state_60140__$1;
(statearr_60144_60187[(1)] = (22));

} else {
var statearr_60145_60188 = state_60140__$1;
(statearr_60145_60188[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (27))){
var inst_60123 = (state_60140[(9)]);
var inst_60067 = (state_60140[(10)]);
var inst_60129 = (state_60140[(2)]);
var inst_60130 = fluree.db.util.core.response_time_formatted(inst_60067);
var inst_60131 = [(200),inst_60129,(100),inst_60130];
var inst_60132 = cljs.core.PersistentHashMap.fromArrays(inst_60123,inst_60131);
var state_60140__$1 = state_60140;
var statearr_60146_60189 = state_60140__$1;
(statearr_60146_60189[(2)] = inst_60132);

(statearr_60146_60189[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (1))){
var state_60140__$1 = state_60140;
var statearr_60147_60190 = state_60140__$1;
(statearr_60147_60190[(2)] = null);

(statearr_60147_60190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (24))){
var inst_60135 = (state_60140[(2)]);
var _ = (function (){var statearr_60148 = state_60140;
(statearr_60148[(4)] = cljs.core.rest((state_60140[(4)])));

return statearr_60148;
})();
var state_60140__$1 = state_60140;
var statearr_60149_60191 = state_60140__$1;
(statearr_60149_60191[(2)] = inst_60135);

(statearr_60149_60191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (4))){
var inst_60056 = (state_60140[(2)]);
var state_60140__$1 = state_60140;
var statearr_60150_60192 = state_60140__$1;
(statearr_60150_60192[(2)] = inst_60056);

(statearr_60150_60192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (15))){
var inst_60107 = (state_60140[(11)]);
var state_60140__$1 = state_60140;
var statearr_60151_60193 = state_60140__$1;
(statearr_60151_60193[(2)] = inst_60107);

(statearr_60151_60193[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (21))){
var inst_60116 = (state_60140[(2)]);
var inst_60117 = fluree.db.util.async.throw_err(inst_60116);
var state_60140__$1 = state_60140;
var statearr_60152_60194 = state_60140__$1;
(statearr_60152_60194[(2)] = inst_60117);

(statearr_60152_60194[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (13))){
var inst_60065 = (state_60140[(12)]);
var inst_60107 = (state_60140[(11)]);
var inst_60106 = (state_60140[(2)]);
var inst_60107__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_60065);
var state_60140__$1 = (function (){var statearr_60153 = state_60140;
(statearr_60153[(11)] = inst_60107__$1);

(statearr_60153[(13)] = inst_60106);

return statearr_60153;
})();
if(cljs.core.truth_(inst_60107__$1)){
var statearr_60154_60195 = state_60140__$1;
(statearr_60154_60195[(1)] = (15));

} else {
var statearr_60155_60196 = state_60140__$1;
(statearr_60155_60196[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (22))){
var inst_60120 = (state_60140[(8)]);
var inst_60123 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_60124 = cljs.core.sequential_QMARK_(inst_60120);
var state_60140__$1 = (function (){var statearr_60156 = state_60140;
(statearr_60156[(9)] = inst_60123);

return statearr_60156;
})();
if(inst_60124){
var statearr_60157_60197 = state_60140__$1;
(statearr_60157_60197[(1)] = (25));

} else {
var statearr_60158_60198 = state_60140__$1;
(statearr_60158_60198[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (6))){
var inst_60081 = (state_60140[(14)]);
var inst_60065 = (state_60140[(12)]);
var inst_60080 = (state_60140[(2)]);
var inst_60081__$1 = fluree.db.util.async.throw_err(inst_60080);
var inst_60082 = fluree.db.api.query.resolve_block_range(inst_60081__$1,inst_60065);
var state_60140__$1 = (function (){var statearr_60159 = state_60140;
(statearr_60159[(14)] = inst_60081__$1);

return statearr_60159;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60140__$1,(10),inst_60082);
} else {
if((state_val_60141 === (25))){
var inst_60120 = (state_60140[(8)]);
var inst_60126 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_60120);
var state_60140__$1 = state_60140;
var statearr_60160_60199 = state_60140__$1;
(statearr_60160_60199[(2)] = inst_60126);

(statearr_60160_60199[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (17))){
var inst_60112 = (state_60140[(2)]);
var state_60140__$1 = state_60140;
if(cljs.core.truth_(inst_60112)){
var statearr_60161_60200 = state_60140__$1;
(statearr_60161_60200[(1)] = (18));

} else {
var statearr_60162_60201 = state_60140__$1;
(statearr_60162_60201[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (3))){
var inst_60138 = (state_60140[(2)]);
var state_60140__$1 = state_60140;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60140__$1,inst_60138);
} else {
if((state_val_60141 === (12))){
var inst_60065 = (state_60140[(12)]);
var inst_60098 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60065], 0));
var inst_60099 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_60098].join('');
var inst_60100 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60101 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60102 = cljs.core.PersistentHashMap.fromArrays(inst_60100,inst_60101);
var inst_60103 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60099,inst_60102);
var inst_60104 = (function(){throw inst_60103})();
var state_60140__$1 = state_60140;
var statearr_60163_60202 = state_60140__$1;
(statearr_60163_60202[(2)] = inst_60104);

(statearr_60163_60202[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (2))){
var inst_60066 = (state_60140[(7)]);
var _ = (function (){var statearr_60164 = state_60140;
(statearr_60164[(4)] = cljs.core.cons((5),(state_60140[(4)])));

return statearr_60164;
})();
var inst_60065 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60066__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60067 = fluree.db.util.core.current_time_millis();
var inst_60068 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_60140__$1 = (function (){var statearr_60165 = state_60140;
(statearr_60165[(7)] = inst_60066__$1);

(statearr_60165[(10)] = inst_60067);

(statearr_60165[(12)] = inst_60065);

(statearr_60165[(15)] = inst_60068);

return statearr_60165;
})();
if(cljs.core.truth_(inst_60066__$1)){
var statearr_60166_60203 = state_60140__$1;
(statearr_60166_60203[(1)] = (7));

} else {
var statearr_60167_60204 = state_60140__$1;
(statearr_60167_60204[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (23))){
var inst_60120 = (state_60140[(8)]);
var state_60140__$1 = state_60140;
var statearr_60168_60205 = state_60140__$1;
(statearr_60168_60205[(2)] = inst_60120);

(statearr_60168_60205[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (19))){
var inst_60106 = (state_60140[(13)]);
var state_60140__$1 = state_60140;
var statearr_60169_60206 = state_60140__$1;
(statearr_60169_60206[(2)] = inst_60106);

(statearr_60169_60206[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (11))){
var inst_60086 = (state_60140[(16)]);
var inst_60087 = (state_60140[(17)]);
var inst_60081 = (state_60140[(14)]);
var inst_60093 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_60081,inst_60086,inst_60087,opts);
var state_60140__$1 = state_60140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60140__$1,(14),inst_60093);
} else {
if((state_val_60141 === (9))){
var inst_60068 = (state_60140[(15)]);
var inst_60075 = (state_60140[(2)]);
var inst_60076 = [inst_60075];
var inst_60077 = cljs.core.PersistentHashMap.fromArrays(inst_60068,inst_60076);
var inst_60078 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_60077);
var state_60140__$1 = state_60140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60140__$1,(6),inst_60078);
} else {
if((state_val_60141 === (5))){
var _ = (function (){var statearr_60171 = state_60140;
(statearr_60171[(4)] = cljs.core.rest((state_60140[(4)])));

return statearr_60171;
})();
var state_60140__$1 = state_60140;
var ex60170 = (state_60140__$1[(2)]);
var statearr_60172_60207 = state_60140__$1;
(statearr_60172_60207[(5)] = ex60170);


if((ex60170 instanceof Error)){
var statearr_60173_60208 = state_60140__$1;
(statearr_60173_60208[(1)] = (4));

(statearr_60173_60208[(5)] = null);

} else {
throw ex60170;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (14))){
var inst_60095 = (state_60140[(2)]);
var inst_60096 = fluree.db.util.async.throw_err(inst_60095);
var state_60140__$1 = state_60140;
var statearr_60174_60209 = state_60140__$1;
(statearr_60174_60209[(2)] = inst_60096);

(statearr_60174_60209[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (26))){
var inst_60120 = (state_60140[(8)]);
var state_60140__$1 = state_60140;
var statearr_60175_60210 = state_60140__$1;
(statearr_60175_60210[(2)] = inst_60120);

(statearr_60175_60210[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (16))){
var inst_60065 = (state_60140[(12)]);
var inst_60110 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_60065);
var state_60140__$1 = state_60140;
var statearr_60176_60211 = state_60140__$1;
(statearr_60176_60211[(2)] = inst_60110);

(statearr_60176_60211[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (10))){
var inst_60065 = (state_60140[(12)]);
var inst_60084 = (state_60140[(2)]);
var inst_60085 = fluree.db.util.async.throw_err(inst_60084);
var inst_60086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60085,(0),null);
var inst_60087 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60085,(1),null);
var inst_60088 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_60089 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_60065,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_60090 = cljs.core.keys(inst_60089);
var inst_60091 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_60088,inst_60090);
var state_60140__$1 = (function (){var statearr_60177 = state_60140;
(statearr_60177[(16)] = inst_60086);

(statearr_60177[(17)] = inst_60087);

return statearr_60177;
})();
if(inst_60091){
var statearr_60178_60212 = state_60140__$1;
(statearr_60178_60212[(1)] = (11));

} else {
var statearr_60179_60213 = state_60140__$1;
(statearr_60179_60213[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60141 === (18))){
var inst_60081 = (state_60140[(14)]);
var inst_60106 = (state_60140[(13)]);
var inst_60114 = fluree.db.api.query.format_blocks_resp_pretty(inst_60081,inst_60106);
var state_60140__$1 = state_60140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60140__$1,(21),inst_60114);
} else {
if((state_val_60141 === (8))){
var state_60140__$1 = state_60140;
var statearr_60180_60214 = state_60140__$1;
(statearr_60180_60214[(2)] = null);

(statearr_60180_60214[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2741__auto____0 = (function (){
var statearr_60181 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60181[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2741__auto__);

(statearr_60181[(1)] = (1));

return statearr_60181;
});
var fluree$db$api$query$block_query_async_$_state_machine__2741__auto____1 = (function (state_60140){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_60140);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e60182){var ex__2744__auto__ = e60182;
var statearr_60183_60215 = state_60140;
(statearr_60183_60215[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_60140[(4)]))){
var statearr_60184_60216 = state_60140;
(statearr_60184_60216[(1)] = cljs.core.first((state_60140[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60217 = state_60140;
state_60140 = G__60217;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2741__auto__ = function(state_60140){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2741__auto____1.call(this,state_60140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2741__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2741__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_60185 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_60185[(6)] = c__2763__auto__);

return statearr_60185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__60218 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60218,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60218,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60218,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60218,(3),null);
var vec__60221 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60221,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60221,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__60224 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60224,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60224,(1),null);
var or__4253__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___60228 = arguments.length;
var i__4865__auto___60229 = (0);
while(true){
if((i__4865__auto___60229 < len__4864__auto___60228)){
args__4870__auto__.push((arguments[i__4865__auto___60229]));

var G__60230 = (i__4865__auto___60229 + (1));
i__4865__auto___60229 = G__60230;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq60227){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq60227));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_60426){
var state_val_60427 = (state_60426[(1)]);
if((state_val_60427 === (7))){
var inst_60346 = (state_60426[(7)]);
var inst_60353 = (state_60426[(8)]);
var inst_60352 = cljs.core.seq(inst_60346);
var inst_60353__$1 = cljs.core.first(inst_60352);
var inst_60354 = cljs.core.next(inst_60352);
var state_60426__$1 = (function (){var statearr_60428 = state_60426;
(statearr_60428[(9)] = inst_60354);

(statearr_60428[(8)] = inst_60353__$1);

return statearr_60428;
})();
if(cljs.core.truth_(inst_60353__$1)){
var statearr_60429_60529 = state_60426__$1;
(statearr_60429_60529[(1)] = (9));

} else {
var statearr_60430_60530 = state_60426__$1;
(statearr_60430_60530[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (20))){
var inst_60416 = (state_60426[(2)]);
var state_60426__$1 = state_60426;
var statearr_60431_60531 = state_60426__$1;
(statearr_60431_60531[(2)] = inst_60416);

(statearr_60431_60531[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (27))){
var inst_60371 = (state_60426[(10)]);
var inst_60374 = (state_60426[(11)]);
var inst_60392 = (state_60426[(12)]);
var inst_60394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60395 = [inst_60374,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_60396 = (new cljs.core.PersistentVector(null,2,(5),inst_60394,inst_60395,null));
var inst_60397 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_60392,inst_60396,fluree.db.api.query.min_safe,inst_60371);
var state_60426__$1 = state_60426;
var statearr_60432_60532 = state_60426__$1;
(statearr_60432_60532[(2)] = inst_60397);

(statearr_60432_60532[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (1))){
var state_60426__$1 = state_60426;
var statearr_60433_60533 = state_60426__$1;
(statearr_60433_60533[(2)] = null);

(statearr_60433_60533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (24))){
var inst_60374 = (state_60426[(11)]);
var inst_60353 = (state_60426[(8)]);
var inst_60384 = (state_60426[(13)]);
var inst_60386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60387 = [inst_60374,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_60388 = (new cljs.core.PersistentVector(null,2,(5),inst_60386,inst_60387,null));
var inst_60389 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_60384,inst_60388,cljs.core.conj,inst_60353);
var state_60426__$1 = state_60426;
var statearr_60435_60534 = state_60426__$1;
(statearr_60435_60534[(2)] = inst_60389);

(statearr_60435_60534[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (4))){
var inst_60232 = (state_60426[(2)]);
var state_60426__$1 = state_60426;
var statearr_60436_60535 = state_60426__$1;
(statearr_60436_60535[(2)] = inst_60232);

(statearr_60436_60535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (15))){
var inst_60347 = (state_60426[(14)]);
var inst_60354 = (state_60426[(9)]);
var tmp60434 = inst_60347;
var inst_60346 = inst_60354;
var inst_60347__$1 = tmp60434;
var state_60426__$1 = (function (){var statearr_60437 = state_60426;
(statearr_60437[(14)] = inst_60347__$1);

(statearr_60437[(7)] = inst_60346);

return statearr_60437;
})();
var statearr_60438_60536 = state_60426__$1;
(statearr_60438_60536[(2)] = null);

(statearr_60438_60536[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (21))){
var inst_60347 = (state_60426[(14)]);
var inst_60374 = (state_60426[(11)]);
var inst_60378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60379 = [inst_60374,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60380 = (new cljs.core.PersistentVector(null,2,(5),inst_60378,inst_60379,null));
var inst_60381 = cljs.core.assoc_in(inst_60347,inst_60380,inst_60374);
var state_60426__$1 = state_60426;
var statearr_60439_60537 = state_60426__$1;
(statearr_60439_60537[(2)] = inst_60381);

(statearr_60439_60537[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (31))){
var inst_60400 = (state_60426[(15)]);
var state_60426__$1 = state_60426;
var statearr_60440_60538 = state_60426__$1;
(statearr_60440_60538[(2)] = inst_60400);

(statearr_60440_60538[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (32))){
var inst_60354 = (state_60426[(9)]);
var inst_60408 = (state_60426[(2)]);
var inst_60346 = inst_60354;
var inst_60347 = inst_60408;
var state_60426__$1 = (function (){var statearr_60441 = state_60426;
(statearr_60441[(14)] = inst_60347);

(statearr_60441[(7)] = inst_60346);

return statearr_60441;
})();
var statearr_60442_60539 = state_60426__$1;
(statearr_60442_60539[(2)] = null);

(statearr_60442_60539[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (33))){
var inst_60347 = (state_60426[(14)]);
var state_60426__$1 = state_60426;
var statearr_60443_60540 = state_60426__$1;
(statearr_60443_60540[(2)] = inst_60347);

(statearr_60443_60540[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (13))){
var inst_60356 = (state_60426[(16)]);
var state_60426__$1 = state_60426;
var statearr_60444_60541 = state_60426__$1;
(statearr_60444_60541[(2)] = inst_60356);

(statearr_60444_60541[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (22))){
var inst_60347 = (state_60426[(14)]);
var state_60426__$1 = state_60426;
var statearr_60445_60542 = state_60426__$1;
(statearr_60445_60542[(2)] = inst_60347);

(statearr_60445_60542[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (29))){
var inst_60400 = (state_60426[(2)]);
var state_60426__$1 = (function (){var statearr_60446 = state_60426;
(statearr_60446[(15)] = inst_60400);

return statearr_60446;
})();
if(cljs.core.truth_(show_auth)){
var statearr_60447_60543 = state_60426__$1;
(statearr_60447_60543[(1)] = (30));

} else {
var statearr_60448_60544 = state_60426__$1;
(statearr_60448_60544[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (6))){
var inst_60332 = (state_60426[(2)]);
var inst_60333 = fluree.db.util.async.throw_err(inst_60332);
var inst_60341 = resp;
var inst_60342 = cljs.core.seq(inst_60341);
var inst_60343 = cljs.core.first(inst_60342);
var inst_60344 = cljs.core.next(inst_60342);
var inst_60345 = cljs.core.PersistentHashMap.EMPTY;
var inst_60346 = inst_60341;
var inst_60347 = inst_60345;
var state_60426__$1 = (function (){var statearr_60449 = state_60426;
(statearr_60449[(14)] = inst_60347);

(statearr_60449[(17)] = inst_60344);

(statearr_60449[(18)] = inst_60333);

(statearr_60449[(19)] = inst_60343);

(statearr_60449[(7)] = inst_60346);

return statearr_60449;
})();
var statearr_60450_60545 = state_60426__$1;
(statearr_60450_60545[(2)] = null);

(statearr_60450_60545[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (28))){
var inst_60392 = (state_60426[(12)]);
var state_60426__$1 = state_60426;
var statearr_60451_60546 = state_60426__$1;
(statearr_60451_60546[(2)] = inst_60392);

(statearr_60451_60546[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (25))){
var inst_60384 = (state_60426[(13)]);
var state_60426__$1 = state_60426;
var statearr_60452_60547 = state_60426__$1;
(statearr_60452_60547[(2)] = inst_60384);

(statearr_60452_60547[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (34))){
var state_60426__$1 = state_60426;
var statearr_60453_60548 = state_60426__$1;
(statearr_60453_60548[(2)] = null);

(statearr_60453_60548[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (17))){
var inst_60418 = (state_60426[(2)]);
var state_60426__$1 = state_60426;
var statearr_60454_60549 = state_60426__$1;
(statearr_60454_60549[(2)] = inst_60418);

(statearr_60454_60549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (3))){
var inst_60424 = (state_60426[(2)]);
var state_60426__$1 = state_60426;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60426__$1,inst_60424);
} else {
if((state_val_60427 === (12))){
var inst_60333 = (state_60426[(18)]);
var inst_60353 = (state_60426[(8)]);
var inst_60358 = fluree.db.api.query.auth_match(auth,inst_60333,inst_60353);
var inst_60359 = cljs.core.not(inst_60358);
var state_60426__$1 = state_60426;
var statearr_60455_60550 = state_60426__$1;
(statearr_60455_60550[(2)] = inst_60359);

(statearr_60455_60550[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (2))){
var _ = (function (){var statearr_60456 = state_60426;
(statearr_60456[(4)] = cljs.core.cons((5),(state_60426[(4)])));

return statearr_60456;
})();
var inst_60238 = (function (){return (function (p1__60231_SHARP_){
return p1__60231_SHARP_.t;
});
})();
var inst_60239 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_60238,resp);
var inst_60240 = cljs.core.set(inst_60239);
var inst_60328 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_60329 = (function (){var ts = inst_60240;
var c__2763__auto____$1 = inst_60328;
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_60326){
var state_val_60327 = (state_60326[(1)]);
if((state_val_60327 === (7))){
var inst_60266 = (state_60326[(7)]);
var inst_60260 = (state_60326[(8)]);
var inst_60254 = (state_60326[(9)]);
var inst_60272 = (state_60326[(10)]);
var inst_60265 = (state_60326[(2)]);
var inst_60266__$1 = fluree.db.util.async.throw_err(inst_60265);
var inst_60268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60269 = [inst_60260,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60270 = (new cljs.core.PersistentVector(null,2,(5),inst_60268,inst_60269,null));
var inst_60271 = cljs.core.assoc_in(inst_60254,inst_60270,inst_60266__$1);
var inst_60272__$1 = auth;
var state_60326__$1 = (function (){var statearr_60457 = state_60326;
(statearr_60457[(7)] = inst_60266__$1);

(statearr_60457[(11)] = inst_60271);

(statearr_60457[(10)] = inst_60272__$1);

return statearr_60457;
})();
if(cljs.core.truth_(inst_60272__$1)){
var statearr_60458_60551 = state_60326__$1;
(statearr_60458_60551[(1)] = (8));

} else {
var statearr_60459_60552 = state_60326__$1;
(statearr_60459_60552[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (1))){
var inst_60248 = (state_60326[(12)]);
var inst_60248__$1 = ts;
var inst_60249 = cljs.core.seq(inst_60248__$1);
var inst_60250 = cljs.core.first(inst_60249);
var inst_60251 = cljs.core.next(inst_60249);
var inst_60252 = cljs.core.PersistentHashMap.EMPTY;
var inst_60253 = inst_60248__$1;
var inst_60254 = inst_60252;
var state_60326__$1 = (function (){var statearr_60460 = state_60326;
(statearr_60460[(12)] = inst_60248__$1);

(statearr_60460[(13)] = inst_60251);

(statearr_60460[(14)] = inst_60250);

(statearr_60460[(9)] = inst_60254);

(statearr_60460[(15)] = inst_60253);

return statearr_60460;
})();
var statearr_60461_60553 = state_60326__$1;
(statearr_60461_60553[(2)] = null);

(statearr_60461_60553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (4))){
var inst_60260 = (state_60326[(8)]);
var inst_60263 = fluree.db.time_travel.non_border_t_to_block(db,inst_60260);
var state_60326__$1 = state_60326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60326__$1,(7),inst_60263);
} else {
if((state_val_60327 === (13))){
var inst_60261 = (state_60326[(16)]);
var inst_60318 = (state_60326[(2)]);
var inst_60253 = inst_60261;
var inst_60254 = inst_60318;
var state_60326__$1 = (function (){var statearr_60462 = state_60326;
(statearr_60462[(9)] = inst_60254);

(statearr_60462[(15)] = inst_60253);

return statearr_60462;
})();
var statearr_60463_60554 = state_60326__$1;
(statearr_60463_60554[(2)] = null);

(statearr_60463_60554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (6))){
var inst_60322 = (state_60326[(2)]);
var state_60326__$1 = state_60326;
var statearr_60464_60555 = state_60326__$1;
(statearr_60464_60555[(2)] = inst_60322);

(statearr_60464_60555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (3))){
var inst_60324 = (state_60326[(2)]);
var state_60326__$1 = state_60326;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60326__$1,inst_60324);
} else {
if((state_val_60327 === (12))){
var inst_60271 = (state_60326[(11)]);
var state_60326__$1 = state_60326;
var statearr_60465_60556 = state_60326__$1;
(statearr_60465_60556[(2)] = inst_60271);

(statearr_60465_60556[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (2))){
var inst_60260 = (state_60326[(8)]);
var inst_60253 = (state_60326[(15)]);
var inst_60259 = cljs.core.seq(inst_60253);
var inst_60260__$1 = cljs.core.first(inst_60259);
var inst_60261 = cljs.core.next(inst_60259);
var state_60326__$1 = (function (){var statearr_60466 = state_60326;
(statearr_60466[(16)] = inst_60261);

(statearr_60466[(8)] = inst_60260__$1);

return statearr_60466;
})();
if(cljs.core.truth_(inst_60260__$1)){
var statearr_60467_60557 = state_60326__$1;
(statearr_60467_60557[(1)] = (4));

} else {
var statearr_60468_60558 = state_60326__$1;
(statearr_60468_60558[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (11))){
var inst_60266 = (state_60326[(7)]);
var inst_60248 = (state_60326[(12)]);
var inst_60251 = (state_60326[(13)]);
var inst_60261 = (state_60326[(16)]);
var inst_60260 = (state_60326[(8)]);
var inst_60271 = (state_60326[(11)]);
var inst_60250 = (state_60326[(14)]);
var inst_60254 = (state_60326[(9)]);
var inst_60253 = (state_60326[(15)]);
var inst_60278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60279 = [inst_60260,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60280 = (new cljs.core.PersistentVector(null,2,(5),inst_60278,inst_60279,null));
var inst_60293 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_60294 = (function (){var t = inst_60260;
var block = inst_60266;
var r = inst_60261;
var G__60244 = inst_60253;
var seq__60246 = inst_60251;
var acc = inst_60254;
var vec__60245 = inst_60248;
var c__2763__auto____$2 = inst_60293;
var seq__60257 = inst_60261;
var first__60258 = inst_60260;
var G__60267 = inst_60271;
var first__60247 = inst_60250;
var vec__60256 = inst_60253;
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_60291){
var state_val_60292 = (state_60291[(1)]);
if((state_val_60292 === (1))){
var state_60291__$1 = state_60291;
var statearr_60469_60559 = state_60291__$1;
(statearr_60469_60559[(2)] = null);

(statearr_60469_60559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60292 === (2))){
var ___$1 = (function (){var statearr_60470 = state_60291;
(statearr_60470[(4)] = cljs.core.cons((5),(state_60291[(4)])));

return statearr_60470;
})();
var ___$2 = (function (){var statearr_60471 = state_60291;
(statearr_60471[(4)] = cljs.core.rest((state_60291[(4)])));

return statearr_60471;
})();
var state_60291__$1 = state_60291;
var statearr_60472_60560 = state_60291__$1;
(statearr_60472_60560[(2)] = db);

(statearr_60472_60560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60292 === (3))){
var inst_60289 = (state_60291[(2)]);
var state_60291__$1 = state_60291;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60291__$1,inst_60289);
} else {
if((state_val_60292 === (4))){
var inst_60281 = (state_60291[(2)]);
var state_60291__$1 = state_60291;
var statearr_60474_60561 = state_60291__$1;
(statearr_60474_60561[(2)] = inst_60281);

(statearr_60474_60561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60292 === (5))){
var ___$1 = (function (){var statearr_60475 = state_60291;
(statearr_60475[(4)] = cljs.core.rest((state_60291[(4)])));

return statearr_60475;
})();
var state_60291__$1 = state_60291;
var ex60473 = (state_60291__$1[(2)]);
var statearr_60476_60562 = state_60291__$1;
(statearr_60476_60562[(5)] = ex60473);


if((ex60473 instanceof Error)){
var statearr_60477_60563 = state_60291__$1;
(statearr_60477_60563[(1)] = (4));

(statearr_60477_60563[(5)] = null);

} else {
throw ex60473;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0 = (function (){
var statearr_60478 = [null,null,null,null,null,null,null];
(statearr_60478[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__);

(statearr_60478[(1)] = (1));

return statearr_60478;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1 = (function (state_60291){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_60291);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e60479){var ex__2744__auto__ = e60479;
var statearr_60480_60564 = state_60291;
(statearr_60480_60564[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_60291[(4)]))){
var statearr_60481_60565 = state_60291;
(statearr_60481_60565[(1)] = cljs.core.first((state_60291[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60566 = state_60291;
state_60291 = G__60566;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__ = function(state_60291){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1.call(this,state_60291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_60482 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_60482[(6)] = c__2763__auto____$2);

return statearr_60482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
});
})();
var inst_60295 = cljs.core.async.impl.dispatch.run(inst_60294);
var inst_60296 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_60297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60298 = ["?auth","?id"];
var inst_60299 = (new cljs.core.PersistentVector(null,2,(5),inst_60297,inst_60298,null));
var inst_60300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60302 = [inst_60260,"_tx/auth","?auth"];
var inst_60303 = (new cljs.core.PersistentVector(null,3,(5),inst_60301,inst_60302,null));
var inst_60304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60305 = ["?auth","_auth/id","?id"];
var inst_60306 = (new cljs.core.PersistentVector(null,3,(5),inst_60304,inst_60305,null));
var inst_60307 = [inst_60303,inst_60306];
var inst_60308 = (new cljs.core.PersistentVector(null,2,(5),inst_60300,inst_60307,null));
var inst_60309 = [inst_60299,inst_60308];
var inst_60310 = cljs.core.PersistentHashMap.fromArrays(inst_60296,inst_60309);
var inst_60311 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_60293,inst_60310) : fluree.db.api.query.query_async.call(null,inst_60293,inst_60310));
var state_60326__$1 = (function (){var statearr_60483 = state_60326;
(statearr_60483[(17)] = inst_60280);

(statearr_60483[(18)] = inst_60295);

return statearr_60483;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60326__$1,(14),inst_60311);
} else {
if((state_val_60327 === (9))){
var state_60326__$1 = state_60326;
var statearr_60484_60567 = state_60326__$1;
(statearr_60484_60567[(2)] = show_auth);

(statearr_60484_60567[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (5))){
var inst_60254 = (state_60326[(9)]);
var state_60326__$1 = state_60326;
var statearr_60485_60568 = state_60326__$1;
(statearr_60485_60568[(2)] = inst_60254);

(statearr_60485_60568[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (14))){
var inst_60271 = (state_60326[(11)]);
var inst_60280 = (state_60326[(17)]);
var inst_60313 = (state_60326[(2)]);
var inst_60314 = fluree.db.util.async.throw_err(inst_60313);
var inst_60315 = cljs.core.assoc_in(inst_60271,inst_60280,inst_60314);
var state_60326__$1 = state_60326;
var statearr_60486_60569 = state_60326__$1;
(statearr_60486_60569[(2)] = inst_60315);

(statearr_60486_60569[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (10))){
var inst_60276 = (state_60326[(2)]);
var state_60326__$1 = state_60326;
if(cljs.core.truth_(inst_60276)){
var statearr_60487_60570 = state_60326__$1;
(statearr_60487_60570[(1)] = (11));

} else {
var statearr_60488_60571 = state_60326__$1;
(statearr_60488_60571[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (8))){
var inst_60272 = (state_60326[(10)]);
var state_60326__$1 = state_60326;
var statearr_60489_60572 = state_60326__$1;
(statearr_60489_60572[(2)] = inst_60272);

(statearr_60489_60572[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0 = (function (){
var statearr_60490 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60490[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__);

(statearr_60490[(1)] = (1));

return statearr_60490;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1 = (function (state_60326){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_60326);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e60491){var ex__2744__auto__ = e60491;
var statearr_60492_60573 = state_60326;
(statearr_60492_60573[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_60326[(4)]))){
var statearr_60493_60574 = state_60326;
(statearr_60493_60574[(1)] = cljs.core.first((state_60326[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60575 = state_60326;
state_60326 = G__60575;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__ = function(state_60326){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1.call(this,state_60326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_60494 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_60494[(6)] = c__2763__auto____$1);

return statearr_60494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
});
})();
var inst_60330 = cljs.core.async.impl.dispatch.run(inst_60329);
var state_60426__$1 = (function (){var statearr_60495 = state_60426;
(statearr_60495[(20)] = inst_60330);

return statearr_60495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60426__$1,(6),inst_60328);
} else {
if((state_val_60427 === (23))){
var inst_60384 = (state_60426[(2)]);
var state_60426__$1 = (function (){var statearr_60496 = state_60426;
(statearr_60496[(13)] = inst_60384);

return statearr_60496;
})();
var statearr_60497_60576 = state_60426__$1;
(statearr_60497_60576[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (35))){
var inst_60414 = (state_60426[(2)]);
var state_60426__$1 = state_60426;
var statearr_60499_60577 = state_60426__$1;
(statearr_60499_60577[(2)] = inst_60414);

(statearr_60499_60577[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (19))){
var state_60426__$1 = state_60426;
var statearr_60500_60578 = state_60426__$1;
(statearr_60500_60578[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (11))){
var inst_60365 = (state_60426[(2)]);
var state_60426__$1 = state_60426;
if(cljs.core.truth_(inst_60365)){
var statearr_60503_60579 = state_60426__$1;
(statearr_60503_60579[(1)] = (15));

} else {
var statearr_60504_60580 = state_60426__$1;
(statearr_60504_60580[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (9))){
var inst_60356 = (state_60426[(16)]);
var inst_60356__$1 = auth;
var state_60426__$1 = (function (){var statearr_60505 = state_60426;
(statearr_60505[(16)] = inst_60356__$1);

return statearr_60505;
})();
if(cljs.core.truth_(inst_60356__$1)){
var statearr_60506_60581 = state_60426__$1;
(statearr_60506_60581[(1)] = (12));

} else {
var statearr_60507_60582 = state_60426__$1;
(statearr_60507_60582[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (5))){
var _ = (function (){var statearr_60508 = state_60426;
(statearr_60508[(4)] = cljs.core.rest((state_60426[(4)])));

return statearr_60508;
})();
var state_60426__$1 = state_60426;
var ex60502 = (state_60426__$1[(2)]);
var statearr_60509_60583 = state_60426__$1;
(statearr_60509_60583[(5)] = ex60502);


if((ex60502 instanceof Error)){
var statearr_60510_60584 = state_60426__$1;
(statearr_60510_60584[(1)] = (4));

(statearr_60510_60584[(5)] = null);

} else {
throw ex60502;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (14))){
var inst_60362 = (state_60426[(2)]);
var state_60426__$1 = state_60426;
var statearr_60511_60585 = state_60426__$1;
(statearr_60511_60585[(2)] = inst_60362);

(statearr_60511_60585[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (26))){
var inst_60392 = (state_60426[(2)]);
var state_60426__$1 = (function (){var statearr_60512 = state_60426;
(statearr_60512[(12)] = inst_60392);

return statearr_60512;
})();
var statearr_60513_60586 = state_60426__$1;
(statearr_60513_60586[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (16))){
var inst_60353 = (state_60426[(8)]);
var state_60426__$1 = state_60426;
if(cljs.core.truth_(inst_60353)){
var statearr_60515_60587 = state_60426__$1;
(statearr_60515_60587[(1)] = (18));

} else {
var statearr_60516_60588 = state_60426__$1;
(statearr_60516_60588[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (30))){
var inst_60375 = (state_60426[(21)]);
var inst_60374 = (state_60426[(11)]);
var inst_60400 = (state_60426[(15)]);
var inst_60402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60403 = [inst_60374,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60404 = (new cljs.core.PersistentVector(null,2,(5),inst_60402,inst_60403,null));
var inst_60405 = cljs.core.assoc_in(inst_60400,inst_60404,inst_60375);
var state_60426__$1 = state_60426;
var statearr_60517_60589 = state_60426__$1;
(statearr_60517_60589[(2)] = inst_60405);

(statearr_60517_60589[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (10))){
var inst_60353 = (state_60426[(8)]);
var state_60426__$1 = state_60426;
var statearr_60518_60590 = state_60426__$1;
(statearr_60518_60590[(2)] = inst_60353);

(statearr_60518_60590[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (18))){
var inst_60371 = (state_60426[(10)]);
var inst_60333 = (state_60426[(18)]);
var inst_60353 = (state_60426[(8)]);
var inst_60371__$1 = inst_60353.t;
var inst_60372 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60333,inst_60371__$1);
var inst_60373 = cljs.core.__destructure_map(inst_60372);
var inst_60374 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60373,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60375 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60373,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_60426__$1 = (function (){var statearr_60519 = state_60426;
(statearr_60519[(21)] = inst_60375);

(statearr_60519[(10)] = inst_60371__$1);

(statearr_60519[(11)] = inst_60374);

return statearr_60519;
})();
var statearr_60520_60591 = state_60426__$1;
(statearr_60520_60591[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60427 === (8))){
var inst_60420 = (state_60426[(2)]);
var inst_60421 = cljs.core.vals(inst_60420);
var _ = (function (){var statearr_60522 = state_60426;
(statearr_60522[(4)] = cljs.core.rest((state_60426[(4)])));

return statearr_60522;
})();
var state_60426__$1 = state_60426;
var statearr_60523_60592 = state_60426__$1;
(statearr_60523_60592[(2)] = inst_60421);

(statearr_60523_60592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0 = (function (){
var statearr_60524 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60524[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__);

(statearr_60524[(1)] = (1));

return statearr_60524;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1 = (function (state_60426){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_60426);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e60525){var ex__2744__auto__ = e60525;
var statearr_60526_60593 = state_60426;
(statearr_60526_60593[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_60426[(4)]))){
var statearr_60527_60594 = state_60426;
(statearr_60527_60594[(1)] = cljs.core.first((state_60426[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60595 = state_60426;
state_60426 = G__60595;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__ = function(state_60426){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1.call(this,state_60426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2741__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_60528 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_60528[(6)] = c__2763__auto__);

return statearr_60528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_60722){
var state_val_60723 = (state_60722[(1)]);
if((state_val_60723 === (7))){
var inst_60618 = (state_60722[(7)]);
var inst_60620 = fluree.db.api.query.resolve_block_range(inst_60618,query_map);
var state_60722__$1 = state_60722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60722__$1,(10),inst_60620);
} else {
if((state_val_60723 === (20))){
var inst_60647 = (state_60722[(2)]);
var inst_60648 = fluree.db.util.async.throw_err(inst_60647);
var inst_60649 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60648);
var inst_60650 = (inst_60649 - (1));
var state_60722__$1 = state_60722;
var statearr_60724_60787 = state_60722__$1;
(statearr_60724_60787[(2)] = inst_60650);

(statearr_60724_60787[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (27))){
var state_60722__$1 = state_60722;
var statearr_60725_60788 = state_60722__$1;
(statearr_60725_60788[(2)] = null);

(statearr_60725_60788[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (1))){
var state_60722__$1 = state_60722;
var statearr_60726_60789 = state_60722__$1;
(statearr_60726_60789[(2)] = null);

(statearr_60726_60789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (24))){
var inst_60657 = (state_60722[(2)]);
var inst_60658 = fluree.db.util.async.throw_err(inst_60657);
var inst_60659 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60658);
var state_60722__$1 = state_60722;
var statearr_60727_60790 = state_60722__$1;
(statearr_60727_60790[(2)] = inst_60659);

(statearr_60727_60790[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (39))){
var inst_60694 = (state_60722[(2)]);
var inst_60695 = fluree.db.util.async.throw_err(inst_60694);
var state_60722__$1 = state_60722;
var statearr_60728_60791 = state_60722__$1;
(statearr_60728_60791[(2)] = inst_60695);

(statearr_60728_60791[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (4))){
var inst_60596 = (state_60722[(2)]);
var state_60722__$1 = state_60722;
var statearr_60729_60792 = state_60722__$1;
(statearr_60729_60792[(2)] = inst_60596);

(statearr_60729_60792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (15))){
var inst_60627 = (state_60722[(8)]);
var state_60722__$1 = state_60722;
var statearr_60730_60793 = state_60722__$1;
(statearr_60730_60793[(2)] = inst_60627);

(statearr_60730_60793[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (21))){
var inst_60628 = (state_60722[(9)]);
var inst_60618 = (state_60722[(7)]);
var inst_60655 = fluree.db.time_travel.as_of_block(inst_60618,inst_60628);
var state_60722__$1 = state_60722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60722__$1,(24),inst_60655);
} else {
if((state_val_60723 === (31))){
var inst_60612 = (state_60722[(10)]);
var state_60722__$1 = state_60722;
var statearr_60731_60794 = state_60722__$1;
(statearr_60731_60794[(2)] = inst_60612);

(statearr_60731_60794[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (32))){
var inst_60678 = (state_60722[(11)]);
var inst_60618 = (state_60722[(7)]);
var inst_60673 = (state_60722[(12)]);
var inst_60682 = (state_60722[(2)]);
var inst_60683 = fluree.db.api.query.format_history_resp(inst_60618,inst_60673,inst_60678,inst_60682);
var state_60722__$1 = state_60722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60722__$1,(29),inst_60683);
} else {
if((state_val_60723 === (40))){
var inst_60699 = (state_60722[(13)]);
var inst_60673 = (state_60722[(12)]);
var inst_60701 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_60702 = cljs.core.count(inst_60673);
var inst_60703 = [inst_60699,inst_60702,(200)];
var inst_60704 = cljs.core.PersistentHashMap.fromArrays(inst_60701,inst_60703);
var state_60722__$1 = state_60722;
var statearr_60732_60795 = state_60722__$1;
(statearr_60732_60795[(2)] = inst_60704);

(statearr_60732_60795[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (33))){
var inst_60611 = (state_60722[(14)]);
var state_60722__$1 = state_60722;
var statearr_60733_60796 = state_60722__$1;
(statearr_60733_60796[(2)] = inst_60611);

(statearr_60733_60796[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (13))){
var inst_60717 = (state_60722[(2)]);
var _ = (function (){var statearr_60734 = state_60722;
(statearr_60734[(4)] = cljs.core.rest((state_60722[(4)])));

return statearr_60734;
})();
var state_60722__$1 = state_60722;
var statearr_60735_60797 = state_60722__$1;
(statearr_60735_60797[(2)] = inst_60717);

(statearr_60735_60797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (22))){
var inst_60618 = (state_60722[(7)]);
var inst_60661 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60618);
var state_60722__$1 = state_60722;
var statearr_60736_60798 = state_60722__$1;
(statearr_60736_60798[(2)] = inst_60661);

(statearr_60736_60798[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (36))){
var inst_60686 = (state_60722[(15)]);
var inst_60618 = (state_60722[(7)]);
var inst_60692 = fluree.db.api.query.format_blocks_resp_pretty(inst_60618,inst_60686);
var state_60722__$1 = state_60722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60722__$1,(39),inst_60692);
} else {
if((state_val_60723 === (41))){
var inst_60699 = (state_60722[(13)]);
var state_60722__$1 = state_60722;
var statearr_60737_60799 = state_60722__$1;
(statearr_60737_60799[(2)] = inst_60699);

(statearr_60737_60799[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (29))){
var inst_60611 = (state_60722[(14)]);
var inst_60685 = (state_60722[(2)]);
var inst_60686 = fluree.db.util.async.throw_err(inst_60685);
var state_60722__$1 = (function (){var statearr_60738 = state_60722;
(statearr_60738[(15)] = inst_60686);

return statearr_60738;
})();
if(cljs.core.truth_(inst_60611)){
var statearr_60739_60800 = state_60722__$1;
(statearr_60739_60800[(1)] = (33));

} else {
var statearr_60740_60801 = state_60722__$1;
(statearr_60740_60801[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (6))){
var inst_60608 = (state_60722[(16)]);
var inst_60617 = (state_60722[(2)]);
var inst_60618 = fluree.db.util.async.throw_err(inst_60617);
var state_60722__$1 = (function (){var statearr_60741 = state_60722;
(statearr_60741[(7)] = inst_60618);

return statearr_60741;
})();
if(cljs.core.truth_(inst_60608)){
var statearr_60742_60802 = state_60722__$1;
(statearr_60742_60802[(1)] = (7));

} else {
var statearr_60743_60803 = state_60722__$1;
(statearr_60743_60803[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (28))){
var inst_60613 = (state_60722[(17)]);
var inst_60678 = (state_60722[(2)]);
var state_60722__$1 = (function (){var statearr_60744 = state_60722;
(statearr_60744[(11)] = inst_60678);

return statearr_60744;
})();
if(cljs.core.truth_(inst_60613)){
var statearr_60745_60804 = state_60722__$1;
(statearr_60745_60804[(1)] = (30));

} else {
var statearr_60746_60805 = state_60722__$1;
(statearr_60746_60805[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (25))){
var inst_60614 = (state_60722[(18)]);
var inst_60672 = (state_60722[(2)]);
var inst_60673 = fluree.db.util.async.throw_err(inst_60672);
var state_60722__$1 = (function (){var statearr_60747 = state_60722;
(statearr_60747[(12)] = inst_60673);

return statearr_60747;
})();
if(cljs.core.truth_(inst_60614)){
var statearr_60748_60806 = state_60722__$1;
(statearr_60748_60806[(1)] = (26));

} else {
var statearr_60749_60807 = state_60722__$1;
(statearr_60749_60807[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (34))){
var inst_60610 = (state_60722[(19)]);
var state_60722__$1 = state_60722;
var statearr_60750_60808 = state_60722__$1;
(statearr_60750_60808[(2)] = inst_60610);

(statearr_60750_60808[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (17))){
var inst_60618 = (state_60722[(7)]);
var inst_60627 = (state_60722[(8)]);
var inst_60644 = (inst_60627 - (1));
var inst_60645 = fluree.db.time_travel.as_of_block(inst_60618,inst_60644);
var state_60722__$1 = state_60722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60722__$1,(20),inst_60645);
} else {
if((state_val_60723 === (3))){
var inst_60720 = (state_60722[(2)]);
var state_60722__$1 = state_60722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60722__$1,inst_60720);
} else {
if((state_val_60723 === (12))){
var inst_60709 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_60710 = ["History query not properly formatted. Provided ",inst_60709].join('');
var inst_60711 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60712 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60713 = cljs.core.PersistentHashMap.fromArrays(inst_60711,inst_60712);
var inst_60714 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60710,inst_60713);
var inst_60715 = (function(){throw inst_60714})();
var state_60722__$1 = state_60722;
var statearr_60751_60809 = state_60722__$1;
(statearr_60751_60809[(2)] = inst_60715);

(statearr_60751_60809[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (2))){
var _ = (function (){var statearr_60752 = state_60722;
(statearr_60752[(4)] = cljs.core.cons((5),(state_60722[(4)])));

return statearr_60752;
})();
var inst_60606 = query_map;
var inst_60607 = cljs.core.__destructure_map(inst_60606);
var inst_60608 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60607,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60609 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60607,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60610 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60607,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_60611 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60607,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_60612 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60607,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_60613 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60607,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_60614 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60607,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60615 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60607,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_60722__$1 = (function (){var statearr_60753 = state_60722;
(statearr_60753[(19)] = inst_60610);

(statearr_60753[(20)] = inst_60609);

(statearr_60753[(18)] = inst_60614);

(statearr_60753[(17)] = inst_60613);

(statearr_60753[(10)] = inst_60612);

(statearr_60753[(21)] = inst_60615);

(statearr_60753[(14)] = inst_60611);

(statearr_60753[(16)] = inst_60608);

return statearr_60753;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60722__$1,(6),sources);
} else {
if((state_val_60723 === (23))){
var inst_60609 = (state_60722[(20)]);
var inst_60618 = (state_60722[(7)]);
var inst_60653 = (state_60722[(22)]);
var inst_60663 = (state_60722[(2)]);
var inst_60664 = fluree.db.api.query.get_history_pattern(inst_60609);
var inst_60665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60664,(0),null);
var inst_60666 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60664,(1),null);
var inst_60667 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_60668 = [inst_60653,inst_60663];
var inst_60669 = cljs.core.PersistentHashMap.fromArrays(inst_60667,inst_60668);
var inst_60670 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_60618,inst_60666,cljs.core._EQ_,inst_60665,inst_60669);
var state_60722__$1 = state_60722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60722__$1,(25),inst_60670);
} else {
if((state_val_60723 === (35))){
var inst_60690 = (state_60722[(2)]);
var state_60722__$1 = state_60722;
if(cljs.core.truth_(inst_60690)){
var statearr_60754_60810 = state_60722__$1;
(statearr_60754_60810[(1)] = (36));

} else {
var statearr_60755_60811 = state_60722__$1;
(statearr_60755_60811[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (19))){
var inst_60628 = (state_60722[(9)]);
var inst_60653 = (state_60722[(2)]);
var state_60722__$1 = (function (){var statearr_60756 = state_60722;
(statearr_60756[(22)] = inst_60653);

return statearr_60756;
})();
if(cljs.core.truth_(inst_60628)){
var statearr_60757_60812 = state_60722__$1;
(statearr_60757_60812[(1)] = (21));

} else {
var statearr_60758_60813 = state_60722__$1;
(statearr_60758_60813[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (11))){
var inst_60615 = (state_60722[(21)]);
var inst_60627 = (state_60722[(8)]);
var inst_60637 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60615);
var state_60722__$1 = (function (){var statearr_60760 = state_60722;
(statearr_60760[(23)] = inst_60637);

return statearr_60760;
})();
if(cljs.core.truth_(inst_60627)){
var statearr_60761_60814 = state_60722__$1;
(statearr_60761_60814[(1)] = (14));

} else {
var statearr_60762_60815 = state_60722__$1;
(statearr_60762_60815[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (9))){
var inst_60626 = (state_60722[(2)]);
var inst_60627 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60626,(0),null);
var inst_60628 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60626,(1),null);
var inst_60629 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60630 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_60631 = cljs.core.keys(inst_60630);
var inst_60632 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_60629,inst_60631);
var state_60722__$1 = (function (){var statearr_60763 = state_60722;
(statearr_60763[(9)] = inst_60628);

(statearr_60763[(8)] = inst_60627);

return statearr_60763;
})();
if(inst_60632){
var statearr_60764_60816 = state_60722__$1;
(statearr_60764_60816[(1)] = (11));

} else {
var statearr_60765_60817 = state_60722__$1;
(statearr_60765_60817[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (5))){
var _ = (function (){var statearr_60766 = state_60722;
(statearr_60766[(4)] = cljs.core.rest((state_60722[(4)])));

return statearr_60766;
})();
var state_60722__$1 = state_60722;
var ex60759 = (state_60722__$1[(2)]);
var statearr_60767_60818 = state_60722__$1;
(statearr_60767_60818[(5)] = ex60759);


if((ex60759 instanceof Error)){
var statearr_60768_60819 = state_60722__$1;
(statearr_60768_60819[(1)] = (4));

(statearr_60768_60819[(5)] = null);

} else {
throw ex60759;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (14))){
var inst_60627 = (state_60722[(8)]);
var inst_60639 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_60627);
var state_60722__$1 = state_60722;
var statearr_60769_60820 = state_60722__$1;
(statearr_60769_60820[(2)] = inst_60639);

(statearr_60769_60820[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (26))){
var inst_60614 = (state_60722[(18)]);
var inst_60675 = cljs.core.set(inst_60614);
var state_60722__$1 = state_60722;
var statearr_60770_60821 = state_60722__$1;
(statearr_60770_60821[(2)] = inst_60675);

(statearr_60770_60821[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (16))){
var inst_60642 = (state_60722[(2)]);
var state_60722__$1 = state_60722;
if(cljs.core.truth_(inst_60642)){
var statearr_60771_60822 = state_60722__$1;
(statearr_60771_60822[(1)] = (17));

} else {
var statearr_60772_60823 = state_60722__$1;
(statearr_60772_60823[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (38))){
var inst_60637 = (state_60722[(23)]);
var inst_60699 = (state_60722[(2)]);
var state_60722__$1 = (function (){var statearr_60773 = state_60722;
(statearr_60773[(13)] = inst_60699);

return statearr_60773;
})();
if(cljs.core.truth_(inst_60637)){
var statearr_60774_60824 = state_60722__$1;
(statearr_60774_60824[(1)] = (40));

} else {
var statearr_60775_60825 = state_60722__$1;
(statearr_60775_60825[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (30))){
var inst_60613 = (state_60722[(17)]);
var state_60722__$1 = state_60722;
var statearr_60776_60826 = state_60722__$1;
(statearr_60776_60826[(2)] = inst_60613);

(statearr_60776_60826[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (10))){
var inst_60622 = (state_60722[(2)]);
var inst_60623 = fluree.db.util.async.throw_err(inst_60622);
var state_60722__$1 = state_60722;
var statearr_60777_60827 = state_60722__$1;
(statearr_60777_60827[(2)] = inst_60623);

(statearr_60777_60827[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (18))){
var state_60722__$1 = state_60722;
var statearr_60778_60828 = state_60722__$1;
(statearr_60778_60828[(2)] = (-1));

(statearr_60778_60828[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (42))){
var inst_60707 = (state_60722[(2)]);
var state_60722__$1 = state_60722;
var statearr_60779_60829 = state_60722__$1;
(statearr_60779_60829[(2)] = inst_60707);

(statearr_60779_60829[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (37))){
var inst_60686 = (state_60722[(15)]);
var inst_60697 = fluree.db.api.query.block_Flakes__GT_vector(inst_60686);
var state_60722__$1 = state_60722;
var statearr_60780_60830 = state_60722__$1;
(statearr_60780_60830[(2)] = inst_60697);

(statearr_60780_60830[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60723 === (8))){
var state_60722__$1 = state_60722;
var statearr_60781_60831 = state_60722__$1;
(statearr_60781_60831[(2)] = null);

(statearr_60781_60831[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2741__auto____0 = (function (){
var statearr_60782 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60782[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2741__auto__);

(statearr_60782[(1)] = (1));

return statearr_60782;
});
var fluree$db$api$query$history_query_async_$_state_machine__2741__auto____1 = (function (state_60722){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_60722);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e60783){var ex__2744__auto__ = e60783;
var statearr_60784_60832 = state_60722;
(statearr_60784_60832[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_60722[(4)]))){
var statearr_60785_60833 = state_60722;
(statearr_60785_60833[(1)] = cljs.core.first((state_60722[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60834 = state_60722;
state_60722 = G__60834;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2741__auto__ = function(state_60722){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2741__auto____1.call(this,state_60722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2741__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2741__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_60786 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_60786[(6)] = c__2763__auto__);

return statearr_60786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_60967){
var state_val_60968 = (state_60967[(1)]);
if((state_val_60968 === (7))){
var inst_60864 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_60865 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_60864].join('');
var inst_60866 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60867 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60868 = cljs.core.PersistentHashMap.fromArrays(inst_60866,inst_60867);
var inst_60869 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60865,inst_60868);
var inst_60870 = (function(){throw inst_60869})();
var state_60967__$1 = state_60967;
var statearr_60969_61048 = state_60967__$1;
(statearr_60969_61048[(2)] = inst_60870);

(statearr_60969_61048[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (20))){
var inst_60902 = (state_60967[(2)]);
var state_60967__$1 = state_60967;
if(cljs.core.truth_(inst_60902)){
var statearr_60970_61049 = state_60967__$1;
(statearr_60970_61049[(1)] = (21));

} else {
var statearr_60971_61050 = state_60967__$1;
(statearr_60971_61050[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (27))){
var inst_60846 = (state_60967[(7)]);
var state_60967__$1 = state_60967;
var statearr_60972_61051 = state_60967__$1;
(statearr_60972_61051[(2)] = inst_60846);

(statearr_60972_61051[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (1))){
var state_60967__$1 = state_60967;
var statearr_60973_61052 = state_60967__$1;
(statearr_60973_61052[(2)] = null);

(statearr_60973_61052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (24))){
var inst_60908 = (state_60967[(8)]);
var state_60967__$1 = state_60967;
var statearr_60974_61053 = state_60967__$1;
(statearr_60974_61053[(2)] = inst_60908);

(statearr_60974_61053[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (39))){
var inst_60852 = (state_60967[(9)]);
var state_60967__$1 = state_60967;
if(cljs.core.truth_(inst_60852)){
var statearr_60975_61054 = state_60967__$1;
(statearr_60975_61054[(1)] = (42));

} else {
var statearr_60976_61055 = state_60967__$1;
(statearr_60976_61055[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (46))){
var inst_60940 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60941 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60942 = cljs.core.PersistentHashMap.fromArrays(inst_60940,inst_60941);
var inst_60943 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_60942);
var inst_60944 = (function(){throw inst_60943})();
var state_60967__$1 = state_60967;
var statearr_60977_61056 = state_60967__$1;
(statearr_60977_61056[(2)] = inst_60944);

(statearr_60977_61056[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (4))){
var inst_60836 = (state_60967[(2)]);
var state_60967__$1 = state_60967;
var statearr_60978_61057 = state_60967__$1;
(statearr_60978_61057[(2)] = inst_60836);

(statearr_60978_61057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (15))){
var inst_60887 = (state_60967[(10)]);
var inst_60849 = (state_60967[(11)]);
var inst_60889 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_60887);
var inst_60890 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_60887);
var inst_60891 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_60887);
var inst_60892 = fluree.db.api.query.get_sources(inst_60889,inst_60890,inst_60891,inst_60849);
var state_60967__$1 = state_60967;
var statearr_60979_61058 = state_60967__$1;
(statearr_60979_61058[(2)] = inst_60892);

(statearr_60979_61058[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (48))){
var inst_60897 = (state_60967[(12)]);
var inst_60951 = (state_60967[(2)]);
var inst_60952 = fluree.db.util.async.throw_err(inst_60951);
var state_60967__$1 = (function (){var statearr_60980 = state_60967;
(statearr_60980[(13)] = inst_60952);

return statearr_60980;
})();
if(cljs.core.truth_(inst_60897)){
var statearr_60981_61059 = state_60967__$1;
(statearr_60981_61059[(1)] = (49));

} else {
var statearr_60982_61060 = state_60967__$1;
(statearr_60982_61060[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (50))){
var inst_60952 = (state_60967[(13)]);
var state_60967__$1 = state_60967;
var statearr_60983_61061 = state_60967__$1;
(statearr_60983_61061[(2)] = inst_60952);

(statearr_60983_61061[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (21))){
var inst_60904 = cljs.core.volatile_BANG_((0));
var state_60967__$1 = state_60967;
var statearr_60984_61062 = state_60967__$1;
(statearr_60984_61062[(2)] = inst_60904);

(statearr_60984_61062[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (31))){
var inst_60850 = (state_60967[(14)]);
var state_60967__$1 = state_60967;
if(cljs.core.truth_(inst_60850)){
var statearr_60985_61063 = state_60967__$1;
(statearr_60985_61063[(1)] = (33));

} else {
var statearr_60986_61064 = state_60967__$1;
(statearr_60986_61064[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (32))){
var inst_60927 = (state_60967[(2)]);
var state_60967__$1 = state_60967;
var statearr_60987_61065 = state_60967__$1;
(statearr_60987_61065[(2)] = inst_60927);

(statearr_60987_61065[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (40))){
var inst_60929 = (state_60967[(15)]);
var state_60967__$1 = state_60967;
var statearr_60988_61066 = state_60967__$1;
(statearr_60988_61066[(2)] = inst_60929);

(statearr_60988_61066[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (33))){
var inst_60850 = (state_60967[(14)]);
var state_60967__$1 = state_60967;
var statearr_60989_61067 = state_60967__$1;
(statearr_60989_61067[(2)] = inst_60850);

(statearr_60989_61067[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (13))){
var inst_60847 = (state_60967[(16)]);
var inst_60876 = (state_60967[(2)]);
var inst_60877 = fluree.db.util.async.throw_err(inst_60876);
var inst_60878 = fluree.db.time_travel.as_of_block(inst_60877,inst_60847);
var state_60967__$1 = state_60967;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60967__$1,(12),inst_60878);
} else {
if((state_val_60968 === (22))){
var state_60967__$1 = state_60967;
var statearr_60990_61068 = state_60967__$1;
(statearr_60990_61068[(2)] = null);

(statearr_60990_61068[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (36))){
var inst_60854 = (state_60967[(17)]);
var state_60967__$1 = state_60967;
var statearr_60991_61069 = state_60967__$1;
(statearr_60991_61069[(2)] = inst_60854);

(statearr_60991_61069[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (41))){
var inst_60937 = (state_60967[(2)]);
var state_60967__$1 = state_60967;
if(cljs.core.truth_(inst_60937)){
var statearr_60992_61070 = state_60967__$1;
(statearr_60992_61070[(1)] = (45));

} else {
var statearr_60993_61071 = state_60967__$1;
(statearr_60993_61071[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (43))){
var inst_60848 = (state_60967[(18)]);
var state_60967__$1 = state_60967;
var statearr_60994_61072 = state_60967__$1;
(statearr_60994_61072[(2)] = inst_60848);

(statearr_60994_61072[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (29))){
var inst_60929 = (state_60967[(15)]);
var inst_60929__$1 = (state_60967[(2)]);
var state_60967__$1 = (function (){var statearr_60995 = state_60967;
(statearr_60995[(15)] = inst_60929__$1);

return statearr_60995;
})();
if(cljs.core.truth_(inst_60929__$1)){
var statearr_60996_61073 = state_60967__$1;
(statearr_60996_61073[(1)] = (39));

} else {
var statearr_60997_61074 = state_60967__$1;
(statearr_60997_61074[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (44))){
var inst_60934 = (state_60967[(2)]);
var state_60967__$1 = state_60967;
var statearr_60998_61075 = state_60967__$1;
(statearr_60998_61075[(2)] = inst_60934);

(statearr_60998_61075[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (6))){
var state_60967__$1 = state_60967;
var statearr_60999_61076 = state_60967__$1;
(statearr_60999_61076[(2)] = null);

(statearr_60999_61076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (28))){
var inst_60851 = (state_60967[(19)]);
var state_60967__$1 = state_60967;
if(cljs.core.truth_(inst_60851)){
var statearr_61000_61077 = state_60967__$1;
(statearr_61000_61077[(1)] = (30));

} else {
var statearr_61001_61078 = state_60967__$1;
(statearr_61001_61078[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (51))){
var inst_60962 = (state_60967[(2)]);
var _ = (function (){var statearr_61002 = state_60967;
(statearr_61002[(4)] = cljs.core.rest((state_60967[(4)])));

return statearr_61002;
})();
var state_60967__$1 = state_60967;
var statearr_61003_61079 = state_60967__$1;
(statearr_61003_61079[(2)] = inst_60962);

(statearr_61003_61079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (25))){
var state_60967__$1 = state_60967;
var statearr_61004_61080 = state_60967__$1;
(statearr_61004_61080[(2)] = (1000000));

(statearr_61004_61080[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (34))){
var inst_60854 = (state_60967[(17)]);
var state_60967__$1 = state_60967;
if(cljs.core.truth_(inst_60854)){
var statearr_61005_61081 = state_60967__$1;
(statearr_61005_61081[(1)] = (36));

} else {
var statearr_61006_61082 = state_60967__$1;
(statearr_61006_61082[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (17))){
var inst_60853 = (state_60967[(20)]);
var inst_60898 = (state_60967[(21)]);
var inst_60896 = (state_60967[(2)]);
var inst_60897 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60853);
var inst_60898__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_60853);
var state_60967__$1 = (function (){var statearr_61007 = state_60967;
(statearr_61007[(22)] = inst_60896);

(statearr_61007[(12)] = inst_60897);

(statearr_61007[(21)] = inst_60898__$1);

return statearr_61007;
})();
if(cljs.core.truth_(inst_60898__$1)){
var statearr_61008_61083 = state_60967__$1;
(statearr_61008_61083[(1)] = (18));

} else {
var statearr_61009_61084 = state_60967__$1;
(statearr_61009_61084[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (3))){
var inst_60965 = (state_60967[(2)]);
var state_60967__$1 = state_60967;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60967__$1,inst_60965);
} else {
if((state_val_60968 === (12))){
var inst_60880 = (state_60967[(2)]);
var inst_60881 = fluree.db.util.async.throw_err(inst_60880);
var state_60967__$1 = state_60967;
var statearr_61010_61085 = state_60967__$1;
(statearr_61010_61085[(2)] = inst_60881);

(statearr_61010_61085[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (2))){
var inst_60846 = (state_60967[(7)]);
var inst_60854 = (state_60967[(17)]);
var inst_60853 = (state_60967[(20)]);
var inst_60847 = (state_60967[(16)]);
var inst_60850 = (state_60967[(14)]);
var inst_60845 = (state_60967[(23)]);
var inst_60848 = (state_60967[(18)]);
var inst_60852 = (state_60967[(9)]);
var inst_60849 = (state_60967[(11)]);
var inst_60851 = (state_60967[(19)]);
var _ = (function (){var statearr_61011 = state_60967;
(statearr_61011[(4)] = cljs.core.cons((5),(state_60967[(4)])));

return statearr_61011;
})();
var inst_60843 = flureeQL;
var inst_60844 = cljs.core.__destructure_map(inst_60843);
var inst_60845__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60844,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_60846__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60844,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_60847__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60844,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60848__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60844,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_60849__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60844,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_60850__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60844,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_60851__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60844,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_60852__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60844,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_60853__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60844,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60854__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60844,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_60855 = (function (){var construct = inst_60845__$1;
var select = inst_60846__$1;
var block = inst_60847__$1;
var where = inst_60848__$1;
var prefixes = inst_60849__$1;
var selectDistinct = inst_60850__$1;
var selectOne = inst_60851__$1;
var from = inst_60852__$1;
var opts = inst_60853__$1;
var selectReduced = inst_60854__$1;
var map__60842 = inst_60844;
return (function (p1__60835_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__60835_SHARP_);
});
})();
var inst_60856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60857 = [inst_60846__$1,inst_60851__$1,inst_60850__$1,inst_60854__$1];
var inst_60858 = (new cljs.core.PersistentVector(null,4,(5),inst_60856,inst_60857,null));
var inst_60859 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_60858);
var inst_60860 = cljs.core.count(inst_60859);
var inst_60861 = (inst_60855.cljs$core$IFn$_invoke$arity$1 ? inst_60855.cljs$core$IFn$_invoke$arity$1(inst_60860) : inst_60855.call(null,inst_60860));
var state_60967__$1 = (function (){var statearr_61012 = state_60967;
(statearr_61012[(7)] = inst_60846__$1);

(statearr_61012[(17)] = inst_60854__$1);

(statearr_61012[(20)] = inst_60853__$1);

(statearr_61012[(16)] = inst_60847__$1);

(statearr_61012[(14)] = inst_60850__$1);

(statearr_61012[(23)] = inst_60845__$1);

(statearr_61012[(18)] = inst_60848__$1);

(statearr_61012[(9)] = inst_60852__$1);

(statearr_61012[(11)] = inst_60849__$1);

(statearr_61012[(19)] = inst_60851__$1);

return statearr_61012;
})();
if(cljs.core.truth_(inst_60861)){
var statearr_61013_61086 = state_60967__$1;
(statearr_61013_61086[(1)] = (6));

} else {
var statearr_61014_61087 = state_60967__$1;
(statearr_61014_61087[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (23))){
var inst_60853 = (state_60967[(20)]);
var inst_60908 = (state_60967[(8)]);
var inst_60907 = (state_60967[(2)]);
var inst_60908__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_60853);
var state_60967__$1 = (function (){var statearr_61015 = state_60967;
(statearr_61015[(24)] = inst_60907);

(statearr_61015[(8)] = inst_60908__$1);

return statearr_61015;
})();
if(cljs.core.truth_(inst_60908__$1)){
var statearr_61016_61088 = state_60967__$1;
(statearr_61016_61088[(1)] = (24));

} else {
var statearr_61017_61089 = state_60967__$1;
(statearr_61017_61089[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (47))){
var inst_60887 = (state_60967[(10)]);
var inst_60913 = (state_60967[(25)]);
var inst_60946 = (state_60967[(2)]);
var inst_60947 = fluree.db.util.core.current_time_millis();
var inst_60948 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_60913);
var inst_60949 = fluree.db.query.fql.query(inst_60887,inst_60948);
var state_60967__$1 = (function (){var statearr_61018 = state_60967;
(statearr_61018[(26)] = inst_60946);

(statearr_61018[(27)] = inst_60947);

return statearr_61018;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60967__$1,(48),inst_60949);
} else {
if((state_val_60968 === (35))){
var inst_60925 = (state_60967[(2)]);
var state_60967__$1 = state_60967;
var statearr_61019_61090 = state_60967__$1;
(statearr_61019_61090[(2)] = inst_60925);

(statearr_61019_61090[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (19))){
var inst_60897 = (state_60967[(12)]);
var state_60967__$1 = state_60967;
var statearr_61020_61091 = state_60967__$1;
(statearr_61020_61091[(2)] = inst_60897);

(statearr_61020_61091[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (11))){
var inst_60849 = (state_60967[(11)]);
var inst_60887 = (state_60967[(2)]);
var state_60967__$1 = (function (){var statearr_61022 = state_60967;
(statearr_61022[(10)] = inst_60887);

return statearr_61022;
})();
if(cljs.core.truth_(inst_60849)){
var statearr_61023_61092 = state_60967__$1;
(statearr_61023_61092[(1)] = (15));

} else {
var statearr_61024_61093 = state_60967__$1;
(statearr_61024_61093[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (9))){
var inst_60873 = (state_60967[(28)]);
var state_60967__$1 = state_60967;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60967__$1,(13),inst_60873);
} else {
if((state_val_60968 === (5))){
var _ = (function (){var statearr_61025 = state_60967;
(statearr_61025[(4)] = cljs.core.rest((state_60967[(4)])));

return statearr_61025;
})();
var state_60967__$1 = state_60967;
var ex61021 = (state_60967__$1[(2)]);
var statearr_61026_61094 = state_60967__$1;
(statearr_61026_61094[(5)] = ex61021);


if((ex61021 instanceof Error)){
var statearr_61027_61095 = state_60967__$1;
(statearr_61027_61095[(1)] = (4));

(statearr_61027_61095[(5)] = null);

} else {
throw ex61021;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (14))){
var inst_60884 = (state_60967[(2)]);
var inst_60885 = fluree.db.util.async.throw_err(inst_60884);
var state_60967__$1 = state_60967;
var statearr_61028_61096 = state_60967__$1;
(statearr_61028_61096[(2)] = inst_60885);

(statearr_61028_61096[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (45))){
var state_60967__$1 = state_60967;
var statearr_61029_61097 = state_60967__$1;
(statearr_61029_61097[(2)] = null);

(statearr_61029_61097[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (26))){
var inst_60846 = (state_60967[(7)]);
var inst_60907 = (state_60967[(24)]);
var inst_60853 = (state_60967[(20)]);
var inst_60896 = (state_60967[(22)]);
var inst_60912 = (state_60967[(2)]);
var inst_60913 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_60853,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_60896,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_60912,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_60907], 0));
var state_60967__$1 = (function (){var statearr_61030 = state_60967;
(statearr_61030[(25)] = inst_60913);

return statearr_61030;
})();
if(cljs.core.truth_(inst_60846)){
var statearr_61031_61098 = state_60967__$1;
(statearr_61031_61098[(1)] = (27));

} else {
var statearr_61032_61099 = state_60967__$1;
(statearr_61032_61099[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (16))){
var inst_60894 = cljs.core.PersistentHashMap.EMPTY;
var state_60967__$1 = state_60967;
var statearr_61033_61100 = state_60967__$1;
(statearr_61033_61100[(2)] = inst_60894);

(statearr_61033_61100[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (38))){
var inst_60923 = (state_60967[(2)]);
var state_60967__$1 = state_60967;
var statearr_61034_61101 = state_60967__$1;
(statearr_61034_61101[(2)] = inst_60923);

(statearr_61034_61101[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (30))){
var inst_60851 = (state_60967[(19)]);
var state_60967__$1 = state_60967;
var statearr_61035_61102 = state_60967__$1;
(statearr_61035_61102[(2)] = inst_60851);

(statearr_61035_61102[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (10))){
var inst_60873 = (state_60967[(28)]);
var state_60967__$1 = state_60967;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60967__$1,(14),inst_60873);
} else {
if((state_val_60968 === (18))){
var inst_60898 = (state_60967[(21)]);
var state_60967__$1 = state_60967;
var statearr_61036_61103 = state_60967__$1;
(statearr_61036_61103[(2)] = inst_60898);

(statearr_61036_61103[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (42))){
var inst_60852 = (state_60967[(9)]);
var state_60967__$1 = state_60967;
var statearr_61037_61104 = state_60967__$1;
(statearr_61037_61104[(2)] = inst_60852);

(statearr_61037_61104[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (37))){
var inst_60845 = (state_60967[(23)]);
var state_60967__$1 = state_60967;
var statearr_61038_61105 = state_60967__$1;
(statearr_61038_61105[(2)] = inst_60845);

(statearr_61038_61105[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (8))){
var inst_60847 = (state_60967[(16)]);
var inst_60872 = (state_60967[(2)]);
var inst_60873 = sources;
var state_60967__$1 = (function (){var statearr_61039 = state_60967;
(statearr_61039[(29)] = inst_60872);

(statearr_61039[(28)] = inst_60873);

return statearr_61039;
})();
if(cljs.core.truth_(inst_60847)){
var statearr_61040_61106 = state_60967__$1;
(statearr_61040_61106[(1)] = (9));

} else {
var statearr_61041_61107 = state_60967__$1;
(statearr_61041_61107[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60968 === (49))){
var inst_60907 = (state_60967[(24)]);
var inst_60952 = (state_60967[(13)]);
var inst_60947 = (state_60967[(27)]);
var inst_60887 = (state_60967[(10)]);
var inst_60954 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60955 = cljs.core.deref(inst_60907);
var inst_60956 = fluree.db.util.core.response_time_formatted(inst_60947);
var inst_60957 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_60887);
var inst_60958 = [(200),inst_60952,inst_60955,inst_60956,inst_60957];
var inst_60959 = cljs.core.PersistentHashMap.fromArrays(inst_60954,inst_60958);
var state_60967__$1 = state_60967;
var statearr_61042_61108 = state_60967__$1;
(statearr_61042_61108[(2)] = inst_60959);

(statearr_61042_61108[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2741__auto____0 = (function (){
var statearr_61043 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61043[(0)] = fluree$db$api$query$query_async_$_state_machine__2741__auto__);

(statearr_61043[(1)] = (1));

return statearr_61043;
});
var fluree$db$api$query$query_async_$_state_machine__2741__auto____1 = (function (state_60967){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_60967);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61044){var ex__2744__auto__ = e61044;
var statearr_61045_61109 = state_60967;
(statearr_61045_61109[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_60967[(4)]))){
var statearr_61046_61110 = state_60967;
(statearr_61046_61110[(1)] = cljs.core.first((state_60967[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61111 = state_60967;
state_60967 = G__61111;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2741__auto__ = function(state_60967){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2741__auto____1.call(this,state_60967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2741__auto____0;
fluree$db$api$query$query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2741__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61047 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_61047[(6)] = c__2763__auto__);

return statearr_61047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61252){
var state_val_61253 = (state_61252[(1)]);
if((state_val_61253 === (7))){
var inst_61247 = (state_61252[(2)]);
var _ = (function (){var statearr_61254 = state_61252;
(statearr_61254[(4)] = cljs.core.rest((state_61252[(4)])));

return statearr_61254;
})();
var state_61252__$1 = state_61252;
var statearr_61255_61331 = state_61252__$1;
(statearr_61255_61331[(2)] = inst_61247);

(statearr_61255_61331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (20))){
var inst_61219 = (state_61252[(2)]);
var state_61252__$1 = state_61252;
var statearr_61256_61332 = state_61252__$1;
(statearr_61256_61332[(2)] = inst_61219);

(statearr_61256_61332[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (27))){
var inst_61199 = (state_61252[(7)]);
var state_61252__$1 = state_61252;
var statearr_61257_61333 = state_61252__$1;
(statearr_61257_61333[(2)] = inst_61199);

(statearr_61257_61333[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (1))){
var state_61252__$1 = state_61252;
var statearr_61258_61334 = state_61252__$1;
(statearr_61258_61334[(2)] = null);

(statearr_61258_61334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (24))){
var inst_61196 = (state_61252[(8)]);
var state_61252__$1 = state_61252;
var statearr_61259_61335 = state_61252__$1;
(statearr_61259_61335[(2)] = inst_61196);

(statearr_61259_61335[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (39))){
var inst_61164 = (state_61252[(9)]);
var inst_61153 = (state_61252[(10)]);
var inst_61186 = (state_61252[(11)]);
var inst_61230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61231 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_61164];
var inst_61232 = (new cljs.core.PersistentVector(null,2,(5),inst_61230,inst_61231,null));
var inst_61233 = cljs.core.assoc_in(inst_61153,inst_61232,inst_61186);
var state_61252__$1 = state_61252;
var statearr_61260_61336 = state_61252__$1;
(statearr_61260_61336[(2)] = inst_61233);

(statearr_61260_61336[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (4))){
var inst_61112 = (state_61252[(2)]);
var state_61252__$1 = state_61252;
var statearr_61261_61337 = state_61252__$1;
(statearr_61261_61337[(2)] = inst_61112);

(statearr_61261_61337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (15))){
var inst_61151 = (state_61252[(12)]);
var inst_61186 = (state_61252[(11)]);
var inst_61189 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_61186);
var inst_61190 = (inst_61151 == null);
var state_61252__$1 = (function (){var statearr_61262 = state_61252;
(statearr_61262[(13)] = inst_61189);

return statearr_61262;
})();
if(cljs.core.truth_(inst_61190)){
var statearr_61263_61338 = state_61252__$1;
(statearr_61263_61338[(1)] = (18));

} else {
var statearr_61264_61339 = state_61252__$1;
(statearr_61264_61339[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (21))){
var inst_61189 = (state_61252[(13)]);
var state_61252__$1 = state_61252;
var statearr_61265_61340 = state_61252__$1;
(statearr_61265_61340[(2)] = inst_61189);

(statearr_61265_61340[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (31))){
var state_61252__$1 = state_61252;
var statearr_61266_61341 = state_61252__$1;
(statearr_61266_61341[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (32))){
var inst_61215 = (state_61252[(2)]);
var state_61252__$1 = state_61252;
var statearr_61268_61342 = state_61252__$1;
(statearr_61268_61342[(2)] = inst_61215);

(statearr_61268_61342[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (40))){
var inst_61184 = (state_61252[(14)]);
var state_61252__$1 = state_61252;
if(cljs.core.truth_(inst_61184)){
var statearr_61269_61343 = state_61252__$1;
(statearr_61269_61343[(1)] = (42));

} else {
var statearr_61270_61344 = state_61252__$1;
(statearr_61270_61344[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (33))){
var inst_61151 = (state_61252[(12)]);
var inst_61189 = (state_61252[(13)]);
var inst_61210 = ((inst_61189 > inst_61151) ? inst_61189 : inst_61151);
var state_61252__$1 = state_61252;
var statearr_61271_61345 = state_61252__$1;
(statearr_61271_61345[(2)] = inst_61210);

(statearr_61271_61345[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (13))){
var inst_61175 = (state_61252[(2)]);
var state_61252__$1 = state_61252;
var statearr_61272_61346 = state_61252__$1;
(statearr_61272_61346[(2)] = inst_61175);

(statearr_61272_61346[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (22))){
var inst_61196 = (state_61252[(8)]);
var inst_61189 = (state_61252[(13)]);
var inst_61196__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_61189);
var state_61252__$1 = (function (){var statearr_61273 = state_61252;
(statearr_61273[(8)] = inst_61196__$1);

return statearr_61273;
})();
if(inst_61196__$1){
var statearr_61274_61347 = state_61252__$1;
(statearr_61274_61347[(1)] = (24));

} else {
var statearr_61275_61348 = state_61252__$1;
(statearr_61275_61348[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (36))){
var inst_61152 = (state_61252[(15)]);
var inst_61186 = (state_61252[(11)]);
var inst_61224 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_61186,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_61225 = (inst_61152 + inst_61224);
var state_61252__$1 = state_61252;
var statearr_61276_61349 = state_61252__$1;
(statearr_61276_61349[(2)] = inst_61225);

(statearr_61276_61349[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (41))){
var inst_61163 = (state_61252[(16)]);
var inst_61222 = (state_61252[(17)]);
var inst_61228 = (state_61252[(18)]);
var inst_61242 = (state_61252[(2)]);
var inst_61150 = inst_61163;
var inst_61151 = inst_61222;
var inst_61152 = inst_61228;
var inst_61153 = inst_61242;
var state_61252__$1 = (function (){var statearr_61277 = state_61252;
(statearr_61277[(12)] = inst_61151);

(statearr_61277[(19)] = inst_61150);

(statearr_61277[(15)] = inst_61152);

(statearr_61277[(10)] = inst_61153);

return statearr_61277;
})();
var statearr_61278_61350 = state_61252__$1;
(statearr_61278_61350[(2)] = null);

(statearr_61278_61350[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (43))){
var inst_61186 = (state_61252[(11)]);
var state_61252__$1 = state_61252;
var statearr_61279_61351 = state_61252__$1;
(statearr_61279_61351[(2)] = inst_61186);

(statearr_61279_61351[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (29))){
var inst_61204 = (state_61252[(2)]);
var state_61252__$1 = state_61252;
var statearr_61280_61352 = state_61252__$1;
(statearr_61280_61352[(2)] = inst_61204);

(statearr_61280_61352[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (44))){
var inst_61164 = (state_61252[(9)]);
var inst_61153 = (state_61252[(10)]);
var inst_61239 = (state_61252[(2)]);
var inst_61240 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_61153,inst_61164,inst_61239);
var state_61252__$1 = state_61252;
var statearr_61281_61353 = state_61252__$1;
(statearr_61281_61353[(2)] = inst_61240);

(statearr_61281_61353[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (6))){
var inst_61150 = (state_61252[(19)]);
var inst_61165 = (state_61252[(20)]);
var inst_61161 = cljs.core.seq(inst_61150);
var inst_61162 = cljs.core.first(inst_61161);
var inst_61163 = cljs.core.next(inst_61161);
var inst_61164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61162,(0),null);
var inst_61165__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61162,(1),null);
var inst_61166 = (inst_61165__$1 == null);
var state_61252__$1 = (function (){var statearr_61282 = state_61252;
(statearr_61282[(9)] = inst_61164);

(statearr_61282[(16)] = inst_61163);

(statearr_61282[(20)] = inst_61165__$1);

return statearr_61282;
})();
if(cljs.core.truth_(inst_61166)){
var statearr_61283_61354 = state_61252__$1;
(statearr_61283_61354[(1)] = (8));

} else {
var statearr_61284_61355 = state_61252__$1;
(statearr_61284_61355[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (28))){
var inst_61151 = (state_61252[(12)]);
var inst_61202 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_61151);
var state_61252__$1 = state_61252;
var statearr_61285_61356 = state_61252__$1;
(statearr_61285_61356[(2)] = inst_61202);

(statearr_61285_61356[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (25))){
var inst_61151 = (state_61252[(12)]);
var inst_61199 = (state_61252[(7)]);
var inst_61199__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_61151);
var state_61252__$1 = (function (){var statearr_61286 = state_61252;
(statearr_61286[(7)] = inst_61199__$1);

return statearr_61286;
})();
if(inst_61199__$1){
var statearr_61287_61357 = state_61252__$1;
(statearr_61287_61357[(1)] = (27));

} else {
var statearr_61288_61358 = state_61252__$1;
(statearr_61288_61358[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (34))){
var state_61252__$1 = state_61252;
var statearr_61289_61359 = state_61252__$1;
(statearr_61289_61359[(2)] = null);

(statearr_61289_61359[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (17))){
var inst_61183 = (state_61252[(21)]);
var inst_61222 = (state_61252[(2)]);
var state_61252__$1 = (function (){var statearr_61290 = state_61252;
(statearr_61290[(17)] = inst_61222);

return statearr_61290;
})();
if(cljs.core.truth_(inst_61183)){
var statearr_61291_61360 = state_61252__$1;
(statearr_61291_61360[(1)] = (36));

} else {
var statearr_61292_61361 = state_61252__$1;
(statearr_61292_61361[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (3))){
var inst_61250 = (state_61252[(2)]);
var state_61252__$1 = state_61252;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61252__$1,inst_61250);
} else {
if((state_val_61253 === (12))){
var inst_61153 = (state_61252[(10)]);
var state_61252__$1 = state_61252;
var statearr_61293_61362 = state_61252__$1;
(statearr_61293_61362[(2)] = inst_61153);

(statearr_61293_61362[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (2))){
var inst_61126 = (state_61252[(22)]);
var inst_61127 = (state_61252[(23)]);
var inst_61122 = (state_61252[(24)]);
var _ = (function (){var statearr_61294 = state_61252;
(statearr_61294[(4)] = cljs.core.cons((5),(state_61252[(4)])));

return statearr_61294;
})();
var inst_61118 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_61119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61120 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_61121 = (new cljs.core.PersistentVector(null,2,(5),inst_61119,inst_61120,null));
var inst_61122__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_61121);
var inst_61123 = (function (){var global_block = inst_61118;
var global_meta_QMARK_ = inst_61122__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4253__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4251__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4251__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_61124 = cljs.core.PersistentHashMap.EMPTY;
var inst_61125 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_61126__$1 = cljs.core.reduce_kv(inst_61123,inst_61124,inst_61125);
var inst_61127__$1 = fluree.db.util.core.current_time_millis();
var inst_61129 = (function (){var global_block = inst_61118;
var global_meta_QMARK_ = inst_61122__$1;
var queries = inst_61126__$1;
var start_time = inst_61127__$1;
return (function (p__61128){
var vec__61295 = p__61128;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61295,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61295,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_61130 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_61129,inst_61126__$1);
var inst_61144 = cljs.core.seq(inst_61130);
var inst_61145 = cljs.core.first(inst_61144);
var inst_61146 = cljs.core.next(inst_61144);
var inst_61147 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61145,(0),null);
var inst_61148 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61145,(1),null);
var inst_61149 = cljs.core.PersistentHashMap.EMPTY;
var inst_61150 = inst_61130;
var inst_61151 = null;
var inst_61152 = (0);
var inst_61153 = inst_61149;
var state_61252__$1 = (function (){var statearr_61298 = state_61252;
(statearr_61298[(12)] = inst_61151);

(statearr_61298[(22)] = inst_61126__$1);

(statearr_61298[(19)] = inst_61150);

(statearr_61298[(15)] = inst_61152);

(statearr_61298[(23)] = inst_61127__$1);

(statearr_61298[(25)] = inst_61147);

(statearr_61298[(26)] = inst_61146);

(statearr_61298[(27)] = inst_61148);

(statearr_61298[(10)] = inst_61153);

(statearr_61298[(24)] = inst_61122__$1);

return statearr_61298;
})();
var statearr_61299_61363 = state_61252__$1;
(statearr_61299_61363[(2)] = null);

(statearr_61299_61363[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (23))){
var inst_61217 = (state_61252[(2)]);
var state_61252__$1 = state_61252;
var statearr_61300_61364 = state_61252__$1;
(statearr_61300_61364[(2)] = inst_61217);

(statearr_61300_61364[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (35))){
var inst_61213 = (state_61252[(2)]);
var state_61252__$1 = state_61252;
var statearr_61301_61365 = state_61252__$1;
(statearr_61301_61365[(2)] = inst_61213);

(statearr_61301_61365[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (19))){
var inst_61151 = (state_61252[(12)]);
var inst_61189 = (state_61252[(13)]);
var inst_61193 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61151,inst_61189);
var state_61252__$1 = state_61252;
if(inst_61193){
var statearr_61302_61366 = state_61252__$1;
(statearr_61302_61366[(1)] = (21));

} else {
var statearr_61303_61367 = state_61252__$1;
(statearr_61303_61367[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (11))){
var inst_61151 = (state_61252[(12)]);
var inst_61152 = (state_61252[(15)]);
var inst_61127 = (state_61252[(23)]);
var inst_61153 = (state_61252[(10)]);
var inst_61169 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61170 = fluree.db.util.core.response_time_formatted(inst_61127);
var inst_61171 = [inst_61153,inst_61152,inst_61151,inst_61170];
var inst_61172 = cljs.core.PersistentHashMap.fromArrays(inst_61169,inst_61171);
var state_61252__$1 = state_61252;
var statearr_61305_61368 = state_61252__$1;
(statearr_61305_61368[(2)] = inst_61172);

(statearr_61305_61368[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (9))){
var inst_61126 = (state_61252[(22)]);
var inst_61164 = (state_61252[(9)]);
var inst_61165 = (state_61252[(20)]);
var inst_61178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61179 = [inst_61164,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_61180 = (new cljs.core.PersistentVector(null,2,(5),inst_61178,inst_61179,null));
var inst_61181 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61126,inst_61180);
var inst_61182 = cljs.core.__destructure_map(inst_61181);
var inst_61183 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61182,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_61184 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61182,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_61252__$1 = (function (){var statearr_61306 = state_61252;
(statearr_61306[(14)] = inst_61184);

(statearr_61306[(21)] = inst_61183);

return statearr_61306;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61252__$1,(14),inst_61165);
} else {
if((state_val_61253 === (5))){
var _ = (function (){var statearr_61307 = state_61252;
(statearr_61307[(4)] = cljs.core.rest((state_61252[(4)])));

return statearr_61307;
})();
var state_61252__$1 = state_61252;
var ex61304 = (state_61252__$1[(2)]);
var statearr_61308_61369 = state_61252__$1;
(statearr_61308_61369[(5)] = ex61304);


var statearr_61309_61370 = state_61252__$1;
(statearr_61309_61370[(1)] = (4));

(statearr_61309_61370[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (14))){
var inst_61183 = (state_61252[(21)]);
var inst_61186 = (state_61252[(11)]);
var inst_61186__$1 = (state_61252[(2)]);
var inst_61187 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_61186__$1);
var state_61252__$1 = (function (){var statearr_61310 = state_61252;
(statearr_61310[(28)] = inst_61187);

(statearr_61310[(11)] = inst_61186__$1);

return statearr_61310;
})();
if(cljs.core.truth_(inst_61183)){
var statearr_61311_61371 = state_61252__$1;
(statearr_61311_61371[(1)] = (15));

} else {
var statearr_61312_61372 = state_61252__$1;
(statearr_61312_61372[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (26))){
var inst_61206 = (state_61252[(2)]);
var state_61252__$1 = state_61252;
if(cljs.core.truth_(inst_61206)){
var statearr_61313_61373 = state_61252__$1;
(statearr_61313_61373[(1)] = (30));

} else {
var statearr_61314_61374 = state_61252__$1;
(statearr_61314_61374[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (16))){
var state_61252__$1 = state_61252;
var statearr_61315_61375 = state_61252__$1;
(statearr_61315_61375[(2)] = null);

(statearr_61315_61375[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (38))){
var inst_61187 = (state_61252[(28)]);
var inst_61228 = (state_61252[(2)]);
var state_61252__$1 = (function (){var statearr_61316 = state_61252;
(statearr_61316[(18)] = inst_61228);

return statearr_61316;
})();
if(cljs.core.truth_(inst_61187)){
var statearr_61317_61376 = state_61252__$1;
(statearr_61317_61376[(1)] = (39));

} else {
var statearr_61318_61377 = state_61252__$1;
(statearr_61318_61377[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (30))){
var state_61252__$1 = state_61252;
var statearr_61319_61378 = state_61252__$1;
(statearr_61319_61378[(2)] = (207));

(statearr_61319_61378[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (10))){
var inst_61245 = (state_61252[(2)]);
var state_61252__$1 = state_61252;
var statearr_61320_61379 = state_61252__$1;
(statearr_61320_61379[(2)] = inst_61245);

(statearr_61320_61379[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (18))){
var inst_61189 = (state_61252[(13)]);
var state_61252__$1 = state_61252;
var statearr_61321_61380 = state_61252__$1;
(statearr_61321_61380[(2)] = inst_61189);

(statearr_61321_61380[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (42))){
var inst_61186 = (state_61252[(11)]);
var inst_61236 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_61186);
var state_61252__$1 = state_61252;
var statearr_61322_61381 = state_61252__$1;
(statearr_61322_61381[(2)] = inst_61236);

(statearr_61322_61381[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (37))){
var state_61252__$1 = state_61252;
var statearr_61323_61382 = state_61252__$1;
(statearr_61323_61382[(2)] = null);

(statearr_61323_61382[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61253 === (8))){
var inst_61122 = (state_61252[(24)]);
var state_61252__$1 = state_61252;
if(cljs.core.truth_(inst_61122)){
var statearr_61324_61383 = state_61252__$1;
(statearr_61324_61383[(1)] = (11));

} else {
var statearr_61325_61384 = state_61252__$1;
(statearr_61325_61384[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2741__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2741__auto____0 = (function (){
var statearr_61326 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61326[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2741__auto__);

(statearr_61326[(1)] = (1));

return statearr_61326;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2741__auto____1 = (function (state_61252){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_61252);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61327){var ex__2744__auto__ = e61327;
var statearr_61328_61385 = state_61252;
(statearr_61328_61385[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_61252[(4)]))){
var statearr_61329_61386 = state_61252;
(statearr_61329_61386[(1)] = cljs.core.first((state_61252[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61387 = state_61252;
state_61252 = G__61387;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2741__auto__ = function(state_61252){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2741__auto____1.call(this,state_61252);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2741__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2741__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61330 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_61330[(6)] = c__2763__auto__);

return statearr_61330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__61388 = query_type;
var G__61388__$1 = (((G__61388 instanceof cljs.core.Keyword))?G__61388.fqn:null);
switch (G__61388__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61388__$1)].join('')));

}
});
