// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__62498 = arguments.length;
switch (G__62498) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62540){
var state_val_62541 = (state_62540[(1)]);
if((state_val_62541 === (7))){
var inst_62510 = typeof user === 'string';
var state_62540__$1 = state_62540;
if(cljs.core.truth_(inst_62510)){
var statearr_62542_62571 = state_62540__$1;
(statearr_62542_62571[(1)] = (9));

} else {
var statearr_62543_62572 = state_62540__$1;
(statearr_62543_62572[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (1))){
var state_62540__$1 = state_62540;
var statearr_62544_62573 = state_62540__$1;
(statearr_62544_62573[(2)] = null);

(statearr_62544_62573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (4))){
var inst_62499 = (state_62540[(2)]);
var inst_62500 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62499], 0));
var inst_62501 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62499) : reject.call(null,inst_62499));
var state_62540__$1 = (function (){var statearr_62545 = state_62540;
(statearr_62545[(7)] = inst_62500);

return statearr_62545;
})();
var statearr_62546_62574 = state_62540__$1;
(statearr_62546_62574[(2)] = inst_62501);

(statearr_62546_62574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (15))){
var inst_62529 = (state_62540[(2)]);
var inst_62530 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_62529);
var inst_62531 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62532 = cljs.core.constantly(inst_62530);
var inst_62533 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62531,inst_62532);
var inst_62534 = fluree.db.connection.add_token(conn,inst_62530);
var inst_62535 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_62529) : resolve.call(null,inst_62529));
var _ = (function (){var statearr_62547 = state_62540;
(statearr_62547[(4)] = cljs.core.rest((state_62540[(4)])));

return statearr_62547;
})();
var state_62540__$1 = (function (){var statearr_62548 = state_62540;
(statearr_62548[(8)] = inst_62533);

(statearr_62548[(9)] = inst_62534);

return statearr_62548;
})();
var statearr_62549_62575 = state_62540__$1;
(statearr_62549_62575[(2)] = inst_62535);

(statearr_62549_62575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (13))){
var state_62540__$1 = state_62540;
var statearr_62550_62576 = state_62540__$1;
(statearr_62550_62576[(2)] = null);

(statearr_62550_62576[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (6))){
var state_62540__$1 = state_62540;
var statearr_62551_62577 = state_62540__$1;
(statearr_62551_62577[(2)] = user);

(statearr_62551_62577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (3))){
var inst_62538 = (state_62540[(2)]);
var state_62540__$1 = state_62540;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62540__$1,inst_62538);
} else {
if((state_val_62541 === (12))){
var state_62540__$1 = state_62540;
var statearr_62552_62578 = state_62540__$1;
(statearr_62552_62578[(2)] = user);

(statearr_62552_62578[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (2))){
var _ = (function (){var statearr_62553 = state_62540;
(statearr_62553[(4)] = cljs.core.cons((5),(state_62540[(4)])));

return statearr_62553;
})();
var inst_62507 = typeof user === 'number';
var state_62540__$1 = state_62540;
if(cljs.core.truth_(inst_62507)){
var statearr_62554_62579 = state_62540__$1;
(statearr_62554_62579[(1)] = (6));

} else {
var statearr_62555_62580 = state_62540__$1;
(statearr_62555_62580[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (11))){
var inst_62521 = (state_62540[(2)]);
var state_62540__$1 = state_62540;
var statearr_62557_62581 = state_62540__$1;
(statearr_62557_62581[(2)] = inst_62521);

(statearr_62557_62581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (9))){
var inst_62512 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62513 = ["_user/username",user];
var inst_62514 = (new cljs.core.PersistentVector(null,2,(5),inst_62512,inst_62513,null));
var state_62540__$1 = state_62540;
var statearr_62558_62582 = state_62540__$1;
(statearr_62558_62582[(2)] = inst_62514);

(statearr_62558_62582[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (5))){
var _ = (function (){var statearr_62559 = state_62540;
(statearr_62559[(4)] = cljs.core.rest((state_62540[(4)])));

return statearr_62559;
})();
var state_62540__$1 = state_62540;
var ex62556 = (state_62540__$1[(2)]);
var statearr_62560_62583 = state_62540__$1;
(statearr_62560_62583[(5)] = ex62556);


var statearr_62561_62584 = state_62540__$1;
(statearr_62561_62584[(1)] = (4));

(statearr_62561_62584[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (14))){
var inst_62519 = (state_62540[(2)]);
var state_62540__$1 = state_62540;
var statearr_62562_62585 = state_62540__$1;
(statearr_62562_62585[(2)] = inst_62519);

(statearr_62562_62585[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (10))){
var state_62540__$1 = state_62540;
var statearr_62563_62586 = state_62540__$1;
(statearr_62563_62586[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62541 === (8))){
var inst_62523 = (state_62540[(2)]);
var inst_62524 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_62525 = [account,inst_62523,password,expireSeconds,syncTo];
var inst_62526 = cljs.core.PersistentHashMap.fromArrays(inst_62524,inst_62525);
var inst_62527 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_62526);
var state_62540__$1 = state_62540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62540__$1,(15),inst_62527);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_62565 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62565[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_62565[(1)] = (1));

return statearr_62565;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_62540){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62540);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62566){var ex__2744__auto__ = e62566;
var statearr_62567_62587 = state_62540;
(statearr_62567_62587[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62540[(4)]))){
var statearr_62568_62588 = state_62540;
(statearr_62568_62588[(1)] = cljs.core.first((state_62540[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62589 = state_62540;
state_62540 = G__62589;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_62540){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_62540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62569 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62569[(6)] = c__2763__auto__);

return statearr_62569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__62591 = arguments.length;
switch (G__62591) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62600){
var state_val_62601 = (state_62600[(1)]);
if((state_val_62601 === (1))){
var inst_62592 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62594 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_62595 = (new cljs.core.PersistentVector(null,4,(5),inst_62593,inst_62594,null));
var inst_62596 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62592,inst_62595);
var inst_62597 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__62602 = cljs.core.seq(cljs.core.keys(x));
var chunk__62603 = null;
var count__62604 = (0);
var i__62605 = (0);
while(true){
if((i__62605 < count__62604)){
var k = chunk__62603.cljs$core$IIndexed$_nth$arity$2(null,i__62605);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__62613 = seq__62602;
var G__62614 = chunk__62603;
var G__62615 = count__62604;
var G__62616 = (i__62605 + (1));
seq__62602 = G__62613;
chunk__62603 = G__62614;
count__62604 = G__62615;
i__62605 = G__62616;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__62602);
if(temp__5753__auto__){
var seq__62602__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__62602__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__62602__$1);
var G__62617 = cljs.core.chunk_rest(seq__62602__$1);
var G__62618 = c__4679__auto__;
var G__62619 = cljs.core.count(c__4679__auto__);
var G__62620 = (0);
seq__62602 = G__62617;
chunk__62603 = G__62618;
count__62604 = G__62619;
i__62605 = G__62620;
continue;
} else {
var k = cljs.core.first(seq__62602__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__62621 = cljs.core.next(seq__62602__$1);
var G__62622 = null;
var G__62623 = (0);
var G__62624 = (0);
seq__62602 = G__62621;
chunk__62603 = G__62622;
count__62604 = G__62623;
i__62605 = G__62624;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_62598 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_62597);
var state_62600__$1 = (function (){var statearr_62606 = state_62600;
(statearr_62606[(7)] = inst_62596);

return statearr_62606;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_62600__$1,inst_62598);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_62607 = [null,null,null,null,null,null,null,null];
(statearr_62607[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_62607[(1)] = (1));

return statearr_62607;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_62600){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62600);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62608){var ex__2744__auto__ = e62608;
var statearr_62609_62625 = state_62600;
(statearr_62609_62625[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62600[(4)]))){
var statearr_62610_62626 = state_62600;
(statearr_62610_62626[(1)] = cljs.core.first((state_62600[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62627 = state_62600;
state_62600 = G__62627;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_62600){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_62600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62611 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62611[(6)] = c__2763__auto__);

return statearr_62611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__62629 = arguments.length;
switch (G__62629) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62663){
var state_val_62664 = (state_62663[(1)]);
if((state_val_62664 === (1))){
var state_62663__$1 = state_62663;
var statearr_62665_62686 = state_62663__$1;
(statearr_62665_62686[(2)] = null);

(statearr_62665_62686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62664 === (2))){
var _ = (function (){var statearr_62666 = state_62663;
(statearr_62666[(4)] = cljs.core.cons((5),(state_62663[(4)])));

return statearr_62666;
})();
var inst_62638 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_62639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62640 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_62641 = (new cljs.core.PersistentVector(null,1,(5),inst_62639,inst_62640,null));
var inst_62642 = cljs.core.PersistentHashMap.EMPTY;
var inst_62643 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_62642);
var inst_62644 = cljs.core.assoc_in(inst_62638,inst_62641,inst_62643);
var inst_62645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62646 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62647 = (new cljs.core.PersistentVector(null,1,(5),inst_62645,inst_62646,null));
var inst_62648 = cljs.core.PersistentHashMap.EMPTY;
var inst_62649 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_62648);
var inst_62650 = cljs.core.assoc_in(inst_62644,inst_62647,inst_62649);
var inst_62651 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62652 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_62650);
var inst_62653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62654 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_62651,null];
var inst_62655 = (new cljs.core.PersistentVector(null,4,(5),inst_62653,inst_62654,null));
var inst_62656 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62652,inst_62655);
var inst_62657 = (function (){var conn = inst_62650;
var pc = inst_62651;
return (function (x){
if((x == null)){
} else {
var seq__62667_62687 = cljs.core.seq(cljs.core.keys(x));
var chunk__62668_62688 = null;
var count__62669_62689 = (0);
var i__62670_62690 = (0);
while(true){
if((i__62670_62690 < count__62669_62689)){
var k_62691 = chunk__62668_62688.cljs$core$IIndexed$_nth$arity$2(null,i__62670_62690);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62691], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_62691,null));


var G__62692 = seq__62667_62687;
var G__62693 = chunk__62668_62688;
var G__62694 = count__62669_62689;
var G__62695 = (i__62670_62690 + (1));
seq__62667_62687 = G__62692;
chunk__62668_62688 = G__62693;
count__62669_62689 = G__62694;
i__62670_62690 = G__62695;
continue;
} else {
var temp__5753__auto___62696 = cljs.core.seq(seq__62667_62687);
if(temp__5753__auto___62696){
var seq__62667_62697__$1 = temp__5753__auto___62696;
if(cljs.core.chunked_seq_QMARK_(seq__62667_62697__$1)){
var c__4679__auto___62698 = cljs.core.chunk_first(seq__62667_62697__$1);
var G__62699 = cljs.core.chunk_rest(seq__62667_62697__$1);
var G__62700 = c__4679__auto___62698;
var G__62701 = cljs.core.count(c__4679__auto___62698);
var G__62702 = (0);
seq__62667_62687 = G__62699;
chunk__62668_62688 = G__62700;
count__62669_62689 = G__62701;
i__62670_62690 = G__62702;
continue;
} else {
var k_62703 = cljs.core.first(seq__62667_62697__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62703], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_62703,null));


var G__62704 = cljs.core.next(seq__62667_62697__$1);
var G__62705 = null;
var G__62706 = (0);
var G__62707 = (0);
seq__62667_62687 = G__62704;
chunk__62668_62688 = G__62705;
count__62669_62689 = G__62706;
i__62670_62690 = G__62707;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_62658 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62651,inst_62657);
var ___$1 = (function (){var statearr_62671 = state_62663;
(statearr_62671[(4)] = cljs.core.rest((state_62663[(4)])));

return statearr_62671;
})();
var state_62663__$1 = (function (){var statearr_62672 = state_62663;
(statearr_62672[(7)] = inst_62656);

return statearr_62672;
})();
var statearr_62673_62708 = state_62663__$1;
(statearr_62673_62708[(2)] = inst_62658);

(statearr_62673_62708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62664 === (3))){
var inst_62661 = (state_62663[(2)]);
var state_62663__$1 = state_62663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62663__$1,inst_62661);
} else {
if((state_val_62664 === (4))){
var inst_62630 = (state_62663[(2)]);
var inst_62631 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62630], 0));
var inst_62632 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62630) : reject.call(null,inst_62630));
var state_62663__$1 = (function (){var statearr_62675 = state_62663;
(statearr_62675[(8)] = inst_62631);

return statearr_62675;
})();
var statearr_62676_62709 = state_62663__$1;
(statearr_62676_62709[(2)] = inst_62632);

(statearr_62676_62709[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62664 === (5))){
var _ = (function (){var statearr_62677 = state_62663;
(statearr_62677[(4)] = cljs.core.rest((state_62663[(4)])));

return statearr_62677;
})();
var state_62663__$1 = state_62663;
var ex62674 = (state_62663__$1[(2)]);
var statearr_62678_62710 = state_62663__$1;
(statearr_62678_62710[(5)] = ex62674);


var statearr_62679_62711 = state_62663__$1;
(statearr_62679_62711[(1)] = (4));

(statearr_62679_62711[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_62680 = [null,null,null,null,null,null,null,null,null];
(statearr_62680[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_62680[(1)] = (1));

return statearr_62680;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_62663){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62663);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62681){var ex__2744__auto__ = e62681;
var statearr_62682_62712 = state_62663;
(statearr_62682_62712[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62663[(4)]))){
var statearr_62683_62713 = state_62663;
(statearr_62683_62713[(1)] = cljs.core.first((state_62663[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62714 = state_62663;
state_62663 = G__62714;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_62663){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_62663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62684 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62684[(6)] = c__2763__auto__);

return statearr_62684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__62716 = arguments.length;
switch (G__62716) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__62718 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62718,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62718,(1),null);
var cb_STAR_ = (function (header,data){
var G__62721 = cljs.core.clj__GT_js(header);
var G__62722 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__62721,G__62722) : callback.call(null,G__62721,G__62722));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__62723 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62723,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62723,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62776){
var state_val_62777 = (state_62776[(1)]);
if((state_val_62777 === (7))){
var inst_62737 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62738 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62739 = cljs.core.PersistentHashMap.fromArrays(inst_62737,inst_62738);
var inst_62740 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_62739);
var inst_62741 = (function(){throw inst_62740})();
var state_62776__$1 = state_62776;
var statearr_62778_62810 = state_62776__$1;
(statearr_62778_62810[(2)] = inst_62741);

(statearr_62778_62810[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62777 === (1))){
var state_62776__$1 = state_62776;
var statearr_62779_62811 = state_62776__$1;
(statearr_62779_62811[(2)] = null);

(statearr_62779_62811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62777 === (4))){
var inst_62726 = (state_62776[(2)]);
var inst_62727 = cljs.core.clj__GT_js(inst_62726);
var inst_62728 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62727) : reject.call(null,inst_62727));
var state_62776__$1 = state_62776;
var statearr_62780_62812 = state_62776__$1;
(statearr_62780_62812[(2)] = inst_62728);

(statearr_62780_62812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62777 === (13))){
var inst_62755 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62756 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62757 = cljs.core.PersistentHashMap.fromArrays(inst_62755,inst_62756);
var inst_62758 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_62757);
var inst_62759 = (function(){throw inst_62758})();
var state_62776__$1 = state_62776;
var statearr_62781_62813 = state_62776__$1;
(statearr_62781_62813[(2)] = inst_62759);

(statearr_62781_62813[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62777 === (6))){
var state_62776__$1 = state_62776;
var statearr_62782_62814 = state_62776__$1;
(statearr_62782_62814[(2)] = null);

(statearr_62782_62814[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62777 === (3))){
var inst_62774 = (state_62776[(2)]);
var state_62776__$1 = state_62776;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62776__$1,inst_62774);
} else {
if((state_val_62777 === (12))){
var state_62776__$1 = state_62776;
var statearr_62783_62815 = state_62776__$1;
(statearr_62783_62815[(2)] = null);

(statearr_62783_62815[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62777 === (2))){
var _ = (function (){var statearr_62784 = state_62776;
(statearr_62784[(4)] = cljs.core.cons((5),(state_62776[(4)])));

return statearr_62784;
})();
var inst_62734 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_62776__$1 = state_62776;
if(cljs.core.truth_(inst_62734)){
var statearr_62785_62816 = state_62776__$1;
(statearr_62785_62816[(1)] = (6));

} else {
var statearr_62786_62817 = state_62776__$1;
(statearr_62786_62817[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62777 === (11))){
var inst_62752 = (state_62776[(2)]);
var state_62776__$1 = (function (){var statearr_62788 = state_62776;
(statearr_62788[(7)] = inst_62752);

return statearr_62788;
})();
if(cljs.core.truth_(password)){
var statearr_62789_62818 = state_62776__$1;
(statearr_62789_62818[(1)] = (12));

} else {
var statearr_62790_62819 = state_62776__$1;
(statearr_62790_62819[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62777 === (9))){
var state_62776__$1 = state_62776;
var statearr_62791_62820 = state_62776__$1;
(statearr_62791_62820[(2)] = null);

(statearr_62791_62820[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62777 === (5))){
var _ = (function (){var statearr_62792 = state_62776;
(statearr_62792[(4)] = cljs.core.rest((state_62776[(4)])));

return statearr_62792;
})();
var state_62776__$1 = state_62776;
var ex62787 = (state_62776__$1[(2)]);
var statearr_62793_62821 = state_62776__$1;
(statearr_62793_62821[(5)] = ex62787);


var statearr_62794_62822 = state_62776__$1;
(statearr_62794_62822[(1)] = (4));

(statearr_62794_62822[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62777 === (14))){
var inst_62761 = (state_62776[(2)]);
var inst_62762 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_62763 = fluree.db.util.core.without_nils(inst_62762);
var inst_62764 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62765 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62767 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_62763,inst_62764,null];
var inst_62768 = (new cljs.core.PersistentVector(null,4,(5),inst_62766,inst_62767,null));
var inst_62769 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62765,inst_62768);
var inst_62770 = (function (){var _ = inst_62761;
var data = inst_62763;
var pc = inst_62764;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__62795 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62795) : reject.call(null,G__62795));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__62796 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62796) : reject.call(null,G__62796));
} else {
var G__62797 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__62797) : resolve.call(null,G__62797));

}
}
});
})();
var inst_62771 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62764,inst_62770);
var _ = (function (){var statearr_62798 = state_62776;
(statearr_62798[(4)] = cljs.core.rest((state_62776[(4)])));

return statearr_62798;
})();
var state_62776__$1 = (function (){var statearr_62799 = state_62776;
(statearr_62799[(8)] = inst_62769);

return statearr_62799;
})();
var statearr_62800_62823 = state_62776__$1;
(statearr_62800_62823[(2)] = inst_62771);

(statearr_62800_62823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62777 === (10))){
var inst_62746 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62747 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62748 = cljs.core.PersistentHashMap.fromArrays(inst_62746,inst_62747);
var inst_62749 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_62748);
var inst_62750 = (function(){throw inst_62749})();
var state_62776__$1 = state_62776;
var statearr_62801_62824 = state_62776__$1;
(statearr_62801_62824[(2)] = inst_62750);

(statearr_62801_62824[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62777 === (8))){
var inst_62743 = (state_62776[(2)]);
var state_62776__$1 = (function (){var statearr_62802 = state_62776;
(statearr_62802[(9)] = inst_62743);

return statearr_62802;
})();
if(cljs.core.truth_(ledger)){
var statearr_62803_62825 = state_62776__$1;
(statearr_62803_62825[(1)] = (9));

} else {
var statearr_62804_62826 = state_62776__$1;
(statearr_62804_62826[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2741__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2741__auto____0 = (function (){
var statearr_62805 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62805[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2741__auto__);

(statearr_62805[(1)] = (1));

return statearr_62805;
});
var fluree$db$connection_js$password_generate_$_state_machine__2741__auto____1 = (function (state_62776){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62776);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62806){var ex__2744__auto__ = e62806;
var statearr_62807_62827 = state_62776;
(statearr_62807_62827[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62776[(4)]))){
var statearr_62808_62828 = state_62776;
(statearr_62808_62828[(1)] = cljs.core.first((state_62776[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62829 = state_62776;
state_62776 = G__62829;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2741__auto__ = function(state_62776){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2741__auto____1.call(this,state_62776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2741__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2741__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62809 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62809[(6)] = c__2763__auto__);

return statearr_62809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__62831 = arguments.length;
switch (G__62831) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62898){
var state_val_62899 = (state_62898[(1)]);
if((state_val_62899 === (7))){
var inst_62843 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62844 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62845 = cljs.core.PersistentHashMap.fromArrays(inst_62843,inst_62844);
var inst_62846 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_62845);
var inst_62847 = (function(){throw inst_62846})();
var state_62898__$1 = state_62898;
var statearr_62900_62942 = state_62898__$1;
(statearr_62900_62942[(2)] = inst_62847);

(statearr_62900_62942[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (20))){
var inst_62881 = (state_62898[(2)]);
var inst_62882 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_62883 = [ledger,password,user,auth,expire];
var inst_62884 = cljs.core.PersistentHashMap.fromArrays(inst_62882,inst_62883);
var inst_62885 = fluree.db.util.core.without_nils(inst_62884);
var inst_62886 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62887 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62889 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_62885,inst_62886,null];
var inst_62890 = (new cljs.core.PersistentVector(null,4,(5),inst_62888,inst_62889,null));
var inst_62891 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62887,inst_62890);
var inst_62892 = (function (){var _ = inst_62881;
var data = inst_62885;
var pc = inst_62886;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__62901 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62901) : reject.call(null,G__62901));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__62902 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62902) : reject.call(null,G__62902));
} else {
fluree.db.connection.add_token(conn,result);

var G__62903 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__62903) : resolve.call(null,G__62903));

}
}
});
})();
var inst_62893 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62886,inst_62892);
var _ = (function (){var statearr_62904 = state_62898;
(statearr_62904[(4)] = cljs.core.rest((state_62898[(4)])));

return statearr_62904;
})();
var state_62898__$1 = (function (){var statearr_62905 = state_62898;
(statearr_62905[(7)] = inst_62891);

return statearr_62905;
})();
var statearr_62906_62943 = state_62898__$1;
(statearr_62906_62943[(2)] = inst_62893);

(statearr_62906_62943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (1))){
var state_62898__$1 = state_62898;
var statearr_62907_62944 = state_62898__$1;
(statearr_62907_62944[(2)] = null);

(statearr_62907_62944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (4))){
var inst_62832 = (state_62898[(2)]);
var inst_62833 = cljs.core.clj__GT_js(inst_62832);
var inst_62834 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62833) : reject.call(null,inst_62833));
var state_62898__$1 = state_62898;
var statearr_62908_62945 = state_62898__$1;
(statearr_62908_62945[(2)] = inst_62834);

(statearr_62908_62945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (15))){
var inst_62868 = (state_62898[(8)]);
var state_62898__$1 = state_62898;
var statearr_62909_62946 = state_62898__$1;
(statearr_62909_62946[(2)] = inst_62868);

(statearr_62909_62946[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (13))){
var inst_62861 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62862 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62863 = cljs.core.PersistentHashMap.fromArrays(inst_62861,inst_62862);
var inst_62864 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_62863);
var inst_62865 = (function(){throw inst_62864})();
var state_62898__$1 = state_62898;
var statearr_62910_62947 = state_62898__$1;
(statearr_62910_62947[(2)] = inst_62865);

(statearr_62910_62947[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (6))){
var state_62898__$1 = state_62898;
var statearr_62911_62948 = state_62898__$1;
(statearr_62911_62948[(2)] = null);

(statearr_62911_62948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (17))){
var inst_62872 = (state_62898[(2)]);
var state_62898__$1 = state_62898;
if(cljs.core.truth_(inst_62872)){
var statearr_62912_62949 = state_62898__$1;
(statearr_62912_62949[(1)] = (18));

} else {
var statearr_62913_62950 = state_62898__$1;
(statearr_62913_62950[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (3))){
var inst_62896 = (state_62898[(2)]);
var state_62898__$1 = state_62898;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62898__$1,inst_62896);
} else {
if((state_val_62899 === (12))){
var state_62898__$1 = state_62898;
var statearr_62914_62951 = state_62898__$1;
(statearr_62914_62951[(2)] = null);

(statearr_62914_62951[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (2))){
var _ = (function (){var statearr_62915 = state_62898;
(statearr_62915[(4)] = cljs.core.cons((5),(state_62898[(4)])));

return statearr_62915;
})();
var inst_62840 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_62898__$1 = state_62898;
if(cljs.core.truth_(inst_62840)){
var statearr_62916_62952 = state_62898__$1;
(statearr_62916_62952[(1)] = (6));

} else {
var statearr_62917_62953 = state_62898__$1;
(statearr_62917_62953[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (19))){
var inst_62875 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62876 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62877 = cljs.core.PersistentHashMap.fromArrays(inst_62875,inst_62876);
var inst_62878 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_62877);
var inst_62879 = (function(){throw inst_62878})();
var state_62898__$1 = state_62898;
var statearr_62918_62954 = state_62898__$1;
(statearr_62918_62954[(2)] = inst_62879);

(statearr_62918_62954[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (11))){
var inst_62858 = (state_62898[(2)]);
var state_62898__$1 = (function (){var statearr_62920 = state_62898;
(statearr_62920[(9)] = inst_62858);

return statearr_62920;
})();
if(cljs.core.truth_(password)){
var statearr_62921_62955 = state_62898__$1;
(statearr_62921_62955[(1)] = (12));

} else {
var statearr_62922_62956 = state_62898__$1;
(statearr_62922_62956[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (9))){
var state_62898__$1 = state_62898;
var statearr_62923_62957 = state_62898__$1;
(statearr_62923_62957[(2)] = null);

(statearr_62923_62957[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (5))){
var _ = (function (){var statearr_62924 = state_62898;
(statearr_62924[(4)] = cljs.core.rest((state_62898[(4)])));

return statearr_62924;
})();
var state_62898__$1 = state_62898;
var ex62919 = (state_62898__$1[(2)]);
var statearr_62925_62958 = state_62898__$1;
(statearr_62925_62958[(5)] = ex62919);


var statearr_62926_62959 = state_62898__$1;
(statearr_62926_62959[(1)] = (4));

(statearr_62926_62959[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (14))){
var inst_62868 = (state_62898[(8)]);
var inst_62867 = (state_62898[(2)]);
var inst_62868__$1 = user;
var state_62898__$1 = (function (){var statearr_62927 = state_62898;
(statearr_62927[(10)] = inst_62867);

(statearr_62927[(8)] = inst_62868__$1);

return statearr_62927;
})();
if(cljs.core.truth_(inst_62868__$1)){
var statearr_62928_62960 = state_62898__$1;
(statearr_62928_62960[(1)] = (15));

} else {
var statearr_62929_62961 = state_62898__$1;
(statearr_62929_62961[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (16))){
var state_62898__$1 = state_62898;
var statearr_62930_62962 = state_62898__$1;
(statearr_62930_62962[(2)] = auth);

(statearr_62930_62962[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (10))){
var inst_62852 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62853 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62854 = cljs.core.PersistentHashMap.fromArrays(inst_62852,inst_62853);
var inst_62855 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_62854);
var inst_62856 = (function(){throw inst_62855})();
var state_62898__$1 = state_62898;
var statearr_62931_62963 = state_62898__$1;
(statearr_62931_62963[(2)] = inst_62856);

(statearr_62931_62963[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (18))){
var state_62898__$1 = state_62898;
var statearr_62932_62964 = state_62898__$1;
(statearr_62932_62964[(2)] = null);

(statearr_62932_62964[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62899 === (8))){
var inst_62849 = (state_62898[(2)]);
var state_62898__$1 = (function (){var statearr_62933 = state_62898;
(statearr_62933[(11)] = inst_62849);

return statearr_62933;
})();
if(cljs.core.truth_(ledger)){
var statearr_62934_62965 = state_62898__$1;
(statearr_62934_62965[(1)] = (9));

} else {
var statearr_62935_62966 = state_62898__$1;
(statearr_62935_62966[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_62936 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62936[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_62936[(1)] = (1));

return statearr_62936;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_62898){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62898);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62937){var ex__2744__auto__ = e62937;
var statearr_62938_62967 = state_62898;
(statearr_62938_62967[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62898[(4)]))){
var statearr_62939_62968 = state_62898;
(statearr_62939_62968[(1)] = cljs.core.first((state_62898[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62969 = state_62898;
state_62898 = G__62969;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_62898){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_62898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62940 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62940[(6)] = c__2763__auto__);

return statearr_62940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__62971 = arguments.length;
switch (G__62971) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63006){
var state_val_63007 = (state_63006[(1)]);
if((state_val_63007 === (1))){
var state_63006__$1 = state_63006;
var statearr_63008_63030 = state_63006__$1;
(statearr_63008_63030[(2)] = null);

(statearr_63008_63030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63007 === (2))){
var _ = (function (){var statearr_63009 = state_63006;
(statearr_63009[(4)] = cljs.core.cons((5),(state_63006[(4)])));

return statearr_63009;
})();
var inst_62980 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63006__$1 = state_63006;
if(cljs.core.truth_(inst_62980)){
var statearr_63010_63031 = state_63006__$1;
(statearr_63010_63031[(1)] = (6));

} else {
var statearr_63011_63032 = state_63006__$1;
(statearr_63011_63032[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63007 === (3))){
var inst_63004 = (state_63006[(2)]);
var state_63006__$1 = state_63006;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63006__$1,inst_63004);
} else {
if((state_val_63007 === (4))){
var inst_62972 = (state_63006[(2)]);
var inst_62973 = cljs.core.clj__GT_js(inst_62972);
var inst_62974 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62973) : reject.call(null,inst_62973));
var state_63006__$1 = state_63006;
var statearr_63013_63033 = state_63006__$1;
(statearr_63013_63033[(2)] = inst_62974);

(statearr_63013_63033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63007 === (5))){
var _ = (function (){var statearr_63014 = state_63006;
(statearr_63014[(4)] = cljs.core.rest((state_63006[(4)])));

return statearr_63014;
})();
var state_63006__$1 = state_63006;
var ex63012 = (state_63006__$1[(2)]);
var statearr_63015_63034 = state_63006__$1;
(statearr_63015_63034[(5)] = ex63012);


var statearr_63016_63035 = state_63006__$1;
(statearr_63016_63035[(1)] = (4));

(statearr_63016_63035[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63007 === (6))){
var state_63006__$1 = state_63006;
var statearr_63017_63036 = state_63006__$1;
(statearr_63017_63036[(2)] = null);

(statearr_63017_63036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63007 === (7))){
var inst_62983 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62984 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62985 = cljs.core.PersistentHashMap.fromArrays(inst_62983,inst_62984);
var inst_62986 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_62985);
var inst_62987 = (function(){throw inst_62986})();
var state_63006__$1 = state_63006;
var statearr_63018_63037 = state_63006__$1;
(statearr_63018_63037[(2)] = inst_62987);

(statearr_63018_63037[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63007 === (8))){
var inst_62989 = (state_63006[(2)]);
var inst_62990 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_62991 = [jwt,expire];
var inst_62992 = cljs.core.PersistentHashMap.fromArrays(inst_62990,inst_62991);
var inst_62993 = fluree.db.util.core.without_nils(inst_62992);
var inst_62994 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62995 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62997 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_62993,inst_62994,null];
var inst_62998 = (new cljs.core.PersistentVector(null,4,(5),inst_62996,inst_62997,null));
var inst_62999 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62995,inst_62998);
var inst_63000 = (function (){var _ = inst_62989;
var data = inst_62993;
var pc = inst_62994;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63019 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63019) : reject.call(null,G__63019));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__63020 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63020) : resolve.call(null,G__63020));

}
});
})();
var inst_63001 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62994,inst_63000);
var _ = (function (){var statearr_63021 = state_63006;
(statearr_63021[(4)] = cljs.core.rest((state_63006[(4)])));

return statearr_63021;
})();
var state_63006__$1 = (function (){var statearr_63022 = state_63006;
(statearr_63022[(7)] = inst_62999);

return statearr_63022;
})();
var statearr_63023_63038 = state_63006__$1;
(statearr_63023_63038[(2)] = inst_63001);

(statearr_63023_63038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2741__auto__ = null;
var fluree$db$connection_js$state_machine__2741__auto____0 = (function (){
var statearr_63024 = [null,null,null,null,null,null,null,null];
(statearr_63024[(0)] = fluree$db$connection_js$state_machine__2741__auto__);

(statearr_63024[(1)] = (1));

return statearr_63024;
});
var fluree$db$connection_js$state_machine__2741__auto____1 = (function (state_63006){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63006);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63025){var ex__2744__auto__ = e63025;
var statearr_63026_63039 = state_63006;
(statearr_63026_63039[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63006[(4)]))){
var statearr_63027_63040 = state_63006;
(statearr_63027_63040[(1)] = cljs.core.first((state_63006[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63041 = state_63006;
state_63006 = G__63041;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2741__auto__ = function(state_63006){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2741__auto____1.call(this,state_63006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2741__auto____0;
fluree$db$connection_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2741__auto____1;
return fluree$db$connection_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63028 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63028[(6)] = c__2763__auto__);

return statearr_63028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

